// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  Uc_D_BFu1c  {
  unsigned char v1;
  double v2;
  unsigned char v3:1;
};
//SIG(1 Uc_D_BFu1c) C1{ Fc FL Fc:1}



static void Test_Uc_D_BFu1c()
{
  {
    init_simple_test("Uc_D_BFu1c");
    static STRUCT_IF_C Uc_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu1c, Uc_D_BFu1c)
//============================================================================


struct  Uc_D_BFu1i  {
  unsigned char v1;
  double v2;
  unsigned int v3:1;
};
//SIG(1 Uc_D_BFu1i) C1{ Fc FL Fi:1}



static void Test_Uc_D_BFu1i()
{
  {
    init_simple_test("Uc_D_BFu1i");
    static STRUCT_IF_C Uc_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu1i, Uc_D_BFu1i)
//============================================================================


struct  Uc_D_BFu1ll  {
  unsigned char v1;
  double v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_D_BFu1ll) C1{ Fc FL FL:1}



static void Test_Uc_D_BFu1ll()
{
  {
    init_simple_test("Uc_D_BFu1ll");
    static STRUCT_IF_C Uc_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu1ll, Uc_D_BFu1ll)
//============================================================================


struct  Uc_D_BFu1s  {
  unsigned char v1;
  double v2;
  unsigned short v3:1;
};
//SIG(1 Uc_D_BFu1s) C1{ Fc FL Fs:1}



static void Test_Uc_D_BFu1s()
{
  {
    init_simple_test("Uc_D_BFu1s");
    static STRUCT_IF_C Uc_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu1s, Uc_D_BFu1s)
//============================================================================


struct  Uc_D_BFu31i  {
  unsigned char v1;
  double v2;
  unsigned int v3:31;
};
//SIG(1 Uc_D_BFu31i) C1{ Fc FL Fi:31}



static void Test_Uc_D_BFu31i()
{
  {
    init_simple_test("Uc_D_BFu31i");
    static STRUCT_IF_C Uc_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Uc_D_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Uc_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu31i, Uc_D_BFu31i)
//============================================================================


struct  Uc_D_BFu31ll  {
  unsigned char v1;
  double v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_D_BFu31ll) C1{ Fc FL FL:31}



static void Test_Uc_D_BFu31ll()
{
  {
    init_simple_test("Uc_D_BFu31ll");
    static STRUCT_IF_C Uc_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Uc_D_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Uc_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu31ll, Uc_D_BFu31ll)
//============================================================================


struct  Uc_D_BFu32i  {
  unsigned char v1;
  double v2;
  unsigned int v3:32;
};
//SIG(1 Uc_D_BFu32i) C1{ Fc FL Fi:32}



static void Test_Uc_D_BFu32i()
{
  {
    init_simple_test("Uc_D_BFu32i");
    static STRUCT_IF_C Uc_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Uc_D_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Uc_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu32i, Uc_D_BFu32i)
//============================================================================


struct  Uc_D_BFu32ll  {
  unsigned char v1;
  double v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_D_BFu32ll) C1{ Fc FL FL:32}



static void Test_Uc_D_BFu32ll()
{
  {
    init_simple_test("Uc_D_BFu32ll");
    static STRUCT_IF_C Uc_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Uc_D_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Uc_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu32ll, Uc_D_BFu32ll)
//============================================================================


struct  Uc_D_BFu33  {
  unsigned char v1;
  double v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_D_BFu33) C1{ Fc FL FL:33}



static void Test_Uc_D_BFu33()
{
  {
    init_simple_test("Uc_D_BFu33");
    static STRUCT_IF_C Uc_D_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Uc_D_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Uc_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu33, Uc_D_BFu33)
//============================================================================


struct  Uc_D_BFu7c  {
  unsigned char v1;
  double v2;
  unsigned char v3:7;
};
//SIG(1 Uc_D_BFu7c) C1{ Fc FL Fc:7}



static void Test_Uc_D_BFu7c()
{
  {
    init_simple_test("Uc_D_BFu7c");
    static STRUCT_IF_C Uc_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_D_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu7c, Uc_D_BFu7c)
//============================================================================


struct  Uc_D_BFu7i  {
  unsigned char v1;
  double v2;
  unsigned int v3:7;
};
//SIG(1 Uc_D_BFu7i) C1{ Fc FL Fi:7}



static void Test_Uc_D_BFu7i()
{
  {
    init_simple_test("Uc_D_BFu7i");
    static STRUCT_IF_C Uc_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_D_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu7i, Uc_D_BFu7i)
//============================================================================


struct  Uc_D_BFu7ll  {
  unsigned char v1;
  double v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_D_BFu7ll) C1{ Fc FL FL:7}



static void Test_Uc_D_BFu7ll()
{
  {
    init_simple_test("Uc_D_BFu7ll");
    static STRUCT_IF_C Uc_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_D_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu7ll, Uc_D_BFu7ll)
//============================================================================


struct  Uc_D_BFu7s  {
  unsigned char v1;
  double v2;
  unsigned short v3:7;
};
//SIG(1 Uc_D_BFu7s) C1{ Fc FL Fs:7}



static void Test_Uc_D_BFu7s()
{
  {
    init_simple_test("Uc_D_BFu7s");
    static STRUCT_IF_C Uc_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_D_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu7s, Uc_D_BFu7s)
//============================================================================


struct  Uc_D_BFu8c  {
  unsigned char v1;
  double v2;
  unsigned char v3:8;
};
//SIG(1 Uc_D_BFu8c) C1{ Fc FL Fc:8}



static void Test_Uc_D_BFu8c()
{
  {
    init_simple_test("Uc_D_BFu8c");
    static STRUCT_IF_C Uc_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_D_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu8c, Uc_D_BFu8c)
//============================================================================


struct  Uc_D_BFu8i  {
  unsigned char v1;
  double v2;
  unsigned int v3:8;
};
//SIG(1 Uc_D_BFu8i) C1{ Fc FL Fi:8}



static void Test_Uc_D_BFu8i()
{
  {
    init_simple_test("Uc_D_BFu8i");
    static STRUCT_IF_C Uc_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_D_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu8i, Uc_D_BFu8i)
//============================================================================


struct  Uc_D_BFu8ll  {
  unsigned char v1;
  double v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_D_BFu8ll) C1{ Fc FL FL:8}



static void Test_Uc_D_BFu8ll()
{
  {
    init_simple_test("Uc_D_BFu8ll");
    static STRUCT_IF_C Uc_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_D_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu8ll, Uc_D_BFu8ll)
//============================================================================


struct  Uc_D_BFu8s  {
  unsigned char v1;
  double v2;
  unsigned short v3:8;
};
//SIG(1 Uc_D_BFu8s) C1{ Fc FL Fs:8}



static void Test_Uc_D_BFu8s()
{
  {
    init_simple_test("Uc_D_BFu8s");
    static STRUCT_IF_C Uc_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_D_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu8s, Uc_D_BFu8s)
//============================================================================


struct  Uc_D_BFu9i  {
  unsigned char v1;
  double v2;
  unsigned int v3:9;
};
//SIG(1 Uc_D_BFu9i) C1{ Fc FL Fi:9}



static void Test_Uc_D_BFu9i()
{
  {
    init_simple_test("Uc_D_BFu9i");
    static STRUCT_IF_C Uc_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_D_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu9i, Uc_D_BFu9i)
//============================================================================


struct  Uc_D_BFu9ll  {
  unsigned char v1;
  double v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_D_BFu9ll) C1{ Fc FL FL:9}



static void Test_Uc_D_BFu9ll()
{
  {
    init_simple_test("Uc_D_BFu9ll");
    static STRUCT_IF_C Uc_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_D_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu9ll, Uc_D_BFu9ll)
//============================================================================


struct  Uc_D_BFu9s  {
  unsigned char v1;
  double v2;
  unsigned short v3:9;
};
//SIG(1 Uc_D_BFu9s) C1{ Fc FL Fs:9}



static void Test_Uc_D_BFu9s()
{
  {
    init_simple_test("Uc_D_BFu9s");
    static STRUCT_IF_C Uc_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_D_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu9s, Uc_D_BFu9s)
//============================================================================


struct  Uc_D_C  {
  unsigned char v1;
  double v2;
  char v3;
};
//SIG(1 Uc_D_C) C1{ Fc FL Fc}



static void Test_Uc_D_C()
{
  {
    init_simple_test("Uc_D_C");
    STRUCT_IF_C Uc_D_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_C)");
    check_field_offset(lv, v1, 0, "Uc_D_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_C, Uc_D_C)
//============================================================================


struct  Uc_D_D  {
  unsigned char v1;
  double v2;
  double v3;
};
//SIG(1 Uc_D_D) C1{ Fc FL[2]}



static void Test_Uc_D_D()
{
  {
    init_simple_test("Uc_D_D");
    STRUCT_IF_C Uc_D_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_D)");
    check_field_offset(lv, v1, 0, "Uc_D_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_D, Uc_D_D)
//============================================================================


struct  Uc_D_F  {
  unsigned char v1;
  double v2;
  float v3;
};
//SIG(1 Uc_D_F) C1{ Fc FL Fi}



static void Test_Uc_D_F()
{
  {
    init_simple_test("Uc_D_F");
    STRUCT_IF_C Uc_D_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_F)");
    check_field_offset(lv, v1, 0, "Uc_D_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_F, Uc_D_F)
//============================================================================


struct  Uc_D_I  {
  unsigned char v1;
  double v2;
  int v3;
};
//SIG(1 Uc_D_I) C1{ Fc FL Fi}



static void Test_Uc_D_I()
{
  {
    init_simple_test("Uc_D_I");
    STRUCT_IF_C Uc_D_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_I)");
    check_field_offset(lv, v1, 0, "Uc_D_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_I, Uc_D_I)
//============================================================================


struct  Uc_D_Ip  {
  unsigned char v1;
  double v2;
  int *v3;
};
//SIG(1 Uc_D_Ip) C1{ Fc FL Fp}



static void Test_Uc_D_Ip()
{
  {
    init_simple_test("Uc_D_Ip");
    STRUCT_IF_C Uc_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_Ip)");
    check_field_offset(lv, v1, 0, "Uc_D_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Ip, Uc_D_Ip)
//============================================================================


struct  Uc_D_L  {
  unsigned char v1;
  double v2;
  __tsi64 v3;
};
//SIG(1 Uc_D_L) C1{ Fc FL[2]}



static void Test_Uc_D_L()
{
  {
    init_simple_test("Uc_D_L");
    STRUCT_IF_C Uc_D_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_L)");
    check_field_offset(lv, v1, 0, "Uc_D_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_L, Uc_D_L)
//============================================================================


struct  Uc_D_S  {
  unsigned char v1;
  double v2;
  short v3;
};
//SIG(1 Uc_D_S) C1{ Fc FL Fs}



static void Test_Uc_D_S()
{
  {
    init_simple_test("Uc_D_S");
    STRUCT_IF_C Uc_D_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_S)");
    check_field_offset(lv, v1, 0, "Uc_D_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_S, Uc_D_S)
//============================================================================


struct  Uc_D_Uc  {
  unsigned char v1;
  double v2;
  unsigned char v3;
};
//SIG(1 Uc_D_Uc) C1{ Fc FL Fc}



static void Test_Uc_D_Uc()
{
  {
    init_simple_test("Uc_D_Uc");
    STRUCT_IF_C Uc_D_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_Uc)");
    check_field_offset(lv, v1, 0, "Uc_D_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Uc, Uc_D_Uc)
//============================================================================


struct  Uc_D_Ui  {
  unsigned char v1;
  double v2;
  unsigned int v3;
};
//SIG(1 Uc_D_Ui) C1{ Fc FL Fi}



static void Test_Uc_D_Ui()
{
  {
    init_simple_test("Uc_D_Ui");
    STRUCT_IF_C Uc_D_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_Ui)");
    check_field_offset(lv, v1, 0, "Uc_D_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Ui, Uc_D_Ui)
//============================================================================


struct  Uc_D_Ul  {
  unsigned char v1;
  double v2;
  __tsu64 v3;
};
//SIG(1 Uc_D_Ul) C1{ Fc FL[2]}



static void Test_Uc_D_Ul()
{
  {
    init_simple_test("Uc_D_Ul");
    STRUCT_IF_C Uc_D_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_Ul)");
    check_field_offset(lv, v1, 0, "Uc_D_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Ul, Uc_D_Ul)
//============================================================================


struct  Uc_D_Us  {
  unsigned char v1;
  double v2;
  unsigned short v3;
};
//SIG(1 Uc_D_Us) C1{ Fc FL Fs}



static void Test_Uc_D_Us()
{
  {
    init_simple_test("Uc_D_Us");
    STRUCT_IF_C Uc_D_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_Us)");
    check_field_offset(lv, v1, 0, "Uc_D_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Us, Uc_D_Us)
//============================================================================


struct  Uc_D_Vp  {
  unsigned char v1;
  double v2;
  void *v3;
};
//SIG(1 Uc_D_Vp) C1{ Fc FL Fp}



static void Test_Uc_D_Vp()
{
  {
    init_simple_test("Uc_D_Vp");
    STRUCT_IF_C Uc_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_Vp)");
    check_field_offset(lv, v1, 0, "Uc_D_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Vp, Uc_D_Vp)
//============================================================================


struct  Uc_F  {
  unsigned char v1;
  float v2;
};
//SIG(1 Uc_F) C1{ Fc Fi}



static void Test_Uc_F()
{
  {
    init_simple_test("Uc_F");
    STRUCT_IF_C Uc_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F)");
    check_field_offset(lv, v1, 0, "Uc_F.v1");
    check_field_offset(lv, v2, 4, "Uc_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F, Uc_F)
//============================================================================


struct  Uc_F_BFu15i  {
  unsigned char v1;
  float v2;
  unsigned int v3:15;
};
//SIG(1 Uc_F_BFu15i) C1{ Fc Fi Fi:15}



static void Test_Uc_F_BFu15i()
{
  {
    init_simple_test("Uc_F_BFu15i");
    static STRUCT_IF_C Uc_F_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu15i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_F_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu15i, Uc_F_BFu15i)
//============================================================================


struct  Uc_F_BFu15ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_F_BFu15ll) C1{ Fc Fi FL:15}



static void Test_Uc_F_BFu15ll()
{
  {
    init_simple_test("Uc_F_BFu15ll");
    static STRUCT_IF_C Uc_F_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_F_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu15ll, Uc_F_BFu15ll)
//============================================================================


struct  Uc_F_BFu15s  {
  unsigned char v1;
  float v2;
  unsigned short v3:15;
};
//SIG(1 Uc_F_BFu15s) C1{ Fc Fi Fs:15}



static void Test_Uc_F_BFu15s()
{
  {
    init_simple_test("Uc_F_BFu15s");
    static STRUCT_IF_C Uc_F_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu15s.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_F_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu15s, Uc_F_BFu15s)
//============================================================================


struct  Uc_F_BFu16i  {
  unsigned char v1;
  float v2;
  unsigned int v3:16;
};
//SIG(1 Uc_F_BFu16i) C1{ Fc Fi Fi:16}



static void Test_Uc_F_BFu16i()
{
  {
    init_simple_test("Uc_F_BFu16i");
    static STRUCT_IF_C Uc_F_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu16i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_F_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu16i, Uc_F_BFu16i)
//============================================================================


struct  Uc_F_BFu16ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_F_BFu16ll) C1{ Fc Fi FL:16}



static void Test_Uc_F_BFu16ll()
{
  {
    init_simple_test("Uc_F_BFu16ll");
    static STRUCT_IF_C Uc_F_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_F_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu16ll, Uc_F_BFu16ll)
//============================================================================


struct  Uc_F_BFu16s  {
  unsigned char v1;
  float v2;
  unsigned short v3:16;
};
//SIG(1 Uc_F_BFu16s) C1{ Fc Fi Fs:16}



static void Test_Uc_F_BFu16s()
{
  {
    init_simple_test("Uc_F_BFu16s");
    static STRUCT_IF_C Uc_F_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu16s.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_F_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu16s, Uc_F_BFu16s)
//============================================================================


struct  Uc_F_BFu17i  {
  unsigned char v1;
  float v2;
  unsigned int v3:17;
};
//SIG(1 Uc_F_BFu17i) C1{ Fc Fi Fi:17}



static void Test_Uc_F_BFu17i()
{
  {
    init_simple_test("Uc_F_BFu17i");
    static STRUCT_IF_C Uc_F_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu17i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Uc_F_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Uc_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu17i, Uc_F_BFu17i)
//============================================================================


struct  Uc_F_BFu17ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_F_BFu17ll) C1{ Fc Fi FL:17}



static void Test_Uc_F_BFu17ll()
{
  {
    init_simple_test("Uc_F_BFu17ll");
    static STRUCT_IF_C Uc_F_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Uc_F_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Uc_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu17ll, Uc_F_BFu17ll)
//============================================================================


struct  Uc_F_BFu1c  {
  unsigned char v1;
  float v2;
  unsigned char v3:1;
};
//SIG(1 Uc_F_BFu1c) C1{ Fc Fi Fc:1}



static void Test_Uc_F_BFu1c()
{
  {
    init_simple_test("Uc_F_BFu1c");
    static STRUCT_IF_C Uc_F_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu1c.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu1c, Uc_F_BFu1c)
//============================================================================


struct  Uc_F_BFu1i  {
  unsigned char v1;
  float v2;
  unsigned int v3:1;
};
//SIG(1 Uc_F_BFu1i) C1{ Fc Fi Fi:1}



static void Test_Uc_F_BFu1i()
{
  {
    init_simple_test("Uc_F_BFu1i");
    static STRUCT_IF_C Uc_F_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu1i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu1i, Uc_F_BFu1i)
//============================================================================


struct  Uc_F_BFu1ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_F_BFu1ll) C1{ Fc Fi FL:1}



static void Test_Uc_F_BFu1ll()
{
  {
    init_simple_test("Uc_F_BFu1ll");
    static STRUCT_IF_C Uc_F_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu1ll, Uc_F_BFu1ll)
//============================================================================


struct  Uc_F_BFu1s  {
  unsigned char v1;
  float v2;
  unsigned short v3:1;
};
//SIG(1 Uc_F_BFu1s) C1{ Fc Fi Fs:1}



static void Test_Uc_F_BFu1s()
{
  {
    init_simple_test("Uc_F_BFu1s");
    static STRUCT_IF_C Uc_F_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu1s.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu1s, Uc_F_BFu1s)
//============================================================================


struct  Uc_F_BFu31i  {
  unsigned char v1;
  float v2;
  unsigned int v3:31;
};
//SIG(1 Uc_F_BFu31i) C1{ Fc Fi Fi:31}



static void Test_Uc_F_BFu31i()
{
  {
    init_simple_test("Uc_F_BFu31i");
    static STRUCT_IF_C Uc_F_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu31i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Uc_F_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Uc_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu31i, Uc_F_BFu31i)
//============================================================================


struct  Uc_F_BFu31ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_F_BFu31ll) C1{ Fc Fi FL:31}



static void Test_Uc_F_BFu31ll()
{
  {
    init_simple_test("Uc_F_BFu31ll");
    static STRUCT_IF_C Uc_F_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Uc_F_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Uc_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu31ll, Uc_F_BFu31ll)
//============================================================================


struct  Uc_F_BFu32i  {
  unsigned char v1;
  float v2;
  unsigned int v3:32;
};
//SIG(1 Uc_F_BFu32i) C1{ Fc Fi Fi:32}



static void Test_Uc_F_BFu32i()
{
  {
    init_simple_test("Uc_F_BFu32i");
    static STRUCT_IF_C Uc_F_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu32i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Uc_F_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Uc_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu32i, Uc_F_BFu32i)
//============================================================================


struct  Uc_F_BFu32ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_F_BFu32ll) C1{ Fc Fi FL:32}



static void Test_Uc_F_BFu32ll()
{
  {
    init_simple_test("Uc_F_BFu32ll");
    static STRUCT_IF_C Uc_F_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Uc_F_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Uc_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu32ll, Uc_F_BFu32ll)
//============================================================================


struct  Uc_F_BFu33  {
  unsigned char v1;
  float v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_F_BFu33) C1{ Fc Fi FL:33}



static void Test_Uc_F_BFu33()
{
  {
    init_simple_test("Uc_F_BFu33");
    static STRUCT_IF_C Uc_F_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Uc_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu33.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "Uc_F_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "Uc_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu33, Uc_F_BFu33)
//============================================================================


struct  Uc_F_BFu7c  {
  unsigned char v1;
  float v2;
  unsigned char v3:7;
};
//SIG(1 Uc_F_BFu7c) C1{ Fc Fi Fc:7}



static void Test_Uc_F_BFu7c()
{
  {
    init_simple_test("Uc_F_BFu7c");
    static STRUCT_IF_C Uc_F_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu7c.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_F_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu7c, Uc_F_BFu7c)
//============================================================================


struct  Uc_F_BFu7i  {
  unsigned char v1;
  float v2;
  unsigned int v3:7;
};
//SIG(1 Uc_F_BFu7i) C1{ Fc Fi Fi:7}



static void Test_Uc_F_BFu7i()
{
  {
    init_simple_test("Uc_F_BFu7i");
    static STRUCT_IF_C Uc_F_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu7i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_F_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu7i, Uc_F_BFu7i)
//============================================================================


struct  Uc_F_BFu7ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_F_BFu7ll) C1{ Fc Fi FL:7}



static void Test_Uc_F_BFu7ll()
{
  {
    init_simple_test("Uc_F_BFu7ll");
    static STRUCT_IF_C Uc_F_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_F_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu7ll, Uc_F_BFu7ll)
//============================================================================


struct  Uc_F_BFu7s  {
  unsigned char v1;
  float v2;
  unsigned short v3:7;
};
//SIG(1 Uc_F_BFu7s) C1{ Fc Fi Fs:7}



static void Test_Uc_F_BFu7s()
{
  {
    init_simple_test("Uc_F_BFu7s");
    static STRUCT_IF_C Uc_F_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu7s.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_F_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu7s, Uc_F_BFu7s)
//============================================================================


struct  Uc_F_BFu8c  {
  unsigned char v1;
  float v2;
  unsigned char v3:8;
};
//SIG(1 Uc_F_BFu8c) C1{ Fc Fi Fc:8}



static void Test_Uc_F_BFu8c()
{
  {
    init_simple_test("Uc_F_BFu8c");
    static STRUCT_IF_C Uc_F_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu8c.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_F_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu8c, Uc_F_BFu8c)
//============================================================================


struct  Uc_F_BFu8i  {
  unsigned char v1;
  float v2;
  unsigned int v3:8;
};
//SIG(1 Uc_F_BFu8i) C1{ Fc Fi Fi:8}



static void Test_Uc_F_BFu8i()
{
  {
    init_simple_test("Uc_F_BFu8i");
    static STRUCT_IF_C Uc_F_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu8i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_F_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu8i, Uc_F_BFu8i)
//============================================================================


struct  Uc_F_BFu8ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_F_BFu8ll) C1{ Fc Fi FL:8}



static void Test_Uc_F_BFu8ll()
{
  {
    init_simple_test("Uc_F_BFu8ll");
    static STRUCT_IF_C Uc_F_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_F_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu8ll, Uc_F_BFu8ll)
//============================================================================


struct  Uc_F_BFu8s  {
  unsigned char v1;
  float v2;
  unsigned short v3:8;
};
//SIG(1 Uc_F_BFu8s) C1{ Fc Fi Fs:8}



static void Test_Uc_F_BFu8s()
{
  {
    init_simple_test("Uc_F_BFu8s");
    static STRUCT_IF_C Uc_F_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu8s.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_F_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu8s, Uc_F_BFu8s)
//============================================================================


struct  Uc_F_BFu9i  {
  unsigned char v1;
  float v2;
  unsigned int v3:9;
};
//SIG(1 Uc_F_BFu9i) C1{ Fc Fi Fi:9}



static void Test_Uc_F_BFu9i()
{
  {
    init_simple_test("Uc_F_BFu9i");
    static STRUCT_IF_C Uc_F_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu9i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_F_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu9i, Uc_F_BFu9i)
//============================================================================


struct  Uc_F_BFu9ll  {
  unsigned char v1;
  float v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_F_BFu9ll) C1{ Fc Fi FL:9}



static void Test_Uc_F_BFu9ll()
{
  {
    init_simple_test("Uc_F_BFu9ll");
    static STRUCT_IF_C Uc_F_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_F_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu9ll, Uc_F_BFu9ll)
//============================================================================


struct  Uc_F_BFu9s  {
  unsigned char v1;
  float v2;
  unsigned short v3:9;
};
//SIG(1 Uc_F_BFu9s) C1{ Fc Fi Fs:9}



static void Test_Uc_F_BFu9s()
{
  {
    init_simple_test("Uc_F_BFu9s");
    static STRUCT_IF_C Uc_F_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu9s.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_F_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu9s, Uc_F_BFu9s)
//============================================================================


struct  Uc_F_C  {
  unsigned char v1;
  float v2;
  char v3;
};
//SIG(1 Uc_F_C) C1{ Fc Fi Fc}



static void Test_Uc_F_C()
{
  {
    init_simple_test("Uc_F_C");
    STRUCT_IF_C Uc_F_C lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_C)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_C)");
    check_field_offset(lv, v1, 0, "Uc_F_C.v1");
    check_field_offset(lv, v2, 4, "Uc_F_C.v2");
    check_field_offset(lv, v3, 8, "Uc_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_C, Uc_F_C)
//============================================================================


struct  Uc_F_D  {
  unsigned char v1;
  float v2;
  double v3;
};
//SIG(1 Uc_F_D) C1{ Fc Fi FL}



static void Test_Uc_F_D()
{
  {
    init_simple_test("Uc_F_D");
    STRUCT_IF_C Uc_F_D lv;
    check2(sizeof(lv), 16, "sizeof(Uc_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_D)");
    check_field_offset(lv, v1, 0, "Uc_F_D.v1");
    check_field_offset(lv, v2, 4, "Uc_F_D.v2");
    check_field_offset(lv, v3, 8, "Uc_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_D, Uc_F_D)
//============================================================================


struct  Uc_F_F  {
  unsigned char v1;
  float v2;
  float v3;
};
//SIG(1 Uc_F_F) C1{ Fc Fi[2]}



static void Test_Uc_F_F()
{
  {
    init_simple_test("Uc_F_F");
    STRUCT_IF_C Uc_F_F lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_F)");
    check_field_offset(lv, v1, 0, "Uc_F_F.v1");
    check_field_offset(lv, v2, 4, "Uc_F_F.v2");
    check_field_offset(lv, v3, 8, "Uc_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_F, Uc_F_F)
//============================================================================


struct  Uc_F_I  {
  unsigned char v1;
  float v2;
  int v3;
};
//SIG(1 Uc_F_I) C1{ Fc Fi[2]}



static void Test_Uc_F_I()
{
  {
    init_simple_test("Uc_F_I");
    STRUCT_IF_C Uc_F_I lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_I)");
    check_field_offset(lv, v1, 0, "Uc_F_I.v1");
    check_field_offset(lv, v2, 4, "Uc_F_I.v2");
    check_field_offset(lv, v3, 8, "Uc_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_I, Uc_F_I)
//============================================================================


struct  Uc_F_Ip  {
  unsigned char v1;
  float v2;
  int *v3;
};
//SIG(1 Uc_F_Ip) C1{ Fc Fi Fp}



static void Test_Uc_F_Ip()
{
  {
    init_simple_test("Uc_F_Ip");
    STRUCT_IF_C Uc_F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_Ip)");
    check_field_offset(lv, v1, 0, "Uc_F_Ip.v1");
    check_field_offset(lv, v2, 4, "Uc_F_Ip.v2");
    check_field_offset(lv, v3, 8, "Uc_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Ip, Uc_F_Ip)
//============================================================================


struct  Uc_F_L  {
  unsigned char v1;
  float v2;
  __tsi64 v3;
};
//SIG(1 Uc_F_L) C1{ Fc Fi FL}



static void Test_Uc_F_L()
{
  {
    init_simple_test("Uc_F_L");
    STRUCT_IF_C Uc_F_L lv;
    check2(sizeof(lv), 16, "sizeof(Uc_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_L)");
    check_field_offset(lv, v1, 0, "Uc_F_L.v1");
    check_field_offset(lv, v2, 4, "Uc_F_L.v2");
    check_field_offset(lv, v3, 8, "Uc_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_L, Uc_F_L)
//============================================================================


struct  Uc_F_S  {
  unsigned char v1;
  float v2;
  short v3;
};
//SIG(1 Uc_F_S) C1{ Fc Fi Fs}



static void Test_Uc_F_S()
{
  {
    init_simple_test("Uc_F_S");
    STRUCT_IF_C Uc_F_S lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_S)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_S)");
    check_field_offset(lv, v1, 0, "Uc_F_S.v1");
    check_field_offset(lv, v2, 4, "Uc_F_S.v2");
    check_field_offset(lv, v3, 8, "Uc_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_S, Uc_F_S)
//============================================================================


struct  Uc_F_Uc  {
  unsigned char v1;
  float v2;
  unsigned char v3;
};
//SIG(1 Uc_F_Uc) C1{ Fc Fi Fc}



static void Test_Uc_F_Uc()
{
  {
    init_simple_test("Uc_F_Uc");
    STRUCT_IF_C Uc_F_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_Uc)");
    check_field_offset(lv, v1, 0, "Uc_F_Uc.v1");
    check_field_offset(lv, v2, 4, "Uc_F_Uc.v2");
    check_field_offset(lv, v3, 8, "Uc_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Uc, Uc_F_Uc)
//============================================================================


struct  Uc_F_Ui  {
  unsigned char v1;
  float v2;
  unsigned int v3;
};
//SIG(1 Uc_F_Ui) C1{ Fc Fi[2]}



static void Test_Uc_F_Ui()
{
  {
    init_simple_test("Uc_F_Ui");
    STRUCT_IF_C Uc_F_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_Ui)");
    check_field_offset(lv, v1, 0, "Uc_F_Ui.v1");
    check_field_offset(lv, v2, 4, "Uc_F_Ui.v2");
    check_field_offset(lv, v3, 8, "Uc_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Ui, Uc_F_Ui)
//============================================================================


struct  Uc_F_Ul  {
  unsigned char v1;
  float v2;
  __tsu64 v3;
};
//SIG(1 Uc_F_Ul) C1{ Fc Fi FL}



static void Test_Uc_F_Ul()
{
  {
    init_simple_test("Uc_F_Ul");
    STRUCT_IF_C Uc_F_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Uc_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_Ul)");
    check_field_offset(lv, v1, 0, "Uc_F_Ul.v1");
    check_field_offset(lv, v2, 4, "Uc_F_Ul.v2");
    check_field_offset(lv, v3, 8, "Uc_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Ul, Uc_F_Ul)
//============================================================================


struct  Uc_F_Us  {
  unsigned char v1;
  float v2;
  unsigned short v3;
};
//SIG(1 Uc_F_Us) C1{ Fc Fi Fs}



static void Test_Uc_F_Us()
{
  {
    init_simple_test("Uc_F_Us");
    STRUCT_IF_C Uc_F_Us lv;
    check2(sizeof(lv), 12, "sizeof(Uc_F_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_Us)");
    check_field_offset(lv, v1, 0, "Uc_F_Us.v1");
    check_field_offset(lv, v2, 4, "Uc_F_Us.v2");
    check_field_offset(lv, v3, 8, "Uc_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Us, Uc_F_Us)
//============================================================================


struct  Uc_F_Vp  {
  unsigned char v1;
  float v2;
  void *v3;
};
//SIG(1 Uc_F_Vp) C1{ Fc Fi Fp}



static void Test_Uc_F_Vp()
{
  {
    init_simple_test("Uc_F_Vp");
    STRUCT_IF_C Uc_F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_F_Vp)");
    check_field_offset(lv, v1, 0, "Uc_F_Vp.v1");
    check_field_offset(lv, v2, 4, "Uc_F_Vp.v2");
    check_field_offset(lv, v3, 8, "Uc_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Vp, Uc_F_Vp)
//============================================================================


struct  Uc_I  {
  unsigned char v1;
  int v2;
};
//SIG(1 Uc_I) C1{ Fc Fi}



static void Test_Uc_I()
{
  {
    init_simple_test("Uc_I");
    STRUCT_IF_C Uc_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I)");
    check_field_offset(lv, v1, 0, "Uc_I.v1");
    check_field_offset(lv, v2, 4, "Uc_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I, Uc_I)
//============================================================================


struct  Uc_I_BFu15i  {
  unsigned char v1;
  int v2;
  unsigned int v3:15;
};
//SIG(1 Uc_I_BFu15i) C1{ Fc Fi Fi:15}



static void Test_Uc_I_BFu15i()
{
  {
    init_simple_test("Uc_I_BFu15i");
    static STRUCT_IF_C Uc_I_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu15i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_I_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu15i, Uc_I_BFu15i)
//============================================================================


struct  Uc_I_BFu15ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_I_BFu15ll) C1{ Fc Fi FL:15}



static void Test_Uc_I_BFu15ll()
{
  {
    init_simple_test("Uc_I_BFu15ll");
    static STRUCT_IF_C Uc_I_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_I_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu15ll, Uc_I_BFu15ll)
//============================================================================


struct  Uc_I_BFu15s  {
  unsigned char v1;
  int v2;
  unsigned short v3:15;
};
//SIG(1 Uc_I_BFu15s) C1{ Fc Fi Fs:15}



static void Test_Uc_I_BFu15s()
{
  {
    init_simple_test("Uc_I_BFu15s");
    static STRUCT_IF_C Uc_I_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu15s.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_I_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu15s, Uc_I_BFu15s)
//============================================================================


struct  Uc_I_BFu16i  {
  unsigned char v1;
  int v2;
  unsigned int v3:16;
};
//SIG(1 Uc_I_BFu16i) C1{ Fc Fi Fi:16}



static void Test_Uc_I_BFu16i()
{
  {
    init_simple_test("Uc_I_BFu16i");
    static STRUCT_IF_C Uc_I_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu16i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_I_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu16i, Uc_I_BFu16i)
//============================================================================


struct  Uc_I_BFu16ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_I_BFu16ll) C1{ Fc Fi FL:16}



static void Test_Uc_I_BFu16ll()
{
  {
    init_simple_test("Uc_I_BFu16ll");
    static STRUCT_IF_C Uc_I_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_I_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu16ll, Uc_I_BFu16ll)
//============================================================================


struct  Uc_I_BFu16s  {
  unsigned char v1;
  int v2;
  unsigned short v3:16;
};
//SIG(1 Uc_I_BFu16s) C1{ Fc Fi Fs:16}



static void Test_Uc_I_BFu16s()
{
  {
    init_simple_test("Uc_I_BFu16s");
    static STRUCT_IF_C Uc_I_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu16s.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_I_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu16s, Uc_I_BFu16s)
//============================================================================


struct  Uc_I_BFu17i  {
  unsigned char v1;
  int v2;
  unsigned int v3:17;
};
//SIG(1 Uc_I_BFu17i) C1{ Fc Fi Fi:17}



static void Test_Uc_I_BFu17i()
{
  {
    init_simple_test("Uc_I_BFu17i");
    static STRUCT_IF_C Uc_I_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu17i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Uc_I_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Uc_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu17i, Uc_I_BFu17i)
//============================================================================


struct  Uc_I_BFu17ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_I_BFu17ll) C1{ Fc Fi FL:17}



static void Test_Uc_I_BFu17ll()
{
  {
    init_simple_test("Uc_I_BFu17ll");
    static STRUCT_IF_C Uc_I_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Uc_I_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Uc_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu17ll, Uc_I_BFu17ll)
//============================================================================


struct  Uc_I_BFu1c  {
  unsigned char v1;
  int v2;
  unsigned char v3:1;
};
//SIG(1 Uc_I_BFu1c) C1{ Fc Fi Fc:1}



static void Test_Uc_I_BFu1c()
{
  {
    init_simple_test("Uc_I_BFu1c");
    static STRUCT_IF_C Uc_I_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu1c.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu1c, Uc_I_BFu1c)
//============================================================================


struct  Uc_I_BFu1i  {
  unsigned char v1;
  int v2;
  unsigned int v3:1;
};
//SIG(1 Uc_I_BFu1i) C1{ Fc Fi Fi:1}



static void Test_Uc_I_BFu1i()
{
  {
    init_simple_test("Uc_I_BFu1i");
    static STRUCT_IF_C Uc_I_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu1i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu1i, Uc_I_BFu1i)
//============================================================================


struct  Uc_I_BFu1ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_I_BFu1ll) C1{ Fc Fi FL:1}



static void Test_Uc_I_BFu1ll()
{
  {
    init_simple_test("Uc_I_BFu1ll");
    static STRUCT_IF_C Uc_I_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu1ll, Uc_I_BFu1ll)
//============================================================================


struct  Uc_I_BFu1s  {
  unsigned char v1;
  int v2;
  unsigned short v3:1;
};
//SIG(1 Uc_I_BFu1s) C1{ Fc Fi Fs:1}



static void Test_Uc_I_BFu1s()
{
  {
    init_simple_test("Uc_I_BFu1s");
    static STRUCT_IF_C Uc_I_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu1s.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu1s, Uc_I_BFu1s)
//============================================================================


struct  Uc_I_BFu31i  {
  unsigned char v1;
  int v2;
  unsigned int v3:31;
};
//SIG(1 Uc_I_BFu31i) C1{ Fc Fi Fi:31}



static void Test_Uc_I_BFu31i()
{
  {
    init_simple_test("Uc_I_BFu31i");
    static STRUCT_IF_C Uc_I_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu31i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Uc_I_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Uc_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu31i, Uc_I_BFu31i)
//============================================================================


struct  Uc_I_BFu31ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_I_BFu31ll) C1{ Fc Fi FL:31}



static void Test_Uc_I_BFu31ll()
{
  {
    init_simple_test("Uc_I_BFu31ll");
    static STRUCT_IF_C Uc_I_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Uc_I_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Uc_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu31ll, Uc_I_BFu31ll)
//============================================================================


struct  Uc_I_BFu32i  {
  unsigned char v1;
  int v2;
  unsigned int v3:32;
};
//SIG(1 Uc_I_BFu32i) C1{ Fc Fi Fi:32}



static void Test_Uc_I_BFu32i()
{
  {
    init_simple_test("Uc_I_BFu32i");
    static STRUCT_IF_C Uc_I_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu32i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Uc_I_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Uc_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu32i, Uc_I_BFu32i)
//============================================================================


struct  Uc_I_BFu32ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_I_BFu32ll) C1{ Fc Fi FL:32}



static void Test_Uc_I_BFu32ll()
{
  {
    init_simple_test("Uc_I_BFu32ll");
    static STRUCT_IF_C Uc_I_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Uc_I_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Uc_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu32ll, Uc_I_BFu32ll)
//============================================================================


struct  Uc_I_BFu33  {
  unsigned char v1;
  int v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_I_BFu33) C1{ Fc Fi FL:33}



static void Test_Uc_I_BFu33()
{
  {
    init_simple_test("Uc_I_BFu33");
    static STRUCT_IF_C Uc_I_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Uc_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu33.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "Uc_I_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "Uc_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu33, Uc_I_BFu33)
//============================================================================


struct  Uc_I_BFu7c  {
  unsigned char v1;
  int v2;
  unsigned char v3:7;
};
//SIG(1 Uc_I_BFu7c) C1{ Fc Fi Fc:7}



static void Test_Uc_I_BFu7c()
{
  {
    init_simple_test("Uc_I_BFu7c");
    static STRUCT_IF_C Uc_I_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu7c.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_I_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu7c, Uc_I_BFu7c)
//============================================================================


struct  Uc_I_BFu7i  {
  unsigned char v1;
  int v2;
  unsigned int v3:7;
};
//SIG(1 Uc_I_BFu7i) C1{ Fc Fi Fi:7}



static void Test_Uc_I_BFu7i()
{
  {
    init_simple_test("Uc_I_BFu7i");
    static STRUCT_IF_C Uc_I_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu7i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_I_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu7i, Uc_I_BFu7i)
//============================================================================


struct  Uc_I_BFu7ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_I_BFu7ll) C1{ Fc Fi FL:7}



static void Test_Uc_I_BFu7ll()
{
  {
    init_simple_test("Uc_I_BFu7ll");
    static STRUCT_IF_C Uc_I_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_I_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu7ll, Uc_I_BFu7ll)
//============================================================================


struct  Uc_I_BFu7s  {
  unsigned char v1;
  int v2;
  unsigned short v3:7;
};
//SIG(1 Uc_I_BFu7s) C1{ Fc Fi Fs:7}



static void Test_Uc_I_BFu7s()
{
  {
    init_simple_test("Uc_I_BFu7s");
    static STRUCT_IF_C Uc_I_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu7s.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_I_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu7s, Uc_I_BFu7s)
//============================================================================


struct  Uc_I_BFu8c  {
  unsigned char v1;
  int v2;
  unsigned char v3:8;
};
//SIG(1 Uc_I_BFu8c) C1{ Fc Fi Fc:8}



static void Test_Uc_I_BFu8c()
{
  {
    init_simple_test("Uc_I_BFu8c");
    static STRUCT_IF_C Uc_I_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu8c.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_I_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu8c, Uc_I_BFu8c)
//============================================================================


struct  Uc_I_BFu8i  {
  unsigned char v1;
  int v2;
  unsigned int v3:8;
};
//SIG(1 Uc_I_BFu8i) C1{ Fc Fi Fi:8}



static void Test_Uc_I_BFu8i()
{
  {
    init_simple_test("Uc_I_BFu8i");
    static STRUCT_IF_C Uc_I_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu8i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_I_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu8i, Uc_I_BFu8i)
//============================================================================


struct  Uc_I_BFu8ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_I_BFu8ll) C1{ Fc Fi FL:8}



static void Test_Uc_I_BFu8ll()
{
  {
    init_simple_test("Uc_I_BFu8ll");
    static STRUCT_IF_C Uc_I_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_I_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu8ll, Uc_I_BFu8ll)
//============================================================================


struct  Uc_I_BFu8s  {
  unsigned char v1;
  int v2;
  unsigned short v3:8;
};
//SIG(1 Uc_I_BFu8s) C1{ Fc Fi Fs:8}



static void Test_Uc_I_BFu8s()
{
  {
    init_simple_test("Uc_I_BFu8s");
    static STRUCT_IF_C Uc_I_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu8s.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_I_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu8s, Uc_I_BFu8s)
//============================================================================


struct  Uc_I_BFu9i  {
  unsigned char v1;
  int v2;
  unsigned int v3:9;
};
//SIG(1 Uc_I_BFu9i) C1{ Fc Fi Fi:9}



static void Test_Uc_I_BFu9i()
{
  {
    init_simple_test("Uc_I_BFu9i");
    static STRUCT_IF_C Uc_I_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu9i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_I_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu9i, Uc_I_BFu9i)
//============================================================================


struct  Uc_I_BFu9ll  {
  unsigned char v1;
  int v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_I_BFu9ll) C1{ Fc Fi FL:9}



static void Test_Uc_I_BFu9ll()
{
  {
    init_simple_test("Uc_I_BFu9ll");
    static STRUCT_IF_C Uc_I_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_I_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu9ll, Uc_I_BFu9ll)
//============================================================================


struct  Uc_I_BFu9s  {
  unsigned char v1;
  int v2;
  unsigned short v3:9;
};
//SIG(1 Uc_I_BFu9s) C1{ Fc Fi Fs:9}



static void Test_Uc_I_BFu9s()
{
  {
    init_simple_test("Uc_I_BFu9s");
    static STRUCT_IF_C Uc_I_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu9s.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_I_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu9s, Uc_I_BFu9s)
//============================================================================


struct  Uc_I_C  {
  unsigned char v1;
  int v2;
  char v3;
};
//SIG(1 Uc_I_C) C1{ Fc Fi Fc}



static void Test_Uc_I_C()
{
  {
    init_simple_test("Uc_I_C");
    STRUCT_IF_C Uc_I_C lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_C)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_C)");
    check_field_offset(lv, v1, 0, "Uc_I_C.v1");
    check_field_offset(lv, v2, 4, "Uc_I_C.v2");
    check_field_offset(lv, v3, 8, "Uc_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_C, Uc_I_C)
//============================================================================


struct  Uc_I_D  {
  unsigned char v1;
  int v2;
  double v3;
};
//SIG(1 Uc_I_D) C1{ Fc Fi FL}



static void Test_Uc_I_D()
{
  {
    init_simple_test("Uc_I_D");
    STRUCT_IF_C Uc_I_D lv;
    check2(sizeof(lv), 16, "sizeof(Uc_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_D)");
    check_field_offset(lv, v1, 0, "Uc_I_D.v1");
    check_field_offset(lv, v2, 4, "Uc_I_D.v2");
    check_field_offset(lv, v3, 8, "Uc_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_D, Uc_I_D)
//============================================================================


struct  Uc_I_F  {
  unsigned char v1;
  int v2;
  float v3;
};
//SIG(1 Uc_I_F) C1{ Fc Fi[2]}



static void Test_Uc_I_F()
{
  {
    init_simple_test("Uc_I_F");
    STRUCT_IF_C Uc_I_F lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_F)");
    check_field_offset(lv, v1, 0, "Uc_I_F.v1");
    check_field_offset(lv, v2, 4, "Uc_I_F.v2");
    check_field_offset(lv, v3, 8, "Uc_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_F, Uc_I_F)
//============================================================================


struct  Uc_I_I  {
  unsigned char v1;
  int v2;
  int v3;
};
//SIG(1 Uc_I_I) C1{ Fc Fi[2]}



static void Test_Uc_I_I()
{
  {
    init_simple_test("Uc_I_I");
    STRUCT_IF_C Uc_I_I lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_I)");
    check_field_offset(lv, v1, 0, "Uc_I_I.v1");
    check_field_offset(lv, v2, 4, "Uc_I_I.v2");
    check_field_offset(lv, v3, 8, "Uc_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_I, Uc_I_I)
//============================================================================


struct  Uc_I_Ip  {
  unsigned char v1;
  int v2;
  int *v3;
};
//SIG(1 Uc_I_Ip) C1{ Fc Fi Fp}



static void Test_Uc_I_Ip()
{
  {
    init_simple_test("Uc_I_Ip");
    STRUCT_IF_C Uc_I_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_Ip)");
    check_field_offset(lv, v1, 0, "Uc_I_Ip.v1");
    check_field_offset(lv, v2, 4, "Uc_I_Ip.v2");
    check_field_offset(lv, v3, 8, "Uc_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Ip, Uc_I_Ip)
//============================================================================


struct  Uc_I_L  {
  unsigned char v1;
  int v2;
  __tsi64 v3;
};
//SIG(1 Uc_I_L) C1{ Fc Fi FL}



static void Test_Uc_I_L()
{
  {
    init_simple_test("Uc_I_L");
    STRUCT_IF_C Uc_I_L lv;
    check2(sizeof(lv), 16, "sizeof(Uc_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_L)");
    check_field_offset(lv, v1, 0, "Uc_I_L.v1");
    check_field_offset(lv, v2, 4, "Uc_I_L.v2");
    check_field_offset(lv, v3, 8, "Uc_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_L, Uc_I_L)
//============================================================================


struct  Uc_I_S  {
  unsigned char v1;
  int v2;
  short v3;
};
//SIG(1 Uc_I_S) C1{ Fc Fi Fs}



static void Test_Uc_I_S()
{
  {
    init_simple_test("Uc_I_S");
    STRUCT_IF_C Uc_I_S lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_S)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_S)");
    check_field_offset(lv, v1, 0, "Uc_I_S.v1");
    check_field_offset(lv, v2, 4, "Uc_I_S.v2");
    check_field_offset(lv, v3, 8, "Uc_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_S, Uc_I_S)
//============================================================================


struct  Uc_I_Uc  {
  unsigned char v1;
  int v2;
  unsigned char v3;
};
//SIG(1 Uc_I_Uc) C1{ Fc Fi Fc}



static void Test_Uc_I_Uc()
{
  {
    init_simple_test("Uc_I_Uc");
    STRUCT_IF_C Uc_I_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_Uc)");
    check_field_offset(lv, v1, 0, "Uc_I_Uc.v1");
    check_field_offset(lv, v2, 4, "Uc_I_Uc.v2");
    check_field_offset(lv, v3, 8, "Uc_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Uc, Uc_I_Uc)
//============================================================================


struct  Uc_I_Ui  {
  unsigned char v1;
  int v2;
  unsigned int v3;
};
//SIG(1 Uc_I_Ui) C1{ Fc Fi[2]}



static void Test_Uc_I_Ui()
{
  {
    init_simple_test("Uc_I_Ui");
    STRUCT_IF_C Uc_I_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_Ui)");
    check_field_offset(lv, v1, 0, "Uc_I_Ui.v1");
    check_field_offset(lv, v2, 4, "Uc_I_Ui.v2");
    check_field_offset(lv, v3, 8, "Uc_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Ui, Uc_I_Ui)
//============================================================================


struct  Uc_I_Ul  {
  unsigned char v1;
  int v2;
  __tsu64 v3;
};
//SIG(1 Uc_I_Ul) C1{ Fc Fi FL}



static void Test_Uc_I_Ul()
{
  {
    init_simple_test("Uc_I_Ul");
    STRUCT_IF_C Uc_I_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Uc_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_Ul)");
    check_field_offset(lv, v1, 0, "Uc_I_Ul.v1");
    check_field_offset(lv, v2, 4, "Uc_I_Ul.v2");
    check_field_offset(lv, v3, 8, "Uc_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Ul, Uc_I_Ul)
//============================================================================


struct  Uc_I_Us  {
  unsigned char v1;
  int v2;
  unsigned short v3;
};
//SIG(1 Uc_I_Us) C1{ Fc Fi Fs}



static void Test_Uc_I_Us()
{
  {
    init_simple_test("Uc_I_Us");
    STRUCT_IF_C Uc_I_Us lv;
    check2(sizeof(lv), 12, "sizeof(Uc_I_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_Us)");
    check_field_offset(lv, v1, 0, "Uc_I_Us.v1");
    check_field_offset(lv, v2, 4, "Uc_I_Us.v2");
    check_field_offset(lv, v3, 8, "Uc_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Us, Uc_I_Us)
//============================================================================


struct  Uc_I_Vp  {
  unsigned char v1;
  int v2;
  void *v3;
};
//SIG(1 Uc_I_Vp) C1{ Fc Fi Fp}



static void Test_Uc_I_Vp()
{
  {
    init_simple_test("Uc_I_Vp");
    STRUCT_IF_C Uc_I_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_I_Vp)");
    check_field_offset(lv, v1, 0, "Uc_I_Vp.v1");
    check_field_offset(lv, v2, 4, "Uc_I_Vp.v2");
    check_field_offset(lv, v3, 8, "Uc_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Vp, Uc_I_Vp)
//============================================================================


struct  Uc_Ip  {
  unsigned char v1;
  int *v2;
};
//SIG(1 Uc_Ip) C1{ Fc Fp}



static void Test_Uc_Ip()
{
  {
    init_simple_test("Uc_Ip");
    STRUCT_IF_C Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip, Uc_Ip)
//============================================================================


struct  Uc_Ip_BFu15i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:15;
};
//SIG(1 Uc_Ip_BFu15i) C1{ Fc Fp Fi:15}



static void Test_Uc_Ip_BFu15i()
{
  {
    init_simple_test("Uc_Ip_BFu15i");
    static STRUCT_IF_C Uc_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "Uc_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "Uc_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu15i, Uc_Ip_BFu15i)
//============================================================================


struct  Uc_Ip_BFu15ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_Ip_BFu15ll) C1{ Fc Fp FL:15}



static void Test_Uc_Ip_BFu15ll()
{
  {
    init_simple_test("Uc_Ip_BFu15ll");
    static STRUCT_IF_C Uc_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "Uc_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "Uc_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu15ll, Uc_Ip_BFu15ll)
//============================================================================


struct  Uc_Ip_BFu15s  {
  unsigned char v1;
  int *v2;
  unsigned short v3:15;
};
//SIG(1 Uc_Ip_BFu15s) C1{ Fc Fp Fs:15}



static void Test_Uc_Ip_BFu15s()
{
  {
    init_simple_test("Uc_Ip_BFu15s");
    static STRUCT_IF_C Uc_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "Uc_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "Uc_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu15s, Uc_Ip_BFu15s)
//============================================================================


struct  Uc_Ip_BFu16i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:16;
};
//SIG(1 Uc_Ip_BFu16i) C1{ Fc Fp Fi:16}



static void Test_Uc_Ip_BFu16i()
{
  {
    init_simple_test("Uc_Ip_BFu16i");
    static STRUCT_IF_C Uc_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "Uc_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "Uc_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu16i, Uc_Ip_BFu16i)
//============================================================================


struct  Uc_Ip_BFu16ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_Ip_BFu16ll) C1{ Fc Fp FL:16}



static void Test_Uc_Ip_BFu16ll()
{
  {
    init_simple_test("Uc_Ip_BFu16ll");
    static STRUCT_IF_C Uc_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "Uc_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "Uc_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu16ll, Uc_Ip_BFu16ll)
//============================================================================


struct  Uc_Ip_BFu16s  {
  unsigned char v1;
  int *v2;
  unsigned short v3:16;
};
//SIG(1 Uc_Ip_BFu16s) C1{ Fc Fp Fs:16}



static void Test_Uc_Ip_BFu16s()
{
  {
    init_simple_test("Uc_Ip_BFu16s");
    static STRUCT_IF_C Uc_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "Uc_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "Uc_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu16s, Uc_Ip_BFu16s)
//============================================================================


struct  Uc_Ip_BFu17i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:17;
};
//SIG(1 Uc_Ip_BFu17i) C1{ Fc Fp Fi:17}



static void Test_Uc_Ip_BFu17i()
{
  {
    init_simple_test("Uc_Ip_BFu17i");
    static STRUCT_IF_C Uc_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "Uc_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "Uc_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu17i, Uc_Ip_BFu17i)
//============================================================================


struct  Uc_Ip_BFu17ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_Ip_BFu17ll) C1{ Fc Fp FL:17}



static void Test_Uc_Ip_BFu17ll()
{
  {
    init_simple_test("Uc_Ip_BFu17ll");
    static STRUCT_IF_C Uc_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "Uc_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "Uc_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu17ll, Uc_Ip_BFu17ll)
//============================================================================


struct  Uc_Ip_BFu1c  {
  unsigned char v1;
  int *v2;
  unsigned char v3:1;
};
//SIG(1 Uc_Ip_BFu1c) C1{ Fc Fp Fc:1}



static void Test_Uc_Ip_BFu1c()
{
  {
    init_simple_test("Uc_Ip_BFu1c");
    static STRUCT_IF_C Uc_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "Uc_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu1c, Uc_Ip_BFu1c)
//============================================================================


struct  Uc_Ip_BFu1i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:1;
};
//SIG(1 Uc_Ip_BFu1i) C1{ Fc Fp Fi:1}



static void Test_Uc_Ip_BFu1i()
{
  {
    init_simple_test("Uc_Ip_BFu1i");
    static STRUCT_IF_C Uc_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "Uc_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu1i, Uc_Ip_BFu1i)
//============================================================================


struct  Uc_Ip_BFu1ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_Ip_BFu1ll) C1{ Fc Fp FL:1}



static void Test_Uc_Ip_BFu1ll()
{
  {
    init_simple_test("Uc_Ip_BFu1ll");
    static STRUCT_IF_C Uc_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "Uc_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu1ll, Uc_Ip_BFu1ll)
//============================================================================


struct  Uc_Ip_BFu1s  {
  unsigned char v1;
  int *v2;
  unsigned short v3:1;
};
//SIG(1 Uc_Ip_BFu1s) C1{ Fc Fp Fs:1}



static void Test_Uc_Ip_BFu1s()
{
  {
    init_simple_test("Uc_Ip_BFu1s");
    static STRUCT_IF_C Uc_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "Uc_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu1s, Uc_Ip_BFu1s)
//============================================================================


struct  Uc_Ip_BFu31i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:31;
};
//SIG(1 Uc_Ip_BFu31i) C1{ Fc Fp Fi:31}



static void Test_Uc_Ip_BFu31i()
{
  {
    init_simple_test("Uc_Ip_BFu31i");
    static STRUCT_IF_C Uc_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "Uc_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "Uc_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu31i, Uc_Ip_BFu31i)
//============================================================================


struct  Uc_Ip_BFu31ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_Ip_BFu31ll) C1{ Fc Fp FL:31}



static void Test_Uc_Ip_BFu31ll()
{
  {
    init_simple_test("Uc_Ip_BFu31ll");
    static STRUCT_IF_C Uc_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "Uc_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "Uc_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu31ll, Uc_Ip_BFu31ll)
//============================================================================


struct  Uc_Ip_BFu32i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:32;
};
//SIG(1 Uc_Ip_BFu32i) C1{ Fc Fp Fi:32}



static void Test_Uc_Ip_BFu32i()
{
  {
    init_simple_test("Uc_Ip_BFu32i");
    static STRUCT_IF_C Uc_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "Uc_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "Uc_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu32i, Uc_Ip_BFu32i)
//============================================================================


struct  Uc_Ip_BFu32ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_Ip_BFu32ll) C1{ Fc Fp FL:32}



static void Test_Uc_Ip_BFu32ll()
{
  {
    init_simple_test("Uc_Ip_BFu32ll");
    static STRUCT_IF_C Uc_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "Uc_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "Uc_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu32ll, Uc_Ip_BFu32ll)
//============================================================================


struct  Uc_Ip_BFu33  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_Ip_BFu33) C1{ Fc Fp FL:33}



static void Test_Uc_Ip_BFu33()
{
  {
    init_simple_test("Uc_Ip_BFu33");
    static STRUCT_IF_C Uc_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "Uc_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "Uc_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu33, Uc_Ip_BFu33)
//============================================================================


struct  Uc_Ip_BFu7c  {
  unsigned char v1;
  int *v2;
  unsigned char v3:7;
};
//SIG(1 Uc_Ip_BFu7c) C1{ Fc Fp Fc:7}



static void Test_Uc_Ip_BFu7c()
{
  {
    init_simple_test("Uc_Ip_BFu7c");
    static STRUCT_IF_C Uc_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "Uc_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "Uc_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu7c, Uc_Ip_BFu7c)
//============================================================================


struct  Uc_Ip_BFu7i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:7;
};
//SIG(1 Uc_Ip_BFu7i) C1{ Fc Fp Fi:7}



static void Test_Uc_Ip_BFu7i()
{
  {
    init_simple_test("Uc_Ip_BFu7i");
    static STRUCT_IF_C Uc_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "Uc_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "Uc_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu7i, Uc_Ip_BFu7i)
//============================================================================


struct  Uc_Ip_BFu7ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_Ip_BFu7ll) C1{ Fc Fp FL:7}



static void Test_Uc_Ip_BFu7ll()
{
  {
    init_simple_test("Uc_Ip_BFu7ll");
    static STRUCT_IF_C Uc_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "Uc_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "Uc_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu7ll, Uc_Ip_BFu7ll)
//============================================================================


struct  Uc_Ip_BFu7s  {
  unsigned char v1;
  int *v2;
  unsigned short v3:7;
};
//SIG(1 Uc_Ip_BFu7s) C1{ Fc Fp Fs:7}



static void Test_Uc_Ip_BFu7s()
{
  {
    init_simple_test("Uc_Ip_BFu7s");
    static STRUCT_IF_C Uc_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "Uc_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "Uc_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu7s, Uc_Ip_BFu7s)
//============================================================================


struct  Uc_Ip_BFu8c  {
  unsigned char v1;
  int *v2;
  unsigned char v3:8;
};
//SIG(1 Uc_Ip_BFu8c) C1{ Fc Fp Fc:8}



static void Test_Uc_Ip_BFu8c()
{
  {
    init_simple_test("Uc_Ip_BFu8c");
    static STRUCT_IF_C Uc_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "Uc_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "Uc_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu8c, Uc_Ip_BFu8c)
//============================================================================


struct  Uc_Ip_BFu8i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:8;
};
//SIG(1 Uc_Ip_BFu8i) C1{ Fc Fp Fi:8}



static void Test_Uc_Ip_BFu8i()
{
  {
    init_simple_test("Uc_Ip_BFu8i");
    static STRUCT_IF_C Uc_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "Uc_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "Uc_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu8i, Uc_Ip_BFu8i)
//============================================================================


struct  Uc_Ip_BFu8ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_Ip_BFu8ll) C1{ Fc Fp FL:8}



static void Test_Uc_Ip_BFu8ll()
{
  {
    init_simple_test("Uc_Ip_BFu8ll");
    static STRUCT_IF_C Uc_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "Uc_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "Uc_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu8ll, Uc_Ip_BFu8ll)
//============================================================================


struct  Uc_Ip_BFu8s  {
  unsigned char v1;
  int *v2;
  unsigned short v3:8;
};
//SIG(1 Uc_Ip_BFu8s) C1{ Fc Fp Fs:8}



static void Test_Uc_Ip_BFu8s()
{
  {
    init_simple_test("Uc_Ip_BFu8s");
    static STRUCT_IF_C Uc_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "Uc_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "Uc_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu8s, Uc_Ip_BFu8s)
//============================================================================


struct  Uc_Ip_BFu9i  {
  unsigned char v1;
  int *v2;
  unsigned int v3:9;
};
//SIG(1 Uc_Ip_BFu9i) C1{ Fc Fp Fi:9}



static void Test_Uc_Ip_BFu9i()
{
  {
    init_simple_test("Uc_Ip_BFu9i");
    static STRUCT_IF_C Uc_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "Uc_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "Uc_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu9i, Uc_Ip_BFu9i)
//============================================================================


struct  Uc_Ip_BFu9ll  {
  unsigned char v1;
  int *v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_Ip_BFu9ll) C1{ Fc Fp FL:9}



static void Test_Uc_Ip_BFu9ll()
{
  {
    init_simple_test("Uc_Ip_BFu9ll");
    static STRUCT_IF_C Uc_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "Uc_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "Uc_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu9ll, Uc_Ip_BFu9ll)
//============================================================================


struct  Uc_Ip_BFu9s  {
  unsigned char v1;
  int *v2;
  unsigned short v3:9;
};
//SIG(1 Uc_Ip_BFu9s) C1{ Fc Fp Fs:9}



static void Test_Uc_Ip_BFu9s()
{
  {
    init_simple_test("Uc_Ip_BFu9s");
    static STRUCT_IF_C Uc_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "Uc_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "Uc_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu9s, Uc_Ip_BFu9s)
//============================================================================


struct  Uc_Ip_C  {
  unsigned char v1;
  int *v2;
  char v3;
};
//SIG(1 Uc_Ip_C) C1{ Fc Fp Fc}



static void Test_Uc_Ip_C()
{
  {
    init_simple_test("Uc_Ip_C");
    STRUCT_IF_C Uc_Ip_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_C)");
    check_field_offset(lv, v1, 0, "Uc_Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_C, Uc_Ip_C)
//============================================================================


struct  Uc_Ip_D  {
  unsigned char v1;
  int *v2;
  double v3;
};
//SIG(1 Uc_Ip_D) C1{ Fc Fp FL}



static void Test_Uc_Ip_D()
{
  {
    init_simple_test("Uc_Ip_D");
    STRUCT_IF_C Uc_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_D)");
    check_field_offset(lv, v1, 0, "Uc_Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_D, Uc_Ip_D)
//============================================================================


struct  Uc_Ip_F  {
  unsigned char v1;
  int *v2;
  float v3;
};
//SIG(1 Uc_Ip_F) C1{ Fc Fp Fi}



static void Test_Uc_Ip_F()
{
  {
    init_simple_test("Uc_Ip_F");
    STRUCT_IF_C Uc_Ip_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_F)");
    check_field_offset(lv, v1, 0, "Uc_Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_F, Uc_Ip_F)
//============================================================================


struct  Uc_Ip_I  {
  unsigned char v1;
  int *v2;
  int v3;
};
//SIG(1 Uc_Ip_I) C1{ Fc Fp Fi}



static void Test_Uc_Ip_I()
{
  {
    init_simple_test("Uc_Ip_I");
    STRUCT_IF_C Uc_Ip_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_I)");
    check_field_offset(lv, v1, 0, "Uc_Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_I, Uc_Ip_I)
//============================================================================


struct  Uc_Ip_Ip  {
  unsigned char v1;
  int *v2;
  int *v3;
};
//SIG(1 Uc_Ip_Ip) C1{ Fc Fp[2]}



static void Test_Uc_Ip_Ip()
{
  {
    init_simple_test("Uc_Ip_Ip");
    STRUCT_IF_C Uc_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Ip, Uc_Ip_Ip)
//============================================================================


struct  Uc_Ip_L  {
  unsigned char v1;
  int *v2;
  __tsi64 v3;
};
//SIG(1 Uc_Ip_L) C1{ Fc Fp FL}



static void Test_Uc_Ip_L()
{
  {
    init_simple_test("Uc_Ip_L");
    STRUCT_IF_C Uc_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ip_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_L)");
    check_field_offset(lv, v1, 0, "Uc_Ip_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_L, Uc_Ip_L)
//============================================================================


struct  Uc_Ip_S  {
  unsigned char v1;
  int *v2;
  short v3;
};
//SIG(1 Uc_Ip_S) C1{ Fc Fp Fs}



static void Test_Uc_Ip_S()
{
  {
    init_simple_test("Uc_Ip_S");
    STRUCT_IF_C Uc_Ip_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_S)");
    check_field_offset(lv, v1, 0, "Uc_Ip_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_S, Uc_Ip_S)
//============================================================================


struct  Uc_Ip_Uc  {
  unsigned char v1;
  int *v2;
  unsigned char v3;
};
//SIG(1 Uc_Ip_Uc) C1{ Fc Fp Fc}



static void Test_Uc_Ip_Uc()
{
  {
    init_simple_test("Uc_Ip_Uc");
    STRUCT_IF_C Uc_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_Uc)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Uc, Uc_Ip_Uc)
//============================================================================


struct  Uc_Ip_Ui  {
  unsigned char v1;
  int *v2;
  unsigned int v3;
};
//SIG(1 Uc_Ip_Ui) C1{ Fc Fp Fi}



static void Test_Uc_Ip_Ui()
{
  {
    init_simple_test("Uc_Ip_Ui");
    STRUCT_IF_C Uc_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_Ui)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Ui, Uc_Ip_Ui)
//============================================================================


struct  Uc_Ip_Ul  {
  unsigned char v1;
  int *v2;
  __tsu64 v3;
};
//SIG(1 Uc_Ip_Ul) C1{ Fc Fp FL}



static void Test_Uc_Ip_Ul()
{
  {
    init_simple_test("Uc_Ip_Ul");
    STRUCT_IF_C Uc_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ip_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_Ul)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Ul, Uc_Ip_Ul)
//============================================================================


struct  Uc_Ip_Us  {
  unsigned char v1;
  int *v2;
  unsigned short v3;
};
//SIG(1 Uc_Ip_Us) C1{ Fc Fp Fs}



static void Test_Uc_Ip_Us()
{
  {
    init_simple_test("Uc_Ip_Us");
    STRUCT_IF_C Uc_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_Us)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Us, Uc_Ip_Us)
//============================================================================


struct  Uc_Ip_Vp  {
  unsigned char v1;
  int *v2;
  void *v3;
};
//SIG(1 Uc_Ip_Vp) C1{ Fc Fp[2]}



static void Test_Uc_Ip_Vp()
{
  {
    init_simple_test("Uc_Ip_Vp");
    STRUCT_IF_C Uc_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Ip_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_Vp)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Vp, Uc_Ip_Vp)
//============================================================================


struct  Uc_L  {
  unsigned char v1;
  __tsi64 v2;
};
//SIG(1 Uc_L) C1{ Fc FL}



static void Test_Uc_L()
{
  {
    init_simple_test("Uc_L");
    STRUCT_IF_C Uc_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L)");
    check_field_offset(lv, v1, 0, "Uc_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L, Uc_L)
//============================================================================


struct  Uc_L_BFu15i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:15;
};
//SIG(1 Uc_L_BFu15i) C1{ Fc FL Fi:15}



static void Test_Uc_L_BFu15i()
{
  {
    init_simple_test("Uc_L_BFu15i");
    static STRUCT_IF_C Uc_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Uc_L_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Uc_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu15i, Uc_L_BFu15i)
//============================================================================


struct  Uc_L_BFu15ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_L_BFu15ll) C1{ Fc FL FL:15}



static void Test_Uc_L_BFu15ll()
{
  {
    init_simple_test("Uc_L_BFu15ll");
    static STRUCT_IF_C Uc_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Uc_L_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Uc_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu15ll, Uc_L_BFu15ll)
//============================================================================


struct  Uc_L_BFu15s  {
  unsigned char v1;
  __tsi64 v2;
  unsigned short v3:15;
};
//SIG(1 Uc_L_BFu15s) C1{ Fc FL Fs:15}



static void Test_Uc_L_BFu15s()
{
  {
    init_simple_test("Uc_L_BFu15s");
    static STRUCT_IF_C Uc_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Uc_L_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Uc_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu15s, Uc_L_BFu15s)
//============================================================================


struct  Uc_L_BFu16i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:16;
};
//SIG(1 Uc_L_BFu16i) C1{ Fc FL Fi:16}



static void Test_Uc_L_BFu16i()
{
  {
    init_simple_test("Uc_L_BFu16i");
    static STRUCT_IF_C Uc_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Uc_L_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Uc_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu16i, Uc_L_BFu16i)
//============================================================================


struct  Uc_L_BFu16ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_L_BFu16ll) C1{ Fc FL FL:16}



static void Test_Uc_L_BFu16ll()
{
  {
    init_simple_test("Uc_L_BFu16ll");
    static STRUCT_IF_C Uc_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Uc_L_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Uc_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu16ll, Uc_L_BFu16ll)
//============================================================================


struct  Uc_L_BFu16s  {
  unsigned char v1;
  __tsi64 v2;
  unsigned short v3:16;
};
//SIG(1 Uc_L_BFu16s) C1{ Fc FL Fs:16}



static void Test_Uc_L_BFu16s()
{
  {
    init_simple_test("Uc_L_BFu16s");
    static STRUCT_IF_C Uc_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Uc_L_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Uc_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu16s, Uc_L_BFu16s)
//============================================================================


struct  Uc_L_BFu17i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:17;
};
//SIG(1 Uc_L_BFu17i) C1{ Fc FL Fi:17}



static void Test_Uc_L_BFu17i()
{
  {
    init_simple_test("Uc_L_BFu17i");
    static STRUCT_IF_C Uc_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Uc_L_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Uc_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu17i, Uc_L_BFu17i)
//============================================================================


struct  Uc_L_BFu17ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_L_BFu17ll) C1{ Fc FL FL:17}



static void Test_Uc_L_BFu17ll()
{
  {
    init_simple_test("Uc_L_BFu17ll");
    static STRUCT_IF_C Uc_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Uc_L_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Uc_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu17ll, Uc_L_BFu17ll)
//============================================================================


struct  Uc_L_BFu1c  {
  unsigned char v1;
  __tsi64 v2;
  unsigned char v3:1;
};
//SIG(1 Uc_L_BFu1c) C1{ Fc FL Fc:1}



static void Test_Uc_L_BFu1c()
{
  {
    init_simple_test("Uc_L_BFu1c");
    static STRUCT_IF_C Uc_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu1c, Uc_L_BFu1c)
//============================================================================


struct  Uc_L_BFu1i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:1;
};
//SIG(1 Uc_L_BFu1i) C1{ Fc FL Fi:1}



static void Test_Uc_L_BFu1i()
{
  {
    init_simple_test("Uc_L_BFu1i");
    static STRUCT_IF_C Uc_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu1i, Uc_L_BFu1i)
//============================================================================


struct  Uc_L_BFu1ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_L_BFu1ll) C1{ Fc FL FL:1}



static void Test_Uc_L_BFu1ll()
{
  {
    init_simple_test("Uc_L_BFu1ll");
    static STRUCT_IF_C Uc_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu1ll, Uc_L_BFu1ll)
//============================================================================


struct  Uc_L_BFu1s  {
  unsigned char v1;
  __tsi64 v2;
  unsigned short v3:1;
};
//SIG(1 Uc_L_BFu1s) C1{ Fc FL Fs:1}



static void Test_Uc_L_BFu1s()
{
  {
    init_simple_test("Uc_L_BFu1s");
    static STRUCT_IF_C Uc_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu1s, Uc_L_BFu1s)
//============================================================================


struct  Uc_L_BFu31i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:31;
};
//SIG(1 Uc_L_BFu31i) C1{ Fc FL Fi:31}



static void Test_Uc_L_BFu31i()
{
  {
    init_simple_test("Uc_L_BFu31i");
    static STRUCT_IF_C Uc_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Uc_L_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Uc_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu31i, Uc_L_BFu31i)
//============================================================================


struct  Uc_L_BFu31ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_L_BFu31ll) C1{ Fc FL FL:31}



static void Test_Uc_L_BFu31ll()
{
  {
    init_simple_test("Uc_L_BFu31ll");
    static STRUCT_IF_C Uc_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Uc_L_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Uc_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu31ll, Uc_L_BFu31ll)
//============================================================================


struct  Uc_L_BFu32i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:32;
};
//SIG(1 Uc_L_BFu32i) C1{ Fc FL Fi:32}



static void Test_Uc_L_BFu32i()
{
  {
    init_simple_test("Uc_L_BFu32i");
    static STRUCT_IF_C Uc_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Uc_L_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Uc_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu32i, Uc_L_BFu32i)
//============================================================================


struct  Uc_L_BFu32ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_L_BFu32ll) C1{ Fc FL FL:32}



static void Test_Uc_L_BFu32ll()
{
  {
    init_simple_test("Uc_L_BFu32ll");
    static STRUCT_IF_C Uc_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Uc_L_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Uc_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu32ll, Uc_L_BFu32ll)
//============================================================================


struct  Uc_L_BFu33  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_L_BFu33) C1{ Fc FL FL:33}



static void Test_Uc_L_BFu33()
{
  {
    init_simple_test("Uc_L_BFu33");
    static STRUCT_IF_C Uc_L_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_L_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Uc_L_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Uc_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu33, Uc_L_BFu33)
//============================================================================


struct  Uc_L_BFu7c  {
  unsigned char v1;
  __tsi64 v2;
  unsigned char v3:7;
};
//SIG(1 Uc_L_BFu7c) C1{ Fc FL Fc:7}



static void Test_Uc_L_BFu7c()
{
  {
    init_simple_test("Uc_L_BFu7c");
    static STRUCT_IF_C Uc_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_L_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu7c, Uc_L_BFu7c)
//============================================================================


struct  Uc_L_BFu7i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:7;
};
//SIG(1 Uc_L_BFu7i) C1{ Fc FL Fi:7}



static void Test_Uc_L_BFu7i()
{
  {
    init_simple_test("Uc_L_BFu7i");
    static STRUCT_IF_C Uc_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_L_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu7i, Uc_L_BFu7i)
//============================================================================


struct  Uc_L_BFu7ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_L_BFu7ll) C1{ Fc FL FL:7}



static void Test_Uc_L_BFu7ll()
{
  {
    init_simple_test("Uc_L_BFu7ll");
    static STRUCT_IF_C Uc_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_L_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu7ll, Uc_L_BFu7ll)
//============================================================================


struct  Uc_L_BFu7s  {
  unsigned char v1;
  __tsi64 v2;
  unsigned short v3:7;
};
//SIG(1 Uc_L_BFu7s) C1{ Fc FL Fs:7}



static void Test_Uc_L_BFu7s()
{
  {
    init_simple_test("Uc_L_BFu7s");
    static STRUCT_IF_C Uc_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_L_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu7s, Uc_L_BFu7s)
//============================================================================


struct  Uc_L_BFu8c  {
  unsigned char v1;
  __tsi64 v2;
  unsigned char v3:8;
};
//SIG(1 Uc_L_BFu8c) C1{ Fc FL Fc:8}



static void Test_Uc_L_BFu8c()
{
  {
    init_simple_test("Uc_L_BFu8c");
    static STRUCT_IF_C Uc_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_L_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu8c, Uc_L_BFu8c)
//============================================================================


struct  Uc_L_BFu8i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:8;
};
//SIG(1 Uc_L_BFu8i) C1{ Fc FL Fi:8}



static void Test_Uc_L_BFu8i()
{
  {
    init_simple_test("Uc_L_BFu8i");
    static STRUCT_IF_C Uc_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_L_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu8i, Uc_L_BFu8i)
//============================================================================


struct  Uc_L_BFu8ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_L_BFu8ll) C1{ Fc FL FL:8}



static void Test_Uc_L_BFu8ll()
{
  {
    init_simple_test("Uc_L_BFu8ll");
    static STRUCT_IF_C Uc_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_L_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu8ll, Uc_L_BFu8ll)
//============================================================================


struct  Uc_L_BFu8s  {
  unsigned char v1;
  __tsi64 v2;
  unsigned short v3:8;
};
//SIG(1 Uc_L_BFu8s) C1{ Fc FL Fs:8}



static void Test_Uc_L_BFu8s()
{
  {
    init_simple_test("Uc_L_BFu8s");
    static STRUCT_IF_C Uc_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_L_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu8s, Uc_L_BFu8s)
//============================================================================


struct  Uc_L_BFu9i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3:9;
};
//SIG(1 Uc_L_BFu9i) C1{ Fc FL Fi:9}



static void Test_Uc_L_BFu9i()
{
  {
    init_simple_test("Uc_L_BFu9i");
    static STRUCT_IF_C Uc_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_L_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu9i, Uc_L_BFu9i)
//============================================================================


struct  Uc_L_BFu9ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_L_BFu9ll) C1{ Fc FL FL:9}



static void Test_Uc_L_BFu9ll()
{
  {
    init_simple_test("Uc_L_BFu9ll");
    static STRUCT_IF_C Uc_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_L_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu9ll, Uc_L_BFu9ll)
//============================================================================


struct  Uc_L_BFu9s  {
  unsigned char v1;
  __tsi64 v2;
  unsigned short v3:9;
};
//SIG(1 Uc_L_BFu9s) C1{ Fc FL Fs:9}



static void Test_Uc_L_BFu9s()
{
  {
    init_simple_test("Uc_L_BFu9s");
    static STRUCT_IF_C Uc_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_L_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu9s, Uc_L_BFu9s)
//============================================================================


struct  Uc_L_C  {
  unsigned char v1;
  __tsi64 v2;
  char v3;
};
//SIG(1 Uc_L_C) C1{ Fc FL Fc}



static void Test_Uc_L_C()
{
  {
    init_simple_test("Uc_L_C");
    STRUCT_IF_C Uc_L_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_C)");
    check_field_offset(lv, v1, 0, "Uc_L_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_C, Uc_L_C)
//============================================================================


struct  Uc_L_D  {
  unsigned char v1;
  __tsi64 v2;
  double v3;
};
//SIG(1 Uc_L_D) C1{ Fc FL[2]}



static void Test_Uc_L_D()
{
  {
    init_simple_test("Uc_L_D");
    STRUCT_IF_C Uc_L_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_L_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_D)");
    check_field_offset(lv, v1, 0, "Uc_L_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_D, Uc_L_D)
//============================================================================


struct  Uc_L_F  {
  unsigned char v1;
  __tsi64 v2;
  float v3;
};
//SIG(1 Uc_L_F) C1{ Fc FL Fi}



static void Test_Uc_L_F()
{
  {
    init_simple_test("Uc_L_F");
    STRUCT_IF_C Uc_L_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_F)");
    check_field_offset(lv, v1, 0, "Uc_L_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_F, Uc_L_F)
//============================================================================


struct  Uc_L_I  {
  unsigned char v1;
  __tsi64 v2;
  int v3;
};
//SIG(1 Uc_L_I) C1{ Fc FL Fi}



static void Test_Uc_L_I()
{
  {
    init_simple_test("Uc_L_I");
    STRUCT_IF_C Uc_L_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_I)");
    check_field_offset(lv, v1, 0, "Uc_L_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_I, Uc_L_I)
//============================================================================


struct  Uc_L_Ip  {
  unsigned char v1;
  __tsi64 v2;
  int *v3;
};
//SIG(1 Uc_L_Ip) C1{ Fc FL Fp}



static void Test_Uc_L_Ip()
{
  {
    init_simple_test("Uc_L_Ip");
    STRUCT_IF_C Uc_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_Ip)");
    check_field_offset(lv, v1, 0, "Uc_L_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_Ip, Uc_L_Ip)
//============================================================================


struct  Uc_L_L  {
  unsigned char v1;
  __tsi64 v2;
  __tsi64 v3;
};
//SIG(1 Uc_L_L) C1{ Fc FL[2]}



static void Test_Uc_L_L()
{
  {
    init_simple_test("Uc_L_L");
    STRUCT_IF_C Uc_L_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_L_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_L)");
    check_field_offset(lv, v1, 0, "Uc_L_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_L, Uc_L_L)
//============================================================================


struct  Uc_L_S  {
  unsigned char v1;
  __tsi64 v2;
  short v3;
};
//SIG(1 Uc_L_S) C1{ Fc FL Fs}



static void Test_Uc_L_S()
{
  {
    init_simple_test("Uc_L_S");
    STRUCT_IF_C Uc_L_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_S)");
    check_field_offset(lv, v1, 0, "Uc_L_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_S, Uc_L_S)
//============================================================================


struct  Uc_L_Uc  {
  unsigned char v1;
  __tsi64 v2;
  unsigned char v3;
};
//SIG(1 Uc_L_Uc) C1{ Fc FL Fc}



static void Test_Uc_L_Uc()
{
  {
    init_simple_test("Uc_L_Uc");
    STRUCT_IF_C Uc_L_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_Uc)");
    check_field_offset(lv, v1, 0, "Uc_L_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_Uc, Uc_L_Uc)
//============================================================================


struct  Uc_L_Ui  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int v3;
};
//SIG(1 Uc_L_Ui) C1{ Fc FL Fi}



static void Test_Uc_L_Ui()
{
  {
    init_simple_test("Uc_L_Ui");
    STRUCT_IF_C Uc_L_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_Ui)");
    check_field_offset(lv, v1, 0, "Uc_L_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_Ui, Uc_L_Ui)
//============================================================================


struct  Uc_L_Ul  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64 v3;
};
//SIG(1 Uc_L_Ul) C1{ Fc FL[2]}



static void Test_Uc_L_Ul()
{
  {
    init_simple_test("Uc_L_Ul");
    STRUCT_IF_C Uc_L_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_Ul)");
    check_field_offset(lv, v1, 0, "Uc_L_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_Ul, Uc_L_Ul)
//============================================================================


struct  Uc_L_Us  {
  unsigned char v1;
  __tsi64 v2;
  unsigned short v3;
};
//SIG(1 Uc_L_Us) C1{ Fc FL Fs}



static void Test_Uc_L_Us()
{
  {
    init_simple_test("Uc_L_Us");
    STRUCT_IF_C Uc_L_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_Us)");
    check_field_offset(lv, v1, 0, "Uc_L_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_Us, Uc_L_Us)
//============================================================================


struct  Uc_L_Vp  {
  unsigned char v1;
  __tsi64 v2;
  void *v3;
};
//SIG(1 Uc_L_Vp) C1{ Fc FL Fp}



static void Test_Uc_L_Vp()
{
  {
    init_simple_test("Uc_L_Vp");
    STRUCT_IF_C Uc_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_Vp)");
    check_field_offset(lv, v1, 0, "Uc_L_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_Vp, Uc_L_Vp)
//============================================================================


struct  Uc_S  {
  unsigned char v1;
  short v2;
};
//SIG(1 Uc_S) C1{ Fc Fs}



static void Test_Uc_S()
{
  {
    init_simple_test("Uc_S");
    STRUCT_IF_C Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_S)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S)");
    check_field_offset(lv, v1, 0, "Uc_S.v1");
    check_field_offset(lv, v2, 2, "Uc_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S, Uc_S)
//============================================================================


struct  Uc_S_BFu15i  {
  unsigned char v1;
  short v2;
  unsigned int v3:15;
};
//SIG(1 Uc_S_BFu15i) C1{ Fc Fs Fi:15}



static void Test_Uc_S_BFu15i()
{
  {
    init_simple_test("Uc_S_BFu15i");
    static STRUCT_IF_C Uc_S_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Uc_S_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Uc_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu15i, Uc_S_BFu15i)
//============================================================================


struct  Uc_S_BFu15ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_S_BFu15ll) C1{ Fc Fs FL:15}



static void Test_Uc_S_BFu15ll()
{
  {
    init_simple_test("Uc_S_BFu15ll");
    static STRUCT_IF_C Uc_S_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Uc_S_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Uc_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu15ll, Uc_S_BFu15ll)
//============================================================================


struct  Uc_S_BFu15s  {
  unsigned char v1;
  short v2;
  unsigned short v3:15;
};
//SIG(1 Uc_S_BFu15s) C1{ Fc Fs Fs:15}



static void Test_Uc_S_BFu15s()
{
  {
    init_simple_test("Uc_S_BFu15s");
    static STRUCT_IF_C Uc_S_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Uc_S_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Uc_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu15s, Uc_S_BFu15s)
//============================================================================


struct  Uc_S_BFu16i  {
  unsigned char v1;
  short v2;
  unsigned int v3:16;
};
//SIG(1 Uc_S_BFu16i) C1{ Fc Fs Fi:16}



static void Test_Uc_S_BFu16i()
{
  {
    init_simple_test("Uc_S_BFu16i");
    static STRUCT_IF_C Uc_S_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Uc_S_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Uc_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu16i, Uc_S_BFu16i)
//============================================================================


struct  Uc_S_BFu16ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_S_BFu16ll) C1{ Fc Fs FL:16}



static void Test_Uc_S_BFu16ll()
{
  {
    init_simple_test("Uc_S_BFu16ll");
    static STRUCT_IF_C Uc_S_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Uc_S_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Uc_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu16ll, Uc_S_BFu16ll)
//============================================================================


struct  Uc_S_BFu16s  {
  unsigned char v1;
  short v2;
  unsigned short v3:16;
};
//SIG(1 Uc_S_BFu16s) C1{ Fc Fs Fs:16}



static void Test_Uc_S_BFu16s()
{
  {
    init_simple_test("Uc_S_BFu16s");
    static STRUCT_IF_C Uc_S_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Uc_S_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Uc_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu16s, Uc_S_BFu16s)
//============================================================================


struct  Uc_S_BFu17i  {
  unsigned char v1;
  short v2;
  unsigned int v3:17;
};
//SIG(1 Uc_S_BFu17i) C1{ Fc Fs Fi:17}



static void Test_Uc_S_BFu17i()
{
  {
    init_simple_test("Uc_S_BFu17i");
    static STRUCT_IF_C Uc_S_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Uc_S_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Uc_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu17i, Uc_S_BFu17i)
//============================================================================


struct  Uc_S_BFu17ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_S_BFu17ll) C1{ Fc Fs FL:17}



static void Test_Uc_S_BFu17ll()
{
  {
    init_simple_test("Uc_S_BFu17ll");
    static STRUCT_IF_C Uc_S_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Uc_S_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Uc_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu17ll, Uc_S_BFu17ll)
//============================================================================


struct  Uc_S_BFu1c  {
  unsigned char v1;
  short v2;
  unsigned char v3:1;
};
//SIG(1 Uc_S_BFu1c) C1{ Fc Fs Fc:1}



static void Test_Uc_S_BFu1c()
{
  {
    init_simple_test("Uc_S_BFu1c");
    static STRUCT_IF_C Uc_S_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Uc_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu1c, Uc_S_BFu1c)
//============================================================================


struct  Uc_S_BFu1i  {
  unsigned char v1;
  short v2;
  unsigned int v3:1;
};
//SIG(1 Uc_S_BFu1i) C1{ Fc Fs Fi:1}



static void Test_Uc_S_BFu1i()
{
  {
    init_simple_test("Uc_S_BFu1i");
    static STRUCT_IF_C Uc_S_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Uc_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu1i, Uc_S_BFu1i)
//============================================================================


struct  Uc_S_BFu1ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_S_BFu1ll) C1{ Fc Fs FL:1}



static void Test_Uc_S_BFu1ll()
{
  {
    init_simple_test("Uc_S_BFu1ll");
    static STRUCT_IF_C Uc_S_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Uc_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu1ll, Uc_S_BFu1ll)
//============================================================================


struct  Uc_S_BFu1s  {
  unsigned char v1;
  short v2;
  unsigned short v3:1;
};
//SIG(1 Uc_S_BFu1s) C1{ Fc Fs Fs:1}



static void Test_Uc_S_BFu1s()
{
  {
    init_simple_test("Uc_S_BFu1s");
    static STRUCT_IF_C Uc_S_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Uc_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu1s, Uc_S_BFu1s)
//============================================================================


struct  Uc_S_BFu31i  {
  unsigned char v1;
  short v2;
  unsigned int v3:31;
};
//SIG(1 Uc_S_BFu31i) C1{ Fc Fs Fi:31}



static void Test_Uc_S_BFu31i()
{
  {
    init_simple_test("Uc_S_BFu31i");
    static STRUCT_IF_C Uc_S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Uc_S_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Uc_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu31i, Uc_S_BFu31i)
//============================================================================


struct  Uc_S_BFu31ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_S_BFu31ll) C1{ Fc Fs FL:31}



static void Test_Uc_S_BFu31ll()
{
  {
    init_simple_test("Uc_S_BFu31ll");
    static STRUCT_IF_C Uc_S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Uc_S_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Uc_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu31ll, Uc_S_BFu31ll)
//============================================================================


struct  Uc_S_BFu32i  {
  unsigned char v1;
  short v2;
  unsigned int v3:32;
};
//SIG(1 Uc_S_BFu32i) C1{ Fc Fs Fi:32}



static void Test_Uc_S_BFu32i()
{
  {
    init_simple_test("Uc_S_BFu32i");
    static STRUCT_IF_C Uc_S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Uc_S_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Uc_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu32i, Uc_S_BFu32i)
//============================================================================


struct  Uc_S_BFu32ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_S_BFu32ll) C1{ Fc Fs FL:32}



static void Test_Uc_S_BFu32ll()
{
  {
    init_simple_test("Uc_S_BFu32ll");
    static STRUCT_IF_C Uc_S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Uc_S_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Uc_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu32ll, Uc_S_BFu32ll)
//============================================================================


struct  Uc_S_BFu33  {
  unsigned char v1;
  short v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_S_BFu33) C1{ Fc Fs FL:33}



static void Test_Uc_S_BFu33()
{
  {
    init_simple_test("Uc_S_BFu33");
    static STRUCT_IF_C Uc_S_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_S_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu33.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "Uc_S_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Uc_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu33, Uc_S_BFu33)
//============================================================================


struct  Uc_S_BFu7c  {
  unsigned char v1;
  short v2;
  unsigned char v3:7;
};
//SIG(1 Uc_S_BFu7c) C1{ Fc Fs Fc:7}



static void Test_Uc_S_BFu7c()
{
  {
    init_simple_test("Uc_S_BFu7c");
    static STRUCT_IF_C Uc_S_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Uc_S_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Uc_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu7c, Uc_S_BFu7c)
//============================================================================


struct  Uc_S_BFu7i  {
  unsigned char v1;
  short v2;
  unsigned int v3:7;
};
//SIG(1 Uc_S_BFu7i) C1{ Fc Fs Fi:7}



static void Test_Uc_S_BFu7i()
{
  {
    init_simple_test("Uc_S_BFu7i");
    static STRUCT_IF_C Uc_S_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Uc_S_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Uc_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu7i, Uc_S_BFu7i)
//============================================================================


struct  Uc_S_BFu7ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_S_BFu7ll) C1{ Fc Fs FL:7}



static void Test_Uc_S_BFu7ll()
{
  {
    init_simple_test("Uc_S_BFu7ll");
    static STRUCT_IF_C Uc_S_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Uc_S_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Uc_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu7ll, Uc_S_BFu7ll)
//============================================================================


struct  Uc_S_BFu7s  {
  unsigned char v1;
  short v2;
  unsigned short v3:7;
};
//SIG(1 Uc_S_BFu7s) C1{ Fc Fs Fs:7}



static void Test_Uc_S_BFu7s()
{
  {
    init_simple_test("Uc_S_BFu7s");
    static STRUCT_IF_C Uc_S_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Uc_S_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Uc_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu7s, Uc_S_BFu7s)
//============================================================================


struct  Uc_S_BFu8c  {
  unsigned char v1;
  short v2;
  unsigned char v3:8;
};
//SIG(1 Uc_S_BFu8c) C1{ Fc Fs Fc:8}



static void Test_Uc_S_BFu8c()
{
  {
    init_simple_test("Uc_S_BFu8c");
    static STRUCT_IF_C Uc_S_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Uc_S_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Uc_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu8c, Uc_S_BFu8c)
//============================================================================


struct  Uc_S_BFu8i  {
  unsigned char v1;
  short v2;
  unsigned int v3:8;
};
//SIG(1 Uc_S_BFu8i) C1{ Fc Fs Fi:8}



static void Test_Uc_S_BFu8i()
{
  {
    init_simple_test("Uc_S_BFu8i");
    static STRUCT_IF_C Uc_S_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Uc_S_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Uc_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu8i, Uc_S_BFu8i)
//============================================================================


struct  Uc_S_BFu8ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_S_BFu8ll) C1{ Fc Fs FL:8}



static void Test_Uc_S_BFu8ll()
{
  {
    init_simple_test("Uc_S_BFu8ll");
    static STRUCT_IF_C Uc_S_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Uc_S_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Uc_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu8ll, Uc_S_BFu8ll)
//============================================================================


struct  Uc_S_BFu8s  {
  unsigned char v1;
  short v2;
  unsigned short v3:8;
};
//SIG(1 Uc_S_BFu8s) C1{ Fc Fs Fs:8}



static void Test_Uc_S_BFu8s()
{
  {
    init_simple_test("Uc_S_BFu8s");
    static STRUCT_IF_C Uc_S_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Uc_S_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Uc_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu8s, Uc_S_BFu8s)
//============================================================================


struct  Uc_S_BFu9i  {
  unsigned char v1;
  short v2;
  unsigned int v3:9;
};
//SIG(1 Uc_S_BFu9i) C1{ Fc Fs Fi:9}



static void Test_Uc_S_BFu9i()
{
  {
    init_simple_test("Uc_S_BFu9i");
    static STRUCT_IF_C Uc_S_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Uc_S_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Uc_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu9i, Uc_S_BFu9i)
//============================================================================


struct  Uc_S_BFu9ll  {
  unsigned char v1;
  short v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_S_BFu9ll) C1{ Fc Fs FL:9}



static void Test_Uc_S_BFu9ll()
{
  {
    init_simple_test("Uc_S_BFu9ll");
    static STRUCT_IF_C Uc_S_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Uc_S_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Uc_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu9ll, Uc_S_BFu9ll)
//============================================================================


struct  Uc_S_BFu9s  {
  unsigned char v1;
  short v2;
  unsigned short v3:9;
};
//SIG(1 Uc_S_BFu9s) C1{ Fc Fs Fs:9}



static void Test_Uc_S_BFu9s()
{
  {
    init_simple_test("Uc_S_BFu9s");
    static STRUCT_IF_C Uc_S_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Uc_S_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Uc_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_BFu9s, Uc_S_BFu9s)
//============================================================================


struct  Uc_S_C  {
  unsigned char v1;
  short v2;
  char v3;
};
//SIG(1 Uc_S_C) C1{ Fc Fs Fc}



static void Test_Uc_S_C()
{
  {
    init_simple_test("Uc_S_C");
    STRUCT_IF_C Uc_S_C lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_C)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_C)");
    check_field_offset(lv, v1, 0, "Uc_S_C.v1");
    check_field_offset(lv, v2, 2, "Uc_S_C.v2");
    check_field_offset(lv, v3, 4, "Uc_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_C, Uc_S_C)
//============================================================================


struct  Uc_S_D  {
  unsigned char v1;
  short v2;
  double v3;
};
//SIG(1 Uc_S_D) C1{ Fc Fs FL}



static void Test_Uc_S_D()
{
  {
    init_simple_test("Uc_S_D");
    STRUCT_IF_C Uc_S_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_S_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_D)");
    check_field_offset(lv, v1, 0, "Uc_S_D.v1");
    check_field_offset(lv, v2, 2, "Uc_S_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_D, Uc_S_D)
//============================================================================


struct  Uc_S_F  {
  unsigned char v1;
  short v2;
  float v3;
};
//SIG(1 Uc_S_F) C1{ Fc Fs Fi}



static void Test_Uc_S_F()
{
  {
    init_simple_test("Uc_S_F");
    STRUCT_IF_C Uc_S_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_F)");
    check_field_offset(lv, v1, 0, "Uc_S_F.v1");
    check_field_offset(lv, v2, 2, "Uc_S_F.v2");
    check_field_offset(lv, v3, 4, "Uc_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_F, Uc_S_F)
//============================================================================


struct  Uc_S_I  {
  unsigned char v1;
  short v2;
  int v3;
};
//SIG(1 Uc_S_I) C1{ Fc Fs Fi}



static void Test_Uc_S_I()
{
  {
    init_simple_test("Uc_S_I");
    STRUCT_IF_C Uc_S_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_I)");
    check_field_offset(lv, v1, 0, "Uc_S_I.v1");
    check_field_offset(lv, v2, 2, "Uc_S_I.v2");
    check_field_offset(lv, v3, 4, "Uc_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_I, Uc_S_I)
//============================================================================


struct  Uc_S_Ip  {
  unsigned char v1;
  short v2;
  int *v3;
};
//SIG(1 Uc_S_Ip) C1{ Fc Fs Fp}



static void Test_Uc_S_Ip()
{
  {
    init_simple_test("Uc_S_Ip");
    STRUCT_IF_C Uc_S_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_S_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_Ip)");
    check_field_offset(lv, v1, 0, "Uc_S_Ip.v1");
    check_field_offset(lv, v2, 2, "Uc_S_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_Ip, Uc_S_Ip)
//============================================================================


struct  Uc_S_L  {
  unsigned char v1;
  short v2;
  __tsi64 v3;
};
//SIG(1 Uc_S_L) C1{ Fc Fs FL}



static void Test_Uc_S_L()
{
  {
    init_simple_test("Uc_S_L");
    STRUCT_IF_C Uc_S_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_S_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_L)");
    check_field_offset(lv, v1, 0, "Uc_S_L.v1");
    check_field_offset(lv, v2, 2, "Uc_S_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_L, Uc_S_L)
//============================================================================


struct  Uc_S_S  {
  unsigned char v1;
  short v2;
  short v3;
};
//SIG(1 Uc_S_S) C1{ Fc Fs[2]}



static void Test_Uc_S_S()
{
  {
    init_simple_test("Uc_S_S");
    STRUCT_IF_C Uc_S_S lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_S)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_S)");
    check_field_offset(lv, v1, 0, "Uc_S_S.v1");
    check_field_offset(lv, v2, 2, "Uc_S_S.v2");
    check_field_offset(lv, v3, 4, "Uc_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_S, Uc_S_S)
//============================================================================


struct  Uc_S_Uc  {
  unsigned char v1;
  short v2;
  unsigned char v3;
};
//SIG(1 Uc_S_Uc) C1{ Fc Fs Fc}



static void Test_Uc_S_Uc()
{
  {
    init_simple_test("Uc_S_Uc");
    STRUCT_IF_C Uc_S_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_Uc)");
    check_field_offset(lv, v1, 0, "Uc_S_Uc.v1");
    check_field_offset(lv, v2, 2, "Uc_S_Uc.v2");
    check_field_offset(lv, v3, 4, "Uc_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_Uc, Uc_S_Uc)
//============================================================================


struct  Uc_S_Ui  {
  unsigned char v1;
  short v2;
  unsigned int v3;
};
//SIG(1 Uc_S_Ui) C1{ Fc Fs Fi}



static void Test_Uc_S_Ui()
{
  {
    init_simple_test("Uc_S_Ui");
    STRUCT_IF_C Uc_S_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_S_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_S_Ui)");
    check_field_offset(lv, v1, 0, "Uc_S_Ui.v1");
    check_field_offset(lv, v2, 2, "Uc_S_Ui.v2");
    check_field_offset(lv, v3, 4, "Uc_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_Ui, Uc_S_Ui)
//============================================================================


struct  Uc_S_Ul  {
  unsigned char v1;
  short v2;
  __tsu64 v3;
};
//SIG(1 Uc_S_Ul) C1{ Fc Fs FL}



static void Test_Uc_S_Ul()
{
  {
    init_simple_test("Uc_S_Ul");
    STRUCT_IF_C Uc_S_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_S_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_Ul)");
    check_field_offset(lv, v1, 0, "Uc_S_Ul.v1");
    check_field_offset(lv, v2, 2, "Uc_S_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_Ul, Uc_S_Ul)
//============================================================================


struct  Uc_S_Us  {
  unsigned char v1;
  short v2;
  unsigned short v3;
};
//SIG(1 Uc_S_Us) C1{ Fc Fs[2]}



static void Test_Uc_S_Us()
{
  {
    init_simple_test("Uc_S_Us");
    STRUCT_IF_C Uc_S_Us lv;
    check2(sizeof(lv), 6, "sizeof(Uc_S_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_Us)");
    check_field_offset(lv, v1, 0, "Uc_S_Us.v1");
    check_field_offset(lv, v2, 2, "Uc_S_Us.v2");
    check_field_offset(lv, v3, 4, "Uc_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_Us, Uc_S_Us)
//============================================================================


struct  Uc_S_Vp  {
  unsigned char v1;
  short v2;
  void *v3;
};
//SIG(1 Uc_S_Vp) C1{ Fc Fs Fp}



static void Test_Uc_S_Vp()
{
  {
    init_simple_test("Uc_S_Vp");
    STRUCT_IF_C Uc_S_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_S_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_S_Vp)");
    check_field_offset(lv, v1, 0, "Uc_S_Vp.v1");
    check_field_offset(lv, v2, 2, "Uc_S_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_S_Vp, Uc_S_Vp)
//============================================================================


struct  Uc_Uc  {
  unsigned char v1;
  unsigned char v2;
};
//SIG(1 Uc_Uc) C1{ Fc[2]}



static void Test_Uc_Uc()
{
  {
    init_simple_test("Uc_Uc");
    STRUCT_IF_C Uc_Uc lv;
    check2(sizeof(lv), 2, "sizeof(Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Uc)");
    check_field_offset(lv, v1, 0, "Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc, Uc_Uc)
//============================================================================


struct  Uc_Uc_BFu15i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:15;
};
//SIG(1 Uc_Uc_BFu15i) C1{ Fc[2] Fi:15}



static void Test_Uc_Uc_BFu15i()
{
  {
    init_simple_test("Uc_Uc_BFu15i");
    static STRUCT_IF_C Uc_Uc_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_Uc_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu15i, Uc_Uc_BFu15i)
//============================================================================


struct  Uc_Uc_BFu15ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_Uc_BFu15ll) C1{ Fc[2] FL:15}



static void Test_Uc_Uc_BFu15ll()
{
  {
    init_simple_test("Uc_Uc_BFu15ll");
    static STRUCT_IF_C Uc_Uc_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_Uc_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu15ll, Uc_Uc_BFu15ll)
//============================================================================


struct  Uc_Uc_BFu15s  {
  unsigned char v1;
  unsigned char v2;
  unsigned short v3:15;
};
//SIG(1 Uc_Uc_BFu15s) C1{ Fc[2] Fs:15}



static void Test_Uc_Uc_BFu15s()
{
  {
    init_simple_test("Uc_Uc_BFu15s");
    static STRUCT_IF_C Uc_Uc_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_Uc_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu15s, Uc_Uc_BFu15s)
//============================================================================


struct  Uc_Uc_BFu16i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:16;
};
//SIG(1 Uc_Uc_BFu16i) C1{ Fc[2] Fi:16}



static void Test_Uc_Uc_BFu16i()
{
  {
    init_simple_test("Uc_Uc_BFu16i");
    static STRUCT_IF_C Uc_Uc_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_Uc_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu16i, Uc_Uc_BFu16i)
//============================================================================


struct  Uc_Uc_BFu16ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_Uc_BFu16ll) C1{ Fc[2] FL:16}



static void Test_Uc_Uc_BFu16ll()
{
  {
    init_simple_test("Uc_Uc_BFu16ll");
    static STRUCT_IF_C Uc_Uc_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_Uc_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu16ll, Uc_Uc_BFu16ll)
//============================================================================


struct  Uc_Uc_BFu16s  {
  unsigned char v1;
  unsigned char v2;
  unsigned short v3:16;
};
//SIG(1 Uc_Uc_BFu16s) C1{ Fc[2] Fs:16}



static void Test_Uc_Uc_BFu16s()
{
  {
    init_simple_test("Uc_Uc_BFu16s");
    static STRUCT_IF_C Uc_Uc_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_Uc_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu16s, Uc_Uc_BFu16s)
//============================================================================


struct  Uc_Uc_BFu17i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:17;
};
//SIG(1 Uc_Uc_BFu17i) C1{ Fc[2] Fi:17}



static void Test_Uc_Uc_BFu17i()
{
  {
    init_simple_test("Uc_Uc_BFu17i");
    static STRUCT_IF_C Uc_Uc_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Uc_Uc_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Uc_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu17i, Uc_Uc_BFu17i)
//============================================================================


struct  Uc_Uc_BFu17ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_Uc_BFu17ll) C1{ Fc[2] FL:17}



static void Test_Uc_Uc_BFu17ll()
{
  {
    init_simple_test("Uc_Uc_BFu17ll");
    static STRUCT_IF_C Uc_Uc_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu17ll, Uc_Uc_BFu17ll)
//============================================================================


struct  Uc_Uc_BFu1c  {
  unsigned char v1;
  unsigned char v2;
  unsigned char v3:1;
};
//SIG(1 Uc_Uc_BFu1c) C1{ Fc[2] Fc:1}



static void Test_Uc_Uc_BFu1c()
{
  {
    init_simple_test("Uc_Uc_BFu1c");
    static STRUCT_IF_C Uc_Uc_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu1c, Uc_Uc_BFu1c)
//============================================================================


struct  Uc_Uc_BFu1i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:1;
};
//SIG(1 Uc_Uc_BFu1i) C1{ Fc[2] Fi:1}



static void Test_Uc_Uc_BFu1i()
{
  {
    init_simple_test("Uc_Uc_BFu1i");
    static STRUCT_IF_C Uc_Uc_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu1i, Uc_Uc_BFu1i)
//============================================================================


struct  Uc_Uc_BFu1ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_Uc_BFu1ll) C1{ Fc[2] FL:1}



static void Test_Uc_Uc_BFu1ll()
{
  {
    init_simple_test("Uc_Uc_BFu1ll");
    static STRUCT_IF_C Uc_Uc_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_Uc_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu1ll, Uc_Uc_BFu1ll)
//============================================================================


struct  Uc_Uc_BFu1s  {
  unsigned char v1;
  unsigned char v2;
  unsigned short v3:1;
};
//SIG(1 Uc_Uc_BFu1s) C1{ Fc[2] Fs:1}



static void Test_Uc_Uc_BFu1s()
{
  {
    init_simple_test("Uc_Uc_BFu1s");
    static STRUCT_IF_C Uc_Uc_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu1s, Uc_Uc_BFu1s)
//============================================================================


struct  Uc_Uc_BFu31i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:31;
};
//SIG(1 Uc_Uc_BFu31i) C1{ Fc[2] Fi:31}



static void Test_Uc_Uc_BFu31i()
{
  {
    init_simple_test("Uc_Uc_BFu31i");
    static STRUCT_IF_C Uc_Uc_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Uc_Uc_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Uc_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu31i, Uc_Uc_BFu31i)
//============================================================================


struct  Uc_Uc_BFu31ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_Uc_BFu31ll) C1{ Fc[2] FL:31}



static void Test_Uc_Uc_BFu31ll()
{
  {
    init_simple_test("Uc_Uc_BFu31ll");
    static STRUCT_IF_C Uc_Uc_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu31ll, Uc_Uc_BFu31ll)
//============================================================================


struct  Uc_Uc_BFu32i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:32;
};
//SIG(1 Uc_Uc_BFu32i) C1{ Fc[2] Fi:32}



static void Test_Uc_Uc_BFu32i()
{
  {
    init_simple_test("Uc_Uc_BFu32i");
    static STRUCT_IF_C Uc_Uc_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Uc_Uc_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Uc_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu32i, Uc_Uc_BFu32i)
//============================================================================


struct  Uc_Uc_BFu32ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_Uc_BFu32ll) C1{ Fc[2] FL:32}



static void Test_Uc_Uc_BFu32ll()
{
  {
    init_simple_test("Uc_Uc_BFu32ll");
    static STRUCT_IF_C Uc_Uc_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu32ll, Uc_Uc_BFu32ll)
//============================================================================


struct  Uc_Uc_BFu33  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_Uc_BFu33) C1{ Fc[2] FL:33}



static void Test_Uc_Uc_BFu33()
{
  {
    init_simple_test("Uc_Uc_BFu33");
    static STRUCT_IF_C Uc_Uc_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu33.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Uc_Uc_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Uc_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu33, Uc_Uc_BFu33)
//============================================================================


struct  Uc_Uc_BFu7c  {
  unsigned char v1;
  unsigned char v2;
  unsigned char v3:7;
};
//SIG(1 Uc_Uc_BFu7c) C1{ Fc[2] Fc:7}



static void Test_Uc_Uc_BFu7c()
{
  {
    init_simple_test("Uc_Uc_BFu7c");
    static STRUCT_IF_C Uc_Uc_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_Uc_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu7c, Uc_Uc_BFu7c)
//============================================================================


struct  Uc_Uc_BFu7i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:7;
};
//SIG(1 Uc_Uc_BFu7i) C1{ Fc[2] Fi:7}



static void Test_Uc_Uc_BFu7i()
{
  {
    init_simple_test("Uc_Uc_BFu7i");
    static STRUCT_IF_C Uc_Uc_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_Uc_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu7i, Uc_Uc_BFu7i)
//============================================================================


struct  Uc_Uc_BFu7ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_Uc_BFu7ll) C1{ Fc[2] FL:7}



static void Test_Uc_Uc_BFu7ll()
{
  {
    init_simple_test("Uc_Uc_BFu7ll");
    static STRUCT_IF_C Uc_Uc_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_Uc_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu7ll, Uc_Uc_BFu7ll)
//============================================================================


struct  Uc_Uc_BFu7s  {
  unsigned char v1;
  unsigned char v2;
  unsigned short v3:7;
};
//SIG(1 Uc_Uc_BFu7s) C1{ Fc[2] Fs:7}



static void Test_Uc_Uc_BFu7s()
{
  {
    init_simple_test("Uc_Uc_BFu7s");
    static STRUCT_IF_C Uc_Uc_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_Uc_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu7s, Uc_Uc_BFu7s)
//============================================================================


struct  Uc_Uc_BFu8c  {
  unsigned char v1;
  unsigned char v2;
  unsigned char v3:8;
};
//SIG(1 Uc_Uc_BFu8c) C1{ Fc[2] Fc:8}



static void Test_Uc_Uc_BFu8c()
{
  {
    init_simple_test("Uc_Uc_BFu8c");
    static STRUCT_IF_C Uc_Uc_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_Uc_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu8c, Uc_Uc_BFu8c)
//============================================================================


struct  Uc_Uc_BFu8i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:8;
};
//SIG(1 Uc_Uc_BFu8i) C1{ Fc[2] Fi:8}



static void Test_Uc_Uc_BFu8i()
{
  {
    init_simple_test("Uc_Uc_BFu8i");
    static STRUCT_IF_C Uc_Uc_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_Uc_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu8i, Uc_Uc_BFu8i)
//============================================================================


struct  Uc_Uc_BFu8ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_Uc_BFu8ll) C1{ Fc[2] FL:8}



static void Test_Uc_Uc_BFu8ll()
{
  {
    init_simple_test("Uc_Uc_BFu8ll");
    static STRUCT_IF_C Uc_Uc_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_Uc_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu8ll, Uc_Uc_BFu8ll)
//============================================================================


struct  Uc_Uc_BFu8s  {
  unsigned char v1;
  unsigned char v2;
  unsigned short v3:8;
};
//SIG(1 Uc_Uc_BFu8s) C1{ Fc[2] Fs:8}



static void Test_Uc_Uc_BFu8s()
{
  {
    init_simple_test("Uc_Uc_BFu8s");
    static STRUCT_IF_C Uc_Uc_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_Uc_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu8s, Uc_Uc_BFu8s)
//============================================================================


struct  Uc_Uc_BFu9i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3:9;
};
//SIG(1 Uc_Uc_BFu9i) C1{ Fc[2] Fi:9}



static void Test_Uc_Uc_BFu9i()
{
  {
    init_simple_test("Uc_Uc_BFu9i");
    static STRUCT_IF_C Uc_Uc_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_Uc_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu9i, Uc_Uc_BFu9i)
//============================================================================


struct  Uc_Uc_BFu9ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_Uc_BFu9ll) C1{ Fc[2] FL:9}



static void Test_Uc_Uc_BFu9ll()
{
  {
    init_simple_test("Uc_Uc_BFu9ll");
    static STRUCT_IF_C Uc_Uc_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_Uc_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu9ll, Uc_Uc_BFu9ll)
//============================================================================


struct  Uc_Uc_BFu9s  {
  unsigned char v1;
  unsigned char v2;
  unsigned short v3:9;
};
//SIG(1 Uc_Uc_BFu9s) C1{ Fc[2] Fs:9}



static void Test_Uc_Uc_BFu9s()
{
  {
    init_simple_test("Uc_Uc_BFu9s");
    static STRUCT_IF_C Uc_Uc_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_Uc_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_BFu9s, Uc_Uc_BFu9s)
//============================================================================


struct  Uc_Uc_C  {
  unsigned char v1;
  unsigned char v2;
  char v3;
};
//SIG(1 Uc_Uc_C) C1{ Fc[3]}



static void Test_Uc_Uc_C()
{
  {
    init_simple_test("Uc_Uc_C");
    STRUCT_IF_C Uc_Uc_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Uc_C)");
    check_field_offset(lv, v1, 0, "Uc_Uc_C.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_C.v2");
    check_field_offset(lv, v3, 2, "Uc_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_C, Uc_Uc_C)
//============================================================================


struct  Uc_Uc_D  {
  unsigned char v1;
  unsigned char v2;
  double v3;
};
//SIG(1 Uc_Uc_D) C1{ Fc[2] FL}



static void Test_Uc_Uc_D()
{
  {
    init_simple_test("Uc_Uc_D");
    STRUCT_IF_C Uc_Uc_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Uc_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_D)");
    check_field_offset(lv, v1, 0, "Uc_Uc_D.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_D, Uc_Uc_D)
//============================================================================


struct  Uc_Uc_F  {
  unsigned char v1;
  unsigned char v2;
  float v3;
};
//SIG(1 Uc_Uc_F) C1{ Fc[2] Fi}



static void Test_Uc_Uc_F()
{
  {
    init_simple_test("Uc_Uc_F");
    STRUCT_IF_C Uc_Uc_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_F)");
    check_field_offset(lv, v1, 0, "Uc_Uc_F.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_F.v2");
    check_field_offset(lv, v3, 4, "Uc_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_F, Uc_Uc_F)
//============================================================================


struct  Uc_Uc_I  {
  unsigned char v1;
  unsigned char v2;
  int v3;
};
//SIG(1 Uc_Uc_I) C1{ Fc[2] Fi}



static void Test_Uc_Uc_I()
{
  {
    init_simple_test("Uc_Uc_I");
    STRUCT_IF_C Uc_Uc_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_I)");
    check_field_offset(lv, v1, 0, "Uc_Uc_I.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_I.v2");
    check_field_offset(lv, v3, 4, "Uc_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_I, Uc_Uc_I)
//============================================================================


struct  Uc_Uc_Ip  {
  unsigned char v1;
  unsigned char v2;
  int *v3;
};
//SIG(1 Uc_Uc_Ip) C1{ Fc[2] Fp}



static void Test_Uc_Uc_Ip()
{
  {
    init_simple_test("Uc_Uc_Ip");
    STRUCT_IF_C Uc_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Uc_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Uc_Ip.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_Ip, Uc_Uc_Ip)
//============================================================================


struct  Uc_Uc_L  {
  unsigned char v1;
  unsigned char v2;
  __tsi64 v3;
};
//SIG(1 Uc_Uc_L) C1{ Fc[2] FL}



static void Test_Uc_Uc_L()
{
  {
    init_simple_test("Uc_Uc_L");
    STRUCT_IF_C Uc_Uc_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Uc_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_L)");
    check_field_offset(lv, v1, 0, "Uc_Uc_L.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_L, Uc_Uc_L)
//============================================================================


struct  Uc_Uc_S  {
  unsigned char v1;
  unsigned char v2;
  short v3;
};
//SIG(1 Uc_Uc_S) C1{ Fc[2] Fs}



static void Test_Uc_Uc_S()
{
  {
    init_simple_test("Uc_Uc_S");
    STRUCT_IF_C Uc_Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_S)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Uc_S)");
    check_field_offset(lv, v1, 0, "Uc_Uc_S.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_S.v2");
    check_field_offset(lv, v3, 2, "Uc_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_S, Uc_Uc_S)
//============================================================================


struct  Uc_Uc_Uc  {
  unsigned char v1;
  unsigned char v2;
  unsigned char v3;
};
//SIG(1 Uc_Uc_Uc) C1{ Fc[3]}



static void Test_Uc_Uc_Uc()
{
  {
    init_simple_test("Uc_Uc_Uc");
    STRUCT_IF_C Uc_Uc_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Uc_Uc)");
    check_field_offset(lv, v1, 0, "Uc_Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_Uc.v2");
    check_field_offset(lv, v3, 2, "Uc_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_Uc, Uc_Uc_Uc)
//============================================================================


struct  Uc_Uc_Ui  {
  unsigned char v1;
  unsigned char v2;
  unsigned int v3;
};
//SIG(1 Uc_Uc_Ui) C1{ Fc[2] Fi}



static void Test_Uc_Uc_Ui()
{
  {
    init_simple_test("Uc_Uc_Ui");
    STRUCT_IF_C Uc_Uc_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Uc_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Uc_Ui)");
    check_field_offset(lv, v1, 0, "Uc_Uc_Ui.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_Ui.v2");
    check_field_offset(lv, v3, 4, "Uc_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_Ui, Uc_Uc_Ui)
//============================================================================


struct  Uc_Uc_Ul  {
  unsigned char v1;
  unsigned char v2;
  __tsu64 v3;
};
//SIG(1 Uc_Uc_Ul) C1{ Fc[2] FL}



static void Test_Uc_Uc_Ul()
{
  {
    init_simple_test("Uc_Uc_Ul");
    STRUCT_IF_C Uc_Uc_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Uc_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_Ul)");
    check_field_offset(lv, v1, 0, "Uc_Uc_Ul.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_Ul, Uc_Uc_Ul)
//============================================================================


struct  Uc_Uc_Us  {
  unsigned char v1;
  unsigned char v2;
  unsigned short v3;
};
//SIG(1 Uc_Uc_Us) C1{ Fc[2] Fs}



static void Test_Uc_Uc_Us()
{
  {
    init_simple_test("Uc_Uc_Us");
    STRUCT_IF_C Uc_Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Uc_Us)");
    check_field_offset(lv, v1, 0, "Uc_Uc_Us.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_Us.v2");
    check_field_offset(lv, v3, 2, "Uc_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_Us, Uc_Uc_Us)
//============================================================================


struct  Uc_Uc_Vp  {
  unsigned char v1;
  unsigned char v2;
  void *v3;
};
//SIG(1 Uc_Uc_Vp) C1{ Fc[2] Fp}



static void Test_Uc_Uc_Vp()
{
  {
    init_simple_test("Uc_Uc_Vp");
    STRUCT_IF_C Uc_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Uc_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Uc_Vp)");
    check_field_offset(lv, v1, 0, "Uc_Uc_Vp.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Uc_Vp, Uc_Uc_Vp)
//============================================================================


struct  Uc_Ui  {
  unsigned char v1;
  unsigned int v2;
};
//SIG(1 Uc_Ui) C1{ Fc Fi}



static void Test_Uc_Ui()
{
  {
    init_simple_test("Uc_Ui");
    STRUCT_IF_C Uc_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui)");
    check_field_offset(lv, v1, 0, "Uc_Ui.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui, Uc_Ui)
//============================================================================


struct  Uc_Ui_BFu15i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:15;
};
//SIG(1 Uc_Ui_BFu15i) C1{ Fc Fi Fi:15}



static void Test_Uc_Ui_BFu15i()
{
  {
    init_simple_test("Uc_Ui_BFu15i");
    static STRUCT_IF_C Uc_Ui_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_Ui_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu15i, Uc_Ui_BFu15i)
//============================================================================


struct  Uc_Ui_BFu15ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_Ui_BFu15ll) C1{ Fc Fi FL:15}



static void Test_Uc_Ui_BFu15ll()
{
  {
    init_simple_test("Uc_Ui_BFu15ll");
    static STRUCT_IF_C Uc_Ui_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu15ll, Uc_Ui_BFu15ll)
//============================================================================


struct  Uc_Ui_BFu15s  {
  unsigned char v1;
  unsigned int v2;
  unsigned short v3:15;
};
//SIG(1 Uc_Ui_BFu15s) C1{ Fc Fi Fs:15}



static void Test_Uc_Ui_BFu15s()
{
  {
    init_simple_test("Uc_Ui_BFu15s");
    static STRUCT_IF_C Uc_Ui_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Uc_Ui_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Uc_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu15s, Uc_Ui_BFu15s)
//============================================================================


struct  Uc_Ui_BFu16i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:16;
};
//SIG(1 Uc_Ui_BFu16i) C1{ Fc Fi Fi:16}



static void Test_Uc_Ui_BFu16i()
{
  {
    init_simple_test("Uc_Ui_BFu16i");
    static STRUCT_IF_C Uc_Ui_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_Ui_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu16i, Uc_Ui_BFu16i)
//============================================================================


struct  Uc_Ui_BFu16ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_Ui_BFu16ll) C1{ Fc Fi FL:16}



static void Test_Uc_Ui_BFu16ll()
{
  {
    init_simple_test("Uc_Ui_BFu16ll");
    static STRUCT_IF_C Uc_Ui_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu16ll, Uc_Ui_BFu16ll)
//============================================================================


struct  Uc_Ui_BFu16s  {
  unsigned char v1;
  unsigned int v2;
  unsigned short v3:16;
};
//SIG(1 Uc_Ui_BFu16s) C1{ Fc Fi Fs:16}



static void Test_Uc_Ui_BFu16s()
{
  {
    init_simple_test("Uc_Ui_BFu16s");
    static STRUCT_IF_C Uc_Ui_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Uc_Ui_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Uc_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu16s, Uc_Ui_BFu16s)
//============================================================================


struct  Uc_Ui_BFu17i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:17;
};
//SIG(1 Uc_Ui_BFu17i) C1{ Fc Fi Fi:17}



static void Test_Uc_Ui_BFu17i()
{
  {
    init_simple_test("Uc_Ui_BFu17i");
    static STRUCT_IF_C Uc_Ui_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Uc_Ui_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Uc_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu17i, Uc_Ui_BFu17i)
//============================================================================


struct  Uc_Ui_BFu17ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_Ui_BFu17ll) C1{ Fc Fi FL:17}



static void Test_Uc_Ui_BFu17ll()
{
  {
    init_simple_test("Uc_Ui_BFu17ll");
    static STRUCT_IF_C Uc_Ui_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Uc_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Uc_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu17ll, Uc_Ui_BFu17ll)
//============================================================================


struct  Uc_Ui_BFu1c  {
  unsigned char v1;
  unsigned int v2;
  unsigned char v3:1;
};
//SIG(1 Uc_Ui_BFu1c) C1{ Fc Fi Fc:1}



static void Test_Uc_Ui_BFu1c()
{
  {
    init_simple_test("Uc_Ui_BFu1c");
    static STRUCT_IF_C Uc_Ui_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu1c, Uc_Ui_BFu1c)
//============================================================================


struct  Uc_Ui_BFu1i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:1;
};
//SIG(1 Uc_Ui_BFu1i) C1{ Fc Fi Fi:1}



static void Test_Uc_Ui_BFu1i()
{
  {
    init_simple_test("Uc_Ui_BFu1i");
    static STRUCT_IF_C Uc_Ui_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu1i, Uc_Ui_BFu1i)
//============================================================================


struct  Uc_Ui_BFu1ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_Ui_BFu1ll) C1{ Fc Fi FL:1}



static void Test_Uc_Ui_BFu1ll()
{
  {
    init_simple_test("Uc_Ui_BFu1ll");
    static STRUCT_IF_C Uc_Ui_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu1ll, Uc_Ui_BFu1ll)
//============================================================================


struct  Uc_Ui_BFu1s  {
  unsigned char v1;
  unsigned int v2;
  unsigned short v3:1;
};
//SIG(1 Uc_Ui_BFu1s) C1{ Fc Fi Fs:1}



static void Test_Uc_Ui_BFu1s()
{
  {
    init_simple_test("Uc_Ui_BFu1s");
    static STRUCT_IF_C Uc_Ui_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Uc_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu1s, Uc_Ui_BFu1s)
//============================================================================


struct  Uc_Ui_BFu31i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:31;
};
//SIG(1 Uc_Ui_BFu31i) C1{ Fc Fi Fi:31}



static void Test_Uc_Ui_BFu31i()
{
  {
    init_simple_test("Uc_Ui_BFu31i");
    static STRUCT_IF_C Uc_Ui_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Uc_Ui_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Uc_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu31i, Uc_Ui_BFu31i)
//============================================================================


struct  Uc_Ui_BFu31ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_Ui_BFu31ll) C1{ Fc Fi FL:31}



static void Test_Uc_Ui_BFu31ll()
{
  {
    init_simple_test("Uc_Ui_BFu31ll");
    static STRUCT_IF_C Uc_Ui_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Uc_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Uc_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu31ll, Uc_Ui_BFu31ll)
//============================================================================


struct  Uc_Ui_BFu32i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:32;
};
//SIG(1 Uc_Ui_BFu32i) C1{ Fc Fi Fi:32}



static void Test_Uc_Ui_BFu32i()
{
  {
    init_simple_test("Uc_Ui_BFu32i");
    static STRUCT_IF_C Uc_Ui_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Uc_Ui_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Uc_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu32i, Uc_Ui_BFu32i)
//============================================================================


struct  Uc_Ui_BFu32ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_Ui_BFu32ll) C1{ Fc Fi FL:32}



static void Test_Uc_Ui_BFu32ll()
{
  {
    init_simple_test("Uc_Ui_BFu32ll");
    static STRUCT_IF_C Uc_Ui_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Uc_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Uc_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu32ll, Uc_Ui_BFu32ll)
//============================================================================


struct  Uc_Ui_BFu33  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_Ui_BFu33) C1{ Fc Fi FL:33}



static void Test_Uc_Ui_BFu33()
{
  {
    init_simple_test("Uc_Ui_BFu33");
    static STRUCT_IF_C Uc_Ui_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Uc_Ui_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu33.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "Uc_Ui_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "Uc_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu33, Uc_Ui_BFu33)
//============================================================================


struct  Uc_Ui_BFu7c  {
  unsigned char v1;
  unsigned int v2;
  unsigned char v3:7;
};
//SIG(1 Uc_Ui_BFu7c) C1{ Fc Fi Fc:7}



static void Test_Uc_Ui_BFu7c()
{
  {
    init_simple_test("Uc_Ui_BFu7c");
    static STRUCT_IF_C Uc_Ui_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_Ui_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu7c, Uc_Ui_BFu7c)
//============================================================================


struct  Uc_Ui_BFu7i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:7;
};
//SIG(1 Uc_Ui_BFu7i) C1{ Fc Fi Fi:7}



static void Test_Uc_Ui_BFu7i()
{
  {
    init_simple_test("Uc_Ui_BFu7i");
    static STRUCT_IF_C Uc_Ui_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_Ui_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu7i, Uc_Ui_BFu7i)
//============================================================================


struct  Uc_Ui_BFu7ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_Ui_BFu7ll) C1{ Fc Fi FL:7}



static void Test_Uc_Ui_BFu7ll()
{
  {
    init_simple_test("Uc_Ui_BFu7ll");
    static STRUCT_IF_C Uc_Ui_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu7ll, Uc_Ui_BFu7ll)
//============================================================================


struct  Uc_Ui_BFu7s  {
  unsigned char v1;
  unsigned int v2;
  unsigned short v3:7;
};
//SIG(1 Uc_Ui_BFu7s) C1{ Fc Fi Fs:7}



static void Test_Uc_Ui_BFu7s()
{
  {
    init_simple_test("Uc_Ui_BFu7s");
    static STRUCT_IF_C Uc_Ui_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Uc_Ui_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Uc_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu7s, Uc_Ui_BFu7s)
//============================================================================


struct  Uc_Ui_BFu8c  {
  unsigned char v1;
  unsigned int v2;
  unsigned char v3:8;
};
//SIG(1 Uc_Ui_BFu8c) C1{ Fc Fi Fc:8}



static void Test_Uc_Ui_BFu8c()
{
  {
    init_simple_test("Uc_Ui_BFu8c");
    static STRUCT_IF_C Uc_Ui_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_Ui_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu8c, Uc_Ui_BFu8c)
//============================================================================


struct  Uc_Ui_BFu8i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:8;
};
//SIG(1 Uc_Ui_BFu8i) C1{ Fc Fi Fi:8}



static void Test_Uc_Ui_BFu8i()
{
  {
    init_simple_test("Uc_Ui_BFu8i");
    static STRUCT_IF_C Uc_Ui_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_Ui_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu8i, Uc_Ui_BFu8i)
//============================================================================


struct  Uc_Ui_BFu8ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_Ui_BFu8ll) C1{ Fc Fi FL:8}



static void Test_Uc_Ui_BFu8ll()
{
  {
    init_simple_test("Uc_Ui_BFu8ll");
    static STRUCT_IF_C Uc_Ui_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu8ll, Uc_Ui_BFu8ll)
//============================================================================


struct  Uc_Ui_BFu8s  {
  unsigned char v1;
  unsigned int v2;
  unsigned short v3:8;
};
//SIG(1 Uc_Ui_BFu8s) C1{ Fc Fi Fs:8}



static void Test_Uc_Ui_BFu8s()
{
  {
    init_simple_test("Uc_Ui_BFu8s");
    static STRUCT_IF_C Uc_Ui_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Uc_Ui_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Uc_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu8s, Uc_Ui_BFu8s)
//============================================================================


struct  Uc_Ui_BFu9i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3:9;
};
//SIG(1 Uc_Ui_BFu9i) C1{ Fc Fi Fi:9}



static void Test_Uc_Ui_BFu9i()
{
  {
    init_simple_test("Uc_Ui_BFu9i");
    static STRUCT_IF_C Uc_Ui_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_Ui_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu9i, Uc_Ui_BFu9i)
//============================================================================


struct  Uc_Ui_BFu9ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_Ui_BFu9ll) C1{ Fc Fi FL:9}



static void Test_Uc_Ui_BFu9ll()
{
  {
    init_simple_test("Uc_Ui_BFu9ll");
    static STRUCT_IF_C Uc_Ui_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu9ll, Uc_Ui_BFu9ll)
//============================================================================


struct  Uc_Ui_BFu9s  {
  unsigned char v1;
  unsigned int v2;
  unsigned short v3:9;
};
//SIG(1 Uc_Ui_BFu9s) C1{ Fc Fi Fs:9}



static void Test_Uc_Ui_BFu9s()
{
  {
    init_simple_test("Uc_Ui_BFu9s");
    static STRUCT_IF_C Uc_Ui_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Uc_Ui_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Uc_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_BFu9s, Uc_Ui_BFu9s)
//============================================================================


struct  Uc_Ui_C  {
  unsigned char v1;
  unsigned int v2;
  char v3;
};
//SIG(1 Uc_Ui_C) C1{ Fc Fi Fc}



static void Test_Uc_Ui_C()
{
  {
    init_simple_test("Uc_Ui_C");
    STRUCT_IF_C Uc_Ui_C lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_C)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_C)");
    check_field_offset(lv, v1, 0, "Uc_Ui_C.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_C.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_C, Uc_Ui_C)
//============================================================================


struct  Uc_Ui_D  {
  unsigned char v1;
  unsigned int v2;
  double v3;
};
//SIG(1 Uc_Ui_D) C1{ Fc Fi FL}



static void Test_Uc_Ui_D()
{
  {
    init_simple_test("Uc_Ui_D");
    STRUCT_IF_C Uc_Ui_D lv;
    check2(sizeof(lv), 16, "sizeof(Uc_Ui_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_D)");
    check_field_offset(lv, v1, 0, "Uc_Ui_D.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_D.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_D, Uc_Ui_D)
//============================================================================


struct  Uc_Ui_F  {
  unsigned char v1;
  unsigned int v2;
  float v3;
};
//SIG(1 Uc_Ui_F) C1{ Fc Fi[2]}



static void Test_Uc_Ui_F()
{
  {
    init_simple_test("Uc_Ui_F");
    STRUCT_IF_C Uc_Ui_F lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_F)");
    check_field_offset(lv, v1, 0, "Uc_Ui_F.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_F.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_F, Uc_Ui_F)
//============================================================================


struct  Uc_Ui_I  {
  unsigned char v1;
  unsigned int v2;
  int v3;
};
//SIG(1 Uc_Ui_I) C1{ Fc Fi[2]}



static void Test_Uc_Ui_I()
{
  {
    init_simple_test("Uc_Ui_I");
    STRUCT_IF_C Uc_Ui_I lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_I)");
    check_field_offset(lv, v1, 0, "Uc_Ui_I.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_I.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_I, Uc_Ui_I)
//============================================================================


struct  Uc_Ui_Ip  {
  unsigned char v1;
  unsigned int v2;
  int *v3;
};
//SIG(1 Uc_Ui_Ip) C1{ Fc Fi Fp}



static void Test_Uc_Ui_Ip()
{
  {
    init_simple_test("Uc_Ui_Ip");
    STRUCT_IF_C Uc_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Ui_Ip.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_Ip.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_Ip, Uc_Ui_Ip)
//============================================================================


struct  Uc_Ui_L  {
  unsigned char v1;
  unsigned int v2;
  __tsi64 v3;
};
//SIG(1 Uc_Ui_L) C1{ Fc Fi FL}



static void Test_Uc_Ui_L()
{
  {
    init_simple_test("Uc_Ui_L");
    STRUCT_IF_C Uc_Ui_L lv;
    check2(sizeof(lv), 16, "sizeof(Uc_Ui_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_L)");
    check_field_offset(lv, v1, 0, "Uc_Ui_L.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_L.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_L, Uc_Ui_L)
//============================================================================


struct  Uc_Ui_S  {
  unsigned char v1;
  unsigned int v2;
  short v3;
};
//SIG(1 Uc_Ui_S) C1{ Fc Fi Fs}



static void Test_Uc_Ui_S()
{
  {
    init_simple_test("Uc_Ui_S");
    STRUCT_IF_C Uc_Ui_S lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_S)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_S)");
    check_field_offset(lv, v1, 0, "Uc_Ui_S.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_S.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_S, Uc_Ui_S)
//============================================================================


struct  Uc_Ui_Uc  {
  unsigned char v1;
  unsigned int v2;
  unsigned char v3;
};
//SIG(1 Uc_Ui_Uc) C1{ Fc Fi Fc}



static void Test_Uc_Ui_Uc()
{
  {
    init_simple_test("Uc_Ui_Uc");
    STRUCT_IF_C Uc_Ui_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_Uc)");
    check_field_offset(lv, v1, 0, "Uc_Ui_Uc.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_Uc.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_Uc, Uc_Ui_Uc)
//============================================================================


struct  Uc_Ui_Ui  {
  unsigned char v1;
  unsigned int v2;
  unsigned int v3;
};
//SIG(1 Uc_Ui_Ui) C1{ Fc Fi[2]}



static void Test_Uc_Ui_Ui()
{
  {
    init_simple_test("Uc_Ui_Ui");
    STRUCT_IF_C Uc_Ui_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_Ui)");
    check_field_offset(lv, v1, 0, "Uc_Ui_Ui.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_Ui.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_Ui, Uc_Ui_Ui)
//============================================================================


struct  Uc_Ui_Ul  {
  unsigned char v1;
  unsigned int v2;
  __tsu64 v3;
};
//SIG(1 Uc_Ui_Ul) C1{ Fc Fi FL}



static void Test_Uc_Ui_Ul()
{
  {
    init_simple_test("Uc_Ui_Ul");
    STRUCT_IF_C Uc_Ui_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Uc_Ui_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_Ul)");
    check_field_offset(lv, v1, 0, "Uc_Ui_Ul.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_Ul.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_Ul, Uc_Ui_Ul)
//============================================================================


struct  Uc_Ui_Us  {
  unsigned char v1;
  unsigned int v2;
  unsigned short v3;
};
//SIG(1 Uc_Ui_Us) C1{ Fc Fi Fs}



static void Test_Uc_Ui_Us()
{
  {
    init_simple_test("Uc_Ui_Us");
    STRUCT_IF_C Uc_Ui_Us lv;
    check2(sizeof(lv), 12, "sizeof(Uc_Ui_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_Us)");
    check_field_offset(lv, v1, 0, "Uc_Ui_Us.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_Us.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_Us, Uc_Ui_Us)
//============================================================================


struct  Uc_Ui_Vp  {
  unsigned char v1;
  unsigned int v2;
  void *v3;
};
//SIG(1 Uc_Ui_Vp) C1{ Fc Fi Fp}



static void Test_Uc_Ui_Vp()
{
  {
    init_simple_test("Uc_Ui_Vp");
    STRUCT_IF_C Uc_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ui_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ui_Vp)");
    check_field_offset(lv, v1, 0, "Uc_Ui_Vp.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_Vp.v2");
    check_field_offset(lv, v3, 8, "Uc_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ui_Vp, Uc_Ui_Vp)
//============================================================================


struct  Uc_Ul  {
  unsigned char v1;
  __tsu64 v2;
};
//SIG(1 Uc_Ul) C1{ Fc FL}



static void Test_Uc_Ul()
{
  {
    init_simple_test("Uc_Ul");
    STRUCT_IF_C Uc_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul)");
    check_field_offset(lv, v1, 0, "Uc_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul, Uc_Ul)
//============================================================================


struct  Uc_Ul_BFu15i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:15;
};
//SIG(1 Uc_Ul_BFu15i) C1{ Fc FL Fi:15}



static void Test_Uc_Ul_BFu15i()
{
  {
    init_simple_test("Uc_Ul_BFu15i");
    static STRUCT_IF_C Uc_Ul_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Uc_Ul_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Uc_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu15i, Uc_Ul_BFu15i)
//============================================================================


struct  Uc_Ul_BFu15ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_Ul_BFu15ll) C1{ Fc FL FL:15}



static void Test_Uc_Ul_BFu15ll()
{
  {
    init_simple_test("Uc_Ul_BFu15ll");
    static STRUCT_IF_C Uc_Ul_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Uc_Ul_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Uc_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu15ll, Uc_Ul_BFu15ll)
//============================================================================


struct  Uc_Ul_BFu15s  {
  unsigned char v1;
  __tsu64 v2;
  unsigned short v3:15;
};
//SIG(1 Uc_Ul_BFu15s) C1{ Fc FL Fs:15}



static void Test_Uc_Ul_BFu15s()
{
  {
    init_simple_test("Uc_Ul_BFu15s");
    static STRUCT_IF_C Uc_Ul_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Uc_Ul_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Uc_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu15s, Uc_Ul_BFu15s)
//============================================================================


struct  Uc_Ul_BFu16i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:16;
};
//SIG(1 Uc_Ul_BFu16i) C1{ Fc FL Fi:16}



static void Test_Uc_Ul_BFu16i()
{
  {
    init_simple_test("Uc_Ul_BFu16i");
    static STRUCT_IF_C Uc_Ul_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Uc_Ul_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Uc_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu16i, Uc_Ul_BFu16i)
//============================================================================


struct  Uc_Ul_BFu16ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_Ul_BFu16ll) C1{ Fc FL FL:16}



static void Test_Uc_Ul_BFu16ll()
{
  {
    init_simple_test("Uc_Ul_BFu16ll");
    static STRUCT_IF_C Uc_Ul_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Uc_Ul_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Uc_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu16ll, Uc_Ul_BFu16ll)
//============================================================================


struct  Uc_Ul_BFu16s  {
  unsigned char v1;
  __tsu64 v2;
  unsigned short v3:16;
};
//SIG(1 Uc_Ul_BFu16s) C1{ Fc FL Fs:16}



static void Test_Uc_Ul_BFu16s()
{
  {
    init_simple_test("Uc_Ul_BFu16s");
    static STRUCT_IF_C Uc_Ul_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Uc_Ul_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Uc_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu16s, Uc_Ul_BFu16s)
//============================================================================


struct  Uc_Ul_BFu17i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:17;
};
//SIG(1 Uc_Ul_BFu17i) C1{ Fc FL Fi:17}



static void Test_Uc_Ul_BFu17i()
{
  {
    init_simple_test("Uc_Ul_BFu17i");
    static STRUCT_IF_C Uc_Ul_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Uc_Ul_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Uc_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu17i, Uc_Ul_BFu17i)
//============================================================================


struct  Uc_Ul_BFu17ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_Ul_BFu17ll) C1{ Fc FL FL:17}



static void Test_Uc_Ul_BFu17ll()
{
  {
    init_simple_test("Uc_Ul_BFu17ll");
    static STRUCT_IF_C Uc_Ul_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Uc_Ul_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Uc_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu17ll, Uc_Ul_BFu17ll)
//============================================================================


struct  Uc_Ul_BFu1c  {
  unsigned char v1;
  __tsu64 v2;
  unsigned char v3:1;
};
//SIG(1 Uc_Ul_BFu1c) C1{ Fc FL Fc:1}



static void Test_Uc_Ul_BFu1c()
{
  {
    init_simple_test("Uc_Ul_BFu1c");
    static STRUCT_IF_C Uc_Ul_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu1c, Uc_Ul_BFu1c)
//============================================================================


struct  Uc_Ul_BFu1i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:1;
};
//SIG(1 Uc_Ul_BFu1i) C1{ Fc FL Fi:1}



static void Test_Uc_Ul_BFu1i()
{
  {
    init_simple_test("Uc_Ul_BFu1i");
    static STRUCT_IF_C Uc_Ul_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu1i, Uc_Ul_BFu1i)
//============================================================================


struct  Uc_Ul_BFu1ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_Ul_BFu1ll) C1{ Fc FL FL:1}



static void Test_Uc_Ul_BFu1ll()
{
  {
    init_simple_test("Uc_Ul_BFu1ll");
    static STRUCT_IF_C Uc_Ul_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu1ll, Uc_Ul_BFu1ll)
//============================================================================


struct  Uc_Ul_BFu1s  {
  unsigned char v1;
  __tsu64 v2;
  unsigned short v3:1;
};
//SIG(1 Uc_Ul_BFu1s) C1{ Fc FL Fs:1}



static void Test_Uc_Ul_BFu1s()
{
  {
    init_simple_test("Uc_Ul_BFu1s");
    static STRUCT_IF_C Uc_Ul_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Uc_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu1s, Uc_Ul_BFu1s)
//============================================================================


struct  Uc_Ul_BFu31i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:31;
};
//SIG(1 Uc_Ul_BFu31i) C1{ Fc FL Fi:31}



static void Test_Uc_Ul_BFu31i()
{
  {
    init_simple_test("Uc_Ul_BFu31i");
    static STRUCT_IF_C Uc_Ul_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Uc_Ul_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Uc_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu31i, Uc_Ul_BFu31i)
//============================================================================


struct  Uc_Ul_BFu31ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_Ul_BFu31ll) C1{ Fc FL FL:31}



static void Test_Uc_Ul_BFu31ll()
{
  {
    init_simple_test("Uc_Ul_BFu31ll");
    static STRUCT_IF_C Uc_Ul_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Uc_Ul_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Uc_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu31ll, Uc_Ul_BFu31ll)
//============================================================================


struct  Uc_Ul_BFu32i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:32;
};
//SIG(1 Uc_Ul_BFu32i) C1{ Fc FL Fi:32}



static void Test_Uc_Ul_BFu32i()
{
  {
    init_simple_test("Uc_Ul_BFu32i");
    static STRUCT_IF_C Uc_Ul_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Uc_Ul_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Uc_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu32i, Uc_Ul_BFu32i)
//============================================================================


struct  Uc_Ul_BFu32ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_Ul_BFu32ll) C1{ Fc FL FL:32}



static void Test_Uc_Ul_BFu32ll()
{
  {
    init_simple_test("Uc_Ul_BFu32ll");
    static STRUCT_IF_C Uc_Ul_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Uc_Ul_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Uc_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu32ll, Uc_Ul_BFu32ll)
//============================================================================


struct  Uc_Ul_BFu33  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_Ul_BFu33) C1{ Fc FL FL:33}



static void Test_Uc_Ul_BFu33()
{
  {
    init_simple_test("Uc_Ul_BFu33");
    static STRUCT_IF_C Uc_Ul_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_Ul_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Uc_Ul_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Uc_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu33, Uc_Ul_BFu33)
//============================================================================


struct  Uc_Ul_BFu7c  {
  unsigned char v1;
  __tsu64 v2;
  unsigned char v3:7;
};
//SIG(1 Uc_Ul_BFu7c) C1{ Fc FL Fc:7}



static void Test_Uc_Ul_BFu7c()
{
  {
    init_simple_test("Uc_Ul_BFu7c");
    static STRUCT_IF_C Uc_Ul_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_Ul_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu7c, Uc_Ul_BFu7c)
//============================================================================


struct  Uc_Ul_BFu7i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:7;
};
//SIG(1 Uc_Ul_BFu7i) C1{ Fc FL Fi:7}



static void Test_Uc_Ul_BFu7i()
{
  {
    init_simple_test("Uc_Ul_BFu7i");
    static STRUCT_IF_C Uc_Ul_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_Ul_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu7i, Uc_Ul_BFu7i)
//============================================================================


struct  Uc_Ul_BFu7ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_Ul_BFu7ll) C1{ Fc FL FL:7}



static void Test_Uc_Ul_BFu7ll()
{
  {
    init_simple_test("Uc_Ul_BFu7ll");
    static STRUCT_IF_C Uc_Ul_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_Ul_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu7ll, Uc_Ul_BFu7ll)
//============================================================================


struct  Uc_Ul_BFu7s  {
  unsigned char v1;
  __tsu64 v2;
  unsigned short v3:7;
};
//SIG(1 Uc_Ul_BFu7s) C1{ Fc FL Fs:7}



static void Test_Uc_Ul_BFu7s()
{
  {
    init_simple_test("Uc_Ul_BFu7s");
    static STRUCT_IF_C Uc_Ul_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Uc_Ul_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Uc_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu7s, Uc_Ul_BFu7s)
//============================================================================


struct  Uc_Ul_BFu8c  {
  unsigned char v1;
  __tsu64 v2;
  unsigned char v3:8;
};
//SIG(1 Uc_Ul_BFu8c) C1{ Fc FL Fc:8}



static void Test_Uc_Ul_BFu8c()
{
  {
    init_simple_test("Uc_Ul_BFu8c");
    static STRUCT_IF_C Uc_Ul_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_Ul_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu8c, Uc_Ul_BFu8c)
//============================================================================


struct  Uc_Ul_BFu8i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:8;
};
//SIG(1 Uc_Ul_BFu8i) C1{ Fc FL Fi:8}



static void Test_Uc_Ul_BFu8i()
{
  {
    init_simple_test("Uc_Ul_BFu8i");
    static STRUCT_IF_C Uc_Ul_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_Ul_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu8i, Uc_Ul_BFu8i)
//============================================================================


struct  Uc_Ul_BFu8ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_Ul_BFu8ll) C1{ Fc FL FL:8}



static void Test_Uc_Ul_BFu8ll()
{
  {
    init_simple_test("Uc_Ul_BFu8ll");
    static STRUCT_IF_C Uc_Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_Ul_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu8ll, Uc_Ul_BFu8ll)
//============================================================================


struct  Uc_Ul_BFu8s  {
  unsigned char v1;
  __tsu64 v2;
  unsigned short v3:8;
};
//SIG(1 Uc_Ul_BFu8s) C1{ Fc FL Fs:8}



static void Test_Uc_Ul_BFu8s()
{
  {
    init_simple_test("Uc_Ul_BFu8s");
    static STRUCT_IF_C Uc_Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Uc_Ul_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Uc_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu8s, Uc_Ul_BFu8s)
//============================================================================


struct  Uc_Ul_BFu9i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3:9;
};
//SIG(1 Uc_Ul_BFu9i) C1{ Fc FL Fi:9}



static void Test_Uc_Ul_BFu9i()
{
  {
    init_simple_test("Uc_Ul_BFu9i");
    static STRUCT_IF_C Uc_Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_Ul_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu9i, Uc_Ul_BFu9i)
//============================================================================


struct  Uc_Ul_BFu9ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_Ul_BFu9ll) C1{ Fc FL FL:9}



static void Test_Uc_Ul_BFu9ll()
{
  {
    init_simple_test("Uc_Ul_BFu9ll");
    static STRUCT_IF_C Uc_Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_Ul_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu9ll, Uc_Ul_BFu9ll)
//============================================================================


struct  Uc_Ul_BFu9s  {
  unsigned char v1;
  __tsu64 v2;
  unsigned short v3:9;
};
//SIG(1 Uc_Ul_BFu9s) C1{ Fc FL Fs:9}



static void Test_Uc_Ul_BFu9s()
{
  {
    init_simple_test("Uc_Ul_BFu9s");
    static STRUCT_IF_C Uc_Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Uc_Ul_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Uc_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_BFu9s, Uc_Ul_BFu9s)
//============================================================================


struct  Uc_Ul_C  {
  unsigned char v1;
  __tsu64 v2;
  char v3;
};
//SIG(1 Uc_Ul_C) C1{ Fc FL Fc}



static void Test_Uc_Ul_C()
{
  {
    init_simple_test("Uc_Ul_C");
    STRUCT_IF_C Uc_Ul_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_C)");
    check_field_offset(lv, v1, 0, "Uc_Ul_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_C, Uc_Ul_C)
//============================================================================


struct  Uc_Ul_D  {
  unsigned char v1;
  __tsu64 v2;
  double v3;
};
//SIG(1 Uc_Ul_D) C1{ Fc FL[2]}



static void Test_Uc_Ul_D()
{
  {
    init_simple_test("Uc_Ul_D");
    STRUCT_IF_C Uc_Ul_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_Ul_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_D)");
    check_field_offset(lv, v1, 0, "Uc_Ul_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_D, Uc_Ul_D)
//============================================================================


struct  Uc_Ul_F  {
  unsigned char v1;
  __tsu64 v2;
  float v3;
};
//SIG(1 Uc_Ul_F) C1{ Fc FL Fi}



static void Test_Uc_Ul_F()
{
  {
    init_simple_test("Uc_Ul_F");
    STRUCT_IF_C Uc_Ul_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_F)");
    check_field_offset(lv, v1, 0, "Uc_Ul_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_F, Uc_Ul_F)
//============================================================================


struct  Uc_Ul_I  {
  unsigned char v1;
  __tsu64 v2;
  int v3;
};
//SIG(1 Uc_Ul_I) C1{ Fc FL Fi}



static void Test_Uc_Ul_I()
{
  {
    init_simple_test("Uc_Ul_I");
    STRUCT_IF_C Uc_Ul_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_I)");
    check_field_offset(lv, v1, 0, "Uc_Ul_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_I, Uc_Ul_I)
//============================================================================


struct  Uc_Ul_Ip  {
  unsigned char v1;
  __tsu64 v2;
  int *v3;
};
//SIG(1 Uc_Ul_Ip) C1{ Fc FL Fp}



static void Test_Uc_Ul_Ip()
{
  {
    init_simple_test("Uc_Ul_Ip");
    STRUCT_IF_C Uc_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Ul_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_Ip, Uc_Ul_Ip)
//============================================================================


struct  Uc_Ul_L  {
  unsigned char v1;
  __tsu64 v2;
  __tsi64 v3;
};
//SIG(1 Uc_Ul_L) C1{ Fc FL[2]}



static void Test_Uc_Ul_L()
{
  {
    init_simple_test("Uc_Ul_L");
    STRUCT_IF_C Uc_Ul_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_Ul_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_L)");
    check_field_offset(lv, v1, 0, "Uc_Ul_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_L, Uc_Ul_L)
//============================================================================


struct  Uc_Ul_S  {
  unsigned char v1;
  __tsu64 v2;
  short v3;
};
//SIG(1 Uc_Ul_S) C1{ Fc FL Fs}



static void Test_Uc_Ul_S()
{
  {
    init_simple_test("Uc_Ul_S");
    STRUCT_IF_C Uc_Ul_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_S)");
    check_field_offset(lv, v1, 0, "Uc_Ul_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_S, Uc_Ul_S)
//============================================================================


struct  Uc_Ul_Uc  {
  unsigned char v1;
  __tsu64 v2;
  unsigned char v3;
};
//SIG(1 Uc_Ul_Uc) C1{ Fc FL Fc}



static void Test_Uc_Ul_Uc()
{
  {
    init_simple_test("Uc_Ul_Uc");
    STRUCT_IF_C Uc_Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_Uc)");
    check_field_offset(lv, v1, 0, "Uc_Ul_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_Uc, Uc_Ul_Uc)
//============================================================================


struct  Uc_Ul_Ui  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int v3;
};
//SIG(1 Uc_Ul_Ui) C1{ Fc FL Fi}



static void Test_Uc_Ul_Ui()
{
  {
    init_simple_test("Uc_Ul_Ui");
    STRUCT_IF_C Uc_Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_Ui)");
    check_field_offset(lv, v1, 0, "Uc_Ul_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_Ui, Uc_Ul_Ui)
//============================================================================


struct  Uc_Ul_Ul  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64 v3;
};
//SIG(1 Uc_Ul_Ul) C1{ Fc FL[2]}



static void Test_Uc_Ul_Ul()
{
  {
    init_simple_test("Uc_Ul_Ul");
    STRUCT_IF_C Uc_Ul_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Uc_Ul_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_Ul)");
    check_field_offset(lv, v1, 0, "Uc_Ul_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_Ul, Uc_Ul_Ul)
//============================================================================


struct  Uc_Ul_Us  {
  unsigned char v1;
  __tsu64 v2;
  unsigned short v3;
};
//SIG(1 Uc_Ul_Us) C1{ Fc FL Fs}



static void Test_Uc_Ul_Us()
{
  {
    init_simple_test("Uc_Ul_Us");
    STRUCT_IF_C Uc_Ul_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_Us)");
    check_field_offset(lv, v1, 0, "Uc_Ul_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_Us, Uc_Ul_Us)
//============================================================================


struct  Uc_Ul_Vp  {
  unsigned char v1;
  __tsu64 v2;
  void *v3;
};
//SIG(1 Uc_Ul_Vp) C1{ Fc FL Fp}



static void Test_Uc_Ul_Vp()
{
  {
    init_simple_test("Uc_Ul_Vp");
    STRUCT_IF_C Uc_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Ul_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_Vp)");
    check_field_offset(lv, v1, 0, "Uc_Ul_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Uc_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ul_Vp, Uc_Ul_Vp)
//============================================================================


struct  Uc_Us  {
  unsigned char v1;
  unsigned short v2;
};
//SIG(1 Uc_Us) C1{ Fc Fs}



static void Test_Uc_Us()
{
  {
    init_simple_test("Uc_Us");
    STRUCT_IF_C Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us)");
    check_field_offset(lv, v1, 0, "Uc_Us.v1");
    check_field_offset(lv, v2, 2, "Uc_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us, Uc_Us)
//============================================================================


struct  Uc_Us_BFu15i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:15;
};
//SIG(1 Uc_Us_BFu15i) C1{ Fc Fs Fi:15}



static void Test_Uc_Us_BFu15i()
{
  {
    init_simple_test("Uc_Us_BFu15i");
    static STRUCT_IF_C Uc_Us_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Uc_Us_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Uc_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu15i, Uc_Us_BFu15i)
//============================================================================


struct  Uc_Us_BFu15ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_Us_BFu15ll) C1{ Fc Fs FL:15}



static void Test_Uc_Us_BFu15ll()
{
  {
    init_simple_test("Uc_Us_BFu15ll");
    static STRUCT_IF_C Uc_Us_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Uc_Us_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Uc_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu15ll, Uc_Us_BFu15ll)
//============================================================================


struct  Uc_Us_BFu15s  {
  unsigned char v1;
  unsigned short v2;
  unsigned short v3:15;
};
//SIG(1 Uc_Us_BFu15s) C1{ Fc Fs Fs:15}



static void Test_Uc_Us_BFu15s()
{
  {
    init_simple_test("Uc_Us_BFu15s");
    static STRUCT_IF_C Uc_Us_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Uc_Us_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Uc_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu15s, Uc_Us_BFu15s)
//============================================================================


struct  Uc_Us_BFu16i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:16;
};
//SIG(1 Uc_Us_BFu16i) C1{ Fc Fs Fi:16}



static void Test_Uc_Us_BFu16i()
{
  {
    init_simple_test("Uc_Us_BFu16i");
    static STRUCT_IF_C Uc_Us_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Uc_Us_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Uc_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu16i, Uc_Us_BFu16i)
//============================================================================


struct  Uc_Us_BFu16ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_Us_BFu16ll) C1{ Fc Fs FL:16}



static void Test_Uc_Us_BFu16ll()
{
  {
    init_simple_test("Uc_Us_BFu16ll");
    static STRUCT_IF_C Uc_Us_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Uc_Us_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Uc_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu16ll, Uc_Us_BFu16ll)
//============================================================================


struct  Uc_Us_BFu16s  {
  unsigned char v1;
  unsigned short v2;
  unsigned short v3:16;
};
//SIG(1 Uc_Us_BFu16s) C1{ Fc Fs Fs:16}



static void Test_Uc_Us_BFu16s()
{
  {
    init_simple_test("Uc_Us_BFu16s");
    static STRUCT_IF_C Uc_Us_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Uc_Us_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Uc_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu16s, Uc_Us_BFu16s)
//============================================================================


struct  Uc_Us_BFu17i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:17;
};
//SIG(1 Uc_Us_BFu17i) C1{ Fc Fs Fi:17}



static void Test_Uc_Us_BFu17i()
{
  {
    init_simple_test("Uc_Us_BFu17i");
    static STRUCT_IF_C Uc_Us_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Uc_Us_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Uc_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu17i, Uc_Us_BFu17i)
//============================================================================


struct  Uc_Us_BFu17ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_Us_BFu17ll) C1{ Fc Fs FL:17}



static void Test_Uc_Us_BFu17ll()
{
  {
    init_simple_test("Uc_Us_BFu17ll");
    static STRUCT_IF_C Uc_Us_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Uc_Us_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Uc_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu17ll, Uc_Us_BFu17ll)
//============================================================================


struct  Uc_Us_BFu1c  {
  unsigned char v1;
  unsigned short v2;
  unsigned char v3:1;
};
//SIG(1 Uc_Us_BFu1c) C1{ Fc Fs Fc:1}



static void Test_Uc_Us_BFu1c()
{
  {
    init_simple_test("Uc_Us_BFu1c");
    static STRUCT_IF_C Uc_Us_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Uc_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu1c, Uc_Us_BFu1c)
//============================================================================


struct  Uc_Us_BFu1i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:1;
};
//SIG(1 Uc_Us_BFu1i) C1{ Fc Fs Fi:1}



static void Test_Uc_Us_BFu1i()
{
  {
    init_simple_test("Uc_Us_BFu1i");
    static STRUCT_IF_C Uc_Us_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Uc_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu1i, Uc_Us_BFu1i)
//============================================================================


struct  Uc_Us_BFu1ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_Us_BFu1ll) C1{ Fc Fs FL:1}



static void Test_Uc_Us_BFu1ll()
{
  {
    init_simple_test("Uc_Us_BFu1ll");
    static STRUCT_IF_C Uc_Us_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Uc_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu1ll, Uc_Us_BFu1ll)
//============================================================================


struct  Uc_Us_BFu1s  {
  unsigned char v1;
  unsigned short v2;
  unsigned short v3:1;
};
//SIG(1 Uc_Us_BFu1s) C1{ Fc Fs Fs:1}



static void Test_Uc_Us_BFu1s()
{
  {
    init_simple_test("Uc_Us_BFu1s");
    static STRUCT_IF_C Uc_Us_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Uc_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu1s, Uc_Us_BFu1s)
//============================================================================


struct  Uc_Us_BFu31i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:31;
};
//SIG(1 Uc_Us_BFu31i) C1{ Fc Fs Fi:31}



static void Test_Uc_Us_BFu31i()
{
  {
    init_simple_test("Uc_Us_BFu31i");
    static STRUCT_IF_C Uc_Us_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Uc_Us_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Uc_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu31i, Uc_Us_BFu31i)
//============================================================================


struct  Uc_Us_BFu31ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_Us_BFu31ll) C1{ Fc Fs FL:31}



static void Test_Uc_Us_BFu31ll()
{
  {
    init_simple_test("Uc_Us_BFu31ll");
    static STRUCT_IF_C Uc_Us_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Uc_Us_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Uc_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu31ll, Uc_Us_BFu31ll)
//============================================================================


struct  Uc_Us_BFu32i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:32;
};
//SIG(1 Uc_Us_BFu32i) C1{ Fc Fs Fi:32}



static void Test_Uc_Us_BFu32i()
{
  {
    init_simple_test("Uc_Us_BFu32i");
    static STRUCT_IF_C Uc_Us_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Uc_Us_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Uc_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu32i, Uc_Us_BFu32i)
//============================================================================


struct  Uc_Us_BFu32ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_Us_BFu32ll) C1{ Fc Fs FL:32}



static void Test_Uc_Us_BFu32ll()
{
  {
    init_simple_test("Uc_Us_BFu32ll");
    static STRUCT_IF_C Uc_Us_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Uc_Us_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Uc_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu32ll, Uc_Us_BFu32ll)
//============================================================================


struct  Uc_Us_BFu33  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_Us_BFu33) C1{ Fc Fs FL:33}



static void Test_Uc_Us_BFu33()
{
  {
    init_simple_test("Uc_Us_BFu33");
    static STRUCT_IF_C Uc_Us_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Us_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu33.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "Uc_Us_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Uc_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu33, Uc_Us_BFu33)
//============================================================================


struct  Uc_Us_BFu7c  {
  unsigned char v1;
  unsigned short v2;
  unsigned char v3:7;
};
//SIG(1 Uc_Us_BFu7c) C1{ Fc Fs Fc:7}



static void Test_Uc_Us_BFu7c()
{
  {
    init_simple_test("Uc_Us_BFu7c");
    static STRUCT_IF_C Uc_Us_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Uc_Us_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Uc_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu7c, Uc_Us_BFu7c)
//============================================================================


struct  Uc_Us_BFu7i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:7;
};
//SIG(1 Uc_Us_BFu7i) C1{ Fc Fs Fi:7}



static void Test_Uc_Us_BFu7i()
{
  {
    init_simple_test("Uc_Us_BFu7i");
    static STRUCT_IF_C Uc_Us_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Uc_Us_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Uc_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu7i, Uc_Us_BFu7i)
//============================================================================


struct  Uc_Us_BFu7ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_Us_BFu7ll) C1{ Fc Fs FL:7}



static void Test_Uc_Us_BFu7ll()
{
  {
    init_simple_test("Uc_Us_BFu7ll");
    static STRUCT_IF_C Uc_Us_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Uc_Us_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Uc_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu7ll, Uc_Us_BFu7ll)
//============================================================================


struct  Uc_Us_BFu7s  {
  unsigned char v1;
  unsigned short v2;
  unsigned short v3:7;
};
//SIG(1 Uc_Us_BFu7s) C1{ Fc Fs Fs:7}



static void Test_Uc_Us_BFu7s()
{
  {
    init_simple_test("Uc_Us_BFu7s");
    static STRUCT_IF_C Uc_Us_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Uc_Us_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Uc_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu7s, Uc_Us_BFu7s)
//============================================================================


struct  Uc_Us_BFu8c  {
  unsigned char v1;
  unsigned short v2;
  unsigned char v3:8;
};
//SIG(1 Uc_Us_BFu8c) C1{ Fc Fs Fc:8}



static void Test_Uc_Us_BFu8c()
{
  {
    init_simple_test("Uc_Us_BFu8c");
    static STRUCT_IF_C Uc_Us_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Uc_Us_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Uc_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu8c, Uc_Us_BFu8c)
//============================================================================


struct  Uc_Us_BFu8i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:8;
};
//SIG(1 Uc_Us_BFu8i) C1{ Fc Fs Fi:8}



static void Test_Uc_Us_BFu8i()
{
  {
    init_simple_test("Uc_Us_BFu8i");
    static STRUCT_IF_C Uc_Us_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Uc_Us_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Uc_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu8i, Uc_Us_BFu8i)
//============================================================================


struct  Uc_Us_BFu8ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_Us_BFu8ll) C1{ Fc Fs FL:8}



static void Test_Uc_Us_BFu8ll()
{
  {
    init_simple_test("Uc_Us_BFu8ll");
    static STRUCT_IF_C Uc_Us_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Uc_Us_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Uc_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu8ll, Uc_Us_BFu8ll)
//============================================================================


struct  Uc_Us_BFu8s  {
  unsigned char v1;
  unsigned short v2;
  unsigned short v3:8;
};
//SIG(1 Uc_Us_BFu8s) C1{ Fc Fs Fs:8}



static void Test_Uc_Us_BFu8s()
{
  {
    init_simple_test("Uc_Us_BFu8s");
    static STRUCT_IF_C Uc_Us_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Uc_Us_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Uc_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu8s, Uc_Us_BFu8s)
//============================================================================


struct  Uc_Us_BFu9i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3:9;
};
//SIG(1 Uc_Us_BFu9i) C1{ Fc Fs Fi:9}



static void Test_Uc_Us_BFu9i()
{
  {
    init_simple_test("Uc_Us_BFu9i");
    static STRUCT_IF_C Uc_Us_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Uc_Us_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Uc_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu9i, Uc_Us_BFu9i)
//============================================================================


struct  Uc_Us_BFu9ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_Us_BFu9ll) C1{ Fc Fs FL:9}



static void Test_Uc_Us_BFu9ll()
{
  {
    init_simple_test("Uc_Us_BFu9ll");
    static STRUCT_IF_C Uc_Us_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Uc_Us_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Uc_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu9ll, Uc_Us_BFu9ll)
//============================================================================


struct  Uc_Us_BFu9s  {
  unsigned char v1;
  unsigned short v2;
  unsigned short v3:9;
};
//SIG(1 Uc_Us_BFu9s) C1{ Fc Fs Fs:9}



static void Test_Uc_Us_BFu9s()
{
  {
    init_simple_test("Uc_Us_BFu9s");
    static STRUCT_IF_C Uc_Us_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Uc_Us_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Uc_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_BFu9s, Uc_Us_BFu9s)
//============================================================================


struct  Uc_Us_C  {
  unsigned char v1;
  unsigned short v2;
  char v3;
};
//SIG(1 Uc_Us_C) C1{ Fc Fs Fc}



static void Test_Uc_Us_C()
{
  {
    init_simple_test("Uc_Us_C");
    STRUCT_IF_C Uc_Us_C lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_C)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_C)");
    check_field_offset(lv, v1, 0, "Uc_Us_C.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_C.v2");
    check_field_offset(lv, v3, 4, "Uc_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_C, Uc_Us_C)
//============================================================================


struct  Uc_Us_D  {
  unsigned char v1;
  unsigned short v2;
  double v3;
};
//SIG(1 Uc_Us_D) C1{ Fc Fs FL}



static void Test_Uc_Us_D()
{
  {
    init_simple_test("Uc_Us_D");
    STRUCT_IF_C Uc_Us_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Us_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_D)");
    check_field_offset(lv, v1, 0, "Uc_Us_D.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_D, Uc_Us_D)
//============================================================================


struct  Uc_Us_F  {
  unsigned char v1;
  unsigned short v2;
  float v3;
};
//SIG(1 Uc_Us_F) C1{ Fc Fs Fi}



static void Test_Uc_Us_F()
{
  {
    init_simple_test("Uc_Us_F");
    STRUCT_IF_C Uc_Us_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_F)");
    check_field_offset(lv, v1, 0, "Uc_Us_F.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_F.v2");
    check_field_offset(lv, v3, 4, "Uc_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_F, Uc_Us_F)
//============================================================================


struct  Uc_Us_I  {
  unsigned char v1;
  unsigned short v2;
  int v3;
};
//SIG(1 Uc_Us_I) C1{ Fc Fs Fi}



static void Test_Uc_Us_I()
{
  {
    init_simple_test("Uc_Us_I");
    STRUCT_IF_C Uc_Us_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_I)");
    check_field_offset(lv, v1, 0, "Uc_Us_I.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_I.v2");
    check_field_offset(lv, v3, 4, "Uc_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_I, Uc_Us_I)
//============================================================================


struct  Uc_Us_Ip  {
  unsigned char v1;
  unsigned short v2;
  int *v3;
};
//SIG(1 Uc_Us_Ip) C1{ Fc Fs Fp}



static void Test_Uc_Us_Ip()
{
  {
    init_simple_test("Uc_Us_Ip");
    STRUCT_IF_C Uc_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Us_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Us_Ip.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_Ip, Uc_Us_Ip)
//============================================================================


struct  Uc_Us_L  {
  unsigned char v1;
  unsigned short v2;
  __tsi64 v3;
};
//SIG(1 Uc_Us_L) C1{ Fc Fs FL}



static void Test_Uc_Us_L()
{
  {
    init_simple_test("Uc_Us_L");
    STRUCT_IF_C Uc_Us_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Us_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_L)");
    check_field_offset(lv, v1, 0, "Uc_Us_L.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_L, Uc_Us_L)
//============================================================================


struct  Uc_Us_S  {
  unsigned char v1;
  unsigned short v2;
  short v3;
};
//SIG(1 Uc_Us_S) C1{ Fc Fs[2]}



static void Test_Uc_Us_S()
{
  {
    init_simple_test("Uc_Us_S");
    STRUCT_IF_C Uc_Us_S lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_S)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_S)");
    check_field_offset(lv, v1, 0, "Uc_Us_S.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_S.v2");
    check_field_offset(lv, v3, 4, "Uc_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_S, Uc_Us_S)
//============================================================================


struct  Uc_Us_Uc  {
  unsigned char v1;
  unsigned short v2;
  unsigned char v3;
};
//SIG(1 Uc_Us_Uc) C1{ Fc Fs Fc}



static void Test_Uc_Us_Uc()
{
  {
    init_simple_test("Uc_Us_Uc");
    STRUCT_IF_C Uc_Us_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_Uc)");
    check_field_offset(lv, v1, 0, "Uc_Us_Uc.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_Uc.v2");
    check_field_offset(lv, v3, 4, "Uc_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_Uc, Uc_Us_Uc)
//============================================================================


struct  Uc_Us_Ui  {
  unsigned char v1;
  unsigned short v2;
  unsigned int v3;
};
//SIG(1 Uc_Us_Ui) C1{ Fc Fs Fi}



static void Test_Uc_Us_Ui()
{
  {
    init_simple_test("Uc_Us_Ui");
    STRUCT_IF_C Uc_Us_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Us_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Us_Ui)");
    check_field_offset(lv, v1, 0, "Uc_Us_Ui.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_Ui.v2");
    check_field_offset(lv, v3, 4, "Uc_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_Ui, Uc_Us_Ui)
//============================================================================


struct  Uc_Us_Ul  {
  unsigned char v1;
  unsigned short v2;
  __tsu64 v3;
};
//SIG(1 Uc_Us_Ul) C1{ Fc Fs FL}



static void Test_Uc_Us_Ul()
{
  {
    init_simple_test("Uc_Us_Ul");
    STRUCT_IF_C Uc_Us_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Us_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_Ul)");
    check_field_offset(lv, v1, 0, "Uc_Us_Ul.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_Ul, Uc_Us_Ul)
//============================================================================


struct  Uc_Us_Us  {
  unsigned char v1;
  unsigned short v2;
  unsigned short v3;
};
//SIG(1 Uc_Us_Us) C1{ Fc Fs[2]}



static void Test_Uc_Us_Us()
{
  {
    init_simple_test("Uc_Us_Us");
    STRUCT_IF_C Uc_Us_Us lv;
    check2(sizeof(lv), 6, "sizeof(Uc_Us_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_Us)");
    check_field_offset(lv, v1, 0, "Uc_Us_Us.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_Us.v2");
    check_field_offset(lv, v3, 4, "Uc_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_Us, Uc_Us_Us)
//============================================================================


struct  Uc_Us_Vp  {
  unsigned char v1;
  unsigned short v2;
  void *v3;
};
//SIG(1 Uc_Us_Vp) C1{ Fc Fs Fp}



static void Test_Uc_Us_Vp()
{
  {
    init_simple_test("Uc_Us_Vp");
    STRUCT_IF_C Uc_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Us_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Us_Vp)");
    check_field_offset(lv, v1, 0, "Uc_Us_Vp.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Uc_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Us_Vp, Uc_Us_Vp)
//============================================================================


struct  Uc_Vp  {
  unsigned char v1;
  void *v2;
};
//SIG(1 Uc_Vp) C1{ Fc Fp}



static void Test_Uc_Vp()
{
  {
    init_simple_test("Uc_Vp");
    STRUCT_IF_C Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp)");
    check_field_offset(lv, v1, 0, "Uc_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp, Uc_Vp)
//============================================================================


struct  Uc_Vp_BFu15i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:15;
};
//SIG(1 Uc_Vp_BFu15i) C1{ Fc Fp Fi:15}



static void Test_Uc_Vp_BFu15i()
{
  {
    init_simple_test("Uc_Vp_BFu15i");
    static STRUCT_IF_C Uc_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "Uc_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "Uc_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu15i, Uc_Vp_BFu15i)
//============================================================================


struct  Uc_Vp_BFu15ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:15;
};
//SIG(1 Uc_Vp_BFu15ll) C1{ Fc Fp FL:15}



static void Test_Uc_Vp_BFu15ll()
{
  {
    init_simple_test("Uc_Vp_BFu15ll");
    static STRUCT_IF_C Uc_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "Uc_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "Uc_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu15ll, Uc_Vp_BFu15ll)
//============================================================================


struct  Uc_Vp_BFu15s  {
  unsigned char v1;
  void *v2;
  unsigned short v3:15;
};
//SIG(1 Uc_Vp_BFu15s) C1{ Fc Fp Fs:15}



static void Test_Uc_Vp_BFu15s()
{
  {
    init_simple_test("Uc_Vp_BFu15s");
    static STRUCT_IF_C Uc_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "Uc_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "Uc_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu15s, Uc_Vp_BFu15s)
//============================================================================


struct  Uc_Vp_BFu16i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:16;
};
//SIG(1 Uc_Vp_BFu16i) C1{ Fc Fp Fi:16}



static void Test_Uc_Vp_BFu16i()
{
  {
    init_simple_test("Uc_Vp_BFu16i");
    static STRUCT_IF_C Uc_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "Uc_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "Uc_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu16i, Uc_Vp_BFu16i)
//============================================================================


struct  Uc_Vp_BFu16ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:16;
};
//SIG(1 Uc_Vp_BFu16ll) C1{ Fc Fp FL:16}



static void Test_Uc_Vp_BFu16ll()
{
  {
    init_simple_test("Uc_Vp_BFu16ll");
    static STRUCT_IF_C Uc_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "Uc_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "Uc_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu16ll, Uc_Vp_BFu16ll)
//============================================================================


struct  Uc_Vp_BFu16s  {
  unsigned char v1;
  void *v2;
  unsigned short v3:16;
};
//SIG(1 Uc_Vp_BFu16s) C1{ Fc Fp Fs:16}



static void Test_Uc_Vp_BFu16s()
{
  {
    init_simple_test("Uc_Vp_BFu16s");
    static STRUCT_IF_C Uc_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "Uc_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "Uc_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu16s, Uc_Vp_BFu16s)
//============================================================================


struct  Uc_Vp_BFu17i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:17;
};
//SIG(1 Uc_Vp_BFu17i) C1{ Fc Fp Fi:17}



static void Test_Uc_Vp_BFu17i()
{
  {
    init_simple_test("Uc_Vp_BFu17i");
    static STRUCT_IF_C Uc_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "Uc_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "Uc_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu17i, Uc_Vp_BFu17i)
//============================================================================


struct  Uc_Vp_BFu17ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:17;
};
//SIG(1 Uc_Vp_BFu17ll) C1{ Fc Fp FL:17}



static void Test_Uc_Vp_BFu17ll()
{
  {
    init_simple_test("Uc_Vp_BFu17ll");
    static STRUCT_IF_C Uc_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "Uc_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "Uc_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu17ll, Uc_Vp_BFu17ll)
//============================================================================


struct  Uc_Vp_BFu1c  {
  unsigned char v1;
  void *v2;
  unsigned char v3:1;
};
//SIG(1 Uc_Vp_BFu1c) C1{ Fc Fp Fc:1}



static void Test_Uc_Vp_BFu1c()
{
  {
    init_simple_test("Uc_Vp_BFu1c");
    static STRUCT_IF_C Uc_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "Uc_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu1c, Uc_Vp_BFu1c)
//============================================================================


struct  Uc_Vp_BFu1i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:1;
};
//SIG(1 Uc_Vp_BFu1i) C1{ Fc Fp Fi:1}



static void Test_Uc_Vp_BFu1i()
{
  {
    init_simple_test("Uc_Vp_BFu1i");
    static STRUCT_IF_C Uc_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "Uc_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu1i, Uc_Vp_BFu1i)
//============================================================================


struct  Uc_Vp_BFu1ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:1;
};
//SIG(1 Uc_Vp_BFu1ll) C1{ Fc Fp FL:1}



static void Test_Uc_Vp_BFu1ll()
{
  {
    init_simple_test("Uc_Vp_BFu1ll");
    static STRUCT_IF_C Uc_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "Uc_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu1ll, Uc_Vp_BFu1ll)
//============================================================================


struct  Uc_Vp_BFu1s  {
  unsigned char v1;
  void *v2;
  unsigned short v3:1;
};
//SIG(1 Uc_Vp_BFu1s) C1{ Fc Fp Fs:1}



static void Test_Uc_Vp_BFu1s()
{
  {
    init_simple_test("Uc_Vp_BFu1s");
    static STRUCT_IF_C Uc_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "Uc_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu1s, Uc_Vp_BFu1s)
//============================================================================


struct  Uc_Vp_BFu31i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:31;
};
//SIG(1 Uc_Vp_BFu31i) C1{ Fc Fp Fi:31}



static void Test_Uc_Vp_BFu31i()
{
  {
    init_simple_test("Uc_Vp_BFu31i");
    static STRUCT_IF_C Uc_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "Uc_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "Uc_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu31i, Uc_Vp_BFu31i)
//============================================================================


struct  Uc_Vp_BFu31ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:31;
};
//SIG(1 Uc_Vp_BFu31ll) C1{ Fc Fp FL:31}



static void Test_Uc_Vp_BFu31ll()
{
  {
    init_simple_test("Uc_Vp_BFu31ll");
    static STRUCT_IF_C Uc_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "Uc_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "Uc_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu31ll, Uc_Vp_BFu31ll)
//============================================================================


struct  Uc_Vp_BFu32i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:32;
};
//SIG(1 Uc_Vp_BFu32i) C1{ Fc Fp Fi:32}



static void Test_Uc_Vp_BFu32i()
{
  {
    init_simple_test("Uc_Vp_BFu32i");
    static STRUCT_IF_C Uc_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "Uc_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "Uc_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu32i, Uc_Vp_BFu32i)
//============================================================================


struct  Uc_Vp_BFu32ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:32;
};
//SIG(1 Uc_Vp_BFu32ll) C1{ Fc Fp FL:32}



static void Test_Uc_Vp_BFu32ll()
{
  {
    init_simple_test("Uc_Vp_BFu32ll");
    static STRUCT_IF_C Uc_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "Uc_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "Uc_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu32ll, Uc_Vp_BFu32ll)
//============================================================================


struct  Uc_Vp_BFu33  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:33;
};
//SIG(1 Uc_Vp_BFu33) C1{ Fc Fp FL:33}



static void Test_Uc_Vp_BFu33()
{
  {
    init_simple_test("Uc_Vp_BFu33");
    static STRUCT_IF_C Uc_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Vp_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "Uc_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "Uc_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu33, Uc_Vp_BFu33)
//============================================================================


struct  Uc_Vp_BFu7c  {
  unsigned char v1;
  void *v2;
  unsigned char v3:7;
};
//SIG(1 Uc_Vp_BFu7c) C1{ Fc Fp Fc:7}



static void Test_Uc_Vp_BFu7c()
{
  {
    init_simple_test("Uc_Vp_BFu7c");
    static STRUCT_IF_C Uc_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "Uc_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "Uc_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu7c, Uc_Vp_BFu7c)
//============================================================================


struct  Uc_Vp_BFu7i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:7;
};
//SIG(1 Uc_Vp_BFu7i) C1{ Fc Fp Fi:7}



static void Test_Uc_Vp_BFu7i()
{
  {
    init_simple_test("Uc_Vp_BFu7i");
    static STRUCT_IF_C Uc_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "Uc_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "Uc_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu7i, Uc_Vp_BFu7i)
//============================================================================


struct  Uc_Vp_BFu7ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:7;
};
//SIG(1 Uc_Vp_BFu7ll) C1{ Fc Fp FL:7}



static void Test_Uc_Vp_BFu7ll()
{
  {
    init_simple_test("Uc_Vp_BFu7ll");
    static STRUCT_IF_C Uc_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "Uc_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "Uc_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu7ll, Uc_Vp_BFu7ll)
//============================================================================


struct  Uc_Vp_BFu7s  {
  unsigned char v1;
  void *v2;
  unsigned short v3:7;
};
//SIG(1 Uc_Vp_BFu7s) C1{ Fc Fp Fs:7}



static void Test_Uc_Vp_BFu7s()
{
  {
    init_simple_test("Uc_Vp_BFu7s");
    static STRUCT_IF_C Uc_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "Uc_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "Uc_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu7s, Uc_Vp_BFu7s)
//============================================================================


struct  Uc_Vp_BFu8c  {
  unsigned char v1;
  void *v2;
  unsigned char v3:8;
};
//SIG(1 Uc_Vp_BFu8c) C1{ Fc Fp Fc:8}



static void Test_Uc_Vp_BFu8c()
{
  {
    init_simple_test("Uc_Vp_BFu8c");
    static STRUCT_IF_C Uc_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "Uc_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "Uc_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu8c, Uc_Vp_BFu8c)
//============================================================================


struct  Uc_Vp_BFu8i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:8;
};
//SIG(1 Uc_Vp_BFu8i) C1{ Fc Fp Fi:8}



static void Test_Uc_Vp_BFu8i()
{
  {
    init_simple_test("Uc_Vp_BFu8i");
    static STRUCT_IF_C Uc_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "Uc_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "Uc_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu8i, Uc_Vp_BFu8i)
//============================================================================


struct  Uc_Vp_BFu8ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:8;
};
//SIG(1 Uc_Vp_BFu8ll) C1{ Fc Fp FL:8}



static void Test_Uc_Vp_BFu8ll()
{
  {
    init_simple_test("Uc_Vp_BFu8ll");
    static STRUCT_IF_C Uc_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "Uc_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "Uc_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu8ll, Uc_Vp_BFu8ll)
//============================================================================


struct  Uc_Vp_BFu8s  {
  unsigned char v1;
  void *v2;
  unsigned short v3:8;
};
//SIG(1 Uc_Vp_BFu8s) C1{ Fc Fp Fs:8}



static void Test_Uc_Vp_BFu8s()
{
  {
    init_simple_test("Uc_Vp_BFu8s");
    static STRUCT_IF_C Uc_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "Uc_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "Uc_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu8s, Uc_Vp_BFu8s)
//============================================================================


struct  Uc_Vp_BFu9i  {
  unsigned char v1;
  void *v2;
  unsigned int v3:9;
};
//SIG(1 Uc_Vp_BFu9i) C1{ Fc Fp Fi:9}



static void Test_Uc_Vp_BFu9i()
{
  {
    init_simple_test("Uc_Vp_BFu9i");
    static STRUCT_IF_C Uc_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "Uc_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "Uc_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu9i, Uc_Vp_BFu9i)
//============================================================================


struct  Uc_Vp_BFu9ll  {
  unsigned char v1;
  void *v2;
  __tsu64 v3:9;
};
//SIG(1 Uc_Vp_BFu9ll) C1{ Fc Fp FL:9}



static void Test_Uc_Vp_BFu9ll()
{
  {
    init_simple_test("Uc_Vp_BFu9ll");
    static STRUCT_IF_C Uc_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "Uc_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "Uc_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu9ll, Uc_Vp_BFu9ll)
//============================================================================


struct  Uc_Vp_BFu9s  {
  unsigned char v1;
  void *v2;
  unsigned short v3:9;
};
//SIG(1 Uc_Vp_BFu9s) C1{ Fc Fp Fs:9}



static void Test_Uc_Vp_BFu9s()
{
  {
    init_simple_test("Uc_Vp_BFu9s");
    static STRUCT_IF_C Uc_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "Uc_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "Uc_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_BFu9s, Uc_Vp_BFu9s)
//============================================================================


struct  Uc_Vp_C  {
  unsigned char v1;
  void *v2;
  char v3;
};
//SIG(1 Uc_Vp_C) C1{ Fc Fp Fc}



static void Test_Uc_Vp_C()
{
  {
    init_simple_test("Uc_Vp_C");
    STRUCT_IF_C Uc_Vp_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_C)");
    check_field_offset(lv, v1, 0, "Uc_Vp_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_C, Uc_Vp_C)
//============================================================================


struct  Uc_Vp_D  {
  unsigned char v1;
  void *v2;
  double v3;
};
//SIG(1 Uc_Vp_D) C1{ Fc Fp FL}



static void Test_Uc_Vp_D()
{
  {
    init_simple_test("Uc_Vp_D");
    STRUCT_IF_C Uc_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Vp_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_D)");
    check_field_offset(lv, v1, 0, "Uc_Vp_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_D, Uc_Vp_D)
//============================================================================


struct  Uc_Vp_F  {
  unsigned char v1;
  void *v2;
  float v3;
};
//SIG(1 Uc_Vp_F) C1{ Fc Fp Fi}



static void Test_Uc_Vp_F()
{
  {
    init_simple_test("Uc_Vp_F");
    STRUCT_IF_C Uc_Vp_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_F)");
    check_field_offset(lv, v1, 0, "Uc_Vp_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_F, Uc_Vp_F)
//============================================================================


struct  Uc_Vp_I  {
  unsigned char v1;
  void *v2;
  int v3;
};
//SIG(1 Uc_Vp_I) C1{ Fc Fp Fi}



static void Test_Uc_Vp_I()
{
  {
    init_simple_test("Uc_Vp_I");
    STRUCT_IF_C Uc_Vp_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_I)");
    check_field_offset(lv, v1, 0, "Uc_Vp_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_I, Uc_Vp_I)
//============================================================================


struct  Uc_Vp_Ip  {
  unsigned char v1;
  void *v2;
  int *v3;
};
//SIG(1 Uc_Vp_Ip) C1{ Fc Fp[2]}



static void Test_Uc_Vp_Ip()
{
  {
    init_simple_test("Uc_Vp_Ip");
    STRUCT_IF_C Uc_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Vp_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_Ip, Uc_Vp_Ip)
//============================================================================


struct  Uc_Vp_L  {
  unsigned char v1;
  void *v2;
  __tsi64 v3;
};
//SIG(1 Uc_Vp_L) C1{ Fc Fp FL}



static void Test_Uc_Vp_L()
{
  {
    init_simple_test("Uc_Vp_L");
    STRUCT_IF_C Uc_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Vp_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_L)");
    check_field_offset(lv, v1, 0, "Uc_Vp_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_L, Uc_Vp_L)
//============================================================================


struct  Uc_Vp_S  {
  unsigned char v1;
  void *v2;
  short v3;
};
//SIG(1 Uc_Vp_S) C1{ Fc Fp Fs}



static void Test_Uc_Vp_S()
{
  {
    init_simple_test("Uc_Vp_S");
    STRUCT_IF_C Uc_Vp_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_S)");
    check_field_offset(lv, v1, 0, "Uc_Vp_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_S, Uc_Vp_S)
//============================================================================


struct  Uc_Vp_Uc  {
  unsigned char v1;
  void *v2;
  unsigned char v3;
};
//SIG(1 Uc_Vp_Uc) C1{ Fc Fp Fc}



static void Test_Uc_Vp_Uc()
{
  {
    init_simple_test("Uc_Vp_Uc");
    STRUCT_IF_C Uc_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_Uc)");
    check_field_offset(lv, v1, 0, "Uc_Vp_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_Uc, Uc_Vp_Uc)
//============================================================================


struct  Uc_Vp_Ui  {
  unsigned char v1;
  void *v2;
  unsigned int v3;
};
//SIG(1 Uc_Vp_Ui) C1{ Fc Fp Fi}



static void Test_Uc_Vp_Ui()
{
  {
    init_simple_test("Uc_Vp_Ui");
    STRUCT_IF_C Uc_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_Ui)");
    check_field_offset(lv, v1, 0, "Uc_Vp_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_Ui, Uc_Vp_Ui)
//============================================================================


struct  Uc_Vp_Ul  {
  unsigned char v1;
  void *v2;
  __tsu64 v3;
};
//SIG(1 Uc_Vp_Ul) C1{ Fc Fp FL}



static void Test_Uc_Vp_Ul()
{
  {
    init_simple_test("Uc_Vp_Ul");
    STRUCT_IF_C Uc_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Uc_Vp_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_Ul)");
    check_field_offset(lv, v1, 0, "Uc_Vp_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_Ul, Uc_Vp_Ul)
//============================================================================


struct  Uc_Vp_Us  {
  unsigned char v1;
  void *v2;
  unsigned short v3;
};
//SIG(1 Uc_Vp_Us) C1{ Fc Fp Fs}



static void Test_Uc_Vp_Us()
{
  {
    init_simple_test("Uc_Vp_Us");
    STRUCT_IF_C Uc_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_Us)");
    check_field_offset(lv, v1, 0, "Uc_Vp_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_Us, Uc_Vp_Us)
//============================================================================


struct  Uc_Vp_Vp  {
  unsigned char v1;
  void *v2;
  void *v3;
};
//SIG(1 Uc_Vp_Vp) C1{ Fc Fp[2]}



static void Test_Uc_Vp_Vp()
{
  {
    init_simple_test("Uc_Vp_Vp");
    STRUCT_IF_C Uc_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Uc_Vp_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_Vp)");
    check_field_offset(lv, v1, 0, "Uc_Vp_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Uc_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Vp_Vp, Uc_Vp_Vp)
//============================================================================


struct  Ui  {
  unsigned int v1;
};
//SIG(1 Ui) C1{ Fi}



static void Test_Ui()
{
  {
    init_simple_test("Ui");
    STRUCT_IF_C Ui lv;
    check2(sizeof(lv), 4, "sizeof(Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui)");
    check_field_offset(lv, v1, 0, "Ui.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui, Ui)
//============================================================================


struct  Ui_BFu15i  {
  unsigned int v1;
  unsigned int v2:15;
};
//SIG(1 Ui_BFu15i) C1{ Fi Fi:15}



static void Test_Ui_BFu15i()
{
  {
    init_simple_test("Ui_BFu15i");
    static STRUCT_IF_C Ui_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i, Ui_BFu15i)
//============================================================================


struct  Ui_BFu15i_BFu15i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu15i_BFu15i) C1{ Fi Fi:15 Fi:15}



static void Test_Ui_BFu15i_BFu15i()
{
  {
    init_simple_test("Ui_BFu15i_BFu15i");
    static STRUCT_IF_C Ui_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "Ui_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu15i, Ui_BFu15i_BFu15i)
//============================================================================


struct  Ui_BFu15i_BFu15ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu15i_BFu15ll) C1{ Fi Fi:15 FL:15}



static void Test_Ui_BFu15i_BFu15ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu15ll");
    static STRUCT_IF_C Ui_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "Ui_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu15ll, Ui_BFu15i_BFu15ll)
//============================================================================


struct  Ui_BFu15i_BFu15s  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu15i_BFu15s) C1{ Fi Fi:15 Fs:15}



static void Test_Ui_BFu15i_BFu15s()
{
  {
    init_simple_test("Ui_BFu15i_BFu15s");
    static STRUCT_IF_C Ui_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu15s, Ui_BFu15i_BFu15s)
//============================================================================


struct  Ui_BFu15i_BFu16i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu15i_BFu16i) C1{ Fi Fi:15 Fi:16}



static void Test_Ui_BFu15i_BFu16i()
{
  {
    init_simple_test("Ui_BFu15i_BFu16i");
    static STRUCT_IF_C Ui_BFu15i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "Ui_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "Ui_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu16i, Ui_BFu15i_BFu16i)
//============================================================================


struct  Ui_BFu15i_BFu16ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu15i_BFu16ll) C1{ Fi Fi:15 FL:16}



static void Test_Ui_BFu15i_BFu16ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu16ll");
    static STRUCT_IF_C Ui_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "Ui_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "Ui_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu16ll, Ui_BFu15i_BFu16ll)
//============================================================================


struct  Ui_BFu15i_BFu16s  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu15i_BFu16s) C1{ Fi Fi:15 Fs:16}



static void Test_Ui_BFu15i_BFu16s()
{
  {
    init_simple_test("Ui_BFu15i_BFu16s");
    static STRUCT_IF_C Ui_BFu15i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu16s, Ui_BFu15i_BFu16s)
//============================================================================


struct  Ui_BFu15i_BFu17i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu15i_BFu17i) C1{ Fi Fi:15 Fi:17}



static void Test_Ui_BFu15i_BFu17i()
{
  {
    init_simple_test("Ui_BFu15i_BFu17i");
    static STRUCT_IF_C Ui_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "Ui_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "Ui_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu17i, Ui_BFu15i_BFu17i)
//============================================================================


struct  Ui_BFu15i_BFu17ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu15i_BFu17ll) C1{ Fi Fi:15 FL:17}



static void Test_Ui_BFu15i_BFu17ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu17ll");
    static STRUCT_IF_C Ui_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "Ui_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "Ui_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu17ll, Ui_BFu15i_BFu17ll)
//============================================================================


struct  Ui_BFu15i_BFu1c  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu15i_BFu1c) C1{ Fi Fi:15 Fc:1}



static void Test_Ui_BFu15i_BFu1c()
{
  {
    init_simple_test("Ui_BFu15i_BFu1c");
    static STRUCT_IF_C Ui_BFu15i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu1c, Ui_BFu15i_BFu1c)
//============================================================================


struct  Ui_BFu15i_BFu1i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu15i_BFu1i) C1{ Fi Fi:15 Fi:1}



static void Test_Ui_BFu15i_BFu1i()
{
  {
    init_simple_test("Ui_BFu15i_BFu1i");
    static STRUCT_IF_C Ui_BFu15i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu1i, Ui_BFu15i_BFu1i)
//============================================================================


struct  Ui_BFu15i_BFu1ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu15i_BFu1ll) C1{ Fi Fi:15 FL:1}



static void Test_Ui_BFu15i_BFu1ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu1ll");
    static STRUCT_IF_C Ui_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu1ll, Ui_BFu15i_BFu1ll)
//============================================================================


struct  Ui_BFu15i_BFu1s  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu15i_BFu1s) C1{ Fi Fi:15 Fs:1}



static void Test_Ui_BFu15i_BFu1s()
{
  {
    init_simple_test("Ui_BFu15i_BFu1s");
    static STRUCT_IF_C Ui_BFu15i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu1s, Ui_BFu15i_BFu1s)
//============================================================================


struct  Ui_BFu15i_BFu31i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu15i_BFu31i) C1{ Fi Fi:15 Fi:31}



static void Test_Ui_BFu15i_BFu31i()
{
  {
    init_simple_test("Ui_BFu15i_BFu31i");
    static STRUCT_IF_C Ui_BFu15i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu31i, Ui_BFu15i_BFu31i)
//============================================================================


struct  Ui_BFu15i_BFu31ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu15i_BFu31ll) C1{ Fi Fi:15 FL:31}



static void Test_Ui_BFu15i_BFu31ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu31ll");
    static STRUCT_IF_C Ui_BFu15i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, 1, "Ui_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu31ll, Ui_BFu15i_BFu31ll)
//============================================================================


struct  Ui_BFu15i_BFu32i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu15i_BFu32i) C1{ Fi Fi:15 Fi:32}



static void Test_Ui_BFu15i_BFu32i()
{
  {
    init_simple_test("Ui_BFu15i_BFu32i");
    static STRUCT_IF_C Ui_BFu15i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu32i, Ui_BFu15i_BFu32i)
//============================================================================


struct  Ui_BFu15i_BFu32ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu15i_BFu32ll) C1{ Fi Fi:15 FL:32}



static void Test_Ui_BFu15i_BFu32ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu32ll");
    static STRUCT_IF_C Ui_BFu15i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, 1, "Ui_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu32ll, Ui_BFu15i_BFu32ll)
//============================================================================


struct  Ui_BFu15i_BFu33  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu15i_BFu33) C1{ Fi Fi:15 FL:33}



static void Test_Ui_BFu15i_BFu33()
{
  {
    init_simple_test("Ui_BFu15i_BFu33");
    static STRUCT_IF_C Ui_BFu15i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, 1, "Ui_BFu15i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu33, Ui_BFu15i_BFu33)
//============================================================================


struct  Ui_BFu15i_BFu7c  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu15i_BFu7c) C1{ Fi Fi:15 Fc:7}



static void Test_Ui_BFu15i_BFu7c()
{
  {
    init_simple_test("Ui_BFu15i_BFu7c");
    static STRUCT_IF_C Ui_BFu15i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu7c, Ui_BFu15i_BFu7c)
//============================================================================


struct  Ui_BFu15i_BFu7i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu15i_BFu7i) C1{ Fi Fi:15 Fi:7}



static void Test_Ui_BFu15i_BFu7i()
{
  {
    init_simple_test("Ui_BFu15i_BFu7i");
    static STRUCT_IF_C Ui_BFu15i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "Ui_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "Ui_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu7i, Ui_BFu15i_BFu7i)
//============================================================================


struct  Ui_BFu15i_BFu7ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu15i_BFu7ll) C1{ Fi Fi:15 FL:7}



static void Test_Ui_BFu15i_BFu7ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu7ll");
    static STRUCT_IF_C Ui_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "Ui_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "Ui_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu7ll, Ui_BFu15i_BFu7ll)
//============================================================================


struct  Ui_BFu15i_BFu7s  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu15i_BFu7s) C1{ Fi Fi:15 Fs:7}



static void Test_Ui_BFu15i_BFu7s()
{
  {
    init_simple_test("Ui_BFu15i_BFu7s");
    static STRUCT_IF_C Ui_BFu15i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu7s, Ui_BFu15i_BFu7s)
//============================================================================


struct  Ui_BFu15i_BFu8c  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu15i_BFu8c) C1{ Fi Fi:15 Fc:8}



static void Test_Ui_BFu15i_BFu8c()
{
  {
    init_simple_test("Ui_BFu15i_BFu8c");
    static STRUCT_IF_C Ui_BFu15i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu8c, Ui_BFu15i_BFu8c)
//============================================================================


struct  Ui_BFu15i_BFu8i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu15i_BFu8i) C1{ Fi Fi:15 Fi:8}



static void Test_Ui_BFu15i_BFu8i()
{
  {
    init_simple_test("Ui_BFu15i_BFu8i");
    static STRUCT_IF_C Ui_BFu15i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "Ui_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "Ui_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu8i, Ui_BFu15i_BFu8i)
//============================================================================


struct  Ui_BFu15i_BFu8ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu15i_BFu8ll) C1{ Fi Fi:15 FL:8}



static void Test_Ui_BFu15i_BFu8ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu8ll");
    static STRUCT_IF_C Ui_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "Ui_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "Ui_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu8ll, Ui_BFu15i_BFu8ll)
//============================================================================


struct  Ui_BFu15i_BFu8s  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu15i_BFu8s) C1{ Fi Fi:15 Fs:8}



static void Test_Ui_BFu15i_BFu8s()
{
  {
    init_simple_test("Ui_BFu15i_BFu8s");
    static STRUCT_IF_C Ui_BFu15i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu8s, Ui_BFu15i_BFu8s)
//============================================================================


struct  Ui_BFu15i_BFu9i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu15i_BFu9i) C1{ Fi Fi:15 Fi:9}



static void Test_Ui_BFu15i_BFu9i()
{
  {
    init_simple_test("Ui_BFu15i_BFu9i");
    static STRUCT_IF_C Ui_BFu15i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "Ui_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "Ui_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu9i, Ui_BFu15i_BFu9i)
//============================================================================


struct  Ui_BFu15i_BFu9ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu15i_BFu9ll) C1{ Fi Fi:15 FL:9}



static void Test_Ui_BFu15i_BFu9ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu9ll");
    static STRUCT_IF_C Ui_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "Ui_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "Ui_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu9ll, Ui_BFu15i_BFu9ll)
//============================================================================


struct  Ui_BFu15i_BFu9s  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu15i_BFu9s) C1{ Fi Fi:15 Fs:9}



static void Test_Ui_BFu15i_BFu9s()
{
  {
    init_simple_test("Ui_BFu15i_BFu9s");
    static STRUCT_IF_C Ui_BFu15i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_BFu9s, Ui_BFu15i_BFu9s)
//============================================================================


struct  Ui_BFu15i_C  {
  unsigned int v1;
  unsigned int v2:15;
  char v3;
};
//SIG(1 Ui_BFu15i_C) C1{ Fi Fi:15 Fc}



static void Test_Ui_BFu15i_C()
{
  {
    init_simple_test("Ui_BFu15i_C");
    static STRUCT_IF_C Ui_BFu15i_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_C");
    check_field_offset(lv, v3, 6, "Ui_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_C, Ui_BFu15i_C)
//============================================================================


struct  Ui_BFu15i_D  {
  unsigned int v1;
  unsigned int v2:15;
  double v3;
};
//SIG(1 Ui_BFu15i_D) C1{ Fi Fi:15 FL}



static void Test_Ui_BFu15i_D()
{
  {
    init_simple_test("Ui_BFu15i_D");
    static STRUCT_IF_C Ui_BFu15i_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_D");
    check_field_offset(lv, v3, 8, "Ui_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_D, Ui_BFu15i_D)
//============================================================================


struct  Ui_BFu15i_F  {
  unsigned int v1;
  unsigned int v2:15;
  float v3;
};
//SIG(1 Ui_BFu15i_F) C1{ Fi Fi:15 Fi}



static void Test_Ui_BFu15i_F()
{
  {
    init_simple_test("Ui_BFu15i_F");
    static STRUCT_IF_C Ui_BFu15i_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_F");
    check_field_offset(lv, v3, 8, "Ui_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_F, Ui_BFu15i_F)
//============================================================================


struct  Ui_BFu15i_I  {
  unsigned int v1;
  unsigned int v2:15;
  int v3;
};
//SIG(1 Ui_BFu15i_I) C1{ Fi Fi:15 Fi}



static void Test_Ui_BFu15i_I()
{
  {
    init_simple_test("Ui_BFu15i_I");
    static STRUCT_IF_C Ui_BFu15i_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_I");
    check_field_offset(lv, v3, 8, "Ui_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_I, Ui_BFu15i_I)
//============================================================================


struct  Ui_BFu15i_Ip  {
  unsigned int v1;
  unsigned int v2:15;
  int *v3;
};
//SIG(1 Ui_BFu15i_Ip) C1{ Fi Fi:15 Fp}



static void Test_Ui_BFu15i_Ip()
{
  {
    init_simple_test("Ui_BFu15i_Ip");
    static STRUCT_IF_C Ui_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_Ip, Ui_BFu15i_Ip)
//============================================================================


struct  Ui_BFu15i_L  {
  unsigned int v1;
  unsigned int v2:15;
  __tsi64 v3;
};
//SIG(1 Ui_BFu15i_L) C1{ Fi Fi:15 FL}



static void Test_Ui_BFu15i_L()
{
  {
    init_simple_test("Ui_BFu15i_L");
    static STRUCT_IF_C Ui_BFu15i_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_L");
    check_field_offset(lv, v3, 8, "Ui_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_L, Ui_BFu15i_L)
//============================================================================


struct  Ui_BFu15i_S  {
  unsigned int v1;
  unsigned int v2:15;
  short v3;
};
//SIG(1 Ui_BFu15i_S) C1{ Fi Fi:15 Fs}



static void Test_Ui_BFu15i_S()
{
  {
    init_simple_test("Ui_BFu15i_S");
    static STRUCT_IF_C Ui_BFu15i_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_S");
    check_field_offset(lv, v3, 6, "Ui_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_S, Ui_BFu15i_S)
//============================================================================


struct  Ui_BFu15i_Uc  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned char v3;
};
//SIG(1 Ui_BFu15i_Uc) C1{ Fi Fi:15 Fc}



static void Test_Ui_BFu15i_Uc()
{
  {
    init_simple_test("Ui_BFu15i_Uc");
    static STRUCT_IF_C Ui_BFu15i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_Uc");
    check_field_offset(lv, v3, 6, "Ui_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_Uc, Ui_BFu15i_Uc)
//============================================================================


struct  Ui_BFu15i_Ui  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int v3;
};
//SIG(1 Ui_BFu15i_Ui) C1{ Fi Fi:15 Fi}



static void Test_Ui_BFu15i_Ui()
{
  {
    init_simple_test("Ui_BFu15i_Ui");
    static STRUCT_IF_C Ui_BFu15i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_Ui, Ui_BFu15i_Ui)
//============================================================================


struct  Ui_BFu15i_Ul  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64 v3;
};
//SIG(1 Ui_BFu15i_Ul) C1{ Fi Fi:15 FL}



static void Test_Ui_BFu15i_Ul()
{
  {
    init_simple_test("Ui_BFu15i_Ul");
    static STRUCT_IF_C Ui_BFu15i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_Ul, Ui_BFu15i_Ul)
//============================================================================


struct  Ui_BFu15i_Us  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned short v3;
};
//SIG(1 Ui_BFu15i_Us) C1{ Fi Fi:15 Fs}



static void Test_Ui_BFu15i_Us()
{
  {
    init_simple_test("Ui_BFu15i_Us");
    static STRUCT_IF_C Ui_BFu15i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_Us, Ui_BFu15i_Us)
//============================================================================


struct  Ui_BFu15i_Vp  {
  unsigned int v1;
  unsigned int v2:15;
  void *v3;
};
//SIG(1 Ui_BFu15i_Vp) C1{ Fi Fi:15 Fp}



static void Test_Ui_BFu15i_Vp()
{
  {
    init_simple_test("Ui_BFu15i_Vp");
    static STRUCT_IF_C Ui_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15i_Vp, Ui_BFu15i_Vp)
//============================================================================


struct  Ui_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:15;
};
//SIG(1 Ui_BFu15ll) C1{ Fi FL:15}



static void Test_Ui_BFu15ll()
{
  {
    init_simple_test("Ui_BFu15ll");
    static STRUCT_IF_C Ui_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll, Ui_BFu15ll)
//============================================================================


struct  Ui_BFu15ll_BFu15i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu15ll_BFu15i) C1{ Fi FL:15 Fi:15}



static void Test_Ui_BFu15ll_BFu15i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu15i");
    static STRUCT_IF_C Ui_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "Ui_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu15i, Ui_BFu15ll_BFu15i)
//============================================================================


struct  Ui_BFu15ll_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu15ll_BFu15ll) C1{ Fi FL:15 FL:15}



static void Test_Ui_BFu15ll_BFu15ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu15ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "Ui_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu15ll, Ui_BFu15ll_BFu15ll)
//============================================================================


struct  Ui_BFu15ll_BFu15s  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu15ll_BFu15s) C1{ Fi FL:15 Fs:15}



static void Test_Ui_BFu15ll_BFu15s()
{
  {
    init_simple_test("Ui_BFu15ll_BFu15s");
    static STRUCT_IF_C Ui_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu15s, Ui_BFu15ll_BFu15s)
//============================================================================


struct  Ui_BFu15ll_BFu16i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu15ll_BFu16i) C1{ Fi FL:15 Fi:16}



static void Test_Ui_BFu15ll_BFu16i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu16i");
    static STRUCT_IF_C Ui_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "Ui_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "Ui_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu16i, Ui_BFu15ll_BFu16i)
//============================================================================


struct  Ui_BFu15ll_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu15ll_BFu16ll) C1{ Fi FL:15 FL:16}



static void Test_Ui_BFu15ll_BFu16ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu16ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "Ui_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "Ui_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu16ll, Ui_BFu15ll_BFu16ll)
//============================================================================


struct  Ui_BFu15ll_BFu16s  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu15ll_BFu16s) C1{ Fi FL:15 Fs:16}



static void Test_Ui_BFu15ll_BFu16s()
{
  {
    init_simple_test("Ui_BFu15ll_BFu16s");
    static STRUCT_IF_C Ui_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu16s, Ui_BFu15ll_BFu16s)
//============================================================================


struct  Ui_BFu15ll_BFu17i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu15ll_BFu17i) C1{ Fi FL:15 Fi:17}



static void Test_Ui_BFu15ll_BFu17i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu17i");
    static STRUCT_IF_C Ui_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "Ui_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "Ui_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu17i, Ui_BFu15ll_BFu17i)
//============================================================================


struct  Ui_BFu15ll_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu15ll_BFu17ll) C1{ Fi FL:15 FL:17}



static void Test_Ui_BFu15ll_BFu17ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu17ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "Ui_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "Ui_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu17ll, Ui_BFu15ll_BFu17ll)
//============================================================================


struct  Ui_BFu15ll_BFu1c  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu15ll_BFu1c) C1{ Fi FL:15 Fc:1}



static void Test_Ui_BFu15ll_BFu1c()
{
  {
    init_simple_test("Ui_BFu15ll_BFu1c");
    static STRUCT_IF_C Ui_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu1c, Ui_BFu15ll_BFu1c)
//============================================================================


struct  Ui_BFu15ll_BFu1i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu15ll_BFu1i) C1{ Fi FL:15 Fi:1}



static void Test_Ui_BFu15ll_BFu1i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu1i");
    static STRUCT_IF_C Ui_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu1i, Ui_BFu15ll_BFu1i)
//============================================================================


struct  Ui_BFu15ll_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu15ll_BFu1ll) C1{ Fi FL:15 FL:1}



static void Test_Ui_BFu15ll_BFu1ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu1ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu1ll, Ui_BFu15ll_BFu1ll)
//============================================================================


struct  Ui_BFu15ll_BFu1s  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu15ll_BFu1s) C1{ Fi FL:15 Fs:1}



static void Test_Ui_BFu15ll_BFu1s()
{
  {
    init_simple_test("Ui_BFu15ll_BFu1s");
    static STRUCT_IF_C Ui_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu1s, Ui_BFu15ll_BFu1s)
//============================================================================


struct  Ui_BFu15ll_BFu31i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu15ll_BFu31i) C1{ Fi FL:15 Fi:31}



static void Test_Ui_BFu15ll_BFu31i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu31i");
    static STRUCT_IF_C Ui_BFu15ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu31i, Ui_BFu15ll_BFu31i)
//============================================================================


struct  Ui_BFu15ll_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu15ll_BFu31ll) C1{ Fi FL:15 FL:31}



static void Test_Ui_BFu15ll_BFu31ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu31ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, 1, "Ui_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu31ll, Ui_BFu15ll_BFu31ll)
//============================================================================


struct  Ui_BFu15ll_BFu32i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu15ll_BFu32i) C1{ Fi FL:15 Fi:32}



static void Test_Ui_BFu15ll_BFu32i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu32i");
    static STRUCT_IF_C Ui_BFu15ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu32i, Ui_BFu15ll_BFu32i)
//============================================================================


struct  Ui_BFu15ll_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu15ll_BFu32ll) C1{ Fi FL:15 FL:32}



static void Test_Ui_BFu15ll_BFu32ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu32ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, 1, "Ui_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu32ll, Ui_BFu15ll_BFu32ll)
//============================================================================


struct  Ui_BFu15ll_BFu33  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu15ll_BFu33) C1{ Fi FL:15 FL:33}



static void Test_Ui_BFu15ll_BFu33()
{
  {
    init_simple_test("Ui_BFu15ll_BFu33");
    static STRUCT_IF_C Ui_BFu15ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, 1, "Ui_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu33, Ui_BFu15ll_BFu33)
//============================================================================


struct  Ui_BFu15ll_BFu7c  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu15ll_BFu7c) C1{ Fi FL:15 Fc:7}



static void Test_Ui_BFu15ll_BFu7c()
{
  {
    init_simple_test("Ui_BFu15ll_BFu7c");
    static STRUCT_IF_C Ui_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu7c, Ui_BFu15ll_BFu7c)
//============================================================================


struct  Ui_BFu15ll_BFu7i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu15ll_BFu7i) C1{ Fi FL:15 Fi:7}



static void Test_Ui_BFu15ll_BFu7i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu7i");
    static STRUCT_IF_C Ui_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "Ui_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "Ui_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu7i, Ui_BFu15ll_BFu7i)
//============================================================================


struct  Ui_BFu15ll_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu15ll_BFu7ll) C1{ Fi FL:15 FL:7}



static void Test_Ui_BFu15ll_BFu7ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu7ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "Ui_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "Ui_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu7ll, Ui_BFu15ll_BFu7ll)
//============================================================================


struct  Ui_BFu15ll_BFu7s  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu15ll_BFu7s) C1{ Fi FL:15 Fs:7}



static void Test_Ui_BFu15ll_BFu7s()
{
  {
    init_simple_test("Ui_BFu15ll_BFu7s");
    static STRUCT_IF_C Ui_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu7s, Ui_BFu15ll_BFu7s)
//============================================================================


struct  Ui_BFu15ll_BFu8c  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu15ll_BFu8c) C1{ Fi FL:15 Fc:8}



static void Test_Ui_BFu15ll_BFu8c()
{
  {
    init_simple_test("Ui_BFu15ll_BFu8c");
    static STRUCT_IF_C Ui_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu8c, Ui_BFu15ll_BFu8c)
//============================================================================


struct  Ui_BFu15ll_BFu8i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu15ll_BFu8i) C1{ Fi FL:15 Fi:8}



static void Test_Ui_BFu15ll_BFu8i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu8i");
    static STRUCT_IF_C Ui_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "Ui_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "Ui_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu8i, Ui_BFu15ll_BFu8i)
//============================================================================


struct  Ui_BFu15ll_BFu8ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu15ll_BFu8ll) C1{ Fi FL:15 FL:8}



static void Test_Ui_BFu15ll_BFu8ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu8ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "Ui_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "Ui_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu8ll, Ui_BFu15ll_BFu8ll)
//============================================================================


struct  Ui_BFu15ll_BFu8s  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu15ll_BFu8s) C1{ Fi FL:15 Fs:8}



static void Test_Ui_BFu15ll_BFu8s()
{
  {
    init_simple_test("Ui_BFu15ll_BFu8s");
    static STRUCT_IF_C Ui_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu8s, Ui_BFu15ll_BFu8s)
//============================================================================


struct  Ui_BFu15ll_BFu9i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu15ll_BFu9i) C1{ Fi FL:15 Fi:9}



static void Test_Ui_BFu15ll_BFu9i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu9i");
    static STRUCT_IF_C Ui_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "Ui_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "Ui_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu9i, Ui_BFu15ll_BFu9i)
//============================================================================


struct  Ui_BFu15ll_BFu9ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu15ll_BFu9ll) C1{ Fi FL:15 FL:9}



static void Test_Ui_BFu15ll_BFu9ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu9ll");
    static STRUCT_IF_C Ui_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "Ui_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "Ui_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu9ll, Ui_BFu15ll_BFu9ll)
//============================================================================


struct  Ui_BFu15ll_BFu9s  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu15ll_BFu9s) C1{ Fi FL:15 Fs:9}



static void Test_Ui_BFu15ll_BFu9s()
{
  {
    init_simple_test("Ui_BFu15ll_BFu9s");
    static STRUCT_IF_C Ui_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_BFu9s, Ui_BFu15ll_BFu9s)
//============================================================================


struct  Ui_BFu15ll_C  {
  unsigned int v1;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 Ui_BFu15ll_C) C1{ Fi FL:15 Fc}



static void Test_Ui_BFu15ll_C()
{
  {
    init_simple_test("Ui_BFu15ll_C");
    static STRUCT_IF_C Ui_BFu15ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_C");
    check_field_offset(lv, v3, 6, "Ui_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_C, Ui_BFu15ll_C)
//============================================================================


struct  Ui_BFu15ll_D  {
  unsigned int v1;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 Ui_BFu15ll_D) C1{ Fi FL:15 FL}



static void Test_Ui_BFu15ll_D()
{
  {
    init_simple_test("Ui_BFu15ll_D");
    static STRUCT_IF_C Ui_BFu15ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_D");
    check_field_offset(lv, v3, 8, "Ui_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_D, Ui_BFu15ll_D)
//============================================================================


struct  Ui_BFu15ll_F  {
  unsigned int v1;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 Ui_BFu15ll_F) C1{ Fi FL:15 Fi}



static void Test_Ui_BFu15ll_F()
{
  {
    init_simple_test("Ui_BFu15ll_F");
    static STRUCT_IF_C Ui_BFu15ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_F");
    check_field_offset(lv, v3, 8, "Ui_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_F, Ui_BFu15ll_F)
//============================================================================


struct  Ui_BFu15ll_I  {
  unsigned int v1;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 Ui_BFu15ll_I) C1{ Fi FL:15 Fi}



static void Test_Ui_BFu15ll_I()
{
  {
    init_simple_test("Ui_BFu15ll_I");
    static STRUCT_IF_C Ui_BFu15ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_I");
    check_field_offset(lv, v3, 8, "Ui_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_I, Ui_BFu15ll_I)
//============================================================================


struct  Ui_BFu15ll_Ip  {
  unsigned int v1;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 Ui_BFu15ll_Ip) C1{ Fi FL:15 Fp}



static void Test_Ui_BFu15ll_Ip()
{
  {
    init_simple_test("Ui_BFu15ll_Ip");
    static STRUCT_IF_C Ui_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_Ip, Ui_BFu15ll_Ip)
//============================================================================


struct  Ui_BFu15ll_L  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 Ui_BFu15ll_L) C1{ Fi FL:15 FL}



static void Test_Ui_BFu15ll_L()
{
  {
    init_simple_test("Ui_BFu15ll_L");
    static STRUCT_IF_C Ui_BFu15ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_L");
    check_field_offset(lv, v3, 8, "Ui_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_L, Ui_BFu15ll_L)
//============================================================================


struct  Ui_BFu15ll_S  {
  unsigned int v1;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 Ui_BFu15ll_S) C1{ Fi FL:15 Fs}



static void Test_Ui_BFu15ll_S()
{
  {
    init_simple_test("Ui_BFu15ll_S");
    static STRUCT_IF_C Ui_BFu15ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_S");
    check_field_offset(lv, v3, 6, "Ui_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_S, Ui_BFu15ll_S)
//============================================================================


struct  Ui_BFu15ll_Uc  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 Ui_BFu15ll_Uc) C1{ Fi FL:15 Fc}



static void Test_Ui_BFu15ll_Uc()
{
  {
    init_simple_test("Ui_BFu15ll_Uc");
    static STRUCT_IF_C Ui_BFu15ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_Uc");
    check_field_offset(lv, v3, 6, "Ui_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_Uc, Ui_BFu15ll_Uc)
//============================================================================


struct  Ui_BFu15ll_Ui  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 Ui_BFu15ll_Ui) C1{ Fi FL:15 Fi}



static void Test_Ui_BFu15ll_Ui()
{
  {
    init_simple_test("Ui_BFu15ll_Ui");
    static STRUCT_IF_C Ui_BFu15ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_Ui, Ui_BFu15ll_Ui)
//============================================================================


struct  Ui_BFu15ll_Ul  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 Ui_BFu15ll_Ul) C1{ Fi FL:15 FL}



static void Test_Ui_BFu15ll_Ul()
{
  {
    init_simple_test("Ui_BFu15ll_Ul");
    static STRUCT_IF_C Ui_BFu15ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_Ul, Ui_BFu15ll_Ul)
//============================================================================


struct  Ui_BFu15ll_Us  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 Ui_BFu15ll_Us) C1{ Fi FL:15 Fs}



static void Test_Ui_BFu15ll_Us()
{
  {
    init_simple_test("Ui_BFu15ll_Us");
    static STRUCT_IF_C Ui_BFu15ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_Us, Ui_BFu15ll_Us)
//============================================================================


struct  Ui_BFu15ll_Vp  {
  unsigned int v1;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 Ui_BFu15ll_Vp) C1{ Fi FL:15 Fp}



static void Test_Ui_BFu15ll_Vp()
{
  {
    init_simple_test("Ui_BFu15ll_Vp");
    static STRUCT_IF_C Ui_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15ll_Vp, Ui_BFu15ll_Vp)
//============================================================================


struct  Ui_BFu15s  {
  unsigned int v1;
  unsigned short v2:15;
};
//SIG(1 Ui_BFu15s) C1{ Fi Fs:15}



static void Test_Ui_BFu15s()
{
  {
    init_simple_test("Ui_BFu15s");
    static STRUCT_IF_C Ui_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s, Ui_BFu15s)
//============================================================================


struct  Ui_BFu15s_BFu15i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu15s_BFu15i) C1{ Fi Fs:15 Fi:15}



static void Test_Ui_BFu15s_BFu15i()
{
  {
    init_simple_test("Ui_BFu15s_BFu15i");
    static STRUCT_IF_C Ui_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "Ui_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu15i, Ui_BFu15s_BFu15i)
//============================================================================


struct  Ui_BFu15s_BFu15ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu15s_BFu15ll) C1{ Fi Fs:15 FL:15}



static void Test_Ui_BFu15s_BFu15ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu15ll");
    static STRUCT_IF_C Ui_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "Ui_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu15ll, Ui_BFu15s_BFu15ll)
//============================================================================


struct  Ui_BFu15s_BFu15s  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu15s_BFu15s) C1{ Fi Fs:15 Fs:15}



static void Test_Ui_BFu15s_BFu15s()
{
  {
    init_simple_test("Ui_BFu15s_BFu15s");
    static STRUCT_IF_C Ui_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu15s, Ui_BFu15s_BFu15s)
//============================================================================


struct  Ui_BFu15s_BFu16i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu15s_BFu16i) C1{ Fi Fs:15 Fi:16}



static void Test_Ui_BFu15s_BFu16i()
{
  {
    init_simple_test("Ui_BFu15s_BFu16i");
    static STRUCT_IF_C Ui_BFu15s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "Ui_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "Ui_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu16i, Ui_BFu15s_BFu16i)
//============================================================================


struct  Ui_BFu15s_BFu16ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu15s_BFu16ll) C1{ Fi Fs:15 FL:16}



static void Test_Ui_BFu15s_BFu16ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu16ll");
    static STRUCT_IF_C Ui_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "Ui_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "Ui_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu16ll, Ui_BFu15s_BFu16ll)
//============================================================================


struct  Ui_BFu15s_BFu16s  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu15s_BFu16s) C1{ Fi Fs:15 Fs:16}



static void Test_Ui_BFu15s_BFu16s()
{
  {
    init_simple_test("Ui_BFu15s_BFu16s");
    static STRUCT_IF_C Ui_BFu15s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu16s, Ui_BFu15s_BFu16s)
//============================================================================


struct  Ui_BFu15s_BFu17i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu15s_BFu17i) C1{ Fi Fs:15 Fi:17}



static void Test_Ui_BFu15s_BFu17i()
{
  {
    init_simple_test("Ui_BFu15s_BFu17i");
    static STRUCT_IF_C Ui_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "Ui_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "Ui_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu17i, Ui_BFu15s_BFu17i)
//============================================================================


struct  Ui_BFu15s_BFu17ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu15s_BFu17ll) C1{ Fi Fs:15 FL:17}



static void Test_Ui_BFu15s_BFu17ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu17ll");
    static STRUCT_IF_C Ui_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "Ui_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "Ui_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu17ll, Ui_BFu15s_BFu17ll)
//============================================================================


struct  Ui_BFu15s_BFu1c  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu15s_BFu1c) C1{ Fi Fs:15 Fc:1}



static void Test_Ui_BFu15s_BFu1c()
{
  {
    init_simple_test("Ui_BFu15s_BFu1c");
    static STRUCT_IF_C Ui_BFu15s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu1c, Ui_BFu15s_BFu1c)
//============================================================================


struct  Ui_BFu15s_BFu1i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu15s_BFu1i) C1{ Fi Fs:15 Fi:1}



static void Test_Ui_BFu15s_BFu1i()
{
  {
    init_simple_test("Ui_BFu15s_BFu1i");
    static STRUCT_IF_C Ui_BFu15s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu1i, Ui_BFu15s_BFu1i)
//============================================================================


struct  Ui_BFu15s_BFu1ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu15s_BFu1ll) C1{ Fi Fs:15 FL:1}



static void Test_Ui_BFu15s_BFu1ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu1ll");
    static STRUCT_IF_C Ui_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu1ll, Ui_BFu15s_BFu1ll)
//============================================================================


struct  Ui_BFu15s_BFu1s  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu15s_BFu1s) C1{ Fi Fs:15 Fs:1}



static void Test_Ui_BFu15s_BFu1s()
{
  {
    init_simple_test("Ui_BFu15s_BFu1s");
    static STRUCT_IF_C Ui_BFu15s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Ui_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu1s, Ui_BFu15s_BFu1s)
//============================================================================


struct  Ui_BFu15s_BFu31i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu15s_BFu31i) C1{ Fi Fs:15 Fi:31}



static void Test_Ui_BFu15s_BFu31i()
{
  {
    init_simple_test("Ui_BFu15s_BFu31i");
    static STRUCT_IF_C Ui_BFu15s_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu31i, Ui_BFu15s_BFu31i)
//============================================================================


struct  Ui_BFu15s_BFu31ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu15s_BFu31ll) C1{ Fi Fs:15 FL:31}



static void Test_Ui_BFu15s_BFu31ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu31ll");
    static STRUCT_IF_C Ui_BFu15s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, 1, "Ui_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu31ll, Ui_BFu15s_BFu31ll)
//============================================================================


struct  Ui_BFu15s_BFu32i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu15s_BFu32i) C1{ Fi Fs:15 Fi:32}



static void Test_Ui_BFu15s_BFu32i()
{
  {
    init_simple_test("Ui_BFu15s_BFu32i");
    static STRUCT_IF_C Ui_BFu15s_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu32i, Ui_BFu15s_BFu32i)
//============================================================================


struct  Ui_BFu15s_BFu32ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu15s_BFu32ll) C1{ Fi Fs:15 FL:32}



static void Test_Ui_BFu15s_BFu32ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu32ll");
    static STRUCT_IF_C Ui_BFu15s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, 1, "Ui_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu32ll, Ui_BFu15s_BFu32ll)
//============================================================================


struct  Ui_BFu15s_BFu33  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu15s_BFu33) C1{ Fi Fs:15 FL:33}



static void Test_Ui_BFu15s_BFu33()
{
  {
    init_simple_test("Ui_BFu15s_BFu33");
    static STRUCT_IF_C Ui_BFu15s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, 1, "Ui_BFu15s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu33, Ui_BFu15s_BFu33)
//============================================================================


struct  Ui_BFu15s_BFu7c  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu15s_BFu7c) C1{ Fi Fs:15 Fc:7}



static void Test_Ui_BFu15s_BFu7c()
{
  {
    init_simple_test("Ui_BFu15s_BFu7c");
    static STRUCT_IF_C Ui_BFu15s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu7c, Ui_BFu15s_BFu7c)
//============================================================================


struct  Ui_BFu15s_BFu7i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu15s_BFu7i) C1{ Fi Fs:15 Fi:7}



static void Test_Ui_BFu15s_BFu7i()
{
  {
    init_simple_test("Ui_BFu15s_BFu7i");
    static STRUCT_IF_C Ui_BFu15s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "Ui_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "Ui_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu7i, Ui_BFu15s_BFu7i)
//============================================================================


struct  Ui_BFu15s_BFu7ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu15s_BFu7ll) C1{ Fi Fs:15 FL:7}



static void Test_Ui_BFu15s_BFu7ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu7ll");
    static STRUCT_IF_C Ui_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "Ui_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "Ui_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu7ll, Ui_BFu15s_BFu7ll)
//============================================================================


struct  Ui_BFu15s_BFu7s  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu15s_BFu7s) C1{ Fi Fs:15 Fs:7}



static void Test_Ui_BFu15s_BFu7s()
{
  {
    init_simple_test("Ui_BFu15s_BFu7s");
    static STRUCT_IF_C Ui_BFu15s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu7s, Ui_BFu15s_BFu7s)
//============================================================================


struct  Ui_BFu15s_BFu8c  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu15s_BFu8c) C1{ Fi Fs:15 Fc:8}



static void Test_Ui_BFu15s_BFu8c()
{
  {
    init_simple_test("Ui_BFu15s_BFu8c");
    static STRUCT_IF_C Ui_BFu15s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu8c, Ui_BFu15s_BFu8c)
//============================================================================


struct  Ui_BFu15s_BFu8i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu15s_BFu8i) C1{ Fi Fs:15 Fi:8}



static void Test_Ui_BFu15s_BFu8i()
{
  {
    init_simple_test("Ui_BFu15s_BFu8i");
    static STRUCT_IF_C Ui_BFu15s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "Ui_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "Ui_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu8i, Ui_BFu15s_BFu8i)
//============================================================================


struct  Ui_BFu15s_BFu8ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu15s_BFu8ll) C1{ Fi Fs:15 FL:8}



static void Test_Ui_BFu15s_BFu8ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu8ll");
    static STRUCT_IF_C Ui_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "Ui_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "Ui_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu8ll, Ui_BFu15s_BFu8ll)
//============================================================================


struct  Ui_BFu15s_BFu8s  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu15s_BFu8s) C1{ Fi Fs:15 Fs:8}



static void Test_Ui_BFu15s_BFu8s()
{
  {
    init_simple_test("Ui_BFu15s_BFu8s");
    static STRUCT_IF_C Ui_BFu15s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu8s, Ui_BFu15s_BFu8s)
//============================================================================


struct  Ui_BFu15s_BFu9i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu15s_BFu9i) C1{ Fi Fs:15 Fi:9}



static void Test_Ui_BFu15s_BFu9i()
{
  {
    init_simple_test("Ui_BFu15s_BFu9i");
    static STRUCT_IF_C Ui_BFu15s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "Ui_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "Ui_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu9i, Ui_BFu15s_BFu9i)
//============================================================================


struct  Ui_BFu15s_BFu9ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu15s_BFu9ll) C1{ Fi Fs:15 FL:9}



static void Test_Ui_BFu15s_BFu9ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu9ll");
    static STRUCT_IF_C Ui_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "Ui_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "Ui_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu9ll, Ui_BFu15s_BFu9ll)
//============================================================================


struct  Ui_BFu15s_BFu9s  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu15s_BFu9s) C1{ Fi Fs:15 Fs:9}



static void Test_Ui_BFu15s_BFu9s()
{
  {
    init_simple_test("Ui_BFu15s_BFu9s");
    static STRUCT_IF_C Ui_BFu15s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_BFu9s, Ui_BFu15s_BFu9s)
//============================================================================


struct  Ui_BFu15s_C  {
  unsigned int v1;
  unsigned short v2:15;
  char v3;
};
//SIG(1 Ui_BFu15s_C) C1{ Fi Fs:15 Fc}



static void Test_Ui_BFu15s_C()
{
  {
    init_simple_test("Ui_BFu15s_C");
    static STRUCT_IF_C Ui_BFu15s_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_C");
    check_field_offset(lv, v3, 6, "Ui_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_C, Ui_BFu15s_C)
//============================================================================


struct  Ui_BFu15s_D  {
  unsigned int v1;
  unsigned short v2:15;
  double v3;
};
//SIG(1 Ui_BFu15s_D) C1{ Fi Fs:15 FL}



static void Test_Ui_BFu15s_D()
{
  {
    init_simple_test("Ui_BFu15s_D");
    static STRUCT_IF_C Ui_BFu15s_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_D");
    check_field_offset(lv, v3, 8, "Ui_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_D, Ui_BFu15s_D)
//============================================================================


struct  Ui_BFu15s_F  {
  unsigned int v1;
  unsigned short v2:15;
  float v3;
};
//SIG(1 Ui_BFu15s_F) C1{ Fi Fs:15 Fi}



static void Test_Ui_BFu15s_F()
{
  {
    init_simple_test("Ui_BFu15s_F");
    static STRUCT_IF_C Ui_BFu15s_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_F");
    check_field_offset(lv, v3, 8, "Ui_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_F, Ui_BFu15s_F)
//============================================================================


struct  Ui_BFu15s_I  {
  unsigned int v1;
  unsigned short v2:15;
  int v3;
};
//SIG(1 Ui_BFu15s_I) C1{ Fi Fs:15 Fi}



static void Test_Ui_BFu15s_I()
{
  {
    init_simple_test("Ui_BFu15s_I");
    static STRUCT_IF_C Ui_BFu15s_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_I");
    check_field_offset(lv, v3, 8, "Ui_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_I, Ui_BFu15s_I)
//============================================================================


struct  Ui_BFu15s_Ip  {
  unsigned int v1;
  unsigned short v2:15;
  int *v3;
};
//SIG(1 Ui_BFu15s_Ip) C1{ Fi Fs:15 Fp}



static void Test_Ui_BFu15s_Ip()
{
  {
    init_simple_test("Ui_BFu15s_Ip");
    static STRUCT_IF_C Ui_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_Ip, Ui_BFu15s_Ip)
//============================================================================


struct  Ui_BFu15s_L  {
  unsigned int v1;
  unsigned short v2:15;
  __tsi64 v3;
};
//SIG(1 Ui_BFu15s_L) C1{ Fi Fs:15 FL}



static void Test_Ui_BFu15s_L()
{
  {
    init_simple_test("Ui_BFu15s_L");
    static STRUCT_IF_C Ui_BFu15s_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_L");
    check_field_offset(lv, v3, 8, "Ui_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_L, Ui_BFu15s_L)
//============================================================================


struct  Ui_BFu15s_S  {
  unsigned int v1;
  unsigned short v2:15;
  short v3;
};
//SIG(1 Ui_BFu15s_S) C1{ Fi Fs:15 Fs}



static void Test_Ui_BFu15s_S()
{
  {
    init_simple_test("Ui_BFu15s_S");
    static STRUCT_IF_C Ui_BFu15s_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_S");
    check_field_offset(lv, v3, 6, "Ui_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_S, Ui_BFu15s_S)
//============================================================================


struct  Ui_BFu15s_Uc  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned char v3;
};
//SIG(1 Ui_BFu15s_Uc) C1{ Fi Fs:15 Fc}



static void Test_Ui_BFu15s_Uc()
{
  {
    init_simple_test("Ui_BFu15s_Uc");
    static STRUCT_IF_C Ui_BFu15s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_Uc");
    check_field_offset(lv, v3, 6, "Ui_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_Uc, Ui_BFu15s_Uc)
//============================================================================


struct  Ui_BFu15s_Ui  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int v3;
};
//SIG(1 Ui_BFu15s_Ui) C1{ Fi Fs:15 Fi}



static void Test_Ui_BFu15s_Ui()
{
  {
    init_simple_test("Ui_BFu15s_Ui");
    static STRUCT_IF_C Ui_BFu15s_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu15s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_Ui, Ui_BFu15s_Ui)
//============================================================================


struct  Ui_BFu15s_Ul  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64 v3;
};
//SIG(1 Ui_BFu15s_Ul) C1{ Fi Fs:15 FL}



static void Test_Ui_BFu15s_Ul()
{
  {
    init_simple_test("Ui_BFu15s_Ul");
    static STRUCT_IF_C Ui_BFu15s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_Ul, Ui_BFu15s_Ul)
//============================================================================


struct  Ui_BFu15s_Us  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 Ui_BFu15s_Us) C1{ Fi Fs:15 Fs}



static void Test_Ui_BFu15s_Us()
{
  {
    init_simple_test("Ui_BFu15s_Us");
    static STRUCT_IF_C Ui_BFu15s_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_Us, Ui_BFu15s_Us)
//============================================================================


struct  Ui_BFu15s_Vp  {
  unsigned int v1;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 Ui_BFu15s_Vp) C1{ Fi Fs:15 Fp}



static void Test_Ui_BFu15s_Vp()
{
  {
    init_simple_test("Ui_BFu15s_Vp");
    static STRUCT_IF_C Ui_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu15s_Vp, Ui_BFu15s_Vp)
//============================================================================


struct  Ui_BFu16i  {
  unsigned int v1;
  unsigned int v2:16;
};
//SIG(1 Ui_BFu16i) C1{ Fi Fi:16}



static void Test_Ui_BFu16i()
{
  {
    init_simple_test("Ui_BFu16i");
    static STRUCT_IF_C Ui_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i, Ui_BFu16i)
//============================================================================


struct  Ui_BFu16i_BFu15i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu16i_BFu15i) C1{ Fi Fi:16 Fi:15}



static void Test_Ui_BFu16i_BFu15i()
{
  {
    init_simple_test("Ui_BFu16i_BFu15i");
    static STRUCT_IF_C Ui_BFu16i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu15i, Ui_BFu16i_BFu15i)
//============================================================================


struct  Ui_BFu16i_BFu15ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu16i_BFu15ll) C1{ Fi Fi:16 FL:15}



static void Test_Ui_BFu16i_BFu15ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu15ll");
    static STRUCT_IF_C Ui_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu15ll, Ui_BFu16i_BFu15ll)
//============================================================================


struct  Ui_BFu16i_BFu15s  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu16i_BFu15s) C1{ Fi Fi:16 Fs:15}



static void Test_Ui_BFu16i_BFu15s()
{
  {
    init_simple_test("Ui_BFu16i_BFu15s");
    static STRUCT_IF_C Ui_BFu16i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu15s, Ui_BFu16i_BFu15s)
//============================================================================


struct  Ui_BFu16i_BFu16i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu16i_BFu16i) C1{ Fi Fi:16 Fi:16}



static void Test_Ui_BFu16i_BFu16i()
{
  {
    init_simple_test("Ui_BFu16i_BFu16i");
    static STRUCT_IF_C Ui_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu16i, Ui_BFu16i_BFu16i)
//============================================================================


struct  Ui_BFu16i_BFu16ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu16i_BFu16ll) C1{ Fi Fi:16 FL:16}



static void Test_Ui_BFu16i_BFu16ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu16ll");
    static STRUCT_IF_C Ui_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu16ll, Ui_BFu16i_BFu16ll)
//============================================================================


struct  Ui_BFu16i_BFu16s  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu16i_BFu16s) C1{ Fi Fi:16 Fs:16}



static void Test_Ui_BFu16i_BFu16s()
{
  {
    init_simple_test("Ui_BFu16i_BFu16s");
    static STRUCT_IF_C Ui_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu16s, Ui_BFu16i_BFu16s)
//============================================================================


struct  Ui_BFu16i_BFu17i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu16i_BFu17i) C1{ Fi Fi:16 Fi:17}



static void Test_Ui_BFu16i_BFu17i()
{
  {
    init_simple_test("Ui_BFu16i_BFu17i");
    static STRUCT_IF_C Ui_BFu16i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu17i, Ui_BFu16i_BFu17i)
//============================================================================


struct  Ui_BFu16i_BFu17ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu16i_BFu17ll) C1{ Fi Fi:16 FL:17}



static void Test_Ui_BFu16i_BFu17ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu17ll");
    static STRUCT_IF_C Ui_BFu16i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "Ui_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "Ui_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu17ll, Ui_BFu16i_BFu17ll)
//============================================================================


struct  Ui_BFu16i_BFu1c  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu16i_BFu1c) C1{ Fi Fi:16 Fc:1}



static void Test_Ui_BFu16i_BFu1c()
{
  {
    init_simple_test("Ui_BFu16i_BFu1c");
    static STRUCT_IF_C Ui_BFu16i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu1c, Ui_BFu16i_BFu1c)
//============================================================================


struct  Ui_BFu16i_BFu1i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu16i_BFu1i) C1{ Fi Fi:16 Fi:1}



static void Test_Ui_BFu16i_BFu1i()
{
  {
    init_simple_test("Ui_BFu16i_BFu1i");
    static STRUCT_IF_C Ui_BFu16i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu1i, Ui_BFu16i_BFu1i)
//============================================================================


struct  Ui_BFu16i_BFu1ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu16i_BFu1ll) C1{ Fi Fi:16 FL:1}



static void Test_Ui_BFu16i_BFu1ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu1ll");
    static STRUCT_IF_C Ui_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu1ll, Ui_BFu16i_BFu1ll)
//============================================================================


struct  Ui_BFu16i_BFu1s  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu16i_BFu1s) C1{ Fi Fi:16 Fs:1}



static void Test_Ui_BFu16i_BFu1s()
{
  {
    init_simple_test("Ui_BFu16i_BFu1s");
    static STRUCT_IF_C Ui_BFu16i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu1s, Ui_BFu16i_BFu1s)
//============================================================================


struct  Ui_BFu16i_BFu31i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu16i_BFu31i) C1{ Fi Fi:16 Fi:31}



static void Test_Ui_BFu16i_BFu31i()
{
  {
    init_simple_test("Ui_BFu16i_BFu31i");
    static STRUCT_IF_C Ui_BFu16i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu31i, Ui_BFu16i_BFu31i)
//============================================================================


struct  Ui_BFu16i_BFu31ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu16i_BFu31ll) C1{ Fi Fi:16 FL:31}



static void Test_Ui_BFu16i_BFu31ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu31ll");
    static STRUCT_IF_C Ui_BFu16i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "Ui_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "Ui_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu31ll, Ui_BFu16i_BFu31ll)
//============================================================================


struct  Ui_BFu16i_BFu32i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu16i_BFu32i) C1{ Fi Fi:16 Fi:32}



static void Test_Ui_BFu16i_BFu32i()
{
  {
    init_simple_test("Ui_BFu16i_BFu32i");
    static STRUCT_IF_C Ui_BFu16i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu32i, Ui_BFu16i_BFu32i)
//============================================================================


struct  Ui_BFu16i_BFu32ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu16i_BFu32ll) C1{ Fi Fi:16 FL:32}



static void Test_Ui_BFu16i_BFu32ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu32ll");
    static STRUCT_IF_C Ui_BFu16i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "Ui_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "Ui_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu32ll, Ui_BFu16i_BFu32ll)
//============================================================================


struct  Ui_BFu16i_BFu33  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu16i_BFu33) C1{ Fi Fi:16 FL:33}



static void Test_Ui_BFu16i_BFu33()
{
  {
    init_simple_test("Ui_BFu16i_BFu33");
    static STRUCT_IF_C Ui_BFu16i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "Ui_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "Ui_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu33, Ui_BFu16i_BFu33)
//============================================================================


struct  Ui_BFu16i_BFu7c  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu16i_BFu7c) C1{ Fi Fi:16 Fc:7}



static void Test_Ui_BFu16i_BFu7c()
{
  {
    init_simple_test("Ui_BFu16i_BFu7c");
    static STRUCT_IF_C Ui_BFu16i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu7c, Ui_BFu16i_BFu7c)
//============================================================================


struct  Ui_BFu16i_BFu7i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu16i_BFu7i) C1{ Fi Fi:16 Fi:7}



static void Test_Ui_BFu16i_BFu7i()
{
  {
    init_simple_test("Ui_BFu16i_BFu7i");
    static STRUCT_IF_C Ui_BFu16i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu7i, Ui_BFu16i_BFu7i)
//============================================================================


struct  Ui_BFu16i_BFu7ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu16i_BFu7ll) C1{ Fi Fi:16 FL:7}



static void Test_Ui_BFu16i_BFu7ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu7ll");
    static STRUCT_IF_C Ui_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu7ll, Ui_BFu16i_BFu7ll)
//============================================================================


struct  Ui_BFu16i_BFu7s  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu16i_BFu7s) C1{ Fi Fi:16 Fs:7}



static void Test_Ui_BFu16i_BFu7s()
{
  {
    init_simple_test("Ui_BFu16i_BFu7s");
    static STRUCT_IF_C Ui_BFu16i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu7s, Ui_BFu16i_BFu7s)
//============================================================================


struct  Ui_BFu16i_BFu8c  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu16i_BFu8c) C1{ Fi Fi:16 Fc:8}



static void Test_Ui_BFu16i_BFu8c()
{
  {
    init_simple_test("Ui_BFu16i_BFu8c");
    static STRUCT_IF_C Ui_BFu16i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu8c, Ui_BFu16i_BFu8c)
//============================================================================


struct  Ui_BFu16i_BFu8i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu16i_BFu8i) C1{ Fi Fi:16 Fi:8}



static void Test_Ui_BFu16i_BFu8i()
{
  {
    init_simple_test("Ui_BFu16i_BFu8i");
    static STRUCT_IF_C Ui_BFu16i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu8i, Ui_BFu16i_BFu8i)
//============================================================================


struct  Ui_BFu16i_BFu8ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu16i_BFu8ll) C1{ Fi Fi:16 FL:8}



static void Test_Ui_BFu16i_BFu8ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu8ll");
    static STRUCT_IF_C Ui_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu8ll, Ui_BFu16i_BFu8ll)
//============================================================================


struct  Ui_BFu16i_BFu8s  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu16i_BFu8s) C1{ Fi Fi:16 Fs:8}



static void Test_Ui_BFu16i_BFu8s()
{
  {
    init_simple_test("Ui_BFu16i_BFu8s");
    static STRUCT_IF_C Ui_BFu16i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu8s, Ui_BFu16i_BFu8s)
//============================================================================


struct  Ui_BFu16i_BFu9i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu16i_BFu9i) C1{ Fi Fi:16 Fi:9}



static void Test_Ui_BFu16i_BFu9i()
{
  {
    init_simple_test("Ui_BFu16i_BFu9i");
    static STRUCT_IF_C Ui_BFu16i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu9i, Ui_BFu16i_BFu9i)
//============================================================================


struct  Ui_BFu16i_BFu9ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu16i_BFu9ll) C1{ Fi Fi:16 FL:9}



static void Test_Ui_BFu16i_BFu9ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu9ll");
    static STRUCT_IF_C Ui_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu9ll, Ui_BFu16i_BFu9ll)
//============================================================================


struct  Ui_BFu16i_BFu9s  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu16i_BFu9s) C1{ Fi Fi:16 Fs:9}



static void Test_Ui_BFu16i_BFu9s()
{
  {
    init_simple_test("Ui_BFu16i_BFu9s");
    static STRUCT_IF_C Ui_BFu16i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_BFu9s, Ui_BFu16i_BFu9s)
//============================================================================


struct  Ui_BFu16i_C  {
  unsigned int v1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 Ui_BFu16i_C) C1{ Fi Fi:16 Fc}



static void Test_Ui_BFu16i_C()
{
  {
    init_simple_test("Ui_BFu16i_C");
    static STRUCT_IF_C Ui_BFu16i_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_C");
    check_field_offset(lv, v3, 6, "Ui_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_C, Ui_BFu16i_C)
//============================================================================


struct  Ui_BFu16i_D  {
  unsigned int v1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 Ui_BFu16i_D) C1{ Fi Fi:16 FL}



static void Test_Ui_BFu16i_D()
{
  {
    init_simple_test("Ui_BFu16i_D");
    static STRUCT_IF_C Ui_BFu16i_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_D");
    check_field_offset(lv, v3, 8, "Ui_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_D, Ui_BFu16i_D)
//============================================================================


struct  Ui_BFu16i_F  {
  unsigned int v1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 Ui_BFu16i_F) C1{ Fi Fi:16 Fi}



static void Test_Ui_BFu16i_F()
{
  {
    init_simple_test("Ui_BFu16i_F");
    static STRUCT_IF_C Ui_BFu16i_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_F");
    check_field_offset(lv, v3, 8, "Ui_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_F, Ui_BFu16i_F)
//============================================================================


struct  Ui_BFu16i_I  {
  unsigned int v1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 Ui_BFu16i_I) C1{ Fi Fi:16 Fi}



static void Test_Ui_BFu16i_I()
{
  {
    init_simple_test("Ui_BFu16i_I");
    static STRUCT_IF_C Ui_BFu16i_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_I");
    check_field_offset(lv, v3, 8, "Ui_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_I, Ui_BFu16i_I)
//============================================================================


struct  Ui_BFu16i_Ip  {
  unsigned int v1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 Ui_BFu16i_Ip) C1{ Fi Fi:16 Fp}



static void Test_Ui_BFu16i_Ip()
{
  {
    init_simple_test("Ui_BFu16i_Ip");
    static STRUCT_IF_C Ui_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_Ip, Ui_BFu16i_Ip)
//============================================================================


struct  Ui_BFu16i_L  {
  unsigned int v1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 Ui_BFu16i_L) C1{ Fi Fi:16 FL}



static void Test_Ui_BFu16i_L()
{
  {
    init_simple_test("Ui_BFu16i_L");
    static STRUCT_IF_C Ui_BFu16i_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_L");
    check_field_offset(lv, v3, 8, "Ui_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_L, Ui_BFu16i_L)
//============================================================================


struct  Ui_BFu16i_S  {
  unsigned int v1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 Ui_BFu16i_S) C1{ Fi Fi:16 Fs}



static void Test_Ui_BFu16i_S()
{
  {
    init_simple_test("Ui_BFu16i_S");
    static STRUCT_IF_C Ui_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_S");
    check_field_offset(lv, v3, 6, "Ui_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_S, Ui_BFu16i_S)
//============================================================================


struct  Ui_BFu16i_Uc  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 Ui_BFu16i_Uc) C1{ Fi Fi:16 Fc}



static void Test_Ui_BFu16i_Uc()
{
  {
    init_simple_test("Ui_BFu16i_Uc");
    static STRUCT_IF_C Ui_BFu16i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_Uc");
    check_field_offset(lv, v3, 6, "Ui_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_Uc, Ui_BFu16i_Uc)
//============================================================================


struct  Ui_BFu16i_Ui  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 Ui_BFu16i_Ui) C1{ Fi Fi:16 Fi}



static void Test_Ui_BFu16i_Ui()
{
  {
    init_simple_test("Ui_BFu16i_Ui");
    static STRUCT_IF_C Ui_BFu16i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_Ui, Ui_BFu16i_Ui)
//============================================================================


struct  Ui_BFu16i_Ul  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 Ui_BFu16i_Ul) C1{ Fi Fi:16 FL}



static void Test_Ui_BFu16i_Ul()
{
  {
    init_simple_test("Ui_BFu16i_Ul");
    static STRUCT_IF_C Ui_BFu16i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_Ul, Ui_BFu16i_Ul)
//============================================================================


struct  Ui_BFu16i_Us  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 Ui_BFu16i_Us) C1{ Fi Fi:16 Fs}



static void Test_Ui_BFu16i_Us()
{
  {
    init_simple_test("Ui_BFu16i_Us");
    static STRUCT_IF_C Ui_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_Us, Ui_BFu16i_Us)
//============================================================================


struct  Ui_BFu16i_Vp  {
  unsigned int v1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 Ui_BFu16i_Vp) C1{ Fi Fi:16 Fp}



static void Test_Ui_BFu16i_Vp()
{
  {
    init_simple_test("Ui_BFu16i_Vp");
    static STRUCT_IF_C Ui_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16i_Vp, Ui_BFu16i_Vp)
//============================================================================


struct  Ui_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:16;
};
//SIG(1 Ui_BFu16ll) C1{ Fi FL:16}



static void Test_Ui_BFu16ll()
{
  {
    init_simple_test("Ui_BFu16ll");
    static STRUCT_IF_C Ui_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll, Ui_BFu16ll)
//============================================================================


struct  Ui_BFu16ll_BFu15i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu16ll_BFu15i) C1{ Fi FL:16 Fi:15}



static void Test_Ui_BFu16ll_BFu15i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu15i");
    static STRUCT_IF_C Ui_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu15i, Ui_BFu16ll_BFu15i)
//============================================================================


struct  Ui_BFu16ll_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu16ll_BFu15ll) C1{ Fi FL:16 FL:15}



static void Test_Ui_BFu16ll_BFu15ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu15ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu15ll, Ui_BFu16ll_BFu15ll)
//============================================================================


struct  Ui_BFu16ll_BFu15s  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu16ll_BFu15s) C1{ Fi FL:16 Fs:15}



static void Test_Ui_BFu16ll_BFu15s()
{
  {
    init_simple_test("Ui_BFu16ll_BFu15s");
    static STRUCT_IF_C Ui_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu15s, Ui_BFu16ll_BFu15s)
//============================================================================


struct  Ui_BFu16ll_BFu16i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu16ll_BFu16i) C1{ Fi FL:16 Fi:16}



static void Test_Ui_BFu16ll_BFu16i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu16i");
    static STRUCT_IF_C Ui_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu16i, Ui_BFu16ll_BFu16i)
//============================================================================


struct  Ui_BFu16ll_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu16ll_BFu16ll) C1{ Fi FL:16 FL:16}



static void Test_Ui_BFu16ll_BFu16ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu16ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu16ll, Ui_BFu16ll_BFu16ll)
//============================================================================


struct  Ui_BFu16ll_BFu16s  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu16ll_BFu16s) C1{ Fi FL:16 Fs:16}



static void Test_Ui_BFu16ll_BFu16s()
{
  {
    init_simple_test("Ui_BFu16ll_BFu16s");
    static STRUCT_IF_C Ui_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu16s, Ui_BFu16ll_BFu16s)
//============================================================================


struct  Ui_BFu16ll_BFu17i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu16ll_BFu17i) C1{ Fi FL:16 Fi:17}



static void Test_Ui_BFu16ll_BFu17i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu17i");
    static STRUCT_IF_C Ui_BFu16ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu17i, Ui_BFu16ll_BFu17i)
//============================================================================


struct  Ui_BFu16ll_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu16ll_BFu17ll) C1{ Fi FL:16 FL:17}



static void Test_Ui_BFu16ll_BFu17ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu17ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "Ui_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "Ui_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu17ll, Ui_BFu16ll_BFu17ll)
//============================================================================


struct  Ui_BFu16ll_BFu1c  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu16ll_BFu1c) C1{ Fi FL:16 Fc:1}



static void Test_Ui_BFu16ll_BFu1c()
{
  {
    init_simple_test("Ui_BFu16ll_BFu1c");
    static STRUCT_IF_C Ui_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu1c, Ui_BFu16ll_BFu1c)
//============================================================================


struct  Ui_BFu16ll_BFu1i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu16ll_BFu1i) C1{ Fi FL:16 Fi:1}



static void Test_Ui_BFu16ll_BFu1i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu1i");
    static STRUCT_IF_C Ui_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu1i, Ui_BFu16ll_BFu1i)
//============================================================================


struct  Ui_BFu16ll_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu16ll_BFu1ll) C1{ Fi FL:16 FL:1}



static void Test_Ui_BFu16ll_BFu1ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu1ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu1ll, Ui_BFu16ll_BFu1ll)
//============================================================================


struct  Ui_BFu16ll_BFu1s  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu16ll_BFu1s) C1{ Fi FL:16 Fs:1}



static void Test_Ui_BFu16ll_BFu1s()
{
  {
    init_simple_test("Ui_BFu16ll_BFu1s");
    static STRUCT_IF_C Ui_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu1s, Ui_BFu16ll_BFu1s)
//============================================================================


struct  Ui_BFu16ll_BFu31i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu16ll_BFu31i) C1{ Fi FL:16 Fi:31}



static void Test_Ui_BFu16ll_BFu31i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu31i");
    static STRUCT_IF_C Ui_BFu16ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu31i, Ui_BFu16ll_BFu31i)
//============================================================================


struct  Ui_BFu16ll_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu16ll_BFu31ll) C1{ Fi FL:16 FL:31}



static void Test_Ui_BFu16ll_BFu31ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu31ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "Ui_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "Ui_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu31ll, Ui_BFu16ll_BFu31ll)
//============================================================================


struct  Ui_BFu16ll_BFu32i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu16ll_BFu32i) C1{ Fi FL:16 Fi:32}



static void Test_Ui_BFu16ll_BFu32i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu32i");
    static STRUCT_IF_C Ui_BFu16ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu32i, Ui_BFu16ll_BFu32i)
//============================================================================


struct  Ui_BFu16ll_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu16ll_BFu32ll) C1{ Fi FL:16 FL:32}



static void Test_Ui_BFu16ll_BFu32ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu32ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "Ui_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "Ui_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu32ll, Ui_BFu16ll_BFu32ll)
//============================================================================


struct  Ui_BFu16ll_BFu33  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu16ll_BFu33) C1{ Fi FL:16 FL:33}



static void Test_Ui_BFu16ll_BFu33()
{
  {
    init_simple_test("Ui_BFu16ll_BFu33");
    static STRUCT_IF_C Ui_BFu16ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "Ui_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "Ui_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu33, Ui_BFu16ll_BFu33)
//============================================================================


struct  Ui_BFu16ll_BFu7c  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu16ll_BFu7c) C1{ Fi FL:16 Fc:7}



static void Test_Ui_BFu16ll_BFu7c()
{
  {
    init_simple_test("Ui_BFu16ll_BFu7c");
    static STRUCT_IF_C Ui_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu7c, Ui_BFu16ll_BFu7c)
//============================================================================


struct  Ui_BFu16ll_BFu7i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu16ll_BFu7i) C1{ Fi FL:16 Fi:7}



static void Test_Ui_BFu16ll_BFu7i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu7i");
    static STRUCT_IF_C Ui_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu7i, Ui_BFu16ll_BFu7i)
//============================================================================


struct  Ui_BFu16ll_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu16ll_BFu7ll) C1{ Fi FL:16 FL:7}



static void Test_Ui_BFu16ll_BFu7ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu7ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu7ll, Ui_BFu16ll_BFu7ll)
//============================================================================


struct  Ui_BFu16ll_BFu7s  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu16ll_BFu7s) C1{ Fi FL:16 Fs:7}



static void Test_Ui_BFu16ll_BFu7s()
{
  {
    init_simple_test("Ui_BFu16ll_BFu7s");
    static STRUCT_IF_C Ui_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu7s, Ui_BFu16ll_BFu7s)
//============================================================================


struct  Ui_BFu16ll_BFu8c  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu16ll_BFu8c) C1{ Fi FL:16 Fc:8}



static void Test_Ui_BFu16ll_BFu8c()
{
  {
    init_simple_test("Ui_BFu16ll_BFu8c");
    static STRUCT_IF_C Ui_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu8c, Ui_BFu16ll_BFu8c)
//============================================================================


struct  Ui_BFu16ll_BFu8i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu16ll_BFu8i) C1{ Fi FL:16 Fi:8}



static void Test_Ui_BFu16ll_BFu8i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu8i");
    static STRUCT_IF_C Ui_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu8i, Ui_BFu16ll_BFu8i)
//============================================================================


struct  Ui_BFu16ll_BFu8ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu16ll_BFu8ll) C1{ Fi FL:16 FL:8}



static void Test_Ui_BFu16ll_BFu8ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu8ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu8ll, Ui_BFu16ll_BFu8ll)
//============================================================================


struct  Ui_BFu16ll_BFu8s  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu16ll_BFu8s) C1{ Fi FL:16 Fs:8}



static void Test_Ui_BFu16ll_BFu8s()
{
  {
    init_simple_test("Ui_BFu16ll_BFu8s");
    static STRUCT_IF_C Ui_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu8s, Ui_BFu16ll_BFu8s)
//============================================================================


struct  Ui_BFu16ll_BFu9i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu16ll_BFu9i) C1{ Fi FL:16 Fi:9}



static void Test_Ui_BFu16ll_BFu9i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu9i");
    static STRUCT_IF_C Ui_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu9i, Ui_BFu16ll_BFu9i)
//============================================================================


struct  Ui_BFu16ll_BFu9ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu16ll_BFu9ll) C1{ Fi FL:16 FL:9}



static void Test_Ui_BFu16ll_BFu9ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu9ll");
    static STRUCT_IF_C Ui_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu9ll, Ui_BFu16ll_BFu9ll)
//============================================================================


struct  Ui_BFu16ll_BFu9s  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu16ll_BFu9s) C1{ Fi FL:16 Fs:9}



static void Test_Ui_BFu16ll_BFu9s()
{
  {
    init_simple_test("Ui_BFu16ll_BFu9s");
    static STRUCT_IF_C Ui_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_BFu9s, Ui_BFu16ll_BFu9s)
//============================================================================


struct  Ui_BFu16ll_C  {
  unsigned int v1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 Ui_BFu16ll_C) C1{ Fi FL:16 Fc}



static void Test_Ui_BFu16ll_C()
{
  {
    init_simple_test("Ui_BFu16ll_C");
    static STRUCT_IF_C Ui_BFu16ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_C");
    check_field_offset(lv, v3, 6, "Ui_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_C, Ui_BFu16ll_C)
//============================================================================


struct  Ui_BFu16ll_D  {
  unsigned int v1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 Ui_BFu16ll_D) C1{ Fi FL:16 FL}



static void Test_Ui_BFu16ll_D()
{
  {
    init_simple_test("Ui_BFu16ll_D");
    static STRUCT_IF_C Ui_BFu16ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_D");
    check_field_offset(lv, v3, 8, "Ui_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_D, Ui_BFu16ll_D)
//============================================================================


struct  Ui_BFu16ll_F  {
  unsigned int v1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 Ui_BFu16ll_F) C1{ Fi FL:16 Fi}



static void Test_Ui_BFu16ll_F()
{
  {
    init_simple_test("Ui_BFu16ll_F");
    static STRUCT_IF_C Ui_BFu16ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_F");
    check_field_offset(lv, v3, 8, "Ui_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_F, Ui_BFu16ll_F)
//============================================================================


struct  Ui_BFu16ll_I  {
  unsigned int v1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 Ui_BFu16ll_I) C1{ Fi FL:16 Fi}



static void Test_Ui_BFu16ll_I()
{
  {
    init_simple_test("Ui_BFu16ll_I");
    static STRUCT_IF_C Ui_BFu16ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_I");
    check_field_offset(lv, v3, 8, "Ui_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_I, Ui_BFu16ll_I)
//============================================================================


struct  Ui_BFu16ll_Ip  {
  unsigned int v1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 Ui_BFu16ll_Ip) C1{ Fi FL:16 Fp}



static void Test_Ui_BFu16ll_Ip()
{
  {
    init_simple_test("Ui_BFu16ll_Ip");
    static STRUCT_IF_C Ui_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_Ip, Ui_BFu16ll_Ip)
//============================================================================


struct  Ui_BFu16ll_L  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 Ui_BFu16ll_L) C1{ Fi FL:16 FL}



static void Test_Ui_BFu16ll_L()
{
  {
    init_simple_test("Ui_BFu16ll_L");
    static STRUCT_IF_C Ui_BFu16ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_L");
    check_field_offset(lv, v3, 8, "Ui_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_L, Ui_BFu16ll_L)
//============================================================================


struct  Ui_BFu16ll_S  {
  unsigned int v1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 Ui_BFu16ll_S) C1{ Fi FL:16 Fs}



static void Test_Ui_BFu16ll_S()
{
  {
    init_simple_test("Ui_BFu16ll_S");
    static STRUCT_IF_C Ui_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_S");
    check_field_offset(lv, v3, 6, "Ui_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_S, Ui_BFu16ll_S)
//============================================================================


struct  Ui_BFu16ll_Uc  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 Ui_BFu16ll_Uc) C1{ Fi FL:16 Fc}



static void Test_Ui_BFu16ll_Uc()
{
  {
    init_simple_test("Ui_BFu16ll_Uc");
    static STRUCT_IF_C Ui_BFu16ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_Uc");
    check_field_offset(lv, v3, 6, "Ui_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_Uc, Ui_BFu16ll_Uc)
//============================================================================


struct  Ui_BFu16ll_Ui  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 Ui_BFu16ll_Ui) C1{ Fi FL:16 Fi}



static void Test_Ui_BFu16ll_Ui()
{
  {
    init_simple_test("Ui_BFu16ll_Ui");
    static STRUCT_IF_C Ui_BFu16ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_Ui, Ui_BFu16ll_Ui)
//============================================================================


struct  Ui_BFu16ll_Ul  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 Ui_BFu16ll_Ul) C1{ Fi FL:16 FL}



static void Test_Ui_BFu16ll_Ul()
{
  {
    init_simple_test("Ui_BFu16ll_Ul");
    static STRUCT_IF_C Ui_BFu16ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_Ul, Ui_BFu16ll_Ul)
//============================================================================


struct  Ui_BFu16ll_Us  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 Ui_BFu16ll_Us) C1{ Fi FL:16 Fs}



static void Test_Ui_BFu16ll_Us()
{
  {
    init_simple_test("Ui_BFu16ll_Us");
    static STRUCT_IF_C Ui_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_Us, Ui_BFu16ll_Us)
//============================================================================


struct  Ui_BFu16ll_Vp  {
  unsigned int v1;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 Ui_BFu16ll_Vp) C1{ Fi FL:16 Fp}



static void Test_Ui_BFu16ll_Vp()
{
  {
    init_simple_test("Ui_BFu16ll_Vp");
    static STRUCT_IF_C Ui_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16ll_Vp, Ui_BFu16ll_Vp)
//============================================================================


struct  Ui_BFu16s  {
  unsigned int v1;
  unsigned short v2:16;
};
//SIG(1 Ui_BFu16s) C1{ Fi Fs:16}



static void Test_Ui_BFu16s()
{
  {
    init_simple_test("Ui_BFu16s");
    static STRUCT_IF_C Ui_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s, Ui_BFu16s)
//============================================================================


struct  Ui_BFu16s_BFu15i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu16s_BFu15i) C1{ Fi Fs:16 Fi:15}



static void Test_Ui_BFu16s_BFu15i()
{
  {
    init_simple_test("Ui_BFu16s_BFu15i");
    static STRUCT_IF_C Ui_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu15i, Ui_BFu16s_BFu15i)
//============================================================================


struct  Ui_BFu16s_BFu15ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu16s_BFu15ll) C1{ Fi Fs:16 FL:15}



static void Test_Ui_BFu16s_BFu15ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu15ll");
    static STRUCT_IF_C Ui_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu15ll, Ui_BFu16s_BFu15ll)
//============================================================================


struct  Ui_BFu16s_BFu15s  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu16s_BFu15s) C1{ Fi Fs:16 Fs:15}



static void Test_Ui_BFu16s_BFu15s()
{
  {
    init_simple_test("Ui_BFu16s_BFu15s");
    static STRUCT_IF_C Ui_BFu16s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu15s, Ui_BFu16s_BFu15s)
//============================================================================


struct  Ui_BFu16s_BFu16i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu16s_BFu16i) C1{ Fi Fs:16 Fi:16}



static void Test_Ui_BFu16s_BFu16i()
{
  {
    init_simple_test("Ui_BFu16s_BFu16i");
    static STRUCT_IF_C Ui_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu16i, Ui_BFu16s_BFu16i)
//============================================================================


struct  Ui_BFu16s_BFu16ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu16s_BFu16ll) C1{ Fi Fs:16 FL:16}



static void Test_Ui_BFu16s_BFu16ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu16ll");
    static STRUCT_IF_C Ui_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu16ll, Ui_BFu16s_BFu16ll)
//============================================================================


struct  Ui_BFu16s_BFu16s  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu16s_BFu16s) C1{ Fi Fs:16 Fs:16}



static void Test_Ui_BFu16s_BFu16s()
{
  {
    init_simple_test("Ui_BFu16s_BFu16s");
    static STRUCT_IF_C Ui_BFu16s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu16s, Ui_BFu16s_BFu16s)
//============================================================================


struct  Ui_BFu16s_BFu17i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu16s_BFu17i) C1{ Fi Fs:16 Fi:17}



static void Test_Ui_BFu16s_BFu17i()
{
  {
    init_simple_test("Ui_BFu16s_BFu17i");
    static STRUCT_IF_C Ui_BFu16s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu17i, Ui_BFu16s_BFu17i)
//============================================================================


struct  Ui_BFu16s_BFu17ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu16s_BFu17ll) C1{ Fi Fs:16 FL:17}



static void Test_Ui_BFu16s_BFu17ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu17ll");
    static STRUCT_IF_C Ui_BFu16s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "Ui_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "Ui_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu17ll, Ui_BFu16s_BFu17ll)
//============================================================================


struct  Ui_BFu16s_BFu1c  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu16s_BFu1c) C1{ Fi Fs:16 Fc:1}



static void Test_Ui_BFu16s_BFu1c()
{
  {
    init_simple_test("Ui_BFu16s_BFu1c");
    static STRUCT_IF_C Ui_BFu16s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu1c, Ui_BFu16s_BFu1c)
//============================================================================


struct  Ui_BFu16s_BFu1i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu16s_BFu1i) C1{ Fi Fs:16 Fi:1}



static void Test_Ui_BFu16s_BFu1i()
{
  {
    init_simple_test("Ui_BFu16s_BFu1i");
    static STRUCT_IF_C Ui_BFu16s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu1i, Ui_BFu16s_BFu1i)
//============================================================================


struct  Ui_BFu16s_BFu1ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu16s_BFu1ll) C1{ Fi Fs:16 FL:1}



static void Test_Ui_BFu16s_BFu1ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu1ll");
    static STRUCT_IF_C Ui_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu1ll, Ui_BFu16s_BFu1ll)
//============================================================================


struct  Ui_BFu16s_BFu1s  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu16s_BFu1s) C1{ Fi Fs:16 Fs:1}



static void Test_Ui_BFu16s_BFu1s()
{
  {
    init_simple_test("Ui_BFu16s_BFu1s");
    static STRUCT_IF_C Ui_BFu16s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu1s, Ui_BFu16s_BFu1s)
//============================================================================


struct  Ui_BFu16s_BFu31i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu16s_BFu31i) C1{ Fi Fs:16 Fi:31}



static void Test_Ui_BFu16s_BFu31i()
{
  {
    init_simple_test("Ui_BFu16s_BFu31i");
    static STRUCT_IF_C Ui_BFu16s_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu31i, Ui_BFu16s_BFu31i)
//============================================================================


struct  Ui_BFu16s_BFu31ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu16s_BFu31ll) C1{ Fi Fs:16 FL:31}



static void Test_Ui_BFu16s_BFu31ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu31ll");
    static STRUCT_IF_C Ui_BFu16s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "Ui_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "Ui_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu31ll, Ui_BFu16s_BFu31ll)
//============================================================================


struct  Ui_BFu16s_BFu32i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu16s_BFu32i) C1{ Fi Fs:16 Fi:32}



static void Test_Ui_BFu16s_BFu32i()
{
  {
    init_simple_test("Ui_BFu16s_BFu32i");
    static STRUCT_IF_C Ui_BFu16s_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu32i, Ui_BFu16s_BFu32i)
//============================================================================


struct  Ui_BFu16s_BFu32ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu16s_BFu32ll) C1{ Fi Fs:16 FL:32}



static void Test_Ui_BFu16s_BFu32ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu32ll");
    static STRUCT_IF_C Ui_BFu16s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "Ui_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "Ui_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu32ll, Ui_BFu16s_BFu32ll)
//============================================================================


struct  Ui_BFu16s_BFu33  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu16s_BFu33) C1{ Fi Fs:16 FL:33}



static void Test_Ui_BFu16s_BFu33()
{
  {
    init_simple_test("Ui_BFu16s_BFu33");
    static STRUCT_IF_C Ui_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "Ui_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "Ui_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu33, Ui_BFu16s_BFu33)
//============================================================================


struct  Ui_BFu16s_BFu7c  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu16s_BFu7c) C1{ Fi Fs:16 Fc:7}



static void Test_Ui_BFu16s_BFu7c()
{
  {
    init_simple_test("Ui_BFu16s_BFu7c");
    static STRUCT_IF_C Ui_BFu16s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu7c, Ui_BFu16s_BFu7c)
//============================================================================


struct  Ui_BFu16s_BFu7i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu16s_BFu7i) C1{ Fi Fs:16 Fi:7}



static void Test_Ui_BFu16s_BFu7i()
{
  {
    init_simple_test("Ui_BFu16s_BFu7i");
    static STRUCT_IF_C Ui_BFu16s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu7i, Ui_BFu16s_BFu7i)
//============================================================================


struct  Ui_BFu16s_BFu7ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu16s_BFu7ll) C1{ Fi Fs:16 FL:7}



static void Test_Ui_BFu16s_BFu7ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu7ll");
    static STRUCT_IF_C Ui_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu7ll, Ui_BFu16s_BFu7ll)
//============================================================================


struct  Ui_BFu16s_BFu7s  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu16s_BFu7s) C1{ Fi Fs:16 Fs:7}



static void Test_Ui_BFu16s_BFu7s()
{
  {
    init_simple_test("Ui_BFu16s_BFu7s");
    static STRUCT_IF_C Ui_BFu16s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu7s, Ui_BFu16s_BFu7s)
//============================================================================


struct  Ui_BFu16s_BFu8c  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu16s_BFu8c) C1{ Fi Fs:16 Fc:8}



static void Test_Ui_BFu16s_BFu8c()
{
  {
    init_simple_test("Ui_BFu16s_BFu8c");
    static STRUCT_IF_C Ui_BFu16s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu8c, Ui_BFu16s_BFu8c)
//============================================================================


struct  Ui_BFu16s_BFu8i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu16s_BFu8i) C1{ Fi Fs:16 Fi:8}



static void Test_Ui_BFu16s_BFu8i()
{
  {
    init_simple_test("Ui_BFu16s_BFu8i");
    static STRUCT_IF_C Ui_BFu16s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu8i, Ui_BFu16s_BFu8i)
//============================================================================


struct  Ui_BFu16s_BFu8ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu16s_BFu8ll) C1{ Fi Fs:16 FL:8}



static void Test_Ui_BFu16s_BFu8ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu8ll");
    static STRUCT_IF_C Ui_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu8ll, Ui_BFu16s_BFu8ll)
//============================================================================


struct  Ui_BFu16s_BFu8s  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu16s_BFu8s) C1{ Fi Fs:16 Fs:8}



static void Test_Ui_BFu16s_BFu8s()
{
  {
    init_simple_test("Ui_BFu16s_BFu8s");
    static STRUCT_IF_C Ui_BFu16s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu8s, Ui_BFu16s_BFu8s)
//============================================================================


struct  Ui_BFu16s_BFu9i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu16s_BFu9i) C1{ Fi Fs:16 Fi:9}



static void Test_Ui_BFu16s_BFu9i()
{
  {
    init_simple_test("Ui_BFu16s_BFu9i");
    static STRUCT_IF_C Ui_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu9i, Ui_BFu16s_BFu9i)
//============================================================================


struct  Ui_BFu16s_BFu9ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu16s_BFu9ll) C1{ Fi Fs:16 FL:9}



static void Test_Ui_BFu16s_BFu9ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu9ll");
    static STRUCT_IF_C Ui_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu9ll, Ui_BFu16s_BFu9ll)
//============================================================================


struct  Ui_BFu16s_BFu9s  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu16s_BFu9s) C1{ Fi Fs:16 Fs:9}



static void Test_Ui_BFu16s_BFu9s()
{
  {
    init_simple_test("Ui_BFu16s_BFu9s");
    static STRUCT_IF_C Ui_BFu16s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_BFu9s, Ui_BFu16s_BFu9s)
//============================================================================


struct  Ui_BFu16s_C  {
  unsigned int v1;
  unsigned short v2:16;
  char v3;
};
//SIG(1 Ui_BFu16s_C) C1{ Fi Fs:16 Fc}



static void Test_Ui_BFu16s_C()
{
  {
    init_simple_test("Ui_BFu16s_C");
    static STRUCT_IF_C Ui_BFu16s_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_C");
    check_field_offset(lv, v3, 6, "Ui_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_C, Ui_BFu16s_C)
//============================================================================


struct  Ui_BFu16s_D  {
  unsigned int v1;
  unsigned short v2:16;
  double v3;
};
//SIG(1 Ui_BFu16s_D) C1{ Fi Fs:16 FL}



static void Test_Ui_BFu16s_D()
{
  {
    init_simple_test("Ui_BFu16s_D");
    static STRUCT_IF_C Ui_BFu16s_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_D");
    check_field_offset(lv, v3, 8, "Ui_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_D, Ui_BFu16s_D)
//============================================================================


struct  Ui_BFu16s_F  {
  unsigned int v1;
  unsigned short v2:16;
  float v3;
};
//SIG(1 Ui_BFu16s_F) C1{ Fi Fs:16 Fi}



static void Test_Ui_BFu16s_F()
{
  {
    init_simple_test("Ui_BFu16s_F");
    static STRUCT_IF_C Ui_BFu16s_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_F");
    check_field_offset(lv, v3, 8, "Ui_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_F, Ui_BFu16s_F)
//============================================================================


struct  Ui_BFu16s_I  {
  unsigned int v1;
  unsigned short v2:16;
  int v3;
};
//SIG(1 Ui_BFu16s_I) C1{ Fi Fs:16 Fi}



static void Test_Ui_BFu16s_I()
{
  {
    init_simple_test("Ui_BFu16s_I");
    static STRUCT_IF_C Ui_BFu16s_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_I");
    check_field_offset(lv, v3, 8, "Ui_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_I, Ui_BFu16s_I)
//============================================================================


struct  Ui_BFu16s_Ip  {
  unsigned int v1;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 Ui_BFu16s_Ip) C1{ Fi Fs:16 Fp}



static void Test_Ui_BFu16s_Ip()
{
  {
    init_simple_test("Ui_BFu16s_Ip");
    static STRUCT_IF_C Ui_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_Ip, Ui_BFu16s_Ip)
//============================================================================


struct  Ui_BFu16s_L  {
  unsigned int v1;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 Ui_BFu16s_L) C1{ Fi Fs:16 FL}



static void Test_Ui_BFu16s_L()
{
  {
    init_simple_test("Ui_BFu16s_L");
    static STRUCT_IF_C Ui_BFu16s_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_L");
    check_field_offset(lv, v3, 8, "Ui_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_L, Ui_BFu16s_L)
//============================================================================


struct  Ui_BFu16s_S  {
  unsigned int v1;
  unsigned short v2:16;
  short v3;
};
//SIG(1 Ui_BFu16s_S) C1{ Fi Fs:16 Fs}



static void Test_Ui_BFu16s_S()
{
  {
    init_simple_test("Ui_BFu16s_S");
    static STRUCT_IF_C Ui_BFu16s_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_S");
    check_field_offset(lv, v3, 6, "Ui_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_S, Ui_BFu16s_S)
//============================================================================


struct  Ui_BFu16s_Uc  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 Ui_BFu16s_Uc) C1{ Fi Fs:16 Fc}



static void Test_Ui_BFu16s_Uc()
{
  {
    init_simple_test("Ui_BFu16s_Uc");
    static STRUCT_IF_C Ui_BFu16s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_Uc");
    check_field_offset(lv, v3, 6, "Ui_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_Uc, Ui_BFu16s_Uc)
//============================================================================


struct  Ui_BFu16s_Ui  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 Ui_BFu16s_Ui) C1{ Fi Fs:16 Fi}



static void Test_Ui_BFu16s_Ui()
{
  {
    init_simple_test("Ui_BFu16s_Ui");
    static STRUCT_IF_C Ui_BFu16s_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu16s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_Ui, Ui_BFu16s_Ui)
//============================================================================


struct  Ui_BFu16s_Ul  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 Ui_BFu16s_Ul) C1{ Fi Fs:16 FL}



static void Test_Ui_BFu16s_Ul()
{
  {
    init_simple_test("Ui_BFu16s_Ul");
    static STRUCT_IF_C Ui_BFu16s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_Ul, Ui_BFu16s_Ul)
//============================================================================


struct  Ui_BFu16s_Us  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 Ui_BFu16s_Us) C1{ Fi Fs:16 Fs}



static void Test_Ui_BFu16s_Us()
{
  {
    init_simple_test("Ui_BFu16s_Us");
    static STRUCT_IF_C Ui_BFu16s_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_Us, Ui_BFu16s_Us)
//============================================================================


struct  Ui_BFu16s_Vp  {
  unsigned int v1;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 Ui_BFu16s_Vp) C1{ Fi Fs:16 Fp}



static void Test_Ui_BFu16s_Vp()
{
  {
    init_simple_test("Ui_BFu16s_Vp");
    static STRUCT_IF_C Ui_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu16s_Vp, Ui_BFu16s_Vp)
//============================================================================


struct  Ui_BFu17i  {
  unsigned int v1;
  unsigned int v2:17;
};
//SIG(1 Ui_BFu17i) C1{ Fi Fi:17}



static void Test_Ui_BFu17i()
{
  {
    init_simple_test("Ui_BFu17i");
    static STRUCT_IF_C Ui_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i, Ui_BFu17i)
//============================================================================


struct  Ui_BFu17i_BFu15i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu17i_BFu15i) C1{ Fi Fi:17 Fi:15}



static void Test_Ui_BFu17i_BFu15i()
{
  {
    init_simple_test("Ui_BFu17i_BFu15i");
    static STRUCT_IF_C Ui_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Ui_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Ui_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu15i, Ui_BFu17i_BFu15i)
//============================================================================


struct  Ui_BFu17i_BFu15ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu17i_BFu15ll) C1{ Fi Fi:17 FL:15}



static void Test_Ui_BFu17i_BFu15ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu15ll");
    static STRUCT_IF_C Ui_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Ui_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Ui_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu15ll, Ui_BFu17i_BFu15ll)
//============================================================================


struct  Ui_BFu17i_BFu15s  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu17i_BFu15s) C1{ Fi Fi:17 Fs:15}



static void Test_Ui_BFu17i_BFu15s()
{
  {
    init_simple_test("Ui_BFu17i_BFu15s");
    static STRUCT_IF_C Ui_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Ui_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Ui_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu15s, Ui_BFu17i_BFu15s)
//============================================================================


struct  Ui_BFu17i_BFu16i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu17i_BFu16i) C1{ Fi Fi:17 Fi:16}



static void Test_Ui_BFu17i_BFu16i()
{
  {
    init_simple_test("Ui_BFu17i_BFu16i");
    static STRUCT_IF_C Ui_BFu17i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu16i, Ui_BFu17i_BFu16i)
//============================================================================


struct  Ui_BFu17i_BFu16ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu17i_BFu16ll) C1{ Fi Fi:17 FL:16}



static void Test_Ui_BFu17i_BFu16ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu16ll");
    static STRUCT_IF_C Ui_BFu17i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, 1, "Ui_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, hide_ull(1LL<<15), "Ui_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu16ll, Ui_BFu17i_BFu16ll)
//============================================================================


struct  Ui_BFu17i_BFu16s  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu17i_BFu16s) C1{ Fi Fi:17 Fs:16}



static void Test_Ui_BFu17i_BFu16s()
{
  {
    init_simple_test("Ui_BFu17i_BFu16s");
    static STRUCT_IF_C Ui_BFu17i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu16s, Ui_BFu17i_BFu16s)
//============================================================================


struct  Ui_BFu17i_BFu17i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu17i_BFu17i) C1{ Fi Fi:17 Fi:17}



static void Test_Ui_BFu17i_BFu17i()
{
  {
    init_simple_test("Ui_BFu17i_BFu17i");
    static STRUCT_IF_C Ui_BFu17i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu17i, Ui_BFu17i_BFu17i)
//============================================================================


struct  Ui_BFu17i_BFu17ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu17i_BFu17ll) C1{ Fi Fi:17 FL:17}



static void Test_Ui_BFu17i_BFu17ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu17ll");
    static STRUCT_IF_C Ui_BFu17i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, 1, "Ui_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu17ll, Ui_BFu17i_BFu17ll)
//============================================================================


struct  Ui_BFu17i_BFu1c  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu17i_BFu1c) C1{ Fi Fi:17 Fc:1}



static void Test_Ui_BFu17i_BFu1c()
{
  {
    init_simple_test("Ui_BFu17i_BFu1c");
    static STRUCT_IF_C Ui_BFu17i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Ui_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu1c, Ui_BFu17i_BFu1c)
//============================================================================


struct  Ui_BFu17i_BFu1i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu17i_BFu1i) C1{ Fi Fi:17 Fi:1}



static void Test_Ui_BFu17i_BFu1i()
{
  {
    init_simple_test("Ui_BFu17i_BFu1i");
    static STRUCT_IF_C Ui_BFu17i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Ui_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu1i, Ui_BFu17i_BFu1i)
//============================================================================


struct  Ui_BFu17i_BFu1ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu17i_BFu1ll) C1{ Fi Fi:17 FL:1}



static void Test_Ui_BFu17i_BFu1ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu1ll");
    static STRUCT_IF_C Ui_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Ui_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu1ll, Ui_BFu17i_BFu1ll)
//============================================================================


struct  Ui_BFu17i_BFu1s  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu17i_BFu1s) C1{ Fi Fi:17 Fs:1}



static void Test_Ui_BFu17i_BFu1s()
{
  {
    init_simple_test("Ui_BFu17i_BFu1s");
    static STRUCT_IF_C Ui_BFu17i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Ui_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu1s, Ui_BFu17i_BFu1s)
//============================================================================


struct  Ui_BFu17i_BFu31i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu17i_BFu31i) C1{ Fi Fi:17 Fi:31}



static void Test_Ui_BFu17i_BFu31i()
{
  {
    init_simple_test("Ui_BFu17i_BFu31i");
    static STRUCT_IF_C Ui_BFu17i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu31i, Ui_BFu17i_BFu31i)
//============================================================================


struct  Ui_BFu17i_BFu31ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu17i_BFu31ll) C1{ Fi Fi:17 FL:31}



static void Test_Ui_BFu17i_BFu31ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu31ll");
    static STRUCT_IF_C Ui_BFu17i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, 1, "Ui_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, hide_ull(1LL<<30), "Ui_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu31ll, Ui_BFu17i_BFu31ll)
//============================================================================


struct  Ui_BFu17i_BFu32i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu17i_BFu32i) C1{ Fi Fi:17 Fi:32}



static void Test_Ui_BFu17i_BFu32i()
{
  {
    init_simple_test("Ui_BFu17i_BFu32i");
    static STRUCT_IF_C Ui_BFu17i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu32i, Ui_BFu17i_BFu32i)
//============================================================================


struct  Ui_BFu17i_BFu32ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu17i_BFu32ll) C1{ Fi Fi:17 FL:32}



static void Test_Ui_BFu17i_BFu32ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu32ll");
    static STRUCT_IF_C Ui_BFu17i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, 1, "Ui_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Ui_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu32ll, Ui_BFu17i_BFu32ll)
//============================================================================


struct  Ui_BFu17i_BFu33  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu17i_BFu33) C1{ Fi Fi:17 FL:33}



static void Test_Ui_BFu17i_BFu33()
{
  {
    init_simple_test("Ui_BFu17i_BFu33");
    static STRUCT_IF_C Ui_BFu17i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, 1, "Ui_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Ui_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu33, Ui_BFu17i_BFu33)
//============================================================================


struct  Ui_BFu17i_BFu7c  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu17i_BFu7c) C1{ Fi Fi:17 Fc:7}



static void Test_Ui_BFu17i_BFu7c()
{
  {
    init_simple_test("Ui_BFu17i_BFu7c");
    static STRUCT_IF_C Ui_BFu17i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Ui_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Ui_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu7c, Ui_BFu17i_BFu7c)
//============================================================================


struct  Ui_BFu17i_BFu7i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu17i_BFu7i) C1{ Fi Fi:17 Fi:7}



static void Test_Ui_BFu17i_BFu7i()
{
  {
    init_simple_test("Ui_BFu17i_BFu7i");
    static STRUCT_IF_C Ui_BFu17i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Ui_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Ui_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu7i, Ui_BFu17i_BFu7i)
//============================================================================


struct  Ui_BFu17i_BFu7ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu17i_BFu7ll) C1{ Fi Fi:17 FL:7}



static void Test_Ui_BFu17i_BFu7ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu7ll");
    static STRUCT_IF_C Ui_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Ui_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Ui_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu7ll, Ui_BFu17i_BFu7ll)
//============================================================================


struct  Ui_BFu17i_BFu7s  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu17i_BFu7s) C1{ Fi Fi:17 Fs:7}



static void Test_Ui_BFu17i_BFu7s()
{
  {
    init_simple_test("Ui_BFu17i_BFu7s");
    static STRUCT_IF_C Ui_BFu17i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Ui_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Ui_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu7s, Ui_BFu17i_BFu7s)
//============================================================================


struct  Ui_BFu17i_BFu8c  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu17i_BFu8c) C1{ Fi Fi:17 Fc:8}



static void Test_Ui_BFu17i_BFu8c()
{
  {
    init_simple_test("Ui_BFu17i_BFu8c");
    static STRUCT_IF_C Ui_BFu17i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, 1, "Ui_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, hide_ull(1LL<<7), "Ui_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu8c, Ui_BFu17i_BFu8c)
//============================================================================


struct  Ui_BFu17i_BFu8i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu17i_BFu8i) C1{ Fi Fi:17 Fi:8}



static void Test_Ui_BFu17i_BFu8i()
{
  {
    init_simple_test("Ui_BFu17i_BFu8i");
    static STRUCT_IF_C Ui_BFu17i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Ui_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Ui_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu8i, Ui_BFu17i_BFu8i)
//============================================================================


struct  Ui_BFu17i_BFu8ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu17i_BFu8ll) C1{ Fi Fi:17 FL:8}



static void Test_Ui_BFu17i_BFu8ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu8ll");
    static STRUCT_IF_C Ui_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Ui_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Ui_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu8ll, Ui_BFu17i_BFu8ll)
//============================================================================


struct  Ui_BFu17i_BFu8s  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu17i_BFu8s) C1{ Fi Fi:17 Fs:8}



static void Test_Ui_BFu17i_BFu8s()
{
  {
    init_simple_test("Ui_BFu17i_BFu8s");
    static STRUCT_IF_C Ui_BFu17i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Ui_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Ui_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu8s, Ui_BFu17i_BFu8s)
//============================================================================


struct  Ui_BFu17i_BFu9i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu17i_BFu9i) C1{ Fi Fi:17 Fi:9}



static void Test_Ui_BFu17i_BFu9i()
{
  {
    init_simple_test("Ui_BFu17i_BFu9i");
    static STRUCT_IF_C Ui_BFu17i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Ui_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Ui_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu9i, Ui_BFu17i_BFu9i)
//============================================================================


struct  Ui_BFu17i_BFu9ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu17i_BFu9ll) C1{ Fi Fi:17 FL:9}



static void Test_Ui_BFu17i_BFu9ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu9ll");
    static STRUCT_IF_C Ui_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Ui_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Ui_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu9ll, Ui_BFu17i_BFu9ll)
//============================================================================


struct  Ui_BFu17i_BFu9s  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu17i_BFu9s) C1{ Fi Fi:17 Fs:9}



static void Test_Ui_BFu17i_BFu9s()
{
  {
    init_simple_test("Ui_BFu17i_BFu9s");
    static STRUCT_IF_C Ui_BFu17i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Ui_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Ui_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_BFu9s, Ui_BFu17i_BFu9s)
//============================================================================


struct  Ui_BFu17i_C  {
  unsigned int v1;
  unsigned int v2:17;
  char v3;
};
//SIG(1 Ui_BFu17i_C) C1{ Fi Fi:17 Fc}



static void Test_Ui_BFu17i_C()
{
  {
    init_simple_test("Ui_BFu17i_C");
    static STRUCT_IF_C Ui_BFu17i_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_C");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_C");
    check_field_offset(lv, v3, 7, "Ui_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_C, Ui_BFu17i_C)
//============================================================================


struct  Ui_BFu17i_D  {
  unsigned int v1;
  unsigned int v2:17;
  double v3;
};
//SIG(1 Ui_BFu17i_D) C1{ Fi Fi:17 FL}



static void Test_Ui_BFu17i_D()
{
  {
    init_simple_test("Ui_BFu17i_D");
    static STRUCT_IF_C Ui_BFu17i_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_D");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_D");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_D, Ui_BFu17i_D)
//============================================================================


struct  Ui_BFu17i_F  {
  unsigned int v1;
  unsigned int v2:17;
  float v3;
};
//SIG(1 Ui_BFu17i_F) C1{ Fi Fi:17 Fi}



static void Test_Ui_BFu17i_F()
{
  {
    init_simple_test("Ui_BFu17i_F");
    static STRUCT_IF_C Ui_BFu17i_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_F");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_F");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_F, Ui_BFu17i_F)
//============================================================================


struct  Ui_BFu17i_I  {
  unsigned int v1;
  unsigned int v2:17;
  int v3;
};
//SIG(1 Ui_BFu17i_I) C1{ Fi Fi:17 Fi}



static void Test_Ui_BFu17i_I()
{
  {
    init_simple_test("Ui_BFu17i_I");
    static STRUCT_IF_C Ui_BFu17i_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_I");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_I");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_I, Ui_BFu17i_I)
//============================================================================


struct  Ui_BFu17i_Ip  {
  unsigned int v1;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 Ui_BFu17i_Ip) C1{ Fi Fi:17 Fp}



static void Test_Ui_BFu17i_Ip()
{
  {
    init_simple_test("Ui_BFu17i_Ip");
    static STRUCT_IF_C Ui_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_Ip, Ui_BFu17i_Ip)
//============================================================================


struct  Ui_BFu17i_L  {
  unsigned int v1;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 Ui_BFu17i_L) C1{ Fi Fi:17 FL}



static void Test_Ui_BFu17i_L()
{
  {
    init_simple_test("Ui_BFu17i_L");
    static STRUCT_IF_C Ui_BFu17i_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_L");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_L");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_L, Ui_BFu17i_L)
//============================================================================


struct  Ui_BFu17i_S  {
  unsigned int v1;
  unsigned int v2:17;
  short v3;
};
//SIG(1 Ui_BFu17i_S) C1{ Fi Fi:17 Fs}



static void Test_Ui_BFu17i_S()
{
  {
    init_simple_test("Ui_BFu17i_S");
    static STRUCT_IF_C Ui_BFu17i_S lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_S");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_S");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_S, Ui_BFu17i_S)
//============================================================================


struct  Ui_BFu17i_Uc  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 Ui_BFu17i_Uc) C1{ Fi Fi:17 Fc}



static void Test_Ui_BFu17i_Uc()
{
  {
    init_simple_test("Ui_BFu17i_Uc");
    static STRUCT_IF_C Ui_BFu17i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_Uc");
    check_field_offset(lv, v3, 7, "Ui_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_Uc, Ui_BFu17i_Uc)
//============================================================================


struct  Ui_BFu17i_Ui  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 Ui_BFu17i_Ui) C1{ Fi Fi:17 Fi}



static void Test_Ui_BFu17i_Ui()
{
  {
    init_simple_test("Ui_BFu17i_Ui");
    static STRUCT_IF_C Ui_BFu17i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_Ui, Ui_BFu17i_Ui)
//============================================================================


struct  Ui_BFu17i_Ul  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 Ui_BFu17i_Ul) C1{ Fi Fi:17 FL}



static void Test_Ui_BFu17i_Ul()
{
  {
    init_simple_test("Ui_BFu17i_Ul");
    static STRUCT_IF_C Ui_BFu17i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_Ul, Ui_BFu17i_Ul)
//============================================================================


struct  Ui_BFu17i_Us  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 Ui_BFu17i_Us) C1{ Fi Fi:17 Fs}



static void Test_Ui_BFu17i_Us()
{
  {
    init_simple_test("Ui_BFu17i_Us");
    static STRUCT_IF_C Ui_BFu17i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu17i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_Us");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_Us");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_Us, Ui_BFu17i_Us)
//============================================================================


struct  Ui_BFu17i_Vp  {
  unsigned int v1;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 Ui_BFu17i_Vp) C1{ Fi Fi:17 Fp}



static void Test_Ui_BFu17i_Vp()
{
  {
    init_simple_test("Ui_BFu17i_Vp");
    static STRUCT_IF_C Ui_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17i_Vp, Ui_BFu17i_Vp)
//============================================================================


struct  Ui_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:17;
};
//SIG(1 Ui_BFu17ll) C1{ Fi FL:17}



static void Test_Ui_BFu17ll()
{
  {
    init_simple_test("Ui_BFu17ll");
    static STRUCT_IF_C Ui_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll, Ui_BFu17ll)
//============================================================================


struct  Ui_BFu17ll_BFu15i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu17ll_BFu15i) C1{ Fi FL:17 Fi:15}



static void Test_Ui_BFu17ll_BFu15i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu15i");
    static STRUCT_IF_C Ui_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Ui_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Ui_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu15i, Ui_BFu17ll_BFu15i)
//============================================================================


struct  Ui_BFu17ll_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu17ll_BFu15ll) C1{ Fi FL:17 FL:15}



static void Test_Ui_BFu17ll_BFu15ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu15ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Ui_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Ui_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu15ll, Ui_BFu17ll_BFu15ll)
//============================================================================


struct  Ui_BFu17ll_BFu15s  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu17ll_BFu15s) C1{ Fi FL:17 Fs:15}



static void Test_Ui_BFu17ll_BFu15s()
{
  {
    init_simple_test("Ui_BFu17ll_BFu15s");
    static STRUCT_IF_C Ui_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Ui_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Ui_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu15s, Ui_BFu17ll_BFu15s)
//============================================================================


struct  Ui_BFu17ll_BFu16i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu17ll_BFu16i) C1{ Fi FL:17 Fi:16}



static void Test_Ui_BFu17ll_BFu16i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu16i");
    static STRUCT_IF_C Ui_BFu17ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu16i, Ui_BFu17ll_BFu16i)
//============================================================================


struct  Ui_BFu17ll_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu17ll_BFu16ll) C1{ Fi FL:17 FL:16}



static void Test_Ui_BFu17ll_BFu16ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu16ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, 1, "Ui_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, hide_ull(1LL<<15), "Ui_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu16ll, Ui_BFu17ll_BFu16ll)
//============================================================================


struct  Ui_BFu17ll_BFu16s  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu17ll_BFu16s) C1{ Fi FL:17 Fs:16}



static void Test_Ui_BFu17ll_BFu16s()
{
  {
    init_simple_test("Ui_BFu17ll_BFu16s");
    static STRUCT_IF_C Ui_BFu17ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu16s, Ui_BFu17ll_BFu16s)
//============================================================================


struct  Ui_BFu17ll_BFu17i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu17ll_BFu17i) C1{ Fi FL:17 Fi:17}



static void Test_Ui_BFu17ll_BFu17i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu17i");
    static STRUCT_IF_C Ui_BFu17ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu17i, Ui_BFu17ll_BFu17i)
//============================================================================


struct  Ui_BFu17ll_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu17ll_BFu17ll) C1{ Fi FL:17 FL:17}



static void Test_Ui_BFu17ll_BFu17ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu17ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, 1, "Ui_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu17ll, Ui_BFu17ll_BFu17ll)
//============================================================================


struct  Ui_BFu17ll_BFu1c  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu17ll_BFu1c) C1{ Fi FL:17 Fc:1}



static void Test_Ui_BFu17ll_BFu1c()
{
  {
    init_simple_test("Ui_BFu17ll_BFu1c");
    static STRUCT_IF_C Ui_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Ui_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu1c, Ui_BFu17ll_BFu1c)
//============================================================================


struct  Ui_BFu17ll_BFu1i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu17ll_BFu1i) C1{ Fi FL:17 Fi:1}



static void Test_Ui_BFu17ll_BFu1i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu1i");
    static STRUCT_IF_C Ui_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Ui_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu1i, Ui_BFu17ll_BFu1i)
//============================================================================


struct  Ui_BFu17ll_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu17ll_BFu1ll) C1{ Fi FL:17 FL:1}



static void Test_Ui_BFu17ll_BFu1ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu1ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Ui_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu1ll, Ui_BFu17ll_BFu1ll)
//============================================================================


struct  Ui_BFu17ll_BFu1s  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu17ll_BFu1s) C1{ Fi FL:17 Fs:1}



static void Test_Ui_BFu17ll_BFu1s()
{
  {
    init_simple_test("Ui_BFu17ll_BFu1s");
    static STRUCT_IF_C Ui_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Ui_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu1s, Ui_BFu17ll_BFu1s)
//============================================================================


struct  Ui_BFu17ll_BFu31i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu17ll_BFu31i) C1{ Fi FL:17 Fi:31}



static void Test_Ui_BFu17ll_BFu31i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu31i");
    static STRUCT_IF_C Ui_BFu17ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu31i, Ui_BFu17ll_BFu31i)
//============================================================================


struct  Ui_BFu17ll_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu17ll_BFu31ll) C1{ Fi FL:17 FL:31}



static void Test_Ui_BFu17ll_BFu31ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu31ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, 1, "Ui_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, hide_ull(1LL<<30), "Ui_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu31ll, Ui_BFu17ll_BFu31ll)
//============================================================================


struct  Ui_BFu17ll_BFu32i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu17ll_BFu32i) C1{ Fi FL:17 Fi:32}



static void Test_Ui_BFu17ll_BFu32i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu32i");
    static STRUCT_IF_C Ui_BFu17ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu32i, Ui_BFu17ll_BFu32i)
//============================================================================


struct  Ui_BFu17ll_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu17ll_BFu32ll) C1{ Fi FL:17 FL:32}



static void Test_Ui_BFu17ll_BFu32ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu32ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, 1, "Ui_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Ui_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu32ll, Ui_BFu17ll_BFu32ll)
//============================================================================


struct  Ui_BFu17ll_BFu33  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu17ll_BFu33) C1{ Fi FL:17 FL:33}



static void Test_Ui_BFu17ll_BFu33()
{
  {
    init_simple_test("Ui_BFu17ll_BFu33");
    static STRUCT_IF_C Ui_BFu17ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, 1, "Ui_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Ui_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu33, Ui_BFu17ll_BFu33)
//============================================================================


struct  Ui_BFu17ll_BFu7c  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu17ll_BFu7c) C1{ Fi FL:17 Fc:7}



static void Test_Ui_BFu17ll_BFu7c()
{
  {
    init_simple_test("Ui_BFu17ll_BFu7c");
    static STRUCT_IF_C Ui_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Ui_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Ui_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu7c, Ui_BFu17ll_BFu7c)
//============================================================================


struct  Ui_BFu17ll_BFu7i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu17ll_BFu7i) C1{ Fi FL:17 Fi:7}



static void Test_Ui_BFu17ll_BFu7i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu7i");
    static STRUCT_IF_C Ui_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Ui_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Ui_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu7i, Ui_BFu17ll_BFu7i)
//============================================================================


struct  Ui_BFu17ll_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu17ll_BFu7ll) C1{ Fi FL:17 FL:7}



static void Test_Ui_BFu17ll_BFu7ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu7ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Ui_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Ui_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu7ll, Ui_BFu17ll_BFu7ll)
//============================================================================


struct  Ui_BFu17ll_BFu7s  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu17ll_BFu7s) C1{ Fi FL:17 Fs:7}



static void Test_Ui_BFu17ll_BFu7s()
{
  {
    init_simple_test("Ui_BFu17ll_BFu7s");
    static STRUCT_IF_C Ui_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Ui_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Ui_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu7s, Ui_BFu17ll_BFu7s)
//============================================================================


struct  Ui_BFu17ll_BFu8c  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu17ll_BFu8c) C1{ Fi FL:17 Fc:8}



static void Test_Ui_BFu17ll_BFu8c()
{
  {
    init_simple_test("Ui_BFu17ll_BFu8c");
    static STRUCT_IF_C Ui_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, 1, "Ui_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, hide_ull(1LL<<7), "Ui_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu8c, Ui_BFu17ll_BFu8c)
//============================================================================


struct  Ui_BFu17ll_BFu8i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu17ll_BFu8i) C1{ Fi FL:17 Fi:8}



static void Test_Ui_BFu17ll_BFu8i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu8i");
    static STRUCT_IF_C Ui_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Ui_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Ui_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu8i, Ui_BFu17ll_BFu8i)
//============================================================================


struct  Ui_BFu17ll_BFu8ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu17ll_BFu8ll) C1{ Fi FL:17 FL:8}



static void Test_Ui_BFu17ll_BFu8ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu8ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Ui_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Ui_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu8ll, Ui_BFu17ll_BFu8ll)
//============================================================================


struct  Ui_BFu17ll_BFu8s  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu17ll_BFu8s) C1{ Fi FL:17 Fs:8}



static void Test_Ui_BFu17ll_BFu8s()
{
  {
    init_simple_test("Ui_BFu17ll_BFu8s");
    static STRUCT_IF_C Ui_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Ui_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Ui_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu8s, Ui_BFu17ll_BFu8s)
//============================================================================


struct  Ui_BFu17ll_BFu9i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu17ll_BFu9i) C1{ Fi FL:17 Fi:9}



static void Test_Ui_BFu17ll_BFu9i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu9i");
    static STRUCT_IF_C Ui_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Ui_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Ui_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu9i, Ui_BFu17ll_BFu9i)
//============================================================================


struct  Ui_BFu17ll_BFu9ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu17ll_BFu9ll) C1{ Fi FL:17 FL:9}



static void Test_Ui_BFu17ll_BFu9ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu9ll");
    static STRUCT_IF_C Ui_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Ui_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Ui_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu9ll, Ui_BFu17ll_BFu9ll)
//============================================================================


struct  Ui_BFu17ll_BFu9s  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu17ll_BFu9s) C1{ Fi FL:17 Fs:9}



static void Test_Ui_BFu17ll_BFu9s()
{
  {
    init_simple_test("Ui_BFu17ll_BFu9s");
    static STRUCT_IF_C Ui_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Ui_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Ui_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_BFu9s, Ui_BFu17ll_BFu9s)
//============================================================================


struct  Ui_BFu17ll_C  {
  unsigned int v1;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 Ui_BFu17ll_C) C1{ Fi FL:17 Fc}



static void Test_Ui_BFu17ll_C()
{
  {
    init_simple_test("Ui_BFu17ll_C");
    static STRUCT_IF_C Ui_BFu17ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_C");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_C");
    check_field_offset(lv, v3, 7, "Ui_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_C, Ui_BFu17ll_C)
//============================================================================


struct  Ui_BFu17ll_D  {
  unsigned int v1;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 Ui_BFu17ll_D) C1{ Fi FL:17 FL}



static void Test_Ui_BFu17ll_D()
{
  {
    init_simple_test("Ui_BFu17ll_D");
    static STRUCT_IF_C Ui_BFu17ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_D");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_D");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_D, Ui_BFu17ll_D)
//============================================================================


struct  Ui_BFu17ll_F  {
  unsigned int v1;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 Ui_BFu17ll_F) C1{ Fi FL:17 Fi}



static void Test_Ui_BFu17ll_F()
{
  {
    init_simple_test("Ui_BFu17ll_F");
    static STRUCT_IF_C Ui_BFu17ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_F");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_F");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_F, Ui_BFu17ll_F)
//============================================================================


struct  Ui_BFu17ll_I  {
  unsigned int v1;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 Ui_BFu17ll_I) C1{ Fi FL:17 Fi}



static void Test_Ui_BFu17ll_I()
{
  {
    init_simple_test("Ui_BFu17ll_I");
    static STRUCT_IF_C Ui_BFu17ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_I");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_I");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_I, Ui_BFu17ll_I)
//============================================================================


struct  Ui_BFu17ll_Ip  {
  unsigned int v1;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 Ui_BFu17ll_Ip) C1{ Fi FL:17 Fp}



static void Test_Ui_BFu17ll_Ip()
{
  {
    init_simple_test("Ui_BFu17ll_Ip");
    static STRUCT_IF_C Ui_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_Ip, Ui_BFu17ll_Ip)
//============================================================================


struct  Ui_BFu17ll_L  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 Ui_BFu17ll_L) C1{ Fi FL:17 FL}



static void Test_Ui_BFu17ll_L()
{
  {
    init_simple_test("Ui_BFu17ll_L");
    static STRUCT_IF_C Ui_BFu17ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_L");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_L");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_L, Ui_BFu17ll_L)
//============================================================================


struct  Ui_BFu17ll_S  {
  unsigned int v1;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 Ui_BFu17ll_S) C1{ Fi FL:17 Fs}



static void Test_Ui_BFu17ll_S()
{
  {
    init_simple_test("Ui_BFu17ll_S");
    static STRUCT_IF_C Ui_BFu17ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_S");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_S");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_S, Ui_BFu17ll_S)
//============================================================================


struct  Ui_BFu17ll_Uc  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 Ui_BFu17ll_Uc) C1{ Fi FL:17 Fc}



static void Test_Ui_BFu17ll_Uc()
{
  {
    init_simple_test("Ui_BFu17ll_Uc");
    static STRUCT_IF_C Ui_BFu17ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_Uc");
    check_field_offset(lv, v3, 7, "Ui_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_Uc, Ui_BFu17ll_Uc)
//============================================================================


struct  Ui_BFu17ll_Ui  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 Ui_BFu17ll_Ui) C1{ Fi FL:17 Fi}



static void Test_Ui_BFu17ll_Ui()
{
  {
    init_simple_test("Ui_BFu17ll_Ui");
    static STRUCT_IF_C Ui_BFu17ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_Ui, Ui_BFu17ll_Ui)
//============================================================================


struct  Ui_BFu17ll_Ul  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 Ui_BFu17ll_Ul) C1{ Fi FL:17 FL}



static void Test_Ui_BFu17ll_Ul()
{
  {
    init_simple_test("Ui_BFu17ll_Ul");
    static STRUCT_IF_C Ui_BFu17ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_Ul, Ui_BFu17ll_Ul)
//============================================================================


struct  Ui_BFu17ll_Us  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 Ui_BFu17ll_Us) C1{ Fi FL:17 Fs}



static void Test_Ui_BFu17ll_Us()
{
  {
    init_simple_test("Ui_BFu17ll_Us");
    static STRUCT_IF_C Ui_BFu17ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_Us");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_Us, Ui_BFu17ll_Us)
//============================================================================


struct  Ui_BFu17ll_Vp  {
  unsigned int v1;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 Ui_BFu17ll_Vp) C1{ Fi FL:17 Fp}



static void Test_Ui_BFu17ll_Vp()
{
  {
    init_simple_test("Ui_BFu17ll_Vp");
    static STRUCT_IF_C Ui_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu17ll_Vp, Ui_BFu17ll_Vp)
//============================================================================


struct  Ui_BFu1c  {
  unsigned int v1;
  unsigned char v2:1;
};
//SIG(1 Ui_BFu1c) C1{ Fi Fc:1}



static void Test_Ui_BFu1c()
{
  {
    init_simple_test("Ui_BFu1c");
    static STRUCT_IF_C Ui_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c, Ui_BFu1c)
//============================================================================


struct  Ui_BFu1c_BFu15i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu1c_BFu15i) C1{ Fi Fc:1 Fi:15}



static void Test_Ui_BFu1c_BFu15i()
{
  {
    init_simple_test("Ui_BFu1c_BFu15i");
    static STRUCT_IF_C Ui_BFu1c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu15i, Ui_BFu1c_BFu15i)
//============================================================================


struct  Ui_BFu1c_BFu15ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu1c_BFu15ll) C1{ Fi Fc:1 FL:15}



static void Test_Ui_BFu1c_BFu15ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu15ll");
    static STRUCT_IF_C Ui_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu15ll, Ui_BFu1c_BFu15ll)
//============================================================================


struct  Ui_BFu1c_BFu15s  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu1c_BFu15s) C1{ Fi Fc:1 Fs:15}



static void Test_Ui_BFu1c_BFu15s()
{
  {
    init_simple_test("Ui_BFu1c_BFu15s");
    static STRUCT_IF_C Ui_BFu1c_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu15s, Ui_BFu1c_BFu15s)
//============================================================================


struct  Ui_BFu1c_BFu16i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu1c_BFu16i) C1{ Fi Fc:1 Fi:16}



static void Test_Ui_BFu1c_BFu16i()
{
  {
    init_simple_test("Ui_BFu1c_BFu16i");
    static STRUCT_IF_C Ui_BFu1c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Ui_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Ui_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu16i, Ui_BFu1c_BFu16i)
//============================================================================


struct  Ui_BFu1c_BFu16ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu1c_BFu16ll) C1{ Fi Fc:1 FL:16}



static void Test_Ui_BFu1c_BFu16ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu16ll");
    static STRUCT_IF_C Ui_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Ui_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Ui_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu16ll, Ui_BFu1c_BFu16ll)
//============================================================================


struct  Ui_BFu1c_BFu16s  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu1c_BFu16s) C1{ Fi Fc:1 Fs:16}



static void Test_Ui_BFu1c_BFu16s()
{
  {
    init_simple_test("Ui_BFu1c_BFu16s");
    static STRUCT_IF_C Ui_BFu1c_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu16s, Ui_BFu1c_BFu16s)
//============================================================================


struct  Ui_BFu1c_BFu17i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu1c_BFu17i) C1{ Fi Fc:1 Fi:17}



static void Test_Ui_BFu1c_BFu17i()
{
  {
    init_simple_test("Ui_BFu1c_BFu17i");
    static STRUCT_IF_C Ui_BFu1c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Ui_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Ui_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu17i, Ui_BFu1c_BFu17i)
//============================================================================


struct  Ui_BFu1c_BFu17ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu1c_BFu17ll) C1{ Fi Fc:1 FL:17}



static void Test_Ui_BFu1c_BFu17ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu17ll");
    static STRUCT_IF_C Ui_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Ui_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Ui_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu17ll, Ui_BFu1c_BFu17ll)
//============================================================================


struct  Ui_BFu1c_BFu1c  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu1c_BFu1c) C1{ Fi Fc:1 Fc:1}



static void Test_Ui_BFu1c_BFu1c()
{
  {
    init_simple_test("Ui_BFu1c_BFu1c");
    static STRUCT_IF_C Ui_BFu1c_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu1c, Ui_BFu1c_BFu1c)
//============================================================================


struct  Ui_BFu1c_BFu1i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu1c_BFu1i) C1{ Fi Fc:1 Fi:1}



static void Test_Ui_BFu1c_BFu1i()
{
  {
    init_simple_test("Ui_BFu1c_BFu1i");
    static STRUCT_IF_C Ui_BFu1c_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu1i, Ui_BFu1c_BFu1i)
//============================================================================


struct  Ui_BFu1c_BFu1ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu1c_BFu1ll) C1{ Fi Fc:1 FL:1}



static void Test_Ui_BFu1c_BFu1ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu1ll");
    static STRUCT_IF_C Ui_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu1ll, Ui_BFu1c_BFu1ll)
//============================================================================


struct  Ui_BFu1c_BFu1s  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu1c_BFu1s) C1{ Fi Fc:1 Fs:1}



static void Test_Ui_BFu1c_BFu1s()
{
  {
    init_simple_test("Ui_BFu1c_BFu1s");
    static STRUCT_IF_C Ui_BFu1c_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu1s, Ui_BFu1c_BFu1s)
//============================================================================


struct  Ui_BFu1c_BFu31i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu1c_BFu31i) C1{ Fi Fc:1 Fi:31}



static void Test_Ui_BFu1c_BFu31i()
{
  {
    init_simple_test("Ui_BFu1c_BFu31i");
    static STRUCT_IF_C Ui_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Ui_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Ui_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu31i, Ui_BFu1c_BFu31i)
//============================================================================


struct  Ui_BFu1c_BFu31ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu1c_BFu31ll) C1{ Fi Fc:1 FL:31}



static void Test_Ui_BFu1c_BFu31ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu31ll");
    static STRUCT_IF_C Ui_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Ui_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Ui_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu31ll, Ui_BFu1c_BFu31ll)
//============================================================================


struct  Ui_BFu1c_BFu32i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu1c_BFu32i) C1{ Fi Fc:1 Fi:32}



static void Test_Ui_BFu1c_BFu32i()
{
  {
    init_simple_test("Ui_BFu1c_BFu32i");
    static STRUCT_IF_C Ui_BFu1c_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu32i, Ui_BFu1c_BFu32i)
//============================================================================


struct  Ui_BFu1c_BFu32ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu1c_BFu32ll) C1{ Fi Fc:1 FL:32}



static void Test_Ui_BFu1c_BFu32ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu32ll");
    static STRUCT_IF_C Ui_BFu1c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "Ui_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Ui_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu32ll, Ui_BFu1c_BFu32ll)
//============================================================================


struct  Ui_BFu1c_BFu33  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu1c_BFu33) C1{ Fi Fc:1 FL:33}



static void Test_Ui_BFu1c_BFu33()
{
  {
    init_simple_test("Ui_BFu1c_BFu33");
    static STRUCT_IF_C Ui_BFu1c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "Ui_BFu1c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Ui_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu33, Ui_BFu1c_BFu33)
//============================================================================


struct  Ui_BFu1c_BFu7c  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu1c_BFu7c) C1{ Fi Fc:1 Fc:7}



static void Test_Ui_BFu1c_BFu7c()
{
  {
    init_simple_test("Ui_BFu1c_BFu7c");
    static STRUCT_IF_C Ui_BFu1c_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu7c, Ui_BFu1c_BFu7c)
//============================================================================


struct  Ui_BFu1c_BFu7i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu1c_BFu7i) C1{ Fi Fc:1 Fi:7}



static void Test_Ui_BFu1c_BFu7i()
{
  {
    init_simple_test("Ui_BFu1c_BFu7i");
    static STRUCT_IF_C Ui_BFu1c_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu7i, Ui_BFu1c_BFu7i)
//============================================================================


struct  Ui_BFu1c_BFu7ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu1c_BFu7ll) C1{ Fi Fc:1 FL:7}



static void Test_Ui_BFu1c_BFu7ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu7ll");
    static STRUCT_IF_C Ui_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu7ll, Ui_BFu1c_BFu7ll)
//============================================================================


struct  Ui_BFu1c_BFu7s  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu1c_BFu7s) C1{ Fi Fc:1 Fs:7}



static void Test_Ui_BFu1c_BFu7s()
{
  {
    init_simple_test("Ui_BFu1c_BFu7s");
    static STRUCT_IF_C Ui_BFu1c_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu7s, Ui_BFu1c_BFu7s)
//============================================================================


struct  Ui_BFu1c_BFu8c  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu1c_BFu8c) C1{ Fi Fc:1 Fc:8}



static void Test_Ui_BFu1c_BFu8c()
{
  {
    init_simple_test("Ui_BFu1c_BFu8c");
    static STRUCT_IF_C Ui_BFu1c_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Ui_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Ui_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu8c, Ui_BFu1c_BFu8c)
//============================================================================


struct  Ui_BFu1c_BFu8i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu1c_BFu8i) C1{ Fi Fc:1 Fi:8}



static void Test_Ui_BFu1c_BFu8i()
{
  {
    init_simple_test("Ui_BFu1c_BFu8i");
    static STRUCT_IF_C Ui_BFu1c_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu8i, Ui_BFu1c_BFu8i)
//============================================================================


struct  Ui_BFu1c_BFu8ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu1c_BFu8ll) C1{ Fi Fc:1 FL:8}



static void Test_Ui_BFu1c_BFu8ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu8ll");
    static STRUCT_IF_C Ui_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu8ll, Ui_BFu1c_BFu8ll)
//============================================================================


struct  Ui_BFu1c_BFu8s  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu1c_BFu8s) C1{ Fi Fc:1 Fs:8}



static void Test_Ui_BFu1c_BFu8s()
{
  {
    init_simple_test("Ui_BFu1c_BFu8s");
    static STRUCT_IF_C Ui_BFu1c_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu8s, Ui_BFu1c_BFu8s)
//============================================================================


struct  Ui_BFu1c_BFu9i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu1c_BFu9i) C1{ Fi Fc:1 Fi:9}



static void Test_Ui_BFu1c_BFu9i()
{
  {
    init_simple_test("Ui_BFu1c_BFu9i");
    static STRUCT_IF_C Ui_BFu1c_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu9i, Ui_BFu1c_BFu9i)
//============================================================================


struct  Ui_BFu1c_BFu9ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu1c_BFu9ll) C1{ Fi Fc:1 FL:9}



static void Test_Ui_BFu1c_BFu9ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu9ll");
    static STRUCT_IF_C Ui_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu9ll, Ui_BFu1c_BFu9ll)
//============================================================================


struct  Ui_BFu1c_BFu9s  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu1c_BFu9s) C1{ Fi Fc:1 Fs:9}



static void Test_Ui_BFu1c_BFu9s()
{
  {
    init_simple_test("Ui_BFu1c_BFu9s");
    static STRUCT_IF_C Ui_BFu1c_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_BFu9s, Ui_BFu1c_BFu9s)
//============================================================================


struct  Ui_BFu1c_C  {
  unsigned int v1;
  unsigned char v2:1;
  char v3;
};
//SIG(1 Ui_BFu1c_C) C1{ Fi Fc:1 Fc}



static void Test_Ui_BFu1c_C()
{
  {
    init_simple_test("Ui_BFu1c_C");
    static STRUCT_IF_C Ui_BFu1c_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_C");
    check_field_offset(lv, v3, 5, "Ui_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_C, Ui_BFu1c_C)
//============================================================================


struct  Ui_BFu1c_D  {
  unsigned int v1;
  unsigned char v2:1;
  double v3;
};
//SIG(1 Ui_BFu1c_D) C1{ Fi Fc:1 FL}



static void Test_Ui_BFu1c_D()
{
  {
    init_simple_test("Ui_BFu1c_D");
    static STRUCT_IF_C Ui_BFu1c_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_D");
    check_field_offset(lv, v3, 8, "Ui_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_D, Ui_BFu1c_D)
//============================================================================


struct  Ui_BFu1c_F  {
  unsigned int v1;
  unsigned char v2:1;
  float v3;
};
//SIG(1 Ui_BFu1c_F) C1{ Fi Fc:1 Fi}



static void Test_Ui_BFu1c_F()
{
  {
    init_simple_test("Ui_BFu1c_F");
    static STRUCT_IF_C Ui_BFu1c_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1c_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_F");
    check_field_offset(lv, v3, 8, "Ui_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_F, Ui_BFu1c_F)
//============================================================================


struct  Ui_BFu1c_I  {
  unsigned int v1;
  unsigned char v2:1;
  int v3;
};
//SIG(1 Ui_BFu1c_I) C1{ Fi Fc:1 Fi}



static void Test_Ui_BFu1c_I()
{
  {
    init_simple_test("Ui_BFu1c_I");
    static STRUCT_IF_C Ui_BFu1c_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1c_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_I");
    check_field_offset(lv, v3, 8, "Ui_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_I, Ui_BFu1c_I)
//============================================================================


struct  Ui_BFu1c_Ip  {
  unsigned int v1;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 Ui_BFu1c_Ip) C1{ Fi Fc:1 Fp}



static void Test_Ui_BFu1c_Ip()
{
  {
    init_simple_test("Ui_BFu1c_Ip");
    static STRUCT_IF_C Ui_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_Ip, Ui_BFu1c_Ip)
//============================================================================


struct  Ui_BFu1c_L  {
  unsigned int v1;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 Ui_BFu1c_L) C1{ Fi Fc:1 FL}



static void Test_Ui_BFu1c_L()
{
  {
    init_simple_test("Ui_BFu1c_L");
    static STRUCT_IF_C Ui_BFu1c_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_L");
    check_field_offset(lv, v3, 8, "Ui_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_L, Ui_BFu1c_L)
//============================================================================


struct  Ui_BFu1c_S  {
  unsigned int v1;
  unsigned char v2:1;
  short v3;
};
//SIG(1 Ui_BFu1c_S) C1{ Fi Fc:1 Fs}



static void Test_Ui_BFu1c_S()
{
  {
    init_simple_test("Ui_BFu1c_S");
    static STRUCT_IF_C Ui_BFu1c_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_S");
    check_field_offset(lv, v3, 6, "Ui_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_S, Ui_BFu1c_S)
//============================================================================


struct  Ui_BFu1c_Uc  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 Ui_BFu1c_Uc) C1{ Fi Fc:1 Fc}



static void Test_Ui_BFu1c_Uc()
{
  {
    init_simple_test("Ui_BFu1c_Uc");
    static STRUCT_IF_C Ui_BFu1c_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_Uc");
    check_field_offset(lv, v3, 5, "Ui_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_Uc, Ui_BFu1c_Uc)
//============================================================================


struct  Ui_BFu1c_Ui  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 Ui_BFu1c_Ui) C1{ Fi Fc:1 Fi}



static void Test_Ui_BFu1c_Ui()
{
  {
    init_simple_test("Ui_BFu1c_Ui");
    static STRUCT_IF_C Ui_BFu1c_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_Ui, Ui_BFu1c_Ui)
//============================================================================


struct  Ui_BFu1c_Ul  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 Ui_BFu1c_Ul) C1{ Fi Fc:1 FL}



static void Test_Ui_BFu1c_Ul()
{
  {
    init_simple_test("Ui_BFu1c_Ul");
    static STRUCT_IF_C Ui_BFu1c_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_Ul, Ui_BFu1c_Ul)
//============================================================================


struct  Ui_BFu1c_Us  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 Ui_BFu1c_Us) C1{ Fi Fc:1 Fs}



static void Test_Ui_BFu1c_Us()
{
  {
    init_simple_test("Ui_BFu1c_Us");
    static STRUCT_IF_C Ui_BFu1c_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_Us, Ui_BFu1c_Us)
//============================================================================


struct  Ui_BFu1c_Vp  {
  unsigned int v1;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 Ui_BFu1c_Vp) C1{ Fi Fc:1 Fp}



static void Test_Ui_BFu1c_Vp()
{
  {
    init_simple_test("Ui_BFu1c_Vp");
    static STRUCT_IF_C Ui_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1c_Vp, Ui_BFu1c_Vp)
//============================================================================


struct  Ui_BFu1i  {
  unsigned int v1;
  unsigned int v2:1;
};
//SIG(1 Ui_BFu1i) C1{ Fi Fi:1}



static void Test_Ui_BFu1i()
{
  {
    init_simple_test("Ui_BFu1i");
    static STRUCT_IF_C Ui_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i, Ui_BFu1i)
//============================================================================


struct  Ui_BFu1i_BFu15i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu1i_BFu15i) C1{ Fi Fi:1 Fi:15}



static void Test_Ui_BFu1i_BFu15i()
{
  {
    init_simple_test("Ui_BFu1i_BFu15i");
    static STRUCT_IF_C Ui_BFu1i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu15i, Ui_BFu1i_BFu15i)
//============================================================================


struct  Ui_BFu1i_BFu15ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu1i_BFu15ll) C1{ Fi Fi:1 FL:15}



static void Test_Ui_BFu1i_BFu15ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu15ll");
    static STRUCT_IF_C Ui_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu15ll, Ui_BFu1i_BFu15ll)
//============================================================================


struct  Ui_BFu1i_BFu15s  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu1i_BFu15s) C1{ Fi Fi:1 Fs:15}



static void Test_Ui_BFu1i_BFu15s()
{
  {
    init_simple_test("Ui_BFu1i_BFu15s");
    static STRUCT_IF_C Ui_BFu1i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu15s, Ui_BFu1i_BFu15s)
//============================================================================


struct  Ui_BFu1i_BFu16i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu1i_BFu16i) C1{ Fi Fi:1 Fi:16}



static void Test_Ui_BFu1i_BFu16i()
{
  {
    init_simple_test("Ui_BFu1i_BFu16i");
    static STRUCT_IF_C Ui_BFu1i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Ui_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Ui_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu16i, Ui_BFu1i_BFu16i)
//============================================================================


struct  Ui_BFu1i_BFu16ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu1i_BFu16ll) C1{ Fi Fi:1 FL:16}



static void Test_Ui_BFu1i_BFu16ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu16ll");
    static STRUCT_IF_C Ui_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Ui_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Ui_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu16ll, Ui_BFu1i_BFu16ll)
//============================================================================


struct  Ui_BFu1i_BFu16s  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu1i_BFu16s) C1{ Fi Fi:1 Fs:16}



static void Test_Ui_BFu1i_BFu16s()
{
  {
    init_simple_test("Ui_BFu1i_BFu16s");
    static STRUCT_IF_C Ui_BFu1i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu16s, Ui_BFu1i_BFu16s)
//============================================================================


struct  Ui_BFu1i_BFu17i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu1i_BFu17i) C1{ Fi Fi:1 Fi:17}



static void Test_Ui_BFu1i_BFu17i()
{
  {
    init_simple_test("Ui_BFu1i_BFu17i");
    static STRUCT_IF_C Ui_BFu1i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Ui_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Ui_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu17i, Ui_BFu1i_BFu17i)
//============================================================================


struct  Ui_BFu1i_BFu17ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu1i_BFu17ll) C1{ Fi Fi:1 FL:17}



static void Test_Ui_BFu1i_BFu17ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu17ll");
    static STRUCT_IF_C Ui_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Ui_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Ui_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu17ll, Ui_BFu1i_BFu17ll)
//============================================================================


struct  Ui_BFu1i_BFu1c  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu1i_BFu1c) C1{ Fi Fi:1 Fc:1}



static void Test_Ui_BFu1i_BFu1c()
{
  {
    init_simple_test("Ui_BFu1i_BFu1c");
    static STRUCT_IF_C Ui_BFu1i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu1c, Ui_BFu1i_BFu1c)
//============================================================================


struct  Ui_BFu1i_BFu1i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu1i_BFu1i) C1{ Fi Fi:1 Fi:1}



static void Test_Ui_BFu1i_BFu1i()
{
  {
    init_simple_test("Ui_BFu1i_BFu1i");
    static STRUCT_IF_C Ui_BFu1i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu1i, Ui_BFu1i_BFu1i)
//============================================================================


struct  Ui_BFu1i_BFu1ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu1i_BFu1ll) C1{ Fi Fi:1 FL:1}



static void Test_Ui_BFu1i_BFu1ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu1ll");
    static STRUCT_IF_C Ui_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu1ll, Ui_BFu1i_BFu1ll)
//============================================================================


struct  Ui_BFu1i_BFu1s  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu1i_BFu1s) C1{ Fi Fi:1 Fs:1}



static void Test_Ui_BFu1i_BFu1s()
{
  {
    init_simple_test("Ui_BFu1i_BFu1s");
    static STRUCT_IF_C Ui_BFu1i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu1s, Ui_BFu1i_BFu1s)
//============================================================================


struct  Ui_BFu1i_BFu31i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu1i_BFu31i) C1{ Fi Fi:1 Fi:31}



static void Test_Ui_BFu1i_BFu31i()
{
  {
    init_simple_test("Ui_BFu1i_BFu31i");
    static STRUCT_IF_C Ui_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Ui_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Ui_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu31i, Ui_BFu1i_BFu31i)
//============================================================================


struct  Ui_BFu1i_BFu31ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu1i_BFu31ll) C1{ Fi Fi:1 FL:31}



static void Test_Ui_BFu1i_BFu31ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu31ll");
    static STRUCT_IF_C Ui_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Ui_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Ui_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu31ll, Ui_BFu1i_BFu31ll)
//============================================================================


struct  Ui_BFu1i_BFu32i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu1i_BFu32i) C1{ Fi Fi:1 Fi:32}



static void Test_Ui_BFu1i_BFu32i()
{
  {
    init_simple_test("Ui_BFu1i_BFu32i");
    static STRUCT_IF_C Ui_BFu1i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu32i, Ui_BFu1i_BFu32i)
//============================================================================


struct  Ui_BFu1i_BFu32ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu1i_BFu32ll) C1{ Fi Fi:1 FL:32}



static void Test_Ui_BFu1i_BFu32ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu32ll");
    static STRUCT_IF_C Ui_BFu1i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "Ui_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Ui_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu32ll, Ui_BFu1i_BFu32ll)
//============================================================================


struct  Ui_BFu1i_BFu33  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu1i_BFu33) C1{ Fi Fi:1 FL:33}



static void Test_Ui_BFu1i_BFu33()
{
  {
    init_simple_test("Ui_BFu1i_BFu33");
    static STRUCT_IF_C Ui_BFu1i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "Ui_BFu1i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Ui_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu33, Ui_BFu1i_BFu33)
//============================================================================


struct  Ui_BFu1i_BFu7c  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu1i_BFu7c) C1{ Fi Fi:1 Fc:7}



static void Test_Ui_BFu1i_BFu7c()
{
  {
    init_simple_test("Ui_BFu1i_BFu7c");
    static STRUCT_IF_C Ui_BFu1i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu7c, Ui_BFu1i_BFu7c)
//============================================================================


struct  Ui_BFu1i_BFu7i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu1i_BFu7i) C1{ Fi Fi:1 Fi:7}



static void Test_Ui_BFu1i_BFu7i()
{
  {
    init_simple_test("Ui_BFu1i_BFu7i");
    static STRUCT_IF_C Ui_BFu1i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu7i, Ui_BFu1i_BFu7i)
//============================================================================


struct  Ui_BFu1i_BFu7ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu1i_BFu7ll) C1{ Fi Fi:1 FL:7}



static void Test_Ui_BFu1i_BFu7ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu7ll");
    static STRUCT_IF_C Ui_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu7ll, Ui_BFu1i_BFu7ll)
//============================================================================


struct  Ui_BFu1i_BFu7s  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu1i_BFu7s) C1{ Fi Fi:1 Fs:7}



static void Test_Ui_BFu1i_BFu7s()
{
  {
    init_simple_test("Ui_BFu1i_BFu7s");
    static STRUCT_IF_C Ui_BFu1i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu7s, Ui_BFu1i_BFu7s)
//============================================================================


struct  Ui_BFu1i_BFu8c  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu1i_BFu8c) C1{ Fi Fi:1 Fc:8}



static void Test_Ui_BFu1i_BFu8c()
{
  {
    init_simple_test("Ui_BFu1i_BFu8c");
    static STRUCT_IF_C Ui_BFu1i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Ui_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Ui_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu8c, Ui_BFu1i_BFu8c)
//============================================================================


struct  Ui_BFu1i_BFu8i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu1i_BFu8i) C1{ Fi Fi:1 Fi:8}



static void Test_Ui_BFu1i_BFu8i()
{
  {
    init_simple_test("Ui_BFu1i_BFu8i");
    static STRUCT_IF_C Ui_BFu1i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu8i, Ui_BFu1i_BFu8i)
//============================================================================


struct  Ui_BFu1i_BFu8ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu1i_BFu8ll) C1{ Fi Fi:1 FL:8}



static void Test_Ui_BFu1i_BFu8ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu8ll");
    static STRUCT_IF_C Ui_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu8ll, Ui_BFu1i_BFu8ll)
//============================================================================


struct  Ui_BFu1i_BFu8s  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu1i_BFu8s) C1{ Fi Fi:1 Fs:8}



static void Test_Ui_BFu1i_BFu8s()
{
  {
    init_simple_test("Ui_BFu1i_BFu8s");
    static STRUCT_IF_C Ui_BFu1i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu8s, Ui_BFu1i_BFu8s)
//============================================================================


struct  Ui_BFu1i_BFu9i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu1i_BFu9i) C1{ Fi Fi:1 Fi:9}



static void Test_Ui_BFu1i_BFu9i()
{
  {
    init_simple_test("Ui_BFu1i_BFu9i");
    static STRUCT_IF_C Ui_BFu1i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu9i, Ui_BFu1i_BFu9i)
//============================================================================


struct  Ui_BFu1i_BFu9ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu1i_BFu9ll) C1{ Fi Fi:1 FL:9}



static void Test_Ui_BFu1i_BFu9ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu9ll");
    static STRUCT_IF_C Ui_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu9ll, Ui_BFu1i_BFu9ll)
//============================================================================


struct  Ui_BFu1i_BFu9s  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu1i_BFu9s) C1{ Fi Fi:1 Fs:9}



static void Test_Ui_BFu1i_BFu9s()
{
  {
    init_simple_test("Ui_BFu1i_BFu9s");
    static STRUCT_IF_C Ui_BFu1i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_BFu9s, Ui_BFu1i_BFu9s)
//============================================================================


struct  Ui_BFu1i_C  {
  unsigned int v1;
  unsigned int v2:1;
  char v3;
};
//SIG(1 Ui_BFu1i_C) C1{ Fi Fi:1 Fc}



static void Test_Ui_BFu1i_C()
{
  {
    init_simple_test("Ui_BFu1i_C");
    static STRUCT_IF_C Ui_BFu1i_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_C");
    check_field_offset(lv, v3, 5, "Ui_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_C, Ui_BFu1i_C)
//============================================================================


struct  Ui_BFu1i_D  {
  unsigned int v1;
  unsigned int v2:1;
  double v3;
};
//SIG(1 Ui_BFu1i_D) C1{ Fi Fi:1 FL}



static void Test_Ui_BFu1i_D()
{
  {
    init_simple_test("Ui_BFu1i_D");
    static STRUCT_IF_C Ui_BFu1i_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_D");
    check_field_offset(lv, v3, 8, "Ui_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_D, Ui_BFu1i_D)
//============================================================================


struct  Ui_BFu1i_F  {
  unsigned int v1;
  unsigned int v2:1;
  float v3;
};
//SIG(1 Ui_BFu1i_F) C1{ Fi Fi:1 Fi}



static void Test_Ui_BFu1i_F()
{
  {
    init_simple_test("Ui_BFu1i_F");
    static STRUCT_IF_C Ui_BFu1i_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_F");
    check_field_offset(lv, v3, 8, "Ui_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_F, Ui_BFu1i_F)
//============================================================================


struct  Ui_BFu1i_I  {
  unsigned int v1;
  unsigned int v2:1;
  int v3;
};
//SIG(1 Ui_BFu1i_I) C1{ Fi Fi:1 Fi}



static void Test_Ui_BFu1i_I()
{
  {
    init_simple_test("Ui_BFu1i_I");
    static STRUCT_IF_C Ui_BFu1i_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_I");
    check_field_offset(lv, v3, 8, "Ui_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_I, Ui_BFu1i_I)
//============================================================================


struct  Ui_BFu1i_Ip  {
  unsigned int v1;
  unsigned int v2:1;
  int *v3;
};
//SIG(1 Ui_BFu1i_Ip) C1{ Fi Fi:1 Fp}



static void Test_Ui_BFu1i_Ip()
{
  {
    init_simple_test("Ui_BFu1i_Ip");
    static STRUCT_IF_C Ui_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_Ip, Ui_BFu1i_Ip)
//============================================================================


struct  Ui_BFu1i_L  {
  unsigned int v1;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 Ui_BFu1i_L) C1{ Fi Fi:1 FL}



static void Test_Ui_BFu1i_L()
{
  {
    init_simple_test("Ui_BFu1i_L");
    static STRUCT_IF_C Ui_BFu1i_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_L");
    check_field_offset(lv, v3, 8, "Ui_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_L, Ui_BFu1i_L)
//============================================================================


struct  Ui_BFu1i_S  {
  unsigned int v1;
  unsigned int v2:1;
  short v3;
};
//SIG(1 Ui_BFu1i_S) C1{ Fi Fi:1 Fs}



static void Test_Ui_BFu1i_S()
{
  {
    init_simple_test("Ui_BFu1i_S");
    static STRUCT_IF_C Ui_BFu1i_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_S");
    check_field_offset(lv, v3, 6, "Ui_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_S, Ui_BFu1i_S)
//============================================================================


struct  Ui_BFu1i_Uc  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 Ui_BFu1i_Uc) C1{ Fi Fi:1 Fc}



static void Test_Ui_BFu1i_Uc()
{
  {
    init_simple_test("Ui_BFu1i_Uc");
    static STRUCT_IF_C Ui_BFu1i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_Uc");
    check_field_offset(lv, v3, 5, "Ui_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_Uc, Ui_BFu1i_Uc)
//============================================================================


struct  Ui_BFu1i_Ui  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 Ui_BFu1i_Ui) C1{ Fi Fi:1 Fi}



static void Test_Ui_BFu1i_Ui()
{
  {
    init_simple_test("Ui_BFu1i_Ui");
    static STRUCT_IF_C Ui_BFu1i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_Ui, Ui_BFu1i_Ui)
//============================================================================


struct  Ui_BFu1i_Ul  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 Ui_BFu1i_Ul) C1{ Fi Fi:1 FL}



static void Test_Ui_BFu1i_Ul()
{
  {
    init_simple_test("Ui_BFu1i_Ul");
    static STRUCT_IF_C Ui_BFu1i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_Ul, Ui_BFu1i_Ul)
//============================================================================


struct  Ui_BFu1i_Us  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 Ui_BFu1i_Us) C1{ Fi Fi:1 Fs}



static void Test_Ui_BFu1i_Us()
{
  {
    init_simple_test("Ui_BFu1i_Us");
    static STRUCT_IF_C Ui_BFu1i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_Us, Ui_BFu1i_Us)
//============================================================================


struct  Ui_BFu1i_Vp  {
  unsigned int v1;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 Ui_BFu1i_Vp) C1{ Fi Fi:1 Fp}



static void Test_Ui_BFu1i_Vp()
{
  {
    init_simple_test("Ui_BFu1i_Vp");
    static STRUCT_IF_C Ui_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1i_Vp, Ui_BFu1i_Vp)
//============================================================================


struct  Ui_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:1;
};
//SIG(1 Ui_BFu1ll) C1{ Fi FL:1}



static void Test_Ui_BFu1ll()
{
  {
    init_simple_test("Ui_BFu1ll");
    static STRUCT_IF_C Ui_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll, Ui_BFu1ll)
//============================================================================


struct  Ui_BFu1ll_BFu15i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu1ll_BFu15i) C1{ Fi FL:1 Fi:15}



static void Test_Ui_BFu1ll_BFu15i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu15i");
    static STRUCT_IF_C Ui_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu15i, Ui_BFu1ll_BFu15i)
//============================================================================


struct  Ui_BFu1ll_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu1ll_BFu15ll) C1{ Fi FL:1 FL:15}



static void Test_Ui_BFu1ll_BFu15ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu15ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu15ll, Ui_BFu1ll_BFu15ll)
//============================================================================


struct  Ui_BFu1ll_BFu15s  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu1ll_BFu15s) C1{ Fi FL:1 Fs:15}



static void Test_Ui_BFu1ll_BFu15s()
{
  {
    init_simple_test("Ui_BFu1ll_BFu15s");
    static STRUCT_IF_C Ui_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu15s, Ui_BFu1ll_BFu15s)
//============================================================================


struct  Ui_BFu1ll_BFu16i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu1ll_BFu16i) C1{ Fi FL:1 Fi:16}



static void Test_Ui_BFu1ll_BFu16i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu16i");
    static STRUCT_IF_C Ui_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Ui_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Ui_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu16i, Ui_BFu1ll_BFu16i)
//============================================================================


struct  Ui_BFu1ll_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu1ll_BFu16ll) C1{ Fi FL:1 FL:16}



static void Test_Ui_BFu1ll_BFu16ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu16ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Ui_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Ui_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu16ll, Ui_BFu1ll_BFu16ll)
//============================================================================


struct  Ui_BFu1ll_BFu16s  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu1ll_BFu16s) C1{ Fi FL:1 Fs:16}



static void Test_Ui_BFu1ll_BFu16s()
{
  {
    init_simple_test("Ui_BFu1ll_BFu16s");
    static STRUCT_IF_C Ui_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu16s, Ui_BFu1ll_BFu16s)
//============================================================================


struct  Ui_BFu1ll_BFu17i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu1ll_BFu17i) C1{ Fi FL:1 Fi:17}



static void Test_Ui_BFu1ll_BFu17i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu17i");
    static STRUCT_IF_C Ui_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Ui_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Ui_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu17i, Ui_BFu1ll_BFu17i)
//============================================================================


struct  Ui_BFu1ll_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu1ll_BFu17ll) C1{ Fi FL:1 FL:17}



static void Test_Ui_BFu1ll_BFu17ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu17ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Ui_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Ui_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu17ll, Ui_BFu1ll_BFu17ll)
//============================================================================


struct  Ui_BFu1ll_BFu1c  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu1ll_BFu1c) C1{ Fi FL:1 Fc:1}



static void Test_Ui_BFu1ll_BFu1c()
{
  {
    init_simple_test("Ui_BFu1ll_BFu1c");
    static STRUCT_IF_C Ui_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu1c, Ui_BFu1ll_BFu1c)
//============================================================================


struct  Ui_BFu1ll_BFu1i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu1ll_BFu1i) C1{ Fi FL:1 Fi:1}



static void Test_Ui_BFu1ll_BFu1i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu1i");
    static STRUCT_IF_C Ui_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu1i, Ui_BFu1ll_BFu1i)
//============================================================================


struct  Ui_BFu1ll_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu1ll_BFu1ll) C1{ Fi FL:1 FL:1}



static void Test_Ui_BFu1ll_BFu1ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu1ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu1ll, Ui_BFu1ll_BFu1ll)
//============================================================================


struct  Ui_BFu1ll_BFu1s  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu1ll_BFu1s) C1{ Fi FL:1 Fs:1}



static void Test_Ui_BFu1ll_BFu1s()
{
  {
    init_simple_test("Ui_BFu1ll_BFu1s");
    static STRUCT_IF_C Ui_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu1s, Ui_BFu1ll_BFu1s)
//============================================================================


struct  Ui_BFu1ll_BFu31i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu1ll_BFu31i) C1{ Fi FL:1 Fi:31}



static void Test_Ui_BFu1ll_BFu31i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu31i");
    static STRUCT_IF_C Ui_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Ui_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Ui_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu31i, Ui_BFu1ll_BFu31i)
//============================================================================


struct  Ui_BFu1ll_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu1ll_BFu31ll) C1{ Fi FL:1 FL:31}



static void Test_Ui_BFu1ll_BFu31ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu31ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Ui_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Ui_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu31ll, Ui_BFu1ll_BFu31ll)
//============================================================================


struct  Ui_BFu1ll_BFu32i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu1ll_BFu32i) C1{ Fi FL:1 Fi:32}



static void Test_Ui_BFu1ll_BFu32i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu32i");
    static STRUCT_IF_C Ui_BFu1ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu32i, Ui_BFu1ll_BFu32i)
//============================================================================


struct  Ui_BFu1ll_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu1ll_BFu32ll) C1{ Fi FL:1 FL:32}



static void Test_Ui_BFu1ll_BFu32ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu32ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "Ui_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Ui_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu32ll, Ui_BFu1ll_BFu32ll)
//============================================================================


struct  Ui_BFu1ll_BFu33  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu1ll_BFu33) C1{ Fi FL:1 FL:33}



static void Test_Ui_BFu1ll_BFu33()
{
  {
    init_simple_test("Ui_BFu1ll_BFu33");
    static STRUCT_IF_C Ui_BFu1ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "Ui_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Ui_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu33, Ui_BFu1ll_BFu33)
//============================================================================


struct  Ui_BFu1ll_BFu7c  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu1ll_BFu7c) C1{ Fi FL:1 Fc:7}



static void Test_Ui_BFu1ll_BFu7c()
{
  {
    init_simple_test("Ui_BFu1ll_BFu7c");
    static STRUCT_IF_C Ui_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu7c, Ui_BFu1ll_BFu7c)
//============================================================================


struct  Ui_BFu1ll_BFu7i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu1ll_BFu7i) C1{ Fi FL:1 Fi:7}



static void Test_Ui_BFu1ll_BFu7i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu7i");
    static STRUCT_IF_C Ui_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu7i, Ui_BFu1ll_BFu7i)
//============================================================================


struct  Ui_BFu1ll_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu1ll_BFu7ll) C1{ Fi FL:1 FL:7}



static void Test_Ui_BFu1ll_BFu7ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu7ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu7ll, Ui_BFu1ll_BFu7ll)
//============================================================================


struct  Ui_BFu1ll_BFu7s  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu1ll_BFu7s) C1{ Fi FL:1 Fs:7}



static void Test_Ui_BFu1ll_BFu7s()
{
  {
    init_simple_test("Ui_BFu1ll_BFu7s");
    static STRUCT_IF_C Ui_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu7s, Ui_BFu1ll_BFu7s)
//============================================================================


struct  Ui_BFu1ll_BFu8c  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu1ll_BFu8c) C1{ Fi FL:1 Fc:8}



static void Test_Ui_BFu1ll_BFu8c()
{
  {
    init_simple_test("Ui_BFu1ll_BFu8c");
    static STRUCT_IF_C Ui_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Ui_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Ui_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu8c, Ui_BFu1ll_BFu8c)
//============================================================================


struct  Ui_BFu1ll_BFu8i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu1ll_BFu8i) C1{ Fi FL:1 Fi:8}



static void Test_Ui_BFu1ll_BFu8i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu8i");
    static STRUCT_IF_C Ui_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu8i, Ui_BFu1ll_BFu8i)
//============================================================================


struct  Ui_BFu1ll_BFu8ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu1ll_BFu8ll) C1{ Fi FL:1 FL:8}



static void Test_Ui_BFu1ll_BFu8ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu8ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu8ll, Ui_BFu1ll_BFu8ll)
//============================================================================


struct  Ui_BFu1ll_BFu8s  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu1ll_BFu8s) C1{ Fi FL:1 Fs:8}



static void Test_Ui_BFu1ll_BFu8s()
{
  {
    init_simple_test("Ui_BFu1ll_BFu8s");
    static STRUCT_IF_C Ui_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu8s, Ui_BFu1ll_BFu8s)
//============================================================================


struct  Ui_BFu1ll_BFu9i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu1ll_BFu9i) C1{ Fi FL:1 Fi:9}



static void Test_Ui_BFu1ll_BFu9i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu9i");
    static STRUCT_IF_C Ui_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu9i, Ui_BFu1ll_BFu9i)
//============================================================================


struct  Ui_BFu1ll_BFu9ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu1ll_BFu9ll) C1{ Fi FL:1 FL:9}



static void Test_Ui_BFu1ll_BFu9ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu9ll");
    static STRUCT_IF_C Ui_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu9ll, Ui_BFu1ll_BFu9ll)
//============================================================================


struct  Ui_BFu1ll_BFu9s  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu1ll_BFu9s) C1{ Fi FL:1 Fs:9}



static void Test_Ui_BFu1ll_BFu9s()
{
  {
    init_simple_test("Ui_BFu1ll_BFu9s");
    static STRUCT_IF_C Ui_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_BFu9s, Ui_BFu1ll_BFu9s)
//============================================================================


struct  Ui_BFu1ll_C  {
  unsigned int v1;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 Ui_BFu1ll_C) C1{ Fi FL:1 Fc}



static void Test_Ui_BFu1ll_C()
{
  {
    init_simple_test("Ui_BFu1ll_C");
    static STRUCT_IF_C Ui_BFu1ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_C");
    check_field_offset(lv, v3, 5, "Ui_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_C, Ui_BFu1ll_C)
//============================================================================


struct  Ui_BFu1ll_D  {
  unsigned int v1;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 Ui_BFu1ll_D) C1{ Fi FL:1 FL}



static void Test_Ui_BFu1ll_D()
{
  {
    init_simple_test("Ui_BFu1ll_D");
    static STRUCT_IF_C Ui_BFu1ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_D");
    check_field_offset(lv, v3, 8, "Ui_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_D, Ui_BFu1ll_D)
//============================================================================


struct  Ui_BFu1ll_F  {
  unsigned int v1;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 Ui_BFu1ll_F) C1{ Fi FL:1 Fi}



static void Test_Ui_BFu1ll_F()
{
  {
    init_simple_test("Ui_BFu1ll_F");
    static STRUCT_IF_C Ui_BFu1ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_F");
    check_field_offset(lv, v3, 8, "Ui_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_F, Ui_BFu1ll_F)
//============================================================================


struct  Ui_BFu1ll_I  {
  unsigned int v1;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 Ui_BFu1ll_I) C1{ Fi FL:1 Fi}



static void Test_Ui_BFu1ll_I()
{
  {
    init_simple_test("Ui_BFu1ll_I");
    static STRUCT_IF_C Ui_BFu1ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_I");
    check_field_offset(lv, v3, 8, "Ui_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_I, Ui_BFu1ll_I)
//============================================================================


struct  Ui_BFu1ll_Ip  {
  unsigned int v1;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 Ui_BFu1ll_Ip) C1{ Fi FL:1 Fp}



static void Test_Ui_BFu1ll_Ip()
{
  {
    init_simple_test("Ui_BFu1ll_Ip");
    static STRUCT_IF_C Ui_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_Ip, Ui_BFu1ll_Ip)
//============================================================================


struct  Ui_BFu1ll_L  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 Ui_BFu1ll_L) C1{ Fi FL:1 FL}



static void Test_Ui_BFu1ll_L()
{
  {
    init_simple_test("Ui_BFu1ll_L");
    static STRUCT_IF_C Ui_BFu1ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_L");
    check_field_offset(lv, v3, 8, "Ui_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_L, Ui_BFu1ll_L)
//============================================================================


struct  Ui_BFu1ll_S  {
  unsigned int v1;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 Ui_BFu1ll_S) C1{ Fi FL:1 Fs}



static void Test_Ui_BFu1ll_S()
{
  {
    init_simple_test("Ui_BFu1ll_S");
    static STRUCT_IF_C Ui_BFu1ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_S");
    check_field_offset(lv, v3, 6, "Ui_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_S, Ui_BFu1ll_S)
//============================================================================


struct  Ui_BFu1ll_Uc  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 Ui_BFu1ll_Uc) C1{ Fi FL:1 Fc}



static void Test_Ui_BFu1ll_Uc()
{
  {
    init_simple_test("Ui_BFu1ll_Uc");
    static STRUCT_IF_C Ui_BFu1ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_Uc");
    check_field_offset(lv, v3, 5, "Ui_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_Uc, Ui_BFu1ll_Uc)
//============================================================================


struct  Ui_BFu1ll_Ui  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 Ui_BFu1ll_Ui) C1{ Fi FL:1 Fi}



static void Test_Ui_BFu1ll_Ui()
{
  {
    init_simple_test("Ui_BFu1ll_Ui");
    static STRUCT_IF_C Ui_BFu1ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_Ui, Ui_BFu1ll_Ui)
//============================================================================


struct  Ui_BFu1ll_Ul  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 Ui_BFu1ll_Ul) C1{ Fi FL:1 FL}



static void Test_Ui_BFu1ll_Ul()
{
  {
    init_simple_test("Ui_BFu1ll_Ul");
    static STRUCT_IF_C Ui_BFu1ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_Ul, Ui_BFu1ll_Ul)
//============================================================================


struct  Ui_BFu1ll_Us  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 Ui_BFu1ll_Us) C1{ Fi FL:1 Fs}



static void Test_Ui_BFu1ll_Us()
{
  {
    init_simple_test("Ui_BFu1ll_Us");
    static STRUCT_IF_C Ui_BFu1ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_Us, Ui_BFu1ll_Us)
//============================================================================


struct  Ui_BFu1ll_Vp  {
  unsigned int v1;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 Ui_BFu1ll_Vp) C1{ Fi FL:1 Fp}



static void Test_Ui_BFu1ll_Vp()
{
  {
    init_simple_test("Ui_BFu1ll_Vp");
    static STRUCT_IF_C Ui_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1ll_Vp, Ui_BFu1ll_Vp)
//============================================================================


struct  Ui_BFu1s  {
  unsigned int v1;
  unsigned short v2:1;
};
//SIG(1 Ui_BFu1s) C1{ Fi Fs:1}



static void Test_Ui_BFu1s()
{
  {
    init_simple_test("Ui_BFu1s");
    static STRUCT_IF_C Ui_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s, Ui_BFu1s)
//============================================================================


struct  Ui_BFu1s_BFu15i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu1s_BFu15i) C1{ Fi Fs:1 Fi:15}



static void Test_Ui_BFu1s_BFu15i()
{
  {
    init_simple_test("Ui_BFu1s_BFu15i");
    static STRUCT_IF_C Ui_BFu1s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu15i, Ui_BFu1s_BFu15i)
//============================================================================


struct  Ui_BFu1s_BFu15ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu1s_BFu15ll) C1{ Fi Fs:1 FL:15}



static void Test_Ui_BFu1s_BFu15ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu15ll");
    static STRUCT_IF_C Ui_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu15ll, Ui_BFu1s_BFu15ll)
//============================================================================


struct  Ui_BFu1s_BFu15s  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu1s_BFu15s) C1{ Fi Fs:1 Fs:15}



static void Test_Ui_BFu1s_BFu15s()
{
  {
    init_simple_test("Ui_BFu1s_BFu15s");
    static STRUCT_IF_C Ui_BFu1s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Ui_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Ui_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu15s, Ui_BFu1s_BFu15s)
//============================================================================


struct  Ui_BFu1s_BFu16i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu1s_BFu16i) C1{ Fi Fs:1 Fi:16}



static void Test_Ui_BFu1s_BFu16i()
{
  {
    init_simple_test("Ui_BFu1s_BFu16i");
    static STRUCT_IF_C Ui_BFu1s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Ui_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Ui_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu16i, Ui_BFu1s_BFu16i)
//============================================================================


struct  Ui_BFu1s_BFu16ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu1s_BFu16ll) C1{ Fi Fs:1 FL:16}



static void Test_Ui_BFu1s_BFu16ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu16ll");
    static STRUCT_IF_C Ui_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Ui_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Ui_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu16ll, Ui_BFu1s_BFu16ll)
//============================================================================


struct  Ui_BFu1s_BFu16s  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu1s_BFu16s) C1{ Fi Fs:1 Fs:16}



static void Test_Ui_BFu1s_BFu16s()
{
  {
    init_simple_test("Ui_BFu1s_BFu16s");
    static STRUCT_IF_C Ui_BFu1s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu16s, Ui_BFu1s_BFu16s)
//============================================================================


struct  Ui_BFu1s_BFu17i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu1s_BFu17i) C1{ Fi Fs:1 Fi:17}



static void Test_Ui_BFu1s_BFu17i()
{
  {
    init_simple_test("Ui_BFu1s_BFu17i");
    static STRUCT_IF_C Ui_BFu1s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Ui_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Ui_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu17i, Ui_BFu1s_BFu17i)
//============================================================================


struct  Ui_BFu1s_BFu17ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu1s_BFu17ll) C1{ Fi Fs:1 FL:17}



static void Test_Ui_BFu1s_BFu17ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu17ll");
    static STRUCT_IF_C Ui_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Ui_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Ui_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu17ll, Ui_BFu1s_BFu17ll)
//============================================================================


struct  Ui_BFu1s_BFu1c  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu1s_BFu1c) C1{ Fi Fs:1 Fc:1}



static void Test_Ui_BFu1s_BFu1c()
{
  {
    init_simple_test("Ui_BFu1s_BFu1c");
    static STRUCT_IF_C Ui_BFu1s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu1c, Ui_BFu1s_BFu1c)
//============================================================================


struct  Ui_BFu1s_BFu1i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu1s_BFu1i) C1{ Fi Fs:1 Fi:1}



static void Test_Ui_BFu1s_BFu1i()
{
  {
    init_simple_test("Ui_BFu1s_BFu1i");
    static STRUCT_IF_C Ui_BFu1s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu1i, Ui_BFu1s_BFu1i)
//============================================================================


struct  Ui_BFu1s_BFu1ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu1s_BFu1ll) C1{ Fi Fs:1 FL:1}



static void Test_Ui_BFu1s_BFu1ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu1ll");
    static STRUCT_IF_C Ui_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu1ll, Ui_BFu1s_BFu1ll)
//============================================================================


struct  Ui_BFu1s_BFu1s  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu1s_BFu1s) C1{ Fi Fs:1 Fs:1}



static void Test_Ui_BFu1s_BFu1s()
{
  {
    init_simple_test("Ui_BFu1s_BFu1s");
    static STRUCT_IF_C Ui_BFu1s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Ui_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu1s, Ui_BFu1s_BFu1s)
//============================================================================


struct  Ui_BFu1s_BFu31i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu1s_BFu31i) C1{ Fi Fs:1 Fi:31}



static void Test_Ui_BFu1s_BFu31i()
{
  {
    init_simple_test("Ui_BFu1s_BFu31i");
    static STRUCT_IF_C Ui_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Ui_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Ui_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu31i, Ui_BFu1s_BFu31i)
//============================================================================


struct  Ui_BFu1s_BFu31ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu1s_BFu31ll) C1{ Fi Fs:1 FL:31}



static void Test_Ui_BFu1s_BFu31ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu31ll");
    static STRUCT_IF_C Ui_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Ui_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Ui_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu31ll, Ui_BFu1s_BFu31ll)
//============================================================================


struct  Ui_BFu1s_BFu32i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu1s_BFu32i) C1{ Fi Fs:1 Fi:32}



static void Test_Ui_BFu1s_BFu32i()
{
  {
    init_simple_test("Ui_BFu1s_BFu32i");
    static STRUCT_IF_C Ui_BFu1s_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu32i, Ui_BFu1s_BFu32i)
//============================================================================


struct  Ui_BFu1s_BFu32ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu1s_BFu32ll) C1{ Fi Fs:1 FL:32}



static void Test_Ui_BFu1s_BFu32ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu32ll");
    static STRUCT_IF_C Ui_BFu1s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "Ui_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Ui_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu32ll, Ui_BFu1s_BFu32ll)
//============================================================================


struct  Ui_BFu1s_BFu33  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu1s_BFu33) C1{ Fi Fs:1 FL:33}



static void Test_Ui_BFu1s_BFu33()
{
  {
    init_simple_test("Ui_BFu1s_BFu33");
    static STRUCT_IF_C Ui_BFu1s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "Ui_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Ui_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu33, Ui_BFu1s_BFu33)
//============================================================================


struct  Ui_BFu1s_BFu7c  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu1s_BFu7c) C1{ Fi Fs:1 Fc:7}



static void Test_Ui_BFu1s_BFu7c()
{
  {
    init_simple_test("Ui_BFu1s_BFu7c");
    static STRUCT_IF_C Ui_BFu1s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu7c, Ui_BFu1s_BFu7c)
//============================================================================


struct  Ui_BFu1s_BFu7i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu1s_BFu7i) C1{ Fi Fs:1 Fi:7}



static void Test_Ui_BFu1s_BFu7i()
{
  {
    init_simple_test("Ui_BFu1s_BFu7i");
    static STRUCT_IF_C Ui_BFu1s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu7i, Ui_BFu1s_BFu7i)
//============================================================================


struct  Ui_BFu1s_BFu7ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu1s_BFu7ll) C1{ Fi Fs:1 FL:7}



static void Test_Ui_BFu1s_BFu7ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu7ll");
    static STRUCT_IF_C Ui_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu7ll, Ui_BFu1s_BFu7ll)
//============================================================================


struct  Ui_BFu1s_BFu7s  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu1s_BFu7s) C1{ Fi Fs:1 Fs:7}



static void Test_Ui_BFu1s_BFu7s()
{
  {
    init_simple_test("Ui_BFu1s_BFu7s");
    static STRUCT_IF_C Ui_BFu1s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Ui_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Ui_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu7s, Ui_BFu1s_BFu7s)
//============================================================================


struct  Ui_BFu1s_BFu8c  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu1s_BFu8c) C1{ Fi Fs:1 Fc:8}



static void Test_Ui_BFu1s_BFu8c()
{
  {
    init_simple_test("Ui_BFu1s_BFu8c");
    static STRUCT_IF_C Ui_BFu1s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Ui_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Ui_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu8c, Ui_BFu1s_BFu8c)
//============================================================================


struct  Ui_BFu1s_BFu8i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu1s_BFu8i) C1{ Fi Fs:1 Fi:8}



static void Test_Ui_BFu1s_BFu8i()
{
  {
    init_simple_test("Ui_BFu1s_BFu8i");
    static STRUCT_IF_C Ui_BFu1s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu8i, Ui_BFu1s_BFu8i)
//============================================================================


struct  Ui_BFu1s_BFu8ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu1s_BFu8ll) C1{ Fi Fs:1 FL:8}



static void Test_Ui_BFu1s_BFu8ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu8ll");
    static STRUCT_IF_C Ui_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu8ll, Ui_BFu1s_BFu8ll)
//============================================================================


struct  Ui_BFu1s_BFu8s  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu1s_BFu8s) C1{ Fi Fs:1 Fs:8}



static void Test_Ui_BFu1s_BFu8s()
{
  {
    init_simple_test("Ui_BFu1s_BFu8s");
    static STRUCT_IF_C Ui_BFu1s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Ui_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Ui_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu8s, Ui_BFu1s_BFu8s)
//============================================================================


struct  Ui_BFu1s_BFu9i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu1s_BFu9i) C1{ Fi Fs:1 Fi:9}



static void Test_Ui_BFu1s_BFu9i()
{
  {
    init_simple_test("Ui_BFu1s_BFu9i");
    static STRUCT_IF_C Ui_BFu1s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu9i, Ui_BFu1s_BFu9i)
//============================================================================


struct  Ui_BFu1s_BFu9ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu1s_BFu9ll) C1{ Fi Fs:1 FL:9}



static void Test_Ui_BFu1s_BFu9ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu9ll");
    static STRUCT_IF_C Ui_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu9ll, Ui_BFu1s_BFu9ll)
//============================================================================


struct  Ui_BFu1s_BFu9s  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu1s_BFu9s) C1{ Fi Fs:1 Fs:9}



static void Test_Ui_BFu1s_BFu9s()
{
  {
    init_simple_test("Ui_BFu1s_BFu9s");
    static STRUCT_IF_C Ui_BFu1s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Ui_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Ui_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_BFu9s, Ui_BFu1s_BFu9s)
//============================================================================


struct  Ui_BFu1s_C  {
  unsigned int v1;
  unsigned short v2:1;
  char v3;
};
//SIG(1 Ui_BFu1s_C) C1{ Fi Fs:1 Fc}



static void Test_Ui_BFu1s_C()
{
  {
    init_simple_test("Ui_BFu1s_C");
    static STRUCT_IF_C Ui_BFu1s_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_C");
    check_field_offset(lv, v3, 5, "Ui_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_C, Ui_BFu1s_C)
//============================================================================


struct  Ui_BFu1s_D  {
  unsigned int v1;
  unsigned short v2:1;
  double v3;
};
//SIG(1 Ui_BFu1s_D) C1{ Fi Fs:1 FL}



static void Test_Ui_BFu1s_D()
{
  {
    init_simple_test("Ui_BFu1s_D");
    static STRUCT_IF_C Ui_BFu1s_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_D");
    check_field_offset(lv, v3, 8, "Ui_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_D, Ui_BFu1s_D)
//============================================================================


struct  Ui_BFu1s_F  {
  unsigned int v1;
  unsigned short v2:1;
  float v3;
};
//SIG(1 Ui_BFu1s_F) C1{ Fi Fs:1 Fi}



static void Test_Ui_BFu1s_F()
{
  {
    init_simple_test("Ui_BFu1s_F");
    static STRUCT_IF_C Ui_BFu1s_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_F");
    check_field_offset(lv, v3, 8, "Ui_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_F, Ui_BFu1s_F)
//============================================================================


struct  Ui_BFu1s_I  {
  unsigned int v1;
  unsigned short v2:1;
  int v3;
};
//SIG(1 Ui_BFu1s_I) C1{ Fi Fs:1 Fi}



static void Test_Ui_BFu1s_I()
{
  {
    init_simple_test("Ui_BFu1s_I");
    static STRUCT_IF_C Ui_BFu1s_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_I");
    check_field_offset(lv, v3, 8, "Ui_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_I, Ui_BFu1s_I)
//============================================================================


struct  Ui_BFu1s_Ip  {
  unsigned int v1;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 Ui_BFu1s_Ip) C1{ Fi Fs:1 Fp}



static void Test_Ui_BFu1s_Ip()
{
  {
    init_simple_test("Ui_BFu1s_Ip");
    static STRUCT_IF_C Ui_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_Ip, Ui_BFu1s_Ip)
//============================================================================


struct  Ui_BFu1s_L  {
  unsigned int v1;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 Ui_BFu1s_L) C1{ Fi Fs:1 FL}



static void Test_Ui_BFu1s_L()
{
  {
    init_simple_test("Ui_BFu1s_L");
    static STRUCT_IF_C Ui_BFu1s_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_L");
    check_field_offset(lv, v3, 8, "Ui_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_L, Ui_BFu1s_L)
//============================================================================


struct  Ui_BFu1s_S  {
  unsigned int v1;
  unsigned short v2:1;
  short v3;
};
//SIG(1 Ui_BFu1s_S) C1{ Fi Fs:1 Fs}



static void Test_Ui_BFu1s_S()
{
  {
    init_simple_test("Ui_BFu1s_S");
    static STRUCT_IF_C Ui_BFu1s_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_S");
    check_field_offset(lv, v3, 6, "Ui_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_S, Ui_BFu1s_S)
//============================================================================


struct  Ui_BFu1s_Uc  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 Ui_BFu1s_Uc) C1{ Fi Fs:1 Fc}



static void Test_Ui_BFu1s_Uc()
{
  {
    init_simple_test("Ui_BFu1s_Uc");
    static STRUCT_IF_C Ui_BFu1s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_Uc");
    check_field_offset(lv, v3, 5, "Ui_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_Uc, Ui_BFu1s_Uc)
//============================================================================


struct  Ui_BFu1s_Ui  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 Ui_BFu1s_Ui) C1{ Fi Fs:1 Fi}



static void Test_Ui_BFu1s_Ui()
{
  {
    init_simple_test("Ui_BFu1s_Ui");
    static STRUCT_IF_C Ui_BFu1s_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_Ui, Ui_BFu1s_Ui)
//============================================================================


struct  Ui_BFu1s_Ul  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 Ui_BFu1s_Ul) C1{ Fi Fs:1 FL}



static void Test_Ui_BFu1s_Ul()
{
  {
    init_simple_test("Ui_BFu1s_Ul");
    static STRUCT_IF_C Ui_BFu1s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_Ul, Ui_BFu1s_Ul)
//============================================================================


struct  Ui_BFu1s_Us  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 Ui_BFu1s_Us) C1{ Fi Fs:1 Fs}



static void Test_Ui_BFu1s_Us()
{
  {
    init_simple_test("Ui_BFu1s_Us");
    static STRUCT_IF_C Ui_BFu1s_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_Us, Ui_BFu1s_Us)
//============================================================================


struct  Ui_BFu1s_Vp  {
  unsigned int v1;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 Ui_BFu1s_Vp) C1{ Fi Fs:1 Fp}



static void Test_Ui_BFu1s_Vp()
{
  {
    init_simple_test("Ui_BFu1s_Vp");
    static STRUCT_IF_C Ui_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu1s_Vp, Ui_BFu1s_Vp)
//============================================================================


struct  Ui_BFu31i  {
  unsigned int v1;
  unsigned int v2:31;
};
//SIG(1 Ui_BFu31i) C1{ Fi Fi:31}



static void Test_Ui_BFu31i()
{
  {
    init_simple_test("Ui_BFu31i");
    static STRUCT_IF_C Ui_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i, Ui_BFu31i)
//============================================================================


struct  Ui_BFu31i_BFu15i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu31i_BFu15i) C1{ Fi Fi:31 Fi:15}



static void Test_Ui_BFu31i_BFu15i()
{
  {
    init_simple_test("Ui_BFu31i_BFu15i");
    static STRUCT_IF_C Ui_BFu31i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu15i, Ui_BFu31i_BFu15i)
//============================================================================


struct  Ui_BFu31i_BFu15ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu31i_BFu15ll) C1{ Fi Fi:31 FL:15}



static void Test_Ui_BFu31i_BFu15ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu15ll");
    static STRUCT_IF_C Ui_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "Ui_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "Ui_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu15ll, Ui_BFu31i_BFu15ll)
//============================================================================


struct  Ui_BFu31i_BFu15s  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu31i_BFu15s) C1{ Fi Fi:31 Fs:15}



static void Test_Ui_BFu31i_BFu15s()
{
  {
    init_simple_test("Ui_BFu31i_BFu15s");
    static STRUCT_IF_C Ui_BFu31i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu15s, Ui_BFu31i_BFu15s)
//============================================================================


struct  Ui_BFu31i_BFu16i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu31i_BFu16i) C1{ Fi Fi:31 Fi:16}



static void Test_Ui_BFu31i_BFu16i()
{
  {
    init_simple_test("Ui_BFu31i_BFu16i");
    static STRUCT_IF_C Ui_BFu31i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu16i, Ui_BFu31i_BFu16i)
//============================================================================


struct  Ui_BFu31i_BFu16ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu31i_BFu16ll) C1{ Fi Fi:31 FL:16}



static void Test_Ui_BFu31i_BFu16ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu16ll");
    static STRUCT_IF_C Ui_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "Ui_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "Ui_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu16ll, Ui_BFu31i_BFu16ll)
//============================================================================


struct  Ui_BFu31i_BFu16s  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu31i_BFu16s) C1{ Fi Fi:31 Fs:16}



static void Test_Ui_BFu31i_BFu16s()
{
  {
    init_simple_test("Ui_BFu31i_BFu16s");
    static STRUCT_IF_C Ui_BFu31i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu16s, Ui_BFu31i_BFu16s)
//============================================================================


struct  Ui_BFu31i_BFu17i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu31i_BFu17i) C1{ Fi Fi:31 Fi:17}



static void Test_Ui_BFu31i_BFu17i()
{
  {
    init_simple_test("Ui_BFu31i_BFu17i");
    static STRUCT_IF_C Ui_BFu31i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu17i, Ui_BFu31i_BFu17i)
//============================================================================


struct  Ui_BFu31i_BFu17ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu31i_BFu17ll) C1{ Fi Fi:31 FL:17}



static void Test_Ui_BFu31i_BFu17ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu17ll");
    static STRUCT_IF_C Ui_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "Ui_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "Ui_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu17ll, Ui_BFu31i_BFu17ll)
//============================================================================


struct  Ui_BFu31i_BFu1c  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu31i_BFu1c) C1{ Fi Fi:31 Fc:1}



static void Test_Ui_BFu31i_BFu1c()
{
  {
    init_simple_test("Ui_BFu31i_BFu1c");
    static STRUCT_IF_C Ui_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Ui_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu1c, Ui_BFu31i_BFu1c)
//============================================================================


struct  Ui_BFu31i_BFu1i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu31i_BFu1i) C1{ Fi Fi:31 Fi:1}



static void Test_Ui_BFu31i_BFu1i()
{
  {
    init_simple_test("Ui_BFu31i_BFu1i");
    static STRUCT_IF_C Ui_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Ui_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu1i, Ui_BFu31i_BFu1i)
//============================================================================


struct  Ui_BFu31i_BFu1ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu31i_BFu1ll) C1{ Fi Fi:31 FL:1}



static void Test_Ui_BFu31i_BFu1ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu1ll");
    static STRUCT_IF_C Ui_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Ui_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu1ll, Ui_BFu31i_BFu1ll)
//============================================================================


struct  Ui_BFu31i_BFu1s  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu31i_BFu1s) C1{ Fi Fi:31 Fs:1}



static void Test_Ui_BFu31i_BFu1s()
{
  {
    init_simple_test("Ui_BFu31i_BFu1s");
    static STRUCT_IF_C Ui_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Ui_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu1s, Ui_BFu31i_BFu1s)
//============================================================================


struct  Ui_BFu31i_BFu31i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu31i_BFu31i) C1{ Fi Fi:31 Fi:31}



static void Test_Ui_BFu31i_BFu31i()
{
  {
    init_simple_test("Ui_BFu31i_BFu31i");
    static STRUCT_IF_C Ui_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu31i, Ui_BFu31i_BFu31i)
//============================================================================


struct  Ui_BFu31i_BFu31ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu31i_BFu31ll) C1{ Fi Fi:31 FL:31}



static void Test_Ui_BFu31i_BFu31ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu31ll");
    static STRUCT_IF_C Ui_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "Ui_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu31ll, Ui_BFu31i_BFu31ll)
//============================================================================


struct  Ui_BFu31i_BFu32i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu31i_BFu32i) C1{ Fi Fi:31 Fi:32}



static void Test_Ui_BFu31i_BFu32i()
{
  {
    init_simple_test("Ui_BFu31i_BFu32i");
    static STRUCT_IF_C Ui_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu32i, Ui_BFu31i_BFu32i)
//============================================================================


struct  Ui_BFu31i_BFu32ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu31i_BFu32ll) C1{ Fi Fi:31 FL:32}



static void Test_Ui_BFu31i_BFu32ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu32ll");
    static STRUCT_IF_C Ui_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "Ui_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu32ll, Ui_BFu31i_BFu32ll)
//============================================================================


struct  Ui_BFu31i_BFu33  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu31i_BFu33) C1{ Fi Fi:31 FL:33}



static void Test_Ui_BFu31i_BFu33()
{
  {
    init_simple_test("Ui_BFu31i_BFu33");
    static STRUCT_IF_C Ui_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "Ui_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu33, Ui_BFu31i_BFu33)
//============================================================================


struct  Ui_BFu31i_BFu7c  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu31i_BFu7c) C1{ Fi Fi:31 Fc:7}



static void Test_Ui_BFu31i_BFu7c()
{
  {
    init_simple_test("Ui_BFu31i_BFu7c");
    static STRUCT_IF_C Ui_BFu31i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu7c, Ui_BFu31i_BFu7c)
//============================================================================


struct  Ui_BFu31i_BFu7i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu31i_BFu7i) C1{ Fi Fi:31 Fi:7}



static void Test_Ui_BFu31i_BFu7i()
{
  {
    init_simple_test("Ui_BFu31i_BFu7i");
    static STRUCT_IF_C Ui_BFu31i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu7i, Ui_BFu31i_BFu7i)
//============================================================================


struct  Ui_BFu31i_BFu7ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu31i_BFu7ll) C1{ Fi Fi:31 FL:7}



static void Test_Ui_BFu31i_BFu7ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu7ll");
    static STRUCT_IF_C Ui_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "Ui_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "Ui_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu7ll, Ui_BFu31i_BFu7ll)
//============================================================================


struct  Ui_BFu31i_BFu7s  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu31i_BFu7s) C1{ Fi Fi:31 Fs:7}



static void Test_Ui_BFu31i_BFu7s()
{
  {
    init_simple_test("Ui_BFu31i_BFu7s");
    static STRUCT_IF_C Ui_BFu31i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu7s, Ui_BFu31i_BFu7s)
//============================================================================


struct  Ui_BFu31i_BFu8c  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu31i_BFu8c) C1{ Fi Fi:31 Fc:8}



static void Test_Ui_BFu31i_BFu8c()
{
  {
    init_simple_test("Ui_BFu31i_BFu8c");
    static STRUCT_IF_C Ui_BFu31i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu8c, Ui_BFu31i_BFu8c)
//============================================================================


struct  Ui_BFu31i_BFu8i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu31i_BFu8i) C1{ Fi Fi:31 Fi:8}



static void Test_Ui_BFu31i_BFu8i()
{
  {
    init_simple_test("Ui_BFu31i_BFu8i");
    static STRUCT_IF_C Ui_BFu31i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu8i, Ui_BFu31i_BFu8i)
//============================================================================


struct  Ui_BFu31i_BFu8ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu31i_BFu8ll) C1{ Fi Fi:31 FL:8}



static void Test_Ui_BFu31i_BFu8ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu8ll");
    static STRUCT_IF_C Ui_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "Ui_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "Ui_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu8ll, Ui_BFu31i_BFu8ll)
//============================================================================


struct  Ui_BFu31i_BFu8s  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu31i_BFu8s) C1{ Fi Fi:31 Fs:8}



static void Test_Ui_BFu31i_BFu8s()
{
  {
    init_simple_test("Ui_BFu31i_BFu8s");
    static STRUCT_IF_C Ui_BFu31i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu8s, Ui_BFu31i_BFu8s)
//============================================================================


struct  Ui_BFu31i_BFu9i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu31i_BFu9i) C1{ Fi Fi:31 Fi:9}



static void Test_Ui_BFu31i_BFu9i()
{
  {
    init_simple_test("Ui_BFu31i_BFu9i");
    static STRUCT_IF_C Ui_BFu31i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu9i, Ui_BFu31i_BFu9i)
//============================================================================


struct  Ui_BFu31i_BFu9ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu31i_BFu9ll) C1{ Fi Fi:31 FL:9}



static void Test_Ui_BFu31i_BFu9ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu9ll");
    static STRUCT_IF_C Ui_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "Ui_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "Ui_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu9ll, Ui_BFu31i_BFu9ll)
//============================================================================


struct  Ui_BFu31i_BFu9s  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu31i_BFu9s) C1{ Fi Fi:31 Fs:9}



static void Test_Ui_BFu31i_BFu9s()
{
  {
    init_simple_test("Ui_BFu31i_BFu9s");
    static STRUCT_IF_C Ui_BFu31i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_BFu9s, Ui_BFu31i_BFu9s)
//============================================================================


struct  Ui_BFu31i_C  {
  unsigned int v1;
  unsigned int v2:31;
  char v3;
};
//SIG(1 Ui_BFu31i_C) C1{ Fi Fi:31 Fc}



static void Test_Ui_BFu31i_C()
{
  {
    init_simple_test("Ui_BFu31i_C");
    static STRUCT_IF_C Ui_BFu31i_C lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_C");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_C, Ui_BFu31i_C)
//============================================================================


struct  Ui_BFu31i_D  {
  unsigned int v1;
  unsigned int v2:31;
  double v3;
};
//SIG(1 Ui_BFu31i_D) C1{ Fi Fi:31 FL}



static void Test_Ui_BFu31i_D()
{
  {
    init_simple_test("Ui_BFu31i_D");
    static STRUCT_IF_C Ui_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_D");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_D, Ui_BFu31i_D)
//============================================================================


struct  Ui_BFu31i_F  {
  unsigned int v1;
  unsigned int v2:31;
  float v3;
};
//SIG(1 Ui_BFu31i_F) C1{ Fi Fi:31 Fi}



static void Test_Ui_BFu31i_F()
{
  {
    init_simple_test("Ui_BFu31i_F");
    static STRUCT_IF_C Ui_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_F");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_F, Ui_BFu31i_F)
//============================================================================


struct  Ui_BFu31i_I  {
  unsigned int v1;
  unsigned int v2:31;
  int v3;
};
//SIG(1 Ui_BFu31i_I) C1{ Fi Fi:31 Fi}



static void Test_Ui_BFu31i_I()
{
  {
    init_simple_test("Ui_BFu31i_I");
    static STRUCT_IF_C Ui_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_I");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_I, Ui_BFu31i_I)
//============================================================================


struct  Ui_BFu31i_Ip  {
  unsigned int v1;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 Ui_BFu31i_Ip) C1{ Fi Fi:31 Fp}



static void Test_Ui_BFu31i_Ip()
{
  {
    init_simple_test("Ui_BFu31i_Ip");
    static STRUCT_IF_C Ui_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_Ip, Ui_BFu31i_Ip)
//============================================================================


struct  Ui_BFu31i_L  {
  unsigned int v1;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 Ui_BFu31i_L) C1{ Fi Fi:31 FL}



static void Test_Ui_BFu31i_L()
{
  {
    init_simple_test("Ui_BFu31i_L");
    static STRUCT_IF_C Ui_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_L");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_L, Ui_BFu31i_L)
//============================================================================


struct  Ui_BFu31i_S  {
  unsigned int v1;
  unsigned int v2:31;
  short v3;
};
//SIG(1 Ui_BFu31i_S) C1{ Fi Fi:31 Fs}



static void Test_Ui_BFu31i_S()
{
  {
    init_simple_test("Ui_BFu31i_S");
    static STRUCT_IF_C Ui_BFu31i_S lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_S");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_S, Ui_BFu31i_S)
//============================================================================


struct  Ui_BFu31i_Uc  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 Ui_BFu31i_Uc) C1{ Fi Fi:31 Fc}



static void Test_Ui_BFu31i_Uc()
{
  {
    init_simple_test("Ui_BFu31i_Uc");
    static STRUCT_IF_C Ui_BFu31i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_Uc, Ui_BFu31i_Uc)
//============================================================================


struct  Ui_BFu31i_Ui  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 Ui_BFu31i_Ui) C1{ Fi Fi:31 Fi}



static void Test_Ui_BFu31i_Ui()
{
  {
    init_simple_test("Ui_BFu31i_Ui");
    static STRUCT_IF_C Ui_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_Ui, Ui_BFu31i_Ui)
//============================================================================


struct  Ui_BFu31i_Ul  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 Ui_BFu31i_Ul) C1{ Fi Fi:31 FL}



static void Test_Ui_BFu31i_Ul()
{
  {
    init_simple_test("Ui_BFu31i_Ul");
    static STRUCT_IF_C Ui_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_Ul, Ui_BFu31i_Ul)
//============================================================================


struct  Ui_BFu31i_Us  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 Ui_BFu31i_Us) C1{ Fi Fi:31 Fs}



static void Test_Ui_BFu31i_Us()
{
  {
    init_simple_test("Ui_BFu31i_Us");
    static STRUCT_IF_C Ui_BFu31i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_Us");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_Us, Ui_BFu31i_Us)
//============================================================================


struct  Ui_BFu31i_Vp  {
  unsigned int v1;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 Ui_BFu31i_Vp) C1{ Fi Fi:31 Fp}



static void Test_Ui_BFu31i_Vp()
{
  {
    init_simple_test("Ui_BFu31i_Vp");
    static STRUCT_IF_C Ui_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31i_Vp, Ui_BFu31i_Vp)
//============================================================================


struct  Ui_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:31;
};
//SIG(1 Ui_BFu31ll) C1{ Fi FL:31}



static void Test_Ui_BFu31ll()
{
  {
    init_simple_test("Ui_BFu31ll");
    static STRUCT_IF_C Ui_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll, Ui_BFu31ll)
//============================================================================


struct  Ui_BFu31ll_BFu15i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu31ll_BFu15i) C1{ Fi FL:31 Fi:15}



static void Test_Ui_BFu31ll_BFu15i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu15i");
    static STRUCT_IF_C Ui_BFu31ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu15i, Ui_BFu31ll_BFu15i)
//============================================================================


struct  Ui_BFu31ll_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu31ll_BFu15ll) C1{ Fi FL:31 FL:15}



static void Test_Ui_BFu31ll_BFu15ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu15ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "Ui_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "Ui_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu15ll, Ui_BFu31ll_BFu15ll)
//============================================================================


struct  Ui_BFu31ll_BFu15s  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu31ll_BFu15s) C1{ Fi FL:31 Fs:15}



static void Test_Ui_BFu31ll_BFu15s()
{
  {
    init_simple_test("Ui_BFu31ll_BFu15s");
    static STRUCT_IF_C Ui_BFu31ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu15s, Ui_BFu31ll_BFu15s)
//============================================================================


struct  Ui_BFu31ll_BFu16i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu31ll_BFu16i) C1{ Fi FL:31 Fi:16}



static void Test_Ui_BFu31ll_BFu16i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu16i");
    static STRUCT_IF_C Ui_BFu31ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu16i, Ui_BFu31ll_BFu16i)
//============================================================================


struct  Ui_BFu31ll_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu31ll_BFu16ll) C1{ Fi FL:31 FL:16}



static void Test_Ui_BFu31ll_BFu16ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu16ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "Ui_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "Ui_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu16ll, Ui_BFu31ll_BFu16ll)
//============================================================================


struct  Ui_BFu31ll_BFu16s  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu31ll_BFu16s) C1{ Fi FL:31 Fs:16}



static void Test_Ui_BFu31ll_BFu16s()
{
  {
    init_simple_test("Ui_BFu31ll_BFu16s");
    static STRUCT_IF_C Ui_BFu31ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu16s, Ui_BFu31ll_BFu16s)
//============================================================================


struct  Ui_BFu31ll_BFu17i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu31ll_BFu17i) C1{ Fi FL:31 Fi:17}



static void Test_Ui_BFu31ll_BFu17i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu17i");
    static STRUCT_IF_C Ui_BFu31ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu17i, Ui_BFu31ll_BFu17i)
//============================================================================


struct  Ui_BFu31ll_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu31ll_BFu17ll) C1{ Fi FL:31 FL:17}



static void Test_Ui_BFu31ll_BFu17ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu17ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "Ui_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "Ui_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu17ll, Ui_BFu31ll_BFu17ll)
//============================================================================


struct  Ui_BFu31ll_BFu1c  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu31ll_BFu1c) C1{ Fi FL:31 Fc:1}



static void Test_Ui_BFu31ll_BFu1c()
{
  {
    init_simple_test("Ui_BFu31ll_BFu1c");
    static STRUCT_IF_C Ui_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Ui_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu1c, Ui_BFu31ll_BFu1c)
//============================================================================


struct  Ui_BFu31ll_BFu1i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu31ll_BFu1i) C1{ Fi FL:31 Fi:1}



static void Test_Ui_BFu31ll_BFu1i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu1i");
    static STRUCT_IF_C Ui_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Ui_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu1i, Ui_BFu31ll_BFu1i)
//============================================================================


struct  Ui_BFu31ll_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu31ll_BFu1ll) C1{ Fi FL:31 FL:1}



static void Test_Ui_BFu31ll_BFu1ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu1ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Ui_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu1ll, Ui_BFu31ll_BFu1ll)
//============================================================================


struct  Ui_BFu31ll_BFu1s  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu31ll_BFu1s) C1{ Fi FL:31 Fs:1}



static void Test_Ui_BFu31ll_BFu1s()
{
  {
    init_simple_test("Ui_BFu31ll_BFu1s");
    static STRUCT_IF_C Ui_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Ui_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu1s, Ui_BFu31ll_BFu1s)
//============================================================================


struct  Ui_BFu31ll_BFu31i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu31ll_BFu31i) C1{ Fi FL:31 Fi:31}



static void Test_Ui_BFu31ll_BFu31i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu31i");
    static STRUCT_IF_C Ui_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu31i, Ui_BFu31ll_BFu31i)
//============================================================================


struct  Ui_BFu31ll_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu31ll_BFu31ll) C1{ Fi FL:31 FL:31}



static void Test_Ui_BFu31ll_BFu31ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu31ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "Ui_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu31ll, Ui_BFu31ll_BFu31ll)
//============================================================================


struct  Ui_BFu31ll_BFu32i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu31ll_BFu32i) C1{ Fi FL:31 Fi:32}



static void Test_Ui_BFu31ll_BFu32i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu32i");
    static STRUCT_IF_C Ui_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu32i, Ui_BFu31ll_BFu32i)
//============================================================================


struct  Ui_BFu31ll_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu31ll_BFu32ll) C1{ Fi FL:31 FL:32}



static void Test_Ui_BFu31ll_BFu32ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu32ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "Ui_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu32ll, Ui_BFu31ll_BFu32ll)
//============================================================================


struct  Ui_BFu31ll_BFu33  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu31ll_BFu33) C1{ Fi FL:31 FL:33}



static void Test_Ui_BFu31ll_BFu33()
{
  {
    init_simple_test("Ui_BFu31ll_BFu33");
    static STRUCT_IF_C Ui_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "Ui_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu33, Ui_BFu31ll_BFu33)
//============================================================================


struct  Ui_BFu31ll_BFu7c  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu31ll_BFu7c) C1{ Fi FL:31 Fc:7}



static void Test_Ui_BFu31ll_BFu7c()
{
  {
    init_simple_test("Ui_BFu31ll_BFu7c");
    static STRUCT_IF_C Ui_BFu31ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu7c, Ui_BFu31ll_BFu7c)
//============================================================================


struct  Ui_BFu31ll_BFu7i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu31ll_BFu7i) C1{ Fi FL:31 Fi:7}



static void Test_Ui_BFu31ll_BFu7i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu7i");
    static STRUCT_IF_C Ui_BFu31ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu7i, Ui_BFu31ll_BFu7i)
//============================================================================


struct  Ui_BFu31ll_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu31ll_BFu7ll) C1{ Fi FL:31 FL:7}



static void Test_Ui_BFu31ll_BFu7ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu7ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "Ui_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "Ui_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu7ll, Ui_BFu31ll_BFu7ll)
//============================================================================


struct  Ui_BFu31ll_BFu7s  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu31ll_BFu7s) C1{ Fi FL:31 Fs:7}



static void Test_Ui_BFu31ll_BFu7s()
{
  {
    init_simple_test("Ui_BFu31ll_BFu7s");
    static STRUCT_IF_C Ui_BFu31ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu7s, Ui_BFu31ll_BFu7s)
//============================================================================


struct  Ui_BFu31ll_BFu8c  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu31ll_BFu8c) C1{ Fi FL:31 Fc:8}



static void Test_Ui_BFu31ll_BFu8c()
{
  {
    init_simple_test("Ui_BFu31ll_BFu8c");
    static STRUCT_IF_C Ui_BFu31ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu8c, Ui_BFu31ll_BFu8c)
//============================================================================


struct  Ui_BFu31ll_BFu8i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu31ll_BFu8i) C1{ Fi FL:31 Fi:8}



static void Test_Ui_BFu31ll_BFu8i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu8i");
    static STRUCT_IF_C Ui_BFu31ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu8i, Ui_BFu31ll_BFu8i)
//============================================================================


struct  Ui_BFu31ll_BFu8ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu31ll_BFu8ll) C1{ Fi FL:31 FL:8}



static void Test_Ui_BFu31ll_BFu8ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu8ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "Ui_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "Ui_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu8ll, Ui_BFu31ll_BFu8ll)
//============================================================================


struct  Ui_BFu31ll_BFu8s  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu31ll_BFu8s) C1{ Fi FL:31 Fs:8}



static void Test_Ui_BFu31ll_BFu8s()
{
  {
    init_simple_test("Ui_BFu31ll_BFu8s");
    static STRUCT_IF_C Ui_BFu31ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu8s, Ui_BFu31ll_BFu8s)
//============================================================================


struct  Ui_BFu31ll_BFu9i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu31ll_BFu9i) C1{ Fi FL:31 Fi:9}



static void Test_Ui_BFu31ll_BFu9i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu9i");
    static STRUCT_IF_C Ui_BFu31ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu9i, Ui_BFu31ll_BFu9i)
//============================================================================


struct  Ui_BFu31ll_BFu9ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu31ll_BFu9ll) C1{ Fi FL:31 FL:9}



static void Test_Ui_BFu31ll_BFu9ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu9ll");
    static STRUCT_IF_C Ui_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "Ui_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "Ui_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu9ll, Ui_BFu31ll_BFu9ll)
//============================================================================


struct  Ui_BFu31ll_BFu9s  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu31ll_BFu9s) C1{ Fi FL:31 Fs:9}



static void Test_Ui_BFu31ll_BFu9s()
{
  {
    init_simple_test("Ui_BFu31ll_BFu9s");
    static STRUCT_IF_C Ui_BFu31ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_BFu9s, Ui_BFu31ll_BFu9s)
//============================================================================


struct  Ui_BFu31ll_C  {
  unsigned int v1;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 Ui_BFu31ll_C) C1{ Fi FL:31 Fc}



static void Test_Ui_BFu31ll_C()
{
  {
    init_simple_test("Ui_BFu31ll_C");
    static STRUCT_IF_C Ui_BFu31ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_C");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_C, Ui_BFu31ll_C)
//============================================================================


struct  Ui_BFu31ll_D  {
  unsigned int v1;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 Ui_BFu31ll_D) C1{ Fi FL:31 FL}



static void Test_Ui_BFu31ll_D()
{
  {
    init_simple_test("Ui_BFu31ll_D");
    static STRUCT_IF_C Ui_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_D");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_D, Ui_BFu31ll_D)
//============================================================================


struct  Ui_BFu31ll_F  {
  unsigned int v1;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 Ui_BFu31ll_F) C1{ Fi FL:31 Fi}



static void Test_Ui_BFu31ll_F()
{
  {
    init_simple_test("Ui_BFu31ll_F");
    static STRUCT_IF_C Ui_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_F");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_F, Ui_BFu31ll_F)
//============================================================================


struct  Ui_BFu31ll_I  {
  unsigned int v1;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 Ui_BFu31ll_I) C1{ Fi FL:31 Fi}



static void Test_Ui_BFu31ll_I()
{
  {
    init_simple_test("Ui_BFu31ll_I");
    static STRUCT_IF_C Ui_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_I");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_I, Ui_BFu31ll_I)
//============================================================================


struct  Ui_BFu31ll_Ip  {
  unsigned int v1;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 Ui_BFu31ll_Ip) C1{ Fi FL:31 Fp}



static void Test_Ui_BFu31ll_Ip()
{
  {
    init_simple_test("Ui_BFu31ll_Ip");
    static STRUCT_IF_C Ui_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_Ip, Ui_BFu31ll_Ip)
//============================================================================


struct  Ui_BFu31ll_L  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 Ui_BFu31ll_L) C1{ Fi FL:31 FL}



static void Test_Ui_BFu31ll_L()
{
  {
    init_simple_test("Ui_BFu31ll_L");
    static STRUCT_IF_C Ui_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_L");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_L, Ui_BFu31ll_L)
//============================================================================


struct  Ui_BFu31ll_S  {
  unsigned int v1;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 Ui_BFu31ll_S) C1{ Fi FL:31 Fs}



static void Test_Ui_BFu31ll_S()
{
  {
    init_simple_test("Ui_BFu31ll_S");
    static STRUCT_IF_C Ui_BFu31ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_S");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_S, Ui_BFu31ll_S)
//============================================================================


struct  Ui_BFu31ll_Uc  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 Ui_BFu31ll_Uc) C1{ Fi FL:31 Fc}



static void Test_Ui_BFu31ll_Uc()
{
  {
    init_simple_test("Ui_BFu31ll_Uc");
    static STRUCT_IF_C Ui_BFu31ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_Uc");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_Uc, Ui_BFu31ll_Uc)
//============================================================================


struct  Ui_BFu31ll_Ui  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 Ui_BFu31ll_Ui) C1{ Fi FL:31 Fi}



static void Test_Ui_BFu31ll_Ui()
{
  {
    init_simple_test("Ui_BFu31ll_Ui");
    static STRUCT_IF_C Ui_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_Ui, Ui_BFu31ll_Ui)
//============================================================================


struct  Ui_BFu31ll_Ul  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 Ui_BFu31ll_Ul) C1{ Fi FL:31 FL}



static void Test_Ui_BFu31ll_Ul()
{
  {
    init_simple_test("Ui_BFu31ll_Ul");
    static STRUCT_IF_C Ui_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_Ul, Ui_BFu31ll_Ul)
//============================================================================


struct  Ui_BFu31ll_Us  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 Ui_BFu31ll_Us) C1{ Fi FL:31 Fs}



static void Test_Ui_BFu31ll_Us()
{
  {
    init_simple_test("Ui_BFu31ll_Us");
    static STRUCT_IF_C Ui_BFu31ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_Us");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_Us, Ui_BFu31ll_Us)
//============================================================================


struct  Ui_BFu31ll_Vp  {
  unsigned int v1;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 Ui_BFu31ll_Vp) C1{ Fi FL:31 Fp}



static void Test_Ui_BFu31ll_Vp()
{
  {
    init_simple_test("Ui_BFu31ll_Vp");
    static STRUCT_IF_C Ui_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu31ll_Vp, Ui_BFu31ll_Vp)
//============================================================================


struct  Ui_BFu32i  {
  unsigned int v1;
  unsigned int v2:32;
};
//SIG(1 Ui_BFu32i) C1{ Fi Fi:32}



static void Test_Ui_BFu32i()
{
  {
    init_simple_test("Ui_BFu32i");
    static STRUCT_IF_C Ui_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i, Ui_BFu32i)
//============================================================================


struct  Ui_BFu32i_BFu15i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu32i_BFu15i) C1{ Fi Fi:32 Fi:15}



static void Test_Ui_BFu32i_BFu15i()
{
  {
    init_simple_test("Ui_BFu32i_BFu15i");
    static STRUCT_IF_C Ui_BFu32i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu15i, Ui_BFu32i_BFu15i)
//============================================================================


struct  Ui_BFu32i_BFu15ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu32i_BFu15ll) C1{ Fi Fi:32 FL:15}



static void Test_Ui_BFu32i_BFu15ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu15ll");
    static STRUCT_IF_C Ui_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu15ll, Ui_BFu32i_BFu15ll)
//============================================================================


struct  Ui_BFu32i_BFu15s  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu32i_BFu15s) C1{ Fi Fi:32 Fs:15}



static void Test_Ui_BFu32i_BFu15s()
{
  {
    init_simple_test("Ui_BFu32i_BFu15s");
    static STRUCT_IF_C Ui_BFu32i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu15s, Ui_BFu32i_BFu15s)
//============================================================================


struct  Ui_BFu32i_BFu16i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu32i_BFu16i) C1{ Fi Fi:32 Fi:16}



static void Test_Ui_BFu32i_BFu16i()
{
  {
    init_simple_test("Ui_BFu32i_BFu16i");
    static STRUCT_IF_C Ui_BFu32i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu16i, Ui_BFu32i_BFu16i)
//============================================================================


struct  Ui_BFu32i_BFu16ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu32i_BFu16ll) C1{ Fi Fi:32 FL:16}



static void Test_Ui_BFu32i_BFu16ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu16ll");
    static STRUCT_IF_C Ui_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu16ll, Ui_BFu32i_BFu16ll)
//============================================================================


struct  Ui_BFu32i_BFu16s  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu32i_BFu16s) C1{ Fi Fi:32 Fs:16}



static void Test_Ui_BFu32i_BFu16s()
{
  {
    init_simple_test("Ui_BFu32i_BFu16s");
    static STRUCT_IF_C Ui_BFu32i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu16s, Ui_BFu32i_BFu16s)
//============================================================================


struct  Ui_BFu32i_BFu17i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu32i_BFu17i) C1{ Fi Fi:32 Fi:17}



static void Test_Ui_BFu32i_BFu17i()
{
  {
    init_simple_test("Ui_BFu32i_BFu17i");
    static STRUCT_IF_C Ui_BFu32i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu17i, Ui_BFu32i_BFu17i)
//============================================================================


struct  Ui_BFu32i_BFu17ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu32i_BFu17ll) C1{ Fi Fi:32 FL:17}



static void Test_Ui_BFu32i_BFu17ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu17ll");
    static STRUCT_IF_C Ui_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu17ll, Ui_BFu32i_BFu17ll)
//============================================================================


struct  Ui_BFu32i_BFu1c  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu32i_BFu1c) C1{ Fi Fi:32 Fc:1}



static void Test_Ui_BFu32i_BFu1c()
{
  {
    init_simple_test("Ui_BFu32i_BFu1c");
    static STRUCT_IF_C Ui_BFu32i_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Ui_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu1c, Ui_BFu32i_BFu1c)
//============================================================================


struct  Ui_BFu32i_BFu1i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu32i_BFu1i) C1{ Fi Fi:32 Fi:1}



static void Test_Ui_BFu32i_BFu1i()
{
  {
    init_simple_test("Ui_BFu32i_BFu1i");
    static STRUCT_IF_C Ui_BFu32i_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Ui_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu1i, Ui_BFu32i_BFu1i)
//============================================================================


struct  Ui_BFu32i_BFu1ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu32i_BFu1ll) C1{ Fi Fi:32 FL:1}



static void Test_Ui_BFu32i_BFu1ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu1ll");
    static STRUCT_IF_C Ui_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Ui_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu1ll, Ui_BFu32i_BFu1ll)
//============================================================================


struct  Ui_BFu32i_BFu1s  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu32i_BFu1s) C1{ Fi Fi:32 Fs:1}



static void Test_Ui_BFu32i_BFu1s()
{
  {
    init_simple_test("Ui_BFu32i_BFu1s");
    static STRUCT_IF_C Ui_BFu32i_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Ui_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu1s, Ui_BFu32i_BFu1s)
//============================================================================


struct  Ui_BFu32i_BFu31i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu32i_BFu31i) C1{ Fi Fi:32 Fi:31}



static void Test_Ui_BFu32i_BFu31i()
{
  {
    init_simple_test("Ui_BFu32i_BFu31i");
    static STRUCT_IF_C Ui_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu31i, Ui_BFu32i_BFu31i)
//============================================================================


struct  Ui_BFu32i_BFu31ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu32i_BFu31ll) C1{ Fi Fi:32 FL:31}



static void Test_Ui_BFu32i_BFu31ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu31ll");
    static STRUCT_IF_C Ui_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu31ll, Ui_BFu32i_BFu31ll)
//============================================================================


struct  Ui_BFu32i_BFu32i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu32i_BFu32i) C1{ Fi Fi:32 Fi:32}



static void Test_Ui_BFu32i_BFu32i()
{
  {
    init_simple_test("Ui_BFu32i_BFu32i");
    static STRUCT_IF_C Ui_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu32i, Ui_BFu32i_BFu32i)
//============================================================================


struct  Ui_BFu32i_BFu32ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu32i_BFu32ll) C1{ Fi Fi:32 FL:32}



static void Test_Ui_BFu32i_BFu32ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu32ll");
    static STRUCT_IF_C Ui_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu32ll, Ui_BFu32i_BFu32ll)
//============================================================================


struct  Ui_BFu32i_BFu33  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu32i_BFu33) C1{ Fi Fi:32 FL:33}



static void Test_Ui_BFu32i_BFu33()
{
  {
    init_simple_test("Ui_BFu32i_BFu33");
    static STRUCT_IF_C Ui_BFu32i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "Ui_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "Ui_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu33, Ui_BFu32i_BFu33)
//============================================================================


struct  Ui_BFu32i_BFu7c  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu32i_BFu7c) C1{ Fi Fi:32 Fc:7}



static void Test_Ui_BFu32i_BFu7c()
{
  {
    init_simple_test("Ui_BFu32i_BFu7c");
    static STRUCT_IF_C Ui_BFu32i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu7c, Ui_BFu32i_BFu7c)
//============================================================================


struct  Ui_BFu32i_BFu7i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu32i_BFu7i) C1{ Fi Fi:32 Fi:7}



static void Test_Ui_BFu32i_BFu7i()
{
  {
    init_simple_test("Ui_BFu32i_BFu7i");
    static STRUCT_IF_C Ui_BFu32i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu7i, Ui_BFu32i_BFu7i)
//============================================================================


struct  Ui_BFu32i_BFu7ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu32i_BFu7ll) C1{ Fi Fi:32 FL:7}



static void Test_Ui_BFu32i_BFu7ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu7ll");
    static STRUCT_IF_C Ui_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu7ll, Ui_BFu32i_BFu7ll)
//============================================================================


struct  Ui_BFu32i_BFu7s  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu32i_BFu7s) C1{ Fi Fi:32 Fs:7}



static void Test_Ui_BFu32i_BFu7s()
{
  {
    init_simple_test("Ui_BFu32i_BFu7s");
    static STRUCT_IF_C Ui_BFu32i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu7s, Ui_BFu32i_BFu7s)
//============================================================================


struct  Ui_BFu32i_BFu8c  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu32i_BFu8c) C1{ Fi Fi:32 Fc:8}



static void Test_Ui_BFu32i_BFu8c()
{
  {
    init_simple_test("Ui_BFu32i_BFu8c");
    static STRUCT_IF_C Ui_BFu32i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu8c, Ui_BFu32i_BFu8c)
//============================================================================


struct  Ui_BFu32i_BFu8i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu32i_BFu8i) C1{ Fi Fi:32 Fi:8}



static void Test_Ui_BFu32i_BFu8i()
{
  {
    init_simple_test("Ui_BFu32i_BFu8i");
    static STRUCT_IF_C Ui_BFu32i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu8i, Ui_BFu32i_BFu8i)
//============================================================================


struct  Ui_BFu32i_BFu8ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu32i_BFu8ll) C1{ Fi Fi:32 FL:8}



static void Test_Ui_BFu32i_BFu8ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu8ll");
    static STRUCT_IF_C Ui_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu8ll, Ui_BFu32i_BFu8ll)
//============================================================================


struct  Ui_BFu32i_BFu8s  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu32i_BFu8s) C1{ Fi Fi:32 Fs:8}



static void Test_Ui_BFu32i_BFu8s()
{
  {
    init_simple_test("Ui_BFu32i_BFu8s");
    static STRUCT_IF_C Ui_BFu32i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu8s, Ui_BFu32i_BFu8s)
//============================================================================


struct  Ui_BFu32i_BFu9i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu32i_BFu9i) C1{ Fi Fi:32 Fi:9}



static void Test_Ui_BFu32i_BFu9i()
{
  {
    init_simple_test("Ui_BFu32i_BFu9i");
    static STRUCT_IF_C Ui_BFu32i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu9i, Ui_BFu32i_BFu9i)
//============================================================================


struct  Ui_BFu32i_BFu9ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu32i_BFu9ll) C1{ Fi Fi:32 FL:9}



static void Test_Ui_BFu32i_BFu9ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu9ll");
    static STRUCT_IF_C Ui_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu9ll, Ui_BFu32i_BFu9ll)
//============================================================================


struct  Ui_BFu32i_BFu9s  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu32i_BFu9s) C1{ Fi Fi:32 Fs:9}



static void Test_Ui_BFu32i_BFu9s()
{
  {
    init_simple_test("Ui_BFu32i_BFu9s");
    static STRUCT_IF_C Ui_BFu32i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_BFu9s, Ui_BFu32i_BFu9s)
//============================================================================


struct  Ui_BFu32i_C  {
  unsigned int v1;
  unsigned int v2:32;
  char v3;
};
//SIG(1 Ui_BFu32i_C) C1{ Fi Fi:32 Fc}



static void Test_Ui_BFu32i_C()
{
  {
    init_simple_test("Ui_BFu32i_C");
    static STRUCT_IF_C Ui_BFu32i_C lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_C");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_C, Ui_BFu32i_C)
//============================================================================


struct  Ui_BFu32i_D  {
  unsigned int v1;
  unsigned int v2:32;
  double v3;
};
//SIG(1 Ui_BFu32i_D) C1{ Fi Fi:32 FL}



static void Test_Ui_BFu32i_D()
{
  {
    init_simple_test("Ui_BFu32i_D");
    static STRUCT_IF_C Ui_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_D");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_D, Ui_BFu32i_D)
//============================================================================


struct  Ui_BFu32i_F  {
  unsigned int v1;
  unsigned int v2:32;
  float v3;
};
//SIG(1 Ui_BFu32i_F) C1{ Fi Fi:32 Fi}



static void Test_Ui_BFu32i_F()
{
  {
    init_simple_test("Ui_BFu32i_F");
    static STRUCT_IF_C Ui_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_F");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_F, Ui_BFu32i_F)
//============================================================================


struct  Ui_BFu32i_I  {
  unsigned int v1;
  unsigned int v2:32;
  int v3;
};
//SIG(1 Ui_BFu32i_I) C1{ Fi Fi:32 Fi}



static void Test_Ui_BFu32i_I()
{
  {
    init_simple_test("Ui_BFu32i_I");
    static STRUCT_IF_C Ui_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_I");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_I, Ui_BFu32i_I)
//============================================================================


struct  Ui_BFu32i_Ip  {
  unsigned int v1;
  unsigned int v2:32;
  int *v3;
};
//SIG(1 Ui_BFu32i_Ip) C1{ Fi Fi:32 Fp}



static void Test_Ui_BFu32i_Ip()
{
  {
    init_simple_test("Ui_BFu32i_Ip");
    static STRUCT_IF_C Ui_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_Ip, Ui_BFu32i_Ip)
//============================================================================


struct  Ui_BFu32i_L  {
  unsigned int v1;
  unsigned int v2:32;
  __tsi64 v3;
};
//SIG(1 Ui_BFu32i_L) C1{ Fi Fi:32 FL}



static void Test_Ui_BFu32i_L()
{
  {
    init_simple_test("Ui_BFu32i_L");
    static STRUCT_IF_C Ui_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_L");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_L, Ui_BFu32i_L)
//============================================================================


struct  Ui_BFu32i_S  {
  unsigned int v1;
  unsigned int v2:32;
  short v3;
};
//SIG(1 Ui_BFu32i_S) C1{ Fi Fi:32 Fs}



static void Test_Ui_BFu32i_S()
{
  {
    init_simple_test("Ui_BFu32i_S");
    static STRUCT_IF_C Ui_BFu32i_S lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_S");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_S, Ui_BFu32i_S)
//============================================================================


struct  Ui_BFu32i_Uc  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned char v3;
};
//SIG(1 Ui_BFu32i_Uc) C1{ Fi Fi:32 Fc}



static void Test_Ui_BFu32i_Uc()
{
  {
    init_simple_test("Ui_BFu32i_Uc");
    static STRUCT_IF_C Ui_BFu32i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_Uc, Ui_BFu32i_Uc)
//============================================================================


struct  Ui_BFu32i_Ui  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int v3;
};
//SIG(1 Ui_BFu32i_Ui) C1{ Fi Fi:32 Fi}



static void Test_Ui_BFu32i_Ui()
{
  {
    init_simple_test("Ui_BFu32i_Ui");
    static STRUCT_IF_C Ui_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_Ui, Ui_BFu32i_Ui)
//============================================================================


struct  Ui_BFu32i_Ul  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64 v3;
};
//SIG(1 Ui_BFu32i_Ul) C1{ Fi Fi:32 FL}



static void Test_Ui_BFu32i_Ul()
{
  {
    init_simple_test("Ui_BFu32i_Ul");
    static STRUCT_IF_C Ui_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_Ul, Ui_BFu32i_Ul)
//============================================================================


struct  Ui_BFu32i_Us  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned short v3;
};
//SIG(1 Ui_BFu32i_Us) C1{ Fi Fi:32 Fs}



static void Test_Ui_BFu32i_Us()
{
  {
    init_simple_test("Ui_BFu32i_Us");
    static STRUCT_IF_C Ui_BFu32i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu32i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_Us");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_Us, Ui_BFu32i_Us)
//============================================================================


struct  Ui_BFu32i_Vp  {
  unsigned int v1;
  unsigned int v2:32;
  void *v3;
};
//SIG(1 Ui_BFu32i_Vp) C1{ Fi Fi:32 Fp}



static void Test_Ui_BFu32i_Vp()
{
  {
    init_simple_test("Ui_BFu32i_Vp");
    static STRUCT_IF_C Ui_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32i_Vp, Ui_BFu32i_Vp)
//============================================================================


struct  Ui_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:32;
};
//SIG(1 Ui_BFu32ll) C1{ Fi FL:32}



static void Test_Ui_BFu32ll()
{
  {
    init_simple_test("Ui_BFu32ll");
    static STRUCT_IF_C Ui_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll, Ui_BFu32ll)
//============================================================================


struct  Ui_BFu32ll_BFu15i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu32ll_BFu15i) C1{ Fi FL:32 Fi:15}



static void Test_Ui_BFu32ll_BFu15i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu15i");
    static STRUCT_IF_C Ui_BFu32ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu15i, Ui_BFu32ll_BFu15i)
//============================================================================


struct  Ui_BFu32ll_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu32ll_BFu15ll) C1{ Fi FL:32 FL:15}



static void Test_Ui_BFu32ll_BFu15ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu15ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu15ll, Ui_BFu32ll_BFu15ll)
//============================================================================


struct  Ui_BFu32ll_BFu15s  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu32ll_BFu15s) C1{ Fi FL:32 Fs:15}



static void Test_Ui_BFu32ll_BFu15s()
{
  {
    init_simple_test("Ui_BFu32ll_BFu15s");
    static STRUCT_IF_C Ui_BFu32ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Ui_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Ui_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu15s, Ui_BFu32ll_BFu15s)
//============================================================================


struct  Ui_BFu32ll_BFu16i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu32ll_BFu16i) C1{ Fi FL:32 Fi:16}



static void Test_Ui_BFu32ll_BFu16i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu16i");
    static STRUCT_IF_C Ui_BFu32ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu16i, Ui_BFu32ll_BFu16i)
//============================================================================


struct  Ui_BFu32ll_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu32ll_BFu16ll) C1{ Fi FL:32 FL:16}



static void Test_Ui_BFu32ll_BFu16ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu16ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu16ll, Ui_BFu32ll_BFu16ll)
//============================================================================


struct  Ui_BFu32ll_BFu16s  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu32ll_BFu16s) C1{ Fi FL:32 Fs:16}



static void Test_Ui_BFu32ll_BFu16s()
{
  {
    init_simple_test("Ui_BFu32ll_BFu16s");
    static STRUCT_IF_C Ui_BFu32ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Ui_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Ui_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu16s, Ui_BFu32ll_BFu16s)
//============================================================================


struct  Ui_BFu32ll_BFu17i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu32ll_BFu17i) C1{ Fi FL:32 Fi:17}



static void Test_Ui_BFu32ll_BFu17i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu17i");
    static STRUCT_IF_C Ui_BFu32ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu17i, Ui_BFu32ll_BFu17i)
//============================================================================


struct  Ui_BFu32ll_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu32ll_BFu17ll) C1{ Fi FL:32 FL:17}



static void Test_Ui_BFu32ll_BFu17ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu17ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Ui_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Ui_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu17ll, Ui_BFu32ll_BFu17ll)
//============================================================================


struct  Ui_BFu32ll_BFu1c  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu32ll_BFu1c) C1{ Fi FL:32 Fc:1}



static void Test_Ui_BFu32ll_BFu1c()
{
  {
    init_simple_test("Ui_BFu32ll_BFu1c");
    static STRUCT_IF_C Ui_BFu32ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Ui_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu1c, Ui_BFu32ll_BFu1c)
//============================================================================


struct  Ui_BFu32ll_BFu1i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu32ll_BFu1i) C1{ Fi FL:32 Fi:1}



static void Test_Ui_BFu32ll_BFu1i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu1i");
    static STRUCT_IF_C Ui_BFu32ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Ui_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu1i, Ui_BFu32ll_BFu1i)
//============================================================================


struct  Ui_BFu32ll_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu32ll_BFu1ll) C1{ Fi FL:32 FL:1}



static void Test_Ui_BFu32ll_BFu1ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu1ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Ui_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu1ll, Ui_BFu32ll_BFu1ll)
//============================================================================


struct  Ui_BFu32ll_BFu1s  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu32ll_BFu1s) C1{ Fi FL:32 Fs:1}



static void Test_Ui_BFu32ll_BFu1s()
{
  {
    init_simple_test("Ui_BFu32ll_BFu1s");
    static STRUCT_IF_C Ui_BFu32ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Ui_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu1s, Ui_BFu32ll_BFu1s)
//============================================================================


struct  Ui_BFu32ll_BFu31i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu32ll_BFu31i) C1{ Fi FL:32 Fi:31}



static void Test_Ui_BFu32ll_BFu31i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu31i");
    static STRUCT_IF_C Ui_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu31i, Ui_BFu32ll_BFu31i)
//============================================================================


struct  Ui_BFu32ll_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu32ll_BFu31ll) C1{ Fi FL:32 FL:31}



static void Test_Ui_BFu32ll_BFu31ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu31ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu31ll, Ui_BFu32ll_BFu31ll)
//============================================================================


struct  Ui_BFu32ll_BFu32i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu32ll_BFu32i) C1{ Fi FL:32 Fi:32}



static void Test_Ui_BFu32ll_BFu32i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu32i");
    static STRUCT_IF_C Ui_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu32i, Ui_BFu32ll_BFu32i)
//============================================================================


struct  Ui_BFu32ll_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu32ll_BFu32ll) C1{ Fi FL:32 FL:32}



static void Test_Ui_BFu32ll_BFu32ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu32ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu32ll, Ui_BFu32ll_BFu32ll)
//============================================================================


struct  Ui_BFu32ll_BFu33  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu32ll_BFu33) C1{ Fi FL:32 FL:33}



static void Test_Ui_BFu32ll_BFu33()
{
  {
    init_simple_test("Ui_BFu32ll_BFu33");
    static STRUCT_IF_C Ui_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "Ui_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "Ui_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu33, Ui_BFu32ll_BFu33)
//============================================================================


struct  Ui_BFu32ll_BFu7c  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu32ll_BFu7c) C1{ Fi FL:32 Fc:7}



static void Test_Ui_BFu32ll_BFu7c()
{
  {
    init_simple_test("Ui_BFu32ll_BFu7c");
    static STRUCT_IF_C Ui_BFu32ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu7c, Ui_BFu32ll_BFu7c)
//============================================================================


struct  Ui_BFu32ll_BFu7i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu32ll_BFu7i) C1{ Fi FL:32 Fi:7}



static void Test_Ui_BFu32ll_BFu7i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu7i");
    static STRUCT_IF_C Ui_BFu32ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu7i, Ui_BFu32ll_BFu7i)
//============================================================================


struct  Ui_BFu32ll_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu32ll_BFu7ll) C1{ Fi FL:32 FL:7}



static void Test_Ui_BFu32ll_BFu7ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu7ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu7ll, Ui_BFu32ll_BFu7ll)
//============================================================================


struct  Ui_BFu32ll_BFu7s  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu32ll_BFu7s) C1{ Fi FL:32 Fs:7}



static void Test_Ui_BFu32ll_BFu7s()
{
  {
    init_simple_test("Ui_BFu32ll_BFu7s");
    static STRUCT_IF_C Ui_BFu32ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Ui_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Ui_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu7s, Ui_BFu32ll_BFu7s)
//============================================================================


struct  Ui_BFu32ll_BFu8c  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu32ll_BFu8c) C1{ Fi FL:32 Fc:8}



static void Test_Ui_BFu32ll_BFu8c()
{
  {
    init_simple_test("Ui_BFu32ll_BFu8c");
    static STRUCT_IF_C Ui_BFu32ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu8c, Ui_BFu32ll_BFu8c)
//============================================================================


struct  Ui_BFu32ll_BFu8i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu32ll_BFu8i) C1{ Fi FL:32 Fi:8}



static void Test_Ui_BFu32ll_BFu8i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu8i");
    static STRUCT_IF_C Ui_BFu32ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu8i, Ui_BFu32ll_BFu8i)
//============================================================================


struct  Ui_BFu32ll_BFu8ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu32ll_BFu8ll) C1{ Fi FL:32 FL:8}



static void Test_Ui_BFu32ll_BFu8ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu8ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu8ll, Ui_BFu32ll_BFu8ll)
//============================================================================


struct  Ui_BFu32ll_BFu8s  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu32ll_BFu8s) C1{ Fi FL:32 Fs:8}



static void Test_Ui_BFu32ll_BFu8s()
{
  {
    init_simple_test("Ui_BFu32ll_BFu8s");
    static STRUCT_IF_C Ui_BFu32ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Ui_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Ui_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu8s, Ui_BFu32ll_BFu8s)
//============================================================================


struct  Ui_BFu32ll_BFu9i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu32ll_BFu9i) C1{ Fi FL:32 Fi:9}



static void Test_Ui_BFu32ll_BFu9i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu9i");
    static STRUCT_IF_C Ui_BFu32ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu9i, Ui_BFu32ll_BFu9i)
//============================================================================


struct  Ui_BFu32ll_BFu9ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu32ll_BFu9ll) C1{ Fi FL:32 FL:9}



static void Test_Ui_BFu32ll_BFu9ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu9ll");
    static STRUCT_IF_C Ui_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu9ll, Ui_BFu32ll_BFu9ll)
//============================================================================


struct  Ui_BFu32ll_BFu9s  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu32ll_BFu9s) C1{ Fi FL:32 Fs:9}



static void Test_Ui_BFu32ll_BFu9s()
{
  {
    init_simple_test("Ui_BFu32ll_BFu9s");
    static STRUCT_IF_C Ui_BFu32ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Ui_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Ui_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_BFu9s, Ui_BFu32ll_BFu9s)
//============================================================================


struct  Ui_BFu32ll_C  {
  unsigned int v1;
  __tsu64 v2:32;
  char v3;
};
//SIG(1 Ui_BFu32ll_C) C1{ Fi FL:32 Fc}



static void Test_Ui_BFu32ll_C()
{
  {
    init_simple_test("Ui_BFu32ll_C");
    static STRUCT_IF_C Ui_BFu32ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_C");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_C, Ui_BFu32ll_C)
//============================================================================


struct  Ui_BFu32ll_D  {
  unsigned int v1;
  __tsu64 v2:32;
  double v3;
};
//SIG(1 Ui_BFu32ll_D) C1{ Fi FL:32 FL}



static void Test_Ui_BFu32ll_D()
{
  {
    init_simple_test("Ui_BFu32ll_D");
    static STRUCT_IF_C Ui_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_D");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_D, Ui_BFu32ll_D)
//============================================================================


struct  Ui_BFu32ll_F  {
  unsigned int v1;
  __tsu64 v2:32;
  float v3;
};
//SIG(1 Ui_BFu32ll_F) C1{ Fi FL:32 Fi}



static void Test_Ui_BFu32ll_F()
{
  {
    init_simple_test("Ui_BFu32ll_F");
    static STRUCT_IF_C Ui_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_F");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_F, Ui_BFu32ll_F)
//============================================================================


struct  Ui_BFu32ll_I  {
  unsigned int v1;
  __tsu64 v2:32;
  int v3;
};
//SIG(1 Ui_BFu32ll_I) C1{ Fi FL:32 Fi}



static void Test_Ui_BFu32ll_I()
{
  {
    init_simple_test("Ui_BFu32ll_I");
    static STRUCT_IF_C Ui_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_I");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_I, Ui_BFu32ll_I)
//============================================================================


struct  Ui_BFu32ll_Ip  {
  unsigned int v1;
  __tsu64 v2:32;
  int *v3;
};
//SIG(1 Ui_BFu32ll_Ip) C1{ Fi FL:32 Fp}



static void Test_Ui_BFu32ll_Ip()
{
  {
    init_simple_test("Ui_BFu32ll_Ip");
    static STRUCT_IF_C Ui_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_Ip, Ui_BFu32ll_Ip)
//============================================================================


struct  Ui_BFu32ll_L  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsi64 v3;
};
//SIG(1 Ui_BFu32ll_L) C1{ Fi FL:32 FL}



static void Test_Ui_BFu32ll_L()
{
  {
    init_simple_test("Ui_BFu32ll_L");
    static STRUCT_IF_C Ui_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_L");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_L, Ui_BFu32ll_L)
//============================================================================


struct  Ui_BFu32ll_S  {
  unsigned int v1;
  __tsu64 v2:32;
  short v3;
};
//SIG(1 Ui_BFu32ll_S) C1{ Fi FL:32 Fs}



static void Test_Ui_BFu32ll_S()
{
  {
    init_simple_test("Ui_BFu32ll_S");
    static STRUCT_IF_C Ui_BFu32ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_S");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_S, Ui_BFu32ll_S)
//============================================================================


struct  Ui_BFu32ll_Uc  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned char v3;
};
//SIG(1 Ui_BFu32ll_Uc) C1{ Fi FL:32 Fc}



static void Test_Ui_BFu32ll_Uc()
{
  {
    init_simple_test("Ui_BFu32ll_Uc");
    static STRUCT_IF_C Ui_BFu32ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_Uc");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_Uc, Ui_BFu32ll_Uc)
//============================================================================


struct  Ui_BFu32ll_Ui  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int v3;
};
//SIG(1 Ui_BFu32ll_Ui) C1{ Fi FL:32 Fi}



static void Test_Ui_BFu32ll_Ui()
{
  {
    init_simple_test("Ui_BFu32ll_Ui");
    static STRUCT_IF_C Ui_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_Ui, Ui_BFu32ll_Ui)
//============================================================================


struct  Ui_BFu32ll_Ul  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64 v3;
};
//SIG(1 Ui_BFu32ll_Ul) C1{ Fi FL:32 FL}



static void Test_Ui_BFu32ll_Ul()
{
  {
    init_simple_test("Ui_BFu32ll_Ul");
    static STRUCT_IF_C Ui_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_Ul, Ui_BFu32ll_Ul)
//============================================================================


struct  Ui_BFu32ll_Us  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned short v3;
};
//SIG(1 Ui_BFu32ll_Us) C1{ Fi FL:32 Fs}



static void Test_Ui_BFu32ll_Us()
{
  {
    init_simple_test("Ui_BFu32ll_Us");
    static STRUCT_IF_C Ui_BFu32ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_Us");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_Us, Ui_BFu32ll_Us)
//============================================================================


struct  Ui_BFu32ll_Vp  {
  unsigned int v1;
  __tsu64 v2:32;
  void *v3;
};
//SIG(1 Ui_BFu32ll_Vp) C1{ Fi FL:32 Fp}



static void Test_Ui_BFu32ll_Vp()
{
  {
    init_simple_test("Ui_BFu32ll_Vp");
    static STRUCT_IF_C Ui_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu32ll_Vp, Ui_BFu32ll_Vp)
//============================================================================


struct  Ui_BFu33  {
  unsigned int v1;
  __tsu64 v2:33;
};
//SIG(1 Ui_BFu33) C1{ Fi FL:33}



static void Test_Ui_BFu33()
{
  {
    init_simple_test("Ui_BFu33");
    static STRUCT_IF_C Ui_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33, Ui_BFu33)
//============================================================================


struct  Ui_BFu33_BFu15i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu33_BFu15i) C1{ Fi FL:33 Fi:15}



static void Test_Ui_BFu33_BFu15i()
{
  {
    init_simple_test("Ui_BFu33_BFu15i");
    static STRUCT_IF_C Ui_BFu33_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Ui_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Ui_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu15i, Ui_BFu33_BFu15i)
//============================================================================


struct  Ui_BFu33_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu33_BFu15ll) C1{ Fi FL:33 FL:15}



static void Test_Ui_BFu33_BFu15ll()
{
  {
    init_simple_test("Ui_BFu33_BFu15ll");
    static STRUCT_IF_C Ui_BFu33_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Ui_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Ui_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu15ll, Ui_BFu33_BFu15ll)
//============================================================================


struct  Ui_BFu33_BFu15s  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu33_BFu15s) C1{ Fi FL:33 Fs:15}



static void Test_Ui_BFu33_BFu15s()
{
  {
    init_simple_test("Ui_BFu33_BFu15s");
    static STRUCT_IF_C Ui_BFu33_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Ui_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Ui_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu15s, Ui_BFu33_BFu15s)
//============================================================================


struct  Ui_BFu33_BFu16i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu33_BFu16i) C1{ Fi FL:33 Fi:16}



static void Test_Ui_BFu33_BFu16i()
{
  {
    init_simple_test("Ui_BFu33_BFu16i");
    static STRUCT_IF_C Ui_BFu33_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "Ui_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "Ui_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu16i, Ui_BFu33_BFu16i)
//============================================================================


struct  Ui_BFu33_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu33_BFu16ll) C1{ Fi FL:33 FL:16}



static void Test_Ui_BFu33_BFu16ll()
{
  {
    init_simple_test("Ui_BFu33_BFu16ll");
    static STRUCT_IF_C Ui_BFu33_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "Ui_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "Ui_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu16ll, Ui_BFu33_BFu16ll)
//============================================================================


struct  Ui_BFu33_BFu16s  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu33_BFu16s) C1{ Fi FL:33 Fs:16}



static void Test_Ui_BFu33_BFu16s()
{
  {
    init_simple_test("Ui_BFu33_BFu16s");
    static STRUCT_IF_C Ui_BFu33_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(14,10), 0, 16, 1, "Ui_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(14,10), 0, 16, hide_ull(1LL<<15), "Ui_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu16s, Ui_BFu33_BFu16s)
//============================================================================


struct  Ui_BFu33_BFu17i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu33_BFu17i) C1{ Fi FL:33 Fi:17}



static void Test_Ui_BFu33_BFu17i()
{
  {
    init_simple_test("Ui_BFu33_BFu17i");
    static STRUCT_IF_C Ui_BFu33_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "Ui_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "Ui_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu17i, Ui_BFu33_BFu17i)
//============================================================================


struct  Ui_BFu33_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu33_BFu17ll) C1{ Fi FL:33 FL:17}



static void Test_Ui_BFu33_BFu17ll()
{
  {
    init_simple_test("Ui_BFu33_BFu17ll");
    static STRUCT_IF_C Ui_BFu33_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "Ui_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "Ui_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu17ll, Ui_BFu33_BFu17ll)
//============================================================================


struct  Ui_BFu33_BFu1c  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu33_BFu1c) C1{ Fi FL:33 Fc:1}



static void Test_Ui_BFu33_BFu1c()
{
  {
    init_simple_test("Ui_BFu33_BFu1c");
    static STRUCT_IF_C Ui_BFu33_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Ui_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu1c, Ui_BFu33_BFu1c)
//============================================================================


struct  Ui_BFu33_BFu1i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu33_BFu1i) C1{ Fi FL:33 Fi:1}



static void Test_Ui_BFu33_BFu1i()
{
  {
    init_simple_test("Ui_BFu33_BFu1i");
    static STRUCT_IF_C Ui_BFu33_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Ui_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu1i, Ui_BFu33_BFu1i)
//============================================================================


struct  Ui_BFu33_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu33_BFu1ll) C1{ Fi FL:33 FL:1}



static void Test_Ui_BFu33_BFu1ll()
{
  {
    init_simple_test("Ui_BFu33_BFu1ll");
    static STRUCT_IF_C Ui_BFu33_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Ui_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu1ll, Ui_BFu33_BFu1ll)
//============================================================================


struct  Ui_BFu33_BFu1s  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu33_BFu1s) C1{ Fi FL:33 Fs:1}



static void Test_Ui_BFu33_BFu1s()
{
  {
    init_simple_test("Ui_BFu33_BFu1s");
    static STRUCT_IF_C Ui_BFu33_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Ui_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu1s, Ui_BFu33_BFu1s)
//============================================================================


struct  Ui_BFu33_BFu31i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu33_BFu31i) C1{ Fi FL:33 Fi:31}



static void Test_Ui_BFu33_BFu31i()
{
  {
    init_simple_test("Ui_BFu33_BFu31i");
    static STRUCT_IF_C Ui_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "Ui_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "Ui_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu31i, Ui_BFu33_BFu31i)
//============================================================================


struct  Ui_BFu33_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu33_BFu31ll) C1{ Fi FL:33 FL:31}



static void Test_Ui_BFu33_BFu31ll()
{
  {
    init_simple_test("Ui_BFu33_BFu31ll");
    static STRUCT_IF_C Ui_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "Ui_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "Ui_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu31ll, Ui_BFu33_BFu31ll)
//============================================================================


struct  Ui_BFu33_BFu32i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu33_BFu32i) C1{ Fi FL:33 Fi:32}



static void Test_Ui_BFu33_BFu32i()
{
  {
    init_simple_test("Ui_BFu33_BFu32i");
    static STRUCT_IF_C Ui_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ui_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Ui_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Ui_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu32i, Ui_BFu33_BFu32i)
//============================================================================


struct  Ui_BFu33_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu33_BFu32ll) C1{ Fi FL:33 FL:32}



static void Test_Ui_BFu33_BFu32ll()
{
  {
    init_simple_test("Ui_BFu33_BFu32ll");
    static STRUCT_IF_C Ui_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ui_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 32, 1, "Ui_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Ui_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu32ll, Ui_BFu33_BFu32ll)
//============================================================================


struct  Ui_BFu33_BFu33  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu33_BFu33) C1{ Fi FL:33 FL:33}



static void Test_Ui_BFu33_BFu33()
{
  {
    init_simple_test("Ui_BFu33_BFu33");
    static STRUCT_IF_C Ui_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ui_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 33, 1, "Ui_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Ui_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu33, Ui_BFu33_BFu33)
//============================================================================


struct  Ui_BFu33_BFu7c  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu33_BFu7c) C1{ Fi FL:33 Fc:7}



static void Test_Ui_BFu33_BFu7c()
{
  {
    init_simple_test("Ui_BFu33_BFu7c");
    static STRUCT_IF_C Ui_BFu33_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Ui_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Ui_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu7c, Ui_BFu33_BFu7c)
//============================================================================


struct  Ui_BFu33_BFu7i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu33_BFu7i) C1{ Fi FL:33 Fi:7}



static void Test_Ui_BFu33_BFu7i()
{
  {
    init_simple_test("Ui_BFu33_BFu7i");
    static STRUCT_IF_C Ui_BFu33_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Ui_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Ui_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu7i, Ui_BFu33_BFu7i)
//============================================================================


struct  Ui_BFu33_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu33_BFu7ll) C1{ Fi FL:33 FL:7}



static void Test_Ui_BFu33_BFu7ll()
{
  {
    init_simple_test("Ui_BFu33_BFu7ll");
    static STRUCT_IF_C Ui_BFu33_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Ui_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Ui_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu7ll, Ui_BFu33_BFu7ll)
//============================================================================


struct  Ui_BFu33_BFu7s  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu33_BFu7s) C1{ Fi FL:33 Fs:7}



static void Test_Ui_BFu33_BFu7s()
{
  {
    init_simple_test("Ui_BFu33_BFu7s");
    static STRUCT_IF_C Ui_BFu33_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Ui_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Ui_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu7s, Ui_BFu33_BFu7s)
//============================================================================


struct  Ui_BFu33_BFu8c  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu33_BFu8c) C1{ Fi FL:33 Fc:8}



static void Test_Ui_BFu33_BFu8c()
{
  {
    init_simple_test("Ui_BFu33_BFu8c");
    static STRUCT_IF_C Ui_BFu33_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(13,9), 0, 8, 1, "Ui_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(13,9), 0, 8, hide_ull(1LL<<7), "Ui_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu8c, Ui_BFu33_BFu8c)
//============================================================================


struct  Ui_BFu33_BFu8i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu33_BFu8i) C1{ Fi FL:33 Fi:8}



static void Test_Ui_BFu33_BFu8i()
{
  {
    init_simple_test("Ui_BFu33_BFu8i");
    static STRUCT_IF_C Ui_BFu33_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Ui_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Ui_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu8i, Ui_BFu33_BFu8i)
//============================================================================


struct  Ui_BFu33_BFu8ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu33_BFu8ll) C1{ Fi FL:33 FL:8}



static void Test_Ui_BFu33_BFu8ll()
{
  {
    init_simple_test("Ui_BFu33_BFu8ll");
    static STRUCT_IF_C Ui_BFu33_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Ui_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Ui_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu8ll, Ui_BFu33_BFu8ll)
//============================================================================


struct  Ui_BFu33_BFu8s  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu33_BFu8s) C1{ Fi FL:33 Fs:8}



static void Test_Ui_BFu33_BFu8s()
{
  {
    init_simple_test("Ui_BFu33_BFu8s");
    static STRUCT_IF_C Ui_BFu33_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Ui_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Ui_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu8s, Ui_BFu33_BFu8s)
//============================================================================


struct  Ui_BFu33_BFu9i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu33_BFu9i) C1{ Fi FL:33 Fi:9}



static void Test_Ui_BFu33_BFu9i()
{
  {
    init_simple_test("Ui_BFu33_BFu9i");
    static STRUCT_IF_C Ui_BFu33_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Ui_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Ui_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu9i, Ui_BFu33_BFu9i)
//============================================================================


struct  Ui_BFu33_BFu9ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu33_BFu9ll) C1{ Fi FL:33 FL:9}



static void Test_Ui_BFu33_BFu9ll()
{
  {
    init_simple_test("Ui_BFu33_BFu9ll");
    static STRUCT_IF_C Ui_BFu33_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Ui_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Ui_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu9ll, Ui_BFu33_BFu9ll)
//============================================================================


struct  Ui_BFu33_BFu9s  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu33_BFu9s) C1{ Fi FL:33 Fs:9}



static void Test_Ui_BFu33_BFu9s()
{
  {
    init_simple_test("Ui_BFu33_BFu9s");
    static STRUCT_IF_C Ui_BFu33_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Ui_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Ui_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_BFu9s, Ui_BFu33_BFu9s)
//============================================================================


struct  Ui_BFu33_C  {
  unsigned int v1;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 Ui_BFu33_C) C1{ Fi FL:33 Fc}



static void Test_Ui_BFu33_C()
{
  {
    init_simple_test("Ui_BFu33_C");
    static STRUCT_IF_C Ui_BFu33_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_C");
    check_field_offset(lv, v3, ABISELECT(13,9), "Ui_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_C, Ui_BFu33_C)
//============================================================================


struct  Ui_BFu33_D  {
  unsigned int v1;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 Ui_BFu33_D) C1{ Fi FL:33 FL}



static void Test_Ui_BFu33_D()
{
  {
    init_simple_test("Ui_BFu33_D");
    static STRUCT_IF_C Ui_BFu33_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ui_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ui_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_D, Ui_BFu33_D)
//============================================================================


struct  Ui_BFu33_F  {
  unsigned int v1;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 Ui_BFu33_F) C1{ Fi FL:33 Fi}



static void Test_Ui_BFu33_F()
{
  {
    init_simple_test("Ui_BFu33_F");
    static STRUCT_IF_C Ui_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ui_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_F");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ui_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_F, Ui_BFu33_F)
//============================================================================


struct  Ui_BFu33_I  {
  unsigned int v1;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 Ui_BFu33_I) C1{ Fi FL:33 Fi}



static void Test_Ui_BFu33_I()
{
  {
    init_simple_test("Ui_BFu33_I");
    static STRUCT_IF_C Ui_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ui_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_I");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ui_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_I, Ui_BFu33_I)
//============================================================================


struct  Ui_BFu33_Ip  {
  unsigned int v1;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 Ui_BFu33_Ip) C1{ Fi FL:33 Fp}



static void Test_Ui_BFu33_Ip()
{
  {
    init_simple_test("Ui_BFu33_Ip");
    static STRUCT_IF_C Ui_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ui_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ui_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_Ip, Ui_BFu33_Ip)
//============================================================================


struct  Ui_BFu33_L  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 Ui_BFu33_L) C1{ Fi FL:33 FL}



static void Test_Ui_BFu33_L()
{
  {
    init_simple_test("Ui_BFu33_L");
    static STRUCT_IF_C Ui_BFu33_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ui_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ui_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_L, Ui_BFu33_L)
//============================================================================


struct  Ui_BFu33_S  {
  unsigned int v1;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 Ui_BFu33_S) C1{ Fi FL:33 Fs}



static void Test_Ui_BFu33_S()
{
  {
    init_simple_test("Ui_BFu33_S");
    static STRUCT_IF_C Ui_BFu33_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_S");
    check_field_offset(lv, v3, ABISELECT(14,10), "Ui_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_S, Ui_BFu33_S)
//============================================================================


struct  Ui_BFu33_Uc  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 Ui_BFu33_Uc) C1{ Fi FL:33 Fc}



static void Test_Ui_BFu33_Uc()
{
  {
    init_simple_test("Ui_BFu33_Uc");
    static STRUCT_IF_C Ui_BFu33_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_Uc");
    check_field_offset(lv, v3, ABISELECT(13,9), "Ui_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_Uc, Ui_BFu33_Uc)
//============================================================================


struct  Ui_BFu33_Ui  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 Ui_BFu33_Ui) C1{ Fi FL:33 Fi}



static void Test_Ui_BFu33_Ui()
{
  {
    init_simple_test("Ui_BFu33_Ui");
    static STRUCT_IF_C Ui_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ui_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_Ui");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ui_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_Ui, Ui_BFu33_Ui)
//============================================================================


struct  Ui_BFu33_Ul  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 Ui_BFu33_Ul) C1{ Fi FL:33 FL}



static void Test_Ui_BFu33_Ul()
{
  {
    init_simple_test("Ui_BFu33_Ul");
    static STRUCT_IF_C Ui_BFu33_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ui_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ui_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_Ul, Ui_BFu33_Ul)
//============================================================================


struct  Ui_BFu33_Us  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 Ui_BFu33_Us) C1{ Fi FL:33 Fs}



static void Test_Ui_BFu33_Us()
{
  {
    init_simple_test("Ui_BFu33_Us");
    static STRUCT_IF_C Ui_BFu33_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_Us");
    check_field_offset(lv, v3, ABISELECT(14,10), "Ui_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_Us, Ui_BFu33_Us)
//============================================================================


struct  Ui_BFu33_Vp  {
  unsigned int v1;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 Ui_BFu33_Vp) C1{ Fi FL:33 Fp}



static void Test_Ui_BFu33_Vp()
{
  {
    init_simple_test("Ui_BFu33_Vp");
    static STRUCT_IF_C Ui_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ui_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ui_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu33_Vp, Ui_BFu33_Vp)
//============================================================================


struct  Ui_BFu7c  {
  unsigned int v1;
  unsigned char v2:7;
};
//SIG(1 Ui_BFu7c) C1{ Fi Fc:7}



static void Test_Ui_BFu7c()
{
  {
    init_simple_test("Ui_BFu7c");
    static STRUCT_IF_C Ui_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c, Ui_BFu7c)
//============================================================================


struct  Ui_BFu7c_BFu15i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu7c_BFu15i) C1{ Fi Fc:7 Fi:15}



static void Test_Ui_BFu7c_BFu15i()
{
  {
    init_simple_test("Ui_BFu7c_BFu15i");
    static STRUCT_IF_C Ui_BFu7c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Ui_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Ui_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu15i, Ui_BFu7c_BFu15i)
//============================================================================


struct  Ui_BFu7c_BFu15ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu7c_BFu15ll) C1{ Fi Fc:7 FL:15}



static void Test_Ui_BFu7c_BFu15ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu15ll");
    static STRUCT_IF_C Ui_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Ui_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Ui_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu15ll, Ui_BFu7c_BFu15ll)
//============================================================================


struct  Ui_BFu7c_BFu15s  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu7c_BFu15s) C1{ Fi Fc:7 Fs:15}



static void Test_Ui_BFu7c_BFu15s()
{
  {
    init_simple_test("Ui_BFu7c_BFu15s");
    static STRUCT_IF_C Ui_BFu7c_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu15s, Ui_BFu7c_BFu15s)
//============================================================================


struct  Ui_BFu7c_BFu16i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu7c_BFu16i) C1{ Fi Fc:7 Fi:16}



static void Test_Ui_BFu7c_BFu16i()
{
  {
    init_simple_test("Ui_BFu7c_BFu16i");
    static STRUCT_IF_C Ui_BFu7c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Ui_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Ui_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu16i, Ui_BFu7c_BFu16i)
//============================================================================


struct  Ui_BFu7c_BFu16ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu7c_BFu16ll) C1{ Fi Fc:7 FL:16}



static void Test_Ui_BFu7c_BFu16ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu16ll");
    static STRUCT_IF_C Ui_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Ui_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Ui_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu16ll, Ui_BFu7c_BFu16ll)
//============================================================================


struct  Ui_BFu7c_BFu16s  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu7c_BFu16s) C1{ Fi Fc:7 Fs:16}



static void Test_Ui_BFu7c_BFu16s()
{
  {
    init_simple_test("Ui_BFu7c_BFu16s");
    static STRUCT_IF_C Ui_BFu7c_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu16s, Ui_BFu7c_BFu16s)
//============================================================================


struct  Ui_BFu7c_BFu17i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu7c_BFu17i) C1{ Fi Fc:7 Fi:17}



static void Test_Ui_BFu7c_BFu17i()
{
  {
    init_simple_test("Ui_BFu7c_BFu17i");
    static STRUCT_IF_C Ui_BFu7c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Ui_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Ui_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu17i, Ui_BFu7c_BFu17i)
//============================================================================


struct  Ui_BFu7c_BFu17ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu7c_BFu17ll) C1{ Fi Fc:7 FL:17}



static void Test_Ui_BFu7c_BFu17ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu17ll");
    static STRUCT_IF_C Ui_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Ui_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Ui_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu17ll, Ui_BFu7c_BFu17ll)
//============================================================================


struct  Ui_BFu7c_BFu1c  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu7c_BFu1c) C1{ Fi Fc:7 Fc:1}



static void Test_Ui_BFu7c_BFu1c()
{
  {
    init_simple_test("Ui_BFu7c_BFu1c");
    static STRUCT_IF_C Ui_BFu7c_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu1c, Ui_BFu7c_BFu1c)
//============================================================================


struct  Ui_BFu7c_BFu1i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu7c_BFu1i) C1{ Fi Fc:7 Fi:1}



static void Test_Ui_BFu7c_BFu1i()
{
  {
    init_simple_test("Ui_BFu7c_BFu1i");
    static STRUCT_IF_C Ui_BFu7c_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu1i, Ui_BFu7c_BFu1i)
//============================================================================


struct  Ui_BFu7c_BFu1ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu7c_BFu1ll) C1{ Fi Fc:7 FL:1}



static void Test_Ui_BFu7c_BFu1ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu1ll");
    static STRUCT_IF_C Ui_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu1ll, Ui_BFu7c_BFu1ll)
//============================================================================


struct  Ui_BFu7c_BFu1s  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu7c_BFu1s) C1{ Fi Fc:7 Fs:1}



static void Test_Ui_BFu7c_BFu1s()
{
  {
    init_simple_test("Ui_BFu7c_BFu1s");
    static STRUCT_IF_C Ui_BFu7c_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu1s, Ui_BFu7c_BFu1s)
//============================================================================


struct  Ui_BFu7c_BFu31i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu7c_BFu31i) C1{ Fi Fc:7 Fi:31}



static void Test_Ui_BFu7c_BFu31i()
{
  {
    init_simple_test("Ui_BFu7c_BFu31i");
    static STRUCT_IF_C Ui_BFu7c_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu31i, Ui_BFu7c_BFu31i)
//============================================================================


struct  Ui_BFu7c_BFu31ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu7c_BFu31ll) C1{ Fi Fc:7 FL:31}



static void Test_Ui_BFu7c_BFu31ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu31ll");
    static STRUCT_IF_C Ui_BFu7c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "Ui_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu31ll, Ui_BFu7c_BFu31ll)
//============================================================================


struct  Ui_BFu7c_BFu32i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu7c_BFu32i) C1{ Fi Fc:7 Fi:32}



static void Test_Ui_BFu7c_BFu32i()
{
  {
    init_simple_test("Ui_BFu7c_BFu32i");
    static STRUCT_IF_C Ui_BFu7c_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu32i, Ui_BFu7c_BFu32i)
//============================================================================


struct  Ui_BFu7c_BFu32ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu7c_BFu32ll) C1{ Fi Fc:7 FL:32}



static void Test_Ui_BFu7c_BFu32ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu32ll");
    static STRUCT_IF_C Ui_BFu7c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "Ui_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu32ll, Ui_BFu7c_BFu32ll)
//============================================================================


struct  Ui_BFu7c_BFu33  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu7c_BFu33) C1{ Fi Fc:7 FL:33}



static void Test_Ui_BFu7c_BFu33()
{
  {
    init_simple_test("Ui_BFu7c_BFu33");
    static STRUCT_IF_C Ui_BFu7c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "Ui_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu33, Ui_BFu7c_BFu33)
//============================================================================


struct  Ui_BFu7c_BFu7c  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu7c_BFu7c) C1{ Fi Fc:7 Fc:7}



static void Test_Ui_BFu7c_BFu7c()
{
  {
    init_simple_test("Ui_BFu7c_BFu7c");
    static STRUCT_IF_C Ui_BFu7c_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Ui_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu7c, Ui_BFu7c_BFu7c)
//============================================================================


struct  Ui_BFu7c_BFu7i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu7c_BFu7i) C1{ Fi Fc:7 Fi:7}



static void Test_Ui_BFu7c_BFu7i()
{
  {
    init_simple_test("Ui_BFu7c_BFu7i");
    static STRUCT_IF_C Ui_BFu7c_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu7i, Ui_BFu7c_BFu7i)
//============================================================================


struct  Ui_BFu7c_BFu7ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu7c_BFu7ll) C1{ Fi Fc:7 FL:7}



static void Test_Ui_BFu7c_BFu7ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu7ll");
    static STRUCT_IF_C Ui_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu7ll, Ui_BFu7c_BFu7ll)
//============================================================================


struct  Ui_BFu7c_BFu7s  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu7c_BFu7s) C1{ Fi Fc:7 Fs:7}



static void Test_Ui_BFu7c_BFu7s()
{
  {
    init_simple_test("Ui_BFu7c_BFu7s");
    static STRUCT_IF_C Ui_BFu7c_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu7s, Ui_BFu7c_BFu7s)
//============================================================================


struct  Ui_BFu7c_BFu8c  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu7c_BFu8c) C1{ Fi Fc:7 Fc:8}



static void Test_Ui_BFu7c_BFu8c()
{
  {
    init_simple_test("Ui_BFu7c_BFu8c");
    static STRUCT_IF_C Ui_BFu7c_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Ui_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Ui_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu8c, Ui_BFu7c_BFu8c)
//============================================================================


struct  Ui_BFu7c_BFu8i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu7c_BFu8i) C1{ Fi Fc:7 Fi:8}



static void Test_Ui_BFu7c_BFu8i()
{
  {
    init_simple_test("Ui_BFu7c_BFu8i");
    static STRUCT_IF_C Ui_BFu7c_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu8i, Ui_BFu7c_BFu8i)
//============================================================================


struct  Ui_BFu7c_BFu8ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu7c_BFu8ll) C1{ Fi Fc:7 FL:8}



static void Test_Ui_BFu7c_BFu8ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu8ll");
    static STRUCT_IF_C Ui_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu8ll, Ui_BFu7c_BFu8ll)
//============================================================================


struct  Ui_BFu7c_BFu8s  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu7c_BFu8s) C1{ Fi Fc:7 Fs:8}



static void Test_Ui_BFu7c_BFu8s()
{
  {
    init_simple_test("Ui_BFu7c_BFu8s");
    static STRUCT_IF_C Ui_BFu7c_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu8s, Ui_BFu7c_BFu8s)
//============================================================================


struct  Ui_BFu7c_BFu9i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu7c_BFu9i) C1{ Fi Fc:7 Fi:9}



static void Test_Ui_BFu7c_BFu9i()
{
  {
    init_simple_test("Ui_BFu7c_BFu9i");
    static STRUCT_IF_C Ui_BFu7c_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu9i, Ui_BFu7c_BFu9i)
//============================================================================


struct  Ui_BFu7c_BFu9ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu7c_BFu9ll) C1{ Fi Fc:7 FL:9}



static void Test_Ui_BFu7c_BFu9ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu9ll");
    static STRUCT_IF_C Ui_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu9ll, Ui_BFu7c_BFu9ll)
//============================================================================


struct  Ui_BFu7c_BFu9s  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu7c_BFu9s) C1{ Fi Fc:7 Fs:9}



static void Test_Ui_BFu7c_BFu9s()
{
  {
    init_simple_test("Ui_BFu7c_BFu9s");
    static STRUCT_IF_C Ui_BFu7c_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_BFu9s, Ui_BFu7c_BFu9s)
//============================================================================


struct  Ui_BFu7c_C  {
  unsigned int v1;
  unsigned char v2:7;
  char v3;
};
//SIG(1 Ui_BFu7c_C) C1{ Fi Fc:7 Fc}



static void Test_Ui_BFu7c_C()
{
  {
    init_simple_test("Ui_BFu7c_C");
    static STRUCT_IF_C Ui_BFu7c_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_C");
    check_field_offset(lv, v3, 5, "Ui_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_C, Ui_BFu7c_C)
//============================================================================


struct  Ui_BFu7c_D  {
  unsigned int v1;
  unsigned char v2:7;
  double v3;
};
//SIG(1 Ui_BFu7c_D) C1{ Fi Fc:7 FL}



static void Test_Ui_BFu7c_D()
{
  {
    init_simple_test("Ui_BFu7c_D");
    static STRUCT_IF_C Ui_BFu7c_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_D");
    check_field_offset(lv, v3, 8, "Ui_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_D, Ui_BFu7c_D)
//============================================================================


struct  Ui_BFu7c_F  {
  unsigned int v1;
  unsigned char v2:7;
  float v3;
};
//SIG(1 Ui_BFu7c_F) C1{ Fi Fc:7 Fi}



static void Test_Ui_BFu7c_F()
{
  {
    init_simple_test("Ui_BFu7c_F");
    static STRUCT_IF_C Ui_BFu7c_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_F");
    check_field_offset(lv, v3, 8, "Ui_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_F, Ui_BFu7c_F)
//============================================================================


struct  Ui_BFu7c_I  {
  unsigned int v1;
  unsigned char v2:7;
  int v3;
};
//SIG(1 Ui_BFu7c_I) C1{ Fi Fc:7 Fi}



static void Test_Ui_BFu7c_I()
{
  {
    init_simple_test("Ui_BFu7c_I");
    static STRUCT_IF_C Ui_BFu7c_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_I");
    check_field_offset(lv, v3, 8, "Ui_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_I, Ui_BFu7c_I)
//============================================================================


struct  Ui_BFu7c_Ip  {
  unsigned int v1;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 Ui_BFu7c_Ip) C1{ Fi Fc:7 Fp}



static void Test_Ui_BFu7c_Ip()
{
  {
    init_simple_test("Ui_BFu7c_Ip");
    static STRUCT_IF_C Ui_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_Ip, Ui_BFu7c_Ip)
//============================================================================


struct  Ui_BFu7c_L  {
  unsigned int v1;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 Ui_BFu7c_L) C1{ Fi Fc:7 FL}



static void Test_Ui_BFu7c_L()
{
  {
    init_simple_test("Ui_BFu7c_L");
    static STRUCT_IF_C Ui_BFu7c_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_L");
    check_field_offset(lv, v3, 8, "Ui_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_L, Ui_BFu7c_L)
//============================================================================


struct  Ui_BFu7c_S  {
  unsigned int v1;
  unsigned char v2:7;
  short v3;
};
//SIG(1 Ui_BFu7c_S) C1{ Fi Fc:7 Fs}



static void Test_Ui_BFu7c_S()
{
  {
    init_simple_test("Ui_BFu7c_S");
    static STRUCT_IF_C Ui_BFu7c_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_S");
    check_field_offset(lv, v3, 6, "Ui_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_S, Ui_BFu7c_S)
//============================================================================


struct  Ui_BFu7c_Uc  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 Ui_BFu7c_Uc) C1{ Fi Fc:7 Fc}



static void Test_Ui_BFu7c_Uc()
{
  {
    init_simple_test("Ui_BFu7c_Uc");
    static STRUCT_IF_C Ui_BFu7c_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_Uc");
    check_field_offset(lv, v3, 5, "Ui_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_Uc, Ui_BFu7c_Uc)
//============================================================================


struct  Ui_BFu7c_Ui  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 Ui_BFu7c_Ui) C1{ Fi Fc:7 Fi}



static void Test_Ui_BFu7c_Ui()
{
  {
    init_simple_test("Ui_BFu7c_Ui");
    static STRUCT_IF_C Ui_BFu7c_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_Ui, Ui_BFu7c_Ui)
//============================================================================


struct  Ui_BFu7c_Ul  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 Ui_BFu7c_Ul) C1{ Fi Fc:7 FL}



static void Test_Ui_BFu7c_Ul()
{
  {
    init_simple_test("Ui_BFu7c_Ul");
    static STRUCT_IF_C Ui_BFu7c_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_Ul, Ui_BFu7c_Ul)
//============================================================================


struct  Ui_BFu7c_Us  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 Ui_BFu7c_Us) C1{ Fi Fc:7 Fs}



static void Test_Ui_BFu7c_Us()
{
  {
    init_simple_test("Ui_BFu7c_Us");
    static STRUCT_IF_C Ui_BFu7c_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_Us, Ui_BFu7c_Us)
//============================================================================


struct  Ui_BFu7c_Vp  {
  unsigned int v1;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 Ui_BFu7c_Vp) C1{ Fi Fc:7 Fp}



static void Test_Ui_BFu7c_Vp()
{
  {
    init_simple_test("Ui_BFu7c_Vp");
    static STRUCT_IF_C Ui_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7c_Vp, Ui_BFu7c_Vp)
//============================================================================


struct  Ui_BFu7i  {
  unsigned int v1;
  unsigned int v2:7;
};
//SIG(1 Ui_BFu7i) C1{ Fi Fi:7}



static void Test_Ui_BFu7i()
{
  {
    init_simple_test("Ui_BFu7i");
    static STRUCT_IF_C Ui_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i, Ui_BFu7i)
//============================================================================


struct  Ui_BFu7i_BFu15i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu7i_BFu15i) C1{ Fi Fi:7 Fi:15}



static void Test_Ui_BFu7i_BFu15i()
{
  {
    init_simple_test("Ui_BFu7i_BFu15i");
    static STRUCT_IF_C Ui_BFu7i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Ui_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Ui_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu15i, Ui_BFu7i_BFu15i)
//============================================================================


struct  Ui_BFu7i_BFu15ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu7i_BFu15ll) C1{ Fi Fi:7 FL:15}



static void Test_Ui_BFu7i_BFu15ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu15ll");
    static STRUCT_IF_C Ui_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Ui_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Ui_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu15ll, Ui_BFu7i_BFu15ll)
//============================================================================


struct  Ui_BFu7i_BFu15s  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu7i_BFu15s) C1{ Fi Fi:7 Fs:15}



static void Test_Ui_BFu7i_BFu15s()
{
  {
    init_simple_test("Ui_BFu7i_BFu15s");
    static STRUCT_IF_C Ui_BFu7i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu15s, Ui_BFu7i_BFu15s)
//============================================================================


struct  Ui_BFu7i_BFu16i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu7i_BFu16i) C1{ Fi Fi:7 Fi:16}



static void Test_Ui_BFu7i_BFu16i()
{
  {
    init_simple_test("Ui_BFu7i_BFu16i");
    static STRUCT_IF_C Ui_BFu7i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Ui_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Ui_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu16i, Ui_BFu7i_BFu16i)
//============================================================================


struct  Ui_BFu7i_BFu16ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu7i_BFu16ll) C1{ Fi Fi:7 FL:16}



static void Test_Ui_BFu7i_BFu16ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu16ll");
    static STRUCT_IF_C Ui_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Ui_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Ui_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu16ll, Ui_BFu7i_BFu16ll)
//============================================================================


struct  Ui_BFu7i_BFu16s  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu7i_BFu16s) C1{ Fi Fi:7 Fs:16}



static void Test_Ui_BFu7i_BFu16s()
{
  {
    init_simple_test("Ui_BFu7i_BFu16s");
    static STRUCT_IF_C Ui_BFu7i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu16s, Ui_BFu7i_BFu16s)
//============================================================================


struct  Ui_BFu7i_BFu17i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu7i_BFu17i) C1{ Fi Fi:7 Fi:17}



static void Test_Ui_BFu7i_BFu17i()
{
  {
    init_simple_test("Ui_BFu7i_BFu17i");
    static STRUCT_IF_C Ui_BFu7i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Ui_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Ui_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu17i, Ui_BFu7i_BFu17i)
//============================================================================


struct  Ui_BFu7i_BFu17ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu7i_BFu17ll) C1{ Fi Fi:7 FL:17}



static void Test_Ui_BFu7i_BFu17ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu17ll");
    static STRUCT_IF_C Ui_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Ui_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Ui_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu17ll, Ui_BFu7i_BFu17ll)
//============================================================================


struct  Ui_BFu7i_BFu1c  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu7i_BFu1c) C1{ Fi Fi:7 Fc:1}



static void Test_Ui_BFu7i_BFu1c()
{
  {
    init_simple_test("Ui_BFu7i_BFu1c");
    static STRUCT_IF_C Ui_BFu7i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu1c, Ui_BFu7i_BFu1c)
//============================================================================


struct  Ui_BFu7i_BFu1i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu7i_BFu1i) C1{ Fi Fi:7 Fi:1}



static void Test_Ui_BFu7i_BFu1i()
{
  {
    init_simple_test("Ui_BFu7i_BFu1i");
    static STRUCT_IF_C Ui_BFu7i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu1i, Ui_BFu7i_BFu1i)
//============================================================================


struct  Ui_BFu7i_BFu1ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu7i_BFu1ll) C1{ Fi Fi:7 FL:1}



static void Test_Ui_BFu7i_BFu1ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu1ll");
    static STRUCT_IF_C Ui_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu1ll, Ui_BFu7i_BFu1ll)
//============================================================================


struct  Ui_BFu7i_BFu1s  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu7i_BFu1s) C1{ Fi Fi:7 Fs:1}



static void Test_Ui_BFu7i_BFu1s()
{
  {
    init_simple_test("Ui_BFu7i_BFu1s");
    static STRUCT_IF_C Ui_BFu7i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu1s, Ui_BFu7i_BFu1s)
//============================================================================


struct  Ui_BFu7i_BFu31i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu7i_BFu31i) C1{ Fi Fi:7 Fi:31}



static void Test_Ui_BFu7i_BFu31i()
{
  {
    init_simple_test("Ui_BFu7i_BFu31i");
    static STRUCT_IF_C Ui_BFu7i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu31i, Ui_BFu7i_BFu31i)
//============================================================================


struct  Ui_BFu7i_BFu31ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu7i_BFu31ll) C1{ Fi Fi:7 FL:31}



static void Test_Ui_BFu7i_BFu31ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu31ll");
    static STRUCT_IF_C Ui_BFu7i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "Ui_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu31ll, Ui_BFu7i_BFu31ll)
//============================================================================


struct  Ui_BFu7i_BFu32i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu7i_BFu32i) C1{ Fi Fi:7 Fi:32}



static void Test_Ui_BFu7i_BFu32i()
{
  {
    init_simple_test("Ui_BFu7i_BFu32i");
    static STRUCT_IF_C Ui_BFu7i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu32i, Ui_BFu7i_BFu32i)
//============================================================================


struct  Ui_BFu7i_BFu32ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu7i_BFu32ll) C1{ Fi Fi:7 FL:32}



static void Test_Ui_BFu7i_BFu32ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu32ll");
    static STRUCT_IF_C Ui_BFu7i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "Ui_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu32ll, Ui_BFu7i_BFu32ll)
//============================================================================


struct  Ui_BFu7i_BFu33  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu7i_BFu33) C1{ Fi Fi:7 FL:33}



static void Test_Ui_BFu7i_BFu33()
{
  {
    init_simple_test("Ui_BFu7i_BFu33");
    static STRUCT_IF_C Ui_BFu7i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "Ui_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu33, Ui_BFu7i_BFu33)
//============================================================================


struct  Ui_BFu7i_BFu7c  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu7i_BFu7c) C1{ Fi Fi:7 Fc:7}



static void Test_Ui_BFu7i_BFu7c()
{
  {
    init_simple_test("Ui_BFu7i_BFu7c");
    static STRUCT_IF_C Ui_BFu7i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Ui_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu7c, Ui_BFu7i_BFu7c)
//============================================================================


struct  Ui_BFu7i_BFu7i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu7i_BFu7i) C1{ Fi Fi:7 Fi:7}



static void Test_Ui_BFu7i_BFu7i()
{
  {
    init_simple_test("Ui_BFu7i_BFu7i");
    static STRUCT_IF_C Ui_BFu7i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu7i, Ui_BFu7i_BFu7i)
//============================================================================


struct  Ui_BFu7i_BFu7ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu7i_BFu7ll) C1{ Fi Fi:7 FL:7}



static void Test_Ui_BFu7i_BFu7ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu7ll");
    static STRUCT_IF_C Ui_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu7ll, Ui_BFu7i_BFu7ll)
//============================================================================


struct  Ui_BFu7i_BFu7s  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu7i_BFu7s) C1{ Fi Fi:7 Fs:7}



static void Test_Ui_BFu7i_BFu7s()
{
  {
    init_simple_test("Ui_BFu7i_BFu7s");
    static STRUCT_IF_C Ui_BFu7i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu7s, Ui_BFu7i_BFu7s)
//============================================================================


struct  Ui_BFu7i_BFu8c  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu7i_BFu8c) C1{ Fi Fi:7 Fc:8}



static void Test_Ui_BFu7i_BFu8c()
{
  {
    init_simple_test("Ui_BFu7i_BFu8c");
    static STRUCT_IF_C Ui_BFu7i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Ui_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Ui_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu8c, Ui_BFu7i_BFu8c)
//============================================================================


struct  Ui_BFu7i_BFu8i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu7i_BFu8i) C1{ Fi Fi:7 Fi:8}



static void Test_Ui_BFu7i_BFu8i()
{
  {
    init_simple_test("Ui_BFu7i_BFu8i");
    static STRUCT_IF_C Ui_BFu7i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu8i, Ui_BFu7i_BFu8i)
//============================================================================


struct  Ui_BFu7i_BFu8ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu7i_BFu8ll) C1{ Fi Fi:7 FL:8}



static void Test_Ui_BFu7i_BFu8ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu8ll");
    static STRUCT_IF_C Ui_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu8ll, Ui_BFu7i_BFu8ll)
//============================================================================


struct  Ui_BFu7i_BFu8s  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu7i_BFu8s) C1{ Fi Fi:7 Fs:8}



static void Test_Ui_BFu7i_BFu8s()
{
  {
    init_simple_test("Ui_BFu7i_BFu8s");
    static STRUCT_IF_C Ui_BFu7i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu8s, Ui_BFu7i_BFu8s)
//============================================================================


struct  Ui_BFu7i_BFu9i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu7i_BFu9i) C1{ Fi Fi:7 Fi:9}



static void Test_Ui_BFu7i_BFu9i()
{
  {
    init_simple_test("Ui_BFu7i_BFu9i");
    static STRUCT_IF_C Ui_BFu7i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu9i, Ui_BFu7i_BFu9i)
//============================================================================


struct  Ui_BFu7i_BFu9ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu7i_BFu9ll) C1{ Fi Fi:7 FL:9}



static void Test_Ui_BFu7i_BFu9ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu9ll");
    static STRUCT_IF_C Ui_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu9ll, Ui_BFu7i_BFu9ll)
//============================================================================


struct  Ui_BFu7i_BFu9s  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu7i_BFu9s) C1{ Fi Fi:7 Fs:9}



static void Test_Ui_BFu7i_BFu9s()
{
  {
    init_simple_test("Ui_BFu7i_BFu9s");
    static STRUCT_IF_C Ui_BFu7i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_BFu9s, Ui_BFu7i_BFu9s)
//============================================================================


struct  Ui_BFu7i_C  {
  unsigned int v1;
  unsigned int v2:7;
  char v3;
};
//SIG(1 Ui_BFu7i_C) C1{ Fi Fi:7 Fc}



static void Test_Ui_BFu7i_C()
{
  {
    init_simple_test("Ui_BFu7i_C");
    static STRUCT_IF_C Ui_BFu7i_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_C");
    check_field_offset(lv, v3, 5, "Ui_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_C, Ui_BFu7i_C)
//============================================================================


struct  Ui_BFu7i_D  {
  unsigned int v1;
  unsigned int v2:7;
  double v3;
};
//SIG(1 Ui_BFu7i_D) C1{ Fi Fi:7 FL}



static void Test_Ui_BFu7i_D()
{
  {
    init_simple_test("Ui_BFu7i_D");
    static STRUCT_IF_C Ui_BFu7i_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_D");
    check_field_offset(lv, v3, 8, "Ui_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_D, Ui_BFu7i_D)
//============================================================================


struct  Ui_BFu7i_F  {
  unsigned int v1;
  unsigned int v2:7;
  float v3;
};
//SIG(1 Ui_BFu7i_F) C1{ Fi Fi:7 Fi}



static void Test_Ui_BFu7i_F()
{
  {
    init_simple_test("Ui_BFu7i_F");
    static STRUCT_IF_C Ui_BFu7i_F lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_F");
    check_field_offset(lv, v3, 8, "Ui_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_F, Ui_BFu7i_F)
//============================================================================


struct  Ui_BFu7i_I  {
  unsigned int v1;
  unsigned int v2:7;
  int v3;
};
//SIG(1 Ui_BFu7i_I) C1{ Fi Fi:7 Fi}



static void Test_Ui_BFu7i_I()
{
  {
    init_simple_test("Ui_BFu7i_I");
    static STRUCT_IF_C Ui_BFu7i_I lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_I");
    check_field_offset(lv, v3, 8, "Ui_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_I, Ui_BFu7i_I)
//============================================================================


struct  Ui_BFu7i_Ip  {
  unsigned int v1;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 Ui_BFu7i_Ip) C1{ Fi Fi:7 Fp}



static void Test_Ui_BFu7i_Ip()
{
  {
    init_simple_test("Ui_BFu7i_Ip");
    static STRUCT_IF_C Ui_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_Ip, Ui_BFu7i_Ip)
//============================================================================


struct  Ui_BFu7i_L  {
  unsigned int v1;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 Ui_BFu7i_L) C1{ Fi Fi:7 FL}



static void Test_Ui_BFu7i_L()
{
  {
    init_simple_test("Ui_BFu7i_L");
    static STRUCT_IF_C Ui_BFu7i_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_L");
    check_field_offset(lv, v3, 8, "Ui_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_L, Ui_BFu7i_L)
//============================================================================


struct  Ui_BFu7i_S  {
  unsigned int v1;
  unsigned int v2:7;
  short v3;
};
//SIG(1 Ui_BFu7i_S) C1{ Fi Fi:7 Fs}



static void Test_Ui_BFu7i_S()
{
  {
    init_simple_test("Ui_BFu7i_S");
    static STRUCT_IF_C Ui_BFu7i_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_S");
    check_field_offset(lv, v3, 6, "Ui_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_S, Ui_BFu7i_S)
//============================================================================


struct  Ui_BFu7i_Uc  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 Ui_BFu7i_Uc) C1{ Fi Fi:7 Fc}



static void Test_Ui_BFu7i_Uc()
{
  {
    init_simple_test("Ui_BFu7i_Uc");
    static STRUCT_IF_C Ui_BFu7i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_Uc");
    check_field_offset(lv, v3, 5, "Ui_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_Uc, Ui_BFu7i_Uc)
//============================================================================


struct  Ui_BFu7i_Ui  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 Ui_BFu7i_Ui) C1{ Fi Fi:7 Fi}



static void Test_Ui_BFu7i_Ui()
{
  {
    init_simple_test("Ui_BFu7i_Ui");
    static STRUCT_IF_C Ui_BFu7i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_Ui, Ui_BFu7i_Ui)
//============================================================================


struct  Ui_BFu7i_Ul  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 Ui_BFu7i_Ul) C1{ Fi Fi:7 FL}



static void Test_Ui_BFu7i_Ul()
{
  {
    init_simple_test("Ui_BFu7i_Ul");
    static STRUCT_IF_C Ui_BFu7i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_Ul, Ui_BFu7i_Ul)
//============================================================================


struct  Ui_BFu7i_Us  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 Ui_BFu7i_Us) C1{ Fi Fi:7 Fs}



static void Test_Ui_BFu7i_Us()
{
  {
    init_simple_test("Ui_BFu7i_Us");
    static STRUCT_IF_C Ui_BFu7i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_Us, Ui_BFu7i_Us)
//============================================================================


struct  Ui_BFu7i_Vp  {
  unsigned int v1;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 Ui_BFu7i_Vp) C1{ Fi Fi:7 Fp}



static void Test_Ui_BFu7i_Vp()
{
  {
    init_simple_test("Ui_BFu7i_Vp");
    static STRUCT_IF_C Ui_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7i_Vp, Ui_BFu7i_Vp)
//============================================================================


struct  Ui_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:7;
};
//SIG(1 Ui_BFu7ll) C1{ Fi FL:7}



static void Test_Ui_BFu7ll()
{
  {
    init_simple_test("Ui_BFu7ll");
    static STRUCT_IF_C Ui_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll, Ui_BFu7ll)
//============================================================================


struct  Ui_BFu7ll_BFu15i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu7ll_BFu15i) C1{ Fi FL:7 Fi:15}



static void Test_Ui_BFu7ll_BFu15i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu15i");
    static STRUCT_IF_C Ui_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Ui_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Ui_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu15i, Ui_BFu7ll_BFu15i)
//============================================================================


struct  Ui_BFu7ll_BFu15ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu7ll_BFu15ll) C1{ Fi FL:7 FL:15}



static void Test_Ui_BFu7ll_BFu15ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu15ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Ui_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Ui_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu15ll, Ui_BFu7ll_BFu15ll)
//============================================================================


struct  Ui_BFu7ll_BFu15s  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu7ll_BFu15s) C1{ Fi FL:7 Fs:15}



static void Test_Ui_BFu7ll_BFu15s()
{
  {
    init_simple_test("Ui_BFu7ll_BFu15s");
    static STRUCT_IF_C Ui_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu15s, Ui_BFu7ll_BFu15s)
//============================================================================


struct  Ui_BFu7ll_BFu16i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu7ll_BFu16i) C1{ Fi FL:7 Fi:16}



static void Test_Ui_BFu7ll_BFu16i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu16i");
    static STRUCT_IF_C Ui_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Ui_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Ui_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu16i, Ui_BFu7ll_BFu16i)
//============================================================================


struct  Ui_BFu7ll_BFu16ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu7ll_BFu16ll) C1{ Fi FL:7 FL:16}



static void Test_Ui_BFu7ll_BFu16ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu16ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Ui_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Ui_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu16ll, Ui_BFu7ll_BFu16ll)
//============================================================================


struct  Ui_BFu7ll_BFu16s  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu7ll_BFu16s) C1{ Fi FL:7 Fs:16}



static void Test_Ui_BFu7ll_BFu16s()
{
  {
    init_simple_test("Ui_BFu7ll_BFu16s");
    static STRUCT_IF_C Ui_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu16s, Ui_BFu7ll_BFu16s)
//============================================================================


struct  Ui_BFu7ll_BFu17i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu7ll_BFu17i) C1{ Fi FL:7 Fi:17}



static void Test_Ui_BFu7ll_BFu17i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu17i");
    static STRUCT_IF_C Ui_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Ui_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Ui_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu17i, Ui_BFu7ll_BFu17i)
//============================================================================


struct  Ui_BFu7ll_BFu17ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu7ll_BFu17ll) C1{ Fi FL:7 FL:17}



static void Test_Ui_BFu7ll_BFu17ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu17ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Ui_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Ui_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu17ll, Ui_BFu7ll_BFu17ll)
//============================================================================


struct  Ui_BFu7ll_BFu1c  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu7ll_BFu1c) C1{ Fi FL:7 Fc:1}



static void Test_Ui_BFu7ll_BFu1c()
{
  {
    init_simple_test("Ui_BFu7ll_BFu1c");
    static STRUCT_IF_C Ui_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu1c, Ui_BFu7ll_BFu1c)
//============================================================================


struct  Ui_BFu7ll_BFu1i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu7ll_BFu1i) C1{ Fi FL:7 Fi:1}



static void Test_Ui_BFu7ll_BFu1i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu1i");
    static STRUCT_IF_C Ui_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu1i, Ui_BFu7ll_BFu1i)
//============================================================================


struct  Ui_BFu7ll_BFu1ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu7ll_BFu1ll) C1{ Fi FL:7 FL:1}



static void Test_Ui_BFu7ll_BFu1ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu1ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu1ll, Ui_BFu7ll_BFu1ll)
//============================================================================


struct  Ui_BFu7ll_BFu1s  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu7ll_BFu1s) C1{ Fi FL:7 Fs:1}



static void Test_Ui_BFu7ll_BFu1s()
{
  {
    init_simple_test("Ui_BFu7ll_BFu1s");
    static STRUCT_IF_C Ui_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu1s, Ui_BFu7ll_BFu1s)
//============================================================================


struct  Ui_BFu7ll_BFu31i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu7ll_BFu31i) C1{ Fi FL:7 Fi:31}



static void Test_Ui_BFu7ll_BFu31i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu31i");
    static STRUCT_IF_C Ui_BFu7ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu31i, Ui_BFu7ll_BFu31i)
//============================================================================


struct  Ui_BFu7ll_BFu31ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu7ll_BFu31ll) C1{ Fi FL:7 FL:31}



static void Test_Ui_BFu7ll_BFu31ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu31ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "Ui_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu31ll, Ui_BFu7ll_BFu31ll)
//============================================================================


struct  Ui_BFu7ll_BFu32i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu7ll_BFu32i) C1{ Fi FL:7 Fi:32}



static void Test_Ui_BFu7ll_BFu32i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu32i");
    static STRUCT_IF_C Ui_BFu7ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu32i, Ui_BFu7ll_BFu32i)
//============================================================================


struct  Ui_BFu7ll_BFu32ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu7ll_BFu32ll) C1{ Fi FL:7 FL:32}



static void Test_Ui_BFu7ll_BFu32ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu32ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "Ui_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu32ll, Ui_BFu7ll_BFu32ll)
//============================================================================


struct  Ui_BFu7ll_BFu33  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu7ll_BFu33) C1{ Fi FL:7 FL:33}



static void Test_Ui_BFu7ll_BFu33()
{
  {
    init_simple_test("Ui_BFu7ll_BFu33");
    static STRUCT_IF_C Ui_BFu7ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "Ui_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu33, Ui_BFu7ll_BFu33)
//============================================================================


struct  Ui_BFu7ll_BFu7c  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu7ll_BFu7c) C1{ Fi FL:7 Fc:7}



static void Test_Ui_BFu7ll_BFu7c()
{
  {
    init_simple_test("Ui_BFu7ll_BFu7c");
    static STRUCT_IF_C Ui_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Ui_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu7c, Ui_BFu7ll_BFu7c)
//============================================================================


struct  Ui_BFu7ll_BFu7i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu7ll_BFu7i) C1{ Fi FL:7 Fi:7}



static void Test_Ui_BFu7ll_BFu7i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu7i");
    static STRUCT_IF_C Ui_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu7i, Ui_BFu7ll_BFu7i)
//============================================================================


struct  Ui_BFu7ll_BFu7ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu7ll_BFu7ll) C1{ Fi FL:7 FL:7}



static void Test_Ui_BFu7ll_BFu7ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu7ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu7ll, Ui_BFu7ll_BFu7ll)
//============================================================================


struct  Ui_BFu7ll_BFu7s  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu7ll_BFu7s) C1{ Fi FL:7 Fs:7}



static void Test_Ui_BFu7ll_BFu7s()
{
  {
    init_simple_test("Ui_BFu7ll_BFu7s");
    static STRUCT_IF_C Ui_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu7s, Ui_BFu7ll_BFu7s)
//============================================================================


struct  Ui_BFu7ll_BFu8c  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu7ll_BFu8c) C1{ Fi FL:7 Fc:8}



static void Test_Ui_BFu7ll_BFu8c()
{
  {
    init_simple_test("Ui_BFu7ll_BFu8c");
    static STRUCT_IF_C Ui_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Ui_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Ui_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu8c, Ui_BFu7ll_BFu8c)
//============================================================================


struct  Ui_BFu7ll_BFu8i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu7ll_BFu8i) C1{ Fi FL:7 Fi:8}



static void Test_Ui_BFu7ll_BFu8i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu8i");
    static STRUCT_IF_C Ui_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu8i, Ui_BFu7ll_BFu8i)
//============================================================================


struct  Ui_BFu7ll_BFu8ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu7ll_BFu8ll) C1{ Fi FL:7 FL:8}



static void Test_Ui_BFu7ll_BFu8ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu8ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu8ll, Ui_BFu7ll_BFu8ll)
//============================================================================


struct  Ui_BFu7ll_BFu8s  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu7ll_BFu8s) C1{ Fi FL:7 Fs:8}



static void Test_Ui_BFu7ll_BFu8s()
{
  {
    init_simple_test("Ui_BFu7ll_BFu8s");
    static STRUCT_IF_C Ui_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu8s, Ui_BFu7ll_BFu8s)
//============================================================================


struct  Ui_BFu7ll_BFu9i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu7ll_BFu9i) C1{ Fi FL:7 Fi:9}



static void Test_Ui_BFu7ll_BFu9i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu9i");
    static STRUCT_IF_C Ui_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu9i, Ui_BFu7ll_BFu9i)
//============================================================================


struct  Ui_BFu7ll_BFu9ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu7ll_BFu9ll) C1{ Fi FL:7 FL:9}



static void Test_Ui_BFu7ll_BFu9ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu9ll");
    static STRUCT_IF_C Ui_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu9ll, Ui_BFu7ll_BFu9ll)
//============================================================================


struct  Ui_BFu7ll_BFu9s  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 Ui_BFu7ll_BFu9s) C1{ Fi FL:7 Fs:9}



static void Test_Ui_BFu7ll_BFu9s()
{
  {
    init_simple_test("Ui_BFu7ll_BFu9s");
    static STRUCT_IF_C Ui_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_BFu9s, Ui_BFu7ll_BFu9s)
//============================================================================


struct  Ui_BFu7ll_C  {
  unsigned int v1;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 Ui_BFu7ll_C) C1{ Fi FL:7 Fc}



static void Test_Ui_BFu7ll_C()
{
  {
    init_simple_test("Ui_BFu7ll_C");
    static STRUCT_IF_C Ui_BFu7ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_C");
    check_field_offset(lv, v3, 5, "Ui_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_C, Ui_BFu7ll_C)
//============================================================================


struct  Ui_BFu7ll_D  {
  unsigned int v1;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 Ui_BFu7ll_D) C1{ Fi FL:7 FL}



static void Test_Ui_BFu7ll_D()
{
  {
    init_simple_test("Ui_BFu7ll_D");
    static STRUCT_IF_C Ui_BFu7ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_D");
    check_field_offset(lv, v3, 8, "Ui_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_D, Ui_BFu7ll_D)
//============================================================================


struct  Ui_BFu7ll_F  {
  unsigned int v1;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 Ui_BFu7ll_F) C1{ Fi FL:7 Fi}



static void Test_Ui_BFu7ll_F()
{
  {
    init_simple_test("Ui_BFu7ll_F");
    static STRUCT_IF_C Ui_BFu7ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_F");
    check_field_offset(lv, v3, 8, "Ui_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_F, Ui_BFu7ll_F)
//============================================================================


struct  Ui_BFu7ll_I  {
  unsigned int v1;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 Ui_BFu7ll_I) C1{ Fi FL:7 Fi}



static void Test_Ui_BFu7ll_I()
{
  {
    init_simple_test("Ui_BFu7ll_I");
    static STRUCT_IF_C Ui_BFu7ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_I");
    check_field_offset(lv, v3, 8, "Ui_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_I, Ui_BFu7ll_I)
//============================================================================


struct  Ui_BFu7ll_Ip  {
  unsigned int v1;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 Ui_BFu7ll_Ip) C1{ Fi FL:7 Fp}



static void Test_Ui_BFu7ll_Ip()
{
  {
    init_simple_test("Ui_BFu7ll_Ip");
    static STRUCT_IF_C Ui_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_Ip");
    check_field_offset(lv, v3, 8, "Ui_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_Ip, Ui_BFu7ll_Ip)
//============================================================================


struct  Ui_BFu7ll_L  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 Ui_BFu7ll_L) C1{ Fi FL:7 FL}



static void Test_Ui_BFu7ll_L()
{
  {
    init_simple_test("Ui_BFu7ll_L");
    static STRUCT_IF_C Ui_BFu7ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_L");
    check_field_offset(lv, v3, 8, "Ui_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_L, Ui_BFu7ll_L)
//============================================================================


struct  Ui_BFu7ll_S  {
  unsigned int v1;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 Ui_BFu7ll_S) C1{ Fi FL:7 Fs}



static void Test_Ui_BFu7ll_S()
{
  {
    init_simple_test("Ui_BFu7ll_S");
    static STRUCT_IF_C Ui_BFu7ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_S");
    check_field_offset(lv, v3, 6, "Ui_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_S, Ui_BFu7ll_S)
//============================================================================


struct  Ui_BFu7ll_Uc  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 Ui_BFu7ll_Uc) C1{ Fi FL:7 Fc}



static void Test_Ui_BFu7ll_Uc()
{
  {
    init_simple_test("Ui_BFu7ll_Uc");
    static STRUCT_IF_C Ui_BFu7ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_Uc");
    check_field_offset(lv, v3, 5, "Ui_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_Uc, Ui_BFu7ll_Uc)
//============================================================================


struct  Ui_BFu7ll_Ui  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 Ui_BFu7ll_Ui) C1{ Fi FL:7 Fi}



static void Test_Ui_BFu7ll_Ui()
{
  {
    init_simple_test("Ui_BFu7ll_Ui");
    static STRUCT_IF_C Ui_BFu7ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_Ui");
    check_field_offset(lv, v3, 8, "Ui_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_Ui, Ui_BFu7ll_Ui)
//============================================================================


struct  Ui_BFu7ll_Ul  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 Ui_BFu7ll_Ul) C1{ Fi FL:7 FL}



static void Test_Ui_BFu7ll_Ul()
{
  {
    init_simple_test("Ui_BFu7ll_Ul");
    static STRUCT_IF_C Ui_BFu7ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ui_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_Ul");
    check_field_offset(lv, v3, 8, "Ui_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_Ul, Ui_BFu7ll_Ul)
//============================================================================


struct  Ui_BFu7ll_Us  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 Ui_BFu7ll_Us) C1{ Fi FL:7 Fs}



static void Test_Ui_BFu7ll_Us()
{
  {
    init_simple_test("Ui_BFu7ll_Us");
    static STRUCT_IF_C Ui_BFu7ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_Us");
    check_field_offset(lv, v3, 6, "Ui_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_Us, Ui_BFu7ll_Us)
//============================================================================


struct  Ui_BFu7ll_Vp  {
  unsigned int v1;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 Ui_BFu7ll_Vp) C1{ Fi FL:7 Fp}



static void Test_Ui_BFu7ll_Vp()
{
  {
    init_simple_test("Ui_BFu7ll_Vp");
    static STRUCT_IF_C Ui_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_Vp");
    check_field_offset(lv, v3, 8, "Ui_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7ll_Vp, Ui_BFu7ll_Vp)
//============================================================================


struct  Ui_BFu7s  {
  unsigned int v1;
  unsigned short v2:7;
};
//SIG(1 Ui_BFu7s) C1{ Fi Fs:7}



static void Test_Ui_BFu7s()
{
  {
    init_simple_test("Ui_BFu7s");
    static STRUCT_IF_C Ui_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s, Ui_BFu7s)
//============================================================================


struct  Ui_BFu7s_BFu15i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 Ui_BFu7s_BFu15i) C1{ Fi Fs:7 Fi:15}



static void Test_Ui_BFu7s_BFu15i()
{
  {
    init_simple_test("Ui_BFu7s_BFu15i");
    static STRUCT_IF_C Ui_BFu7s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Ui_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Ui_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu15i, Ui_BFu7s_BFu15i)
//============================================================================


struct  Ui_BFu7s_BFu15ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 Ui_BFu7s_BFu15ll) C1{ Fi Fs:7 FL:15}



static void Test_Ui_BFu7s_BFu15ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu15ll");
    static STRUCT_IF_C Ui_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Ui_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Ui_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu15ll, Ui_BFu7s_BFu15ll)
//============================================================================


struct  Ui_BFu7s_BFu15s  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 Ui_BFu7s_BFu15s) C1{ Fi Fs:7 Fs:15}



static void Test_Ui_BFu7s_BFu15s()
{
  {
    init_simple_test("Ui_BFu7s_BFu15s");
    static STRUCT_IF_C Ui_BFu7s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu15s, Ui_BFu7s_BFu15s)
//============================================================================


struct  Ui_BFu7s_BFu16i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 Ui_BFu7s_BFu16i) C1{ Fi Fs:7 Fi:16}



static void Test_Ui_BFu7s_BFu16i()
{
  {
    init_simple_test("Ui_BFu7s_BFu16i");
    static STRUCT_IF_C Ui_BFu7s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Ui_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Ui_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu16i, Ui_BFu7s_BFu16i)
//============================================================================


struct  Ui_BFu7s_BFu16ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 Ui_BFu7s_BFu16ll) C1{ Fi Fs:7 FL:16}



static void Test_Ui_BFu7s_BFu16ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu16ll");
    static STRUCT_IF_C Ui_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Ui_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Ui_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu16ll, Ui_BFu7s_BFu16ll)
//============================================================================


struct  Ui_BFu7s_BFu16s  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 Ui_BFu7s_BFu16s) C1{ Fi Fs:7 Fs:16}



static void Test_Ui_BFu7s_BFu16s()
{
  {
    init_simple_test("Ui_BFu7s_BFu16s");
    static STRUCT_IF_C Ui_BFu7s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu16s, Ui_BFu7s_BFu16s)
//============================================================================


struct  Ui_BFu7s_BFu17i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 Ui_BFu7s_BFu17i) C1{ Fi Fs:7 Fi:17}



static void Test_Ui_BFu7s_BFu17i()
{
  {
    init_simple_test("Ui_BFu7s_BFu17i");
    static STRUCT_IF_C Ui_BFu7s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Ui_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Ui_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu17i, Ui_BFu7s_BFu17i)
//============================================================================


struct  Ui_BFu7s_BFu17ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 Ui_BFu7s_BFu17ll) C1{ Fi Fs:7 FL:17}



static void Test_Ui_BFu7s_BFu17ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu17ll");
    static STRUCT_IF_C Ui_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Ui_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Ui_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu17ll, Ui_BFu7s_BFu17ll)
//============================================================================


struct  Ui_BFu7s_BFu1c  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 Ui_BFu7s_BFu1c) C1{ Fi Fs:7 Fc:1}



static void Test_Ui_BFu7s_BFu1c()
{
  {
    init_simple_test("Ui_BFu7s_BFu1c");
    static STRUCT_IF_C Ui_BFu7s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu1c, Ui_BFu7s_BFu1c)
//============================================================================


struct  Ui_BFu7s_BFu1i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 Ui_BFu7s_BFu1i) C1{ Fi Fs:7 Fi:1}



static void Test_Ui_BFu7s_BFu1i()
{
  {
    init_simple_test("Ui_BFu7s_BFu1i");
    static STRUCT_IF_C Ui_BFu7s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu1i, Ui_BFu7s_BFu1i)
//============================================================================


struct  Ui_BFu7s_BFu1ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 Ui_BFu7s_BFu1ll) C1{ Fi Fs:7 FL:1}



static void Test_Ui_BFu7s_BFu1ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu1ll");
    static STRUCT_IF_C Ui_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu1ll, Ui_BFu7s_BFu1ll)
//============================================================================


struct  Ui_BFu7s_BFu1s  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 Ui_BFu7s_BFu1s) C1{ Fi Fs:7 Fs:1}



static void Test_Ui_BFu7s_BFu1s()
{
  {
    init_simple_test("Ui_BFu7s_BFu1s");
    static STRUCT_IF_C Ui_BFu7s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Ui_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu1s, Ui_BFu7s_BFu1s)
//============================================================================


struct  Ui_BFu7s_BFu31i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 Ui_BFu7s_BFu31i) C1{ Fi Fs:7 Fi:31}



static void Test_Ui_BFu7s_BFu31i()
{
  {
    init_simple_test("Ui_BFu7s_BFu31i");
    static STRUCT_IF_C Ui_BFu7s_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Ui_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Ui_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu31i, Ui_BFu7s_BFu31i)
//============================================================================


struct  Ui_BFu7s_BFu31ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 Ui_BFu7s_BFu31ll) C1{ Fi Fs:7 FL:31}



static void Test_Ui_BFu7s_BFu31ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu31ll");
    static STRUCT_IF_C Ui_BFu7s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "Ui_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Ui_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu31ll, Ui_BFu7s_BFu31ll)
//============================================================================


struct  Ui_BFu7s_BFu32i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 Ui_BFu7s_BFu32i) C1{ Fi Fs:7 Fi:32}



static void Test_Ui_BFu7s_BFu32i()
{
  {
    init_simple_test("Ui_BFu7s_BFu32i");
    static STRUCT_IF_C Ui_BFu7s_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ui_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Ui_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Ui_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu32i, Ui_BFu7s_BFu32i)
//============================================================================


struct  Ui_BFu7s_BFu32ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 Ui_BFu7s_BFu32ll) C1{ Fi Fs:7 FL:32}



static void Test_Ui_BFu7s_BFu32ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu32ll");
    static STRUCT_IF_C Ui_BFu7s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "Ui_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Ui_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu32ll, Ui_BFu7s_BFu32ll)
//============================================================================


struct  Ui_BFu7s_BFu33  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 Ui_BFu7s_BFu33) C1{ Fi Fs:7 FL:33}



static void Test_Ui_BFu7s_BFu33()
{
  {
    init_simple_test("Ui_BFu7s_BFu33");
    static STRUCT_IF_C Ui_BFu7s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "Ui_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Ui_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu33, Ui_BFu7s_BFu33)
//============================================================================


struct  Ui_BFu7s_BFu7c  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 Ui_BFu7s_BFu7c) C1{ Fi Fs:7 Fc:7}



static void Test_Ui_BFu7s_BFu7c()
{
  {
    init_simple_test("Ui_BFu7s_BFu7c");
    static STRUCT_IF_C Ui_BFu7s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Ui_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu7c, Ui_BFu7s_BFu7c)
//============================================================================


struct  Ui_BFu7s_BFu7i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 Ui_BFu7s_BFu7i) C1{ Fi Fs:7 Fi:7}



static void Test_Ui_BFu7s_BFu7i()
{
  {
    init_simple_test("Ui_BFu7s_BFu7i");
    static STRUCT_IF_C Ui_BFu7s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu7i, Ui_BFu7s_BFu7i)
//============================================================================


struct  Ui_BFu7s_BFu7ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 Ui_BFu7s_BFu7ll) C1{ Fi Fs:7 FL:7}



static void Test_Ui_BFu7s_BFu7ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu7ll");
    static STRUCT_IF_C Ui_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu7ll, Ui_BFu7s_BFu7ll)
//============================================================================


struct  Ui_BFu7s_BFu7s  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 Ui_BFu7s_BFu7s) C1{ Fi Fs:7 Fs:7}



static void Test_Ui_BFu7s_BFu7s()
{
  {
    init_simple_test("Ui_BFu7s_BFu7s");
    static STRUCT_IF_C Ui_BFu7s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Ui_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu7s, Ui_BFu7s_BFu7s)
//============================================================================


struct  Ui_BFu7s_BFu8c  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 Ui_BFu7s_BFu8c) C1{ Fi Fs:7 Fc:8}



static void Test_Ui_BFu7s_BFu8c()
{
  {
    init_simple_test("Ui_BFu7s_BFu8c");
    static STRUCT_IF_C Ui_BFu7s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Ui_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Ui_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu8c, Ui_BFu7s_BFu8c)
//============================================================================


struct  Ui_BFu7s_BFu8i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 Ui_BFu7s_BFu8i) C1{ Fi Fs:7 Fi:8}



static void Test_Ui_BFu7s_BFu8i()
{
  {
    init_simple_test("Ui_BFu7s_BFu8i");
    static STRUCT_IF_C Ui_BFu7s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu8i, Ui_BFu7s_BFu8i)
//============================================================================


struct  Ui_BFu7s_BFu8ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 Ui_BFu7s_BFu8ll) C1{ Fi Fs:7 FL:8}



static void Test_Ui_BFu7s_BFu8ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu8ll");
    static STRUCT_IF_C Ui_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu8ll, Ui_BFu7s_BFu8ll)
//============================================================================


struct  Ui_BFu7s_BFu8s  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 Ui_BFu7s_BFu8s) C1{ Fi Fs:7 Fs:8}



static void Test_Ui_BFu7s_BFu8s()
{
  {
    init_simple_test("Ui_BFu7s_BFu8s");
    static STRUCT_IF_C Ui_BFu7s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Ui_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Ui_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu8s, Ui_BFu7s_BFu8s)
//============================================================================


struct  Ui_BFu7s_BFu9i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 Ui_BFu7s_BFu9i) C1{ Fi Fs:7 Fi:9}



static void Test_Ui_BFu7s_BFu9i()
{
  {
    init_simple_test("Ui_BFu7s_BFu9i");
    static STRUCT_IF_C Ui_BFu7s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu9i, Ui_BFu7s_BFu9i)
//============================================================================


struct  Ui_BFu7s_BFu9ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 Ui_BFu7s_BFu9ll) C1{ Fi Fs:7 FL:9}



static void Test_Ui_BFu7s_BFu9ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu9ll");
    static STRUCT_IF_C Ui_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Ui_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Ui_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_BFu7s_BFu9ll, Ui_BFu7s_BFu9ll)
//============================================================================


struct  Ui_BFu7s_BFu9s  {
  unsigned int v