// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  L_Ui_BFu16i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3:16;
};
//SIG(1 L_Ui_BFu16i) C1{ FL Fi Fi:16}



static void Test_L_Ui_BFu16i()
{
  {
    init_simple_test("L_Ui_BFu16i");
    static STRUCT_IF_C L_Ui_BFu16i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_Ui_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu16i, L_Ui_BFu16i)
//============================================================================


struct  L_Ui_BFu16ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:16;
};
//SIG(1 L_Ui_BFu16ll) C1{ FL Fi FL:16}



static void Test_L_Ui_BFu16ll()
{
  {
    init_simple_test("L_Ui_BFu16ll");
    static STRUCT_IF_C L_Ui_BFu16ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu16ll, L_Ui_BFu16ll)
//============================================================================


struct  L_Ui_BFu16s  {
  __tsi64 v1;
  unsigned int v2;
  unsigned short v3:16;
};
//SIG(1 L_Ui_BFu16s) C1{ FL Fi Fs:16}



static void Test_L_Ui_BFu16s()
{
  {
    init_simple_test("L_Ui_BFu16s");
    static STRUCT_IF_C L_Ui_BFu16s lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_Ui_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu16s, L_Ui_BFu16s)
//============================================================================


struct  L_Ui_BFu17i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3:17;
};
//SIG(1 L_Ui_BFu17i) C1{ FL Fi Fi:17}



static void Test_L_Ui_BFu17i()
{
  {
    init_simple_test("L_Ui_BFu17i");
    static STRUCT_IF_C L_Ui_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_Ui_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu17i, L_Ui_BFu17i)
//============================================================================


struct  L_Ui_BFu17ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:17;
};
//SIG(1 L_Ui_BFu17ll) C1{ FL Fi FL:17}



static void Test_L_Ui_BFu17ll()
{
  {
    init_simple_test("L_Ui_BFu17ll");
    static STRUCT_IF_C L_Ui_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu17ll, L_Ui_BFu17ll)
//============================================================================


struct  L_Ui_BFu1c  {
  __tsi64 v1;
  unsigned int v2;
  unsigned char v3:1;
};
//SIG(1 L_Ui_BFu1c) C1{ FL Fi Fc:1}



static void Test_L_Ui_BFu1c()
{
  {
    init_simple_test("L_Ui_BFu1c");
    static STRUCT_IF_C L_Ui_BFu1c lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu1c, L_Ui_BFu1c)
//============================================================================


struct  L_Ui_BFu1i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3:1;
};
//SIG(1 L_Ui_BFu1i) C1{ FL Fi Fi:1}



static void Test_L_Ui_BFu1i()
{
  {
    init_simple_test("L_Ui_BFu1i");
    static STRUCT_IF_C L_Ui_BFu1i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu1i, L_Ui_BFu1i)
//============================================================================


struct  L_Ui_BFu1ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:1;
};
//SIG(1 L_Ui_BFu1ll) C1{ FL Fi FL:1}



static void Test_L_Ui_BFu1ll()
{
  {
    init_simple_test("L_Ui_BFu1ll");
    static STRUCT_IF_C L_Ui_BFu1ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu1ll, L_Ui_BFu1ll)
//============================================================================


struct  L_Ui_BFu1s  {
  __tsi64 v1;
  unsigned int v2;
  unsigned short v3:1;
};
//SIG(1 L_Ui_BFu1s) C1{ FL Fi Fs:1}



static void Test_L_Ui_BFu1s()
{
  {
    init_simple_test("L_Ui_BFu1s");
    static STRUCT_IF_C L_Ui_BFu1s lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu1s, L_Ui_BFu1s)
//============================================================================


struct  L_Ui_BFu31i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3:31;
};
//SIG(1 L_Ui_BFu31i) C1{ FL Fi Fi:31}



static void Test_L_Ui_BFu31i()
{
  {
    init_simple_test("L_Ui_BFu31i");
    static STRUCT_IF_C L_Ui_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_Ui_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu31i, L_Ui_BFu31i)
//============================================================================


struct  L_Ui_BFu31ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:31;
};
//SIG(1 L_Ui_BFu31ll) C1{ FL Fi FL:31}



static void Test_L_Ui_BFu31ll()
{
  {
    init_simple_test("L_Ui_BFu31ll");
    static STRUCT_IF_C L_Ui_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu31ll, L_Ui_BFu31ll)
//============================================================================


struct  L_Ui_BFu32i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3:32;
};
//SIG(1 L_Ui_BFu32i) C1{ FL Fi Fi:32}



static void Test_L_Ui_BFu32i()
{
  {
    init_simple_test("L_Ui_BFu32i");
    static STRUCT_IF_C L_Ui_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_Ui_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu32i, L_Ui_BFu32i)
//============================================================================


struct  L_Ui_BFu32ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:32;
};
//SIG(1 L_Ui_BFu32ll) C1{ FL Fi FL:32}



static void Test_L_Ui_BFu32ll()
{
  {
    init_simple_test("L_Ui_BFu32ll");
    static STRUCT_IF_C L_Ui_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu32ll, L_Ui_BFu32ll)
//============================================================================


struct  L_Ui_BFu33  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:33;
};
//SIG(1 L_Ui_BFu33) C1{ FL Fi FL:33}



static void Test_L_Ui_BFu33()
{
  {
    init_simple_test("L_Ui_BFu33");
    static STRUCT_IF_C L_Ui_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ui_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "L_Ui_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "L_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu33, L_Ui_BFu33)
//============================================================================


struct  L_Ui_BFu7c  {
  __tsi64 v1;
  unsigned int v2;
  unsigned char v3:7;
};
//SIG(1 L_Ui_BFu7c) C1{ FL Fi Fc:7}



static void Test_L_Ui_BFu7c()
{
  {
    init_simple_test("L_Ui_BFu7c");
    static STRUCT_IF_C L_Ui_BFu7c lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_Ui_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu7c, L_Ui_BFu7c)
//============================================================================


struct  L_Ui_BFu7i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3:7;
};
//SIG(1 L_Ui_BFu7i) C1{ FL Fi Fi:7}



static void Test_L_Ui_BFu7i()
{
  {
    init_simple_test("L_Ui_BFu7i");
    static STRUCT_IF_C L_Ui_BFu7i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_Ui_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu7i, L_Ui_BFu7i)
//============================================================================


struct  L_Ui_BFu7ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:7;
};
//SIG(1 L_Ui_BFu7ll) C1{ FL Fi FL:7}



static void Test_L_Ui_BFu7ll()
{
  {
    init_simple_test("L_Ui_BFu7ll");
    static STRUCT_IF_C L_Ui_BFu7ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu7ll, L_Ui_BFu7ll)
//============================================================================


struct  L_Ui_BFu7s  {
  __tsi64 v1;
  unsigned int v2;
  unsigned short v3:7;
};
//SIG(1 L_Ui_BFu7s) C1{ FL Fi Fs:7}



static void Test_L_Ui_BFu7s()
{
  {
    init_simple_test("L_Ui_BFu7s");
    static STRUCT_IF_C L_Ui_BFu7s lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_Ui_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu7s, L_Ui_BFu7s)
//============================================================================


struct  L_Ui_BFu8c  {
  __tsi64 v1;
  unsigned int v2;
  unsigned char v3:8;
};
//SIG(1 L_Ui_BFu8c) C1{ FL Fi Fc:8}



static void Test_L_Ui_BFu8c()
{
  {
    init_simple_test("L_Ui_BFu8c");
    static STRUCT_IF_C L_Ui_BFu8c lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_Ui_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu8c, L_Ui_BFu8c)
//============================================================================


struct  L_Ui_BFu8i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3:8;
};
//SIG(1 L_Ui_BFu8i) C1{ FL Fi Fi:8}



static void Test_L_Ui_BFu8i()
{
  {
    init_simple_test("L_Ui_BFu8i");
    static STRUCT_IF_C L_Ui_BFu8i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_Ui_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu8i, L_Ui_BFu8i)
//============================================================================


struct  L_Ui_BFu8ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:8;
};
//SIG(1 L_Ui_BFu8ll) C1{ FL Fi FL:8}



static void Test_L_Ui_BFu8ll()
{
  {
    init_simple_test("L_Ui_BFu8ll");
    static STRUCT_IF_C L_Ui_BFu8ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu8ll, L_Ui_BFu8ll)
//============================================================================


struct  L_Ui_BFu8s  {
  __tsi64 v1;
  unsigned int v2;
  unsigned short v3:8;
};
//SIG(1 L_Ui_BFu8s) C1{ FL Fi Fs:8}



static void Test_L_Ui_BFu8s()
{
  {
    init_simple_test("L_Ui_BFu8s");
    static STRUCT_IF_C L_Ui_BFu8s lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_Ui_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu8s, L_Ui_BFu8s)
//============================================================================


struct  L_Ui_BFu9i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3:9;
};
//SIG(1 L_Ui_BFu9i) C1{ FL Fi Fi:9}



static void Test_L_Ui_BFu9i()
{
  {
    init_simple_test("L_Ui_BFu9i");
    static STRUCT_IF_C L_Ui_BFu9i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_Ui_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu9i, L_Ui_BFu9i)
//============================================================================


struct  L_Ui_BFu9ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3:9;
};
//SIG(1 L_Ui_BFu9ll) C1{ FL Fi FL:9}



static void Test_L_Ui_BFu9ll()
{
  {
    init_simple_test("L_Ui_BFu9ll");
    static STRUCT_IF_C L_Ui_BFu9ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu9ll, L_Ui_BFu9ll)
//============================================================================


struct  L_Ui_BFu9s  {
  __tsi64 v1;
  unsigned int v2;
  unsigned short v3:9;
};
//SIG(1 L_Ui_BFu9s) C1{ FL Fi Fs:9}



static void Test_L_Ui_BFu9s()
{
  {
    init_simple_test("L_Ui_BFu9s");
    static STRUCT_IF_C L_Ui_BFu9s lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_Ui_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu9s, L_Ui_BFu9s)
//============================================================================


struct  L_Ui_C  {
  __tsi64 v1;
  unsigned int v2;
  char v3;
};
//SIG(1 L_Ui_C) C1{ FL Fi Fc}



static void Test_L_Ui_C()
{
  {
    init_simple_test("L_Ui_C");
    STRUCT_IF_C L_Ui_C lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_C)");
    check_field_offset(lv, v1, 0, "L_Ui_C.v1");
    check_field_offset(lv, v2, 8, "L_Ui_C.v2");
    check_field_offset(lv, v3, 12, "L_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_C, L_Ui_C)
//============================================================================


struct  L_Ui_D  {
  __tsi64 v1;
  unsigned int v2;
  double v3;
};
//SIG(1 L_Ui_D) C1{ FL Fi FL}



static void Test_L_Ui_D()
{
  {
    init_simple_test("L_Ui_D");
    STRUCT_IF_C L_Ui_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ui_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_D)");
    check_field_offset(lv, v1, 0, "L_Ui_D.v1");
    check_field_offset(lv, v2, 8, "L_Ui_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_D, L_Ui_D)
//============================================================================


struct  L_Ui_F  {
  __tsi64 v1;
  unsigned int v2;
  float v3;
};
//SIG(1 L_Ui_F) C1{ FL Fi[2]}



static void Test_L_Ui_F()
{
  {
    init_simple_test("L_Ui_F");
    STRUCT_IF_C L_Ui_F lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_F)");
    check_field_offset(lv, v1, 0, "L_Ui_F.v1");
    check_field_offset(lv, v2, 8, "L_Ui_F.v2");
    check_field_offset(lv, v3, 12, "L_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_F, L_Ui_F)
//============================================================================


struct  L_Ui_I  {
  __tsi64 v1;
  unsigned int v2;
  int v3;
};
//SIG(1 L_Ui_I) C1{ FL Fi[2]}



static void Test_L_Ui_I()
{
  {
    init_simple_test("L_Ui_I");
    STRUCT_IF_C L_Ui_I lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_I)");
    check_field_offset(lv, v1, 0, "L_Ui_I.v1");
    check_field_offset(lv, v2, 8, "L_Ui_I.v2");
    check_field_offset(lv, v3, 12, "L_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_I, L_Ui_I)
//============================================================================


struct  L_Ui_Ip  {
  __tsi64 v1;
  unsigned int v2;
  int *v3;
};
//SIG(1 L_Ui_Ip) C1{ FL Fi Fp}



static void Test_L_Ui_Ip()
{
  {
    init_simple_test("L_Ui_Ip");
    STRUCT_IF_C L_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Ui_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_Ip)");
    check_field_offset(lv, v1, 0, "L_Ui_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Ip, L_Ui_Ip)
//============================================================================


struct  L_Ui_L  {
  __tsi64 v1;
  unsigned int v2;
  __tsi64 v3;
};
//SIG(1 L_Ui_L) C1{ FL Fi FL}



static void Test_L_Ui_L()
{
  {
    init_simple_test("L_Ui_L");
    STRUCT_IF_C L_Ui_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ui_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_L)");
    check_field_offset(lv, v1, 0, "L_Ui_L.v1");
    check_field_offset(lv, v2, 8, "L_Ui_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_L, L_Ui_L)
//============================================================================


struct  L_Ui_S  {
  __tsi64 v1;
  unsigned int v2;
  short v3;
};
//SIG(1 L_Ui_S) C1{ FL Fi Fs}



static void Test_L_Ui_S()
{
  {
    init_simple_test("L_Ui_S");
    STRUCT_IF_C L_Ui_S lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_S)");
    check_field_offset(lv, v1, 0, "L_Ui_S.v1");
    check_field_offset(lv, v2, 8, "L_Ui_S.v2");
    check_field_offset(lv, v3, 12, "L_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_S, L_Ui_S)
//============================================================================


struct  L_Ui_Uc  {
  __tsi64 v1;
  unsigned int v2;
  unsigned char v3;
};
//SIG(1 L_Ui_Uc) C1{ FL Fi Fc}



static void Test_L_Ui_Uc()
{
  {
    init_simple_test("L_Ui_Uc");
    STRUCT_IF_C L_Ui_Uc lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_Uc)");
    check_field_offset(lv, v1, 0, "L_Ui_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Uc.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Uc, L_Ui_Uc)
//============================================================================


struct  L_Ui_Ui  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int v3;
};
//SIG(1 L_Ui_Ui) C1{ FL Fi[2]}



static void Test_L_Ui_Ui()
{
  {
    init_simple_test("L_Ui_Ui");
    STRUCT_IF_C L_Ui_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_Ui)");
    check_field_offset(lv, v1, 0, "L_Ui_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Ui.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Ui, L_Ui_Ui)
//============================================================================


struct  L_Ui_Ul  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64 v3;
};
//SIG(1 L_Ui_Ul) C1{ FL Fi FL}



static void Test_L_Ui_Ul()
{
  {
    init_simple_test("L_Ui_Ul");
    STRUCT_IF_C L_Ui_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ui_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_Ul)");
    check_field_offset(lv, v1, 0, "L_Ui_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Ul, L_Ui_Ul)
//============================================================================


struct  L_Ui_Us  {
  __tsi64 v1;
  unsigned int v2;
  unsigned short v3;
};
//SIG(1 L_Ui_Us) C1{ FL Fi Fs}



static void Test_L_Ui_Us()
{
  {
    init_simple_test("L_Ui_Us");
    STRUCT_IF_C L_Ui_Us lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_Us)");
    check_field_offset(lv, v1, 0, "L_Ui_Us.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Us.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Us, L_Ui_Us)
//============================================================================


struct  L_Ui_Vp  {
  __tsi64 v1;
  unsigned int v2;
  void *v3;
};
//SIG(1 L_Ui_Vp) C1{ FL Fi Fp}



static void Test_L_Ui_Vp()
{
  {
    init_simple_test("L_Ui_Vp");
    STRUCT_IF_C L_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Ui_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_Vp)");
    check_field_offset(lv, v1, 0, "L_Ui_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Vp, L_Ui_Vp)
//============================================================================


struct  L_Ul  {
  __tsi64 v1;
  __tsu64 v2;
};
//SIG(1 L_Ul) C1{ FL[2]}



static void Test_L_Ul()
{
  {
    init_simple_test("L_Ul");
    STRUCT_IF_C L_Ul lv;
    check2(sizeof(lv), 16, "sizeof(L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul)");
    check_field_offset(lv, v1, 0, "L_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul, L_Ul)
//============================================================================


struct  L_Ul_BFu15i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:15;
};
//SIG(1 L_Ul_BFu15i) C1{ FL[2] Fi:15}



static void Test_L_Ul_BFu15i()
{
  {
    init_simple_test("L_Ul_BFu15i");
    static STRUCT_IF_C L_Ul_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_Ul_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu15i, L_Ul_BFu15i)
//============================================================================


struct  L_Ul_BFu15ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:15;
};
//SIG(1 L_Ul_BFu15ll) C1{ FL[2] FL:15}



static void Test_L_Ul_BFu15ll()
{
  {
    init_simple_test("L_Ul_BFu15ll");
    static STRUCT_IF_C L_Ul_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu15ll, L_Ul_BFu15ll)
//============================================================================


struct  L_Ul_BFu15s  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned short v3:15;
};
//SIG(1 L_Ul_BFu15s) C1{ FL[2] Fs:15}



static void Test_L_Ul_BFu15s()
{
  {
    init_simple_test("L_Ul_BFu15s");
    static STRUCT_IF_C L_Ul_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_Ul_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu15s, L_Ul_BFu15s)
//============================================================================


struct  L_Ul_BFu16i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:16;
};
//SIG(1 L_Ul_BFu16i) C1{ FL[2] Fi:16}



static void Test_L_Ul_BFu16i()
{
  {
    init_simple_test("L_Ul_BFu16i");
    static STRUCT_IF_C L_Ul_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_Ul_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu16i, L_Ul_BFu16i)
//============================================================================


struct  L_Ul_BFu16ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:16;
};
//SIG(1 L_Ul_BFu16ll) C1{ FL[2] FL:16}



static void Test_L_Ul_BFu16ll()
{
  {
    init_simple_test("L_Ul_BFu16ll");
    static STRUCT_IF_C L_Ul_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu16ll, L_Ul_BFu16ll)
//============================================================================


struct  L_Ul_BFu16s  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned short v3:16;
};
//SIG(1 L_Ul_BFu16s) C1{ FL[2] Fs:16}



static void Test_L_Ul_BFu16s()
{
  {
    init_simple_test("L_Ul_BFu16s");
    static STRUCT_IF_C L_Ul_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_Ul_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu16s, L_Ul_BFu16s)
//============================================================================


struct  L_Ul_BFu17i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:17;
};
//SIG(1 L_Ul_BFu17i) C1{ FL[2] Fi:17}



static void Test_L_Ul_BFu17i()
{
  {
    init_simple_test("L_Ul_BFu17i");
    static STRUCT_IF_C L_Ul_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "L_Ul_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "L_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu17i, L_Ul_BFu17i)
//============================================================================


struct  L_Ul_BFu17ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:17;
};
//SIG(1 L_Ul_BFu17ll) C1{ FL[2] FL:17}



static void Test_L_Ul_BFu17ll()
{
  {
    init_simple_test("L_Ul_BFu17ll");
    static STRUCT_IF_C L_Ul_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "L_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "L_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu17ll, L_Ul_BFu17ll)
//============================================================================


struct  L_Ul_BFu1c  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned char v3:1;
};
//SIG(1 L_Ul_BFu1c) C1{ FL[2] Fc:1}



static void Test_L_Ul_BFu1c()
{
  {
    init_simple_test("L_Ul_BFu1c");
    static STRUCT_IF_C L_Ul_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu1c, L_Ul_BFu1c)
//============================================================================


struct  L_Ul_BFu1i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:1;
};
//SIG(1 L_Ul_BFu1i) C1{ FL[2] Fi:1}



static void Test_L_Ul_BFu1i()
{
  {
    init_simple_test("L_Ul_BFu1i");
    static STRUCT_IF_C L_Ul_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu1i, L_Ul_BFu1i)
//============================================================================


struct  L_Ul_BFu1ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:1;
};
//SIG(1 L_Ul_BFu1ll) C1{ FL[2] FL:1}



static void Test_L_Ul_BFu1ll()
{
  {
    init_simple_test("L_Ul_BFu1ll");
    static STRUCT_IF_C L_Ul_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu1ll, L_Ul_BFu1ll)
//============================================================================


struct  L_Ul_BFu1s  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned short v3:1;
};
//SIG(1 L_Ul_BFu1s) C1{ FL[2] Fs:1}



static void Test_L_Ul_BFu1s()
{
  {
    init_simple_test("L_Ul_BFu1s");
    static STRUCT_IF_C L_Ul_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu1s, L_Ul_BFu1s)
//============================================================================


struct  L_Ul_BFu31i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:31;
};
//SIG(1 L_Ul_BFu31i) C1{ FL[2] Fi:31}



static void Test_L_Ul_BFu31i()
{
  {
    init_simple_test("L_Ul_BFu31i");
    static STRUCT_IF_C L_Ul_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "L_Ul_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "L_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu31i, L_Ul_BFu31i)
//============================================================================


struct  L_Ul_BFu31ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:31;
};
//SIG(1 L_Ul_BFu31ll) C1{ FL[2] FL:31}



static void Test_L_Ul_BFu31ll()
{
  {
    init_simple_test("L_Ul_BFu31ll");
    static STRUCT_IF_C L_Ul_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "L_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "L_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu31ll, L_Ul_BFu31ll)
//============================================================================


struct  L_Ul_BFu32i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:32;
};
//SIG(1 L_Ul_BFu32i) C1{ FL[2] Fi:32}



static void Test_L_Ul_BFu32i()
{
  {
    init_simple_test("L_Ul_BFu32i");
    static STRUCT_IF_C L_Ul_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "L_Ul_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "L_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu32i, L_Ul_BFu32i)
//============================================================================


struct  L_Ul_BFu32ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:32;
};
//SIG(1 L_Ul_BFu32ll) C1{ FL[2] FL:32}



static void Test_L_Ul_BFu32ll()
{
  {
    init_simple_test("L_Ul_BFu32ll");
    static STRUCT_IF_C L_Ul_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "L_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "L_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu32ll, L_Ul_BFu32ll)
//============================================================================


struct  L_Ul_BFu33  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:33;
};
//SIG(1 L_Ul_BFu33) C1{ FL[2] FL:33}



static void Test_L_Ul_BFu33()
{
  {
    init_simple_test("L_Ul_BFu33");
    static STRUCT_IF_C L_Ul_BFu33 lv;
    check2(sizeof(lv), 24, "sizeof(L_Ul_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "L_Ul_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "L_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu33, L_Ul_BFu33)
//============================================================================


struct  L_Ul_BFu7c  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned char v3:7;
};
//SIG(1 L_Ul_BFu7c) C1{ FL[2] Fc:7}



static void Test_L_Ul_BFu7c()
{
  {
    init_simple_test("L_Ul_BFu7c");
    static STRUCT_IF_C L_Ul_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_Ul_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu7c, L_Ul_BFu7c)
//============================================================================


struct  L_Ul_BFu7i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:7;
};
//SIG(1 L_Ul_BFu7i) C1{ FL[2] Fi:7}



static void Test_L_Ul_BFu7i()
{
  {
    init_simple_test("L_Ul_BFu7i");
    static STRUCT_IF_C L_Ul_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_Ul_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu7i, L_Ul_BFu7i)
//============================================================================


struct  L_Ul_BFu7ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:7;
};
//SIG(1 L_Ul_BFu7ll) C1{ FL[2] FL:7}



static void Test_L_Ul_BFu7ll()
{
  {
    init_simple_test("L_Ul_BFu7ll");
    static STRUCT_IF_C L_Ul_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu7ll, L_Ul_BFu7ll)
//============================================================================


struct  L_Ul_BFu7s  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned short v3:7;
};
//SIG(1 L_Ul_BFu7s) C1{ FL[2] Fs:7}



static void Test_L_Ul_BFu7s()
{
  {
    init_simple_test("L_Ul_BFu7s");
    static STRUCT_IF_C L_Ul_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_Ul_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu7s, L_Ul_BFu7s)
//============================================================================


struct  L_Ul_BFu8c  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned char v3:8;
};
//SIG(1 L_Ul_BFu8c) C1{ FL[2] Fc:8}



static void Test_L_Ul_BFu8c()
{
  {
    init_simple_test("L_Ul_BFu8c");
    static STRUCT_IF_C L_Ul_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_Ul_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu8c, L_Ul_BFu8c)
//============================================================================


struct  L_Ul_BFu8i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:8;
};
//SIG(1 L_Ul_BFu8i) C1{ FL[2] Fi:8}



static void Test_L_Ul_BFu8i()
{
  {
    init_simple_test("L_Ul_BFu8i");
    static STRUCT_IF_C L_Ul_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_Ul_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu8i, L_Ul_BFu8i)
//============================================================================


struct  L_Ul_BFu8ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:8;
};
//SIG(1 L_Ul_BFu8ll) C1{ FL[2] FL:8}



static void Test_L_Ul_BFu8ll()
{
  {
    init_simple_test("L_Ul_BFu8ll");
    static STRUCT_IF_C L_Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu8ll, L_Ul_BFu8ll)
//============================================================================


struct  L_Ul_BFu8s  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned short v3:8;
};
//SIG(1 L_Ul_BFu8s) C1{ FL[2] Fs:8}



static void Test_L_Ul_BFu8s()
{
  {
    init_simple_test("L_Ul_BFu8s");
    static STRUCT_IF_C L_Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_Ul_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu8s, L_Ul_BFu8s)
//============================================================================


struct  L_Ul_BFu9i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3:9;
};
//SIG(1 L_Ul_BFu9i) C1{ FL[2] Fi:9}



static void Test_L_Ul_BFu9i()
{
  {
    init_simple_test("L_Ul_BFu9i");
    static STRUCT_IF_C L_Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_Ul_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu9i, L_Ul_BFu9i)
//============================================================================


struct  L_Ul_BFu9ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3:9;
};
//SIG(1 L_Ul_BFu9ll) C1{ FL[2] FL:9}



static void Test_L_Ul_BFu9ll()
{
  {
    init_simple_test("L_Ul_BFu9ll");
    static STRUCT_IF_C L_Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu9ll, L_Ul_BFu9ll)
//============================================================================


struct  L_Ul_BFu9s  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned short v3:9;
};
//SIG(1 L_Ul_BFu9s) C1{ FL[2] Fs:9}



static void Test_L_Ul_BFu9s()
{
  {
    init_simple_test("L_Ul_BFu9s");
    static STRUCT_IF_C L_Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_Ul_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu9s, L_Ul_BFu9s)
//============================================================================


struct  L_Ul_C  {
  __tsi64 v1;
  __tsu64 v2;
  char v3;
};
//SIG(1 L_Ul_C) C1{ FL[2] Fc}



static void Test_L_Ul_C()
{
  {
    init_simple_test("L_Ul_C");
    STRUCT_IF_C L_Ul_C lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_C)");
    check_field_offset(lv, v1, 0, "L_Ul_C.v1");
    check_field_offset(lv, v2, 8, "L_Ul_C.v2");
    check_field_offset(lv, v3, 16, "L_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_C, L_Ul_C)
//============================================================================


struct  L_Ul_D  {
  __tsi64 v1;
  __tsu64 v2;
  double v3;
};
//SIG(1 L_Ul_D) C1{ FL[3]}



static void Test_L_Ul_D()
{
  {
    init_simple_test("L_Ul_D");
    STRUCT_IF_C L_Ul_D lv;
    check2(sizeof(lv), 24, "sizeof(L_Ul_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_D)");
    check_field_offset(lv, v1, 0, "L_Ul_D.v1");
    check_field_offset(lv, v2, 8, "L_Ul_D.v2");
    check_field_offset(lv, v3, 16, "L_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_D, L_Ul_D)
//============================================================================


struct  L_Ul_F  {
  __tsi64 v1;
  __tsu64 v2;
  float v3;
};
//SIG(1 L_Ul_F) C1{ FL[2] Fi}



static void Test_L_Ul_F()
{
  {
    init_simple_test("L_Ul_F");
    STRUCT_IF_C L_Ul_F lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_F)");
    check_field_offset(lv, v1, 0, "L_Ul_F.v1");
    check_field_offset(lv, v2, 8, "L_Ul_F.v2");
    check_field_offset(lv, v3, 16, "L_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_F, L_Ul_F)
//============================================================================


struct  L_Ul_I  {
  __tsi64 v1;
  __tsu64 v2;
  int v3;
};
//SIG(1 L_Ul_I) C1{ FL[2] Fi}



static void Test_L_Ul_I()
{
  {
    init_simple_test("L_Ul_I");
    STRUCT_IF_C L_Ul_I lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_I)");
    check_field_offset(lv, v1, 0, "L_Ul_I.v1");
    check_field_offset(lv, v2, 8, "L_Ul_I.v2");
    check_field_offset(lv, v3, 16, "L_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_I, L_Ul_I)
//============================================================================


struct  L_Ul_Ip  {
  __tsi64 v1;
  __tsu64 v2;
  int *v3;
};
//SIG(1 L_Ul_Ip) C1{ FL[2] Fp}



static void Test_L_Ul_Ip()
{
  {
    init_simple_test("L_Ul_Ip");
    STRUCT_IF_C L_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_Ip)");
    check_field_offset(lv, v1, 0, "L_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Ip.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Ip, L_Ul_Ip)
//============================================================================


struct  L_Ul_L  {
  __tsi64 v1;
  __tsu64 v2;
  __tsi64 v3;
};
//SIG(1 L_Ul_L) C1{ FL[3]}



static void Test_L_Ul_L()
{
  {
    init_simple_test("L_Ul_L");
    STRUCT_IF_C L_Ul_L lv;
    check2(sizeof(lv), 24, "sizeof(L_Ul_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_L)");
    check_field_offset(lv, v1, 0, "L_Ul_L.v1");
    check_field_offset(lv, v2, 8, "L_Ul_L.v2");
    check_field_offset(lv, v3, 16, "L_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_L, L_Ul_L)
//============================================================================


struct  L_Ul_S  {
  __tsi64 v1;
  __tsu64 v2;
  short v3;
};
//SIG(1 L_Ul_S) C1{ FL[2] Fs}



static void Test_L_Ul_S()
{
  {
    init_simple_test("L_Ul_S");
    STRUCT_IF_C L_Ul_S lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_S)");
    check_field_offset(lv, v1, 0, "L_Ul_S.v1");
    check_field_offset(lv, v2, 8, "L_Ul_S.v2");
    check_field_offset(lv, v3, 16, "L_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_S, L_Ul_S)
//============================================================================


struct  L_Ul_Uc  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned char v3;
};
//SIG(1 L_Ul_Uc) C1{ FL[2] Fc}



static void Test_L_Ul_Uc()
{
  {
    init_simple_test("L_Ul_Uc");
    STRUCT_IF_C L_Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_Uc)");
    check_field_offset(lv, v1, 0, "L_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Uc.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Uc, L_Ul_Uc)
//============================================================================


struct  L_Ul_Ui  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int v3;
};
//SIG(1 L_Ul_Ui) C1{ FL[2] Fi}



static void Test_L_Ul_Ui()
{
  {
    init_simple_test("L_Ul_Ui");
    STRUCT_IF_C L_Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_Ui)");
    check_field_offset(lv, v1, 0, "L_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Ui.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Ui, L_Ul_Ui)
//============================================================================


struct  L_Ul_Ul  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64 v3;
};
//SIG(1 L_Ul_Ul) C1{ FL[3]}



static void Test_L_Ul_Ul()
{
  {
    init_simple_test("L_Ul_Ul");
    STRUCT_IF_C L_Ul_Ul lv;
    check2(sizeof(lv), 24, "sizeof(L_Ul_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_Ul)");
    check_field_offset(lv, v1, 0, "L_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Ul.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Ul, L_Ul_Ul)
//============================================================================


struct  L_Ul_Us  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned short v3;
};
//SIG(1 L_Ul_Us) C1{ FL[2] Fs}



static void Test_L_Ul_Us()
{
  {
    init_simple_test("L_Ul_Us");
    STRUCT_IF_C L_Ul_Us lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_Us)");
    check_field_offset(lv, v1, 0, "L_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Us.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Us, L_Ul_Us)
//============================================================================


struct  L_Ul_Vp  {
  __tsi64 v1;
  __tsu64 v2;
  void *v3;
};
//SIG(1 L_Ul_Vp) C1{ FL[2] Fp}



static void Test_L_Ul_Vp()
{
  {
    init_simple_test("L_Ul_Vp");
    STRUCT_IF_C L_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_Vp)");
    check_field_offset(lv, v1, 0, "L_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Vp.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Vp, L_Ul_Vp)
//============================================================================


struct  L_Us  {
  __tsi64 v1;
  unsigned short v2;
};
//SIG(1 L_Us) C1{ FL Fs}



static void Test_L_Us()
{
  {
    init_simple_test("L_Us");
    STRUCT_IF_C L_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us)");
    check_field_offset(lv, v1, 0, "L_Us.v1");
    check_field_offset(lv, v2, 8, "L_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us, L_Us)
//============================================================================


struct  L_Us_BFu15i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:15;
};
//SIG(1 L_Us_BFu15i) C1{ FL Fs Fi:15}



static void Test_L_Us_BFu15i()
{
  {
    init_simple_test("L_Us_BFu15i");
    static STRUCT_IF_C L_Us_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_Us_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu15i, L_Us_BFu15i)
//============================================================================


struct  L_Us_BFu15ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:15;
};
//SIG(1 L_Us_BFu15ll) C1{ FL Fs FL:15}



static void Test_L_Us_BFu15ll()
{
  {
    init_simple_test("L_Us_BFu15ll");
    static STRUCT_IF_C L_Us_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_Us_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu15ll, L_Us_BFu15ll)
//============================================================================


struct  L_Us_BFu15s  {
  __tsi64 v1;
  unsigned short v2;
  unsigned short v3:15;
};
//SIG(1 L_Us_BFu15s) C1{ FL Fs Fs:15}



static void Test_L_Us_BFu15s()
{
  {
    init_simple_test("L_Us_BFu15s");
    static STRUCT_IF_C L_Us_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_Us_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu15s, L_Us_BFu15s)
//============================================================================


struct  L_Us_BFu16i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:16;
};
//SIG(1 L_Us_BFu16i) C1{ FL Fs Fi:16}



static void Test_L_Us_BFu16i()
{
  {
    init_simple_test("L_Us_BFu16i");
    static STRUCT_IF_C L_Us_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_Us_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu16i, L_Us_BFu16i)
//============================================================================


struct  L_Us_BFu16ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:16;
};
//SIG(1 L_Us_BFu16ll) C1{ FL Fs FL:16}



static void Test_L_Us_BFu16ll()
{
  {
    init_simple_test("L_Us_BFu16ll");
    static STRUCT_IF_C L_Us_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_Us_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu16ll, L_Us_BFu16ll)
//============================================================================


struct  L_Us_BFu16s  {
  __tsi64 v1;
  unsigned short v2;
  unsigned short v3:16;
};
//SIG(1 L_Us_BFu16s) C1{ FL Fs Fs:16}



static void Test_L_Us_BFu16s()
{
  {
    init_simple_test("L_Us_BFu16s");
    static STRUCT_IF_C L_Us_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_Us_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu16s, L_Us_BFu16s)
//============================================================================


struct  L_Us_BFu17i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:17;
};
//SIG(1 L_Us_BFu17i) C1{ FL Fs Fi:17}



static void Test_L_Us_BFu17i()
{
  {
    init_simple_test("L_Us_BFu17i");
    static STRUCT_IF_C L_Us_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_Us_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu17i, L_Us_BFu17i)
//============================================================================


struct  L_Us_BFu17ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:17;
};
//SIG(1 L_Us_BFu17ll) C1{ FL Fs FL:17}



static void Test_L_Us_BFu17ll()
{
  {
    init_simple_test("L_Us_BFu17ll");
    static STRUCT_IF_C L_Us_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "L_Us_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "L_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu17ll, L_Us_BFu17ll)
//============================================================================


struct  L_Us_BFu1c  {
  __tsi64 v1;
  unsigned short v2;
  unsigned char v3:1;
};
//SIG(1 L_Us_BFu1c) C1{ FL Fs Fc:1}



static void Test_L_Us_BFu1c()
{
  {
    init_simple_test("L_Us_BFu1c");
    static STRUCT_IF_C L_Us_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Us_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu1c, L_Us_BFu1c)
//============================================================================


struct  L_Us_BFu1i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:1;
};
//SIG(1 L_Us_BFu1i) C1{ FL Fs Fi:1}



static void Test_L_Us_BFu1i()
{
  {
    init_simple_test("L_Us_BFu1i");
    static STRUCT_IF_C L_Us_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu1i, L_Us_BFu1i)
//============================================================================


struct  L_Us_BFu1ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:1;
};
//SIG(1 L_Us_BFu1ll) C1{ FL Fs FL:1}



static void Test_L_Us_BFu1ll()
{
  {
    init_simple_test("L_Us_BFu1ll");
    static STRUCT_IF_C L_Us_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu1ll, L_Us_BFu1ll)
//============================================================================


struct  L_Us_BFu1s  {
  __tsi64 v1;
  unsigned short v2;
  unsigned short v3:1;
};
//SIG(1 L_Us_BFu1s) C1{ FL Fs Fs:1}



static void Test_L_Us_BFu1s()
{
  {
    init_simple_test("L_Us_BFu1s");
    static STRUCT_IF_C L_Us_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu1s, L_Us_BFu1s)
//============================================================================


struct  L_Us_BFu31i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:31;
};
//SIG(1 L_Us_BFu31i) C1{ FL Fs Fi:31}



static void Test_L_Us_BFu31i()
{
  {
    init_simple_test("L_Us_BFu31i");
    static STRUCT_IF_C L_Us_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_Us_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu31i, L_Us_BFu31i)
//============================================================================


struct  L_Us_BFu31ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:31;
};
//SIG(1 L_Us_BFu31ll) C1{ FL Fs FL:31}



static void Test_L_Us_BFu31ll()
{
  {
    init_simple_test("L_Us_BFu31ll");
    static STRUCT_IF_C L_Us_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "L_Us_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "L_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu31ll, L_Us_BFu31ll)
//============================================================================


struct  L_Us_BFu32i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:32;
};
//SIG(1 L_Us_BFu32i) C1{ FL Fs Fi:32}



static void Test_L_Us_BFu32i()
{
  {
    init_simple_test("L_Us_BFu32i");
    static STRUCT_IF_C L_Us_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_Us_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu32i, L_Us_BFu32i)
//============================================================================


struct  L_Us_BFu32ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:32;
};
//SIG(1 L_Us_BFu32ll) C1{ FL Fs FL:32}



static void Test_L_Us_BFu32ll()
{
  {
    init_simple_test("L_Us_BFu32ll");
    static STRUCT_IF_C L_Us_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "L_Us_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "L_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu32ll, L_Us_BFu32ll)
//============================================================================


struct  L_Us_BFu33  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:33;
};
//SIG(1 L_Us_BFu33) C1{ FL Fs FL:33}



static void Test_L_Us_BFu33()
{
  {
    init_simple_test("L_Us_BFu33");
    static STRUCT_IF_C L_Us_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu33)");
    check_field_offset(lv, v1, 0, "L_Us_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "L_Us_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "L_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu33, L_Us_BFu33)
//============================================================================


struct  L_Us_BFu7c  {
  __tsi64 v1;
  unsigned short v2;
  unsigned char v3:7;
};
//SIG(1 L_Us_BFu7c) C1{ FL Fs Fc:7}



static void Test_L_Us_BFu7c()
{
  {
    init_simple_test("L_Us_BFu7c");
    static STRUCT_IF_C L_Us_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Us_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_Us_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu7c, L_Us_BFu7c)
//============================================================================


struct  L_Us_BFu7i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:7;
};
//SIG(1 L_Us_BFu7i) C1{ FL Fs Fi:7}



static void Test_L_Us_BFu7i()
{
  {
    init_simple_test("L_Us_BFu7i");
    static STRUCT_IF_C L_Us_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_Us_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu7i, L_Us_BFu7i)
//============================================================================


struct  L_Us_BFu7ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:7;
};
//SIG(1 L_Us_BFu7ll) C1{ FL Fs FL:7}



static void Test_L_Us_BFu7ll()
{
  {
    init_simple_test("L_Us_BFu7ll");
    static STRUCT_IF_C L_Us_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_Us_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu7ll, L_Us_BFu7ll)
//============================================================================


struct  L_Us_BFu7s  {
  __tsi64 v1;
  unsigned short v2;
  unsigned short v3:7;
};
//SIG(1 L_Us_BFu7s) C1{ FL Fs Fs:7}



static void Test_L_Us_BFu7s()
{
  {
    init_simple_test("L_Us_BFu7s");
    static STRUCT_IF_C L_Us_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_Us_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu7s, L_Us_BFu7s)
//============================================================================


struct  L_Us_BFu8c  {
  __tsi64 v1;
  unsigned short v2;
  unsigned char v3:8;
};
//SIG(1 L_Us_BFu8c) C1{ FL Fs Fc:8}



static void Test_L_Us_BFu8c()
{
  {
    init_simple_test("L_Us_BFu8c");
    static STRUCT_IF_C L_Us_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Us_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_Us_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu8c, L_Us_BFu8c)
//============================================================================


struct  L_Us_BFu8i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:8;
};
//SIG(1 L_Us_BFu8i) C1{ FL Fs Fi:8}



static void Test_L_Us_BFu8i()
{
  {
    init_simple_test("L_Us_BFu8i");
    static STRUCT_IF_C L_Us_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_Us_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu8i, L_Us_BFu8i)
//============================================================================


struct  L_Us_BFu8ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:8;
};
//SIG(1 L_Us_BFu8ll) C1{ FL Fs FL:8}



static void Test_L_Us_BFu8ll()
{
  {
    init_simple_test("L_Us_BFu8ll");
    static STRUCT_IF_C L_Us_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_Us_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu8ll, L_Us_BFu8ll)
//============================================================================


struct  L_Us_BFu8s  {
  __tsi64 v1;
  unsigned short v2;
  unsigned short v3:8;
};
//SIG(1 L_Us_BFu8s) C1{ FL Fs Fs:8}



static void Test_L_Us_BFu8s()
{
  {
    init_simple_test("L_Us_BFu8s");
    static STRUCT_IF_C L_Us_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_Us_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu8s, L_Us_BFu8s)
//============================================================================


struct  L_Us_BFu9i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3:9;
};
//SIG(1 L_Us_BFu9i) C1{ FL Fs Fi:9}



static void Test_L_Us_BFu9i()
{
  {
    init_simple_test("L_Us_BFu9i");
    static STRUCT_IF_C L_Us_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_Us_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu9i, L_Us_BFu9i)
//============================================================================


struct  L_Us_BFu9ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3:9;
};
//SIG(1 L_Us_BFu9ll) C1{ FL Fs FL:9}



static void Test_L_Us_BFu9ll()
{
  {
    init_simple_test("L_Us_BFu9ll");
    static STRUCT_IF_C L_Us_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_Us_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu9ll, L_Us_BFu9ll)
//============================================================================


struct  L_Us_BFu9s  {
  __tsi64 v1;
  unsigned short v2;
  unsigned short v3:9;
};
//SIG(1 L_Us_BFu9s) C1{ FL Fs Fs:9}



static void Test_L_Us_BFu9s()
{
  {
    init_simple_test("L_Us_BFu9s");
    static STRUCT_IF_C L_Us_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_Us_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu9s, L_Us_BFu9s)
//============================================================================


struct  L_Us_C  {
  __tsi64 v1;
  unsigned short v2;
  char v3;
};
//SIG(1 L_Us_C) C1{ FL Fs Fc}



static void Test_L_Us_C()
{
  {
    init_simple_test("L_Us_C");
    STRUCT_IF_C L_Us_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_C)");
    check_field_offset(lv, v1, 0, "L_Us_C.v1");
    check_field_offset(lv, v2, 8, "L_Us_C.v2");
    check_field_offset(lv, v3, 10, "L_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_C, L_Us_C)
//============================================================================


struct  L_Us_D  {
  __tsi64 v1;
  unsigned short v2;
  double v3;
};
//SIG(1 L_Us_D) C1{ FL Fs FL}



static void Test_L_Us_D()
{
  {
    init_simple_test("L_Us_D");
    STRUCT_IF_C L_Us_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Us_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_D)");
    check_field_offset(lv, v1, 0, "L_Us_D.v1");
    check_field_offset(lv, v2, 8, "L_Us_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_D, L_Us_D)
//============================================================================


struct  L_Us_F  {
  __tsi64 v1;
  unsigned short v2;
  float v3;
};
//SIG(1 L_Us_F) C1{ FL Fs Fi}



static void Test_L_Us_F()
{
  {
    init_simple_test("L_Us_F");
    STRUCT_IF_C L_Us_F lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_F)");
    check_field_offset(lv, v1, 0, "L_Us_F.v1");
    check_field_offset(lv, v2, 8, "L_Us_F.v2");
    check_field_offset(lv, v3, 12, "L_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_F, L_Us_F)
//============================================================================


struct  L_Us_I  {
  __tsi64 v1;
  unsigned short v2;
  int v3;
};
//SIG(1 L_Us_I) C1{ FL Fs Fi}



static void Test_L_Us_I()
{
  {
    init_simple_test("L_Us_I");
    STRUCT_IF_C L_Us_I lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_I)");
    check_field_offset(lv, v1, 0, "L_Us_I.v1");
    check_field_offset(lv, v2, 8, "L_Us_I.v2");
    check_field_offset(lv, v3, 12, "L_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_I, L_Us_I)
//============================================================================


struct  L_Us_Ip  {
  __tsi64 v1;
  unsigned short v2;
  int *v3;
};
//SIG(1 L_Us_Ip) C1{ FL Fs Fp}



static void Test_L_Us_Ip()
{
  {
    init_simple_test("L_Us_Ip");
    STRUCT_IF_C L_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Us_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_Ip)");
    check_field_offset(lv, v1, 0, "L_Us_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Us_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Ip, L_Us_Ip)
//============================================================================


struct  L_Us_L  {
  __tsi64 v1;
  unsigned short v2;
  __tsi64 v3;
};
//SIG(1 L_Us_L) C1{ FL Fs FL}



static void Test_L_Us_L()
{
  {
    init_simple_test("L_Us_L");
    STRUCT_IF_C L_Us_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Us_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_L)");
    check_field_offset(lv, v1, 0, "L_Us_L.v1");
    check_field_offset(lv, v2, 8, "L_Us_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_L, L_Us_L)
//============================================================================


struct  L_Us_S  {
  __tsi64 v1;
  unsigned short v2;
  short v3;
};
//SIG(1 L_Us_S) C1{ FL Fs[2]}



static void Test_L_Us_S()
{
  {
    init_simple_test("L_Us_S");
    STRUCT_IF_C L_Us_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_S)");
    check_field_offset(lv, v1, 0, "L_Us_S.v1");
    check_field_offset(lv, v2, 8, "L_Us_S.v2");
    check_field_offset(lv, v3, 10, "L_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_S, L_Us_S)
//============================================================================


struct  L_Us_Uc  {
  __tsi64 v1;
  unsigned short v2;
  unsigned char v3;
};
//SIG(1 L_Us_Uc) C1{ FL Fs Fc}



static void Test_L_Us_Uc()
{
  {
    init_simple_test("L_Us_Uc");
    STRUCT_IF_C L_Us_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_Uc)");
    check_field_offset(lv, v1, 0, "L_Us_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Us_Uc.v2");
    check_field_offset(lv, v3, 10, "L_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Uc, L_Us_Uc)
//============================================================================


struct  L_Us_Ui  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int v3;
};
//SIG(1 L_Us_Ui) C1{ FL Fs Fi}



static void Test_L_Us_Ui()
{
  {
    init_simple_test("L_Us_Ui");
    STRUCT_IF_C L_Us_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_Us_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_Ui)");
    check_field_offset(lv, v1, 0, "L_Us_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Us_Ui.v2");
    check_field_offset(lv, v3, 12, "L_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Ui, L_Us_Ui)
//============================================================================


struct  L_Us_Ul  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64 v3;
};
//SIG(1 L_Us_Ul) C1{ FL Fs FL}



static void Test_L_Us_Ul()
{
  {
    init_simple_test("L_Us_Ul");
    STRUCT_IF_C L_Us_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Us_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_Ul)");
    check_field_offset(lv, v1, 0, "L_Us_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Us_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Ul, L_Us_Ul)
//============================================================================


struct  L_Us_Us  {
  __tsi64 v1;
  unsigned short v2;
  unsigned short v3;
};
//SIG(1 L_Us_Us) C1{ FL Fs[2]}



static void Test_L_Us_Us()
{
  {
    init_simple_test("L_Us_Us");
    STRUCT_IF_C L_Us_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_Us)");
    check_field_offset(lv, v1, 0, "L_Us_Us.v1");
    check_field_offset(lv, v2, 8, "L_Us_Us.v2");
    check_field_offset(lv, v3, 10, "L_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Us, L_Us_Us)
//============================================================================


struct  L_Us_Vp  {
  __tsi64 v1;
  unsigned short v2;
  void *v3;
};
//SIG(1 L_Us_Vp) C1{ FL Fs Fp}



static void Test_L_Us_Vp()
{
  {
    init_simple_test("L_Us_Vp");
    STRUCT_IF_C L_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Us_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_Vp)");
    check_field_offset(lv, v1, 0, "L_Us_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Us_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Vp, L_Us_Vp)
//============================================================================


struct  L_Vp  {
  __tsi64 v1;
  void *v2;
};
//SIG(1 L_Vp) C1{ FL Fp}



static void Test_L_Vp()
{
  {
    init_simple_test("L_Vp");
    STRUCT_IF_C L_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp)");
    check_field_offset(lv, v1, 0, "L_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp, L_Vp)
//============================================================================


struct  L_Vp_BFu15i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:15;
};
//SIG(1 L_Vp_BFu15i) C1{ FL Fp Fi:15}



static void Test_L_Vp_BFu15i()
{
  {
    init_simple_test("L_Vp_BFu15i");
    static STRUCT_IF_C L_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu15i, L_Vp_BFu15i)
//============================================================================


struct  L_Vp_BFu15ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:15;
};
//SIG(1 L_Vp_BFu15ll) C1{ FL Fp FL:15}



static void Test_L_Vp_BFu15ll()
{
  {
    init_simple_test("L_Vp_BFu15ll");
    static STRUCT_IF_C L_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu15ll, L_Vp_BFu15ll)
//============================================================================


struct  L_Vp_BFu15s  {
  __tsi64 v1;
  void *v2;
  unsigned short v3:15;
};
//SIG(1 L_Vp_BFu15s) C1{ FL Fp Fs:15}



static void Test_L_Vp_BFu15s()
{
  {
    init_simple_test("L_Vp_BFu15s");
    static STRUCT_IF_C L_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu15s, L_Vp_BFu15s)
//============================================================================


struct  L_Vp_BFu16i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:16;
};
//SIG(1 L_Vp_BFu16i) C1{ FL Fp Fi:16}



static void Test_L_Vp_BFu16i()
{
  {
    init_simple_test("L_Vp_BFu16i");
    static STRUCT_IF_C L_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu16i, L_Vp_BFu16i)
//============================================================================


struct  L_Vp_BFu16ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:16;
};
//SIG(1 L_Vp_BFu16ll) C1{ FL Fp FL:16}



static void Test_L_Vp_BFu16ll()
{
  {
    init_simple_test("L_Vp_BFu16ll");
    static STRUCT_IF_C L_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu16ll, L_Vp_BFu16ll)
//============================================================================


struct  L_Vp_BFu16s  {
  __tsi64 v1;
  void *v2;
  unsigned short v3:16;
};
//SIG(1 L_Vp_BFu16s) C1{ FL Fp Fs:16}



static void Test_L_Vp_BFu16s()
{
  {
    init_simple_test("L_Vp_BFu16s");
    static STRUCT_IF_C L_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu16s, L_Vp_BFu16s)
//============================================================================


struct  L_Vp_BFu17i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:17;
};
//SIG(1 L_Vp_BFu17i) C1{ FL Fp Fi:17}



static void Test_L_Vp_BFu17i()
{
  {
    init_simple_test("L_Vp_BFu17i");
    static STRUCT_IF_C L_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "L_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "L_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu17i, L_Vp_BFu17i)
//============================================================================


struct  L_Vp_BFu17ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:17;
};
//SIG(1 L_Vp_BFu17ll) C1{ FL Fp FL:17}



static void Test_L_Vp_BFu17ll()
{
  {
    init_simple_test("L_Vp_BFu17ll");
    static STRUCT_IF_C L_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "L_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "L_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu17ll, L_Vp_BFu17ll)
//============================================================================


struct  L_Vp_BFu1c  {
  __tsi64 v1;
  void *v2;
  unsigned char v3:1;
};
//SIG(1 L_Vp_BFu1c) C1{ FL Fp Fc:1}



static void Test_L_Vp_BFu1c()
{
  {
    init_simple_test("L_Vp_BFu1c");
    static STRUCT_IF_C L_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu1c, L_Vp_BFu1c)
//============================================================================


struct  L_Vp_BFu1i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:1;
};
//SIG(1 L_Vp_BFu1i) C1{ FL Fp Fi:1}



static void Test_L_Vp_BFu1i()
{
  {
    init_simple_test("L_Vp_BFu1i");
    static STRUCT_IF_C L_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu1i, L_Vp_BFu1i)
//============================================================================


struct  L_Vp_BFu1ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:1;
};
//SIG(1 L_Vp_BFu1ll) C1{ FL Fp FL:1}



static void Test_L_Vp_BFu1ll()
{
  {
    init_simple_test("L_Vp_BFu1ll");
    static STRUCT_IF_C L_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu1ll, L_Vp_BFu1ll)
//============================================================================


struct  L_Vp_BFu1s  {
  __tsi64 v1;
  void *v2;
  unsigned short v3:1;
};
//SIG(1 L_Vp_BFu1s) C1{ FL Fp Fs:1}



static void Test_L_Vp_BFu1s()
{
  {
    init_simple_test("L_Vp_BFu1s");
    static STRUCT_IF_C L_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu1s, L_Vp_BFu1s)
//============================================================================


struct  L_Vp_BFu31i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:31;
};
//SIG(1 L_Vp_BFu31i) C1{ FL Fp Fi:31}



static void Test_L_Vp_BFu31i()
{
  {
    init_simple_test("L_Vp_BFu31i");
    static STRUCT_IF_C L_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "L_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "L_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu31i, L_Vp_BFu31i)
//============================================================================


struct  L_Vp_BFu31ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:31;
};
//SIG(1 L_Vp_BFu31ll) C1{ FL Fp FL:31}



static void Test_L_Vp_BFu31ll()
{
  {
    init_simple_test("L_Vp_BFu31ll");
    static STRUCT_IF_C L_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "L_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "L_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu31ll, L_Vp_BFu31ll)
//============================================================================


struct  L_Vp_BFu32i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:32;
};
//SIG(1 L_Vp_BFu32i) C1{ FL Fp Fi:32}



static void Test_L_Vp_BFu32i()
{
  {
    init_simple_test("L_Vp_BFu32i");
    static STRUCT_IF_C L_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "L_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "L_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu32i, L_Vp_BFu32i)
//============================================================================


struct  L_Vp_BFu32ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:32;
};
//SIG(1 L_Vp_BFu32ll) C1{ FL Fp FL:32}



static void Test_L_Vp_BFu32ll()
{
  {
    init_simple_test("L_Vp_BFu32ll");
    static STRUCT_IF_C L_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "L_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "L_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu32ll, L_Vp_BFu32ll)
//============================================================================


struct  L_Vp_BFu33  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:33;
};
//SIG(1 L_Vp_BFu33) C1{ FL Fp FL:33}



static void Test_L_Vp_BFu33()
{
  {
    init_simple_test("L_Vp_BFu33");
    static STRUCT_IF_C L_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Vp_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "L_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "L_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu33, L_Vp_BFu33)
//============================================================================


struct  L_Vp_BFu7c  {
  __tsi64 v1;
  void *v2;
  unsigned char v3:7;
};
//SIG(1 L_Vp_BFu7c) C1{ FL Fp Fc:7}



static void Test_L_Vp_BFu7c()
{
  {
    init_simple_test("L_Vp_BFu7c");
    static STRUCT_IF_C L_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu7c, L_Vp_BFu7c)
//============================================================================


struct  L_Vp_BFu7i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:7;
};
//SIG(1 L_Vp_BFu7i) C1{ FL Fp Fi:7}



static void Test_L_Vp_BFu7i()
{
  {
    init_simple_test("L_Vp_BFu7i");
    static STRUCT_IF_C L_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu7i, L_Vp_BFu7i)
//============================================================================


struct  L_Vp_BFu7ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:7;
};
//SIG(1 L_Vp_BFu7ll) C1{ FL Fp FL:7}



static void Test_L_Vp_BFu7ll()
{
  {
    init_simple_test("L_Vp_BFu7ll");
    static STRUCT_IF_C L_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu7ll, L_Vp_BFu7ll)
//============================================================================


struct  L_Vp_BFu7s  {
  __tsi64 v1;
  void *v2;
  unsigned short v3:7;
};
//SIG(1 L_Vp_BFu7s) C1{ FL Fp Fs:7}



static void Test_L_Vp_BFu7s()
{
  {
    init_simple_test("L_Vp_BFu7s");
    static STRUCT_IF_C L_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu7s, L_Vp_BFu7s)
//============================================================================


struct  L_Vp_BFu8c  {
  __tsi64 v1;
  void *v2;
  unsigned char v3:8;
};
//SIG(1 L_Vp_BFu8c) C1{ FL Fp Fc:8}



static void Test_L_Vp_BFu8c()
{
  {
    init_simple_test("L_Vp_BFu8c");
    static STRUCT_IF_C L_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu8c, L_Vp_BFu8c)
//============================================================================


struct  L_Vp_BFu8i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:8;
};
//SIG(1 L_Vp_BFu8i) C1{ FL Fp Fi:8}



static void Test_L_Vp_BFu8i()
{
  {
    init_simple_test("L_Vp_BFu8i");
    static STRUCT_IF_C L_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu8i, L_Vp_BFu8i)
//============================================================================


struct  L_Vp_BFu8ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:8;
};
//SIG(1 L_Vp_BFu8ll) C1{ FL Fp FL:8}



static void Test_L_Vp_BFu8ll()
{
  {
    init_simple_test("L_Vp_BFu8ll");
    static STRUCT_IF_C L_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu8ll, L_Vp_BFu8ll)
//============================================================================


struct  L_Vp_BFu8s  {
  __tsi64 v1;
  void *v2;
  unsigned short v3:8;
};
//SIG(1 L_Vp_BFu8s) C1{ FL Fp Fs:8}



static void Test_L_Vp_BFu8s()
{
  {
    init_simple_test("L_Vp_BFu8s");
    static STRUCT_IF_C L_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu8s, L_Vp_BFu8s)
//============================================================================


struct  L_Vp_BFu9i  {
  __tsi64 v1;
  void *v2;
  unsigned int v3:9;
};
//SIG(1 L_Vp_BFu9i) C1{ FL Fp Fi:9}



static void Test_L_Vp_BFu9i()
{
  {
    init_simple_test("L_Vp_BFu9i");
    static STRUCT_IF_C L_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu9i, L_Vp_BFu9i)
//============================================================================


struct  L_Vp_BFu9ll  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3:9;
};
//SIG(1 L_Vp_BFu9ll) C1{ FL Fp FL:9}



static void Test_L_Vp_BFu9ll()
{
  {
    init_simple_test("L_Vp_BFu9ll");
    static STRUCT_IF_C L_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu9ll, L_Vp_BFu9ll)
//============================================================================


struct  L_Vp_BFu9s  {
  __tsi64 v1;
  void *v2;
  unsigned short v3:9;
};
//SIG(1 L_Vp_BFu9s) C1{ FL Fp Fs:9}



static void Test_L_Vp_BFu9s()
{
  {
    init_simple_test("L_Vp_BFu9s");
    static STRUCT_IF_C L_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu9s, L_Vp_BFu9s)
//============================================================================


struct  L_Vp_C  {
  __tsi64 v1;
  void *v2;
  char v3;
};
//SIG(1 L_Vp_C) C1{ FL Fp Fc}



static void Test_L_Vp_C()
{
  {
    init_simple_test("L_Vp_C");
    STRUCT_IF_C L_Vp_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_C)");
    check_field_offset(lv, v1, 0, "L_Vp_C.v1");
    check_field_offset(lv, v2, 8, "L_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_C, L_Vp_C)
//============================================================================


struct  L_Vp_D  {
  __tsi64 v1;
  void *v2;
  double v3;
};
//SIG(1 L_Vp_D) C1{ FL Fp FL}



static void Test_L_Vp_D()
{
  {
    init_simple_test("L_Vp_D");
    STRUCT_IF_C L_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Vp_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_D)");
    check_field_offset(lv, v1, 0, "L_Vp_D.v1");
    check_field_offset(lv, v2, 8, "L_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_D, L_Vp_D)
//============================================================================


struct  L_Vp_F  {
  __tsi64 v1;
  void *v2;
  float v3;
};
//SIG(1 L_Vp_F) C1{ FL Fp Fi}



static void Test_L_Vp_F()
{
  {
    init_simple_test("L_Vp_F");
    STRUCT_IF_C L_Vp_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_F)");
    check_field_offset(lv, v1, 0, "L_Vp_F.v1");
    check_field_offset(lv, v2, 8, "L_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_F, L_Vp_F)
//============================================================================


struct  L_Vp_I  {
  __tsi64 v1;
  void *v2;
  int v3;
};
//SIG(1 L_Vp_I) C1{ FL Fp Fi}



static void Test_L_Vp_I()
{
  {
    init_simple_test("L_Vp_I");
    STRUCT_IF_C L_Vp_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_I)");
    check_field_offset(lv, v1, 0, "L_Vp_I.v1");
    check_field_offset(lv, v2, 8, "L_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_I, L_Vp_I)
//============================================================================


struct  L_Vp_Ip  {
  __tsi64 v1;
  void *v2;
  int *v3;
};
//SIG(1 L_Vp_Ip) C1{ FL Fp[2]}



static void Test_L_Vp_Ip()
{
  {
    init_simple_test("L_Vp_Ip");
    STRUCT_IF_C L_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_Ip)");
    check_field_offset(lv, v1, 0, "L_Vp_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Ip, L_Vp_Ip)
//============================================================================


struct  L_Vp_L  {
  __tsi64 v1;
  void *v2;
  __tsi64 v3;
};
//SIG(1 L_Vp_L) C1{ FL Fp FL}



static void Test_L_Vp_L()
{
  {
    init_simple_test("L_Vp_L");
    STRUCT_IF_C L_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Vp_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_L)");
    check_field_offset(lv, v1, 0, "L_Vp_L.v1");
    check_field_offset(lv, v2, 8, "L_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_L, L_Vp_L)
//============================================================================


struct  L_Vp_S  {
  __tsi64 v1;
  void *v2;
  short v3;
};
//SIG(1 L_Vp_S) C1{ FL Fp Fs}



static void Test_L_Vp_S()
{
  {
    init_simple_test("L_Vp_S");
    STRUCT_IF_C L_Vp_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_S)");
    check_field_offset(lv, v1, 0, "L_Vp_S.v1");
    check_field_offset(lv, v2, 8, "L_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_S, L_Vp_S)
//============================================================================


struct  L_Vp_Uc  {
  __tsi64 v1;
  void *v2;
  unsigned char v3;
};
//SIG(1 L_Vp_Uc) C1{ FL Fp Fc}



static void Test_L_Vp_Uc()
{
  {
    init_simple_test("L_Vp_Uc");
    STRUCT_IF_C L_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_Uc)");
    check_field_offset(lv, v1, 0, "L_Vp_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Uc, L_Vp_Uc)
//============================================================================


struct  L_Vp_Ui  {
  __tsi64 v1;
  void *v2;
  unsigned int v3;
};
//SIG(1 L_Vp_Ui) C1{ FL Fp Fi}



static void Test_L_Vp_Ui()
{
  {
    init_simple_test("L_Vp_Ui");
    STRUCT_IF_C L_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_Ui)");
    check_field_offset(lv, v1, 0, "L_Vp_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Ui, L_Vp_Ui)
//============================================================================


struct  L_Vp_Ul  {
  __tsi64 v1;
  void *v2;
  __tsu64 v3;
};
//SIG(1 L_Vp_Ul) C1{ FL Fp FL}



static void Test_L_Vp_Ul()
{
  {
    init_simple_test("L_Vp_Ul");
    STRUCT_IF_C L_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Vp_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_Ul)");
    check_field_offset(lv, v1, 0, "L_Vp_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Ul, L_Vp_Ul)
//============================================================================


struct  L_Vp_Us  {
  __tsi64 v1;
  void *v2;
  unsigned short v3;
};
//SIG(1 L_Vp_Us) C1{ FL Fp Fs}



static void Test_L_Vp_Us()
{
  {
    init_simple_test("L_Vp_Us");
    STRUCT_IF_C L_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_Us)");
    check_field_offset(lv, v1, 0, "L_Vp_Us.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Us, L_Vp_Us)
//============================================================================


struct  L_Vp_Vp  {
  __tsi64 v1;
  void *v2;
  void *v3;
};
//SIG(1 L_Vp_Vp) C1{ FL Fp[2]}



static void Test_L_Vp_Vp()
{
  {
    init_simple_test("L_Vp_Vp");
    STRUCT_IF_C L_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_Vp)");
    check_field_offset(lv, v1, 0, "L_Vp_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Vp, L_Vp_Vp)
//============================================================================


struct  S  {
  short v1;
};
//SIG(1 S) C1{ Fs}



static void Test_S()
{
  {
    init_simple_test("S");
    STRUCT_IF_C S lv;
    check2(sizeof(lv), 2, "sizeof(S)");
    check2(__alignof__(lv), 2, "__alignof__(S)");
    check_field_offset(lv, v1, 0, "S.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_S, S)
//============================================================================


struct  S_BFu15i  {
  short v1;
  unsigned int v2:15;
};
//SIG(1 S_BFu15i) C1{ Fs Fi:15}



static void Test_S_BFu15i()
{
  {
    init_simple_test("S_BFu15i");
    static STRUCT_IF_C S_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i, S_BFu15i)
//============================================================================


struct  S_BFu15i_BFu15i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 S_BFu15i_BFu15i) C1{ Fs Fi:15 Fi:15}



static void Test_S_BFu15i_BFu15i()
{
  {
    init_simple_test("S_BFu15i_BFu15i");
    static STRUCT_IF_C S_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu15i, S_BFu15i_BFu15i)
//============================================================================


struct  S_BFu15i_BFu15ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 S_BFu15i_BFu15ll) C1{ Fs Fi:15 FL:15}



static void Test_S_BFu15i_BFu15ll()
{
  {
    init_simple_test("S_BFu15i_BFu15ll");
    static STRUCT_IF_C S_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu15ll, S_BFu15i_BFu15ll)
//============================================================================


struct  S_BFu15i_BFu15s  {
  short v1;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 S_BFu15i_BFu15s) C1{ Fs Fi:15 Fs:15}



static void Test_S_BFu15i_BFu15s()
{
  {
    init_simple_test("S_BFu15i_BFu15s");
    static STRUCT_IF_C S_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu15s, S_BFu15i_BFu15s)
//============================================================================


struct  S_BFu15i_BFu16i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:16;
};
//SIG(1 S_BFu15i_BFu16i) C1{ Fs Fi:15 Fi:16}



static void Test_S_BFu15i_BFu16i()
{
  {
    init_simple_test("S_BFu15i_BFu16i");
    static STRUCT_IF_C S_BFu15i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu16i, S_BFu15i_BFu16i)
//============================================================================


struct  S_BFu15i_BFu16ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:16;
};
//SIG(1 S_BFu15i_BFu16ll) C1{ Fs Fi:15 FL:16}



static void Test_S_BFu15i_BFu16ll()
{
  {
    init_simple_test("S_BFu15i_BFu16ll");
    static STRUCT_IF_C S_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu16ll, S_BFu15i_BFu16ll)
//============================================================================


struct  S_BFu15i_BFu16s  {
  short v1;
  unsigned int v2:15;
  unsigned short v3:16;
};
//SIG(1 S_BFu15i_BFu16s) C1{ Fs Fi:15 Fs:16}



static void Test_S_BFu15i_BFu16s()
{
  {
    init_simple_test("S_BFu15i_BFu16s");
    static STRUCT_IF_C S_BFu15i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu16s, S_BFu15i_BFu16s)
//============================================================================


struct  S_BFu15i_BFu17i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:17;
};
//SIG(1 S_BFu15i_BFu17i) C1{ Fs Fi:15 Fi:17}



static void Test_S_BFu15i_BFu17i()
{
  {
    init_simple_test("S_BFu15i_BFu17i");
    static STRUCT_IF_C S_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu17i, S_BFu15i_BFu17i)
//============================================================================


struct  S_BFu15i_BFu17ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:17;
};
//SIG(1 S_BFu15i_BFu17ll) C1{ Fs Fi:15 FL:17}



static void Test_S_BFu15i_BFu17ll()
{
  {
    init_simple_test("S_BFu15i_BFu17ll");
    static STRUCT_IF_C S_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "S_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "S_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu17ll, S_BFu15i_BFu17ll)
//============================================================================


struct  S_BFu15i_BFu1c  {
  short v1;
  unsigned int v2:15;
  unsigned char v3:1;
};
//SIG(1 S_BFu15i_BFu1c) C1{ Fs Fi:15 Fc:1}



static void Test_S_BFu15i_BFu1c()
{
  {
    init_simple_test("S_BFu15i_BFu1c");
    static STRUCT_IF_C S_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu1c, S_BFu15i_BFu1c)
//============================================================================


struct  S_BFu15i_BFu1i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:1;
};
//SIG(1 S_BFu15i_BFu1i) C1{ Fs Fi:15 Fi:1}



static void Test_S_BFu15i_BFu1i()
{
  {
    init_simple_test("S_BFu15i_BFu1i");
    static STRUCT_IF_C S_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu1i, S_BFu15i_BFu1i)
//============================================================================


struct  S_BFu15i_BFu1ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:1;
};
//SIG(1 S_BFu15i_BFu1ll) C1{ Fs Fi:15 FL:1}



static void Test_S_BFu15i_BFu1ll()
{
  {
    init_simple_test("S_BFu15i_BFu1ll");
    static STRUCT_IF_C S_BFu15i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu1ll, S_BFu15i_BFu1ll)
//============================================================================


struct  S_BFu15i_BFu1s  {
  short v1;
  unsigned int v2:15;
  unsigned short v3:1;
};
//SIG(1 S_BFu15i_BFu1s) C1{ Fs Fi:15 Fs:1}



static void Test_S_BFu15i_BFu1s()
{
  {
    init_simple_test("S_BFu15i_BFu1s");
    static STRUCT_IF_C S_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu1s, S_BFu15i_BFu1s)
//============================================================================


struct  S_BFu15i_BFu31i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:31;
};
//SIG(1 S_BFu15i_BFu31i) C1{ Fs Fi:15 Fi:31}



static void Test_S_BFu15i_BFu31i()
{
  {
    init_simple_test("S_BFu15i_BFu31i");
    static STRUCT_IF_C S_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu31i, S_BFu15i_BFu31i)
//============================================================================


struct  S_BFu15i_BFu31ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:31;
};
//SIG(1 S_BFu15i_BFu31ll) C1{ Fs Fi:15 FL:31}



static void Test_S_BFu15i_BFu31ll()
{
  {
    init_simple_test("S_BFu15i_BFu31ll");
    static STRUCT_IF_C S_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "S_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "S_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu31ll, S_BFu15i_BFu31ll)
//============================================================================


struct  S_BFu15i_BFu32i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:32;
};
//SIG(1 S_BFu15i_BFu32i) C1{ Fs Fi:15 Fi:32}



static void Test_S_BFu15i_BFu32i()
{
  {
    init_simple_test("S_BFu15i_BFu32i");
    static STRUCT_IF_C S_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu32i, S_BFu15i_BFu32i)
//============================================================================


struct  S_BFu15i_BFu32ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:32;
};
//SIG(1 S_BFu15i_BFu32ll) C1{ Fs Fi:15 FL:32}



static void Test_S_BFu15i_BFu32ll()
{
  {
    init_simple_test("S_BFu15i_BFu32ll");
    static STRUCT_IF_C S_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "S_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "S_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu32ll, S_BFu15i_BFu32ll)
//============================================================================


struct  S_BFu15i_BFu33  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:33;
};
//SIG(1 S_BFu15i_BFu33) C1{ Fs Fi:15 FL:33}



static void Test_S_BFu15i_BFu33()
{
  {
    init_simple_test("S_BFu15i_BFu33");
    static STRUCT_IF_C S_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "S_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "S_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu33, S_BFu15i_BFu33)
//============================================================================


struct  S_BFu15i_BFu7c  {
  short v1;
  unsigned int v2:15;
  unsigned char v3:7;
};
//SIG(1 S_BFu15i_BFu7c) C1{ Fs Fi:15 Fc:7}



static void Test_S_BFu15i_BFu7c()
{
  {
    init_simple_test("S_BFu15i_BFu7c");
    static STRUCT_IF_C S_BFu15i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu7c, S_BFu15i_BFu7c)
//============================================================================


struct  S_BFu15i_BFu7i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:7;
};
//SIG(1 S_BFu15i_BFu7i) C1{ Fs Fi:15 Fi:7}



static void Test_S_BFu15i_BFu7i()
{
  {
    init_simple_test("S_BFu15i_BFu7i");
    static STRUCT_IF_C S_BFu15i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu7i, S_BFu15i_BFu7i)
//============================================================================


struct  S_BFu15i_BFu7ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:7;
};
//SIG(1 S_BFu15i_BFu7ll) C1{ Fs Fi:15 FL:7}



static void Test_S_BFu15i_BFu7ll()
{
  {
    init_simple_test("S_BFu15i_BFu7ll");
    static STRUCT_IF_C S_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu7ll, S_BFu15i_BFu7ll)
//============================================================================


struct  S_BFu15i_BFu7s  {
  short v1;
  unsigned int v2:15;
  unsigned short v3:7;
};
//SIG(1 S_BFu15i_BFu7s) C1{ Fs Fi:15 Fs:7}



static void Test_S_BFu15i_BFu7s()
{
  {
    init_simple_test("S_BFu15i_BFu7s");
    static STRUCT_IF_C S_BFu15i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu7s, S_BFu15i_BFu7s)
//============================================================================


struct  S_BFu15i_BFu8c  {
  short v1;
  unsigned int v2:15;
  unsigned char v3:8;
};
//SIG(1 S_BFu15i_BFu8c) C1{ Fs Fi:15 Fc:8}



static void Test_S_BFu15i_BFu8c()
{
  {
    init_simple_test("S_BFu15i_BFu8c");
    static STRUCT_IF_C S_BFu15i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu8c, S_BFu15i_BFu8c)
//============================================================================


struct  S_BFu15i_BFu8i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:8;
};
//SIG(1 S_BFu15i_BFu8i) C1{ Fs Fi:15 Fi:8}



static void Test_S_BFu15i_BFu8i()
{
  {
    init_simple_test("S_BFu15i_BFu8i");
    static STRUCT_IF_C S_BFu15i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu8i, S_BFu15i_BFu8i)
//============================================================================


struct  S_BFu15i_BFu8ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:8;
};
//SIG(1 S_BFu15i_BFu8ll) C1{ Fs Fi:15 FL:8}



static void Test_S_BFu15i_BFu8ll()
{
  {
    init_simple_test("S_BFu15i_BFu8ll");
    static STRUCT_IF_C S_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu8ll, S_BFu15i_BFu8ll)
//============================================================================


struct  S_BFu15i_BFu8s  {
  short v1;
  unsigned int v2:15;
  unsigned short v3:8;
};
//SIG(1 S_BFu15i_BFu8s) C1{ Fs Fi:15 Fs:8}



static void Test_S_BFu15i_BFu8s()
{
  {
    init_simple_test("S_BFu15i_BFu8s");
    static STRUCT_IF_C S_BFu15i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu8s, S_BFu15i_BFu8s)
//============================================================================


struct  S_BFu15i_BFu9i  {
  short v1;
  unsigned int v2:15;
  unsigned int v3:9;
};
//SIG(1 S_BFu15i_BFu9i) C1{ Fs Fi:15 Fi:9}



static void Test_S_BFu15i_BFu9i()
{
  {
    init_simple_test("S_BFu15i_BFu9i");
    static STRUCT_IF_C S_BFu15i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu9i, S_BFu15i_BFu9i)
//============================================================================


struct  S_BFu15i_BFu9ll  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3:9;
};
//SIG(1 S_BFu15i_BFu9ll) C1{ Fs Fi:15 FL:9}



static void Test_S_BFu15i_BFu9ll()
{
  {
    init_simple_test("S_BFu15i_BFu9ll");
    static STRUCT_IF_C S_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu9ll, S_BFu15i_BFu9ll)
//============================================================================


struct  S_BFu15i_BFu9s  {
  short v1;
  unsigned int v2:15;
  unsigned short v3:9;
};
//SIG(1 S_BFu15i_BFu9s) C1{ Fs Fi:15 Fs:9}



static void Test_S_BFu15i_BFu9s()
{
  {
    init_simple_test("S_BFu15i_BFu9s");
    static STRUCT_IF_C S_BFu15i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu9s, S_BFu15i_BFu9s)
//============================================================================


struct  S_BFu15i_C  {
  short v1;
  unsigned int v2:15;
  char v3;
};
//SIG(1 S_BFu15i_C) C1{ Fs Fi:15 Fc}



static void Test_S_BFu15i_C()
{
  {
    init_simple_test("S_BFu15i_C");
    static STRUCT_IF_C S_BFu15i_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_C)");
    check_field_offset(lv, v1, 0, "S_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_C");
    check_field_offset(lv, v3, 4, "S_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_C, S_BFu15i_C)
//============================================================================


struct  S_BFu15i_D  {
  short v1;
  unsigned int v2:15;
  double v3;
};
//SIG(1 S_BFu15i_D) C1{ Fs Fi:15 FL}



static void Test_S_BFu15i_D()
{
  {
    init_simple_test("S_BFu15i_D");
    static STRUCT_IF_C S_BFu15i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_D)");
    check_field_offset(lv, v1, 0, "S_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_D, S_BFu15i_D)
//============================================================================


struct  S_BFu15i_F  {
  short v1;
  unsigned int v2:15;
  float v3;
};
//SIG(1 S_BFu15i_F) C1{ Fs Fi:15 Fi}



static void Test_S_BFu15i_F()
{
  {
    init_simple_test("S_BFu15i_F");
    static STRUCT_IF_C S_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_F)");
    check_field_offset(lv, v1, 0, "S_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_F");
    check_field_offset(lv, v3, 4, "S_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_F, S_BFu15i_F)
//============================================================================


struct  S_BFu15i_I  {
  short v1;
  unsigned int v2:15;
  int v3;
};
//SIG(1 S_BFu15i_I) C1{ Fs Fi:15 Fi}



static void Test_S_BFu15i_I()
{
  {
    init_simple_test("S_BFu15i_I");
    static STRUCT_IF_C S_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_I)");
    check_field_offset(lv, v1, 0, "S_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_I");
    check_field_offset(lv, v3, 4, "S_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_I, S_BFu15i_I)
//============================================================================


struct  S_BFu15i_Ip  {
  short v1;
  unsigned int v2:15;
  int *v3;
};
//SIG(1 S_BFu15i_Ip) C1{ Fs Fi:15 Fp}



static void Test_S_BFu15i_Ip()
{
  {
    init_simple_test("S_BFu15i_Ip");
    static STRUCT_IF_C S_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Ip, S_BFu15i_Ip)
//============================================================================


struct  S_BFu15i_L  {
  short v1;
  unsigned int v2:15;
  __tsi64 v3;
};
//SIG(1 S_BFu15i_L) C1{ Fs Fi:15 FL}



static void Test_S_BFu15i_L()
{
  {
    init_simple_test("S_BFu15i_L");
    static STRUCT_IF_C S_BFu15i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_L)");
    check_field_offset(lv, v1, 0, "S_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_L, S_BFu15i_L)
//============================================================================


struct  S_BFu15i_S  {
  short v1;
  unsigned int v2:15;
  short v3;
};
//SIG(1 S_BFu15i_S) C1{ Fs Fi:15 Fs}



static void Test_S_BFu15i_S()
{
  {
    init_simple_test("S_BFu15i_S");
    static STRUCT_IF_C S_BFu15i_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_S)");
    check_field_offset(lv, v1, 0, "S_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_S");
    check_field_offset(lv, v3, 4, "S_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_S, S_BFu15i_S)
//============================================================================


struct  S_BFu15i_Uc  {
  short v1;
  unsigned int v2:15;
  unsigned char v3;
};
//SIG(1 S_BFu15i_Uc) C1{ Fs Fi:15 Fc}



static void Test_S_BFu15i_Uc()
{
  {
    init_simple_test("S_BFu15i_Uc");
    static STRUCT_IF_C S_BFu15i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Uc");
    check_field_offset(lv, v3, 4, "S_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Uc, S_BFu15i_Uc)
//============================================================================


struct  S_BFu15i_Ui  {
  short v1;
  unsigned int v2:15;
  unsigned int v3;
};
//SIG(1 S_BFu15i_Ui) C1{ Fs Fi:15 Fi}



static void Test_S_BFu15i_Ui()
{
  {
    init_simple_test("S_BFu15i_Ui");
    static STRUCT_IF_C S_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Ui");
    check_field_offset(lv, v3, 4, "S_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Ui, S_BFu15i_Ui)
//============================================================================


struct  S_BFu15i_Ul  {
  short v1;
  unsigned int v2:15;
  __tsu64 v3;
};
//SIG(1 S_BFu15i_Ul) C1{ Fs Fi:15 FL}



static void Test_S_BFu15i_Ul()
{
  {
    init_simple_test("S_BFu15i_Ul");
    static STRUCT_IF_C S_BFu15i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Ul, S_BFu15i_Ul)
//============================================================================


struct  S_BFu15i_Us  {
  short v1;
  unsigned int v2:15;
  unsigned short v3;
};
//SIG(1 S_BFu15i_Us) C1{ Fs Fi:15 Fs}



static void Test_S_BFu15i_Us()
{
  {
    init_simple_test("S_BFu15i_Us");
    static STRUCT_IF_C S_BFu15i_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Us");
    check_field_offset(lv, v3, 4, "S_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Us, S_BFu15i_Us)
//============================================================================


struct  S_BFu15i_Vp  {
  short v1;
  unsigned int v2:15;
  void *v3;
};
//SIG(1 S_BFu15i_Vp) C1{ Fs Fi:15 Fp}



static void Test_S_BFu15i_Vp()
{
  {
    init_simple_test("S_BFu15i_Vp");
    static STRUCT_IF_C S_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Vp, S_BFu15i_Vp)
//============================================================================


struct  S_BFu15ll  {
  short v1;
  __tsu64 v2:15;
};
//SIG(1 S_BFu15ll) C1{ Fs FL:15}



static void Test_S_BFu15ll()
{
  {
    init_simple_test("S_BFu15ll");
    static STRUCT_IF_C S_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll, S_BFu15ll)
//============================================================================


struct  S_BFu15ll_BFu15i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 S_BFu15ll_BFu15i) C1{ Fs FL:15 Fi:15}



static void Test_S_BFu15ll_BFu15i()
{
  {
    init_simple_test("S_BFu15ll_BFu15i");
    static STRUCT_IF_C S_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu15i, S_BFu15ll_BFu15i)
//============================================================================


struct  S_BFu15ll_BFu15ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 S_BFu15ll_BFu15ll) C1{ Fs FL:15 FL:15}



static void Test_S_BFu15ll_BFu15ll()
{
  {
    init_simple_test("S_BFu15ll_BFu15ll");
    static STRUCT_IF_C S_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu15ll, S_BFu15ll_BFu15ll)
//============================================================================


struct  S_BFu15ll_BFu15s  {
  short v1;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 S_BFu15ll_BFu15s) C1{ Fs FL:15 Fs:15}



static void Test_S_BFu15ll_BFu15s()
{
  {
    init_simple_test("S_BFu15ll_BFu15s");
    static STRUCT_IF_C S_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu15s, S_BFu15ll_BFu15s)
//============================================================================


struct  S_BFu15ll_BFu16i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 S_BFu15ll_BFu16i) C1{ Fs FL:15 Fi:16}



static void Test_S_BFu15ll_BFu16i()
{
  {
    init_simple_test("S_BFu15ll_BFu16i");
    static STRUCT_IF_C S_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu16i, S_BFu15ll_BFu16i)
//============================================================================


struct  S_BFu15ll_BFu16ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 S_BFu15ll_BFu16ll) C1{ Fs FL:15 FL:16}



static void Test_S_BFu15ll_BFu16ll()
{
  {
    init_simple_test("S_BFu15ll_BFu16ll");
    static STRUCT_IF_C S_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu16ll, S_BFu15ll_BFu16ll)
//============================================================================


struct  S_BFu15ll_BFu16s  {
  short v1;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 S_BFu15ll_BFu16s) C1{ Fs FL:15 Fs:16}



static void Test_S_BFu15ll_BFu16s()
{
  {
    init_simple_test("S_BFu15ll_BFu16s");
    static STRUCT_IF_C S_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu16s, S_BFu15ll_BFu16s)
//============================================================================


struct  S_BFu15ll_BFu17i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 S_BFu15ll_BFu17i) C1{ Fs FL:15 Fi:17}



static void Test_S_BFu15ll_BFu17i()
{
  {
    init_simple_test("S_BFu15ll_BFu17i");
    static STRUCT_IF_C S_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu17i, S_BFu15ll_BFu17i)
//============================================================================


struct  S_BFu15ll_BFu17ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 S_BFu15ll_BFu17ll) C1{ Fs FL:15 FL:17}



static void Test_S_BFu15ll_BFu17ll()
{
  {
    init_simple_test("S_BFu15ll_BFu17ll");
    static STRUCT_IF_C S_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "S_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "S_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu17ll, S_BFu15ll_BFu17ll)
//============================================================================


struct  S_BFu15ll_BFu1c  {
  short v1;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 S_BFu15ll_BFu1c) C1{ Fs FL:15 Fc:1}



static void Test_S_BFu15ll_BFu1c()
{
  {
    init_simple_test("S_BFu15ll_BFu1c");
    static STRUCT_IF_C S_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu1c, S_BFu15ll_BFu1c)
//============================================================================


struct  S_BFu15ll_BFu1i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 S_BFu15ll_BFu1i) C1{ Fs FL:15 Fi:1}



static void Test_S_BFu15ll_BFu1i()
{
  {
    init_simple_test("S_BFu15ll_BFu1i");
    static STRUCT_IF_C S_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu1i, S_BFu15ll_BFu1i)
//============================================================================


struct  S_BFu15ll_BFu1ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 S_BFu15ll_BFu1ll) C1{ Fs FL:15 FL:1}



static void Test_S_BFu15ll_BFu1ll()
{
  {
    init_simple_test("S_BFu15ll_BFu1ll");
    static STRUCT_IF_C S_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu1ll, S_BFu15ll_BFu1ll)
//============================================================================


struct  S_BFu15ll_BFu1s  {
  short v1;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 S_BFu15ll_BFu1s) C1{ Fs FL:15 Fs:1}



static void Test_S_BFu15ll_BFu1s()
{
  {
    init_simple_test("S_BFu15ll_BFu1s");
    static STRUCT_IF_C S_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu1s, S_BFu15ll_BFu1s)
//============================================================================


struct  S_BFu15ll_BFu31i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 S_BFu15ll_BFu31i) C1{ Fs FL:15 Fi:31}



static void Test_S_BFu15ll_BFu31i()
{
  {
    init_simple_test("S_BFu15ll_BFu31i");
    static STRUCT_IF_C S_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu31i, S_BFu15ll_BFu31i)
//============================================================================


struct  S_BFu15ll_BFu31ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 S_BFu15ll_BFu31ll) C1{ Fs FL:15 FL:31}



static void Test_S_BFu15ll_BFu31ll()
{
  {
    init_simple_test("S_BFu15ll_BFu31ll");
    static STRUCT_IF_C S_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "S_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "S_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu31ll, S_BFu15ll_BFu31ll)
//============================================================================


struct  S_BFu15ll_BFu32i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 S_BFu15ll_BFu32i) C1{ Fs FL:15 Fi:32}



static void Test_S_BFu15ll_BFu32i()
{
  {
    init_simple_test("S_BFu15ll_BFu32i");
    static STRUCT_IF_C S_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu32i, S_BFu15ll_BFu32i)
//============================================================================


struct  S_BFu15ll_BFu32ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 S_BFu15ll_BFu32ll) C1{ Fs FL:15 FL:32}



static void Test_S_BFu15ll_BFu32ll()
{
  {
    init_simple_test("S_BFu15ll_BFu32ll");
    static STRUCT_IF_C S_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "S_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "S_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu32ll, S_BFu15ll_BFu32ll)
//============================================================================


struct  S_BFu15ll_BFu33  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 S_BFu15ll_BFu33) C1{ Fs FL:15 FL:33}



static void Test_S_BFu15ll_BFu33()
{
  {
    init_simple_test("S_BFu15ll_BFu33");
    static STRUCT_IF_C S_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "S_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "S_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu33, S_BFu15ll_BFu33)
//============================================================================


struct  S_BFu15ll_BFu7c  {
  short v1;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 S_BFu15ll_BFu7c) C1{ Fs FL:15 Fc:7}



static void Test_S_BFu15ll_BFu7c()
{
  {
    init_simple_test("S_BFu15ll_BFu7c");
    static STRUCT_IF_C S_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu7c, S_BFu15ll_BFu7c)
//============================================================================


struct  S_BFu15ll_BFu7i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 S_BFu15ll_BFu7i) C1{ Fs FL:15 Fi:7}



static void Test_S_BFu15ll_BFu7i()
{
  {
    init_simple_test("S_BFu15ll_BFu7i");
    static STRUCT_IF_C S_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu7i, S_BFu15ll_BFu7i)
//============================================================================


struct  S_BFu15ll_BFu7ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 S_BFu15ll_BFu7ll) C1{ Fs FL:15 FL:7}



static void Test_S_BFu15ll_BFu7ll()
{
  {
    init_simple_test("S_BFu15ll_BFu7ll");
    static STRUCT_IF_C S_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu7ll, S_BFu15ll_BFu7ll)
//============================================================================


struct  S_BFu15ll_BFu7s  {
  short v1;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 S_BFu15ll_BFu7s) C1{ Fs FL:15 Fs:7}



static void Test_S_BFu15ll_BFu7s()
{
  {
    init_simple_test("S_BFu15ll_BFu7s");
    static STRUCT_IF_C S_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu7s, S_BFu15ll_BFu7s)
//============================================================================


struct  S_BFu15ll_BFu8c  {
  short v1;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 S_BFu15ll_BFu8c) C1{ Fs FL:15 Fc:8}



static void Test_S_BFu15ll_BFu8c()
{
  {
    init_simple_test("S_BFu15ll_BFu8c");
    static STRUCT_IF_C S_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu8c, S_BFu15ll_BFu8c)
//============================================================================


struct  S_BFu15ll_BFu8i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 S_BFu15ll_BFu8i) C1{ Fs FL:15 Fi:8}



static void Test_S_BFu15ll_BFu8i()
{
  {
    init_simple_test("S_BFu15ll_BFu8i");
    static STRUCT_IF_C S_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu8i, S_BFu15ll_BFu8i)
//============================================================================


struct  S_BFu15ll_BFu8ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 S_BFu15ll_BFu8ll) C1{ Fs FL:15 FL:8}



static void Test_S_BFu15ll_BFu8ll()
{
  {
    init_simple_test("S_BFu15ll_BFu8ll");
    static STRUCT_IF_C S_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu8ll, S_BFu15ll_BFu8ll)
//============================================================================


struct  S_BFu15ll_BFu8s  {
  short v1;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 S_BFu15ll_BFu8s) C1{ Fs FL:15 Fs:8}



static void Test_S_BFu15ll_BFu8s()
{
  {
    init_simple_test("S_BFu15ll_BFu8s");
    static STRUCT_IF_C S_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu8s, S_BFu15ll_BFu8s)
//============================================================================


struct  S_BFu15ll_BFu9i  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 S_BFu15ll_BFu9i) C1{ Fs FL:15 Fi:9}



static void Test_S_BFu15ll_BFu9i()
{
  {
    init_simple_test("S_BFu15ll_BFu9i");
    static STRUCT_IF_C S_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu9i, S_BFu15ll_BFu9i)
//============================================================================


struct  S_BFu15ll_BFu9ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 S_BFu15ll_BFu9ll) C1{ Fs FL:15 FL:9}



static void Test_S_BFu15ll_BFu9ll()
{
  {
    init_simple_test("S_BFu15ll_BFu9ll");
    static STRUCT_IF_C S_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu9ll, S_BFu15ll_BFu9ll)
//============================================================================


struct  S_BFu15ll_BFu9s  {
  short v1;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 S_BFu15ll_BFu9s) C1{ Fs FL:15 Fs:9}



static void Test_S_BFu15ll_BFu9s()
{
  {
    init_simple_test("S_BFu15ll_BFu9s");
    static STRUCT_IF_C S_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu9s, S_BFu15ll_BFu9s)
//============================================================================


struct  S_BFu15ll_C  {
  short v1;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 S_BFu15ll_C) C1{ Fs FL:15 Fc}



static void Test_S_BFu15ll_C()
{
  {
    init_simple_test("S_BFu15ll_C");
    static STRUCT_IF_C S_BFu15ll_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_C");
    check_field_offset(lv, v3, 4, "S_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_C, S_BFu15ll_C)
//============================================================================


struct  S_BFu15ll_D  {
  short v1;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 S_BFu15ll_D) C1{ Fs FL:15 FL}



static void Test_S_BFu15ll_D()
{
  {
    init_simple_test("S_BFu15ll_D");
    static STRUCT_IF_C S_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_D, S_BFu15ll_D)
//============================================================================


struct  S_BFu15ll_F  {
  short v1;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 S_BFu15ll_F) C1{ Fs FL:15 Fi}



static void Test_S_BFu15ll_F()
{
  {
    init_simple_test("S_BFu15ll_F");
    static STRUCT_IF_C S_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_F");
    check_field_offset(lv, v3, 4, "S_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_F, S_BFu15ll_F)
//============================================================================


struct  S_BFu15ll_I  {
  short v1;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 S_BFu15ll_I) C1{ Fs FL:15 Fi}



static void Test_S_BFu15ll_I()
{
  {
    init_simple_test("S_BFu15ll_I");
    static STRUCT_IF_C S_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_I");
    check_field_offset(lv, v3, 4, "S_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_I, S_BFu15ll_I)
//============================================================================


struct  S_BFu15ll_Ip  {
  short v1;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 S_BFu15ll_Ip) C1{ Fs FL:15 Fp}



static void Test_S_BFu15ll_Ip()
{
  {
    init_simple_test("S_BFu15ll_Ip");
    static STRUCT_IF_C S_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Ip, S_BFu15ll_Ip)
//============================================================================


struct  S_BFu15ll_L  {
  short v1;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 S_BFu15ll_L) C1{ Fs FL:15 FL}



static void Test_S_BFu15ll_L()
{
  {
    init_simple_test("S_BFu15ll_L");
    static STRUCT_IF_C S_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_L, S_BFu15ll_L)
//============================================================================


struct  S_BFu15ll_S  {
  short v1;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 S_BFu15ll_S) C1{ Fs FL:15 Fs}



static void Test_S_BFu15ll_S()
{
  {
    init_simple_test("S_BFu15ll_S");
    static STRUCT_IF_C S_BFu15ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_S");
    check_field_offset(lv, v3, 4, "S_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_S, S_BFu15ll_S)
//============================================================================


struct  S_BFu15ll_Uc  {
  short v1;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 S_BFu15ll_Uc) C1{ Fs FL:15 Fc}



static void Test_S_BFu15ll_Uc()
{
  {
    init_simple_test("S_BFu15ll_Uc");
    static STRUCT_IF_C S_BFu15ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Uc");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Uc, S_BFu15ll_Uc)
//============================================================================


struct  S_BFu15ll_Ui  {
  short v1;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 S_BFu15ll_Ui) C1{ Fs FL:15 Fi}



static void Test_S_BFu15ll_Ui()
{
  {
    init_simple_test("S_BFu15ll_Ui");
    static STRUCT_IF_C S_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Ui, S_BFu15ll_Ui)
//============================================================================


struct  S_BFu15ll_Ul  {
  short v1;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 S_BFu15ll_Ul) C1{ Fs FL:15 FL}



static void Test_S_BFu15ll_Ul()
{
  {
    init_simple_test("S_BFu15ll_Ul");
    static STRUCT_IF_C S_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Ul, S_BFu15ll_Ul)
//============================================================================


struct  S_BFu15ll_Us  {
  short v1;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 S_BFu15ll_Us) C1{ Fs FL:15 Fs}



static void Test_S_BFu15ll_Us()
{
  {
    init_simple_test("S_BFu15ll_Us");
    static STRUCT_IF_C S_BFu15ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Us");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Us, S_BFu15ll_Us)
//============================================================================


struct  S_BFu15ll_Vp  {
  short v1;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 S_BFu15ll_Vp) C1{ Fs FL:15 Fp}



static void Test_S_BFu15ll_Vp()
{
  {
    init_simple_test("S_BFu15ll_Vp");
    static STRUCT_IF_C S_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Vp, S_BFu15ll_Vp)
//============================================================================


struct  S_BFu15s  {
  short v1;
  unsigned short v2:15;
};
//SIG(1 S_BFu15s) C1{ Fs Fs:15}



static void Test_S_BFu15s()
{
  {
    init_simple_test("S_BFu15s");
    static STRUCT_IF_C S_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s, S_BFu15s)
//============================================================================


struct  S_BFu15s_BFu15i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 S_BFu15s_BFu15i) C1{ Fs Fs:15 Fi:15}



static void Test_S_BFu15s_BFu15i()
{
  {
    init_simple_test("S_BFu15s_BFu15i");
    static STRUCT_IF_C S_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu15i, S_BFu15s_BFu15i)
//============================================================================


struct  S_BFu15s_BFu15ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 S_BFu15s_BFu15ll) C1{ Fs Fs:15 FL:15}



static void Test_S_BFu15s_BFu15ll()
{
  {
    init_simple_test("S_BFu15s_BFu15ll");
    static STRUCT_IF_C S_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu15ll, S_BFu15s_BFu15ll)
//============================================================================


struct  S_BFu15s_BFu15s  {
  short v1;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 S_BFu15s_BFu15s) C1{ Fs Fs:15 Fs:15}



static void Test_S_BFu15s_BFu15s()
{
  {
    init_simple_test("S_BFu15s_BFu15s");
    static STRUCT_IF_C S_BFu15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu15s, S_BFu15s_BFu15s)
//============================================================================


struct  S_BFu15s_BFu16i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 S_BFu15s_BFu16i) C1{ Fs Fs:15 Fi:16}



static void Test_S_BFu15s_BFu16i()
{
  {
    init_simple_test("S_BFu15s_BFu16i");
    static STRUCT_IF_C S_BFu15s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu16i, S_BFu15s_BFu16i)
//============================================================================


struct  S_BFu15s_BFu16ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 S_BFu15s_BFu16ll) C1{ Fs Fs:15 FL:16}



static void Test_S_BFu15s_BFu16ll()
{
  {
    init_simple_test("S_BFu15s_BFu16ll");
    static STRUCT_IF_C S_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu16ll, S_BFu15s_BFu16ll)
//============================================================================


struct  S_BFu15s_BFu16s  {
  short v1;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 S_BFu15s_BFu16s) C1{ Fs Fs:15 Fs:16}



static void Test_S_BFu15s_BFu16s()
{
  {
    init_simple_test("S_BFu15s_BFu16s");
    static STRUCT_IF_C S_BFu15s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu16s, S_BFu15s_BFu16s)
//============================================================================


struct  S_BFu15s_BFu17i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 S_BFu15s_BFu17i) C1{ Fs Fs:15 Fi:17}



static void Test_S_BFu15s_BFu17i()
{
  {
    init_simple_test("S_BFu15s_BFu17i");
    static STRUCT_IF_C S_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu17i, S_BFu15s_BFu17i)
//============================================================================


struct  S_BFu15s_BFu17ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 S_BFu15s_BFu17ll) C1{ Fs Fs:15 FL:17}



static void Test_S_BFu15s_BFu17ll()
{
  {
    init_simple_test("S_BFu15s_BFu17ll");
    static STRUCT_IF_C S_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "S_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "S_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu17ll, S_BFu15s_BFu17ll)
//============================================================================


struct  S_BFu15s_BFu1c  {
  short v1;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 S_BFu15s_BFu1c) C1{ Fs Fs:15 Fc:1}



static void Test_S_BFu15s_BFu1c()
{
  {
    init_simple_test("S_BFu15s_BFu1c");
    static STRUCT_IF_C S_BFu15s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu1c, S_BFu15s_BFu1c)
//============================================================================


struct  S_BFu15s_BFu1i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 S_BFu15s_BFu1i) C1{ Fs Fs:15 Fi:1}



static void Test_S_BFu15s_BFu1i()
{
  {
    init_simple_test("S_BFu15s_BFu1i");
    static STRUCT_IF_C S_BFu15s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu1i, S_BFu15s_BFu1i)
//============================================================================


struct  S_BFu15s_BFu1ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 S_BFu15s_BFu1ll) C1{ Fs Fs:15 FL:1}



static void Test_S_BFu15s_BFu1ll()
{
  {
    init_simple_test("S_BFu15s_BFu1ll");
    static STRUCT_IF_C S_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu1ll, S_BFu15s_BFu1ll)
//============================================================================


struct  S_BFu15s_BFu1s  {
  short v1;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 S_BFu15s_BFu1s) C1{ Fs Fs:15 Fs:1}



static void Test_S_BFu15s_BFu1s()
{
  {
    init_simple_test("S_BFu15s_BFu1s");
    static STRUCT_IF_C S_BFu15s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu1s, S_BFu15s_BFu1s)
//============================================================================


struct  S_BFu15s_BFu31i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 S_BFu15s_BFu31i) C1{ Fs Fs:15 Fi:31}



static void Test_S_BFu15s_BFu31i()
{
  {
    init_simple_test("S_BFu15s_BFu31i");
    static STRUCT_IF_C S_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu31i, S_BFu15s_BFu31i)
//============================================================================


struct  S_BFu15s_BFu31ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:31;
};
//SIG(1 S_BFu15s_BFu31ll) C1{ Fs Fs:15 FL:31}



static void Test_S_BFu15s_BFu31ll()
{
  {
    init_simple_test("S_BFu15s_BFu31ll");
    static STRUCT_IF_C S_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "S_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "S_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu31ll, S_BFu15s_BFu31ll)
//============================================================================


struct  S_BFu15s_BFu32i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:32;
};
//SIG(1 S_BFu15s_BFu32i) C1{ Fs Fs:15 Fi:32}



static void Test_S_BFu15s_BFu32i()
{
  {
    init_simple_test("S_BFu15s_BFu32i");
    static STRUCT_IF_C S_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu32i, S_BFu15s_BFu32i)
//============================================================================


struct  S_BFu15s_BFu32ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:32;
};
//SIG(1 S_BFu15s_BFu32ll) C1{ Fs Fs:15 FL:32}



static void Test_S_BFu15s_BFu32ll()
{
  {
    init_simple_test("S_BFu15s_BFu32ll");
    static STRUCT_IF_C S_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "S_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "S_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu32ll, S_BFu15s_BFu32ll)
//============================================================================


struct  S_BFu15s_BFu33  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:33;
};
//SIG(1 S_BFu15s_BFu33) C1{ Fs Fs:15 FL:33}



static void Test_S_BFu15s_BFu33()
{
  {
    init_simple_test("S_BFu15s_BFu33");
    static STRUCT_IF_C S_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "S_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "S_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu33, S_BFu15s_BFu33)
//============================================================================


struct  S_BFu15s_BFu7c  {
  short v1;
  unsigned short v2:15;
  unsigned char v3:7;
};
//SIG(1 S_BFu15s_BFu7c) C1{ Fs Fs:15 Fc:7}



static void Test_S_BFu15s_BFu7c()
{
  {
    init_simple_test("S_BFu15s_BFu7c");
    static STRUCT_IF_C S_BFu15s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu7c, S_BFu15s_BFu7c)
//============================================================================


struct  S_BFu15s_BFu7i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:7;
};
//SIG(1 S_BFu15s_BFu7i) C1{ Fs Fs:15 Fi:7}



static void Test_S_BFu15s_BFu7i()
{
  {
    init_simple_test("S_BFu15s_BFu7i");
    static STRUCT_IF_C S_BFu15s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu7i, S_BFu15s_BFu7i)
//============================================================================


struct  S_BFu15s_BFu7ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:7;
};
//SIG(1 S_BFu15s_BFu7ll) C1{ Fs Fs:15 FL:7}



static void Test_S_BFu15s_BFu7ll()
{
  {
    init_simple_test("S_BFu15s_BFu7ll");
    static STRUCT_IF_C S_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu7ll, S_BFu15s_BFu7ll)
//============================================================================


struct  S_BFu15s_BFu7s  {
  short v1;
  unsigned short v2:15;
  unsigned short v3:7;
};
//SIG(1 S_BFu15s_BFu7s) C1{ Fs Fs:15 Fs:7}



static void Test_S_BFu15s_BFu7s()
{
  {
    init_simple_test("S_BFu15s_BFu7s");
    static STRUCT_IF_C S_BFu15s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu7s, S_BFu15s_BFu7s)
//============================================================================


struct  S_BFu15s_BFu8c  {
  short v1;
  unsigned short v2:15;
  unsigned char v3:8;
};
//SIG(1 S_BFu15s_BFu8c) C1{ Fs Fs:15 Fc:8}



static void Test_S_BFu15s_BFu8c()
{
  {
    init_simple_test("S_BFu15s_BFu8c");
    static STRUCT_IF_C S_BFu15s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu8c, S_BFu15s_BFu8c)
//============================================================================


struct  S_BFu15s_BFu8i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:8;
};
//SIG(1 S_BFu15s_BFu8i) C1{ Fs Fs:15 Fi:8}



static void Test_S_BFu15s_BFu8i()
{
  {
    init_simple_test("S_BFu15s_BFu8i");
    static STRUCT_IF_C S_BFu15s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu8i, S_BFu15s_BFu8i)
//============================================================================


struct  S_BFu15s_BFu8ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:8;
};
//SIG(1 S_BFu15s_BFu8ll) C1{ Fs Fs:15 FL:8}



static void Test_S_BFu15s_BFu8ll()
{
  {
    init_simple_test("S_BFu15s_BFu8ll");
    static STRUCT_IF_C S_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu8ll, S_BFu15s_BFu8ll)
//============================================================================


struct  S_BFu15s_BFu8s  {
  short v1;
  unsigned short v2:15;
  unsigned short v3:8;
};
//SIG(1 S_BFu15s_BFu8s) C1{ Fs Fs:15 Fs:8}



static void Test_S_BFu15s_BFu8s()
{
  {
    init_simple_test("S_BFu15s_BFu8s");
    static STRUCT_IF_C S_BFu15s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu8s, S_BFu15s_BFu8s)
//============================================================================


struct  S_BFu15s_BFu9i  {
  short v1;
  unsigned short v2:15;
  unsigned int v3:9;
};
//SIG(1 S_BFu15s_BFu9i) C1{ Fs Fs:15 Fi:9}



static void Test_S_BFu15s_BFu9i()
{
  {
    init_simple_test("S_BFu15s_BFu9i");
    static STRUCT_IF_C S_BFu15s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu9i, S_BFu15s_BFu9i)
//============================================================================


struct  S_BFu15s_BFu9ll  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3:9;
};
//SIG(1 S_BFu15s_BFu9ll) C1{ Fs Fs:15 FL:9}



static void Test_S_BFu15s_BFu9ll()
{
  {
    init_simple_test("S_BFu15s_BFu9ll");
    static STRUCT_IF_C S_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu9ll, S_BFu15s_BFu9ll)
//============================================================================


struct  S_BFu15s_BFu9s  {
  short v1;
  unsigned short v2:15;
  unsigned short v3:9;
};
//SIG(1 S_BFu15s_BFu9s) C1{ Fs Fs:15 Fs:9}



static void Test_S_BFu15s_BFu9s()
{
  {
    init_simple_test("S_BFu15s_BFu9s");
    static STRUCT_IF_C S_BFu15s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu9s, S_BFu15s_BFu9s)
//============================================================================


struct  S_BFu15s_C  {
  short v1;
  unsigned short v2:15;
  char v3;
};
//SIG(1 S_BFu15s_C) C1{ Fs Fs:15 Fc}



static void Test_S_BFu15s_C()
{
  {
    init_simple_test("S_BFu15s_C");
    static STRUCT_IF_C S_BFu15s_C lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_C)");
    check_field_offset(lv, v1, 0, "S_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_C");
    check_field_offset(lv, v3, 4, "S_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_C, S_BFu15s_C)
//============================================================================


struct  S_BFu15s_D  {
  short v1;
  unsigned short v2:15;
  double v3;
};
//SIG(1 S_BFu15s_D) C1{ Fs Fs:15 FL}



static void Test_S_BFu15s_D()
{
  {
    init_simple_test("S_BFu15s_D");
    static STRUCT_IF_C S_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_D)");
    check_field_offset(lv, v1, 0, "S_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_D, S_BFu15s_D)
//============================================================================


struct  S_BFu15s_F  {
  short v1;
  unsigned short v2:15;
  float v3;
};
//SIG(1 S_BFu15s_F) C1{ Fs Fs:15 Fi}



static void Test_S_BFu15s_F()
{
  {
    init_simple_test("S_BFu15s_F");
    static STRUCT_IF_C S_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_F)");
    check_field_offset(lv, v1, 0, "S_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_F");
    check_field_offset(lv, v3, 4, "S_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_F, S_BFu15s_F)
//============================================================================


struct  S_BFu15s_I  {
  short v1;
  unsigned short v2:15;
  int v3;
};
//SIG(1 S_BFu15s_I) C1{ Fs Fs:15 Fi}



static void Test_S_BFu15s_I()
{
  {
    init_simple_test("S_BFu15s_I");
    static STRUCT_IF_C S_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_I)");
    check_field_offset(lv, v1, 0, "S_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_I");
    check_field_offset(lv, v3, 4, "S_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_I, S_BFu15s_I)
//============================================================================


struct  S_BFu15s_Ip  {
  short v1;
  unsigned short v2:15;
  int *v3;
};
//SIG(1 S_BFu15s_Ip) C1{ Fs Fs:15 Fp}



static void Test_S_BFu15s_Ip()
{
  {
    init_simple_test("S_BFu15s_Ip");
    static STRUCT_IF_C S_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_Ip, S_BFu15s_Ip)
//============================================================================


struct  S_BFu15s_L  {
  short v1;
  unsigned short v2:15;
  __tsi64 v3;
};
//SIG(1 S_BFu15s_L) C1{ Fs Fs:15 FL}



static void Test_S_BFu15s_L()
{
  {
    init_simple_test("S_BFu15s_L");
    static STRUCT_IF_C S_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_L)");
    check_field_offset(lv, v1, 0, "S_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_L, S_BFu15s_L)
//============================================================================


struct  S_BFu15s_S  {
  short v1;
  unsigned short v2:15;
  short v3;
};
//SIG(1 S_BFu15s_S) C1{ Fs Fs:15 Fs}



static void Test_S_BFu15s_S()
{
  {
    init_simple_test("S_BFu15s_S");
    static STRUCT_IF_C S_BFu15s_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_S)");
    check_field_offset(lv, v1, 0, "S_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_S");
    check_field_offset(lv, v3, 4, "S_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_S, S_BFu15s_S)
//============================================================================


struct  S_BFu15s_Uc  {
  short v1;
  unsigned short v2:15;
  unsigned char v3;
};
//SIG(1 S_BFu15s_Uc) C1{ Fs Fs:15 Fc}



static void Test_S_BFu15s_Uc()
{
  {
    init_simple_test("S_BFu15s_Uc");
    static STRUCT_IF_C S_BFu15s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_Uc");
    check_field_offset(lv, v3, 4, "S_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_Uc, S_BFu15s_Uc)
//============================================================================


struct  S_BFu15s_Ui  {
  short v1;
  unsigned short v2:15;
  unsigned int v3;
};
//SIG(1 S_BFu15s_Ui) C1{ Fs Fs:15 Fi}



static void Test_S_BFu15s_Ui()
{
  {
    init_simple_test("S_BFu15s_Ui");
    static STRUCT_IF_C S_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_Ui");
    check_field_offset(lv, v3, 4, "S_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_Ui, S_BFu15s_Ui)
//============================================================================


struct  S_BFu15s_Ul  {
  short v1;
  unsigned short v2:15;
  __tsu64 v3;
};
//SIG(1 S_BFu15s_Ul) C1{ Fs Fs:15 FL}



static void Test_S_BFu15s_Ul()
{
  {
    init_simple_test("S_BFu15s_Ul");
    static STRUCT_IF_C S_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_Ul, S_BFu15s_Ul)
//============================================================================


struct  S_BFu15s_Us  {
  short v1;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 S_BFu15s_Us) C1{ Fs Fs:15 Fs}



static void Test_S_BFu15s_Us()
{
  {
    init_simple_test("S_BFu15s_Us");
    static STRUCT_IF_C S_BFu15s_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "S_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_Us");
    check_field_offset(lv, v3, 4, "S_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_Us, S_BFu15s_Us)
//============================================================================


struct  S_BFu15s_Vp  {
  short v1;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 S_BFu15s_Vp) C1{ Fs Fs:15 Fp}



static void Test_S_BFu15s_Vp()
{
  {
    init_simple_test("S_BFu15s_Vp");
    static STRUCT_IF_C S_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_Vp, S_BFu15s_Vp)
//============================================================================


struct  S_BFu16i  {
  short v1;
  unsigned int v2:16;
};
//SIG(1 S_BFu16i) C1{ Fs Fi:16}



static void Test_S_BFu16i()
{
  {
    init_simple_test("S_BFu16i");
    static STRUCT_IF_C S_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i, S_BFu16i)
//============================================================================


struct  S_BFu16i_BFu15i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 S_BFu16i_BFu15i) C1{ Fs Fi:16 Fi:15}



static void Test_S_BFu16i_BFu15i()
{
  {
    init_simple_test("S_BFu16i_BFu15i");
    static STRUCT_IF_C S_BFu16i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu15i, S_BFu16i_BFu15i)
//============================================================================


struct  S_BFu16i_BFu15ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 S_BFu16i_BFu15ll) C1{ Fs Fi:16 FL:15}



static void Test_S_BFu16i_BFu15ll()
{
  {
    init_simple_test("S_BFu16i_BFu15ll");
    static STRUCT_IF_C S_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu15ll, S_BFu16i_BFu15ll)
//============================================================================


struct  S_BFu16i_BFu15s  {
  short v1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 S_BFu16i_BFu15s) C1{ Fs Fi:16 Fs:15}



static void Test_S_BFu16i_BFu15s()
{
  {
    init_simple_test("S_BFu16i_BFu15s");
    static STRUCT_IF_C S_BFu16i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu15s, S_BFu16i_BFu15s)
//============================================================================


struct  S_BFu16i_BFu16i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 S_BFu16i_BFu16i) C1{ Fs Fi:16 Fi:16}



static void Test_S_BFu16i_BFu16i()
{
  {
    init_simple_test("S_BFu16i_BFu16i");
    static STRUCT_IF_C S_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu16i, S_BFu16i_BFu16i)
//============================================================================


struct  S_BFu16i_BFu16ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 S_BFu16i_BFu16ll) C1{ Fs Fi:16 FL:16}



static void Test_S_BFu16i_BFu16ll()
{
  {
    init_simple_test("S_BFu16i_BFu16ll");
    static STRUCT_IF_C S_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu16ll, S_BFu16i_BFu16ll)
//============================================================================


struct  S_BFu16i_BFu16s  {
  short v1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 S_BFu16i_BFu16s) C1{ Fs Fi:16 Fs:16}



static void Test_S_BFu16i_BFu16s()
{
  {
    init_simple_test("S_BFu16i_BFu16s");
    static STRUCT_IF_C S_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu16s, S_BFu16i_BFu16s)
//============================================================================


struct  S_BFu16i_BFu17i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 S_BFu16i_BFu17i) C1{ Fs Fi:16 Fi:17}



static void Test_S_BFu16i_BFu17i()
{
  {
    init_simple_test("S_BFu16i_BFu17i");
    static STRUCT_IF_C S_BFu16i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu17i, S_BFu16i_BFu17i)
//============================================================================


struct  S_BFu16i_BFu17ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 S_BFu16i_BFu17ll) C1{ Fs Fi:16 FL:17}



static void Test_S_BFu16i_BFu17ll()
{
  {
    init_simple_test("S_BFu16i_BFu17ll");
    static STRUCT_IF_C S_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu17ll, S_BFu16i_BFu17ll)
//============================================================================


struct  S_BFu16i_BFu1c  {
  short v1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 S_BFu16i_BFu1c) C1{ Fs Fi:16 Fc:1}



static void Test_S_BFu16i_BFu1c()
{
  {
    init_simple_test("S_BFu16i_BFu1c");
    static STRUCT_IF_C S_BFu16i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu1c, S_BFu16i_BFu1c)
//============================================================================


struct  S_BFu16i_BFu1i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 S_BFu16i_BFu1i) C1{ Fs Fi:16 Fi:1}



static void Test_S_BFu16i_BFu1i()
{
  {
    init_simple_test("S_BFu16i_BFu1i");
    static STRUCT_IF_C S_BFu16i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu1i, S_BFu16i_BFu1i)
//============================================================================


struct  S_BFu16i_BFu1ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 S_BFu16i_BFu1ll) C1{ Fs Fi:16 FL:1}



static void Test_S_BFu16i_BFu1ll()
{
  {
    init_simple_test("S_BFu16i_BFu1ll");
    static STRUCT_IF_C S_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu1ll, S_BFu16i_BFu1ll)
//============================================================================


struct  S_BFu16i_BFu1s  {
  short v1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 S_BFu16i_BFu1s) C1{ Fs Fi:16 Fs:1}



static void Test_S_BFu16i_BFu1s()
{
  {
    init_simple_test("S_BFu16i_BFu1s");
    static STRUCT_IF_C S_BFu16i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu1s, S_BFu16i_BFu1s)
//============================================================================


struct  S_BFu16i_BFu31i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 S_BFu16i_BFu31i) C1{ Fs Fi:16 Fi:31}



static void Test_S_BFu16i_BFu31i()
{
  {
    init_simple_test("S_BFu16i_BFu31i");
    static STRUCT_IF_C S_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu31i, S_BFu16i_BFu31i)
//============================================================================


struct  S_BFu16i_BFu31ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 S_BFu16i_BFu31ll) C1{ Fs Fi:16 FL:31}



static void Test_S_BFu16i_BFu31ll()
{
  {
    init_simple_test("S_BFu16i_BFu31ll");
    static STRUCT_IF_C S_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu31ll, S_BFu16i_BFu31ll)
//============================================================================


struct  S_BFu16i_BFu32i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 S_BFu16i_BFu32i) C1{ Fs Fi:16 Fi:32}



static void Test_S_BFu16i_BFu32i()
{
  {
    init_simple_test("S_BFu16i_BFu32i");
    static STRUCT_IF_C S_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu32i, S_BFu16i_BFu32i)
//============================================================================


struct  S_BFu16i_BFu32ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 S_BFu16i_BFu32ll) C1{ Fs Fi:16 FL:32}



static void Test_S_BFu16i_BFu32ll()
{
  {
    init_simple_test("S_BFu16i_BFu32ll");
    static STRUCT_IF_C S_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu32ll, S_BFu16i_BFu32ll)
//============================================================================


struct  S_BFu16i_BFu33  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 S_BFu16i_BFu33) C1{ Fs Fi:16 FL:33}



static void Test_S_BFu16i_BFu33()
{
  {
    init_simple_test("S_BFu16i_BFu33");
    static STRUCT_IF_C S_BFu16i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "S_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "S_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu33, S_BFu16i_BFu33)
//============================================================================


struct  S_BFu16i_BFu7c  {
  short v1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 S_BFu16i_BFu7c) C1{ Fs Fi:16 Fc:7}



static void Test_S_BFu16i_BFu7c()
{
  {
    init_simple_test("S_BFu16i_BFu7c");
    static STRUCT_IF_C S_BFu16i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu7c, S_BFu16i_BFu7c)
//============================================================================


struct  S_BFu16i_BFu7i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 S_BFu16i_BFu7i) C1{ Fs Fi:16 Fi:7}



static void Test_S_BFu16i_BFu7i()
{
  {
    init_simple_test("S_BFu16i_BFu7i");
    static STRUCT_IF_C S_BFu16i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu7i, S_BFu16i_BFu7i)
//============================================================================


struct  S_BFu16i_BFu7ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 S_BFu16i_BFu7ll) C1{ Fs Fi:16 FL:7}



static void Test_S_BFu16i_BFu7ll()
{
  {
    init_simple_test("S_BFu16i_BFu7ll");
    static STRUCT_IF_C S_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu7ll, S_BFu16i_BFu7ll)
//============================================================================


struct  S_BFu16i_BFu7s  {
  short v1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 S_BFu16i_BFu7s) C1{ Fs Fi:16 Fs:7}



static void Test_S_BFu16i_BFu7s()
{
  {
    init_simple_test("S_BFu16i_BFu7s");
    static STRUCT_IF_C S_BFu16i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu7s, S_BFu16i_BFu7s)
//============================================================================


struct  S_BFu16i_BFu8c  {
  short v1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 S_BFu16i_BFu8c) C1{ Fs Fi:16 Fc:8}



static void Test_S_BFu16i_BFu8c()
{
  {
    init_simple_test("S_BFu16i_BFu8c");
    static STRUCT_IF_C S_BFu16i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu8c, S_BFu16i_BFu8c)
//============================================================================


struct  S_BFu16i_BFu8i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 S_BFu16i_BFu8i) C1{ Fs Fi:16 Fi:8}



static void Test_S_BFu16i_BFu8i()
{
  {
    init_simple_test("S_BFu16i_BFu8i");
    static STRUCT_IF_C S_BFu16i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu8i, S_BFu16i_BFu8i)
//============================================================================


struct  S_BFu16i_BFu8ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 S_BFu16i_BFu8ll) C1{ Fs Fi:16 FL:8}



static void Test_S_BFu16i_BFu8ll()
{
  {
    init_simple_test("S_BFu16i_BFu8ll");
    static STRUCT_IF_C S_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu8ll, S_BFu16i_BFu8ll)
//============================================================================


struct  S_BFu16i_BFu8s  {
  short v1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 S_BFu16i_BFu8s) C1{ Fs Fi:16 Fs:8}



static void Test_S_BFu16i_BFu8s()
{
  {
    init_simple_test("S_BFu16i_BFu8s");
    static STRUCT_IF_C S_BFu16i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu8s, S_BFu16i_BFu8s)
//============================================================================


struct  S_BFu16i_BFu9i  {
  short v1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 S_BFu16i_BFu9i) C1{ Fs Fi:16 Fi:9}



static void Test_S_BFu16i_BFu9i()
{
  {
    init_simple_test("S_BFu16i_BFu9i");
    static STRUCT_IF_C S_BFu16i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu9i, S_BFu16i_BFu9i)
//============================================================================


struct  S_BFu16i_BFu9ll  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 S_BFu16i_BFu9ll) C1{ Fs Fi:16 FL:9}



static void Test_S_BFu16i_BFu9ll()
{
  {
    init_simple_test("S_BFu16i_BFu9ll");
    static STRUCT_IF_C S_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu9ll, S_BFu16i_BFu9ll)
//============================================================================


struct  S_BFu16i_BFu9s  {
  short v1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 S_BFu16i_BFu9s) C1{ Fs Fi:16 Fs:9}



static void Test_S_BFu16i_BFu9s()
{
  {
    init_simple_test("S_BFu16i_BFu9s");
    static STRUCT_IF_C S_BFu16i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_BFu9s, S_BFu16i_BFu9s)
//============================================================================


struct  S_BFu16i_C  {
  short v1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 S_BFu16i_C) C1{ Fs Fi:16 Fc}



static void Test_S_BFu16i_C()
{
  {
    init_simple_test("S_BFu16i_C");
    static STRUCT_IF_C S_BFu16i_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_C)");
    check_field_offset(lv, v1, 0, "S_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_C");
    check_field_offset(lv, v3, 4, "S_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_C, S_BFu16i_C)
//============================================================================


struct  S_BFu16i_D  {
  short v1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 S_BFu16i_D) C1{ Fs Fi:16 FL}



static void Test_S_BFu16i_D()
{
  {
    init_simple_test("S_BFu16i_D");
    static STRUCT_IF_C S_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_D)");
    check_field_offset(lv, v1, 0, "S_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_D, S_BFu16i_D)
//============================================================================


struct  S_BFu16i_F  {
  short v1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 S_BFu16i_F) C1{ Fs Fi:16 Fi}



static void Test_S_BFu16i_F()
{
  {
    init_simple_test("S_BFu16i_F");
    static STRUCT_IF_C S_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_F)");
    check_field_offset(lv, v1, 0, "S_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_F");
    check_field_offset(lv, v3, 4, "S_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_F, S_BFu16i_F)
//============================================================================


struct  S_BFu16i_I  {
  short v1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 S_BFu16i_I) C1{ Fs Fi:16 Fi}



static void Test_S_BFu16i_I()
{
  {
    init_simple_test("S_BFu16i_I");
    static STRUCT_IF_C S_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_I)");
    check_field_offset(lv, v1, 0, "S_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_I");
    check_field_offset(lv, v3, 4, "S_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_I, S_BFu16i_I)
//============================================================================


struct  S_BFu16i_Ip  {
  short v1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 S_BFu16i_Ip) C1{ Fs Fi:16 Fp}



static void Test_S_BFu16i_Ip()
{
  {
    init_simple_test("S_BFu16i_Ip");
    static STRUCT_IF_C S_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_Ip, S_BFu16i_Ip)
//============================================================================


struct  S_BFu16i_L  {
  short v1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 S_BFu16i_L) C1{ Fs Fi:16 FL}



static void Test_S_BFu16i_L()
{
  {
    init_simple_test("S_BFu16i_L");
    static STRUCT_IF_C S_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_L)");
    check_field_offset(lv, v1, 0, "S_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_L, S_BFu16i_L)
//============================================================================


struct  S_BFu16i_S  {
  short v1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 S_BFu16i_S) C1{ Fs Fi:16 Fs}



static void Test_S_BFu16i_S()
{
  {
    init_simple_test("S_BFu16i_S");
    static STRUCT_IF_C S_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_S)");
    check_field_offset(lv, v1, 0, "S_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_S");
    check_field_offset(lv, v3, 4, "S_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_S, S_BFu16i_S)
//============================================================================


struct  S_BFu16i_Uc  {
  short v1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 S_BFu16i_Uc) C1{ Fs Fi:16 Fc}



static void Test_S_BFu16i_Uc()
{
  {
    init_simple_test("S_BFu16i_Uc");
    static STRUCT_IF_C S_BFu16i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_Uc");
    check_field_offset(lv, v3, 4, "S_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_Uc, S_BFu16i_Uc)
//============================================================================


struct  S_BFu16i_Ui  {
  short v1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 S_BFu16i_Ui) C1{ Fs Fi:16 Fi}



static void Test_S_BFu16i_Ui()
{
  {
    init_simple_test("S_BFu16i_Ui");
    static STRUCT_IF_C S_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "S_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_Ui, S_BFu16i_Ui)
//============================================================================


struct  S_BFu16i_Ul  {
  short v1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 S_BFu16i_Ul) C1{ Fs Fi:16 FL}



static void Test_S_BFu16i_Ul()
{
  {
    init_simple_test("S_BFu16i_Ul");
    static STRUCT_IF_C S_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_Ul, S_BFu16i_Ul)
//============================================================================


struct  S_BFu16i_Us  {
  short v1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 S_BFu16i_Us) C1{ Fs Fi:16 Fs}



static void Test_S_BFu16i_Us()
{
  {
    init_simple_test("S_BFu16i_Us");
    static STRUCT_IF_C S_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_Us");
    check_field_offset(lv, v3, 4, "S_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_Us, S_BFu16i_Us)
//============================================================================


struct  S_BFu16i_Vp  {
  short v1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 S_BFu16i_Vp) C1{ Fs Fi:16 Fp}



static void Test_S_BFu16i_Vp()
{
  {
    init_simple_test("S_BFu16i_Vp");
    static STRUCT_IF_C S_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16i_Vp, S_BFu16i_Vp)
//============================================================================


struct  S_BFu16ll  {
  short v1;
  __tsu64 v2:16;
};
//SIG(1 S_BFu16ll) C1{ Fs FL:16}



static void Test_S_BFu16ll()
{
  {
    init_simple_test("S_BFu16ll");
    static STRUCT_IF_C S_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll, S_BFu16ll)
//============================================================================


struct  S_BFu16ll_BFu15i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 S_BFu16ll_BFu15i) C1{ Fs FL:16 Fi:15}



static void Test_S_BFu16ll_BFu15i()
{
  {
    init_simple_test("S_BFu16ll_BFu15i");
    static STRUCT_IF_C S_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu15i, S_BFu16ll_BFu15i)
//============================================================================


struct  S_BFu16ll_BFu15ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 S_BFu16ll_BFu15ll) C1{ Fs FL:16 FL:15}



static void Test_S_BFu16ll_BFu15ll()
{
  {
    init_simple_test("S_BFu16ll_BFu15ll");
    static STRUCT_IF_C S_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu15ll, S_BFu16ll_BFu15ll)
//============================================================================


struct  S_BFu16ll_BFu15s  {
  short v1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 S_BFu16ll_BFu15s) C1{ Fs FL:16 Fs:15}



static void Test_S_BFu16ll_BFu15s()
{
  {
    init_simple_test("S_BFu16ll_BFu15s");
    static STRUCT_IF_C S_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu15s, S_BFu16ll_BFu15s)
//============================================================================


struct  S_BFu16ll_BFu16i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 S_BFu16ll_BFu16i) C1{ Fs FL:16 Fi:16}



static void Test_S_BFu16ll_BFu16i()
{
  {
    init_simple_test("S_BFu16ll_BFu16i");
    static STRUCT_IF_C S_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu16i, S_BFu16ll_BFu16i)
//============================================================================


struct  S_BFu16ll_BFu16ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 S_BFu16ll_BFu16ll) C1{ Fs FL:16 FL:16}



static void Test_S_BFu16ll_BFu16ll()
{
  {
    init_simple_test("S_BFu16ll_BFu16ll");
    static STRUCT_IF_C S_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu16ll, S_BFu16ll_BFu16ll)
//============================================================================


struct  S_BFu16ll_BFu16s  {
  short v1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 S_BFu16ll_BFu16s) C1{ Fs FL:16 Fs:16}



static void Test_S_BFu16ll_BFu16s()
{
  {
    init_simple_test("S_BFu16ll_BFu16s");
    static STRUCT_IF_C S_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu16s, S_BFu16ll_BFu16s)
//============================================================================


struct  S_BFu16ll_BFu17i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 S_BFu16ll_BFu17i) C1{ Fs FL:16 Fi:17}



static void Test_S_BFu16ll_BFu17i()
{
  {
    init_simple_test("S_BFu16ll_BFu17i");
    static STRUCT_IF_C S_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu17i, S_BFu16ll_BFu17i)
//============================================================================


struct  S_BFu16ll_BFu17ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 S_BFu16ll_BFu17ll) C1{ Fs FL:16 FL:17}



static void Test_S_BFu16ll_BFu17ll()
{
  {
    init_simple_test("S_BFu16ll_BFu17ll");
    static STRUCT_IF_C S_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu17ll, S_BFu16ll_BFu17ll)
//============================================================================


struct  S_BFu16ll_BFu1c  {
  short v1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 S_BFu16ll_BFu1c) C1{ Fs FL:16 Fc:1}



static void Test_S_BFu16ll_BFu1c()
{
  {
    init_simple_test("S_BFu16ll_BFu1c");
    static STRUCT_IF_C S_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu1c, S_BFu16ll_BFu1c)
//============================================================================


struct  S_BFu16ll_BFu1i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 S_BFu16ll_BFu1i) C1{ Fs FL:16 Fi:1}



static void Test_S_BFu16ll_BFu1i()
{
  {
    init_simple_test("S_BFu16ll_BFu1i");
    static STRUCT_IF_C S_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu1i, S_BFu16ll_BFu1i)
//============================================================================


struct  S_BFu16ll_BFu1ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 S_BFu16ll_BFu1ll) C1{ Fs FL:16 FL:1}



static void Test_S_BFu16ll_BFu1ll()
{
  {
    init_simple_test("S_BFu16ll_BFu1ll");
    static STRUCT_IF_C S_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu1ll, S_BFu16ll_BFu1ll)
//============================================================================


struct  S_BFu16ll_BFu1s  {
  short v1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 S_BFu16ll_BFu1s) C1{ Fs FL:16 Fs:1}



static void Test_S_BFu16ll_BFu1s()
{
  {
    init_simple_test("S_BFu16ll_BFu1s");
    static STRUCT_IF_C S_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu1s, S_BFu16ll_BFu1s)
//============================================================================


struct  S_BFu16ll_BFu31i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 S_BFu16ll_BFu31i) C1{ Fs FL:16 Fi:31}



static void Test_S_BFu16ll_BFu31i()
{
  {
    init_simple_test("S_BFu16ll_BFu31i");
    static STRUCT_IF_C S_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu31i, S_BFu16ll_BFu31i)
//============================================================================


struct  S_BFu16ll_BFu31ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 S_BFu16ll_BFu31ll) C1{ Fs FL:16 FL:31}



static void Test_S_BFu16ll_BFu31ll()
{
  {
    init_simple_test("S_BFu16ll_BFu31ll");
    static STRUCT_IF_C S_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu31ll, S_BFu16ll_BFu31ll)
//============================================================================


struct  S_BFu16ll_BFu32i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 S_BFu16ll_BFu32i) C1{ Fs FL:16 Fi:32}



static void Test_S_BFu16ll_BFu32i()
{
  {
    init_simple_test("S_BFu16ll_BFu32i");
    static STRUCT_IF_C S_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu32i, S_BFu16ll_BFu32i)
//============================================================================


struct  S_BFu16ll_BFu32ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 S_BFu16ll_BFu32ll) C1{ Fs FL:16 FL:32}



static void Test_S_BFu16ll_BFu32ll()
{
  {
    init_simple_test("S_BFu16ll_BFu32ll");
    static STRUCT_IF_C S_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu32ll, S_BFu16ll_BFu32ll)
//============================================================================


struct  S_BFu16ll_BFu33  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 S_BFu16ll_BFu33) C1{ Fs FL:16 FL:33}



static void Test_S_BFu16ll_BFu33()
{
  {
    init_simple_test("S_BFu16ll_BFu33");
    static STRUCT_IF_C S_BFu16ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "S_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "S_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu33, S_BFu16ll_BFu33)
//============================================================================


struct  S_BFu16ll_BFu7c  {
  short v1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 S_BFu16ll_BFu7c) C1{ Fs FL:16 Fc:7}



static void Test_S_BFu16ll_BFu7c()
{
  {
    init_simple_test("S_BFu16ll_BFu7c");
    static STRUCT_IF_C S_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu7c, S_BFu16ll_BFu7c)
//============================================================================


struct  S_BFu16ll_BFu7i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 S_BFu16ll_BFu7i) C1{ Fs FL:16 Fi:7}



static void Test_S_BFu16ll_BFu7i()
{
  {
    init_simple_test("S_BFu16ll_BFu7i");
    static STRUCT_IF_C S_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu7i, S_BFu16ll_BFu7i)
//============================================================================


struct  S_BFu16ll_BFu7ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 S_BFu16ll_BFu7ll) C1{ Fs FL:16 FL:7}



static void Test_S_BFu16ll_BFu7ll()
{
  {
    init_simple_test("S_BFu16ll_BFu7ll");
    static STRUCT_IF_C S_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu7ll, S_BFu16ll_BFu7ll)
//============================================================================


struct  S_BFu16ll_BFu7s  {
  short v1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 S_BFu16ll_BFu7s) C1{ Fs FL:16 Fs:7}



static void Test_S_BFu16ll_BFu7s()
{
  {
    init_simple_test("S_BFu16ll_BFu7s");
    static STRUCT_IF_C S_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu7s, S_BFu16ll_BFu7s)
//============================================================================


struct  S_BFu16ll_BFu8c  {
  short v1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 S_BFu16ll_BFu8c) C1{ Fs FL:16 Fc:8}



static void Test_S_BFu16ll_BFu8c()
{
  {
    init_simple_test("S_BFu16ll_BFu8c");
    static STRUCT_IF_C S_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu8c, S_BFu16ll_BFu8c)
//============================================================================


struct  S_BFu16ll_BFu8i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 S_BFu16ll_BFu8i) C1{ Fs FL:16 Fi:8}



static void Test_S_BFu16ll_BFu8i()
{
  {
    init_simple_test("S_BFu16ll_BFu8i");
    static STRUCT_IF_C S_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu8i, S_BFu16ll_BFu8i)
//============================================================================


struct  S_BFu16ll_BFu8ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 S_BFu16ll_BFu8ll) C1{ Fs FL:16 FL:8}



static void Test_S_BFu16ll_BFu8ll()
{
  {
    init_simple_test("S_BFu16ll_BFu8ll");
    static STRUCT_IF_C S_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu8ll, S_BFu16ll_BFu8ll)
//============================================================================


struct  S_BFu16ll_BFu8s  {
  short v1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 S_BFu16ll_BFu8s) C1{ Fs FL:16 Fs:8}



static void Test_S_BFu16ll_BFu8s()
{
  {
    init_simple_test("S_BFu16ll_BFu8s");
    static STRUCT_IF_C S_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu8s, S_BFu16ll_BFu8s)
//============================================================================


struct  S_BFu16ll_BFu9i  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 S_BFu16ll_BFu9i) C1{ Fs FL:16 Fi:9}



static void Test_S_BFu16ll_BFu9i()
{
  {
    init_simple_test("S_BFu16ll_BFu9i");
    static STRUCT_IF_C S_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu9i, S_BFu16ll_BFu9i)
//============================================================================


struct  S_BFu16ll_BFu9ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 S_BFu16ll_BFu9ll) C1{ Fs FL:16 FL:9}



static void Test_S_BFu16ll_BFu9ll()
{
  {
    init_simple_test("S_BFu16ll_BFu9ll");
    static STRUCT_IF_C S_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu9ll, S_BFu16ll_BFu9ll)
//============================================================================


struct  S_BFu16ll_BFu9s  {
  short v1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 S_BFu16ll_BFu9s) C1{ Fs FL:16 Fs:9}



static void Test_S_BFu16ll_BFu9s()
{
  {
    init_simple_test("S_BFu16ll_BFu9s");
    static STRUCT_IF_C S_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_BFu9s, S_BFu16ll_BFu9s)
//============================================================================


struct  S_BFu16ll_C  {
  short v1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 S_BFu16ll_C) C1{ Fs FL:16 Fc}



static void Test_S_BFu16ll_C()
{
  {
    init_simple_test("S_BFu16ll_C");
    static STRUCT_IF_C S_BFu16ll_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_C");
    check_field_offset(lv, v3, 4, "S_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_C, S_BFu16ll_C)
//============================================================================


struct  S_BFu16ll_D  {
  short v1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 S_BFu16ll_D) C1{ Fs FL:16 FL}



static void Test_S_BFu16ll_D()
{
  {
    init_simple_test("S_BFu16ll_D");
    static STRUCT_IF_C S_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_D, S_BFu16ll_D)
//============================================================================


struct  S_BFu16ll_F  {
  short v1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 S_BFu16ll_F) C1{ Fs FL:16 Fi}



static void Test_S_BFu16ll_F()
{
  {
    init_simple_test("S_BFu16ll_F");
    static STRUCT_IF_C S_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_F");
    check_field_offset(lv, v3, 4, "S_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_F, S_BFu16ll_F)
//============================================================================


struct  S_BFu16ll_I  {
  short v1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 S_BFu16ll_I) C1{ Fs FL:16 Fi}



static void Test_S_BFu16ll_I()
{
  {
    init_simple_test("S_BFu16ll_I");
    static STRUCT_IF_C S_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_I");
    check_field_offset(lv, v3, 4, "S_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_I, S_BFu16ll_I)
//============================================================================


struct  S_BFu16ll_Ip  {
  short v1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 S_BFu16ll_Ip) C1{ Fs FL:16 Fp}



static void Test_S_BFu16ll_Ip()
{
  {
    init_simple_test("S_BFu16ll_Ip");
    static STRUCT_IF_C S_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_Ip, S_BFu16ll_Ip)
//============================================================================


struct  S_BFu16ll_L  {
  short v1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 S_BFu16ll_L) C1{ Fs FL:16 FL}



static void Test_S_BFu16ll_L()
{
  {
    init_simple_test("S_BFu16ll_L");
    static STRUCT_IF_C S_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_L, S_BFu16ll_L)
//============================================================================


struct  S_BFu16ll_S  {
  short v1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 S_BFu16ll_S) C1{ Fs FL:16 Fs}



static void Test_S_BFu16ll_S()
{
  {
    init_simple_test("S_BFu16ll_S");
    static STRUCT_IF_C S_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_S");
    check_field_offset(lv, v3, 4, "S_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_S, S_BFu16ll_S)
//============================================================================


struct  S_BFu16ll_Uc  {
  short v1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 S_BFu16ll_Uc) C1{ Fs FL:16 Fc}



static void Test_S_BFu16ll_Uc()
{
  {
    init_simple_test("S_BFu16ll_Uc");
    static STRUCT_IF_C S_BFu16ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_Uc");
    check_field_offset(lv, v3, 4, "S_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_Uc, S_BFu16ll_Uc)
//============================================================================


struct  S_BFu16ll_Ui  {
  short v1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 S_BFu16ll_Ui) C1{ Fs FL:16 Fi}



static void Test_S_BFu16ll_Ui()
{
  {
    init_simple_test("S_BFu16ll_Ui");
    static STRUCT_IF_C S_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "S_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_Ui, S_BFu16ll_Ui)
//============================================================================


struct  S_BFu16ll_Ul  {
  short v1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 S_BFu16ll_Ul) C1{ Fs FL:16 FL}



static void Test_S_BFu16ll_Ul()
{
  {
    init_simple_test("S_BFu16ll_Ul");
    static STRUCT_IF_C S_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_Ul, S_BFu16ll_Ul)
//============================================================================


struct  S_BFu16ll_Us  {
  short v1;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 S_BFu16ll_Us) C1{ Fs FL:16 Fs}



static void Test_S_BFu16ll_Us()
{
  {
    init_simple_test("S_BFu16ll_Us");
    static STRUCT_IF_C S_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_Us");
    check_field_offset(lv, v3, 4, "S_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_Us, S_BFu16ll_Us)
//============================================================================


struct  S_BFu16ll_Vp  {
  short v1;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 S_BFu16ll_Vp) C1{ Fs FL:16 Fp}



static void Test_S_BFu16ll_Vp()
{
  {
    init_simple_test("S_BFu16ll_Vp");
    static STRUCT_IF_C S_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16ll_Vp, S_BFu16ll_Vp)
//============================================================================


struct  S_BFu16s  {
  short v1;
  unsigned short v2:16;
};
//SIG(1 S_BFu16s) C1{ Fs Fs:16}



static void Test_S_BFu16s()
{
  {
    init_simple_test("S_BFu16s");
    static STRUCT_IF_C S_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s, S_BFu16s)
//============================================================================


struct  S_BFu16s_BFu15i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 S_BFu16s_BFu15i) C1{ Fs Fs:16 Fi:15}



static void Test_S_BFu16s_BFu15i()
{
  {
    init_simple_test("S_BFu16s_BFu15i");
    static STRUCT_IF_C S_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu15i, S_BFu16s_BFu15i)
//============================================================================


struct  S_BFu16s_BFu15ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 S_BFu16s_BFu15ll) C1{ Fs Fs:16 FL:15}



static void Test_S_BFu16s_BFu15ll()
{
  {
    init_simple_test("S_BFu16s_BFu15ll");
    static STRUCT_IF_C S_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu15ll, S_BFu16s_BFu15ll)
//============================================================================


struct  S_BFu16s_BFu15s  {
  short v1;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 S_BFu16s_BFu15s) C1{ Fs Fs:16 Fs:15}



static void Test_S_BFu16s_BFu15s()
{
  {
    init_simple_test("S_BFu16s_BFu15s");
    static STRUCT_IF_C S_BFu16s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu15s, S_BFu16s_BFu15s)
//============================================================================


struct  S_BFu16s_BFu16i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 S_BFu16s_BFu16i) C1{ Fs Fs:16 Fi:16}



static void Test_S_BFu16s_BFu16i()
{
  {
    init_simple_test("S_BFu16s_BFu16i");
    static STRUCT_IF_C S_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu16i, S_BFu16s_BFu16i)
//============================================================================


struct  S_BFu16s_BFu16ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 S_BFu16s_BFu16ll) C1{ Fs Fs:16 FL:16}



static void Test_S_BFu16s_BFu16ll()
{
  {
    init_simple_test("S_BFu16s_BFu16ll");
    static STRUCT_IF_C S_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu16ll, S_BFu16s_BFu16ll)
//============================================================================


struct  S_BFu16s_BFu16s  {
  short v1;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 S_BFu16s_BFu16s) C1{ Fs Fs:16 Fs:16}



static void Test_S_BFu16s_BFu16s()
{
  {
    init_simple_test("S_BFu16s_BFu16s");
    static STRUCT_IF_C S_BFu16s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu16s, S_BFu16s_BFu16s)
//============================================================================


struct  S_BFu16s_BFu17i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 S_BFu16s_BFu17i) C1{ Fs Fs:16 Fi:17}



static void Test_S_BFu16s_BFu17i()
{
  {
    init_simple_test("S_BFu16s_BFu17i");
    static STRUCT_IF_C S_BFu16s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu17i, S_BFu16s_BFu17i)
//============================================================================


struct  S_BFu16s_BFu17ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 S_BFu16s_BFu17ll) C1{ Fs Fs:16 FL:17}



static void Test_S_BFu16s_BFu17ll()
{
  {
    init_simple_test("S_BFu16s_BFu17ll");
    static STRUCT_IF_C S_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu17ll, S_BFu16s_BFu17ll)
//============================================================================


struct  S_BFu16s_BFu1c  {
  short v1;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 S_BFu16s_BFu1c) C1{ Fs Fs:16 Fc:1}



static void Test_S_BFu16s_BFu1c()
{
  {
    init_simple_test("S_BFu16s_BFu1c");
    static STRUCT_IF_C S_BFu16s_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu1c, S_BFu16s_BFu1c)
//============================================================================


struct  S_BFu16s_BFu1i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 S_BFu16s_BFu1i) C1{ Fs Fs:16 Fi:1}



static void Test_S_BFu16s_BFu1i()
{
  {
    init_simple_test("S_BFu16s_BFu1i");
    static STRUCT_IF_C S_BFu16s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu1i, S_BFu16s_BFu1i)
//============================================================================


struct  S_BFu16s_BFu1ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 S_BFu16s_BFu1ll) C1{ Fs Fs:16 FL:1}



static void Test_S_BFu16s_BFu1ll()
{
  {
    init_simple_test("S_BFu16s_BFu1ll");
    static STRUCT_IF_C S_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu1ll, S_BFu16s_BFu1ll)
//============================================================================


struct  S_BFu16s_BFu1s  {
  short v1;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 S_BFu16s_BFu1s) C1{ Fs Fs:16 Fs:1}



static void Test_S_BFu16s_BFu1s()
{
  {
    init_simple_test("S_BFu16s_BFu1s");
    static STRUCT_IF_C S_BFu16s_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "S_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu1s, S_BFu16s_BFu1s)
//============================================================================


struct  S_BFu16s_BFu31i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 S_BFu16s_BFu31i) C1{ Fs Fs:16 Fi:31}



static void Test_S_BFu16s_BFu31i()
{
  {
    init_simple_test("S_BFu16s_BFu31i");
    static STRUCT_IF_C S_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu31i, S_BFu16s_BFu31i)
//============================================================================


struct  S_BFu16s_BFu31ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 S_BFu16s_BFu31ll) C1{ Fs Fs:16 FL:31}



static void Test_S_BFu16s_BFu31ll()
{
  {
    init_simple_test("S_BFu16s_BFu31ll");
    static STRUCT_IF_C S_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu31ll, S_BFu16s_BFu31ll)
//============================================================================


struct  S_BFu16s_BFu32i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 S_BFu16s_BFu32i) C1{ Fs Fs:16 Fi:32}



static void Test_S_BFu16s_BFu32i()
{
  {
    init_simple_test("S_BFu16s_BFu32i");
    static STRUCT_IF_C S_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu32i, S_BFu16s_BFu32i)
//============================================================================


struct  S_BFu16s_BFu32ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 S_BFu16s_BFu32ll) C1{ Fs Fs:16 FL:32}



static void Test_S_BFu16s_BFu32ll()
{
  {
    init_simple_test("S_BFu16s_BFu32ll");
    static STRUCT_IF_C S_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu32ll, S_BFu16s_BFu32ll)
//============================================================================


struct  S_BFu16s_BFu33  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 S_BFu16s_BFu33) C1{ Fs Fs:16 FL:33}



static void Test_S_BFu16s_BFu33()
{
  {
    init_simple_test("S_BFu16s_BFu33");
    static STRUCT_IF_C S_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "S_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "S_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu33, S_BFu16s_BFu33)
//============================================================================


struct  S_BFu16s_BFu7c  {
  short v1;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 S_BFu16s_BFu7c) C1{ Fs Fs:16 Fc:7}



static void Test_S_BFu16s_BFu7c()
{
  {
    init_simple_test("S_BFu16s_BFu7c");
    static STRUCT_IF_C S_BFu16s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu7c, S_BFu16s_BFu7c)
//============================================================================


struct  S_BFu16s_BFu7i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 S_BFu16s_BFu7i) C1{ Fs Fs:16 Fi:7}



static void Test_S_BFu16s_BFu7i()
{
  {
    init_simple_test("S_BFu16s_BFu7i");
    static STRUCT_IF_C S_BFu16s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu7i, S_BFu16s_BFu7i)
//============================================================================


struct  S_BFu16s_BFu7ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 S_BFu16s_BFu7ll) C1{ Fs Fs:16 FL:7}



static void Test_S_BFu16s_BFu7ll()
{
  {
    init_simple_test("S_BFu16s_BFu7ll");
    static STRUCT_IF_C S_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu7ll, S_BFu16s_BFu7ll)
//============================================================================


struct  S_BFu16s_BFu7s  {
  short v1;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 S_BFu16s_BFu7s) C1{ Fs Fs:16 Fs:7}



static void Test_S_BFu16s_BFu7s()
{
  {
    init_simple_test("S_BFu16s_BFu7s");
    static STRUCT_IF_C S_BFu16s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "S_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "S_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu7s, S_BFu16s_BFu7s)
//============================================================================


struct  S_BFu16s_BFu8c  {
  short v1;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 S_BFu16s_BFu8c) C1{ Fs Fs:16 Fc:8}



static void Test_S_BFu16s_BFu8c()
{
  {
    init_simple_test("S_BFu16s_BFu8c");
    static STRUCT_IF_C S_BFu16s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu8c, S_BFu16s_BFu8c)
//============================================================================


struct  S_BFu16s_BFu8i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 S_BFu16s_BFu8i) C1{ Fs Fs:16 Fi:8}



static void Test_S_BFu16s_BFu8i()
{
  {
    init_simple_test("S_BFu16s_BFu8i");
    static STRUCT_IF_C S_BFu16s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu8i, S_BFu16s_BFu8i)
//============================================================================


struct  S_BFu16s_BFu8ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 S_BFu16s_BFu8ll) C1{ Fs Fs:16 FL:8}



static void Test_S_BFu16s_BFu8ll()
{
  {
    init_simple_test("S_BFu16s_BFu8ll");
    static STRUCT_IF_C S_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu8ll, S_BFu16s_BFu8ll)
//============================================================================


struct  S_BFu16s_BFu8s  {
  short v1;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 S_BFu16s_BFu8s) C1{ Fs Fs:16 Fs:8}



static void Test_S_BFu16s_BFu8s()
{
  {
    init_simple_test("S_BFu16s_BFu8s");
    static STRUCT_IF_C S_BFu16s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu8s, S_BFu16s_BFu8s)
//============================================================================


struct  S_BFu16s_BFu9i  {
  short v1;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 S_BFu16s_BFu9i) C1{ Fs Fs:16 Fi:9}



static void Test_S_BFu16s_BFu9i()
{
  {
    init_simple_test("S_BFu16s_BFu9i");
    static STRUCT_IF_C S_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu9i, S_BFu16s_BFu9i)
//============================================================================


struct  S_BFu16s_BFu9ll  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 S_BFu16s_BFu9ll) C1{ Fs Fs:16 FL:9}



static void Test_S_BFu16s_BFu9ll()
{
  {
    init_simple_test("S_BFu16s_BFu9ll");
    static STRUCT_IF_C S_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu9ll, S_BFu16s_BFu9ll)
//============================================================================


struct  S_BFu16s_BFu9s  {
  short v1;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 S_BFu16s_BFu9s) C1{ Fs Fs:16 Fs:9}



static void Test_S_BFu16s_BFu9s()
{
  {
    init_simple_test("S_BFu16s_BFu9s");
    static STRUCT_IF_C S_BFu16s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_BFu9s, S_BFu16s_BFu9s)
//============================================================================


struct  S_BFu16s_C  {
  short v1;
  unsigned short v2:16;
  char v3;
};
//SIG(1 S_BFu16s_C) C1{ Fs Fs:16 Fc}



static void Test_S_BFu16s_C()
{
  {
    init_simple_test("S_BFu16s_C");
    static STRUCT_IF_C S_BFu16s_C lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_C)");
    check_field_offset(lv, v1, 0, "S_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_C");
    check_field_offset(lv, v3, 4, "S_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_C, S_BFu16s_C)
//============================================================================


struct  S_BFu16s_D  {
  short v1;
  unsigned short v2:16;
  double v3;
};
//SIG(1 S_BFu16s_D) C1{ Fs Fs:16 FL}



static void Test_S_BFu16s_D()
{
  {
    init_simple_test("S_BFu16s_D");
    static STRUCT_IF_C S_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_D)");
    check_field_offset(lv, v1, 0, "S_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_D, S_BFu16s_D)
//============================================================================


struct  S_BFu16s_F  {
  short v1;
  unsigned short v2:16;
  float v3;
};
//SIG(1 S_BFu16s_F) C1{ Fs Fs:16 Fi}



static void Test_S_BFu16s_F()
{
  {
    init_simple_test("S_BFu16s_F");
    static STRUCT_IF_C S_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_F)");
    check_field_offset(lv, v1, 0, "S_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_F");
    check_field_offset(lv, v3, 4, "S_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_F, S_BFu16s_F)
//============================================================================


struct  S_BFu16s_I  {
  short v1;
  unsigned short v2:16;
  int v3;
};
//SIG(1 S_BFu16s_I) C1{ Fs Fs:16 Fi}



static void Test_S_BFu16s_I()
{
  {
    init_simple_test("S_BFu16s_I");
    static STRUCT_IF_C S_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_I)");
    check_field_offset(lv, v1, 0, "S_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_I");
    check_field_offset(lv, v3, 4, "S_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_I, S_BFu16s_I)
//============================================================================


struct  S_BFu16s_Ip  {
  short v1;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 S_BFu16s_Ip) C1{ Fs Fs:16 Fp}



static void Test_S_BFu16s_Ip()
{
  {
    init_simple_test("S_BFu16s_Ip");
    static STRUCT_IF_C S_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_Ip, S_BFu16s_Ip)
//============================================================================


struct  S_BFu16s_L  {
  short v1;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 S_BFu16s_L) C1{ Fs Fs:16 FL}



static void Test_S_BFu16s_L()
{
  {
    init_simple_test("S_BFu16s_L");
    static STRUCT_IF_C S_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_L)");
    check_field_offset(lv, v1, 0, "S_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_L, S_BFu16s_L)
//============================================================================


struct  S_BFu16s_S  {
  short v1;
  unsigned short v2:16;
  short v3;
};
//SIG(1 S_BFu16s_S) C1{ Fs Fs:16 Fs}



static void Test_S_BFu16s_S()
{
  {
    init_simple_test("S_BFu16s_S");
    static STRUCT_IF_C S_BFu16s_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_S)");
    check_field_offset(lv, v1, 0, "S_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_S");
    check_field_offset(lv, v3, 4, "S_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_S, S_BFu16s_S)
//============================================================================


struct  S_BFu16s_Uc  {
  short v1;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 S_BFu16s_Uc) C1{ Fs Fs:16 Fc}



static void Test_S_BFu16s_Uc()
{
  {
    init_simple_test("S_BFu16s_Uc");
    static STRUCT_IF_C S_BFu16s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_Uc");
    check_field_offset(lv, v3, 4, "S_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_Uc, S_BFu16s_Uc)
//============================================================================


struct  S_BFu16s_Ui  {
  short v1;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 S_BFu16s_Ui) C1{ Fs Fs:16 Fi}



static void Test_S_BFu16s_Ui()
{
  {
    init_simple_test("S_BFu16s_Ui");
    static STRUCT_IF_C S_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu16s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_Ui");
    check_field_offset(lv, v3, 4, "S_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_Ui, S_BFu16s_Ui)
//============================================================================


struct  S_BFu16s_Ul  {
  short v1;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 S_BFu16s_Ul) C1{ Fs Fs:16 FL}



static void Test_S_BFu16s_Ul()
{
  {
    init_simple_test("S_BFu16s_Ul");
    static STRUCT_IF_C S_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_Ul, S_BFu16s_Ul)
//============================================================================


struct  S_BFu16s_Us  {
  short v1;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 S_BFu16s_Us) C1{ Fs Fs:16 Fs}



static void Test_S_BFu16s_Us()
{
  {
    init_simple_test("S_BFu16s_Us");
    static STRUCT_IF_C S_BFu16s_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu16s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "S_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_Us");
    check_field_offset(lv, v3, 4, "S_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_Us, S_BFu16s_Us)
//============================================================================


struct  S_BFu16s_Vp  {
  short v1;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 S_BFu16s_Vp) C1{ Fs Fs:16 Fp}



static void Test_S_BFu16s_Vp()
{
  {
    init_simple_test("S_BFu16s_Vp");
    static STRUCT_IF_C S_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu16s_Vp, S_BFu16s_Vp)
//============================================================================


struct  S_BFu17i  {
  short v1;
  unsigned int v2:17;
};
//SIG(1 S_BFu17i) C1{ Fs Fi:17}



static void Test_S_BFu17i()
{
  {
    init_simple_test("S_BFu17i");
    static STRUCT_IF_C S_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i, S_BFu17i)
//============================================================================


struct  S_BFu17i_BFu15i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 S_BFu17i_BFu15i) C1{ Fs Fi:17 Fi:15}



static void Test_S_BFu17i_BFu15i()
{
  {
    init_simple_test("S_BFu17i_BFu15i");
    static STRUCT_IF_C S_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "S_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "S_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu15i, S_BFu17i_BFu15i)
//============================================================================


struct  S_BFu17i_BFu15ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 S_BFu17i_BFu15ll) C1{ Fs Fi:17 FL:15}



static void Test_S_BFu17i_BFu15ll()
{
  {
    init_simple_test("S_BFu17i_BFu15ll");
    static STRUCT_IF_C S_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "S_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "S_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu15ll, S_BFu17i_BFu15ll)
//============================================================================


struct  S_BFu17i_BFu15s  {
  short v1;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 S_BFu17i_BFu15s) C1{ Fs Fi:17 Fs:15}



static void Test_S_BFu17i_BFu15s()
{
  {
    init_simple_test("S_BFu17i_BFu15s");
    static STRUCT_IF_C S_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "S_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "S_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu15s, S_BFu17i_BFu15s)
//============================================================================


struct  S_BFu17i_BFu16i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 S_BFu17i_BFu16i) C1{ Fs Fi:17 Fi:16}



static void Test_S_BFu17i_BFu16i()
{
  {
    init_simple_test("S_BFu17i_BFu16i");
    static STRUCT_IF_C S_BFu17i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu16i, S_BFu17i_BFu16i)
//============================================================================


struct  S_BFu17i_BFu16ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 S_BFu17i_BFu16ll) C1{ Fs Fi:17 FL:16}



static void Test_S_BFu17i_BFu16ll()
{
  {
    init_simple_test("S_BFu17i_BFu16ll");
    static STRUCT_IF_C S_BFu17i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, 1, "S_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, hide_ull(1LL<<15), "S_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu16ll, S_BFu17i_BFu16ll)
//============================================================================


struct  S_BFu17i_BFu16s  {
  short v1;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 S_BFu17i_BFu16s) C1{ Fs Fi:17 Fs:16}



static void Test_S_BFu17i_BFu16s()
{
  {
    init_simple_test("S_BFu17i_BFu16s");
    static STRUCT_IF_C S_BFu17i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu16s, S_BFu17i_BFu16s)
//============================================================================


struct  S_BFu17i_BFu17i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 S_BFu17i_BFu17i) C1{ Fs Fi:17 Fi:17}



static void Test_S_BFu17i_BFu17i()
{
  {
    init_simple_test("S_BFu17i_BFu17i");
    static STRUCT_IF_C S_BFu17i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "S_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu17i, S_BFu17i_BFu17i)
//============================================================================


struct  S_BFu17i_BFu17ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 S_BFu17i_BFu17ll) C1{ Fs Fi:17 FL:17}



static void Test_S_BFu17i_BFu17ll()
{
  {
    init_simple_test("S_BFu17i_BFu17ll");
    static STRUCT_IF_C S_BFu17i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, 1, "S_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, hide_ull(1LL<<16), "S_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu17ll, S_BFu17i_BFu17ll)
//============================================================================


struct  S_BFu17i_BFu1c  {
  short v1;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 S_BFu17i_BFu1c) C1{ Fs Fi:17 Fc:1}



static void Test_S_BFu17i_BFu1c()
{
  {
    init_simple_test("S_BFu17i_BFu1c");
    static STRUCT_IF_C S_BFu17i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "S_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu1c, S_BFu17i_BFu1c)
//============================================================================


struct  S_BFu17i_BFu1i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 S_BFu17i_BFu1i) C1{ Fs Fi:17 Fi:1}



static void Test_S_BFu17i_BFu1i()
{
  {
    init_simple_test("S_BFu17i_BFu1i");
    static STRUCT_IF_C S_BFu17i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "S_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu1i, S_BFu17i_BFu1i)
//============================================================================


struct  S_BFu17i_BFu1ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 S_BFu17i_BFu1ll) C1{ Fs Fi:17 FL:1}



static void Test_S_BFu17i_BFu1ll()
{
  {
    init_simple_test("S_BFu17i_BFu1ll");
    static STRUCT_IF_C S_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "S_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu1ll, S_BFu17i_BFu1ll)
//============================================================================


struct  S_BFu17i_BFu1s  {
  short v1;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 S_BFu17i_BFu1s) C1{ Fs Fi:17 Fs:1}



static void Test_S_BFu17i_BFu1s()
{
  {
    init_simple_test("S_BFu17i_BFu1s");
    static STRUCT_IF_C S_BFu17i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "S_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu1s, S_BFu17i_BFu1s)
//============================================================================


struct  S_BFu17i_BFu31i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 S_BFu17i_BFu31i) C1{ Fs Fi:17 Fi:31}



static void Test_S_BFu17i_BFu31i()
{
  {
    init_simple_test("S_BFu17i_BFu31i");
    static STRUCT_IF_C S_BFu17i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "S_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "S_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu31i, S_BFu17i_BFu31i)
//============================================================================


struct  S_BFu17i_BFu31ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 S_BFu17i_BFu31ll) C1{ Fs Fi:17 FL:31}



static void Test_S_BFu17i_BFu31ll()
{
  {
    init_simple_test("S_BFu17i_BFu31ll");
    static STRUCT_IF_C S_BFu17i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, 1, "S_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, hide_ull(1LL<<30), "S_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu31ll, S_BFu17i_BFu31ll)
//============================================================================


struct  S_BFu17i_BFu32i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 S_BFu17i_BFu32i) C1{ Fs Fi:17 Fi:32}



static void Test_S_BFu17i_BFu32i()
{
  {
    init_simple_test("S_BFu17i_BFu32i");
    static STRUCT_IF_C S_BFu17i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "S_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "S_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu32i, S_BFu17i_BFu32i)
//============================================================================


struct  S_BFu17i_BFu32ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 S_BFu17i_BFu32ll) C1{ Fs Fi:17 FL:32}



static void Test_S_BFu17i_BFu32ll()
{
  {
    init_simple_test("S_BFu17i_BFu32ll");
    static STRUCT_IF_C S_BFu17i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, 1, "S_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, hide_ull(1LL<<31), "S_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu32ll, S_BFu17i_BFu32ll)
//============================================================================


struct  S_BFu17i_BFu33  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 S_BFu17i_BFu33) C1{ Fs Fi:17 FL:33}



static void Test_S_BFu17i_BFu33()
{
  {
    init_simple_test("S_BFu17i_BFu33");
    static STRUCT_IF_C S_BFu17i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, 1, "S_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, hide_ull(1LL<<32), "S_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu33, S_BFu17i_BFu33)
//============================================================================


struct  S_BFu17i_BFu7c  {
  short v1;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 S_BFu17i_BFu7c) C1{ Fs Fi:17 Fc:7}



static void Test_S_BFu17i_BFu7c()
{
  {
    init_simple_test("S_BFu17i_BFu7c");
    static STRUCT_IF_C S_BFu17i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "S_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "S_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu7c, S_BFu17i_BFu7c)
//============================================================================


struct  S_BFu17i_BFu7i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 S_BFu17i_BFu7i) C1{ Fs Fi:17 Fi:7}



static void Test_S_BFu17i_BFu7i()
{
  {
    init_simple_test("S_BFu17i_BFu7i");
    static STRUCT_IF_C S_BFu17i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "S_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "S_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu7i, S_BFu17i_BFu7i)
//============================================================================


struct  S_BFu17i_BFu7ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 S_BFu17i_BFu7ll) C1{ Fs Fi:17 FL:7}



static void Test_S_BFu17i_BFu7ll()
{
  {
    init_simple_test("S_BFu17i_BFu7ll");
    static STRUCT_IF_C S_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "S_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "S_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu7ll, S_BFu17i_BFu7ll)
//============================================================================


struct  S_BFu17i_BFu7s  {
  short v1;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 S_BFu17i_BFu7s) C1{ Fs Fi:17 Fs:7}



static void Test_S_BFu17i_BFu7s()
{
  {
    init_simple_test("S_BFu17i_BFu7s");
    static STRUCT_IF_C S_BFu17i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "S_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "S_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu7s, S_BFu17i_BFu7s)
//============================================================================


struct  S_BFu17i_BFu8c  {
  short v1;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 S_BFu17i_BFu8c) C1{ Fs Fi:17 Fc:8}



static void Test_S_BFu17i_BFu8c()
{
  {
    init_simple_test("S_BFu17i_BFu8c");
    static STRUCT_IF_C S_BFu17i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, 1, "S_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, hide_ull(1LL<<7), "S_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu8c, S_BFu17i_BFu8c)
//============================================================================


struct  S_BFu17i_BFu8i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 S_BFu17i_BFu8i) C1{ Fs Fi:17 Fi:8}



static void Test_S_BFu17i_BFu8i()
{
  {
    init_simple_test("S_BFu17i_BFu8i");
    static STRUCT_IF_C S_BFu17i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "S_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "S_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu8i, S_BFu17i_BFu8i)
//============================================================================


struct  S_BFu17i_BFu8ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 S_BFu17i_BFu8ll) C1{ Fs Fi:17 FL:8}



static void Test_S_BFu17i_BFu8ll()
{
  {
    init_simple_test("S_BFu17i_BFu8ll");
    static STRUCT_IF_C S_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "S_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "S_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu8ll, S_BFu17i_BFu8ll)
//============================================================================


struct  S_BFu17i_BFu8s  {
  short v1;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 S_BFu17i_BFu8s) C1{ Fs Fi:17 Fs:8}



static void Test_S_BFu17i_BFu8s()
{
  {
    init_simple_test("S_BFu17i_BFu8s");
    static STRUCT_IF_C S_BFu17i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "S_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "S_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu8s, S_BFu17i_BFu8s)
//============================================================================


struct  S_BFu17i_BFu9i  {
  short v1;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 S_BFu17i_BFu9i) C1{ Fs Fi:17 Fi:9}



static void Test_S_BFu17i_BFu9i()
{
  {
    init_simple_test("S_BFu17i_BFu9i");
    static STRUCT_IF_C S_BFu17i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "S_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "S_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu9i, S_BFu17i_BFu9i)
//============================================================================


struct  S_BFu17i_BFu9ll  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 S_BFu17i_BFu9ll) C1{ Fs Fi:17 FL:9}



static void Test_S_BFu17i_BFu9ll()
{
  {
    init_simple_test("S_BFu17i_BFu9ll");
    static STRUCT_IF_C S_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "S_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "S_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu9ll, S_BFu17i_BFu9ll)
//============================================================================


struct  S_BFu17i_BFu9s  {
  short v1;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 S_BFu17i_BFu9s) C1{ Fs Fi:17 Fs:9}



static void Test_S_BFu17i_BFu9s()
{
  {
    init_simple_test("S_BFu17i_BFu9s");
    static STRUCT_IF_C S_BFu17i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "S_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "S_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_BFu9s, S_BFu17i_BFu9s)
//============================================================================


struct  S_BFu17i_C  {
  short v1;
  unsigned int v2:17;
  char v3;
};
//SIG(1 S_BFu17i_C) C1{ Fs Fi:17 Fc}



static void Test_S_BFu17i_C()
{
  {
    init_simple_test("S_BFu17i_C");
    static STRUCT_IF_C S_BFu17i_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_C)");
    check_field_offset(lv, v1, 0, "S_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_C");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_C");
    check_field_offset(lv, v3, 7, "S_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_C, S_BFu17i_C)
//============================================================================


struct  S_BFu17i_D  {
  short v1;
  unsigned int v2:17;
  double v3;
};
//SIG(1 S_BFu17i_D) C1{ Fs Fi:17 FL}



static void Test_S_BFu17i_D()
{
  {
    init_simple_test("S_BFu17i_D");
    static STRUCT_IF_C S_BFu17i_D lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_D)");
    check_field_offset(lv, v1, 0, "S_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_D");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_D");
    check_field_offset(lv, v3, 8, "S_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_D, S_BFu17i_D)
//============================================================================


struct  S_BFu17i_F  {
  short v1;
  unsigned int v2:17;
  float v3;
};
//SIG(1 S_BFu17i_F) C1{ Fs Fi:17 Fi}



static void Test_S_BFu17i_F()
{
  {
    init_simple_test("S_BFu17i_F");
    static STRUCT_IF_C S_BFu17i_F lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_F)");
    check_field_offset(lv, v1, 0, "S_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_F");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_F");
    check_field_offset(lv, v3, 8, "S_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_F, S_BFu17i_F)
//============================================================================


struct  S_BFu17i_I  {
  short v1;
  unsigned int v2:17;
  int v3;
};
//SIG(1 S_BFu17i_I) C1{ Fs Fi:17 Fi}



static void Test_S_BFu17i_I()
{
  {
    init_simple_test("S_BFu17i_I");
    static STRUCT_IF_C S_BFu17i_I lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_I)");
    check_field_offset(lv, v1, 0, "S_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_I");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_I");
    check_field_offset(lv, v3, 8, "S_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_I, S_BFu17i_I)
//============================================================================


struct  S_BFu17i_Ip  {
  short v1;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 S_BFu17i_Ip) C1{ Fs Fi:17 Fp}



static void Test_S_BFu17i_Ip()
{
  {
    init_simple_test("S_BFu17i_Ip");
    static STRUCT_IF_C S_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_Ip");
    check_field_offset(lv, v3, 8, "S_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_Ip, S_BFu17i_Ip)
//============================================================================


struct  S_BFu17i_L  {
  short v1;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 S_BFu17i_L) C1{ Fs Fi:17 FL}



static void Test_S_BFu17i_L()
{
  {
    init_simple_test("S_BFu17i_L");
    static STRUCT_IF_C S_BFu17i_L lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_L)");
    check_field_offset(lv, v1, 0, "S_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_L");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_L");
    check_field_offset(lv, v3, 8, "S_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_L, S_BFu17i_L)
//============================================================================


struct  S_BFu17i_S  {
  short v1;
  unsigned int v2:17;
  short v3;
};
//SIG(1 S_BFu17i_S) C1{ Fs Fi:17 Fs}



static void Test_S_BFu17i_S()
{
  {
    init_simple_test("S_BFu17i_S");
    static STRUCT_IF_C S_BFu17i_S lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_S)");
    check_field_offset(lv, v1, 0, "S_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_S");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_S");
    check_field_offset(lv, v3, 8, "S_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_S, S_BFu17i_S)
//============================================================================


struct  S_BFu17i_Uc  {
  short v1;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 S_BFu17i_Uc) C1{ Fs Fi:17 Fc}



static void Test_S_BFu17i_Uc()
{
  {
    init_simple_test("S_BFu17i_Uc");
    static STRUCT_IF_C S_BFu17i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_Uc");
    check_field_offset(lv, v3, 7, "S_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_Uc, S_BFu17i_Uc)
//============================================================================


struct  S_BFu17i_Ui  {
  short v1;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 S_BFu17i_Ui) C1{ Fs Fi:17 Fi}



static void Test_S_BFu17i_Ui()
{
  {
    init_simple_test("S_BFu17i_Ui");
    static STRUCT_IF_C S_BFu17i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_Ui");
    check_field_offset(lv, v3, 8, "S_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_Ui, S_BFu17i_Ui)
//============================================================================


struct  S_BFu17i_Ul  {
  short v1;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 S_BFu17i_Ul) C1{ Fs Fi:17 FL}



static void Test_S_BFu17i_Ul()
{
  {
    init_simple_test("S_BFu17i_Ul");
    static STRUCT_IF_C S_BFu17i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_Ul");
    check_field_offset(lv, v3, 8, "S_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_Ul, S_BFu17i_Ul)
//============================================================================


struct  S_BFu17i_Us  {
  short v1;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 S_BFu17i_Us) C1{ Fs Fi:17 Fs}



static void Test_S_BFu17i_Us()
{
  {
    init_simple_test("S_BFu17i_Us");
    static STRUCT_IF_C S_BFu17i_Us lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu17i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_Us");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_Us");
    check_field_offset(lv, v3, 8, "S_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_Us, S_BFu17i_Us)
//============================================================================


struct  S_BFu17i_Vp  {
  short v1;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 S_BFu17i_Vp) C1{ Fs Fi:17 Fp}



static void Test_S_BFu17i_Vp()
{
  {
    init_simple_test("S_BFu17i_Vp");
    static STRUCT_IF_C S_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_Vp");
    check_field_offset(lv, v3, 8, "S_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17i_Vp, S_BFu17i_Vp)
//============================================================================


struct  S_BFu17ll  {
  short v1;
  __tsu64 v2:17;
};
//SIG(1 S_BFu17ll) C1{ Fs FL:17}



static void Test_S_BFu17ll()
{
  {
    init_simple_test("S_BFu17ll");
    static STRUCT_IF_C S_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll, S_BFu17ll)
//============================================================================


struct  S_BFu17ll_BFu15i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 S_BFu17ll_BFu15i) C1{ Fs FL:17 Fi:15}



static void Test_S_BFu17ll_BFu15i()
{
  {
    init_simple_test("S_BFu17ll_BFu15i");
    static STRUCT_IF_C S_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "S_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "S_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu15i, S_BFu17ll_BFu15i)
//============================================================================


struct  S_BFu17ll_BFu15ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 S_BFu17ll_BFu15ll) C1{ Fs FL:17 FL:15}



static void Test_S_BFu17ll_BFu15ll()
{
  {
    init_simple_test("S_BFu17ll_BFu15ll");
    static STRUCT_IF_C S_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "S_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "S_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu15ll, S_BFu17ll_BFu15ll)
//============================================================================


struct  S_BFu17ll_BFu15s  {
  short v1;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 S_BFu17ll_BFu15s) C1{ Fs FL:17 Fs:15}



static void Test_S_BFu17ll_BFu15s()
{
  {
    init_simple_test("S_BFu17ll_BFu15s");
    static STRUCT_IF_C S_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "S_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "S_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu15s, S_BFu17ll_BFu15s)
//============================================================================


struct  S_BFu17ll_BFu16i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 S_BFu17ll_BFu16i) C1{ Fs FL:17 Fi:16}



static void Test_S_BFu17ll_BFu16i()
{
  {
    init_simple_test("S_BFu17ll_BFu16i");
    static STRUCT_IF_C S_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "S_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "S_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu16i, S_BFu17ll_BFu16i)
//============================================================================


struct  S_BFu17ll_BFu16ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 S_BFu17ll_BFu16ll) C1{ Fs FL:17 FL:16}



static void Test_S_BFu17ll_BFu16ll()
{
  {
    init_simple_test("S_BFu17ll_BFu16ll");
    static STRUCT_IF_C S_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "S_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "S_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu16ll, S_BFu17ll_BFu16ll)
//============================================================================


struct  S_BFu17ll_BFu16s  {
  short v1;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 S_BFu17ll_BFu16s) C1{ Fs FL:17 Fs:16}



static void Test_S_BFu17ll_BFu16s()
{
  {
    init_simple_test("S_BFu17ll_BFu16s");
    static STRUCT_IF_C S_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "S_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "S_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu16s, S_BFu17ll_BFu16s)
//============================================================================


struct  S_BFu17ll_BFu17i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 S_BFu17ll_BFu17i) C1{ Fs FL:17 Fi:17}



static void Test_S_BFu17ll_BFu17i()
{
  {
    init_simple_test("S_BFu17ll_BFu17i");
    static STRUCT_IF_C S_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "S_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu17i, S_BFu17ll_BFu17i)
//============================================================================


struct  S_BFu17ll_BFu17ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 S_BFu17ll_BFu17ll) C1{ Fs FL:17 FL:17}



static void Test_S_BFu17ll_BFu17ll()
{
  {
    init_simple_test("S_BFu17ll_BFu17ll");
    static STRUCT_IF_C S_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "S_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu17ll, S_BFu17ll_BFu17ll)
//============================================================================


struct  S_BFu17ll_BFu1c  {
  short v1;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 S_BFu17ll_BFu1c) C1{ Fs FL:17 Fc:1}



static void Test_S_BFu17ll_BFu1c()
{
  {
    init_simple_test("S_BFu17ll_BFu1c");
    static STRUCT_IF_C S_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "S_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu1c, S_BFu17ll_BFu1c)
//============================================================================


struct  S_BFu17ll_BFu1i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 S_BFu17ll_BFu1i) C1{ Fs FL:17 Fi:1}



static void Test_S_BFu17ll_BFu1i()
{
  {
    init_simple_test("S_BFu17ll_BFu1i");
    static STRUCT_IF_C S_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "S_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu1i, S_BFu17ll_BFu1i)
//============================================================================


struct  S_BFu17ll_BFu1ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 S_BFu17ll_BFu1ll) C1{ Fs FL:17 FL:1}



static void Test_S_BFu17ll_BFu1ll()
{
  {
    init_simple_test("S_BFu17ll_BFu1ll");
    static STRUCT_IF_C S_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "S_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu1ll, S_BFu17ll_BFu1ll)
//============================================================================


struct  S_BFu17ll_BFu1s  {
  short v1;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 S_BFu17ll_BFu1s) C1{ Fs FL:17 Fs:1}



static void Test_S_BFu17ll_BFu1s()
{
  {
    init_simple_test("S_BFu17ll_BFu1s");
    static STRUCT_IF_C S_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "S_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu1s, S_BFu17ll_BFu1s)
//============================================================================


struct  S_BFu17ll_BFu31i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 S_BFu17ll_BFu31i) C1{ Fs FL:17 Fi:31}



static void Test_S_BFu17ll_BFu31i()
{
  {
    init_simple_test("S_BFu17ll_BFu31i");
    static STRUCT_IF_C S_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "S_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "S_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu31i, S_BFu17ll_BFu31i)
//============================================================================


struct  S_BFu17ll_BFu31ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 S_BFu17ll_BFu31ll) C1{ Fs FL:17 FL:31}



static void Test_S_BFu17ll_BFu31ll()
{
  {
    init_simple_test("S_BFu17ll_BFu31ll");
    static STRUCT_IF_C S_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "S_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "S_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu31ll, S_BFu17ll_BFu31ll)
//============================================================================


struct  S_BFu17ll_BFu32i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 S_BFu17ll_BFu32i) C1{ Fs FL:17 Fi:32}



static void Test_S_BFu17ll_BFu32i()
{
  {
    init_simple_test("S_BFu17ll_BFu32i");
    static STRUCT_IF_C S_BFu17ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "S_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "S_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu32i, S_BFu17ll_BFu32i)
//============================================================================


struct  S_BFu17ll_BFu32ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 S_BFu17ll_BFu32ll) C1{ Fs FL:17 FL:32}



static void Test_S_BFu17ll_BFu32ll()
{
  {
    init_simple_test("S_BFu17ll_BFu32ll");
    static STRUCT_IF_C S_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "S_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "S_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu32ll, S_BFu17ll_BFu32ll)
//============================================================================


struct  S_BFu17ll_BFu33  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 S_BFu17ll_BFu33) C1{ Fs FL:17 FL:33}



static void Test_S_BFu17ll_BFu33()
{
  {
    init_simple_test("S_BFu17ll_BFu33");
    static STRUCT_IF_C S_BFu17ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "S_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "S_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu33, S_BFu17ll_BFu33)
//============================================================================


struct  S_BFu17ll_BFu7c  {
  short v1;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 S_BFu17ll_BFu7c) C1{ Fs FL:17 Fc:7}



static void Test_S_BFu17ll_BFu7c()
{
  {
    init_simple_test("S_BFu17ll_BFu7c");
    static STRUCT_IF_C S_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "S_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "S_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu7c, S_BFu17ll_BFu7c)
//============================================================================


struct  S_BFu17ll_BFu7i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 S_BFu17ll_BFu7i) C1{ Fs FL:17 Fi:7}



static void Test_S_BFu17ll_BFu7i()
{
  {
    init_simple_test("S_BFu17ll_BFu7i");
    static STRUCT_IF_C S_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "S_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "S_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu7i, S_BFu17ll_BFu7i)
//============================================================================


struct  S_BFu17ll_BFu7ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 S_BFu17ll_BFu7ll) C1{ Fs FL:17 FL:7}



static void Test_S_BFu17ll_BFu7ll()
{
  {
    init_simple_test("S_BFu17ll_BFu7ll");
    static STRUCT_IF_C S_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "S_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "S_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu7ll, S_BFu17ll_BFu7ll)
//============================================================================


struct  S_BFu17ll_BFu7s  {
  short v1;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 S_BFu17ll_BFu7s) C1{ Fs FL:17 Fs:7}



static void Test_S_BFu17ll_BFu7s()
{
  {
    init_simple_test("S_BFu17ll_BFu7s");
    static STRUCT_IF_C S_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "S_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "S_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu7s, S_BFu17ll_BFu7s)
//============================================================================


struct  S_BFu17ll_BFu8c  {
  short v1;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 S_BFu17ll_BFu8c) C1{ Fs FL:17 Fc:8}



static void Test_S_BFu17ll_BFu8c()
{
  {
    init_simple_test("S_BFu17ll_BFu8c");
    static STRUCT_IF_C S_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "S_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "S_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu8c, S_BFu17ll_BFu8c)
//============================================================================


struct  S_BFu17ll_BFu8i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 S_BFu17ll_BFu8i) C1{ Fs FL:17 Fi:8}



static void Test_S_BFu17ll_BFu8i()
{
  {
    init_simple_test("S_BFu17ll_BFu8i");
    static STRUCT_IF_C S_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "S_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "S_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu8i, S_BFu17ll_BFu8i)
//============================================================================


struct  S_BFu17ll_BFu8ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 S_BFu17ll_BFu8ll) C1{ Fs FL:17 FL:8}



static void Test_S_BFu17ll_BFu8ll()
{
  {
    init_simple_test("S_BFu17ll_BFu8ll");
    static STRUCT_IF_C S_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "S_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "S_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu8ll, S_BFu17ll_BFu8ll)
//============================================================================


struct  S_BFu17ll_BFu8s  {
  short v1;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 S_BFu17ll_BFu8s) C1{ Fs FL:17 Fs:8}



static void Test_S_BFu17ll_BFu8s()
{
  {
    init_simple_test("S_BFu17ll_BFu8s");
    static STRUCT_IF_C S_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "S_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "S_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu8s, S_BFu17ll_BFu8s)
//============================================================================


struct  S_BFu17ll_BFu9i  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 S_BFu17ll_BFu9i) C1{ Fs FL:17 Fi:9}



static void Test_S_BFu17ll_BFu9i()
{
  {
    init_simple_test("S_BFu17ll_BFu9i");
    static STRUCT_IF_C S_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "S_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "S_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu9i, S_BFu17ll_BFu9i)
//============================================================================


struct  S_BFu17ll_BFu9ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 S_BFu17ll_BFu9ll) C1{ Fs FL:17 FL:9}



static void Test_S_BFu17ll_BFu9ll()
{
  {
    init_simple_test("S_BFu17ll_BFu9ll");
    static STRUCT_IF_C S_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "S_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "S_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu9ll, S_BFu17ll_BFu9ll)
//============================================================================


struct  S_BFu17ll_BFu9s  {
  short v1;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 S_BFu17ll_BFu9s) C1{ Fs FL:17 Fs:9}



static void Test_S_BFu17ll_BFu9s()
{
  {
    init_simple_test("S_BFu17ll_BFu9s");
    static STRUCT_IF_C S_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "S_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "S_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_BFu9s, S_BFu17ll_BFu9s)
//============================================================================


struct  S_BFu17ll_C  {
  short v1;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 S_BFu17ll_C) C1{ Fs FL:17 Fc}



static void Test_S_BFu17ll_C()
{
  {
    init_simple_test("S_BFu17ll_C");
    static STRUCT_IF_C S_BFu17ll_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_C");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_C");
    check_field_offset(lv, v3, 5, "S_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_C, S_BFu17ll_C)
//============================================================================


struct  S_BFu17ll_D  {
  short v1;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 S_BFu17ll_D) C1{ Fs FL:17 FL}



static void Test_S_BFu17ll_D()
{
  {
    init_simple_test("S_BFu17ll_D");
    static STRUCT_IF_C S_BFu17ll_D lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_D");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_D");
    check_field_offset(lv, v3, 8, "S_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_D, S_BFu17ll_D)
//============================================================================


struct  S_BFu17ll_F  {
  short v1;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 S_BFu17ll_F) C1{ Fs FL:17 Fi}



static void Test_S_BFu17ll_F()
{
  {
    init_simple_test("S_BFu17ll_F");
    static STRUCT_IF_C S_BFu17ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_F");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_F");
    check_field_offset(lv, v3, 8, "S_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_F, S_BFu17ll_F)
//============================================================================


struct  S_BFu17ll_I  {
  short v1;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 S_BFu17ll_I) C1{ Fs FL:17 Fi}



static void Test_S_BFu17ll_I()
{
  {
    init_simple_test("S_BFu17ll_I");
    static STRUCT_IF_C S_BFu17ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_I");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_I");
    check_field_offset(lv, v3, 8, "S_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_I, S_BFu17ll_I)
//============================================================================


struct  S_BFu17ll_Ip  {
  short v1;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 S_BFu17ll_Ip) C1{ Fs FL:17 Fp}



static void Test_S_BFu17ll_Ip()
{
  {
    init_simple_test("S_BFu17ll_Ip");
    static STRUCT_IF_C S_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_Ip");
    check_field_offset(lv, v3, 8, "S_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_Ip, S_BFu17ll_Ip)
//============================================================================


struct  S_BFu17ll_L  {
  short v1;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 S_BFu17ll_L) C1{ Fs FL:17 FL}



static void Test_S_BFu17ll_L()
{
  {
    init_simple_test("S_BFu17ll_L");
    static STRUCT_IF_C S_BFu17ll_L lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_L");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_L");
    check_field_offset(lv, v3, 8, "S_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_L, S_BFu17ll_L)
//============================================================================


struct  S_BFu17ll_S  {
  short v1;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 S_BFu17ll_S) C1{ Fs FL:17 Fs}



static void Test_S_BFu17ll_S()
{
  {
    init_simple_test("S_BFu17ll_S");
    static STRUCT_IF_C S_BFu17ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_S");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_S");
    check_field_offset(lv, v3, 6, "S_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_S, S_BFu17ll_S)
//============================================================================


struct  S_BFu17ll_Uc  {
  short v1;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 S_BFu17ll_Uc) C1{ Fs FL:17 Fc}



static void Test_S_BFu17ll_Uc()
{
  {
    init_simple_test("S_BFu17ll_Uc");
    static STRUCT_IF_C S_BFu17ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_Uc");
    check_field_offset(lv, v3, 5, "S_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_Uc, S_BFu17ll_Uc)
//============================================================================


struct  S_BFu17ll_Ui  {
  short v1;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 S_BFu17ll_Ui) C1{ Fs FL:17 Fi}



static void Test_S_BFu17ll_Ui()
{
  {
    init_simple_test("S_BFu17ll_Ui");
    static STRUCT_IF_C S_BFu17ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_Ui");
    check_field_offset(lv, v3, 8, "S_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_Ui, S_BFu17ll_Ui)
//============================================================================


struct  S_BFu17ll_Ul  {
  short v1;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 S_BFu17ll_Ul) C1{ Fs FL:17 FL}



static void Test_S_BFu17ll_Ul()
{
  {
    init_simple_test("S_BFu17ll_Ul");
    static STRUCT_IF_C S_BFu17ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_Ul");
    check_field_offset(lv, v3, 8, "S_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_Ul, S_BFu17ll_Ul)
//============================================================================


struct  S_BFu17ll_Us  {
  short v1;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 S_BFu17ll_Us) C1{ Fs FL:17 Fs}



static void Test_S_BFu17ll_Us()
{
  {
    init_simple_test("S_BFu17ll_Us");
    static STRUCT_IF_C S_BFu17ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_Us");
    check_field_offset(lv, v3, 6, "S_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_Us, S_BFu17ll_Us)
//============================================================================


struct  S_BFu17ll_Vp  {
  short v1;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 S_BFu17ll_Vp) C1{ Fs FL:17 Fp}



static void Test_S_BFu17ll_Vp()
{
  {
    init_simple_test("S_BFu17ll_Vp");
    static STRUCT_IF_C S_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_Vp");
    check_field_offset(lv, v3, 8, "S_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu17ll_Vp, S_BFu17ll_Vp)
//============================================================================


struct  S_BFu1c  {
  short v1;
  unsigned char v2:1;
};
//SIG(1 S_BFu1c) C1{ Fs Fc:1}



static void Test_S_BFu1c()
{
  {
    init_simple_test("S_BFu1c");
    static STRUCT_IF_C S_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c, S_BFu1c)
//============================================================================


struct  S_BFu1c_BFu15i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 S_BFu1c_BFu15i) C1{ Fs Fc:1 Fi:15}



static void Test_S_BFu1c_BFu15i()
{
  {
    init_simple_test("S_BFu1c_BFu15i");
    static STRUCT_IF_C S_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu15i, S_BFu1c_BFu15i)
//============================================================================


struct  S_BFu1c_BFu15ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 S_BFu1c_BFu15ll) C1{ Fs Fc:1 FL:15}



static void Test_S_BFu1c_BFu15ll()
{
  {
    init_simple_test("S_BFu1c_BFu15ll");
    static STRUCT_IF_C S_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu15ll, S_BFu1c_BFu15ll)
//============================================================================


struct  S_BFu1c_BFu15s  {
  short v1;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 S_BFu1c_BFu15s) C1{ Fs Fc:1 Fs:15}



static void Test_S_BFu1c_BFu15s()
{
  {
    init_simple_test("S_BFu1c_BFu15s");
    static STRUCT_IF_C S_BFu1c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu15s, S_BFu1c_BFu15s)
//============================================================================


struct  S_BFu1c_BFu16i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 S_BFu1c_BFu16i) C1{ Fs Fc:1 Fi:16}



static void Test_S_BFu1c_BFu16i()
{
  {
    init_simple_test("S_BFu1c_BFu16i");
    static STRUCT_IF_C S_BFu1c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu16i, S_BFu1c_BFu16i)
//============================================================================


struct  S_BFu1c_BFu16ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 S_BFu1c_BFu16ll) C1{ Fs Fc:1 FL:16}



static void Test_S_BFu1c_BFu16ll()
{
  {
    init_simple_test("S_BFu1c_BFu16ll");
    static STRUCT_IF_C S_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "S_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "S_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu16ll, S_BFu1c_BFu16ll)
//============================================================================


struct  S_BFu1c_BFu16s  {
  short v1;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 S_BFu1c_BFu16s) C1{ Fs Fc:1 Fs:16}



static void Test_S_BFu1c_BFu16s()
{
  {
    init_simple_test("S_BFu1c_BFu16s");
    static STRUCT_IF_C S_BFu1c_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu1c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu16s, S_BFu1c_BFu16s)
//============================================================================


struct  S_BFu1c_BFu17i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 S_BFu1c_BFu17i) C1{ Fs Fc:1 Fi:17}



static void Test_S_BFu1c_BFu17i()
{
  {
    init_simple_test("S_BFu1c_BFu17i");
    static STRUCT_IF_C S_BFu1c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu17i, S_BFu1c_BFu17i)
//============================================================================


struct  S_BFu1c_BFu17ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 S_BFu1c_BFu17ll) C1{ Fs Fc:1 FL:17}



static void Test_S_BFu1c_BFu17ll()
{
  {
    init_simple_test("S_BFu1c_BFu17ll");
    static STRUCT_IF_C S_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "S_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "S_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu17ll, S_BFu1c_BFu17ll)
//============================================================================


struct  S_BFu1c_BFu1c  {
  short v1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 S_BFu1c_BFu1c) C1{ Fs Fc:1 Fc:1}



static void Test_S_BFu1c_BFu1c()
{
  {
    init_simple_test("S_BFu1c_BFu1c");
    static STRUCT_IF_C S_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu1c, S_BFu1c_BFu1c)
//============================================================================


struct  S_BFu1c_BFu1i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 S_BFu1c_BFu1i) C1{ Fs Fc:1 Fi:1}



static void Test_S_BFu1c_BFu1i()
{
  {
    init_simple_test("S_BFu1c_BFu1i");
    static STRUCT_IF_C S_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu1i, S_BFu1c_BFu1i)
//============================================================================


struct  S_BFu1c_BFu1ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 S_BFu1c_BFu1ll) C1{ Fs Fc:1 FL:1}



static void Test_S_BFu1c_BFu1ll()
{
  {
    init_simple_test("S_BFu1c_BFu1ll");
    static STRUCT_IF_C S_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu1ll, S_BFu1c_BFu1ll)
//============================================================================


struct  S_BFu1c_BFu1s  {
  short v1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 S_BFu1c_BFu1s) C1{ Fs Fc:1 Fs:1}



static void Test_S_BFu1c_BFu1s()
{
  {
    init_simple_test("S_BFu1c_BFu1s");
    static STRUCT_IF_C S_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu1s, S_BFu1c_BFu1s)
//============================================================================


struct  S_BFu1c_BFu31i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 S_BFu1c_BFu31i) C1{ Fs Fc:1 Fi:31}



static void Test_S_BFu1c_BFu31i()
{
  {
    init_simple_test("S_BFu1c_BFu31i");
    static STRUCT_IF_C S_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu31i, S_BFu1c_BFu31i)
//============================================================================


struct  S_BFu1c_BFu31ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 S_BFu1c_BFu31ll) C1{ Fs Fc:1 FL:31}



static void Test_S_BFu1c_BFu31ll()
{
  {
    init_simple_test("S_BFu1c_BFu31ll");
    static STRUCT_IF_C S_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "S_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "S_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu31ll, S_BFu1c_BFu31ll)
//============================================================================


struct  S_BFu1c_BFu32i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 S_BFu1c_BFu32i) C1{ Fs Fc:1 Fi:32}



static void Test_S_BFu1c_BFu32i()
{
  {
    init_simple_test("S_BFu1c_BFu32i");
    static STRUCT_IF_C S_BFu1c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu32i, S_BFu1c_BFu32i)
//============================================================================


struct  S_BFu1c_BFu32ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 S_BFu1c_BFu32ll) C1{ Fs Fc:1 FL:32}



static void Test_S_BFu1c_BFu32ll()
{
  {
    init_simple_test("S_BFu1c_BFu32ll");
    static STRUCT_IF_C S_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "S_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "S_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu32ll, S_BFu1c_BFu32ll)
//============================================================================


struct  S_BFu1c_BFu33  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 S_BFu1c_BFu33) C1{ Fs Fc:1 FL:33}



static void Test_S_BFu1c_BFu33()
{
  {
    init_simple_test("S_BFu1c_BFu33");
    static STRUCT_IF_C S_BFu1c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "S_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "S_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu33, S_BFu1c_BFu33)
//============================================================================


struct  S_BFu1c_BFu7c  {
  short v1;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 S_BFu1c_BFu7c) C1{ Fs Fc:1 Fc:7}



static void Test_S_BFu1c_BFu7c()
{
  {
    init_simple_test("S_BFu1c_BFu7c");
    static STRUCT_IF_C S_BFu1c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu7c, S_BFu1c_BFu7c)
//============================================================================


struct  S_BFu1c_BFu7i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 S_BFu1c_BFu7i) C1{ Fs Fc:1 Fi:7}



static void Test_S_BFu1c_BFu7i()
{
  {
    init_simple_test("S_BFu1c_BFu7i");
    static STRUCT_IF_C S_BFu1c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu7i, S_BFu1c_BFu7i)
//============================================================================


struct  S_BFu1c_BFu7ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 S_BFu1c_BFu7ll) C1{ Fs Fc:1 FL:7}



static void Test_S_BFu1c_BFu7ll()
{
  {
    init_simple_test("S_BFu1c_BFu7ll");
    static STRUCT_IF_C S_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu7ll, S_BFu1c_BFu7ll)
//============================================================================


struct  S_BFu1c_BFu7s  {
  short v1;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 S_BFu1c_BFu7s) C1{ Fs Fc:1 Fs:7}



static void Test_S_BFu1c_BFu7s()
{
  {
    init_simple_test("S_BFu1c_BFu7s");
    static STRUCT_IF_C S_BFu1c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu7s, S_BFu1c_BFu7s)
//============================================================================


struct  S_BFu1c_BFu8c  {
  short v1;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 S_BFu1c_BFu8c) C1{ Fs Fc:1 Fc:8}



static void Test_S_BFu1c_BFu8c()
{
  {
    init_simple_test("S_BFu1c_BFu8c");
    static STRUCT_IF_C S_BFu1c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu8c, S_BFu1c_BFu8c)
//============================================================================


struct  S_BFu1c_BFu8i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 S_BFu1c_BFu8i) C1{ Fs Fc:1 Fi:8}



static void Test_S_BFu1c_BFu8i()
{
  {
    init_simple_test("S_BFu1c_BFu8i");
    static STRUCT_IF_C S_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu8i, S_BFu1c_BFu8i)
//============================================================================


struct  S_BFu1c_BFu8ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 S_BFu1c_BFu8ll) C1{ Fs Fc:1 FL:8}



static void Test_S_BFu1c_BFu8ll()
{
  {
    init_simple_test("S_BFu1c_BFu8ll");
    static STRUCT_IF_C S_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu8ll, S_BFu1c_BFu8ll)
//============================================================================


struct  S_BFu1c_BFu8s  {
  short v1;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 S_BFu1c_BFu8s) C1{ Fs Fc:1 Fs:8}



static void Test_S_BFu1c_BFu8s()
{
  {
    init_simple_test("S_BFu1c_BFu8s");
    static STRUCT_IF_C S_BFu1c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu8s, S_BFu1c_BFu8s)
//============================================================================


struct  S_BFu1c_BFu9i  {
  short v1;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 S_BFu1c_BFu9i) C1{ Fs Fc:1 Fi:9}



static void Test_S_BFu1c_BFu9i()
{
  {
    init_simple_test("S_BFu1c_BFu9i");
    static STRUCT_IF_C S_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu9i, S_BFu1c_BFu9i)
//============================================================================


struct  S_BFu1c_BFu9ll  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 S_BFu1c_BFu9ll) C1{ Fs Fc:1 FL:9}



static void Test_S_BFu1c_BFu9ll()
{
  {
    init_simple_test("S_BFu1c_BFu9ll");
    static STRUCT_IF_C S_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu9ll, S_BFu1c_BFu9ll)
//============================================================================


struct  S_BFu1c_BFu9s  {
  short v1;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 S_BFu1c_BFu9s) C1{ Fs Fc:1 Fs:9}



static void Test_S_BFu1c_BFu9s()
{
  {
    init_simple_test("S_BFu1c_BFu9s");
    static STRUCT_IF_C S_BFu1c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_BFu9s, S_BFu1c_BFu9s)
//============================================================================


struct  S_BFu1c_C  {
  short v1;
  unsigned char v2:1;
  char v3;
};
//SIG(1 S_BFu1c_C) C1{ Fs Fc:1 Fc}



static void Test_S_BFu1c_C()
{
  {
    init_simple_test("S_BFu1c_C");
    static STRUCT_IF_C S_BFu1c_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_C)");
    check_field_offset(lv, v1, 0, "S_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_C");
    check_field_offset(lv, v3, 3, "S_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_C, S_BFu1c_C)
//============================================================================


struct  S_BFu1c_D  {
  short v1;
  unsigned char v2:1;
  double v3;
};
//SIG(1 S_BFu1c_D) C1{ Fs Fc:1 FL}



static void Test_S_BFu1c_D()
{
  {
    init_simple_test("S_BFu1c_D");
    static STRUCT_IF_C S_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_D)");
    check_field_offset(lv, v1, 0, "S_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_D, S_BFu1c_D)
//============================================================================


struct  S_BFu1c_F  {
  short v1;
  unsigned char v2:1;
  float v3;
};
//SIG(1 S_BFu1c_F) C1{ Fs Fc:1 Fi}



static void Test_S_BFu1c_F()
{
  {
    init_simple_test("S_BFu1c_F");
    static STRUCT_IF_C S_BFu1c_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_F)");
    check_field_offset(lv, v1, 0, "S_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_F");
    check_field_offset(lv, v3, 4, "S_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_F, S_BFu1c_F)
//============================================================================


struct  S_BFu1c_I  {
  short v1;
  unsigned char v2:1;
  int v3;
};
//SIG(1 S_BFu1c_I) C1{ Fs Fc:1 Fi}



static void Test_S_BFu1c_I()
{
  {
    init_simple_test("S_BFu1c_I");
    static STRUCT_IF_C S_BFu1c_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_I)");
    check_field_offset(lv, v1, 0, "S_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_I");
    check_field_offset(lv, v3, 4, "S_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_I, S_BFu1c_I)
//============================================================================


struct  S_BFu1c_Ip  {
  short v1;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 S_BFu1c_Ip) C1{ Fs Fc:1 Fp}



static void Test_S_BFu1c_Ip()
{
  {
    init_simple_test("S_BFu1c_Ip");
    static STRUCT_IF_C S_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_Ip, S_BFu1c_Ip)
//============================================================================


struct  S_BFu1c_L  {
  short v1;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 S_BFu1c_L) C1{ Fs Fc:1 FL}



static void Test_S_BFu1c_L()
{
  {
    init_simple_test("S_BFu1c_L");
    static STRUCT_IF_C S_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_L)");
    check_field_offset(lv, v1, 0, "S_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_L, S_BFu1c_L)
//============================================================================


struct  S_BFu1c_S  {
  short v1;
  unsigned char v2:1;
  short v3;
};
//SIG(1 S_BFu1c_S) C1{ Fs Fc:1 Fs}



static void Test_S_BFu1c_S()
{
  {
    init_simple_test("S_BFu1c_S");
    static STRUCT_IF_C S_BFu1c_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu1c_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_S)");
    check_field_offset(lv, v1, 0, "S_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_S");
    check_field_offset(lv, v3, 4, "S_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_S, S_BFu1c_S)
//============================================================================


struct  S_BFu1c_Uc  {
  short v1;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 S_BFu1c_Uc) C1{ Fs Fc:1 Fc}



static void Test_S_BFu1c_Uc()
{
  {
    init_simple_test("S_BFu1c_Uc");
    static STRUCT_IF_C S_BFu1c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_Uc");
    check_field_offset(lv, v3, 3, "S_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_Uc, S_BFu1c_Uc)
//============================================================================


struct  S_BFu1c_Ui  {
  short v1;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 S_BFu1c_Ui) C1{ Fs Fc:1 Fi}



static void Test_S_BFu1c_Ui()
{
  {
    init_simple_test("S_BFu1c_Ui");
    static STRUCT_IF_C S_BFu1c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_Ui");
    check_field_offset(lv, v3, 4, "S_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_Ui, S_BFu1c_Ui)
//============================================================================


struct  S_BFu1c_Ul  {
  short v1;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 S_BFu1c_Ul) C1{ Fs Fc:1 FL}



static void Test_S_BFu1c_Ul()
{
  {
    init_simple_test("S_BFu1c_Ul");
    static STRUCT_IF_C S_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_Ul, S_BFu1c_Ul)
//============================================================================


struct  S_BFu1c_Us  {
  short v1;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 S_BFu1c_Us) C1{ Fs Fc:1 Fs}



static void Test_S_BFu1c_Us()
{
  {
    init_simple_test("S_BFu1c_Us");
    static STRUCT_IF_C S_BFu1c_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu1c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "S_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_Us");
    check_field_offset(lv, v3, 4, "S_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_Us, S_BFu1c_Us)
//============================================================================


struct  S_BFu1c_Vp  {
  short v1;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 S_BFu1c_Vp) C1{ Fs Fc:1 Fp}



static void Test_S_BFu1c_Vp()
{
  {
    init_simple_test("S_BFu1c_Vp");
    static STRUCT_IF_C S_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1c_Vp, S_BFu1c_Vp)
//============================================================================


struct  S_BFu1i  {
  short v1;
  unsigned int v2:1;
};
//SIG(1 S_BFu1i) C1{ Fs Fi:1}



static void Test_S_BFu1i()
{
  {
    init_simple_test("S_BFu1i");
    static STRUCT_IF_C S_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i, S_BFu1i)
//============================================================================


struct  S_BFu1i_BFu15i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 S_BFu1i_BFu15i) C1{ Fs Fi:1 Fi:15}



static void Test_S_BFu1i_BFu15i()
{
  {
    init_simple_test("S_BFu1i_BFu15i");
    static STRUCT_IF_C S_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu15i, S_BFu1i_BFu15i)
//============================================================================


struct  S_BFu1i_BFu15ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 S_BFu1i_BFu15ll) C1{ Fs Fi:1 FL:15}



static void Test_S_BFu1i_BFu15ll()
{
  {
    init_simple_test("S_BFu1i_BFu15ll");
    static STRUCT_IF_C S_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu15ll, S_BFu1i_BFu15ll)
//============================================================================


struct  S_BFu1i_BFu15s  {
  short v1;
  unsigned int v2:1;
  unsigned short v3:15;
};
//SIG(1 S_BFu1i_BFu15s) C1{ Fs Fi:1 Fs:15}



static void Test_S_BFu1i_BFu15s()
{
  {
    init_simple_test("S_BFu1i_BFu15s");
    static STRUCT_IF_C S_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu15s, S_BFu1i_BFu15s)
//============================================================================


struct  S_BFu1i_BFu16i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:16;
};
//SIG(1 S_BFu1i_BFu16i) C1{ Fs Fi:1 Fi:16}



static void Test_S_BFu1i_BFu16i()
{
  {
    init_simple_test("S_BFu1i_BFu16i");
    static STRUCT_IF_C S_BFu1i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu16i, S_BFu1i_BFu16i)
//============================================================================


struct  S_BFu1i_BFu16ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:16;
};
//SIG(1 S_BFu1i_BFu16ll) C1{ Fs Fi:1 FL:16}



static void Test_S_BFu1i_BFu16ll()
{
  {
    init_simple_test("S_BFu1i_BFu16ll");
    static STRUCT_IF_C S_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "S_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "S_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu16ll, S_BFu1i_BFu16ll)
//============================================================================


struct  S_BFu1i_BFu16s  {
  short v1;
  unsigned int v2:1;
  unsigned short v3:16;
};
//SIG(1 S_BFu1i_BFu16s) C1{ Fs Fi:1 Fs:16}



static void Test_S_BFu1i_BFu16s()
{
  {
    init_simple_test("S_BFu1i_BFu16s");
    static STRUCT_IF_C S_BFu1i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu16s, S_BFu1i_BFu16s)
//============================================================================


struct  S_BFu1i_BFu17i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:17;
};
//SIG(1 S_BFu1i_BFu17i) C1{ Fs Fi:1 Fi:17}



static void Test_S_BFu1i_BFu17i()
{
  {
    init_simple_test("S_BFu1i_BFu17i");
    static STRUCT_IF_C S_BFu1i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu17i, S_BFu1i_BFu17i)
//============================================================================


struct  S_BFu1i_BFu17ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:17;
};
//SIG(1 S_BFu1i_BFu17ll) C1{ Fs Fi:1 FL:17}



static void Test_S_BFu1i_BFu17ll()
{
  {
    init_simple_test("S_BFu1i_BFu17ll");
    static STRUCT_IF_C S_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "S_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "S_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu17ll, S_BFu1i_BFu17ll)
//============================================================================


struct  S_BFu1i_BFu1c  {
  short v1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 S_BFu1i_BFu1c) C1{ Fs Fi:1 Fc:1}



static void Test_S_BFu1i_BFu1c()
{
  {
    init_simple_test("S_BFu1i_BFu1c");
    static STRUCT_IF_C S_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu1c, S_BFu1i_BFu1c)
//============================================================================


struct  S_BFu1i_BFu1i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 S_BFu1i_BFu1i) C1{ Fs Fi:1 Fi:1}



static void Test_S_BFu1i_BFu1i()
{
  {
    init_simple_test("S_BFu1i_BFu1i");
    static STRUCT_IF_C S_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu1i, S_BFu1i_BFu1i)
//============================================================================


struct  S_BFu1i_BFu1ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 S_BFu1i_BFu1ll) C1{ Fs Fi:1 FL:1}



static void Test_S_BFu1i_BFu1ll()
{
  {
    init_simple_test("S_BFu1i_BFu1ll");
    static STRUCT_IF_C S_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu1ll, S_BFu1i_BFu1ll)
//============================================================================


struct  S_BFu1i_BFu1s  {
  short v1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 S_BFu1i_BFu1s) C1{ Fs Fi:1 Fs:1}



static void Test_S_BFu1i_BFu1s()
{
  {
    init_simple_test("S_BFu1i_BFu1s");
    static STRUCT_IF_C S_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu1s, S_BFu1i_BFu1s)
//============================================================================


struct  S_BFu1i_BFu31i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:31;
};
//SIG(1 S_BFu1i_BFu31i) C1{ Fs Fi:1 Fi:31}



static void Test_S_BFu1i_BFu31i()
{
  {
    init_simple_test("S_BFu1i_BFu31i");
    static STRUCT_IF_C S_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu31i, S_BFu1i_BFu31i)
//============================================================================


struct  S_BFu1i_BFu31ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:31;
};
//SIG(1 S_BFu1i_BFu31ll) C1{ Fs Fi:1 FL:31}



static void Test_S_BFu1i_BFu31ll()
{
  {
    init_simple_test("S_BFu1i_BFu31ll");
    static STRUCT_IF_C S_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "S_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "S_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu31ll, S_BFu1i_BFu31ll)
//============================================================================


struct  S_BFu1i_BFu32i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:32;
};
//SIG(1 S_BFu1i_BFu32i) C1{ Fs Fi:1 Fi:32}



static void Test_S_BFu1i_BFu32i()
{
  {
    init_simple_test("S_BFu1i_BFu32i");
    static STRUCT_IF_C S_BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu32i, S_BFu1i_BFu32i)
//============================================================================


struct  S_BFu1i_BFu32ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:32;
};
//SIG(1 S_BFu1i_BFu32ll) C1{ Fs Fi:1 FL:32}



static void Test_S_BFu1i_BFu32ll()
{
  {
    init_simple_test("S_BFu1i_BFu32ll");
    static STRUCT_IF_C S_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "S_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "S_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu32ll, S_BFu1i_BFu32ll)
//============================================================================


struct  S_BFu1i_BFu33  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:33;
};
//SIG(1 S_BFu1i_BFu33) C1{ Fs Fi:1 FL:33}



static void Test_S_BFu1i_BFu33()
{
  {
    init_simple_test("S_BFu1i_BFu33");
    static STRUCT_IF_C S_BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "S_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "S_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu33, S_BFu1i_BFu33)
//============================================================================


struct  S_BFu1i_BFu7c  {
  short v1;
  unsigned int v2:1;
  unsigned char v3:7;
};
//SIG(1 S_BFu1i_BFu7c) C1{ Fs Fi:1 Fc:7}



static void Test_S_BFu1i_BFu7c()
{
  {
    init_simple_test("S_BFu1i_BFu7c");
    static STRUCT_IF_C S_BFu1i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu7c, S_BFu1i_BFu7c)
//============================================================================


struct  S_BFu1i_BFu7i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:7;
};
//SIG(1 S_BFu1i_BFu7i) C1{ Fs Fi:1 Fi:7}



static void Test_S_BFu1i_BFu7i()
{
  {
    init_simple_test("S_BFu1i_BFu7i");
    static STRUCT_IF_C S_BFu1i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu7i, S_BFu1i_BFu7i)
//============================================================================


struct  S_BFu1i_BFu7ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:7;
};
//SIG(1 S_BFu1i_BFu7ll) C1{ Fs Fi:1 FL:7}



static void Test_S_BFu1i_BFu7ll()
{
  {
    init_simple_test("S_BFu1i_BFu7ll");
    static STRUCT_IF_C S_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu7ll, S_BFu1i_BFu7ll)
//============================================================================


struct  S_BFu1i_BFu7s  {
  short v1;
  unsigned int v2:1;
  unsigned short v3:7;
};
//SIG(1 S_BFu1i_BFu7s) C1{ Fs Fi:1 Fs:7}



static void Test_S_BFu1i_BFu7s()
{
  {
    init_simple_test("S_BFu1i_BFu7s");
    static STRUCT_IF_C S_BFu1i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu7s, S_BFu1i_BFu7s)
//============================================================================


struct  S_BFu1i_BFu8c  {
  short v1;
  unsigned int v2:1;
  unsigned char v3:8;
};
//SIG(1 S_BFu1i_BFu8c) C1{ Fs Fi:1 Fc:8}



static void Test_S_BFu1i_BFu8c()
{
  {
    init_simple_test("S_BFu1i_BFu8c");
    static STRUCT_IF_C S_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu8c, S_BFu1i_BFu8c)
//============================================================================


struct  S_BFu1i_BFu8i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:8;
};
//SIG(1 S_BFu1i_BFu8i) C1{ Fs Fi:1 Fi:8}



static void Test_S_BFu1i_BFu8i()
{
  {
    init_simple_test("S_BFu1i_BFu8i");
    static STRUCT_IF_C S_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu8i, S_BFu1i_BFu8i)
//============================================================================


struct  S_BFu1i_BFu8ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:8;
};
//SIG(1 S_BFu1i_BFu8ll) C1{ Fs Fi:1 FL:8}



static void Test_S_BFu1i_BFu8ll()
{
  {
    init_simple_test("S_BFu1i_BFu8ll");
    static STRUCT_IF_C S_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu8ll, S_BFu1i_BFu8ll)
//============================================================================


struct  S_BFu1i_BFu8s  {
  short v1;
  unsigned int v2:1;
  unsigned short v3:8;
};
//SIG(1 S_BFu1i_BFu8s) C1{ Fs Fi:1 Fs:8}



static void Test_S_BFu1i_BFu8s()
{
  {
    init_simple_test("S_BFu1i_BFu8s");
    static STRUCT_IF_C S_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu8s, S_BFu1i_BFu8s)
//============================================================================


struct  S_BFu1i_BFu9i  {
  short v1;
  unsigned int v2:1;
  unsigned int v3:9;
};
//SIG(1 S_BFu1i_BFu9i) C1{ Fs Fi:1 Fi:9}



static void Test_S_BFu1i_BFu9i()
{
  {
    init_simple_test("S_BFu1i_BFu9i");
    static STRUCT_IF_C S_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu9i, S_BFu1i_BFu9i)
//============================================================================


struct  S_BFu1i_BFu9ll  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3:9;
};
//SIG(1 S_BFu1i_BFu9ll) C1{ Fs Fi:1 FL:9}



static void Test_S_BFu1i_BFu9ll()
{
  {
    init_simple_test("S_BFu1i_BFu9ll");
    static STRUCT_IF_C S_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu9ll, S_BFu1i_BFu9ll)
//============================================================================


struct  S_BFu1i_BFu9s  {
  short v1;
  unsigned int v2:1;
  unsigned short v3:9;
};
//SIG(1 S_BFu1i_BFu9s) C1{ Fs Fi:1 Fs:9}



static void Test_S_BFu1i_BFu9s()
{
  {
    init_simple_test("S_BFu1i_BFu9s");
    static STRUCT_IF_C S_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_BFu9s, S_BFu1i_BFu9s)
//============================================================================


struct  S_BFu1i_C  {
  short v1;
  unsigned int v2:1;
  char v3;
};
//SIG(1 S_BFu1i_C) C1{ Fs Fi:1 Fc}



static void Test_S_BFu1i_C()
{
  {
    init_simple_test("S_BFu1i_C");
    static STRUCT_IF_C S_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_C)");
    check_field_offset(lv, v1, 0, "S_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_C");
    check_field_offset(lv, v3, 3, "S_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_C, S_BFu1i_C)
//============================================================================


struct  S_BFu1i_D  {
  short v1;
  unsigned int v2:1;
  double v3;
};
//SIG(1 S_BFu1i_D) C1{ Fs Fi:1 FL}



static void Test_S_BFu1i_D()
{
  {
    init_simple_test("S_BFu1i_D");
    static STRUCT_IF_C S_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_D)");
    check_field_offset(lv, v1, 0, "S_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_D, S_BFu1i_D)
//============================================================================


struct  S_BFu1i_F  {
  short v1;
  unsigned int v2:1;
  float v3;
};
//SIG(1 S_BFu1i_F) C1{ Fs Fi:1 Fi}



static void Test_S_BFu1i_F()
{
  {
    init_simple_test("S_BFu1i_F");
    static STRUCT_IF_C S_BFu1i_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_F)");
    check_field_offset(lv, v1, 0, "S_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_F");
    check_field_offset(lv, v3, 4, "S_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_F, S_BFu1i_F)
//============================================================================


struct  S_BFu1i_I  {
  short v1;
  unsigned int v2:1;
  int v3;
};
//SIG(1 S_BFu1i_I) C1{ Fs Fi:1 Fi}



static void Test_S_BFu1i_I()
{
  {
    init_simple_test("S_BFu1i_I");
    static STRUCT_IF_C S_BFu1i_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_I)");
    check_field_offset(lv, v1, 0, "S_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_I");
    check_field_offset(lv, v3, 4, "S_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_I, S_BFu1i_I)
//============================================================================


struct  S_BFu1i_Ip  {
  short v1;
  unsigned int v2:1;
  int *v3;
};
//SIG(1 S_BFu1i_Ip) C1{ Fs Fi:1 Fp}



static void Test_S_BFu1i_Ip()
{
  {
    init_simple_test("S_BFu1i_Ip");
    static STRUCT_IF_C S_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_Ip, S_BFu1i_Ip)
//============================================================================


struct  S_BFu1i_L  {
  short v1;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 S_BFu1i_L) C1{ Fs Fi:1 FL}



static void Test_S_BFu1i_L()
{
  {
    init_simple_test("S_BFu1i_L");
    static STRUCT_IF_C S_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_L)");
    check_field_offset(lv, v1, 0, "S_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_L, S_BFu1i_L)
//============================================================================


struct  S_BFu1i_S  {
  short v1;
  unsigned int v2:1;
  short v3;
};
//SIG(1 S_BFu1i_S) C1{ Fs Fi:1 Fs}



static void Test_S_BFu1i_S()
{
  {
    init_simple_test("S_BFu1i_S");
    static STRUCT_IF_C S_BFu1i_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_S)");
    check_field_offset(lv, v1, 0, "S_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_S");
    check_field_offset(lv, v3, 4, "S_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_S, S_BFu1i_S)
//============================================================================


struct  S_BFu1i_Uc  {
  short v1;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 S_BFu1i_Uc) C1{ Fs Fi:1 Fc}



static void Test_S_BFu1i_Uc()
{
  {
    init_simple_test("S_BFu1i_Uc");
    static STRUCT_IF_C S_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_Uc");
    check_field_offset(lv, v3, 3, "S_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_Uc, S_BFu1i_Uc)
//============================================================================


struct  S_BFu1i_Ui  {
  short v1;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 S_BFu1i_Ui) C1{ Fs Fi:1 Fi}



static void Test_S_BFu1i_Ui()
{
  {
    init_simple_test("S_BFu1i_Ui");
    static STRUCT_IF_C S_BFu1i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_Ui");
    check_field_offset(lv, v3, 4, "S_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_Ui, S_BFu1i_Ui)
//============================================================================


struct  S_BFu1i_Ul  {
  short v1;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 S_BFu1i_Ul) C1{ Fs Fi:1 FL}



static void Test_S_BFu1i_Ul()
{
  {
    init_simple_test("S_BFu1i_Ul");
    static STRUCT_IF_C S_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_Ul, S_BFu1i_Ul)
//============================================================================


struct  S_BFu1i_Us  {
  short v1;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 S_BFu1i_Us) C1{ Fs Fi:1 Fs}



static void Test_S_BFu1i_Us()
{
  {
    init_simple_test("S_BFu1i_Us");
    static STRUCT_IF_C S_BFu1i_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_Us");
    check_field_offset(lv, v3, 4, "S_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_Us, S_BFu1i_Us)
//============================================================================


struct  S_BFu1i_Vp  {
  short v1;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 S_BFu1i_Vp) C1{ Fs Fi:1 Fp}



static void Test_S_BFu1i_Vp()
{
  {
    init_simple_test("S_BFu1i_Vp");
    static STRUCT_IF_C S_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1i_Vp, S_BFu1i_Vp)
//============================================================================


struct  S_BFu1ll  {
  short v1;
  __tsu64 v2:1;
};
//SIG(1 S_BFu1ll) C1{ Fs FL:1}



static void Test_S_BFu1ll()
{
  {
    init_simple_test("S_BFu1ll");
    static STRUCT_IF_C S_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll, S_BFu1ll)
//============================================================================


struct  S_BFu1ll_BFu15i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 S_BFu1ll_BFu15i) C1{ Fs FL:1 Fi:15}



static void Test_S_BFu1ll_BFu15i()
{
  {
    init_simple_test("S_BFu1ll_BFu15i");
    static STRUCT_IF_C S_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu15i, S_BFu1ll_BFu15i)
//============================================================================


struct  S_BFu1ll_BFu15ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 S_BFu1ll_BFu15ll) C1{ Fs FL:1 FL:15}



static void Test_S_BFu1ll_BFu15ll()
{
  {
    init_simple_test("S_BFu1ll_BFu15ll");
    static STRUCT_IF_C S_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu15ll, S_BFu1ll_BFu15ll)
//============================================================================


struct  S_BFu1ll_BFu15s  {
  short v1;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 S_BFu1ll_BFu15s) C1{ Fs FL:1 Fs:15}



static void Test_S_BFu1ll_BFu15s()
{
  {
    init_simple_test("S_BFu1ll_BFu15s");
    static STRUCT_IF_C S_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu15s, S_BFu1ll_BFu15s)
//============================================================================


struct  S_BFu1ll_BFu16i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 S_BFu1ll_BFu16i) C1{ Fs FL:1 Fi:16}



static void Test_S_BFu1ll_BFu16i()
{
  {
    init_simple_test("S_BFu1ll_BFu16i");
    static STRUCT_IF_C S_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu16i, S_BFu1ll_BFu16i)
//============================================================================


struct  S_BFu1ll_BFu16ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 S_BFu1ll_BFu16ll) C1{ Fs FL:1 FL:16}



static void Test_S_BFu1ll_BFu16ll()
{
  {
    init_simple_test("S_BFu1ll_BFu16ll");
    static STRUCT_IF_C S_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "S_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "S_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu16ll, S_BFu1ll_BFu16ll)
//============================================================================


struct  S_BFu1ll_BFu16s  {
  short v1;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 S_BFu1ll_BFu16s) C1{ Fs FL:1 Fs:16}



static void Test_S_BFu1ll_BFu16s()
{
  {
    init_simple_test("S_BFu1ll_BFu16s");
    static STRUCT_IF_C S_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu16s, S_BFu1ll_BFu16s)
//============================================================================


struct  S_BFu1ll_BFu17i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 S_BFu1ll_BFu17i) C1{ Fs FL:1 Fi:17}



static void Test_S_BFu1ll_BFu17i()
{
  {
    init_simple_test("S_BFu1ll_BFu17i");
    static STRUCT_IF_C S_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu17i, S_BFu1ll_BFu17i)
//============================================================================


struct  S_BFu1ll_BFu17ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 S_BFu1ll_BFu17ll) C1{ Fs FL:1 FL:17}



static void Test_S_BFu1ll_BFu17ll()
{
  {
    init_simple_test("S_BFu1ll_BFu17ll");
    static STRUCT_IF_C S_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "S_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "S_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu17ll, S_BFu1ll_BFu17ll)
//============================================================================


struct  S_BFu1ll_BFu1c  {
  short v1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 S_BFu1ll_BFu1c) C1{ Fs FL:1 Fc:1}



static void Test_S_BFu1ll_BFu1c()
{
  {
    init_simple_test("S_BFu1ll_BFu1c");
    static STRUCT_IF_C S_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu1c, S_BFu1ll_BFu1c)
//============================================================================


struct  S_BFu1ll_BFu1i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 S_BFu1ll_BFu1i) C1{ Fs FL:1 Fi:1}



static void Test_S_BFu1ll_BFu1i()
{
  {
    init_simple_test("S_BFu1ll_BFu1i");
    static STRUCT_IF_C S_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu1i, S_BFu1ll_BFu1i)
//============================================================================


struct  S_BFu1ll_BFu1ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 S_BFu1ll_BFu1ll) C1{ Fs FL:1 FL:1}



static void Test_S_BFu1ll_BFu1ll()
{
  {
    init_simple_test("S_BFu1ll_BFu1ll");
    static STRUCT_IF_C S_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu1ll, S_BFu1ll_BFu1ll)
//============================================================================


struct  S_BFu1ll_BFu1s  {
  short v1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 S_BFu1ll_BFu1s) C1{ Fs FL:1 Fs:1}



static void Test_S_BFu1ll_BFu1s()
{
  {
    init_simple_test("S_BFu1ll_BFu1s");
    static STRUCT_IF_C S_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu1s, S_BFu1ll_BFu1s)
//============================================================================


struct  S_BFu1ll_BFu31i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 S_BFu1ll_BFu31i) C1{ Fs FL:1 Fi:31}



static void Test_S_BFu1ll_BFu31i()
{
  {
    init_simple_test("S_BFu1ll_BFu31i");
    static STRUCT_IF_C S_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu31i, S_BFu1ll_BFu31i)
//============================================================================


struct  S_BFu1ll_BFu31ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 S_BFu1ll_BFu31ll) C1{ Fs FL:1 FL:31}



static void Test_S_BFu1ll_BFu31ll()
{
  {
    init_simple_test("S_BFu1ll_BFu31ll");
    static STRUCT_IF_C S_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "S_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "S_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu31ll, S_BFu1ll_BFu31ll)
//============================================================================


struct  S_BFu1ll_BFu32i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 S_BFu1ll_BFu32i) C1{ Fs FL:1 Fi:32}



static void Test_S_BFu1ll_BFu32i()
{
  {
    init_simple_test("S_BFu1ll_BFu32i");
    static STRUCT_IF_C S_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu32i, S_BFu1ll_BFu32i)
//============================================================================


struct  S_BFu1ll_BFu32ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 S_BFu1ll_BFu32ll) C1{ Fs FL:1 FL:32}



static void Test_S_BFu1ll_BFu32ll()
{
  {
    init_simple_test("S_BFu1ll_BFu32ll");
    static STRUCT_IF_C S_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "S_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "S_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu32ll, S_BFu1ll_BFu32ll)
//============================================================================


struct  S_BFu1ll_BFu33  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 S_BFu1ll_BFu33) C1{ Fs FL:1 FL:33}



static void Test_S_BFu1ll_BFu33()
{
  {
    init_simple_test("S_BFu1ll_BFu33");
    static STRUCT_IF_C S_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "S_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "S_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu33, S_BFu1ll_BFu33)
//============================================================================


struct  S_BFu1ll_BFu7c  {
  short v1;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 S_BFu1ll_BFu7c) C1{ Fs FL:1 Fc:7}



static void Test_S_BFu1ll_BFu7c()
{
  {
    init_simple_test("S_BFu1ll_BFu7c");
    static STRUCT_IF_C S_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu7c, S_BFu1ll_BFu7c)
//============================================================================


struct  S_BFu1ll_BFu7i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 S_BFu1ll_BFu7i) C1{ Fs FL:1 Fi:7}



static void Test_S_BFu1ll_BFu7i()
{
  {
    init_simple_test("S_BFu1ll_BFu7i");
    static STRUCT_IF_C S_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu7i, S_BFu1ll_BFu7i)
//============================================================================


struct  S_BFu1ll_BFu7ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 S_BFu1ll_BFu7ll) C1{ Fs FL:1 FL:7}



static void Test_S_BFu1ll_BFu7ll()
{
  {
    init_simple_test("S_BFu1ll_BFu7ll");
    static STRUCT_IF_C S_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu7ll, S_BFu1ll_BFu7ll)
//============================================================================


struct  S_BFu1ll_BFu7s  {
  short v1;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 S_BFu1ll_BFu7s) C1{ Fs FL:1 Fs:7}



static void Test_S_BFu1ll_BFu7s()
{
  {
    init_simple_test("S_BFu1ll_BFu7s");
    static STRUCT_IF_C S_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu7s, S_BFu1ll_BFu7s)
//============================================================================


struct  S_BFu1ll_BFu8c  {
  short v1;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 S_BFu1ll_BFu8c) C1{ Fs FL:1 Fc:8}



static void Test_S_BFu1ll_BFu8c()
{
  {
    init_simple_test("S_BFu1ll_BFu8c");
    static STRUCT_IF_C S_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu8c, S_BFu1ll_BFu8c)
//============================================================================


struct  S_BFu1ll_BFu8i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 S_BFu1ll_BFu8i) C1{ Fs FL:1 Fi:8}



static void Test_S_BFu1ll_BFu8i()
{
  {
    init_simple_test("S_BFu1ll_BFu8i");
    static STRUCT_IF_C S_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu8i, S_BFu1ll_BFu8i)
//============================================================================


struct  S_BFu1ll_BFu8ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 S_BFu1ll_BFu8ll) C1{ Fs FL:1 FL:8}



static void Test_S_BFu1ll_BFu8ll()
{
  {
    init_simple_test("S_BFu1ll_BFu8ll");
    static STRUCT_IF_C S_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu8ll, S_BFu1ll_BFu8ll)
//============================================================================


struct  S_BFu1ll_BFu8s  {
  short v1;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 S_BFu1ll_BFu8s) C1{ Fs FL:1 Fs:8}



static void Test_S_BFu1ll_BFu8s()
{
  {
    init_simple_test("S_BFu1ll_BFu8s");
    static STRUCT_IF_C S_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu8s, S_BFu1ll_BFu8s)
//============================================================================


struct  S_BFu1ll_BFu9i  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 S_BFu1ll_BFu9i) C1{ Fs FL:1 Fi:9}



static void Test_S_BFu1ll_BFu9i()
{
  {
    init_simple_test("S_BFu1ll_BFu9i");
    static STRUCT_IF_C S_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu9i, S_BFu1ll_BFu9i)
//============================================================================


struct  S_BFu1ll_BFu9ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 S_BFu1ll_BFu9ll) C1{ Fs FL:1 FL:9}



static void Test_S_BFu1ll_BFu9ll()
{
  {
    init_simple_test("S_BFu1ll_BFu9ll");
    static STRUCT_IF_C S_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu9ll, S_BFu1ll_BFu9ll)
//============================================================================


struct  S_BFu1ll_BFu9s  {
  short v1;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 S_BFu1ll_BFu9s) C1{ Fs FL:1 Fs:9}



static void Test_S_BFu1ll_BFu9s()
{
  {
    init_simple_test("S_BFu1ll_BFu9s");
    static STRUCT_IF_C S_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_BFu9s, S_BFu1ll_BFu9s)
//============================================================================


struct  S_BFu1ll_C  {
  short v1;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 S_BFu1ll_C) C1{ Fs FL:1 Fc}



static void Test_S_BFu1ll_C()
{
  {
    init_simple_test("S_BFu1ll_C");
    static STRUCT_IF_C S_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_C");
    check_field_offset(lv, v3, 3, "S_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_C, S_BFu1ll_C)
//============================================================================


struct  S_BFu1ll_D  {
  short v1;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 S_BFu1ll_D) C1{ Fs FL:1 FL}



static void Test_S_BFu1ll_D()
{
  {
    init_simple_test("S_BFu1ll_D");
    static STRUCT_IF_C S_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_D, S_BFu1ll_D)
//============================================================================


struct  S_BFu1ll_F  {
  short v1;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 S_BFu1ll_F) C1{ Fs FL:1 Fi}



static void Test_S_BFu1ll_F()
{
  {
    init_simple_test("S_BFu1ll_F");
    static STRUCT_IF_C S_BFu1ll_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_F");
    check_field_offset(lv, v3, 4, "S_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_F, S_BFu1ll_F)
//============================================================================


struct  S_BFu1ll_I  {
  short v1;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 S_BFu1ll_I) C1{ Fs FL:1 Fi}



static void Test_S_BFu1ll_I()
{
  {
    init_simple_test("S_BFu1ll_I");
    static STRUCT_IF_C S_BFu1ll_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_I");
    check_field_offset(lv, v3, 4, "S_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_I, S_BFu1ll_I)
//============================================================================


struct  S_BFu1ll_Ip  {
  short v1;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 S_BFu1ll_Ip) C1{ Fs FL:1 Fp}



static void Test_S_BFu1ll_Ip()
{
  {
    init_simple_test("S_BFu1ll_Ip");
    static STRUCT_IF_C S_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_Ip, S_BFu1ll_Ip)
//============================================================================


struct  S_BFu1ll_L  {
  short v1;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 S_BFu1ll_L) C1{ Fs FL:1 FL}



static void Test_S_BFu1ll_L()
{
  {
    init_simple_test("S_BFu1ll_L");
    static STRUCT_IF_C S_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_L, S_BFu1ll_L)
//============================================================================


struct  S_BFu1ll_S  {
  short v1;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 S_BFu1ll_S) C1{ Fs FL:1 Fs}



static void Test_S_BFu1ll_S()
{
  {
    init_simple_test("S_BFu1ll_S");
    static STRUCT_IF_C S_BFu1ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_S");
    check_field_offset(lv, v3, 4, "S_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_S, S_BFu1ll_S)
//============================================================================


struct  S_BFu1ll_Uc  {
  short v1;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 S_BFu1ll_Uc) C1{ Fs FL:1 Fc}



static void Test_S_BFu1ll_Uc()
{
  {
    init_simple_test("S_BFu1ll_Uc");
    static STRUCT_IF_C S_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_Uc");
    check_field_offset(lv, v3, 3, "S_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_Uc, S_BFu1ll_Uc)
//============================================================================


struct  S_BFu1ll_Ui  {
  short v1;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 S_BFu1ll_Ui) C1{ Fs FL:1 Fi}



static void Test_S_BFu1ll_Ui()
{
  {
    init_simple_test("S_BFu1ll_Ui");
    static STRUCT_IF_C S_BFu1ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_Ui");
    check_field_offset(lv, v3, 4, "S_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_Ui, S_BFu1ll_Ui)
//============================================================================


struct  S_BFu1ll_Ul  {
  short v1;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 S_BFu1ll_Ul) C1{ Fs FL:1 FL}



static void Test_S_BFu1ll_Ul()
{
  {
    init_simple_test("S_BFu1ll_Ul");
    static STRUCT_IF_C S_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_Ul, S_BFu1ll_Ul)
//============================================================================


struct  S_BFu1ll_Us  {
  short v1;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 S_BFu1ll_Us) C1{ Fs FL:1 Fs}



static void Test_S_BFu1ll_Us()
{
  {
    init_simple_test("S_BFu1ll_Us");
    static STRUCT_IF_C S_BFu1ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_Us");
    check_field_offset(lv, v3, 4, "S_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_Us, S_BFu1ll_Us)
//============================================================================


struct  S_BFu1ll_Vp  {
  short v1;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 S_BFu1ll_Vp) C1{ Fs FL:1 Fp}



static void Test_S_BFu1ll_Vp()
{
  {
    init_simple_test("S_BFu1ll_Vp");
    static STRUCT_IF_C S_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1ll_Vp, S_BFu1ll_Vp)
//============================================================================


struct  S_BFu1s  {
  short v1;
  unsigned short v2:1;
};
//SIG(1 S_BFu1s) C1{ Fs Fs:1}



static void Test_S_BFu1s()
{
  {
    init_simple_test("S_BFu1s");
    static STRUCT_IF_C S_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s, S_BFu1s)
//============================================================================


struct  S_BFu1s_BFu15i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 S_BFu1s_BFu15i) C1{ Fs Fs:1 Fi:15}



static void Test_S_BFu1s_BFu15i()
{
  {
    init_simple_test("S_BFu1s_BFu15i");
    static STRUCT_IF_C S_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu15i, S_BFu1s_BFu15i)
//============================================================================


struct  S_BFu1s_BFu15ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 S_BFu1s_BFu15ll) C1{ Fs Fs:1 FL:15}



static void Test_S_BFu1s_BFu15ll()
{
  {
    init_simple_test("S_BFu1s_BFu15ll");
    static STRUCT_IF_C S_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu15ll, S_BFu1s_BFu15ll)
//============================================================================


struct  S_BFu1s_BFu15s  {
  short v1;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 S_BFu1s_BFu15s) C1{ Fs Fs:1 Fs:15}



static void Test_S_BFu1s_BFu15s()
{
  {
    init_simple_test("S_BFu1s_BFu15s");
    static STRUCT_IF_C S_BFu1s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "S_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "S_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu15s, S_BFu1s_BFu15s)
//============================================================================


struct  S_BFu1s_BFu16i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 S_BFu1s_BFu16i) C1{ Fs Fs:1 Fi:16}



static void Test_S_BFu1s_BFu16i()
{
  {
    init_simple_test("S_BFu1s_BFu16i");
    static STRUCT_IF_C S_BFu1s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu16i, S_BFu1s_BFu16i)
//============================================================================


struct  S_BFu1s_BFu16ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 S_BFu1s_BFu16ll) C1{ Fs Fs:1 FL:16}



static void Test_S_BFu1s_BFu16ll()
{
  {
    init_simple_test("S_BFu1s_BFu16ll");
    static STRUCT_IF_C S_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "S_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "S_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu16ll, S_BFu1s_BFu16ll)
//============================================================================


struct  S_BFu1s_BFu16s  {
  short v1;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 S_BFu1s_BFu16s) C1{ Fs Fs:1 Fs:16}



static void Test_S_BFu1s_BFu16s()
{
  {
    init_simple_test("S_BFu1s_BFu16s");
    static STRUCT_IF_C S_BFu1s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu1s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu16s, S_BFu1s_BFu16s)
//============================================================================


struct  S_BFu1s_BFu17i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 S_BFu1s_BFu17i) C1{ Fs Fs:1 Fi:17}



static void Test_S_BFu1s_BFu17i()
{
  {
    init_simple_test("S_BFu1s_BFu17i");
    static STRUCT_IF_C S_BFu1s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu17i, S_BFu1s_BFu17i)
//============================================================================


struct  S_BFu1s_BFu17ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 S_BFu1s_BFu17ll) C1{ Fs Fs:1 FL:17}



static void Test_S_BFu1s_BFu17ll()
{
  {
    init_simple_test("S_BFu1s_BFu17ll");
    static STRUCT_IF_C S_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "S_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "S_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu17ll, S_BFu1s_BFu17ll)
//============================================================================


struct  S_BFu1s_BFu1c  {
  short v1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 S_BFu1s_BFu1c) C1{ Fs Fs:1 Fc:1}



static void Test_S_BFu1s_BFu1c()
{
  {
    init_simple_test("S_BFu1s_BFu1c");
    static STRUCT_IF_C S_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu1c, S_BFu1s_BFu1c)
//============================================================================


struct  S_BFu1s_BFu1i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 S_BFu1s_BFu1i) C1{ Fs Fs:1 Fi:1}



static void Test_S_BFu1s_BFu1i()
{
  {
    init_simple_test("S_BFu1s_BFu1i");
    static STRUCT_IF_C S_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu1i, S_BFu1s_BFu1i)
//============================================================================


struct  S_BFu1s_BFu1ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 S_BFu1s_BFu1ll) C1{ Fs Fs:1 FL:1}



static void Test_S_BFu1s_BFu1ll()
{
  {
    init_simple_test("S_BFu1s_BFu1ll");
    static STRUCT_IF_C S_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu1ll, S_BFu1s_BFu1ll)
//============================================================================


struct  S_BFu1s_BFu1s  {
  short v1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 S_BFu1s_BFu1s) C1{ Fs Fs:1 Fs:1}



static void Test_S_BFu1s_BFu1s()
{
  {
    init_simple_test("S_BFu1s_BFu1s");
    static STRUCT_IF_C S_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "S_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu1s, S_BFu1s_BFu1s)
//============================================================================


struct  S_BFu1s_BFu31i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 S_BFu1s_BFu31i) C1{ Fs Fs:1 Fi:31}



static void Test_S_BFu1s_BFu31i()
{
  {
    init_simple_test("S_BFu1s_BFu31i");
    static STRUCT_IF_C S_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu31i, S_BFu1s_BFu31i)
//============================================================================


struct  S_BFu1s_BFu31ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 S_BFu1s_BFu31ll) C1{ Fs Fs:1 FL:31}



static void Test_S_BFu1s_BFu31ll()
{
  {
    init_simple_test("S_BFu1s_BFu31ll");
    static STRUCT_IF_C S_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "S_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "S_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu31ll, S_BFu1s_BFu31ll)
//============================================================================


struct  S_BFu1s_BFu32i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 S_BFu1s_BFu32i) C1{ Fs Fs:1 Fi:32}



static void Test_S_BFu1s_BFu32i()
{
  {
    init_simple_test("S_BFu1s_BFu32i");
    static STRUCT_IF_C S_BFu1s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu32i, S_BFu1s_BFu32i)
//============================================================================


struct  S_BFu1s_BFu32ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 S_BFu1s_BFu32ll) C1{ Fs Fs:1 FL:32}



static void Test_S_BFu1s_BFu32ll()
{
  {
    init_simple_test("S_BFu1s_BFu32ll");
    static STRUCT_IF_C S_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "S_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "S_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu32ll, S_BFu1s_BFu32ll)
//============================================================================


struct  S_BFu1s_BFu33  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 S_BFu1s_BFu33) C1{ Fs Fs:1 FL:33}



static void Test_S_BFu1s_BFu33()
{
  {
    init_simple_test("S_BFu1s_BFu33");
    static STRUCT_IF_C S_BFu1s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "S_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "S_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu33, S_BFu1s_BFu33)
//============================================================================


struct  S_BFu1s_BFu7c  {
  short v1;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 S_BFu1s_BFu7c) C1{ Fs Fs:1 Fc:7}



static void Test_S_BFu1s_BFu7c()
{
  {
    init_simple_test("S_BFu1s_BFu7c");
    static STRUCT_IF_C S_BFu1s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu7c, S_BFu1s_BFu7c)
//============================================================================


struct  S_BFu1s_BFu7i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 S_BFu1s_BFu7i) C1{ Fs Fs:1 Fi:7}



static void Test_S_BFu1s_BFu7i()
{
  {
    init_simple_test("S_BFu1s_BFu7i");
    static STRUCT_IF_C S_BFu1s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu7i, S_BFu1s_BFu7i)
//============================================================================


struct  S_BFu1s_BFu7ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 S_BFu1s_BFu7ll) C1{ Fs Fs:1 FL:7}



static void Test_S_BFu1s_BFu7ll()
{
  {
    init_simple_test("S_BFu1s_BFu7ll");
    static STRUCT_IF_C S_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu7ll, S_BFu1s_BFu7ll)
//============================================================================


struct  S_BFu1s_BFu7s  {
  short v1;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 S_BFu1s_BFu7s) C1{ Fs Fs:1 Fs:7}



static void Test_S_BFu1s_BFu7s()
{
  {
    init_simple_test("S_BFu1s_BFu7s");
    static STRUCT_IF_C S_BFu1s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "S_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "S_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu7s, S_BFu1s_BFu7s)
//============================================================================


struct  S_BFu1s_BFu8c  {
  short v1;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 S_BFu1s_BFu8c) C1{ Fs Fs:1 Fc:8}



static void Test_S_BFu1s_BFu8c()
{
  {
    init_simple_test("S_BFu1s_BFu8c");
    static STRUCT_IF_C S_BFu1s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu8c, S_BFu1s_BFu8c)
//============================================================================


struct  S_BFu1s_BFu8i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 S_BFu1s_BFu8i) C1{ Fs Fs:1 Fi:8}



static void Test_S_BFu1s_BFu8i()
{
  {
    init_simple_test("S_BFu1s_BFu8i");
    static STRUCT_IF_C S_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu8i, S_BFu1s_BFu8i)
//============================================================================


struct  S_BFu1s_BFu8ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 S_BFu1s_BFu8ll) C1{ Fs Fs:1 FL:8}



static void Test_S_BFu1s_BFu8ll()
{
  {
    init_simple_test("S_BFu1s_BFu8ll");
    static STRUCT_IF_C S_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu8ll, S_BFu1s_BFu8ll)
//============================================================================


struct  S_BFu1s_BFu8s  {
  short v1;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 S_BFu1s_BFu8s) C1{ Fs Fs:1 Fs:8}



static void Test_S_BFu1s_BFu8s()
{
  {
    init_simple_test("S_BFu1s_BFu8s");
    static STRUCT_IF_C S_BFu1s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "S_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "S_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu8s, S_BFu1s_BFu8s)
//============================================================================


struct  S_BFu1s_BFu9i  {
  short v1;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 S_BFu1s_BFu9i) C1{ Fs Fs:1 Fi:9}



static void Test_S_BFu1s_BFu9i()
{
  {
    init_simple_test("S_BFu1s_BFu9i");
    static STRUCT_IF_C S_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu9i, S_BFu1s_BFu9i)
//============================================================================


struct  S_BFu1s_BFu9ll  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 S_BFu1s_BFu9ll) C1{ Fs Fs:1 FL:9}



static void Test_S_BFu1s_BFu9ll()
{
  {
    init_simple_test("S_BFu1s_BFu9ll");
    static STRUCT_IF_C S_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu9ll, S_BFu1s_BFu9ll)
//============================================================================


struct  S_BFu1s_BFu9s  {
  short v1;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 S_BFu1s_BFu9s) C1{ Fs Fs:1 Fs:9}



static void Test_S_BFu1s_BFu9s()
{
  {
    init_simple_test("S_BFu1s_BFu9s");
    static STRUCT_IF_C S_BFu1s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "S_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "S_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_BFu9s, S_BFu1s_BFu9s)
//============================================================================


struct  S_BFu1s_C  {
  short v1;
  unsigned short v2:1;
  char v3;
};
//SIG(1 S_BFu1s_C) C1{ Fs Fs:1 Fc}



static void Test_S_BFu1s_C()
{
  {
    init_simple_test("S_BFu1s_C");
    static STRUCT_IF_C S_BFu1s_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_C)");
    check_field_offset(lv, v1, 0, "S_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_C");
    check_field_offset(lv, v3, 3, "S_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_C, S_BFu1s_C)
//============================================================================


struct  S_BFu1s_D  {
  short v1;
  unsigned short v2:1;
  double v3;
};
//SIG(1 S_BFu1s_D) C1{ Fs Fs:1 FL}



static void Test_S_BFu1s_D()
{
  {
    init_simple_test("S_BFu1s_D");
    static STRUCT_IF_C S_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_D)");
    check_field_offset(lv, v1, 0, "S_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_D, S_BFu1s_D)
//============================================================================


struct  S_BFu1s_F  {
  short v1;
  unsigned short v2:1;
  float v3;
};
//SIG(1 S_BFu1s_F) C1{ Fs Fs:1 Fi}



static void Test_S_BFu1s_F()
{
  {
    init_simple_test("S_BFu1s_F");
    static STRUCT_IF_C S_BFu1s_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_F)");
    check_field_offset(lv, v1, 0, "S_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_F");
    check_field_offset(lv, v3, 4, "S_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_F, S_BFu1s_F)
//============================================================================


struct  S_BFu1s_I  {
  short v1;
  unsigned short v2:1;
  int v3;
};
//SIG(1 S_BFu1s_I) C1{ Fs Fs:1 Fi}



static void Test_S_BFu1s_I()
{
  {
    init_simple_test("S_BFu1s_I");
    static STRUCT_IF_C S_BFu1s_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_I)");
    check_field_offset(lv, v1, 0, "S_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_I");
    check_field_offset(lv, v3, 4, "S_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_I, S_BFu1s_I)
//============================================================================


struct  S_BFu1s_Ip  {
  short v1;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 S_BFu1s_Ip) C1{ Fs Fs:1 Fp}



static void Test_S_BFu1s_Ip()
{
  {
    init_simple_test("S_BFu1s_Ip");
    static STRUCT_IF_C S_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_Ip, S_BFu1s_Ip)
//============================================================================


struct  S_BFu1s_L  {
  short v1;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 S_BFu1s_L) C1{ Fs Fs:1 FL}



static void Test_S_BFu1s_L()
{
  {
    init_simple_test("S_BFu1s_L");
    static STRUCT_IF_C S_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_L)");
    check_field_offset(lv, v1, 0, "S_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_L, S_BFu1s_L)
//============================================================================


struct  S_BFu1s_S  {
  short v1;
  unsigned short v2:1;
  short v3;
};
//SIG(1 S_BFu1s_S) C1{ Fs Fs:1 Fs}



static void Test_S_BFu1s_S()
{
  {
    init_simple_test("S_BFu1s_S");
    static STRUCT_IF_C S_BFu1s_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu1s_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_S)");
    check_field_offset(lv, v1, 0, "S_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_S");
    check_field_offset(lv, v3, 4, "S_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_S, S_BFu1s_S)
//============================================================================


struct  S_BFu1s_Uc  {
  short v1;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 S_BFu1s_Uc) C1{ Fs Fs:1 Fc}



static void Test_S_BFu1s_Uc()
{
  {
    init_simple_test("S_BFu1s_Uc");
    static STRUCT_IF_C S_BFu1s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_Uc");
    check_field_offset(lv, v3, 3, "S_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_Uc, S_BFu1s_Uc)
//============================================================================


struct  S_BFu1s_Ui  {
  short v1;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 S_BFu1s_Ui) C1{ Fs Fs:1 Fi}



static void Test_S_BFu1s_Ui()
{
  {
    init_simple_test("S_BFu1s_Ui");
    static STRUCT_IF_C S_BFu1s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_Ui");
    check_field_offset(lv, v3, 4, "S_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_Ui, S_BFu1s_Ui)
//============================================================================


struct  S_BFu1s_Ul  {
  short v1;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 S_BFu1s_Ul) C1{ Fs Fs:1 FL}



static void Test_S_BFu1s_Ul()
{
  {
    init_simple_test("S_BFu1s_Ul");
    static STRUCT_IF_C S_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_Ul, S_BFu1s_Ul)
//============================================================================


struct  S_BFu1s_Us  {
  short v1;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 S_BFu1s_Us) C1{ Fs Fs:1 Fs}



static void Test_S_BFu1s_Us()
{
  {
    init_simple_test("S_BFu1s_Us");
    static STRUCT_IF_C S_BFu1s_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu1s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "S_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_Us");
    check_field_offset(lv, v3, 4, "S_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_Us, S_BFu1s_Us)
//============================================================================


struct  S_BFu1s_Vp  {
  short v1;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 S_BFu1s_Vp) C1{ Fs Fs:1 Fp}



static void Test_S_BFu1s_Vp()
{
  {
    init_simple_test("S_BFu1s_Vp");
    static STRUCT_IF_C S_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu1s_Vp, S_BFu1s_Vp)
//============================================================================


struct  S_BFu31i  {
  short v1;
  unsigned int v2:31;
};
//SIG(1 S_BFu31i) C1{ Fs Fi:31}



static void Test_S_BFu31i()
{
  {
    init_simple_test("S_BFu31i");
    static STRUCT_IF_C S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i, S_BFu31i)
//============================================================================


struct  S_BFu31i_BFu15i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 S_BFu31i_BFu15i) C1{ Fs Fi:31 Fi:15}



static void Test_S_BFu31i_BFu15i()
{
  {
    init_simple_test("S_BFu31i_BFu15i");
    static STRUCT_IF_C S_BFu31i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "S_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "S_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu15i, S_BFu31i_BFu15i)
//============================================================================


struct  S_BFu31i_BFu15ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 S_BFu31i_BFu15ll) C1{ Fs Fi:31 FL:15}



static void Test_S_BFu31i_BFu15ll()
{
  {
    init_simple_test("S_BFu31i_BFu15ll");
    static STRUCT_IF_C S_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "S_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "S_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu15ll, S_BFu31i_BFu15ll)
//============================================================================


struct  S_BFu31i_BFu15s  {
  short v1;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 S_BFu31i_BFu15s) C1{ Fs Fi:31 Fs:15}



static void Test_S_BFu31i_BFu15s()
{
  {
    init_simple_test("S_BFu31i_BFu15s");
    static STRUCT_IF_C S_BFu31i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "S_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "S_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu15s, S_BFu31i_BFu15s)
//============================================================================


struct  S_BFu31i_BFu16i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 S_BFu31i_BFu16i) C1{ Fs Fi:31 Fi:16}



static void Test_S_BFu31i_BFu16i()
{
  {
    init_simple_test("S_BFu31i_BFu16i");
    static STRUCT_IF_C S_BFu31i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu16i, S_BFu31i_BFu16i)
//============================================================================


struct  S_BFu31i_BFu16ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 S_BFu31i_BFu16ll) C1{ Fs Fi:31 FL:16}



static void Test_S_BFu31i_BFu16ll()
{
  {
    init_simple_test("S_BFu31i_BFu16ll");
    static STRUCT_IF_C S_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "S_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "S_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu16ll, S_BFu31i_BFu16ll)
//============================================================================


struct  S_BFu31i_BFu16s  {
  short v1;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 S_BFu31i_BFu16s) C1{ Fs Fi:31 Fs:16}



static void Test_S_BFu31i_BFu16s()
{
  {
    init_simple_test("S_BFu31i_BFu16s");
    static STRUCT_IF_C S_BFu31i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu16s, S_BFu31i_BFu16s)
//============================================================================


struct  S_BFu31i_BFu17i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 S_BFu31i_BFu17i) C1{ Fs Fi:31 Fi:17}



static void Test_S_BFu31i_BFu17i()
{
  {
    init_simple_test("S_BFu31i_BFu17i");
    static STRUCT_IF_C S_BFu31i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "S_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "S_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu17i, S_BFu31i_BFu17i)
//============================================================================


struct  S_BFu31i_BFu17ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 S_BFu31i_BFu17ll) C1{ Fs Fi:31 FL:17}



static void Test_S_BFu31i_BFu17ll()
{
  {
    init_simple_test("S_BFu31i_BFu17ll");
    static STRUCT_IF_C S_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "S_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "S_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu17ll, S_BFu31i_BFu17ll)
//============================================================================


struct  S_BFu31i_BFu1c  {
  short v1;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 S_BFu31i_BFu1c) C1{ Fs Fi:31 Fc:1}



static void Test_S_BFu31i_BFu1c()
{
  {
    init_simple_test("S_BFu31i_BFu1c");
    static STRUCT_IF_C S_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "S_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu1c, S_BFu31i_BFu1c)
//============================================================================


struct  S_BFu31i_BFu1i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 S_BFu31i_BFu1i) C1{ Fs Fi:31 Fi:1}



static void Test_S_BFu31i_BFu1i()
{
  {
    init_simple_test("S_BFu31i_BFu1i");
    static STRUCT_IF_C S_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "S_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu1i, S_BFu31i_BFu1i)
//============================================================================


struct  S_BFu31i_BFu1ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 S_BFu31i_BFu1ll) C1{ Fs Fi:31 FL:1}



static void Test_S_BFu31i_BFu1ll()
{
  {
    init_simple_test("S_BFu31i_BFu1ll");
    static STRUCT_IF_C S_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "S_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu1ll, S_BFu31i_BFu1ll)
//============================================================================


struct  S_BFu31i_BFu1s  {
  short v1;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 S_BFu31i_BFu1s) C1{ Fs Fi:31 Fs:1}



static void Test_S_BFu31i_BFu1s()
{
  {
    init_simple_test("S_BFu31i_BFu1s");
    static STRUCT_IF_C S_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "S_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu1s, S_BFu31i_BFu1s)
//============================================================================


struct  S_BFu31i_BFu31i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 S_BFu31i_BFu31i) C1{ Fs Fi:31 Fi:31}



static void Test_S_BFu31i_BFu31i()
{
  {
    init_simple_test("S_BFu31i_BFu31i");
    static STRUCT_IF_C S_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "S_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu31i, S_BFu31i_BFu31i)
//============================================================================


struct  S_BFu31i_BFu31ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 S_BFu31i_BFu31ll) C1{ Fs Fi:31 FL:31}



static void Test_S_BFu31i_BFu31ll()
{
  {
    init_simple_test("S_BFu31i_BFu31ll");
    static STRUCT_IF_C S_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "S_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "S_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu31ll, S_BFu31i_BFu31ll)
//============================================================================


struct  S_BFu31i_BFu32i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 S_BFu31i_BFu32i) C1{ Fs Fi:31 Fi:32}



static void Test_S_BFu31i_BFu32i()
{
  {
    init_simple_test("S_BFu31i_BFu32i");
    static STRUCT_IF_C S_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "S_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "S_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu32i, S_BFu31i_BFu32i)
//============================================================================


struct  S_BFu31i_BFu32ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 S_BFu31i_BFu32ll) C1{ Fs Fi:31 FL:32}



static void Test_S_BFu31i_BFu32ll()
{
  {
    init_simple_test("S_BFu31i_BFu32ll");
    static STRUCT_IF_C S_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "S_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "S_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu32ll, S_BFu31i_BFu32ll)
//============================================================================


struct  S_BFu31i_BFu33  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 S_BFu31i_BFu33) C1{ Fs Fi:31 FL:33}



static void Test_S_BFu31i_BFu33()
{
  {
    init_simple_test("S_BFu31i_BFu33");
    static STRUCT_IF_C S_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "S_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "S_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu33, S_BFu31i_BFu33)
//============================================================================


struct  S_BFu31i_BFu7c  {
  short v1;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 S_BFu31i_BFu7c) C1{ Fs Fi:31 Fc:7}



static void Test_S_BFu31i_BFu7c()
{
  {
    init_simple_test("S_BFu31i_BFu7c");
    static STRUCT_IF_C S_BFu31i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "S_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "S_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu7c, S_BFu31i_BFu7c)
//============================================================================


struct  S_BFu31i_BFu7i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 S_BFu31i_BFu7i) C1{ Fs Fi:31 Fi:7}



static void Test_S_BFu31i_BFu7i()
{
  {
    init_simple_test("S_BFu31i_BFu7i");
    static STRUCT_IF_C S_BFu31i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "S_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "S_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu7i, S_BFu31i_BFu7i)
//============================================================================


struct  S_BFu31i_BFu7ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 S_BFu31i_BFu7ll) C1{ Fs Fi:31 FL:7}



static void Test_S_BFu31i_BFu7ll()
{
  {
    init_simple_test("S_BFu31i_BFu7ll");
    static STRUCT_IF_C S_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "S_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "S_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu7ll, S_BFu31i_BFu7ll)
//============================================================================


struct  S_BFu31i_BFu7s  {
  short v1;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 S_BFu31i_BFu7s) C1{ Fs Fi:31 Fs:7}



static void Test_S_BFu31i_BFu7s()
{
  {
    init_simple_test("S_BFu31i_BFu7s");
    static STRUCT_IF_C S_BFu31i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "S_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "S_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu7s, S_BFu31i_BFu7s)
//============================================================================


struct  S_BFu31i_BFu8c  {
  short v1;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 S_BFu31i_BFu8c) C1{ Fs Fi:31 Fc:8}



static void Test_S_BFu31i_BFu8c()
{
  {
    init_simple_test("S_BFu31i_BFu8c");
    static STRUCT_IF_C S_BFu31i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "S_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "S_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu8c, S_BFu31i_BFu8c)
//============================================================================


struct  S_BFu31i_BFu8i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 S_BFu31i_BFu8i) C1{ Fs Fi:31 Fi:8}



static void Test_S_BFu31i_BFu8i()
{
  {
    init_simple_test("S_BFu31i_BFu8i");
    static STRUCT_IF_C S_BFu31i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "S_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "S_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu8i, S_BFu31i_BFu8i)
//============================================================================


struct  S_BFu31i_BFu8ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 S_BFu31i_BFu8ll) C1{ Fs Fi:31 FL:8}



static void Test_S_BFu31i_BFu8ll()
{
  {
    init_simple_test("S_BFu31i_BFu8ll");
    static STRUCT_IF_C S_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "S_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "S_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu8ll, S_BFu31i_BFu8ll)
//============================================================================


struct  S_BFu31i_BFu8s  {
  short v1;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 S_BFu31i_BFu8s) C1{ Fs Fi:31 Fs:8}



static void Test_S_BFu31i_BFu8s()
{
  {
    init_simple_test("S_BFu31i_BFu8s");
    static STRUCT_IF_C S_BFu31i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "S_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "S_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu8s, S_BFu31i_BFu8s)
//============================================================================


struct  S_BFu31i_BFu9i  {
  short v1;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 S_BFu31i_BFu9i) C1{ Fs Fi:31 Fi:9}



static void Test_S_BFu31i_BFu9i()
{
  {
    init_simple_test("S_BFu31i_BFu9i");
    static STRUCT_IF_C S_BFu31i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "S_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "S_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu9i, S_BFu31i_BFu9i)
//============================================================================


struct  S_BFu31i_BFu9ll  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 S_BFu31i_BFu9ll) C1{ Fs Fi:31 FL:9}



static void Test_S_BFu31i_BFu9ll()
{
  {
    init_simple_test("S_BFu31i_BFu9ll");
    static STRUCT_IF_C S_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "S_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "S_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu9ll, S_BFu31i_BFu9ll)
//============================================================================


struct  S_BFu31i_BFu9s  {
  short v1;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 S_BFu31i_BFu9s) C1{ Fs Fi:31 Fs:9}



static void Test_S_BFu31i_BFu9s()
{
  {
    init_simple_test("S_BFu31i_BFu9s");
    static STRUCT_IF_C S_BFu31i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "S_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "S_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_BFu9s, S_BFu31i_BFu9s)
//============================================================================


struct  S_BFu31i_C  {
  short v1;
  unsigned int v2:31;
  char v3;
};
//SIG(1 S_BFu31i_C) C1{ Fs Fi:31 Fc}



static void Test_S_BFu31i_C()
{
  {
    init_simple_test("S_BFu31i_C");
    static STRUCT_IF_C S_BFu31i_C lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_C)");
    check_field_offset(lv, v1, 0, "S_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_C");
    check_field_offset(lv, v3, 8, "S_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_C, S_BFu31i_C)
//============================================================================


struct  S_BFu31i_D  {
  short v1;
  unsigned int v2:31;
  double v3;
};
//SIG(1 S_BFu31i_D) C1{ Fs Fi:31 FL}



static void Test_S_BFu31i_D()
{
  {
    init_simple_test("S_BFu31i_D");
    static STRUCT_IF_C S_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_D)");
    check_field_offset(lv, v1, 0, "S_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_D");
    check_field_offset(lv, v3, 8, "S_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_D, S_BFu31i_D)
//============================================================================


struct  S_BFu31i_F  {
  short v1;
  unsigned int v2:31;
  float v3;
};
//SIG(1 S_BFu31i_F) C1{ Fs Fi:31 Fi}



static void Test_S_BFu31i_F()
{
  {
    init_simple_test("S_BFu31i_F");
    static STRUCT_IF_C S_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_F)");
    check_field_offset(lv, v1, 0, "S_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_F");
    check_field_offset(lv, v3, 8, "S_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_F, S_BFu31i_F)
//============================================================================


struct  S_BFu31i_I  {
  short v1;
  unsigned int v2:31;
  int v3;
};
//SIG(1 S_BFu31i_I) C1{ Fs Fi:31 Fi}



static void Test_S_BFu31i_I()
{
  {
    init_simple_test("S_BFu31i_I");
    static STRUCT_IF_C S_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_I)");
    check_field_offset(lv, v1, 0, "S_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_I");
    check_field_offset(lv, v3, 8, "S_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_I, S_BFu31i_I)
//============================================================================


struct  S_BFu31i_Ip  {
  short v1;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 S_BFu31i_Ip) C1{ Fs Fi:31 Fp}



static void Test_S_BFu31i_Ip()
{
  {
    init_simple_test("S_BFu31i_Ip");
    static STRUCT_IF_C S_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "S_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_Ip, S_BFu31i_Ip)
//============================================================================


struct  S_BFu31i_L  {
  short v1;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 S_BFu31i_L) C1{ Fs Fi:31 FL}



static void Test_S_BFu31i_L()
{
  {
    init_simple_test("S_BFu31i_L");
    static STRUCT_IF_C S_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_L)");
    check_field_offset(lv, v1, 0, "S_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_L");
    check_field_offset(lv, v3, 8, "S_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_L, S_BFu31i_L)
//============================================================================


struct  S_BFu31i_S  {
  short v1;
  unsigned int v2:31;
  short v3;
};
//SIG(1 S_BFu31i_S) C1{ Fs Fi:31 Fs}



static void Test_S_BFu31i_S()
{
  {
    init_simple_test("S_BFu31i_S");
    static STRUCT_IF_C S_BFu31i_S lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_S)");
    check_field_offset(lv, v1, 0, "S_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_S");
    check_field_offset(lv, v3, 8, "S_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_S, S_BFu31i_S)
//============================================================================


struct  S_BFu31i_Uc  {
  short v1;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 S_BFu31i_Uc) C1{ Fs Fi:31 Fc}



static void Test_S_BFu31i_Uc()
{
  {
    init_simple_test("S_BFu31i_Uc");
    static STRUCT_IF_C S_BFu31i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "S_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_Uc, S_BFu31i_Uc)
//============================================================================


struct  S_BFu31i_Ui  {
  short v1;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 S_BFu31i_Ui) C1{ Fs Fi:31 Fi}



static void Test_S_BFu31i_Ui()
{
  {
    init_simple_test("S_BFu31i_Ui");
    static STRUCT_IF_C S_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "S_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_Ui, S_BFu31i_Ui)
//============================================================================


struct  S_BFu31i_Ul  {
  short v1;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 S_BFu31i_Ul) C1{ Fs Fi:31 FL}



static void Test_S_BFu31i_Ul()
{
  {
    init_simple_test("S_BFu31i_Ul");
    static STRUCT_IF_C S_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "S_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_Ul, S_BFu31i_Ul)
//============================================================================


struct  S_BFu31i_Us  {
  short v1;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 S_BFu31i_Us) C1{ Fs Fi:31 Fs}



static void Test_S_BFu31i_Us()
{
  {
    init_simple_test("S_BFu31i_Us");
    static STRUCT_IF_C S_BFu31i_Us lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_Us");
    check_field_offset(lv, v3, 8, "S_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_Us, S_BFu31i_Us)
//============================================================================


struct  S_BFu31i_Vp  {
  short v1;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 S_BFu31i_Vp) C1{ Fs Fi:31 Fp}



static void Test_S_BFu31i_Vp()
{
  {
    init_simple_test("S_BFu31i_Vp");
    static STRUCT_IF_C S_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "S_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31i_Vp, S_BFu31i_Vp)
//============================================================================


struct  S_BFu31ll  {
  short v1;
  __tsu64 v2:31;
};
//SIG(1 S_BFu31ll) C1{ Fs FL:31}



static void Test_S_BFu31ll()
{
  {
    init_simple_test("S_BFu31ll");
    static STRUCT_IF_C S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll, S_BFu31ll)
//============================================================================


struct  S_BFu31ll_BFu15i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 S_BFu31ll_BFu15i) C1{ Fs FL:31 Fi:15}



static void Test_S_BFu31ll_BFu15i()
{
  {
    init_simple_test("S_BFu31ll_BFu15i");
    static STRUCT_IF_C S_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "S_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "S_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu15i, S_BFu31ll_BFu15i)
//============================================================================


struct  S_BFu31ll_BFu15ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 S_BFu31ll_BFu15ll) C1{ Fs FL:31 FL:15}



static void Test_S_BFu31ll_BFu15ll()
{
  {
    init_simple_test("S_BFu31ll_BFu15ll");
    static STRUCT_IF_C S_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "S_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "S_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu15ll, S_BFu31ll_BFu15ll)
//============================================================================


struct  S_BFu31ll_BFu15s  {
  short v1;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 S_BFu31ll_BFu15s) C1{ Fs FL:31 Fs:15}



static void Test_S_BFu31ll_BFu15s()
{
  {
    init_simple_test("S_BFu31ll_BFu15s");
    static STRUCT_IF_C S_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "S_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "S_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu15s, S_BFu31ll_BFu15s)
//============================================================================


struct  S_BFu31ll_BFu16i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 S_BFu31ll_BFu16i) C1{ Fs FL:31 Fi:16}



static void Test_S_BFu31ll_BFu16i()
{
  {
    init_simple_test("S_BFu31ll_BFu16i");
    static STRUCT_IF_C S_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "S_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "S_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu16i, S_BFu31ll_BFu16i)
//============================================================================


struct  S_BFu31ll_BFu16ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 S_BFu31ll_BFu16ll) C1{ Fs FL:31 FL:16}



static void Test_S_BFu31ll_BFu16ll()
{
  {
    init_simple_test("S_BFu31ll_BFu16ll");
    static STRUCT_IF_C S_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "S_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "S_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu16ll, S_BFu31ll_BFu16ll)
//============================================================================


struct  S_BFu31ll_BFu16s  {
  short v1;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 S_BFu31ll_BFu16s) C1{ Fs FL:31 Fs:16}



static void Test_S_BFu31ll_BFu16s()
{
  {
    init_simple_test("S_BFu31ll_BFu16s");
    static STRUCT_IF_C S_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "S_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "S_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu16s, S_BFu31ll_BFu16s)
//============================================================================


struct  S_BFu31ll_BFu17i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 S_BFu31ll_BFu17i) C1{ Fs FL:31 Fi:17}



static void Test_S_BFu31ll_BFu17i()
{
  {
    init_simple_test("S_BFu31ll_BFu17i");
    static STRUCT_IF_C S_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "S_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "S_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu17i, S_BFu31ll_BFu17i)
//============================================================================


struct  S_BFu31ll_BFu17ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 S_BFu31ll_BFu17ll) C1{ Fs FL:31 FL:17}



static void Test_S_BFu31ll_BFu17ll()
{
  {
    init_simple_test("S_BFu31ll_BFu17ll");
    static STRUCT_IF_C S_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "S_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "S_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu17ll, S_BFu31ll_BFu17ll)
//============================================================================


struct  S_BFu31ll_BFu1c  {
  short v1;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 S_BFu31ll_BFu1c) C1{ Fs FL:31 Fc:1}



static void Test_S_BFu31ll_BFu1c()
{
  {
    init_simple_test("S_BFu31ll_BFu1c");
    static STRUCT_IF_C S_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "S_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu1c, S_BFu31ll_BFu1c)
//============================================================================


struct  S_BFu31ll_BFu1i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 S_BFu31ll_BFu1i) C1{ Fs FL:31 Fi:1}



static void Test_S_BFu31ll_BFu1i()
{
  {
    init_simple_test("S_BFu31ll_BFu1i");
    static STRUCT_IF_C S_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "S_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu1i, S_BFu31ll_BFu1i)
//============================================================================


struct  S_BFu31ll_BFu1ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 S_BFu31ll_BFu1ll) C1{ Fs FL:31 FL:1}



static void Test_S_BFu31ll_BFu1ll()
{
  {
    init_simple_test("S_BFu31ll_BFu1ll");
    static STRUCT_IF_C S_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "S_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu1ll, S_BFu31ll_BFu1ll)
//============================================================================


struct  S_BFu31ll_BFu1s  {
  short v1;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 S_BFu31ll_BFu1s) C1{ Fs FL:31 Fs:1}



static void Test_S_BFu31ll_BFu1s()
{
  {
    init_simple_test("S_BFu31ll_BFu1s");
    static STRUCT_IF_C S_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "S_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu1s, S_BFu31ll_BFu1s)
//============================================================================


struct  S_BFu31ll_BFu31i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 S_BFu31ll_BFu31i) C1{ Fs FL:31 Fi:31}



static void Test_S_BFu31ll_BFu31i()
{
  {
    init_simple_test("S_BFu31ll_BFu31i");
    static STRUCT_IF_C S_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "S_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu31i, S_BFu31ll_BFu31i)
//============================================================================


struct  S_BFu31ll_BFu31ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 S_BFu31ll_BFu31ll) C1{ Fs FL:31 FL:31}



static void Test_S_BFu31ll_BFu31ll()
{
  {
    init_simple_test("S_BFu31ll_BFu31ll");
    static STRUCT_IF_C S_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, 1, "S_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, hide_ull(1LL<<30), "S_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu31ll, S_BFu31ll_BFu31ll)
//============================================================================


struct  S_BFu31ll_BFu32i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 S_BFu31ll_BFu32i) C1{ Fs FL:31 Fi:32}



static void Test_S_BFu31ll_BFu32i()
{
  {
    init_simple_test("S_BFu31ll_BFu32i");
    static STRUCT_IF_C S_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "S_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "S_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu32i, S_BFu31ll_BFu32i)
//============================================================================


struct  S_BFu31ll_BFu32ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 S_BFu31ll_BFu32ll) C1{ Fs FL:31 FL:32}



static void Test_S_BFu31ll_BFu32ll()
{
  {
    init_simple_test("S_BFu31ll_BFu32ll");
    static STRUCT_IF_C S_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, 1, "S_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, hide_ull(1LL<<31), "S_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu32ll, S_BFu31ll_BFu32ll)
//============================================================================


struct  S_BFu31ll_BFu33  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 S_BFu31ll_BFu33) C1{ Fs FL:31 FL:33}



static void Test_S_BFu31ll_BFu33()
{
  {
    init_simple_test("S_BFu31ll_BFu33");
    static STRUCT_IF_C S_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, 1, "S_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, hide_ull(1LL<<32), "S_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu33, S_BFu31ll_BFu33)
//============================================================================


struct  S_BFu31ll_BFu7c  {
  short v1;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 S_BFu31ll_BFu7c) C1{ Fs FL:31 Fc:7}



static void Test_S_BFu31ll_BFu7c()
{
  {
    init_simple_test("S_BFu31ll_BFu7c");
    static STRUCT_IF_C S_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "S_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "S_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu7c, S_BFu31ll_BFu7c)
//============================================================================


struct  S_BFu31ll_BFu7i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 S_BFu31ll_BFu7i) C1{ Fs FL:31 Fi:7}



static void Test_S_BFu31ll_BFu7i()
{
  {
    init_simple_test("S_BFu31ll_BFu7i");
    static STRUCT_IF_C S_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "S_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "S_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu7i, S_BFu31ll_BFu7i)
//============================================================================


struct  S_BFu31ll_BFu7ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 S_BFu31ll_BFu7ll) C1{ Fs FL:31 FL:7}



static void Test_S_BFu31ll_BFu7ll()
{
  {
    init_simple_test("S_BFu31ll_BFu7ll");
    static STRUCT_IF_C S_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "S_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "S_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu7ll, S_BFu31ll_BFu7ll)
//============================================================================


struct  S_BFu31ll_BFu7s  {
  short v1;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 S_BFu31ll_BFu7s) C1{ Fs FL:31 Fs:7}



static void Test_S_BFu31ll_BFu7s()
{
  {
    init_simple_test("S_BFu31ll_BFu7s");
    static STRUCT_IF_C S_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "S_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "S_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu7s, S_BFu31ll_BFu7s)
//============================================================================


struct  S_BFu31ll_BFu8c  {
  short v1;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 S_BFu31ll_BFu8c) C1{ Fs FL:31 Fc:8}



static void Test_S_BFu31ll_BFu8c()
{
  {
    init_simple_test("S_BFu31ll_BFu8c");
    static STRUCT_IF_C S_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "S_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "S_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu8c, S_BFu31ll_BFu8c)
//============================================================================


struct  S_BFu31ll_BFu8i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 S_BFu31ll_BFu8i) C1{ Fs FL:31 Fi:8}



static void Test_S_BFu31ll_BFu8i()
{
  {
    init_simple_test("S_BFu31ll_BFu8i");
    static STRUCT_IF_C S_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "S_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "S_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu8i, S_BFu31ll_BFu8i)
//============================================================================


struct  S_BFu31ll_BFu8ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 S_BFu31ll_BFu8ll) C1{ Fs FL:31 FL:8}



static void Test_S_BFu31ll_BFu8ll()
{
  {
    init_simple_test("S_BFu31ll_BFu8ll");
    static STRUCT_IF_C S_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "S_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "S_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu8ll, S_BFu31ll_BFu8ll)
//============================================================================


struct  S_BFu31ll_BFu8s  {
  short v1;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 S_BFu31ll_BFu8s) C1{ Fs FL:31 Fs:8}



static void Test_S_BFu31ll_BFu8s()
{
  {
    init_simple_test("S_BFu31ll_BFu8s");
    static STRUCT_IF_C S_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "S_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "S_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu8s, S_BFu31ll_BFu8s)
//============================================================================


struct  S_BFu31ll_BFu9i  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 S_BFu31ll_BFu9i) C1{ Fs FL:31 Fi:9}



static void Test_S_BFu31ll_BFu9i()
{
  {
    init_simple_test("S_BFu31ll_BFu9i");
    static STRUCT_IF_C S_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "S_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "S_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu9i, S_BFu31ll_BFu9i)
//============================================================================


struct  S_BFu31ll_BFu9ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 S_BFu31ll_BFu9ll) C1{ Fs FL:31 FL:9}



static void Test_S_BFu31ll_BFu9ll()
{
  {
    init_simple_test("S_BFu31ll_BFu9ll");
    static STRUCT_IF_C S_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "S_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "S_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu9ll, S_BFu31ll_BFu9ll)
//============================================================================


struct  S_BFu31ll_BFu9s  {
  short v1;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 S_BFu31ll_BFu9s) C1{ Fs FL:31 Fs:9}



static void Test_S_BFu31ll_BFu9s()
{
  {
    init_simple_test("S_BFu31ll_BFu9s");
    static STRUCT_IF_C S_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "S_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "S_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_BFu9s, S_BFu31ll_BFu9s)
//============================================================================


struct  S_BFu31ll_C  {
  short v1;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 S_BFu31ll_C) C1{ Fs FL:31 Fc}



static void Test_S_BFu31ll_C()
{
  {
    init_simple_test("S_BFu31ll_C");
    static STRUCT_IF_C S_BFu31ll_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_C");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_C");
    check_field_offset(lv, v3, 6, "S_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_C, S_BFu31ll_C)
//============================================================================


struct  S_BFu31ll_D  {
  short v1;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 S_BFu31ll_D) C1{ Fs FL:31 FL}



static void Test_S_BFu31ll_D()
{
  {
    init_simple_test("S_BFu31ll_D");
    static STRUCT_IF_C S_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_D");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_D");
    check_field_offset(lv, v3, 8, "S_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_D, S_BFu31ll_D)
//============================================================================


struct  S_BFu31ll_F  {
  short v1;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 S_BFu31ll_F) C1{ Fs FL:31 Fi}



static void Test_S_BFu31ll_F()
{
  {
    init_simple_test("S_BFu31ll_F");
    static STRUCT_IF_C S_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_F");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_F");
    check_field_offset(lv, v3, 8, "S_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_F, S_BFu31ll_F)
//============================================================================


struct  S_BFu31ll_I  {
  short v1;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 S_BFu31ll_I) C1{ Fs FL:31 Fi}



static void Test_S_BFu31ll_I()
{
  {
    init_simple_test("S_BFu31ll_I");
    static STRUCT_IF_C S_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_I");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_I");
    check_field_offset(lv, v3, 8, "S_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_I, S_BFu31ll_I)
//============================================================================


struct  S_BFu31ll_Ip  {
  short v1;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 S_BFu31ll_Ip) C1{ Fs FL:31 Fp}



static void Test_S_BFu31ll_Ip()
{
  {
    init_simple_test("S_BFu31ll_Ip");
    static STRUCT_IF_C S_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "S_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_Ip, S_BFu31ll_Ip)
//============================================================================


struct  S_BFu31ll_L  {
  short v1;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 S_BFu31ll_L) C1{ Fs FL:31 FL}



static void Test_S_BFu31ll_L()
{
  {
    init_simple_test("S_BFu31ll_L");
    static STRUCT_IF_C S_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_L");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_L");
    check_field_offset(lv, v3, 8, "S_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_L, S_BFu31ll_L)
//============================================================================


struct  S_BFu31ll_S  {
  short v1;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 S_BFu31ll_S) C1{ Fs FL:31 Fs}



static void Test_S_BFu31ll_S()
{
  {
    init_simple_test("S_BFu31ll_S");
    static STRUCT_IF_C S_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_S");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_S");
    check_field_offset(lv, v3, 6, "S_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_S, S_BFu31ll_S)
//============================================================================


struct  S_BFu31ll_Uc  {
  short v1;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 S_BFu31ll_Uc) C1{ Fs FL:31 Fc}



static void Test_S_BFu31ll_Uc()
{
  {
    init_simple_test("S_BFu31ll_Uc");
    static STRUCT_IF_C S_BFu31ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_Uc");
    check_field_offset(lv, v3, 6, "S_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_Uc, S_BFu31ll_Uc)
//============================================================================


struct  S_BFu31ll_Ui  {
  short v1;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 S_BFu31ll_Ui) C1{ Fs FL:31 Fi}



static void Test_S_BFu31ll_Ui()
{
  {
    init_simple_test("S_BFu31ll_Ui");
    static STRUCT_IF_C S_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "S_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_Ui, S_BFu31ll_Ui)
//============================================================================


struct  S_BFu31ll_Ul  {
  short v1;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 S_BFu31ll_Ul) C1{ Fs FL:31 FL}



static void Test_S_BFu31ll_Ul()
{
  {
    init_simple_test("S_BFu31ll_Ul");
    static STRUCT_IF_C S_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "S_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_Ul, S_BFu31ll_Ul)
//============================================================================


struct  S_BFu31ll_Us  {
  short v1;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 S_BFu31ll_Us) C1{ Fs FL:31 Fs}



static void Test_S_BFu31ll_Us()
{
  {
    init_simple_test("S_BFu31ll_Us");
    static STRUCT_IF_C S_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_Us");
    check_field_offset(lv, v3, 6, "S_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_Us, S_BFu31ll_Us)
//============================================================================


struct  S_BFu31ll_Vp  {
  short v1;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 S_BFu31ll_Vp) C1{ Fs FL:31 Fp}



static void Test_S_BFu31ll_Vp()
{
  {
    init_simple_test("S_BFu31ll_Vp");
    static STRUCT_IF_C S_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "S_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu31ll_Vp, S_BFu31ll_Vp)
//============================================================================


struct  S_BFu32i  {
  short v1;
  unsigned int v2:32;
};
//SIG(1 S_BFu32i) C1{ Fs Fi:32}



static void Test_S_BFu32i()
{
  {
    init_simple_test("S_BFu32i");
    static STRUCT_IF_C S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i, S_BFu32i)
//============================================================================


struct  S_BFu32i_BFu15i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 S_BFu32i_BFu15i) C1{ Fs Fi:32 Fi:15}



static void Test_S_BFu32i_BFu15i()
{
  {
    init_simple_test("S_BFu32i_BFu15i");
    static STRUCT_IF_C S_BFu32i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "S_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "S_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu15i, S_BFu32i_BFu15i)
//============================================================================


struct  S_BFu32i_BFu15ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 S_BFu32i_BFu15ll) C1{ Fs Fi:32 FL:15}



static void Test_S_BFu32i_BFu15ll()
{
  {
    init_simple_test("S_BFu32i_BFu15ll");
    static STRUCT_IF_C S_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "S_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "S_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu15ll, S_BFu32i_BFu15ll)
//============================================================================


struct  S_BFu32i_BFu15s  {
  short v1;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 S_BFu32i_BFu15s) C1{ Fs Fi:32 Fs:15}



static void Test_S_BFu32i_BFu15s()
{
  {
    init_simple_test("S_BFu32i_BFu15s");
    static STRUCT_IF_C S_BFu32i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "S_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "S_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu15s, S_BFu32i_BFu15s)
//============================================================================


struct  S_BFu32i_BFu16i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 S_BFu32i_BFu16i) C1{ Fs Fi:32 Fi:16}



static void Test_S_BFu32i_BFu16i()
{
  {
    init_simple_test("S_BFu32i_BFu16i");
    static STRUCT_IF_C S_BFu32i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu16i, S_BFu32i_BFu16i)
//============================================================================


struct  S_BFu32i_BFu16ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 S_BFu32i_BFu16ll) C1{ Fs Fi:32 FL:16}



static void Test_S_BFu32i_BFu16ll()
{
  {
    init_simple_test("S_BFu32i_BFu16ll");
    static STRUCT_IF_C S_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu16ll, S_BFu32i_BFu16ll)
//============================================================================


struct  S_BFu32i_BFu16s  {
  short v1;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 S_BFu32i_BFu16s) C1{ Fs Fi:32 Fs:16}



static void Test_S_BFu32i_BFu16s()
{
  {
    init_simple_test("S_BFu32i_BFu16s");
    static STRUCT_IF_C S_BFu32i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu16s, S_BFu32i_BFu16s)
//============================================================================


struct  S_BFu32i_BFu17i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 S_BFu32i_BFu17i) C1{ Fs Fi:32 Fi:17}



static void Test_S_BFu32i_BFu17i()
{
  {
    init_simple_test("S_BFu32i_BFu17i");
    static STRUCT_IF_C S_BFu32i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "S_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "S_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu17i, S_BFu32i_BFu17i)
//============================================================================


struct  S_BFu32i_BFu17ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 S_BFu32i_BFu17ll) C1{ Fs Fi:32 FL:17}



static void Test_S_BFu32i_BFu17ll()
{
  {
    init_simple_test("S_BFu32i_BFu17ll");
    static STRUCT_IF_C S_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "S_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "S_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu17ll, S_BFu32i_BFu17ll)
//============================================================================


struct  S_BFu32i_BFu1c  {
  short v1;
  unsigned int v2:32;
  unsigned char v3:1;
};
//SIG(1 S_BFu32i_BFu1c) C1{ Fs Fi:32 Fc:1}



static void Test_S_BFu32i_BFu1c()
{
  {
    init_simple_test("S_BFu32i_BFu1c");
    static STRUCT_IF_C S_BFu32i_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "S_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu1c, S_BFu32i_BFu1c)
//============================================================================


struct  S_BFu32i_BFu1i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:1;
};
//SIG(1 S_BFu32i_BFu1i) C1{ Fs Fi:32 Fi:1}



static void Test_S_BFu32i_BFu1i()
{
  {
    init_simple_test("S_BFu32i_BFu1i");
    static STRUCT_IF_C S_BFu32i_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "S_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu1i, S_BFu32i_BFu1i)
//============================================================================


struct  S_BFu32i_BFu1ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:1;
};
//SIG(1 S_BFu32i_BFu1ll) C1{ Fs Fi:32 FL:1}



static void Test_S_BFu32i_BFu1ll()
{
  {
    init_simple_test("S_BFu32i_BFu1ll");
    static STRUCT_IF_C S_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "S_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu1ll, S_BFu32i_BFu1ll)
//============================================================================


struct  S_BFu32i_BFu1s  {
  short v1;
  unsigned int v2:32;
  unsigned short v3:1;
};
//SIG(1 S_BFu32i_BFu1s) C1{ Fs Fi:32 Fs:1}



static void Test_S_BFu32i_BFu1s()
{
  {
    init_simple_test("S_BFu32i_BFu1s");
    static STRUCT_IF_C S_BFu32i_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "S_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu1s, S_BFu32i_BFu1s)
//============================================================================


struct  S_BFu32i_BFu31i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:31;
};
//SIG(1 S_BFu32i_BFu31i) C1{ Fs Fi:32 Fi:31}



static void Test_S_BFu32i_BFu31i()
{
  {
    init_simple_test("S_BFu32i_BFu31i");
    static STRUCT_IF_C S_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "S_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "S_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu31i, S_BFu32i_BFu31i)
//============================================================================


struct  S_BFu32i_BFu31ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:31;
};
//SIG(1 S_BFu32i_BFu31ll) C1{ Fs Fi:32 FL:31}



static void Test_S_BFu32i_BFu31ll()
{
  {
    init_simple_test("S_BFu32i_BFu31ll");
    static STRUCT_IF_C S_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "S_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "S_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu31ll, S_BFu32i_BFu31ll)
//============================================================================


struct  S_BFu32i_BFu32i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:32;
};
//SIG(1 S_BFu32i_BFu32i) C1{ Fs Fi:32 Fi:32}



static void Test_S_BFu32i_BFu32i()
{
  {
    init_simple_test("S_BFu32i_BFu32i");
    static STRUCT_IF_C S_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "S_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu32i, S_BFu32i_BFu32i)
//============================================================================


struct  S_BFu32i_BFu32ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:32;
};
//SIG(1 S_BFu32i_BFu32ll) C1{ Fs Fi:32 FL:32}



static void Test_S_BFu32i_BFu32ll()
{
  {
    init_simple_test("S_BFu32i_BFu32ll");
    static STRUCT_IF_C S_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "S_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu32ll, S_BFu32i_BFu32ll)
//============================================================================


struct  S_BFu32i_BFu33  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:33;
};
//SIG(1 S_BFu32i_BFu33) C1{ Fs Fi:32 FL:33}



static void Test_S_BFu32i_BFu33()
{
  {
    init_simple_test("S_BFu32i_BFu33");
    static STRUCT_IF_C S_BFu32i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "S_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "S_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu33, S_BFu32i_BFu33)
//============================================================================


struct  S_BFu32i_BFu7c  {
  short v1;
  unsigned int v2:32;
  unsigned char v3:7;
};
//SIG(1 S_BFu32i_BFu7c) C1{ Fs Fi:32 Fc:7}



static void Test_S_BFu32i_BFu7c()
{
  {
    init_simple_test("S_BFu32i_BFu7c");
    static STRUCT_IF_C S_BFu32i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "S_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "S_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu7c, S_BFu32i_BFu7c)
//============================================================================


struct  S_BFu32i_BFu7i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:7;
};
//SIG(1 S_BFu32i_BFu7i) C1{ Fs Fi:32 Fi:7}



static void Test_S_BFu32i_BFu7i()
{
  {
    init_simple_test("S_BFu32i_BFu7i");
    static STRUCT_IF_C S_BFu32i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "S_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "S_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu7i, S_BFu32i_BFu7i)
//============================================================================


struct  S_BFu32i_BFu7ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:7;
};
//SIG(1 S_BFu32i_BFu7ll) C1{ Fs Fi:32 FL:7}



static void Test_S_BFu32i_BFu7ll()
{
  {
    init_simple_test("S_BFu32i_BFu7ll");
    static STRUCT_IF_C S_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "S_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "S_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu7ll, S_BFu32i_BFu7ll)
//============================================================================


struct  S_BFu32i_BFu7s  {
  short v1;
  unsigned int v2:32;
  unsigned short v3:7;
};
//SIG(1 S_BFu32i_BFu7s) C1{ Fs Fi:32 Fs:7}



static void Test_S_BFu32i_BFu7s()
{
  {
    init_simple_test("S_BFu32i_BFu7s");
    static STRUCT_IF_C S_BFu32i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "S_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "S_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu7s, S_BFu32i_BFu7s)
//============================================================================


struct  S_BFu32i_BFu8c  {
  short v1;
  unsigned int v2:32;
  unsigned char v3:8;
};
//SIG(1 S_BFu32i_BFu8c) C1{ Fs Fi:32 Fc:8}



static void Test_S_BFu32i_BFu8c()
{
  {
    init_simple_test("S_BFu32i_BFu8c");
    static STRUCT_IF_C S_BFu32i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "S_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "S_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu8c, S_BFu32i_BFu8c)
//============================================================================


struct  S_BFu32i_BFu8i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:8;
};
//SIG(1 S_BFu32i_BFu8i) C1{ Fs Fi:32 Fi:8}



static void Test_S_BFu32i_BFu8i()
{
  {
    init_simple_test("S_BFu32i_BFu8i");
    static STRUCT_IF_C S_BFu32i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "S_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "S_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu8i, S_BFu32i_BFu8i)
//============================================================================


struct  S_BFu32i_BFu8ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:8;
};
//SIG(1 S_BFu32i_BFu8ll) C1{ Fs Fi:32 FL:8}



static void Test_S_BFu32i_BFu8ll()
{
  {
    init_simple_test("S_BFu32i_BFu8ll");
    static STRUCT_IF_C S_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "S_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "S_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu8ll, S_BFu32i_BFu8ll)
//============================================================================


struct  S_BFu32i_BFu8s  {
  short v1;
  unsigned int v2:32;
  unsigned short v3:8;
};
//SIG(1 S_BFu32i_BFu8s) C1{ Fs Fi:32 Fs:8}



static void Test_S_BFu32i_BFu8s()
{
  {
    init_simple_test("S_BFu32i_BFu8s");
    static STRUCT_IF_C S_BFu32i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "S_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "S_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu8s, S_BFu32i_BFu8s)
//============================================================================


struct  S_BFu32i_BFu9i  {
  short v1;
  unsigned int v2:32;
  unsigned int v3:9;
};
//SIG(1 S_BFu32i_BFu9i) C1{ Fs Fi:32 Fi:9}



static void Test_S_BFu32i_BFu9i()
{
  {
    init_simple_test("S_BFu32i_BFu9i");
    static STRUCT_IF_C S_BFu32i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "S_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "S_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu9i, S_BFu32i_BFu9i)
//============================================================================


struct  S_BFu32i_BFu9ll  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3:9;
};
//SIG(1 S_BFu32i_BFu9ll) C1{ Fs Fi:32 FL:9}



static void Test_S_BFu32i_BFu9ll()
{
  {
    init_simple_test("S_BFu32i_BFu9ll");
    static STRUCT_IF_C S_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "S_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "S_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu9ll, S_BFu32i_BFu9ll)
//============================================================================


struct  S_BFu32i_BFu9s  {
  short v1;
  unsigned int v2:32;
  unsigned short v3:9;
};
//SIG(1 S_BFu32i_BFu9s) C1{ Fs Fi:32 Fs:9}



static void Test_S_BFu32i_BFu9s()
{
  {
    init_simple_test("S_BFu32i_BFu9s");
    static STRUCT_IF_C S_BFu32i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "S_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "S_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_BFu9s, S_BFu32i_BFu9s)
//============================================================================


struct  S_BFu32i_C  {
  short v1;
  unsigned int v2:32;
  char v3;
};
//SIG(1 S_BFu32i_C) C1{ Fs Fi:32 Fc}



static void Test_S_BFu32i_C()
{
  {
    init_simple_test("S_BFu32i_C");
    static STRUCT_IF_C S_BFu32i_C lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_C)");
    check_field_offset(lv, v1, 0, "S_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_C");
    check_field_offset(lv, v3, 8, "S_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_C, S_BFu32i_C)
//============================================================================


struct  S_BFu32i_D  {
  short v1;
  unsigned int v2:32;
  double v3;
};
//SIG(1 S_BFu32i_D) C1{ Fs Fi:32 FL}



static void Test_S_BFu32i_D()
{
  {
    init_simple_test("S_BFu32i_D");
    static STRUCT_IF_C S_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_D)");
    check_field_offset(lv, v1, 0, "S_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_D");
    check_field_offset(lv, v3, 8, "S_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_D, S_BFu32i_D)
//============================================================================


struct  S_BFu32i_F  {
  short v1;
  unsigned int v2:32;
  float v3;
};
//SIG(1 S_BFu32i_F) C1{ Fs Fi:32 Fi}



static void Test_S_BFu32i_F()
{
  {
    init_simple_test("S_BFu32i_F");
    static STRUCT_IF_C S_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_F)");
    check_field_offset(lv, v1, 0, "S_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_F");
    check_field_offset(lv, v3, 8, "S_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_F, S_BFu32i_F)
//============================================================================


struct  S_BFu32i_I  {
  short v1;
  unsigned int v2:32;
  int v3;
};
//SIG(1 S_BFu32i_I) C1{ Fs Fi:32 Fi}



static void Test_S_BFu32i_I()
{
  {
    init_simple_test("S_BFu32i_I");
    static STRUCT_IF_C S_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_I)");
    check_field_offset(lv, v1, 0, "S_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_I");
    check_field_offset(lv, v3, 8, "S_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_I, S_BFu32i_I)
//============================================================================


struct  S_BFu32i_Ip  {
  short v1;
  unsigned int v2:32;
  int *v3;
};
//SIG(1 S_BFu32i_Ip) C1{ Fs Fi:32 Fp}



static void Test_S_BFu32i_Ip()
{
  {
    init_simple_test("S_BFu32i_Ip");
    static STRUCT_IF_C S_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "S_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_Ip, S_BFu32i_Ip)
//============================================================================


struct  S_BFu32i_L  {
  short v1;
  unsigned int v2:32;
  __tsi64 v3;
};
//SIG(1 S_BFu32i_L) C1{ Fs Fi:32 FL}



static void Test_S_BFu32i_L()
{
  {
    init_simple_test("S_BFu32i_L");
    static STRUCT_IF_C S_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_L)");
    check_field_offset(lv, v1, 0, "S_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_L");
    check_field_offset(lv, v3, 8, "S_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_L, S_BFu32i_L)
//============================================================================


struct  S_BFu32i_S  {
  short v1;
  unsigned int v2:32;
  short v3;
};
//SIG(1 S_BFu32i_S) C1{ Fs Fi:32 Fs}



static void Test_S_BFu32i_S()
{
  {
    init_simple_test("S_BFu32i_S");
    static STRUCT_IF_C S_BFu32i_S lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_S)");
    check_field_offset(lv, v1, 0, "S_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_S");
    check_field_offset(lv, v3, 8, "S_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_S, S_BFu32i_S)
//============================================================================


struct  S_BFu32i_Uc  {
  short v1;
  unsigned int v2:32;
  unsigned char v3;
};
//SIG(1 S_BFu32i_Uc) C1{ Fs Fi:32 Fc}



static void Test_S_BFu32i_Uc()
{
  {
    init_simple_test("S_BFu32i_Uc");
    static STRUCT_IF_C S_BFu32i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "S_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_Uc, S_BFu32i_Uc)
//============================================================================


struct  S_BFu32i_Ui  {
  short v1;
  unsigned int v2:32;
  unsigned int v3;
};
//SIG(1 S_BFu32i_Ui) C1{ Fs Fi:32 Fi}



static void Test_S_BFu32i_Ui()
{
  {
    init_simple_test("S_BFu32i_Ui");
    static STRUCT_IF_C S_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "S_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_Ui, S_BFu32i_Ui)
//============================================================================


struct  S_BFu32i_Ul  {
  short v1;
  unsigned int v2:32;
  __tsu64 v3;
};
//SIG(1 S_BFu32i_Ul) C1{ Fs Fi:32 FL}



static void Test_S_BFu32i_Ul()
{
  {
    init_simple_test("S_BFu32i_Ul");
    static STRUCT_IF_C S_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "S_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_Ul, S_BFu32i_Ul)
//============================================================================


struct  S_BFu32i_Us  {
  short v1;
  unsigned int v2:32;
  unsigned short v3;
};
//SIG(1 S_BFu32i_Us) C1{ Fs Fi:32 Fs}



static void Test_S_BFu32i_Us()
{
  {
    init_simple_test("S_BFu32i_Us");
    static STRUCT_IF_C S_BFu32i_Us lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu32i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_Us");
    check_field_offset(lv, v3, 8, "S_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_Us, S_BFu32i_Us)
//============================================================================


struct  S_BFu32i_Vp  {
  short v1;
  unsigned int v2:32;
  void *v3;
};
//SIG(1 S_BFu32i_Vp) C1{ Fs Fi:32 Fp}



static void Test_S_BFu32i_Vp()
{
  {
    init_simple_test("S_BFu32i_Vp");
    static STRUCT_IF_C S_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "S_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32i_Vp, S_BFu32i_Vp)
//============================================================================


struct  S_BFu32ll  {
  short v1;
  __tsu64 v2:32;
};
//SIG(1 S_BFu32ll) C1{ Fs FL:32}



static void Test_S_BFu32ll()
{
  {
    init_simple_test("S_BFu32ll");
    static STRUCT_IF_C S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll, S_BFu32ll)
//============================================================================


struct  S_BFu32ll_BFu15i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:15;
};
//SIG(1 S_BFu32ll_BFu15i) C1{ Fs FL:32 Fi:15}



static void Test_S_BFu32ll_BFu15i()
{
  {
    init_simple_test("S_BFu32ll_BFu15i");
    static STRUCT_IF_C S_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "S_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "S_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu15i, S_BFu32ll_BFu15i)
//============================================================================


struct  S_BFu32ll_BFu15ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:15;
};
//SIG(1 S_BFu32ll_BFu15ll) C1{ Fs FL:32 FL:15}



static void Test_S_BFu32ll_BFu15ll()
{
  {
    init_simple_test("S_BFu32ll_BFu15ll");
    static STRUCT_IF_C S_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "S_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "S_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu15ll, S_BFu32ll_BFu15ll)
//============================================================================


struct  S_BFu32ll_BFu15s  {
  short v1;
  __tsu64 v2:32;
  unsigned short v3:15;
};
//SIG(1 S_BFu32ll_BFu15s) C1{ Fs FL:32 Fs:15}



static void Test_S_BFu32ll_BFu15s()
{
  {
    init_simple_test("S_BFu32ll_BFu15s");
    static STRUCT_IF_C S_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "S_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "S_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu15s, S_BFu32ll_BFu15s)
//============================================================================


struct  S_BFu32ll_BFu16i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:16;
};
//SIG(1 S_BFu32ll_BFu16i) C1{ Fs FL:32 Fi:16}



static void Test_S_BFu32ll_BFu16i()
{
  {
    init_simple_test("S_BFu32ll_BFu16i");
    static STRUCT_IF_C S_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "S_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "S_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu16i, S_BFu32ll_BFu16i)
//============================================================================


struct  S_BFu32ll_BFu16ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:16;
};
//SIG(1 S_BFu32ll_BFu16ll) C1{ Fs FL:32 FL:16}



static void Test_S_BFu32ll_BFu16ll()
{
  {
    init_simple_test("S_BFu32ll_BFu16ll");
    static STRUCT_IF_C S_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "S_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "S_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu16ll, S_BFu32ll_BFu16ll)
//============================================================================


struct  S_BFu32ll_BFu16s  {
  short v1;
  __tsu64 v2:32;
  unsigned short v3:16;
};
//SIG(1 S_BFu32ll_BFu16s) C1{ Fs FL:32 Fs:16}



static void Test_S_BFu32ll_BFu16s()
{
  {
    init_simple_test("S_BFu32ll_BFu16s");
    static STRUCT_IF_C S_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "S_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "S_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu16s, S_BFu32ll_BFu16s)
//============================================================================


struct  S_BFu32ll_BFu17i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:17;
};
//SIG(1 S_BFu32ll_BFu17i) C1{ Fs FL:32 Fi:17}



static void Test_S_BFu32ll_BFu17i()
{
  {
    init_simple_test("S_BFu32ll_BFu17i");
    static STRUCT_IF_C S_BFu32ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "S_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "S_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu17i, S_BFu32ll_BFu17i)
//============================================================================


struct  S_BFu32ll_BFu17ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:17;
};
//SIG(1 S_BFu32ll_BFu17ll) C1{ Fs FL:32 FL:17}



static void Test_S_BFu32ll_BFu17ll()
{
  {
    init_simple_test("S_BFu32ll_BFu17ll");
    static STRUCT_IF_C S_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "S_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "S_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu17ll, S_BFu32ll_BFu17ll)
//============================================================================


struct  S_BFu32ll_BFu1c  {
  short v1;
  __tsu64 v2:32;
  unsigned char v3:1;
};
//SIG(1 S_BFu32ll_BFu1c) C1{ Fs FL:32 Fc:1}



static void Test_S_BFu32ll_BFu1c()
{
  {
    init_simple_test("S_BFu32ll_BFu1c");
    static STRUCT_IF_C S_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "S_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu1c, S_BFu32ll_BFu1c)
//============================================================================


struct  S_BFu32ll_BFu1i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:1;
};
//SIG(1 S_BFu32ll_BFu1i) C1{ Fs FL:32 Fi:1}



static void Test_S_BFu32ll_BFu1i()
{
  {
    init_simple_test("S_BFu32ll_BFu1i");
    static STRUCT_IF_C S_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "S_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu1i, S_BFu32ll_BFu1i)
//============================================================================


struct  S_BFu32ll_BFu1ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:1;
};
//SIG(1 S_BFu32ll_BFu1ll) C1{ Fs FL:32 FL:1}



static void Test_S_BFu32ll_BFu1ll()
{
  {
    init_simple_test("S_BFu32ll_BFu1ll");
    static STRUCT_IF_C S_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "S_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu1ll, S_BFu32ll_BFu1ll)
//============================================================================


struct  S_BFu32ll_BFu1s  {
  short v1;
  __tsu64 v2:32;
  unsigned short v3:1;
};
//SIG(1 S_BFu32ll_BFu1s) C1{ Fs FL:32 Fs:1}



static void Test_S_BFu32ll_BFu1s()
{
  {
    init_simple_test("S_BFu32ll_BFu1s");
    static STRUCT_IF_C S_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "S_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu1s, S_BFu32ll_BFu1s)
//============================================================================


struct  S_BFu32ll_BFu31i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:31;
};
//SIG(1 S_BFu32ll_BFu31i) C1{ Fs FL:32 Fi:31}



static void Test_S_BFu32ll_BFu31i()
{
  {
    init_simple_test("S_BFu32ll_BFu31i");
    static STRUCT_IF_C S_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "S_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "S_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu31i, S_BFu32ll_BFu31i)
//============================================================================


struct  S_BFu32ll_BFu31ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:31;
};
//SIG(1 S_BFu32ll_BFu31ll) C1{ Fs FL:32 FL:31}



static void Test_S_BFu32ll_BFu31ll()
{
  {
    init_simple_test("S_BFu32ll_BFu31ll");
    static STRUCT_IF_C S_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "S_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "S_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu31ll, S_BFu32ll_BFu31ll)
//============================================================================


struct  S_BFu32ll_BFu32i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:32;
};
//SIG(1 S_BFu32ll_BFu32i) C1{ Fs FL:32 Fi:32}



static void Test_S_BFu32ll_BFu32i()
{
  {
    init_simple_test("S_BFu32ll_BFu32i");
    static STRUCT_IF_C S_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "S_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu32i, S_BFu32ll_BFu32i)
//============================================================================


struct  S_BFu32ll_BFu32ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:32;
};
//SIG(1 S_BFu32ll_BFu32ll) C1{ Fs FL:32 FL:32}



static void Test_S_BFu32ll_BFu32ll()
{
  {
    init_simple_test("S_BFu32ll_BFu32ll");
    static STRUCT_IF_C S_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "S_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu32ll, S_BFu32ll_BFu32ll)
//============================================================================


struct  S_BFu32ll_BFu33  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:33;
};
//SIG(1 S_BFu32ll_BFu33) C1{ Fs FL:32 FL:33}



static void Test_S_BFu32ll_BFu33()
{
  {
    init_simple_test("S_BFu32ll_BFu33");
    static STRUCT_IF_C S_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "S_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "S_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu33, S_BFu32ll_BFu33)
//============================================================================


struct  S_BFu32ll_BFu7c  {
  short v1;
  __tsu64 v2:32;
  unsigned char v3:7;
};
//SIG(1 S_BFu32ll_BFu7c) C1{ Fs FL:32 Fc:7}



static void Test_S_BFu32ll_BFu7c()
{
  {
    init_simple_test("S_BFu32ll_BFu7c");
    static STRUCT_IF_C S_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "S_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "S_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu7c, S_BFu32ll_BFu7c)
//============================================================================


struct  S_BFu32ll_BFu7i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:7;
};
//SIG(1 S_BFu32ll_BFu7i) C1{ Fs FL:32 Fi:7}



static void Test_S_BFu32ll_BFu7i()
{
  {
    init_simple_test("S_BFu32ll_BFu7i");
    static STRUCT_IF_C S_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "S_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "S_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu7i, S_BFu32ll_BFu7i)
//============================================================================


struct  S_BFu32ll_BFu7ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:7;
};
//SIG(1 S_BFu32ll_BFu7ll) C1{ Fs FL:32 FL:7}



static void Test_S_BFu32ll_BFu7ll()
{
  {
    init_simple_test("S_BFu32ll_BFu7ll");
    static STRUCT_IF_C S_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "S_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "S_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu7ll, S_BFu32ll_BFu7ll)
//============================================================================


struct  S_BFu32ll_BFu7s  {
  short v1;
  __tsu64 v2:32;
  unsigned short v3:7;
};
//SIG(1 S_BFu32ll_BFu7s) C1{ Fs FL:32 Fs:7}



static void Test_S_BFu32ll_BFu7s()
{
  {
    init_simple_test("S_BFu32ll_BFu7s");
    static STRUCT_IF_C S_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "S_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "S_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu7s, S_BFu32ll_BFu7s)
//============================================================================


struct  S_BFu32ll_BFu8c  {
  short v1;
  __tsu64 v2:32;
  unsigned char v3:8;
};
//SIG(1 S_BFu32ll_BFu8c) C1{ Fs FL:32 Fc:8}



static void Test_S_BFu32ll_BFu8c()
{
  {
    init_simple_test("S_BFu32ll_BFu8c");
    static STRUCT_IF_C S_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "S_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "S_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu8c, S_BFu32ll_BFu8c)
//============================================================================


struct  S_BFu32ll_BFu8i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:8;
};
//SIG(1 S_BFu32ll_BFu8i) C1{ Fs FL:32 Fi:8}



static void Test_S_BFu32ll_BFu8i()
{
  {
    init_simple_test("S_BFu32ll_BFu8i");
    static STRUCT_IF_C S_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "S_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "S_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu8i, S_BFu32ll_BFu8i)
//============================================================================


struct  S_BFu32ll_BFu8ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:8;
};
//SIG(1 S_BFu32ll_BFu8ll) C1{ Fs FL:32 FL:8}



static void Test_S_BFu32ll_BFu8ll()
{
  {
    init_simple_test("S_BFu32ll_BFu8ll");
    static STRUCT_IF_C S_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "S_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "S_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu8ll, S_BFu32ll_BFu8ll)
//============================================================================


struct  S_BFu32ll_BFu8s  {
  short v1;
  __tsu64 v2:32;
  unsigned short v3:8;
};
//SIG(1 S_BFu32ll_BFu8s) C1{ Fs FL:32 Fs:8}



static void Test_S_BFu32ll_BFu8s()
{
  {
    init_simple_test("S_BFu32ll_BFu8s");
    static STRUCT_IF_C S_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "S_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "S_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu8s, S_BFu32ll_BFu8s)
//============================================================================


struct  S_BFu32ll_BFu9i  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3:9;
};
//SIG(1 S_BFu32ll_BFu9i) C1{ Fs FL:32 Fi:9}



static void Test_S_BFu32ll_BFu9i()
{
  {
    init_simple_test("S_BFu32ll_BFu9i");
    static STRUCT_IF_C S_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "S_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "S_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu9i, S_BFu32ll_BFu9i)
//============================================================================


struct  S_BFu32ll_BFu9ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3:9;
};
//SIG(1 S_BFu32ll_BFu9ll) C1{ Fs FL:32 FL:9}



static void Test_S_BFu32ll_BFu9ll()
{
  {
    init_simple_test("S_BFu32ll_BFu9ll");
    static STRUCT_IF_C S_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "S_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "S_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu9ll, S_BFu32ll_BFu9ll)
//============================================================================


struct  S_BFu32ll_BFu9s  {
  short v1;
  __tsu64 v2:32;
  unsigned short v3:9;
};
//SIG(1 S_BFu32ll_BFu9s) C1{ Fs FL:32 Fs:9}



static void Test_S_BFu32ll_BFu9s()
{
  {
    init_simple_test("S_BFu32ll_BFu9s");
    static STRUCT_IF_C S_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "S_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "S_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_BFu9s, S_BFu32ll_BFu9s)
//============================================================================


struct  S_BFu32ll_C  {
  short v1;
  __tsu64 v2:32;
  char v3;
};
//SIG(1 S_BFu32ll_C) C1{ Fs FL:32 Fc}



static void Test_S_BFu32ll_C()
{
  {
    init_simple_test("S_BFu32ll_C");
    static STRUCT_IF_C S_BFu32ll_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_C");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_C");
    check_field_offset(lv, v3, 6, "S_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_C, S_BFu32ll_C)
//============================================================================


struct  S_BFu32ll_D  {
  short v1;
  __tsu64 v2:32;
  double v3;
};
//SIG(1 S_BFu32ll_D) C1{ Fs FL:32 FL}



static void Test_S_BFu32ll_D()
{
  {
    init_simple_test("S_BFu32ll_D");
    static STRUCT_IF_C S_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_D");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_D");
    check_field_offset(lv, v3, 8, "S_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_D, S_BFu32ll_D)
//============================================================================


struct  S_BFu32ll_F  {
  short v1;
  __tsu64 v2:32;
  float v3;
};
//SIG(1 S_BFu32ll_F) C1{ Fs FL:32 Fi}



static void Test_S_BFu32ll_F()
{
  {
    init_simple_test("S_BFu32ll_F");
    static STRUCT_IF_C S_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_F");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_F");
    check_field_offset(lv, v3, 8, "S_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_F, S_BFu32ll_F)
//============================================================================


struct  S_BFu32ll_I  {
  short v1;
  __tsu64 v2:32;
  int v3;
};
//SIG(1 S_BFu32ll_I) C1{ Fs FL:32 Fi}



static void Test_S_BFu32ll_I()
{
  {
    init_simple_test("S_BFu32ll_I");
    static STRUCT_IF_C S_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_I");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_I");
    check_field_offset(lv, v3, 8, "S_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_I, S_BFu32ll_I)
//============================================================================


struct  S_BFu32ll_Ip  {
  short v1;
  __tsu64 v2:32;
  int *v3;
};
//SIG(1 S_BFu32ll_Ip) C1{ Fs FL:32 Fp}



static void Test_S_BFu32ll_Ip()
{
  {
    init_simple_test("S_BFu32ll_Ip");
    static STRUCT_IF_C S_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "S_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_Ip, S_BFu32ll_Ip)
//============================================================================


struct  S_BFu32ll_L  {
  short v1;
  __tsu64 v2:32;
  __tsi64 v3;
};
//SIG(1 S_BFu32ll_L) C1{ Fs FL:32 FL}



static void Test_S_BFu32ll_L()
{
  {
    init_simple_test("S_BFu32ll_L");
    static STRUCT_IF_C S_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_L");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_L");
    check_field_offset(lv, v3, 8, "S_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_L, S_BFu32ll_L)
//============================================================================


struct  S_BFu32ll_S  {
  short v1;
  __tsu64 v2:32;
  short v3;
};
//SIG(1 S_BFu32ll_S) C1{ Fs FL:32 Fs}



static void Test_S_BFu32ll_S()
{
  {
    init_simple_test("S_BFu32ll_S");
    static STRUCT_IF_C S_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_S");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_S");
    check_field_offset(lv, v3, 6, "S_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_S, S_BFu32ll_S)
//============================================================================


struct  S_BFu32ll_Uc  {
  short v1;
  __tsu64 v2:32;
  unsigned char v3;
};
//SIG(1 S_BFu32ll_Uc) C1{ Fs FL:32 Fc}



static void Test_S_BFu32ll_Uc()
{
  {
    init_simple_test("S_BFu32ll_Uc");
    static STRUCT_IF_C S_BFu32ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_Uc");
    check_field_offset(lv, v3, 6, "S_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_Uc, S_BFu32ll_Uc)
//============================================================================


struct  S_BFu32ll_Ui  {
  short v1;
  __tsu64 v2:32;
  unsigned int v3;
};
//SIG(1 S_BFu32ll_Ui) C1{ Fs FL:32 Fi}



static void Test_S_BFu32ll_Ui()
{
  {
    init_simple_test("S_BFu32ll_Ui");
    static STRUCT_IF_C S_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "S_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_Ui, S_BFu32ll_Ui)
//============================================================================


struct  S_BFu32ll_Ul  {
  short v1;
  __tsu64 v2:32;
  __tsu64 v3;
};
//SIG(1 S_BFu32ll_Ul) C1{ Fs FL:32 FL}



static void Test_S_BFu32ll_Ul()
{
  {
    init_simple_test("S_BFu32ll_Ul");
    static STRUCT_IF_C S_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "S_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_Ul, S_BFu32ll_Ul)
//============================================================================


struct  S_BFu32ll_Us  {
  short v1;
  __tsu64 v2:32;
  unsigned short v3;
};
//SIG(1 S_BFu32ll_Us) C1{ Fs FL:32 Fs}



static void Test_S_BFu32ll_Us()
{
  {
    init_simple_test("S_BFu32ll_Us");
    static STRUCT_IF_C S_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_Us");
    check_field_offset(lv, v3, 6, "S_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_Us, S_BFu32ll_Us)
//============================================================================


struct  S_BFu32ll_Vp  {
  short v1;
  __tsu64 v2:32;
  void *v3;
};
//SIG(1 S_BFu32ll_Vp) C1{ Fs FL:32 Fp}



static void Test_S_BFu32ll_Vp()
{
  {
    init_simple_test("S_BFu32ll_Vp");
    static STRUCT_IF_C S_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "S_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu32ll_Vp, S_BFu32ll_Vp)
//============================================================================


struct  S_BFu33  {
  short v1;
  __tsu64 v2:33;
};
//SIG(1 S_BFu33) C1{ Fs FL:33}



static void Test_S_BFu33()
{
  {
    init_simple_test("S_BFu33");
    static STRUCT_IF_C S_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33, S_BFu33)
//============================================================================


struct  S_BFu33_BFu15i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:15;
};
//SIG(1 S_BFu33_BFu15i) C1{ Fs FL:33 Fi:15}



static void Test_S_BFu33_BFu15i()
{
  {
    init_simple_test("S_BFu33_BFu15i");
    static STRUCT_IF_C S_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "S_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "S_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu15i, S_BFu33_BFu15i)
//============================================================================


struct  S_BFu33_BFu15ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:15;
};
//SIG(1 S_BFu33_BFu15ll) C1{ Fs FL:33 FL:15}



static void Test_S_BFu33_BFu15ll()
{
  {
    init_simple_test("S_BFu33_BFu15ll");
    static STRUCT_IF_C S_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "S_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "S_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu15ll, S_BFu33_BFu15ll)
//============================================================================


struct  S_BFu33_BFu15s  {
  short v1;
  __tsu64 v2:33;
  unsigned short v3:15;
};
//SIG(1 S_BFu33_BFu15s) C1{ Fs FL:33 Fs:15}



static void Test_S_BFu33_BFu15s()
{
  {
    init_simple_test("S_BFu33_BFu15s");
    static STRUCT_IF_C S_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "S_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "S_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu15s, S_BFu33_BFu15s)
//============================================================================


struct  S_BFu33_BFu16i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:16;
};
//SIG(1 S_BFu33_BFu16i) C1{ Fs FL:33 Fi:16}



static void Test_S_BFu33_BFu16i()
{
  {
    init_simple_test("S_BFu33_BFu16i");
    static STRUCT_IF_C S_BFu33_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu16i, S_BFu33_BFu16i)
//============================================================================


struct  S_BFu33_BFu16ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:16;
};
//SIG(1 S_BFu33_BFu16ll) C1{ Fs FL:33 FL:16}



static void Test_S_BFu33_BFu16ll()
{
  {
    init_simple_test("S_BFu33_BFu16ll");
    static STRUCT_IF_C S_BFu33_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, 1, "S_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, hide_ull(1LL<<15), "S_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu16ll, S_BFu33_BFu16ll)
//============================================================================


struct  S_BFu33_BFu16s  {
  short v1;
  __tsu64 v2:33;
  unsigned short v3:16;
};
//SIG(1 S_BFu33_BFu16s) C1{ Fs FL:33 Fs:16}



static void Test_S_BFu33_BFu16s()
{
  {
    init_simple_test("S_BFu33_BFu16s");
    static STRUCT_IF_C S_BFu33_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "S_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "S_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu16s, S_BFu33_BFu16s)
//============================================================================


struct  S_BFu33_BFu17i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:17;
};
//SIG(1 S_BFu33_BFu17i) C1{ Fs FL:33 Fi:17}



static void Test_S_BFu33_BFu17i()
{
  {
    init_simple_test("S_BFu33_BFu17i");
    static STRUCT_IF_C S_BFu33_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "S_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "S_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu17i, S_BFu33_BFu17i)
//============================================================================


struct  S_BFu33_BFu17ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:17;
};
//SIG(1 S_BFu33_BFu17ll) C1{ Fs FL:33 FL:17}



static void Test_S_BFu33_BFu17ll()
{
  {
    init_simple_test("S_BFu33_BFu17ll");
    static STRUCT_IF_C S_BFu33_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, 1, "S_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, hide_ull(1LL<<16), "S_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu17ll, S_BFu33_BFu17ll)
//============================================================================


struct  S_BFu33_BFu1c  {
  short v1;
  __tsu64 v2:33;
  unsigned char v3:1;
};
//SIG(1 S_BFu33_BFu1c) C1{ Fs FL:33 Fc:1}



static void Test_S_BFu33_BFu1c()
{
  {
    init_simple_test("S_BFu33_BFu1c");
    static STRUCT_IF_C S_BFu33_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "S_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu1c, S_BFu33_BFu1c)
//============================================================================


struct  S_BFu33_BFu1i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:1;
};
//SIG(1 S_BFu33_BFu1i) C1{ Fs FL:33 Fi:1}



static void Test_S_BFu33_BFu1i()
{
  {
    init_simple_test("S_BFu33_BFu1i");
    static STRUCT_IF_C S_BFu33_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "S_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu1i, S_BFu33_BFu1i)
//============================================================================


struct  S_BFu33_BFu1ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:1;
};
//SIG(1 S_BFu33_BFu1ll) C1{ Fs FL:33 FL:1}



static void Test_S_BFu33_BFu1ll()
{
  {
    init_simple_test("S_BFu33_BFu1ll");
    static STRUCT_IF_C S_BFu33_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "S_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu1ll, S_BFu33_BFu1ll)
//============================================================================


struct  S_BFu33_BFu1s  {
  short v1;
  __tsu64 v2:33;
  unsigned short v3:1;
};
//SIG(1 S_BFu33_BFu1s) C1{ Fs FL:33 Fs:1}



static void Test_S_BFu33_BFu1s()
{
  {
    init_simple_test("S_BFu33_BFu1s");
    static STRUCT_IF_C S_BFu33_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "S_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu1s, S_BFu33_BFu1s)
//============================================================================


struct  S_BFu33_BFu31i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 S_BFu33_BFu31i) C1{ Fs FL:33 Fi:31}



static void Test_S_BFu33_BFu31i()
{
  {
    init_simple_test("S_BFu33_BFu31i");
    static STRUCT_IF_C S_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "S_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "S_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu31i, S_BFu33_BFu31i)
//============================================================================


struct  S_BFu33_BFu31ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 S_BFu33_BFu31ll) C1{ Fs FL:33 FL:31}



static void Test_S_BFu33_BFu31ll()
{
  {
    init_simple_test("S_BFu33_BFu31ll");
    static STRUCT_IF_C S_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, 1, "S_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, hide_ull(1LL<<30), "S_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu31ll, S_BFu33_BFu31ll)
//============================================================================


struct  S_BFu33_BFu32i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 S_BFu33_BFu32i) C1{ Fs FL:33 Fi:32}



static void Test_S_BFu33_BFu32i()
{
  {
    init_simple_test("S_BFu33_BFu32i");
    static STRUCT_IF_C S_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "S_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "S_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu32i, S_BFu33_BFu32i)
//============================================================================


struct  S_BFu33_BFu32ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 S_BFu33_BFu32ll) C1{ Fs FL:33 FL:32}



static void Test_S_BFu33_BFu32ll()
{
  {
    init_simple_test("S_BFu33_BFu32ll");
    static STRUCT_IF_C S_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, 1, "S_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, hide_ull(1LL<<31), "S_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu32ll, S_BFu33_BFu32ll)
//============================================================================


struct  S_BFu33_BFu33  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 S_BFu33_BFu33) C1{ Fs FL:33 FL:33}



static void Test_S_BFu33_BFu33()
{
  {
    init_simple_test("S_BFu33_BFu33");
    static STRUCT_IF_C S_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, 1, "S_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, hide_ull(1LL<<32), "S_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu33, S_BFu33_BFu33)
//============================================================================


struct  S_BFu33_BFu7c  {
  short v1;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 S_BFu33_BFu7c) C1{ Fs FL:33 Fc:7}



static void Test_S_BFu33_BFu7c()
{
  {
    init_simple_test("S_BFu33_BFu7c");
    static STRUCT_IF_C S_BFu33_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "S_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "S_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu7c, S_BFu33_BFu7c)
//============================================================================


struct  S_BFu33_BFu7i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 S_BFu33_BFu7i) C1{ Fs FL:33 Fi:7}



static void Test_S_BFu33_BFu7i()
{
  {
    init_simple_test("S_BFu33_BFu7i");
    static STRUCT_IF_C S_BFu33_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "S_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "S_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu7i, S_BFu33_BFu7i)
//============================================================================


struct  S_BFu33_BFu7ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 S_BFu33_BFu7ll) C1{ Fs FL:33 FL:7}



static void Test_S_BFu33_BFu7ll()
{
  {
    init_simple_test("S_BFu33_BFu7ll");
    static STRUCT_IF_C S_BFu33_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "S_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "S_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu7ll, S_BFu33_BFu7ll)
//============================================================================


struct  S_BFu33_BFu7s  {
  short v1;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 S_BFu33_BFu7s) C1{ Fs FL:33 Fs:7}



static void Test_S_BFu33_BFu7s()
{
  {
    init_simple_test("S_BFu33_BFu7s");
    static STRUCT_IF_C S_BFu33_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "S_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "S_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu7s, S_BFu33_BFu7s)
//============================================================================


struct  S_BFu33_BFu8c  {
  short v1;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 S_BFu33_BFu8c) C1{ Fs FL:33 Fc:8}



static void Test_S_BFu33_BFu8c()
{
  {
    init_simple_test("S_BFu33_BFu8c");
    static STRUCT_IF_C S_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, 1, "S_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, hide_ull(1LL<<7), "S_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu8c, S_BFu33_BFu8c)
//============================================================================


struct  S_BFu33_BFu8i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 S_BFu33_BFu8i) C1{ Fs FL:33 Fi:8}



static void Test_S_BFu33_BFu8i()
{
  {
    init_simple_test("S_BFu33_BFu8i");
    static STRUCT_IF_C S_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "S_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "S_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu8i, S_BFu33_BFu8i)
//============================================================================


struct  S_BFu33_BFu8ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 S_BFu33_BFu8ll) C1{ Fs FL:33 FL:8}



static void Test_S_BFu33_BFu8ll()
{
  {
    init_simple_test("S_BFu33_BFu8ll");
    static STRUCT_IF_C S_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "S_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "S_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu8ll, S_BFu33_BFu8ll)
//============================================================================


struct  S_BFu33_BFu8s  {
  short v1;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 S_BFu33_BFu8s) C1{ Fs FL:33 Fs:8}



static void Test_S_BFu33_BFu8s()
{
  {
    init_simple_test("S_BFu33_BFu8s");
    static STRUCT_IF_C S_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "S_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "S_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu8s, S_BFu33_BFu8s)
//============================================================================


struct  S_BFu33_BFu9i  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 S_BFu33_BFu9i) C1{ Fs FL:33 Fi:9}



static void Test_S_BFu33_BFu9i()
{
  {
    init_simple_test("S_BFu33_BFu9i");
    static STRUCT_IF_C S_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "S_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "S_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu9i, S_BFu33_BFu9i)
//============================================================================


struct  S_BFu33_BFu9ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 S_BFu33_BFu9ll) C1{ Fs FL:33 FL:9}



static void Test_S_BFu33_BFu9ll()
{
  {
    init_simple_test("S_BFu33_BFu9ll");
    static STRUCT_IF_C S_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "S_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "S_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu9ll, S_BFu33_BFu9ll)
//============================================================================


struct  S_BFu33_BFu9s  {
  short v1;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 S_BFu33_BFu9s) C1{ Fs FL:33 Fs:9}



static void Test_S_BFu33_BFu9s()
{
  {
    init_simple_test("S_BFu33_BFu9s");
    static STRUCT_IF_C S_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "S_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "S_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_BFu9s, S_BFu33_BFu9s)
//============================================================================


struct  S_BFu33_C  {
  short v1;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 S_BFu33_C) C1{ Fs FL:33 Fc}



static void Test_S_BFu33_C()
{
  {
    init_simple_test("S_BFu33_C");
    static STRUCT_IF_C S_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_C)");
    check_field_offset(lv, v1, 0, "S_BFu33_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_C");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_C");
    check_field_offset(lv, v3, 7, "S_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_C, S_BFu33_C)
//============================================================================


struct  S_BFu33_D  {
  short v1;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 S_BFu33_D) C1{ Fs FL:33 FL}



static void Test_S_BFu33_D()
{
  {
    init_simple_test("S_BFu33_D");
    static STRUCT_IF_C S_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_D)");
    check_field_offset(lv, v1, 0, "S_BFu33_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_D");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_D");
    check_field_offset(lv, v3, 8, "S_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_D, S_BFu33_D)
//============================================================================


struct  S_BFu33_F  {
  short v1;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 S_BFu33_F) C1{ Fs FL:33 Fi}



static void Test_S_BFu33_F()
{
  {
    init_simple_test("S_BFu33_F");
    static STRUCT_IF_C S_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_F)");
    check_field_offset(lv, v1, 0, "S_BFu33_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_F");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_F");
    check_field_offset(lv, v3, 8, "S_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_F, S_BFu33_F)
//============================================================================


struct  S_BFu33_I  {
  short v1;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 S_BFu33_I) C1{ Fs FL:33 Fi}



static void Test_S_BFu33_I()
{
  {
    init_simple_test("S_BFu33_I");
    static STRUCT_IF_C S_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_I)");
    check_field_offset(lv, v1, 0, "S_BFu33_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_I");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_I");
    check_field_offset(lv, v3, 8, "S_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_I, S_BFu33_I)
//============================================================================


struct  S_BFu33_Ip  {
  short v1;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 S_BFu33_Ip) C1{ Fs FL:33 Fp}



static void Test_S_BFu33_Ip()
{
  {
    init_simple_test("S_BFu33_Ip");
    static STRUCT_IF_C S_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_Ip");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_Ip");
    check_field_offset(lv, v3, 8, "S_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_Ip, S_BFu33_Ip)
//============================================================================


struct  S_BFu33_L  {
  short v1;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 S_BFu33_L) C1{ Fs FL:33 FL}



static void Test_S_BFu33_L()
{
  {
    init_simple_test("S_BFu33_L");
    static STRUCT_IF_C S_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_L)");
    check_field_offset(lv, v1, 0, "S_BFu33_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_L");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_L");
    check_field_offset(lv, v3, 8, "S_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_L, S_BFu33_L)
//============================================================================


struct  S_BFu33_S  {
  short v1;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 S_BFu33_S) C1{ Fs FL:33 Fs}



static void Test_S_BFu33_S()
{
  {
    init_simple_test("S_BFu33_S");
    static STRUCT_IF_C S_BFu33_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_S)");
    check_field_offset(lv, v1, 0, "S_BFu33_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_S");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_S");
    check_field_offset(lv, v3, 8, "S_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_S, S_BFu33_S)
//============================================================================


struct  S_BFu33_Uc  {
  short v1;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 S_BFu33_Uc) C1{ Fs FL:33 Fc}



static void Test_S_BFu33_Uc()
{
  {
    init_simple_test("S_BFu33_Uc");
    static STRUCT_IF_C S_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_Uc");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_Uc");
    check_field_offset(lv, v3, 7, "S_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_Uc, S_BFu33_Uc)
//============================================================================


struct  S_BFu33_Ui  {
  short v1;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 S_BFu33_Ui) C1{ Fs FL:33 Fi}



static void Test_S_BFu33_Ui()
{
  {
    init_simple_test("S_BFu33_Ui");
    static STRUCT_IF_C S_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_Ui");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_Ui");
    check_field_offset(lv, v3, 8, "S_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_Ui, S_BFu33_Ui)
//============================================================================


struct  S_BFu33_Ul  {
  short v1;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 S_BFu33_Ul) C1{ Fs FL:33 FL}



static void Test_S_BFu33_Ul()
{
  {
    init_simple_test("S_BFu33_Ul");
    static STRUCT_IF_C S_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(S_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_Ul");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_Ul");
    check_field_offset(lv, v3, 8, "S_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_Ul, S_BFu33_Ul)
//============================================================================


struct  S_BFu33_Us  {
  short v1;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 S_BFu33_Us) C1{ Fs FL:33 Fs}



static void Test_S_BFu33_Us()
{
  {
    init_simple_test("S_BFu33_Us");
    static STRUCT_IF_C S_BFu33_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_Us)");
    check_field_offset(lv, v1, 0, "S_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_Us");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_Us");
    check_field_offset(lv, v3, 8, "S_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_Us, S_BFu33_Us)
//============================================================================


struct  S_BFu33_Vp  {
  short v1;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 S_BFu33_Vp) C1{ Fs FL:33 Fp}



static void Test_S_BFu33_Vp()
{
  {
    init_simple_test("S_BFu33_Vp");
    static STRUCT_IF_C S_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_Vp");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_Vp");
    check_field_offset(lv, v3, 8, "S_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu33_Vp, S_BFu33_Vp)
//============================================================================


struct  S_BFu7c  {
  short v1;
  unsigned char v2:7;
};
//SIG(1 S_BFu7c) C1{ Fs Fc:7}



static void Test_S_BFu7c()
{
  {
    init_simple_test("S_BFu7c");
    static STRUCT_IF_C S_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c, S_BFu7c)
//============================================================================


struct  S_BFu7c_BFu15i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 S_BFu7c_BFu15i) C1{ Fs Fc:7 Fi:15}



static void Test_S_BFu7c_BFu15i()
{
  {
    init_simple_test("S_BFu7c_BFu15i");
    static STRUCT_IF_C S_BFu7c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu15i, S_BFu7c_BFu15i)
//============================================================================


struct  S_BFu7c_BFu15ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 S_BFu7c_BFu15ll) C1{ Fs Fc:7 FL:15}



static void Test_S_BFu7c_BFu15ll()
{
  {
    init_simple_test("S_BFu7c_BFu15ll");
    static STRUCT_IF_C S_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "S_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "S_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu15ll, S_BFu7c_BFu15ll)
//============================================================================


struct  S_BFu7c_BFu15s  {
  short v1;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 S_BFu7c_BFu15s) C1{ Fs Fc:7 Fs:15}



static void Test_S_BFu7c_BFu15s()
{
  {
    init_simple_test("S_BFu7c_BFu15s");
    static STRUCT_IF_C S_BFu7c_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu7c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu15s, S_BFu7c_BFu15s)
//============================================================================


struct  S_BFu7c_BFu16i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 S_BFu7c_BFu16i) C1{ Fs Fc:7 Fi:16}



static void Test_S_BFu7c_BFu16i()
{
  {
    init_simple_test("S_BFu7c_BFu16i");
    static STRUCT_IF_C S_BFu7c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu16i, S_BFu7c_BFu16i)
//============================================================================


struct  S_BFu7c_BFu16ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 S_BFu7c_BFu16ll) C1{ Fs Fc:7 FL:16}



static void Test_S_BFu7c_BFu16ll()
{
  {
    init_simple_test("S_BFu7c_BFu16ll");
    static STRUCT_IF_C S_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "S_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "S_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu16ll, S_BFu7c_BFu16ll)
//============================================================================


struct  S_BFu7c_BFu16s  {
  short v1;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 S_BFu7c_BFu16s) C1{ Fs Fc:7 Fs:16}



static void Test_S_BFu7c_BFu16s()
{
  {
    init_simple_test("S_BFu7c_BFu16s");
    static STRUCT_IF_C S_BFu7c_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu7c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu16s, S_BFu7c_BFu16s)
//============================================================================


struct  S_BFu7c_BFu17i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 S_BFu7c_BFu17i) C1{ Fs Fc:7 Fi:17}



static void Test_S_BFu7c_BFu17i()
{
  {
    init_simple_test("S_BFu7c_BFu17i");
    static STRUCT_IF_C S_BFu7c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu17i, S_BFu7c_BFu17i)
//============================================================================


struct  S_BFu7c_BFu17ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 S_BFu7c_BFu17ll) C1{ Fs Fc:7 FL:17}



static void Test_S_BFu7c_BFu17ll()
{
  {
    init_simple_test("S_BFu7c_BFu17ll");
    static STRUCT_IF_C S_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "S_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "S_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu17ll, S_BFu7c_BFu17ll)
//============================================================================


struct  S_BFu7c_BFu1c  {
  short v1;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 S_BFu7c_BFu1c) C1{ Fs Fc:7 Fc:1}



static void Test_S_BFu7c_BFu1c()
{
  {
    init_simple_test("S_BFu7c_BFu1c");
    static STRUCT_IF_C S_BFu7c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu1c, S_BFu7c_BFu1c)
//============================================================================


struct  S_BFu7c_BFu1i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 S_BFu7c_BFu1i) C1{ Fs Fc:7 Fi:1}



static void Test_S_BFu7c_BFu1i()
{
  {
    init_simple_test("S_BFu7c_BFu1i");
    static STRUCT_IF_C S_BFu7c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu1i, S_BFu7c_BFu1i)
//============================================================================


struct  S_BFu7c_BFu1ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 S_BFu7c_BFu1ll) C1{ Fs Fc:7 FL:1}



static void Test_S_BFu7c_BFu1ll()
{
  {
    init_simple_test("S_BFu7c_BFu1ll");
    static STRUCT_IF_C S_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu1ll, S_BFu7c_BFu1ll)
//============================================================================


struct  S_BFu7c_BFu1s  {
  short v1;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 S_BFu7c_BFu1s) C1{ Fs Fc:7 Fs:1}



static void Test_S_BFu7c_BFu1s()
{
  {
    init_simple_test("S_BFu7c_BFu1s");
    static STRUCT_IF_C S_BFu7c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu1s, S_BFu7c_BFu1s)
//============================================================================


struct  S_BFu7c_BFu31i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 S_BFu7c_BFu31i) C1{ Fs Fc:7 Fi:31}



static void Test_S_BFu7c_BFu31i()
{
  {
    init_simple_test("S_BFu7c_BFu31i");
    static STRUCT_IF_C S_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu31i, S_BFu7c_BFu31i)
//============================================================================


struct  S_BFu7c_BFu31ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 S_BFu7c_BFu31ll) C1{ Fs Fc:7 FL:31}



static void Test_S_BFu7c_BFu31ll()
{
  {
    init_simple_test("S_BFu7c_BFu31ll");
    static STRUCT_IF_C S_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "S_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "S_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu31ll, S_BFu7c_BFu31ll)
//============================================================================


struct  S_BFu7c_BFu32i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 S_BFu7c_BFu32i) C1{ Fs Fc:7 Fi:32}



static void Test_S_BFu7c_BFu32i()
{
  {
    init_simple_test("S_BFu7c_BFu32i");
    static STRUCT_IF_C S_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu32i, S_BFu7c_BFu32i)
//============================================================================


struct  S_BFu7c_BFu32ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 S_BFu7c_BFu32ll) C1{ Fs Fc:7 FL:32}



static void Test_S_BFu7c_BFu32ll()
{
  {
    init_simple_test("S_BFu7c_BFu32ll");
    static STRUCT_IF_C S_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "S_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "S_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu32ll, S_BFu7c_BFu32ll)
//============================================================================


struct  S_BFu7c_BFu33  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 S_BFu7c_BFu33) C1{ Fs Fc:7 FL:33}



static void Test_S_BFu7c_BFu33()
{
  {
    init_simple_test("S_BFu7c_BFu33");
    static STRUCT_IF_C S_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "S_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "S_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu33, S_BFu7c_BFu33)
//============================================================================


struct  S_BFu7c_BFu7c  {
  short v1;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 S_BFu7c_BFu7c) C1{ Fs Fc:7 Fc:7}



static void Test_S_BFu7c_BFu7c()
{
  {
    init_simple_test("S_BFu7c_BFu7c");
    static STRUCT_IF_C S_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu7c, S_BFu7c_BFu7c)
//============================================================================


struct  S_BFu7c_BFu7i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 S_BFu7c_BFu7i) C1{ Fs Fc:7 Fi:7}



static void Test_S_BFu7c_BFu7i()
{
  {
    init_simple_test("S_BFu7c_BFu7i");
    static STRUCT_IF_C S_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu7i, S_BFu7c_BFu7i)
//============================================================================


struct  S_BFu7c_BFu7ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 S_BFu7c_BFu7ll) C1{ Fs Fc:7 FL:7}



static void Test_S_BFu7c_BFu7ll()
{
  {
    init_simple_test("S_BFu7c_BFu7ll");
    static STRUCT_IF_C S_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu7ll, S_BFu7c_BFu7ll)
//============================================================================


struct  S_BFu7c_BFu7s  {
  short v1;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 S_BFu7c_BFu7s) C1{ Fs Fc:7 Fs:7}



static void Test_S_BFu7c_BFu7s()
{
  {
    init_simple_test("S_BFu7c_BFu7s");
    static STRUCT_IF_C S_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu7s, S_BFu7c_BFu7s)
//============================================================================


struct  S_BFu7c_BFu8c  {
  short v1;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 S_BFu7c_BFu8c) C1{ Fs Fc:7 Fc:8}



static void Test_S_BFu7c_BFu8c()
{
  {
    init_simple_test("S_BFu7c_BFu8c");
    static STRUCT_IF_C S_BFu7c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu8c, S_BFu7c_BFu8c)
//============================================================================


struct  S_BFu7c_BFu8i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 S_BFu7c_BFu8i) C1{ Fs Fc:7 Fi:8}



static void Test_S_BFu7c_BFu8i()
{
  {
    init_simple_test("S_BFu7c_BFu8i");
    static STRUCT_IF_C S_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu8i, S_BFu7c_BFu8i)
//============================================================================


struct  S_BFu7c_BFu8ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 S_BFu7c_BFu8ll) C1{ Fs Fc:7 FL:8}



static void Test_S_BFu7c_BFu8ll()
{
  {
    init_simple_test("S_BFu7c_BFu8ll");
    static STRUCT_IF_C S_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu8ll, S_BFu7c_BFu8ll)
//============================================================================


struct  S_BFu7c_BFu8s  {
  short v1;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 S_BFu7c_BFu8s) C1{ Fs Fc:7 Fs:8}



static void Test_S_BFu7c_BFu8s()
{
  {
    init_simple_test("S_BFu7c_BFu8s");
    static STRUCT_IF_C S_BFu7c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu8s, S_BFu7c_BFu8s)
//============================================================================


struct  S_BFu7c_BFu9i  {
  short v1;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 S_BFu7c_BFu9i) C1{ Fs Fc:7 Fi:9}



static void Test_S_BFu7c_BFu9i()
{
  {
    init_simple_test("S_BFu7c_BFu9i");
    static STRUCT_IF_C S_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu9i, S_BFu7c_BFu9i)
//============================================================================


struct  S_BFu7c_BFu9ll  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 S_BFu7c_BFu9ll) C1{ Fs Fc:7 FL:9}



static void Test_S_BFu7c_BFu9ll()
{
  {
    init_simple_test("S_BFu7c_BFu9ll");
    static STRUCT_IF_C S_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu9ll, S_BFu7c_BFu9ll)
//============================================================================


struct  S_BFu7c_BFu9s  {
  short v1;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 S_BFu7c_BFu9s) C1{ Fs Fc:7 Fs:9}



static void Test_S_BFu7c_BFu9s()
{
  {
    init_simple_test("S_BFu7c_BFu9s");
    static STRUCT_IF_C S_BFu7c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_BFu9s, S_BFu7c_BFu9s)
//============================================================================


struct  S_BFu7c_C  {
  short v1;
  unsigned char v2:7;
  char v3;
};
//SIG(1 S_BFu7c_C) C1{ Fs Fc:7 Fc}



static void Test_S_BFu7c_C()
{
  {
    init_simple_test("S_BFu7c_C");
    static STRUCT_IF_C S_BFu7c_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_C)");
    check_field_offset(lv, v1, 0, "S_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_C");
    check_field_offset(lv, v3, 3, "S_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_C, S_BFu7c_C)
//============================================================================


struct  S_BFu7c_D  {
  short v1;
  unsigned char v2:7;
  double v3;
};
//SIG(1 S_BFu7c_D) C1{ Fs Fc:7 FL}



static void Test_S_BFu7c_D()
{
  {
    init_simple_test("S_BFu7c_D");
    static STRUCT_IF_C S_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_D)");
    check_field_offset(lv, v1, 0, "S_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_D, S_BFu7c_D)
//============================================================================


struct  S_BFu7c_F  {
  short v1;
  unsigned char v2:7;
  float v3;
};
//SIG(1 S_BFu7c_F) C1{ Fs Fc:7 Fi}



static void Test_S_BFu7c_F()
{
  {
    init_simple_test("S_BFu7c_F");
    static STRUCT_IF_C S_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_F)");
    check_field_offset(lv, v1, 0, "S_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_F");
    check_field_offset(lv, v3, 4, "S_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_F, S_BFu7c_F)
//============================================================================


struct  S_BFu7c_I  {
  short v1;
  unsigned char v2:7;
  int v3;
};
//SIG(1 S_BFu7c_I) C1{ Fs Fc:7 Fi}



static void Test_S_BFu7c_I()
{
  {
    init_simple_test("S_BFu7c_I");
    static STRUCT_IF_C S_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_I)");
    check_field_offset(lv, v1, 0, "S_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_I");
    check_field_offset(lv, v3, 4, "S_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_I, S_BFu7c_I)
//============================================================================


struct  S_BFu7c_Ip  {
  short v1;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 S_BFu7c_Ip) C1{ Fs Fc:7 Fp}



static void Test_S_BFu7c_Ip()
{
  {
    init_simple_test("S_BFu7c_Ip");
    static STRUCT_IF_C S_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_Ip, S_BFu7c_Ip)
//============================================================================


struct  S_BFu7c_L  {
  short v1;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 S_BFu7c_L) C1{ Fs Fc:7 FL}



static void Test_S_BFu7c_L()
{
  {
    init_simple_test("S_BFu7c_L");
    static STRUCT_IF_C S_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_L)");
    check_field_offset(lv, v1, 0, "S_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_L, S_BFu7c_L)
//============================================================================


struct  S_BFu7c_S  {
  short v1;
  unsigned char v2:7;
  short v3;
};
//SIG(1 S_BFu7c_S) C1{ Fs Fc:7 Fs}



static void Test_S_BFu7c_S()
{
  {
    init_simple_test("S_BFu7c_S");
    static STRUCT_IF_C S_BFu7c_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu7c_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_S)");
    check_field_offset(lv, v1, 0, "S_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_S");
    check_field_offset(lv, v3, 4, "S_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_S, S_BFu7c_S)
//============================================================================


struct  S_BFu7c_Uc  {
  short v1;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 S_BFu7c_Uc) C1{ Fs Fc:7 Fc}



static void Test_S_BFu7c_Uc()
{
  {
    init_simple_test("S_BFu7c_Uc");
    static STRUCT_IF_C S_BFu7c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_Uc");
    check_field_offset(lv, v3, 3, "S_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_Uc, S_BFu7c_Uc)
//============================================================================


struct  S_BFu7c_Ui  {
  short v1;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 S_BFu7c_Ui) C1{ Fs Fc:7 Fi}



static void Test_S_BFu7c_Ui()
{
  {
    init_simple_test("S_BFu7c_Ui");
    static STRUCT_IF_C S_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_Ui");
    check_field_offset(lv, v3, 4, "S_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_Ui, S_BFu7c_Ui)
//============================================================================


struct  S_BFu7c_Ul  {
  short v1;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 S_BFu7c_Ul) C1{ Fs Fc:7 FL}



static void Test_S_BFu7c_Ul()
{
  {
    init_simple_test("S_BFu7c_Ul");
    static STRUCT_IF_C S_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_Ul, S_BFu7c_Ul)
//============================================================================


struct  S_BFu7c_Us  {
  short v1;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 S_BFu7c_Us) C1{ Fs Fc:7 Fs}



static void Test_S_BFu7c_Us()
{
  {
    init_simple_test("S_BFu7c_Us");
    static STRUCT_IF_C S_BFu7c_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu7c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "S_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_Us");
    check_field_offset(lv, v3, 4, "S_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_Us, S_BFu7c_Us)
//============================================================================


struct  S_BFu7c_Vp  {
  short v1;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 S_BFu7c_Vp) C1{ Fs Fc:7 Fp}



static void Test_S_BFu7c_Vp()
{
  {
    init_simple_test("S_BFu7c_Vp");
    static STRUCT_IF_C S_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7c_Vp, S_BFu7c_Vp)
//============================================================================


struct  S_BFu7i  {
  short v1;
  unsigned int v2:7;
};
//SIG(1 S_BFu7i) C1{ Fs Fi:7}



static void Test_S_BFu7i()
{
  {
    init_simple_test("S_BFu7i");
    static STRUCT_IF_C S_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i, S_BFu7i)
//============================================================================


struct  S_BFu7i_BFu15i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 S_BFu7i_BFu15i) C1{ Fs Fi:7 Fi:15}



static void Test_S_BFu7i_BFu15i()
{
  {
    init_simple_test("S_BFu7i_BFu15i");
    static STRUCT_IF_C S_BFu7i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu15i, S_BFu7i_BFu15i)
//============================================================================


struct  S_BFu7i_BFu15ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 S_BFu7i_BFu15ll) C1{ Fs Fi:7 FL:15}



static void Test_S_BFu7i_BFu15ll()
{
  {
    init_simple_test("S_BFu7i_BFu15ll");
    static STRUCT_IF_C S_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "S_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "S_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu15ll, S_BFu7i_BFu15ll)
//============================================================================


struct  S_BFu7i_BFu15s  {
  short v1;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 S_BFu7i_BFu15s) C1{ Fs Fi:7 Fs:15}



static void Test_S_BFu7i_BFu15s()
{
  {
    init_simple_test("S_BFu7i_BFu15s");
    static STRUCT_IF_C S_BFu7i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu15s, S_BFu7i_BFu15s)
//============================================================================


struct  S_BFu7i_BFu16i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 S_BFu7i_BFu16i) C1{ Fs Fi:7 Fi:16}



static void Test_S_BFu7i_BFu16i()
{
  {
    init_simple_test("S_BFu7i_BFu16i");
    static STRUCT_IF_C S_BFu7i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu16i, S_BFu7i_BFu16i)
//============================================================================


struct  S_BFu7i_BFu16ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 S_BFu7i_BFu16ll) C1{ Fs Fi:7 FL:16}



static void Test_S_BFu7i_BFu16ll()
{
  {
    init_simple_test("S_BFu7i_BFu16ll");
    static STRUCT_IF_C S_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "S_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "S_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu16ll, S_BFu7i_BFu16ll)
//============================================================================


struct  S_BFu7i_BFu16s  {
  short v1;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 S_BFu7i_BFu16s) C1{ Fs Fi:7 Fs:16}



static void Test_S_BFu7i_BFu16s()
{
  {
    init_simple_test("S_BFu7i_BFu16s");
    static STRUCT_IF_C S_BFu7i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu16s, S_BFu7i_BFu16s)
//============================================================================


struct  S_BFu7i_BFu17i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 S_BFu7i_BFu17i) C1{ Fs Fi:7 Fi:17}



static void Test_S_BFu7i_BFu17i()
{
  {
    init_simple_test("S_BFu7i_BFu17i");
    static STRUCT_IF_C S_BFu7i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu17i, S_BFu7i_BFu17i)
//============================================================================


struct  S_BFu7i_BFu17ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 S_BFu7i_BFu17ll) C1{ Fs Fi:7 FL:17}



static void Test_S_BFu7i_BFu17ll()
{
  {
    init_simple_test("S_BFu7i_BFu17ll");
    static STRUCT_IF_C S_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "S_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "S_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu17ll, S_BFu7i_BFu17ll)
//============================================================================


struct  S_BFu7i_BFu1c  {
  short v1;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 S_BFu7i_BFu1c) C1{ Fs Fi:7 Fc:1}



static void Test_S_BFu7i_BFu1c()
{
  {
    init_simple_test("S_BFu7i_BFu1c");
    static STRUCT_IF_C S_BFu7i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu1c, S_BFu7i_BFu1c)
//============================================================================


struct  S_BFu7i_BFu1i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 S_BFu7i_BFu1i) C1{ Fs Fi:7 Fi:1}



static void Test_S_BFu7i_BFu1i()
{
  {
    init_simple_test("S_BFu7i_BFu1i");
    static STRUCT_IF_C S_BFu7i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu1i, S_BFu7i_BFu1i)
//============================================================================


struct  S_BFu7i_BFu1ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 S_BFu7i_BFu1ll) C1{ Fs Fi:7 FL:1}



static void Test_S_BFu7i_BFu1ll()
{
  {
    init_simple_test("S_BFu7i_BFu1ll");
    static STRUCT_IF_C S_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu1ll, S_BFu7i_BFu1ll)
//============================================================================


struct  S_BFu7i_BFu1s  {
  short v1;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 S_BFu7i_BFu1s) C1{ Fs Fi:7 Fs:1}



static void Test_S_BFu7i_BFu1s()
{
  {
    init_simple_test("S_BFu7i_BFu1s");
    static STRUCT_IF_C S_BFu7i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu1s, S_BFu7i_BFu1s)
//============================================================================


struct  S_BFu7i_BFu31i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 S_BFu7i_BFu31i) C1{ Fs Fi:7 Fi:31}



static void Test_S_BFu7i_BFu31i()
{
  {
    init_simple_test("S_BFu7i_BFu31i");
    static STRUCT_IF_C S_BFu7i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu31i, S_BFu7i_BFu31i)
//============================================================================


struct  S_BFu7i_BFu31ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 S_BFu7i_BFu31ll) C1{ Fs Fi:7 FL:31}



static void Test_S_BFu7i_BFu31ll()
{
  {
    init_simple_test("S_BFu7i_BFu31ll");
    static STRUCT_IF_C S_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "S_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "S_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu31ll, S_BFu7i_BFu31ll)
//============================================================================


struct  S_BFu7i_BFu32i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 S_BFu7i_BFu32i) C1{ Fs Fi:7 Fi:32}



static void Test_S_BFu7i_BFu32i()
{
  {
    init_simple_test("S_BFu7i_BFu32i");
    static STRUCT_IF_C S_BFu7i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu32i, S_BFu7i_BFu32i)
//============================================================================


struct  S_BFu7i_BFu32ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 S_BFu7i_BFu32ll) C1{ Fs Fi:7 FL:32}



static void Test_S_BFu7i_BFu32ll()
{
  {
    init_simple_test("S_BFu7i_BFu32ll");
    static STRUCT_IF_C S_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "S_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "S_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu32ll, S_BFu7i_BFu32ll)
//============================================================================


struct  S_BFu7i_BFu33  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 S_BFu7i_BFu33) C1{ Fs Fi:7 FL:33}



static void Test_S_BFu7i_BFu33()
{
  {
    init_simple_test("S_BFu7i_BFu33");
    static STRUCT_IF_C S_BFu7i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "S_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "S_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu33, S_BFu7i_BFu33)
//============================================================================


struct  S_BFu7i_BFu7c  {
  short v1;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 S_BFu7i_BFu7c) C1{ Fs Fi:7 Fc:7}



static void Test_S_BFu7i_BFu7c()
{
  {
    init_simple_test("S_BFu7i_BFu7c");
    static STRUCT_IF_C S_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu7c, S_BFu7i_BFu7c)
//============================================================================


struct  S_BFu7i_BFu7i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 S_BFu7i_BFu7i) C1{ Fs Fi:7 Fi:7}



static void Test_S_BFu7i_BFu7i()
{
  {
    init_simple_test("S_BFu7i_BFu7i");
    static STRUCT_IF_C S_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu7i, S_BFu7i_BFu7i)
//============================================================================


struct  S_BFu7i_BFu7ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 S_BFu7i_BFu7ll) C1{ Fs Fi:7 FL:7}



static void Test_S_BFu7i_BFu7ll()
{
  {
    init_simple_test("S_BFu7i_BFu7ll");
    static STRUCT_IF_C S_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu7ll, S_BFu7i_BFu7ll)
//============================================================================


struct  S_BFu7i_BFu7s  {
  short v1;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 S_BFu7i_BFu7s) C1{ Fs Fi:7 Fs:7}



static void Test_S_BFu7i_BFu7s()
{
  {
    init_simple_test("S_BFu7i_BFu7s");
    static STRUCT_IF_C S_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu7s, S_BFu7i_BFu7s)
//============================================================================


struct  S_BFu7i_BFu8c  {
  short v1;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 S_BFu7i_BFu8c) C1{ Fs Fi:7 Fc:8}



static void Test_S_BFu7i_BFu8c()
{
  {
    init_simple_test("S_BFu7i_BFu8c");
    static STRUCT_IF_C S_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu8c, S_BFu7i_BFu8c)
//============================================================================


struct  S_BFu7i_BFu8i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 S_BFu7i_BFu8i) C1{ Fs Fi:7 Fi:8}



static void Test_S_BFu7i_BFu8i()
{
  {
    init_simple_test("S_BFu7i_BFu8i");
    static STRUCT_IF_C S_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu8i, S_BFu7i_BFu8i)
//============================================================================


struct  S_BFu7i_BFu8ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 S_BFu7i_BFu8ll) C1{ Fs Fi:7 FL:8}



static void Test_S_BFu7i_BFu8ll()
{
  {
    init_simple_test("S_BFu7i_BFu8ll");
    static STRUCT_IF_C S_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu8ll, S_BFu7i_BFu8ll)
//============================================================================


struct  S_BFu7i_BFu8s  {
  short v1;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 S_BFu7i_BFu8s) C1{ Fs Fi:7 Fs:8}



static void Test_S_BFu7i_BFu8s()
{
  {
    init_simple_test("S_BFu7i_BFu8s");
    static STRUCT_IF_C S_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu8s, S_BFu7i_BFu8s)
//============================================================================


struct  S_BFu7i_BFu9i  {
  short v1;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 S_BFu7i_BFu9i) C1{ Fs Fi:7 Fi:9}



static void Test_S_BFu7i_BFu9i()
{
  {
    init_simple_test("S_BFu7i_BFu9i");
    static STRUCT_IF_C S_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu9i, S_BFu7i_BFu9i)
//============================================================================


struct  S_BFu7i_BFu9ll  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 S_BFu7i_BFu9ll) C1{ Fs Fi:7 FL:9}



static void Test_S_BFu7i_BFu9ll()
{
  {
    init_simple_test("S_BFu7i_BFu9ll");
    static STRUCT_IF_C S_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu9ll, S_BFu7i_BFu9ll)
//============================================================================


struct  S_BFu7i_BFu9s  {
  short v1;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 S_BFu7i_BFu9s) C1{ Fs Fi:7 Fs:9}



static void Test_S_BFu7i_BFu9s()
{
  {
    init_simple_test("S_BFu7i_BFu9s");
    static STRUCT_IF_C S_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_BFu9s, S_BFu7i_BFu9s)
//============================================================================


struct  S_BFu7i_C  {
  short v1;
  unsigned int v2:7;
  char v3;
};
//SIG(1 S_BFu7i_C) C1{ Fs Fi:7 Fc}



static void Test_S_BFu7i_C()
{
  {
    init_simple_test("S_BFu7i_C");
    static STRUCT_IF_C S_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_C)");
    check_field_offset(lv, v1, 0, "S_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_C");
    check_field_offset(lv, v3, 3, "S_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_C, S_BFu7i_C)
//============================================================================


struct  S_BFu7i_D  {
  short v1;
  unsigned int v2:7;
  double v3;
};
//SIG(1 S_BFu7i_D) C1{ Fs Fi:7 FL}



static void Test_S_BFu7i_D()
{
  {
    init_simple_test("S_BFu7i_D");
    static STRUCT_IF_C S_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_D)");
    check_field_offset(lv, v1, 0, "S_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_D, S_BFu7i_D)
//============================================================================


struct  S_BFu7i_F  {
  short v1;
  unsigned int v2:7;
  float v3;
};
//SIG(1 S_BFu7i_F) C1{ Fs Fi:7 Fi}



static void Test_S_BFu7i_F()
{
  {
    init_simple_test("S_BFu7i_F");
    static STRUCT_IF_C S_BFu7i_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_F)");
    check_field_offset(lv, v1, 0, "S_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_F");
    check_field_offset(lv, v3, 4, "S_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_F, S_BFu7i_F)
//============================================================================


struct  S_BFu7i_I  {
  short v1;
  unsigned int v2:7;
  int v3;
};
//SIG(1 S_BFu7i_I) C1{ Fs Fi:7 Fi}



static void Test_S_BFu7i_I()
{
  {
    init_simple_test("S_BFu7i_I");
    static STRUCT_IF_C S_BFu7i_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_I)");
    check_field_offset(lv, v1, 0, "S_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_I");
    check_field_offset(lv, v3, 4, "S_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_I, S_BFu7i_I)
//============================================================================


struct  S_BFu7i_Ip  {
  short v1;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 S_BFu7i_Ip) C1{ Fs Fi:7 Fp}



static void Test_S_BFu7i_Ip()
{
  {
    init_simple_test("S_BFu7i_Ip");
    static STRUCT_IF_C S_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_Ip, S_BFu7i_Ip)
//============================================================================


struct  S_BFu7i_L  {
  short v1;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 S_BFu7i_L) C1{ Fs Fi:7 FL}



static void Test_S_BFu7i_L()
{
  {
    init_simple_test("S_BFu7i_L");
    static STRUCT_IF_C S_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_L)");
    check_field_offset(lv, v1, 0, "S_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_L, S_BFu7i_L)
//============================================================================


struct  S_BFu7i_S  {
  short v1;
  unsigned int v2:7;
  short v3;
};
//SIG(1 S_BFu7i_S) C1{ Fs Fi:7 Fs}



static void Test_S_BFu7i_S()
{
  {
    init_simple_test("S_BFu7i_S");
    static STRUCT_IF_C S_BFu7i_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_S)");
    check_field_offset(lv, v1, 0, "S_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_S");
    check_field_offset(lv, v3, 4, "S_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_S, S_BFu7i_S)
//============================================================================


struct  S_BFu7i_Uc  {
  short v1;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 S_BFu7i_Uc) C1{ Fs Fi:7 Fc}



static void Test_S_BFu7i_Uc()
{
  {
    init_simple_test("S_BFu7i_Uc");
    static STRUCT_IF_C S_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_Uc");
    check_field_offset(lv, v3, 3, "S_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_Uc, S_BFu7i_Uc)
//============================================================================


struct  S_BFu7i_Ui  {
  short v1;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 S_BFu7i_Ui) C1{ Fs Fi:7 Fi}



static void Test_S_BFu7i_Ui()
{
  {
    init_simple_test("S_BFu7i_Ui");
    static STRUCT_IF_C S_BFu7i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_Ui");
    check_field_offset(lv, v3, 4, "S_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_Ui, S_BFu7i_Ui)
//============================================================================


struct  S_BFu7i_Ul  {
  short v1;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 S_BFu7i_Ul) C1{ Fs Fi:7 FL}



static void Test_S_BFu7i_Ul()
{
  {
    init_simple_test("S_BFu7i_Ul");
    static STRUCT_IF_C S_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_Ul, S_BFu7i_Ul)
//============================================================================


struct  S_BFu7i_Us  {
  short v1;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 S_BFu7i_Us) C1{ Fs Fi:7 Fs}



static void Test_S_BFu7i_Us()
{
  {
    init_simple_test("S_BFu7i_Us");
    static STRUCT_IF_C S_BFu7i_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_Us");
    check_field_offset(lv, v3, 4, "S_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_Us, S_BFu7i_Us)
//============================================================================


struct  S_BFu7i_Vp  {
  short v1;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 S_BFu7i_Vp) C1{ Fs Fi:7 Fp}



static void Test_S_BFu7i_Vp()
{
  {
    init_simple_test("S_BFu7i_Vp");
    static STRUCT_IF_C S_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7i_Vp, S_BFu7i_Vp)
//============================================================================


struct  S_BFu7ll  {
  short v1;
  __tsu64 v2:7;
};
//SIG(1 S_BFu7ll) C1{ Fs FL:7}



static void Test_S_BFu7ll()
{
  {
    init_simple_test("S_BFu7ll");
    static STRUCT_IF_C S_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll, S_BFu7ll)
//============================================================================


struct  S_BFu7ll_BFu15i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 S_BFu7ll_BFu15i) C1{ Fs FL:7 Fi:15}



static void Test_S_BFu7ll_BFu15i()
{
  {
    init_simple_test("S_BFu7ll_BFu15i");
    static STRUCT_IF_C S_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu15i, S_BFu7ll_BFu15i)
//============================================================================


struct  S_BFu7ll_BFu15ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 S_BFu7ll_BFu15ll) C1{ Fs FL:7 FL:15}



static void Test_S_BFu7ll_BFu15ll()
{
  {
    init_simple_test("S_BFu7ll_BFu15ll");
    static STRUCT_IF_C S_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "S_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "S_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu15ll, S_BFu7ll_BFu15ll)
//============================================================================


struct  S_BFu7ll_BFu15s  {
  short v1;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 S_BFu7ll_BFu15s) C1{ Fs FL:7 Fs:15}



static void Test_S_BFu7ll_BFu15s()
{
  {
    init_simple_test("S_BFu7ll_BFu15s");
    static STRUCT_IF_C S_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu15s, S_BFu7ll_BFu15s)
//============================================================================


struct  S_BFu7ll_BFu16i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 S_BFu7ll_BFu16i) C1{ Fs FL:7 Fi:16}



static void Test_S_BFu7ll_BFu16i()
{
  {
    init_simple_test("S_BFu7ll_BFu16i");
    static STRUCT_IF_C S_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu16i, S_BFu7ll_BFu16i)
//============================================================================


struct  S_BFu7ll_BFu16ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 S_BFu7ll_BFu16ll) C1{ Fs FL:7 FL:16}



static void Test_S_BFu7ll_BFu16ll()
{
  {
    init_simple_test("S_BFu7ll_BFu16ll");
    static STRUCT_IF_C S_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "S_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "S_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu16ll, S_BFu7ll_BFu16ll)
//============================================================================


struct  S_BFu7ll_BFu16s  {
  short v1;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 S_BFu7ll_BFu16s) C1{ Fs FL:7 Fs:16}



static void Test_S_BFu7ll_BFu16s()
{
  {
    init_simple_test("S_BFu7ll_BFu16s");
    static STRUCT_IF_C S_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu16s, S_BFu7ll_BFu16s)
//============================================================================


struct  S_BFu7ll_BFu17i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 S_BFu7ll_BFu17i) C1{ Fs FL:7 Fi:17}



static void Test_S_BFu7ll_BFu17i()
{
  {
    init_simple_test("S_BFu7ll_BFu17i");
    static STRUCT_IF_C S_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu17i, S_BFu7ll_BFu17i)
//============================================================================


struct  S_BFu7ll_BFu17ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 S_BFu7ll_BFu17ll) C1{ Fs FL:7 FL:17}



static void Test_S_BFu7ll_BFu17ll()
{
  {
    init_simple_test("S_BFu7ll_BFu17ll");
    static STRUCT_IF_C S_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "S_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "S_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu17ll, S_BFu7ll_BFu17ll)
//============================================================================


struct  S_BFu7ll_BFu1c  {
  short v1;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 S_BFu7ll_BFu1c) C1{ Fs FL:7 Fc:1}



static void Test_S_BFu7ll_BFu1c()
{
  {
    init_simple_test("S_BFu7ll_BFu1c");
    static STRUCT_IF_C S_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu1c, S_BFu7ll_BFu1c)
//============================================================================


struct  S_BFu7ll_BFu1i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 S_BFu7ll_BFu1i) C1{ Fs FL:7 Fi:1}



static void Test_S_BFu7ll_BFu1i()
{
  {
    init_simple_test("S_BFu7ll_BFu1i");
    static STRUCT_IF_C S_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu1i, S_BFu7ll_BFu1i)
//============================================================================


struct  S_BFu7ll_BFu1ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 S_BFu7ll_BFu1ll) C1{ Fs FL:7 FL:1}



static void Test_S_BFu7ll_BFu1ll()
{
  {
    init_simple_test("S_BFu7ll_BFu1ll");
    static STRUCT_IF_C S_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu1ll, S_BFu7ll_BFu1ll)
//============================================================================


struct  S_BFu7ll_BFu1s  {
  short v1;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 S_BFu7ll_BFu1s) C1{ Fs FL:7 Fs:1}



static void Test_S_BFu7ll_BFu1s()
{
  {
    init_simple_test("S_BFu7ll_BFu1s");
    static STRUCT_IF_C S_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu1s, S_BFu7ll_BFu1s)
//============================================================================


struct  S_BFu7ll_BFu31i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 S_BFu7ll_BFu31i) C1{ Fs FL:7 Fi:31}



static void Test_S_BFu7ll_BFu31i()
{
  {
    init_simple_test("S_BFu7ll_BFu31i");
    static STRUCT_IF_C S_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu31i, S_BFu7ll_BFu31i)
//============================================================================


struct  S_BFu7ll_BFu31ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 S_BFu7ll_BFu31ll) C1{ Fs FL:7 FL:31}



static void Test_S_BFu7ll_BFu31ll()
{
  {
    init_simple_test("S_BFu7ll_BFu31ll");
    static STRUCT_IF_C S_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "S_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "S_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu31ll, S_BFu7ll_BFu31ll)
//============================================================================


struct  S_BFu7ll_BFu32i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 S_BFu7ll_BFu32i) C1{ Fs FL:7 Fi:32}



static void Test_S_BFu7ll_BFu32i()
{
  {
    init_simple_test("S_BFu7ll_BFu32i");
    static STRUCT_IF_C S_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu32i, S_BFu7ll_BFu32i)
//============================================================================


struct  S_BFu7ll_BFu32ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 S_BFu7ll_BFu32ll) C1{ Fs FL:7 FL:32}



static void Test_S_BFu7ll_BFu32ll()
{
  {
    init_simple_test("S_BFu7ll_BFu32ll");
    static STRUCT_IF_C S_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "S_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "S_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu32ll, S_BFu7ll_BFu32ll)
//============================================================================


struct  S_BFu7ll_BFu33  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 S_BFu7ll_BFu33) C1{ Fs FL:7 FL:33}



static void Test_S_BFu7ll_BFu33()
{
  {
    init_simple_test("S_BFu7ll_BFu33");
    static STRUCT_IF_C S_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "S_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "S_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu33, S_BFu7ll_BFu33)
//============================================================================


struct  S_BFu7ll_BFu7c  {
  short v1;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 S_BFu7ll_BFu7c) C1{ Fs FL:7 Fc:7}



static void Test_S_BFu7ll_BFu7c()
{
  {
    init_simple_test("S_BFu7ll_BFu7c");
    static STRUCT_IF_C S_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu7c, S_BFu7ll_BFu7c)
//============================================================================


struct  S_BFu7ll_BFu7i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 S_BFu7ll_BFu7i) C1{ Fs FL:7 Fi:7}



static void Test_S_BFu7ll_BFu7i()
{
  {
    init_simple_test("S_BFu7ll_BFu7i");
    static STRUCT_IF_C S_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu7i, S_BFu7ll_BFu7i)
//============================================================================


struct  S_BFu7ll_BFu7ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 S_BFu7ll_BFu7ll) C1{ Fs FL:7 FL:7}



static void Test_S_BFu7ll_BFu7ll()
{
  {
    init_simple_test("S_BFu7ll_BFu7ll");
    static STRUCT_IF_C S_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu7ll, S_BFu7ll_BFu7ll)
//============================================================================


struct  S_BFu7ll_BFu7s  {
  short v1;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 S_BFu7ll_BFu7s) C1{ Fs FL:7 Fs:7}



static void Test_S_BFu7ll_BFu7s()
{
  {
    init_simple_test("S_BFu7ll_BFu7s");
    static STRUCT_IF_C S_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu7s, S_BFu7ll_BFu7s)
//============================================================================


struct  S_BFu7ll_BFu8c  {
  short v1;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 S_BFu7ll_BFu8c) C1{ Fs FL:7 Fc:8}



static void Test_S_BFu7ll_BFu8c()
{
  {
    init_simple_test("S_BFu7ll_BFu8c");
    static STRUCT_IF_C S_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu8c, S_BFu7ll_BFu8c)
//============================================================================


struct  S_BFu7ll_BFu8i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 S_BFu7ll_BFu8i) C1{ Fs FL:7 Fi:8}



static void Test_S_BFu7ll_BFu8i()
{
  {
    init_simple_test("S_BFu7ll_BFu8i");
    static STRUCT_IF_C S_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu8i, S_BFu7ll_BFu8i)
//============================================================================


struct  S_BFu7ll_BFu8ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 S_BFu7ll_BFu8ll) C1{ Fs FL:7 FL:8}



static void Test_S_BFu7ll_BFu8ll()
{
  {
    init_simple_test("S_BFu7ll_BFu8ll");
    static STRUCT_IF_C S_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu8ll, S_BFu7ll_BFu8ll)
//============================================================================


struct  S_BFu7ll_BFu8s  {
  short v1;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 S_BFu7ll_BFu8s) C1{ Fs FL:7 Fs:8}



static void Test_S_BFu7ll_BFu8s()
{
  {
    init_simple_test("S_BFu7ll_BFu8s");
    static STRUCT_IF_C S_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu8s, S_BFu7ll_BFu8s)
//============================================================================


struct  S_BFu7ll_BFu9i  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 S_BFu7ll_BFu9i) C1{ Fs FL:7 Fi:9}



static void Test_S_BFu7ll_BFu9i()
{
  {
    init_simple_test("S_BFu7ll_BFu9i");
    static STRUCT_IF_C S_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu9i, S_BFu7ll_BFu9i)
//============================================================================


struct  S_BFu7ll_BFu9ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 S_BFu7ll_BFu9ll) C1{ Fs FL:7 FL:9}



static void Test_S_BFu7ll_BFu9ll()
{
  {
    init_simple_test("S_BFu7ll_BFu9ll");
    static STRUCT_IF_C S_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu9ll, S_BFu7ll_BFu9ll)
//============================================================================


struct  S_BFu7ll_BFu9s  {
  short v1;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 S_BFu7ll_BFu9s) C1{ Fs FL:7 Fs:9}



static void Test_S_BFu7ll_BFu9s()
{
  {
    init_simple_test("S_BFu7ll_BFu9s");
    static STRUCT_IF_C S_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_BFu9s, S_BFu7ll_BFu9s)
//============================================================================


struct  S_BFu7ll_C  {
  short v1;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 S_BFu7ll_C) C1{ Fs FL:7 Fc}



static void Test_S_BFu7ll_C()
{
  {
    init_simple_test("S_BFu7ll_C");
    static STRUCT_IF_C S_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_C");
    check_field_offset(lv, v3, 3, "S_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_C, S_BFu7ll_C)
//============================================================================


struct  S_BFu7ll_D  {
  short v1;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 S_BFu7ll_D) C1{ Fs FL:7 FL}



static void Test_S_BFu7ll_D()
{
  {
    init_simple_test("S_BFu7ll_D");
    static STRUCT_IF_C S_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_D, S_BFu7ll_D)
//============================================================================


struct  S_BFu7ll_F  {
  short v1;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 S_BFu7ll_F) C1{ Fs FL:7 Fi}



static void Test_S_BFu7ll_F()
{
  {
    init_simple_test("S_BFu7ll_F");
    static STRUCT_IF_C S_BFu7ll_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_F");
    check_field_offset(lv, v3, 4, "S_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_F, S_BFu7ll_F)
//============================================================================


struct  S_BFu7ll_I  {
  short v1;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 S_BFu7ll_I) C1{ Fs FL:7 Fi}



static void Test_S_BFu7ll_I()
{
  {
    init_simple_test("S_BFu7ll_I");
    static STRUCT_IF_C S_BFu7ll_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_I");
    check_field_offset(lv, v3, 4, "S_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_I, S_BFu7ll_I)
//============================================================================


struct  S_BFu7ll_Ip  {
  short v1;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 S_BFu7ll_Ip) C1{ Fs FL:7 Fp}



static void Test_S_BFu7ll_Ip()
{
  {
    init_simple_test("S_BFu7ll_Ip");
    static STRUCT_IF_C S_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_Ip, S_BFu7ll_Ip)
//============================================================================


struct  S_BFu7ll_L  {
  short v1;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 S_BFu7ll_L) C1{ Fs FL:7 FL}



static void Test_S_BFu7ll_L()
{
  {
    init_simple_test("S_BFu7ll_L");
    static STRUCT_IF_C S_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_L, S_BFu7ll_L)
//============================================================================


struct  S_BFu7ll_S  {
  short v1;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 S_BFu7ll_S) C1{ Fs FL:7 Fs}



static void Test_S_BFu7ll_S()
{
  {
    init_simple_test("S_BFu7ll_S");
    static STRUCT_IF_C S_BFu7ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_S");
    check_field_offset(lv, v3, 4, "S_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_S, S_BFu7ll_S)
//============================================================================


struct  S_BFu7ll_Uc  {
  short v1;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 S_BFu7ll_Uc) C1{ Fs FL:7 Fc}



static void Test_S_BFu7ll_Uc()
{
  {
    init_simple_test("S_BFu7ll_Uc");
    static STRUCT_IF_C S_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_Uc");
    check_field_offset(lv, v3, 3, "S_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_Uc, S_BFu7ll_Uc)
//============================================================================


struct  S_BFu7ll_Ui  {
  short v1;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 S_BFu7ll_Ui) C1{ Fs FL:7 Fi}



static void Test_S_BFu7ll_Ui()
{
  {
    init_simple_test("S_BFu7ll_Ui");
    static STRUCT_IF_C S_BFu7ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_Ui");
    check_field_offset(lv, v3, 4, "S_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_Ui, S_BFu7ll_Ui)
//============================================================================


struct  S_BFu7ll_Ul  {
  short v1;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 S_BFu7ll_Ul) C1{ Fs FL:7 FL}



static void Test_S_BFu7ll_Ul()
{
  {
    init_simple_test("S_BFu7ll_Ul");
    static STRUCT_IF_C S_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_Ul, S_BFu7ll_Ul)
//============================================================================


struct  S_BFu7ll_Us  {
  short v1;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 S_BFu7ll_Us) C1{ Fs FL:7 Fs}



static void Test_S_BFu7ll_Us()
{
  {
    init_simple_test("S_BFu7ll_Us");
    static STRUCT_IF_C S_BFu7ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_Us");
    check_field_offset(lv, v3, 4, "S_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_Us, S_BFu7ll_Us)
//============================================================================


struct  S_BFu7ll_Vp  {
  short v1;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 S_BFu7ll_Vp) C1{ Fs FL:7 Fp}



static void Test_S_BFu7ll_Vp()
{
  {
    init_simple_test("S_BFu7ll_Vp");
    static STRUCT_IF_C S_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7ll_Vp, S_BFu7ll_Vp)
//============================================================================


struct  S_BFu7s  {
  short v1;
  unsigned short v2:7;
};
//SIG(1 S_BFu7s) C1{ Fs Fs:7}



static void Test_S_BFu7s()
{
  {
    init_simple_test("S_BFu7s");
    static STRUCT_IF_C S_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s, S_BFu7s)
//============================================================================


struct  S_BFu7s_BFu15i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 S_BFu7s_BFu15i) C1{ Fs Fs:7 Fi:15}



static void Test_S_BFu7s_BFu15i()
{
  {
    init_simple_test("S_BFu7s_BFu15i");
    static STRUCT_IF_C S_BFu7s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu15i, S_BFu7s_BFu15i)
//============================================================================


struct  S_BFu7s_BFu15ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 S_BFu7s_BFu15ll) C1{ Fs Fs:7 FL:15}



static void Test_S_BFu7s_BFu15ll()
{
  {
    init_simple_test("S_BFu7s_BFu15ll");
    static STRUCT_IF_C S_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "S_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "S_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu15ll, S_BFu7s_BFu15ll)
//============================================================================


struct  S_BFu7s_BFu15s  {
  short v1;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 S_BFu7s_BFu15s) C1{ Fs Fs:7 Fs:15}



static void Test_S_BFu7s_BFu15s()
{
  {
    init_simple_test("S_BFu7s_BFu15s");
    static STRUCT_IF_C S_BFu7s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu7s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu15s, S_BFu7s_BFu15s)
//============================================================================


struct  S_BFu7s_BFu16i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 S_BFu7s_BFu16i) C1{ Fs Fs:7 Fi:16}



static void Test_S_BFu7s_BFu16i()
{
  {
    init_simple_test("S_BFu7s_BFu16i");
    static STRUCT_IF_C S_BFu7s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu16i, S_BFu7s_BFu16i)
//============================================================================


struct  S_BFu7s_BFu16ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 S_BFu7s_BFu16ll) C1{ Fs Fs:7 FL:16}



static void Test_S_BFu7s_BFu16ll()
{
  {
    init_simple_test("S_BFu7s_BFu16ll");
    static STRUCT_IF_C S_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "S_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "S_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu16ll, S_BFu7s_BFu16ll)
//============================================================================


struct  S_BFu7s_BFu16s  {
  short v1;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 S_BFu7s_BFu16s) C1{ Fs Fs:7 Fs:16}



static void Test_S_BFu7s_BFu16s()
{
  {
    init_simple_test("S_BFu7s_BFu16s");
    static STRUCT_IF_C S_BFu7s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu7s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu16s, S_BFu7s_BFu16s)
//============================================================================


struct  S_BFu7s_BFu17i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 S_BFu7s_BFu17i) C1{ Fs Fs:7 Fi:17}



static void Test_S_BFu7s_BFu17i()
{
  {
    init_simple_test("S_BFu7s_BFu17i");
    static STRUCT_IF_C S_BFu7s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu17i, S_BFu7s_BFu17i)
//============================================================================


struct  S_BFu7s_BFu17ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 S_BFu7s_BFu17ll) C1{ Fs Fs:7 FL:17}



static void Test_S_BFu7s_BFu17ll()
{
  {
    init_simple_test("S_BFu7s_BFu17ll");
    static STRUCT_IF_C S_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "S_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "S_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu17ll, S_BFu7s_BFu17ll)
//============================================================================


struct  S_BFu7s_BFu1c  {
  short v1;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 S_BFu7s_BFu1c) C1{ Fs Fs:7 Fc:1}



static void Test_S_BFu7s_BFu1c()
{
  {
    init_simple_test("S_BFu7s_BFu1c");
    static STRUCT_IF_C S_BFu7s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu1c, S_BFu7s_BFu1c)
//============================================================================


struct  S_BFu7s_BFu1i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 S_BFu7s_BFu1i) C1{ Fs Fs:7 Fi:1}



static void Test_S_BFu7s_BFu1i()
{
  {
    init_simple_test("S_BFu7s_BFu1i");
    static STRUCT_IF_C S_BFu7s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu1i, S_BFu7s_BFu1i)
//============================================================================


struct  S_BFu7s_BFu1ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 S_BFu7s_BFu1ll) C1{ Fs Fs:7 FL:1}



static void Test_S_BFu7s_BFu1ll()
{
  {
    init_simple_test("S_BFu7s_BFu1ll");
    static STRUCT_IF_C S_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu1ll, S_BFu7s_BFu1ll)
//============================================================================


struct  S_BFu7s_BFu1s  {
  short v1;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 S_BFu7s_BFu1s) C1{ Fs Fs:7 Fs:1}



static void Test_S_BFu7s_BFu1s()
{
  {
    init_simple_test("S_BFu7s_BFu1s");
    static STRUCT_IF_C S_BFu7s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "S_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu1s, S_BFu7s_BFu1s)
//============================================================================


struct  S_BFu7s_BFu31i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 S_BFu7s_BFu31i) C1{ Fs Fs:7 Fi:31}



static void Test_S_BFu7s_BFu31i()
{
  {
    init_simple_test("S_BFu7s_BFu31i");
    static STRUCT_IF_C S_BFu7s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu31i, S_BFu7s_BFu31i)
//============================================================================


struct  S_BFu7s_BFu31ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 S_BFu7s_BFu31ll) C1{ Fs Fs:7 FL:31}



static void Test_S_BFu7s_BFu31ll()
{
  {
    init_simple_test("S_BFu7s_BFu31ll");
    static STRUCT_IF_C S_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "S_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "S_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu31ll, S_BFu7s_BFu31ll)
//============================================================================


struct  S_BFu7s_BFu32i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 S_BFu7s_BFu32i) C1{ Fs Fs:7 Fi:32}



static void Test_S_BFu7s_BFu32i()
{
  {
    init_simple_test("S_BFu7s_BFu32i");
    static STRUCT_IF_C S_BFu7s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu32i, S_BFu7s_BFu32i)
//============================================================================


struct  S_BFu7s_BFu32ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 S_BFu7s_BFu32ll) C1{ Fs Fs:7 FL:32}



static void Test_S_BFu7s_BFu32ll()
{
  {
    init_simple_test("S_BFu7s_BFu32ll");
    static STRUCT_IF_C S_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "S_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "S_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu32ll, S_BFu7s_BFu32ll)
//============================================================================


struct  S_BFu7s_BFu33  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 S_BFu7s_BFu33) C1{ Fs Fs:7 FL:33}



static void Test_S_BFu7s_BFu33()
{
  {
    init_simple_test("S_BFu7s_BFu33");
    static STRUCT_IF_C S_BFu7s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "S_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "S_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu33, S_BFu7s_BFu33)
//============================================================================


struct  S_BFu7s_BFu7c  {
  short v1;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 S_BFu7s_BFu7c) C1{ Fs Fs:7 Fc:7}



static void Test_S_BFu7s_BFu7c()
{
  {
    init_simple_test("S_BFu7s_BFu7c");
    static STRUCT_IF_C S_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu7c, S_BFu7s_BFu7c)
//============================================================================


struct  S_BFu7s_BFu7i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 S_BFu7s_BFu7i) C1{ Fs Fs:7 Fi:7}



static void Test_S_BFu7s_BFu7i()
{
  {
    init_simple_test("S_BFu7s_BFu7i");
    static STRUCT_IF_C S_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu7i, S_BFu7s_BFu7i)
//============================================================================


struct  S_BFu7s_BFu7ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 S_BFu7s_BFu7ll) C1{ Fs Fs:7 FL:7}



static void Test_S_BFu7s_BFu7ll()
{
  {
    init_simple_test("S_BFu7s_BFu7ll");
    static STRUCT_IF_C S_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu7ll, S_BFu7s_BFu7ll)
//============================================================================


struct  S_BFu7s_BFu7s  {
  short v1;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 S_BFu7s_BFu7s) C1{ Fs Fs:7 Fs:7}



static void Test_S_BFu7s_BFu7s()
{
  {
    init_simple_test("S_BFu7s_BFu7s");
    static STRUCT_IF_C S_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "S_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "S_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu7s, S_BFu7s_BFu7s)
//============================================================================


struct  S_BFu7s_BFu8c  {
  short v1;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 S_BFu7s_BFu8c) C1{ Fs Fs:7 Fc:8}



static void Test_S_BFu7s_BFu8c()
{
  {
    init_simple_test("S_BFu7s_BFu8c");
    static STRUCT_IF_C S_BFu7s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu8c, S_BFu7s_BFu8c)
//============================================================================


struct  S_BFu7s_BFu8i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 S_BFu7s_BFu8i) C1{ Fs Fs:7 Fi:8}



static void Test_S_BFu7s_BFu8i()
{
  {
    init_simple_test("S_BFu7s_BFu8i");
    static STRUCT_IF_C S_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu8i, S_BFu7s_BFu8i)
//============================================================================


struct  S_BFu7s_BFu8ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 S_BFu7s_BFu8ll) C1{ Fs Fs:7 FL:8}



static void Test_S_BFu7s_BFu8ll()
{
  {
    init_simple_test("S_BFu7s_BFu8ll");
    static STRUCT_IF_C S_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu8ll, S_BFu7s_BFu8ll)
//============================================================================


struct  S_BFu7s_BFu8s  {
  short v1;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 S_BFu7s_BFu8s) C1{ Fs Fs:7 Fs:8}



static void Test_S_BFu7s_BFu8s()
{
  {
    init_simple_test("S_BFu7s_BFu8s");
    static STRUCT_IF_C S_BFu7s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "S_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "S_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu8s, S_BFu7s_BFu8s)
//============================================================================


struct  S_BFu7s_BFu9i  {
  short v1;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 S_BFu7s_BFu9i) C1{ Fs Fs:7 Fi:9}



static void Test_S_BFu7s_BFu9i()
{
  {
    init_simple_test("S_BFu7s_BFu9i");
    static STRUCT_IF_C S_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu9i, S_BFu7s_BFu9i)
//============================================================================


struct  S_BFu7s_BFu9ll  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 S_BFu7s_BFu9ll) C1{ Fs Fs:7 FL:9}



static void Test_S_BFu7s_BFu9ll()
{
  {
    init_simple_test("S_BFu7s_BFu9ll");
    static STRUCT_IF_C S_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu9ll, S_BFu7s_BFu9ll)
//============================================================================


struct  S_BFu7s_BFu9s  {
  short v1;
  unsigned short v2:7;
  unsigned short v3:9;
};
//SIG(1 S_BFu7s_BFu9s) C1{ Fs Fs:7 Fs:9}



static void Test_S_BFu7s_BFu9s()
{
  {
    init_simple_test("S_BFu7s_BFu9s");
    static STRUCT_IF_C S_BFu7s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "S_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "S_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_BFu9s, S_BFu7s_BFu9s)
//============================================================================


struct  S_BFu7s_C  {
  short v1;
  unsigned short v2:7;
  char v3;
};
//SIG(1 S_BFu7s_C) C1{ Fs Fs:7 Fc}



static void Test_S_BFu7s_C()
{
  {
    init_simple_test("S_BFu7s_C");
    static STRUCT_IF_C S_BFu7s_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_C)");
    check_field_offset(lv, v1, 0, "S_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_C");
    check_field_offset(lv, v3, 3, "S_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_C, S_BFu7s_C)
//============================================================================


struct  S_BFu7s_D  {
  short v1;
  unsigned short v2:7;
  double v3;
};
//SIG(1 S_BFu7s_D) C1{ Fs Fs:7 FL}



static void Test_S_BFu7s_D()
{
  {
    init_simple_test("S_BFu7s_D");
    static STRUCT_IF_C S_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_D)");
    check_field_offset(lv, v1, 0, "S_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_D, S_BFu7s_D)
//============================================================================


struct  S_BFu7s_F  {
  short v1;
  unsigned short v2:7;
  float v3;
};
//SIG(1 S_BFu7s_F) C1{ Fs Fs:7 Fi}



static void Test_S_BFu7s_F()
{
  {
    init_simple_test("S_BFu7s_F");
    static STRUCT_IF_C S_BFu7s_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_F)");
    check_field_offset(lv, v1, 0, "S_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_F");
    check_field_offset(lv, v3, 4, "S_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_F, S_BFu7s_F)
//============================================================================


struct  S_BFu7s_I  {
  short v1;
  unsigned short v2:7;
  int v3;
};
//SIG(1 S_BFu7s_I) C1{ Fs Fs:7 Fi}



static void Test_S_BFu7s_I()
{
  {
    init_simple_test("S_BFu7s_I");
    static STRUCT_IF_C S_BFu7s_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_I)");
    check_field_offset(lv, v1, 0, "S_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_I");
    check_field_offset(lv, v3, 4, "S_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_I, S_BFu7s_I)
//============================================================================


struct  S_BFu7s_Ip  {
  short v1;
  unsigned short v2:7;
  int *v3;
};
//SIG(1 S_BFu7s_Ip) C1{ Fs Fs:7 Fp}



static void Test_S_BFu7s_Ip()
{
  {
    init_simple_test("S_BFu7s_Ip");
    static STRUCT_IF_C S_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_Ip, S_BFu7s_Ip)
//============================================================================


struct  S_BFu7s_L  {
  short v1;
  unsigned short v2:7;
  __tsi64 v3;
};
//SIG(1 S_BFu7s_L) C1{ Fs Fs:7 FL}



static void Test_S_BFu7s_L()
{
  {
    init_simple_test("S_BFu7s_L");
    static STRUCT_IF_C S_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_L)");
    check_field_offset(lv, v1, 0, "S_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_L, S_BFu7s_L)
//============================================================================


struct  S_BFu7s_S  {
  short v1;
  unsigned short v2:7;
  short v3;
};
//SIG(1 S_BFu7s_S) C1{ Fs Fs:7 Fs}



static void Test_S_BFu7s_S()
{
  {
    init_simple_test("S_BFu7s_S");
    static STRUCT_IF_C S_BFu7s_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu7s_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_S)");
    check_field_offset(lv, v1, 0, "S_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_S");
    check_field_offset(lv, v3, 4, "S_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_S, S_BFu7s_S)
//============================================================================


struct  S_BFu7s_Uc  {
  short v1;
  unsigned short v2:7;
  unsigned char v3;
};
//SIG(1 S_BFu7s_Uc) C1{ Fs Fs:7 Fc}



static void Test_S_BFu7s_Uc()
{
  {
    init_simple_test("S_BFu7s_Uc");
    static STRUCT_IF_C S_BFu7s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_Uc");
    check_field_offset(lv, v3, 3, "S_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_Uc, S_BFu7s_Uc)
//============================================================================


struct  S_BFu7s_Ui  {
  short v1;
  unsigned short v2:7;
  unsigned int v3;
};
//SIG(1 S_BFu7s_Ui) C1{ Fs Fs:7 Fi}



static void Test_S_BFu7s_Ui()
{
  {
    init_simple_test("S_BFu7s_Ui");
    static STRUCT_IF_C S_BFu7s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu7s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_Ui");
    check_field_offset(lv, v3, 4, "S_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_Ui, S_BFu7s_Ui)
//============================================================================


struct  S_BFu7s_Ul  {
  short v1;
  unsigned short v2:7;
  __tsu64 v3;
};
//SIG(1 S_BFu7s_Ul) C1{ Fs Fs:7 FL}



static void Test_S_BFu7s_Ul()
{
  {
    init_simple_test("S_BFu7s_Ul");
    static STRUCT_IF_C S_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_Ul, S_BFu7s_Ul)
//============================================================================


struct  S_BFu7s_Us  {
  short v1;
  unsigned short v2:7;
  unsigned short v3;
};
//SIG(1 S_BFu7s_Us) C1{ Fs Fs:7 Fs}



static void Test_S_BFu7s_Us()
{
  {
    init_simple_test("S_BFu7s_Us");
    static STRUCT_IF_C S_BFu7s_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu7s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "S_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_Us");
    check_field_offset(lv, v3, 4, "S_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_Us, S_BFu7s_Us)
//============================================================================


struct  S_BFu7s_Vp  {
  short v1;
  unsigned short v2:7;
  void *v3;
};
//SIG(1 S_BFu7s_Vp) C1{ Fs Fs:7 Fp}



static void Test_S_BFu7s_Vp()
{
  {
    init_simple_test("S_BFu7s_Vp");
    static STRUCT_IF_C S_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu7s_Vp, S_BFu7s_Vp)
//============================================================================


struct  S_BFu8c  {
  short v1;
  unsigned char v2:8;
};
//SIG(1 S_BFu8c) C1{ Fs Fc:8}



static void Test_S_BFu8c()
{
  {
    init_simple_test("S_BFu8c");
    static STRUCT_IF_C S_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c, S_BFu8c)
//============================================================================


struct  S_BFu8c_BFu15i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:15;
};
//SIG(1 S_BFu8c_BFu15i) C1{ Fs Fc:8 Fi:15}



static void Test_S_BFu8c_BFu15i()
{
  {
    init_simple_test("S_BFu8c_BFu15i");
    static STRUCT_IF_C S_BFu8c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu15i, S_BFu8c_BFu15i)
//============================================================================


struct  S_BFu8c_BFu15ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:15;
};
//SIG(1 S_BFu8c_BFu15ll) C1{ Fs Fc:8 FL:15}



static void Test_S_BFu8c_BFu15ll()
{
  {
    init_simple_test("S_BFu8c_BFu15ll");
    static STRUCT_IF_C S_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "S_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "S_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu15ll, S_BFu8c_BFu15ll)
//============================================================================


struct  S_BFu8c_BFu15s  {
  short v1;
  unsigned char v2:8;
  unsigned short v3:15;
};
//SIG(1 S_BFu8c_BFu15s) C1{ Fs Fc:8 Fs:15}



static void Test_S_BFu8c_BFu15s()
{
  {
    init_simple_test("S_BFu8c_BFu15s");
    static STRUCT_IF_C S_BFu8c_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu15s, S_BFu8c_BFu15s)
//============================================================================


struct  S_BFu8c_BFu16i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:16;
};
//SIG(1 S_BFu8c_BFu16i) C1{ Fs Fc:8 Fi:16}



static void Test_S_BFu8c_BFu16i()
{
  {
    init_simple_test("S_BFu8c_BFu16i");
    static STRUCT_IF_C S_BFu8c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu16i, S_BFu8c_BFu16i)
//============================================================================


struct  S_BFu8c_BFu16ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:16;
};
//SIG(1 S_BFu8c_BFu16ll) C1{ Fs Fc:8 FL:16}



static void Test_S_BFu8c_BFu16ll()
{
  {
    init_simple_test("S_BFu8c_BFu16ll");
    static STRUCT_IF_C S_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "S_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "S_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu16ll, S_BFu8c_BFu16ll)
//============================================================================


struct  S_BFu8c_BFu16s  {
  short v1;
  unsigned char v2:8;
  unsigned short v3:16;
};
//SIG(1 S_BFu8c_BFu16s) C1{ Fs Fc:8 Fs:16}



static void Test_S_BFu8c_BFu16s()
{
  {
    init_simple_test("S_BFu8c_BFu16s");
    static STRUCT_IF_C S_BFu8c_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu16s, S_BFu8c_BFu16s)
//============================================================================


struct  S_BFu8c_BFu17i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:17;
};
//SIG(1 S_BFu8c_BFu17i) C1{ Fs Fc:8 Fi:17}



static void Test_S_BFu8c_BFu17i()
{
  {
    init_simple_test("S_BFu8c_BFu17i");
    static STRUCT_IF_C S_BFu8c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu17i, S_BFu8c_BFu17i)
//============================================================================


struct  S_BFu8c_BFu17ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:17;
};
//SIG(1 S_BFu8c_BFu17ll) C1{ Fs Fc:8 FL:17}



static void Test_S_BFu8c_BFu17ll()
{
  {
    init_simple_test("S_BFu8c_BFu17ll");
    static STRUCT_IF_C S_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "S_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "S_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu17ll, S_BFu8c_BFu17ll)
//============================================================================


struct  S_BFu8c_BFu1c  {
  short v1;
  unsigned char v2:8;
  unsigned char v3:1;
};
//SIG(1 S_BFu8c_BFu1c) C1{ Fs Fc:8 Fc:1}



static void Test_S_BFu8c_BFu1c()
{
  {
    init_simple_test("S_BFu8c_BFu1c");
    static STRUCT_IF_C S_BFu8c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu1c, S_BFu8c_BFu1c)
//============================================================================


struct  S_BFu8c_BFu1i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:1;
};
//SIG(1 S_BFu8c_BFu1i) C1{ Fs Fc:8 Fi:1}



static void Test_S_BFu8c_BFu1i()
{
  {
    init_simple_test("S_BFu8c_BFu1i");
    static STRUCT_IF_C S_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu1i, S_BFu8c_BFu1i)
//============================================================================


struct  S_BFu8c_BFu1ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:1;
};
//SIG(1 S_BFu8c_BFu1ll) C1{ Fs Fc:8 FL:1}



static void Test_S_BFu8c_BFu1ll()
{
  {
    init_simple_test("S_BFu8c_BFu1ll");
    static STRUCT_IF_C S_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu1ll, S_BFu8c_BFu1ll)
//============================================================================


struct  S_BFu8c_BFu1s  {
  short v1;
  unsigned char v2:8;
  unsigned short v3:1;
};
//SIG(1 S_BFu8c_BFu1s) C1{ Fs Fc:8 Fs:1}



static void Test_S_BFu8c_BFu1s()
{
  {
    init_simple_test("S_BFu8c_BFu1s");
    static STRUCT_IF_C S_BFu8c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu1s, S_BFu8c_BFu1s)
//============================================================================


struct  S_BFu8c_BFu31i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:31;
};
//SIG(1 S_BFu8c_BFu31i) C1{ Fs Fc:8 Fi:31}



static void Test_S_BFu8c_BFu31i()
{
  {
    init_simple_test("S_BFu8c_BFu31i");
    static STRUCT_IF_C S_BFu8c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu31i, S_BFu8c_BFu31i)
//============================================================================


struct  S_BFu8c_BFu31ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:31;
};
//SIG(1 S_BFu8c_BFu31ll) C1{ Fs Fc:8 FL:31}



static void Test_S_BFu8c_BFu31ll()
{
  {
    init_simple_test("S_BFu8c_BFu31ll");
    static STRUCT_IF_C S_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "S_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "S_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu31ll, S_BFu8c_BFu31ll)
//============================================================================


struct  S_BFu8c_BFu32i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:32;
};
//SIG(1 S_BFu8c_BFu32i) C1{ Fs Fc:8 Fi:32}



static void Test_S_BFu8c_BFu32i()
{
  {
    init_simple_test("S_BFu8c_BFu32i");
    static STRUCT_IF_C S_BFu8c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu32i, S_BFu8c_BFu32i)
//============================================================================


struct  S_BFu8c_BFu32ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:32;
};
//SIG(1 S_BFu8c_BFu32ll) C1{ Fs Fc:8 FL:32}



static void Test_S_BFu8c_BFu32ll()
{
  {
    init_simple_test("S_BFu8c_BFu32ll");
    static STRUCT_IF_C S_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "S_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "S_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu32ll, S_BFu8c_BFu32ll)
//============================================================================


struct  S_BFu8c_BFu33  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:33;
};
//SIG(1 S_BFu8c_BFu33) C1{ Fs Fc:8 FL:33}



static void Test_S_BFu8c_BFu33()
{
  {
    init_simple_test("S_BFu8c_BFu33");
    static STRUCT_IF_C S_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "S_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "S_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu33, S_BFu8c_BFu33)
//============================================================================


struct  S_BFu8c_BFu7c  {
  short v1;
  unsigned char v2:8;
  unsigned char v3:7;
};
//SIG(1 S_BFu8c_BFu7c) C1{ Fs Fc:8 Fc:7}



static void Test_S_BFu8c_BFu7c()
{
  {
    init_simple_test("S_BFu8c_BFu7c");
    static STRUCT_IF_C S_BFu8c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu7c, S_BFu8c_BFu7c)
//============================================================================


struct  S_BFu8c_BFu7i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:7;
};
//SIG(1 S_BFu8c_BFu7i) C1{ Fs Fc:8 Fi:7}



static void Test_S_BFu8c_BFu7i()
{
  {
    init_simple_test("S_BFu8c_BFu7i");
    static STRUCT_IF_C S_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu7i, S_BFu8c_BFu7i)
//============================================================================


struct  S_BFu8c_BFu7ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:7;
};
//SIG(1 S_BFu8c_BFu7ll) C1{ Fs Fc:8 FL:7}



static void Test_S_BFu8c_BFu7ll()
{
  {
    init_simple_test("S_BFu8c_BFu7ll");
    static STRUCT_IF_C S_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu7ll, S_BFu8c_BFu7ll)
//============================================================================


struct  S_BFu8c_BFu7s  {
  short v1;
  unsigned char v2:8;
  unsigned short v3:7;
};
//SIG(1 S_BFu8c_BFu7s) C1{ Fs Fc:8 Fs:7}



static void Test_S_BFu8c_BFu7s()
{
  {
    init_simple_test("S_BFu8c_BFu7s");
    static STRUCT_IF_C S_BFu8c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu7s, S_BFu8c_BFu7s)
//============================================================================


struct  S_BFu8c_BFu8c  {
  short v1;
  unsigned char v2:8;
  unsigned char v3:8;
};
//SIG(1 S_BFu8c_BFu8c) C1{ Fs Fc:8 Fc:8}



static void Test_S_BFu8c_BFu8c()
{
  {
    init_simple_test("S_BFu8c_BFu8c");
    static STRUCT_IF_C S_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu8c, S_BFu8c_BFu8c)
//============================================================================


struct  S_BFu8c_BFu8i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:8;
};
//SIG(1 S_BFu8c_BFu8i) C1{ Fs Fc:8 Fi:8}



static void Test_S_BFu8c_BFu8i()
{
  {
    init_simple_test("S_BFu8c_BFu8i");
    static STRUCT_IF_C S_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu8i, S_BFu8c_BFu8i)
//============================================================================


struct  S_BFu8c_BFu8ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:8;
};
//SIG(1 S_BFu8c_BFu8ll) C1{ Fs Fc:8 FL:8}



static void Test_S_BFu8c_BFu8ll()
{
  {
    init_simple_test("S_BFu8c_BFu8ll");
    static STRUCT_IF_C S_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu8ll, S_BFu8c_BFu8ll)
//============================================================================


struct  S_BFu8c_BFu8s  {
  short v1;
  unsigned char v2:8;
  unsigned short v3:8;
};
//SIG(1 S_BFu8c_BFu8s) C1{ Fs Fc:8 Fs:8}



static void Test_S_BFu8c_BFu8s()
{
  {
    init_simple_test("S_BFu8c_BFu8s");
    static STRUCT_IF_C S_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu8s, S_BFu8c_BFu8s)
//============================================================================


struct  S_BFu8c_BFu9i  {
  short v1;
  unsigned char v2:8;
  unsigned int v3:9;
};
//SIG(1 S_BFu8c_BFu9i) C1{ Fs Fc:8 Fi:9}



static void Test_S_BFu8c_BFu9i()
{
  {
    init_simple_test("S_BFu8c_BFu9i");
    static STRUCT_IF_C S_BFu8c_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu9i, S_BFu8c_BFu9i)
//============================================================================


struct  S_BFu8c_BFu9ll  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3:9;
};
//SIG(1 S_BFu8c_BFu9ll) C1{ Fs Fc:8 FL:9}



static void Test_S_BFu8c_BFu9ll()
{
  {
    init_simple_test("S_BFu8c_BFu9ll");
    static STRUCT_IF_C S_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "S_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "S_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu9ll, S_BFu8c_BFu9ll)
//============================================================================


struct  S_BFu8c_BFu9s  {
  short v1;
  unsigned char v2:8;
  unsigned short v3:9;
};
//SIG(1 S_BFu8c_BFu9s) C1{ Fs Fc:8 Fs:9}



static void Test_S_BFu8c_BFu9s()
{
  {
    init_simple_test("S_BFu8c_BFu9s");
    static STRUCT_IF_C S_BFu8c_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_BFu9s, S_BFu8c_BFu9s)
//============================================================================


struct  S_BFu8c_C  {
  short v1;
  unsigned char v2:8;
  char v3;
};
//SIG(1 S_BFu8c_C) C1{ Fs Fc:8 Fc}



static void Test_S_BFu8c_C()
{
  {
    init_simple_test("S_BFu8c_C");
    static STRUCT_IF_C S_BFu8c_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_C)");
    check_field_offset(lv, v1, 0, "S_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_C");
    check_field_offset(lv, v3, 3, "S_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_C, S_BFu8c_C)
//============================================================================


struct  S_BFu8c_D  {
  short v1;
  unsigned char v2:8;
  double v3;
};
//SIG(1 S_BFu8c_D) C1{ Fs Fc:8 FL}



static void Test_S_BFu8c_D()
{
  {
    init_simple_test("S_BFu8c_D");
    static STRUCT_IF_C S_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_D)");
    check_field_offset(lv, v1, 0, "S_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_D, S_BFu8c_D)
//============================================================================


struct  S_BFu8c_F  {
  short v1;
  unsigned char v2:8;
  float v3;
};
//SIG(1 S_BFu8c_F) C1{ Fs Fc:8 Fi}



static void Test_S_BFu8c_F()
{
  {
    init_simple_test("S_BFu8c_F");
    static STRUCT_IF_C S_BFu8c_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_F)");
    check_field_offset(lv, v1, 0, "S_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_F");
    check_field_offset(lv, v3, 4, "S_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_F, S_BFu8c_F)
//============================================================================


struct  S_BFu8c_I  {
  short v1;
  unsigned char v2:8;
  int v3;
};
//SIG(1 S_BFu8c_I) C1{ Fs Fc:8 Fi}



static void Test_S_BFu8c_I()
{
  {
    init_simple_test("S_BFu8c_I");
    static STRUCT_IF_C S_BFu8c_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_I)");
    check_field_offset(lv, v1, 0, "S_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_I");
    check_field_offset(lv, v3, 4, "S_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_I, S_BFu8c_I)
//============================================================================


struct  S_BFu8c_Ip  {
  short v1;
  unsigned char v2:8;
  int *v3;
};
//SIG(1 S_BFu8c_Ip) C1{ Fs Fc:8 Fp}



static void Test_S_BFu8c_Ip()
{
  {
    init_simple_test("S_BFu8c_Ip");
    static STRUCT_IF_C S_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_Ip, S_BFu8c_Ip)
//============================================================================


struct  S_BFu8c_L  {
  short v1;
  unsigned char v2:8;
  __tsi64 v3;
};
//SIG(1 S_BFu8c_L) C1{ Fs Fc:8 FL}



static void Test_S_BFu8c_L()
{
  {
    init_simple_test("S_BFu8c_L");
    static STRUCT_IF_C S_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_L)");
    check_field_offset(lv, v1, 0, "S_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_L, S_BFu8c_L)
//============================================================================


struct  S_BFu8c_S  {
  short v1;
  unsigned char v2:8;
  short v3;
};
//SIG(1 S_BFu8c_S) C1{ Fs Fc:8 Fs}



static void Test_S_BFu8c_S()
{
  {
    init_simple_test("S_BFu8c_S");
    static STRUCT_IF_C S_BFu8c_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8c_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_S)");
    check_field_offset(lv, v1, 0, "S_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_S");
    check_field_offset(lv, v3, 4, "S_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_S, S_BFu8c_S)
//============================================================================


struct  S_BFu8c_Uc  {
  short v1;
  unsigned char v2:8;
  unsigned char v3;
};
//SIG(1 S_BFu8c_Uc) C1{ Fs Fc:8 Fc}



static void Test_S_BFu8c_Uc()
{
  {
    init_simple_test("S_BFu8c_Uc");
    static STRUCT_IF_C S_BFu8c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_Uc");
    check_field_offset(lv, v3, 3, "S_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_Uc, S_BFu8c_Uc)
//============================================================================


struct  S_BFu8c_Ui  {
  short v1;
  unsigned char v2:8;
  unsigned int v3;
};
//SIG(1 S_BFu8c_Ui) C1{ Fs Fc:8 Fi}



static void Test_S_BFu8c_Ui()
{
  {
    init_simple_test("S_BFu8c_Ui");
    static STRUCT_IF_C S_BFu8c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_Ui");
    check_field_offset(lv, v3, 4, "S_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_Ui, S_BFu8c_Ui)
//============================================================================


struct  S_BFu8c_Ul  {
  short v1;
  unsigned char v2:8;
  __tsu64 v3;
};
//SIG(1 S_BFu8c_Ul) C1{ Fs Fc:8 FL}



static void Test_S_BFu8c_Ul()
{
  {
    init_simple_test("S_BFu8c_Ul");
    static STRUCT_IF_C S_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_Ul, S_BFu8c_Ul)
//============================================================================


struct  S_BFu8c_Us  {
  short v1;
  unsigned char v2:8;
  unsigned short v3;
};
//SIG(1 S_BFu8c_Us) C1{ Fs Fc:8 Fs}



static void Test_S_BFu8c_Us()
{
  {
    init_simple_test("S_BFu8c_Us");
    static STRUCT_IF_C S_BFu8c_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "S_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_Us");
    check_field_offset(lv, v3, 4, "S_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_Us, S_BFu8c_Us)
//============================================================================


struct  S_BFu8c_Vp  {
  short v1;
  unsigned char v2:8;
  void *v3;
};
//SIG(1 S_BFu8c_Vp) C1{ Fs Fc:8 Fp}



static void Test_S_BFu8c_Vp()
{
  {
    init_simple_test("S_BFu8c_Vp");
    static STRUCT_IF_C S_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8c_Vp, S_BFu8c_Vp)
//============================================================================


struct  S_BFu8i  {
  short v1;
  unsigned int v2:8;
};
//SIG(1 S_BFu8i) C1{ Fs Fi:8}



static void Test_S_BFu8i()
{
  {
    init_simple_test("S_BFu8i");
    static STRUCT_IF_C S_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i, S_BFu8i)
//============================================================================


struct  S_BFu8i_BFu15i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:15;
};
//SIG(1 S_BFu8i_BFu15i) C1{ Fs Fi:8 Fi:15}



static void Test_S_BFu8i_BFu15i()
{
  {
    init_simple_test("S_BFu8i_BFu15i");
    static STRUCT_IF_C S_BFu8i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu15i, S_BFu8i_BFu15i)
//============================================================================


struct  S_BFu8i_BFu15ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:15;
};
//SIG(1 S_BFu8i_BFu15ll) C1{ Fs Fi:8 FL:15}



static void Test_S_BFu8i_BFu15ll()
{
  {
    init_simple_test("S_BFu8i_BFu15ll");
    static STRUCT_IF_C S_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "S_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "S_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu15ll, S_BFu8i_BFu15ll)
//============================================================================


struct  S_BFu8i_BFu15s  {
  short v1;
  unsigned int v2:8;
  unsigned short v3:15;
};
//SIG(1 S_BFu8i_BFu15s) C1{ Fs Fi:8 Fs:15}



static void Test_S_BFu8i_BFu15s()
{
  {
    init_simple_test("S_BFu8i_BFu15s");
    static STRUCT_IF_C S_BFu8i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu15s, S_BFu8i_BFu15s)
//============================================================================


struct  S_BFu8i_BFu16i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:16;
};
//SIG(1 S_BFu8i_BFu16i) C1{ Fs Fi:8 Fi:16}



static void Test_S_BFu8i_BFu16i()
{
  {
    init_simple_test("S_BFu8i_BFu16i");
    static STRUCT_IF_C S_BFu8i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu16i, S_BFu8i_BFu16i)
//============================================================================


struct  S_BFu8i_BFu16ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:16;
};
//SIG(1 S_BFu8i_BFu16ll) C1{ Fs Fi:8 FL:16}



static void Test_S_BFu8i_BFu16ll()
{
  {
    init_simple_test("S_BFu8i_BFu16ll");
    static STRUCT_IF_C S_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "S_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "S_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu16ll, S_BFu8i_BFu16ll)
//============================================================================


struct  S_BFu8i_BFu16s  {
  short v1;
  unsigned int v2:8;
  unsigned short v3:16;
};
//SIG(1 S_BFu8i_BFu16s) C1{ Fs Fi:8 Fs:16}



static void Test_S_BFu8i_BFu16s()
{
  {
    init_simple_test("S_BFu8i_BFu16s");
    static STRUCT_IF_C S_BFu8i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu16s, S_BFu8i_BFu16s)
//============================================================================


struct  S_BFu8i_BFu17i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:17;
};
//SIG(1 S_BFu8i_BFu17i) C1{ Fs Fi:8 Fi:17}



static void Test_S_BFu8i_BFu17i()
{
  {
    init_simple_test("S_BFu8i_BFu17i");
    static STRUCT_IF_C S_BFu8i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu17i, S_BFu8i_BFu17i)
//============================================================================


struct  S_BFu8i_BFu17ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:17;
};
//SIG(1 S_BFu8i_BFu17ll) C1{ Fs Fi:8 FL:17}



static void Test_S_BFu8i_BFu17ll()
{
  {
    init_simple_test("S_BFu8i_BFu17ll");
    static STRUCT_IF_C S_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "S_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "S_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu17ll, S_BFu8i_BFu17ll)
//============================================================================


struct  S_BFu8i_BFu1c  {
  short v1;
  unsigned int v2:8;
  unsigned char v3:1;
};
//SIG(1 S_BFu8i_BFu1c) C1{ Fs Fi:8 Fc:1}



static void Test_S_BFu8i_BFu1c()
{
  {
    init_simple_test("S_BFu8i_BFu1c");
    static STRUCT_IF_C S_BFu8i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu1c, S_BFu8i_BFu1c)
//============================================================================


struct  S_BFu8i_BFu1i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:1;
};
//SIG(1 S_BFu8i_BFu1i) C1{ Fs Fi:8 Fi:1}



static void Test_S_BFu8i_BFu1i()
{
  {
    init_simple_test("S_BFu8i_BFu1i");
    static STRUCT_IF_C S_BFu8i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu1i, S_BFu8i_BFu1i)
//============================================================================


struct  S_BFu8i_BFu1ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:1;
};
//SIG(1 S_BFu8i_BFu1ll) C1{ Fs Fi:8 FL:1}



static void Test_S_BFu8i_BFu1ll()
{
  {
    init_simple_test("S_BFu8i_BFu1ll");
    static STRUCT_IF_C S_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu1ll, S_BFu8i_BFu1ll)
//============================================================================


struct  S_BFu8i_BFu1s  {
  short v1;
  unsigned int v2:8;
  unsigned short v3:1;
};
//SIG(1 S_BFu8i_BFu1s) C1{ Fs Fi:8 Fs:1}



static void Test_S_BFu8i_BFu1s()
{
  {
    init_simple_test("S_BFu8i_BFu1s");
    static STRUCT_IF_C S_BFu8i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu1s, S_BFu8i_BFu1s)
//============================================================================


struct  S_BFu8i_BFu31i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:31;
};
//SIG(1 S_BFu8i_BFu31i) C1{ Fs Fi:8 Fi:31}



static void Test_S_BFu8i_BFu31i()
{
  {
    init_simple_test("S_BFu8i_BFu31i");
    static STRUCT_IF_C S_BFu8i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu31i, S_BFu8i_BFu31i)
//============================================================================


struct  S_BFu8i_BFu31ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 S_BFu8i_BFu31ll) C1{ Fs Fi:8 FL:31}



static void Test_S_BFu8i_BFu31ll()
{
  {
    init_simple_test("S_BFu8i_BFu31ll");
    static STRUCT_IF_C S_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "S_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "S_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu31ll, S_BFu8i_BFu31ll)
//============================================================================


struct  S_BFu8i_BFu32i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 S_BFu8i_BFu32i) C1{ Fs Fi:8 Fi:32}



static void Test_S_BFu8i_BFu32i()
{
  {
    init_simple_test("S_BFu8i_BFu32i");
    static STRUCT_IF_C S_BFu8i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu32i, S_BFu8i_BFu32i)
//============================================================================


struct  S_BFu8i_BFu32ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 S_BFu8i_BFu32ll) C1{ Fs Fi:8 FL:32}



static void Test_S_BFu8i_BFu32ll()
{
  {
    init_simple_test("S_BFu8i_BFu32ll");
    static STRUCT_IF_C S_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "S_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "S_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu32ll, S_BFu8i_BFu32ll)
//============================================================================


struct  S_BFu8i_BFu33  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 S_BFu8i_BFu33) C1{ Fs Fi:8 FL:33}



static void Test_S_BFu8i_BFu33()
{
  {
    init_simple_test("S_BFu8i_BFu33");
    static STRUCT_IF_C S_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "S_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "S_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu33, S_BFu8i_BFu33)
//============================================================================


struct  S_BFu8i_BFu7c  {
  short v1;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 S_BFu8i_BFu7c) C1{ Fs Fi:8 Fc:7}



static void Test_S_BFu8i_BFu7c()
{
  {
    init_simple_test("S_BFu8i_BFu7c");
    static STRUCT_IF_C S_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu7c, S_BFu8i_BFu7c)
//============================================================================


struct  S_BFu8i_BFu7i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 S_BFu8i_BFu7i) C1{ Fs Fi:8 Fi:7}



static void Test_S_BFu8i_BFu7i()
{
  {
    init_simple_test("S_BFu8i_BFu7i");
    static STRUCT_IF_C S_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu7i, S_BFu8i_BFu7i)
//============================================================================


struct  S_BFu8i_BFu7ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 S_BFu8i_BFu7ll) C1{ Fs Fi:8 FL:7}



static void Test_S_BFu8i_BFu7ll()
{
  {
    init_simple_test("S_BFu8i_BFu7ll");
    static STRUCT_IF_C S_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu7ll, S_BFu8i_BFu7ll)
//============================================================================


struct  S_BFu8i_BFu7s  {
  short v1;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 S_BFu8i_BFu7s) C1{ Fs Fi:8 Fs:7}



static void Test_S_BFu8i_BFu7s()
{
  {
    init_simple_test("S_BFu8i_BFu7s");
    static STRUCT_IF_C S_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu7s, S_BFu8i_BFu7s)
//============================================================================


struct  S_BFu8i_BFu8c  {
  short v1;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 S_BFu8i_BFu8c) C1{ Fs Fi:8 Fc:8}



static void Test_S_BFu8i_BFu8c()
{
  {
    init_simple_test("S_BFu8i_BFu8c");
    static STRUCT_IF_C S_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu8c, S_BFu8i_BFu8c)
//============================================================================


struct  S_BFu8i_BFu8i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 S_BFu8i_BFu8i) C1{ Fs Fi:8 Fi:8}



static void Test_S_BFu8i_BFu8i()
{
  {
    init_simple_test("S_BFu8i_BFu8i");
    static STRUCT_IF_C S_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu8i, S_BFu8i_BFu8i)
//============================================================================


struct  S_BFu8i_BFu8ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 S_BFu8i_BFu8ll) C1{ Fs Fi:8 FL:8}



static void Test_S_BFu8i_BFu8ll()
{
  {
    init_simple_test("S_BFu8i_BFu8ll");
    static STRUCT_IF_C S_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu8ll, S_BFu8i_BFu8ll)
//============================================================================


struct  S_BFu8i_BFu8s  {
  short v1;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 S_BFu8i_BFu8s) C1{ Fs Fi:8 Fs:8}



static void Test_S_BFu8i_BFu8s()
{
  {
    init_simple_test("S_BFu8i_BFu8s");
    static STRUCT_IF_C S_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu8s, S_BFu8i_BFu8s)
//============================================================================


struct  S_BFu8i_BFu9i  {
  short v1;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 S_BFu8i_BFu9i) C1{ Fs Fi:8 Fi:9}



static void Test_S_BFu8i_BFu9i()
{
  {
    init_simple_test("S_BFu8i_BFu9i");
    static STRUCT_IF_C S_BFu8i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu9i, S_BFu8i_BFu9i)
//============================================================================


struct  S_BFu8i_BFu9ll  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 S_BFu8i_BFu9ll) C1{ Fs Fi:8 FL:9}



static void Test_S_BFu8i_BFu9ll()
{
  {
    init_simple_test("S_BFu8i_BFu9ll");
    static STRUCT_IF_C S_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "S_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "S_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu9ll, S_BFu8i_BFu9ll)
//============================================================================


struct  S_BFu8i_BFu9s  {
  short v1;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 S_BFu8i_BFu9s) C1{ Fs Fi:8 Fs:9}



static void Test_S_BFu8i_BFu9s()
{
  {
    init_simple_test("S_BFu8i_BFu9s");
    static STRUCT_IF_C S_BFu8i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_BFu9s, S_BFu8i_BFu9s)
//============================================================================


struct  S_BFu8i_C  {
  short v1;
  unsigned int v2:8;
  char v3;
};
//SIG(1 S_BFu8i_C) C1{ Fs Fi:8 Fc}



static void Test_S_BFu8i_C()
{
  {
    init_simple_test("S_BFu8i_C");
    static STRUCT_IF_C S_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_C)");
    check_field_offset(lv, v1, 0, "S_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_C");
    check_field_offset(lv, v3, 3, "S_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_C, S_BFu8i_C)
//============================================================================


struct  S_BFu8i_D  {
  short v1;
  unsigned int v2:8;
  double v3;
};
//SIG(1 S_BFu8i_D) C1{ Fs Fi:8 FL}



static void Test_S_BFu8i_D()
{
  {
    init_simple_test("S_BFu8i_D");
    static STRUCT_IF_C S_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_D)");
    check_field_offset(lv, v1, 0, "S_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_D, S_BFu8i_D)
//============================================================================


struct  S_BFu8i_F  {
  short v1;
  unsigned int v2:8;
  float v3;
};
//SIG(1 S_BFu8i_F) C1{ Fs Fi:8 Fi}



static void Test_S_BFu8i_F()
{
  {
    init_simple_test("S_BFu8i_F");
    static STRUCT_IF_C S_BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_F)");
    check_field_offset(lv, v1, 0, "S_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_F");
    check_field_offset(lv, v3, 4, "S_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_F, S_BFu8i_F)
//============================================================================


struct  S_BFu8i_I  {
  short v1;
  unsigned int v2:8;
  int v3;
};
//SIG(1 S_BFu8i_I) C1{ Fs Fi:8 Fi}



static void Test_S_BFu8i_I()
{
  {
    init_simple_test("S_BFu8i_I");
    static STRUCT_IF_C S_BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_I)");
    check_field_offset(lv, v1, 0, "S_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_I");
    check_field_offset(lv, v3, 4, "S_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_I, S_BFu8i_I)
//============================================================================


struct  S_BFu8i_Ip  {
  short v1;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 S_BFu8i_Ip) C1{ Fs Fi:8 Fp}



static void Test_S_BFu8i_Ip()
{
  {
    init_simple_test("S_BFu8i_Ip");
    static STRUCT_IF_C S_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_Ip, S_BFu8i_Ip)
//============================================================================


struct  S_BFu8i_L  {
  short v1;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 S_BFu8i_L) C1{ Fs Fi:8 FL}



static void Test_S_BFu8i_L()
{
  {
    init_simple_test("S_BFu8i_L");
    static STRUCT_IF_C S_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_L)");
    check_field_offset(lv, v1, 0, "S_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_L, S_BFu8i_L)
//============================================================================


struct  S_BFu8i_S  {
  short v1;
  unsigned int v2:8;
  short v3;
};
//SIG(1 S_BFu8i_S) C1{ Fs Fi:8 Fs}



static void Test_S_BFu8i_S()
{
  {
    init_simple_test("S_BFu8i_S");
    static STRUCT_IF_C S_BFu8i_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_S)");
    check_field_offset(lv, v1, 0, "S_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_S");
    check_field_offset(lv, v3, 4, "S_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_S, S_BFu8i_S)
//============================================================================


struct  S_BFu8i_Uc  {
  short v1;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 S_BFu8i_Uc) C1{ Fs Fi:8 Fc}



static void Test_S_BFu8i_Uc()
{
  {
    init_simple_test("S_BFu8i_Uc");
    static STRUCT_IF_C S_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_Uc");
    check_field_offset(lv, v3, 3, "S_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_Uc, S_BFu8i_Uc)
//============================================================================


struct  S_BFu8i_Ui  {
  short v1;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 S_BFu8i_Ui) C1{ Fs Fi:8 Fi}



static void Test_S_BFu8i_Ui()
{
  {
    init_simple_test("S_BFu8i_Ui");
    static STRUCT_IF_C S_BFu8i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_Ui");
    check_field_offset(lv, v3, 4, "S_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_Ui, S_BFu8i_Ui)
//============================================================================


struct  S_BFu8i_Ul  {
  short v1;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 S_BFu8i_Ul) C1{ Fs Fi:8 FL}



static void Test_S_BFu8i_Ul()
{
  {
    init_simple_test("S_BFu8i_Ul");
    static STRUCT_IF_C S_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_Ul, S_BFu8i_Ul)
//============================================================================


struct  S_BFu8i_Us  {
  short v1;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 S_BFu8i_Us) C1{ Fs Fi:8 Fs}



static void Test_S_BFu8i_Us()
{
  {
    init_simple_test("S_BFu8i_Us");
    static STRUCT_IF_C S_BFu8i_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_Us");
    check_field_offset(lv, v3, 4, "S_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_Us, S_BFu8i_Us)
//============================================================================


struct  S_BFu8i_Vp  {
  short v1;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 S_BFu8i_Vp) C1{ Fs Fi:8 Fp}



static void Test_S_BFu8i_Vp()
{
  {
    init_simple_test("S_BFu8i_Vp");
    static STRUCT_IF_C S_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8i_Vp, S_BFu8i_Vp)
//============================================================================


struct  S_BFu8ll  {
  short v1;
  __tsu64 v2:8;
};
//SIG(1 S_BFu8ll) C1{ Fs FL:8}



static void Test_S_BFu8ll()
{
  {
    init_simple_test("S_BFu8ll");
    static STRUCT_IF_C S_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll, S_BFu8ll)
//============================================================================


struct  S_BFu8ll_BFu15i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 S_BFu8ll_BFu15i) C1{ Fs FL:8 Fi:15}



static void Test_S_BFu8ll_BFu15i()
{
  {
    init_simple_test("S_BFu8ll_BFu15i");
    static STRUCT_IF_C S_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu15i, S_BFu8ll_BFu15i)
//============================================================================


struct  S_BFu8ll_BFu15ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 S_BFu8ll_BFu15ll) C1{ Fs FL:8 FL:15}



static void Test_S_BFu8ll_BFu15ll()
{
  {
    init_simple_test("S_BFu8ll_BFu15ll");
    static STRUCT_IF_C S_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "S_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "S_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu15ll, S_BFu8ll_BFu15ll)
//============================================================================


struct  S_BFu8ll_BFu15s  {
  short v1;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 S_BFu8ll_BFu15s) C1{ Fs FL:8 Fs:15}



static void Test_S_BFu8ll_BFu15s()
{
  {
    init_simple_test("S_BFu8ll_BFu15s");
    static STRUCT_IF_C S_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu15s, S_BFu8ll_BFu15s)
//============================================================================


struct  S_BFu8ll_BFu16i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 S_BFu8ll_BFu16i) C1{ Fs FL:8 Fi:16}



static void Test_S_BFu8ll_BFu16i()
{
  {
    init_simple_test("S_BFu8ll_BFu16i");
    static STRUCT_IF_C S_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu16i, S_BFu8ll_BFu16i)
//============================================================================


struct  S_BFu8ll_BFu16ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 S_BFu8ll_BFu16ll) C1{ Fs FL:8 FL:16}



static void Test_S_BFu8ll_BFu16ll()
{
  {
    init_simple_test("S_BFu8ll_BFu16ll");
    static STRUCT_IF_C S_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "S_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "S_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu16ll, S_BFu8ll_BFu16ll)
//============================================================================


struct  S_BFu8ll_BFu16s  {
  short v1;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 S_BFu8ll_BFu16s) C1{ Fs FL:8 Fs:16}



static void Test_S_BFu8ll_BFu16s()
{
  {
    init_simple_test("S_BFu8ll_BFu16s");
    static STRUCT_IF_C S_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu16s, S_BFu8ll_BFu16s)
//============================================================================


struct  S_BFu8ll_BFu17i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 S_BFu8ll_BFu17i) C1{ Fs FL:8 Fi:17}



static void Test_S_BFu8ll_BFu17i()
{
  {
    init_simple_test("S_BFu8ll_BFu17i");
    static STRUCT_IF_C S_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu17i, S_BFu8ll_BFu17i)
//============================================================================


struct  S_BFu8ll_BFu17ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 S_BFu8ll_BFu17ll) C1{ Fs FL:8 FL:17}



static void Test_S_BFu8ll_BFu17ll()
{
  {
    init_simple_test("S_BFu8ll_BFu17ll");
    static STRUCT_IF_C S_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "S_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "S_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu17ll, S_BFu8ll_BFu17ll)
//============================================================================


struct  S_BFu8ll_BFu1c  {
  short v1;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 S_BFu8ll_BFu1c) C1{ Fs FL:8 Fc:1}



static void Test_S_BFu8ll_BFu1c()
{
  {
    init_simple_test("S_BFu8ll_BFu1c");
    static STRUCT_IF_C S_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu1c, S_BFu8ll_BFu1c)
//============================================================================


struct  S_BFu8ll_BFu1i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 S_BFu8ll_BFu1i) C1{ Fs FL:8 Fi:1}



static void Test_S_BFu8ll_BFu1i()
{
  {
    init_simple_test("S_BFu8ll_BFu1i");
    static STRUCT_IF_C S_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu1i, S_BFu8ll_BFu1i)
//============================================================================


struct  S_BFu8ll_BFu1ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 S_BFu8ll_BFu1ll) C1{ Fs FL:8 FL:1}



static void Test_S_BFu8ll_BFu1ll()
{
  {
    init_simple_test("S_BFu8ll_BFu1ll");
    static STRUCT_IF_C S_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu1ll, S_BFu8ll_BFu1ll)
//============================================================================


struct  S_BFu8ll_BFu1s  {
  short v1;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 S_BFu8ll_BFu1s) C1{ Fs FL:8 Fs:1}



static void Test_S_BFu8ll_BFu1s()
{
  {
    init_simple_test("S_BFu8ll_BFu1s");
    static STRUCT_IF_C S_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu1s, S_BFu8ll_BFu1s)
//============================================================================


struct  S_BFu8ll_BFu31i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 S_BFu8ll_BFu31i) C1{ Fs FL:8 Fi:31}



static void Test_S_BFu8ll_BFu31i()
{
  {
    init_simple_test("S_BFu8ll_BFu31i");
    static STRUCT_IF_C S_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu31i, S_BFu8ll_BFu31i)
//============================================================================


struct  S_BFu8ll_BFu31ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 S_BFu8ll_BFu31ll) C1{ Fs FL:8 FL:31}



static void Test_S_BFu8ll_BFu31ll()
{
  {
    init_simple_test("S_BFu8ll_BFu31ll");
    static STRUCT_IF_C S_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "S_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "S_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu31ll, S_BFu8ll_BFu31ll)
//============================================================================


struct  S_BFu8ll_BFu32i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 S_BFu8ll_BFu32i) C1{ Fs FL:8 Fi:32}



static void Test_S_BFu8ll_BFu32i()
{
  {
    init_simple_test("S_BFu8ll_BFu32i");
    static STRUCT_IF_C S_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu32i, S_BFu8ll_BFu32i)
//============================================================================


struct  S_BFu8ll_BFu32ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 S_BFu8ll_BFu32ll) C1{ Fs FL:8 FL:32}



static void Test_S_BFu8ll_BFu32ll()
{
  {
    init_simple_test("S_BFu8ll_BFu32ll");
    static STRUCT_IF_C S_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "S_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "S_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu32ll, S_BFu8ll_BFu32ll)
//============================================================================


struct  S_BFu8ll_BFu33  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 S_BFu8ll_BFu33) C1{ Fs FL:8 FL:33}



static void Test_S_BFu8ll_BFu33()
{
  {
    init_simple_test("S_BFu8ll_BFu33");
    static STRUCT_IF_C S_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "S_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "S_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu33, S_BFu8ll_BFu33)
//============================================================================


struct  S_BFu8ll_BFu7c  {
  short v1;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 S_BFu8ll_BFu7c) C1{ Fs FL:8 Fc:7}



static void Test_S_BFu8ll_BFu7c()
{
  {
    init_simple_test("S_BFu8ll_BFu7c");
    static STRUCT_IF_C S_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu7c, S_BFu8ll_BFu7c)
//============================================================================


struct  S_BFu8ll_BFu7i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 S_BFu8ll_BFu7i) C1{ Fs FL:8 Fi:7}



static void Test_S_BFu8ll_BFu7i()
{
  {
    init_simple_test("S_BFu8ll_BFu7i");
    static STRUCT_IF_C S_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu7i, S_BFu8ll_BFu7i)
//============================================================================


struct  S_BFu8ll_BFu7ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 S_BFu8ll_BFu7ll) C1{ Fs FL:8 FL:7}



static void Test_S_BFu8ll_BFu7ll()
{
  {
    init_simple_test("S_BFu8ll_BFu7ll");
    static STRUCT_IF_C S_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu7ll, S_BFu8ll_BFu7ll)
//============================================================================


struct  S_BFu8ll_BFu7s  {
  short v1;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 S_BFu8ll_BFu7s) C1{ Fs FL:8 Fs:7}



static void Test_S_BFu8ll_BFu7s()
{
  {
    init_simple_test("S_BFu8ll_BFu7s");
    static STRUCT_IF_C S_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu7s, S_BFu8ll_BFu7s)
//============================================================================


struct  S_BFu8ll_BFu8c  {
  short v1;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 S_BFu8ll_BFu8c) C1{ Fs FL:8 Fc:8}



static void Test_S_BFu8ll_BFu8c()
{
  {
    init_simple_test("S_BFu8ll_BFu8c");
    static STRUCT_IF_C S_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu8c, S_BFu8ll_BFu8c)
//============================================================================


struct  S_BFu8ll_BFu8i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 S_BFu8ll_BFu8i) C1{ Fs FL:8 Fi:8}



static void Test_S_BFu8ll_BFu8i()
{
  {
    init_simple_test("S_BFu8ll_BFu8i");
    static STRUCT_IF_C S_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu8i, S_BFu8ll_BFu8i)
//============================================================================


struct  S_BFu8ll_BFu8ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 S_BFu8ll_BFu8ll) C1{ Fs FL:8 FL:8}



static void Test_S_BFu8ll_BFu8ll()
{
  {
    init_simple_test("S_BFu8ll_BFu8ll");
    static STRUCT_IF_C S_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu8ll, S_BFu8ll_BFu8ll)
//============================================================================


struct  S_BFu8ll_BFu8s  {
  short v1;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 S_BFu8ll_BFu8s) C1{ Fs FL:8 Fs:8}



static void Test_S_BFu8ll_BFu8s()
{
  {
    init_simple_test("S_BFu8ll_BFu8s");
    static STRUCT_IF_C S_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu8s, S_BFu8ll_BFu8s)
//============================================================================


struct  S_BFu8ll_BFu9i  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 S_BFu8ll_BFu9i) C1{ Fs FL:8 Fi:9}



static void Test_S_BFu8ll_BFu9i()
{
  {
    init_simple_test("S_BFu8ll_BFu9i");
    static STRUCT_IF_C S_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu9i, S_BFu8ll_BFu9i)
//============================================================================


struct  S_BFu8ll_BFu9ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 S_BFu8ll_BFu9ll) C1{ Fs FL:8 FL:9}



static void Test_S_BFu8ll_BFu9ll()
{
  {
    init_simple_test("S_BFu8ll_BFu9ll");
    static STRUCT_IF_C S_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "S_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "S_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu9ll, S_BFu8ll_BFu9ll)
//============================================================================


struct  S_BFu8ll_BFu9s  {
  short v1;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 S_BFu8ll_BFu9s) C1{ Fs FL:8 Fs:9}



static void Test_S_BFu8ll_BFu9s()
{
  {
    init_simple_test("S_BFu8ll_BFu9s");
    static STRUCT_IF_C S_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_BFu9s, S_BFu8ll_BFu9s)
//============================================================================


struct  S_BFu8ll_C  {
  short v1;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 S_BFu8ll_C) C1{ Fs FL:8 Fc}



static void Test_S_BFu8ll_C()
{
  {
    init_simple_test("S_BFu8ll_C");
    static STRUCT_IF_C S_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_C");
    check_field_offset(lv, v3, 3, "S_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_C, S_BFu8ll_C)
//============================================================================


struct  S_BFu8ll_D  {
  short v1;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 S_BFu8ll_D) C1{ Fs FL:8 FL}



static void Test_S_BFu8ll_D()
{
  {
    init_simple_test("S_BFu8ll_D");
    static STRUCT_IF_C S_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_D, S_BFu8ll_D)
//============================================================================


struct  S_BFu8ll_F  {
  short v1;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 S_BFu8ll_F) C1{ Fs FL:8 Fi}



static void Test_S_BFu8ll_F()
{
  {
    init_simple_test("S_BFu8ll_F");
    static STRUCT_IF_C S_BFu8ll_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_F");
    check_field_offset(lv, v3, 4, "S_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_F, S_BFu8ll_F)
//============================================================================


struct  S_BFu8ll_I  {
  short v1;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 S_BFu8ll_I) C1{ Fs FL:8 Fi}



static void Test_S_BFu8ll_I()
{
  {
    init_simple_test("S_BFu8ll_I");
    static STRUCT_IF_C S_BFu8ll_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_I");
    check_field_offset(lv, v3, 4, "S_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_I, S_BFu8ll_I)
//============================================================================


struct  S_BFu8ll_Ip  {
  short v1;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 S_BFu8ll_Ip) C1{ Fs FL:8 Fp}



static void Test_S_BFu8ll_Ip()
{
  {
    init_simple_test("S_BFu8ll_Ip");
    static STRUCT_IF_C S_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_Ip, S_BFu8ll_Ip)
//============================================================================


struct  S_BFu8ll_L  {
  short v1;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 S_BFu8ll_L) C1{ Fs FL:8 FL}



static void Test_S_BFu8ll_L()
{
  {
    init_simple_test("S_BFu8ll_L");
    static STRUCT_IF_C S_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_L, S_BFu8ll_L)
//============================================================================


struct  S_BFu8ll_S  {
  short v1;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 S_BFu8ll_S) C1{ Fs FL:8 Fs}



static void Test_S_BFu8ll_S()
{
  {
    init_simple_test("S_BFu8ll_S");
    static STRUCT_IF_C S_BFu8ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_S");
    check_field_offset(lv, v3, 4, "S_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_S, S_BFu8ll_S)
//============================================================================


struct  S_BFu8ll_Uc  {
  short v1;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 S_BFu8ll_Uc) C1{ Fs FL:8 Fc}



static void Test_S_BFu8ll_Uc()
{
  {
    init_simple_test("S_BFu8ll_Uc");
    static STRUCT_IF_C S_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_Uc");
    check_field_offset(lv, v3, 3, "S_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_Uc, S_BFu8ll_Uc)
//============================================================================


struct  S_BFu8ll_Ui  {
  short v1;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 S_BFu8ll_Ui) C1{ Fs FL:8 Fi}



static void Test_S_BFu8ll_Ui()
{
  {
    init_simple_test("S_BFu8ll_Ui");
    static STRUCT_IF_C S_BFu8ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_Ui");
    check_field_offset(lv, v3, 4, "S_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_Ui, S_BFu8ll_Ui)
//============================================================================


struct  S_BFu8ll_Ul  {
  short v1;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 S_BFu8ll_Ul) C1{ Fs FL:8 FL}



static void Test_S_BFu8ll_Ul()
{
  {
    init_simple_test("S_BFu8ll_Ul");
    static STRUCT_IF_C S_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_Ul, S_BFu8ll_Ul)
//============================================================================


struct  S_BFu8ll_Us  {
  short v1;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 S_BFu8ll_Us) C1{ Fs FL:8 Fs}



static void Test_S_BFu8ll_Us()
{
  {
    init_simple_test("S_BFu8ll_Us");
    static STRUCT_IF_C S_BFu8ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_Us");
    check_field_offset(lv, v3, 4, "S_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_Us, S_BFu8ll_Us)
//============================================================================


struct  S_BFu8ll_Vp  {
  short v1;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 S_BFu8ll_Vp) C1{ Fs FL:8 Fp}



static void Test_S_BFu8ll_Vp()
{
  {
    init_simple_test("S_BFu8ll_Vp");
    static STRUCT_IF_C S_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8ll_Vp, S_BFu8ll_Vp)
//============================================================================


struct  S_BFu8s  {
  short v1;
  unsigned short v2:8;
};
//SIG(1 S_BFu8s) C1{ Fs Fs:8}



static void Test_S_BFu8s()
{
  {
    init_simple_test("S_BFu8s");
    static STRUCT_IF_C S_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s, S_BFu8s)
//============================================================================


struct  S_BFu8s_BFu15i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 S_BFu8s_BFu15i) C1{ Fs Fs:8 Fi:15}



static void Test_S_BFu8s_BFu15i()
{
  {
    init_simple_test("S_BFu8s_BFu15i");
    static STRUCT_IF_C S_BFu8s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu15i, S_BFu8s_BFu15i)
//============================================================================


struct  S_BFu8s_BFu15ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 S_BFu8s_BFu15ll) C1{ Fs Fs:8 FL:15}



static void Test_S_BFu8s_BFu15ll()
{
  {
    init_simple_test("S_BFu8s_BFu15ll");
    static STRUCT_IF_C S_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "S_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "S_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu15ll, S_BFu8s_BFu15ll)
//============================================================================


struct  S_BFu8s_BFu15s  {
  short v1;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 S_BFu8s_BFu15s) C1{ Fs Fs:8 Fs:15}



static void Test_S_BFu8s_BFu15s()
{
  {
    init_simple_test("S_BFu8s_BFu15s");
    static STRUCT_IF_C S_BFu8s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu15s, S_BFu8s_BFu15s)
//============================================================================


struct  S_BFu8s_BFu16i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 S_BFu8s_BFu16i) C1{ Fs Fs:8 Fi:16}



static void Test_S_BFu8s_BFu16i()
{
  {
    init_simple_test("S_BFu8s_BFu16i");
    static STRUCT_IF_C S_BFu8s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu16i, S_BFu8s_BFu16i)
//============================================================================


struct  S_BFu8s_BFu16ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 S_BFu8s_BFu16ll) C1{ Fs Fs:8 FL:16}



static void Test_S_BFu8s_BFu16ll()
{
  {
    init_simple_test("S_BFu8s_BFu16ll");
    static STRUCT_IF_C S_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "S_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "S_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu16ll, S_BFu8s_BFu16ll)
//============================================================================


struct  S_BFu8s_BFu16s  {
  short v1;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 S_BFu8s_BFu16s) C1{ Fs Fs:8 Fs:16}



static void Test_S_BFu8s_BFu16s()
{
  {
    init_simple_test("S_BFu8s_BFu16s");
    static STRUCT_IF_C S_BFu8s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu16s, S_BFu8s_BFu16s)
//============================================================================


struct  S_BFu8s_BFu17i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 S_BFu8s_BFu17i) C1{ Fs Fs:8 Fi:17}



static void Test_S_BFu8s_BFu17i()
{
  {
    init_simple_test("S_BFu8s_BFu17i");
    static STRUCT_IF_C S_BFu8s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu17i, S_BFu8s_BFu17i)
//============================================================================


struct  S_BFu8s_BFu17ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 S_BFu8s_BFu17ll) C1{ Fs Fs:8 FL:17}



static void Test_S_BFu8s_BFu17ll()
{
  {
    init_simple_test("S_BFu8s_BFu17ll");
    static STRUCT_IF_C S_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "S_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "S_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu17ll, S_BFu8s_BFu17ll)
//============================================================================


struct  S_BFu8s_BFu1c  {
  short v1;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 S_BFu8s_BFu1c) C1{ Fs Fs:8 Fc:1}



static void Test_S_BFu8s_BFu1c()
{
  {
    init_simple_test("S_BFu8s_BFu1c");
    static STRUCT_IF_C S_BFu8s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu1c, S_BFu8s_BFu1c)
//============================================================================


struct  S_BFu8s_BFu1i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 S_BFu8s_BFu1i) C1{ Fs Fs:8 Fi:1}



static void Test_S_BFu8s_BFu1i()
{
  {
    init_simple_test("S_BFu8s_BFu1i");
    static STRUCT_IF_C S_BFu8s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu1i, S_BFu8s_BFu1i)
//============================================================================


struct  S_BFu8s_BFu1ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 S_BFu8s_BFu1ll) C1{ Fs Fs:8 FL:1}



static void Test_S_BFu8s_BFu1ll()
{
  {
    init_simple_test("S_BFu8s_BFu1ll");
    static STRUCT_IF_C S_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu1ll, S_BFu8s_BFu1ll)
//============================================================================


struct  S_BFu8s_BFu1s  {
  short v1;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 S_BFu8s_BFu1s) C1{ Fs Fs:8 Fs:1}



static void Test_S_BFu8s_BFu1s()
{
  {
    init_simple_test("S_BFu8s_BFu1s");
    static STRUCT_IF_C S_BFu8s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "S_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu1s, S_BFu8s_BFu1s)
//============================================================================


struct  S_BFu8s_BFu31i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 S_BFu8s_BFu31i) C1{ Fs Fs:8 Fi:31}



static void Test_S_BFu8s_BFu31i()
{
  {
    init_simple_test("S_BFu8s_BFu31i");
    static STRUCT_IF_C S_BFu8s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu31i, S_BFu8s_BFu31i)
//============================================================================


struct  S_BFu8s_BFu31ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 S_BFu8s_BFu31ll) C1{ Fs Fs:8 FL:31}



static void Test_S_BFu8s_BFu31ll()
{
  {
    init_simple_test("S_BFu8s_BFu31ll");
    static STRUCT_IF_C S_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "S_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "S_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu31ll, S_BFu8s_BFu31ll)
//============================================================================


struct  S_BFu8s_BFu32i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 S_BFu8s_BFu32i) C1{ Fs Fs:8 Fi:32}



static void Test_S_BFu8s_BFu32i()
{
  {
    init_simple_test("S_BFu8s_BFu32i");
    static STRUCT_IF_C S_BFu8s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu32i, S_BFu8s_BFu32i)
//============================================================================


struct  S_BFu8s_BFu32ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 S_BFu8s_BFu32ll) C1{ Fs Fs:8 FL:32}



static void Test_S_BFu8s_BFu32ll()
{
  {
    init_simple_test("S_BFu8s_BFu32ll");
    static STRUCT_IF_C S_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "S_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "S_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu32ll, S_BFu8s_BFu32ll)
//============================================================================


struct  S_BFu8s_BFu33  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:33;
};
//SIG(1 S_BFu8s_BFu33) C1{ Fs Fs:8 FL:33}



static void Test_S_BFu8s_BFu33()
{
  {
    init_simple_test("S_BFu8s_BFu33");
    static STRUCT_IF_C S_BFu8s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "S_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "S_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu33, S_BFu8s_BFu33)
//============================================================================


struct  S_BFu8s_BFu7c  {
  short v1;
  unsigned short v2:8;
  unsigned char v3:7;
};
//SIG(1 S_BFu8s_BFu7c) C1{ Fs Fs:8 Fc:7}



static void Test_S_BFu8s_BFu7c()
{
  {
    init_simple_test("S_BFu8s_BFu7c");
    static STRUCT_IF_C S_BFu8s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu7c, S_BFu8s_BFu7c)
//============================================================================


struct  S_BFu8s_BFu7i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:7;
};
//SIG(1 S_BFu8s_BFu7i) C1{ Fs Fs:8 Fi:7}



static void Test_S_BFu8s_BFu7i()
{
  {
    init_simple_test("S_BFu8s_BFu7i");
    static STRUCT_IF_C S_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu7i, S_BFu8s_BFu7i)
//============================================================================


struct  S_BFu8s_BFu7ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 S_BFu8s_BFu7ll) C1{ Fs Fs:8 FL:7}



static void Test_S_BFu8s_BFu7ll()
{
  {
    init_simple_test("S_BFu8s_BFu7ll");
    static STRUCT_IF_C S_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu7ll, S_BFu8s_BFu7ll)
//============================================================================


struct  S_BFu8s_BFu7s  {
  short v1;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 S_BFu8s_BFu7s) C1{ Fs Fs:8 Fs:7}



static void Test_S_BFu8s_BFu7s()
{
  {
    init_simple_test("S_BFu8s_BFu7s");
    static STRUCT_IF_C S_BFu8s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "S_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "S_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu7s, S_BFu8s_BFu7s)
//============================================================================


struct  S_BFu8s_BFu8c  {
  short v1;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 S_BFu8s_BFu8c) C1{ Fs Fs:8 Fc:8}



static void Test_S_BFu8s_BFu8c()
{
  {
    init_simple_test("S_BFu8s_BFu8c");
    static STRUCT_IF_C S_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu8c, S_BFu8s_BFu8c)
//============================================================================


struct  S_BFu8s_BFu8i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 S_BFu8s_BFu8i) C1{ Fs Fs:8 Fi:8}



static void Test_S_BFu8s_BFu8i()
{
  {
    init_simple_test("S_BFu8s_BFu8i");
    static STRUCT_IF_C S_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu8i, S_BFu8s_BFu8i)
//============================================================================


struct  S_BFu8s_BFu8ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 S_BFu8s_BFu8ll) C1{ Fs Fs:8 FL:8}



static void Test_S_BFu8s_BFu8ll()
{
  {
    init_simple_test("S_BFu8s_BFu8ll");
    static STRUCT_IF_C S_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu8ll, S_BFu8s_BFu8ll)
//============================================================================


struct  S_BFu8s_BFu8s  {
  short v1;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 S_BFu8s_BFu8s) C1{ Fs Fs:8 Fs:8}



static void Test_S_BFu8s_BFu8s()
{
  {
    init_simple_test("S_BFu8s_BFu8s");
    static STRUCT_IF_C S_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "S_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu8s, S_BFu8s_BFu8s)
//============================================================================


struct  S_BFu8s_BFu9i  {
  short v1;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 S_BFu8s_BFu9i) C1{ Fs Fs:8 Fi:9}



static void Test_S_BFu8s_BFu9i()
{
  {
    init_simple_test("S_BFu8s_BFu9i");
    static STRUCT_IF_C S_BFu8s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu9i, S_BFu8s_BFu9i)
//============================================================================


struct  S_BFu8s_BFu9ll  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 S_BFu8s_BFu9ll) C1{ Fs Fs:8 FL:9}



static void Test_S_BFu8s_BFu9ll()
{
  {
    init_simple_test("S_BFu8s_BFu9ll");
    static STRUCT_IF_C S_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "S_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "S_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu9ll, S_BFu8s_BFu9ll)
//============================================================================


struct  S_BFu8s_BFu9s  {
  short v1;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 S_BFu8s_BFu9s) C1{ Fs Fs:8 Fs:9}



static void Test_S_BFu8s_BFu9s()
{
  {
    init_simple_test("S_BFu8s_BFu9s");
    static STRUCT_IF_C S_BFu8s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_BFu9s, S_BFu8s_BFu9s)
//============================================================================


struct  S_BFu8s_C  {
  short v1;
  unsigned short v2:8;
  char v3;
};
//SIG(1 S_BFu8s_C) C1{ Fs Fs:8 Fc}



static void Test_S_BFu8s_C()
{
  {
    init_simple_test("S_BFu8s_C");
    static STRUCT_IF_C S_BFu8s_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_C)");
    check_field_offset(lv, v1, 0, "S_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_C");
    check_field_offset(lv, v3, 3, "S_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_C, S_BFu8s_C)
//============================================================================


struct  S_BFu8s_D  {
  short v1;
  unsigned short v2:8;
  double v3;
};
//SIG(1 S_BFu8s_D) C1{ Fs Fs:8 FL}



static void Test_S_BFu8s_D()
{
  {
    init_simple_test("S_BFu8s_D");
    static STRUCT_IF_C S_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_D)");
    check_field_offset(lv, v1, 0, "S_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_D, S_BFu8s_D)
//============================================================================


struct  S_BFu8s_F  {
  short v1;
  unsigned short v2:8;
  float v3;
};
//SIG(1 S_BFu8s_F) C1{ Fs Fs:8 Fi}



static void Test_S_BFu8s_F()
{
  {
    init_simple_test("S_BFu8s_F");
    static STRUCT_IF_C S_BFu8s_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_F)");
    check_field_offset(lv, v1, 0, "S_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_F");
    check_field_offset(lv, v3, 4, "S_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_F, S_BFu8s_F)
//============================================================================


struct  S_BFu8s_I  {
  short v1;
  unsigned short v2:8;
  int v3;
};
//SIG(1 S_BFu8s_I) C1{ Fs Fs:8 Fi}



static void Test_S_BFu8s_I()
{
  {
    init_simple_test("S_BFu8s_I");
    static STRUCT_IF_C S_BFu8s_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_I)");
    check_field_offset(lv, v1, 0, "S_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_I");
    check_field_offset(lv, v3, 4, "S_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_I, S_BFu8s_I)
//============================================================================


struct  S_BFu8s_Ip  {
  short v1;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 S_BFu8s_Ip) C1{ Fs Fs:8 Fp}



static void Test_S_BFu8s_Ip()
{
  {
    init_simple_test("S_BFu8s_Ip");
    static STRUCT_IF_C S_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_Ip, S_BFu8s_Ip)
//============================================================================


struct  S_BFu8s_L  {
  short v1;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 S_BFu8s_L) C1{ Fs Fs:8 FL}



static void Test_S_BFu8s_L()
{
  {
    init_simple_test("S_BFu8s_L");
    static STRUCT_IF_C S_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_L)");
    check_field_offset(lv, v1, 0, "S_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_L, S_BFu8s_L)
//============================================================================


struct  S_BFu8s_S  {
  short v1;
  unsigned short v2:8;
  short v3;
};
//SIG(1 S_BFu8s_S) C1{ Fs Fs:8 Fs}



static void Test_S_BFu8s_S()
{
  {
    init_simple_test("S_BFu8s_S");
    static STRUCT_IF_C S_BFu8s_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8s_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_S)");
    check_field_offset(lv, v1, 0, "S_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_S");
    check_field_offset(lv, v3, 4, "S_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_S, S_BFu8s_S)
//============================================================================


struct  S_BFu8s_Uc  {
  short v1;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 S_BFu8s_Uc) C1{ Fs Fs:8 Fc}



static void Test_S_BFu8s_Uc()
{
  {
    init_simple_test("S_BFu8s_Uc");
    static STRUCT_IF_C S_BFu8s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_Uc");
    check_field_offset(lv, v3, 3, "S_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_Uc, S_BFu8s_Uc)
//============================================================================


struct  S_BFu8s_Ui  {
  short v1;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 S_BFu8s_Ui) C1{ Fs Fs:8 Fi}



static void Test_S_BFu8s_Ui()
{
  {
    init_simple_test("S_BFu8s_Ui");
    static STRUCT_IF_C S_BFu8s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu8s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_Ui");
    check_field_offset(lv, v3, 4, "S_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_Ui, S_BFu8s_Ui)
//============================================================================


struct  S_BFu8s_Ul  {
  short v1;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 S_BFu8s_Ul) C1{ Fs Fs:8 FL}



static void Test_S_BFu8s_Ul()
{
  {
    init_simple_test("S_BFu8s_Ul");
    static STRUCT_IF_C S_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_Ul, S_BFu8s_Ul)
//============================================================================


struct  S_BFu8s_Us  {
  short v1;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 S_BFu8s_Us) C1{ Fs Fs:8 Fs}



static void Test_S_BFu8s_Us()
{
  {
    init_simple_test("S_BFu8s_Us");
    static STRUCT_IF_C S_BFu8s_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu8s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "S_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_Us");
    check_field_offset(lv, v3, 4, "S_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_Us, S_BFu8s_Us)
//============================================================================


struct  S_BFu8s_Vp  {
  short v1;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 S_BFu8s_Vp) C1{ Fs Fs:8 Fp}



static void Test_S_BFu8s_Vp()
{
  {
    init_simple_test("S_BFu8s_Vp");
    static STRUCT_IF_C S_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu8s_Vp, S_BFu8s_Vp)
//============================================================================


struct  S_BFu9i  {
  short v1;
  unsigned int v2:9;
};
//SIG(1 S_BFu9i) C1{ Fs Fi:9}



static void Test_S_BFu9i()
{
  {
    init_simple_test("S_BFu9i");
    static STRUCT_IF_C S_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i, S_BFu9i)
//============================================================================


struct  S_BFu9i_BFu15i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 S_BFu9i_BFu15i) C1{ Fs Fi:9 Fi:15}



static void Test_S_BFu9i_BFu15i()
{
  {
    init_simple_test("S_BFu9i_BFu15i");
    static STRUCT_IF_C S_BFu9i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu15i, S_BFu9i_BFu15i)
//============================================================================


struct  S_BFu9i_BFu15ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 S_BFu9i_BFu15ll) C1{ Fs Fi:9 FL:15}



static void Test_S_BFu9i_BFu15ll()
{
  {
    init_simple_test("S_BFu9i_BFu15ll");
    static STRUCT_IF_C S_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "S_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "S_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu15ll, S_BFu9i_BFu15ll)
//============================================================================


struct  S_BFu9i_BFu15s  {
  short v1;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 S_BFu9i_BFu15s) C1{ Fs Fi:9 Fs:15}



static void Test_S_BFu9i_BFu15s()
{
  {
    init_simple_test("S_BFu9i_BFu15s");
    static STRUCT_IF_C S_BFu9i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu15s, S_BFu9i_BFu15s)
//============================================================================


struct  S_BFu9i_BFu16i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 S_BFu9i_BFu16i) C1{ Fs Fi:9 Fi:16}



static void Test_S_BFu9i_BFu16i()
{
  {
    init_simple_test("S_BFu9i_BFu16i");
    static STRUCT_IF_C S_BFu9i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu16i, S_BFu9i_BFu16i)
//============================================================================


struct  S_BFu9i_BFu16ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 S_BFu9i_BFu16ll) C1{ Fs Fi:9 FL:16}



static void Test_S_BFu9i_BFu16ll()
{
  {
    init_simple_test("S_BFu9i_BFu16ll");
    static STRUCT_IF_C S_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "S_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "S_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu16ll, S_BFu9i_BFu16ll)
//============================================================================


struct  S_BFu9i_BFu16s  {
  short v1;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 S_BFu9i_BFu16s) C1{ Fs Fi:9 Fs:16}



static void Test_S_BFu9i_BFu16s()
{
  {
    init_simple_test("S_BFu9i_BFu16s");
    static STRUCT_IF_C S_BFu9i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu16s, S_BFu9i_BFu16s)
//============================================================================


struct  S_BFu9i_BFu17i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 S_BFu9i_BFu17i) C1{ Fs Fi:9 Fi:17}



static void Test_S_BFu9i_BFu17i()
{
  {
    init_simple_test("S_BFu9i_BFu17i");
    static STRUCT_IF_C S_BFu9i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu17i, S_BFu9i_BFu17i)
//============================================================================


struct  S_BFu9i_BFu17ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 S_BFu9i_BFu17ll) C1{ Fs Fi:9 FL:17}



static void Test_S_BFu9i_BFu17ll()
{
  {
    init_simple_test("S_BFu9i_BFu17ll");
    static STRUCT_IF_C S_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "S_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "S_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu17ll, S_BFu9i_BFu17ll)
//============================================================================


struct  S_BFu9i_BFu1c  {
  short v1;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 S_BFu9i_BFu1c) C1{ Fs Fi:9 Fc:1}



static void Test_S_BFu9i_BFu1c()
{
  {
    init_simple_test("S_BFu9i_BFu1c");
    static STRUCT_IF_C S_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu1c, S_BFu9i_BFu1c)
//============================================================================


struct  S_BFu9i_BFu1i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 S_BFu9i_BFu1i) C1{ Fs Fi:9 Fi:1}



static void Test_S_BFu9i_BFu1i()
{
  {
    init_simple_test("S_BFu9i_BFu1i");
    static STRUCT_IF_C S_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu1i, S_BFu9i_BFu1i)
//============================================================================


struct  S_BFu9i_BFu1ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 S_BFu9i_BFu1ll) C1{ Fs Fi:9 FL:1}



static void Test_S_BFu9i_BFu1ll()
{
  {
    init_simple_test("S_BFu9i_BFu1ll");
    static STRUCT_IF_C S_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu1ll, S_BFu9i_BFu1ll)
//============================================================================


struct  S_BFu9i_BFu1s  {
  short v1;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 S_BFu9i_BFu1s) C1{ Fs Fi:9 Fs:1}



static void Test_S_BFu9i_BFu1s()
{
  {
    init_simple_test("S_BFu9i_BFu1s");
    static STRUCT_IF_C S_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu1s, S_BFu9i_BFu1s)
//============================================================================


struct  S_BFu9i_BFu31i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 S_BFu9i_BFu31i) C1{ Fs Fi:9 Fi:31}



static void Test_S_BFu9i_BFu31i()
{
  {
    init_simple_test("S_BFu9i_BFu31i");
    static STRUCT_IF_C S_BFu9i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu31i, S_BFu9i_BFu31i)
//============================================================================


struct  S_BFu9i_BFu31ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 S_BFu9i_BFu31ll) C1{ Fs Fi:9 FL:31}



static void Test_S_BFu9i_BFu31ll()
{
  {
    init_simple_test("S_BFu9i_BFu31ll");
    static STRUCT_IF_C S_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "S_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "S_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu31ll, S_BFu9i_BFu31ll)
//============================================================================


struct  S_BFu9i_BFu32i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 S_BFu9i_BFu32i) C1{ Fs Fi:9 Fi:32}



static void Test_S_BFu9i_BFu32i()
{
  {
    init_simple_test("S_BFu9i_BFu32i");
    static STRUCT_IF_C S_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu32i, S_BFu9i_BFu32i)
//============================================================================


struct  S_BFu9i_BFu32ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 S_BFu9i_BFu32ll) C1{ Fs Fi:9 FL:32}



static void Test_S_BFu9i_BFu32ll()
{
  {
    init_simple_test("S_BFu9i_BFu32ll");
    static STRUCT_IF_C S_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "S_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "S_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu32ll, S_BFu9i_BFu32ll)
//============================================================================


struct  S_BFu9i_BFu33  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 S_BFu9i_BFu33) C1{ Fs Fi:9 FL:33}



static void Test_S_BFu9i_BFu33()
{
  {
    init_simple_test("S_BFu9i_BFu33");
    static STRUCT_IF_C S_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "S_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "S_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu33, S_BFu9i_BFu33)
//============================================================================


struct  S_BFu9i_BFu7c  {
  short v1;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 S_BFu9i_BFu7c) C1{ Fs Fi:9 Fc:7}



static void Test_S_BFu9i_BFu7c()
{
  {
    init_simple_test("S_BFu9i_BFu7c");
    static STRUCT_IF_C S_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu7c, S_BFu9i_BFu7c)
//============================================================================


struct  S_BFu9i_BFu7i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 S_BFu9i_BFu7i) C1{ Fs Fi:9 Fi:7}



static void Test_S_BFu9i_BFu7i()
{
  {
    init_simple_test("S_BFu9i_BFu7i");
    static STRUCT_IF_C S_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu7i, S_BFu9i_BFu7i)
//============================================================================


struct  S_BFu9i_BFu7ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 S_BFu9i_BFu7ll) C1{ Fs Fi:9 FL:7}



static void Test_S_BFu9i_BFu7ll()
{
  {
    init_simple_test("S_BFu9i_BFu7ll");
    static STRUCT_IF_C S_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu7ll, S_BFu9i_BFu7ll)
//============================================================================


struct  S_BFu9i_BFu7s  {
  short v1;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 S_BFu9i_BFu7s) C1{ Fs Fi:9 Fs:7}



static void Test_S_BFu9i_BFu7s()
{
  {
    init_simple_test("S_BFu9i_BFu7s");
    static STRUCT_IF_C S_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu7s, S_BFu9i_BFu7s)
//============================================================================


struct  S_BFu9i_BFu8c  {
  short v1;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 S_BFu9i_BFu8c) C1{ Fs Fi:9 Fc:8}



static void Test_S_BFu9i_BFu8c()
{
  {
    init_simple_test("S_BFu9i_BFu8c");
    static STRUCT_IF_C S_BFu9i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu8c, S_BFu9i_BFu8c)
//============================================================================


struct  S_BFu9i_BFu8i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 S_BFu9i_BFu8i) C1{ Fs Fi:9 Fi:8}



static void Test_S_BFu9i_BFu8i()
{
  {
    init_simple_test("S_BFu9i_BFu8i");
    static STRUCT_IF_C S_BFu9i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu8i, S_BFu9i_BFu8i)
//============================================================================


struct  S_BFu9i_BFu8ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 S_BFu9i_BFu8ll) C1{ Fs Fi:9 FL:8}



static void Test_S_BFu9i_BFu8ll()
{
  {
    init_simple_test("S_BFu9i_BFu8ll");
    static STRUCT_IF_C S_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "S_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "S_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu8ll, S_BFu9i_BFu8ll)
//============================================================================


struct  S_BFu9i_BFu8s  {
  short v1;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 S_BFu9i_BFu8s) C1{ Fs Fi:9 Fs:8}



static void Test_S_BFu9i_BFu8s()
{
  {
    init_simple_test("S_BFu9i_BFu8s");
    static STRUCT_IF_C S_BFu9i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu8s, S_BFu9i_BFu8s)
//============================================================================


struct  S_BFu9i_BFu9i  {
  short v1;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 S_BFu9i_BFu9i) C1{ Fs Fi:9 Fi:9}



static void Test_S_BFu9i_BFu9i()
{
  {
    init_simple_test("S_BFu9i_BFu9i");
    static STRUCT_IF_C S_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu9i, S_BFu9i_BFu9i)
//============================================================================


struct  S_BFu9i_BFu9ll  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 S_BFu9i_BFu9ll) C1{ Fs Fi:9 FL:9}



static void Test_S_BFu9i_BFu9ll()
{
  {
    init_simple_test("S_BFu9i_BFu9ll");
    static STRUCT_IF_C S_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "S_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "S_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu9ll, S_BFu9i_BFu9ll)
//============================================================================


struct  S_BFu9i_BFu9s  {
  short v1;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 S_BFu9i_BFu9s) C1{ Fs Fi:9 Fs:9}



static void Test_S_BFu9i_BFu9s()
{
  {
    init_simple_test("S_BFu9i_BFu9s");
    static STRUCT_IF_C S_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_BFu9s, S_BFu9i_BFu9s)
//============================================================================


struct  S_BFu9i_C  {
  short v1;
  unsigned int v2:9;
  char v3;
};
//SIG(1 S_BFu9i_C) C1{ Fs Fi:9 Fc}



static void Test_S_BFu9i_C()
{
  {
    init_simple_test("S_BFu9i_C");
    static STRUCT_IF_C S_BFu9i_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_C)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_C)");
    check_field_offset(lv, v1, 0, "S_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_C");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_C");
    check_field_offset(lv, v3, 4, "S_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_C, S_BFu9i_C)
//============================================================================


struct  S_BFu9i_D  {
  short v1;
  unsigned int v2:9;
  double v3;
};
//SIG(1 S_BFu9i_D) C1{ Fs Fi:9 FL}



static void Test_S_BFu9i_D()
{
  {
    init_simple_test("S_BFu9i_D");
    static STRUCT_IF_C S_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_D)");
    check_field_offset(lv, v1, 0, "S_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_D");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_D, S_BFu9i_D)
//============================================================================


struct  S_BFu9i_F  {
  short v1;
  unsigned int v2:9;
  float v3;
};
//SIG(1 S_BFu9i_F) C1{ Fs Fi:9 Fi}



static void Test_S_BFu9i_F()
{
  {
    init_simple_test("S_BFu9i_F");
    static STRUCT_IF_C S_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_F)");
    check_field_offset(lv, v1, 0, "S_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_F");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_F");
    check_field_offset(lv, v3, 4, "S_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_F, S_BFu9i_F)
//============================================================================


struct  S_BFu9i_I  {
  short v1;
  unsigned int v2:9;
  int v3;
};
//SIG(1 S_BFu9i_I) C1{ Fs Fi:9 Fi}



static void Test_S_BFu9i_I()
{
  {
    init_simple_test("S_BFu9i_I");
    static STRUCT_IF_C S_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_I)");
    check_field_offset(lv, v1, 0, "S_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_I");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_I");
    check_field_offset(lv, v3, 4, "S_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_I, S_BFu9i_I)
//============================================================================


struct  S_BFu9i_Ip  {
  short v1;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 S_BFu9i_Ip) C1{ Fs Fi:9 Fp}



static void Test_S_BFu9i_Ip()
{
  {
    init_simple_test("S_BFu9i_Ip");
    static STRUCT_IF_C S_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_Ip, S_BFu9i_Ip)
//============================================================================


struct  S_BFu9i_L  {
  short v1;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 S_BFu9i_L) C1{ Fs Fi:9 FL}



static void Test_S_BFu9i_L()
{
  {
    init_simple_test("S_BFu9i_L");
    static STRUCT_IF_C S_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_L)");
    check_field_offset(lv, v1, 0, "S_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_L");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_L, S_BFu9i_L)
//============================================================================


struct  S_BFu9i_S  {
  short v1;
  unsigned int v2:9;
  short v3;
};
//SIG(1 S_BFu9i_S) C1{ Fs Fi:9 Fs}



static void Test_S_BFu9i_S()
{
  {
    init_simple_test("S_BFu9i_S");
    static STRUCT_IF_C S_BFu9i_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_S)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_S)");
    check_field_offset(lv, v1, 0, "S_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_S");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_S");
    check_field_offset(lv, v3, 4, "S_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_S, S_BFu9i_S)
//============================================================================


struct  S_BFu9i_Uc  {
  short v1;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 S_BFu9i_Uc) C1{ Fs Fi:9 Fc}



static void Test_S_BFu9i_Uc()
{
  {
    init_simple_test("S_BFu9i_Uc");
    static STRUCT_IF_C S_BFu9i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_Uc");
    check_field_offset(lv, v3, 4, "S_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_Uc, S_BFu9i_Uc)
//============================================================================


struct  S_BFu9i_Ui  {
  short v1;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 S_BFu9i_Ui) C1{ Fs Fi:9 Fi}



static void Test_S_BFu9i_Ui()
{
  {
    init_simple_test("S_BFu9i_Ui");
    static STRUCT_IF_C S_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_Ui");
    check_field_offset(lv, v3, 4, "S_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_Ui, S_BFu9i_Ui)
//============================================================================


struct  S_BFu9i_Ul  {
  short v1;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 S_BFu9i_Ul) C1{ Fs Fi:9 FL}



static void Test_S_BFu9i_Ul()
{
  {
    init_simple_test("S_BFu9i_Ul");
    static STRUCT_IF_C S_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_Ul, S_BFu9i_Ul)
//============================================================================


struct  S_BFu9i_Us  {
  short v1;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 S_BFu9i_Us) C1{ Fs Fi:9 Fs}



static void Test_S_BFu9i_Us()
{
  {
    init_simple_test("S_BFu9i_Us");
    static STRUCT_IF_C S_BFu9i_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_Us");
    check_field_offset(lv, v3, 4, "S_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_Us, S_BFu9i_Us)
//============================================================================


struct  S_BFu9i_Vp  {
  short v1;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 S_BFu9i_Vp) C1{ Fs Fi:9 Fp}



static void Test_S_BFu9i_Vp()
{
  {
    init_simple_test("S_BFu9i_Vp");
    static STRUCT_IF_C S_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9i_Vp, S_BFu9i_Vp)
//============================================================================


struct  S_BFu9ll  {
  short v1;
  __tsu64 v2:9;
};
//SIG(1 S_BFu9ll) C1{ Fs FL:9}



static void Test_S_BFu9ll()
{
  {
    init_simple_test("S_BFu9ll");
    static STRUCT_IF_C S_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll, S_BFu9ll)
//============================================================================


struct  S_BFu9ll_BFu15i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 S_BFu9ll_BFu15i) C1{ Fs FL:9 Fi:15}



static void Test_S_BFu9ll_BFu15i()
{
  {
    init_simple_test("S_BFu9ll_BFu15i");
    static STRUCT_IF_C S_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu15i, S_BFu9ll_BFu15i)
//============================================================================


struct  S_BFu9ll_BFu15ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 S_BFu9ll_BFu15ll) C1{ Fs FL:9 FL:15}



static void Test_S_BFu9ll_BFu15ll()
{
  {
    init_simple_test("S_BFu9ll_BFu15ll");
    static STRUCT_IF_C S_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "S_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "S_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu15ll, S_BFu9ll_BFu15ll)
//============================================================================


struct  S_BFu9ll_BFu15s  {
  short v1;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 S_BFu9ll_BFu15s) C1{ Fs FL:9 Fs:15}



static void Test_S_BFu9ll_BFu15s()
{
  {
    init_simple_test("S_BFu9ll_BFu15s");
    static STRUCT_IF_C S_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu15s, S_BFu9ll_BFu15s)
//============================================================================


struct  S_BFu9ll_BFu16i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 S_BFu9ll_BFu16i) C1{ Fs FL:9 Fi:16}



static void Test_S_BFu9ll_BFu16i()
{
  {
    init_simple_test("S_BFu9ll_BFu16i");
    static STRUCT_IF_C S_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu16i, S_BFu9ll_BFu16i)
//============================================================================


struct  S_BFu9ll_BFu16ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 S_BFu9ll_BFu16ll) C1{ Fs FL:9 FL:16}



static void Test_S_BFu9ll_BFu16ll()
{
  {
    init_simple_test("S_BFu9ll_BFu16ll");
    static STRUCT_IF_C S_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "S_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "S_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu16ll, S_BFu9ll_BFu16ll)
//============================================================================


struct  S_BFu9ll_BFu16s  {
  short v1;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 S_BFu9ll_BFu16s) C1{ Fs FL:9 Fs:16}



static void Test_S_BFu9ll_BFu16s()
{
  {
    init_simple_test("S_BFu9ll_BFu16s");
    static STRUCT_IF_C S_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu16s, S_BFu9ll_BFu16s)
//============================================================================


struct  S_BFu9ll_BFu17i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 S_BFu9ll_BFu17i) C1{ Fs FL:9 Fi:17}



static void Test_S_BFu9ll_BFu17i()
{
  {
    init_simple_test("S_BFu9ll_BFu17i");
    static STRUCT_IF_C S_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu17i, S_BFu9ll_BFu17i)
//============================================================================


struct  S_BFu9ll_BFu17ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 S_BFu9ll_BFu17ll) C1{ Fs FL:9 FL:17}



static void Test_S_BFu9ll_BFu17ll()
{
  {
    init_simple_test("S_BFu9ll_BFu17ll");
    static STRUCT_IF_C S_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "S_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "S_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu17ll, S_BFu9ll_BFu17ll)
//============================================================================


struct  S_BFu9ll_BFu1c  {
  short v1;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 S_BFu9ll_BFu1c) C1{ Fs FL:9 Fc:1}



static void Test_S_BFu9ll_BFu1c()
{
  {
    init_simple_test("S_BFu9ll_BFu1c");
    static STRUCT_IF_C S_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu1c, S_BFu9ll_BFu1c)
//============================================================================


struct  S_BFu9ll_BFu1i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 S_BFu9ll_BFu1i) C1{ Fs FL:9 Fi:1}



static void Test_S_BFu9ll_BFu1i()
{
  {
    init_simple_test("S_BFu9ll_BFu1i");
    static STRUCT_IF_C S_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu1i, S_BFu9ll_BFu1i)
//============================================================================


struct  S_BFu9ll_BFu1ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 S_BFu9ll_BFu1ll) C1{ Fs FL:9 FL:1}



static void Test_S_BFu9ll_BFu1ll()
{
  {
    init_simple_test("S_BFu9ll_BFu1ll");
    static STRUCT_IF_C S_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu1ll, S_BFu9ll_BFu1ll)
//============================================================================


struct  S_BFu9ll_BFu1s  {
  short v1;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 S_BFu9ll_BFu1s) C1{ Fs FL:9 Fs:1}



static void Test_S_BFu9ll_BFu1s()
{
  {
    init_simple_test("S_BFu9ll_BFu1s");
    static STRUCT_IF_C S_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu1s, S_BFu9ll_BFu1s)
//============================================================================


struct  S_BFu9ll_BFu31i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 S_BFu9ll_BFu31i) C1{ Fs FL:9 Fi:31}



static void Test_S_BFu9ll_BFu31i()
{
  {
    init_simple_test("S_BFu9ll_BFu31i");
    static STRUCT_IF_C S_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu31i, S_BFu9ll_BFu31i)
//============================================================================


struct  S_BFu9ll_BFu31ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 S_BFu9ll_BFu31ll) C1{ Fs FL:9 FL:31}



static void Test_S_BFu9ll_BFu31ll()
{
  {
    init_simple_test("S_BFu9ll_BFu31ll");
    static STRUCT_IF_C S_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "S_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "S_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu31ll, S_BFu9ll_BFu31ll)
//============================================================================


struct  S_BFu9ll_BFu32i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 S_BFu9ll_BFu32i) C1{ Fs FL:9 Fi:32}



static void Test_S_BFu9ll_BFu32i()
{
  {
    init_simple_test("S_BFu9ll_BFu32i");
    static STRUCT_IF_C S_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu32i, S_BFu9ll_BFu32i)
//============================================================================


struct  S_BFu9ll_BFu32ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 S_BFu9ll_BFu32ll) C1{ Fs FL:9 FL:32}



static void Test_S_BFu9ll_BFu32ll()
{
  {
    init_simple_test("S_BFu9ll_BFu32ll");
    static STRUCT_IF_C S_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "S_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "S_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu32ll, S_BFu9ll_BFu32ll)
//============================================================================


struct  S_BFu9ll_BFu33  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 S_BFu9ll_BFu33) C1{ Fs FL:9 FL:33}



static void Test_S_BFu9ll_BFu33()
{
  {
    init_simple_test("S_BFu9ll_BFu33");
    static STRUCT_IF_C S_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "S_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "S_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu33, S_BFu9ll_BFu33)
//============================================================================


struct  S_BFu9ll_BFu7c  {
  short v1;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 S_BFu9ll_BFu7c) C1{ Fs FL:9 Fc:7}



static void Test_S_BFu9ll_BFu7c()
{
  {
    init_simple_test("S_BFu9ll_BFu7c");
    static STRUCT_IF_C S_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu7c, S_BFu9ll_BFu7c)
//============================================================================


struct  S_BFu9ll_BFu7i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:7;
};
//SIG(1 S_BFu9ll_BFu7i) C1{ Fs FL:9 Fi:7}



static void Test_S_BFu9ll_BFu7i()
{
  {
    init_simple_test("S_BFu9ll_BFu7i");
    static STRUCT_IF_C S_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu7i, S_BFu9ll_BFu7i)
//============================================================================


struct  S_BFu9ll_BFu7ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:7;
};
//SIG(1 S_BFu9ll_BFu7ll) C1{ Fs FL:9 FL:7}



static void Test_S_BFu9ll_BFu7ll()
{
  {
    init_simple_test("S_BFu9ll_BFu7ll");
    static STRUCT_IF_C S_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu7ll, S_BFu9ll_BFu7ll)
//============================================================================


struct  S_BFu9ll_BFu7s  {
  short v1;
  __tsu64 v2:9;
  unsigned short v3:7;
};
//SIG(1 S_BFu9ll_BFu7s) C1{ Fs FL:9 Fs:7}



static void Test_S_BFu9ll_BFu7s()
{
  {
    init_simple_test("S_BFu9ll_BFu7s");
    static STRUCT_IF_C S_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu7s, S_BFu9ll_BFu7s)
//============================================================================


struct  S_BFu9ll_BFu8c  {
  short v1;
  __tsu64 v2:9;
  unsigned char v3:8;
};
//SIG(1 S_BFu9ll_BFu8c) C1{ Fs FL:9 Fc:8}



static void Test_S_BFu9ll_BFu8c()
{
  {
    init_simple_test("S_BFu9ll_BFu8c");
    static STRUCT_IF_C S_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu8c, S_BFu9ll_BFu8c)
//============================================================================


struct  S_BFu9ll_BFu8i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:8;
};
//SIG(1 S_BFu9ll_BFu8i) C1{ Fs FL:9 Fi:8}



static void Test_S_BFu9ll_BFu8i()
{
  {
    init_simple_test("S_BFu9ll_BFu8i");
    static STRUCT_IF_C S_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu8i, S_BFu9ll_BFu8i)
//============================================================================


struct  S_BFu9ll_BFu8ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:8;
};
//SIG(1 S_BFu9ll_BFu8ll) C1{ Fs FL:9 FL:8}



static void Test_S_BFu9ll_BFu8ll()
{
  {
    init_simple_test("S_BFu9ll_BFu8ll");
    static STRUCT_IF_C S_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "S_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "S_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu8ll, S_BFu9ll_BFu8ll)
//============================================================================


struct  S_BFu9ll_BFu8s  {
  short v1;
  __tsu64 v2:9;
  unsigned short v3:8;
};
//SIG(1 S_BFu9ll_BFu8s) C1{ Fs FL:9 Fs:8}



static void Test_S_BFu9ll_BFu8s()
{
  {
    init_simple_test("S_BFu9ll_BFu8s");
    static STRUCT_IF_C S_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "S_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "S_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu8s, S_BFu9ll_BFu8s)
//============================================================================


struct  S_BFu9ll_BFu9i  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 S_BFu9ll_BFu9i) C1{ Fs FL:9 Fi:9}



static void Test_S_BFu9ll_BFu9i()
{
  {
    init_simple_test("S_BFu9ll_BFu9i");
    static STRUCT_IF_C S_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu9i, S_BFu9ll_BFu9i)
//============================================================================


struct  S_BFu9ll_BFu9ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 S_BFu9ll_BFu9ll) C1{ Fs FL:9 FL:9}



static void Test_S_BFu9ll_BFu9ll()
{
  {
    init_simple_test("S_BFu9ll_BFu9ll");
    static STRUCT_IF_C S_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "S_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu9ll, S_BFu9ll_BFu9ll)
//============================================================================


struct  S_BFu9ll_BFu9s  {
  short v1;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 S_BFu9ll_BFu9s) C1{ Fs FL:9 Fs:9}



static void Test_S_BFu9ll_BFu9s()
{
  {
    init_simple_test("S_BFu9ll_BFu9s");
    static STRUCT_IF_C S_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "S_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_BFu9s, S_BFu9ll_BFu9s)
//============================================================================


struct  S_BFu9ll_C  {
  short v1;
  __tsu64 v2:9;
  char v3;
};
//SIG(1 S_BFu9ll_C) C1{ Fs FL:9 Fc}



static void Test_S_BFu9ll_C()
{
  {
    init_simple_test("S_BFu9ll_C");
    static STRUCT_IF_C S_BFu9ll_C lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_C");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_C");
    check_field_offset(lv, v3, 4, "S_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_C, S_BFu9ll_C)
//============================================================================


struct  S_BFu9ll_D  {
  short v1;
  __tsu64 v2:9;
  double v3;
};
//SIG(1 S_BFu9ll_D) C1{ Fs FL:9 FL}



static void Test_S_BFu9ll_D()
{
  {
    init_simple_test("S_BFu9ll_D");
    static STRUCT_IF_C S_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_D");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_D, S_BFu9ll_D)
//============================================================================


struct  S_BFu9ll_F  {
  short v1;
  __tsu64 v2:9;
  float v3;
};
//SIG(1 S_BFu9ll_F) C1{ Fs FL:9 Fi}



static void Test_S_BFu9ll_F()
{
  {
    init_simple_test("S_BFu9ll_F");
    static STRUCT_IF_C S_BFu9ll_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_F");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_F");
    check_field_offset(lv, v3, 4, "S_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_F, S_BFu9ll_F)
//============================================================================


struct  S_BFu9ll_I  {
  short v1;
  __tsu64 v2:9;
  int v3;
};
//SIG(1 S_BFu9ll_I) C1{ Fs FL:9 Fi}



static void Test_S_BFu9ll_I()
{
  {
    init_simple_test("S_BFu9ll_I");
    static STRUCT_IF_C S_BFu9ll_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_I");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_I");
    check_field_offset(lv, v3, 4, "S_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_I, S_BFu9ll_I)
//============================================================================


struct  S_BFu9ll_Ip  {
  short v1;
  __tsu64 v2:9;
  int *v3;
};
//SIG(1 S_BFu9ll_Ip) C1{ Fs FL:9 Fp}



static void Test_S_BFu9ll_Ip()
{
  {
    init_simple_test("S_BFu9ll_Ip");
    static STRUCT_IF_C S_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_Ip, S_BFu9ll_Ip)
//============================================================================


struct  S_BFu9ll_L  {
  short v1;
  __tsu64 v2:9;
  __tsi64 v3;
};
//SIG(1 S_BFu9ll_L) C1{ Fs FL:9 FL}



static void Test_S_BFu9ll_L()
{
  {
    init_simple_test("S_BFu9ll_L");
    static STRUCT_IF_C S_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_L");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_L, S_BFu9ll_L)
//============================================================================


struct  S_BFu9ll_S  {
  short v1;
  __tsu64 v2:9;
  short v3;
};
//SIG(1 S_BFu9ll_S) C1{ Fs FL:9 Fs}



static void Test_S_BFu9ll_S()
{
  {
    init_simple_test("S_BFu9ll_S");
    static STRUCT_IF_C S_BFu9ll_S lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_S");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_S");
    check_field_offset(lv, v3, 4, "S_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_S, S_BFu9ll_S)
//============================================================================


struct  S_BFu9ll_Uc  {
  short v1;
  __tsu64 v2:9;
  unsigned char v3;
};
//SIG(1 S_BFu9ll_Uc) C1{ Fs FL:9 Fc}



static void Test_S_BFu9ll_Uc()
{
  {
    init_simple_test("S_BFu9ll_Uc");
    static STRUCT_IF_C S_BFu9ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_Uc");
    check_field_offset(lv, v3, 4, "S_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_Uc, S_BFu9ll_Uc)
//============================================================================


struct  S_BFu9ll_Ui  {
  short v1;
  __tsu64 v2:9;
  unsigned int v3;
};
//SIG(1 S_BFu9ll_Ui) C1{ Fs FL:9 Fi}



static void Test_S_BFu9ll_Ui()
{
  {
    init_simple_test("S_BFu9ll_Ui");
    static STRUCT_IF_C S_BFu9ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_Ui");
    check_field_offset(lv, v3, 4, "S_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_Ui, S_BFu9ll_Ui)
//============================================================================


struct  S_BFu9ll_Ul  {
  short v1;
  __tsu64 v2:9;
  __tsu64 v3;
};
//SIG(1 S_BFu9ll_Ul) C1{ Fs FL:9 FL}



static void Test_S_BFu9ll_Ul()
{
  {
    init_simple_test("S_BFu9ll_Ul");
    static STRUCT_IF_C S_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_Ul, S_BFu9ll_Ul)
//============================================================================


struct  S_BFu9ll_Us  {
  short v1;
  __tsu64 v2:9;
  unsigned short v3;
};
//SIG(1 S_BFu9ll_Us) C1{ Fs FL:9 Fs}



static void Test_S_BFu9ll_Us()
{
  {
    init_simple_test("S_BFu9ll_Us");
    static STRUCT_IF_C S_BFu9ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_Us");
    check_field_offset(lv, v3, 4, "S_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_Us, S_BFu9ll_Us)
//============================================================================


struct  S_BFu9ll_Vp  {
  short v1;
  __tsu64 v2:9;
  void *v3;
};
//SIG(1 S_BFu9ll_Vp) C1{ Fs FL:9 Fp}



static void Test_S_BFu9ll_Vp()
{
  {
    init_simple_test("S_BFu9ll_Vp");
    static STRUCT_IF_C S_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "S_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9ll_Vp, S_BFu9ll_Vp)
//============================================================================


struct  S_BFu9s  {
  short v1;
  unsigned short v2:9;
};
//SIG(1 S_BFu9s) C1{ Fs Fs:9}



static void Test_S_BFu9s()
{
  {
    init_simple_test("S_BFu9s");
    static STRUCT_IF_C S_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s, S_BFu9s)
//============================================================================


struct  S_BFu9s_BFu15i  {
  short v1;
  unsigned short v2:9;
  unsigned int v3:15;
};
//SIG(1 S_BFu9s_BFu15i) C1{ Fs Fs:9 Fi:15}



static void Test_S_BFu9s_BFu15i()
{
  {
    init_simple_test("S_BFu9s_BFu15i");
    static STRUCT_IF_C S_BFu9s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu15i, S_BFu9s_BFu15i)
//============================================================================


struct  S_BFu9s_BFu15ll  {
  short v1;
  unsigned short v2:9;
  __tsu64 v3:15;
};
//SIG(1 S_BFu9s_BFu15ll) C1{ Fs Fs:9 FL:15}



static void Test_S_BFu9s_BFu15ll()
{
  {
    init_simple_test("S_BFu9s_BFu15ll");
    static STRUCT_IF_C S_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "S_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "S_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu15ll, S_BFu9s_BFu15ll)
//============================================================================


struct  S_BFu9s_BFu15s  {
  short v1;
  unsigned short v2:9;
  unsigned short v3:15;
};
//SIG(1 S_BFu9s_BFu15s) C1{ Fs Fs:9 Fs:15}



static void Test_S_BFu9s_BFu15s()
{
  {
    init_simple_test("S_BFu9s_BFu15s");
    static STRUCT_IF_C S_BFu9s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu9s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "S_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "S_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu15s, S_BFu9s_BFu15s)
//============================================================================


struct  S_BFu9s_BFu16i  {
  short v1;
  unsigned short v2:9;
  unsigned int v3:16;
};
//SIG(1 S_BFu9s_BFu16i) C1{ Fs Fs:9 Fi:16}



static void Test_S_BFu9s_BFu16i()
{
  {
    init_simple_test("S_BFu9s_BFu16i");
    static STRUCT_IF_C S_BFu9s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu16i, S_BFu9s_BFu16i)
//============================================================================


struct  S_BFu9s_BFu16ll  {
  short v1;
  unsigned short v2:9;
  __tsu64 v3:16;
};
//SIG(1 S_BFu9s_BFu16ll) C1{ Fs Fs:9 FL:16}



static void Test_S_BFu9s_BFu16ll()
{
  {
    init_simple_test("S_BFu9s_BFu16ll");
    static STRUCT_IF_C S_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "S_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "S_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu16ll, S_BFu9s_BFu16ll)
//============================================================================


struct  S_BFu9s_BFu16s  {
  short v1;
  unsigned short v2:9;
  unsigned short v3:16;
};
//SIG(1 S_BFu9s_BFu16s) C1{ Fs Fs:9 Fs:16}



static void Test_S_BFu9s_BFu16s()
{
  {
    init_simple_test("S_BFu9s_BFu16s");
    static STRUCT_IF_C S_BFu9s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu9s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "S_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "S_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu16s, S_BFu9s_BFu16s)
//============================================================================


struct  S_BFu9s_BFu17i  {
  short v1;
  unsigned short v2:9;
  unsigned int v3:17;
};
//SIG(1 S_BFu9s_BFu17i) C1{ Fs Fs:9 Fi:17}



static void Test_S_BFu9s_BFu17i()
{
  {
    init_simple_test("S_BFu9s_BFu17i");
    static STRUCT_IF_C S_BFu9s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "S_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "S_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu17i, S_BFu9s_BFu17i)
//============================================================================


struct  S_BFu9s_BFu17ll  {
  short v1;
  unsigned short v2:9;
  __tsu64 v3:17;
};
//SIG(1 S_BFu9s_BFu17ll) C1{ Fs Fs:9 FL:17}



static void Test_S_BFu9s_BFu17ll()
{
  {
    init_simple_test("S_BFu9s_BFu17ll");
    static STRUCT_IF_C S_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "S_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "S_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu17ll, S_BFu9s_BFu17ll)
//============================================================================


struct  S_BFu9s_BFu1c  {
  short v1;
  unsigned short v2:9;
  unsigned char v3:1;
};
//SIG(1 S_BFu9s_BFu1c) C1{ Fs Fs:9 Fc:1}



static void Test_S_BFu9s_BFu1c()
{
  {
    init_simple_test("S_BFu9s_BFu1c");
    static STRUCT_IF_C S_BFu9s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu1c, S_BFu9s_BFu1c)
//============================================================================


struct  S_BFu9s_BFu1i  {
  short v1;
  unsigned short v2:9;
  unsigned int v3:1;
};
//SIG(1 S_BFu9s_BFu1i) C1{ Fs Fs:9 Fi:1}



static void Test_S_BFu9s_BFu1i()
{
  {
    init_simple_test("S_BFu9s_BFu1i");
    static STRUCT_IF_C S_BFu9s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu1i, S_BFu9s_BFu1i)
//============================================================================


struct  S_BFu9s_BFu1ll  {
  short v1;
  unsigned short v2:9;
  __tsu64 v3:1;
};
//SIG(1 S_BFu9s_BFu1ll) C1{ Fs Fs:9 FL:1}



static void Test_S_BFu9s_BFu1ll()
{
  {
    init_simple_test("S_BFu9s_BFu1ll");
    static STRUCT_IF_C S_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu1ll, S_BFu9s_BFu1ll)
//============================================================================


struct  S_BFu9s_BFu1s  {
  short v1;
  unsigned short v2:9;
  unsigned short v3:1;
};
//SIG(1 S_BFu9s_BFu1s) C1{ Fs Fs:9 Fs:1}



static void Test_S_BFu9s_BFu1s()
{
  {
    init_simple_test("S_BFu9s_BFu1s");
    static STRUCT_IF_C S_BFu9s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "S_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu1s, S_BFu9s_BFu1s)
//============================================================================


struct  S_BFu9s_BFu31i  {
  short v1;
  unsigned short v2:9;
  unsigned int v3:31;
};
//SIG(1 S_BFu9s_BFu31i) C1{ Fs Fs:9 Fi:31}



static void Test_S_BFu9s_BFu31i()
{
  {
    init_simple_test("S_BFu9s_BFu31i");
    static STRUCT_IF_C S_BFu9s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "S_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "S_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu31i, S_BFu9s_BFu31i)
//============================================================================


struct  S_BFu9s_BFu31ll  {
  short v1;
  unsigned short v2:9;
  __tsu64 v3:31;
};
//SIG(1 S_BFu9s_BFu31ll) C1{ Fs Fs:9 FL:31}



static void Test_S_BFu9s_BFu31ll()
{
  {
    init_simple_test("S_BFu9s_BFu31ll");
    static STRUCT_IF_C S_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "S_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "S_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu31ll, S_BFu9s_BFu31ll)
//============================================================================


struct  S_BFu9s_BFu32i  {
  short v1;
  unsigned short v2:9;
  unsigned int v3:32;
};
//SIG(1 S_BFu9s_BFu32i) C1{ Fs Fs:9 Fi:32}



static void Test_S_BFu9s_BFu32i()
{
  {
    init_simple_test("S_BFu9s_BFu32i");
    static STRUCT_IF_C S_BFu9s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "S_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "S_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu32i, S_BFu9s_BFu32i)
//============================================================================


struct  S_BFu9s_BFu32ll  {
  short v1;
  unsigned short v2:9;
  __tsu64 v3:32;
};
//SIG(1 S_BFu9s_BFu32ll) C1{ Fs Fs:9 FL:32}



static void Test_S_BFu9s_BFu32ll()
{
  {
    init_simple_test("S_BFu9s_BFu32ll");
    static STRUCT_IF_C S_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "S_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "S_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu32ll, S_BFu9s_BFu32ll)
//============================================================================


struct  S_BFu9s_BFu33  {
  short v1;
  unsigned short v2:9;
  __tsu64 v3:33;
};
//SIG(1 S_BFu9s_BFu33) C1{ Fs Fs:9 FL:33}



static void Test_S_BFu9s_BFu33()
{
  {
    init_simple_test("S_BFu9s_BFu33");
    static STRUCT_IF_C S_BFu9s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "S_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "S_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu33, S_BFu9s_BFu33)
//============================================================================


struct  S_BFu9s_BFu7c  {
  short v1;
  unsigned short v2:9;
  unsigned char v3:7;
};
//SIG(1 S_BFu9s_BFu7c) C1{ Fs Fs:9 Fc:7}



static void Test_S_BFu9s_BFu7c()
{
  {
    init_simple_test("S_BFu9s_BFu7c");
    static STRUCT_IF_C S_BFu9s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "S_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "S_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu9s_BFu7c, S_BFu9s_BFu7c)
//============================================================================


struct  S_BFu9s_BFu7i  {
  short v1;
  unsigned short v2:9;
  unsigned int v3:7;
};
//SIG(1 S_BFu9s_BFu7i) C1{ Fs Fs:9 Fi:7}



static void Test_S_BFu9s_BFu7i()
{
  {
    init_simple_test("S_BFu9s_BFu7i");
    static STRUCT_IF_C S_BFu9s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu7i");
    set_bf_and