// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  Ip_BFu15s_Us  {
  int *v1;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 Ip_BFu15s_Us) C1{ Fp Fs:15 Fs}



static void Test_Ip_BFu15s_Us()
{
  {
    init_simple_test("Ip_BFu15s_Us");
    static STRUCT_IF_C Ip_BFu15s_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu15s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Ip_BFu15s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Ip_BFu15s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu15s_Us, Ip_BFu15s_Us)
//============================================================================


struct  Ip_BFu15s_Vp  {
  int *v1;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 Ip_BFu15s_Vp) C1{ Fp Fs:15 Fp}



static void Test_Ip_BFu15s_Vp()
{
  {
    init_simple_test("Ip_BFu15s_Vp");
    static STRUCT_IF_C Ip_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Ip_BFu15s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Ip_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu15s_Vp, Ip_BFu15s_Vp)
//============================================================================


struct  Ip_BFu16i  {
  int *v1;
  unsigned int v2:16;
};
//SIG(1 Ip_BFu16i) C1{ Fp Fi:16}



static void Test_Ip_BFu16i()
{
  {
    init_simple_test("Ip_BFu16i");
    static STRUCT_IF_C Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i, Ip_BFu16i)
//============================================================================


struct  Ip_BFu16i_BFu15i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu16i_BFu15i) C1{ Fp Fi:16 Fi:15}



static void Test_Ip_BFu16i_BFu15i()
{
  {
    init_simple_test("Ip_BFu16i_BFu15i");
    static STRUCT_IF_C Ip_BFu16i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu15i, Ip_BFu16i_BFu15i)
//============================================================================


struct  Ip_BFu16i_BFu15ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu16i_BFu15ll) C1{ Fp Fi:16 FL:15}



static void Test_Ip_BFu16i_BFu15ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu15ll");
    static STRUCT_IF_C Ip_BFu16i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu15ll, Ip_BFu16i_BFu15ll)
//============================================================================


struct  Ip_BFu16i_BFu15s  {
  int *v1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu16i_BFu15s) C1{ Fp Fi:16 Fs:15}



static void Test_Ip_BFu16i_BFu15s()
{
  {
    init_simple_test("Ip_BFu16i_BFu15s");
    static STRUCT_IF_C Ip_BFu16i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu15s, Ip_BFu16i_BFu15s)
//============================================================================


struct  Ip_BFu16i_BFu16i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu16i_BFu16i) C1{ Fp Fi:16 Fi:16}



static void Test_Ip_BFu16i_BFu16i()
{
  {
    init_simple_test("Ip_BFu16i_BFu16i");
    static STRUCT_IF_C Ip_BFu16i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu16i, Ip_BFu16i_BFu16i)
//============================================================================


struct  Ip_BFu16i_BFu16ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu16i_BFu16ll) C1{ Fp Fi:16 FL:16}



static void Test_Ip_BFu16i_BFu16ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu16ll");
    static STRUCT_IF_C Ip_BFu16i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu16ll, Ip_BFu16i_BFu16ll)
//============================================================================


struct  Ip_BFu16i_BFu16s  {
  int *v1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu16i_BFu16s) C1{ Fp Fi:16 Fs:16}



static void Test_Ip_BFu16i_BFu16s()
{
  {
    init_simple_test("Ip_BFu16i_BFu16s");
    static STRUCT_IF_C Ip_BFu16i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu16s, Ip_BFu16i_BFu16s)
//============================================================================


struct  Ip_BFu16i_BFu17i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu16i_BFu17i) C1{ Fp Fi:16 Fi:17}



static void Test_Ip_BFu16i_BFu17i()
{
  {
    init_simple_test("Ip_BFu16i_BFu17i");
    static STRUCT_IF_C Ip_BFu16i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu17i, Ip_BFu16i_BFu17i)
//============================================================================


struct  Ip_BFu16i_BFu17ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu16i_BFu17ll) C1{ Fp Fi:16 FL:17}



static void Test_Ip_BFu16i_BFu17ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu17ll");
    static STRUCT_IF_C Ip_BFu16i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Ip_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Ip_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu17ll, Ip_BFu16i_BFu17ll)
//============================================================================


struct  Ip_BFu16i_BFu1c  {
  int *v1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu16i_BFu1c) C1{ Fp Fi:16 Fc:1}



static void Test_Ip_BFu16i_BFu1c()
{
  {
    init_simple_test("Ip_BFu16i_BFu1c");
    static STRUCT_IF_C Ip_BFu16i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu1c, Ip_BFu16i_BFu1c)
//============================================================================


struct  Ip_BFu16i_BFu1i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu16i_BFu1i) C1{ Fp Fi:16 Fi:1}



static void Test_Ip_BFu16i_BFu1i()
{
  {
    init_simple_test("Ip_BFu16i_BFu1i");
    static STRUCT_IF_C Ip_BFu16i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu1i, Ip_BFu16i_BFu1i)
//============================================================================


struct  Ip_BFu16i_BFu1ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu16i_BFu1ll) C1{ Fp Fi:16 FL:1}



static void Test_Ip_BFu16i_BFu1ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu1ll");
    static STRUCT_IF_C Ip_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu1ll, Ip_BFu16i_BFu1ll)
//============================================================================


struct  Ip_BFu16i_BFu1s  {
  int *v1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu16i_BFu1s) C1{ Fp Fi:16 Fs:1}



static void Test_Ip_BFu16i_BFu1s()
{
  {
    init_simple_test("Ip_BFu16i_BFu1s");
    static STRUCT_IF_C Ip_BFu16i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu1s, Ip_BFu16i_BFu1s)
//============================================================================


struct  Ip_BFu16i_BFu31i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu16i_BFu31i) C1{ Fp Fi:16 Fi:31}



static void Test_Ip_BFu16i_BFu31i()
{
  {
    init_simple_test("Ip_BFu16i_BFu31i");
    static STRUCT_IF_C Ip_BFu16i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu31i, Ip_BFu16i_BFu31i)
//============================================================================


struct  Ip_BFu16i_BFu31ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu16i_BFu31ll) C1{ Fp Fi:16 FL:31}



static void Test_Ip_BFu16i_BFu31ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu31ll");
    static STRUCT_IF_C Ip_BFu16i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Ip_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Ip_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu31ll, Ip_BFu16i_BFu31ll)
//============================================================================


struct  Ip_BFu16i_BFu32i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu16i_BFu32i) C1{ Fp Fi:16 Fi:32}



static void Test_Ip_BFu16i_BFu32i()
{
  {
    init_simple_test("Ip_BFu16i_BFu32i");
    static STRUCT_IF_C Ip_BFu16i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu32i, Ip_BFu16i_BFu32i)
//============================================================================


struct  Ip_BFu16i_BFu32ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu16i_BFu32ll) C1{ Fp Fi:16 FL:32}



static void Test_Ip_BFu16i_BFu32ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu32ll");
    static STRUCT_IF_C Ip_BFu16i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Ip_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Ip_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu32ll, Ip_BFu16i_BFu32ll)
//============================================================================


struct  Ip_BFu16i_BFu33  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu16i_BFu33) C1{ Fp Fi:16 FL:33}



static void Test_Ip_BFu16i_BFu33()
{
  {
    init_simple_test("Ip_BFu16i_BFu33");
    static STRUCT_IF_C Ip_BFu16i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "Ip_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "Ip_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu33, Ip_BFu16i_BFu33)
//============================================================================


struct  Ip_BFu16i_BFu7c  {
  int *v1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu16i_BFu7c) C1{ Fp Fi:16 Fc:7}



static void Test_Ip_BFu16i_BFu7c()
{
  {
    init_simple_test("Ip_BFu16i_BFu7c");
    static STRUCT_IF_C Ip_BFu16i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu7c, Ip_BFu16i_BFu7c)
//============================================================================


struct  Ip_BFu16i_BFu7i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu16i_BFu7i) C1{ Fp Fi:16 Fi:7}



static void Test_Ip_BFu16i_BFu7i()
{
  {
    init_simple_test("Ip_BFu16i_BFu7i");
    static STRUCT_IF_C Ip_BFu16i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu7i, Ip_BFu16i_BFu7i)
//============================================================================


struct  Ip_BFu16i_BFu7ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu16i_BFu7ll) C1{ Fp Fi:16 FL:7}



static void Test_Ip_BFu16i_BFu7ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu7ll");
    static STRUCT_IF_C Ip_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu7ll, Ip_BFu16i_BFu7ll)
//============================================================================


struct  Ip_BFu16i_BFu7s  {
  int *v1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu16i_BFu7s) C1{ Fp Fi:16 Fs:7}



static void Test_Ip_BFu16i_BFu7s()
{
  {
    init_simple_test("Ip_BFu16i_BFu7s");
    static STRUCT_IF_C Ip_BFu16i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu7s, Ip_BFu16i_BFu7s)
//============================================================================


struct  Ip_BFu16i_BFu8c  {
  int *v1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu16i_BFu8c) C1{ Fp Fi:16 Fc:8}



static void Test_Ip_BFu16i_BFu8c()
{
  {
    init_simple_test("Ip_BFu16i_BFu8c");
    static STRUCT_IF_C Ip_BFu16i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu8c, Ip_BFu16i_BFu8c)
//============================================================================


struct  Ip_BFu16i_BFu8i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu16i_BFu8i) C1{ Fp Fi:16 Fi:8}



static void Test_Ip_BFu16i_BFu8i()
{
  {
    init_simple_test("Ip_BFu16i_BFu8i");
    static STRUCT_IF_C Ip_BFu16i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu8i, Ip_BFu16i_BFu8i)
//============================================================================


struct  Ip_BFu16i_BFu8ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu16i_BFu8ll) C1{ Fp Fi:16 FL:8}



static void Test_Ip_BFu16i_BFu8ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu8ll");
    static STRUCT_IF_C Ip_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu8ll, Ip_BFu16i_BFu8ll)
//============================================================================


struct  Ip_BFu16i_BFu8s  {
  int *v1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu16i_BFu8s) C1{ Fp Fi:16 Fs:8}



static void Test_Ip_BFu16i_BFu8s()
{
  {
    init_simple_test("Ip_BFu16i_BFu8s");
    static STRUCT_IF_C Ip_BFu16i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu8s, Ip_BFu16i_BFu8s)
//============================================================================


struct  Ip_BFu16i_BFu9i  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu16i_BFu9i) C1{ Fp Fi:16 Fi:9}



static void Test_Ip_BFu16i_BFu9i()
{
  {
    init_simple_test("Ip_BFu16i_BFu9i");
    static STRUCT_IF_C Ip_BFu16i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu9i, Ip_BFu16i_BFu9i)
//============================================================================


struct  Ip_BFu16i_BFu9ll  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu16i_BFu9ll) C1{ Fp Fi:16 FL:9}



static void Test_Ip_BFu16i_BFu9ll()
{
  {
    init_simple_test("Ip_BFu16i_BFu9ll");
    static STRUCT_IF_C Ip_BFu16i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu9ll, Ip_BFu16i_BFu9ll)
//============================================================================


struct  Ip_BFu16i_BFu9s  {
  int *v1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu16i_BFu9s) C1{ Fp Fi:16 Fs:9}



static void Test_Ip_BFu16i_BFu9s()
{
  {
    init_simple_test("Ip_BFu16i_BFu9s");
    static STRUCT_IF_C Ip_BFu16i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_BFu9s, Ip_BFu16i_BFu9s)
//============================================================================


struct  Ip_BFu16i_C  {
  int *v1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 Ip_BFu16i_C) C1{ Fp Fi:16 Fc}



static void Test_Ip_BFu16i_C()
{
  {
    init_simple_test("Ip_BFu16i_C");
    static STRUCT_IF_C Ip_BFu16i_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_C, Ip_BFu16i_C)
//============================================================================


struct  Ip_BFu16i_D  {
  int *v1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 Ip_BFu16i_D) C1{ Fp Fi:16 FL}



static void Test_Ip_BFu16i_D()
{
  {
    init_simple_test("Ip_BFu16i_D");
    static STRUCT_IF_C Ip_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_D, Ip_BFu16i_D)
//============================================================================


struct  Ip_BFu16i_F  {
  int *v1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 Ip_BFu16i_F) C1{ Fp Fi:16 Fi}



static void Test_Ip_BFu16i_F()
{
  {
    init_simple_test("Ip_BFu16i_F");
    static STRUCT_IF_C Ip_BFu16i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_F, Ip_BFu16i_F)
//============================================================================


struct  Ip_BFu16i_I  {
  int *v1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 Ip_BFu16i_I) C1{ Fp Fi:16 Fi}



static void Test_Ip_BFu16i_I()
{
  {
    init_simple_test("Ip_BFu16i_I");
    static STRUCT_IF_C Ip_BFu16i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_I, Ip_BFu16i_I)
//============================================================================


struct  Ip_BFu16i_Ip  {
  int *v1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 Ip_BFu16i_Ip) C1{ Fp Fi:16 Fp}



static void Test_Ip_BFu16i_Ip()
{
  {
    init_simple_test("Ip_BFu16i_Ip");
    static STRUCT_IF_C Ip_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_Ip, Ip_BFu16i_Ip)
//============================================================================


struct  Ip_BFu16i_L  {
  int *v1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 Ip_BFu16i_L) C1{ Fp Fi:16 FL}



static void Test_Ip_BFu16i_L()
{
  {
    init_simple_test("Ip_BFu16i_L");
    static STRUCT_IF_C Ip_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_L, Ip_BFu16i_L)
//============================================================================


struct  Ip_BFu16i_S  {
  int *v1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 Ip_BFu16i_S) C1{ Fp Fi:16 Fs}



static void Test_Ip_BFu16i_S()
{
  {
    init_simple_test("Ip_BFu16i_S");
    static STRUCT_IF_C Ip_BFu16i_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_S, Ip_BFu16i_S)
//============================================================================


struct  Ip_BFu16i_Uc  {
  int *v1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 Ip_BFu16i_Uc) C1{ Fp Fi:16 Fc}



static void Test_Ip_BFu16i_Uc()
{
  {
    init_simple_test("Ip_BFu16i_Uc");
    static STRUCT_IF_C Ip_BFu16i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_Uc, Ip_BFu16i_Uc)
//============================================================================


struct  Ip_BFu16i_Ui  {
  int *v1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 Ip_BFu16i_Ui) C1{ Fp Fi:16 Fi}



static void Test_Ip_BFu16i_Ui()
{
  {
    init_simple_test("Ip_BFu16i_Ui");
    static STRUCT_IF_C Ip_BFu16i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_Ui, Ip_BFu16i_Ui)
//============================================================================


struct  Ip_BFu16i_Ul  {
  int *v1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 Ip_BFu16i_Ul) C1{ Fp Fi:16 FL}



static void Test_Ip_BFu16i_Ul()
{
  {
    init_simple_test("Ip_BFu16i_Ul");
    static STRUCT_IF_C Ip_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_Ul, Ip_BFu16i_Ul)
//============================================================================


struct  Ip_BFu16i_Us  {
  int *v1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 Ip_BFu16i_Us) C1{ Fp Fi:16 Fs}



static void Test_Ip_BFu16i_Us()
{
  {
    init_simple_test("Ip_BFu16i_Us");
    static STRUCT_IF_C Ip_BFu16i_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_Us, Ip_BFu16i_Us)
//============================================================================


struct  Ip_BFu16i_Vp  {
  int *v1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 Ip_BFu16i_Vp) C1{ Fp Fi:16 Fp}



static void Test_Ip_BFu16i_Vp()
{
  {
    init_simple_test("Ip_BFu16i_Vp");
    static STRUCT_IF_C Ip_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16i_Vp, Ip_BFu16i_Vp)
//============================================================================


struct  Ip_BFu16ll  {
  int *v1;
  __tsu64 v2:16;
};
//SIG(1 Ip_BFu16ll) C1{ Fp FL:16}



static void Test_Ip_BFu16ll()
{
  {
    init_simple_test("Ip_BFu16ll");
    static STRUCT_IF_C Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll, Ip_BFu16ll)
//============================================================================


struct  Ip_BFu16ll_BFu15i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu16ll_BFu15i) C1{ Fp FL:16 Fi:15}



static void Test_Ip_BFu16ll_BFu15i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu15i");
    static STRUCT_IF_C Ip_BFu16ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu15i, Ip_BFu16ll_BFu15i)
//============================================================================


struct  Ip_BFu16ll_BFu15ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu16ll_BFu15ll) C1{ Fp FL:16 FL:15}



static void Test_Ip_BFu16ll_BFu15ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu15ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu15ll, Ip_BFu16ll_BFu15ll)
//============================================================================


struct  Ip_BFu16ll_BFu15s  {
  int *v1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu16ll_BFu15s) C1{ Fp FL:16 Fs:15}



static void Test_Ip_BFu16ll_BFu15s()
{
  {
    init_simple_test("Ip_BFu16ll_BFu15s");
    static STRUCT_IF_C Ip_BFu16ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu15s, Ip_BFu16ll_BFu15s)
//============================================================================


struct  Ip_BFu16ll_BFu16i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu16ll_BFu16i) C1{ Fp FL:16 Fi:16}



static void Test_Ip_BFu16ll_BFu16i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu16i");
    static STRUCT_IF_C Ip_BFu16ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu16i, Ip_BFu16ll_BFu16i)
//============================================================================


struct  Ip_BFu16ll_BFu16ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu16ll_BFu16ll) C1{ Fp FL:16 FL:16}



static void Test_Ip_BFu16ll_BFu16ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu16ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu16ll, Ip_BFu16ll_BFu16ll)
//============================================================================


struct  Ip_BFu16ll_BFu16s  {
  int *v1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu16ll_BFu16s) C1{ Fp FL:16 Fs:16}



static void Test_Ip_BFu16ll_BFu16s()
{
  {
    init_simple_test("Ip_BFu16ll_BFu16s");
    static STRUCT_IF_C Ip_BFu16ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu16s, Ip_BFu16ll_BFu16s)
//============================================================================


struct  Ip_BFu16ll_BFu17i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu16ll_BFu17i) C1{ Fp FL:16 Fi:17}



static void Test_Ip_BFu16ll_BFu17i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu17i");
    static STRUCT_IF_C Ip_BFu16ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu17i, Ip_BFu16ll_BFu17i)
//============================================================================


struct  Ip_BFu16ll_BFu17ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu16ll_BFu17ll) C1{ Fp FL:16 FL:17}



static void Test_Ip_BFu16ll_BFu17ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu17ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Ip_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Ip_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu17ll, Ip_BFu16ll_BFu17ll)
//============================================================================


struct  Ip_BFu16ll_BFu1c  {
  int *v1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu16ll_BFu1c) C1{ Fp FL:16 Fc:1}



static void Test_Ip_BFu16ll_BFu1c()
{
  {
    init_simple_test("Ip_BFu16ll_BFu1c");
    static STRUCT_IF_C Ip_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu1c, Ip_BFu16ll_BFu1c)
//============================================================================


struct  Ip_BFu16ll_BFu1i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu16ll_BFu1i) C1{ Fp FL:16 Fi:1}



static void Test_Ip_BFu16ll_BFu1i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu1i");
    static STRUCT_IF_C Ip_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu1i, Ip_BFu16ll_BFu1i)
//============================================================================


struct  Ip_BFu16ll_BFu1ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu16ll_BFu1ll) C1{ Fp FL:16 FL:1}



static void Test_Ip_BFu16ll_BFu1ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu1ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu1ll, Ip_BFu16ll_BFu1ll)
//============================================================================


struct  Ip_BFu16ll_BFu1s  {
  int *v1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu16ll_BFu1s) C1{ Fp FL:16 Fs:1}



static void Test_Ip_BFu16ll_BFu1s()
{
  {
    init_simple_test("Ip_BFu16ll_BFu1s");
    static STRUCT_IF_C Ip_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu1s, Ip_BFu16ll_BFu1s)
//============================================================================


struct  Ip_BFu16ll_BFu31i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu16ll_BFu31i) C1{ Fp FL:16 Fi:31}



static void Test_Ip_BFu16ll_BFu31i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu31i");
    static STRUCT_IF_C Ip_BFu16ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu31i, Ip_BFu16ll_BFu31i)
//============================================================================


struct  Ip_BFu16ll_BFu31ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu16ll_BFu31ll) C1{ Fp FL:16 FL:31}



static void Test_Ip_BFu16ll_BFu31ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu31ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Ip_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Ip_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu31ll, Ip_BFu16ll_BFu31ll)
//============================================================================


struct  Ip_BFu16ll_BFu32i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu16ll_BFu32i) C1{ Fp FL:16 Fi:32}



static void Test_Ip_BFu16ll_BFu32i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu32i");
    static STRUCT_IF_C Ip_BFu16ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu32i, Ip_BFu16ll_BFu32i)
//============================================================================


struct  Ip_BFu16ll_BFu32ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu16ll_BFu32ll) C1{ Fp FL:16 FL:32}



static void Test_Ip_BFu16ll_BFu32ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu32ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Ip_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Ip_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu32ll, Ip_BFu16ll_BFu32ll)
//============================================================================


struct  Ip_BFu16ll_BFu33  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu16ll_BFu33) C1{ Fp FL:16 FL:33}



static void Test_Ip_BFu16ll_BFu33()
{
  {
    init_simple_test("Ip_BFu16ll_BFu33");
    static STRUCT_IF_C Ip_BFu16ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "Ip_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "Ip_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu33, Ip_BFu16ll_BFu33)
//============================================================================


struct  Ip_BFu16ll_BFu7c  {
  int *v1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu16ll_BFu7c) C1{ Fp FL:16 Fc:7}



static void Test_Ip_BFu16ll_BFu7c()
{
  {
    init_simple_test("Ip_BFu16ll_BFu7c");
    static STRUCT_IF_C Ip_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu7c, Ip_BFu16ll_BFu7c)
//============================================================================


struct  Ip_BFu16ll_BFu7i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu16ll_BFu7i) C1{ Fp FL:16 Fi:7}



static void Test_Ip_BFu16ll_BFu7i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu7i");
    static STRUCT_IF_C Ip_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu7i, Ip_BFu16ll_BFu7i)
//============================================================================


struct  Ip_BFu16ll_BFu7ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu16ll_BFu7ll) C1{ Fp FL:16 FL:7}



static void Test_Ip_BFu16ll_BFu7ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu7ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu7ll, Ip_BFu16ll_BFu7ll)
//============================================================================


struct  Ip_BFu16ll_BFu7s  {
  int *v1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu16ll_BFu7s) C1{ Fp FL:16 Fs:7}



static void Test_Ip_BFu16ll_BFu7s()
{
  {
    init_simple_test("Ip_BFu16ll_BFu7s");
    static STRUCT_IF_C Ip_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu7s, Ip_BFu16ll_BFu7s)
//============================================================================


struct  Ip_BFu16ll_BFu8c  {
  int *v1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu16ll_BFu8c) C1{ Fp FL:16 Fc:8}



static void Test_Ip_BFu16ll_BFu8c()
{
  {
    init_simple_test("Ip_BFu16ll_BFu8c");
    static STRUCT_IF_C Ip_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu8c, Ip_BFu16ll_BFu8c)
//============================================================================


struct  Ip_BFu16ll_BFu8i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu16ll_BFu8i) C1{ Fp FL:16 Fi:8}



static void Test_Ip_BFu16ll_BFu8i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu8i");
    static STRUCT_IF_C Ip_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu8i, Ip_BFu16ll_BFu8i)
//============================================================================


struct  Ip_BFu16ll_BFu8ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu16ll_BFu8ll) C1{ Fp FL:16 FL:8}



static void Test_Ip_BFu16ll_BFu8ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu8ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu8ll, Ip_BFu16ll_BFu8ll)
//============================================================================


struct  Ip_BFu16ll_BFu8s  {
  int *v1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu16ll_BFu8s) C1{ Fp FL:16 Fs:8}



static void Test_Ip_BFu16ll_BFu8s()
{
  {
    init_simple_test("Ip_BFu16ll_BFu8s");
    static STRUCT_IF_C Ip_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu8s, Ip_BFu16ll_BFu8s)
//============================================================================


struct  Ip_BFu16ll_BFu9i  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu16ll_BFu9i) C1{ Fp FL:16 Fi:9}



static void Test_Ip_BFu16ll_BFu9i()
{
  {
    init_simple_test("Ip_BFu16ll_BFu9i");
    static STRUCT_IF_C Ip_BFu16ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu9i, Ip_BFu16ll_BFu9i)
//============================================================================


struct  Ip_BFu16ll_BFu9ll  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu16ll_BFu9ll) C1{ Fp FL:16 FL:9}



static void Test_Ip_BFu16ll_BFu9ll()
{
  {
    init_simple_test("Ip_BFu16ll_BFu9ll");
    static STRUCT_IF_C Ip_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu9ll, Ip_BFu16ll_BFu9ll)
//============================================================================


struct  Ip_BFu16ll_BFu9s  {
  int *v1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu16ll_BFu9s) C1{ Fp FL:16 Fs:9}



static void Test_Ip_BFu16ll_BFu9s()
{
  {
    init_simple_test("Ip_BFu16ll_BFu9s");
    static STRUCT_IF_C Ip_BFu16ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_BFu9s, Ip_BFu16ll_BFu9s)
//============================================================================


struct  Ip_BFu16ll_C  {
  int *v1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 Ip_BFu16ll_C) C1{ Fp FL:16 Fc}



static void Test_Ip_BFu16ll_C()
{
  {
    init_simple_test("Ip_BFu16ll_C");
    static STRUCT_IF_C Ip_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_C, Ip_BFu16ll_C)
//============================================================================


struct  Ip_BFu16ll_D  {
  int *v1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 Ip_BFu16ll_D) C1{ Fp FL:16 FL}



static void Test_Ip_BFu16ll_D()
{
  {
    init_simple_test("Ip_BFu16ll_D");
    static STRUCT_IF_C Ip_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_D, Ip_BFu16ll_D)
//============================================================================


struct  Ip_BFu16ll_F  {
  int *v1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 Ip_BFu16ll_F) C1{ Fp FL:16 Fi}



static void Test_Ip_BFu16ll_F()
{
  {
    init_simple_test("Ip_BFu16ll_F");
    static STRUCT_IF_C Ip_BFu16ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_F, Ip_BFu16ll_F)
//============================================================================


struct  Ip_BFu16ll_I  {
  int *v1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 Ip_BFu16ll_I) C1{ Fp FL:16 Fi}



static void Test_Ip_BFu16ll_I()
{
  {
    init_simple_test("Ip_BFu16ll_I");
    static STRUCT_IF_C Ip_BFu16ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_I, Ip_BFu16ll_I)
//============================================================================


struct  Ip_BFu16ll_Ip  {
  int *v1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 Ip_BFu16ll_Ip) C1{ Fp FL:16 Fp}



static void Test_Ip_BFu16ll_Ip()
{
  {
    init_simple_test("Ip_BFu16ll_Ip");
    static STRUCT_IF_C Ip_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_Ip, Ip_BFu16ll_Ip)
//============================================================================


struct  Ip_BFu16ll_L  {
  int *v1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 Ip_BFu16ll_L) C1{ Fp FL:16 FL}



static void Test_Ip_BFu16ll_L()
{
  {
    init_simple_test("Ip_BFu16ll_L");
    static STRUCT_IF_C Ip_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_L, Ip_BFu16ll_L)
//============================================================================


struct  Ip_BFu16ll_S  {
  int *v1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 Ip_BFu16ll_S) C1{ Fp FL:16 Fs}



static void Test_Ip_BFu16ll_S()
{
  {
    init_simple_test("Ip_BFu16ll_S");
    static STRUCT_IF_C Ip_BFu16ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_S, Ip_BFu16ll_S)
//============================================================================


struct  Ip_BFu16ll_Uc  {
  int *v1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 Ip_BFu16ll_Uc) C1{ Fp FL:16 Fc}



static void Test_Ip_BFu16ll_Uc()
{
  {
    init_simple_test("Ip_BFu16ll_Uc");
    static STRUCT_IF_C Ip_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_Uc, Ip_BFu16ll_Uc)
//============================================================================


struct  Ip_BFu16ll_Ui  {
  int *v1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 Ip_BFu16ll_Ui) C1{ Fp FL:16 Fi}



static void Test_Ip_BFu16ll_Ui()
{
  {
    init_simple_test("Ip_BFu16ll_Ui");
    static STRUCT_IF_C Ip_BFu16ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_Ui, Ip_BFu16ll_Ui)
//============================================================================


struct  Ip_BFu16ll_Ul  {
  int *v1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 Ip_BFu16ll_Ul) C1{ Fp FL:16 FL}



static void Test_Ip_BFu16ll_Ul()
{
  {
    init_simple_test("Ip_BFu16ll_Ul");
    static STRUCT_IF_C Ip_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_Ul, Ip_BFu16ll_Ul)
//============================================================================


struct  Ip_BFu16ll_Us  {
  int *v1;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 Ip_BFu16ll_Us) C1{ Fp FL:16 Fs}



static void Test_Ip_BFu16ll_Us()
{
  {
    init_simple_test("Ip_BFu16ll_Us");
    static STRUCT_IF_C Ip_BFu16ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_Us, Ip_BFu16ll_Us)
//============================================================================


struct  Ip_BFu16ll_Vp  {
  int *v1;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 Ip_BFu16ll_Vp) C1{ Fp FL:16 Fp}



static void Test_Ip_BFu16ll_Vp()
{
  {
    init_simple_test("Ip_BFu16ll_Vp");
    static STRUCT_IF_C Ip_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16ll_Vp, Ip_BFu16ll_Vp)
//============================================================================


struct  Ip_BFu16s  {
  int *v1;
  unsigned short v2:16;
};
//SIG(1 Ip_BFu16s) C1{ Fp Fs:16}



static void Test_Ip_BFu16s()
{
  {
    init_simple_test("Ip_BFu16s");
    static STRUCT_IF_C Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s, Ip_BFu16s)
//============================================================================


struct  Ip_BFu16s_BFu15i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu16s_BFu15i) C1{ Fp Fs:16 Fi:15}



static void Test_Ip_BFu16s_BFu15i()
{
  {
    init_simple_test("Ip_BFu16s_BFu15i");
    static STRUCT_IF_C Ip_BFu16s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu15i, Ip_BFu16s_BFu15i)
//============================================================================


struct  Ip_BFu16s_BFu15ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu16s_BFu15ll) C1{ Fp Fs:16 FL:15}



static void Test_Ip_BFu16s_BFu15ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu15ll");
    static STRUCT_IF_C Ip_BFu16s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu15ll, Ip_BFu16s_BFu15ll)
//============================================================================


struct  Ip_BFu16s_BFu15s  {
  int *v1;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu16s_BFu15s) C1{ Fp Fs:16 Fs:15}



static void Test_Ip_BFu16s_BFu15s()
{
  {
    init_simple_test("Ip_BFu16s_BFu15s");
    static STRUCT_IF_C Ip_BFu16s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu15s, Ip_BFu16s_BFu15s)
//============================================================================


struct  Ip_BFu16s_BFu16i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu16s_BFu16i) C1{ Fp Fs:16 Fi:16}



static void Test_Ip_BFu16s_BFu16i()
{
  {
    init_simple_test("Ip_BFu16s_BFu16i");
    static STRUCT_IF_C Ip_BFu16s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu16i, Ip_BFu16s_BFu16i)
//============================================================================


struct  Ip_BFu16s_BFu16ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu16s_BFu16ll) C1{ Fp Fs:16 FL:16}



static void Test_Ip_BFu16s_BFu16ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu16ll");
    static STRUCT_IF_C Ip_BFu16s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu16ll, Ip_BFu16s_BFu16ll)
//============================================================================


struct  Ip_BFu16s_BFu16s  {
  int *v1;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu16s_BFu16s) C1{ Fp Fs:16 Fs:16}



static void Test_Ip_BFu16s_BFu16s()
{
  {
    init_simple_test("Ip_BFu16s_BFu16s");
    static STRUCT_IF_C Ip_BFu16s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu16s, Ip_BFu16s_BFu16s)
//============================================================================


struct  Ip_BFu16s_BFu17i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu16s_BFu17i) C1{ Fp Fs:16 Fi:17}



static void Test_Ip_BFu16s_BFu17i()
{
  {
    init_simple_test("Ip_BFu16s_BFu17i");
    static STRUCT_IF_C Ip_BFu16s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu17i, Ip_BFu16s_BFu17i)
//============================================================================


struct  Ip_BFu16s_BFu17ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu16s_BFu17ll) C1{ Fp Fs:16 FL:17}



static void Test_Ip_BFu16s_BFu17ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu17ll");
    static STRUCT_IF_C Ip_BFu16s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Ip_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Ip_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu17ll, Ip_BFu16s_BFu17ll)
//============================================================================


struct  Ip_BFu16s_BFu1c  {
  int *v1;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu16s_BFu1c) C1{ Fp Fs:16 Fc:1}



static void Test_Ip_BFu16s_BFu1c()
{
  {
    init_simple_test("Ip_BFu16s_BFu1c");
    static STRUCT_IF_C Ip_BFu16s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu1c, Ip_BFu16s_BFu1c)
//============================================================================


struct  Ip_BFu16s_BFu1i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu16s_BFu1i) C1{ Fp Fs:16 Fi:1}



static void Test_Ip_BFu16s_BFu1i()
{
  {
    init_simple_test("Ip_BFu16s_BFu1i");
    static STRUCT_IF_C Ip_BFu16s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu1i, Ip_BFu16s_BFu1i)
//============================================================================


struct  Ip_BFu16s_BFu1ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu16s_BFu1ll) C1{ Fp Fs:16 FL:1}



static void Test_Ip_BFu16s_BFu1ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu1ll");
    static STRUCT_IF_C Ip_BFu16s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu1ll, Ip_BFu16s_BFu1ll)
//============================================================================


struct  Ip_BFu16s_BFu1s  {
  int *v1;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu16s_BFu1s) C1{ Fp Fs:16 Fs:1}



static void Test_Ip_BFu16s_BFu1s()
{
  {
    init_simple_test("Ip_BFu16s_BFu1s");
    static STRUCT_IF_C Ip_BFu16s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Ip_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu1s, Ip_BFu16s_BFu1s)
//============================================================================


struct  Ip_BFu16s_BFu31i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu16s_BFu31i) C1{ Fp Fs:16 Fi:31}



static void Test_Ip_BFu16s_BFu31i()
{
  {
    init_simple_test("Ip_BFu16s_BFu31i");
    static STRUCT_IF_C Ip_BFu16s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu31i, Ip_BFu16s_BFu31i)
//============================================================================


struct  Ip_BFu16s_BFu31ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu16s_BFu31ll) C1{ Fp Fs:16 FL:31}



static void Test_Ip_BFu16s_BFu31ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu31ll");
    static STRUCT_IF_C Ip_BFu16s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Ip_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Ip_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu31ll, Ip_BFu16s_BFu31ll)
//============================================================================


struct  Ip_BFu16s_BFu32i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu16s_BFu32i) C1{ Fp Fs:16 Fi:32}



static void Test_Ip_BFu16s_BFu32i()
{
  {
    init_simple_test("Ip_BFu16s_BFu32i");
    static STRUCT_IF_C Ip_BFu16s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu32i, Ip_BFu16s_BFu32i)
//============================================================================


struct  Ip_BFu16s_BFu32ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu16s_BFu32ll) C1{ Fp Fs:16 FL:32}



static void Test_Ip_BFu16s_BFu32ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu32ll");
    static STRUCT_IF_C Ip_BFu16s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Ip_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Ip_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu32ll, Ip_BFu16s_BFu32ll)
//============================================================================


struct  Ip_BFu16s_BFu33  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu16s_BFu33) C1{ Fp Fs:16 FL:33}



static void Test_Ip_BFu16s_BFu33()
{
  {
    init_simple_test("Ip_BFu16s_BFu33");
    static STRUCT_IF_C Ip_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "Ip_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "Ip_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu33, Ip_BFu16s_BFu33)
//============================================================================


struct  Ip_BFu16s_BFu7c  {
  int *v1;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu16s_BFu7c) C1{ Fp Fs:16 Fc:7}



static void Test_Ip_BFu16s_BFu7c()
{
  {
    init_simple_test("Ip_BFu16s_BFu7c");
    static STRUCT_IF_C Ip_BFu16s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu7c, Ip_BFu16s_BFu7c)
//============================================================================


struct  Ip_BFu16s_BFu7i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu16s_BFu7i) C1{ Fp Fs:16 Fi:7}



static void Test_Ip_BFu16s_BFu7i()
{
  {
    init_simple_test("Ip_BFu16s_BFu7i");
    static STRUCT_IF_C Ip_BFu16s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu7i, Ip_BFu16s_BFu7i)
//============================================================================


struct  Ip_BFu16s_BFu7ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu16s_BFu7ll) C1{ Fp Fs:16 FL:7}



static void Test_Ip_BFu16s_BFu7ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu7ll");
    static STRUCT_IF_C Ip_BFu16s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu7ll, Ip_BFu16s_BFu7ll)
//============================================================================


struct  Ip_BFu16s_BFu7s  {
  int *v1;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu16s_BFu7s) C1{ Fp Fs:16 Fs:7}



static void Test_Ip_BFu16s_BFu7s()
{
  {
    init_simple_test("Ip_BFu16s_BFu7s");
    static STRUCT_IF_C Ip_BFu16s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Ip_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Ip_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu7s, Ip_BFu16s_BFu7s)
//============================================================================


struct  Ip_BFu16s_BFu8c  {
  int *v1;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu16s_BFu8c) C1{ Fp Fs:16 Fc:8}



static void Test_Ip_BFu16s_BFu8c()
{
  {
    init_simple_test("Ip_BFu16s_BFu8c");
    static STRUCT_IF_C Ip_BFu16s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu8c, Ip_BFu16s_BFu8c)
//============================================================================


struct  Ip_BFu16s_BFu8i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu16s_BFu8i) C1{ Fp Fs:16 Fi:8}



static void Test_Ip_BFu16s_BFu8i()
{
  {
    init_simple_test("Ip_BFu16s_BFu8i");
    static STRUCT_IF_C Ip_BFu16s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu8i, Ip_BFu16s_BFu8i)
//============================================================================


struct  Ip_BFu16s_BFu8ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu16s_BFu8ll) C1{ Fp Fs:16 FL:8}



static void Test_Ip_BFu16s_BFu8ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu8ll");
    static STRUCT_IF_C Ip_BFu16s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu8ll, Ip_BFu16s_BFu8ll)
//============================================================================


struct  Ip_BFu16s_BFu8s  {
  int *v1;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu16s_BFu8s) C1{ Fp Fs:16 Fs:8}



static void Test_Ip_BFu16s_BFu8s()
{
  {
    init_simple_test("Ip_BFu16s_BFu8s");
    static STRUCT_IF_C Ip_BFu16s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu8s, Ip_BFu16s_BFu8s)
//============================================================================


struct  Ip_BFu16s_BFu9i  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu16s_BFu9i) C1{ Fp Fs:16 Fi:9}



static void Test_Ip_BFu16s_BFu9i()
{
  {
    init_simple_test("Ip_BFu16s_BFu9i");
    static STRUCT_IF_C Ip_BFu16s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu9i, Ip_BFu16s_BFu9i)
//============================================================================


struct  Ip_BFu16s_BFu9ll  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu16s_BFu9ll) C1{ Fp Fs:16 FL:9}



static void Test_Ip_BFu16s_BFu9ll()
{
  {
    init_simple_test("Ip_BFu16s_BFu9ll");
    static STRUCT_IF_C Ip_BFu16s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu9ll, Ip_BFu16s_BFu9ll)
//============================================================================


struct  Ip_BFu16s_BFu9s  {
  int *v1;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu16s_BFu9s) C1{ Fp Fs:16 Fs:9}



static void Test_Ip_BFu16s_BFu9s()
{
  {
    init_simple_test("Ip_BFu16s_BFu9s");
    static STRUCT_IF_C Ip_BFu16s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_BFu9s, Ip_BFu16s_BFu9s)
//============================================================================


struct  Ip_BFu16s_C  {
  int *v1;
  unsigned short v2:16;
  char v3;
};
//SIG(1 Ip_BFu16s_C) C1{ Fp Fs:16 Fc}



static void Test_Ip_BFu16s_C()
{
  {
    init_simple_test("Ip_BFu16s_C");
    static STRUCT_IF_C Ip_BFu16s_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_C, Ip_BFu16s_C)
//============================================================================


struct  Ip_BFu16s_D  {
  int *v1;
  unsigned short v2:16;
  double v3;
};
//SIG(1 Ip_BFu16s_D) C1{ Fp Fs:16 FL}



static void Test_Ip_BFu16s_D()
{
  {
    init_simple_test("Ip_BFu16s_D");
    static STRUCT_IF_C Ip_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_D, Ip_BFu16s_D)
//============================================================================


struct  Ip_BFu16s_F  {
  int *v1;
  unsigned short v2:16;
  float v3;
};
//SIG(1 Ip_BFu16s_F) C1{ Fp Fs:16 Fi}



static void Test_Ip_BFu16s_F()
{
  {
    init_simple_test("Ip_BFu16s_F");
    static STRUCT_IF_C Ip_BFu16s_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_F, Ip_BFu16s_F)
//============================================================================


struct  Ip_BFu16s_I  {
  int *v1;
  unsigned short v2:16;
  int v3;
};
//SIG(1 Ip_BFu16s_I) C1{ Fp Fs:16 Fi}



static void Test_Ip_BFu16s_I()
{
  {
    init_simple_test("Ip_BFu16s_I");
    static STRUCT_IF_C Ip_BFu16s_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_I, Ip_BFu16s_I)
//============================================================================


struct  Ip_BFu16s_Ip  {
  int *v1;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 Ip_BFu16s_Ip) C1{ Fp Fs:16 Fp}



static void Test_Ip_BFu16s_Ip()
{
  {
    init_simple_test("Ip_BFu16s_Ip");
    static STRUCT_IF_C Ip_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_Ip, Ip_BFu16s_Ip)
//============================================================================


struct  Ip_BFu16s_L  {
  int *v1;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 Ip_BFu16s_L) C1{ Fp Fs:16 FL}



static void Test_Ip_BFu16s_L()
{
  {
    init_simple_test("Ip_BFu16s_L");
    static STRUCT_IF_C Ip_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_L, Ip_BFu16s_L)
//============================================================================


struct  Ip_BFu16s_S  {
  int *v1;
  unsigned short v2:16;
  short v3;
};
//SIG(1 Ip_BFu16s_S) C1{ Fp Fs:16 Fs}



static void Test_Ip_BFu16s_S()
{
  {
    init_simple_test("Ip_BFu16s_S");
    static STRUCT_IF_C Ip_BFu16s_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_S, Ip_BFu16s_S)
//============================================================================


struct  Ip_BFu16s_Uc  {
  int *v1;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 Ip_BFu16s_Uc) C1{ Fp Fs:16 Fc}



static void Test_Ip_BFu16s_Uc()
{
  {
    init_simple_test("Ip_BFu16s_Uc");
    static STRUCT_IF_C Ip_BFu16s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_Uc, Ip_BFu16s_Uc)
//============================================================================


struct  Ip_BFu16s_Ui  {
  int *v1;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 Ip_BFu16s_Ui) C1{ Fp Fs:16 Fi}



static void Test_Ip_BFu16s_Ui()
{
  {
    init_simple_test("Ip_BFu16s_Ui");
    static STRUCT_IF_C Ip_BFu16s_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu16s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_Ui, Ip_BFu16s_Ui)
//============================================================================


struct  Ip_BFu16s_Ul  {
  int *v1;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 Ip_BFu16s_Ul) C1{ Fp Fs:16 FL}



static void Test_Ip_BFu16s_Ul()
{
  {
    init_simple_test("Ip_BFu16s_Ul");
    static STRUCT_IF_C Ip_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_Ul, Ip_BFu16s_Ul)
//============================================================================


struct  Ip_BFu16s_Us  {
  int *v1;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 Ip_BFu16s_Us) C1{ Fp Fs:16 Fs}



static void Test_Ip_BFu16s_Us()
{
  {
    init_simple_test("Ip_BFu16s_Us");
    static STRUCT_IF_C Ip_BFu16s_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu16s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_Us, Ip_BFu16s_Us)
//============================================================================


struct  Ip_BFu16s_Vp  {
  int *v1;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 Ip_BFu16s_Vp) C1{ Fp Fs:16 Fp}



static void Test_Ip_BFu16s_Vp()
{
  {
    init_simple_test("Ip_BFu16s_Vp");
    static STRUCT_IF_C Ip_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ip_BFu16s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ip_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu16s_Vp, Ip_BFu16s_Vp)
//============================================================================


struct  Ip_BFu17i  {
  int *v1;
  unsigned int v2:17;
};
//SIG(1 Ip_BFu17i) C1{ Fp Fi:17}



static void Test_Ip_BFu17i()
{
  {
    init_simple_test("Ip_BFu17i");
    static STRUCT_IF_C Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i, Ip_BFu17i)
//============================================================================


struct  Ip_BFu17i_BFu15i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu17i_BFu15i) C1{ Fp Fi:17 Fi:15}



static void Test_Ip_BFu17i_BFu15i()
{
  {
    init_simple_test("Ip_BFu17i_BFu15i");
    static STRUCT_IF_C Ip_BFu17i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Ip_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Ip_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu15i, Ip_BFu17i_BFu15i)
//============================================================================


struct  Ip_BFu17i_BFu15ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu17i_BFu15ll) C1{ Fp Fi:17 FL:15}



static void Test_Ip_BFu17i_BFu15ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu15ll");
    static STRUCT_IF_C Ip_BFu17i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Ip_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Ip_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu15ll, Ip_BFu17i_BFu15ll)
//============================================================================


struct  Ip_BFu17i_BFu15s  {
  int *v1;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu17i_BFu15s) C1{ Fp Fi:17 Fs:15}



static void Test_Ip_BFu17i_BFu15s()
{
  {
    init_simple_test("Ip_BFu17i_BFu15s");
    static STRUCT_IF_C Ip_BFu17i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Ip_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Ip_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu15s, Ip_BFu17i_BFu15s)
//============================================================================


struct  Ip_BFu17i_BFu16i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu17i_BFu16i) C1{ Fp Fi:17 Fi:16}



static void Test_Ip_BFu17i_BFu16i()
{
  {
    init_simple_test("Ip_BFu17i_BFu16i");
    static STRUCT_IF_C Ip_BFu17i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu16i, Ip_BFu17i_BFu16i)
//============================================================================


struct  Ip_BFu17i_BFu16ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu17i_BFu16ll) C1{ Fp Fi:17 FL:16}



static void Test_Ip_BFu17i_BFu16ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu16ll");
    static STRUCT_IF_C Ip_BFu17i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 16, 1, "Ip_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 16, hide_ull(1LL<<15), "Ip_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu16ll, Ip_BFu17i_BFu16ll)
//============================================================================


struct  Ip_BFu17i_BFu16s  {
  int *v1;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu17i_BFu16s) C1{ Fp Fi:17 Fs:16}



static void Test_Ip_BFu17i_BFu16s()
{
  {
    init_simple_test("Ip_BFu17i_BFu16s");
    static STRUCT_IF_C Ip_BFu17i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu16s, Ip_BFu17i_BFu16s)
//============================================================================


struct  Ip_BFu17i_BFu17i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu17i_BFu17i) C1{ Fp Fi:17 Fi:17}



static void Test_Ip_BFu17i_BFu17i()
{
  {
    init_simple_test("Ip_BFu17i_BFu17i");
    static STRUCT_IF_C Ip_BFu17i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu17i, Ip_BFu17i_BFu17i)
//============================================================================


struct  Ip_BFu17i_BFu17ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu17i_BFu17ll) C1{ Fp Fi:17 FL:17}



static void Test_Ip_BFu17i_BFu17ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu17ll");
    static STRUCT_IF_C Ip_BFu17i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 17, 1, "Ip_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu17ll, Ip_BFu17i_BFu17ll)
//============================================================================


struct  Ip_BFu17i_BFu1c  {
  int *v1;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu17i_BFu1c) C1{ Fp Fi:17 Fc:1}



static void Test_Ip_BFu17i_BFu1c()
{
  {
    init_simple_test("Ip_BFu17i_BFu1c");
    static STRUCT_IF_C Ip_BFu17i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Ip_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu1c, Ip_BFu17i_BFu1c)
//============================================================================


struct  Ip_BFu17i_BFu1i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu17i_BFu1i) C1{ Fp Fi:17 Fi:1}



static void Test_Ip_BFu17i_BFu1i()
{
  {
    init_simple_test("Ip_BFu17i_BFu1i");
    static STRUCT_IF_C Ip_BFu17i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Ip_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu1i, Ip_BFu17i_BFu1i)
//============================================================================


struct  Ip_BFu17i_BFu1ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu17i_BFu1ll) C1{ Fp Fi:17 FL:1}



static void Test_Ip_BFu17i_BFu1ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu1ll");
    static STRUCT_IF_C Ip_BFu17i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Ip_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu1ll, Ip_BFu17i_BFu1ll)
//============================================================================


struct  Ip_BFu17i_BFu1s  {
  int *v1;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu17i_BFu1s) C1{ Fp Fi:17 Fs:1}



static void Test_Ip_BFu17i_BFu1s()
{
  {
    init_simple_test("Ip_BFu17i_BFu1s");
    static STRUCT_IF_C Ip_BFu17i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Ip_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu1s, Ip_BFu17i_BFu1s)
//============================================================================


struct  Ip_BFu17i_BFu31i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu17i_BFu31i) C1{ Fp Fi:17 Fi:31}



static void Test_Ip_BFu17i_BFu31i()
{
  {
    init_simple_test("Ip_BFu17i_BFu31i");
    static STRUCT_IF_C Ip_BFu17i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu31i, Ip_BFu17i_BFu31i)
//============================================================================


struct  Ip_BFu17i_BFu31ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu17i_BFu31ll) C1{ Fp Fi:17 FL:31}



static void Test_Ip_BFu17i_BFu31ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu31ll");
    static STRUCT_IF_C Ip_BFu17i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 31, 1, "Ip_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 31, hide_ull(1LL<<30), "Ip_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu31ll, Ip_BFu17i_BFu31ll)
//============================================================================


struct  Ip_BFu17i_BFu32i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu17i_BFu32i) C1{ Fp Fi:17 Fi:32}



static void Test_Ip_BFu17i_BFu32i()
{
  {
    init_simple_test("Ip_BFu17i_BFu32i");
    static STRUCT_IF_C Ip_BFu17i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu32i, Ip_BFu17i_BFu32i)
//============================================================================


struct  Ip_BFu17i_BFu32ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu17i_BFu32ll) C1{ Fp Fi:17 FL:32}



static void Test_Ip_BFu17i_BFu32ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu32ll");
    static STRUCT_IF_C Ip_BFu17i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 32, 1, "Ip_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu32ll, Ip_BFu17i_BFu32ll)
//============================================================================


struct  Ip_BFu17i_BFu33  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu17i_BFu33) C1{ Fp Fi:17 FL:33}



static void Test_Ip_BFu17i_BFu33()
{
  {
    init_simple_test("Ip_BFu17i_BFu33");
    static STRUCT_IF_C Ip_BFu17i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 33, 1, "Ip_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu33, Ip_BFu17i_BFu33)
//============================================================================


struct  Ip_BFu17i_BFu7c  {
  int *v1;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu17i_BFu7c) C1{ Fp Fi:17 Fc:7}



static void Test_Ip_BFu17i_BFu7c()
{
  {
    init_simple_test("Ip_BFu17i_BFu7c");
    static STRUCT_IF_C Ip_BFu17i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Ip_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Ip_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu7c, Ip_BFu17i_BFu7c)
//============================================================================


struct  Ip_BFu17i_BFu7i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu17i_BFu7i) C1{ Fp Fi:17 Fi:7}



static void Test_Ip_BFu17i_BFu7i()
{
  {
    init_simple_test("Ip_BFu17i_BFu7i");
    static STRUCT_IF_C Ip_BFu17i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Ip_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Ip_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu7i, Ip_BFu17i_BFu7i)
//============================================================================


struct  Ip_BFu17i_BFu7ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu17i_BFu7ll) C1{ Fp Fi:17 FL:7}



static void Test_Ip_BFu17i_BFu7ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu7ll");
    static STRUCT_IF_C Ip_BFu17i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Ip_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Ip_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu7ll, Ip_BFu17i_BFu7ll)
//============================================================================


struct  Ip_BFu17i_BFu7s  {
  int *v1;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu17i_BFu7s) C1{ Fp Fi:17 Fs:7}



static void Test_Ip_BFu17i_BFu7s()
{
  {
    init_simple_test("Ip_BFu17i_BFu7s");
    static STRUCT_IF_C Ip_BFu17i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Ip_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Ip_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu7s, Ip_BFu17i_BFu7s)
//============================================================================


struct  Ip_BFu17i_BFu8c  {
  int *v1;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu17i_BFu8c) C1{ Fp Fi:17 Fc:8}



static void Test_Ip_BFu17i_BFu8c()
{
  {
    init_simple_test("Ip_BFu17i_BFu8c");
    static STRUCT_IF_C Ip_BFu17i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 0, 8, 1, "Ip_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 0, 8, hide_ull(1LL<<7), "Ip_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu8c, Ip_BFu17i_BFu8c)
//============================================================================


struct  Ip_BFu17i_BFu8i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu17i_BFu8i) C1{ Fp Fi:17 Fi:8}



static void Test_Ip_BFu17i_BFu8i()
{
  {
    init_simple_test("Ip_BFu17i_BFu8i");
    static STRUCT_IF_C Ip_BFu17i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Ip_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Ip_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu8i, Ip_BFu17i_BFu8i)
//============================================================================


struct  Ip_BFu17i_BFu8ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu17i_BFu8ll) C1{ Fp Fi:17 FL:8}



static void Test_Ip_BFu17i_BFu8ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu8ll");
    static STRUCT_IF_C Ip_BFu17i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Ip_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Ip_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu8ll, Ip_BFu17i_BFu8ll)
//============================================================================


struct  Ip_BFu17i_BFu8s  {
  int *v1;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu17i_BFu8s) C1{ Fp Fi:17 Fs:8}



static void Test_Ip_BFu17i_BFu8s()
{
  {
    init_simple_test("Ip_BFu17i_BFu8s");
    static STRUCT_IF_C Ip_BFu17i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Ip_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Ip_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu8s, Ip_BFu17i_BFu8s)
//============================================================================


struct  Ip_BFu17i_BFu9i  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu17i_BFu9i) C1{ Fp Fi:17 Fi:9}



static void Test_Ip_BFu17i_BFu9i()
{
  {
    init_simple_test("Ip_BFu17i_BFu9i");
    static STRUCT_IF_C Ip_BFu17i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Ip_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Ip_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu9i, Ip_BFu17i_BFu9i)
//============================================================================


struct  Ip_BFu17i_BFu9ll  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu17i_BFu9ll) C1{ Fp Fi:17 FL:9}



static void Test_Ip_BFu17i_BFu9ll()
{
  {
    init_simple_test("Ip_BFu17i_BFu9ll");
    static STRUCT_IF_C Ip_BFu17i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Ip_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Ip_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu9ll, Ip_BFu17i_BFu9ll)
//============================================================================


struct  Ip_BFu17i_BFu9s  {
  int *v1;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu17i_BFu9s) C1{ Fp Fi:17 Fs:9}



static void Test_Ip_BFu17i_BFu9s()
{
  {
    init_simple_test("Ip_BFu17i_BFu9s");
    static STRUCT_IF_C Ip_BFu17i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Ip_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Ip_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_BFu9s, Ip_BFu17i_BFu9s)
//============================================================================


struct  Ip_BFu17i_C  {
  int *v1;
  unsigned int v2:17;
  char v3;
};
//SIG(1 Ip_BFu17i_C) C1{ Fp Fi:17 Fc}



static void Test_Ip_BFu17i_C()
{
  {
    init_simple_test("Ip_BFu17i_C");
    static STRUCT_IF_C Ip_BFu17i_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_C");
    check_field_offset(lv, v3, ABISELECT(11,7), "Ip_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_C, Ip_BFu17i_C)
//============================================================================


struct  Ip_BFu17i_D  {
  int *v1;
  unsigned int v2:17;
  double v3;
};
//SIG(1 Ip_BFu17i_D) C1{ Fp Fi:17 FL}



static void Test_Ip_BFu17i_D()
{
  {
    init_simple_test("Ip_BFu17i_D");
    static STRUCT_IF_C Ip_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_D, Ip_BFu17i_D)
//============================================================================


struct  Ip_BFu17i_F  {
  int *v1;
  unsigned int v2:17;
  float v3;
};
//SIG(1 Ip_BFu17i_F) C1{ Fp Fi:17 Fi}



static void Test_Ip_BFu17i_F()
{
  {
    init_simple_test("Ip_BFu17i_F");
    static STRUCT_IF_C Ip_BFu17i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_F, Ip_BFu17i_F)
//============================================================================


struct  Ip_BFu17i_I  {
  int *v1;
  unsigned int v2:17;
  int v3;
};
//SIG(1 Ip_BFu17i_I) C1{ Fp Fi:17 Fi}



static void Test_Ip_BFu17i_I()
{
  {
    init_simple_test("Ip_BFu17i_I");
    static STRUCT_IF_C Ip_BFu17i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_I, Ip_BFu17i_I)
//============================================================================


struct  Ip_BFu17i_Ip  {
  int *v1;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 Ip_BFu17i_Ip) C1{ Fp Fi:17 Fp}



static void Test_Ip_BFu17i_Ip()
{
  {
    init_simple_test("Ip_BFu17i_Ip");
    static STRUCT_IF_C Ip_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_Ip, Ip_BFu17i_Ip)
//============================================================================


struct  Ip_BFu17i_L  {
  int *v1;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 Ip_BFu17i_L) C1{ Fp Fi:17 FL}



static void Test_Ip_BFu17i_L()
{
  {
    init_simple_test("Ip_BFu17i_L");
    static STRUCT_IF_C Ip_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_L, Ip_BFu17i_L)
//============================================================================


struct  Ip_BFu17i_S  {
  int *v1;
  unsigned int v2:17;
  short v3;
};
//SIG(1 Ip_BFu17i_S) C1{ Fp Fi:17 Fs}



static void Test_Ip_BFu17i_S()
{
  {
    init_simple_test("Ip_BFu17i_S");
    static STRUCT_IF_C Ip_BFu17i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_S, Ip_BFu17i_S)
//============================================================================


struct  Ip_BFu17i_Uc  {
  int *v1;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 Ip_BFu17i_Uc) C1{ Fp Fi:17 Fc}



static void Test_Ip_BFu17i_Uc()
{
  {
    init_simple_test("Ip_BFu17i_Uc");
    static STRUCT_IF_C Ip_BFu17i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_Uc");
    check_field_offset(lv, v3, ABISELECT(11,7), "Ip_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_Uc, Ip_BFu17i_Uc)
//============================================================================


struct  Ip_BFu17i_Ui  {
  int *v1;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 Ip_BFu17i_Ui) C1{ Fp Fi:17 Fi}



static void Test_Ip_BFu17i_Ui()
{
  {
    init_simple_test("Ip_BFu17i_Ui");
    static STRUCT_IF_C Ip_BFu17i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_Ui, Ip_BFu17i_Ui)
//============================================================================


struct  Ip_BFu17i_Ul  {
  int *v1;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 Ip_BFu17i_Ul) C1{ Fp Fi:17 FL}



static void Test_Ip_BFu17i_Ul()
{
  {
    init_simple_test("Ip_BFu17i_Ul");
    static STRUCT_IF_C Ip_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_Ul, Ip_BFu17i_Ul)
//============================================================================


struct  Ip_BFu17i_Us  {
  int *v1;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 Ip_BFu17i_Us) C1{ Fp Fi:17 Fs}



static void Test_Ip_BFu17i_Us()
{
  {
    init_simple_test("Ip_BFu17i_Us");
    static STRUCT_IF_C Ip_BFu17i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_Us, Ip_BFu17i_Us)
//============================================================================


struct  Ip_BFu17i_Vp  {
  int *v1;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 Ip_BFu17i_Vp) C1{ Fp Fi:17 Fp}



static void Test_Ip_BFu17i_Vp()
{
  {
    init_simple_test("Ip_BFu17i_Vp");
    static STRUCT_IF_C Ip_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17i_Vp, Ip_BFu17i_Vp)
//============================================================================


struct  Ip_BFu17ll  {
  int *v1;
  __tsu64 v2:17;
};
//SIG(1 Ip_BFu17ll) C1{ Fp FL:17}



static void Test_Ip_BFu17ll()
{
  {
    init_simple_test("Ip_BFu17ll");
    static STRUCT_IF_C Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll, Ip_BFu17ll)
//============================================================================


struct  Ip_BFu17ll_BFu15i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu17ll_BFu15i) C1{ Fp FL:17 Fi:15}



static void Test_Ip_BFu17ll_BFu15i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu15i");
    static STRUCT_IF_C Ip_BFu17ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Ip_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Ip_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu15i, Ip_BFu17ll_BFu15i)
//============================================================================


struct  Ip_BFu17ll_BFu15ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu17ll_BFu15ll) C1{ Fp FL:17 FL:15}



static void Test_Ip_BFu17ll_BFu15ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu15ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Ip_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Ip_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu15ll, Ip_BFu17ll_BFu15ll)
//============================================================================


struct  Ip_BFu17ll_BFu15s  {
  int *v1;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu17ll_BFu15s) C1{ Fp FL:17 Fs:15}



static void Test_Ip_BFu17ll_BFu15s()
{
  {
    init_simple_test("Ip_BFu17ll_BFu15s");
    static STRUCT_IF_C Ip_BFu17ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Ip_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Ip_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu15s, Ip_BFu17ll_BFu15s)
//============================================================================


struct  Ip_BFu17ll_BFu16i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu17ll_BFu16i) C1{ Fp FL:17 Fi:16}



static void Test_Ip_BFu17ll_BFu16i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu16i");
    static STRUCT_IF_C Ip_BFu17ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu16i, Ip_BFu17ll_BFu16i)
//============================================================================


struct  Ip_BFu17ll_BFu16ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu17ll_BFu16ll) C1{ Fp FL:17 FL:16}



static void Test_Ip_BFu17ll_BFu16ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu16ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 16, 1, "Ip_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 16, hide_ull(1LL<<15), "Ip_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu16ll, Ip_BFu17ll_BFu16ll)
//============================================================================


struct  Ip_BFu17ll_BFu16s  {
  int *v1;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu17ll_BFu16s) C1{ Fp FL:17 Fs:16}



static void Test_Ip_BFu17ll_BFu16s()
{
  {
    init_simple_test("Ip_BFu17ll_BFu16s");
    static STRUCT_IF_C Ip_BFu17ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu16s, Ip_BFu17ll_BFu16s)
//============================================================================


struct  Ip_BFu17ll_BFu17i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu17ll_BFu17i) C1{ Fp FL:17 Fi:17}



static void Test_Ip_BFu17ll_BFu17i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu17i");
    static STRUCT_IF_C Ip_BFu17ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu17i, Ip_BFu17ll_BFu17i)
//============================================================================


struct  Ip_BFu17ll_BFu17ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu17ll_BFu17ll) C1{ Fp FL:17 FL:17}



static void Test_Ip_BFu17ll_BFu17ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu17ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 17, 1, "Ip_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu17ll, Ip_BFu17ll_BFu17ll)
//============================================================================


struct  Ip_BFu17ll_BFu1c  {
  int *v1;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu17ll_BFu1c) C1{ Fp FL:17 Fc:1}



static void Test_Ip_BFu17ll_BFu1c()
{
  {
    init_simple_test("Ip_BFu17ll_BFu1c");
    static STRUCT_IF_C Ip_BFu17ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Ip_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu1c, Ip_BFu17ll_BFu1c)
//============================================================================


struct  Ip_BFu17ll_BFu1i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu17ll_BFu1i) C1{ Fp FL:17 Fi:1}



static void Test_Ip_BFu17ll_BFu1i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu1i");
    static STRUCT_IF_C Ip_BFu17ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Ip_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu1i, Ip_BFu17ll_BFu1i)
//============================================================================


struct  Ip_BFu17ll_BFu1ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu17ll_BFu1ll) C1{ Fp FL:17 FL:1}



static void Test_Ip_BFu17ll_BFu1ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu1ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Ip_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu1ll, Ip_BFu17ll_BFu1ll)
//============================================================================


struct  Ip_BFu17ll_BFu1s  {
  int *v1;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu17ll_BFu1s) C1{ Fp FL:17 Fs:1}



static void Test_Ip_BFu17ll_BFu1s()
{
  {
    init_simple_test("Ip_BFu17ll_BFu1s");
    static STRUCT_IF_C Ip_BFu17ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Ip_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu1s, Ip_BFu17ll_BFu1s)
//============================================================================


struct  Ip_BFu17ll_BFu31i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu17ll_BFu31i) C1{ Fp FL:17 Fi:31}



static void Test_Ip_BFu17ll_BFu31i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu31i");
    static STRUCT_IF_C Ip_BFu17ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu31i, Ip_BFu17ll_BFu31i)
//============================================================================


struct  Ip_BFu17ll_BFu31ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu17ll_BFu31ll) C1{ Fp FL:17 FL:31}



static void Test_Ip_BFu17ll_BFu31ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu31ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 31, 1, "Ip_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 31, hide_ull(1LL<<30), "Ip_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu31ll, Ip_BFu17ll_BFu31ll)
//============================================================================


struct  Ip_BFu17ll_BFu32i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu17ll_BFu32i) C1{ Fp FL:17 Fi:32}



static void Test_Ip_BFu17ll_BFu32i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu32i");
    static STRUCT_IF_C Ip_BFu17ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu32i, Ip_BFu17ll_BFu32i)
//============================================================================


struct  Ip_BFu17ll_BFu32ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu17ll_BFu32ll) C1{ Fp FL:17 FL:32}



static void Test_Ip_BFu17ll_BFu32ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu32ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 32, 1, "Ip_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu32ll, Ip_BFu17ll_BFu32ll)
//============================================================================


struct  Ip_BFu17ll_BFu33  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu17ll_BFu33) C1{ Fp FL:17 FL:33}



static void Test_Ip_BFu17ll_BFu33()
{
  {
    init_simple_test("Ip_BFu17ll_BFu33");
    static STRUCT_IF_C Ip_BFu17ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 33, 1, "Ip_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu33, Ip_BFu17ll_BFu33)
//============================================================================


struct  Ip_BFu17ll_BFu7c  {
  int *v1;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu17ll_BFu7c) C1{ Fp FL:17 Fc:7}



static void Test_Ip_BFu17ll_BFu7c()
{
  {
    init_simple_test("Ip_BFu17ll_BFu7c");
    static STRUCT_IF_C Ip_BFu17ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Ip_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Ip_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu7c, Ip_BFu17ll_BFu7c)
//============================================================================


struct  Ip_BFu17ll_BFu7i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu17ll_BFu7i) C1{ Fp FL:17 Fi:7}



static void Test_Ip_BFu17ll_BFu7i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu7i");
    static STRUCT_IF_C Ip_BFu17ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Ip_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Ip_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu7i, Ip_BFu17ll_BFu7i)
//============================================================================


struct  Ip_BFu17ll_BFu7ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu17ll_BFu7ll) C1{ Fp FL:17 FL:7}



static void Test_Ip_BFu17ll_BFu7ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu7ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Ip_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Ip_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu7ll, Ip_BFu17ll_BFu7ll)
//============================================================================


struct  Ip_BFu17ll_BFu7s  {
  int *v1;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu17ll_BFu7s) C1{ Fp FL:17 Fs:7}



static void Test_Ip_BFu17ll_BFu7s()
{
  {
    init_simple_test("Ip_BFu17ll_BFu7s");
    static STRUCT_IF_C Ip_BFu17ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Ip_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Ip_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu7s, Ip_BFu17ll_BFu7s)
//============================================================================


struct  Ip_BFu17ll_BFu8c  {
  int *v1;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu17ll_BFu8c) C1{ Fp FL:17 Fc:8}



static void Test_Ip_BFu17ll_BFu8c()
{
  {
    init_simple_test("Ip_BFu17ll_BFu8c");
    static STRUCT_IF_C Ip_BFu17ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 0, 8, 1, "Ip_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 0, 8, hide_ull(1LL<<7), "Ip_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu8c, Ip_BFu17ll_BFu8c)
//============================================================================


struct  Ip_BFu17ll_BFu8i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu17ll_BFu8i) C1{ Fp FL:17 Fi:8}



static void Test_Ip_BFu17ll_BFu8i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu8i");
    static STRUCT_IF_C Ip_BFu17ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Ip_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Ip_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu8i, Ip_BFu17ll_BFu8i)
//============================================================================


struct  Ip_BFu17ll_BFu8ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu17ll_BFu8ll) C1{ Fp FL:17 FL:8}



static void Test_Ip_BFu17ll_BFu8ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu8ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Ip_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Ip_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu8ll, Ip_BFu17ll_BFu8ll)
//============================================================================


struct  Ip_BFu17ll_BFu8s  {
  int *v1;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu17ll_BFu8s) C1{ Fp FL:17 Fs:8}



static void Test_Ip_BFu17ll_BFu8s()
{
  {
    init_simple_test("Ip_BFu17ll_BFu8s");
    static STRUCT_IF_C Ip_BFu17ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Ip_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Ip_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu8s, Ip_BFu17ll_BFu8s)
//============================================================================


struct  Ip_BFu17ll_BFu9i  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu17ll_BFu9i) C1{ Fp FL:17 Fi:9}



static void Test_Ip_BFu17ll_BFu9i()
{
  {
    init_simple_test("Ip_BFu17ll_BFu9i");
    static STRUCT_IF_C Ip_BFu17ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Ip_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Ip_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu9i, Ip_BFu17ll_BFu9i)
//============================================================================


struct  Ip_BFu17ll_BFu9ll  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu17ll_BFu9ll) C1{ Fp FL:17 FL:9}



static void Test_Ip_BFu17ll_BFu9ll()
{
  {
    init_simple_test("Ip_BFu17ll_BFu9ll");
    static STRUCT_IF_C Ip_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Ip_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Ip_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu9ll, Ip_BFu17ll_BFu9ll)
//============================================================================


struct  Ip_BFu17ll_BFu9s  {
  int *v1;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu17ll_BFu9s) C1{ Fp FL:17 Fs:9}



static void Test_Ip_BFu17ll_BFu9s()
{
  {
    init_simple_test("Ip_BFu17ll_BFu9s");
    static STRUCT_IF_C Ip_BFu17ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Ip_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Ip_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_BFu9s, Ip_BFu17ll_BFu9s)
//============================================================================


struct  Ip_BFu17ll_C  {
  int *v1;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 Ip_BFu17ll_C) C1{ Fp FL:17 Fc}



static void Test_Ip_BFu17ll_C()
{
  {
    init_simple_test("Ip_BFu17ll_C");
    static STRUCT_IF_C Ip_BFu17ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_C");
    check_field_offset(lv, v3, ABISELECT(11,7), "Ip_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_C, Ip_BFu17ll_C)
//============================================================================


struct  Ip_BFu17ll_D  {
  int *v1;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 Ip_BFu17ll_D) C1{ Fp FL:17 FL}



static void Test_Ip_BFu17ll_D()
{
  {
    init_simple_test("Ip_BFu17ll_D");
    static STRUCT_IF_C Ip_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_D, Ip_BFu17ll_D)
//============================================================================


struct  Ip_BFu17ll_F  {
  int *v1;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 Ip_BFu17ll_F) C1{ Fp FL:17 Fi}



static void Test_Ip_BFu17ll_F()
{
  {
    init_simple_test("Ip_BFu17ll_F");
    static STRUCT_IF_C Ip_BFu17ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_F, Ip_BFu17ll_F)
//============================================================================


struct  Ip_BFu17ll_I  {
  int *v1;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 Ip_BFu17ll_I) C1{ Fp FL:17 Fi}



static void Test_Ip_BFu17ll_I()
{
  {
    init_simple_test("Ip_BFu17ll_I");
    static STRUCT_IF_C Ip_BFu17ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_I, Ip_BFu17ll_I)
//============================================================================


struct  Ip_BFu17ll_Ip  {
  int *v1;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 Ip_BFu17ll_Ip) C1{ Fp FL:17 Fp}



static void Test_Ip_BFu17ll_Ip()
{
  {
    init_simple_test("Ip_BFu17ll_Ip");
    static STRUCT_IF_C Ip_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_Ip, Ip_BFu17ll_Ip)
//============================================================================


struct  Ip_BFu17ll_L  {
  int *v1;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 Ip_BFu17ll_L) C1{ Fp FL:17 FL}



static void Test_Ip_BFu17ll_L()
{
  {
    init_simple_test("Ip_BFu17ll_L");
    static STRUCT_IF_C Ip_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_L, Ip_BFu17ll_L)
//============================================================================


struct  Ip_BFu17ll_S  {
  int *v1;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 Ip_BFu17ll_S) C1{ Fp FL:17 Fs}



static void Test_Ip_BFu17ll_S()
{
  {
    init_simple_test("Ip_BFu17ll_S");
    static STRUCT_IF_C Ip_BFu17ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_S, Ip_BFu17ll_S)
//============================================================================


struct  Ip_BFu17ll_Uc  {
  int *v1;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 Ip_BFu17ll_Uc) C1{ Fp FL:17 Fc}



static void Test_Ip_BFu17ll_Uc()
{
  {
    init_simple_test("Ip_BFu17ll_Uc");
    static STRUCT_IF_C Ip_BFu17ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_Uc");
    check_field_offset(lv, v3, ABISELECT(11,7), "Ip_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_Uc, Ip_BFu17ll_Uc)
//============================================================================


struct  Ip_BFu17ll_Ui  {
  int *v1;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 Ip_BFu17ll_Ui) C1{ Fp FL:17 Fi}



static void Test_Ip_BFu17ll_Ui()
{
  {
    init_simple_test("Ip_BFu17ll_Ui");
    static STRUCT_IF_C Ip_BFu17ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_Ui, Ip_BFu17ll_Ui)
//============================================================================


struct  Ip_BFu17ll_Ul  {
  int *v1;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 Ip_BFu17ll_Ul) C1{ Fp FL:17 FL}



static void Test_Ip_BFu17ll_Ul()
{
  {
    init_simple_test("Ip_BFu17ll_Ul");
    static STRUCT_IF_C Ip_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_Ul, Ip_BFu17ll_Ul)
//============================================================================


struct  Ip_BFu17ll_Us  {
  int *v1;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 Ip_BFu17ll_Us) C1{ Fp FL:17 Fs}



static void Test_Ip_BFu17ll_Us()
{
  {
    init_simple_test("Ip_BFu17ll_Us");
    static STRUCT_IF_C Ip_BFu17ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_Us, Ip_BFu17ll_Us)
//============================================================================


struct  Ip_BFu17ll_Vp  {
  int *v1;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 Ip_BFu17ll_Vp) C1{ Fp FL:17 Fp}



static void Test_Ip_BFu17ll_Vp()
{
  {
    init_simple_test("Ip_BFu17ll_Vp");
    static STRUCT_IF_C Ip_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ip_BFu17ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ip_BFu17ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu17ll_Vp, Ip_BFu17ll_Vp)
//============================================================================


struct  Ip_BFu1c  {
  int *v1;
  unsigned char v2:1;
};
//SIG(1 Ip_BFu1c) C1{ Fp Fc:1}



static void Test_Ip_BFu1c()
{
  {
    init_simple_test("Ip_BFu1c");
    static STRUCT_IF_C Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c, Ip_BFu1c)
//============================================================================


struct  Ip_BFu1c_BFu15i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu1c_BFu15i) C1{ Fp Fc:1 Fi:15}



static void Test_Ip_BFu1c_BFu15i()
{
  {
    init_simple_test("Ip_BFu1c_BFu15i");
    static STRUCT_IF_C Ip_BFu1c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu15i, Ip_BFu1c_BFu15i)
//============================================================================


struct  Ip_BFu1c_BFu15ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu1c_BFu15ll) C1{ Fp Fc:1 FL:15}



static void Test_Ip_BFu1c_BFu15ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu15ll");
    static STRUCT_IF_C Ip_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu15ll, Ip_BFu1c_BFu15ll)
//============================================================================


struct  Ip_BFu1c_BFu15s  {
  int *v1;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu1c_BFu15s) C1{ Fp Fc:1 Fs:15}



static void Test_Ip_BFu1c_BFu15s()
{
  {
    init_simple_test("Ip_BFu1c_BFu15s");
    static STRUCT_IF_C Ip_BFu1c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu15s, Ip_BFu1c_BFu15s)
//============================================================================


struct  Ip_BFu1c_BFu16i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu1c_BFu16i) C1{ Fp Fc:1 Fi:16}



static void Test_Ip_BFu1c_BFu16i()
{
  {
    init_simple_test("Ip_BFu1c_BFu16i");
    static STRUCT_IF_C Ip_BFu1c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Ip_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Ip_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu16i, Ip_BFu1c_BFu16i)
//============================================================================


struct  Ip_BFu1c_BFu16ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu1c_BFu16ll) C1{ Fp Fc:1 FL:16}



static void Test_Ip_BFu1c_BFu16ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu16ll");
    static STRUCT_IF_C Ip_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Ip_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Ip_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu16ll, Ip_BFu1c_BFu16ll)
//============================================================================


struct  Ip_BFu1c_BFu16s  {
  int *v1;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu1c_BFu16s) C1{ Fp Fc:1 Fs:16}



static void Test_Ip_BFu1c_BFu16s()
{
  {
    init_simple_test("Ip_BFu1c_BFu16s");
    static STRUCT_IF_C Ip_BFu1c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu16s, Ip_BFu1c_BFu16s)
//============================================================================


struct  Ip_BFu1c_BFu17i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu1c_BFu17i) C1{ Fp Fc:1 Fi:17}



static void Test_Ip_BFu1c_BFu17i()
{
  {
    init_simple_test("Ip_BFu1c_BFu17i");
    static STRUCT_IF_C Ip_BFu1c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Ip_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Ip_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu17i, Ip_BFu1c_BFu17i)
//============================================================================


struct  Ip_BFu1c_BFu17ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu1c_BFu17ll) C1{ Fp Fc:1 FL:17}



static void Test_Ip_BFu1c_BFu17ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu17ll");
    static STRUCT_IF_C Ip_BFu1c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Ip_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Ip_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu17ll, Ip_BFu1c_BFu17ll)
//============================================================================


struct  Ip_BFu1c_BFu1c  {
  int *v1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu1c_BFu1c) C1{ Fp Fc:1 Fc:1}



static void Test_Ip_BFu1c_BFu1c()
{
  {
    init_simple_test("Ip_BFu1c_BFu1c");
    static STRUCT_IF_C Ip_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu1c, Ip_BFu1c_BFu1c)
//============================================================================


struct  Ip_BFu1c_BFu1i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu1c_BFu1i) C1{ Fp Fc:1 Fi:1}



static void Test_Ip_BFu1c_BFu1i()
{
  {
    init_simple_test("Ip_BFu1c_BFu1i");
    static STRUCT_IF_C Ip_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu1i, Ip_BFu1c_BFu1i)
//============================================================================


struct  Ip_BFu1c_BFu1ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu1c_BFu1ll) C1{ Fp Fc:1 FL:1}



static void Test_Ip_BFu1c_BFu1ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu1ll");
    static STRUCT_IF_C Ip_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu1ll, Ip_BFu1c_BFu1ll)
//============================================================================


struct  Ip_BFu1c_BFu1s  {
  int *v1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu1c_BFu1s) C1{ Fp Fc:1 Fs:1}



static void Test_Ip_BFu1c_BFu1s()
{
  {
    init_simple_test("Ip_BFu1c_BFu1s");
    static STRUCT_IF_C Ip_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu1s, Ip_BFu1c_BFu1s)
//============================================================================


struct  Ip_BFu1c_BFu31i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu1c_BFu31i) C1{ Fp Fc:1 Fi:31}



static void Test_Ip_BFu1c_BFu31i()
{
  {
    init_simple_test("Ip_BFu1c_BFu31i");
    static STRUCT_IF_C Ip_BFu1c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Ip_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Ip_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu31i, Ip_BFu1c_BFu31i)
//============================================================================


struct  Ip_BFu1c_BFu31ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu1c_BFu31ll) C1{ Fp Fc:1 FL:31}



static void Test_Ip_BFu1c_BFu31ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu31ll");
    static STRUCT_IF_C Ip_BFu1c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Ip_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Ip_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu31ll, Ip_BFu1c_BFu31ll)
//============================================================================


struct  Ip_BFu1c_BFu32i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu1c_BFu32i) C1{ Fp Fc:1 Fi:32}



static void Test_Ip_BFu1c_BFu32i()
{
  {
    init_simple_test("Ip_BFu1c_BFu32i");
    static STRUCT_IF_C Ip_BFu1c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu32i, Ip_BFu1c_BFu32i)
//============================================================================


struct  Ip_BFu1c_BFu32ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu1c_BFu32ll) C1{ Fp Fc:1 FL:32}



static void Test_Ip_BFu1c_BFu32ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu32ll");
    static STRUCT_IF_C Ip_BFu1c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 32, 1, "Ip_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu32ll, Ip_BFu1c_BFu32ll)
//============================================================================


struct  Ip_BFu1c_BFu33  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu1c_BFu33) C1{ Fp Fc:1 FL:33}



static void Test_Ip_BFu1c_BFu33()
{
  {
    init_simple_test("Ip_BFu1c_BFu33");
    static STRUCT_IF_C Ip_BFu1c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 33, 1, "Ip_BFu1c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu33, Ip_BFu1c_BFu33)
//============================================================================


struct  Ip_BFu1c_BFu7c  {
  int *v1;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu1c_BFu7c) C1{ Fp Fc:1 Fc:7}



static void Test_Ip_BFu1c_BFu7c()
{
  {
    init_simple_test("Ip_BFu1c_BFu7c");
    static STRUCT_IF_C Ip_BFu1c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu7c, Ip_BFu1c_BFu7c)
//============================================================================


struct  Ip_BFu1c_BFu7i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu1c_BFu7i) C1{ Fp Fc:1 Fi:7}



static void Test_Ip_BFu1c_BFu7i()
{
  {
    init_simple_test("Ip_BFu1c_BFu7i");
    static STRUCT_IF_C Ip_BFu1c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu7i, Ip_BFu1c_BFu7i)
//============================================================================


struct  Ip_BFu1c_BFu7ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu1c_BFu7ll) C1{ Fp Fc:1 FL:7}



static void Test_Ip_BFu1c_BFu7ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu7ll");
    static STRUCT_IF_C Ip_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu7ll, Ip_BFu1c_BFu7ll)
//============================================================================


struct  Ip_BFu1c_BFu7s  {
  int *v1;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu1c_BFu7s) C1{ Fp Fc:1 Fs:7}



static void Test_Ip_BFu1c_BFu7s()
{
  {
    init_simple_test("Ip_BFu1c_BFu7s");
    static STRUCT_IF_C Ip_BFu1c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu7s, Ip_BFu1c_BFu7s)
//============================================================================


struct  Ip_BFu1c_BFu8c  {
  int *v1;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu1c_BFu8c) C1{ Fp Fc:1 Fc:8}



static void Test_Ip_BFu1c_BFu8c()
{
  {
    init_simple_test("Ip_BFu1c_BFu8c");
    static STRUCT_IF_C Ip_BFu1c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu8c, Ip_BFu1c_BFu8c)
//============================================================================


struct  Ip_BFu1c_BFu8i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu1c_BFu8i) C1{ Fp Fc:1 Fi:8}



static void Test_Ip_BFu1c_BFu8i()
{
  {
    init_simple_test("Ip_BFu1c_BFu8i");
    static STRUCT_IF_C Ip_BFu1c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu8i, Ip_BFu1c_BFu8i)
//============================================================================


struct  Ip_BFu1c_BFu8ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu1c_BFu8ll) C1{ Fp Fc:1 FL:8}



static void Test_Ip_BFu1c_BFu8ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu8ll");
    static STRUCT_IF_C Ip_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu8ll, Ip_BFu1c_BFu8ll)
//============================================================================


struct  Ip_BFu1c_BFu8s  {
  int *v1;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu1c_BFu8s) C1{ Fp Fc:1 Fs:8}



static void Test_Ip_BFu1c_BFu8s()
{
  {
    init_simple_test("Ip_BFu1c_BFu8s");
    static STRUCT_IF_C Ip_BFu1c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu8s, Ip_BFu1c_BFu8s)
//============================================================================


struct  Ip_BFu1c_BFu9i  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu1c_BFu9i) C1{ Fp Fc:1 Fi:9}



static void Test_Ip_BFu1c_BFu9i()
{
  {
    init_simple_test("Ip_BFu1c_BFu9i");
    static STRUCT_IF_C Ip_BFu1c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu9i, Ip_BFu1c_BFu9i)
//============================================================================


struct  Ip_BFu1c_BFu9ll  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu1c_BFu9ll) C1{ Fp Fc:1 FL:9}



static void Test_Ip_BFu1c_BFu9ll()
{
  {
    init_simple_test("Ip_BFu1c_BFu9ll");
    static STRUCT_IF_C Ip_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu9ll, Ip_BFu1c_BFu9ll)
//============================================================================


struct  Ip_BFu1c_BFu9s  {
  int *v1;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu1c_BFu9s) C1{ Fp Fc:1 Fs:9}



static void Test_Ip_BFu1c_BFu9s()
{
  {
    init_simple_test("Ip_BFu1c_BFu9s");
    static STRUCT_IF_C Ip_BFu1c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_BFu9s, Ip_BFu1c_BFu9s)
//============================================================================


struct  Ip_BFu1c_C  {
  int *v1;
  unsigned char v2:1;
  char v3;
};
//SIG(1 Ip_BFu1c_C) C1{ Fp Fc:1 Fc}



static void Test_Ip_BFu1c_C()
{
  {
    init_simple_test("Ip_BFu1c_C");
    static STRUCT_IF_C Ip_BFu1c_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_C, Ip_BFu1c_C)
//============================================================================


struct  Ip_BFu1c_D  {
  int *v1;
  unsigned char v2:1;
  double v3;
};
//SIG(1 Ip_BFu1c_D) C1{ Fp Fc:1 FL}



static void Test_Ip_BFu1c_D()
{
  {
    init_simple_test("Ip_BFu1c_D");
    static STRUCT_IF_C Ip_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_D, Ip_BFu1c_D)
//============================================================================


struct  Ip_BFu1c_F  {
  int *v1;
  unsigned char v2:1;
  float v3;
};
//SIG(1 Ip_BFu1c_F) C1{ Fp Fc:1 Fi}



static void Test_Ip_BFu1c_F()
{
  {
    init_simple_test("Ip_BFu1c_F");
    static STRUCT_IF_C Ip_BFu1c_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_F, Ip_BFu1c_F)
//============================================================================


struct  Ip_BFu1c_I  {
  int *v1;
  unsigned char v2:1;
  int v3;
};
//SIG(1 Ip_BFu1c_I) C1{ Fp Fc:1 Fi}



static void Test_Ip_BFu1c_I()
{
  {
    init_simple_test("Ip_BFu1c_I");
    static STRUCT_IF_C Ip_BFu1c_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_I, Ip_BFu1c_I)
//============================================================================


struct  Ip_BFu1c_Ip  {
  int *v1;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 Ip_BFu1c_Ip) C1{ Fp Fc:1 Fp}



static void Test_Ip_BFu1c_Ip()
{
  {
    init_simple_test("Ip_BFu1c_Ip");
    static STRUCT_IF_C Ip_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_Ip, Ip_BFu1c_Ip)
//============================================================================


struct  Ip_BFu1c_L  {
  int *v1;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 Ip_BFu1c_L) C1{ Fp Fc:1 FL}



static void Test_Ip_BFu1c_L()
{
  {
    init_simple_test("Ip_BFu1c_L");
    static STRUCT_IF_C Ip_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_L, Ip_BFu1c_L)
//============================================================================


struct  Ip_BFu1c_S  {
  int *v1;
  unsigned char v2:1;
  short v3;
};
//SIG(1 Ip_BFu1c_S) C1{ Fp Fc:1 Fs}



static void Test_Ip_BFu1c_S()
{
  {
    init_simple_test("Ip_BFu1c_S");
    static STRUCT_IF_C Ip_BFu1c_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_S, Ip_BFu1c_S)
//============================================================================


struct  Ip_BFu1c_Uc  {
  int *v1;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 Ip_BFu1c_Uc) C1{ Fp Fc:1 Fc}



static void Test_Ip_BFu1c_Uc()
{
  {
    init_simple_test("Ip_BFu1c_Uc");
    static STRUCT_IF_C Ip_BFu1c_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_Uc, Ip_BFu1c_Uc)
//============================================================================


struct  Ip_BFu1c_Ui  {
  int *v1;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 Ip_BFu1c_Ui) C1{ Fp Fc:1 Fi}



static void Test_Ip_BFu1c_Ui()
{
  {
    init_simple_test("Ip_BFu1c_Ui");
    static STRUCT_IF_C Ip_BFu1c_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_Ui, Ip_BFu1c_Ui)
//============================================================================


struct  Ip_BFu1c_Ul  {
  int *v1;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 Ip_BFu1c_Ul) C1{ Fp Fc:1 FL}



static void Test_Ip_BFu1c_Ul()
{
  {
    init_simple_test("Ip_BFu1c_Ul");
    static STRUCT_IF_C Ip_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_Ul, Ip_BFu1c_Ul)
//============================================================================


struct  Ip_BFu1c_Us  {
  int *v1;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 Ip_BFu1c_Us) C1{ Fp Fc:1 Fs}



static void Test_Ip_BFu1c_Us()
{
  {
    init_simple_test("Ip_BFu1c_Us");
    static STRUCT_IF_C Ip_BFu1c_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_Us, Ip_BFu1c_Us)
//============================================================================


struct  Ip_BFu1c_Vp  {
  int *v1;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 Ip_BFu1c_Vp) C1{ Fp Fc:1 Fp}



static void Test_Ip_BFu1c_Vp()
{
  {
    init_simple_test("Ip_BFu1c_Vp");
    static STRUCT_IF_C Ip_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1c_Vp, Ip_BFu1c_Vp)
//============================================================================


struct  Ip_BFu1i  {
  int *v1;
  unsigned int v2:1;
};
//SIG(1 Ip_BFu1i) C1{ Fp Fi:1}



static void Test_Ip_BFu1i()
{
  {
    init_simple_test("Ip_BFu1i");
    static STRUCT_IF_C Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i, Ip_BFu1i)
//============================================================================


struct  Ip_BFu1i_BFu15i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu1i_BFu15i) C1{ Fp Fi:1 Fi:15}



static void Test_Ip_BFu1i_BFu15i()
{
  {
    init_simple_test("Ip_BFu1i_BFu15i");
    static STRUCT_IF_C Ip_BFu1i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu15i, Ip_BFu1i_BFu15i)
//============================================================================


struct  Ip_BFu1i_BFu15ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu1i_BFu15ll) C1{ Fp Fi:1 FL:15}



static void Test_Ip_BFu1i_BFu15ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu15ll");
    static STRUCT_IF_C Ip_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu15ll, Ip_BFu1i_BFu15ll)
//============================================================================


struct  Ip_BFu1i_BFu15s  {
  int *v1;
  unsigned int v2:1;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu1i_BFu15s) C1{ Fp Fi:1 Fs:15}



static void Test_Ip_BFu1i_BFu15s()
{
  {
    init_simple_test("Ip_BFu1i_BFu15s");
    static STRUCT_IF_C Ip_BFu1i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu15s, Ip_BFu1i_BFu15s)
//============================================================================


struct  Ip_BFu1i_BFu16i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu1i_BFu16i) C1{ Fp Fi:1 Fi:16}



static void Test_Ip_BFu1i_BFu16i()
{
  {
    init_simple_test("Ip_BFu1i_BFu16i");
    static STRUCT_IF_C Ip_BFu1i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Ip_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Ip_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu16i, Ip_BFu1i_BFu16i)
//============================================================================


struct  Ip_BFu1i_BFu16ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu1i_BFu16ll) C1{ Fp Fi:1 FL:16}



static void Test_Ip_BFu1i_BFu16ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu16ll");
    static STRUCT_IF_C Ip_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Ip_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Ip_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu16ll, Ip_BFu1i_BFu16ll)
//============================================================================


struct  Ip_BFu1i_BFu16s  {
  int *v1;
  unsigned int v2:1;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu1i_BFu16s) C1{ Fp Fi:1 Fs:16}



static void Test_Ip_BFu1i_BFu16s()
{
  {
    init_simple_test("Ip_BFu1i_BFu16s");
    static STRUCT_IF_C Ip_BFu1i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu16s, Ip_BFu1i_BFu16s)
//============================================================================


struct  Ip_BFu1i_BFu17i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu1i_BFu17i) C1{ Fp Fi:1 Fi:17}



static void Test_Ip_BFu1i_BFu17i()
{
  {
    init_simple_test("Ip_BFu1i_BFu17i");
    static STRUCT_IF_C Ip_BFu1i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Ip_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Ip_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu17i, Ip_BFu1i_BFu17i)
//============================================================================


struct  Ip_BFu1i_BFu17ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu1i_BFu17ll) C1{ Fp Fi:1 FL:17}



static void Test_Ip_BFu1i_BFu17ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu17ll");
    static STRUCT_IF_C Ip_BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Ip_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Ip_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu17ll, Ip_BFu1i_BFu17ll)
//============================================================================


struct  Ip_BFu1i_BFu1c  {
  int *v1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu1i_BFu1c) C1{ Fp Fi:1 Fc:1}



static void Test_Ip_BFu1i_BFu1c()
{
  {
    init_simple_test("Ip_BFu1i_BFu1c");
    static STRUCT_IF_C Ip_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu1c, Ip_BFu1i_BFu1c)
//============================================================================


struct  Ip_BFu1i_BFu1i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu1i_BFu1i) C1{ Fp Fi:1 Fi:1}



static void Test_Ip_BFu1i_BFu1i()
{
  {
    init_simple_test("Ip_BFu1i_BFu1i");
    static STRUCT_IF_C Ip_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu1i, Ip_BFu1i_BFu1i)
//============================================================================


struct  Ip_BFu1i_BFu1ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu1i_BFu1ll) C1{ Fp Fi:1 FL:1}



static void Test_Ip_BFu1i_BFu1ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu1ll");
    static STRUCT_IF_C Ip_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu1ll, Ip_BFu1i_BFu1ll)
//============================================================================


struct  Ip_BFu1i_BFu1s  {
  int *v1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu1i_BFu1s) C1{ Fp Fi:1 Fs:1}



static void Test_Ip_BFu1i_BFu1s()
{
  {
    init_simple_test("Ip_BFu1i_BFu1s");
    static STRUCT_IF_C Ip_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu1s, Ip_BFu1i_BFu1s)
//============================================================================


struct  Ip_BFu1i_BFu31i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu1i_BFu31i) C1{ Fp Fi:1 Fi:31}



static void Test_Ip_BFu1i_BFu31i()
{
  {
    init_simple_test("Ip_BFu1i_BFu31i");
    static STRUCT_IF_C Ip_BFu1i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Ip_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Ip_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu31i, Ip_BFu1i_BFu31i)
//============================================================================


struct  Ip_BFu1i_BFu31ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu1i_BFu31ll) C1{ Fp Fi:1 FL:31}



static void Test_Ip_BFu1i_BFu31ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu31ll");
    static STRUCT_IF_C Ip_BFu1i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Ip_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Ip_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu31ll, Ip_BFu1i_BFu31ll)
//============================================================================


struct  Ip_BFu1i_BFu32i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu1i_BFu32i) C1{ Fp Fi:1 Fi:32}



static void Test_Ip_BFu1i_BFu32i()
{
  {
    init_simple_test("Ip_BFu1i_BFu32i");
    static STRUCT_IF_C Ip_BFu1i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu32i, Ip_BFu1i_BFu32i)
//============================================================================


struct  Ip_BFu1i_BFu32ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu1i_BFu32ll) C1{ Fp Fi:1 FL:32}



static void Test_Ip_BFu1i_BFu32ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu32ll");
    static STRUCT_IF_C Ip_BFu1i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 32, 1, "Ip_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu32ll, Ip_BFu1i_BFu32ll)
//============================================================================


struct  Ip_BFu1i_BFu33  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu1i_BFu33) C1{ Fp Fi:1 FL:33}



static void Test_Ip_BFu1i_BFu33()
{
  {
    init_simple_test("Ip_BFu1i_BFu33");
    static STRUCT_IF_C Ip_BFu1i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 33, 1, "Ip_BFu1i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu33, Ip_BFu1i_BFu33)
//============================================================================


struct  Ip_BFu1i_BFu7c  {
  int *v1;
  unsigned int v2:1;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu1i_BFu7c) C1{ Fp Fi:1 Fc:7}



static void Test_Ip_BFu1i_BFu7c()
{
  {
    init_simple_test("Ip_BFu1i_BFu7c");
    static STRUCT_IF_C Ip_BFu1i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu7c, Ip_BFu1i_BFu7c)
//============================================================================


struct  Ip_BFu1i_BFu7i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu1i_BFu7i) C1{ Fp Fi:1 Fi:7}



static void Test_Ip_BFu1i_BFu7i()
{
  {
    init_simple_test("Ip_BFu1i_BFu7i");
    static STRUCT_IF_C Ip_BFu1i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu7i, Ip_BFu1i_BFu7i)
//============================================================================


struct  Ip_BFu1i_BFu7ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu1i_BFu7ll) C1{ Fp Fi:1 FL:7}



static void Test_Ip_BFu1i_BFu7ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu7ll");
    static STRUCT_IF_C Ip_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu7ll, Ip_BFu1i_BFu7ll)
//============================================================================


struct  Ip_BFu1i_BFu7s  {
  int *v1;
  unsigned int v2:1;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu1i_BFu7s) C1{ Fp Fi:1 Fs:7}



static void Test_Ip_BFu1i_BFu7s()
{
  {
    init_simple_test("Ip_BFu1i_BFu7s");
    static STRUCT_IF_C Ip_BFu1i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu7s, Ip_BFu1i_BFu7s)
//============================================================================


struct  Ip_BFu1i_BFu8c  {
  int *v1;
  unsigned int v2:1;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu1i_BFu8c) C1{ Fp Fi:1 Fc:8}



static void Test_Ip_BFu1i_BFu8c()
{
  {
    init_simple_test("Ip_BFu1i_BFu8c");
    static STRUCT_IF_C Ip_BFu1i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu8c, Ip_BFu1i_BFu8c)
//============================================================================


struct  Ip_BFu1i_BFu8i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu1i_BFu8i) C1{ Fp Fi:1 Fi:8}



static void Test_Ip_BFu1i_BFu8i()
{
  {
    init_simple_test("Ip_BFu1i_BFu8i");
    static STRUCT_IF_C Ip_BFu1i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu8i, Ip_BFu1i_BFu8i)
//============================================================================


struct  Ip_BFu1i_BFu8ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu1i_BFu8ll) C1{ Fp Fi:1 FL:8}



static void Test_Ip_BFu1i_BFu8ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu8ll");
    static STRUCT_IF_C Ip_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu8ll, Ip_BFu1i_BFu8ll)
//============================================================================


struct  Ip_BFu1i_BFu8s  {
  int *v1;
  unsigned int v2:1;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu1i_BFu8s) C1{ Fp Fi:1 Fs:8}



static void Test_Ip_BFu1i_BFu8s()
{
  {
    init_simple_test("Ip_BFu1i_BFu8s");
    static STRUCT_IF_C Ip_BFu1i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu8s, Ip_BFu1i_BFu8s)
//============================================================================


struct  Ip_BFu1i_BFu9i  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu1i_BFu9i) C1{ Fp Fi:1 Fi:9}



static void Test_Ip_BFu1i_BFu9i()
{
  {
    init_simple_test("Ip_BFu1i_BFu9i");
    static STRUCT_IF_C Ip_BFu1i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu9i, Ip_BFu1i_BFu9i)
//============================================================================


struct  Ip_BFu1i_BFu9ll  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu1i_BFu9ll) C1{ Fp Fi:1 FL:9}



static void Test_Ip_BFu1i_BFu9ll()
{
  {
    init_simple_test("Ip_BFu1i_BFu9ll");
    static STRUCT_IF_C Ip_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu9ll, Ip_BFu1i_BFu9ll)
//============================================================================


struct  Ip_BFu1i_BFu9s  {
  int *v1;
  unsigned int v2:1;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu1i_BFu9s) C1{ Fp Fi:1 Fs:9}



static void Test_Ip_BFu1i_BFu9s()
{
  {
    init_simple_test("Ip_BFu1i_BFu9s");
    static STRUCT_IF_C Ip_BFu1i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_BFu9s, Ip_BFu1i_BFu9s)
//============================================================================


struct  Ip_BFu1i_C  {
  int *v1;
  unsigned int v2:1;
  char v3;
};
//SIG(1 Ip_BFu1i_C) C1{ Fp Fi:1 Fc}



static void Test_Ip_BFu1i_C()
{
  {
    init_simple_test("Ip_BFu1i_C");
    static STRUCT_IF_C Ip_BFu1i_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_C, Ip_BFu1i_C)
//============================================================================


struct  Ip_BFu1i_D  {
  int *v1;
  unsigned int v2:1;
  double v3;
};
//SIG(1 Ip_BFu1i_D) C1{ Fp Fi:1 FL}



static void Test_Ip_BFu1i_D()
{
  {
    init_simple_test("Ip_BFu1i_D");
    static STRUCT_IF_C Ip_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_D, Ip_BFu1i_D)
//============================================================================


struct  Ip_BFu1i_F  {
  int *v1;
  unsigned int v2:1;
  float v3;
};
//SIG(1 Ip_BFu1i_F) C1{ Fp Fi:1 Fi}



static void Test_Ip_BFu1i_F()
{
  {
    init_simple_test("Ip_BFu1i_F");
    static STRUCT_IF_C Ip_BFu1i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_F, Ip_BFu1i_F)
//============================================================================


struct  Ip_BFu1i_I  {
  int *v1;
  unsigned int v2:1;
  int v3;
};
//SIG(1 Ip_BFu1i_I) C1{ Fp Fi:1 Fi}



static void Test_Ip_BFu1i_I()
{
  {
    init_simple_test("Ip_BFu1i_I");
    static STRUCT_IF_C Ip_BFu1i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_I, Ip_BFu1i_I)
//============================================================================


struct  Ip_BFu1i_Ip  {
  int *v1;
  unsigned int v2:1;
  int *v3;
};
//SIG(1 Ip_BFu1i_Ip) C1{ Fp Fi:1 Fp}



static void Test_Ip_BFu1i_Ip()
{
  {
    init_simple_test("Ip_BFu1i_Ip");
    static STRUCT_IF_C Ip_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_Ip, Ip_BFu1i_Ip)
//============================================================================


struct  Ip_BFu1i_L  {
  int *v1;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 Ip_BFu1i_L) C1{ Fp Fi:1 FL}



static void Test_Ip_BFu1i_L()
{
  {
    init_simple_test("Ip_BFu1i_L");
    static STRUCT_IF_C Ip_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_L, Ip_BFu1i_L)
//============================================================================


struct  Ip_BFu1i_S  {
  int *v1;
  unsigned int v2:1;
  short v3;
};
//SIG(1 Ip_BFu1i_S) C1{ Fp Fi:1 Fs}



static void Test_Ip_BFu1i_S()
{
  {
    init_simple_test("Ip_BFu1i_S");
    static STRUCT_IF_C Ip_BFu1i_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_S, Ip_BFu1i_S)
//============================================================================


struct  Ip_BFu1i_Uc  {
  int *v1;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 Ip_BFu1i_Uc) C1{ Fp Fi:1 Fc}



static void Test_Ip_BFu1i_Uc()
{
  {
    init_simple_test("Ip_BFu1i_Uc");
    static STRUCT_IF_C Ip_BFu1i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_Uc, Ip_BFu1i_Uc)
//============================================================================


struct  Ip_BFu1i_Ui  {
  int *v1;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 Ip_BFu1i_Ui) C1{ Fp Fi:1 Fi}



static void Test_Ip_BFu1i_Ui()
{
  {
    init_simple_test("Ip_BFu1i_Ui");
    static STRUCT_IF_C Ip_BFu1i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_Ui, Ip_BFu1i_Ui)
//============================================================================


struct  Ip_BFu1i_Ul  {
  int *v1;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 Ip_BFu1i_Ul) C1{ Fp Fi:1 FL}



static void Test_Ip_BFu1i_Ul()
{
  {
    init_simple_test("Ip_BFu1i_Ul");
    static STRUCT_IF_C Ip_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_Ul, Ip_BFu1i_Ul)
//============================================================================


struct  Ip_BFu1i_Us  {
  int *v1;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 Ip_BFu1i_Us) C1{ Fp Fi:1 Fs}



static void Test_Ip_BFu1i_Us()
{
  {
    init_simple_test("Ip_BFu1i_Us");
    static STRUCT_IF_C Ip_BFu1i_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_Us, Ip_BFu1i_Us)
//============================================================================


struct  Ip_BFu1i_Vp  {
  int *v1;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 Ip_BFu1i_Vp) C1{ Fp Fi:1 Fp}



static void Test_Ip_BFu1i_Vp()
{
  {
    init_simple_test("Ip_BFu1i_Vp");
    static STRUCT_IF_C Ip_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1i_Vp, Ip_BFu1i_Vp)
//============================================================================


struct  Ip_BFu1ll  {
  int *v1;
  __tsu64 v2:1;
};
//SIG(1 Ip_BFu1ll) C1{ Fp FL:1}



static void Test_Ip_BFu1ll()
{
  {
    init_simple_test("Ip_BFu1ll");
    static STRUCT_IF_C Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll, Ip_BFu1ll)
//============================================================================


struct  Ip_BFu1ll_BFu15i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu1ll_BFu15i) C1{ Fp FL:1 Fi:15}



static void Test_Ip_BFu1ll_BFu15i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu15i");
    static STRUCT_IF_C Ip_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu15i, Ip_BFu1ll_BFu15i)
//============================================================================


struct  Ip_BFu1ll_BFu15ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu1ll_BFu15ll) C1{ Fp FL:1 FL:15}



static void Test_Ip_BFu1ll_BFu15ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu15ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu15ll, Ip_BFu1ll_BFu15ll)
//============================================================================


struct  Ip_BFu1ll_BFu15s  {
  int *v1;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu1ll_BFu15s) C1{ Fp FL:1 Fs:15}



static void Test_Ip_BFu1ll_BFu15s()
{
  {
    init_simple_test("Ip_BFu1ll_BFu15s");
    static STRUCT_IF_C Ip_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu15s, Ip_BFu1ll_BFu15s)
//============================================================================


struct  Ip_BFu1ll_BFu16i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu1ll_BFu16i) C1{ Fp FL:1 Fi:16}



static void Test_Ip_BFu1ll_BFu16i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu16i");
    static STRUCT_IF_C Ip_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Ip_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Ip_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu16i, Ip_BFu1ll_BFu16i)
//============================================================================


struct  Ip_BFu1ll_BFu16ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu1ll_BFu16ll) C1{ Fp FL:1 FL:16}



static void Test_Ip_BFu1ll_BFu16ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu16ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Ip_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Ip_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu16ll, Ip_BFu1ll_BFu16ll)
//============================================================================


struct  Ip_BFu1ll_BFu16s  {
  int *v1;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu1ll_BFu16s) C1{ Fp FL:1 Fs:16}



static void Test_Ip_BFu1ll_BFu16s()
{
  {
    init_simple_test("Ip_BFu1ll_BFu16s");
    static STRUCT_IF_C Ip_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu16s, Ip_BFu1ll_BFu16s)
//============================================================================


struct  Ip_BFu1ll_BFu17i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu1ll_BFu17i) C1{ Fp FL:1 Fi:17}



static void Test_Ip_BFu1ll_BFu17i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu17i");
    static STRUCT_IF_C Ip_BFu1ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Ip_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Ip_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu17i, Ip_BFu1ll_BFu17i)
//============================================================================


struct  Ip_BFu1ll_BFu17ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu1ll_BFu17ll) C1{ Fp FL:1 FL:17}



static void Test_Ip_BFu1ll_BFu17ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu17ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Ip_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Ip_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu17ll, Ip_BFu1ll_BFu17ll)
//============================================================================


struct  Ip_BFu1ll_BFu1c  {
  int *v1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu1ll_BFu1c) C1{ Fp FL:1 Fc:1}



static void Test_Ip_BFu1ll_BFu1c()
{
  {
    init_simple_test("Ip_BFu1ll_BFu1c");
    static STRUCT_IF_C Ip_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu1c, Ip_BFu1ll_BFu1c)
//============================================================================


struct  Ip_BFu1ll_BFu1i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu1ll_BFu1i) C1{ Fp FL:1 Fi:1}



static void Test_Ip_BFu1ll_BFu1i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu1i");
    static STRUCT_IF_C Ip_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu1i, Ip_BFu1ll_BFu1i)
//============================================================================


struct  Ip_BFu1ll_BFu1ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu1ll_BFu1ll) C1{ Fp FL:1 FL:1}



static void Test_Ip_BFu1ll_BFu1ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu1ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu1ll, Ip_BFu1ll_BFu1ll)
//============================================================================


struct  Ip_BFu1ll_BFu1s  {
  int *v1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu1ll_BFu1s) C1{ Fp FL:1 Fs:1}



static void Test_Ip_BFu1ll_BFu1s()
{
  {
    init_simple_test("Ip_BFu1ll_BFu1s");
    static STRUCT_IF_C Ip_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu1s, Ip_BFu1ll_BFu1s)
//============================================================================


struct  Ip_BFu1ll_BFu31i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu1ll_BFu31i) C1{ Fp FL:1 Fi:31}



static void Test_Ip_BFu1ll_BFu31i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu31i");
    static STRUCT_IF_C Ip_BFu1ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Ip_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Ip_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu31i, Ip_BFu1ll_BFu31i)
//============================================================================


struct  Ip_BFu1ll_BFu31ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu1ll_BFu31ll) C1{ Fp FL:1 FL:31}



static void Test_Ip_BFu1ll_BFu31ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu31ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Ip_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Ip_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu31ll, Ip_BFu1ll_BFu31ll)
//============================================================================


struct  Ip_BFu1ll_BFu32i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu1ll_BFu32i) C1{ Fp FL:1 Fi:32}



static void Test_Ip_BFu1ll_BFu32i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu32i");
    static STRUCT_IF_C Ip_BFu1ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu32i, Ip_BFu1ll_BFu32i)
//============================================================================


struct  Ip_BFu1ll_BFu32ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu1ll_BFu32ll) C1{ Fp FL:1 FL:32}



static void Test_Ip_BFu1ll_BFu32ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu32ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 32, 1, "Ip_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu32ll, Ip_BFu1ll_BFu32ll)
//============================================================================


struct  Ip_BFu1ll_BFu33  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu1ll_BFu33) C1{ Fp FL:1 FL:33}



static void Test_Ip_BFu1ll_BFu33()
{
  {
    init_simple_test("Ip_BFu1ll_BFu33");
    static STRUCT_IF_C Ip_BFu1ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 33, 1, "Ip_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu33, Ip_BFu1ll_BFu33)
//============================================================================


struct  Ip_BFu1ll_BFu7c  {
  int *v1;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu1ll_BFu7c) C1{ Fp FL:1 Fc:7}



static void Test_Ip_BFu1ll_BFu7c()
{
  {
    init_simple_test("Ip_BFu1ll_BFu7c");
    static STRUCT_IF_C Ip_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu7c, Ip_BFu1ll_BFu7c)
//============================================================================


struct  Ip_BFu1ll_BFu7i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu1ll_BFu7i) C1{ Fp FL:1 Fi:7}



static void Test_Ip_BFu1ll_BFu7i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu7i");
    static STRUCT_IF_C Ip_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu7i, Ip_BFu1ll_BFu7i)
//============================================================================


struct  Ip_BFu1ll_BFu7ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu1ll_BFu7ll) C1{ Fp FL:1 FL:7}



static void Test_Ip_BFu1ll_BFu7ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu7ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu7ll, Ip_BFu1ll_BFu7ll)
//============================================================================


struct  Ip_BFu1ll_BFu7s  {
  int *v1;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu1ll_BFu7s) C1{ Fp FL:1 Fs:7}



static void Test_Ip_BFu1ll_BFu7s()
{
  {
    init_simple_test("Ip_BFu1ll_BFu7s");
    static STRUCT_IF_C Ip_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu7s, Ip_BFu1ll_BFu7s)
//============================================================================


struct  Ip_BFu1ll_BFu8c  {
  int *v1;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu1ll_BFu8c) C1{ Fp FL:1 Fc:8}



static void Test_Ip_BFu1ll_BFu8c()
{
  {
    init_simple_test("Ip_BFu1ll_BFu8c");
    static STRUCT_IF_C Ip_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu8c, Ip_BFu1ll_BFu8c)
//============================================================================


struct  Ip_BFu1ll_BFu8i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu1ll_BFu8i) C1{ Fp FL:1 Fi:8}



static void Test_Ip_BFu1ll_BFu8i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu8i");
    static STRUCT_IF_C Ip_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu8i, Ip_BFu1ll_BFu8i)
//============================================================================


struct  Ip_BFu1ll_BFu8ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu1ll_BFu8ll) C1{ Fp FL:1 FL:8}



static void Test_Ip_BFu1ll_BFu8ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu8ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu8ll, Ip_BFu1ll_BFu8ll)
//============================================================================


struct  Ip_BFu1ll_BFu8s  {
  int *v1;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu1ll_BFu8s) C1{ Fp FL:1 Fs:8}



static void Test_Ip_BFu1ll_BFu8s()
{
  {
    init_simple_test("Ip_BFu1ll_BFu8s");
    static STRUCT_IF_C Ip_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu8s, Ip_BFu1ll_BFu8s)
//============================================================================


struct  Ip_BFu1ll_BFu9i  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu1ll_BFu9i) C1{ Fp FL:1 Fi:9}



static void Test_Ip_BFu1ll_BFu9i()
{
  {
    init_simple_test("Ip_BFu1ll_BFu9i");
    static STRUCT_IF_C Ip_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu9i, Ip_BFu1ll_BFu9i)
//============================================================================


struct  Ip_BFu1ll_BFu9ll  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu1ll_BFu9ll) C1{ Fp FL:1 FL:9}



static void Test_Ip_BFu1ll_BFu9ll()
{
  {
    init_simple_test("Ip_BFu1ll_BFu9ll");
    static STRUCT_IF_C Ip_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu9ll, Ip_BFu1ll_BFu9ll)
//============================================================================


struct  Ip_BFu1ll_BFu9s  {
  int *v1;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu1ll_BFu9s) C1{ Fp FL:1 Fs:9}



static void Test_Ip_BFu1ll_BFu9s()
{
  {
    init_simple_test("Ip_BFu1ll_BFu9s");
    static STRUCT_IF_C Ip_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_BFu9s, Ip_BFu1ll_BFu9s)
//============================================================================


struct  Ip_BFu1ll_C  {
  int *v1;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 Ip_BFu1ll_C) C1{ Fp FL:1 Fc}



static void Test_Ip_BFu1ll_C()
{
  {
    init_simple_test("Ip_BFu1ll_C");
    static STRUCT_IF_C Ip_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_C, Ip_BFu1ll_C)
//============================================================================


struct  Ip_BFu1ll_D  {
  int *v1;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 Ip_BFu1ll_D) C1{ Fp FL:1 FL}



static void Test_Ip_BFu1ll_D()
{
  {
    init_simple_test("Ip_BFu1ll_D");
    static STRUCT_IF_C Ip_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_D, Ip_BFu1ll_D)
//============================================================================


struct  Ip_BFu1ll_F  {
  int *v1;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 Ip_BFu1ll_F) C1{ Fp FL:1 Fi}



static void Test_Ip_BFu1ll_F()
{
  {
    init_simple_test("Ip_BFu1ll_F");
    static STRUCT_IF_C Ip_BFu1ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_F, Ip_BFu1ll_F)
//============================================================================


struct  Ip_BFu1ll_I  {
  int *v1;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 Ip_BFu1ll_I) C1{ Fp FL:1 Fi}



static void Test_Ip_BFu1ll_I()
{
  {
    init_simple_test("Ip_BFu1ll_I");
    static STRUCT_IF_C Ip_BFu1ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_I, Ip_BFu1ll_I)
//============================================================================


struct  Ip_BFu1ll_Ip  {
  int *v1;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 Ip_BFu1ll_Ip) C1{ Fp FL:1 Fp}



static void Test_Ip_BFu1ll_Ip()
{
  {
    init_simple_test("Ip_BFu1ll_Ip");
    static STRUCT_IF_C Ip_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_Ip, Ip_BFu1ll_Ip)
//============================================================================


struct  Ip_BFu1ll_L  {
  int *v1;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 Ip_BFu1ll_L) C1{ Fp FL:1 FL}



static void Test_Ip_BFu1ll_L()
{
  {
    init_simple_test("Ip_BFu1ll_L");
    static STRUCT_IF_C Ip_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_L, Ip_BFu1ll_L)
//============================================================================


struct  Ip_BFu1ll_S  {
  int *v1;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 Ip_BFu1ll_S) C1{ Fp FL:1 Fs}



static void Test_Ip_BFu1ll_S()
{
  {
    init_simple_test("Ip_BFu1ll_S");
    static STRUCT_IF_C Ip_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_S, Ip_BFu1ll_S)
//============================================================================


struct  Ip_BFu1ll_Uc  {
  int *v1;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 Ip_BFu1ll_Uc) C1{ Fp FL:1 Fc}



static void Test_Ip_BFu1ll_Uc()
{
  {
    init_simple_test("Ip_BFu1ll_Uc");
    static STRUCT_IF_C Ip_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_Uc, Ip_BFu1ll_Uc)
//============================================================================


struct  Ip_BFu1ll_Ui  {
  int *v1;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 Ip_BFu1ll_Ui) C1{ Fp FL:1 Fi}



static void Test_Ip_BFu1ll_Ui()
{
  {
    init_simple_test("Ip_BFu1ll_Ui");
    static STRUCT_IF_C Ip_BFu1ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_Ui, Ip_BFu1ll_Ui)
//============================================================================


struct  Ip_BFu1ll_Ul  {
  int *v1;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 Ip_BFu1ll_Ul) C1{ Fp FL:1 FL}



static void Test_Ip_BFu1ll_Ul()
{
  {
    init_simple_test("Ip_BFu1ll_Ul");
    static STRUCT_IF_C Ip_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_Ul, Ip_BFu1ll_Ul)
//============================================================================


struct  Ip_BFu1ll_Us  {
  int *v1;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 Ip_BFu1ll_Us) C1{ Fp FL:1 Fs}



static void Test_Ip_BFu1ll_Us()
{
  {
    init_simple_test("Ip_BFu1ll_Us");
    static STRUCT_IF_C Ip_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_Us, Ip_BFu1ll_Us)
//============================================================================


struct  Ip_BFu1ll_Vp  {
  int *v1;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 Ip_BFu1ll_Vp) C1{ Fp FL:1 Fp}



static void Test_Ip_BFu1ll_Vp()
{
  {
    init_simple_test("Ip_BFu1ll_Vp");
    static STRUCT_IF_C Ip_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1ll_Vp, Ip_BFu1ll_Vp)
//============================================================================


struct  Ip_BFu1s  {
  int *v1;
  unsigned short v2:1;
};
//SIG(1 Ip_BFu1s) C1{ Fp Fs:1}



static void Test_Ip_BFu1s()
{
  {
    init_simple_test("Ip_BFu1s");
    static STRUCT_IF_C Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s, Ip_BFu1s)
//============================================================================


struct  Ip_BFu1s_BFu15i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu1s_BFu15i) C1{ Fp Fs:1 Fi:15}



static void Test_Ip_BFu1s_BFu15i()
{
  {
    init_simple_test("Ip_BFu1s_BFu15i");
    static STRUCT_IF_C Ip_BFu1s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu15i, Ip_BFu1s_BFu15i)
//============================================================================


struct  Ip_BFu1s_BFu15ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu1s_BFu15ll) C1{ Fp Fs:1 FL:15}



static void Test_Ip_BFu1s_BFu15ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu15ll");
    static STRUCT_IF_C Ip_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu15ll, Ip_BFu1s_BFu15ll)
//============================================================================


struct  Ip_BFu1s_BFu15s  {
  int *v1;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu1s_BFu15s) C1{ Fp Fs:1 Fs:15}



static void Test_Ip_BFu1s_BFu15s()
{
  {
    init_simple_test("Ip_BFu1s_BFu15s");
    static STRUCT_IF_C Ip_BFu1s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Ip_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Ip_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu15s, Ip_BFu1s_BFu15s)
//============================================================================


struct  Ip_BFu1s_BFu16i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu1s_BFu16i) C1{ Fp Fs:1 Fi:16}



static void Test_Ip_BFu1s_BFu16i()
{
  {
    init_simple_test("Ip_BFu1s_BFu16i");
    static STRUCT_IF_C Ip_BFu1s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Ip_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Ip_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu16i, Ip_BFu1s_BFu16i)
//============================================================================


struct  Ip_BFu1s_BFu16ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu1s_BFu16ll) C1{ Fp Fs:1 FL:16}



static void Test_Ip_BFu1s_BFu16ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu16ll");
    static STRUCT_IF_C Ip_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Ip_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Ip_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu16ll, Ip_BFu1s_BFu16ll)
//============================================================================


struct  Ip_BFu1s_BFu16s  {
  int *v1;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu1s_BFu16s) C1{ Fp Fs:1 Fs:16}



static void Test_Ip_BFu1s_BFu16s()
{
  {
    init_simple_test("Ip_BFu1s_BFu16s");
    static STRUCT_IF_C Ip_BFu1s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu16s, Ip_BFu1s_BFu16s)
//============================================================================


struct  Ip_BFu1s_BFu17i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu1s_BFu17i) C1{ Fp Fs:1 Fi:17}



static void Test_Ip_BFu1s_BFu17i()
{
  {
    init_simple_test("Ip_BFu1s_BFu17i");
    static STRUCT_IF_C Ip_BFu1s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Ip_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Ip_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu17i, Ip_BFu1s_BFu17i)
//============================================================================


struct  Ip_BFu1s_BFu17ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu1s_BFu17ll) C1{ Fp Fs:1 FL:17}



static void Test_Ip_BFu1s_BFu17ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu17ll");
    static STRUCT_IF_C Ip_BFu1s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Ip_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Ip_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu17ll, Ip_BFu1s_BFu17ll)
//============================================================================


struct  Ip_BFu1s_BFu1c  {
  int *v1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu1s_BFu1c) C1{ Fp Fs:1 Fc:1}



static void Test_Ip_BFu1s_BFu1c()
{
  {
    init_simple_test("Ip_BFu1s_BFu1c");
    static STRUCT_IF_C Ip_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu1c, Ip_BFu1s_BFu1c)
//============================================================================


struct  Ip_BFu1s_BFu1i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu1s_BFu1i) C1{ Fp Fs:1 Fi:1}



static void Test_Ip_BFu1s_BFu1i()
{
  {
    init_simple_test("Ip_BFu1s_BFu1i");
    static STRUCT_IF_C Ip_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu1i, Ip_BFu1s_BFu1i)
//============================================================================


struct  Ip_BFu1s_BFu1ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu1s_BFu1ll) C1{ Fp Fs:1 FL:1}



static void Test_Ip_BFu1s_BFu1ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu1ll");
    static STRUCT_IF_C Ip_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu1ll, Ip_BFu1s_BFu1ll)
//============================================================================


struct  Ip_BFu1s_BFu1s  {
  int *v1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu1s_BFu1s) C1{ Fp Fs:1 Fs:1}



static void Test_Ip_BFu1s_BFu1s()
{
  {
    init_simple_test("Ip_BFu1s_BFu1s");
    static STRUCT_IF_C Ip_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Ip_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu1s, Ip_BFu1s_BFu1s)
//============================================================================


struct  Ip_BFu1s_BFu31i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu1s_BFu31i) C1{ Fp Fs:1 Fi:31}



static void Test_Ip_BFu1s_BFu31i()
{
  {
    init_simple_test("Ip_BFu1s_BFu31i");
    static STRUCT_IF_C Ip_BFu1s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Ip_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Ip_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu31i, Ip_BFu1s_BFu31i)
//============================================================================


struct  Ip_BFu1s_BFu31ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu1s_BFu31ll) C1{ Fp Fs:1 FL:31}



static void Test_Ip_BFu1s_BFu31ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu31ll");
    static STRUCT_IF_C Ip_BFu1s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Ip_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Ip_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu31ll, Ip_BFu1s_BFu31ll)
//============================================================================


struct  Ip_BFu1s_BFu32i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu1s_BFu32i) C1{ Fp Fs:1 Fi:32}



static void Test_Ip_BFu1s_BFu32i()
{
  {
    init_simple_test("Ip_BFu1s_BFu32i");
    static STRUCT_IF_C Ip_BFu1s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu32i, Ip_BFu1s_BFu32i)
//============================================================================


struct  Ip_BFu1s_BFu32ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu1s_BFu32ll) C1{ Fp Fs:1 FL:32}



static void Test_Ip_BFu1s_BFu32ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu32ll");
    static STRUCT_IF_C Ip_BFu1s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 32, 1, "Ip_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu32ll, Ip_BFu1s_BFu32ll)
//============================================================================


struct  Ip_BFu1s_BFu33  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu1s_BFu33) C1{ Fp Fs:1 FL:33}



static void Test_Ip_BFu1s_BFu33()
{
  {
    init_simple_test("Ip_BFu1s_BFu33");
    static STRUCT_IF_C Ip_BFu1s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 33, 1, "Ip_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu33, Ip_BFu1s_BFu33)
//============================================================================


struct  Ip_BFu1s_BFu7c  {
  int *v1;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu1s_BFu7c) C1{ Fp Fs:1 Fc:7}



static void Test_Ip_BFu1s_BFu7c()
{
  {
    init_simple_test("Ip_BFu1s_BFu7c");
    static STRUCT_IF_C Ip_BFu1s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu7c, Ip_BFu1s_BFu7c)
//============================================================================


struct  Ip_BFu1s_BFu7i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu1s_BFu7i) C1{ Fp Fs:1 Fi:7}



static void Test_Ip_BFu1s_BFu7i()
{
  {
    init_simple_test("Ip_BFu1s_BFu7i");
    static STRUCT_IF_C Ip_BFu1s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu7i, Ip_BFu1s_BFu7i)
//============================================================================


struct  Ip_BFu1s_BFu7ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu1s_BFu7ll) C1{ Fp Fs:1 FL:7}



static void Test_Ip_BFu1s_BFu7ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu7ll");
    static STRUCT_IF_C Ip_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu7ll, Ip_BFu1s_BFu7ll)
//============================================================================


struct  Ip_BFu1s_BFu7s  {
  int *v1;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu1s_BFu7s) C1{ Fp Fs:1 Fs:7}



static void Test_Ip_BFu1s_BFu7s()
{
  {
    init_simple_test("Ip_BFu1s_BFu7s");
    static STRUCT_IF_C Ip_BFu1s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Ip_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Ip_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu7s, Ip_BFu1s_BFu7s)
//============================================================================


struct  Ip_BFu1s_BFu8c  {
  int *v1;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu1s_BFu8c) C1{ Fp Fs:1 Fc:8}



static void Test_Ip_BFu1s_BFu8c()
{
  {
    init_simple_test("Ip_BFu1s_BFu8c");
    static STRUCT_IF_C Ip_BFu1s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu8c, Ip_BFu1s_BFu8c)
//============================================================================


struct  Ip_BFu1s_BFu8i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu1s_BFu8i) C1{ Fp Fs:1 Fi:8}



static void Test_Ip_BFu1s_BFu8i()
{
  {
    init_simple_test("Ip_BFu1s_BFu8i");
    static STRUCT_IF_C Ip_BFu1s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu8i, Ip_BFu1s_BFu8i)
//============================================================================


struct  Ip_BFu1s_BFu8ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu1s_BFu8ll) C1{ Fp Fs:1 FL:8}



static void Test_Ip_BFu1s_BFu8ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu8ll");
    static STRUCT_IF_C Ip_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu8ll, Ip_BFu1s_BFu8ll)
//============================================================================


struct  Ip_BFu1s_BFu8s  {
  int *v1;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu1s_BFu8s) C1{ Fp Fs:1 Fs:8}



static void Test_Ip_BFu1s_BFu8s()
{
  {
    init_simple_test("Ip_BFu1s_BFu8s");
    static STRUCT_IF_C Ip_BFu1s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Ip_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Ip_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu8s, Ip_BFu1s_BFu8s)
//============================================================================


struct  Ip_BFu1s_BFu9i  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu1s_BFu9i) C1{ Fp Fs:1 Fi:9}



static void Test_Ip_BFu1s_BFu9i()
{
  {
    init_simple_test("Ip_BFu1s_BFu9i");
    static STRUCT_IF_C Ip_BFu1s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu9i, Ip_BFu1s_BFu9i)
//============================================================================


struct  Ip_BFu1s_BFu9ll  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu1s_BFu9ll) C1{ Fp Fs:1 FL:9}



static void Test_Ip_BFu1s_BFu9ll()
{
  {
    init_simple_test("Ip_BFu1s_BFu9ll");
    static STRUCT_IF_C Ip_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu9ll, Ip_BFu1s_BFu9ll)
//============================================================================


struct  Ip_BFu1s_BFu9s  {
  int *v1;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu1s_BFu9s) C1{ Fp Fs:1 Fs:9}



static void Test_Ip_BFu1s_BFu9s()
{
  {
    init_simple_test("Ip_BFu1s_BFu9s");
    static STRUCT_IF_C Ip_BFu1s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Ip_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Ip_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_BFu9s, Ip_BFu1s_BFu9s)
//============================================================================


struct  Ip_BFu1s_C  {
  int *v1;
  unsigned short v2:1;
  char v3;
};
//SIG(1 Ip_BFu1s_C) C1{ Fp Fs:1 Fc}



static void Test_Ip_BFu1s_C()
{
  {
    init_simple_test("Ip_BFu1s_C");
    static STRUCT_IF_C Ip_BFu1s_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_C, Ip_BFu1s_C)
//============================================================================


struct  Ip_BFu1s_D  {
  int *v1;
  unsigned short v2:1;
  double v3;
};
//SIG(1 Ip_BFu1s_D) C1{ Fp Fs:1 FL}



static void Test_Ip_BFu1s_D()
{
  {
    init_simple_test("Ip_BFu1s_D");
    static STRUCT_IF_C Ip_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_D, Ip_BFu1s_D)
//============================================================================


struct  Ip_BFu1s_F  {
  int *v1;
  unsigned short v2:1;
  float v3;
};
//SIG(1 Ip_BFu1s_F) C1{ Fp Fs:1 Fi}



static void Test_Ip_BFu1s_F()
{
  {
    init_simple_test("Ip_BFu1s_F");
    static STRUCT_IF_C Ip_BFu1s_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_F, Ip_BFu1s_F)
//============================================================================


struct  Ip_BFu1s_I  {
  int *v1;
  unsigned short v2:1;
  int v3;
};
//SIG(1 Ip_BFu1s_I) C1{ Fp Fs:1 Fi}



static void Test_Ip_BFu1s_I()
{
  {
    init_simple_test("Ip_BFu1s_I");
    static STRUCT_IF_C Ip_BFu1s_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_I, Ip_BFu1s_I)
//============================================================================


struct  Ip_BFu1s_Ip  {
  int *v1;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 Ip_BFu1s_Ip) C1{ Fp Fs:1 Fp}



static void Test_Ip_BFu1s_Ip()
{
  {
    init_simple_test("Ip_BFu1s_Ip");
    static STRUCT_IF_C Ip_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_Ip, Ip_BFu1s_Ip)
//============================================================================


struct  Ip_BFu1s_L  {
  int *v1;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 Ip_BFu1s_L) C1{ Fp Fs:1 FL}



static void Test_Ip_BFu1s_L()
{
  {
    init_simple_test("Ip_BFu1s_L");
    static STRUCT_IF_C Ip_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_L, Ip_BFu1s_L)
//============================================================================


struct  Ip_BFu1s_S  {
  int *v1;
  unsigned short v2:1;
  short v3;
};
//SIG(1 Ip_BFu1s_S) C1{ Fp Fs:1 Fs}



static void Test_Ip_BFu1s_S()
{
  {
    init_simple_test("Ip_BFu1s_S");
    static STRUCT_IF_C Ip_BFu1s_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_S, Ip_BFu1s_S)
//============================================================================


struct  Ip_BFu1s_Uc  {
  int *v1;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 Ip_BFu1s_Uc) C1{ Fp Fs:1 Fc}



static void Test_Ip_BFu1s_Uc()
{
  {
    init_simple_test("Ip_BFu1s_Uc");
    static STRUCT_IF_C Ip_BFu1s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_Uc, Ip_BFu1s_Uc)
//============================================================================


struct  Ip_BFu1s_Ui  {
  int *v1;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 Ip_BFu1s_Ui) C1{ Fp Fs:1 Fi}



static void Test_Ip_BFu1s_Ui()
{
  {
    init_simple_test("Ip_BFu1s_Ui");
    static STRUCT_IF_C Ip_BFu1s_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu1s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_Ui, Ip_BFu1s_Ui)
//============================================================================


struct  Ip_BFu1s_Ul  {
  int *v1;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 Ip_BFu1s_Ul) C1{ Fp Fs:1 FL}



static void Test_Ip_BFu1s_Ul()
{
  {
    init_simple_test("Ip_BFu1s_Ul");
    static STRUCT_IF_C Ip_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_Ul, Ip_BFu1s_Ul)
//============================================================================


struct  Ip_BFu1s_Us  {
  int *v1;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 Ip_BFu1s_Us) C1{ Fp Fs:1 Fs}



static void Test_Ip_BFu1s_Us()
{
  {
    init_simple_test("Ip_BFu1s_Us");
    static STRUCT_IF_C Ip_BFu1s_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu1s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_Us, Ip_BFu1s_Us)
//============================================================================


struct  Ip_BFu1s_Vp  {
  int *v1;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 Ip_BFu1s_Vp) C1{ Fp Fs:1 Fp}



static void Test_Ip_BFu1s_Vp()
{
  {
    init_simple_test("Ip_BFu1s_Vp");
    static STRUCT_IF_C Ip_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ip_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu1s_Vp, Ip_BFu1s_Vp)
//============================================================================


struct  Ip_BFu31i  {
  int *v1;
  unsigned int v2:31;
};
//SIG(1 Ip_BFu31i) C1{ Fp Fi:31}



static void Test_Ip_BFu31i()
{
  {
    init_simple_test("Ip_BFu31i");
    static STRUCT_IF_C Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i, Ip_BFu31i)
//============================================================================


struct  Ip_BFu31i_BFu15i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu31i_BFu15i) C1{ Fp Fi:31 Fi:15}



static void Test_Ip_BFu31i_BFu15i()
{
  {
    init_simple_test("Ip_BFu31i_BFu15i");
    static STRUCT_IF_C Ip_BFu31i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu15i, Ip_BFu31i_BFu15i)
//============================================================================


struct  Ip_BFu31i_BFu15ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu31i_BFu15ll) C1{ Fp Fi:31 FL:15}



static void Test_Ip_BFu31i_BFu15ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu15ll");
    static STRUCT_IF_C Ip_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 15, 1, "Ip_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 15, hide_ull(1LL<<14), "Ip_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu15ll, Ip_BFu31i_BFu15ll)
//============================================================================


struct  Ip_BFu31i_BFu15s  {
  int *v1;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu31i_BFu15s) C1{ Fp Fi:31 Fs:15}



static void Test_Ip_BFu31i_BFu15s()
{
  {
    init_simple_test("Ip_BFu31i_BFu15s");
    static STRUCT_IF_C Ip_BFu31i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu15s, Ip_BFu31i_BFu15s)
//============================================================================


struct  Ip_BFu31i_BFu16i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu31i_BFu16i) C1{ Fp Fi:31 Fi:16}



static void Test_Ip_BFu31i_BFu16i()
{
  {
    init_simple_test("Ip_BFu31i_BFu16i");
    static STRUCT_IF_C Ip_BFu31i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu16i, Ip_BFu31i_BFu16i)
//============================================================================


struct  Ip_BFu31i_BFu16ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu31i_BFu16ll) C1{ Fp Fi:31 FL:16}



static void Test_Ip_BFu31i_BFu16ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu16ll");
    static STRUCT_IF_C Ip_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 16, 1, "Ip_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 16, hide_ull(1LL<<15), "Ip_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu16ll, Ip_BFu31i_BFu16ll)
//============================================================================


struct  Ip_BFu31i_BFu16s  {
  int *v1;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu31i_BFu16s) C1{ Fp Fi:31 Fs:16}



static void Test_Ip_BFu31i_BFu16s()
{
  {
    init_simple_test("Ip_BFu31i_BFu16s");
    static STRUCT_IF_C Ip_BFu31i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu16s, Ip_BFu31i_BFu16s)
//============================================================================


struct  Ip_BFu31i_BFu17i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu31i_BFu17i) C1{ Fp Fi:31 Fi:17}



static void Test_Ip_BFu31i_BFu17i()
{
  {
    init_simple_test("Ip_BFu31i_BFu17i");
    static STRUCT_IF_C Ip_BFu31i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu17i, Ip_BFu31i_BFu17i)
//============================================================================


struct  Ip_BFu31i_BFu17ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu31i_BFu17ll) C1{ Fp Fi:31 FL:17}



static void Test_Ip_BFu31i_BFu17ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu17ll");
    static STRUCT_IF_C Ip_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 17, 1, "Ip_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 17, hide_ull(1LL<<16), "Ip_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu17ll, Ip_BFu31i_BFu17ll)
//============================================================================


struct  Ip_BFu31i_BFu1c  {
  int *v1;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu31i_BFu1c) C1{ Fp Fi:31 Fc:1}



static void Test_Ip_BFu31i_BFu1c()
{
  {
    init_simple_test("Ip_BFu31i_BFu1c");
    static STRUCT_IF_C Ip_BFu31i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Ip_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu1c, Ip_BFu31i_BFu1c)
//============================================================================


struct  Ip_BFu31i_BFu1i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu31i_BFu1i) C1{ Fp Fi:31 Fi:1}



static void Test_Ip_BFu31i_BFu1i()
{
  {
    init_simple_test("Ip_BFu31i_BFu1i");
    static STRUCT_IF_C Ip_BFu31i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Ip_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu1i, Ip_BFu31i_BFu1i)
//============================================================================


struct  Ip_BFu31i_BFu1ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu31i_BFu1ll) C1{ Fp Fi:31 FL:1}



static void Test_Ip_BFu31i_BFu1ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu1ll");
    static STRUCT_IF_C Ip_BFu31i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Ip_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu1ll, Ip_BFu31i_BFu1ll)
//============================================================================


struct  Ip_BFu31i_BFu1s  {
  int *v1;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu31i_BFu1s) C1{ Fp Fi:31 Fs:1}



static void Test_Ip_BFu31i_BFu1s()
{
  {
    init_simple_test("Ip_BFu31i_BFu1s");
    static STRUCT_IF_C Ip_BFu31i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Ip_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu1s, Ip_BFu31i_BFu1s)
//============================================================================


struct  Ip_BFu31i_BFu31i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu31i_BFu31i) C1{ Fp Fi:31 Fi:31}



static void Test_Ip_BFu31i_BFu31i()
{
  {
    init_simple_test("Ip_BFu31i_BFu31i");
    static STRUCT_IF_C Ip_BFu31i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu31i, Ip_BFu31i_BFu31i)
//============================================================================


struct  Ip_BFu31i_BFu31ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu31i_BFu31ll) C1{ Fp Fi:31 FL:31}



static void Test_Ip_BFu31i_BFu31ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu31ll");
    static STRUCT_IF_C Ip_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 31, 1, "Ip_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu31ll, Ip_BFu31i_BFu31ll)
//============================================================================


struct  Ip_BFu31i_BFu32i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu31i_BFu32i) C1{ Fp Fi:31 Fi:32}



static void Test_Ip_BFu31i_BFu32i()
{
  {
    init_simple_test("Ip_BFu31i_BFu32i");
    static STRUCT_IF_C Ip_BFu31i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu32i, Ip_BFu31i_BFu32i)
//============================================================================


struct  Ip_BFu31i_BFu32ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu31i_BFu32ll) C1{ Fp Fi:31 FL:32}



static void Test_Ip_BFu31i_BFu32ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu32ll");
    static STRUCT_IF_C Ip_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 32, 1, "Ip_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 32, hide_ull(1LL<<31), "Ip_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu32ll, Ip_BFu31i_BFu32ll)
//============================================================================


struct  Ip_BFu31i_BFu33  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu31i_BFu33) C1{ Fp Fi:31 FL:33}



static void Test_Ip_BFu31i_BFu33()
{
  {
    init_simple_test("Ip_BFu31i_BFu33");
    static STRUCT_IF_C Ip_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 33, 1, "Ip_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 33, hide_ull(1LL<<32), "Ip_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu33, Ip_BFu31i_BFu33)
//============================================================================


struct  Ip_BFu31i_BFu7c  {
  int *v1;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu31i_BFu7c) C1{ Fp Fi:31 Fc:7}



static void Test_Ip_BFu31i_BFu7c()
{
  {
    init_simple_test("Ip_BFu31i_BFu7c");
    static STRUCT_IF_C Ip_BFu31i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu7c, Ip_BFu31i_BFu7c)
//============================================================================


struct  Ip_BFu31i_BFu7i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu31i_BFu7i) C1{ Fp Fi:31 Fi:7}



static void Test_Ip_BFu31i_BFu7i()
{
  {
    init_simple_test("Ip_BFu31i_BFu7i");
    static STRUCT_IF_C Ip_BFu31i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu7i, Ip_BFu31i_BFu7i)
//============================================================================


struct  Ip_BFu31i_BFu7ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu31i_BFu7ll) C1{ Fp Fi:31 FL:7}



static void Test_Ip_BFu31i_BFu7ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu7ll");
    static STRUCT_IF_C Ip_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 7, 1, "Ip_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 7, hide_ull(1LL<<6), "Ip_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu7ll, Ip_BFu31i_BFu7ll)
//============================================================================


struct  Ip_BFu31i_BFu7s  {
  int *v1;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu31i_BFu7s) C1{ Fp Fi:31 Fs:7}



static void Test_Ip_BFu31i_BFu7s()
{
  {
    init_simple_test("Ip_BFu31i_BFu7s");
    static STRUCT_IF_C Ip_BFu31i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu7s, Ip_BFu31i_BFu7s)
//============================================================================


struct  Ip_BFu31i_BFu8c  {
  int *v1;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu31i_BFu8c) C1{ Fp Fi:31 Fc:8}



static void Test_Ip_BFu31i_BFu8c()
{
  {
    init_simple_test("Ip_BFu31i_BFu8c");
    static STRUCT_IF_C Ip_BFu31i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu8c, Ip_BFu31i_BFu8c)
//============================================================================


struct  Ip_BFu31i_BFu8i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu31i_BFu8i) C1{ Fp Fi:31 Fi:8}



static void Test_Ip_BFu31i_BFu8i()
{
  {
    init_simple_test("Ip_BFu31i_BFu8i");
    static STRUCT_IF_C Ip_BFu31i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu8i, Ip_BFu31i_BFu8i)
//============================================================================


struct  Ip_BFu31i_BFu8ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu31i_BFu8ll) C1{ Fp Fi:31 FL:8}



static void Test_Ip_BFu31i_BFu8ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu8ll");
    static STRUCT_IF_C Ip_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 8, 1, "Ip_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 8, hide_ull(1LL<<7), "Ip_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu8ll, Ip_BFu31i_BFu8ll)
//============================================================================


struct  Ip_BFu31i_BFu8s  {
  int *v1;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu31i_BFu8s) C1{ Fp Fi:31 Fs:8}



static void Test_Ip_BFu31i_BFu8s()
{
  {
    init_simple_test("Ip_BFu31i_BFu8s");
    static STRUCT_IF_C Ip_BFu31i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu8s, Ip_BFu31i_BFu8s)
//============================================================================


struct  Ip_BFu31i_BFu9i  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu31i_BFu9i) C1{ Fp Fi:31 Fi:9}



static void Test_Ip_BFu31i_BFu9i()
{
  {
    init_simple_test("Ip_BFu31i_BFu9i");
    static STRUCT_IF_C Ip_BFu31i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu9i, Ip_BFu31i_BFu9i)
//============================================================================


struct  Ip_BFu31i_BFu9ll  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu31i_BFu9ll) C1{ Fp Fi:31 FL:9}



static void Test_Ip_BFu31i_BFu9ll()
{
  {
    init_simple_test("Ip_BFu31i_BFu9ll");
    static STRUCT_IF_C Ip_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 9, 1, "Ip_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 9, hide_ull(1LL<<8), "Ip_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu9ll, Ip_BFu31i_BFu9ll)
//============================================================================


struct  Ip_BFu31i_BFu9s  {
  int *v1;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu31i_BFu9s) C1{ Fp Fi:31 Fs:9}



static void Test_Ip_BFu31i_BFu9s()
{
  {
    init_simple_test("Ip_BFu31i_BFu9s");
    static STRUCT_IF_C Ip_BFu31i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_BFu9s, Ip_BFu31i_BFu9s)
//============================================================================


struct  Ip_BFu31i_C  {
  int *v1;
  unsigned int v2:31;
  char v3;
};
//SIG(1 Ip_BFu31i_C) C1{ Fp Fi:31 Fc}



static void Test_Ip_BFu31i_C()
{
  {
    init_simple_test("Ip_BFu31i_C");
    static STRUCT_IF_C Ip_BFu31i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_C, Ip_BFu31i_C)
//============================================================================


struct  Ip_BFu31i_D  {
  int *v1;
  unsigned int v2:31;
  double v3;
};
//SIG(1 Ip_BFu31i_D) C1{ Fp Fi:31 FL}



static void Test_Ip_BFu31i_D()
{
  {
    init_simple_test("Ip_BFu31i_D");
    static STRUCT_IF_C Ip_BFu31i_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_D, Ip_BFu31i_D)
//============================================================================


struct  Ip_BFu31i_F  {
  int *v1;
  unsigned int v2:31;
  float v3;
};
//SIG(1 Ip_BFu31i_F) C1{ Fp Fi:31 Fi}



static void Test_Ip_BFu31i_F()
{
  {
    init_simple_test("Ip_BFu31i_F");
    static STRUCT_IF_C Ip_BFu31i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_F, Ip_BFu31i_F)
//============================================================================


struct  Ip_BFu31i_I  {
  int *v1;
  unsigned int v2:31;
  int v3;
};
//SIG(1 Ip_BFu31i_I) C1{ Fp Fi:31 Fi}



static void Test_Ip_BFu31i_I()
{
  {
    init_simple_test("Ip_BFu31i_I");
    static STRUCT_IF_C Ip_BFu31i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_I, Ip_BFu31i_I)
//============================================================================


struct  Ip_BFu31i_Ip  {
  int *v1;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 Ip_BFu31i_Ip) C1{ Fp Fi:31 Fp}



static void Test_Ip_BFu31i_Ip()
{
  {
    init_simple_test("Ip_BFu31i_Ip");
    static STRUCT_IF_C Ip_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_Ip, Ip_BFu31i_Ip)
//============================================================================


struct  Ip_BFu31i_L  {
  int *v1;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 Ip_BFu31i_L) C1{ Fp Fi:31 FL}



static void Test_Ip_BFu31i_L()
{
  {
    init_simple_test("Ip_BFu31i_L");
    static STRUCT_IF_C Ip_BFu31i_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_L, Ip_BFu31i_L)
//============================================================================


struct  Ip_BFu31i_S  {
  int *v1;
  unsigned int v2:31;
  short v3;
};
//SIG(1 Ip_BFu31i_S) C1{ Fp Fi:31 Fs}



static void Test_Ip_BFu31i_S()
{
  {
    init_simple_test("Ip_BFu31i_S");
    static STRUCT_IF_C Ip_BFu31i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_S, Ip_BFu31i_S)
//============================================================================


struct  Ip_BFu31i_Uc  {
  int *v1;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 Ip_BFu31i_Uc) C1{ Fp Fi:31 Fc}



static void Test_Ip_BFu31i_Uc()
{
  {
    init_simple_test("Ip_BFu31i_Uc");
    static STRUCT_IF_C Ip_BFu31i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_Uc, Ip_BFu31i_Uc)
//============================================================================


struct  Ip_BFu31i_Ui  {
  int *v1;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 Ip_BFu31i_Ui) C1{ Fp Fi:31 Fi}



static void Test_Ip_BFu31i_Ui()
{
  {
    init_simple_test("Ip_BFu31i_Ui");
    static STRUCT_IF_C Ip_BFu31i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_Ui, Ip_BFu31i_Ui)
//============================================================================


struct  Ip_BFu31i_Ul  {
  int *v1;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 Ip_BFu31i_Ul) C1{ Fp Fi:31 FL}



static void Test_Ip_BFu31i_Ul()
{
  {
    init_simple_test("Ip_BFu31i_Ul");
    static STRUCT_IF_C Ip_BFu31i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_Ul, Ip_BFu31i_Ul)
//============================================================================


struct  Ip_BFu31i_Us  {
  int *v1;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 Ip_BFu31i_Us) C1{ Fp Fi:31 Fs}



static void Test_Ip_BFu31i_Us()
{
  {
    init_simple_test("Ip_BFu31i_Us");
    static STRUCT_IF_C Ip_BFu31i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_Us, Ip_BFu31i_Us)
//============================================================================


struct  Ip_BFu31i_Vp  {
  int *v1;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 Ip_BFu31i_Vp) C1{ Fp Fi:31 Fp}



static void Test_Ip_BFu31i_Vp()
{
  {
    init_simple_test("Ip_BFu31i_Vp");
    static STRUCT_IF_C Ip_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31i_Vp, Ip_BFu31i_Vp)
//============================================================================


struct  Ip_BFu31ll  {
  int *v1;
  __tsu64 v2:31;
};
//SIG(1 Ip_BFu31ll) C1{ Fp FL:31}



static void Test_Ip_BFu31ll()
{
  {
    init_simple_test("Ip_BFu31ll");
    static STRUCT_IF_C Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll, Ip_BFu31ll)
//============================================================================


struct  Ip_BFu31ll_BFu15i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu31ll_BFu15i) C1{ Fp FL:31 Fi:15}



static void Test_Ip_BFu31ll_BFu15i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu15i");
    static STRUCT_IF_C Ip_BFu31ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu15i, Ip_BFu31ll_BFu15i)
//============================================================================


struct  Ip_BFu31ll_BFu15ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu31ll_BFu15ll) C1{ Fp FL:31 FL:15}



static void Test_Ip_BFu31ll_BFu15ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu15ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 15, 1, "Ip_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 15, hide_ull(1LL<<14), "Ip_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu15ll, Ip_BFu31ll_BFu15ll)
//============================================================================


struct  Ip_BFu31ll_BFu15s  {
  int *v1;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu31ll_BFu15s) C1{ Fp FL:31 Fs:15}



static void Test_Ip_BFu31ll_BFu15s()
{
  {
    init_simple_test("Ip_BFu31ll_BFu15s");
    static STRUCT_IF_C Ip_BFu31ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu15s, Ip_BFu31ll_BFu15s)
//============================================================================


struct  Ip_BFu31ll_BFu16i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu31ll_BFu16i) C1{ Fp FL:31 Fi:16}



static void Test_Ip_BFu31ll_BFu16i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu16i");
    static STRUCT_IF_C Ip_BFu31ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu16i, Ip_BFu31ll_BFu16i)
//============================================================================


struct  Ip_BFu31ll_BFu16ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu31ll_BFu16ll) C1{ Fp FL:31 FL:16}



static void Test_Ip_BFu31ll_BFu16ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu16ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 16, 1, "Ip_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 16, hide_ull(1LL<<15), "Ip_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu16ll, Ip_BFu31ll_BFu16ll)
//============================================================================


struct  Ip_BFu31ll_BFu16s  {
  int *v1;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu31ll_BFu16s) C1{ Fp FL:31 Fs:16}



static void Test_Ip_BFu31ll_BFu16s()
{
  {
    init_simple_test("Ip_BFu31ll_BFu16s");
    static STRUCT_IF_C Ip_BFu31ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu16s, Ip_BFu31ll_BFu16s)
//============================================================================


struct  Ip_BFu31ll_BFu17i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu31ll_BFu17i) C1{ Fp FL:31 Fi:17}



static void Test_Ip_BFu31ll_BFu17i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu17i");
    static STRUCT_IF_C Ip_BFu31ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu17i, Ip_BFu31ll_BFu17i)
//============================================================================


struct  Ip_BFu31ll_BFu17ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu31ll_BFu17ll) C1{ Fp FL:31 FL:17}



static void Test_Ip_BFu31ll_BFu17ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu17ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 17, 1, "Ip_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 17, hide_ull(1LL<<16), "Ip_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu17ll, Ip_BFu31ll_BFu17ll)
//============================================================================


struct  Ip_BFu31ll_BFu1c  {
  int *v1;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu31ll_BFu1c) C1{ Fp FL:31 Fc:1}



static void Test_Ip_BFu31ll_BFu1c()
{
  {
    init_simple_test("Ip_BFu31ll_BFu1c");
    static STRUCT_IF_C Ip_BFu31ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Ip_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu1c, Ip_BFu31ll_BFu1c)
//============================================================================


struct  Ip_BFu31ll_BFu1i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu31ll_BFu1i) C1{ Fp FL:31 Fi:1}



static void Test_Ip_BFu31ll_BFu1i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu1i");
    static STRUCT_IF_C Ip_BFu31ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Ip_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu1i, Ip_BFu31ll_BFu1i)
//============================================================================


struct  Ip_BFu31ll_BFu1ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu31ll_BFu1ll) C1{ Fp FL:31 FL:1}



static void Test_Ip_BFu31ll_BFu1ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu1ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Ip_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu1ll, Ip_BFu31ll_BFu1ll)
//============================================================================


struct  Ip_BFu31ll_BFu1s  {
  int *v1;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu31ll_BFu1s) C1{ Fp FL:31 Fs:1}



static void Test_Ip_BFu31ll_BFu1s()
{
  {
    init_simple_test("Ip_BFu31ll_BFu1s");
    static STRUCT_IF_C Ip_BFu31ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Ip_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu1s, Ip_BFu31ll_BFu1s)
//============================================================================


struct  Ip_BFu31ll_BFu31i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu31ll_BFu31i) C1{ Fp FL:31 Fi:31}



static void Test_Ip_BFu31ll_BFu31i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu31i");
    static STRUCT_IF_C Ip_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu31i, Ip_BFu31ll_BFu31i)
//============================================================================


struct  Ip_BFu31ll_BFu31ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu31ll_BFu31ll) C1{ Fp FL:31 FL:31}



static void Test_Ip_BFu31ll_BFu31ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu31ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 31, 1, "Ip_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu31ll, Ip_BFu31ll_BFu31ll)
//============================================================================


struct  Ip_BFu31ll_BFu32i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu31ll_BFu32i) C1{ Fp FL:31 Fi:32}



static void Test_Ip_BFu31ll_BFu32i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu32i");
    static STRUCT_IF_C Ip_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu32i, Ip_BFu31ll_BFu32i)
//============================================================================


struct  Ip_BFu31ll_BFu32ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu31ll_BFu32ll) C1{ Fp FL:31 FL:32}



static void Test_Ip_BFu31ll_BFu32ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu32ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 32, 1, "Ip_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 32, hide_ull(1LL<<31), "Ip_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu32ll, Ip_BFu31ll_BFu32ll)
//============================================================================


struct  Ip_BFu31ll_BFu33  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu31ll_BFu33) C1{ Fp FL:31 FL:33}



static void Test_Ip_BFu31ll_BFu33()
{
  {
    init_simple_test("Ip_BFu31ll_BFu33");
    static STRUCT_IF_C Ip_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 33, 1, "Ip_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 33, hide_ull(1LL<<32), "Ip_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu33, Ip_BFu31ll_BFu33)
//============================================================================


struct  Ip_BFu31ll_BFu7c  {
  int *v1;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu31ll_BFu7c) C1{ Fp FL:31 Fc:7}



static void Test_Ip_BFu31ll_BFu7c()
{
  {
    init_simple_test("Ip_BFu31ll_BFu7c");
    static STRUCT_IF_C Ip_BFu31ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu7c, Ip_BFu31ll_BFu7c)
//============================================================================


struct  Ip_BFu31ll_BFu7i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu31ll_BFu7i) C1{ Fp FL:31 Fi:7}



static void Test_Ip_BFu31ll_BFu7i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu7i");
    static STRUCT_IF_C Ip_BFu31ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu7i, Ip_BFu31ll_BFu7i)
//============================================================================


struct  Ip_BFu31ll_BFu7ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu31ll_BFu7ll) C1{ Fp FL:31 FL:7}



static void Test_Ip_BFu31ll_BFu7ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu7ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 7, 1, "Ip_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 7, hide_ull(1LL<<6), "Ip_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu7ll, Ip_BFu31ll_BFu7ll)
//============================================================================


struct  Ip_BFu31ll_BFu7s  {
  int *v1;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu31ll_BFu7s) C1{ Fp FL:31 Fs:7}



static void Test_Ip_BFu31ll_BFu7s()
{
  {
    init_simple_test("Ip_BFu31ll_BFu7s");
    static STRUCT_IF_C Ip_BFu31ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu7s, Ip_BFu31ll_BFu7s)
//============================================================================


struct  Ip_BFu31ll_BFu8c  {
  int *v1;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu31ll_BFu8c) C1{ Fp FL:31 Fc:8}



static void Test_Ip_BFu31ll_BFu8c()
{
  {
    init_simple_test("Ip_BFu31ll_BFu8c");
    static STRUCT_IF_C Ip_BFu31ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu8c, Ip_BFu31ll_BFu8c)
//============================================================================


struct  Ip_BFu31ll_BFu8i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu31ll_BFu8i) C1{ Fp FL:31 Fi:8}



static void Test_Ip_BFu31ll_BFu8i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu8i");
    static STRUCT_IF_C Ip_BFu31ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu8i, Ip_BFu31ll_BFu8i)
//============================================================================


struct  Ip_BFu31ll_BFu8ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu31ll_BFu8ll) C1{ Fp FL:31 FL:8}



static void Test_Ip_BFu31ll_BFu8ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu8ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 8, 1, "Ip_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 8, hide_ull(1LL<<7), "Ip_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu8ll, Ip_BFu31ll_BFu8ll)
//============================================================================


struct  Ip_BFu31ll_BFu8s  {
  int *v1;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu31ll_BFu8s) C1{ Fp FL:31 Fs:8}



static void Test_Ip_BFu31ll_BFu8s()
{
  {
    init_simple_test("Ip_BFu31ll_BFu8s");
    static STRUCT_IF_C Ip_BFu31ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu8s, Ip_BFu31ll_BFu8s)
//============================================================================


struct  Ip_BFu31ll_BFu9i  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu31ll_BFu9i) C1{ Fp FL:31 Fi:9}



static void Test_Ip_BFu31ll_BFu9i()
{
  {
    init_simple_test("Ip_BFu31ll_BFu9i");
    static STRUCT_IF_C Ip_BFu31ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu9i, Ip_BFu31ll_BFu9i)
//============================================================================


struct  Ip_BFu31ll_BFu9ll  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu31ll_BFu9ll) C1{ Fp FL:31 FL:9}



static void Test_Ip_BFu31ll_BFu9ll()
{
  {
    init_simple_test("Ip_BFu31ll_BFu9ll");
    static STRUCT_IF_C Ip_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 9, 1, "Ip_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), ABISELECT(7,7), 9, hide_ull(1LL<<8), "Ip_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu9ll, Ip_BFu31ll_BFu9ll)
//============================================================================


struct  Ip_BFu31ll_BFu9s  {
  int *v1;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu31ll_BFu9s) C1{ Fp FL:31 Fs:9}



static void Test_Ip_BFu31ll_BFu9s()
{
  {
    init_simple_test("Ip_BFu31ll_BFu9s");
    static STRUCT_IF_C Ip_BFu31ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_BFu9s, Ip_BFu31ll_BFu9s)
//============================================================================


struct  Ip_BFu31ll_C  {
  int *v1;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 Ip_BFu31ll_C) C1{ Fp FL:31 Fc}



static void Test_Ip_BFu31ll_C()
{
  {
    init_simple_test("Ip_BFu31ll_C");
    static STRUCT_IF_C Ip_BFu31ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_C, Ip_BFu31ll_C)
//============================================================================


struct  Ip_BFu31ll_D  {
  int *v1;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 Ip_BFu31ll_D) C1{ Fp FL:31 FL}



static void Test_Ip_BFu31ll_D()
{
  {
    init_simple_test("Ip_BFu31ll_D");
    static STRUCT_IF_C Ip_BFu31ll_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_D, Ip_BFu31ll_D)
//============================================================================


struct  Ip_BFu31ll_F  {
  int *v1;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 Ip_BFu31ll_F) C1{ Fp FL:31 Fi}



static void Test_Ip_BFu31ll_F()
{
  {
    init_simple_test("Ip_BFu31ll_F");
    static STRUCT_IF_C Ip_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_F, Ip_BFu31ll_F)
//============================================================================


struct  Ip_BFu31ll_I  {
  int *v1;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 Ip_BFu31ll_I) C1{ Fp FL:31 Fi}



static void Test_Ip_BFu31ll_I()
{
  {
    init_simple_test("Ip_BFu31ll_I");
    static STRUCT_IF_C Ip_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_I, Ip_BFu31ll_I)
//============================================================================


struct  Ip_BFu31ll_Ip  {
  int *v1;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 Ip_BFu31ll_Ip) C1{ Fp FL:31 Fp}



static void Test_Ip_BFu31ll_Ip()
{
  {
    init_simple_test("Ip_BFu31ll_Ip");
    static STRUCT_IF_C Ip_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_Ip, Ip_BFu31ll_Ip)
//============================================================================


struct  Ip_BFu31ll_L  {
  int *v1;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 Ip_BFu31ll_L) C1{ Fp FL:31 FL}



static void Test_Ip_BFu31ll_L()
{
  {
    init_simple_test("Ip_BFu31ll_L");
    static STRUCT_IF_C Ip_BFu31ll_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_L, Ip_BFu31ll_L)
//============================================================================


struct  Ip_BFu31ll_S  {
  int *v1;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 Ip_BFu31ll_S) C1{ Fp FL:31 Fs}



static void Test_Ip_BFu31ll_S()
{
  {
    init_simple_test("Ip_BFu31ll_S");
    static STRUCT_IF_C Ip_BFu31ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_S, Ip_BFu31ll_S)
//============================================================================


struct  Ip_BFu31ll_Uc  {
  int *v1;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 Ip_BFu31ll_Uc) C1{ Fp FL:31 Fc}



static void Test_Ip_BFu31ll_Uc()
{
  {
    init_simple_test("Ip_BFu31ll_Uc");
    static STRUCT_IF_C Ip_BFu31ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_Uc, Ip_BFu31ll_Uc)
//============================================================================


struct  Ip_BFu31ll_Ui  {
  int *v1;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 Ip_BFu31ll_Ui) C1{ Fp FL:31 Fi}



static void Test_Ip_BFu31ll_Ui()
{
  {
    init_simple_test("Ip_BFu31ll_Ui");
    static STRUCT_IF_C Ip_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_Ui, Ip_BFu31ll_Ui)
//============================================================================


struct  Ip_BFu31ll_Ul  {
  int *v1;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 Ip_BFu31ll_Ul) C1{ Fp FL:31 FL}



static void Test_Ip_BFu31ll_Ul()
{
  {
    init_simple_test("Ip_BFu31ll_Ul");
    static STRUCT_IF_C Ip_BFu31ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_Ul, Ip_BFu31ll_Ul)
//============================================================================


struct  Ip_BFu31ll_Us  {
  int *v1;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 Ip_BFu31ll_Us) C1{ Fp FL:31 Fs}



static void Test_Ip_BFu31ll_Us()
{
  {
    init_simple_test("Ip_BFu31ll_Us");
    static STRUCT_IF_C Ip_BFu31ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_Us, Ip_BFu31ll_Us)
//============================================================================


struct  Ip_BFu31ll_Vp  {
  int *v1;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 Ip_BFu31ll_Vp) C1{ Fp FL:31 Fp}



static void Test_Ip_BFu31ll_Vp()
{
  {
    init_simple_test("Ip_BFu31ll_Vp");
    static STRUCT_IF_C Ip_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ip_BFu31ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ip_BFu31ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu31ll_Vp, Ip_BFu31ll_Vp)
//============================================================================


struct  Ip_BFu32i  {
  int *v1;
  unsigned int v2:32;
};
//SIG(1 Ip_BFu32i) C1{ Fp Fi:32}



static void Test_Ip_BFu32i()
{
  {
    init_simple_test("Ip_BFu32i");
    static STRUCT_IF_C Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i, Ip_BFu32i)
//============================================================================


struct  Ip_BFu32i_BFu15i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu32i_BFu15i) C1{ Fp Fi:32 Fi:15}



static void Test_Ip_BFu32i_BFu15i()
{
  {
    init_simple_test("Ip_BFu32i_BFu15i");
    static STRUCT_IF_C Ip_BFu32i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu15i, Ip_BFu32i_BFu15i)
//============================================================================


struct  Ip_BFu32i_BFu15ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu32i_BFu15ll) C1{ Fp Fi:32 FL:15}



static void Test_Ip_BFu32i_BFu15ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu15ll");
    static STRUCT_IF_C Ip_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu15ll, Ip_BFu32i_BFu15ll)
//============================================================================


struct  Ip_BFu32i_BFu15s  {
  int *v1;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu32i_BFu15s) C1{ Fp Fi:32 Fs:15}



static void Test_Ip_BFu32i_BFu15s()
{
  {
    init_simple_test("Ip_BFu32i_BFu15s");
    static STRUCT_IF_C Ip_BFu32i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu15s, Ip_BFu32i_BFu15s)
//============================================================================


struct  Ip_BFu32i_BFu16i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu32i_BFu16i) C1{ Fp Fi:32 Fi:16}



static void Test_Ip_BFu32i_BFu16i()
{
  {
    init_simple_test("Ip_BFu32i_BFu16i");
    static STRUCT_IF_C Ip_BFu32i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu16i, Ip_BFu32i_BFu16i)
//============================================================================


struct  Ip_BFu32i_BFu16ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu32i_BFu16ll) C1{ Fp Fi:32 FL:16}



static void Test_Ip_BFu32i_BFu16ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu16ll");
    static STRUCT_IF_C Ip_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu16ll, Ip_BFu32i_BFu16ll)
//============================================================================


struct  Ip_BFu32i_BFu16s  {
  int *v1;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu32i_BFu16s) C1{ Fp Fi:32 Fs:16}



static void Test_Ip_BFu32i_BFu16s()
{
  {
    init_simple_test("Ip_BFu32i_BFu16s");
    static STRUCT_IF_C Ip_BFu32i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu16s, Ip_BFu32i_BFu16s)
//============================================================================


struct  Ip_BFu32i_BFu17i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu32i_BFu17i) C1{ Fp Fi:32 Fi:17}



static void Test_Ip_BFu32i_BFu17i()
{
  {
    init_simple_test("Ip_BFu32i_BFu17i");
    static STRUCT_IF_C Ip_BFu32i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu17i, Ip_BFu32i_BFu17i)
//============================================================================


struct  Ip_BFu32i_BFu17ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu32i_BFu17ll) C1{ Fp Fi:32 FL:17}



static void Test_Ip_BFu32i_BFu17ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu17ll");
    static STRUCT_IF_C Ip_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu17ll, Ip_BFu32i_BFu17ll)
//============================================================================


struct  Ip_BFu32i_BFu1c  {
  int *v1;
  unsigned int v2:32;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu32i_BFu1c) C1{ Fp Fi:32 Fc:1}



static void Test_Ip_BFu32i_BFu1c()
{
  {
    init_simple_test("Ip_BFu32i_BFu1c");
    static STRUCT_IF_C Ip_BFu32i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu1c, Ip_BFu32i_BFu1c)
//============================================================================


struct  Ip_BFu32i_BFu1i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu32i_BFu1i) C1{ Fp Fi:32 Fi:1}



static void Test_Ip_BFu32i_BFu1i()
{
  {
    init_simple_test("Ip_BFu32i_BFu1i");
    static STRUCT_IF_C Ip_BFu32i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu1i, Ip_BFu32i_BFu1i)
//============================================================================


struct  Ip_BFu32i_BFu1ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu32i_BFu1ll) C1{ Fp Fi:32 FL:1}



static void Test_Ip_BFu32i_BFu1ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu1ll");
    static STRUCT_IF_C Ip_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu1ll, Ip_BFu32i_BFu1ll)
//============================================================================


struct  Ip_BFu32i_BFu1s  {
  int *v1;
  unsigned int v2:32;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu32i_BFu1s) C1{ Fp Fi:32 Fs:1}



static void Test_Ip_BFu32i_BFu1s()
{
  {
    init_simple_test("Ip_BFu32i_BFu1s");
    static STRUCT_IF_C Ip_BFu32i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu1s, Ip_BFu32i_BFu1s)
//============================================================================


struct  Ip_BFu32i_BFu31i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu32i_BFu31i) C1{ Fp Fi:32 Fi:31}



static void Test_Ip_BFu32i_BFu31i()
{
  {
    init_simple_test("Ip_BFu32i_BFu31i");
    static STRUCT_IF_C Ip_BFu32i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu31i, Ip_BFu32i_BFu31i)
//============================================================================


struct  Ip_BFu32i_BFu31ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu32i_BFu31ll) C1{ Fp Fi:32 FL:31}



static void Test_Ip_BFu32i_BFu31ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu31ll");
    static STRUCT_IF_C Ip_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu31ll, Ip_BFu32i_BFu31ll)
//============================================================================


struct  Ip_BFu32i_BFu32i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu32i_BFu32i) C1{ Fp Fi:32 Fi:32}



static void Test_Ip_BFu32i_BFu32i()
{
  {
    init_simple_test("Ip_BFu32i_BFu32i");
    static STRUCT_IF_C Ip_BFu32i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu32i, Ip_BFu32i_BFu32i)
//============================================================================


struct  Ip_BFu32i_BFu32ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu32i_BFu32ll) C1{ Fp Fi:32 FL:32}



static void Test_Ip_BFu32i_BFu32ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu32ll");
    static STRUCT_IF_C Ip_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu32ll, Ip_BFu32i_BFu32ll)
//============================================================================


struct  Ip_BFu32i_BFu33  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu32i_BFu33) C1{ Fp Fi:32 FL:33}



static void Test_Ip_BFu32i_BFu33()
{
  {
    init_simple_test("Ip_BFu32i_BFu33");
    static STRUCT_IF_C Ip_BFu32i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "Ip_BFu32i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "Ip_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu33, Ip_BFu32i_BFu33)
//============================================================================


struct  Ip_BFu32i_BFu7c  {
  int *v1;
  unsigned int v2:32;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu32i_BFu7c) C1{ Fp Fi:32 Fc:7}



static void Test_Ip_BFu32i_BFu7c()
{
  {
    init_simple_test("Ip_BFu32i_BFu7c");
    static STRUCT_IF_C Ip_BFu32i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu7c, Ip_BFu32i_BFu7c)
//============================================================================


struct  Ip_BFu32i_BFu7i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu32i_BFu7i) C1{ Fp Fi:32 Fi:7}



static void Test_Ip_BFu32i_BFu7i()
{
  {
    init_simple_test("Ip_BFu32i_BFu7i");
    static STRUCT_IF_C Ip_BFu32i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu7i, Ip_BFu32i_BFu7i)
//============================================================================


struct  Ip_BFu32i_BFu7ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu32i_BFu7ll) C1{ Fp Fi:32 FL:7}



static void Test_Ip_BFu32i_BFu7ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu7ll");
    static STRUCT_IF_C Ip_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu7ll, Ip_BFu32i_BFu7ll)
//============================================================================


struct  Ip_BFu32i_BFu7s  {
  int *v1;
  unsigned int v2:32;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu32i_BFu7s) C1{ Fp Fi:32 Fs:7}



static void Test_Ip_BFu32i_BFu7s()
{
  {
    init_simple_test("Ip_BFu32i_BFu7s");
    static STRUCT_IF_C Ip_BFu32i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu7s, Ip_BFu32i_BFu7s)
//============================================================================


struct  Ip_BFu32i_BFu8c  {
  int *v1;
  unsigned int v2:32;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu32i_BFu8c) C1{ Fp Fi:32 Fc:8}



static void Test_Ip_BFu32i_BFu8c()
{
  {
    init_simple_test("Ip_BFu32i_BFu8c");
    static STRUCT_IF_C Ip_BFu32i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu8c, Ip_BFu32i_BFu8c)
//============================================================================


struct  Ip_BFu32i_BFu8i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu32i_BFu8i) C1{ Fp Fi:32 Fi:8}



static void Test_Ip_BFu32i_BFu8i()
{
  {
    init_simple_test("Ip_BFu32i_BFu8i");
    static STRUCT_IF_C Ip_BFu32i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu8i, Ip_BFu32i_BFu8i)
//============================================================================


struct  Ip_BFu32i_BFu8ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu32i_BFu8ll) C1{ Fp Fi:32 FL:8}



static void Test_Ip_BFu32i_BFu8ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu8ll");
    static STRUCT_IF_C Ip_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu8ll, Ip_BFu32i_BFu8ll)
//============================================================================


struct  Ip_BFu32i_BFu8s  {
  int *v1;
  unsigned int v2:32;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu32i_BFu8s) C1{ Fp Fi:32 Fs:8}



static void Test_Ip_BFu32i_BFu8s()
{
  {
    init_simple_test("Ip_BFu32i_BFu8s");
    static STRUCT_IF_C Ip_BFu32i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu8s, Ip_BFu32i_BFu8s)
//============================================================================


struct  Ip_BFu32i_BFu9i  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu32i_BFu9i) C1{ Fp Fi:32 Fi:9}



static void Test_Ip_BFu32i_BFu9i()
{
  {
    init_simple_test("Ip_BFu32i_BFu9i");
    static STRUCT_IF_C Ip_BFu32i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu9i, Ip_BFu32i_BFu9i)
//============================================================================


struct  Ip_BFu32i_BFu9ll  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu32i_BFu9ll) C1{ Fp Fi:32 FL:9}



static void Test_Ip_BFu32i_BFu9ll()
{
  {
    init_simple_test("Ip_BFu32i_BFu9ll");
    static STRUCT_IF_C Ip_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu9ll, Ip_BFu32i_BFu9ll)
//============================================================================


struct  Ip_BFu32i_BFu9s  {
  int *v1;
  unsigned int v2:32;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu32i_BFu9s) C1{ Fp Fi:32 Fs:9}



static void Test_Ip_BFu32i_BFu9s()
{
  {
    init_simple_test("Ip_BFu32i_BFu9s");
    static STRUCT_IF_C Ip_BFu32i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_BFu9s, Ip_BFu32i_BFu9s)
//============================================================================


struct  Ip_BFu32i_C  {
  int *v1;
  unsigned int v2:32;
  char v3;
};
//SIG(1 Ip_BFu32i_C) C1{ Fp Fi:32 Fc}



static void Test_Ip_BFu32i_C()
{
  {
    init_simple_test("Ip_BFu32i_C");
    static STRUCT_IF_C Ip_BFu32i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_C, Ip_BFu32i_C)
//============================================================================


struct  Ip_BFu32i_D  {
  int *v1;
  unsigned int v2:32;
  double v3;
};
//SIG(1 Ip_BFu32i_D) C1{ Fp Fi:32 FL}



static void Test_Ip_BFu32i_D()
{
  {
    init_simple_test("Ip_BFu32i_D");
    static STRUCT_IF_C Ip_BFu32i_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_D, Ip_BFu32i_D)
//============================================================================


struct  Ip_BFu32i_F  {
  int *v1;
  unsigned int v2:32;
  float v3;
};
//SIG(1 Ip_BFu32i_F) C1{ Fp Fi:32 Fi}



static void Test_Ip_BFu32i_F()
{
  {
    init_simple_test("Ip_BFu32i_F");
    static STRUCT_IF_C Ip_BFu32i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_F, Ip_BFu32i_F)
//============================================================================


struct  Ip_BFu32i_I  {
  int *v1;
  unsigned int v2:32;
  int v3;
};
//SIG(1 Ip_BFu32i_I) C1{ Fp Fi:32 Fi}



static void Test_Ip_BFu32i_I()
{
  {
    init_simple_test("Ip_BFu32i_I");
    static STRUCT_IF_C Ip_BFu32i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_I, Ip_BFu32i_I)
//============================================================================


struct  Ip_BFu32i_Ip  {
  int *v1;
  unsigned int v2:32;
  int *v3;
};
//SIG(1 Ip_BFu32i_Ip) C1{ Fp Fi:32 Fp}



static void Test_Ip_BFu32i_Ip()
{
  {
    init_simple_test("Ip_BFu32i_Ip");
    static STRUCT_IF_C Ip_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_Ip, Ip_BFu32i_Ip)
//============================================================================


struct  Ip_BFu32i_L  {
  int *v1;
  unsigned int v2:32;
  __tsi64 v3;
};
//SIG(1 Ip_BFu32i_L) C1{ Fp Fi:32 FL}



static void Test_Ip_BFu32i_L()
{
  {
    init_simple_test("Ip_BFu32i_L");
    static STRUCT_IF_C Ip_BFu32i_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_L, Ip_BFu32i_L)
//============================================================================


struct  Ip_BFu32i_S  {
  int *v1;
  unsigned int v2:32;
  short v3;
};
//SIG(1 Ip_BFu32i_S) C1{ Fp Fi:32 Fs}



static void Test_Ip_BFu32i_S()
{
  {
    init_simple_test("Ip_BFu32i_S");
    static STRUCT_IF_C Ip_BFu32i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_S, Ip_BFu32i_S)
//============================================================================


struct  Ip_BFu32i_Uc  {
  int *v1;
  unsigned int v2:32;
  unsigned char v3;
};
//SIG(1 Ip_BFu32i_Uc) C1{ Fp Fi:32 Fc}



static void Test_Ip_BFu32i_Uc()
{
  {
    init_simple_test("Ip_BFu32i_Uc");
    static STRUCT_IF_C Ip_BFu32i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_Uc, Ip_BFu32i_Uc)
//============================================================================


struct  Ip_BFu32i_Ui  {
  int *v1;
  unsigned int v2:32;
  unsigned int v3;
};
//SIG(1 Ip_BFu32i_Ui) C1{ Fp Fi:32 Fi}



static void Test_Ip_BFu32i_Ui()
{
  {
    init_simple_test("Ip_BFu32i_Ui");
    static STRUCT_IF_C Ip_BFu32i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_Ui, Ip_BFu32i_Ui)
//============================================================================


struct  Ip_BFu32i_Ul  {
  int *v1;
  unsigned int v2:32;
  __tsu64 v3;
};
//SIG(1 Ip_BFu32i_Ul) C1{ Fp Fi:32 FL}



static void Test_Ip_BFu32i_Ul()
{
  {
    init_simple_test("Ip_BFu32i_Ul");
    static STRUCT_IF_C Ip_BFu32i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_Ul, Ip_BFu32i_Ul)
//============================================================================


struct  Ip_BFu32i_Us  {
  int *v1;
  unsigned int v2:32;
  unsigned short v3;
};
//SIG(1 Ip_BFu32i_Us) C1{ Fp Fi:32 Fs}



static void Test_Ip_BFu32i_Us()
{
  {
    init_simple_test("Ip_BFu32i_Us");
    static STRUCT_IF_C Ip_BFu32i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_Us, Ip_BFu32i_Us)
//============================================================================


struct  Ip_BFu32i_Vp  {
  int *v1;
  unsigned int v2:32;
  void *v3;
};
//SIG(1 Ip_BFu32i_Vp) C1{ Fp Fi:32 Fp}



static void Test_Ip_BFu32i_Vp()
{
  {
    init_simple_test("Ip_BFu32i_Vp");
    static STRUCT_IF_C Ip_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32i_Vp, Ip_BFu32i_Vp)
//============================================================================


struct  Ip_BFu32ll  {
  int *v1;
  __tsu64 v2:32;
};
//SIG(1 Ip_BFu32ll) C1{ Fp FL:32}



static void Test_Ip_BFu32ll()
{
  {
    init_simple_test("Ip_BFu32ll");
    static STRUCT_IF_C Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll, Ip_BFu32ll)
//============================================================================


struct  Ip_BFu32ll_BFu15i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu32ll_BFu15i) C1{ Fp FL:32 Fi:15}



static void Test_Ip_BFu32ll_BFu15i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu15i");
    static STRUCT_IF_C Ip_BFu32ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu15i, Ip_BFu32ll_BFu15i)
//============================================================================


struct  Ip_BFu32ll_BFu15ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu32ll_BFu15ll) C1{ Fp FL:32 FL:15}



static void Test_Ip_BFu32ll_BFu15ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu15ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu15ll, Ip_BFu32ll_BFu15ll)
//============================================================================


struct  Ip_BFu32ll_BFu15s  {
  int *v1;
  __tsu64 v2:32;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu32ll_BFu15s) C1{ Fp FL:32 Fs:15}



static void Test_Ip_BFu32ll_BFu15s()
{
  {
    init_simple_test("Ip_BFu32ll_BFu15s");
    static STRUCT_IF_C Ip_BFu32ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu15s, Ip_BFu32ll_BFu15s)
//============================================================================


struct  Ip_BFu32ll_BFu16i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu32ll_BFu16i) C1{ Fp FL:32 Fi:16}



static void Test_Ip_BFu32ll_BFu16i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu16i");
    static STRUCT_IF_C Ip_BFu32ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu16i, Ip_BFu32ll_BFu16i)
//============================================================================


struct  Ip_BFu32ll_BFu16ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu32ll_BFu16ll) C1{ Fp FL:32 FL:16}



static void Test_Ip_BFu32ll_BFu16ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu16ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu16ll, Ip_BFu32ll_BFu16ll)
//============================================================================


struct  Ip_BFu32ll_BFu16s  {
  int *v1;
  __tsu64 v2:32;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu32ll_BFu16s) C1{ Fp FL:32 Fs:16}



static void Test_Ip_BFu32ll_BFu16s()
{
  {
    init_simple_test("Ip_BFu32ll_BFu16s");
    static STRUCT_IF_C Ip_BFu32ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu16s, Ip_BFu32ll_BFu16s)
//============================================================================


struct  Ip_BFu32ll_BFu17i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu32ll_BFu17i) C1{ Fp FL:32 Fi:17}



static void Test_Ip_BFu32ll_BFu17i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu17i");
    static STRUCT_IF_C Ip_BFu32ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu17i, Ip_BFu32ll_BFu17i)
//============================================================================


struct  Ip_BFu32ll_BFu17ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu32ll_BFu17ll) C1{ Fp FL:32 FL:17}



static void Test_Ip_BFu32ll_BFu17ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu17ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu17ll, Ip_BFu32ll_BFu17ll)
//============================================================================


struct  Ip_BFu32ll_BFu1c  {
  int *v1;
  __tsu64 v2:32;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu32ll_BFu1c) C1{ Fp FL:32 Fc:1}



static void Test_Ip_BFu32ll_BFu1c()
{
  {
    init_simple_test("Ip_BFu32ll_BFu1c");
    static STRUCT_IF_C Ip_BFu32ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu1c, Ip_BFu32ll_BFu1c)
//============================================================================


struct  Ip_BFu32ll_BFu1i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu32ll_BFu1i) C1{ Fp FL:32 Fi:1}



static void Test_Ip_BFu32ll_BFu1i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu1i");
    static STRUCT_IF_C Ip_BFu32ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu1i, Ip_BFu32ll_BFu1i)
//============================================================================


struct  Ip_BFu32ll_BFu1ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu32ll_BFu1ll) C1{ Fp FL:32 FL:1}



static void Test_Ip_BFu32ll_BFu1ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu1ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu1ll, Ip_BFu32ll_BFu1ll)
//============================================================================


struct  Ip_BFu32ll_BFu1s  {
  int *v1;
  __tsu64 v2:32;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu32ll_BFu1s) C1{ Fp FL:32 Fs:1}



static void Test_Ip_BFu32ll_BFu1s()
{
  {
    init_simple_test("Ip_BFu32ll_BFu1s");
    static STRUCT_IF_C Ip_BFu32ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu1s, Ip_BFu32ll_BFu1s)
//============================================================================


struct  Ip_BFu32ll_BFu31i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu32ll_BFu31i) C1{ Fp FL:32 Fi:31}



static void Test_Ip_BFu32ll_BFu31i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu31i");
    static STRUCT_IF_C Ip_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu31i, Ip_BFu32ll_BFu31i)
//============================================================================


struct  Ip_BFu32ll_BFu31ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu32ll_BFu31ll) C1{ Fp FL:32 FL:31}



static void Test_Ip_BFu32ll_BFu31ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu31ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu31ll, Ip_BFu32ll_BFu31ll)
//============================================================================


struct  Ip_BFu32ll_BFu32i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu32ll_BFu32i) C1{ Fp FL:32 Fi:32}



static void Test_Ip_BFu32ll_BFu32i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu32i");
    static STRUCT_IF_C Ip_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu32i, Ip_BFu32ll_BFu32i)
//============================================================================


struct  Ip_BFu32ll_BFu32ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu32ll_BFu32ll) C1{ Fp FL:32 FL:32}



static void Test_Ip_BFu32ll_BFu32ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu32ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu32ll, Ip_BFu32ll_BFu32ll)
//============================================================================


struct  Ip_BFu32ll_BFu33  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu32ll_BFu33) C1{ Fp FL:32 FL:33}



static void Test_Ip_BFu32ll_BFu33()
{
  {
    init_simple_test("Ip_BFu32ll_BFu33");
    static STRUCT_IF_C Ip_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "Ip_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "Ip_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu33, Ip_BFu32ll_BFu33)
//============================================================================


struct  Ip_BFu32ll_BFu7c  {
  int *v1;
  __tsu64 v2:32;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu32ll_BFu7c) C1{ Fp FL:32 Fc:7}



static void Test_Ip_BFu32ll_BFu7c()
{
  {
    init_simple_test("Ip_BFu32ll_BFu7c");
    static STRUCT_IF_C Ip_BFu32ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu7c, Ip_BFu32ll_BFu7c)
//============================================================================


struct  Ip_BFu32ll_BFu7i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu32ll_BFu7i) C1{ Fp FL:32 Fi:7}



static void Test_Ip_BFu32ll_BFu7i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu7i");
    static STRUCT_IF_C Ip_BFu32ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu7i, Ip_BFu32ll_BFu7i)
//============================================================================


struct  Ip_BFu32ll_BFu7ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu32ll_BFu7ll) C1{ Fp FL:32 FL:7}



static void Test_Ip_BFu32ll_BFu7ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu7ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu7ll, Ip_BFu32ll_BFu7ll)
//============================================================================


struct  Ip_BFu32ll_BFu7s  {
  int *v1;
  __tsu64 v2:32;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu32ll_BFu7s) C1{ Fp FL:32 Fs:7}



static void Test_Ip_BFu32ll_BFu7s()
{
  {
    init_simple_test("Ip_BFu32ll_BFu7s");
    static STRUCT_IF_C Ip_BFu32ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu7s, Ip_BFu32ll_BFu7s)
//============================================================================


struct  Ip_BFu32ll_BFu8c  {
  int *v1;
  __tsu64 v2:32;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu32ll_BFu8c) C1{ Fp FL:32 Fc:8}



static void Test_Ip_BFu32ll_BFu8c()
{
  {
    init_simple_test("Ip_BFu32ll_BFu8c");
    static STRUCT_IF_C Ip_BFu32ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu8c, Ip_BFu32ll_BFu8c)
//============================================================================


struct  Ip_BFu32ll_BFu8i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu32ll_BFu8i) C1{ Fp FL:32 Fi:8}



static void Test_Ip_BFu32ll_BFu8i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu8i");
    static STRUCT_IF_C Ip_BFu32ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu8i, Ip_BFu32ll_BFu8i)
//============================================================================


struct  Ip_BFu32ll_BFu8ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu32ll_BFu8ll) C1{ Fp FL:32 FL:8}



static void Test_Ip_BFu32ll_BFu8ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu8ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu8ll, Ip_BFu32ll_BFu8ll)
//============================================================================


struct  Ip_BFu32ll_BFu8s  {
  int *v1;
  __tsu64 v2:32;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu32ll_BFu8s) C1{ Fp FL:32 Fs:8}



static void Test_Ip_BFu32ll_BFu8s()
{
  {
    init_simple_test("Ip_BFu32ll_BFu8s");
    static STRUCT_IF_C Ip_BFu32ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu8s, Ip_BFu32ll_BFu8s)
//============================================================================


struct  Ip_BFu32ll_BFu9i  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu32ll_BFu9i) C1{ Fp FL:32 Fi:9}



static void Test_Ip_BFu32ll_BFu9i()
{
  {
    init_simple_test("Ip_BFu32ll_BFu9i");
    static STRUCT_IF_C Ip_BFu32ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu9i, Ip_BFu32ll_BFu9i)
//============================================================================


struct  Ip_BFu32ll_BFu9ll  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu32ll_BFu9ll) C1{ Fp FL:32 FL:9}



static void Test_Ip_BFu32ll_BFu9ll()
{
  {
    init_simple_test("Ip_BFu32ll_BFu9ll");
    static STRUCT_IF_C Ip_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu9ll, Ip_BFu32ll_BFu9ll)
//============================================================================


struct  Ip_BFu32ll_BFu9s  {
  int *v1;
  __tsu64 v2:32;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu32ll_BFu9s) C1{ Fp FL:32 Fs:9}



static void Test_Ip_BFu32ll_BFu9s()
{
  {
    init_simple_test("Ip_BFu32ll_BFu9s");
    static STRUCT_IF_C Ip_BFu32ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_BFu9s, Ip_BFu32ll_BFu9s)
//============================================================================


struct  Ip_BFu32ll_C  {
  int *v1;
  __tsu64 v2:32;
  char v3;
};
//SIG(1 Ip_BFu32ll_C) C1{ Fp FL:32 Fc}



static void Test_Ip_BFu32ll_C()
{
  {
    init_simple_test("Ip_BFu32ll_C");
    static STRUCT_IF_C Ip_BFu32ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_C, Ip_BFu32ll_C)
//============================================================================


struct  Ip_BFu32ll_D  {
  int *v1;
  __tsu64 v2:32;
  double v3;
};
//SIG(1 Ip_BFu32ll_D) C1{ Fp FL:32 FL}



static void Test_Ip_BFu32ll_D()
{
  {
    init_simple_test("Ip_BFu32ll_D");
    static STRUCT_IF_C Ip_BFu32ll_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_D, Ip_BFu32ll_D)
//============================================================================


struct  Ip_BFu32ll_F  {
  int *v1;
  __tsu64 v2:32;
  float v3;
};
//SIG(1 Ip_BFu32ll_F) C1{ Fp FL:32 Fi}



static void Test_Ip_BFu32ll_F()
{
  {
    init_simple_test("Ip_BFu32ll_F");
    static STRUCT_IF_C Ip_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_F, Ip_BFu32ll_F)
//============================================================================


struct  Ip_BFu32ll_I  {
  int *v1;
  __tsu64 v2:32;
  int v3;
};
//SIG(1 Ip_BFu32ll_I) C1{ Fp FL:32 Fi}



static void Test_Ip_BFu32ll_I()
{
  {
    init_simple_test("Ip_BFu32ll_I");
    static STRUCT_IF_C Ip_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_I, Ip_BFu32ll_I)
//============================================================================


struct  Ip_BFu32ll_Ip  {
  int *v1;
  __tsu64 v2:32;
  int *v3;
};
//SIG(1 Ip_BFu32ll_Ip) C1{ Fp FL:32 Fp}



static void Test_Ip_BFu32ll_Ip()
{
  {
    init_simple_test("Ip_BFu32ll_Ip");
    static STRUCT_IF_C Ip_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_Ip, Ip_BFu32ll_Ip)
//============================================================================


struct  Ip_BFu32ll_L  {
  int *v1;
  __tsu64 v2:32;
  __tsi64 v3;
};
//SIG(1 Ip_BFu32ll_L) C1{ Fp FL:32 FL}



static void Test_Ip_BFu32ll_L()
{
  {
    init_simple_test("Ip_BFu32ll_L");
    static STRUCT_IF_C Ip_BFu32ll_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_L, Ip_BFu32ll_L)
//============================================================================


struct  Ip_BFu32ll_S  {
  int *v1;
  __tsu64 v2:32;
  short v3;
};
//SIG(1 Ip_BFu32ll_S) C1{ Fp FL:32 Fs}



static void Test_Ip_BFu32ll_S()
{
  {
    init_simple_test("Ip_BFu32ll_S");
    static STRUCT_IF_C Ip_BFu32ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_S, Ip_BFu32ll_S)
//============================================================================


struct  Ip_BFu32ll_Uc  {
  int *v1;
  __tsu64 v2:32;
  unsigned char v3;
};
//SIG(1 Ip_BFu32ll_Uc) C1{ Fp FL:32 Fc}



static void Test_Ip_BFu32ll_Uc()
{
  {
    init_simple_test("Ip_BFu32ll_Uc");
    static STRUCT_IF_C Ip_BFu32ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_Uc, Ip_BFu32ll_Uc)
//============================================================================


struct  Ip_BFu32ll_Ui  {
  int *v1;
  __tsu64 v2:32;
  unsigned int v3;
};
//SIG(1 Ip_BFu32ll_Ui) C1{ Fp FL:32 Fi}



static void Test_Ip_BFu32ll_Ui()
{
  {
    init_simple_test("Ip_BFu32ll_Ui");
    static STRUCT_IF_C Ip_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_Ui, Ip_BFu32ll_Ui)
//============================================================================


struct  Ip_BFu32ll_Ul  {
  int *v1;
  __tsu64 v2:32;
  __tsu64 v3;
};
//SIG(1 Ip_BFu32ll_Ul) C1{ Fp FL:32 FL}



static void Test_Ip_BFu32ll_Ul()
{
  {
    init_simple_test("Ip_BFu32ll_Ul");
    static STRUCT_IF_C Ip_BFu32ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_Ul, Ip_BFu32ll_Ul)
//============================================================================


struct  Ip_BFu32ll_Us  {
  int *v1;
  __tsu64 v2:32;
  unsigned short v3;
};
//SIG(1 Ip_BFu32ll_Us) C1{ Fp FL:32 Fs}



static void Test_Ip_BFu32ll_Us()
{
  {
    init_simple_test("Ip_BFu32ll_Us");
    static STRUCT_IF_C Ip_BFu32ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_Us, Ip_BFu32ll_Us)
//============================================================================


struct  Ip_BFu32ll_Vp  {
  int *v1;
  __tsu64 v2:32;
  void *v3;
};
//SIG(1 Ip_BFu32ll_Vp) C1{ Fp FL:32 Fp}



static void Test_Ip_BFu32ll_Vp()
{
  {
    init_simple_test("Ip_BFu32ll_Vp");
    static STRUCT_IF_C Ip_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ip_BFu32ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ip_BFu32ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu32ll_Vp, Ip_BFu32ll_Vp)
//============================================================================


struct  Ip_BFu33  {
  int *v1;
  __tsu64 v2:33;
};
//SIG(1 Ip_BFu33) C1{ Fp FL:33}



static void Test_Ip_BFu33()
{
  {
    init_simple_test("Ip_BFu33");
    static STRUCT_IF_C Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33, Ip_BFu33)
//============================================================================


struct  Ip_BFu33_BFu15i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu33_BFu15i) C1{ Fp FL:33 Fi:15}



static void Test_Ip_BFu33_BFu15i()
{
  {
    init_simple_test("Ip_BFu33_BFu15i");
    static STRUCT_IF_C Ip_BFu33_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Ip_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Ip_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu15i, Ip_BFu33_BFu15i)
//============================================================================


struct  Ip_BFu33_BFu15ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu33_BFu15ll) C1{ Fp FL:33 FL:15}



static void Test_Ip_BFu33_BFu15ll()
{
  {
    init_simple_test("Ip_BFu33_BFu15ll");
    static STRUCT_IF_C Ip_BFu33_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Ip_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Ip_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu15ll, Ip_BFu33_BFu15ll)
//============================================================================


struct  Ip_BFu33_BFu15s  {
  int *v1;
  __tsu64 v2:33;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu33_BFu15s) C1{ Fp FL:33 Fs:15}



static void Test_Ip_BFu33_BFu15s()
{
  {
    init_simple_test("Ip_BFu33_BFu15s");
    static STRUCT_IF_C Ip_BFu33_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Ip_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Ip_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu15s, Ip_BFu33_BFu15s)
//============================================================================


struct  Ip_BFu33_BFu16i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu33_BFu16i) C1{ Fp FL:33 Fi:16}



static void Test_Ip_BFu33_BFu16i()
{
  {
    init_simple_test("Ip_BFu33_BFu16i");
    static STRUCT_IF_C Ip_BFu33_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "Ip_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "Ip_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu16i, Ip_BFu33_BFu16i)
//============================================================================


struct  Ip_BFu33_BFu16ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu33_BFu16ll) C1{ Fp FL:33 FL:16}



static void Test_Ip_BFu33_BFu16ll()
{
  {
    init_simple_test("Ip_BFu33_BFu16ll");
    static STRUCT_IF_C Ip_BFu33_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "Ip_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "Ip_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu16ll, Ip_BFu33_BFu16ll)
//============================================================================


struct  Ip_BFu33_BFu16s  {
  int *v1;
  __tsu64 v2:33;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu33_BFu16s) C1{ Fp FL:33 Fs:16}



static void Test_Ip_BFu33_BFu16s()
{
  {
    init_simple_test("Ip_BFu33_BFu16s");
    static STRUCT_IF_C Ip_BFu33_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(14,10), 0, 16, 1, "Ip_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(14,10), 0, 16, hide_ull(1LL<<15), "Ip_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu16s, Ip_BFu33_BFu16s)
//============================================================================


struct  Ip_BFu33_BFu17i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu33_BFu17i) C1{ Fp FL:33 Fi:17}



static void Test_Ip_BFu33_BFu17i()
{
  {
    init_simple_test("Ip_BFu33_BFu17i");
    static STRUCT_IF_C Ip_BFu33_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "Ip_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "Ip_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu17i, Ip_BFu33_BFu17i)
//============================================================================


struct  Ip_BFu33_BFu17ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu33_BFu17ll) C1{ Fp FL:33 FL:17}



static void Test_Ip_BFu33_BFu17ll()
{
  {
    init_simple_test("Ip_BFu33_BFu17ll");
    static STRUCT_IF_C Ip_BFu33_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "Ip_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "Ip_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu17ll, Ip_BFu33_BFu17ll)
//============================================================================


struct  Ip_BFu33_BFu1c  {
  int *v1;
  __tsu64 v2:33;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu33_BFu1c) C1{ Fp FL:33 Fc:1}



static void Test_Ip_BFu33_BFu1c()
{
  {
    init_simple_test("Ip_BFu33_BFu1c");
    static STRUCT_IF_C Ip_BFu33_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Ip_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu1c, Ip_BFu33_BFu1c)
//============================================================================


struct  Ip_BFu33_BFu1i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu33_BFu1i) C1{ Fp FL:33 Fi:1}



static void Test_Ip_BFu33_BFu1i()
{
  {
    init_simple_test("Ip_BFu33_BFu1i");
    static STRUCT_IF_C Ip_BFu33_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Ip_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu1i, Ip_BFu33_BFu1i)
//============================================================================


struct  Ip_BFu33_BFu1ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu33_BFu1ll) C1{ Fp FL:33 FL:1}



static void Test_Ip_BFu33_BFu1ll()
{
  {
    init_simple_test("Ip_BFu33_BFu1ll");
    static STRUCT_IF_C Ip_BFu33_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Ip_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu1ll, Ip_BFu33_BFu1ll)
//============================================================================


struct  Ip_BFu33_BFu1s  {
  int *v1;
  __tsu64 v2:33;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu33_BFu1s) C1{ Fp FL:33 Fs:1}



static void Test_Ip_BFu33_BFu1s()
{
  {
    init_simple_test("Ip_BFu33_BFu1s");
    static STRUCT_IF_C Ip_BFu33_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Ip_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu1s, Ip_BFu33_BFu1s)
//============================================================================


struct  Ip_BFu33_BFu31i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu33_BFu31i) C1{ Fp FL:33 Fi:31}



static void Test_Ip_BFu33_BFu31i()
{
  {
    init_simple_test("Ip_BFu33_BFu31i");
    static STRUCT_IF_C Ip_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "Ip_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "Ip_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu31i, Ip_BFu33_BFu31i)
//============================================================================


struct  Ip_BFu33_BFu31ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu33_BFu31ll) C1{ Fp FL:33 FL:31}



static void Test_Ip_BFu33_BFu31ll()
{
  {
    init_simple_test("Ip_BFu33_BFu31ll");
    static STRUCT_IF_C Ip_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "Ip_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "Ip_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu31ll, Ip_BFu33_BFu31ll)
//============================================================================


struct  Ip_BFu33_BFu32i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu33_BFu32i) C1{ Fp FL:33 Fi:32}



static void Test_Ip_BFu33_BFu32i()
{
  {
    init_simple_test("Ip_BFu33_BFu32i");
    static STRUCT_IF_C Ip_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Ip_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Ip_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu32i, Ip_BFu33_BFu32i)
//============================================================================


struct  Ip_BFu33_BFu32ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu33_BFu32ll) C1{ Fp FL:33 FL:32}



static void Test_Ip_BFu33_BFu32ll()
{
  {
    init_simple_test("Ip_BFu33_BFu32ll");
    static STRUCT_IF_C Ip_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 32, 1, "Ip_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Ip_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu32ll, Ip_BFu33_BFu32ll)
//============================================================================


struct  Ip_BFu33_BFu33  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu33_BFu33) C1{ Fp FL:33 FL:33}



static void Test_Ip_BFu33_BFu33()
{
  {
    init_simple_test("Ip_BFu33_BFu33");
    static STRUCT_IF_C Ip_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 33, 1, "Ip_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Ip_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu33, Ip_BFu33_BFu33)
//============================================================================


struct  Ip_BFu33_BFu7c  {
  int *v1;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu33_BFu7c) C1{ Fp FL:33 Fc:7}



static void Test_Ip_BFu33_BFu7c()
{
  {
    init_simple_test("Ip_BFu33_BFu7c");
    static STRUCT_IF_C Ip_BFu33_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Ip_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Ip_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu7c, Ip_BFu33_BFu7c)
//============================================================================


struct  Ip_BFu33_BFu7i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu33_BFu7i) C1{ Fp FL:33 Fi:7}



static void Test_Ip_BFu33_BFu7i()
{
  {
    init_simple_test("Ip_BFu33_BFu7i");
    static STRUCT_IF_C Ip_BFu33_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Ip_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Ip_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu7i, Ip_BFu33_BFu7i)
//============================================================================


struct  Ip_BFu33_BFu7ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu33_BFu7ll) C1{ Fp FL:33 FL:7}



static void Test_Ip_BFu33_BFu7ll()
{
  {
    init_simple_test("Ip_BFu33_BFu7ll");
    static STRUCT_IF_C Ip_BFu33_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Ip_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Ip_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu7ll, Ip_BFu33_BFu7ll)
//============================================================================


struct  Ip_BFu33_BFu7s  {
  int *v1;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu33_BFu7s) C1{ Fp FL:33 Fs:7}



static void Test_Ip_BFu33_BFu7s()
{
  {
    init_simple_test("Ip_BFu33_BFu7s");
    static STRUCT_IF_C Ip_BFu33_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Ip_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Ip_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu7s, Ip_BFu33_BFu7s)
//============================================================================


struct  Ip_BFu33_BFu8c  {
  int *v1;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu33_BFu8c) C1{ Fp FL:33 Fc:8}



static void Test_Ip_BFu33_BFu8c()
{
  {
    init_simple_test("Ip_BFu33_BFu8c");
    static STRUCT_IF_C Ip_BFu33_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(13,9), 0, 8, 1, "Ip_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(13,9), 0, 8, hide_ull(1LL<<7), "Ip_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu8c, Ip_BFu33_BFu8c)
//============================================================================


struct  Ip_BFu33_BFu8i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu33_BFu8i) C1{ Fp FL:33 Fi:8}



static void Test_Ip_BFu33_BFu8i()
{
  {
    init_simple_test("Ip_BFu33_BFu8i");
    static STRUCT_IF_C Ip_BFu33_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Ip_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Ip_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu8i, Ip_BFu33_BFu8i)
//============================================================================


struct  Ip_BFu33_BFu8ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu33_BFu8ll) C1{ Fp FL:33 FL:8}



static void Test_Ip_BFu33_BFu8ll()
{
  {
    init_simple_test("Ip_BFu33_BFu8ll");
    static STRUCT_IF_C Ip_BFu33_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Ip_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Ip_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu8ll, Ip_BFu33_BFu8ll)
//============================================================================


struct  Ip_BFu33_BFu8s  {
  int *v1;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu33_BFu8s) C1{ Fp FL:33 Fs:8}



static void Test_Ip_BFu33_BFu8s()
{
  {
    init_simple_test("Ip_BFu33_BFu8s");
    static STRUCT_IF_C Ip_BFu33_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Ip_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Ip_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu8s, Ip_BFu33_BFu8s)
//============================================================================


struct  Ip_BFu33_BFu9i  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu33_BFu9i) C1{ Fp FL:33 Fi:9}



static void Test_Ip_BFu33_BFu9i()
{
  {
    init_simple_test("Ip_BFu33_BFu9i");
    static STRUCT_IF_C Ip_BFu33_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Ip_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Ip_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu9i, Ip_BFu33_BFu9i)
//============================================================================


struct  Ip_BFu33_BFu9ll  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu33_BFu9ll) C1{ Fp FL:33 FL:9}



static void Test_Ip_BFu33_BFu9ll()
{
  {
    init_simple_test("Ip_BFu33_BFu9ll");
    static STRUCT_IF_C Ip_BFu33_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Ip_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Ip_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu9ll, Ip_BFu33_BFu9ll)
//============================================================================


struct  Ip_BFu33_BFu9s  {
  int *v1;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu33_BFu9s) C1{ Fp FL:33 Fs:9}



static void Test_Ip_BFu33_BFu9s()
{
  {
    init_simple_test("Ip_BFu33_BFu9s");
    static STRUCT_IF_C Ip_BFu33_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Ip_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Ip_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_BFu9s, Ip_BFu33_BFu9s)
//============================================================================


struct  Ip_BFu33_C  {
  int *v1;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 Ip_BFu33_C) C1{ Fp FL:33 Fc}



static void Test_Ip_BFu33_C()
{
  {
    init_simple_test("Ip_BFu33_C");
    static STRUCT_IF_C Ip_BFu33_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_C");
    check_field_offset(lv, v3, ABISELECT(13,9), "Ip_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_C, Ip_BFu33_C)
//============================================================================


struct  Ip_BFu33_D  {
  int *v1;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 Ip_BFu33_D) C1{ Fp FL:33 FL}



static void Test_Ip_BFu33_D()
{
  {
    init_simple_test("Ip_BFu33_D");
    static STRUCT_IF_C Ip_BFu33_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ip_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_D, Ip_BFu33_D)
//============================================================================


struct  Ip_BFu33_F  {
  int *v1;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 Ip_BFu33_F) C1{ Fp FL:33 Fi}



static void Test_Ip_BFu33_F()
{
  {
    init_simple_test("Ip_BFu33_F");
    static STRUCT_IF_C Ip_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_F");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_F, Ip_BFu33_F)
//============================================================================


struct  Ip_BFu33_I  {
  int *v1;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 Ip_BFu33_I) C1{ Fp FL:33 Fi}



static void Test_Ip_BFu33_I()
{
  {
    init_simple_test("Ip_BFu33_I");
    static STRUCT_IF_C Ip_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_I");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_I, Ip_BFu33_I)
//============================================================================


struct  Ip_BFu33_Ip  {
  int *v1;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 Ip_BFu33_Ip) C1{ Fp FL:33 Fp}



static void Test_Ip_BFu33_Ip()
{
  {
    init_simple_test("Ip_BFu33_Ip");
    static STRUCT_IF_C Ip_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_Ip, Ip_BFu33_Ip)
//============================================================================


struct  Ip_BFu33_L  {
  int *v1;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 Ip_BFu33_L) C1{ Fp FL:33 FL}



static void Test_Ip_BFu33_L()
{
  {
    init_simple_test("Ip_BFu33_L");
    static STRUCT_IF_C Ip_BFu33_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ip_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_L, Ip_BFu33_L)
//============================================================================


struct  Ip_BFu33_S  {
  int *v1;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 Ip_BFu33_S) C1{ Fp FL:33 Fs}



static void Test_Ip_BFu33_S()
{
  {
    init_simple_test("Ip_BFu33_S");
    static STRUCT_IF_C Ip_BFu33_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_S");
    check_field_offset(lv, v3, ABISELECT(14,10), "Ip_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_S, Ip_BFu33_S)
//============================================================================


struct  Ip_BFu33_Uc  {
  int *v1;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 Ip_BFu33_Uc) C1{ Fp FL:33 Fc}



static void Test_Ip_BFu33_Uc()
{
  {
    init_simple_test("Ip_BFu33_Uc");
    static STRUCT_IF_C Ip_BFu33_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_Uc");
    check_field_offset(lv, v3, ABISELECT(13,9), "Ip_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_Uc, Ip_BFu33_Uc)
//============================================================================


struct  Ip_BFu33_Ui  {
  int *v1;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 Ip_BFu33_Ui) C1{ Fp FL:33 Fi}



static void Test_Ip_BFu33_Ui()
{
  {
    init_simple_test("Ip_BFu33_Ui");
    static STRUCT_IF_C Ip_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_Ui");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_Ui, Ip_BFu33_Ui)
//============================================================================


struct  Ip_BFu33_Ul  {
  int *v1;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 Ip_BFu33_Ul) C1{ Fp FL:33 FL}



static void Test_Ip_BFu33_Ul()
{
  {
    init_simple_test("Ip_BFu33_Ul");
    static STRUCT_IF_C Ip_BFu33_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ip_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_Ul, Ip_BFu33_Ul)
//============================================================================


struct  Ip_BFu33_Us  {
  int *v1;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 Ip_BFu33_Us) C1{ Fp FL:33 Fs}



static void Test_Ip_BFu33_Us()
{
  {
    init_simple_test("Ip_BFu33_Us");
    static STRUCT_IF_C Ip_BFu33_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_Us");
    check_field_offset(lv, v3, ABISELECT(14,10), "Ip_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_Us, Ip_BFu33_Us)
//============================================================================


struct  Ip_BFu33_Vp  {
  int *v1;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 Ip_BFu33_Vp) C1{ Fp FL:33 Fp}



static void Test_Ip_BFu33_Vp()
{
  {
    init_simple_test("Ip_BFu33_Vp");
    static STRUCT_IF_C Ip_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ip_BFu33_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ip_BFu33_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu33_Vp, Ip_BFu33_Vp)
//============================================================================


struct  Ip_BFu7c  {
  int *v1;
  unsigned char v2:7;
};
//SIG(1 Ip_BFu7c) C1{ Fp Fc:7}



static void Test_Ip_BFu7c()
{
  {
    init_simple_test("Ip_BFu7c");
    static STRUCT_IF_C Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c, Ip_BFu7c)
//============================================================================


struct  Ip_BFu7c_BFu15i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu7c_BFu15i) C1{ Fp Fc:7 Fi:15}



static void Test_Ip_BFu7c_BFu15i()
{
  {
    init_simple_test("Ip_BFu7c_BFu15i");
    static STRUCT_IF_C Ip_BFu7c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Ip_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Ip_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu15i, Ip_BFu7c_BFu15i)
//============================================================================


struct  Ip_BFu7c_BFu15ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu7c_BFu15ll) C1{ Fp Fc:7 FL:15}



static void Test_Ip_BFu7c_BFu15ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu15ll");
    static STRUCT_IF_C Ip_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Ip_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Ip_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu15ll, Ip_BFu7c_BFu15ll)
//============================================================================


struct  Ip_BFu7c_BFu15s  {
  int *v1;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu7c_BFu15s) C1{ Fp Fc:7 Fs:15}



static void Test_Ip_BFu7c_BFu15s()
{
  {
    init_simple_test("Ip_BFu7c_BFu15s");
    static STRUCT_IF_C Ip_BFu7c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu15s, Ip_BFu7c_BFu15s)
//============================================================================


struct  Ip_BFu7c_BFu16i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu7c_BFu16i) C1{ Fp Fc:7 Fi:16}



static void Test_Ip_BFu7c_BFu16i()
{
  {
    init_simple_test("Ip_BFu7c_BFu16i");
    static STRUCT_IF_C Ip_BFu7c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Ip_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Ip_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu16i, Ip_BFu7c_BFu16i)
//============================================================================


struct  Ip_BFu7c_BFu16ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu7c_BFu16ll) C1{ Fp Fc:7 FL:16}



static void Test_Ip_BFu7c_BFu16ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu16ll");
    static STRUCT_IF_C Ip_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Ip_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Ip_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu16ll, Ip_BFu7c_BFu16ll)
//============================================================================


struct  Ip_BFu7c_BFu16s  {
  int *v1;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu7c_BFu16s) C1{ Fp Fc:7 Fs:16}



static void Test_Ip_BFu7c_BFu16s()
{
  {
    init_simple_test("Ip_BFu7c_BFu16s");
    static STRUCT_IF_C Ip_BFu7c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu16s, Ip_BFu7c_BFu16s)
//============================================================================


struct  Ip_BFu7c_BFu17i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu7c_BFu17i) C1{ Fp Fc:7 Fi:17}



static void Test_Ip_BFu7c_BFu17i()
{
  {
    init_simple_test("Ip_BFu7c_BFu17i");
    static STRUCT_IF_C Ip_BFu7c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Ip_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Ip_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu17i, Ip_BFu7c_BFu17i)
//============================================================================


struct  Ip_BFu7c_BFu17ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu7c_BFu17ll) C1{ Fp Fc:7 FL:17}



static void Test_Ip_BFu7c_BFu17ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu17ll");
    static STRUCT_IF_C Ip_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Ip_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Ip_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu17ll, Ip_BFu7c_BFu17ll)
//============================================================================


struct  Ip_BFu7c_BFu1c  {
  int *v1;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu7c_BFu1c) C1{ Fp Fc:7 Fc:1}



static void Test_Ip_BFu7c_BFu1c()
{
  {
    init_simple_test("Ip_BFu7c_BFu1c");
    static STRUCT_IF_C Ip_BFu7c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu1c, Ip_BFu7c_BFu1c)
//============================================================================


struct  Ip_BFu7c_BFu1i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu7c_BFu1i) C1{ Fp Fc:7 Fi:1}



static void Test_Ip_BFu7c_BFu1i()
{
  {
    init_simple_test("Ip_BFu7c_BFu1i");
    static STRUCT_IF_C Ip_BFu7c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu1i, Ip_BFu7c_BFu1i)
//============================================================================


struct  Ip_BFu7c_BFu1ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu7c_BFu1ll) C1{ Fp Fc:7 FL:1}



static void Test_Ip_BFu7c_BFu1ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu1ll");
    static STRUCT_IF_C Ip_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu1ll, Ip_BFu7c_BFu1ll)
//============================================================================


struct  Ip_BFu7c_BFu1s  {
  int *v1;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu7c_BFu1s) C1{ Fp Fc:7 Fs:1}



static void Test_Ip_BFu7c_BFu1s()
{
  {
    init_simple_test("Ip_BFu7c_BFu1s");
    static STRUCT_IF_C Ip_BFu7c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu1s, Ip_BFu7c_BFu1s)
//============================================================================


struct  Ip_BFu7c_BFu31i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu7c_BFu31i) C1{ Fp Fc:7 Fi:31}



static void Test_Ip_BFu7c_BFu31i()
{
  {
    init_simple_test("Ip_BFu7c_BFu31i");
    static STRUCT_IF_C Ip_BFu7c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu31i, Ip_BFu7c_BFu31i)
//============================================================================


struct  Ip_BFu7c_BFu31ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu7c_BFu31ll) C1{ Fp Fc:7 FL:31}



static void Test_Ip_BFu7c_BFu31ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu31ll");
    static STRUCT_IF_C Ip_BFu7c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 31, 1, "Ip_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 31, hide_ull(1LL<<30), "Ip_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu31ll, Ip_BFu7c_BFu31ll)
//============================================================================


struct  Ip_BFu7c_BFu32i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu7c_BFu32i) C1{ Fp Fc:7 Fi:32}



static void Test_Ip_BFu7c_BFu32i()
{
  {
    init_simple_test("Ip_BFu7c_BFu32i");
    static STRUCT_IF_C Ip_BFu7c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu32i, Ip_BFu7c_BFu32i)
//============================================================================


struct  Ip_BFu7c_BFu32ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu7c_BFu32ll) C1{ Fp Fc:7 FL:32}



static void Test_Ip_BFu7c_BFu32ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu32ll");
    static STRUCT_IF_C Ip_BFu7c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 32, 1, "Ip_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 32, hide_ull(1LL<<31), "Ip_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu32ll, Ip_BFu7c_BFu32ll)
//============================================================================


struct  Ip_BFu7c_BFu33  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu7c_BFu33) C1{ Fp Fc:7 FL:33}



static void Test_Ip_BFu7c_BFu33()
{
  {
    init_simple_test("Ip_BFu7c_BFu33");
    static STRUCT_IF_C Ip_BFu7c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 33, 1, "Ip_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 33, hide_ull(1LL<<32), "Ip_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu33, Ip_BFu7c_BFu33)
//============================================================================


struct  Ip_BFu7c_BFu7c  {
  int *v1;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu7c_BFu7c) C1{ Fp Fc:7 Fc:7}



static void Test_Ip_BFu7c_BFu7c()
{
  {
    init_simple_test("Ip_BFu7c_BFu7c");
    static STRUCT_IF_C Ip_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu7c, Ip_BFu7c_BFu7c)
//============================================================================


struct  Ip_BFu7c_BFu7i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu7c_BFu7i) C1{ Fp Fc:7 Fi:7}



static void Test_Ip_BFu7c_BFu7i()
{
  {
    init_simple_test("Ip_BFu7c_BFu7i");
    static STRUCT_IF_C Ip_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu7i, Ip_BFu7c_BFu7i)
//============================================================================


struct  Ip_BFu7c_BFu7ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu7c_BFu7ll) C1{ Fp Fc:7 FL:7}



static void Test_Ip_BFu7c_BFu7ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu7ll");
    static STRUCT_IF_C Ip_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu7ll, Ip_BFu7c_BFu7ll)
//============================================================================


struct  Ip_BFu7c_BFu7s  {
  int *v1;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu7c_BFu7s) C1{ Fp Fc:7 Fs:7}



static void Test_Ip_BFu7c_BFu7s()
{
  {
    init_simple_test("Ip_BFu7c_BFu7s");
    static STRUCT_IF_C Ip_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu7s, Ip_BFu7c_BFu7s)
//============================================================================


struct  Ip_BFu7c_BFu8c  {
  int *v1;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu7c_BFu8c) C1{ Fp Fc:7 Fc:8}



static void Test_Ip_BFu7c_BFu8c()
{
  {
    init_simple_test("Ip_BFu7c_BFu8c");
    static STRUCT_IF_C Ip_BFu7c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu8c, Ip_BFu7c_BFu8c)
//============================================================================


struct  Ip_BFu7c_BFu8i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu7c_BFu8i) C1{ Fp Fc:7 Fi:8}



static void Test_Ip_BFu7c_BFu8i()
{
  {
    init_simple_test("Ip_BFu7c_BFu8i");
    static STRUCT_IF_C Ip_BFu7c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu8i, Ip_BFu7c_BFu8i)
//============================================================================


struct  Ip_BFu7c_BFu8ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu7c_BFu8ll) C1{ Fp Fc:7 FL:8}



static void Test_Ip_BFu7c_BFu8ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu8ll");
    static STRUCT_IF_C Ip_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu8ll, Ip_BFu7c_BFu8ll)
//============================================================================


struct  Ip_BFu7c_BFu8s  {
  int *v1;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu7c_BFu8s) C1{ Fp Fc:7 Fs:8}



static void Test_Ip_BFu7c_BFu8s()
{
  {
    init_simple_test("Ip_BFu7c_BFu8s");
    static STRUCT_IF_C Ip_BFu7c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu8s, Ip_BFu7c_BFu8s)
//============================================================================


struct  Ip_BFu7c_BFu9i  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu7c_BFu9i) C1{ Fp Fc:7 Fi:9}



static void Test_Ip_BFu7c_BFu9i()
{
  {
    init_simple_test("Ip_BFu7c_BFu9i");
    static STRUCT_IF_C Ip_BFu7c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu9i, Ip_BFu7c_BFu9i)
//============================================================================


struct  Ip_BFu7c_BFu9ll  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu7c_BFu9ll) C1{ Fp Fc:7 FL:9}



static void Test_Ip_BFu7c_BFu9ll()
{
  {
    init_simple_test("Ip_BFu7c_BFu9ll");
    static STRUCT_IF_C Ip_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu9ll, Ip_BFu7c_BFu9ll)
//============================================================================


struct  Ip_BFu7c_BFu9s  {
  int *v1;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu7c_BFu9s) C1{ Fp Fc:7 Fs:9}



static void Test_Ip_BFu7c_BFu9s()
{
  {
    init_simple_test("Ip_BFu7c_BFu9s");
    static STRUCT_IF_C Ip_BFu7c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_BFu9s, Ip_BFu7c_BFu9s)
//============================================================================


struct  Ip_BFu7c_C  {
  int *v1;
  unsigned char v2:7;
  char v3;
};
//SIG(1 Ip_BFu7c_C) C1{ Fp Fc:7 Fc}



static void Test_Ip_BFu7c_C()
{
  {
    init_simple_test("Ip_BFu7c_C");
    static STRUCT_IF_C Ip_BFu7c_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_C, Ip_BFu7c_C)
//============================================================================


struct  Ip_BFu7c_D  {
  int *v1;
  unsigned char v2:7;
  double v3;
};
//SIG(1 Ip_BFu7c_D) C1{ Fp Fc:7 FL}



static void Test_Ip_BFu7c_D()
{
  {
    init_simple_test("Ip_BFu7c_D");
    static STRUCT_IF_C Ip_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_D, Ip_BFu7c_D)
//============================================================================


struct  Ip_BFu7c_F  {
  int *v1;
  unsigned char v2:7;
  float v3;
};
//SIG(1 Ip_BFu7c_F) C1{ Fp Fc:7 Fi}



static void Test_Ip_BFu7c_F()
{
  {
    init_simple_test("Ip_BFu7c_F");
    static STRUCT_IF_C Ip_BFu7c_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_F, Ip_BFu7c_F)
//============================================================================


struct  Ip_BFu7c_I  {
  int *v1;
  unsigned char v2:7;
  int v3;
};
//SIG(1 Ip_BFu7c_I) C1{ Fp Fc:7 Fi}



static void Test_Ip_BFu7c_I()
{
  {
    init_simple_test("Ip_BFu7c_I");
    static STRUCT_IF_C Ip_BFu7c_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_I, Ip_BFu7c_I)
//============================================================================


struct  Ip_BFu7c_Ip  {
  int *v1;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 Ip_BFu7c_Ip) C1{ Fp Fc:7 Fp}



static void Test_Ip_BFu7c_Ip()
{
  {
    init_simple_test("Ip_BFu7c_Ip");
    static STRUCT_IF_C Ip_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_Ip, Ip_BFu7c_Ip)
//============================================================================


struct  Ip_BFu7c_L  {
  int *v1;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 Ip_BFu7c_L) C1{ Fp Fc:7 FL}



static void Test_Ip_BFu7c_L()
{
  {
    init_simple_test("Ip_BFu7c_L");
    static STRUCT_IF_C Ip_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_L, Ip_BFu7c_L)
//============================================================================


struct  Ip_BFu7c_S  {
  int *v1;
  unsigned char v2:7;
  short v3;
};
//SIG(1 Ip_BFu7c_S) C1{ Fp Fc:7 Fs}



static void Test_Ip_BFu7c_S()
{
  {
    init_simple_test("Ip_BFu7c_S");
    static STRUCT_IF_C Ip_BFu7c_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_S, Ip_BFu7c_S)
//============================================================================


struct  Ip_BFu7c_Uc  {
  int *v1;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 Ip_BFu7c_Uc) C1{ Fp Fc:7 Fc}



static void Test_Ip_BFu7c_Uc()
{
  {
    init_simple_test("Ip_BFu7c_Uc");
    static STRUCT_IF_C Ip_BFu7c_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_Uc, Ip_BFu7c_Uc)
//============================================================================


struct  Ip_BFu7c_Ui  {
  int *v1;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 Ip_BFu7c_Ui) C1{ Fp Fc:7 Fi}



static void Test_Ip_BFu7c_Ui()
{
  {
    init_simple_test("Ip_BFu7c_Ui");
    static STRUCT_IF_C Ip_BFu7c_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_Ui, Ip_BFu7c_Ui)
//============================================================================


struct  Ip_BFu7c_Ul  {
  int *v1;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 Ip_BFu7c_Ul) C1{ Fp Fc:7 FL}



static void Test_Ip_BFu7c_Ul()
{
  {
    init_simple_test("Ip_BFu7c_Ul");
    static STRUCT_IF_C Ip_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_Ul, Ip_BFu7c_Ul)
//============================================================================


struct  Ip_BFu7c_Us  {
  int *v1;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 Ip_BFu7c_Us) C1{ Fp Fc:7 Fs}



static void Test_Ip_BFu7c_Us()
{
  {
    init_simple_test("Ip_BFu7c_Us");
    static STRUCT_IF_C Ip_BFu7c_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_Us, Ip_BFu7c_Us)
//============================================================================


struct  Ip_BFu7c_Vp  {
  int *v1;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 Ip_BFu7c_Vp) C1{ Fp Fc:7 Fp}



static void Test_Ip_BFu7c_Vp()
{
  {
    init_simple_test("Ip_BFu7c_Vp");
    static STRUCT_IF_C Ip_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7c_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7c_Vp, Ip_BFu7c_Vp)
//============================================================================


struct  Ip_BFu7i  {
  int *v1;
  unsigned int v2:7;
};
//SIG(1 Ip_BFu7i) C1{ Fp Fi:7}



static void Test_Ip_BFu7i()
{
  {
    init_simple_test("Ip_BFu7i");
    static STRUCT_IF_C Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i, Ip_BFu7i)
//============================================================================


struct  Ip_BFu7i_BFu15i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu7i_BFu15i) C1{ Fp Fi:7 Fi:15}



static void Test_Ip_BFu7i_BFu15i()
{
  {
    init_simple_test("Ip_BFu7i_BFu15i");
    static STRUCT_IF_C Ip_BFu7i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Ip_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Ip_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu15i, Ip_BFu7i_BFu15i)
//============================================================================


struct  Ip_BFu7i_BFu15ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu7i_BFu15ll) C1{ Fp Fi:7 FL:15}



static void Test_Ip_BFu7i_BFu15ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu15ll");
    static STRUCT_IF_C Ip_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Ip_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Ip_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu15ll, Ip_BFu7i_BFu15ll)
//============================================================================


struct  Ip_BFu7i_BFu15s  {
  int *v1;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu7i_BFu15s) C1{ Fp Fi:7 Fs:15}



static void Test_Ip_BFu7i_BFu15s()
{
  {
    init_simple_test("Ip_BFu7i_BFu15s");
    static STRUCT_IF_C Ip_BFu7i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu15s, Ip_BFu7i_BFu15s)
//============================================================================


struct  Ip_BFu7i_BFu16i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu7i_BFu16i) C1{ Fp Fi:7 Fi:16}



static void Test_Ip_BFu7i_BFu16i()
{
  {
    init_simple_test("Ip_BFu7i_BFu16i");
    static STRUCT_IF_C Ip_BFu7i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Ip_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Ip_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu16i, Ip_BFu7i_BFu16i)
//============================================================================


struct  Ip_BFu7i_BFu16ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu7i_BFu16ll) C1{ Fp Fi:7 FL:16}



static void Test_Ip_BFu7i_BFu16ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu16ll");
    static STRUCT_IF_C Ip_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Ip_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Ip_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu16ll, Ip_BFu7i_BFu16ll)
//============================================================================


struct  Ip_BFu7i_BFu16s  {
  int *v1;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu7i_BFu16s) C1{ Fp Fi:7 Fs:16}



static void Test_Ip_BFu7i_BFu16s()
{
  {
    init_simple_test("Ip_BFu7i_BFu16s");
    static STRUCT_IF_C Ip_BFu7i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu16s, Ip_BFu7i_BFu16s)
//============================================================================


struct  Ip_BFu7i_BFu17i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu7i_BFu17i) C1{ Fp Fi:7 Fi:17}



static void Test_Ip_BFu7i_BFu17i()
{
  {
    init_simple_test("Ip_BFu7i_BFu17i");
    static STRUCT_IF_C Ip_BFu7i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Ip_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Ip_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu17i, Ip_BFu7i_BFu17i)
//============================================================================


struct  Ip_BFu7i_BFu17ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu7i_BFu17ll) C1{ Fp Fi:7 FL:17}



static void Test_Ip_BFu7i_BFu17ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu17ll");
    static STRUCT_IF_C Ip_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Ip_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Ip_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu17ll, Ip_BFu7i_BFu17ll)
//============================================================================


struct  Ip_BFu7i_BFu1c  {
  int *v1;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu7i_BFu1c) C1{ Fp Fi:7 Fc:1}



static void Test_Ip_BFu7i_BFu1c()
{
  {
    init_simple_test("Ip_BFu7i_BFu1c");
    static STRUCT_IF_C Ip_BFu7i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu1c, Ip_BFu7i_BFu1c)
//============================================================================


struct  Ip_BFu7i_BFu1i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu7i_BFu1i) C1{ Fp Fi:7 Fi:1}



static void Test_Ip_BFu7i_BFu1i()
{
  {
    init_simple_test("Ip_BFu7i_BFu1i");
    static STRUCT_IF_C Ip_BFu7i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu1i, Ip_BFu7i_BFu1i)
//============================================================================


struct  Ip_BFu7i_BFu1ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu7i_BFu1ll) C1{ Fp Fi:7 FL:1}



static void Test_Ip_BFu7i_BFu1ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu1ll");
    static STRUCT_IF_C Ip_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu1ll, Ip_BFu7i_BFu1ll)
//============================================================================


struct  Ip_BFu7i_BFu1s  {
  int *v1;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu7i_BFu1s) C1{ Fp Fi:7 Fs:1}



static void Test_Ip_BFu7i_BFu1s()
{
  {
    init_simple_test("Ip_BFu7i_BFu1s");
    static STRUCT_IF_C Ip_BFu7i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu1s, Ip_BFu7i_BFu1s)
//============================================================================


struct  Ip_BFu7i_BFu31i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu7i_BFu31i) C1{ Fp Fi:7 Fi:31}



static void Test_Ip_BFu7i_BFu31i()
{
  {
    init_simple_test("Ip_BFu7i_BFu31i");
    static STRUCT_IF_C Ip_BFu7i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu31i, Ip_BFu7i_BFu31i)
//============================================================================


struct  Ip_BFu7i_BFu31ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu7i_BFu31ll) C1{ Fp Fi:7 FL:31}



static void Test_Ip_BFu7i_BFu31ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu31ll");
    static STRUCT_IF_C Ip_BFu7i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 31, 1, "Ip_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 31, hide_ull(1LL<<30), "Ip_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu31ll, Ip_BFu7i_BFu31ll)
//============================================================================


struct  Ip_BFu7i_BFu32i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu7i_BFu32i) C1{ Fp Fi:7 Fi:32}



static void Test_Ip_BFu7i_BFu32i()
{
  {
    init_simple_test("Ip_BFu7i_BFu32i");
    static STRUCT_IF_C Ip_BFu7i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu32i, Ip_BFu7i_BFu32i)
//============================================================================


struct  Ip_BFu7i_BFu32ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu7i_BFu32ll) C1{ Fp Fi:7 FL:32}



static void Test_Ip_BFu7i_BFu32ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu32ll");
    static STRUCT_IF_C Ip_BFu7i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 32, 1, "Ip_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 32, hide_ull(1LL<<31), "Ip_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu32ll, Ip_BFu7i_BFu32ll)
//============================================================================


struct  Ip_BFu7i_BFu33  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu7i_BFu33) C1{ Fp Fi:7 FL:33}



static void Test_Ip_BFu7i_BFu33()
{
  {
    init_simple_test("Ip_BFu7i_BFu33");
    static STRUCT_IF_C Ip_BFu7i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 33, 1, "Ip_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 33, hide_ull(1LL<<32), "Ip_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu33, Ip_BFu7i_BFu33)
//============================================================================


struct  Ip_BFu7i_BFu7c  {
  int *v1;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu7i_BFu7c) C1{ Fp Fi:7 Fc:7}



static void Test_Ip_BFu7i_BFu7c()
{
  {
    init_simple_test("Ip_BFu7i_BFu7c");
    static STRUCT_IF_C Ip_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu7c, Ip_BFu7i_BFu7c)
//============================================================================


struct  Ip_BFu7i_BFu7i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu7i_BFu7i) C1{ Fp Fi:7 Fi:7}



static void Test_Ip_BFu7i_BFu7i()
{
  {
    init_simple_test("Ip_BFu7i_BFu7i");
    static STRUCT_IF_C Ip_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu7i, Ip_BFu7i_BFu7i)
//============================================================================


struct  Ip_BFu7i_BFu7ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu7i_BFu7ll) C1{ Fp Fi:7 FL:7}



static void Test_Ip_BFu7i_BFu7ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu7ll");
    static STRUCT_IF_C Ip_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu7ll, Ip_BFu7i_BFu7ll)
//============================================================================


struct  Ip_BFu7i_BFu7s  {
  int *v1;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu7i_BFu7s) C1{ Fp Fi:7 Fs:7}



static void Test_Ip_BFu7i_BFu7s()
{
  {
    init_simple_test("Ip_BFu7i_BFu7s");
    static STRUCT_IF_C Ip_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu7s, Ip_BFu7i_BFu7s)
//============================================================================


struct  Ip_BFu7i_BFu8c  {
  int *v1;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu7i_BFu8c) C1{ Fp Fi:7 Fc:8}



static void Test_Ip_BFu7i_BFu8c()
{
  {
    init_simple_test("Ip_BFu7i_BFu8c");
    static STRUCT_IF_C Ip_BFu7i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu8c, Ip_BFu7i_BFu8c)
//============================================================================


struct  Ip_BFu7i_BFu8i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu7i_BFu8i) C1{ Fp Fi:7 Fi:8}



static void Test_Ip_BFu7i_BFu8i()
{
  {
    init_simple_test("Ip_BFu7i_BFu8i");
    static STRUCT_IF_C Ip_BFu7i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu8i, Ip_BFu7i_BFu8i)
//============================================================================


struct  Ip_BFu7i_BFu8ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu7i_BFu8ll) C1{ Fp Fi:7 FL:8}



static void Test_Ip_BFu7i_BFu8ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu8ll");
    static STRUCT_IF_C Ip_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu8ll, Ip_BFu7i_BFu8ll)
//============================================================================


struct  Ip_BFu7i_BFu8s  {
  int *v1;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu7i_BFu8s) C1{ Fp Fi:7 Fs:8}



static void Test_Ip_BFu7i_BFu8s()
{
  {
    init_simple_test("Ip_BFu7i_BFu8s");
    static STRUCT_IF_C Ip_BFu7i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu8s, Ip_BFu7i_BFu8s)
//============================================================================


struct  Ip_BFu7i_BFu9i  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu7i_BFu9i) C1{ Fp Fi:7 Fi:9}



static void Test_Ip_BFu7i_BFu9i()
{
  {
    init_simple_test("Ip_BFu7i_BFu9i");
    static STRUCT_IF_C Ip_BFu7i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu9i, Ip_BFu7i_BFu9i)
//============================================================================


struct  Ip_BFu7i_BFu9ll  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu7i_BFu9ll) C1{ Fp Fi:7 FL:9}



static void Test_Ip_BFu7i_BFu9ll()
{
  {
    init_simple_test("Ip_BFu7i_BFu9ll");
    static STRUCT_IF_C Ip_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu9ll, Ip_BFu7i_BFu9ll)
//============================================================================


struct  Ip_BFu7i_BFu9s  {
  int *v1;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu7i_BFu9s) C1{ Fp Fi:7 Fs:9}



static void Test_Ip_BFu7i_BFu9s()
{
  {
    init_simple_test("Ip_BFu7i_BFu9s");
    static STRUCT_IF_C Ip_BFu7i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_BFu9s, Ip_BFu7i_BFu9s)
//============================================================================


struct  Ip_BFu7i_C  {
  int *v1;
  unsigned int v2:7;
  char v3;
};
//SIG(1 Ip_BFu7i_C) C1{ Fp Fi:7 Fc}



static void Test_Ip_BFu7i_C()
{
  {
    init_simple_test("Ip_BFu7i_C");
    static STRUCT_IF_C Ip_BFu7i_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_C, Ip_BFu7i_C)
//============================================================================


struct  Ip_BFu7i_D  {
  int *v1;
  unsigned int v2:7;
  double v3;
};
//SIG(1 Ip_BFu7i_D) C1{ Fp Fi:7 FL}



static void Test_Ip_BFu7i_D()
{
  {
    init_simple_test("Ip_BFu7i_D");
    static STRUCT_IF_C Ip_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_D, Ip_BFu7i_D)
//============================================================================


struct  Ip_BFu7i_F  {
  int *v1;
  unsigned int v2:7;
  float v3;
};
//SIG(1 Ip_BFu7i_F) C1{ Fp Fi:7 Fi}



static void Test_Ip_BFu7i_F()
{
  {
    init_simple_test("Ip_BFu7i_F");
    static STRUCT_IF_C Ip_BFu7i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_F, Ip_BFu7i_F)
//============================================================================


struct  Ip_BFu7i_I  {
  int *v1;
  unsigned int v2:7;
  int v3;
};
//SIG(1 Ip_BFu7i_I) C1{ Fp Fi:7 Fi}



static void Test_Ip_BFu7i_I()
{
  {
    init_simple_test("Ip_BFu7i_I");
    static STRUCT_IF_C Ip_BFu7i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_I, Ip_BFu7i_I)
//============================================================================


struct  Ip_BFu7i_Ip  {
  int *v1;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 Ip_BFu7i_Ip) C1{ Fp Fi:7 Fp}



static void Test_Ip_BFu7i_Ip()
{
  {
    init_simple_test("Ip_BFu7i_Ip");
    static STRUCT_IF_C Ip_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_Ip, Ip_BFu7i_Ip)
//============================================================================


struct  Ip_BFu7i_L  {
  int *v1;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 Ip_BFu7i_L) C1{ Fp Fi:7 FL}



static void Test_Ip_BFu7i_L()
{
  {
    init_simple_test("Ip_BFu7i_L");
    static STRUCT_IF_C Ip_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_L, Ip_BFu7i_L)
//============================================================================


struct  Ip_BFu7i_S  {
  int *v1;
  unsigned int v2:7;
  short v3;
};
//SIG(1 Ip_BFu7i_S) C1{ Fp Fi:7 Fs}



static void Test_Ip_BFu7i_S()
{
  {
    init_simple_test("Ip_BFu7i_S");
    static STRUCT_IF_C Ip_BFu7i_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_S, Ip_BFu7i_S)
//============================================================================


struct  Ip_BFu7i_Uc  {
  int *v1;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 Ip_BFu7i_Uc) C1{ Fp Fi:7 Fc}



static void Test_Ip_BFu7i_Uc()
{
  {
    init_simple_test("Ip_BFu7i_Uc");
    static STRUCT_IF_C Ip_BFu7i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_Uc, Ip_BFu7i_Uc)
//============================================================================


struct  Ip_BFu7i_Ui  {
  int *v1;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 Ip_BFu7i_Ui) C1{ Fp Fi:7 Fi}



static void Test_Ip_BFu7i_Ui()
{
  {
    init_simple_test("Ip_BFu7i_Ui");
    static STRUCT_IF_C Ip_BFu7i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_Ui, Ip_BFu7i_Ui)
//============================================================================


struct  Ip_BFu7i_Ul  {
  int *v1;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 Ip_BFu7i_Ul) C1{ Fp Fi:7 FL}



static void Test_Ip_BFu7i_Ul()
{
  {
    init_simple_test("Ip_BFu7i_Ul");
    static STRUCT_IF_C Ip_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_Ul, Ip_BFu7i_Ul)
//============================================================================


struct  Ip_BFu7i_Us  {
  int *v1;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 Ip_BFu7i_Us) C1{ Fp Fi:7 Fs}



static void Test_Ip_BFu7i_Us()
{
  {
    init_simple_test("Ip_BFu7i_Us");
    static STRUCT_IF_C Ip_BFu7i_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_Us, Ip_BFu7i_Us)
//============================================================================


struct  Ip_BFu7i_Vp  {
  int *v1;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 Ip_BFu7i_Vp) C1{ Fp Fi:7 Fp}



static void Test_Ip_BFu7i_Vp()
{
  {
    init_simple_test("Ip_BFu7i_Vp");
    static STRUCT_IF_C Ip_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7i_Vp, Ip_BFu7i_Vp)
//============================================================================


struct  Ip_BFu7ll  {
  int *v1;
  __tsu64 v2:7;
};
//SIG(1 Ip_BFu7ll) C1{ Fp FL:7}



static void Test_Ip_BFu7ll()
{
  {
    init_simple_test("Ip_BFu7ll");
    static STRUCT_IF_C Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll, Ip_BFu7ll)
//============================================================================


struct  Ip_BFu7ll_BFu15i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu7ll_BFu15i) C1{ Fp FL:7 Fi:15}



static void Test_Ip_BFu7ll_BFu15i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu15i");
    static STRUCT_IF_C Ip_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Ip_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Ip_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu15i, Ip_BFu7ll_BFu15i)
//============================================================================


struct  Ip_BFu7ll_BFu15ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu7ll_BFu15ll) C1{ Fp FL:7 FL:15}



static void Test_Ip_BFu7ll_BFu15ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu15ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Ip_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Ip_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu15ll, Ip_BFu7ll_BFu15ll)
//============================================================================


struct  Ip_BFu7ll_BFu15s  {
  int *v1;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu7ll_BFu15s) C1{ Fp FL:7 Fs:15}



static void Test_Ip_BFu7ll_BFu15s()
{
  {
    init_simple_test("Ip_BFu7ll_BFu15s");
    static STRUCT_IF_C Ip_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu15s, Ip_BFu7ll_BFu15s)
//============================================================================


struct  Ip_BFu7ll_BFu16i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu7ll_BFu16i) C1{ Fp FL:7 Fi:16}



static void Test_Ip_BFu7ll_BFu16i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu16i");
    static STRUCT_IF_C Ip_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Ip_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Ip_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu16i, Ip_BFu7ll_BFu16i)
//============================================================================


struct  Ip_BFu7ll_BFu16ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu7ll_BFu16ll) C1{ Fp FL:7 FL:16}



static void Test_Ip_BFu7ll_BFu16ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu16ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Ip_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Ip_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu16ll, Ip_BFu7ll_BFu16ll)
//============================================================================


struct  Ip_BFu7ll_BFu16s  {
  int *v1;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu7ll_BFu16s) C1{ Fp FL:7 Fs:16}



static void Test_Ip_BFu7ll_BFu16s()
{
  {
    init_simple_test("Ip_BFu7ll_BFu16s");
    static STRUCT_IF_C Ip_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu16s, Ip_BFu7ll_BFu16s)
//============================================================================


struct  Ip_BFu7ll_BFu17i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu7ll_BFu17i) C1{ Fp FL:7 Fi:17}



static void Test_Ip_BFu7ll_BFu17i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu17i");
    static STRUCT_IF_C Ip_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Ip_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Ip_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu17i, Ip_BFu7ll_BFu17i)
//============================================================================


struct  Ip_BFu7ll_BFu17ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu7ll_BFu17ll) C1{ Fp FL:7 FL:17}



static void Test_Ip_BFu7ll_BFu17ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu17ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Ip_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Ip_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu17ll, Ip_BFu7ll_BFu17ll)
//============================================================================


struct  Ip_BFu7ll_BFu1c  {
  int *v1;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu7ll_BFu1c) C1{ Fp FL:7 Fc:1}



static void Test_Ip_BFu7ll_BFu1c()
{
  {
    init_simple_test("Ip_BFu7ll_BFu1c");
    static STRUCT_IF_C Ip_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu1c, Ip_BFu7ll_BFu1c)
//============================================================================


struct  Ip_BFu7ll_BFu1i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu7ll_BFu1i) C1{ Fp FL:7 Fi:1}



static void Test_Ip_BFu7ll_BFu1i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu1i");
    static STRUCT_IF_C Ip_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu1i, Ip_BFu7ll_BFu1i)
//============================================================================


struct  Ip_BFu7ll_BFu1ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu7ll_BFu1ll) C1{ Fp FL:7 FL:1}



static void Test_Ip_BFu7ll_BFu1ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu1ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu1ll, Ip_BFu7ll_BFu1ll)
//============================================================================


struct  Ip_BFu7ll_BFu1s  {
  int *v1;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu7ll_BFu1s) C1{ Fp FL:7 Fs:1}



static void Test_Ip_BFu7ll_BFu1s()
{
  {
    init_simple_test("Ip_BFu7ll_BFu1s");
    static STRUCT_IF_C Ip_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu1s, Ip_BFu7ll_BFu1s)
//============================================================================


struct  Ip_BFu7ll_BFu31i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu7ll_BFu31i) C1{ Fp FL:7 Fi:31}



static void Test_Ip_BFu7ll_BFu31i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu31i");
    static STRUCT_IF_C Ip_BFu7ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu31i, Ip_BFu7ll_BFu31i)
//============================================================================


struct  Ip_BFu7ll_BFu31ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu7ll_BFu31ll) C1{ Fp FL:7 FL:31}



static void Test_Ip_BFu7ll_BFu31ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu31ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 31, 1, "Ip_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 31, hide_ull(1LL<<30), "Ip_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu31ll, Ip_BFu7ll_BFu31ll)
//============================================================================


struct  Ip_BFu7ll_BFu32i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu7ll_BFu32i) C1{ Fp FL:7 Fi:32}



static void Test_Ip_BFu7ll_BFu32i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu32i");
    static STRUCT_IF_C Ip_BFu7ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu32i, Ip_BFu7ll_BFu32i)
//============================================================================


struct  Ip_BFu7ll_BFu32ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu7ll_BFu32ll) C1{ Fp FL:7 FL:32}



static void Test_Ip_BFu7ll_BFu32ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu32ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 32, 1, "Ip_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 32, hide_ull(1LL<<31), "Ip_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu32ll, Ip_BFu7ll_BFu32ll)
//============================================================================


struct  Ip_BFu7ll_BFu33  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu7ll_BFu33) C1{ Fp FL:7 FL:33}



static void Test_Ip_BFu7ll_BFu33()
{
  {
    init_simple_test("Ip_BFu7ll_BFu33");
    static STRUCT_IF_C Ip_BFu7ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 33, 1, "Ip_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 33, hide_ull(1LL<<32), "Ip_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu33, Ip_BFu7ll_BFu33)
//============================================================================


struct  Ip_BFu7ll_BFu7c  {
  int *v1;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu7ll_BFu7c) C1{ Fp FL:7 Fc:7}



static void Test_Ip_BFu7ll_BFu7c()
{
  {
    init_simple_test("Ip_BFu7ll_BFu7c");
    static STRUCT_IF_C Ip_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu7c, Ip_BFu7ll_BFu7c)
//============================================================================


struct  Ip_BFu7ll_BFu7i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu7ll_BFu7i) C1{ Fp FL:7 Fi:7}



static void Test_Ip_BFu7ll_BFu7i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu7i");
    static STRUCT_IF_C Ip_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu7i, Ip_BFu7ll_BFu7i)
//============================================================================


struct  Ip_BFu7ll_BFu7ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu7ll_BFu7ll) C1{ Fp FL:7 FL:7}



static void Test_Ip_BFu7ll_BFu7ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu7ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu7ll, Ip_BFu7ll_BFu7ll)
//============================================================================


struct  Ip_BFu7ll_BFu7s  {
  int *v1;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu7ll_BFu7s) C1{ Fp FL:7 Fs:7}



static void Test_Ip_BFu7ll_BFu7s()
{
  {
    init_simple_test("Ip_BFu7ll_BFu7s");
    static STRUCT_IF_C Ip_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu7s, Ip_BFu7ll_BFu7s)
//============================================================================


struct  Ip_BFu7ll_BFu8c  {
  int *v1;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu7ll_BFu8c) C1{ Fp FL:7 Fc:8}



static void Test_Ip_BFu7ll_BFu8c()
{
  {
    init_simple_test("Ip_BFu7ll_BFu8c");
    static STRUCT_IF_C Ip_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu8c, Ip_BFu7ll_BFu8c)
//============================================================================


struct  Ip_BFu7ll_BFu8i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu7ll_BFu8i) C1{ Fp FL:7 Fi:8}



static void Test_Ip_BFu7ll_BFu8i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu8i");
    static STRUCT_IF_C Ip_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu8i, Ip_BFu7ll_BFu8i)
//============================================================================


struct  Ip_BFu7ll_BFu8ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu7ll_BFu8ll) C1{ Fp FL:7 FL:8}



static void Test_Ip_BFu7ll_BFu8ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu8ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu8ll, Ip_BFu7ll_BFu8ll)
//============================================================================


struct  Ip_BFu7ll_BFu8s  {
  int *v1;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu7ll_BFu8s) C1{ Fp FL:7 Fs:8}



static void Test_Ip_BFu7ll_BFu8s()
{
  {
    init_simple_test("Ip_BFu7ll_BFu8s");
    static STRUCT_IF_C Ip_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu8s, Ip_BFu7ll_BFu8s)
//============================================================================


struct  Ip_BFu7ll_BFu9i  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu7ll_BFu9i) C1{ Fp FL:7 Fi:9}



static void Test_Ip_BFu7ll_BFu9i()
{
  {
    init_simple_test("Ip_BFu7ll_BFu9i");
    static STRUCT_IF_C Ip_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu9i, Ip_BFu7ll_BFu9i)
//============================================================================


struct  Ip_BFu7ll_BFu9ll  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu7ll_BFu9ll) C1{ Fp FL:7 FL:9}



static void Test_Ip_BFu7ll_BFu9ll()
{
  {
    init_simple_test("Ip_BFu7ll_BFu9ll");
    static STRUCT_IF_C Ip_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu9ll, Ip_BFu7ll_BFu9ll)
//============================================================================


struct  Ip_BFu7ll_BFu9s  {
  int *v1;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu7ll_BFu9s) C1{ Fp FL:7 Fs:9}



static void Test_Ip_BFu7ll_BFu9s()
{
  {
    init_simple_test("Ip_BFu7ll_BFu9s");
    static STRUCT_IF_C Ip_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_BFu9s, Ip_BFu7ll_BFu9s)
//============================================================================


struct  Ip_BFu7ll_C  {
  int *v1;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 Ip_BFu7ll_C) C1{ Fp FL:7 Fc}



static void Test_Ip_BFu7ll_C()
{
  {
    init_simple_test("Ip_BFu7ll_C");
    static STRUCT_IF_C Ip_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_C, Ip_BFu7ll_C)
//============================================================================


struct  Ip_BFu7ll_D  {
  int *v1;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 Ip_BFu7ll_D) C1{ Fp FL:7 FL}



static void Test_Ip_BFu7ll_D()
{
  {
    init_simple_test("Ip_BFu7ll_D");
    static STRUCT_IF_C Ip_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_D, Ip_BFu7ll_D)
//============================================================================


struct  Ip_BFu7ll_F  {
  int *v1;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 Ip_BFu7ll_F) C1{ Fp FL:7 Fi}



static void Test_Ip_BFu7ll_F()
{
  {
    init_simple_test("Ip_BFu7ll_F");
    static STRUCT_IF_C Ip_BFu7ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_F, Ip_BFu7ll_F)
//============================================================================


struct  Ip_BFu7ll_I  {
  int *v1;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 Ip_BFu7ll_I) C1{ Fp FL:7 Fi}



static void Test_Ip_BFu7ll_I()
{
  {
    init_simple_test("Ip_BFu7ll_I");
    static STRUCT_IF_C Ip_BFu7ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_I, Ip_BFu7ll_I)
//============================================================================


struct  Ip_BFu7ll_Ip  {
  int *v1;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 Ip_BFu7ll_Ip) C1{ Fp FL:7 Fp}



static void Test_Ip_BFu7ll_Ip()
{
  {
    init_simple_test("Ip_BFu7ll_Ip");
    static STRUCT_IF_C Ip_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_Ip, Ip_BFu7ll_Ip)
//============================================================================


struct  Ip_BFu7ll_L  {
  int *v1;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 Ip_BFu7ll_L) C1{ Fp FL:7 FL}



static void Test_Ip_BFu7ll_L()
{
  {
    init_simple_test("Ip_BFu7ll_L");
    static STRUCT_IF_C Ip_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_L, Ip_BFu7ll_L)
//============================================================================


struct  Ip_BFu7ll_S  {
  int *v1;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 Ip_BFu7ll_S) C1{ Fp FL:7 Fs}



static void Test_Ip_BFu7ll_S()
{
  {
    init_simple_test("Ip_BFu7ll_S");
    static STRUCT_IF_C Ip_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_S, Ip_BFu7ll_S)
//============================================================================


struct  Ip_BFu7ll_Uc  {
  int *v1;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 Ip_BFu7ll_Uc) C1{ Fp FL:7 Fc}



static void Test_Ip_BFu7ll_Uc()
{
  {
    init_simple_test("Ip_BFu7ll_Uc");
    static STRUCT_IF_C Ip_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_Uc, Ip_BFu7ll_Uc)
//============================================================================


struct  Ip_BFu7ll_Ui  {
  int *v1;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 Ip_BFu7ll_Ui) C1{ Fp FL:7 Fi}



static void Test_Ip_BFu7ll_Ui()
{
  {
    init_simple_test("Ip_BFu7ll_Ui");
    static STRUCT_IF_C Ip_BFu7ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_Ui, Ip_BFu7ll_Ui)
//============================================================================


struct  Ip_BFu7ll_Ul  {
  int *v1;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 Ip_BFu7ll_Ul) C1{ Fp FL:7 FL}



static void Test_Ip_BFu7ll_Ul()
{
  {
    init_simple_test("Ip_BFu7ll_Ul");
    static STRUCT_IF_C Ip_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_Ul, Ip_BFu7ll_Ul)
//============================================================================


struct  Ip_BFu7ll_Us  {
  int *v1;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 Ip_BFu7ll_Us) C1{ Fp FL:7 Fs}



static void Test_Ip_BFu7ll_Us()
{
  {
    init_simple_test("Ip_BFu7ll_Us");
    static STRUCT_IF_C Ip_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_Us, Ip_BFu7ll_Us)
//============================================================================


struct  Ip_BFu7ll_Vp  {
  int *v1;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 Ip_BFu7ll_Vp) C1{ Fp FL:7 Fp}



static void Test_Ip_BFu7ll_Vp()
{
  {
    init_simple_test("Ip_BFu7ll_Vp");
    static STRUCT_IF_C Ip_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7ll_Vp, Ip_BFu7ll_Vp)
//============================================================================


struct  Ip_BFu7s  {
  int *v1;
  unsigned short v2:7;
};
//SIG(1 Ip_BFu7s) C1{ Fp Fs:7}



static void Test_Ip_BFu7s()
{
  {
    init_simple_test("Ip_BFu7s");
    static STRUCT_IF_C Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s, Ip_BFu7s)
//============================================================================


struct  Ip_BFu7s_BFu15i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu7s_BFu15i) C1{ Fp Fs:7 Fi:15}



static void Test_Ip_BFu7s_BFu15i()
{
  {
    init_simple_test("Ip_BFu7s_BFu15i");
    static STRUCT_IF_C Ip_BFu7s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Ip_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Ip_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu15i, Ip_BFu7s_BFu15i)
//============================================================================


struct  Ip_BFu7s_BFu15ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu7s_BFu15ll) C1{ Fp Fs:7 FL:15}



static void Test_Ip_BFu7s_BFu15ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu15ll");
    static STRUCT_IF_C Ip_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Ip_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Ip_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu15ll, Ip_BFu7s_BFu15ll)
//============================================================================


struct  Ip_BFu7s_BFu15s  {
  int *v1;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu7s_BFu15s) C1{ Fp Fs:7 Fs:15}



static void Test_Ip_BFu7s_BFu15s()
{
  {
    init_simple_test("Ip_BFu7s_BFu15s");
    static STRUCT_IF_C Ip_BFu7s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu15s, Ip_BFu7s_BFu15s)
//============================================================================


struct  Ip_BFu7s_BFu16i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu7s_BFu16i) C1{ Fp Fs:7 Fi:16}



static void Test_Ip_BFu7s_BFu16i()
{
  {
    init_simple_test("Ip_BFu7s_BFu16i");
    static STRUCT_IF_C Ip_BFu7s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Ip_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Ip_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu16i, Ip_BFu7s_BFu16i)
//============================================================================


struct  Ip_BFu7s_BFu16ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu7s_BFu16ll) C1{ Fp Fs:7 FL:16}



static void Test_Ip_BFu7s_BFu16ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu16ll");
    static STRUCT_IF_C Ip_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Ip_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Ip_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu16ll, Ip_BFu7s_BFu16ll)
//============================================================================


struct  Ip_BFu7s_BFu16s  {
  int *v1;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu7s_BFu16s) C1{ Fp Fs:7 Fs:16}



static void Test_Ip_BFu7s_BFu16s()
{
  {
    init_simple_test("Ip_BFu7s_BFu16s");
    static STRUCT_IF_C Ip_BFu7s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu16s, Ip_BFu7s_BFu16s)
//============================================================================


struct  Ip_BFu7s_BFu17i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu7s_BFu17i) C1{ Fp Fs:7 Fi:17}



static void Test_Ip_BFu7s_BFu17i()
{
  {
    init_simple_test("Ip_BFu7s_BFu17i");
    static STRUCT_IF_C Ip_BFu7s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Ip_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Ip_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu17i, Ip_BFu7s_BFu17i)
//============================================================================


struct  Ip_BFu7s_BFu17ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu7s_BFu17ll) C1{ Fp Fs:7 FL:17}



static void Test_Ip_BFu7s_BFu17ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu17ll");
    static STRUCT_IF_C Ip_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Ip_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Ip_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu17ll, Ip_BFu7s_BFu17ll)
//============================================================================


struct  Ip_BFu7s_BFu1c  {
  int *v1;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu7s_BFu1c) C1{ Fp Fs:7 Fc:1}



static void Test_Ip_BFu7s_BFu1c()
{
  {
    init_simple_test("Ip_BFu7s_BFu1c");
    static STRUCT_IF_C Ip_BFu7s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu1c, Ip_BFu7s_BFu1c)
//============================================================================


struct  Ip_BFu7s_BFu1i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu7s_BFu1i) C1{ Fp Fs:7 Fi:1}



static void Test_Ip_BFu7s_BFu1i()
{
  {
    init_simple_test("Ip_BFu7s_BFu1i");
    static STRUCT_IF_C Ip_BFu7s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu1i, Ip_BFu7s_BFu1i)
//============================================================================


struct  Ip_BFu7s_BFu1ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu7s_BFu1ll) C1{ Fp Fs:7 FL:1}



static void Test_Ip_BFu7s_BFu1ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu1ll");
    static STRUCT_IF_C Ip_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu1ll, Ip_BFu7s_BFu1ll)
//============================================================================


struct  Ip_BFu7s_BFu1s  {
  int *v1;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu7s_BFu1s) C1{ Fp Fs:7 Fs:1}



static void Test_Ip_BFu7s_BFu1s()
{
  {
    init_simple_test("Ip_BFu7s_BFu1s");
    static STRUCT_IF_C Ip_BFu7s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Ip_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu1s, Ip_BFu7s_BFu1s)
//============================================================================


struct  Ip_BFu7s_BFu31i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu7s_BFu31i) C1{ Fp Fs:7 Fi:31}



static void Test_Ip_BFu7s_BFu31i()
{
  {
    init_simple_test("Ip_BFu7s_BFu31i");
    static STRUCT_IF_C Ip_BFu7s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu31i, Ip_BFu7s_BFu31i)
//============================================================================


struct  Ip_BFu7s_BFu31ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu7s_BFu31ll) C1{ Fp Fs:7 FL:31}



static void Test_Ip_BFu7s_BFu31ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu31ll");
    static STRUCT_IF_C Ip_BFu7s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 31, 1, "Ip_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 31, hide_ull(1LL<<30), "Ip_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu31ll, Ip_BFu7s_BFu31ll)
//============================================================================


struct  Ip_BFu7s_BFu32i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu7s_BFu32i) C1{ Fp Fs:7 Fi:32}



static void Test_Ip_BFu7s_BFu32i()
{
  {
    init_simple_test("Ip_BFu7s_BFu32i");
    static STRUCT_IF_C Ip_BFu7s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu32i, Ip_BFu7s_BFu32i)
//============================================================================


struct  Ip_BFu7s_BFu32ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu7s_BFu32ll) C1{ Fp Fs:7 FL:32}



static void Test_Ip_BFu7s_BFu32ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu32ll");
    static STRUCT_IF_C Ip_BFu7s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 32, 1, "Ip_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 32, hide_ull(1LL<<31), "Ip_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu32ll, Ip_BFu7s_BFu32ll)
//============================================================================


struct  Ip_BFu7s_BFu33  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu7s_BFu33) C1{ Fp Fs:7 FL:33}



static void Test_Ip_BFu7s_BFu33()
{
  {
    init_simple_test("Ip_BFu7s_BFu33");
    static STRUCT_IF_C Ip_BFu7s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 33, 1, "Ip_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(7,7), 33, hide_ull(1LL<<32), "Ip_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu33, Ip_BFu7s_BFu33)
//============================================================================


struct  Ip_BFu7s_BFu7c  {
  int *v1;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu7s_BFu7c) C1{ Fp Fs:7 Fc:7}



static void Test_Ip_BFu7s_BFu7c()
{
  {
    init_simple_test("Ip_BFu7s_BFu7c");
    static STRUCT_IF_C Ip_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu7c, Ip_BFu7s_BFu7c)
//============================================================================


struct  Ip_BFu7s_BFu7i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu7s_BFu7i) C1{ Fp Fs:7 Fi:7}



static void Test_Ip_BFu7s_BFu7i()
{
  {
    init_simple_test("Ip_BFu7s_BFu7i");
    static STRUCT_IF_C Ip_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu7i, Ip_BFu7s_BFu7i)
//============================================================================


struct  Ip_BFu7s_BFu7ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu7s_BFu7ll) C1{ Fp Fs:7 FL:7}



static void Test_Ip_BFu7s_BFu7ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu7ll");
    static STRUCT_IF_C Ip_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu7ll, Ip_BFu7s_BFu7ll)
//============================================================================


struct  Ip_BFu7s_BFu7s  {
  int *v1;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu7s_BFu7s) C1{ Fp Fs:7 Fs:7}



static void Test_Ip_BFu7s_BFu7s()
{
  {
    init_simple_test("Ip_BFu7s_BFu7s");
    static STRUCT_IF_C Ip_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Ip_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu7s, Ip_BFu7s_BFu7s)
//============================================================================


struct  Ip_BFu7s_BFu8c  {
  int *v1;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu7s_BFu8c) C1{ Fp Fs:7 Fc:8}



static void Test_Ip_BFu7s_BFu8c()
{
  {
    init_simple_test("Ip_BFu7s_BFu8c");
    static STRUCT_IF_C Ip_BFu7s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu8c, Ip_BFu7s_BFu8c)
//============================================================================


struct  Ip_BFu7s_BFu8i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu7s_BFu8i) C1{ Fp Fs:7 Fi:8}



static void Test_Ip_BFu7s_BFu8i()
{
  {
    init_simple_test("Ip_BFu7s_BFu8i");
    static STRUCT_IF_C Ip_BFu7s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu8i, Ip_BFu7s_BFu8i)
//============================================================================


struct  Ip_BFu7s_BFu8ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu7s_BFu8ll) C1{ Fp Fs:7 FL:8}



static void Test_Ip_BFu7s_BFu8ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu8ll");
    static STRUCT_IF_C Ip_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu8ll, Ip_BFu7s_BFu8ll)
//============================================================================


struct  Ip_BFu7s_BFu8s  {
  int *v1;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu7s_BFu8s) C1{ Fp Fs:7 Fs:8}



static void Test_Ip_BFu7s_BFu8s()
{
  {
    init_simple_test("Ip_BFu7s_BFu8s");
    static STRUCT_IF_C Ip_BFu7s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Ip_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Ip_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu8s, Ip_BFu7s_BFu8s)
//============================================================================


struct  Ip_BFu7s_BFu9i  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu7s_BFu9i) C1{ Fp Fs:7 Fi:9}



static void Test_Ip_BFu7s_BFu9i()
{
  {
    init_simple_test("Ip_BFu7s_BFu9i");
    static STRUCT_IF_C Ip_BFu7s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu9i, Ip_BFu7s_BFu9i)
//============================================================================


struct  Ip_BFu7s_BFu9ll  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu7s_BFu9ll) C1{ Fp Fs:7 FL:9}



static void Test_Ip_BFu7s_BFu9ll()
{
  {
    init_simple_test("Ip_BFu7s_BFu9ll");
    static STRUCT_IF_C Ip_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu9ll, Ip_BFu7s_BFu9ll)
//============================================================================


struct  Ip_BFu7s_BFu9s  {
  int *v1;
  unsigned short v2:7;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu7s_BFu9s) C1{ Fp Fs:7 Fs:9}



static void Test_Ip_BFu7s_BFu9s()
{
  {
    init_simple_test("Ip_BFu7s_BFu9s");
    static STRUCT_IF_C Ip_BFu7s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Ip_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Ip_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_BFu9s, Ip_BFu7s_BFu9s)
//============================================================================


struct  Ip_BFu7s_C  {
  int *v1;
  unsigned short v2:7;
  char v3;
};
//SIG(1 Ip_BFu7s_C) C1{ Fp Fs:7 Fc}



static void Test_Ip_BFu7s_C()
{
  {
    init_simple_test("Ip_BFu7s_C");
    static STRUCT_IF_C Ip_BFu7s_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_C, Ip_BFu7s_C)
//============================================================================


struct  Ip_BFu7s_D  {
  int *v1;
  unsigned short v2:7;
  double v3;
};
//SIG(1 Ip_BFu7s_D) C1{ Fp Fs:7 FL}



static void Test_Ip_BFu7s_D()
{
  {
    init_simple_test("Ip_BFu7s_D");
    static STRUCT_IF_C Ip_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_D, Ip_BFu7s_D)
//============================================================================


struct  Ip_BFu7s_F  {
  int *v1;
  unsigned short v2:7;
  float v3;
};
//SIG(1 Ip_BFu7s_F) C1{ Fp Fs:7 Fi}



static void Test_Ip_BFu7s_F()
{
  {
    init_simple_test("Ip_BFu7s_F");
    static STRUCT_IF_C Ip_BFu7s_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_F, Ip_BFu7s_F)
//============================================================================


struct  Ip_BFu7s_I  {
  int *v1;
  unsigned short v2:7;
  int v3;
};
//SIG(1 Ip_BFu7s_I) C1{ Fp Fs:7 Fi}



static void Test_Ip_BFu7s_I()
{
  {
    init_simple_test("Ip_BFu7s_I");
    static STRUCT_IF_C Ip_BFu7s_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_I, Ip_BFu7s_I)
//============================================================================


struct  Ip_BFu7s_Ip  {
  int *v1;
  unsigned short v2:7;
  int *v3;
};
//SIG(1 Ip_BFu7s_Ip) C1{ Fp Fs:7 Fp}



static void Test_Ip_BFu7s_Ip()
{
  {
    init_simple_test("Ip_BFu7s_Ip");
    static STRUCT_IF_C Ip_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_Ip, Ip_BFu7s_Ip)
//============================================================================


struct  Ip_BFu7s_L  {
  int *v1;
  unsigned short v2:7;
  __tsi64 v3;
};
//SIG(1 Ip_BFu7s_L) C1{ Fp Fs:7 FL}



static void Test_Ip_BFu7s_L()
{
  {
    init_simple_test("Ip_BFu7s_L");
    static STRUCT_IF_C Ip_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_L, Ip_BFu7s_L)
//============================================================================


struct  Ip_BFu7s_S  {
  int *v1;
  unsigned short v2:7;
  short v3;
};
//SIG(1 Ip_BFu7s_S) C1{ Fp Fs:7 Fs}



static void Test_Ip_BFu7s_S()
{
  {
    init_simple_test("Ip_BFu7s_S");
    static STRUCT_IF_C Ip_BFu7s_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_S, Ip_BFu7s_S)
//============================================================================


struct  Ip_BFu7s_Uc  {
  int *v1;
  unsigned short v2:7;
  unsigned char v3;
};
//SIG(1 Ip_BFu7s_Uc) C1{ Fp Fs:7 Fc}



static void Test_Ip_BFu7s_Uc()
{
  {
    init_simple_test("Ip_BFu7s_Uc");
    static STRUCT_IF_C Ip_BFu7s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_Uc, Ip_BFu7s_Uc)
//============================================================================


struct  Ip_BFu7s_Ui  {
  int *v1;
  unsigned short v2:7;
  unsigned int v3;
};
//SIG(1 Ip_BFu7s_Ui) C1{ Fp Fs:7 Fi}



static void Test_Ip_BFu7s_Ui()
{
  {
    init_simple_test("Ip_BFu7s_Ui");
    static STRUCT_IF_C Ip_BFu7s_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu7s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_Ui, Ip_BFu7s_Ui)
//============================================================================


struct  Ip_BFu7s_Ul  {
  int *v1;
  unsigned short v2:7;
  __tsu64 v3;
};
//SIG(1 Ip_BFu7s_Ul) C1{ Fp Fs:7 FL}



static void Test_Ip_BFu7s_Ul()
{
  {
    init_simple_test("Ip_BFu7s_Ul");
    static STRUCT_IF_C Ip_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_Ul, Ip_BFu7s_Ul)
//============================================================================


struct  Ip_BFu7s_Us  {
  int *v1;
  unsigned short v2:7;
  unsigned short v3;
};
//SIG(1 Ip_BFu7s_Us) C1{ Fp Fs:7 Fs}



static void Test_Ip_BFu7s_Us()
{
  {
    init_simple_test("Ip_BFu7s_Us");
    static STRUCT_IF_C Ip_BFu7s_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu7s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_Us, Ip_BFu7s_Us)
//============================================================================


struct  Ip_BFu7s_Vp  {
  int *v1;
  unsigned short v2:7;
  void *v3;
};
//SIG(1 Ip_BFu7s_Vp) C1{ Fp Fs:7 Fp}



static void Test_Ip_BFu7s_Vp()
{
  {
    init_simple_test("Ip_BFu7s_Vp");
    static STRUCT_IF_C Ip_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ip_BFu7s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ip_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu7s_Vp, Ip_BFu7s_Vp)
//============================================================================


struct  Ip_BFu8c  {
  int *v1;
  unsigned char v2:8;
};
//SIG(1 Ip_BFu8c) C1{ Fp Fc:8}



static void Test_Ip_BFu8c()
{
  {
    init_simple_test("Ip_BFu8c");
    static STRUCT_IF_C Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c, Ip_BFu8c)
//============================================================================


struct  Ip_BFu8c_BFu15i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu8c_BFu15i) C1{ Fp Fc:8 Fi:15}



static void Test_Ip_BFu8c_BFu15i()
{
  {
    init_simple_test("Ip_BFu8c_BFu15i");
    static STRUCT_IF_C Ip_BFu8c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu15i, Ip_BFu8c_BFu15i)
//============================================================================


struct  Ip_BFu8c_BFu15ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu8c_BFu15ll) C1{ Fp Fc:8 FL:15}



static void Test_Ip_BFu8c_BFu15ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu15ll");
    static STRUCT_IF_C Ip_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu15ll, Ip_BFu8c_BFu15ll)
//============================================================================


struct  Ip_BFu8c_BFu15s  {
  int *v1;
  unsigned char v2:8;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu8c_BFu15s) C1{ Fp Fc:8 Fs:15}



static void Test_Ip_BFu8c_BFu15s()
{
  {
    init_simple_test("Ip_BFu8c_BFu15s");
    static STRUCT_IF_C Ip_BFu8c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu15s, Ip_BFu8c_BFu15s)
//============================================================================


struct  Ip_BFu8c_BFu16i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu8c_BFu16i) C1{ Fp Fc:8 Fi:16}



static void Test_Ip_BFu8c_BFu16i()
{
  {
    init_simple_test("Ip_BFu8c_BFu16i");
    static STRUCT_IF_C Ip_BFu8c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu16i, Ip_BFu8c_BFu16i)
//============================================================================


struct  Ip_BFu8c_BFu16ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu8c_BFu16ll) C1{ Fp Fc:8 FL:16}



static void Test_Ip_BFu8c_BFu16ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu16ll");
    static STRUCT_IF_C Ip_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu16ll, Ip_BFu8c_BFu16ll)
//============================================================================


struct  Ip_BFu8c_BFu16s  {
  int *v1;
  unsigned char v2:8;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu8c_BFu16s) C1{ Fp Fc:8 Fs:16}



static void Test_Ip_BFu8c_BFu16s()
{
  {
    init_simple_test("Ip_BFu8c_BFu16s");
    static STRUCT_IF_C Ip_BFu8c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu16s, Ip_BFu8c_BFu16s)
//============================================================================


struct  Ip_BFu8c_BFu17i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu8c_BFu17i) C1{ Fp Fc:8 Fi:17}



static void Test_Ip_BFu8c_BFu17i()
{
  {
    init_simple_test("Ip_BFu8c_BFu17i");
    static STRUCT_IF_C Ip_BFu8c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu17i, Ip_BFu8c_BFu17i)
//============================================================================


struct  Ip_BFu8c_BFu17ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu8c_BFu17ll) C1{ Fp Fc:8 FL:17}



static void Test_Ip_BFu8c_BFu17ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu17ll");
    static STRUCT_IF_C Ip_BFu8c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu17ll, Ip_BFu8c_BFu17ll)
//============================================================================


struct  Ip_BFu8c_BFu1c  {
  int *v1;
  unsigned char v2:8;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu8c_BFu1c) C1{ Fp Fc:8 Fc:1}



static void Test_Ip_BFu8c_BFu1c()
{
  {
    init_simple_test("Ip_BFu8c_BFu1c");
    static STRUCT_IF_C Ip_BFu8c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu1c, Ip_BFu8c_BFu1c)
//============================================================================


struct  Ip_BFu8c_BFu1i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu8c_BFu1i) C1{ Fp Fc:8 Fi:1}



static void Test_Ip_BFu8c_BFu1i()
{
  {
    init_simple_test("Ip_BFu8c_BFu1i");
    static STRUCT_IF_C Ip_BFu8c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu1i, Ip_BFu8c_BFu1i)
//============================================================================


struct  Ip_BFu8c_BFu1ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu8c_BFu1ll) C1{ Fp Fc:8 FL:1}



static void Test_Ip_BFu8c_BFu1ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu1ll");
    static STRUCT_IF_C Ip_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu1ll, Ip_BFu8c_BFu1ll)
//============================================================================


struct  Ip_BFu8c_BFu1s  {
  int *v1;
  unsigned char v2:8;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu8c_BFu1s) C1{ Fp Fc:8 Fs:1}



static void Test_Ip_BFu8c_BFu1s()
{
  {
    init_simple_test("Ip_BFu8c_BFu1s");
    static STRUCT_IF_C Ip_BFu8c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu1s, Ip_BFu8c_BFu1s)
//============================================================================


struct  Ip_BFu8c_BFu31i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu8c_BFu31i) C1{ Fp Fc:8 Fi:31}



static void Test_Ip_BFu8c_BFu31i()
{
  {
    init_simple_test("Ip_BFu8c_BFu31i");
    static STRUCT_IF_C Ip_BFu8c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu31i, Ip_BFu8c_BFu31i)
//============================================================================


struct  Ip_BFu8c_BFu31ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu8c_BFu31ll) C1{ Fp Fc:8 FL:31}



static void Test_Ip_BFu8c_BFu31ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu31ll");
    static STRUCT_IF_C Ip_BFu8c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Ip_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Ip_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu31ll, Ip_BFu8c_BFu31ll)
//============================================================================


struct  Ip_BFu8c_BFu32i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu8c_BFu32i) C1{ Fp Fc:8 Fi:32}



static void Test_Ip_BFu8c_BFu32i()
{
  {
    init_simple_test("Ip_BFu8c_BFu32i");
    static STRUCT_IF_C Ip_BFu8c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu32i, Ip_BFu8c_BFu32i)
//============================================================================


struct  Ip_BFu8c_BFu32ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu8c_BFu32ll) C1{ Fp Fc:8 FL:32}



static void Test_Ip_BFu8c_BFu32ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu32ll");
    static STRUCT_IF_C Ip_BFu8c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Ip_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Ip_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu32ll, Ip_BFu8c_BFu32ll)
//============================================================================


struct  Ip_BFu8c_BFu33  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu8c_BFu33) C1{ Fp Fc:8 FL:33}



static void Test_Ip_BFu8c_BFu33()
{
  {
    init_simple_test("Ip_BFu8c_BFu33");
    static STRUCT_IF_C Ip_BFu8c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "Ip_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "Ip_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu33, Ip_BFu8c_BFu33)
//============================================================================


struct  Ip_BFu8c_BFu7c  {
  int *v1;
  unsigned char v2:8;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu8c_BFu7c) C1{ Fp Fc:8 Fc:7}



static void Test_Ip_BFu8c_BFu7c()
{
  {
    init_simple_test("Ip_BFu8c_BFu7c");
    static STRUCT_IF_C Ip_BFu8c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu7c, Ip_BFu8c_BFu7c)
//============================================================================


struct  Ip_BFu8c_BFu7i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu8c_BFu7i) C1{ Fp Fc:8 Fi:7}



static void Test_Ip_BFu8c_BFu7i()
{
  {
    init_simple_test("Ip_BFu8c_BFu7i");
    static STRUCT_IF_C Ip_BFu8c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu7i, Ip_BFu8c_BFu7i)
//============================================================================


struct  Ip_BFu8c_BFu7ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu8c_BFu7ll) C1{ Fp Fc:8 FL:7}



static void Test_Ip_BFu8c_BFu7ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu7ll");
    static STRUCT_IF_C Ip_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu7ll, Ip_BFu8c_BFu7ll)
//============================================================================


struct  Ip_BFu8c_BFu7s  {
  int *v1;
  unsigned char v2:8;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu8c_BFu7s) C1{ Fp Fc:8 Fs:7}



static void Test_Ip_BFu8c_BFu7s()
{
  {
    init_simple_test("Ip_BFu8c_BFu7s");
    static STRUCT_IF_C Ip_BFu8c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu7s, Ip_BFu8c_BFu7s)
//============================================================================


struct  Ip_BFu8c_BFu8c  {
  int *v1;
  unsigned char v2:8;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu8c_BFu8c) C1{ Fp Fc:8 Fc:8}



static void Test_Ip_BFu8c_BFu8c()
{
  {
    init_simple_test("Ip_BFu8c_BFu8c");
    static STRUCT_IF_C Ip_BFu8c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu8c, Ip_BFu8c_BFu8c)
//============================================================================


struct  Ip_BFu8c_BFu8i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu8c_BFu8i) C1{ Fp Fc:8 Fi:8}



static void Test_Ip_BFu8c_BFu8i()
{
  {
    init_simple_test("Ip_BFu8c_BFu8i");
    static STRUCT_IF_C Ip_BFu8c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu8i, Ip_BFu8c_BFu8i)
//============================================================================


struct  Ip_BFu8c_BFu8ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu8c_BFu8ll) C1{ Fp Fc:8 FL:8}



static void Test_Ip_BFu8c_BFu8ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu8ll");
    static STRUCT_IF_C Ip_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu8ll, Ip_BFu8c_BFu8ll)
//============================================================================


struct  Ip_BFu8c_BFu8s  {
  int *v1;
  unsigned char v2:8;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu8c_BFu8s) C1{ Fp Fc:8 Fs:8}



static void Test_Ip_BFu8c_BFu8s()
{
  {
    init_simple_test("Ip_BFu8c_BFu8s");
    static STRUCT_IF_C Ip_BFu8c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu8s, Ip_BFu8c_BFu8s)
//============================================================================


struct  Ip_BFu8c_BFu9i  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu8c_BFu9i) C1{ Fp Fc:8 Fi:9}



static void Test_Ip_BFu8c_BFu9i()
{
  {
    init_simple_test("Ip_BFu8c_BFu9i");
    static STRUCT_IF_C Ip_BFu8c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu9i, Ip_BFu8c_BFu9i)
//============================================================================


struct  Ip_BFu8c_BFu9ll  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu8c_BFu9ll) C1{ Fp Fc:8 FL:9}



static void Test_Ip_BFu8c_BFu9ll()
{
  {
    init_simple_test("Ip_BFu8c_BFu9ll");
    static STRUCT_IF_C Ip_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu9ll, Ip_BFu8c_BFu9ll)
//============================================================================


struct  Ip_BFu8c_BFu9s  {
  int *v1;
  unsigned char v2:8;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu8c_BFu9s) C1{ Fp Fc:8 Fs:9}



static void Test_Ip_BFu8c_BFu9s()
{
  {
    init_simple_test("Ip_BFu8c_BFu9s");
    static STRUCT_IF_C Ip_BFu8c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_BFu9s, Ip_BFu8c_BFu9s)
//============================================================================


struct  Ip_BFu8c_C  {
  int *v1;
  unsigned char v2:8;
  char v3;
};
//SIG(1 Ip_BFu8c_C) C1{ Fp Fc:8 Fc}



static void Test_Ip_BFu8c_C()
{
  {
    init_simple_test("Ip_BFu8c_C");
    static STRUCT_IF_C Ip_BFu8c_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_C, Ip_BFu8c_C)
//============================================================================


struct  Ip_BFu8c_D  {
  int *v1;
  unsigned char v2:8;
  double v3;
};
//SIG(1 Ip_BFu8c_D) C1{ Fp Fc:8 FL}



static void Test_Ip_BFu8c_D()
{
  {
    init_simple_test("Ip_BFu8c_D");
    static STRUCT_IF_C Ip_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_D, Ip_BFu8c_D)
//============================================================================


struct  Ip_BFu8c_F  {
  int *v1;
  unsigned char v2:8;
  float v3;
};
//SIG(1 Ip_BFu8c_F) C1{ Fp Fc:8 Fi}



static void Test_Ip_BFu8c_F()
{
  {
    init_simple_test("Ip_BFu8c_F");
    static STRUCT_IF_C Ip_BFu8c_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_F, Ip_BFu8c_F)
//============================================================================


struct  Ip_BFu8c_I  {
  int *v1;
  unsigned char v2:8;
  int v3;
};
//SIG(1 Ip_BFu8c_I) C1{ Fp Fc:8 Fi}



static void Test_Ip_BFu8c_I()
{
  {
    init_simple_test("Ip_BFu8c_I");
    static STRUCT_IF_C Ip_BFu8c_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_I, Ip_BFu8c_I)
//============================================================================


struct  Ip_BFu8c_Ip  {
  int *v1;
  unsigned char v2:8;
  int *v3;
};
//SIG(1 Ip_BFu8c_Ip) C1{ Fp Fc:8 Fp}



static void Test_Ip_BFu8c_Ip()
{
  {
    init_simple_test("Ip_BFu8c_Ip");
    static STRUCT_IF_C Ip_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_Ip, Ip_BFu8c_Ip)
//============================================================================


struct  Ip_BFu8c_L  {
  int *v1;
  unsigned char v2:8;
  __tsi64 v3;
};
//SIG(1 Ip_BFu8c_L) C1{ Fp Fc:8 FL}



static void Test_Ip_BFu8c_L()
{
  {
    init_simple_test("Ip_BFu8c_L");
    static STRUCT_IF_C Ip_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_L, Ip_BFu8c_L)
//============================================================================


struct  Ip_BFu8c_S  {
  int *v1;
  unsigned char v2:8;
  short v3;
};
//SIG(1 Ip_BFu8c_S) C1{ Fp Fc:8 Fs}



static void Test_Ip_BFu8c_S()
{
  {
    init_simple_test("Ip_BFu8c_S");
    static STRUCT_IF_C Ip_BFu8c_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_S, Ip_BFu8c_S)
//============================================================================


struct  Ip_BFu8c_Uc  {
  int *v1;
  unsigned char v2:8;
  unsigned char v3;
};
//SIG(1 Ip_BFu8c_Uc) C1{ Fp Fc:8 Fc}



static void Test_Ip_BFu8c_Uc()
{
  {
    init_simple_test("Ip_BFu8c_Uc");
    static STRUCT_IF_C Ip_BFu8c_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_Uc, Ip_BFu8c_Uc)
//============================================================================


struct  Ip_BFu8c_Ui  {
  int *v1;
  unsigned char v2:8;
  unsigned int v3;
};
//SIG(1 Ip_BFu8c_Ui) C1{ Fp Fc:8 Fi}



static void Test_Ip_BFu8c_Ui()
{
  {
    init_simple_test("Ip_BFu8c_Ui");
    static STRUCT_IF_C Ip_BFu8c_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_Ui, Ip_BFu8c_Ui)
//============================================================================


struct  Ip_BFu8c_Ul  {
  int *v1;
  unsigned char v2:8;
  __tsu64 v3;
};
//SIG(1 Ip_BFu8c_Ul) C1{ Fp Fc:8 FL}



static void Test_Ip_BFu8c_Ul()
{
  {
    init_simple_test("Ip_BFu8c_Ul");
    static STRUCT_IF_C Ip_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_Ul, Ip_BFu8c_Ul)
//============================================================================


struct  Ip_BFu8c_Us  {
  int *v1;
  unsigned char v2:8;
  unsigned short v3;
};
//SIG(1 Ip_BFu8c_Us) C1{ Fp Fc:8 Fs}



static void Test_Ip_BFu8c_Us()
{
  {
    init_simple_test("Ip_BFu8c_Us");
    static STRUCT_IF_C Ip_BFu8c_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_Us, Ip_BFu8c_Us)
//============================================================================


struct  Ip_BFu8c_Vp  {
  int *v1;
  unsigned char v2:8;
  void *v3;
};
//SIG(1 Ip_BFu8c_Vp) C1{ Fp Fc:8 Fp}



static void Test_Ip_BFu8c_Vp()
{
  {
    init_simple_test("Ip_BFu8c_Vp");
    static STRUCT_IF_C Ip_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8c_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8c_Vp, Ip_BFu8c_Vp)
//============================================================================


struct  Ip_BFu8i  {
  int *v1;
  unsigned int v2:8;
};
//SIG(1 Ip_BFu8i) C1{ Fp Fi:8}



static void Test_Ip_BFu8i()
{
  {
    init_simple_test("Ip_BFu8i");
    static STRUCT_IF_C Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i, Ip_BFu8i)
//============================================================================


struct  Ip_BFu8i_BFu15i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu8i_BFu15i) C1{ Fp Fi:8 Fi:15}



static void Test_Ip_BFu8i_BFu15i()
{
  {
    init_simple_test("Ip_BFu8i_BFu15i");
    static STRUCT_IF_C Ip_BFu8i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu15i, Ip_BFu8i_BFu15i)
//============================================================================


struct  Ip_BFu8i_BFu15ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu8i_BFu15ll) C1{ Fp Fi:8 FL:15}



static void Test_Ip_BFu8i_BFu15ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu15ll");
    static STRUCT_IF_C Ip_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu15ll, Ip_BFu8i_BFu15ll)
//============================================================================


struct  Ip_BFu8i_BFu15s  {
  int *v1;
  unsigned int v2:8;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu8i_BFu15s) C1{ Fp Fi:8 Fs:15}



static void Test_Ip_BFu8i_BFu15s()
{
  {
    init_simple_test("Ip_BFu8i_BFu15s");
    static STRUCT_IF_C Ip_BFu8i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu15s, Ip_BFu8i_BFu15s)
//============================================================================


struct  Ip_BFu8i_BFu16i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu8i_BFu16i) C1{ Fp Fi:8 Fi:16}



static void Test_Ip_BFu8i_BFu16i()
{
  {
    init_simple_test("Ip_BFu8i_BFu16i");
    static STRUCT_IF_C Ip_BFu8i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu16i, Ip_BFu8i_BFu16i)
//============================================================================


struct  Ip_BFu8i_BFu16ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu8i_BFu16ll) C1{ Fp Fi:8 FL:16}



static void Test_Ip_BFu8i_BFu16ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu16ll");
    static STRUCT_IF_C Ip_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu16ll, Ip_BFu8i_BFu16ll)
//============================================================================


struct  Ip_BFu8i_BFu16s  {
  int *v1;
  unsigned int v2:8;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu8i_BFu16s) C1{ Fp Fi:8 Fs:16}



static void Test_Ip_BFu8i_BFu16s()
{
  {
    init_simple_test("Ip_BFu8i_BFu16s");
    static STRUCT_IF_C Ip_BFu8i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu16s, Ip_BFu8i_BFu16s)
//============================================================================


struct  Ip_BFu8i_BFu17i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu8i_BFu17i) C1{ Fp Fi:8 Fi:17}



static void Test_Ip_BFu8i_BFu17i()
{
  {
    init_simple_test("Ip_BFu8i_BFu17i");
    static STRUCT_IF_C Ip_BFu8i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu17i, Ip_BFu8i_BFu17i)
//============================================================================


struct  Ip_BFu8i_BFu17ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu8i_BFu17ll) C1{ Fp Fi:8 FL:17}



static void Test_Ip_BFu8i_BFu17ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu17ll");
    static STRUCT_IF_C Ip_BFu8i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu17ll, Ip_BFu8i_BFu17ll)
//============================================================================


struct  Ip_BFu8i_BFu1c  {
  int *v1;
  unsigned int v2:8;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu8i_BFu1c) C1{ Fp Fi:8 Fc:1}



static void Test_Ip_BFu8i_BFu1c()
{
  {
    init_simple_test("Ip_BFu8i_BFu1c");
    static STRUCT_IF_C Ip_BFu8i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu1c, Ip_BFu8i_BFu1c)
//============================================================================


struct  Ip_BFu8i_BFu1i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu8i_BFu1i) C1{ Fp Fi:8 Fi:1}



static void Test_Ip_BFu8i_BFu1i()
{
  {
    init_simple_test("Ip_BFu8i_BFu1i");
    static STRUCT_IF_C Ip_BFu8i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu1i, Ip_BFu8i_BFu1i)
//============================================================================


struct  Ip_BFu8i_BFu1ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu8i_BFu1ll) C1{ Fp Fi:8 FL:1}



static void Test_Ip_BFu8i_BFu1ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu1ll");
    static STRUCT_IF_C Ip_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu1ll, Ip_BFu8i_BFu1ll)
//============================================================================


struct  Ip_BFu8i_BFu1s  {
  int *v1;
  unsigned int v2:8;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu8i_BFu1s) C1{ Fp Fi:8 Fs:1}



static void Test_Ip_BFu8i_BFu1s()
{
  {
    init_simple_test("Ip_BFu8i_BFu1s");
    static STRUCT_IF_C Ip_BFu8i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu1s, Ip_BFu8i_BFu1s)
//============================================================================


struct  Ip_BFu8i_BFu31i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu8i_BFu31i) C1{ Fp Fi:8 Fi:31}



static void Test_Ip_BFu8i_BFu31i()
{
  {
    init_simple_test("Ip_BFu8i_BFu31i");
    static STRUCT_IF_C Ip_BFu8i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu31i, Ip_BFu8i_BFu31i)
//============================================================================


struct  Ip_BFu8i_BFu31ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu8i_BFu31ll) C1{ Fp Fi:8 FL:31}



static void Test_Ip_BFu8i_BFu31ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu31ll");
    static STRUCT_IF_C Ip_BFu8i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Ip_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Ip_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu31ll, Ip_BFu8i_BFu31ll)
//============================================================================


struct  Ip_BFu8i_BFu32i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu8i_BFu32i) C1{ Fp Fi:8 Fi:32}



static void Test_Ip_BFu8i_BFu32i()
{
  {
    init_simple_test("Ip_BFu8i_BFu32i");
    static STRUCT_IF_C Ip_BFu8i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu32i, Ip_BFu8i_BFu32i)
//============================================================================


struct  Ip_BFu8i_BFu32ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu8i_BFu32ll) C1{ Fp Fi:8 FL:32}



static void Test_Ip_BFu8i_BFu32ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu32ll");
    static STRUCT_IF_C Ip_BFu8i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Ip_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Ip_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu32ll, Ip_BFu8i_BFu32ll)
//============================================================================


struct  Ip_BFu8i_BFu33  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu8i_BFu33) C1{ Fp Fi:8 FL:33}



static void Test_Ip_BFu8i_BFu33()
{
  {
    init_simple_test("Ip_BFu8i_BFu33");
    static STRUCT_IF_C Ip_BFu8i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "Ip_BFu8i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "Ip_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu33, Ip_BFu8i_BFu33)
//============================================================================


struct  Ip_BFu8i_BFu7c  {
  int *v1;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu8i_BFu7c) C1{ Fp Fi:8 Fc:7}



static void Test_Ip_BFu8i_BFu7c()
{
  {
    init_simple_test("Ip_BFu8i_BFu7c");
    static STRUCT_IF_C Ip_BFu8i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu7c, Ip_BFu8i_BFu7c)
//============================================================================


struct  Ip_BFu8i_BFu7i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu8i_BFu7i) C1{ Fp Fi:8 Fi:7}



static void Test_Ip_BFu8i_BFu7i()
{
  {
    init_simple_test("Ip_BFu8i_BFu7i");
    static STRUCT_IF_C Ip_BFu8i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu7i, Ip_BFu8i_BFu7i)
//============================================================================


struct  Ip_BFu8i_BFu7ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu8i_BFu7ll) C1{ Fp Fi:8 FL:7}



static void Test_Ip_BFu8i_BFu7ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu7ll");
    static STRUCT_IF_C Ip_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu7ll, Ip_BFu8i_BFu7ll)
//============================================================================


struct  Ip_BFu8i_BFu7s  {
  int *v1;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu8i_BFu7s) C1{ Fp Fi:8 Fs:7}



static void Test_Ip_BFu8i_BFu7s()
{
  {
    init_simple_test("Ip_BFu8i_BFu7s");
    static STRUCT_IF_C Ip_BFu8i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu7s, Ip_BFu8i_BFu7s)
//============================================================================


struct  Ip_BFu8i_BFu8c  {
  int *v1;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu8i_BFu8c) C1{ Fp Fi:8 Fc:8}



static void Test_Ip_BFu8i_BFu8c()
{
  {
    init_simple_test("Ip_BFu8i_BFu8c");
    static STRUCT_IF_C Ip_BFu8i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu8c, Ip_BFu8i_BFu8c)
//============================================================================


struct  Ip_BFu8i_BFu8i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu8i_BFu8i) C1{ Fp Fi:8 Fi:8}



static void Test_Ip_BFu8i_BFu8i()
{
  {
    init_simple_test("Ip_BFu8i_BFu8i");
    static STRUCT_IF_C Ip_BFu8i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu8i, Ip_BFu8i_BFu8i)
//============================================================================


struct  Ip_BFu8i_BFu8ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu8i_BFu8ll) C1{ Fp Fi:8 FL:8}



static void Test_Ip_BFu8i_BFu8ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu8ll");
    static STRUCT_IF_C Ip_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu8ll, Ip_BFu8i_BFu8ll)
//============================================================================


struct  Ip_BFu8i_BFu8s  {
  int *v1;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu8i_BFu8s) C1{ Fp Fi:8 Fs:8}



static void Test_Ip_BFu8i_BFu8s()
{
  {
    init_simple_test("Ip_BFu8i_BFu8s");
    static STRUCT_IF_C Ip_BFu8i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu8s, Ip_BFu8i_BFu8s)
//============================================================================


struct  Ip_BFu8i_BFu9i  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu8i_BFu9i) C1{ Fp Fi:8 Fi:9}



static void Test_Ip_BFu8i_BFu9i()
{
  {
    init_simple_test("Ip_BFu8i_BFu9i");
    static STRUCT_IF_C Ip_BFu8i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu9i, Ip_BFu8i_BFu9i)
//============================================================================


struct  Ip_BFu8i_BFu9ll  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu8i_BFu9ll) C1{ Fp Fi:8 FL:9}



static void Test_Ip_BFu8i_BFu9ll()
{
  {
    init_simple_test("Ip_BFu8i_BFu9ll");
    static STRUCT_IF_C Ip_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu9ll, Ip_BFu8i_BFu9ll)
//============================================================================


struct  Ip_BFu8i_BFu9s  {
  int *v1;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu8i_BFu9s) C1{ Fp Fi:8 Fs:9}



static void Test_Ip_BFu8i_BFu9s()
{
  {
    init_simple_test("Ip_BFu8i_BFu9s");
    static STRUCT_IF_C Ip_BFu8i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_BFu9s, Ip_BFu8i_BFu9s)
//============================================================================


struct  Ip_BFu8i_C  {
  int *v1;
  unsigned int v2:8;
  char v3;
};
//SIG(1 Ip_BFu8i_C) C1{ Fp Fi:8 Fc}



static void Test_Ip_BFu8i_C()
{
  {
    init_simple_test("Ip_BFu8i_C");
    static STRUCT_IF_C Ip_BFu8i_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_C, Ip_BFu8i_C)
//============================================================================


struct  Ip_BFu8i_D  {
  int *v1;
  unsigned int v2:8;
  double v3;
};
//SIG(1 Ip_BFu8i_D) C1{ Fp Fi:8 FL}



static void Test_Ip_BFu8i_D()
{
  {
    init_simple_test("Ip_BFu8i_D");
    static STRUCT_IF_C Ip_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_D, Ip_BFu8i_D)
//============================================================================


struct  Ip_BFu8i_F  {
  int *v1;
  unsigned int v2:8;
  float v3;
};
//SIG(1 Ip_BFu8i_F) C1{ Fp Fi:8 Fi}



static void Test_Ip_BFu8i_F()
{
  {
    init_simple_test("Ip_BFu8i_F");
    static STRUCT_IF_C Ip_BFu8i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_F, Ip_BFu8i_F)
//============================================================================


struct  Ip_BFu8i_I  {
  int *v1;
  unsigned int v2:8;
  int v3;
};
//SIG(1 Ip_BFu8i_I) C1{ Fp Fi:8 Fi}



static void Test_Ip_BFu8i_I()
{
  {
    init_simple_test("Ip_BFu8i_I");
    static STRUCT_IF_C Ip_BFu8i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_I, Ip_BFu8i_I)
//============================================================================


struct  Ip_BFu8i_Ip  {
  int *v1;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 Ip_BFu8i_Ip) C1{ Fp Fi:8 Fp}



static void Test_Ip_BFu8i_Ip()
{
  {
    init_simple_test("Ip_BFu8i_Ip");
    static STRUCT_IF_C Ip_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_Ip, Ip_BFu8i_Ip)
//============================================================================


struct  Ip_BFu8i_L  {
  int *v1;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 Ip_BFu8i_L) C1{ Fp Fi:8 FL}



static void Test_Ip_BFu8i_L()
{
  {
    init_simple_test("Ip_BFu8i_L");
    static STRUCT_IF_C Ip_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_L, Ip_BFu8i_L)
//============================================================================


struct  Ip_BFu8i_S  {
  int *v1;
  unsigned int v2:8;
  short v3;
};
//SIG(1 Ip_BFu8i_S) C1{ Fp Fi:8 Fs}



static void Test_Ip_BFu8i_S()
{
  {
    init_simple_test("Ip_BFu8i_S");
    static STRUCT_IF_C Ip_BFu8i_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_S, Ip_BFu8i_S)
//============================================================================


struct  Ip_BFu8i_Uc  {
  int *v1;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 Ip_BFu8i_Uc) C1{ Fp Fi:8 Fc}



static void Test_Ip_BFu8i_Uc()
{
  {
    init_simple_test("Ip_BFu8i_Uc");
    static STRUCT_IF_C Ip_BFu8i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_Uc, Ip_BFu8i_Uc)
//============================================================================


struct  Ip_BFu8i_Ui  {
  int *v1;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 Ip_BFu8i_Ui) C1{ Fp Fi:8 Fi}



static void Test_Ip_BFu8i_Ui()
{
  {
    init_simple_test("Ip_BFu8i_Ui");
    static STRUCT_IF_C Ip_BFu8i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_Ui, Ip_BFu8i_Ui)
//============================================================================


struct  Ip_BFu8i_Ul  {
  int *v1;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 Ip_BFu8i_Ul) C1{ Fp Fi:8 FL}



static void Test_Ip_BFu8i_Ul()
{
  {
    init_simple_test("Ip_BFu8i_Ul");
    static STRUCT_IF_C Ip_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_Ul, Ip_BFu8i_Ul)
//============================================================================


struct  Ip_BFu8i_Us  {
  int *v1;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 Ip_BFu8i_Us) C1{ Fp Fi:8 Fs}



static void Test_Ip_BFu8i_Us()
{
  {
    init_simple_test("Ip_BFu8i_Us");
    static STRUCT_IF_C Ip_BFu8i_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_Us, Ip_BFu8i_Us)
//============================================================================


struct  Ip_BFu8i_Vp  {
  int *v1;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 Ip_BFu8i_Vp) C1{ Fp Fi:8 Fp}



static void Test_Ip_BFu8i_Vp()
{
  {
    init_simple_test("Ip_BFu8i_Vp");
    static STRUCT_IF_C Ip_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8i_Vp, Ip_BFu8i_Vp)
//============================================================================


struct  Ip_BFu8ll  {
  int *v1;
  __tsu64 v2:8;
};
//SIG(1 Ip_BFu8ll) C1{ Fp FL:8}



static void Test_Ip_BFu8ll()
{
  {
    init_simple_test("Ip_BFu8ll");
    static STRUCT_IF_C Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll, Ip_BFu8ll)
//============================================================================


struct  Ip_BFu8ll_BFu15i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu8ll_BFu15i) C1{ Fp FL:8 Fi:15}



static void Test_Ip_BFu8ll_BFu15i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu15i");
    static STRUCT_IF_C Ip_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu15i, Ip_BFu8ll_BFu15i)
//============================================================================


struct  Ip_BFu8ll_BFu15ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu8ll_BFu15ll) C1{ Fp FL:8 FL:15}



static void Test_Ip_BFu8ll_BFu15ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu15ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu15ll, Ip_BFu8ll_BFu15ll)
//============================================================================


struct  Ip_BFu8ll_BFu15s  {
  int *v1;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu8ll_BFu15s) C1{ Fp FL:8 Fs:15}



static void Test_Ip_BFu8ll_BFu15s()
{
  {
    init_simple_test("Ip_BFu8ll_BFu15s");
    static STRUCT_IF_C Ip_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu15s, Ip_BFu8ll_BFu15s)
//============================================================================


struct  Ip_BFu8ll_BFu16i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu8ll_BFu16i) C1{ Fp FL:8 Fi:16}



static void Test_Ip_BFu8ll_BFu16i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu16i");
    static STRUCT_IF_C Ip_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu16i, Ip_BFu8ll_BFu16i)
//============================================================================


struct  Ip_BFu8ll_BFu16ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu8ll_BFu16ll) C1{ Fp FL:8 FL:16}



static void Test_Ip_BFu8ll_BFu16ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu16ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu16ll, Ip_BFu8ll_BFu16ll)
//============================================================================


struct  Ip_BFu8ll_BFu16s  {
  int *v1;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu8ll_BFu16s) C1{ Fp FL:8 Fs:16}



static void Test_Ip_BFu8ll_BFu16s()
{
  {
    init_simple_test("Ip_BFu8ll_BFu16s");
    static STRUCT_IF_C Ip_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu16s, Ip_BFu8ll_BFu16s)
//============================================================================


struct  Ip_BFu8ll_BFu17i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu8ll_BFu17i) C1{ Fp FL:8 Fi:17}



static void Test_Ip_BFu8ll_BFu17i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu17i");
    static STRUCT_IF_C Ip_BFu8ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu17i, Ip_BFu8ll_BFu17i)
//============================================================================


struct  Ip_BFu8ll_BFu17ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu8ll_BFu17ll) C1{ Fp FL:8 FL:17}



static void Test_Ip_BFu8ll_BFu17ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu17ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu17ll, Ip_BFu8ll_BFu17ll)
//============================================================================


struct  Ip_BFu8ll_BFu1c  {
  int *v1;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu8ll_BFu1c) C1{ Fp FL:8 Fc:1}



static void Test_Ip_BFu8ll_BFu1c()
{
  {
    init_simple_test("Ip_BFu8ll_BFu1c");
    static STRUCT_IF_C Ip_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu1c, Ip_BFu8ll_BFu1c)
//============================================================================


struct  Ip_BFu8ll_BFu1i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu8ll_BFu1i) C1{ Fp FL:8 Fi:1}



static void Test_Ip_BFu8ll_BFu1i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu1i");
    static STRUCT_IF_C Ip_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu1i, Ip_BFu8ll_BFu1i)
//============================================================================


struct  Ip_BFu8ll_BFu1ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu8ll_BFu1ll) C1{ Fp FL:8 FL:1}



static void Test_Ip_BFu8ll_BFu1ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu1ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu1ll, Ip_BFu8ll_BFu1ll)
//============================================================================


struct  Ip_BFu8ll_BFu1s  {
  int *v1;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu8ll_BFu1s) C1{ Fp FL:8 Fs:1}



static void Test_Ip_BFu8ll_BFu1s()
{
  {
    init_simple_test("Ip_BFu8ll_BFu1s");
    static STRUCT_IF_C Ip_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu1s, Ip_BFu8ll_BFu1s)
//============================================================================


struct  Ip_BFu8ll_BFu31i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu8ll_BFu31i) C1{ Fp FL:8 Fi:31}



static void Test_Ip_BFu8ll_BFu31i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu31i");
    static STRUCT_IF_C Ip_BFu8ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu31i, Ip_BFu8ll_BFu31i)
//============================================================================


struct  Ip_BFu8ll_BFu31ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu8ll_BFu31ll) C1{ Fp FL:8 FL:31}



static void Test_Ip_BFu8ll_BFu31ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu31ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Ip_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Ip_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu31ll, Ip_BFu8ll_BFu31ll)
//============================================================================


struct  Ip_BFu8ll_BFu32i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu8ll_BFu32i) C1{ Fp FL:8 Fi:32}



static void Test_Ip_BFu8ll_BFu32i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu32i");
    static STRUCT_IF_C Ip_BFu8ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu32i, Ip_BFu8ll_BFu32i)
//============================================================================


struct  Ip_BFu8ll_BFu32ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu8ll_BFu32ll) C1{ Fp FL:8 FL:32}



static void Test_Ip_BFu8ll_BFu32ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu32ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Ip_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Ip_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu32ll, Ip_BFu8ll_BFu32ll)
//============================================================================


struct  Ip_BFu8ll_BFu33  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu8ll_BFu33) C1{ Fp FL:8 FL:33}



static void Test_Ip_BFu8ll_BFu33()
{
  {
    init_simple_test("Ip_BFu8ll_BFu33");
    static STRUCT_IF_C Ip_BFu8ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "Ip_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "Ip_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu33, Ip_BFu8ll_BFu33)
//============================================================================


struct  Ip_BFu8ll_BFu7c  {
  int *v1;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu8ll_BFu7c) C1{ Fp FL:8 Fc:7}



static void Test_Ip_BFu8ll_BFu7c()
{
  {
    init_simple_test("Ip_BFu8ll_BFu7c");
    static STRUCT_IF_C Ip_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu7c, Ip_BFu8ll_BFu7c)
//============================================================================


struct  Ip_BFu8ll_BFu7i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu8ll_BFu7i) C1{ Fp FL:8 Fi:7}



static void Test_Ip_BFu8ll_BFu7i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu7i");
    static STRUCT_IF_C Ip_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu7i, Ip_BFu8ll_BFu7i)
//============================================================================


struct  Ip_BFu8ll_BFu7ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu8ll_BFu7ll) C1{ Fp FL:8 FL:7}



static void Test_Ip_BFu8ll_BFu7ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu7ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu7ll, Ip_BFu8ll_BFu7ll)
//============================================================================


struct  Ip_BFu8ll_BFu7s  {
  int *v1;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu8ll_BFu7s) C1{ Fp FL:8 Fs:7}



static void Test_Ip_BFu8ll_BFu7s()
{
  {
    init_simple_test("Ip_BFu8ll_BFu7s");
    static STRUCT_IF_C Ip_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu7s, Ip_BFu8ll_BFu7s)
//============================================================================


struct  Ip_BFu8ll_BFu8c  {
  int *v1;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu8ll_BFu8c) C1{ Fp FL:8 Fc:8}



static void Test_Ip_BFu8ll_BFu8c()
{
  {
    init_simple_test("Ip_BFu8ll_BFu8c");
    static STRUCT_IF_C Ip_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu8c, Ip_BFu8ll_BFu8c)
//============================================================================


struct  Ip_BFu8ll_BFu8i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu8ll_BFu8i) C1{ Fp FL:8 Fi:8}



static void Test_Ip_BFu8ll_BFu8i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu8i");
    static STRUCT_IF_C Ip_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu8i, Ip_BFu8ll_BFu8i)
//============================================================================


struct  Ip_BFu8ll_BFu8ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu8ll_BFu8ll) C1{ Fp FL:8 FL:8}



static void Test_Ip_BFu8ll_BFu8ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu8ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu8ll, Ip_BFu8ll_BFu8ll)
//============================================================================


struct  Ip_BFu8ll_BFu8s  {
  int *v1;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu8ll_BFu8s) C1{ Fp FL:8 Fs:8}



static void Test_Ip_BFu8ll_BFu8s()
{
  {
    init_simple_test("Ip_BFu8ll_BFu8s");
    static STRUCT_IF_C Ip_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu8s, Ip_BFu8ll_BFu8s)
//============================================================================


struct  Ip_BFu8ll_BFu9i  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu8ll_BFu9i) C1{ Fp FL:8 Fi:9}



static void Test_Ip_BFu8ll_BFu9i()
{
  {
    init_simple_test("Ip_BFu8ll_BFu9i");
    static STRUCT_IF_C Ip_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu9i, Ip_BFu8ll_BFu9i)
//============================================================================


struct  Ip_BFu8ll_BFu9ll  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu8ll_BFu9ll) C1{ Fp FL:8 FL:9}



static void Test_Ip_BFu8ll_BFu9ll()
{
  {
    init_simple_test("Ip_BFu8ll_BFu9ll");
    static STRUCT_IF_C Ip_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu9ll, Ip_BFu8ll_BFu9ll)
//============================================================================


struct  Ip_BFu8ll_BFu9s  {
  int *v1;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu8ll_BFu9s) C1{ Fp FL:8 Fs:9}



static void Test_Ip_BFu8ll_BFu9s()
{
  {
    init_simple_test("Ip_BFu8ll_BFu9s");
    static STRUCT_IF_C Ip_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_BFu9s, Ip_BFu8ll_BFu9s)
//============================================================================


struct  Ip_BFu8ll_C  {
  int *v1;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 Ip_BFu8ll_C) C1{ Fp FL:8 Fc}



static void Test_Ip_BFu8ll_C()
{
  {
    init_simple_test("Ip_BFu8ll_C");
    static STRUCT_IF_C Ip_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_C, Ip_BFu8ll_C)
//============================================================================


struct  Ip_BFu8ll_D  {
  int *v1;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 Ip_BFu8ll_D) C1{ Fp FL:8 FL}



static void Test_Ip_BFu8ll_D()
{
  {
    init_simple_test("Ip_BFu8ll_D");
    static STRUCT_IF_C Ip_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_D, Ip_BFu8ll_D)
//============================================================================


struct  Ip_BFu8ll_F  {
  int *v1;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 Ip_BFu8ll_F) C1{ Fp FL:8 Fi}



static void Test_Ip_BFu8ll_F()
{
  {
    init_simple_test("Ip_BFu8ll_F");
    static STRUCT_IF_C Ip_BFu8ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_F, Ip_BFu8ll_F)
//============================================================================


struct  Ip_BFu8ll_I  {
  int *v1;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 Ip_BFu8ll_I) C1{ Fp FL:8 Fi}



static void Test_Ip_BFu8ll_I()
{
  {
    init_simple_test("Ip_BFu8ll_I");
    static STRUCT_IF_C Ip_BFu8ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_I, Ip_BFu8ll_I)
//============================================================================


struct  Ip_BFu8ll_Ip  {
  int *v1;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 Ip_BFu8ll_Ip) C1{ Fp FL:8 Fp}



static void Test_Ip_BFu8ll_Ip()
{
  {
    init_simple_test("Ip_BFu8ll_Ip");
    static STRUCT_IF_C Ip_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_Ip, Ip_BFu8ll_Ip)
//============================================================================


struct  Ip_BFu8ll_L  {
  int *v1;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 Ip_BFu8ll_L) C1{ Fp FL:8 FL}



static void Test_Ip_BFu8ll_L()
{
  {
    init_simple_test("Ip_BFu8ll_L");
    static STRUCT_IF_C Ip_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_L, Ip_BFu8ll_L)
//============================================================================


struct  Ip_BFu8ll_S  {
  int *v1;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 Ip_BFu8ll_S) C1{ Fp FL:8 Fs}



static void Test_Ip_BFu8ll_S()
{
  {
    init_simple_test("Ip_BFu8ll_S");
    static STRUCT_IF_C Ip_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_S, Ip_BFu8ll_S)
//============================================================================


struct  Ip_BFu8ll_Uc  {
  int *v1;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 Ip_BFu8ll_Uc) C1{ Fp FL:8 Fc}



static void Test_Ip_BFu8ll_Uc()
{
  {
    init_simple_test("Ip_BFu8ll_Uc");
    static STRUCT_IF_C Ip_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_Uc, Ip_BFu8ll_Uc)
//============================================================================


struct  Ip_BFu8ll_Ui  {
  int *v1;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 Ip_BFu8ll_Ui) C1{ Fp FL:8 Fi}



static void Test_Ip_BFu8ll_Ui()
{
  {
    init_simple_test("Ip_BFu8ll_Ui");
    static STRUCT_IF_C Ip_BFu8ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_Ui, Ip_BFu8ll_Ui)
//============================================================================


struct  Ip_BFu8ll_Ul  {
  int *v1;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 Ip_BFu8ll_Ul) C1{ Fp FL:8 FL}



static void Test_Ip_BFu8ll_Ul()
{
  {
    init_simple_test("Ip_BFu8ll_Ul");
    static STRUCT_IF_C Ip_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_Ul, Ip_BFu8ll_Ul)
//============================================================================


struct  Ip_BFu8ll_Us  {
  int *v1;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 Ip_BFu8ll_Us) C1{ Fp FL:8 Fs}



static void Test_Ip_BFu8ll_Us()
{
  {
    init_simple_test("Ip_BFu8ll_Us");
    static STRUCT_IF_C Ip_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_Us, Ip_BFu8ll_Us)
//============================================================================


struct  Ip_BFu8ll_Vp  {
  int *v1;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 Ip_BFu8ll_Vp) C1{ Fp FL:8 Fp}



static void Test_Ip_BFu8ll_Vp()
{
  {
    init_simple_test("Ip_BFu8ll_Vp");
    static STRUCT_IF_C Ip_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8ll_Vp, Ip_BFu8ll_Vp)
//============================================================================


struct  Ip_BFu8s  {
  int *v1;
  unsigned short v2:8;
};
//SIG(1 Ip_BFu8s) C1{ Fp Fs:8}



static void Test_Ip_BFu8s()
{
  {
    init_simple_test("Ip_BFu8s");
    static STRUCT_IF_C Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s, Ip_BFu8s)
//============================================================================


struct  Ip_BFu8s_BFu15i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu8s_BFu15i) C1{ Fp Fs:8 Fi:15}



static void Test_Ip_BFu8s_BFu15i()
{
  {
    init_simple_test("Ip_BFu8s_BFu15i");
    static STRUCT_IF_C Ip_BFu8s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu15i, Ip_BFu8s_BFu15i)
//============================================================================


struct  Ip_BFu8s_BFu15ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu8s_BFu15ll) C1{ Fp Fs:8 FL:15}



static void Test_Ip_BFu8s_BFu15ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu15ll");
    static STRUCT_IF_C Ip_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu15ll, Ip_BFu8s_BFu15ll)
//============================================================================


struct  Ip_BFu8s_BFu15s  {
  int *v1;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu8s_BFu15s) C1{ Fp Fs:8 Fs:15}



static void Test_Ip_BFu8s_BFu15s()
{
  {
    init_simple_test("Ip_BFu8s_BFu15s");
    static STRUCT_IF_C Ip_BFu8s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu15s, Ip_BFu8s_BFu15s)
//============================================================================


struct  Ip_BFu8s_BFu16i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu8s_BFu16i) C1{ Fp Fs:8 Fi:16}



static void Test_Ip_BFu8s_BFu16i()
{
  {
    init_simple_test("Ip_BFu8s_BFu16i");
    static STRUCT_IF_C Ip_BFu8s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu16i, Ip_BFu8s_BFu16i)
//============================================================================


struct  Ip_BFu8s_BFu16ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu8s_BFu16ll) C1{ Fp Fs:8 FL:16}



static void Test_Ip_BFu8s_BFu16ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu16ll");
    static STRUCT_IF_C Ip_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu16ll, Ip_BFu8s_BFu16ll)
//============================================================================


struct  Ip_BFu8s_BFu16s  {
  int *v1;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu8s_BFu16s) C1{ Fp Fs:8 Fs:16}



static void Test_Ip_BFu8s_BFu16s()
{
  {
    init_simple_test("Ip_BFu8s_BFu16s");
    static STRUCT_IF_C Ip_BFu8s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu16s, Ip_BFu8s_BFu16s)
//============================================================================


struct  Ip_BFu8s_BFu17i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu8s_BFu17i) C1{ Fp Fs:8 Fi:17}



static void Test_Ip_BFu8s_BFu17i()
{
  {
    init_simple_test("Ip_BFu8s_BFu17i");
    static STRUCT_IF_C Ip_BFu8s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu17i, Ip_BFu8s_BFu17i)
//============================================================================


struct  Ip_BFu8s_BFu17ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu8s_BFu17ll) C1{ Fp Fs:8 FL:17}



static void Test_Ip_BFu8s_BFu17ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu17ll");
    static STRUCT_IF_C Ip_BFu8s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu17ll, Ip_BFu8s_BFu17ll)
//============================================================================


struct  Ip_BFu8s_BFu1c  {
  int *v1;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu8s_BFu1c) C1{ Fp Fs:8 Fc:1}



static void Test_Ip_BFu8s_BFu1c()
{
  {
    init_simple_test("Ip_BFu8s_BFu1c");
    static STRUCT_IF_C Ip_BFu8s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu1c, Ip_BFu8s_BFu1c)
//============================================================================


struct  Ip_BFu8s_BFu1i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu8s_BFu1i) C1{ Fp Fs:8 Fi:1}



static void Test_Ip_BFu8s_BFu1i()
{
  {
    init_simple_test("Ip_BFu8s_BFu1i");
    static STRUCT_IF_C Ip_BFu8s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu1i, Ip_BFu8s_BFu1i)
//============================================================================


struct  Ip_BFu8s_BFu1ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu8s_BFu1ll) C1{ Fp Fs:8 FL:1}



static void Test_Ip_BFu8s_BFu1ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu1ll");
    static STRUCT_IF_C Ip_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu1ll, Ip_BFu8s_BFu1ll)
//============================================================================


struct  Ip_BFu8s_BFu1s  {
  int *v1;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu8s_BFu1s) C1{ Fp Fs:8 Fs:1}



static void Test_Ip_BFu8s_BFu1s()
{
  {
    init_simple_test("Ip_BFu8s_BFu1s");
    static STRUCT_IF_C Ip_BFu8s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu1s, Ip_BFu8s_BFu1s)
//============================================================================


struct  Ip_BFu8s_BFu31i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu8s_BFu31i) C1{ Fp Fs:8 Fi:31}



static void Test_Ip_BFu8s_BFu31i()
{
  {
    init_simple_test("Ip_BFu8s_BFu31i");
    static STRUCT_IF_C Ip_BFu8s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu31i, Ip_BFu8s_BFu31i)
//============================================================================


struct  Ip_BFu8s_BFu31ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu8s_BFu31ll) C1{ Fp Fs:8 FL:31}



static void Test_Ip_BFu8s_BFu31ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu31ll");
    static STRUCT_IF_C Ip_BFu8s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Ip_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Ip_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu31ll, Ip_BFu8s_BFu31ll)
//============================================================================


struct  Ip_BFu8s_BFu32i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu8s_BFu32i) C1{ Fp Fs:8 Fi:32}



static void Test_Ip_BFu8s_BFu32i()
{
  {
    init_simple_test("Ip_BFu8s_BFu32i");
    static STRUCT_IF_C Ip_BFu8s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu32i, Ip_BFu8s_BFu32i)
//============================================================================


struct  Ip_BFu8s_BFu32ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu8s_BFu32ll) C1{ Fp Fs:8 FL:32}



static void Test_Ip_BFu8s_BFu32ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu32ll");
    static STRUCT_IF_C Ip_BFu8s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Ip_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Ip_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu32ll, Ip_BFu8s_BFu32ll)
//============================================================================


struct  Ip_BFu8s_BFu33  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu8s_BFu33) C1{ Fp Fs:8 FL:33}



static void Test_Ip_BFu8s_BFu33()
{
  {
    init_simple_test("Ip_BFu8s_BFu33");
    static STRUCT_IF_C Ip_BFu8s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "Ip_BFu8s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "Ip_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu33, Ip_BFu8s_BFu33)
//============================================================================


struct  Ip_BFu8s_BFu7c  {
  int *v1;
  unsigned short v2:8;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu8s_BFu7c) C1{ Fp Fs:8 Fc:7}



static void Test_Ip_BFu8s_BFu7c()
{
  {
    init_simple_test("Ip_BFu8s_BFu7c");
    static STRUCT_IF_C Ip_BFu8s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu7c, Ip_BFu8s_BFu7c)
//============================================================================


struct  Ip_BFu8s_BFu7i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu8s_BFu7i) C1{ Fp Fs:8 Fi:7}



static void Test_Ip_BFu8s_BFu7i()
{
  {
    init_simple_test("Ip_BFu8s_BFu7i");
    static STRUCT_IF_C Ip_BFu8s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu7i, Ip_BFu8s_BFu7i)
//============================================================================


struct  Ip_BFu8s_BFu7ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu8s_BFu7ll) C1{ Fp Fs:8 FL:7}



static void Test_Ip_BFu8s_BFu7ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu7ll");
    static STRUCT_IF_C Ip_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu7ll, Ip_BFu8s_BFu7ll)
//============================================================================


struct  Ip_BFu8s_BFu7s  {
  int *v1;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu8s_BFu7s) C1{ Fp Fs:8 Fs:7}



static void Test_Ip_BFu8s_BFu7s()
{
  {
    init_simple_test("Ip_BFu8s_BFu7s");
    static STRUCT_IF_C Ip_BFu8s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu7s, Ip_BFu8s_BFu7s)
//============================================================================


struct  Ip_BFu8s_BFu8c  {
  int *v1;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu8s_BFu8c) C1{ Fp Fs:8 Fc:8}



static void Test_Ip_BFu8s_BFu8c()
{
  {
    init_simple_test("Ip_BFu8s_BFu8c");
    static STRUCT_IF_C Ip_BFu8s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu8c, Ip_BFu8s_BFu8c)
//============================================================================


struct  Ip_BFu8s_BFu8i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu8s_BFu8i) C1{ Fp Fs:8 Fi:8}



static void Test_Ip_BFu8s_BFu8i()
{
  {
    init_simple_test("Ip_BFu8s_BFu8i");
    static STRUCT_IF_C Ip_BFu8s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu8i, Ip_BFu8s_BFu8i)
//============================================================================


struct  Ip_BFu8s_BFu8ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu8s_BFu8ll) C1{ Fp Fs:8 FL:8}



static void Test_Ip_BFu8s_BFu8ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu8ll");
    static STRUCT_IF_C Ip_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu8ll, Ip_BFu8s_BFu8ll)
//============================================================================


struct  Ip_BFu8s_BFu8s  {
  int *v1;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu8s_BFu8s) C1{ Fp Fs:8 Fs:8}



static void Test_Ip_BFu8s_BFu8s()
{
  {
    init_simple_test("Ip_BFu8s_BFu8s");
    static STRUCT_IF_C Ip_BFu8s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu8s, Ip_BFu8s_BFu8s)
//============================================================================


struct  Ip_BFu8s_BFu9i  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu8s_BFu9i) C1{ Fp Fs:8 Fi:9}



static void Test_Ip_BFu8s_BFu9i()
{
  {
    init_simple_test("Ip_BFu8s_BFu9i");
    static STRUCT_IF_C Ip_BFu8s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu9i, Ip_BFu8s_BFu9i)
//============================================================================


struct  Ip_BFu8s_BFu9ll  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu8s_BFu9ll) C1{ Fp Fs:8 FL:9}



static void Test_Ip_BFu8s_BFu9ll()
{
  {
    init_simple_test("Ip_BFu8s_BFu9ll");
    static STRUCT_IF_C Ip_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu9ll, Ip_BFu8s_BFu9ll)
//============================================================================


struct  Ip_BFu8s_BFu9s  {
  int *v1;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu8s_BFu9s) C1{ Fp Fs:8 Fs:9}



static void Test_Ip_BFu8s_BFu9s()
{
  {
    init_simple_test("Ip_BFu8s_BFu9s");
    static STRUCT_IF_C Ip_BFu8s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_BFu9s, Ip_BFu8s_BFu9s)
//============================================================================


struct  Ip_BFu8s_C  {
  int *v1;
  unsigned short v2:8;
  char v3;
};
//SIG(1 Ip_BFu8s_C) C1{ Fp Fs:8 Fc}



static void Test_Ip_BFu8s_C()
{
  {
    init_simple_test("Ip_BFu8s_C");
    static STRUCT_IF_C Ip_BFu8s_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_C, Ip_BFu8s_C)
//============================================================================


struct  Ip_BFu8s_D  {
  int *v1;
  unsigned short v2:8;
  double v3;
};
//SIG(1 Ip_BFu8s_D) C1{ Fp Fs:8 FL}



static void Test_Ip_BFu8s_D()
{
  {
    init_simple_test("Ip_BFu8s_D");
    static STRUCT_IF_C Ip_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_D, Ip_BFu8s_D)
//============================================================================


struct  Ip_BFu8s_F  {
  int *v1;
  unsigned short v2:8;
  float v3;
};
//SIG(1 Ip_BFu8s_F) C1{ Fp Fs:8 Fi}



static void Test_Ip_BFu8s_F()
{
  {
    init_simple_test("Ip_BFu8s_F");
    static STRUCT_IF_C Ip_BFu8s_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_F, Ip_BFu8s_F)
//============================================================================


struct  Ip_BFu8s_I  {
  int *v1;
  unsigned short v2:8;
  int v3;
};
//SIG(1 Ip_BFu8s_I) C1{ Fp Fs:8 Fi}



static void Test_Ip_BFu8s_I()
{
  {
    init_simple_test("Ip_BFu8s_I");
    static STRUCT_IF_C Ip_BFu8s_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_I, Ip_BFu8s_I)
//============================================================================


struct  Ip_BFu8s_Ip  {
  int *v1;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 Ip_BFu8s_Ip) C1{ Fp Fs:8 Fp}



static void Test_Ip_BFu8s_Ip()
{
  {
    init_simple_test("Ip_BFu8s_Ip");
    static STRUCT_IF_C Ip_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_Ip, Ip_BFu8s_Ip)
//============================================================================


struct  Ip_BFu8s_L  {
  int *v1;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 Ip_BFu8s_L) C1{ Fp Fs:8 FL}



static void Test_Ip_BFu8s_L()
{
  {
    init_simple_test("Ip_BFu8s_L");
    static STRUCT_IF_C Ip_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_L, Ip_BFu8s_L)
//============================================================================


struct  Ip_BFu8s_S  {
  int *v1;
  unsigned short v2:8;
  short v3;
};
//SIG(1 Ip_BFu8s_S) C1{ Fp Fs:8 Fs}



static void Test_Ip_BFu8s_S()
{
  {
    init_simple_test("Ip_BFu8s_S");
    static STRUCT_IF_C Ip_BFu8s_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_S, Ip_BFu8s_S)
//============================================================================


struct  Ip_BFu8s_Uc  {
  int *v1;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 Ip_BFu8s_Uc) C1{ Fp Fs:8 Fc}



static void Test_Ip_BFu8s_Uc()
{
  {
    init_simple_test("Ip_BFu8s_Uc");
    static STRUCT_IF_C Ip_BFu8s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_Uc, Ip_BFu8s_Uc)
//============================================================================


struct  Ip_BFu8s_Ui  {
  int *v1;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 Ip_BFu8s_Ui) C1{ Fp Fs:8 Fi}



static void Test_Ip_BFu8s_Ui()
{
  {
    init_simple_test("Ip_BFu8s_Ui");
    static STRUCT_IF_C Ip_BFu8s_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu8s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_Ui, Ip_BFu8s_Ui)
//============================================================================


struct  Ip_BFu8s_Ul  {
  int *v1;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 Ip_BFu8s_Ul) C1{ Fp Fs:8 FL}



static void Test_Ip_BFu8s_Ul()
{
  {
    init_simple_test("Ip_BFu8s_Ul");
    static STRUCT_IF_C Ip_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_Ul, Ip_BFu8s_Ul)
//============================================================================


struct  Ip_BFu8s_Us  {
  int *v1;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 Ip_BFu8s_Us) C1{ Fp Fs:8 Fs}



static void Test_Ip_BFu8s_Us()
{
  {
    init_simple_test("Ip_BFu8s_Us");
    static STRUCT_IF_C Ip_BFu8s_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu8s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_Us, Ip_BFu8s_Us)
//============================================================================


struct  Ip_BFu8s_Vp  {
  int *v1;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 Ip_BFu8s_Vp) C1{ Fp Fs:8 Fp}



static void Test_Ip_BFu8s_Vp()
{
  {
    init_simple_test("Ip_BFu8s_Vp");
    static STRUCT_IF_C Ip_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ip_BFu8s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ip_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu8s_Vp, Ip_BFu8s_Vp)
//============================================================================


struct  Ip_BFu9i  {
  int *v1;
  unsigned int v2:9;
};
//SIG(1 Ip_BFu9i) C1{ Fp Fi:9}



static void Test_Ip_BFu9i()
{
  {
    init_simple_test("Ip_BFu9i");
    static STRUCT_IF_C Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i, Ip_BFu9i)
//============================================================================


struct  Ip_BFu9i_BFu15i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu9i_BFu15i) C1{ Fp Fi:9 Fi:15}



static void Test_Ip_BFu9i_BFu15i()
{
  {
    init_simple_test("Ip_BFu9i_BFu15i");
    static STRUCT_IF_C Ip_BFu9i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "Ip_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "Ip_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu15i, Ip_BFu9i_BFu15i)
//============================================================================


struct  Ip_BFu9i_BFu15ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu9i_BFu15ll) C1{ Fp Fi:9 FL:15}



static void Test_Ip_BFu9i_BFu15ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu15ll");
    static STRUCT_IF_C Ip_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "Ip_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "Ip_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu15ll, Ip_BFu9i_BFu15ll)
//============================================================================


struct  Ip_BFu9i_BFu15s  {
  int *v1;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu9i_BFu15s) C1{ Fp Fi:9 Fs:15}



static void Test_Ip_BFu9i_BFu15s()
{
  {
    init_simple_test("Ip_BFu9i_BFu15s");
    static STRUCT_IF_C Ip_BFu9i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu15s, Ip_BFu9i_BFu15s)
//============================================================================


struct  Ip_BFu9i_BFu16i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu9i_BFu16i) C1{ Fp Fi:9 Fi:16}



static void Test_Ip_BFu9i_BFu16i()
{
  {
    init_simple_test("Ip_BFu9i_BFu16i");
    static STRUCT_IF_C Ip_BFu9i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "Ip_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "Ip_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu16i, Ip_BFu9i_BFu16i)
//============================================================================


struct  Ip_BFu9i_BFu16ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu9i_BFu16ll) C1{ Fp Fi:9 FL:16}



static void Test_Ip_BFu9i_BFu16ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu16ll");
    static STRUCT_IF_C Ip_BFu9i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "Ip_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "Ip_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu16ll, Ip_BFu9i_BFu16ll)
//============================================================================


struct  Ip_BFu9i_BFu16s  {
  int *v1;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu9i_BFu16s) C1{ Fp Fi:9 Fs:16}



static void Test_Ip_BFu9i_BFu16s()
{
  {
    init_simple_test("Ip_BFu9i_BFu16s");
    static STRUCT_IF_C Ip_BFu9i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu16s, Ip_BFu9i_BFu16s)
//============================================================================


struct  Ip_BFu9i_BFu17i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu9i_BFu17i) C1{ Fp Fi:9 Fi:17}



static void Test_Ip_BFu9i_BFu17i()
{
  {
    init_simple_test("Ip_BFu9i_BFu17i");
    static STRUCT_IF_C Ip_BFu9i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "Ip_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "Ip_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu17i, Ip_BFu9i_BFu17i)
//============================================================================


struct  Ip_BFu9i_BFu17ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu9i_BFu17ll) C1{ Fp Fi:9 FL:17}



static void Test_Ip_BFu9i_BFu17ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu17ll");
    static STRUCT_IF_C Ip_BFu9i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "Ip_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "Ip_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu17ll, Ip_BFu9i_BFu17ll)
//============================================================================


struct  Ip_BFu9i_BFu1c  {
  int *v1;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu9i_BFu1c) C1{ Fp Fi:9 Fc:1}



static void Test_Ip_BFu9i_BFu1c()
{
  {
    init_simple_test("Ip_BFu9i_BFu1c");
    static STRUCT_IF_C Ip_BFu9i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu1c, Ip_BFu9i_BFu1c)
//============================================================================


struct  Ip_BFu9i_BFu1i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu9i_BFu1i) C1{ Fp Fi:9 Fi:1}



static void Test_Ip_BFu9i_BFu1i()
{
  {
    init_simple_test("Ip_BFu9i_BFu1i");
    static STRUCT_IF_C Ip_BFu9i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu1i, Ip_BFu9i_BFu1i)
//============================================================================


struct  Ip_BFu9i_BFu1ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu9i_BFu1ll) C1{ Fp Fi:9 FL:1}



static void Test_Ip_BFu9i_BFu1ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu1ll");
    static STRUCT_IF_C Ip_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu1ll, Ip_BFu9i_BFu1ll)
//============================================================================


struct  Ip_BFu9i_BFu1s  {
  int *v1;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu9i_BFu1s) C1{ Fp Fi:9 Fs:1}



static void Test_Ip_BFu9i_BFu1s()
{
  {
    init_simple_test("Ip_BFu9i_BFu1s");
    static STRUCT_IF_C Ip_BFu9i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu1s, Ip_BFu9i_BFu1s)
//============================================================================


struct  Ip_BFu9i_BFu31i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu9i_BFu31i) C1{ Fp Fi:9 Fi:31}



static void Test_Ip_BFu9i_BFu31i()
{
  {
    init_simple_test("Ip_BFu9i_BFu31i");
    static STRUCT_IF_C Ip_BFu9i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu31i, Ip_BFu9i_BFu31i)
//============================================================================


struct  Ip_BFu9i_BFu31ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu9i_BFu31ll) C1{ Fp Fi:9 FL:31}



static void Test_Ip_BFu9i_BFu31ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu31ll");
    static STRUCT_IF_C Ip_BFu9i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 31, 1, "Ip_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 31, hide_ull(1LL<<30), "Ip_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu31ll, Ip_BFu9i_BFu31ll)
//============================================================================


struct  Ip_BFu9i_BFu32i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu9i_BFu32i) C1{ Fp Fi:9 Fi:32}



static void Test_Ip_BFu9i_BFu32i()
{
  {
    init_simple_test("Ip_BFu9i_BFu32i");
    static STRUCT_IF_C Ip_BFu9i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu32i, Ip_BFu9i_BFu32i)
//============================================================================


struct  Ip_BFu9i_BFu32ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu9i_BFu32ll) C1{ Fp Fi:9 FL:32}



static void Test_Ip_BFu9i_BFu32ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu32ll");
    static STRUCT_IF_C Ip_BFu9i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 32, 1, "Ip_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu32ll, Ip_BFu9i_BFu32ll)
//============================================================================


struct  Ip_BFu9i_BFu33  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu9i_BFu33) C1{ Fp Fi:9 FL:33}



static void Test_Ip_BFu9i_BFu33()
{
  {
    init_simple_test("Ip_BFu9i_BFu33");
    static STRUCT_IF_C Ip_BFu9i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 33, 1, "Ip_BFu9i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu33, Ip_BFu9i_BFu33)
//============================================================================


struct  Ip_BFu9i_BFu7c  {
  int *v1;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu9i_BFu7c) C1{ Fp Fi:9 Fc:7}



static void Test_Ip_BFu9i_BFu7c()
{
  {
    init_simple_test("Ip_BFu9i_BFu7c");
    static STRUCT_IF_C Ip_BFu9i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu7c, Ip_BFu9i_BFu7c)
//============================================================================


struct  Ip_BFu9i_BFu7i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu9i_BFu7i) C1{ Fp Fi:9 Fi:7}



static void Test_Ip_BFu9i_BFu7i()
{
  {
    init_simple_test("Ip_BFu9i_BFu7i");
    static STRUCT_IF_C Ip_BFu9i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu7i, Ip_BFu9i_BFu7i)
//============================================================================


struct  Ip_BFu9i_BFu7ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu9i_BFu7ll) C1{ Fp Fi:9 FL:7}



static void Test_Ip_BFu9i_BFu7ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu7ll");
    static STRUCT_IF_C Ip_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu7ll, Ip_BFu9i_BFu7ll)
//============================================================================


struct  Ip_BFu9i_BFu7s  {
  int *v1;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu9i_BFu7s) C1{ Fp Fi:9 Fs:7}



static void Test_Ip_BFu9i_BFu7s()
{
  {
    init_simple_test("Ip_BFu9i_BFu7s");
    static STRUCT_IF_C Ip_BFu9i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu7s, Ip_BFu9i_BFu7s)
//============================================================================


struct  Ip_BFu9i_BFu8c  {
  int *v1;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu9i_BFu8c) C1{ Fp Fi:9 Fc:8}



static void Test_Ip_BFu9i_BFu8c()
{
  {
    init_simple_test("Ip_BFu9i_BFu8c");
    static STRUCT_IF_C Ip_BFu9i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu8c, Ip_BFu9i_BFu8c)
//============================================================================


struct  Ip_BFu9i_BFu8i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu9i_BFu8i) C1{ Fp Fi:9 Fi:8}



static void Test_Ip_BFu9i_BFu8i()
{
  {
    init_simple_test("Ip_BFu9i_BFu8i");
    static STRUCT_IF_C Ip_BFu9i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "Ip_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "Ip_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu8i, Ip_BFu9i_BFu8i)
//============================================================================


struct  Ip_BFu9i_BFu8ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu9i_BFu8ll) C1{ Fp Fi:9 FL:8}



static void Test_Ip_BFu9i_BFu8ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu8ll");
    static STRUCT_IF_C Ip_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "Ip_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "Ip_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu8ll, Ip_BFu9i_BFu8ll)
//============================================================================


struct  Ip_BFu9i_BFu8s  {
  int *v1;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu9i_BFu8s) C1{ Fp Fi:9 Fs:8}



static void Test_Ip_BFu9i_BFu8s()
{
  {
    init_simple_test("Ip_BFu9i_BFu8s");
    static STRUCT_IF_C Ip_BFu9i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu8s, Ip_BFu9i_BFu8s)
//============================================================================


struct  Ip_BFu9i_BFu9i  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu9i_BFu9i) C1{ Fp Fi:9 Fi:9}



static void Test_Ip_BFu9i_BFu9i()
{
  {
    init_simple_test("Ip_BFu9i_BFu9i");
    static STRUCT_IF_C Ip_BFu9i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "Ip_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu9i, Ip_BFu9i_BFu9i)
//============================================================================


struct  Ip_BFu9i_BFu9ll  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu9i_BFu9ll) C1{ Fp Fi:9 FL:9}



static void Test_Ip_BFu9i_BFu9ll()
{
  {
    init_simple_test("Ip_BFu9i_BFu9ll");
    static STRUCT_IF_C Ip_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "Ip_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu9ll, Ip_BFu9i_BFu9ll)
//============================================================================


struct  Ip_BFu9i_BFu9s  {
  int *v1;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu9i_BFu9s) C1{ Fp Fi:9 Fs:9}



static void Test_Ip_BFu9i_BFu9s()
{
  {
    init_simple_test("Ip_BFu9i_BFu9s");
    static STRUCT_IF_C Ip_BFu9i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_BFu9s, Ip_BFu9i_BFu9s)
//============================================================================


struct  Ip_BFu9i_C  {
  int *v1;
  unsigned int v2:9;
  char v3;
};
//SIG(1 Ip_BFu9i_C) C1{ Fp Fi:9 Fc}



static void Test_Ip_BFu9i_C()
{
  {
    init_simple_test("Ip_BFu9i_C");
    static STRUCT_IF_C Ip_BFu9i_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_C, Ip_BFu9i_C)
//============================================================================


struct  Ip_BFu9i_D  {
  int *v1;
  unsigned int v2:9;
  double v3;
};
//SIG(1 Ip_BFu9i_D) C1{ Fp Fi:9 FL}



static void Test_Ip_BFu9i_D()
{
  {
    init_simple_test("Ip_BFu9i_D");
    static STRUCT_IF_C Ip_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_D, Ip_BFu9i_D)
//============================================================================


struct  Ip_BFu9i_F  {
  int *v1;
  unsigned int v2:9;
  float v3;
};
//SIG(1 Ip_BFu9i_F) C1{ Fp Fi:9 Fi}



static void Test_Ip_BFu9i_F()
{
  {
    init_simple_test("Ip_BFu9i_F");
    static STRUCT_IF_C Ip_BFu9i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_F, Ip_BFu9i_F)
//============================================================================


struct  Ip_BFu9i_I  {
  int *v1;
  unsigned int v2:9;
  int v3;
};
//SIG(1 Ip_BFu9i_I) C1{ Fp Fi:9 Fi}



static void Test_Ip_BFu9i_I()
{
  {
    init_simple_test("Ip_BFu9i_I");
    static STRUCT_IF_C Ip_BFu9i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_I, Ip_BFu9i_I)
//============================================================================


struct  Ip_BFu9i_Ip  {
  int *v1;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 Ip_BFu9i_Ip) C1{ Fp Fi:9 Fp}



static void Test_Ip_BFu9i_Ip()
{
  {
    init_simple_test("Ip_BFu9i_Ip");
    static STRUCT_IF_C Ip_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_Ip, Ip_BFu9i_Ip)
//============================================================================


struct  Ip_BFu9i_L  {
  int *v1;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 Ip_BFu9i_L) C1{ Fp Fi:9 FL}



static void Test_Ip_BFu9i_L()
{
  {
    init_simple_test("Ip_BFu9i_L");
    static STRUCT_IF_C Ip_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_L, Ip_BFu9i_L)
//============================================================================


struct  Ip_BFu9i_S  {
  int *v1;
  unsigned int v2:9;
  short v3;
};
//SIG(1 Ip_BFu9i_S) C1{ Fp Fi:9 Fs}



static void Test_Ip_BFu9i_S()
{
  {
    init_simple_test("Ip_BFu9i_S");
    static STRUCT_IF_C Ip_BFu9i_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_S, Ip_BFu9i_S)
//============================================================================


struct  Ip_BFu9i_Uc  {
  int *v1;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 Ip_BFu9i_Uc) C1{ Fp Fi:9 Fc}



static void Test_Ip_BFu9i_Uc()
{
  {
    init_simple_test("Ip_BFu9i_Uc");
    static STRUCT_IF_C Ip_BFu9i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_Uc, Ip_BFu9i_Uc)
//============================================================================


struct  Ip_BFu9i_Ui  {
  int *v1;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 Ip_BFu9i_Ui) C1{ Fp Fi:9 Fi}



static void Test_Ip_BFu9i_Ui()
{
  {
    init_simple_test("Ip_BFu9i_Ui");
    static STRUCT_IF_C Ip_BFu9i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_Ui, Ip_BFu9i_Ui)
//============================================================================


struct  Ip_BFu9i_Ul  {
  int *v1;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 Ip_BFu9i_Ul) C1{ Fp Fi:9 FL}



static void Test_Ip_BFu9i_Ul()
{
  {
    init_simple_test("Ip_BFu9i_Ul");
    static STRUCT_IF_C Ip_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_Ul, Ip_BFu9i_Ul)
//============================================================================


struct  Ip_BFu9i_Us  {
  int *v1;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 Ip_BFu9i_Us) C1{ Fp Fi:9 Fs}



static void Test_Ip_BFu9i_Us()
{
  {
    init_simple_test("Ip_BFu9i_Us");
    static STRUCT_IF_C Ip_BFu9i_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_Us, Ip_BFu9i_Us)
//============================================================================


struct  Ip_BFu9i_Vp  {
  int *v1;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 Ip_BFu9i_Vp) C1{ Fp Fi:9 Fp}



static void Test_Ip_BFu9i_Vp()
{
  {
    init_simple_test("Ip_BFu9i_Vp");
    static STRUCT_IF_C Ip_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9i_Vp, Ip_BFu9i_Vp)
//============================================================================


struct  Ip_BFu9ll  {
  int *v1;
  __tsu64 v2:9;
};
//SIG(1 Ip_BFu9ll) C1{ Fp FL:9}



static void Test_Ip_BFu9ll()
{
  {
    init_simple_test("Ip_BFu9ll");
    static STRUCT_IF_C Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll, Ip_BFu9ll)
//============================================================================


struct  Ip_BFu9ll_BFu15i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu9ll_BFu15i) C1{ Fp FL:9 Fi:15}



static void Test_Ip_BFu9ll_BFu15i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu15i");
    static STRUCT_IF_C Ip_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "Ip_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "Ip_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu15i, Ip_BFu9ll_BFu15i)
//============================================================================


struct  Ip_BFu9ll_BFu15ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu9ll_BFu15ll) C1{ Fp FL:9 FL:15}



static void Test_Ip_BFu9ll_BFu15ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu15ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "Ip_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "Ip_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu15ll, Ip_BFu9ll_BFu15ll)
//============================================================================


struct  Ip_BFu9ll_BFu15s  {
  int *v1;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu9ll_BFu15s) C1{ Fp FL:9 Fs:15}



static void Test_Ip_BFu9ll_BFu15s()
{
  {
    init_simple_test("Ip_BFu9ll_BFu15s");
    static STRUCT_IF_C Ip_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu15s, Ip_BFu9ll_BFu15s)
//============================================================================


struct  Ip_BFu9ll_BFu16i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu9ll_BFu16i) C1{ Fp FL:9 Fi:16}



static void Test_Ip_BFu9ll_BFu16i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu16i");
    static STRUCT_IF_C Ip_BFu9ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "Ip_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "Ip_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu16i, Ip_BFu9ll_BFu16i)
//============================================================================


struct  Ip_BFu9ll_BFu16ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu9ll_BFu16ll) C1{ Fp FL:9 FL:16}



static void Test_Ip_BFu9ll_BFu16ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu16ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "Ip_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "Ip_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu16ll, Ip_BFu9ll_BFu16ll)
//============================================================================


struct  Ip_BFu9ll_BFu16s  {
  int *v1;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu9ll_BFu16s) C1{ Fp FL:9 Fs:16}



static void Test_Ip_BFu9ll_BFu16s()
{
  {
    init_simple_test("Ip_BFu9ll_BFu16s");
    static STRUCT_IF_C Ip_BFu9ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu16s, Ip_BFu9ll_BFu16s)
//============================================================================


struct  Ip_BFu9ll_BFu17i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu9ll_BFu17i) C1{ Fp FL:9 Fi:17}



static void Test_Ip_BFu9ll_BFu17i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu17i");
    static STRUCT_IF_C Ip_BFu9ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "Ip_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "Ip_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu17i, Ip_BFu9ll_BFu17i)
//============================================================================


struct  Ip_BFu9ll_BFu17ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu9ll_BFu17ll) C1{ Fp FL:9 FL:17}



static void Test_Ip_BFu9ll_BFu17ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu17ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "Ip_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "Ip_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu17ll, Ip_BFu9ll_BFu17ll)
//============================================================================


struct  Ip_BFu9ll_BFu1c  {
  int *v1;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu9ll_BFu1c) C1{ Fp FL:9 Fc:1}



static void Test_Ip_BFu9ll_BFu1c()
{
  {
    init_simple_test("Ip_BFu9ll_BFu1c");
    static STRUCT_IF_C Ip_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu1c, Ip_BFu9ll_BFu1c)
//============================================================================


struct  Ip_BFu9ll_BFu1i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu9ll_BFu1i) C1{ Fp FL:9 Fi:1}



static void Test_Ip_BFu9ll_BFu1i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu1i");
    static STRUCT_IF_C Ip_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu1i, Ip_BFu9ll_BFu1i)
//============================================================================


struct  Ip_BFu9ll_BFu1ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu9ll_BFu1ll) C1{ Fp FL:9 FL:1}



static void Test_Ip_BFu9ll_BFu1ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu1ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu1ll, Ip_BFu9ll_BFu1ll)
//============================================================================


struct  Ip_BFu9ll_BFu1s  {
  int *v1;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu9ll_BFu1s) C1{ Fp FL:9 Fs:1}



static void Test_Ip_BFu9ll_BFu1s()
{
  {
    init_simple_test("Ip_BFu9ll_BFu1s");
    static STRUCT_IF_C Ip_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu1s, Ip_BFu9ll_BFu1s)
//============================================================================


struct  Ip_BFu9ll_BFu31i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu9ll_BFu31i) C1{ Fp FL:9 Fi:31}



static void Test_Ip_BFu9ll_BFu31i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu31i");
    static STRUCT_IF_C Ip_BFu9ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu31i, Ip_BFu9ll_BFu31i)
//============================================================================


struct  Ip_BFu9ll_BFu31ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu9ll_BFu31ll) C1{ Fp FL:9 FL:31}



static void Test_Ip_BFu9ll_BFu31ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu31ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 31, 1, "Ip_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 31, hide_ull(1LL<<30), "Ip_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu31ll, Ip_BFu9ll_BFu31ll)
//============================================================================


struct  Ip_BFu9ll_BFu32i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu9ll_BFu32i) C1{ Fp FL:9 Fi:32}



static void Test_Ip_BFu9ll_BFu32i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu32i");
    static STRUCT_IF_C Ip_BFu9ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu32i, Ip_BFu9ll_BFu32i)
//============================================================================


struct  Ip_BFu9ll_BFu32ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu9ll_BFu32ll) C1{ Fp FL:9 FL:32}



static void Test_Ip_BFu9ll_BFu32ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu32ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 32, 1, "Ip_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu32ll, Ip_BFu9ll_BFu32ll)
//============================================================================


struct  Ip_BFu9ll_BFu33  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu9ll_BFu33) C1{ Fp FL:9 FL:33}



static void Test_Ip_BFu9ll_BFu33()
{
  {
    init_simple_test("Ip_BFu9ll_BFu33");
    static STRUCT_IF_C Ip_BFu9ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 33, 1, "Ip_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu33, Ip_BFu9ll_BFu33)
//============================================================================


struct  Ip_BFu9ll_BFu7c  {
  int *v1;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu9ll_BFu7c) C1{ Fp FL:9 Fc:7}



static void Test_Ip_BFu9ll_BFu7c()
{
  {
    init_simple_test("Ip_BFu9ll_BFu7c");
    static STRUCT_IF_C Ip_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu7c, Ip_BFu9ll_BFu7c)
//============================================================================


struct  Ip_BFu9ll_BFu7i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu9ll_BFu7i) C1{ Fp FL:9 Fi:7}



static void Test_Ip_BFu9ll_BFu7i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu7i");
    static STRUCT_IF_C Ip_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu7i, Ip_BFu9ll_BFu7i)
//============================================================================


struct  Ip_BFu9ll_BFu7ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu9ll_BFu7ll) C1{ Fp FL:9 FL:7}



static void Test_Ip_BFu9ll_BFu7ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu7ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu7ll, Ip_BFu9ll_BFu7ll)
//============================================================================


struct  Ip_BFu9ll_BFu7s  {
  int *v1;
  __tsu64 v2:9;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu9ll_BFu7s) C1{ Fp FL:9 Fs:7}



static void Test_Ip_BFu9ll_BFu7s()
{
  {
    init_simple_test("Ip_BFu9ll_BFu7s");
    static STRUCT_IF_C Ip_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu7s, Ip_BFu9ll_BFu7s)
//============================================================================


struct  Ip_BFu9ll_BFu8c  {
  int *v1;
  __tsu64 v2:9;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu9ll_BFu8c) C1{ Fp FL:9 Fc:8}



static void Test_Ip_BFu9ll_BFu8c()
{
  {
    init_simple_test("Ip_BFu9ll_BFu8c");
    static STRUCT_IF_C Ip_BFu9ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu8c, Ip_BFu9ll_BFu8c)
//============================================================================


struct  Ip_BFu9ll_BFu8i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu9ll_BFu8i) C1{ Fp FL:9 Fi:8}



static void Test_Ip_BFu9ll_BFu8i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu8i");
    static STRUCT_IF_C Ip_BFu9ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "Ip_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "Ip_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu8i, Ip_BFu9ll_BFu8i)
//============================================================================


struct  Ip_BFu9ll_BFu8ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu9ll_BFu8ll) C1{ Fp FL:9 FL:8}



static void Test_Ip_BFu9ll_BFu8ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu8ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "Ip_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "Ip_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu8ll, Ip_BFu9ll_BFu8ll)
//============================================================================


struct  Ip_BFu9ll_BFu8s  {
  int *v1;
  __tsu64 v2:9;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu9ll_BFu8s) C1{ Fp FL:9 Fs:8}



static void Test_Ip_BFu9ll_BFu8s()
{
  {
    init_simple_test("Ip_BFu9ll_BFu8s");
    static STRUCT_IF_C Ip_BFu9ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu8s, Ip_BFu9ll_BFu8s)
//============================================================================


struct  Ip_BFu9ll_BFu9i  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu9ll_BFu9i) C1{ Fp FL:9 Fi:9}



static void Test_Ip_BFu9ll_BFu9i()
{
  {
    init_simple_test("Ip_BFu9ll_BFu9i");
    static STRUCT_IF_C Ip_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "Ip_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu9i, Ip_BFu9ll_BFu9i)
//============================================================================


struct  Ip_BFu9ll_BFu9ll  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu9ll_BFu9ll) C1{ Fp FL:9 FL:9}



static void Test_Ip_BFu9ll_BFu9ll()
{
  {
    init_simple_test("Ip_BFu9ll_BFu9ll");
    static STRUCT_IF_C Ip_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "Ip_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu9ll, Ip_BFu9ll_BFu9ll)
//============================================================================


struct  Ip_BFu9ll_BFu9s  {
  int *v1;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu9ll_BFu9s) C1{ Fp FL:9 Fs:9}



static void Test_Ip_BFu9ll_BFu9s()
{
  {
    init_simple_test("Ip_BFu9ll_BFu9s");
    static STRUCT_IF_C Ip_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_BFu9s, Ip_BFu9ll_BFu9s)
//============================================================================


struct  Ip_BFu9ll_C  {
  int *v1;
  __tsu64 v2:9;
  char v3;
};
//SIG(1 Ip_BFu9ll_C) C1{ Fp FL:9 Fc}



static void Test_Ip_BFu9ll_C()
{
  {
    init_simple_test("Ip_BFu9ll_C");
    static STRUCT_IF_C Ip_BFu9ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_C, Ip_BFu9ll_C)
//============================================================================


struct  Ip_BFu9ll_D  {
  int *v1;
  __tsu64 v2:9;
  double v3;
};
//SIG(1 Ip_BFu9ll_D) C1{ Fp FL:9 FL}



static void Test_Ip_BFu9ll_D()
{
  {
    init_simple_test("Ip_BFu9ll_D");
    static STRUCT_IF_C Ip_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_D, Ip_BFu9ll_D)
//============================================================================


struct  Ip_BFu9ll_F  {
  int *v1;
  __tsu64 v2:9;
  float v3;
};
//SIG(1 Ip_BFu9ll_F) C1{ Fp FL:9 Fi}



static void Test_Ip_BFu9ll_F()
{
  {
    init_simple_test("Ip_BFu9ll_F");
    static STRUCT_IF_C Ip_BFu9ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_F, Ip_BFu9ll_F)
//============================================================================


struct  Ip_BFu9ll_I  {
  int *v1;
  __tsu64 v2:9;
  int v3;
};
//SIG(1 Ip_BFu9ll_I) C1{ Fp FL:9 Fi}



static void Test_Ip_BFu9ll_I()
{
  {
    init_simple_test("Ip_BFu9ll_I");
    static STRUCT_IF_C Ip_BFu9ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_I, Ip_BFu9ll_I)
//============================================================================


struct  Ip_BFu9ll_Ip  {
  int *v1;
  __tsu64 v2:9;
  int *v3;
};
//SIG(1 Ip_BFu9ll_Ip) C1{ Fp FL:9 Fp}



static void Test_Ip_BFu9ll_Ip()
{
  {
    init_simple_test("Ip_BFu9ll_Ip");
    static STRUCT_IF_C Ip_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_Ip, Ip_BFu9ll_Ip)
//============================================================================


struct  Ip_BFu9ll_L  {
  int *v1;
  __tsu64 v2:9;
  __tsi64 v3;
};
//SIG(1 Ip_BFu9ll_L) C1{ Fp FL:9 FL}



static void Test_Ip_BFu9ll_L()
{
  {
    init_simple_test("Ip_BFu9ll_L");
    static STRUCT_IF_C Ip_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_L, Ip_BFu9ll_L)
//============================================================================


struct  Ip_BFu9ll_S  {
  int *v1;
  __tsu64 v2:9;
  short v3;
};
//SIG(1 Ip_BFu9ll_S) C1{ Fp FL:9 Fs}



static void Test_Ip_BFu9ll_S()
{
  {
    init_simple_test("Ip_BFu9ll_S");
    static STRUCT_IF_C Ip_BFu9ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_S, Ip_BFu9ll_S)
//============================================================================


struct  Ip_BFu9ll_Uc  {
  int *v1;
  __tsu64 v2:9;
  unsigned char v3;
};
//SIG(1 Ip_BFu9ll_Uc) C1{ Fp FL:9 Fc}



static void Test_Ip_BFu9ll_Uc()
{
  {
    init_simple_test("Ip_BFu9ll_Uc");
    static STRUCT_IF_C Ip_BFu9ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_Uc, Ip_BFu9ll_Uc)
//============================================================================


struct  Ip_BFu9ll_Ui  {
  int *v1;
  __tsu64 v2:9;
  unsigned int v3;
};
//SIG(1 Ip_BFu9ll_Ui) C1{ Fp FL:9 Fi}



static void Test_Ip_BFu9ll_Ui()
{
  {
    init_simple_test("Ip_BFu9ll_Ui");
    static STRUCT_IF_C Ip_BFu9ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_Ui, Ip_BFu9ll_Ui)
//============================================================================


struct  Ip_BFu9ll_Ul  {
  int *v1;
  __tsu64 v2:9;
  __tsu64 v3;
};
//SIG(1 Ip_BFu9ll_Ul) C1{ Fp FL:9 FL}



static void Test_Ip_BFu9ll_Ul()
{
  {
    init_simple_test("Ip_BFu9ll_Ul");
    static STRUCT_IF_C Ip_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_Ul, Ip_BFu9ll_Ul)
//============================================================================


struct  Ip_BFu9ll_Us  {
  int *v1;
  __tsu64 v2:9;
  unsigned short v3;
};
//SIG(1 Ip_BFu9ll_Us) C1{ Fp FL:9 Fs}



static void Test_Ip_BFu9ll_Us()
{
  {
    init_simple_test("Ip_BFu9ll_Us");
    static STRUCT_IF_C Ip_BFu9ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_Us, Ip_BFu9ll_Us)
//============================================================================


struct  Ip_BFu9ll_Vp  {
  int *v1;
  __tsu64 v2:9;
  void *v3;
};
//SIG(1 Ip_BFu9ll_Vp) C1{ Fp FL:9 Fp}



static void Test_Ip_BFu9ll_Vp()
{
  {
    init_simple_test("Ip_BFu9ll_Vp");
    static STRUCT_IF_C Ip_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9ll_Vp, Ip_BFu9ll_Vp)
//============================================================================


struct  Ip_BFu9s  {
  int *v1;
  unsigned short v2:9;
};
//SIG(1 Ip_BFu9s) C1{ Fp Fs:9}



static void Test_Ip_BFu9s()
{
  {
    init_simple_test("Ip_BFu9s");
    static STRUCT_IF_C Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s, Ip_BFu9s)
//============================================================================


struct  Ip_BFu9s_BFu15i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:15;
};
//SIG(1 Ip_BFu9s_BFu15i) C1{ Fp Fs:9 Fi:15}



static void Test_Ip_BFu9s_BFu15i()
{
  {
    init_simple_test("Ip_BFu9s_BFu15i");
    static STRUCT_IF_C Ip_BFu9s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "Ip_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "Ip_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu15i, Ip_BFu9s_BFu15i)
//============================================================================


struct  Ip_BFu9s_BFu15ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:15;
};
//SIG(1 Ip_BFu9s_BFu15ll) C1{ Fp Fs:9 FL:15}



static void Test_Ip_BFu9s_BFu15ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu15ll");
    static STRUCT_IF_C Ip_BFu9s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "Ip_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "Ip_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu15ll, Ip_BFu9s_BFu15ll)
//============================================================================


struct  Ip_BFu9s_BFu15s  {
  int *v1;
  unsigned short v2:9;
  unsigned short v3:15;
};
//SIG(1 Ip_BFu9s_BFu15s) C1{ Fp Fs:9 Fs:15}



static void Test_Ip_BFu9s_BFu15s()
{
  {
    init_simple_test("Ip_BFu9s_BFu15s");
    static STRUCT_IF_C Ip_BFu9s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu15s, Ip_BFu9s_BFu15s)
//============================================================================


struct  Ip_BFu9s_BFu16i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:16;
};
//SIG(1 Ip_BFu9s_BFu16i) C1{ Fp Fs:9 Fi:16}



static void Test_Ip_BFu9s_BFu16i()
{
  {
    init_simple_test("Ip_BFu9s_BFu16i");
    static STRUCT_IF_C Ip_BFu9s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "Ip_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "Ip_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu16i, Ip_BFu9s_BFu16i)
//============================================================================


struct  Ip_BFu9s_BFu16ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:16;
};
//SIG(1 Ip_BFu9s_BFu16ll) C1{ Fp Fs:9 FL:16}



static void Test_Ip_BFu9s_BFu16ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu16ll");
    static STRUCT_IF_C Ip_BFu9s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "Ip_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "Ip_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu16ll, Ip_BFu9s_BFu16ll)
//============================================================================


struct  Ip_BFu9s_BFu16s  {
  int *v1;
  unsigned short v2:9;
  unsigned short v3:16;
};
//SIG(1 Ip_BFu9s_BFu16s) C1{ Fp Fs:9 Fs:16}



static void Test_Ip_BFu9s_BFu16s()
{
  {
    init_simple_test("Ip_BFu9s_BFu16s");
    static STRUCT_IF_C Ip_BFu9s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu16s, Ip_BFu9s_BFu16s)
//============================================================================


struct  Ip_BFu9s_BFu17i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:17;
};
//SIG(1 Ip_BFu9s_BFu17i) C1{ Fp Fs:9 Fi:17}



static void Test_Ip_BFu9s_BFu17i()
{
  {
    init_simple_test("Ip_BFu9s_BFu17i");
    static STRUCT_IF_C Ip_BFu9s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "Ip_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "Ip_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu17i, Ip_BFu9s_BFu17i)
//============================================================================


struct  Ip_BFu9s_BFu17ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:17;
};
//SIG(1 Ip_BFu9s_BFu17ll) C1{ Fp Fs:9 FL:17}



static void Test_Ip_BFu9s_BFu17ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu17ll");
    static STRUCT_IF_C Ip_BFu9s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "Ip_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "Ip_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu17ll, Ip_BFu9s_BFu17ll)
//============================================================================


struct  Ip_BFu9s_BFu1c  {
  int *v1;
  unsigned short v2:9;
  unsigned char v3:1;
};
//SIG(1 Ip_BFu9s_BFu1c) C1{ Fp Fs:9 Fc:1}



static void Test_Ip_BFu9s_BFu1c()
{
  {
    init_simple_test("Ip_BFu9s_BFu1c");
    static STRUCT_IF_C Ip_BFu9s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu1c, Ip_BFu9s_BFu1c)
//============================================================================


struct  Ip_BFu9s_BFu1i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:1;
};
//SIG(1 Ip_BFu9s_BFu1i) C1{ Fp Fs:9 Fi:1}



static void Test_Ip_BFu9s_BFu1i()
{
  {
    init_simple_test("Ip_BFu9s_BFu1i");
    static STRUCT_IF_C Ip_BFu9s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu1i, Ip_BFu9s_BFu1i)
//============================================================================


struct  Ip_BFu9s_BFu1ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:1;
};
//SIG(1 Ip_BFu9s_BFu1ll) C1{ Fp Fs:9 FL:1}



static void Test_Ip_BFu9s_BFu1ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu1ll");
    static STRUCT_IF_C Ip_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu1ll, Ip_BFu9s_BFu1ll)
//============================================================================


struct  Ip_BFu9s_BFu1s  {
  int *v1;
  unsigned short v2:9;
  unsigned short v3:1;
};
//SIG(1 Ip_BFu9s_BFu1s) C1{ Fp Fs:9 Fs:1}



static void Test_Ip_BFu9s_BFu1s()
{
  {
    init_simple_test("Ip_BFu9s_BFu1s");
    static STRUCT_IF_C Ip_BFu9s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "Ip_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu1s, Ip_BFu9s_BFu1s)
//============================================================================


struct  Ip_BFu9s_BFu31i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:31;
};
//SIG(1 Ip_BFu9s_BFu31i) C1{ Fp Fs:9 Fi:31}



static void Test_Ip_BFu9s_BFu31i()
{
  {
    init_simple_test("Ip_BFu9s_BFu31i");
    static STRUCT_IF_C Ip_BFu9s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu31i, Ip_BFu9s_BFu31i)
//============================================================================


struct  Ip_BFu9s_BFu31ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:31;
};
//SIG(1 Ip_BFu9s_BFu31ll) C1{ Fp Fs:9 FL:31}



static void Test_Ip_BFu9s_BFu31ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu31ll");
    static STRUCT_IF_C Ip_BFu9s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 31, 1, "Ip_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 31, hide_ull(1LL<<30), "Ip_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu31ll, Ip_BFu9s_BFu31ll)
//============================================================================


struct  Ip_BFu9s_BFu32i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:32;
};
//SIG(1 Ip_BFu9s_BFu32i) C1{ Fp Fs:9 Fi:32}



static void Test_Ip_BFu9s_BFu32i()
{
  {
    init_simple_test("Ip_BFu9s_BFu32i");
    static STRUCT_IF_C Ip_BFu9s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu32i, Ip_BFu9s_BFu32i)
//============================================================================


struct  Ip_BFu9s_BFu32ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:32;
};
//SIG(1 Ip_BFu9s_BFu32ll) C1{ Fp Fs:9 FL:32}



static void Test_Ip_BFu9s_BFu32ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu32ll");
    static STRUCT_IF_C Ip_BFu9s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 32, 1, "Ip_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 32, hide_ull(1LL<<31), "Ip_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu32ll, Ip_BFu9s_BFu32ll)
//============================================================================


struct  Ip_BFu9s_BFu33  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:33;
};
//SIG(1 Ip_BFu9s_BFu33) C1{ Fp Fs:9 FL:33}



static void Test_Ip_BFu9s_BFu33()
{
  {
    init_simple_test("Ip_BFu9s_BFu33");
    static STRUCT_IF_C Ip_BFu9s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 33, 1, "Ip_BFu9s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), ABISELECT(1,1), 33, hide_ull(1LL<<32), "Ip_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu33, Ip_BFu9s_BFu33)
//============================================================================


struct  Ip_BFu9s_BFu7c  {
  int *v1;
  unsigned short v2:9;
  unsigned char v3:7;
};
//SIG(1 Ip_BFu9s_BFu7c) C1{ Fp Fs:9 Fc:7}



static void Test_Ip_BFu9s_BFu7c()
{
  {
    init_simple_test("Ip_BFu9s_BFu7c");
    static STRUCT_IF_C Ip_BFu9s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu7c, Ip_BFu9s_BFu7c)
//============================================================================


struct  Ip_BFu9s_BFu7i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:7;
};
//SIG(1 Ip_BFu9s_BFu7i) C1{ Fp Fs:9 Fi:7}



static void Test_Ip_BFu9s_BFu7i()
{
  {
    init_simple_test("Ip_BFu9s_BFu7i");
    static STRUCT_IF_C Ip_BFu9s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu7i, Ip_BFu9s_BFu7i)
//============================================================================


struct  Ip_BFu9s_BFu7ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:7;
};
//SIG(1 Ip_BFu9s_BFu7ll) C1{ Fp Fs:9 FL:7}



static void Test_Ip_BFu9s_BFu7ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu7ll");
    static STRUCT_IF_C Ip_BFu9s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu7ll, Ip_BFu9s_BFu7ll)
//============================================================================


struct  Ip_BFu9s_BFu7s  {
  int *v1;
  unsigned short v2:9;
  unsigned short v3:7;
};
//SIG(1 Ip_BFu9s_BFu7s) C1{ Fp Fs:9 Fs:7}



static void Test_Ip_BFu9s_BFu7s()
{
  {
    init_simple_test("Ip_BFu9s_BFu7s");
    static STRUCT_IF_C Ip_BFu9s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "Ip_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "Ip_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu7s, Ip_BFu9s_BFu7s)
//============================================================================


struct  Ip_BFu9s_BFu8c  {
  int *v1;
  unsigned short v2:9;
  unsigned char v3:8;
};
//SIG(1 Ip_BFu9s_BFu8c) C1{ Fp Fs:9 Fc:8}



static void Test_Ip_BFu9s_BFu8c()
{
  {
    init_simple_test("Ip_BFu9s_BFu8c");
    static STRUCT_IF_C Ip_BFu9s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu8c, Ip_BFu9s_BFu8c)
//============================================================================


struct  Ip_BFu9s_BFu8i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:8;
};
//SIG(1 Ip_BFu9s_BFu8i) C1{ Fp Fs:9 Fi:8}



static void Test_Ip_BFu9s_BFu8i()
{
  {
    init_simple_test("Ip_BFu9s_BFu8i");
    static STRUCT_IF_C Ip_BFu9s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "Ip_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "Ip_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu8i, Ip_BFu9s_BFu8i)
//============================================================================


struct  Ip_BFu9s_BFu8ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:8;
};
//SIG(1 Ip_BFu9s_BFu8ll) C1{ Fp Fs:9 FL:8}



static void Test_Ip_BFu9s_BFu8ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu8ll");
    static STRUCT_IF_C Ip_BFu9s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "Ip_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "Ip_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu8ll, Ip_BFu9s_BFu8ll)
//============================================================================


struct  Ip_BFu9s_BFu8s  {
  int *v1;
  unsigned short v2:9;
  unsigned short v3:8;
};
//SIG(1 Ip_BFu9s_BFu8s) C1{ Fp Fs:9 Fs:8}



static void Test_Ip_BFu9s_BFu8s()
{
  {
    init_simple_test("Ip_BFu9s_BFu8s");
    static STRUCT_IF_C Ip_BFu9s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Ip_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Ip_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu8s, Ip_BFu9s_BFu8s)
//============================================================================


struct  Ip_BFu9s_BFu9i  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 Ip_BFu9s_BFu9i) C1{ Fp Fs:9 Fi:9}



static void Test_Ip_BFu9s_BFu9i()
{
  {
    init_simple_test("Ip_BFu9s_BFu9i");
    static STRUCT_IF_C Ip_BFu9s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "Ip_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu9i, Ip_BFu9s_BFu9i)
//============================================================================


struct  Ip_BFu9s_BFu9ll  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 Ip_BFu9s_BFu9ll) C1{ Fp Fs:9 FL:9}



static void Test_Ip_BFu9s_BFu9ll()
{
  {
    init_simple_test("Ip_BFu9s_BFu9ll");
    static STRUCT_IF_C Ip_BFu9s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "Ip_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu9ll, Ip_BFu9s_BFu9ll)
//============================================================================


struct  Ip_BFu9s_BFu9s  {
  int *v1;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 Ip_BFu9s_BFu9s) C1{ Fp Fs:9 Fs:9}



static void Test_Ip_BFu9s_BFu9s()
{
  {
    init_simple_test("Ip_BFu9s_BFu9s");
    static STRUCT_IF_C Ip_BFu9s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_BFu9s, Ip_BFu9s_BFu9s)
//============================================================================


struct  Ip_BFu9s_C  {
  int *v1;
  unsigned short v2:9;
  char v3;
};
//SIG(1 Ip_BFu9s_C) C1{ Fp Fs:9 Fc}



static void Test_Ip_BFu9s_C()
{
  {
    init_simple_test("Ip_BFu9s_C");
    static STRUCT_IF_C Ip_BFu9s_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_C)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_C, Ip_BFu9s_C)
//============================================================================


struct  Ip_BFu9s_D  {
  int *v1;
  unsigned short v2:9;
  double v3;
};
//SIG(1 Ip_BFu9s_D) C1{ Fp Fs:9 FL}



static void Test_Ip_BFu9s_D()
{
  {
    init_simple_test("Ip_BFu9s_D");
    static STRUCT_IF_C Ip_BFu9s_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_D)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_D");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_D, Ip_BFu9s_D)
//============================================================================


struct  Ip_BFu9s_F  {
  int *v1;
  unsigned short v2:9;
  float v3;
};
//SIG(1 Ip_BFu9s_F) C1{ Fp Fs:9 Fi}



static void Test_Ip_BFu9s_F()
{
  {
    init_simple_test("Ip_BFu9s_F");
    static STRUCT_IF_C Ip_BFu9s_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_F)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_F, Ip_BFu9s_F)
//============================================================================


struct  Ip_BFu9s_I  {
  int *v1;
  unsigned short v2:9;
  int v3;
};
//SIG(1 Ip_BFu9s_I) C1{ Fp Fs:9 Fi}



static void Test_Ip_BFu9s_I()
{
  {
    init_simple_test("Ip_BFu9s_I");
    static STRUCT_IF_C Ip_BFu9s_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_I)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_I, Ip_BFu9s_I)
//============================================================================


struct  Ip_BFu9s_Ip  {
  int *v1;
  unsigned short v2:9;
  int *v3;
};
//SIG(1 Ip_BFu9s_Ip) C1{ Fp Fs:9 Fp}



static void Test_Ip_BFu9s_Ip()
{
  {
    init_simple_test("Ip_BFu9s_Ip");
    static STRUCT_IF_C Ip_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu9s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_Ip, Ip_BFu9s_Ip)
//============================================================================


struct  Ip_BFu9s_L  {
  int *v1;
  unsigned short v2:9;
  __tsi64 v3;
};
//SIG(1 Ip_BFu9s_L) C1{ Fp Fs:9 FL}



static void Test_Ip_BFu9s_L()
{
  {
    init_simple_test("Ip_BFu9s_L");
    static STRUCT_IF_C Ip_BFu9s_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_L)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_L");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_L, Ip_BFu9s_L)
//============================================================================


struct  Ip_BFu9s_S  {
  int *v1;
  unsigned short v2:9;
  short v3;
};
//SIG(1 Ip_BFu9s_S) C1{ Fp Fs:9 Fs}



static void Test_Ip_BFu9s_S()
{
  {
    init_simple_test("Ip_BFu9s_S");
    static STRUCT_IF_C Ip_BFu9s_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_S)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_S, Ip_BFu9s_S)
//============================================================================


struct  Ip_BFu9s_Uc  {
  int *v1;
  unsigned short v2:9;
  unsigned char v3;
};
//SIG(1 Ip_BFu9s_Uc) C1{ Fp Fs:9 Fc}



static void Test_Ip_BFu9s_Uc()
{
  {
    init_simple_test("Ip_BFu9s_Uc");
    static STRUCT_IF_C Ip_BFu9s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_Uc, Ip_BFu9s_Uc)
//============================================================================


struct  Ip_BFu9s_Ui  {
  int *v1;
  unsigned short v2:9;
  unsigned int v3;
};
//SIG(1 Ip_BFu9s_Ui) C1{ Fp Fs:9 Fi}



static void Test_Ip_BFu9s_Ui()
{
  {
    init_simple_test("Ip_BFu9s_Ui");
    static STRUCT_IF_C Ip_BFu9s_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_BFu9s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_Ui, Ip_BFu9s_Ui)
//============================================================================


struct  Ip_BFu9s_Ul  {
  int *v1;
  unsigned short v2:9;
  __tsu64 v3;
};
//SIG(1 Ip_BFu9s_Ul) C1{ Fp Fs:9 FL}



static void Test_Ip_BFu9s_Ul()
{
  {
    init_simple_test("Ip_BFu9s_Ul");
    static STRUCT_IF_C Ip_BFu9s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_BFu9s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_Ul, Ip_BFu9s_Ul)
//============================================================================


struct  Ip_BFu9s_Us  {
  int *v1;
  unsigned short v2:9;
  unsigned short v3;
};
//SIG(1 Ip_BFu9s_Us) C1{ Fp Fs:9 Fs}



static void Test_Ip_BFu9s_Us()
{
  {
    init_simple_test("Ip_BFu9s_Us");
    static STRUCT_IF_C Ip_BFu9s_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_BFu9s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_Us, Ip_BFu9s_Us)
//============================================================================


struct  Ip_BFu9s_Vp  {
  int *v1;
  unsigned short v2:9;
  void *v3;
};
//SIG(1 Ip_BFu9s_Vp) C1{ Fp Fs:9 Fp}



static void Test_Ip_BFu9s_Vp()
{
  {
    init_simple_test("Ip_BFu9s_Vp");
    static STRUCT_IF_C Ip_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_BFu9s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "Ip_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ip_BFu9s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ip_BFu9s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_BFu9s_Vp, Ip_BFu9s_Vp)
//============================================================================


struct  Ip_C  {
  int *v1;
  char v2;
};
//SIG(1 Ip_C) C1{ Fp Fc}



static void Test_Ip_C()
{
  {
    init_simple_test("Ip_C");
    STRUCT_IF_C Ip_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C)");
    check_field_offset(lv, v1, 0, "Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C, Ip_C)
//============================================================================


struct  Ip_C_BFu15i  {
  int *v1;
  char v2;
  unsigned int v3:15;
};
//SIG(1 Ip_C_BFu15i) C1{ Fp Fc Fi:15}



static void Test_Ip_C_BFu15i()
{
  {
    init_simple_test("Ip_C_BFu15i");
    static STRUCT_IF_C Ip_C_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_C_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu15i, Ip_C_BFu15i)
//============================================================================


struct  Ip_C_BFu15ll  {
  int *v1;
  char v2;
  __tsu64 v3:15;
};
//SIG(1 Ip_C_BFu15ll) C1{ Fp Fc FL:15}



static void Test_Ip_C_BFu15ll()
{
  {
    init_simple_test("Ip_C_BFu15ll");
    static STRUCT_IF_C Ip_C_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Ip_C_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Ip_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu15ll, Ip_C_BFu15ll)
//============================================================================


struct  Ip_C_BFu15s  {
  int *v1;
  char v2;
  unsigned short v3:15;
};
//SIG(1 Ip_C_BFu15s) C1{ Fp Fc Fs:15}



static void Test_Ip_C_BFu15s()
{
  {
    init_simple_test("Ip_C_BFu15s");
    static STRUCT_IF_C Ip_C_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Ip_C_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Ip_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu15s, Ip_C_BFu15s)
//============================================================================


struct  Ip_C_BFu16i  {
  int *v1;
  char v2;
  unsigned int v3:16;
};
//SIG(1 Ip_C_BFu16i) C1{ Fp Fc Fi:16}



static void Test_Ip_C_BFu16i()
{
  {
    init_simple_test("Ip_C_BFu16i");
    static STRUCT_IF_C Ip_C_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_C_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu16i, Ip_C_BFu16i)
//============================================================================


struct  Ip_C_BFu16ll  {
  int *v1;
  char v2;
  __tsu64 v3:16;
};
//SIG(1 Ip_C_BFu16ll) C1{ Fp Fc FL:16}



static void Test_Ip_C_BFu16ll()
{
  {
    init_simple_test("Ip_C_BFu16ll");
    static STRUCT_IF_C Ip_C_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Ip_C_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Ip_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu16ll, Ip_C_BFu16ll)
//============================================================================


struct  Ip_C_BFu16s  {
  int *v1;
  char v2;
  unsigned short v3:16;
};
//SIG(1 Ip_C_BFu16s) C1{ Fp Fc Fs:16}



static void Test_Ip_C_BFu16s()
{
  {
    init_simple_test("Ip_C_BFu16s");
    static STRUCT_IF_C Ip_C_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Ip_C_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Ip_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu16s, Ip_C_BFu16s)
//============================================================================


struct  Ip_C_BFu17i  {
  int *v1;
  char v2;
  unsigned int v3:17;
};
//SIG(1 Ip_C_BFu17i) C1{ Fp Fc Fi:17}



static void Test_Ip_C_BFu17i()
{
  {
    init_simple_test("Ip_C_BFu17i");
    static STRUCT_IF_C Ip_C_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_C_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu17i, Ip_C_BFu17i)
//============================================================================


struct  Ip_C_BFu17ll  {
  int *v1;
  char v2;
  __tsu64 v3:17;
};
//SIG(1 Ip_C_BFu17ll) C1{ Fp Fc FL:17}



static void Test_Ip_C_BFu17ll()
{
  {
    init_simple_test("Ip_C_BFu17ll");
    static STRUCT_IF_C Ip_C_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Ip_C_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Ip_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu17ll, Ip_C_BFu17ll)
//============================================================================


struct  Ip_C_BFu1c  {
  int *v1;
  char v2;
  unsigned char v3:1;
};
//SIG(1 Ip_C_BFu1c) C1{ Fp Fc Fc:1}



static void Test_Ip_C_BFu1c()
{
  {
    init_simple_test("Ip_C_BFu1c");
    static STRUCT_IF_C Ip_C_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu1c, Ip_C_BFu1c)
//============================================================================


struct  Ip_C_BFu1i  {
  int *v1;
  char v2;
  unsigned int v3:1;
};
//SIG(1 Ip_C_BFu1i) C1{ Fp Fc Fi:1}



static void Test_Ip_C_BFu1i()
{
  {
    init_simple_test("Ip_C_BFu1i");
    static STRUCT_IF_C Ip_C_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu1i, Ip_C_BFu1i)
//============================================================================


struct  Ip_C_BFu1ll  {
  int *v1;
  char v2;
  __tsu64 v3:1;
};
//SIG(1 Ip_C_BFu1ll) C1{ Fp Fc FL:1}



static void Test_Ip_C_BFu1ll()
{
  {
    init_simple_test("Ip_C_BFu1ll");
    static STRUCT_IF_C Ip_C_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu1ll, Ip_C_BFu1ll)
//============================================================================


struct  Ip_C_BFu1s  {
  int *v1;
  char v2;
  unsigned short v3:1;
};
//SIG(1 Ip_C_BFu1s) C1{ Fp Fc Fs:1}



static void Test_Ip_C_BFu1s()
{
  {
    init_simple_test("Ip_C_BFu1s");
    static STRUCT_IF_C Ip_C_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Ip_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu1s, Ip_C_BFu1s)
//============================================================================


struct  Ip_C_BFu31i  {
  int *v1;
  char v2;
  unsigned int v3:31;
};
//SIG(1 Ip_C_BFu31i) C1{ Fp Fc Fi:31}



static void Test_Ip_C_BFu31i()
{
  {
    init_simple_test("Ip_C_BFu31i");
    static STRUCT_IF_C Ip_C_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_C_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_C_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu31i, Ip_C_BFu31i)
//============================================================================


struct  Ip_C_BFu31ll  {
  int *v1;
  char v2;
  __tsu64 v3:31;
};
//SIG(1 Ip_C_BFu31ll) C1{ Fp Fc FL:31}



static void Test_Ip_C_BFu31ll()
{
  {
    init_simple_test("Ip_C_BFu31ll");
    static STRUCT_IF_C Ip_C_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_C_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Ip_C_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Ip_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu31ll, Ip_C_BFu31ll)
//============================================================================


struct  Ip_C_BFu32i  {
  int *v1;
  char v2;
  unsigned int v3:32;
};
//SIG(1 Ip_C_BFu32i) C1{ Fp Fc Fi:32}



static void Test_Ip_C_BFu32i()
{
  {
    init_simple_test("Ip_C_BFu32i");
    static STRUCT_IF_C Ip_C_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_C_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_C_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu32i, Ip_C_BFu32i)
//============================================================================


struct  Ip_C_BFu32ll  {
  int *v1;
  char v2;
  __tsu64 v3:32;
};
//SIG(1 Ip_C_BFu32ll) C1{ Fp Fc FL:32}



static void Test_Ip_C_BFu32ll()
{
  {
    init_simple_test("Ip_C_BFu32ll");
    static STRUCT_IF_C Ip_C_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_C_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Ip_C_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Ip_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu32ll, Ip_C_BFu32ll)
//============================================================================


struct  Ip_C_BFu33  {
  int *v1;
  char v2;
  __tsu64 v3:33;
};
//SIG(1 Ip_C_BFu33) C1{ Fp Fc FL:33}



static void Test_Ip_C_BFu33()
{
  {
    init_simple_test("Ip_C_BFu33");
    static STRUCT_IF_C Ip_C_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_C_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "Ip_C_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "Ip_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu33, Ip_C_BFu33)
//============================================================================


struct  Ip_C_BFu7c  {
  int *v1;
  char v2;
  unsigned char v3:7;
};
//SIG(1 Ip_C_BFu7c) C1{ Fp Fc Fc:7}



static void Test_Ip_C_BFu7c()
{
  {
    init_simple_test("Ip_C_BFu7c");
    static STRUCT_IF_C Ip_C_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_C_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu7c, Ip_C_BFu7c)
//============================================================================


struct  Ip_C_BFu7i  {
  int *v1;
  char v2;
  unsigned int v3:7;
};
//SIG(1 Ip_C_BFu7i) C1{ Fp Fc Fi:7}



static void Test_Ip_C_BFu7i()
{
  {
    init_simple_test("Ip_C_BFu7i");
    static STRUCT_IF_C Ip_C_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_C_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu7i, Ip_C_BFu7i)
//============================================================================


struct  Ip_C_BFu7ll  {
  int *v1;
  char v2;
  __tsu64 v3:7;
};
//SIG(1 Ip_C_BFu7ll) C1{ Fp Fc FL:7}



static void Test_Ip_C_BFu7ll()
{
  {
    init_simple_test("Ip_C_BFu7ll");
    static STRUCT_IF_C Ip_C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_C_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu7ll, Ip_C_BFu7ll)
//============================================================================


struct  Ip_C_BFu7s  {
  int *v1;
  char v2;
  unsigned short v3:7;
};
//SIG(1 Ip_C_BFu7s) C1{ Fp Fc Fs:7}



static void Test_Ip_C_BFu7s()
{
  {
    init_simple_test("Ip_C_BFu7s");
    static STRUCT_IF_C Ip_C_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Ip_C_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Ip_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu7s, Ip_C_BFu7s)
//============================================================================


struct  Ip_C_BFu8c  {
  int *v1;
  char v2;
  unsigned char v3:8;
};
//SIG(1 Ip_C_BFu8c) C1{ Fp Fc Fc:8}



static void Test_Ip_C_BFu8c()
{
  {
    init_simple_test("Ip_C_BFu8c");
    static STRUCT_IF_C Ip_C_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_C_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu8c, Ip_C_BFu8c)
//============================================================================


struct  Ip_C_BFu8i  {
  int *v1;
  char v2;
  unsigned int v3:8;
};
//SIG(1 Ip_C_BFu8i) C1{ Fp Fc Fi:8}



static void Test_Ip_C_BFu8i()
{
  {
    init_simple_test("Ip_C_BFu8i");
    static STRUCT_IF_C Ip_C_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_C_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu8i, Ip_C_BFu8i)
//============================================================================


struct  Ip_C_BFu8ll  {
  int *v1;
  char v2;
  __tsu64 v3:8;
};
//SIG(1 Ip_C_BFu8ll) C1{ Fp Fc FL:8}



static void Test_Ip_C_BFu8ll()
{
  {
    init_simple_test("Ip_C_BFu8ll");
    static STRUCT_IF_C Ip_C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_C_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu8ll, Ip_C_BFu8ll)
//============================================================================


struct  Ip_C_BFu8s  {
  int *v1;
  char v2;
  unsigned short v3:8;
};
//SIG(1 Ip_C_BFu8s) C1{ Fp Fc Fs:8}



static void Test_Ip_C_BFu8s()
{
  {
    init_simple_test("Ip_C_BFu8s");
    static STRUCT_IF_C Ip_C_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Ip_C_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Ip_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu8s, Ip_C_BFu8s)
//============================================================================


struct  Ip_C_BFu9i  {
  int *v1;
  char v2;
  unsigned int v3:9;
};
//SIG(1 Ip_C_BFu9i) C1{ Fp Fc Fi:9}



static void Test_Ip_C_BFu9i()
{
  {
    init_simple_test("Ip_C_BFu9i");
    static STRUCT_IF_C Ip_C_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_C_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu9i, Ip_C_BFu9i)
//============================================================================


struct  Ip_C_BFu9ll  {
  int *v1;
  char v2;
  __tsu64 v3:9;
};
//SIG(1 Ip_C_BFu9ll) C1{ Fp Fc FL:9}



static void Test_Ip_C_BFu9ll()
{
  {
    init_simple_test("Ip_C_BFu9ll");
    static STRUCT_IF_C Ip_C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Ip_C_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Ip_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu9ll, Ip_C_BFu9ll)
//============================================================================


struct  Ip_C_BFu9s  {
  int *v1;
  char v2;
  unsigned short v3:9;
};
//SIG(1 Ip_C_BFu9s) C1{ Fp Fc Fs:9}



static void Test_Ip_C_BFu9s()
{
  {
    init_simple_test("Ip_C_BFu9s");
    static STRUCT_IF_C Ip_C_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_C_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Ip_C_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Ip_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_BFu9s, Ip_C_BFu9s)
//============================================================================


struct  Ip_C_C  {
  int *v1;
  char v2;
  char v3;
};
//SIG(1 Ip_C_C) C1{ Fp Fc[2]}



static void Test_Ip_C_C()
{
  {
    init_simple_test("Ip_C_C");
    STRUCT_IF_C Ip_C_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_C)");
    check_field_offset(lv, v1, 0, "Ip_C_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_C, Ip_C_C)
//============================================================================


struct  Ip_C_D  {
  int *v1;
  char v2;
  double v3;
};
//SIG(1 Ip_C_D) C1{ Fp Fc FL}



static void Test_Ip_C_D()
{
  {
    init_simple_test("Ip_C_D");
    STRUCT_IF_C Ip_C_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_D)");
    check_field_offset(lv, v1, 0, "Ip_C_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_D, Ip_C_D)
//============================================================================


struct  Ip_C_F  {
  int *v1;
  char v2;
  float v3;
};
//SIG(1 Ip_C_F) C1{ Fp Fc Fi}



static void Test_Ip_C_F()
{
  {
    init_simple_test("Ip_C_F");
    STRUCT_IF_C Ip_C_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_C_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_F)");
    check_field_offset(lv, v1, 0, "Ip_C_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_F.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_F, Ip_C_F)
//============================================================================


struct  Ip_C_I  {
  int *v1;
  char v2;
  int v3;
};
//SIG(1 Ip_C_I) C1{ Fp Fc Fi}



static void Test_Ip_C_I()
{
  {
    init_simple_test("Ip_C_I");
    STRUCT_IF_C Ip_C_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_C_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_I)");
    check_field_offset(lv, v1, 0, "Ip_C_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_I.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_I, Ip_C_I)
//============================================================================


struct  Ip_C_Ip  {
  int *v1;
  char v2;
  int *v3;
};
//SIG(1 Ip_C_Ip) C1{ Fp Fc Fp}



static void Test_Ip_C_Ip()
{
  {
    init_simple_test("Ip_C_Ip");
    STRUCT_IF_C Ip_C_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_Ip)");
    check_field_offset(lv, v1, 0, "Ip_C_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_Ip, Ip_C_Ip)
//============================================================================


struct  Ip_C_L  {
  int *v1;
  char v2;
  __tsi64 v3;
};
//SIG(1 Ip_C_L) C1{ Fp Fc FL}



static void Test_Ip_C_L()
{
  {
    init_simple_test("Ip_C_L");
    STRUCT_IF_C Ip_C_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_L)");
    check_field_offset(lv, v1, 0, "Ip_C_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_L, Ip_C_L)
//============================================================================


struct  Ip_C_S  {
  int *v1;
  char v2;
  short v3;
};
//SIG(1 Ip_C_S) C1{ Fp Fc Fs}



static void Test_Ip_C_S()
{
  {
    init_simple_test("Ip_C_S");
    STRUCT_IF_C Ip_C_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_S)");
    check_field_offset(lv, v1, 0, "Ip_C_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_S, Ip_C_S)
//============================================================================


struct  Ip_C_Uc  {
  int *v1;
  char v2;
  unsigned char v3;
};
//SIG(1 Ip_C_Uc) C1{ Fp Fc[2]}



static void Test_Ip_C_Uc()
{
  {
    init_simple_test("Ip_C_Uc");
    STRUCT_IF_C Ip_C_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_Uc)");
    check_field_offset(lv, v1, 0, "Ip_C_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Ip_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_Uc, Ip_C_Uc)
//============================================================================


struct  Ip_C_Ui  {
  int *v1;
  char v2;
  unsigned int v3;
};
//SIG(1 Ip_C_Ui) C1{ Fp Fc Fi}



static void Test_Ip_C_Ui()
{
  {
    init_simple_test("Ip_C_Ui");
    STRUCT_IF_C Ip_C_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_C_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_Ui)");
    check_field_offset(lv, v1, 0, "Ip_C_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_Ui, Ip_C_Ui)
//============================================================================


struct  Ip_C_Ul  {
  int *v1;
  char v2;
  __tsu64 v3;
};
//SIG(1 Ip_C_Ul) C1{ Fp Fc FL}



static void Test_Ip_C_Ul()
{
  {
    init_simple_test("Ip_C_Ul");
    STRUCT_IF_C Ip_C_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_Ul)");
    check_field_offset(lv, v1, 0, "Ip_C_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_Ul, Ip_C_Ul)
//============================================================================


struct  Ip_C_Us  {
  int *v1;
  char v2;
  unsigned short v3;
};
//SIG(1 Ip_C_Us) C1{ Fp Fc Fs}



static void Test_Ip_C_Us()
{
  {
    init_simple_test("Ip_C_Us");
    STRUCT_IF_C Ip_C_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_C_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_Us)");
    check_field_offset(lv, v1, 0, "Ip_C_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Ip_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_Us, Ip_C_Us)
//============================================================================


struct  Ip_C_Vp  {
  int *v1;
  char v2;
  void *v3;
};
//SIG(1 Ip_C_Vp) C1{ Fp Fc Fp}



static void Test_Ip_C_Vp()
{
  {
    init_simple_test("Ip_C_Vp");
    STRUCT_IF_C Ip_C_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_C_Vp)");
    check_field_offset(lv, v1, 0, "Ip_C_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_C_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_C_Vp, Ip_C_Vp)
//============================================================================


struct  Ip_D  {
  int *v1;
  double v2;
};
//SIG(1 Ip_D) C1{ Fp FL}



static void Test_Ip_D()
{
  {
    init_simple_test("Ip_D");
    STRUCT_IF_C Ip_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D)");
    check_field_offset(lv, v1, 0, "Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D, Ip_D)
//============================================================================


struct  Ip_D_BFu15i  {
  int *v1;
  double v2;
  unsigned int v3:15;
};
//SIG(1 Ip_D_BFu15i) C1{ Fp FL Fi:15}



static void Test_Ip_D_BFu15i()
{
  {
    init_simple_test("Ip_D_BFu15i");
    static STRUCT_IF_C Ip_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ip_D_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ip_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu15i, Ip_D_BFu15i)
//============================================================================


struct  Ip_D_BFu15ll  {
  int *v1;
  double v2;
  __tsu64 v3:15;
};
//SIG(1 Ip_D_BFu15ll) C1{ Fp FL FL:15}



static void Test_Ip_D_BFu15ll()
{
  {
    init_simple_test("Ip_D_BFu15ll");
    static STRUCT_IF_C Ip_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ip_D_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ip_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu15ll, Ip_D_BFu15ll)
//============================================================================


struct  Ip_D_BFu15s  {
  int *v1;
  double v2;
  unsigned short v3:15;
};
//SIG(1 Ip_D_BFu15s) C1{ Fp FL Fs:15}



static void Test_Ip_D_BFu15s()
{
  {
    init_simple_test("Ip_D_BFu15s");
    static STRUCT_IF_C Ip_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ip_D_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ip_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu15s, Ip_D_BFu15s)
//============================================================================


struct  Ip_D_BFu16i  {
  int *v1;
  double v2;
  unsigned int v3:16;
};
//SIG(1 Ip_D_BFu16i) C1{ Fp FL Fi:16}



static void Test_Ip_D_BFu16i()
{
  {
    init_simple_test("Ip_D_BFu16i");
    static STRUCT_IF_C Ip_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ip_D_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ip_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu16i, Ip_D_BFu16i)
//============================================================================


struct  Ip_D_BFu16ll  {
  int *v1;
  double v2;
  __tsu64 v3:16;
};
//SIG(1 Ip_D_BFu16ll) C1{ Fp FL FL:16}



static void Test_Ip_D_BFu16ll()
{
  {
    init_simple_test("Ip_D_BFu16ll");
    static STRUCT_IF_C Ip_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ip_D_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ip_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu16ll, Ip_D_BFu16ll)
//============================================================================


struct  Ip_D_BFu16s  {
  int *v1;
  double v2;
  unsigned short v3:16;
};
//SIG(1 Ip_D_BFu16s) C1{ Fp FL Fs:16}



static void Test_Ip_D_BFu16s()
{
  {
    init_simple_test("Ip_D_BFu16s");
    static STRUCT_IF_C Ip_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ip_D_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ip_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu16s, Ip_D_BFu16s)
//============================================================================


struct  Ip_D_BFu17i  {
  int *v1;
  double v2;
  unsigned int v3:17;
};
//SIG(1 Ip_D_BFu17i) C1{ Fp FL Fi:17}



static void Test_Ip_D_BFu17i()
{
  {
    init_simple_test("Ip_D_BFu17i");
    static STRUCT_IF_C Ip_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Ip_D_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Ip_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu17i, Ip_D_BFu17i)
//============================================================================


struct  Ip_D_BFu17ll  {
  int *v1;
  double v2;
  __tsu64 v3:17;
};
//SIG(1 Ip_D_BFu17ll) C1{ Fp FL FL:17}



static void Test_Ip_D_BFu17ll()
{
  {
    init_simple_test("Ip_D_BFu17ll");
    static STRUCT_IF_C Ip_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Ip_D_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Ip_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu17ll, Ip_D_BFu17ll)
//============================================================================


struct  Ip_D_BFu1c  {
  int *v1;
  double v2;
  unsigned char v3:1;
};
//SIG(1 Ip_D_BFu1c) C1{ Fp FL Fc:1}



static void Test_Ip_D_BFu1c()
{
  {
    init_simple_test("Ip_D_BFu1c");
    static STRUCT_IF_C Ip_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ip_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu1c, Ip_D_BFu1c)
//============================================================================


struct  Ip_D_BFu1i  {
  int *v1;
  double v2;
  unsigned int v3:1;
};
//SIG(1 Ip_D_BFu1i) C1{ Fp FL Fi:1}



static void Test_Ip_D_BFu1i()
{
  {
    init_simple_test("Ip_D_BFu1i");
    static STRUCT_IF_C Ip_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ip_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu1i, Ip_D_BFu1i)
//============================================================================


struct  Ip_D_BFu1ll  {
  int *v1;
  double v2;
  __tsu64 v3:1;
};
//SIG(1 Ip_D_BFu1ll) C1{ Fp FL FL:1}



static void Test_Ip_D_BFu1ll()
{
  {
    init_simple_test("Ip_D_BFu1ll");
    static STRUCT_IF_C Ip_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ip_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu1ll, Ip_D_BFu1ll)
//============================================================================


struct  Ip_D_BFu1s  {
  int *v1;
  double v2;
  unsigned short v3:1;
};
//SIG(1 Ip_D_BFu1s) C1{ Fp FL Fs:1}



static void Test_Ip_D_BFu1s()
{
  {
    init_simple_test("Ip_D_BFu1s");
    static STRUCT_IF_C Ip_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ip_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu1s, Ip_D_BFu1s)
//============================================================================


struct  Ip_D_BFu31i  {
  int *v1;
  double v2;
  unsigned int v3:31;
};
//SIG(1 Ip_D_BFu31i) C1{ Fp FL Fi:31}



static void Test_Ip_D_BFu31i()
{
  {
    init_simple_test("Ip_D_BFu31i");
    static STRUCT_IF_C Ip_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Ip_D_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Ip_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu31i, Ip_D_BFu31i)
//============================================================================


struct  Ip_D_BFu31ll  {
  int *v1;
  double v2;
  __tsu64 v3:31;
};
//SIG(1 Ip_D_BFu31ll) C1{ Fp FL FL:31}



static void Test_Ip_D_BFu31ll()
{
  {
    init_simple_test("Ip_D_BFu31ll");
    static STRUCT_IF_C Ip_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Ip_D_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Ip_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu31ll, Ip_D_BFu31ll)
//============================================================================


struct  Ip_D_BFu32i  {
  int *v1;
  double v2;
  unsigned int v3:32;
};
//SIG(1 Ip_D_BFu32i) C1{ Fp FL Fi:32}



static void Test_Ip_D_BFu32i()
{
  {
    init_simple_test("Ip_D_BFu32i");
    static STRUCT_IF_C Ip_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Ip_D_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Ip_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu32i, Ip_D_BFu32i)
//============================================================================


struct  Ip_D_BFu32ll  {
  int *v1;
  double v2;
  __tsu64 v3:32;
};
//SIG(1 Ip_D_BFu32ll) C1{ Fp FL FL:32}



static void Test_Ip_D_BFu32ll()
{
  {
    init_simple_test("Ip_D_BFu32ll");
    static STRUCT_IF_C Ip_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Ip_D_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Ip_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu32ll, Ip_D_BFu32ll)
//============================================================================


struct  Ip_D_BFu33  {
  int *v1;
  double v2;
  __tsu64 v3:33;
};
//SIG(1 Ip_D_BFu33) C1{ Fp FL FL:33}



static void Test_Ip_D_BFu33()
{
  {
    init_simple_test("Ip_D_BFu33");
    static STRUCT_IF_C Ip_D_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ip_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Ip_D_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Ip_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu33, Ip_D_BFu33)
//============================================================================


struct  Ip_D_BFu7c  {
  int *v1;
  double v2;
  unsigned char v3:7;
};
//SIG(1 Ip_D_BFu7c) C1{ Fp FL Fc:7}



static void Test_Ip_D_BFu7c()
{
  {
    init_simple_test("Ip_D_BFu7c");
    static STRUCT_IF_C Ip_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ip_D_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ip_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu7c, Ip_D_BFu7c)
//============================================================================


struct  Ip_D_BFu7i  {
  int *v1;
  double v2;
  unsigned int v3:7;
};
//SIG(1 Ip_D_BFu7i) C1{ Fp FL Fi:7}



static void Test_Ip_D_BFu7i()
{
  {
    init_simple_test("Ip_D_BFu7i");
    static STRUCT_IF_C Ip_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ip_D_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ip_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu7i, Ip_D_BFu7i)
//============================================================================


struct  Ip_D_BFu7ll  {
  int *v1;
  double v2;
  __tsu64 v3:7;
};
//SIG(1 Ip_D_BFu7ll) C1{ Fp FL FL:7}



static void Test_Ip_D_BFu7ll()
{
  {
    init_simple_test("Ip_D_BFu7ll");
    static STRUCT_IF_C Ip_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ip_D_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ip_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu7ll, Ip_D_BFu7ll)
//============================================================================


struct  Ip_D_BFu7s  {
  int *v1;
  double v2;
  unsigned short v3:7;
};
//SIG(1 Ip_D_BFu7s) C1{ Fp FL Fs:7}



static void Test_Ip_D_BFu7s()
{
  {
    init_simple_test("Ip_D_BFu7s");
    static STRUCT_IF_C Ip_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ip_D_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ip_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu7s, Ip_D_BFu7s)
//============================================================================


struct  Ip_D_BFu8c  {
  int *v1;
  double v2;
  unsigned char v3:8;
};
//SIG(1 Ip_D_BFu8c) C1{ Fp FL Fc:8}



static void Test_Ip_D_BFu8c()
{
  {
    init_simple_test("Ip_D_BFu8c");
    static STRUCT_IF_C Ip_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ip_D_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ip_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu8c, Ip_D_BFu8c)
//============================================================================


struct  Ip_D_BFu8i  {
  int *v1;
  double v2;
  unsigned int v3:8;
};
//SIG(1 Ip_D_BFu8i) C1{ Fp FL Fi:8}



static void Test_Ip_D_BFu8i()
{
  {
    init_simple_test("Ip_D_BFu8i");
    static STRUCT_IF_C Ip_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ip_D_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ip_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu8i, Ip_D_BFu8i)
//============================================================================


struct  Ip_D_BFu8ll  {
  int *v1;
  double v2;
  __tsu64 v3:8;
};
//SIG(1 Ip_D_BFu8ll) C1{ Fp FL FL:8}



static void Test_Ip_D_BFu8ll()
{
  {
    init_simple_test("Ip_D_BFu8ll");
    static STRUCT_IF_C Ip_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ip_D_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ip_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu8ll, Ip_D_BFu8ll)
//============================================================================


struct  Ip_D_BFu8s  {
  int *v1;
  double v2;
  unsigned short v3:8;
};
//SIG(1 Ip_D_BFu8s) C1{ Fp FL Fs:8}



static void Test_Ip_D_BFu8s()
{
  {
    init_simple_test("Ip_D_BFu8s");
    static STRUCT_IF_C Ip_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ip_D_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ip_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu8s, Ip_D_BFu8s)
//============================================================================


struct  Ip_D_BFu9i  {
  int *v1;
  double v2;
  unsigned int v3:9;
};
//SIG(1 Ip_D_BFu9i) C1{ Fp FL Fi:9}



static void Test_Ip_D_BFu9i()
{
  {
    init_simple_test("Ip_D_BFu9i");
    static STRUCT_IF_C Ip_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ip_D_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ip_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu9i, Ip_D_BFu9i)
//============================================================================


struct  Ip_D_BFu9ll  {
  int *v1;
  double v2;
  __tsu64 v3:9;
};
//SIG(1 Ip_D_BFu9ll) C1{ Fp FL FL:9}



static void Test_Ip_D_BFu9ll()
{
  {
    init_simple_test("Ip_D_BFu9ll");
    static STRUCT_IF_C Ip_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ip_D_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ip_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu9ll, Ip_D_BFu9ll)
//============================================================================


struct  Ip_D_BFu9s  {
  int *v1;
  double v2;
  unsigned short v3:9;
};
//SIG(1 Ip_D_BFu9s) C1{ Fp FL Fs:9}



static void Test_Ip_D_BFu9s()
{
  {
    init_simple_test("Ip_D_BFu9s");
    static STRUCT_IF_C Ip_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_D_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ip_D_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ip_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_BFu9s, Ip_D_BFu9s)
//============================================================================


struct  Ip_D_C  {
  int *v1;
  double v2;
  char v3;
};
//SIG(1 Ip_D_C) C1{ Fp FL Fc}



static void Test_Ip_D_C()
{
  {
    init_simple_test("Ip_D_C");
    STRUCT_IF_C Ip_D_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_C)");
    check_field_offset(lv, v1, 0, "Ip_D_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_C, Ip_D_C)
//============================================================================


struct  Ip_D_D  {
  int *v1;
  double v2;
  double v3;
};
//SIG(1 Ip_D_D) C1{ Fp FL[2]}



static void Test_Ip_D_D()
{
  {
    init_simple_test("Ip_D_D");
    STRUCT_IF_C Ip_D_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ip_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_D)");
    check_field_offset(lv, v1, 0, "Ip_D_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_D, Ip_D_D)
//============================================================================


struct  Ip_D_F  {
  int *v1;
  double v2;
  float v3;
};
//SIG(1 Ip_D_F) C1{ Fp FL Fi}



static void Test_Ip_D_F()
{
  {
    init_simple_test("Ip_D_F");
    STRUCT_IF_C Ip_D_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_F)");
    check_field_offset(lv, v1, 0, "Ip_D_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_F, Ip_D_F)
//============================================================================


struct  Ip_D_I  {
  int *v1;
  double v2;
  int v3;
};
//SIG(1 Ip_D_I) C1{ Fp FL Fi}



static void Test_Ip_D_I()
{
  {
    init_simple_test("Ip_D_I");
    STRUCT_IF_C Ip_D_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_I)");
    check_field_offset(lv, v1, 0, "Ip_D_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_I, Ip_D_I)
//============================================================================


struct  Ip_D_Ip  {
  int *v1;
  double v2;
  int *v3;
};
//SIG(1 Ip_D_Ip) C1{ Fp FL Fp}



static void Test_Ip_D_Ip()
{
  {
    init_simple_test("Ip_D_Ip");
    STRUCT_IF_C Ip_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_Ip)");
    check_field_offset(lv, v1, 0, "Ip_D_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_Ip, Ip_D_Ip)
//============================================================================


struct  Ip_D_L  {
  int *v1;
  double v2;
  __tsi64 v3;
};
//SIG(1 Ip_D_L) C1{ Fp FL[2]}



static void Test_Ip_D_L()
{
  {
    init_simple_test("Ip_D_L");
    STRUCT_IF_C Ip_D_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ip_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_L)");
    check_field_offset(lv, v1, 0, "Ip_D_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_L, Ip_D_L)
//============================================================================


struct  Ip_D_S  {
  int *v1;
  double v2;
  short v3;
};
//SIG(1 Ip_D_S) C1{ Fp FL Fs}



static void Test_Ip_D_S()
{
  {
    init_simple_test("Ip_D_S");
    STRUCT_IF_C Ip_D_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_S)");
    check_field_offset(lv, v1, 0, "Ip_D_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_S, Ip_D_S)
//============================================================================


struct  Ip_D_Uc  {
  int *v1;
  double v2;
  unsigned char v3;
};
//SIG(1 Ip_D_Uc) C1{ Fp FL Fc}



static void Test_Ip_D_Uc()
{
  {
    init_simple_test("Ip_D_Uc");
    STRUCT_IF_C Ip_D_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_Uc)");
    check_field_offset(lv, v1, 0, "Ip_D_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_Uc, Ip_D_Uc)
//============================================================================


struct  Ip_D_Ui  {
  int *v1;
  double v2;
  unsigned int v3;
};
//SIG(1 Ip_D_Ui) C1{ Fp FL Fi}



static void Test_Ip_D_Ui()
{
  {
    init_simple_test("Ip_D_Ui");
    STRUCT_IF_C Ip_D_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_Ui)");
    check_field_offset(lv, v1, 0, "Ip_D_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_Ui, Ip_D_Ui)
//============================================================================


struct  Ip_D_Ul  {
  int *v1;
  double v2;
  __tsu64 v3;
};
//SIG(1 Ip_D_Ul) C1{ Fp FL[2]}



static void Test_Ip_D_Ul()
{
  {
    init_simple_test("Ip_D_Ul");
    STRUCT_IF_C Ip_D_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ip_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_Ul)");
    check_field_offset(lv, v1, 0, "Ip_D_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_Ul, Ip_D_Ul)
//============================================================================


struct  Ip_D_Us  {
  int *v1;
  double v2;
  unsigned short v3;
};
//SIG(1 Ip_D_Us) C1{ Fp FL Fs}



static void Test_Ip_D_Us()
{
  {
    init_simple_test("Ip_D_Us");
    STRUCT_IF_C Ip_D_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_Us)");
    check_field_offset(lv, v1, 0, "Ip_D_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_Us, Ip_D_Us)
//============================================================================


struct  Ip_D_Vp  {
  int *v1;
  double v2;
  void *v3;
};
//SIG(1 Ip_D_Vp) C1{ Fp FL Fp}



static void Test_Ip_D_Vp()
{
  {
    init_simple_test("Ip_D_Vp");
    STRUCT_IF_C Ip_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_D_Vp)");
    check_field_offset(lv, v1, 0, "Ip_D_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_D_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ip_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_D_Vp, Ip_D_Vp)
//============================================================================


struct  Ip_F  {
  int *v1;
  float v2;
};
//SIG(1 Ip_F) C1{ Fp Fi}



static void Test_Ip_F()
{
  {
    init_simple_test("Ip_F");
    STRUCT_IF_C Ip_F lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F)");
    check_field_offset(lv, v1, 0, "Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F, Ip_F)
//============================================================================


struct  Ip_F_BFu15i  {
  int *v1;
  float v2;
  unsigned int v3:15;
};
//SIG(1 Ip_F_BFu15i) C1{ Fp Fi Fi:15}



static void Test_Ip_F_BFu15i()
{
  {
    init_simple_test("Ip_F_BFu15i");
    static STRUCT_IF_C Ip_F_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_F_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu15i, Ip_F_BFu15i)
//============================================================================


struct  Ip_F_BFu15ll  {
  int *v1;
  float v2;
  __tsu64 v3:15;
};
//SIG(1 Ip_F_BFu15ll) C1{ Fp Fi FL:15}



static void Test_Ip_F_BFu15ll()
{
  {
    init_simple_test("Ip_F_BFu15ll");
    static STRUCT_IF_C Ip_F_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_F_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu15ll, Ip_F_BFu15ll)
//============================================================================


struct  Ip_F_BFu15s  {
  int *v1;
  float v2;
  unsigned short v3:15;
};
//SIG(1 Ip_F_BFu15s) C1{ Fp Fi Fs:15}



static void Test_Ip_F_BFu15s()
{
  {
    init_simple_test("Ip_F_BFu15s");
    static STRUCT_IF_C Ip_F_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_F_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu15s, Ip_F_BFu15s)
//============================================================================


struct  Ip_F_BFu16i  {
  int *v1;
  float v2;
  unsigned int v3:16;
};
//SIG(1 Ip_F_BFu16i) C1{ Fp Fi Fi:16}



static void Test_Ip_F_BFu16i()
{
  {
    init_simple_test("Ip_F_BFu16i");
    static STRUCT_IF_C Ip_F_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_F_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu16i, Ip_F_BFu16i)
//============================================================================


struct  Ip_F_BFu16ll  {
  int *v1;
  float v2;
  __tsu64 v3:16;
};
//SIG(1 Ip_F_BFu16ll) C1{ Fp Fi FL:16}



static void Test_Ip_F_BFu16ll()
{
  {
    init_simple_test("Ip_F_BFu16ll");
    static STRUCT_IF_C Ip_F_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_F_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu16ll, Ip_F_BFu16ll)
//============================================================================


struct  Ip_F_BFu16s  {
  int *v1;
  float v2;
  unsigned short v3:16;
};
//SIG(1 Ip_F_BFu16s) C1{ Fp Fi Fs:16}



static void Test_Ip_F_BFu16s()
{
  {
    init_simple_test("Ip_F_BFu16s");
    static STRUCT_IF_C Ip_F_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_F_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu16s, Ip_F_BFu16s)
//============================================================================


struct  Ip_F_BFu17i  {
  int *v1;
  float v2;
  unsigned int v3:17;
};
//SIG(1 Ip_F_BFu17i) C1{ Fp Fi Fi:17}



static void Test_Ip_F_BFu17i()
{
  {
    init_simple_test("Ip_F_BFu17i");
    static STRUCT_IF_C Ip_F_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_F_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu17i, Ip_F_BFu17i)
//============================================================================


struct  Ip_F_BFu17ll  {
  int *v1;
  float v2;
  __tsu64 v3:17;
};
//SIG(1 Ip_F_BFu17ll) C1{ Fp Fi FL:17}



static void Test_Ip_F_BFu17ll()
{
  {
    init_simple_test("Ip_F_BFu17ll");
    static STRUCT_IF_C Ip_F_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_F_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu17ll, Ip_F_BFu17ll)
//============================================================================


struct  Ip_F_BFu1c  {
  int *v1;
  float v2;
  unsigned char v3:1;
};
//SIG(1 Ip_F_BFu1c) C1{ Fp Fi Fc:1}



static void Test_Ip_F_BFu1c()
{
  {
    init_simple_test("Ip_F_BFu1c");
    static STRUCT_IF_C Ip_F_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu1c, Ip_F_BFu1c)
//============================================================================


struct  Ip_F_BFu1i  {
  int *v1;
  float v2;
  unsigned int v3:1;
};
//SIG(1 Ip_F_BFu1i) C1{ Fp Fi Fi:1}



static void Test_Ip_F_BFu1i()
{
  {
    init_simple_test("Ip_F_BFu1i");
    static STRUCT_IF_C Ip_F_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu1i, Ip_F_BFu1i)
//============================================================================


struct  Ip_F_BFu1ll  {
  int *v1;
  float v2;
  __tsu64 v3:1;
};
//SIG(1 Ip_F_BFu1ll) C1{ Fp Fi FL:1}



static void Test_Ip_F_BFu1ll()
{
  {
    init_simple_test("Ip_F_BFu1ll");
    static STRUCT_IF_C Ip_F_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu1ll, Ip_F_BFu1ll)
//============================================================================


struct  Ip_F_BFu1s  {
  int *v1;
  float v2;
  unsigned short v3:1;
};
//SIG(1 Ip_F_BFu1s) C1{ Fp Fi Fs:1}



static void Test_Ip_F_BFu1s()
{
  {
    init_simple_test("Ip_F_BFu1s");
    static STRUCT_IF_C Ip_F_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu1s, Ip_F_BFu1s)
//============================================================================


struct  Ip_F_BFu31i  {
  int *v1;
  float v2;
  unsigned int v3:31;
};
//SIG(1 Ip_F_BFu31i) C1{ Fp Fi Fi:31}



static void Test_Ip_F_BFu31i()
{
  {
    init_simple_test("Ip_F_BFu31i");
    static STRUCT_IF_C Ip_F_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_F_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu31i, Ip_F_BFu31i)
//============================================================================


struct  Ip_F_BFu31ll  {
  int *v1;
  float v2;
  __tsu64 v3:31;
};
//SIG(1 Ip_F_BFu31ll) C1{ Fp Fi FL:31}



static void Test_Ip_F_BFu31ll()
{
  {
    init_simple_test("Ip_F_BFu31ll");
    static STRUCT_IF_C Ip_F_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_F_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu31ll, Ip_F_BFu31ll)
//============================================================================


struct  Ip_F_BFu32i  {
  int *v1;
  float v2;
  unsigned int v3:32;
};
//SIG(1 Ip_F_BFu32i) C1{ Fp Fi Fi:32}



static void Test_Ip_F_BFu32i()
{
  {
    init_simple_test("Ip_F_BFu32i");
    static STRUCT_IF_C Ip_F_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_F_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu32i, Ip_F_BFu32i)
//============================================================================


struct  Ip_F_BFu32ll  {
  int *v1;
  float v2;
  __tsu64 v3:32;
};
//SIG(1 Ip_F_BFu32ll) C1{ Fp Fi FL:32}



static void Test_Ip_F_BFu32ll()
{
  {
    init_simple_test("Ip_F_BFu32ll");
    static STRUCT_IF_C Ip_F_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_F_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu32ll, Ip_F_BFu32ll)
//============================================================================


struct  Ip_F_BFu33  {
  int *v1;
  float v2;
  __tsu64 v3:33;
};
//SIG(1 Ip_F_BFu33) C1{ Fp Fi FL:33}



static void Test_Ip_F_BFu33()
{
  {
    init_simple_test("Ip_F_BFu33");
    static STRUCT_IF_C Ip_F_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "Ip_F_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "Ip_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu33, Ip_F_BFu33)
//============================================================================


struct  Ip_F_BFu7c  {
  int *v1;
  float v2;
  unsigned char v3:7;
};
//SIG(1 Ip_F_BFu7c) C1{ Fp Fi Fc:7}



static void Test_Ip_F_BFu7c()
{
  {
    init_simple_test("Ip_F_BFu7c");
    static STRUCT_IF_C Ip_F_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_F_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu7c, Ip_F_BFu7c)
//============================================================================


struct  Ip_F_BFu7i  {
  int *v1;
  float v2;
  unsigned int v3:7;
};
//SIG(1 Ip_F_BFu7i) C1{ Fp Fi Fi:7}



static void Test_Ip_F_BFu7i()
{
  {
    init_simple_test("Ip_F_BFu7i");
    static STRUCT_IF_C Ip_F_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_F_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu7i, Ip_F_BFu7i)
//============================================================================


struct  Ip_F_BFu7ll  {
  int *v1;
  float v2;
  __tsu64 v3:7;
};
//SIG(1 Ip_F_BFu7ll) C1{ Fp Fi FL:7}



static void Test_Ip_F_BFu7ll()
{
  {
    init_simple_test("Ip_F_BFu7ll");
    static STRUCT_IF_C Ip_F_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_F_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu7ll, Ip_F_BFu7ll)
//============================================================================


struct  Ip_F_BFu7s  {
  int *v1;
  float v2;
  unsigned short v3:7;
};
//SIG(1 Ip_F_BFu7s) C1{ Fp Fi Fs:7}



static void Test_Ip_F_BFu7s()
{
  {
    init_simple_test("Ip_F_BFu7s");
    static STRUCT_IF_C Ip_F_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_F_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu7s, Ip_F_BFu7s)
//============================================================================


struct  Ip_F_BFu8c  {
  int *v1;
  float v2;
  unsigned char v3:8;
};
//SIG(1 Ip_F_BFu8c) C1{ Fp Fi Fc:8}



static void Test_Ip_F_BFu8c()
{
  {
    init_simple_test("Ip_F_BFu8c");
    static STRUCT_IF_C Ip_F_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_F_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu8c, Ip_F_BFu8c)
//============================================================================


struct  Ip_F_BFu8i  {
  int *v1;
  float v2;
  unsigned int v3:8;
};
//SIG(1 Ip_F_BFu8i) C1{ Fp Fi Fi:8}



static void Test_Ip_F_BFu8i()
{
  {
    init_simple_test("Ip_F_BFu8i");
    static STRUCT_IF_C Ip_F_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_F_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu8i, Ip_F_BFu8i)
//============================================================================


struct  Ip_F_BFu8ll  {
  int *v1;
  float v2;
  __tsu64 v3:8;
};
//SIG(1 Ip_F_BFu8ll) C1{ Fp Fi FL:8}



static void Test_Ip_F_BFu8ll()
{
  {
    init_simple_test("Ip_F_BFu8ll");
    static STRUCT_IF_C Ip_F_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_F_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu8ll, Ip_F_BFu8ll)
//============================================================================


struct  Ip_F_BFu8s  {
  int *v1;
  float v2;
  unsigned short v3:8;
};
//SIG(1 Ip_F_BFu8s) C1{ Fp Fi Fs:8}



static void Test_Ip_F_BFu8s()
{
  {
    init_simple_test("Ip_F_BFu8s");
    static STRUCT_IF_C Ip_F_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_F_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu8s, Ip_F_BFu8s)
//============================================================================


struct  Ip_F_BFu9i  {
  int *v1;
  float v2;
  unsigned int v3:9;
};
//SIG(1 Ip_F_BFu9i) C1{ Fp Fi Fi:9}



static void Test_Ip_F_BFu9i()
{
  {
    init_simple_test("Ip_F_BFu9i");
    static STRUCT_IF_C Ip_F_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_F_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu9i, Ip_F_BFu9i)
//============================================================================


struct  Ip_F_BFu9ll  {
  int *v1;
  float v2;
  __tsu64 v3:9;
};
//SIG(1 Ip_F_BFu9ll) C1{ Fp Fi FL:9}



static void Test_Ip_F_BFu9ll()
{
  {
    init_simple_test("Ip_F_BFu9ll");
    static STRUCT_IF_C Ip_F_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_F_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu9ll, Ip_F_BFu9ll)
//============================================================================


struct  Ip_F_BFu9s  {
  int *v1;
  float v2;
  unsigned short v3:9;
};
//SIG(1 Ip_F_BFu9s) C1{ Fp Fi Fs:9}



static void Test_Ip_F_BFu9s()
{
  {
    init_simple_test("Ip_F_BFu9s");
    static STRUCT_IF_C Ip_F_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_F_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_F_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_BFu9s, Ip_F_BFu9s)
//============================================================================


struct  Ip_F_C  {
  int *v1;
  float v2;
  char v3;
};
//SIG(1 Ip_F_C) C1{ Fp Fi Fc}



static void Test_Ip_F_C()
{
  {
    init_simple_test("Ip_F_C");
    STRUCT_IF_C Ip_F_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_C)");
    check_field_offset(lv, v1, 0, "Ip_F_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_C.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_C, Ip_F_C)
//============================================================================


struct  Ip_F_D  {
  int *v1;
  float v2;
  double v3;
};
//SIG(1 Ip_F_D) C1{ Fp Fi FL}



static void Test_Ip_F_D()
{
  {
    init_simple_test("Ip_F_D");
    STRUCT_IF_C Ip_F_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_D)");
    check_field_offset(lv, v1, 0, "Ip_F_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_D, Ip_F_D)
//============================================================================


struct  Ip_F_F  {
  int *v1;
  float v2;
  float v3;
};
//SIG(1 Ip_F_F) C1{ Fp Fi[2]}



static void Test_Ip_F_F()
{
  {
    init_simple_test("Ip_F_F");
    STRUCT_IF_C Ip_F_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_F)");
    check_field_offset(lv, v1, 0, "Ip_F_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_F.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_F, Ip_F_F)
//============================================================================


struct  Ip_F_I  {
  int *v1;
  float v2;
  int v3;
};
//SIG(1 Ip_F_I) C1{ Fp Fi[2]}



static void Test_Ip_F_I()
{
  {
    init_simple_test("Ip_F_I");
    STRUCT_IF_C Ip_F_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_I)");
    check_field_offset(lv, v1, 0, "Ip_F_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_I.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_I, Ip_F_I)
//============================================================================


struct  Ip_F_Ip  {
  int *v1;
  float v2;
  int *v3;
};
//SIG(1 Ip_F_Ip) C1{ Fp Fi Fp}



static void Test_Ip_F_Ip()
{
  {
    init_simple_test("Ip_F_Ip");
    STRUCT_IF_C Ip_F_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_Ip)");
    check_field_offset(lv, v1, 0, "Ip_F_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_Ip, Ip_F_Ip)
//============================================================================


struct  Ip_F_L  {
  int *v1;
  float v2;
  __tsi64 v3;
};
//SIG(1 Ip_F_L) C1{ Fp Fi FL}



static void Test_Ip_F_L()
{
  {
    init_simple_test("Ip_F_L");
    STRUCT_IF_C Ip_F_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_L)");
    check_field_offset(lv, v1, 0, "Ip_F_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_L, Ip_F_L)
//============================================================================


struct  Ip_F_S  {
  int *v1;
  float v2;
  short v3;
};
//SIG(1 Ip_F_S) C1{ Fp Fi Fs}



static void Test_Ip_F_S()
{
  {
    init_simple_test("Ip_F_S");
    STRUCT_IF_C Ip_F_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_S)");
    check_field_offset(lv, v1, 0, "Ip_F_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_S.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_S, Ip_F_S)
//============================================================================


struct  Ip_F_Uc  {
  int *v1;
  float v2;
  unsigned char v3;
};
//SIG(1 Ip_F_Uc) C1{ Fp Fi Fc}



static void Test_Ip_F_Uc()
{
  {
    init_simple_test("Ip_F_Uc");
    STRUCT_IF_C Ip_F_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_Uc)");
    check_field_offset(lv, v1, 0, "Ip_F_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_Uc, Ip_F_Uc)
//============================================================================


struct  Ip_F_Ui  {
  int *v1;
  float v2;
  unsigned int v3;
};
//SIG(1 Ip_F_Ui) C1{ Fp Fi[2]}



static void Test_Ip_F_Ui()
{
  {
    init_simple_test("Ip_F_Ui");
    STRUCT_IF_C Ip_F_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_Ui)");
    check_field_offset(lv, v1, 0, "Ip_F_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_Ui, Ip_F_Ui)
//============================================================================


struct  Ip_F_Ul  {
  int *v1;
  float v2;
  __tsu64 v3;
};
//SIG(1 Ip_F_Ul) C1{ Fp Fi FL}



static void Test_Ip_F_Ul()
{
  {
    init_simple_test("Ip_F_Ul");
    STRUCT_IF_C Ip_F_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_Ul)");
    check_field_offset(lv, v1, 0, "Ip_F_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_Ul, Ip_F_Ul)
//============================================================================


struct  Ip_F_Us  {
  int *v1;
  float v2;
  unsigned short v3;
};
//SIG(1 Ip_F_Us) C1{ Fp Fi Fs}



static void Test_Ip_F_Us()
{
  {
    init_simple_test("Ip_F_Us");
    STRUCT_IF_C Ip_F_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_F_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_Us)");
    check_field_offset(lv, v1, 0, "Ip_F_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_Us.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_Us, Ip_F_Us)
//============================================================================


struct  Ip_F_Vp  {
  int *v1;
  float v2;
  void *v3;
};
//SIG(1 Ip_F_Vp) C1{ Fp Fi Fp}



static void Test_Ip_F_Vp()
{
  {
    init_simple_test("Ip_F_Vp");
    STRUCT_IF_C Ip_F_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_F_Vp)");
    check_field_offset(lv, v1, 0, "Ip_F_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_F_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_F_Vp, Ip_F_Vp)
//============================================================================


struct  Ip_I  {
  int *v1;
  int v2;
};
//SIG(1 Ip_I) C1{ Fp Fi}



static void Test_Ip_I()
{
  {
    init_simple_test("Ip_I");
    STRUCT_IF_C Ip_I lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I)");
    check_field_offset(lv, v1, 0, "Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I, Ip_I)
//============================================================================


struct  Ip_I_BFu15i  {
  int *v1;
  int v2;
  unsigned int v3:15;
};
//SIG(1 Ip_I_BFu15i) C1{ Fp Fi Fi:15}



static void Test_Ip_I_BFu15i()
{
  {
    init_simple_test("Ip_I_BFu15i");
    static STRUCT_IF_C Ip_I_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_I_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu15i, Ip_I_BFu15i)
//============================================================================


struct  Ip_I_BFu15ll  {
  int *v1;
  int v2;
  __tsu64 v3:15;
};
//SIG(1 Ip_I_BFu15ll) C1{ Fp Fi FL:15}



static void Test_Ip_I_BFu15ll()
{
  {
    init_simple_test("Ip_I_BFu15ll");
    static STRUCT_IF_C Ip_I_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_I_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu15ll, Ip_I_BFu15ll)
//============================================================================


struct  Ip_I_BFu15s  {
  int *v1;
  int v2;
  unsigned short v3:15;
};
//SIG(1 Ip_I_BFu15s) C1{ Fp Fi Fs:15}



static void Test_Ip_I_BFu15s()
{
  {
    init_simple_test("Ip_I_BFu15s");
    static STRUCT_IF_C Ip_I_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu15s)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ip_I_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ip_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu15s, Ip_I_BFu15s)
//============================================================================


struct  Ip_I_BFu16i  {
  int *v1;
  int v2;
  unsigned int v3:16;
};
//SIG(1 Ip_I_BFu16i) C1{ Fp Fi Fi:16}



static void Test_Ip_I_BFu16i()
{
  {
    init_simple_test("Ip_I_BFu16i");
    static STRUCT_IF_C Ip_I_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu16i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_I_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu16i, Ip_I_BFu16i)
//============================================================================


struct  Ip_I_BFu16ll  {
  int *v1;
  int v2;
  __tsu64 v3:16;
};
//SIG(1 Ip_I_BFu16ll) C1{ Fp Fi FL:16}



static void Test_Ip_I_BFu16ll()
{
  {
    init_simple_test("Ip_I_BFu16ll");
    static STRUCT_IF_C Ip_I_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_I_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu16ll, Ip_I_BFu16ll)
//============================================================================


struct  Ip_I_BFu16s  {
  int *v1;
  int v2;
  unsigned short v3:16;
};
//SIG(1 Ip_I_BFu16s) C1{ Fp Fi Fs:16}



static void Test_Ip_I_BFu16s()
{
  {
    init_simple_test("Ip_I_BFu16s");
    static STRUCT_IF_C Ip_I_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu16s)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ip_I_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ip_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu16s, Ip_I_BFu16s)
//============================================================================


struct  Ip_I_BFu17i  {
  int *v1;
  int v2;
  unsigned int v3:17;
};
//SIG(1 Ip_I_BFu17i) C1{ Fp Fi Fi:17}



static void Test_Ip_I_BFu17i()
{
  {
    init_simple_test("Ip_I_BFu17i");
    static STRUCT_IF_C Ip_I_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu17i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_I_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu17i, Ip_I_BFu17i)
//============================================================================


struct  Ip_I_BFu17ll  {
  int *v1;
  int v2;
  __tsu64 v3:17;
};
//SIG(1 Ip_I_BFu17ll) C1{ Fp Fi FL:17}



static void Test_Ip_I_BFu17ll()
{
  {
    init_simple_test("Ip_I_BFu17ll");
    static STRUCT_IF_C Ip_I_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ip_I_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ip_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu17ll, Ip_I_BFu17ll)
//============================================================================


struct  Ip_I_BFu1c  {
  int *v1;
  int v2;
  unsigned char v3:1;
};
//SIG(1 Ip_I_BFu1c) C1{ Fp Fi Fc:1}



static void Test_Ip_I_BFu1c()
{
  {
    init_simple_test("Ip_I_BFu1c");
    static STRUCT_IF_C Ip_I_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu1c)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu1c, Ip_I_BFu1c)
//============================================================================


struct  Ip_I_BFu1i  {
  int *v1;
  int v2;
  unsigned int v3:1;
};
//SIG(1 Ip_I_BFu1i) C1{ Fp Fi Fi:1}



static void Test_Ip_I_BFu1i()
{
  {
    init_simple_test("Ip_I_BFu1i");
    static STRUCT_IF_C Ip_I_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu1i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu1i, Ip_I_BFu1i)
//============================================================================


struct  Ip_I_BFu1ll  {
  int *v1;
  int v2;
  __tsu64 v3:1;
};
//SIG(1 Ip_I_BFu1ll) C1{ Fp Fi FL:1}



static void Test_Ip_I_BFu1ll()
{
  {
    init_simple_test("Ip_I_BFu1ll");
    static STRUCT_IF_C Ip_I_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu1ll, Ip_I_BFu1ll)
//============================================================================


struct  Ip_I_BFu1s  {
  int *v1;
  int v2;
  unsigned short v3:1;
};
//SIG(1 Ip_I_BFu1s) C1{ Fp Fi Fs:1}



static void Test_Ip_I_BFu1s()
{
  {
    init_simple_test("Ip_I_BFu1s");
    static STRUCT_IF_C Ip_I_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu1s)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ip_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu1s, Ip_I_BFu1s)
//============================================================================


struct  Ip_I_BFu31i  {
  int *v1;
  int v2;
  unsigned int v3:31;
};
//SIG(1 Ip_I_BFu31i) C1{ Fp Fi Fi:31}



static void Test_Ip_I_BFu31i()
{
  {
    init_simple_test("Ip_I_BFu31i");
    static STRUCT_IF_C Ip_I_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu31i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_I_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu31i, Ip_I_BFu31i)
//============================================================================


struct  Ip_I_BFu31ll  {
  int *v1;
  int v2;
  __tsu64 v3:31;
};
//SIG(1 Ip_I_BFu31ll) C1{ Fp Fi FL:31}



static void Test_Ip_I_BFu31ll()
{
  {
    init_simple_test("Ip_I_BFu31ll");
    static STRUCT_IF_C Ip_I_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ip_I_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ip_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu31ll, Ip_I_BFu31ll)
//============================================================================


struct  Ip_I_BFu32i  {
  int *v1;
  int v2;
  unsigned int v3:32;
};
//SIG(1 Ip_I_BFu32i) C1{ Fp Fi Fi:32}



static void Test_Ip_I_BFu32i()
{
  {
    init_simple_test("Ip_I_BFu32i");
    static STRUCT_IF_C Ip_I_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu32i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_I_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu32i, Ip_I_BFu32i)
//============================================================================


struct  Ip_I_BFu32ll  {
  int *v1;
  int v2;
  __tsu64 v3:32;
};
//SIG(1 Ip_I_BFu32ll) C1{ Fp Fi FL:32}



static void Test_Ip_I_BFu32ll()
{
  {
    init_simple_test("Ip_I_BFu32ll");
    static STRUCT_IF_C Ip_I_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ip_I_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ip_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu32ll, Ip_I_BFu32ll)
//============================================================================


struct  Ip_I_BFu33  {
  int *v1;
  int v2;
  __tsu64 v3:33;
};
//SIG(1 Ip_I_BFu33) C1{ Fp Fi FL:33}



static void Test_Ip_I_BFu33()
{
  {
    init_simple_test("Ip_I_BFu33");
    static STRUCT_IF_C Ip_I_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu33)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "Ip_I_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "Ip_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu33, Ip_I_BFu33)
//============================================================================


struct  Ip_I_BFu7c  {
  int *v1;
  int v2;
  unsigned char v3:7;
};
//SIG(1 Ip_I_BFu7c) C1{ Fp Fi Fc:7}



static void Test_Ip_I_BFu7c()
{
  {
    init_simple_test("Ip_I_BFu7c");
    static STRUCT_IF_C Ip_I_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu7c)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_I_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu7c, Ip_I_BFu7c)
//============================================================================


struct  Ip_I_BFu7i  {
  int *v1;
  int v2;
  unsigned int v3:7;
};
//SIG(1 Ip_I_BFu7i) C1{ Fp Fi Fi:7}



static void Test_Ip_I_BFu7i()
{
  {
    init_simple_test("Ip_I_BFu7i");
    static STRUCT_IF_C Ip_I_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu7i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_I_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu7i, Ip_I_BFu7i)
//============================================================================


struct  Ip_I_BFu7ll  {
  int *v1;
  int v2;
  __tsu64 v3:7;
};
//SIG(1 Ip_I_BFu7ll) C1{ Fp Fi FL:7}



static void Test_Ip_I_BFu7ll()
{
  {
    init_simple_test("Ip_I_BFu7ll");
    static STRUCT_IF_C Ip_I_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_I_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu7ll, Ip_I_BFu7ll)
//============================================================================


struct  Ip_I_BFu7s  {
  int *v1;
  int v2;
  unsigned short v3:7;
};
//SIG(1 Ip_I_BFu7s) C1{ Fp Fi Fs:7}



static void Test_Ip_I_BFu7s()
{
  {
    init_simple_test("Ip_I_BFu7s");
    static STRUCT_IF_C Ip_I_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu7s)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ip_I_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ip_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu7s, Ip_I_BFu7s)
//============================================================================


struct  Ip_I_BFu8c  {
  int *v1;
  int v2;
  unsigned char v3:8;
};
//SIG(1 Ip_I_BFu8c) C1{ Fp Fi Fc:8}



static void Test_Ip_I_BFu8c()
{
  {
    init_simple_test("Ip_I_BFu8c");
    static STRUCT_IF_C Ip_I_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu8c)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_I_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu8c, Ip_I_BFu8c)
//============================================================================


struct  Ip_I_BFu8i  {
  int *v1;
  int v2;
  unsigned int v3:8;
};
//SIG(1 Ip_I_BFu8i) C1{ Fp Fi Fi:8}



static void Test_Ip_I_BFu8i()
{
  {
    init_simple_test("Ip_I_BFu8i");
    static STRUCT_IF_C Ip_I_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu8i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_I_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu8i, Ip_I_BFu8i)
//============================================================================


struct  Ip_I_BFu8ll  {
  int *v1;
  int v2;
  __tsu64 v3:8;
};
//SIG(1 Ip_I_BFu8ll) C1{ Fp Fi FL:8}



static void Test_Ip_I_BFu8ll()
{
  {
    init_simple_test("Ip_I_BFu8ll");
    static STRUCT_IF_C Ip_I_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_I_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu8ll, Ip_I_BFu8ll)
//============================================================================


struct  Ip_I_BFu8s  {
  int *v1;
  int v2;
  unsigned short v3:8;
};
//SIG(1 Ip_I_BFu8s) C1{ Fp Fi Fs:8}



static void Test_Ip_I_BFu8s()
{
  {
    init_simple_test("Ip_I_BFu8s");
    static STRUCT_IF_C Ip_I_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu8s)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ip_I_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ip_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu8s, Ip_I_BFu8s)
//============================================================================


struct  Ip_I_BFu9i  {
  int *v1;
  int v2;
  unsigned int v3:9;
};
//SIG(1 Ip_I_BFu9i) C1{ Fp Fi Fi:9}



static void Test_Ip_I_BFu9i()
{
  {
    init_simple_test("Ip_I_BFu9i");
    static STRUCT_IF_C Ip_I_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu9i)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_I_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu9i, Ip_I_BFu9i)
//============================================================================


struct  Ip_I_BFu9ll  {
  int *v1;
  int v2;
  __tsu64 v3:9;
};
//SIG(1 Ip_I_BFu9ll) C1{ Fp Fi FL:9}



static void Test_Ip_I_BFu9ll()
{
  {
    init_simple_test("Ip_I_BFu9ll");
    static STRUCT_IF_C Ip_I_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_I_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu9ll, Ip_I_BFu9ll)
//============================================================================


struct  Ip_I_BFu9s  {
  int *v1;
  int v2;
  unsigned short v3:9;
};
//SIG(1 Ip_I_BFu9s) C1{ Fp Fi Fs:9}



static void Test_Ip_I_BFu9s()
{
  {
    init_simple_test("Ip_I_BFu9s");
    static STRUCT_IF_C Ip_I_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_BFu9s)");
    check_field_offset(lv, v1, 0, "Ip_I_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ip_I_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ip_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_BFu9s, Ip_I_BFu9s)
//============================================================================


struct  Ip_I_C  {
  int *v1;
  int v2;
  char v3;
};
//SIG(1 Ip_I_C) C1{ Fp Fi Fc}



static void Test_Ip_I_C()
{
  {
    init_simple_test("Ip_I_C");
    STRUCT_IF_C Ip_I_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_C)");
    check_field_offset(lv, v1, 0, "Ip_I_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_C.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_C, Ip_I_C)
//============================================================================


struct  Ip_I_D  {
  int *v1;
  int v2;
  double v3;
};
//SIG(1 Ip_I_D) C1{ Fp Fi FL}



static void Test_Ip_I_D()
{
  {
    init_simple_test("Ip_I_D");
    STRUCT_IF_C Ip_I_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_D)");
    check_field_offset(lv, v1, 0, "Ip_I_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_D, Ip_I_D)
//============================================================================


struct  Ip_I_F  {
  int *v1;
  int v2;
  float v3;
};
//SIG(1 Ip_I_F) C1{ Fp Fi[2]}



static void Test_Ip_I_F()
{
  {
    init_simple_test("Ip_I_F");
    STRUCT_IF_C Ip_I_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_F)");
    check_field_offset(lv, v1, 0, "Ip_I_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_F.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_F, Ip_I_F)
//============================================================================


struct  Ip_I_I  {
  int *v1;
  int v2;
  int v3;
};
//SIG(1 Ip_I_I) C1{ Fp Fi[2]}



static void Test_Ip_I_I()
{
  {
    init_simple_test("Ip_I_I");
    STRUCT_IF_C Ip_I_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_I)");
    check_field_offset(lv, v1, 0, "Ip_I_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_I.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_I, Ip_I_I)
//============================================================================


struct  Ip_I_Ip  {
  int *v1;
  int v2;
  int *v3;
};
//SIG(1 Ip_I_Ip) C1{ Fp Fi Fp}



static void Test_Ip_I_Ip()
{
  {
    init_simple_test("Ip_I_Ip");
    STRUCT_IF_C Ip_I_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_Ip)");
    check_field_offset(lv, v1, 0, "Ip_I_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_Ip, Ip_I_Ip)
//============================================================================


struct  Ip_I_L  {
  int *v1;
  int v2;
  __tsi64 v3;
};
//SIG(1 Ip_I_L) C1{ Fp Fi FL}



static void Test_Ip_I_L()
{
  {
    init_simple_test("Ip_I_L");
    STRUCT_IF_C Ip_I_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_L)");
    check_field_offset(lv, v1, 0, "Ip_I_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_L, Ip_I_L)
//============================================================================


struct  Ip_I_S  {
  int *v1;
  int v2;
  short v3;
};
//SIG(1 Ip_I_S) C1{ Fp Fi Fs}



static void Test_Ip_I_S()
{
  {
    init_simple_test("Ip_I_S");
    STRUCT_IF_C Ip_I_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_S)");
    check_field_offset(lv, v1, 0, "Ip_I_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_S.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_S, Ip_I_S)
//============================================================================


struct  Ip_I_Uc  {
  int *v1;
  int v2;
  unsigned char v3;
};
//SIG(1 Ip_I_Uc) C1{ Fp Fi Fc}



static void Test_Ip_I_Uc()
{
  {
    init_simple_test("Ip_I_Uc");
    STRUCT_IF_C Ip_I_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_Uc)");
    check_field_offset(lv, v1, 0, "Ip_I_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_Uc, Ip_I_Uc)
//============================================================================


struct  Ip_I_Ui  {
  int *v1;
  int v2;
  unsigned int v3;
};
//SIG(1 Ip_I_Ui) C1{ Fp Fi[2]}



static void Test_Ip_I_Ui()
{
  {
    init_simple_test("Ip_I_Ui");
    STRUCT_IF_C Ip_I_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_Ui)");
    check_field_offset(lv, v1, 0, "Ip_I_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_Ui, Ip_I_Ui)
//============================================================================


struct  Ip_I_Ul  {
  int *v1;
  int v2;
  __tsu64 v3;
};
//SIG(1 Ip_I_Ul) C1{ Fp Fi FL}



static void Test_Ip_I_Ul()
{
  {
    init_simple_test("Ip_I_Ul");
    STRUCT_IF_C Ip_I_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ip_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_Ul)");
    check_field_offset(lv, v1, 0, "Ip_I_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_Ul, Ip_I_Ul)
//============================================================================


struct  Ip_I_Us  {
  int *v1;
  int v2;
  unsigned short v3;
};
//SIG(1 Ip_I_Us) C1{ Fp Fi Fs}



static void Test_Ip_I_Us()
{
  {
    init_simple_test("Ip_I_Us");
    STRUCT_IF_C Ip_I_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ip_I_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_Us)");
    check_field_offset(lv, v1, 0, "Ip_I_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_Us.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ip_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_Us, Ip_I_Us)
//============================================================================


struct  Ip_I_Vp  {
  int *v1;
  int v2;
  void *v3;
};
//SIG(1 Ip_I_Vp) C1{ Fp Fi Fp}



static void Test_Ip_I_Vp()
{
  {
    init_simple_test("Ip_I_Vp");
    STRUCT_IF_C Ip_I_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_I_Vp)");
    check_field_offset(lv, v1, 0, "Ip_I_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_I_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "Ip_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_I_Vp, Ip_I_Vp)
//============================================================================


struct  Ip_Ip  {
  int *v1;
  int *v2;
};
//SIG(1 Ip_Ip) C1{ Fp[2]}



static void Test_Ip_Ip()
{
  {
    init_simple_test("Ip_Ip");
    STRUCT_IF_C Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_Ip)");
    check_field_offset(lv, v1, 0, "Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_Ip, Ip_Ip)
//============================================================================


struct  Ip_Ip_BFu15i  {
  int *v1;
  int *v2;
  unsigned int v3:15;
};
//SIG(1 Ip_Ip_BFu15i) C1{ Fp[2] Fi:15}



static void Test_Ip_Ip_BFu15i()
{
  {
    init_simple_test("Ip_Ip_BFu15i");
    static STRUCT_IF_C Ip_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(Ip_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ip_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "Ip_Ip_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ip_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "Ip_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "Ip_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ip_Ip_BFu15i, Ip_Ip_BFu15i)
//============================================