// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  F_BFu1i_L  {
  float v1;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 F_BFu1i_L) C1{ Fi Fi:1 FL}



static void Test_F_BFu1i_L()
{
  {
    init_simple_test("F_BFu1i_L");
    static STRUCT_IF_C F_BFu1i_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1i_L)");
    check_field_offset(lv, v1, 0, "F_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_L");
    check_field_offset(lv, v3, 8, "F_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_L, F_BFu1i_L)
//============================================================================


struct  F_BFu1i_S  {
  float v1;
  unsigned int v2:1;
  short v3;
};
//SIG(1 F_BFu1i_S) C1{ Fi Fi:1 Fs}



static void Test_F_BFu1i_S()
{
  {
    init_simple_test("F_BFu1i_S");
    static STRUCT_IF_C F_BFu1i_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1i_S)");
    check_field_offset(lv, v1, 0, "F_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_S");
    check_field_offset(lv, v3, 6, "F_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_S, F_BFu1i_S)
//============================================================================


struct  F_BFu1i_Uc  {
  float v1;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 F_BFu1i_Uc) C1{ Fi Fi:1 Fc}



static void Test_F_BFu1i_Uc()
{
  {
    init_simple_test("F_BFu1i_Uc");
    static STRUCT_IF_C F_BFu1i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Uc");
    check_field_offset(lv, v3, 5, "F_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Uc, F_BFu1i_Uc)
//============================================================================


struct  F_BFu1i_Ui  {
  float v1;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 F_BFu1i_Ui) C1{ Fi Fi:1 Fi}



static void Test_F_BFu1i_Ui()
{
  {
    init_simple_test("F_BFu1i_Ui");
    static STRUCT_IF_C F_BFu1i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Ui");
    check_field_offset(lv, v3, 8, "F_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Ui, F_BFu1i_Ui)
//============================================================================


struct  F_BFu1i_Ul  {
  float v1;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 F_BFu1i_Ul) C1{ Fi Fi:1 FL}



static void Test_F_BFu1i_Ul()
{
  {
    init_simple_test("F_BFu1i_Ul");
    static STRUCT_IF_C F_BFu1i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Ul");
    check_field_offset(lv, v3, 8, "F_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Ul, F_BFu1i_Ul)
//============================================================================


struct  F_BFu1i_Us  {
  float v1;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 F_BFu1i_Us) C1{ Fi Fi:1 Fs}



static void Test_F_BFu1i_Us()
{
  {
    init_simple_test("F_BFu1i_Us");
    static STRUCT_IF_C F_BFu1i_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Us");
    check_field_offset(lv, v3, 6, "F_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Us, F_BFu1i_Us)
//============================================================================


struct  F_BFu1i_Vp  {
  float v1;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 F_BFu1i_Vp) C1{ Fi Fi:1 Fp}



static void Test_F_BFu1i_Vp()
{
  {
    init_simple_test("F_BFu1i_Vp");
    static STRUCT_IF_C F_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Vp");
    check_field_offset(lv, v3, 8, "F_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Vp, F_BFu1i_Vp)
//============================================================================


struct  F_BFu1ll  {
  float v1;
  __tsu64 v2:1;
};
//SIG(1 F_BFu1ll) C1{ Fi FL:1}



static void Test_F_BFu1ll()
{
  {
    init_simple_test("F_BFu1ll");
    static STRUCT_IF_C F_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll, F_BFu1ll)
//============================================================================


struct  F_BFu1ll_BFu15i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 F_BFu1ll_BFu15i) C1{ Fi FL:1 Fi:15}



static void Test_F_BFu1ll_BFu15i()
{
  {
    init_simple_test("F_BFu1ll_BFu15i");
    static STRUCT_IF_C F_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu15i, F_BFu1ll_BFu15i)
//============================================================================


struct  F_BFu1ll_BFu15ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 F_BFu1ll_BFu15ll) C1{ Fi FL:1 FL:15}



static void Test_F_BFu1ll_BFu15ll()
{
  {
    init_simple_test("F_BFu1ll_BFu15ll");
    static STRUCT_IF_C F_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu15ll, F_BFu1ll_BFu15ll)
//============================================================================


struct  F_BFu1ll_BFu15s  {
  float v1;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 F_BFu1ll_BFu15s) C1{ Fi FL:1 Fs:15}



static void Test_F_BFu1ll_BFu15s()
{
  {
    init_simple_test("F_BFu1ll_BFu15s");
    static STRUCT_IF_C F_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu15s, F_BFu1ll_BFu15s)
//============================================================================


struct  F_BFu1ll_BFu16i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 F_BFu1ll_BFu16i) C1{ Fi FL:1 Fi:16}



static void Test_F_BFu1ll_BFu16i()
{
  {
    init_simple_test("F_BFu1ll_BFu16i");
    static STRUCT_IF_C F_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu16i, F_BFu1ll_BFu16i)
//============================================================================


struct  F_BFu1ll_BFu16ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 F_BFu1ll_BFu16ll) C1{ Fi FL:1 FL:16}



static void Test_F_BFu1ll_BFu16ll()
{
  {
    init_simple_test("F_BFu1ll_BFu16ll");
    static STRUCT_IF_C F_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu16ll, F_BFu1ll_BFu16ll)
//============================================================================


struct  F_BFu1ll_BFu16s  {
  float v1;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 F_BFu1ll_BFu16s) C1{ Fi FL:1 Fs:16}



static void Test_F_BFu1ll_BFu16s()
{
  {
    init_simple_test("F_BFu1ll_BFu16s");
    static STRUCT_IF_C F_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu16s, F_BFu1ll_BFu16s)
//============================================================================


struct  F_BFu1ll_BFu17i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 F_BFu1ll_BFu17i) C1{ Fi FL:1 Fi:17}



static void Test_F_BFu1ll_BFu17i()
{
  {
    init_simple_test("F_BFu1ll_BFu17i");
    static STRUCT_IF_C F_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu17i, F_BFu1ll_BFu17i)
//============================================================================


struct  F_BFu1ll_BFu17ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 F_BFu1ll_BFu17ll) C1{ Fi FL:1 FL:17}



static void Test_F_BFu1ll_BFu17ll()
{
  {
    init_simple_test("F_BFu1ll_BFu17ll");
    static STRUCT_IF_C F_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu17ll, F_BFu1ll_BFu17ll)
//============================================================================


struct  F_BFu1ll_BFu1c  {
  float v1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 F_BFu1ll_BFu1c) C1{ Fi FL:1 Fc:1}



static void Test_F_BFu1ll_BFu1c()
{
  {
    init_simple_test("F_BFu1ll_BFu1c");
    static STRUCT_IF_C F_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu1c, F_BFu1ll_BFu1c)
//============================================================================


struct  F_BFu1ll_BFu1i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 F_BFu1ll_BFu1i) C1{ Fi FL:1 Fi:1}



static void Test_F_BFu1ll_BFu1i()
{
  {
    init_simple_test("F_BFu1ll_BFu1i");
    static STRUCT_IF_C F_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu1i, F_BFu1ll_BFu1i)
//============================================================================


struct  F_BFu1ll_BFu1ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 F_BFu1ll_BFu1ll) C1{ Fi FL:1 FL:1}



static void Test_F_BFu1ll_BFu1ll()
{
  {
    init_simple_test("F_BFu1ll_BFu1ll");
    static STRUCT_IF_C F_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu1ll, F_BFu1ll_BFu1ll)
//============================================================================


struct  F_BFu1ll_BFu1s  {
  float v1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 F_BFu1ll_BFu1s) C1{ Fi FL:1 Fs:1}



static void Test_F_BFu1ll_BFu1s()
{
  {
    init_simple_test("F_BFu1ll_BFu1s");
    static STRUCT_IF_C F_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu1s, F_BFu1ll_BFu1s)
//============================================================================


struct  F_BFu1ll_BFu31i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 F_BFu1ll_BFu31i) C1{ Fi FL:1 Fi:31}



static void Test_F_BFu1ll_BFu31i()
{
  {
    init_simple_test("F_BFu1ll_BFu31i");
    static STRUCT_IF_C F_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu31i, F_BFu1ll_BFu31i)
//============================================================================


struct  F_BFu1ll_BFu31ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 F_BFu1ll_BFu31ll) C1{ Fi FL:1 FL:31}



static void Test_F_BFu1ll_BFu31ll()
{
  {
    init_simple_test("F_BFu1ll_BFu31ll");
    static STRUCT_IF_C F_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu31ll, F_BFu1ll_BFu31ll)
//============================================================================


struct  F_BFu1ll_BFu32i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 F_BFu1ll_BFu32i) C1{ Fi FL:1 Fi:32}



static void Test_F_BFu1ll_BFu32i()
{
  {
    init_simple_test("F_BFu1ll_BFu32i");
    static STRUCT_IF_C F_BFu1ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu32i, F_BFu1ll_BFu32i)
//============================================================================


struct  F_BFu1ll_BFu32ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 F_BFu1ll_BFu32ll) C1{ Fi FL:1 FL:32}



static void Test_F_BFu1ll_BFu32ll()
{
  {
    init_simple_test("F_BFu1ll_BFu32ll");
    static STRUCT_IF_C F_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "F_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "F_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu32ll, F_BFu1ll_BFu32ll)
//============================================================================


struct  F_BFu1ll_BFu33  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 F_BFu1ll_BFu33) C1{ Fi FL:1 FL:33}



static void Test_F_BFu1ll_BFu33()
{
  {
    init_simple_test("F_BFu1ll_BFu33");
    static STRUCT_IF_C F_BFu1ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "F_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "F_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu33, F_BFu1ll_BFu33)
//============================================================================


struct  F_BFu1ll_BFu7c  {
  float v1;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 F_BFu1ll_BFu7c) C1{ Fi FL:1 Fc:7}



static void Test_F_BFu1ll_BFu7c()
{
  {
    init_simple_test("F_BFu1ll_BFu7c");
    static STRUCT_IF_C F_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu7c, F_BFu1ll_BFu7c)
//============================================================================


struct  F_BFu1ll_BFu7i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 F_BFu1ll_BFu7i) C1{ Fi FL:1 Fi:7}



static void Test_F_BFu1ll_BFu7i()
{
  {
    init_simple_test("F_BFu1ll_BFu7i");
    static STRUCT_IF_C F_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu7i, F_BFu1ll_BFu7i)
//============================================================================


struct  F_BFu1ll_BFu7ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 F_BFu1ll_BFu7ll) C1{ Fi FL:1 FL:7}



static void Test_F_BFu1ll_BFu7ll()
{
  {
    init_simple_test("F_BFu1ll_BFu7ll");
    static STRUCT_IF_C F_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu7ll, F_BFu1ll_BFu7ll)
//============================================================================


struct  F_BFu1ll_BFu7s  {
  float v1;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 F_BFu1ll_BFu7s) C1{ Fi FL:1 Fs:7}



static void Test_F_BFu1ll_BFu7s()
{
  {
    init_simple_test("F_BFu1ll_BFu7s");
    static STRUCT_IF_C F_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu7s, F_BFu1ll_BFu7s)
//============================================================================


struct  F_BFu1ll_BFu8c  {
  float v1;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 F_BFu1ll_BFu8c) C1{ Fi FL:1 Fc:8}



static void Test_F_BFu1ll_BFu8c()
{
  {
    init_simple_test("F_BFu1ll_BFu8c");
    static STRUCT_IF_C F_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu8c, F_BFu1ll_BFu8c)
//============================================================================


struct  F_BFu1ll_BFu8i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 F_BFu1ll_BFu8i) C1{ Fi FL:1 Fi:8}



static void Test_F_BFu1ll_BFu8i()
{
  {
    init_simple_test("F_BFu1ll_BFu8i");
    static STRUCT_IF_C F_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu8i, F_BFu1ll_BFu8i)
//============================================================================


struct  F_BFu1ll_BFu8ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 F_BFu1ll_BFu8ll) C1{ Fi FL:1 FL:8}



static void Test_F_BFu1ll_BFu8ll()
{
  {
    init_simple_test("F_BFu1ll_BFu8ll");
    static STRUCT_IF_C F_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu8ll, F_BFu1ll_BFu8ll)
//============================================================================


struct  F_BFu1ll_BFu8s  {
  float v1;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 F_BFu1ll_BFu8s) C1{ Fi FL:1 Fs:8}



static void Test_F_BFu1ll_BFu8s()
{
  {
    init_simple_test("F_BFu1ll_BFu8s");
    static STRUCT_IF_C F_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu8s, F_BFu1ll_BFu8s)
//============================================================================


struct  F_BFu1ll_BFu9i  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 F_BFu1ll_BFu9i) C1{ Fi FL:1 Fi:9}



static void Test_F_BFu1ll_BFu9i()
{
  {
    init_simple_test("F_BFu1ll_BFu9i");
    static STRUCT_IF_C F_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu9i, F_BFu1ll_BFu9i)
//============================================================================


struct  F_BFu1ll_BFu9ll  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 F_BFu1ll_BFu9ll) C1{ Fi FL:1 FL:9}



static void Test_F_BFu1ll_BFu9ll()
{
  {
    init_simple_test("F_BFu1ll_BFu9ll");
    static STRUCT_IF_C F_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu9ll, F_BFu1ll_BFu9ll)
//============================================================================


struct  F_BFu1ll_BFu9s  {
  float v1;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 F_BFu1ll_BFu9s) C1{ Fi FL:1 Fs:9}



static void Test_F_BFu1ll_BFu9s()
{
  {
    init_simple_test("F_BFu1ll_BFu9s");
    static STRUCT_IF_C F_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu9s, F_BFu1ll_BFu9s)
//============================================================================


struct  F_BFu1ll_C  {
  float v1;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 F_BFu1ll_C) C1{ Fi FL:1 Fc}



static void Test_F_BFu1ll_C()
{
  {
    init_simple_test("F_BFu1ll_C");
    static STRUCT_IF_C F_BFu1ll_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_C");
    check_field_offset(lv, v3, 5, "F_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_C, F_BFu1ll_C)
//============================================================================


struct  F_BFu1ll_D  {
  float v1;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 F_BFu1ll_D) C1{ Fi FL:1 FL}



static void Test_F_BFu1ll_D()
{
  {
    init_simple_test("F_BFu1ll_D");
    static STRUCT_IF_C F_BFu1ll_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_D");
    check_field_offset(lv, v3, 8, "F_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_D, F_BFu1ll_D)
//============================================================================


struct  F_BFu1ll_F  {
  float v1;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 F_BFu1ll_F) C1{ Fi FL:1 Fi}



static void Test_F_BFu1ll_F()
{
  {
    init_simple_test("F_BFu1ll_F");
    static STRUCT_IF_C F_BFu1ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_F");
    check_field_offset(lv, v3, 8, "F_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_F, F_BFu1ll_F)
//============================================================================


struct  F_BFu1ll_I  {
  float v1;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 F_BFu1ll_I) C1{ Fi FL:1 Fi}



static void Test_F_BFu1ll_I()
{
  {
    init_simple_test("F_BFu1ll_I");
    static STRUCT_IF_C F_BFu1ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_I");
    check_field_offset(lv, v3, 8, "F_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_I, F_BFu1ll_I)
//============================================================================


struct  F_BFu1ll_Ip  {
  float v1;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 F_BFu1ll_Ip) C1{ Fi FL:1 Fp}



static void Test_F_BFu1ll_Ip()
{
  {
    init_simple_test("F_BFu1ll_Ip");
    static STRUCT_IF_C F_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Ip");
    check_field_offset(lv, v3, 8, "F_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Ip, F_BFu1ll_Ip)
//============================================================================


struct  F_BFu1ll_L  {
  float v1;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 F_BFu1ll_L) C1{ Fi FL:1 FL}



static void Test_F_BFu1ll_L()
{
  {
    init_simple_test("F_BFu1ll_L");
    static STRUCT_IF_C F_BFu1ll_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_L");
    check_field_offset(lv, v3, 8, "F_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_L, F_BFu1ll_L)
//============================================================================


struct  F_BFu1ll_S  {
  float v1;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 F_BFu1ll_S) C1{ Fi FL:1 Fs}



static void Test_F_BFu1ll_S()
{
  {
    init_simple_test("F_BFu1ll_S");
    static STRUCT_IF_C F_BFu1ll_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_S");
    check_field_offset(lv, v3, 6, "F_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_S, F_BFu1ll_S)
//============================================================================


struct  F_BFu1ll_Uc  {
  float v1;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 F_BFu1ll_Uc) C1{ Fi FL:1 Fc}



static void Test_F_BFu1ll_Uc()
{
  {
    init_simple_test("F_BFu1ll_Uc");
    static STRUCT_IF_C F_BFu1ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Uc");
    check_field_offset(lv, v3, 5, "F_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Uc, F_BFu1ll_Uc)
//============================================================================


struct  F_BFu1ll_Ui  {
  float v1;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 F_BFu1ll_Ui) C1{ Fi FL:1 Fi}



static void Test_F_BFu1ll_Ui()
{
  {
    init_simple_test("F_BFu1ll_Ui");
    static STRUCT_IF_C F_BFu1ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Ui");
    check_field_offset(lv, v3, 8, "F_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Ui, F_BFu1ll_Ui)
//============================================================================


struct  F_BFu1ll_Ul  {
  float v1;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 F_BFu1ll_Ul) C1{ Fi FL:1 FL}



static void Test_F_BFu1ll_Ul()
{
  {
    init_simple_test("F_BFu1ll_Ul");
    static STRUCT_IF_C F_BFu1ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Ul");
    check_field_offset(lv, v3, 8, "F_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Ul, F_BFu1ll_Ul)
//============================================================================


struct  F_BFu1ll_Us  {
  float v1;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 F_BFu1ll_Us) C1{ Fi FL:1 Fs}



static void Test_F_BFu1ll_Us()
{
  {
    init_simple_test("F_BFu1ll_Us");
    static STRUCT_IF_C F_BFu1ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Us");
    check_field_offset(lv, v3, 6, "F_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Us, F_BFu1ll_Us)
//============================================================================


struct  F_BFu1ll_Vp  {
  float v1;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 F_BFu1ll_Vp) C1{ Fi FL:1 Fp}



static void Test_F_BFu1ll_Vp()
{
  {
    init_simple_test("F_BFu1ll_Vp");
    static STRUCT_IF_C F_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Vp");
    check_field_offset(lv, v3, 8, "F_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Vp, F_BFu1ll_Vp)
//============================================================================


struct  F_BFu1s  {
  float v1;
  unsigned short v2:1;
};
//SIG(1 F_BFu1s) C1{ Fi Fs:1}



static void Test_F_BFu1s()
{
  {
    init_simple_test("F_BFu1s");
    static STRUCT_IF_C F_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s, F_BFu1s)
//============================================================================


struct  F_BFu1s_BFu15i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 F_BFu1s_BFu15i) C1{ Fi Fs:1 Fi:15}



static void Test_F_BFu1s_BFu15i()
{
  {
    init_simple_test("F_BFu1s_BFu15i");
    static STRUCT_IF_C F_BFu1s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu15i, F_BFu1s_BFu15i)
//============================================================================


struct  F_BFu1s_BFu15ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 F_BFu1s_BFu15ll) C1{ Fi Fs:1 FL:15}



static void Test_F_BFu1s_BFu15ll()
{
  {
    init_simple_test("F_BFu1s_BFu15ll");
    static STRUCT_IF_C F_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu15ll, F_BFu1s_BFu15ll)
//============================================================================


struct  F_BFu1s_BFu15s  {
  float v1;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 F_BFu1s_BFu15s) C1{ Fi Fs:1 Fs:15}



static void Test_F_BFu1s_BFu15s()
{
  {
    init_simple_test("F_BFu1s_BFu15s");
    static STRUCT_IF_C F_BFu1s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu15s, F_BFu1s_BFu15s)
//============================================================================


struct  F_BFu1s_BFu16i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 F_BFu1s_BFu16i) C1{ Fi Fs:1 Fi:16}



static void Test_F_BFu1s_BFu16i()
{
  {
    init_simple_test("F_BFu1s_BFu16i");
    static STRUCT_IF_C F_BFu1s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu16i, F_BFu1s_BFu16i)
//============================================================================


struct  F_BFu1s_BFu16ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 F_BFu1s_BFu16ll) C1{ Fi Fs:1 FL:16}



static void Test_F_BFu1s_BFu16ll()
{
  {
    init_simple_test("F_BFu1s_BFu16ll");
    static STRUCT_IF_C F_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu16ll, F_BFu1s_BFu16ll)
//============================================================================


struct  F_BFu1s_BFu16s  {
  float v1;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 F_BFu1s_BFu16s) C1{ Fi Fs:1 Fs:16}



static void Test_F_BFu1s_BFu16s()
{
  {
    init_simple_test("F_BFu1s_BFu16s");
    static STRUCT_IF_C F_BFu1s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu16s, F_BFu1s_BFu16s)
//============================================================================


struct  F_BFu1s_BFu17i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 F_BFu1s_BFu17i) C1{ Fi Fs:1 Fi:17}



static void Test_F_BFu1s_BFu17i()
{
  {
    init_simple_test("F_BFu1s_BFu17i");
    static STRUCT_IF_C F_BFu1s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu17i, F_BFu1s_BFu17i)
//============================================================================


struct  F_BFu1s_BFu17ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 F_BFu1s_BFu17ll) C1{ Fi Fs:1 FL:17}



static void Test_F_BFu1s_BFu17ll()
{
  {
    init_simple_test("F_BFu1s_BFu17ll");
    static STRUCT_IF_C F_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu17ll, F_BFu1s_BFu17ll)
//============================================================================


struct  F_BFu1s_BFu1c  {
  float v1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 F_BFu1s_BFu1c) C1{ Fi Fs:1 Fc:1}



static void Test_F_BFu1s_BFu1c()
{
  {
    init_simple_test("F_BFu1s_BFu1c");
    static STRUCT_IF_C F_BFu1s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu1c, F_BFu1s_BFu1c)
//============================================================================


struct  F_BFu1s_BFu1i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 F_BFu1s_BFu1i) C1{ Fi Fs:1 Fi:1}



static void Test_F_BFu1s_BFu1i()
{
  {
    init_simple_test("F_BFu1s_BFu1i");
    static STRUCT_IF_C F_BFu1s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu1i, F_BFu1s_BFu1i)
//============================================================================


struct  F_BFu1s_BFu1ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 F_BFu1s_BFu1ll) C1{ Fi Fs:1 FL:1}



static void Test_F_BFu1s_BFu1ll()
{
  {
    init_simple_test("F_BFu1s_BFu1ll");
    static STRUCT_IF_C F_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu1ll, F_BFu1s_BFu1ll)
//============================================================================


struct  F_BFu1s_BFu1s  {
  float v1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 F_BFu1s_BFu1s) C1{ Fi Fs:1 Fs:1}



static void Test_F_BFu1s_BFu1s()
{
  {
    init_simple_test("F_BFu1s_BFu1s");
    static STRUCT_IF_C F_BFu1s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu1s, F_BFu1s_BFu1s)
//============================================================================


struct  F_BFu1s_BFu31i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 F_BFu1s_BFu31i) C1{ Fi Fs:1 Fi:31}



static void Test_F_BFu1s_BFu31i()
{
  {
    init_simple_test("F_BFu1s_BFu31i");
    static STRUCT_IF_C F_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu31i, F_BFu1s_BFu31i)
//============================================================================


struct  F_BFu1s_BFu31ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 F_BFu1s_BFu31ll) C1{ Fi Fs:1 FL:31}



static void Test_F_BFu1s_BFu31ll()
{
  {
    init_simple_test("F_BFu1s_BFu31ll");
    static STRUCT_IF_C F_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu31ll, F_BFu1s_BFu31ll)
//============================================================================


struct  F_BFu1s_BFu32i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 F_BFu1s_BFu32i) C1{ Fi Fs:1 Fi:32}



static void Test_F_BFu1s_BFu32i()
{
  {
    init_simple_test("F_BFu1s_BFu32i");
    static STRUCT_IF_C F_BFu1s_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu32i, F_BFu1s_BFu32i)
//============================================================================


struct  F_BFu1s_BFu32ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 F_BFu1s_BFu32ll) C1{ Fi Fs:1 FL:32}



static void Test_F_BFu1s_BFu32ll()
{
  {
    init_simple_test("F_BFu1s_BFu32ll");
    static STRUCT_IF_C F_BFu1s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "F_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "F_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu32ll, F_BFu1s_BFu32ll)
//============================================================================


struct  F_BFu1s_BFu33  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 F_BFu1s_BFu33) C1{ Fi Fs:1 FL:33}



static void Test_F_BFu1s_BFu33()
{
  {
    init_simple_test("F_BFu1s_BFu33");
    static STRUCT_IF_C F_BFu1s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "F_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "F_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu33, F_BFu1s_BFu33)
//============================================================================


struct  F_BFu1s_BFu7c  {
  float v1;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 F_BFu1s_BFu7c) C1{ Fi Fs:1 Fc:7}



static void Test_F_BFu1s_BFu7c()
{
  {
    init_simple_test("F_BFu1s_BFu7c");
    static STRUCT_IF_C F_BFu1s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu7c, F_BFu1s_BFu7c)
//============================================================================


struct  F_BFu1s_BFu7i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 F_BFu1s_BFu7i) C1{ Fi Fs:1 Fi:7}



static void Test_F_BFu1s_BFu7i()
{
  {
    init_simple_test("F_BFu1s_BFu7i");
    static STRUCT_IF_C F_BFu1s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu7i, F_BFu1s_BFu7i)
//============================================================================


struct  F_BFu1s_BFu7ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 F_BFu1s_BFu7ll) C1{ Fi Fs:1 FL:7}



static void Test_F_BFu1s_BFu7ll()
{
  {
    init_simple_test("F_BFu1s_BFu7ll");
    static STRUCT_IF_C F_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu7ll, F_BFu1s_BFu7ll)
//============================================================================


struct  F_BFu1s_BFu7s  {
  float v1;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 F_BFu1s_BFu7s) C1{ Fi Fs:1 Fs:7}



static void Test_F_BFu1s_BFu7s()
{
  {
    init_simple_test("F_BFu1s_BFu7s");
    static STRUCT_IF_C F_BFu1s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu7s, F_BFu1s_BFu7s)
//============================================================================


struct  F_BFu1s_BFu8c  {
  float v1;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 F_BFu1s_BFu8c) C1{ Fi Fs:1 Fc:8}



static void Test_F_BFu1s_BFu8c()
{
  {
    init_simple_test("F_BFu1s_BFu8c");
    static STRUCT_IF_C F_BFu1s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu8c, F_BFu1s_BFu8c)
//============================================================================


struct  F_BFu1s_BFu8i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 F_BFu1s_BFu8i) C1{ Fi Fs:1 Fi:8}



static void Test_F_BFu1s_BFu8i()
{
  {
    init_simple_test("F_BFu1s_BFu8i");
    static STRUCT_IF_C F_BFu1s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu8i, F_BFu1s_BFu8i)
//============================================================================


struct  F_BFu1s_BFu8ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 F_BFu1s_BFu8ll) C1{ Fi Fs:1 FL:8}



static void Test_F_BFu1s_BFu8ll()
{
  {
    init_simple_test("F_BFu1s_BFu8ll");
    static STRUCT_IF_C F_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu8ll, F_BFu1s_BFu8ll)
//============================================================================


struct  F_BFu1s_BFu8s  {
  float v1;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 F_BFu1s_BFu8s) C1{ Fi Fs:1 Fs:8}



static void Test_F_BFu1s_BFu8s()
{
  {
    init_simple_test("F_BFu1s_BFu8s");
    static STRUCT_IF_C F_BFu1s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu8s, F_BFu1s_BFu8s)
//============================================================================


struct  F_BFu1s_BFu9i  {
  float v1;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 F_BFu1s_BFu9i) C1{ Fi Fs:1 Fi:9}



static void Test_F_BFu1s_BFu9i()
{
  {
    init_simple_test("F_BFu1s_BFu9i");
    static STRUCT_IF_C F_BFu1s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu9i, F_BFu1s_BFu9i)
//============================================================================


struct  F_BFu1s_BFu9ll  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 F_BFu1s_BFu9ll) C1{ Fi Fs:1 FL:9}



static void Test_F_BFu1s_BFu9ll()
{
  {
    init_simple_test("F_BFu1s_BFu9ll");
    static STRUCT_IF_C F_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu9ll, F_BFu1s_BFu9ll)
//============================================================================


struct  F_BFu1s_BFu9s  {
  float v1;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 F_BFu1s_BFu9s) C1{ Fi Fs:1 Fs:9}



static void Test_F_BFu1s_BFu9s()
{
  {
    init_simple_test("F_BFu1s_BFu9s");
    static STRUCT_IF_C F_BFu1s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu9s, F_BFu1s_BFu9s)
//============================================================================


struct  F_BFu1s_C  {
  float v1;
  unsigned short v2:1;
  char v3;
};
//SIG(1 F_BFu1s_C) C1{ Fi Fs:1 Fc}



static void Test_F_BFu1s_C()
{
  {
    init_simple_test("F_BFu1s_C");
    static STRUCT_IF_C F_BFu1s_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_C)");
    check_field_offset(lv, v1, 0, "F_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_C");
    check_field_offset(lv, v3, 5, "F_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_C, F_BFu1s_C)
//============================================================================


struct  F_BFu1s_D  {
  float v1;
  unsigned short v2:1;
  double v3;
};
//SIG(1 F_BFu1s_D) C1{ Fi Fs:1 FL}



static void Test_F_BFu1s_D()
{
  {
    init_simple_test("F_BFu1s_D");
    static STRUCT_IF_C F_BFu1s_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_D)");
    check_field_offset(lv, v1, 0, "F_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_D");
    check_field_offset(lv, v3, 8, "F_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_D, F_BFu1s_D)
//============================================================================


struct  F_BFu1s_F  {
  float v1;
  unsigned short v2:1;
  float v3;
};
//SIG(1 F_BFu1s_F) C1{ Fi Fs:1 Fi}



static void Test_F_BFu1s_F()
{
  {
    init_simple_test("F_BFu1s_F");
    static STRUCT_IF_C F_BFu1s_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_F)");
    check_field_offset(lv, v1, 0, "F_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_F");
    check_field_offset(lv, v3, 8, "F_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_F, F_BFu1s_F)
//============================================================================


struct  F_BFu1s_I  {
  float v1;
  unsigned short v2:1;
  int v3;
};
//SIG(1 F_BFu1s_I) C1{ Fi Fs:1 Fi}



static void Test_F_BFu1s_I()
{
  {
    init_simple_test("F_BFu1s_I");
    static STRUCT_IF_C F_BFu1s_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_I)");
    check_field_offset(lv, v1, 0, "F_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_I");
    check_field_offset(lv, v3, 8, "F_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_I, F_BFu1s_I)
//============================================================================


struct  F_BFu1s_Ip  {
  float v1;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 F_BFu1s_Ip) C1{ Fi Fs:1 Fp}



static void Test_F_BFu1s_Ip()
{
  {
    init_simple_test("F_BFu1s_Ip");
    static STRUCT_IF_C F_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Ip");
    check_field_offset(lv, v3, 8, "F_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Ip, F_BFu1s_Ip)
//============================================================================


struct  F_BFu1s_L  {
  float v1;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 F_BFu1s_L) C1{ Fi Fs:1 FL}



static void Test_F_BFu1s_L()
{
  {
    init_simple_test("F_BFu1s_L");
    static STRUCT_IF_C F_BFu1s_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_L)");
    check_field_offset(lv, v1, 0, "F_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_L");
    check_field_offset(lv, v3, 8, "F_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_L, F_BFu1s_L)
//============================================================================


struct  F_BFu1s_S  {
  float v1;
  unsigned short v2:1;
  short v3;
};
//SIG(1 F_BFu1s_S) C1{ Fi Fs:1 Fs}



static void Test_F_BFu1s_S()
{
  {
    init_simple_test("F_BFu1s_S");
    static STRUCT_IF_C F_BFu1s_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_S)");
    check_field_offset(lv, v1, 0, "F_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_S");
    check_field_offset(lv, v3, 6, "F_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_S, F_BFu1s_S)
//============================================================================


struct  F_BFu1s_Uc  {
  float v1;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 F_BFu1s_Uc) C1{ Fi Fs:1 Fc}



static void Test_F_BFu1s_Uc()
{
  {
    init_simple_test("F_BFu1s_Uc");
    static STRUCT_IF_C F_BFu1s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Uc");
    check_field_offset(lv, v3, 5, "F_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Uc, F_BFu1s_Uc)
//============================================================================


struct  F_BFu1s_Ui  {
  float v1;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 F_BFu1s_Ui) C1{ Fi Fs:1 Fi}



static void Test_F_BFu1s_Ui()
{
  {
    init_simple_test("F_BFu1s_Ui");
    static STRUCT_IF_C F_BFu1s_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Ui");
    check_field_offset(lv, v3, 8, "F_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Ui, F_BFu1s_Ui)
//============================================================================


struct  F_BFu1s_Ul  {
  float v1;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 F_BFu1s_Ul) C1{ Fi Fs:1 FL}



static void Test_F_BFu1s_Ul()
{
  {
    init_simple_test("F_BFu1s_Ul");
    static STRUCT_IF_C F_BFu1s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Ul");
    check_field_offset(lv, v3, 8, "F_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Ul, F_BFu1s_Ul)
//============================================================================


struct  F_BFu1s_Us  {
  float v1;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 F_BFu1s_Us) C1{ Fi Fs:1 Fs}



static void Test_F_BFu1s_Us()
{
  {
    init_simple_test("F_BFu1s_Us");
    static STRUCT_IF_C F_BFu1s_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Us");
    check_field_offset(lv, v3, 6, "F_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Us, F_BFu1s_Us)
//============================================================================


struct  F_BFu1s_Vp  {
  float v1;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 F_BFu1s_Vp) C1{ Fi Fs:1 Fp}



static void Test_F_BFu1s_Vp()
{
  {
    init_simple_test("F_BFu1s_Vp");
    static STRUCT_IF_C F_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Vp");
    check_field_offset(lv, v3, 8, "F_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Vp, F_BFu1s_Vp)
//============================================================================


struct  F_BFu31i  {
  float v1;
  unsigned int v2:31;
};
//SIG(1 F_BFu31i) C1{ Fi Fi:31}



static void Test_F_BFu31i()
{
  {
    init_simple_test("F_BFu31i");
    static STRUCT_IF_C F_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i, F_BFu31i)
//============================================================================


struct  F_BFu31i_BFu15i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 F_BFu31i_BFu15i) C1{ Fi Fi:31 Fi:15}



static void Test_F_BFu31i_BFu15i()
{
  {
    init_simple_test("F_BFu31i_BFu15i");
    static STRUCT_IF_C F_BFu31i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu15i, F_BFu31i_BFu15i)
//============================================================================


struct  F_BFu31i_BFu15ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 F_BFu31i_BFu15ll) C1{ Fi Fi:31 FL:15}



static void Test_F_BFu31i_BFu15ll()
{
  {
    init_simple_test("F_BFu31i_BFu15ll");
    static STRUCT_IF_C F_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "F_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "F_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu15ll, F_BFu31i_BFu15ll)
//============================================================================


struct  F_BFu31i_BFu15s  {
  float v1;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 F_BFu31i_BFu15s) C1{ Fi Fi:31 Fs:15}



static void Test_F_BFu31i_BFu15s()
{
  {
    init_simple_test("F_BFu31i_BFu15s");
    static STRUCT_IF_C F_BFu31i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu15s, F_BFu31i_BFu15s)
//============================================================================


struct  F_BFu31i_BFu16i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 F_BFu31i_BFu16i) C1{ Fi Fi:31 Fi:16}



static void Test_F_BFu31i_BFu16i()
{
  {
    init_simple_test("F_BFu31i_BFu16i");
    static STRUCT_IF_C F_BFu31i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu16i, F_BFu31i_BFu16i)
//============================================================================


struct  F_BFu31i_BFu16ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 F_BFu31i_BFu16ll) C1{ Fi Fi:31 FL:16}



static void Test_F_BFu31i_BFu16ll()
{
  {
    init_simple_test("F_BFu31i_BFu16ll");
    static STRUCT_IF_C F_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "F_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "F_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu16ll, F_BFu31i_BFu16ll)
//============================================================================


struct  F_BFu31i_BFu16s  {
  float v1;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 F_BFu31i_BFu16s) C1{ Fi Fi:31 Fs:16}



static void Test_F_BFu31i_BFu16s()
{
  {
    init_simple_test("F_BFu31i_BFu16s");
    static STRUCT_IF_C F_BFu31i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu16s, F_BFu31i_BFu16s)
//============================================================================


struct  F_BFu31i_BFu17i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 F_BFu31i_BFu17i) C1{ Fi Fi:31 Fi:17}



static void Test_F_BFu31i_BFu17i()
{
  {
    init_simple_test("F_BFu31i_BFu17i");
    static STRUCT_IF_C F_BFu31i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu17i, F_BFu31i_BFu17i)
//============================================================================


struct  F_BFu31i_BFu17ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 F_BFu31i_BFu17ll) C1{ Fi Fi:31 FL:17}



static void Test_F_BFu31i_BFu17ll()
{
  {
    init_simple_test("F_BFu31i_BFu17ll");
    static STRUCT_IF_C F_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "F_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "F_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu17ll, F_BFu31i_BFu17ll)
//============================================================================


struct  F_BFu31i_BFu1c  {
  float v1;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 F_BFu31i_BFu1c) C1{ Fi Fi:31 Fc:1}



static void Test_F_BFu31i_BFu1c()
{
  {
    init_simple_test("F_BFu31i_BFu1c");
    static STRUCT_IF_C F_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu1c, F_BFu31i_BFu1c)
//============================================================================


struct  F_BFu31i_BFu1i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 F_BFu31i_BFu1i) C1{ Fi Fi:31 Fi:1}



static void Test_F_BFu31i_BFu1i()
{
  {
    init_simple_test("F_BFu31i_BFu1i");
    static STRUCT_IF_C F_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu1i, F_BFu31i_BFu1i)
//============================================================================


struct  F_BFu31i_BFu1ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 F_BFu31i_BFu1ll) C1{ Fi Fi:31 FL:1}



static void Test_F_BFu31i_BFu1ll()
{
  {
    init_simple_test("F_BFu31i_BFu1ll");
    static STRUCT_IF_C F_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu1ll, F_BFu31i_BFu1ll)
//============================================================================


struct  F_BFu31i_BFu1s  {
  float v1;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 F_BFu31i_BFu1s) C1{ Fi Fi:31 Fs:1}



static void Test_F_BFu31i_BFu1s()
{
  {
    init_simple_test("F_BFu31i_BFu1s");
    static STRUCT_IF_C F_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu1s, F_BFu31i_BFu1s)
//============================================================================


struct  F_BFu31i_BFu31i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 F_BFu31i_BFu31i) C1{ Fi Fi:31 Fi:31}



static void Test_F_BFu31i_BFu31i()
{
  {
    init_simple_test("F_BFu31i_BFu31i");
    static STRUCT_IF_C F_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu31i, F_BFu31i_BFu31i)
//============================================================================


struct  F_BFu31i_BFu31ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 F_BFu31i_BFu31ll) C1{ Fi Fi:31 FL:31}



static void Test_F_BFu31i_BFu31ll()
{
  {
    init_simple_test("F_BFu31i_BFu31ll");
    static STRUCT_IF_C F_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "F_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "F_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu31ll, F_BFu31i_BFu31ll)
//============================================================================


struct  F_BFu31i_BFu32i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 F_BFu31i_BFu32i) C1{ Fi Fi:31 Fi:32}



static void Test_F_BFu31i_BFu32i()
{
  {
    init_simple_test("F_BFu31i_BFu32i");
    static STRUCT_IF_C F_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu32i, F_BFu31i_BFu32i)
//============================================================================


struct  F_BFu31i_BFu32ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 F_BFu31i_BFu32ll) C1{ Fi Fi:31 FL:32}



static void Test_F_BFu31i_BFu32ll()
{
  {
    init_simple_test("F_BFu31i_BFu32ll");
    static STRUCT_IF_C F_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "F_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "F_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu32ll, F_BFu31i_BFu32ll)
//============================================================================


struct  F_BFu31i_BFu33  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 F_BFu31i_BFu33) C1{ Fi Fi:31 FL:33}



static void Test_F_BFu31i_BFu33()
{
  {
    init_simple_test("F_BFu31i_BFu33");
    static STRUCT_IF_C F_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "F_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "F_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu33, F_BFu31i_BFu33)
//============================================================================


struct  F_BFu31i_BFu7c  {
  float v1;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 F_BFu31i_BFu7c) C1{ Fi Fi:31 Fc:7}



static void Test_F_BFu31i_BFu7c()
{
  {
    init_simple_test("F_BFu31i_BFu7c");
    static STRUCT_IF_C F_BFu31i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu7c, F_BFu31i_BFu7c)
//============================================================================


struct  F_BFu31i_BFu7i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 F_BFu31i_BFu7i) C1{ Fi Fi:31 Fi:7}



static void Test_F_BFu31i_BFu7i()
{
  {
    init_simple_test("F_BFu31i_BFu7i");
    static STRUCT_IF_C F_BFu31i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu7i, F_BFu31i_BFu7i)
//============================================================================


struct  F_BFu31i_BFu7ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 F_BFu31i_BFu7ll) C1{ Fi Fi:31 FL:7}



static void Test_F_BFu31i_BFu7ll()
{
  {
    init_simple_test("F_BFu31i_BFu7ll");
    static STRUCT_IF_C F_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "F_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "F_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu7ll, F_BFu31i_BFu7ll)
//============================================================================


struct  F_BFu31i_BFu7s  {
  float v1;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 F_BFu31i_BFu7s) C1{ Fi Fi:31 Fs:7}



static void Test_F_BFu31i_BFu7s()
{
  {
    init_simple_test("F_BFu31i_BFu7s");
    static STRUCT_IF_C F_BFu31i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu7s, F_BFu31i_BFu7s)
//============================================================================


struct  F_BFu31i_BFu8c  {
  float v1;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 F_BFu31i_BFu8c) C1{ Fi Fi:31 Fc:8}



static void Test_F_BFu31i_BFu8c()
{
  {
    init_simple_test("F_BFu31i_BFu8c");
    static STRUCT_IF_C F_BFu31i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu8c, F_BFu31i_BFu8c)
//============================================================================


struct  F_BFu31i_BFu8i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 F_BFu31i_BFu8i) C1{ Fi Fi:31 Fi:8}



static void Test_F_BFu31i_BFu8i()
{
  {
    init_simple_test("F_BFu31i_BFu8i");
    static STRUCT_IF_C F_BFu31i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu8i, F_BFu31i_BFu8i)
//============================================================================


struct  F_BFu31i_BFu8ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 F_BFu31i_BFu8ll) C1{ Fi Fi:31 FL:8}



static void Test_F_BFu31i_BFu8ll()
{
  {
    init_simple_test("F_BFu31i_BFu8ll");
    static STRUCT_IF_C F_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "F_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "F_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu8ll, F_BFu31i_BFu8ll)
//============================================================================


struct  F_BFu31i_BFu8s  {
  float v1;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 F_BFu31i_BFu8s) C1{ Fi Fi:31 Fs:8}



static void Test_F_BFu31i_BFu8s()
{
  {
    init_simple_test("F_BFu31i_BFu8s");
    static STRUCT_IF_C F_BFu31i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu8s, F_BFu31i_BFu8s)
//============================================================================


struct  F_BFu31i_BFu9i  {
  float v1;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 F_BFu31i_BFu9i) C1{ Fi Fi:31 Fi:9}



static void Test_F_BFu31i_BFu9i()
{
  {
    init_simple_test("F_BFu31i_BFu9i");
    static STRUCT_IF_C F_BFu31i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu9i, F_BFu31i_BFu9i)
//============================================================================


struct  F_BFu31i_BFu9ll  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 F_BFu31i_BFu9ll) C1{ Fi Fi:31 FL:9}



static void Test_F_BFu31i_BFu9ll()
{
  {
    init_simple_test("F_BFu31i_BFu9ll");
    static STRUCT_IF_C F_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "F_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "F_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu9ll, F_BFu31i_BFu9ll)
//============================================================================


struct  F_BFu31i_BFu9s  {
  float v1;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 F_BFu31i_BFu9s) C1{ Fi Fi:31 Fs:9}



static void Test_F_BFu31i_BFu9s()
{
  {
    init_simple_test("F_BFu31i_BFu9s");
    static STRUCT_IF_C F_BFu31i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu9s, F_BFu31i_BFu9s)
//============================================================================


struct  F_BFu31i_C  {
  float v1;
  unsigned int v2:31;
  char v3;
};
//SIG(1 F_BFu31i_C) C1{ Fi Fi:31 Fc}



static void Test_F_BFu31i_C()
{
  {
    init_simple_test("F_BFu31i_C");
    static STRUCT_IF_C F_BFu31i_C lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_C)");
    check_field_offset(lv, v1, 0, "F_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_C");
    check_field_offset(lv, v3, 8, "F_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_C, F_BFu31i_C)
//============================================================================


struct  F_BFu31i_D  {
  float v1;
  unsigned int v2:31;
  double v3;
};
//SIG(1 F_BFu31i_D) C1{ Fi Fi:31 FL}



static void Test_F_BFu31i_D()
{
  {
    init_simple_test("F_BFu31i_D");
    static STRUCT_IF_C F_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_D)");
    check_field_offset(lv, v1, 0, "F_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_D");
    check_field_offset(lv, v3, 8, "F_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_D, F_BFu31i_D)
//============================================================================


struct  F_BFu31i_F  {
  float v1;
  unsigned int v2:31;
  float v3;
};
//SIG(1 F_BFu31i_F) C1{ Fi Fi:31 Fi}



static void Test_F_BFu31i_F()
{
  {
    init_simple_test("F_BFu31i_F");
    static STRUCT_IF_C F_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_F)");
    check_field_offset(lv, v1, 0, "F_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_F");
    check_field_offset(lv, v3, 8, "F_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_F, F_BFu31i_F)
//============================================================================


struct  F_BFu31i_I  {
  float v1;
  unsigned int v2:31;
  int v3;
};
//SIG(1 F_BFu31i_I) C1{ Fi Fi:31 Fi}



static void Test_F_BFu31i_I()
{
  {
    init_simple_test("F_BFu31i_I");
    static STRUCT_IF_C F_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_I)");
    check_field_offset(lv, v1, 0, "F_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_I");
    check_field_offset(lv, v3, 8, "F_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_I, F_BFu31i_I)
//============================================================================


struct  F_BFu31i_Ip  {
  float v1;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 F_BFu31i_Ip) C1{ Fi Fi:31 Fp}



static void Test_F_BFu31i_Ip()
{
  {
    init_simple_test("F_BFu31i_Ip");
    static STRUCT_IF_C F_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "F_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Ip, F_BFu31i_Ip)
//============================================================================


struct  F_BFu31i_L  {
  float v1;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 F_BFu31i_L) C1{ Fi Fi:31 FL}



static void Test_F_BFu31i_L()
{
  {
    init_simple_test("F_BFu31i_L");
    static STRUCT_IF_C F_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_L)");
    check_field_offset(lv, v1, 0, "F_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_L");
    check_field_offset(lv, v3, 8, "F_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_L, F_BFu31i_L)
//============================================================================


struct  F_BFu31i_S  {
  float v1;
  unsigned int v2:31;
  short v3;
};
//SIG(1 F_BFu31i_S) C1{ Fi Fi:31 Fs}



static void Test_F_BFu31i_S()
{
  {
    init_simple_test("F_BFu31i_S");
    static STRUCT_IF_C F_BFu31i_S lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_S)");
    check_field_offset(lv, v1, 0, "F_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_S");
    check_field_offset(lv, v3, 8, "F_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_S, F_BFu31i_S)
//============================================================================


struct  F_BFu31i_Uc  {
  float v1;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 F_BFu31i_Uc) C1{ Fi Fi:31 Fc}



static void Test_F_BFu31i_Uc()
{
  {
    init_simple_test("F_BFu31i_Uc");
    static STRUCT_IF_C F_BFu31i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "F_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Uc, F_BFu31i_Uc)
//============================================================================


struct  F_BFu31i_Ui  {
  float v1;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 F_BFu31i_Ui) C1{ Fi Fi:31 Fi}



static void Test_F_BFu31i_Ui()
{
  {
    init_simple_test("F_BFu31i_Ui");
    static STRUCT_IF_C F_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "F_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Ui, F_BFu31i_Ui)
//============================================================================


struct  F_BFu31i_Ul  {
  float v1;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 F_BFu31i_Ul) C1{ Fi Fi:31 FL}



static void Test_F_BFu31i_Ul()
{
  {
    init_simple_test("F_BFu31i_Ul");
    static STRUCT_IF_C F_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "F_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Ul, F_BFu31i_Ul)
//============================================================================


struct  F_BFu31i_Us  {
  float v1;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 F_BFu31i_Us) C1{ Fi Fi:31 Fs}



static void Test_F_BFu31i_Us()
{
  {
    init_simple_test("F_BFu31i_Us");
    static STRUCT_IF_C F_BFu31i_Us lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Us");
    check_field_offset(lv, v3, 8, "F_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Us, F_BFu31i_Us)
//============================================================================


struct  F_BFu31i_Vp  {
  float v1;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 F_BFu31i_Vp) C1{ Fi Fi:31 Fp}



static void Test_F_BFu31i_Vp()
{
  {
    init_simple_test("F_BFu31i_Vp");
    static STRUCT_IF_C F_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "F_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Vp, F_BFu31i_Vp)
//============================================================================


struct  F_BFu31ll  {
  float v1;
  __tsu64 v2:31;
};
//SIG(1 F_BFu31ll) C1{ Fi FL:31}



static void Test_F_BFu31ll()
{
  {
    init_simple_test("F_BFu31ll");
    static STRUCT_IF_C F_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll, F_BFu31ll)
//============================================================================


struct  F_BFu31ll_BFu15i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 F_BFu31ll_BFu15i) C1{ Fi FL:31 Fi:15}



static void Test_F_BFu31ll_BFu15i()
{
  {
    init_simple_test("F_BFu31ll_BFu15i");
    static STRUCT_IF_C F_BFu31ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu15i, F_BFu31ll_BFu15i)
//============================================================================


struct  F_BFu31ll_BFu15ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 F_BFu31ll_BFu15ll) C1{ Fi FL:31 FL:15}



static void Test_F_BFu31ll_BFu15ll()
{
  {
    init_simple_test("F_BFu31ll_BFu15ll");
    static STRUCT_IF_C F_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "F_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "F_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu15ll, F_BFu31ll_BFu15ll)
//============================================================================


struct  F_BFu31ll_BFu15s  {
  float v1;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 F_BFu31ll_BFu15s) C1{ Fi FL:31 Fs:15}



static void Test_F_BFu31ll_BFu15s()
{
  {
    init_simple_test("F_BFu31ll_BFu15s");
    static STRUCT_IF_C F_BFu31ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu15s, F_BFu31ll_BFu15s)
//============================================================================


struct  F_BFu31ll_BFu16i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 F_BFu31ll_BFu16i) C1{ Fi FL:31 Fi:16}



static void Test_F_BFu31ll_BFu16i()
{
  {
    init_simple_test("F_BFu31ll_BFu16i");
    static STRUCT_IF_C F_BFu31ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu16i, F_BFu31ll_BFu16i)
//============================================================================


struct  F_BFu31ll_BFu16ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 F_BFu31ll_BFu16ll) C1{ Fi FL:31 FL:16}



static void Test_F_BFu31ll_BFu16ll()
{
  {
    init_simple_test("F_BFu31ll_BFu16ll");
    static STRUCT_IF_C F_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "F_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "F_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu16ll, F_BFu31ll_BFu16ll)
//============================================================================


struct  F_BFu31ll_BFu16s  {
  float v1;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 F_BFu31ll_BFu16s) C1{ Fi FL:31 Fs:16}



static void Test_F_BFu31ll_BFu16s()
{
  {
    init_simple_test("F_BFu31ll_BFu16s");
    static STRUCT_IF_C F_BFu31ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu16s, F_BFu31ll_BFu16s)
//============================================================================


struct  F_BFu31ll_BFu17i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 F_BFu31ll_BFu17i) C1{ Fi FL:31 Fi:17}



static void Test_F_BFu31ll_BFu17i()
{
  {
    init_simple_test("F_BFu31ll_BFu17i");
    static STRUCT_IF_C F_BFu31ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu17i, F_BFu31ll_BFu17i)
//============================================================================


struct  F_BFu31ll_BFu17ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 F_BFu31ll_BFu17ll) C1{ Fi FL:31 FL:17}



static void Test_F_BFu31ll_BFu17ll()
{
  {
    init_simple_test("F_BFu31ll_BFu17ll");
    static STRUCT_IF_C F_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "F_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "F_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu17ll, F_BFu31ll_BFu17ll)
//============================================================================


struct  F_BFu31ll_BFu1c  {
  float v1;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 F_BFu31ll_BFu1c) C1{ Fi FL:31 Fc:1}



static void Test_F_BFu31ll_BFu1c()
{
  {
    init_simple_test("F_BFu31ll_BFu1c");
    static STRUCT_IF_C F_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu1c, F_BFu31ll_BFu1c)
//============================================================================


struct  F_BFu31ll_BFu1i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 F_BFu31ll_BFu1i) C1{ Fi FL:31 Fi:1}



static void Test_F_BFu31ll_BFu1i()
{
  {
    init_simple_test("F_BFu31ll_BFu1i");
    static STRUCT_IF_C F_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu1i, F_BFu31ll_BFu1i)
//============================================================================


struct  F_BFu31ll_BFu1ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 F_BFu31ll_BFu1ll) C1{ Fi FL:31 FL:1}



static void Test_F_BFu31ll_BFu1ll()
{
  {
    init_simple_test("F_BFu31ll_BFu1ll");
    static STRUCT_IF_C F_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu1ll, F_BFu31ll_BFu1ll)
//============================================================================


struct  F_BFu31ll_BFu1s  {
  float v1;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 F_BFu31ll_BFu1s) C1{ Fi FL:31 Fs:1}



static void Test_F_BFu31ll_BFu1s()
{
  {
    init_simple_test("F_BFu31ll_BFu1s");
    static STRUCT_IF_C F_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu1s, F_BFu31ll_BFu1s)
//============================================================================


struct  F_BFu31ll_BFu31i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 F_BFu31ll_BFu31i) C1{ Fi FL:31 Fi:31}



static void Test_F_BFu31ll_BFu31i()
{
  {
    init_simple_test("F_BFu31ll_BFu31i");
    static STRUCT_IF_C F_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu31i, F_BFu31ll_BFu31i)
//============================================================================


struct  F_BFu31ll_BFu31ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 F_BFu31ll_BFu31ll) C1{ Fi FL:31 FL:31}



static void Test_F_BFu31ll_BFu31ll()
{
  {
    init_simple_test("F_BFu31ll_BFu31ll");
    static STRUCT_IF_C F_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "F_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "F_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu31ll, F_BFu31ll_BFu31ll)
//============================================================================


struct  F_BFu31ll_BFu32i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 F_BFu31ll_BFu32i) C1{ Fi FL:31 Fi:32}



static void Test_F_BFu31ll_BFu32i()
{
  {
    init_simple_test("F_BFu31ll_BFu32i");
    static STRUCT_IF_C F_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu32i, F_BFu31ll_BFu32i)
//============================================================================


struct  F_BFu31ll_BFu32ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 F_BFu31ll_BFu32ll) C1{ Fi FL:31 FL:32}



static void Test_F_BFu31ll_BFu32ll()
{
  {
    init_simple_test("F_BFu31ll_BFu32ll");
    static STRUCT_IF_C F_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "F_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "F_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu32ll, F_BFu31ll_BFu32ll)
//============================================================================


struct  F_BFu31ll_BFu33  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 F_BFu31ll_BFu33) C1{ Fi FL:31 FL:33}



static void Test_F_BFu31ll_BFu33()
{
  {
    init_simple_test("F_BFu31ll_BFu33");
    static STRUCT_IF_C F_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "F_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "F_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu33, F_BFu31ll_BFu33)
//============================================================================


struct  F_BFu31ll_BFu7c  {
  float v1;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 F_BFu31ll_BFu7c) C1{ Fi FL:31 Fc:7}



static void Test_F_BFu31ll_BFu7c()
{
  {
    init_simple_test("F_BFu31ll_BFu7c");
    static STRUCT_IF_C F_BFu31ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu7c, F_BFu31ll_BFu7c)
//============================================================================


struct  F_BFu31ll_BFu7i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 F_BFu31ll_BFu7i) C1{ Fi FL:31 Fi:7}



static void Test_F_BFu31ll_BFu7i()
{
  {
    init_simple_test("F_BFu31ll_BFu7i");
    static STRUCT_IF_C F_BFu31ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu7i, F_BFu31ll_BFu7i)
//============================================================================


struct  F_BFu31ll_BFu7ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 F_BFu31ll_BFu7ll) C1{ Fi FL:31 FL:7}



static void Test_F_BFu31ll_BFu7ll()
{
  {
    init_simple_test("F_BFu31ll_BFu7ll");
    static STRUCT_IF_C F_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "F_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "F_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu7ll, F_BFu31ll_BFu7ll)
//============================================================================


struct  F_BFu31ll_BFu7s  {
  float v1;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 F_BFu31ll_BFu7s) C1{ Fi FL:31 Fs:7}



static void Test_F_BFu31ll_BFu7s()
{
  {
    init_simple_test("F_BFu31ll_BFu7s");
    static STRUCT_IF_C F_BFu31ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu7s, F_BFu31ll_BFu7s)
//============================================================================


struct  F_BFu31ll_BFu8c  {
  float v1;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 F_BFu31ll_BFu8c) C1{ Fi FL:31 Fc:8}



static void Test_F_BFu31ll_BFu8c()
{
  {
    init_simple_test("F_BFu31ll_BFu8c");
    static STRUCT_IF_C F_BFu31ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu8c, F_BFu31ll_BFu8c)
//============================================================================


struct  F_BFu31ll_BFu8i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 F_BFu31ll_BFu8i) C1{ Fi FL:31 Fi:8}



static void Test_F_BFu31ll_BFu8i()
{
  {
    init_simple_test("F_BFu31ll_BFu8i");
    static STRUCT_IF_C F_BFu31ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu8i, F_BFu31ll_BFu8i)
//============================================================================


struct  F_BFu31ll_BFu8ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 F_BFu31ll_BFu8ll) C1{ Fi FL:31 FL:8}



static void Test_F_BFu31ll_BFu8ll()
{
  {
    init_simple_test("F_BFu31ll_BFu8ll");
    static STRUCT_IF_C F_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "F_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "F_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu8ll, F_BFu31ll_BFu8ll)
//============================================================================


struct  F_BFu31ll_BFu8s  {
  float v1;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 F_BFu31ll_BFu8s) C1{ Fi FL:31 Fs:8}



static void Test_F_BFu31ll_BFu8s()
{
  {
    init_simple_test("F_BFu31ll_BFu8s");
    static STRUCT_IF_C F_BFu31ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu8s, F_BFu31ll_BFu8s)
//============================================================================


struct  F_BFu31ll_BFu9i  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 F_BFu31ll_BFu9i) C1{ Fi FL:31 Fi:9}



static void Test_F_BFu31ll_BFu9i()
{
  {
    init_simple_test("F_BFu31ll_BFu9i");
    static STRUCT_IF_C F_BFu31ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu9i, F_BFu31ll_BFu9i)
//============================================================================


struct  F_BFu31ll_BFu9ll  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 F_BFu31ll_BFu9ll) C1{ Fi FL:31 FL:9}



static void Test_F_BFu31ll_BFu9ll()
{
  {
    init_simple_test("F_BFu31ll_BFu9ll");
    static STRUCT_IF_C F_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "F_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "F_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu9ll, F_BFu31ll_BFu9ll)
//============================================================================


struct  F_BFu31ll_BFu9s  {
  float v1;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 F_BFu31ll_BFu9s) C1{ Fi FL:31 Fs:9}



static void Test_F_BFu31ll_BFu9s()
{
  {
    init_simple_test("F_BFu31ll_BFu9s");
    static STRUCT_IF_C F_BFu31ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu9s, F_BFu31ll_BFu9s)
//============================================================================


struct  F_BFu31ll_C  {
  float v1;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 F_BFu31ll_C) C1{ Fi FL:31 Fc}



static void Test_F_BFu31ll_C()
{
  {
    init_simple_test("F_BFu31ll_C");
    static STRUCT_IF_C F_BFu31ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_C");
    check_field_offset(lv, v3, 8, "F_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_C, F_BFu31ll_C)
//============================================================================


struct  F_BFu31ll_D  {
  float v1;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 F_BFu31ll_D) C1{ Fi FL:31 FL}



static void Test_F_BFu31ll_D()
{
  {
    init_simple_test("F_BFu31ll_D");
    static STRUCT_IF_C F_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_D");
    check_field_offset(lv, v3, 8, "F_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_D, F_BFu31ll_D)
//============================================================================


struct  F_BFu31ll_F  {
  float v1;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 F_BFu31ll_F) C1{ Fi FL:31 Fi}



static void Test_F_BFu31ll_F()
{
  {
    init_simple_test("F_BFu31ll_F");
    static STRUCT_IF_C F_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_F");
    check_field_offset(lv, v3, 8, "F_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_F, F_BFu31ll_F)
//============================================================================


struct  F_BFu31ll_I  {
  float v1;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 F_BFu31ll_I) C1{ Fi FL:31 Fi}



static void Test_F_BFu31ll_I()
{
  {
    init_simple_test("F_BFu31ll_I");
    static STRUCT_IF_C F_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_I");
    check_field_offset(lv, v3, 8, "F_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_I, F_BFu31ll_I)
//============================================================================


struct  F_BFu31ll_Ip  {
  float v1;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 F_BFu31ll_Ip) C1{ Fi FL:31 Fp}



static void Test_F_BFu31ll_Ip()
{
  {
    init_simple_test("F_BFu31ll_Ip");
    static STRUCT_IF_C F_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Ip, F_BFu31ll_Ip)
//============================================================================


struct  F_BFu31ll_L  {
  float v1;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 F_BFu31ll_L) C1{ Fi FL:31 FL}



static void Test_F_BFu31ll_L()
{
  {
    init_simple_test("F_BFu31ll_L");
    static STRUCT_IF_C F_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_L");
    check_field_offset(lv, v3, 8, "F_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_L, F_BFu31ll_L)
//============================================================================


struct  F_BFu31ll_S  {
  float v1;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 F_BFu31ll_S) C1{ Fi FL:31 Fs}



static void Test_F_BFu31ll_S()
{
  {
    init_simple_test("F_BFu31ll_S");
    static STRUCT_IF_C F_BFu31ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_S");
    check_field_offset(lv, v3, 8, "F_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_S, F_BFu31ll_S)
//============================================================================


struct  F_BFu31ll_Uc  {
  float v1;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 F_BFu31ll_Uc) C1{ Fi FL:31 Fc}



static void Test_F_BFu31ll_Uc()
{
  {
    init_simple_test("F_BFu31ll_Uc");
    static STRUCT_IF_C F_BFu31ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Uc");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Uc, F_BFu31ll_Uc)
//============================================================================


struct  F_BFu31ll_Ui  {
  float v1;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 F_BFu31ll_Ui) C1{ Fi FL:31 Fi}



static void Test_F_BFu31ll_Ui()
{
  {
    init_simple_test("F_BFu31ll_Ui");
    static STRUCT_IF_C F_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Ui, F_BFu31ll_Ui)
//============================================================================


struct  F_BFu31ll_Ul  {
  float v1;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 F_BFu31ll_Ul) C1{ Fi FL:31 FL}



static void Test_F_BFu31ll_Ul()
{
  {
    init_simple_test("F_BFu31ll_Ul");
    static STRUCT_IF_C F_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Ul, F_BFu31ll_Ul)
//============================================================================


struct  F_BFu31ll_Us  {
  float v1;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 F_BFu31ll_Us) C1{ Fi FL:31 Fs}



static void Test_F_BFu31ll_Us()
{
  {
    init_simple_test("F_BFu31ll_Us");
    static STRUCT_IF_C F_BFu31ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Us");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Us, F_BFu31ll_Us)
//============================================================================


struct  F_BFu31ll_Vp  {
  float v1;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 F_BFu31ll_Vp) C1{ Fi FL:31 Fp}



static void Test_F_BFu31ll_Vp()
{
  {
    init_simple_test("F_BFu31ll_Vp");
    static STRUCT_IF_C F_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Vp, F_BFu31ll_Vp)
//============================================================================


struct  F_BFu32i  {
  float v1;
  unsigned int v2:32;
};
//SIG(1 F_BFu32i) C1{ Fi Fi:32}



static void Test_F_BFu32i()
{
  {
    init_simple_test("F_BFu32i");
    static STRUCT_IF_C F_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i, F_BFu32i)
//============================================================================


struct  F_BFu32i_BFu15i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 F_BFu32i_BFu15i) C1{ Fi Fi:32 Fi:15}



static void Test_F_BFu32i_BFu15i()
{
  {
    init_simple_test("F_BFu32i_BFu15i");
    static STRUCT_IF_C F_BFu32i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu15i, F_BFu32i_BFu15i)
//============================================================================


struct  F_BFu32i_BFu15ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 F_BFu32i_BFu15ll) C1{ Fi Fi:32 FL:15}



static void Test_F_BFu32i_BFu15ll()
{
  {
    init_simple_test("F_BFu32i_BFu15ll");
    static STRUCT_IF_C F_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu15ll, F_BFu32i_BFu15ll)
//============================================================================


struct  F_BFu32i_BFu15s  {
  float v1;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 F_BFu32i_BFu15s) C1{ Fi Fi:32 Fs:15}



static void Test_F_BFu32i_BFu15s()
{
  {
    init_simple_test("F_BFu32i_BFu15s");
    static STRUCT_IF_C F_BFu32i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu15s, F_BFu32i_BFu15s)
//============================================================================


struct  F_BFu32i_BFu16i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 F_BFu32i_BFu16i) C1{ Fi Fi:32 Fi:16}



static void Test_F_BFu32i_BFu16i()
{
  {
    init_simple_test("F_BFu32i_BFu16i");
    static STRUCT_IF_C F_BFu32i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu16i, F_BFu32i_BFu16i)
//============================================================================


struct  F_BFu32i_BFu16ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 F_BFu32i_BFu16ll) C1{ Fi Fi:32 FL:16}



static void Test_F_BFu32i_BFu16ll()
{
  {
    init_simple_test("F_BFu32i_BFu16ll");
    static STRUCT_IF_C F_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu16ll, F_BFu32i_BFu16ll)
//============================================================================


struct  F_BFu32i_BFu16s  {
  float v1;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 F_BFu32i_BFu16s) C1{ Fi Fi:32 Fs:16}



static void Test_F_BFu32i_BFu16s()
{
  {
    init_simple_test("F_BFu32i_BFu16s");
    static STRUCT_IF_C F_BFu32i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu16s, F_BFu32i_BFu16s)
//============================================================================


struct  F_BFu32i_BFu17i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 F_BFu32i_BFu17i) C1{ Fi Fi:32 Fi:17}



static void Test_F_BFu32i_BFu17i()
{
  {
    init_simple_test("F_BFu32i_BFu17i");
    static STRUCT_IF_C F_BFu32i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu17i, F_BFu32i_BFu17i)
//============================================================================


struct  F_BFu32i_BFu17ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 F_BFu32i_BFu17ll) C1{ Fi Fi:32 FL:17}



static void Test_F_BFu32i_BFu17ll()
{
  {
    init_simple_test("F_BFu32i_BFu17ll");
    static STRUCT_IF_C F_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu17ll, F_BFu32i_BFu17ll)
//============================================================================


struct  F_BFu32i_BFu1c  {
  float v1;
  unsigned int v2:32;
  unsigned char v3:1;
};
//SIG(1 F_BFu32i_BFu1c) C1{ Fi Fi:32 Fc:1}



static void Test_F_BFu32i_BFu1c()
{
  {
    init_simple_test("F_BFu32i_BFu1c");
    static STRUCT_IF_C F_BFu32i_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu1c, F_BFu32i_BFu1c)
//============================================================================


struct  F_BFu32i_BFu1i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:1;
};
//SIG(1 F_BFu32i_BFu1i) C1{ Fi Fi:32 Fi:1}



static void Test_F_BFu32i_BFu1i()
{
  {
    init_simple_test("F_BFu32i_BFu1i");
    static STRUCT_IF_C F_BFu32i_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu1i, F_BFu32i_BFu1i)
//============================================================================


struct  F_BFu32i_BFu1ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:1;
};
//SIG(1 F_BFu32i_BFu1ll) C1{ Fi Fi:32 FL:1}



static void Test_F_BFu32i_BFu1ll()
{
  {
    init_simple_test("F_BFu32i_BFu1ll");
    static STRUCT_IF_C F_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu1ll, F_BFu32i_BFu1ll)
//============================================================================


struct  F_BFu32i_BFu1s  {
  float v1;
  unsigned int v2:32;
  unsigned short v3:1;
};
//SIG(1 F_BFu32i_BFu1s) C1{ Fi Fi:32 Fs:1}



static void Test_F_BFu32i_BFu1s()
{
  {
    init_simple_test("F_BFu32i_BFu1s");
    static STRUCT_IF_C F_BFu32i_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu1s, F_BFu32i_BFu1s)
//============================================================================


struct  F_BFu32i_BFu31i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:31;
};
//SIG(1 F_BFu32i_BFu31i) C1{ Fi Fi:32 Fi:31}



static void Test_F_BFu32i_BFu31i()
{
  {
    init_simple_test("F_BFu32i_BFu31i");
    static STRUCT_IF_C F_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu31i, F_BFu32i_BFu31i)
//============================================================================


struct  F_BFu32i_BFu31ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:31;
};
//SIG(1 F_BFu32i_BFu31ll) C1{ Fi Fi:32 FL:31}



static void Test_F_BFu32i_BFu31ll()
{
  {
    init_simple_test("F_BFu32i_BFu31ll");
    static STRUCT_IF_C F_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu31ll, F_BFu32i_BFu31ll)
//============================================================================


struct  F_BFu32i_BFu32i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:32;
};
//SIG(1 F_BFu32i_BFu32i) C1{ Fi Fi:32 Fi:32}



static void Test_F_BFu32i_BFu32i()
{
  {
    init_simple_test("F_BFu32i_BFu32i");
    static STRUCT_IF_C F_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu32i, F_BFu32i_BFu32i)
//============================================================================


struct  F_BFu32i_BFu32ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:32;
};
//SIG(1 F_BFu32i_BFu32ll) C1{ Fi Fi:32 FL:32}



static void Test_F_BFu32i_BFu32ll()
{
  {
    init_simple_test("F_BFu32i_BFu32ll");
    static STRUCT_IF_C F_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu32ll, F_BFu32i_BFu32ll)
//============================================================================


struct  F_BFu32i_BFu33  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:33;
};
//SIG(1 F_BFu32i_BFu33) C1{ Fi Fi:32 FL:33}



static void Test_F_BFu32i_BFu33()
{
  {
    init_simple_test("F_BFu32i_BFu33");
    static STRUCT_IF_C F_BFu32i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "F_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "F_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu33, F_BFu32i_BFu33)
//============================================================================


struct  F_BFu32i_BFu7c  {
  float v1;
  unsigned int v2:32;
  unsigned char v3:7;
};
//SIG(1 F_BFu32i_BFu7c) C1{ Fi Fi:32 Fc:7}



static void Test_F_BFu32i_BFu7c()
{
  {
    init_simple_test("F_BFu32i_BFu7c");
    static STRUCT_IF_C F_BFu32i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu7c, F_BFu32i_BFu7c)
//============================================================================


struct  F_BFu32i_BFu7i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:7;
};
//SIG(1 F_BFu32i_BFu7i) C1{ Fi Fi:32 Fi:7}



static void Test_F_BFu32i_BFu7i()
{
  {
    init_simple_test("F_BFu32i_BFu7i");
    static STRUCT_IF_C F_BFu32i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu7i, F_BFu32i_BFu7i)
//============================================================================


struct  F_BFu32i_BFu7ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:7;
};
//SIG(1 F_BFu32i_BFu7ll) C1{ Fi Fi:32 FL:7}



static void Test_F_BFu32i_BFu7ll()
{
  {
    init_simple_test("F_BFu32i_BFu7ll");
    static STRUCT_IF_C F_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu7ll, F_BFu32i_BFu7ll)
//============================================================================


struct  F_BFu32i_BFu7s  {
  float v1;
  unsigned int v2:32;
  unsigned short v3:7;
};
//SIG(1 F_BFu32i_BFu7s) C1{ Fi Fi:32 Fs:7}



static void Test_F_BFu32i_BFu7s()
{
  {
    init_simple_test("F_BFu32i_BFu7s");
    static STRUCT_IF_C F_BFu32i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu7s, F_BFu32i_BFu7s)
//============================================================================


struct  F_BFu32i_BFu8c  {
  float v1;
  unsigned int v2:32;
  unsigned char v3:8;
};
//SIG(1 F_BFu32i_BFu8c) C1{ Fi Fi:32 Fc:8}



static void Test_F_BFu32i_BFu8c()
{
  {
    init_simple_test("F_BFu32i_BFu8c");
    static STRUCT_IF_C F_BFu32i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu8c, F_BFu32i_BFu8c)
//============================================================================


struct  F_BFu32i_BFu8i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:8;
};
//SIG(1 F_BFu32i_BFu8i) C1{ Fi Fi:32 Fi:8}



static void Test_F_BFu32i_BFu8i()
{
  {
    init_simple_test("F_BFu32i_BFu8i");
    static STRUCT_IF_C F_BFu32i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu8i, F_BFu32i_BFu8i)
//============================================================================


struct  F_BFu32i_BFu8ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:8;
};
//SIG(1 F_BFu32i_BFu8ll) C1{ Fi Fi:32 FL:8}



static void Test_F_BFu32i_BFu8ll()
{
  {
    init_simple_test("F_BFu32i_BFu8ll");
    static STRUCT_IF_C F_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu8ll, F_BFu32i_BFu8ll)
//============================================================================


struct  F_BFu32i_BFu8s  {
  float v1;
  unsigned int v2:32;
  unsigned short v3:8;
};
//SIG(1 F_BFu32i_BFu8s) C1{ Fi Fi:32 Fs:8}



static void Test_F_BFu32i_BFu8s()
{
  {
    init_simple_test("F_BFu32i_BFu8s");
    static STRUCT_IF_C F_BFu32i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu8s, F_BFu32i_BFu8s)
//============================================================================


struct  F_BFu32i_BFu9i  {
  float v1;
  unsigned int v2:32;
  unsigned int v3:9;
};
//SIG(1 F_BFu32i_BFu9i) C1{ Fi Fi:32 Fi:9}



static void Test_F_BFu32i_BFu9i()
{
  {
    init_simple_test("F_BFu32i_BFu9i");
    static STRUCT_IF_C F_BFu32i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu9i, F_BFu32i_BFu9i)
//============================================================================


struct  F_BFu32i_BFu9ll  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3:9;
};
//SIG(1 F_BFu32i_BFu9ll) C1{ Fi Fi:32 FL:9}



static void Test_F_BFu32i_BFu9ll()
{
  {
    init_simple_test("F_BFu32i_BFu9ll");
    static STRUCT_IF_C F_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu9ll, F_BFu32i_BFu9ll)
//============================================================================


struct  F_BFu32i_BFu9s  {
  float v1;
  unsigned int v2:32;
  unsigned short v3:9;
};
//SIG(1 F_BFu32i_BFu9s) C1{ Fi Fi:32 Fs:9}



static void Test_F_BFu32i_BFu9s()
{
  {
    init_simple_test("F_BFu32i_BFu9s");
    static STRUCT_IF_C F_BFu32i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu9s, F_BFu32i_BFu9s)
//============================================================================


struct  F_BFu32i_C  {
  float v1;
  unsigned int v2:32;
  char v3;
};
//SIG(1 F_BFu32i_C) C1{ Fi Fi:32 Fc}



static void Test_F_BFu32i_C()
{
  {
    init_simple_test("F_BFu32i_C");
    static STRUCT_IF_C F_BFu32i_C lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_C)");
    check_field_offset(lv, v1, 0, "F_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_C");
    check_field_offset(lv, v3, 8, "F_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_C, F_BFu32i_C)
//============================================================================


struct  F_BFu32i_D  {
  float v1;
  unsigned int v2:32;
  double v3;
};
//SIG(1 F_BFu32i_D) C1{ Fi Fi:32 FL}



static void Test_F_BFu32i_D()
{
  {
    init_simple_test("F_BFu32i_D");
    static STRUCT_IF_C F_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_D)");
    check_field_offset(lv, v1, 0, "F_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_D");
    check_field_offset(lv, v3, 8, "F_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_D, F_BFu32i_D)
//============================================================================


struct  F_BFu32i_F  {
  float v1;
  unsigned int v2:32;
  float v3;
};
//SIG(1 F_BFu32i_F) C1{ Fi Fi:32 Fi}



static void Test_F_BFu32i_F()
{
  {
    init_simple_test("F_BFu32i_F");
    static STRUCT_IF_C F_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_F)");
    check_field_offset(lv, v1, 0, "F_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_F");
    check_field_offset(lv, v3, 8, "F_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_F, F_BFu32i_F)
//============================================================================


struct  F_BFu32i_I  {
  float v1;
  unsigned int v2:32;
  int v3;
};
//SIG(1 F_BFu32i_I) C1{ Fi Fi:32 Fi}



static void Test_F_BFu32i_I()
{
  {
    init_simple_test("F_BFu32i_I");
    static STRUCT_IF_C F_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_I)");
    check_field_offset(lv, v1, 0, "F_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_I");
    check_field_offset(lv, v3, 8, "F_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_I, F_BFu32i_I)
//============================================================================


struct  F_BFu32i_Ip  {
  float v1;
  unsigned int v2:32;
  int *v3;
};
//SIG(1 F_BFu32i_Ip) C1{ Fi Fi:32 Fp}



static void Test_F_BFu32i_Ip()
{
  {
    init_simple_test("F_BFu32i_Ip");
    static STRUCT_IF_C F_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "F_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Ip, F_BFu32i_Ip)
//============================================================================


struct  F_BFu32i_L  {
  float v1;
  unsigned int v2:32;
  __tsi64 v3;
};
//SIG(1 F_BFu32i_L) C1{ Fi Fi:32 FL}



static void Test_F_BFu32i_L()
{
  {
    init_simple_test("F_BFu32i_L");
    static STRUCT_IF_C F_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_L)");
    check_field_offset(lv, v1, 0, "F_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_L");
    check_field_offset(lv, v3, 8, "F_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_L, F_BFu32i_L)
//============================================================================


struct  F_BFu32i_S  {
  float v1;
  unsigned int v2:32;
  short v3;
};
//SIG(1 F_BFu32i_S) C1{ Fi Fi:32 Fs}



static void Test_F_BFu32i_S()
{
  {
    init_simple_test("F_BFu32i_S");
    static STRUCT_IF_C F_BFu32i_S lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_S)");
    check_field_offset(lv, v1, 0, "F_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_S");
    check_field_offset(lv, v3, 8, "F_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_S, F_BFu32i_S)
//============================================================================


struct  F_BFu32i_Uc  {
  float v1;
  unsigned int v2:32;
  unsigned char v3;
};
//SIG(1 F_BFu32i_Uc) C1{ Fi Fi:32 Fc}



static void Test_F_BFu32i_Uc()
{
  {
    init_simple_test("F_BFu32i_Uc");
    static STRUCT_IF_C F_BFu32i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "F_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Uc, F_BFu32i_Uc)
//============================================================================


struct  F_BFu32i_Ui  {
  float v1;
  unsigned int v2:32;
  unsigned int v3;
};
//SIG(1 F_BFu32i_Ui) C1{ Fi Fi:32 Fi}



static void Test_F_BFu32i_Ui()
{
  {
    init_simple_test("F_BFu32i_Ui");
    static STRUCT_IF_C F_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "F_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Ui, F_BFu32i_Ui)
//============================================================================


struct  F_BFu32i_Ul  {
  float v1;
  unsigned int v2:32;
  __tsu64 v3;
};
//SIG(1 F_BFu32i_Ul) C1{ Fi Fi:32 FL}



static void Test_F_BFu32i_Ul()
{
  {
    init_simple_test("F_BFu32i_Ul");
    static STRUCT_IF_C F_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "F_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Ul, F_BFu32i_Ul)
//============================================================================


struct  F_BFu32i_Us  {
  float v1;
  unsigned int v2:32;
  unsigned short v3;
};
//SIG(1 F_BFu32i_Us) C1{ Fi Fi:32 Fs}



static void Test_F_BFu32i_Us()
{
  {
    init_simple_test("F_BFu32i_Us");
    static STRUCT_IF_C F_BFu32i_Us lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Us");
    check_field_offset(lv, v3, 8, "F_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Us, F_BFu32i_Us)
//============================================================================


struct  F_BFu32i_Vp  {
  float v1;
  unsigned int v2:32;
  void *v3;
};
//SIG(1 F_BFu32i_Vp) C1{ Fi Fi:32 Fp}



static void Test_F_BFu32i_Vp()
{
  {
    init_simple_test("F_BFu32i_Vp");
    static STRUCT_IF_C F_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "F_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Vp, F_BFu32i_Vp)
//============================================================================


struct  F_BFu32ll  {
  float v1;
  __tsu64 v2:32;
};
//SIG(1 F_BFu32ll) C1{ Fi FL:32}



static void Test_F_BFu32ll()
{
  {
    init_simple_test("F_BFu32ll");
    static STRUCT_IF_C F_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll, F_BFu32ll)
//============================================================================


struct  F_BFu32ll_BFu15i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:15;
};
//SIG(1 F_BFu32ll_BFu15i) C1{ Fi FL:32 Fi:15}



static void Test_F_BFu32ll_BFu15i()
{
  {
    init_simple_test("F_BFu32ll_BFu15i");
    static STRUCT_IF_C F_BFu32ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu15i, F_BFu32ll_BFu15i)
//============================================================================


struct  F_BFu32ll_BFu15ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:15;
};
//SIG(1 F_BFu32ll_BFu15ll) C1{ Fi FL:32 FL:15}



static void Test_F_BFu32ll_BFu15ll()
{
  {
    init_simple_test("F_BFu32ll_BFu15ll");
    static STRUCT_IF_C F_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu15ll, F_BFu32ll_BFu15ll)
//============================================================================


struct  F_BFu32ll_BFu15s  {
  float v1;
  __tsu64 v2:32;
  unsigned short v3:15;
};
//SIG(1 F_BFu32ll_BFu15s) C1{ Fi FL:32 Fs:15}



static void Test_F_BFu32ll_BFu15s()
{
  {
    init_simple_test("F_BFu32ll_BFu15s");
    static STRUCT_IF_C F_BFu32ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu15s, F_BFu32ll_BFu15s)
//============================================================================


struct  F_BFu32ll_BFu16i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:16;
};
//SIG(1 F_BFu32ll_BFu16i) C1{ Fi FL:32 Fi:16}



static void Test_F_BFu32ll_BFu16i()
{
  {
    init_simple_test("F_BFu32ll_BFu16i");
    static STRUCT_IF_C F_BFu32ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu16i, F_BFu32ll_BFu16i)
//============================================================================


struct  F_BFu32ll_BFu16ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:16;
};
//SIG(1 F_BFu32ll_BFu16ll) C1{ Fi FL:32 FL:16}



static void Test_F_BFu32ll_BFu16ll()
{
  {
    init_simple_test("F_BFu32ll_BFu16ll");
    static STRUCT_IF_C F_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu16ll, F_BFu32ll_BFu16ll)
//============================================================================


struct  F_BFu32ll_BFu16s  {
  float v1;
  __tsu64 v2:32;
  unsigned short v3:16;
};
//SIG(1 F_BFu32ll_BFu16s) C1{ Fi FL:32 Fs:16}



static void Test_F_BFu32ll_BFu16s()
{
  {
    init_simple_test("F_BFu32ll_BFu16s");
    static STRUCT_IF_C F_BFu32ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu16s, F_BFu32ll_BFu16s)
//============================================================================


struct  F_BFu32ll_BFu17i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:17;
};
//SIG(1 F_BFu32ll_BFu17i) C1{ Fi FL:32 Fi:17}



static void Test_F_BFu32ll_BFu17i()
{
  {
    init_simple_test("F_BFu32ll_BFu17i");
    static STRUCT_IF_C F_BFu32ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu17i, F_BFu32ll_BFu17i)
//============================================================================


struct  F_BFu32ll_BFu17ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:17;
};
//SIG(1 F_BFu32ll_BFu17ll) C1{ Fi FL:32 FL:17}



static void Test_F_BFu32ll_BFu17ll()
{
  {
    init_simple_test("F_BFu32ll_BFu17ll");
    static STRUCT_IF_C F_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu17ll, F_BFu32ll_BFu17ll)
//============================================================================


struct  F_BFu32ll_BFu1c  {
  float v1;
  __tsu64 v2:32;
  unsigned char v3:1;
};
//SIG(1 F_BFu32ll_BFu1c) C1{ Fi FL:32 Fc:1}



static void Test_F_BFu32ll_BFu1c()
{
  {
    init_simple_test("F_BFu32ll_BFu1c");
    static STRUCT_IF_C F_BFu32ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu1c, F_BFu32ll_BFu1c)
//============================================================================


struct  F_BFu32ll_BFu1i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:1;
};
//SIG(1 F_BFu32ll_BFu1i) C1{ Fi FL:32 Fi:1}



static void Test_F_BFu32ll_BFu1i()
{
  {
    init_simple_test("F_BFu32ll_BFu1i");
    static STRUCT_IF_C F_BFu32ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu1i, F_BFu32ll_BFu1i)
//============================================================================


struct  F_BFu32ll_BFu1ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:1;
};
//SIG(1 F_BFu32ll_BFu1ll) C1{ Fi FL:32 FL:1}



static void Test_F_BFu32ll_BFu1ll()
{
  {
    init_simple_test("F_BFu32ll_BFu1ll");
    static STRUCT_IF_C F_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu1ll, F_BFu32ll_BFu1ll)
//============================================================================


struct  F_BFu32ll_BFu1s  {
  float v1;
  __tsu64 v2:32;
  unsigned short v3:1;
};
//SIG(1 F_BFu32ll_BFu1s) C1{ Fi FL:32 Fs:1}



static void Test_F_BFu32ll_BFu1s()
{
  {
    init_simple_test("F_BFu32ll_BFu1s");
    static STRUCT_IF_C F_BFu32ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu1s, F_BFu32ll_BFu1s)
//============================================================================


struct  F_BFu32ll_BFu31i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:31;
};
//SIG(1 F_BFu32ll_BFu31i) C1{ Fi FL:32 Fi:31}



static void Test_F_BFu32ll_BFu31i()
{
  {
    init_simple_test("F_BFu32ll_BFu31i");
    static STRUCT_IF_C F_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu31i, F_BFu32ll_BFu31i)
//============================================================================


struct  F_BFu32ll_BFu31ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:31;
};
//SIG(1 F_BFu32ll_BFu31ll) C1{ Fi FL:32 FL:31}



static void Test_F_BFu32ll_BFu31ll()
{
  {
    init_simple_test("F_BFu32ll_BFu31ll");
    static STRUCT_IF_C F_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu31ll, F_BFu32ll_BFu31ll)
//============================================================================


struct  F_BFu32ll_BFu32i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:32;
};
//SIG(1 F_BFu32ll_BFu32i) C1{ Fi FL:32 Fi:32}



static void Test_F_BFu32ll_BFu32i()
{
  {
    init_simple_test("F_BFu32ll_BFu32i");
    static STRUCT_IF_C F_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu32i, F_BFu32ll_BFu32i)
//============================================================================


struct  F_BFu32ll_BFu32ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:32;
};
//SIG(1 F_BFu32ll_BFu32ll) C1{ Fi FL:32 FL:32}



static void Test_F_BFu32ll_BFu32ll()
{
  {
    init_simple_test("F_BFu32ll_BFu32ll");
    static STRUCT_IF_C F_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu32ll, F_BFu32ll_BFu32ll)
//============================================================================


struct  F_BFu32ll_BFu33  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:33;
};
//SIG(1 F_BFu32ll_BFu33) C1{ Fi FL:32 FL:33}



static void Test_F_BFu32ll_BFu33()
{
  {
    init_simple_test("F_BFu32ll_BFu33");
    static STRUCT_IF_C F_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "F_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "F_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu33, F_BFu32ll_BFu33)
//============================================================================


struct  F_BFu32ll_BFu7c  {
  float v1;
  __tsu64 v2:32;
  unsigned char v3:7;
};
//SIG(1 F_BFu32ll_BFu7c) C1{ Fi FL:32 Fc:7}



static void Test_F_BFu32ll_BFu7c()
{
  {
    init_simple_test("F_BFu32ll_BFu7c");
    static STRUCT_IF_C F_BFu32ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu7c, F_BFu32ll_BFu7c)
//============================================================================


struct  F_BFu32ll_BFu7i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:7;
};
//SIG(1 F_BFu32ll_BFu7i) C1{ Fi FL:32 Fi:7}



static void Test_F_BFu32ll_BFu7i()
{
  {
    init_simple_test("F_BFu32ll_BFu7i");
    static STRUCT_IF_C F_BFu32ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu7i, F_BFu32ll_BFu7i)
//============================================================================


struct  F_BFu32ll_BFu7ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:7;
};
//SIG(1 F_BFu32ll_BFu7ll) C1{ Fi FL:32 FL:7}



static void Test_F_BFu32ll_BFu7ll()
{
  {
    init_simple_test("F_BFu32ll_BFu7ll");
    static STRUCT_IF_C F_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu7ll, F_BFu32ll_BFu7ll)
//============================================================================


struct  F_BFu32ll_BFu7s  {
  float v1;
  __tsu64 v2:32;
  unsigned short v3:7;
};
//SIG(1 F_BFu32ll_BFu7s) C1{ Fi FL:32 Fs:7}



static void Test_F_BFu32ll_BFu7s()
{
  {
    init_simple_test("F_BFu32ll_BFu7s");
    static STRUCT_IF_C F_BFu32ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu7s, F_BFu32ll_BFu7s)
//============================================================================


struct  F_BFu32ll_BFu8c  {
  float v1;
  __tsu64 v2:32;
  unsigned char v3:8;
};
//SIG(1 F_BFu32ll_BFu8c) C1{ Fi FL:32 Fc:8}



static void Test_F_BFu32ll_BFu8c()
{
  {
    init_simple_test("F_BFu32ll_BFu8c");
    static STRUCT_IF_C F_BFu32ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu8c, F_BFu32ll_BFu8c)
//============================================================================


struct  F_BFu32ll_BFu8i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:8;
};
//SIG(1 F_BFu32ll_BFu8i) C1{ Fi FL:32 Fi:8}



static void Test_F_BFu32ll_BFu8i()
{
  {
    init_simple_test("F_BFu32ll_BFu8i");
    static STRUCT_IF_C F_BFu32ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu8i, F_BFu32ll_BFu8i)
//============================================================================


struct  F_BFu32ll_BFu8ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:8;
};
//SIG(1 F_BFu32ll_BFu8ll) C1{ Fi FL:32 FL:8}



static void Test_F_BFu32ll_BFu8ll()
{
  {
    init_simple_test("F_BFu32ll_BFu8ll");
    static STRUCT_IF_C F_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu8ll, F_BFu32ll_BFu8ll)
//============================================================================


struct  F_BFu32ll_BFu8s  {
  float v1;
  __tsu64 v2:32;
  unsigned short v3:8;
};
//SIG(1 F_BFu32ll_BFu8s) C1{ Fi FL:32 Fs:8}



static void Test_F_BFu32ll_BFu8s()
{
  {
    init_simple_test("F_BFu32ll_BFu8s");
    static STRUCT_IF_C F_BFu32ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu8s, F_BFu32ll_BFu8s)
//============================================================================


struct  F_BFu32ll_BFu9i  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3:9;
};
//SIG(1 F_BFu32ll_BFu9i) C1{ Fi FL:32 Fi:9}



static void Test_F_BFu32ll_BFu9i()
{
  {
    init_simple_test("F_BFu32ll_BFu9i");
    static STRUCT_IF_C F_BFu32ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu9i, F_BFu32ll_BFu9i)
//============================================================================


struct  F_BFu32ll_BFu9ll  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3:9;
};
//SIG(1 F_BFu32ll_BFu9ll) C1{ Fi FL:32 FL:9}



static void Test_F_BFu32ll_BFu9ll()
{
  {
    init_simple_test("F_BFu32ll_BFu9ll");
    static STRUCT_IF_C F_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu9ll, F_BFu32ll_BFu9ll)
//============================================================================


struct  F_BFu32ll_BFu9s  {
  float v1;
  __tsu64 v2:32;
  unsigned short v3:9;
};
//SIG(1 F_BFu32ll_BFu9s) C1{ Fi FL:32 Fs:9}



static void Test_F_BFu32ll_BFu9s()
{
  {
    init_simple_test("F_BFu32ll_BFu9s");
    static STRUCT_IF_C F_BFu32ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu9s, F_BFu32ll_BFu9s)
//============================================================================


struct  F_BFu32ll_C  {
  float v1;
  __tsu64 v2:32;
  char v3;
};
//SIG(1 F_BFu32ll_C) C1{ Fi FL:32 Fc}



static void Test_F_BFu32ll_C()
{
  {
    init_simple_test("F_BFu32ll_C");
    static STRUCT_IF_C F_BFu32ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_C");
    check_field_offset(lv, v3, 8, "F_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_C, F_BFu32ll_C)
//============================================================================


struct  F_BFu32ll_D  {
  float v1;
  __tsu64 v2:32;
  double v3;
};
//SIG(1 F_BFu32ll_D) C1{ Fi FL:32 FL}



static void Test_F_BFu32ll_D()
{
  {
    init_simple_test("F_BFu32ll_D");
    static STRUCT_IF_C F_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_D");
    check_field_offset(lv, v3, 8, "F_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_D, F_BFu32ll_D)
//============================================================================


struct  F_BFu32ll_F  {
  float v1;
  __tsu64 v2:32;
  float v3;
};
//SIG(1 F_BFu32ll_F) C1{ Fi FL:32 Fi}



static void Test_F_BFu32ll_F()
{
  {
    init_simple_test("F_BFu32ll_F");
    static STRUCT_IF_C F_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_F");
    check_field_offset(lv, v3, 8, "F_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_F, F_BFu32ll_F)
//============================================================================


struct  F_BFu32ll_I  {
  float v1;
  __tsu64 v2:32;
  int v3;
};
//SIG(1 F_BFu32ll_I) C1{ Fi FL:32 Fi}



static void Test_F_BFu32ll_I()
{
  {
    init_simple_test("F_BFu32ll_I");
    static STRUCT_IF_C F_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_I");
    check_field_offset(lv, v3, 8, "F_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_I, F_BFu32ll_I)
//============================================================================


struct  F_BFu32ll_Ip  {
  float v1;
  __tsu64 v2:32;
  int *v3;
};
//SIG(1 F_BFu32ll_Ip) C1{ Fi FL:32 Fp}



static void Test_F_BFu32ll_Ip()
{
  {
    init_simple_test("F_BFu32ll_Ip");
    static STRUCT_IF_C F_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Ip, F_BFu32ll_Ip)
//============================================================================


struct  F_BFu32ll_L  {
  float v1;
  __tsu64 v2:32;
  __tsi64 v3;
};
//SIG(1 F_BFu32ll_L) C1{ Fi FL:32 FL}



static void Test_F_BFu32ll_L()
{
  {
    init_simple_test("F_BFu32ll_L");
    static STRUCT_IF_C F_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_L");
    check_field_offset(lv, v3, 8, "F_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_L, F_BFu32ll_L)
//============================================================================


struct  F_BFu32ll_S  {
  float v1;
  __tsu64 v2:32;
  short v3;
};
//SIG(1 F_BFu32ll_S) C1{ Fi FL:32 Fs}



static void Test_F_BFu32ll_S()
{
  {
    init_simple_test("F_BFu32ll_S");
    static STRUCT_IF_C F_BFu32ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_S");
    check_field_offset(lv, v3, 8, "F_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_S, F_BFu32ll_S)
//============================================================================


struct  F_BFu32ll_Uc  {
  float v1;
  __tsu64 v2:32;
  unsigned char v3;
};
//SIG(1 F_BFu32ll_Uc) C1{ Fi FL:32 Fc}



static void Test_F_BFu32ll_Uc()
{
  {
    init_simple_test("F_BFu32ll_Uc");
    static STRUCT_IF_C F_BFu32ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Uc");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Uc, F_BFu32ll_Uc)
//============================================================================


struct  F_BFu32ll_Ui  {
  float v1;
  __tsu64 v2:32;
  unsigned int v3;
};
//SIG(1 F_BFu32ll_Ui) C1{ Fi FL:32 Fi}



static void Test_F_BFu32ll_Ui()
{
  {
    init_simple_test("F_BFu32ll_Ui");
    static STRUCT_IF_C F_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Ui, F_BFu32ll_Ui)
//============================================================================


struct  F_BFu32ll_Ul  {
  float v1;
  __tsu64 v2:32;
  __tsu64 v3;
};
//SIG(1 F_BFu32ll_Ul) C1{ Fi FL:32 FL}



static void Test_F_BFu32ll_Ul()
{
  {
    init_simple_test("F_BFu32ll_Ul");
    static STRUCT_IF_C F_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Ul, F_BFu32ll_Ul)
//============================================================================


struct  F_BFu32ll_Us  {
  float v1;
  __tsu64 v2:32;
  unsigned short v3;
};
//SIG(1 F_BFu32ll_Us) C1{ Fi FL:32 Fs}



static void Test_F_BFu32ll_Us()
{
  {
    init_simple_test("F_BFu32ll_Us");
    static STRUCT_IF_C F_BFu32ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Us");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Us, F_BFu32ll_Us)
//============================================================================


struct  F_BFu32ll_Vp  {
  float v1;
  __tsu64 v2:32;
  void *v3;
};
//SIG(1 F_BFu32ll_Vp) C1{ Fi FL:32 Fp}



static void Test_F_BFu32ll_Vp()
{
  {
    init_simple_test("F_BFu32ll_Vp");
    static STRUCT_IF_C F_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Vp, F_BFu32ll_Vp)
//============================================================================


struct  F_BFu33  {
  float v1;
  __tsu64 v2:33;
};
//SIG(1 F_BFu33) C1{ Fi FL:33}



static void Test_F_BFu33()
{
  {
    init_simple_test("F_BFu33");
    static STRUCT_IF_C F_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33, F_BFu33)
//============================================================================


struct  F_BFu33_BFu15i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:15;
};
//SIG(1 F_BFu33_BFu15i) C1{ Fi FL:33 Fi:15}



static void Test_F_BFu33_BFu15i()
{
  {
    init_simple_test("F_BFu33_BFu15i");
    static STRUCT_IF_C F_BFu33_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "F_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "F_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu15i, F_BFu33_BFu15i)
//============================================================================


struct  F_BFu33_BFu15ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:15;
};
//SIG(1 F_BFu33_BFu15ll) C1{ Fi FL:33 FL:15}



static void Test_F_BFu33_BFu15ll()
{
  {
    init_simple_test("F_BFu33_BFu15ll");
    static STRUCT_IF_C F_BFu33_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "F_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "F_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu15ll, F_BFu33_BFu15ll)
//============================================================================


struct  F_BFu33_BFu15s  {
  float v1;
  __tsu64 v2:33;
  unsigned short v3:15;
};
//SIG(1 F_BFu33_BFu15s) C1{ Fi FL:33 Fs:15}



static void Test_F_BFu33_BFu15s()
{
  {
    init_simple_test("F_BFu33_BFu15s");
    static STRUCT_IF_C F_BFu33_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "F_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "F_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu15s, F_BFu33_BFu15s)
//============================================================================


struct  F_BFu33_BFu16i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:16;
};
//SIG(1 F_BFu33_BFu16i) C1{ Fi FL:33 Fi:16}



static void Test_F_BFu33_BFu16i()
{
  {
    init_simple_test("F_BFu33_BFu16i");
    static STRUCT_IF_C F_BFu33_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "F_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "F_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu16i, F_BFu33_BFu16i)
//============================================================================


struct  F_BFu33_BFu16ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:16;
};
//SIG(1 F_BFu33_BFu16ll) C1{ Fi FL:33 FL:16}



static void Test_F_BFu33_BFu16ll()
{
  {
    init_simple_test("F_BFu33_BFu16ll");
    static STRUCT_IF_C F_BFu33_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "F_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "F_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu16ll, F_BFu33_BFu16ll)
//============================================================================


struct  F_BFu33_BFu16s  {
  float v1;
  __tsu64 v2:33;
  unsigned short v3:16;
};
//SIG(1 F_BFu33_BFu16s) C1{ Fi FL:33 Fs:16}



static void Test_F_BFu33_BFu16s()
{
  {
    init_simple_test("F_BFu33_BFu16s");
    static STRUCT_IF_C F_BFu33_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(14,10), 0, 16, 1, "F_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(14,10), 0, 16, hide_ull(1LL<<15), "F_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu16s, F_BFu33_BFu16s)
//============================================================================


struct  F_BFu33_BFu17i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:17;
};
//SIG(1 F_BFu33_BFu17i) C1{ Fi FL:33 Fi:17}



static void Test_F_BFu33_BFu17i()
{
  {
    init_simple_test("F_BFu33_BFu17i");
    static STRUCT_IF_C F_BFu33_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "F_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "F_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu17i, F_BFu33_BFu17i)
//============================================================================


struct  F_BFu33_BFu17ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:17;
};
//SIG(1 F_BFu33_BFu17ll) C1{ Fi FL:33 FL:17}



static void Test_F_BFu33_BFu17ll()
{
  {
    init_simple_test("F_BFu33_BFu17ll");
    static STRUCT_IF_C F_BFu33_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "F_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "F_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu17ll, F_BFu33_BFu17ll)
//============================================================================


struct  F_BFu33_BFu1c  {
  float v1;
  __tsu64 v2:33;
  unsigned char v3:1;
};
//SIG(1 F_BFu33_BFu1c) C1{ Fi FL:33 Fc:1}



static void Test_F_BFu33_BFu1c()
{
  {
    init_simple_test("F_BFu33_BFu1c");
    static STRUCT_IF_C F_BFu33_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "F_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu1c, F_BFu33_BFu1c)
//============================================================================


struct  F_BFu33_BFu1i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:1;
};
//SIG(1 F_BFu33_BFu1i) C1{ Fi FL:33 Fi:1}



static void Test_F_BFu33_BFu1i()
{
  {
    init_simple_test("F_BFu33_BFu1i");
    static STRUCT_IF_C F_BFu33_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "F_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu1i, F_BFu33_BFu1i)
//============================================================================


struct  F_BFu33_BFu1ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:1;
};
//SIG(1 F_BFu33_BFu1ll) C1{ Fi FL:33 FL:1}



static void Test_F_BFu33_BFu1ll()
{
  {
    init_simple_test("F_BFu33_BFu1ll");
    static STRUCT_IF_C F_BFu33_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "F_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu1ll, F_BFu33_BFu1ll)
//============================================================================


struct  F_BFu33_BFu1s  {
  float v1;
  __tsu64 v2:33;
  unsigned short v3:1;
};
//SIG(1 F_BFu33_BFu1s) C1{ Fi FL:33 Fs:1}



static void Test_F_BFu33_BFu1s()
{
  {
    init_simple_test("F_BFu33_BFu1s");
    static STRUCT_IF_C F_BFu33_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "F_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu1s, F_BFu33_BFu1s)
//============================================================================


struct  F_BFu33_BFu31i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 F_BFu33_BFu31i) C1{ Fi FL:33 Fi:31}



static void Test_F_BFu33_BFu31i()
{
  {
    init_simple_test("F_BFu33_BFu31i");
    static STRUCT_IF_C F_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "F_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "F_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu31i, F_BFu33_BFu31i)
//============================================================================


struct  F_BFu33_BFu31ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 F_BFu33_BFu31ll) C1{ Fi FL:33 FL:31}



static void Test_F_BFu33_BFu31ll()
{
  {
    init_simple_test("F_BFu33_BFu31ll");
    static STRUCT_IF_C F_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "F_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "F_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu31ll, F_BFu33_BFu31ll)
//============================================================================


struct  F_BFu33_BFu32i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 F_BFu33_BFu32i) C1{ Fi FL:33 Fi:32}



static void Test_F_BFu33_BFu32i()
{
  {
    init_simple_test("F_BFu33_BFu32i");
    static STRUCT_IF_C F_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "F_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "F_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu32i, F_BFu33_BFu32i)
//============================================================================


struct  F_BFu33_BFu32ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 F_BFu33_BFu32ll) C1{ Fi FL:33 FL:32}



static void Test_F_BFu33_BFu32ll()
{
  {
    init_simple_test("F_BFu33_BFu32ll");
    static STRUCT_IF_C F_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 32, 1, "F_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 32, hide_ull(1LL<<31), "F_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu32ll, F_BFu33_BFu32ll)
//============================================================================


struct  F_BFu33_BFu33  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 F_BFu33_BFu33) C1{ Fi FL:33 FL:33}



static void Test_F_BFu33_BFu33()
{
  {
    init_simple_test("F_BFu33_BFu33");
    static STRUCT_IF_C F_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 33, 1, "F_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), ABISELECT(0,1), 33, hide_ull(1LL<<32), "F_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu33, F_BFu33_BFu33)
//============================================================================


struct  F_BFu33_BFu7c  {
  float v1;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 F_BFu33_BFu7c) C1{ Fi FL:33 Fc:7}



static void Test_F_BFu33_BFu7c()
{
  {
    init_simple_test("F_BFu33_BFu7c");
    static STRUCT_IF_C F_BFu33_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "F_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "F_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu7c, F_BFu33_BFu7c)
//============================================================================


struct  F_BFu33_BFu7i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 F_BFu33_BFu7i) C1{ Fi FL:33 Fi:7}



static void Test_F_BFu33_BFu7i()
{
  {
    init_simple_test("F_BFu33_BFu7i");
    static STRUCT_IF_C F_BFu33_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "F_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "F_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu7i, F_BFu33_BFu7i)
//============================================================================


struct  F_BFu33_BFu7ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 F_BFu33_BFu7ll) C1{ Fi FL:33 FL:7}



static void Test_F_BFu33_BFu7ll()
{
  {
    init_simple_test("F_BFu33_BFu7ll");
    static STRUCT_IF_C F_BFu33_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "F_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "F_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu7ll, F_BFu33_BFu7ll)
//============================================================================


struct  F_BFu33_BFu7s  {
  float v1;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 F_BFu33_BFu7s) C1{ Fi FL:33 Fs:7}



static void Test_F_BFu33_BFu7s()
{
  {
    init_simple_test("F_BFu33_BFu7s");
    static STRUCT_IF_C F_BFu33_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "F_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "F_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu7s, F_BFu33_BFu7s)
//============================================================================


struct  F_BFu33_BFu8c  {
  float v1;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 F_BFu33_BFu8c) C1{ Fi FL:33 Fc:8}



static void Test_F_BFu33_BFu8c()
{
  {
    init_simple_test("F_BFu33_BFu8c");
    static STRUCT_IF_C F_BFu33_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(13,9), 0, 8, 1, "F_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(13,9), 0, 8, hide_ull(1LL<<7), "F_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu8c, F_BFu33_BFu8c)
//============================================================================


struct  F_BFu33_BFu8i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 F_BFu33_BFu8i) C1{ Fi FL:33 Fi:8}



static void Test_F_BFu33_BFu8i()
{
  {
    init_simple_test("F_BFu33_BFu8i");
    static STRUCT_IF_C F_BFu33_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "F_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "F_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu8i, F_BFu33_BFu8i)
//============================================================================


struct  F_BFu33_BFu8ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 F_BFu33_BFu8ll) C1{ Fi FL:33 FL:8}



static void Test_F_BFu33_BFu8ll()
{
  {
    init_simple_test("F_BFu33_BFu8ll");
    static STRUCT_IF_C F_BFu33_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "F_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "F_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu8ll, F_BFu33_BFu8ll)
//============================================================================


struct  F_BFu33_BFu8s  {
  float v1;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 F_BFu33_BFu8s) C1{ Fi FL:33 Fs:8}



static void Test_F_BFu33_BFu8s()
{
  {
    init_simple_test("F_BFu33_BFu8s");
    static STRUCT_IF_C F_BFu33_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "F_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "F_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu8s, F_BFu33_BFu8s)
//============================================================================


struct  F_BFu33_BFu9i  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 F_BFu33_BFu9i) C1{ Fi FL:33 Fi:9}



static void Test_F_BFu33_BFu9i()
{
  {
    init_simple_test("F_BFu33_BFu9i");
    static STRUCT_IF_C F_BFu33_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "F_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "F_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu9i, F_BFu33_BFu9i)
//============================================================================


struct  F_BFu33_BFu9ll  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 F_BFu33_BFu9ll) C1{ Fi FL:33 FL:9}



static void Test_F_BFu33_BFu9ll()
{
  {
    init_simple_test("F_BFu33_BFu9ll");
    static STRUCT_IF_C F_BFu33_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "F_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "F_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu9ll, F_BFu33_BFu9ll)
//============================================================================


struct  F_BFu33_BFu9s  {
  float v1;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 F_BFu33_BFu9s) C1{ Fi FL:33 Fs:9}



static void Test_F_BFu33_BFu9s()
{
  {
    init_simple_test("F_BFu33_BFu9s");
    static STRUCT_IF_C F_BFu33_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "F_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "F_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu9s, F_BFu33_BFu9s)
//============================================================================


struct  F_BFu33_C  {
  float v1;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 F_BFu33_C) C1{ Fi FL:33 Fc}



static void Test_F_BFu33_C()
{
  {
    init_simple_test("F_BFu33_C");
    static STRUCT_IF_C F_BFu33_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_C)");
    check_field_offset(lv, v1, 0, "F_BFu33_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_C");
    check_field_offset(lv, v3, ABISELECT(13,9), "F_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_C, F_BFu33_C)
//============================================================================


struct  F_BFu33_D  {
  float v1;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 F_BFu33_D) C1{ Fi FL:33 FL}



static void Test_F_BFu33_D()
{
  {
    init_simple_test("F_BFu33_D");
    static STRUCT_IF_C F_BFu33_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_D)");
    check_field_offset(lv, v1, 0, "F_BFu33_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_D, F_BFu33_D)
//============================================================================


struct  F_BFu33_F  {
  float v1;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 F_BFu33_F) C1{ Fi FL:33 Fi}



static void Test_F_BFu33_F()
{
  {
    init_simple_test("F_BFu33_F");
    static STRUCT_IF_C F_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_F)");
    check_field_offset(lv, v1, 0, "F_BFu33_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_F");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_F, F_BFu33_F)
//============================================================================


struct  F_BFu33_I  {
  float v1;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 F_BFu33_I) C1{ Fi FL:33 Fi}



static void Test_F_BFu33_I()
{
  {
    init_simple_test("F_BFu33_I");
    static STRUCT_IF_C F_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_I)");
    check_field_offset(lv, v1, 0, "F_BFu33_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_I");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_I, F_BFu33_I)
//============================================================================


struct  F_BFu33_Ip  {
  float v1;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 F_BFu33_Ip) C1{ Fi FL:33 Fp}



static void Test_F_BFu33_Ip()
{
  {
    init_simple_test("F_BFu33_Ip");
    static STRUCT_IF_C F_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_Ip, F_BFu33_Ip)
//============================================================================


struct  F_BFu33_L  {
  float v1;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 F_BFu33_L) C1{ Fi FL:33 FL}



static void Test_F_BFu33_L()
{
  {
    init_simple_test("F_BFu33_L");
    static STRUCT_IF_C F_BFu33_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_L)");
    check_field_offset(lv, v1, 0, "F_BFu33_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_L, F_BFu33_L)
//============================================================================


struct  F_BFu33_S  {
  float v1;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 F_BFu33_S) C1{ Fi FL:33 Fs}



static void Test_F_BFu33_S()
{
  {
    init_simple_test("F_BFu33_S");
    static STRUCT_IF_C F_BFu33_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_S)");
    check_field_offset(lv, v1, 0, "F_BFu33_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_S");
    check_field_offset(lv, v3, ABISELECT(14,10), "F_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_S, F_BFu33_S)
//============================================================================


struct  F_BFu33_Uc  {
  float v1;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 F_BFu33_Uc) C1{ Fi FL:33 Fc}



static void Test_F_BFu33_Uc()
{
  {
    init_simple_test("F_BFu33_Uc");
    static STRUCT_IF_C F_BFu33_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_Uc");
    check_field_offset(lv, v3, ABISELECT(13,9), "F_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_Uc, F_BFu33_Uc)
//============================================================================


struct  F_BFu33_Ui  {
  float v1;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 F_BFu33_Ui) C1{ Fi FL:33 Fi}



static void Test_F_BFu33_Ui()
{
  {
    init_simple_test("F_BFu33_Ui");
    static STRUCT_IF_C F_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_Ui");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_Ui, F_BFu33_Ui)
//============================================================================


struct  F_BFu33_Ul  {
  float v1;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 F_BFu33_Ul) C1{ Fi FL:33 FL}



static void Test_F_BFu33_Ul()
{
  {
    init_simple_test("F_BFu33_Ul");
    static STRUCT_IF_C F_BFu33_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_Ul, F_BFu33_Ul)
//============================================================================


struct  F_BFu33_Us  {
  float v1;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 F_BFu33_Us) C1{ Fi FL:33 Fs}



static void Test_F_BFu33_Us()
{
  {
    init_simple_test("F_BFu33_Us");
    static STRUCT_IF_C F_BFu33_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_Us)");
    check_field_offset(lv, v1, 0, "F_BFu33_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_Us");
    check_field_offset(lv, v3, ABISELECT(14,10), "F_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_Us, F_BFu33_Us)
//============================================================================


struct  F_BFu33_Vp  {
  float v1;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 F_BFu33_Vp) C1{ Fi FL:33 Fp}



static void Test_F_BFu33_Vp()
{
  {
    init_simple_test("F_BFu33_Vp");
    static STRUCT_IF_C F_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "F_BFu33_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "F_BFu33_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_Vp, F_BFu33_Vp)
//============================================================================


struct  F_BFu7c  {
  float v1;
  unsigned char v2:7;
};
//SIG(1 F_BFu7c) C1{ Fi Fc:7}



static void Test_F_BFu7c()
{
  {
    init_simple_test("F_BFu7c");
    static STRUCT_IF_C F_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c, F_BFu7c)
//============================================================================


struct  F_BFu7c_BFu15i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 F_BFu7c_BFu15i) C1{ Fi Fc:7 Fi:15}



static void Test_F_BFu7c_BFu15i()
{
  {
    init_simple_test("F_BFu7c_BFu15i");
    static STRUCT_IF_C F_BFu7c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "F_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "F_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu15i, F_BFu7c_BFu15i)
//============================================================================


struct  F_BFu7c_BFu15ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 F_BFu7c_BFu15ll) C1{ Fi Fc:7 FL:15}



static void Test_F_BFu7c_BFu15ll()
{
  {
    init_simple_test("F_BFu7c_BFu15ll");
    static STRUCT_IF_C F_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "F_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "F_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu15ll, F_BFu7c_BFu15ll)
//============================================================================


struct  F_BFu7c_BFu15s  {
  float v1;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 F_BFu7c_BFu15s) C1{ Fi Fc:7 Fs:15}



static void Test_F_BFu7c_BFu15s()
{
  {
    init_simple_test("F_BFu7c_BFu15s");
    static STRUCT_IF_C F_BFu7c_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu15s, F_BFu7c_BFu15s)
//============================================================================


struct  F_BFu7c_BFu16i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 F_BFu7c_BFu16i) C1{ Fi Fc:7 Fi:16}



static void Test_F_BFu7c_BFu16i()
{
  {
    init_simple_test("F_BFu7c_BFu16i");
    static STRUCT_IF_C F_BFu7c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "F_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "F_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu16i, F_BFu7c_BFu16i)
//============================================================================


struct  F_BFu7c_BFu16ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 F_BFu7c_BFu16ll) C1{ Fi Fc:7 FL:16}



static void Test_F_BFu7c_BFu16ll()
{
  {
    init_simple_test("F_BFu7c_BFu16ll");
    static STRUCT_IF_C F_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "F_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "F_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu16ll, F_BFu7c_BFu16ll)
//============================================================================


struct  F_BFu7c_BFu16s  {
  float v1;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 F_BFu7c_BFu16s) C1{ Fi Fc:7 Fs:16}



static void Test_F_BFu7c_BFu16s()
{
  {
    init_simple_test("F_BFu7c_BFu16s");
    static STRUCT_IF_C F_BFu7c_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu16s, F_BFu7c_BFu16s)
//============================================================================


struct  F_BFu7c_BFu17i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 F_BFu7c_BFu17i) C1{ Fi Fc:7 Fi:17}



static void Test_F_BFu7c_BFu17i()
{
  {
    init_simple_test("F_BFu7c_BFu17i");
    static STRUCT_IF_C F_BFu7c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "F_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "F_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu17i, F_BFu7c_BFu17i)
//============================================================================


struct  F_BFu7c_BFu17ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 F_BFu7c_BFu17ll) C1{ Fi Fc:7 FL:17}



static void Test_F_BFu7c_BFu17ll()
{
  {
    init_simple_test("F_BFu7c_BFu17ll");
    static STRUCT_IF_C F_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "F_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "F_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu17ll, F_BFu7c_BFu17ll)
//============================================================================


struct  F_BFu7c_BFu1c  {
  float v1;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 F_BFu7c_BFu1c) C1{ Fi Fc:7 Fc:1}



static void Test_F_BFu7c_BFu1c()
{
  {
    init_simple_test("F_BFu7c_BFu1c");
    static STRUCT_IF_C F_BFu7c_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu1c, F_BFu7c_BFu1c)
//============================================================================


struct  F_BFu7c_BFu1i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 F_BFu7c_BFu1i) C1{ Fi Fc:7 Fi:1}



static void Test_F_BFu7c_BFu1i()
{
  {
    init_simple_test("F_BFu7c_BFu1i");
    static STRUCT_IF_C F_BFu7c_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu1i, F_BFu7c_BFu1i)
//============================================================================


struct  F_BFu7c_BFu1ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 F_BFu7c_BFu1ll) C1{ Fi Fc:7 FL:1}



static void Test_F_BFu7c_BFu1ll()
{
  {
    init_simple_test("F_BFu7c_BFu1ll");
    static STRUCT_IF_C F_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu1ll, F_BFu7c_BFu1ll)
//============================================================================


struct  F_BFu7c_BFu1s  {
  float v1;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 F_BFu7c_BFu1s) C1{ Fi Fc:7 Fs:1}



static void Test_F_BFu7c_BFu1s()
{
  {
    init_simple_test("F_BFu7c_BFu1s");
    static STRUCT_IF_C F_BFu7c_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu1s, F_BFu7c_BFu1s)
//============================================================================


struct  F_BFu7c_BFu31i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 F_BFu7c_BFu31i) C1{ Fi Fc:7 Fi:31}



static void Test_F_BFu7c_BFu31i()
{
  {
    init_simple_test("F_BFu7c_BFu31i");
    static STRUCT_IF_C F_BFu7c_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu31i, F_BFu7c_BFu31i)
//============================================================================


struct  F_BFu7c_BFu31ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 F_BFu7c_BFu31ll) C1{ Fi Fc:7 FL:31}



static void Test_F_BFu7c_BFu31ll()
{
  {
    init_simple_test("F_BFu7c_BFu31ll");
    static STRUCT_IF_C F_BFu7c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "F_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "F_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu31ll, F_BFu7c_BFu31ll)
//============================================================================


struct  F_BFu7c_BFu32i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 F_BFu7c_BFu32i) C1{ Fi Fc:7 Fi:32}



static void Test_F_BFu7c_BFu32i()
{
  {
    init_simple_test("F_BFu7c_BFu32i");
    static STRUCT_IF_C F_BFu7c_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu32i, F_BFu7c_BFu32i)
//============================================================================


struct  F_BFu7c_BFu32ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 F_BFu7c_BFu32ll) C1{ Fi Fc:7 FL:32}



static void Test_F_BFu7c_BFu32ll()
{
  {
    init_simple_test("F_BFu7c_BFu32ll");
    static STRUCT_IF_C F_BFu7c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "F_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "F_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu32ll, F_BFu7c_BFu32ll)
//============================================================================


struct  F_BFu7c_BFu33  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 F_BFu7c_BFu33) C1{ Fi Fc:7 FL:33}



static void Test_F_BFu7c_BFu33()
{
  {
    init_simple_test("F_BFu7c_BFu33");
    static STRUCT_IF_C F_BFu7c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "F_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "F_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu33, F_BFu7c_BFu33)
//============================================================================


struct  F_BFu7c_BFu7c  {
  float v1;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 F_BFu7c_BFu7c) C1{ Fi Fc:7 Fc:7}



static void Test_F_BFu7c_BFu7c()
{
  {
    init_simple_test("F_BFu7c_BFu7c");
    static STRUCT_IF_C F_BFu7c_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu7c, F_BFu7c_BFu7c)
//============================================================================


struct  F_BFu7c_BFu7i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 F_BFu7c_BFu7i) C1{ Fi Fc:7 Fi:7}



static void Test_F_BFu7c_BFu7i()
{
  {
    init_simple_test("F_BFu7c_BFu7i");
    static STRUCT_IF_C F_BFu7c_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu7i, F_BFu7c_BFu7i)
//============================================================================


struct  F_BFu7c_BFu7ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 F_BFu7c_BFu7ll) C1{ Fi Fc:7 FL:7}



static void Test_F_BFu7c_BFu7ll()
{
  {
    init_simple_test("F_BFu7c_BFu7ll");
    static STRUCT_IF_C F_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu7ll, F_BFu7c_BFu7ll)
//============================================================================


struct  F_BFu7c_BFu7s  {
  float v1;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 F_BFu7c_BFu7s) C1{ Fi Fc:7 Fs:7}



static void Test_F_BFu7c_BFu7s()
{
  {
    init_simple_test("F_BFu7c_BFu7s");
    static STRUCT_IF_C F_BFu7c_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu7s, F_BFu7c_BFu7s)
//============================================================================


struct  F_BFu7c_BFu8c  {
  float v1;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 F_BFu7c_BFu8c) C1{ Fi Fc:7 Fc:8}



static void Test_F_BFu7c_BFu8c()
{
  {
    init_simple_test("F_BFu7c_BFu8c");
    static STRUCT_IF_C F_BFu7c_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu8c, F_BFu7c_BFu8c)
//============================================================================


struct  F_BFu7c_BFu8i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 F_BFu7c_BFu8i) C1{ Fi Fc:7 Fi:8}



static void Test_F_BFu7c_BFu8i()
{
  {
    init_simple_test("F_BFu7c_BFu8i");
    static STRUCT_IF_C F_BFu7c_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu8i, F_BFu7c_BFu8i)
//============================================================================


struct  F_BFu7c_BFu8ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 F_BFu7c_BFu8ll) C1{ Fi Fc:7 FL:8}



static void Test_F_BFu7c_BFu8ll()
{
  {
    init_simple_test("F_BFu7c_BFu8ll");
    static STRUCT_IF_C F_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu8ll, F_BFu7c_BFu8ll)
//============================================================================


struct  F_BFu7c_BFu8s  {
  float v1;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 F_BFu7c_BFu8s) C1{ Fi Fc:7 Fs:8}



static void Test_F_BFu7c_BFu8s()
{
  {
    init_simple_test("F_BFu7c_BFu8s");
    static STRUCT_IF_C F_BFu7c_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu8s, F_BFu7c_BFu8s)
//============================================================================


struct  F_BFu7c_BFu9i  {
  float v1;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 F_BFu7c_BFu9i) C1{ Fi Fc:7 Fi:9}



static void Test_F_BFu7c_BFu9i()
{
  {
    init_simple_test("F_BFu7c_BFu9i");
    static STRUCT_IF_C F_BFu7c_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu9i, F_BFu7c_BFu9i)
//============================================================================


struct  F_BFu7c_BFu9ll  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 F_BFu7c_BFu9ll) C1{ Fi Fc:7 FL:9}



static void Test_F_BFu7c_BFu9ll()
{
  {
    init_simple_test("F_BFu7c_BFu9ll");
    static STRUCT_IF_C F_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu9ll, F_BFu7c_BFu9ll)
//============================================================================


struct  F_BFu7c_BFu9s  {
  float v1;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 F_BFu7c_BFu9s) C1{ Fi Fc:7 Fs:9}



static void Test_F_BFu7c_BFu9s()
{
  {
    init_simple_test("F_BFu7c_BFu9s");
    static STRUCT_IF_C F_BFu7c_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_BFu9s, F_BFu7c_BFu9s)
//============================================================================


struct  F_BFu7c_C  {
  float v1;
  unsigned char v2:7;
  char v3;
};
//SIG(1 F_BFu7c_C) C1{ Fi Fc:7 Fc}



static void Test_F_BFu7c_C()
{
  {
    init_simple_test("F_BFu7c_C");
    static STRUCT_IF_C F_BFu7c_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_C)");
    check_field_offset(lv, v1, 0, "F_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_C");
    check_field_offset(lv, v3, 5, "F_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_C, F_BFu7c_C)
//============================================================================


struct  F_BFu7c_D  {
  float v1;
  unsigned char v2:7;
  double v3;
};
//SIG(1 F_BFu7c_D) C1{ Fi Fc:7 FL}



static void Test_F_BFu7c_D()
{
  {
    init_simple_test("F_BFu7c_D");
    static STRUCT_IF_C F_BFu7c_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_D)");
    check_field_offset(lv, v1, 0, "F_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_D");
    check_field_offset(lv, v3, 8, "F_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_D, F_BFu7c_D)
//============================================================================


struct  F_BFu7c_F  {
  float v1;
  unsigned char v2:7;
  float v3;
};
//SIG(1 F_BFu7c_F) C1{ Fi Fc:7 Fi}



static void Test_F_BFu7c_F()
{
  {
    init_simple_test("F_BFu7c_F");
    static STRUCT_IF_C F_BFu7c_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_F)");
    check_field_offset(lv, v1, 0, "F_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_F");
    check_field_offset(lv, v3, 8, "F_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_F, F_BFu7c_F)
//============================================================================


struct  F_BFu7c_I  {
  float v1;
  unsigned char v2:7;
  int v3;
};
//SIG(1 F_BFu7c_I) C1{ Fi Fc:7 Fi}



static void Test_F_BFu7c_I()
{
  {
    init_simple_test("F_BFu7c_I");
    static STRUCT_IF_C F_BFu7c_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_I)");
    check_field_offset(lv, v1, 0, "F_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_I");
    check_field_offset(lv, v3, 8, "F_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_I, F_BFu7c_I)
//============================================================================


struct  F_BFu7c_Ip  {
  float v1;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 F_BFu7c_Ip) C1{ Fi Fc:7 Fp}



static void Test_F_BFu7c_Ip()
{
  {
    init_simple_test("F_BFu7c_Ip");
    static STRUCT_IF_C F_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_Ip");
    check_field_offset(lv, v3, 8, "F_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_Ip, F_BFu7c_Ip)
//============================================================================


struct  F_BFu7c_L  {
  float v1;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 F_BFu7c_L) C1{ Fi Fc:7 FL}



static void Test_F_BFu7c_L()
{
  {
    init_simple_test("F_BFu7c_L");
    static STRUCT_IF_C F_BFu7c_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_L)");
    check_field_offset(lv, v1, 0, "F_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_L");
    check_field_offset(lv, v3, 8, "F_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_L, F_BFu7c_L)
//============================================================================


struct  F_BFu7c_S  {
  float v1;
  unsigned char v2:7;
  short v3;
};
//SIG(1 F_BFu7c_S) C1{ Fi Fc:7 Fs}



static void Test_F_BFu7c_S()
{
  {
    init_simple_test("F_BFu7c_S");
    static STRUCT_IF_C F_BFu7c_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_S)");
    check_field_offset(lv, v1, 0, "F_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_S");
    check_field_offset(lv, v3, 6, "F_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_S, F_BFu7c_S)
//============================================================================


struct  F_BFu7c_Uc  {
  float v1;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 F_BFu7c_Uc) C1{ Fi Fc:7 Fc}



static void Test_F_BFu7c_Uc()
{
  {
    init_simple_test("F_BFu7c_Uc");
    static STRUCT_IF_C F_BFu7c_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_Uc");
    check_field_offset(lv, v3, 5, "F_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_Uc, F_BFu7c_Uc)
//============================================================================


struct  F_BFu7c_Ui  {
  float v1;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 F_BFu7c_Ui) C1{ Fi Fc:7 Fi}



static void Test_F_BFu7c_Ui()
{
  {
    init_simple_test("F_BFu7c_Ui");
    static STRUCT_IF_C F_BFu7c_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_Ui");
    check_field_offset(lv, v3, 8, "F_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_Ui, F_BFu7c_Ui)
//============================================================================


struct  F_BFu7c_Ul  {
  float v1;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 F_BFu7c_Ul) C1{ Fi Fc:7 FL}



static void Test_F_BFu7c_Ul()
{
  {
    init_simple_test("F_BFu7c_Ul");
    static STRUCT_IF_C F_BFu7c_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_Ul");
    check_field_offset(lv, v3, 8, "F_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_Ul, F_BFu7c_Ul)
//============================================================================


struct  F_BFu7c_Us  {
  float v1;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 F_BFu7c_Us) C1{ Fi Fc:7 Fs}



static void Test_F_BFu7c_Us()
{
  {
    init_simple_test("F_BFu7c_Us");
    static STRUCT_IF_C F_BFu7c_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "F_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_Us");
    check_field_offset(lv, v3, 6, "F_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_Us, F_BFu7c_Us)
//============================================================================


struct  F_BFu7c_Vp  {
  float v1;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 F_BFu7c_Vp) C1{ Fi Fc:7 Fp}



static void Test_F_BFu7c_Vp()
{
  {
    init_simple_test("F_BFu7c_Vp");
    static STRUCT_IF_C F_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7c_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7c_Vp");
    check_field_offset(lv, v3, 8, "F_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7c_Vp, F_BFu7c_Vp)
//============================================================================


struct  F_BFu7i  {
  float v1;
  unsigned int v2:7;
};
//SIG(1 F_BFu7i) C1{ Fi Fi:7}



static void Test_F_BFu7i()
{
  {
    init_simple_test("F_BFu7i");
    static STRUCT_IF_C F_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i, F_BFu7i)
//============================================================================


struct  F_BFu7i_BFu15i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 F_BFu7i_BFu15i) C1{ Fi Fi:7 Fi:15}



static void Test_F_BFu7i_BFu15i()
{
  {
    init_simple_test("F_BFu7i_BFu15i");
    static STRUCT_IF_C F_BFu7i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "F_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "F_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu15i, F_BFu7i_BFu15i)
//============================================================================


struct  F_BFu7i_BFu15ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 F_BFu7i_BFu15ll) C1{ Fi Fi:7 FL:15}



static void Test_F_BFu7i_BFu15ll()
{
  {
    init_simple_test("F_BFu7i_BFu15ll");
    static STRUCT_IF_C F_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "F_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "F_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu15ll, F_BFu7i_BFu15ll)
//============================================================================


struct  F_BFu7i_BFu15s  {
  float v1;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 F_BFu7i_BFu15s) C1{ Fi Fi:7 Fs:15}



static void Test_F_BFu7i_BFu15s()
{
  {
    init_simple_test("F_BFu7i_BFu15s");
    static STRUCT_IF_C F_BFu7i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu15s, F_BFu7i_BFu15s)
//============================================================================


struct  F_BFu7i_BFu16i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 F_BFu7i_BFu16i) C1{ Fi Fi:7 Fi:16}



static void Test_F_BFu7i_BFu16i()
{
  {
    init_simple_test("F_BFu7i_BFu16i");
    static STRUCT_IF_C F_BFu7i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "F_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "F_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu16i, F_BFu7i_BFu16i)
//============================================================================


struct  F_BFu7i_BFu16ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 F_BFu7i_BFu16ll) C1{ Fi Fi:7 FL:16}



static void Test_F_BFu7i_BFu16ll()
{
  {
    init_simple_test("F_BFu7i_BFu16ll");
    static STRUCT_IF_C F_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "F_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "F_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu16ll, F_BFu7i_BFu16ll)
//============================================================================


struct  F_BFu7i_BFu16s  {
  float v1;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 F_BFu7i_BFu16s) C1{ Fi Fi:7 Fs:16}



static void Test_F_BFu7i_BFu16s()
{
  {
    init_simple_test("F_BFu7i_BFu16s");
    static STRUCT_IF_C F_BFu7i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu16s, F_BFu7i_BFu16s)
//============================================================================


struct  F_BFu7i_BFu17i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 F_BFu7i_BFu17i) C1{ Fi Fi:7 Fi:17}



static void Test_F_BFu7i_BFu17i()
{
  {
    init_simple_test("F_BFu7i_BFu17i");
    static STRUCT_IF_C F_BFu7i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "F_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "F_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu17i, F_BFu7i_BFu17i)
//============================================================================


struct  F_BFu7i_BFu17ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 F_BFu7i_BFu17ll) C1{ Fi Fi:7 FL:17}



static void Test_F_BFu7i_BFu17ll()
{
  {
    init_simple_test("F_BFu7i_BFu17ll");
    static STRUCT_IF_C F_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "F_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "F_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu17ll, F_BFu7i_BFu17ll)
//============================================================================


struct  F_BFu7i_BFu1c  {
  float v1;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 F_BFu7i_BFu1c) C1{ Fi Fi:7 Fc:1}



static void Test_F_BFu7i_BFu1c()
{
  {
    init_simple_test("F_BFu7i_BFu1c");
    static STRUCT_IF_C F_BFu7i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu1c, F_BFu7i_BFu1c)
//============================================================================


struct  F_BFu7i_BFu1i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 F_BFu7i_BFu1i) C1{ Fi Fi:7 Fi:1}



static void Test_F_BFu7i_BFu1i()
{
  {
    init_simple_test("F_BFu7i_BFu1i");
    static STRUCT_IF_C F_BFu7i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu1i, F_BFu7i_BFu1i)
//============================================================================


struct  F_BFu7i_BFu1ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 F_BFu7i_BFu1ll) C1{ Fi Fi:7 FL:1}



static void Test_F_BFu7i_BFu1ll()
{
  {
    init_simple_test("F_BFu7i_BFu1ll");
    static STRUCT_IF_C F_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu1ll, F_BFu7i_BFu1ll)
//============================================================================


struct  F_BFu7i_BFu1s  {
  float v1;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 F_BFu7i_BFu1s) C1{ Fi Fi:7 Fs:1}



static void Test_F_BFu7i_BFu1s()
{
  {
    init_simple_test("F_BFu7i_BFu1s");
    static STRUCT_IF_C F_BFu7i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu1s, F_BFu7i_BFu1s)
//============================================================================


struct  F_BFu7i_BFu31i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 F_BFu7i_BFu31i) C1{ Fi Fi:7 Fi:31}



static void Test_F_BFu7i_BFu31i()
{
  {
    init_simple_test("F_BFu7i_BFu31i");
    static STRUCT_IF_C F_BFu7i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu31i, F_BFu7i_BFu31i)
//============================================================================


struct  F_BFu7i_BFu31ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 F_BFu7i_BFu31ll) C1{ Fi Fi:7 FL:31}



static void Test_F_BFu7i_BFu31ll()
{
  {
    init_simple_test("F_BFu7i_BFu31ll");
    static STRUCT_IF_C F_BFu7i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "F_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "F_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu31ll, F_BFu7i_BFu31ll)
//============================================================================


struct  F_BFu7i_BFu32i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 F_BFu7i_BFu32i) C1{ Fi Fi:7 Fi:32}



static void Test_F_BFu7i_BFu32i()
{
  {
    init_simple_test("F_BFu7i_BFu32i");
    static STRUCT_IF_C F_BFu7i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu32i, F_BFu7i_BFu32i)
//============================================================================


struct  F_BFu7i_BFu32ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 F_BFu7i_BFu32ll) C1{ Fi Fi:7 FL:32}



static void Test_F_BFu7i_BFu32ll()
{
  {
    init_simple_test("F_BFu7i_BFu32ll");
    static STRUCT_IF_C F_BFu7i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "F_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "F_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu32ll, F_BFu7i_BFu32ll)
//============================================================================


struct  F_BFu7i_BFu33  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 F_BFu7i_BFu33) C1{ Fi Fi:7 FL:33}



static void Test_F_BFu7i_BFu33()
{
  {
    init_simple_test("F_BFu7i_BFu33");
    static STRUCT_IF_C F_BFu7i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "F_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "F_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu33, F_BFu7i_BFu33)
//============================================================================


struct  F_BFu7i_BFu7c  {
  float v1;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 F_BFu7i_BFu7c) C1{ Fi Fi:7 Fc:7}



static void Test_F_BFu7i_BFu7c()
{
  {
    init_simple_test("F_BFu7i_BFu7c");
    static STRUCT_IF_C F_BFu7i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu7c, F_BFu7i_BFu7c)
//============================================================================


struct  F_BFu7i_BFu7i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 F_BFu7i_BFu7i) C1{ Fi Fi:7 Fi:7}



static void Test_F_BFu7i_BFu7i()
{
  {
    init_simple_test("F_BFu7i_BFu7i");
    static STRUCT_IF_C F_BFu7i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu7i, F_BFu7i_BFu7i)
//============================================================================


struct  F_BFu7i_BFu7ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 F_BFu7i_BFu7ll) C1{ Fi Fi:7 FL:7}



static void Test_F_BFu7i_BFu7ll()
{
  {
    init_simple_test("F_BFu7i_BFu7ll");
    static STRUCT_IF_C F_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu7ll, F_BFu7i_BFu7ll)
//============================================================================


struct  F_BFu7i_BFu7s  {
  float v1;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 F_BFu7i_BFu7s) C1{ Fi Fi:7 Fs:7}



static void Test_F_BFu7i_BFu7s()
{
  {
    init_simple_test("F_BFu7i_BFu7s");
    static STRUCT_IF_C F_BFu7i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu7s, F_BFu7i_BFu7s)
//============================================================================


struct  F_BFu7i_BFu8c  {
  float v1;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 F_BFu7i_BFu8c) C1{ Fi Fi:7 Fc:8}



static void Test_F_BFu7i_BFu8c()
{
  {
    init_simple_test("F_BFu7i_BFu8c");
    static STRUCT_IF_C F_BFu7i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu8c, F_BFu7i_BFu8c)
//============================================================================


struct  F_BFu7i_BFu8i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 F_BFu7i_BFu8i) C1{ Fi Fi:7 Fi:8}



static void Test_F_BFu7i_BFu8i()
{
  {
    init_simple_test("F_BFu7i_BFu8i");
    static STRUCT_IF_C F_BFu7i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu8i, F_BFu7i_BFu8i)
//============================================================================


struct  F_BFu7i_BFu8ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 F_BFu7i_BFu8ll) C1{ Fi Fi:7 FL:8}



static void Test_F_BFu7i_BFu8ll()
{
  {
    init_simple_test("F_BFu7i_BFu8ll");
    static STRUCT_IF_C F_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu8ll, F_BFu7i_BFu8ll)
//============================================================================


struct  F_BFu7i_BFu8s  {
  float v1;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 F_BFu7i_BFu8s) C1{ Fi Fi:7 Fs:8}



static void Test_F_BFu7i_BFu8s()
{
  {
    init_simple_test("F_BFu7i_BFu8s");
    static STRUCT_IF_C F_BFu7i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu8s, F_BFu7i_BFu8s)
//============================================================================


struct  F_BFu7i_BFu9i  {
  float v1;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 F_BFu7i_BFu9i) C1{ Fi Fi:7 Fi:9}



static void Test_F_BFu7i_BFu9i()
{
  {
    init_simple_test("F_BFu7i_BFu9i");
    static STRUCT_IF_C F_BFu7i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu9i, F_BFu7i_BFu9i)
//============================================================================


struct  F_BFu7i_BFu9ll  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 F_BFu7i_BFu9ll) C1{ Fi Fi:7 FL:9}



static void Test_F_BFu7i_BFu9ll()
{
  {
    init_simple_test("F_BFu7i_BFu9ll");
    static STRUCT_IF_C F_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu9ll, F_BFu7i_BFu9ll)
//============================================================================


struct  F_BFu7i_BFu9s  {
  float v1;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 F_BFu7i_BFu9s) C1{ Fi Fi:7 Fs:9}



static void Test_F_BFu7i_BFu9s()
{
  {
    init_simple_test("F_BFu7i_BFu9s");
    static STRUCT_IF_C F_BFu7i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_BFu9s, F_BFu7i_BFu9s)
//============================================================================


struct  F_BFu7i_C  {
  float v1;
  unsigned int v2:7;
  char v3;
};
//SIG(1 F_BFu7i_C) C1{ Fi Fi:7 Fc}



static void Test_F_BFu7i_C()
{
  {
    init_simple_test("F_BFu7i_C");
    static STRUCT_IF_C F_BFu7i_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_C)");
    check_field_offset(lv, v1, 0, "F_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_C");
    check_field_offset(lv, v3, 5, "F_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_C, F_BFu7i_C)
//============================================================================


struct  F_BFu7i_D  {
  float v1;
  unsigned int v2:7;
  double v3;
};
//SIG(1 F_BFu7i_D) C1{ Fi Fi:7 FL}



static void Test_F_BFu7i_D()
{
  {
    init_simple_test("F_BFu7i_D");
    static STRUCT_IF_C F_BFu7i_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_D)");
    check_field_offset(lv, v1, 0, "F_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_D");
    check_field_offset(lv, v3, 8, "F_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_D, F_BFu7i_D)
//============================================================================


struct  F_BFu7i_F  {
  float v1;
  unsigned int v2:7;
  float v3;
};
//SIG(1 F_BFu7i_F) C1{ Fi Fi:7 Fi}



static void Test_F_BFu7i_F()
{
  {
    init_simple_test("F_BFu7i_F");
    static STRUCT_IF_C F_BFu7i_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_F)");
    check_field_offset(lv, v1, 0, "F_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_F");
    check_field_offset(lv, v3, 8, "F_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_F, F_BFu7i_F)
//============================================================================


struct  F_BFu7i_I  {
  float v1;
  unsigned int v2:7;
  int v3;
};
//SIG(1 F_BFu7i_I) C1{ Fi Fi:7 Fi}



static void Test_F_BFu7i_I()
{
  {
    init_simple_test("F_BFu7i_I");
    static STRUCT_IF_C F_BFu7i_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_I)");
    check_field_offset(lv, v1, 0, "F_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_I");
    check_field_offset(lv, v3, 8, "F_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_I, F_BFu7i_I)
//============================================================================


struct  F_BFu7i_Ip  {
  float v1;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 F_BFu7i_Ip) C1{ Fi Fi:7 Fp}



static void Test_F_BFu7i_Ip()
{
  {
    init_simple_test("F_BFu7i_Ip");
    static STRUCT_IF_C F_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_Ip");
    check_field_offset(lv, v3, 8, "F_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_Ip, F_BFu7i_Ip)
//============================================================================


struct  F_BFu7i_L  {
  float v1;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 F_BFu7i_L) C1{ Fi Fi:7 FL}



static void Test_F_BFu7i_L()
{
  {
    init_simple_test("F_BFu7i_L");
    static STRUCT_IF_C F_BFu7i_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_L)");
    check_field_offset(lv, v1, 0, "F_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_L");
    check_field_offset(lv, v3, 8, "F_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_L, F_BFu7i_L)
//============================================================================


struct  F_BFu7i_S  {
  float v1;
  unsigned int v2:7;
  short v3;
};
//SIG(1 F_BFu7i_S) C1{ Fi Fi:7 Fs}



static void Test_F_BFu7i_S()
{
  {
    init_simple_test("F_BFu7i_S");
    static STRUCT_IF_C F_BFu7i_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_S)");
    check_field_offset(lv, v1, 0, "F_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_S");
    check_field_offset(lv, v3, 6, "F_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_S, F_BFu7i_S)
//============================================================================


struct  F_BFu7i_Uc  {
  float v1;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 F_BFu7i_Uc) C1{ Fi Fi:7 Fc}



static void Test_F_BFu7i_Uc()
{
  {
    init_simple_test("F_BFu7i_Uc");
    static STRUCT_IF_C F_BFu7i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_Uc");
    check_field_offset(lv, v3, 5, "F_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_Uc, F_BFu7i_Uc)
//============================================================================


struct  F_BFu7i_Ui  {
  float v1;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 F_BFu7i_Ui) C1{ Fi Fi:7 Fi}



static void Test_F_BFu7i_Ui()
{
  {
    init_simple_test("F_BFu7i_Ui");
    static STRUCT_IF_C F_BFu7i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_Ui");
    check_field_offset(lv, v3, 8, "F_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_Ui, F_BFu7i_Ui)
//============================================================================


struct  F_BFu7i_Ul  {
  float v1;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 F_BFu7i_Ul) C1{ Fi Fi:7 FL}



static void Test_F_BFu7i_Ul()
{
  {
    init_simple_test("F_BFu7i_Ul");
    static STRUCT_IF_C F_BFu7i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_Ul");
    check_field_offset(lv, v3, 8, "F_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_Ul, F_BFu7i_Ul)
//============================================================================


struct  F_BFu7i_Us  {
  float v1;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 F_BFu7i_Us) C1{ Fi Fi:7 Fs}



static void Test_F_BFu7i_Us()
{
  {
    init_simple_test("F_BFu7i_Us");
    static STRUCT_IF_C F_BFu7i_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_Us");
    check_field_offset(lv, v3, 6, "F_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_Us, F_BFu7i_Us)
//============================================================================


struct  F_BFu7i_Vp  {
  float v1;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 F_BFu7i_Vp) C1{ Fi Fi:7 Fp}



static void Test_F_BFu7i_Vp()
{
  {
    init_simple_test("F_BFu7i_Vp");
    static STRUCT_IF_C F_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7i_Vp");
    check_field_offset(lv, v3, 8, "F_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7i_Vp, F_BFu7i_Vp)
//============================================================================


struct  F_BFu7ll  {
  float v1;
  __tsu64 v2:7;
};
//SIG(1 F_BFu7ll) C1{ Fi FL:7}



static void Test_F_BFu7ll()
{
  {
    init_simple_test("F_BFu7ll");
    static STRUCT_IF_C F_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll, F_BFu7ll)
//============================================================================


struct  F_BFu7ll_BFu15i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 F_BFu7ll_BFu15i) C1{ Fi FL:7 Fi:15}



static void Test_F_BFu7ll_BFu15i()
{
  {
    init_simple_test("F_BFu7ll_BFu15i");
    static STRUCT_IF_C F_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "F_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "F_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu15i, F_BFu7ll_BFu15i)
//============================================================================


struct  F_BFu7ll_BFu15ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 F_BFu7ll_BFu15ll) C1{ Fi FL:7 FL:15}



static void Test_F_BFu7ll_BFu15ll()
{
  {
    init_simple_test("F_BFu7ll_BFu15ll");
    static STRUCT_IF_C F_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "F_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "F_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu15ll, F_BFu7ll_BFu15ll)
//============================================================================


struct  F_BFu7ll_BFu15s  {
  float v1;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 F_BFu7ll_BFu15s) C1{ Fi FL:7 Fs:15}



static void Test_F_BFu7ll_BFu15s()
{
  {
    init_simple_test("F_BFu7ll_BFu15s");
    static STRUCT_IF_C F_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu15s, F_BFu7ll_BFu15s)
//============================================================================


struct  F_BFu7ll_BFu16i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 F_BFu7ll_BFu16i) C1{ Fi FL:7 Fi:16}



static void Test_F_BFu7ll_BFu16i()
{
  {
    init_simple_test("F_BFu7ll_BFu16i");
    static STRUCT_IF_C F_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "F_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "F_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu16i, F_BFu7ll_BFu16i)
//============================================================================


struct  F_BFu7ll_BFu16ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 F_BFu7ll_BFu16ll) C1{ Fi FL:7 FL:16}



static void Test_F_BFu7ll_BFu16ll()
{
  {
    init_simple_test("F_BFu7ll_BFu16ll");
    static STRUCT_IF_C F_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "F_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "F_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu16ll, F_BFu7ll_BFu16ll)
//============================================================================


struct  F_BFu7ll_BFu16s  {
  float v1;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 F_BFu7ll_BFu16s) C1{ Fi FL:7 Fs:16}



static void Test_F_BFu7ll_BFu16s()
{
  {
    init_simple_test("F_BFu7ll_BFu16s");
    static STRUCT_IF_C F_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu16s, F_BFu7ll_BFu16s)
//============================================================================


struct  F_BFu7ll_BFu17i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 F_BFu7ll_BFu17i) C1{ Fi FL:7 Fi:17}



static void Test_F_BFu7ll_BFu17i()
{
  {
    init_simple_test("F_BFu7ll_BFu17i");
    static STRUCT_IF_C F_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "F_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "F_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu17i, F_BFu7ll_BFu17i)
//============================================================================


struct  F_BFu7ll_BFu17ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 F_BFu7ll_BFu17ll) C1{ Fi FL:7 FL:17}



static void Test_F_BFu7ll_BFu17ll()
{
  {
    init_simple_test("F_BFu7ll_BFu17ll");
    static STRUCT_IF_C F_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "F_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "F_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu17ll, F_BFu7ll_BFu17ll)
//============================================================================


struct  F_BFu7ll_BFu1c  {
  float v1;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 F_BFu7ll_BFu1c) C1{ Fi FL:7 Fc:1}



static void Test_F_BFu7ll_BFu1c()
{
  {
    init_simple_test("F_BFu7ll_BFu1c");
    static STRUCT_IF_C F_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu1c, F_BFu7ll_BFu1c)
//============================================================================


struct  F_BFu7ll_BFu1i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 F_BFu7ll_BFu1i) C1{ Fi FL:7 Fi:1}



static void Test_F_BFu7ll_BFu1i()
{
  {
    init_simple_test("F_BFu7ll_BFu1i");
    static STRUCT_IF_C F_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu1i, F_BFu7ll_BFu1i)
//============================================================================


struct  F_BFu7ll_BFu1ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 F_BFu7ll_BFu1ll) C1{ Fi FL:7 FL:1}



static void Test_F_BFu7ll_BFu1ll()
{
  {
    init_simple_test("F_BFu7ll_BFu1ll");
    static STRUCT_IF_C F_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu1ll, F_BFu7ll_BFu1ll)
//============================================================================


struct  F_BFu7ll_BFu1s  {
  float v1;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 F_BFu7ll_BFu1s) C1{ Fi FL:7 Fs:1}



static void Test_F_BFu7ll_BFu1s()
{
  {
    init_simple_test("F_BFu7ll_BFu1s");
    static STRUCT_IF_C F_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu1s, F_BFu7ll_BFu1s)
//============================================================================


struct  F_BFu7ll_BFu31i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 F_BFu7ll_BFu31i) C1{ Fi FL:7 Fi:31}



static void Test_F_BFu7ll_BFu31i()
{
  {
    init_simple_test("F_BFu7ll_BFu31i");
    static STRUCT_IF_C F_BFu7ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu31i, F_BFu7ll_BFu31i)
//============================================================================


struct  F_BFu7ll_BFu31ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 F_BFu7ll_BFu31ll) C1{ Fi FL:7 FL:31}



static void Test_F_BFu7ll_BFu31ll()
{
  {
    init_simple_test("F_BFu7ll_BFu31ll");
    static STRUCT_IF_C F_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "F_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "F_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu31ll, F_BFu7ll_BFu31ll)
//============================================================================


struct  F_BFu7ll_BFu32i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 F_BFu7ll_BFu32i) C1{ Fi FL:7 Fi:32}



static void Test_F_BFu7ll_BFu32i()
{
  {
    init_simple_test("F_BFu7ll_BFu32i");
    static STRUCT_IF_C F_BFu7ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu32i, F_BFu7ll_BFu32i)
//============================================================================


struct  F_BFu7ll_BFu32ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 F_BFu7ll_BFu32ll) C1{ Fi FL:7 FL:32}



static void Test_F_BFu7ll_BFu32ll()
{
  {
    init_simple_test("F_BFu7ll_BFu32ll");
    static STRUCT_IF_C F_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "F_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "F_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu32ll, F_BFu7ll_BFu32ll)
//============================================================================


struct  F_BFu7ll_BFu33  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 F_BFu7ll_BFu33) C1{ Fi FL:7 FL:33}



static void Test_F_BFu7ll_BFu33()
{
  {
    init_simple_test("F_BFu7ll_BFu33");
    static STRUCT_IF_C F_BFu7ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "F_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "F_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu33, F_BFu7ll_BFu33)
//============================================================================


struct  F_BFu7ll_BFu7c  {
  float v1;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 F_BFu7ll_BFu7c) C1{ Fi FL:7 Fc:7}



static void Test_F_BFu7ll_BFu7c()
{
  {
    init_simple_test("F_BFu7ll_BFu7c");
    static STRUCT_IF_C F_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu7c, F_BFu7ll_BFu7c)
//============================================================================


struct  F_BFu7ll_BFu7i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 F_BFu7ll_BFu7i) C1{ Fi FL:7 Fi:7}



static void Test_F_BFu7ll_BFu7i()
{
  {
    init_simple_test("F_BFu7ll_BFu7i");
    static STRUCT_IF_C F_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu7i, F_BFu7ll_BFu7i)
//============================================================================


struct  F_BFu7ll_BFu7ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 F_BFu7ll_BFu7ll) C1{ Fi FL:7 FL:7}



static void Test_F_BFu7ll_BFu7ll()
{
  {
    init_simple_test("F_BFu7ll_BFu7ll");
    static STRUCT_IF_C F_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu7ll, F_BFu7ll_BFu7ll)
//============================================================================


struct  F_BFu7ll_BFu7s  {
  float v1;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 F_BFu7ll_BFu7s) C1{ Fi FL:7 Fs:7}



static void Test_F_BFu7ll_BFu7s()
{
  {
    init_simple_test("F_BFu7ll_BFu7s");
    static STRUCT_IF_C F_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu7s, F_BFu7ll_BFu7s)
//============================================================================


struct  F_BFu7ll_BFu8c  {
  float v1;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 F_BFu7ll_BFu8c) C1{ Fi FL:7 Fc:8}



static void Test_F_BFu7ll_BFu8c()
{
  {
    init_simple_test("F_BFu7ll_BFu8c");
    static STRUCT_IF_C F_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu8c, F_BFu7ll_BFu8c)
//============================================================================


struct  F_BFu7ll_BFu8i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 F_BFu7ll_BFu8i) C1{ Fi FL:7 Fi:8}



static void Test_F_BFu7ll_BFu8i()
{
  {
    init_simple_test("F_BFu7ll_BFu8i");
    static STRUCT_IF_C F_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu8i, F_BFu7ll_BFu8i)
//============================================================================


struct  F_BFu7ll_BFu8ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 F_BFu7ll_BFu8ll) C1{ Fi FL:7 FL:8}



static void Test_F_BFu7ll_BFu8ll()
{
  {
    init_simple_test("F_BFu7ll_BFu8ll");
    static STRUCT_IF_C F_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu8ll, F_BFu7ll_BFu8ll)
//============================================================================


struct  F_BFu7ll_BFu8s  {
  float v1;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 F_BFu7ll_BFu8s) C1{ Fi FL:7 Fs:8}



static void Test_F_BFu7ll_BFu8s()
{
  {
    init_simple_test("F_BFu7ll_BFu8s");
    static STRUCT_IF_C F_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu8s, F_BFu7ll_BFu8s)
//============================================================================


struct  F_BFu7ll_BFu9i  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 F_BFu7ll_BFu9i) C1{ Fi FL:7 Fi:9}



static void Test_F_BFu7ll_BFu9i()
{
  {
    init_simple_test("F_BFu7ll_BFu9i");
    static STRUCT_IF_C F_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu9i, F_BFu7ll_BFu9i)
//============================================================================


struct  F_BFu7ll_BFu9ll  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 F_BFu7ll_BFu9ll) C1{ Fi FL:7 FL:9}



static void Test_F_BFu7ll_BFu9ll()
{
  {
    init_simple_test("F_BFu7ll_BFu9ll");
    static STRUCT_IF_C F_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu9ll, F_BFu7ll_BFu9ll)
//============================================================================


struct  F_BFu7ll_BFu9s  {
  float v1;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 F_BFu7ll_BFu9s) C1{ Fi FL:7 Fs:9}



static void Test_F_BFu7ll_BFu9s()
{
  {
    init_simple_test("F_BFu7ll_BFu9s");
    static STRUCT_IF_C F_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_BFu9s, F_BFu7ll_BFu9s)
//============================================================================


struct  F_BFu7ll_C  {
  float v1;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 F_BFu7ll_C) C1{ Fi FL:7 Fc}



static void Test_F_BFu7ll_C()
{
  {
    init_simple_test("F_BFu7ll_C");
    static STRUCT_IF_C F_BFu7ll_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_C");
    check_field_offset(lv, v3, 5, "F_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_C, F_BFu7ll_C)
//============================================================================


struct  F_BFu7ll_D  {
  float v1;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 F_BFu7ll_D) C1{ Fi FL:7 FL}



static void Test_F_BFu7ll_D()
{
  {
    init_simple_test("F_BFu7ll_D");
    static STRUCT_IF_C F_BFu7ll_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_D");
    check_field_offset(lv, v3, 8, "F_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_D, F_BFu7ll_D)
//============================================================================


struct  F_BFu7ll_F  {
  float v1;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 F_BFu7ll_F) C1{ Fi FL:7 Fi}



static void Test_F_BFu7ll_F()
{
  {
    init_simple_test("F_BFu7ll_F");
    static STRUCT_IF_C F_BFu7ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_F");
    check_field_offset(lv, v3, 8, "F_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_F, F_BFu7ll_F)
//============================================================================


struct  F_BFu7ll_I  {
  float v1;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 F_BFu7ll_I) C1{ Fi FL:7 Fi}



static void Test_F_BFu7ll_I()
{
  {
    init_simple_test("F_BFu7ll_I");
    static STRUCT_IF_C F_BFu7ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_I");
    check_field_offset(lv, v3, 8, "F_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_I, F_BFu7ll_I)
//============================================================================


struct  F_BFu7ll_Ip  {
  float v1;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 F_BFu7ll_Ip) C1{ Fi FL:7 Fp}



static void Test_F_BFu7ll_Ip()
{
  {
    init_simple_test("F_BFu7ll_Ip");
    static STRUCT_IF_C F_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_Ip");
    check_field_offset(lv, v3, 8, "F_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_Ip, F_BFu7ll_Ip)
//============================================================================


struct  F_BFu7ll_L  {
  float v1;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 F_BFu7ll_L) C1{ Fi FL:7 FL}



static void Test_F_BFu7ll_L()
{
  {
    init_simple_test("F_BFu7ll_L");
    static STRUCT_IF_C F_BFu7ll_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_L");
    check_field_offset(lv, v3, 8, "F_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_L, F_BFu7ll_L)
//============================================================================


struct  F_BFu7ll_S  {
  float v1;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 F_BFu7ll_S) C1{ Fi FL:7 Fs}



static void Test_F_BFu7ll_S()
{
  {
    init_simple_test("F_BFu7ll_S");
    static STRUCT_IF_C F_BFu7ll_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_S");
    check_field_offset(lv, v3, 6, "F_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_S, F_BFu7ll_S)
//============================================================================


struct  F_BFu7ll_Uc  {
  float v1;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 F_BFu7ll_Uc) C1{ Fi FL:7 Fc}



static void Test_F_BFu7ll_Uc()
{
  {
    init_simple_test("F_BFu7ll_Uc");
    static STRUCT_IF_C F_BFu7ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_Uc");
    check_field_offset(lv, v3, 5, "F_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_Uc, F_BFu7ll_Uc)
//============================================================================


struct  F_BFu7ll_Ui  {
  float v1;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 F_BFu7ll_Ui) C1{ Fi FL:7 Fi}



static void Test_F_BFu7ll_Ui()
{
  {
    init_simple_test("F_BFu7ll_Ui");
    static STRUCT_IF_C F_BFu7ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_Ui");
    check_field_offset(lv, v3, 8, "F_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_Ui, F_BFu7ll_Ui)
//============================================================================


struct  F_BFu7ll_Ul  {
  float v1;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 F_BFu7ll_Ul) C1{ Fi FL:7 FL}



static void Test_F_BFu7ll_Ul()
{
  {
    init_simple_test("F_BFu7ll_Ul");
    static STRUCT_IF_C F_BFu7ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_Ul");
    check_field_offset(lv, v3, 8, "F_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_Ul, F_BFu7ll_Ul)
//============================================================================


struct  F_BFu7ll_Us  {
  float v1;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 F_BFu7ll_Us) C1{ Fi FL:7 Fs}



static void Test_F_BFu7ll_Us()
{
  {
    init_simple_test("F_BFu7ll_Us");
    static STRUCT_IF_C F_BFu7ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_Us");
    check_field_offset(lv, v3, 6, "F_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_Us, F_BFu7ll_Us)
//============================================================================


struct  F_BFu7ll_Vp  {
  float v1;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 F_BFu7ll_Vp) C1{ Fi FL:7 Fp}



static void Test_F_BFu7ll_Vp()
{
  {
    init_simple_test("F_BFu7ll_Vp");
    static STRUCT_IF_C F_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7ll_Vp");
    check_field_offset(lv, v3, 8, "F_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7ll_Vp, F_BFu7ll_Vp)
//============================================================================


struct  F_BFu7s  {
  float v1;
  unsigned short v2:7;
};
//SIG(1 F_BFu7s) C1{ Fi Fs:7}



static void Test_F_BFu7s()
{
  {
    init_simple_test("F_BFu7s");
    static STRUCT_IF_C F_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s, F_BFu7s)
//============================================================================


struct  F_BFu7s_BFu15i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 F_BFu7s_BFu15i) C1{ Fi Fs:7 Fi:15}



static void Test_F_BFu7s_BFu15i()
{
  {
    init_simple_test("F_BFu7s_BFu15i");
    static STRUCT_IF_C F_BFu7s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "F_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "F_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu15i, F_BFu7s_BFu15i)
//============================================================================


struct  F_BFu7s_BFu15ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 F_BFu7s_BFu15ll) C1{ Fi Fs:7 FL:15}



static void Test_F_BFu7s_BFu15ll()
{
  {
    init_simple_test("F_BFu7s_BFu15ll");
    static STRUCT_IF_C F_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "F_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "F_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu15ll, F_BFu7s_BFu15ll)
//============================================================================


struct  F_BFu7s_BFu15s  {
  float v1;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 F_BFu7s_BFu15s) C1{ Fi Fs:7 Fs:15}



static void Test_F_BFu7s_BFu15s()
{
  {
    init_simple_test("F_BFu7s_BFu15s");
    static STRUCT_IF_C F_BFu7s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu15s, F_BFu7s_BFu15s)
//============================================================================


struct  F_BFu7s_BFu16i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 F_BFu7s_BFu16i) C1{ Fi Fs:7 Fi:16}



static void Test_F_BFu7s_BFu16i()
{
  {
    init_simple_test("F_BFu7s_BFu16i");
    static STRUCT_IF_C F_BFu7s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "F_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "F_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu16i, F_BFu7s_BFu16i)
//============================================================================


struct  F_BFu7s_BFu16ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 F_BFu7s_BFu16ll) C1{ Fi Fs:7 FL:16}



static void Test_F_BFu7s_BFu16ll()
{
  {
    init_simple_test("F_BFu7s_BFu16ll");
    static STRUCT_IF_C F_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "F_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "F_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu16ll, F_BFu7s_BFu16ll)
//============================================================================


struct  F_BFu7s_BFu16s  {
  float v1;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 F_BFu7s_BFu16s) C1{ Fi Fs:7 Fs:16}



static void Test_F_BFu7s_BFu16s()
{
  {
    init_simple_test("F_BFu7s_BFu16s");
    static STRUCT_IF_C F_BFu7s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu16s, F_BFu7s_BFu16s)
//============================================================================


struct  F_BFu7s_BFu17i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 F_BFu7s_BFu17i) C1{ Fi Fs:7 Fi:17}



static void Test_F_BFu7s_BFu17i()
{
  {
    init_simple_test("F_BFu7s_BFu17i");
    static STRUCT_IF_C F_BFu7s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "F_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "F_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu17i, F_BFu7s_BFu17i)
//============================================================================


struct  F_BFu7s_BFu17ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 F_BFu7s_BFu17ll) C1{ Fi Fs:7 FL:17}



static void Test_F_BFu7s_BFu17ll()
{
  {
    init_simple_test("F_BFu7s_BFu17ll");
    static STRUCT_IF_C F_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "F_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "F_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu17ll, F_BFu7s_BFu17ll)
//============================================================================


struct  F_BFu7s_BFu1c  {
  float v1;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 F_BFu7s_BFu1c) C1{ Fi Fs:7 Fc:1}



static void Test_F_BFu7s_BFu1c()
{
  {
    init_simple_test("F_BFu7s_BFu1c");
    static STRUCT_IF_C F_BFu7s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu1c, F_BFu7s_BFu1c)
//============================================================================


struct  F_BFu7s_BFu1i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 F_BFu7s_BFu1i) C1{ Fi Fs:7 Fi:1}



static void Test_F_BFu7s_BFu1i()
{
  {
    init_simple_test("F_BFu7s_BFu1i");
    static STRUCT_IF_C F_BFu7s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu1i, F_BFu7s_BFu1i)
//============================================================================


struct  F_BFu7s_BFu1ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 F_BFu7s_BFu1ll) C1{ Fi Fs:7 FL:1}



static void Test_F_BFu7s_BFu1ll()
{
  {
    init_simple_test("F_BFu7s_BFu1ll");
    static STRUCT_IF_C F_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu1ll, F_BFu7s_BFu1ll)
//============================================================================


struct  F_BFu7s_BFu1s  {
  float v1;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 F_BFu7s_BFu1s) C1{ Fi Fs:7 Fs:1}



static void Test_F_BFu7s_BFu1s()
{
  {
    init_simple_test("F_BFu7s_BFu1s");
    static STRUCT_IF_C F_BFu7s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "F_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu1s, F_BFu7s_BFu1s)
//============================================================================


struct  F_BFu7s_BFu31i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 F_BFu7s_BFu31i) C1{ Fi Fs:7 Fi:31}



static void Test_F_BFu7s_BFu31i()
{
  {
    init_simple_test("F_BFu7s_BFu31i");
    static STRUCT_IF_C F_BFu7s_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu31i, F_BFu7s_BFu31i)
//============================================================================


struct  F_BFu7s_BFu31ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 F_BFu7s_BFu31ll) C1{ Fi Fs:7 FL:31}



static void Test_F_BFu7s_BFu31ll()
{
  {
    init_simple_test("F_BFu7s_BFu31ll");
    static STRUCT_IF_C F_BFu7s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "F_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "F_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu31ll, F_BFu7s_BFu31ll)
//============================================================================


struct  F_BFu7s_BFu32i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 F_BFu7s_BFu32i) C1{ Fi Fs:7 Fi:32}



static void Test_F_BFu7s_BFu32i()
{
  {
    init_simple_test("F_BFu7s_BFu32i");
    static STRUCT_IF_C F_BFu7s_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu32i, F_BFu7s_BFu32i)
//============================================================================


struct  F_BFu7s_BFu32ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 F_BFu7s_BFu32ll) C1{ Fi Fs:7 FL:32}



static void Test_F_BFu7s_BFu32ll()
{
  {
    init_simple_test("F_BFu7s_BFu32ll");
    static STRUCT_IF_C F_BFu7s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "F_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "F_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu32ll, F_BFu7s_BFu32ll)
//============================================================================


struct  F_BFu7s_BFu33  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 F_BFu7s_BFu33) C1{ Fi Fs:7 FL:33}



static void Test_F_BFu7s_BFu33()
{
  {
    init_simple_test("F_BFu7s_BFu33");
    static STRUCT_IF_C F_BFu7s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "F_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "F_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu33, F_BFu7s_BFu33)
//============================================================================


struct  F_BFu7s_BFu7c  {
  float v1;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 F_BFu7s_BFu7c) C1{ Fi Fs:7 Fc:7}



static void Test_F_BFu7s_BFu7c()
{
  {
    init_simple_test("F_BFu7s_BFu7c");
    static STRUCT_IF_C F_BFu7s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu7c, F_BFu7s_BFu7c)
//============================================================================


struct  F_BFu7s_BFu7i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 F_BFu7s_BFu7i) C1{ Fi Fs:7 Fi:7}



static void Test_F_BFu7s_BFu7i()
{
  {
    init_simple_test("F_BFu7s_BFu7i");
    static STRUCT_IF_C F_BFu7s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu7i, F_BFu7s_BFu7i)
//============================================================================


struct  F_BFu7s_BFu7ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 F_BFu7s_BFu7ll) C1{ Fi Fs:7 FL:7}



static void Test_F_BFu7s_BFu7ll()
{
  {
    init_simple_test("F_BFu7s_BFu7ll");
    static STRUCT_IF_C F_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu7ll, F_BFu7s_BFu7ll)
//============================================================================


struct  F_BFu7s_BFu7s  {
  float v1;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 F_BFu7s_BFu7s) C1{ Fi Fs:7 Fs:7}



static void Test_F_BFu7s_BFu7s()
{
  {
    init_simple_test("F_BFu7s_BFu7s");
    static STRUCT_IF_C F_BFu7s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "F_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "F_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu7s, F_BFu7s_BFu7s)
//============================================================================


struct  F_BFu7s_BFu8c  {
  float v1;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 F_BFu7s_BFu8c) C1{ Fi Fs:7 Fc:8}



static void Test_F_BFu7s_BFu8c()
{
  {
    init_simple_test("F_BFu7s_BFu8c");
    static STRUCT_IF_C F_BFu7s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu8c, F_BFu7s_BFu8c)
//============================================================================


struct  F_BFu7s_BFu8i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 F_BFu7s_BFu8i) C1{ Fi Fs:7 Fi:8}



static void Test_F_BFu7s_BFu8i()
{
  {
    init_simple_test("F_BFu7s_BFu8i");
    static STRUCT_IF_C F_BFu7s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu8i, F_BFu7s_BFu8i)
//============================================================================


struct  F_BFu7s_BFu8ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 F_BFu7s_BFu8ll) C1{ Fi Fs:7 FL:8}



static void Test_F_BFu7s_BFu8ll()
{
  {
    init_simple_test("F_BFu7s_BFu8ll");
    static STRUCT_IF_C F_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu8ll, F_BFu7s_BFu8ll)
//============================================================================


struct  F_BFu7s_BFu8s  {
  float v1;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 F_BFu7s_BFu8s) C1{ Fi Fs:7 Fs:8}



static void Test_F_BFu7s_BFu8s()
{
  {
    init_simple_test("F_BFu7s_BFu8s");
    static STRUCT_IF_C F_BFu7s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "F_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "F_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu8s, F_BFu7s_BFu8s)
//============================================================================


struct  F_BFu7s_BFu9i  {
  float v1;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 F_BFu7s_BFu9i) C1{ Fi Fs:7 Fi:9}



static void Test_F_BFu7s_BFu9i()
{
  {
    init_simple_test("F_BFu7s_BFu9i");
    static STRUCT_IF_C F_BFu7s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu9i, F_BFu7s_BFu9i)
//============================================================================


struct  F_BFu7s_BFu9ll  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 F_BFu7s_BFu9ll) C1{ Fi Fs:7 FL:9}



static void Test_F_BFu7s_BFu9ll()
{
  {
    init_simple_test("F_BFu7s_BFu9ll");
    static STRUCT_IF_C F_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu9ll, F_BFu7s_BFu9ll)
//============================================================================


struct  F_BFu7s_BFu9s  {
  float v1;
  unsigned short v2:7;
  unsigned short v3:9;
};
//SIG(1 F_BFu7s_BFu9s) C1{ Fi Fs:7 Fs:9}



static void Test_F_BFu7s_BFu9s()
{
  {
    init_simple_test("F_BFu7s_BFu9s");
    static STRUCT_IF_C F_BFu7s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "F_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "F_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_BFu9s, F_BFu7s_BFu9s)
//============================================================================


struct  F_BFu7s_C  {
  float v1;
  unsigned short v2:7;
  char v3;
};
//SIG(1 F_BFu7s_C) C1{ Fi Fs:7 Fc}



static void Test_F_BFu7s_C()
{
  {
    init_simple_test("F_BFu7s_C");
    static STRUCT_IF_C F_BFu7s_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_C)");
    check_field_offset(lv, v1, 0, "F_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_C");
    check_field_offset(lv, v3, 5, "F_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_C, F_BFu7s_C)
//============================================================================


struct  F_BFu7s_D  {
  float v1;
  unsigned short v2:7;
  double v3;
};
//SIG(1 F_BFu7s_D) C1{ Fi Fs:7 FL}



static void Test_F_BFu7s_D()
{
  {
    init_simple_test("F_BFu7s_D");
    static STRUCT_IF_C F_BFu7s_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_D)");
    check_field_offset(lv, v1, 0, "F_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_D");
    check_field_offset(lv, v3, 8, "F_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_D, F_BFu7s_D)
//============================================================================


struct  F_BFu7s_F  {
  float v1;
  unsigned short v2:7;
  float v3;
};
//SIG(1 F_BFu7s_F) C1{ Fi Fs:7 Fi}



static void Test_F_BFu7s_F()
{
  {
    init_simple_test("F_BFu7s_F");
    static STRUCT_IF_C F_BFu7s_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7s_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_F)");
    check_field_offset(lv, v1, 0, "F_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_F");
    check_field_offset(lv, v3, 8, "F_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_F, F_BFu7s_F)
//============================================================================


struct  F_BFu7s_I  {
  float v1;
  unsigned short v2:7;
  int v3;
};
//SIG(1 F_BFu7s_I) C1{ Fi Fs:7 Fi}



static void Test_F_BFu7s_I()
{
  {
    init_simple_test("F_BFu7s_I");
    static STRUCT_IF_C F_BFu7s_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7s_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_I)");
    check_field_offset(lv, v1, 0, "F_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_I");
    check_field_offset(lv, v3, 8, "F_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_I, F_BFu7s_I)
//============================================================================


struct  F_BFu7s_Ip  {
  float v1;
  unsigned short v2:7;
  int *v3;
};
//SIG(1 F_BFu7s_Ip) C1{ Fi Fs:7 Fp}



static void Test_F_BFu7s_Ip()
{
  {
    init_simple_test("F_BFu7s_Ip");
    static STRUCT_IF_C F_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_Ip");
    check_field_offset(lv, v3, 8, "F_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_Ip, F_BFu7s_Ip)
//============================================================================


struct  F_BFu7s_L  {
  float v1;
  unsigned short v2:7;
  __tsi64 v3;
};
//SIG(1 F_BFu7s_L) C1{ Fi Fs:7 FL}



static void Test_F_BFu7s_L()
{
  {
    init_simple_test("F_BFu7s_L");
    static STRUCT_IF_C F_BFu7s_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_L)");
    check_field_offset(lv, v1, 0, "F_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_L");
    check_field_offset(lv, v3, 8, "F_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_L, F_BFu7s_L)
//============================================================================


struct  F_BFu7s_S  {
  float v1;
  unsigned short v2:7;
  short v3;
};
//SIG(1 F_BFu7s_S) C1{ Fi Fs:7 Fs}



static void Test_F_BFu7s_S()
{
  {
    init_simple_test("F_BFu7s_S");
    static STRUCT_IF_C F_BFu7s_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_S)");
    check_field_offset(lv, v1, 0, "F_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_S");
    check_field_offset(lv, v3, 6, "F_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_S, F_BFu7s_S)
//============================================================================


struct  F_BFu7s_Uc  {
  float v1;
  unsigned short v2:7;
  unsigned char v3;
};
//SIG(1 F_BFu7s_Uc) C1{ Fi Fs:7 Fc}



static void Test_F_BFu7s_Uc()
{
  {
    init_simple_test("F_BFu7s_Uc");
    static STRUCT_IF_C F_BFu7s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_Uc");
    check_field_offset(lv, v3, 5, "F_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_Uc, F_BFu7s_Uc)
//============================================================================


struct  F_BFu7s_Ui  {
  float v1;
  unsigned short v2:7;
  unsigned int v3;
};
//SIG(1 F_BFu7s_Ui) C1{ Fi Fs:7 Fi}



static void Test_F_BFu7s_Ui()
{
  {
    init_simple_test("F_BFu7s_Ui");
    static STRUCT_IF_C F_BFu7s_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu7s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_Ui");
    check_field_offset(lv, v3, 8, "F_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_Ui, F_BFu7s_Ui)
//============================================================================


struct  F_BFu7s_Ul  {
  float v1;
  unsigned short v2:7;
  __tsu64 v3;
};
//SIG(1 F_BFu7s_Ul) C1{ Fi Fs:7 FL}



static void Test_F_BFu7s_Ul()
{
  {
    init_simple_test("F_BFu7s_Ul");
    static STRUCT_IF_C F_BFu7s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_Ul");
    check_field_offset(lv, v3, 8, "F_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_Ul, F_BFu7s_Ul)
//============================================================================


struct  F_BFu7s_Us  {
  float v1;
  unsigned short v2:7;
  unsigned short v3;
};
//SIG(1 F_BFu7s_Us) C1{ Fi Fs:7 Fs}



static void Test_F_BFu7s_Us()
{
  {
    init_simple_test("F_BFu7s_Us");
    static STRUCT_IF_C F_BFu7s_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu7s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "F_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_Us");
    check_field_offset(lv, v3, 6, "F_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_Us, F_BFu7s_Us)
//============================================================================


struct  F_BFu7s_Vp  {
  float v1;
  unsigned short v2:7;
  void *v3;
};
//SIG(1 F_BFu7s_Vp) C1{ Fi Fs:7 Fp}



static void Test_F_BFu7s_Vp()
{
  {
    init_simple_test("F_BFu7s_Vp");
    static STRUCT_IF_C F_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "F_BFu7s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "F_BFu7s_Vp");
    check_field_offset(lv, v3, 8, "F_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu7s_Vp, F_BFu7s_Vp)
//============================================================================


struct  F_BFu8c  {
  float v1;
  unsigned char v2:8;
};
//SIG(1 F_BFu8c) C1{ Fi Fc:8}



static void Test_F_BFu8c()
{
  {
    init_simple_test("F_BFu8c");
    static STRUCT_IF_C F_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c, F_BFu8c)
//============================================================================


struct  F_BFu8c_BFu15i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:15;
};
//SIG(1 F_BFu8c_BFu15i) C1{ Fi Fc:8 Fi:15}



static void Test_F_BFu8c_BFu15i()
{
  {
    init_simple_test("F_BFu8c_BFu15i");
    static STRUCT_IF_C F_BFu8c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu15i, F_BFu8c_BFu15i)
//============================================================================


struct  F_BFu8c_BFu15ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:15;
};
//SIG(1 F_BFu8c_BFu15ll) C1{ Fi Fc:8 FL:15}



static void Test_F_BFu8c_BFu15ll()
{
  {
    init_simple_test("F_BFu8c_BFu15ll");
    static STRUCT_IF_C F_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu15ll, F_BFu8c_BFu15ll)
//============================================================================


struct  F_BFu8c_BFu15s  {
  float v1;
  unsigned char v2:8;
  unsigned short v3:15;
};
//SIG(1 F_BFu8c_BFu15s) C1{ Fi Fc:8 Fs:15}



static void Test_F_BFu8c_BFu15s()
{
  {
    init_simple_test("F_BFu8c_BFu15s");
    static STRUCT_IF_C F_BFu8c_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu15s, F_BFu8c_BFu15s)
//============================================================================


struct  F_BFu8c_BFu16i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:16;
};
//SIG(1 F_BFu8c_BFu16i) C1{ Fi Fc:8 Fi:16}



static void Test_F_BFu8c_BFu16i()
{
  {
    init_simple_test("F_BFu8c_BFu16i");
    static STRUCT_IF_C F_BFu8c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu16i, F_BFu8c_BFu16i)
//============================================================================


struct  F_BFu8c_BFu16ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:16;
};
//SIG(1 F_BFu8c_BFu16ll) C1{ Fi Fc:8 FL:16}



static void Test_F_BFu8c_BFu16ll()
{
  {
    init_simple_test("F_BFu8c_BFu16ll");
    static STRUCT_IF_C F_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu16ll, F_BFu8c_BFu16ll)
//============================================================================


struct  F_BFu8c_BFu16s  {
  float v1;
  unsigned char v2:8;
  unsigned short v3:16;
};
//SIG(1 F_BFu8c_BFu16s) C1{ Fi Fc:8 Fs:16}



static void Test_F_BFu8c_BFu16s()
{
  {
    init_simple_test("F_BFu8c_BFu16s");
    static STRUCT_IF_C F_BFu8c_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu16s, F_BFu8c_BFu16s)
//============================================================================


struct  F_BFu8c_BFu17i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:17;
};
//SIG(1 F_BFu8c_BFu17i) C1{ Fi Fc:8 Fi:17}



static void Test_F_BFu8c_BFu17i()
{
  {
    init_simple_test("F_BFu8c_BFu17i");
    static STRUCT_IF_C F_BFu8c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu17i, F_BFu8c_BFu17i)
//============================================================================


struct  F_BFu8c_BFu17ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:17;
};
//SIG(1 F_BFu8c_BFu17ll) C1{ Fi Fc:8 FL:17}



static void Test_F_BFu8c_BFu17ll()
{
  {
    init_simple_test("F_BFu8c_BFu17ll");
    static STRUCT_IF_C F_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu17ll, F_BFu8c_BFu17ll)
//============================================================================


struct  F_BFu8c_BFu1c  {
  float v1;
  unsigned char v2:8;
  unsigned char v3:1;
};
//SIG(1 F_BFu8c_BFu1c) C1{ Fi Fc:8 Fc:1}



static void Test_F_BFu8c_BFu1c()
{
  {
    init_simple_test("F_BFu8c_BFu1c");
    static STRUCT_IF_C F_BFu8c_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu1c, F_BFu8c_BFu1c)
//============================================================================


struct  F_BFu8c_BFu1i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:1;
};
//SIG(1 F_BFu8c_BFu1i) C1{ Fi Fc:8 Fi:1}



static void Test_F_BFu8c_BFu1i()
{
  {
    init_simple_test("F_BFu8c_BFu1i");
    static STRUCT_IF_C F_BFu8c_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu1i, F_BFu8c_BFu1i)
//============================================================================


struct  F_BFu8c_BFu1ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:1;
};
//SIG(1 F_BFu8c_BFu1ll) C1{ Fi Fc:8 FL:1}



static void Test_F_BFu8c_BFu1ll()
{
  {
    init_simple_test("F_BFu8c_BFu1ll");
    static STRUCT_IF_C F_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu1ll, F_BFu8c_BFu1ll)
//============================================================================


struct  F_BFu8c_BFu1s  {
  float v1;
  unsigned char v2:8;
  unsigned short v3:1;
};
//SIG(1 F_BFu8c_BFu1s) C1{ Fi Fc:8 Fs:1}



static void Test_F_BFu8c_BFu1s()
{
  {
    init_simple_test("F_BFu8c_BFu1s");
    static STRUCT_IF_C F_BFu8c_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu1s, F_BFu8c_BFu1s)
//============================================================================


struct  F_BFu8c_BFu31i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:31;
};
//SIG(1 F_BFu8c_BFu31i) C1{ Fi Fc:8 Fi:31}



static void Test_F_BFu8c_BFu31i()
{
  {
    init_simple_test("F_BFu8c_BFu31i");
    static STRUCT_IF_C F_BFu8c_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu31i, F_BFu8c_BFu31i)
//============================================================================


struct  F_BFu8c_BFu31ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:31;
};
//SIG(1 F_BFu8c_BFu31ll) C1{ Fi Fc:8 FL:31}



static void Test_F_BFu8c_BFu31ll()
{
  {
    init_simple_test("F_BFu8c_BFu31ll");
    static STRUCT_IF_C F_BFu8c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "F_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "F_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu31ll, F_BFu8c_BFu31ll)
//============================================================================


struct  F_BFu8c_BFu32i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:32;
};
//SIG(1 F_BFu8c_BFu32i) C1{ Fi Fc:8 Fi:32}



static void Test_F_BFu8c_BFu32i()
{
  {
    init_simple_test("F_BFu8c_BFu32i");
    static STRUCT_IF_C F_BFu8c_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu32i, F_BFu8c_BFu32i)
//============================================================================


struct  F_BFu8c_BFu32ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:32;
};
//SIG(1 F_BFu8c_BFu32ll) C1{ Fi Fc:8 FL:32}



static void Test_F_BFu8c_BFu32ll()
{
  {
    init_simple_test("F_BFu8c_BFu32ll");
    static STRUCT_IF_C F_BFu8c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "F_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "F_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu32ll, F_BFu8c_BFu32ll)
//============================================================================


struct  F_BFu8c_BFu33  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:33;
};
//SIG(1 F_BFu8c_BFu33) C1{ Fi Fc:8 FL:33}



static void Test_F_BFu8c_BFu33()
{
  {
    init_simple_test("F_BFu8c_BFu33");
    static STRUCT_IF_C F_BFu8c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "F_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "F_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu33, F_BFu8c_BFu33)
//============================================================================


struct  F_BFu8c_BFu7c  {
  float v1;
  unsigned char v2:8;
  unsigned char v3:7;
};
//SIG(1 F_BFu8c_BFu7c) C1{ Fi Fc:8 Fc:7}



static void Test_F_BFu8c_BFu7c()
{
  {
    init_simple_test("F_BFu8c_BFu7c");
    static STRUCT_IF_C F_BFu8c_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu7c, F_BFu8c_BFu7c)
//============================================================================


struct  F_BFu8c_BFu7i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:7;
};
//SIG(1 F_BFu8c_BFu7i) C1{ Fi Fc:8 Fi:7}



static void Test_F_BFu8c_BFu7i()
{
  {
    init_simple_test("F_BFu8c_BFu7i");
    static STRUCT_IF_C F_BFu8c_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu7i, F_BFu8c_BFu7i)
//============================================================================


struct  F_BFu8c_BFu7ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:7;
};
//SIG(1 F_BFu8c_BFu7ll) C1{ Fi Fc:8 FL:7}



static void Test_F_BFu8c_BFu7ll()
{
  {
    init_simple_test("F_BFu8c_BFu7ll");
    static STRUCT_IF_C F_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu7ll, F_BFu8c_BFu7ll)
//============================================================================


struct  F_BFu8c_BFu7s  {
  float v1;
  unsigned char v2:8;
  unsigned short v3:7;
};
//SIG(1 F_BFu8c_BFu7s) C1{ Fi Fc:8 Fs:7}



static void Test_F_BFu8c_BFu7s()
{
  {
    init_simple_test("F_BFu8c_BFu7s");
    static STRUCT_IF_C F_BFu8c_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu7s, F_BFu8c_BFu7s)
//============================================================================


struct  F_BFu8c_BFu8c  {
  float v1;
  unsigned char v2:8;
  unsigned char v3:8;
};
//SIG(1 F_BFu8c_BFu8c) C1{ Fi Fc:8 Fc:8}



static void Test_F_BFu8c_BFu8c()
{
  {
    init_simple_test("F_BFu8c_BFu8c");
    static STRUCT_IF_C F_BFu8c_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu8c, F_BFu8c_BFu8c)
//============================================================================


struct  F_BFu8c_BFu8i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:8;
};
//SIG(1 F_BFu8c_BFu8i) C1{ Fi Fc:8 Fi:8}



static void Test_F_BFu8c_BFu8i()
{
  {
    init_simple_test("F_BFu8c_BFu8i");
    static STRUCT_IF_C F_BFu8c_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu8i, F_BFu8c_BFu8i)
//============================================================================


struct  F_BFu8c_BFu8ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:8;
};
//SIG(1 F_BFu8c_BFu8ll) C1{ Fi Fc:8 FL:8}



static void Test_F_BFu8c_BFu8ll()
{
  {
    init_simple_test("F_BFu8c_BFu8ll");
    static STRUCT_IF_C F_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu8ll, F_BFu8c_BFu8ll)
//============================================================================


struct  F_BFu8c_BFu8s  {
  float v1;
  unsigned char v2:8;
  unsigned short v3:8;
};
//SIG(1 F_BFu8c_BFu8s) C1{ Fi Fc:8 Fs:8}



static void Test_F_BFu8c_BFu8s()
{
  {
    init_simple_test("F_BFu8c_BFu8s");
    static STRUCT_IF_C F_BFu8c_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu8s, F_BFu8c_BFu8s)
//============================================================================


struct  F_BFu8c_BFu9i  {
  float v1;
  unsigned char v2:8;
  unsigned int v3:9;
};
//SIG(1 F_BFu8c_BFu9i) C1{ Fi Fc:8 Fi:9}



static void Test_F_BFu8c_BFu9i()
{
  {
    init_simple_test("F_BFu8c_BFu9i");
    static STRUCT_IF_C F_BFu8c_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu9i, F_BFu8c_BFu9i)
//============================================================================


struct  F_BFu8c_BFu9ll  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3:9;
};
//SIG(1 F_BFu8c_BFu9ll) C1{ Fi Fc:8 FL:9}



static void Test_F_BFu8c_BFu9ll()
{
  {
    init_simple_test("F_BFu8c_BFu9ll");
    static STRUCT_IF_C F_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu9ll, F_BFu8c_BFu9ll)
//============================================================================


struct  F_BFu8c_BFu9s  {
  float v1;
  unsigned char v2:8;
  unsigned short v3:9;
};
//SIG(1 F_BFu8c_BFu9s) C1{ Fi Fc:8 Fs:9}



static void Test_F_BFu8c_BFu9s()
{
  {
    init_simple_test("F_BFu8c_BFu9s");
    static STRUCT_IF_C F_BFu8c_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_BFu9s, F_BFu8c_BFu9s)
//============================================================================


struct  F_BFu8c_C  {
  float v1;
  unsigned char v2:8;
  char v3;
};
//SIG(1 F_BFu8c_C) C1{ Fi Fc:8 Fc}



static void Test_F_BFu8c_C()
{
  {
    init_simple_test("F_BFu8c_C");
    static STRUCT_IF_C F_BFu8c_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_C)");
    check_field_offset(lv, v1, 0, "F_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_C");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_C");
    check_field_offset(lv, v3, 5, "F_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_C, F_BFu8c_C)
//============================================================================


struct  F_BFu8c_D  {
  float v1;
  unsigned char v2:8;
  double v3;
};
//SIG(1 F_BFu8c_D) C1{ Fi Fc:8 FL}



static void Test_F_BFu8c_D()
{
  {
    init_simple_test("F_BFu8c_D");
    static STRUCT_IF_C F_BFu8c_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_D)");
    check_field_offset(lv, v1, 0, "F_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_D");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_D");
    check_field_offset(lv, v3, 8, "F_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_D, F_BFu8c_D)
//============================================================================


struct  F_BFu8c_F  {
  float v1;
  unsigned char v2:8;
  float v3;
};
//SIG(1 F_BFu8c_F) C1{ Fi Fc:8 Fi}



static void Test_F_BFu8c_F()
{
  {
    init_simple_test("F_BFu8c_F");
    static STRUCT_IF_C F_BFu8c_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8c_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_F)");
    check_field_offset(lv, v1, 0, "F_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_F");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_F");
    check_field_offset(lv, v3, 8, "F_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_F, F_BFu8c_F)
//============================================================================


struct  F_BFu8c_I  {
  float v1;
  unsigned char v2:8;
  int v3;
};
//SIG(1 F_BFu8c_I) C1{ Fi Fc:8 Fi}



static void Test_F_BFu8c_I()
{
  {
    init_simple_test("F_BFu8c_I");
    static STRUCT_IF_C F_BFu8c_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8c_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_I)");
    check_field_offset(lv, v1, 0, "F_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_I");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_I");
    check_field_offset(lv, v3, 8, "F_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_I, F_BFu8c_I)
//============================================================================


struct  F_BFu8c_Ip  {
  float v1;
  unsigned char v2:8;
  int *v3;
};
//SIG(1 F_BFu8c_Ip) C1{ Fi Fc:8 Fp}



static void Test_F_BFu8c_Ip()
{
  {
    init_simple_test("F_BFu8c_Ip");
    static STRUCT_IF_C F_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_Ip");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_Ip");
    check_field_offset(lv, v3, 8, "F_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_Ip, F_BFu8c_Ip)
//============================================================================


struct  F_BFu8c_L  {
  float v1;
  unsigned char v2:8;
  __tsi64 v3;
};
//SIG(1 F_BFu8c_L) C1{ Fi Fc:8 FL}



static void Test_F_BFu8c_L()
{
  {
    init_simple_test("F_BFu8c_L");
    static STRUCT_IF_C F_BFu8c_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_L)");
    check_field_offset(lv, v1, 0, "F_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_L");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_L");
    check_field_offset(lv, v3, 8, "F_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_L, F_BFu8c_L)
//============================================================================


struct  F_BFu8c_S  {
  float v1;
  unsigned char v2:8;
  short v3;
};
//SIG(1 F_BFu8c_S) C1{ Fi Fc:8 Fs}



static void Test_F_BFu8c_S()
{
  {
    init_simple_test("F_BFu8c_S");
    static STRUCT_IF_C F_BFu8c_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_S)");
    check_field_offset(lv, v1, 0, "F_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_S");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_S");
    check_field_offset(lv, v3, 6, "F_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_S, F_BFu8c_S)
//============================================================================


struct  F_BFu8c_Uc  {
  float v1;
  unsigned char v2:8;
  unsigned char v3;
};
//SIG(1 F_BFu8c_Uc) C1{ Fi Fc:8 Fc}



static void Test_F_BFu8c_Uc()
{
  {
    init_simple_test("F_BFu8c_Uc");
    static STRUCT_IF_C F_BFu8c_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_Uc");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_Uc");
    check_field_offset(lv, v3, 5, "F_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_Uc, F_BFu8c_Uc)
//============================================================================


struct  F_BFu8c_Ui  {
  float v1;
  unsigned char v2:8;
  unsigned int v3;
};
//SIG(1 F_BFu8c_Ui) C1{ Fi Fc:8 Fi}



static void Test_F_BFu8c_Ui()
{
  {
    init_simple_test("F_BFu8c_Ui");
    static STRUCT_IF_C F_BFu8c_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_Ui");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_Ui");
    check_field_offset(lv, v3, 8, "F_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_Ui, F_BFu8c_Ui)
//============================================================================


struct  F_BFu8c_Ul  {
  float v1;
  unsigned char v2:8;
  __tsu64 v3;
};
//SIG(1 F_BFu8c_Ul) C1{ Fi Fc:8 FL}



static void Test_F_BFu8c_Ul()
{
  {
    init_simple_test("F_BFu8c_Ul");
    static STRUCT_IF_C F_BFu8c_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_Ul");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_Ul");
    check_field_offset(lv, v3, 8, "F_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_Ul, F_BFu8c_Ul)
//============================================================================


struct  F_BFu8c_Us  {
  float v1;
  unsigned char v2:8;
  unsigned short v3;
};
//SIG(1 F_BFu8c_Us) C1{ Fi Fc:8 Fs}



static void Test_F_BFu8c_Us()
{
  {
    init_simple_test("F_BFu8c_Us");
    static STRUCT_IF_C F_BFu8c_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "F_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_Us");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_Us");
    check_field_offset(lv, v3, 6, "F_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_Us, F_BFu8c_Us)
//============================================================================


struct  F_BFu8c_Vp  {
  float v1;
  unsigned char v2:8;
  void *v3;
};
//SIG(1 F_BFu8c_Vp) C1{ Fi Fc:8 Fp}



static void Test_F_BFu8c_Vp()
{
  {
    init_simple_test("F_BFu8c_Vp");
    static STRUCT_IF_C F_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8c_Vp");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8c_Vp");
    check_field_offset(lv, v3, 8, "F_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8c_Vp, F_BFu8c_Vp)
//============================================================================


struct  F_BFu8i  {
  float v1;
  unsigned int v2:8;
};
//SIG(1 F_BFu8i) C1{ Fi Fi:8}



static void Test_F_BFu8i()
{
  {
    init_simple_test("F_BFu8i");
    static STRUCT_IF_C F_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i, F_BFu8i)
//============================================================================


struct  F_BFu8i_BFu15i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:15;
};
//SIG(1 F_BFu8i_BFu15i) C1{ Fi Fi:8 Fi:15}



static void Test_F_BFu8i_BFu15i()
{
  {
    init_simple_test("F_BFu8i_BFu15i");
    static STRUCT_IF_C F_BFu8i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu15i, F_BFu8i_BFu15i)
//============================================================================


struct  F_BFu8i_BFu15ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:15;
};
//SIG(1 F_BFu8i_BFu15ll) C1{ Fi Fi:8 FL:15}



static void Test_F_BFu8i_BFu15ll()
{
  {
    init_simple_test("F_BFu8i_BFu15ll");
    static STRUCT_IF_C F_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu15ll, F_BFu8i_BFu15ll)
//============================================================================


struct  F_BFu8i_BFu15s  {
  float v1;
  unsigned int v2:8;
  unsigned short v3:15;
};
//SIG(1 F_BFu8i_BFu15s) C1{ Fi Fi:8 Fs:15}



static void Test_F_BFu8i_BFu15s()
{
  {
    init_simple_test("F_BFu8i_BFu15s");
    static STRUCT_IF_C F_BFu8i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu15s, F_BFu8i_BFu15s)
//============================================================================


struct  F_BFu8i_BFu16i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:16;
};
//SIG(1 F_BFu8i_BFu16i) C1{ Fi Fi:8 Fi:16}



static void Test_F_BFu8i_BFu16i()
{
  {
    init_simple_test("F_BFu8i_BFu16i");
    static STRUCT_IF_C F_BFu8i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu16i, F_BFu8i_BFu16i)
//============================================================================


struct  F_BFu8i_BFu16ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:16;
};
//SIG(1 F_BFu8i_BFu16ll) C1{ Fi Fi:8 FL:16}



static void Test_F_BFu8i_BFu16ll()
{
  {
    init_simple_test("F_BFu8i_BFu16ll");
    static STRUCT_IF_C F_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu16ll, F_BFu8i_BFu16ll)
//============================================================================


struct  F_BFu8i_BFu16s  {
  float v1;
  unsigned int v2:8;
  unsigned short v3:16;
};
//SIG(1 F_BFu8i_BFu16s) C1{ Fi Fi:8 Fs:16}



static void Test_F_BFu8i_BFu16s()
{
  {
    init_simple_test("F_BFu8i_BFu16s");
    static STRUCT_IF_C F_BFu8i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu16s, F_BFu8i_BFu16s)
//============================================================================


struct  F_BFu8i_BFu17i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:17;
};
//SIG(1 F_BFu8i_BFu17i) C1{ Fi Fi:8 Fi:17}



static void Test_F_BFu8i_BFu17i()
{
  {
    init_simple_test("F_BFu8i_BFu17i");
    static STRUCT_IF_C F_BFu8i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu17i, F_BFu8i_BFu17i)
//============================================================================


struct  F_BFu8i_BFu17ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:17;
};
//SIG(1 F_BFu8i_BFu17ll) C1{ Fi Fi:8 FL:17}



static void Test_F_BFu8i_BFu17ll()
{
  {
    init_simple_test("F_BFu8i_BFu17ll");
    static STRUCT_IF_C F_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu17ll, F_BFu8i_BFu17ll)
//============================================================================


struct  F_BFu8i_BFu1c  {
  float v1;
  unsigned int v2:8;
  unsigned char v3:1;
};
//SIG(1 F_BFu8i_BFu1c) C1{ Fi Fi:8 Fc:1}



static void Test_F_BFu8i_BFu1c()
{
  {
    init_simple_test("F_BFu8i_BFu1c");
    static STRUCT_IF_C F_BFu8i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu1c, F_BFu8i_BFu1c)
//============================================================================


struct  F_BFu8i_BFu1i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:1;
};
//SIG(1 F_BFu8i_BFu1i) C1{ Fi Fi:8 Fi:1}



static void Test_F_BFu8i_BFu1i()
{
  {
    init_simple_test("F_BFu8i_BFu1i");
    static STRUCT_IF_C F_BFu8i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu1i, F_BFu8i_BFu1i)
//============================================================================


struct  F_BFu8i_BFu1ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:1;
};
//SIG(1 F_BFu8i_BFu1ll) C1{ Fi Fi:8 FL:1}



static void Test_F_BFu8i_BFu1ll()
{
  {
    init_simple_test("F_BFu8i_BFu1ll");
    static STRUCT_IF_C F_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu1ll, F_BFu8i_BFu1ll)
//============================================================================


struct  F_BFu8i_BFu1s  {
  float v1;
  unsigned int v2:8;
  unsigned short v3:1;
};
//SIG(1 F_BFu8i_BFu1s) C1{ Fi Fi:8 Fs:1}



static void Test_F_BFu8i_BFu1s()
{
  {
    init_simple_test("F_BFu8i_BFu1s");
    static STRUCT_IF_C F_BFu8i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu1s, F_BFu8i_BFu1s)
//============================================================================


struct  F_BFu8i_BFu31i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:31;
};
//SIG(1 F_BFu8i_BFu31i) C1{ Fi Fi:8 Fi:31}



static void Test_F_BFu8i_BFu31i()
{
  {
    init_simple_test("F_BFu8i_BFu31i");
    static STRUCT_IF_C F_BFu8i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu31i, F_BFu8i_BFu31i)
//============================================================================


struct  F_BFu8i_BFu31ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 F_BFu8i_BFu31ll) C1{ Fi Fi:8 FL:31}



static void Test_F_BFu8i_BFu31ll()
{
  {
    init_simple_test("F_BFu8i_BFu31ll");
    static STRUCT_IF_C F_BFu8i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "F_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "F_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu31ll, F_BFu8i_BFu31ll)
//============================================================================


struct  F_BFu8i_BFu32i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 F_BFu8i_BFu32i) C1{ Fi Fi:8 Fi:32}



static void Test_F_BFu8i_BFu32i()
{
  {
    init_simple_test("F_BFu8i_BFu32i");
    static STRUCT_IF_C F_BFu8i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu32i, F_BFu8i_BFu32i)
//============================================================================


struct  F_BFu8i_BFu32ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 F_BFu8i_BFu32ll) C1{ Fi Fi:8 FL:32}



static void Test_F_BFu8i_BFu32ll()
{
  {
    init_simple_test("F_BFu8i_BFu32ll");
    static STRUCT_IF_C F_BFu8i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "F_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "F_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu32ll, F_BFu8i_BFu32ll)
//============================================================================


struct  F_BFu8i_BFu33  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 F_BFu8i_BFu33) C1{ Fi Fi:8 FL:33}



static void Test_F_BFu8i_BFu33()
{
  {
    init_simple_test("F_BFu8i_BFu33");
    static STRUCT_IF_C F_BFu8i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "F_BFu8i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "F_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu33, F_BFu8i_BFu33)
//============================================================================


struct  F_BFu8i_BFu7c  {
  float v1;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 F_BFu8i_BFu7c) C1{ Fi Fi:8 Fc:7}



static void Test_F_BFu8i_BFu7c()
{
  {
    init_simple_test("F_BFu8i_BFu7c");
    static STRUCT_IF_C F_BFu8i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu7c, F_BFu8i_BFu7c)
//============================================================================


struct  F_BFu8i_BFu7i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 F_BFu8i_BFu7i) C1{ Fi Fi:8 Fi:7}



static void Test_F_BFu8i_BFu7i()
{
  {
    init_simple_test("F_BFu8i_BFu7i");
    static STRUCT_IF_C F_BFu8i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu7i, F_BFu8i_BFu7i)
//============================================================================


struct  F_BFu8i_BFu7ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 F_BFu8i_BFu7ll) C1{ Fi Fi:8 FL:7}



static void Test_F_BFu8i_BFu7ll()
{
  {
    init_simple_test("F_BFu8i_BFu7ll");
    static STRUCT_IF_C F_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu7ll, F_BFu8i_BFu7ll)
//============================================================================


struct  F_BFu8i_BFu7s  {
  float v1;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 F_BFu8i_BFu7s) C1{ Fi Fi:8 Fs:7}



static void Test_F_BFu8i_BFu7s()
{
  {
    init_simple_test("F_BFu8i_BFu7s");
    static STRUCT_IF_C F_BFu8i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu7s, F_BFu8i_BFu7s)
//============================================================================


struct  F_BFu8i_BFu8c  {
  float v1;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 F_BFu8i_BFu8c) C1{ Fi Fi:8 Fc:8}



static void Test_F_BFu8i_BFu8c()
{
  {
    init_simple_test("F_BFu8i_BFu8c");
    static STRUCT_IF_C F_BFu8i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu8c, F_BFu8i_BFu8c)
//============================================================================


struct  F_BFu8i_BFu8i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 F_BFu8i_BFu8i) C1{ Fi Fi:8 Fi:8}



static void Test_F_BFu8i_BFu8i()
{
  {
    init_simple_test("F_BFu8i_BFu8i");
    static STRUCT_IF_C F_BFu8i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu8i, F_BFu8i_BFu8i)
//============================================================================


struct  F_BFu8i_BFu8ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 F_BFu8i_BFu8ll) C1{ Fi Fi:8 FL:8}



static void Test_F_BFu8i_BFu8ll()
{
  {
    init_simple_test("F_BFu8i_BFu8ll");
    static STRUCT_IF_C F_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu8ll, F_BFu8i_BFu8ll)
//============================================================================


struct  F_BFu8i_BFu8s  {
  float v1;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 F_BFu8i_BFu8s) C1{ Fi Fi:8 Fs:8}



static void Test_F_BFu8i_BFu8s()
{
  {
    init_simple_test("F_BFu8i_BFu8s");
    static STRUCT_IF_C F_BFu8i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu8s, F_BFu8i_BFu8s)
//============================================================================


struct  F_BFu8i_BFu9i  {
  float v1;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 F_BFu8i_BFu9i) C1{ Fi Fi:8 Fi:9}



static void Test_F_BFu8i_BFu9i()
{
  {
    init_simple_test("F_BFu8i_BFu9i");
    static STRUCT_IF_C F_BFu8i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu9i, F_BFu8i_BFu9i)
//============================================================================


struct  F_BFu8i_BFu9ll  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 F_BFu8i_BFu9ll) C1{ Fi Fi:8 FL:9}



static void Test_F_BFu8i_BFu9ll()
{
  {
    init_simple_test("F_BFu8i_BFu9ll");
    static STRUCT_IF_C F_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu9ll, F_BFu8i_BFu9ll)
//============================================================================


struct  F_BFu8i_BFu9s  {
  float v1;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 F_BFu8i_BFu9s) C1{ Fi Fi:8 Fs:9}



static void Test_F_BFu8i_BFu9s()
{
  {
    init_simple_test("F_BFu8i_BFu9s");
    static STRUCT_IF_C F_BFu8i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_BFu9s, F_BFu8i_BFu9s)
//============================================================================


struct  F_BFu8i_C  {
  float v1;
  unsigned int v2:8;
  char v3;
};
//SIG(1 F_BFu8i_C) C1{ Fi Fi:8 Fc}



static void Test_F_BFu8i_C()
{
  {
    init_simple_test("F_BFu8i_C");
    static STRUCT_IF_C F_BFu8i_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_C)");
    check_field_offset(lv, v1, 0, "F_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_C");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_C");
    check_field_offset(lv, v3, 5, "F_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_C, F_BFu8i_C)
//============================================================================


struct  F_BFu8i_D  {
  float v1;
  unsigned int v2:8;
  double v3;
};
//SIG(1 F_BFu8i_D) C1{ Fi Fi:8 FL}



static void Test_F_BFu8i_D()
{
  {
    init_simple_test("F_BFu8i_D");
    static STRUCT_IF_C F_BFu8i_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_D)");
    check_field_offset(lv, v1, 0, "F_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_D");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_D");
    check_field_offset(lv, v3, 8, "F_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_D, F_BFu8i_D)
//============================================================================


struct  F_BFu8i_F  {
  float v1;
  unsigned int v2:8;
  float v3;
};
//SIG(1 F_BFu8i_F) C1{ Fi Fi:8 Fi}



static void Test_F_BFu8i_F()
{
  {
    init_simple_test("F_BFu8i_F");
    static STRUCT_IF_C F_BFu8i_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_F)");
    check_field_offset(lv, v1, 0, "F_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_F");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_F");
    check_field_offset(lv, v3, 8, "F_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_F, F_BFu8i_F)
//============================================================================


struct  F_BFu8i_I  {
  float v1;
  unsigned int v2:8;
  int v3;
};
//SIG(1 F_BFu8i_I) C1{ Fi Fi:8 Fi}



static void Test_F_BFu8i_I()
{
  {
    init_simple_test("F_BFu8i_I");
    static STRUCT_IF_C F_BFu8i_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_I)");
    check_field_offset(lv, v1, 0, "F_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_I");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_I");
    check_field_offset(lv, v3, 8, "F_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_I, F_BFu8i_I)
//============================================================================


struct  F_BFu8i_Ip  {
  float v1;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 F_BFu8i_Ip) C1{ Fi Fi:8 Fp}



static void Test_F_BFu8i_Ip()
{
  {
    init_simple_test("F_BFu8i_Ip");
    static STRUCT_IF_C F_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_Ip");
    check_field_offset(lv, v3, 8, "F_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_Ip, F_BFu8i_Ip)
//============================================================================


struct  F_BFu8i_L  {
  float v1;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 F_BFu8i_L) C1{ Fi Fi:8 FL}



static void Test_F_BFu8i_L()
{
  {
    init_simple_test("F_BFu8i_L");
    static STRUCT_IF_C F_BFu8i_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_L)");
    check_field_offset(lv, v1, 0, "F_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_L");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_L");
    check_field_offset(lv, v3, 8, "F_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_L, F_BFu8i_L)
//============================================================================


struct  F_BFu8i_S  {
  float v1;
  unsigned int v2:8;
  short v3;
};
//SIG(1 F_BFu8i_S) C1{ Fi Fi:8 Fs}



static void Test_F_BFu8i_S()
{
  {
    init_simple_test("F_BFu8i_S");
    static STRUCT_IF_C F_BFu8i_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_S)");
    check_field_offset(lv, v1, 0, "F_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_S");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_S");
    check_field_offset(lv, v3, 6, "F_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_S, F_BFu8i_S)
//============================================================================


struct  F_BFu8i_Uc  {
  float v1;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 F_BFu8i_Uc) C1{ Fi Fi:8 Fc}



static void Test_F_BFu8i_Uc()
{
  {
    init_simple_test("F_BFu8i_Uc");
    static STRUCT_IF_C F_BFu8i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_Uc");
    check_field_offset(lv, v3, 5, "F_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_Uc, F_BFu8i_Uc)
//============================================================================


struct  F_BFu8i_Ui  {
  float v1;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 F_BFu8i_Ui) C1{ Fi Fi:8 Fi}



static void Test_F_BFu8i_Ui()
{
  {
    init_simple_test("F_BFu8i_Ui");
    static STRUCT_IF_C F_BFu8i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_Ui");
    check_field_offset(lv, v3, 8, "F_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_Ui, F_BFu8i_Ui)
//============================================================================


struct  F_BFu8i_Ul  {
  float v1;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 F_BFu8i_Ul) C1{ Fi Fi:8 FL}



static void Test_F_BFu8i_Ul()
{
  {
    init_simple_test("F_BFu8i_Ul");
    static STRUCT_IF_C F_BFu8i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_Ul");
    check_field_offset(lv, v3, 8, "F_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_Ul, F_BFu8i_Ul)
//============================================================================


struct  F_BFu8i_Us  {
  float v1;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 F_BFu8i_Us) C1{ Fi Fi:8 Fs}



static void Test_F_BFu8i_Us()
{
  {
    init_simple_test("F_BFu8i_Us");
    static STRUCT_IF_C F_BFu8i_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_Us");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_Us");
    check_field_offset(lv, v3, 6, "F_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_Us, F_BFu8i_Us)
//============================================================================


struct  F_BFu8i_Vp  {
  float v1;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 F_BFu8i_Vp) C1{ Fi Fi:8 Fp}



static void Test_F_BFu8i_Vp()
{
  {
    init_simple_test("F_BFu8i_Vp");
    static STRUCT_IF_C F_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8i_Vp");
    check_field_offset(lv, v3, 8, "F_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8i_Vp, F_BFu8i_Vp)
//============================================================================


struct  F_BFu8ll  {
  float v1;
  __tsu64 v2:8;
};
//SIG(1 F_BFu8ll) C1{ Fi FL:8}



static void Test_F_BFu8ll()
{
  {
    init_simple_test("F_BFu8ll");
    static STRUCT_IF_C F_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll, F_BFu8ll)
//============================================================================


struct  F_BFu8ll_BFu15i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 F_BFu8ll_BFu15i) C1{ Fi FL:8 Fi:15}



static void Test_F_BFu8ll_BFu15i()
{
  {
    init_simple_test("F_BFu8ll_BFu15i");
    static STRUCT_IF_C F_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu15i, F_BFu8ll_BFu15i)
//============================================================================


struct  F_BFu8ll_BFu15ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 F_BFu8ll_BFu15ll) C1{ Fi FL:8 FL:15}



static void Test_F_BFu8ll_BFu15ll()
{
  {
    init_simple_test("F_BFu8ll_BFu15ll");
    static STRUCT_IF_C F_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu15ll, F_BFu8ll_BFu15ll)
//============================================================================


struct  F_BFu8ll_BFu15s  {
  float v1;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 F_BFu8ll_BFu15s) C1{ Fi FL:8 Fs:15}



static void Test_F_BFu8ll_BFu15s()
{
  {
    init_simple_test("F_BFu8ll_BFu15s");
    static STRUCT_IF_C F_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu15s, F_BFu8ll_BFu15s)
//============================================================================


struct  F_BFu8ll_BFu16i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 F_BFu8ll_BFu16i) C1{ Fi FL:8 Fi:16}



static void Test_F_BFu8ll_BFu16i()
{
  {
    init_simple_test("F_BFu8ll_BFu16i");
    static STRUCT_IF_C F_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu16i, F_BFu8ll_BFu16i)
//============================================================================


struct  F_BFu8ll_BFu16ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 F_BFu8ll_BFu16ll) C1{ Fi FL:8 FL:16}



static void Test_F_BFu8ll_BFu16ll()
{
  {
    init_simple_test("F_BFu8ll_BFu16ll");
    static STRUCT_IF_C F_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu16ll, F_BFu8ll_BFu16ll)
//============================================================================


struct  F_BFu8ll_BFu16s  {
  float v1;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 F_BFu8ll_BFu16s) C1{ Fi FL:8 Fs:16}



static void Test_F_BFu8ll_BFu16s()
{
  {
    init_simple_test("F_BFu8ll_BFu16s");
    static STRUCT_IF_C F_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu16s, F_BFu8ll_BFu16s)
//============================================================================


struct  F_BFu8ll_BFu17i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 F_BFu8ll_BFu17i) C1{ Fi FL:8 Fi:17}



static void Test_F_BFu8ll_BFu17i()
{
  {
    init_simple_test("F_BFu8ll_BFu17i");
    static STRUCT_IF_C F_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu17i, F_BFu8ll_BFu17i)
//============================================================================


struct  F_BFu8ll_BFu17ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 F_BFu8ll_BFu17ll) C1{ Fi FL:8 FL:17}



static void Test_F_BFu8ll_BFu17ll()
{
  {
    init_simple_test("F_BFu8ll_BFu17ll");
    static STRUCT_IF_C F_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu17ll, F_BFu8ll_BFu17ll)
//============================================================================


struct  F_BFu8ll_BFu1c  {
  float v1;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 F_BFu8ll_BFu1c) C1{ Fi FL:8 Fc:1}



static void Test_F_BFu8ll_BFu1c()
{
  {
    init_simple_test("F_BFu8ll_BFu1c");
    static STRUCT_IF_C F_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu1c, F_BFu8ll_BFu1c)
//============================================================================


struct  F_BFu8ll_BFu1i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 F_BFu8ll_BFu1i) C1{ Fi FL:8 Fi:1}



static void Test_F_BFu8ll_BFu1i()
{
  {
    init_simple_test("F_BFu8ll_BFu1i");
    static STRUCT_IF_C F_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu1i, F_BFu8ll_BFu1i)
//============================================================================


struct  F_BFu8ll_BFu1ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 F_BFu8ll_BFu1ll) C1{ Fi FL:8 FL:1}



static void Test_F_BFu8ll_BFu1ll()
{
  {
    init_simple_test("F_BFu8ll_BFu1ll");
    static STRUCT_IF_C F_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu1ll, F_BFu8ll_BFu1ll)
//============================================================================


struct  F_BFu8ll_BFu1s  {
  float v1;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 F_BFu8ll_BFu1s) C1{ Fi FL:8 Fs:1}



static void Test_F_BFu8ll_BFu1s()
{
  {
    init_simple_test("F_BFu8ll_BFu1s");
    static STRUCT_IF_C F_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu1s, F_BFu8ll_BFu1s)
//============================================================================


struct  F_BFu8ll_BFu31i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 F_BFu8ll_BFu31i) C1{ Fi FL:8 Fi:31}



static void Test_F_BFu8ll_BFu31i()
{
  {
    init_simple_test("F_BFu8ll_BFu31i");
    static STRUCT_IF_C F_BFu8ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu31i, F_BFu8ll_BFu31i)
//============================================================================


struct  F_BFu8ll_BFu31ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 F_BFu8ll_BFu31ll) C1{ Fi FL:8 FL:31}



static void Test_F_BFu8ll_BFu31ll()
{
  {
    init_simple_test("F_BFu8ll_BFu31ll");
    static STRUCT_IF_C F_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "F_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "F_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu31ll, F_BFu8ll_BFu31ll)
//============================================================================


struct  F_BFu8ll_BFu32i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 F_BFu8ll_BFu32i) C1{ Fi FL:8 Fi:32}



static void Test_F_BFu8ll_BFu32i()
{
  {
    init_simple_test("F_BFu8ll_BFu32i");
    static STRUCT_IF_C F_BFu8ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu32i, F_BFu8ll_BFu32i)
//============================================================================


struct  F_BFu8ll_BFu32ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 F_BFu8ll_BFu32ll) C1{ Fi FL:8 FL:32}



static void Test_F_BFu8ll_BFu32ll()
{
  {
    init_simple_test("F_BFu8ll_BFu32ll");
    static STRUCT_IF_C F_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "F_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "F_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu32ll, F_BFu8ll_BFu32ll)
//============================================================================


struct  F_BFu8ll_BFu33  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 F_BFu8ll_BFu33) C1{ Fi FL:8 FL:33}



static void Test_F_BFu8ll_BFu33()
{
  {
    init_simple_test("F_BFu8ll_BFu33");
    static STRUCT_IF_C F_BFu8ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "F_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "F_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu33, F_BFu8ll_BFu33)
//============================================================================


struct  F_BFu8ll_BFu7c  {
  float v1;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 F_BFu8ll_BFu7c) C1{ Fi FL:8 Fc:7}



static void Test_F_BFu8ll_BFu7c()
{
  {
    init_simple_test("F_BFu8ll_BFu7c");
    static STRUCT_IF_C F_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu7c, F_BFu8ll_BFu7c)
//============================================================================


struct  F_BFu8ll_BFu7i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 F_BFu8ll_BFu7i) C1{ Fi FL:8 Fi:7}



static void Test_F_BFu8ll_BFu7i()
{
  {
    init_simple_test("F_BFu8ll_BFu7i");
    static STRUCT_IF_C F_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu7i, F_BFu8ll_BFu7i)
//============================================================================


struct  F_BFu8ll_BFu7ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 F_BFu8ll_BFu7ll) C1{ Fi FL:8 FL:7}



static void Test_F_BFu8ll_BFu7ll()
{
  {
    init_simple_test("F_BFu8ll_BFu7ll");
    static STRUCT_IF_C F_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu7ll, F_BFu8ll_BFu7ll)
//============================================================================


struct  F_BFu8ll_BFu7s  {
  float v1;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 F_BFu8ll_BFu7s) C1{ Fi FL:8 Fs:7}



static void Test_F_BFu8ll_BFu7s()
{
  {
    init_simple_test("F_BFu8ll_BFu7s");
    static STRUCT_IF_C F_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu7s, F_BFu8ll_BFu7s)
//============================================================================


struct  F_BFu8ll_BFu8c  {
  float v1;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 F_BFu8ll_BFu8c) C1{ Fi FL:8 Fc:8}



static void Test_F_BFu8ll_BFu8c()
{
  {
    init_simple_test("F_BFu8ll_BFu8c");
    static STRUCT_IF_C F_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu8c, F_BFu8ll_BFu8c)
//============================================================================


struct  F_BFu8ll_BFu8i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 F_BFu8ll_BFu8i) C1{ Fi FL:8 Fi:8}



static void Test_F_BFu8ll_BFu8i()
{
  {
    init_simple_test("F_BFu8ll_BFu8i");
    static STRUCT_IF_C F_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu8i, F_BFu8ll_BFu8i)
//============================================================================


struct  F_BFu8ll_BFu8ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 F_BFu8ll_BFu8ll) C1{ Fi FL:8 FL:8}



static void Test_F_BFu8ll_BFu8ll()
{
  {
    init_simple_test("F_BFu8ll_BFu8ll");
    static STRUCT_IF_C F_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu8ll, F_BFu8ll_BFu8ll)
//============================================================================


struct  F_BFu8ll_BFu8s  {
  float v1;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 F_BFu8ll_BFu8s) C1{ Fi FL:8 Fs:8}



static void Test_F_BFu8ll_BFu8s()
{
  {
    init_simple_test("F_BFu8ll_BFu8s");
    static STRUCT_IF_C F_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu8s, F_BFu8ll_BFu8s)
//============================================================================


struct  F_BFu8ll_BFu9i  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 F_BFu8ll_BFu9i) C1{ Fi FL:8 Fi:9}



static void Test_F_BFu8ll_BFu9i()
{
  {
    init_simple_test("F_BFu8ll_BFu9i");
    static STRUCT_IF_C F_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu9i, F_BFu8ll_BFu9i)
//============================================================================


struct  F_BFu8ll_BFu9ll  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 F_BFu8ll_BFu9ll) C1{ Fi FL:8 FL:9}



static void Test_F_BFu8ll_BFu9ll()
{
  {
    init_simple_test("F_BFu8ll_BFu9ll");
    static STRUCT_IF_C F_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu9ll, F_BFu8ll_BFu9ll)
//============================================================================


struct  F_BFu8ll_BFu9s  {
  float v1;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 F_BFu8ll_BFu9s) C1{ Fi FL:8 Fs:9}



static void Test_F_BFu8ll_BFu9s()
{
  {
    init_simple_test("F_BFu8ll_BFu9s");
    static STRUCT_IF_C F_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_BFu9s, F_BFu8ll_BFu9s)
//============================================================================


struct  F_BFu8ll_C  {
  float v1;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 F_BFu8ll_C) C1{ Fi FL:8 Fc}



static void Test_F_BFu8ll_C()
{
  {
    init_simple_test("F_BFu8ll_C");
    static STRUCT_IF_C F_BFu8ll_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_C");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_C");
    check_field_offset(lv, v3, 5, "F_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_C, F_BFu8ll_C)
//============================================================================


struct  F_BFu8ll_D  {
  float v1;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 F_BFu8ll_D) C1{ Fi FL:8 FL}



static void Test_F_BFu8ll_D()
{
  {
    init_simple_test("F_BFu8ll_D");
    static STRUCT_IF_C F_BFu8ll_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_D");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_D");
    check_field_offset(lv, v3, 8, "F_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_D, F_BFu8ll_D)
//============================================================================


struct  F_BFu8ll_F  {
  float v1;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 F_BFu8ll_F) C1{ Fi FL:8 Fi}



static void Test_F_BFu8ll_F()
{
  {
    init_simple_test("F_BFu8ll_F");
    static STRUCT_IF_C F_BFu8ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_F");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_F");
    check_field_offset(lv, v3, 8, "F_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_F, F_BFu8ll_F)
//============================================================================


struct  F_BFu8ll_I  {
  float v1;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 F_BFu8ll_I) C1{ Fi FL:8 Fi}



static void Test_F_BFu8ll_I()
{
  {
    init_simple_test("F_BFu8ll_I");
    static STRUCT_IF_C F_BFu8ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_I");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_I");
    check_field_offset(lv, v3, 8, "F_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_I, F_BFu8ll_I)
//============================================================================


struct  F_BFu8ll_Ip  {
  float v1;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 F_BFu8ll_Ip) C1{ Fi FL:8 Fp}



static void Test_F_BFu8ll_Ip()
{
  {
    init_simple_test("F_BFu8ll_Ip");
    static STRUCT_IF_C F_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_Ip");
    check_field_offset(lv, v3, 8, "F_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_Ip, F_BFu8ll_Ip)
//============================================================================


struct  F_BFu8ll_L  {
  float v1;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 F_BFu8ll_L) C1{ Fi FL:8 FL}



static void Test_F_BFu8ll_L()
{
  {
    init_simple_test("F_BFu8ll_L");
    static STRUCT_IF_C F_BFu8ll_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_L");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_L");
    check_field_offset(lv, v3, 8, "F_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_L, F_BFu8ll_L)
//============================================================================


struct  F_BFu8ll_S  {
  float v1;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 F_BFu8ll_S) C1{ Fi FL:8 Fs}



static void Test_F_BFu8ll_S()
{
  {
    init_simple_test("F_BFu8ll_S");
    static STRUCT_IF_C F_BFu8ll_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_S");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_S");
    check_field_offset(lv, v3, 6, "F_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_S, F_BFu8ll_S)
//============================================================================


struct  F_BFu8ll_Uc  {
  float v1;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 F_BFu8ll_Uc) C1{ Fi FL:8 Fc}



static void Test_F_BFu8ll_Uc()
{
  {
    init_simple_test("F_BFu8ll_Uc");
    static STRUCT_IF_C F_BFu8ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_Uc");
    check_field_offset(lv, v3, 5, "F_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_Uc, F_BFu8ll_Uc)
//============================================================================


struct  F_BFu8ll_Ui  {
  float v1;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 F_BFu8ll_Ui) C1{ Fi FL:8 Fi}



static void Test_F_BFu8ll_Ui()
{
  {
    init_simple_test("F_BFu8ll_Ui");
    static STRUCT_IF_C F_BFu8ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_Ui");
    check_field_offset(lv, v3, 8, "F_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_Ui, F_BFu8ll_Ui)
//============================================================================


struct  F_BFu8ll_Ul  {
  float v1;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 F_BFu8ll_Ul) C1{ Fi FL:8 FL}



static void Test_F_BFu8ll_Ul()
{
  {
    init_simple_test("F_BFu8ll_Ul");
    static STRUCT_IF_C F_BFu8ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_Ul");
    check_field_offset(lv, v3, 8, "F_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_Ul, F_BFu8ll_Ul)
//============================================================================


struct  F_BFu8ll_Us  {
  float v1;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 F_BFu8ll_Us) C1{ Fi FL:8 Fs}



static void Test_F_BFu8ll_Us()
{
  {
    init_simple_test("F_BFu8ll_Us");
    static STRUCT_IF_C F_BFu8ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_Us");
    check_field_offset(lv, v3, 6, "F_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_Us, F_BFu8ll_Us)
//============================================================================


struct  F_BFu8ll_Vp  {
  float v1;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 F_BFu8ll_Vp) C1{ Fi FL:8 Fp}



static void Test_F_BFu8ll_Vp()
{
  {
    init_simple_test("F_BFu8ll_Vp");
    static STRUCT_IF_C F_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8ll_Vp");
    check_field_offset(lv, v3, 8, "F_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8ll_Vp, F_BFu8ll_Vp)
//============================================================================


struct  F_BFu8s  {
  float v1;
  unsigned short v2:8;
};
//SIG(1 F_BFu8s) C1{ Fi Fs:8}



static void Test_F_BFu8s()
{
  {
    init_simple_test("F_BFu8s");
    static STRUCT_IF_C F_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s, F_BFu8s)
//============================================================================


struct  F_BFu8s_BFu15i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 F_BFu8s_BFu15i) C1{ Fi Fs:8 Fi:15}



static void Test_F_BFu8s_BFu15i()
{
  {
    init_simple_test("F_BFu8s_BFu15i");
    static STRUCT_IF_C F_BFu8s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu15i, F_BFu8s_BFu15i)
//============================================================================


struct  F_BFu8s_BFu15ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 F_BFu8s_BFu15ll) C1{ Fi Fs:8 FL:15}



static void Test_F_BFu8s_BFu15ll()
{
  {
    init_simple_test("F_BFu8s_BFu15ll");
    static STRUCT_IF_C F_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu15ll, F_BFu8s_BFu15ll)
//============================================================================


struct  F_BFu8s_BFu15s  {
  float v1;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 F_BFu8s_BFu15s) C1{ Fi Fs:8 Fs:15}



static void Test_F_BFu8s_BFu15s()
{
  {
    init_simple_test("F_BFu8s_BFu15s");
    static STRUCT_IF_C F_BFu8s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu15s, F_BFu8s_BFu15s)
//============================================================================


struct  F_BFu8s_BFu16i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 F_BFu8s_BFu16i) C1{ Fi Fs:8 Fi:16}



static void Test_F_BFu8s_BFu16i()
{
  {
    init_simple_test("F_BFu8s_BFu16i");
    static STRUCT_IF_C F_BFu8s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu16i, F_BFu8s_BFu16i)
//============================================================================


struct  F_BFu8s_BFu16ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 F_BFu8s_BFu16ll) C1{ Fi Fs:8 FL:16}



static void Test_F_BFu8s_BFu16ll()
{
  {
    init_simple_test("F_BFu8s_BFu16ll");
    static STRUCT_IF_C F_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu16ll, F_BFu8s_BFu16ll)
//============================================================================


struct  F_BFu8s_BFu16s  {
  float v1;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 F_BFu8s_BFu16s) C1{ Fi Fs:8 Fs:16}



static void Test_F_BFu8s_BFu16s()
{
  {
    init_simple_test("F_BFu8s_BFu16s");
    static STRUCT_IF_C F_BFu8s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu16s, F_BFu8s_BFu16s)
//============================================================================


struct  F_BFu8s_BFu17i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 F_BFu8s_BFu17i) C1{ Fi Fs:8 Fi:17}



static void Test_F_BFu8s_BFu17i()
{
  {
    init_simple_test("F_BFu8s_BFu17i");
    static STRUCT_IF_C F_BFu8s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu17i, F_BFu8s_BFu17i)
//============================================================================


struct  F_BFu8s_BFu17ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 F_BFu8s_BFu17ll) C1{ Fi Fs:8 FL:17}



static void Test_F_BFu8s_BFu17ll()
{
  {
    init_simple_test("F_BFu8s_BFu17ll");
    static STRUCT_IF_C F_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu17ll, F_BFu8s_BFu17ll)
//============================================================================


struct  F_BFu8s_BFu1c  {
  float v1;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 F_BFu8s_BFu1c) C1{ Fi Fs:8 Fc:1}



static void Test_F_BFu8s_BFu1c()
{
  {
    init_simple_test("F_BFu8s_BFu1c");
    static STRUCT_IF_C F_BFu8s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu1c, F_BFu8s_BFu1c)
//============================================================================


struct  F_BFu8s_BFu1i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 F_BFu8s_BFu1i) C1{ Fi Fs:8 Fi:1}



static void Test_F_BFu8s_BFu1i()
{
  {
    init_simple_test("F_BFu8s_BFu1i");
    static STRUCT_IF_C F_BFu8s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu1i, F_BFu8s_BFu1i)
//============================================================================


struct  F_BFu8s_BFu1ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 F_BFu8s_BFu1ll) C1{ Fi Fs:8 FL:1}



static void Test_F_BFu8s_BFu1ll()
{
  {
    init_simple_test("F_BFu8s_BFu1ll");
    static STRUCT_IF_C F_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu1ll, F_BFu8s_BFu1ll)
//============================================================================


struct  F_BFu8s_BFu1s  {
  float v1;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 F_BFu8s_BFu1s) C1{ Fi Fs:8 Fs:1}



static void Test_F_BFu8s_BFu1s()
{
  {
    init_simple_test("F_BFu8s_BFu1s");
    static STRUCT_IF_C F_BFu8s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu1s, F_BFu8s_BFu1s)
//============================================================================


struct  F_BFu8s_BFu31i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 F_BFu8s_BFu31i) C1{ Fi Fs:8 Fi:31}



static void Test_F_BFu8s_BFu31i()
{
  {
    init_simple_test("F_BFu8s_BFu31i");
    static STRUCT_IF_C F_BFu8s_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu31i, F_BFu8s_BFu31i)
//============================================================================


struct  F_BFu8s_BFu31ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 F_BFu8s_BFu31ll) C1{ Fi Fs:8 FL:31}



static void Test_F_BFu8s_BFu31ll()
{
  {
    init_simple_test("F_BFu8s_BFu31ll");
    static STRUCT_IF_C F_BFu8s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "F_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "F_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu31ll, F_BFu8s_BFu31ll)
//============================================================================


struct  F_BFu8s_BFu32i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 F_BFu8s_BFu32i) C1{ Fi Fs:8 Fi:32}



static void Test_F_BFu8s_BFu32i()
{
  {
    init_simple_test("F_BFu8s_BFu32i");
    static STRUCT_IF_C F_BFu8s_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu32i, F_BFu8s_BFu32i)
//============================================================================


struct  F_BFu8s_BFu32ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 F_BFu8s_BFu32ll) C1{ Fi Fs:8 FL:32}



static void Test_F_BFu8s_BFu32ll()
{
  {
    init_simple_test("F_BFu8s_BFu32ll");
    static STRUCT_IF_C F_BFu8s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "F_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "F_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu32ll, F_BFu8s_BFu32ll)
//============================================================================


struct  F_BFu8s_BFu33  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:33;
};
//SIG(1 F_BFu8s_BFu33) C1{ Fi Fs:8 FL:33}



static void Test_F_BFu8s_BFu33()
{
  {
    init_simple_test("F_BFu8s_BFu33");
    static STRUCT_IF_C F_BFu8s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "F_BFu8s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "F_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu33, F_BFu8s_BFu33)
//============================================================================


struct  F_BFu8s_BFu7c  {
  float v1;
  unsigned short v2:8;
  unsigned char v3:7;
};
//SIG(1 F_BFu8s_BFu7c) C1{ Fi Fs:8 Fc:7}



static void Test_F_BFu8s_BFu7c()
{
  {
    init_simple_test("F_BFu8s_BFu7c");
    static STRUCT_IF_C F_BFu8s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu7c, F_BFu8s_BFu7c)
//============================================================================


struct  F_BFu8s_BFu7i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:7;
};
//SIG(1 F_BFu8s_BFu7i) C1{ Fi Fs:8 Fi:7}



static void Test_F_BFu8s_BFu7i()
{
  {
    init_simple_test("F_BFu8s_BFu7i");
    static STRUCT_IF_C F_BFu8s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu7i, F_BFu8s_BFu7i)
//============================================================================


struct  F_BFu8s_BFu7ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 F_BFu8s_BFu7ll) C1{ Fi Fs:8 FL:7}



static void Test_F_BFu8s_BFu7ll()
{
  {
    init_simple_test("F_BFu8s_BFu7ll");
    static STRUCT_IF_C F_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu7ll, F_BFu8s_BFu7ll)
//============================================================================


struct  F_BFu8s_BFu7s  {
  float v1;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 F_BFu8s_BFu7s) C1{ Fi Fs:8 Fs:7}



static void Test_F_BFu8s_BFu7s()
{
  {
    init_simple_test("F_BFu8s_BFu7s");
    static STRUCT_IF_C F_BFu8s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu7s, F_BFu8s_BFu7s)
//============================================================================


struct  F_BFu8s_BFu8c  {
  float v1;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 F_BFu8s_BFu8c) C1{ Fi Fs:8 Fc:8}



static void Test_F_BFu8s_BFu8c()
{
  {
    init_simple_test("F_BFu8s_BFu8c");
    static STRUCT_IF_C F_BFu8s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu8c, F_BFu8s_BFu8c)
//============================================================================


struct  F_BFu8s_BFu8i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 F_BFu8s_BFu8i) C1{ Fi Fs:8 Fi:8}



static void Test_F_BFu8s_BFu8i()
{
  {
    init_simple_test("F_BFu8s_BFu8i");
    static STRUCT_IF_C F_BFu8s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu8i, F_BFu8s_BFu8i)
//============================================================================


struct  F_BFu8s_BFu8ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 F_BFu8s_BFu8ll) C1{ Fi Fs:8 FL:8}



static void Test_F_BFu8s_BFu8ll()
{
  {
    init_simple_test("F_BFu8s_BFu8ll");
    static STRUCT_IF_C F_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu8ll, F_BFu8s_BFu8ll)
//============================================================================


struct  F_BFu8s_BFu8s  {
  float v1;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 F_BFu8s_BFu8s) C1{ Fi Fs:8 Fs:8}



static void Test_F_BFu8s_BFu8s()
{
  {
    init_simple_test("F_BFu8s_BFu8s");
    static STRUCT_IF_C F_BFu8s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu8s, F_BFu8s_BFu8s)
//============================================================================


struct  F_BFu8s_BFu9i  {
  float v1;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 F_BFu8s_BFu9i) C1{ Fi Fs:8 Fi:9}



static void Test_F_BFu8s_BFu9i()
{
  {
    init_simple_test("F_BFu8s_BFu9i");
    static STRUCT_IF_C F_BFu8s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu9i, F_BFu8s_BFu9i)
//============================================================================


struct  F_BFu8s_BFu9ll  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 F_BFu8s_BFu9ll) C1{ Fi Fs:8 FL:9}



static void Test_F_BFu8s_BFu9ll()
{
  {
    init_simple_test("F_BFu8s_BFu9ll");
    static STRUCT_IF_C F_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu9ll, F_BFu8s_BFu9ll)
//============================================================================


struct  F_BFu8s_BFu9s  {
  float v1;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 F_BFu8s_BFu9s) C1{ Fi Fs:8 Fs:9}



static void Test_F_BFu8s_BFu9s()
{
  {
    init_simple_test("F_BFu8s_BFu9s");
    static STRUCT_IF_C F_BFu8s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_BFu9s, F_BFu8s_BFu9s)
//============================================================================


struct  F_BFu8s_C  {
  float v1;
  unsigned short v2:8;
  char v3;
};
//SIG(1 F_BFu8s_C) C1{ Fi Fs:8 Fc}



static void Test_F_BFu8s_C()
{
  {
    init_simple_test("F_BFu8s_C");
    static STRUCT_IF_C F_BFu8s_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_C)");
    check_field_offset(lv, v1, 0, "F_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_C");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_C");
    check_field_offset(lv, v3, 5, "F_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_C, F_BFu8s_C)
//============================================================================


struct  F_BFu8s_D  {
  float v1;
  unsigned short v2:8;
  double v3;
};
//SIG(1 F_BFu8s_D) C1{ Fi Fs:8 FL}



static void Test_F_BFu8s_D()
{
  {
    init_simple_test("F_BFu8s_D");
    static STRUCT_IF_C F_BFu8s_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_D)");
    check_field_offset(lv, v1, 0, "F_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_D");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_D");
    check_field_offset(lv, v3, 8, "F_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_D, F_BFu8s_D)
//============================================================================


struct  F_BFu8s_F  {
  float v1;
  unsigned short v2:8;
  float v3;
};
//SIG(1 F_BFu8s_F) C1{ Fi Fs:8 Fi}



static void Test_F_BFu8s_F()
{
  {
    init_simple_test("F_BFu8s_F");
    static STRUCT_IF_C F_BFu8s_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8s_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_F)");
    check_field_offset(lv, v1, 0, "F_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_F");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_F");
    check_field_offset(lv, v3, 8, "F_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_F, F_BFu8s_F)
//============================================================================


struct  F_BFu8s_I  {
  float v1;
  unsigned short v2:8;
  int v3;
};
//SIG(1 F_BFu8s_I) C1{ Fi Fs:8 Fi}



static void Test_F_BFu8s_I()
{
  {
    init_simple_test("F_BFu8s_I");
    static STRUCT_IF_C F_BFu8s_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8s_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_I)");
    check_field_offset(lv, v1, 0, "F_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_I");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_I");
    check_field_offset(lv, v3, 8, "F_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_I, F_BFu8s_I)
//============================================================================


struct  F_BFu8s_Ip  {
  float v1;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 F_BFu8s_Ip) C1{ Fi Fs:8 Fp}



static void Test_F_BFu8s_Ip()
{
  {
    init_simple_test("F_BFu8s_Ip");
    static STRUCT_IF_C F_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_Ip");
    check_field_offset(lv, v3, 8, "F_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_Ip, F_BFu8s_Ip)
//============================================================================


struct  F_BFu8s_L  {
  float v1;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 F_BFu8s_L) C1{ Fi Fs:8 FL}



static void Test_F_BFu8s_L()
{
  {
    init_simple_test("F_BFu8s_L");
    static STRUCT_IF_C F_BFu8s_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_L)");
    check_field_offset(lv, v1, 0, "F_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_L");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_L");
    check_field_offset(lv, v3, 8, "F_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_L, F_BFu8s_L)
//============================================================================


struct  F_BFu8s_S  {
  float v1;
  unsigned short v2:8;
  short v3;
};
//SIG(1 F_BFu8s_S) C1{ Fi Fs:8 Fs}



static void Test_F_BFu8s_S()
{
  {
    init_simple_test("F_BFu8s_S");
    static STRUCT_IF_C F_BFu8s_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_S)");
    check_field_offset(lv, v1, 0, "F_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_S");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_S");
    check_field_offset(lv, v3, 6, "F_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_S, F_BFu8s_S)
//============================================================================


struct  F_BFu8s_Uc  {
  float v1;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 F_BFu8s_Uc) C1{ Fi Fs:8 Fc}



static void Test_F_BFu8s_Uc()
{
  {
    init_simple_test("F_BFu8s_Uc");
    static STRUCT_IF_C F_BFu8s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_Uc");
    check_field_offset(lv, v3, 5, "F_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_Uc, F_BFu8s_Uc)
//============================================================================


struct  F_BFu8s_Ui  {
  float v1;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 F_BFu8s_Ui) C1{ Fi Fs:8 Fi}



static void Test_F_BFu8s_Ui()
{
  {
    init_simple_test("F_BFu8s_Ui");
    static STRUCT_IF_C F_BFu8s_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu8s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_Ui");
    check_field_offset(lv, v3, 8, "F_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_Ui, F_BFu8s_Ui)
//============================================================================


struct  F_BFu8s_Ul  {
  float v1;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 F_BFu8s_Ul) C1{ Fi Fs:8 FL}



static void Test_F_BFu8s_Ul()
{
  {
    init_simple_test("F_BFu8s_Ul");
    static STRUCT_IF_C F_BFu8s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_Ul");
    check_field_offset(lv, v3, 8, "F_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_Ul, F_BFu8s_Ul)
//============================================================================


struct  F_BFu8s_Us  {
  float v1;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 F_BFu8s_Us) C1{ Fi Fs:8 Fs}



static void Test_F_BFu8s_Us()
{
  {
    init_simple_test("F_BFu8s_Us");
    static STRUCT_IF_C F_BFu8s_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu8s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "F_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_Us");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_Us");
    check_field_offset(lv, v3, 6, "F_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_Us, F_BFu8s_Us)
//============================================================================


struct  F_BFu8s_Vp  {
  float v1;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 F_BFu8s_Vp) C1{ Fi Fs:8 Fp}



static void Test_F_BFu8s_Vp()
{
  {
    init_simple_test("F_BFu8s_Vp");
    static STRUCT_IF_C F_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "F_BFu8s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "F_BFu8s_Vp");
    check_field_offset(lv, v3, 8, "F_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu8s_Vp, F_BFu8s_Vp)
//============================================================================


struct  F_BFu9i  {
  float v1;
  unsigned int v2:9;
};
//SIG(1 F_BFu9i) C1{ Fi Fi:9}



static void Test_F_BFu9i()
{
  {
    init_simple_test("F_BFu9i");
    static STRUCT_IF_C F_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i, F_BFu9i)
//============================================================================


struct  F_BFu9i_BFu15i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 F_BFu9i_BFu15i) C1{ Fi Fi:9 Fi:15}



static void Test_F_BFu9i_BFu15i()
{
  {
    init_simple_test("F_BFu9i_BFu15i");
    static STRUCT_IF_C F_BFu9i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "F_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "F_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu15i, F_BFu9i_BFu15i)
//============================================================================


struct  F_BFu9i_BFu15ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 F_BFu9i_BFu15ll) C1{ Fi Fi:9 FL:15}



static void Test_F_BFu9i_BFu15ll()
{
  {
    init_simple_test("F_BFu9i_BFu15ll");
    static STRUCT_IF_C F_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "F_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "F_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu15ll, F_BFu9i_BFu15ll)
//============================================================================


struct  F_BFu9i_BFu15s  {
  float v1;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 F_BFu9i_BFu15s) C1{ Fi Fi:9 Fs:15}



static void Test_F_BFu9i_BFu15s()
{
  {
    init_simple_test("F_BFu9i_BFu15s");
    static STRUCT_IF_C F_BFu9i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu15s, F_BFu9i_BFu15s)
//============================================================================


struct  F_BFu9i_BFu16i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 F_BFu9i_BFu16i) C1{ Fi Fi:9 Fi:16}



static void Test_F_BFu9i_BFu16i()
{
  {
    init_simple_test("F_BFu9i_BFu16i");
    static STRUCT_IF_C F_BFu9i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "F_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "F_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu16i, F_BFu9i_BFu16i)
//============================================================================


struct  F_BFu9i_BFu16ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 F_BFu9i_BFu16ll) C1{ Fi Fi:9 FL:16}



static void Test_F_BFu9i_BFu16ll()
{
  {
    init_simple_test("F_BFu9i_BFu16ll");
    static STRUCT_IF_C F_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "F_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "F_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu16ll, F_BFu9i_BFu16ll)
//============================================================================


struct  F_BFu9i_BFu16s  {
  float v1;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 F_BFu9i_BFu16s) C1{ Fi Fi:9 Fs:16}



static void Test_F_BFu9i_BFu16s()
{
  {
    init_simple_test("F_BFu9i_BFu16s");
    static STRUCT_IF_C F_BFu9i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu16s, F_BFu9i_BFu16s)
//============================================================================


struct  F_BFu9i_BFu17i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 F_BFu9i_BFu17i) C1{ Fi Fi:9 Fi:17}



static void Test_F_BFu9i_BFu17i()
{
  {
    init_simple_test("F_BFu9i_BFu17i");
    static STRUCT_IF_C F_BFu9i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "F_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "F_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu17i, F_BFu9i_BFu17i)
//============================================================================


struct  F_BFu9i_BFu17ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 F_BFu9i_BFu17ll) C1{ Fi Fi:9 FL:17}



static void Test_F_BFu9i_BFu17ll()
{
  {
    init_simple_test("F_BFu9i_BFu17ll");
    static STRUCT_IF_C F_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "F_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "F_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu17ll, F_BFu9i_BFu17ll)
//============================================================================


struct  F_BFu9i_BFu1c  {
  float v1;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 F_BFu9i_BFu1c) C1{ Fi Fi:9 Fc:1}



static void Test_F_BFu9i_BFu1c()
{
  {
    init_simple_test("F_BFu9i_BFu1c");
    static STRUCT_IF_C F_BFu9i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu1c, F_BFu9i_BFu1c)
//============================================================================


struct  F_BFu9i_BFu1i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 F_BFu9i_BFu1i) C1{ Fi Fi:9 Fi:1}



static void Test_F_BFu9i_BFu1i()
{
  {
    init_simple_test("F_BFu9i_BFu1i");
    static STRUCT_IF_C F_BFu9i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu1i, F_BFu9i_BFu1i)
//============================================================================


struct  F_BFu9i_BFu1ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 F_BFu9i_BFu1ll) C1{ Fi Fi:9 FL:1}



static void Test_F_BFu9i_BFu1ll()
{
  {
    init_simple_test("F_BFu9i_BFu1ll");
    static STRUCT_IF_C F_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu1ll, F_BFu9i_BFu1ll)
//============================================================================


struct  F_BFu9i_BFu1s  {
  float v1;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 F_BFu9i_BFu1s) C1{ Fi Fi:9 Fs:1}



static void Test_F_BFu9i_BFu1s()
{
  {
    init_simple_test("F_BFu9i_BFu1s");
    static STRUCT_IF_C F_BFu9i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu1s, F_BFu9i_BFu1s)
//============================================================================


struct  F_BFu9i_BFu31i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 F_BFu9i_BFu31i) C1{ Fi Fi:9 Fi:31}



static void Test_F_BFu9i_BFu31i()
{
  {
    init_simple_test("F_BFu9i_BFu31i");
    static STRUCT_IF_C F_BFu9i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu31i, F_BFu9i_BFu31i)
//============================================================================


struct  F_BFu9i_BFu31ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 F_BFu9i_BFu31ll) C1{ Fi Fi:9 FL:31}



static void Test_F_BFu9i_BFu31ll()
{
  {
    init_simple_test("F_BFu9i_BFu31ll");
    static STRUCT_IF_C F_BFu9i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, 1, "F_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, hide_ull(1LL<<30), "F_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu31ll, F_BFu9i_BFu31ll)
//============================================================================


struct  F_BFu9i_BFu32i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 F_BFu9i_BFu32i) C1{ Fi Fi:9 Fi:32}



static void Test_F_BFu9i_BFu32i()
{
  {
    init_simple_test("F_BFu9i_BFu32i");
    static STRUCT_IF_C F_BFu9i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu32i, F_BFu9i_BFu32i)
//============================================================================


struct  F_BFu9i_BFu32ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 F_BFu9i_BFu32ll) C1{ Fi Fi:9 FL:32}



static void Test_F_BFu9i_BFu32ll()
{
  {
    init_simple_test("F_BFu9i_BFu32ll");
    static STRUCT_IF_C F_BFu9i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, 1, "F_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, hide_ull(1LL<<31), "F_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu32ll, F_BFu9i_BFu32ll)
//============================================================================


struct  F_BFu9i_BFu33  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 F_BFu9i_BFu33) C1{ Fi Fi:9 FL:33}



static void Test_F_BFu9i_BFu33()
{
  {
    init_simple_test("F_BFu9i_BFu33");
    static STRUCT_IF_C F_BFu9i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, 1, "F_BFu9i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, hide_ull(1LL<<32), "F_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu33, F_BFu9i_BFu33)
//============================================================================


struct  F_BFu9i_BFu7c  {
  float v1;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 F_BFu9i_BFu7c) C1{ Fi Fi:9 Fc:7}



static void Test_F_BFu9i_BFu7c()
{
  {
    init_simple_test("F_BFu9i_BFu7c");
    static STRUCT_IF_C F_BFu9i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu7c, F_BFu9i_BFu7c)
//============================================================================


struct  F_BFu9i_BFu7i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 F_BFu9i_BFu7i) C1{ Fi Fi:9 Fi:7}



static void Test_F_BFu9i_BFu7i()
{
  {
    init_simple_test("F_BFu9i_BFu7i");
    static STRUCT_IF_C F_BFu9i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu7i, F_BFu9i_BFu7i)
//============================================================================


struct  F_BFu9i_BFu7ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 F_BFu9i_BFu7ll) C1{ Fi Fi:9 FL:7}



static void Test_F_BFu9i_BFu7ll()
{
  {
    init_simple_test("F_BFu9i_BFu7ll");
    static STRUCT_IF_C F_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu7ll, F_BFu9i_BFu7ll)
//============================================================================


struct  F_BFu9i_BFu7s  {
  float v1;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 F_BFu9i_BFu7s) C1{ Fi Fi:9 Fs:7}



static void Test_F_BFu9i_BFu7s()
{
  {
    init_simple_test("F_BFu9i_BFu7s");
    static STRUCT_IF_C F_BFu9i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu7s, F_BFu9i_BFu7s)
//============================================================================


struct  F_BFu9i_BFu8c  {
  float v1;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 F_BFu9i_BFu8c) C1{ Fi Fi:9 Fc:8}



static void Test_F_BFu9i_BFu8c()
{
  {
    init_simple_test("F_BFu9i_BFu8c");
    static STRUCT_IF_C F_BFu9i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu8c, F_BFu9i_BFu8c)
//============================================================================


struct  F_BFu9i_BFu8i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 F_BFu9i_BFu8i) C1{ Fi Fi:9 Fi:8}



static void Test_F_BFu9i_BFu8i()
{
  {
    init_simple_test("F_BFu9i_BFu8i");
    static STRUCT_IF_C F_BFu9i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "F_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "F_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu8i, F_BFu9i_BFu8i)
//============================================================================


struct  F_BFu9i_BFu8ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 F_BFu9i_BFu8ll) C1{ Fi Fi:9 FL:8}



static void Test_F_BFu9i_BFu8ll()
{
  {
    init_simple_test("F_BFu9i_BFu8ll");
    static STRUCT_IF_C F_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "F_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "F_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu8ll, F_BFu9i_BFu8ll)
//============================================================================


struct  F_BFu9i_BFu8s  {
  float v1;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 F_BFu9i_BFu8s) C1{ Fi Fi:9 Fs:8}



static void Test_F_BFu9i_BFu8s()
{
  {
    init_simple_test("F_BFu9i_BFu8s");
    static STRUCT_IF_C F_BFu9i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu8s, F_BFu9i_BFu8s)
//============================================================================


struct  F_BFu9i_BFu9i  {
  float v1;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 F_BFu9i_BFu9i) C1{ Fi Fi:9 Fi:9}



static void Test_F_BFu9i_BFu9i()
{
  {
    init_simple_test("F_BFu9i_BFu9i");
    static STRUCT_IF_C F_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "F_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "F_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu9i, F_BFu9i_BFu9i)
//============================================================================


struct  F_BFu9i_BFu9ll  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 F_BFu9i_BFu9ll) C1{ Fi Fi:9 FL:9}



static void Test_F_BFu9i_BFu9ll()
{
  {
    init_simple_test("F_BFu9i_BFu9ll");
    static STRUCT_IF_C F_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "F_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "F_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu9ll, F_BFu9i_BFu9ll)
//============================================================================


struct  F_BFu9i_BFu9s  {
  float v1;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 F_BFu9i_BFu9s) C1{ Fi Fi:9 Fs:9}



static void Test_F_BFu9i_BFu9s()
{
  {
    init_simple_test("F_BFu9i_BFu9s");
    static STRUCT_IF_C F_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_BFu9s, F_BFu9i_BFu9s)
//============================================================================


struct  F_BFu9i_C  {
  float v1;
  unsigned int v2:9;
  char v3;
};
//SIG(1 F_BFu9i_C) C1{ Fi Fi:9 Fc}



static void Test_F_BFu9i_C()
{
  {
    init_simple_test("F_BFu9i_C");
    static STRUCT_IF_C F_BFu9i_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_C)");
    check_field_offset(lv, v1, 0, "F_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_C");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_C");
    check_field_offset(lv, v3, 6, "F_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_C, F_BFu9i_C)
//============================================================================


struct  F_BFu9i_D  {
  float v1;
  unsigned int v2:9;
  double v3;
};
//SIG(1 F_BFu9i_D) C1{ Fi Fi:9 FL}



static void Test_F_BFu9i_D()
{
  {
    init_simple_test("F_BFu9i_D");
    static STRUCT_IF_C F_BFu9i_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_D)");
    check_field_offset(lv, v1, 0, "F_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_D");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_D");
    check_field_offset(lv, v3, 8, "F_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_D, F_BFu9i_D)
//============================================================================


struct  F_BFu9i_F  {
  float v1;
  unsigned int v2:9;
  float v3;
};
//SIG(1 F_BFu9i_F) C1{ Fi Fi:9 Fi}



static void Test_F_BFu9i_F()
{
  {
    init_simple_test("F_BFu9i_F");
    static STRUCT_IF_C F_BFu9i_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9i_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_F)");
    check_field_offset(lv, v1, 0, "F_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_F");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_F");
    check_field_offset(lv, v3, 8, "F_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_F, F_BFu9i_F)
//============================================================================


struct  F_BFu9i_I  {
  float v1;
  unsigned int v2:9;
  int v3;
};
//SIG(1 F_BFu9i_I) C1{ Fi Fi:9 Fi}



static void Test_F_BFu9i_I()
{
  {
    init_simple_test("F_BFu9i_I");
    static STRUCT_IF_C F_BFu9i_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9i_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_I)");
    check_field_offset(lv, v1, 0, "F_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_I");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_I");
    check_field_offset(lv, v3, 8, "F_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_I, F_BFu9i_I)
//============================================================================


struct  F_BFu9i_Ip  {
  float v1;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 F_BFu9i_Ip) C1{ Fi Fi:9 Fp}



static void Test_F_BFu9i_Ip()
{
  {
    init_simple_test("F_BFu9i_Ip");
    static STRUCT_IF_C F_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_Ip");
    check_field_offset(lv, v3, 8, "F_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_Ip, F_BFu9i_Ip)
//============================================================================


struct  F_BFu9i_L  {
  float v1;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 F_BFu9i_L) C1{ Fi Fi:9 FL}



static void Test_F_BFu9i_L()
{
  {
    init_simple_test("F_BFu9i_L");
    static STRUCT_IF_C F_BFu9i_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_L)");
    check_field_offset(lv, v1, 0, "F_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_L");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_L");
    check_field_offset(lv, v3, 8, "F_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_L, F_BFu9i_L)
//============================================================================


struct  F_BFu9i_S  {
  float v1;
  unsigned int v2:9;
  short v3;
};
//SIG(1 F_BFu9i_S) C1{ Fi Fi:9 Fs}



static void Test_F_BFu9i_S()
{
  {
    init_simple_test("F_BFu9i_S");
    static STRUCT_IF_C F_BFu9i_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_S)");
    check_field_offset(lv, v1, 0, "F_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_S");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_S");
    check_field_offset(lv, v3, 6, "F_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_S, F_BFu9i_S)
//============================================================================


struct  F_BFu9i_Uc  {
  float v1;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 F_BFu9i_Uc) C1{ Fi Fi:9 Fc}



static void Test_F_BFu9i_Uc()
{
  {
    init_simple_test("F_BFu9i_Uc");
    static STRUCT_IF_C F_BFu9i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_Uc");
    check_field_offset(lv, v3, 6, "F_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_Uc, F_BFu9i_Uc)
//============================================================================


struct  F_BFu9i_Ui  {
  float v1;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 F_BFu9i_Ui) C1{ Fi Fi:9 Fi}



static void Test_F_BFu9i_Ui()
{
  {
    init_simple_test("F_BFu9i_Ui");
    static STRUCT_IF_C F_BFu9i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_Ui");
    check_field_offset(lv, v3, 8, "F_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_Ui, F_BFu9i_Ui)
//============================================================================


struct  F_BFu9i_Ul  {
  float v1;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 F_BFu9i_Ul) C1{ Fi Fi:9 FL}



static void Test_F_BFu9i_Ul()
{
  {
    init_simple_test("F_BFu9i_Ul");
    static STRUCT_IF_C F_BFu9i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_Ul");
    check_field_offset(lv, v3, 8, "F_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_Ul, F_BFu9i_Ul)
//============================================================================


struct  F_BFu9i_Us  {
  float v1;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 F_BFu9i_Us) C1{ Fi Fi:9 Fs}



static void Test_F_BFu9i_Us()
{
  {
    init_simple_test("F_BFu9i_Us");
    static STRUCT_IF_C F_BFu9i_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_Us");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_Us");
    check_field_offset(lv, v3, 6, "F_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_Us, F_BFu9i_Us)
//============================================================================


struct  F_BFu9i_Vp  {
  float v1;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 F_BFu9i_Vp) C1{ Fi Fi:9 Fp}



static void Test_F_BFu9i_Vp()
{
  {
    init_simple_test("F_BFu9i_Vp");
    static STRUCT_IF_C F_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9i_Vp");
    check_field_offset(lv, v3, 8, "F_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9i_Vp, F_BFu9i_Vp)
//============================================================================


struct  F_BFu9ll  {
  float v1;
  __tsu64 v2:9;
};
//SIG(1 F_BFu9ll) C1{ Fi FL:9}



static void Test_F_BFu9ll()
{
  {
    init_simple_test("F_BFu9ll");
    static STRUCT_IF_C F_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll, F_BFu9ll)
//============================================================================


struct  F_BFu9ll_BFu15i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 F_BFu9ll_BFu15i) C1{ Fi FL:9 Fi:15}



static void Test_F_BFu9ll_BFu15i()
{
  {
    init_simple_test("F_BFu9ll_BFu15i");
    static STRUCT_IF_C F_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "F_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "F_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu15i, F_BFu9ll_BFu15i)
//============================================================================


struct  F_BFu9ll_BFu15ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 F_BFu9ll_BFu15ll) C1{ Fi FL:9 FL:15}



static void Test_F_BFu9ll_BFu15ll()
{
  {
    init_simple_test("F_BFu9ll_BFu15ll");
    static STRUCT_IF_C F_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "F_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "F_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu15ll, F_BFu9ll_BFu15ll)
//============================================================================


struct  F_BFu9ll_BFu15s  {
  float v1;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 F_BFu9ll_BFu15s) C1{ Fi FL:9 Fs:15}



static void Test_F_BFu9ll_BFu15s()
{
  {
    init_simple_test("F_BFu9ll_BFu15s");
    static STRUCT_IF_C F_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu15s, F_BFu9ll_BFu15s)
//============================================================================


struct  F_BFu9ll_BFu16i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 F_BFu9ll_BFu16i) C1{ Fi FL:9 Fi:16}



static void Test_F_BFu9ll_BFu16i()
{
  {
    init_simple_test("F_BFu9ll_BFu16i");
    static STRUCT_IF_C F_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "F_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "F_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu16i, F_BFu9ll_BFu16i)
//============================================================================


struct  F_BFu9ll_BFu16ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 F_BFu9ll_BFu16ll) C1{ Fi FL:9 FL:16}



static void Test_F_BFu9ll_BFu16ll()
{
  {
    init_simple_test("F_BFu9ll_BFu16ll");
    static STRUCT_IF_C F_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "F_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "F_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu16ll, F_BFu9ll_BFu16ll)
//============================================================================


struct  F_BFu9ll_BFu16s  {
  float v1;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 F_BFu9ll_BFu16s) C1{ Fi FL:9 Fs:16}



static void Test_F_BFu9ll_BFu16s()
{
  {
    init_simple_test("F_BFu9ll_BFu16s");
    static STRUCT_IF_C F_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu16s, F_BFu9ll_BFu16s)
//============================================================================


struct  F_BFu9ll_BFu17i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 F_BFu9ll_BFu17i) C1{ Fi FL:9 Fi:17}



static void Test_F_BFu9ll_BFu17i()
{
  {
    init_simple_test("F_BFu9ll_BFu17i");
    static STRUCT_IF_C F_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "F_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "F_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu17i, F_BFu9ll_BFu17i)
//============================================================================


struct  F_BFu9ll_BFu17ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 F_BFu9ll_BFu17ll) C1{ Fi FL:9 FL:17}



static void Test_F_BFu9ll_BFu17ll()
{
  {
    init_simple_test("F_BFu9ll_BFu17ll");
    static STRUCT_IF_C F_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "F_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "F_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu17ll, F_BFu9ll_BFu17ll)
//============================================================================


struct  F_BFu9ll_BFu1c  {
  float v1;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 F_BFu9ll_BFu1c) C1{ Fi FL:9 Fc:1}



static void Test_F_BFu9ll_BFu1c()
{
  {
    init_simple_test("F_BFu9ll_BFu1c");
    static STRUCT_IF_C F_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu1c, F_BFu9ll_BFu1c)
//============================================================================


struct  F_BFu9ll_BFu1i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 F_BFu9ll_BFu1i) C1{ Fi FL:9 Fi:1}



static void Test_F_BFu9ll_BFu1i()
{
  {
    init_simple_test("F_BFu9ll_BFu1i");
    static STRUCT_IF_C F_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu1i, F_BFu9ll_BFu1i)
//============================================================================


struct  F_BFu9ll_BFu1ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 F_BFu9ll_BFu1ll) C1{ Fi FL:9 FL:1}



static void Test_F_BFu9ll_BFu1ll()
{
  {
    init_simple_test("F_BFu9ll_BFu1ll");
    static STRUCT_IF_C F_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu1ll, F_BFu9ll_BFu1ll)
//============================================================================


struct  F_BFu9ll_BFu1s  {
  float v1;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 F_BFu9ll_BFu1s) C1{ Fi FL:9 Fs:1}



static void Test_F_BFu9ll_BFu1s()
{
  {
    init_simple_test("F_BFu9ll_BFu1s");
    static STRUCT_IF_C F_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu1s, F_BFu9ll_BFu1s)
//============================================================================


struct  F_BFu9ll_BFu31i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 F_BFu9ll_BFu31i) C1{ Fi FL:9 Fi:31}



static void Test_F_BFu9ll_BFu31i()
{
  {
    init_simple_test("F_BFu9ll_BFu31i");
    static STRUCT_IF_C F_BFu9ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu31i, F_BFu9ll_BFu31i)
//============================================================================


struct  F_BFu9ll_BFu31ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 F_BFu9ll_BFu31ll) C1{ Fi FL:9 FL:31}



static void Test_F_BFu9ll_BFu31ll()
{
  {
    init_simple_test("F_BFu9ll_BFu31ll");
    static STRUCT_IF_C F_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, 1, "F_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, hide_ull(1LL<<30), "F_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu31ll, F_BFu9ll_BFu31ll)
//============================================================================


struct  F_BFu9ll_BFu32i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 F_BFu9ll_BFu32i) C1{ Fi FL:9 Fi:32}



static void Test_F_BFu9ll_BFu32i()
{
  {
    init_simple_test("F_BFu9ll_BFu32i");
    static STRUCT_IF_C F_BFu9ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu32i, F_BFu9ll_BFu32i)
//============================================================================


struct  F_BFu9ll_BFu32ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 F_BFu9ll_BFu32ll) C1{ Fi FL:9 FL:32}



static void Test_F_BFu9ll_BFu32ll()
{
  {
    init_simple_test("F_BFu9ll_BFu32ll");
    static STRUCT_IF_C F_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, 1, "F_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, hide_ull(1LL<<31), "F_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu32ll, F_BFu9ll_BFu32ll)
//============================================================================


struct  F_BFu9ll_BFu33  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 F_BFu9ll_BFu33) C1{ Fi FL:9 FL:33}



static void Test_F_BFu9ll_BFu33()
{
  {
    init_simple_test("F_BFu9ll_BFu33");
    static STRUCT_IF_C F_BFu9ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, 1, "F_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, hide_ull(1LL<<32), "F_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu33, F_BFu9ll_BFu33)
//============================================================================


struct  F_BFu9ll_BFu7c  {
  float v1;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 F_BFu9ll_BFu7c) C1{ Fi FL:9 Fc:7}



static void Test_F_BFu9ll_BFu7c()
{
  {
    init_simple_test("F_BFu9ll_BFu7c");
    static STRUCT_IF_C F_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu7c, F_BFu9ll_BFu7c)
//============================================================================


struct  F_BFu9ll_BFu7i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:7;
};
//SIG(1 F_BFu9ll_BFu7i) C1{ Fi FL:9 Fi:7}



static void Test_F_BFu9ll_BFu7i()
{
  {
    init_simple_test("F_BFu9ll_BFu7i");
    static STRUCT_IF_C F_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu7i, F_BFu9ll_BFu7i)
//============================================================================


struct  F_BFu9ll_BFu7ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:7;
};
//SIG(1 F_BFu9ll_BFu7ll) C1{ Fi FL:9 FL:7}



static void Test_F_BFu9ll_BFu7ll()
{
  {
    init_simple_test("F_BFu9ll_BFu7ll");
    static STRUCT_IF_C F_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu7ll, F_BFu9ll_BFu7ll)
//============================================================================


struct  F_BFu9ll_BFu7s  {
  float v1;
  __tsu64 v2:9;
  unsigned short v3:7;
};
//SIG(1 F_BFu9ll_BFu7s) C1{ Fi FL:9 Fs:7}



static void Test_F_BFu9ll_BFu7s()
{
  {
    init_simple_test("F_BFu9ll_BFu7s");
    static STRUCT_IF_C F_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu7s, F_BFu9ll_BFu7s)
//============================================================================


struct  F_BFu9ll_BFu8c  {
  float v1;
  __tsu64 v2:9;
  unsigned char v3:8;
};
//SIG(1 F_BFu9ll_BFu8c) C1{ Fi FL:9 Fc:8}



static void Test_F_BFu9ll_BFu8c()
{
  {
    init_simple_test("F_BFu9ll_BFu8c");
    static STRUCT_IF_C F_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu8c, F_BFu9ll_BFu8c)
//============================================================================


struct  F_BFu9ll_BFu8i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:8;
};
//SIG(1 F_BFu9ll_BFu8i) C1{ Fi FL:9 Fi:8}



static void Test_F_BFu9ll_BFu8i()
{
  {
    init_simple_test("F_BFu9ll_BFu8i");
    static STRUCT_IF_C F_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "F_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "F_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu8i, F_BFu9ll_BFu8i)
//============================================================================


struct  F_BFu9ll_BFu8ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:8;
};
//SIG(1 F_BFu9ll_BFu8ll) C1{ Fi FL:9 FL:8}



static void Test_F_BFu9ll_BFu8ll()
{
  {
    init_simple_test("F_BFu9ll_BFu8ll");
    static STRUCT_IF_C F_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "F_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "F_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu8ll, F_BFu9ll_BFu8ll)
//============================================================================


struct  F_BFu9ll_BFu8s  {
  float v1;
  __tsu64 v2:9;
  unsigned short v3:8;
};
//SIG(1 F_BFu9ll_BFu8s) C1{ Fi FL:9 Fs:8}



static void Test_F_BFu9ll_BFu8s()
{
  {
    init_simple_test("F_BFu9ll_BFu8s");
    static STRUCT_IF_C F_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu8s, F_BFu9ll_BFu8s)
//============================================================================


struct  F_BFu9ll_BFu9i  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 F_BFu9ll_BFu9i) C1{ Fi FL:9 Fi:9}



static void Test_F_BFu9ll_BFu9i()
{
  {
    init_simple_test("F_BFu9ll_BFu9i");
    static STRUCT_IF_C F_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "F_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu9i, F_BFu9ll_BFu9i)
//============================================================================


struct  F_BFu9ll_BFu9ll  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 F_BFu9ll_BFu9ll) C1{ Fi FL:9 FL:9}



static void Test_F_BFu9ll_BFu9ll()
{
  {
    init_simple_test("F_BFu9ll_BFu9ll");
    static STRUCT_IF_C F_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "F_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu9ll, F_BFu9ll_BFu9ll)
//============================================================================


struct  F_BFu9ll_BFu9s  {
  float v1;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 F_BFu9ll_BFu9s) C1{ Fi FL:9 Fs:9}



static void Test_F_BFu9ll_BFu9s()
{
  {
    init_simple_test("F_BFu9ll_BFu9s");
    static STRUCT_IF_C F_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_BFu9s, F_BFu9ll_BFu9s)
//============================================================================


struct  F_BFu9ll_C  {
  float v1;
  __tsu64 v2:9;
  char v3;
};
//SIG(1 F_BFu9ll_C) C1{ Fi FL:9 Fc}



static void Test_F_BFu9ll_C()
{
  {
    init_simple_test("F_BFu9ll_C");
    static STRUCT_IF_C F_BFu9ll_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_C");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_C");
    check_field_offset(lv, v3, 6, "F_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_C, F_BFu9ll_C)
//============================================================================


struct  F_BFu9ll_D  {
  float v1;
  __tsu64 v2:9;
  double v3;
};
//SIG(1 F_BFu9ll_D) C1{ Fi FL:9 FL}



static void Test_F_BFu9ll_D()
{
  {
    init_simple_test("F_BFu9ll_D");
    static STRUCT_IF_C F_BFu9ll_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_D");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_D");
    check_field_offset(lv, v3, 8, "F_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_D, F_BFu9ll_D)
//============================================================================


struct  F_BFu9ll_F  {
  float v1;
  __tsu64 v2:9;
  float v3;
};
//SIG(1 F_BFu9ll_F) C1{ Fi FL:9 Fi}



static void Test_F_BFu9ll_F()
{
  {
    init_simple_test("F_BFu9ll_F");
    static STRUCT_IF_C F_BFu9ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_F");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_F");
    check_field_offset(lv, v3, 8, "F_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_F, F_BFu9ll_F)
//============================================================================


struct  F_BFu9ll_I  {
  float v1;
  __tsu64 v2:9;
  int v3;
};
//SIG(1 F_BFu9ll_I) C1{ Fi FL:9 Fi}



static void Test_F_BFu9ll_I()
{
  {
    init_simple_test("F_BFu9ll_I");
    static STRUCT_IF_C F_BFu9ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_I");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_I");
    check_field_offset(lv, v3, 8, "F_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_I, F_BFu9ll_I)
//============================================================================


struct  F_BFu9ll_Ip  {
  float v1;
  __tsu64 v2:9;
  int *v3;
};
//SIG(1 F_BFu9ll_Ip) C1{ Fi FL:9 Fp}



static void Test_F_BFu9ll_Ip()
{
  {
    init_simple_test("F_BFu9ll_Ip");
    static STRUCT_IF_C F_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_Ip");
    check_field_offset(lv, v3, 8, "F_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_Ip, F_BFu9ll_Ip)
//============================================================================


struct  F_BFu9ll_L  {
  float v1;
  __tsu64 v2:9;
  __tsi64 v3;
};
//SIG(1 F_BFu9ll_L) C1{ Fi FL:9 FL}



static void Test_F_BFu9ll_L()
{
  {
    init_simple_test("F_BFu9ll_L");
    static STRUCT_IF_C F_BFu9ll_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_L");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_L");
    check_field_offset(lv, v3, 8, "F_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_L, F_BFu9ll_L)
//============================================================================


struct  F_BFu9ll_S  {
  float v1;
  __tsu64 v2:9;
  short v3;
};
//SIG(1 F_BFu9ll_S) C1{ Fi FL:9 Fs}



static void Test_F_BFu9ll_S()
{
  {
    init_simple_test("F_BFu9ll_S");
    static STRUCT_IF_C F_BFu9ll_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_S");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_S");
    check_field_offset(lv, v3, 6, "F_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_S, F_BFu9ll_S)
//============================================================================


struct  F_BFu9ll_Uc  {
  float v1;
  __tsu64 v2:9;
  unsigned char v3;
};
//SIG(1 F_BFu9ll_Uc) C1{ Fi FL:9 Fc}



static void Test_F_BFu9ll_Uc()
{
  {
    init_simple_test("F_BFu9ll_Uc");
    static STRUCT_IF_C F_BFu9ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_Uc");
    check_field_offset(lv, v3, 6, "F_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_Uc, F_BFu9ll_Uc)
//============================================================================


struct  F_BFu9ll_Ui  {
  float v1;
  __tsu64 v2:9;
  unsigned int v3;
};
//SIG(1 F_BFu9ll_Ui) C1{ Fi FL:9 Fi}



static void Test_F_BFu9ll_Ui()
{
  {
    init_simple_test("F_BFu9ll_Ui");
    static STRUCT_IF_C F_BFu9ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_Ui");
    check_field_offset(lv, v3, 8, "F_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_Ui, F_BFu9ll_Ui)
//============================================================================


struct  F_BFu9ll_Ul  {
  float v1;
  __tsu64 v2:9;
  __tsu64 v3;
};
//SIG(1 F_BFu9ll_Ul) C1{ Fi FL:9 FL}



static void Test_F_BFu9ll_Ul()
{
  {
    init_simple_test("F_BFu9ll_Ul");
    static STRUCT_IF_C F_BFu9ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_Ul");
    check_field_offset(lv, v3, 8, "F_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_Ul, F_BFu9ll_Ul)
//============================================================================


struct  F_BFu9ll_Us  {
  float v1;
  __tsu64 v2:9;
  unsigned short v3;
};
//SIG(1 F_BFu9ll_Us) C1{ Fi FL:9 Fs}



static void Test_F_BFu9ll_Us()
{
  {
    init_simple_test("F_BFu9ll_Us");
    static STRUCT_IF_C F_BFu9ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_Us");
    check_field_offset(lv, v3, 6, "F_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_Us, F_BFu9ll_Us)
//============================================================================


struct  F_BFu9ll_Vp  {
  float v1;
  __tsu64 v2:9;
  void *v3;
};
//SIG(1 F_BFu9ll_Vp) C1{ Fi FL:9 Fp}



static void Test_F_BFu9ll_Vp()
{
  {
    init_simple_test("F_BFu9ll_Vp");
    static STRUCT_IF_C F_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9ll_Vp");
    check_field_offset(lv, v3, 8, "F_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9ll_Vp, F_BFu9ll_Vp)
//============================================================================


struct  F_BFu9s  {
  float v1;
  unsigned short v2:9;
};
//SIG(1 F_BFu9s) C1{ Fi Fs:9}



static void Test_F_BFu9s()
{
  {
    init_simple_test("F_BFu9s");
    static STRUCT_IF_C F_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s, F_BFu9s)
//============================================================================


struct  F_BFu9s_BFu15i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:15;
};
//SIG(1 F_BFu9s_BFu15i) C1{ Fi Fs:9 Fi:15}



static void Test_F_BFu9s_BFu15i()
{
  {
    init_simple_test("F_BFu9s_BFu15i");
    static STRUCT_IF_C F_BFu9s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "F_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "F_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu15i, F_BFu9s_BFu15i)
//============================================================================


struct  F_BFu9s_BFu15ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:15;
};
//SIG(1 F_BFu9s_BFu15ll) C1{ Fi Fs:9 FL:15}



static void Test_F_BFu9s_BFu15ll()
{
  {
    init_simple_test("F_BFu9s_BFu15ll");
    static STRUCT_IF_C F_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "F_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "F_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu15ll, F_BFu9s_BFu15ll)
//============================================================================


struct  F_BFu9s_BFu15s  {
  float v1;
  unsigned short v2:9;
  unsigned short v3:15;
};
//SIG(1 F_BFu9s_BFu15s) C1{ Fi Fs:9 Fs:15}



static void Test_F_BFu9s_BFu15s()
{
  {
    init_simple_test("F_BFu9s_BFu15s");
    static STRUCT_IF_C F_BFu9s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu15s, F_BFu9s_BFu15s)
//============================================================================


struct  F_BFu9s_BFu16i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:16;
};
//SIG(1 F_BFu9s_BFu16i) C1{ Fi Fs:9 Fi:16}



static void Test_F_BFu9s_BFu16i()
{
  {
    init_simple_test("F_BFu9s_BFu16i");
    static STRUCT_IF_C F_BFu9s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "F_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "F_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu16i, F_BFu9s_BFu16i)
//============================================================================


struct  F_BFu9s_BFu16ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:16;
};
//SIG(1 F_BFu9s_BFu16ll) C1{ Fi Fs:9 FL:16}



static void Test_F_BFu9s_BFu16ll()
{
  {
    init_simple_test("F_BFu9s_BFu16ll");
    static STRUCT_IF_C F_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "F_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "F_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu16ll, F_BFu9s_BFu16ll)
//============================================================================


struct  F_BFu9s_BFu16s  {
  float v1;
  unsigned short v2:9;
  unsigned short v3:16;
};
//SIG(1 F_BFu9s_BFu16s) C1{ Fi Fs:9 Fs:16}



static void Test_F_BFu9s_BFu16s()
{
  {
    init_simple_test("F_BFu9s_BFu16s");
    static STRUCT_IF_C F_BFu9s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu16s, F_BFu9s_BFu16s)
//============================================================================


struct  F_BFu9s_BFu17i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:17;
};
//SIG(1 F_BFu9s_BFu17i) C1{ Fi Fs:9 Fi:17}



static void Test_F_BFu9s_BFu17i()
{
  {
    init_simple_test("F_BFu9s_BFu17i");
    static STRUCT_IF_C F_BFu9s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "F_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "F_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu17i, F_BFu9s_BFu17i)
//============================================================================


struct  F_BFu9s_BFu17ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:17;
};
//SIG(1 F_BFu9s_BFu17ll) C1{ Fi Fs:9 FL:17}



static void Test_F_BFu9s_BFu17ll()
{
  {
    init_simple_test("F_BFu9s_BFu17ll");
    static STRUCT_IF_C F_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "F_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "F_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu17ll, F_BFu9s_BFu17ll)
//============================================================================


struct  F_BFu9s_BFu1c  {
  float v1;
  unsigned short v2:9;
  unsigned char v3:1;
};
//SIG(1 F_BFu9s_BFu1c) C1{ Fi Fs:9 Fc:1}



static void Test_F_BFu9s_BFu1c()
{
  {
    init_simple_test("F_BFu9s_BFu1c");
    static STRUCT_IF_C F_BFu9s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu1c, F_BFu9s_BFu1c)
//============================================================================


struct  F_BFu9s_BFu1i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:1;
};
//SIG(1 F_BFu9s_BFu1i) C1{ Fi Fs:9 Fi:1}



static void Test_F_BFu9s_BFu1i()
{
  {
    init_simple_test("F_BFu9s_BFu1i");
    static STRUCT_IF_C F_BFu9s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu1i, F_BFu9s_BFu1i)
//============================================================================


struct  F_BFu9s_BFu1ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:1;
};
//SIG(1 F_BFu9s_BFu1ll) C1{ Fi Fs:9 FL:1}



static void Test_F_BFu9s_BFu1ll()
{
  {
    init_simple_test("F_BFu9s_BFu1ll");
    static STRUCT_IF_C F_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu1ll, F_BFu9s_BFu1ll)
//============================================================================


struct  F_BFu9s_BFu1s  {
  float v1;
  unsigned short v2:9;
  unsigned short v3:1;
};
//SIG(1 F_BFu9s_BFu1s) C1{ Fi Fs:9 Fs:1}



static void Test_F_BFu9s_BFu1s()
{
  {
    init_simple_test("F_BFu9s_BFu1s");
    static STRUCT_IF_C F_BFu9s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "F_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu1s, F_BFu9s_BFu1s)
//============================================================================


struct  F_BFu9s_BFu31i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:31;
};
//SIG(1 F_BFu9s_BFu31i) C1{ Fi Fs:9 Fi:31}



static void Test_F_BFu9s_BFu31i()
{
  {
    init_simple_test("F_BFu9s_BFu31i");
    static STRUCT_IF_C F_BFu9s_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu31i, F_BFu9s_BFu31i)
//============================================================================


struct  F_BFu9s_BFu31ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:31;
};
//SIG(1 F_BFu9s_BFu31ll) C1{ Fi Fs:9 FL:31}



static void Test_F_BFu9s_BFu31ll()
{
  {
    init_simple_test("F_BFu9s_BFu31ll");
    static STRUCT_IF_C F_BFu9s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, 1, "F_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, hide_ull(1LL<<30), "F_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu31ll, F_BFu9s_BFu31ll)
//============================================================================


struct  F_BFu9s_BFu32i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:32;
};
//SIG(1 F_BFu9s_BFu32i) C1{ Fi Fs:9 Fi:32}



static void Test_F_BFu9s_BFu32i()
{
  {
    init_simple_test("F_BFu9s_BFu32i");
    static STRUCT_IF_C F_BFu9s_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu32i, F_BFu9s_BFu32i)
//============================================================================


struct  F_BFu9s_BFu32ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:32;
};
//SIG(1 F_BFu9s_BFu32ll) C1{ Fi Fs:9 FL:32}



static void Test_F_BFu9s_BFu32ll()
{
  {
    init_simple_test("F_BFu9s_BFu32ll");
    static STRUCT_IF_C F_BFu9s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, 1, "F_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, hide_ull(1LL<<31), "F_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu32ll, F_BFu9s_BFu32ll)
//============================================================================


struct  F_BFu9s_BFu33  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:33;
};
//SIG(1 F_BFu9s_BFu33) C1{ Fi Fs:9 FL:33}



static void Test_F_BFu9s_BFu33()
{
  {
    init_simple_test("F_BFu9s_BFu33");
    static STRUCT_IF_C F_BFu9s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, 1, "F_BFu9s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, hide_ull(1LL<<32), "F_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu33, F_BFu9s_BFu33)
//============================================================================


struct  F_BFu9s_BFu7c  {
  float v1;
  unsigned short v2:9;
  unsigned char v3:7;
};
//SIG(1 F_BFu9s_BFu7c) C1{ Fi Fs:9 Fc:7}



static void Test_F_BFu9s_BFu7c()
{
  {
    init_simple_test("F_BFu9s_BFu7c");
    static STRUCT_IF_C F_BFu9s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu7c, F_BFu9s_BFu7c)
//============================================================================


struct  F_BFu9s_BFu7i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:7;
};
//SIG(1 F_BFu9s_BFu7i) C1{ Fi Fs:9 Fi:7}



static void Test_F_BFu9s_BFu7i()
{
  {
    init_simple_test("F_BFu9s_BFu7i");
    static STRUCT_IF_C F_BFu9s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu7i, F_BFu9s_BFu7i)
//============================================================================


struct  F_BFu9s_BFu7ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:7;
};
//SIG(1 F_BFu9s_BFu7ll) C1{ Fi Fs:9 FL:7}



static void Test_F_BFu9s_BFu7ll()
{
  {
    init_simple_test("F_BFu9s_BFu7ll");
    static STRUCT_IF_C F_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu7ll, F_BFu9s_BFu7ll)
//============================================================================


struct  F_BFu9s_BFu7s  {
  float v1;
  unsigned short v2:9;
  unsigned short v3:7;
};
//SIG(1 F_BFu9s_BFu7s) C1{ Fi Fs:9 Fs:7}



static void Test_F_BFu9s_BFu7s()
{
  {
    init_simple_test("F_BFu9s_BFu7s");
    static STRUCT_IF_C F_BFu9s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "F_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "F_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu7s, F_BFu9s_BFu7s)
//============================================================================


struct  F_BFu9s_BFu8c  {
  float v1;
  unsigned short v2:9;
  unsigned char v3:8;
};
//SIG(1 F_BFu9s_BFu8c) C1{ Fi Fs:9 Fc:8}



static void Test_F_BFu9s_BFu8c()
{
  {
    init_simple_test("F_BFu9s_BFu8c");
    static STRUCT_IF_C F_BFu9s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu8c, F_BFu9s_BFu8c)
//============================================================================


struct  F_BFu9s_BFu8i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:8;
};
//SIG(1 F_BFu9s_BFu8i) C1{ Fi Fs:9 Fi:8}



static void Test_F_BFu9s_BFu8i()
{
  {
    init_simple_test("F_BFu9s_BFu8i");
    static STRUCT_IF_C F_BFu9s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "F_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "F_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu8i, F_BFu9s_BFu8i)
//============================================================================


struct  F_BFu9s_BFu8ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:8;
};
//SIG(1 F_BFu9s_BFu8ll) C1{ Fi Fs:9 FL:8}



static void Test_F_BFu9s_BFu8ll()
{
  {
    init_simple_test("F_BFu9s_BFu8ll");
    static STRUCT_IF_C F_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "F_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "F_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu8ll, F_BFu9s_BFu8ll)
//============================================================================


struct  F_BFu9s_BFu8s  {
  float v1;
  unsigned short v2:9;
  unsigned short v3:8;
};
//SIG(1 F_BFu9s_BFu8s) C1{ Fi Fs:9 Fs:8}



static void Test_F_BFu9s_BFu8s()
{
  {
    init_simple_test("F_BFu9s_BFu8s");
    static STRUCT_IF_C F_BFu9s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu8s, F_BFu9s_BFu8s)
//============================================================================


struct  F_BFu9s_BFu9i  {
  float v1;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 F_BFu9s_BFu9i) C1{ Fi Fs:9 Fi:9}



static void Test_F_BFu9s_BFu9i()
{
  {
    init_simple_test("F_BFu9s_BFu9i");
    static STRUCT_IF_C F_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "F_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "F_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu9i, F_BFu9s_BFu9i)
//============================================================================


struct  F_BFu9s_BFu9ll  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 F_BFu9s_BFu9ll) C1{ Fi Fs:9 FL:9}



static void Test_F_BFu9s_BFu9ll()
{
  {
    init_simple_test("F_BFu9s_BFu9ll");
    static STRUCT_IF_C F_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "F_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "F_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu9ll, F_BFu9s_BFu9ll)
//============================================================================


struct  F_BFu9s_BFu9s  {
  float v1;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 F_BFu9s_BFu9s) C1{ Fi Fs:9 Fs:9}



static void Test_F_BFu9s_BFu9s()
{
  {
    init_simple_test("F_BFu9s_BFu9s");
    static STRUCT_IF_C F_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_BFu9s, F_BFu9s_BFu9s)
//============================================================================


struct  F_BFu9s_C  {
  float v1;
  unsigned short v2:9;
  char v3;
};
//SIG(1 F_BFu9s_C) C1{ Fi Fs:9 Fc}



static void Test_F_BFu9s_C()
{
  {
    init_simple_test("F_BFu9s_C");
    static STRUCT_IF_C F_BFu9s_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_C)");
    check_field_offset(lv, v1, 0, "F_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_C");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_C");
    check_field_offset(lv, v3, 6, "F_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_C, F_BFu9s_C)
//============================================================================


struct  F_BFu9s_D  {
  float v1;
  unsigned short v2:9;
  double v3;
};
//SIG(1 F_BFu9s_D) C1{ Fi Fs:9 FL}



static void Test_F_BFu9s_D()
{
  {
    init_simple_test("F_BFu9s_D");
    static STRUCT_IF_C F_BFu9s_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_D)");
    check_field_offset(lv, v1, 0, "F_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_D");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_D");
    check_field_offset(lv, v3, 8, "F_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_D, F_BFu9s_D)
//============================================================================


struct  F_BFu9s_F  {
  float v1;
  unsigned short v2:9;
  float v3;
};
//SIG(1 F_BFu9s_F) C1{ Fi Fs:9 Fi}



static void Test_F_BFu9s_F()
{
  {
    init_simple_test("F_BFu9s_F");
    static STRUCT_IF_C F_BFu9s_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9s_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_F)");
    check_field_offset(lv, v1, 0, "F_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_F");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_F");
    check_field_offset(lv, v3, 8, "F_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_F, F_BFu9s_F)
//============================================================================


struct  F_BFu9s_I  {
  float v1;
  unsigned short v2:9;
  int v3;
};
//SIG(1 F_BFu9s_I) C1{ Fi Fs:9 Fi}



static void Test_F_BFu9s_I()
{
  {
    init_simple_test("F_BFu9s_I");
    static STRUCT_IF_C F_BFu9s_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9s_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_I)");
    check_field_offset(lv, v1, 0, "F_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_I");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_I");
    check_field_offset(lv, v3, 8, "F_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_I, F_BFu9s_I)
//============================================================================


struct  F_BFu9s_Ip  {
  float v1;
  unsigned short v2:9;
  int *v3;
};
//SIG(1 F_BFu9s_Ip) C1{ Fi Fs:9 Fp}



static void Test_F_BFu9s_Ip()
{
  {
    init_simple_test("F_BFu9s_Ip");
    static STRUCT_IF_C F_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_Ip");
    check_field_offset(lv, v3, 8, "F_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_Ip, F_BFu9s_Ip)
//============================================================================


struct  F_BFu9s_L  {
  float v1;
  unsigned short v2:9;
  __tsi64 v3;
};
//SIG(1 F_BFu9s_L) C1{ Fi Fs:9 FL}



static void Test_F_BFu9s_L()
{
  {
    init_simple_test("F_BFu9s_L");
    static STRUCT_IF_C F_BFu9s_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_L)");
    check_field_offset(lv, v1, 0, "F_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_L");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_L");
    check_field_offset(lv, v3, 8, "F_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_L, F_BFu9s_L)
//============================================================================


struct  F_BFu9s_S  {
  float v1;
  unsigned short v2:9;
  short v3;
};
//SIG(1 F_BFu9s_S) C1{ Fi Fs:9 Fs}



static void Test_F_BFu9s_S()
{
  {
    init_simple_test("F_BFu9s_S");
    static STRUCT_IF_C F_BFu9s_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_S)");
    check_field_offset(lv, v1, 0, "F_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_S");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_S");
    check_field_offset(lv, v3, 6, "F_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_S, F_BFu9s_S)
//============================================================================


struct  F_BFu9s_Uc  {
  float v1;
  unsigned short v2:9;
  unsigned char v3;
};
//SIG(1 F_BFu9s_Uc) C1{ Fi Fs:9 Fc}



static void Test_F_BFu9s_Uc()
{
  {
    init_simple_test("F_BFu9s_Uc");
    static STRUCT_IF_C F_BFu9s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_Uc");
    check_field_offset(lv, v3, 6, "F_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_Uc, F_BFu9s_Uc)
//============================================================================


struct  F_BFu9s_Ui  {
  float v1;
  unsigned short v2:9;
  unsigned int v3;
};
//SIG(1 F_BFu9s_Ui) C1{ Fi Fs:9 Fi}



static void Test_F_BFu9s_Ui()
{
  {
    init_simple_test("F_BFu9s_Ui");
    static STRUCT_IF_C F_BFu9s_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu9s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_Ui");
    check_field_offset(lv, v3, 8, "F_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_Ui, F_BFu9s_Ui)
//============================================================================


struct  F_BFu9s_Ul  {
  float v1;
  unsigned short v2:9;
  __tsu64 v3;
};
//SIG(1 F_BFu9s_Ul) C1{ Fi Fs:9 FL}



static void Test_F_BFu9s_Ul()
{
  {
    init_simple_test("F_BFu9s_Ul");
    static STRUCT_IF_C F_BFu9s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu9s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_Ul");
    check_field_offset(lv, v3, 8, "F_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_Ul, F_BFu9s_Ul)
//============================================================================


struct  F_BFu9s_Us  {
  float v1;
  unsigned short v2:9;
  unsigned short v3;
};
//SIG(1 F_BFu9s_Us) C1{ Fi Fs:9 Fs}



static void Test_F_BFu9s_Us()
{
  {
    init_simple_test("F_BFu9s_Us");
    static STRUCT_IF_C F_BFu9s_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu9s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "F_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_Us");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_Us");
    check_field_offset(lv, v3, 6, "F_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_Us, F_BFu9s_Us)
//============================================================================


struct  F_BFu9s_Vp  {
  float v1;
  unsigned short v2:9;
  void *v3;
};
//SIG(1 F_BFu9s_Vp) C1{ Fi Fs:9 Fp}



static void Test_F_BFu9s_Vp()
{
  {
    init_simple_test("F_BFu9s_Vp");
    static STRUCT_IF_C F_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu9s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "F_BFu9s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "F_BFu9s_Vp");
    check_field_offset(lv, v3, 8, "F_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu9s_Vp, F_BFu9s_Vp)
//============================================================================


struct  F_C  {
  float v1;
  char v2;
};
//SIG(1 F_C) C1{ Fi Fc}



static void Test_F_C()
{
  {
    init_simple_test("F_C");
    STRUCT_IF_C F_C lv;
    check2(sizeof(lv), 8, "sizeof(F_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_C)");
    check_field_offset(lv, v1, 0, "F_C.v1");
    check_field_offset(lv, v2, 4, "F_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C, F_C)
//============================================================================


struct  F_C_BFu15i  {
  float v1;
  char v2;
  unsigned int v3:15;
};
//SIG(1 F_C_BFu15i) C1{ Fi Fc Fi:15}



static void Test_F_C_BFu15i()
{
  {
    init_simple_test("F_C_BFu15i");
    static STRUCT_IF_C F_C_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu15i)");
    check_field_offset(lv, v1, 0, "F_C_BFu15i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_C_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu15i, F_C_BFu15i)
//============================================================================


struct  F_C_BFu15ll  {
  float v1;
  char v2;
  __tsu64 v3:15;
};
//SIG(1 F_C_BFu15ll) C1{ Fi Fc FL:15}



static void Test_F_C_BFu15ll()
{
  {
    init_simple_test("F_C_BFu15ll");
    static STRUCT_IF_C F_C_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_C_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu15ll, F_C_BFu15ll)
//============================================================================


struct  F_C_BFu15s  {
  float v1;
  char v2;
  unsigned short v3:15;
};
//SIG(1 F_C_BFu15s) C1{ Fi Fc Fs:15}



static void Test_F_C_BFu15s()
{
  {
    init_simple_test("F_C_BFu15s");
    static STRUCT_IF_C F_C_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu15s)");
    check_field_offset(lv, v1, 0, "F_C_BFu15s.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_C_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu15s, F_C_BFu15s)
//============================================================================


struct  F_C_BFu16i  {
  float v1;
  char v2;
  unsigned int v3:16;
};
//SIG(1 F_C_BFu16i) C1{ Fi Fc Fi:16}



static void Test_F_C_BFu16i()
{
  {
    init_simple_test("F_C_BFu16i");
    static STRUCT_IF_C F_C_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu16i)");
    check_field_offset(lv, v1, 0, "F_C_BFu16i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_C_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu16i, F_C_BFu16i)
//============================================================================


struct  F_C_BFu16ll  {
  float v1;
  char v2;
  __tsu64 v3:16;
};
//SIG(1 F_C_BFu16ll) C1{ Fi Fc FL:16}



static void Test_F_C_BFu16ll()
{
  {
    init_simple_test("F_C_BFu16ll");
    static STRUCT_IF_C F_C_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_C_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu16ll, F_C_BFu16ll)
//============================================================================


struct  F_C_BFu16s  {
  float v1;
  char v2;
  unsigned short v3:16;
};
//SIG(1 F_C_BFu16s) C1{ Fi Fc Fs:16}



static void Test_F_C_BFu16s()
{
  {
    init_simple_test("F_C_BFu16s");
    static STRUCT_IF_C F_C_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu16s)");
    check_field_offset(lv, v1, 0, "F_C_BFu16s.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_C_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu16s, F_C_BFu16s)
//============================================================================


struct  F_C_BFu17i  {
  float v1;
  char v2;
  unsigned int v3:17;
};
//SIG(1 F_C_BFu17i) C1{ Fi Fc Fi:17}



static void Test_F_C_BFu17i()
{
  {
    init_simple_test("F_C_BFu17i");
    static STRUCT_IF_C F_C_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu17i)");
    check_field_offset(lv, v1, 0, "F_C_BFu17i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_C_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu17i, F_C_BFu17i)
//============================================================================


struct  F_C_BFu17ll  {
  float v1;
  char v2;
  __tsu64 v3:17;
};
//SIG(1 F_C_BFu17ll) C1{ Fi Fc FL:17}



static void Test_F_C_BFu17ll()
{
  {
    init_simple_test("F_C_BFu17ll");
    static STRUCT_IF_C F_C_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_C_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu17ll, F_C_BFu17ll)
//============================================================================


struct  F_C_BFu1c  {
  float v1;
  char v2;
  unsigned char v3:1;
};
//SIG(1 F_C_BFu1c) C1{ Fi Fc Fc:1}



static void Test_F_C_BFu1c()
{
  {
    init_simple_test("F_C_BFu1c");
    static STRUCT_IF_C F_C_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu1c)");
    check_field_offset(lv, v1, 0, "F_C_BFu1c.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu1c, F_C_BFu1c)
//============================================================================


struct  F_C_BFu1i  {
  float v1;
  char v2;
  unsigned int v3:1;
};
//SIG(1 F_C_BFu1i) C1{ Fi Fc Fi:1}



static void Test_F_C_BFu1i()
{
  {
    init_simple_test("F_C_BFu1i");
    static STRUCT_IF_C F_C_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu1i)");
    check_field_offset(lv, v1, 0, "F_C_BFu1i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu1i, F_C_BFu1i)
//============================================================================


struct  F_C_BFu1ll  {
  float v1;
  char v2;
  __tsu64 v3:1;
};
//SIG(1 F_C_BFu1ll) C1{ Fi Fc FL:1}



static void Test_F_C_BFu1ll()
{
  {
    init_simple_test("F_C_BFu1ll");
    static STRUCT_IF_C F_C_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu1ll, F_C_BFu1ll)
//============================================================================


struct  F_C_BFu1s  {
  float v1;
  char v2;
  unsigned short v3:1;
};
//SIG(1 F_C_BFu1s) C1{ Fi Fc Fs:1}



static void Test_F_C_BFu1s()
{
  {
    init_simple_test("F_C_BFu1s");
    static STRUCT_IF_C F_C_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu1s)");
    check_field_offset(lv, v1, 0, "F_C_BFu1s.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu1s, F_C_BFu1s)
//============================================================================


struct  F_C_BFu31i  {
  float v1;
  char v2;
  unsigned int v3:31;
};
//SIG(1 F_C_BFu31i) C1{ Fi Fc Fi:31}



static void Test_F_C_BFu31i()
{
  {
    init_simple_test("F_C_BFu31i");
    static STRUCT_IF_C F_C_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_C_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu31i)");
    check_field_offset(lv, v1, 0, "F_C_BFu31i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_C_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu31i, F_C_BFu31i)
//============================================================================


struct  F_C_BFu31ll  {
  float v1;
  char v2;
  __tsu64 v3:31;
};
//SIG(1 F_C_BFu31ll) C1{ Fi Fc FL:31}



static void Test_F_C_BFu31ll()
{
  {
    init_simple_test("F_C_BFu31ll");
    static STRUCT_IF_C F_C_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_C_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "F_C_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "F_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu31ll, F_C_BFu31ll)
//============================================================================


struct  F_C_BFu32i  {
  float v1;
  char v2;
  unsigned int v3:32;
};
//SIG(1 F_C_BFu32i) C1{ Fi Fc Fi:32}



static void Test_F_C_BFu32i()
{
  {
    init_simple_test("F_C_BFu32i");
    static STRUCT_IF_C F_C_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_C_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu32i)");
    check_field_offset(lv, v1, 0, "F_C_BFu32i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_C_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu32i, F_C_BFu32i)
//============================================================================


struct  F_C_BFu32ll  {
  float v1;
  char v2;
  __tsu64 v3:32;
};
//SIG(1 F_C_BFu32ll) C1{ Fi Fc FL:32}



static void Test_F_C_BFu32ll()
{
  {
    init_simple_test("F_C_BFu32ll");
    static STRUCT_IF_C F_C_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_C_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "F_C_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "F_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu32ll, F_C_BFu32ll)
//============================================================================


struct  F_C_BFu33  {
  float v1;
  char v2;
  __tsu64 v3:33;
};
//SIG(1 F_C_BFu33) C1{ Fi Fc FL:33}



static void Test_F_C_BFu33()
{
  {
    init_simple_test("F_C_BFu33");
    static STRUCT_IF_C F_C_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_C_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu33)");
    check_field_offset(lv, v1, 0, "F_C_BFu33.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "F_C_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "F_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu33, F_C_BFu33)
//============================================================================


struct  F_C_BFu7c  {
  float v1;
  char v2;
  unsigned char v3:7;
};
//SIG(1 F_C_BFu7c) C1{ Fi Fc Fc:7}



static void Test_F_C_BFu7c()
{
  {
    init_simple_test("F_C_BFu7c");
    static STRUCT_IF_C F_C_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu7c)");
    check_field_offset(lv, v1, 0, "F_C_BFu7c.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_C_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu7c, F_C_BFu7c)
//============================================================================


struct  F_C_BFu7i  {
  float v1;
  char v2;
  unsigned int v3:7;
};
//SIG(1 F_C_BFu7i) C1{ Fi Fc Fi:7}



static void Test_F_C_BFu7i()
{
  {
    init_simple_test("F_C_BFu7i");
    static STRUCT_IF_C F_C_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu7i)");
    check_field_offset(lv, v1, 0, "F_C_BFu7i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_C_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu7i, F_C_BFu7i)
//============================================================================


struct  F_C_BFu7ll  {
  float v1;
  char v2;
  __tsu64 v3:7;
};
//SIG(1 F_C_BFu7ll) C1{ Fi Fc FL:7}



static void Test_F_C_BFu7ll()
{
  {
    init_simple_test("F_C_BFu7ll");
    static STRUCT_IF_C F_C_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_C_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu7ll, F_C_BFu7ll)
//============================================================================


struct  F_C_BFu7s  {
  float v1;
  char v2;
  unsigned short v3:7;
};
//SIG(1 F_C_BFu7s) C1{ Fi Fc Fs:7}



static void Test_F_C_BFu7s()
{
  {
    init_simple_test("F_C_BFu7s");
    static STRUCT_IF_C F_C_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu7s)");
    check_field_offset(lv, v1, 0, "F_C_BFu7s.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_C_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu7s, F_C_BFu7s)
//============================================================================


struct  F_C_BFu8c  {
  float v1;
  char v2;
  unsigned char v3:8;
};
//SIG(1 F_C_BFu8c) C1{ Fi Fc Fc:8}



static void Test_F_C_BFu8c()
{
  {
    init_simple_test("F_C_BFu8c");
    static STRUCT_IF_C F_C_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu8c)");
    check_field_offset(lv, v1, 0, "F_C_BFu8c.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_C_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu8c, F_C_BFu8c)
//============================================================================


struct  F_C_BFu8i  {
  float v1;
  char v2;
  unsigned int v3:8;
};
//SIG(1 F_C_BFu8i) C1{ Fi Fc Fi:8}



static void Test_F_C_BFu8i()
{
  {
    init_simple_test("F_C_BFu8i");
    static STRUCT_IF_C F_C_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu8i)");
    check_field_offset(lv, v1, 0, "F_C_BFu8i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_C_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu8i, F_C_BFu8i)
//============================================================================


struct  F_C_BFu8ll  {
  float v1;
  char v2;
  __tsu64 v3:8;
};
//SIG(1 F_C_BFu8ll) C1{ Fi Fc FL:8}



static void Test_F_C_BFu8ll()
{
  {
    init_simple_test("F_C_BFu8ll");
    static STRUCT_IF_C F_C_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_C_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu8ll, F_C_BFu8ll)
//============================================================================


struct  F_C_BFu8s  {
  float v1;
  char v2;
  unsigned short v3:8;
};
//SIG(1 F_C_BFu8s) C1{ Fi Fc Fs:8}



static void Test_F_C_BFu8s()
{
  {
    init_simple_test("F_C_BFu8s");
    static STRUCT_IF_C F_C_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu8s)");
    check_field_offset(lv, v1, 0, "F_C_BFu8s.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_C_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu8s, F_C_BFu8s)
//============================================================================


struct  F_C_BFu9i  {
  float v1;
  char v2;
  unsigned int v3:9;
};
//SIG(1 F_C_BFu9i) C1{ Fi Fc Fi:9}



static void Test_F_C_BFu9i()
{
  {
    init_simple_test("F_C_BFu9i");
    static STRUCT_IF_C F_C_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu9i)");
    check_field_offset(lv, v1, 0, "F_C_BFu9i.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_C_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu9i, F_C_BFu9i)
//============================================================================


struct  F_C_BFu9ll  {
  float v1;
  char v2;
  __tsu64 v3:9;
};
//SIG(1 F_C_BFu9ll) C1{ Fi Fc FL:9}



static void Test_F_C_BFu9ll()
{
  {
    init_simple_test("F_C_BFu9ll");
    static STRUCT_IF_C F_C_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_C_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_C_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu9ll, F_C_BFu9ll)
//============================================================================


struct  F_C_BFu9s  {
  float v1;
  char v2;
  unsigned short v3:9;
};
//SIG(1 F_C_BFu9s) C1{ Fi Fc Fs:9}



static void Test_F_C_BFu9s()
{
  {
    init_simple_test("F_C_BFu9s");
    static STRUCT_IF_C F_C_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_C_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_BFu9s)");
    check_field_offset(lv, v1, 0, "F_C_BFu9s.v1");
    check_field_offset(lv, v2, 4, "F_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_C_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_BFu9s, F_C_BFu9s)
//============================================================================


struct  F_C_C  {
  float v1;
  char v2;
  char v3;
};
//SIG(1 F_C_C) C1{ Fi Fc[2]}



static void Test_F_C_C()
{
  {
    init_simple_test("F_C_C");
    STRUCT_IF_C F_C_C lv;
    check2(sizeof(lv), 8, "sizeof(F_C_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_C)");
    check_field_offset(lv, v1, 0, "F_C_C.v1");
    check_field_offset(lv, v2, 4, "F_C_C.v2");
    check_field_offset(lv, v3, 5, "F_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_C, F_C_C)
//============================================================================


struct  F_C_D  {
  float v1;
  char v2;
  double v3;
};
//SIG(1 F_C_D) C1{ Fi Fc FL}



static void Test_F_C_D()
{
  {
    init_simple_test("F_C_D");
    STRUCT_IF_C F_C_D lv;
    check2(sizeof(lv), 16, "sizeof(F_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_D)");
    check_field_offset(lv, v1, 0, "F_C_D.v1");
    check_field_offset(lv, v2, 4, "F_C_D.v2");
    check_field_offset(lv, v3, 8, "F_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_D, F_C_D)
//============================================================================


struct  F_C_F  {
  float v1;
  char v2;
  float v3;
};
//SIG(1 F_C_F) C1{ Fi Fc Fi}



static void Test_F_C_F()
{
  {
    init_simple_test("F_C_F");
    STRUCT_IF_C F_C_F lv;
    check2(sizeof(lv), 12, "sizeof(F_C_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_F)");
    check_field_offset(lv, v1, 0, "F_C_F.v1");
    check_field_offset(lv, v2, 4, "F_C_F.v2");
    check_field_offset(lv, v3, 8, "F_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_F, F_C_F)
//============================================================================


struct  F_C_I  {
  float v1;
  char v2;
  int v3;
};
//SIG(1 F_C_I) C1{ Fi Fc Fi}



static void Test_F_C_I()
{
  {
    init_simple_test("F_C_I");
    STRUCT_IF_C F_C_I lv;
    check2(sizeof(lv), 12, "sizeof(F_C_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_I)");
    check_field_offset(lv, v1, 0, "F_C_I.v1");
    check_field_offset(lv, v2, 4, "F_C_I.v2");
    check_field_offset(lv, v3, 8, "F_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_I, F_C_I)
//============================================================================


struct  F_C_Ip  {
  float v1;
  char v2;
  int *v3;
};
//SIG(1 F_C_Ip) C1{ Fi Fc Fp}



static void Test_F_C_Ip()
{
  {
    init_simple_test("F_C_Ip");
    STRUCT_IF_C F_C_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_Ip)");
    check_field_offset(lv, v1, 0, "F_C_Ip.v1");
    check_field_offset(lv, v2, 4, "F_C_Ip.v2");
    check_field_offset(lv, v3, 8, "F_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_Ip, F_C_Ip)
//============================================================================


struct  F_C_L  {
  float v1;
  char v2;
  __tsi64 v3;
};
//SIG(1 F_C_L) C1{ Fi Fc FL}



static void Test_F_C_L()
{
  {
    init_simple_test("F_C_L");
    STRUCT_IF_C F_C_L lv;
    check2(sizeof(lv), 16, "sizeof(F_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_L)");
    check_field_offset(lv, v1, 0, "F_C_L.v1");
    check_field_offset(lv, v2, 4, "F_C_L.v2");
    check_field_offset(lv, v3, 8, "F_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_L, F_C_L)
//============================================================================


struct  F_C_S  {
  float v1;
  char v2;
  short v3;
};
//SIG(1 F_C_S) C1{ Fi Fc Fs}



static void Test_F_C_S()
{
  {
    init_simple_test("F_C_S");
    STRUCT_IF_C F_C_S lv;
    check2(sizeof(lv), 8, "sizeof(F_C_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_S)");
    check_field_offset(lv, v1, 0, "F_C_S.v1");
    check_field_offset(lv, v2, 4, "F_C_S.v2");
    check_field_offset(lv, v3, 6, "F_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_S, F_C_S)
//============================================================================


struct  F_C_Uc  {
  float v1;
  char v2;
  unsigned char v3;
};
//SIG(1 F_C_Uc) C1{ Fi Fc[2]}



static void Test_F_C_Uc()
{
  {
    init_simple_test("F_C_Uc");
    STRUCT_IF_C F_C_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_C_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_Uc)");
    check_field_offset(lv, v1, 0, "F_C_Uc.v1");
    check_field_offset(lv, v2, 4, "F_C_Uc.v2");
    check_field_offset(lv, v3, 5, "F_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_Uc, F_C_Uc)
//============================================================================


struct  F_C_Ui  {
  float v1;
  char v2;
  unsigned int v3;
};
//SIG(1 F_C_Ui) C1{ Fi Fc Fi}



static void Test_F_C_Ui()
{
  {
    init_simple_test("F_C_Ui");
    STRUCT_IF_C F_C_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_C_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_Ui)");
    check_field_offset(lv, v1, 0, "F_C_Ui.v1");
    check_field_offset(lv, v2, 4, "F_C_Ui.v2");
    check_field_offset(lv, v3, 8, "F_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_Ui, F_C_Ui)
//============================================================================


struct  F_C_Ul  {
  float v1;
  char v2;
  __tsu64 v3;
};
//SIG(1 F_C_Ul) C1{ Fi Fc FL}



static void Test_F_C_Ul()
{
  {
    init_simple_test("F_C_Ul");
    STRUCT_IF_C F_C_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_Ul)");
    check_field_offset(lv, v1, 0, "F_C_Ul.v1");
    check_field_offset(lv, v2, 4, "F_C_Ul.v2");
    check_field_offset(lv, v3, 8, "F_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_Ul, F_C_Ul)
//============================================================================


struct  F_C_Us  {
  float v1;
  char v2;
  unsigned short v3;
};
//SIG(1 F_C_Us) C1{ Fi Fc Fs}



static void Test_F_C_Us()
{
  {
    init_simple_test("F_C_Us");
    STRUCT_IF_C F_C_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_C_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_C_Us)");
    check_field_offset(lv, v1, 0, "F_C_Us.v1");
    check_field_offset(lv, v2, 4, "F_C_Us.v2");
    check_field_offset(lv, v3, 6, "F_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_Us, F_C_Us)
//============================================================================


struct  F_C_Vp  {
  float v1;
  char v2;
  void *v3;
};
//SIG(1 F_C_Vp) C1{ Fi Fc Fp}



static void Test_F_C_Vp()
{
  {
    init_simple_test("F_C_Vp");
    STRUCT_IF_C F_C_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_C_Vp)");
    check_field_offset(lv, v1, 0, "F_C_Vp.v1");
    check_field_offset(lv, v2, 4, "F_C_Vp.v2");
    check_field_offset(lv, v3, 8, "F_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_C_Vp, F_C_Vp)
//============================================================================


struct  F_D  {
  float v1;
  double v2;
};
//SIG(1 F_D) C1{ Fi FL}



static void Test_F_D()
{
  {
    init_simple_test("F_D");
    STRUCT_IF_C F_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D)");
    check_field_offset(lv, v1, 0, "F_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D, F_D)
//============================================================================


struct  F_D_BFu15i  {
  float v1;
  double v2;
  unsigned int v3:15;
};
//SIG(1 F_D_BFu15i) C1{ Fi FL Fi:15}



static void Test_F_D_BFu15i()
{
  {
    init_simple_test("F_D_BFu15i");
    static STRUCT_IF_C F_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu15i)");
    check_field_offset(lv, v1, 0, "F_D_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_D_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu15i, F_D_BFu15i)
//============================================================================


struct  F_D_BFu15ll  {
  float v1;
  double v2;
  __tsu64 v3:15;
};
//SIG(1 F_D_BFu15ll) C1{ Fi FL FL:15}



static void Test_F_D_BFu15ll()
{
  {
    init_simple_test("F_D_BFu15ll");
    static STRUCT_IF_C F_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_D_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu15ll, F_D_BFu15ll)
//============================================================================


struct  F_D_BFu15s  {
  float v1;
  double v2;
  unsigned short v3:15;
};
//SIG(1 F_D_BFu15s) C1{ Fi FL Fs:15}



static void Test_F_D_BFu15s()
{
  {
    init_simple_test("F_D_BFu15s");
    static STRUCT_IF_C F_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu15s)");
    check_field_offset(lv, v1, 0, "F_D_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_D_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu15s, F_D_BFu15s)
//============================================================================


struct  F_D_BFu16i  {
  float v1;
  double v2;
  unsigned int v3:16;
};
//SIG(1 F_D_BFu16i) C1{ Fi FL Fi:16}



static void Test_F_D_BFu16i()
{
  {
    init_simple_test("F_D_BFu16i");
    static STRUCT_IF_C F_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu16i)");
    check_field_offset(lv, v1, 0, "F_D_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_D_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu16i, F_D_BFu16i)
//============================================================================


struct  F_D_BFu16ll  {
  float v1;
  double v2;
  __tsu64 v3:16;
};
//SIG(1 F_D_BFu16ll) C1{ Fi FL FL:16}



static void Test_F_D_BFu16ll()
{
  {
    init_simple_test("F_D_BFu16ll");
    static STRUCT_IF_C F_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_D_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu16ll, F_D_BFu16ll)
//============================================================================


struct  F_D_BFu16s  {
  float v1;
  double v2;
  unsigned short v3:16;
};
//SIG(1 F_D_BFu16s) C1{ Fi FL Fs:16}



static void Test_F_D_BFu16s()
{
  {
    init_simple_test("F_D_BFu16s");
    static STRUCT_IF_C F_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu16s)");
    check_field_offset(lv, v1, 0, "F_D_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_D_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu16s, F_D_BFu16s)
//============================================================================


struct  F_D_BFu17i  {
  float v1;
  double v2;
  unsigned int v3:17;
};
//SIG(1 F_D_BFu17i) C1{ Fi FL Fi:17}



static void Test_F_D_BFu17i()
{
  {
    init_simple_test("F_D_BFu17i");
    static STRUCT_IF_C F_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu17i)");
    check_field_offset(lv, v1, 0, "F_D_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "F_D_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "F_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu17i, F_D_BFu17i)
//============================================================================


struct  F_D_BFu17ll  {
  float v1;
  double v2;
  __tsu64 v3:17;
};
//SIG(1 F_D_BFu17ll) C1{ Fi FL FL:17}



static void Test_F_D_BFu17ll()
{
  {
    init_simple_test("F_D_BFu17ll");
    static STRUCT_IF_C F_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "F_D_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "F_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu17ll, F_D_BFu17ll)
//============================================================================


struct  F_D_BFu1c  {
  float v1;
  double v2;
  unsigned char v3:1;
};
//SIG(1 F_D_BFu1c) C1{ Fi FL Fc:1}



static void Test_F_D_BFu1c()
{
  {
    init_simple_test("F_D_BFu1c");
    static STRUCT_IF_C F_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu1c)");
    check_field_offset(lv, v1, 0, "F_D_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu1c, F_D_BFu1c)
//============================================================================


struct  F_D_BFu1i  {
  float v1;
  double v2;
  unsigned int v3:1;
};
//SIG(1 F_D_BFu1i) C1{ Fi FL Fi:1}



static void Test_F_D_BFu1i()
{
  {
    init_simple_test("F_D_BFu1i");
    static STRUCT_IF_C F_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu1i)");
    check_field_offset(lv, v1, 0, "F_D_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu1i, F_D_BFu1i)
//============================================================================


struct  F_D_BFu1ll  {
  float v1;
  double v2;
  __tsu64 v3:1;
};
//SIG(1 F_D_BFu1ll) C1{ Fi FL FL:1}



static void Test_F_D_BFu1ll()
{
  {
    init_simple_test("F_D_BFu1ll");
    static STRUCT_IF_C F_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu1ll, F_D_BFu1ll)
//============================================================================


struct  F_D_BFu1s  {
  float v1;
  double v2;
  unsigned short v3:1;
};
//SIG(1 F_D_BFu1s) C1{ Fi FL Fs:1}



static void Test_F_D_BFu1s()
{
  {
    init_simple_test("F_D_BFu1s");
    static STRUCT_IF_C F_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu1s)");
    check_field_offset(lv, v1, 0, "F_D_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu1s, F_D_BFu1s)
//============================================================================


struct  F_D_BFu31i  {
  float v1;
  double v2;
  unsigned int v3:31;
};
//SIG(1 F_D_BFu31i) C1{ Fi FL Fi:31}



static void Test_F_D_BFu31i()
{
  {
    init_simple_test("F_D_BFu31i");
    static STRUCT_IF_C F_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu31i)");
    check_field_offset(lv, v1, 0, "F_D_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "F_D_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "F_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu31i, F_D_BFu31i)
//============================================================================


struct  F_D_BFu31ll  {
  float v1;
  double v2;
  __tsu64 v3:31;
};
//SIG(1 F_D_BFu31ll) C1{ Fi FL FL:31}



static void Test_F_D_BFu31ll()
{
  {
    init_simple_test("F_D_BFu31ll");
    static STRUCT_IF_C F_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "F_D_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "F_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu31ll, F_D_BFu31ll)
//============================================================================


struct  F_D_BFu32i  {
  float v1;
  double v2;
  unsigned int v3:32;
};
//SIG(1 F_D_BFu32i) C1{ Fi FL Fi:32}



static void Test_F_D_BFu32i()
{
  {
    init_simple_test("F_D_BFu32i");
    static STRUCT_IF_C F_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu32i)");
    check_field_offset(lv, v1, 0, "F_D_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "F_D_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "F_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu32i, F_D_BFu32i)
//============================================================================


struct  F_D_BFu32ll  {
  float v1;
  double v2;
  __tsu64 v3:32;
};
//SIG(1 F_D_BFu32ll) C1{ Fi FL FL:32}



static void Test_F_D_BFu32ll()
{
  {
    init_simple_test("F_D_BFu32ll");
    static STRUCT_IF_C F_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "F_D_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "F_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu32ll, F_D_BFu32ll)
//============================================================================


struct  F_D_BFu33  {
  float v1;
  double v2;
  __tsu64 v3:33;
};
//SIG(1 F_D_BFu33) C1{ Fi FL FL:33}



static void Test_F_D_BFu33()
{
  {
    init_simple_test("F_D_BFu33");
    static STRUCT_IF_C F_D_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu33)");
    check_field_offset(lv, v1, 0, "F_D_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "F_D_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "F_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu33, F_D_BFu33)
//============================================================================


struct  F_D_BFu7c  {
  float v1;
  double v2;
  unsigned char v3:7;
};
//SIG(1 F_D_BFu7c) C1{ Fi FL Fc:7}



static void Test_F_D_BFu7c()
{
  {
    init_simple_test("F_D_BFu7c");
    static STRUCT_IF_C F_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu7c)");
    check_field_offset(lv, v1, 0, "F_D_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_D_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu7c, F_D_BFu7c)
//============================================================================


struct  F_D_BFu7i  {
  float v1;
  double v2;
  unsigned int v3:7;
};
//SIG(1 F_D_BFu7i) C1{ Fi FL Fi:7}



static void Test_F_D_BFu7i()
{
  {
    init_simple_test("F_D_BFu7i");
    static STRUCT_IF_C F_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu7i)");
    check_field_offset(lv, v1, 0, "F_D_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_D_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu7i, F_D_BFu7i)
//============================================================================


struct  F_D_BFu7ll  {
  float v1;
  double v2;
  __tsu64 v3:7;
};
//SIG(1 F_D_BFu7ll) C1{ Fi FL FL:7}



static void Test_F_D_BFu7ll()
{
  {
    init_simple_test("F_D_BFu7ll");
    static STRUCT_IF_C F_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_D_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu7ll, F_D_BFu7ll)
//============================================================================


struct  F_D_BFu7s  {
  float v1;
  double v2;
  unsigned short v3:7;
};
//SIG(1 F_D_BFu7s) C1{ Fi FL Fs:7}



static void Test_F_D_BFu7s()
{
  {
    init_simple_test("F_D_BFu7s");
    static STRUCT_IF_C F_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu7s)");
    check_field_offset(lv, v1, 0, "F_D_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_D_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu7s, F_D_BFu7s)
//============================================================================


struct  F_D_BFu8c  {
  float v1;
  double v2;
  unsigned char v3:8;
};
//SIG(1 F_D_BFu8c) C1{ Fi FL Fc:8}



static void Test_F_D_BFu8c()
{
  {
    init_simple_test("F_D_BFu8c");
    static STRUCT_IF_C F_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu8c)");
    check_field_offset(lv, v1, 0, "F_D_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_D_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu8c, F_D_BFu8c)
//============================================================================


struct  F_D_BFu8i  {
  float v1;
  double v2;
  unsigned int v3:8;
};
//SIG(1 F_D_BFu8i) C1{ Fi FL Fi:8}



static void Test_F_D_BFu8i()
{
  {
    init_simple_test("F_D_BFu8i");
    static STRUCT_IF_C F_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu8i)");
    check_field_offset(lv, v1, 0, "F_D_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_D_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu8i, F_D_BFu8i)
//============================================================================


struct  F_D_BFu8ll  {
  float v1;
  double v2;
  __tsu64 v3:8;
};
//SIG(1 F_D_BFu8ll) C1{ Fi FL FL:8}



static void Test_F_D_BFu8ll()
{
  {
    init_simple_test("F_D_BFu8ll");
    static STRUCT_IF_C F_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_D_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu8ll, F_D_BFu8ll)
//============================================================================


struct  F_D_BFu8s  {
  float v1;
  double v2;
  unsigned short v3:8;
};
//SIG(1 F_D_BFu8s) C1{ Fi FL Fs:8}



static void Test_F_D_BFu8s()
{
  {
    init_simple_test("F_D_BFu8s");
    static STRUCT_IF_C F_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu8s)");
    check_field_offset(lv, v1, 0, "F_D_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_D_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu8s, F_D_BFu8s)
//============================================================================


struct  F_D_BFu9i  {
  float v1;
  double v2;
  unsigned int v3:9;
};
//SIG(1 F_D_BFu9i) C1{ Fi FL Fi:9}



static void Test_F_D_BFu9i()
{
  {
    init_simple_test("F_D_BFu9i");
    static STRUCT_IF_C F_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu9i)");
    check_field_offset(lv, v1, 0, "F_D_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_D_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu9i, F_D_BFu9i)
//============================================================================


struct  F_D_BFu9ll  {
  float v1;
  double v2;
  __tsu64 v3:9;
};
//SIG(1 F_D_BFu9ll) C1{ Fi FL FL:9}



static void Test_F_D_BFu9ll()
{
  {
    init_simple_test("F_D_BFu9ll");
    static STRUCT_IF_C F_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_D_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_D_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu9ll, F_D_BFu9ll)
//============================================================================


struct  F_D_BFu9s  {
  float v1;
  double v2;
  unsigned short v3:9;
};
//SIG(1 F_D_BFu9s) C1{ Fi FL Fs:9}



static void Test_F_D_BFu9s()
{
  {
    init_simple_test("F_D_BFu9s");
    static STRUCT_IF_C F_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_BFu9s)");
    check_field_offset(lv, v1, 0, "F_D_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_D_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_BFu9s, F_D_BFu9s)
//============================================================================


struct  F_D_C  {
  float v1;
  double v2;
  char v3;
};
//SIG(1 F_D_C) C1{ Fi FL Fc}



static void Test_F_D_C()
{
  {
    init_simple_test("F_D_C");
    STRUCT_IF_C F_D_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_C)");
    check_field_offset(lv, v1, 0, "F_D_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_C, F_D_C)
//============================================================================


struct  F_D_D  {
  float v1;
  double v2;
  double v3;
};
//SIG(1 F_D_D) C1{ Fi FL[2]}



static void Test_F_D_D()
{
  {
    init_simple_test("F_D_D");
    STRUCT_IF_C F_D_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_D)");
    check_field_offset(lv, v1, 0, "F_D_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_D, F_D_D)
//============================================================================


struct  F_D_F  {
  float v1;
  double v2;
  float v3;
};
//SIG(1 F_D_F) C1{ Fi FL Fi}



static void Test_F_D_F()
{
  {
    init_simple_test("F_D_F");
    STRUCT_IF_C F_D_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_F)");
    check_field_offset(lv, v1, 0, "F_D_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_F, F_D_F)
//============================================================================


struct  F_D_I  {
  float v1;
  double v2;
  int v3;
};
//SIG(1 F_D_I) C1{ Fi FL Fi}



static void Test_F_D_I()
{
  {
    init_simple_test("F_D_I");
    STRUCT_IF_C F_D_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_I)");
    check_field_offset(lv, v1, 0, "F_D_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_I, F_D_I)
//============================================================================


struct  F_D_Ip  {
  float v1;
  double v2;
  int *v3;
};
//SIG(1 F_D_Ip) C1{ Fi FL Fp}



static void Test_F_D_Ip()
{
  {
    init_simple_test("F_D_Ip");
    STRUCT_IF_C F_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_Ip)");
    check_field_offset(lv, v1, 0, "F_D_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_Ip, F_D_Ip)
//============================================================================


struct  F_D_L  {
  float v1;
  double v2;
  __tsi64 v3;
};
//SIG(1 F_D_L) C1{ Fi FL[2]}



static void Test_F_D_L()
{
  {
    init_simple_test("F_D_L");
    STRUCT_IF_C F_D_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_L)");
    check_field_offset(lv, v1, 0, "F_D_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_L, F_D_L)
//============================================================================


struct  F_D_S  {
  float v1;
  double v2;
  short v3;
};
//SIG(1 F_D_S) C1{ Fi FL Fs}



static void Test_F_D_S()
{
  {
    init_simple_test("F_D_S");
    STRUCT_IF_C F_D_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_S)");
    check_field_offset(lv, v1, 0, "F_D_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_S, F_D_S)
//============================================================================


struct  F_D_Uc  {
  float v1;
  double v2;
  unsigned char v3;
};
//SIG(1 F_D_Uc) C1{ Fi FL Fc}



static void Test_F_D_Uc()
{
  {
    init_simple_test("F_D_Uc");
    STRUCT_IF_C F_D_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_Uc)");
    check_field_offset(lv, v1, 0, "F_D_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_Uc, F_D_Uc)
//============================================================================


struct  F_D_Ui  {
  float v1;
  double v2;
  unsigned int v3;
};
//SIG(1 F_D_Ui) C1{ Fi FL Fi}



static void Test_F_D_Ui()
{
  {
    init_simple_test("F_D_Ui");
    STRUCT_IF_C F_D_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_Ui)");
    check_field_offset(lv, v1, 0, "F_D_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_Ui, F_D_Ui)
//============================================================================


struct  F_D_Ul  {
  float v1;
  double v2;
  __tsu64 v3;
};
//SIG(1 F_D_Ul) C1{ Fi FL[2]}



static void Test_F_D_Ul()
{
  {
    init_simple_test("F_D_Ul");
    STRUCT_IF_C F_D_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_Ul)");
    check_field_offset(lv, v1, 0, "F_D_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_Ul, F_D_Ul)
//============================================================================


struct  F_D_Us  {
  float v1;
  double v2;
  unsigned short v3;
};
//SIG(1 F_D_Us) C1{ Fi FL Fs}



static void Test_F_D_Us()
{
  {
    init_simple_test("F_D_Us");
    STRUCT_IF_C F_D_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_Us)");
    check_field_offset(lv, v1, 0, "F_D_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_Us, F_D_Us)
//============================================================================


struct  F_D_Vp  {
  float v1;
  double v2;
  void *v3;
};
//SIG(1 F_D_Vp) C1{ Fi FL Fp}



static void Test_F_D_Vp()
{
  {
    init_simple_test("F_D_Vp");
    STRUCT_IF_C F_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_D_Vp)");
    check_field_offset(lv, v1, 0, "F_D_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_D_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_D_Vp, F_D_Vp)
//============================================================================


struct  F_F  {
  float v1;
  float v2;
};
//SIG(1 F_F) C1{ Fi[2]}



static void Test_F_F()
{
  {
    init_simple_test("F_F");
    STRUCT_IF_C F_F lv;
    check2(sizeof(lv), 8, "sizeof(F_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_F)");
    check_field_offset(lv, v1, 0, "F_F.v1");
    check_field_offset(lv, v2, 4, "F_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F, F_F)
//============================================================================


struct  F_F_BFu15i  {
  float v1;
  float v2;
  unsigned int v3:15;
};
//SIG(1 F_F_BFu15i) C1{ Fi[2] Fi:15}



static void Test_F_F_BFu15i()
{
  {
    init_simple_test("F_F_BFu15i");
    static STRUCT_IF_C F_F_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu15i)");
    check_field_offset(lv, v1, 0, "F_F_BFu15i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_F_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu15i, F_F_BFu15i)
//============================================================================


struct  F_F_BFu15ll  {
  float v1;
  float v2;
  __tsu64 v3:15;
};
//SIG(1 F_F_BFu15ll) C1{ Fi[2] FL:15}



static void Test_F_F_BFu15ll()
{
  {
    init_simple_test("F_F_BFu15ll");
    static STRUCT_IF_C F_F_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_F_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu15ll, F_F_BFu15ll)
//============================================================================


struct  F_F_BFu15s  {
  float v1;
  float v2;
  unsigned short v3:15;
};
//SIG(1 F_F_BFu15s) C1{ Fi[2] Fs:15}



static void Test_F_F_BFu15s()
{
  {
    init_simple_test("F_F_BFu15s");
    static STRUCT_IF_C F_F_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu15s)");
    check_field_offset(lv, v1, 0, "F_F_BFu15s.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_F_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu15s, F_F_BFu15s)
//============================================================================


struct  F_F_BFu16i  {
  float v1;
  float v2;
  unsigned int v3:16;
};
//SIG(1 F_F_BFu16i) C1{ Fi[2] Fi:16}



static void Test_F_F_BFu16i()
{
  {
    init_simple_test("F_F_BFu16i");
    static STRUCT_IF_C F_F_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu16i)");
    check_field_offset(lv, v1, 0, "F_F_BFu16i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_F_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu16i, F_F_BFu16i)
//============================================================================


struct  F_F_BFu16ll  {
  float v1;
  float v2;
  __tsu64 v3:16;
};
//SIG(1 F_F_BFu16ll) C1{ Fi[2] FL:16}



static void Test_F_F_BFu16ll()
{
  {
    init_simple_test("F_F_BFu16ll");
    static STRUCT_IF_C F_F_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_F_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu16ll, F_F_BFu16ll)
//============================================================================


struct  F_F_BFu16s  {
  float v1;
  float v2;
  unsigned short v3:16;
};
//SIG(1 F_F_BFu16s) C1{ Fi[2] Fs:16}



static void Test_F_F_BFu16s()
{
  {
    init_simple_test("F_F_BFu16s");
    static STRUCT_IF_C F_F_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu16s)");
    check_field_offset(lv, v1, 0, "F_F_BFu16s.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_F_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu16s, F_F_BFu16s)
//============================================================================


struct  F_F_BFu17i  {
  float v1;
  float v2;
  unsigned int v3:17;
};
//SIG(1 F_F_BFu17i) C1{ Fi[2] Fi:17}



static void Test_F_F_BFu17i()
{
  {
    init_simple_test("F_F_BFu17i");
    static STRUCT_IF_C F_F_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu17i)");
    check_field_offset(lv, v1, 0, "F_F_BFu17i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_F_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu17i, F_F_BFu17i)
//============================================================================


struct  F_F_BFu17ll  {
  float v1;
  float v2;
  __tsu64 v3:17;
};
//SIG(1 F_F_BFu17ll) C1{ Fi[2] FL:17}



static void Test_F_F_BFu17ll()
{
  {
    init_simple_test("F_F_BFu17ll");
    static STRUCT_IF_C F_F_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_F_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu17ll, F_F_BFu17ll)
//============================================================================


struct  F_F_BFu1c  {
  float v1;
  float v2;
  unsigned char v3:1;
};
//SIG(1 F_F_BFu1c) C1{ Fi[2] Fc:1}



static void Test_F_F_BFu1c()
{
  {
    init_simple_test("F_F_BFu1c");
    static STRUCT_IF_C F_F_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu1c)");
    check_field_offset(lv, v1, 0, "F_F_BFu1c.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu1c, F_F_BFu1c)
//============================================================================


struct  F_F_BFu1i  {
  float v1;
  float v2;
  unsigned int v3:1;
};
//SIG(1 F_F_BFu1i) C1{ Fi[2] Fi:1}



static void Test_F_F_BFu1i()
{
  {
    init_simple_test("F_F_BFu1i");
    static STRUCT_IF_C F_F_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu1i)");
    check_field_offset(lv, v1, 0, "F_F_BFu1i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu1i, F_F_BFu1i)
//============================================================================


struct  F_F_BFu1ll  {
  float v1;
  float v2;
  __tsu64 v3:1;
};
//SIG(1 F_F_BFu1ll) C1{ Fi[2] FL:1}



static void Test_F_F_BFu1ll()
{
  {
    init_simple_test("F_F_BFu1ll");
    static STRUCT_IF_C F_F_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu1ll, F_F_BFu1ll)
//============================================================================


struct  F_F_BFu1s  {
  float v1;
  float v2;
  unsigned short v3:1;
};
//SIG(1 F_F_BFu1s) C1{ Fi[2] Fs:1}



static void Test_F_F_BFu1s()
{
  {
    init_simple_test("F_F_BFu1s");
    static STRUCT_IF_C F_F_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu1s)");
    check_field_offset(lv, v1, 0, "F_F_BFu1s.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu1s, F_F_BFu1s)
//============================================================================


struct  F_F_BFu31i  {
  float v1;
  float v2;
  unsigned int v3:31;
};
//SIG(1 F_F_BFu31i) C1{ Fi[2] Fi:31}



static void Test_F_F_BFu31i()
{
  {
    init_simple_test("F_F_BFu31i");
    static STRUCT_IF_C F_F_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu31i)");
    check_field_offset(lv, v1, 0, "F_F_BFu31i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_F_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu31i, F_F_BFu31i)
//============================================================================


struct  F_F_BFu31ll  {
  float v1;
  float v2;
  __tsu64 v3:31;
};
//SIG(1 F_F_BFu31ll) C1{ Fi[2] FL:31}



static void Test_F_F_BFu31ll()
{
  {
    init_simple_test("F_F_BFu31ll");
    static STRUCT_IF_C F_F_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_F_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu31ll, F_F_BFu31ll)
//============================================================================


struct  F_F_BFu32i  {
  float v1;
  float v2;
  unsigned int v3:32;
};
//SIG(1 F_F_BFu32i) C1{ Fi[2] Fi:32}



static void Test_F_F_BFu32i()
{
  {
    init_simple_test("F_F_BFu32i");
    static STRUCT_IF_C F_F_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu32i)");
    check_field_offset(lv, v1, 0, "F_F_BFu32i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_F_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu32i, F_F_BFu32i)
//============================================================================


struct  F_F_BFu32ll  {
  float v1;
  float v2;
  __tsu64 v3:32;
};
//SIG(1 F_F_BFu32ll) C1{ Fi[2] FL:32}



static void Test_F_F_BFu32ll()
{
  {
    init_simple_test("F_F_BFu32ll");
    static STRUCT_IF_C F_F_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_F_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu32ll, F_F_BFu32ll)
//============================================================================


struct  F_F_BFu33  {
  float v1;
  float v2;
  __tsu64 v3:33;
};
//SIG(1 F_F_BFu33) C1{ Fi[2] FL:33}



static void Test_F_F_BFu33()
{
  {
    init_simple_test("F_F_BFu33");
    static STRUCT_IF_C F_F_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(F_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu33)");
    check_field_offset(lv, v1, 0, "F_F_BFu33.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "F_F_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "F_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu33, F_F_BFu33)
//============================================================================


struct  F_F_BFu7c  {
  float v1;
  float v2;
  unsigned char v3:7;
};
//SIG(1 F_F_BFu7c) C1{ Fi[2] Fc:7}



static void Test_F_F_BFu7c()
{
  {
    init_simple_test("F_F_BFu7c");
    static STRUCT_IF_C F_F_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu7c)");
    check_field_offset(lv, v1, 0, "F_F_BFu7c.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_F_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu7c, F_F_BFu7c)
//============================================================================


struct  F_F_BFu7i  {
  float v1;
  float v2;
  unsigned int v3:7;
};
//SIG(1 F_F_BFu7i) C1{ Fi[2] Fi:7}



static void Test_F_F_BFu7i()
{
  {
    init_simple_test("F_F_BFu7i");
    static STRUCT_IF_C F_F_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu7i)");
    check_field_offset(lv, v1, 0, "F_F_BFu7i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_F_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu7i, F_F_BFu7i)
//============================================================================


struct  F_F_BFu7ll  {
  float v1;
  float v2;
  __tsu64 v3:7;
};
//SIG(1 F_F_BFu7ll) C1{ Fi[2] FL:7}



static void Test_F_F_BFu7ll()
{
  {
    init_simple_test("F_F_BFu7ll");
    static STRUCT_IF_C F_F_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_F_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu7ll, F_F_BFu7ll)
//============================================================================


struct  F_F_BFu7s  {
  float v1;
  float v2;
  unsigned short v3:7;
};
//SIG(1 F_F_BFu7s) C1{ Fi[2] Fs:7}



static void Test_F_F_BFu7s()
{
  {
    init_simple_test("F_F_BFu7s");
    static STRUCT_IF_C F_F_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu7s)");
    check_field_offset(lv, v1, 0, "F_F_BFu7s.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_F_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu7s, F_F_BFu7s)
//============================================================================


struct  F_F_BFu8c  {
  float v1;
  float v2;
  unsigned char v3:8;
};
//SIG(1 F_F_BFu8c) C1{ Fi[2] Fc:8}



static void Test_F_F_BFu8c()
{
  {
    init_simple_test("F_F_BFu8c");
    static STRUCT_IF_C F_F_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu8c)");
    check_field_offset(lv, v1, 0, "F_F_BFu8c.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_F_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu8c, F_F_BFu8c)
//============================================================================


struct  F_F_BFu8i  {
  float v1;
  float v2;
  unsigned int v3:8;
};
//SIG(1 F_F_BFu8i) C1{ Fi[2] Fi:8}



static void Test_F_F_BFu8i()
{
  {
    init_simple_test("F_F_BFu8i");
    static STRUCT_IF_C F_F_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu8i)");
    check_field_offset(lv, v1, 0, "F_F_BFu8i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_F_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu8i, F_F_BFu8i)
//============================================================================


struct  F_F_BFu8ll  {
  float v1;
  float v2;
  __tsu64 v3:8;
};
//SIG(1 F_F_BFu8ll) C1{ Fi[2] FL:8}



static void Test_F_F_BFu8ll()
{
  {
    init_simple_test("F_F_BFu8ll");
    static STRUCT_IF_C F_F_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_F_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu8ll, F_F_BFu8ll)
//============================================================================


struct  F_F_BFu8s  {
  float v1;
  float v2;
  unsigned short v3:8;
};
//SIG(1 F_F_BFu8s) C1{ Fi[2] Fs:8}



static void Test_F_F_BFu8s()
{
  {
    init_simple_test("F_F_BFu8s");
    static STRUCT_IF_C F_F_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu8s)");
    check_field_offset(lv, v1, 0, "F_F_BFu8s.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_F_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu8s, F_F_BFu8s)
//============================================================================


struct  F_F_BFu9i  {
  float v1;
  float v2;
  unsigned int v3:9;
};
//SIG(1 F_F_BFu9i) C1{ Fi[2] Fi:9}



static void Test_F_F_BFu9i()
{
  {
    init_simple_test("F_F_BFu9i");
    static STRUCT_IF_C F_F_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu9i)");
    check_field_offset(lv, v1, 0, "F_F_BFu9i.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_F_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu9i, F_F_BFu9i)
//============================================================================


struct  F_F_BFu9ll  {
  float v1;
  float v2;
  __tsu64 v3:9;
};
//SIG(1 F_F_BFu9ll) C1{ Fi[2] FL:9}



static void Test_F_F_BFu9ll()
{
  {
    init_simple_test("F_F_BFu9ll");
    static STRUCT_IF_C F_F_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_F_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_F_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu9ll, F_F_BFu9ll)
//============================================================================


struct  F_F_BFu9s  {
  float v1;
  float v2;
  unsigned short v3:9;
};
//SIG(1 F_F_BFu9s) C1{ Fi[2] Fs:9}



static void Test_F_F_BFu9s()
{
  {
    init_simple_test("F_F_BFu9s");
    static STRUCT_IF_C F_F_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(F_F_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_BFu9s)");
    check_field_offset(lv, v1, 0, "F_F_BFu9s.v1");
    check_field_offset(lv, v2, 4, "F_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_F_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_BFu9s, F_F_BFu9s)
//============================================================================


struct  F_F_C  {
  float v1;
  float v2;
  char v3;
};
//SIG(1 F_F_C) C1{ Fi[2] Fc}



static void Test_F_F_C()
{
  {
    init_simple_test("F_F_C");
    STRUCT_IF_C F_F_C lv;
    check2(sizeof(lv), 12, "sizeof(F_F_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_C)");
    check_field_offset(lv, v1, 0, "F_F_C.v1");
    check_field_offset(lv, v2, 4, "F_F_C.v2");
    check_field_offset(lv, v3, 8, "F_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_C, F_F_C)
//============================================================================


struct  F_F_D  {
  float v1;
  float v2;
  double v3;
};
//SIG(1 F_F_D) C1{ Fi[2] FL}



static void Test_F_F_D()
{
  {
    init_simple_test("F_F_D");
    STRUCT_IF_C F_F_D lv;
    check2(sizeof(lv), 16, "sizeof(F_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_D)");
    check_field_offset(lv, v1, 0, "F_F_D.v1");
    check_field_offset(lv, v2, 4, "F_F_D.v2");
    check_field_offset(lv, v3, 8, "F_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_D, F_F_D)
//============================================================================


struct  F_F_F  {
  float v1;
  float v2;
  float v3;
};
//SIG(1 F_F_F) C1{ Fi[3]}



static void Test_F_F_F()
{
  {
    init_simple_test("F_F_F");
    STRUCT_IF_C F_F_F lv;
    check2(sizeof(lv), 12, "sizeof(F_F_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_F)");
    check_field_offset(lv, v1, 0, "F_F_F.v1");
    check_field_offset(lv, v2, 4, "F_F_F.v2");
    check_field_offset(lv, v3, 8, "F_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_F, F_F_F)
//============================================================================


struct  F_F_I  {
  float v1;
  float v2;
  int v3;
};
//SIG(1 F_F_I) C1{ Fi[3]}



static void Test_F_F_I()
{
  {
    init_simple_test("F_F_I");
    STRUCT_IF_C F_F_I lv;
    check2(sizeof(lv), 12, "sizeof(F_F_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_I)");
    check_field_offset(lv, v1, 0, "F_F_I.v1");
    check_field_offset(lv, v2, 4, "F_F_I.v2");
    check_field_offset(lv, v3, 8, "F_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_I, F_F_I)
//============================================================================


struct  F_F_Ip  {
  float v1;
  float v2;
  int *v3;
};
//SIG(1 F_F_Ip) C1{ Fi[2] Fp}



static void Test_F_F_Ip()
{
  {
    init_simple_test("F_F_Ip");
    STRUCT_IF_C F_F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_Ip)");
    check_field_offset(lv, v1, 0, "F_F_Ip.v1");
    check_field_offset(lv, v2, 4, "F_F_Ip.v2");
    check_field_offset(lv, v3, 8, "F_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_Ip, F_F_Ip)
//============================================================================


struct  F_F_L  {
  float v1;
  float v2;
  __tsi64 v3;
};
//SIG(1 F_F_L) C1{ Fi[2] FL}



static void Test_F_F_L()
{
  {
    init_simple_test("F_F_L");
    STRUCT_IF_C F_F_L lv;
    check2(sizeof(lv), 16, "sizeof(F_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_L)");
    check_field_offset(lv, v1, 0, "F_F_L.v1");
    check_field_offset(lv, v2, 4, "F_F_L.v2");
    check_field_offset(lv, v3, 8, "F_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_L, F_F_L)
//============================================================================


struct  F_F_S  {
  float v1;
  float v2;
  short v3;
};
//SIG(1 F_F_S) C1{ Fi[2] Fs}



static void Test_F_F_S()
{
  {
    init_simple_test("F_F_S");
    STRUCT_IF_C F_F_S lv;
    check2(sizeof(lv), 12, "sizeof(F_F_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_S)");
    check_field_offset(lv, v1, 0, "F_F_S.v1");
    check_field_offset(lv, v2, 4, "F_F_S.v2");
    check_field_offset(lv, v3, 8, "F_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_S, F_F_S)
//============================================================================


struct  F_F_Uc  {
  float v1;
  float v2;
  unsigned char v3;
};
//SIG(1 F_F_Uc) C1{ Fi[2] Fc}



static void Test_F_F_Uc()
{
  {
    init_simple_test("F_F_Uc");
    STRUCT_IF_C F_F_Uc lv;
    check2(sizeof(lv), 12, "sizeof(F_F_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_Uc)");
    check_field_offset(lv, v1, 0, "F_F_Uc.v1");
    check_field_offset(lv, v2, 4, "F_F_Uc.v2");
    check_field_offset(lv, v3, 8, "F_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_Uc, F_F_Uc)
//============================================================================


struct  F_F_Ui  {
  float v1;
  float v2;
  unsigned int v3;
};
//SIG(1 F_F_Ui) C1{ Fi[3]}



static void Test_F_F_Ui()
{
  {
    init_simple_test("F_F_Ui");
    STRUCT_IF_C F_F_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_F_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_Ui)");
    check_field_offset(lv, v1, 0, "F_F_Ui.v1");
    check_field_offset(lv, v2, 4, "F_F_Ui.v2");
    check_field_offset(lv, v3, 8, "F_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_Ui, F_F_Ui)
//============================================================================


struct  F_F_Ul  {
  float v1;
  float v2;
  __tsu64 v3;
};
//SIG(1 F_F_Ul) C1{ Fi[2] FL}



static void Test_F_F_Ul()
{
  {
    init_simple_test("F_F_Ul");
    STRUCT_IF_C F_F_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_Ul)");
    check_field_offset(lv, v1, 0, "F_F_Ul.v1");
    check_field_offset(lv, v2, 4, "F_F_Ul.v2");
    check_field_offset(lv, v3, 8, "F_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_Ul, F_F_Ul)
//============================================================================


struct  F_F_Us  {
  float v1;
  float v2;
  unsigned short v3;
};
//SIG(1 F_F_Us) C1{ Fi[2] Fs}



static void Test_F_F_Us()
{
  {
    init_simple_test("F_F_Us");
    STRUCT_IF_C F_F_Us lv;
    check2(sizeof(lv), 12, "sizeof(F_F_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_F_Us)");
    check_field_offset(lv, v1, 0, "F_F_Us.v1");
    check_field_offset(lv, v2, 4, "F_F_Us.v2");
    check_field_offset(lv, v3, 8, "F_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_Us, F_F_Us)
//============================================================================


struct  F_F_Vp  {
  float v1;
  float v2;
  void *v3;
};
//SIG(1 F_F_Vp) C1{ Fi[2] Fp}



static void Test_F_F_Vp()
{
  {
    init_simple_test("F_F_Vp");
    STRUCT_IF_C F_F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_F_Vp)");
    check_field_offset(lv, v1, 0, "F_F_Vp.v1");
    check_field_offset(lv, v2, 4, "F_F_Vp.v2");
    check_field_offset(lv, v3, 8, "F_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_F_Vp, F_F_Vp)
//============================================================================


struct  F_I  {
  float v1;
  int v2;
};
//SIG(1 F_I) C1{ Fi[2]}



static void Test_F_I()
{
  {
    init_simple_test("F_I");
    STRUCT_IF_C F_I lv;
    check2(sizeof(lv), 8, "sizeof(F_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_I)");
    check_field_offset(lv, v1, 0, "F_I.v1");
    check_field_offset(lv, v2, 4, "F_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I, F_I)
//============================================================================


struct  F_I_BFu15i  {
  float v1;
  int v2;
  unsigned int v3:15;
};
//SIG(1 F_I_BFu15i) C1{ Fi[2] Fi:15}



static void Test_F_I_BFu15i()
{
  {
    init_simple_test("F_I_BFu15i");
    static STRUCT_IF_C F_I_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu15i)");
    check_field_offset(lv, v1, 0, "F_I_BFu15i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_I_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu15i, F_I_BFu15i)
//============================================================================


struct  F_I_BFu15ll  {
  float v1;
  int v2;
  __tsu64 v3:15;
};
//SIG(1 F_I_BFu15ll) C1{ Fi[2] FL:15}



static void Test_F_I_BFu15ll()
{
  {
    init_simple_test("F_I_BFu15ll");
    static STRUCT_IF_C F_I_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_I_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu15ll, F_I_BFu15ll)
//============================================================================


struct  F_I_BFu15s  {
  float v1;
  int v2;
  unsigned short v3:15;
};
//SIG(1 F_I_BFu15s) C1{ Fi[2] Fs:15}



static void Test_F_I_BFu15s()
{
  {
    init_simple_test("F_I_BFu15s");
    static STRUCT_IF_C F_I_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu15s)");
    check_field_offset(lv, v1, 0, "F_I_BFu15s.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_I_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu15s, F_I_BFu15s)
//============================================================================


struct  F_I_BFu16i  {
  float v1;
  int v2;
  unsigned int v3:16;
};
//SIG(1 F_I_BFu16i) C1{ Fi[2] Fi:16}



static void Test_F_I_BFu16i()
{
  {
    init_simple_test("F_I_BFu16i");
    static STRUCT_IF_C F_I_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu16i)");
    check_field_offset(lv, v1, 0, "F_I_BFu16i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_I_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu16i, F_I_BFu16i)
//============================================================================


struct  F_I_BFu16ll  {
  float v1;
  int v2;
  __tsu64 v3:16;
};
//SIG(1 F_I_BFu16ll) C1{ Fi[2] FL:16}



static void Test_F_I_BFu16ll()
{
  {
    init_simple_test("F_I_BFu16ll");
    static STRUCT_IF_C F_I_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_I_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu16ll, F_I_BFu16ll)
//============================================================================


struct  F_I_BFu16s  {
  float v1;
  int v2;
  unsigned short v3:16;
};
//SIG(1 F_I_BFu16s) C1{ Fi[2] Fs:16}



static void Test_F_I_BFu16s()
{
  {
    init_simple_test("F_I_BFu16s");
    static STRUCT_IF_C F_I_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu16s)");
    check_field_offset(lv, v1, 0, "F_I_BFu16s.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_I_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu16s, F_I_BFu16s)
//============================================================================


struct  F_I_BFu17i  {
  float v1;
  int v2;
  unsigned int v3:17;
};
//SIG(1 F_I_BFu17i) C1{ Fi[2] Fi:17}



static void Test_F_I_BFu17i()
{
  {
    init_simple_test("F_I_BFu17i");
    static STRUCT_IF_C F_I_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu17i)");
    check_field_offset(lv, v1, 0, "F_I_BFu17i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_I_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu17i, F_I_BFu17i)
//============================================================================


struct  F_I_BFu17ll  {
  float v1;
  int v2;
  __tsu64 v3:17;
};
//SIG(1 F_I_BFu17ll) C1{ Fi[2] FL:17}



static void Test_F_I_BFu17ll()
{
  {
    init_simple_test("F_I_BFu17ll");
    static STRUCT_IF_C F_I_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_I_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu17ll, F_I_BFu17ll)
//============================================================================


struct  F_I_BFu1c  {
  float v1;
  int v2;
  unsigned char v3:1;
};
//SIG(1 F_I_BFu1c) C1{ Fi[2] Fc:1}



static void Test_F_I_BFu1c()
{
  {
    init_simple_test("F_I_BFu1c");
    static STRUCT_IF_C F_I_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu1c)");
    check_field_offset(lv, v1, 0, "F_I_BFu1c.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu1c, F_I_BFu1c)
//============================================================================


struct  F_I_BFu1i  {
  float v1;
  int v2;
  unsigned int v3:1;
};
//SIG(1 F_I_BFu1i) C1{ Fi[2] Fi:1}



static void Test_F_I_BFu1i()
{
  {
    init_simple_test("F_I_BFu1i");
    static STRUCT_IF_C F_I_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu1i)");
    check_field_offset(lv, v1, 0, "F_I_BFu1i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu1i, F_I_BFu1i)
//============================================================================


struct  F_I_BFu1ll  {
  float v1;
  int v2;
  __tsu64 v3:1;
};
//SIG(1 F_I_BFu1ll) C1{ Fi[2] FL:1}



static void Test_F_I_BFu1ll()
{
  {
    init_simple_test("F_I_BFu1ll");
    static STRUCT_IF_C F_I_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu1ll, F_I_BFu1ll)
//============================================================================


struct  F_I_BFu1s  {
  float v1;
  int v2;
  unsigned short v3:1;
};
//SIG(1 F_I_BFu1s) C1{ Fi[2] Fs:1}



static void Test_F_I_BFu1s()
{
  {
    init_simple_test("F_I_BFu1s");
    static STRUCT_IF_C F_I_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu1s)");
    check_field_offset(lv, v1, 0, "F_I_BFu1s.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu1s, F_I_BFu1s)
//============================================================================


struct  F_I_BFu31i  {
  float v1;
  int v2;
  unsigned int v3:31;
};
//SIG(1 F_I_BFu31i) C1{ Fi[2] Fi:31}



static void Test_F_I_BFu31i()
{
  {
    init_simple_test("F_I_BFu31i");
    static STRUCT_IF_C F_I_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu31i)");
    check_field_offset(lv, v1, 0, "F_I_BFu31i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_I_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu31i, F_I_BFu31i)
//============================================================================


struct  F_I_BFu31ll  {
  float v1;
  int v2;
  __tsu64 v3:31;
};
//SIG(1 F_I_BFu31ll) C1{ Fi[2] FL:31}



static void Test_F_I_BFu31ll()
{
  {
    init_simple_test("F_I_BFu31ll");
    static STRUCT_IF_C F_I_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_I_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu31ll, F_I_BFu31ll)
//============================================================================


struct  F_I_BFu32i  {
  float v1;
  int v2;
  unsigned int v3:32;
};
//SIG(1 F_I_BFu32i) C1{ Fi[2] Fi:32}



static void Test_F_I_BFu32i()
{
  {
    init_simple_test("F_I_BFu32i");
    static STRUCT_IF_C F_I_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu32i)");
    check_field_offset(lv, v1, 0, "F_I_BFu32i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_I_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu32i, F_I_BFu32i)
//============================================================================


struct  F_I_BFu32ll  {
  float v1;
  int v2;
  __tsu64 v3:32;
};
//SIG(1 F_I_BFu32ll) C1{ Fi[2] FL:32}



static void Test_F_I_BFu32ll()
{
  {
    init_simple_test("F_I_BFu32ll");
    static STRUCT_IF_C F_I_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_I_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu32ll, F_I_BFu32ll)
//============================================================================


struct  F_I_BFu33  {
  float v1;
  int v2;
  __tsu64 v3:33;
};
//SIG(1 F_I_BFu33) C1{ Fi[2] FL:33}



static void Test_F_I_BFu33()
{
  {
    init_simple_test("F_I_BFu33");
    static STRUCT_IF_C F_I_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(F_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu33)");
    check_field_offset(lv, v1, 0, "F_I_BFu33.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "F_I_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "F_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu33, F_I_BFu33)
//============================================================================


struct  F_I_BFu7c  {
  float v1;
  int v2;
  unsigned char v3:7;
};
//SIG(1 F_I_BFu7c) C1{ Fi[2] Fc:7}



static void Test_F_I_BFu7c()
{
  {
    init_simple_test("F_I_BFu7c");
    static STRUCT_IF_C F_I_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu7c)");
    check_field_offset(lv, v1, 0, "F_I_BFu7c.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_I_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu7c, F_I_BFu7c)
//============================================================================


struct  F_I_BFu7i  {
  float v1;
  int v2;
  unsigned int v3:7;
};
//SIG(1 F_I_BFu7i) C1{ Fi[2] Fi:7}



static void Test_F_I_BFu7i()
{
  {
    init_simple_test("F_I_BFu7i");
    static STRUCT_IF_C F_I_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu7i)");
    check_field_offset(lv, v1, 0, "F_I_BFu7i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_I_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu7i, F_I_BFu7i)
//============================================================================


struct  F_I_BFu7ll  {
  float v1;
  int v2;
  __tsu64 v3:7;
};
//SIG(1 F_I_BFu7ll) C1{ Fi[2] FL:7}



static void Test_F_I_BFu7ll()
{
  {
    init_simple_test("F_I_BFu7ll");
    static STRUCT_IF_C F_I_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_I_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu7ll, F_I_BFu7ll)
//============================================================================


struct  F_I_BFu7s  {
  float v1;
  int v2;
  unsigned short v3:7;
};
//SIG(1 F_I_BFu7s) C1{ Fi[2] Fs:7}



static void Test_F_I_BFu7s()
{
  {
    init_simple_test("F_I_BFu7s");
    static STRUCT_IF_C F_I_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu7s)");
    check_field_offset(lv, v1, 0, "F_I_BFu7s.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_I_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu7s, F_I_BFu7s)
//============================================================================


struct  F_I_BFu8c  {
  float v1;
  int v2;
  unsigned char v3:8;
};
//SIG(1 F_I_BFu8c) C1{ Fi[2] Fc:8}



static void Test_F_I_BFu8c()
{
  {
    init_simple_test("F_I_BFu8c");
    static STRUCT_IF_C F_I_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu8c)");
    check_field_offset(lv, v1, 0, "F_I_BFu8c.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_I_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu8c, F_I_BFu8c)
//============================================================================


struct  F_I_BFu8i  {
  float v1;
  int v2;
  unsigned int v3:8;
};
//SIG(1 F_I_BFu8i) C1{ Fi[2] Fi:8}



static void Test_F_I_BFu8i()
{
  {
    init_simple_test("F_I_BFu8i");
    static STRUCT_IF_C F_I_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu8i)");
    check_field_offset(lv, v1, 0, "F_I_BFu8i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_I_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu8i, F_I_BFu8i)
//============================================================================


struct  F_I_BFu8ll  {
  float v1;
  int v2;
  __tsu64 v3:8;
};
//SIG(1 F_I_BFu8ll) C1{ Fi[2] FL:8}



static void Test_F_I_BFu8ll()
{
  {
    init_simple_test("F_I_BFu8ll");
    static STRUCT_IF_C F_I_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_I_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu8ll, F_I_BFu8ll)
//============================================================================


struct  F_I_BFu8s  {
  float v1;
  int v2;
  unsigned short v3:8;
};
//SIG(1 F_I_BFu8s) C1{ Fi[2] Fs:8}



static void Test_F_I_BFu8s()
{
  {
    init_simple_test("F_I_BFu8s");
    static STRUCT_IF_C F_I_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu8s)");
    check_field_offset(lv, v1, 0, "F_I_BFu8s.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_I_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu8s, F_I_BFu8s)
//============================================================================


struct  F_I_BFu9i  {
  float v1;
  int v2;
  unsigned int v3:9;
};
//SIG(1 F_I_BFu9i) C1{ Fi[2] Fi:9}



static void Test_F_I_BFu9i()
{
  {
    init_simple_test("F_I_BFu9i");
    static STRUCT_IF_C F_I_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu9i)");
    check_field_offset(lv, v1, 0, "F_I_BFu9i.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_I_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu9i, F_I_BFu9i)
//============================================================================


struct  F_I_BFu9ll  {
  float v1;
  int v2;
  __tsu64 v3:9;
};
//SIG(1 F_I_BFu9ll) C1{ Fi[2] FL:9}



static void Test_F_I_BFu9ll()
{
  {
    init_simple_test("F_I_BFu9ll");
    static STRUCT_IF_C F_I_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_I_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_I_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu9ll, F_I_BFu9ll)
//============================================================================


struct  F_I_BFu9s  {
  float v1;
  int v2;
  unsigned short v3:9;
};
//SIG(1 F_I_BFu9s) C1{ Fi[2] Fs:9}



static void Test_F_I_BFu9s()
{
  {
    init_simple_test("F_I_BFu9s");
    static STRUCT_IF_C F_I_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(F_I_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_BFu9s)");
    check_field_offset(lv, v1, 0, "F_I_BFu9s.v1");
    check_field_offset(lv, v2, 4, "F_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_I_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_BFu9s, F_I_BFu9s)
//============================================================================


struct  F_I_C  {
  float v1;
  int v2;
  char v3;
};
//SIG(1 F_I_C) C1{ Fi[2] Fc}



static void Test_F_I_C()
{
  {
    init_simple_test("F_I_C");
    STRUCT_IF_C F_I_C lv;
    check2(sizeof(lv), 12, "sizeof(F_I_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_C)");
    check_field_offset(lv, v1, 0, "F_I_C.v1");
    check_field_offset(lv, v2, 4, "F_I_C.v2");
    check_field_offset(lv, v3, 8, "F_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_C, F_I_C)
//============================================================================


struct  F_I_D  {
  float v1;
  int v2;
  double v3;
};
//SIG(1 F_I_D) C1{ Fi[2] FL}



static void Test_F_I_D()
{
  {
    init_simple_test("F_I_D");
    STRUCT_IF_C F_I_D lv;
    check2(sizeof(lv), 16, "sizeof(F_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_D)");
    check_field_offset(lv, v1, 0, "F_I_D.v1");
    check_field_offset(lv, v2, 4, "F_I_D.v2");
    check_field_offset(lv, v3, 8, "F_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_D, F_I_D)
//============================================================================


struct  F_I_F  {
  float v1;
  int v2;
  float v3;
};
//SIG(1 F_I_F) C1{ Fi[3]}



static void Test_F_I_F()
{
  {
    init_simple_test("F_I_F");
    STRUCT_IF_C F_I_F lv;
    check2(sizeof(lv), 12, "sizeof(F_I_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_F)");
    check_field_offset(lv, v1, 0, "F_I_F.v1");
    check_field_offset(lv, v2, 4, "F_I_F.v2");
    check_field_offset(lv, v3, 8, "F_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_F, F_I_F)
//============================================================================


struct  F_I_I  {
  float v1;
  int v2;
  int v3;
};
//SIG(1 F_I_I) C1{ Fi[3]}



static void Test_F_I_I()
{
  {
    init_simple_test("F_I_I");
    STRUCT_IF_C F_I_I lv;
    check2(sizeof(lv), 12, "sizeof(F_I_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_I)");
    check_field_offset(lv, v1, 0, "F_I_I.v1");
    check_field_offset(lv, v2, 4, "F_I_I.v2");
    check_field_offset(lv, v3, 8, "F_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_I, F_I_I)
//============================================================================


struct  F_I_Ip  {
  float v1;
  int v2;
  int *v3;
};
//SIG(1 F_I_Ip) C1{ Fi[2] Fp}



static void Test_F_I_Ip()
{
  {
    init_simple_test("F_I_Ip");
    STRUCT_IF_C F_I_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_Ip)");
    check_field_offset(lv, v1, 0, "F_I_Ip.v1");
    check_field_offset(lv, v2, 4, "F_I_Ip.v2");
    check_field_offset(lv, v3, 8, "F_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_Ip, F_I_Ip)
//============================================================================


struct  F_I_L  {
  float v1;
  int v2;
  __tsi64 v3;
};
//SIG(1 F_I_L) C1{ Fi[2] FL}



static void Test_F_I_L()
{
  {
    init_simple_test("F_I_L");
    STRUCT_IF_C F_I_L lv;
    check2(sizeof(lv), 16, "sizeof(F_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_L)");
    check_field_offset(lv, v1, 0, "F_I_L.v1");
    check_field_offset(lv, v2, 4, "F_I_L.v2");
    check_field_offset(lv, v3, 8, "F_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_L, F_I_L)
//============================================================================


struct  F_I_S  {
  float v1;
  int v2;
  short v3;
};
//SIG(1 F_I_S) C1{ Fi[2] Fs}



static void Test_F_I_S()
{
  {
    init_simple_test("F_I_S");
    STRUCT_IF_C F_I_S lv;
    check2(sizeof(lv), 12, "sizeof(F_I_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_S)");
    check_field_offset(lv, v1, 0, "F_I_S.v1");
    check_field_offset(lv, v2, 4, "F_I_S.v2");
    check_field_offset(lv, v3, 8, "F_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_S, F_I_S)
//============================================================================


struct  F_I_Uc  {
  float v1;
  int v2;
  unsigned char v3;
};
//SIG(1 F_I_Uc) C1{ Fi[2] Fc}



static void Test_F_I_Uc()
{
  {
    init_simple_test("F_I_Uc");
    STRUCT_IF_C F_I_Uc lv;
    check2(sizeof(lv), 12, "sizeof(F_I_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_Uc)");
    check_field_offset(lv, v1, 0, "F_I_Uc.v1");
    check_field_offset(lv, v2, 4, "F_I_Uc.v2");
    check_field_offset(lv, v3, 8, "F_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_Uc, F_I_Uc)
//============================================================================


struct  F_I_Ui  {
  float v1;
  int v2;
  unsigned int v3;
};
//SIG(1 F_I_Ui) C1{ Fi[3]}



static void Test_F_I_Ui()
{
  {
    init_simple_test("F_I_Ui");
    STRUCT_IF_C F_I_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_I_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_Ui)");
    check_field_offset(lv, v1, 0, "F_I_Ui.v1");
    check_field_offset(lv, v2, 4, "F_I_Ui.v2");
    check_field_offset(lv, v3, 8, "F_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_Ui, F_I_Ui)
//============================================================================


struct  F_I_Ul  {
  float v1;
  int v2;
  __tsu64 v3;
};
//SIG(1 F_I_Ul) C1{ Fi[2] FL}



static void Test_F_I_Ul()
{
  {
    init_simple_test("F_I_Ul");
    STRUCT_IF_C F_I_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_Ul)");
    check_field_offset(lv, v1, 0, "F_I_Ul.v1");
    check_field_offset(lv, v2, 4, "F_I_Ul.v2");
    check_field_offset(lv, v3, 8, "F_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_Ul, F_I_Ul)
//============================================================================


struct  F_I_Us  {
  float v1;
  int v2;
  unsigned short v3;
};
//SIG(1 F_I_Us) C1{ Fi[2] Fs}



static void Test_F_I_Us()
{
  {
    init_simple_test("F_I_Us");
    STRUCT_IF_C F_I_Us lv;
    check2(sizeof(lv), 12, "sizeof(F_I_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_I_Us)");
    check_field_offset(lv, v1, 0, "F_I_Us.v1");
    check_field_offset(lv, v2, 4, "F_I_Us.v2");
    check_field_offset(lv, v3, 8, "F_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_Us, F_I_Us)
//============================================================================


struct  F_I_Vp  {
  float v1;
  int v2;
  void *v3;
};
//SIG(1 F_I_Vp) C1{ Fi[2] Fp}



static void Test_F_I_Vp()
{
  {
    init_simple_test("F_I_Vp");
    STRUCT_IF_C F_I_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_I_Vp)");
    check_field_offset(lv, v1, 0, "F_I_Vp.v1");
    check_field_offset(lv, v2, 4, "F_I_Vp.v2");
    check_field_offset(lv, v3, 8, "F_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_I_Vp, F_I_Vp)
//============================================================================


struct  F_Ip  {
  float v1;
  int *v2;
};
//SIG(1 F_Ip) C1{ Fi Fp}



static void Test_F_Ip()
{
  {
    init_simple_test("F_Ip");
    STRUCT_IF_C F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip)");
    check_field_offset(lv, v1, 0, "F_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip, F_Ip)
//============================================================================


struct  F_Ip_BFu15i  {
  float v1;
  int *v2;
  unsigned int v3:15;
};
//SIG(1 F_Ip_BFu15i) C1{ Fi Fp Fi:15}



static void Test_F_Ip_BFu15i()
{
  {
    init_simple_test("F_Ip_BFu15i");
    static STRUCT_IF_C F_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "F_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "F_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu15i, F_Ip_BFu15i)
//============================================================================


struct  F_Ip_BFu15ll  {
  float v1;
  int *v2;
  __tsu64 v3:15;
};
//SIG(1 F_Ip_BFu15ll) C1{ Fi Fp FL:15}



static void Test_F_Ip_BFu15ll()
{
  {
    init_simple_test("F_Ip_BFu15ll");
    static STRUCT_IF_C F_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "F_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "F_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu15ll, F_Ip_BFu15ll)
//============================================================================


struct  F_Ip_BFu15s  {
  float v1;
  int *v2;
  unsigned short v3:15;
};
//SIG(1 F_Ip_BFu15s) C1{ Fi Fp Fs:15}



static void Test_F_Ip_BFu15s()
{
  {
    init_simple_test("F_Ip_BFu15s");
    static STRUCT_IF_C F_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "F_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "F_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu15s, F_Ip_BFu15s)
//============================================================================


struct  F_Ip_BFu16i  {
  float v1;
  int *v2;
  unsigned int v3:16;
};
//SIG(1 F_Ip_BFu16i) C1{ Fi Fp Fi:16}



static void Test_F_Ip_BFu16i()
{
  {
    init_simple_test("F_Ip_BFu16i");
    static STRUCT_IF_C F_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "F_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "F_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu16i, F_Ip_BFu16i)
//============================================================================


struct  F_Ip_BFu16ll  {
  float v1;
  int *v2;
  __tsu64 v3:16;
};
//SIG(1 F_Ip_BFu16ll) C1{ Fi Fp FL:16}



static void Test_F_Ip_BFu16ll()
{
  {
    init_simple_test("F_Ip_BFu16ll");
    static STRUCT_IF_C F_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "F_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "F_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu16ll, F_Ip_BFu16ll)
//============================================================================


struct  F_Ip_BFu16s  {
  float v1;
  int *v2;
  unsigned short v3:16;
};
//SIG(1 F_Ip_BFu16s) C1{ Fi Fp Fs:16}



static void Test_F_Ip_BFu16s()
{
  {
    init_simple_test("F_Ip_BFu16s");
    static STRUCT_IF_C F_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "F_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "F_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu16s, F_Ip_BFu16s)
//============================================================================


struct  F_Ip_BFu17i  {
  float v1;
  int *v2;
  unsigned int v3:17;
};
//SIG(1 F_Ip_BFu17i) C1{ Fi Fp Fi:17}



static void Test_F_Ip_BFu17i()
{
  {
    init_simple_test("F_Ip_BFu17i");
    static STRUCT_IF_C F_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "F_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "F_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu17i, F_Ip_BFu17i)
//============================================================================


struct  F_Ip_BFu17ll  {
  float v1;
  int *v2;
  __tsu64 v3:17;
};
//SIG(1 F_Ip_BFu17ll) C1{ Fi Fp FL:17}



static void Test_F_Ip_BFu17ll()
{
  {
    init_simple_test("F_Ip_BFu17ll");
    static STRUCT_IF_C F_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "F_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "F_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu17ll, F_Ip_BFu17ll)
//============================================================================


struct  F_Ip_BFu1c  {
  float v1;
  int *v2;
  unsigned char v3:1;
};
//SIG(1 F_Ip_BFu1c) C1{ Fi Fp Fc:1}



static void Test_F_Ip_BFu1c()
{
  {
    init_simple_test("F_Ip_BFu1c");
    static STRUCT_IF_C F_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "F_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu1c, F_Ip_BFu1c)
//============================================================================


struct  F_Ip_BFu1i  {
  float v1;
  int *v2;
  unsigned int v3:1;
};
//SIG(1 F_Ip_BFu1i) C1{ Fi Fp Fi:1}



static void Test_F_Ip_BFu1i()
{
  {
    init_simple_test("F_Ip_BFu1i");
    static STRUCT_IF_C F_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "F_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu1i, F_Ip_BFu1i)
//============================================================================


struct  F_Ip_BFu1ll  {
  float v1;
  int *v2;
  __tsu64 v3:1;
};
//SIG(1 F_Ip_BFu1ll) C1{ Fi Fp FL:1}



static void Test_F_Ip_BFu1ll()
{
  {
    init_simple_test("F_Ip_BFu1ll");
    static STRUCT_IF_C F_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "F_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu1ll, F_Ip_BFu1ll)
//============================================================================


struct  F_Ip_BFu1s  {
  float v1;
  int *v2;
  unsigned short v3:1;
};
//SIG(1 F_Ip_BFu1s) C1{ Fi Fp Fs:1}



static void Test_F_Ip_BFu1s()
{
  {
    init_simple_test("F_Ip_BFu1s");
    static STRUCT_IF_C F_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "F_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu1s, F_Ip_BFu1s)
//============================================================================


struct  F_Ip_BFu31i  {
  float v1;
  int *v2;
  unsigned int v3:31;
};
//SIG(1 F_Ip_BFu31i) C1{ Fi Fp Fi:31}



static void Test_F_Ip_BFu31i()
{
  {
    init_simple_test("F_Ip_BFu31i");
    static STRUCT_IF_C F_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "F_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "F_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu31i, F_Ip_BFu31i)
//============================================================================


struct  F_Ip_BFu31ll  {
  float v1;
  int *v2;
  __tsu64 v3:31;
};
//SIG(1 F_Ip_BFu31ll) C1{ Fi Fp FL:31}



static void Test_F_Ip_BFu31ll()
{
  {
    init_simple_test("F_Ip_BFu31ll");
    static STRUCT_IF_C F_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "F_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "F_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu31ll, F_Ip_BFu31ll)
//============================================================================


struct  F_Ip_BFu32i  {
  float v1;
  int *v2;
  unsigned int v3:32;
};
//SIG(1 F_Ip_BFu32i) C1{ Fi Fp Fi:32}



static void Test_F_Ip_BFu32i()
{
  {
    init_simple_test("F_Ip_BFu32i");
    static STRUCT_IF_C F_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "F_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "F_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu32i, F_Ip_BFu32i)
//============================================================================


struct  F_Ip_BFu32ll  {
  float v1;
  int *v2;
  __tsu64 v3:32;
};
//SIG(1 F_Ip_BFu32ll) C1{ Fi Fp FL:32}



static void Test_F_Ip_BFu32ll()
{
  {
    init_simple_test("F_Ip_BFu32ll");
    static STRUCT_IF_C F_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "F_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "F_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu32ll, F_Ip_BFu32ll)
//============================================================================


struct  F_Ip_BFu33  {
  float v1;
  int *v2;
  __tsu64 v3:33;
};
//SIG(1 F_Ip_BFu33) C1{ Fi Fp FL:33}



static void Test_F_Ip_BFu33()
{
  {
    init_simple_test("F_Ip_BFu33");
    static STRUCT_IF_C F_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "F_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "F_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu33, F_Ip_BFu33)
//============================================================================


struct  F_Ip_BFu7c  {
  float v1;
  int *v2;
  unsigned char v3:7;
};
//SIG(1 F_Ip_BFu7c) C1{ Fi Fp Fc:7}



static void Test_F_Ip_BFu7c()
{
  {
    init_simple_test("F_Ip_BFu7c");
    static STRUCT_IF_C F_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "F_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "F_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu7c, F_Ip_BFu7c)
//============================================================================


struct  F_Ip_BFu7i  {
  float v1;
  int *v2;
  unsigned int v3:7;
};
//SIG(1 F_Ip_BFu7i) C1{ Fi Fp Fi:7}



static void Test_F_Ip_BFu7i()
{
  {
    init_simple_test("F_Ip_BFu7i");
    static STRUCT_IF_C F_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "F_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "F_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu7i, F_Ip_BFu7i)
//============================================================================


struct  F_Ip_BFu7ll  {
  float v1;
  int *v2;
  __tsu64 v3:7;
};
//SIG(1 F_Ip_BFu7ll) C1{ Fi Fp FL:7}



static void Test_F_Ip_BFu7ll()
{
  {
    init_simple_test("F_Ip_BFu7ll");
    static STRUCT_IF_C F_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "F_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "F_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu7ll, F_Ip_BFu7ll)
//============================================================================


struct  F_Ip_BFu7s  {
  float v1;
  int *v2;
  unsigned short v3:7;
};
//SIG(1 F_Ip_BFu7s) C1{ Fi Fp Fs:7}



static void Test_F_Ip_BFu7s()
{
  {
    init_simple_test("F_Ip_BFu7s");
    static STRUCT_IF_C F_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "F_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "F_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu7s, F_Ip_BFu7s)
//============================================================================


struct  F_Ip_BFu8c  {
  float v1;
  int *v2;
  unsigned char v3:8;
};
//SIG(1 F_Ip_BFu8c) C1{ Fi Fp Fc:8}



static void Test_F_Ip_BFu8c()
{
  {
    init_simple_test("F_Ip_BFu8c");
    static STRUCT_IF_C F_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "F_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "F_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu8c, F_Ip_BFu8c)
//============================================================================


struct  F_Ip_BFu8i  {
  float v1;
  int *v2;
  unsigned int v3:8;
};
//SIG(1 F_Ip_BFu8i) C1{ Fi Fp Fi:8}



static void Test_F_Ip_BFu8i()
{
  {
    init_simple_test("F_Ip_BFu8i");
    static STRUCT_IF_C F_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "F_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "F_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu8i, F_Ip_BFu8i)
//============================================================================


struct  F_Ip_BFu8ll  {
  float v1;
  int *v2;
  __tsu64 v3:8;
};
//SIG(1 F_Ip_BFu8ll) C1{ Fi Fp FL:8}



static void Test_F_Ip_BFu8ll()
{
  {
    init_simple_test("F_Ip_BFu8ll");
    static STRUCT_IF_C F_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "F_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "F_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu8ll, F_Ip_BFu8ll)
//============================================================================


struct  F_Ip_BFu8s  {
  float v1;
  int *v2;
  unsigned short v3:8;
};
//SIG(1 F_Ip_BFu8s) C1{ Fi Fp Fs:8}



static void Test_F_Ip_BFu8s()
{
  {
    init_simple_test("F_Ip_BFu8s");
    static STRUCT_IF_C F_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "F_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "F_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu8s, F_Ip_BFu8s)
//============================================================================


struct  F_Ip_BFu9i  {
  float v1;
  int *v2;
  unsigned int v3:9;
};
//SIG(1 F_Ip_BFu9i) C1{ Fi Fp Fi:9}



static void Test_F_Ip_BFu9i()
{
  {
    init_simple_test("F_Ip_BFu9i");
    static STRUCT_IF_C F_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "F_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "F_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu9i, F_Ip_BFu9i)
//============================================================================


struct  F_Ip_BFu9ll  {
  float v1;
  int *v2;
  __tsu64 v3:9;
};
//SIG(1 F_Ip_BFu9ll) C1{ Fi Fp FL:9}



static void Test_F_Ip_BFu9ll()
{
  {
    init_simple_test("F_Ip_BFu9ll");
    static STRUCT_IF_C F_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "F_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "F_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu9ll, F_Ip_BFu9ll)
//============================================================================


struct  F_Ip_BFu9s  {
  float v1;
  int *v2;
  unsigned short v3:9;
};
//SIG(1 F_Ip_BFu9s) C1{ Fi Fp Fs:9}



static void Test_F_Ip_BFu9s()
{
  {
    init_simple_test("F_Ip_BFu9s");
    static STRUCT_IF_C F_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "F_Ip_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "F_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "F_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_BFu9s, F_Ip_BFu9s)
//============================================================================


struct  F_Ip_C  {
  float v1;
  int *v2;
  char v3;
};
//SIG(1 F_Ip_C) C1{ Fi Fp Fc}



static void Test_F_Ip_C()
{
  {
    init_simple_test("F_Ip_C");
    STRUCT_IF_C F_Ip_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_C)");
    check_field_offset(lv, v1, 0, "F_Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_C, F_Ip_C)
//============================================================================


struct  F_Ip_D  {
  float v1;
  int *v2;
  double v3;
};
//SIG(1 F_Ip_D) C1{ Fi Fp FL}



static void Test_F_Ip_D()
{
  {
    init_simple_test("F_Ip_D");
    STRUCT_IF_C F_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_D)");
    check_field_offset(lv, v1, 0, "F_Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_D, F_Ip_D)
//============================================================================


struct  F_Ip_F  {
  float v1;
  int *v2;
  float v3;
};
//SIG(1 F_Ip_F) C1{ Fi Fp Fi}



static void Test_F_Ip_F()
{
  {
    init_simple_test("F_Ip_F");
    STRUCT_IF_C F_Ip_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_F)");
    check_field_offset(lv, v1, 0, "F_Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_F, F_Ip_F)
//============================================================================


struct  F_Ip_I  {
  float v1;
  int *v2;
  int v3;
};
//SIG(1 F_Ip_I) C1{ Fi Fp Fi}



static void Test_F_Ip_I()
{
  {
    init_simple_test("F_Ip_I");
    STRUCT_IF_C F_Ip_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_I)");
    check_field_offset(lv, v1, 0, "F_Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_I, F_Ip_I)
//============================================================================


struct  F_Ip_Ip  {
  float v1;
  int *v2;
  int *v3;
};
//SIG(1 F_Ip_Ip) C1{ Fi Fp[2]}



static void Test_F_Ip_Ip()
{
  {
    init_simple_test("F_Ip_Ip");
    STRUCT_IF_C F_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_Ip)");
    check_field_offset(lv, v1, 0, "F_Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_Ip, F_Ip_Ip)
//============================================================================


struct  F_Ip_L  {
  float v1;
  int *v2;
  __tsi64 v3;
};
//SIG(1 F_Ip_L) C1{ Fi Fp FL}



static void Test_F_Ip_L()
{
  {
    init_simple_test("F_Ip_L");
    STRUCT_IF_C F_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ip_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_L)");
    check_field_offset(lv, v1, 0, "F_Ip_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_L, F_Ip_L)
//============================================================================


struct  F_Ip_S  {
  float v1;
  int *v2;
  short v3;
};
//SIG(1 F_Ip_S) C1{ Fi Fp Fs}



static void Test_F_Ip_S()
{
  {
    init_simple_test("F_Ip_S");
    STRUCT_IF_C F_Ip_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_S)");
    check_field_offset(lv, v1, 0, "F_Ip_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_S, F_Ip_S)
//============================================================================


struct  F_Ip_Uc  {
  float v1;
  int *v2;
  unsigned char v3;
};
//SIG(1 F_Ip_Uc) C1{ Fi Fp Fc}



static void Test_F_Ip_Uc()
{
  {
    init_simple_test("F_Ip_Uc");
    STRUCT_IF_C F_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_Uc)");
    check_field_offset(lv, v1, 0, "F_Ip_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_Uc, F_Ip_Uc)
//============================================================================


struct  F_Ip_Ui  {
  float v1;
  int *v2;
  unsigned int v3;
};
//SIG(1 F_Ip_Ui) C1{ Fi Fp Fi}



static void Test_F_Ip_Ui()
{
  {
    init_simple_test("F_Ip_Ui");
    STRUCT_IF_C F_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_Ui)");
    check_field_offset(lv, v1, 0, "F_Ip_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_Ui, F_Ip_Ui)
//============================================================================


struct  F_Ip_Ul  {
  float v1;
  int *v2;
  __tsu64 v3;
};
//SIG(1 F_Ip_Ul) C1{ Fi Fp FL}



static void Test_F_Ip_Ul()
{
  {
    init_simple_test("F_Ip_Ul");
    STRUCT_IF_C F_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ip_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_Ul)");
    check_field_offset(lv, v1, 0, "F_Ip_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_Ul, F_Ip_Ul)
//============================================================================


struct  F_Ip_Us  {
  float v1;
  int *v2;
  unsigned short v3;
};
//SIG(1 F_Ip_Us) C1{ Fi Fp Fs}



static void Test_F_Ip_Us()
{
  {
    init_simple_test("F_Ip_Us");
    STRUCT_IF_C F_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_Us)");
    check_field_offset(lv, v1, 0, "F_Ip_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_Us, F_Ip_Us)
//============================================================================


struct  F_Ip_Vp  {
  float v1;
  int *v2;
  void *v3;
};
//SIG(1 F_Ip_Vp) C1{ Fi Fp[2]}



static void Test_F_Ip_Vp()
{
  {
    init_simple_test("F_Ip_Vp");
    STRUCT_IF_C F_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Ip_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ip_Vp)");
    check_field_offset(lv, v1, 0, "F_Ip_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ip_Vp, F_Ip_Vp)
//============================================================================


struct  F_L  {
  float v1;
  __tsi64 v2;
};
//SIG(1 F_L) C1{ Fi FL}



static void Test_F_L()
{
  {
    init_simple_test("F_L");
    STRUCT_IF_C F_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L)");
    check_field_offset(lv, v1, 0, "F_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L, F_L)
//============================================================================


struct  F_L_BFu15i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:15;
};
//SIG(1 F_L_BFu15i) C1{ Fi FL Fi:15}



static void Test_F_L_BFu15i()
{
  {
    init_simple_test("F_L_BFu15i");
    static STRUCT_IF_C F_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu15i)");
    check_field_offset(lv, v1, 0, "F_L_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_L_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu15i, F_L_BFu15i)
//============================================================================


struct  F_L_BFu15ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:15;
};
//SIG(1 F_L_BFu15ll) C1{ Fi FL FL:15}



static void Test_F_L_BFu15ll()
{
  {
    init_simple_test("F_L_BFu15ll");
    static STRUCT_IF_C F_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_L_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu15ll, F_L_BFu15ll)
//============================================================================


struct  F_L_BFu15s  {
  float v1;
  __tsi64 v2;
  unsigned short v3:15;
};
//SIG(1 F_L_BFu15s) C1{ Fi FL Fs:15}



static void Test_F_L_BFu15s()
{
  {
    init_simple_test("F_L_BFu15s");
    static STRUCT_IF_C F_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu15s)");
    check_field_offset(lv, v1, 0, "F_L_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_L_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu15s, F_L_BFu15s)
//============================================================================


struct  F_L_BFu16i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:16;
};
//SIG(1 F_L_BFu16i) C1{ Fi FL Fi:16}



static void Test_F_L_BFu16i()
{
  {
    init_simple_test("F_L_BFu16i");
    static STRUCT_IF_C F_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu16i)");
    check_field_offset(lv, v1, 0, "F_L_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_L_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu16i, F_L_BFu16i)
//============================================================================


struct  F_L_BFu16ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:16;
};
//SIG(1 F_L_BFu16ll) C1{ Fi FL FL:16}



static void Test_F_L_BFu16ll()
{
  {
    init_simple_test("F_L_BFu16ll");
    static STRUCT_IF_C F_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_L_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu16ll, F_L_BFu16ll)
//============================================================================


struct  F_L_BFu16s  {
  float v1;
  __tsi64 v2;
  unsigned short v3:16;
};
//SIG(1 F_L_BFu16s) C1{ Fi FL Fs:16}



static void Test_F_L_BFu16s()
{
  {
    init_simple_test("F_L_BFu16s");
    static STRUCT_IF_C F_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu16s)");
    check_field_offset(lv, v1, 0, "F_L_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_L_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu16s, F_L_BFu16s)
//============================================================================


struct  F_L_BFu17i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:17;
};
//SIG(1 F_L_BFu17i) C1{ Fi FL Fi:17}



static void Test_F_L_BFu17i()
{
  {
    init_simple_test("F_L_BFu17i");
    static STRUCT_IF_C F_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu17i)");
    check_field_offset(lv, v1, 0, "F_L_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "F_L_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "F_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu17i, F_L_BFu17i)
//============================================================================


struct  F_L_BFu17ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:17;
};
//SIG(1 F_L_BFu17ll) C1{ Fi FL FL:17}



static void Test_F_L_BFu17ll()
{
  {
    init_simple_test("F_L_BFu17ll");
    static STRUCT_IF_C F_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "F_L_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "F_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu17ll, F_L_BFu17ll)
//============================================================================


struct  F_L_BFu1c  {
  float v1;
  __tsi64 v2;
  unsigned char v3:1;
};
//SIG(1 F_L_BFu1c) C1{ Fi FL Fc:1}



static void Test_F_L_BFu1c()
{
  {
    init_simple_test("F_L_BFu1c");
    static STRUCT_IF_C F_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu1c)");
    check_field_offset(lv, v1, 0, "F_L_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu1c, F_L_BFu1c)
//============================================================================


struct  F_L_BFu1i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:1;
};
//SIG(1 F_L_BFu1i) C1{ Fi FL Fi:1}



static void Test_F_L_BFu1i()
{
  {
    init_simple_test("F_L_BFu1i");
    static STRUCT_IF_C F_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu1i)");
    check_field_offset(lv, v1, 0, "F_L_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu1i, F_L_BFu1i)
//============================================================================


struct  F_L_BFu1ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:1;
};
//SIG(1 F_L_BFu1ll) C1{ Fi FL FL:1}



static void Test_F_L_BFu1ll()
{
  {
    init_simple_test("F_L_BFu1ll");
    static STRUCT_IF_C F_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu1ll, F_L_BFu1ll)
//============================================================================


struct  F_L_BFu1s  {
  float v1;
  __tsi64 v2;
  unsigned short v3:1;
};
//SIG(1 F_L_BFu1s) C1{ Fi FL Fs:1}



static void Test_F_L_BFu1s()
{
  {
    init_simple_test("F_L_BFu1s");
    static STRUCT_IF_C F_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu1s)");
    check_field_offset(lv, v1, 0, "F_L_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu1s, F_L_BFu1s)
//============================================================================


struct  F_L_BFu31i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:31;
};
//SIG(1 F_L_BFu31i) C1{ Fi FL Fi:31}



static void Test_F_L_BFu31i()
{
  {
    init_simple_test("F_L_BFu31i");
    static STRUCT_IF_C F_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu31i)");
    check_field_offset(lv, v1, 0, "F_L_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "F_L_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "F_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu31i, F_L_BFu31i)
//============================================================================


struct  F_L_BFu31ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:31;
};
//SIG(1 F_L_BFu31ll) C1{ Fi FL FL:31}



static void Test_F_L_BFu31ll()
{
  {
    init_simple_test("F_L_BFu31ll");
    static STRUCT_IF_C F_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "F_L_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "F_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu31ll, F_L_BFu31ll)
//============================================================================


struct  F_L_BFu32i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:32;
};
//SIG(1 F_L_BFu32i) C1{ Fi FL Fi:32}



static void Test_F_L_BFu32i()
{
  {
    init_simple_test("F_L_BFu32i");
    static STRUCT_IF_C F_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu32i)");
    check_field_offset(lv, v1, 0, "F_L_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "F_L_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "F_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu32i, F_L_BFu32i)
//============================================================================


struct  F_L_BFu32ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:32;
};
//SIG(1 F_L_BFu32ll) C1{ Fi FL FL:32}



static void Test_F_L_BFu32ll()
{
  {
    init_simple_test("F_L_BFu32ll");
    static STRUCT_IF_C F_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "F_L_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "F_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu32ll, F_L_BFu32ll)
//============================================================================


struct  F_L_BFu33  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:33;
};
//SIG(1 F_L_BFu33) C1{ Fi FL FL:33}



static void Test_F_L_BFu33()
{
  {
    init_simple_test("F_L_BFu33");
    static STRUCT_IF_C F_L_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_L_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu33)");
    check_field_offset(lv, v1, 0, "F_L_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "F_L_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "F_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu33, F_L_BFu33)
//============================================================================


struct  F_L_BFu7c  {
  float v1;
  __tsi64 v2;
  unsigned char v3:7;
};
//SIG(1 F_L_BFu7c) C1{ Fi FL Fc:7}



static void Test_F_L_BFu7c()
{
  {
    init_simple_test("F_L_BFu7c");
    static STRUCT_IF_C F_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu7c)");
    check_field_offset(lv, v1, 0, "F_L_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_L_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu7c, F_L_BFu7c)
//============================================================================


struct  F_L_BFu7i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:7;
};
//SIG(1 F_L_BFu7i) C1{ Fi FL Fi:7}



static void Test_F_L_BFu7i()
{
  {
    init_simple_test("F_L_BFu7i");
    static STRUCT_IF_C F_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu7i)");
    check_field_offset(lv, v1, 0, "F_L_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_L_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu7i, F_L_BFu7i)
//============================================================================


struct  F_L_BFu7ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:7;
};
//SIG(1 F_L_BFu7ll) C1{ Fi FL FL:7}



static void Test_F_L_BFu7ll()
{
  {
    init_simple_test("F_L_BFu7ll");
    static STRUCT_IF_C F_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_L_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu7ll, F_L_BFu7ll)
//============================================================================


struct  F_L_BFu7s  {
  float v1;
  __tsi64 v2;
  unsigned short v3:7;
};
//SIG(1 F_L_BFu7s) C1{ Fi FL Fs:7}



static void Test_F_L_BFu7s()
{
  {
    init_simple_test("F_L_BFu7s");
    static STRUCT_IF_C F_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu7s)");
    check_field_offset(lv, v1, 0, "F_L_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_L_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu7s, F_L_BFu7s)
//============================================================================


struct  F_L_BFu8c  {
  float v1;
  __tsi64 v2;
  unsigned char v3:8;
};
//SIG(1 F_L_BFu8c) C1{ Fi FL Fc:8}



static void Test_F_L_BFu8c()
{
  {
    init_simple_test("F_L_BFu8c");
    static STRUCT_IF_C F_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu8c)");
    check_field_offset(lv, v1, 0, "F_L_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_L_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu8c, F_L_BFu8c)
//============================================================================


struct  F_L_BFu8i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:8;
};
//SIG(1 F_L_BFu8i) C1{ Fi FL Fi:8}



static void Test_F_L_BFu8i()
{
  {
    init_simple_test("F_L_BFu8i");
    static STRUCT_IF_C F_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu8i)");
    check_field_offset(lv, v1, 0, "F_L_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_L_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu8i, F_L_BFu8i)
//============================================================================


struct  F_L_BFu8ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:8;
};
//SIG(1 F_L_BFu8ll) C1{ Fi FL FL:8}



static void Test_F_L_BFu8ll()
{
  {
    init_simple_test("F_L_BFu8ll");
    static STRUCT_IF_C F_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_L_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu8ll, F_L_BFu8ll)
//============================================================================


struct  F_L_BFu8s  {
  float v1;
  __tsi64 v2;
  unsigned short v3:8;
};
//SIG(1 F_L_BFu8s) C1{ Fi FL Fs:8}



static void Test_F_L_BFu8s()
{
  {
    init_simple_test("F_L_BFu8s");
    static STRUCT_IF_C F_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu8s)");
    check_field_offset(lv, v1, 0, "F_L_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_L_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu8s, F_L_BFu8s)
//============================================================================


struct  F_L_BFu9i  {
  float v1;
  __tsi64 v2;
  unsigned int v3:9;
};
//SIG(1 F_L_BFu9i) C1{ Fi FL Fi:9}



static void Test_F_L_BFu9i()
{
  {
    init_simple_test("F_L_BFu9i");
    static STRUCT_IF_C F_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu9i)");
    check_field_offset(lv, v1, 0, "F_L_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_L_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu9i, F_L_BFu9i)
//============================================================================


struct  F_L_BFu9ll  {
  float v1;
  __tsi64 v2;
  __tsu64 v3:9;
};
//SIG(1 F_L_BFu9ll) C1{ Fi FL FL:9}



static void Test_F_L_BFu9ll()
{
  {
    init_simple_test("F_L_BFu9ll");
    static STRUCT_IF_C F_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_L_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_L_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu9ll, F_L_BFu9ll)
//============================================================================


struct  F_L_BFu9s  {
  float v1;
  __tsi64 v2;
  unsigned short v3:9;
};
//SIG(1 F_L_BFu9s) C1{ Fi FL Fs:9}



static void Test_F_L_BFu9s()
{
  {
    init_simple_test("F_L_BFu9s");
    static STRUCT_IF_C F_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_BFu9s)");
    check_field_offset(lv, v1, 0, "F_L_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_L_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_BFu9s, F_L_BFu9s)
//============================================================================


struct  F_L_C  {
  float v1;
  __tsi64 v2;
  char v3;
};
//SIG(1 F_L_C) C1{ Fi FL Fc}



static void Test_F_L_C()
{
  {
    init_simple_test("F_L_C");
    STRUCT_IF_C F_L_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_C)");
    check_field_offset(lv, v1, 0, "F_L_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_C, F_L_C)
//============================================================================


struct  F_L_D  {
  float v1;
  __tsi64 v2;
  double v3;
};
//SIG(1 F_L_D) C1{ Fi FL[2]}



static void Test_F_L_D()
{
  {
    init_simple_test("F_L_D");
    STRUCT_IF_C F_L_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_L_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_D)");
    check_field_offset(lv, v1, 0, "F_L_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_D, F_L_D)
//============================================================================


struct  F_L_F  {
  float v1;
  __tsi64 v2;
  float v3;
};
//SIG(1 F_L_F) C1{ Fi FL Fi}



static void Test_F_L_F()
{
  {
    init_simple_test("F_L_F");
    STRUCT_IF_C F_L_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_F)");
    check_field_offset(lv, v1, 0, "F_L_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_F, F_L_F)
//============================================================================


struct  F_L_I  {
  float v1;
  __tsi64 v2;
  int v3;
};
//SIG(1 F_L_I) C1{ Fi FL Fi}



static void Test_F_L_I()
{
  {
    init_simple_test("F_L_I");
    STRUCT_IF_C F_L_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_I)");
    check_field_offset(lv, v1, 0, "F_L_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_I, F_L_I)
//============================================================================


struct  F_L_Ip  {
  float v1;
  __tsi64 v2;
  int *v3;
};
//SIG(1 F_L_Ip) C1{ Fi FL Fp}



static void Test_F_L_Ip()
{
  {
    init_simple_test("F_L_Ip");
    STRUCT_IF_C F_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_Ip)");
    check_field_offset(lv, v1, 0, "F_L_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_Ip, F_L_Ip)
//============================================================================


struct  F_L_L  {
  float v1;
  __tsi64 v2;
  __tsi64 v3;
};
//SIG(1 F_L_L) C1{ Fi FL[2]}



static void Test_F_L_L()
{
  {
    init_simple_test("F_L_L");
    STRUCT_IF_C F_L_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_L_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_L)");
    check_field_offset(lv, v1, 0, "F_L_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_L, F_L_L)
//============================================================================


struct  F_L_S  {
  float v1;
  __tsi64 v2;
  short v3;
};
//SIG(1 F_L_S) C1{ Fi FL Fs}



static void Test_F_L_S()
{
  {
    init_simple_test("F_L_S");
    STRUCT_IF_C F_L_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_S)");
    check_field_offset(lv, v1, 0, "F_L_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_S, F_L_S)
//============================================================================


struct  F_L_Uc  {
  float v1;
  __tsi64 v2;
  unsigned char v3;
};
//SIG(1 F_L_Uc) C1{ Fi FL Fc}



static void Test_F_L_Uc()
{
  {
    init_simple_test("F_L_Uc");
    STRUCT_IF_C F_L_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_Uc)");
    check_field_offset(lv, v1, 0, "F_L_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_Uc, F_L_Uc)
//============================================================================


struct  F_L_Ui  {
  float v1;
  __tsi64 v2;
  unsigned int v3;
};
//SIG(1 F_L_Ui) C1{ Fi FL Fi}



static void Test_F_L_Ui()
{
  {
    init_simple_test("F_L_Ui");
    STRUCT_IF_C F_L_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_Ui)");
    check_field_offset(lv, v1, 0, "F_L_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_Ui, F_L_Ui)
//============================================================================


struct  F_L_Ul  {
  float v1;
  __tsi64 v2;
  __tsu64 v3;
};
//SIG(1 F_L_Ul) C1{ Fi FL[2]}



static void Test_F_L_Ul()
{
  {
    init_simple_test("F_L_Ul");
    STRUCT_IF_C F_L_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_Ul)");
    check_field_offset(lv, v1, 0, "F_L_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_Ul, F_L_Ul)
//============================================================================


struct  F_L_Us  {
  float v1;
  __tsi64 v2;
  unsigned short v3;
};
//SIG(1 F_L_Us) C1{ Fi FL Fs}



static void Test_F_L_Us()
{
  {
    init_simple_test("F_L_Us");
    STRUCT_IF_C F_L_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_Us)");
    check_field_offset(lv, v1, 0, "F_L_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_Us, F_L_Us)
//============================================================================


struct  F_L_Vp  {
  float v1;
  __tsi64 v2;
  void *v3;
};
//SIG(1 F_L_Vp) C1{ Fi FL Fp}



static void Test_F_L_Vp()
{
  {
    init_simple_test("F_L_Vp");
    STRUCT_IF_C F_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_L_Vp)");
    check_field_offset(lv, v1, 0, "F_L_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_L_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_L_Vp, F_L_Vp)
//============================================================================


struct  F_S  {
  float v1;
  short v2;
};
//SIG(1 F_S) C1{ Fi Fs}



static void Test_F_S()
{
  {
    init_simple_test("F_S");
    STRUCT_IF_C F_S lv;
    check2(sizeof(lv), 8, "sizeof(F_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_S)");
    check_field_offset(lv, v1, 0, "F_S.v1");
    check_field_offset(lv, v2, 4, "F_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S, F_S)
//============================================================================


struct  F_S_BFu15i  {
  float v1;
  short v2;
  unsigned int v3:15;
};
//SIG(1 F_S_BFu15i) C1{ Fi Fs Fi:15}



static void Test_F_S_BFu15i()
{
  {
    init_simple_test("F_S_BFu15i");
    static STRUCT_IF_C F_S_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu15i)");
    check_field_offset(lv, v1, 0, "F_S_BFu15i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_S_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu15i, F_S_BFu15i)
//============================================================================


struct  F_S_BFu15ll  {
  float v1;
  short v2;
  __tsu64 v3:15;
};
//SIG(1 F_S_BFu15ll) C1{ Fi Fs FL:15}



static void Test_F_S_BFu15ll()
{
  {
    init_simple_test("F_S_BFu15ll");
    static STRUCT_IF_C F_S_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_S_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu15ll, F_S_BFu15ll)
//============================================================================


struct  F_S_BFu15s  {
  float v1;
  short v2;
  unsigned short v3:15;
};
//SIG(1 F_S_BFu15s) C1{ Fi Fs Fs:15}



static void Test_F_S_BFu15s()
{
  {
    init_simple_test("F_S_BFu15s");
    static STRUCT_IF_C F_S_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu15s)");
    check_field_offset(lv, v1, 0, "F_S_BFu15s.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_S_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu15s, F_S_BFu15s)
//============================================================================


struct  F_S_BFu16i  {
  float v1;
  short v2;
  unsigned int v3:16;
};
//SIG(1 F_S_BFu16i) C1{ Fi Fs Fi:16}



static void Test_F_S_BFu16i()
{
  {
    init_simple_test("F_S_BFu16i");
    static STRUCT_IF_C F_S_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu16i)");
    check_field_offset(lv, v1, 0, "F_S_BFu16i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_S_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu16i, F_S_BFu16i)
//============================================================================


struct  F_S_BFu16ll  {
  float v1;
  short v2;
  __tsu64 v3:16;
};
//SIG(1 F_S_BFu16ll) C1{ Fi Fs FL:16}



static void Test_F_S_BFu16ll()
{
  {
    init_simple_test("F_S_BFu16ll");
    static STRUCT_IF_C F_S_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_S_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu16ll, F_S_BFu16ll)
//============================================================================


struct  F_S_BFu16s  {
  float v1;
  short v2;
  unsigned short v3:16;
};
//SIG(1 F_S_BFu16s) C1{ Fi Fs Fs:16}



static void Test_F_S_BFu16s()
{
  {
    init_simple_test("F_S_BFu16s");
    static STRUCT_IF_C F_S_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu16s)");
    check_field_offset(lv, v1, 0, "F_S_BFu16s.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_S_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu16s, F_S_BFu16s)
//============================================================================


struct  F_S_BFu17i  {
  float v1;
  short v2;
  unsigned int v3:17;
};
//SIG(1 F_S_BFu17i) C1{ Fi Fs Fi:17}



static void Test_F_S_BFu17i()
{
  {
    init_simple_test("F_S_BFu17i");
    static STRUCT_IF_C F_S_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(F_S_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu17i)");
    check_field_offset(lv, v1, 0, "F_S_BFu17i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_S_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu17i, F_S_BFu17i)
//============================================================================


struct  F_S_BFu17ll  {
  float v1;
  short v2;
  __tsu64 v3:17;
};
//SIG(1 F_S_BFu17ll) C1{ Fi Fs FL:17}



static void Test_F_S_BFu17ll()
{
  {
    init_simple_test("F_S_BFu17ll");
    static STRUCT_IF_C F_S_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "F_S_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "F_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu17ll, F_S_BFu17ll)
//============================================================================


struct  F_S_BFu1c  {
  float v1;
  short v2;
  unsigned char v3:1;
};
//SIG(1 F_S_BFu1c) C1{ Fi Fs Fc:1}



static void Test_F_S_BFu1c()
{
  {
    init_simple_test("F_S_BFu1c");
    static STRUCT_IF_C F_S_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu1c)");
    check_field_offset(lv, v1, 0, "F_S_BFu1c.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu1c, F_S_BFu1c)
//============================================================================


struct  F_S_BFu1i  {
  float v1;
  short v2;
  unsigned int v3:1;
};
//SIG(1 F_S_BFu1i) C1{ Fi Fs Fi:1}



static void Test_F_S_BFu1i()
{
  {
    init_simple_test("F_S_BFu1i");
    static STRUCT_IF_C F_S_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu1i)");
    check_field_offset(lv, v1, 0, "F_S_BFu1i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu1i, F_S_BFu1i)
//============================================================================


struct  F_S_BFu1ll  {
  float v1;
  short v2;
  __tsu64 v3:1;
};
//SIG(1 F_S_BFu1ll) C1{ Fi Fs FL:1}



static void Test_F_S_BFu1ll()
{
  {
    init_simple_test("F_S_BFu1ll");
    static STRUCT_IF_C F_S_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu1ll, F_S_BFu1ll)
//============================================================================


struct  F_S_BFu1s  {
  float v1;
  short v2;
  unsigned short v3:1;
};
//SIG(1 F_S_BFu1s) C1{ Fi Fs Fs:1}



static void Test_F_S_BFu1s()
{
  {
    init_simple_test("F_S_BFu1s");
    static STRUCT_IF_C F_S_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu1s)");
    check_field_offset(lv, v1, 0, "F_S_BFu1s.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu1s, F_S_BFu1s)
//============================================================================


struct  F_S_BFu31i  {
  float v1;
  short v2;
  unsigned int v3:31;
};
//SIG(1 F_S_BFu31i) C1{ Fi Fs Fi:31}



static void Test_F_S_BFu31i()
{
  {
    init_simple_test("F_S_BFu31i");
    static STRUCT_IF_C F_S_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_S_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu31i)");
    check_field_offset(lv, v1, 0, "F_S_BFu31i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_S_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu31i, F_S_BFu31i)
//============================================================================


struct  F_S_BFu31ll  {
  float v1;
  short v2;
  __tsu64 v3:31;
};
//SIG(1 F_S_BFu31ll) C1{ Fi Fs FL:31}



static void Test_F_S_BFu31ll()
{
  {
    init_simple_test("F_S_BFu31ll");
    static STRUCT_IF_C F_S_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "F_S_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "F_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu31ll, F_S_BFu31ll)
//============================================================================


struct  F_S_BFu32i  {
  float v1;
  short v2;
  unsigned int v3:32;
};
//SIG(1 F_S_BFu32i) C1{ Fi Fs Fi:32}



static void Test_F_S_BFu32i()
{
  {
    init_simple_test("F_S_BFu32i");
    static STRUCT_IF_C F_S_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_S_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu32i)");
    check_field_offset(lv, v1, 0, "F_S_BFu32i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_S_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu32i, F_S_BFu32i)
//============================================================================


struct  F_S_BFu32ll  {
  float v1;
  short v2;
  __tsu64 v3:32;
};
//SIG(1 F_S_BFu32ll) C1{ Fi Fs FL:32}



static void Test_F_S_BFu32ll()
{
  {
    init_simple_test("F_S_BFu32ll");
    static STRUCT_IF_C F_S_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "F_S_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "F_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu32ll, F_S_BFu32ll)
//============================================================================


struct  F_S_BFu33  {
  float v1;
  short v2;
  __tsu64 v3:33;
};
//SIG(1 F_S_BFu33) C1{ Fi Fs FL:33}



static void Test_F_S_BFu33()
{
  {
    init_simple_test("F_S_BFu33");
    static STRUCT_IF_C F_S_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_S_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu33)");
    check_field_offset(lv, v1, 0, "F_S_BFu33.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "F_S_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "F_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu33, F_S_BFu33)
//============================================================================


struct  F_S_BFu7c  {
  float v1;
  short v2;
  unsigned char v3:7;
};
//SIG(1 F_S_BFu7c) C1{ Fi Fs Fc:7}



static void Test_F_S_BFu7c()
{
  {
    init_simple_test("F_S_BFu7c");
    static STRUCT_IF_C F_S_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu7c)");
    check_field_offset(lv, v1, 0, "F_S_BFu7c.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_S_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu7c, F_S_BFu7c)
//============================================================================


struct  F_S_BFu7i  {
  float v1;
  short v2;
  unsigned int v3:7;
};
//SIG(1 F_S_BFu7i) C1{ Fi Fs Fi:7}



static void Test_F_S_BFu7i()
{
  {
    init_simple_test("F_S_BFu7i");
    static STRUCT_IF_C F_S_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu7i)");
    check_field_offset(lv, v1, 0, "F_S_BFu7i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_S_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu7i, F_S_BFu7i)
//============================================================================


struct  F_S_BFu7ll  {
  float v1;
  short v2;
  __tsu64 v3:7;
};
//SIG(1 F_S_BFu7ll) C1{ Fi Fs FL:7}



static void Test_F_S_BFu7ll()
{
  {
    init_simple_test("F_S_BFu7ll");
    static STRUCT_IF_C F_S_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_S_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu7ll, F_S_BFu7ll)
//============================================================================


struct  F_S_BFu7s  {
  float v1;
  short v2;
  unsigned short v3:7;
};
//SIG(1 F_S_BFu7s) C1{ Fi Fs Fs:7}



static void Test_F_S_BFu7s()
{
  {
    init_simple_test("F_S_BFu7s");
    static STRUCT_IF_C F_S_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu7s)");
    check_field_offset(lv, v1, 0, "F_S_BFu7s.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_S_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu7s, F_S_BFu7s)
//============================================================================


struct  F_S_BFu8c  {
  float v1;
  short v2;
  unsigned char v3:8;
};
//SIG(1 F_S_BFu8c) C1{ Fi Fs Fc:8}



static void Test_F_S_BFu8c()
{
  {
    init_simple_test("F_S_BFu8c");
    static STRUCT_IF_C F_S_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu8c)");
    check_field_offset(lv, v1, 0, "F_S_BFu8c.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_S_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu8c, F_S_BFu8c)
//============================================================================


struct  F_S_BFu8i  {
  float v1;
  short v2;
  unsigned int v3:8;
};
//SIG(1 F_S_BFu8i) C1{ Fi Fs Fi:8}



static void Test_F_S_BFu8i()
{
  {
    init_simple_test("F_S_BFu8i");
    static STRUCT_IF_C F_S_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu8i)");
    check_field_offset(lv, v1, 0, "F_S_BFu8i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_S_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu8i, F_S_BFu8i)
//============================================================================


struct  F_S_BFu8ll  {
  float v1;
  short v2;
  __tsu64 v3:8;
};
//SIG(1 F_S_BFu8ll) C1{ Fi Fs FL:8}



static void Test_F_S_BFu8ll()
{
  {
    init_simple_test("F_S_BFu8ll");
    static STRUCT_IF_C F_S_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_S_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu8ll, F_S_BFu8ll)
//============================================================================


struct  F_S_BFu8s  {
  float v1;
  short v2;
  unsigned short v3:8;
};
//SIG(1 F_S_BFu8s) C1{ Fi Fs Fs:8}



static void Test_F_S_BFu8s()
{
  {
    init_simple_test("F_S_BFu8s");
    static STRUCT_IF_C F_S_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu8s)");
    check_field_offset(lv, v1, 0, "F_S_BFu8s.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_S_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu8s, F_S_BFu8s)
//============================================================================


struct  F_S_BFu9i  {
  float v1;
  short v2;
  unsigned int v3:9;
};
//SIG(1 F_S_BFu9i) C1{ Fi Fs Fi:9}



static void Test_F_S_BFu9i()
{
  {
    init_simple_test("F_S_BFu9i");
    static STRUCT_IF_C F_S_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu9i)");
    check_field_offset(lv, v1, 0, "F_S_BFu9i.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_S_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu9i, F_S_BFu9i)
//============================================================================


struct  F_S_BFu9ll  {
  float v1;
  short v2;
  __tsu64 v3:9;
};
//SIG(1 F_S_BFu9ll) C1{ Fi Fs FL:9}



static void Test_F_S_BFu9ll()
{
  {
    init_simple_test("F_S_BFu9ll");
    static STRUCT_IF_C F_S_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_S_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_S_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu9ll, F_S_BFu9ll)
//============================================================================


struct  F_S_BFu9s  {
  float v1;
  short v2;
  unsigned short v3:9;
};
//SIG(1 F_S_BFu9s) C1{ Fi Fs Fs:9}



static void Test_F_S_BFu9s()
{
  {
    init_simple_test("F_S_BFu9s");
    static STRUCT_IF_C F_S_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_S_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_BFu9s)");
    check_field_offset(lv, v1, 0, "F_S_BFu9s.v1");
    check_field_offset(lv, v2, 4, "F_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_S_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_BFu9s, F_S_BFu9s)
//============================================================================


struct  F_S_C  {
  float v1;
  short v2;
  char v3;
};
//SIG(1 F_S_C) C1{ Fi Fs Fc}



static void Test_F_S_C()
{
  {
    init_simple_test("F_S_C");
    STRUCT_IF_C F_S_C lv;
    check2(sizeof(lv), 8, "sizeof(F_S_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_C)");
    check_field_offset(lv, v1, 0, "F_S_C.v1");
    check_field_offset(lv, v2, 4, "F_S_C.v2");
    check_field_offset(lv, v3, 6, "F_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_C, F_S_C)
//============================================================================


struct  F_S_D  {
  float v1;
  short v2;
  double v3;
};
//SIG(1 F_S_D) C1{ Fi Fs FL}



static void Test_F_S_D()
{
  {
    init_simple_test("F_S_D");
    STRUCT_IF_C F_S_D lv;
    check2(sizeof(lv), 16, "sizeof(F_S_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_D)");
    check_field_offset(lv, v1, 0, "F_S_D.v1");
    check_field_offset(lv, v2, 4, "F_S_D.v2");
    check_field_offset(lv, v3, 8, "F_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_D, F_S_D)
//============================================================================


struct  F_S_F  {
  float v1;
  short v2;
  float v3;
};
//SIG(1 F_S_F) C1{ Fi Fs Fi}



static void Test_F_S_F()
{
  {
    init_simple_test("F_S_F");
    STRUCT_IF_C F_S_F lv;
    check2(sizeof(lv), 12, "sizeof(F_S_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_F)");
    check_field_offset(lv, v1, 0, "F_S_F.v1");
    check_field_offset(lv, v2, 4, "F_S_F.v2");
    check_field_offset(lv, v3, 8, "F_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_F, F_S_F)
//============================================================================


struct  F_S_I  {
  float v1;
  short v2;
  int v3;
};
//SIG(1 F_S_I) C1{ Fi Fs Fi}



static void Test_F_S_I()
{
  {
    init_simple_test("F_S_I");
    STRUCT_IF_C F_S_I lv;
    check2(sizeof(lv), 12, "sizeof(F_S_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_I)");
    check_field_offset(lv, v1, 0, "F_S_I.v1");
    check_field_offset(lv, v2, 4, "F_S_I.v2");
    check_field_offset(lv, v3, 8, "F_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_I, F_S_I)
//============================================================================


struct  F_S_Ip  {
  float v1;
  short v2;
  int *v3;
};
//SIG(1 F_S_Ip) C1{ Fi Fs Fp}



static void Test_F_S_Ip()
{
  {
    init_simple_test("F_S_Ip");
    STRUCT_IF_C F_S_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_S_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_Ip)");
    check_field_offset(lv, v1, 0, "F_S_Ip.v1");
    check_field_offset(lv, v2, 4, "F_S_Ip.v2");
    check_field_offset(lv, v3, 8, "F_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_Ip, F_S_Ip)
//============================================================================


struct  F_S_L  {
  float v1;
  short v2;
  __tsi64 v3;
};
//SIG(1 F_S_L) C1{ Fi Fs FL}



static void Test_F_S_L()
{
  {
    init_simple_test("F_S_L");
    STRUCT_IF_C F_S_L lv;
    check2(sizeof(lv), 16, "sizeof(F_S_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_L)");
    check_field_offset(lv, v1, 0, "F_S_L.v1");
    check_field_offset(lv, v2, 4, "F_S_L.v2");
    check_field_offset(lv, v3, 8, "F_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_L, F_S_L)
//============================================================================


struct  F_S_S  {
  float v1;
  short v2;
  short v3;
};
//SIG(1 F_S_S) C1{ Fi Fs[2]}



static void Test_F_S_S()
{
  {
    init_simple_test("F_S_S");
    STRUCT_IF_C F_S_S lv;
    check2(sizeof(lv), 8, "sizeof(F_S_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_S)");
    check_field_offset(lv, v1, 0, "F_S_S.v1");
    check_field_offset(lv, v2, 4, "F_S_S.v2");
    check_field_offset(lv, v3, 6, "F_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_S, F_S_S)
//============================================================================


struct  F_S_Uc  {
  float v1;
  short v2;
  unsigned char v3;
};
//SIG(1 F_S_Uc) C1{ Fi Fs Fc}



static void Test_F_S_Uc()
{
  {
    init_simple_test("F_S_Uc");
    STRUCT_IF_C F_S_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_S_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_Uc)");
    check_field_offset(lv, v1, 0, "F_S_Uc.v1");
    check_field_offset(lv, v2, 4, "F_S_Uc.v2");
    check_field_offset(lv, v3, 6, "F_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_Uc, F_S_Uc)
//============================================================================


struct  F_S_Ui  {
  float v1;
  short v2;
  unsigned int v3;
};
//SIG(1 F_S_Ui) C1{ Fi Fs Fi}



static void Test_F_S_Ui()
{
  {
    init_simple_test("F_S_Ui");
    STRUCT_IF_C F_S_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_S_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_Ui)");
    check_field_offset(lv, v1, 0, "F_S_Ui.v1");
    check_field_offset(lv, v2, 4, "F_S_Ui.v2");
    check_field_offset(lv, v3, 8, "F_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_Ui, F_S_Ui)
//============================================================================


struct  F_S_Ul  {
  float v1;
  short v2;
  __tsu64 v3;
};
//SIG(1 F_S_Ul) C1{ Fi Fs FL}



static void Test_F_S_Ul()
{
  {
    init_simple_test("F_S_Ul");
    STRUCT_IF_C F_S_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_S_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_Ul)");
    check_field_offset(lv, v1, 0, "F_S_Ul.v1");
    check_field_offset(lv, v2, 4, "F_S_Ul.v2");
    check_field_offset(lv, v3, 8, "F_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_Ul, F_S_Ul)
//============================================================================


struct  F_S_Us  {
  float v1;
  short v2;
  unsigned short v3;
};
//SIG(1 F_S_Us) C1{ Fi Fs[2]}



static void Test_F_S_Us()
{
  {
    init_simple_test("F_S_Us");
    STRUCT_IF_C F_S_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_S_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_S_Us)");
    check_field_offset(lv, v1, 0, "F_S_Us.v1");
    check_field_offset(lv, v2, 4, "F_S_Us.v2");
    check_field_offset(lv, v3, 6, "F_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_Us, F_S_Us)
//============================================================================


struct  F_S_Vp  {
  float v1;
  short v2;
  void *v3;
};
//SIG(1 F_S_Vp) C1{ Fi Fs Fp}



static void Test_F_S_Vp()
{
  {
    init_simple_test("F_S_Vp");
    STRUCT_IF_C F_S_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_S_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_S_Vp)");
    check_field_offset(lv, v1, 0, "F_S_Vp.v1");
    check_field_offset(lv, v2, 4, "F_S_Vp.v2");
    check_field_offset(lv, v3, 8, "F_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_S_Vp, F_S_Vp)
//============================================================================


struct  F_Uc  {
  float v1;
  unsigned char v2;
};
//SIG(1 F_Uc) C1{ Fi Fc}



static void Test_F_Uc()
{
  {
    init_simple_test("F_Uc");
    STRUCT_IF_C F_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc)");
    check_field_offset(lv, v1, 0, "F_Uc.v1");
    check_field_offset(lv, v2, 4, "F_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc, F_Uc)
//============================================================================


struct  F_Uc_BFu15i  {
  float v1;
  unsigned char v2;
  unsigned int v3:15;
};
//SIG(1 F_Uc_BFu15i) C1{ Fi Fc Fi:15}



static void Test_F_Uc_BFu15i()
{
  {
    init_simple_test("F_Uc_BFu15i");
    static STRUCT_IF_C F_Uc_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_Uc_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu15i, F_Uc_BFu15i)
//============================================================================


struct  F_Uc_BFu15ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:15;
};
//SIG(1 F_Uc_BFu15ll) C1{ Fi Fc FL:15}



static void Test_F_Uc_BFu15ll()
{
  {
    init_simple_test("F_Uc_BFu15ll");
    static STRUCT_IF_C F_Uc_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "F_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "F_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu15ll, F_Uc_BFu15ll)
//============================================================================


struct  F_Uc_BFu15s  {
  float v1;
  unsigned char v2;
  unsigned short v3:15;
};
//SIG(1 F_Uc_BFu15s) C1{ Fi Fc Fs:15}



static void Test_F_Uc_BFu15s()
{
  {
    init_simple_test("F_Uc_BFu15s");
    static STRUCT_IF_C F_Uc_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_Uc_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu15s, F_Uc_BFu15s)
//============================================================================


struct  F_Uc_BFu16i  {
  float v1;
  unsigned char v2;
  unsigned int v3:16;
};
//SIG(1 F_Uc_BFu16i) C1{ Fi Fc Fi:16}



static void Test_F_Uc_BFu16i()
{
  {
    init_simple_test("F_Uc_BFu16i");
    static STRUCT_IF_C F_Uc_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_Uc_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu16i, F_Uc_BFu16i)
//============================================================================


struct  F_Uc_BFu16ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:16;
};
//SIG(1 F_Uc_BFu16ll) C1{ Fi Fc FL:16}



static void Test_F_Uc_BFu16ll()
{
  {
    init_simple_test("F_Uc_BFu16ll");
    static STRUCT_IF_C F_Uc_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "F_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "F_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu16ll, F_Uc_BFu16ll)
//============================================================================


struct  F_Uc_BFu16s  {
  float v1;
  unsigned char v2;
  unsigned short v3:16;
};
//SIG(1 F_Uc_BFu16s) C1{ Fi Fc Fs:16}



static void Test_F_Uc_BFu16s()
{
  {
    init_simple_test("F_Uc_BFu16s");
    static STRUCT_IF_C F_Uc_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_Uc_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu16s, F_Uc_BFu16s)
//============================================================================


struct  F_Uc_BFu17i  {
  float v1;
  unsigned char v2;
  unsigned int v3:17;
};
//SIG(1 F_Uc_BFu17i) C1{ Fi Fc Fi:17}



static void Test_F_Uc_BFu17i()
{
  {
    init_simple_test("F_Uc_BFu17i");
    static STRUCT_IF_C F_Uc_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_Uc_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu17i, F_Uc_BFu17i)
//============================================================================


struct  F_Uc_BFu17ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:17;
};
//SIG(1 F_Uc_BFu17ll) C1{ Fi Fc FL:17}



static void Test_F_Uc_BFu17ll()
{
  {
    init_simple_test("F_Uc_BFu17ll");
    static STRUCT_IF_C F_Uc_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "F_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "F_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu17ll, F_Uc_BFu17ll)
//============================================================================


struct  F_Uc_BFu1c  {
  float v1;
  unsigned char v2;
  unsigned char v3:1;
};
//SIG(1 F_Uc_BFu1c) C1{ Fi Fc Fc:1}



static void Test_F_Uc_BFu1c()
{
  {
    init_simple_test("F_Uc_BFu1c");
    static STRUCT_IF_C F_Uc_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu1c, F_Uc_BFu1c)
//============================================================================


struct  F_Uc_BFu1i  {
  float v1;
  unsigned char v2;
  unsigned int v3:1;
};
//SIG(1 F_Uc_BFu1i) C1{ Fi Fc Fi:1}



static void Test_F_Uc_BFu1i()
{
  {
    init_simple_test("F_Uc_BFu1i");
    static STRUCT_IF_C F_Uc_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu1i, F_Uc_BFu1i)
//============================================================================


struct  F_Uc_BFu1ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:1;
};
//SIG(1 F_Uc_BFu1ll) C1{ Fi Fc FL:1}



static void Test_F_Uc_BFu1ll()
{
  {
    init_simple_test("F_Uc_BFu1ll");
    static STRUCT_IF_C F_Uc_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu1ll, F_Uc_BFu1ll)
//============================================================================


struct  F_Uc_BFu1s  {
  float v1;
  unsigned char v2;
  unsigned short v3:1;
};
//SIG(1 F_Uc_BFu1s) C1{ Fi Fc Fs:1}



static void Test_F_Uc_BFu1s()
{
  {
    init_simple_test("F_Uc_BFu1s");
    static STRUCT_IF_C F_Uc_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "F_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu1s, F_Uc_BFu1s)
//============================================================================


struct  F_Uc_BFu31i  {
  float v1;
  unsigned char v2;
  unsigned int v3:31;
};
//SIG(1 F_Uc_BFu31i) C1{ Fi Fc Fi:31}



static void Test_F_Uc_BFu31i()
{
  {
    init_simple_test("F_Uc_BFu31i");
    static STRUCT_IF_C F_Uc_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_Uc_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_Uc_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu31i, F_Uc_BFu31i)
//============================================================================


struct  F_Uc_BFu31ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:31;
};
//SIG(1 F_Uc_BFu31ll) C1{ Fi Fc FL:31}



static void Test_F_Uc_BFu31ll()
{
  {
    init_simple_test("F_Uc_BFu31ll");
    static STRUCT_IF_C F_Uc_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Uc_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "F_Uc_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "F_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu31ll, F_Uc_BFu31ll)
//============================================================================


struct  F_Uc_BFu32i  {
  float v1;
  unsigned char v2;
  unsigned int v3:32;
};
//SIG(1 F_Uc_BFu32i) C1{ Fi Fc Fi:32}



static void Test_F_Uc_BFu32i()
{
  {
    init_simple_test("F_Uc_BFu32i");
    static STRUCT_IF_C F_Uc_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_Uc_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_Uc_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu32i, F_Uc_BFu32i)
//============================================================================


struct  F_Uc_BFu32ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:32;
};
//SIG(1 F_Uc_BFu32ll) C1{ Fi Fc FL:32}



static void Test_F_Uc_BFu32ll()
{
  {
    init_simple_test("F_Uc_BFu32ll");
    static STRUCT_IF_C F_Uc_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Uc_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "F_Uc_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "F_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu32ll, F_Uc_BFu32ll)
//============================================================================


struct  F_Uc_BFu33  {
  float v1;
  unsigned char v2;
  __tsu64 v3:33;
};
//SIG(1 F_Uc_BFu33) C1{ Fi Fc FL:33}



static void Test_F_Uc_BFu33()
{
  {
    init_simple_test("F_Uc_BFu33");
    static STRUCT_IF_C F_Uc_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Uc_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu33.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "F_Uc_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "F_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu33, F_Uc_BFu33)
//============================================================================


struct  F_Uc_BFu7c  {
  float v1;
  unsigned char v2;
  unsigned char v3:7;
};
//SIG(1 F_Uc_BFu7c) C1{ Fi Fc Fc:7}



static void Test_F_Uc_BFu7c()
{
  {
    init_simple_test("F_Uc_BFu7c");
    static STRUCT_IF_C F_Uc_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_Uc_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu7c, F_Uc_BFu7c)
//============================================================================


struct  F_Uc_BFu7i  {
  float v1;
  unsigned char v2;
  unsigned int v3:7;
};
//SIG(1 F_Uc_BFu7i) C1{ Fi Fc Fi:7}



static void Test_F_Uc_BFu7i()
{
  {
    init_simple_test("F_Uc_BFu7i");
    static STRUCT_IF_C F_Uc_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_Uc_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu7i, F_Uc_BFu7i)
//============================================================================


struct  F_Uc_BFu7ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:7;
};
//SIG(1 F_Uc_BFu7ll) C1{ Fi Fc FL:7}



static void Test_F_Uc_BFu7ll()
{
  {
    init_simple_test("F_Uc_BFu7ll");
    static STRUCT_IF_C F_Uc_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu7ll, F_Uc_BFu7ll)
//============================================================================


struct  F_Uc_BFu7s  {
  float v1;
  unsigned char v2;
  unsigned short v3:7;
};
//SIG(1 F_Uc_BFu7s) C1{ Fi Fc Fs:7}



static void Test_F_Uc_BFu7s()
{
  {
    init_simple_test("F_Uc_BFu7s");
    static STRUCT_IF_C F_Uc_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "F_Uc_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "F_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu7s, F_Uc_BFu7s)
//============================================================================


struct  F_Uc_BFu8c  {
  float v1;
  unsigned char v2;
  unsigned char v3:8;
};
//SIG(1 F_Uc_BFu8c) C1{ Fi Fc Fc:8}



static void Test_F_Uc_BFu8c()
{
  {
    init_simple_test("F_Uc_BFu8c");
    static STRUCT_IF_C F_Uc_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_Uc_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu8c, F_Uc_BFu8c)
//============================================================================


struct  F_Uc_BFu8i  {
  float v1;
  unsigned char v2;
  unsigned int v3:8;
};
//SIG(1 F_Uc_BFu8i) C1{ Fi Fc Fi:8}



static void Test_F_Uc_BFu8i()
{
  {
    init_simple_test("F_Uc_BFu8i");
    static STRUCT_IF_C F_Uc_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_Uc_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu8i, F_Uc_BFu8i)
//============================================================================


struct  F_Uc_BFu8ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:8;
};
//SIG(1 F_Uc_BFu8ll) C1{ Fi Fc FL:8}



static void Test_F_Uc_BFu8ll()
{
  {
    init_simple_test("F_Uc_BFu8ll");
    static STRUCT_IF_C F_Uc_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu8ll, F_Uc_BFu8ll)
//============================================================================


struct  F_Uc_BFu8s  {
  float v1;
  unsigned char v2;
  unsigned short v3:8;
};
//SIG(1 F_Uc_BFu8s) C1{ Fi Fc Fs:8}



static void Test_F_Uc_BFu8s()
{
  {
    init_simple_test("F_Uc_BFu8s");
    static STRUCT_IF_C F_Uc_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "F_Uc_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "F_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu8s, F_Uc_BFu8s)
//============================================================================


struct  F_Uc_BFu9i  {
  float v1;
  unsigned char v2;
  unsigned int v3:9;
};
//SIG(1 F_Uc_BFu9i) C1{ Fi Fc Fi:9}



static void Test_F_Uc_BFu9i()
{
  {
    init_simple_test("F_Uc_BFu9i");
    static STRUCT_IF_C F_Uc_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_Uc_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu9i, F_Uc_BFu9i)
//============================================================================


struct  F_Uc_BFu9ll  {
  float v1;
  unsigned char v2;
  __tsu64 v3:9;
};
//SIG(1 F_Uc_BFu9ll) C1{ Fi Fc FL:9}



static void Test_F_Uc_BFu9ll()
{
  {
    init_simple_test("F_Uc_BFu9ll");
    static STRUCT_IF_C F_Uc_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "F_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "F_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu9ll, F_Uc_BFu9ll)
//============================================================================


struct  F_Uc_BFu9s  {
  float v1;
  unsigned char v2;
  unsigned short v3:9;
};
//SIG(1 F_Uc_BFu9s) C1{ Fi Fc Fs:9}



static void Test_F_Uc_BFu9s()
{
  {
    init_simple_test("F_Uc_BFu9s");
    static STRUCT_IF_C F_Uc_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "F_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 4, "F_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_Uc_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_BFu9s, F_Uc_BFu9s)
//============================================================================


struct  F_Uc_C  {
  float v1;
  unsigned char v2;
  char v3;
};
//SIG(1 F_Uc_C) C1{ Fi Fc[2]}



static void Test_F_Uc_C()
{
  {
    init_simple_test("F_Uc_C");
    STRUCT_IF_C F_Uc_C lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_C)");
    check_field_offset(lv, v1, 0, "F_Uc_C.v1");
    check_field_offset(lv, v2, 4, "F_Uc_C.v2");
    check_field_offset(lv, v3, 5, "F_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_C, F_Uc_C)
//============================================================================


struct  F_Uc_D  {
  float v1;
  unsigned char v2;
  double v3;
};
//SIG(1 F_Uc_D) C1{ Fi Fc FL}



static void Test_F_Uc_D()
{
  {
    init_simple_test("F_Uc_D");
    STRUCT_IF_C F_Uc_D lv;
    check2(sizeof(lv), 16, "sizeof(F_Uc_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_D)");
    check_field_offset(lv, v1, 0, "F_Uc_D.v1");
    check_field_offset(lv, v2, 4, "F_Uc_D.v2");
    check_field_offset(lv, v3, 8, "F_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_D, F_Uc_D)
//============================================================================


struct  F_Uc_F  {
  float v1;
  unsigned char v2;
  float v3;
};
//SIG(1 F_Uc_F) C1{ Fi Fc Fi}



static void Test_F_Uc_F()
{
  {
    init_simple_test("F_Uc_F");
    STRUCT_IF_C F_Uc_F lv;
    check2(sizeof(lv), 12, "sizeof(F_Uc_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_F)");
    check_field_offset(lv, v1, 0, "F_Uc_F.v1");
    check_field_offset(lv, v2, 4, "F_Uc_F.v2");
    check_field_offset(lv, v3, 8, "F_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_F, F_Uc_F)
//============================================================================


struct  F_Uc_I  {
  float v1;
  unsigned char v2;
  int v3;
};
//SIG(1 F_Uc_I) C1{ Fi Fc Fi}



static void Test_F_Uc_I()
{
  {
    init_simple_test("F_Uc_I");
    STRUCT_IF_C F_Uc_I lv;
    check2(sizeof(lv), 12, "sizeof(F_Uc_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_I)");
    check_field_offset(lv, v1, 0, "F_Uc_I.v1");
    check_field_offset(lv, v2, 4, "F_Uc_I.v2");
    check_field_offset(lv, v3, 8, "F_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_I, F_Uc_I)
//============================================================================


struct  F_Uc_Ip  {
  float v1;
  unsigned char v2;
  int *v3;
};
//SIG(1 F_Uc_Ip) C1{ Fi Fc Fp}



static void Test_F_Uc_Ip()
{
  {
    init_simple_test("F_Uc_Ip");
    STRUCT_IF_C F_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Uc_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_Ip)");
    check_field_offset(lv, v1, 0, "F_Uc_Ip.v1");
    check_field_offset(lv, v2, 4, "F_Uc_Ip.v2");
    check_field_offset(lv, v3, 8, "F_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_Ip, F_Uc_Ip)
//============================================================================


struct  F_Uc_L  {
  float v1;
  unsigned char v2;
  __tsi64 v3;
};
//SIG(1 F_Uc_L) C1{ Fi Fc FL}



static void Test_F_Uc_L()
{
  {
    init_simple_test("F_Uc_L");
    STRUCT_IF_C F_Uc_L lv;
    check2(sizeof(lv), 16, "sizeof(F_Uc_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_L)");
    check_field_offset(lv, v1, 0, "F_Uc_L.v1");
    check_field_offset(lv, v2, 4, "F_Uc_L.v2");
    check_field_offset(lv, v3, 8, "F_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_L, F_Uc_L)
//============================================================================


struct  F_Uc_S  {
  float v1;
  unsigned char v2;
  short v3;
};
//SIG(1 F_Uc_S) C1{ Fi Fc Fs}



static void Test_F_Uc_S()
{
  {
    init_simple_test("F_Uc_S");
    STRUCT_IF_C F_Uc_S lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_S)");
    check_field_offset(lv, v1, 0, "F_Uc_S.v1");
    check_field_offset(lv, v2, 4, "F_Uc_S.v2");
    check_field_offset(lv, v3, 6, "F_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_S, F_Uc_S)
//============================================================================


struct  F_Uc_Uc  {
  float v1;
  unsigned char v2;
  unsigned char v3;
};
//SIG(1 F_Uc_Uc) C1{ Fi Fc[2]}



static void Test_F_Uc_Uc()
{
  {
    init_simple_test("F_Uc_Uc");
    STRUCT_IF_C F_Uc_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_Uc)");
    check_field_offset(lv, v1, 0, "F_Uc_Uc.v1");
    check_field_offset(lv, v2, 4, "F_Uc_Uc.v2");
    check_field_offset(lv, v3, 5, "F_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_Uc, F_Uc_Uc)
//============================================================================


struct  F_Uc_Ui  {
  float v1;
  unsigned char v2;
  unsigned int v3;
};
//SIG(1 F_Uc_Ui) C1{ Fi Fc Fi}



static void Test_F_Uc_Ui()
{
  {
    init_simple_test("F_Uc_Ui");
    STRUCT_IF_C F_Uc_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_Uc_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_Ui)");
    check_field_offset(lv, v1, 0, "F_Uc_Ui.v1");
    check_field_offset(lv, v2, 4, "F_Uc_Ui.v2");
    check_field_offset(lv, v3, 8, "F_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_Ui, F_Uc_Ui)
//============================================================================


struct  F_Uc_Ul  {
  float v1;
  unsigned char v2;
  __tsu64 v3;
};
//SIG(1 F_Uc_Ul) C1{ Fi Fc FL}



static void Test_F_Uc_Ul()
{
  {
    init_simple_test("F_Uc_Ul");
    STRUCT_IF_C F_Uc_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_Uc_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_Ul)");
    check_field_offset(lv, v1, 0, "F_Uc_Ul.v1");
    check_field_offset(lv, v2, 4, "F_Uc_Ul.v2");
    check_field_offset(lv, v3, 8, "F_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_Ul, F_Uc_Ul)
//============================================================================


struct  F_Uc_Us  {
  float v1;
  unsigned char v2;
  unsigned short v3;
};
//SIG(1 F_Uc_Us) C1{ Fi Fc Fs}



static void Test_F_Uc_Us()
{
  {
    init_simple_test("F_Uc_Us");
    STRUCT_IF_C F_Uc_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_Uc_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_Uc_Us)");
    check_field_offset(lv, v1, 0, "F_Uc_Us.v1");
    check_field_offset(lv, v2, 4, "F_Uc_Us.v2");
    check_field_offset(lv, v3, 6, "F_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_Us, F_Uc_Us)
//============================================================================


struct  F_Uc_Vp  {
  float v1;
  unsigned char v2;
  void *v3;
};
//SIG(1 F_Uc_Vp) C1{ Fi Fc Fp}



static void Test_F_Uc_Vp()
{
  {
    init_simple_test("F_Uc_Vp");
    STRUCT_IF_C F_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Uc_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Uc_Vp)");
    check_field_offset(lv, v1, 0, "F_Uc_Vp.v1");
    check_field_offset(lv, v2, 4, "F_Uc_Vp.v2");
    check_field_offset(lv, v3, 8, "F_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Uc_Vp, F_Uc_Vp)
//============================================================================


struct  F_Ui  {
  float v1;
  unsigned int v2;
};
//SIG(1 F_Ui) C1{ Fi[2]}



static void Test_F_Ui()
{
  {
    init_simple_test("F_Ui");
    STRUCT_IF_C F_Ui lv;
    check2(sizeof(lv), 8, "sizeof(F_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui)");
    check_field_offset(lv, v1, 0, "F_Ui.v1");
    check_field_offset(lv, v2, 4, "F_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui, F_Ui)
//============================================================================


struct  F_Ui_BFu15i  {
  float v1;
  unsigned int v2;
  unsigned int v3:15;
};
//SIG(1 F_Ui_BFu15i) C1{ Fi[2] Fi:15}



static void Test_F_Ui_BFu15i()
{
  {
    init_simple_test("F_Ui_BFu15i");
    static STRUCT_IF_C F_Ui_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_Ui_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu15i, F_Ui_BFu15i)
//============================================================================


struct  F_Ui_BFu15ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:15;
};
//SIG(1 F_Ui_BFu15ll) C1{ Fi[2] FL:15}



static void Test_F_Ui_BFu15ll()
{
  {
    init_simple_test("F_Ui_BFu15ll");
    static STRUCT_IF_C F_Ui_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu15ll, F_Ui_BFu15ll)
//============================================================================


struct  F_Ui_BFu15s  {
  float v1;
  unsigned int v2;
  unsigned short v3:15;
};
//SIG(1 F_Ui_BFu15s) C1{ Fi[2] Fs:15}



static void Test_F_Ui_BFu15s()
{
  {
    init_simple_test("F_Ui_BFu15s");
    static STRUCT_IF_C F_Ui_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_Ui_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu15s, F_Ui_BFu15s)
//============================================================================


struct  F_Ui_BFu16i  {
  float v1;
  unsigned int v2;
  unsigned int v3:16;
};
//SIG(1 F_Ui_BFu16i) C1{ Fi[2] Fi:16}



static void Test_F_Ui_BFu16i()
{
  {
    init_simple_test("F_Ui_BFu16i");
    static STRUCT_IF_C F_Ui_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_Ui_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu16i, F_Ui_BFu16i)
//============================================================================


struct  F_Ui_BFu16ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:16;
};
//SIG(1 F_Ui_BFu16ll) C1{ Fi[2] FL:16}



static void Test_F_Ui_BFu16ll()
{
  {
    init_simple_test("F_Ui_BFu16ll");
    static STRUCT_IF_C F_Ui_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu16ll, F_Ui_BFu16ll)
//============================================================================


struct  F_Ui_BFu16s  {
  float v1;
  unsigned int v2;
  unsigned short v3:16;
};
//SIG(1 F_Ui_BFu16s) C1{ Fi[2] Fs:16}



static void Test_F_Ui_BFu16s()
{
  {
    init_simple_test("F_Ui_BFu16s");
    static STRUCT_IF_C F_Ui_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_Ui_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu16s, F_Ui_BFu16s)
//============================================================================


struct  F_Ui_BFu17i  {
  float v1;
  unsigned int v2;
  unsigned int v3:17;
};
//SIG(1 F_Ui_BFu17i) C1{ Fi[2] Fi:17}



static void Test_F_Ui_BFu17i()
{
  {
    init_simple_test("F_Ui_BFu17i");
    static STRUCT_IF_C F_Ui_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_Ui_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu17i, F_Ui_BFu17i)
//============================================================================


struct  F_Ui_BFu17ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:17;
};
//SIG(1 F_Ui_BFu17ll) C1{ Fi[2] FL:17}



static void Test_F_Ui_BFu17ll()
{
  {
    init_simple_test("F_Ui_BFu17ll");
    static STRUCT_IF_C F_Ui_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu17ll, F_Ui_BFu17ll)
//============================================================================


struct  F_Ui_BFu1c  {
  float v1;
  unsigned int v2;
  unsigned char v3:1;
};
//SIG(1 F_Ui_BFu1c) C1{ Fi[2] Fc:1}



static void Test_F_Ui_BFu1c()
{
  {
    init_simple_test("F_Ui_BFu1c");
    static STRUCT_IF_C F_Ui_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu1c, F_Ui_BFu1c)
//============================================================================


struct  F_Ui_BFu1i  {
  float v1;
  unsigned int v2;
  unsigned int v3:1;
};
//SIG(1 F_Ui_BFu1i) C1{ Fi[2] Fi:1}



static void Test_F_Ui_BFu1i()
{
  {
    init_simple_test("F_Ui_BFu1i");
    static STRUCT_IF_C F_Ui_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu1i, F_Ui_BFu1i)
//============================================================================


struct  F_Ui_BFu1ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:1;
};
//SIG(1 F_Ui_BFu1ll) C1{ Fi[2] FL:1}



static void Test_F_Ui_BFu1ll()
{
  {
    init_simple_test("F_Ui_BFu1ll");
    static STRUCT_IF_C F_Ui_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu1ll, F_Ui_BFu1ll)
//============================================================================


struct  F_Ui_BFu1s  {
  float v1;
  unsigned int v2;
  unsigned short v3:1;
};
//SIG(1 F_Ui_BFu1s) C1{ Fi[2] Fs:1}



static void Test_F_Ui_BFu1s()
{
  {
    init_simple_test("F_Ui_BFu1s");
    static STRUCT_IF_C F_Ui_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu1s, F_Ui_BFu1s)
//============================================================================


struct  F_Ui_BFu31i  {
  float v1;
  unsigned int v2;
  unsigned int v3:31;
};
//SIG(1 F_Ui_BFu31i) C1{ Fi[2] Fi:31}



static void Test_F_Ui_BFu31i()
{
  {
    init_simple_test("F_Ui_BFu31i");
    static STRUCT_IF_C F_Ui_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_Ui_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu31i, F_Ui_BFu31i)
//============================================================================


struct  F_Ui_BFu31ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:31;
};
//SIG(1 F_Ui_BFu31ll) C1{ Fi[2] FL:31}



static void Test_F_Ui_BFu31ll()
{
  {
    init_simple_test("F_Ui_BFu31ll");
    static STRUCT_IF_C F_Ui_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu31ll, F_Ui_BFu31ll)
//============================================================================


struct  F_Ui_BFu32i  {
  float v1;
  unsigned int v2;
  unsigned int v3:32;
};
//SIG(1 F_Ui_BFu32i) C1{ Fi[2] Fi:32}



static void Test_F_Ui_BFu32i()
{
  {
    init_simple_test("F_Ui_BFu32i");
    static STRUCT_IF_C F_Ui_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_Ui_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu32i, F_Ui_BFu32i)
//============================================================================


struct  F_Ui_BFu32ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:32;
};
//SIG(1 F_Ui_BFu32ll) C1{ Fi[2] FL:32}



static void Test_F_Ui_BFu32ll()
{
  {
    init_simple_test("F_Ui_BFu32ll");
    static STRUCT_IF_C F_Ui_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu32ll, F_Ui_BFu32ll)
//============================================================================


struct  F_Ui_BFu33  {
  float v1;
  unsigned int v2;
  __tsu64 v3:33;
};
//SIG(1 F_Ui_BFu33) C1{ Fi[2] FL:33}



static void Test_F_Ui_BFu33()
{
  {
    init_simple_test("F_Ui_BFu33");
    static STRUCT_IF_C F_Ui_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(F_Ui_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu33.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "F_Ui_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "F_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu33, F_Ui_BFu33)
//============================================================================


struct  F_Ui_BFu7c  {
  float v1;
  unsigned int v2;
  unsigned char v3:7;
};
//SIG(1 F_Ui_BFu7c) C1{ Fi[2] Fc:7}



static void Test_F_Ui_BFu7c()
{
  {
    init_simple_test("F_Ui_BFu7c");
    static STRUCT_IF_C F_Ui_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_Ui_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu7c, F_Ui_BFu7c)
//============================================================================


struct  F_Ui_BFu7i  {
  float v1;
  unsigned int v2;
  unsigned int v3:7;
};
//SIG(1 F_Ui_BFu7i) C1{ Fi[2] Fi:7}



static void Test_F_Ui_BFu7i()
{
  {
    init_simple_test("F_Ui_BFu7i");
    static STRUCT_IF_C F_Ui_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_Ui_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu7i, F_Ui_BFu7i)
//============================================================================


struct  F_Ui_BFu7ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:7;
};
//SIG(1 F_Ui_BFu7ll) C1{ Fi[2] FL:7}



static void Test_F_Ui_BFu7ll()
{
  {
    init_simple_test("F_Ui_BFu7ll");
    static STRUCT_IF_C F_Ui_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu7ll, F_Ui_BFu7ll)
//============================================================================


struct  F_Ui_BFu7s  {
  float v1;
  unsigned int v2;
  unsigned short v3:7;
};
//SIG(1 F_Ui_BFu7s) C1{ Fi[2] Fs:7}



static void Test_F_Ui_BFu7s()
{
  {
    init_simple_test("F_Ui_BFu7s");
    static STRUCT_IF_C F_Ui_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_Ui_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu7s, F_Ui_BFu7s)
//============================================================================


struct  F_Ui_BFu8c  {
  float v1;
  unsigned int v2;
  unsigned char v3:8;
};
//SIG(1 F_Ui_BFu8c) C1{ Fi[2] Fc:8}



static void Test_F_Ui_BFu8c()
{
  {
    init_simple_test("F_Ui_BFu8c");
    static STRUCT_IF_C F_Ui_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_Ui_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu8c, F_Ui_BFu8c)
//============================================================================


struct  F_Ui_BFu8i  {
  float v1;
  unsigned int v2;
  unsigned int v3:8;
};
//SIG(1 F_Ui_BFu8i) C1{ Fi[2] Fi:8}



static void Test_F_Ui_BFu8i()
{
  {
    init_simple_test("F_Ui_BFu8i");
    static STRUCT_IF_C F_Ui_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_Ui_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu8i, F_Ui_BFu8i)
//============================================================================


struct  F_Ui_BFu8ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:8;
};
//SIG(1 F_Ui_BFu8ll) C1{ Fi[2] FL:8}



static void Test_F_Ui_BFu8ll()
{
  {
    init_simple_test("F_Ui_BFu8ll");
    static STRUCT_IF_C F_Ui_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu8ll, F_Ui_BFu8ll)
//============================================================================


struct  F_Ui_BFu8s  {
  float v1;
  unsigned int v2;
  unsigned short v3:8;
};
//SIG(1 F_Ui_BFu8s) C1{ Fi[2] Fs:8}



static void Test_F_Ui_BFu8s()
{
  {
    init_simple_test("F_Ui_BFu8s");
    static STRUCT_IF_C F_Ui_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_Ui_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu8s, F_Ui_BFu8s)
//============================================================================


struct  F_Ui_BFu9i  {
  float v1;
  unsigned int v2;
  unsigned int v3:9;
};
//SIG(1 F_Ui_BFu9i) C1{ Fi[2] Fi:9}



static void Test_F_Ui_BFu9i()
{
  {
    init_simple_test("F_Ui_BFu9i");
    static STRUCT_IF_C F_Ui_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_Ui_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu9i, F_Ui_BFu9i)
//============================================================================


struct  F_Ui_BFu9ll  {
  float v1;
  unsigned int v2;
  __tsu64 v3:9;
};
//SIG(1 F_Ui_BFu9ll) C1{ Fi[2] FL:9}



static void Test_F_Ui_BFu9ll()
{
  {
    init_simple_test("F_Ui_BFu9ll");
    static STRUCT_IF_C F_Ui_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu9ll, F_Ui_BFu9ll)
//============================================================================


struct  F_Ui_BFu9s  {
  float v1;
  unsigned int v2;
  unsigned short v3:9;
};
//SIG(1 F_Ui_BFu9s) C1{ Fi[2] Fs:9}



static void Test_F_Ui_BFu9s()
{
  {
    init_simple_test("F_Ui_BFu9s");
    static STRUCT_IF_C F_Ui_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "F_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 4, "F_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_Ui_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_BFu9s, F_Ui_BFu9s)
//============================================================================


struct  F_Ui_C  {
  float v1;
  unsigned int v2;
  char v3;
};
//SIG(1 F_Ui_C) C1{ Fi[2] Fc}



static void Test_F_Ui_C()
{
  {
    init_simple_test("F_Ui_C");
    STRUCT_IF_C F_Ui_C lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_C)");
    check_field_offset(lv, v1, 0, "F_Ui_C.v1");
    check_field_offset(lv, v2, 4, "F_Ui_C.v2");
    check_field_offset(lv, v3, 8, "F_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_C, F_Ui_C)
//============================================================================


struct  F_Ui_D  {
  float v1;
  unsigned int v2;
  double v3;
};
//SIG(1 F_Ui_D) C1{ Fi[2] FL}



static void Test_F_Ui_D()
{
  {
    init_simple_test("F_Ui_D");
    STRUCT_IF_C F_Ui_D lv;
    check2(sizeof(lv), 16, "sizeof(F_Ui_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_D)");
    check_field_offset(lv, v1, 0, "F_Ui_D.v1");
    check_field_offset(lv, v2, 4, "F_Ui_D.v2");
    check_field_offset(lv, v3, 8, "F_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_D, F_Ui_D)
//============================================================================


struct  F_Ui_F  {
  float v1;
  unsigned int v2;
  float v3;
};
//SIG(1 F_Ui_F) C1{ Fi[3]}



static void Test_F_Ui_F()
{
  {
    init_simple_test("F_Ui_F");
    STRUCT_IF_C F_Ui_F lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_F)");
    check_field_offset(lv, v1, 0, "F_Ui_F.v1");
    check_field_offset(lv, v2, 4, "F_Ui_F.v2");
    check_field_offset(lv, v3, 8, "F_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_F, F_Ui_F)
//============================================================================


struct  F_Ui_I  {
  float v1;
  unsigned int v2;
  int v3;
};
//SIG(1 F_Ui_I) C1{ Fi[3]}



static void Test_F_Ui_I()
{
  {
    init_simple_test("F_Ui_I");
    STRUCT_IF_C F_Ui_I lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_I)");
    check_field_offset(lv, v1, 0, "F_Ui_I.v1");
    check_field_offset(lv, v2, 4, "F_Ui_I.v2");
    check_field_offset(lv, v3, 8, "F_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_I, F_Ui_I)
//============================================================================


struct  F_Ui_Ip  {
  float v1;
  unsigned int v2;
  int *v3;
};
//SIG(1 F_Ui_Ip) C1{ Fi[2] Fp}



static void Test_F_Ui_Ip()
{
  {
    init_simple_test("F_Ui_Ip");
    STRUCT_IF_C F_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_Ip)");
    check_field_offset(lv, v1, 0, "F_Ui_Ip.v1");
    check_field_offset(lv, v2, 4, "F_Ui_Ip.v2");
    check_field_offset(lv, v3, 8, "F_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_Ip, F_Ui_Ip)
//============================================================================


struct  F_Ui_L  {
  float v1;
  unsigned int v2;
  __tsi64 v3;
};
//SIG(1 F_Ui_L) C1{ Fi[2] FL}



static void Test_F_Ui_L()
{
  {
    init_simple_test("F_Ui_L");
    STRUCT_IF_C F_Ui_L lv;
    check2(sizeof(lv), 16, "sizeof(F_Ui_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_L)");
    check_field_offset(lv, v1, 0, "F_Ui_L.v1");
    check_field_offset(lv, v2, 4, "F_Ui_L.v2");
    check_field_offset(lv, v3, 8, "F_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_L, F_Ui_L)
//============================================================================


struct  F_Ui_S  {
  float v1;
  unsigned int v2;
  short v3;
};
//SIG(1 F_Ui_S) C1{ Fi[2] Fs}



static void Test_F_Ui_S()
{
  {
    init_simple_test("F_Ui_S");
    STRUCT_IF_C F_Ui_S lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_S)");
    check_field_offset(lv, v1, 0, "F_Ui_S.v1");
    check_field_offset(lv, v2, 4, "F_Ui_S.v2");
    check_field_offset(lv, v3, 8, "F_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_S, F_Ui_S)
//============================================================================


struct  F_Ui_Uc  {
  float v1;
  unsigned int v2;
  unsigned char v3;
};
//SIG(1 F_Ui_Uc) C1{ Fi[2] Fc}



static void Test_F_Ui_Uc()
{
  {
    init_simple_test("F_Ui_Uc");
    STRUCT_IF_C F_Ui_Uc lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_Uc)");
    check_field_offset(lv, v1, 0, "F_Ui_Uc.v1");
    check_field_offset(lv, v2, 4, "F_Ui_Uc.v2");
    check_field_offset(lv, v3, 8, "F_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_Uc, F_Ui_Uc)
//============================================================================


struct  F_Ui_Ui  {
  float v1;
  unsigned int v2;
  unsigned int v3;
};
//SIG(1 F_Ui_Ui) C1{ Fi[3]}



static void Test_F_Ui_Ui()
{
  {
    init_simple_test("F_Ui_Ui");
    STRUCT_IF_C F_Ui_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_Ui)");
    check_field_offset(lv, v1, 0, "F_Ui_Ui.v1");
    check_field_offset(lv, v2, 4, "F_Ui_Ui.v2");
    check_field_offset(lv, v3, 8, "F_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_Ui, F_Ui_Ui)
//============================================================================


struct  F_Ui_Ul  {
  float v1;
  unsigned int v2;
  __tsu64 v3;
};
//SIG(1 F_Ui_Ul) C1{ Fi[2] FL}



static void Test_F_Ui_Ul()
{
  {
    init_simple_test("F_Ui_Ul");
    STRUCT_IF_C F_Ui_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_Ui_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_Ul)");
    check_field_offset(lv, v1, 0, "F_Ui_Ul.v1");
    check_field_offset(lv, v2, 4, "F_Ui_Ul.v2");
    check_field_offset(lv, v3, 8, "F_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_Ul, F_Ui_Ul)
//============================================================================


struct  F_Ui_Us  {
  float v1;
  unsigned int v2;
  unsigned short v3;
};
//SIG(1 F_Ui_Us) C1{ Fi[2] Fs}



static void Test_F_Ui_Us()
{
  {
    init_simple_test("F_Ui_Us");
    STRUCT_IF_C F_Ui_Us lv;
    check2(sizeof(lv), 12, "sizeof(F_Ui_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_Ui_Us)");
    check_field_offset(lv, v1, 0, "F_Ui_Us.v1");
    check_field_offset(lv, v2, 4, "F_Ui_Us.v2");
    check_field_offset(lv, v3, 8, "F_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_Us, F_Ui_Us)
//============================================================================


struct  F_Ui_Vp  {
  float v1;
  unsigned int v2;
  void *v3;
};
//SIG(1 F_Ui_Vp) C1{ Fi[2] Fp}



static void Test_F_Ui_Vp()
{
  {
    init_simple_test("F_Ui_Vp");
    STRUCT_IF_C F_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ui_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ui_Vp)");
    check_field_offset(lv, v1, 0, "F_Ui_Vp.v1");
    check_field_offset(lv, v2, 4, "F_Ui_Vp.v2");
    check_field_offset(lv, v3, 8, "F_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ui_Vp, F_Ui_Vp)
//============================================================================


struct  F_Ul  {
  float v1;
  __tsu64 v2;
};
//SIG(1 F_Ul) C1{ Fi FL}



static void Test_F_Ul()
{
  {
    init_simple_test("F_Ul");
    STRUCT_IF_C F_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul)");
    check_field_offset(lv, v1, 0, "F_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul, F_Ul)
//============================================================================


struct  F_Ul_BFu15i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:15;
};
//SIG(1 F_Ul_BFu15i) C1{ Fi FL Fi:15}



static void Test_F_Ul_BFu15i()
{
  {
    init_simple_test("F_Ul_BFu15i");
    static STRUCT_IF_C F_Ul_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_Ul_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu15i, F_Ul_BFu15i)
//============================================================================


struct  F_Ul_BFu15ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:15;
};
//SIG(1 F_Ul_BFu15ll) C1{ Fi FL FL:15}



static void Test_F_Ul_BFu15ll()
{
  {
    init_simple_test("F_Ul_BFu15ll");
    static STRUCT_IF_C F_Ul_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_Ul_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu15ll, F_Ul_BFu15ll)
//============================================================================


struct  F_Ul_BFu15s  {
  float v1;
  __tsu64 v2;
  unsigned short v3:15;
};
//SIG(1 F_Ul_BFu15s) C1{ Fi FL Fs:15}



static void Test_F_Ul_BFu15s()
{
  {
    init_simple_test("F_Ul_BFu15s");
    static STRUCT_IF_C F_Ul_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "F_Ul_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "F_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu15s, F_Ul_BFu15s)
//============================================================================


struct  F_Ul_BFu16i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:16;
};
//SIG(1 F_Ul_BFu16i) C1{ Fi FL Fi:16}



static void Test_F_Ul_BFu16i()
{
  {
    init_simple_test("F_Ul_BFu16i");
    static STRUCT_IF_C F_Ul_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_Ul_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu16i, F_Ul_BFu16i)
//============================================================================


struct  F_Ul_BFu16ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:16;
};
//SIG(1 F_Ul_BFu16ll) C1{ Fi FL FL:16}



static void Test_F_Ul_BFu16ll()
{
  {
    init_simple_test("F_Ul_BFu16ll");
    static STRUCT_IF_C F_Ul_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_Ul_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu16ll, F_Ul_BFu16ll)
//============================================================================


struct  F_Ul_BFu16s  {
  float v1;
  __tsu64 v2;
  unsigned short v3:16;
};
//SIG(1 F_Ul_BFu16s) C1{ Fi FL Fs:16}



static void Test_F_Ul_BFu16s()
{
  {
    init_simple_test("F_Ul_BFu16s");
    static STRUCT_IF_C F_Ul_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "F_Ul_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "F_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu16s, F_Ul_BFu16s)
//============================================================================


struct  F_Ul_BFu17i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:17;
};
//SIG(1 F_Ul_BFu17i) C1{ Fi FL Fi:17}



static void Test_F_Ul_BFu17i()
{
  {
    init_simple_test("F_Ul_BFu17i");
    static STRUCT_IF_C F_Ul_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "F_Ul_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "F_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu17i, F_Ul_BFu17i)
//============================================================================


struct  F_Ul_BFu17ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:17;
};
//SIG(1 F_Ul_BFu17ll) C1{ Fi FL FL:17}



static void Test_F_Ul_BFu17ll()
{
  {
    init_simple_test("F_Ul_BFu17ll");
    static STRUCT_IF_C F_Ul_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "F_Ul_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "F_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu17ll, F_Ul_BFu17ll)
//============================================================================


struct  F_Ul_BFu1c  {
  float v1;
  __tsu64 v2;
  unsigned char v3:1;
};
//SIG(1 F_Ul_BFu1c) C1{ Fi FL Fc:1}



static void Test_F_Ul_BFu1c()
{
  {
    init_simple_test("F_Ul_BFu1c");
    static STRUCT_IF_C F_Ul_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu1c, F_Ul_BFu1c)
//============================================================================


struct  F_Ul_BFu1i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:1;
};
//SIG(1 F_Ul_BFu1i) C1{ Fi FL Fi:1}



static void Test_F_Ul_BFu1i()
{
  {
    init_simple_test("F_Ul_BFu1i");
    static STRUCT_IF_C F_Ul_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu1i, F_Ul_BFu1i)
//============================================================================


struct  F_Ul_BFu1ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:1;
};
//SIG(1 F_Ul_BFu1ll) C1{ Fi FL FL:1}



static void Test_F_Ul_BFu1ll()
{
  {
    init_simple_test("F_Ul_BFu1ll");
    static STRUCT_IF_C F_Ul_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu1ll, F_Ul_BFu1ll)
//============================================================================


struct  F_Ul_BFu1s  {
  float v1;
  __tsu64 v2;
  unsigned short v3:1;
};
//SIG(1 F_Ul_BFu1s) C1{ Fi FL Fs:1}



static void Test_F_Ul_BFu1s()
{
  {
    init_simple_test("F_Ul_BFu1s");
    static STRUCT_IF_C F_Ul_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "F_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu1s, F_Ul_BFu1s)
//============================================================================


struct  F_Ul_BFu31i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:31;
};
//SIG(1 F_Ul_BFu31i) C1{ Fi FL Fi:31}



static void Test_F_Ul_BFu31i()
{
  {
    init_simple_test("F_Ul_BFu31i");
    static STRUCT_IF_C F_Ul_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "F_Ul_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "F_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu31i, F_Ul_BFu31i)
//============================================================================


struct  F_Ul_BFu31ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:31;
};
//SIG(1 F_Ul_BFu31ll) C1{ Fi FL FL:31}



static void Test_F_Ul_BFu31ll()
{
  {
    init_simple_test("F_Ul_BFu31ll");
    static STRUCT_IF_C F_Ul_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "F_Ul_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "F_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu31ll, F_Ul_BFu31ll)
//============================================================================


struct  F_Ul_BFu32i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:32;
};
//SIG(1 F_Ul_BFu32i) C1{ Fi FL Fi:32}



static void Test_F_Ul_BFu32i()
{
  {
    init_simple_test("F_Ul_BFu32i");
    static STRUCT_IF_C F_Ul_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "F_Ul_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "F_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu32i, F_Ul_BFu32i)
//============================================================================


struct  F_Ul_BFu32ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:32;
};
//SIG(1 F_Ul_BFu32ll) C1{ Fi FL FL:32}



static void Test_F_Ul_BFu32ll()
{
  {
    init_simple_test("F_Ul_BFu32ll");
    static STRUCT_IF_C F_Ul_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "F_Ul_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "F_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu32ll, F_Ul_BFu32ll)
//============================================================================


struct  F_Ul_BFu33  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:33;
};
//SIG(1 F_Ul_BFu33) C1{ Fi FL FL:33}



static void Test_F_Ul_BFu33()
{
  {
    init_simple_test("F_Ul_BFu33");
    static STRUCT_IF_C F_Ul_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_Ul_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "F_Ul_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "F_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu33, F_Ul_BFu33)
//============================================================================


struct  F_Ul_BFu7c  {
  float v1;
  __tsu64 v2;
  unsigned char v3:7;
};
//SIG(1 F_Ul_BFu7c) C1{ Fi FL Fc:7}



static void Test_F_Ul_BFu7c()
{
  {
    init_simple_test("F_Ul_BFu7c");
    static STRUCT_IF_C F_Ul_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_Ul_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu7c, F_Ul_BFu7c)
//============================================================================


struct  F_Ul_BFu7i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:7;
};
//SIG(1 F_Ul_BFu7i) C1{ Fi FL Fi:7}



static void Test_F_Ul_BFu7i()
{
  {
    init_simple_test("F_Ul_BFu7i");
    static STRUCT_IF_C F_Ul_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_Ul_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu7i, F_Ul_BFu7i)
//============================================================================


struct  F_Ul_BFu7ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:7;
};
//SIG(1 F_Ul_BFu7ll) C1{ Fi FL FL:7}



static void Test_F_Ul_BFu7ll()
{
  {
    init_simple_test("F_Ul_BFu7ll");
    static STRUCT_IF_C F_Ul_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_Ul_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu7ll, F_Ul_BFu7ll)
//============================================================================


struct  F_Ul_BFu7s  {
  float v1;
  __tsu64 v2;
  unsigned short v3:7;
};
//SIG(1 F_Ul_BFu7s) C1{ Fi FL Fs:7}



static void Test_F_Ul_BFu7s()
{
  {
    init_simple_test("F_Ul_BFu7s");
    static STRUCT_IF_C F_Ul_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "F_Ul_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "F_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu7s, F_Ul_BFu7s)
//============================================================================


struct  F_Ul_BFu8c  {
  float v1;
  __tsu64 v2;
  unsigned char v3:8;
};
//SIG(1 F_Ul_BFu8c) C1{ Fi FL Fc:8}



static void Test_F_Ul_BFu8c()
{
  {
    init_simple_test("F_Ul_BFu8c");
    static STRUCT_IF_C F_Ul_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_Ul_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu8c, F_Ul_BFu8c)
//============================================================================


struct  F_Ul_BFu8i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:8;
};
//SIG(1 F_Ul_BFu8i) C1{ Fi FL Fi:8}



static void Test_F_Ul_BFu8i()
{
  {
    init_simple_test("F_Ul_BFu8i");
    static STRUCT_IF_C F_Ul_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_Ul_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu8i, F_Ul_BFu8i)
//============================================================================


struct  F_Ul_BFu8ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:8;
};
//SIG(1 F_Ul_BFu8ll) C1{ Fi FL FL:8}



static void Test_F_Ul_BFu8ll()
{
  {
    init_simple_test("F_Ul_BFu8ll");
    static STRUCT_IF_C F_Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_Ul_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu8ll, F_Ul_BFu8ll)
//============================================================================


struct  F_Ul_BFu8s  {
  float v1;
  __tsu64 v2;
  unsigned short v3:8;
};
//SIG(1 F_Ul_BFu8s) C1{ Fi FL Fs:8}



static void Test_F_Ul_BFu8s()
{
  {
    init_simple_test("F_Ul_BFu8s");
    static STRUCT_IF_C F_Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "F_Ul_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "F_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu8s, F_Ul_BFu8s)
//============================================================================


struct  F_Ul_BFu9i  {
  float v1;
  __tsu64 v2;
  unsigned int v3:9;
};
//SIG(1 F_Ul_BFu9i) C1{ Fi FL Fi:9}



static void Test_F_Ul_BFu9i()
{
  {
    init_simple_test("F_Ul_BFu9i");
    static STRUCT_IF_C F_Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_Ul_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu9i, F_Ul_BFu9i)
//============================================================================


struct  F_Ul_BFu9ll  {
  float v1;
  __tsu64 v2;
  __tsu64 v3:9;
};
//SIG(1 F_Ul_BFu9ll) C1{ Fi FL FL:9}



static void Test_F_Ul_BFu9ll()
{
  {
    init_simple_test("F_Ul_BFu9ll");
    static STRUCT_IF_C F_Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_Ul_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu9ll, F_Ul_BFu9ll)
//============================================================================


struct  F_Ul_BFu9s  {
  float v1;
  __tsu64 v2;
  unsigned short v3:9;
};
//SIG(1 F_Ul_BFu9s) C1{ Fi FL Fs:9}



static void Test_F_Ul_BFu9s()
{
  {
    init_simple_test("F_Ul_BFu9s");
    static STRUCT_IF_C F_Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "F_Ul_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "F_Ul_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "F_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_BFu9s, F_Ul_BFu9s)
//============================================================================


struct  F_Ul_C  {
  float v1;
  __tsu64 v2;
  char v3;
};
//SIG(1 F_Ul_C) C1{ Fi FL Fc}



static void Test_F_Ul_C()
{
  {
    init_simple_test("F_Ul_C");
    STRUCT_IF_C F_Ul_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_C)");
    check_field_offset(lv, v1, 0, "F_Ul_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_C, F_Ul_C)
//============================================================================


struct  F_Ul_D  {
  float v1;
  __tsu64 v2;
  double v3;
};
//SIG(1 F_Ul_D) C1{ Fi FL[2]}



static void Test_F_Ul_D()
{
  {
    init_simple_test("F_Ul_D");
    STRUCT_IF_C F_Ul_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_Ul_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_D)");
    check_field_offset(lv, v1, 0, "F_Ul_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_D, F_Ul_D)
//============================================================================


struct  F_Ul_F  {
  float v1;
  __tsu64 v2;
  float v3;
};
//SIG(1 F_Ul_F) C1{ Fi FL Fi}



static void Test_F_Ul_F()
{
  {
    init_simple_test("F_Ul_F");
    STRUCT_IF_C F_Ul_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_F)");
    check_field_offset(lv, v1, 0, "F_Ul_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_F, F_Ul_F)
//============================================================================


struct  F_Ul_I  {
  float v1;
  __tsu64 v2;
  int v3;
};
//SIG(1 F_Ul_I) C1{ Fi FL Fi}



static void Test_F_Ul_I()
{
  {
    init_simple_test("F_Ul_I");
    STRUCT_IF_C F_Ul_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_I)");
    check_field_offset(lv, v1, 0, "F_Ul_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_I, F_Ul_I)
//============================================================================


struct  F_Ul_Ip  {
  float v1;
  __tsu64 v2;
  int *v3;
};
//SIG(1 F_Ul_Ip) C1{ Fi FL Fp}



static void Test_F_Ul_Ip()
{
  {
    init_simple_test("F_Ul_Ip");
    STRUCT_IF_C F_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_Ip)");
    check_field_offset(lv, v1, 0, "F_Ul_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_Ip, F_Ul_Ip)
//============================================================================


struct  F_Ul_L  {
  float v1;
  __tsu64 v2;
  __tsi64 v3;
};
//SIG(1 F_Ul_L) C1{ Fi FL[2]}



static void Test_F_Ul_L()
{
  {
    init_simple_test("F_Ul_L");
    STRUCT_IF_C F_Ul_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_Ul_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_L)");
    check_field_offset(lv, v1, 0, "F_Ul_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_L, F_Ul_L)
//============================================================================


struct  F_Ul_S  {
  float v1;
  __tsu64 v2;
  short v3;
};
//SIG(1 F_Ul_S) C1{ Fi FL Fs}



static void Test_F_Ul_S()
{
  {
    init_simple_test("F_Ul_S");
    STRUCT_IF_C F_Ul_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_S)");
    check_field_offset(lv, v1, 0, "F_Ul_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_S, F_Ul_S)
//============================================================================


struct  F_Ul_Uc  {
  float v1;
  __tsu64 v2;
  unsigned char v3;
};
//SIG(1 F_Ul_Uc) C1{ Fi FL Fc}



static void Test_F_Ul_Uc()
{
  {
    init_simple_test("F_Ul_Uc");
    STRUCT_IF_C F_Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_Uc)");
    check_field_offset(lv, v1, 0, "F_Ul_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_Uc, F_Ul_Uc)
//============================================================================


struct  F_Ul_Ui  {
  float v1;
  __tsu64 v2;
  unsigned int v3;
};
//SIG(1 F_Ul_Ui) C1{ Fi FL Fi}



static void Test_F_Ul_Ui()
{
  {
    init_simple_test("F_Ul_Ui");
    STRUCT_IF_C F_Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_Ui)");
    check_field_offset(lv, v1, 0, "F_Ul_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_Ui, F_Ul_Ui)
//============================================================================


struct  F_Ul_Ul  {
  float v1;
  __tsu64 v2;
  __tsu64 v3;
};
//SIG(1 F_Ul_Ul) C1{ Fi FL[2]}



static void Test_F_Ul_Ul()
{
  {
    init_simple_test("F_Ul_Ul");
    STRUCT_IF_C F_Ul_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(F_Ul_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_Ul)");
    check_field_offset(lv, v1, 0, "F_Ul_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_Ul, F_Ul_Ul)
//============================================================================


struct  F_Ul_Us  {
  float v1;
  __tsu64 v2;
  unsigned short v3;
};
//SIG(1 F_Ul_Us) C1{ Fi FL Fs}



static void Test_F_Ul_Us()
{
  {
    init_simple_test("F_Ul_Us");
    STRUCT_IF_C F_Ul_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_Us)");
    check_field_offset(lv, v1, 0, "F_Ul_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_Us, F_Ul_Us)
//============================================================================


struct  F_Ul_Vp  {
  float v1;
  __tsu64 v2;
  void *v3;
};
//SIG(1 F_Ul_Vp) C1{ Fi FL Fp}



static void Test_F_Ul_Vp()
{
  {
    init_simple_test("F_Ul_Vp");
    STRUCT_IF_C F_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Ul_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Ul_Vp)");
    check_field_offset(lv, v1, 0, "F_Ul_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Ul_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "F_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Ul_Vp, F_Ul_Vp)
//============================================================================


struct  F_Us  {
  float v1;
  unsigned short v2;
};
//SIG(1 F_Us) C1{ Fi Fs}



static void Test_F_Us()
{
  {
    init_simple_test("F_Us");
    STRUCT_IF_C F_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us)");
    check_field_offset(lv, v1, 0, "F_Us.v1");
    check_field_offset(lv, v2, 4, "F_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us, F_Us)
//============================================================================


struct  F_Us_BFu15i  {
  float v1;
  unsigned short v2;
  unsigned int v3:15;
};
//SIG(1 F_Us_BFu15i) C1{ Fi Fs Fi:15}



static void Test_F_Us_BFu15i()
{
  {
    init_simple_test("F_Us_BFu15i");
    static STRUCT_IF_C F_Us_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu15i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_Us_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu15i, F_Us_BFu15i)
//============================================================================


struct  F_Us_BFu15ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:15;
};
//SIG(1 F_Us_BFu15ll) C1{ Fi Fs FL:15}



static void Test_F_Us_BFu15ll()
{
  {
    init_simple_test("F_Us_BFu15ll");
    static STRUCT_IF_C F_Us_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_Us_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu15ll, F_Us_BFu15ll)
//============================================================================


struct  F_Us_BFu15s  {
  float v1;
  unsigned short v2;
  unsigned short v3:15;
};
//SIG(1 F_Us_BFu15s) C1{ Fi Fs Fs:15}



static void Test_F_Us_BFu15s()
{
  {
    init_simple_test("F_Us_BFu15s");
    static STRUCT_IF_C F_Us_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "F_Us_BFu15s.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_Us_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu15s, F_Us_BFu15s)
//============================================================================


struct  F_Us_BFu16i  {
  float v1;
  unsigned short v2;
  unsigned int v3:16;
};
//SIG(1 F_Us_BFu16i) C1{ Fi Fs Fi:16}



static void Test_F_Us_BFu16i()
{
  {
    init_simple_test("F_Us_BFu16i");
    static STRUCT_IF_C F_Us_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu16i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_Us_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu16i, F_Us_BFu16i)
//============================================================================


struct  F_Us_BFu16ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:16;
};
//SIG(1 F_Us_BFu16ll) C1{ Fi Fs FL:16}



static void Test_F_Us_BFu16ll()
{
  {
    init_simple_test("F_Us_BFu16ll");
    static STRUCT_IF_C F_Us_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_Us_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu16ll, F_Us_BFu16ll)
//============================================================================


struct  F_Us_BFu16s  {
  float v1;
  unsigned short v2;
  unsigned short v3:16;
};
//SIG(1 F_Us_BFu16s) C1{ Fi Fs Fs:16}



static void Test_F_Us_BFu16s()
{
  {
    init_simple_test("F_Us_BFu16s");
    static STRUCT_IF_C F_Us_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "F_Us_BFu16s.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_Us_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu16s, F_Us_BFu16s)
//============================================================================


struct  F_Us_BFu17i  {
  float v1;
  unsigned short v2;
  unsigned int v3:17;
};
//SIG(1 F_Us_BFu17i) C1{ Fi Fs Fi:17}



static void Test_F_Us_BFu17i()
{
  {
    init_simple_test("F_Us_BFu17i");
    static STRUCT_IF_C F_Us_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(F_Us_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu17i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_Us_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu17i, F_Us_BFu17i)
//============================================================================


struct  F_Us_BFu17ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:17;
};
//SIG(1 F_Us_BFu17ll) C1{ Fi Fs FL:17}



static void Test_F_Us_BFu17ll()
{
  {
    init_simple_test("F_Us_BFu17ll");
    static STRUCT_IF_C F_Us_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Us_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "F_Us_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "F_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu17ll, F_Us_BFu17ll)
//============================================================================


struct  F_Us_BFu1c  {
  float v1;
  unsigned short v2;
  unsigned char v3:1;
};
//SIG(1 F_Us_BFu1c) C1{ Fi Fs Fc:1}



static void Test_F_Us_BFu1c()
{
  {
    init_simple_test("F_Us_BFu1c");
    static STRUCT_IF_C F_Us_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "F_Us_BFu1c.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu1c, F_Us_BFu1c)
//============================================================================


struct  F_Us_BFu1i  {
  float v1;
  unsigned short v2;
  unsigned int v3:1;
};
//SIG(1 F_Us_BFu1i) C1{ Fi Fs Fi:1}



static void Test_F_Us_BFu1i()
{
  {
    init_simple_test("F_Us_BFu1i");
    static STRUCT_IF_C F_Us_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu1i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu1i, F_Us_BFu1i)
//============================================================================


struct  F_Us_BFu1ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:1;
};
//SIG(1 F_Us_BFu1ll) C1{ Fi Fs FL:1}



static void Test_F_Us_BFu1ll()
{
  {
    init_simple_test("F_Us_BFu1ll");
    static STRUCT_IF_C F_Us_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu1ll, F_Us_BFu1ll)
//============================================================================


struct  F_Us_BFu1s  {
  float v1;
  unsigned short v2;
  unsigned short v3:1;
};
//SIG(1 F_Us_BFu1s) C1{ Fi Fs Fs:1}



static void Test_F_Us_BFu1s()
{
  {
    init_simple_test("F_Us_BFu1s");
    static STRUCT_IF_C F_Us_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "F_Us_BFu1s.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu1s, F_Us_BFu1s)
//============================================================================


struct  F_Us_BFu31i  {
  float v1;
  unsigned short v2;
  unsigned int v3:31;
};
//SIG(1 F_Us_BFu31i) C1{ Fi Fs Fi:31}



static void Test_F_Us_BFu31i()
{
  {
    init_simple_test("F_Us_BFu31i");
    static STRUCT_IF_C F_Us_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_Us_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu31i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_Us_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu31i, F_Us_BFu31i)
//============================================================================


struct  F_Us_BFu31ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:31;
};
//SIG(1 F_Us_BFu31ll) C1{ Fi Fs FL:31}



static void Test_F_Us_BFu31ll()
{
  {
    init_simple_test("F_Us_BFu31ll");
    static STRUCT_IF_C F_Us_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Us_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "F_Us_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "F_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu31ll, F_Us_BFu31ll)
//============================================================================


struct  F_Us_BFu32i  {
  float v1;
  unsigned short v2;
  unsigned int v3:32;
};
//SIG(1 F_Us_BFu32i) C1{ Fi Fs Fi:32}



static void Test_F_Us_BFu32i()
{
  {
    init_simple_test("F_Us_BFu32i");
    static STRUCT_IF_C F_Us_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_Us_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu32i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_Us_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu32i, F_Us_BFu32i)
//============================================================================


struct  F_Us_BFu32ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:32;
};
//SIG(1 F_Us_BFu32ll) C1{ Fi Fs FL:32}



static void Test_F_Us_BFu32ll()
{
  {
    init_simple_test("F_Us_BFu32ll");
    static STRUCT_IF_C F_Us_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Us_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "F_Us_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "F_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu32ll, F_Us_BFu32ll)
//============================================================================


struct  F_Us_BFu33  {
  float v1;
  unsigned short v2;
  __tsu64 v3:33;
};
//SIG(1 F_Us_BFu33) C1{ Fi Fs FL:33}



static void Test_F_Us_BFu33()
{
  {
    init_simple_test("F_Us_BFu33");
    static STRUCT_IF_C F_Us_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Us_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu33)");
    check_field_offset(lv, v1, 0, "F_Us_BFu33.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "F_Us_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "F_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu33, F_Us_BFu33)
//============================================================================


struct  F_Us_BFu7c  {
  float v1;
  unsigned short v2;
  unsigned char v3:7;
};
//SIG(1 F_Us_BFu7c) C1{ Fi Fs Fc:7}



static void Test_F_Us_BFu7c()
{
  {
    init_simple_test("F_Us_BFu7c");
    static STRUCT_IF_C F_Us_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "F_Us_BFu7c.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_Us_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu7c, F_Us_BFu7c)
//============================================================================


struct  F_Us_BFu7i  {
  float v1;
  unsigned short v2;
  unsigned int v3:7;
};
//SIG(1 F_Us_BFu7i) C1{ Fi Fs Fi:7}



static void Test_F_Us_BFu7i()
{
  {
    init_simple_test("F_Us_BFu7i");
    static STRUCT_IF_C F_Us_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu7i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_Us_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu7i, F_Us_BFu7i)
//============================================================================


struct  F_Us_BFu7ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:7;
};
//SIG(1 F_Us_BFu7ll) C1{ Fi Fs FL:7}



static void Test_F_Us_BFu7ll()
{
  {
    init_simple_test("F_Us_BFu7ll");
    static STRUCT_IF_C F_Us_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_Us_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu7ll, F_Us_BFu7ll)
//============================================================================


struct  F_Us_BFu7s  {
  float v1;
  unsigned short v2;
  unsigned short v3:7;
};
//SIG(1 F_Us_BFu7s) C1{ Fi Fs Fs:7}



static void Test_F_Us_BFu7s()
{
  {
    init_simple_test("F_Us_BFu7s");
    static STRUCT_IF_C F_Us_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "F_Us_BFu7s.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_Us_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu7s, F_Us_BFu7s)
//============================================================================


struct  F_Us_BFu8c  {
  float v1;
  unsigned short v2;
  unsigned char v3:8;
};
//SIG(1 F_Us_BFu8c) C1{ Fi Fs Fc:8}



static void Test_F_Us_BFu8c()
{
  {
    init_simple_test("F_Us_BFu8c");
    static STRUCT_IF_C F_Us_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "F_Us_BFu8c.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_Us_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu8c, F_Us_BFu8c)
//============================================================================


struct  F_Us_BFu8i  {
  float v1;
  unsigned short v2;
  unsigned int v3:8;
};
//SIG(1 F_Us_BFu8i) C1{ Fi Fs Fi:8}



static void Test_F_Us_BFu8i()
{
  {
    init_simple_test("F_Us_BFu8i");
    static STRUCT_IF_C F_Us_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu8i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_Us_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu8i, F_Us_BFu8i)
//============================================================================


struct  F_Us_BFu8ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:8;
};
//SIG(1 F_Us_BFu8ll) C1{ Fi Fs FL:8}



static void Test_F_Us_BFu8ll()
{
  {
    init_simple_test("F_Us_BFu8ll");
    static STRUCT_IF_C F_Us_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_Us_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu8ll, F_Us_BFu8ll)
//============================================================================


struct  F_Us_BFu8s  {
  float v1;
  unsigned short v2;
  unsigned short v3:8;
};
//SIG(1 F_Us_BFu8s) C1{ Fi Fs Fs:8}



static void Test_F_Us_BFu8s()
{
  {
    init_simple_test("F_Us_BFu8s");
    static STRUCT_IF_C F_Us_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "F_Us_BFu8s.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_Us_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu8s, F_Us_BFu8s)
//============================================================================


struct  F_Us_BFu9i  {
  float v1;
  unsigned short v2;
  unsigned int v3:9;
};
//SIG(1 F_Us_BFu9i) C1{ Fi Fs Fi:9}



static void Test_F_Us_BFu9i()
{
  {
    init_simple_test("F_Us_BFu9i");
    static STRUCT_IF_C F_Us_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "F_Us_BFu9i.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_Us_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu9i, F_Us_BFu9i)
//============================================================================


struct  F_Us_BFu9ll  {
  float v1;
  unsigned short v2;
  __tsu64 v3:9;
};
//SIG(1 F_Us_BFu9ll) C1{ Fi Fs FL:9}



static void Test_F_Us_BFu9ll()
{
  {
    init_simple_test("F_Us_BFu9ll");
    static STRUCT_IF_C F_Us_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_Us_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu9ll, F_Us_BFu9ll)
//============================================================================


struct  F_Us_BFu9s  {
  float v1;
  unsigned short v2;
  unsigned short v3:9;
};
//SIG(1 F_Us_BFu9s) C1{ Fi Fs Fs:9}



static void Test_F_Us_BFu9s()
{
  {
    init_simple_test("F_Us_BFu9s");
    static STRUCT_IF_C F_Us_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "F_Us_BFu9s.v1");
    check_field_offset(lv, v2, 4, "F_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_Us_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_BFu9s, F_Us_BFu9s)
//============================================================================


struct  F_Us_C  {
  float v1;
  unsigned short v2;
  char v3;
};
//SIG(1 F_Us_C) C1{ Fi Fs Fc}



static void Test_F_Us_C()
{
  {
    init_simple_test("F_Us_C");
    STRUCT_IF_C F_Us_C lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_C)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_C)");
    check_field_offset(lv, v1, 0, "F_Us_C.v1");
    check_field_offset(lv, v2, 4, "F_Us_C.v2");
    check_field_offset(lv, v3, 6, "F_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_C, F_Us_C)
//============================================================================


struct  F_Us_D  {
  float v1;
  unsigned short v2;
  double v3;
};
//SIG(1 F_Us_D) C1{ Fi Fs FL}



static void Test_F_Us_D()
{
  {
    init_simple_test("F_Us_D");
    STRUCT_IF_C F_Us_D lv;
    check2(sizeof(lv), 16, "sizeof(F_Us_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_D)");
    check_field_offset(lv, v1, 0, "F_Us_D.v1");
    check_field_offset(lv, v2, 4, "F_Us_D.v2");
    check_field_offset(lv, v3, 8, "F_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_D, F_Us_D)
//============================================================================


struct  F_Us_F  {
  float v1;
  unsigned short v2;
  float v3;
};
//SIG(1 F_Us_F) C1{ Fi Fs Fi}



static void Test_F_Us_F()
{
  {
    init_simple_test("F_Us_F");
    STRUCT_IF_C F_Us_F lv;
    check2(sizeof(lv), 12, "sizeof(F_Us_F)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_F)");
    check_field_offset(lv, v1, 0, "F_Us_F.v1");
    check_field_offset(lv, v2, 4, "F_Us_F.v2");
    check_field_offset(lv, v3, 8, "F_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_F, F_Us_F)
//============================================================================


struct  F_Us_I  {
  float v1;
  unsigned short v2;
  int v3;
};
//SIG(1 F_Us_I) C1{ Fi Fs Fi}



static void Test_F_Us_I()
{
  {
    init_simple_test("F_Us_I");
    STRUCT_IF_C F_Us_I lv;
    check2(sizeof(lv), 12, "sizeof(F_Us_I)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_I)");
    check_field_offset(lv, v1, 0, "F_Us_I.v1");
    check_field_offset(lv, v2, 4, "F_Us_I.v2");
    check_field_offset(lv, v3, 8, "F_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_I, F_Us_I)
//============================================================================


struct  F_Us_Ip  {
  float v1;
  unsigned short v2;
  int *v3;
};
//SIG(1 F_Us_Ip) C1{ Fi Fs Fp}



static void Test_F_Us_Ip()
{
  {
    init_simple_test("F_Us_Ip");
    STRUCT_IF_C F_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Us_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_Ip)");
    check_field_offset(lv, v1, 0, "F_Us_Ip.v1");
    check_field_offset(lv, v2, 4, "F_Us_Ip.v2");
    check_field_offset(lv, v3, 8, "F_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_Ip, F_Us_Ip)
//============================================================================


struct  F_Us_L  {
  float v1;
  unsigned short v2;
  __tsi64 v3;
};
//SIG(1 F_Us_L) C1{ Fi Fs FL}



static void Test_F_Us_L()
{
  {
    init_simple_test("F_Us_L");
    STRUCT_IF_C F_Us_L lv;
    check2(sizeof(lv), 16, "sizeof(F_Us_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_L)");
    check_field_offset(lv, v1, 0, "F_Us_L.v1");
    check_field_offset(lv, v2, 4, "F_Us_L.v2");
    check_field_offset(lv, v3, 8, "F_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_L, F_Us_L)
//============================================================================


struct  F_Us_S  {
  float v1;
  unsigned short v2;
  short v3;
};
//SIG(1 F_Us_S) C1{ Fi Fs[2]}



static void Test_F_Us_S()
{
  {
    init_simple_test("F_Us_S");
    STRUCT_IF_C F_Us_S lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_S)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_S)");
    check_field_offset(lv, v1, 0, "F_Us_S.v1");
    check_field_offset(lv, v2, 4, "F_Us_S.v2");
    check_field_offset(lv, v3, 6, "F_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_S, F_Us_S)
//============================================================================


struct  F_Us_Uc  {
  float v1;
  unsigned short v2;
  unsigned char v3;
};
//SIG(1 F_Us_Uc) C1{ Fi Fs Fc}



static void Test_F_Us_Uc()
{
  {
    init_simple_test("F_Us_Uc");
    STRUCT_IF_C F_Us_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_Uc)");
    check_field_offset(lv, v1, 0, "F_Us_Uc.v1");
    check_field_offset(lv, v2, 4, "F_Us_Uc.v2");
    check_field_offset(lv, v3, 6, "F_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_Uc, F_Us_Uc)
//============================================================================


struct  F_Us_Ui  {
  float v1;
  unsigned short v2;
  unsigned int v3;
};
//SIG(1 F_Us_Ui) C1{ Fi Fs Fi}



static void Test_F_Us_Ui()
{
  {
    init_simple_test("F_Us_Ui");
    STRUCT_IF_C F_Us_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_Us_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_Ui)");
    check_field_offset(lv, v1, 0, "F_Us_Ui.v1");
    check_field_offset(lv, v2, 4, "F_Us_Ui.v2");
    check_field_offset(lv, v3, 8, "F_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_Ui, F_Us_Ui)
//============================================================================


struct  F_Us_Ul  {
  float v1;
  unsigned short v2;
  __tsu64 v3;
};
//SIG(1 F_Us_Ul) C1{ Fi Fs FL}



static void Test_F_Us_Ul()
{
  {
    init_simple_test("F_Us_Ul");
    STRUCT_IF_C F_Us_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_Us_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_Ul)");
    check_field_offset(lv, v1, 0, "F_Us_Ul.v1");
    check_field_offset(lv, v2, 4, "F_Us_Ul.v2");
    check_field_offset(lv, v3, 8, "F_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_Ul, F_Us_Ul)
//============================================================================


struct  F_Us_Us  {
  float v1;
  unsigned short v2;
  unsigned short v3;
};
//SIG(1 F_Us_Us) C1{ Fi Fs[2]}



static void Test_F_Us_Us()
{
  {
    init_simple_test("F_Us_Us");
    STRUCT_IF_C F_Us_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_Us_Us)");
    check2(__alignof__(lv), 4, "__alignof__(F_Us_Us)");
    check_field_offset(lv, v1, 0, "F_Us_Us.v1");
    check_field_offset(lv, v2, 4, "F_Us_Us.v2");
    check_field_offset(lv, v3, 6, "F_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_Us, F_Us_Us)
//============================================================================


struct  F_Us_Vp  {
  float v1;
  unsigned short v2;
  void *v3;
};
//SIG(1 F_Us_Vp) C1{ Fi Fs Fp}



static void Test_F_Us_Vp()
{
  {
    init_simple_test("F_Us_Vp");
    STRUCT_IF_C F_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_Us_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Us_Vp)");
    check_field_offset(lv, v1, 0, "F_Us_Vp.v1");
    check_field_offset(lv, v2, 4, "F_Us_Vp.v2");
    check_field_offset(lv, v3, 8, "F_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Us_Vp, F_Us_Vp)
//============================================================================


struct  F_Vp  {
  float v1;
  void *v2;
};
//SIG(1 F_Vp) C1{ Fi Fp}



static void Test_F_Vp()
{
  {
    init_simple_test("F_Vp");
    STRUCT_IF_C F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp)");
    check_field_offset(lv, v1, 0, "F_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp, F_Vp)
//============================================================================


struct  F_Vp_BFu15i  {
  float v1;
  void *v2;
  unsigned int v3:15;
};
//SIG(1 F_Vp_BFu15i) C1{ Fi Fp Fi:15}



static void Test_F_Vp_BFu15i()
{
  {
    init_simple_test("F_Vp_BFu15i");
    static STRUCT_IF_C F_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "F_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "F_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu15i, F_Vp_BFu15i)
//============================================================================


struct  F_Vp_BFu15ll  {
  float v1;
  void *v2;
  __tsu64 v3:15;
};
//SIG(1 F_Vp_BFu15ll) C1{ Fi Fp FL:15}



static void Test_F_Vp_BFu15ll()
{
  {
    init_simple_test("F_Vp_BFu15ll");
    static STRUCT_IF_C F_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "F_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "F_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu15ll, F_Vp_BFu15ll)
//============================================================================


struct  F_Vp_BFu15s  {
  float v1;
  void *v2;
  unsigned short v3:15;
};
//SIG(1 F_Vp_BFu15s) C1{ Fi Fp Fs:15}



static void Test_F_Vp_BFu15s()
{
  {
    init_simple_test("F_Vp_BFu15s");
    static STRUCT_IF_C F_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "F_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "F_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu15s, F_Vp_BFu15s)
//============================================================================


struct  F_Vp_BFu16i  {
  float v1;
  void *v2;
  unsigned int v3:16;
};
//SIG(1 F_Vp_BFu16i) C1{ Fi Fp Fi:16}



static void Test_F_Vp_BFu16i()
{
  {
    init_simple_test("F_Vp_BFu16i");
    static STRUCT_IF_C F_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "F_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "F_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu16i, F_Vp_BFu16i)
//============================================================================


struct  F_Vp_BFu16ll  {
  float v1;
  void *v2;
  __tsu64 v3:16;
};
//SIG(1 F_Vp_BFu16ll) C1{ Fi Fp FL:16}



static void Test_F_Vp_BFu16ll()
{
  {
    init_simple_test("F_Vp_BFu16ll");
    static STRUCT_IF_C F_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "F_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "F_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu16ll, F_Vp_BFu16ll)
//============================================================================


struct  F_Vp_BFu16s  {
  float v1;
  void *v2;
  unsigned short v3:16;
};
//SIG(1 F_Vp_BFu16s) C1{ Fi Fp Fs:16}



static void Test_F_Vp_BFu16s()
{
  {
    init_simple_test("F_Vp_BFu16s");
    static STRUCT_IF_C F_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "F_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "F_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu16s, F_Vp_BFu16s)
//============================================================================


struct  F_Vp_BFu17i  {
  float v1;
  void *v2;
  unsigned int v3:17;
};
//SIG(1 F_Vp_BFu17i) C1{ Fi Fp Fi:17}



static void Test_F_Vp_BFu17i()
{
  {
    init_simple_test("F_Vp_BFu17i");
    static STRUCT_IF_C F_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "F_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "F_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu17i, F_Vp_BFu17i)
//============================================================================


struct  F_Vp_BFu17ll  {
  float v1;
  void *v2;
  __tsu64 v3:17;
};
//SIG(1 F_Vp_BFu17ll) C1{ Fi Fp FL:17}



static void Test_F_Vp_BFu17ll()
{
  {
    init_simple_test("F_Vp_BFu17ll");
    static STRUCT_IF_C F_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "F_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "F_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu17ll, F_Vp_BFu17ll)
//============================================================================


struct  F_Vp_BFu1c  {
  float v1;
  void *v2;
  unsigned char v3:1;
};
//SIG(1 F_Vp_BFu1c) C1{ Fi Fp Fc:1}



static void Test_F_Vp_BFu1c()
{
  {
    init_simple_test("F_Vp_BFu1c");
    static STRUCT_IF_C F_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "F_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu1c, F_Vp_BFu1c)
//============================================================================


struct  F_Vp_BFu1i  {
  float v1;
  void *v2;
  unsigned int v3:1;
};
//SIG(1 F_Vp_BFu1i) C1{ Fi Fp Fi:1}



static void Test_F_Vp_BFu1i()
{
  {
    init_simple_test("F_Vp_BFu1i");
    static STRUCT_IF_C F_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "F_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu1i, F_Vp_BFu1i)
//============================================================================


struct  F_Vp_BFu1ll  {
  float v1;
  void *v2;
  __tsu64 v3:1;
};
//SIG(1 F_Vp_BFu1ll) C1{ Fi Fp FL:1}



static void Test_F_Vp_BFu1ll()
{
  {
    init_simple_test("F_Vp_BFu1ll");
    static STRUCT_IF_C F_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "F_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu1ll, F_Vp_BFu1ll)
//============================================================================


struct  F_Vp_BFu1s  {
  float v1;
  void *v2;
  unsigned short v3:1;
};
//SIG(1 F_Vp_BFu1s) C1{ Fi Fp Fs:1}



static void Test_F_Vp_BFu1s()
{
  {
    init_simple_test("F_Vp_BFu1s");
    static STRUCT_IF_C F_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "F_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu1s, F_Vp_BFu1s)
//============================================================================


struct  F_Vp_BFu31i  {
  float v1;
  void *v2;
  unsigned int v3:31;
};
//SIG(1 F_Vp_BFu31i) C1{ Fi Fp Fi:31}



static void Test_F_Vp_BFu31i()
{
  {
    init_simple_test("F_Vp_BFu31i");
    static STRUCT_IF_C F_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "F_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "F_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu31i, F_Vp_BFu31i)
//============================================================================


struct  F_Vp_BFu31ll  {
  float v1;
  void *v2;
  __tsu64 v3:31;
};
//SIG(1 F_Vp_BFu31ll) C1{ Fi Fp FL:31}



static void Test_F_Vp_BFu31ll()
{
  {
    init_simple_test("F_Vp_BFu31ll");
    static STRUCT_IF_C F_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "F_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "F_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu31ll, F_Vp_BFu31ll)
//============================================================================


struct  F_Vp_BFu32i  {
  float v1;
  void *v2;
  unsigned int v3:32;
};
//SIG(1 F_Vp_BFu32i) C1{ Fi Fp Fi:32}



static void Test_F_Vp_BFu32i()
{
  {
    init_simple_test("F_Vp_BFu32i");
    static STRUCT_IF_C F_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "F_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "F_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu32i, F_Vp_BFu32i)
//============================================================================


struct  F_Vp_BFu32ll  {
  float v1;
  void *v2;
  __tsu64 v3:32;
};
//SIG(1 F_Vp_BFu32ll) C1{ Fi Fp FL:32}



static void Test_F_Vp_BFu32ll()
{
  {
    init_simple_test("F_Vp_BFu32ll");
    static STRUCT_IF_C F_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "F_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "F_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu32ll, F_Vp_BFu32ll)
//============================================================================


struct  F_Vp_BFu33  {
  float v1;
  void *v2;
  __tsu64 v3:33;
};
//SIG(1 F_Vp_BFu33) C1{ Fi Fp FL:33}



static void Test_F_Vp_BFu33()
{
  {
    init_simple_test("F_Vp_BFu33");
    static STRUCT_IF_C F_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Vp_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "F_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "F_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu33, F_Vp_BFu33)
//============================================================================


struct  F_Vp_BFu7c  {
  float v1;
  void *v2;
  unsigned char v3:7;
};
//SIG(1 F_Vp_BFu7c) C1{ Fi Fp Fc:7}



static void Test_F_Vp_BFu7c()
{
  {
    init_simple_test("F_Vp_BFu7c");
    static STRUCT_IF_C F_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "F_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "F_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu7c, F_Vp_BFu7c)
//============================================================================


struct  F_Vp_BFu7i  {
  float v1;
  void *v2;
  unsigned int v3:7;
};
//SIG(1 F_Vp_BFu7i) C1{ Fi Fp Fi:7}



static void Test_F_Vp_BFu7i()
{
  {
    init_simple_test("F_Vp_BFu7i");
    static STRUCT_IF_C F_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "F_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "F_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu7i, F_Vp_BFu7i)
//============================================================================


struct  F_Vp_BFu7ll  {
  float v1;
  void *v2;
  __tsu64 v3:7;
};
//SIG(1 F_Vp_BFu7ll) C1{ Fi Fp FL:7}



static void Test_F_Vp_BFu7ll()
{
  {
    init_simple_test("F_Vp_BFu7ll");
    static STRUCT_IF_C F_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "F_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "F_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu7ll, F_Vp_BFu7ll)
//============================================================================


struct  F_Vp_BFu7s  {
  float v1;
  void *v2;
  unsigned short v3:7;
};
//SIG(1 F_Vp_BFu7s) C1{ Fi Fp Fs:7}



static void Test_F_Vp_BFu7s()
{
  {
    init_simple_test("F_Vp_BFu7s");
    static STRUCT_IF_C F_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "F_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "F_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu7s, F_Vp_BFu7s)
//============================================================================


struct  F_Vp_BFu8c  {
  float v1;
  void *v2;
  unsigned char v3:8;
};
//SIG(1 F_Vp_BFu8c) C1{ Fi Fp Fc:8}



static void Test_F_Vp_BFu8c()
{
  {
    init_simple_test("F_Vp_BFu8c");
    static STRUCT_IF_C F_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "F_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "F_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu8c, F_Vp_BFu8c)
//============================================================================


struct  F_Vp_BFu8i  {
  float v1;
  void *v2;
  unsigned int v3:8;
};
//SIG(1 F_Vp_BFu8i) C1{ Fi Fp Fi:8}



static void Test_F_Vp_BFu8i()
{
  {
    init_simple_test("F_Vp_BFu8i");
    static STRUCT_IF_C F_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "F_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "F_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu8i, F_Vp_BFu8i)
//============================================================================


struct  F_Vp_BFu8ll  {
  float v1;
  void *v2;
  __tsu64 v3:8;
};
//SIG(1 F_Vp_BFu8ll) C1{ Fi Fp FL:8}



static void Test_F_Vp_BFu8ll()
{
  {
    init_simple_test("F_Vp_BFu8ll");
    static STRUCT_IF_C F_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "F_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "F_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu8ll, F_Vp_BFu8ll)
//============================================================================


struct  F_Vp_BFu8s  {
  float v1;
  void *v2;
  unsigned short v3:8;
};
//SIG(1 F_Vp_BFu8s) C1{ Fi Fp Fs:8}



static void Test_F_Vp_BFu8s()
{
  {
    init_simple_test("F_Vp_BFu8s");
    static STRUCT_IF_C F_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "F_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "F_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu8s, F_Vp_BFu8s)
//============================================================================


struct  F_Vp_BFu9i  {
  float v1;
  void *v2;
  unsigned int v3:9;
};
//SIG(1 F_Vp_BFu9i) C1{ Fi Fp Fi:9}



static void Test_F_Vp_BFu9i()
{
  {
    init_simple_test("F_Vp_BFu9i");
    static STRUCT_IF_C F_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "F_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "F_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu9i, F_Vp_BFu9i)
//============================================================================


struct  F_Vp_BFu9ll  {
  float v1;
  void *v2;
  __tsu64 v3:9;
};
//SIG(1 F_Vp_BFu9ll) C1{ Fi Fp FL:9}



static void Test_F_Vp_BFu9ll()
{
  {
    init_simple_test("F_Vp_BFu9ll");
    static STRUCT_IF_C F_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "F_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "F_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu9ll, F_Vp_BFu9ll)
//============================================================================


struct  F_Vp_BFu9s  {
  float v1;
  void *v2;
  unsigned short v3:9;
};
//SIG(1 F_Vp_BFu9s) C1{ Fi Fp Fs:9}



static void Test_F_Vp_BFu9s()
{
  {
    init_simple_test("F_Vp_BFu9s");
    static STRUCT_IF_C F_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "F_Vp_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "F_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "F_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_BFu9s, F_Vp_BFu9s)
//============================================================================


struct  F_Vp_C  {
  float v1;
  void *v2;
  char v3;
};
//SIG(1 F_Vp_C) C1{ Fi Fp Fc}



static void Test_F_Vp_C()
{
  {
    init_simple_test("F_Vp_C");
    STRUCT_IF_C F_Vp_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_C)");
    check_field_offset(lv, v1, 0, "F_Vp_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_C, F_Vp_C)
//============================================================================


struct  F_Vp_D  {
  float v1;
  void *v2;
  double v3;
};
//SIG(1 F_Vp_D) C1{ Fi Fp FL}



static void Test_F_Vp_D()
{
  {
    init_simple_test("F_Vp_D");
    STRUCT_IF_C F_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Vp_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_D)");
    check_field_offset(lv, v1, 0, "F_Vp_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_D, F_Vp_D)
//============================================================================


struct  F_Vp_F  {
  float v1;
  void *v2;
  float v3;
};
//SIG(1 F_Vp_F) C1{ Fi Fp Fi}



static void Test_F_Vp_F()
{
  {
    init_simple_test("F_Vp_F");
    STRUCT_IF_C F_Vp_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_F)");
    check_field_offset(lv, v1, 0, "F_Vp_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_F, F_Vp_F)
//============================================================================


struct  F_Vp_I  {
  float v1;
  void *v2;
  int v3;
};
//SIG(1 F_Vp_I) C1{ Fi Fp Fi}



static void Test_F_Vp_I()
{
  {
    init_simple_test("F_Vp_I");
    STRUCT_IF_C F_Vp_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_I)");
    check_field_offset(lv, v1, 0, "F_Vp_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_I, F_Vp_I)
//============================================================================


struct  F_Vp_Ip  {
  float v1;
  void *v2;
  int *v3;
};
//SIG(1 F_Vp_Ip) C1{ Fi Fp[2]}



static void Test_F_Vp_Ip()
{
  {
    init_simple_test("F_Vp_Ip");
    STRUCT_IF_C F_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_Ip)");
    check_field_offset(lv, v1, 0, "F_Vp_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_Ip, F_Vp_Ip)
//============================================================================


struct  F_Vp_L  {
  float v1;
  void *v2;
  __tsi64 v3;
};
//SIG(1 F_Vp_L) C1{ Fi Fp FL}



static void Test_F_Vp_L()
{
  {
    init_simple_test("F_Vp_L");
    STRUCT_IF_C F_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Vp_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_L)");
    check_field_offset(lv, v1, 0, "F_Vp_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_L, F_Vp_L)
//============================================================================


struct  F_Vp_S  {
  float v1;
  void *v2;
  short v3;
};
//SIG(1 F_Vp_S) C1{ Fi Fp Fs}



static void Test_F_Vp_S()
{
  {
    init_simple_test("F_Vp_S");
    STRUCT_IF_C F_Vp_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_S)");
    check_field_offset(lv, v1, 0, "F_Vp_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_S, F_Vp_S)
//============================================================================


struct  F_Vp_Uc  {
  float v1;
  void *v2;
  unsigned char v3;
};
//SIG(1 F_Vp_Uc) C1{ Fi Fp Fc}



static void Test_F_Vp_Uc()
{
  {
    init_simple_test("F_Vp_Uc");
    STRUCT_IF_C F_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_Uc)");
    check_field_offset(lv, v1, 0, "F_Vp_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_Uc, F_Vp_Uc)
//============================================================================


struct  F_Vp_Ui  {
  float v1;
  void *v2;
  unsigned int v3;
};
//SIG(1 F_Vp_Ui) C1{ Fi Fp Fi}



static void Test_F_Vp_Ui()
{
  {
    init_simple_test("F_Vp_Ui");
    STRUCT_IF_C F_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_Ui)");
    check_field_offset(lv, v1, 0, "F_Vp_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_Ui, F_Vp_Ui)
//============================================================================


struct  F_Vp_Ul  {
  float v1;
  void *v2;
  __tsu64 v3;
};
//SIG(1 F_Vp_Ul) C1{ Fi Fp FL}



static void Test_F_Vp_Ul()
{
  {
    init_simple_test("F_Vp_Ul");
    STRUCT_IF_C F_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(F_Vp_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_Ul)");
    check_field_offset(lv, v1, 0, "F_Vp_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_Ul, F_Vp_Ul)
//============================================================================


struct  F_Vp_Us  {
  float v1;
  void *v2;
  unsigned short v3;
};
//SIG(1 F_Vp_Us) C1{ Fi Fp Fs}



static void Test_F_Vp_Us()
{
  {
    init_simple_test("F_Vp_Us");
    STRUCT_IF_C F_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_Us)");
    check_field_offset(lv, v1, 0, "F_Vp_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_Us, F_Vp_Us)
//============================================================================


struct  F_Vp_Vp  {
  float v1;
  void *v2;
  void *v3;
};
//SIG(1 F_Vp_Vp) C1{ Fi Fp[2]}



static void Test_F_Vp_Vp()
{
  {
    init_simple_test("F_Vp_Vp");
    STRUCT_IF_C F_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(F_Vp_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F_Vp_Vp)");
    check_field_offset(lv, v1, 0, "F_Vp_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "F_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "F_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_Vp_Vp, F_Vp_Vp)
//============================================================================


struct  I  {
  int v1;
};
//SIG(1 I) C1{ Fi}



static void Test_I()
{
  {
    init_simple_test("I");
    STRUCT_IF_C I lv;
    check2(sizeof(lv), 4, "sizeof(I)");
    check2(__alignof__(lv), 4, "__alignof__(I)");
    check_field_offset(lv, v1, 0, "I.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_I, I)
//============================================================================


struct  I_BFu15i  {
  int v1;
  unsigned int v2:15;
};
//SIG(1 I_BFu15i) C1{ Fi Fi:15}



static void Test_I_BFu15i()
{
  {
    init_simple_test("I_BFu15i");
    static STRUCT_IF_C I_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i)");
    check_field_offset(lv, v1, 0, "I_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i, I_BFu15i)
//============================================================================


struct  I_BFu15i_BFu15i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 I_BFu15i_BFu15i) C1{ Fi Fi:15 Fi:15}



static void Test_I_BFu15i_BFu15i()
{
  {
    init_simple_test("I_BFu15i_BFu15i");
    static STRUCT_IF_C I_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "I_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "I_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu15i, I_BFu15i_BFu15i)
//============================================================================


struct  I_BFu15i_BFu15ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 I_BFu15i_BFu15ll) C1{ Fi Fi:15 FL:15}



static void Test_I_BFu15i_BFu15ll()
{
  {
    init_simple_test("I_BFu15i_BFu15ll");
    static STRUCT_IF_C I_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "I_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "I_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu15ll, I_BFu15i_BFu15ll)
//============================================================================


struct  I_BFu15i_BFu15s  {
  int v1;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 I_BFu15i_BFu15s) C1{ Fi Fi:15 Fs:15}



static void Test_I_BFu15i_BFu15s()
{
  {
    init_simple_test("I_BFu15i_BFu15s");
    static STRUCT_IF_C I_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "I_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu15s, I_BFu15i_BFu15s)
//============================================================================


struct  I_BFu15i_BFu16i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:16;
};
//SIG(1 I_BFu15i_BFu16i) C1{ Fi Fi:15 Fi:16}



static void Test_I_BFu15i_BFu16i()
{
  {
    init_simple_test("I_BFu15i_BFu16i");
    static STRUCT_IF_C I_BFu15i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "I_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "I_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu16i, I_BFu15i_BFu16i)
//============================================================================


struct  I_BFu15i_BFu16ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:16;
};
//SIG(1 I_BFu15i_BFu16ll) C1{ Fi Fi:15 FL:16}



static void Test_I_BFu15i_BFu16ll()
{
  {
    init_simple_test("I_BFu15i_BFu16ll");
    static STRUCT_IF_C I_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "I_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "I_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu16ll, I_BFu15i_BFu16ll)
//============================================================================


struct  I_BFu15i_BFu16s  {
  int v1;
  unsigned int v2:15;
  unsigned short v3:16;
};
//SIG(1 I_BFu15i_BFu16s) C1{ Fi Fi:15 Fs:16}



static void Test_I_BFu15i_BFu16s()
{
  {
    init_simple_test("I_BFu15i_BFu16s");
    static STRUCT_IF_C I_BFu15i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "I_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "I_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu16s, I_BFu15i_BFu16s)
//============================================================================


struct  I_BFu15i_BFu17i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:17;
};
//SIG(1 I_BFu15i_BFu17i) C1{ Fi Fi:15 Fi:17}



static void Test_I_BFu15i_BFu17i()
{
  {
    init_simple_test("I_BFu15i_BFu17i");
    static STRUCT_IF_C I_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "I_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "I_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu17i, I_BFu15i_BFu17i)
//============================================================================


struct  I_BFu15i_BFu17ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:17;
};
//SIG(1 I_BFu15i_BFu17ll) C1{ Fi Fi:15 FL:17}



static void Test_I_BFu15i_BFu17ll()
{
  {
    init_simple_test("I_BFu15i_BFu17ll");
    static STRUCT_IF_C I_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "I_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "I_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu17ll, I_BFu15i_BFu17ll)
//============================================================================


struct  I_BFu15i_BFu1c  {
  int v1;
  unsigned int v2:15;
  unsigned char v3:1;
};
//SIG(1 I_BFu15i_BFu1c) C1{ Fi Fi:15 Fc:1}



static void Test_I_BFu15i_BFu1c()
{
  {
    init_simple_test("I_BFu15i_BFu1c");
    static STRUCT_IF_C I_BFu15i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu1c, I_BFu15i_BFu1c)
//============================================================================


struct  I_BFu15i_BFu1i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:1;
};
//SIG(1 I_BFu15i_BFu1i) C1{ Fi Fi:15 Fi:1}



static void Test_I_BFu15i_BFu1i()
{
  {
    init_simple_test("I_BFu15i_BFu1i");
    static STRUCT_IF_C I_BFu15i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu1i, I_BFu15i_BFu1i)
//============================================================================


struct  I_BFu15i_BFu1ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:1;
};
//SIG(1 I_BFu15i_BFu1ll) C1{ Fi Fi:15 FL:1}



static void Test_I_BFu15i_BFu1ll()
{
  {
    init_simple_test("I_BFu15i_BFu1ll");
    static STRUCT_IF_C I_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu1ll, I_BFu15i_BFu1ll)
//============================================================================


struct  I_BFu15i_BFu1s  {
  int v1;
  unsigned int v2:15;
  unsigned short v3:1;
};
//SIG(1 I_BFu15i_BFu1s) C1{ Fi Fi:15 Fs:1}



static void Test_I_BFu15i_BFu1s()
{
  {
    init_simple_test("I_BFu15i_BFu1s");
    static STRUCT_IF_C I_BFu15i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu1s, I_BFu15i_BFu1s)
//============================================================================


struct  I_BFu15i_BFu31i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:31;
};
//SIG(1 I_BFu15i_BFu31i) C1{ Fi Fi:15 Fi:31}



static void Test_I_BFu15i_BFu31i()
{
  {
    init_simple_test("I_BFu15i_BFu31i");
    static STRUCT_IF_C I_BFu15i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(I_BFu15i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "I_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "I_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu31i, I_BFu15i_BFu31i)
//============================================================================


struct  I_BFu15i_BFu31ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:31;
};
//SIG(1 I_BFu15i_BFu31ll) C1{ Fi Fi:15 FL:31}



static void Test_I_BFu15i_BFu31ll()
{
  {
    init_simple_test("I_BFu15i_BFu31ll");
    static STRUCT_IF_C I_BFu15i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, 1, "I_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, hide_ull(1LL<<30), "I_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu31ll, I_BFu15i_BFu31ll)
//============================================================================


struct  I_BFu15i_BFu32i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:32;
};
//SIG(1 I_BFu15i_BFu32i) C1{ Fi Fi:15 Fi:32}



static void Test_I_BFu15i_BFu32i()
{
  {
    init_simple_test("I_BFu15i_BFu32i");
    static STRUCT_IF_C I_BFu15i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(I_BFu15i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "I_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "I_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu32i, I_BFu15i_BFu32i)
//============================================================================


struct  I_BFu15i_BFu32ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:32;
};
//SIG(1 I_BFu15i_BFu32ll) C1{ Fi Fi:15 FL:32}



static void Test_I_BFu15i_BFu32ll()
{
  {
    init_simple_test("I_BFu15i_BFu32ll");
    static STRUCT_IF_C I_BFu15i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, 1, "I_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, hide_ull(1LL<<31), "I_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu32ll, I_BFu15i_BFu32ll)
//============================================================================


struct  I_BFu15i_BFu33  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:33;
};
//SIG(1 I_BFu15i_BFu33) C1{ Fi Fi:15 FL:33}



static void Test_I_BFu15i_BFu33()
{
  {
    init_simple_test("I_BFu15i_BFu33");
    static STRUCT_IF_C I_BFu15i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, 1, "I_BFu15i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, hide_ull(1LL<<32), "I_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu33, I_BFu15i_BFu33)
//============================================================================


struct  I_BFu15i_BFu7c  {
  int v1;
  unsigned int v2:15;
  unsigned char v3:7;
};
//SIG(1 I_BFu15i_BFu7c) C1{ Fi Fi:15 Fc:7}



static void Test_I_BFu15i_BFu7c()
{
  {
    init_simple_test("I_BFu15i_BFu7c");
    static STRUCT_IF_C I_BFu15i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "I_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "I_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu7c, I_BFu15i_BFu7c)
//============================================================================


struct  I_BFu15i_BFu7i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:7;
};
//SIG(1 I_BFu15i_BFu7i) C1{ Fi Fi:15 Fi:7}



static void Test_I_BFu15i_BFu7i()
{
  {
    init_simple_test("I_BFu15i_BFu7i");
    static STRUCT_IF_C I_BFu15i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "I_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "I_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu7i, I_BFu15i_BFu7i)
//============================================================================


struct  I_BFu15i_BFu7ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:7;
};
//SIG(1 I_BFu15i_BFu7ll) C1{ Fi Fi:15 FL:7}



static void Test_I_BFu15i_BFu7ll()
{
  {
    init_simple_test("I_BFu15i_BFu7ll");
    static STRUCT_IF_C I_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "I_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "I_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu7ll, I_BFu15i_BFu7ll)
//============================================================================


struct  I_BFu15i_BFu7s  {
  int v1;
  unsigned int v2:15;
  unsigned short v3:7;
};
//SIG(1 I_BFu15i_BFu7s) C1{ Fi Fi:15 Fs:7}



static void Test_I_BFu15i_BFu7s()
{
  {
    init_simple_test("I_BFu15i_BFu7s");
    static STRUCT_IF_C I_BFu15i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "I_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "I_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu7s, I_BFu15i_BFu7s)
//============================================================================


struct  I_BFu15i_BFu8c  {
  int v1;
  unsigned int v2:15;
  unsigned char v3:8;
};
//SIG(1 I_BFu15i_BFu8c) C1{ Fi Fi:15 Fc:8}



static void Test_I_BFu15i_BFu8c()
{
  {
    init_simple_test("I_BFu15i_BFu8c");
    static STRUCT_IF_C I_BFu15i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "I_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "I_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu8c, I_BFu15i_BFu8c)
//============================================================================


struct  I_BFu15i_BFu8i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:8;
};
//SIG(1 I_BFu15i_BFu8i) C1{ Fi Fi:15 Fi:8}



static void Test_I_BFu15i_BFu8i()
{
  {
    init_simple_test("I_BFu15i_BFu8i");
    static STRUCT_IF_C I_BFu15i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "I_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "I_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu8i, I_BFu15i_BFu8i)
//============================================================================


struct  I_BFu15i_BFu8ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:8;
};
//SIG(1 I_BFu15i_BFu8ll) C1{ Fi Fi:15 FL:8}



static void Test_I_BFu15i_BFu8ll()
{
  {
    init_simple_test("I_BFu15i_BFu8ll");
    static STRUCT_IF_C I_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "I_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "I_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu8ll, I_BFu15i_BFu8ll)
//============================================================================


struct  I_BFu15i_BFu8s  {
  int v1;
  unsigned int v2:15;
  unsigned short v3:8;
};
//SIG(1 I_BFu15i_BFu8s) C1{ Fi Fi:15 Fs:8}



static void Test_I_BFu15i_BFu8s()
{
  {
    init_simple_test("I_BFu15i_BFu8s");
    static STRUCT_IF_C I_BFu15i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "I_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "I_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu8s, I_BFu15i_BFu8s)
//============================================================================


struct  I_BFu15i_BFu9i  {
  int v1;
  unsigned int v2:15;
  unsigned int v3:9;
};
//SIG(1 I_BFu15i_BFu9i) C1{ Fi Fi:15 Fi:9}



static void Test_I_BFu15i_BFu9i()
{
  {
    init_simple_test("I_BFu15i_BFu9i");
    static STRUCT_IF_C I_BFu15i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "I_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "I_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu9i, I_BFu15i_BFu9i)
//============================================================================


struct  I_BFu15i_BFu9ll  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3:9;
};
//SIG(1 I_BFu15i_BFu9ll) C1{ Fi Fi:15 FL:9}



static void Test_I_BFu15i_BFu9ll()
{
  {
    init_simple_test("I_BFu15i_BFu9ll");
    static STRUCT_IF_C I_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "I_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "I_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu9ll, I_BFu15i_BFu9ll)
//============================================================================


struct  I_BFu15i_BFu9s  {
  int v1;
  unsigned int v2:15;
  unsigned short v3:9;
};
//SIG(1 I_BFu15i_BFu9s) C1{ Fi Fi:15 Fs:9}



static void Test_I_BFu15i_BFu9s()
{
  {
    init_simple_test("I_BFu15i_BFu9s");
    static STRUCT_IF_C I_BFu15i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "I_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "I_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "I_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_BFu9s, I_BFu15i_BFu9s)
//============================================================================


struct  I_BFu15i_C  {
  int v1;
  unsigned int v2:15;
  char v3;
};
//SIG(1 I_BFu15i_C) C1{ Fi Fi:15 Fc}



static void Test_I_BFu15i_C()
{
  {
    init_simple_test("I_BFu15i_C");
    static STRUCT_IF_C I_BFu15i_C lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_C)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_C)");
    check_field_offset(lv, v1, 0, "I_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_C");
    check_field_offset(lv, v3, 6, "I_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_C, I_BFu15i_C)
//============================================================================


struct  I_BFu15i_D  {
  int v1;
  unsigned int v2:15;
  double v3;
};
//SIG(1 I_BFu15i_D) C1{ Fi Fi:15 FL}



static void Test_I_BFu15i_D()
{
  {
    init_simple_test("I_BFu15i_D");
    static STRUCT_IF_C I_BFu15i_D lv;
    check2(sizeof(lv), 16, "sizeof(I_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_D)");
    check_field_offset(lv, v1, 0, "I_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_D");
    check_field_offset(lv, v3, 8, "I_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_D, I_BFu15i_D)
//============================================================================


struct  I_BFu15i_F  {
  int v1;
  unsigned int v2:15;
  float v3;
};
//SIG(1 I_BFu15i_F) C1{ Fi Fi:15 Fi}



static void Test_I_BFu15i_F()
{
  {
    init_simple_test("I_BFu15i_F");
    static STRUCT_IF_C I_BFu15i_F lv;
    check2(sizeof(lv), 12, "sizeof(I_BFu15i_F)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_F)");
    check_field_offset(lv, v1, 0, "I_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_F");
    check_field_offset(lv, v3, 8, "I_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_F, I_BFu15i_F)
//============================================================================


struct  I_BFu15i_I  {
  int v1;
  unsigned int v2:15;
  int v3;
};
//SIG(1 I_BFu15i_I) C1{ Fi Fi:15 Fi}



static void Test_I_BFu15i_I()
{
  {
    init_simple_test("I_BFu15i_I");
    static STRUCT_IF_C I_BFu15i_I lv;
    check2(sizeof(lv), 12, "sizeof(I_BFu15i_I)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_I)");
    check_field_offset(lv, v1, 0, "I_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_I");
    check_field_offset(lv, v3, 8, "I_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_I, I_BFu15i_I)
//============================================================================


struct  I_BFu15i_Ip  {
  int v1;
  unsigned int v2:15;
  int *v3;
};
//SIG(1 I_BFu15i_Ip) C1{ Fi Fi:15 Fp}



static void Test_I_BFu15i_Ip()
{
  {
    init_simple_test("I_BFu15i_Ip");
    static STRUCT_IF_C I_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "I_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_Ip");
    check_field_offset(lv, v3, 8, "I_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_Ip, I_BFu15i_Ip)
//============================================================================


struct  I_BFu15i_L  {
  int v1;
  unsigned int v2:15;
  __tsi64 v3;
};
//SIG(1 I_BFu15i_L) C1{ Fi Fi:15 FL}



static void Test_I_BFu15i_L()
{
  {
    init_simple_test("I_BFu15i_L");
    static STRUCT_IF_C I_BFu15i_L lv;
    check2(sizeof(lv), 16, "sizeof(I_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_L)");
    check_field_offset(lv, v1, 0, "I_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_L");
    check_field_offset(lv, v3, 8, "I_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_L, I_BFu15i_L)
//============================================================================


struct  I_BFu15i_S  {
  int v1;
  unsigned int v2:15;
  short v3;
};
//SIG(1 I_BFu15i_S) C1{ Fi Fi:15 Fs}



static void Test_I_BFu15i_S()
{
  {
    init_simple_test("I_BFu15i_S");
    static STRUCT_IF_C I_BFu15i_S lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_S)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_S)");
    check_field_offset(lv, v1, 0, "I_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_S");
    check_field_offset(lv, v3, 6, "I_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_S, I_BFu15i_S)
//============================================================================


struct  I_BFu15i_Uc  {
  int v1;
  unsigned int v2:15;
  unsigned char v3;
};
//SIG(1 I_BFu15i_Uc) C1{ Fi Fi:15 Fc}



static void Test_I_BFu15i_Uc()
{
  {
    init_simple_test("I_BFu15i_Uc");
    static STRUCT_IF_C I_BFu15i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "I_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_Uc");
    check_field_offset(lv, v3, 6, "I_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_Uc, I_BFu15i_Uc)
//============================================================================


struct  I_BFu15i_Ui  {
  int v1;
  unsigned int v2:15;
  unsigned int v3;
};
//SIG(1 I_BFu15i_Ui) C1{ Fi Fi:15 Fi}



static void Test_I_BFu15i_Ui()
{
  {
    init_simple_test("I_BFu15i_Ui");
    static STRUCT_IF_C I_BFu15i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(I_BFu15i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "I_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_Ui");
    check_field_offset(lv, v3, 8, "I_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_Ui, I_BFu15i_Ui)
//============================================================================


struct  I_BFu15i_Ul  {
  int v1;
  unsigned int v2:15;
  __tsu64 v3;
};
//SIG(1 I_BFu15i_Ul) C1{ Fi Fi:15 FL}



static void Test_I_BFu15i_Ul()
{
  {
    init_simple_test("I_BFu15i_Ul");
    static STRUCT_IF_C I_BFu15i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(I_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "I_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_Ul");
    check_field_offset(lv, v3, 8, "I_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_Ul, I_BFu15i_Ul)
//============================================================================


struct  I_BFu15i_Us  {
  int v1;
  unsigned int v2:15;
  unsigned short v3;
};
//SIG(1 I_BFu15i_Us) C1{ Fi Fi:15 Fs}



static void Test_I_BFu15i_Us()
{
  {
    init_simple_test("I_BFu15i_Us");
    static STRUCT_IF_C I_BFu15i_Us lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "I_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_Us");
    check_field_offset(lv, v3, 6, "I_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_Us, I_BFu15i_Us)
//============================================================================


struct  I_BFu15i_Vp  {
  int v1;
  unsigned int v2:15;
  void *v3;
};
//SIG(1 I_BFu15i_Vp) C1{ Fi Fi:15 Fp}



static void Test_I_BFu15i_Vp()
{
  {
    init_simple_test("I_BFu15i_Vp");
    static STRUCT_IF_C I_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "I_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15i_Vp");
    check_field_offset(lv, v3, 8, "I_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15i_Vp, I_BFu15i_Vp)
//============================================================================


struct  I_BFu15ll  {
  int v1;
  __tsu64 v2:15;
};
//SIG(1 I_BFu15ll) C1{ Fi FL:15}



static void Test_I_BFu15ll()
{
  {
    init_simple_test("I_BFu15ll");
    static STRUCT_IF_C I_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll, I_BFu15ll)
//============================================================================


struct  I_BFu15ll_BFu15i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 I_BFu15ll_BFu15i) C1{ Fi FL:15 Fi:15}



static void Test_I_BFu15ll_BFu15i()
{
  {
    init_simple_test("I_BFu15ll_BFu15i");
    static STRUCT_IF_C I_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "I_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu15i, I_BFu15ll_BFu15i)
//============================================================================


struct  I_BFu15ll_BFu15ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 I_BFu15ll_BFu15ll) C1{ Fi FL:15 FL:15}



static void Test_I_BFu15ll_BFu15ll()
{
  {
    init_simple_test("I_BFu15ll_BFu15ll");
    static STRUCT_IF_C I_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "I_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu15ll, I_BFu15ll_BFu15ll)
//============================================================================


struct  I_BFu15ll_BFu15s  {
  int v1;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 I_BFu15ll_BFu15s) C1{ Fi FL:15 Fs:15}



static void Test_I_BFu15ll_BFu15s()
{
  {
    init_simple_test("I_BFu15ll_BFu15s");
    static STRUCT_IF_C I_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "I_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu15s, I_BFu15ll_BFu15s)
//============================================================================


struct  I_BFu15ll_BFu16i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 I_BFu15ll_BFu16i) C1{ Fi FL:15 Fi:16}



static void Test_I_BFu15ll_BFu16i()
{
  {
    init_simple_test("I_BFu15ll_BFu16i");
    static STRUCT_IF_C I_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "I_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "I_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu16i, I_BFu15ll_BFu16i)
//============================================================================


struct  I_BFu15ll_BFu16ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 I_BFu15ll_BFu16ll) C1{ Fi FL:15 FL:16}



static void Test_I_BFu15ll_BFu16ll()
{
  {
    init_simple_test("I_BFu15ll_BFu16ll");
    static STRUCT_IF_C I_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "I_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "I_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu16ll, I_BFu15ll_BFu16ll)
//============================================================================


struct  I_BFu15ll_BFu16s  {
  int v1;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 I_BFu15ll_BFu16s) C1{ Fi FL:15 Fs:16}



static void Test_I_BFu15ll_BFu16s()
{
  {
    init_simple_test("I_BFu15ll_BFu16s");
    static STRUCT_IF_C I_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "I_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "I_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu16s, I_BFu15ll_BFu16s)
//============================================================================


struct  I_BFu15ll_BFu17i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 I_BFu15ll_BFu17i) C1{ Fi FL:15 Fi:17}



static void Test_I_BFu15ll_BFu17i()
{
  {
    init_simple_test("I_BFu15ll_BFu17i");
    static STRUCT_IF_C I_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "I_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "I_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu17i, I_BFu15ll_BFu17i)
//============================================================================


struct  I_BFu15ll_BFu17ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 I_BFu15ll_BFu17ll) C1{ Fi FL:15 FL:17}



static void Test_I_BFu15ll_BFu17ll()
{
  {
    init_simple_test("I_BFu15ll_BFu17ll");
    static STRUCT_IF_C I_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "I_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "I_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu17ll, I_BFu15ll_BFu17ll)
//============================================================================


struct  I_BFu15ll_BFu1c  {
  int v1;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 I_BFu15ll_BFu1c) C1{ Fi FL:15 Fc:1}



static void Test_I_BFu15ll_BFu1c()
{
  {
    init_simple_test("I_BFu15ll_BFu1c");
    static STRUCT_IF_C I_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu1c, I_BFu15ll_BFu1c)
//============================================================================


struct  I_BFu15ll_BFu1i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 I_BFu15ll_BFu1i) C1{ Fi FL:15 Fi:1}



static void Test_I_BFu15ll_BFu1i()
{
  {
    init_simple_test("I_BFu15ll_BFu1i");
    static STRUCT_IF_C I_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu1i, I_BFu15ll_BFu1i)
//============================================================================


struct  I_BFu15ll_BFu1ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 I_BFu15ll_BFu1ll) C1{ Fi FL:15 FL:1}



static void Test_I_BFu15ll_BFu1ll()
{
  {
    init_simple_test("I_BFu15ll_BFu1ll");
    static STRUCT_IF_C I_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu1ll, I_BFu15ll_BFu1ll)
//============================================================================


struct  I_BFu15ll_BFu1s  {
  int v1;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 I_BFu15ll_BFu1s) C1{ Fi FL:15 Fs:1}



static void Test_I_BFu15ll_BFu1s()
{
  {
    init_simple_test("I_BFu15ll_BFu1s");
    static STRUCT_IF_C I_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu1s, I_BFu15ll_BFu1s)
//============================================================================


struct  I_BFu15ll_BFu31i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 I_BFu15ll_BFu31i) C1{ Fi FL:15 Fi:31}



static void Test_I_BFu15ll_BFu31i()
{
  {
    init_simple_test("I_BFu15ll_BFu31i");
    static STRUCT_IF_C I_BFu15ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "I_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "I_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu31i, I_BFu15ll_BFu31i)
//============================================================================


struct  I_BFu15ll_BFu31ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 I_BFu15ll_BFu31ll) C1{ Fi FL:15 FL:31}



static void Test_I_BFu15ll_BFu31ll()
{
  {
    init_simple_test("I_BFu15ll_BFu31ll");
    static STRUCT_IF_C I_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, 1, "I_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, hide_ull(1LL<<30), "I_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu31ll, I_BFu15ll_BFu31ll)
//============================================================================


struct  I_BFu15ll_BFu32i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 I_BFu15ll_BFu32i) C1{ Fi FL:15 Fi:32}



static void Test_I_BFu15ll_BFu32i()
{
  {
    init_simple_test("I_BFu15ll_BFu32i");
    static STRUCT_IF_C I_BFu15ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "I_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "I_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu32i, I_BFu15ll_BFu32i)
//============================================================================


struct  I_BFu15ll_BFu32ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 I_BFu15ll_BFu32ll) C1{ Fi FL:15 FL:32}



static void Test_I_BFu15ll_BFu32ll()
{
  {
    init_simple_test("I_BFu15ll_BFu32ll");
    static STRUCT_IF_C I_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, 1, "I_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, hide_ull(1LL<<31), "I_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu32ll, I_BFu15ll_BFu32ll)
//============================================================================


struct  I_BFu15ll_BFu33  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 I_BFu15ll_BFu33) C1{ Fi FL:15 FL:33}



static void Test_I_BFu15ll_BFu33()
{
  {
    init_simple_test("I_BFu15ll_BFu33");
    static STRUCT_IF_C I_BFu15ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, 1, "I_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, hide_ull(1LL<<32), "I_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu33, I_BFu15ll_BFu33)
//============================================================================


struct  I_BFu15ll_BFu7c  {
  int v1;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 I_BFu15ll_BFu7c) C1{ Fi FL:15 Fc:7}



static void Test_I_BFu15ll_BFu7c()
{
  {
    init_simple_test("I_BFu15ll_BFu7c");
    static STRUCT_IF_C I_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "I_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "I_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu7c, I_BFu15ll_BFu7c)
//============================================================================


struct  I_BFu15ll_BFu7i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 I_BFu15ll_BFu7i) C1{ Fi FL:15 Fi:7}



static void Test_I_BFu15ll_BFu7i()
{
  {
    init_simple_test("I_BFu15ll_BFu7i");
    static STRUCT_IF_C I_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "I_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "I_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu7i, I_BFu15ll_BFu7i)
//============================================================================


struct  I_BFu15ll_BFu7ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 I_BFu15ll_BFu7ll) C1{ Fi FL:15 FL:7}



static void Test_I_BFu15ll_BFu7ll()
{
  {
    init_simple_test("I_BFu15ll_BFu7ll");
    static STRUCT_IF_C I_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "I_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "I_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu7ll, I_BFu15ll_BFu7ll)
//============================================================================


struct  I_BFu15ll_BFu7s  {
  int v1;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 I_BFu15ll_BFu7s) C1{ Fi FL:15 Fs:7}



static void Test_I_BFu15ll_BFu7s()
{
  {
    init_simple_test("I_BFu15ll_BFu7s");
    static STRUCT_IF_C I_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "I_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "I_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu7s, I_BFu15ll_BFu7s)
//============================================================================


struct  I_BFu15ll_BFu8c  {
  int v1;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 I_BFu15ll_BFu8c) C1{ Fi FL:15 Fc:8}



static void Test_I_BFu15ll_BFu8c()
{
  {
    init_simple_test("I_BFu15ll_BFu8c");
    static STRUCT_IF_C I_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "I_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "I_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu8c, I_BFu15ll_BFu8c)
//============================================================================


struct  I_BFu15ll_BFu8i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 I_BFu15ll_BFu8i) C1{ Fi FL:15 Fi:8}



static void Test_I_BFu15ll_BFu8i()
{
  {
    init_simple_test("I_BFu15ll_BFu8i");
    static STRUCT_IF_C I_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "I_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "I_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu8i, I_BFu15ll_BFu8i)
//============================================================================


struct  I_BFu15ll_BFu8ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 I_BFu15ll_BFu8ll) C1{ Fi FL:15 FL:8}



static void Test_I_BFu15ll_BFu8ll()
{
  {
    init_simple_test("I_BFu15ll_BFu8ll");
    static STRUCT_IF_C I_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "I_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "I_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu8ll, I_BFu15ll_BFu8ll)
//============================================================================


struct  I_BFu15ll_BFu8s  {
  int v1;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 I_BFu15ll_BFu8s) C1{ Fi FL:15 Fs:8}



static void Test_I_BFu15ll_BFu8s()
{
  {
    init_simple_test("I_BFu15ll_BFu8s");
    static STRUCT_IF_C I_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "I_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "I_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu8s, I_BFu15ll_BFu8s)
//============================================================================


struct  I_BFu15ll_BFu9i  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 I_BFu15ll_BFu9i) C1{ Fi FL:15 Fi:9}



static void Test_I_BFu15ll_BFu9i()
{
  {
    init_simple_test("I_BFu15ll_BFu9i");
    static STRUCT_IF_C I_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "I_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "I_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu9i, I_BFu15ll_BFu9i)
//============================================================================


struct  I_BFu15ll_BFu9ll  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 I_BFu15ll_BFu9ll) C1{ Fi FL:15 FL:9}



static void Test_I_BFu15ll_BFu9ll()
{
  {
    init_simple_test("I_BFu15ll_BFu9ll");
    static STRUCT_IF_C I_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "I_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "I_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu9ll, I_BFu15ll_BFu9ll)
//============================================================================


struct  I_BFu15ll_BFu9s  {
  int v1;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 I_BFu15ll_BFu9s) C1{ Fi FL:15 Fs:9}



static void Test_I_BFu15ll_BFu9s()
{
  {
    init_simple_test("I_BFu15ll_BFu9s");
    static STRUCT_IF_C I_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "I_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "I_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_BFu9s, I_BFu15ll_BFu9s)
//============================================================================


struct  I_BFu15ll_C  {
  int v1;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 I_BFu15ll_C) C1{ Fi FL:15 Fc}



static void Test_I_BFu15ll_C()
{
  {
    init_simple_test("I_BFu15ll_C");
    static STRUCT_IF_C I_BFu15ll_C lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_C");
    check_field_offset(lv, v3, 6, "I_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_C, I_BFu15ll_C)
//============================================================================


struct  I_BFu15ll_D  {
  int v1;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 I_BFu15ll_D) C1{ Fi FL:15 FL}



static void Test_I_BFu15ll_D()
{
  {
    init_simple_test("I_BFu15ll_D");
    static STRUCT_IF_C I_BFu15ll_D lv;
    check2(sizeof(lv), 16, "sizeof(I_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_D");
    check_field_offset(lv, v3, 8, "I_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_D, I_BFu15ll_D)
//============================================================================


struct  I_BFu15ll_F  {
  int v1;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 I_BFu15ll_F) C1{ Fi FL:15 Fi}



static void Test_I_BFu15ll_F()
{
  {
    init_simple_test("I_BFu15ll_F");
    static STRUCT_IF_C I_BFu15ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_F");
    check_field_offset(lv, v3, 8, "I_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_F, I_BFu15ll_F)
//============================================================================


struct  I_BFu15ll_I  {
  int v1;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 I_BFu15ll_I) C1{ Fi FL:15 Fi}



static void Test_I_BFu15ll_I()
{
  {
    init_simple_test("I_BFu15ll_I");
    static STRUCT_IF_C I_BFu15ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_I");
    check_field_offset(lv, v3, 8, "I_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_I, I_BFu15ll_I)
//============================================================================


struct  I_BFu15ll_Ip  {
  int v1;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 I_BFu15ll_Ip) C1{ Fi FL:15 Fp}



static void Test_I_BFu15ll_Ip()
{
  {
    init_simple_test("I_BFu15ll_Ip");
    static STRUCT_IF_C I_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_Ip");
    check_field_offset(lv, v3, 8, "I_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_Ip, I_BFu15ll_Ip)
//============================================================================


struct  I_BFu15ll_L  {
  int v1;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 I_BFu15ll_L) C1{ Fi FL:15 FL}



static void Test_I_BFu15ll_L()
{
  {
    init_simple_test("I_BFu15ll_L");
    static STRUCT_IF_C I_BFu15ll_L lv;
    check2(sizeof(lv), 16, "sizeof(I_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_L");
    check_field_offset(lv, v3, 8, "I_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_L, I_BFu15ll_L)
//============================================================================


struct  I_BFu15ll_S  {
  int v1;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 I_BFu15ll_S) C1{ Fi FL:15 Fs}



static void Test_I_BFu15ll_S()
{
  {
    init_simple_test("I_BFu15ll_S");
    static STRUCT_IF_C I_BFu15ll_S lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_S");
    check_field_offset(lv, v3, 6, "I_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_S, I_BFu15ll_S)
//============================================================================


struct  I_BFu15ll_Uc  {
  int v1;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 I_BFu15ll_Uc) C1{ Fi FL:15 Fc}



static void Test_I_BFu15ll_Uc()
{
  {
    init_simple_test("I_BFu15ll_Uc");
    static STRUCT_IF_C I_BFu15ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_Uc");
    check_field_offset(lv, v3, 6, "I_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_Uc, I_BFu15ll_Uc)
//============================================================================


struct  I_BFu15ll_Ui  {
  int v1;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 I_BFu15ll_Ui) C1{ Fi FL:15 Fi}



static void Test_I_BFu15ll_Ui()
{
  {
    init_simple_test("I_BFu15ll_Ui");
    static STRUCT_IF_C I_BFu15ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_Ui");
    check_field_offset(lv, v3, 8, "I_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_Ui, I_BFu15ll_Ui)
//============================================================================


struct  I_BFu15ll_Ul  {
  int v1;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 I_BFu15ll_Ul) C1{ Fi FL:15 FL}



static void Test_I_BFu15ll_Ul()
{
  {
    init_simple_test("I_BFu15ll_Ul");
    static STRUCT_IF_C I_BFu15ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(I_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_Ul");
    check_field_offset(lv, v3, 8, "I_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_Ul, I_BFu15ll_Ul)
//============================================================================


struct  I_BFu15ll_Us  {
  int v1;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 I_BFu15ll_Us) C1{ Fi FL:15 Fs}



static void Test_I_BFu15ll_Us()
{
  {
    init_simple_test("I_BFu15ll_Us");
    static STRUCT_IF_C I_BFu15ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_Us");
    check_field_offset(lv, v3, 6, "I_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_Us, I_BFu15ll_Us)
//============================================================================


struct  I_BFu15ll_Vp  {
  int v1;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 I_BFu15ll_Vp) C1{ Fi FL:15 Fp}



static void Test_I_BFu15ll_Vp()
{
  {
    init_simple_test("I_BFu15ll_Vp");
    static STRUCT_IF_C I_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(I_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "I_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15ll_Vp");
    check_field_offset(lv, v3, 8, "I_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15ll_Vp, I_BFu15ll_Vp)
//============================================================================


struct  I_BFu15s  {
  int v1;
  unsigned short v2:15;
};
//SIG(1 I_BFu15s) C1{ Fi Fs:15}



static void Test_I_BFu15s()
{
  {
    init_simple_test("I_BFu15s");
    static STRUCT_IF_C I_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s)");
    check_field_offset(lv, v1, 0, "I_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s, I_BFu15s)
//============================================================================


struct  I_BFu15s_BFu15i  {
  int v1;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 I_BFu15s_BFu15i) C1{ Fi Fs:15 Fi:15}



static void Test_I_BFu15s_BFu15i()
{
  {
    init_simple_test("I_BFu15s_BFu15i");
    static STRUCT_IF_C I_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "I_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "I_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu15i, I_BFu15s_BFu15i)
//============================================================================


struct  I_BFu15s_BFu15ll  {
  int v1;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 I_BFu15s_BFu15ll) C1{ Fi Fs:15 FL:15}



static void Test_I_BFu15s_BFu15ll()
{
  {
    init_simple_test("I_BFu15s_BFu15ll");
    static STRUCT_IF_C I_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "I_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "I_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu15ll, I_BFu15s_BFu15ll)
//============================================================================


struct  I_BFu15s_BFu15s  {
  int v1;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 I_BFu15s_BFu15s) C1{ Fi Fs:15 Fs:15}



static void Test_I_BFu15s_BFu15s()
{
  {
    init_simple_test("I_BFu15s_BFu15s");
    static STRUCT_IF_C I_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "I_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu15s, I_BFu15s_BFu15s)
//============================================================================


struct  I_BFu15s_BFu16i  {
  int v1;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 I_BFu15s_BFu16i) C1{ Fi Fs:15 Fi:16}



static void Test_I_BFu15s_BFu16i()
{
  {
    init_simple_test("I_BFu15s_BFu16i");
    static STRUCT_IF_C I_BFu15s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "I_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "I_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu16i, I_BFu15s_BFu16i)
//============================================================================


struct  I_BFu15s_BFu16ll  {
  int v1;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 I_BFu15s_BFu16ll) C1{ Fi Fs:15 FL:16}



static void Test_I_BFu15s_BFu16ll()
{
  {
    init_simple_test("I_BFu15s_BFu16ll");
    static STRUCT_IF_C I_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "I_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "I_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu16ll, I_BFu15s_BFu16ll)
//============================================================================


struct  I_BFu15s_BFu16s  {
  int v1;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 I_BFu15s_BFu16s) C1{ Fi Fs:15 Fs:16}



static void Test_I_BFu15s_BFu16s()
{
  {
    init_simple_test("I_BFu15s_BFu16s");
    static STRUCT_IF_C I_BFu15s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "I_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "I_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu16s, I_BFu15s_BFu16s)
//============================================================================


struct  I_BFu15s_BFu17i  {
  int v1;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 I_BFu15s_BFu17i) C1{ Fi Fs:15 Fi:17}



static void Test_I_BFu15s_BFu17i()
{
  {
    init_simple_test("I_BFu15s_BFu17i");
    static STRUCT_IF_C I_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "I_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "I_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu17i, I_BFu15s_BFu17i)
//============================================================================


struct  I_BFu15s_BFu17ll  {
  int v1;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 I_BFu15s_BFu17ll) C1{ Fi Fs:15 FL:17}



static void Test_I_BFu15s_BFu17ll()
{
  {
    init_simple_test("I_BFu15s_BFu17ll");
    static STRUCT_IF_C I_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "I_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "I_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu17ll, I_BFu15s_BFu17ll)
//============================================================================


struct  I_BFu15s_BFu1c  {
  int v1;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 I_BFu15s_BFu1c) C1{ Fi Fs:15 Fc:1}



static void Test_I_BFu15s_BFu1c()
{
  {
    init_simple_test("I_BFu15s_BFu1c");
    static STRUCT_IF_C I_BFu15s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu1c, I_BFu15s_BFu1c)
//============================================================================


struct  I_BFu15s_BFu1i  {
  int v1;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 I_BFu15s_BFu1i) C1{ Fi Fs:15 Fi:1}



static void Test_I_BFu15s_BFu1i()
{
  {
    init_simple_test("I_BFu15s_BFu1i");
    static STRUCT_IF_C I_BFu15s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu1i, I_BFu15s_BFu1i)
//============================================================================


struct  I_BFu15s_BFu1ll  {
  int v1;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 I_BFu15s_BFu1ll) C1{ Fi Fs:15 FL:1}



static void Test_I_BFu15s_BFu1ll()
{
  {
    init_simple_test("I_BFu15s_BFu1ll");
    static STRUCT_IF_C I_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(I_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu1ll, I_BFu15s_BFu1ll)
//============================================================================


struct  I_BFu15s_BFu1s  {
  int v1;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 I_BFu15s_BFu1s) C1{ Fi Fs:15 Fs:1}



static void Test_I_BFu15s_BFu1s()
{
  {
    init_simple_test("I_BFu15s_BFu1s");
    static STRUCT_IF_C I_BFu15s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(I_BFu15s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "I_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_I_BFu15s_BFu1s, I_BFu15s_BFu1s)
//============================================================================


struct  I_BFu15s_BFu31i  {
  int v1;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 I_BFu15s_BFu31i) C1{ Fi Fs:15 Fi:31}



static void Test_I_BFu15s_BFu31i()
{
  {
    init_simple_test("I_BFu15s_BFu31i");
    static STRUCT_IF_C I_BFu15s_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(I_BFu15s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(I_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "I_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "I_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "I_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "I_BFu15s_BFu31i");
    set