// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  C_BFu33_C  {
  char v1;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 C_BFu33_C) C1{ Fc FL:33 Fc}



static void Test_C_BFu33_C()
{
  {
    init_simple_test("C_BFu33_C");
    static STRUCT_IF_C C_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_C)");
    check_field_offset(lv, v1, 0, "C_BFu33_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_C");
    check_field_offset(lv, v3, 6, "C_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_C, C_BFu33_C)
//============================================================================


struct  C_BFu33_D  {
  char v1;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 C_BFu33_D) C1{ Fc FL:33 FL}



static void Test_C_BFu33_D()
{
  {
    init_simple_test("C_BFu33_D");
    static STRUCT_IF_C C_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(C_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_D)");
    check_field_offset(lv, v1, 0, "C_BFu33_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_D");
    check_field_offset(lv, v3, 8, "C_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_D, C_BFu33_D)
//============================================================================


struct  C_BFu33_F  {
  char v1;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 C_BFu33_F) C1{ Fc FL:33 Fi}



static void Test_C_BFu33_F()
{
  {
    init_simple_test("C_BFu33_F");
    static STRUCT_IF_C C_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_F)");
    check_field_offset(lv, v1, 0, "C_BFu33_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_F");
    check_field_offset(lv, v3, 8, "C_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_F, C_BFu33_F)
//============================================================================


struct  C_BFu33_I  {
  char v1;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 C_BFu33_I) C1{ Fc FL:33 Fi}



static void Test_C_BFu33_I()
{
  {
    init_simple_test("C_BFu33_I");
    static STRUCT_IF_C C_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_I)");
    check_field_offset(lv, v1, 0, "C_BFu33_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_I");
    check_field_offset(lv, v3, 8, "C_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_I, C_BFu33_I)
//============================================================================


struct  C_BFu33_Ip  {
  char v1;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 C_BFu33_Ip) C1{ Fc FL:33 Fp}



static void Test_C_BFu33_Ip()
{
  {
    init_simple_test("C_BFu33_Ip");
    static STRUCT_IF_C C_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Ip");
    check_field_offset(lv, v3, 8, "C_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Ip, C_BFu33_Ip)
//============================================================================


struct  C_BFu33_L  {
  char v1;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 C_BFu33_L) C1{ Fc FL:33 FL}



static void Test_C_BFu33_L()
{
  {
    init_simple_test("C_BFu33_L");
    static STRUCT_IF_C C_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(C_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_L)");
    check_field_offset(lv, v1, 0, "C_BFu33_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_L");
    check_field_offset(lv, v3, 8, "C_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_L, C_BFu33_L)
//============================================================================


struct  C_BFu33_S  {
  char v1;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 C_BFu33_S) C1{ Fc FL:33 Fs}



static void Test_C_BFu33_S()
{
  {
    init_simple_test("C_BFu33_S");
    static STRUCT_IF_C C_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_S)");
    check_field_offset(lv, v1, 0, "C_BFu33_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_S");
    check_field_offset(lv, v3, 6, "C_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_S, C_BFu33_S)
//============================================================================


struct  C_BFu33_Uc  {
  char v1;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 C_BFu33_Uc) C1{ Fc FL:33 Fc}



static void Test_C_BFu33_Uc()
{
  {
    init_simple_test("C_BFu33_Uc");
    static STRUCT_IF_C C_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Uc");
    check_field_offset(lv, v3, 6, "C_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Uc, C_BFu33_Uc)
//============================================================================


struct  C_BFu33_Ui  {
  char v1;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 C_BFu33_Ui) C1{ Fc FL:33 Fi}



static void Test_C_BFu33_Ui()
{
  {
    init_simple_test("C_BFu33_Ui");
    static STRUCT_IF_C C_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Ui");
    check_field_offset(lv, v3, 8, "C_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Ui, C_BFu33_Ui)
//============================================================================


struct  C_BFu33_Ul  {
  char v1;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 C_BFu33_Ul) C1{ Fc FL:33 FL}



static void Test_C_BFu33_Ul()
{
  {
    init_simple_test("C_BFu33_Ul");
    static STRUCT_IF_C C_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(C_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Ul");
    check_field_offset(lv, v3, 8, "C_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Ul, C_BFu33_Ul)
//============================================================================


struct  C_BFu33_Us  {
  char v1;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 C_BFu33_Us) C1{ Fc FL:33 Fs}



static void Test_C_BFu33_Us()
{
  {
    init_simple_test("C_BFu33_Us");
    static STRUCT_IF_C C_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_Us)");
    check_field_offset(lv, v1, 0, "C_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Us");
    check_field_offset(lv, v3, 6, "C_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Us, C_BFu33_Us)
//============================================================================


struct  C_BFu33_Vp  {
  char v1;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 C_BFu33_Vp) C1{ Fc FL:33 Fp}



static void Test_C_BFu33_Vp()
{
  {
    init_simple_test("C_BFu33_Vp");
    static STRUCT_IF_C C_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Vp");
    check_field_offset(lv, v3, 8, "C_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Vp, C_BFu33_Vp)
//============================================================================


struct  C_BFu7c  {
  char v1;
  unsigned char v2:7;
};
//SIG(1 C_BFu7c) C1{ Fc Fc:7}



static void Test_C_BFu7c()
{
  {
    init_simple_test("C_BFu7c");
    static STRUCT_IF_C C_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c, C_BFu7c)
//============================================================================


struct  C_BFu7c_BFu15i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 C_BFu7c_BFu15i) C1{ Fc Fc:7 Fi:15}



static void Test_C_BFu7c_BFu15i()
{
  {
    init_simple_test("C_BFu7c_BFu15i");
    static STRUCT_IF_C C_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu15i, C_BFu7c_BFu15i)
//============================================================================


struct  C_BFu7c_BFu15ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 C_BFu7c_BFu15ll) C1{ Fc Fc:7 FL:15}



static void Test_C_BFu7c_BFu15ll()
{
  {
    init_simple_test("C_BFu7c_BFu15ll");
    static STRUCT_IF_C C_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu15ll, C_BFu7c_BFu15ll)
//============================================================================


struct  C_BFu7c_BFu15s  {
  char v1;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 C_BFu7c_BFu15s) C1{ Fc Fc:7 Fs:15}



static void Test_C_BFu7c_BFu15s()
{
  {
    init_simple_test("C_BFu7c_BFu15s");
    static STRUCT_IF_C C_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu15s, C_BFu7c_BFu15s)
//============================================================================


struct  C_BFu7c_BFu16i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 C_BFu7c_BFu16i) C1{ Fc Fc:7 Fi:16}



static void Test_C_BFu7c_BFu16i()
{
  {
    init_simple_test("C_BFu7c_BFu16i");
    static STRUCT_IF_C C_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu16i, C_BFu7c_BFu16i)
//============================================================================


struct  C_BFu7c_BFu16ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 C_BFu7c_BFu16ll) C1{ Fc Fc:7 FL:16}



static void Test_C_BFu7c_BFu16ll()
{
  {
    init_simple_test("C_BFu7c_BFu16ll");
    static STRUCT_IF_C C_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu16ll, C_BFu7c_BFu16ll)
//============================================================================


struct  C_BFu7c_BFu16s  {
  char v1;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 C_BFu7c_BFu16s) C1{ Fc Fc:7 Fs:16}



static void Test_C_BFu7c_BFu16s()
{
  {
    init_simple_test("C_BFu7c_BFu16s");
    static STRUCT_IF_C C_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu16s, C_BFu7c_BFu16s)
//============================================================================


struct  C_BFu7c_BFu17i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 C_BFu7c_BFu17i) C1{ Fc Fc:7 Fi:17}



static void Test_C_BFu7c_BFu17i()
{
  {
    init_simple_test("C_BFu7c_BFu17i");
    static STRUCT_IF_C C_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu17i, C_BFu7c_BFu17i)
//============================================================================


struct  C_BFu7c_BFu17ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 C_BFu7c_BFu17ll) C1{ Fc Fc:7 FL:17}



static void Test_C_BFu7c_BFu17ll()
{
  {
    init_simple_test("C_BFu7c_BFu17ll");
    static STRUCT_IF_C C_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu17ll, C_BFu7c_BFu17ll)
//============================================================================


struct  C_BFu7c_BFu1c  {
  char v1;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 C_BFu7c_BFu1c) C1{ Fc Fc:7 Fc:1}



static void Test_C_BFu7c_BFu1c()
{
  {
    init_simple_test("C_BFu7c_BFu1c");
    static STRUCT_IF_C C_BFu7c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu1c, C_BFu7c_BFu1c)
//============================================================================


struct  C_BFu7c_BFu1i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 C_BFu7c_BFu1i) C1{ Fc Fc:7 Fi:1}



static void Test_C_BFu7c_BFu1i()
{
  {
    init_simple_test("C_BFu7c_BFu1i");
    static STRUCT_IF_C C_BFu7c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu1i, C_BFu7c_BFu1i)
//============================================================================


struct  C_BFu7c_BFu1ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 C_BFu7c_BFu1ll) C1{ Fc Fc:7 FL:1}



static void Test_C_BFu7c_BFu1ll()
{
  {
    init_simple_test("C_BFu7c_BFu1ll");
    static STRUCT_IF_C C_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu1ll, C_BFu7c_BFu1ll)
//============================================================================


struct  C_BFu7c_BFu1s  {
  char v1;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 C_BFu7c_BFu1s) C1{ Fc Fc:7 Fs:1}



static void Test_C_BFu7c_BFu1s()
{
  {
    init_simple_test("C_BFu7c_BFu1s");
    static STRUCT_IF_C C_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu1s, C_BFu7c_BFu1s)
//============================================================================


struct  C_BFu7c_BFu31i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 C_BFu7c_BFu31i) C1{ Fc Fc:7 Fi:31}



static void Test_C_BFu7c_BFu31i()
{
  {
    init_simple_test("C_BFu7c_BFu31i");
    static STRUCT_IF_C C_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu31i, C_BFu7c_BFu31i)
//============================================================================


struct  C_BFu7c_BFu31ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 C_BFu7c_BFu31ll) C1{ Fc Fc:7 FL:31}



static void Test_C_BFu7c_BFu31ll()
{
  {
    init_simple_test("C_BFu7c_BFu31ll");
    static STRUCT_IF_C C_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu31ll, C_BFu7c_BFu31ll)
//============================================================================


struct  C_BFu7c_BFu32i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 C_BFu7c_BFu32i) C1{ Fc Fc:7 Fi:32}



static void Test_C_BFu7c_BFu32i()
{
  {
    init_simple_test("C_BFu7c_BFu32i");
    static STRUCT_IF_C C_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu32i, C_BFu7c_BFu32i)
//============================================================================


struct  C_BFu7c_BFu32ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 C_BFu7c_BFu32ll) C1{ Fc Fc:7 FL:32}



static void Test_C_BFu7c_BFu32ll()
{
  {
    init_simple_test("C_BFu7c_BFu32ll");
    static STRUCT_IF_C C_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu32ll, C_BFu7c_BFu32ll)
//============================================================================


struct  C_BFu7c_BFu33  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 C_BFu7c_BFu33) C1{ Fc Fc:7 FL:33}



static void Test_C_BFu7c_BFu33()
{
  {
    init_simple_test("C_BFu7c_BFu33");
    static STRUCT_IF_C C_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "C_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "C_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu33, C_BFu7c_BFu33)
//============================================================================


struct  C_BFu7c_BFu7c  {
  char v1;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 C_BFu7c_BFu7c) C1{ Fc Fc:7 Fc:7}



static void Test_C_BFu7c_BFu7c()
{
  {
    init_simple_test("C_BFu7c_BFu7c");
    static STRUCT_IF_C C_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu7c, C_BFu7c_BFu7c)
//============================================================================


struct  C_BFu7c_BFu7i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 C_BFu7c_BFu7i) C1{ Fc Fc:7 Fi:7}



static void Test_C_BFu7c_BFu7i()
{
  {
    init_simple_test("C_BFu7c_BFu7i");
    static STRUCT_IF_C C_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu7i, C_BFu7c_BFu7i)
//============================================================================


struct  C_BFu7c_BFu7ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 C_BFu7c_BFu7ll) C1{ Fc Fc:7 FL:7}



static void Test_C_BFu7c_BFu7ll()
{
  {
    init_simple_test("C_BFu7c_BFu7ll");
    static STRUCT_IF_C C_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu7ll, C_BFu7c_BFu7ll)
//============================================================================


struct  C_BFu7c_BFu7s  {
  char v1;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 C_BFu7c_BFu7s) C1{ Fc Fc:7 Fs:7}



static void Test_C_BFu7c_BFu7s()
{
  {
    init_simple_test("C_BFu7c_BFu7s");
    static STRUCT_IF_C C_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu7s, C_BFu7c_BFu7s)
//============================================================================


struct  C_BFu7c_BFu8c  {
  char v1;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 C_BFu7c_BFu8c) C1{ Fc Fc:7 Fc:8}



static void Test_C_BFu7c_BFu8c()
{
  {
    init_simple_test("C_BFu7c_BFu8c");
    static STRUCT_IF_C C_BFu7c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu8c, C_BFu7c_BFu8c)
//============================================================================


struct  C_BFu7c_BFu8i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 C_BFu7c_BFu8i) C1{ Fc Fc:7 Fi:8}



static void Test_C_BFu7c_BFu8i()
{
  {
    init_simple_test("C_BFu7c_BFu8i");
    static STRUCT_IF_C C_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu8i, C_BFu7c_BFu8i)
//============================================================================


struct  C_BFu7c_BFu8ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 C_BFu7c_BFu8ll) C1{ Fc Fc:7 FL:8}



static void Test_C_BFu7c_BFu8ll()
{
  {
    init_simple_test("C_BFu7c_BFu8ll");
    static STRUCT_IF_C C_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu8ll, C_BFu7c_BFu8ll)
//============================================================================


struct  C_BFu7c_BFu8s  {
  char v1;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 C_BFu7c_BFu8s) C1{ Fc Fc:7 Fs:8}



static void Test_C_BFu7c_BFu8s()
{
  {
    init_simple_test("C_BFu7c_BFu8s");
    static STRUCT_IF_C C_BFu7c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu8s, C_BFu7c_BFu8s)
//============================================================================


struct  C_BFu7c_BFu9i  {
  char v1;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 C_BFu7c_BFu9i) C1{ Fc Fc:7 Fi:9}



static void Test_C_BFu7c_BFu9i()
{
  {
    init_simple_test("C_BFu7c_BFu9i");
    static STRUCT_IF_C C_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu9i, C_BFu7c_BFu9i)
//============================================================================


struct  C_BFu7c_BFu9ll  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 C_BFu7c_BFu9ll) C1{ Fc Fc:7 FL:9}



static void Test_C_BFu7c_BFu9ll()
{
  {
    init_simple_test("C_BFu7c_BFu9ll");
    static STRUCT_IF_C C_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu9ll, C_BFu7c_BFu9ll)
//============================================================================


struct  C_BFu7c_BFu9s  {
  char v1;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 C_BFu7c_BFu9s) C1{ Fc Fc:7 Fs:9}



static void Test_C_BFu7c_BFu9s()
{
  {
    init_simple_test("C_BFu7c_BFu9s");
    static STRUCT_IF_C C_BFu7c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu9s, C_BFu7c_BFu9s)
//============================================================================


struct  C_BFu7c_C  {
  char v1;
  unsigned char v2:7;
  char v3;
};
//SIG(1 C_BFu7c_C) C1{ Fc Fc:7 Fc}



static void Test_C_BFu7c_C()
{
  {
    init_simple_test("C_BFu7c_C");
    static STRUCT_IF_C C_BFu7c_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_C)");
    check_field_offset(lv, v1, 0, "C_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_C");
    check_field_offset(lv, v3, 2, "C_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_C, C_BFu7c_C)
//============================================================================


struct  C_BFu7c_D  {
  char v1;
  unsigned char v2:7;
  double v3;
};
//SIG(1 C_BFu7c_D) C1{ Fc Fc:7 FL}



static void Test_C_BFu7c_D()
{
  {
    init_simple_test("C_BFu7c_D");
    static STRUCT_IF_C C_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_D)");
    check_field_offset(lv, v1, 0, "C_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_D, C_BFu7c_D)
//============================================================================


struct  C_BFu7c_F  {
  char v1;
  unsigned char v2:7;
  float v3;
};
//SIG(1 C_BFu7c_F) C1{ Fc Fc:7 Fi}



static void Test_C_BFu7c_F()
{
  {
    init_simple_test("C_BFu7c_F");
    static STRUCT_IF_C C_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_F)");
    check_field_offset(lv, v1, 0, "C_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_F");
    check_field_offset(lv, v3, 4, "C_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_F, C_BFu7c_F)
//============================================================================


struct  C_BFu7c_I  {
  char v1;
  unsigned char v2:7;
  int v3;
};
//SIG(1 C_BFu7c_I) C1{ Fc Fc:7 Fi}



static void Test_C_BFu7c_I()
{
  {
    init_simple_test("C_BFu7c_I");
    static STRUCT_IF_C C_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_I)");
    check_field_offset(lv, v1, 0, "C_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_I");
    check_field_offset(lv, v3, 4, "C_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_I, C_BFu7c_I)
//============================================================================


struct  C_BFu7c_Ip  {
  char v1;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 C_BFu7c_Ip) C1{ Fc Fc:7 Fp}



static void Test_C_BFu7c_Ip()
{
  {
    init_simple_test("C_BFu7c_Ip");
    static STRUCT_IF_C C_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Ip, C_BFu7c_Ip)
//============================================================================


struct  C_BFu7c_L  {
  char v1;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 C_BFu7c_L) C1{ Fc Fc:7 FL}



static void Test_C_BFu7c_L()
{
  {
    init_simple_test("C_BFu7c_L");
    static STRUCT_IF_C C_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_L)");
    check_field_offset(lv, v1, 0, "C_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_L, C_BFu7c_L)
//============================================================================


struct  C_BFu7c_S  {
  char v1;
  unsigned char v2:7;
  short v3;
};
//SIG(1 C_BFu7c_S) C1{ Fc Fc:7 Fs}



static void Test_C_BFu7c_S()
{
  {
    init_simple_test("C_BFu7c_S");
    static STRUCT_IF_C C_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7c_S)");
    check_field_offset(lv, v1, 0, "C_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_S");
    check_field_offset(lv, v3, 2, "C_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_S, C_BFu7c_S)
//============================================================================


struct  C_BFu7c_Uc  {
  char v1;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 C_BFu7c_Uc) C1{ Fc Fc:7 Fc}



static void Test_C_BFu7c_Uc()
{
  {
    init_simple_test("C_BFu7c_Uc");
    static STRUCT_IF_C C_BFu7c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "C_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Uc, C_BFu7c_Uc)
//============================================================================


struct  C_BFu7c_Ui  {
  char v1;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 C_BFu7c_Ui) C1{ Fc Fc:7 Fi}



static void Test_C_BFu7c_Ui()
{
  {
    init_simple_test("C_BFu7c_Ui");
    static STRUCT_IF_C C_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Ui");
    check_field_offset(lv, v3, 4, "C_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Ui, C_BFu7c_Ui)
//============================================================================


struct  C_BFu7c_Ul  {
  char v1;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 C_BFu7c_Ul) C1{ Fc Fc:7 FL}



static void Test_C_BFu7c_Ul()
{
  {
    init_simple_test("C_BFu7c_Ul");
    static STRUCT_IF_C C_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Ul, C_BFu7c_Ul)
//============================================================================


struct  C_BFu7c_Us  {
  char v1;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 C_BFu7c_Us) C1{ Fc Fc:7 Fs}



static void Test_C_BFu7c_Us()
{
  {
    init_simple_test("C_BFu7c_Us");
    static STRUCT_IF_C C_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Us");
    check_field_offset(lv, v3, 2, "C_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Us, C_BFu7c_Us)
//============================================================================


struct  C_BFu7c_Vp  {
  char v1;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 C_BFu7c_Vp) C1{ Fc Fc:7 Fp}



static void Test_C_BFu7c_Vp()
{
  {
    init_simple_test("C_BFu7c_Vp");
    static STRUCT_IF_C C_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Vp, C_BFu7c_Vp)
//============================================================================


struct  C_BFu7i  {
  char v1;
  unsigned int v2:7;
};
//SIG(1 C_BFu7i) C1{ Fc Fi:7}



static void Test_C_BFu7i()
{
  {
    init_simple_test("C_BFu7i");
    static STRUCT_IF_C C_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i, C_BFu7i)
//============================================================================


struct  C_BFu7i_BFu15i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 C_BFu7i_BFu15i) C1{ Fc Fi:7 Fi:15}



static void Test_C_BFu7i_BFu15i()
{
  {
    init_simple_test("C_BFu7i_BFu15i");
    static STRUCT_IF_C C_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu15i, C_BFu7i_BFu15i)
//============================================================================


struct  C_BFu7i_BFu15ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 C_BFu7i_BFu15ll) C1{ Fc Fi:7 FL:15}



static void Test_C_BFu7i_BFu15ll()
{
  {
    init_simple_test("C_BFu7i_BFu15ll");
    static STRUCT_IF_C C_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu15ll, C_BFu7i_BFu15ll)
//============================================================================


struct  C_BFu7i_BFu15s  {
  char v1;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 C_BFu7i_BFu15s) C1{ Fc Fi:7 Fs:15}



static void Test_C_BFu7i_BFu15s()
{
  {
    init_simple_test("C_BFu7i_BFu15s");
    static STRUCT_IF_C C_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu15s, C_BFu7i_BFu15s)
//============================================================================


struct  C_BFu7i_BFu16i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 C_BFu7i_BFu16i) C1{ Fc Fi:7 Fi:16}



static void Test_C_BFu7i_BFu16i()
{
  {
    init_simple_test("C_BFu7i_BFu16i");
    static STRUCT_IF_C C_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu16i, C_BFu7i_BFu16i)
//============================================================================


struct  C_BFu7i_BFu16ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 C_BFu7i_BFu16ll) C1{ Fc Fi:7 FL:16}



static void Test_C_BFu7i_BFu16ll()
{
  {
    init_simple_test("C_BFu7i_BFu16ll");
    static STRUCT_IF_C C_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu16ll, C_BFu7i_BFu16ll)
//============================================================================


struct  C_BFu7i_BFu16s  {
  char v1;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 C_BFu7i_BFu16s) C1{ Fc Fi:7 Fs:16}



static void Test_C_BFu7i_BFu16s()
{
  {
    init_simple_test("C_BFu7i_BFu16s");
    static STRUCT_IF_C C_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu16s, C_BFu7i_BFu16s)
//============================================================================


struct  C_BFu7i_BFu17i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 C_BFu7i_BFu17i) C1{ Fc Fi:7 Fi:17}



static void Test_C_BFu7i_BFu17i()
{
  {
    init_simple_test("C_BFu7i_BFu17i");
    static STRUCT_IF_C C_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu17i, C_BFu7i_BFu17i)
//============================================================================


struct  C_BFu7i_BFu17ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 C_BFu7i_BFu17ll) C1{ Fc Fi:7 FL:17}



static void Test_C_BFu7i_BFu17ll()
{
  {
    init_simple_test("C_BFu7i_BFu17ll");
    static STRUCT_IF_C C_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu17ll, C_BFu7i_BFu17ll)
//============================================================================


struct  C_BFu7i_BFu1c  {
  char v1;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 C_BFu7i_BFu1c) C1{ Fc Fi:7 Fc:1}



static void Test_C_BFu7i_BFu1c()
{
  {
    init_simple_test("C_BFu7i_BFu1c");
    static STRUCT_IF_C C_BFu7i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu1c, C_BFu7i_BFu1c)
//============================================================================


struct  C_BFu7i_BFu1i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 C_BFu7i_BFu1i) C1{ Fc Fi:7 Fi:1}



static void Test_C_BFu7i_BFu1i()
{
  {
    init_simple_test("C_BFu7i_BFu1i");
    static STRUCT_IF_C C_BFu7i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu1i, C_BFu7i_BFu1i)
//============================================================================


struct  C_BFu7i_BFu1ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 C_BFu7i_BFu1ll) C1{ Fc Fi:7 FL:1}



static void Test_C_BFu7i_BFu1ll()
{
  {
    init_simple_test("C_BFu7i_BFu1ll");
    static STRUCT_IF_C C_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu1ll, C_BFu7i_BFu1ll)
//============================================================================


struct  C_BFu7i_BFu1s  {
  char v1;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 C_BFu7i_BFu1s) C1{ Fc Fi:7 Fs:1}



static void Test_C_BFu7i_BFu1s()
{
  {
    init_simple_test("C_BFu7i_BFu1s");
    static STRUCT_IF_C C_BFu7i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu1s, C_BFu7i_BFu1s)
//============================================================================


struct  C_BFu7i_BFu31i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 C_BFu7i_BFu31i) C1{ Fc Fi:7 Fi:31}



static void Test_C_BFu7i_BFu31i()
{
  {
    init_simple_test("C_BFu7i_BFu31i");
    static STRUCT_IF_C C_BFu7i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu31i, C_BFu7i_BFu31i)
//============================================================================


struct  C_BFu7i_BFu31ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 C_BFu7i_BFu31ll) C1{ Fc Fi:7 FL:31}



static void Test_C_BFu7i_BFu31ll()
{
  {
    init_simple_test("C_BFu7i_BFu31ll");
    static STRUCT_IF_C C_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu31ll, C_BFu7i_BFu31ll)
//============================================================================


struct  C_BFu7i_BFu32i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 C_BFu7i_BFu32i) C1{ Fc Fi:7 Fi:32}



static void Test_C_BFu7i_BFu32i()
{
  {
    init_simple_test("C_BFu7i_BFu32i");
    static STRUCT_IF_C C_BFu7i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu32i, C_BFu7i_BFu32i)
//============================================================================


struct  C_BFu7i_BFu32ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 C_BFu7i_BFu32ll) C1{ Fc Fi:7 FL:32}



static void Test_C_BFu7i_BFu32ll()
{
  {
    init_simple_test("C_BFu7i_BFu32ll");
    static STRUCT_IF_C C_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu32ll, C_BFu7i_BFu32ll)
//============================================================================


struct  C_BFu7i_BFu33  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 C_BFu7i_BFu33) C1{ Fc Fi:7 FL:33}



static void Test_C_BFu7i_BFu33()
{
  {
    init_simple_test("C_BFu7i_BFu33");
    static STRUCT_IF_C C_BFu7i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "C_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "C_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu33, C_BFu7i_BFu33)
//============================================================================


struct  C_BFu7i_BFu7c  {
  char v1;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 C_BFu7i_BFu7c) C1{ Fc Fi:7 Fc:7}



static void Test_C_BFu7i_BFu7c()
{
  {
    init_simple_test("C_BFu7i_BFu7c");
    static STRUCT_IF_C C_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu7c, C_BFu7i_BFu7c)
//============================================================================


struct  C_BFu7i_BFu7i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 C_BFu7i_BFu7i) C1{ Fc Fi:7 Fi:7}



static void Test_C_BFu7i_BFu7i()
{
  {
    init_simple_test("C_BFu7i_BFu7i");
    static STRUCT_IF_C C_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu7i, C_BFu7i_BFu7i)
//============================================================================


struct  C_BFu7i_BFu7ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 C_BFu7i_BFu7ll) C1{ Fc Fi:7 FL:7}



static void Test_C_BFu7i_BFu7ll()
{
  {
    init_simple_test("C_BFu7i_BFu7ll");
    static STRUCT_IF_C C_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu7ll, C_BFu7i_BFu7ll)
//============================================================================


struct  C_BFu7i_BFu7s  {
  char v1;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 C_BFu7i_BFu7s) C1{ Fc Fi:7 Fs:7}



static void Test_C_BFu7i_BFu7s()
{
  {
    init_simple_test("C_BFu7i_BFu7s");
    static STRUCT_IF_C C_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu7s, C_BFu7i_BFu7s)
//============================================================================


struct  C_BFu7i_BFu8c  {
  char v1;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 C_BFu7i_BFu8c) C1{ Fc Fi:7 Fc:8}



static void Test_C_BFu7i_BFu8c()
{
  {
    init_simple_test("C_BFu7i_BFu8c");
    static STRUCT_IF_C C_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu8c, C_BFu7i_BFu8c)
//============================================================================


struct  C_BFu7i_BFu8i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 C_BFu7i_BFu8i) C1{ Fc Fi:7 Fi:8}



static void Test_C_BFu7i_BFu8i()
{
  {
    init_simple_test("C_BFu7i_BFu8i");
    static STRUCT_IF_C C_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu8i, C_BFu7i_BFu8i)
//============================================================================


struct  C_BFu7i_BFu8ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 C_BFu7i_BFu8ll) C1{ Fc Fi:7 FL:8}



static void Test_C_BFu7i_BFu8ll()
{
  {
    init_simple_test("C_BFu7i_BFu8ll");
    static STRUCT_IF_C C_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu8ll, C_BFu7i_BFu8ll)
//============================================================================


struct  C_BFu7i_BFu8s  {
  char v1;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 C_BFu7i_BFu8s) C1{ Fc Fi:7 Fs:8}



static void Test_C_BFu7i_BFu8s()
{
  {
    init_simple_test("C_BFu7i_BFu8s");
    static STRUCT_IF_C C_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu8s, C_BFu7i_BFu8s)
//============================================================================


struct  C_BFu7i_BFu9i  {
  char v1;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 C_BFu7i_BFu9i) C1{ Fc Fi:7 Fi:9}



static void Test_C_BFu7i_BFu9i()
{
  {
    init_simple_test("C_BFu7i_BFu9i");
    static STRUCT_IF_C C_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu9i, C_BFu7i_BFu9i)
//============================================================================


struct  C_BFu7i_BFu9ll  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 C_BFu7i_BFu9ll) C1{ Fc Fi:7 FL:9}



static void Test_C_BFu7i_BFu9ll()
{
  {
    init_simple_test("C_BFu7i_BFu9ll");
    static STRUCT_IF_C C_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu9ll, C_BFu7i_BFu9ll)
//============================================================================


struct  C_BFu7i_BFu9s  {
  char v1;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 C_BFu7i_BFu9s) C1{ Fc Fi:7 Fs:9}



static void Test_C_BFu7i_BFu9s()
{
  {
    init_simple_test("C_BFu7i_BFu9s");
    static STRUCT_IF_C C_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu9s, C_BFu7i_BFu9s)
//============================================================================


struct  C_BFu7i_C  {
  char v1;
  unsigned int v2:7;
  char v3;
};
//SIG(1 C_BFu7i_C) C1{ Fc Fi:7 Fc}



static void Test_C_BFu7i_C()
{
  {
    init_simple_test("C_BFu7i_C");
    static STRUCT_IF_C C_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_C)");
    check_field_offset(lv, v1, 0, "C_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_C");
    check_field_offset(lv, v3, 2, "C_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_C, C_BFu7i_C)
//============================================================================


struct  C_BFu7i_D  {
  char v1;
  unsigned int v2:7;
  double v3;
};
//SIG(1 C_BFu7i_D) C1{ Fc Fi:7 FL}



static void Test_C_BFu7i_D()
{
  {
    init_simple_test("C_BFu7i_D");
    static STRUCT_IF_C C_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_D)");
    check_field_offset(lv, v1, 0, "C_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_D, C_BFu7i_D)
//============================================================================


struct  C_BFu7i_F  {
  char v1;
  unsigned int v2:7;
  float v3;
};
//SIG(1 C_BFu7i_F) C1{ Fc Fi:7 Fi}



static void Test_C_BFu7i_F()
{
  {
    init_simple_test("C_BFu7i_F");
    static STRUCT_IF_C C_BFu7i_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_F)");
    check_field_offset(lv, v1, 0, "C_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_F");
    check_field_offset(lv, v3, 4, "C_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_F, C_BFu7i_F)
//============================================================================


struct  C_BFu7i_I  {
  char v1;
  unsigned int v2:7;
  int v3;
};
//SIG(1 C_BFu7i_I) C1{ Fc Fi:7 Fi}



static void Test_C_BFu7i_I()
{
  {
    init_simple_test("C_BFu7i_I");
    static STRUCT_IF_C C_BFu7i_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_I)");
    check_field_offset(lv, v1, 0, "C_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_I");
    check_field_offset(lv, v3, 4, "C_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_I, C_BFu7i_I)
//============================================================================


struct  C_BFu7i_Ip  {
  char v1;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 C_BFu7i_Ip) C1{ Fc Fi:7 Fp}



static void Test_C_BFu7i_Ip()
{
  {
    init_simple_test("C_BFu7i_Ip");
    static STRUCT_IF_C C_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Ip, C_BFu7i_Ip)
//============================================================================


struct  C_BFu7i_L  {
  char v1;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 C_BFu7i_L) C1{ Fc Fi:7 FL}



static void Test_C_BFu7i_L()
{
  {
    init_simple_test("C_BFu7i_L");
    static STRUCT_IF_C C_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_L)");
    check_field_offset(lv, v1, 0, "C_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_L, C_BFu7i_L)
//============================================================================


struct  C_BFu7i_S  {
  char v1;
  unsigned int v2:7;
  short v3;
};
//SIG(1 C_BFu7i_S) C1{ Fc Fi:7 Fs}



static void Test_C_BFu7i_S()
{
  {
    init_simple_test("C_BFu7i_S");
    static STRUCT_IF_C C_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_S)");
    check_field_offset(lv, v1, 0, "C_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_S");
    check_field_offset(lv, v3, 2, "C_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_S, C_BFu7i_S)
//============================================================================


struct  C_BFu7i_Uc  {
  char v1;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 C_BFu7i_Uc) C1{ Fc Fi:7 Fc}



static void Test_C_BFu7i_Uc()
{
  {
    init_simple_test("C_BFu7i_Uc");
    static STRUCT_IF_C C_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "C_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Uc, C_BFu7i_Uc)
//============================================================================


struct  C_BFu7i_Ui  {
  char v1;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 C_BFu7i_Ui) C1{ Fc Fi:7 Fi}



static void Test_C_BFu7i_Ui()
{
  {
    init_simple_test("C_BFu7i_Ui");
    static STRUCT_IF_C C_BFu7i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Ui");
    check_field_offset(lv, v3, 4, "C_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Ui, C_BFu7i_Ui)
//============================================================================


struct  C_BFu7i_Ul  {
  char v1;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 C_BFu7i_Ul) C1{ Fc Fi:7 FL}



static void Test_C_BFu7i_Ul()
{
  {
    init_simple_test("C_BFu7i_Ul");
    static STRUCT_IF_C C_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Ul, C_BFu7i_Ul)
//============================================================================


struct  C_BFu7i_Us  {
  char v1;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 C_BFu7i_Us) C1{ Fc Fi:7 Fs}



static void Test_C_BFu7i_Us()
{
  {
    init_simple_test("C_BFu7i_Us");
    static STRUCT_IF_C C_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Us");
    check_field_offset(lv, v3, 2, "C_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Us, C_BFu7i_Us)
//============================================================================


struct  C_BFu7i_Vp  {
  char v1;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 C_BFu7i_Vp) C1{ Fc Fi:7 Fp}



static void Test_C_BFu7i_Vp()
{
  {
    init_simple_test("C_BFu7i_Vp");
    static STRUCT_IF_C C_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Vp, C_BFu7i_Vp)
//============================================================================


struct  C_BFu7ll  {
  char v1;
  __tsu64 v2:7;
};
//SIG(1 C_BFu7ll) C1{ Fc FL:7}



static void Test_C_BFu7ll()
{
  {
    init_simple_test("C_BFu7ll");
    static STRUCT_IF_C C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll, C_BFu7ll)
//============================================================================


struct  C_BFu7ll_BFu15i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 C_BFu7ll_BFu15i) C1{ Fc FL:7 Fi:15}



static void Test_C_BFu7ll_BFu15i()
{
  {
    init_simple_test("C_BFu7ll_BFu15i");
    static STRUCT_IF_C C_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu15i, C_BFu7ll_BFu15i)
//============================================================================


struct  C_BFu7ll_BFu15ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 C_BFu7ll_BFu15ll) C1{ Fc FL:7 FL:15}



static void Test_C_BFu7ll_BFu15ll()
{
  {
    init_simple_test("C_BFu7ll_BFu15ll");
    static STRUCT_IF_C C_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu15ll, C_BFu7ll_BFu15ll)
//============================================================================


struct  C_BFu7ll_BFu15s  {
  char v1;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 C_BFu7ll_BFu15s) C1{ Fc FL:7 Fs:15}



static void Test_C_BFu7ll_BFu15s()
{
  {
    init_simple_test("C_BFu7ll_BFu15s");
    static STRUCT_IF_C C_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu15s, C_BFu7ll_BFu15s)
//============================================================================


struct  C_BFu7ll_BFu16i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 C_BFu7ll_BFu16i) C1{ Fc FL:7 Fi:16}



static void Test_C_BFu7ll_BFu16i()
{
  {
    init_simple_test("C_BFu7ll_BFu16i");
    static STRUCT_IF_C C_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu16i, C_BFu7ll_BFu16i)
//============================================================================


struct  C_BFu7ll_BFu16ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 C_BFu7ll_BFu16ll) C1{ Fc FL:7 FL:16}



static void Test_C_BFu7ll_BFu16ll()
{
  {
    init_simple_test("C_BFu7ll_BFu16ll");
    static STRUCT_IF_C C_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu16ll, C_BFu7ll_BFu16ll)
//============================================================================


struct  C_BFu7ll_BFu16s  {
  char v1;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 C_BFu7ll_BFu16s) C1{ Fc FL:7 Fs:16}



static void Test_C_BFu7ll_BFu16s()
{
  {
    init_simple_test("C_BFu7ll_BFu16s");
    static STRUCT_IF_C C_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu16s, C_BFu7ll_BFu16s)
//============================================================================


struct  C_BFu7ll_BFu17i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 C_BFu7ll_BFu17i) C1{ Fc FL:7 Fi:17}



static void Test_C_BFu7ll_BFu17i()
{
  {
    init_simple_test("C_BFu7ll_BFu17i");
    static STRUCT_IF_C C_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu17i, C_BFu7ll_BFu17i)
//============================================================================


struct  C_BFu7ll_BFu17ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 C_BFu7ll_BFu17ll) C1{ Fc FL:7 FL:17}



static void Test_C_BFu7ll_BFu17ll()
{
  {
    init_simple_test("C_BFu7ll_BFu17ll");
    static STRUCT_IF_C C_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu17ll, C_BFu7ll_BFu17ll)
//============================================================================


struct  C_BFu7ll_BFu1c  {
  char v1;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 C_BFu7ll_BFu1c) C1{ Fc FL:7 Fc:1}



static void Test_C_BFu7ll_BFu1c()
{
  {
    init_simple_test("C_BFu7ll_BFu1c");
    static STRUCT_IF_C C_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu1c, C_BFu7ll_BFu1c)
//============================================================================


struct  C_BFu7ll_BFu1i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 C_BFu7ll_BFu1i) C1{ Fc FL:7 Fi:1}



static void Test_C_BFu7ll_BFu1i()
{
  {
    init_simple_test("C_BFu7ll_BFu1i");
    static STRUCT_IF_C C_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu1i, C_BFu7ll_BFu1i)
//============================================================================


struct  C_BFu7ll_BFu1ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 C_BFu7ll_BFu1ll) C1{ Fc FL:7 FL:1}



static void Test_C_BFu7ll_BFu1ll()
{
  {
    init_simple_test("C_BFu7ll_BFu1ll");
    static STRUCT_IF_C C_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu1ll, C_BFu7ll_BFu1ll)
//============================================================================


struct  C_BFu7ll_BFu1s  {
  char v1;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 C_BFu7ll_BFu1s) C1{ Fc FL:7 Fs:1}



static void Test_C_BFu7ll_BFu1s()
{
  {
    init_simple_test("C_BFu7ll_BFu1s");
    static STRUCT_IF_C C_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu1s, C_BFu7ll_BFu1s)
//============================================================================


struct  C_BFu7ll_BFu31i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 C_BFu7ll_BFu31i) C1{ Fc FL:7 Fi:31}



static void Test_C_BFu7ll_BFu31i()
{
  {
    init_simple_test("C_BFu7ll_BFu31i");
    static STRUCT_IF_C C_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu31i, C_BFu7ll_BFu31i)
//============================================================================


struct  C_BFu7ll_BFu31ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 C_BFu7ll_BFu31ll) C1{ Fc FL:7 FL:31}



static void Test_C_BFu7ll_BFu31ll()
{
  {
    init_simple_test("C_BFu7ll_BFu31ll");
    static STRUCT_IF_C C_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu31ll, C_BFu7ll_BFu31ll)
//============================================================================


struct  C_BFu7ll_BFu32i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 C_BFu7ll_BFu32i) C1{ Fc FL:7 Fi:32}



static void Test_C_BFu7ll_BFu32i()
{
  {
    init_simple_test("C_BFu7ll_BFu32i");
    static STRUCT_IF_C C_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu32i, C_BFu7ll_BFu32i)
//============================================================================


struct  C_BFu7ll_BFu32ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 C_BFu7ll_BFu32ll) C1{ Fc FL:7 FL:32}



static void Test_C_BFu7ll_BFu32ll()
{
  {
    init_simple_test("C_BFu7ll_BFu32ll");
    static STRUCT_IF_C C_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu32ll, C_BFu7ll_BFu32ll)
//============================================================================


struct  C_BFu7ll_BFu33  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 C_BFu7ll_BFu33) C1{ Fc FL:7 FL:33}



static void Test_C_BFu7ll_BFu33()
{
  {
    init_simple_test("C_BFu7ll_BFu33");
    static STRUCT_IF_C C_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "C_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "C_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu33, C_BFu7ll_BFu33)
//============================================================================


struct  C_BFu7ll_BFu7c  {
  char v1;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 C_BFu7ll_BFu7c) C1{ Fc FL:7 Fc:7}



static void Test_C_BFu7ll_BFu7c()
{
  {
    init_simple_test("C_BFu7ll_BFu7c");
    static STRUCT_IF_C C_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu7c, C_BFu7ll_BFu7c)
//============================================================================


struct  C_BFu7ll_BFu7i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 C_BFu7ll_BFu7i) C1{ Fc FL:7 Fi:7}



static void Test_C_BFu7ll_BFu7i()
{
  {
    init_simple_test("C_BFu7ll_BFu7i");
    static STRUCT_IF_C C_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu7i, C_BFu7ll_BFu7i)
//============================================================================


struct  C_BFu7ll_BFu7ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 C_BFu7ll_BFu7ll) C1{ Fc FL:7 FL:7}



static void Test_C_BFu7ll_BFu7ll()
{
  {
    init_simple_test("C_BFu7ll_BFu7ll");
    static STRUCT_IF_C C_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu7ll, C_BFu7ll_BFu7ll)
//============================================================================


struct  C_BFu7ll_BFu7s  {
  char v1;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 C_BFu7ll_BFu7s) C1{ Fc FL:7 Fs:7}



static void Test_C_BFu7ll_BFu7s()
{
  {
    init_simple_test("C_BFu7ll_BFu7s");
    static STRUCT_IF_C C_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu7s, C_BFu7ll_BFu7s)
//============================================================================


struct  C_BFu7ll_BFu8c  {
  char v1;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 C_BFu7ll_BFu8c) C1{ Fc FL:7 Fc:8}



static void Test_C_BFu7ll_BFu8c()
{
  {
    init_simple_test("C_BFu7ll_BFu8c");
    static STRUCT_IF_C C_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu8c, C_BFu7ll_BFu8c)
//============================================================================


struct  C_BFu7ll_BFu8i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 C_BFu7ll_BFu8i) C1{ Fc FL:7 Fi:8}



static void Test_C_BFu7ll_BFu8i()
{
  {
    init_simple_test("C_BFu7ll_BFu8i");
    static STRUCT_IF_C C_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu8i, C_BFu7ll_BFu8i)
//============================================================================


struct  C_BFu7ll_BFu8ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 C_BFu7ll_BFu8ll) C1{ Fc FL:7 FL:8}



static void Test_C_BFu7ll_BFu8ll()
{
  {
    init_simple_test("C_BFu7ll_BFu8ll");
    static STRUCT_IF_C C_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu8ll, C_BFu7ll_BFu8ll)
//============================================================================


struct  C_BFu7ll_BFu8s  {
  char v1;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 C_BFu7ll_BFu8s) C1{ Fc FL:7 Fs:8}



static void Test_C_BFu7ll_BFu8s()
{
  {
    init_simple_test("C_BFu7ll_BFu8s");
    static STRUCT_IF_C C_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu8s, C_BFu7ll_BFu8s)
//============================================================================


struct  C_BFu7ll_BFu9i  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 C_BFu7ll_BFu9i) C1{ Fc FL:7 Fi:9}



static void Test_C_BFu7ll_BFu9i()
{
  {
    init_simple_test("C_BFu7ll_BFu9i");
    static STRUCT_IF_C C_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu9i, C_BFu7ll_BFu9i)
//============================================================================


struct  C_BFu7ll_BFu9ll  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 C_BFu7ll_BFu9ll) C1{ Fc FL:7 FL:9}



static void Test_C_BFu7ll_BFu9ll()
{
  {
    init_simple_test("C_BFu7ll_BFu9ll");
    static STRUCT_IF_C C_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu9ll, C_BFu7ll_BFu9ll)
//============================================================================


struct  C_BFu7ll_BFu9s  {
  char v1;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 C_BFu7ll_BFu9s) C1{ Fc FL:7 Fs:9}



static void Test_C_BFu7ll_BFu9s()
{
  {
    init_simple_test("C_BFu7ll_BFu9s");
    static STRUCT_IF_C C_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu9s, C_BFu7ll_BFu9s)
//============================================================================


struct  C_BFu7ll_C  {
  char v1;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 C_BFu7ll_C) C1{ Fc FL:7 Fc}



static void Test_C_BFu7ll_C()
{
  {
    init_simple_test("C_BFu7ll_C");
    static STRUCT_IF_C C_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_C");
    check_field_offset(lv, v3, 2, "C_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_C, C_BFu7ll_C)
//============================================================================


struct  C_BFu7ll_D  {
  char v1;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 C_BFu7ll_D) C1{ Fc FL:7 FL}



static void Test_C_BFu7ll_D()
{
  {
    init_simple_test("C_BFu7ll_D");
    static STRUCT_IF_C C_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_D, C_BFu7ll_D)
//============================================================================


struct  C_BFu7ll_F  {
  char v1;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 C_BFu7ll_F) C1{ Fc FL:7 Fi}



static void Test_C_BFu7ll_F()
{
  {
    init_simple_test("C_BFu7ll_F");
    static STRUCT_IF_C C_BFu7ll_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_F");
    check_field_offset(lv, v3, 4, "C_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_F, C_BFu7ll_F)
//============================================================================


struct  C_BFu7ll_I  {
  char v1;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 C_BFu7ll_I) C1{ Fc FL:7 Fi}



static void Test_C_BFu7ll_I()
{
  {
    init_simple_test("C_BFu7ll_I");
    static STRUCT_IF_C C_BFu7ll_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_I");
    check_field_offset(lv, v3, 4, "C_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_I, C_BFu7ll_I)
//============================================================================


struct  C_BFu7ll_Ip  {
  char v1;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 C_BFu7ll_Ip) C1{ Fc FL:7 Fp}



static void Test_C_BFu7ll_Ip()
{
  {
    init_simple_test("C_BFu7ll_Ip");
    static STRUCT_IF_C C_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Ip, C_BFu7ll_Ip)
//============================================================================


struct  C_BFu7ll_L  {
  char v1;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 C_BFu7ll_L) C1{ Fc FL:7 FL}



static void Test_C_BFu7ll_L()
{
  {
    init_simple_test("C_BFu7ll_L");
    static STRUCT_IF_C C_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_L, C_BFu7ll_L)
//============================================================================


struct  C_BFu7ll_S  {
  char v1;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 C_BFu7ll_S) C1{ Fc FL:7 Fs}



static void Test_C_BFu7ll_S()
{
  {
    init_simple_test("C_BFu7ll_S");
    static STRUCT_IF_C C_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_S");
    check_field_offset(lv, v3, 2, "C_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_S, C_BFu7ll_S)
//============================================================================


struct  C_BFu7ll_Uc  {
  char v1;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 C_BFu7ll_Uc) C1{ Fc FL:7 Fc}



static void Test_C_BFu7ll_Uc()
{
  {
    init_simple_test("C_BFu7ll_Uc");
    static STRUCT_IF_C C_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "C_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Uc, C_BFu7ll_Uc)
//============================================================================


struct  C_BFu7ll_Ui  {
  char v1;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 C_BFu7ll_Ui) C1{ Fc FL:7 Fi}



static void Test_C_BFu7ll_Ui()
{
  {
    init_simple_test("C_BFu7ll_Ui");
    static STRUCT_IF_C C_BFu7ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Ui");
    check_field_offset(lv, v3, 4, "C_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Ui, C_BFu7ll_Ui)
//============================================================================


struct  C_BFu7ll_Ul  {
  char v1;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 C_BFu7ll_Ul) C1{ Fc FL:7 FL}



static void Test_C_BFu7ll_Ul()
{
  {
    init_simple_test("C_BFu7ll_Ul");
    static STRUCT_IF_C C_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Ul, C_BFu7ll_Ul)
//============================================================================


struct  C_BFu7ll_Us  {
  char v1;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 C_BFu7ll_Us) C1{ Fc FL:7 Fs}



static void Test_C_BFu7ll_Us()
{
  {
    init_simple_test("C_BFu7ll_Us");
    static STRUCT_IF_C C_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "C_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Us, C_BFu7ll_Us)
//============================================================================


struct  C_BFu7ll_Vp  {
  char v1;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 C_BFu7ll_Vp) C1{ Fc FL:7 Fp}



static void Test_C_BFu7ll_Vp()
{
  {
    init_simple_test("C_BFu7ll_Vp");
    static STRUCT_IF_C C_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Vp, C_BFu7ll_Vp)
//============================================================================


struct  C_BFu7s  {
  char v1;
  unsigned short v2:7;
};
//SIG(1 C_BFu7s) C1{ Fc Fs:7}



static void Test_C_BFu7s()
{
  {
    init_simple_test("C_BFu7s");
    static STRUCT_IF_C C_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s, C_BFu7s)
//============================================================================


struct  C_BFu7s_BFu15i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 C_BFu7s_BFu15i) C1{ Fc Fs:7 Fi:15}



static void Test_C_BFu7s_BFu15i()
{
  {
    init_simple_test("C_BFu7s_BFu15i");
    static STRUCT_IF_C C_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu15i, C_BFu7s_BFu15i)
//============================================================================


struct  C_BFu7s_BFu15ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 C_BFu7s_BFu15ll) C1{ Fc Fs:7 FL:15}



static void Test_C_BFu7s_BFu15ll()
{
  {
    init_simple_test("C_BFu7s_BFu15ll");
    static STRUCT_IF_C C_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu15ll, C_BFu7s_BFu15ll)
//============================================================================


struct  C_BFu7s_BFu15s  {
  char v1;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 C_BFu7s_BFu15s) C1{ Fc Fs:7 Fs:15}



static void Test_C_BFu7s_BFu15s()
{
  {
    init_simple_test("C_BFu7s_BFu15s");
    static STRUCT_IF_C C_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu15s, C_BFu7s_BFu15s)
//============================================================================


struct  C_BFu7s_BFu16i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 C_BFu7s_BFu16i) C1{ Fc Fs:7 Fi:16}



static void Test_C_BFu7s_BFu16i()
{
  {
    init_simple_test("C_BFu7s_BFu16i");
    static STRUCT_IF_C C_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu16i, C_BFu7s_BFu16i)
//============================================================================


struct  C_BFu7s_BFu16ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 C_BFu7s_BFu16ll) C1{ Fc Fs:7 FL:16}



static void Test_C_BFu7s_BFu16ll()
{
  {
    init_simple_test("C_BFu7s_BFu16ll");
    static STRUCT_IF_C C_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu16ll, C_BFu7s_BFu16ll)
//============================================================================


struct  C_BFu7s_BFu16s  {
  char v1;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 C_BFu7s_BFu16s) C1{ Fc Fs:7 Fs:16}



static void Test_C_BFu7s_BFu16s()
{
  {
    init_simple_test("C_BFu7s_BFu16s");
    static STRUCT_IF_C C_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu16s, C_BFu7s_BFu16s)
//============================================================================


struct  C_BFu7s_BFu17i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 C_BFu7s_BFu17i) C1{ Fc Fs:7 Fi:17}



static void Test_C_BFu7s_BFu17i()
{
  {
    init_simple_test("C_BFu7s_BFu17i");
    static STRUCT_IF_C C_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu17i, C_BFu7s_BFu17i)
//============================================================================


struct  C_BFu7s_BFu17ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 C_BFu7s_BFu17ll) C1{ Fc Fs:7 FL:17}



static void Test_C_BFu7s_BFu17ll()
{
  {
    init_simple_test("C_BFu7s_BFu17ll");
    static STRUCT_IF_C C_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu17ll, C_BFu7s_BFu17ll)
//============================================================================


struct  C_BFu7s_BFu1c  {
  char v1;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 C_BFu7s_BFu1c) C1{ Fc Fs:7 Fc:1}



static void Test_C_BFu7s_BFu1c()
{
  {
    init_simple_test("C_BFu7s_BFu1c");
    static STRUCT_IF_C C_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu1c, C_BFu7s_BFu1c)
//============================================================================


struct  C_BFu7s_BFu1i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 C_BFu7s_BFu1i) C1{ Fc Fs:7 Fi:1}



static void Test_C_BFu7s_BFu1i()
{
  {
    init_simple_test("C_BFu7s_BFu1i");
    static STRUCT_IF_C C_BFu7s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu1i, C_BFu7s_BFu1i)
//============================================================================


struct  C_BFu7s_BFu1ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 C_BFu7s_BFu1ll) C1{ Fc Fs:7 FL:1}



static void Test_C_BFu7s_BFu1ll()
{
  {
    init_simple_test("C_BFu7s_BFu1ll");
    static STRUCT_IF_C C_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu1ll, C_BFu7s_BFu1ll)
//============================================================================


struct  C_BFu7s_BFu1s  {
  char v1;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 C_BFu7s_BFu1s) C1{ Fc Fs:7 Fs:1}



static void Test_C_BFu7s_BFu1s()
{
  {
    init_simple_test("C_BFu7s_BFu1s");
    static STRUCT_IF_C C_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu1s, C_BFu7s_BFu1s)
//============================================================================


struct  C_BFu7s_BFu31i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 C_BFu7s_BFu31i) C1{ Fc Fs:7 Fi:31}



static void Test_C_BFu7s_BFu31i()
{
  {
    init_simple_test("C_BFu7s_BFu31i");
    static STRUCT_IF_C C_BFu7s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu31i, C_BFu7s_BFu31i)
//============================================================================


struct  C_BFu7s_BFu31ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 C_BFu7s_BFu31ll) C1{ Fc Fs:7 FL:31}



static void Test_C_BFu7s_BFu31ll()
{
  {
    init_simple_test("C_BFu7s_BFu31ll");
    static STRUCT_IF_C C_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu31ll, C_BFu7s_BFu31ll)
//============================================================================


struct  C_BFu7s_BFu32i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 C_BFu7s_BFu32i) C1{ Fc Fs:7 Fi:32}



static void Test_C_BFu7s_BFu32i()
{
  {
    init_simple_test("C_BFu7s_BFu32i");
    static STRUCT_IF_C C_BFu7s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu32i, C_BFu7s_BFu32i)
//============================================================================


struct  C_BFu7s_BFu32ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 C_BFu7s_BFu32ll) C1{ Fc Fs:7 FL:32}



static void Test_C_BFu7s_BFu32ll()
{
  {
    init_simple_test("C_BFu7s_BFu32ll");
    static STRUCT_IF_C C_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu32ll, C_BFu7s_BFu32ll)
//============================================================================


struct  C_BFu7s_BFu33  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 C_BFu7s_BFu33) C1{ Fc Fs:7 FL:33}



static void Test_C_BFu7s_BFu33()
{
  {
    init_simple_test("C_BFu7s_BFu33");
    static STRUCT_IF_C C_BFu7s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "C_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "C_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu33, C_BFu7s_BFu33)
//============================================================================


struct  C_BFu7s_BFu7c  {
  char v1;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 C_BFu7s_BFu7c) C1{ Fc Fs:7 Fc:7}



static void Test_C_BFu7s_BFu7c()
{
  {
    init_simple_test("C_BFu7s_BFu7c");
    static STRUCT_IF_C C_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu7c, C_BFu7s_BFu7c)
//============================================================================


struct  C_BFu7s_BFu7i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 C_BFu7s_BFu7i) C1{ Fc Fs:7 Fi:7}



static void Test_C_BFu7s_BFu7i()
{
  {
    init_simple_test("C_BFu7s_BFu7i");
    static STRUCT_IF_C C_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu7i, C_BFu7s_BFu7i)
//============================================================================


struct  C_BFu7s_BFu7ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 C_BFu7s_BFu7ll) C1{ Fc Fs:7 FL:7}



static void Test_C_BFu7s_BFu7ll()
{
  {
    init_simple_test("C_BFu7s_BFu7ll");
    static STRUCT_IF_C C_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu7ll, C_BFu7s_BFu7ll)
//============================================================================


struct  C_BFu7s_BFu7s  {
  char v1;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 C_BFu7s_BFu7s) C1{ Fc Fs:7 Fs:7}



static void Test_C_BFu7s_BFu7s()
{
  {
    init_simple_test("C_BFu7s_BFu7s");
    static STRUCT_IF_C C_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu7s, C_BFu7s_BFu7s)
//============================================================================


struct  C_BFu7s_BFu8c  {
  char v1;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 C_BFu7s_BFu8c) C1{ Fc Fs:7 Fc:8}



static void Test_C_BFu7s_BFu8c()
{
  {
    init_simple_test("C_BFu7s_BFu8c");
    static STRUCT_IF_C C_BFu7s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu8c, C_BFu7s_BFu8c)
//============================================================================


struct  C_BFu7s_BFu8i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 C_BFu7s_BFu8i) C1{ Fc Fs:7 Fi:8}



static void Test_C_BFu7s_BFu8i()
{
  {
    init_simple_test("C_BFu7s_BFu8i");
    static STRUCT_IF_C C_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu8i, C_BFu7s_BFu8i)
//============================================================================


struct  C_BFu7s_BFu8ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 C_BFu7s_BFu8ll) C1{ Fc Fs:7 FL:8}



static void Test_C_BFu7s_BFu8ll()
{
  {
    init_simple_test("C_BFu7s_BFu8ll");
    static STRUCT_IF_C C_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu8ll, C_BFu7s_BFu8ll)
//============================================================================


struct  C_BFu7s_BFu8s  {
  char v1;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 C_BFu7s_BFu8s) C1{ Fc Fs:7 Fs:8}



static void Test_C_BFu7s_BFu8s()
{
  {
    init_simple_test("C_BFu7s_BFu8s");
    static STRUCT_IF_C C_BFu7s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu8s, C_BFu7s_BFu8s)
//============================================================================


struct  C_BFu7s_BFu9i  {
  char v1;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 C_BFu7s_BFu9i) C1{ Fc Fs:7 Fi:9}



static void Test_C_BFu7s_BFu9i()
{
  {
    init_simple_test("C_BFu7s_BFu9i");
    static STRUCT_IF_C C_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu9i, C_BFu7s_BFu9i)
//============================================================================


struct  C_BFu7s_BFu9ll  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 C_BFu7s_BFu9ll) C1{ Fc Fs:7 FL:9}



static void Test_C_BFu7s_BFu9ll()
{
  {
    init_simple_test("C_BFu7s_BFu9ll");
    static STRUCT_IF_C C_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu9ll, C_BFu7s_BFu9ll)
//============================================================================


struct  C_BFu7s_BFu9s  {
  char v1;
  unsigned short v2:7;
  unsigned short v3:9;
};
//SIG(1 C_BFu7s_BFu9s) C1{ Fc Fs:7 Fs:9}



static void Test_C_BFu7s_BFu9s()
{
  {
    init_simple_test("C_BFu7s_BFu9s");
    static STRUCT_IF_C C_BFu7s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu9s, C_BFu7s_BFu9s)
//============================================================================


struct  C_BFu7s_C  {
  char v1;
  unsigned short v2:7;
  char v3;
};
//SIG(1 C_BFu7s_C) C1{ Fc Fs:7 Fc}



static void Test_C_BFu7s_C()
{
  {
    init_simple_test("C_BFu7s_C");
    static STRUCT_IF_C C_BFu7s_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_C)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_C)");
    check_field_offset(lv, v1, 0, "C_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_C");
    check_field_offset(lv, v3, 2, "C_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_C, C_BFu7s_C)
//============================================================================


struct  C_BFu7s_D  {
  char v1;
  unsigned short v2:7;
  double v3;
};
//SIG(1 C_BFu7s_D) C1{ Fc Fs:7 FL}



static void Test_C_BFu7s_D()
{
  {
    init_simple_test("C_BFu7s_D");
    static STRUCT_IF_C C_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_D)");
    check_field_offset(lv, v1, 0, "C_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_D, C_BFu7s_D)
//============================================================================


struct  C_BFu7s_F  {
  char v1;
  unsigned short v2:7;
  float v3;
};
//SIG(1 C_BFu7s_F) C1{ Fc Fs:7 Fi}



static void Test_C_BFu7s_F()
{
  {
    init_simple_test("C_BFu7s_F");
    static STRUCT_IF_C C_BFu7s_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7s_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_F)");
    check_field_offset(lv, v1, 0, "C_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_F");
    check_field_offset(lv, v3, 4, "C_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_F, C_BFu7s_F)
//============================================================================


struct  C_BFu7s_I  {
  char v1;
  unsigned short v2:7;
  int v3;
};
//SIG(1 C_BFu7s_I) C1{ Fc Fs:7 Fi}



static void Test_C_BFu7s_I()
{
  {
    init_simple_test("C_BFu7s_I");
    static STRUCT_IF_C C_BFu7s_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7s_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_I)");
    check_field_offset(lv, v1, 0, "C_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_I");
    check_field_offset(lv, v3, 4, "C_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_I, C_BFu7s_I)
//============================================================================


struct  C_BFu7s_Ip  {
  char v1;
  unsigned short v2:7;
  int *v3;
};
//SIG(1 C_BFu7s_Ip) C1{ Fc Fs:7 Fp}



static void Test_C_BFu7s_Ip()
{
  {
    init_simple_test("C_BFu7s_Ip");
    static STRUCT_IF_C C_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_Ip, C_BFu7s_Ip)
//============================================================================


struct  C_BFu7s_L  {
  char v1;
  unsigned short v2:7;
  __tsi64 v3;
};
//SIG(1 C_BFu7s_L) C1{ Fc Fs:7 FL}



static void Test_C_BFu7s_L()
{
  {
    init_simple_test("C_BFu7s_L");
    static STRUCT_IF_C C_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_L)");
    check_field_offset(lv, v1, 0, "C_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_L, C_BFu7s_L)
//============================================================================


struct  C_BFu7s_S  {
  char v1;
  unsigned short v2:7;
  short v3;
};
//SIG(1 C_BFu7s_S) C1{ Fc Fs:7 Fs}



static void Test_C_BFu7s_S()
{
  {
    init_simple_test("C_BFu7s_S");
    static STRUCT_IF_C C_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_S)");
    check_field_offset(lv, v1, 0, "C_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_S");
    check_field_offset(lv, v3, 2, "C_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_S, C_BFu7s_S)
//============================================================================


struct  C_BFu7s_Uc  {
  char v1;
  unsigned short v2:7;
  unsigned char v3;
};
//SIG(1 C_BFu7s_Uc) C1{ Fc Fs:7 Fc}



static void Test_C_BFu7s_Uc()
{
  {
    init_simple_test("C_BFu7s_Uc");
    static STRUCT_IF_C C_BFu7s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_Uc");
    check_field_offset(lv, v3, 2, "C_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_Uc, C_BFu7s_Uc)
//============================================================================


struct  C_BFu7s_Ui  {
  char v1;
  unsigned short v2:7;
  unsigned int v3;
};
//SIG(1 C_BFu7s_Ui) C1{ Fc Fs:7 Fi}



static void Test_C_BFu7s_Ui()
{
  {
    init_simple_test("C_BFu7s_Ui");
    static STRUCT_IF_C C_BFu7s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu7s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_Ui");
    check_field_offset(lv, v3, 4, "C_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_Ui, C_BFu7s_Ui)
//============================================================================


struct  C_BFu7s_Ul  {
  char v1;
  unsigned short v2:7;
  __tsu64 v3;
};
//SIG(1 C_BFu7s_Ul) C1{ Fc Fs:7 FL}



static void Test_C_BFu7s_Ul()
{
  {
    init_simple_test("C_BFu7s_Ul");
    static STRUCT_IF_C C_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_Ul, C_BFu7s_Ul)
//============================================================================


struct  C_BFu7s_Us  {
  char v1;
  unsigned short v2:7;
  unsigned short v3;
};
//SIG(1 C_BFu7s_Us) C1{ Fc Fs:7 Fs}



static void Test_C_BFu7s_Us()
{
  {
    init_simple_test("C_BFu7s_Us");
    static STRUCT_IF_C C_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "C_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_Us");
    check_field_offset(lv, v3, 2, "C_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_Us, C_BFu7s_Us)
//============================================================================


struct  C_BFu7s_Vp  {
  char v1;
  unsigned short v2:7;
  void *v3;
};
//SIG(1 C_BFu7s_Vp) C1{ Fc Fs:7 Fp}



static void Test_C_BFu7s_Vp()
{
  {
    init_simple_test("C_BFu7s_Vp");
    static STRUCT_IF_C C_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_Vp, C_BFu7s_Vp)
//============================================================================


struct  C_BFu8c  {
  char v1;
  unsigned char v2:8;
};
//SIG(1 C_BFu8c) C1{ Fc Fc:8}



static void Test_C_BFu8c()
{
  {
    init_simple_test("C_BFu8c");
    static STRUCT_IF_C C_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c, C_BFu8c)
//============================================================================


struct  C_BFu8c_BFu15i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:15;
};
//SIG(1 C_BFu8c_BFu15i) C1{ Fc Fc:8 Fi:15}



static void Test_C_BFu8c_BFu15i()
{
  {
    init_simple_test("C_BFu8c_BFu15i");
    static STRUCT_IF_C C_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu15i, C_BFu8c_BFu15i)
//============================================================================


struct  C_BFu8c_BFu15ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:15;
};
//SIG(1 C_BFu8c_BFu15ll) C1{ Fc Fc:8 FL:15}



static void Test_C_BFu8c_BFu15ll()
{
  {
    init_simple_test("C_BFu8c_BFu15ll");
    static STRUCT_IF_C C_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu15ll, C_BFu8c_BFu15ll)
//============================================================================


struct  C_BFu8c_BFu15s  {
  char v1;
  unsigned char v2:8;
  unsigned short v3:15;
};
//SIG(1 C_BFu8c_BFu15s) C1{ Fc Fc:8 Fs:15}



static void Test_C_BFu8c_BFu15s()
{
  {
    init_simple_test("C_BFu8c_BFu15s");
    static STRUCT_IF_C C_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu15s, C_BFu8c_BFu15s)
//============================================================================


struct  C_BFu8c_BFu16i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:16;
};
//SIG(1 C_BFu8c_BFu16i) C1{ Fc Fc:8 Fi:16}



static void Test_C_BFu8c_BFu16i()
{
  {
    init_simple_test("C_BFu8c_BFu16i");
    static STRUCT_IF_C C_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu16i, C_BFu8c_BFu16i)
//============================================================================


struct  C_BFu8c_BFu16ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:16;
};
//SIG(1 C_BFu8c_BFu16ll) C1{ Fc Fc:8 FL:16}



static void Test_C_BFu8c_BFu16ll()
{
  {
    init_simple_test("C_BFu8c_BFu16ll");
    static STRUCT_IF_C C_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu16ll, C_BFu8c_BFu16ll)
//============================================================================


struct  C_BFu8c_BFu16s  {
  char v1;
  unsigned char v2:8;
  unsigned short v3:16;
};
//SIG(1 C_BFu8c_BFu16s) C1{ Fc Fc:8 Fs:16}



static void Test_C_BFu8c_BFu16s()
{
  {
    init_simple_test("C_BFu8c_BFu16s");
    static STRUCT_IF_C C_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu16s, C_BFu8c_BFu16s)
//============================================================================


struct  C_BFu8c_BFu17i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:17;
};
//SIG(1 C_BFu8c_BFu17i) C1{ Fc Fc:8 Fi:17}



static void Test_C_BFu8c_BFu17i()
{
  {
    init_simple_test("C_BFu8c_BFu17i");
    static STRUCT_IF_C C_BFu8c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu17i, C_BFu8c_BFu17i)
//============================================================================


struct  C_BFu8c_BFu17ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:17;
};
//SIG(1 C_BFu8c_BFu17ll) C1{ Fc Fc:8 FL:17}



static void Test_C_BFu8c_BFu17ll()
{
  {
    init_simple_test("C_BFu8c_BFu17ll");
    static STRUCT_IF_C C_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "C_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "C_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu17ll, C_BFu8c_BFu17ll)
//============================================================================


struct  C_BFu8c_BFu1c  {
  char v1;
  unsigned char v2:8;
  unsigned char v3:1;
};
//SIG(1 C_BFu8c_BFu1c) C1{ Fc Fc:8 Fc:1}



static void Test_C_BFu8c_BFu1c()
{
  {
    init_simple_test("C_BFu8c_BFu1c");
    static STRUCT_IF_C C_BFu8c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu1c, C_BFu8c_BFu1c)
//============================================================================


struct  C_BFu8c_BFu1i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:1;
};
//SIG(1 C_BFu8c_BFu1i) C1{ Fc Fc:8 Fi:1}



static void Test_C_BFu8c_BFu1i()
{
  {
    init_simple_test("C_BFu8c_BFu1i");
    static STRUCT_IF_C C_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu1i, C_BFu8c_BFu1i)
//============================================================================


struct  C_BFu8c_BFu1ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:1;
};
//SIG(1 C_BFu8c_BFu1ll) C1{ Fc Fc:8 FL:1}



static void Test_C_BFu8c_BFu1ll()
{
  {
    init_simple_test("C_BFu8c_BFu1ll");
    static STRUCT_IF_C C_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu1ll, C_BFu8c_BFu1ll)
//============================================================================


struct  C_BFu8c_BFu1s  {
  char v1;
  unsigned char v2:8;
  unsigned short v3:1;
};
//SIG(1 C_BFu8c_BFu1s) C1{ Fc Fc:8 Fs:1}



static void Test_C_BFu8c_BFu1s()
{
  {
    init_simple_test("C_BFu8c_BFu1s");
    static STRUCT_IF_C C_BFu8c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu1s, C_BFu8c_BFu1s)
//============================================================================


struct  C_BFu8c_BFu31i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:31;
};
//SIG(1 C_BFu8c_BFu31i) C1{ Fc Fc:8 Fi:31}



static void Test_C_BFu8c_BFu31i()
{
  {
    init_simple_test("C_BFu8c_BFu31i");
    static STRUCT_IF_C C_BFu8c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu31i, C_BFu8c_BFu31i)
//============================================================================


struct  C_BFu8c_BFu31ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:31;
};
//SIG(1 C_BFu8c_BFu31ll) C1{ Fc Fc:8 FL:31}



static void Test_C_BFu8c_BFu31ll()
{
  {
    init_simple_test("C_BFu8c_BFu31ll");
    static STRUCT_IF_C C_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "C_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "C_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu31ll, C_BFu8c_BFu31ll)
//============================================================================


struct  C_BFu8c_BFu32i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:32;
};
//SIG(1 C_BFu8c_BFu32i) C1{ Fc Fc:8 Fi:32}



static void Test_C_BFu8c_BFu32i()
{
  {
    init_simple_test("C_BFu8c_BFu32i");
    static STRUCT_IF_C C_BFu8c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu32i, C_BFu8c_BFu32i)
//============================================================================


struct  C_BFu8c_BFu32ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:32;
};
//SIG(1 C_BFu8c_BFu32ll) C1{ Fc Fc:8 FL:32}



static void Test_C_BFu8c_BFu32ll()
{
  {
    init_simple_test("C_BFu8c_BFu32ll");
    static STRUCT_IF_C C_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "C_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "C_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu32ll, C_BFu8c_BFu32ll)
//============================================================================


struct  C_BFu8c_BFu33  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:33;
};
//SIG(1 C_BFu8c_BFu33) C1{ Fc Fc:8 FL:33}



static void Test_C_BFu8c_BFu33()
{
  {
    init_simple_test("C_BFu8c_BFu33");
    static STRUCT_IF_C C_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "C_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "C_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu33, C_BFu8c_BFu33)
//============================================================================


struct  C_BFu8c_BFu7c  {
  char v1;
  unsigned char v2:8;
  unsigned char v3:7;
};
//SIG(1 C_BFu8c_BFu7c) C1{ Fc Fc:8 Fc:7}



static void Test_C_BFu8c_BFu7c()
{
  {
    init_simple_test("C_BFu8c_BFu7c");
    static STRUCT_IF_C C_BFu8c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu7c, C_BFu8c_BFu7c)
//============================================================================


struct  C_BFu8c_BFu7i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:7;
};
//SIG(1 C_BFu8c_BFu7i) C1{ Fc Fc:8 Fi:7}



static void Test_C_BFu8c_BFu7i()
{
  {
    init_simple_test("C_BFu8c_BFu7i");
    static STRUCT_IF_C C_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu7i, C_BFu8c_BFu7i)
//============================================================================


struct  C_BFu8c_BFu7ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:7;
};
//SIG(1 C_BFu8c_BFu7ll) C1{ Fc Fc:8 FL:7}



static void Test_C_BFu8c_BFu7ll()
{
  {
    init_simple_test("C_BFu8c_BFu7ll");
    static STRUCT_IF_C C_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu7ll, C_BFu8c_BFu7ll)
//============================================================================


struct  C_BFu8c_BFu7s  {
  char v1;
  unsigned char v2:8;
  unsigned short v3:7;
};
//SIG(1 C_BFu8c_BFu7s) C1{ Fc Fc:8 Fs:7}



static void Test_C_BFu8c_BFu7s()
{
  {
    init_simple_test("C_BFu8c_BFu7s");
    static STRUCT_IF_C C_BFu8c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu7s, C_BFu8c_BFu7s)
//============================================================================


struct  C_BFu8c_BFu8c  {
  char v1;
  unsigned char v2:8;
  unsigned char v3:8;
};
//SIG(1 C_BFu8c_BFu8c) C1{ Fc Fc:8 Fc:8}



static void Test_C_BFu8c_BFu8c()
{
  {
    init_simple_test("C_BFu8c_BFu8c");
    static STRUCT_IF_C C_BFu8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu8c, C_BFu8c_BFu8c)
//============================================================================


struct  C_BFu8c_BFu8i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:8;
};
//SIG(1 C_BFu8c_BFu8i) C1{ Fc Fc:8 Fi:8}



static void Test_C_BFu8c_BFu8i()
{
  {
    init_simple_test("C_BFu8c_BFu8i");
    static STRUCT_IF_C C_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu8i, C_BFu8c_BFu8i)
//============================================================================


struct  C_BFu8c_BFu8ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:8;
};
//SIG(1 C_BFu8c_BFu8ll) C1{ Fc Fc:8 FL:8}



static void Test_C_BFu8c_BFu8ll()
{
  {
    init_simple_test("C_BFu8c_BFu8ll");
    static STRUCT_IF_C C_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu8ll, C_BFu8c_BFu8ll)
//============================================================================


struct  C_BFu8c_BFu8s  {
  char v1;
  unsigned char v2:8;
  unsigned short v3:8;
};
//SIG(1 C_BFu8c_BFu8s) C1{ Fc Fc:8 Fs:8}



static void Test_C_BFu8c_BFu8s()
{
  {
    init_simple_test("C_BFu8c_BFu8s");
    static STRUCT_IF_C C_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu8s, C_BFu8c_BFu8s)
//============================================================================


struct  C_BFu8c_BFu9i  {
  char v1;
  unsigned char v2:8;
  unsigned int v3:9;
};
//SIG(1 C_BFu8c_BFu9i) C1{ Fc Fc:8 Fi:9}



static void Test_C_BFu8c_BFu9i()
{
  {
    init_simple_test("C_BFu8c_BFu9i");
    static STRUCT_IF_C C_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu9i, C_BFu8c_BFu9i)
//============================================================================


struct  C_BFu8c_BFu9ll  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3:9;
};
//SIG(1 C_BFu8c_BFu9ll) C1{ Fc Fc:8 FL:9}



static void Test_C_BFu8c_BFu9ll()
{
  {
    init_simple_test("C_BFu8c_BFu9ll");
    static STRUCT_IF_C C_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu9ll, C_BFu8c_BFu9ll)
//============================================================================


struct  C_BFu8c_BFu9s  {
  char v1;
  unsigned char v2:8;
  unsigned short v3:9;
};
//SIG(1 C_BFu8c_BFu9s) C1{ Fc Fc:8 Fs:9}



static void Test_C_BFu8c_BFu9s()
{
  {
    init_simple_test("C_BFu8c_BFu9s");
    static STRUCT_IF_C C_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_BFu9s, C_BFu8c_BFu9s)
//============================================================================


struct  C_BFu8c_C  {
  char v1;
  unsigned char v2:8;
  char v3;
};
//SIG(1 C_BFu8c_C) C1{ Fc Fc:8 Fc}



static void Test_C_BFu8c_C()
{
  {
    init_simple_test("C_BFu8c_C");
    static STRUCT_IF_C C_BFu8c_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu8c_C)");
    check_field_offset(lv, v1, 0, "C_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_C");
    check_field_offset(lv, v3, 2, "C_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_C, C_BFu8c_C)
//============================================================================


struct  C_BFu8c_D  {
  char v1;
  unsigned char v2:8;
  double v3;
};
//SIG(1 C_BFu8c_D) C1{ Fc Fc:8 FL}



static void Test_C_BFu8c_D()
{
  {
    init_simple_test("C_BFu8c_D");
    static STRUCT_IF_C C_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_D)");
    check_field_offset(lv, v1, 0, "C_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_D, C_BFu8c_D)
//============================================================================


struct  C_BFu8c_F  {
  char v1;
  unsigned char v2:8;
  float v3;
};
//SIG(1 C_BFu8c_F) C1{ Fc Fc:8 Fi}



static void Test_C_BFu8c_F()
{
  {
    init_simple_test("C_BFu8c_F");
    static STRUCT_IF_C C_BFu8c_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_F)");
    check_field_offset(lv, v1, 0, "C_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_F");
    check_field_offset(lv, v3, 4, "C_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_F, C_BFu8c_F)
//============================================================================


struct  C_BFu8c_I  {
  char v1;
  unsigned char v2:8;
  int v3;
};
//SIG(1 C_BFu8c_I) C1{ Fc Fc:8 Fi}



static void Test_C_BFu8c_I()
{
  {
    init_simple_test("C_BFu8c_I");
    static STRUCT_IF_C C_BFu8c_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_I)");
    check_field_offset(lv, v1, 0, "C_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_I");
    check_field_offset(lv, v3, 4, "C_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_I, C_BFu8c_I)
//============================================================================


struct  C_BFu8c_Ip  {
  char v1;
  unsigned char v2:8;
  int *v3;
};
//SIG(1 C_BFu8c_Ip) C1{ Fc Fc:8 Fp}



static void Test_C_BFu8c_Ip()
{
  {
    init_simple_test("C_BFu8c_Ip");
    static STRUCT_IF_C C_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_Ip, C_BFu8c_Ip)
//============================================================================


struct  C_BFu8c_L  {
  char v1;
  unsigned char v2:8;
  __tsi64 v3;
};
//SIG(1 C_BFu8c_L) C1{ Fc Fc:8 FL}



static void Test_C_BFu8c_L()
{
  {
    init_simple_test("C_BFu8c_L");
    static STRUCT_IF_C C_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_L)");
    check_field_offset(lv, v1, 0, "C_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_L, C_BFu8c_L)
//============================================================================


struct  C_BFu8c_S  {
  char v1;
  unsigned char v2:8;
  short v3;
};
//SIG(1 C_BFu8c_S) C1{ Fc Fc:8 Fs}



static void Test_C_BFu8c_S()
{
  {
    init_simple_test("C_BFu8c_S");
    static STRUCT_IF_C C_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8c_S)");
    check_field_offset(lv, v1, 0, "C_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_S");
    check_field_offset(lv, v3, 2, "C_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_S, C_BFu8c_S)
//============================================================================


struct  C_BFu8c_Uc  {
  char v1;
  unsigned char v2:8;
  unsigned char v3;
};
//SIG(1 C_BFu8c_Uc) C1{ Fc Fc:8 Fc}



static void Test_C_BFu8c_Uc()
{
  {
    init_simple_test("C_BFu8c_Uc");
    static STRUCT_IF_C C_BFu8c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_Uc");
    check_field_offset(lv, v3, 2, "C_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_Uc, C_BFu8c_Uc)
//============================================================================


struct  C_BFu8c_Ui  {
  char v1;
  unsigned char v2:8;
  unsigned int v3;
};
//SIG(1 C_BFu8c_Ui) C1{ Fc Fc:8 Fi}



static void Test_C_BFu8c_Ui()
{
  {
    init_simple_test("C_BFu8c_Ui");
    static STRUCT_IF_C C_BFu8c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_Ui");
    check_field_offset(lv, v3, 4, "C_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_Ui, C_BFu8c_Ui)
//============================================================================


struct  C_BFu8c_Ul  {
  char v1;
  unsigned char v2:8;
  __tsu64 v3;
};
//SIG(1 C_BFu8c_Ul) C1{ Fc Fc:8 FL}



static void Test_C_BFu8c_Ul()
{
  {
    init_simple_test("C_BFu8c_Ul");
    static STRUCT_IF_C C_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_Ul, C_BFu8c_Ul)
//============================================================================


struct  C_BFu8c_Us  {
  char v1;
  unsigned char v2:8;
  unsigned short v3;
};
//SIG(1 C_BFu8c_Us) C1{ Fc Fc:8 Fs}



static void Test_C_BFu8c_Us()
{
  {
    init_simple_test("C_BFu8c_Us");
    static STRUCT_IF_C C_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "C_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_Us");
    check_field_offset(lv, v3, 2, "C_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_Us, C_BFu8c_Us)
//============================================================================


struct  C_BFu8c_Vp  {
  char v1;
  unsigned char v2:8;
  void *v3;
};
//SIG(1 C_BFu8c_Vp) C1{ Fc Fc:8 Fp}



static void Test_C_BFu8c_Vp()
{
  {
    init_simple_test("C_BFu8c_Vp");
    static STRUCT_IF_C C_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8c_Vp, C_BFu8c_Vp)
//============================================================================


struct  C_BFu8i  {
  char v1;
  unsigned int v2:8;
};
//SIG(1 C_BFu8i) C1{ Fc Fi:8}



static void Test_C_BFu8i()
{
  {
    init_simple_test("C_BFu8i");
    static STRUCT_IF_C C_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i, C_BFu8i)
//============================================================================


struct  C_BFu8i_BFu15i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:15;
};
//SIG(1 C_BFu8i_BFu15i) C1{ Fc Fi:8 Fi:15}



static void Test_C_BFu8i_BFu15i()
{
  {
    init_simple_test("C_BFu8i_BFu15i");
    static STRUCT_IF_C C_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu15i, C_BFu8i_BFu15i)
//============================================================================


struct  C_BFu8i_BFu15ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:15;
};
//SIG(1 C_BFu8i_BFu15ll) C1{ Fc Fi:8 FL:15}



static void Test_C_BFu8i_BFu15ll()
{
  {
    init_simple_test("C_BFu8i_BFu15ll");
    static STRUCT_IF_C C_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu15ll, C_BFu8i_BFu15ll)
//============================================================================


struct  C_BFu8i_BFu15s  {
  char v1;
  unsigned int v2:8;
  unsigned short v3:15;
};
//SIG(1 C_BFu8i_BFu15s) C1{ Fc Fi:8 Fs:15}



static void Test_C_BFu8i_BFu15s()
{
  {
    init_simple_test("C_BFu8i_BFu15s");
    static STRUCT_IF_C C_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu15s, C_BFu8i_BFu15s)
//============================================================================


struct  C_BFu8i_BFu16i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:16;
};
//SIG(1 C_BFu8i_BFu16i) C1{ Fc Fi:8 Fi:16}



static void Test_C_BFu8i_BFu16i()
{
  {
    init_simple_test("C_BFu8i_BFu16i");
    static STRUCT_IF_C C_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu16i, C_BFu8i_BFu16i)
//============================================================================


struct  C_BFu8i_BFu16ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:16;
};
//SIG(1 C_BFu8i_BFu16ll) C1{ Fc Fi:8 FL:16}



static void Test_C_BFu8i_BFu16ll()
{
  {
    init_simple_test("C_BFu8i_BFu16ll");
    static STRUCT_IF_C C_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu16ll, C_BFu8i_BFu16ll)
//============================================================================


struct  C_BFu8i_BFu16s  {
  char v1;
  unsigned int v2:8;
  unsigned short v3:16;
};
//SIG(1 C_BFu8i_BFu16s) C1{ Fc Fi:8 Fs:16}



static void Test_C_BFu8i_BFu16s()
{
  {
    init_simple_test("C_BFu8i_BFu16s");
    static STRUCT_IF_C C_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu16s, C_BFu8i_BFu16s)
//============================================================================


struct  C_BFu8i_BFu17i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:17;
};
//SIG(1 C_BFu8i_BFu17i) C1{ Fc Fi:8 Fi:17}



static void Test_C_BFu8i_BFu17i()
{
  {
    init_simple_test("C_BFu8i_BFu17i");
    static STRUCT_IF_C C_BFu8i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu17i, C_BFu8i_BFu17i)
//============================================================================


struct  C_BFu8i_BFu17ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:17;
};
//SIG(1 C_BFu8i_BFu17ll) C1{ Fc Fi:8 FL:17}



static void Test_C_BFu8i_BFu17ll()
{
  {
    init_simple_test("C_BFu8i_BFu17ll");
    static STRUCT_IF_C C_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "C_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "C_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu17ll, C_BFu8i_BFu17ll)
//============================================================================


struct  C_BFu8i_BFu1c  {
  char v1;
  unsigned int v2:8;
  unsigned char v3:1;
};
//SIG(1 C_BFu8i_BFu1c) C1{ Fc Fi:8 Fc:1}



static void Test_C_BFu8i_BFu1c()
{
  {
    init_simple_test("C_BFu8i_BFu1c");
    static STRUCT_IF_C C_BFu8i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu1c, C_BFu8i_BFu1c)
//============================================================================


struct  C_BFu8i_BFu1i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:1;
};
//SIG(1 C_BFu8i_BFu1i) C1{ Fc Fi:8 Fi:1}



static void Test_C_BFu8i_BFu1i()
{
  {
    init_simple_test("C_BFu8i_BFu1i");
    static STRUCT_IF_C C_BFu8i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu1i, C_BFu8i_BFu1i)
//============================================================================


struct  C_BFu8i_BFu1ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:1;
};
//SIG(1 C_BFu8i_BFu1ll) C1{ Fc Fi:8 FL:1}



static void Test_C_BFu8i_BFu1ll()
{
  {
    init_simple_test("C_BFu8i_BFu1ll");
    static STRUCT_IF_C C_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu1ll, C_BFu8i_BFu1ll)
//============================================================================


struct  C_BFu8i_BFu1s  {
  char v1;
  unsigned int v2:8;
  unsigned short v3:1;
};
//SIG(1 C_BFu8i_BFu1s) C1{ Fc Fi:8 Fs:1}



static void Test_C_BFu8i_BFu1s()
{
  {
    init_simple_test("C_BFu8i_BFu1s");
    static STRUCT_IF_C C_BFu8i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu1s, C_BFu8i_BFu1s)
//============================================================================


struct  C_BFu8i_BFu31i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:31;
};
//SIG(1 C_BFu8i_BFu31i) C1{ Fc Fi:8 Fi:31}



static void Test_C_BFu8i_BFu31i()
{
  {
    init_simple_test("C_BFu8i_BFu31i");
    static STRUCT_IF_C C_BFu8i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu31i, C_BFu8i_BFu31i)
//============================================================================


struct  C_BFu8i_BFu31ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 C_BFu8i_BFu31ll) C1{ Fc Fi:8 FL:31}



static void Test_C_BFu8i_BFu31ll()
{
  {
    init_simple_test("C_BFu8i_BFu31ll");
    static STRUCT_IF_C C_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "C_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "C_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu31ll, C_BFu8i_BFu31ll)
//============================================================================


struct  C_BFu8i_BFu32i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 C_BFu8i_BFu32i) C1{ Fc Fi:8 Fi:32}



static void Test_C_BFu8i_BFu32i()
{
  {
    init_simple_test("C_BFu8i_BFu32i");
    static STRUCT_IF_C C_BFu8i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu32i, C_BFu8i_BFu32i)
//============================================================================


struct  C_BFu8i_BFu32ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 C_BFu8i_BFu32ll) C1{ Fc Fi:8 FL:32}



static void Test_C_BFu8i_BFu32ll()
{
  {
    init_simple_test("C_BFu8i_BFu32ll");
    static STRUCT_IF_C C_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "C_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "C_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu32ll, C_BFu8i_BFu32ll)
//============================================================================


struct  C_BFu8i_BFu33  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 C_BFu8i_BFu33) C1{ Fc Fi:8 FL:33}



static void Test_C_BFu8i_BFu33()
{
  {
    init_simple_test("C_BFu8i_BFu33");
    static STRUCT_IF_C C_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "C_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "C_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu33, C_BFu8i_BFu33)
//============================================================================


struct  C_BFu8i_BFu7c  {
  char v1;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 C_BFu8i_BFu7c) C1{ Fc Fi:8 Fc:7}



static void Test_C_BFu8i_BFu7c()
{
  {
    init_simple_test("C_BFu8i_BFu7c");
    static STRUCT_IF_C C_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu7c, C_BFu8i_BFu7c)
//============================================================================


struct  C_BFu8i_BFu7i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 C_BFu8i_BFu7i) C1{ Fc Fi:8 Fi:7}



static void Test_C_BFu8i_BFu7i()
{
  {
    init_simple_test("C_BFu8i_BFu7i");
    static STRUCT_IF_C C_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu7i, C_BFu8i_BFu7i)
//============================================================================


struct  C_BFu8i_BFu7ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 C_BFu8i_BFu7ll) C1{ Fc Fi:8 FL:7}



static void Test_C_BFu8i_BFu7ll()
{
  {
    init_simple_test("C_BFu8i_BFu7ll");
    static STRUCT_IF_C C_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu7ll, C_BFu8i_BFu7ll)
//============================================================================


struct  C_BFu8i_BFu7s  {
  char v1;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 C_BFu8i_BFu7s) C1{ Fc Fi:8 Fs:7}



static void Test_C_BFu8i_BFu7s()
{
  {
    init_simple_test("C_BFu8i_BFu7s");
    static STRUCT_IF_C C_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu7s, C_BFu8i_BFu7s)
//============================================================================


struct  C_BFu8i_BFu8c  {
  char v1;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 C_BFu8i_BFu8c) C1{ Fc Fi:8 Fc:8}



static void Test_C_BFu8i_BFu8c()
{
  {
    init_simple_test("C_BFu8i_BFu8c");
    static STRUCT_IF_C C_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu8c, C_BFu8i_BFu8c)
//============================================================================


struct  C_BFu8i_BFu8i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 C_BFu8i_BFu8i) C1{ Fc Fi:8 Fi:8}



static void Test_C_BFu8i_BFu8i()
{
  {
    init_simple_test("C_BFu8i_BFu8i");
    static STRUCT_IF_C C_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu8i, C_BFu8i_BFu8i)
//============================================================================


struct  C_BFu8i_BFu8ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 C_BFu8i_BFu8ll) C1{ Fc Fi:8 FL:8}



static void Test_C_BFu8i_BFu8ll()
{
  {
    init_simple_test("C_BFu8i_BFu8ll");
    static STRUCT_IF_C C_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu8ll, C_BFu8i_BFu8ll)
//============================================================================


struct  C_BFu8i_BFu8s  {
  char v1;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 C_BFu8i_BFu8s) C1{ Fc Fi:8 Fs:8}



static void Test_C_BFu8i_BFu8s()
{
  {
    init_simple_test("C_BFu8i_BFu8s");
    static STRUCT_IF_C C_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu8s, C_BFu8i_BFu8s)
//============================================================================


struct  C_BFu8i_BFu9i  {
  char v1;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 C_BFu8i_BFu9i) C1{ Fc Fi:8 Fi:9}



static void Test_C_BFu8i_BFu9i()
{
  {
    init_simple_test("C_BFu8i_BFu9i");
    static STRUCT_IF_C C_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu9i, C_BFu8i_BFu9i)
//============================================================================


struct  C_BFu8i_BFu9ll  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 C_BFu8i_BFu9ll) C1{ Fc Fi:8 FL:9}



static void Test_C_BFu8i_BFu9ll()
{
  {
    init_simple_test("C_BFu8i_BFu9ll");
    static STRUCT_IF_C C_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu9ll, C_BFu8i_BFu9ll)
//============================================================================


struct  C_BFu8i_BFu9s  {
  char v1;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 C_BFu8i_BFu9s) C1{ Fc Fi:8 Fs:9}



static void Test_C_BFu8i_BFu9s()
{
  {
    init_simple_test("C_BFu8i_BFu9s");
    static STRUCT_IF_C C_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_BFu9s, C_BFu8i_BFu9s)
//============================================================================


struct  C_BFu8i_C  {
  char v1;
  unsigned int v2:8;
  char v3;
};
//SIG(1 C_BFu8i_C) C1{ Fc Fi:8 Fc}



static void Test_C_BFu8i_C()
{
  {
    init_simple_test("C_BFu8i_C");
    static STRUCT_IF_C C_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_C)");
    check_field_offset(lv, v1, 0, "C_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_C");
    check_field_offset(lv, v3, 2, "C_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_C, C_BFu8i_C)
//============================================================================


struct  C_BFu8i_D  {
  char v1;
  unsigned int v2:8;
  double v3;
};
//SIG(1 C_BFu8i_D) C1{ Fc Fi:8 FL}



static void Test_C_BFu8i_D()
{
  {
    init_simple_test("C_BFu8i_D");
    static STRUCT_IF_C C_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_D)");
    check_field_offset(lv, v1, 0, "C_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_D, C_BFu8i_D)
//============================================================================


struct  C_BFu8i_F  {
  char v1;
  unsigned int v2:8;
  float v3;
};
//SIG(1 C_BFu8i_F) C1{ Fc Fi:8 Fi}



static void Test_C_BFu8i_F()
{
  {
    init_simple_test("C_BFu8i_F");
    static STRUCT_IF_C C_BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_F)");
    check_field_offset(lv, v1, 0, "C_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_F");
    check_field_offset(lv, v3, 4, "C_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_F, C_BFu8i_F)
//============================================================================


struct  C_BFu8i_I  {
  char v1;
  unsigned int v2:8;
  int v3;
};
//SIG(1 C_BFu8i_I) C1{ Fc Fi:8 Fi}



static void Test_C_BFu8i_I()
{
  {
    init_simple_test("C_BFu8i_I");
    static STRUCT_IF_C C_BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_I)");
    check_field_offset(lv, v1, 0, "C_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_I");
    check_field_offset(lv, v3, 4, "C_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_I, C_BFu8i_I)
//============================================================================


struct  C_BFu8i_Ip  {
  char v1;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 C_BFu8i_Ip) C1{ Fc Fi:8 Fp}



static void Test_C_BFu8i_Ip()
{
  {
    init_simple_test("C_BFu8i_Ip");
    static STRUCT_IF_C C_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_Ip, C_BFu8i_Ip)
//============================================================================


struct  C_BFu8i_L  {
  char v1;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 C_BFu8i_L) C1{ Fc Fi:8 FL}



static void Test_C_BFu8i_L()
{
  {
    init_simple_test("C_BFu8i_L");
    static STRUCT_IF_C C_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_L)");
    check_field_offset(lv, v1, 0, "C_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_L, C_BFu8i_L)
//============================================================================


struct  C_BFu8i_S  {
  char v1;
  unsigned int v2:8;
  short v3;
};
//SIG(1 C_BFu8i_S) C1{ Fc Fi:8 Fs}



static void Test_C_BFu8i_S()
{
  {
    init_simple_test("C_BFu8i_S");
    static STRUCT_IF_C C_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_S)");
    check_field_offset(lv, v1, 0, "C_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_S");
    check_field_offset(lv, v3, 2, "C_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_S, C_BFu8i_S)
//============================================================================


struct  C_BFu8i_Uc  {
  char v1;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 C_BFu8i_Uc) C1{ Fc Fi:8 Fc}



static void Test_C_BFu8i_Uc()
{
  {
    init_simple_test("C_BFu8i_Uc");
    static STRUCT_IF_C C_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_Uc");
    check_field_offset(lv, v3, 2, "C_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_Uc, C_BFu8i_Uc)
//============================================================================


struct  C_BFu8i_Ui  {
  char v1;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 C_BFu8i_Ui) C1{ Fc Fi:8 Fi}



static void Test_C_BFu8i_Ui()
{
  {
    init_simple_test("C_BFu8i_Ui");
    static STRUCT_IF_C C_BFu8i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_Ui");
    check_field_offset(lv, v3, 4, "C_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_Ui, C_BFu8i_Ui)
//============================================================================


struct  C_BFu8i_Ul  {
  char v1;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 C_BFu8i_Ul) C1{ Fc Fi:8 FL}



static void Test_C_BFu8i_Ul()
{
  {
    init_simple_test("C_BFu8i_Ul");
    static STRUCT_IF_C C_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_Ul, C_BFu8i_Ul)
//============================================================================


struct  C_BFu8i_Us  {
  char v1;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 C_BFu8i_Us) C1{ Fc Fi:8 Fs}



static void Test_C_BFu8i_Us()
{
  {
    init_simple_test("C_BFu8i_Us");
    static STRUCT_IF_C C_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_Us");
    check_field_offset(lv, v3, 2, "C_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_Us, C_BFu8i_Us)
//============================================================================


struct  C_BFu8i_Vp  {
  char v1;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 C_BFu8i_Vp) C1{ Fc Fi:8 Fp}



static void Test_C_BFu8i_Vp()
{
  {
    init_simple_test("C_BFu8i_Vp");
    static STRUCT_IF_C C_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8i_Vp, C_BFu8i_Vp)
//============================================================================


struct  C_BFu8ll  {
  char v1;
  __tsu64 v2:8;
};
//SIG(1 C_BFu8ll) C1{ Fc FL:8}



static void Test_C_BFu8ll()
{
  {
    init_simple_test("C_BFu8ll");
    static STRUCT_IF_C C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll, C_BFu8ll)
//============================================================================


struct  C_BFu8ll_BFu15i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 C_BFu8ll_BFu15i) C1{ Fc FL:8 Fi:15}



static void Test_C_BFu8ll_BFu15i()
{
  {
    init_simple_test("C_BFu8ll_BFu15i");
    static STRUCT_IF_C C_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu15i, C_BFu8ll_BFu15i)
//============================================================================


struct  C_BFu8ll_BFu15ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 C_BFu8ll_BFu15ll) C1{ Fc FL:8 FL:15}



static void Test_C_BFu8ll_BFu15ll()
{
  {
    init_simple_test("C_BFu8ll_BFu15ll");
    static STRUCT_IF_C C_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu15ll, C_BFu8ll_BFu15ll)
//============================================================================


struct  C_BFu8ll_BFu15s  {
  char v1;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 C_BFu8ll_BFu15s) C1{ Fc FL:8 Fs:15}



static void Test_C_BFu8ll_BFu15s()
{
  {
    init_simple_test("C_BFu8ll_BFu15s");
    static STRUCT_IF_C C_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu15s, C_BFu8ll_BFu15s)
//============================================================================


struct  C_BFu8ll_BFu16i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 C_BFu8ll_BFu16i) C1{ Fc FL:8 Fi:16}



static void Test_C_BFu8ll_BFu16i()
{
  {
    init_simple_test("C_BFu8ll_BFu16i");
    static STRUCT_IF_C C_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu16i, C_BFu8ll_BFu16i)
//============================================================================


struct  C_BFu8ll_BFu16ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 C_BFu8ll_BFu16ll) C1{ Fc FL:8 FL:16}



static void Test_C_BFu8ll_BFu16ll()
{
  {
    init_simple_test("C_BFu8ll_BFu16ll");
    static STRUCT_IF_C C_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu16ll, C_BFu8ll_BFu16ll)
//============================================================================


struct  C_BFu8ll_BFu16s  {
  char v1;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 C_BFu8ll_BFu16s) C1{ Fc FL:8 Fs:16}



static void Test_C_BFu8ll_BFu16s()
{
  {
    init_simple_test("C_BFu8ll_BFu16s");
    static STRUCT_IF_C C_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu16s, C_BFu8ll_BFu16s)
//============================================================================


struct  C_BFu8ll_BFu17i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 C_BFu8ll_BFu17i) C1{ Fc FL:8 Fi:17}



static void Test_C_BFu8ll_BFu17i()
{
  {
    init_simple_test("C_BFu8ll_BFu17i");
    static STRUCT_IF_C C_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu17i, C_BFu8ll_BFu17i)
//============================================================================


struct  C_BFu8ll_BFu17ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 C_BFu8ll_BFu17ll) C1{ Fc FL:8 FL:17}



static void Test_C_BFu8ll_BFu17ll()
{
  {
    init_simple_test("C_BFu8ll_BFu17ll");
    static STRUCT_IF_C C_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "C_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "C_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu17ll, C_BFu8ll_BFu17ll)
//============================================================================


struct  C_BFu8ll_BFu1c  {
  char v1;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 C_BFu8ll_BFu1c) C1{ Fc FL:8 Fc:1}



static void Test_C_BFu8ll_BFu1c()
{
  {
    init_simple_test("C_BFu8ll_BFu1c");
    static STRUCT_IF_C C_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu1c, C_BFu8ll_BFu1c)
//============================================================================


struct  C_BFu8ll_BFu1i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 C_BFu8ll_BFu1i) C1{ Fc FL:8 Fi:1}



static void Test_C_BFu8ll_BFu1i()
{
  {
    init_simple_test("C_BFu8ll_BFu1i");
    static STRUCT_IF_C C_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu1i, C_BFu8ll_BFu1i)
//============================================================================


struct  C_BFu8ll_BFu1ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 C_BFu8ll_BFu1ll) C1{ Fc FL:8 FL:1}



static void Test_C_BFu8ll_BFu1ll()
{
  {
    init_simple_test("C_BFu8ll_BFu1ll");
    static STRUCT_IF_C C_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu1ll, C_BFu8ll_BFu1ll)
//============================================================================


struct  C_BFu8ll_BFu1s  {
  char v1;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 C_BFu8ll_BFu1s) C1{ Fc FL:8 Fs:1}



static void Test_C_BFu8ll_BFu1s()
{
  {
    init_simple_test("C_BFu8ll_BFu1s");
    static STRUCT_IF_C C_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu1s, C_BFu8ll_BFu1s)
//============================================================================


struct  C_BFu8ll_BFu31i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 C_BFu8ll_BFu31i) C1{ Fc FL:8 Fi:31}



static void Test_C_BFu8ll_BFu31i()
{
  {
    init_simple_test("C_BFu8ll_BFu31i");
    static STRUCT_IF_C C_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu31i, C_BFu8ll_BFu31i)
//============================================================================


struct  C_BFu8ll_BFu31ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 C_BFu8ll_BFu31ll) C1{ Fc FL:8 FL:31}



static void Test_C_BFu8ll_BFu31ll()
{
  {
    init_simple_test("C_BFu8ll_BFu31ll");
    static STRUCT_IF_C C_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "C_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "C_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu31ll, C_BFu8ll_BFu31ll)
//============================================================================


struct  C_BFu8ll_BFu32i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 C_BFu8ll_BFu32i) C1{ Fc FL:8 Fi:32}



static void Test_C_BFu8ll_BFu32i()
{
  {
    init_simple_test("C_BFu8ll_BFu32i");
    static STRUCT_IF_C C_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu32i, C_BFu8ll_BFu32i)
//============================================================================


struct  C_BFu8ll_BFu32ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 C_BFu8ll_BFu32ll) C1{ Fc FL:8 FL:32}



static void Test_C_BFu8ll_BFu32ll()
{
  {
    init_simple_test("C_BFu8ll_BFu32ll");
    static STRUCT_IF_C C_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "C_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "C_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu32ll, C_BFu8ll_BFu32ll)
//============================================================================


struct  C_BFu8ll_BFu33  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 C_BFu8ll_BFu33) C1{ Fc FL:8 FL:33}



static void Test_C_BFu8ll_BFu33()
{
  {
    init_simple_test("C_BFu8ll_BFu33");
    static STRUCT_IF_C C_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "C_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "C_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu33, C_BFu8ll_BFu33)
//============================================================================


struct  C_BFu8ll_BFu7c  {
  char v1;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 C_BFu8ll_BFu7c) C1{ Fc FL:8 Fc:7}



static void Test_C_BFu8ll_BFu7c()
{
  {
    init_simple_test("C_BFu8ll_BFu7c");
    static STRUCT_IF_C C_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu7c, C_BFu8ll_BFu7c)
//============================================================================


struct  C_BFu8ll_BFu7i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 C_BFu8ll_BFu7i) C1{ Fc FL:8 Fi:7}



static void Test_C_BFu8ll_BFu7i()
{
  {
    init_simple_test("C_BFu8ll_BFu7i");
    static STRUCT_IF_C C_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu7i, C_BFu8ll_BFu7i)
//============================================================================


struct  C_BFu8ll_BFu7ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 C_BFu8ll_BFu7ll) C1{ Fc FL:8 FL:7}



static void Test_C_BFu8ll_BFu7ll()
{
  {
    init_simple_test("C_BFu8ll_BFu7ll");
    static STRUCT_IF_C C_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu7ll, C_BFu8ll_BFu7ll)
//============================================================================


struct  C_BFu8ll_BFu7s  {
  char v1;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 C_BFu8ll_BFu7s) C1{ Fc FL:8 Fs:7}



static void Test_C_BFu8ll_BFu7s()
{
  {
    init_simple_test("C_BFu8ll_BFu7s");
    static STRUCT_IF_C C_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu7s, C_BFu8ll_BFu7s)
//============================================================================


struct  C_BFu8ll_BFu8c  {
  char v1;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 C_BFu8ll_BFu8c) C1{ Fc FL:8 Fc:8}



static void Test_C_BFu8ll_BFu8c()
{
  {
    init_simple_test("C_BFu8ll_BFu8c");
    static STRUCT_IF_C C_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu8c, C_BFu8ll_BFu8c)
//============================================================================


struct  C_BFu8ll_BFu8i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 C_BFu8ll_BFu8i) C1{ Fc FL:8 Fi:8}



static void Test_C_BFu8ll_BFu8i()
{
  {
    init_simple_test("C_BFu8ll_BFu8i");
    static STRUCT_IF_C C_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu8i, C_BFu8ll_BFu8i)
//============================================================================


struct  C_BFu8ll_BFu8ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 C_BFu8ll_BFu8ll) C1{ Fc FL:8 FL:8}



static void Test_C_BFu8ll_BFu8ll()
{
  {
    init_simple_test("C_BFu8ll_BFu8ll");
    static STRUCT_IF_C C_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu8ll, C_BFu8ll_BFu8ll)
//============================================================================


struct  C_BFu8ll_BFu8s  {
  char v1;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 C_BFu8ll_BFu8s) C1{ Fc FL:8 Fs:8}



static void Test_C_BFu8ll_BFu8s()
{
  {
    init_simple_test("C_BFu8ll_BFu8s");
    static STRUCT_IF_C C_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu8s, C_BFu8ll_BFu8s)
//============================================================================


struct  C_BFu8ll_BFu9i  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 C_BFu8ll_BFu9i) C1{ Fc FL:8 Fi:9}



static void Test_C_BFu8ll_BFu9i()
{
  {
    init_simple_test("C_BFu8ll_BFu9i");
    static STRUCT_IF_C C_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu9i, C_BFu8ll_BFu9i)
//============================================================================


struct  C_BFu8ll_BFu9ll  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 C_BFu8ll_BFu9ll) C1{ Fc FL:8 FL:9}



static void Test_C_BFu8ll_BFu9ll()
{
  {
    init_simple_test("C_BFu8ll_BFu9ll");
    static STRUCT_IF_C C_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu9ll, C_BFu8ll_BFu9ll)
//============================================================================


struct  C_BFu8ll_BFu9s  {
  char v1;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 C_BFu8ll_BFu9s) C1{ Fc FL:8 Fs:9}



static void Test_C_BFu8ll_BFu9s()
{
  {
    init_simple_test("C_BFu8ll_BFu9s");
    static STRUCT_IF_C C_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_BFu9s, C_BFu8ll_BFu9s)
//============================================================================


struct  C_BFu8ll_C  {
  char v1;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 C_BFu8ll_C) C1{ Fc FL:8 Fc}



static void Test_C_BFu8ll_C()
{
  {
    init_simple_test("C_BFu8ll_C");
    static STRUCT_IF_C C_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_C");
    check_field_offset(lv, v3, 2, "C_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_C, C_BFu8ll_C)
//============================================================================


struct  C_BFu8ll_D  {
  char v1;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 C_BFu8ll_D) C1{ Fc FL:8 FL}



static void Test_C_BFu8ll_D()
{
  {
    init_simple_test("C_BFu8ll_D");
    static STRUCT_IF_C C_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_D, C_BFu8ll_D)
//============================================================================


struct  C_BFu8ll_F  {
  char v1;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 C_BFu8ll_F) C1{ Fc FL:8 Fi}



static void Test_C_BFu8ll_F()
{
  {
    init_simple_test("C_BFu8ll_F");
    static STRUCT_IF_C C_BFu8ll_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_F");
    check_field_offset(lv, v3, 4, "C_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_F, C_BFu8ll_F)
//============================================================================


struct  C_BFu8ll_I  {
  char v1;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 C_BFu8ll_I) C1{ Fc FL:8 Fi}



static void Test_C_BFu8ll_I()
{
  {
    init_simple_test("C_BFu8ll_I");
    static STRUCT_IF_C C_BFu8ll_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_I");
    check_field_offset(lv, v3, 4, "C_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_I, C_BFu8ll_I)
//============================================================================


struct  C_BFu8ll_Ip  {
  char v1;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 C_BFu8ll_Ip) C1{ Fc FL:8 Fp}



static void Test_C_BFu8ll_Ip()
{
  {
    init_simple_test("C_BFu8ll_Ip");
    static STRUCT_IF_C C_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_Ip, C_BFu8ll_Ip)
//============================================================================


struct  C_BFu8ll_L  {
  char v1;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 C_BFu8ll_L) C1{ Fc FL:8 FL}



static void Test_C_BFu8ll_L()
{
  {
    init_simple_test("C_BFu8ll_L");
    static STRUCT_IF_C C_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_L, C_BFu8ll_L)
//============================================================================


struct  C_BFu8ll_S  {
  char v1;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 C_BFu8ll_S) C1{ Fc FL:8 Fs}



static void Test_C_BFu8ll_S()
{
  {
    init_simple_test("C_BFu8ll_S");
    static STRUCT_IF_C C_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_S");
    check_field_offset(lv, v3, 2, "C_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_S, C_BFu8ll_S)
//============================================================================


struct  C_BFu8ll_Uc  {
  char v1;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 C_BFu8ll_Uc) C1{ Fc FL:8 Fc}



static void Test_C_BFu8ll_Uc()
{
  {
    init_simple_test("C_BFu8ll_Uc");
    static STRUCT_IF_C C_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_Uc");
    check_field_offset(lv, v3, 2, "C_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_Uc, C_BFu8ll_Uc)
//============================================================================


struct  C_BFu8ll_Ui  {
  char v1;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 C_BFu8ll_Ui) C1{ Fc FL:8 Fi}



static void Test_C_BFu8ll_Ui()
{
  {
    init_simple_test("C_BFu8ll_Ui");
    static STRUCT_IF_C C_BFu8ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_Ui");
    check_field_offset(lv, v3, 4, "C_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_Ui, C_BFu8ll_Ui)
//============================================================================


struct  C_BFu8ll_Ul  {
  char v1;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 C_BFu8ll_Ul) C1{ Fc FL:8 FL}



static void Test_C_BFu8ll_Ul()
{
  {
    init_simple_test("C_BFu8ll_Ul");
    static STRUCT_IF_C C_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_Ul, C_BFu8ll_Ul)
//============================================================================


struct  C_BFu8ll_Us  {
  char v1;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 C_BFu8ll_Us) C1{ Fc FL:8 Fs}



static void Test_C_BFu8ll_Us()
{
  {
    init_simple_test("C_BFu8ll_Us");
    static STRUCT_IF_C C_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_Us");
    check_field_offset(lv, v3, 2, "C_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_Us, C_BFu8ll_Us)
//============================================================================


struct  C_BFu8ll_Vp  {
  char v1;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 C_BFu8ll_Vp) C1{ Fc FL:8 Fp}



static void Test_C_BFu8ll_Vp()
{
  {
    init_simple_test("C_BFu8ll_Vp");
    static STRUCT_IF_C C_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8ll_Vp, C_BFu8ll_Vp)
//============================================================================


struct  C_BFu8s  {
  char v1;
  unsigned short v2:8;
};
//SIG(1 C_BFu8s) C1{ Fc Fs:8}



static void Test_C_BFu8s()
{
  {
    init_simple_test("C_BFu8s");
    static STRUCT_IF_C C_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s, C_BFu8s)
//============================================================================


struct  C_BFu8s_BFu15i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 C_BFu8s_BFu15i) C1{ Fc Fs:8 Fi:15}



static void Test_C_BFu8s_BFu15i()
{
  {
    init_simple_test("C_BFu8s_BFu15i");
    static STRUCT_IF_C C_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu15i, C_BFu8s_BFu15i)
//============================================================================


struct  C_BFu8s_BFu15ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 C_BFu8s_BFu15ll) C1{ Fc Fs:8 FL:15}



static void Test_C_BFu8s_BFu15ll()
{
  {
    init_simple_test("C_BFu8s_BFu15ll");
    static STRUCT_IF_C C_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu15ll, C_BFu8s_BFu15ll)
//============================================================================


struct  C_BFu8s_BFu15s  {
  char v1;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 C_BFu8s_BFu15s) C1{ Fc Fs:8 Fs:15}



static void Test_C_BFu8s_BFu15s()
{
  {
    init_simple_test("C_BFu8s_BFu15s");
    static STRUCT_IF_C C_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu15s, C_BFu8s_BFu15s)
//============================================================================


struct  C_BFu8s_BFu16i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 C_BFu8s_BFu16i) C1{ Fc Fs:8 Fi:16}



static void Test_C_BFu8s_BFu16i()
{
  {
    init_simple_test("C_BFu8s_BFu16i");
    static STRUCT_IF_C C_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu16i, C_BFu8s_BFu16i)
//============================================================================


struct  C_BFu8s_BFu16ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 C_BFu8s_BFu16ll) C1{ Fc Fs:8 FL:16}



static void Test_C_BFu8s_BFu16ll()
{
  {
    init_simple_test("C_BFu8s_BFu16ll");
    static STRUCT_IF_C C_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu16ll, C_BFu8s_BFu16ll)
//============================================================================


struct  C_BFu8s_BFu16s  {
  char v1;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 C_BFu8s_BFu16s) C1{ Fc Fs:8 Fs:16}



static void Test_C_BFu8s_BFu16s()
{
  {
    init_simple_test("C_BFu8s_BFu16s");
    static STRUCT_IF_C C_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu16s, C_BFu8s_BFu16s)
//============================================================================


struct  C_BFu8s_BFu17i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 C_BFu8s_BFu17i) C1{ Fc Fs:8 Fi:17}



static void Test_C_BFu8s_BFu17i()
{
  {
    init_simple_test("C_BFu8s_BFu17i");
    static STRUCT_IF_C C_BFu8s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu17i, C_BFu8s_BFu17i)
//============================================================================


struct  C_BFu8s_BFu17ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 C_BFu8s_BFu17ll) C1{ Fc Fs:8 FL:17}



static void Test_C_BFu8s_BFu17ll()
{
  {
    init_simple_test("C_BFu8s_BFu17ll");
    static STRUCT_IF_C C_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "C_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "C_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu17ll, C_BFu8s_BFu17ll)
//============================================================================


struct  C_BFu8s_BFu1c  {
  char v1;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 C_BFu8s_BFu1c) C1{ Fc Fs:8 Fc:1}



static void Test_C_BFu8s_BFu1c()
{
  {
    init_simple_test("C_BFu8s_BFu1c");
    static STRUCT_IF_C C_BFu8s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu1c, C_BFu8s_BFu1c)
//============================================================================


struct  C_BFu8s_BFu1i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 C_BFu8s_BFu1i) C1{ Fc Fs:8 Fi:1}



static void Test_C_BFu8s_BFu1i()
{
  {
    init_simple_test("C_BFu8s_BFu1i");
    static STRUCT_IF_C C_BFu8s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu1i, C_BFu8s_BFu1i)
//============================================================================


struct  C_BFu8s_BFu1ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 C_BFu8s_BFu1ll) C1{ Fc Fs:8 FL:1}



static void Test_C_BFu8s_BFu1ll()
{
  {
    init_simple_test("C_BFu8s_BFu1ll");
    static STRUCT_IF_C C_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu1ll, C_BFu8s_BFu1ll)
//============================================================================


struct  C_BFu8s_BFu1s  {
  char v1;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 C_BFu8s_BFu1s) C1{ Fc Fs:8 Fs:1}



static void Test_C_BFu8s_BFu1s()
{
  {
    init_simple_test("C_BFu8s_BFu1s");
    static STRUCT_IF_C C_BFu8s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu1s, C_BFu8s_BFu1s)
//============================================================================


struct  C_BFu8s_BFu31i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 C_BFu8s_BFu31i) C1{ Fc Fs:8 Fi:31}



static void Test_C_BFu8s_BFu31i()
{
  {
    init_simple_test("C_BFu8s_BFu31i");
    static STRUCT_IF_C C_BFu8s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu31i, C_BFu8s_BFu31i)
//============================================================================


struct  C_BFu8s_BFu31ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 C_BFu8s_BFu31ll) C1{ Fc Fs:8 FL:31}



static void Test_C_BFu8s_BFu31ll()
{
  {
    init_simple_test("C_BFu8s_BFu31ll");
    static STRUCT_IF_C C_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "C_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "C_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu31ll, C_BFu8s_BFu31ll)
//============================================================================


struct  C_BFu8s_BFu32i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 C_BFu8s_BFu32i) C1{ Fc Fs:8 Fi:32}



static void Test_C_BFu8s_BFu32i()
{
  {
    init_simple_test("C_BFu8s_BFu32i");
    static STRUCT_IF_C C_BFu8s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu32i, C_BFu8s_BFu32i)
//============================================================================


struct  C_BFu8s_BFu32ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 C_BFu8s_BFu32ll) C1{ Fc Fs:8 FL:32}



static void Test_C_BFu8s_BFu32ll()
{
  {
    init_simple_test("C_BFu8s_BFu32ll");
    static STRUCT_IF_C C_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "C_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "C_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu32ll, C_BFu8s_BFu32ll)
//============================================================================


struct  C_BFu8s_BFu33  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:33;
};
//SIG(1 C_BFu8s_BFu33) C1{ Fc Fs:8 FL:33}



static void Test_C_BFu8s_BFu33()
{
  {
    init_simple_test("C_BFu8s_BFu33");
    static STRUCT_IF_C C_BFu8s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "C_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "C_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu33, C_BFu8s_BFu33)
//============================================================================


struct  C_BFu8s_BFu7c  {
  char v1;
  unsigned short v2:8;
  unsigned char v3:7;
};
//SIG(1 C_BFu8s_BFu7c) C1{ Fc Fs:8 Fc:7}



static void Test_C_BFu8s_BFu7c()
{
  {
    init_simple_test("C_BFu8s_BFu7c");
    static STRUCT_IF_C C_BFu8s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu7c, C_BFu8s_BFu7c)
//============================================================================


struct  C_BFu8s_BFu7i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:7;
};
//SIG(1 C_BFu8s_BFu7i) C1{ Fc Fs:8 Fi:7}



static void Test_C_BFu8s_BFu7i()
{
  {
    init_simple_test("C_BFu8s_BFu7i");
    static STRUCT_IF_C C_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu7i, C_BFu8s_BFu7i)
//============================================================================


struct  C_BFu8s_BFu7ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 C_BFu8s_BFu7ll) C1{ Fc Fs:8 FL:7}



static void Test_C_BFu8s_BFu7ll()
{
  {
    init_simple_test("C_BFu8s_BFu7ll");
    static STRUCT_IF_C C_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu7ll, C_BFu8s_BFu7ll)
//============================================================================


struct  C_BFu8s_BFu7s  {
  char v1;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 C_BFu8s_BFu7s) C1{ Fc Fs:8 Fs:7}



static void Test_C_BFu8s_BFu7s()
{
  {
    init_simple_test("C_BFu8s_BFu7s");
    static STRUCT_IF_C C_BFu8s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu7s, C_BFu8s_BFu7s)
//============================================================================


struct  C_BFu8s_BFu8c  {
  char v1;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 C_BFu8s_BFu8c) C1{ Fc Fs:8 Fc:8}



static void Test_C_BFu8s_BFu8c()
{
  {
    init_simple_test("C_BFu8s_BFu8c");
    static STRUCT_IF_C C_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu8c, C_BFu8s_BFu8c)
//============================================================================


struct  C_BFu8s_BFu8i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 C_BFu8s_BFu8i) C1{ Fc Fs:8 Fi:8}



static void Test_C_BFu8s_BFu8i()
{
  {
    init_simple_test("C_BFu8s_BFu8i");
    static STRUCT_IF_C C_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu8i, C_BFu8s_BFu8i)
//============================================================================


struct  C_BFu8s_BFu8ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 C_BFu8s_BFu8ll) C1{ Fc Fs:8 FL:8}



static void Test_C_BFu8s_BFu8ll()
{
  {
    init_simple_test("C_BFu8s_BFu8ll");
    static STRUCT_IF_C C_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu8ll, C_BFu8s_BFu8ll)
//============================================================================


struct  C_BFu8s_BFu8s  {
  char v1;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 C_BFu8s_BFu8s) C1{ Fc Fs:8 Fs:8}



static void Test_C_BFu8s_BFu8s()
{
  {
    init_simple_test("C_BFu8s_BFu8s");
    static STRUCT_IF_C C_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu8s, C_BFu8s_BFu8s)
//============================================================================


struct  C_BFu8s_BFu9i  {
  char v1;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 C_BFu8s_BFu9i) C1{ Fc Fs:8 Fi:9}



static void Test_C_BFu8s_BFu9i()
{
  {
    init_simple_test("C_BFu8s_BFu9i");
    static STRUCT_IF_C C_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu9i, C_BFu8s_BFu9i)
//============================================================================


struct  C_BFu8s_BFu9ll  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 C_BFu8s_BFu9ll) C1{ Fc Fs:8 FL:9}



static void Test_C_BFu8s_BFu9ll()
{
  {
    init_simple_test("C_BFu8s_BFu9ll");
    static STRUCT_IF_C C_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu9ll, C_BFu8s_BFu9ll)
//============================================================================


struct  C_BFu8s_BFu9s  {
  char v1;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 C_BFu8s_BFu9s) C1{ Fc Fs:8 Fs:9}



static void Test_C_BFu8s_BFu9s()
{
  {
    init_simple_test("C_BFu8s_BFu9s");
    static STRUCT_IF_C C_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_BFu9s, C_BFu8s_BFu9s)
//============================================================================


struct  C_BFu8s_C  {
  char v1;
  unsigned short v2:8;
  char v3;
};
//SIG(1 C_BFu8s_C) C1{ Fc Fs:8 Fc}



static void Test_C_BFu8s_C()
{
  {
    init_simple_test("C_BFu8s_C");
    static STRUCT_IF_C C_BFu8s_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_C)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_C)");
    check_field_offset(lv, v1, 0, "C_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_C");
    check_field_offset(lv, v3, 2, "C_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_C, C_BFu8s_C)
//============================================================================


struct  C_BFu8s_D  {
  char v1;
  unsigned short v2:8;
  double v3;
};
//SIG(1 C_BFu8s_D) C1{ Fc Fs:8 FL}



static void Test_C_BFu8s_D()
{
  {
    init_simple_test("C_BFu8s_D");
    static STRUCT_IF_C C_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_D)");
    check_field_offset(lv, v1, 0, "C_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_D, C_BFu8s_D)
//============================================================================


struct  C_BFu8s_F  {
  char v1;
  unsigned short v2:8;
  float v3;
};
//SIG(1 C_BFu8s_F) C1{ Fc Fs:8 Fi}



static void Test_C_BFu8s_F()
{
  {
    init_simple_test("C_BFu8s_F");
    static STRUCT_IF_C C_BFu8s_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_F)");
    check_field_offset(lv, v1, 0, "C_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_F");
    check_field_offset(lv, v3, 4, "C_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_F, C_BFu8s_F)
//============================================================================


struct  C_BFu8s_I  {
  char v1;
  unsigned short v2:8;
  int v3;
};
//SIG(1 C_BFu8s_I) C1{ Fc Fs:8 Fi}



static void Test_C_BFu8s_I()
{
  {
    init_simple_test("C_BFu8s_I");
    static STRUCT_IF_C C_BFu8s_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_I)");
    check_field_offset(lv, v1, 0, "C_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_I");
    check_field_offset(lv, v3, 4, "C_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_I, C_BFu8s_I)
//============================================================================


struct  C_BFu8s_Ip  {
  char v1;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 C_BFu8s_Ip) C1{ Fc Fs:8 Fp}



static void Test_C_BFu8s_Ip()
{
  {
    init_simple_test("C_BFu8s_Ip");
    static STRUCT_IF_C C_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_Ip, C_BFu8s_Ip)
//============================================================================


struct  C_BFu8s_L  {
  char v1;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 C_BFu8s_L) C1{ Fc Fs:8 FL}



static void Test_C_BFu8s_L()
{
  {
    init_simple_test("C_BFu8s_L");
    static STRUCT_IF_C C_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_L)");
    check_field_offset(lv, v1, 0, "C_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_L, C_BFu8s_L)
//============================================================================


struct  C_BFu8s_S  {
  char v1;
  unsigned short v2:8;
  short v3;
};
//SIG(1 C_BFu8s_S) C1{ Fc Fs:8 Fs}



static void Test_C_BFu8s_S()
{
  {
    init_simple_test("C_BFu8s_S");
    static STRUCT_IF_C C_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_S)");
    check_field_offset(lv, v1, 0, "C_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_S");
    check_field_offset(lv, v3, 2, "C_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_S, C_BFu8s_S)
//============================================================================


struct  C_BFu8s_Uc  {
  char v1;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 C_BFu8s_Uc) C1{ Fc Fs:8 Fc}



static void Test_C_BFu8s_Uc()
{
  {
    init_simple_test("C_BFu8s_Uc");
    static STRUCT_IF_C C_BFu8s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_Uc");
    check_field_offset(lv, v3, 2, "C_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_Uc, C_BFu8s_Uc)
//============================================================================


struct  C_BFu8s_Ui  {
  char v1;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 C_BFu8s_Ui) C1{ Fc Fs:8 Fi}



static void Test_C_BFu8s_Ui()
{
  {
    init_simple_test("C_BFu8s_Ui");
    static STRUCT_IF_C C_BFu8s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu8s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_Ui");
    check_field_offset(lv, v3, 4, "C_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_Ui, C_BFu8s_Ui)
//============================================================================


struct  C_BFu8s_Ul  {
  char v1;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 C_BFu8s_Ul) C1{ Fc Fs:8 FL}



static void Test_C_BFu8s_Ul()
{
  {
    init_simple_test("C_BFu8s_Ul");
    static STRUCT_IF_C C_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_Ul, C_BFu8s_Ul)
//============================================================================


struct  C_BFu8s_Us  {
  char v1;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 C_BFu8s_Us) C1{ Fc Fs:8 Fs}



static void Test_C_BFu8s_Us()
{
  {
    init_simple_test("C_BFu8s_Us");
    static STRUCT_IF_C C_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "C_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_Us");
    check_field_offset(lv, v3, 2, "C_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_Us, C_BFu8s_Us)
//============================================================================


struct  C_BFu8s_Vp  {
  char v1;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 C_BFu8s_Vp) C1{ Fc Fs:8 Fp}



static void Test_C_BFu8s_Vp()
{
  {
    init_simple_test("C_BFu8s_Vp");
    static STRUCT_IF_C C_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu8s_Vp, C_BFu8s_Vp)
//============================================================================


struct  C_BFu9i  {
  char v1;
  unsigned int v2:9;
};
//SIG(1 C_BFu9i) C1{ Fc Fi:9}



static void Test_C_BFu9i()
{
  {
    init_simple_test("C_BFu9i");
    static STRUCT_IF_C C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i, C_BFu9i)
//============================================================================


struct  C_BFu9i_BFu15i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 C_BFu9i_BFu15i) C1{ Fc Fi:9 Fi:15}



static void Test_C_BFu9i_BFu15i()
{
  {
    init_simple_test("C_BFu9i_BFu15i");
    static STRUCT_IF_C C_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "C_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "C_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu15i, C_BFu9i_BFu15i)
//============================================================================


struct  C_BFu9i_BFu15ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 C_BFu9i_BFu15ll) C1{ Fc Fi:9 FL:15}



static void Test_C_BFu9i_BFu15ll()
{
  {
    init_simple_test("C_BFu9i_BFu15ll");
    static STRUCT_IF_C C_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "C_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "C_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu15ll, C_BFu9i_BFu15ll)
//============================================================================


struct  C_BFu9i_BFu15s  {
  char v1;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 C_BFu9i_BFu15s) C1{ Fc Fi:9 Fs:15}



static void Test_C_BFu9i_BFu15s()
{
  {
    init_simple_test("C_BFu9i_BFu15s");
    static STRUCT_IF_C C_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "C_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "C_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu15s, C_BFu9i_BFu15s)
//============================================================================


struct  C_BFu9i_BFu16i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 C_BFu9i_BFu16i) C1{ Fc Fi:9 Fi:16}



static void Test_C_BFu9i_BFu16i()
{
  {
    init_simple_test("C_BFu9i_BFu16i");
    static STRUCT_IF_C C_BFu9i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu16i, C_BFu9i_BFu16i)
//============================================================================


struct  C_BFu9i_BFu16ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 C_BFu9i_BFu16ll) C1{ Fc Fi:9 FL:16}



static void Test_C_BFu9i_BFu16ll()
{
  {
    init_simple_test("C_BFu9i_BFu16ll");
    static STRUCT_IF_C C_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "C_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "C_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu16ll, C_BFu9i_BFu16ll)
//============================================================================


struct  C_BFu9i_BFu16s  {
  char v1;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 C_BFu9i_BFu16s) C1{ Fc Fi:9 Fs:16}



static void Test_C_BFu9i_BFu16s()
{
  {
    init_simple_test("C_BFu9i_BFu16s");
    static STRUCT_IF_C C_BFu9i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu16s, C_BFu9i_BFu16s)
//============================================================================


struct  C_BFu9i_BFu17i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 C_BFu9i_BFu17i) C1{ Fc Fi:9 Fi:17}



static void Test_C_BFu9i_BFu17i()
{
  {
    init_simple_test("C_BFu9i_BFu17i");
    static STRUCT_IF_C C_BFu9i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu17i, C_BFu9i_BFu17i)
//============================================================================


struct  C_BFu9i_BFu17ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 C_BFu9i_BFu17ll) C1{ Fc Fi:9 FL:17}



static void Test_C_BFu9i_BFu17ll()
{
  {
    init_simple_test("C_BFu9i_BFu17ll");
    static STRUCT_IF_C C_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "C_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "C_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu17ll, C_BFu9i_BFu17ll)
//============================================================================


struct  C_BFu9i_BFu1c  {
  char v1;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 C_BFu9i_BFu1c) C1{ Fc Fi:9 Fc:1}



static void Test_C_BFu9i_BFu1c()
{
  {
    init_simple_test("C_BFu9i_BFu1c");
    static STRUCT_IF_C C_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "C_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu1c, C_BFu9i_BFu1c)
//============================================================================


struct  C_BFu9i_BFu1i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 C_BFu9i_BFu1i) C1{ Fc Fi:9 Fi:1}



static void Test_C_BFu9i_BFu1i()
{
  {
    init_simple_test("C_BFu9i_BFu1i");
    static STRUCT_IF_C C_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "C_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu1i, C_BFu9i_BFu1i)
//============================================================================


struct  C_BFu9i_BFu1ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 C_BFu9i_BFu1ll) C1{ Fc Fi:9 FL:1}



static void Test_C_BFu9i_BFu1ll()
{
  {
    init_simple_test("C_BFu9i_BFu1ll");
    static STRUCT_IF_C C_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "C_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu1ll, C_BFu9i_BFu1ll)
//============================================================================


struct  C_BFu9i_BFu1s  {
  char v1;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 C_BFu9i_BFu1s) C1{ Fc Fi:9 Fs:1}



static void Test_C_BFu9i_BFu1s()
{
  {
    init_simple_test("C_BFu9i_BFu1s");
    static STRUCT_IF_C C_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "C_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu1s, C_BFu9i_BFu1s)
//============================================================================


struct  C_BFu9i_BFu31i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 C_BFu9i_BFu31i) C1{ Fc Fi:9 Fi:31}



static void Test_C_BFu9i_BFu31i()
{
  {
    init_simple_test("C_BFu9i_BFu31i");
    static STRUCT_IF_C C_BFu9i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu31i, C_BFu9i_BFu31i)
//============================================================================


struct  C_BFu9i_BFu31ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 C_BFu9i_BFu31ll) C1{ Fc Fi:9 FL:31}



static void Test_C_BFu9i_BFu31ll()
{
  {
    init_simple_test("C_BFu9i_BFu31ll");
    static STRUCT_IF_C C_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "C_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "C_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu31ll, C_BFu9i_BFu31ll)
//============================================================================


struct  C_BFu9i_BFu32i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 C_BFu9i_BFu32i) C1{ Fc Fi:9 Fi:32}



static void Test_C_BFu9i_BFu32i()
{
  {
    init_simple_test("C_BFu9i_BFu32i");
    static STRUCT_IF_C C_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu32i, C_BFu9i_BFu32i)
//============================================================================


struct  C_BFu9i_BFu32ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 C_BFu9i_BFu32ll) C1{ Fc Fi:9 FL:32}



static void Test_C_BFu9i_BFu32ll()
{
  {
    init_simple_test("C_BFu9i_BFu32ll");
    static STRUCT_IF_C C_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "C_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "C_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu32ll, C_BFu9i_BFu32ll)
//============================================================================


struct  C_BFu9i_BFu33  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 C_BFu9i_BFu33) C1{ Fc Fi:9 FL:33}



static void Test_C_BFu9i_BFu33()
{
  {
    init_simple_test("C_BFu9i_BFu33");
    static STRUCT_IF_C C_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "C_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "C_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu33, C_BFu9i_BFu33)
//============================================================================


struct  C_BFu9i_BFu7c  {
  char v1;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 C_BFu9i_BFu7c) C1{ Fc Fi:9 Fc:7}



static void Test_C_BFu9i_BFu7c()
{
  {
    init_simple_test("C_BFu9i_BFu7c");
    static STRUCT_IF_C C_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "C_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "C_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu7c, C_BFu9i_BFu7c)
//============================================================================


struct  C_BFu9i_BFu7i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 C_BFu9i_BFu7i) C1{ Fc Fi:9 Fi:7}



static void Test_C_BFu9i_BFu7i()
{
  {
    init_simple_test("C_BFu9i_BFu7i");
    static STRUCT_IF_C C_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "C_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "C_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu7i, C_BFu9i_BFu7i)
//============================================================================


struct  C_BFu9i_BFu7ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 C_BFu9i_BFu7ll) C1{ Fc Fi:9 FL:7}



static void Test_C_BFu9i_BFu7ll()
{
  {
    init_simple_test("C_BFu9i_BFu7ll");
    static STRUCT_IF_C C_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "C_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "C_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu7ll, C_BFu9i_BFu7ll)
//============================================================================


struct  C_BFu9i_BFu7s  {
  char v1;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 C_BFu9i_BFu7s) C1{ Fc Fi:9 Fs:7}



static void Test_C_BFu9i_BFu7s()
{
  {
    init_simple_test("C_BFu9i_BFu7s");
    static STRUCT_IF_C C_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "C_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "C_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu7s, C_BFu9i_BFu7s)
//============================================================================


struct  C_BFu9i_BFu8c  {
  char v1;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 C_BFu9i_BFu8c) C1{ Fc Fi:9 Fc:8}



static void Test_C_BFu9i_BFu8c()
{
  {
    init_simple_test("C_BFu9i_BFu8c");
    static STRUCT_IF_C C_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu8c, C_BFu9i_BFu8c)
//============================================================================


struct  C_BFu9i_BFu8i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 C_BFu9i_BFu8i) C1{ Fc Fi:9 Fi:8}



static void Test_C_BFu9i_BFu8i()
{
  {
    init_simple_test("C_BFu9i_BFu8i");
    static STRUCT_IF_C C_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "C_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "C_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu8i, C_BFu9i_BFu8i)
//============================================================================


struct  C_BFu9i_BFu8ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 C_BFu9i_BFu8ll) C1{ Fc Fi:9 FL:8}



static void Test_C_BFu9i_BFu8ll()
{
  {
    init_simple_test("C_BFu9i_BFu8ll");
    static STRUCT_IF_C C_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "C_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "C_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu8ll, C_BFu9i_BFu8ll)
//============================================================================


struct  C_BFu9i_BFu8s  {
  char v1;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 C_BFu9i_BFu8s) C1{ Fc Fi:9 Fs:8}



static void Test_C_BFu9i_BFu8s()
{
  {
    init_simple_test("C_BFu9i_BFu8s");
    static STRUCT_IF_C C_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "C_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "C_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu8s, C_BFu9i_BFu8s)
//============================================================================


struct  C_BFu9i_BFu9i  {
  char v1;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 C_BFu9i_BFu9i) C1{ Fc Fi:9 Fi:9}



static void Test_C_BFu9i_BFu9i()
{
  {
    init_simple_test("C_BFu9i_BFu9i");
    static STRUCT_IF_C C_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "C_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "C_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu9i, C_BFu9i_BFu9i)
//============================================================================


struct  C_BFu9i_BFu9ll  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 C_BFu9i_BFu9ll) C1{ Fc Fi:9 FL:9}



static void Test_C_BFu9i_BFu9ll()
{
  {
    init_simple_test("C_BFu9i_BFu9ll");
    static STRUCT_IF_C C_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "C_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "C_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu9ll, C_BFu9i_BFu9ll)
//============================================================================


struct  C_BFu9i_BFu9s  {
  char v1;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 C_BFu9i_BFu9s) C1{ Fc Fi:9 Fs:9}



static void Test_C_BFu9i_BFu9s()
{
  {
    init_simple_test("C_BFu9i_BFu9s");
    static STRUCT_IF_C C_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "C_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "C_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_BFu9s, C_BFu9i_BFu9s)
//============================================================================


struct  C_BFu9i_C  {
  char v1;
  unsigned int v2:9;
  char v3;
};
//SIG(1 C_BFu9i_C) C1{ Fc Fi:9 Fc}



static void Test_C_BFu9i_C()
{
  {
    init_simple_test("C_BFu9i_C");
    static STRUCT_IF_C C_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_C)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_C)");
    check_field_offset(lv, v1, 0, "C_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_C");
    check_field_offset(lv, v3, 3, "C_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_C, C_BFu9i_C)
//============================================================================


struct  C_BFu9i_D  {
  char v1;
  unsigned int v2:9;
  double v3;
};
//SIG(1 C_BFu9i_D) C1{ Fc Fi:9 FL}



static void Test_C_BFu9i_D()
{
  {
    init_simple_test("C_BFu9i_D");
    static STRUCT_IF_C C_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_D)");
    check_field_offset(lv, v1, 0, "C_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_D, C_BFu9i_D)
//============================================================================


struct  C_BFu9i_F  {
  char v1;
  unsigned int v2:9;
  float v3;
};
//SIG(1 C_BFu9i_F) C1{ Fc Fi:9 Fi}



static void Test_C_BFu9i_F()
{
  {
    init_simple_test("C_BFu9i_F");
    static STRUCT_IF_C C_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_F)");
    check_field_offset(lv, v1, 0, "C_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_F");
    check_field_offset(lv, v3, 4, "C_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_F, C_BFu9i_F)
//============================================================================


struct  C_BFu9i_I  {
  char v1;
  unsigned int v2:9;
  int v3;
};
//SIG(1 C_BFu9i_I) C1{ Fc Fi:9 Fi}



static void Test_C_BFu9i_I()
{
  {
    init_simple_test("C_BFu9i_I");
    static STRUCT_IF_C C_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_I)");
    check_field_offset(lv, v1, 0, "C_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_I");
    check_field_offset(lv, v3, 4, "C_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_I, C_BFu9i_I)
//============================================================================


struct  C_BFu9i_Ip  {
  char v1;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 C_BFu9i_Ip) C1{ Fc Fi:9 Fp}



static void Test_C_BFu9i_Ip()
{
  {
    init_simple_test("C_BFu9i_Ip");
    static STRUCT_IF_C C_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_Ip, C_BFu9i_Ip)
//============================================================================


struct  C_BFu9i_L  {
  char v1;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 C_BFu9i_L) C1{ Fc Fi:9 FL}



static void Test_C_BFu9i_L()
{
  {
    init_simple_test("C_BFu9i_L");
    static STRUCT_IF_C C_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_L)");
    check_field_offset(lv, v1, 0, "C_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_L, C_BFu9i_L)
//============================================================================


struct  C_BFu9i_S  {
  char v1;
  unsigned int v2:9;
  short v3;
};
//SIG(1 C_BFu9i_S) C1{ Fc Fi:9 Fs}



static void Test_C_BFu9i_S()
{
  {
    init_simple_test("C_BFu9i_S");
    static STRUCT_IF_C C_BFu9i_S lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_S)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_S)");
    check_field_offset(lv, v1, 0, "C_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_S");
    check_field_offset(lv, v3, 4, "C_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_S, C_BFu9i_S)
//============================================================================


struct  C_BFu9i_Uc  {
  char v1;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 C_BFu9i_Uc) C1{ Fc Fi:9 Fc}



static void Test_C_BFu9i_Uc()
{
  {
    init_simple_test("C_BFu9i_Uc");
    static STRUCT_IF_C C_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_Uc");
    check_field_offset(lv, v3, 3, "C_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_Uc, C_BFu9i_Uc)
//============================================================================


struct  C_BFu9i_Ui  {
  char v1;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 C_BFu9i_Ui) C1{ Fc Fi:9 Fi}



static void Test_C_BFu9i_Ui()
{
  {
    init_simple_test("C_BFu9i_Ui");
    static STRUCT_IF_C C_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_Ui");
    check_field_offset(lv, v3, 4, "C_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_Ui, C_BFu9i_Ui)
//============================================================================


struct  C_BFu9i_Ul  {
  char v1;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 C_BFu9i_Ul) C1{ Fc Fi:9 FL}



static void Test_C_BFu9i_Ul()
{
  {
    init_simple_test("C_BFu9i_Ul");
    static STRUCT_IF_C C_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_Ul, C_BFu9i_Ul)
//============================================================================


struct  C_BFu9i_Us  {
  char v1;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 C_BFu9i_Us) C1{ Fc Fi:9 Fs}



static void Test_C_BFu9i_Us()
{
  {
    init_simple_test("C_BFu9i_Us");
    static STRUCT_IF_C C_BFu9i_Us lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_Us");
    check_field_offset(lv, v3, 4, "C_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_Us, C_BFu9i_Us)
//============================================================================


struct  C_BFu9i_Vp  {
  char v1;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 C_BFu9i_Vp) C1{ Fc Fi:9 Fp}



static void Test_C_BFu9i_Vp()
{
  {
    init_simple_test("C_BFu9i_Vp");
    static STRUCT_IF_C C_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9i_Vp, C_BFu9i_Vp)
//============================================================================


struct  C_BFu9ll  {
  char v1;
  __tsu64 v2:9;
};
//SIG(1 C_BFu9ll) C1{ Fc FL:9}



static void Test_C_BFu9ll()
{
  {
    init_simple_test("C_BFu9ll");
    static STRUCT_IF_C C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll, C_BFu9ll)
//============================================================================


struct  C_BFu9ll_BFu15i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 C_BFu9ll_BFu15i) C1{ Fc FL:9 Fi:15}



static void Test_C_BFu9ll_BFu15i()
{
  {
    init_simple_test("C_BFu9ll_BFu15i");
    static STRUCT_IF_C C_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "C_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "C_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu15i, C_BFu9ll_BFu15i)
//============================================================================


struct  C_BFu9ll_BFu15ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 C_BFu9ll_BFu15ll) C1{ Fc FL:9 FL:15}



static void Test_C_BFu9ll_BFu15ll()
{
  {
    init_simple_test("C_BFu9ll_BFu15ll");
    static STRUCT_IF_C C_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "C_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "C_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu15ll, C_BFu9ll_BFu15ll)
//============================================================================


struct  C_BFu9ll_BFu15s  {
  char v1;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 C_BFu9ll_BFu15s) C1{ Fc FL:9 Fs:15}



static void Test_C_BFu9ll_BFu15s()
{
  {
    init_simple_test("C_BFu9ll_BFu15s");
    static STRUCT_IF_C C_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "C_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "C_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu15s, C_BFu9ll_BFu15s)
//============================================================================


struct  C_BFu9ll_BFu16i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 C_BFu9ll_BFu16i) C1{ Fc FL:9 Fi:16}



static void Test_C_BFu9ll_BFu16i()
{
  {
    init_simple_test("C_BFu9ll_BFu16i");
    static STRUCT_IF_C C_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu16i, C_BFu9ll_BFu16i)
//============================================================================


struct  C_BFu9ll_BFu16ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 C_BFu9ll_BFu16ll) C1{ Fc FL:9 FL:16}



static void Test_C_BFu9ll_BFu16ll()
{
  {
    init_simple_test("C_BFu9ll_BFu16ll");
    static STRUCT_IF_C C_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "C_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "C_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu16ll, C_BFu9ll_BFu16ll)
//============================================================================


struct  C_BFu9ll_BFu16s  {
  char v1;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 C_BFu9ll_BFu16s) C1{ Fc FL:9 Fs:16}



static void Test_C_BFu9ll_BFu16s()
{
  {
    init_simple_test("C_BFu9ll_BFu16s");
    static STRUCT_IF_C C_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu16s, C_BFu9ll_BFu16s)
//============================================================================


struct  C_BFu9ll_BFu17i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 C_BFu9ll_BFu17i) C1{ Fc FL:9 Fi:17}



static void Test_C_BFu9ll_BFu17i()
{
  {
    init_simple_test("C_BFu9ll_BFu17i");
    static STRUCT_IF_C C_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu17i, C_BFu9ll_BFu17i)
//============================================================================


struct  C_BFu9ll_BFu17ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 C_BFu9ll_BFu17ll) C1{ Fc FL:9 FL:17}



static void Test_C_BFu9ll_BFu17ll()
{
  {
    init_simple_test("C_BFu9ll_BFu17ll");
    static STRUCT_IF_C C_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "C_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "C_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu17ll, C_BFu9ll_BFu17ll)
//============================================================================


struct  C_BFu9ll_BFu1c  {
  char v1;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 C_BFu9ll_BFu1c) C1{ Fc FL:9 Fc:1}



static void Test_C_BFu9ll_BFu1c()
{
  {
    init_simple_test("C_BFu9ll_BFu1c");
    static STRUCT_IF_C C_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "C_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu1c, C_BFu9ll_BFu1c)
//============================================================================


struct  C_BFu9ll_BFu1i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 C_BFu9ll_BFu1i) C1{ Fc FL:9 Fi:1}



static void Test_C_BFu9ll_BFu1i()
{
  {
    init_simple_test("C_BFu9ll_BFu1i");
    static STRUCT_IF_C C_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "C_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu1i, C_BFu9ll_BFu1i)
//============================================================================


struct  C_BFu9ll_BFu1ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 C_BFu9ll_BFu1ll) C1{ Fc FL:9 FL:1}



static void Test_C_BFu9ll_BFu1ll()
{
  {
    init_simple_test("C_BFu9ll_BFu1ll");
    static STRUCT_IF_C C_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "C_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu1ll, C_BFu9ll_BFu1ll)
//============================================================================


struct  C_BFu9ll_BFu1s  {
  char v1;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 C_BFu9ll_BFu1s) C1{ Fc FL:9 Fs:1}



static void Test_C_BFu9ll_BFu1s()
{
  {
    init_simple_test("C_BFu9ll_BFu1s");
    static STRUCT_IF_C C_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "C_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu1s, C_BFu9ll_BFu1s)
//============================================================================


struct  C_BFu9ll_BFu31i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 C_BFu9ll_BFu31i) C1{ Fc FL:9 Fi:31}



static void Test_C_BFu9ll_BFu31i()
{
  {
    init_simple_test("C_BFu9ll_BFu31i");
    static STRUCT_IF_C C_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu31i, C_BFu9ll_BFu31i)
//============================================================================


struct  C_BFu9ll_BFu31ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 C_BFu9ll_BFu31ll) C1{ Fc FL:9 FL:31}



static void Test_C_BFu9ll_BFu31ll()
{
  {
    init_simple_test("C_BFu9ll_BFu31ll");
    static STRUCT_IF_C C_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "C_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "C_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu31ll, C_BFu9ll_BFu31ll)
//============================================================================


struct  C_BFu9ll_BFu32i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 C_BFu9ll_BFu32i) C1{ Fc FL:9 Fi:32}



static void Test_C_BFu9ll_BFu32i()
{
  {
    init_simple_test("C_BFu9ll_BFu32i");
    static STRUCT_IF_C C_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu32i, C_BFu9ll_BFu32i)
//============================================================================


struct  C_BFu9ll_BFu32ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 C_BFu9ll_BFu32ll) C1{ Fc FL:9 FL:32}



static void Test_C_BFu9ll_BFu32ll()
{
  {
    init_simple_test("C_BFu9ll_BFu32ll");
    static STRUCT_IF_C C_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "C_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "C_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu32ll, C_BFu9ll_BFu32ll)
//============================================================================


struct  C_BFu9ll_BFu33  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 C_BFu9ll_BFu33) C1{ Fc FL:9 FL:33}



static void Test_C_BFu9ll_BFu33()
{
  {
    init_simple_test("C_BFu9ll_BFu33");
    static STRUCT_IF_C C_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "C_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "C_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu33, C_BFu9ll_BFu33)
//============================================================================


struct  C_BFu9ll_BFu7c  {
  char v1;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 C_BFu9ll_BFu7c) C1{ Fc FL:9 Fc:7}



static void Test_C_BFu9ll_BFu7c()
{
  {
    init_simple_test("C_BFu9ll_BFu7c");
    static STRUCT_IF_C C_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "C_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "C_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu7c, C_BFu9ll_BFu7c)
//============================================================================


struct  C_BFu9ll_BFu7i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:7;
};
//SIG(1 C_BFu9ll_BFu7i) C1{ Fc FL:9 Fi:7}



static void Test_C_BFu9ll_BFu7i()
{
  {
    init_simple_test("C_BFu9ll_BFu7i");
    static STRUCT_IF_C C_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "C_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "C_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu7i, C_BFu9ll_BFu7i)
//============================================================================


struct  C_BFu9ll_BFu7ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:7;
};
//SIG(1 C_BFu9ll_BFu7ll) C1{ Fc FL:9 FL:7}



static void Test_C_BFu9ll_BFu7ll()
{
  {
    init_simple_test("C_BFu9ll_BFu7ll");
    static STRUCT_IF_C C_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "C_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "C_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu7ll, C_BFu9ll_BFu7ll)
//============================================================================


struct  C_BFu9ll_BFu7s  {
  char v1;
  __tsu64 v2:9;
  unsigned short v3:7;
};
//SIG(1 C_BFu9ll_BFu7s) C1{ Fc FL:9 Fs:7}



static void Test_C_BFu9ll_BFu7s()
{
  {
    init_simple_test("C_BFu9ll_BFu7s");
    static STRUCT_IF_C C_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "C_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "C_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu7s, C_BFu9ll_BFu7s)
//============================================================================


struct  C_BFu9ll_BFu8c  {
  char v1;
  __tsu64 v2:9;
  unsigned char v3:8;
};
//SIG(1 C_BFu9ll_BFu8c) C1{ Fc FL:9 Fc:8}



static void Test_C_BFu9ll_BFu8c()
{
  {
    init_simple_test("C_BFu9ll_BFu8c");
    static STRUCT_IF_C C_BFu9ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu8c, C_BFu9ll_BFu8c)
//============================================================================


struct  C_BFu9ll_BFu8i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:8;
};
//SIG(1 C_BFu9ll_BFu8i) C1{ Fc FL:9 Fi:8}



static void Test_C_BFu9ll_BFu8i()
{
  {
    init_simple_test("C_BFu9ll_BFu8i");
    static STRUCT_IF_C C_BFu9ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "C_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "C_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu8i, C_BFu9ll_BFu8i)
//============================================================================


struct  C_BFu9ll_BFu8ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:8;
};
//SIG(1 C_BFu9ll_BFu8ll) C1{ Fc FL:9 FL:8}



static void Test_C_BFu9ll_BFu8ll()
{
  {
    init_simple_test("C_BFu9ll_BFu8ll");
    static STRUCT_IF_C C_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "C_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "C_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu8ll, C_BFu9ll_BFu8ll)
//============================================================================


struct  C_BFu9ll_BFu8s  {
  char v1;
  __tsu64 v2:9;
  unsigned short v3:8;
};
//SIG(1 C_BFu9ll_BFu8s) C1{ Fc FL:9 Fs:8}



static void Test_C_BFu9ll_BFu8s()
{
  {
    init_simple_test("C_BFu9ll_BFu8s");
    static STRUCT_IF_C C_BFu9ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "C_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "C_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu8s, C_BFu9ll_BFu8s)
//============================================================================


struct  C_BFu9ll_BFu9i  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 C_BFu9ll_BFu9i) C1{ Fc FL:9 Fi:9}



static void Test_C_BFu9ll_BFu9i()
{
  {
    init_simple_test("C_BFu9ll_BFu9i");
    static STRUCT_IF_C C_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "C_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu9i, C_BFu9ll_BFu9i)
//============================================================================


struct  C_BFu9ll_BFu9ll  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 C_BFu9ll_BFu9ll) C1{ Fc FL:9 FL:9}



static void Test_C_BFu9ll_BFu9ll()
{
  {
    init_simple_test("C_BFu9ll_BFu9ll");
    static STRUCT_IF_C C_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "C_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu9ll, C_BFu9ll_BFu9ll)
//============================================================================


struct  C_BFu9ll_BFu9s  {
  char v1;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 C_BFu9ll_BFu9s) C1{ Fc FL:9 Fs:9}



static void Test_C_BFu9ll_BFu9s()
{
  {
    init_simple_test("C_BFu9ll_BFu9s");
    static STRUCT_IF_C C_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "C_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "C_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_BFu9s, C_BFu9ll_BFu9s)
//============================================================================


struct  C_BFu9ll_C  {
  char v1;
  __tsu64 v2:9;
  char v3;
};
//SIG(1 C_BFu9ll_C) C1{ Fc FL:9 Fc}



static void Test_C_BFu9ll_C()
{
  {
    init_simple_test("C_BFu9ll_C");
    static STRUCT_IF_C C_BFu9ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_C");
    check_field_offset(lv, v3, 3, "C_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_C, C_BFu9ll_C)
//============================================================================


struct  C_BFu9ll_D  {
  char v1;
  __tsu64 v2:9;
  double v3;
};
//SIG(1 C_BFu9ll_D) C1{ Fc FL:9 FL}



static void Test_C_BFu9ll_D()
{
  {
    init_simple_test("C_BFu9ll_D");
    static STRUCT_IF_C C_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_D, C_BFu9ll_D)
//============================================================================


struct  C_BFu9ll_F  {
  char v1;
  __tsu64 v2:9;
  float v3;
};
//SIG(1 C_BFu9ll_F) C1{ Fc FL:9 Fi}



static void Test_C_BFu9ll_F()
{
  {
    init_simple_test("C_BFu9ll_F");
    static STRUCT_IF_C C_BFu9ll_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_F");
    check_field_offset(lv, v3, 4, "C_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_F, C_BFu9ll_F)
//============================================================================


struct  C_BFu9ll_I  {
  char v1;
  __tsu64 v2:9;
  int v3;
};
//SIG(1 C_BFu9ll_I) C1{ Fc FL:9 Fi}



static void Test_C_BFu9ll_I()
{
  {
    init_simple_test("C_BFu9ll_I");
    static STRUCT_IF_C C_BFu9ll_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_I");
    check_field_offset(lv, v3, 4, "C_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_I, C_BFu9ll_I)
//============================================================================


struct  C_BFu9ll_Ip  {
  char v1;
  __tsu64 v2:9;
  int *v3;
};
//SIG(1 C_BFu9ll_Ip) C1{ Fc FL:9 Fp}



static void Test_C_BFu9ll_Ip()
{
  {
    init_simple_test("C_BFu9ll_Ip");
    static STRUCT_IF_C C_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_Ip, C_BFu9ll_Ip)
//============================================================================


struct  C_BFu9ll_L  {
  char v1;
  __tsu64 v2:9;
  __tsi64 v3;
};
//SIG(1 C_BFu9ll_L) C1{ Fc FL:9 FL}



static void Test_C_BFu9ll_L()
{
  {
    init_simple_test("C_BFu9ll_L");
    static STRUCT_IF_C C_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_L, C_BFu9ll_L)
//============================================================================


struct  C_BFu9ll_S  {
  char v1;
  __tsu64 v2:9;
  short v3;
};
//SIG(1 C_BFu9ll_S) C1{ Fc FL:9 Fs}



static void Test_C_BFu9ll_S()
{
  {
    init_simple_test("C_BFu9ll_S");
    static STRUCT_IF_C C_BFu9ll_S lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_S");
    check_field_offset(lv, v3, 4, "C_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_S, C_BFu9ll_S)
//============================================================================


struct  C_BFu9ll_Uc  {
  char v1;
  __tsu64 v2:9;
  unsigned char v3;
};
//SIG(1 C_BFu9ll_Uc) C1{ Fc FL:9 Fc}



static void Test_C_BFu9ll_Uc()
{
  {
    init_simple_test("C_BFu9ll_Uc");
    static STRUCT_IF_C C_BFu9ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_Uc");
    check_field_offset(lv, v3, 3, "C_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_Uc, C_BFu9ll_Uc)
//============================================================================


struct  C_BFu9ll_Ui  {
  char v1;
  __tsu64 v2:9;
  unsigned int v3;
};
//SIG(1 C_BFu9ll_Ui) C1{ Fc FL:9 Fi}



static void Test_C_BFu9ll_Ui()
{
  {
    init_simple_test("C_BFu9ll_Ui");
    static STRUCT_IF_C C_BFu9ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_Ui");
    check_field_offset(lv, v3, 4, "C_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_Ui, C_BFu9ll_Ui)
//============================================================================


struct  C_BFu9ll_Ul  {
  char v1;
  __tsu64 v2:9;
  __tsu64 v3;
};
//SIG(1 C_BFu9ll_Ul) C1{ Fc FL:9 FL}



static void Test_C_BFu9ll_Ul()
{
  {
    init_simple_test("C_BFu9ll_Ul");
    static STRUCT_IF_C C_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_Ul, C_BFu9ll_Ul)
//============================================================================


struct  C_BFu9ll_Us  {
  char v1;
  __tsu64 v2:9;
  unsigned short v3;
};
//SIG(1 C_BFu9ll_Us) C1{ Fc FL:9 Fs}



static void Test_C_BFu9ll_Us()
{
  {
    init_simple_test("C_BFu9ll_Us");
    static STRUCT_IF_C C_BFu9ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_Us");
    check_field_offset(lv, v3, 4, "C_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_Us, C_BFu9ll_Us)
//============================================================================


struct  C_BFu9ll_Vp  {
  char v1;
  __tsu64 v2:9;
  void *v3;
};
//SIG(1 C_BFu9ll_Vp) C1{ Fc FL:9 Fp}



static void Test_C_BFu9ll_Vp()
{
  {
    init_simple_test("C_BFu9ll_Vp");
    static STRUCT_IF_C C_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9ll_Vp, C_BFu9ll_Vp)
//============================================================================


struct  C_BFu9s  {
  char v1;
  unsigned short v2:9;
};
//SIG(1 C_BFu9s) C1{ Fc Fs:9}



static void Test_C_BFu9s()
{
  {
    init_simple_test("C_BFu9s");
    static STRUCT_IF_C C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s, C_BFu9s)
//============================================================================


struct  C_BFu9s_BFu15i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:15;
};
//SIG(1 C_BFu9s_BFu15i) C1{ Fc Fs:9 Fi:15}



static void Test_C_BFu9s_BFu15i()
{
  {
    init_simple_test("C_BFu9s_BFu15i");
    static STRUCT_IF_C C_BFu9s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "C_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "C_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu15i, C_BFu9s_BFu15i)
//============================================================================


struct  C_BFu9s_BFu15ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:15;
};
//SIG(1 C_BFu9s_BFu15ll) C1{ Fc Fs:9 FL:15}



static void Test_C_BFu9s_BFu15ll()
{
  {
    init_simple_test("C_BFu9s_BFu15ll");
    static STRUCT_IF_C C_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "C_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "C_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu15ll, C_BFu9s_BFu15ll)
//============================================================================


struct  C_BFu9s_BFu15s  {
  char v1;
  unsigned short v2:9;
  unsigned short v3:15;
};
//SIG(1 C_BFu9s_BFu15s) C1{ Fc Fs:9 Fs:15}



static void Test_C_BFu9s_BFu15s()
{
  {
    init_simple_test("C_BFu9s_BFu15s");
    static STRUCT_IF_C C_BFu9s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "C_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "C_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu15s, C_BFu9s_BFu15s)
//============================================================================


struct  C_BFu9s_BFu16i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:16;
};
//SIG(1 C_BFu9s_BFu16i) C1{ Fc Fs:9 Fi:16}



static void Test_C_BFu9s_BFu16i()
{
  {
    init_simple_test("C_BFu9s_BFu16i");
    static STRUCT_IF_C C_BFu9s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu16i, C_BFu9s_BFu16i)
//============================================================================


struct  C_BFu9s_BFu16ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:16;
};
//SIG(1 C_BFu9s_BFu16ll) C1{ Fc Fs:9 FL:16}



static void Test_C_BFu9s_BFu16ll()
{
  {
    init_simple_test("C_BFu9s_BFu16ll");
    static STRUCT_IF_C C_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "C_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "C_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu16ll, C_BFu9s_BFu16ll)
//============================================================================


struct  C_BFu9s_BFu16s  {
  char v1;
  unsigned short v2:9;
  unsigned short v3:16;
};
//SIG(1 C_BFu9s_BFu16s) C1{ Fc Fs:9 Fs:16}



static void Test_C_BFu9s_BFu16s()
{
  {
    init_simple_test("C_BFu9s_BFu16s");
    static STRUCT_IF_C C_BFu9s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu16s, C_BFu9s_BFu16s)
//============================================================================


struct  C_BFu9s_BFu17i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:17;
};
//SIG(1 C_BFu9s_BFu17i) C1{ Fc Fs:9 Fi:17}



static void Test_C_BFu9s_BFu17i()
{
  {
    init_simple_test("C_BFu9s_BFu17i");
    static STRUCT_IF_C C_BFu9s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu17i, C_BFu9s_BFu17i)
//============================================================================


struct  C_BFu9s_BFu17ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:17;
};
//SIG(1 C_BFu9s_BFu17ll) C1{ Fc Fs:9 FL:17}



static void Test_C_BFu9s_BFu17ll()
{
  {
    init_simple_test("C_BFu9s_BFu17ll");
    static STRUCT_IF_C C_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "C_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "C_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu17ll, C_BFu9s_BFu17ll)
//============================================================================


struct  C_BFu9s_BFu1c  {
  char v1;
  unsigned short v2:9;
  unsigned char v3:1;
};
//SIG(1 C_BFu9s_BFu1c) C1{ Fc Fs:9 Fc:1}



static void Test_C_BFu9s_BFu1c()
{
  {
    init_simple_test("C_BFu9s_BFu1c");
    static STRUCT_IF_C C_BFu9s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu1c, C_BFu9s_BFu1c)
//============================================================================


struct  C_BFu9s_BFu1i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:1;
};
//SIG(1 C_BFu9s_BFu1i) C1{ Fc Fs:9 Fi:1}



static void Test_C_BFu9s_BFu1i()
{
  {
    init_simple_test("C_BFu9s_BFu1i");
    static STRUCT_IF_C C_BFu9s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu1i, C_BFu9s_BFu1i)
//============================================================================


struct  C_BFu9s_BFu1ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:1;
};
//SIG(1 C_BFu9s_BFu1ll) C1{ Fc Fs:9 FL:1}



static void Test_C_BFu9s_BFu1ll()
{
  {
    init_simple_test("C_BFu9s_BFu1ll");
    static STRUCT_IF_C C_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu1ll, C_BFu9s_BFu1ll)
//============================================================================


struct  C_BFu9s_BFu1s  {
  char v1;
  unsigned short v2:9;
  unsigned short v3:1;
};
//SIG(1 C_BFu9s_BFu1s) C1{ Fc Fs:9 Fs:1}



static void Test_C_BFu9s_BFu1s()
{
  {
    init_simple_test("C_BFu9s_BFu1s");
    static STRUCT_IF_C C_BFu9s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu1s, C_BFu9s_BFu1s)
//============================================================================


struct  C_BFu9s_BFu31i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:31;
};
//SIG(1 C_BFu9s_BFu31i) C1{ Fc Fs:9 Fi:31}



static void Test_C_BFu9s_BFu31i()
{
  {
    init_simple_test("C_BFu9s_BFu31i");
    static STRUCT_IF_C C_BFu9s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu31i, C_BFu9s_BFu31i)
//============================================================================


struct  C_BFu9s_BFu31ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:31;
};
//SIG(1 C_BFu9s_BFu31ll) C1{ Fc Fs:9 FL:31}



static void Test_C_BFu9s_BFu31ll()
{
  {
    init_simple_test("C_BFu9s_BFu31ll");
    static STRUCT_IF_C C_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "C_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "C_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu31ll, C_BFu9s_BFu31ll)
//============================================================================


struct  C_BFu9s_BFu32i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:32;
};
//SIG(1 C_BFu9s_BFu32i) C1{ Fc Fs:9 Fi:32}



static void Test_C_BFu9s_BFu32i()
{
  {
    init_simple_test("C_BFu9s_BFu32i");
    static STRUCT_IF_C C_BFu9s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu32i, C_BFu9s_BFu32i)
//============================================================================


struct  C_BFu9s_BFu32ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:32;
};
//SIG(1 C_BFu9s_BFu32ll) C1{ Fc Fs:9 FL:32}



static void Test_C_BFu9s_BFu32ll()
{
  {
    init_simple_test("C_BFu9s_BFu32ll");
    static STRUCT_IF_C C_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "C_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "C_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu32ll, C_BFu9s_BFu32ll)
//============================================================================


struct  C_BFu9s_BFu33  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:33;
};
//SIG(1 C_BFu9s_BFu33) C1{ Fc Fs:9 FL:33}



static void Test_C_BFu9s_BFu33()
{
  {
    init_simple_test("C_BFu9s_BFu33");
    static STRUCT_IF_C C_BFu9s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "C_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "C_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu33, C_BFu9s_BFu33)
//============================================================================


struct  C_BFu9s_BFu7c  {
  char v1;
  unsigned short v2:9;
  unsigned char v3:7;
};
//SIG(1 C_BFu9s_BFu7c) C1{ Fc Fs:9 Fc:7}



static void Test_C_BFu9s_BFu7c()
{
  {
    init_simple_test("C_BFu9s_BFu7c");
    static STRUCT_IF_C C_BFu9s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu7c, C_BFu9s_BFu7c)
//============================================================================


struct  C_BFu9s_BFu7i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:7;
};
//SIG(1 C_BFu9s_BFu7i) C1{ Fc Fs:9 Fi:7}



static void Test_C_BFu9s_BFu7i()
{
  {
    init_simple_test("C_BFu9s_BFu7i");
    static STRUCT_IF_C C_BFu9s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu7i, C_BFu9s_BFu7i)
//============================================================================


struct  C_BFu9s_BFu7ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:7;
};
//SIG(1 C_BFu9s_BFu7ll) C1{ Fc Fs:9 FL:7}



static void Test_C_BFu9s_BFu7ll()
{
  {
    init_simple_test("C_BFu9s_BFu7ll");
    static STRUCT_IF_C C_BFu9s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu7ll, C_BFu9s_BFu7ll)
//============================================================================


struct  C_BFu9s_BFu7s  {
  char v1;
  unsigned short v2:9;
  unsigned short v3:7;
};
//SIG(1 C_BFu9s_BFu7s) C1{ Fc Fs:9 Fs:7}



static void Test_C_BFu9s_BFu7s()
{
  {
    init_simple_test("C_BFu9s_BFu7s");
    static STRUCT_IF_C C_BFu9s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu7s, C_BFu9s_BFu7s)
//============================================================================


struct  C_BFu9s_BFu8c  {
  char v1;
  unsigned short v2:9;
  unsigned char v3:8;
};
//SIG(1 C_BFu9s_BFu8c) C1{ Fc Fs:9 Fc:8}



static void Test_C_BFu9s_BFu8c()
{
  {
    init_simple_test("C_BFu9s_BFu8c");
    static STRUCT_IF_C C_BFu9s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu8c, C_BFu9s_BFu8c)
//============================================================================


struct  C_BFu9s_BFu8i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:8;
};
//SIG(1 C_BFu9s_BFu8i) C1{ Fc Fs:9 Fi:8}



static void Test_C_BFu9s_BFu8i()
{
  {
    init_simple_test("C_BFu9s_BFu8i");
    static STRUCT_IF_C C_BFu9s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu8i, C_BFu9s_BFu8i)
//============================================================================


struct  C_BFu9s_BFu8ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:8;
};
//SIG(1 C_BFu9s_BFu8ll) C1{ Fc Fs:9 FL:8}



static void Test_C_BFu9s_BFu8ll()
{
  {
    init_simple_test("C_BFu9s_BFu8ll");
    static STRUCT_IF_C C_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu8ll, C_BFu9s_BFu8ll)
//============================================================================


struct  C_BFu9s_BFu8s  {
  char v1;
  unsigned short v2:9;
  unsigned short v3:8;
};
//SIG(1 C_BFu9s_BFu8s) C1{ Fc Fs:9 Fs:8}



static void Test_C_BFu9s_BFu8s()
{
  {
    init_simple_test("C_BFu9s_BFu8s");
    static STRUCT_IF_C C_BFu9s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu8s, C_BFu9s_BFu8s)
//============================================================================


struct  C_BFu9s_BFu9i  {
  char v1;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 C_BFu9s_BFu9i) C1{ Fc Fs:9 Fi:9}



static void Test_C_BFu9s_BFu9i()
{
  {
    init_simple_test("C_BFu9s_BFu9i");
    static STRUCT_IF_C C_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "C_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu9i, C_BFu9s_BFu9i)
//============================================================================


struct  C_BFu9s_BFu9ll  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 C_BFu9s_BFu9ll) C1{ Fc Fs:9 FL:9}



static void Test_C_BFu9s_BFu9ll()
{
  {
    init_simple_test("C_BFu9s_BFu9ll");
    static STRUCT_IF_C C_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "C_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "C_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu9ll, C_BFu9s_BFu9ll)
//============================================================================


struct  C_BFu9s_BFu9s  {
  char v1;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 C_BFu9s_BFu9s) C1{ Fc Fs:9 Fs:9}



static void Test_C_BFu9s_BFu9s()
{
  {
    init_simple_test("C_BFu9s_BFu9s");
    static STRUCT_IF_C C_BFu9s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "C_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "C_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_BFu9s, C_BFu9s_BFu9s)
//============================================================================


struct  C_BFu9s_C  {
  char v1;
  unsigned short v2:9;
  char v3;
};
//SIG(1 C_BFu9s_C) C1{ Fc Fs:9 Fc}



static void Test_C_BFu9s_C()
{
  {
    init_simple_test("C_BFu9s_C");
    static STRUCT_IF_C C_BFu9s_C lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_C)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_C)");
    check_field_offset(lv, v1, 0, "C_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_C");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_C");
    check_field_offset(lv, v3, 4, "C_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_C, C_BFu9s_C)
//============================================================================


struct  C_BFu9s_D  {
  char v1;
  unsigned short v2:9;
  double v3;
};
//SIG(1 C_BFu9s_D) C1{ Fc Fs:9 FL}



static void Test_C_BFu9s_D()
{
  {
    init_simple_test("C_BFu9s_D");
    static STRUCT_IF_C C_BFu9s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_D)");
    check_field_offset(lv, v1, 0, "C_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_D");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_D, C_BFu9s_D)
//============================================================================


struct  C_BFu9s_F  {
  char v1;
  unsigned short v2:9;
  float v3;
};
//SIG(1 C_BFu9s_F) C1{ Fc Fs:9 Fi}



static void Test_C_BFu9s_F()
{
  {
    init_simple_test("C_BFu9s_F");
    static STRUCT_IF_C C_BFu9s_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_F)");
    check_field_offset(lv, v1, 0, "C_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_F");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_F");
    check_field_offset(lv, v3, 4, "C_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_F, C_BFu9s_F)
//============================================================================


struct  C_BFu9s_I  {
  char v1;
  unsigned short v2:9;
  int v3;
};
//SIG(1 C_BFu9s_I) C1{ Fc Fs:9 Fi}



static void Test_C_BFu9s_I()
{
  {
    init_simple_test("C_BFu9s_I");
    static STRUCT_IF_C C_BFu9s_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_I)");
    check_field_offset(lv, v1, 0, "C_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_I");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_I");
    check_field_offset(lv, v3, 4, "C_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_I, C_BFu9s_I)
//============================================================================


struct  C_BFu9s_Ip  {
  char v1;
  unsigned short v2:9;
  int *v3;
};
//SIG(1 C_BFu9s_Ip) C1{ Fc Fs:9 Fp}



static void Test_C_BFu9s_Ip()
{
  {
    init_simple_test("C_BFu9s_Ip");
    static STRUCT_IF_C C_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu9s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_Ip, C_BFu9s_Ip)
//============================================================================


struct  C_BFu9s_L  {
  char v1;
  unsigned short v2:9;
  __tsi64 v3;
};
//SIG(1 C_BFu9s_L) C1{ Fc Fs:9 FL}



static void Test_C_BFu9s_L()
{
  {
    init_simple_test("C_BFu9s_L");
    static STRUCT_IF_C C_BFu9s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_L)");
    check_field_offset(lv, v1, 0, "C_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_L");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_L, C_BFu9s_L)
//============================================================================


struct  C_BFu9s_S  {
  char v1;
  unsigned short v2:9;
  short v3;
};
//SIG(1 C_BFu9s_S) C1{ Fc Fs:9 Fs}



static void Test_C_BFu9s_S()
{
  {
    init_simple_test("C_BFu9s_S");
    static STRUCT_IF_C C_BFu9s_S lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_S)");
    check_field_offset(lv, v1, 0, "C_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_S");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_S");
    check_field_offset(lv, v3, 4, "C_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_S, C_BFu9s_S)
//============================================================================


struct  C_BFu9s_Uc  {
  char v1;
  unsigned short v2:9;
  unsigned char v3;
};
//SIG(1 C_BFu9s_Uc) C1{ Fc Fs:9 Fc}



static void Test_C_BFu9s_Uc()
{
  {
    init_simple_test("C_BFu9s_Uc");
    static STRUCT_IF_C C_BFu9s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_Uc");
    check_field_offset(lv, v3, 4, "C_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_Uc, C_BFu9s_Uc)
//============================================================================


struct  C_BFu9s_Ui  {
  char v1;
  unsigned short v2:9;
  unsigned int v3;
};
//SIG(1 C_BFu9s_Ui) C1{ Fc Fs:9 Fi}



static void Test_C_BFu9s_Ui()
{
  {
    init_simple_test("C_BFu9s_Ui");
    static STRUCT_IF_C C_BFu9s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu9s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_Ui");
    check_field_offset(lv, v3, 4, "C_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_Ui, C_BFu9s_Ui)
//============================================================================


struct  C_BFu9s_Ul  {
  char v1;
  unsigned short v2:9;
  __tsu64 v3;
};
//SIG(1 C_BFu9s_Ul) C1{ Fc Fs:9 FL}



static void Test_C_BFu9s_Ul()
{
  {
    init_simple_test("C_BFu9s_Ul");
    static STRUCT_IF_C C_BFu9s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_BFu9s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_Ul, C_BFu9s_Ul)
//============================================================================


struct  C_BFu9s_Us  {
  char v1;
  unsigned short v2:9;
  unsigned short v3;
};
//SIG(1 C_BFu9s_Us) C1{ Fc Fs:9 Fs}



static void Test_C_BFu9s_Us()
{
  {
    init_simple_test("C_BFu9s_Us");
    static STRUCT_IF_C C_BFu9s_Us lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "C_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_Us");
    check_field_offset(lv, v3, 4, "C_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_Us, C_BFu9s_Us)
//============================================================================


struct  C_BFu9s_Vp  {
  char v1;
  unsigned short v2:9;
  void *v3;
};
//SIG(1 C_BFu9s_Vp) C1{ Fc Fs:9 Fp}



static void Test_C_BFu9s_Vp()
{
  {
    init_simple_test("C_BFu9s_Vp");
    static STRUCT_IF_C C_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_BFu9s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu9s_Vp, C_BFu9s_Vp)
//============================================================================


struct  C_C  {
  char v1;
  char v2;
};
//SIG(1 C_C) C1{ Fc[2]}



static void Test_C_C()
{
  {
    init_simple_test("C_C");
    STRUCT_IF_C C_C lv;
    check2(sizeof(lv), 2, "sizeof(C_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_C)");
    check_field_offset(lv, v1, 0, "C_C.v1");
    check_field_offset(lv, v2, 1, "C_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C, C_C)
//============================================================================


struct  C_C_BFu15i  {
  char v1;
  char v2;
  unsigned int v3:15;
};
//SIG(1 C_C_BFu15i) C1{ Fc[2] Fi:15}



static void Test_C_C_BFu15i()
{
  {
    init_simple_test("C_C_BFu15i");
    static STRUCT_IF_C C_C_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu15i)");
    check_field_offset(lv, v1, 0, "C_C_BFu15i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_C_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu15i, C_C_BFu15i)
//============================================================================


struct  C_C_BFu15ll  {
  char v1;
  char v2;
  __tsu64 v3:15;
};
//SIG(1 C_C_BFu15ll) C1{ Fc[2] FL:15}



static void Test_C_C_BFu15ll()
{
  {
    init_simple_test("C_C_BFu15ll");
    static STRUCT_IF_C C_C_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_C_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_C_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu15ll, C_C_BFu15ll)
//============================================================================


struct  C_C_BFu15s  {
  char v1;
  char v2;
  unsigned short v3:15;
};
//SIG(1 C_C_BFu15s) C1{ Fc[2] Fs:15}



static void Test_C_C_BFu15s()
{
  {
    init_simple_test("C_C_BFu15s");
    static STRUCT_IF_C C_C_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_C_BFu15s)");
    check_field_offset(lv, v1, 0, "C_C_BFu15s.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_C_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu15s, C_C_BFu15s)
//============================================================================


struct  C_C_BFu16i  {
  char v1;
  char v2;
  unsigned int v3:16;
};
//SIG(1 C_C_BFu16i) C1{ Fc[2] Fi:16}



static void Test_C_C_BFu16i()
{
  {
    init_simple_test("C_C_BFu16i");
    static STRUCT_IF_C C_C_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu16i)");
    check_field_offset(lv, v1, 0, "C_C_BFu16i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_C_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu16i, C_C_BFu16i)
//============================================================================


struct  C_C_BFu16ll  {
  char v1;
  char v2;
  __tsu64 v3:16;
};
//SIG(1 C_C_BFu16ll) C1{ Fc[2] FL:16}



static void Test_C_C_BFu16ll()
{
  {
    init_simple_test("C_C_BFu16ll");
    static STRUCT_IF_C C_C_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_C_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_C_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu16ll, C_C_BFu16ll)
//============================================================================


struct  C_C_BFu16s  {
  char v1;
  char v2;
  unsigned short v3:16;
};
//SIG(1 C_C_BFu16s) C1{ Fc[2] Fs:16}



static void Test_C_C_BFu16s()
{
  {
    init_simple_test("C_C_BFu16s");
    static STRUCT_IF_C C_C_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_C_BFu16s)");
    check_field_offset(lv, v1, 0, "C_C_BFu16s.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_C_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu16s, C_C_BFu16s)
//============================================================================


struct  C_C_BFu17i  {
  char v1;
  char v2;
  unsigned int v3:17;
};
//SIG(1 C_C_BFu17i) C1{ Fc[2] Fi:17}



static void Test_C_C_BFu17i()
{
  {
    init_simple_test("C_C_BFu17i");
    static STRUCT_IF_C C_C_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_C_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu17i)");
    check_field_offset(lv, v1, 0, "C_C_BFu17i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_C_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu17i, C_C_BFu17i)
//============================================================================


struct  C_C_BFu17ll  {
  char v1;
  char v2;
  __tsu64 v3:17;
};
//SIG(1 C_C_BFu17ll) C1{ Fc[2] FL:17}



static void Test_C_C_BFu17ll()
{
  {
    init_simple_test("C_C_BFu17ll");
    static STRUCT_IF_C C_C_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_C_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "C_C_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "C_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu17ll, C_C_BFu17ll)
//============================================================================


struct  C_C_BFu1c  {
  char v1;
  char v2;
  unsigned char v3:1;
};
//SIG(1 C_C_BFu1c) C1{ Fc[2] Fc:1}



static void Test_C_C_BFu1c()
{
  {
    init_simple_test("C_C_BFu1c");
    static STRUCT_IF_C C_C_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(C_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_C_BFu1c)");
    check_field_offset(lv, v1, 0, "C_C_BFu1c.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu1c, C_C_BFu1c)
//============================================================================


struct  C_C_BFu1i  {
  char v1;
  char v2;
  unsigned int v3:1;
};
//SIG(1 C_C_BFu1i) C1{ Fc[2] Fi:1}



static void Test_C_C_BFu1i()
{
  {
    init_simple_test("C_C_BFu1i");
    static STRUCT_IF_C C_C_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu1i)");
    check_field_offset(lv, v1, 0, "C_C_BFu1i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu1i, C_C_BFu1i)
//============================================================================


struct  C_C_BFu1ll  {
  char v1;
  char v2;
  __tsu64 v3:1;
};
//SIG(1 C_C_BFu1ll) C1{ Fc[2] FL:1}



static void Test_C_C_BFu1ll()
{
  {
    init_simple_test("C_C_BFu1ll");
    static STRUCT_IF_C C_C_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_C_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu1ll, C_C_BFu1ll)
//============================================================================


struct  C_C_BFu1s  {
  char v1;
  char v2;
  unsigned short v3:1;
};
//SIG(1 C_C_BFu1s) C1{ Fc[2] Fs:1}



static void Test_C_C_BFu1s()
{
  {
    init_simple_test("C_C_BFu1s");
    static STRUCT_IF_C C_C_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_C_BFu1s)");
    check_field_offset(lv, v1, 0, "C_C_BFu1s.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu1s, C_C_BFu1s)
//============================================================================


struct  C_C_BFu31i  {
  char v1;
  char v2;
  unsigned int v3:31;
};
//SIG(1 C_C_BFu31i) C1{ Fc[2] Fi:31}



static void Test_C_C_BFu31i()
{
  {
    init_simple_test("C_C_BFu31i");
    static STRUCT_IF_C C_C_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_C_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu31i)");
    check_field_offset(lv, v1, 0, "C_C_BFu31i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_C_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu31i, C_C_BFu31i)
//============================================================================


struct  C_C_BFu31ll  {
  char v1;
  char v2;
  __tsu64 v3:31;
};
//SIG(1 C_C_BFu31ll) C1{ Fc[2] FL:31}



static void Test_C_C_BFu31ll()
{
  {
    init_simple_test("C_C_BFu31ll");
    static STRUCT_IF_C C_C_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_C_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "C_C_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "C_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu31ll, C_C_BFu31ll)
//============================================================================


struct  C_C_BFu32i  {
  char v1;
  char v2;
  unsigned int v3:32;
};
//SIG(1 C_C_BFu32i) C1{ Fc[2] Fi:32}



static void Test_C_C_BFu32i()
{
  {
    init_simple_test("C_C_BFu32i");
    static STRUCT_IF_C C_C_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_C_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu32i)");
    check_field_offset(lv, v1, 0, "C_C_BFu32i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_C_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu32i, C_C_BFu32i)
//============================================================================


struct  C_C_BFu32ll  {
  char v1;
  char v2;
  __tsu64 v3:32;
};
//SIG(1 C_C_BFu32ll) C1{ Fc[2] FL:32}



static void Test_C_C_BFu32ll()
{
  {
    init_simple_test("C_C_BFu32ll");
    static STRUCT_IF_C C_C_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_C_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "C_C_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "C_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu32ll, C_C_BFu32ll)
//============================================================================


struct  C_C_BFu33  {
  char v1;
  char v2;
  __tsu64 v3:33;
};
//SIG(1 C_C_BFu33) C1{ Fc[2] FL:33}



static void Test_C_C_BFu33()
{
  {
    init_simple_test("C_C_BFu33");
    static STRUCT_IF_C C_C_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_C_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu33)");
    check_field_offset(lv, v1, 0, "C_C_BFu33.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "C_C_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "C_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu33, C_C_BFu33)
//============================================================================


struct  C_C_BFu7c  {
  char v1;
  char v2;
  unsigned char v3:7;
};
//SIG(1 C_C_BFu7c) C1{ Fc[2] Fc:7}



static void Test_C_C_BFu7c()
{
  {
    init_simple_test("C_C_BFu7c");
    static STRUCT_IF_C C_C_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_C_BFu7c)");
    check_field_offset(lv, v1, 0, "C_C_BFu7c.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_C_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu7c, C_C_BFu7c)
//============================================================================


struct  C_C_BFu7i  {
  char v1;
  char v2;
  unsigned int v3:7;
};
//SIG(1 C_C_BFu7i) C1{ Fc[2] Fi:7}



static void Test_C_C_BFu7i()
{
  {
    init_simple_test("C_C_BFu7i");
    static STRUCT_IF_C C_C_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu7i)");
    check_field_offset(lv, v1, 0, "C_C_BFu7i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_C_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu7i, C_C_BFu7i)
//============================================================================


struct  C_C_BFu7ll  {
  char v1;
  char v2;
  __tsu64 v3:7;
};
//SIG(1 C_C_BFu7ll) C1{ Fc[2] FL:7}



static void Test_C_C_BFu7ll()
{
  {
    init_simple_test("C_C_BFu7ll");
    static STRUCT_IF_C C_C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_C_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu7ll, C_C_BFu7ll)
//============================================================================


struct  C_C_BFu7s  {
  char v1;
  char v2;
  unsigned short v3:7;
};
//SIG(1 C_C_BFu7s) C1{ Fc[2] Fs:7}



static void Test_C_C_BFu7s()
{
  {
    init_simple_test("C_C_BFu7s");
    static STRUCT_IF_C C_C_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_C_BFu7s)");
    check_field_offset(lv, v1, 0, "C_C_BFu7s.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_C_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu7s, C_C_BFu7s)
//============================================================================


struct  C_C_BFu8c  {
  char v1;
  char v2;
  unsigned char v3:8;
};
//SIG(1 C_C_BFu8c) C1{ Fc[2] Fc:8}



static void Test_C_C_BFu8c()
{
  {
    init_simple_test("C_C_BFu8c");
    static STRUCT_IF_C C_C_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_C_BFu8c)");
    check_field_offset(lv, v1, 0, "C_C_BFu8c.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_C_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu8c, C_C_BFu8c)
//============================================================================


struct  C_C_BFu8i  {
  char v1;
  char v2;
  unsigned int v3:8;
};
//SIG(1 C_C_BFu8i) C1{ Fc[2] Fi:8}



static void Test_C_C_BFu8i()
{
  {
    init_simple_test("C_C_BFu8i");
    static STRUCT_IF_C C_C_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu8i)");
    check_field_offset(lv, v1, 0, "C_C_BFu8i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_C_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu8i, C_C_BFu8i)
//============================================================================


struct  C_C_BFu8ll  {
  char v1;
  char v2;
  __tsu64 v3:8;
};
//SIG(1 C_C_BFu8ll) C1{ Fc[2] FL:8}



static void Test_C_C_BFu8ll()
{
  {
    init_simple_test("C_C_BFu8ll");
    static STRUCT_IF_C C_C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_C_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu8ll, C_C_BFu8ll)
//============================================================================


struct  C_C_BFu8s  {
  char v1;
  char v2;
  unsigned short v3:8;
};
//SIG(1 C_C_BFu8s) C1{ Fc[2] Fs:8}



static void Test_C_C_BFu8s()
{
  {
    init_simple_test("C_C_BFu8s");
    static STRUCT_IF_C C_C_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_C_BFu8s)");
    check_field_offset(lv, v1, 0, "C_C_BFu8s.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_C_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu8s, C_C_BFu8s)
//============================================================================


struct  C_C_BFu9i  {
  char v1;
  char v2;
  unsigned int v3:9;
};
//SIG(1 C_C_BFu9i) C1{ Fc[2] Fi:9}



static void Test_C_C_BFu9i()
{
  {
    init_simple_test("C_C_BFu9i");
    static STRUCT_IF_C C_C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_BFu9i)");
    check_field_offset(lv, v1, 0, "C_C_BFu9i.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_C_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu9i, C_C_BFu9i)
//============================================================================


struct  C_C_BFu9ll  {
  char v1;
  char v2;
  __tsu64 v3:9;
};
//SIG(1 C_C_BFu9ll) C1{ Fc[2] FL:9}



static void Test_C_C_BFu9ll()
{
  {
    init_simple_test("C_C_BFu9ll");
    static STRUCT_IF_C C_C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_C_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_C_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu9ll, C_C_BFu9ll)
//============================================================================


struct  C_C_BFu9s  {
  char v1;
  char v2;
  unsigned short v3:9;
};
//SIG(1 C_C_BFu9s) C1{ Fc[2] Fs:9}



static void Test_C_C_BFu9s()
{
  {
    init_simple_test("C_C_BFu9s");
    static STRUCT_IF_C C_C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_C_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_C_BFu9s)");
    check_field_offset(lv, v1, 0, "C_C_BFu9s.v1");
    check_field_offset(lv, v2, 1, "C_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_C_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_BFu9s, C_C_BFu9s)
//============================================================================


struct  C_C_C  {
  char v1;
  char v2;
  char v3;
};
//SIG(1 C_C_C) C1{ Fc[3]}



static void Test_C_C_C()
{
  {
    init_simple_test("C_C_C");
    STRUCT_IF_C C_C_C lv;
    check2(sizeof(lv), 3, "sizeof(C_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_C_C)");
    check_field_offset(lv, v1, 0, "C_C_C.v1");
    check_field_offset(lv, v2, 1, "C_C_C.v2");
    check_field_offset(lv, v3, 2, "C_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_C, C_C_C)
//============================================================================


struct  C_C_D  {
  char v1;
  char v2;
  double v3;
};
//SIG(1 C_C_D) C1{ Fc[2] FL}



static void Test_C_C_D()
{
  {
    init_simple_test("C_C_D");
    STRUCT_IF_C C_C_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_D)");
    check_field_offset(lv, v1, 0, "C_C_D.v1");
    check_field_offset(lv, v2, 1, "C_C_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_D, C_C_D)
//============================================================================


struct  C_C_F  {
  char v1;
  char v2;
  float v3;
};
//SIG(1 C_C_F) C1{ Fc[2] Fi}



static void Test_C_C_F()
{
  {
    init_simple_test("C_C_F");
    STRUCT_IF_C C_C_F lv;
    check2(sizeof(lv), 8, "sizeof(C_C_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_F)");
    check_field_offset(lv, v1, 0, "C_C_F.v1");
    check_field_offset(lv, v2, 1, "C_C_F.v2");
    check_field_offset(lv, v3, 4, "C_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_F, C_C_F)
//============================================================================


struct  C_C_I  {
  char v1;
  char v2;
  int v3;
};
//SIG(1 C_C_I) C1{ Fc[2] Fi}



static void Test_C_C_I()
{
  {
    init_simple_test("C_C_I");
    STRUCT_IF_C C_C_I lv;
    check2(sizeof(lv), 8, "sizeof(C_C_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_I)");
    check_field_offset(lv, v1, 0, "C_C_I.v1");
    check_field_offset(lv, v2, 1, "C_C_I.v2");
    check_field_offset(lv, v3, 4, "C_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_I, C_C_I)
//============================================================================


struct  C_C_Ip  {
  char v1;
  char v2;
  int *v3;
};
//SIG(1 C_C_Ip) C1{ Fc[2] Fp}



static void Test_C_C_Ip()
{
  {
    init_simple_test("C_C_Ip");
    STRUCT_IF_C C_C_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_Ip)");
    check_field_offset(lv, v1, 0, "C_C_Ip.v1");
    check_field_offset(lv, v2, 1, "C_C_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_Ip, C_C_Ip)
//============================================================================


struct  C_C_L  {
  char v1;
  char v2;
  __tsi64 v3;
};
//SIG(1 C_C_L) C1{ Fc[2] FL}



static void Test_C_C_L()
{
  {
    init_simple_test("C_C_L");
    STRUCT_IF_C C_C_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_L)");
    check_field_offset(lv, v1, 0, "C_C_L.v1");
    check_field_offset(lv, v2, 1, "C_C_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_L, C_C_L)
//============================================================================


struct  C_C_S  {
  char v1;
  char v2;
  short v3;
};
//SIG(1 C_C_S) C1{ Fc[2] Fs}



static void Test_C_C_S()
{
  {
    init_simple_test("C_C_S");
    STRUCT_IF_C C_C_S lv;
    check2(sizeof(lv), 4, "sizeof(C_C_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_C_S)");
    check_field_offset(lv, v1, 0, "C_C_S.v1");
    check_field_offset(lv, v2, 1, "C_C_S.v2");
    check_field_offset(lv, v3, 2, "C_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_S, C_C_S)
//============================================================================


struct  C_C_Uc  {
  char v1;
  char v2;
  unsigned char v3;
};
//SIG(1 C_C_Uc) C1{ Fc[3]}



static void Test_C_C_Uc()
{
  {
    init_simple_test("C_C_Uc");
    STRUCT_IF_C C_C_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_C_Uc)");
    check_field_offset(lv, v1, 0, "C_C_Uc.v1");
    check_field_offset(lv, v2, 1, "C_C_Uc.v2");
    check_field_offset(lv, v3, 2, "C_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_Uc, C_C_Uc)
//============================================================================


struct  C_C_Ui  {
  char v1;
  char v2;
  unsigned int v3;
};
//SIG(1 C_C_Ui) C1{ Fc[2] Fi}



static void Test_C_C_Ui()
{
  {
    init_simple_test("C_C_Ui");
    STRUCT_IF_C C_C_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_C_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_C_Ui)");
    check_field_offset(lv, v1, 0, "C_C_Ui.v1");
    check_field_offset(lv, v2, 1, "C_C_Ui.v2");
    check_field_offset(lv, v3, 4, "C_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_Ui, C_C_Ui)
//============================================================================


struct  C_C_Ul  {
  char v1;
  char v2;
  __tsu64 v3;
};
//SIG(1 C_C_Ul) C1{ Fc[2] FL}



static void Test_C_C_Ul()
{
  {
    init_simple_test("C_C_Ul");
    STRUCT_IF_C C_C_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_Ul)");
    check_field_offset(lv, v1, 0, "C_C_Ul.v1");
    check_field_offset(lv, v2, 1, "C_C_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_Ul, C_C_Ul)
//============================================================================


struct  C_C_Us  {
  char v1;
  char v2;
  unsigned short v3;
};
//SIG(1 C_C_Us) C1{ Fc[2] Fs}



static void Test_C_C_Us()
{
  {
    init_simple_test("C_C_Us");
    STRUCT_IF_C C_C_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_C_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_C_Us)");
    check_field_offset(lv, v1, 0, "C_C_Us.v1");
    check_field_offset(lv, v2, 1, "C_C_Us.v2");
    check_field_offset(lv, v3, 2, "C_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_Us, C_C_Us)
//============================================================================


struct  C_C_Vp  {
  char v1;
  char v2;
  void *v3;
};
//SIG(1 C_C_Vp) C1{ Fc[2] Fp}



static void Test_C_C_Vp()
{
  {
    init_simple_test("C_C_Vp");
    STRUCT_IF_C C_C_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_C_Vp)");
    check_field_offset(lv, v1, 0, "C_C_Vp.v1");
    check_field_offset(lv, v2, 1, "C_C_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_C_Vp, C_C_Vp)
//============================================================================


struct  C_D  {
  char v1;
  double v2;
};
//SIG(1 C_D) C1{ Fc FL}



static void Test_C_D()
{
  {
    init_simple_test("C_D");
    STRUCT_IF_C C_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D)");
    check_field_offset(lv, v1, 0, "C_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D, C_D)
//============================================================================


struct  C_D_BFu15i  {
  char v1;
  double v2;
  unsigned int v3:15;
};
//SIG(1 C_D_BFu15i) C1{ Fc FL Fi:15}



static void Test_C_D_BFu15i()
{
  {
    init_simple_test("C_D_BFu15i");
    static STRUCT_IF_C C_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu15i)");
    check_field_offset(lv, v1, 0, "C_D_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_D_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu15i, C_D_BFu15i)
//============================================================================


struct  C_D_BFu15ll  {
  char v1;
  double v2;
  __tsu64 v3:15;
};
//SIG(1 C_D_BFu15ll) C1{ Fc FL FL:15}



static void Test_C_D_BFu15ll()
{
  {
    init_simple_test("C_D_BFu15ll");
    static STRUCT_IF_C C_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_D_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu15ll, C_D_BFu15ll)
//============================================================================


struct  C_D_BFu15s  {
  char v1;
  double v2;
  unsigned short v3:15;
};
//SIG(1 C_D_BFu15s) C1{ Fc FL Fs:15}



static void Test_C_D_BFu15s()
{
  {
    init_simple_test("C_D_BFu15s");
    static STRUCT_IF_C C_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu15s)");
    check_field_offset(lv, v1, 0, "C_D_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_D_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu15s, C_D_BFu15s)
//============================================================================


struct  C_D_BFu16i  {
  char v1;
  double v2;
  unsigned int v3:16;
};
//SIG(1 C_D_BFu16i) C1{ Fc FL Fi:16}



static void Test_C_D_BFu16i()
{
  {
    init_simple_test("C_D_BFu16i");
    static STRUCT_IF_C C_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu16i)");
    check_field_offset(lv, v1, 0, "C_D_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_D_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu16i, C_D_BFu16i)
//============================================================================


struct  C_D_BFu16ll  {
  char v1;
  double v2;
  __tsu64 v3:16;
};
//SIG(1 C_D_BFu16ll) C1{ Fc FL FL:16}



static void Test_C_D_BFu16ll()
{
  {
    init_simple_test("C_D_BFu16ll");
    static STRUCT_IF_C C_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_D_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu16ll, C_D_BFu16ll)
//============================================================================


struct  C_D_BFu16s  {
  char v1;
  double v2;
  unsigned short v3:16;
};
//SIG(1 C_D_BFu16s) C1{ Fc FL Fs:16}



static void Test_C_D_BFu16s()
{
  {
    init_simple_test("C_D_BFu16s");
    static STRUCT_IF_C C_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu16s)");
    check_field_offset(lv, v1, 0, "C_D_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_D_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu16s, C_D_BFu16s)
//============================================================================


struct  C_D_BFu17i  {
  char v1;
  double v2;
  unsigned int v3:17;
};
//SIG(1 C_D_BFu17i) C1{ Fc FL Fi:17}



static void Test_C_D_BFu17i()
{
  {
    init_simple_test("C_D_BFu17i");
    static STRUCT_IF_C C_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu17i)");
    check_field_offset(lv, v1, 0, "C_D_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "C_D_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "C_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu17i, C_D_BFu17i)
//============================================================================


struct  C_D_BFu17ll  {
  char v1;
  double v2;
  __tsu64 v3:17;
};
//SIG(1 C_D_BFu17ll) C1{ Fc FL FL:17}



static void Test_C_D_BFu17ll()
{
  {
    init_simple_test("C_D_BFu17ll");
    static STRUCT_IF_C C_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "C_D_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "C_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu17ll, C_D_BFu17ll)
//============================================================================


struct  C_D_BFu1c  {
  char v1;
  double v2;
  unsigned char v3:1;
};
//SIG(1 C_D_BFu1c) C1{ Fc FL Fc:1}



static void Test_C_D_BFu1c()
{
  {
    init_simple_test("C_D_BFu1c");
    static STRUCT_IF_C C_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu1c)");
    check_field_offset(lv, v1, 0, "C_D_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu1c, C_D_BFu1c)
//============================================================================


struct  C_D_BFu1i  {
  char v1;
  double v2;
  unsigned int v3:1;
};
//SIG(1 C_D_BFu1i) C1{ Fc FL Fi:1}



static void Test_C_D_BFu1i()
{
  {
    init_simple_test("C_D_BFu1i");
    static STRUCT_IF_C C_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu1i)");
    check_field_offset(lv, v1, 0, "C_D_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu1i, C_D_BFu1i)
//============================================================================


struct  C_D_BFu1ll  {
  char v1;
  double v2;
  __tsu64 v3:1;
};
//SIG(1 C_D_BFu1ll) C1{ Fc FL FL:1}



static void Test_C_D_BFu1ll()
{
  {
    init_simple_test("C_D_BFu1ll");
    static STRUCT_IF_C C_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu1ll, C_D_BFu1ll)
//============================================================================


struct  C_D_BFu1s  {
  char v1;
  double v2;
  unsigned short v3:1;
};
//SIG(1 C_D_BFu1s) C1{ Fc FL Fs:1}



static void Test_C_D_BFu1s()
{
  {
    init_simple_test("C_D_BFu1s");
    static STRUCT_IF_C C_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu1s)");
    check_field_offset(lv, v1, 0, "C_D_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu1s, C_D_BFu1s)
//============================================================================


struct  C_D_BFu31i  {
  char v1;
  double v2;
  unsigned int v3:31;
};
//SIG(1 C_D_BFu31i) C1{ Fc FL Fi:31}



static void Test_C_D_BFu31i()
{
  {
    init_simple_test("C_D_BFu31i");
    static STRUCT_IF_C C_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu31i)");
    check_field_offset(lv, v1, 0, "C_D_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "C_D_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "C_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu31i, C_D_BFu31i)
//============================================================================


struct  C_D_BFu31ll  {
  char v1;
  double v2;
  __tsu64 v3:31;
};
//SIG(1 C_D_BFu31ll) C1{ Fc FL FL:31}



static void Test_C_D_BFu31ll()
{
  {
    init_simple_test("C_D_BFu31ll");
    static STRUCT_IF_C C_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "C_D_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "C_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu31ll, C_D_BFu31ll)
//============================================================================


struct  C_D_BFu32i  {
  char v1;
  double v2;
  unsigned int v3:32;
};
//SIG(1 C_D_BFu32i) C1{ Fc FL Fi:32}



static void Test_C_D_BFu32i()
{
  {
    init_simple_test("C_D_BFu32i");
    static STRUCT_IF_C C_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu32i)");
    check_field_offset(lv, v1, 0, "C_D_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "C_D_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "C_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu32i, C_D_BFu32i)
//============================================================================


struct  C_D_BFu32ll  {
  char v1;
  double v2;
  __tsu64 v3:32;
};
//SIG(1 C_D_BFu32ll) C1{ Fc FL FL:32}



static void Test_C_D_BFu32ll()
{
  {
    init_simple_test("C_D_BFu32ll");
    static STRUCT_IF_C C_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "C_D_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "C_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu32ll, C_D_BFu32ll)
//============================================================================


struct  C_D_BFu33  {
  char v1;
  double v2;
  __tsu64 v3:33;
};
//SIG(1 C_D_BFu33) C1{ Fc FL FL:33}



static void Test_C_D_BFu33()
{
  {
    init_simple_test("C_D_BFu33");
    static STRUCT_IF_C C_D_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu33)");
    check_field_offset(lv, v1, 0, "C_D_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "C_D_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "C_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu33, C_D_BFu33)
//============================================================================


struct  C_D_BFu7c  {
  char v1;
  double v2;
  unsigned char v3:7;
};
//SIG(1 C_D_BFu7c) C1{ Fc FL Fc:7}



static void Test_C_D_BFu7c()
{
  {
    init_simple_test("C_D_BFu7c");
    static STRUCT_IF_C C_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu7c)");
    check_field_offset(lv, v1, 0, "C_D_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_D_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu7c, C_D_BFu7c)
//============================================================================


struct  C_D_BFu7i  {
  char v1;
  double v2;
  unsigned int v3:7;
};
//SIG(1 C_D_BFu7i) C1{ Fc FL Fi:7}



static void Test_C_D_BFu7i()
{
  {
    init_simple_test("C_D_BFu7i");
    static STRUCT_IF_C C_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu7i)");
    check_field_offset(lv, v1, 0, "C_D_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_D_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu7i, C_D_BFu7i)
//============================================================================


struct  C_D_BFu7ll  {
  char v1;
  double v2;
  __tsu64 v3:7;
};
//SIG(1 C_D_BFu7ll) C1{ Fc FL FL:7}



static void Test_C_D_BFu7ll()
{
  {
    init_simple_test("C_D_BFu7ll");
    static STRUCT_IF_C C_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_D_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu7ll, C_D_BFu7ll)
//============================================================================


struct  C_D_BFu7s  {
  char v1;
  double v2;
  unsigned short v3:7;
};
//SIG(1 C_D_BFu7s) C1{ Fc FL Fs:7}



static void Test_C_D_BFu7s()
{
  {
    init_simple_test("C_D_BFu7s");
    static STRUCT_IF_C C_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu7s)");
    check_field_offset(lv, v1, 0, "C_D_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_D_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu7s, C_D_BFu7s)
//============================================================================


struct  C_D_BFu8c  {
  char v1;
  double v2;
  unsigned char v3:8;
};
//SIG(1 C_D_BFu8c) C1{ Fc FL Fc:8}



static void Test_C_D_BFu8c()
{
  {
    init_simple_test("C_D_BFu8c");
    static STRUCT_IF_C C_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu8c)");
    check_field_offset(lv, v1, 0, "C_D_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_D_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu8c, C_D_BFu8c)
//============================================================================


struct  C_D_BFu8i  {
  char v1;
  double v2;
  unsigned int v3:8;
};
//SIG(1 C_D_BFu8i) C1{ Fc FL Fi:8}



static void Test_C_D_BFu8i()
{
  {
    init_simple_test("C_D_BFu8i");
    static STRUCT_IF_C C_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu8i)");
    check_field_offset(lv, v1, 0, "C_D_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_D_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu8i, C_D_BFu8i)
//============================================================================


struct  C_D_BFu8ll  {
  char v1;
  double v2;
  __tsu64 v3:8;
};
//SIG(1 C_D_BFu8ll) C1{ Fc FL FL:8}



static void Test_C_D_BFu8ll()
{
  {
    init_simple_test("C_D_BFu8ll");
    static STRUCT_IF_C C_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_D_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu8ll, C_D_BFu8ll)
//============================================================================


struct  C_D_BFu8s  {
  char v1;
  double v2;
  unsigned short v3:8;
};
//SIG(1 C_D_BFu8s) C1{ Fc FL Fs:8}



static void Test_C_D_BFu8s()
{
  {
    init_simple_test("C_D_BFu8s");
    static STRUCT_IF_C C_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu8s)");
    check_field_offset(lv, v1, 0, "C_D_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_D_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu8s, C_D_BFu8s)
//============================================================================


struct  C_D_BFu9i  {
  char v1;
  double v2;
  unsigned int v3:9;
};
//SIG(1 C_D_BFu9i) C1{ Fc FL Fi:9}



static void Test_C_D_BFu9i()
{
  {
    init_simple_test("C_D_BFu9i");
    static STRUCT_IF_C C_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu9i)");
    check_field_offset(lv, v1, 0, "C_D_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_D_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu9i, C_D_BFu9i)
//============================================================================


struct  C_D_BFu9ll  {
  char v1;
  double v2;
  __tsu64 v3:9;
};
//SIG(1 C_D_BFu9ll) C1{ Fc FL FL:9}



static void Test_C_D_BFu9ll()
{
  {
    init_simple_test("C_D_BFu9ll");
    static STRUCT_IF_C C_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_D_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_D_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu9ll, C_D_BFu9ll)
//============================================================================


struct  C_D_BFu9s  {
  char v1;
  double v2;
  unsigned short v3:9;
};
//SIG(1 C_D_BFu9s) C1{ Fc FL Fs:9}



static void Test_C_D_BFu9s()
{
  {
    init_simple_test("C_D_BFu9s");
    static STRUCT_IF_C C_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_BFu9s)");
    check_field_offset(lv, v1, 0, "C_D_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_D_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_BFu9s, C_D_BFu9s)
//============================================================================


struct  C_D_C  {
  char v1;
  double v2;
  char v3;
};
//SIG(1 C_D_C) C1{ Fc FL Fc}



static void Test_C_D_C()
{
  {
    init_simple_test("C_D_C");
    STRUCT_IF_C C_D_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_C)");
    check_field_offset(lv, v1, 0, "C_D_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_C, C_D_C)
//============================================================================


struct  C_D_D  {
  char v1;
  double v2;
  double v3;
};
//SIG(1 C_D_D) C1{ Fc FL[2]}



static void Test_C_D_D()
{
  {
    init_simple_test("C_D_D");
    STRUCT_IF_C C_D_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_D)");
    check_field_offset(lv, v1, 0, "C_D_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_D, C_D_D)
//============================================================================


struct  C_D_F  {
  char v1;
  double v2;
  float v3;
};
//SIG(1 C_D_F) C1{ Fc FL Fi}



static void Test_C_D_F()
{
  {
    init_simple_test("C_D_F");
    STRUCT_IF_C C_D_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_F)");
    check_field_offset(lv, v1, 0, "C_D_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_F, C_D_F)
//============================================================================


struct  C_D_I  {
  char v1;
  double v2;
  int v3;
};
//SIG(1 C_D_I) C1{ Fc FL Fi}



static void Test_C_D_I()
{
  {
    init_simple_test("C_D_I");
    STRUCT_IF_C C_D_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_I)");
    check_field_offset(lv, v1, 0, "C_D_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_I, C_D_I)
//============================================================================


struct  C_D_Ip  {
  char v1;
  double v2;
  int *v3;
};
//SIG(1 C_D_Ip) C1{ Fc FL Fp}



static void Test_C_D_Ip()
{
  {
    init_simple_test("C_D_Ip");
    STRUCT_IF_C C_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_Ip)");
    check_field_offset(lv, v1, 0, "C_D_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_Ip, C_D_Ip)
//============================================================================


struct  C_D_L  {
  char v1;
  double v2;
  __tsi64 v3;
};
//SIG(1 C_D_L) C1{ Fc FL[2]}



static void Test_C_D_L()
{
  {
    init_simple_test("C_D_L");
    STRUCT_IF_C C_D_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_L)");
    check_field_offset(lv, v1, 0, "C_D_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_L, C_D_L)
//============================================================================


struct  C_D_S  {
  char v1;
  double v2;
  short v3;
};
//SIG(1 C_D_S) C1{ Fc FL Fs}



static void Test_C_D_S()
{
  {
    init_simple_test("C_D_S");
    STRUCT_IF_C C_D_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_S)");
    check_field_offset(lv, v1, 0, "C_D_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_S, C_D_S)
//============================================================================


struct  C_D_Uc  {
  char v1;
  double v2;
  unsigned char v3;
};
//SIG(1 C_D_Uc) C1{ Fc FL Fc}



static void Test_C_D_Uc()
{
  {
    init_simple_test("C_D_Uc");
    STRUCT_IF_C C_D_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_Uc)");
    check_field_offset(lv, v1, 0, "C_D_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_Uc, C_D_Uc)
//============================================================================


struct  C_D_Ui  {
  char v1;
  double v2;
  unsigned int v3;
};
//SIG(1 C_D_Ui) C1{ Fc FL Fi}



static void Test_C_D_Ui()
{
  {
    init_simple_test("C_D_Ui");
    STRUCT_IF_C C_D_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_Ui)");
    check_field_offset(lv, v1, 0, "C_D_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_Ui, C_D_Ui)
//============================================================================


struct  C_D_Ul  {
  char v1;
  double v2;
  __tsu64 v3;
};
//SIG(1 C_D_Ul) C1{ Fc FL[2]}



static void Test_C_D_Ul()
{
  {
    init_simple_test("C_D_Ul");
    STRUCT_IF_C C_D_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_Ul)");
    check_field_offset(lv, v1, 0, "C_D_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_Ul, C_D_Ul)
//============================================================================


struct  C_D_Us  {
  char v1;
  double v2;
  unsigned short v3;
};
//SIG(1 C_D_Us) C1{ Fc FL Fs}



static void Test_C_D_Us()
{
  {
    init_simple_test("C_D_Us");
    STRUCT_IF_C C_D_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_Us)");
    check_field_offset(lv, v1, 0, "C_D_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_Us, C_D_Us)
//============================================================================


struct  C_D_Vp  {
  char v1;
  double v2;
  void *v3;
};
//SIG(1 C_D_Vp) C1{ Fc FL Fp}



static void Test_C_D_Vp()
{
  {
    init_simple_test("C_D_Vp");
    STRUCT_IF_C C_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_Vp)");
    check_field_offset(lv, v1, 0, "C_D_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_D_Vp, C_D_Vp)
//============================================================================


struct  C_F  {
  char v1;
  float v2;
};
//SIG(1 C_F) C1{ Fc Fi}



static void Test_C_F()
{
  {
    init_simple_test("C_F");
    STRUCT_IF_C C_F lv;
    check2(sizeof(lv), 8, "sizeof(C_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_F)");
    check_field_offset(lv, v1, 0, "C_F.v1");
    check_field_offset(lv, v2, 4, "C_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F, C_F)
//============================================================================


struct  C_F_BFu15i  {
  char v1;
  float v2;
  unsigned int v3:15;
};
//SIG(1 C_F_BFu15i) C1{ Fc Fi Fi:15}



static void Test_C_F_BFu15i()
{
  {
    init_simple_test("C_F_BFu15i");
    static STRUCT_IF_C C_F_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu15i)");
    check_field_offset(lv, v1, 0, "C_F_BFu15i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_F_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu15i, C_F_BFu15i)
//============================================================================


struct  C_F_BFu15ll  {
  char v1;
  float v2;
  __tsu64 v3:15;
};
//SIG(1 C_F_BFu15ll) C1{ Fc Fi FL:15}



static void Test_C_F_BFu15ll()
{
  {
    init_simple_test("C_F_BFu15ll");
    static STRUCT_IF_C C_F_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_F_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu15ll, C_F_BFu15ll)
//============================================================================


struct  C_F_BFu15s  {
  char v1;
  float v2;
  unsigned short v3:15;
};
//SIG(1 C_F_BFu15s) C1{ Fc Fi Fs:15}



static void Test_C_F_BFu15s()
{
  {
    init_simple_test("C_F_BFu15s");
    static STRUCT_IF_C C_F_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu15s)");
    check_field_offset(lv, v1, 0, "C_F_BFu15s.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_F_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu15s, C_F_BFu15s)
//============================================================================


struct  C_F_BFu16i  {
  char v1;
  float v2;
  unsigned int v3:16;
};
//SIG(1 C_F_BFu16i) C1{ Fc Fi Fi:16}



static void Test_C_F_BFu16i()
{
  {
    init_simple_test("C_F_BFu16i");
    static STRUCT_IF_C C_F_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu16i)");
    check_field_offset(lv, v1, 0, "C_F_BFu16i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_F_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu16i, C_F_BFu16i)
//============================================================================


struct  C_F_BFu16ll  {
  char v1;
  float v2;
  __tsu64 v3:16;
};
//SIG(1 C_F_BFu16ll) C1{ Fc Fi FL:16}



static void Test_C_F_BFu16ll()
{
  {
    init_simple_test("C_F_BFu16ll");
    static STRUCT_IF_C C_F_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_F_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu16ll, C_F_BFu16ll)
//============================================================================


struct  C_F_BFu16s  {
  char v1;
  float v2;
  unsigned short v3:16;
};
//SIG(1 C_F_BFu16s) C1{ Fc Fi Fs:16}



static void Test_C_F_BFu16s()
{
  {
    init_simple_test("C_F_BFu16s");
    static STRUCT_IF_C C_F_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu16s)");
    check_field_offset(lv, v1, 0, "C_F_BFu16s.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_F_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu16s, C_F_BFu16s)
//============================================================================


struct  C_F_BFu17i  {
  char v1;
  float v2;
  unsigned int v3:17;
};
//SIG(1 C_F_BFu17i) C1{ Fc Fi Fi:17}



static void Test_C_F_BFu17i()
{
  {
    init_simple_test("C_F_BFu17i");
    static STRUCT_IF_C C_F_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu17i)");
    check_field_offset(lv, v1, 0, "C_F_BFu17i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "C_F_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "C_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu17i, C_F_BFu17i)
//============================================================================


struct  C_F_BFu17ll  {
  char v1;
  float v2;
  __tsu64 v3:17;
};
//SIG(1 C_F_BFu17ll) C1{ Fc Fi FL:17}



static void Test_C_F_BFu17ll()
{
  {
    init_simple_test("C_F_BFu17ll");
    static STRUCT_IF_C C_F_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "C_F_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "C_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu17ll, C_F_BFu17ll)
//============================================================================


struct  C_F_BFu1c  {
  char v1;
  float v2;
  unsigned char v3:1;
};
//SIG(1 C_F_BFu1c) C1{ Fc Fi Fc:1}



static void Test_C_F_BFu1c()
{
  {
    init_simple_test("C_F_BFu1c");
    static STRUCT_IF_C C_F_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu1c)");
    check_field_offset(lv, v1, 0, "C_F_BFu1c.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu1c, C_F_BFu1c)
//============================================================================


struct  C_F_BFu1i  {
  char v1;
  float v2;
  unsigned int v3:1;
};
//SIG(1 C_F_BFu1i) C1{ Fc Fi Fi:1}



static void Test_C_F_BFu1i()
{
  {
    init_simple_test("C_F_BFu1i");
    static STRUCT_IF_C C_F_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu1i)");
    check_field_offset(lv, v1, 0, "C_F_BFu1i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu1i, C_F_BFu1i)
//============================================================================


struct  C_F_BFu1ll  {
  char v1;
  float v2;
  __tsu64 v3:1;
};
//SIG(1 C_F_BFu1ll) C1{ Fc Fi FL:1}



static void Test_C_F_BFu1ll()
{
  {
    init_simple_test("C_F_BFu1ll");
    static STRUCT_IF_C C_F_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu1ll, C_F_BFu1ll)
//============================================================================


struct  C_F_BFu1s  {
  char v1;
  float v2;
  unsigned short v3:1;
};
//SIG(1 C_F_BFu1s) C1{ Fc Fi Fs:1}



static void Test_C_F_BFu1s()
{
  {
    init_simple_test("C_F_BFu1s");
    static STRUCT_IF_C C_F_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu1s)");
    check_field_offset(lv, v1, 0, "C_F_BFu1s.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu1s, C_F_BFu1s)
//============================================================================


struct  C_F_BFu31i  {
  char v1;
  float v2;
  unsigned int v3:31;
};
//SIG(1 C_F_BFu31i) C1{ Fc Fi Fi:31}



static void Test_C_F_BFu31i()
{
  {
    init_simple_test("C_F_BFu31i");
    static STRUCT_IF_C C_F_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu31i)");
    check_field_offset(lv, v1, 0, "C_F_BFu31i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "C_F_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "C_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu31i, C_F_BFu31i)
//============================================================================


struct  C_F_BFu31ll  {
  char v1;
  float v2;
  __tsu64 v3:31;
};
//SIG(1 C_F_BFu31ll) C1{ Fc Fi FL:31}



static void Test_C_F_BFu31ll()
{
  {
    init_simple_test("C_F_BFu31ll");
    static STRUCT_IF_C C_F_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "C_F_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "C_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu31ll, C_F_BFu31ll)
//============================================================================


struct  C_F_BFu32i  {
  char v1;
  float v2;
  unsigned int v3:32;
};
//SIG(1 C_F_BFu32i) C1{ Fc Fi Fi:32}



static void Test_C_F_BFu32i()
{
  {
    init_simple_test("C_F_BFu32i");
    static STRUCT_IF_C C_F_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu32i)");
    check_field_offset(lv, v1, 0, "C_F_BFu32i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "C_F_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "C_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu32i, C_F_BFu32i)
//============================================================================


struct  C_F_BFu32ll  {
  char v1;
  float v2;
  __tsu64 v3:32;
};
//SIG(1 C_F_BFu32ll) C1{ Fc Fi FL:32}



static void Test_C_F_BFu32ll()
{
  {
    init_simple_test("C_F_BFu32ll");
    static STRUCT_IF_C C_F_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "C_F_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "C_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu32ll, C_F_BFu32ll)
//============================================================================


struct  C_F_BFu33  {
  char v1;
  float v2;
  __tsu64 v3:33;
};
//SIG(1 C_F_BFu33) C1{ Fc Fi FL:33}



static void Test_C_F_BFu33()
{
  {
    init_simple_test("C_F_BFu33");
    static STRUCT_IF_C C_F_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(C_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu33)");
    check_field_offset(lv, v1, 0, "C_F_BFu33.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "C_F_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "C_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu33, C_F_BFu33)
//============================================================================


struct  C_F_BFu7c  {
  char v1;
  float v2;
  unsigned char v3:7;
};
//SIG(1 C_F_BFu7c) C1{ Fc Fi Fc:7}



static void Test_C_F_BFu7c()
{
  {
    init_simple_test("C_F_BFu7c");
    static STRUCT_IF_C C_F_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu7c)");
    check_field_offset(lv, v1, 0, "C_F_BFu7c.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_F_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu7c, C_F_BFu7c)
//============================================================================


struct  C_F_BFu7i  {
  char v1;
  float v2;
  unsigned int v3:7;
};
//SIG(1 C_F_BFu7i) C1{ Fc Fi Fi:7}



static void Test_C_F_BFu7i()
{
  {
    init_simple_test("C_F_BFu7i");
    static STRUCT_IF_C C_F_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu7i)");
    check_field_offset(lv, v1, 0, "C_F_BFu7i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_F_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu7i, C_F_BFu7i)
//============================================================================


struct  C_F_BFu7ll  {
  char v1;
  float v2;
  __tsu64 v3:7;
};
//SIG(1 C_F_BFu7ll) C1{ Fc Fi FL:7}



static void Test_C_F_BFu7ll()
{
  {
    init_simple_test("C_F_BFu7ll");
    static STRUCT_IF_C C_F_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_F_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu7ll, C_F_BFu7ll)
//============================================================================


struct  C_F_BFu7s  {
  char v1;
  float v2;
  unsigned short v3:7;
};
//SIG(1 C_F_BFu7s) C1{ Fc Fi Fs:7}



static void Test_C_F_BFu7s()
{
  {
    init_simple_test("C_F_BFu7s");
    static STRUCT_IF_C C_F_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu7s)");
    check_field_offset(lv, v1, 0, "C_F_BFu7s.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_F_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu7s, C_F_BFu7s)
//============================================================================


struct  C_F_BFu8c  {
  char v1;
  float v2;
  unsigned char v3:8;
};
//SIG(1 C_F_BFu8c) C1{ Fc Fi Fc:8}



static void Test_C_F_BFu8c()
{
  {
    init_simple_test("C_F_BFu8c");
    static STRUCT_IF_C C_F_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu8c)");
    check_field_offset(lv, v1, 0, "C_F_BFu8c.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_F_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu8c, C_F_BFu8c)
//============================================================================


struct  C_F_BFu8i  {
  char v1;
  float v2;
  unsigned int v3:8;
};
//SIG(1 C_F_BFu8i) C1{ Fc Fi Fi:8}



static void Test_C_F_BFu8i()
{
  {
    init_simple_test("C_F_BFu8i");
    static STRUCT_IF_C C_F_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu8i)");
    check_field_offset(lv, v1, 0, "C_F_BFu8i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_F_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu8i, C_F_BFu8i)
//============================================================================


struct  C_F_BFu8ll  {
  char v1;
  float v2;
  __tsu64 v3:8;
};
//SIG(1 C_F_BFu8ll) C1{ Fc Fi FL:8}



static void Test_C_F_BFu8ll()
{
  {
    init_simple_test("C_F_BFu8ll");
    static STRUCT_IF_C C_F_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_F_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu8ll, C_F_BFu8ll)
//============================================================================


struct  C_F_BFu8s  {
  char v1;
  float v2;
  unsigned short v3:8;
};
//SIG(1 C_F_BFu8s) C1{ Fc Fi Fs:8}



static void Test_C_F_BFu8s()
{
  {
    init_simple_test("C_F_BFu8s");
    static STRUCT_IF_C C_F_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu8s)");
    check_field_offset(lv, v1, 0, "C_F_BFu8s.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_F_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu8s, C_F_BFu8s)
//============================================================================


struct  C_F_BFu9i  {
  char v1;
  float v2;
  unsigned int v3:9;
};
//SIG(1 C_F_BFu9i) C1{ Fc Fi Fi:9}



static void Test_C_F_BFu9i()
{
  {
    init_simple_test("C_F_BFu9i");
    static STRUCT_IF_C C_F_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu9i)");
    check_field_offset(lv, v1, 0, "C_F_BFu9i.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_F_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu9i, C_F_BFu9i)
//============================================================================


struct  C_F_BFu9ll  {
  char v1;
  float v2;
  __tsu64 v3:9;
};
//SIG(1 C_F_BFu9ll) C1{ Fc Fi FL:9}



static void Test_C_F_BFu9ll()
{
  {
    init_simple_test("C_F_BFu9ll");
    static STRUCT_IF_C C_F_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_F_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_F_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu9ll, C_F_BFu9ll)
//============================================================================


struct  C_F_BFu9s  {
  char v1;
  float v2;
  unsigned short v3:9;
};
//SIG(1 C_F_BFu9s) C1{ Fc Fi Fs:9}



static void Test_C_F_BFu9s()
{
  {
    init_simple_test("C_F_BFu9s");
    static STRUCT_IF_C C_F_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(C_F_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_BFu9s)");
    check_field_offset(lv, v1, 0, "C_F_BFu9s.v1");
    check_field_offset(lv, v2, 4, "C_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_F_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_BFu9s, C_F_BFu9s)
//============================================================================


struct  C_F_C  {
  char v1;
  float v2;
  char v3;
};
//SIG(1 C_F_C) C1{ Fc Fi Fc}



static void Test_C_F_C()
{
  {
    init_simple_test("C_F_C");
    STRUCT_IF_C C_F_C lv;
    check2(sizeof(lv), 12, "sizeof(C_F_C)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_C)");
    check_field_offset(lv, v1, 0, "C_F_C.v1");
    check_field_offset(lv, v2, 4, "C_F_C.v2");
    check_field_offset(lv, v3, 8, "C_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_C, C_F_C)
//============================================================================


struct  C_F_D  {
  char v1;
  float v2;
  double v3;
};
//SIG(1 C_F_D) C1{ Fc Fi FL}



static void Test_C_F_D()
{
  {
    init_simple_test("C_F_D");
    STRUCT_IF_C C_F_D lv;
    check2(sizeof(lv), 16, "sizeof(C_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_D)");
    check_field_offset(lv, v1, 0, "C_F_D.v1");
    check_field_offset(lv, v2, 4, "C_F_D.v2");
    check_field_offset(lv, v3, 8, "C_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_D, C_F_D)
//============================================================================


struct  C_F_F  {
  char v1;
  float v2;
  float v3;
};
//SIG(1 C_F_F) C1{ Fc Fi[2]}



static void Test_C_F_F()
{
  {
    init_simple_test("C_F_F");
    STRUCT_IF_C C_F_F lv;
    check2(sizeof(lv), 12, "sizeof(C_F_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_F)");
    check_field_offset(lv, v1, 0, "C_F_F.v1");
    check_field_offset(lv, v2, 4, "C_F_F.v2");
    check_field_offset(lv, v3, 8, "C_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_F, C_F_F)
//============================================================================


struct  C_F_I  {
  char v1;
  float v2;
  int v3;
};
//SIG(1 C_F_I) C1{ Fc Fi[2]}



static void Test_C_F_I()
{
  {
    init_simple_test("C_F_I");
    STRUCT_IF_C C_F_I lv;
    check2(sizeof(lv), 12, "sizeof(C_F_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_I)");
    check_field_offset(lv, v1, 0, "C_F_I.v1");
    check_field_offset(lv, v2, 4, "C_F_I.v2");
    check_field_offset(lv, v3, 8, "C_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_I, C_F_I)
//============================================================================


struct  C_F_Ip  {
  char v1;
  float v2;
  int *v3;
};
//SIG(1 C_F_Ip) C1{ Fc Fi Fp}



static void Test_C_F_Ip()
{
  {
    init_simple_test("C_F_Ip");
    STRUCT_IF_C C_F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_Ip)");
    check_field_offset(lv, v1, 0, "C_F_Ip.v1");
    check_field_offset(lv, v2, 4, "C_F_Ip.v2");
    check_field_offset(lv, v3, 8, "C_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_Ip, C_F_Ip)
//============================================================================


struct  C_F_L  {
  char v1;
  float v2;
  __tsi64 v3;
};
//SIG(1 C_F_L) C1{ Fc Fi FL}



static void Test_C_F_L()
{
  {
    init_simple_test("C_F_L");
    STRUCT_IF_C C_F_L lv;
    check2(sizeof(lv), 16, "sizeof(C_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_L)");
    check_field_offset(lv, v1, 0, "C_F_L.v1");
    check_field_offset(lv, v2, 4, "C_F_L.v2");
    check_field_offset(lv, v3, 8, "C_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_L, C_F_L)
//============================================================================


struct  C_F_S  {
  char v1;
  float v2;
  short v3;
};
//SIG(1 C_F_S) C1{ Fc Fi Fs}



static void Test_C_F_S()
{
  {
    init_simple_test("C_F_S");
    STRUCT_IF_C C_F_S lv;
    check2(sizeof(lv), 12, "sizeof(C_F_S)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_S)");
    check_field_offset(lv, v1, 0, "C_F_S.v1");
    check_field_offset(lv, v2, 4, "C_F_S.v2");
    check_field_offset(lv, v3, 8, "C_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_S, C_F_S)
//============================================================================


struct  C_F_Uc  {
  char v1;
  float v2;
  unsigned char v3;
};
//SIG(1 C_F_Uc) C1{ Fc Fi Fc}



static void Test_C_F_Uc()
{
  {
    init_simple_test("C_F_Uc");
    STRUCT_IF_C C_F_Uc lv;
    check2(sizeof(lv), 12, "sizeof(C_F_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_Uc)");
    check_field_offset(lv, v1, 0, "C_F_Uc.v1");
    check_field_offset(lv, v2, 4, "C_F_Uc.v2");
    check_field_offset(lv, v3, 8, "C_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_Uc, C_F_Uc)
//============================================================================


struct  C_F_Ui  {
  char v1;
  float v2;
  unsigned int v3;
};
//SIG(1 C_F_Ui) C1{ Fc Fi[2]}



static void Test_C_F_Ui()
{
  {
    init_simple_test("C_F_Ui");
    STRUCT_IF_C C_F_Ui lv;
    check2(sizeof(lv), 12, "sizeof(C_F_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_Ui)");
    check_field_offset(lv, v1, 0, "C_F_Ui.v1");
    check_field_offset(lv, v2, 4, "C_F_Ui.v2");
    check_field_offset(lv, v3, 8, "C_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_Ui, C_F_Ui)
//============================================================================


struct  C_F_Ul  {
  char v1;
  float v2;
  __tsu64 v3;
};
//SIG(1 C_F_Ul) C1{ Fc Fi FL}



static void Test_C_F_Ul()
{
  {
    init_simple_test("C_F_Ul");
    STRUCT_IF_C C_F_Ul lv;
    check2(sizeof(lv), 16, "sizeof(C_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_Ul)");
    check_field_offset(lv, v1, 0, "C_F_Ul.v1");
    check_field_offset(lv, v2, 4, "C_F_Ul.v2");
    check_field_offset(lv, v3, 8, "C_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_Ul, C_F_Ul)
//============================================================================


struct  C_F_Us  {
  char v1;
  float v2;
  unsigned short v3;
};
//SIG(1 C_F_Us) C1{ Fc Fi Fs}



static void Test_C_F_Us()
{
  {
    init_simple_test("C_F_Us");
    STRUCT_IF_C C_F_Us lv;
    check2(sizeof(lv), 12, "sizeof(C_F_Us)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_Us)");
    check_field_offset(lv, v1, 0, "C_F_Us.v1");
    check_field_offset(lv, v2, 4, "C_F_Us.v2");
    check_field_offset(lv, v3, 8, "C_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_Us, C_F_Us)
//============================================================================


struct  C_F_Vp  {
  char v1;
  float v2;
  void *v3;
};
//SIG(1 C_F_Vp) C1{ Fc Fi Fp}



static void Test_C_F_Vp()
{
  {
    init_simple_test("C_F_Vp");
    STRUCT_IF_C C_F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_F_Vp)");
    check_field_offset(lv, v1, 0, "C_F_Vp.v1");
    check_field_offset(lv, v2, 4, "C_F_Vp.v2");
    check_field_offset(lv, v3, 8, "C_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_F_Vp, C_F_Vp)
//============================================================================


struct  C_I  {
  char v1;
  int v2;
};
//SIG(1 C_I) C1{ Fc Fi}



static void Test_C_I()
{
  {
    init_simple_test("C_I");
    STRUCT_IF_C C_I lv;
    check2(sizeof(lv), 8, "sizeof(C_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_I)");
    check_field_offset(lv, v1, 0, "C_I.v1");
    check_field_offset(lv, v2, 4, "C_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I, C_I)
//============================================================================


struct  C_I_BFu15i  {
  char v1;
  int v2;
  unsigned int v3:15;
};
//SIG(1 C_I_BFu15i) C1{ Fc Fi Fi:15}



static void Test_C_I_BFu15i()
{
  {
    init_simple_test("C_I_BFu15i");
    static STRUCT_IF_C C_I_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu15i)");
    check_field_offset(lv, v1, 0, "C_I_BFu15i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_I_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu15i, C_I_BFu15i)
//============================================================================


struct  C_I_BFu15ll  {
  char v1;
  int v2;
  __tsu64 v3:15;
};
//SIG(1 C_I_BFu15ll) C1{ Fc Fi FL:15}



static void Test_C_I_BFu15ll()
{
  {
    init_simple_test("C_I_BFu15ll");
    static STRUCT_IF_C C_I_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_I_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu15ll, C_I_BFu15ll)
//============================================================================


struct  C_I_BFu15s  {
  char v1;
  int v2;
  unsigned short v3:15;
};
//SIG(1 C_I_BFu15s) C1{ Fc Fi Fs:15}



static void Test_C_I_BFu15s()
{
  {
    init_simple_test("C_I_BFu15s");
    static STRUCT_IF_C C_I_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu15s)");
    check_field_offset(lv, v1, 0, "C_I_BFu15s.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_I_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu15s, C_I_BFu15s)
//============================================================================


struct  C_I_BFu16i  {
  char v1;
  int v2;
  unsigned int v3:16;
};
//SIG(1 C_I_BFu16i) C1{ Fc Fi Fi:16}



static void Test_C_I_BFu16i()
{
  {
    init_simple_test("C_I_BFu16i");
    static STRUCT_IF_C C_I_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu16i)");
    check_field_offset(lv, v1, 0, "C_I_BFu16i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_I_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu16i, C_I_BFu16i)
//============================================================================


struct  C_I_BFu16ll  {
  char v1;
  int v2;
  __tsu64 v3:16;
};
//SIG(1 C_I_BFu16ll) C1{ Fc Fi FL:16}



static void Test_C_I_BFu16ll()
{
  {
    init_simple_test("C_I_BFu16ll");
    static STRUCT_IF_C C_I_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_I_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu16ll, C_I_BFu16ll)
//============================================================================


struct  C_I_BFu16s  {
  char v1;
  int v2;
  unsigned short v3:16;
};
//SIG(1 C_I_BFu16s) C1{ Fc Fi Fs:16}



static void Test_C_I_BFu16s()
{
  {
    init_simple_test("C_I_BFu16s");
    static STRUCT_IF_C C_I_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu16s)");
    check_field_offset(lv, v1, 0, "C_I_BFu16s.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_I_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu16s, C_I_BFu16s)
//============================================================================


struct  C_I_BFu17i  {
  char v1;
  int v2;
  unsigned int v3:17;
};
//SIG(1 C_I_BFu17i) C1{ Fc Fi Fi:17}



static void Test_C_I_BFu17i()
{
  {
    init_simple_test("C_I_BFu17i");
    static STRUCT_IF_C C_I_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu17i)");
    check_field_offset(lv, v1, 0, "C_I_BFu17i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "C_I_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "C_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu17i, C_I_BFu17i)
//============================================================================


struct  C_I_BFu17ll  {
  char v1;
  int v2;
  __tsu64 v3:17;
};
//SIG(1 C_I_BFu17ll) C1{ Fc Fi FL:17}



static void Test_C_I_BFu17ll()
{
  {
    init_simple_test("C_I_BFu17ll");
    static STRUCT_IF_C C_I_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "C_I_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "C_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu17ll, C_I_BFu17ll)
//============================================================================


struct  C_I_BFu1c  {
  char v1;
  int v2;
  unsigned char v3:1;
};
//SIG(1 C_I_BFu1c) C1{ Fc Fi Fc:1}



static void Test_C_I_BFu1c()
{
  {
    init_simple_test("C_I_BFu1c");
    static STRUCT_IF_C C_I_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu1c)");
    check_field_offset(lv, v1, 0, "C_I_BFu1c.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu1c, C_I_BFu1c)
//============================================================================


struct  C_I_BFu1i  {
  char v1;
  int v2;
  unsigned int v3:1;
};
//SIG(1 C_I_BFu1i) C1{ Fc Fi Fi:1}



static void Test_C_I_BFu1i()
{
  {
    init_simple_test("C_I_BFu1i");
    static STRUCT_IF_C C_I_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu1i)");
    check_field_offset(lv, v1, 0, "C_I_BFu1i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu1i, C_I_BFu1i)
//============================================================================


struct  C_I_BFu1ll  {
  char v1;
  int v2;
  __tsu64 v3:1;
};
//SIG(1 C_I_BFu1ll) C1{ Fc Fi FL:1}



static void Test_C_I_BFu1ll()
{
  {
    init_simple_test("C_I_BFu1ll");
    static STRUCT_IF_C C_I_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu1ll, C_I_BFu1ll)
//============================================================================


struct  C_I_BFu1s  {
  char v1;
  int v2;
  unsigned short v3:1;
};
//SIG(1 C_I_BFu1s) C1{ Fc Fi Fs:1}



static void Test_C_I_BFu1s()
{
  {
    init_simple_test("C_I_BFu1s");
    static STRUCT_IF_C C_I_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu1s)");
    check_field_offset(lv, v1, 0, "C_I_BFu1s.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu1s, C_I_BFu1s)
//============================================================================


struct  C_I_BFu31i  {
  char v1;
  int v2;
  unsigned int v3:31;
};
//SIG(1 C_I_BFu31i) C1{ Fc Fi Fi:31}



static void Test_C_I_BFu31i()
{
  {
    init_simple_test("C_I_BFu31i");
    static STRUCT_IF_C C_I_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu31i)");
    check_field_offset(lv, v1, 0, "C_I_BFu31i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "C_I_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "C_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu31i, C_I_BFu31i)
//============================================================================


struct  C_I_BFu31ll  {
  char v1;
  int v2;
  __tsu64 v3:31;
};
//SIG(1 C_I_BFu31ll) C1{ Fc Fi FL:31}



static void Test_C_I_BFu31ll()
{
  {
    init_simple_test("C_I_BFu31ll");
    static STRUCT_IF_C C_I_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "C_I_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "C_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu31ll, C_I_BFu31ll)
//============================================================================


struct  C_I_BFu32i  {
  char v1;
  int v2;
  unsigned int v3:32;
};
//SIG(1 C_I_BFu32i) C1{ Fc Fi Fi:32}



static void Test_C_I_BFu32i()
{
  {
    init_simple_test("C_I_BFu32i");
    static STRUCT_IF_C C_I_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu32i)");
    check_field_offset(lv, v1, 0, "C_I_BFu32i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "C_I_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "C_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu32i, C_I_BFu32i)
//============================================================================


struct  C_I_BFu32ll  {
  char v1;
  int v2;
  __tsu64 v3:32;
};
//SIG(1 C_I_BFu32ll) C1{ Fc Fi FL:32}



static void Test_C_I_BFu32ll()
{
  {
    init_simple_test("C_I_BFu32ll");
    static STRUCT_IF_C C_I_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "C_I_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "C_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu32ll, C_I_BFu32ll)
//============================================================================


struct  C_I_BFu33  {
  char v1;
  int v2;
  __tsu64 v3:33;
};
//SIG(1 C_I_BFu33) C1{ Fc Fi FL:33}



static void Test_C_I_BFu33()
{
  {
    init_simple_test("C_I_BFu33");
    static STRUCT_IF_C C_I_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(C_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu33)");
    check_field_offset(lv, v1, 0, "C_I_BFu33.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "C_I_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "C_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu33, C_I_BFu33)
//============================================================================


struct  C_I_BFu7c  {
  char v1;
  int v2;
  unsigned char v3:7;
};
//SIG(1 C_I_BFu7c) C1{ Fc Fi Fc:7}



static void Test_C_I_BFu7c()
{
  {
    init_simple_test("C_I_BFu7c");
    static STRUCT_IF_C C_I_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu7c)");
    check_field_offset(lv, v1, 0, "C_I_BFu7c.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_I_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu7c, C_I_BFu7c)
//============================================================================


struct  C_I_BFu7i  {
  char v1;
  int v2;
  unsigned int v3:7;
};
//SIG(1 C_I_BFu7i) C1{ Fc Fi Fi:7}



static void Test_C_I_BFu7i()
{
  {
    init_simple_test("C_I_BFu7i");
    static STRUCT_IF_C C_I_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu7i)");
    check_field_offset(lv, v1, 0, "C_I_BFu7i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_I_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu7i, C_I_BFu7i)
//============================================================================


struct  C_I_BFu7ll  {
  char v1;
  int v2;
  __tsu64 v3:7;
};
//SIG(1 C_I_BFu7ll) C1{ Fc Fi FL:7}



static void Test_C_I_BFu7ll()
{
  {
    init_simple_test("C_I_BFu7ll");
    static STRUCT_IF_C C_I_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_I_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu7ll, C_I_BFu7ll)
//============================================================================


struct  C_I_BFu7s  {
  char v1;
  int v2;
  unsigned short v3:7;
};
//SIG(1 C_I_BFu7s) C1{ Fc Fi Fs:7}



static void Test_C_I_BFu7s()
{
  {
    init_simple_test("C_I_BFu7s");
    static STRUCT_IF_C C_I_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu7s)");
    check_field_offset(lv, v1, 0, "C_I_BFu7s.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_I_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu7s, C_I_BFu7s)
//============================================================================


struct  C_I_BFu8c  {
  char v1;
  int v2;
  unsigned char v3:8;
};
//SIG(1 C_I_BFu8c) C1{ Fc Fi Fc:8}



static void Test_C_I_BFu8c()
{
  {
    init_simple_test("C_I_BFu8c");
    static STRUCT_IF_C C_I_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu8c)");
    check_field_offset(lv, v1, 0, "C_I_BFu8c.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_I_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu8c, C_I_BFu8c)
//============================================================================


struct  C_I_BFu8i  {
  char v1;
  int v2;
  unsigned int v3:8;
};
//SIG(1 C_I_BFu8i) C1{ Fc Fi Fi:8}



static void Test_C_I_BFu8i()
{
  {
    init_simple_test("C_I_BFu8i");
    static STRUCT_IF_C C_I_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu8i)");
    check_field_offset(lv, v1, 0, "C_I_BFu8i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_I_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu8i, C_I_BFu8i)
//============================================================================


struct  C_I_BFu8ll  {
  char v1;
  int v2;
  __tsu64 v3:8;
};
//SIG(1 C_I_BFu8ll) C1{ Fc Fi FL:8}



static void Test_C_I_BFu8ll()
{
  {
    init_simple_test("C_I_BFu8ll");
    static STRUCT_IF_C C_I_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_I_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu8ll, C_I_BFu8ll)
//============================================================================


struct  C_I_BFu8s  {
  char v1;
  int v2;
  unsigned short v3:8;
};
//SIG(1 C_I_BFu8s) C1{ Fc Fi Fs:8}



static void Test_C_I_BFu8s()
{
  {
    init_simple_test("C_I_BFu8s");
    static STRUCT_IF_C C_I_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu8s)");
    check_field_offset(lv, v1, 0, "C_I_BFu8s.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_I_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu8s, C_I_BFu8s)
//============================================================================


struct  C_I_BFu9i  {
  char v1;
  int v2;
  unsigned int v3:9;
};
//SIG(1 C_I_BFu9i) C1{ Fc Fi Fi:9}



static void Test_C_I_BFu9i()
{
  {
    init_simple_test("C_I_BFu9i");
    static STRUCT_IF_C C_I_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu9i)");
    check_field_offset(lv, v1, 0, "C_I_BFu9i.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_I_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu9i, C_I_BFu9i)
//============================================================================


struct  C_I_BFu9ll  {
  char v1;
  int v2;
  __tsu64 v3:9;
};
//SIG(1 C_I_BFu9ll) C1{ Fc Fi FL:9}



static void Test_C_I_BFu9ll()
{
  {
    init_simple_test("C_I_BFu9ll");
    static STRUCT_IF_C C_I_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_I_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_I_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu9ll, C_I_BFu9ll)
//============================================================================


struct  C_I_BFu9s  {
  char v1;
  int v2;
  unsigned short v3:9;
};
//SIG(1 C_I_BFu9s) C1{ Fc Fi Fs:9}



static void Test_C_I_BFu9s()
{
  {
    init_simple_test("C_I_BFu9s");
    static STRUCT_IF_C C_I_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(C_I_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_BFu9s)");
    check_field_offset(lv, v1, 0, "C_I_BFu9s.v1");
    check_field_offset(lv, v2, 4, "C_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_I_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_BFu9s, C_I_BFu9s)
//============================================================================


struct  C_I_C  {
  char v1;
  int v2;
  char v3;
};
//SIG(1 C_I_C) C1{ Fc Fi Fc}



static void Test_C_I_C()
{
  {
    init_simple_test("C_I_C");
    STRUCT_IF_C C_I_C lv;
    check2(sizeof(lv), 12, "sizeof(C_I_C)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_C)");
    check_field_offset(lv, v1, 0, "C_I_C.v1");
    check_field_offset(lv, v2, 4, "C_I_C.v2");
    check_field_offset(lv, v3, 8, "C_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_C, C_I_C)
//============================================================================


struct  C_I_D  {
  char v1;
  int v2;
  double v3;
};
//SIG(1 C_I_D) C1{ Fc Fi FL}



static void Test_C_I_D()
{
  {
    init_simple_test("C_I_D");
    STRUCT_IF_C C_I_D lv;
    check2(sizeof(lv), 16, "sizeof(C_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_D)");
    check_field_offset(lv, v1, 0, "C_I_D.v1");
    check_field_offset(lv, v2, 4, "C_I_D.v2");
    check_field_offset(lv, v3, 8, "C_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_D, C_I_D)
//============================================================================


struct  C_I_F  {
  char v1;
  int v2;
  float v3;
};
//SIG(1 C_I_F) C1{ Fc Fi[2]}



static void Test_C_I_F()
{
  {
    init_simple_test("C_I_F");
    STRUCT_IF_C C_I_F lv;
    check2(sizeof(lv), 12, "sizeof(C_I_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_F)");
    check_field_offset(lv, v1, 0, "C_I_F.v1");
    check_field_offset(lv, v2, 4, "C_I_F.v2");
    check_field_offset(lv, v3, 8, "C_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_F, C_I_F)
//============================================================================


struct  C_I_I  {
  char v1;
  int v2;
  int v3;
};
//SIG(1 C_I_I) C1{ Fc Fi[2]}



static void Test_C_I_I()
{
  {
    init_simple_test("C_I_I");
    STRUCT_IF_C C_I_I lv;
    check2(sizeof(lv), 12, "sizeof(C_I_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_I)");
    check_field_offset(lv, v1, 0, "C_I_I.v1");
    check_field_offset(lv, v2, 4, "C_I_I.v2");
    check_field_offset(lv, v3, 8, "C_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_I, C_I_I)
//============================================================================


struct  C_I_Ip  {
  char v1;
  int v2;
  int *v3;
};
//SIG(1 C_I_Ip) C1{ Fc Fi Fp}



static void Test_C_I_Ip()
{
  {
    init_simple_test("C_I_Ip");
    STRUCT_IF_C C_I_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_Ip)");
    check_field_offset(lv, v1, 0, "C_I_Ip.v1");
    check_field_offset(lv, v2, 4, "C_I_Ip.v2");
    check_field_offset(lv, v3, 8, "C_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_Ip, C_I_Ip)
//============================================================================


struct  C_I_L  {
  char v1;
  int v2;
  __tsi64 v3;
};
//SIG(1 C_I_L) C1{ Fc Fi FL}



static void Test_C_I_L()
{
  {
    init_simple_test("C_I_L");
    STRUCT_IF_C C_I_L lv;
    check2(sizeof(lv), 16, "sizeof(C_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_L)");
    check_field_offset(lv, v1, 0, "C_I_L.v1");
    check_field_offset(lv, v2, 4, "C_I_L.v2");
    check_field_offset(lv, v3, 8, "C_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_L, C_I_L)
//============================================================================


struct  C_I_S  {
  char v1;
  int v2;
  short v3;
};
//SIG(1 C_I_S) C1{ Fc Fi Fs}



static void Test_C_I_S()
{
  {
    init_simple_test("C_I_S");
    STRUCT_IF_C C_I_S lv;
    check2(sizeof(lv), 12, "sizeof(C_I_S)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_S)");
    check_field_offset(lv, v1, 0, "C_I_S.v1");
    check_field_offset(lv, v2, 4, "C_I_S.v2");
    check_field_offset(lv, v3, 8, "C_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_S, C_I_S)
//============================================================================


struct  C_I_Uc  {
  char v1;
  int v2;
  unsigned char v3;
};
//SIG(1 C_I_Uc) C1{ Fc Fi Fc}



static void Test_C_I_Uc()
{
  {
    init_simple_test("C_I_Uc");
    STRUCT_IF_C C_I_Uc lv;
    check2(sizeof(lv), 12, "sizeof(C_I_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_Uc)");
    check_field_offset(lv, v1, 0, "C_I_Uc.v1");
    check_field_offset(lv, v2, 4, "C_I_Uc.v2");
    check_field_offset(lv, v3, 8, "C_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_Uc, C_I_Uc)
//============================================================================


struct  C_I_Ui  {
  char v1;
  int v2;
  unsigned int v3;
};
//SIG(1 C_I_Ui) C1{ Fc Fi[2]}



static void Test_C_I_Ui()
{
  {
    init_simple_test("C_I_Ui");
    STRUCT_IF_C C_I_Ui lv;
    check2(sizeof(lv), 12, "sizeof(C_I_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_Ui)");
    check_field_offset(lv, v1, 0, "C_I_Ui.v1");
    check_field_offset(lv, v2, 4, "C_I_Ui.v2");
    check_field_offset(lv, v3, 8, "C_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_Ui, C_I_Ui)
//============================================================================


struct  C_I_Ul  {
  char v1;
  int v2;
  __tsu64 v3;
};
//SIG(1 C_I_Ul) C1{ Fc Fi FL}



static void Test_C_I_Ul()
{
  {
    init_simple_test("C_I_Ul");
    STRUCT_IF_C C_I_Ul lv;
    check2(sizeof(lv), 16, "sizeof(C_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_Ul)");
    check_field_offset(lv, v1, 0, "C_I_Ul.v1");
    check_field_offset(lv, v2, 4, "C_I_Ul.v2");
    check_field_offset(lv, v3, 8, "C_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_Ul, C_I_Ul)
//============================================================================


struct  C_I_Us  {
  char v1;
  int v2;
  unsigned short v3;
};
//SIG(1 C_I_Us) C1{ Fc Fi Fs}



static void Test_C_I_Us()
{
  {
    init_simple_test("C_I_Us");
    STRUCT_IF_C C_I_Us lv;
    check2(sizeof(lv), 12, "sizeof(C_I_Us)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_Us)");
    check_field_offset(lv, v1, 0, "C_I_Us.v1");
    check_field_offset(lv, v2, 4, "C_I_Us.v2");
    check_field_offset(lv, v3, 8, "C_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_Us, C_I_Us)
//============================================================================


struct  C_I_Vp  {
  char v1;
  int v2;
  void *v3;
};
//SIG(1 C_I_Vp) C1{ Fc Fi Fp}



static void Test_C_I_Vp()
{
  {
    init_simple_test("C_I_Vp");
    STRUCT_IF_C C_I_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_I_Vp)");
    check_field_offset(lv, v1, 0, "C_I_Vp.v1");
    check_field_offset(lv, v2, 4, "C_I_Vp.v2");
    check_field_offset(lv, v3, 8, "C_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_I_Vp, C_I_Vp)
//============================================================================


struct  C_Ip  {
  char v1;
  int *v2;
};
//SIG(1 C_Ip) C1{ Fc Fp}



static void Test_C_Ip()
{
  {
    init_simple_test("C_Ip");
    STRUCT_IF_C C_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip)");
    check_field_offset(lv, v1, 0, "C_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip, C_Ip)
//============================================================================


struct  C_Ip_BFu15i  {
  char v1;
  int *v2;
  unsigned int v3:15;
};
//SIG(1 C_Ip_BFu15i) C1{ Fc Fp Fi:15}



static void Test_C_Ip_BFu15i()
{
  {
    init_simple_test("C_Ip_BFu15i");
    static STRUCT_IF_C C_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "C_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "C_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu15i, C_Ip_BFu15i)
//============================================================================


struct  C_Ip_BFu15ll  {
  char v1;
  int *v2;
  __tsu64 v3:15;
};
//SIG(1 C_Ip_BFu15ll) C1{ Fc Fp FL:15}



static void Test_C_Ip_BFu15ll()
{
  {
    init_simple_test("C_Ip_BFu15ll");
    static STRUCT_IF_C C_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "C_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "C_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu15ll, C_Ip_BFu15ll)
//============================================================================


struct  C_Ip_BFu15s  {
  char v1;
  int *v2;
  unsigned short v3:15;
};
//SIG(1 C_Ip_BFu15s) C1{ Fc Fp Fs:15}



static void Test_C_Ip_BFu15s()
{
  {
    init_simple_test("C_Ip_BFu15s");
    static STRUCT_IF_C C_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "C_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "C_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu15s, C_Ip_BFu15s)
//============================================================================


struct  C_Ip_BFu16i  {
  char v1;
  int *v2;
  unsigned int v3:16;
};
//SIG(1 C_Ip_BFu16i) C1{ Fc Fp Fi:16}



static void Test_C_Ip_BFu16i()
{
  {
    init_simple_test("C_Ip_BFu16i");
    static STRUCT_IF_C C_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "C_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "C_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu16i, C_Ip_BFu16i)
//============================================================================


struct  C_Ip_BFu16ll  {
  char v1;
  int *v2;
  __tsu64 v3:16;
};
//SIG(1 C_Ip_BFu16ll) C1{ Fc Fp FL:16}



static void Test_C_Ip_BFu16ll()
{
  {
    init_simple_test("C_Ip_BFu16ll");
    static STRUCT_IF_C C_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "C_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "C_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu16ll, C_Ip_BFu16ll)
//============================================================================


struct  C_Ip_BFu16s  {
  char v1;
  int *v2;
  unsigned short v3:16;
};
//SIG(1 C_Ip_BFu16s) C1{ Fc Fp Fs:16}



static void Test_C_Ip_BFu16s()
{
  {
    init_simple_test("C_Ip_BFu16s");
    static STRUCT_IF_C C_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "C_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "C_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu16s, C_Ip_BFu16s)
//============================================================================


struct  C_Ip_BFu17i  {
  char v1;
  int *v2;
  unsigned int v3:17;
};
//SIG(1 C_Ip_BFu17i) C1{ Fc Fp Fi:17}



static void Test_C_Ip_BFu17i()
{
  {
    init_simple_test("C_Ip_BFu17i");
    static STRUCT_IF_C C_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "C_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "C_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu17i, C_Ip_BFu17i)
//============================================================================


struct  C_Ip_BFu17ll  {
  char v1;
  int *v2;
  __tsu64 v3:17;
};
//SIG(1 C_Ip_BFu17ll) C1{ Fc Fp FL:17}



static void Test_C_Ip_BFu17ll()
{
  {
    init_simple_test("C_Ip_BFu17ll");
    static STRUCT_IF_C C_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "C_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "C_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu17ll, C_Ip_BFu17ll)
//============================================================================


struct  C_Ip_BFu1c  {
  char v1;
  int *v2;
  unsigned char v3:1;
};
//SIG(1 C_Ip_BFu1c) C1{ Fc Fp Fc:1}



static void Test_C_Ip_BFu1c()
{
  {
    init_simple_test("C_Ip_BFu1c");
    static STRUCT_IF_C C_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "C_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu1c, C_Ip_BFu1c)
//============================================================================


struct  C_Ip_BFu1i  {
  char v1;
  int *v2;
  unsigned int v3:1;
};
//SIG(1 C_Ip_BFu1i) C1{ Fc Fp Fi:1}



static void Test_C_Ip_BFu1i()
{
  {
    init_simple_test("C_Ip_BFu1i");
    static STRUCT_IF_C C_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "C_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu1i, C_Ip_BFu1i)
//============================================================================


struct  C_Ip_BFu1ll  {
  char v1;
  int *v2;
  __tsu64 v3:1;
};
//SIG(1 C_Ip_BFu1ll) C1{ Fc Fp FL:1}



static void Test_C_Ip_BFu1ll()
{
  {
    init_simple_test("C_Ip_BFu1ll");
    static STRUCT_IF_C C_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "C_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu1ll, C_Ip_BFu1ll)
//============================================================================


struct  C_Ip_BFu1s  {
  char v1;
  int *v2;
  unsigned short v3:1;
};
//SIG(1 C_Ip_BFu1s) C1{ Fc Fp Fs:1}



static void Test_C_Ip_BFu1s()
{
  {
    init_simple_test("C_Ip_BFu1s");
    static STRUCT_IF_C C_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "C_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu1s, C_Ip_BFu1s)
//============================================================================


struct  C_Ip_BFu31i  {
  char v1;
  int *v2;
  unsigned int v3:31;
};
//SIG(1 C_Ip_BFu31i) C1{ Fc Fp Fi:31}



static void Test_C_Ip_BFu31i()
{
  {
    init_simple_test("C_Ip_BFu31i");
    static STRUCT_IF_C C_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "C_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "C_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu31i, C_Ip_BFu31i)
//============================================================================


struct  C_Ip_BFu31ll  {
  char v1;
  int *v2;
  __tsu64 v3:31;
};
//SIG(1 C_Ip_BFu31ll) C1{ Fc Fp FL:31}



static void Test_C_Ip_BFu31ll()
{
  {
    init_simple_test("C_Ip_BFu31ll");
    static STRUCT_IF_C C_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "C_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "C_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu31ll, C_Ip_BFu31ll)
//============================================================================


struct  C_Ip_BFu32i  {
  char v1;
  int *v2;
  unsigned int v3:32;
};
//SIG(1 C_Ip_BFu32i) C1{ Fc Fp Fi:32}



static void Test_C_Ip_BFu32i()
{
  {
    init_simple_test("C_Ip_BFu32i");
    static STRUCT_IF_C C_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "C_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "C_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu32i, C_Ip_BFu32i)
//============================================================================


struct  C_Ip_BFu32ll  {
  char v1;
  int *v2;
  __tsu64 v3:32;
};
//SIG(1 C_Ip_BFu32ll) C1{ Fc Fp FL:32}



static void Test_C_Ip_BFu32ll()
{
  {
    init_simple_test("C_Ip_BFu32ll");
    static STRUCT_IF_C C_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "C_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "C_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu32ll, C_Ip_BFu32ll)
//============================================================================


struct  C_Ip_BFu33  {
  char v1;
  int *v2;
  __tsu64 v3:33;
};
//SIG(1 C_Ip_BFu33) C1{ Fc Fp FL:33}



static void Test_C_Ip_BFu33()
{
  {
    init_simple_test("C_Ip_BFu33");
    static STRUCT_IF_C C_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "C_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "C_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu33, C_Ip_BFu33)
//============================================================================


struct  C_Ip_BFu7c  {
  char v1;
  int *v2;
  unsigned char v3:7;
};
//SIG(1 C_Ip_BFu7c) C1{ Fc Fp Fc:7}



static void Test_C_Ip_BFu7c()
{
  {
    init_simple_test("C_Ip_BFu7c");
    static STRUCT_IF_C C_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "C_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "C_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu7c, C_Ip_BFu7c)
//============================================================================


struct  C_Ip_BFu7i  {
  char v1;
  int *v2;
  unsigned int v3:7;
};
//SIG(1 C_Ip_BFu7i) C1{ Fc Fp Fi:7}



static void Test_C_Ip_BFu7i()
{
  {
    init_simple_test("C_Ip_BFu7i");
    static STRUCT_IF_C C_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "C_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "C_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu7i, C_Ip_BFu7i)
//============================================================================


struct  C_Ip_BFu7ll  {
  char v1;
  int *v2;
  __tsu64 v3:7;
};
//SIG(1 C_Ip_BFu7ll) C1{ Fc Fp FL:7}



static void Test_C_Ip_BFu7ll()
{
  {
    init_simple_test("C_Ip_BFu7ll");
    static STRUCT_IF_C C_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "C_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "C_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu7ll, C_Ip_BFu7ll)
//============================================================================


struct  C_Ip_BFu7s  {
  char v1;
  int *v2;
  unsigned short v3:7;
};
//SIG(1 C_Ip_BFu7s) C1{ Fc Fp Fs:7}



static void Test_C_Ip_BFu7s()
{
  {
    init_simple_test("C_Ip_BFu7s");
    static STRUCT_IF_C C_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "C_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "C_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu7s, C_Ip_BFu7s)
//============================================================================


struct  C_Ip_BFu8c  {
  char v1;
  int *v2;
  unsigned char v3:8;
};
//SIG(1 C_Ip_BFu8c) C1{ Fc Fp Fc:8}



static void Test_C_Ip_BFu8c()
{
  {
    init_simple_test("C_Ip_BFu8c");
    static STRUCT_IF_C C_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "C_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "C_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu8c, C_Ip_BFu8c)
//============================================================================


struct  C_Ip_BFu8i  {
  char v1;
  int *v2;
  unsigned int v3:8;
};
//SIG(1 C_Ip_BFu8i) C1{ Fc Fp Fi:8}



static void Test_C_Ip_BFu8i()
{
  {
    init_simple_test("C_Ip_BFu8i");
    static STRUCT_IF_C C_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "C_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "C_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu8i, C_Ip_BFu8i)
//============================================================================


struct  C_Ip_BFu8ll  {
  char v1;
  int *v2;
  __tsu64 v3:8;
};
//SIG(1 C_Ip_BFu8ll) C1{ Fc Fp FL:8}



static void Test_C_Ip_BFu8ll()
{
  {
    init_simple_test("C_Ip_BFu8ll");
    static STRUCT_IF_C C_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "C_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "C_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu8ll, C_Ip_BFu8ll)
//============================================================================


struct  C_Ip_BFu8s  {
  char v1;
  int *v2;
  unsigned short v3:8;
};
//SIG(1 C_Ip_BFu8s) C1{ Fc Fp Fs:8}



static void Test_C_Ip_BFu8s()
{
  {
    init_simple_test("C_Ip_BFu8s");
    static STRUCT_IF_C C_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "C_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "C_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu8s, C_Ip_BFu8s)
//============================================================================


struct  C_Ip_BFu9i  {
  char v1;
  int *v2;
  unsigned int v3:9;
};
//SIG(1 C_Ip_BFu9i) C1{ Fc Fp Fi:9}



static void Test_C_Ip_BFu9i()
{
  {
    init_simple_test("C_Ip_BFu9i");
    static STRUCT_IF_C C_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "C_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "C_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu9i, C_Ip_BFu9i)
//============================================================================


struct  C_Ip_BFu9ll  {
  char v1;
  int *v2;
  __tsu64 v3:9;
};
//SIG(1 C_Ip_BFu9ll) C1{ Fc Fp FL:9}



static void Test_C_Ip_BFu9ll()
{
  {
    init_simple_test("C_Ip_BFu9ll");
    static STRUCT_IF_C C_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "C_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "C_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu9ll, C_Ip_BFu9ll)
//============================================================================


struct  C_Ip_BFu9s  {
  char v1;
  int *v2;
  unsigned short v3:9;
};
//SIG(1 C_Ip_BFu9s) C1{ Fc Fp Fs:9}



static void Test_C_Ip_BFu9s()
{
  {
    init_simple_test("C_Ip_BFu9s");
    static STRUCT_IF_C C_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "C_Ip_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "C_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "C_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_BFu9s, C_Ip_BFu9s)
//============================================================================


struct  C_Ip_C  {
  char v1;
  int *v2;
  char v3;
};
//SIG(1 C_Ip_C) C1{ Fc Fp Fc}



static void Test_C_Ip_C()
{
  {
    init_simple_test("C_Ip_C");
    STRUCT_IF_C C_Ip_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_C)");
    check_field_offset(lv, v1, 0, "C_Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_C, C_Ip_C)
//============================================================================


struct  C_Ip_D  {
  char v1;
  int *v2;
  double v3;
};
//SIG(1 C_Ip_D) C1{ Fc Fp FL}



static void Test_C_Ip_D()
{
  {
    init_simple_test("C_Ip_D");
    STRUCT_IF_C C_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_D)");
    check_field_offset(lv, v1, 0, "C_Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_D, C_Ip_D)
//============================================================================


struct  C_Ip_F  {
  char v1;
  int *v2;
  float v3;
};
//SIG(1 C_Ip_F) C1{ Fc Fp Fi}



static void Test_C_Ip_F()
{
  {
    init_simple_test("C_Ip_F");
    STRUCT_IF_C C_Ip_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_F)");
    check_field_offset(lv, v1, 0, "C_Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_F, C_Ip_F)
//============================================================================


struct  C_Ip_I  {
  char v1;
  int *v2;
  int v3;
};
//SIG(1 C_Ip_I) C1{ Fc Fp Fi}



static void Test_C_Ip_I()
{
  {
    init_simple_test("C_Ip_I");
    STRUCT_IF_C C_Ip_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_I)");
    check_field_offset(lv, v1, 0, "C_Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_I, C_Ip_I)
//============================================================================


struct  C_Ip_Ip  {
  char v1;
  int *v2;
  int *v3;
};
//SIG(1 C_Ip_Ip) C1{ Fc Fp[2]}



static void Test_C_Ip_Ip()
{
  {
    init_simple_test("C_Ip_Ip");
    STRUCT_IF_C C_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_Ip)");
    check_field_offset(lv, v1, 0, "C_Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_Ip, C_Ip_Ip)
//============================================================================


struct  C_Ip_L  {
  char v1;
  int *v2;
  __tsi64 v3;
};
//SIG(1 C_Ip_L) C1{ Fc Fp FL}



static void Test_C_Ip_L()
{
  {
    init_simple_test("C_Ip_L");
    STRUCT_IF_C C_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ip_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_L)");
    check_field_offset(lv, v1, 0, "C_Ip_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_L, C_Ip_L)
//============================================================================


struct  C_Ip_S  {
  char v1;
  int *v2;
  short v3;
};
//SIG(1 C_Ip_S) C1{ Fc Fp Fs}



static void Test_C_Ip_S()
{
  {
    init_simple_test("C_Ip_S");
    STRUCT_IF_C C_Ip_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_S)");
    check_field_offset(lv, v1, 0, "C_Ip_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_S, C_Ip_S)
//============================================================================


struct  C_Ip_Uc  {
  char v1;
  int *v2;
  unsigned char v3;
};
//SIG(1 C_Ip_Uc) C1{ Fc Fp Fc}



static void Test_C_Ip_Uc()
{
  {
    init_simple_test("C_Ip_Uc");
    STRUCT_IF_C C_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_Uc)");
    check_field_offset(lv, v1, 0, "C_Ip_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_Uc, C_Ip_Uc)
//============================================================================


struct  C_Ip_Ui  {
  char v1;
  int *v2;
  unsigned int v3;
};
//SIG(1 C_Ip_Ui) C1{ Fc Fp Fi}



static void Test_C_Ip_Ui()
{
  {
    init_simple_test("C_Ip_Ui");
    STRUCT_IF_C C_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_Ui)");
    check_field_offset(lv, v1, 0, "C_Ip_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_Ui, C_Ip_Ui)
//============================================================================


struct  C_Ip_Ul  {
  char v1;
  int *v2;
  __tsu64 v3;
};
//SIG(1 C_Ip_Ul) C1{ Fc Fp FL}



static void Test_C_Ip_Ul()
{
  {
    init_simple_test("C_Ip_Ul");
    STRUCT_IF_C C_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ip_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_Ul)");
    check_field_offset(lv, v1, 0, "C_Ip_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_Ul, C_Ip_Ul)
//============================================================================


struct  C_Ip_Us  {
  char v1;
  int *v2;
  unsigned short v3;
};
//SIG(1 C_Ip_Us) C1{ Fc Fp Fs}



static void Test_C_Ip_Us()
{
  {
    init_simple_test("C_Ip_Us");
    STRUCT_IF_C C_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_Us)");
    check_field_offset(lv, v1, 0, "C_Ip_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_Us, C_Ip_Us)
//============================================================================


struct  C_Ip_Vp  {
  char v1;
  int *v2;
  void *v3;
};
//SIG(1 C_Ip_Vp) C1{ Fc Fp[2]}



static void Test_C_Ip_Vp()
{
  {
    init_simple_test("C_Ip_Vp");
    STRUCT_IF_C C_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_Vp)");
    check_field_offset(lv, v1, 0, "C_Ip_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ip_Vp, C_Ip_Vp)
//============================================================================


struct  C_L  {
  char v1;
  __tsi64 v2;
};
//SIG(1 C_L) C1{ Fc FL}



static void Test_C_L()
{
  {
    init_simple_test("C_L");
    STRUCT_IF_C C_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L)");
    check_field_offset(lv, v1, 0, "C_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L, C_L)
//============================================================================


struct  C_L_BFu15i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:15;
};
//SIG(1 C_L_BFu15i) C1{ Fc FL Fi:15}



static void Test_C_L_BFu15i()
{
  {
    init_simple_test("C_L_BFu15i");
    static STRUCT_IF_C C_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu15i)");
    check_field_offset(lv, v1, 0, "C_L_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_L_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu15i, C_L_BFu15i)
//============================================================================


struct  C_L_BFu15ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:15;
};
//SIG(1 C_L_BFu15ll) C1{ Fc FL FL:15}



static void Test_C_L_BFu15ll()
{
  {
    init_simple_test("C_L_BFu15ll");
    static STRUCT_IF_C C_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_L_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu15ll, C_L_BFu15ll)
//============================================================================


struct  C_L_BFu15s  {
  char v1;
  __tsi64 v2;
  unsigned short v3:15;
};
//SIG(1 C_L_BFu15s) C1{ Fc FL Fs:15}



static void Test_C_L_BFu15s()
{
  {
    init_simple_test("C_L_BFu15s");
    static STRUCT_IF_C C_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu15s)");
    check_field_offset(lv, v1, 0, "C_L_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_L_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu15s, C_L_BFu15s)
//============================================================================


struct  C_L_BFu16i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:16;
};
//SIG(1 C_L_BFu16i) C1{ Fc FL Fi:16}



static void Test_C_L_BFu16i()
{
  {
    init_simple_test("C_L_BFu16i");
    static STRUCT_IF_C C_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu16i)");
    check_field_offset(lv, v1, 0, "C_L_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_L_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu16i, C_L_BFu16i)
//============================================================================


struct  C_L_BFu16ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:16;
};
//SIG(1 C_L_BFu16ll) C1{ Fc FL FL:16}



static void Test_C_L_BFu16ll()
{
  {
    init_simple_test("C_L_BFu16ll");
    static STRUCT_IF_C C_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_L_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu16ll, C_L_BFu16ll)
//============================================================================


struct  C_L_BFu16s  {
  char v1;
  __tsi64 v2;
  unsigned short v3:16;
};
//SIG(1 C_L_BFu16s) C1{ Fc FL Fs:16}



static void Test_C_L_BFu16s()
{
  {
    init_simple_test("C_L_BFu16s");
    static STRUCT_IF_C C_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu16s)");
    check_field_offset(lv, v1, 0, "C_L_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_L_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu16s, C_L_BFu16s)
//============================================================================


struct  C_L_BFu17i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:17;
};
//SIG(1 C_L_BFu17i) C1{ Fc FL Fi:17}



static void Test_C_L_BFu17i()
{
  {
    init_simple_test("C_L_BFu17i");
    static STRUCT_IF_C C_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu17i)");
    check_field_offset(lv, v1, 0, "C_L_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "C_L_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "C_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu17i, C_L_BFu17i)
//============================================================================


struct  C_L_BFu17ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:17;
};
//SIG(1 C_L_BFu17ll) C1{ Fc FL FL:17}



static void Test_C_L_BFu17ll()
{
  {
    init_simple_test("C_L_BFu17ll");
    static STRUCT_IF_C C_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "C_L_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "C_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu17ll, C_L_BFu17ll)
//============================================================================


struct  C_L_BFu1c  {
  char v1;
  __tsi64 v2;
  unsigned char v3:1;
};
//SIG(1 C_L_BFu1c) C1{ Fc FL Fc:1}



static void Test_C_L_BFu1c()
{
  {
    init_simple_test("C_L_BFu1c");
    static STRUCT_IF_C C_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu1c)");
    check_field_offset(lv, v1, 0, "C_L_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu1c, C_L_BFu1c)
//============================================================================


struct  C_L_BFu1i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:1;
};
//SIG(1 C_L_BFu1i) C1{ Fc FL Fi:1}



static void Test_C_L_BFu1i()
{
  {
    init_simple_test("C_L_BFu1i");
    static STRUCT_IF_C C_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu1i)");
    check_field_offset(lv, v1, 0, "C_L_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu1i, C_L_BFu1i)
//============================================================================


struct  C_L_BFu1ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:1;
};
//SIG(1 C_L_BFu1ll) C1{ Fc FL FL:1}



static void Test_C_L_BFu1ll()
{
  {
    init_simple_test("C_L_BFu1ll");
    static STRUCT_IF_C C_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu1ll, C_L_BFu1ll)
//============================================================================


struct  C_L_BFu1s  {
  char v1;
  __tsi64 v2;
  unsigned short v3:1;
};
//SIG(1 C_L_BFu1s) C1{ Fc FL Fs:1}



static void Test_C_L_BFu1s()
{
  {
    init_simple_test("C_L_BFu1s");
    static STRUCT_IF_C C_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu1s)");
    check_field_offset(lv, v1, 0, "C_L_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu1s, C_L_BFu1s)
//============================================================================


struct  C_L_BFu31i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:31;
};
//SIG(1 C_L_BFu31i) C1{ Fc FL Fi:31}



static void Test_C_L_BFu31i()
{
  {
    init_simple_test("C_L_BFu31i");
    static STRUCT_IF_C C_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu31i)");
    check_field_offset(lv, v1, 0, "C_L_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "C_L_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "C_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu31i, C_L_BFu31i)
//============================================================================


struct  C_L_BFu31ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:31;
};
//SIG(1 C_L_BFu31ll) C1{ Fc FL FL:31}



static void Test_C_L_BFu31ll()
{
  {
    init_simple_test("C_L_BFu31ll");
    static STRUCT_IF_C C_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "C_L_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "C_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu31ll, C_L_BFu31ll)
//============================================================================


struct  C_L_BFu32i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:32;
};
//SIG(1 C_L_BFu32i) C1{ Fc FL Fi:32}



static void Test_C_L_BFu32i()
{
  {
    init_simple_test("C_L_BFu32i");
    static STRUCT_IF_C C_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu32i)");
    check_field_offset(lv, v1, 0, "C_L_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "C_L_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "C_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu32i, C_L_BFu32i)
//============================================================================


struct  C_L_BFu32ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:32;
};
//SIG(1 C_L_BFu32ll) C1{ Fc FL FL:32}



static void Test_C_L_BFu32ll()
{
  {
    init_simple_test("C_L_BFu32ll");
    static STRUCT_IF_C C_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "C_L_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "C_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu32ll, C_L_BFu32ll)
//============================================================================


struct  C_L_BFu33  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:33;
};
//SIG(1 C_L_BFu33) C1{ Fc FL FL:33}



static void Test_C_L_BFu33()
{
  {
    init_simple_test("C_L_BFu33");
    static STRUCT_IF_C C_L_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_L_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu33)");
    check_field_offset(lv, v1, 0, "C_L_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "C_L_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "C_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu33, C_L_BFu33)
//============================================================================


struct  C_L_BFu7c  {
  char v1;
  __tsi64 v2;
  unsigned char v3:7;
};
//SIG(1 C_L_BFu7c) C1{ Fc FL Fc:7}



static void Test_C_L_BFu7c()
{
  {
    init_simple_test("C_L_BFu7c");
    static STRUCT_IF_C C_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu7c)");
    check_field_offset(lv, v1, 0, "C_L_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_L_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu7c, C_L_BFu7c)
//============================================================================


struct  C_L_BFu7i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:7;
};
//SIG(1 C_L_BFu7i) C1{ Fc FL Fi:7}



static void Test_C_L_BFu7i()
{
  {
    init_simple_test("C_L_BFu7i");
    static STRUCT_IF_C C_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu7i)");
    check_field_offset(lv, v1, 0, "C_L_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_L_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu7i, C_L_BFu7i)
//============================================================================


struct  C_L_BFu7ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:7;
};
//SIG(1 C_L_BFu7ll) C1{ Fc FL FL:7}



static void Test_C_L_BFu7ll()
{
  {
    init_simple_test("C_L_BFu7ll");
    static STRUCT_IF_C C_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_L_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu7ll, C_L_BFu7ll)
//============================================================================


struct  C_L_BFu7s  {
  char v1;
  __tsi64 v2;
  unsigned short v3:7;
};
//SIG(1 C_L_BFu7s) C1{ Fc FL Fs:7}



static void Test_C_L_BFu7s()
{
  {
    init_simple_test("C_L_BFu7s");
    static STRUCT_IF_C C_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu7s)");
    check_field_offset(lv, v1, 0, "C_L_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_L_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu7s, C_L_BFu7s)
//============================================================================


struct  C_L_BFu8c  {
  char v1;
  __tsi64 v2;
  unsigned char v3:8;
};
//SIG(1 C_L_BFu8c) C1{ Fc FL Fc:8}



static void Test_C_L_BFu8c()
{
  {
    init_simple_test("C_L_BFu8c");
    static STRUCT_IF_C C_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu8c)");
    check_field_offset(lv, v1, 0, "C_L_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_L_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu8c, C_L_BFu8c)
//============================================================================


struct  C_L_BFu8i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:8;
};
//SIG(1 C_L_BFu8i) C1{ Fc FL Fi:8}



static void Test_C_L_BFu8i()
{
  {
    init_simple_test("C_L_BFu8i");
    static STRUCT_IF_C C_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu8i)");
    check_field_offset(lv, v1, 0, "C_L_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_L_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu8i, C_L_BFu8i)
//============================================================================


struct  C_L_BFu8ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:8;
};
//SIG(1 C_L_BFu8ll) C1{ Fc FL FL:8}



static void Test_C_L_BFu8ll()
{
  {
    init_simple_test("C_L_BFu8ll");
    static STRUCT_IF_C C_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_L_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu8ll, C_L_BFu8ll)
//============================================================================


struct  C_L_BFu8s  {
  char v1;
  __tsi64 v2;
  unsigned short v3:8;
};
//SIG(1 C_L_BFu8s) C1{ Fc FL Fs:8}



static void Test_C_L_BFu8s()
{
  {
    init_simple_test("C_L_BFu8s");
    static STRUCT_IF_C C_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu8s)");
    check_field_offset(lv, v1, 0, "C_L_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_L_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu8s, C_L_BFu8s)
//============================================================================


struct  C_L_BFu9i  {
  char v1;
  __tsi64 v2;
  unsigned int v3:9;
};
//SIG(1 C_L_BFu9i) C1{ Fc FL Fi:9}



static void Test_C_L_BFu9i()
{
  {
    init_simple_test("C_L_BFu9i");
    static STRUCT_IF_C C_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu9i)");
    check_field_offset(lv, v1, 0, "C_L_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_L_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu9i, C_L_BFu9i)
//============================================================================


struct  C_L_BFu9ll  {
  char v1;
  __tsi64 v2;
  __tsu64 v3:9;
};
//SIG(1 C_L_BFu9ll) C1{ Fc FL FL:9}



static void Test_C_L_BFu9ll()
{
  {
    init_simple_test("C_L_BFu9ll");
    static STRUCT_IF_C C_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_L_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_L_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu9ll, C_L_BFu9ll)
//============================================================================


struct  C_L_BFu9s  {
  char v1;
  __tsi64 v2;
  unsigned short v3:9;
};
//SIG(1 C_L_BFu9s) C1{ Fc FL Fs:9}



static void Test_C_L_BFu9s()
{
  {
    init_simple_test("C_L_BFu9s");
    static STRUCT_IF_C C_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_BFu9s)");
    check_field_offset(lv, v1, 0, "C_L_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_L_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_BFu9s, C_L_BFu9s)
//============================================================================


struct  C_L_C  {
  char v1;
  __tsi64 v2;
  char v3;
};
//SIG(1 C_L_C) C1{ Fc FL Fc}



static void Test_C_L_C()
{
  {
    init_simple_test("C_L_C");
    STRUCT_IF_C C_L_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_C)");
    check_field_offset(lv, v1, 0, "C_L_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_C, C_L_C)
//============================================================================


struct  C_L_D  {
  char v1;
  __tsi64 v2;
  double v3;
};
//SIG(1 C_L_D) C1{ Fc FL[2]}



static void Test_C_L_D()
{
  {
    init_simple_test("C_L_D");
    STRUCT_IF_C C_L_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_L_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_D)");
    check_field_offset(lv, v1, 0, "C_L_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_D, C_L_D)
//============================================================================


struct  C_L_F  {
  char v1;
  __tsi64 v2;
  float v3;
};
//SIG(1 C_L_F) C1{ Fc FL Fi}



static void Test_C_L_F()
{
  {
    init_simple_test("C_L_F");
    STRUCT_IF_C C_L_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_F)");
    check_field_offset(lv, v1, 0, "C_L_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_F, C_L_F)
//============================================================================


struct  C_L_I  {
  char v1;
  __tsi64 v2;
  int v3;
};
//SIG(1 C_L_I) C1{ Fc FL Fi}



static void Test_C_L_I()
{
  {
    init_simple_test("C_L_I");
    STRUCT_IF_C C_L_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_I)");
    check_field_offset(lv, v1, 0, "C_L_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_I, C_L_I)
//============================================================================


struct  C_L_Ip  {
  char v1;
  __tsi64 v2;
  int *v3;
};
//SIG(1 C_L_Ip) C1{ Fc FL Fp}



static void Test_C_L_Ip()
{
  {
    init_simple_test("C_L_Ip");
    STRUCT_IF_C C_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_Ip)");
    check_field_offset(lv, v1, 0, "C_L_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_Ip, C_L_Ip)
//============================================================================


struct  C_L_L  {
  char v1;
  __tsi64 v2;
  __tsi64 v3;
};
//SIG(1 C_L_L) C1{ Fc FL[2]}



static void Test_C_L_L()
{
  {
    init_simple_test("C_L_L");
    STRUCT_IF_C C_L_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_L_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_L)");
    check_field_offset(lv, v1, 0, "C_L_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_L, C_L_L)
//============================================================================


struct  C_L_S  {
  char v1;
  __tsi64 v2;
  short v3;
};
//SIG(1 C_L_S) C1{ Fc FL Fs}



static void Test_C_L_S()
{
  {
    init_simple_test("C_L_S");
    STRUCT_IF_C C_L_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_S)");
    check_field_offset(lv, v1, 0, "C_L_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_S, C_L_S)
//============================================================================


struct  C_L_Uc  {
  char v1;
  __tsi64 v2;
  unsigned char v3;
};
//SIG(1 C_L_Uc) C1{ Fc FL Fc}



static void Test_C_L_Uc()
{
  {
    init_simple_test("C_L_Uc");
    STRUCT_IF_C C_L_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_Uc)");
    check_field_offset(lv, v1, 0, "C_L_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_Uc, C_L_Uc)
//============================================================================


struct  C_L_Ui  {
  char v1;
  __tsi64 v2;
  unsigned int v3;
};
//SIG(1 C_L_Ui) C1{ Fc FL Fi}



static void Test_C_L_Ui()
{
  {
    init_simple_test("C_L_Ui");
    STRUCT_IF_C C_L_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_Ui)");
    check_field_offset(lv, v1, 0, "C_L_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_Ui, C_L_Ui)
//============================================================================


struct  C_L_Ul  {
  char v1;
  __tsi64 v2;
  __tsu64 v3;
};
//SIG(1 C_L_Ul) C1{ Fc FL[2]}



static void Test_C_L_Ul()
{
  {
    init_simple_test("C_L_Ul");
    STRUCT_IF_C C_L_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_Ul)");
    check_field_offset(lv, v1, 0, "C_L_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_Ul, C_L_Ul)
//============================================================================


struct  C_L_Us  {
  char v1;
  __tsi64 v2;
  unsigned short v3;
};
//SIG(1 C_L_Us) C1{ Fc FL Fs}



static void Test_C_L_Us()
{
  {
    init_simple_test("C_L_Us");
    STRUCT_IF_C C_L_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_Us)");
    check_field_offset(lv, v1, 0, "C_L_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_Us, C_L_Us)
//============================================================================


struct  C_L_Vp  {
  char v1;
  __tsi64 v2;
  void *v3;
};
//SIG(1 C_L_Vp) C1{ Fc FL Fp}



static void Test_C_L_Vp()
{
  {
    init_simple_test("C_L_Vp");
    STRUCT_IF_C C_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_Vp)");
    check_field_offset(lv, v1, 0, "C_L_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_L_Vp, C_L_Vp)
//============================================================================


struct  C_S  {
  char v1;
  short v2;
};
//SIG(1 C_S) C1{ Fc Fs}



static void Test_C_S()
{
  {
    init_simple_test("C_S");
    STRUCT_IF_C C_S lv;
    check2(sizeof(lv), 4, "sizeof(C_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_S)");
    check_field_offset(lv, v1, 0, "C_S.v1");
    check_field_offset(lv, v2, 2, "C_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S, C_S)
//============================================================================


struct  C_S_BFu15i  {
  char v1;
  short v2;
  unsigned int v3:15;
};
//SIG(1 C_S_BFu15i) C1{ Fc Fs Fi:15}



static void Test_C_S_BFu15i()
{
  {
    init_simple_test("C_S_BFu15i");
    static STRUCT_IF_C C_S_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu15i)");
    check_field_offset(lv, v1, 0, "C_S_BFu15i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "C_S_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "C_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu15i, C_S_BFu15i)
//============================================================================


struct  C_S_BFu15ll  {
  char v1;
  short v2;
  __tsu64 v3:15;
};
//SIG(1 C_S_BFu15ll) C1{ Fc Fs FL:15}



static void Test_C_S_BFu15ll()
{
  {
    init_simple_test("C_S_BFu15ll");
    static STRUCT_IF_C C_S_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "C_S_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "C_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu15ll, C_S_BFu15ll)
//============================================================================


struct  C_S_BFu15s  {
  char v1;
  short v2;
  unsigned short v3:15;
};
//SIG(1 C_S_BFu15s) C1{ Fc Fs Fs:15}



static void Test_C_S_BFu15s()
{
  {
    init_simple_test("C_S_BFu15s");
    static STRUCT_IF_C C_S_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu15s)");
    check_field_offset(lv, v1, 0, "C_S_BFu15s.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "C_S_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "C_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu15s, C_S_BFu15s)
//============================================================================


struct  C_S_BFu16i  {
  char v1;
  short v2;
  unsigned int v3:16;
};
//SIG(1 C_S_BFu16i) C1{ Fc Fs Fi:16}



static void Test_C_S_BFu16i()
{
  {
    init_simple_test("C_S_BFu16i");
    static STRUCT_IF_C C_S_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu16i)");
    check_field_offset(lv, v1, 0, "C_S_BFu16i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_S_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu16i, C_S_BFu16i)
//============================================================================


struct  C_S_BFu16ll  {
  char v1;
  short v2;
  __tsu64 v3:16;
};
//SIG(1 C_S_BFu16ll) C1{ Fc Fs FL:16}



static void Test_C_S_BFu16ll()
{
  {
    init_simple_test("C_S_BFu16ll");
    static STRUCT_IF_C C_S_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_S_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu16ll, C_S_BFu16ll)
//============================================================================


struct  C_S_BFu16s  {
  char v1;
  short v2;
  unsigned short v3:16;
};
//SIG(1 C_S_BFu16s) C1{ Fc Fs Fs:16}



static void Test_C_S_BFu16s()
{
  {
    init_simple_test("C_S_BFu16s");
    static STRUCT_IF_C C_S_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu16s)");
    check_field_offset(lv, v1, 0, "C_S_BFu16s.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_S_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu16s, C_S_BFu16s)
//============================================================================


struct  C_S_BFu17i  {
  char v1;
  short v2;
  unsigned int v3:17;
};
//SIG(1 C_S_BFu17i) C1{ Fc Fs Fi:17}



static void Test_C_S_BFu17i()
{
  {
    init_simple_test("C_S_BFu17i");
    static STRUCT_IF_C C_S_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu17i)");
    check_field_offset(lv, v1, 0, "C_S_BFu17i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_S_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu17i, C_S_BFu17i)
//============================================================================


struct  C_S_BFu17ll  {
  char v1;
  short v2;
  __tsu64 v3:17;
};
//SIG(1 C_S_BFu17ll) C1{ Fc Fs FL:17}



static void Test_C_S_BFu17ll()
{
  {
    init_simple_test("C_S_BFu17ll");
    static STRUCT_IF_C C_S_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_S_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu17ll, C_S_BFu17ll)
//============================================================================


struct  C_S_BFu1c  {
  char v1;
  short v2;
  unsigned char v3:1;
};
//SIG(1 C_S_BFu1c) C1{ Fc Fs Fc:1}



static void Test_C_S_BFu1c()
{
  {
    init_simple_test("C_S_BFu1c");
    static STRUCT_IF_C C_S_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu1c)");
    check_field_offset(lv, v1, 0, "C_S_BFu1c.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "C_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu1c, C_S_BFu1c)
//============================================================================


struct  C_S_BFu1i  {
  char v1;
  short v2;
  unsigned int v3:1;
};
//SIG(1 C_S_BFu1i) C1{ Fc Fs Fi:1}



static void Test_C_S_BFu1i()
{
  {
    init_simple_test("C_S_BFu1i");
    static STRUCT_IF_C C_S_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu1i)");
    check_field_offset(lv, v1, 0, "C_S_BFu1i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "C_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu1i, C_S_BFu1i)
//============================================================================


struct  C_S_BFu1ll  {
  char v1;
  short v2;
  __tsu64 v3:1;
};
//SIG(1 C_S_BFu1ll) C1{ Fc Fs FL:1}



static void Test_C_S_BFu1ll()
{
  {
    init_simple_test("C_S_BFu1ll");
    static STRUCT_IF_C C_S_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "C_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu1ll, C_S_BFu1ll)
//============================================================================


struct  C_S_BFu1s  {
  char v1;
  short v2;
  unsigned short v3:1;
};
//SIG(1 C_S_BFu1s) C1{ Fc Fs Fs:1}



static void Test_C_S_BFu1s()
{
  {
    init_simple_test("C_S_BFu1s");
    static STRUCT_IF_C C_S_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu1s)");
    check_field_offset(lv, v1, 0, "C_S_BFu1s.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "C_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu1s, C_S_BFu1s)
//============================================================================


struct  C_S_BFu31i  {
  char v1;
  short v2;
  unsigned int v3:31;
};
//SIG(1 C_S_BFu31i) C1{ Fc Fs Fi:31}



static void Test_C_S_BFu31i()
{
  {
    init_simple_test("C_S_BFu31i");
    static STRUCT_IF_C C_S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu31i)");
    check_field_offset(lv, v1, 0, "C_S_BFu31i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_S_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu31i, C_S_BFu31i)
//============================================================================


struct  C_S_BFu31ll  {
  char v1;
  short v2;
  __tsu64 v3:31;
};
//SIG(1 C_S_BFu31ll) C1{ Fc Fs FL:31}



static void Test_C_S_BFu31ll()
{
  {
    init_simple_test("C_S_BFu31ll");
    static STRUCT_IF_C C_S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_S_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu31ll, C_S_BFu31ll)
//============================================================================


struct  C_S_BFu32i  {
  char v1;
  short v2;
  unsigned int v3:32;
};
//SIG(1 C_S_BFu32i) C1{ Fc Fs Fi:32}



static void Test_C_S_BFu32i()
{
  {
    init_simple_test("C_S_BFu32i");
    static STRUCT_IF_C C_S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu32i)");
    check_field_offset(lv, v1, 0, "C_S_BFu32i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_S_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu32i, C_S_BFu32i)
//============================================================================


struct  C_S_BFu32ll  {
  char v1;
  short v2;
  __tsu64 v3:32;
};
//SIG(1 C_S_BFu32ll) C1{ Fc Fs FL:32}



static void Test_C_S_BFu32ll()
{
  {
    init_simple_test("C_S_BFu32ll");
    static STRUCT_IF_C C_S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_S_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu32ll, C_S_BFu32ll)
//============================================================================


struct  C_S_BFu33  {
  char v1;
  short v2;
  __tsu64 v3:33;
};
//SIG(1 C_S_BFu33) C1{ Fc Fs FL:33}



static void Test_C_S_BFu33()
{
  {
    init_simple_test("C_S_BFu33");
    static STRUCT_IF_C C_S_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_S_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu33)");
    check_field_offset(lv, v1, 0, "C_S_BFu33.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "C_S_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "C_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu33, C_S_BFu33)
//============================================================================


struct  C_S_BFu7c  {
  char v1;
  short v2;
  unsigned char v3:7;
};
//SIG(1 C_S_BFu7c) C1{ Fc Fs Fc:7}



static void Test_C_S_BFu7c()
{
  {
    init_simple_test("C_S_BFu7c");
    static STRUCT_IF_C C_S_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu7c)");
    check_field_offset(lv, v1, 0, "C_S_BFu7c.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "C_S_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "C_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu7c, C_S_BFu7c)
//============================================================================


struct  C_S_BFu7i  {
  char v1;
  short v2;
  unsigned int v3:7;
};
//SIG(1 C_S_BFu7i) C1{ Fc Fs Fi:7}



static void Test_C_S_BFu7i()
{
  {
    init_simple_test("C_S_BFu7i");
    static STRUCT_IF_C C_S_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu7i)");
    check_field_offset(lv, v1, 0, "C_S_BFu7i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "C_S_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "C_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu7i, C_S_BFu7i)
//============================================================================


struct  C_S_BFu7ll  {
  char v1;
  short v2;
  __tsu64 v3:7;
};
//SIG(1 C_S_BFu7ll) C1{ Fc Fs FL:7}



static void Test_C_S_BFu7ll()
{
  {
    init_simple_test("C_S_BFu7ll");
    static STRUCT_IF_C C_S_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "C_S_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "C_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu7ll, C_S_BFu7ll)
//============================================================================


struct  C_S_BFu7s  {
  char v1;
  short v2;
  unsigned short v3:7;
};
//SIG(1 C_S_BFu7s) C1{ Fc Fs Fs:7}



static void Test_C_S_BFu7s()
{
  {
    init_simple_test("C_S_BFu7s");
    static STRUCT_IF_C C_S_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu7s)");
    check_field_offset(lv, v1, 0, "C_S_BFu7s.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "C_S_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "C_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu7s, C_S_BFu7s)
//============================================================================


struct  C_S_BFu8c  {
  char v1;
  short v2;
  unsigned char v3:8;
};
//SIG(1 C_S_BFu8c) C1{ Fc Fs Fc:8}



static void Test_C_S_BFu8c()
{
  {
    init_simple_test("C_S_BFu8c");
    static STRUCT_IF_C C_S_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu8c)");
    check_field_offset(lv, v1, 0, "C_S_BFu8c.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_S_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu8c, C_S_BFu8c)
//============================================================================


struct  C_S_BFu8i  {
  char v1;
  short v2;
  unsigned int v3:8;
};
//SIG(1 C_S_BFu8i) C1{ Fc Fs Fi:8}



static void Test_C_S_BFu8i()
{
  {
    init_simple_test("C_S_BFu8i");
    static STRUCT_IF_C C_S_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu8i)");
    check_field_offset(lv, v1, 0, "C_S_BFu8i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_S_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu8i, C_S_BFu8i)
//============================================================================


struct  C_S_BFu8ll  {
  char v1;
  short v2;
  __tsu64 v3:8;
};
//SIG(1 C_S_BFu8ll) C1{ Fc Fs FL:8}



static void Test_C_S_BFu8ll()
{
  {
    init_simple_test("C_S_BFu8ll");
    static STRUCT_IF_C C_S_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_S_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu8ll, C_S_BFu8ll)
//============================================================================


struct  C_S_BFu8s  {
  char v1;
  short v2;
  unsigned short v3:8;
};
//SIG(1 C_S_BFu8s) C1{ Fc Fs Fs:8}



static void Test_C_S_BFu8s()
{
  {
    init_simple_test("C_S_BFu8s");
    static STRUCT_IF_C C_S_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu8s)");
    check_field_offset(lv, v1, 0, "C_S_BFu8s.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_S_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu8s, C_S_BFu8s)
//============================================================================


struct  C_S_BFu9i  {
  char v1;
  short v2;
  unsigned int v3:9;
};
//SIG(1 C_S_BFu9i) C1{ Fc Fs Fi:9}



static void Test_C_S_BFu9i()
{
  {
    init_simple_test("C_S_BFu9i");
    static STRUCT_IF_C C_S_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_BFu9i)");
    check_field_offset(lv, v1, 0, "C_S_BFu9i.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "C_S_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "C_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu9i, C_S_BFu9i)
//============================================================================


struct  C_S_BFu9ll  {
  char v1;
  short v2;
  __tsu64 v3:9;
};
//SIG(1 C_S_BFu9ll) C1{ Fc Fs FL:9}



static void Test_C_S_BFu9ll()
{
  {
    init_simple_test("C_S_BFu9ll");
    static STRUCT_IF_C C_S_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(C_S_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_S_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "C_S_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "C_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu9ll, C_S_BFu9ll)
//============================================================================


struct  C_S_BFu9s  {
  char v1;
  short v2;
  unsigned short v3:9;
};
//SIG(1 C_S_BFu9s) C1{ Fc Fs Fs:9}



static void Test_C_S_BFu9s()
{
  {
    init_simple_test("C_S_BFu9s");
    static STRUCT_IF_C C_S_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(C_S_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_BFu9s)");
    check_field_offset(lv, v1, 0, "C_S_BFu9s.v1");
    check_field_offset(lv, v2, 2, "C_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "C_S_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "C_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_BFu9s, C_S_BFu9s)
//============================================================================


struct  C_S_C  {
  char v1;
  short v2;
  char v3;
};
//SIG(1 C_S_C) C1{ Fc Fs Fc}



static void Test_C_S_C()
{
  {
    init_simple_test("C_S_C");
    STRUCT_IF_C C_S_C lv;
    check2(sizeof(lv), 6, "sizeof(C_S_C)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_C)");
    check_field_offset(lv, v1, 0, "C_S_C.v1");
    check_field_offset(lv, v2, 2, "C_S_C.v2");
    check_field_offset(lv, v3, 4, "C_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_C, C_S_C)
//============================================================================


struct  C_S_D  {
  char v1;
  short v2;
  double v3;
};
//SIG(1 C_S_D) C1{ Fc Fs FL}



static void Test_C_S_D()
{
  {
    init_simple_test("C_S_D");
    STRUCT_IF_C C_S_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_S_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_D)");
    check_field_offset(lv, v1, 0, "C_S_D.v1");
    check_field_offset(lv, v2, 2, "C_S_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_D, C_S_D)
//============================================================================


struct  C_S_F  {
  char v1;
  short v2;
  float v3;
};
//SIG(1 C_S_F) C1{ Fc Fs Fi}



static void Test_C_S_F()
{
  {
    init_simple_test("C_S_F");
    STRUCT_IF_C C_S_F lv;
    check2(sizeof(lv), 8, "sizeof(C_S_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_F)");
    check_field_offset(lv, v1, 0, "C_S_F.v1");
    check_field_offset(lv, v2, 2, "C_S_F.v2");
    check_field_offset(lv, v3, 4, "C_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_F, C_S_F)
//============================================================================


struct  C_S_I  {
  char v1;
  short v2;
  int v3;
};
//SIG(1 C_S_I) C1{ Fc Fs Fi}



static void Test_C_S_I()
{
  {
    init_simple_test("C_S_I");
    STRUCT_IF_C C_S_I lv;
    check2(sizeof(lv), 8, "sizeof(C_S_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_I)");
    check_field_offset(lv, v1, 0, "C_S_I.v1");
    check_field_offset(lv, v2, 2, "C_S_I.v2");
    check_field_offset(lv, v3, 4, "C_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_I, C_S_I)
//============================================================================


struct  C_S_Ip  {
  char v1;
  short v2;
  int *v3;
};
//SIG(1 C_S_Ip) C1{ Fc Fs Fp}



static void Test_C_S_Ip()
{
  {
    init_simple_test("C_S_Ip");
    STRUCT_IF_C C_S_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_S_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_Ip)");
    check_field_offset(lv, v1, 0, "C_S_Ip.v1");
    check_field_offset(lv, v2, 2, "C_S_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_Ip, C_S_Ip)
//============================================================================


struct  C_S_L  {
  char v1;
  short v2;
  __tsi64 v3;
};
//SIG(1 C_S_L) C1{ Fc Fs FL}



static void Test_C_S_L()
{
  {
    init_simple_test("C_S_L");
    STRUCT_IF_C C_S_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_S_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_L)");
    check_field_offset(lv, v1, 0, "C_S_L.v1");
    check_field_offset(lv, v2, 2, "C_S_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_L, C_S_L)
//============================================================================


struct  C_S_S  {
  char v1;
  short v2;
  short v3;
};
//SIG(1 C_S_S) C1{ Fc Fs[2]}



static void Test_C_S_S()
{
  {
    init_simple_test("C_S_S");
    STRUCT_IF_C C_S_S lv;
    check2(sizeof(lv), 6, "sizeof(C_S_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_S)");
    check_field_offset(lv, v1, 0, "C_S_S.v1");
    check_field_offset(lv, v2, 2, "C_S_S.v2");
    check_field_offset(lv, v3, 4, "C_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_S, C_S_S)
//============================================================================


struct  C_S_Uc  {
  char v1;
  short v2;
  unsigned char v3;
};
//SIG(1 C_S_Uc) C1{ Fc Fs Fc}



static void Test_C_S_Uc()
{
  {
    init_simple_test("C_S_Uc");
    STRUCT_IF_C C_S_Uc lv;
    check2(sizeof(lv), 6, "sizeof(C_S_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_Uc)");
    check_field_offset(lv, v1, 0, "C_S_Uc.v1");
    check_field_offset(lv, v2, 2, "C_S_Uc.v2");
    check_field_offset(lv, v3, 4, "C_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_Uc, C_S_Uc)
//============================================================================


struct  C_S_Ui  {
  char v1;
  short v2;
  unsigned int v3;
};
//SIG(1 C_S_Ui) C1{ Fc Fs Fi}



static void Test_C_S_Ui()
{
  {
    init_simple_test("C_S_Ui");
    STRUCT_IF_C C_S_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_S_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_S_Ui)");
    check_field_offset(lv, v1, 0, "C_S_Ui.v1");
    check_field_offset(lv, v2, 2, "C_S_Ui.v2");
    check_field_offset(lv, v3, 4, "C_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_Ui, C_S_Ui)
//============================================================================


struct  C_S_Ul  {
  char v1;
  short v2;
  __tsu64 v3;
};
//SIG(1 C_S_Ul) C1{ Fc Fs FL}



static void Test_C_S_Ul()
{
  {
    init_simple_test("C_S_Ul");
    STRUCT_IF_C C_S_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_S_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_Ul)");
    check_field_offset(lv, v1, 0, "C_S_Ul.v1");
    check_field_offset(lv, v2, 2, "C_S_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_Ul, C_S_Ul)
//============================================================================


struct  C_S_Us  {
  char v1;
  short v2;
  unsigned short v3;
};
//SIG(1 C_S_Us) C1{ Fc Fs[2]}



static void Test_C_S_Us()
{
  {
    init_simple_test("C_S_Us");
    STRUCT_IF_C C_S_Us lv;
    check2(sizeof(lv), 6, "sizeof(C_S_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_Us)");
    check_field_offset(lv, v1, 0, "C_S_Us.v1");
    check_field_offset(lv, v2, 2, "C_S_Us.v2");
    check_field_offset(lv, v3, 4, "C_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_Us, C_S_Us)
//============================================================================


struct  C_S_Vp  {
  char v1;
  short v2;
  void *v3;
};
//SIG(1 C_S_Vp) C1{ Fc Fs Fp}



static void Test_C_S_Vp()
{
  {
    init_simple_test("C_S_Vp");
    STRUCT_IF_C C_S_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_S_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_S_Vp)");
    check_field_offset(lv, v1, 0, "C_S_Vp.v1");
    check_field_offset(lv, v2, 2, "C_S_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_S_Vp, C_S_Vp)
//============================================================================


struct  C_Uc  {
  char v1;
  unsigned char v2;
};
//SIG(1 C_Uc) C1{ Fc[2]}



static void Test_C_Uc()
{
  {
    init_simple_test("C_Uc");
    STRUCT_IF_C C_Uc lv;
    check2(sizeof(lv), 2, "sizeof(C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_Uc)");
    check_field_offset(lv, v1, 0, "C_Uc.v1");
    check_field_offset(lv, v2, 1, "C_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc, C_Uc)
//============================================================================


struct  C_Uc_BFu15i  {
  char v1;
  unsigned char v2;
  unsigned int v3:15;
};
//SIG(1 C_Uc_BFu15i) C1{ Fc[2] Fi:15}



static void Test_C_Uc_BFu15i()
{
  {
    init_simple_test("C_Uc_BFu15i");
    static STRUCT_IF_C C_Uc_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_Uc_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu15i, C_Uc_BFu15i)
//============================================================================


struct  C_Uc_BFu15ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:15;
};
//SIG(1 C_Uc_BFu15ll) C1{ Fc[2] FL:15}



static void Test_C_Uc_BFu15ll()
{
  {
    init_simple_test("C_Uc_BFu15ll");
    static STRUCT_IF_C C_Uc_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_Uc_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu15ll, C_Uc_BFu15ll)
//============================================================================


struct  C_Uc_BFu15s  {
  char v1;
  unsigned char v2;
  unsigned short v3:15;
};
//SIG(1 C_Uc_BFu15s) C1{ Fc[2] Fs:15}



static void Test_C_Uc_BFu15s()
{
  {
    init_simple_test("C_Uc_BFu15s");
    static STRUCT_IF_C C_Uc_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_Uc_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu15s, C_Uc_BFu15s)
//============================================================================


struct  C_Uc_BFu16i  {
  char v1;
  unsigned char v2;
  unsigned int v3:16;
};
//SIG(1 C_Uc_BFu16i) C1{ Fc[2] Fi:16}



static void Test_C_Uc_BFu16i()
{
  {
    init_simple_test("C_Uc_BFu16i");
    static STRUCT_IF_C C_Uc_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_Uc_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu16i, C_Uc_BFu16i)
//============================================================================


struct  C_Uc_BFu16ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:16;
};
//SIG(1 C_Uc_BFu16ll) C1{ Fc[2] FL:16}



static void Test_C_Uc_BFu16ll()
{
  {
    init_simple_test("C_Uc_BFu16ll");
    static STRUCT_IF_C C_Uc_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_Uc_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu16ll, C_Uc_BFu16ll)
//============================================================================


struct  C_Uc_BFu16s  {
  char v1;
  unsigned char v2;
  unsigned short v3:16;
};
//SIG(1 C_Uc_BFu16s) C1{ Fc[2] Fs:16}



static void Test_C_Uc_BFu16s()
{
  {
    init_simple_test("C_Uc_BFu16s");
    static STRUCT_IF_C C_Uc_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_Uc_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu16s, C_Uc_BFu16s)
//============================================================================


struct  C_Uc_BFu17i  {
  char v1;
  unsigned char v2;
  unsigned int v3:17;
};
//SIG(1 C_Uc_BFu17i) C1{ Fc[2] Fi:17}



static void Test_C_Uc_BFu17i()
{
  {
    init_simple_test("C_Uc_BFu17i");
    static STRUCT_IF_C C_Uc_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_Uc_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu17i, C_Uc_BFu17i)
//============================================================================


struct  C_Uc_BFu17ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:17;
};
//SIG(1 C_Uc_BFu17ll) C1{ Fc[2] FL:17}



static void Test_C_Uc_BFu17ll()
{
  {
    init_simple_test("C_Uc_BFu17ll");
    static STRUCT_IF_C C_Uc_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "C_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "C_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu17ll, C_Uc_BFu17ll)
//============================================================================


struct  C_Uc_BFu1c  {
  char v1;
  unsigned char v2;
  unsigned char v3:1;
};
//SIG(1 C_Uc_BFu1c) C1{ Fc[2] Fc:1}



static void Test_C_Uc_BFu1c()
{
  {
    init_simple_test("C_Uc_BFu1c");
    static STRUCT_IF_C C_Uc_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(C_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu1c, C_Uc_BFu1c)
//============================================================================


struct  C_Uc_BFu1i  {
  char v1;
  unsigned char v2;
  unsigned int v3:1;
};
//SIG(1 C_Uc_BFu1i) C1{ Fc[2] Fi:1}



static void Test_C_Uc_BFu1i()
{
  {
    init_simple_test("C_Uc_BFu1i");
    static STRUCT_IF_C C_Uc_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu1i, C_Uc_BFu1i)
//============================================================================


struct  C_Uc_BFu1ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:1;
};
//SIG(1 C_Uc_BFu1ll) C1{ Fc[2] FL:1}



static void Test_C_Uc_BFu1ll()
{
  {
    init_simple_test("C_Uc_BFu1ll");
    static STRUCT_IF_C C_Uc_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_Uc_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu1ll, C_Uc_BFu1ll)
//============================================================================


struct  C_Uc_BFu1s  {
  char v1;
  unsigned char v2;
  unsigned short v3:1;
};
//SIG(1 C_Uc_BFu1s) C1{ Fc[2] Fs:1}



static void Test_C_Uc_BFu1s()
{
  {
    init_simple_test("C_Uc_BFu1s");
    static STRUCT_IF_C C_Uc_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu1s, C_Uc_BFu1s)
//============================================================================


struct  C_Uc_BFu31i  {
  char v1;
  unsigned char v2;
  unsigned int v3:31;
};
//SIG(1 C_Uc_BFu31i) C1{ Fc[2] Fi:31}



static void Test_C_Uc_BFu31i()
{
  {
    init_simple_test("C_Uc_BFu31i");
    static STRUCT_IF_C C_Uc_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_Uc_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu31i, C_Uc_BFu31i)
//============================================================================


struct  C_Uc_BFu31ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:31;
};
//SIG(1 C_Uc_BFu31ll) C1{ Fc[2] FL:31}



static void Test_C_Uc_BFu31ll()
{
  {
    init_simple_test("C_Uc_BFu31ll");
    static STRUCT_IF_C C_Uc_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "C_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "C_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu31ll, C_Uc_BFu31ll)
//============================================================================


struct  C_Uc_BFu32i  {
  char v1;
  unsigned char v2;
  unsigned int v3:32;
};
//SIG(1 C_Uc_BFu32i) C1{ Fc[2] Fi:32}



static void Test_C_Uc_BFu32i()
{
  {
    init_simple_test("C_Uc_BFu32i");
    static STRUCT_IF_C C_Uc_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_Uc_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu32i, C_Uc_BFu32i)
//============================================================================


struct  C_Uc_BFu32ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:32;
};
//SIG(1 C_Uc_BFu32ll) C1{ Fc[2] FL:32}



static void Test_C_Uc_BFu32ll()
{
  {
    init_simple_test("C_Uc_BFu32ll");
    static STRUCT_IF_C C_Uc_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "C_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "C_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu32ll, C_Uc_BFu32ll)
//============================================================================


struct  C_Uc_BFu33  {
  char v1;
  unsigned char v2;
  __tsu64 v3:33;
};
//SIG(1 C_Uc_BFu33) C1{ Fc[2] FL:33}



static void Test_C_Uc_BFu33()
{
  {
    init_simple_test("C_Uc_BFu33");
    static STRUCT_IF_C C_Uc_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu33.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "C_Uc_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "C_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu33, C_Uc_BFu33)
//============================================================================


struct  C_Uc_BFu7c  {
  char v1;
  unsigned char v2;
  unsigned char v3:7;
};
//SIG(1 C_Uc_BFu7c) C1{ Fc[2] Fc:7}



static void Test_C_Uc_BFu7c()
{
  {
    init_simple_test("C_Uc_BFu7c");
    static STRUCT_IF_C C_Uc_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_Uc_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu7c, C_Uc_BFu7c)
//============================================================================


struct  C_Uc_BFu7i  {
  char v1;
  unsigned char v2;
  unsigned int v3:7;
};
//SIG(1 C_Uc_BFu7i) C1{ Fc[2] Fi:7}



static void Test_C_Uc_BFu7i()
{
  {
    init_simple_test("C_Uc_BFu7i");
    static STRUCT_IF_C C_Uc_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_Uc_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu7i, C_Uc_BFu7i)
//============================================================================


struct  C_Uc_BFu7ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:7;
};
//SIG(1 C_Uc_BFu7ll) C1{ Fc[2] FL:7}



static void Test_C_Uc_BFu7ll()
{
  {
    init_simple_test("C_Uc_BFu7ll");
    static STRUCT_IF_C C_Uc_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_Uc_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu7ll, C_Uc_BFu7ll)
//============================================================================


struct  C_Uc_BFu7s  {
  char v1;
  unsigned char v2;
  unsigned short v3:7;
};
//SIG(1 C_Uc_BFu7s) C1{ Fc[2] Fs:7}



static void Test_C_Uc_BFu7s()
{
  {
    init_simple_test("C_Uc_BFu7s");
    static STRUCT_IF_C C_Uc_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_Uc_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu7s, C_Uc_BFu7s)
//============================================================================


struct  C_Uc_BFu8c  {
  char v1;
  unsigned char v2;
  unsigned char v3:8;
};
//SIG(1 C_Uc_BFu8c) C1{ Fc[2] Fc:8}



static void Test_C_Uc_BFu8c()
{
  {
    init_simple_test("C_Uc_BFu8c");
    static STRUCT_IF_C C_Uc_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_Uc_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu8c, C_Uc_BFu8c)
//============================================================================


struct  C_Uc_BFu8i  {
  char v1;
  unsigned char v2;
  unsigned int v3:8;
};
//SIG(1 C_Uc_BFu8i) C1{ Fc[2] Fi:8}



static void Test_C_Uc_BFu8i()
{
  {
    init_simple_test("C_Uc_BFu8i");
    static STRUCT_IF_C C_Uc_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_Uc_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu8i, C_Uc_BFu8i)
//============================================================================


struct  C_Uc_BFu8ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:8;
};
//SIG(1 C_Uc_BFu8ll) C1{ Fc[2] FL:8}



static void Test_C_Uc_BFu8ll()
{
  {
    init_simple_test("C_Uc_BFu8ll");
    static STRUCT_IF_C C_Uc_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_Uc_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu8ll, C_Uc_BFu8ll)
//============================================================================


struct  C_Uc_BFu8s  {
  char v1;
  unsigned char v2;
  unsigned short v3:8;
};
//SIG(1 C_Uc_BFu8s) C1{ Fc[2] Fs:8}



static void Test_C_Uc_BFu8s()
{
  {
    init_simple_test("C_Uc_BFu8s");
    static STRUCT_IF_C C_Uc_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_Uc_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu8s, C_Uc_BFu8s)
//============================================================================


struct  C_Uc_BFu9i  {
  char v1;
  unsigned char v2;
  unsigned int v3:9;
};
//SIG(1 C_Uc_BFu9i) C1{ Fc[2] Fi:9}



static void Test_C_Uc_BFu9i()
{
  {
    init_simple_test("C_Uc_BFu9i");
    static STRUCT_IF_C C_Uc_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_Uc_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu9i, C_Uc_BFu9i)
//============================================================================


struct  C_Uc_BFu9ll  {
  char v1;
  unsigned char v2;
  __tsu64 v3:9;
};
//SIG(1 C_Uc_BFu9ll) C1{ Fc[2] FL:9}



static void Test_C_Uc_BFu9ll()
{
  {
    init_simple_test("C_Uc_BFu9ll");
    static STRUCT_IF_C C_Uc_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_Uc_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu9ll, C_Uc_BFu9ll)
//============================================================================


struct  C_Uc_BFu9s  {
  char v1;
  unsigned char v2;
  unsigned short v3:9;
};
//SIG(1 C_Uc_BFu9s) C1{ Fc[2] Fs:9}



static void Test_C_Uc_BFu9s()
{
  {
    init_simple_test("C_Uc_BFu9s");
    static STRUCT_IF_C C_Uc_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "C_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 1, "C_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_Uc_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_BFu9s, C_Uc_BFu9s)
//============================================================================


struct  C_Uc_C  {
  char v1;
  unsigned char v2;
  char v3;
};
//SIG(1 C_Uc_C) C1{ Fc[3]}



static void Test_C_Uc_C()
{
  {
    init_simple_test("C_Uc_C");
    STRUCT_IF_C C_Uc_C lv;
    check2(sizeof(lv), 3, "sizeof(C_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_Uc_C)");
    check_field_offset(lv, v1, 0, "C_Uc_C.v1");
    check_field_offset(lv, v2, 1, "C_Uc_C.v2");
    check_field_offset(lv, v3, 2, "C_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_C, C_Uc_C)
//============================================================================


struct  C_Uc_D  {
  char v1;
  unsigned char v2;
  double v3;
};
//SIG(1 C_Uc_D) C1{ Fc[2] FL}



static void Test_C_Uc_D()
{
  {
    init_simple_test("C_Uc_D");
    STRUCT_IF_C C_Uc_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Uc_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_D)");
    check_field_offset(lv, v1, 0, "C_Uc_D.v1");
    check_field_offset(lv, v2, 1, "C_Uc_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_D, C_Uc_D)
//============================================================================


struct  C_Uc_F  {
  char v1;
  unsigned char v2;
  float v3;
};
//SIG(1 C_Uc_F) C1{ Fc[2] Fi}



static void Test_C_Uc_F()
{
  {
    init_simple_test("C_Uc_F");
    STRUCT_IF_C C_Uc_F lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_F)");
    check_field_offset(lv, v1, 0, "C_Uc_F.v1");
    check_field_offset(lv, v2, 1, "C_Uc_F.v2");
    check_field_offset(lv, v3, 4, "C_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_F, C_Uc_F)
//============================================================================


struct  C_Uc_I  {
  char v1;
  unsigned char v2;
  int v3;
};
//SIG(1 C_Uc_I) C1{ Fc[2] Fi}



static void Test_C_Uc_I()
{
  {
    init_simple_test("C_Uc_I");
    STRUCT_IF_C C_Uc_I lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_I)");
    check_field_offset(lv, v1, 0, "C_Uc_I.v1");
    check_field_offset(lv, v2, 1, "C_Uc_I.v2");
    check_field_offset(lv, v3, 4, "C_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_I, C_Uc_I)
//============================================================================


struct  C_Uc_Ip  {
  char v1;
  unsigned char v2;
  int *v3;
};
//SIG(1 C_Uc_Ip) C1{ Fc[2] Fp}



static void Test_C_Uc_Ip()
{
  {
    init_simple_test("C_Uc_Ip");
    STRUCT_IF_C C_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_Uc_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_Ip)");
    check_field_offset(lv, v1, 0, "C_Uc_Ip.v1");
    check_field_offset(lv, v2, 1, "C_Uc_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_Ip, C_Uc_Ip)
//============================================================================


struct  C_Uc_L  {
  char v1;
  unsigned char v2;
  __tsi64 v3;
};
//SIG(1 C_Uc_L) C1{ Fc[2] FL}



static void Test_C_Uc_L()
{
  {
    init_simple_test("C_Uc_L");
    STRUCT_IF_C C_Uc_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Uc_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_L)");
    check_field_offset(lv, v1, 0, "C_Uc_L.v1");
    check_field_offset(lv, v2, 1, "C_Uc_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_L, C_Uc_L)
//============================================================================


struct  C_Uc_S  {
  char v1;
  unsigned char v2;
  short v3;
};
//SIG(1 C_Uc_S) C1{ Fc[2] Fs}



static void Test_C_Uc_S()
{
  {
    init_simple_test("C_Uc_S");
    STRUCT_IF_C C_Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_Uc_S)");
    check_field_offset(lv, v1, 0, "C_Uc_S.v1");
    check_field_offset(lv, v2, 1, "C_Uc_S.v2");
    check_field_offset(lv, v3, 2, "C_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_S, C_Uc_S)
//============================================================================


struct  C_Uc_Uc  {
  char v1;
  unsigned char v2;
  unsigned char v3;
};
//SIG(1 C_Uc_Uc) C1{ Fc[3]}



static void Test_C_Uc_Uc()
{
  {
    init_simple_test("C_Uc_Uc");
    STRUCT_IF_C C_Uc_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_Uc_Uc)");
    check_field_offset(lv, v1, 0, "C_Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "C_Uc_Uc.v2");
    check_field_offset(lv, v3, 2, "C_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_Uc, C_Uc_Uc)
//============================================================================


struct  C_Uc_Ui  {
  char v1;
  unsigned char v2;
  unsigned int v3;
};
//SIG(1 C_Uc_Ui) C1{ Fc[2] Fi}



static void Test_C_Uc_Ui()
{
  {
    init_simple_test("C_Uc_Ui");
    STRUCT_IF_C C_Uc_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_Uc_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_Uc_Ui)");
    check_field_offset(lv, v1, 0, "C_Uc_Ui.v1");
    check_field_offset(lv, v2, 1, "C_Uc_Ui.v2");
    check_field_offset(lv, v3, 4, "C_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_Ui, C_Uc_Ui)
//============================================================================


struct  C_Uc_Ul  {
  char v1;
  unsigned char v2;
  __tsu64 v3;
};
//SIG(1 C_Uc_Ul) C1{ Fc[2] FL}



static void Test_C_Uc_Ul()
{
  {
    init_simple_test("C_Uc_Ul");
    STRUCT_IF_C C_Uc_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Uc_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_Ul)");
    check_field_offset(lv, v1, 0, "C_Uc_Ul.v1");
    check_field_offset(lv, v2, 1, "C_Uc_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_Ul, C_Uc_Ul)
//============================================================================


struct  C_Uc_Us  {
  char v1;
  unsigned char v2;
  unsigned short v3;
};
//SIG(1 C_Uc_Us) C1{ Fc[2] Fs}



static void Test_C_Uc_Us()
{
  {
    init_simple_test("C_Uc_Us");
    STRUCT_IF_C C_Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_Uc_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_Uc_Us)");
    check_field_offset(lv, v1, 0, "C_Uc_Us.v1");
    check_field_offset(lv, v2, 1, "C_Uc_Us.v2");
    check_field_offset(lv, v3, 2, "C_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_Us, C_Uc_Us)
//============================================================================


struct  C_Uc_Vp  {
  char v1;
  unsigned char v2;
  void *v3;
};
//SIG(1 C_Uc_Vp) C1{ Fc[2] Fp}



static void Test_C_Uc_Vp()
{
  {
    init_simple_test("C_Uc_Vp");
    STRUCT_IF_C C_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_Uc_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Uc_Vp)");
    check_field_offset(lv, v1, 0, "C_Uc_Vp.v1");
    check_field_offset(lv, v2, 1, "C_Uc_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Uc_Vp, C_Uc_Vp)
//============================================================================


struct  C_Ui  {
  char v1;
  unsigned int v2;
};
//SIG(1 C_Ui) C1{ Fc Fi}



static void Test_C_Ui()
{
  {
    init_simple_test("C_Ui");
    STRUCT_IF_C C_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui)");
    check_field_offset(lv, v1, 0, "C_Ui.v1");
    check_field_offset(lv, v2, 4, "C_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui, C_Ui)
//============================================================================


struct  C_Ui_BFu15i  {
  char v1;
  unsigned int v2;
  unsigned int v3:15;
};
//SIG(1 C_Ui_BFu15i) C1{ Fc Fi Fi:15}



static void Test_C_Ui_BFu15i()
{
  {
    init_simple_test("C_Ui_BFu15i");
    static STRUCT_IF_C C_Ui_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_Ui_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu15i, C_Ui_BFu15i)
//============================================================================


struct  C_Ui_BFu15ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:15;
};
//SIG(1 C_Ui_BFu15ll) C1{ Fc Fi FL:15}



static void Test_C_Ui_BFu15ll()
{
  {
    init_simple_test("C_Ui_BFu15ll");
    static STRUCT_IF_C C_Ui_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu15ll, C_Ui_BFu15ll)
//============================================================================


struct  C_Ui_BFu15s  {
  char v1;
  unsigned int v2;
  unsigned short v3:15;
};
//SIG(1 C_Ui_BFu15s) C1{ Fc Fi Fs:15}



static void Test_C_Ui_BFu15s()
{
  {
    init_simple_test("C_Ui_BFu15s");
    static STRUCT_IF_C C_Ui_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "C_Ui_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "C_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu15s, C_Ui_BFu15s)
//============================================================================


struct  C_Ui_BFu16i  {
  char v1;
  unsigned int v2;
  unsigned int v3:16;
};
//SIG(1 C_Ui_BFu16i) C1{ Fc Fi Fi:16}



static void Test_C_Ui_BFu16i()
{
  {
    init_simple_test("C_Ui_BFu16i");
    static STRUCT_IF_C C_Ui_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_Ui_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu16i, C_Ui_BFu16i)
//============================================================================


struct  C_Ui_BFu16ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:16;
};
//SIG(1 C_Ui_BFu16ll) C1{ Fc Fi FL:16}



static void Test_C_Ui_BFu16ll()
{
  {
    init_simple_test("C_Ui_BFu16ll");
    static STRUCT_IF_C C_Ui_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu16ll, C_Ui_BFu16ll)
//============================================================================


struct  C_Ui_BFu16s  {
  char v1;
  unsigned int v2;
  unsigned short v3:16;
};
//SIG(1 C_Ui_BFu16s) C1{ Fc Fi Fs:16}



static void Test_C_Ui_BFu16s()
{
  {
    init_simple_test("C_Ui_BFu16s");
    static STRUCT_IF_C C_Ui_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "C_Ui_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "C_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu16s, C_Ui_BFu16s)
//============================================================================


struct  C_Ui_BFu17i  {
  char v1;
  unsigned int v2;
  unsigned int v3:17;
};
//SIG(1 C_Ui_BFu17i) C1{ Fc Fi Fi:17}



static void Test_C_Ui_BFu17i()
{
  {
    init_simple_test("C_Ui_BFu17i");
    static STRUCT_IF_C C_Ui_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "C_Ui_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "C_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu17i, C_Ui_BFu17i)
//============================================================================


struct  C_Ui_BFu17ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:17;
};
//SIG(1 C_Ui_BFu17ll) C1{ Fc Fi FL:17}



static void Test_C_Ui_BFu17ll()
{
  {
    init_simple_test("C_Ui_BFu17ll");
    static STRUCT_IF_C C_Ui_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "C_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "C_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu17ll, C_Ui_BFu17ll)
//============================================================================


struct  C_Ui_BFu1c  {
  char v1;
  unsigned int v2;
  unsigned char v3:1;
};
//SIG(1 C_Ui_BFu1c) C1{ Fc Fi Fc:1}



static void Test_C_Ui_BFu1c()
{
  {
    init_simple_test("C_Ui_BFu1c");
    static STRUCT_IF_C C_Ui_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu1c, C_Ui_BFu1c)
//============================================================================


struct  C_Ui_BFu1i  {
  char v1;
  unsigned int v2;
  unsigned int v3:1;
};
//SIG(1 C_Ui_BFu1i) C1{ Fc Fi Fi:1}



static void Test_C_Ui_BFu1i()
{
  {
    init_simple_test("C_Ui_BFu1i");
    static STRUCT_IF_C C_Ui_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu1i, C_Ui_BFu1i)
//============================================================================


struct  C_Ui_BFu1ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:1;
};
//SIG(1 C_Ui_BFu1ll) C1{ Fc Fi FL:1}



static void Test_C_Ui_BFu1ll()
{
  {
    init_simple_test("C_Ui_BFu1ll");
    static STRUCT_IF_C C_Ui_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu1ll, C_Ui_BFu1ll)
//============================================================================


struct  C_Ui_BFu1s  {
  char v1;
  unsigned int v2;
  unsigned short v3:1;
};
//SIG(1 C_Ui_BFu1s) C1{ Fc Fi Fs:1}



static void Test_C_Ui_BFu1s()
{
  {
    init_simple_test("C_Ui_BFu1s");
    static STRUCT_IF_C C_Ui_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "C_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu1s, C_Ui_BFu1s)
//============================================================================


struct  C_Ui_BFu31i  {
  char v1;
  unsigned int v2;
  unsigned int v3:31;
};
//SIG(1 C_Ui_BFu31i) C1{ Fc Fi Fi:31}



static void Test_C_Ui_BFu31i()
{
  {
    init_simple_test("C_Ui_BFu31i");
    static STRUCT_IF_C C_Ui_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "C_Ui_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "C_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu31i, C_Ui_BFu31i)
//============================================================================


struct  C_Ui_BFu31ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:31;
};
//SIG(1 C_Ui_BFu31ll) C1{ Fc Fi FL:31}



static void Test_C_Ui_BFu31ll()
{
  {
    init_simple_test("C_Ui_BFu31ll");
    static STRUCT_IF_C C_Ui_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "C_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "C_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu31ll, C_Ui_BFu31ll)
//============================================================================


struct  C_Ui_BFu32i  {
  char v1;
  unsigned int v2;
  unsigned int v3:32;
};
//SIG(1 C_Ui_BFu32i) C1{ Fc Fi Fi:32}



static void Test_C_Ui_BFu32i()
{
  {
    init_simple_test("C_Ui_BFu32i");
    static STRUCT_IF_C C_Ui_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "C_Ui_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "C_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu32i, C_Ui_BFu32i)
//============================================================================


struct  C_Ui_BFu32ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:32;
};
//SIG(1 C_Ui_BFu32ll) C1{ Fc Fi FL:32}



static void Test_C_Ui_BFu32ll()
{
  {
    init_simple_test("C_Ui_BFu32ll");
    static STRUCT_IF_C C_Ui_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "C_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "C_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu32ll, C_Ui_BFu32ll)
//============================================================================


struct  C_Ui_BFu33  {
  char v1;
  unsigned int v2;
  __tsu64 v3:33;
};
//SIG(1 C_Ui_BFu33) C1{ Fc Fi FL:33}



static void Test_C_Ui_BFu33()
{
  {
    init_simple_test("C_Ui_BFu33");
    static STRUCT_IF_C C_Ui_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(C_Ui_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu33.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "C_Ui_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "C_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu33, C_Ui_BFu33)
//============================================================================


struct  C_Ui_BFu7c  {
  char v1;
  unsigned int v2;
  unsigned char v3:7;
};
//SIG(1 C_Ui_BFu7c) C1{ Fc Fi Fc:7}



static void Test_C_Ui_BFu7c()
{
  {
    init_simple_test("C_Ui_BFu7c");
    static STRUCT_IF_C C_Ui_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_Ui_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu7c, C_Ui_BFu7c)
//============================================================================


struct  C_Ui_BFu7i  {
  char v1;
  unsigned int v2;
  unsigned int v3:7;
};
//SIG(1 C_Ui_BFu7i) C1{ Fc Fi Fi:7}



static void Test_C_Ui_BFu7i()
{
  {
    init_simple_test("C_Ui_BFu7i");
    static STRUCT_IF_C C_Ui_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_Ui_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu7i, C_Ui_BFu7i)
//============================================================================


struct  C_Ui_BFu7ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:7;
};
//SIG(1 C_Ui_BFu7ll) C1{ Fc Fi FL:7}



static void Test_C_Ui_BFu7ll()
{
  {
    init_simple_test("C_Ui_BFu7ll");
    static STRUCT_IF_C C_Ui_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu7ll, C_Ui_BFu7ll)
//============================================================================


struct  C_Ui_BFu7s  {
  char v1;
  unsigned int v2;
  unsigned short v3:7;
};
//SIG(1 C_Ui_BFu7s) C1{ Fc Fi Fs:7}



static void Test_C_Ui_BFu7s()
{
  {
    init_simple_test("C_Ui_BFu7s");
    static STRUCT_IF_C C_Ui_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "C_Ui_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "C_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu7s, C_Ui_BFu7s)
//============================================================================


struct  C_Ui_BFu8c  {
  char v1;
  unsigned int v2;
  unsigned char v3:8;
};
//SIG(1 C_Ui_BFu8c) C1{ Fc Fi Fc:8}



static void Test_C_Ui_BFu8c()
{
  {
    init_simple_test("C_Ui_BFu8c");
    static STRUCT_IF_C C_Ui_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_Ui_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu8c, C_Ui_BFu8c)
//============================================================================


struct  C_Ui_BFu8i  {
  char v1;
  unsigned int v2;
  unsigned int v3:8;
};
//SIG(1 C_Ui_BFu8i) C1{ Fc Fi Fi:8}



static void Test_C_Ui_BFu8i()
{
  {
    init_simple_test("C_Ui_BFu8i");
    static STRUCT_IF_C C_Ui_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_Ui_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu8i, C_Ui_BFu8i)
//============================================================================


struct  C_Ui_BFu8ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:8;
};
//SIG(1 C_Ui_BFu8ll) C1{ Fc Fi FL:8}



static void Test_C_Ui_BFu8ll()
{
  {
    init_simple_test("C_Ui_BFu8ll");
    static STRUCT_IF_C C_Ui_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu8ll, C_Ui_BFu8ll)
//============================================================================


struct  C_Ui_BFu8s  {
  char v1;
  unsigned int v2;
  unsigned short v3:8;
};
//SIG(1 C_Ui_BFu8s) C1{ Fc Fi Fs:8}



static void Test_C_Ui_BFu8s()
{
  {
    init_simple_test("C_Ui_BFu8s");
    static STRUCT_IF_C C_Ui_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "C_Ui_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "C_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu8s, C_Ui_BFu8s)
//============================================================================


struct  C_Ui_BFu9i  {
  char v1;
  unsigned int v2;
  unsigned int v3:9;
};
//SIG(1 C_Ui_BFu9i) C1{ Fc Fi Fi:9}



static void Test_C_Ui_BFu9i()
{
  {
    init_simple_test("C_Ui_BFu9i");
    static STRUCT_IF_C C_Ui_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_Ui_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu9i, C_Ui_BFu9i)
//============================================================================


struct  C_Ui_BFu9ll  {
  char v1;
  unsigned int v2;
  __tsu64 v3:9;
};
//SIG(1 C_Ui_BFu9ll) C1{ Fc Fi FL:9}



static void Test_C_Ui_BFu9ll()
{
  {
    init_simple_test("C_Ui_BFu9ll");
    static STRUCT_IF_C C_Ui_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu9ll, C_Ui_BFu9ll)
//============================================================================


struct  C_Ui_BFu9s  {
  char v1;
  unsigned int v2;
  unsigned short v3:9;
};
//SIG(1 C_Ui_BFu9s) C1{ Fc Fi Fs:9}



static void Test_C_Ui_BFu9s()
{
  {
    init_simple_test("C_Ui_BFu9s");
    static STRUCT_IF_C C_Ui_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "C_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 4, "C_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "C_Ui_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "C_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_BFu9s, C_Ui_BFu9s)
//============================================================================


struct  C_Ui_C  {
  char v1;
  unsigned int v2;
  char v3;
};
//SIG(1 C_Ui_C) C1{ Fc Fi Fc}



static void Test_C_Ui_C()
{
  {
    init_simple_test("C_Ui_C");
    STRUCT_IF_C C_Ui_C lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_C)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_C)");
    check_field_offset(lv, v1, 0, "C_Ui_C.v1");
    check_field_offset(lv, v2, 4, "C_Ui_C.v2");
    check_field_offset(lv, v3, 8, "C_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_C, C_Ui_C)
//============================================================================


struct  C_Ui_D  {
  char v1;
  unsigned int v2;
  double v3;
};
//SIG(1 C_Ui_D) C1{ Fc Fi FL}



static void Test_C_Ui_D()
{
  {
    init_simple_test("C_Ui_D");
    STRUCT_IF_C C_Ui_D lv;
    check2(sizeof(lv), 16, "sizeof(C_Ui_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_D)");
    check_field_offset(lv, v1, 0, "C_Ui_D.v1");
    check_field_offset(lv, v2, 4, "C_Ui_D.v2");
    check_field_offset(lv, v3, 8, "C_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_D, C_Ui_D)
//============================================================================


struct  C_Ui_F  {
  char v1;
  unsigned int v2;
  float v3;
};
//SIG(1 C_Ui_F) C1{ Fc Fi[2]}



static void Test_C_Ui_F()
{
  {
    init_simple_test("C_Ui_F");
    STRUCT_IF_C C_Ui_F lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_F)");
    check_field_offset(lv, v1, 0, "C_Ui_F.v1");
    check_field_offset(lv, v2, 4, "C_Ui_F.v2");
    check_field_offset(lv, v3, 8, "C_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_F, C_Ui_F)
//============================================================================


struct  C_Ui_I  {
  char v1;
  unsigned int v2;
  int v3;
};
//SIG(1 C_Ui_I) C1{ Fc Fi[2]}



static void Test_C_Ui_I()
{
  {
    init_simple_test("C_Ui_I");
    STRUCT_IF_C C_Ui_I lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_I)");
    check_field_offset(lv, v1, 0, "C_Ui_I.v1");
    check_field_offset(lv, v2, 4, "C_Ui_I.v2");
    check_field_offset(lv, v3, 8, "C_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_I, C_Ui_I)
//============================================================================


struct  C_Ui_Ip  {
  char v1;
  unsigned int v2;
  int *v3;
};
//SIG(1 C_Ui_Ip) C1{ Fc Fi Fp}



static void Test_C_Ui_Ip()
{
  {
    init_simple_test("C_Ui_Ip");
    STRUCT_IF_C C_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_Ip)");
    check_field_offset(lv, v1, 0, "C_Ui_Ip.v1");
    check_field_offset(lv, v2, 4, "C_Ui_Ip.v2");
    check_field_offset(lv, v3, 8, "C_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_Ip, C_Ui_Ip)
//============================================================================


struct  C_Ui_L  {
  char v1;
  unsigned int v2;
  __tsi64 v3;
};
//SIG(1 C_Ui_L) C1{ Fc Fi FL}



static void Test_C_Ui_L()
{
  {
    init_simple_test("C_Ui_L");
    STRUCT_IF_C C_Ui_L lv;
    check2(sizeof(lv), 16, "sizeof(C_Ui_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_L)");
    check_field_offset(lv, v1, 0, "C_Ui_L.v1");
    check_field_offset(lv, v2, 4, "C_Ui_L.v2");
    check_field_offset(lv, v3, 8, "C_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_L, C_Ui_L)
//============================================================================


struct  C_Ui_S  {
  char v1;
  unsigned int v2;
  short v3;
};
//SIG(1 C_Ui_S) C1{ Fc Fi Fs}



static void Test_C_Ui_S()
{
  {
    init_simple_test("C_Ui_S");
    STRUCT_IF_C C_Ui_S lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_S)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_S)");
    check_field_offset(lv, v1, 0, "C_Ui_S.v1");
    check_field_offset(lv, v2, 4, "C_Ui_S.v2");
    check_field_offset(lv, v3, 8, "C_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_S, C_Ui_S)
//============================================================================


struct  C_Ui_Uc  {
  char v1;
  unsigned int v2;
  unsigned char v3;
};
//SIG(1 C_Ui_Uc) C1{ Fc Fi Fc}



static void Test_C_Ui_Uc()
{
  {
    init_simple_test("C_Ui_Uc");
    STRUCT_IF_C C_Ui_Uc lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_Uc)");
    check_field_offset(lv, v1, 0, "C_Ui_Uc.v1");
    check_field_offset(lv, v2, 4, "C_Ui_Uc.v2");
    check_field_offset(lv, v3, 8, "C_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_Uc, C_Ui_Uc)
//============================================================================


struct  C_Ui_Ui  {
  char v1;
  unsigned int v2;
  unsigned int v3;
};
//SIG(1 C_Ui_Ui) C1{ Fc Fi[2]}



static void Test_C_Ui_Ui()
{
  {
    init_simple_test("C_Ui_Ui");
    STRUCT_IF_C C_Ui_Ui lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_Ui)");
    check_field_offset(lv, v1, 0, "C_Ui_Ui.v1");
    check_field_offset(lv, v2, 4, "C_Ui_Ui.v2");
    check_field_offset(lv, v3, 8, "C_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_Ui, C_Ui_Ui)
//============================================================================


struct  C_Ui_Ul  {
  char v1;
  unsigned int v2;
  __tsu64 v3;
};
//SIG(1 C_Ui_Ul) C1{ Fc Fi FL}



static void Test_C_Ui_Ul()
{
  {
    init_simple_test("C_Ui_Ul");
    STRUCT_IF_C C_Ui_Ul lv;
    check2(sizeof(lv), 16, "sizeof(C_Ui_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_Ul)");
    check_field_offset(lv, v1, 0, "C_Ui_Ul.v1");
    check_field_offset(lv, v2, 4, "C_Ui_Ul.v2");
    check_field_offset(lv, v3, 8, "C_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_Ul, C_Ui_Ul)
//============================================================================


struct  C_Ui_Us  {
  char v1;
  unsigned int v2;
  unsigned short v3;
};
//SIG(1 C_Ui_Us) C1{ Fc Fi Fs}



static void Test_C_Ui_Us()
{
  {
    init_simple_test("C_Ui_Us");
    STRUCT_IF_C C_Ui_Us lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_Us)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_Us)");
    check_field_offset(lv, v1, 0, "C_Ui_Us.v1");
    check_field_offset(lv, v2, 4, "C_Ui_Us.v2");
    check_field_offset(lv, v3, 8, "C_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_Us, C_Ui_Us)
//============================================================================


struct  C_Ui_Vp  {
  char v1;
  unsigned int v2;
  void *v3;
};
//SIG(1 C_Ui_Vp) C1{ Fc Fi Fp}



static void Test_C_Ui_Vp()
{
  {
    init_simple_test("C_Ui_Vp");
    STRUCT_IF_C C_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ui_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ui_Vp)");
    check_field_offset(lv, v1, 0, "C_Ui_Vp.v1");
    check_field_offset(lv, v2, 4, "C_Ui_Vp.v2");
    check_field_offset(lv, v3, 8, "C_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ui_Vp, C_Ui_Vp)
//============================================================================


struct  C_Ul  {
  char v1;
  __tsu64 v2;
};
//SIG(1 C_Ul) C1{ Fc FL}



static void Test_C_Ul()
{
  {
    init_simple_test("C_Ul");
    STRUCT_IF_C C_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul)");
    check_field_offset(lv, v1, 0, "C_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul, C_Ul)
//============================================================================


struct  C_Ul_BFu15i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:15;
};
//SIG(1 C_Ul_BFu15i) C1{ Fc FL Fi:15}



static void Test_C_Ul_BFu15i()
{
  {
    init_simple_test("C_Ul_BFu15i");
    static STRUCT_IF_C C_Ul_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_Ul_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu15i, C_Ul_BFu15i)
//============================================================================


struct  C_Ul_BFu15ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:15;
};
//SIG(1 C_Ul_BFu15ll) C1{ Fc FL FL:15}



static void Test_C_Ul_BFu15ll()
{
  {
    init_simple_test("C_Ul_BFu15ll");
    static STRUCT_IF_C C_Ul_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_Ul_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu15ll, C_Ul_BFu15ll)
//============================================================================


struct  C_Ul_BFu15s  {
  char v1;
  __tsu64 v2;
  unsigned short v3:15;
};
//SIG(1 C_Ul_BFu15s) C1{ Fc FL Fs:15}



static void Test_C_Ul_BFu15s()
{
  {
    init_simple_test("C_Ul_BFu15s");
    static STRUCT_IF_C C_Ul_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "C_Ul_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "C_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu15s, C_Ul_BFu15s)
//============================================================================


struct  C_Ul_BFu16i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:16;
};
//SIG(1 C_Ul_BFu16i) C1{ Fc FL Fi:16}



static void Test_C_Ul_BFu16i()
{
  {
    init_simple_test("C_Ul_BFu16i");
    static STRUCT_IF_C C_Ul_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_Ul_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu16i, C_Ul_BFu16i)
//============================================================================


struct  C_Ul_BFu16ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:16;
};
//SIG(1 C_Ul_BFu16ll) C1{ Fc FL FL:16}



static void Test_C_Ul_BFu16ll()
{
  {
    init_simple_test("C_Ul_BFu16ll");
    static STRUCT_IF_C C_Ul_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_Ul_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu16ll, C_Ul_BFu16ll)
//============================================================================


struct  C_Ul_BFu16s  {
  char v1;
  __tsu64 v2;
  unsigned short v3:16;
};
//SIG(1 C_Ul_BFu16s) C1{ Fc FL Fs:16}



static void Test_C_Ul_BFu16s()
{
  {
    init_simple_test("C_Ul_BFu16s");
    static STRUCT_IF_C C_Ul_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "C_Ul_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "C_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu16s, C_Ul_BFu16s)
//============================================================================


struct  C_Ul_BFu17i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:17;
};
//SIG(1 C_Ul_BFu17i) C1{ Fc FL Fi:17}



static void Test_C_Ul_BFu17i()
{
  {
    init_simple_test("C_Ul_BFu17i");
    static STRUCT_IF_C C_Ul_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "C_Ul_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "C_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu17i, C_Ul_BFu17i)
//============================================================================


struct  C_Ul_BFu17ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:17;
};
//SIG(1 C_Ul_BFu17ll) C1{ Fc FL FL:17}



static void Test_C_Ul_BFu17ll()
{
  {
    init_simple_test("C_Ul_BFu17ll");
    static STRUCT_IF_C C_Ul_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "C_Ul_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "C_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu17ll, C_Ul_BFu17ll)
//============================================================================


struct  C_Ul_BFu1c  {
  char v1;
  __tsu64 v2;
  unsigned char v3:1;
};
//SIG(1 C_Ul_BFu1c) C1{ Fc FL Fc:1}



static void Test_C_Ul_BFu1c()
{
  {
    init_simple_test("C_Ul_BFu1c");
    static STRUCT_IF_C C_Ul_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu1c, C_Ul_BFu1c)
//============================================================================


struct  C_Ul_BFu1i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:1;
};
//SIG(1 C_Ul_BFu1i) C1{ Fc FL Fi:1}



static void Test_C_Ul_BFu1i()
{
  {
    init_simple_test("C_Ul_BFu1i");
    static STRUCT_IF_C C_Ul_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu1i, C_Ul_BFu1i)
//============================================================================


struct  C_Ul_BFu1ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:1;
};
//SIG(1 C_Ul_BFu1ll) C1{ Fc FL FL:1}



static void Test_C_Ul_BFu1ll()
{
  {
    init_simple_test("C_Ul_BFu1ll");
    static STRUCT_IF_C C_Ul_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu1ll, C_Ul_BFu1ll)
//============================================================================


struct  C_Ul_BFu1s  {
  char v1;
  __tsu64 v2;
  unsigned short v3:1;
};
//SIG(1 C_Ul_BFu1s) C1{ Fc FL Fs:1}



static void Test_C_Ul_BFu1s()
{
  {
    init_simple_test("C_Ul_BFu1s");
    static STRUCT_IF_C C_Ul_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "C_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu1s, C_Ul_BFu1s)
//============================================================================


struct  C_Ul_BFu31i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:31;
};
//SIG(1 C_Ul_BFu31i) C1{ Fc FL Fi:31}



static void Test_C_Ul_BFu31i()
{
  {
    init_simple_test("C_Ul_BFu31i");
    static STRUCT_IF_C C_Ul_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "C_Ul_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "C_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu31i, C_Ul_BFu31i)
//============================================================================


struct  C_Ul_BFu31ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:31;
};
//SIG(1 C_Ul_BFu31ll) C1{ Fc FL FL:31}



static void Test_C_Ul_BFu31ll()
{
  {
    init_simple_test("C_Ul_BFu31ll");
    static STRUCT_IF_C C_Ul_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "C_Ul_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "C_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu31ll, C_Ul_BFu31ll)
//============================================================================


struct  C_Ul_BFu32i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:32;
};
//SIG(1 C_Ul_BFu32i) C1{ Fc FL Fi:32}



static void Test_C_Ul_BFu32i()
{
  {
    init_simple_test("C_Ul_BFu32i");
    static STRUCT_IF_C C_Ul_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "C_Ul_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "C_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu32i, C_Ul_BFu32i)
//============================================================================


struct  C_Ul_BFu32ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:32;
};
//SIG(1 C_Ul_BFu32ll) C1{ Fc FL FL:32}



static void Test_C_Ul_BFu32ll()
{
  {
    init_simple_test("C_Ul_BFu32ll");
    static STRUCT_IF_C C_Ul_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "C_Ul_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "C_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu32ll, C_Ul_BFu32ll)
//============================================================================


struct  C_Ul_BFu33  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:33;
};
//SIG(1 C_Ul_BFu33) C1{ Fc FL FL:33}



static void Test_C_Ul_BFu33()
{
  {
    init_simple_test("C_Ul_BFu33");
    static STRUCT_IF_C C_Ul_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_Ul_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "C_Ul_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "C_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu33, C_Ul_BFu33)
//============================================================================


struct  C_Ul_BFu7c  {
  char v1;
  __tsu64 v2;
  unsigned char v3:7;
};
//SIG(1 C_Ul_BFu7c) C1{ Fc FL Fc:7}



static void Test_C_Ul_BFu7c()
{
  {
    init_simple_test("C_Ul_BFu7c");
    static STRUCT_IF_C C_Ul_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_Ul_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu7c, C_Ul_BFu7c)
//============================================================================


struct  C_Ul_BFu7i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:7;
};
//SIG(1 C_Ul_BFu7i) C1{ Fc FL Fi:7}



static void Test_C_Ul_BFu7i()
{
  {
    init_simple_test("C_Ul_BFu7i");
    static STRUCT_IF_C C_Ul_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_Ul_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu7i, C_Ul_BFu7i)
//============================================================================


struct  C_Ul_BFu7ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:7;
};
//SIG(1 C_Ul_BFu7ll) C1{ Fc FL FL:7}



static void Test_C_Ul_BFu7ll()
{
  {
    init_simple_test("C_Ul_BFu7ll");
    static STRUCT_IF_C C_Ul_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_Ul_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu7ll, C_Ul_BFu7ll)
//============================================================================


struct  C_Ul_BFu7s  {
  char v1;
  __tsu64 v2;
  unsigned short v3:7;
};
//SIG(1 C_Ul_BFu7s) C1{ Fc FL Fs:7}



static void Test_C_Ul_BFu7s()
{
  {
    init_simple_test("C_Ul_BFu7s");
    static STRUCT_IF_C C_Ul_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "C_Ul_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "C_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu7s, C_Ul_BFu7s)
//============================================================================


struct  C_Ul_BFu8c  {
  char v1;
  __tsu64 v2;
  unsigned char v3:8;
};
//SIG(1 C_Ul_BFu8c) C1{ Fc FL Fc:8}



static void Test_C_Ul_BFu8c()
{
  {
    init_simple_test("C_Ul_BFu8c");
    static STRUCT_IF_C C_Ul_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_Ul_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu8c, C_Ul_BFu8c)
//============================================================================


struct  C_Ul_BFu8i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:8;
};
//SIG(1 C_Ul_BFu8i) C1{ Fc FL Fi:8}



static void Test_C_Ul_BFu8i()
{
  {
    init_simple_test("C_Ul_BFu8i");
    static STRUCT_IF_C C_Ul_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_Ul_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu8i, C_Ul_BFu8i)
//============================================================================


struct  C_Ul_BFu8ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:8;
};
//SIG(1 C_Ul_BFu8ll) C1{ Fc FL FL:8}



static void Test_C_Ul_BFu8ll()
{
  {
    init_simple_test("C_Ul_BFu8ll");
    static STRUCT_IF_C C_Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_Ul_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu8ll, C_Ul_BFu8ll)
//============================================================================


struct  C_Ul_BFu8s  {
  char v1;
  __tsu64 v2;
  unsigned short v3:8;
};
//SIG(1 C_Ul_BFu8s) C1{ Fc FL Fs:8}



static void Test_C_Ul_BFu8s()
{
  {
    init_simple_test("C_Ul_BFu8s");
    static STRUCT_IF_C C_Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "C_Ul_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "C_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu8s, C_Ul_BFu8s)
//============================================================================


struct  C_Ul_BFu9i  {
  char v1;
  __tsu64 v2;
  unsigned int v3:9;
};
//SIG(1 C_Ul_BFu9i) C1{ Fc FL Fi:9}



static void Test_C_Ul_BFu9i()
{
  {
    init_simple_test("C_Ul_BFu9i");
    static STRUCT_IF_C C_Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_Ul_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu9i, C_Ul_BFu9i)
//============================================================================


struct  C_Ul_BFu9ll  {
  char v1;
  __tsu64 v2;
  __tsu64 v3:9;
};
//SIG(1 C_Ul_BFu9ll) C1{ Fc FL FL:9}



static void Test_C_Ul_BFu9ll()
{
  {
    init_simple_test("C_Ul_BFu9ll");
    static STRUCT_IF_C C_Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_Ul_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu9ll, C_Ul_BFu9ll)
//============================================================================


struct  C_Ul_BFu9s  {
  char v1;
  __tsu64 v2;
  unsigned short v3:9;
};
//SIG(1 C_Ul_BFu9s) C1{ Fc FL Fs:9}



static void Test_C_Ul_BFu9s()
{
  {
    init_simple_test("C_Ul_BFu9s");
    static STRUCT_IF_C C_Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "C_Ul_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "C_Ul_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "C_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_BFu9s, C_Ul_BFu9s)
//============================================================================


struct  C_Ul_C  {
  char v1;
  __tsu64 v2;
  char v3;
};
//SIG(1 C_Ul_C) C1{ Fc FL Fc}



static void Test_C_Ul_C()
{
  {
    init_simple_test("C_Ul_C");
    STRUCT_IF_C C_Ul_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_C)");
    check_field_offset(lv, v1, 0, "C_Ul_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_C, C_Ul_C)
//============================================================================


struct  C_Ul_D  {
  char v1;
  __tsu64 v2;
  double v3;
};
//SIG(1 C_Ul_D) C1{ Fc FL[2]}



static void Test_C_Ul_D()
{
  {
    init_simple_test("C_Ul_D");
    STRUCT_IF_C C_Ul_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_Ul_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_D)");
    check_field_offset(lv, v1, 0, "C_Ul_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_D, C_Ul_D)
//============================================================================


struct  C_Ul_F  {
  char v1;
  __tsu64 v2;
  float v3;
};
//SIG(1 C_Ul_F) C1{ Fc FL Fi}



static void Test_C_Ul_F()
{
  {
    init_simple_test("C_Ul_F");
    STRUCT_IF_C C_Ul_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_F)");
    check_field_offset(lv, v1, 0, "C_Ul_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_F, C_Ul_F)
//============================================================================


struct  C_Ul_I  {
  char v1;
  __tsu64 v2;
  int v3;
};
//SIG(1 C_Ul_I) C1{ Fc FL Fi}



static void Test_C_Ul_I()
{
  {
    init_simple_test("C_Ul_I");
    STRUCT_IF_C C_Ul_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_I)");
    check_field_offset(lv, v1, 0, "C_Ul_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_I, C_Ul_I)
//============================================================================


struct  C_Ul_Ip  {
  char v1;
  __tsu64 v2;
  int *v3;
};
//SIG(1 C_Ul_Ip) C1{ Fc FL Fp}



static void Test_C_Ul_Ip()
{
  {
    init_simple_test("C_Ul_Ip");
    STRUCT_IF_C C_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_Ip)");
    check_field_offset(lv, v1, 0, "C_Ul_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_Ip, C_Ul_Ip)
//============================================================================


struct  C_Ul_L  {
  char v1;
  __tsu64 v2;
  __tsi64 v3;
};
//SIG(1 C_Ul_L) C1{ Fc FL[2]}



static void Test_C_Ul_L()
{
  {
    init_simple_test("C_Ul_L");
    STRUCT_IF_C C_Ul_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_Ul_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_L)");
    check_field_offset(lv, v1, 0, "C_Ul_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_L, C_Ul_L)
//============================================================================


struct  C_Ul_S  {
  char v1;
  __tsu64 v2;
  short v3;
};
//SIG(1 C_Ul_S) C1{ Fc FL Fs}



static void Test_C_Ul_S()
{
  {
    init_simple_test("C_Ul_S");
    STRUCT_IF_C C_Ul_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_S)");
    check_field_offset(lv, v1, 0, "C_Ul_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_S, C_Ul_S)
//============================================================================


struct  C_Ul_Uc  {
  char v1;
  __tsu64 v2;
  unsigned char v3;
};
//SIG(1 C_Ul_Uc) C1{ Fc FL Fc}



static void Test_C_Ul_Uc()
{
  {
    init_simple_test("C_Ul_Uc");
    STRUCT_IF_C C_Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_Uc)");
    check_field_offset(lv, v1, 0, "C_Ul_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_Uc, C_Ul_Uc)
//============================================================================


struct  C_Ul_Ui  {
  char v1;
  __tsu64 v2;
  unsigned int v3;
};
//SIG(1 C_Ul_Ui) C1{ Fc FL Fi}



static void Test_C_Ul_Ui()
{
  {
    init_simple_test("C_Ul_Ui");
    STRUCT_IF_C C_Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_Ui)");
    check_field_offset(lv, v1, 0, "C_Ul_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_Ui, C_Ul_Ui)
//============================================================================


struct  C_Ul_Ul  {
  char v1;
  __tsu64 v2;
  __tsu64 v3;
};
//SIG(1 C_Ul_Ul) C1{ Fc FL[2]}



static void Test_C_Ul_Ul()
{
  {
    init_simple_test("C_Ul_Ul");
    STRUCT_IF_C C_Ul_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(C_Ul_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_Ul)");
    check_field_offset(lv, v1, 0, "C_Ul_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_Ul, C_Ul_Ul)
//============================================================================


struct  C_Ul_Us  {
  char v1;
  __tsu64 v2;
  unsigned short v3;
};
//SIG(1 C_Ul_Us) C1{ Fc FL Fs}



static void Test_C_Ul_Us()
{
  {
    init_simple_test("C_Ul_Us");
    STRUCT_IF_C C_Ul_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_Us)");
    check_field_offset(lv, v1, 0, "C_Ul_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_Us, C_Ul_Us)
//============================================================================


struct  C_Ul_Vp  {
  char v1;
  __tsu64 v2;
  void *v3;
};
//SIG(1 C_Ul_Vp) C1{ Fc FL Fp}



static void Test_C_Ul_Vp()
{
  {
    init_simple_test("C_Ul_Vp");
    STRUCT_IF_C C_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_Vp)");
    check_field_offset(lv, v1, 0, "C_Ul_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Ul_Vp, C_Ul_Vp)
//============================================================================


struct  C_Us  {
  char v1;
  unsigned short v2;
};
//SIG(1 C_Us) C1{ Fc Fs}



static void Test_C_Us()
{
  {
    init_simple_test("C_Us");
    STRUCT_IF_C C_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us)");
    check_field_offset(lv, v1, 0, "C_Us.v1");
    check_field_offset(lv, v2, 2, "C_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us, C_Us)
//============================================================================


struct  C_Us_BFu15i  {
  char v1;
  unsigned short v2;
  unsigned int v3:15;
};
//SIG(1 C_Us_BFu15i) C1{ Fc Fs Fi:15}



static void Test_C_Us_BFu15i()
{
  {
    init_simple_test("C_Us_BFu15i");
    static STRUCT_IF_C C_Us_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu15i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "C_Us_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "C_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu15i, C_Us_BFu15i)
//============================================================================


struct  C_Us_BFu15ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:15;
};
//SIG(1 C_Us_BFu15ll) C1{ Fc Fs FL:15}



static void Test_C_Us_BFu15ll()
{
  {
    init_simple_test("C_Us_BFu15ll");
    static STRUCT_IF_C C_Us_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "C_Us_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "C_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu15ll, C_Us_BFu15ll)
//============================================================================


struct  C_Us_BFu15s  {
  char v1;
  unsigned short v2;
  unsigned short v3:15;
};
//SIG(1 C_Us_BFu15s) C1{ Fc Fs Fs:15}



static void Test_C_Us_BFu15s()
{
  {
    init_simple_test("C_Us_BFu15s");
    static STRUCT_IF_C C_Us_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "C_Us_BFu15s.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "C_Us_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "C_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu15s, C_Us_BFu15s)
//============================================================================


struct  C_Us_BFu16i  {
  char v1;
  unsigned short v2;
  unsigned int v3:16;
};
//SIG(1 C_Us_BFu16i) C1{ Fc Fs Fi:16}



static void Test_C_Us_BFu16i()
{
  {
    init_simple_test("C_Us_BFu16i");
    static STRUCT_IF_C C_Us_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu16i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_Us_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu16i, C_Us_BFu16i)
//============================================================================


struct  C_Us_BFu16ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:16;
};
//SIG(1 C_Us_BFu16ll) C1{ Fc Fs FL:16}



static void Test_C_Us_BFu16ll()
{
  {
    init_simple_test("C_Us_BFu16ll");
    static STRUCT_IF_C C_Us_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_Us_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu16ll, C_Us_BFu16ll)
//============================================================================


struct  C_Us_BFu16s  {
  char v1;
  unsigned short v2;
  unsigned short v3:16;
};
//SIG(1 C_Us_BFu16s) C1{ Fc Fs Fs:16}



static void Test_C_Us_BFu16s()
{
  {
    init_simple_test("C_Us_BFu16s");
    static STRUCT_IF_C C_Us_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "C_Us_BFu16s.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "C_Us_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "C_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu16s, C_Us_BFu16s)
//============================================================================


struct  C_Us_BFu17i  {
  char v1;
  unsigned short v2;
  unsigned int v3:17;
};
//SIG(1 C_Us_BFu17i) C1{ Fc Fs Fi:17}



static void Test_C_Us_BFu17i()
{
  {
    init_simple_test("C_Us_BFu17i");
    static STRUCT_IF_C C_Us_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu17i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_Us_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu17i, C_Us_BFu17i)
//============================================================================


struct  C_Us_BFu17ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:17;
};
//SIG(1 C_Us_BFu17ll) C1{ Fc Fs FL:17}



static void Test_C_Us_BFu17ll()
{
  {
    init_simple_test("C_Us_BFu17ll");
    static STRUCT_IF_C C_Us_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_Us_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu17ll, C_Us_BFu17ll)
//============================================================================


struct  C_Us_BFu1c  {
  char v1;
  unsigned short v2;
  unsigned char v3:1;
};
//SIG(1 C_Us_BFu1c) C1{ Fc Fs Fc:1}



static void Test_C_Us_BFu1c()
{
  {
    init_simple_test("C_Us_BFu1c");
    static STRUCT_IF_C C_Us_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "C_Us_BFu1c.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "C_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu1c, C_Us_BFu1c)
//============================================================================


struct  C_Us_BFu1i  {
  char v1;
  unsigned short v2;
  unsigned int v3:1;
};
//SIG(1 C_Us_BFu1i) C1{ Fc Fs Fi:1}



static void Test_C_Us_BFu1i()
{
  {
    init_simple_test("C_Us_BFu1i");
    static STRUCT_IF_C C_Us_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu1i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "C_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu1i, C_Us_BFu1i)
//============================================================================


struct  C_Us_BFu1ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:1;
};
//SIG(1 C_Us_BFu1ll) C1{ Fc Fs FL:1}



static void Test_C_Us_BFu1ll()
{
  {
    init_simple_test("C_Us_BFu1ll");
    static STRUCT_IF_C C_Us_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "C_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu1ll, C_Us_BFu1ll)
//============================================================================


struct  C_Us_BFu1s  {
  char v1;
  unsigned short v2;
  unsigned short v3:1;
};
//SIG(1 C_Us_BFu1s) C1{ Fc Fs Fs:1}



static void Test_C_Us_BFu1s()
{
  {
    init_simple_test("C_Us_BFu1s");
    static STRUCT_IF_C C_Us_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "C_Us_BFu1s.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "C_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu1s, C_Us_BFu1s)
//============================================================================


struct  C_Us_BFu31i  {
  char v1;
  unsigned short v2;
  unsigned int v3:31;
};
//SIG(1 C_Us_BFu31i) C1{ Fc Fs Fi:31}



static void Test_C_Us_BFu31i()
{
  {
    init_simple_test("C_Us_BFu31i");
    static STRUCT_IF_C C_Us_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu31i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_Us_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu31i, C_Us_BFu31i)
//============================================================================


struct  C_Us_BFu31ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:31;
};
//SIG(1 C_Us_BFu31ll) C1{ Fc Fs FL:31}



static void Test_C_Us_BFu31ll()
{
  {
    init_simple_test("C_Us_BFu31ll");
    static STRUCT_IF_C C_Us_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_Us_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu31ll, C_Us_BFu31ll)
//============================================================================


struct  C_Us_BFu32i  {
  char v1;
  unsigned short v2;
  unsigned int v3:32;
};
//SIG(1 C_Us_BFu32i) C1{ Fc Fs Fi:32}



static void Test_C_Us_BFu32i()
{
  {
    init_simple_test("C_Us_BFu32i");
    static STRUCT_IF_C C_Us_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu32i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_Us_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu32i, C_Us_BFu32i)
//============================================================================


struct  C_Us_BFu32ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:32;
};
//SIG(1 C_Us_BFu32ll) C1{ Fc Fs FL:32}



static void Test_C_Us_BFu32ll()
{
  {
    init_simple_test("C_Us_BFu32ll");
    static STRUCT_IF_C C_Us_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_Us_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu32ll, C_Us_BFu32ll)
//============================================================================


struct  C_Us_BFu33  {
  char v1;
  unsigned short v2;
  __tsu64 v3:33;
};
//SIG(1 C_Us_BFu33) C1{ Fc Fs FL:33}



static void Test_C_Us_BFu33()
{
  {
    init_simple_test("C_Us_BFu33");
    static STRUCT_IF_C C_Us_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Us_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu33)");
    check_field_offset(lv, v1, 0, "C_Us_BFu33.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "C_Us_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "C_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu33, C_Us_BFu33)
//============================================================================


struct  C_Us_BFu7c  {
  char v1;
  unsigned short v2;
  unsigned char v3:7;
};
//SIG(1 C_Us_BFu7c) C1{ Fc Fs Fc:7}



static void Test_C_Us_BFu7c()
{
  {
    init_simple_test("C_Us_BFu7c");
    static STRUCT_IF_C C_Us_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "C_Us_BFu7c.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "C_Us_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "C_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu7c, C_Us_BFu7c)
//============================================================================


struct  C_Us_BFu7i  {
  char v1;
  unsigned short v2;
  unsigned int v3:7;
};
//SIG(1 C_Us_BFu7i) C1{ Fc Fs Fi:7}



static void Test_C_Us_BFu7i()
{
  {
    init_simple_test("C_Us_BFu7i");
    static STRUCT_IF_C C_Us_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu7i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "C_Us_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "C_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu7i, C_Us_BFu7i)
//============================================================================


struct  C_Us_BFu7ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:7;
};
//SIG(1 C_Us_BFu7ll) C1{ Fc Fs FL:7}



static void Test_C_Us_BFu7ll()
{
  {
    init_simple_test("C_Us_BFu7ll");
    static STRUCT_IF_C C_Us_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "C_Us_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "C_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu7ll, C_Us_BFu7ll)
//============================================================================


struct  C_Us_BFu7s  {
  char v1;
  unsigned short v2;
  unsigned short v3:7;
};
//SIG(1 C_Us_BFu7s) C1{ Fc Fs Fs:7}



static void Test_C_Us_BFu7s()
{
  {
    init_simple_test("C_Us_BFu7s");
    static STRUCT_IF_C C_Us_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "C_Us_BFu7s.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "C_Us_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "C_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu7s, C_Us_BFu7s)
//============================================================================


struct  C_Us_BFu8c  {
  char v1;
  unsigned short v2;
  unsigned char v3:8;
};
//SIG(1 C_Us_BFu8c) C1{ Fc Fs Fc:8}



static void Test_C_Us_BFu8c()
{
  {
    init_simple_test("C_Us_BFu8c");
    static STRUCT_IF_C C_Us_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "C_Us_BFu8c.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_Us_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu8c, C_Us_BFu8c)
//============================================================================


struct  C_Us_BFu8i  {
  char v1;
  unsigned short v2;
  unsigned int v3:8;
};
//SIG(1 C_Us_BFu8i) C1{ Fc Fs Fi:8}



static void Test_C_Us_BFu8i()
{
  {
    init_simple_test("C_Us_BFu8i");
    static STRUCT_IF_C C_Us_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu8i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_Us_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu8i, C_Us_BFu8i)
//============================================================================


struct  C_Us_BFu8ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:8;
};
//SIG(1 C_Us_BFu8ll) C1{ Fc Fs FL:8}



static void Test_C_Us_BFu8ll()
{
  {
    init_simple_test("C_Us_BFu8ll");
    static STRUCT_IF_C C_Us_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_Us_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu8ll, C_Us_BFu8ll)
//============================================================================


struct  C_Us_BFu8s  {
  char v1;
  unsigned short v2;
  unsigned short v3:8;
};
//SIG(1 C_Us_BFu8s) C1{ Fc Fs Fs:8}



static void Test_C_Us_BFu8s()
{
  {
    init_simple_test("C_Us_BFu8s");
    static STRUCT_IF_C C_Us_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "C_Us_BFu8s.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "C_Us_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "C_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu8s, C_Us_BFu8s)
//============================================================================


struct  C_Us_BFu9i  {
  char v1;
  unsigned short v2;
  unsigned int v3:9;
};
//SIG(1 C_Us_BFu9i) C1{ Fc Fs Fi:9}



static void Test_C_Us_BFu9i()
{
  {
    init_simple_test("C_Us_BFu9i");
    static STRUCT_IF_C C_Us_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "C_Us_BFu9i.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "C_Us_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "C_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu9i, C_Us_BFu9i)
//============================================================================


struct  C_Us_BFu9ll  {
  char v1;
  unsigned short v2;
  __tsu64 v3:9;
};
//SIG(1 C_Us_BFu9ll) C1{ Fc Fs FL:9}



static void Test_C_Us_BFu9ll()
{
  {
    init_simple_test("C_Us_BFu9ll");
    static STRUCT_IF_C C_Us_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "C_Us_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "C_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu9ll, C_Us_BFu9ll)
//============================================================================


struct  C_Us_BFu9s  {
  char v1;
  unsigned short v2;
  unsigned short v3:9;
};
//SIG(1 C_Us_BFu9s) C1{ Fc Fs Fs:9}



static void Test_C_Us_BFu9s()
{
  {
    init_simple_test("C_Us_BFu9s");
    static STRUCT_IF_C C_Us_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "C_Us_BFu9s.v1");
    check_field_offset(lv, v2, 2, "C_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "C_Us_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "C_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_BFu9s, C_Us_BFu9s)
//============================================================================


struct  C_Us_C  {
  char v1;
  unsigned short v2;
  char v3;
};
//SIG(1 C_Us_C) C1{ Fc Fs Fc}



static void Test_C_Us_C()
{
  {
    init_simple_test("C_Us_C");
    STRUCT_IF_C C_Us_C lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_C)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_C)");
    check_field_offset(lv, v1, 0, "C_Us_C.v1");
    check_field_offset(lv, v2, 2, "C_Us_C.v2");
    check_field_offset(lv, v3, 4, "C_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_C, C_Us_C)
//============================================================================


struct  C_Us_D  {
  char v1;
  unsigned short v2;
  double v3;
};
//SIG(1 C_Us_D) C1{ Fc Fs FL}



static void Test_C_Us_D()
{
  {
    init_simple_test("C_Us_D");
    STRUCT_IF_C C_Us_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Us_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_D)");
    check_field_offset(lv, v1, 0, "C_Us_D.v1");
    check_field_offset(lv, v2, 2, "C_Us_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_D, C_Us_D)
//============================================================================


struct  C_Us_F  {
  char v1;
  unsigned short v2;
  float v3;
};
//SIG(1 C_Us_F) C1{ Fc Fs Fi}



static void Test_C_Us_F()
{
  {
    init_simple_test("C_Us_F");
    STRUCT_IF_C C_Us_F lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_F)");
    check_field_offset(lv, v1, 0, "C_Us_F.v1");
    check_field_offset(lv, v2, 2, "C_Us_F.v2");
    check_field_offset(lv, v3, 4, "C_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_F, C_Us_F)
//============================================================================


struct  C_Us_I  {
  char v1;
  unsigned short v2;
  int v3;
};
//SIG(1 C_Us_I) C1{ Fc Fs Fi}



static void Test_C_Us_I()
{
  {
    init_simple_test("C_Us_I");
    STRUCT_IF_C C_Us_I lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_I)");
    check_field_offset(lv, v1, 0, "C_Us_I.v1");
    check_field_offset(lv, v2, 2, "C_Us_I.v2");
    check_field_offset(lv, v3, 4, "C_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_I, C_Us_I)
//============================================================================


struct  C_Us_Ip  {
  char v1;
  unsigned short v2;
  int *v3;
};
//SIG(1 C_Us_Ip) C1{ Fc Fs Fp}



static void Test_C_Us_Ip()
{
  {
    init_simple_test("C_Us_Ip");
    STRUCT_IF_C C_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_Us_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_Ip)");
    check_field_offset(lv, v1, 0, "C_Us_Ip.v1");
    check_field_offset(lv, v2, 2, "C_Us_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_Ip, C_Us_Ip)
//============================================================================


struct  C_Us_L  {
  char v1;
  unsigned short v2;
  __tsi64 v3;
};
//SIG(1 C_Us_L) C1{ Fc Fs FL}



static void Test_C_Us_L()
{
  {
    init_simple_test("C_Us_L");
    STRUCT_IF_C C_Us_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Us_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_L)");
    check_field_offset(lv, v1, 0, "C_Us_L.v1");
    check_field_offset(lv, v2, 2, "C_Us_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_L, C_Us_L)
//============================================================================


struct  C_Us_S  {
  char v1;
  unsigned short v2;
  short v3;
};
//SIG(1 C_Us_S) C1{ Fc Fs[2]}



static void Test_C_Us_S()
{
  {
    init_simple_test("C_Us_S");
    STRUCT_IF_C C_Us_S lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_S)");
    check_field_offset(lv, v1, 0, "C_Us_S.v1");
    check_field_offset(lv, v2, 2, "C_Us_S.v2");
    check_field_offset(lv, v3, 4, "C_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_S, C_Us_S)
//============================================================================


struct  C_Us_Uc  {
  char v1;
  unsigned short v2;
  unsigned char v3;
};
//SIG(1 C_Us_Uc) C1{ Fc Fs Fc}



static void Test_C_Us_Uc()
{
  {
    init_simple_test("C_Us_Uc");
    STRUCT_IF_C C_Us_Uc lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_Uc)");
    check_field_offset(lv, v1, 0, "C_Us_Uc.v1");
    check_field_offset(lv, v2, 2, "C_Us_Uc.v2");
    check_field_offset(lv, v3, 4, "C_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_Uc, C_Us_Uc)
//============================================================================


struct  C_Us_Ui  {
  char v1;
  unsigned short v2;
  unsigned int v3;
};
//SIG(1 C_Us_Ui) C1{ Fc Fs Fi}



static void Test_C_Us_Ui()
{
  {
    init_simple_test("C_Us_Ui");
    STRUCT_IF_C C_Us_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_Us_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_Us_Ui)");
    check_field_offset(lv, v1, 0, "C_Us_Ui.v1");
    check_field_offset(lv, v2, 2, "C_Us_Ui.v2");
    check_field_offset(lv, v3, 4, "C_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_Ui, C_Us_Ui)
//============================================================================


struct  C_Us_Ul  {
  char v1;
  unsigned short v2;
  __tsu64 v3;
};
//SIG(1 C_Us_Ul) C1{ Fc Fs FL}



static void Test_C_Us_Ul()
{
  {
    init_simple_test("C_Us_Ul");
    STRUCT_IF_C C_Us_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_Us_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_Ul)");
    check_field_offset(lv, v1, 0, "C_Us_Ul.v1");
    check_field_offset(lv, v2, 2, "C_Us_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_Ul, C_Us_Ul)
//============================================================================


struct  C_Us_Us  {
  char v1;
  unsigned short v2;
  unsigned short v3;
};
//SIG(1 C_Us_Us) C1{ Fc Fs[2]}



static void Test_C_Us_Us()
{
  {
    init_simple_test("C_Us_Us");
    STRUCT_IF_C C_Us_Us lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_Us)");
    check_field_offset(lv, v1, 0, "C_Us_Us.v1");
    check_field_offset(lv, v2, 2, "C_Us_Us.v2");
    check_field_offset(lv, v3, 4, "C_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_Us, C_Us_Us)
//============================================================================


struct  C_Us_Vp  {
  char v1;
  unsigned short v2;
  void *v3;
};
//SIG(1 C_Us_Vp) C1{ Fc Fs Fp}



static void Test_C_Us_Vp()
{
  {
    init_simple_test("C_Us_Vp");
    STRUCT_IF_C C_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_Us_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Us_Vp)");
    check_field_offset(lv, v1, 0, "C_Us_Vp.v1");
    check_field_offset(lv, v2, 2, "C_Us_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Us_Vp, C_Us_Vp)
//============================================================================


struct  C_Vp  {
  char v1;
  void *v2;
};
//SIG(1 C_Vp) C1{ Fc Fp}



static void Test_C_Vp()
{
  {
    init_simple_test("C_Vp");
    STRUCT_IF_C C_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp)");
    check_field_offset(lv, v1, 0, "C_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp, C_Vp)
//============================================================================


struct  C_Vp_BFu15i  {
  char v1;
  void *v2;
  unsigned int v3:15;
};
//SIG(1 C_Vp_BFu15i) C1{ Fc Fp Fi:15}



static void Test_C_Vp_BFu15i()
{
  {
    init_simple_test("C_Vp_BFu15i");
    static STRUCT_IF_C C_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "C_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "C_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu15i, C_Vp_BFu15i)
//============================================================================


struct  C_Vp_BFu15ll  {
  char v1;
  void *v2;
  __tsu64 v3:15;
};
//SIG(1 C_Vp_BFu15ll) C1{ Fc Fp FL:15}



static void Test_C_Vp_BFu15ll()
{
  {
    init_simple_test("C_Vp_BFu15ll");
    static STRUCT_IF_C C_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "C_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "C_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu15ll, C_Vp_BFu15ll)
//============================================================================


struct  C_Vp_BFu15s  {
  char v1;
  void *v2;
  unsigned short v3:15;
};
//SIG(1 C_Vp_BFu15s) C1{ Fc Fp Fs:15}



static void Test_C_Vp_BFu15s()
{
  {
    init_simple_test("C_Vp_BFu15s");
    static STRUCT_IF_C C_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "C_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "C_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu15s, C_Vp_BFu15s)
//============================================================================


struct  C_Vp_BFu16i  {
  char v1;
  void *v2;
  unsigned int v3:16;
};
//SIG(1 C_Vp_BFu16i) C1{ Fc Fp Fi:16}



static void Test_C_Vp_BFu16i()
{
  {
    init_simple_test("C_Vp_BFu16i");
    static STRUCT_IF_C C_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "C_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "C_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu16i, C_Vp_BFu16i)
//============================================================================


struct  C_Vp_BFu16ll  {
  char v1;
  void *v2;
  __tsu64 v3:16;
};
//SIG(1 C_Vp_BFu16ll) C1{ Fc Fp FL:16}



static void Test_C_Vp_BFu16ll()
{
  {
    init_simple_test("C_Vp_BFu16ll");
    static STRUCT_IF_C C_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "C_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "C_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu16ll, C_Vp_BFu16ll)
//============================================================================


struct  C_Vp_BFu16s  {
  char v1;
  void *v2;
  unsigned short v3:16;
};
//SIG(1 C_Vp_BFu16s) C1{ Fc Fp Fs:16}



static void Test_C_Vp_BFu16s()
{
  {
    init_simple_test("C_Vp_BFu16s");
    static STRUCT_IF_C C_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "C_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "C_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu16s, C_Vp_BFu16s)
//============================================================================


struct  C_Vp_BFu17i  {
  char v1;
  void *v2;
  unsigned int v3:17;
};
//SIG(1 C_Vp_BFu17i) C1{ Fc Fp Fi:17}



static void Test_C_Vp_BFu17i()
{
  {
    init_simple_test("C_Vp_BFu17i");
    static STRUCT_IF_C C_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "C_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "C_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu17i, C_Vp_BFu17i)
//============================================================================


struct  C_Vp_BFu17ll  {
  char v1;
  void *v2;
  __tsu64 v3:17;
};
//SIG(1 C_Vp_BFu17ll) C1{ Fc Fp FL:17}



static void Test_C_Vp_BFu17ll()
{
  {
    init_simple_test("C_Vp_BFu17ll");
    static STRUCT_IF_C C_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "C_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "C_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu17ll, C_Vp_BFu17ll)
//============================================================================


struct  C_Vp_BFu1c  {
  char v1;
  void *v2;
  unsigned char v3:1;
};
//SIG(1 C_Vp_BFu1c) C1{ Fc Fp Fc:1}



static void Test_C_Vp_BFu1c()
{
  {
    init_simple_test("C_Vp_BFu1c");
    static STRUCT_IF_C C_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "C_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu1c, C_Vp_BFu1c)
//============================================================================


struct  C_Vp_BFu1i  {
  char v1;
  void *v2;
  unsigned int v3:1;
};
//SIG(1 C_Vp_BFu1i) C1{ Fc Fp Fi:1}



static void Test_C_Vp_BFu1i()
{
  {
    init_simple_test("C_Vp_BFu1i");
    static STRUCT_IF_C C_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "C_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu1i, C_Vp_BFu1i)
//============================================================================


struct  C_Vp_BFu1ll  {
  char v1;
  void *v2;
  __tsu64 v3:1;
};
//SIG(1 C_Vp_BFu1ll) C1{ Fc Fp FL:1}



static void Test_C_Vp_BFu1ll()
{
  {
    init_simple_test("C_Vp_BFu1ll");
    static STRUCT_IF_C C_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "C_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu1ll, C_Vp_BFu1ll)
//============================================================================


struct  C_Vp_BFu1s  {
  char v1;
  void *v2;
  unsigned short v3:1;
};
//SIG(1 C_Vp_BFu1s) C1{ Fc Fp Fs:1}



static void Test_C_Vp_BFu1s()
{
  {
    init_simple_test("C_Vp_BFu1s");
    static STRUCT_IF_C C_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "C_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu1s, C_Vp_BFu1s)
//============================================================================


struct  C_Vp_BFu31i  {
  char v1;
  void *v2;
  unsigned int v3:31;
};
//SIG(1 C_Vp_BFu31i) C1{ Fc Fp Fi:31}



static void Test_C_Vp_BFu31i()
{
  {
    init_simple_test("C_Vp_BFu31i");
    static STRUCT_IF_C C_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "C_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "C_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu31i, C_Vp_BFu31i)
//============================================================================


struct  C_Vp_BFu31ll  {
  char v1;
  void *v2;
  __tsu64 v3:31;
};
//SIG(1 C_Vp_BFu31ll) C1{ Fc Fp FL:31}



static void Test_C_Vp_BFu31ll()
{
  {
    init_simple_test("C_Vp_BFu31ll");
    static STRUCT_IF_C C_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "C_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "C_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu31ll, C_Vp_BFu31ll)
//============================================================================


struct  C_Vp_BFu32i  {
  char v1;
  void *v2;
  unsigned int v3:32;
};
//SIG(1 C_Vp_BFu32i) C1{ Fc Fp Fi:32}



static void Test_C_Vp_BFu32i()
{
  {
    init_simple_test("C_Vp_BFu32i");
    static STRUCT_IF_C C_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "C_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "C_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu32i, C_Vp_BFu32i)
//============================================================================


struct  C_Vp_BFu32ll  {
  char v1;
  void *v2;
  __tsu64 v3:32;
};
//SIG(1 C_Vp_BFu32ll) C1{ Fc Fp FL:32}



static void Test_C_Vp_BFu32ll()
{
  {
    init_simple_test("C_Vp_BFu32ll");
    static STRUCT_IF_C C_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "C_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "C_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu32ll, C_Vp_BFu32ll)
//============================================================================


struct  C_Vp_BFu33  {
  char v1;
  void *v2;
  __tsu64 v3:33;
};
//SIG(1 C_Vp_BFu33) C1{ Fc Fp FL:33}



static void Test_C_Vp_BFu33()
{
  {
    init_simple_test("C_Vp_BFu33");
    static STRUCT_IF_C C_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Vp_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "C_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "C_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu33, C_Vp_BFu33)
//============================================================================


struct  C_Vp_BFu7c  {
  char v1;
  void *v2;
  unsigned char v3:7;
};
//SIG(1 C_Vp_BFu7c) C1{ Fc Fp Fc:7}



static void Test_C_Vp_BFu7c()
{
  {
    init_simple_test("C_Vp_BFu7c");
    static STRUCT_IF_C C_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "C_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "C_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu7c, C_Vp_BFu7c)
//============================================================================


struct  C_Vp_BFu7i  {
  char v1;
  void *v2;
  unsigned int v3:7;
};
//SIG(1 C_Vp_BFu7i) C1{ Fc Fp Fi:7}



static void Test_C_Vp_BFu7i()
{
  {
    init_simple_test("C_Vp_BFu7i");
    static STRUCT_IF_C C_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "C_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "C_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu7i, C_Vp_BFu7i)
//============================================================================


struct  C_Vp_BFu7ll  {
  char v1;
  void *v2;
  __tsu64 v3:7;
};
//SIG(1 C_Vp_BFu7ll) C1{ Fc Fp FL:7}



static void Test_C_Vp_BFu7ll()
{
  {
    init_simple_test("C_Vp_BFu7ll");
    static STRUCT_IF_C C_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "C_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "C_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu7ll, C_Vp_BFu7ll)
//============================================================================


struct  C_Vp_BFu7s  {
  char v1;
  void *v2;
  unsigned short v3:7;
};
//SIG(1 C_Vp_BFu7s) C1{ Fc Fp Fs:7}



static void Test_C_Vp_BFu7s()
{
  {
    init_simple_test("C_Vp_BFu7s");
    static STRUCT_IF_C C_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "C_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "C_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu7s, C_Vp_BFu7s)
//============================================================================


struct  C_Vp_BFu8c  {
  char v1;
  void *v2;
  unsigned char v3:8;
};
//SIG(1 C_Vp_BFu8c) C1{ Fc Fp Fc:8}



static void Test_C_Vp_BFu8c()
{
  {
    init_simple_test("C_Vp_BFu8c");
    static STRUCT_IF_C C_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "C_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "C_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu8c, C_Vp_BFu8c)
//============================================================================


struct  C_Vp_BFu8i  {
  char v1;
  void *v2;
  unsigned int v3:8;
};
//SIG(1 C_Vp_BFu8i) C1{ Fc Fp Fi:8}



static void Test_C_Vp_BFu8i()
{
  {
    init_simple_test("C_Vp_BFu8i");
    static STRUCT_IF_C C_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "C_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "C_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu8i, C_Vp_BFu8i)
//============================================================================


struct  C_Vp_BFu8ll  {
  char v1;
  void *v2;
  __tsu64 v3:8;
};
//SIG(1 C_Vp_BFu8ll) C1{ Fc Fp FL:8}



static void Test_C_Vp_BFu8ll()
{
  {
    init_simple_test("C_Vp_BFu8ll");
    static STRUCT_IF_C C_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "C_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "C_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu8ll, C_Vp_BFu8ll)
//============================================================================


struct  C_Vp_BFu8s  {
  char v1;
  void *v2;
  unsigned short v3:8;
};
//SIG(1 C_Vp_BFu8s) C1{ Fc Fp Fs:8}



static void Test_C_Vp_BFu8s()
{
  {
    init_simple_test("C_Vp_BFu8s");
    static STRUCT_IF_C C_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "C_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "C_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu8s, C_Vp_BFu8s)
//============================================================================


struct  C_Vp_BFu9i  {
  char v1;
  void *v2;
  unsigned int v3:9;
};
//SIG(1 C_Vp_BFu9i) C1{ Fc Fp Fi:9}



static void Test_C_Vp_BFu9i()
{
  {
    init_simple_test("C_Vp_BFu9i");
    static STRUCT_IF_C C_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "C_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "C_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu9i, C_Vp_BFu9i)
//============================================================================


struct  C_Vp_BFu9ll  {
  char v1;
  void *v2;
  __tsu64 v3:9;
};
//SIG(1 C_Vp_BFu9ll) C1{ Fc Fp FL:9}



static void Test_C_Vp_BFu9ll()
{
  {
    init_simple_test("C_Vp_BFu9ll");
    static STRUCT_IF_C C_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "C_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "C_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu9ll, C_Vp_BFu9ll)
//============================================================================


struct  C_Vp_BFu9s  {
  char v1;
  void *v2;
  unsigned short v3:9;
};
//SIG(1 C_Vp_BFu9s) C1{ Fc Fp Fs:9}



static void Test_C_Vp_BFu9s()
{
  {
    init_simple_test("C_Vp_BFu9s");
    static STRUCT_IF_C C_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "C_Vp_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "C_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "C_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_BFu9s, C_Vp_BFu9s)
//============================================================================


struct  C_Vp_C  {
  char v1;
  void *v2;
  char v3;
};
//SIG(1 C_Vp_C) C1{ Fc Fp Fc}



static void Test_C_Vp_C()
{
  {
    init_simple_test("C_Vp_C");
    STRUCT_IF_C C_Vp_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_C)");
    check_field_offset(lv, v1, 0, "C_Vp_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_C, C_Vp_C)
//============================================================================


struct  C_Vp_D  {
  char v1;
  void *v2;
  double v3;
};
//SIG(1 C_Vp_D) C1{ Fc Fp FL}



static void Test_C_Vp_D()
{
  {
    init_simple_test("C_Vp_D");
    STRUCT_IF_C C_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Vp_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_D)");
    check_field_offset(lv, v1, 0, "C_Vp_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_D, C_Vp_D)
//============================================================================


struct  C_Vp_F  {
  char v1;
  void *v2;
  float v3;
};
//SIG(1 C_Vp_F) C1{ Fc Fp Fi}



static void Test_C_Vp_F()
{
  {
    init_simple_test("C_Vp_F");
    STRUCT_IF_C C_Vp_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_F)");
    check_field_offset(lv, v1, 0, "C_Vp_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_F, C_Vp_F)
//============================================================================


struct  C_Vp_I  {
  char v1;
  void *v2;
  int v3;
};
//SIG(1 C_Vp_I) C1{ Fc Fp Fi}



static void Test_C_Vp_I()
{
  {
    init_simple_test("C_Vp_I");
    STRUCT_IF_C C_Vp_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_I)");
    check_field_offset(lv, v1, 0, "C_Vp_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_I, C_Vp_I)
//============================================================================


struct  C_Vp_Ip  {
  char v1;
  void *v2;
  int *v3;
};
//SIG(1 C_Vp_Ip) C1{ Fc Fp[2]}



static void Test_C_Vp_Ip()
{
  {
    init_simple_test("C_Vp_Ip");
    STRUCT_IF_C C_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_Ip)");
    check_field_offset(lv, v1, 0, "C_Vp_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_Ip, C_Vp_Ip)
//============================================================================


struct  C_Vp_L  {
  char v1;
  void *v2;
  __tsi64 v3;
};
//SIG(1 C_Vp_L) C1{ Fc Fp FL}



static void Test_C_Vp_L()
{
  {
    init_simple_test("C_Vp_L");
    STRUCT_IF_C C_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Vp_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_L)");
    check_field_offset(lv, v1, 0, "C_Vp_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_L, C_Vp_L)
//============================================================================


struct  C_Vp_S  {
  char v1;
  void *v2;
  short v3;
};
//SIG(1 C_Vp_S) C1{ Fc Fp Fs}



static void Test_C_Vp_S()
{
  {
    init_simple_test("C_Vp_S");
    STRUCT_IF_C C_Vp_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_S)");
    check_field_offset(lv, v1, 0, "C_Vp_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_S, C_Vp_S)
//============================================================================


struct  C_Vp_Uc  {
  char v1;
  void *v2;
  unsigned char v3;
};
//SIG(1 C_Vp_Uc) C1{ Fc Fp Fc}



static void Test_C_Vp_Uc()
{
  {
    init_simple_test("C_Vp_Uc");
    STRUCT_IF_C C_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_Uc)");
    check_field_offset(lv, v1, 0, "C_Vp_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_Uc, C_Vp_Uc)
//============================================================================


struct  C_Vp_Ui  {
  char v1;
  void *v2;
  unsigned int v3;
};
//SIG(1 C_Vp_Ui) C1{ Fc Fp Fi}



static void Test_C_Vp_Ui()
{
  {
    init_simple_test("C_Vp_Ui");
    STRUCT_IF_C C_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_Ui)");
    check_field_offset(lv, v1, 0, "C_Vp_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_Ui, C_Vp_Ui)
//============================================================================


struct  C_Vp_Ul  {
  char v1;
  void *v2;
  __tsu64 v3;
};
//SIG(1 C_Vp_Ul) C1{ Fc Fp FL}



static void Test_C_Vp_Ul()
{
  {
    init_simple_test("C_Vp_Ul");
    STRUCT_IF_C C_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Vp_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_Ul)");
    check_field_offset(lv, v1, 0, "C_Vp_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_Ul, C_Vp_Ul)
//============================================================================


struct  C_Vp_Us  {
  char v1;
  void *v2;
  unsigned short v3;
};
//SIG(1 C_Vp_Us) C1{ Fc Fp Fs}



static void Test_C_Vp_Us()
{
  {
    init_simple_test("C_Vp_Us");
    STRUCT_IF_C C_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_Us)");
    check_field_offset(lv, v1, 0, "C_Vp_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_Us, C_Vp_Us)
//============================================================================


struct  C_Vp_Vp  {
  char v1;
  void *v2;
  void *v3;
};
//SIG(1 C_Vp_Vp) C1{ Fc Fp[2]}



static void Test_C_Vp_Vp()
{
  {
    init_simple_test("C_Vp_Vp");
    STRUCT_IF_C C_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_Vp)");
    check_field_offset(lv, v1, 0, "C_Vp_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_Vp_Vp, C_Vp_Vp)
//============================================================================


struct  D  {
  double v1;
};
//SIG(1 D) C1{ FL}



static void Test_D()
{
  {
    init_simple_test("D");
    STRUCT_IF_C D lv;
    check2(sizeof(lv), 8, "sizeof(D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D)");
    check_field_offset(lv, v1, 0, "D.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_D, D)
//============================================================================


struct  D_BFu15i  {
  double v1;
  unsigned int v2:15;
};
//SIG(1 D_BFu15i) C1{ FL Fi:15}



static void Test_D_BFu15i()
{
  {
    init_simple_test("D_BFu15i");
    static STRUCT_IF_C D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i, D_BFu15i)
//============================================================================


struct  D_BFu15i_BFu15i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 D_BFu15i_BFu15i) C1{ FL Fi:15 Fi:15}



static void Test_D_BFu15i_BFu15i()
{
  {
    init_simple_test("D_BFu15i_BFu15i");
    static STRUCT_IF_C D_BFu15i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "D_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "D_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu15i, D_BFu15i_BFu15i)
//============================================================================


struct  D_BFu15i_BFu15ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 D_BFu15i_BFu15ll) C1{ FL Fi:15 FL:15}



static void Test_D_BFu15i_BFu15ll()
{
  {
    init_simple_test("D_BFu15i_BFu15ll");
    static STRUCT_IF_C D_BFu15i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "D_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "D_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu15ll, D_BFu15i_BFu15ll)
//============================================================================


struct  D_BFu15i_BFu15s  {
  double v1;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 D_BFu15i_BFu15s) C1{ FL Fi:15 Fs:15}



static void Test_D_BFu15i_BFu15s()
{
  {
    init_simple_test("D_BFu15i_BFu15s");
    static STRUCT_IF_C D_BFu15i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu15s, D_BFu15i_BFu15s)
//============================================================================


struct  D_BFu15i_BFu16i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:16;
};
//SIG(1 D_BFu15i_BFu16i) C1{ FL Fi:15 Fi:16}



static void Test_D_BFu15i_BFu16i()
{
  {
    init_simple_test("D_BFu15i_BFu16i");
    static STRUCT_IF_C D_BFu15i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "D_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "D_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu16i, D_BFu15i_BFu16i)
//============================================================================


struct  D_BFu15i_BFu16ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:16;
};
//SIG(1 D_BFu15i_BFu16ll) C1{ FL Fi:15 FL:16}



static void Test_D_BFu15i_BFu16ll()
{
  {
    init_simple_test("D_BFu15i_BFu16ll");
    static STRUCT_IF_C D_BFu15i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "D_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "D_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu16ll, D_BFu15i_BFu16ll)
//============================================================================


struct  D_BFu15i_BFu16s  {
  double v1;
  unsigned int v2:15;
  unsigned short v3:16;
};
//SIG(1 D_BFu15i_BFu16s) C1{ FL Fi:15 Fs:16}



static void Test_D_BFu15i_BFu16s()
{
  {
    init_simple_test("D_BFu15i_BFu16s");
    static STRUCT_IF_C D_BFu15i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu16s, D_BFu15i_BFu16s)
//============================================================================


struct  D_BFu15i_BFu17i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:17;
};
//SIG(1 D_BFu15i_BFu17i) C1{ FL Fi:15 Fi:17}



static void Test_D_BFu15i_BFu17i()
{
  {
    init_simple_test("D_BFu15i_BFu17i");
    static STRUCT_IF_C D_BFu15i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "D_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "D_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu17i, D_BFu15i_BFu17i)
//============================================================================


struct  D_BFu15i_BFu17ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:17;
};
//SIG(1 D_BFu15i_BFu17ll) C1{ FL Fi:15 FL:17}



static void Test_D_BFu15i_BFu17ll()
{
  {
    init_simple_test("D_BFu15i_BFu17ll");
    static STRUCT_IF_C D_BFu15i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "D_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "D_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu17ll, D_BFu15i_BFu17ll)
//============================================================================


struct  D_BFu15i_BFu1c  {
  double v1;
  unsigned int v2:15;
  unsigned char v3:1;
};
//SIG(1 D_BFu15i_BFu1c) C1{ FL Fi:15 Fc:1}



static void Test_D_BFu15i_BFu1c()
{
  {
    init_simple_test("D_BFu15i_BFu1c");
    static STRUCT_IF_C D_BFu15i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu1c, D_BFu15i_BFu1c)
//============================================================================


struct  D_BFu15i_BFu1i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:1;
};
//SIG(1 D_BFu15i_BFu1i) C1{ FL Fi:15 Fi:1}



static void Test_D_BFu15i_BFu1i()
{
  {
    init_simple_test("D_BFu15i_BFu1i");
    static STRUCT_IF_C D_BFu15i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu1i, D_BFu15i_BFu1i)
//============================================================================


struct  D_BFu15i_BFu1ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:1;
};
//SIG(1 D_BFu15i_BFu1ll) C1{ FL Fi:15 FL:1}



static void Test_D_BFu15i_BFu1ll()
{
  {
    init_simple_test("D_BFu15i_BFu1ll");
    static STRUCT_IF_C D_BFu15i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu1ll, D_BFu15i_BFu1ll)
//============================================================================


struct  D_BFu15i_BFu1s  {
  double v1;
  unsigned int v2:15;
  unsigned short v3:1;
};
//SIG(1 D_BFu15i_BFu1s) C1{ FL Fi:15 Fs:1}



static void Test_D_BFu15i_BFu1s()
{
  {
    init_simple_test("D_BFu15i_BFu1s");
    static STRUCT_IF_C D_BFu15i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu1s, D_BFu15i_BFu1s)
//============================================================================


struct  D_BFu15i_BFu31i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:31;
};
//SIG(1 D_BFu15i_BFu31i) C1{ FL Fi:15 Fi:31}



static void Test_D_BFu15i_BFu31i()
{
  {
    init_simple_test("D_BFu15i_BFu31i");
    static STRUCT_IF_C D_BFu15i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu31i, D_BFu15i_BFu31i)
//============================================================================


struct  D_BFu15i_BFu31ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:31;
};
//SIG(1 D_BFu15i_BFu31ll) C1{ FL Fi:15 FL:31}



static void Test_D_BFu15i_BFu31ll()
{
  {
    init_simple_test("D_BFu15i_BFu31ll");
    static STRUCT_IF_C D_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "D_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "D_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu31ll, D_BFu15i_BFu31ll)
//============================================================================


struct  D_BFu15i_BFu32i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:32;
};
//SIG(1 D_BFu15i_BFu32i) C1{ FL Fi:15 Fi:32}



static void Test_D_BFu15i_BFu32i()
{
  {
    init_simple_test("D_BFu15i_BFu32i");
    static STRUCT_IF_C D_BFu15i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu32i, D_BFu15i_BFu32i)
//============================================================================


struct  D_BFu15i_BFu32ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:32;
};
//SIG(1 D_BFu15i_BFu32ll) C1{ FL Fi:15 FL:32}



static void Test_D_BFu15i_BFu32ll()
{
  {
    init_simple_test("D_BFu15i_BFu32ll");
    static STRUCT_IF_C D_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "D_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "D_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu32ll, D_BFu15i_BFu32ll)
//============================================================================


struct  D_BFu15i_BFu33  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:33;
};
//SIG(1 D_BFu15i_BFu33) C1{ FL Fi:15 FL:33}



static void Test_D_BFu15i_BFu33()
{
  {
    init_simple_test("D_BFu15i_BFu33");
    static STRUCT_IF_C D_BFu15i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "D_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "D_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu33, D_BFu15i_BFu33)
//============================================================================


struct  D_BFu15i_BFu7c  {
  double v1;
  unsigned int v2:15;
  unsigned char v3:7;
};
//SIG(1 D_BFu15i_BFu7c) C1{ FL Fi:15 Fc:7}



static void Test_D_BFu15i_BFu7c()
{
  {
    init_simple_test("D_BFu15i_BFu7c");
    static STRUCT_IF_C D_BFu15i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu7c, D_BFu15i_BFu7c)
//============================================================================


struct  D_BFu15i_BFu7i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:7;
};
//SIG(1 D_BFu15i_BFu7i) C1{ FL Fi:15 Fi:7}



static void Test_D_BFu15i_BFu7i()
{
  {
    init_simple_test("D_BFu15i_BFu7i");
    static STRUCT_IF_C D_BFu15i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "D_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "D_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu7i, D_BFu15i_BFu7i)
//============================================================================


struct  D_BFu15i_BFu7ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:7;
};
//SIG(1 D_BFu15i_BFu7ll) C1{ FL Fi:15 FL:7}



static void Test_D_BFu15i_BFu7ll()
{
  {
    init_simple_test("D_BFu15i_BFu7ll");
    static STRUCT_IF_C D_BFu15i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "D_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "D_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu7ll, D_BFu15i_BFu7ll)
//============================================================================


struct  D_BFu15i_BFu7s  {
  double v1;
  unsigned int v2:15;
  unsigned short v3:7;
};
//SIG(1 D_BFu15i_BFu7s) C1{ FL Fi:15 Fs:7}



static void Test_D_BFu15i_BFu7s()
{
  {
    init_simple_test("D_BFu15i_BFu7s");
    static STRUCT_IF_C D_BFu15i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu7s, D_BFu15i_BFu7s)
//============================================================================


struct  D_BFu15i_BFu8c  {
  double v1;
  unsigned int v2:15;
  unsigned char v3:8;
};
//SIG(1 D_BFu15i_BFu8c) C1{ FL Fi:15 Fc:8}



static void Test_D_BFu15i_BFu8c()
{
  {
    init_simple_test("D_BFu15i_BFu8c");
    static STRUCT_IF_C D_BFu15i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu8c, D_BFu15i_BFu8c)
//============================================================================


struct  D_BFu15i_BFu8i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:8;
};
//SIG(1 D_BFu15i_BFu8i) C1{ FL Fi:15 Fi:8}



static void Test_D_BFu15i_BFu8i()
{
  {
    init_simple_test("D_BFu15i_BFu8i");
    static STRUCT_IF_C D_BFu15i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "D_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "D_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu8i, D_BFu15i_BFu8i)
//============================================================================


struct  D_BFu15i_BFu8ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:8;
};
//SIG(1 D_BFu15i_BFu8ll) C1{ FL Fi:15 FL:8}



static void Test_D_BFu15i_BFu8ll()
{
  {
    init_simple_test("D_BFu15i_BFu8ll");
    static STRUCT_IF_C D_BFu15i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "D_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "D_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu8ll, D_BFu15i_BFu8ll)
//============================================================================


struct  D_BFu15i_BFu8s  {
  double v1;
  unsigned int v2:15;
  unsigned short v3:8;
};
//SIG(1 D_BFu15i_BFu8s) C1{ FL Fi:15 Fs:8}



static void Test_D_BFu15i_BFu8s()
{
  {
    init_simple_test("D_BFu15i_BFu8s");
    static STRUCT_IF_C D_BFu15i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu8s, D_BFu15i_BFu8s)
//============================================================================


struct  D_BFu15i_BFu9i  {
  double v1;
  unsigned int v2:15;
  unsigned int v3:9;
};
//SIG(1 D_BFu15i_BFu9i) C1{ FL Fi:15 Fi:9}



static void Test_D_BFu15i_BFu9i()
{
  {
    init_simple_test("D_BFu15i_BFu9i");
    static STRUCT_IF_C D_BFu15i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "D_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "D_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu9i, D_BFu15i_BFu9i)
//============================================================================


struct  D_BFu15i_BFu9ll  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3:9;
};
//SIG(1 D_BFu15i_BFu9ll) C1{ FL Fi:15 FL:9}



static void Test_D_BFu15i_BFu9ll()
{
  {
    init_simple_test("D_BFu15i_BFu9ll");
    static STRUCT_IF_C D_BFu15i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "D_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "D_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu9ll, D_BFu15i_BFu9ll)
//============================================================================


struct  D_BFu15i_BFu9s  {
  double v1;
  unsigned int v2:15;
  unsigned short v3:9;
};
//SIG(1 D_BFu15i_BFu9s) C1{ FL Fi:15 Fs:9}



static void Test_D_BFu15i_BFu9s()
{
  {
    init_simple_test("D_BFu15i_BFu9s");
    static STRUCT_IF_C D_BFu15i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_BFu9s, D_BFu15i_BFu9s)
//============================================================================


struct  D_BFu15i_C  {
  double v1;
  unsigned int v2:15;
  char v3;
};
//SIG(1 D_BFu15i_C) C1{ FL Fi:15 Fc}



static void Test_D_BFu15i_C()
{
  {
    init_simple_test("D_BFu15i_C");
    static STRUCT_IF_C D_BFu15i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_C)");
    check_field_offset(lv, v1, 0, "D_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_C");
    check_field_offset(lv, v3, 10, "D_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_C, D_BFu15i_C)
//============================================================================


struct  D_BFu15i_D  {
  double v1;
  unsigned int v2:15;
  double v3;
};
//SIG(1 D_BFu15i_D) C1{ FL Fi:15 FL}



static void Test_D_BFu15i_D()
{
  {
    init_simple_test("D_BFu15i_D");
    static STRUCT_IF_C D_BFu15i_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_D)");
    check_field_offset(lv, v1, 0, "D_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_D, D_BFu15i_D)
//============================================================================


struct  D_BFu15i_F  {
  double v1;
  unsigned int v2:15;
  float v3;
};
//SIG(1 D_BFu15i_F) C1{ FL Fi:15 Fi}



static void Test_D_BFu15i_F()
{
  {
    init_simple_test("D_BFu15i_F");
    static STRUCT_IF_C D_BFu15i_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_F)");
    check_field_offset(lv, v1, 0, "D_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_F");
    check_field_offset(lv, v3, 12, "D_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_F, D_BFu15i_F)
//============================================================================


struct  D_BFu15i_I  {
  double v1;
  unsigned int v2:15;
  int v3;
};
//SIG(1 D_BFu15i_I) C1{ FL Fi:15 Fi}



static void Test_D_BFu15i_I()
{
  {
    init_simple_test("D_BFu15i_I");
    static STRUCT_IF_C D_BFu15i_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_I)");
    check_field_offset(lv, v1, 0, "D_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_I");
    check_field_offset(lv, v3, 12, "D_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_I, D_BFu15i_I)
//============================================================================


struct  D_BFu15i_Ip  {
  double v1;
  unsigned int v2:15;
  int *v3;
};
//SIG(1 D_BFu15i_Ip) C1{ FL Fi:15 Fp}



static void Test_D_BFu15i_Ip()
{
  {
    init_simple_test("D_BFu15i_Ip");
    static STRUCT_IF_C D_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_Ip, D_BFu15i_Ip)
//============================================================================


struct  D_BFu15i_L  {
  double v1;
  unsigned int v2:15;
  __tsi64 v3;
};
//SIG(1 D_BFu15i_L) C1{ FL Fi:15 FL}



static void Test_D_BFu15i_L()
{
  {
    init_simple_test("D_BFu15i_L");
    static STRUCT_IF_C D_BFu15i_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_L)");
    check_field_offset(lv, v1, 0, "D_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_L, D_BFu15i_L)
//============================================================================


struct  D_BFu15i_S  {
  double v1;
  unsigned int v2:15;
  short v3;
};
//SIG(1 D_BFu15i_S) C1{ FL Fi:15 Fs}



static void Test_D_BFu15i_S()
{
  {
    init_simple_test("D_BFu15i_S");
    static STRUCT_IF_C D_BFu15i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_S)");
    check_field_offset(lv, v1, 0, "D_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_S");
    check_field_offset(lv, v3, 10, "D_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_S, D_BFu15i_S)
//============================================================================


struct  D_BFu15i_Uc  {
  double v1;
  unsigned int v2:15;
  unsigned char v3;
};
//SIG(1 D_BFu15i_Uc) C1{ FL Fi:15 Fc}



static void Test_D_BFu15i_Uc()
{
  {
    init_simple_test("D_BFu15i_Uc");
    static STRUCT_IF_C D_BFu15i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_Uc");
    check_field_offset(lv, v3, 10, "D_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_Uc, D_BFu15i_Uc)
//============================================================================


struct  D_BFu15i_Ui  {
  double v1;
  unsigned int v2:15;
  unsigned int v3;
};
//SIG(1 D_BFu15i_Ui) C1{ FL Fi:15 Fi}



static void Test_D_BFu15i_Ui()
{
  {
    init_simple_test("D_BFu15i_Ui");
    static STRUCT_IF_C D_BFu15i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_Ui");
    check_field_offset(lv, v3, 12, "D_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_Ui, D_BFu15i_Ui)
//============================================================================


struct  D_BFu15i_Ul  {
  double v1;
  unsigned int v2:15;
  __tsu64 v3;
};
//SIG(1 D_BFu15i_Ul) C1{ FL Fi:15 FL}



static void Test_D_BFu15i_Ul()
{
  {
    init_simple_test("D_BFu15i_Ul");
    static STRUCT_IF_C D_BFu15i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_Ul, D_BFu15i_Ul)
//============================================================================


struct  D_BFu15i_Us  {
  double v1;
  unsigned int v2:15;
  unsigned short v3;
};
//SIG(1 D_BFu15i_Us) C1{ FL Fi:15 Fs}



static void Test_D_BFu15i_Us()
{
  {
    init_simple_test("D_BFu15i_Us");
    static STRUCT_IF_C D_BFu15i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "D_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_Us");
    check_field_offset(lv, v3, 10, "D_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_Us, D_BFu15i_Us)
//============================================================================


struct  D_BFu15i_Vp  {
  double v1;
  unsigned int v2:15;
  void *v3;
};
//SIG(1 D_BFu15i_Vp) C1{ FL Fi:15 Fp}



static void Test_D_BFu15i_Vp()
{
  {
    init_simple_test("D_BFu15i_Vp");
    static STRUCT_IF_C D_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15i_Vp, D_BFu15i_Vp)
//============================================================================


struct  D_BFu15ll  {
  double v1;
  __tsu64 v2:15;
};
//SIG(1 D_BFu15ll) C1{ FL FL:15}



static void Test_D_BFu15ll()
{
  {
    init_simple_test("D_BFu15ll");
    static STRUCT_IF_C D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll, D_BFu15ll)
//============================================================================


struct  D_BFu15ll_BFu15i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 D_BFu15ll_BFu15i) C1{ FL FL:15 Fi:15}



static void Test_D_BFu15ll_BFu15i()
{
  {
    init_simple_test("D_BFu15ll_BFu15i");
    static STRUCT_IF_C D_BFu15ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "D_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu15i, D_BFu15ll_BFu15i)
//============================================================================


struct  D_BFu15ll_BFu15ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 D_BFu15ll_BFu15ll) C1{ FL FL:15 FL:15}



static void Test_D_BFu15ll_BFu15ll()
{
  {
    init_simple_test("D_BFu15ll_BFu15ll");
    static STRUCT_IF_C D_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "D_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu15ll, D_BFu15ll_BFu15ll)
//============================================================================


struct  D_BFu15ll_BFu15s  {
  double v1;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 D_BFu15ll_BFu15s) C1{ FL FL:15 Fs:15}



static void Test_D_BFu15ll_BFu15s()
{
  {
    init_simple_test("D_BFu15ll_BFu15s");
    static STRUCT_IF_C D_BFu15ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu15s, D_BFu15ll_BFu15s)
//============================================================================


struct  D_BFu15ll_BFu16i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 D_BFu15ll_BFu16i) C1{ FL FL:15 Fi:16}



static void Test_D_BFu15ll_BFu16i()
{
  {
    init_simple_test("D_BFu15ll_BFu16i");
    static STRUCT_IF_C D_BFu15ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "D_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "D_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu16i, D_BFu15ll_BFu16i)
//============================================================================


struct  D_BFu15ll_BFu16ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 D_BFu15ll_BFu16ll) C1{ FL FL:15 FL:16}



static void Test_D_BFu15ll_BFu16ll()
{
  {
    init_simple_test("D_BFu15ll_BFu16ll");
    static STRUCT_IF_C D_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "D_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "D_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu16ll, D_BFu15ll_BFu16ll)
//============================================================================


struct  D_BFu15ll_BFu16s  {
  double v1;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 D_BFu15ll_BFu16s) C1{ FL FL:15 Fs:16}



static void Test_D_BFu15ll_BFu16s()
{
  {
    init_simple_test("D_BFu15ll_BFu16s");
    static STRUCT_IF_C D_BFu15ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu16s, D_BFu15ll_BFu16s)
//============================================================================


struct  D_BFu15ll_BFu17i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 D_BFu15ll_BFu17i) C1{ FL FL:15 Fi:17}



static void Test_D_BFu15ll_BFu17i()
{
  {
    init_simple_test("D_BFu15ll_BFu17i");
    static STRUCT_IF_C D_BFu15ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "D_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "D_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu17i, D_BFu15ll_BFu17i)
//============================================================================


struct  D_BFu15ll_BFu17ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 D_BFu15ll_BFu17ll) C1{ FL FL:15 FL:17}



static void Test_D_BFu15ll_BFu17ll()
{
  {
    init_simple_test("D_BFu15ll_BFu17ll");
    static STRUCT_IF_C D_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "D_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "D_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu17ll, D_BFu15ll_BFu17ll)
//============================================================================


struct  D_BFu15ll_BFu1c  {
  double v1;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 D_BFu15ll_BFu1c) C1{ FL FL:15 Fc:1}



static void Test_D_BFu15ll_BFu1c()
{
  {
    init_simple_test("D_BFu15ll_BFu1c");
    static STRUCT_IF_C D_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu1c, D_BFu15ll_BFu1c)
//============================================================================


struct  D_BFu15ll_BFu1i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 D_BFu15ll_BFu1i) C1{ FL FL:15 Fi:1}



static void Test_D_BFu15ll_BFu1i()
{
  {
    init_simple_test("D_BFu15ll_BFu1i");
    static STRUCT_IF_C D_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu1i, D_BFu15ll_BFu1i)
//============================================================================


struct  D_BFu15ll_BFu1ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 D_BFu15ll_BFu1ll) C1{ FL FL:15 FL:1}



static void Test_D_BFu15ll_BFu1ll()
{
  {
    init_simple_test("D_BFu15ll_BFu1ll");
    static STRUCT_IF_C D_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu1ll, D_BFu15ll_BFu1ll)
//============================================================================


struct  D_BFu15ll_BFu1s  {
  double v1;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 D_BFu15ll_BFu1s) C1{ FL FL:15 Fs:1}



static void Test_D_BFu15ll_BFu1s()
{
  {
    init_simple_test("D_BFu15ll_BFu1s");
    static STRUCT_IF_C D_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu1s, D_BFu15ll_BFu1s)
//============================================================================


struct  D_BFu15ll_BFu31i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 D_BFu15ll_BFu31i) C1{ FL FL:15 Fi:31}



static void Test_D_BFu15ll_BFu31i()
{
  {
    init_simple_test("D_BFu15ll_BFu31i");
    static STRUCT_IF_C D_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu31i, D_BFu15ll_BFu31i)
//============================================================================


struct  D_BFu15ll_BFu31ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 D_BFu15ll_BFu31ll) C1{ FL FL:15 FL:31}



static void Test_D_BFu15ll_BFu31ll()
{
  {
    init_simple_test("D_BFu15ll_BFu31ll");
    static STRUCT_IF_C D_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "D_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "D_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu31ll, D_BFu15ll_BFu31ll)
//============================================================================


struct  D_BFu15ll_BFu32i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 D_BFu15ll_BFu32i) C1{ FL FL:15 Fi:32}



static void Test_D_BFu15ll_BFu32i()
{
  {
    init_simple_test("D_BFu15ll_BFu32i");
    static STRUCT_IF_C D_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu32i, D_BFu15ll_BFu32i)
//============================================================================


struct  D_BFu15ll_BFu32ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 D_BFu15ll_BFu32ll) C1{ FL FL:15 FL:32}



static void Test_D_BFu15ll_BFu32ll()
{
  {
    init_simple_test("D_BFu15ll_BFu32ll");
    static STRUCT_IF_C D_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "D_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "D_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu32ll, D_BFu15ll_BFu32ll)
//============================================================================


struct  D_BFu15ll_BFu33  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 D_BFu15ll_BFu33) C1{ FL FL:15 FL:33}



static void Test_D_BFu15ll_BFu33()
{
  {
    init_simple_test("D_BFu15ll_BFu33");
    static STRUCT_IF_C D_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "D_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "D_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu33, D_BFu15ll_BFu33)
//============================================================================


struct  D_BFu15ll_BFu7c  {
  double v1;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 D_BFu15ll_BFu7c) C1{ FL FL:15 Fc:7}



static void Test_D_BFu15ll_BFu7c()
{
  {
    init_simple_test("D_BFu15ll_BFu7c");
    static STRUCT_IF_C D_BFu15ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu7c, D_BFu15ll_BFu7c)
//============================================================================


struct  D_BFu15ll_BFu7i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 D_BFu15ll_BFu7i) C1{ FL FL:15 Fi:7}



static void Test_D_BFu15ll_BFu7i()
{
  {
    init_simple_test("D_BFu15ll_BFu7i");
    static STRUCT_IF_C D_BFu15ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "D_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "D_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu7i, D_BFu15ll_BFu7i)
//============================================================================


struct  D_BFu15ll_BFu7ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 D_BFu15ll_BFu7ll) C1{ FL FL:15 FL:7}



static void Test_D_BFu15ll_BFu7ll()
{
  {
    init_simple_test("D_BFu15ll_BFu7ll");
    static STRUCT_IF_C D_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "D_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "D_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu7ll, D_BFu15ll_BFu7ll)
//============================================================================


struct  D_BFu15ll_BFu7s  {
  double v1;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 D_BFu15ll_BFu7s) C1{ FL FL:15 Fs:7}



static void Test_D_BFu15ll_BFu7s()
{
  {
    init_simple_test("D_BFu15ll_BFu7s");
    static STRUCT_IF_C D_BFu15ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu7s, D_BFu15ll_BFu7s)
//============================================================================


struct  D_BFu15ll_BFu8c  {
  double v1;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 D_BFu15ll_BFu8c) C1{ FL FL:15 Fc:8}



static void Test_D_BFu15ll_BFu8c()
{
  {
    init_simple_test("D_BFu15ll_BFu8c");
    static STRUCT_IF_C D_BFu15ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu8c, D_BFu15ll_BFu8c)
//============================================================================


struct  D_BFu15ll_BFu8i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 D_BFu15ll_BFu8i) C1{ FL FL:15 Fi:8}



static void Test_D_BFu15ll_BFu8i()
{
  {
    init_simple_test("D_BFu15ll_BFu8i");
    static STRUCT_IF_C D_BFu15ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "D_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "D_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu8i, D_BFu15ll_BFu8i)
//============================================================================


struct  D_BFu15ll_BFu8ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 D_BFu15ll_BFu8ll) C1{ FL FL:15 FL:8}



static void Test_D_BFu15ll_BFu8ll()
{
  {
    init_simple_test("D_BFu15ll_BFu8ll");
    static STRUCT_IF_C D_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "D_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "D_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu8ll, D_BFu15ll_BFu8ll)
//============================================================================


struct  D_BFu15ll_BFu8s  {
  double v1;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 D_BFu15ll_BFu8s) C1{ FL FL:15 Fs:8}



static void Test_D_BFu15ll_BFu8s()
{
  {
    init_simple_test("D_BFu15ll_BFu8s");
    static STRUCT_IF_C D_BFu15ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu8s, D_BFu15ll_BFu8s)
//============================================================================


struct  D_BFu15ll_BFu9i  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 D_BFu15ll_BFu9i) C1{ FL FL:15 Fi:9}



static void Test_D_BFu15ll_BFu9i()
{
  {
    init_simple_test("D_BFu15ll_BFu9i");
    static STRUCT_IF_C D_BFu15ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "D_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "D_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu9i, D_BFu15ll_BFu9i)
//============================================================================


struct  D_BFu15ll_BFu9ll  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 D_BFu15ll_BFu9ll) C1{ FL FL:15 FL:9}



static void Test_D_BFu15ll_BFu9ll()
{
  {
    init_simple_test("D_BFu15ll_BFu9ll");
    static STRUCT_IF_C D_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "D_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "D_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu9ll, D_BFu15ll_BFu9ll)
//============================================================================


struct  D_BFu15ll_BFu9s  {
  double v1;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 D_BFu15ll_BFu9s) C1{ FL FL:15 Fs:9}



static void Test_D_BFu15ll_BFu9s()
{
  {
    init_simple_test("D_BFu15ll_BFu9s");
    static STRUCT_IF_C D_BFu15ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_BFu9s, D_BFu15ll_BFu9s)
//============================================================================


struct  D_BFu15ll_C  {
  double v1;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 D_BFu15ll_C) C1{ FL FL:15 Fc}



static void Test_D_BFu15ll_C()
{
  {
    init_simple_test("D_BFu15ll_C");
    static STRUCT_IF_C D_BFu15ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_C");
    check_field_offset(lv, v3, 10, "D_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_C, D_BFu15ll_C)
//============================================================================


struct  D_BFu15ll_D  {
  double v1;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 D_BFu15ll_D) C1{ FL FL:15 FL}



static void Test_D_BFu15ll_D()
{
  {
    init_simple_test("D_BFu15ll_D");
    static STRUCT_IF_C D_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_D, D_BFu15ll_D)
//============================================================================


struct  D_BFu15ll_F  {
  double v1;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 D_BFu15ll_F) C1{ FL FL:15 Fi}



static void Test_D_BFu15ll_F()
{
  {
    init_simple_test("D_BFu15ll_F");
    static STRUCT_IF_C D_BFu15ll_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_F");
    check_field_offset(lv, v3, 12, "D_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_F, D_BFu15ll_F)
//============================================================================


struct  D_BFu15ll_I  {
  double v1;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 D_BFu15ll_I) C1{ FL FL:15 Fi}



static void Test_D_BFu15ll_I()
{
  {
    init_simple_test("D_BFu15ll_I");
    static STRUCT_IF_C D_BFu15ll_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_I");
    check_field_offset(lv, v3, 12, "D_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_I, D_BFu15ll_I)
//============================================================================


struct  D_BFu15ll_Ip  {
  double v1;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 D_BFu15ll_Ip) C1{ FL FL:15 Fp}



static void Test_D_BFu15ll_Ip()
{
  {
    init_simple_test("D_BFu15ll_Ip");
    static STRUCT_IF_C D_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_Ip, D_BFu15ll_Ip)
//============================================================================


struct  D_BFu15ll_L  {
  double v1;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 D_BFu15ll_L) C1{ FL FL:15 FL}



static void Test_D_BFu15ll_L()
{
  {
    init_simple_test("D_BFu15ll_L");
    static STRUCT_IF_C D_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_L, D_BFu15ll_L)
//============================================================================


struct  D_BFu15ll_S  {
  double v1;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 D_BFu15ll_S) C1{ FL FL:15 Fs}



static void Test_D_BFu15ll_S()
{
  {
    init_simple_test("D_BFu15ll_S");
    static STRUCT_IF_C D_BFu15ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_S");
    check_field_offset(lv, v3, 10, "D_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_S, D_BFu15ll_S)
//============================================================================


struct  D_BFu15ll_Uc  {
  double v1;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 D_BFu15ll_Uc) C1{ FL FL:15 Fc}



static void Test_D_BFu15ll_Uc()
{
  {
    init_simple_test("D_BFu15ll_Uc");
    static STRUCT_IF_C D_BFu15ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_Uc");
    check_field_offset(lv, v3, 10, "D_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_Uc, D_BFu15ll_Uc)
//============================================================================


struct  D_BFu15ll_Ui  {
  double v1;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 D_BFu15ll_Ui) C1{ FL FL:15 Fi}



static void Test_D_BFu15ll_Ui()
{
  {
    init_simple_test("D_BFu15ll_Ui");
    static STRUCT_IF_C D_BFu15ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_Ui");
    check_field_offset(lv, v3, 12, "D_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_Ui, D_BFu15ll_Ui)
//============================================================================


struct  D_BFu15ll_Ul  {
  double v1;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 D_BFu15ll_Ul) C1{ FL FL:15 FL}



static void Test_D_BFu15ll_Ul()
{
  {
    init_simple_test("D_BFu15ll_Ul");
    static STRUCT_IF_C D_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_Ul, D_BFu15ll_Ul)
//============================================================================


struct  D_BFu15ll_Us  {
  double v1;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 D_BFu15ll_Us) C1{ FL FL:15 Fs}



static void Test_D_BFu15ll_Us()
{
  {
    init_simple_test("D_BFu15ll_Us");
    static STRUCT_IF_C D_BFu15ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_Us");
    check_field_offset(lv, v3, 10, "D_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_Us, D_BFu15ll_Us)
//============================================================================


struct  D_BFu15ll_Vp  {
  double v1;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 D_BFu15ll_Vp) C1{ FL FL:15 Fp}



static void Test_D_BFu15ll_Vp()
{
  {
    init_simple_test("D_BFu15ll_Vp");
    static STRUCT_IF_C D_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15ll_Vp, D_BFu15ll_Vp)
//============================================================================


struct  D_BFu15s  {
  double v1;
  unsigned short v2:15;
};
//SIG(1 D_BFu15s) C1{ FL Fs:15}



static void Test_D_BFu15s()
{
  {
    init_simple_test("D_BFu15s");
    static STRUCT_IF_C D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s, D_BFu15s)
//============================================================================


struct  D_BFu15s_BFu15i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 D_BFu15s_BFu15i) C1{ FL Fs:15 Fi:15}



static void Test_D_BFu15s_BFu15i()
{
  {
    init_simple_test("D_BFu15s_BFu15i");
    static STRUCT_IF_C D_BFu15s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "D_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "D_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu15i, D_BFu15s_BFu15i)
//============================================================================


struct  D_BFu15s_BFu15ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 D_BFu15s_BFu15ll) C1{ FL Fs:15 FL:15}



static void Test_D_BFu15s_BFu15ll()
{
  {
    init_simple_test("D_BFu15s_BFu15ll");
    static STRUCT_IF_C D_BFu15s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "D_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "D_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu15ll, D_BFu15s_BFu15ll)
//============================================================================


struct  D_BFu15s_BFu15s  {
  double v1;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 D_BFu15s_BFu15s) C1{ FL Fs:15 Fs:15}



static void Test_D_BFu15s_BFu15s()
{
  {
    init_simple_test("D_BFu15s_BFu15s");
    static STRUCT_IF_C D_BFu15s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu15s, D_BFu15s_BFu15s)
//============================================================================


struct  D_BFu15s_BFu16i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 D_BFu15s_BFu16i) C1{ FL Fs:15 Fi:16}



static void Test_D_BFu15s_BFu16i()
{
  {
    init_simple_test("D_BFu15s_BFu16i");
    static STRUCT_IF_C D_BFu15s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "D_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "D_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu16i, D_BFu15s_BFu16i)
//============================================================================


struct  D_BFu15s_BFu16ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 D_BFu15s_BFu16ll) C1{ FL Fs:15 FL:16}



static void Test_D_BFu15s_BFu16ll()
{
  {
    init_simple_test("D_BFu15s_BFu16ll");
    static STRUCT_IF_C D_BFu15s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "D_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "D_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu16ll, D_BFu15s_BFu16ll)
//============================================================================


struct  D_BFu15s_BFu16s  {
  double v1;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 D_BFu15s_BFu16s) C1{ FL Fs:15 Fs:16}



static void Test_D_BFu15s_BFu16s()
{
  {
    init_simple_test("D_BFu15s_BFu16s");
    static STRUCT_IF_C D_BFu15s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu16s, D_BFu15s_BFu16s)
//============================================================================


struct  D_BFu15s_BFu17i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 D_BFu15s_BFu17i) C1{ FL Fs:15 Fi:17}



static void Test_D_BFu15s_BFu17i()
{
  {
    init_simple_test("D_BFu15s_BFu17i");
    static STRUCT_IF_C D_BFu15s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "D_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "D_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu17i, D_BFu15s_BFu17i)
//============================================================================


struct  D_BFu15s_BFu17ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 D_BFu15s_BFu17ll) C1{ FL Fs:15 FL:17}



static void Test_D_BFu15s_BFu17ll()
{
  {
    init_simple_test("D_BFu15s_BFu17ll");
    static STRUCT_IF_C D_BFu15s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "D_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "D_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu17ll, D_BFu15s_BFu17ll)
//============================================================================


struct  D_BFu15s_BFu1c  {
  double v1;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 D_BFu15s_BFu1c) C1{ FL Fs:15 Fc:1}



static void Test_D_BFu15s_BFu1c()
{
  {
    init_simple_test("D_BFu15s_BFu1c");
    static STRUCT_IF_C D_BFu15s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu1c, D_BFu15s_BFu1c)
//============================================================================


struct  D_BFu15s_BFu1i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 D_BFu15s_BFu1i) C1{ FL Fs:15 Fi:1}



static void Test_D_BFu15s_BFu1i()
{
  {
    init_simple_test("D_BFu15s_BFu1i");
    static STRUCT_IF_C D_BFu15s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu1i, D_BFu15s_BFu1i)
//============================================================================


struct  D_BFu15s_BFu1ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 D_BFu15s_BFu1ll) C1{ FL Fs:15 FL:1}



static void Test_D_BFu15s_BFu1ll()
{
  {
    init_simple_test("D_BFu15s_BFu1ll");
    static STRUCT_IF_C D_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu1ll, D_BFu15s_BFu1ll)
//============================================================================


struct  D_BFu15s_BFu1s  {
  double v1;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 D_BFu15s_BFu1s) C1{ FL Fs:15 Fs:1}



static void Test_D_BFu15s_BFu1s()
{
  {
    init_simple_test("D_BFu15s_BFu1s");
    static STRUCT_IF_C D_BFu15s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "D_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu1s, D_BFu15s_BFu1s)
//============================================================================


struct  D_BFu15s_BFu31i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 D_BFu15s_BFu31i) C1{ FL Fs:15 Fi:31}



static void Test_D_BFu15s_BFu31i()
{
  {
    init_simple_test("D_BFu15s_BFu31i");
    static STRUCT_IF_C D_BFu15s_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu31i, D_BFu15s_BFu31i)
//============================================================================


struct  D_BFu15s_BFu31ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:31;
};
//SIG(1 D_BFu15s_BFu31ll) C1{ FL Fs:15 FL:31}



static void Test_D_BFu15s_BFu31ll()
{
  {
    init_simple_test("D_BFu15s_BFu31ll");
    static STRUCT_IF_C D_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "D_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "D_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu31ll, D_BFu15s_BFu31ll)
//============================================================================


struct  D_BFu15s_BFu32i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:32;
};
//SIG(1 D_BFu15s_BFu32i) C1{ FL Fs:15 Fi:32}



static void Test_D_BFu15s_BFu32i()
{
  {
    init_simple_test("D_BFu15s_BFu32i");
    static STRUCT_IF_C D_BFu15s_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu32i, D_BFu15s_BFu32i)
//============================================================================


struct  D_BFu15s_BFu32ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:32;
};
//SIG(1 D_BFu15s_BFu32ll) C1{ FL Fs:15 FL:32}



static void Test_D_BFu15s_BFu32ll()
{
  {
    init_simple_test("D_BFu15s_BFu32ll");
    static STRUCT_IF_C D_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "D_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "D_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu32ll, D_BFu15s_BFu32ll)
//============================================================================


struct  D_BFu15s_BFu33  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:33;
};
//SIG(1 D_BFu15s_BFu33) C1{ FL Fs:15 FL:33}



static void Test_D_BFu15s_BFu33()
{
  {
    init_simple_test("D_BFu15s_BFu33");
    static STRUCT_IF_C D_BFu15s_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "D_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "D_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu33, D_BFu15s_BFu33)
//============================================================================


struct  D_BFu15s_BFu7c  {
  double v1;
  unsigned short v2:15;
  unsigned char v3:7;
};
//SIG(1 D_BFu15s_BFu7c) C1{ FL Fs:15 Fc:7}



static void Test_D_BFu15s_BFu7c()
{
  {
    init_simple_test("D_BFu15s_BFu7c");
    static STRUCT_IF_C D_BFu15s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu7c, D_BFu15s_BFu7c)
//============================================================================


struct  D_BFu15s_BFu7i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:7;
};
//SIG(1 D_BFu15s_BFu7i) C1{ FL Fs:15 Fi:7}



static void Test_D_BFu15s_BFu7i()
{
  {
    init_simple_test("D_BFu15s_BFu7i");
    static STRUCT_IF_C D_BFu15s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "D_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "D_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu7i, D_BFu15s_BFu7i)
//============================================================================


struct  D_BFu15s_BFu7ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:7;
};
//SIG(1 D_BFu15s_BFu7ll) C1{ FL Fs:15 FL:7}



static void Test_D_BFu15s_BFu7ll()
{
  {
    init_simple_test("D_BFu15s_BFu7ll");
    static STRUCT_IF_C D_BFu15s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "D_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "D_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu7ll, D_BFu15s_BFu7ll)
//============================================================================


struct  D_BFu15s_BFu7s  {
  double v1;
  unsigned short v2:15;
  unsigned short v3:7;
};
//SIG(1 D_BFu15s_BFu7s) C1{ FL Fs:15 Fs:7}



static void Test_D_BFu15s_BFu7s()
{
  {
    init_simple_test("D_BFu15s_BFu7s");
    static STRUCT_IF_C D_BFu15s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu7s, D_BFu15s_BFu7s)
//============================================================================


struct  D_BFu15s_BFu8c  {
  double v1;
  unsigned short v2:15;
  unsigned char v3:8;
};
//SIG(1 D_BFu15s_BFu8c) C1{ FL Fs:15 Fc:8}



static void Test_D_BFu15s_BFu8c()
{
  {
    init_simple_test("D_BFu15s_BFu8c");
    static STRUCT_IF_C D_BFu15s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu8c, D_BFu15s_BFu8c)
//============================================================================


struct  D_BFu15s_BFu8i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:8;
};
//SIG(1 D_BFu15s_BFu8i) C1{ FL Fs:15 Fi:8}



static void Test_D_BFu15s_BFu8i()
{
  {
    init_simple_test("D_BFu15s_BFu8i");
    static STRUCT_IF_C D_BFu15s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "D_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "D_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu8i, D_BFu15s_BFu8i)
//============================================================================


struct  D_BFu15s_BFu8ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:8;
};
//SIG(1 D_BFu15s_BFu8ll) C1{ FL Fs:15 FL:8}



static void Test_D_BFu15s_BFu8ll()
{
  {
    init_simple_test("D_BFu15s_BFu8ll");
    static STRUCT_IF_C D_BFu15s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "D_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "D_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu8ll, D_BFu15s_BFu8ll)
//============================================================================


struct  D_BFu15s_BFu8s  {
  double v1;
  unsigned short v2:15;
  unsigned short v3:8;
};
//SIG(1 D_BFu15s_BFu8s) C1{ FL Fs:15 Fs:8}



static void Test_D_BFu15s_BFu8s()
{
  {
    init_simple_test("D_BFu15s_BFu8s");
    static STRUCT_IF_C D_BFu15s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu8s, D_BFu15s_BFu8s)
//============================================================================


struct  D_BFu15s_BFu9i  {
  double v1;
  unsigned short v2:15;
  unsigned int v3:9;
};
//SIG(1 D_BFu15s_BFu9i) C1{ FL Fs:15 Fi:9}



static void Test_D_BFu15s_BFu9i()
{
  {
    init_simple_test("D_BFu15s_BFu9i");
    static STRUCT_IF_C D_BFu15s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "D_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "D_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu9i, D_BFu15s_BFu9i)
//============================================================================


struct  D_BFu15s_BFu9ll  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3:9;
};
//SIG(1 D_BFu15s_BFu9ll) C1{ FL Fs:15 FL:9}



static void Test_D_BFu15s_BFu9ll()
{
  {
    init_simple_test("D_BFu15s_BFu9ll");
    static STRUCT_IF_C D_BFu15s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "D_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "D_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu9ll, D_BFu15s_BFu9ll)
//============================================================================


struct  D_BFu15s_BFu9s  {
  double v1;
  unsigned short v2:15;
  unsigned short v3:9;
};
//SIG(1 D_BFu15s_BFu9s) C1{ FL Fs:15 Fs:9}



static void Test_D_BFu15s_BFu9s()
{
  {
    init_simple_test("D_BFu15s_BFu9s");
    static STRUCT_IF_C D_BFu15s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_BFu9s, D_BFu15s_BFu9s)
//============================================================================


struct  D_BFu15s_C  {
  double v1;
  unsigned short v2:15;
  char v3;
};
//SIG(1 D_BFu15s_C) C1{ FL Fs:15 Fc}



static void Test_D_BFu15s_C()
{
  {
    init_simple_test("D_BFu15s_C");
    static STRUCT_IF_C D_BFu15s_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_C)");
    check_field_offset(lv, v1, 0, "D_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_C");
    check_field_offset(lv, v3, 10, "D_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_C, D_BFu15s_C)
//============================================================================


struct  D_BFu15s_D  {
  double v1;
  unsigned short v2:15;
  double v3;
};
//SIG(1 D_BFu15s_D) C1{ FL Fs:15 FL}



static void Test_D_BFu15s_D()
{
  {
    init_simple_test("D_BFu15s_D");
    static STRUCT_IF_C D_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_D)");
    check_field_offset(lv, v1, 0, "D_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_D, D_BFu15s_D)
//============================================================================


struct  D_BFu15s_F  {
  double v1;
  unsigned short v2:15;
  float v3;
};
//SIG(1 D_BFu15s_F) C1{ FL Fs:15 Fi}



static void Test_D_BFu15s_F()
{
  {
    init_simple_test("D_BFu15s_F");
    static STRUCT_IF_C D_BFu15s_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_F)");
    check_field_offset(lv, v1, 0, "D_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_F");
    check_field_offset(lv, v3, 12, "D_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_F, D_BFu15s_F)
//============================================================================


struct  D_BFu15s_I  {
  double v1;
  unsigned short v2:15;
  int v3;
};
//SIG(1 D_BFu15s_I) C1{ FL Fs:15 Fi}



static void Test_D_BFu15s_I()
{
  {
    init_simple_test("D_BFu15s_I");
    static STRUCT_IF_C D_BFu15s_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_I)");
    check_field_offset(lv, v1, 0, "D_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_I");
    check_field_offset(lv, v3, 12, "D_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_I, D_BFu15s_I)
//============================================================================


struct  D_BFu15s_Ip  {
  double v1;
  unsigned short v2:15;
  int *v3;
};
//SIG(1 D_BFu15s_Ip) C1{ FL Fs:15 Fp}



static void Test_D_BFu15s_Ip()
{
  {
    init_simple_test("D_BFu15s_Ip");
    static STRUCT_IF_C D_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_Ip, D_BFu15s_Ip)
//============================================================================


struct  D_BFu15s_L  {
  double v1;
  unsigned short v2:15;
  __tsi64 v3;
};
//SIG(1 D_BFu15s_L) C1{ FL Fs:15 FL}



static void Test_D_BFu15s_L()
{
  {
    init_simple_test("D_BFu15s_L");
    static STRUCT_IF_C D_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_L)");
    check_field_offset(lv, v1, 0, "D_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_L, D_BFu15s_L)
//============================================================================


struct  D_BFu15s_S  {
  double v1;
  unsigned short v2:15;
  short v3;
};
//SIG(1 D_BFu15s_S) C1{ FL Fs:15 Fs}



static void Test_D_BFu15s_S()
{
  {
    init_simple_test("D_BFu15s_S");
    static STRUCT_IF_C D_BFu15s_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_S)");
    check_field_offset(lv, v1, 0, "D_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_S");
    check_field_offset(lv, v3, 10, "D_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_S, D_BFu15s_S)
//============================================================================


struct  D_BFu15s_Uc  {
  double v1;
  unsigned short v2:15;
  unsigned char v3;
};
//SIG(1 D_BFu15s_Uc) C1{ FL Fs:15 Fc}



static void Test_D_BFu15s_Uc()
{
  {
    init_simple_test("D_BFu15s_Uc");
    static STRUCT_IF_C D_BFu15s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_Uc");
    check_field_offset(lv, v3, 10, "D_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_Uc, D_BFu15s_Uc)
//============================================================================


struct  D_BFu15s_Ui  {
  double v1;
  unsigned short v2:15;
  unsigned int v3;
};
//SIG(1 D_BFu15s_Ui) C1{ FL Fs:15 Fi}



static void Test_D_BFu15s_Ui()
{
  {
    init_simple_test("D_BFu15s_Ui");
    static STRUCT_IF_C D_BFu15s_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu15s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_Ui");
    check_field_offset(lv, v3, 12, "D_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_Ui, D_BFu15s_Ui)
//============================================================================


struct  D_BFu15s_Ul  {
  double v1;
  unsigned short v2:15;
  __tsu64 v3;
};
//SIG(1 D_BFu15s_Ul) C1{ FL Fs:15 FL}



static void Test_D_BFu15s_Ul()
{
  {
    init_simple_test("D_BFu15s_Ul");
    static STRUCT_IF_C D_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_Ul, D_BFu15s_Ul)
//============================================================================


struct  D_BFu15s_Us  {
  double v1;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 D_BFu15s_Us) C1{ FL Fs:15 Fs}



static void Test_D_BFu15s_Us()
{
  {
    init_simple_test("D_BFu15s_Us");
    static STRUCT_IF_C D_BFu15s_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "D_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_Us");
    check_field_offset(lv, v3, 10, "D_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_Us, D_BFu15s_Us)
//============================================================================


struct  D_BFu15s_Vp  {
  double v1;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 D_BFu15s_Vp) C1{ FL Fs:15 Fp}



static void Test_D_BFu15s_Vp()
{
  {
    init_simple_test("D_BFu15s_Vp");
    static STRUCT_IF_C D_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu15s_Vp, D_BFu15s_Vp)
//============================================================================


struct  D_BFu16i  {
  double v1;
  unsigned int v2:16;
};
//SIG(1 D_BFu16i) C1{ FL Fi:16}



static void Test_D_BFu16i()
{
  {
    init_simple_test("D_BFu16i");
    static STRUCT_IF_C D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i, D_BFu16i)
//============================================================================


struct  D_BFu16i_BFu15i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 D_BFu16i_BFu15i) C1{ FL Fi:16 Fi:15}



static void Test_D_BFu16i_BFu15i()
{
  {
    init_simple_test("D_BFu16i_BFu15i");
    static STRUCT_IF_C D_BFu16i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu15i, D_BFu16i_BFu15i)
//============================================================================


struct  D_BFu16i_BFu15ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 D_BFu16i_BFu15ll) C1{ FL Fi:16 FL:15}



static void Test_D_BFu16i_BFu15ll()
{
  {
    init_simple_test("D_BFu16i_BFu15ll");
    static STRUCT_IF_C D_BFu16i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu15ll, D_BFu16i_BFu15ll)
//============================================================================


struct  D_BFu16i_BFu15s  {
  double v1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 D_BFu16i_BFu15s) C1{ FL Fi:16 Fs:15}



static void Test_D_BFu16i_BFu15s()
{
  {
    init_simple_test("D_BFu16i_BFu15s");
    static STRUCT_IF_C D_BFu16i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu15s, D_BFu16i_BFu15s)
//============================================================================


struct  D_BFu16i_BFu16i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 D_BFu16i_BFu16i) C1{ FL Fi:16 Fi:16}



static void Test_D_BFu16i_BFu16i()
{
  {
    init_simple_test("D_BFu16i_BFu16i");
    static STRUCT_IF_C D_BFu16i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu16i, D_BFu16i_BFu16i)
//============================================================================


struct  D_BFu16i_BFu16ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 D_BFu16i_BFu16ll) C1{ FL Fi:16 FL:16}



static void Test_D_BFu16i_BFu16ll()
{
  {
    init_simple_test("D_BFu16i_BFu16ll");
    static STRUCT_IF_C D_BFu16i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu16ll, D_BFu16i_BFu16ll)
//============================================================================


struct  D_BFu16i_BFu16s  {
  double v1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 D_BFu16i_BFu16s) C1{ FL Fi:16 Fs:16}



static void Test_D_BFu16i_BFu16s()
{
  {
    init_simple_test("D_BFu16i_BFu16s");
    static STRUCT_IF_C D_BFu16i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu16s, D_BFu16i_BFu16s)
//============================================================================


struct  D_BFu16i_BFu17i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 D_BFu16i_BFu17i) C1{ FL Fi:16 Fi:17}



static void Test_D_BFu16i_BFu17i()
{
  {
    init_simple_test("D_BFu16i_BFu17i");
    static STRUCT_IF_C D_BFu16i_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu17i, D_BFu16i_BFu17i)
//============================================================================


struct  D_BFu16i_BFu17ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 D_BFu16i_BFu17ll) C1{ FL Fi:16 FL:17}



static void Test_D_BFu16i_BFu17ll()
{
  {
    init_simple_test("D_BFu16i_BFu17ll");
    static STRUCT_IF_C D_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "D_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "D_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu17ll, D_BFu16i_BFu17ll)
//============================================================================


struct  D_BFu16i_BFu1c  {
  double v1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 D_BFu16i_BFu1c) C1{ FL Fi:16 Fc:1}



static void Test_D_BFu16i_BFu1c()
{
  {
    init_simple_test("D_BFu16i_BFu1c");
    static STRUCT_IF_C D_BFu16i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu1c, D_BFu16i_BFu1c)
//============================================================================


struct  D_BFu16i_BFu1i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 D_BFu16i_BFu1i) C1{ FL Fi:16 Fi:1}



static void Test_D_BFu16i_BFu1i()
{
  {
    init_simple_test("D_BFu16i_BFu1i");
    static STRUCT_IF_C D_BFu16i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu1i, D_BFu16i_BFu1i)
//============================================================================


struct  D_BFu16i_BFu1ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 D_BFu16i_BFu1ll) C1{ FL Fi:16 FL:1}



static void Test_D_BFu16i_BFu1ll()
{
  {
    init_simple_test("D_BFu16i_BFu1ll");
    static STRUCT_IF_C D_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu1ll, D_BFu16i_BFu1ll)
//============================================================================


struct  D_BFu16i_BFu1s  {
  double v1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 D_BFu16i_BFu1s) C1{ FL Fi:16 Fs:1}



static void Test_D_BFu16i_BFu1s()
{
  {
    init_simple_test("D_BFu16i_BFu1s");
    static STRUCT_IF_C D_BFu16i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu1s, D_BFu16i_BFu1s)
//============================================================================


struct  D_BFu16i_BFu31i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 D_BFu16i_BFu31i) C1{ FL Fi:16 Fi:31}



static void Test_D_BFu16i_BFu31i()
{
  {
    init_simple_test("D_BFu16i_BFu31i");
    static STRUCT_IF_C D_BFu16i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu31i, D_BFu16i_BFu31i)
//============================================================================


struct  D_BFu16i_BFu31ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 D_BFu16i_BFu31ll) C1{ FL Fi:16 FL:31}



static void Test_D_BFu16i_BFu31ll()
{
  {
    init_simple_test("D_BFu16i_BFu31ll");
    static STRUCT_IF_C D_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "D_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "D_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu31ll, D_BFu16i_BFu31ll)
//============================================================================


struct  D_BFu16i_BFu32i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 D_BFu16i_BFu32i) C1{ FL Fi:16 Fi:32}



static void Test_D_BFu16i_BFu32i()
{
  {
    init_simple_test("D_BFu16i_BFu32i");
    static STRUCT_IF_C D_BFu16i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu32i, D_BFu16i_BFu32i)
//============================================================================


struct  D_BFu16i_BFu32ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 D_BFu16i_BFu32ll) C1{ FL Fi:16 FL:32}



static void Test_D_BFu16i_BFu32ll()
{
  {
    init_simple_test("D_BFu16i_BFu32ll");
    static STRUCT_IF_C D_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "D_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "D_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu32ll, D_BFu16i_BFu32ll)
//============================================================================


struct  D_BFu16i_BFu33  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 D_BFu16i_BFu33) C1{ FL Fi:16 FL:33}



static void Test_D_BFu16i_BFu33()
{
  {
    init_simple_test("D_BFu16i_BFu33");
    static STRUCT_IF_C D_BFu16i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "D_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "D_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu33, D_BFu16i_BFu33)
//============================================================================


struct  D_BFu16i_BFu7c  {
  double v1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 D_BFu16i_BFu7c) C1{ FL Fi:16 Fc:7}



static void Test_D_BFu16i_BFu7c()
{
  {
    init_simple_test("D_BFu16i_BFu7c");
    static STRUCT_IF_C D_BFu16i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu7c, D_BFu16i_BFu7c)
//============================================================================


struct  D_BFu16i_BFu7i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 D_BFu16i_BFu7i) C1{ FL Fi:16 Fi:7}



static void Test_D_BFu16i_BFu7i()
{
  {
    init_simple_test("D_BFu16i_BFu7i");
    static STRUCT_IF_C D_BFu16i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu7i, D_BFu16i_BFu7i)
//============================================================================


struct  D_BFu16i_BFu7ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 D_BFu16i_BFu7ll) C1{ FL Fi:16 FL:7}



static void Test_D_BFu16i_BFu7ll()
{
  {
    init_simple_test("D_BFu16i_BFu7ll");
    static STRUCT_IF_C D_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu7ll, D_BFu16i_BFu7ll)
//============================================================================


struct  D_BFu16i_BFu7s  {
  double v1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 D_BFu16i_BFu7s) C1{ FL Fi:16 Fs:7}



static void Test_D_BFu16i_BFu7s()
{
  {
    init_simple_test("D_BFu16i_BFu7s");
    static STRUCT_IF_C D_BFu16i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu7s, D_BFu16i_BFu7s)
//============================================================================


struct  D_BFu16i_BFu8c  {
  double v1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 D_BFu16i_BFu8c) C1{ FL Fi:16 Fc:8}



static void Test_D_BFu16i_BFu8c()
{
  {
    init_simple_test("D_BFu16i_BFu8c");
    static STRUCT_IF_C D_BFu16i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu8c, D_BFu16i_BFu8c)
//============================================================================


struct  D_BFu16i_BFu8i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 D_BFu16i_BFu8i) C1{ FL Fi:16 Fi:8}



static void Test_D_BFu16i_BFu8i()
{
  {
    init_simple_test("D_BFu16i_BFu8i");
    static STRUCT_IF_C D_BFu16i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu8i, D_BFu16i_BFu8i)
//============================================================================


struct  D_BFu16i_BFu8ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 D_BFu16i_BFu8ll) C1{ FL Fi:16 FL:8}



static void Test_D_BFu16i_BFu8ll()
{
  {
    init_simple_test("D_BFu16i_BFu8ll");
    static STRUCT_IF_C D_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu8ll, D_BFu16i_BFu8ll)
//============================================================================


struct  D_BFu16i_BFu8s  {
  double v1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 D_BFu16i_BFu8s) C1{ FL Fi:16 Fs:8}



static void Test_D_BFu16i_BFu8s()
{
  {
    init_simple_test("D_BFu16i_BFu8s");
    static STRUCT_IF_C D_BFu16i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu8s, D_BFu16i_BFu8s)
//============================================================================


struct  D_BFu16i_BFu9i  {
  double v1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 D_BFu16i_BFu9i) C1{ FL Fi:16 Fi:9}



static void Test_D_BFu16i_BFu9i()
{
  {
    init_simple_test("D_BFu16i_BFu9i");
    static STRUCT_IF_C D_BFu16i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu9i, D_BFu16i_BFu9i)
//============================================================================


struct  D_BFu16i_BFu9ll  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 D_BFu16i_BFu9ll) C1{ FL Fi:16 FL:9}



static void Test_D_BFu16i_BFu9ll()
{
  {
    init_simple_test("D_BFu16i_BFu9ll");
    static STRUCT_IF_C D_BFu16i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu9ll, D_BFu16i_BFu9ll)
//============================================================================


struct  D_BFu16i_BFu9s  {
  double v1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 D_BFu16i_BFu9s) C1{ FL Fi:16 Fs:9}



static void Test_D_BFu16i_BFu9s()
{
  {
    init_simple_test("D_BFu16i_BFu9s");
    static STRUCT_IF_C D_BFu16i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_BFu9s, D_BFu16i_BFu9s)
//============================================================================


struct  D_BFu16i_C  {
  double v1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 D_BFu16i_C) C1{ FL Fi:16 Fc}



static void Test_D_BFu16i_C()
{
  {
    init_simple_test("D_BFu16i_C");
    static STRUCT_IF_C D_BFu16i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_C)");
    check_field_offset(lv, v1, 0, "D_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_C");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_C");
    check_field_offset(lv, v3, 10, "D_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_C, D_BFu16i_C)
//============================================================================


struct  D_BFu16i_D  {
  double v1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 D_BFu16i_D) C1{ FL Fi:16 FL}



static void Test_D_BFu16i_D()
{
  {
    init_simple_test("D_BFu16i_D");
    static STRUCT_IF_C D_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_D)");
    check_field_offset(lv, v1, 0, "D_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_D");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_D, D_BFu16i_D)
//============================================================================


struct  D_BFu16i_F  {
  double v1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 D_BFu16i_F) C1{ FL Fi:16 Fi}



static void Test_D_BFu16i_F()
{
  {
    init_simple_test("D_BFu16i_F");
    static STRUCT_IF_C D_BFu16i_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_F)");
    check_field_offset(lv, v1, 0, "D_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_F");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_F");
    check_field_offset(lv, v3, 12, "D_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_F, D_BFu16i_F)
//============================================================================


struct  D_BFu16i_I  {
  double v1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 D_BFu16i_I) C1{ FL Fi:16 Fi}



static void Test_D_BFu16i_I()
{
  {
    init_simple_test("D_BFu16i_I");
    static STRUCT_IF_C D_BFu16i_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_I)");
    check_field_offset(lv, v1, 0, "D_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_I");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_I");
    check_field_offset(lv, v3, 12, "D_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_I, D_BFu16i_I)
//============================================================================


struct  D_BFu16i_Ip  {
  double v1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 D_BFu16i_Ip) C1{ FL Fi:16 Fp}



static void Test_D_BFu16i_Ip()
{
  {
    init_simple_test("D_BFu16i_Ip");
    static STRUCT_IF_C D_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_Ip, D_BFu16i_Ip)
//============================================================================


struct  D_BFu16i_L  {
  double v1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 D_BFu16i_L) C1{ FL Fi:16 FL}



static void Test_D_BFu16i_L()
{
  {
    init_simple_test("D_BFu16i_L");
    static STRUCT_IF_C D_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_L)");
    check_field_offset(lv, v1, 0, "D_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_L");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_L, D_BFu16i_L)
//============================================================================


struct  D_BFu16i_S  {
  double v1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 D_BFu16i_S) C1{ FL Fi:16 Fs}



static void Test_D_BFu16i_S()
{
  {
    init_simple_test("D_BFu16i_S");
    static STRUCT_IF_C D_BFu16i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_S)");
    check_field_offset(lv, v1, 0, "D_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_S");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_S");
    check_field_offset(lv, v3, 10, "D_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_S, D_BFu16i_S)
//============================================================================


struct  D_BFu16i_Uc  {
  double v1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 D_BFu16i_Uc) C1{ FL Fi:16 Fc}



static void Test_D_BFu16i_Uc()
{
  {
    init_simple_test("D_BFu16i_Uc");
    static STRUCT_IF_C D_BFu16i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_Uc");
    check_field_offset(lv, v3, 10, "D_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_Uc, D_BFu16i_Uc)
//============================================================================


struct  D_BFu16i_Ui  {
  double v1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 D_BFu16i_Ui) C1{ FL Fi:16 Fi}



static void Test_D_BFu16i_Ui()
{
  {
    init_simple_test("D_BFu16i_Ui");
    static STRUCT_IF_C D_BFu16i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_Ui");
    check_field_offset(lv, v3, 12, "D_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_Ui, D_BFu16i_Ui)
//============================================================================


struct  D_BFu16i_Ul  {
  double v1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 D_BFu16i_Ul) C1{ FL Fi:16 FL}



static void Test_D_BFu16i_Ul()
{
  {
    init_simple_test("D_BFu16i_Ul");
    static STRUCT_IF_C D_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_Ul, D_BFu16i_Ul)
//============================================================================


struct  D_BFu16i_Us  {
  double v1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 D_BFu16i_Us) C1{ FL Fi:16 Fs}



static void Test_D_BFu16i_Us()
{
  {
    init_simple_test("D_BFu16i_Us");
    static STRUCT_IF_C D_BFu16i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "D_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_Us");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_Us");
    check_field_offset(lv, v3, 10, "D_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_Us, D_BFu16i_Us)
//============================================================================


struct  D_BFu16i_Vp  {
  double v1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 D_BFu16i_Vp) C1{ FL Fi:16 Fp}



static void Test_D_BFu16i_Vp()
{
  {
    init_simple_test("D_BFu16i_Vp");
    static STRUCT_IF_C D_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16i_Vp, D_BFu16i_Vp)
//============================================================================


struct  D_BFu16ll  {
  double v1;
  __tsu64 v2:16;
};
//SIG(1 D_BFu16ll) C1{ FL FL:16}



static void Test_D_BFu16ll()
{
  {
    init_simple_test("D_BFu16ll");
    static STRUCT_IF_C D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll, D_BFu16ll)
//============================================================================


struct  D_BFu16ll_BFu15i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 D_BFu16ll_BFu15i) C1{ FL FL:16 Fi:15}



static void Test_D_BFu16ll_BFu15i()
{
  {
    init_simple_test("D_BFu16ll_BFu15i");
    static STRUCT_IF_C D_BFu16ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu15i, D_BFu16ll_BFu15i)
//============================================================================


struct  D_BFu16ll_BFu15ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 D_BFu16ll_BFu15ll) C1{ FL FL:16 FL:15}



static void Test_D_BFu16ll_BFu15ll()
{
  {
    init_simple_test("D_BFu16ll_BFu15ll");
    static STRUCT_IF_C D_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu15ll, D_BFu16ll_BFu15ll)
//============================================================================


struct  D_BFu16ll_BFu15s  {
  double v1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 D_BFu16ll_BFu15s) C1{ FL FL:16 Fs:15}



static void Test_D_BFu16ll_BFu15s()
{
  {
    init_simple_test("D_BFu16ll_BFu15s");
    static STRUCT_IF_C D_BFu16ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu15s, D_BFu16ll_BFu15s)
//============================================================================


struct  D_BFu16ll_BFu16i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 D_BFu16ll_BFu16i) C1{ FL FL:16 Fi:16}



static void Test_D_BFu16ll_BFu16i()
{
  {
    init_simple_test("D_BFu16ll_BFu16i");
    static STRUCT_IF_C D_BFu16ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu16i, D_BFu16ll_BFu16i)
//============================================================================


struct  D_BFu16ll_BFu16ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 D_BFu16ll_BFu16ll) C1{ FL FL:16 FL:16}



static void Test_D_BFu16ll_BFu16ll()
{
  {
    init_simple_test("D_BFu16ll_BFu16ll");
    static STRUCT_IF_C D_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu16ll, D_BFu16ll_BFu16ll)
//============================================================================


struct  D_BFu16ll_BFu16s  {
  double v1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 D_BFu16ll_BFu16s) C1{ FL FL:16 Fs:16}



static void Test_D_BFu16ll_BFu16s()
{
  {
    init_simple_test("D_BFu16ll_BFu16s");
    static STRUCT_IF_C D_BFu16ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu16s, D_BFu16ll_BFu16s)
//============================================================================


struct  D_BFu16ll_BFu17i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 D_BFu16ll_BFu17i) C1{ FL FL:16 Fi:17}



static void Test_D_BFu16ll_BFu17i()
{
  {
    init_simple_test("D_BFu16ll_BFu17i");
    static STRUCT_IF_C D_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu17i, D_BFu16ll_BFu17i)
//============================================================================


struct  D_BFu16ll_BFu17ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 D_BFu16ll_BFu17ll) C1{ FL FL:16 FL:17}



static void Test_D_BFu16ll_BFu17ll()
{
  {
    init_simple_test("D_BFu16ll_BFu17ll");
    static STRUCT_IF_C D_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "D_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "D_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu17ll, D_BFu16ll_BFu17ll)
//============================================================================


struct  D_BFu16ll_BFu1c  {
  double v1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 D_BFu16ll_BFu1c) C1{ FL FL:16 Fc:1}



static void Test_D_BFu16ll_BFu1c()
{
  {
    init_simple_test("D_BFu16ll_BFu1c");
    static STRUCT_IF_C D_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu1c, D_BFu16ll_BFu1c)
//============================================================================


struct  D_BFu16ll_BFu1i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 D_BFu16ll_BFu1i) C1{ FL FL:16 Fi:1}



static void Test_D_BFu16ll_BFu1i()
{
  {
    init_simple_test("D_BFu16ll_BFu1i");
    static STRUCT_IF_C D_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu1i, D_BFu16ll_BFu1i)
//============================================================================


struct  D_BFu16ll_BFu1ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 D_BFu16ll_BFu1ll) C1{ FL FL:16 FL:1}



static void Test_D_BFu16ll_BFu1ll()
{
  {
    init_simple_test("D_BFu16ll_BFu1ll");
    static STRUCT_IF_C D_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu1ll, D_BFu16ll_BFu1ll)
//============================================================================


struct  D_BFu16ll_BFu1s  {
  double v1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 D_BFu16ll_BFu1s) C1{ FL FL:16 Fs:1}



static void Test_D_BFu16ll_BFu1s()
{
  {
    init_simple_test("D_BFu16ll_BFu1s");
    static STRUCT_IF_C D_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu1s, D_BFu16ll_BFu1s)
//============================================================================


struct  D_BFu16ll_BFu31i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 D_BFu16ll_BFu31i) C1{ FL FL:16 Fi:31}



static void Test_D_BFu16ll_BFu31i()
{
  {
    init_simple_test("D_BFu16ll_BFu31i");
    static STRUCT_IF_C D_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu31i, D_BFu16ll_BFu31i)
//============================================================================


struct  D_BFu16ll_BFu31ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 D_BFu16ll_BFu31ll) C1{ FL FL:16 FL:31}



static void Test_D_BFu16ll_BFu31ll()
{
  {
    init_simple_test("D_BFu16ll_BFu31ll");
    static STRUCT_IF_C D_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "D_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "D_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu31ll, D_BFu16ll_BFu31ll)
//============================================================================


struct  D_BFu16ll_BFu32i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 D_BFu16ll_BFu32i) C1{ FL FL:16 Fi:32}



static void Test_D_BFu16ll_BFu32i()
{
  {
    init_simple_test("D_BFu16ll_BFu32i");
    static STRUCT_IF_C D_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu32i, D_BFu16ll_BFu32i)
//============================================================================


struct  D_BFu16ll_BFu32ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 D_BFu16ll_BFu32ll) C1{ FL FL:16 FL:32}



static void Test_D_BFu16ll_BFu32ll()
{
  {
    init_simple_test("D_BFu16ll_BFu32ll");
    static STRUCT_IF_C D_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "D_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "D_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu32ll, D_BFu16ll_BFu32ll)
//============================================================================


struct  D_BFu16ll_BFu33  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 D_BFu16ll_BFu33) C1{ FL FL:16 FL:33}



static void Test_D_BFu16ll_BFu33()
{
  {
    init_simple_test("D_BFu16ll_BFu33");
    static STRUCT_IF_C D_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "D_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "D_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu33, D_BFu16ll_BFu33)
//============================================================================


struct  D_BFu16ll_BFu7c  {
  double v1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 D_BFu16ll_BFu7c) C1{ FL FL:16 Fc:7}



static void Test_D_BFu16ll_BFu7c()
{
  {
    init_simple_test("D_BFu16ll_BFu7c");
    static STRUCT_IF_C D_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu7c, D_BFu16ll_BFu7c)
//============================================================================


struct  D_BFu16ll_BFu7i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 D_BFu16ll_BFu7i) C1{ FL FL:16 Fi:7}



static void Test_D_BFu16ll_BFu7i()
{
  {
    init_simple_test("D_BFu16ll_BFu7i");
    static STRUCT_IF_C D_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu7i, D_BFu16ll_BFu7i)
//============================================================================


struct  D_BFu16ll_BFu7ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 D_BFu16ll_BFu7ll) C1{ FL FL:16 FL:7}



static void Test_D_BFu16ll_BFu7ll()
{
  {
    init_simple_test("D_BFu16ll_BFu7ll");
    static STRUCT_IF_C D_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu7ll, D_BFu16ll_BFu7ll)
//============================================================================


struct  D_BFu16ll_BFu7s  {
  double v1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 D_BFu16ll_BFu7s) C1{ FL FL:16 Fs:7}



static void Test_D_BFu16ll_BFu7s()
{
  {
    init_simple_test("D_BFu16ll_BFu7s");
    static STRUCT_IF_C D_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu7s, D_BFu16ll_BFu7s)
//============================================================================


struct  D_BFu16ll_BFu8c  {
  double v1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 D_BFu16ll_BFu8c) C1{ FL FL:16 Fc:8}



static void Test_D_BFu16ll_BFu8c()
{
  {
    init_simple_test("D_BFu16ll_BFu8c");
    static STRUCT_IF_C D_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu8c, D_BFu16ll_BFu8c)
//============================================================================


struct  D_BFu16ll_BFu8i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 D_BFu16ll_BFu8i) C1{ FL FL:16 Fi:8}



static void Test_D_BFu16ll_BFu8i()
{
  {
    init_simple_test("D_BFu16ll_BFu8i");
    static STRUCT_IF_C D_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu8i, D_BFu16ll_BFu8i)
//============================================================================


struct  D_BFu16ll_BFu8ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 D_BFu16ll_BFu8ll) C1{ FL FL:16 FL:8}



static void Test_D_BFu16ll_BFu8ll()
{
  {
    init_simple_test("D_BFu16ll_BFu8ll");
    static STRUCT_IF_C D_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu8ll, D_BFu16ll_BFu8ll)
//============================================================================


struct  D_BFu16ll_BFu8s  {
  double v1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 D_BFu16ll_BFu8s) C1{ FL FL:16 Fs:8}



static void Test_D_BFu16ll_BFu8s()
{
  {
    init_simple_test("D_BFu16ll_BFu8s");
    static STRUCT_IF_C D_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu8s, D_BFu16ll_BFu8s)
//============================================================================


struct  D_BFu16ll_BFu9i  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 D_BFu16ll_BFu9i) C1{ FL FL:16 Fi:9}



static void Test_D_BFu16ll_BFu9i()
{
  {
    init_simple_test("D_BFu16ll_BFu9i");
    static STRUCT_IF_C D_BFu16ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu9i, D_BFu16ll_BFu9i)
//============================================================================


struct  D_BFu16ll_BFu9ll  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 D_BFu16ll_BFu9ll) C1{ FL FL:16 FL:9}



static void Test_D_BFu16ll_BFu9ll()
{
  {
    init_simple_test("D_BFu16ll_BFu9ll");
    static STRUCT_IF_C D_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu9ll, D_BFu16ll_BFu9ll)
//============================================================================


struct  D_BFu16ll_BFu9s  {
  double v1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 D_BFu16ll_BFu9s) C1{ FL FL:16 Fs:9}



static void Test_D_BFu16ll_BFu9s()
{
  {
    init_simple_test("D_BFu16ll_BFu9s");
    static STRUCT_IF_C D_BFu16ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_BFu9s, D_BFu16ll_BFu9s)
//============================================================================


struct  D_BFu16ll_C  {
  double v1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 D_BFu16ll_C) C1{ FL FL:16 Fc}



static void Test_D_BFu16ll_C()
{
  {
    init_simple_test("D_BFu16ll_C");
    static STRUCT_IF_C D_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_C");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_C");
    check_field_offset(lv, v3, 10, "D_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_C, D_BFu16ll_C)
//============================================================================


struct  D_BFu16ll_D  {
  double v1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 D_BFu16ll_D) C1{ FL FL:16 FL}



static void Test_D_BFu16ll_D()
{
  {
    init_simple_test("D_BFu16ll_D");
    static STRUCT_IF_C D_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_D");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_D, D_BFu16ll_D)
//============================================================================


struct  D_BFu16ll_F  {
  double v1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 D_BFu16ll_F) C1{ FL FL:16 Fi}



static void Test_D_BFu16ll_F()
{
  {
    init_simple_test("D_BFu16ll_F");
    static STRUCT_IF_C D_BFu16ll_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_F");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_F");
    check_field_offset(lv, v3, 12, "D_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_F, D_BFu16ll_F)
//============================================================================


struct  D_BFu16ll_I  {
  double v1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 D_BFu16ll_I) C1{ FL FL:16 Fi}



static void Test_D_BFu16ll_I()
{
  {
    init_simple_test("D_BFu16ll_I");
    static STRUCT_IF_C D_BFu16ll_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_I");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_I");
    check_field_offset(lv, v3, 12, "D_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_I, D_BFu16ll_I)
//============================================================================


struct  D_BFu16ll_Ip  {
  double v1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 D_BFu16ll_Ip) C1{ FL FL:16 Fp}



static void Test_D_BFu16ll_Ip()
{
  {
    init_simple_test("D_BFu16ll_Ip");
    static STRUCT_IF_C D_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_Ip, D_BFu16ll_Ip)
//============================================================================


struct  D_BFu16ll_L  {
  double v1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 D_BFu16ll_L) C1{ FL FL:16 FL}



static void Test_D_BFu16ll_L()
{
  {
    init_simple_test("D_BFu16ll_L");
    static STRUCT_IF_C D_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_L");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_L, D_BFu16ll_L)
//============================================================================


struct  D_BFu16ll_S  {
  double v1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 D_BFu16ll_S) C1{ FL FL:16 Fs}



static void Test_D_BFu16ll_S()
{
  {
    init_simple_test("D_BFu16ll_S");
    static STRUCT_IF_C D_BFu16ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_S");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_S");
    check_field_offset(lv, v3, 10, "D_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_S, D_BFu16ll_S)
//============================================================================


struct  D_BFu16ll_Uc  {
  double v1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 D_BFu16ll_Uc) C1{ FL FL:16 Fc}



static void Test_D_BFu16ll_Uc()
{
  {
    init_simple_test("D_BFu16ll_Uc");
    static STRUCT_IF_C D_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_Uc");
    check_field_offset(lv, v3, 10, "D_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_Uc, D_BFu16ll_Uc)
//============================================================================


struct  D_BFu16ll_Ui  {
  double v1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 D_BFu16ll_Ui) C1{ FL FL:16 Fi}



static void Test_D_BFu16ll_Ui()
{
  {
    init_simple_test("D_BFu16ll_Ui");
    static STRUCT_IF_C D_BFu16ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_Ui");
    check_field_offset(lv, v3, 12, "D_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_Ui, D_BFu16ll_Ui)
//============================================================================


struct  D_BFu16ll_Ul  {
  double v1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 D_BFu16ll_Ul) C1{ FL FL:16 FL}



static void Test_D_BFu16ll_Ul()
{
  {
    init_simple_test("D_BFu16ll_Ul");
    static STRUCT_IF_C D_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_Ul, D_BFu16ll_Ul)
//============================================================================


struct  D_BFu16ll_Us  {
  double v1;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 D_BFu16ll_Us) C1{ FL FL:16 Fs}



static void Test_D_BFu16ll_Us()
{
  {
    init_simple_test("D_BFu16ll_Us");
    static STRUCT_IF_C D_BFu16ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_Us");
    check_field_offset(lv, v3, 10, "D_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_Us, D_BFu16ll_Us)
//============================================================================


struct  D_BFu16ll_Vp  {
  double v1;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 D_BFu16ll_Vp) C1{ FL FL:16 Fp}



static void Test_D_BFu16ll_Vp()
{
  {
    init_simple_test("D_BFu16ll_Vp");
    static STRUCT_IF_C D_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16ll_Vp, D_BFu16ll_Vp)
//============================================================================


struct  D_BFu16s  {
  double v1;
  unsigned short v2:16;
};
//SIG(1 D_BFu16s) C1{ FL Fs:16}



static void Test_D_BFu16s()
{
  {
    init_simple_test("D_BFu16s");
    static STRUCT_IF_C D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s, D_BFu16s)
//============================================================================


struct  D_BFu16s_BFu15i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 D_BFu16s_BFu15i) C1{ FL Fs:16 Fi:15}



static void Test_D_BFu16s_BFu15i()
{
  {
    init_simple_test("D_BFu16s_BFu15i");
    static STRUCT_IF_C D_BFu16s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu15i, D_BFu16s_BFu15i)
//============================================================================


struct  D_BFu16s_BFu15ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 D_BFu16s_BFu15ll) C1{ FL Fs:16 FL:15}



static void Test_D_BFu16s_BFu15ll()
{
  {
    init_simple_test("D_BFu16s_BFu15ll");
    static STRUCT_IF_C D_BFu16s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu15ll, D_BFu16s_BFu15ll)
//============================================================================


struct  D_BFu16s_BFu15s  {
  double v1;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 D_BFu16s_BFu15s) C1{ FL Fs:16 Fs:15}



static void Test_D_BFu16s_BFu15s()
{
  {
    init_simple_test("D_BFu16s_BFu15s");
    static STRUCT_IF_C D_BFu16s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu15s, D_BFu16s_BFu15s)
//============================================================================


struct  D_BFu16s_BFu16i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 D_BFu16s_BFu16i) C1{ FL Fs:16 Fi:16}



static void Test_D_BFu16s_BFu16i()
{
  {
    init_simple_test("D_BFu16s_BFu16i");
    static STRUCT_IF_C D_BFu16s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu16i, D_BFu16s_BFu16i)
//============================================================================


struct  D_BFu16s_BFu16ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 D_BFu16s_BFu16ll) C1{ FL Fs:16 FL:16}



static void Test_D_BFu16s_BFu16ll()
{
  {
    init_simple_test("D_BFu16s_BFu16ll");
    static STRUCT_IF_C D_BFu16s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu16ll, D_BFu16s_BFu16ll)
//============================================================================


struct  D_BFu16s_BFu16s  {
  double v1;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 D_BFu16s_BFu16s) C1{ FL Fs:16 Fs:16}



static void Test_D_BFu16s_BFu16s()
{
  {
    init_simple_test("D_BFu16s_BFu16s");
    static STRUCT_IF_C D_BFu16s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu16s, D_BFu16s_BFu16s)
//============================================================================


struct  D_BFu16s_BFu17i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 D_BFu16s_BFu17i) C1{ FL Fs:16 Fi:17}



static void Test_D_BFu16s_BFu17i()
{
  {
    init_simple_test("D_BFu16s_BFu17i");
    static STRUCT_IF_C D_BFu16s_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu17i, D_BFu16s_BFu17i)
//============================================================================


struct  D_BFu16s_BFu17ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 D_BFu16s_BFu17ll) C1{ FL Fs:16 FL:17}



static void Test_D_BFu16s_BFu17ll()
{
  {
    init_simple_test("D_BFu16s_BFu17ll");
    static STRUCT_IF_C D_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "D_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "D_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu17ll, D_BFu16s_BFu17ll)
//============================================================================


struct  D_BFu16s_BFu1c  {
  double v1;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 D_BFu16s_BFu1c) C1{ FL Fs:16 Fc:1}



static void Test_D_BFu16s_BFu1c()
{
  {
    init_simple_test("D_BFu16s_BFu1c");
    static STRUCT_IF_C D_BFu16s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu1c, D_BFu16s_BFu1c)
//============================================================================


struct  D_BFu16s_BFu1i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 D_BFu16s_BFu1i) C1{ FL Fs:16 Fi:1}



static void Test_D_BFu16s_BFu1i()
{
  {
    init_simple_test("D_BFu16s_BFu1i");
    static STRUCT_IF_C D_BFu16s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu1i, D_BFu16s_BFu1i)
//============================================================================


struct  D_BFu16s_BFu1ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 D_BFu16s_BFu1ll) C1{ FL Fs:16 FL:1}



static void Test_D_BFu16s_BFu1ll()
{
  {
    init_simple_test("D_BFu16s_BFu1ll");
    static STRUCT_IF_C D_BFu16s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu1ll, D_BFu16s_BFu1ll)
//============================================================================


struct  D_BFu16s_BFu1s  {
  double v1;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 D_BFu16s_BFu1s) C1{ FL Fs:16 Fs:1}



static void Test_D_BFu16s_BFu1s()
{
  {
    init_simple_test("D_BFu16s_BFu1s");
    static STRUCT_IF_C D_BFu16s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu1s, D_BFu16s_BFu1s)
//============================================================================


struct  D_BFu16s_BFu31i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 D_BFu16s_BFu31i) C1{ FL Fs:16 Fi:31}



static void Test_D_BFu16s_BFu31i()
{
  {
    init_simple_test("D_BFu16s_BFu31i");
    static STRUCT_IF_C D_BFu16s_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu31i, D_BFu16s_BFu31i)
//============================================================================


struct  D_BFu16s_BFu31ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 D_BFu16s_BFu31ll) C1{ FL Fs:16 FL:31}



static void Test_D_BFu16s_BFu31ll()
{
  {
    init_simple_test("D_BFu16s_BFu31ll");
    static STRUCT_IF_C D_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "D_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "D_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu31ll, D_BFu16s_BFu31ll)
//============================================================================


struct  D_BFu16s_BFu32i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 D_BFu16s_BFu32i) C1{ FL Fs:16 Fi:32}



static void Test_D_BFu16s_BFu32i()
{
  {
    init_simple_test("D_BFu16s_BFu32i");
    static STRUCT_IF_C D_BFu16s_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu32i, D_BFu16s_BFu32i)
//============================================================================


struct  D_BFu16s_BFu32ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 D_BFu16s_BFu32ll) C1{ FL Fs:16 FL:32}



static void Test_D_BFu16s_BFu32ll()
{
  {
    init_simple_test("D_BFu16s_BFu32ll");
    static STRUCT_IF_C D_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "D_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "D_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu32ll, D_BFu16s_BFu32ll)
//============================================================================


struct  D_BFu16s_BFu33  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 D_BFu16s_BFu33) C1{ FL Fs:16 FL:33}



static void Test_D_BFu16s_BFu33()
{
  {
    init_simple_test("D_BFu16s_BFu33");
    static STRUCT_IF_C D_BFu16s_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "D_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "D_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu33, D_BFu16s_BFu33)
//============================================================================


struct  D_BFu16s_BFu7c  {
  double v1;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 D_BFu16s_BFu7c) C1{ FL Fs:16 Fc:7}



static void Test_D_BFu16s_BFu7c()
{
  {
    init_simple_test("D_BFu16s_BFu7c");
    static STRUCT_IF_C D_BFu16s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu7c, D_BFu16s_BFu7c)
//============================================================================


struct  D_BFu16s_BFu7i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 D_BFu16s_BFu7i) C1{ FL Fs:16 Fi:7}



static void Test_D_BFu16s_BFu7i()
{
  {
    init_simple_test("D_BFu16s_BFu7i");
    static STRUCT_IF_C D_BFu16s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu7i, D_BFu16s_BFu7i)
//============================================================================


struct  D_BFu16s_BFu7ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 D_BFu16s_BFu7ll) C1{ FL Fs:16 FL:7}



static void Test_D_BFu16s_BFu7ll()
{
  {
    init_simple_test("D_BFu16s_BFu7ll");
    static STRUCT_IF_C D_BFu16s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu7ll, D_BFu16s_BFu7ll)
//============================================================================


struct  D_BFu16s_BFu7s  {
  double v1;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 D_BFu16s_BFu7s) C1{ FL Fs:16 Fs:7}



static void Test_D_BFu16s_BFu7s()
{
  {
    init_simple_test("D_BFu16s_BFu7s");
    static STRUCT_IF_C D_BFu16s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu7s, D_BFu16s_BFu7s)
//============================================================================


struct  D_BFu16s_BFu8c  {
  double v1;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 D_BFu16s_BFu8c) C1{ FL Fs:16 Fc:8}



static void Test_D_BFu16s_BFu8c()
{
  {
    init_simple_test("D_BFu16s_BFu8c");
    static STRUCT_IF_C D_BFu16s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu8c, D_BFu16s_BFu8c)
//============================================================================


struct  D_BFu16s_BFu8i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 D_BFu16s_BFu8i) C1{ FL Fs:16 Fi:8}



static void Test_D_BFu16s_BFu8i()
{
  {
    init_simple_test("D_BFu16s_BFu8i");
    static STRUCT_IF_C D_BFu16s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu8i, D_BFu16s_BFu8i)
//============================================================================


struct  D_BFu16s_BFu8ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 D_BFu16s_BFu8ll) C1{ FL Fs:16 FL:8}



static void Test_D_BFu16s_BFu8ll()
{
  {
    init_simple_test("D_BFu16s_BFu8ll");
    static STRUCT_IF_C D_BFu16s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu8ll, D_BFu16s_BFu8ll)
//============================================================================


struct  D_BFu16s_BFu8s  {
  double v1;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 D_BFu16s_BFu8s) C1{ FL Fs:16 Fs:8}



static void Test_D_BFu16s_BFu8s()
{
  {
    init_simple_test("D_BFu16s_BFu8s");
    static STRUCT_IF_C D_BFu16s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu8s, D_BFu16s_BFu8s)
//============================================================================


struct  D_BFu16s_BFu9i  {
  double v1;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 D_BFu16s_BFu9i) C1{ FL Fs:16 Fi:9}



static void Test_D_BFu16s_BFu9i()
{
  {
    init_simple_test("D_BFu16s_BFu9i");
    static STRUCT_IF_C D_BFu16s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu9i, D_BFu16s_BFu9i)
//============================================================================


struct  D_BFu16s_BFu9ll  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 D_BFu16s_BFu9ll) C1{ FL Fs:16 FL:9}



static void Test_D_BFu16s_BFu9ll()
{
  {
    init_simple_test("D_BFu16s_BFu9ll");
    static STRUCT_IF_C D_BFu16s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu9ll, D_BFu16s_BFu9ll)
//============================================================================


struct  D_BFu16s_BFu9s  {
  double v1;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 D_BFu16s_BFu9s) C1{ FL Fs:16 Fs:9}



static void Test_D_BFu16s_BFu9s()
{
  {
    init_simple_test("D_BFu16s_BFu9s");
    static STRUCT_IF_C D_BFu16s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_BFu9s, D_BFu16s_BFu9s)
//============================================================================


struct  D_BFu16s_C  {
  double v1;
  unsigned short v2:16;
  char v3;
};
//SIG(1 D_BFu16s_C) C1{ FL Fs:16 Fc}



static void Test_D_BFu16s_C()
{
  {
    init_simple_test("D_BFu16s_C");
    static STRUCT_IF_C D_BFu16s_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_C)");
    check_field_offset(lv, v1, 0, "D_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_C");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_C");
    check_field_offset(lv, v3, 10, "D_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_C, D_BFu16s_C)
//============================================================================


struct  D_BFu16s_D  {
  double v1;
  unsigned short v2:16;
  double v3;
};
//SIG(1 D_BFu16s_D) C1{ FL Fs:16 FL}



static void Test_D_BFu16s_D()
{
  {
    init_simple_test("D_BFu16s_D");
    static STRUCT_IF_C D_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_D)");
    check_field_offset(lv, v1, 0, "D_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_D");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_D, D_BFu16s_D)
//============================================================================


struct  D_BFu16s_F  {
  double v1;
  unsigned short v2:16;
  float v3;
};
//SIG(1 D_BFu16s_F) C1{ FL Fs:16 Fi}



static void Test_D_BFu16s_F()
{
  {
    init_simple_test("D_BFu16s_F");
    static STRUCT_IF_C D_BFu16s_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_F)");
    check_field_offset(lv, v1, 0, "D_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_F");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_F");
    check_field_offset(lv, v3, 12, "D_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_F, D_BFu16s_F)
//============================================================================


struct  D_BFu16s_I  {
  double v1;
  unsigned short v2:16;
  int v3;
};
//SIG(1 D_BFu16s_I) C1{ FL Fs:16 Fi}



static void Test_D_BFu16s_I()
{
  {
    init_simple_test("D_BFu16s_I");
    static STRUCT_IF_C D_BFu16s_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_I)");
    check_field_offset(lv, v1, 0, "D_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_I");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_I");
    check_field_offset(lv, v3, 12, "D_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_I, D_BFu16s_I)
//============================================================================


struct  D_BFu16s_Ip  {
  double v1;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 D_BFu16s_Ip) C1{ FL Fs:16 Fp}



static void Test_D_BFu16s_Ip()
{
  {
    init_simple_test("D_BFu16s_Ip");
    static STRUCT_IF_C D_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_Ip, D_BFu16s_Ip)
//============================================================================


struct  D_BFu16s_L  {
  double v1;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 D_BFu16s_L) C1{ FL Fs:16 FL}



static void Test_D_BFu16s_L()
{
  {
    init_simple_test("D_BFu16s_L");
    static STRUCT_IF_C D_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_L)");
    check_field_offset(lv, v1, 0, "D_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_L");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_L, D_BFu16s_L)
//============================================================================


struct  D_BFu16s_S  {
  double v1;
  unsigned short v2:16;
  short v3;
};
//SIG(1 D_BFu16s_S) C1{ FL Fs:16 Fs}



static void Test_D_BFu16s_S()
{
  {
    init_simple_test("D_BFu16s_S");
    static STRUCT_IF_C D_BFu16s_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_S)");
    check_field_offset(lv, v1, 0, "D_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_S");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_S");
    check_field_offset(lv, v3, 10, "D_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_S, D_BFu16s_S)
//============================================================================


struct  D_BFu16s_Uc  {
  double v1;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 D_BFu16s_Uc) C1{ FL Fs:16 Fc}



static void Test_D_BFu16s_Uc()
{
  {
    init_simple_test("D_BFu16s_Uc");
    static STRUCT_IF_C D_BFu16s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_Uc");
    check_field_offset(lv, v3, 10, "D_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_Uc, D_BFu16s_Uc)
//============================================================================


struct  D_BFu16s_Ui  {
  double v1;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 D_BFu16s_Ui) C1{ FL Fs:16 Fi}



static void Test_D_BFu16s_Ui()
{
  {
    init_simple_test("D_BFu16s_Ui");
    static STRUCT_IF_C D_BFu16s_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu16s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_Ui");
    check_field_offset(lv, v3, 12, "D_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_Ui, D_BFu16s_Ui)
//============================================================================


struct  D_BFu16s_Ul  {
  double v1;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 D_BFu16s_Ul) C1{ FL Fs:16 FL}



static void Test_D_BFu16s_Ul()
{
  {
    init_simple_test("D_BFu16s_Ul");
    static STRUCT_IF_C D_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_Ul, D_BFu16s_Ul)
//============================================================================


struct  D_BFu16s_Us  {
  double v1;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 D_BFu16s_Us) C1{ FL Fs:16 Fs}



static void Test_D_BFu16s_Us()
{
  {
    init_simple_test("D_BFu16s_Us");
    static STRUCT_IF_C D_BFu16s_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "D_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_Us");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_Us");
    check_field_offset(lv, v3, 10, "D_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_Us, D_BFu16s_Us)
//============================================================================


struct  D_BFu16s_Vp  {
  double v1;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 D_BFu16s_Vp) C1{ FL Fs:16 Fp}



static void Test_D_BFu16s_Vp()
{
  {
    init_simple_test("D_BFu16s_Vp");
    static STRUCT_IF_C D_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu16s_Vp, D_BFu16s_Vp)
//============================================================================


struct  D_BFu17i  {
  double v1;
  unsigned int v2:17;
};
//SIG(1 D_BFu17i) C1{ FL Fi:17}



static void Test_D_BFu17i()
{
  {
    init_simple_test("D_BFu17i");
    static STRUCT_IF_C D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i, D_BFu17i)
//============================================================================


struct  D_BFu17i_BFu15i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 D_BFu17i_BFu15i) C1{ FL Fi:17 Fi:15}



static void Test_D_BFu17i_BFu15i()
{
  {
    init_simple_test("D_BFu17i_BFu15i");
    static STRUCT_IF_C D_BFu17i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "D_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "D_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu15i, D_BFu17i_BFu15i)
//============================================================================


struct  D_BFu17i_BFu15ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 D_BFu17i_BFu15ll) C1{ FL Fi:17 FL:15}



static void Test_D_BFu17i_BFu15ll()
{
  {
    init_simple_test("D_BFu17i_BFu15ll");
    static STRUCT_IF_C D_BFu17i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "D_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "D_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu15ll, D_BFu17i_BFu15ll)
//============================================================================


struct  D_BFu17i_BFu15s  {
  double v1;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 D_BFu17i_BFu15s) C1{ FL Fi:17 Fs:15}



static void Test_D_BFu17i_BFu15s()
{
  {
    init_simple_test("D_BFu17i_BFu15s");
    static STRUCT_IF_C D_BFu17i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "D_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "D_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu15s, D_BFu17i_BFu15s)
//============================================================================


struct  D_BFu17i_BFu16i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 D_BFu17i_BFu16i) C1{ FL Fi:17 Fi:16}



static void Test_D_BFu17i_BFu16i()
{
  {
    init_simple_test("D_BFu17i_BFu16i");
    static STRUCT_IF_C D_BFu17i_BFu16i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu16i, D_BFu17i_BFu16i)
//============================================================================


struct  D_BFu17i_BFu16ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 D_BFu17i_BFu16ll) C1{ FL Fi:17 FL:16}



static void Test_D_BFu17i_BFu16ll()
{
  {
    init_simple_test("D_BFu17i_BFu16ll");
    static STRUCT_IF_C D_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 1, 16, 1, "D_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 1, 16, hide_ull(1LL<<15), "D_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu16ll, D_BFu17i_BFu16ll)
//============================================================================


struct  D_BFu17i_BFu16s  {
  double v1;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 D_BFu17i_BFu16s) C1{ FL Fi:17 Fs:16}



static void Test_D_BFu17i_BFu16s()
{
  {
    init_simple_test("D_BFu17i_BFu16s");
    static STRUCT_IF_C D_BFu17i_BFu16s lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu16s, D_BFu17i_BFu16s)
//============================================================================


struct  D_BFu17i_BFu17i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 D_BFu17i_BFu17i) C1{ FL Fi:17 Fi:17}



static void Test_D_BFu17i_BFu17i()
{
  {
    init_simple_test("D_BFu17i_BFu17i");
    static STRUCT_IF_C D_BFu17i_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu17i, D_BFu17i_BFu17i)
//============================================================================


struct  D_BFu17i_BFu17ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 D_BFu17i_BFu17ll) C1{ FL Fi:17 FL:17}



static void Test_D_BFu17i_BFu17ll()
{
  {
    init_simple_test("D_BFu17i_BFu17ll");
    static STRUCT_IF_C D_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 1, 17, 1, "D_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 1, 17, hide_ull(1LL<<16), "D_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu17ll, D_BFu17i_BFu17ll)
//============================================================================


struct  D_BFu17i_BFu1c  {
  double v1;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 D_BFu17i_BFu1c) C1{ FL Fi:17 Fc:1}



static void Test_D_BFu17i_BFu1c()
{
  {
    init_simple_test("D_BFu17i_BFu1c");
    static STRUCT_IF_C D_BFu17i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "D_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu1c, D_BFu17i_BFu1c)
//============================================================================


struct  D_BFu17i_BFu1i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 D_BFu17i_BFu1i) C1{ FL Fi:17 Fi:1}



static void Test_D_BFu17i_BFu1i()
{
  {
    init_simple_test("D_BFu17i_BFu1i");
    static STRUCT_IF_C D_BFu17i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "D_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu1i, D_BFu17i_BFu1i)
//============================================================================


struct  D_BFu17i_BFu1ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 D_BFu17i_BFu1ll) C1{ FL Fi:17 FL:1}



static void Test_D_BFu17i_BFu1ll()
{
  {
    init_simple_test("D_BFu17i_BFu1ll");
    static STRUCT_IF_C D_BFu17i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "D_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu1ll, D_BFu17i_BFu1ll)
//============================================================================


struct  D_BFu17i_BFu1s  {
  double v1;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 D_BFu17i_BFu1s) C1{ FL Fi:17 Fs:1}



static void Test_D_BFu17i_BFu1s()
{
  {
    init_simple_test("D_BFu17i_BFu1s");
    static STRUCT_IF_C D_BFu17i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "D_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu1s, D_BFu17i_BFu1s)
//============================================================================


struct  D_BFu17i_BFu31i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 D_BFu17i_BFu31i) C1{ FL Fi:17 Fi:31}



static void Test_D_BFu17i_BFu31i()
{
  {
    init_simple_test("D_BFu17i_BFu31i");
    static STRUCT_IF_C D_BFu17i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu31i, D_BFu17i_BFu31i)
//============================================================================


struct  D_BFu17i_BFu31ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 D_BFu17i_BFu31ll) C1{ FL Fi:17 FL:31}



static void Test_D_BFu17i_BFu31ll()
{
  {
    init_simple_test("D_BFu17i_BFu31ll");
    static STRUCT_IF_C D_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 1, 31, 1, "D_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 1, 31, hide_ull(1LL<<30), "D_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu31ll, D_BFu17i_BFu31ll)
//============================================================================


struct  D_BFu17i_BFu32i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 D_BFu17i_BFu32i) C1{ FL Fi:17 Fi:32}



static void Test_D_BFu17i_BFu32i()
{
  {
    init_simple_test("D_BFu17i_BFu32i");
    static STRUCT_IF_C D_BFu17i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu32i, D_BFu17i_BFu32i)
//============================================================================


struct  D_BFu17i_BFu32ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 D_BFu17i_BFu32ll) C1{ FL Fi:17 FL:32}



static void Test_D_BFu17i_BFu32ll()
{
  {
    init_simple_test("D_BFu17i_BFu32ll");
    static STRUCT_IF_C D_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 1, 32, 1, "D_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 1, 32, hide_ull(1LL<<31), "D_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu32ll, D_BFu17i_BFu32ll)
//============================================================================


struct  D_BFu17i_BFu33  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 D_BFu17i_BFu33) C1{ FL Fi:17 FL:33}



static void Test_D_BFu17i_BFu33()
{
  {
    init_simple_test("D_BFu17i_BFu33");
    static STRUCT_IF_C D_BFu17i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 10, 1, 33, 1, "D_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 10, 1, 33, hide_ull(1LL<<32), "D_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu33, D_BFu17i_BFu33)
//============================================================================


struct  D_BFu17i_BFu7c  {
  double v1;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 D_BFu17i_BFu7c) C1{ FL Fi:17 Fc:7}



static void Test_D_BFu17i_BFu7c()
{
  {
    init_simple_test("D_BFu17i_BFu7c");
    static STRUCT_IF_C D_BFu17i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "D_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "D_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu7c, D_BFu17i_BFu7c)
//============================================================================


struct  D_BFu17i_BFu7i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 D_BFu17i_BFu7i) C1{ FL Fi:17 Fi:7}



static void Test_D_BFu17i_BFu7i()
{
  {
    init_simple_test("D_BFu17i_BFu7i");
    static STRUCT_IF_C D_BFu17i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "D_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "D_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu7i, D_BFu17i_BFu7i)
//============================================================================


struct  D_BFu17i_BFu7ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 D_BFu17i_BFu7ll) C1{ FL Fi:17 FL:7}



static void Test_D_BFu17i_BFu7ll()
{
  {
    init_simple_test("D_BFu17i_BFu7ll");
    static STRUCT_IF_C D_BFu17i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "D_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "D_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu7ll, D_BFu17i_BFu7ll)
//============================================================================


struct  D_BFu17i_BFu7s  {
  double v1;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 D_BFu17i_BFu7s) C1{ FL Fi:17 Fs:7}



static void Test_D_BFu17i_BFu7s()
{
  {
    init_simple_test("D_BFu17i_BFu7s");
    static STRUCT_IF_C D_BFu17i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "D_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "D_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu7s, D_BFu17i_BFu7s)
//============================================================================


struct  D_BFu17i_BFu8c  {
  double v1;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 D_BFu17i_BFu8c) C1{ FL Fi:17 Fc:8}



static void Test_D_BFu17i_BFu8c()
{
  {
    init_simple_test("D_BFu17i_BFu8c");
    static STRUCT_IF_C D_BFu17i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 11, 0, 8, 1, "D_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 11, 0, 8, hide_ull(1LL<<7), "D_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu8c, D_BFu17i_BFu8c)
//============================================================================


struct  D_BFu17i_BFu8i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 D_BFu17i_BFu8i) C1{ FL Fi:17 Fi:8}



static void Test_D_BFu17i_BFu8i()
{
  {
    init_simple_test("D_BFu17i_BFu8i");
    static STRUCT_IF_C D_BFu17i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "D_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "D_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu8i, D_BFu17i_BFu8i)
//============================================================================


struct  D_BFu17i_BFu8ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 D_BFu17i_BFu8ll) C1{ FL Fi:17 FL:8}



static void Test_D_BFu17i_BFu8ll()
{
  {
    init_simple_test("D_BFu17i_BFu8ll");
    static STRUCT_IF_C D_BFu17i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "D_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "D_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu8ll, D_BFu17i_BFu8ll)
//============================================================================


struct  D_BFu17i_BFu8s  {
  double v1;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 D_BFu17i_BFu8s) C1{ FL Fi:17 Fs:8}



static void Test_D_BFu17i_BFu8s()
{
  {
    init_simple_test("D_BFu17i_BFu8s");
    static STRUCT_IF_C D_BFu17i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "D_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "D_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu8s, D_BFu17i_BFu8s)
//============================================================================


struct  D_BFu17i_BFu9i  {
  double v1;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 D_BFu17i_BFu9i) C1{ FL Fi:17 Fi:9}



static void Test_D_BFu17i_BFu9i()
{
  {
    init_simple_test("D_BFu17i_BFu9i");
    static STRUCT_IF_C D_BFu17i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "D_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "D_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu9i, D_BFu17i_BFu9i)
//============================================================================


struct  D_BFu17i_BFu9ll  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 D_BFu17i_BFu9ll) C1{ FL Fi:17 FL:9}



static void Test_D_BFu17i_BFu9ll()
{
  {
    init_simple_test("D_BFu17i_BFu9ll");
    static STRUCT_IF_C D_BFu17i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "D_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "D_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu9ll, D_BFu17i_BFu9ll)
//============================================================================


struct  D_BFu17i_BFu9s  {
  double v1;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 D_BFu17i_BFu9s) C1{ FL Fi:17 Fs:9}



static void Test_D_BFu17i_BFu9s()
{
  {
    init_simple_test("D_BFu17i_BFu9s");
    static STRUCT_IF_C D_BFu17i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "D_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "D_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_BFu9s, D_BFu17i_BFu9s)
//============================================================================


struct  D_BFu17i_C  {
  double v1;
  unsigned int v2:17;
  char v3;
};
//SIG(1 D_BFu17i_C) C1{ FL Fi:17 Fc}



static void Test_D_BFu17i_C()
{
  {
    init_simple_test("D_BFu17i_C");
    static STRUCT_IF_C D_BFu17i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_C)");
    check_field_offset(lv, v1, 0, "D_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_C");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_C");
    check_field_offset(lv, v3, 11, "D_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_C, D_BFu17i_C)
//============================================================================


struct  D_BFu17i_D  {
  double v1;
  unsigned int v2:17;
  double v3;
};
//SIG(1 D_BFu17i_D) C1{ FL Fi:17 FL}



static void Test_D_BFu17i_D()
{
  {
    init_simple_test("D_BFu17i_D");
    static STRUCT_IF_C D_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_D)");
    check_field_offset(lv, v1, 0, "D_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_D");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_D, D_BFu17i_D)
//============================================================================


struct  D_BFu17i_F  {
  double v1;
  unsigned int v2:17;
  float v3;
};
//SIG(1 D_BFu17i_F) C1{ FL Fi:17 Fi}



static void Test_D_BFu17i_F()
{
  {
    init_simple_test("D_BFu17i_F");
    static STRUCT_IF_C D_BFu17i_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_F)");
    check_field_offset(lv, v1, 0, "D_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_F");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_F");
    check_field_offset(lv, v3, 12, "D_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_F, D_BFu17i_F)
//============================================================================


struct  D_BFu17i_I  {
  double v1;
  unsigned int v2:17;
  int v3;
};
//SIG(1 D_BFu17i_I) C1{ FL Fi:17 Fi}



static void Test_D_BFu17i_I()
{
  {
    init_simple_test("D_BFu17i_I");
    static STRUCT_IF_C D_BFu17i_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_I)");
    check_field_offset(lv, v1, 0, "D_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_I");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_I");
    check_field_offset(lv, v3, 12, "D_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_I, D_BFu17i_I)
//============================================================================


struct  D_BFu17i_Ip  {
  double v1;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 D_BFu17i_Ip) C1{ FL Fi:17 Fp}



static void Test_D_BFu17i_Ip()
{
  {
    init_simple_test("D_BFu17i_Ip");
    static STRUCT_IF_C D_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_Ip, D_BFu17i_Ip)
//============================================================================


struct  D_BFu17i_L  {
  double v1;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 D_BFu17i_L) C1{ FL Fi:17 FL}



static void Test_D_BFu17i_L()
{
  {
    init_simple_test("D_BFu17i_L");
    static STRUCT_IF_C D_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_L)");
    check_field_offset(lv, v1, 0, "D_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_L");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_L, D_BFu17i_L)
//============================================================================


struct  D_BFu17i_S  {
  double v1;
  unsigned int v2:17;
  short v3;
};
//SIG(1 D_BFu17i_S) C1{ FL Fi:17 Fs}



static void Test_D_BFu17i_S()
{
  {
    init_simple_test("D_BFu17i_S");
    static STRUCT_IF_C D_BFu17i_S lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_S)");
    check_field_offset(lv, v1, 0, "D_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_S");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_S");
    check_field_offset(lv, v3, 12, "D_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_S, D_BFu17i_S)
//============================================================================


struct  D_BFu17i_Uc  {
  double v1;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 D_BFu17i_Uc) C1{ FL Fi:17 Fc}



static void Test_D_BFu17i_Uc()
{
  {
    init_simple_test("D_BFu17i_Uc");
    static STRUCT_IF_C D_BFu17i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_Uc");
    check_field_offset(lv, v3, 11, "D_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_Uc, D_BFu17i_Uc)
//============================================================================


struct  D_BFu17i_Ui  {
  double v1;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 D_BFu17i_Ui) C1{ FL Fi:17 Fi}



static void Test_D_BFu17i_Ui()
{
  {
    init_simple_test("D_BFu17i_Ui");
    static STRUCT_IF_C D_BFu17i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_Ui");
    check_field_offset(lv, v3, 12, "D_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_Ui, D_BFu17i_Ui)
//============================================================================


struct  D_BFu17i_Ul  {
  double v1;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 D_BFu17i_Ul) C1{ FL Fi:17 FL}



static void Test_D_BFu17i_Ul()
{
  {
    init_simple_test("D_BFu17i_Ul");
    static STRUCT_IF_C D_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_Ul, D_BFu17i_Ul)
//============================================================================


struct  D_BFu17i_Us  {
  double v1;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 D_BFu17i_Us) C1{ FL Fi:17 Fs}



static void Test_D_BFu17i_Us()
{
  {
    init_simple_test("D_BFu17i_Us");
    static STRUCT_IF_C D_BFu17i_Us lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "D_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_Us");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_Us");
    check_field_offset(lv, v3, 12, "D_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_Us, D_BFu17i_Us)
//============================================================================


struct  D_BFu17i_Vp  {
  double v1;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 D_BFu17i_Vp) C1{ FL Fi:17 Fp}



static void Test_D_BFu17i_Vp()
{
  {
    init_simple_test("D_BFu17i_Vp");
    static STRUCT_IF_C D_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17i_Vp, D_BFu17i_Vp)
//============================================================================


struct  D_BFu17ll  {
  double v1;
  __tsu64 v2:17;
};
//SIG(1 D_BFu17ll) C1{ FL FL:17}



static void Test_D_BFu17ll()
{
  {
    init_simple_test("D_BFu17ll");
    static STRUCT_IF_C D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll, D_BFu17ll)
//============================================================================


struct  D_BFu17ll_BFu15i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 D_BFu17ll_BFu15i) C1{ FL FL:17 Fi:15}



static void Test_D_BFu17ll_BFu15i()
{
  {
    init_simple_test("D_BFu17ll_BFu15i");
    static STRUCT_IF_C D_BFu17ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "D_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "D_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu15i, D_BFu17ll_BFu15i)
//============================================================================


struct  D_BFu17ll_BFu15ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 D_BFu17ll_BFu15ll) C1{ FL FL:17 FL:15}



static void Test_D_BFu17ll_BFu15ll()
{
  {
    init_simple_test("D_BFu17ll_BFu15ll");
    static STRUCT_IF_C D_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "D_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "D_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu15ll, D_BFu17ll_BFu15ll)
//============================================================================


struct  D_BFu17ll_BFu15s  {
  double v1;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 D_BFu17ll_BFu15s) C1{ FL FL:17 Fs:15}



static void Test_D_BFu17ll_BFu15s()
{
  {
    init_simple_test("D_BFu17ll_BFu15s");
    static STRUCT_IF_C D_BFu17ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "D_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "D_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu15s, D_BFu17ll_BFu15s)
//============================================================================


struct  D_BFu17ll_BFu16i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 D_BFu17ll_BFu16i) C1{ FL FL:17 Fi:16}



static void Test_D_BFu17ll_BFu16i()
{
  {
    init_simple_test("D_BFu17ll_BFu16i");
    static STRUCT_IF_C D_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu16i, D_BFu17ll_BFu16i)
//============================================================================


struct  D_BFu17ll_BFu16ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 D_BFu17ll_BFu16ll) C1{ FL FL:17 FL:16}



static void Test_D_BFu17ll_BFu16ll()
{
  {
    init_simple_test("D_BFu17ll_BFu16ll");
    static STRUCT_IF_C D_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 1, 16, 1, "D_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 1, 16, hide_ull(1LL<<15), "D_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu16ll, D_BFu17ll_BFu16ll)
//============================================================================


struct  D_BFu17ll_BFu16s  {
  double v1;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 D_BFu17ll_BFu16s) C1{ FL FL:17 Fs:16}



static void Test_D_BFu17ll_BFu16s()
{
  {
    init_simple_test("D_BFu17ll_BFu16s");
    static STRUCT_IF_C D_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu16s, D_BFu17ll_BFu16s)
//============================================================================


struct  D_BFu17ll_BFu17i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 D_BFu17ll_BFu17i) C1{ FL FL:17 Fi:17}



static void Test_D_BFu17ll_BFu17i()
{
  {
    init_simple_test("D_BFu17ll_BFu17i");
    static STRUCT_IF_C D_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu17i, D_BFu17ll_BFu17i)
//============================================================================


struct  D_BFu17ll_BFu17ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 D_BFu17ll_BFu17ll) C1{ FL FL:17 FL:17}



static void Test_D_BFu17ll_BFu17ll()
{
  {
    init_simple_test("D_BFu17ll_BFu17ll");
    static STRUCT_IF_C D_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 1, 17, 1, "D_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 1, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu17ll, D_BFu17ll_BFu17ll)
//============================================================================


struct  D_BFu17ll_BFu1c  {
  double v1;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 D_BFu17ll_BFu1c) C1{ FL FL:17 Fc:1}



static void Test_D_BFu17ll_BFu1c()
{
  {
    init_simple_test("D_BFu17ll_BFu1c");
    static STRUCT_IF_C D_BFu17ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "D_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu1c, D_BFu17ll_BFu1c)
//============================================================================


struct  D_BFu17ll_BFu1i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 D_BFu17ll_BFu1i) C1{ FL FL:17 Fi:1}



static void Test_D_BFu17ll_BFu1i()
{
  {
    init_simple_test("D_BFu17ll_BFu1i");
    static STRUCT_IF_C D_BFu17ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "D_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu1i, D_BFu17ll_BFu1i)
//============================================================================


struct  D_BFu17ll_BFu1ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 D_BFu17ll_BFu1ll) C1{ FL FL:17 FL:1}



static void Test_D_BFu17ll_BFu1ll()
{
  {
    init_simple_test("D_BFu17ll_BFu1ll");
    static STRUCT_IF_C D_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "D_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu1ll, D_BFu17ll_BFu1ll)
//============================================================================


struct  D_BFu17ll_BFu1s  {
  double v1;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 D_BFu17ll_BFu1s) C1{ FL FL:17 Fs:1}



static void Test_D_BFu17ll_BFu1s()
{
  {
    init_simple_test("D_BFu17ll_BFu1s");
    static STRUCT_IF_C D_BFu17ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "D_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu1s, D_BFu17ll_BFu1s)
//============================================================================


struct  D_BFu17ll_BFu31i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 D_BFu17ll_BFu31i) C1{ FL FL:17 Fi:31}



static void Test_D_BFu17ll_BFu31i()
{
  {
    init_simple_test("D_BFu17ll_BFu31i");
    static STRUCT_IF_C D_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu31i, D_BFu17ll_BFu31i)
//============================================================================


struct  D_BFu17ll_BFu31ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 D_BFu17ll_BFu31ll) C1{ FL FL:17 FL:31}



static void Test_D_BFu17ll_BFu31ll()
{
  {
    init_simple_test("D_BFu17ll_BFu31ll");
    static STRUCT_IF_C D_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 10, 1, 31, 1, "D_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 10, 1, 31, hide_ull(1LL<<30), "D_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu31ll, D_BFu17ll_BFu31ll)
//============================================================================


struct  D_BFu17ll_BFu32i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 D_BFu17ll_BFu32i) C1{ FL FL:17 Fi:32}



static void Test_D_BFu17ll_BFu32i()
{
  {
    init_simple_test("D_BFu17ll_BFu32i");
    static STRUCT_IF_C D_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu32i, D_BFu17ll_BFu32i)
//============================================================================


struct  D_BFu17ll_BFu32ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 D_BFu17ll_BFu32ll) C1{ FL FL:17 FL:32}



static void Test_D_BFu17ll_BFu32ll()
{
  {
    init_simple_test("D_BFu17ll_BFu32ll");
    static STRUCT_IF_C D_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 10, 1, 32, 1, "D_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 10, 1, 32, hide_ull(1LL<<31), "D_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu32ll, D_BFu17ll_BFu32ll)
//============================================================================


struct  D_BFu17ll_BFu33  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 D_BFu17ll_BFu33) C1{ FL FL:17 FL:33}



static void Test_D_BFu17ll_BFu33()
{
  {
    init_simple_test("D_BFu17ll_BFu33");
    static STRUCT_IF_C D_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 10, 1, 33, 1, "D_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 10, 1, 33, hide_ull(1LL<<32), "D_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu33, D_BFu17ll_BFu33)
//============================================================================


struct  D_BFu17ll_BFu7c  {
  double v1;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 D_BFu17ll_BFu7c) C1{ FL FL:17 Fc:7}



static void Test_D_BFu17ll_BFu7c()
{
  {
    init_simple_test("D_BFu17ll_BFu7c");
    static STRUCT_IF_C D_BFu17ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "D_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "D_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu7c, D_BFu17ll_BFu7c)
//============================================================================


struct  D_BFu17ll_BFu7i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 D_BFu17ll_BFu7i) C1{ FL FL:17 Fi:7}



static void Test_D_BFu17ll_BFu7i()
{
  {
    init_simple_test("D_BFu17ll_BFu7i");
    static STRUCT_IF_C D_BFu17ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "D_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "D_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu7i, D_BFu17ll_BFu7i)
//============================================================================


struct  D_BFu17ll_BFu7ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 D_BFu17ll_BFu7ll) C1{ FL FL:17 FL:7}



static void Test_D_BFu17ll_BFu7ll()
{
  {
    init_simple_test("D_BFu17ll_BFu7ll");
    static STRUCT_IF_C D_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "D_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "D_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu7ll, D_BFu17ll_BFu7ll)
//============================================================================


struct  D_BFu17ll_BFu7s  {
  double v1;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 D_BFu17ll_BFu7s) C1{ FL FL:17 Fs:7}



static void Test_D_BFu17ll_BFu7s()
{
  {
    init_simple_test("D_BFu17ll_BFu7s");
    static STRUCT_IF_C D_BFu17ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "D_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "D_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu7s, D_BFu17ll_BFu7s)
//============================================================================


struct  D_BFu17ll_BFu8c  {
  double v1;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 D_BFu17ll_BFu8c) C1{ FL FL:17 Fc:8}



static void Test_D_BFu17ll_BFu8c()
{
  {
    init_simple_test("D_BFu17ll_BFu8c");
    static STRUCT_IF_C D_BFu17ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 11, 0, 8, 1, "D_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 11, 0, 8, hide_ull(1LL<<7), "D_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu8c, D_BFu17ll_BFu8c)
//============================================================================


struct  D_BFu17ll_BFu8i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 D_BFu17ll_BFu8i) C1{ FL FL:17 Fi:8}



static void Test_D_BFu17ll_BFu8i()
{
  {
    init_simple_test("D_BFu17ll_BFu8i");
    static STRUCT_IF_C D_BFu17ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "D_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "D_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu8i, D_BFu17ll_BFu8i)
//============================================================================


struct  D_BFu17ll_BFu8ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 D_BFu17ll_BFu8ll) C1{ FL FL:17 FL:8}



static void Test_D_BFu17ll_BFu8ll()
{
  {
    init_simple_test("D_BFu17ll_BFu8ll");
    static STRUCT_IF_C D_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "D_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "D_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu8ll, D_BFu17ll_BFu8ll)
//============================================================================


struct  D_BFu17ll_BFu8s  {
  double v1;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 D_BFu17ll_BFu8s) C1{ FL FL:17 Fs:8}



static void Test_D_BFu17ll_BFu8s()
{
  {
    init_simple_test("D_BFu17ll_BFu8s");
    static STRUCT_IF_C D_BFu17ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "D_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "D_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu8s, D_BFu17ll_BFu8s)
//============================================================================


struct  D_BFu17ll_BFu9i  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 D_BFu17ll_BFu9i) C1{ FL FL:17 Fi:9}



static void Test_D_BFu17ll_BFu9i()
{
  {
    init_simple_test("D_BFu17ll_BFu9i");
    static STRUCT_IF_C D_BFu17ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "D_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "D_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu9i, D_BFu17ll_BFu9i)
//============================================================================


struct  D_BFu17ll_BFu9ll  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 D_BFu17ll_BFu9ll) C1{ FL FL:17 FL:9}



static void Test_D_BFu17ll_BFu9ll()
{
  {
    init_simple_test("D_BFu17ll_BFu9ll");
    static STRUCT_IF_C D_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "D_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "D_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu9ll, D_BFu17ll_BFu9ll)
//============================================================================


struct  D_BFu17ll_BFu9s  {
  double v1;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 D_BFu17ll_BFu9s) C1{ FL FL:17 Fs:9}



static void Test_D_BFu17ll_BFu9s()
{
  {
    init_simple_test("D_BFu17ll_BFu9s");
    static STRUCT_IF_C D_BFu17ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "D_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "D_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_BFu9s, D_BFu17ll_BFu9s)
//============================================================================


struct  D_BFu17ll_C  {
  double v1;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 D_BFu17ll_C) C1{ FL FL:17 Fc}



static void Test_D_BFu17ll_C()
{
  {
    init_simple_test("D_BFu17ll_C");
    static STRUCT_IF_C D_BFu17ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_C");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_C");
    check_field_offset(lv, v3, 11, "D_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_C, D_BFu17ll_C)
//============================================================================


struct  D_BFu17ll_D  {
  double v1;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 D_BFu17ll_D) C1{ FL FL:17 FL}



static void Test_D_BFu17ll_D()
{
  {
    init_simple_test("D_BFu17ll_D");
    static STRUCT_IF_C D_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_D");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_D, D_BFu17ll_D)
//============================================================================


struct  D_BFu17ll_F  {
  double v1;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 D_BFu17ll_F) C1{ FL FL:17 Fi}



static void Test_D_BFu17ll_F()
{
  {
    init_simple_test("D_BFu17ll_F");
    static STRUCT_IF_C D_BFu17ll_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_F");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_F");
    check_field_offset(lv, v3, 12, "D_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_F, D_BFu17ll_F)
//============================================================================


struct  D_BFu17ll_I  {
  double v1;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 D_BFu17ll_I) C1{ FL FL:17 Fi}



static void Test_D_BFu17ll_I()
{
  {
    init_simple_test("D_BFu17ll_I");
    static STRUCT_IF_C D_BFu17ll_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_I");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_I");
    check_field_offset(lv, v3, 12, "D_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_I, D_BFu17ll_I)
//============================================================================


struct  D_BFu17ll_Ip  {
  double v1;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 D_BFu17ll_Ip) C1{ FL FL:17 Fp}



static void Test_D_BFu17ll_Ip()
{
  {
    init_simple_test("D_BFu17ll_Ip");
    static STRUCT_IF_C D_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_Ip, D_BFu17ll_Ip)
//============================================================================


struct  D_BFu17ll_L  {
  double v1;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 D_BFu17ll_L) C1{ FL FL:17 FL}



static void Test_D_BFu17ll_L()
{
  {
    init_simple_test("D_BFu17ll_L");
    static STRUCT_IF_C D_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_L");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_L, D_BFu17ll_L)
//============================================================================


struct  D_BFu17ll_S  {
  double v1;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 D_BFu17ll_S) C1{ FL FL:17 Fs}



static void Test_D_BFu17ll_S()
{
  {
    init_simple_test("D_BFu17ll_S");
    static STRUCT_IF_C D_BFu17ll_S lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_S");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_S");
    check_field_offset(lv, v3, 12, "D_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_S, D_BFu17ll_S)
//============================================================================


struct  D_BFu17ll_Uc  {
  double v1;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 D_BFu17ll_Uc) C1{ FL FL:17 Fc}



static void Test_D_BFu17ll_Uc()
{
  {
    init_simple_test("D_BFu17ll_Uc");
    static STRUCT_IF_C D_BFu17ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_Uc");
    check_field_offset(lv, v3, 11, "D_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_Uc, D_BFu17ll_Uc)
//============================================================================


struct  D_BFu17ll_Ui  {
  double v1;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 D_BFu17ll_Ui) C1{ FL FL:17 Fi}



static void Test_D_BFu17ll_Ui()
{
  {
    init_simple_test("D_BFu17ll_Ui");
    static STRUCT_IF_C D_BFu17ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_Ui");
    check_field_offset(lv, v3, 12, "D_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_Ui, D_BFu17ll_Ui)
//============================================================================


struct  D_BFu17ll_Ul  {
  double v1;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 D_BFu17ll_Ul) C1{ FL FL:17 FL}



static void Test_D_BFu17ll_Ul()
{
  {
    init_simple_test("D_BFu17ll_Ul");
    static STRUCT_IF_C D_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_Ul, D_BFu17ll_Ul)
//============================================================================


struct  D_BFu17ll_Us  {
  double v1;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 D_BFu17ll_Us) C1{ FL FL:17 Fs}



static void Test_D_BFu17ll_Us()
{
  {
    init_simple_test("D_BFu17ll_Us");
    static STRUCT_IF_C D_BFu17ll_Us lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_Us");
    check_field_offset(lv, v3, 12, "D_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_Us, D_BFu17ll_Us)
//============================================================================


struct  D_BFu17ll_Vp  {
  double v1;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 D_BFu17ll_Vp) C1{ FL FL:17 Fp}



static void Test_D_BFu17ll_Vp()
{
  {
    init_simple_test("D_BFu17ll_Vp");
    static STRUCT_IF_C D_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu17ll_Vp, D_BFu17ll_Vp)
//============================================================================


struct  D_BFu1c  {
  double v1;
  unsigned char v2:1;
};
//SIG(1 D_BFu1c) C1{ FL Fc:1}



static void Test_D_BFu1c()
{
  {
    init_simple_test("D_BFu1c");
    static STRUCT_IF_C D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c, D_BFu1c)
//============================================================================


struct  D_BFu1c_BFu15i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 D_BFu1c_BFu15i) C1{ FL Fc:1 Fi:15}



static void Test_D_BFu1c_BFu15i()
{
  {
    init_simple_test("D_BFu1c_BFu15i");
    static STRUCT_IF_C D_BFu1c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "D_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "D_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu15i, D_BFu1c_BFu15i)
//============================================================================


struct  D_BFu1c_BFu15ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 D_BFu1c_BFu15ll) C1{ FL Fc:1 FL:15}



static void Test_D_BFu1c_BFu15ll()
{
  {
    init_simple_test("D_BFu1c_BFu15ll");
    static STRUCT_IF_C D_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "D_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "D_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu15ll, D_BFu1c_BFu15ll)
//============================================================================


struct  D_BFu1c_BFu15s  {
  double v1;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 D_BFu1c_BFu15s) C1{ FL Fc:1 Fs:15}



static void Test_D_BFu1c_BFu15s()
{
  {
    init_simple_test("D_BFu1c_BFu15s");
    static STRUCT_IF_C D_BFu1c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "D_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "D_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu15s, D_BFu1c_BFu15s)
//============================================================================


struct  D_BFu1c_BFu16i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 D_BFu1c_BFu16i) C1{ FL Fc:1 Fi:16}



static void Test_D_BFu1c_BFu16i()
{
  {
    init_simple_test("D_BFu1c_BFu16i");
    static STRUCT_IF_C D_BFu1c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "D_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "D_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu16i, D_BFu1c_BFu16i)
//============================================================================


struct  D_BFu1c_BFu16ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 D_BFu1c_BFu16ll) C1{ FL Fc:1 FL:16}



static void Test_D_BFu1c_BFu16ll()
{
  {
    init_simple_test("D_BFu1c_BFu16ll");
    static STRUCT_IF_C D_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "D_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "D_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu16ll, D_BFu1c_BFu16ll)
//============================================================================


struct  D_BFu1c_BFu16s  {
  double v1;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 D_BFu1c_BFu16s) C1{ FL Fc:1 Fs:16}



static void Test_D_BFu1c_BFu16s()
{
  {
    init_simple_test("D_BFu1c_BFu16s");
    static STRUCT_IF_C D_BFu1c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu16s, D_BFu1c_BFu16s)
//============================================================================


struct  D_BFu1c_BFu17i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 D_BFu1c_BFu17i) C1{ FL Fc:1 Fi:17}



static void Test_D_BFu1c_BFu17i()
{
  {
    init_simple_test("D_BFu1c_BFu17i");
    static STRUCT_IF_C D_BFu1c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "D_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "D_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu17i, D_BFu1c_BFu17i)
//============================================================================


struct  D_BFu1c_BFu17ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 D_BFu1c_BFu17ll) C1{ FL Fc:1 FL:17}



static void Test_D_BFu1c_BFu17ll()
{
  {
    init_simple_test("D_BFu1c_BFu17ll");
    static STRUCT_IF_C D_BFu1c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "D_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "D_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu17ll, D_BFu1c_BFu17ll)
//============================================================================


struct  D_BFu1c_BFu1c  {
  double v1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 D_BFu1c_BFu1c) C1{ FL Fc:1 Fc:1}



static void Test_D_BFu1c_BFu1c()
{
  {
    init_simple_test("D_BFu1c_BFu1c");
    static STRUCT_IF_C D_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "D_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu1c, D_BFu1c_BFu1c)
//============================================================================


struct  D_BFu1c_BFu1i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 D_BFu1c_BFu1i) C1{ FL Fc:1 Fi:1}



static void Test_D_BFu1c_BFu1i()
{
  {
    init_simple_test("D_BFu1c_BFu1i");
    static STRUCT_IF_C D_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "D_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu1i, D_BFu1c_BFu1i)
//============================================================================


struct  D_BFu1c_BFu1ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 D_BFu1c_BFu1ll) C1{ FL Fc:1 FL:1}



static void Test_D_BFu1c_BFu1ll()
{
  {
    init_simple_test("D_BFu1c_BFu1ll");
    static STRUCT_IF_C D_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "D_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu1ll, D_BFu1c_BFu1ll)
//============================================================================


struct  D_BFu1c_BFu1s  {
  double v1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 D_BFu1c_BFu1s) C1{ FL Fc:1 Fs:1}



static void Test_D_BFu1c_BFu1s()
{
  {
    init_simple_test("D_BFu1c_BFu1s");
    static STRUCT_IF_C D_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "D_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu1s, D_BFu1c_BFu1s)
//============================================================================


struct  D_BFu1c_BFu31i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 D_BFu1c_BFu31i) C1{ FL Fc:1 Fi:31}



static void Test_D_BFu1c_BFu31i()
{
  {
    init_simple_test("D_BFu1c_BFu31i");
    static STRUCT_IF_C D_BFu1c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "D_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "D_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu31i, D_BFu1c_BFu31i)
//============================================================================


struct  D_BFu1c_BFu31ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 D_BFu1c_BFu31ll) C1{ FL Fc:1 FL:31}



static void Test_D_BFu1c_BFu31ll()
{
  {
    init_simple_test("D_BFu1c_BFu31ll");
    static STRUCT_IF_C D_BFu1c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "D_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "D_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu31ll, D_BFu1c_BFu31ll)
//============================================================================


struct  D_BFu1c_BFu32i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 D_BFu1c_BFu32i) C1{ FL Fc:1 Fi:32}



static void Test_D_BFu1c_BFu32i()
{
  {
    init_simple_test("D_BFu1c_BFu32i");
    static STRUCT_IF_C D_BFu1c_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu1c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu32i, D_BFu1c_BFu32i)
//============================================================================


struct  D_BFu1c_BFu32ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 D_BFu1c_BFu32ll) C1{ FL Fc:1 FL:32}



static void Test_D_BFu1c_BFu32ll()
{
  {
    init_simple_test("D_BFu1c_BFu32ll");
    static STRUCT_IF_C D_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "D_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "D_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu32ll, D_BFu1c_BFu32ll)
//============================================================================


struct  D_BFu1c_BFu33  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 D_BFu1c_BFu33) C1{ FL Fc:1 FL:33}



static void Test_D_BFu1c_BFu33()
{
  {
    init_simple_test("D_BFu1c_BFu33");
    static STRUCT_IF_C D_BFu1c_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, 1, "D_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, hide_ull(1LL<<32), "D_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu33, D_BFu1c_BFu33)
//============================================================================


struct  D_BFu1c_BFu7c  {
  double v1;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 D_BFu1c_BFu7c) C1{ FL Fc:1 Fc:7}



static void Test_D_BFu1c_BFu7c()
{
  {
    init_simple_test("D_BFu1c_BFu7c");
    static STRUCT_IF_C D_BFu1c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "D_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "D_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu7c, D_BFu1c_BFu7c)
//============================================================================


struct  D_BFu1c_BFu7i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 D_BFu1c_BFu7i) C1{ FL Fc:1 Fi:7}



static void Test_D_BFu1c_BFu7i()
{
  {
    init_simple_test("D_BFu1c_BFu7i");
    static STRUCT_IF_C D_BFu1c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "D_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "D_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu7i, D_BFu1c_BFu7i)
//============================================================================


struct  D_BFu1c_BFu7ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 D_BFu1c_BFu7ll) C1{ FL Fc:1 FL:7}



static void Test_D_BFu1c_BFu7ll()
{
  {
    init_simple_test("D_BFu1c_BFu7ll");
    static STRUCT_IF_C D_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "D_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "D_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu7ll, D_BFu1c_BFu7ll)
//============================================================================


struct  D_BFu1c_BFu7s  {
  double v1;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 D_BFu1c_BFu7s) C1{ FL Fc:1 Fs:7}



static void Test_D_BFu1c_BFu7s()
{
  {
    init_simple_test("D_BFu1c_BFu7s");
    static STRUCT_IF_C D_BFu1c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "D_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "D_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu7s, D_BFu1c_BFu7s)
//============================================================================


struct  D_BFu1c_BFu8c  {
  double v1;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 D_BFu1c_BFu8c) C1{ FL Fc:1 Fc:8}



static void Test_D_BFu1c_BFu8c()
{
  {
    init_simple_test("D_BFu1c_BFu8c");
    static STRUCT_IF_C D_BFu1c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu8c, D_BFu1c_BFu8c)
//============================================================================


struct  D_BFu1c_BFu8i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 D_BFu1c_BFu8i) C1{ FL Fc:1 Fi:8}



static void Test_D_BFu1c_BFu8i()
{
  {
    init_simple_test("D_BFu1c_BFu8i");
    static STRUCT_IF_C D_BFu1c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "D_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "D_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu8i, D_BFu1c_BFu8i)
//============================================================================


struct  D_BFu1c_BFu8ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 D_BFu1c_BFu8ll) C1{ FL Fc:1 FL:8}



static void Test_D_BFu1c_BFu8ll()
{
  {
    init_simple_test("D_BFu1c_BFu8ll");
    static STRUCT_IF_C D_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "D_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "D_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu8ll, D_BFu1c_BFu8ll)
//============================================================================


struct  D_BFu1c_BFu8s  {
  double v1;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 D_BFu1c_BFu8s) C1{ FL Fc:1 Fs:8}



static void Test_D_BFu1c_BFu8s()
{
  {
    init_simple_test("D_BFu1c_BFu8s");
    static STRUCT_IF_C D_BFu1c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "D_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "D_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu8s, D_BFu1c_BFu8s)
//============================================================================


struct  D_BFu1c_BFu9i  {
  double v1;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 D_BFu1c_BFu9i) C1{ FL Fc:1 Fi:9}



static void Test_D_BFu1c_BFu9i()
{
  {
    init_simple_test("D_BFu1c_BFu9i");
    static STRUCT_IF_C D_BFu1c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "D_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "D_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu9i, D_BFu1c_BFu9i)
//============================================================================


struct  D_BFu1c_BFu9ll  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 D_BFu1c_BFu9ll) C1{ FL Fc:1 FL:9}



static void Test_D_BFu1c_BFu9ll()
{
  {
    init_simple_test("D_BFu1c_BFu9ll");
    static STRUCT_IF_C D_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "D_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "D_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu9ll, D_BFu1c_BFu9ll)
//============================================================================


struct  D_BFu1c_BFu9s  {
  double v1;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 D_BFu1c_BFu9s) C1{ FL Fc:1 Fs:9}



static void Test_D_BFu1c_BFu9s()
{
  {
    init_simple_test("D_BFu1c_BFu9s");
    static STRUCT_IF_C D_BFu1c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "D_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "D_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_BFu9s, D_BFu1c_BFu9s)
//============================================================================


struct  D_BFu1c_C  {
  double v1;
  unsigned char v2:1;
  char v3;
};
//SIG(1 D_BFu1c_C) C1{ FL Fc:1 Fc}



static void Test_D_BFu1c_C()
{
  {
    init_simple_test("D_BFu1c_C");
    static STRUCT_IF_C D_BFu1c_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_C)");
    check_field_offset(lv, v1, 0, "D_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_C");
    check_field_offset(lv, v3, 9, "D_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_C, D_BFu1c_C)
//============================================================================


struct  D_BFu1c_D  {
  double v1;
  unsigned char v2:1;
  double v3;
};
//SIG(1 D_BFu1c_D) C1{ FL Fc:1 FL}



static void Test_D_BFu1c_D()
{
  {
    init_simple_test("D_BFu1c_D");
    static STRUCT_IF_C D_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_D)");
    check_field_offset(lv, v1, 0, "D_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_D, D_BFu1c_D)
//============================================================================


struct  D_BFu1c_F  {
  double v1;
  unsigned char v2:1;
  float v3;
};
//SIG(1 D_BFu1c_F) C1{ FL Fc:1 Fi}



static void Test_D_BFu1c_F()
{
  {
    init_simple_test("D_BFu1c_F");
    static STRUCT_IF_C D_BFu1c_F lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu1c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_F)");
    check_field_offset(lv, v1, 0, "D_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_F");
    check_field_offset(lv, v3, 12, "D_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_F, D_BFu1c_F)
//============================================================================


struct  D_BFu1c_I  {
  double v1;
  unsigned char v2:1;
  int v3;
};
//SIG(1 D_BFu1c_I) C1{ FL Fc:1 Fi}



static void Test_D_BFu1c_I()
{
  {
    init_simple_test("D_BFu1c_I");
    static STRUCT_IF_C D_BFu1c_I lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu1c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_I)");
    check_field_offset(lv, v1, 0, "D_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_I");
    check_field_offset(lv, v3, 12, "D_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_I, D_BFu1c_I)
//============================================================================


struct  D_BFu1c_Ip  {
  double v1;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 D_BFu1c_Ip) C1{ FL Fc:1 Fp}



static void Test_D_BFu1c_Ip()
{
  {
    init_simple_test("D_BFu1c_Ip");
    static STRUCT_IF_C D_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_Ip, D_BFu1c_Ip)
//============================================================================


struct  D_BFu1c_L  {
  double v1;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 D_BFu1c_L) C1{ FL Fc:1 FL}



static void Test_D_BFu1c_L()
{
  {
    init_simple_test("D_BFu1c_L");
    static STRUCT_IF_C D_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_L)");
    check_field_offset(lv, v1, 0, "D_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_L, D_BFu1c_L)
//============================================================================


struct  D_BFu1c_S  {
  double v1;
  unsigned char v2:1;
  short v3;
};
//SIG(1 D_BFu1c_S) C1{ FL Fc:1 Fs}



static void Test_D_BFu1c_S()
{
  {
    init_simple_test("D_BFu1c_S");
    static STRUCT_IF_C D_BFu1c_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_S)");
    check_field_offset(lv, v1, 0, "D_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_S");
    check_field_offset(lv, v3, 10, "D_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_S, D_BFu1c_S)
//============================================================================


struct  D_BFu1c_Uc  {
  double v1;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 D_BFu1c_Uc) C1{ FL Fc:1 Fc}



static void Test_D_BFu1c_Uc()
{
  {
    init_simple_test("D_BFu1c_Uc");
    static STRUCT_IF_C D_BFu1c_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_Uc");
    check_field_offset(lv, v3, 9, "D_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_Uc, D_BFu1c_Uc)
//============================================================================


struct  D_BFu1c_Ui  {
  double v1;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 D_BFu1c_Ui) C1{ FL Fc:1 Fi}



static void Test_D_BFu1c_Ui()
{
  {
    init_simple_test("D_BFu1c_Ui");
    static STRUCT_IF_C D_BFu1c_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu1c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_Ui");
    check_field_offset(lv, v3, 12, "D_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_Ui, D_BFu1c_Ui)
//============================================================================


struct  D_BFu1c_Ul  {
  double v1;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 D_BFu1c_Ul) C1{ FL Fc:1 FL}



static void Test_D_BFu1c_Ul()
{
  {
    init_simple_test("D_BFu1c_Ul");
    static STRUCT_IF_C D_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_Ul, D_BFu1c_Ul)
//============================================================================


struct  D_BFu1c_Us  {
  double v1;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 D_BFu1c_Us) C1{ FL Fc:1 Fs}



static void Test_D_BFu1c_Us()
{
  {
    init_simple_test("D_BFu1c_Us");
    static STRUCT_IF_C D_BFu1c_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "D_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_Us");
    check_field_offset(lv, v3, 10, "D_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_Us, D_BFu1c_Us)
//============================================================================


struct  D_BFu1c_Vp  {
  double v1;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 D_BFu1c_Vp) C1{ FL Fc:1 Fp}



static void Test_D_BFu1c_Vp()
{
  {
    init_simple_test("D_BFu1c_Vp");
    static STRUCT_IF_C D_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1c_Vp, D_BFu1c_Vp)
//============================================================================


struct  D_BFu1i  {
  double v1;
  unsigned int v2:1;
};
//SIG(1 D_BFu1i) C1{ FL Fi:1}



static void Test_D_BFu1i()
{
  {
    init_simple_test("D_BFu1i");
    static STRUCT_IF_C D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1i, D_BFu1i)
//============================================================================


struct  D_BFu1i_BFu15i  {
  double v1;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 D_BFu1i_BFu15i) C1{ FL Fi:1 Fi:15}



static void Test_D_BFu1i_BFu15i()
{
  {
    init_simple_test("D_BFu1i_BFu15i");
    static STRUCT_IF_C D_BFu1i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "D_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "D_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu1i_BFu15i, D_BFu1i_BFu15i)
//============================================================================


struct  D_BFu1i_BFu15ll  {
  double v1;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 D_BFu1i_BFu15ll) C1{ FL Fi:1 FL:15}



static void Test_D_BFu1i_BFu15ll()
{
  {
    init_simple_test("D_BFu1i_BFu15ll");
    static STRUCT_IF_C D_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, 1,