// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFu8i_BFu33_BFu31i  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu33_BFu31i) C1{ Fi:8 FL:33 Fi:31}



static void Test_BFu8i_BFu33_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu33_BFu31i");
    static STRUCT_IF_C BFu8i_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu8i_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu31i, BFu8i_BFu33_BFu31i)
//============================================================================


struct  BFu8i_BFu33_BFu31ll  {
  unsigned int v1:8;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu33_BFu31ll) C1{ Fi:8 FL:33 FL:31}



static void Test_BFu8i_BFu33_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu33_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, 1, "BFu8i_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, hide_ull(1LL<<30), "BFu8i_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu31ll, BFu8i_BFu33_BFu31ll)
//============================================================================


struct  BFu8i_BFu33_BFu32i  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu33_BFu32i) C1{ Fi:8 FL:33 Fi:32}



static void Test_BFu8i_BFu33_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu33_BFu32i");
    static STRUCT_IF_C BFu8i_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu8i_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu32i, BFu8i_BFu33_BFu32i)
//============================================================================


struct  BFu8i_BFu33_BFu32ll  {
  unsigned int v1:8;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu33_BFu32ll) C1{ Fi:8 FL:33 FL:32}



static void Test_BFu8i_BFu33_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu33_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, 1, "BFu8i_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu8i_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu32ll, BFu8i_BFu33_BFu32ll)
//============================================================================


struct  BFu8i_BFu33_BFu33  {
  unsigned int v1:8;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu33_BFu33) C1{ Fi:8 FL:33 FL:33}



static void Test_BFu8i_BFu33_BFu33()
{
  {
    init_simple_test("BFu8i_BFu33_BFu33");
    static STRUCT_IF_C BFu8i_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, 1, "BFu8i_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu33, BFu8i_BFu33_BFu33)
//============================================================================


struct  BFu8i_BFu33_BFu7c  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu33_BFu7c) C1{ Fi:8 FL:33 Fc:7}



static void Test_BFu8i_BFu33_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu33_BFu7c");
    static STRUCT_IF_C BFu8i_BFu33_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "BFu8i_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu7c, BFu8i_BFu33_BFu7c)
//============================================================================


struct  BFu8i_BFu33_BFu7i  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu33_BFu7i) C1{ Fi:8 FL:33 Fi:7}



static void Test_BFu8i_BFu33_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu33_BFu7i");
    static STRUCT_IF_C BFu8i_BFu33_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "BFu8i_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu7i, BFu8i_BFu33_BFu7i)
//============================================================================


struct  BFu8i_BFu33_BFu7ll  {
  unsigned int v1:8;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu33_BFu7ll) C1{ Fi:8 FL:33 FL:7}



static void Test_BFu8i_BFu33_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu33_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu33_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "BFu8i_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu7ll, BFu8i_BFu33_BFu7ll)
//============================================================================


struct  BFu8i_BFu33_BFu7s  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu33_BFu7s) C1{ Fi:8 FL:33 Fs:7}



static void Test_BFu8i_BFu33_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu33_BFu7s");
    static STRUCT_IF_C BFu8i_BFu33_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "BFu8i_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu7s, BFu8i_BFu33_BFu7s)
//============================================================================


struct  BFu8i_BFu33_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu33_BFu8c) C1{ Fi:8 FL:33 Fc:8}



static void Test_BFu8i_BFu33_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu33_BFu8c");
    static STRUCT_IF_C BFu8i_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu8i_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu8c, BFu8i_BFu33_BFu8c)
//============================================================================


struct  BFu8i_BFu33_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu33_BFu8i) C1{ Fi:8 FL:33 Fi:8}



static void Test_BFu8i_BFu33_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu33_BFu8i");
    static STRUCT_IF_C BFu8i_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "BFu8i_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu8i, BFu8i_BFu33_BFu8i)
//============================================================================


struct  BFu8i_BFu33_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu33_BFu8ll) C1{ Fi:8 FL:33 FL:8}



static void Test_BFu8i_BFu33_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu33_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "BFu8i_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu8ll, BFu8i_BFu33_BFu8ll)
//============================================================================


struct  BFu8i_BFu33_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu33_BFu8s) C1{ Fi:8 FL:33 Fs:8}



static void Test_BFu8i_BFu33_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu33_BFu8s");
    static STRUCT_IF_C BFu8i_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu8i_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu8s, BFu8i_BFu33_BFu8s)
//============================================================================


struct  BFu8i_BFu33_BFu9i  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu33_BFu9i) C1{ Fi:8 FL:33 Fi:9}



static void Test_BFu8i_BFu33_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu33_BFu9i");
    static STRUCT_IF_C BFu8i_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "BFu8i_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu9i, BFu8i_BFu33_BFu9i)
//============================================================================


struct  BFu8i_BFu33_BFu9ll  {
  unsigned int v1:8;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu33_BFu9ll) C1{ Fi:8 FL:33 FL:9}



static void Test_BFu8i_BFu33_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu33_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "BFu8i_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu9ll, BFu8i_BFu33_BFu9ll)
//============================================================================


struct  BFu8i_BFu33_BFu9s  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu33_BFu9s) C1{ Fi:8 FL:33 Fs:9}



static void Test_BFu8i_BFu33_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu33_BFu9s");
    static STRUCT_IF_C BFu8i_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu8i_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_BFu9s, BFu8i_BFu33_BFu9s)
//============================================================================


struct  BFu8i_BFu33_C  {
  unsigned int v1:8;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 BFu8i_BFu33_C) C1{ Fi:8 FL:33 Fc}



static void Test_BFu8i_BFu33_C()
{
  {
    init_simple_test("BFu8i_BFu33_C");
    static STRUCT_IF_C BFu8i_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_C");
    check_field_offset(lv, v3, 6, "BFu8i_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_C, BFu8i_BFu33_C)
//============================================================================


struct  BFu8i_BFu33_D  {
  unsigned int v1:8;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 BFu8i_BFu33_D) C1{ Fi:8 FL:33 FL}



static void Test_BFu8i_BFu33_D()
{
  {
    init_simple_test("BFu8i_BFu33_D");
    static STRUCT_IF_C BFu8i_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_D");
    check_field_offset(lv, v3, 8, "BFu8i_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_D, BFu8i_BFu33_D)
//============================================================================


struct  BFu8i_BFu33_F  {
  unsigned int v1:8;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 BFu8i_BFu33_F) C1{ Fi:8 FL:33 Fi}



static void Test_BFu8i_BFu33_F()
{
  {
    init_simple_test("BFu8i_BFu33_F");
    static STRUCT_IF_C BFu8i_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_F");
    check_field_offset(lv, v3, 8, "BFu8i_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_F, BFu8i_BFu33_F)
//============================================================================


struct  BFu8i_BFu33_I  {
  unsigned int v1:8;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 BFu8i_BFu33_I) C1{ Fi:8 FL:33 Fi}



static void Test_BFu8i_BFu33_I()
{
  {
    init_simple_test("BFu8i_BFu33_I");
    static STRUCT_IF_C BFu8i_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_I");
    check_field_offset(lv, v3, 8, "BFu8i_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_I, BFu8i_BFu33_I)
//============================================================================


struct  BFu8i_BFu33_Ip  {
  unsigned int v1:8;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 BFu8i_BFu33_Ip) C1{ Fi:8 FL:33 Fp}



static void Test_BFu8i_BFu33_Ip()
{
  {
    init_simple_test("BFu8i_BFu33_Ip");
    static STRUCT_IF_C BFu8i_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_Ip");
    check_field_offset(lv, v3, 8, "BFu8i_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_Ip, BFu8i_BFu33_Ip)
//============================================================================


struct  BFu8i_BFu33_L  {
  unsigned int v1:8;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu33_L) C1{ Fi:8 FL:33 FL}



static void Test_BFu8i_BFu33_L()
{
  {
    init_simple_test("BFu8i_BFu33_L");
    static STRUCT_IF_C BFu8i_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_L");
    check_field_offset(lv, v3, 8, "BFu8i_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_L, BFu8i_BFu33_L)
//============================================================================


struct  BFu8i_BFu33_S  {
  unsigned int v1:8;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 BFu8i_BFu33_S) C1{ Fi:8 FL:33 Fs}



static void Test_BFu8i_BFu33_S()
{
  {
    init_simple_test("BFu8i_BFu33_S");
    static STRUCT_IF_C BFu8i_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_S");
    check_field_offset(lv, v3, 6, "BFu8i_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_S, BFu8i_BFu33_S)
//============================================================================


struct  BFu8i_BFu33_Uc  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu33_Uc) C1{ Fi:8 FL:33 Fc}



static void Test_BFu8i_BFu33_Uc()
{
  {
    init_simple_test("BFu8i_BFu33_Uc");
    static STRUCT_IF_C BFu8i_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_Uc");
    check_field_offset(lv, v3, 6, "BFu8i_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_Uc, BFu8i_BFu33_Uc)
//============================================================================


struct  BFu8i_BFu33_Ui  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu33_Ui) C1{ Fi:8 FL:33 Fi}



static void Test_BFu8i_BFu33_Ui()
{
  {
    init_simple_test("BFu8i_BFu33_Ui");
    static STRUCT_IF_C BFu8i_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_Ui");
    check_field_offset(lv, v3, 8, "BFu8i_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_Ui, BFu8i_BFu33_Ui)
//============================================================================


struct  BFu8i_BFu33_Ul  {
  unsigned int v1:8;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu33_Ul) C1{ Fi:8 FL:33 FL}



static void Test_BFu8i_BFu33_Ul()
{
  {
    init_simple_test("BFu8i_BFu33_Ul");
    static STRUCT_IF_C BFu8i_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_Ul");
    check_field_offset(lv, v3, 8, "BFu8i_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_Ul, BFu8i_BFu33_Ul)
//============================================================================


struct  BFu8i_BFu33_Us  {
  unsigned int v1:8;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu33_Us) C1{ Fi:8 FL:33 Fs}



static void Test_BFu8i_BFu33_Us()
{
  {
    init_simple_test("BFu8i_BFu33_Us");
    static STRUCT_IF_C BFu8i_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_Us");
    check_field_offset(lv, v3, 6, "BFu8i_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_Us, BFu8i_BFu33_Us)
//============================================================================


struct  BFu8i_BFu33_Vp  {
  unsigned int v1:8;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 BFu8i_BFu33_Vp) C1{ Fi:8 FL:33 Fp}



static void Test_BFu8i_BFu33_Vp()
{
  {
    init_simple_test("BFu8i_BFu33_Vp");
    static STRUCT_IF_C BFu8i_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_Vp");
    check_field_offset(lv, v3, 8, "BFu8i_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_Vp, BFu8i_BFu33_Vp)
//============================================================================


struct  BFu8i_BFu7c  {
  unsigned int v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu8i_BFu7c) C1{ Fi:8 Fc:7}



static void Test_BFu8i_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu7c");
    static STRUCT_IF_C BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c, BFu8i_BFu7c)
//============================================================================


struct  BFu8i_BFu7c_BFu15i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu7c_BFu15i) C1{ Fi:8 Fc:7 Fi:15}



static void Test_BFu8i_BFu7c_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu15i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "BFu8i_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "BFu8i_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu15i, BFu8i_BFu7c_BFu15i)
//============================================================================


struct  BFu8i_BFu7c_BFu15ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu7c_BFu15ll) C1{ Fi:8 Fc:7 FL:15}



static void Test_BFu8i_BFu7c_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "BFu8i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "BFu8i_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu15ll, BFu8i_BFu7c_BFu15ll)
//============================================================================


struct  BFu8i_BFu7c_BFu15s  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu7c_BFu15s) C1{ Fi:8 Fc:7 Fs:15}



static void Test_BFu8i_BFu7c_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu15s");
    static STRUCT_IF_C BFu8i_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu15s, BFu8i_BFu7c_BFu15s)
//============================================================================


struct  BFu8i_BFu7c_BFu16i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu7c_BFu16i) C1{ Fi:8 Fc:7 Fi:16}



static void Test_BFu8i_BFu7c_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu16i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "BFu8i_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "BFu8i_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu16i, BFu8i_BFu7c_BFu16i)
//============================================================================


struct  BFu8i_BFu7c_BFu16ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu7c_BFu16ll) C1{ Fi:8 Fc:7 FL:16}



static void Test_BFu8i_BFu7c_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "BFu8i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "BFu8i_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu16ll, BFu8i_BFu7c_BFu16ll)
//============================================================================


struct  BFu8i_BFu7c_BFu16s  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu7c_BFu16s) C1{ Fi:8 Fc:7 Fs:16}



static void Test_BFu8i_BFu7c_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu16s");
    static STRUCT_IF_C BFu8i_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu16s, BFu8i_BFu7c_BFu16s)
//============================================================================


struct  BFu8i_BFu7c_BFu17i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu7c_BFu17i) C1{ Fi:8 Fc:7 Fi:17}



static void Test_BFu8i_BFu7c_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu17i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "BFu8i_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "BFu8i_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu17i, BFu8i_BFu7c_BFu17i)
//============================================================================


struct  BFu8i_BFu7c_BFu17ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu7c_BFu17ll) C1{ Fi:8 Fc:7 FL:17}



static void Test_BFu8i_BFu7c_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "BFu8i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "BFu8i_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu17ll, BFu8i_BFu7c_BFu17ll)
//============================================================================


struct  BFu8i_BFu7c_BFu1c  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu7c_BFu1c) C1{ Fi:8 Fc:7 Fc:1}



static void Test_BFu8i_BFu7c_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu1c");
    static STRUCT_IF_C BFu8i_BFu7c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu1c, BFu8i_BFu7c_BFu1c)
//============================================================================


struct  BFu8i_BFu7c_BFu1i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu7c_BFu1i) C1{ Fi:8 Fc:7 Fi:1}



static void Test_BFu8i_BFu7c_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu1i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu1i, BFu8i_BFu7c_BFu1i)
//============================================================================


struct  BFu8i_BFu7c_BFu1ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu7c_BFu1ll) C1{ Fi:8 Fc:7 FL:1}



static void Test_BFu8i_BFu7c_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu1ll, BFu8i_BFu7c_BFu1ll)
//============================================================================


struct  BFu8i_BFu7c_BFu1s  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu7c_BFu1s) C1{ Fi:8 Fc:7 Fs:1}



static void Test_BFu8i_BFu7c_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu1s");
    static STRUCT_IF_C BFu8i_BFu7c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu1s, BFu8i_BFu7c_BFu1s)
//============================================================================


struct  BFu8i_BFu7c_BFu31i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu7c_BFu31i) C1{ Fi:8 Fc:7 Fi:31}



static void Test_BFu8i_BFu7c_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu31i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu31i, BFu8i_BFu7c_BFu31i)
//============================================================================


struct  BFu8i_BFu7c_BFu31ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu7c_BFu31ll) C1{ Fi:8 Fc:7 FL:31}



static void Test_BFu8i_BFu7c_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "BFu8i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "BFu8i_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu31ll, BFu8i_BFu7c_BFu31ll)
//============================================================================


struct  BFu8i_BFu7c_BFu32i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu7c_BFu32i) C1{ Fi:8 Fc:7 Fi:32}



static void Test_BFu8i_BFu7c_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu32i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu32i, BFu8i_BFu7c_BFu32i)
//============================================================================


struct  BFu8i_BFu7c_BFu32ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu7c_BFu32ll) C1{ Fi:8 Fc:7 FL:32}



static void Test_BFu8i_BFu7c_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "BFu8i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "BFu8i_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu32ll, BFu8i_BFu7c_BFu32ll)
//============================================================================


struct  BFu8i_BFu7c_BFu33  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu7c_BFu33) C1{ Fi:8 Fc:7 FL:33}



static void Test_BFu8i_BFu7c_BFu33()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu33");
    static STRUCT_IF_C BFu8i_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "BFu8i_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "BFu8i_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu33, BFu8i_BFu7c_BFu33)
//============================================================================


struct  BFu8i_BFu7c_BFu7c  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu7c_BFu7c) C1{ Fi:8 Fc:7 Fc:7}



static void Test_BFu8i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu7c");
    static STRUCT_IF_C BFu8i_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu7c, BFu8i_BFu7c_BFu7c)
//============================================================================


struct  BFu8i_BFu7c_BFu7i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu7c_BFu7i) C1{ Fi:8 Fc:7 Fi:7}



static void Test_BFu8i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu7i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFu8i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu7i, BFu8i_BFu7c_BFu7i)
//============================================================================


struct  BFu8i_BFu7c_BFu7ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu7c_BFu7ll) C1{ Fi:8 Fc:7 FL:7}



static void Test_BFu8i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFu8i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu7ll, BFu8i_BFu7c_BFu7ll)
//============================================================================


struct  BFu8i_BFu7c_BFu7s  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu7c_BFu7s) C1{ Fi:8 Fc:7 Fs:7}



static void Test_BFu8i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu7s");
    static STRUCT_IF_C BFu8i_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu7s, BFu8i_BFu7c_BFu7s)
//============================================================================


struct  BFu8i_BFu7c_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu7c_BFu8c) C1{ Fi:8 Fc:7 Fc:8}



static void Test_BFu8i_BFu7c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu7c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu8c, BFu8i_BFu7c_BFu8c)
//============================================================================


struct  BFu8i_BFu7c_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu7c_BFu8i) C1{ Fi:8 Fc:7 Fi:8}



static void Test_BFu8i_BFu7c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "BFu8i_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu8i, BFu8i_BFu7c_BFu8i)
//============================================================================


struct  BFu8i_BFu7c_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu7c_BFu8ll) C1{ Fi:8 Fc:7 FL:8}



static void Test_BFu8i_BFu7c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "BFu8i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu8ll, BFu8i_BFu7c_BFu8ll)
//============================================================================


struct  BFu8i_BFu7c_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu7c_BFu8s) C1{ Fi:8 Fc:7 Fs:8}



static void Test_BFu8i_BFu7c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu7c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu8s, BFu8i_BFu7c_BFu8s)
//============================================================================


struct  BFu8i_BFu7c_BFu9i  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu7c_BFu9i) C1{ Fi:8 Fc:7 Fi:9}



static void Test_BFu8i_BFu7c_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu9i");
    static STRUCT_IF_C BFu8i_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "BFu8i_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "BFu8i_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu9i, BFu8i_BFu7c_BFu9i)
//============================================================================


struct  BFu8i_BFu7c_BFu9ll  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu7c_BFu9ll) C1{ Fi:8 Fc:7 FL:9}



static void Test_BFu8i_BFu7c_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "BFu8i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "BFu8i_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu9ll, BFu8i_BFu7c_BFu9ll)
//============================================================================


struct  BFu8i_BFu7c_BFu9s  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu7c_BFu9s) C1{ Fi:8 Fc:7 Fs:9}



static void Test_BFu8i_BFu7c_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu7c_BFu9s");
    static STRUCT_IF_C BFu8i_BFu7c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_BFu9s, BFu8i_BFu7c_BFu9s)
//============================================================================


struct  BFu8i_BFu7c_C  {
  unsigned int v1:8;
  unsigned char v2:7;
  char v3;
};
//SIG(1 BFu8i_BFu7c_C) C1{ Fi:8 Fc:7 Fc}



static void Test_BFu8i_BFu7c_C()
{
  {
    init_simple_test("BFu8i_BFu7c_C");
    static STRUCT_IF_C BFu8i_BFu7c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_C");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_C, BFu8i_BFu7c_C)
//============================================================================


struct  BFu8i_BFu7c_D  {
  unsigned int v1:8;
  unsigned char v2:7;
  double v3;
};
//SIG(1 BFu8i_BFu7c_D) C1{ Fi:8 Fc:7 FL}



static void Test_BFu8i_BFu7c_D()
{
  {
    init_simple_test("BFu8i_BFu7c_D");
    static STRUCT_IF_C BFu8i_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_D, BFu8i_BFu7c_D)
//============================================================================


struct  BFu8i_BFu7c_F  {
  unsigned int v1:8;
  unsigned char v2:7;
  float v3;
};
//SIG(1 BFu8i_BFu7c_F) C1{ Fi:8 Fc:7 Fi}



static void Test_BFu8i_BFu7c_F()
{
  {
    init_simple_test("BFu8i_BFu7c_F");
    static STRUCT_IF_C BFu8i_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_F, BFu8i_BFu7c_F)
//============================================================================


struct  BFu8i_BFu7c_I  {
  unsigned int v1:8;
  unsigned char v2:7;
  int v3;
};
//SIG(1 BFu8i_BFu7c_I) C1{ Fi:8 Fc:7 Fi}



static void Test_BFu8i_BFu7c_I()
{
  {
    init_simple_test("BFu8i_BFu7c_I");
    static STRUCT_IF_C BFu8i_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_I, BFu8i_BFu7c_I)
//============================================================================


struct  BFu8i_BFu7c_Ip  {
  unsigned int v1:8;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 BFu8i_BFu7c_Ip) C1{ Fi:8 Fc:7 Fp}



static void Test_BFu8i_BFu7c_Ip()
{
  {
    init_simple_test("BFu8i_BFu7c_Ip");
    static STRUCT_IF_C BFu8i_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_Ip, BFu8i_BFu7c_Ip)
//============================================================================


struct  BFu8i_BFu7c_L  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu7c_L) C1{ Fi:8 Fc:7 FL}



static void Test_BFu8i_BFu7c_L()
{
  {
    init_simple_test("BFu8i_BFu7c_L");
    static STRUCT_IF_C BFu8i_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_L, BFu8i_BFu7c_L)
//============================================================================


struct  BFu8i_BFu7c_S  {
  unsigned int v1:8;
  unsigned char v2:7;
  short v3;
};
//SIG(1 BFu8i_BFu7c_S) C1{ Fi:8 Fc:7 Fs}



static void Test_BFu8i_BFu7c_S()
{
  {
    init_simple_test("BFu8i_BFu7c_S");
    static STRUCT_IF_C BFu8i_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_S");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_S, BFu8i_BFu7c_S)
//============================================================================


struct  BFu8i_BFu7c_Uc  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu7c_Uc) C1{ Fi:8 Fc:7 Fc}



static void Test_BFu8i_BFu7c_Uc()
{
  {
    init_simple_test("BFu8i_BFu7c_Uc");
    static STRUCT_IF_C BFu8i_BFu7c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_Uc, BFu8i_BFu7c_Uc)
//============================================================================


struct  BFu8i_BFu7c_Ui  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu7c_Ui) C1{ Fi:8 Fc:7 Fi}



static void Test_BFu8i_BFu7c_Ui()
{
  {
    init_simple_test("BFu8i_BFu7c_Ui");
    static STRUCT_IF_C BFu8i_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_Ui, BFu8i_BFu7c_Ui)
//============================================================================


struct  BFu8i_BFu7c_Ul  {
  unsigned int v1:8;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu7c_Ul) C1{ Fi:8 Fc:7 FL}



static void Test_BFu8i_BFu7c_Ul()
{
  {
    init_simple_test("BFu8i_BFu7c_Ul");
    static STRUCT_IF_C BFu8i_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_Ul, BFu8i_BFu7c_Ul)
//============================================================================


struct  BFu8i_BFu7c_Us  {
  unsigned int v1:8;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu7c_Us) C1{ Fi:8 Fc:7 Fs}



static void Test_BFu8i_BFu7c_Us()
{
  {
    init_simple_test("BFu8i_BFu7c_Us");
    static STRUCT_IF_C BFu8i_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_Us");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_Us, BFu8i_BFu7c_Us)
//============================================================================


struct  BFu8i_BFu7c_Vp  {
  unsigned int v1:8;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 BFu8i_BFu7c_Vp) C1{ Fi:8 Fc:7 Fp}



static void Test_BFu8i_BFu7c_Vp()
{
  {
    init_simple_test("BFu8i_BFu7c_Vp");
    static STRUCT_IF_C BFu8i_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_Vp, BFu8i_BFu7c_Vp)
//============================================================================


struct  BFu8i_BFu7i  {
  unsigned int v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu8i_BFu7i) C1{ Fi:8 Fi:7}



static void Test_BFu8i_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu7i");
    static STRUCT_IF_C BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i, BFu8i_BFu7i)
//============================================================================


struct  BFu8i_BFu7i_BFu15i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu7i_BFu15i) C1{ Fi:8 Fi:7 Fi:15}



static void Test_BFu8i_BFu7i_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu15i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "BFu8i_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "BFu8i_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu15i, BFu8i_BFu7i_BFu15i)
//============================================================================


struct  BFu8i_BFu7i_BFu15ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu7i_BFu15ll) C1{ Fi:8 Fi:7 FL:15}



static void Test_BFu8i_BFu7i_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "BFu8i_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "BFu8i_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu15ll, BFu8i_BFu7i_BFu15ll)
//============================================================================


struct  BFu8i_BFu7i_BFu15s  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu7i_BFu15s) C1{ Fi:8 Fi:7 Fs:15}



static void Test_BFu8i_BFu7i_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu15s");
    static STRUCT_IF_C BFu8i_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu15s, BFu8i_BFu7i_BFu15s)
//============================================================================


struct  BFu8i_BFu7i_BFu16i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu7i_BFu16i) C1{ Fi:8 Fi:7 Fi:16}



static void Test_BFu8i_BFu7i_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu16i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "BFu8i_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "BFu8i_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu16i, BFu8i_BFu7i_BFu16i)
//============================================================================


struct  BFu8i_BFu7i_BFu16ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu7i_BFu16ll) C1{ Fi:8 Fi:7 FL:16}



static void Test_BFu8i_BFu7i_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "BFu8i_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "BFu8i_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu16ll, BFu8i_BFu7i_BFu16ll)
//============================================================================


struct  BFu8i_BFu7i_BFu16s  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu7i_BFu16s) C1{ Fi:8 Fi:7 Fs:16}



static void Test_BFu8i_BFu7i_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu16s");
    static STRUCT_IF_C BFu8i_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu16s, BFu8i_BFu7i_BFu16s)
//============================================================================


struct  BFu8i_BFu7i_BFu17i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu7i_BFu17i) C1{ Fi:8 Fi:7 Fi:17}



static void Test_BFu8i_BFu7i_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu17i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "BFu8i_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "BFu8i_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu17i, BFu8i_BFu7i_BFu17i)
//============================================================================


struct  BFu8i_BFu7i_BFu17ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu7i_BFu17ll) C1{ Fi:8 Fi:7 FL:17}



static void Test_BFu8i_BFu7i_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "BFu8i_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "BFu8i_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu17ll, BFu8i_BFu7i_BFu17ll)
//============================================================================


struct  BFu8i_BFu7i_BFu1c  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu7i_BFu1c) C1{ Fi:8 Fi:7 Fc:1}



static void Test_BFu8i_BFu7i_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu1c");
    static STRUCT_IF_C BFu8i_BFu7i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu1c, BFu8i_BFu7i_BFu1c)
//============================================================================


struct  BFu8i_BFu7i_BFu1i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu7i_BFu1i) C1{ Fi:8 Fi:7 Fi:1}



static void Test_BFu8i_BFu7i_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu1i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu1i, BFu8i_BFu7i_BFu1i)
//============================================================================


struct  BFu8i_BFu7i_BFu1ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu7i_BFu1ll) C1{ Fi:8 Fi:7 FL:1}



static void Test_BFu8i_BFu7i_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu1ll, BFu8i_BFu7i_BFu1ll)
//============================================================================


struct  BFu8i_BFu7i_BFu1s  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu7i_BFu1s) C1{ Fi:8 Fi:7 Fs:1}



static void Test_BFu8i_BFu7i_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu1s");
    static STRUCT_IF_C BFu8i_BFu7i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu1s, BFu8i_BFu7i_BFu1s)
//============================================================================


struct  BFu8i_BFu7i_BFu31i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu7i_BFu31i) C1{ Fi:8 Fi:7 Fi:31}



static void Test_BFu8i_BFu7i_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu31i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu31i, BFu8i_BFu7i_BFu31i)
//============================================================================


struct  BFu8i_BFu7i_BFu31ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu7i_BFu31ll) C1{ Fi:8 Fi:7 FL:31}



static void Test_BFu8i_BFu7i_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "BFu8i_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "BFu8i_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu31ll, BFu8i_BFu7i_BFu31ll)
//============================================================================


struct  BFu8i_BFu7i_BFu32i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu7i_BFu32i) C1{ Fi:8 Fi:7 Fi:32}



static void Test_BFu8i_BFu7i_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu32i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu32i, BFu8i_BFu7i_BFu32i)
//============================================================================


struct  BFu8i_BFu7i_BFu32ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu7i_BFu32ll) C1{ Fi:8 Fi:7 FL:32}



static void Test_BFu8i_BFu7i_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "BFu8i_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "BFu8i_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu32ll, BFu8i_BFu7i_BFu32ll)
//============================================================================


struct  BFu8i_BFu7i_BFu33  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu7i_BFu33) C1{ Fi:8 Fi:7 FL:33}



static void Test_BFu8i_BFu7i_BFu33()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu33");
    static STRUCT_IF_C BFu8i_BFu7i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "BFu8i_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "BFu8i_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu33, BFu8i_BFu7i_BFu33)
//============================================================================


struct  BFu8i_BFu7i_BFu7c  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu7i_BFu7c) C1{ Fi:8 Fi:7 Fc:7}



static void Test_BFu8i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu7c");
    static STRUCT_IF_C BFu8i_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu7c, BFu8i_BFu7i_BFu7c)
//============================================================================


struct  BFu8i_BFu7i_BFu7i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu7i_BFu7i) C1{ Fi:8 Fi:7 Fi:7}



static void Test_BFu8i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu7i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFu8i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu7i, BFu8i_BFu7i_BFu7i)
//============================================================================


struct  BFu8i_BFu7i_BFu7ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu7i_BFu7ll) C1{ Fi:8 Fi:7 FL:7}



static void Test_BFu8i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFu8i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu7ll, BFu8i_BFu7i_BFu7ll)
//============================================================================


struct  BFu8i_BFu7i_BFu7s  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu7i_BFu7s) C1{ Fi:8 Fi:7 Fs:7}



static void Test_BFu8i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu7s");
    static STRUCT_IF_C BFu8i_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu7s, BFu8i_BFu7i_BFu7s)
//============================================================================


struct  BFu8i_BFu7i_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu7i_BFu8c) C1{ Fi:8 Fi:7 Fc:8}



static void Test_BFu8i_BFu7i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu8c, BFu8i_BFu7i_BFu8c)
//============================================================================


struct  BFu8i_BFu7i_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu7i_BFu8i) C1{ Fi:8 Fi:7 Fi:8}



static void Test_BFu8i_BFu7i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "BFu8i_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu8i, BFu8i_BFu7i_BFu8i)
//============================================================================


struct  BFu8i_BFu7i_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu7i_BFu8ll) C1{ Fi:8 Fi:7 FL:8}



static void Test_BFu8i_BFu7i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "BFu8i_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu8ll, BFu8i_BFu7i_BFu8ll)
//============================================================================


struct  BFu8i_BFu7i_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu7i_BFu8s) C1{ Fi:8 Fi:7 Fs:8}



static void Test_BFu8i_BFu7i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu8s, BFu8i_BFu7i_BFu8s)
//============================================================================


struct  BFu8i_BFu7i_BFu9i  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu7i_BFu9i) C1{ Fi:8 Fi:7 Fi:9}



static void Test_BFu8i_BFu7i_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu9i");
    static STRUCT_IF_C BFu8i_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "BFu8i_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "BFu8i_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu9i, BFu8i_BFu7i_BFu9i)
//============================================================================


struct  BFu8i_BFu7i_BFu9ll  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu7i_BFu9ll) C1{ Fi:8 Fi:7 FL:9}



static void Test_BFu8i_BFu7i_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "BFu8i_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "BFu8i_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu9ll, BFu8i_BFu7i_BFu9ll)
//============================================================================


struct  BFu8i_BFu7i_BFu9s  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu7i_BFu9s) C1{ Fi:8 Fi:7 Fs:9}



static void Test_BFu8i_BFu7i_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu7i_BFu9s");
    static STRUCT_IF_C BFu8i_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_BFu9s, BFu8i_BFu7i_BFu9s)
//============================================================================


struct  BFu8i_BFu7i_C  {
  unsigned int v1:8;
  unsigned int v2:7;
  char v3;
};
//SIG(1 BFu8i_BFu7i_C) C1{ Fi:8 Fi:7 Fc}



static void Test_BFu8i_BFu7i_C()
{
  {
    init_simple_test("BFu8i_BFu7i_C");
    static STRUCT_IF_C BFu8i_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_C");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_C, BFu8i_BFu7i_C)
//============================================================================


struct  BFu8i_BFu7i_D  {
  unsigned int v1:8;
  unsigned int v2:7;
  double v3;
};
//SIG(1 BFu8i_BFu7i_D) C1{ Fi:8 Fi:7 FL}



static void Test_BFu8i_BFu7i_D()
{
  {
    init_simple_test("BFu8i_BFu7i_D");
    static STRUCT_IF_C BFu8i_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_D, BFu8i_BFu7i_D)
//============================================================================


struct  BFu8i_BFu7i_F  {
  unsigned int v1:8;
  unsigned int v2:7;
  float v3;
};
//SIG(1 BFu8i_BFu7i_F) C1{ Fi:8 Fi:7 Fi}



static void Test_BFu8i_BFu7i_F()
{
  {
    init_simple_test("BFu8i_BFu7i_F");
    static STRUCT_IF_C BFu8i_BFu7i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_F, BFu8i_BFu7i_F)
//============================================================================


struct  BFu8i_BFu7i_I  {
  unsigned int v1:8;
  unsigned int v2:7;
  int v3;
};
//SIG(1 BFu8i_BFu7i_I) C1{ Fi:8 Fi:7 Fi}



static void Test_BFu8i_BFu7i_I()
{
  {
    init_simple_test("BFu8i_BFu7i_I");
    static STRUCT_IF_C BFu8i_BFu7i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_I, BFu8i_BFu7i_I)
//============================================================================


struct  BFu8i_BFu7i_Ip  {
  unsigned int v1:8;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 BFu8i_BFu7i_Ip) C1{ Fi:8 Fi:7 Fp}



static void Test_BFu8i_BFu7i_Ip()
{
  {
    init_simple_test("BFu8i_BFu7i_Ip");
    static STRUCT_IF_C BFu8i_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_Ip, BFu8i_BFu7i_Ip)
//============================================================================


struct  BFu8i_BFu7i_L  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu7i_L) C1{ Fi:8 Fi:7 FL}



static void Test_BFu8i_BFu7i_L()
{
  {
    init_simple_test("BFu8i_BFu7i_L");
    static STRUCT_IF_C BFu8i_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_L, BFu8i_BFu7i_L)
//============================================================================


struct  BFu8i_BFu7i_S  {
  unsigned int v1:8;
  unsigned int v2:7;
  short v3;
};
//SIG(1 BFu8i_BFu7i_S) C1{ Fi:8 Fi:7 Fs}



static void Test_BFu8i_BFu7i_S()
{
  {
    init_simple_test("BFu8i_BFu7i_S");
    static STRUCT_IF_C BFu8i_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_S");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_S, BFu8i_BFu7i_S)
//============================================================================


struct  BFu8i_BFu7i_Uc  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu7i_Uc) C1{ Fi:8 Fi:7 Fc}



static void Test_BFu8i_BFu7i_Uc()
{
  {
    init_simple_test("BFu8i_BFu7i_Uc");
    static STRUCT_IF_C BFu8i_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_Uc, BFu8i_BFu7i_Uc)
//============================================================================


struct  BFu8i_BFu7i_Ui  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu7i_Ui) C1{ Fi:8 Fi:7 Fi}



static void Test_BFu8i_BFu7i_Ui()
{
  {
    init_simple_test("BFu8i_BFu7i_Ui");
    static STRUCT_IF_C BFu8i_BFu7i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_Ui, BFu8i_BFu7i_Ui)
//============================================================================


struct  BFu8i_BFu7i_Ul  {
  unsigned int v1:8;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu7i_Ul) C1{ Fi:8 Fi:7 FL}



static void Test_BFu8i_BFu7i_Ul()
{
  {
    init_simple_test("BFu8i_BFu7i_Ul");
    static STRUCT_IF_C BFu8i_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_Ul, BFu8i_BFu7i_Ul)
//============================================================================


struct  BFu8i_BFu7i_Us  {
  unsigned int v1:8;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu7i_Us) C1{ Fi:8 Fi:7 Fs}



static void Test_BFu8i_BFu7i_Us()
{
  {
    init_simple_test("BFu8i_BFu7i_Us");
    static STRUCT_IF_C BFu8i_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_Us");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_Us, BFu8i_BFu7i_Us)
//============================================================================


struct  BFu8i_BFu7i_Vp  {
  unsigned int v1:8;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 BFu8i_BFu7i_Vp) C1{ Fi:8 Fi:7 Fp}



static void Test_BFu8i_BFu7i_Vp()
{
  {
    init_simple_test("BFu8i_BFu7i_Vp");
    static STRUCT_IF_C BFu8i_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_Vp, BFu8i_BFu7i_Vp)
//============================================================================


struct  BFu8i_BFu7ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu8i_BFu7ll) C1{ Fi:8 FL:7}



static void Test_BFu8i_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll, BFu8i_BFu7ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu15i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu7ll_BFu15i) C1{ Fi:8 FL:7 Fi:15}



static void Test_BFu8i_BFu7ll_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu15i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "BFu8i_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "BFu8i_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu15i, BFu8i_BFu7ll_BFu15i)
//============================================================================


struct  BFu8i_BFu7ll_BFu15ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu7ll_BFu15ll) C1{ Fi:8 FL:7 FL:15}



static void Test_BFu8i_BFu7ll_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "BFu8i_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "BFu8i_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu15ll, BFu8i_BFu7ll_BFu15ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu15s  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu7ll_BFu15s) C1{ Fi:8 FL:7 Fs:15}



static void Test_BFu8i_BFu7ll_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu15s");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu15s, BFu8i_BFu7ll_BFu15s)
//============================================================================


struct  BFu8i_BFu7ll_BFu16i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu7ll_BFu16i) C1{ Fi:8 FL:7 Fi:16}



static void Test_BFu8i_BFu7ll_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu16i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "BFu8i_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "BFu8i_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu16i, BFu8i_BFu7ll_BFu16i)
//============================================================================


struct  BFu8i_BFu7ll_BFu16ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu7ll_BFu16ll) C1{ Fi:8 FL:7 FL:16}



static void Test_BFu8i_BFu7ll_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "BFu8i_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "BFu8i_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu16ll, BFu8i_BFu7ll_BFu16ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu16s  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu7ll_BFu16s) C1{ Fi:8 FL:7 Fs:16}



static void Test_BFu8i_BFu7ll_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu16s");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu16s, BFu8i_BFu7ll_BFu16s)
//============================================================================


struct  BFu8i_BFu7ll_BFu17i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu7ll_BFu17i) C1{ Fi:8 FL:7 Fi:17}



static void Test_BFu8i_BFu7ll_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu17i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "BFu8i_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "BFu8i_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu17i, BFu8i_BFu7ll_BFu17i)
//============================================================================


struct  BFu8i_BFu7ll_BFu17ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu7ll_BFu17ll) C1{ Fi:8 FL:7 FL:17}



static void Test_BFu8i_BFu7ll_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "BFu8i_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "BFu8i_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu17ll, BFu8i_BFu7ll_BFu17ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu1c  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu7ll_BFu1c) C1{ Fi:8 FL:7 Fc:1}



static void Test_BFu8i_BFu7ll_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu1c");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu1c, BFu8i_BFu7ll_BFu1c)
//============================================================================


struct  BFu8i_BFu7ll_BFu1i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu7ll_BFu1i) C1{ Fi:8 FL:7 Fi:1}



static void Test_BFu8i_BFu7ll_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu1i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu1i, BFu8i_BFu7ll_BFu1i)
//============================================================================


struct  BFu8i_BFu7ll_BFu1ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu7ll_BFu1ll) C1{ Fi:8 FL:7 FL:1}



static void Test_BFu8i_BFu7ll_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu1ll, BFu8i_BFu7ll_BFu1ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu1s  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu7ll_BFu1s) C1{ Fi:8 FL:7 Fs:1}



static void Test_BFu8i_BFu7ll_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu1s");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu1s, BFu8i_BFu7ll_BFu1s)
//============================================================================


struct  BFu8i_BFu7ll_BFu31i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu7ll_BFu31i) C1{ Fi:8 FL:7 Fi:31}



static void Test_BFu8i_BFu7ll_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu31i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu31i, BFu8i_BFu7ll_BFu31i)
//============================================================================


struct  BFu8i_BFu7ll_BFu31ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu7ll_BFu31ll) C1{ Fi:8 FL:7 FL:31}



static void Test_BFu8i_BFu7ll_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "BFu8i_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "BFu8i_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu31ll, BFu8i_BFu7ll_BFu31ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu32i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu7ll_BFu32i) C1{ Fi:8 FL:7 Fi:32}



static void Test_BFu8i_BFu7ll_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu32i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu32i, BFu8i_BFu7ll_BFu32i)
//============================================================================


struct  BFu8i_BFu7ll_BFu32ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu7ll_BFu32ll) C1{ Fi:8 FL:7 FL:32}



static void Test_BFu8i_BFu7ll_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "BFu8i_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "BFu8i_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu32ll, BFu8i_BFu7ll_BFu32ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu33  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu7ll_BFu33) C1{ Fi:8 FL:7 FL:33}



static void Test_BFu8i_BFu7ll_BFu33()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu33");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "BFu8i_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "BFu8i_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu33, BFu8i_BFu7ll_BFu33)
//============================================================================


struct  BFu8i_BFu7ll_BFu7c  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu7ll_BFu7c) C1{ Fi:8 FL:7 Fc:7}



static void Test_BFu8i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu7c");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu7c, BFu8i_BFu7ll_BFu7c)
//============================================================================


struct  BFu8i_BFu7ll_BFu7i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu7ll_BFu7i) C1{ Fi:8 FL:7 Fi:7}



static void Test_BFu8i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu7i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFu8i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu7i, BFu8i_BFu7ll_BFu7i)
//============================================================================


struct  BFu8i_BFu7ll_BFu7ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu7ll_BFu7ll) C1{ Fi:8 FL:7 FL:7}



static void Test_BFu8i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFu8i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu7ll, BFu8i_BFu7ll_BFu7ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu7s  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu7ll_BFu7s) C1{ Fi:8 FL:7 Fs:7}



static void Test_BFu8i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu7s");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu7s, BFu8i_BFu7ll_BFu7s)
//============================================================================


struct  BFu8i_BFu7ll_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu7ll_BFu8c) C1{ Fi:8 FL:7 Fc:8}



static void Test_BFu8i_BFu7ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu8c, BFu8i_BFu7ll_BFu8c)
//============================================================================


struct  BFu8i_BFu7ll_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu7ll_BFu8i) C1{ Fi:8 FL:7 Fi:8}



static void Test_BFu8i_BFu7ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "BFu8i_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu8i, BFu8i_BFu7ll_BFu8i)
//============================================================================


struct  BFu8i_BFu7ll_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu7ll_BFu8ll) C1{ Fi:8 FL:7 FL:8}



static void Test_BFu8i_BFu7ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "BFu8i_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu8ll, BFu8i_BFu7ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu7ll_BFu8s) C1{ Fi:8 FL:7 Fs:8}



static void Test_BFu8i_BFu7ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu8s, BFu8i_BFu7ll_BFu8s)
//============================================================================


struct  BFu8i_BFu7ll_BFu9i  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu7ll_BFu9i) C1{ Fi:8 FL:7 Fi:9}



static void Test_BFu8i_BFu7ll_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu9i");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "BFu8i_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "BFu8i_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu9i, BFu8i_BFu7ll_BFu9i)
//============================================================================


struct  BFu8i_BFu7ll_BFu9ll  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu7ll_BFu9ll) C1{ Fi:8 FL:7 FL:9}



static void Test_BFu8i_BFu7ll_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "BFu8i_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "BFu8i_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu9ll, BFu8i_BFu7ll_BFu9ll)
//============================================================================


struct  BFu8i_BFu7ll_BFu9s  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu7ll_BFu9s) C1{ Fi:8 FL:7 Fs:9}



static void Test_BFu8i_BFu7ll_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu7ll_BFu9s");
    static STRUCT_IF_C BFu8i_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_BFu9s, BFu8i_BFu7ll_BFu9s)
//============================================================================


struct  BFu8i_BFu7ll_C  {
  unsigned int v1:8;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 BFu8i_BFu7ll_C) C1{ Fi:8 FL:7 Fc}



static void Test_BFu8i_BFu7ll_C()
{
  {
    init_simple_test("BFu8i_BFu7ll_C");
    static STRUCT_IF_C BFu8i_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_C");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_C, BFu8i_BFu7ll_C)
//============================================================================


struct  BFu8i_BFu7ll_D  {
  unsigned int v1:8;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 BFu8i_BFu7ll_D) C1{ Fi:8 FL:7 FL}



static void Test_BFu8i_BFu7ll_D()
{
  {
    init_simple_test("BFu8i_BFu7ll_D");
    static STRUCT_IF_C BFu8i_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_D, BFu8i_BFu7ll_D)
//============================================================================


struct  BFu8i_BFu7ll_F  {
  unsigned int v1:8;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 BFu8i_BFu7ll_F) C1{ Fi:8 FL:7 Fi}



static void Test_BFu8i_BFu7ll_F()
{
  {
    init_simple_test("BFu8i_BFu7ll_F");
    static STRUCT_IF_C BFu8i_BFu7ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_F, BFu8i_BFu7ll_F)
//============================================================================


struct  BFu8i_BFu7ll_I  {
  unsigned int v1:8;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 BFu8i_BFu7ll_I) C1{ Fi:8 FL:7 Fi}



static void Test_BFu8i_BFu7ll_I()
{
  {
    init_simple_test("BFu8i_BFu7ll_I");
    static STRUCT_IF_C BFu8i_BFu7ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_I, BFu8i_BFu7ll_I)
//============================================================================


struct  BFu8i_BFu7ll_Ip  {
  unsigned int v1:8;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 BFu8i_BFu7ll_Ip) C1{ Fi:8 FL:7 Fp}



static void Test_BFu8i_BFu7ll_Ip()
{
  {
    init_simple_test("BFu8i_BFu7ll_Ip");
    static STRUCT_IF_C BFu8i_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_Ip, BFu8i_BFu7ll_Ip)
//============================================================================


struct  BFu8i_BFu7ll_L  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu7ll_L) C1{ Fi:8 FL:7 FL}



static void Test_BFu8i_BFu7ll_L()
{
  {
    init_simple_test("BFu8i_BFu7ll_L");
    static STRUCT_IF_C BFu8i_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_L, BFu8i_BFu7ll_L)
//============================================================================


struct  BFu8i_BFu7ll_S  {
  unsigned int v1:8;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 BFu8i_BFu7ll_S) C1{ Fi:8 FL:7 Fs}



static void Test_BFu8i_BFu7ll_S()
{
  {
    init_simple_test("BFu8i_BFu7ll_S");
    static STRUCT_IF_C BFu8i_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_S");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_S, BFu8i_BFu7ll_S)
//============================================================================


struct  BFu8i_BFu7ll_Uc  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu7ll_Uc) C1{ Fi:8 FL:7 Fc}



static void Test_BFu8i_BFu7ll_Uc()
{
  {
    init_simple_test("BFu8i_BFu7ll_Uc");
    static STRUCT_IF_C BFu8i_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_Uc, BFu8i_BFu7ll_Uc)
//============================================================================


struct  BFu8i_BFu7ll_Ui  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu7ll_Ui) C1{ Fi:8 FL:7 Fi}



static void Test_BFu8i_BFu7ll_Ui()
{
  {
    init_simple_test("BFu8i_BFu7ll_Ui");
    static STRUCT_IF_C BFu8i_BFu7ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_Ui, BFu8i_BFu7ll_Ui)
//============================================================================


struct  BFu8i_BFu7ll_Ul  {
  unsigned int v1:8;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu7ll_Ul) C1{ Fi:8 FL:7 FL}



static void Test_BFu8i_BFu7ll_Ul()
{
  {
    init_simple_test("BFu8i_BFu7ll_Ul");
    static STRUCT_IF_C BFu8i_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_Ul, BFu8i_BFu7ll_Ul)
//============================================================================


struct  BFu8i_BFu7ll_Us  {
  unsigned int v1:8;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu7ll_Us) C1{ Fi:8 FL:7 Fs}



static void Test_BFu8i_BFu7ll_Us()
{
  {
    init_simple_test("BFu8i_BFu7ll_Us");
    static STRUCT_IF_C BFu8i_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_Us, BFu8i_BFu7ll_Us)
//============================================================================


struct  BFu8i_BFu7ll_Vp  {
  unsigned int v1:8;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 BFu8i_BFu7ll_Vp) C1{ Fi:8 FL:7 Fp}



static void Test_BFu8i_BFu7ll_Vp()
{
  {
    init_simple_test("BFu8i_BFu7ll_Vp");
    static STRUCT_IF_C BFu8i_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_Vp, BFu8i_BFu7ll_Vp)
//============================================================================


struct  BFu8i_BFu7s  {
  unsigned int v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu8i_BFu7s) C1{ Fi:8 Fs:7}



static void Test_BFu8i_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu7s");
    static STRUCT_IF_C BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s, BFu8i_BFu7s)
//============================================================================


struct  BFu8i_BFu7s_BFu15i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu7s_BFu15i) C1{ Fi:8 Fs:7 Fi:15}



static void Test_BFu8i_BFu7s_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu15i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "BFu8i_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "BFu8i_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu15i, BFu8i_BFu7s_BFu15i)
//============================================================================


struct  BFu8i_BFu7s_BFu15ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu7s_BFu15ll) C1{ Fi:8 Fs:7 FL:15}



static void Test_BFu8i_BFu7s_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "BFu8i_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "BFu8i_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu15ll, BFu8i_BFu7s_BFu15ll)
//============================================================================


struct  BFu8i_BFu7s_BFu15s  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu7s_BFu15s) C1{ Fi:8 Fs:7 Fs:15}



static void Test_BFu8i_BFu7s_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu15s");
    static STRUCT_IF_C BFu8i_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu15s, BFu8i_BFu7s_BFu15s)
//============================================================================


struct  BFu8i_BFu7s_BFu16i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu7s_BFu16i) C1{ Fi:8 Fs:7 Fi:16}



static void Test_BFu8i_BFu7s_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu16i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "BFu8i_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "BFu8i_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu16i, BFu8i_BFu7s_BFu16i)
//============================================================================


struct  BFu8i_BFu7s_BFu16ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu7s_BFu16ll) C1{ Fi:8 Fs:7 FL:16}



static void Test_BFu8i_BFu7s_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "BFu8i_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "BFu8i_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu16ll, BFu8i_BFu7s_BFu16ll)
//============================================================================


struct  BFu8i_BFu7s_BFu16s  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu7s_BFu16s) C1{ Fi:8 Fs:7 Fs:16}



static void Test_BFu8i_BFu7s_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu16s");
    static STRUCT_IF_C BFu8i_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu16s, BFu8i_BFu7s_BFu16s)
//============================================================================


struct  BFu8i_BFu7s_BFu17i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu7s_BFu17i) C1{ Fi:8 Fs:7 Fi:17}



static void Test_BFu8i_BFu7s_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu17i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "BFu8i_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "BFu8i_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu17i, BFu8i_BFu7s_BFu17i)
//============================================================================


struct  BFu8i_BFu7s_BFu17ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu7s_BFu17ll) C1{ Fi:8 Fs:7 FL:17}



static void Test_BFu8i_BFu7s_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "BFu8i_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "BFu8i_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu17ll, BFu8i_BFu7s_BFu17ll)
//============================================================================


struct  BFu8i_BFu7s_BFu1c  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu7s_BFu1c) C1{ Fi:8 Fs:7 Fc:1}



static void Test_BFu8i_BFu7s_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu1c");
    static STRUCT_IF_C BFu8i_BFu7s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu1c, BFu8i_BFu7s_BFu1c)
//============================================================================


struct  BFu8i_BFu7s_BFu1i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu7s_BFu1i) C1{ Fi:8 Fs:7 Fi:1}



static void Test_BFu8i_BFu7s_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu1i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu1i, BFu8i_BFu7s_BFu1i)
//============================================================================


struct  BFu8i_BFu7s_BFu1ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu7s_BFu1ll) C1{ Fi:8 Fs:7 FL:1}



static void Test_BFu8i_BFu7s_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu1ll, BFu8i_BFu7s_BFu1ll)
//============================================================================


struct  BFu8i_BFu7s_BFu1s  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu7s_BFu1s) C1{ Fi:8 Fs:7 Fs:1}



static void Test_BFu8i_BFu7s_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu1s");
    static STRUCT_IF_C BFu8i_BFu7s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "BFu8i_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu1s, BFu8i_BFu7s_BFu1s)
//============================================================================


struct  BFu8i_BFu7s_BFu31i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu7s_BFu31i) C1{ Fi:8 Fs:7 Fi:31}



static void Test_BFu8i_BFu7s_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu31i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu31i, BFu8i_BFu7s_BFu31i)
//============================================================================


struct  BFu8i_BFu7s_BFu31ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu7s_BFu31ll) C1{ Fi:8 Fs:7 FL:31}



static void Test_BFu8i_BFu7s_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "BFu8i_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "BFu8i_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu31ll, BFu8i_BFu7s_BFu31ll)
//============================================================================


struct  BFu8i_BFu7s_BFu32i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu7s_BFu32i) C1{ Fi:8 Fs:7 Fi:32}



static void Test_BFu8i_BFu7s_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu32i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu32i, BFu8i_BFu7s_BFu32i)
//============================================================================


struct  BFu8i_BFu7s_BFu32ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu7s_BFu32ll) C1{ Fi:8 Fs:7 FL:32}



static void Test_BFu8i_BFu7s_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "BFu8i_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "BFu8i_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu32ll, BFu8i_BFu7s_BFu32ll)
//============================================================================


struct  BFu8i_BFu7s_BFu33  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu7s_BFu33) C1{ Fi:8 Fs:7 FL:33}



static void Test_BFu8i_BFu7s_BFu33()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu33");
    static STRUCT_IF_C BFu8i_BFu7s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "BFu8i_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "BFu8i_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu33, BFu8i_BFu7s_BFu33)
//============================================================================


struct  BFu8i_BFu7s_BFu7c  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu7s_BFu7c) C1{ Fi:8 Fs:7 Fc:7}



static void Test_BFu8i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu7c");
    static STRUCT_IF_C BFu8i_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu7c, BFu8i_BFu7s_BFu7c)
//============================================================================


struct  BFu8i_BFu7s_BFu7i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu7s_BFu7i) C1{ Fi:8 Fs:7 Fi:7}



static void Test_BFu8i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu7i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFu8i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu7i, BFu8i_BFu7s_BFu7i)
//============================================================================


struct  BFu8i_BFu7s_BFu7ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu7s_BFu7ll) C1{ Fi:8 Fs:7 FL:7}



static void Test_BFu8i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFu8i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu7ll, BFu8i_BFu7s_BFu7ll)
//============================================================================


struct  BFu8i_BFu7s_BFu7s  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu7s_BFu7s) C1{ Fi:8 Fs:7 Fs:7}



static void Test_BFu8i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu7s");
    static STRUCT_IF_C BFu8i_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu7s, BFu8i_BFu7s_BFu7s)
//============================================================================


struct  BFu8i_BFu7s_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu7s_BFu8c) C1{ Fi:8 Fs:7 Fc:8}



static void Test_BFu8i_BFu7s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu7s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu8c, BFu8i_BFu7s_BFu8c)
//============================================================================


struct  BFu8i_BFu7s_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu7s_BFu8i) C1{ Fi:8 Fs:7 Fi:8}



static void Test_BFu8i_BFu7s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "BFu8i_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu8i, BFu8i_BFu7s_BFu8i)
//============================================================================


struct  BFu8i_BFu7s_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu7s_BFu8ll) C1{ Fi:8 Fs:7 FL:8}



static void Test_BFu8i_BFu7s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "BFu8i_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu8ll, BFu8i_BFu7s_BFu8ll)
//============================================================================


struct  BFu8i_BFu7s_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu7s_BFu8s) C1{ Fi:8 Fs:7 Fs:8}



static void Test_BFu8i_BFu7s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu7s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu8s, BFu8i_BFu7s_BFu8s)
//============================================================================


struct  BFu8i_BFu7s_BFu9i  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu7s_BFu9i) C1{ Fi:8 Fs:7 Fi:9}



static void Test_BFu8i_BFu7s_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu9i");
    static STRUCT_IF_C BFu8i_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "BFu8i_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "BFu8i_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu9i, BFu8i_BFu7s_BFu9i)
//============================================================================


struct  BFu8i_BFu7s_BFu9ll  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu7s_BFu9ll) C1{ Fi:8 Fs:7 FL:9}



static void Test_BFu8i_BFu7s_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "BFu8i_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "BFu8i_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu9ll, BFu8i_BFu7s_BFu9ll)
//============================================================================


struct  BFu8i_BFu7s_BFu9s  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu7s_BFu9s) C1{ Fi:8 Fs:7 Fs:9}



static void Test_BFu8i_BFu7s_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu7s_BFu9s");
    static STRUCT_IF_C BFu8i_BFu7s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_BFu9s, BFu8i_BFu7s_BFu9s)
//============================================================================


struct  BFu8i_BFu7s_C  {
  unsigned int v1:8;
  unsigned short v2:7;
  char v3;
};
//SIG(1 BFu8i_BFu7s_C) C1{ Fi:8 Fs:7 Fc}



static void Test_BFu8i_BFu7s_C()
{
  {
    init_simple_test("BFu8i_BFu7s_C");
    static STRUCT_IF_C BFu8i_BFu7s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_C");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_C, BFu8i_BFu7s_C)
//============================================================================


struct  BFu8i_BFu7s_D  {
  unsigned int v1:8;
  unsigned short v2:7;
  double v3;
};
//SIG(1 BFu8i_BFu7s_D) C1{ Fi:8 Fs:7 FL}



static void Test_BFu8i_BFu7s_D()
{
  {
    init_simple_test("BFu8i_BFu7s_D");
    static STRUCT_IF_C BFu8i_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_D, BFu8i_BFu7s_D)
//============================================================================


struct  BFu8i_BFu7s_F  {
  unsigned int v1:8;
  unsigned short v2:7;
  float v3;
};
//SIG(1 BFu8i_BFu7s_F) C1{ Fi:8 Fs:7 Fi}



static void Test_BFu8i_BFu7s_F()
{
  {
    init_simple_test("BFu8i_BFu7s_F");
    static STRUCT_IF_C BFu8i_BFu7s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_F, BFu8i_BFu7s_F)
//============================================================================


struct  BFu8i_BFu7s_I  {
  unsigned int v1:8;
  unsigned short v2:7;
  int v3;
};
//SIG(1 BFu8i_BFu7s_I) C1{ Fi:8 Fs:7 Fi}



static void Test_BFu8i_BFu7s_I()
{
  {
    init_simple_test("BFu8i_BFu7s_I");
    static STRUCT_IF_C BFu8i_BFu7s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_I, BFu8i_BFu7s_I)
//============================================================================


struct  BFu8i_BFu7s_Ip  {
  unsigned int v1:8;
  unsigned short v2:7;
  int *v3;
};
//SIG(1 BFu8i_BFu7s_Ip) C1{ Fi:8 Fs:7 Fp}



static void Test_BFu8i_BFu7s_Ip()
{
  {
    init_simple_test("BFu8i_BFu7s_Ip");
    static STRUCT_IF_C BFu8i_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_Ip, BFu8i_BFu7s_Ip)
//============================================================================


struct  BFu8i_BFu7s_L  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu7s_L) C1{ Fi:8 Fs:7 FL}



static void Test_BFu8i_BFu7s_L()
{
  {
    init_simple_test("BFu8i_BFu7s_L");
    static STRUCT_IF_C BFu8i_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_L, BFu8i_BFu7s_L)
//============================================================================


struct  BFu8i_BFu7s_S  {
  unsigned int v1:8;
  unsigned short v2:7;
  short v3;
};
//SIG(1 BFu8i_BFu7s_S) C1{ Fi:8 Fs:7 Fs}



static void Test_BFu8i_BFu7s_S()
{
  {
    init_simple_test("BFu8i_BFu7s_S");
    static STRUCT_IF_C BFu8i_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_S");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_S, BFu8i_BFu7s_S)
//============================================================================


struct  BFu8i_BFu7s_Uc  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu7s_Uc) C1{ Fi:8 Fs:7 Fc}



static void Test_BFu8i_BFu7s_Uc()
{
  {
    init_simple_test("BFu8i_BFu7s_Uc");
    static STRUCT_IF_C BFu8i_BFu7s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_Uc");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_Uc, BFu8i_BFu7s_Uc)
//============================================================================


struct  BFu8i_BFu7s_Ui  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu7s_Ui) C1{ Fi:8 Fs:7 Fi}



static void Test_BFu8i_BFu7s_Ui()
{
  {
    init_simple_test("BFu8i_BFu7s_Ui");
    static STRUCT_IF_C BFu8i_BFu7s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu7s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_Ui, BFu8i_BFu7s_Ui)
//============================================================================


struct  BFu8i_BFu7s_Ul  {
  unsigned int v1:8;
  unsigned short v2:7;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu7s_Ul) C1{ Fi:8 Fs:7 FL}



static void Test_BFu8i_BFu7s_Ul()
{
  {
    init_simple_test("BFu8i_BFu7s_Ul");
    static STRUCT_IF_C BFu8i_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_Ul, BFu8i_BFu7s_Ul)
//============================================================================


struct  BFu8i_BFu7s_Us  {
  unsigned int v1:8;
  unsigned short v2:7;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu7s_Us) C1{ Fi:8 Fs:7 Fs}



static void Test_BFu8i_BFu7s_Us()
{
  {
    init_simple_test("BFu8i_BFu7s_Us");
    static STRUCT_IF_C BFu8i_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_Us");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_Us, BFu8i_BFu7s_Us)
//============================================================================


struct  BFu8i_BFu7s_Vp  {
  unsigned int v1:8;
  unsigned short v2:7;
  void *v3;
};
//SIG(1 BFu8i_BFu7s_Vp) C1{ Fi:8 Fs:7 Fp}



static void Test_BFu8i_BFu7s_Vp()
{
  {
    init_simple_test("BFu8i_BFu7s_Vp");
    static STRUCT_IF_C BFu8i_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_Vp, BFu8i_BFu7s_Vp)
//============================================================================


struct  BFu8i_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu8i_BFu8c) C1{ Fi:8 Fc:8}



static void Test_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c, BFu8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c) C1{ Fi:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c, BFu8i_BFu8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8c_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c_BFs8c) C1{ Fi:8 Fc:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8c_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c_BFs8c, BFu8i_BFu8c_BFs8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8c_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c_BFs8i) C1{ Fi:8 Fc:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c_BFs8i, BFu8i_BFu8c_BFs8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8c_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c_BFs8ll) C1{ Fi:8 Fc:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c_BFs8ll, BFu8i_BFu8c_BFs8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8c_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c_BFs8s) C1{ Fi:8 Fc:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8c_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c_BFs8s, BFu8i_BFu8c_BFs8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFs8c_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c_BFu8c) C1{ Fi:8 Fc:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c_BFu8c, BFu8i_BFu8c_BFs8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8c_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c_BFu8i) C1{ Fi:8 Fc:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c_BFu8i, BFu8i_BFu8c_BFs8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8c_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c_BFu8ll) C1{ Fi:8 Fc:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c_BFu8ll, BFu8i_BFu8c_BFs8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8c_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8c_BFu8s) C1{ Fi:8 Fc:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8c_BFu8s, BFu8i_BFu8c_BFs8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i) C1{ Fi:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i, BFu8i_BFu8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8i_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i_BFs8c) C1{ Fi:8 Fc:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i_BFs8c, BFu8i_BFu8c_BFs8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8i_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i_BFs8i) C1{ Fi:8 Fc:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i_BFs8i, BFu8i_BFu8c_BFs8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8i_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i_BFs8ll) C1{ Fi:8 Fc:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i_BFs8ll, BFu8i_BFu8c_BFs8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8i_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i_BFs8s) C1{ Fi:8 Fc:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i_BFs8s, BFu8i_BFu8c_BFs8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFs8i_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i_BFu8c) C1{ Fi:8 Fc:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i_BFu8c, BFu8i_BFu8c_BFs8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8i_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i_BFu8i) C1{ Fi:8 Fc:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i_BFu8i, BFu8i_BFu8c_BFs8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8i_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i_BFu8ll) C1{ Fi:8 Fc:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i_BFu8ll, BFu8i_BFu8c_BFs8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8i_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8i_BFu8s) C1{ Fi:8 Fc:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8i_BFu8s, BFu8i_BFu8c_BFs8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll) C1{ Fi:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll, BFu8i_BFu8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll_BFs8c) C1{ Fi:8 Fc:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll_BFs8c, BFu8i_BFu8c_BFs8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll_BFs8i) C1{ Fi:8 Fc:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll_BFs8i, BFu8i_BFu8c_BFs8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll_BFs8ll) C1{ Fi:8 Fc:8 FL:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll_BFs8ll, BFu8i_BFu8c_BFs8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll_BFs8s) C1{ Fi:8 Fc:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll_BFs8s, BFu8i_BFu8c_BFs8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll_BFu8c) C1{ Fi:8 Fc:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll_BFu8c, BFu8i_BFu8c_BFs8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll_BFu8i) C1{ Fi:8 Fc:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll_BFu8i, BFu8i_BFu8c_BFs8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll_BFu8ll) C1{ Fi:8 Fc:8 FL:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll_BFu8ll, BFu8i_BFu8c_BFs8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8ll_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed __tsi64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8ll_BFu8s) C1{ Fi:8 Fc:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8ll_BFu8s, BFu8i_BFu8c_BFs8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s) C1{ Fi:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s, BFu8i_BFu8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFs8s_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s_BFs8c) C1{ Fi:8 Fc:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8s_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s_BFs8c, BFu8i_BFu8c_BFs8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8s_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s_BFs8i) C1{ Fi:8 Fc:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s_BFs8i, BFu8i_BFu8c_BFs8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8s_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s_BFs8ll) C1{ Fi:8 Fc:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s_BFs8ll, BFu8i_BFu8c_BFs8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8s_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s_BFs8s) C1{ Fi:8 Fc:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8s_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s_BFs8s, BFu8i_BFu8c_BFs8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFs8s_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s_BFu8c) C1{ Fi:8 Fc:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8c_BFs8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s_BFu8c, BFu8i_BFu8c_BFs8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFs8s_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s_BFu8i) C1{ Fi:8 Fc:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8c_BFs8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s_BFu8i, BFu8i_BFu8c_BFs8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFs8s_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s_BFu8ll) C1{ Fi:8 Fc:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8c_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFs8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s_BFu8ll, BFu8i_BFu8c_BFs8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFs8s_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  signed short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFs8s_BFu8s) C1{ Fi:8 Fc:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8c_BFs8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFs8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFs8s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFs8s_BFu8s, BFu8i_BFu8c_BFs8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFu15i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu8c_BFu15i) C1{ Fi:8 Fc:8 Fi:15}



static void Test_BFu8i_BFu8c_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu15i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu15i, BFu8i_BFu8c_BFu15i)
//============================================================================


struct  BFu8i_BFu8c_BFu15ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu8c_BFu15ll) C1{ Fi:8 Fc:8 FL:15}



static void Test_BFu8i_BFu8c_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu15ll, BFu8i_BFu8c_BFu15ll)
//============================================================================


struct  BFu8i_BFu8c_BFu15s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu8c_BFu15s) C1{ Fi:8 Fc:8 Fs:15}



static void Test_BFu8i_BFu8c_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu15s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu15s, BFu8i_BFu8c_BFu15s)
//============================================================================


struct  BFu8i_BFu8c_BFu16i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu8c_BFu16i) C1{ Fi:8 Fc:8 Fi:16}



static void Test_BFu8i_BFu8c_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu16i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu16i, BFu8i_BFu8c_BFu16i)
//============================================================================


struct  BFu8i_BFu8c_BFu16ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu8c_BFu16ll) C1{ Fi:8 Fc:8 FL:16}



static void Test_BFu8i_BFu8c_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu16ll, BFu8i_BFu8c_BFu16ll)
//============================================================================


struct  BFu8i_BFu8c_BFu16s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu8c_BFu16s) C1{ Fi:8 Fc:8 Fs:16}



static void Test_BFu8i_BFu8c_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu16s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu16s, BFu8i_BFu8c_BFu16s)
//============================================================================


struct  BFu8i_BFu8c_BFu17i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu8c_BFu17i) C1{ Fi:8 Fc:8 Fi:17}



static void Test_BFu8i_BFu8c_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu17i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu17i, BFu8i_BFu8c_BFu17i)
//============================================================================


struct  BFu8i_BFu8c_BFu17ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu8c_BFu17ll) C1{ Fi:8 Fc:8 FL:17}



static void Test_BFu8i_BFu8c_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8i_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu17ll, BFu8i_BFu8c_BFu17ll)
//============================================================================


struct  BFu8i_BFu8c_BFu1c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu8c_BFu1c) C1{ Fi:8 Fc:8 Fc:1}



static void Test_BFu8i_BFu8c_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu1c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu1c, BFu8i_BFu8c_BFu1c)
//============================================================================


struct  BFu8i_BFu8c_BFu1i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu8c_BFu1i) C1{ Fi:8 Fc:8 Fi:1}



static void Test_BFu8i_BFu8c_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu1i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu1i, BFu8i_BFu8c_BFu1i)
//============================================================================


struct  BFu8i_BFu8c_BFu1ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu8c_BFu1ll) C1{ Fi:8 Fc:8 FL:1}



static void Test_BFu8i_BFu8c_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu1ll, BFu8i_BFu8c_BFu1ll)
//============================================================================


struct  BFu8i_BFu8c_BFu1s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu8c_BFu1s) C1{ Fi:8 Fc:8 Fs:1}



static void Test_BFu8i_BFu8c_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu1s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu1s, BFu8i_BFu8c_BFu1s)
//============================================================================


struct  BFu8i_BFu8c_BFu31i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu8c_BFu31i) C1{ Fi:8 Fc:8 Fi:31}



static void Test_BFu8i_BFu8c_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu31i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu31i, BFu8i_BFu8c_BFu31i)
//============================================================================


struct  BFu8i_BFu8c_BFu31ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu8c_BFu31ll) C1{ Fi:8 Fc:8 FL:31}



static void Test_BFu8i_BFu8c_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu31ll, BFu8i_BFu8c_BFu31ll)
//============================================================================


struct  BFu8i_BFu8c_BFu32i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu8c_BFu32i) C1{ Fi:8 Fc:8 Fi:32}



static void Test_BFu8i_BFu8c_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu32i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu32i, BFu8i_BFu8c_BFu32i)
//============================================================================


struct  BFu8i_BFu8c_BFu32ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu8c_BFu32ll) C1{ Fi:8 Fc:8 FL:32}



static void Test_BFu8i_BFu8c_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu32ll, BFu8i_BFu8c_BFu32ll)
//============================================================================


struct  BFu8i_BFu8c_BFu33  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu8c_BFu33) C1{ Fi:8 Fc:8 FL:33}



static void Test_BFu8i_BFu8c_BFu33()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu33");
    static STRUCT_IF_C BFu8i_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8i_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu33, BFu8i_BFu8c_BFu33)
//============================================================================


struct  BFu8i_BFu8c_BFu7c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu8c_BFu7c) C1{ Fi:8 Fc:8 Fc:7}



static void Test_BFu8i_BFu8c_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu7c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu7c, BFu8i_BFu8c_BFu7c)
//============================================================================


struct  BFu8i_BFu8c_BFu7i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu8c_BFu7i) C1{ Fi:8 Fc:8 Fi:7}



static void Test_BFu8i_BFu8c_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu7i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu7i, BFu8i_BFu8c_BFu7i)
//============================================================================


struct  BFu8i_BFu8c_BFu7ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu8c_BFu7ll) C1{ Fi:8 Fc:8 FL:7}



static void Test_BFu8i_BFu8c_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu7ll, BFu8i_BFu8c_BFu7ll)
//============================================================================


struct  BFu8i_BFu8c_BFu7s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu8c_BFu7s) C1{ Fi:8 Fc:8 Fs:7}



static void Test_BFu8i_BFu8c_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu7s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu7s, BFu8i_BFu8c_BFu7s)
//============================================================================


struct  BFu8i_BFu8c_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c) C1{ Fi:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c, BFu8i_BFu8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8c_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c_BFs8c) C1{ Fi:8 Fc:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8c_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c_BFs8c, BFu8i_BFu8c_BFu8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8c_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c_BFs8i) C1{ Fi:8 Fc:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c_BFs8i, BFu8i_BFu8c_BFu8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8c_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c_BFs8ll) C1{ Fi:8 Fc:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c_BFs8ll, BFu8i_BFu8c_BFu8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8c_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c_BFs8s) C1{ Fi:8 Fc:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8c_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c_BFs8s, BFu8i_BFu8c_BFu8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFu8c_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c_BFu8c) C1{ Fi:8 Fc:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c_BFu8c, BFu8i_BFu8c_BFu8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8c_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c_BFu8i) C1{ Fi:8 Fc:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c_BFu8i, BFu8i_BFu8c_BFu8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8c_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c_BFu8ll) C1{ Fi:8 Fc:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c_BFu8ll, BFu8i_BFu8c_BFu8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8c_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8c_BFu8s) C1{ Fi:8 Fc:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8c_BFu8s, BFu8i_BFu8c_BFu8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i) C1{ Fi:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i, BFu8i_BFu8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8i_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i_BFs8c) C1{ Fi:8 Fc:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i_BFs8c, BFu8i_BFu8c_BFu8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8i_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i_BFs8i) C1{ Fi:8 Fc:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i_BFs8i, BFu8i_BFu8c_BFu8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8i_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i_BFs8ll) C1{ Fi:8 Fc:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i_BFs8ll, BFu8i_BFu8c_BFu8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8i_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i_BFs8s) C1{ Fi:8 Fc:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i_BFs8s, BFu8i_BFu8c_BFu8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFu8i_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i_BFu8c) C1{ Fi:8 Fc:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i_BFu8c, BFu8i_BFu8c_BFu8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8i_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i_BFu8i) C1{ Fi:8 Fc:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i_BFu8i, BFu8i_BFu8c_BFu8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8i_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i_BFu8ll) C1{ Fi:8 Fc:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i_BFu8ll, BFu8i_BFu8c_BFu8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8i_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8i_BFu8s) C1{ Fi:8 Fc:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8i_BFu8s, BFu8i_BFu8c_BFu8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll) C1{ Fi:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll, BFu8i_BFu8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll_BFs8c) C1{ Fi:8 Fc:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll_BFs8c, BFu8i_BFu8c_BFu8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll_BFs8i) C1{ Fi:8 Fc:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll_BFs8i, BFu8i_BFu8c_BFu8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll_BFs8ll) C1{ Fi:8 Fc:8 FL:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll_BFs8ll, BFu8i_BFu8c_BFu8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll_BFs8s) C1{ Fi:8 Fc:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll_BFs8s, BFu8i_BFu8c_BFu8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll_BFu8c) C1{ Fi:8 Fc:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll_BFu8c, BFu8i_BFu8c_BFu8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll_BFu8i) C1{ Fi:8 Fc:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll_BFu8i, BFu8i_BFu8c_BFu8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll_BFu8ll) C1{ Fi:8 Fc:8 FL:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll_BFu8ll, BFu8i_BFu8c_BFu8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8ll_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8ll_BFu8s) C1{ Fi:8 Fc:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8ll_BFu8s, BFu8i_BFu8c_BFu8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s) C1{ Fi:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s, BFu8i_BFu8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFu8s_BFs8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s_BFs8c) C1{ Fi:8 Fc:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8s_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s_BFs8c, BFu8i_BFu8c_BFu8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8s_BFs8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s_BFs8i) C1{ Fi:8 Fc:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s_BFs8i, BFu8i_BFu8c_BFu8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8s_BFs8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s_BFs8ll) C1{ Fi:8 Fc:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s_BFs8ll, BFu8i_BFu8c_BFu8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8s_BFs8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s_BFs8s) C1{ Fi:8 Fc:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8s_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8c_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s_BFs8s, BFu8i_BFu8c_BFu8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8c_BFu8s_BFu8c  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s_BFu8c) C1{ Fi:8 Fc:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8c_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s_BFu8c, BFu8i_BFu8c_BFu8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8c_BFu8s_BFu8i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s_BFu8i) C1{ Fi:8 Fc:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8c_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s_BFu8i, BFu8i_BFu8c_BFu8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8c_BFu8s_BFu8ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s_BFu8ll) C1{ Fi:8 Fc:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8c_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s_BFu8ll, BFu8i_BFu8c_BFu8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8c_BFu8s_BFu8s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8c_BFu8s_BFu8s) C1{ Fi:8 Fc:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8c_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu8s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu8s_BFu8s, BFu8i_BFu8c_BFu8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8c_BFu9i  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu8c_BFu9i) C1{ Fi:8 Fc:8 Fi:9}



static void Test_BFu8i_BFu8c_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu9i");
    static STRUCT_IF_C BFu8i_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu9i, BFu8i_BFu8c_BFu9i)
//============================================================================


struct  BFu8i_BFu8c_BFu9ll  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu8c_BFu9ll) C1{ Fi:8 Fc:8 FL:9}



static void Test_BFu8i_BFu8c_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu9ll, BFu8i_BFu8c_BFu9ll)
//============================================================================


struct  BFu8i_BFu8c_BFu9s  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu8c_BFu9s) C1{ Fi:8 Fc:8 Fs:9}



static void Test_BFu8i_BFu8c_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu8c_BFu9s");
    static STRUCT_IF_C BFu8i_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_BFu9s, BFu8i_BFu8c_BFu9s)
//============================================================================


struct  BFu8i_BFu8c_C  {
  unsigned int v1:8;
  unsigned char v2:8;
  char v3;
};
//SIG(1 BFu8i_BFu8c_C) C1{ Fi:8 Fc:8 Fc}



static void Test_BFu8i_BFu8c_C()
{
  {
    init_simple_test("BFu8i_BFu8c_C");
    static STRUCT_IF_C BFu8i_BFu8c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_C");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_C, BFu8i_BFu8c_C)
//============================================================================


struct  BFu8i_BFu8c_D  {
  unsigned int v1:8;
  unsigned char v2:8;
  double v3;
};
//SIG(1 BFu8i_BFu8c_D) C1{ Fi:8 Fc:8 FL}



static void Test_BFu8i_BFu8c_D()
{
  {
    init_simple_test("BFu8i_BFu8c_D");
    static STRUCT_IF_C BFu8i_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_D, BFu8i_BFu8c_D)
//============================================================================


struct  BFu8i_BFu8c_F  {
  unsigned int v1:8;
  unsigned char v2:8;
  float v3;
};
//SIG(1 BFu8i_BFu8c_F) C1{ Fi:8 Fc:8 Fi}



static void Test_BFu8i_BFu8c_F()
{
  {
    init_simple_test("BFu8i_BFu8c_F");
    static STRUCT_IF_C BFu8i_BFu8c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_F, BFu8i_BFu8c_F)
//============================================================================


struct  BFu8i_BFu8c_I  {
  unsigned int v1:8;
  unsigned char v2:8;
  int v3;
};
//SIG(1 BFu8i_BFu8c_I) C1{ Fi:8 Fc:8 Fi}



static void Test_BFu8i_BFu8c_I()
{
  {
    init_simple_test("BFu8i_BFu8c_I");
    static STRUCT_IF_C BFu8i_BFu8c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_I, BFu8i_BFu8c_I)
//============================================================================


struct  BFu8i_BFu8c_Ip  {
  unsigned int v1:8;
  unsigned char v2:8;
  int *v3;
};
//SIG(1 BFu8i_BFu8c_Ip) C1{ Fi:8 Fc:8 Fp}



static void Test_BFu8i_BFu8c_Ip()
{
  {
    init_simple_test("BFu8i_BFu8c_Ip");
    static STRUCT_IF_C BFu8i_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_Ip, BFu8i_BFu8c_Ip)
//============================================================================


struct  BFu8i_BFu8c_L  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu8c_L) C1{ Fi:8 Fc:8 FL}



static void Test_BFu8i_BFu8c_L()
{
  {
    init_simple_test("BFu8i_BFu8c_L");
    static STRUCT_IF_C BFu8i_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_L, BFu8i_BFu8c_L)
//============================================================================


struct  BFu8i_BFu8c_S  {
  unsigned int v1:8;
  unsigned char v2:8;
  short v3;
};
//SIG(1 BFu8i_BFu8c_S) C1{ Fi:8 Fc:8 Fs}



static void Test_BFu8i_BFu8c_S()
{
  {
    init_simple_test("BFu8i_BFu8c_S");
    static STRUCT_IF_C BFu8i_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_S");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_S, BFu8i_BFu8c_S)
//============================================================================


struct  BFu8i_BFu8c_Uc  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu8c_Uc) C1{ Fi:8 Fc:8 Fc}



static void Test_BFu8i_BFu8c_Uc()
{
  {
    init_simple_test("BFu8i_BFu8c_Uc");
    static STRUCT_IF_C BFu8i_BFu8c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Uc");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_Uc, BFu8i_BFu8c_Uc)
//============================================================================


struct  BFu8i_BFu8c_Ui  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu8c_Ui) C1{ Fi:8 Fc:8 Fi}



static void Test_BFu8i_BFu8c_Ui()
{
  {
    init_simple_test("BFu8i_BFu8c_Ui");
    static STRUCT_IF_C BFu8i_BFu8c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_Ui, BFu8i_BFu8c_Ui)
//============================================================================


struct  BFu8i_BFu8c_Ul  {
  unsigned int v1:8;
  unsigned char v2:8;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu8c_Ul) C1{ Fi:8 Fc:8 FL}



static void Test_BFu8i_BFu8c_Ul()
{
  {
    init_simple_test("BFu8i_BFu8c_Ul");
    static STRUCT_IF_C BFu8i_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_Ul, BFu8i_BFu8c_Ul)
//============================================================================


struct  BFu8i_BFu8c_Us  {
  unsigned int v1:8;
  unsigned char v2:8;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu8c_Us) C1{ Fi:8 Fc:8 Fs}



static void Test_BFu8i_BFu8c_Us()
{
  {
    init_simple_test("BFu8i_BFu8c_Us");
    static STRUCT_IF_C BFu8i_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Us");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_Us, BFu8i_BFu8c_Us)
//============================================================================


struct  BFu8i_BFu8c_Vp  {
  unsigned int v1:8;
  unsigned char v2:8;
  void *v3;
};
//SIG(1 BFu8i_BFu8c_Vp) C1{ Fi:8 Fc:8 Fp}



static void Test_BFu8i_BFu8c_Vp()
{
  {
    init_simple_test("BFu8i_BFu8c_Vp");
    static STRUCT_IF_C BFu8i_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_Vp, BFu8i_BFu8c_Vp)
//============================================================================


struct  BFu8i_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu8i_BFu8i) C1{ Fi:8 Fi:8}



static void Test_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i, BFu8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c) C1{ Fi:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c, BFu8i_BFu8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8c_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c_BFs8c) C1{ Fi:8 Fi:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8c_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c_BFs8c, BFu8i_BFu8i_BFs8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8c_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c_BFs8i) C1{ Fi:8 Fi:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c_BFs8i, BFu8i_BFu8i_BFs8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8c_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c_BFs8ll) C1{ Fi:8 Fi:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c_BFs8ll, BFu8i_BFu8i_BFs8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8c_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c_BFs8s) C1{ Fi:8 Fi:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8c_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c_BFs8s, BFu8i_BFu8i_BFs8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFs8c_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c_BFu8c) C1{ Fi:8 Fi:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c_BFu8c, BFu8i_BFu8i_BFs8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8c_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c_BFu8i) C1{ Fi:8 Fi:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c_BFu8i, BFu8i_BFu8i_BFs8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8c_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c_BFu8ll) C1{ Fi:8 Fi:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c_BFu8ll, BFu8i_BFu8i_BFs8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8c_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8c_BFu8s) C1{ Fi:8 Fi:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8c_BFu8s, BFu8i_BFu8i_BFs8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i) C1{ Fi:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i, BFu8i_BFu8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8i_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i_BFs8c) C1{ Fi:8 Fi:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i_BFs8c, BFu8i_BFu8i_BFs8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8i_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i_BFs8i) C1{ Fi:8 Fi:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i_BFs8i, BFu8i_BFu8i_BFs8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8i_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i_BFs8ll) C1{ Fi:8 Fi:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i_BFs8ll, BFu8i_BFu8i_BFs8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8i_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i_BFs8s) C1{ Fi:8 Fi:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i_BFs8s, BFu8i_BFu8i_BFs8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFs8i_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i_BFu8c) C1{ Fi:8 Fi:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i_BFu8c, BFu8i_BFu8i_BFs8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8i_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i_BFu8i) C1{ Fi:8 Fi:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i_BFu8i, BFu8i_BFu8i_BFs8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8i_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i_BFu8ll) C1{ Fi:8 Fi:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i_BFu8ll, BFu8i_BFu8i_BFs8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8i_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8i_BFu8s) C1{ Fi:8 Fi:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8i_BFu8s, BFu8i_BFu8i_BFs8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll) C1{ Fi:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll, BFu8i_BFu8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll_BFs8c) C1{ Fi:8 Fi:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll_BFs8c, BFu8i_BFu8i_BFs8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll_BFs8i) C1{ Fi:8 Fi:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll_BFs8i, BFu8i_BFu8i_BFs8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll_BFs8ll) C1{ Fi:8 Fi:8 FL:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll_BFs8ll, BFu8i_BFu8i_BFs8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll_BFs8s) C1{ Fi:8 Fi:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll_BFs8s, BFu8i_BFu8i_BFs8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll_BFu8c) C1{ Fi:8 Fi:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll_BFu8c, BFu8i_BFu8i_BFs8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll_BFu8i) C1{ Fi:8 Fi:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll_BFu8i, BFu8i_BFu8i_BFs8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll_BFu8ll) C1{ Fi:8 Fi:8 FL:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll_BFu8ll, BFu8i_BFu8i_BFs8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8ll_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed __tsi64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8ll_BFu8s) C1{ Fi:8 Fi:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8ll_BFu8s, BFu8i_BFu8i_BFs8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s) C1{ Fi:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s, BFu8i_BFu8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFs8s_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s_BFs8c) C1{ Fi:8 Fi:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8s_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s_BFs8c, BFu8i_BFu8i_BFs8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8s_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s_BFs8i) C1{ Fi:8 Fi:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s_BFs8i, BFu8i_BFu8i_BFs8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8s_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s_BFs8ll) C1{ Fi:8 Fi:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s_BFs8ll, BFu8i_BFu8i_BFs8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8s_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s_BFs8s) C1{ Fi:8 Fi:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8s_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s_BFs8s, BFu8i_BFu8i_BFs8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFs8s_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s_BFu8c) C1{ Fi:8 Fi:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8i_BFs8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s_BFu8c, BFu8i_BFu8i_BFs8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFs8s_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s_BFu8i) C1{ Fi:8 Fi:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8i_BFs8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s_BFu8i, BFu8i_BFu8i_BFs8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFs8s_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s_BFu8ll) C1{ Fi:8 Fi:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8i_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFs8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s_BFu8ll, BFu8i_BFu8i_BFs8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFs8s_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  signed short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFs8s_BFu8s) C1{ Fi:8 Fi:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8i_BFs8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFs8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFs8s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFs8s_BFu8s, BFu8i_BFu8i_BFs8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFu15i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu8i_BFu15i) C1{ Fi:8 Fi:8 Fi:15}



static void Test_BFu8i_BFu8i_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu15i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu15i, BFu8i_BFu8i_BFu15i)
//============================================================================


struct  BFu8i_BFu8i_BFu15ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu8i_BFu15ll) C1{ Fi:8 Fi:8 FL:15}



static void Test_BFu8i_BFu8i_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu15ll, BFu8i_BFu8i_BFu15ll)
//============================================================================


struct  BFu8i_BFu8i_BFu15s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu8i_BFu15s) C1{ Fi:8 Fi:8 Fs:15}



static void Test_BFu8i_BFu8i_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu15s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu15s, BFu8i_BFu8i_BFu15s)
//============================================================================


struct  BFu8i_BFu8i_BFu16i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu8i_BFu16i) C1{ Fi:8 Fi:8 Fi:16}



static void Test_BFu8i_BFu8i_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu16i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu16i, BFu8i_BFu8i_BFu16i)
//============================================================================


struct  BFu8i_BFu8i_BFu16ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu8i_BFu16ll) C1{ Fi:8 Fi:8 FL:16}



static void Test_BFu8i_BFu8i_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu16ll, BFu8i_BFu8i_BFu16ll)
//============================================================================


struct  BFu8i_BFu8i_BFu16s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu8i_BFu16s) C1{ Fi:8 Fi:8 Fs:16}



static void Test_BFu8i_BFu8i_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu16s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu16s, BFu8i_BFu8i_BFu16s)
//============================================================================


struct  BFu8i_BFu8i_BFu17i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu8i_BFu17i) C1{ Fi:8 Fi:8 Fi:17}



static void Test_BFu8i_BFu8i_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu17i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu17i, BFu8i_BFu8i_BFu17i)
//============================================================================


struct  BFu8i_BFu8i_BFu17ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu8i_BFu17ll) C1{ Fi:8 Fi:8 FL:17}



static void Test_BFu8i_BFu8i_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu17ll, BFu8i_BFu8i_BFu17ll)
//============================================================================


struct  BFu8i_BFu8i_BFu1c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu8i_BFu1c) C1{ Fi:8 Fi:8 Fc:1}



static void Test_BFu8i_BFu8i_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu1c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu1c, BFu8i_BFu8i_BFu1c)
//============================================================================


struct  BFu8i_BFu8i_BFu1i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu8i_BFu1i) C1{ Fi:8 Fi:8 Fi:1}



static void Test_BFu8i_BFu8i_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu1i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu1i, BFu8i_BFu8i_BFu1i)
//============================================================================


struct  BFu8i_BFu8i_BFu1ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu8i_BFu1ll) C1{ Fi:8 Fi:8 FL:1}



static void Test_BFu8i_BFu8i_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu1ll, BFu8i_BFu8i_BFu1ll)
//============================================================================


struct  BFu8i_BFu8i_BFu1s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu8i_BFu1s) C1{ Fi:8 Fi:8 Fs:1}



static void Test_BFu8i_BFu8i_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu1s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu1s, BFu8i_BFu8i_BFu1s)
//============================================================================


struct  BFu8i_BFu8i_BFu31i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu8i_BFu31i) C1{ Fi:8 Fi:8 Fi:31}



static void Test_BFu8i_BFu8i_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu31i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu31i, BFu8i_BFu8i_BFu31i)
//============================================================================


struct  BFu8i_BFu8i_BFu31ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu8i_BFu31ll) C1{ Fi:8 Fi:8 FL:31}



static void Test_BFu8i_BFu8i_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu31ll, BFu8i_BFu8i_BFu31ll)
//============================================================================


struct  BFu8i_BFu8i_BFu32i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu8i_BFu32i) C1{ Fi:8 Fi:8 Fi:32}



static void Test_BFu8i_BFu8i_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu32i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu32i, BFu8i_BFu8i_BFu32i)
//============================================================================


struct  BFu8i_BFu8i_BFu32ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu8i_BFu32ll) C1{ Fi:8 Fi:8 FL:32}



static void Test_BFu8i_BFu8i_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu32ll, BFu8i_BFu8i_BFu32ll)
//============================================================================


struct  BFu8i_BFu8i_BFu33  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu8i_BFu33) C1{ Fi:8 Fi:8 FL:33}



static void Test_BFu8i_BFu8i_BFu33()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu33");
    static STRUCT_IF_C BFu8i_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8i_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu33, BFu8i_BFu8i_BFu33)
//============================================================================


struct  BFu8i_BFu8i_BFu7c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu8i_BFu7c) C1{ Fi:8 Fi:8 Fc:7}



static void Test_BFu8i_BFu8i_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu7c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu7c, BFu8i_BFu8i_BFu7c)
//============================================================================


struct  BFu8i_BFu8i_BFu7i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu8i_BFu7i) C1{ Fi:8 Fi:8 Fi:7}



static void Test_BFu8i_BFu8i_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu7i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu7i, BFu8i_BFu8i_BFu7i)
//============================================================================


struct  BFu8i_BFu8i_BFu7ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu8i_BFu7ll) C1{ Fi:8 Fi:8 FL:7}



static void Test_BFu8i_BFu8i_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu7ll, BFu8i_BFu8i_BFu7ll)
//============================================================================


struct  BFu8i_BFu8i_BFu7s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu8i_BFu7s) C1{ Fi:8 Fi:8 Fs:7}



static void Test_BFu8i_BFu8i_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu7s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu7s, BFu8i_BFu8i_BFu7s)
//============================================================================


struct  BFu8i_BFu8i_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c) C1{ Fi:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c, BFu8i_BFu8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8c_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c_BFs8c) C1{ Fi:8 Fi:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8c_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c_BFs8c, BFu8i_BFu8i_BFu8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8c_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c_BFs8i) C1{ Fi:8 Fi:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c_BFs8i, BFu8i_BFu8i_BFu8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8c_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c_BFs8ll) C1{ Fi:8 Fi:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c_BFs8ll, BFu8i_BFu8i_BFu8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8c_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c_BFs8s) C1{ Fi:8 Fi:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8c_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c_BFs8s, BFu8i_BFu8i_BFu8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFu8c_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c_BFu8c) C1{ Fi:8 Fi:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c_BFu8c, BFu8i_BFu8i_BFu8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8c_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c_BFu8i) C1{ Fi:8 Fi:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c_BFu8i, BFu8i_BFu8i_BFu8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8c_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c_BFu8ll) C1{ Fi:8 Fi:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c_BFu8ll, BFu8i_BFu8i_BFu8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8c_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8c_BFu8s) C1{ Fi:8 Fi:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8c_BFu8s, BFu8i_BFu8i_BFu8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i) C1{ Fi:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i, BFu8i_BFu8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8i_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i_BFs8c) C1{ Fi:8 Fi:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i_BFs8c, BFu8i_BFu8i_BFu8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8i_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i_BFs8i) C1{ Fi:8 Fi:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i_BFs8i, BFu8i_BFu8i_BFu8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8i_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i_BFs8ll) C1{ Fi:8 Fi:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i_BFs8ll, BFu8i_BFu8i_BFu8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8i_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i_BFs8s) C1{ Fi:8 Fi:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i_BFs8s, BFu8i_BFu8i_BFu8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFu8i_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i_BFu8c) C1{ Fi:8 Fi:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i_BFu8c, BFu8i_BFu8i_BFu8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8i_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i_BFu8i) C1{ Fi:8 Fi:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i_BFu8i, BFu8i_BFu8i_BFu8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8i_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i_BFu8ll) C1{ Fi:8 Fi:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i_BFu8ll, BFu8i_BFu8i_BFu8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8i_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8i_BFu8s) C1{ Fi:8 Fi:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8i_BFu8s, BFu8i_BFu8i_BFu8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll) C1{ Fi:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll, BFu8i_BFu8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll_BFs8c) C1{ Fi:8 Fi:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll_BFs8c, BFu8i_BFu8i_BFu8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll_BFs8i) C1{ Fi:8 Fi:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll_BFs8i, BFu8i_BFu8i_BFu8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll_BFs8ll) C1{ Fi:8 Fi:8 FL:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll_BFs8ll, BFu8i_BFu8i_BFu8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll_BFs8s) C1{ Fi:8 Fi:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll_BFs8s, BFu8i_BFu8i_BFu8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll_BFu8c) C1{ Fi:8 Fi:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll_BFu8c, BFu8i_BFu8i_BFu8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll_BFu8i) C1{ Fi:8 Fi:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll_BFu8i, BFu8i_BFu8i_BFu8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll_BFu8ll) C1{ Fi:8 Fi:8 FL:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll_BFu8ll, BFu8i_BFu8i_BFu8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8ll_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8ll_BFu8s) C1{ Fi:8 Fi:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8ll_BFu8s, BFu8i_BFu8i_BFu8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s) C1{ Fi:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s, BFu8i_BFu8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFu8s_BFs8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s_BFs8c) C1{ Fi:8 Fi:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8s_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s_BFs8c, BFu8i_BFu8i_BFu8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8s_BFs8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s_BFs8i) C1{ Fi:8 Fi:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s_BFs8i, BFu8i_BFu8i_BFu8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8s_BFs8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s_BFs8ll) C1{ Fi:8 Fi:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s_BFs8ll, BFu8i_BFu8i_BFu8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8s_BFs8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s_BFs8s) C1{ Fi:8 Fi:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8s_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8i_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s_BFs8s, BFu8i_BFu8i_BFu8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8i_BFu8s_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s_BFu8c) C1{ Fi:8 Fi:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8i_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s_BFu8c, BFu8i_BFu8i_BFu8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8i_BFu8s_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s_BFu8i) C1{ Fi:8 Fi:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8i_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s_BFu8i, BFu8i_BFu8i_BFu8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8i_BFu8s_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s_BFu8ll) C1{ Fi:8 Fi:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8i_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s_BFu8ll, BFu8i_BFu8i_BFu8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8i_BFu8s_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8i_BFu8s_BFu8s) C1{ Fi:8 Fi:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8i_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu8s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu8s_BFu8s, BFu8i_BFu8i_BFu8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8i_BFu9i  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu8i_BFu9i) C1{ Fi:8 Fi:8 Fi:9}



static void Test_BFu8i_BFu8i_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu9i");
    static STRUCT_IF_C BFu8i_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu9i, BFu8i_BFu8i_BFu9i)
//============================================================================


struct  BFu8i_BFu8i_BFu9ll  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu8i_BFu9ll) C1{ Fi:8 Fi:8 FL:9}



static void Test_BFu8i_BFu8i_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu9ll, BFu8i_BFu8i_BFu9ll)
//============================================================================


struct  BFu8i_BFu8i_BFu9s  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu8i_BFu9s) C1{ Fi:8 Fi:8 Fs:9}



static void Test_BFu8i_BFu8i_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu8i_BFu9s");
    static STRUCT_IF_C BFu8i_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_BFu9s, BFu8i_BFu8i_BFu9s)
//============================================================================


struct  BFu8i_BFu8i_C  {
  unsigned int v1:8;
  unsigned int v2:8;
  char v3;
};
//SIG(1 BFu8i_BFu8i_C) C1{ Fi:8 Fi:8 Fc}



static void Test_BFu8i_BFu8i_C()
{
  {
    init_simple_test("BFu8i_BFu8i_C");
    static STRUCT_IF_C BFu8i_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_C");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_C, BFu8i_BFu8i_C)
//============================================================================


struct  BFu8i_BFu8i_D  {
  unsigned int v1:8;
  unsigned int v2:8;
  double v3;
};
//SIG(1 BFu8i_BFu8i_D) C1{ Fi:8 Fi:8 FL}



static void Test_BFu8i_BFu8i_D()
{
  {
    init_simple_test("BFu8i_BFu8i_D");
    static STRUCT_IF_C BFu8i_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_D, BFu8i_BFu8i_D)
//============================================================================


struct  BFu8i_BFu8i_F  {
  unsigned int v1:8;
  unsigned int v2:8;
  float v3;
};
//SIG(1 BFu8i_BFu8i_F) C1{ Fi:8 Fi:8 Fi}



static void Test_BFu8i_BFu8i_F()
{
  {
    init_simple_test("BFu8i_BFu8i_F");
    static STRUCT_IF_C BFu8i_BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_F, BFu8i_BFu8i_F)
//============================================================================


struct  BFu8i_BFu8i_I  {
  unsigned int v1:8;
  unsigned int v2:8;
  int v3;
};
//SIG(1 BFu8i_BFu8i_I) C1{ Fi:8 Fi:8 Fi}



static void Test_BFu8i_BFu8i_I()
{
  {
    init_simple_test("BFu8i_BFu8i_I");
    static STRUCT_IF_C BFu8i_BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_I, BFu8i_BFu8i_I)
//============================================================================


struct  BFu8i_BFu8i_Ip  {
  unsigned int v1:8;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 BFu8i_BFu8i_Ip) C1{ Fi:8 Fi:8 Fp}



static void Test_BFu8i_BFu8i_Ip()
{
  {
    init_simple_test("BFu8i_BFu8i_Ip");
    static STRUCT_IF_C BFu8i_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_Ip, BFu8i_BFu8i_Ip)
//============================================================================


struct  BFu8i_BFu8i_L  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu8i_L) C1{ Fi:8 Fi:8 FL}



static void Test_BFu8i_BFu8i_L()
{
  {
    init_simple_test("BFu8i_BFu8i_L");
    static STRUCT_IF_C BFu8i_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_L, BFu8i_BFu8i_L)
//============================================================================


struct  BFu8i_BFu8i_S  {
  unsigned int v1:8;
  unsigned int v2:8;
  short v3;
};
//SIG(1 BFu8i_BFu8i_S) C1{ Fi:8 Fi:8 Fs}



static void Test_BFu8i_BFu8i_S()
{
  {
    init_simple_test("BFu8i_BFu8i_S");
    static STRUCT_IF_C BFu8i_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_S");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_S, BFu8i_BFu8i_S)
//============================================================================


struct  BFu8i_BFu8i_Uc  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu8i_Uc) C1{ Fi:8 Fi:8 Fc}



static void Test_BFu8i_BFu8i_Uc()
{
  {
    init_simple_test("BFu8i_BFu8i_Uc");
    static STRUCT_IF_C BFu8i_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Uc");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_Uc, BFu8i_BFu8i_Uc)
//============================================================================


struct  BFu8i_BFu8i_Ui  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu8i_Ui) C1{ Fi:8 Fi:8 Fi}



static void Test_BFu8i_BFu8i_Ui()
{
  {
    init_simple_test("BFu8i_BFu8i_Ui");
    static STRUCT_IF_C BFu8i_BFu8i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_Ui, BFu8i_BFu8i_Ui)
//============================================================================


struct  BFu8i_BFu8i_Ul  {
  unsigned int v1:8;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu8i_Ul) C1{ Fi:8 Fi:8 FL}



static void Test_BFu8i_BFu8i_Ul()
{
  {
    init_simple_test("BFu8i_BFu8i_Ul");
    static STRUCT_IF_C BFu8i_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_Ul, BFu8i_BFu8i_Ul)
//============================================================================


struct  BFu8i_BFu8i_Us  {
  unsigned int v1:8;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu8i_Us) C1{ Fi:8 Fi:8 Fs}



static void Test_BFu8i_BFu8i_Us()
{
  {
    init_simple_test("BFu8i_BFu8i_Us");
    static STRUCT_IF_C BFu8i_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Us");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_Us, BFu8i_BFu8i_Us)
//============================================================================


struct  BFu8i_BFu8i_Vp  {
  unsigned int v1:8;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 BFu8i_BFu8i_Vp) C1{ Fi:8 Fi:8 Fp}



static void Test_BFu8i_BFu8i_Vp()
{
  {
    init_simple_test("BFu8i_BFu8i_Vp");
    static STRUCT_IF_C BFu8i_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_Vp, BFu8i_BFu8i_Vp)
//============================================================================


struct  BFu8i_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu8i_BFu8ll) C1{ Fi:8 FL:8}



static void Test_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll, BFu8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c) C1{ Fi:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c, BFu8i_BFu8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c_BFs8c) C1{ Fi:8 FL:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c_BFs8c, BFu8i_BFu8ll_BFs8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c_BFs8i) C1{ Fi:8 FL:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c_BFs8i, BFu8i_BFu8ll_BFs8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c_BFs8ll) C1{ Fi:8 FL:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c_BFs8ll, BFu8i_BFu8ll_BFs8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c_BFs8s) C1{ Fi:8 FL:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c_BFs8s, BFu8i_BFu8ll_BFs8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c_BFu8c) C1{ Fi:8 FL:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c_BFu8c, BFu8i_BFu8ll_BFs8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c_BFu8i) C1{ Fi:8 FL:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c_BFu8i, BFu8i_BFu8ll_BFs8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c_BFu8ll) C1{ Fi:8 FL:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c_BFu8ll, BFu8i_BFu8ll_BFs8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8c_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8c_BFu8s) C1{ Fi:8 FL:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8c_BFu8s, BFu8i_BFu8ll_BFs8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i) C1{ Fi:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i, BFu8i_BFu8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i_BFs8c) C1{ Fi:8 FL:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i_BFs8c, BFu8i_BFu8ll_BFs8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i_BFs8i) C1{ Fi:8 FL:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i_BFs8i, BFu8i_BFu8ll_BFs8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i_BFs8ll) C1{ Fi:8 FL:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i_BFs8ll, BFu8i_BFu8ll_BFs8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i_BFs8s) C1{ Fi:8 FL:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i_BFs8s, BFu8i_BFu8ll_BFs8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i_BFu8c) C1{ Fi:8 FL:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i_BFu8c, BFu8i_BFu8ll_BFs8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i_BFu8i) C1{ Fi:8 FL:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i_BFu8i, BFu8i_BFu8ll_BFs8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i_BFu8ll) C1{ Fi:8 FL:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i_BFu8ll, BFu8i_BFu8ll_BFs8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8i_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8i_BFu8s) C1{ Fi:8 FL:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8i_BFu8s, BFu8i_BFu8ll_BFs8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll) C1{ Fi:8 FL:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll, BFu8i_BFu8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll_BFs8c) C1{ Fi:8 FL:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll_BFs8c, BFu8i_BFu8ll_BFs8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll_BFs8i) C1{ Fi:8 FL:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll_BFs8i, BFu8i_BFu8ll_BFs8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll_BFs8ll) C1{ Fi:8 FL:8 FL:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll_BFs8ll, BFu8i_BFu8ll_BFs8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll_BFs8s) C1{ Fi:8 FL:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll_BFs8s, BFu8i_BFu8ll_BFs8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll_BFu8c) C1{ Fi:8 FL:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll_BFu8c, BFu8i_BFu8ll_BFs8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll_BFu8i) C1{ Fi:8 FL:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll_BFu8i, BFu8i_BFu8ll_BFs8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll_BFu8ll) C1{ Fi:8 FL:8 FL:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll_BFu8ll, BFu8i_BFu8ll_BFs8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8ll_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed __tsi64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8ll_BFu8s) C1{ Fi:8 FL:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8ll_BFu8s, BFu8i_BFu8ll_BFs8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s) C1{ Fi:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s, BFu8i_BFu8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s_BFs8c) C1{ Fi:8 FL:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s_BFs8c, BFu8i_BFu8ll_BFs8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s_BFs8i) C1{ Fi:8 FL:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s_BFs8i, BFu8i_BFu8ll_BFs8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s_BFs8ll) C1{ Fi:8 FL:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s_BFs8ll, BFu8i_BFu8ll_BFs8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s_BFs8s) C1{ Fi:8 FL:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s_BFs8s, BFu8i_BFu8ll_BFs8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s_BFu8c) C1{ Fi:8 FL:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFs8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s_BFu8c, BFu8i_BFu8ll_BFs8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s_BFu8i) C1{ Fi:8 FL:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFs8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s_BFu8i, BFu8i_BFu8ll_BFs8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s_BFu8ll) C1{ Fi:8 FL:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8ll_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s_BFu8ll, BFu8i_BFu8ll_BFs8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFs8s_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  signed short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFs8s_BFu8s) C1{ Fi:8 FL:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFs8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFs8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFs8s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFs8s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFs8s_BFu8s, BFu8i_BFu8ll_BFs8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu15i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu8ll_BFu15i) C1{ Fi:8 FL:8 Fi:15}



static void Test_BFu8i_BFu8ll_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu15i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu15i, BFu8i_BFu8ll_BFu15i)
//============================================================================


struct  BFu8i_BFu8ll_BFu15ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu8ll_BFu15ll) C1{ Fi:8 FL:8 FL:15}



static void Test_BFu8i_BFu8ll_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu15ll, BFu8i_BFu8ll_BFu15ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu15s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu8ll_BFu15s) C1{ Fi:8 FL:8 Fs:15}



static void Test_BFu8i_BFu8ll_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu15s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu15s, BFu8i_BFu8ll_BFu15s)
//============================================================================


struct  BFu8i_BFu8ll_BFu16i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu8ll_BFu16i) C1{ Fi:8 FL:8 Fi:16}



static void Test_BFu8i_BFu8ll_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu16i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu16i, BFu8i_BFu8ll_BFu16i)
//============================================================================


struct  BFu8i_BFu8ll_BFu16ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu8ll_BFu16ll) C1{ Fi:8 FL:8 FL:16}



static void Test_BFu8i_BFu8ll_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu16ll, BFu8i_BFu8ll_BFu16ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu16s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu8ll_BFu16s) C1{ Fi:8 FL:8 Fs:16}



static void Test_BFu8i_BFu8ll_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu16s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu16s, BFu8i_BFu8ll_BFu16s)
//============================================================================


struct  BFu8i_BFu8ll_BFu17i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu8ll_BFu17i) C1{ Fi:8 FL:8 Fi:17}



static void Test_BFu8i_BFu8ll_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu17i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu17i, BFu8i_BFu8ll_BFu17i)
//============================================================================


struct  BFu8i_BFu8ll_BFu17ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu8ll_BFu17ll) C1{ Fi:8 FL:8 FL:17}



static void Test_BFu8i_BFu8ll_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu17ll, BFu8i_BFu8ll_BFu17ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu1c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu8ll_BFu1c) C1{ Fi:8 FL:8 Fc:1}



static void Test_BFu8i_BFu8ll_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu1c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu1c, BFu8i_BFu8ll_BFu1c)
//============================================================================


struct  BFu8i_BFu8ll_BFu1i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu8ll_BFu1i) C1{ Fi:8 FL:8 Fi:1}



static void Test_BFu8i_BFu8ll_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu1i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu1i, BFu8i_BFu8ll_BFu1i)
//============================================================================


struct  BFu8i_BFu8ll_BFu1ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu8ll_BFu1ll) C1{ Fi:8 FL:8 FL:1}



static void Test_BFu8i_BFu8ll_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu1ll, BFu8i_BFu8ll_BFu1ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu1s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu8ll_BFu1s) C1{ Fi:8 FL:8 Fs:1}



static void Test_BFu8i_BFu8ll_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu1s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu1s, BFu8i_BFu8ll_BFu1s)
//============================================================================


struct  BFu8i_BFu8ll_BFu31i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu8ll_BFu31i) C1{ Fi:8 FL:8 Fi:31}



static void Test_BFu8i_BFu8ll_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu31i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu31i, BFu8i_BFu8ll_BFu31i)
//============================================================================


struct  BFu8i_BFu8ll_BFu31ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu8ll_BFu31ll) C1{ Fi:8 FL:8 FL:31}



static void Test_BFu8i_BFu8ll_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu31ll, BFu8i_BFu8ll_BFu31ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu32i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu8ll_BFu32i) C1{ Fi:8 FL:8 Fi:32}



static void Test_BFu8i_BFu8ll_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu32i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu32i, BFu8i_BFu8ll_BFu32i)
//============================================================================


struct  BFu8i_BFu8ll_BFu32ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu8ll_BFu32ll) C1{ Fi:8 FL:8 FL:32}



static void Test_BFu8i_BFu8ll_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu32ll, BFu8i_BFu8ll_BFu32ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu33  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu8ll_BFu33) C1{ Fi:8 FL:8 FL:33}



static void Test_BFu8i_BFu8ll_BFu33()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu33");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8i_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu33, BFu8i_BFu8ll_BFu33)
//============================================================================


struct  BFu8i_BFu8ll_BFu7c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu8ll_BFu7c) C1{ Fi:8 FL:8 Fc:7}



static void Test_BFu8i_BFu8ll_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu7c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu7c, BFu8i_BFu8ll_BFu7c)
//============================================================================


struct  BFu8i_BFu8ll_BFu7i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu8ll_BFu7i) C1{ Fi:8 FL:8 Fi:7}



static void Test_BFu8i_BFu8ll_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu7i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu7i, BFu8i_BFu8ll_BFu7i)
//============================================================================


struct  BFu8i_BFu8ll_BFu7ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu8ll_BFu7ll) C1{ Fi:8 FL:8 FL:7}



static void Test_BFu8i_BFu8ll_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu7ll, BFu8i_BFu8ll_BFu7ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu7s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu8ll_BFu7s) C1{ Fi:8 FL:8 Fs:7}



static void Test_BFu8i_BFu8ll_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu7s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu7s, BFu8i_BFu8ll_BFu7s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c) C1{ Fi:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c, BFu8i_BFu8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c_BFs8c) C1{ Fi:8 FL:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c_BFs8c, BFu8i_BFu8ll_BFu8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c_BFs8i) C1{ Fi:8 FL:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c_BFs8i, BFu8i_BFu8ll_BFu8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c_BFs8ll) C1{ Fi:8 FL:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c_BFs8ll, BFu8i_BFu8ll_BFu8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c_BFs8s) C1{ Fi:8 FL:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c_BFs8s, BFu8i_BFu8ll_BFu8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c_BFu8c) C1{ Fi:8 FL:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c_BFu8c, BFu8i_BFu8ll_BFu8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c_BFu8i) C1{ Fi:8 FL:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c_BFu8i, BFu8i_BFu8ll_BFu8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c_BFu8ll) C1{ Fi:8 FL:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c_BFu8ll, BFu8i_BFu8ll_BFu8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8c_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8c_BFu8s) C1{ Fi:8 FL:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8c_BFu8s, BFu8i_BFu8ll_BFu8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i) C1{ Fi:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i, BFu8i_BFu8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i_BFs8c) C1{ Fi:8 FL:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i_BFs8c, BFu8i_BFu8ll_BFu8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i_BFs8i) C1{ Fi:8 FL:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i_BFs8i, BFu8i_BFu8ll_BFu8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i_BFs8ll) C1{ Fi:8 FL:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i_BFs8ll, BFu8i_BFu8ll_BFu8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i_BFs8s) C1{ Fi:8 FL:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i_BFs8s, BFu8i_BFu8ll_BFu8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i_BFu8c) C1{ Fi:8 FL:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i_BFu8c, BFu8i_BFu8ll_BFu8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i_BFu8i) C1{ Fi:8 FL:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i_BFu8i, BFu8i_BFu8ll_BFu8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i_BFu8ll) C1{ Fi:8 FL:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i_BFu8ll, BFu8i_BFu8ll_BFu8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8i_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8i_BFu8s) C1{ Fi:8 FL:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8i_BFu8s, BFu8i_BFu8ll_BFu8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll) C1{ Fi:8 FL:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll, BFu8i_BFu8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll_BFs8c) C1{ Fi:8 FL:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll_BFs8c, BFu8i_BFu8ll_BFu8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll_BFs8i) C1{ Fi:8 FL:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll_BFs8i, BFu8i_BFu8ll_BFu8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll_BFs8ll) C1{ Fi:8 FL:8 FL:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll_BFs8ll, BFu8i_BFu8ll_BFu8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll_BFs8s) C1{ Fi:8 FL:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll_BFs8s, BFu8i_BFu8ll_BFu8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll_BFu8c) C1{ Fi:8 FL:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll_BFu8c, BFu8i_BFu8ll_BFu8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll_BFu8i) C1{ Fi:8 FL:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll_BFu8i, BFu8i_BFu8ll_BFu8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll_BFu8ll) C1{ Fi:8 FL:8 FL:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll_BFu8ll, BFu8i_BFu8ll_BFu8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8ll_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8ll_BFu8s) C1{ Fi:8 FL:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8ll_BFu8s, BFu8i_BFu8ll_BFu8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s) C1{ Fi:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s, BFu8i_BFu8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s_BFs8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s_BFs8c) C1{ Fi:8 FL:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s_BFs8c, BFu8i_BFu8ll_BFu8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s_BFs8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s_BFs8i) C1{ Fi:8 FL:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s_BFs8i, BFu8i_BFu8ll_BFu8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s_BFs8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s_BFs8ll) C1{ Fi:8 FL:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s_BFs8ll, BFu8i_BFu8ll_BFu8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s_BFs8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s_BFs8s) C1{ Fi:8 FL:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s_BFs8s, BFu8i_BFu8ll_BFu8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s_BFu8c) C1{ Fi:8 FL:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8ll_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s_BFu8c, BFu8i_BFu8ll_BFu8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s_BFu8i) C1{ Fi:8 FL:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8ll_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s_BFu8i, BFu8i_BFu8ll_BFu8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s_BFu8ll) C1{ Fi:8 FL:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8ll_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s_BFu8ll, BFu8i_BFu8ll_BFu8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu8s_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8ll_BFu8s_BFu8s) C1{ Fi:8 FL:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8ll_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu8s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu8s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu8s_BFu8s, BFu8i_BFu8ll_BFu8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8ll_BFu9i  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu8ll_BFu9i) C1{ Fi:8 FL:8 Fi:9}



static void Test_BFu8i_BFu8ll_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu9i");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu9i, BFu8i_BFu8ll_BFu9i)
//============================================================================


struct  BFu8i_BFu8ll_BFu9ll  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu8ll_BFu9ll) C1{ Fi:8 FL:8 FL:9}



static void Test_BFu8i_BFu8ll_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu9ll, BFu8i_BFu8ll_BFu9ll)
//============================================================================


struct  BFu8i_BFu8ll_BFu9s  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu8ll_BFu9s) C1{ Fi:8 FL:8 Fs:9}



static void Test_BFu8i_BFu8ll_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu8ll_BFu9s");
    static STRUCT_IF_C BFu8i_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_BFu9s, BFu8i_BFu8ll_BFu9s)
//============================================================================


struct  BFu8i_BFu8ll_C  {
  unsigned int v1:8;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 BFu8i_BFu8ll_C) C1{ Fi:8 FL:8 Fc}



static void Test_BFu8i_BFu8ll_C()
{
  {
    init_simple_test("BFu8i_BFu8ll_C");
    static STRUCT_IF_C BFu8i_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_C");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_C, BFu8i_BFu8ll_C)
//============================================================================


struct  BFu8i_BFu8ll_D  {
  unsigned int v1:8;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 BFu8i_BFu8ll_D) C1{ Fi:8 FL:8 FL}



static void Test_BFu8i_BFu8ll_D()
{
  {
    init_simple_test("BFu8i_BFu8ll_D");
    static STRUCT_IF_C BFu8i_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_D, BFu8i_BFu8ll_D)
//============================================================================


struct  BFu8i_BFu8ll_F  {
  unsigned int v1:8;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 BFu8i_BFu8ll_F) C1{ Fi:8 FL:8 Fi}



static void Test_BFu8i_BFu8ll_F()
{
  {
    init_simple_test("BFu8i_BFu8ll_F");
    static STRUCT_IF_C BFu8i_BFu8ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_F, BFu8i_BFu8ll_F)
//============================================================================


struct  BFu8i_BFu8ll_I  {
  unsigned int v1:8;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 BFu8i_BFu8ll_I) C1{ Fi:8 FL:8 Fi}



static void Test_BFu8i_BFu8ll_I()
{
  {
    init_simple_test("BFu8i_BFu8ll_I");
    static STRUCT_IF_C BFu8i_BFu8ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_I, BFu8i_BFu8ll_I)
//============================================================================


struct  BFu8i_BFu8ll_Ip  {
  unsigned int v1:8;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 BFu8i_BFu8ll_Ip) C1{ Fi:8 FL:8 Fp}



static void Test_BFu8i_BFu8ll_Ip()
{
  {
    init_simple_test("BFu8i_BFu8ll_Ip");
    static STRUCT_IF_C BFu8i_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_Ip, BFu8i_BFu8ll_Ip)
//============================================================================


struct  BFu8i_BFu8ll_L  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu8ll_L) C1{ Fi:8 FL:8 FL}



static void Test_BFu8i_BFu8ll_L()
{
  {
    init_simple_test("BFu8i_BFu8ll_L");
    static STRUCT_IF_C BFu8i_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_L, BFu8i_BFu8ll_L)
//============================================================================


struct  BFu8i_BFu8ll_S  {
  unsigned int v1:8;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 BFu8i_BFu8ll_S) C1{ Fi:8 FL:8 Fs}



static void Test_BFu8i_BFu8ll_S()
{
  {
    init_simple_test("BFu8i_BFu8ll_S");
    static STRUCT_IF_C BFu8i_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_S");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_S, BFu8i_BFu8ll_S)
//============================================================================


struct  BFu8i_BFu8ll_Uc  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu8ll_Uc) C1{ Fi:8 FL:8 Fc}



static void Test_BFu8i_BFu8ll_Uc()
{
  {
    init_simple_test("BFu8i_BFu8ll_Uc");
    static STRUCT_IF_C BFu8i_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Uc");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_Uc, BFu8i_BFu8ll_Uc)
//============================================================================


struct  BFu8i_BFu8ll_Ui  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu8ll_Ui) C1{ Fi:8 FL:8 Fi}



static void Test_BFu8i_BFu8ll_Ui()
{
  {
    init_simple_test("BFu8i_BFu8ll_Ui");
    static STRUCT_IF_C BFu8i_BFu8ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_Ui, BFu8i_BFu8ll_Ui)
//============================================================================


struct  BFu8i_BFu8ll_Ul  {
  unsigned int v1:8;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu8ll_Ul) C1{ Fi:8 FL:8 FL}



static void Test_BFu8i_BFu8ll_Ul()
{
  {
    init_simple_test("BFu8i_BFu8ll_Ul");
    static STRUCT_IF_C BFu8i_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_Ul, BFu8i_BFu8ll_Ul)
//============================================================================


struct  BFu8i_BFu8ll_Us  {
  unsigned int v1:8;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu8ll_Us) C1{ Fi:8 FL:8 Fs}



static void Test_BFu8i_BFu8ll_Us()
{
  {
    init_simple_test("BFu8i_BFu8ll_Us");
    static STRUCT_IF_C BFu8i_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Us");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_Us, BFu8i_BFu8ll_Us)
//============================================================================


struct  BFu8i_BFu8ll_Vp  {
  unsigned int v1:8;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 BFu8i_BFu8ll_Vp) C1{ Fi:8 FL:8 Fp}



static void Test_BFu8i_BFu8ll_Vp()
{
  {
    init_simple_test("BFu8i_BFu8ll_Vp");
    static STRUCT_IF_C BFu8i_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_Vp, BFu8i_BFu8ll_Vp)
//============================================================================


struct  BFu8i_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu8i_BFu8s) C1{ Fi:8 Fs:8}



static void Test_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s, BFu8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c) C1{ Fi:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c, BFu8i_BFu8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8c_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c_BFs8c) C1{ Fi:8 Fs:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8c_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c_BFs8c, BFu8i_BFu8s_BFs8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8c_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c_BFs8i) C1{ Fi:8 Fs:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c_BFs8i, BFu8i_BFu8s_BFs8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8c_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c_BFs8ll) C1{ Fi:8 Fs:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c_BFs8ll, BFu8i_BFu8s_BFs8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8c_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c_BFs8s) C1{ Fi:8 Fs:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8c_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c_BFs8s, BFu8i_BFu8s_BFs8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8c_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c_BFu8c) C1{ Fi:8 Fs:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c_BFu8c, BFu8i_BFu8s_BFs8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8c_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c_BFu8i) C1{ Fi:8 Fs:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c_BFu8i, BFu8i_BFu8s_BFs8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8c_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c_BFu8ll) C1{ Fi:8 Fs:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c_BFu8ll, BFu8i_BFu8s_BFs8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8c_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8c_BFu8s) C1{ Fi:8 Fs:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8c_BFu8s, BFu8i_BFu8s_BFs8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i) C1{ Fi:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i, BFu8i_BFu8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8i_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i_BFs8c) C1{ Fi:8 Fs:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i_BFs8c, BFu8i_BFu8s_BFs8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8i_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i_BFs8i) C1{ Fi:8 Fs:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i_BFs8i, BFu8i_BFu8s_BFs8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8i_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i_BFs8ll) C1{ Fi:8 Fs:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i_BFs8ll, BFu8i_BFu8s_BFs8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8i_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i_BFs8s) C1{ Fi:8 Fs:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i_BFs8s, BFu8i_BFu8s_BFs8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8i_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i_BFu8c) C1{ Fi:8 Fs:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i_BFu8c, BFu8i_BFu8s_BFs8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8i_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i_BFu8i) C1{ Fi:8 Fs:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i_BFu8i, BFu8i_BFu8s_BFs8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8i_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i_BFu8ll) C1{ Fi:8 Fs:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i_BFu8ll, BFu8i_BFu8s_BFs8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8i_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8i_BFu8s) C1{ Fi:8 Fs:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8i_BFu8s, BFu8i_BFu8s_BFs8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll) C1{ Fi:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll, BFu8i_BFu8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll_BFs8c) C1{ Fi:8 Fs:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll_BFs8c, BFu8i_BFu8s_BFs8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll_BFs8i) C1{ Fi:8 Fs:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll_BFs8i, BFu8i_BFu8s_BFs8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll_BFs8ll) C1{ Fi:8 Fs:8 FL:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll_BFs8ll, BFu8i_BFu8s_BFs8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll_BFs8s) C1{ Fi:8 Fs:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll_BFs8s, BFu8i_BFu8s_BFs8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll_BFu8c) C1{ Fi:8 Fs:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll_BFu8c, BFu8i_BFu8s_BFs8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll_BFu8i) C1{ Fi:8 Fs:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll_BFu8i, BFu8i_BFu8s_BFs8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll_BFu8ll) C1{ Fi:8 Fs:8 FL:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll_BFu8ll, BFu8i_BFu8s_BFs8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8ll_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8ll_BFu8s) C1{ Fi:8 Fs:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8ll_BFu8s, BFu8i_BFu8s_BFs8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s) C1{ Fi:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s, BFu8i_BFu8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8s_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s_BFs8c) C1{ Fi:8 Fs:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8s_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s_BFs8c, BFu8i_BFu8s_BFs8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8s_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s_BFs8i) C1{ Fi:8 Fs:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s_BFs8i, BFu8i_BFu8s_BFs8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8s_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s_BFs8ll) C1{ Fi:8 Fs:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s_BFs8ll, BFu8i_BFu8s_BFs8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8s_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s_BFs8s) C1{ Fi:8 Fs:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8s_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s_BFs8s, BFu8i_BFu8s_BFs8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFs8s_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s_BFu8c) C1{ Fi:8 Fs:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8s_BFs8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s_BFu8c, BFu8i_BFu8s_BFs8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFs8s_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s_BFu8i) C1{ Fi:8 Fs:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8s_BFs8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s_BFu8i, BFu8i_BFu8s_BFs8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFs8s_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s_BFu8ll) C1{ Fi:8 Fs:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8s_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFs8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s_BFu8ll, BFu8i_BFu8s_BFs8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFs8s_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  signed short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFs8s_BFu8s) C1{ Fi:8 Fs:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8s_BFs8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFs8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFs8s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFs8s_BFu8s, BFu8i_BFu8s_BFs8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFu15i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu8s_BFu15i) C1{ Fi:8 Fs:8 Fi:15}



static void Test_BFu8i_BFu8s_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu15i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu15i, BFu8i_BFu8s_BFu15i)
//============================================================================


struct  BFu8i_BFu8s_BFu15ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu8s_BFu15ll) C1{ Fi:8 Fs:8 FL:15}



static void Test_BFu8i_BFu8s_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu15ll, BFu8i_BFu8s_BFu15ll)
//============================================================================


struct  BFu8i_BFu8s_BFu15s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu8s_BFu15s) C1{ Fi:8 Fs:8 Fs:15}



static void Test_BFu8i_BFu8s_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu15s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu15s, BFu8i_BFu8s_BFu15s)
//============================================================================


struct  BFu8i_BFu8s_BFu16i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu8s_BFu16i) C1{ Fi:8 Fs:8 Fi:16}



static void Test_BFu8i_BFu8s_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu16i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu16i, BFu8i_BFu8s_BFu16i)
//============================================================================


struct  BFu8i_BFu8s_BFu16ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu8s_BFu16ll) C1{ Fi:8 Fs:8 FL:16}



static void Test_BFu8i_BFu8s_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu16ll, BFu8i_BFu8s_BFu16ll)
//============================================================================


struct  BFu8i_BFu8s_BFu16s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu8s_BFu16s) C1{ Fi:8 Fs:8 Fs:16}



static void Test_BFu8i_BFu8s_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu16s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu16s, BFu8i_BFu8s_BFu16s)
//============================================================================


struct  BFu8i_BFu8s_BFu17i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu8s_BFu17i) C1{ Fi:8 Fs:8 Fi:17}



static void Test_BFu8i_BFu8s_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu17i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu17i, BFu8i_BFu8s_BFu17i)
//============================================================================


struct  BFu8i_BFu8s_BFu17ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu8s_BFu17ll) C1{ Fi:8 Fs:8 FL:17}



static void Test_BFu8i_BFu8s_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu17ll, BFu8i_BFu8s_BFu17ll)
//============================================================================


struct  BFu8i_BFu8s_BFu1c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu8s_BFu1c) C1{ Fi:8 Fs:8 Fc:1}



static void Test_BFu8i_BFu8s_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu1c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu1c, BFu8i_BFu8s_BFu1c)
//============================================================================


struct  BFu8i_BFu8s_BFu1i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu8s_BFu1i) C1{ Fi:8 Fs:8 Fi:1}



static void Test_BFu8i_BFu8s_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu1i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu1i, BFu8i_BFu8s_BFu1i)
//============================================================================


struct  BFu8i_BFu8s_BFu1ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu8s_BFu1ll) C1{ Fi:8 Fs:8 FL:1}



static void Test_BFu8i_BFu8s_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu1ll, BFu8i_BFu8s_BFu1ll)
//============================================================================


struct  BFu8i_BFu8s_BFu1s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu8s_BFu1s) C1{ Fi:8 Fs:8 Fs:1}



static void Test_BFu8i_BFu8s_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu1s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu1s, BFu8i_BFu8s_BFu1s)
//============================================================================


struct  BFu8i_BFu8s_BFu31i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu8s_BFu31i) C1{ Fi:8 Fs:8 Fi:31}



static void Test_BFu8i_BFu8s_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu31i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu31i, BFu8i_BFu8s_BFu31i)
//============================================================================


struct  BFu8i_BFu8s_BFu31ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu8s_BFu31ll) C1{ Fi:8 Fs:8 FL:31}



static void Test_BFu8i_BFu8s_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu31ll, BFu8i_BFu8s_BFu31ll)
//============================================================================


struct  BFu8i_BFu8s_BFu32i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu8s_BFu32i) C1{ Fi:8 Fs:8 Fi:32}



static void Test_BFu8i_BFu8s_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu32i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu32i, BFu8i_BFu8s_BFu32i)
//============================================================================


struct  BFu8i_BFu8s_BFu32ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu8s_BFu32ll) C1{ Fi:8 Fs:8 FL:32}



static void Test_BFu8i_BFu8s_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu32ll, BFu8i_BFu8s_BFu32ll)
//============================================================================


struct  BFu8i_BFu8s_BFu33  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu8s_BFu33) C1{ Fi:8 Fs:8 FL:33}



static void Test_BFu8i_BFu8s_BFu33()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu33");
    static STRUCT_IF_C BFu8i_BFu8s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8i_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu33, BFu8i_BFu8s_BFu33)
//============================================================================


struct  BFu8i_BFu8s_BFu7c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu8s_BFu7c) C1{ Fi:8 Fs:8 Fc:7}



static void Test_BFu8i_BFu8s_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu7c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu7c, BFu8i_BFu8s_BFu7c)
//============================================================================


struct  BFu8i_BFu8s_BFu7i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu8s_BFu7i) C1{ Fi:8 Fs:8 Fi:7}



static void Test_BFu8i_BFu8s_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu7i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu7i, BFu8i_BFu8s_BFu7i)
//============================================================================


struct  BFu8i_BFu8s_BFu7ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu8s_BFu7ll) C1{ Fi:8 Fs:8 FL:7}



static void Test_BFu8i_BFu8s_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu7ll, BFu8i_BFu8s_BFu7ll)
//============================================================================


struct  BFu8i_BFu8s_BFu7s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu8s_BFu7s) C1{ Fi:8 Fs:8 Fs:7}



static void Test_BFu8i_BFu8s_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu7s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu7s, BFu8i_BFu8s_BFu7s)
//============================================================================


struct  BFu8i_BFu8s_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c) C1{ Fi:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c, BFu8i_BFu8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8c_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c_BFs8c) C1{ Fi:8 Fs:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8c_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8c_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c_BFs8c, BFu8i_BFu8s_BFu8c_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8c_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c_BFs8i) C1{ Fi:8 Fs:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8c_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c_BFs8i, BFu8i_BFu8s_BFu8c_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8c_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c_BFs8ll) C1{ Fi:8 Fs:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c_BFs8ll, BFu8i_BFu8s_BFu8c_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8c_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c_BFs8s) C1{ Fi:8 Fs:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8c_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8c_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c_BFs8s, BFu8i_BFu8s_BFu8c_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFu8c_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c_BFu8c) C1{ Fi:8 Fs:8 Fc:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c_BFu8c, BFu8i_BFu8s_BFu8c_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8c_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c_BFu8i) C1{ Fi:8 Fs:8 Fc:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c_BFu8i, BFu8i_BFu8s_BFu8c_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8c_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c_BFu8ll) C1{ Fi:8 Fs:8 Fc:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c_BFu8ll, BFu8i_BFu8s_BFu8c_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8c_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8c_BFu8s) C1{ Fi:8 Fs:8 Fc:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8c_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8c_BFu8s, BFu8i_BFu8s_BFu8c_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i) C1{ Fi:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i, BFu8i_BFu8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8i_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i_BFs8c) C1{ Fi:8 Fs:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8i_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i_BFs8c, BFu8i_BFu8s_BFu8i_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8i_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i_BFs8i) C1{ Fi:8 Fs:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8i_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i_BFs8i, BFu8i_BFu8s_BFu8i_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8i_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i_BFs8ll) C1{ Fi:8 Fs:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i_BFs8ll, BFu8i_BFu8s_BFu8i_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8i_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i_BFs8s) C1{ Fi:8 Fs:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8i_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i_BFs8s, BFu8i_BFu8s_BFu8i_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFu8i_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i_BFu8c) C1{ Fi:8 Fs:8 Fi:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i_BFu8c, BFu8i_BFu8s_BFu8i_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8i_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i_BFu8i) C1{ Fi:8 Fs:8 Fi:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i_BFu8i, BFu8i_BFu8s_BFu8i_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8i_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i_BFu8ll) C1{ Fi:8 Fs:8 Fi:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i_BFu8ll, BFu8i_BFu8s_BFu8i_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8i_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8i_BFu8s) C1{ Fi:8 Fs:8 Fi:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8i_BFu8s, BFu8i_BFu8s_BFu8i_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll) C1{ Fi:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll, BFu8i_BFu8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll_BFs8c) C1{ Fi:8 Fs:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll_BFs8c, BFu8i_BFu8s_BFu8ll_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll_BFs8i) C1{ Fi:8 Fs:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll_BFs8i, BFu8i_BFu8s_BFu8ll_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll_BFs8ll) C1{ Fi:8 Fs:8 FL:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll_BFs8ll, BFu8i_BFu8s_BFu8ll_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll_BFs8s) C1{ Fi:8 Fs:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll_BFs8s, BFu8i_BFu8s_BFu8ll_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll_BFu8c) C1{ Fi:8 Fs:8 FL:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll_BFu8c, BFu8i_BFu8s_BFu8ll_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll_BFu8i) C1{ Fi:8 Fs:8 FL:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll_BFu8i, BFu8i_BFu8s_BFu8ll_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll_BFu8ll) C1{ Fi:8 Fs:8 FL:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll_BFu8ll, BFu8i_BFu8s_BFu8ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8ll_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8ll_BFu8s) C1{ Fi:8 Fs:8 FL:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8ll_BFu8s, BFu8i_BFu8s_BFu8ll_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s) C1{ Fi:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s, BFu8i_BFu8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFu8s_BFs8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  signed char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s_BFs8c) C1{ Fi:8 Fs:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8s_BFs8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s_BFs8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8s_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s_BFs8c, BFu8i_BFu8s_BFu8s_BFs8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8s_BFs8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  signed int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s_BFs8i) C1{ Fi:8 Fs:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8s_BFs8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s_BFs8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s_BFs8i, BFu8i_BFu8s_BFu8s_BFs8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8s_BFs8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s_BFs8ll) C1{ Fi:8 Fs:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s_BFs8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s_BFs8ll, BFu8i_BFu8s_BFu8s_BFs8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8s_BFs8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  signed short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s_BFs8s) C1{ Fi:8 Fs:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8s_BFs8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s_BFs8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8s_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFu8i_BFu8s_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s_BFs8s, BFu8i_BFu8s_BFu8s_BFs8s)
//============================================================================


struct  BFu8i_BFu8s_BFu8s_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s_BFu8c) C1{ Fi:8 Fs:8 Fs:8 Fc:8}



static void Test_BFu8i_BFu8s_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s_BFu8c, BFu8i_BFu8s_BFu8s_BFu8c)
//============================================================================


struct  BFu8i_BFu8s_BFu8s_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s_BFu8i) C1{ Fi:8 Fs:8 Fs:8 Fi:8}



static void Test_BFu8i_BFu8s_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s_BFu8i, BFu8i_BFu8s_BFu8s_BFu8i)
//============================================================================


struct  BFu8i_BFu8s_BFu8s_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s_BFu8ll) C1{ Fi:8 Fs:8 Fs:8 FL:8}



static void Test_BFu8i_BFu8s_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s_BFu8ll, BFu8i_BFu8s_BFu8s_BFu8ll)
//============================================================================


struct  BFu8i_BFu8s_BFu8s_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFu8i_BFu8s_BFu8s_BFu8s) C1{ Fi:8 Fs:8 Fs:8 Fs:8}



static void Test_BFu8i_BFu8s_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu8s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu8s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFu8i_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu8s_BFu8s, BFu8i_BFu8s_BFu8s_BFu8s)
//============================================================================


struct  BFu8i_BFu8s_BFu9i  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu8s_BFu9i) C1{ Fi:8 Fs:8 Fi:9}



static void Test_BFu8i_BFu8s_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu9i");
    static STRUCT_IF_C BFu8i_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu9i, BFu8i_BFu8s_BFu9i)
//============================================================================


struct  BFu8i_BFu8s_BFu9ll  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu8s_BFu9ll) C1{ Fi:8 Fs:8 FL:9}



static void Test_BFu8i_BFu8s_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu9ll, BFu8i_BFu8s_BFu9ll)
//============================================================================


struct  BFu8i_BFu8s_BFu9s  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu8s_BFu9s) C1{ Fi:8 Fs:8 Fs:9}



static void Test_BFu8i_BFu8s_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu8s_BFu9s");
    static STRUCT_IF_C BFu8i_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_BFu9s, BFu8i_BFu8s_BFu9s)
//============================================================================


struct  BFu8i_BFu8s_C  {
  unsigned int v1:8;
  unsigned short v2:8;
  char v3;
};
//SIG(1 BFu8i_BFu8s_C) C1{ Fi:8 Fs:8 Fc}



static void Test_BFu8i_BFu8s_C()
{
  {
    init_simple_test("BFu8i_BFu8s_C");
    static STRUCT_IF_C BFu8i_BFu8s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_C");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_C, BFu8i_BFu8s_C)
//============================================================================


struct  BFu8i_BFu8s_D  {
  unsigned int v1:8;
  unsigned short v2:8;
  double v3;
};
//SIG(1 BFu8i_BFu8s_D) C1{ Fi:8 Fs:8 FL}



static void Test_BFu8i_BFu8s_D()
{
  {
    init_simple_test("BFu8i_BFu8s_D");
    static STRUCT_IF_C BFu8i_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_D, BFu8i_BFu8s_D)
//============================================================================


struct  BFu8i_BFu8s_F  {
  unsigned int v1:8;
  unsigned short v2:8;
  float v3;
};
//SIG(1 BFu8i_BFu8s_F) C1{ Fi:8 Fs:8 Fi}



static void Test_BFu8i_BFu8s_F()
{
  {
    init_simple_test("BFu8i_BFu8s_F");
    static STRUCT_IF_C BFu8i_BFu8s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_F, BFu8i_BFu8s_F)
//============================================================================


struct  BFu8i_BFu8s_I  {
  unsigned int v1:8;
  unsigned short v2:8;
  int v3;
};
//SIG(1 BFu8i_BFu8s_I) C1{ Fi:8 Fs:8 Fi}



static void Test_BFu8i_BFu8s_I()
{
  {
    init_simple_test("BFu8i_BFu8s_I");
    static STRUCT_IF_C BFu8i_BFu8s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_I, BFu8i_BFu8s_I)
//============================================================================


struct  BFu8i_BFu8s_Ip  {
  unsigned int v1:8;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 BFu8i_BFu8s_Ip) C1{ Fi:8 Fs:8 Fp}



static void Test_BFu8i_BFu8s_Ip()
{
  {
    init_simple_test("BFu8i_BFu8s_Ip");
    static STRUCT_IF_C BFu8i_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_Ip, BFu8i_BFu8s_Ip)
//============================================================================


struct  BFu8i_BFu8s_L  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu8s_L) C1{ Fi:8 Fs:8 FL}



static void Test_BFu8i_BFu8s_L()
{
  {
    init_simple_test("BFu8i_BFu8s_L");
    static STRUCT_IF_C BFu8i_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_L, BFu8i_BFu8s_L)
//============================================================================


struct  BFu8i_BFu8s_S  {
  unsigned int v1:8;
  unsigned short v2:8;
  short v3;
};
//SIG(1 BFu8i_BFu8s_S) C1{ Fi:8 Fs:8 Fs}



static void Test_BFu8i_BFu8s_S()
{
  {
    init_simple_test("BFu8i_BFu8s_S");
    static STRUCT_IF_C BFu8i_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_S");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_S, BFu8i_BFu8s_S)
//============================================================================


struct  BFu8i_BFu8s_Uc  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu8s_Uc) C1{ Fi:8 Fs:8 Fc}



static void Test_BFu8i_BFu8s_Uc()
{
  {
    init_simple_test("BFu8i_BFu8s_Uc");
    static STRUCT_IF_C BFu8i_BFu8s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Uc");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_Uc, BFu8i_BFu8s_Uc)
//============================================================================


struct  BFu8i_BFu8s_Ui  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu8s_Ui) C1{ Fi:8 Fs:8 Fi}



static void Test_BFu8i_BFu8s_Ui()
{
  {
    init_simple_test("BFu8i_BFu8s_Ui");
    static STRUCT_IF_C BFu8i_BFu8s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu8s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_Ui, BFu8i_BFu8s_Ui)
//============================================================================


struct  BFu8i_BFu8s_Ul  {
  unsigned int v1:8;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu8s_Ul) C1{ Fi:8 Fs:8 FL}



static void Test_BFu8i_BFu8s_Ul()
{
  {
    init_simple_test("BFu8i_BFu8s_Ul");
    static STRUCT_IF_C BFu8i_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_Ul, BFu8i_BFu8s_Ul)
//============================================================================


struct  BFu8i_BFu8s_Us  {
  unsigned int v1:8;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu8s_Us) C1{ Fi:8 Fs:8 Fs}



static void Test_BFu8i_BFu8s_Us()
{
  {
    init_simple_test("BFu8i_BFu8s_Us");
    static STRUCT_IF_C BFu8i_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Us");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_Us, BFu8i_BFu8s_Us)
//============================================================================


struct  BFu8i_BFu8s_Vp  {
  unsigned int v1:8;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 BFu8i_BFu8s_Vp) C1{ Fi:8 Fs:8 Fp}



static void Test_BFu8i_BFu8s_Vp()
{
  {
    init_simple_test("BFu8i_BFu8s_Vp");
    static STRUCT_IF_C BFu8i_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_Vp, BFu8i_BFu8s_Vp)
//============================================================================


struct  BFu8i_BFu9i  {
  unsigned int v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu8i_BFu9i) C1{ Fi:8 Fi:9}



static void Test_BFu8i_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu9i");
    static STRUCT_IF_C BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i, BFu8i_BFu9i)
//============================================================================


struct  BFu8i_BFu9i_BFu15i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu9i_BFu15i) C1{ Fi:8 Fi:9 Fi:15}



static void Test_BFu8i_BFu9i_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu15i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu8i_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu8i_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu15i, BFu8i_BFu9i_BFu15i)
//============================================================================


struct  BFu8i_BFu9i_BFu15ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu9i_BFu15ll) C1{ Fi:8 Fi:9 FL:15}



static void Test_BFu8i_BFu9i_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu8i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu8i_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu15ll, BFu8i_BFu9i_BFu15ll)
//============================================================================


struct  BFu8i_BFu9i_BFu15s  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu9i_BFu15s) C1{ Fi:8 Fi:9 Fs:15}



static void Test_BFu8i_BFu9i_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu15s");
    static STRUCT_IF_C BFu8i_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu8i_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu8i_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu15s, BFu8i_BFu9i_BFu15s)
//============================================================================


struct  BFu8i_BFu9i_BFu16i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu9i_BFu16i) C1{ Fi:8 Fi:9 Fi:16}



static void Test_BFu8i_BFu9i_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu16i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu16i, BFu8i_BFu9i_BFu16i)
//============================================================================


struct  BFu8i_BFu9i_BFu16ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu9i_BFu16ll) C1{ Fi:8 Fi:9 FL:16}



static void Test_BFu8i_BFu9i_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "BFu8i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "BFu8i_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu16ll, BFu8i_BFu9i_BFu16ll)
//============================================================================


struct  BFu8i_BFu9i_BFu16s  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu9i_BFu16s) C1{ Fi:8 Fi:9 Fs:16}



static void Test_BFu8i_BFu9i_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu16s");
    static STRUCT_IF_C BFu8i_BFu9i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu16s, BFu8i_BFu9i_BFu16s)
//============================================================================


struct  BFu8i_BFu9i_BFu17i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu9i_BFu17i) C1{ Fi:8 Fi:9 Fi:17}



static void Test_BFu8i_BFu9i_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu17i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu17i, BFu8i_BFu9i_BFu17i)
//============================================================================


struct  BFu8i_BFu9i_BFu17ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu9i_BFu17ll) C1{ Fi:8 Fi:9 FL:17}



static void Test_BFu8i_BFu9i_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "BFu8i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "BFu8i_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu17ll, BFu8i_BFu9i_BFu17ll)
//============================================================================


struct  BFu8i_BFu9i_BFu1c  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu9i_BFu1c) C1{ Fi:8 Fi:9 Fc:1}



static void Test_BFu8i_BFu9i_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu1c");
    static STRUCT_IF_C BFu8i_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu8i_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu1c, BFu8i_BFu9i_BFu1c)
//============================================================================


struct  BFu8i_BFu9i_BFu1i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu9i_BFu1i) C1{ Fi:8 Fi:9 Fi:1}



static void Test_BFu8i_BFu9i_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu1i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu8i_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu1i, BFu8i_BFu9i_BFu1i)
//============================================================================


struct  BFu8i_BFu9i_BFu1ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu9i_BFu1ll) C1{ Fi:8 Fi:9 FL:1}



static void Test_BFu8i_BFu9i_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu8i_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu1ll, BFu8i_BFu9i_BFu1ll)
//============================================================================


struct  BFu8i_BFu9i_BFu1s  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu9i_BFu1s) C1{ Fi:8 Fi:9 Fs:1}



static void Test_BFu8i_BFu9i_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu1s");
    static STRUCT_IF_C BFu8i_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu8i_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu1s, BFu8i_BFu9i_BFu1s)
//============================================================================


struct  BFu8i_BFu9i_BFu31i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu9i_BFu31i) C1{ Fi:8 Fi:9 Fi:31}



static void Test_BFu8i_BFu9i_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu31i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu31i, BFu8i_BFu9i_BFu31i)
//============================================================================


struct  BFu8i_BFu9i_BFu31ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu9i_BFu31ll) C1{ Fi:8 Fi:9 FL:31}



static void Test_BFu8i_BFu9i_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "BFu8i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "BFu8i_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu31ll, BFu8i_BFu9i_BFu31ll)
//============================================================================


struct  BFu8i_BFu9i_BFu32i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu9i_BFu32i) C1{ Fi:8 Fi:9 Fi:32}



static void Test_BFu8i_BFu9i_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu32i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu32i, BFu8i_BFu9i_BFu32i)
//============================================================================


struct  BFu8i_BFu9i_BFu32ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu9i_BFu32ll) C1{ Fi:8 Fi:9 FL:32}



static void Test_BFu8i_BFu9i_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "BFu8i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "BFu8i_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu32ll, BFu8i_BFu9i_BFu32ll)
//============================================================================


struct  BFu8i_BFu9i_BFu33  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu9i_BFu33) C1{ Fi:8 Fi:9 FL:33}



static void Test_BFu8i_BFu9i_BFu33()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu33");
    static STRUCT_IF_C BFu8i_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "BFu8i_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "BFu8i_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu33, BFu8i_BFu9i_BFu33)
//============================================================================


struct  BFu8i_BFu9i_BFu7c  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu9i_BFu7c) C1{ Fi:8 Fi:9 Fc:7}



static void Test_BFu8i_BFu9i_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu7c");
    static STRUCT_IF_C BFu8i_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu8i_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu7c, BFu8i_BFu9i_BFu7c)
//============================================================================


struct  BFu8i_BFu9i_BFu7i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu9i_BFu7i) C1{ Fi:8 Fi:9 Fi:7}



static void Test_BFu8i_BFu9i_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu7i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu8i_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu7i, BFu8i_BFu9i_BFu7i)
//============================================================================


struct  BFu8i_BFu9i_BFu7ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu9i_BFu7ll) C1{ Fi:8 Fi:9 FL:7}



static void Test_BFu8i_BFu9i_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu8i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu7ll, BFu8i_BFu9i_BFu7ll)
//============================================================================


struct  BFu8i_BFu9i_BFu7s  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu9i_BFu7s) C1{ Fi:8 Fi:9 Fs:7}



static void Test_BFu8i_BFu9i_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu7s");
    static STRUCT_IF_C BFu8i_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu8i_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu7s, BFu8i_BFu9i_BFu7s)
//============================================================================


struct  BFu8i_BFu9i_BFu8c  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu9i_BFu8c) C1{ Fi:8 Fi:9 Fc:8}



static void Test_BFu8i_BFu9i_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu8c");
    static STRUCT_IF_C BFu8i_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu8i_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu8c, BFu8i_BFu9i_BFu8c)
//============================================================================


struct  BFu8i_BFu9i_BFu8i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu9i_BFu8i) C1{ Fi:8 Fi:9 Fi:8}



static void Test_BFu8i_BFu9i_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu8i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu8i_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu8i, BFu8i_BFu9i_BFu8i)
//============================================================================


struct  BFu8i_BFu9i_BFu8ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu9i_BFu8ll) C1{ Fi:8 Fi:9 FL:8}



static void Test_BFu8i_BFu9i_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu8i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu8ll, BFu8i_BFu9i_BFu8ll)
//============================================================================


struct  BFu8i_BFu9i_BFu8s  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu9i_BFu8s) C1{ Fi:8 Fi:9 Fs:8}



static void Test_BFu8i_BFu9i_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu8s");
    static STRUCT_IF_C BFu8i_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu8i_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu8s, BFu8i_BFu9i_BFu8s)
//============================================================================


struct  BFu8i_BFu9i_BFu9i  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu9i_BFu9i) C1{ Fi:8 Fi:9 Fi:9}



static void Test_BFu8i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu9i");
    static STRUCT_IF_C BFu8i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu8i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu9i, BFu8i_BFu9i_BFu9i)
//============================================================================


struct  BFu8i_BFu9i_BFu9ll  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu9i_BFu9ll) C1{ Fi:8 Fi:9 FL:9}



static void Test_BFu8i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu8i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu9ll, BFu8i_BFu9i_BFu9ll)
//============================================================================


struct  BFu8i_BFu9i_BFu9s  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu9i_BFu9s) C1{ Fi:8 Fi:9 Fs:9}



static void Test_BFu8i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu9i_BFu9s");
    static STRUCT_IF_C BFu8i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu8i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_BFu9s, BFu8i_BFu9i_BFu9s)
//============================================================================


struct  BFu8i_BFu9i_C  {
  unsigned int v1:8;
  unsigned int v2:9;
  char v3;
};
//SIG(1 BFu8i_BFu9i_C) C1{ Fi:8 Fi:9 Fc}



static void Test_BFu8i_BFu9i_C()
{
  {
    init_simple_test("BFu8i_BFu9i_C");
    static STRUCT_IF_C BFu8i_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_C");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_C, BFu8i_BFu9i_C)
//============================================================================


struct  BFu8i_BFu9i_D  {
  unsigned int v1:8;
  unsigned int v2:9;
  double v3;
};
//SIG(1 BFu8i_BFu9i_D) C1{ Fi:8 Fi:9 FL}



static void Test_BFu8i_BFu9i_D()
{
  {
    init_simple_test("BFu8i_BFu9i_D");
    static STRUCT_IF_C BFu8i_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_D, BFu8i_BFu9i_D)
//============================================================================


struct  BFu8i_BFu9i_F  {
  unsigned int v1:8;
  unsigned int v2:9;
  float v3;
};
//SIG(1 BFu8i_BFu9i_F) C1{ Fi:8 Fi:9 Fi}



static void Test_BFu8i_BFu9i_F()
{
  {
    init_simple_test("BFu8i_BFu9i_F");
    static STRUCT_IF_C BFu8i_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_F, BFu8i_BFu9i_F)
//============================================================================


struct  BFu8i_BFu9i_I  {
  unsigned int v1:8;
  unsigned int v2:9;
  int v3;
};
//SIG(1 BFu8i_BFu9i_I) C1{ Fi:8 Fi:9 Fi}



static void Test_BFu8i_BFu9i_I()
{
  {
    init_simple_test("BFu8i_BFu9i_I");
    static STRUCT_IF_C BFu8i_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_I, BFu8i_BFu9i_I)
//============================================================================


struct  BFu8i_BFu9i_Ip  {
  unsigned int v1:8;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 BFu8i_BFu9i_Ip) C1{ Fi:8 Fi:9 Fp}



static void Test_BFu8i_BFu9i_Ip()
{
  {
    init_simple_test("BFu8i_BFu9i_Ip");
    static STRUCT_IF_C BFu8i_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_Ip, BFu8i_BFu9i_Ip)
//============================================================================


struct  BFu8i_BFu9i_L  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu9i_L) C1{ Fi:8 Fi:9 FL}



static void Test_BFu8i_BFu9i_L()
{
  {
    init_simple_test("BFu8i_BFu9i_L");
    static STRUCT_IF_C BFu8i_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_L, BFu8i_BFu9i_L)
//============================================================================


struct  BFu8i_BFu9i_S  {
  unsigned int v1:8;
  unsigned int v2:9;
  short v3;
};
//SIG(1 BFu8i_BFu9i_S) C1{ Fi:8 Fi:9 Fs}



static void Test_BFu8i_BFu9i_S()
{
  {
    init_simple_test("BFu8i_BFu9i_S");
    static STRUCT_IF_C BFu8i_BFu9i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_S");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_S, BFu8i_BFu9i_S)
//============================================================================


struct  BFu8i_BFu9i_Uc  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu9i_Uc) C1{ Fi:8 Fi:9 Fc}



static void Test_BFu8i_BFu9i_Uc()
{
  {
    init_simple_test("BFu8i_BFu9i_Uc");
    static STRUCT_IF_C BFu8i_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_Uc");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_Uc, BFu8i_BFu9i_Uc)
//============================================================================


struct  BFu8i_BFu9i_Ui  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu9i_Ui) C1{ Fi:8 Fi:9 Fi}



static void Test_BFu8i_BFu9i_Ui()
{
  {
    init_simple_test("BFu8i_BFu9i_Ui");
    static STRUCT_IF_C BFu8i_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_Ui, BFu8i_BFu9i_Ui)
//============================================================================


struct  BFu8i_BFu9i_Ul  {
  unsigned int v1:8;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu9i_Ul) C1{ Fi:8 Fi:9 FL}



static void Test_BFu8i_BFu9i_Ul()
{
  {
    init_simple_test("BFu8i_BFu9i_Ul");
    static STRUCT_IF_C BFu8i_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_Ul, BFu8i_BFu9i_Ul)
//============================================================================


struct  BFu8i_BFu9i_Us  {
  unsigned int v1:8;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu9i_Us) C1{ Fi:8 Fi:9 Fs}



static void Test_BFu8i_BFu9i_Us()
{
  {
    init_simple_test("BFu8i_BFu9i_Us");
    static STRUCT_IF_C BFu8i_BFu9i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_Us");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_Us, BFu8i_BFu9i_Us)
//============================================================================


struct  BFu8i_BFu9i_Vp  {
  unsigned int v1:8;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 BFu8i_BFu9i_Vp) C1{ Fi:8 Fi:9 Fp}



static void Test_BFu8i_BFu9i_Vp()
{
  {
    init_simple_test("BFu8i_BFu9i_Vp");
    static STRUCT_IF_C BFu8i_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_Vp, BFu8i_BFu9i_Vp)
//============================================================================


struct  BFu8i_BFu9ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu8i_BFu9ll) C1{ Fi:8 FL:9}



static void Test_BFu8i_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll, BFu8i_BFu9ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu15i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu9ll_BFu15i) C1{ Fi:8 FL:9 Fi:15}



static void Test_BFu8i_BFu9ll_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu15i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu8i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu8i_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu15i, BFu8i_BFu9ll_BFu15i)
//============================================================================


struct  BFu8i_BFu9ll_BFu15ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu9ll_BFu15ll) C1{ Fi:8 FL:9 FL:15}



static void Test_BFu8i_BFu9ll_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu8i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu8i_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu15ll, BFu8i_BFu9ll_BFu15ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu15s  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu9ll_BFu15s) C1{ Fi:8 FL:9 Fs:15}



static void Test_BFu8i_BFu9ll_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu15s");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu8i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu8i_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu15s, BFu8i_BFu9ll_BFu15s)
//============================================================================


struct  BFu8i_BFu9ll_BFu16i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu9ll_BFu16i) C1{ Fi:8 FL:9 Fi:16}



static void Test_BFu8i_BFu9ll_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu16i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu16i, BFu8i_BFu9ll_BFu16i)
//============================================================================


struct  BFu8i_BFu9ll_BFu16ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu9ll_BFu16ll) C1{ Fi:8 FL:9 FL:16}



static void Test_BFu8i_BFu9ll_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "BFu8i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "BFu8i_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu16ll, BFu8i_BFu9ll_BFu16ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu16s  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu9ll_BFu16s) C1{ Fi:8 FL:9 Fs:16}



static void Test_BFu8i_BFu9ll_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu16s");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu16s, BFu8i_BFu9ll_BFu16s)
//============================================================================


struct  BFu8i_BFu9ll_BFu17i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu9ll_BFu17i) C1{ Fi:8 FL:9 Fi:17}



static void Test_BFu8i_BFu9ll_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu17i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu17i, BFu8i_BFu9ll_BFu17i)
//============================================================================


struct  BFu8i_BFu9ll_BFu17ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu9ll_BFu17ll) C1{ Fi:8 FL:9 FL:17}



static void Test_BFu8i_BFu9ll_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "BFu8i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "BFu8i_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu17ll, BFu8i_BFu9ll_BFu17ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu1c  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu9ll_BFu1c) C1{ Fi:8 FL:9 Fc:1}



static void Test_BFu8i_BFu9ll_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu1c");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu8i_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu1c, BFu8i_BFu9ll_BFu1c)
//============================================================================


struct  BFu8i_BFu9ll_BFu1i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu9ll_BFu1i) C1{ Fi:8 FL:9 Fi:1}



static void Test_BFu8i_BFu9ll_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu1i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu8i_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu1i, BFu8i_BFu9ll_BFu1i)
//============================================================================


struct  BFu8i_BFu9ll_BFu1ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu9ll_BFu1ll) C1{ Fi:8 FL:9 FL:1}



static void Test_BFu8i_BFu9ll_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu8i_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu1ll, BFu8i_BFu9ll_BFu1ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu1s  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu9ll_BFu1s) C1{ Fi:8 FL:9 Fs:1}



static void Test_BFu8i_BFu9ll_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu1s");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu8i_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu1s, BFu8i_BFu9ll_BFu1s)
//============================================================================


struct  BFu8i_BFu9ll_BFu31i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu9ll_BFu31i) C1{ Fi:8 FL:9 Fi:31}



static void Test_BFu8i_BFu9ll_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu31i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu31i, BFu8i_BFu9ll_BFu31i)
//============================================================================


struct  BFu8i_BFu9ll_BFu31ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu9ll_BFu31ll) C1{ Fi:8 FL:9 FL:31}



static void Test_BFu8i_BFu9ll_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "BFu8i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "BFu8i_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu31ll, BFu8i_BFu9ll_BFu31ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu32i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu9ll_BFu32i) C1{ Fi:8 FL:9 Fi:32}



static void Test_BFu8i_BFu9ll_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu32i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu32i, BFu8i_BFu9ll_BFu32i)
//============================================================================


struct  BFu8i_BFu9ll_BFu32ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu9ll_BFu32ll) C1{ Fi:8 FL:9 FL:32}



static void Test_BFu8i_BFu9ll_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "BFu8i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "BFu8i_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu32ll, BFu8i_BFu9ll_BFu32ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu33  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu9ll_BFu33) C1{ Fi:8 FL:9 FL:33}



static void Test_BFu8i_BFu9ll_BFu33()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu33");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "BFu8i_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "BFu8i_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu33, BFu8i_BFu9ll_BFu33)
//============================================================================


struct  BFu8i_BFu9ll_BFu7c  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu9ll_BFu7c) C1{ Fi:8 FL:9 Fc:7}



static void Test_BFu8i_BFu9ll_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu7c");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu8i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu7c, BFu8i_BFu9ll_BFu7c)
//============================================================================


struct  BFu8i_BFu9ll_BFu7i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu9ll_BFu7i) C1{ Fi:8 FL:9 Fi:7}



static void Test_BFu8i_BFu9ll_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu7i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu8i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu7i, BFu8i_BFu9ll_BFu7i)
//============================================================================


struct  BFu8i_BFu9ll_BFu7ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu9ll_BFu7ll) C1{ Fi:8 FL:9 FL:7}



static void Test_BFu8i_BFu9ll_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu8i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu7ll, BFu8i_BFu9ll_BFu7ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu7s  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu9ll_BFu7s) C1{ Fi:8 FL:9 Fs:7}



static void Test_BFu8i_BFu9ll_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu7s");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu8i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu7s, BFu8i_BFu9ll_BFu7s)
//============================================================================


struct  BFu8i_BFu9ll_BFu8c  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu9ll_BFu8c) C1{ Fi:8 FL:9 Fc:8}



static void Test_BFu8i_BFu9ll_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu8c");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu8i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu8c, BFu8i_BFu9ll_BFu8c)
//============================================================================


struct  BFu8i_BFu9ll_BFu8i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu9ll_BFu8i) C1{ Fi:8 FL:9 Fi:8}



static void Test_BFu8i_BFu9ll_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu8i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu8i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu8i, BFu8i_BFu9ll_BFu8i)
//============================================================================


struct  BFu8i_BFu9ll_BFu8ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu9ll_BFu8ll) C1{ Fi:8 FL:9 FL:8}



static void Test_BFu8i_BFu9ll_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu8i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu8ll, BFu8i_BFu9ll_BFu8ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu8s  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu9ll_BFu8s) C1{ Fi:8 FL:9 Fs:8}



static void Test_BFu8i_BFu9ll_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu8s");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu8i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu8s, BFu8i_BFu9ll_BFu8s)
//============================================================================


struct  BFu8i_BFu9ll_BFu9i  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu9ll_BFu9i) C1{ Fi:8 FL:9 Fi:9}



static void Test_BFu8i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu8i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu9i, BFu8i_BFu9ll_BFu9i)
//============================================================================


struct  BFu8i_BFu9ll_BFu9ll  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu9ll_BFu9ll) C1{ Fi:8 FL:9 FL:9}



static void Test_BFu8i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu8i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu9ll, BFu8i_BFu9ll_BFu9ll)
//============================================================================


struct  BFu8i_BFu9ll_BFu9s  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu9ll_BFu9s) C1{ Fi:8 FL:9 Fs:9}



static void Test_BFu8i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFu8i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu8i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_BFu9s, BFu8i_BFu9ll_BFu9s)
//============================================================================


struct  BFu8i_BFu9ll_C  {
  unsigned int v1:8;
  __tsu64 v2:9;
  char v3;
};
//SIG(1 BFu8i_BFu9ll_C) C1{ Fi:8 FL:9 Fc}



static void Test_BFu8i_BFu9ll_C()
{
  {
    init_simple_test("BFu8i_BFu9ll_C");
    static STRUCT_IF_C BFu8i_BFu9ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_C");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_C, BFu8i_BFu9ll_C)
//============================================================================


struct  BFu8i_BFu9ll_D  {
  unsigned int v1:8;
  __tsu64 v2:9;
  double v3;
};
//SIG(1 BFu8i_BFu9ll_D) C1{ Fi:8 FL:9 FL}



static void Test_BFu8i_BFu9ll_D()
{
  {
    init_simple_test("BFu8i_BFu9ll_D");
    static STRUCT_IF_C BFu8i_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_D, BFu8i_BFu9ll_D)
//============================================================================


struct  BFu8i_BFu9ll_F  {
  unsigned int v1:8;
  __tsu64 v2:9;
  float v3;
};
//SIG(1 BFu8i_BFu9ll_F) C1{ Fi:8 FL:9 Fi}



static void Test_BFu8i_BFu9ll_F()
{
  {
    init_simple_test("BFu8i_BFu9ll_F");
    static STRUCT_IF_C BFu8i_BFu9ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_F, BFu8i_BFu9ll_F)
//============================================================================


struct  BFu8i_BFu9ll_I  {
  unsigned int v1:8;
  __tsu64 v2:9;
  int v3;
};
//SIG(1 BFu8i_BFu9ll_I) C1{ Fi:8 FL:9 Fi}



static void Test_BFu8i_BFu9ll_I()
{
  {
    init_simple_test("BFu8i_BFu9ll_I");
    static STRUCT_IF_C BFu8i_BFu9ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_I, BFu8i_BFu9ll_I)
//============================================================================


struct  BFu8i_BFu9ll_Ip  {
  unsigned int v1:8;
  __tsu64 v2:9;
  int *v3;
};
//SIG(1 BFu8i_BFu9ll_Ip) C1{ Fi:8 FL:9 Fp}



static void Test_BFu8i_BFu9ll_Ip()
{
  {
    init_simple_test("BFu8i_BFu9ll_Ip");
    static STRUCT_IF_C BFu8i_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_Ip, BFu8i_BFu9ll_Ip)
//============================================================================


struct  BFu8i_BFu9ll_L  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu9ll_L) C1{ Fi:8 FL:9 FL}



static void Test_BFu8i_BFu9ll_L()
{
  {
    init_simple_test("BFu8i_BFu9ll_L");
    static STRUCT_IF_C BFu8i_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_L, BFu8i_BFu9ll_L)
//============================================================================


struct  BFu8i_BFu9ll_S  {
  unsigned int v1:8;
  __tsu64 v2:9;
  short v3;
};
//SIG(1 BFu8i_BFu9ll_S) C1{ Fi:8 FL:9 Fs}



static void Test_BFu8i_BFu9ll_S()
{
  {
    init_simple_test("BFu8i_BFu9ll_S");
    static STRUCT_IF_C BFu8i_BFu9ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_S");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_S, BFu8i_BFu9ll_S)
//============================================================================


struct  BFu8i_BFu9ll_Uc  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu9ll_Uc) C1{ Fi:8 FL:9 Fc}



static void Test_BFu8i_BFu9ll_Uc()
{
  {
    init_simple_test("BFu8i_BFu9ll_Uc");
    static STRUCT_IF_C BFu8i_BFu9ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_Uc");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_Uc, BFu8i_BFu9ll_Uc)
//============================================================================


struct  BFu8i_BFu9ll_Ui  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu9ll_Ui) C1{ Fi:8 FL:9 Fi}



static void Test_BFu8i_BFu9ll_Ui()
{
  {
    init_simple_test("BFu8i_BFu9ll_Ui");
    static STRUCT_IF_C BFu8i_BFu9ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_Ui, BFu8i_BFu9ll_Ui)
//============================================================================


struct  BFu8i_BFu9ll_Ul  {
  unsigned int v1:8;
  __tsu64 v2:9;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu9ll_Ul) C1{ Fi:8 FL:9 FL}



static void Test_BFu8i_BFu9ll_Ul()
{
  {
    init_simple_test("BFu8i_BFu9ll_Ul");
    static STRUCT_IF_C BFu8i_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_Ul, BFu8i_BFu9ll_Ul)
//============================================================================


struct  BFu8i_BFu9ll_Us  {
  unsigned int v1:8;
  __tsu64 v2:9;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu9ll_Us) C1{ Fi:8 FL:9 Fs}



static void Test_BFu8i_BFu9ll_Us()
{
  {
    init_simple_test("BFu8i_BFu9ll_Us");
    static STRUCT_IF_C BFu8i_BFu9ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_Us");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_Us, BFu8i_BFu9ll_Us)
//============================================================================


struct  BFu8i_BFu9ll_Vp  {
  unsigned int v1:8;
  __tsu64 v2:9;
  void *v3;
};
//SIG(1 BFu8i_BFu9ll_Vp) C1{ Fi:8 FL:9 Fp}



static void Test_BFu8i_BFu9ll_Vp()
{
  {
    init_simple_test("BFu8i_BFu9ll_Vp");
    static STRUCT_IF_C BFu8i_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_Vp, BFu8i_BFu9ll_Vp)
//============================================================================


struct  BFu8i_BFu9s  {
  unsigned int v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu8i_BFu9s) C1{ Fi:8 Fs:9}



static void Test_BFu8i_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu9s");
    static STRUCT_IF_C BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s, BFu8i_BFu9s)
//============================================================================


struct  BFu8i_BFu9s_BFu15i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:15;
};
//SIG(1 BFu8i_BFu9s_BFu15i) C1{ Fi:8 Fs:9 Fi:15}



static void Test_BFu8i_BFu9s_BFu15i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu15i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu8i_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu15i, BFu8i_BFu9s_BFu15i)
//============================================================================


struct  BFu8i_BFu9s_BFu15ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_BFu9s_BFu15ll) C1{ Fi:8 Fs:9 FL:15}



static void Test_BFu8i_BFu9s_BFu15ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu15ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "BFu8i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "BFu8i_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu15ll, BFu8i_BFu9s_BFu15ll)
//============================================================================


struct  BFu8i_BFu9s_BFu15s  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned short v3:15;
};
//SIG(1 BFu8i_BFu9s_BFu15s) C1{ Fi:8 Fs:9 Fs:15}



static void Test_BFu8i_BFu9s_BFu15s()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu15s");
    static STRUCT_IF_C BFu8i_BFu9s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu8i_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu15s, BFu8i_BFu9s_BFu15s)
//============================================================================


struct  BFu8i_BFu9s_BFu16i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:16;
};
//SIG(1 BFu8i_BFu9s_BFu16i) C1{ Fi:8 Fs:9 Fi:16}



static void Test_BFu8i_BFu9s_BFu16i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu16i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu16i, BFu8i_BFu9s_BFu16i)
//============================================================================


struct  BFu8i_BFu9s_BFu16ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_BFu9s_BFu16ll) C1{ Fi:8 Fs:9 FL:16}



static void Test_BFu8i_BFu9s_BFu16ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu16ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "BFu8i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "BFu8i_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu16ll, BFu8i_BFu9s_BFu16ll)
//============================================================================


struct  BFu8i_BFu9s_BFu16s  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned short v3:16;
};
//SIG(1 BFu8i_BFu9s_BFu16s) C1{ Fi:8 Fs:9 Fs:16}



static void Test_BFu8i_BFu9s_BFu16s()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu16s");
    static STRUCT_IF_C BFu8i_BFu9s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu16s, BFu8i_BFu9s_BFu16s)
//============================================================================


struct  BFu8i_BFu9s_BFu17i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:17;
};
//SIG(1 BFu8i_BFu9s_BFu17i) C1{ Fi:8 Fs:9 Fi:17}



static void Test_BFu8i_BFu9s_BFu17i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu17i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu17i, BFu8i_BFu9s_BFu17i)
//============================================================================


struct  BFu8i_BFu9s_BFu17ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_BFu9s_BFu17ll) C1{ Fi:8 Fs:9 FL:17}



static void Test_BFu8i_BFu9s_BFu17ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu17ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "BFu8i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "BFu8i_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu17ll, BFu8i_BFu9s_BFu17ll)
//============================================================================


struct  BFu8i_BFu9s_BFu1c  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned char v3:1;
};
//SIG(1 BFu8i_BFu9s_BFu1c) C1{ Fi:8 Fs:9 Fc:1}



static void Test_BFu8i_BFu9s_BFu1c()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu1c");
    static STRUCT_IF_C BFu8i_BFu9s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "BFu8i_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu1c, BFu8i_BFu9s_BFu1c)
//============================================================================


struct  BFu8i_BFu9s_BFu1i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:1;
};
//SIG(1 BFu8i_BFu9s_BFu1i) C1{ Fi:8 Fs:9 Fi:1}



static void Test_BFu8i_BFu9s_BFu1i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu1i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "BFu8i_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu1i, BFu8i_BFu9s_BFu1i)
//============================================================================


struct  BFu8i_BFu9s_BFu1ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_BFu9s_BFu1ll) C1{ Fi:8 Fs:9 FL:1}



static void Test_BFu8i_BFu9s_BFu1ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu1ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "BFu8i_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu1ll, BFu8i_BFu9s_BFu1ll)
//============================================================================


struct  BFu8i_BFu9s_BFu1s  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned short v3:1;
};
//SIG(1 BFu8i_BFu9s_BFu1s) C1{ Fi:8 Fs:9 Fs:1}



static void Test_BFu8i_BFu9s_BFu1s()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu1s");
    static STRUCT_IF_C BFu8i_BFu9s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "BFu8i_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu1s, BFu8i_BFu9s_BFu1s)
//============================================================================


struct  BFu8i_BFu9s_BFu31i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:31;
};
//SIG(1 BFu8i_BFu9s_BFu31i) C1{ Fi:8 Fs:9 Fi:31}



static void Test_BFu8i_BFu9s_BFu31i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu31i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu31i, BFu8i_BFu9s_BFu31i)
//============================================================================


struct  BFu8i_BFu9s_BFu31ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_BFu9s_BFu31ll) C1{ Fi:8 Fs:9 FL:31}



static void Test_BFu8i_BFu9s_BFu31ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu31ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "BFu8i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "BFu8i_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu31ll, BFu8i_BFu9s_BFu31ll)
//============================================================================


struct  BFu8i_BFu9s_BFu32i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:32;
};
//SIG(1 BFu8i_BFu9s_BFu32i) C1{ Fi:8 Fs:9 Fi:32}



static void Test_BFu8i_BFu9s_BFu32i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu32i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu32i, BFu8i_BFu9s_BFu32i)
//============================================================================


struct  BFu8i_BFu9s_BFu32ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_BFu9s_BFu32ll) C1{ Fi:8 Fs:9 FL:32}



static void Test_BFu8i_BFu9s_BFu32ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu32ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "BFu8i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "BFu8i_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu32ll, BFu8i_BFu9s_BFu32ll)
//============================================================================


struct  BFu8i_BFu9s_BFu33  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_BFu9s_BFu33) C1{ Fi:8 Fs:9 FL:33}



static void Test_BFu8i_BFu9s_BFu33()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu33");
    static STRUCT_IF_C BFu8i_BFu9s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "BFu8i_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "BFu8i_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu33, BFu8i_BFu9s_BFu33)
//============================================================================


struct  BFu8i_BFu9s_BFu7c  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned char v3:7;
};
//SIG(1 BFu8i_BFu9s_BFu7c) C1{ Fi:8 Fs:9 Fc:7}



static void Test_BFu8i_BFu9s_BFu7c()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu7c");
    static STRUCT_IF_C BFu8i_BFu9s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "BFu8i_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu7c, BFu8i_BFu9s_BFu7c)
//============================================================================


struct  BFu8i_BFu9s_BFu7i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:7;
};
//SIG(1 BFu8i_BFu9s_BFu7i) C1{ Fi:8 Fs:9 Fi:7}



static void Test_BFu8i_BFu9s_BFu7i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu7i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "BFu8i_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu7i, BFu8i_BFu9s_BFu7i)
//============================================================================


struct  BFu8i_BFu9s_BFu7ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_BFu9s_BFu7ll) C1{ Fi:8 Fs:9 FL:7}



static void Test_BFu8i_BFu9s_BFu7ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu7ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "BFu8i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu7ll, BFu8i_BFu9s_BFu7ll)
//============================================================================


struct  BFu8i_BFu9s_BFu7s  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned short v3:7;
};
//SIG(1 BFu8i_BFu9s_BFu7s) C1{ Fi:8 Fs:9 Fs:7}



static void Test_BFu8i_BFu9s_BFu7s()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu7s");
    static STRUCT_IF_C BFu8i_BFu9s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "BFu8i_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "BFu8i_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu7s, BFu8i_BFu9s_BFu7s)
//============================================================================


struct  BFu8i_BFu9s_BFu8c  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned char v3:8;
};
//SIG(1 BFu8i_BFu9s_BFu8c) C1{ Fi:8 Fs:9 Fc:8}



static void Test_BFu8i_BFu9s_BFu8c()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu8c");
    static STRUCT_IF_C BFu8i_BFu9s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu8i_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu8c, BFu8i_BFu9s_BFu8c)
//============================================================================


struct  BFu8i_BFu9s_BFu8i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:8;
};
//SIG(1 BFu8i_BFu9s_BFu8i) C1{ Fi:8 Fs:9 Fi:8}



static void Test_BFu8i_BFu9s_BFu8i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu8i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu8i_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu8i, BFu8i_BFu9s_BFu8i)
//============================================================================


struct  BFu8i_BFu9s_BFu8ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_BFu9s_BFu8ll) C1{ Fi:8 Fs:9 FL:8}



static void Test_BFu8i_BFu9s_BFu8ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu8ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "BFu8i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu8ll, BFu8i_BFu9s_BFu8ll)
//============================================================================


struct  BFu8i_BFu9s_BFu8s  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned short v3:8;
};
//SIG(1 BFu8i_BFu9s_BFu8s) C1{ Fi:8 Fs:9 Fs:8}



static void Test_BFu8i_BFu9s_BFu8s()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu8s");
    static STRUCT_IF_C BFu8i_BFu9s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu8i_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu8s, BFu8i_BFu9s_BFu8s)
//============================================================================


struct  BFu8i_BFu9s_BFu9i  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 BFu8i_BFu9s_BFu9i) C1{ Fi:8 Fs:9 Fi:9}



static void Test_BFu8i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu9i");
    static STRUCT_IF_C BFu8i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu8i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu9i, BFu8i_BFu9s_BFu9i)
//============================================================================


struct  BFu8i_BFu9s_BFu9ll  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_BFu9s_BFu9ll) C1{ Fi:8 Fs:9 FL:9}



static void Test_BFu8i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFu8i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFu8i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu9ll, BFu8i_BFu9s_BFu9ll)
//============================================================================


struct  BFu8i_BFu9s_BFu9s  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 BFu8i_BFu9s_BFu9s) C1{ Fi:8 Fs:9 Fs:9}



static void Test_BFu8i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFu8i_BFu9s_BFu9s");
    static STRUCT_IF_C BFu8i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu8i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_BFu9s, BFu8i_BFu9s_BFu9s)
//============================================================================


struct  BFu8i_BFu9s_C  {
  unsigned int v1:8;
  unsigned short v2:9;
  char v3;
};
//SIG(1 BFu8i_BFu9s_C) C1{ Fi:8 Fs:9 Fc}



static void Test_BFu8i_BFu9s_C()
{
  {
    init_simple_test("BFu8i_BFu9s_C");
    static STRUCT_IF_C BFu8i_BFu9s_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_C");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_C");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_C");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_C, BFu8i_BFu9s_C)
//============================================================================


struct  BFu8i_BFu9s_D  {
  unsigned int v1:8;
  unsigned short v2:9;
  double v3;
};
//SIG(1 BFu8i_BFu9s_D) C1{ Fi:8 Fs:9 FL}



static void Test_BFu8i_BFu9s_D()
{
  {
    init_simple_test("BFu8i_BFu9s_D");
    static STRUCT_IF_C BFu8i_BFu9s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_D");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_D");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_D, BFu8i_BFu9s_D)
//============================================================================


struct  BFu8i_BFu9s_F  {
  unsigned int v1:8;
  unsigned short v2:9;
  float v3;
};
//SIG(1 BFu8i_BFu9s_F) C1{ Fi:8 Fs:9 Fi}



static void Test_BFu8i_BFu9s_F()
{
  {
    init_simple_test("BFu8i_BFu9s_F");
    static STRUCT_IF_C BFu8i_BFu9s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_F");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_F");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_F");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_F, BFu8i_BFu9s_F)
//============================================================================


struct  BFu8i_BFu9s_I  {
  unsigned int v1:8;
  unsigned short v2:9;
  int v3;
};
//SIG(1 BFu8i_BFu9s_I) C1{ Fi:8 Fs:9 Fi}



static void Test_BFu8i_BFu9s_I()
{
  {
    init_simple_test("BFu8i_BFu9s_I");
    static STRUCT_IF_C BFu8i_BFu9s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_I");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_I");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_I");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_I, BFu8i_BFu9s_I)
//============================================================================


struct  BFu8i_BFu9s_Ip  {
  unsigned int v1:8;
  unsigned short v2:9;
  int *v3;
};
//SIG(1 BFu8i_BFu9s_Ip) C1{ Fi:8 Fs:9 Fp}



static void Test_BFu8i_BFu9s_Ip()
{
  {
    init_simple_test("BFu8i_BFu9s_Ip");
    static STRUCT_IF_C BFu8i_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu9s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_Ip, BFu8i_BFu9s_Ip)
//============================================================================


struct  BFu8i_BFu9s_L  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsi64 v3;
};
//SIG(1 BFu8i_BFu9s_L) C1{ Fi:8 Fs:9 FL}



static void Test_BFu8i_BFu9s_L()
{
  {
    init_simple_test("BFu8i_BFu9s_L");
    static STRUCT_IF_C BFu8i_BFu9s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_L");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_L");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_L, BFu8i_BFu9s_L)
//============================================================================


struct  BFu8i_BFu9s_S  {
  unsigned int v1:8;
  unsigned short v2:9;
  short v3;
};
//SIG(1 BFu8i_BFu9s_S) C1{ Fi:8 Fs:9 Fs}



static void Test_BFu8i_BFu9s_S()
{
  {
    init_simple_test("BFu8i_BFu9s_S");
    static STRUCT_IF_C BFu8i_BFu9s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_S");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_S");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_S");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_S, BFu8i_BFu9s_S)
//============================================================================


struct  BFu8i_BFu9s_Uc  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned char v3;
};
//SIG(1 BFu8i_BFu9s_Uc) C1{ Fi:8 Fs:9 Fc}



static void Test_BFu8i_BFu9s_Uc()
{
  {
    init_simple_test("BFu8i_BFu9s_Uc");
    static STRUCT_IF_C BFu8i_BFu9s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_Uc");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_Uc, BFu8i_BFu9s_Uc)
//============================================================================


struct  BFu8i_BFu9s_Ui  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned int v3;
};
//SIG(1 BFu8i_BFu9s_Ui) C1{ Fi:8 Fs:9 Fi}



static void Test_BFu8i_BFu9s_Ui()
{
  {
    init_simple_test("BFu8i_BFu9s_Ui");
    static STRUCT_IF_C BFu8i_BFu9s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_Ui");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_Ui, BFu8i_BFu9s_Ui)
//============================================================================


struct  BFu8i_BFu9s_Ul  {
  unsigned int v1:8;
  unsigned short v2:9;
  __tsu64 v3;
};
//SIG(1 BFu8i_BFu9s_Ul) C1{ Fi:8 Fs:9 FL}



static void Test_BFu8i_BFu9s_Ul()
{
  {
    init_simple_test("BFu8i_BFu9s_Ul");
    static STRUCT_IF_C BFu8i_BFu9s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_BFu9s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_Ul, BFu8i_BFu9s_Ul)
//============================================================================


struct  BFu8i_BFu9s_Us  {
  unsigned int v1:8;
  unsigned short v2:9;
  unsigned short v3;
};
//SIG(1 BFu8i_BFu9s_Us) C1{ Fi:8 Fs:9 Fs}



static void Test_BFu8i_BFu9s_Us()
{
  {
    init_simple_test("BFu8i_BFu9s_Us");
    static STRUCT_IF_C BFu8i_BFu9s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_Us");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_Us, BFu8i_BFu9s_Us)
//============================================================================


struct  BFu8i_BFu9s_Vp  {
  unsigned int v1:8;
  unsigned short v2:9;
  void *v3;
};
//SIG(1 BFu8i_BFu9s_Vp) C1{ Fi:8 Fs:9 Fp}



static void Test_BFu8i_BFu9s_Vp()
{
  {
    init_simple_test("BFu8i_BFu9s_Vp");
    static STRUCT_IF_C BFu8i_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_BFu9s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_Vp, BFu8i_BFu9s_Vp)
//============================================================================


struct  BFu8i_C  {
  unsigned int v1:8;
  char v2;
};
//SIG(1 BFu8i_C) C1{ Fi:8 Fc}



static void Test_BFu8i_C()
{
  {
    init_simple_test("BFu8i_C");
    static STRUCT_IF_C BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C");
    check_field_offset(lv, v2, 1, "BFu8i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C, BFu8i_C)
//============================================================================


struct  BFu8i_C_BFu15i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:15;
};
//SIG(1 BFu8i_C_BFu15i) C1{ Fi:8 Fc Fi:15}



static void Test_BFu8i_C_BFu15i()
{
  {
    init_simple_test("BFu8i_C_BFu15i");
    static STRUCT_IF_C BFu8i_C_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_C_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu15i, BFu8i_C_BFu15i)
//============================================================================


struct  BFu8i_C_BFu15ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_C_BFu15ll) C1{ Fi:8 Fc FL:15}



static void Test_BFu8i_C_BFu15ll()
{
  {
    init_simple_test("BFu8i_C_BFu15ll");
    static STRUCT_IF_C BFu8i_C_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_C_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_C_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu15ll, BFu8i_C_BFu15ll)
//============================================================================


struct  BFu8i_C_BFu15s  {
  unsigned int v1:8;
  char v2;
  unsigned short v3:15;
};
//SIG(1 BFu8i_C_BFu15s) C1{ Fi:8 Fc Fs:15}



static void Test_BFu8i_C_BFu15s()
{
  {
    init_simple_test("BFu8i_C_BFu15s");
    static STRUCT_IF_C BFu8i_C_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_C_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu15s, BFu8i_C_BFu15s)
//============================================================================


struct  BFu8i_C_BFu16i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:16;
};
//SIG(1 BFu8i_C_BFu16i) C1{ Fi:8 Fc Fi:16}



static void Test_BFu8i_C_BFu16i()
{
  {
    init_simple_test("BFu8i_C_BFu16i");
    static STRUCT_IF_C BFu8i_C_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_C_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu16i, BFu8i_C_BFu16i)
//============================================================================


struct  BFu8i_C_BFu16ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_C_BFu16ll) C1{ Fi:8 Fc FL:16}



static void Test_BFu8i_C_BFu16ll()
{
  {
    init_simple_test("BFu8i_C_BFu16ll");
    static STRUCT_IF_C BFu8i_C_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_C_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_C_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu16ll, BFu8i_C_BFu16ll)
//============================================================================


struct  BFu8i_C_BFu16s  {
  unsigned int v1:8;
  char v2;
  unsigned short v3:16;
};
//SIG(1 BFu8i_C_BFu16s) C1{ Fi:8 Fc Fs:16}



static void Test_BFu8i_C_BFu16s()
{
  {
    init_simple_test("BFu8i_C_BFu16s");
    static STRUCT_IF_C BFu8i_C_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_C_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu16s, BFu8i_C_BFu16s)
//============================================================================


struct  BFu8i_C_BFu17i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:17;
};
//SIG(1 BFu8i_C_BFu17i) C1{ Fi:8 Fc Fi:17}



static void Test_BFu8i_C_BFu17i()
{
  {
    init_simple_test("BFu8i_C_BFu17i");
    static STRUCT_IF_C BFu8i_C_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_C_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu17i, BFu8i_C_BFu17i)
//============================================================================


struct  BFu8i_C_BFu17ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_C_BFu17ll) C1{ Fi:8 Fc FL:17}



static void Test_BFu8i_C_BFu17ll()
{
  {
    init_simple_test("BFu8i_C_BFu17ll");
    static STRUCT_IF_C BFu8i_C_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8i_C_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8i_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu17ll, BFu8i_C_BFu17ll)
//============================================================================


struct  BFu8i_C_BFu1c  {
  unsigned int v1:8;
  char v2;
  unsigned char v3:1;
};
//SIG(1 BFu8i_C_BFu1c) C1{ Fi:8 Fc Fc:1}



static void Test_BFu8i_C_BFu1c()
{
  {
    init_simple_test("BFu8i_C_BFu1c");
    static STRUCT_IF_C BFu8i_C_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu1c, BFu8i_C_BFu1c)
//============================================================================


struct  BFu8i_C_BFu1i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:1;
};
//SIG(1 BFu8i_C_BFu1i) C1{ Fi:8 Fc Fi:1}



static void Test_BFu8i_C_BFu1i()
{
  {
    init_simple_test("BFu8i_C_BFu1i");
    static STRUCT_IF_C BFu8i_C_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu1i, BFu8i_C_BFu1i)
//============================================================================


struct  BFu8i_C_BFu1ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_C_BFu1ll) C1{ Fi:8 Fc FL:1}



static void Test_BFu8i_C_BFu1ll()
{
  {
    init_simple_test("BFu8i_C_BFu1ll");
    static STRUCT_IF_C BFu8i_C_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_C_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu1ll, BFu8i_C_BFu1ll)
//============================================================================


struct  BFu8i_C_BFu1s  {
  unsigned int v1:8;
  char v2;
  unsigned short v3:1;
};
//SIG(1 BFu8i_C_BFu1s) C1{ Fi:8 Fc Fs:1}



static void Test_BFu8i_C_BFu1s()
{
  {
    init_simple_test("BFu8i_C_BFu1s");
    static STRUCT_IF_C BFu8i_C_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu1s, BFu8i_C_BFu1s)
//============================================================================


struct  BFu8i_C_BFu31i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:31;
};
//SIG(1 BFu8i_C_BFu31i) C1{ Fi:8 Fc Fi:31}



static void Test_BFu8i_C_BFu31i()
{
  {
    init_simple_test("BFu8i_C_BFu31i");
    static STRUCT_IF_C BFu8i_C_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_C_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu31i, BFu8i_C_BFu31i)
//============================================================================


struct  BFu8i_C_BFu31ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_C_BFu31ll) C1{ Fi:8 Fc FL:31}



static void Test_BFu8i_C_BFu31ll()
{
  {
    init_simple_test("BFu8i_C_BFu31ll");
    static STRUCT_IF_C BFu8i_C_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8i_C_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8i_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu31ll, BFu8i_C_BFu31ll)
//============================================================================


struct  BFu8i_C_BFu32i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:32;
};
//SIG(1 BFu8i_C_BFu32i) C1{ Fi:8 Fc Fi:32}



static void Test_BFu8i_C_BFu32i()
{
  {
    init_simple_test("BFu8i_C_BFu32i");
    static STRUCT_IF_C BFu8i_C_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_C_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu32i, BFu8i_C_BFu32i)
//============================================================================


struct  BFu8i_C_BFu32ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_C_BFu32ll) C1{ Fi:8 Fc FL:32}



static void Test_BFu8i_C_BFu32ll()
{
  {
    init_simple_test("BFu8i_C_BFu32ll");
    static STRUCT_IF_C BFu8i_C_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8i_C_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8i_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu32ll, BFu8i_C_BFu32ll)
//============================================================================


struct  BFu8i_C_BFu33  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_C_BFu33) C1{ Fi:8 Fc FL:33}



static void Test_BFu8i_C_BFu33()
{
  {
    init_simple_test("BFu8i_C_BFu33");
    static STRUCT_IF_C BFu8i_C_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu33");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8i_C_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8i_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu33, BFu8i_C_BFu33)
//============================================================================


struct  BFu8i_C_BFu7c  {
  unsigned int v1:8;
  char v2;
  unsigned char v3:7;
};
//SIG(1 BFu8i_C_BFu7c) C1{ Fi:8 Fc Fc:7}



static void Test_BFu8i_C_BFu7c()
{
  {
    init_simple_test("BFu8i_C_BFu7c");
    static STRUCT_IF_C BFu8i_C_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_C_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu7c, BFu8i_C_BFu7c)
//============================================================================


struct  BFu8i_C_BFu7i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:7;
};
//SIG(1 BFu8i_C_BFu7i) C1{ Fi:8 Fc Fi:7}



static void Test_BFu8i_C_BFu7i()
{
  {
    init_simple_test("BFu8i_C_BFu7i");
    static STRUCT_IF_C BFu8i_C_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_C_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu7i, BFu8i_C_BFu7i)
//============================================================================


struct  BFu8i_C_BFu7ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_C_BFu7ll) C1{ Fi:8 Fc FL:7}



static void Test_BFu8i_C_BFu7ll()
{
  {
    init_simple_test("BFu8i_C_BFu7ll");
    static STRUCT_IF_C BFu8i_C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_C_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu7ll, BFu8i_C_BFu7ll)
//============================================================================


struct  BFu8i_C_BFu7s  {
  unsigned int v1:8;
  char v2;
  unsigned short v3:7;
};
//SIG(1 BFu8i_C_BFu7s) C1{ Fi:8 Fc Fs:7}



static void Test_BFu8i_C_BFu7s()
{
  {
    init_simple_test("BFu8i_C_BFu7s");
    static STRUCT_IF_C BFu8i_C_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_C_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu7s, BFu8i_C_BFu7s)
//============================================================================


struct  BFu8i_C_BFu8c  {
  unsigned int v1:8;
  char v2;
  unsigned char v3:8;
};
//SIG(1 BFu8i_C_BFu8c) C1{ Fi:8 Fc Fc:8}



static void Test_BFu8i_C_BFu8c()
{
  {
    init_simple_test("BFu8i_C_BFu8c");
    static STRUCT_IF_C BFu8i_C_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_C_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu8c, BFu8i_C_BFu8c)
//============================================================================


struct  BFu8i_C_BFu8i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:8;
};
//SIG(1 BFu8i_C_BFu8i) C1{ Fi:8 Fc Fi:8}



static void Test_BFu8i_C_BFu8i()
{
  {
    init_simple_test("BFu8i_C_BFu8i");
    static STRUCT_IF_C BFu8i_C_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_C_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu8i, BFu8i_C_BFu8i)
//============================================================================


struct  BFu8i_C_BFu8ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_C_BFu8ll) C1{ Fi:8 Fc FL:8}



static void Test_BFu8i_C_BFu8ll()
{
  {
    init_simple_test("BFu8i_C_BFu8ll");
    static STRUCT_IF_C BFu8i_C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_C_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu8ll, BFu8i_C_BFu8ll)
//============================================================================


struct  BFu8i_C_BFu8s  {
  unsigned int v1:8;
  char v2;
  unsigned short v3:8;
};
//SIG(1 BFu8i_C_BFu8s) C1{ Fi:8 Fc Fs:8}



static void Test_BFu8i_C_BFu8s()
{
  {
    init_simple_test("BFu8i_C_BFu8s");
    static STRUCT_IF_C BFu8i_C_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_C_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu8s, BFu8i_C_BFu8s)
//============================================================================


struct  BFu8i_C_BFu9i  {
  unsigned int v1:8;
  char v2;
  unsigned int v3:9;
};
//SIG(1 BFu8i_C_BFu9i) C1{ Fi:8 Fc Fi:9}



static void Test_BFu8i_C_BFu9i()
{
  {
    init_simple_test("BFu8i_C_BFu9i");
    static STRUCT_IF_C BFu8i_C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_C_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu9i, BFu8i_C_BFu9i)
//============================================================================


struct  BFu8i_C_BFu9ll  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_C_BFu9ll) C1{ Fi:8 Fc FL:9}



static void Test_BFu8i_C_BFu9ll()
{
  {
    init_simple_test("BFu8i_C_BFu9ll");
    static STRUCT_IF_C BFu8i_C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_C_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu9ll, BFu8i_C_BFu9ll)
//============================================================================


struct  BFu8i_C_BFu9s  {
  unsigned int v1:8;
  char v2;
  unsigned short v3:9;
};
//SIG(1 BFu8i_C_BFu9s) C1{ Fi:8 Fc Fs:9}



static void Test_BFu8i_C_BFu9s()
{
  {
    init_simple_test("BFu8i_C_BFu9s");
    static STRUCT_IF_C BFu8i_C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8i_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_C_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_BFu9s, BFu8i_C_BFu9s)
//============================================================================


struct  BFu8i_C_C  {
  unsigned int v1:8;
  char v2;
  char v3;
};
//SIG(1 BFu8i_C_C) C1{ Fi:8 Fc[2]}



static void Test_BFu8i_C_C()
{
  {
    init_simple_test("BFu8i_C_C");
    static STRUCT_IF_C BFu8i_C_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_C");
    check_field_offset(lv, v2, 1, "BFu8i_C_C.v2");
    check_field_offset(lv, v3, 2, "BFu8i_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_C, BFu8i_C_C)
//============================================================================


struct  BFu8i_C_D  {
  unsigned int v1:8;
  char v2;
  double v3;
};
//SIG(1 BFu8i_C_D) C1{ Fi:8 Fc FL}



static void Test_BFu8i_C_D()
{
  {
    init_simple_test("BFu8i_C_D");
    static STRUCT_IF_C BFu8i_C_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_D");
    check_field_offset(lv, v2, 1, "BFu8i_C_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_D, BFu8i_C_D)
//============================================================================


struct  BFu8i_C_F  {
  unsigned int v1:8;
  char v2;
  float v3;
};
//SIG(1 BFu8i_C_F) C1{ Fi:8 Fc Fi}



static void Test_BFu8i_C_F()
{
  {
    init_simple_test("BFu8i_C_F");
    static STRUCT_IF_C BFu8i_C_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_F");
    check_field_offset(lv, v2, 1, "BFu8i_C_F.v2");
    check_field_offset(lv, v3, 4, "BFu8i_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_F, BFu8i_C_F)
//============================================================================


struct  BFu8i_C_I  {
  unsigned int v1:8;
  char v2;
  int v3;
};
//SIG(1 BFu8i_C_I) C1{ Fi:8 Fc Fi}



static void Test_BFu8i_C_I()
{
  {
    init_simple_test("BFu8i_C_I");
    static STRUCT_IF_C BFu8i_C_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_I");
    check_field_offset(lv, v2, 1, "BFu8i_C_I.v2");
    check_field_offset(lv, v3, 4, "BFu8i_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_I, BFu8i_C_I)
//============================================================================


struct  BFu8i_C_Ip  {
  unsigned int v1:8;
  char v2;
  int *v3;
};
//SIG(1 BFu8i_C_Ip) C1{ Fi:8 Fc Fp}



static void Test_BFu8i_C_Ip()
{
  {
    init_simple_test("BFu8i_C_Ip");
    static STRUCT_IF_C BFu8i_C_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_Ip");
    check_field_offset(lv, v2, 1, "BFu8i_C_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_Ip, BFu8i_C_Ip)
//============================================================================


struct  BFu8i_C_L  {
  unsigned int v1:8;
  char v2;
  __tsi64 v3;
};
//SIG(1 BFu8i_C_L) C1{ Fi:8 Fc FL}



static void Test_BFu8i_C_L()
{
  {
    init_simple_test("BFu8i_C_L");
    static STRUCT_IF_C BFu8i_C_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_L");
    check_field_offset(lv, v2, 1, "BFu8i_C_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_L, BFu8i_C_L)
//============================================================================


struct  BFu8i_C_S  {
  unsigned int v1:8;
  char v2;
  short v3;
};
//SIG(1 BFu8i_C_S) C1{ Fi:8 Fc Fs}



static void Test_BFu8i_C_S()
{
  {
    init_simple_test("BFu8i_C_S");
    static STRUCT_IF_C BFu8i_C_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_S");
    check_field_offset(lv, v2, 1, "BFu8i_C_S.v2");
    check_field_offset(lv, v3, 2, "BFu8i_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_S, BFu8i_C_S)
//============================================================================


struct  BFu8i_C_Uc  {
  unsigned int v1:8;
  char v2;
  unsigned char v3;
};
//SIG(1 BFu8i_C_Uc) C1{ Fi:8 Fc[2]}



static void Test_BFu8i_C_Uc()
{
  {
    init_simple_test("BFu8i_C_Uc");
    static STRUCT_IF_C BFu8i_C_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_Uc");
    check_field_offset(lv, v2, 1, "BFu8i_C_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu8i_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_Uc, BFu8i_C_Uc)
//============================================================================


struct  BFu8i_C_Ui  {
  unsigned int v1:8;
  char v2;
  unsigned int v3;
};
//SIG(1 BFu8i_C_Ui) C1{ Fi:8 Fc Fi}



static void Test_BFu8i_C_Ui()
{
  {
    init_simple_test("BFu8i_C_Ui");
    static STRUCT_IF_C BFu8i_C_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_C_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_Ui");
    check_field_offset(lv, v2, 1, "BFu8i_C_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu8i_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_Ui, BFu8i_C_Ui)
//============================================================================


struct  BFu8i_C_Ul  {
  unsigned int v1:8;
  char v2;
  __tsu64 v3;
};
//SIG(1 BFu8i_C_Ul) C1{ Fi:8 Fc FL}



static void Test_BFu8i_C_Ul()
{
  {
    init_simple_test("BFu8i_C_Ul");
    static STRUCT_IF_C BFu8i_C_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_Ul");
    check_field_offset(lv, v2, 1, "BFu8i_C_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_Ul, BFu8i_C_Ul)
//============================================================================


struct  BFu8i_C_Us  {
  unsigned int v1:8;
  char v2;
  unsigned short v3;
};
//SIG(1 BFu8i_C_Us) C1{ Fi:8 Fc Fs}



static void Test_BFu8i_C_Us()
{
  {
    init_simple_test("BFu8i_C_Us");
    static STRUCT_IF_C BFu8i_C_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_Us");
    check_field_offset(lv, v2, 1, "BFu8i_C_Us.v2");
    check_field_offset(lv, v3, 2, "BFu8i_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_Us, BFu8i_C_Us)
//============================================================================


struct  BFu8i_C_Vp  {
  unsigned int v1:8;
  char v2;
  void *v3;
};
//SIG(1 BFu8i_C_Vp) C1{ Fi:8 Fc Fp}



static void Test_BFu8i_C_Vp()
{
  {
    init_simple_test("BFu8i_C_Vp");
    static STRUCT_IF_C BFu8i_C_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_C_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_Vp");
    check_field_offset(lv, v2, 1, "BFu8i_C_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_Vp, BFu8i_C_Vp)
//============================================================================


struct  BFu8i_D  {
  unsigned int v1:8;
  double v2;
};
//SIG(1 BFu8i_D) C1{ Fi:8 FL}



static void Test_BFu8i_D()
{
  {
    init_simple_test("BFu8i_D");
    static STRUCT_IF_C BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D, BFu8i_D)
//============================================================================


struct  BFu8i_D_BFu15i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:15;
};
//SIG(1 BFu8i_D_BFu15i) C1{ Fi:8 FL Fi:15}



static void Test_BFu8i_D_BFu15i()
{
  {
    init_simple_test("BFu8i_D_BFu15i");
    static STRUCT_IF_C BFu8i_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu15i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu8i_D_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu8i_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu15i, BFu8i_D_BFu15i)
//============================================================================


struct  BFu8i_D_BFu15ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_D_BFu15ll) C1{ Fi:8 FL FL:15}



static void Test_BFu8i_D_BFu15ll()
{
  {
    init_simple_test("BFu8i_D_BFu15ll");
    static STRUCT_IF_C BFu8i_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu15ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu8i_D_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu8i_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu15ll, BFu8i_D_BFu15ll)
//============================================================================


struct  BFu8i_D_BFu15s  {
  unsigned int v1:8;
  double v2;
  unsigned short v3:15;
};
//SIG(1 BFu8i_D_BFu15s) C1{ Fi:8 FL Fs:15}



static void Test_BFu8i_D_BFu15s()
{
  {
    init_simple_test("BFu8i_D_BFu15s");
    static STRUCT_IF_C BFu8i_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu15s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu8i_D_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu8i_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu15s, BFu8i_D_BFu15s)
//============================================================================


struct  BFu8i_D_BFu16i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:16;
};
//SIG(1 BFu8i_D_BFu16i) C1{ Fi:8 FL Fi:16}



static void Test_BFu8i_D_BFu16i()
{
  {
    init_simple_test("BFu8i_D_BFu16i");
    static STRUCT_IF_C BFu8i_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu16i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu8i_D_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu8i_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu16i, BFu8i_D_BFu16i)
//============================================================================


struct  BFu8i_D_BFu16ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_D_BFu16ll) C1{ Fi:8 FL FL:16}



static void Test_BFu8i_D_BFu16ll()
{
  {
    init_simple_test("BFu8i_D_BFu16ll");
    static STRUCT_IF_C BFu8i_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu16ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu8i_D_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu8i_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu16ll, BFu8i_D_BFu16ll)
//============================================================================


struct  BFu8i_D_BFu16s  {
  unsigned int v1:8;
  double v2;
  unsigned short v3:16;
};
//SIG(1 BFu8i_D_BFu16s) C1{ Fi:8 FL Fs:16}



static void Test_BFu8i_D_BFu16s()
{
  {
    init_simple_test("BFu8i_D_BFu16s");
    static STRUCT_IF_C BFu8i_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu16s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu8i_D_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu8i_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu16s, BFu8i_D_BFu16s)
//============================================================================


struct  BFu8i_D_BFu17i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:17;
};
//SIG(1 BFu8i_D_BFu17i) C1{ Fi:8 FL Fi:17}



static void Test_BFu8i_D_BFu17i()
{
  {
    init_simple_test("BFu8i_D_BFu17i");
    static STRUCT_IF_C BFu8i_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu17i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu8i_D_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu8i_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu17i, BFu8i_D_BFu17i)
//============================================================================


struct  BFu8i_D_BFu17ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_D_BFu17ll) C1{ Fi:8 FL FL:17}



static void Test_BFu8i_D_BFu17ll()
{
  {
    init_simple_test("BFu8i_D_BFu17ll");
    static STRUCT_IF_C BFu8i_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu17ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu8i_D_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu8i_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu17ll, BFu8i_D_BFu17ll)
//============================================================================


struct  BFu8i_D_BFu1c  {
  unsigned int v1:8;
  double v2;
  unsigned char v3:1;
};
//SIG(1 BFu8i_D_BFu1c) C1{ Fi:8 FL Fc:1}



static void Test_BFu8i_D_BFu1c()
{
  {
    init_simple_test("BFu8i_D_BFu1c");
    static STRUCT_IF_C BFu8i_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu1c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu8i_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu1c, BFu8i_D_BFu1c)
//============================================================================


struct  BFu8i_D_BFu1i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:1;
};
//SIG(1 BFu8i_D_BFu1i) C1{ Fi:8 FL Fi:1}



static void Test_BFu8i_D_BFu1i()
{
  {
    init_simple_test("BFu8i_D_BFu1i");
    static STRUCT_IF_C BFu8i_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu1i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu8i_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu1i, BFu8i_D_BFu1i)
//============================================================================


struct  BFu8i_D_BFu1ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_D_BFu1ll) C1{ Fi:8 FL FL:1}



static void Test_BFu8i_D_BFu1ll()
{
  {
    init_simple_test("BFu8i_D_BFu1ll");
    static STRUCT_IF_C BFu8i_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu1ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu8i_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu1ll, BFu8i_D_BFu1ll)
//============================================================================


struct  BFu8i_D_BFu1s  {
  unsigned int v1:8;
  double v2;
  unsigned short v3:1;
};
//SIG(1 BFu8i_D_BFu1s) C1{ Fi:8 FL Fs:1}



static void Test_BFu8i_D_BFu1s()
{
  {
    init_simple_test("BFu8i_D_BFu1s");
    static STRUCT_IF_C BFu8i_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu1s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu8i_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu1s, BFu8i_D_BFu1s)
//============================================================================


struct  BFu8i_D_BFu31i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:31;
};
//SIG(1 BFu8i_D_BFu31i) C1{ Fi:8 FL Fi:31}



static void Test_BFu8i_D_BFu31i()
{
  {
    init_simple_test("BFu8i_D_BFu31i");
    static STRUCT_IF_C BFu8i_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu31i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu8i_D_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu8i_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu31i, BFu8i_D_BFu31i)
//============================================================================


struct  BFu8i_D_BFu31ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_D_BFu31ll) C1{ Fi:8 FL FL:31}



static void Test_BFu8i_D_BFu31ll()
{
  {
    init_simple_test("BFu8i_D_BFu31ll");
    static STRUCT_IF_C BFu8i_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu31ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu8i_D_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu8i_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu31ll, BFu8i_D_BFu31ll)
//============================================================================


struct  BFu8i_D_BFu32i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:32;
};
//SIG(1 BFu8i_D_BFu32i) C1{ Fi:8 FL Fi:32}



static void Test_BFu8i_D_BFu32i()
{
  {
    init_simple_test("BFu8i_D_BFu32i");
    static STRUCT_IF_C BFu8i_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu32i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu8i_D_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu8i_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu32i, BFu8i_D_BFu32i)
//============================================================================


struct  BFu8i_D_BFu32ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_D_BFu32ll) C1{ Fi:8 FL FL:32}



static void Test_BFu8i_D_BFu32ll()
{
  {
    init_simple_test("BFu8i_D_BFu32ll");
    static STRUCT_IF_C BFu8i_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu32ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu8i_D_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu8i_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu32ll, BFu8i_D_BFu32ll)
//============================================================================


struct  BFu8i_D_BFu33  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_D_BFu33) C1{ Fi:8 FL FL:33}



static void Test_BFu8i_D_BFu33()
{
  {
    init_simple_test("BFu8i_D_BFu33");
    static STRUCT_IF_C BFu8i_D_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu8i_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu33");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "BFu8i_D_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "BFu8i_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu33, BFu8i_D_BFu33)
//============================================================================


struct  BFu8i_D_BFu7c  {
  unsigned int v1:8;
  double v2;
  unsigned char v3:7;
};
//SIG(1 BFu8i_D_BFu7c) C1{ Fi:8 FL Fc:7}



static void Test_BFu8i_D_BFu7c()
{
  {
    init_simple_test("BFu8i_D_BFu7c");
    static STRUCT_IF_C BFu8i_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu7c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu8i_D_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu8i_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu7c, BFu8i_D_BFu7c)
//============================================================================


struct  BFu8i_D_BFu7i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:7;
};
//SIG(1 BFu8i_D_BFu7i) C1{ Fi:8 FL Fi:7}



static void Test_BFu8i_D_BFu7i()
{
  {
    init_simple_test("BFu8i_D_BFu7i");
    static STRUCT_IF_C BFu8i_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu7i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu8i_D_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu8i_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu7i, BFu8i_D_BFu7i)
//============================================================================


struct  BFu8i_D_BFu7ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_D_BFu7ll) C1{ Fi:8 FL FL:7}



static void Test_BFu8i_D_BFu7ll()
{
  {
    init_simple_test("BFu8i_D_BFu7ll");
    static STRUCT_IF_C BFu8i_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu7ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu8i_D_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu8i_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu7ll, BFu8i_D_BFu7ll)
//============================================================================


struct  BFu8i_D_BFu7s  {
  unsigned int v1:8;
  double v2;
  unsigned short v3:7;
};
//SIG(1 BFu8i_D_BFu7s) C1{ Fi:8 FL Fs:7}



static void Test_BFu8i_D_BFu7s()
{
  {
    init_simple_test("BFu8i_D_BFu7s");
    static STRUCT_IF_C BFu8i_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu7s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu8i_D_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu8i_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu7s, BFu8i_D_BFu7s)
//============================================================================


struct  BFu8i_D_BFu8c  {
  unsigned int v1:8;
  double v2;
  unsigned char v3:8;
};
//SIG(1 BFu8i_D_BFu8c) C1{ Fi:8 FL Fc:8}



static void Test_BFu8i_D_BFu8c()
{
  {
    init_simple_test("BFu8i_D_BFu8c");
    static STRUCT_IF_C BFu8i_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu8c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu8i_D_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu8c, BFu8i_D_BFu8c)
//============================================================================


struct  BFu8i_D_BFu8i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:8;
};
//SIG(1 BFu8i_D_BFu8i) C1{ Fi:8 FL Fi:8}



static void Test_BFu8i_D_BFu8i()
{
  {
    init_simple_test("BFu8i_D_BFu8i");
    static STRUCT_IF_C BFu8i_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu8i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu8i_D_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu8i, BFu8i_D_BFu8i)
//============================================================================


struct  BFu8i_D_BFu8ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_D_BFu8ll) C1{ Fi:8 FL FL:8}



static void Test_BFu8i_D_BFu8ll()
{
  {
    init_simple_test("BFu8i_D_BFu8ll");
    static STRUCT_IF_C BFu8i_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu8ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu8i_D_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu8ll, BFu8i_D_BFu8ll)
//============================================================================


struct  BFu8i_D_BFu8s  {
  unsigned int v1:8;
  double v2;
  unsigned short v3:8;
};
//SIG(1 BFu8i_D_BFu8s) C1{ Fi:8 FL Fs:8}



static void Test_BFu8i_D_BFu8s()
{
  {
    init_simple_test("BFu8i_D_BFu8s");
    static STRUCT_IF_C BFu8i_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu8s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu8i_D_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu8s, BFu8i_D_BFu8s)
//============================================================================


struct  BFu8i_D_BFu9i  {
  unsigned int v1:8;
  double v2;
  unsigned int v3:9;
};
//SIG(1 BFu8i_D_BFu9i) C1{ Fi:8 FL Fi:9}



static void Test_BFu8i_D_BFu9i()
{
  {
    init_simple_test("BFu8i_D_BFu9i");
    static STRUCT_IF_C BFu8i_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu9i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu8i_D_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu8i_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu9i, BFu8i_D_BFu9i)
//============================================================================


struct  BFu8i_D_BFu9ll  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_D_BFu9ll) C1{ Fi:8 FL FL:9}



static void Test_BFu8i_D_BFu9ll()
{
  {
    init_simple_test("BFu8i_D_BFu9ll");
    static STRUCT_IF_C BFu8i_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu9ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu8i_D_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu8i_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu9ll, BFu8i_D_BFu9ll)
//============================================================================


struct  BFu8i_D_BFu9s  {
  unsigned int v1:8;
  double v2;
  unsigned short v3:9;
};
//SIG(1 BFu8i_D_BFu9s) C1{ Fi:8 FL Fs:9}



static void Test_BFu8i_D_BFu9s()
{
  {
    init_simple_test("BFu8i_D_BFu9s");
    static STRUCT_IF_C BFu8i_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_BFu9s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu8i_D_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu8i_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_BFu9s, BFu8i_D_BFu9s)
//============================================================================


struct  BFu8i_D_C  {
  unsigned int v1:8;
  double v2;
  char v3;
};
//SIG(1 BFu8i_D_C) C1{ Fi:8 FL Fc}



static void Test_BFu8i_D_C()
{
  {
    init_simple_test("BFu8i_D_C");
    static STRUCT_IF_C BFu8i_D_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_C, BFu8i_D_C)
//============================================================================


struct  BFu8i_D_D  {
  unsigned int v1:8;
  double v2;
  double v3;
};
//SIG(1 BFu8i_D_D) C1{ Fi:8 FL[2]}



static void Test_BFu8i_D_D()
{
  {
    init_simple_test("BFu8i_D_D");
    static STRUCT_IF_C BFu8i_D_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu8i_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_D, BFu8i_D_D)
//============================================================================


struct  BFu8i_D_F  {
  unsigned int v1:8;
  double v2;
  float v3;
};
//SIG(1 BFu8i_D_F) C1{ Fi:8 FL Fi}



static void Test_BFu8i_D_F()
{
  {
    init_simple_test("BFu8i_D_F");
    static STRUCT_IF_C BFu8i_D_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_F, BFu8i_D_F)
//============================================================================


struct  BFu8i_D_I  {
  unsigned int v1:8;
  double v2;
  int v3;
};
//SIG(1 BFu8i_D_I) C1{ Fi:8 FL Fi}



static void Test_BFu8i_D_I()
{
  {
    init_simple_test("BFu8i_D_I");
    static STRUCT_IF_C BFu8i_D_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_I, BFu8i_D_I)
//============================================================================


struct  BFu8i_D_Ip  {
  unsigned int v1:8;
  double v2;
  int *v3;
};
//SIG(1 BFu8i_D_Ip) C1{ Fi:8 FL Fp}



static void Test_BFu8i_D_Ip()
{
  {
    init_simple_test("BFu8i_D_Ip");
    static STRUCT_IF_C BFu8i_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_Ip, BFu8i_D_Ip)
//============================================================================


struct  BFu8i_D_L  {
  unsigned int v1:8;
  double v2;
  __tsi64 v3;
};
//SIG(1 BFu8i_D_L) C1{ Fi:8 FL[2]}



static void Test_BFu8i_D_L()
{
  {
    init_simple_test("BFu8i_D_L");
    static STRUCT_IF_C BFu8i_D_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu8i_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_L, BFu8i_D_L)
//============================================================================


struct  BFu8i_D_S  {
  unsigned int v1:8;
  double v2;
  short v3;
};
//SIG(1 BFu8i_D_S) C1{ Fi:8 FL Fs}



static void Test_BFu8i_D_S()
{
  {
    init_simple_test("BFu8i_D_S");
    static STRUCT_IF_C BFu8i_D_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_S, BFu8i_D_S)
//============================================================================


struct  BFu8i_D_Uc  {
  unsigned int v1:8;
  double v2;
  unsigned char v3;
};
//SIG(1 BFu8i_D_Uc) C1{ Fi:8 FL Fc}



static void Test_BFu8i_D_Uc()
{
  {
    init_simple_test("BFu8i_D_Uc");
    static STRUCT_IF_C BFu8i_D_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_Uc, BFu8i_D_Uc)
//============================================================================


struct  BFu8i_D_Ui  {
  unsigned int v1:8;
  double v2;
  unsigned int v3;
};
//SIG(1 BFu8i_D_Ui) C1{ Fi:8 FL Fi}



static void Test_BFu8i_D_Ui()
{
  {
    init_simple_test("BFu8i_D_Ui");
    static STRUCT_IF_C BFu8i_D_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_Ui, BFu8i_D_Ui)
//============================================================================


struct  BFu8i_D_Ul  {
  unsigned int v1:8;
  double v2;
  __tsu64 v3;
};
//SIG(1 BFu8i_D_Ul) C1{ Fi:8 FL[2]}



static void Test_BFu8i_D_Ul()
{
  {
    init_simple_test("BFu8i_D_Ul");
    static STRUCT_IF_C BFu8i_D_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu8i_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_Ul, BFu8i_D_Ul)
//============================================================================


struct  BFu8i_D_Us  {
  unsigned int v1:8;
  double v2;
  unsigned short v3;
};
//SIG(1 BFu8i_D_Us) C1{ Fi:8 FL Fs}



static void Test_BFu8i_D_Us()
{
  {
    init_simple_test("BFu8i_D_Us");
    static STRUCT_IF_C BFu8i_D_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_Us, BFu8i_D_Us)
//============================================================================


struct  BFu8i_D_Vp  {
  unsigned int v1:8;
  double v2;
  void *v3;
};
//SIG(1 BFu8i_D_Vp) C1{ Fi:8 FL Fp}



static void Test_BFu8i_D_Vp()
{
  {
    init_simple_test("BFu8i_D_Vp");
    static STRUCT_IF_C BFu8i_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_Vp, BFu8i_D_Vp)
//============================================================================


struct  BFu8i_F  {
  unsigned int v1:8;
  float v2;
};
//SIG(1 BFu8i_F) C1{ Fi:8 Fi}



static void Test_BFu8i_F()
{
  {
    init_simple_test("BFu8i_F");
    static STRUCT_IF_C BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F");
    check_field_offset(lv, v2, 4, "BFu8i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F, BFu8i_F)
//============================================================================


struct  BFu8i_F_BFu15i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:15;
};
//SIG(1 BFu8i_F_BFu15i) C1{ Fi:8 Fi Fi:15}



static void Test_BFu8i_F_BFu15i()
{
  {
    init_simple_test("BFu8i_F_BFu15i");
    static STRUCT_IF_C BFu8i_F_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu15i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu8i_F_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu8i_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu15i, BFu8i_F_BFu15i)
//============================================================================


struct  BFu8i_F_BFu15ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_F_BFu15ll) C1{ Fi:8 Fi FL:15}



static void Test_BFu8i_F_BFu15ll()
{
  {
    init_simple_test("BFu8i_F_BFu15ll");
    static STRUCT_IF_C BFu8i_F_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu8i_F_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu8i_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu15ll, BFu8i_F_BFu15ll)
//============================================================================


struct  BFu8i_F_BFu15s  {
  unsigned int v1:8;
  float v2;
  unsigned short v3:15;
};
//SIG(1 BFu8i_F_BFu15s) C1{ Fi:8 Fi Fs:15}



static void Test_BFu8i_F_BFu15s()
{
  {
    init_simple_test("BFu8i_F_BFu15s");
    static STRUCT_IF_C BFu8i_F_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu15s");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu8i_F_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu8i_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu15s, BFu8i_F_BFu15s)
//============================================================================


struct  BFu8i_F_BFu16i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:16;
};
//SIG(1 BFu8i_F_BFu16i) C1{ Fi:8 Fi Fi:16}



static void Test_BFu8i_F_BFu16i()
{
  {
    init_simple_test("BFu8i_F_BFu16i");
    static STRUCT_IF_C BFu8i_F_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu16i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu8i_F_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu8i_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu16i, BFu8i_F_BFu16i)
//============================================================================


struct  BFu8i_F_BFu16ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_F_BFu16ll) C1{ Fi:8 Fi FL:16}



static void Test_BFu8i_F_BFu16ll()
{
  {
    init_simple_test("BFu8i_F_BFu16ll");
    static STRUCT_IF_C BFu8i_F_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu8i_F_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu8i_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu16ll, BFu8i_F_BFu16ll)
//============================================================================


struct  BFu8i_F_BFu16s  {
  unsigned int v1:8;
  float v2;
  unsigned short v3:16;
};
//SIG(1 BFu8i_F_BFu16s) C1{ Fi:8 Fi Fs:16}



static void Test_BFu8i_F_BFu16s()
{
  {
    init_simple_test("BFu8i_F_BFu16s");
    static STRUCT_IF_C BFu8i_F_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu16s");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu8i_F_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu8i_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu16s, BFu8i_F_BFu16s)
//============================================================================


struct  BFu8i_F_BFu17i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:17;
};
//SIG(1 BFu8i_F_BFu17i) C1{ Fi:8 Fi Fi:17}



static void Test_BFu8i_F_BFu17i()
{
  {
    init_simple_test("BFu8i_F_BFu17i");
    static STRUCT_IF_C BFu8i_F_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu17i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu8i_F_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu8i_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu17i, BFu8i_F_BFu17i)
//============================================================================


struct  BFu8i_F_BFu17ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_F_BFu17ll) C1{ Fi:8 Fi FL:17}



static void Test_BFu8i_F_BFu17ll()
{
  {
    init_simple_test("BFu8i_F_BFu17ll");
    static STRUCT_IF_C BFu8i_F_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu8i_F_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu8i_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu17ll, BFu8i_F_BFu17ll)
//============================================================================


struct  BFu8i_F_BFu1c  {
  unsigned int v1:8;
  float v2;
  unsigned char v3:1;
};
//SIG(1 BFu8i_F_BFu1c) C1{ Fi:8 Fi Fc:1}



static void Test_BFu8i_F_BFu1c()
{
  {
    init_simple_test("BFu8i_F_BFu1c");
    static STRUCT_IF_C BFu8i_F_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu1c");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu8i_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu1c, BFu8i_F_BFu1c)
//============================================================================


struct  BFu8i_F_BFu1i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:1;
};
//SIG(1 BFu8i_F_BFu1i) C1{ Fi:8 Fi Fi:1}



static void Test_BFu8i_F_BFu1i()
{
  {
    init_simple_test("BFu8i_F_BFu1i");
    static STRUCT_IF_C BFu8i_F_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu1i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu8i_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu1i, BFu8i_F_BFu1i)
//============================================================================


struct  BFu8i_F_BFu1ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_F_BFu1ll) C1{ Fi:8 Fi FL:1}



static void Test_BFu8i_F_BFu1ll()
{
  {
    init_simple_test("BFu8i_F_BFu1ll");
    static STRUCT_IF_C BFu8i_F_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu8i_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu1ll, BFu8i_F_BFu1ll)
//============================================================================


struct  BFu8i_F_BFu1s  {
  unsigned int v1:8;
  float v2;
  unsigned short v3:1;
};
//SIG(1 BFu8i_F_BFu1s) C1{ Fi:8 Fi Fs:1}



static void Test_BFu8i_F_BFu1s()
{
  {
    init_simple_test("BFu8i_F_BFu1s");
    static STRUCT_IF_C BFu8i_F_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu1s");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu8i_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu1s, BFu8i_F_BFu1s)
//============================================================================


struct  BFu8i_F_BFu31i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:31;
};
//SIG(1 BFu8i_F_BFu31i) C1{ Fi:8 Fi Fi:31}



static void Test_BFu8i_F_BFu31i()
{
  {
    init_simple_test("BFu8i_F_BFu31i");
    static STRUCT_IF_C BFu8i_F_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu31i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu8i_F_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu8i_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu31i, BFu8i_F_BFu31i)
//============================================================================


struct  BFu8i_F_BFu31ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_F_BFu31ll) C1{ Fi:8 Fi FL:31}



static void Test_BFu8i_F_BFu31ll()
{
  {
    init_simple_test("BFu8i_F_BFu31ll");
    static STRUCT_IF_C BFu8i_F_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu8i_F_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu8i_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu31ll, BFu8i_F_BFu31ll)
//============================================================================


struct  BFu8i_F_BFu32i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:32;
};
//SIG(1 BFu8i_F_BFu32i) C1{ Fi:8 Fi Fi:32}



static void Test_BFu8i_F_BFu32i()
{
  {
    init_simple_test("BFu8i_F_BFu32i");
    static STRUCT_IF_C BFu8i_F_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu32i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu8i_F_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu8i_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu32i, BFu8i_F_BFu32i)
//============================================================================


struct  BFu8i_F_BFu32ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_F_BFu32ll) C1{ Fi:8 Fi FL:32}



static void Test_BFu8i_F_BFu32ll()
{
  {
    init_simple_test("BFu8i_F_BFu32ll");
    static STRUCT_IF_C BFu8i_F_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu8i_F_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu8i_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu32ll, BFu8i_F_BFu32ll)
//============================================================================


struct  BFu8i_F_BFu33  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_F_BFu33) C1{ Fi:8 Fi FL:33}



static void Test_BFu8i_F_BFu33()
{
  {
    init_simple_test("BFu8i_F_BFu33");
    static STRUCT_IF_C BFu8i_F_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu33");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "BFu8i_F_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "BFu8i_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu33, BFu8i_F_BFu33)
//============================================================================


struct  BFu8i_F_BFu7c  {
  unsigned int v1:8;
  float v2;
  unsigned char v3:7;
};
//SIG(1 BFu8i_F_BFu7c) C1{ Fi:8 Fi Fc:7}



static void Test_BFu8i_F_BFu7c()
{
  {
    init_simple_test("BFu8i_F_BFu7c");
    static STRUCT_IF_C BFu8i_F_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu7c");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu8i_F_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu8i_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu7c, BFu8i_F_BFu7c)
//============================================================================


struct  BFu8i_F_BFu7i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:7;
};
//SIG(1 BFu8i_F_BFu7i) C1{ Fi:8 Fi Fi:7}



static void Test_BFu8i_F_BFu7i()
{
  {
    init_simple_test("BFu8i_F_BFu7i");
    static STRUCT_IF_C BFu8i_F_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu7i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu8i_F_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu8i_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu7i, BFu8i_F_BFu7i)
//============================================================================


struct  BFu8i_F_BFu7ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_F_BFu7ll) C1{ Fi:8 Fi FL:7}



static void Test_BFu8i_F_BFu7ll()
{
  {
    init_simple_test("BFu8i_F_BFu7ll");
    static STRUCT_IF_C BFu8i_F_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu8i_F_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu8i_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu7ll, BFu8i_F_BFu7ll)
//============================================================================


struct  BFu8i_F_BFu7s  {
  unsigned int v1:8;
  float v2;
  unsigned short v3:7;
};
//SIG(1 BFu8i_F_BFu7s) C1{ Fi:8 Fi Fs:7}



static void Test_BFu8i_F_BFu7s()
{
  {
    init_simple_test("BFu8i_F_BFu7s");
    static STRUCT_IF_C BFu8i_F_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu7s");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu8i_F_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu8i_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu7s, BFu8i_F_BFu7s)
//============================================================================


struct  BFu8i_F_BFu8c  {
  unsigned int v1:8;
  float v2;
  unsigned char v3:8;
};
//SIG(1 BFu8i_F_BFu8c) C1{ Fi:8 Fi Fc:8}



static void Test_BFu8i_F_BFu8c()
{
  {
    init_simple_test("BFu8i_F_BFu8c");
    static STRUCT_IF_C BFu8i_F_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu8c");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu8i_F_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu8c, BFu8i_F_BFu8c)
//============================================================================


struct  BFu8i_F_BFu8i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:8;
};
//SIG(1 BFu8i_F_BFu8i) C1{ Fi:8 Fi Fi:8}



static void Test_BFu8i_F_BFu8i()
{
  {
    init_simple_test("BFu8i_F_BFu8i");
    static STRUCT_IF_C BFu8i_F_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu8i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu8i_F_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu8i, BFu8i_F_BFu8i)
//============================================================================


struct  BFu8i_F_BFu8ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_F_BFu8ll) C1{ Fi:8 Fi FL:8}



static void Test_BFu8i_F_BFu8ll()
{
  {
    init_simple_test("BFu8i_F_BFu8ll");
    static STRUCT_IF_C BFu8i_F_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu8i_F_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu8ll, BFu8i_F_BFu8ll)
//============================================================================


struct  BFu8i_F_BFu8s  {
  unsigned int v1:8;
  float v2;
  unsigned short v3:8;
};
//SIG(1 BFu8i_F_BFu8s) C1{ Fi:8 Fi Fs:8}



static void Test_BFu8i_F_BFu8s()
{
  {
    init_simple_test("BFu8i_F_BFu8s");
    static STRUCT_IF_C BFu8i_F_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu8s");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu8i_F_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu8s, BFu8i_F_BFu8s)
//============================================================================


struct  BFu8i_F_BFu9i  {
  unsigned int v1:8;
  float v2;
  unsigned int v3:9;
};
//SIG(1 BFu8i_F_BFu9i) C1{ Fi:8 Fi Fi:9}



static void Test_BFu8i_F_BFu9i()
{
  {
    init_simple_test("BFu8i_F_BFu9i");
    static STRUCT_IF_C BFu8i_F_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu9i");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu8i_F_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu8i_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu9i, BFu8i_F_BFu9i)
//============================================================================


struct  BFu8i_F_BFu9ll  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_F_BFu9ll) C1{ Fi:8 Fi FL:9}



static void Test_BFu8i_F_BFu9ll()
{
  {
    init_simple_test("BFu8i_F_BFu9ll");
    static STRUCT_IF_C BFu8i_F_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu8i_F_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu8i_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu9ll, BFu8i_F_BFu9ll)
//============================================================================


struct  BFu8i_F_BFu9s  {
  unsigned int v1:8;
  float v2;
  unsigned short v3:9;
};
//SIG(1 BFu8i_F_BFu9s) C1{ Fi:8 Fi Fs:9}



static void Test_BFu8i_F_BFu9s()
{
  {
    init_simple_test("BFu8i_F_BFu9s");
    static STRUCT_IF_C BFu8i_F_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_BFu9s");
    check_field_offset(lv, v2, 4, "BFu8i_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu8i_F_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu8i_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_BFu9s, BFu8i_F_BFu9s)
//============================================================================


struct  BFu8i_F_C  {
  unsigned int v1:8;
  float v2;
  char v3;
};
//SIG(1 BFu8i_F_C) C1{ Fi:8 Fi Fc}



static void Test_BFu8i_F_C()
{
  {
    init_simple_test("BFu8i_F_C");
    static STRUCT_IF_C BFu8i_F_C lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_C");
    check_field_offset(lv, v2, 4, "BFu8i_F_C.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_C, BFu8i_F_C)
//============================================================================


struct  BFu8i_F_D  {
  unsigned int v1:8;
  float v2;
  double v3;
};
//SIG(1 BFu8i_F_D) C1{ Fi:8 Fi FL}



static void Test_BFu8i_F_D()
{
  {
    init_simple_test("BFu8i_F_D");
    static STRUCT_IF_C BFu8i_F_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_D");
    check_field_offset(lv, v2, 4, "BFu8i_F_D.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_D, BFu8i_F_D)
//============================================================================


struct  BFu8i_F_F  {
  unsigned int v1:8;
  float v2;
  float v3;
};
//SIG(1 BFu8i_F_F) C1{ Fi:8 Fi[2]}



static void Test_BFu8i_F_F()
{
  {
    init_simple_test("BFu8i_F_F");
    static STRUCT_IF_C BFu8i_F_F lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_F");
    check_field_offset(lv, v2, 4, "BFu8i_F_F.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_F, BFu8i_F_F)
//============================================================================


struct  BFu8i_F_I  {
  unsigned int v1:8;
  float v2;
  int v3;
};
//SIG(1 BFu8i_F_I) C1{ Fi:8 Fi[2]}



static void Test_BFu8i_F_I()
{
  {
    init_simple_test("BFu8i_F_I");
    static STRUCT_IF_C BFu8i_F_I lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_I");
    check_field_offset(lv, v2, 4, "BFu8i_F_I.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_I, BFu8i_F_I)
//============================================================================


struct  BFu8i_F_Ip  {
  unsigned int v1:8;
  float v2;
  int *v3;
};
//SIG(1 BFu8i_F_Ip) C1{ Fi:8 Fi Fp}



static void Test_BFu8i_F_Ip()
{
  {
    init_simple_test("BFu8i_F_Ip");
    static STRUCT_IF_C BFu8i_F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_Ip");
    check_field_offset(lv, v2, 4, "BFu8i_F_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_Ip, BFu8i_F_Ip)
//============================================================================


struct  BFu8i_F_L  {
  unsigned int v1:8;
  float v2;
  __tsi64 v3;
};
//SIG(1 BFu8i_F_L) C1{ Fi:8 Fi FL}



static void Test_BFu8i_F_L()
{
  {
    init_simple_test("BFu8i_F_L");
    static STRUCT_IF_C BFu8i_F_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_L");
    check_field_offset(lv, v2, 4, "BFu8i_F_L.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_L, BFu8i_F_L)
//============================================================================


struct  BFu8i_F_S  {
  unsigned int v1:8;
  float v2;
  short v3;
};
//SIG(1 BFu8i_F_S) C1{ Fi:8 Fi Fs}



static void Test_BFu8i_F_S()
{
  {
    init_simple_test("BFu8i_F_S");
    static STRUCT_IF_C BFu8i_F_S lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_S");
    check_field_offset(lv, v2, 4, "BFu8i_F_S.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_S, BFu8i_F_S)
//============================================================================


struct  BFu8i_F_Uc  {
  unsigned int v1:8;
  float v2;
  unsigned char v3;
};
//SIG(1 BFu8i_F_Uc) C1{ Fi:8 Fi Fc}



static void Test_BFu8i_F_Uc()
{
  {
    init_simple_test("BFu8i_F_Uc");
    static STRUCT_IF_C BFu8i_F_Uc lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_Uc");
    check_field_offset(lv, v2, 4, "BFu8i_F_Uc.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_Uc, BFu8i_F_Uc)
//============================================================================


struct  BFu8i_F_Ui  {
  unsigned int v1:8;
  float v2;
  unsigned int v3;
};
//SIG(1 BFu8i_F_Ui) C1{ Fi:8 Fi[2]}



static void Test_BFu8i_F_Ui()
{
  {
    init_simple_test("BFu8i_F_Ui");
    static STRUCT_IF_C BFu8i_F_Ui lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_Ui");
    check_field_offset(lv, v2, 4, "BFu8i_F_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_Ui, BFu8i_F_Ui)
//============================================================================


struct  BFu8i_F_Ul  {
  unsigned int v1:8;
  float v2;
  __tsu64 v3;
};
//SIG(1 BFu8i_F_Ul) C1{ Fi:8 Fi FL}



static void Test_BFu8i_F_Ul()
{
  {
    init_simple_test("BFu8i_F_Ul");
    static STRUCT_IF_C BFu8i_F_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_Ul");
    check_field_offset(lv, v2, 4, "BFu8i_F_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_Ul, BFu8i_F_Ul)
//============================================================================


struct  BFu8i_F_Us  {
  unsigned int v1:8;
  float v2;
  unsigned short v3;
};
//SIG(1 BFu8i_F_Us) C1{ Fi:8 Fi Fs}



static void Test_BFu8i_F_Us()
{
  {
    init_simple_test("BFu8i_F_Us");
    static STRUCT_IF_C BFu8i_F_Us lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_Us");
    check_field_offset(lv, v2, 4, "BFu8i_F_Us.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_Us, BFu8i_F_Us)
//============================================================================


struct  BFu8i_F_Vp  {
  unsigned int v1:8;
  float v2;
  void *v3;
};
//SIG(1 BFu8i_F_Vp) C1{ Fi:8 Fi Fp}



static void Test_BFu8i_F_Vp()
{
  {
    init_simple_test("BFu8i_F_Vp");
    static STRUCT_IF_C BFu8i_F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_F_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_Vp");
    check_field_offset(lv, v2, 4, "BFu8i_F_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_Vp, BFu8i_F_Vp)
//============================================================================


struct  BFu8i_I  {
  unsigned int v1:8;
  int v2;
};
//SIG(1 BFu8i_I) C1{ Fi:8 Fi}



static void Test_BFu8i_I()
{
  {
    init_simple_test("BFu8i_I");
    static STRUCT_IF_C BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I");
    check_field_offset(lv, v2, 4, "BFu8i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I, BFu8i_I)
//============================================================================


struct  BFu8i_I_BFu15i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:15;
};
//SIG(1 BFu8i_I_BFu15i) C1{ Fi:8 Fi Fi:15}



static void Test_BFu8i_I_BFu15i()
{
  {
    init_simple_test("BFu8i_I_BFu15i");
    static STRUCT_IF_C BFu8i_I_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu15i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu8i_I_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu8i_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu15i, BFu8i_I_BFu15i)
//============================================================================


struct  BFu8i_I_BFu15ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_I_BFu15ll) C1{ Fi:8 Fi FL:15}



static void Test_BFu8i_I_BFu15ll()
{
  {
    init_simple_test("BFu8i_I_BFu15ll");
    static STRUCT_IF_C BFu8i_I_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu8i_I_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu8i_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu15ll, BFu8i_I_BFu15ll)
//============================================================================


struct  BFu8i_I_BFu15s  {
  unsigned int v1:8;
  int v2;
  unsigned short v3:15;
};
//SIG(1 BFu8i_I_BFu15s) C1{ Fi:8 Fi Fs:15}



static void Test_BFu8i_I_BFu15s()
{
  {
    init_simple_test("BFu8i_I_BFu15s");
    static STRUCT_IF_C BFu8i_I_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu15s");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu8i_I_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu8i_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu15s, BFu8i_I_BFu15s)
//============================================================================


struct  BFu8i_I_BFu16i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:16;
};
//SIG(1 BFu8i_I_BFu16i) C1{ Fi:8 Fi Fi:16}



static void Test_BFu8i_I_BFu16i()
{
  {
    init_simple_test("BFu8i_I_BFu16i");
    static STRUCT_IF_C BFu8i_I_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu16i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu8i_I_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu8i_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu16i, BFu8i_I_BFu16i)
//============================================================================


struct  BFu8i_I_BFu16ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_I_BFu16ll) C1{ Fi:8 Fi FL:16}



static void Test_BFu8i_I_BFu16ll()
{
  {
    init_simple_test("BFu8i_I_BFu16ll");
    static STRUCT_IF_C BFu8i_I_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu8i_I_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu8i_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu16ll, BFu8i_I_BFu16ll)
//============================================================================


struct  BFu8i_I_BFu16s  {
  unsigned int v1:8;
  int v2;
  unsigned short v3:16;
};
//SIG(1 BFu8i_I_BFu16s) C1{ Fi:8 Fi Fs:16}



static void Test_BFu8i_I_BFu16s()
{
  {
    init_simple_test("BFu8i_I_BFu16s");
    static STRUCT_IF_C BFu8i_I_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu16s");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu8i_I_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu8i_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu16s, BFu8i_I_BFu16s)
//============================================================================


struct  BFu8i_I_BFu17i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:17;
};
//SIG(1 BFu8i_I_BFu17i) C1{ Fi:8 Fi Fi:17}



static void Test_BFu8i_I_BFu17i()
{
  {
    init_simple_test("BFu8i_I_BFu17i");
    static STRUCT_IF_C BFu8i_I_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu17i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu8i_I_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu8i_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu17i, BFu8i_I_BFu17i)
//============================================================================


struct  BFu8i_I_BFu17ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_I_BFu17ll) C1{ Fi:8 Fi FL:17}



static void Test_BFu8i_I_BFu17ll()
{
  {
    init_simple_test("BFu8i_I_BFu17ll");
    static STRUCT_IF_C BFu8i_I_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu8i_I_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu8i_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu17ll, BFu8i_I_BFu17ll)
//============================================================================


struct  BFu8i_I_BFu1c  {
  unsigned int v1:8;
  int v2;
  unsigned char v3:1;
};
//SIG(1 BFu8i_I_BFu1c) C1{ Fi:8 Fi Fc:1}



static void Test_BFu8i_I_BFu1c()
{
  {
    init_simple_test("BFu8i_I_BFu1c");
    static STRUCT_IF_C BFu8i_I_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu1c");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu8i_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu1c, BFu8i_I_BFu1c)
//============================================================================


struct  BFu8i_I_BFu1i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:1;
};
//SIG(1 BFu8i_I_BFu1i) C1{ Fi:8 Fi Fi:1}



static void Test_BFu8i_I_BFu1i()
{
  {
    init_simple_test("BFu8i_I_BFu1i");
    static STRUCT_IF_C BFu8i_I_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu1i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu8i_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu1i, BFu8i_I_BFu1i)
//============================================================================


struct  BFu8i_I_BFu1ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_I_BFu1ll) C1{ Fi:8 Fi FL:1}



static void Test_BFu8i_I_BFu1ll()
{
  {
    init_simple_test("BFu8i_I_BFu1ll");
    static STRUCT_IF_C BFu8i_I_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu8i_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu1ll, BFu8i_I_BFu1ll)
//============================================================================


struct  BFu8i_I_BFu1s  {
  unsigned int v1:8;
  int v2;
  unsigned short v3:1;
};
//SIG(1 BFu8i_I_BFu1s) C1{ Fi:8 Fi Fs:1}



static void Test_BFu8i_I_BFu1s()
{
  {
    init_simple_test("BFu8i_I_BFu1s");
    static STRUCT_IF_C BFu8i_I_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu1s");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu8i_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu1s, BFu8i_I_BFu1s)
//============================================================================


struct  BFu8i_I_BFu31i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:31;
};
//SIG(1 BFu8i_I_BFu31i) C1{ Fi:8 Fi Fi:31}



static void Test_BFu8i_I_BFu31i()
{
  {
    init_simple_test("BFu8i_I_BFu31i");
    static STRUCT_IF_C BFu8i_I_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu31i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu8i_I_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu8i_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu31i, BFu8i_I_BFu31i)
//============================================================================


struct  BFu8i_I_BFu31ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_I_BFu31ll) C1{ Fi:8 Fi FL:31}



static void Test_BFu8i_I_BFu31ll()
{
  {
    init_simple_test("BFu8i_I_BFu31ll");
    static STRUCT_IF_C BFu8i_I_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu8i_I_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu8i_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu31ll, BFu8i_I_BFu31ll)
//============================================================================


struct  BFu8i_I_BFu32i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:32;
};
//SIG(1 BFu8i_I_BFu32i) C1{ Fi:8 Fi Fi:32}



static void Test_BFu8i_I_BFu32i()
{
  {
    init_simple_test("BFu8i_I_BFu32i");
    static STRUCT_IF_C BFu8i_I_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu32i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu8i_I_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu8i_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu32i, BFu8i_I_BFu32i)
//============================================================================


struct  BFu8i_I_BFu32ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_I_BFu32ll) C1{ Fi:8 Fi FL:32}



static void Test_BFu8i_I_BFu32ll()
{
  {
    init_simple_test("BFu8i_I_BFu32ll");
    static STRUCT_IF_C BFu8i_I_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu8i_I_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu8i_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu32ll, BFu8i_I_BFu32ll)
//============================================================================


struct  BFu8i_I_BFu33  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_I_BFu33) C1{ Fi:8 Fi FL:33}



static void Test_BFu8i_I_BFu33()
{
  {
    init_simple_test("BFu8i_I_BFu33");
    static STRUCT_IF_C BFu8i_I_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu33");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "BFu8i_I_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "BFu8i_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu33, BFu8i_I_BFu33)
//============================================================================


struct  BFu8i_I_BFu7c  {
  unsigned int v1:8;
  int v2;
  unsigned char v3:7;
};
//SIG(1 BFu8i_I_BFu7c) C1{ Fi:8 Fi Fc:7}



static void Test_BFu8i_I_BFu7c()
{
  {
    init_simple_test("BFu8i_I_BFu7c");
    static STRUCT_IF_C BFu8i_I_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu7c");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu8i_I_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu8i_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu7c, BFu8i_I_BFu7c)
//============================================================================


struct  BFu8i_I_BFu7i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:7;
};
//SIG(1 BFu8i_I_BFu7i) C1{ Fi:8 Fi Fi:7}



static void Test_BFu8i_I_BFu7i()
{
  {
    init_simple_test("BFu8i_I_BFu7i");
    static STRUCT_IF_C BFu8i_I_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu7i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu8i_I_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu8i_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu7i, BFu8i_I_BFu7i)
//============================================================================


struct  BFu8i_I_BFu7ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_I_BFu7ll) C1{ Fi:8 Fi FL:7}



static void Test_BFu8i_I_BFu7ll()
{
  {
    init_simple_test("BFu8i_I_BFu7ll");
    static STRUCT_IF_C BFu8i_I_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu8i_I_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu8i_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu7ll, BFu8i_I_BFu7ll)
//============================================================================


struct  BFu8i_I_BFu7s  {
  unsigned int v1:8;
  int v2;
  unsigned short v3:7;
};
//SIG(1 BFu8i_I_BFu7s) C1{ Fi:8 Fi Fs:7}



static void Test_BFu8i_I_BFu7s()
{
  {
    init_simple_test("BFu8i_I_BFu7s");
    static STRUCT_IF_C BFu8i_I_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu7s");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu8i_I_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu8i_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu7s, BFu8i_I_BFu7s)
//============================================================================


struct  BFu8i_I_BFu8c  {
  unsigned int v1:8;
  int v2;
  unsigned char v3:8;
};
//SIG(1 BFu8i_I_BFu8c) C1{ Fi:8 Fi Fc:8}



static void Test_BFu8i_I_BFu8c()
{
  {
    init_simple_test("BFu8i_I_BFu8c");
    static STRUCT_IF_C BFu8i_I_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu8c");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu8i_I_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu8c, BFu8i_I_BFu8c)
//============================================================================


struct  BFu8i_I_BFu8i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:8;
};
//SIG(1 BFu8i_I_BFu8i) C1{ Fi:8 Fi Fi:8}



static void Test_BFu8i_I_BFu8i()
{
  {
    init_simple_test("BFu8i_I_BFu8i");
    static STRUCT_IF_C BFu8i_I_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu8i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu8i_I_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu8i, BFu8i_I_BFu8i)
//============================================================================


struct  BFu8i_I_BFu8ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_I_BFu8ll) C1{ Fi:8 Fi FL:8}



static void Test_BFu8i_I_BFu8ll()
{
  {
    init_simple_test("BFu8i_I_BFu8ll");
    static STRUCT_IF_C BFu8i_I_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu8i_I_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu8ll, BFu8i_I_BFu8ll)
//============================================================================


struct  BFu8i_I_BFu8s  {
  unsigned int v1:8;
  int v2;
  unsigned short v3:8;
};
//SIG(1 BFu8i_I_BFu8s) C1{ Fi:8 Fi Fs:8}



static void Test_BFu8i_I_BFu8s()
{
  {
    init_simple_test("BFu8i_I_BFu8s");
    static STRUCT_IF_C BFu8i_I_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu8s");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu8i_I_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu8s, BFu8i_I_BFu8s)
//============================================================================


struct  BFu8i_I_BFu9i  {
  unsigned int v1:8;
  int v2;
  unsigned int v3:9;
};
//SIG(1 BFu8i_I_BFu9i) C1{ Fi:8 Fi Fi:9}



static void Test_BFu8i_I_BFu9i()
{
  {
    init_simple_test("BFu8i_I_BFu9i");
    static STRUCT_IF_C BFu8i_I_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu9i");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu8i_I_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu8i_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu9i, BFu8i_I_BFu9i)
//============================================================================


struct  BFu8i_I_BFu9ll  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_I_BFu9ll) C1{ Fi:8 Fi FL:9}



static void Test_BFu8i_I_BFu9ll()
{
  {
    init_simple_test("BFu8i_I_BFu9ll");
    static STRUCT_IF_C BFu8i_I_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu8i_I_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu8i_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu9ll, BFu8i_I_BFu9ll)
//============================================================================


struct  BFu8i_I_BFu9s  {
  unsigned int v1:8;
  int v2;
  unsigned short v3:9;
};
//SIG(1 BFu8i_I_BFu9s) C1{ Fi:8 Fi Fs:9}



static void Test_BFu8i_I_BFu9s()
{
  {
    init_simple_test("BFu8i_I_BFu9s");
    static STRUCT_IF_C BFu8i_I_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_BFu9s");
    check_field_offset(lv, v2, 4, "BFu8i_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu8i_I_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu8i_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_BFu9s, BFu8i_I_BFu9s)
//============================================================================


struct  BFu8i_I_C  {
  unsigned int v1:8;
  int v2;
  char v3;
};
//SIG(1 BFu8i_I_C) C1{ Fi:8 Fi Fc}



static void Test_BFu8i_I_C()
{
  {
    init_simple_test("BFu8i_I_C");
    static STRUCT_IF_C BFu8i_I_C lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_C");
    check_field_offset(lv, v2, 4, "BFu8i_I_C.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_C, BFu8i_I_C)
//============================================================================


struct  BFu8i_I_D  {
  unsigned int v1:8;
  int v2;
  double v3;
};
//SIG(1 BFu8i_I_D) C1{ Fi:8 Fi FL}



static void Test_BFu8i_I_D()
{
  {
    init_simple_test("BFu8i_I_D");
    static STRUCT_IF_C BFu8i_I_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_D");
    check_field_offset(lv, v2, 4, "BFu8i_I_D.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_D, BFu8i_I_D)
//============================================================================


struct  BFu8i_I_F  {
  unsigned int v1:8;
  int v2;
  float v3;
};
//SIG(1 BFu8i_I_F) C1{ Fi:8 Fi[2]}



static void Test_BFu8i_I_F()
{
  {
    init_simple_test("BFu8i_I_F");
    static STRUCT_IF_C BFu8i_I_F lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_F");
    check_field_offset(lv, v2, 4, "BFu8i_I_F.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_F, BFu8i_I_F)
//============================================================================


struct  BFu8i_I_I  {
  unsigned int v1:8;
  int v2;
  int v3;
};
//SIG(1 BFu8i_I_I) C1{ Fi:8 Fi[2]}



static void Test_BFu8i_I_I()
{
  {
    init_simple_test("BFu8i_I_I");
    static STRUCT_IF_C BFu8i_I_I lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_I");
    check_field_offset(lv, v2, 4, "BFu8i_I_I.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_I, BFu8i_I_I)
//============================================================================


struct  BFu8i_I_Ip  {
  unsigned int v1:8;
  int v2;
  int *v3;
};
//SIG(1 BFu8i_I_Ip) C1{ Fi:8 Fi Fp}



static void Test_BFu8i_I_Ip()
{
  {
    init_simple_test("BFu8i_I_Ip");
    static STRUCT_IF_C BFu8i_I_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_Ip");
    check_field_offset(lv, v2, 4, "BFu8i_I_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_Ip, BFu8i_I_Ip)
//============================================================================


struct  BFu8i_I_L  {
  unsigned int v1:8;
  int v2;
  __tsi64 v3;
};
//SIG(1 BFu8i_I_L) C1{ Fi:8 Fi FL}



static void Test_BFu8i_I_L()
{
  {
    init_simple_test("BFu8i_I_L");
    static STRUCT_IF_C BFu8i_I_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_L");
    check_field_offset(lv, v2, 4, "BFu8i_I_L.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_L, BFu8i_I_L)
//============================================================================


struct  BFu8i_I_S  {
  unsigned int v1:8;
  int v2;
  short v3;
};
//SIG(1 BFu8i_I_S) C1{ Fi:8 Fi Fs}



static void Test_BFu8i_I_S()
{
  {
    init_simple_test("BFu8i_I_S");
    static STRUCT_IF_C BFu8i_I_S lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_S");
    check_field_offset(lv, v2, 4, "BFu8i_I_S.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_S, BFu8i_I_S)
//============================================================================


struct  BFu8i_I_Uc  {
  unsigned int v1:8;
  int v2;
  unsigned char v3;
};
//SIG(1 BFu8i_I_Uc) C1{ Fi:8 Fi Fc}



static void Test_BFu8i_I_Uc()
{
  {
    init_simple_test("BFu8i_I_Uc");
    static STRUCT_IF_C BFu8i_I_Uc lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_Uc");
    check_field_offset(lv, v2, 4, "BFu8i_I_Uc.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_Uc, BFu8i_I_Uc)
//============================================================================


struct  BFu8i_I_Ui  {
  unsigned int v1:8;
  int v2;
  unsigned int v3;
};
//SIG(1 BFu8i_I_Ui) C1{ Fi:8 Fi[2]}



static void Test_BFu8i_I_Ui()
{
  {
    init_simple_test("BFu8i_I_Ui");
    static STRUCT_IF_C BFu8i_I_Ui lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_Ui");
    check_field_offset(lv, v2, 4, "BFu8i_I_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_Ui, BFu8i_I_Ui)
//============================================================================


struct  BFu8i_I_Ul  {
  unsigned int v1:8;
  int v2;
  __tsu64 v3;
};
//SIG(1 BFu8i_I_Ul) C1{ Fi:8 Fi FL}



static void Test_BFu8i_I_Ul()
{
  {
    init_simple_test("BFu8i_I_Ul");
    static STRUCT_IF_C BFu8i_I_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu8i_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_Ul");
    check_field_offset(lv, v2, 4, "BFu8i_I_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_Ul, BFu8i_I_Ul)
//============================================================================


struct  BFu8i_I_Us  {
  unsigned int v1:8;
  int v2;
  unsigned short v3;
};
//SIG(1 BFu8i_I_Us) C1{ Fi:8 Fi Fs}



static void Test_BFu8i_I_Us()
{
  {
    init_simple_test("BFu8i_I_Us");
    static STRUCT_IF_C BFu8i_I_Us lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_Us");
    check_field_offset(lv, v2, 4, "BFu8i_I_Us.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_Us, BFu8i_I_Us)
//============================================================================


struct  BFu8i_I_Vp  {
  unsigned int v1:8;
  int v2;
  void *v3;
};
//SIG(1 BFu8i_I_Vp) C1{ Fi:8 Fi Fp}



static void Test_BFu8i_I_Vp()
{
  {
    init_simple_test("BFu8i_I_Vp");
    static STRUCT_IF_C BFu8i_I_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_I_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_Vp");
    check_field_offset(lv, v2, 4, "BFu8i_I_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_Vp, BFu8i_I_Vp)
//============================================================================


struct  BFu8i_Ip  {
  unsigned int v1:8;
  int *v2;
};
//SIG(1 BFu8i_Ip) C1{ Fi:8 Fp}



static void Test_BFu8i_Ip()
{
  {
    init_simple_test("BFu8i_Ip");
    static STRUCT_IF_C BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip, BFu8i_Ip)
//============================================================================


struct  BFu8i_Ip_BFu15i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:15;
};
//SIG(1 BFu8i_Ip_BFu15i) C1{ Fi:8 Fp Fi:15}



static void Test_BFu8i_Ip_BFu15i()
{
  {
    init_simple_test("BFu8i_Ip_BFu15i");
    static STRUCT_IF_C BFu8i_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu15i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu8i_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu8i_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu15i, BFu8i_Ip_BFu15i)
//============================================================================


struct  BFu8i_Ip_BFu15ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_Ip_BFu15ll) C1{ Fi:8 Fp FL:15}



static void Test_BFu8i_Ip_BFu15ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu15ll");
    static STRUCT_IF_C BFu8i_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu15ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu8i_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu8i_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu15ll, BFu8i_Ip_BFu15ll)
//============================================================================


struct  BFu8i_Ip_BFu15s  {
  unsigned int v1:8;
  int *v2;
  unsigned short v3:15;
};
//SIG(1 BFu8i_Ip_BFu15s) C1{ Fi:8 Fp Fs:15}



static void Test_BFu8i_Ip_BFu15s()
{
  {
    init_simple_test("BFu8i_Ip_BFu15s");
    static STRUCT_IF_C BFu8i_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu15s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu8i_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu8i_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu15s, BFu8i_Ip_BFu15s)
//============================================================================


struct  BFu8i_Ip_BFu16i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:16;
};
//SIG(1 BFu8i_Ip_BFu16i) C1{ Fi:8 Fp Fi:16}



static void Test_BFu8i_Ip_BFu16i()
{
  {
    init_simple_test("BFu8i_Ip_BFu16i");
    static STRUCT_IF_C BFu8i_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu16i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu8i_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu8i_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu16i, BFu8i_Ip_BFu16i)
//============================================================================


struct  BFu8i_Ip_BFu16ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_Ip_BFu16ll) C1{ Fi:8 Fp FL:16}



static void Test_BFu8i_Ip_BFu16ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu16ll");
    static STRUCT_IF_C BFu8i_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu16ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu8i_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu8i_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu16ll, BFu8i_Ip_BFu16ll)
//============================================================================


struct  BFu8i_Ip_BFu16s  {
  unsigned int v1:8;
  int *v2;
  unsigned short v3:16;
};
//SIG(1 BFu8i_Ip_BFu16s) C1{ Fi:8 Fp Fs:16}



static void Test_BFu8i_Ip_BFu16s()
{
  {
    init_simple_test("BFu8i_Ip_BFu16s");
    static STRUCT_IF_C BFu8i_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu16s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu8i_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu8i_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu16s, BFu8i_Ip_BFu16s)
//============================================================================


struct  BFu8i_Ip_BFu17i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:17;
};
//SIG(1 BFu8i_Ip_BFu17i) C1{ Fi:8 Fp Fi:17}



static void Test_BFu8i_Ip_BFu17i()
{
  {
    init_simple_test("BFu8i_Ip_BFu17i");
    static STRUCT_IF_C BFu8i_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu17i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "BFu8i_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "BFu8i_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu17i, BFu8i_Ip_BFu17i)
//============================================================================


struct  BFu8i_Ip_BFu17ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_Ip_BFu17ll) C1{ Fi:8 Fp FL:17}



static void Test_BFu8i_Ip_BFu17ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu17ll");
    static STRUCT_IF_C BFu8i_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu17ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "BFu8i_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "BFu8i_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu17ll, BFu8i_Ip_BFu17ll)
//============================================================================


struct  BFu8i_Ip_BFu1c  {
  unsigned int v1:8;
  int *v2;
  unsigned char v3:1;
};
//SIG(1 BFu8i_Ip_BFu1c) C1{ Fi:8 Fp Fc:1}



static void Test_BFu8i_Ip_BFu1c()
{
  {
    init_simple_test("BFu8i_Ip_BFu1c");
    static STRUCT_IF_C BFu8i_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu1c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu8i_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu1c, BFu8i_Ip_BFu1c)
//============================================================================


struct  BFu8i_Ip_BFu1i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:1;
};
//SIG(1 BFu8i_Ip_BFu1i) C1{ Fi:8 Fp Fi:1}



static void Test_BFu8i_Ip_BFu1i()
{
  {
    init_simple_test("BFu8i_Ip_BFu1i");
    static STRUCT_IF_C BFu8i_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu1i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu8i_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu1i, BFu8i_Ip_BFu1i)
//============================================================================


struct  BFu8i_Ip_BFu1ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_Ip_BFu1ll) C1{ Fi:8 Fp FL:1}



static void Test_BFu8i_Ip_BFu1ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu1ll");
    static STRUCT_IF_C BFu8i_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu1ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu8i_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu1ll, BFu8i_Ip_BFu1ll)
//============================================================================


struct  BFu8i_Ip_BFu1s  {
  unsigned int v1:8;
  int *v2;
  unsigned short v3:1;
};
//SIG(1 BFu8i_Ip_BFu1s) C1{ Fi:8 Fp Fs:1}



static void Test_BFu8i_Ip_BFu1s()
{
  {
    init_simple_test("BFu8i_Ip_BFu1s");
    static STRUCT_IF_C BFu8i_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu1s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu8i_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu1s, BFu8i_Ip_BFu1s)
//============================================================================


struct  BFu8i_Ip_BFu31i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:31;
};
//SIG(1 BFu8i_Ip_BFu31i) C1{ Fi:8 Fp Fi:31}



static void Test_BFu8i_Ip_BFu31i()
{
  {
    init_simple_test("BFu8i_Ip_BFu31i");
    static STRUCT_IF_C BFu8i_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu31i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "BFu8i_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "BFu8i_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu31i, BFu8i_Ip_BFu31i)
//============================================================================


struct  BFu8i_Ip_BFu31ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_Ip_BFu31ll) C1{ Fi:8 Fp FL:31}



static void Test_BFu8i_Ip_BFu31ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu31ll");
    static STRUCT_IF_C BFu8i_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu31ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "BFu8i_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "BFu8i_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu31ll, BFu8i_Ip_BFu31ll)
//============================================================================


struct  BFu8i_Ip_BFu32i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:32;
};
//SIG(1 BFu8i_Ip_BFu32i) C1{ Fi:8 Fp Fi:32}



static void Test_BFu8i_Ip_BFu32i()
{
  {
    init_simple_test("BFu8i_Ip_BFu32i");
    static STRUCT_IF_C BFu8i_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu32i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "BFu8i_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "BFu8i_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu32i, BFu8i_Ip_BFu32i)
//============================================================================


struct  BFu8i_Ip_BFu32ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_Ip_BFu32ll) C1{ Fi:8 Fp FL:32}



static void Test_BFu8i_Ip_BFu32ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu32ll");
    static STRUCT_IF_C BFu8i_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu32ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "BFu8i_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "BFu8i_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu32ll, BFu8i_Ip_BFu32ll)
//============================================================================


struct  BFu8i_Ip_BFu33  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_Ip_BFu33) C1{ Fi:8 Fp FL:33}



static void Test_BFu8i_Ip_BFu33()
{
  {
    init_simple_test("BFu8i_Ip_BFu33");
    static STRUCT_IF_C BFu8i_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu33");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "BFu8i_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "BFu8i_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu33, BFu8i_Ip_BFu33)
//============================================================================


struct  BFu8i_Ip_BFu7c  {
  unsigned int v1:8;
  int *v2;
  unsigned char v3:7;
};
//SIG(1 BFu8i_Ip_BFu7c) C1{ Fi:8 Fp Fc:7}



static void Test_BFu8i_Ip_BFu7c()
{
  {
    init_simple_test("BFu8i_Ip_BFu7c");
    static STRUCT_IF_C BFu8i_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu7c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu8i_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu8i_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu7c, BFu8i_Ip_BFu7c)
//============================================================================


struct  BFu8i_Ip_BFu7i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:7;
};
//SIG(1 BFu8i_Ip_BFu7i) C1{ Fi:8 Fp Fi:7}



static void Test_BFu8i_Ip_BFu7i()
{
  {
    init_simple_test("BFu8i_Ip_BFu7i");
    static STRUCT_IF_C BFu8i_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu7i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu8i_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu8i_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu7i, BFu8i_Ip_BFu7i)
//============================================================================


struct  BFu8i_Ip_BFu7ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_Ip_BFu7ll) C1{ Fi:8 Fp FL:7}



static void Test_BFu8i_Ip_BFu7ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu7ll");
    static STRUCT_IF_C BFu8i_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu7ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu8i_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu8i_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu7ll, BFu8i_Ip_BFu7ll)
//============================================================================


struct  BFu8i_Ip_BFu7s  {
  unsigned int v1:8;
  int *v2;
  unsigned short v3:7;
};
//SIG(1 BFu8i_Ip_BFu7s) C1{ Fi:8 Fp Fs:7}



static void Test_BFu8i_Ip_BFu7s()
{
  {
    init_simple_test("BFu8i_Ip_BFu7s");
    static STRUCT_IF_C BFu8i_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu7s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu8i_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu8i_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu7s, BFu8i_Ip_BFu7s)
//============================================================================


struct  BFu8i_Ip_BFu8c  {
  unsigned int v1:8;
  int *v2;
  unsigned char v3:8;
};
//SIG(1 BFu8i_Ip_BFu8c) C1{ Fi:8 Fp Fc:8}



static void Test_BFu8i_Ip_BFu8c()
{
  {
    init_simple_test("BFu8i_Ip_BFu8c");
    static STRUCT_IF_C BFu8i_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu8c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu8i_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu8c, BFu8i_Ip_BFu8c)
//============================================================================


struct  BFu8i_Ip_BFu8i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:8;
};
//SIG(1 BFu8i_Ip_BFu8i) C1{ Fi:8 Fp Fi:8}



static void Test_BFu8i_Ip_BFu8i()
{
  {
    init_simple_test("BFu8i_Ip_BFu8i");
    static STRUCT_IF_C BFu8i_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu8i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu8i_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu8i, BFu8i_Ip_BFu8i)
//============================================================================


struct  BFu8i_Ip_BFu8ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_Ip_BFu8ll) C1{ Fi:8 Fp FL:8}



static void Test_BFu8i_Ip_BFu8ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu8ll");
    static STRUCT_IF_C BFu8i_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu8ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu8i_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu8ll, BFu8i_Ip_BFu8ll)
//============================================================================


struct  BFu8i_Ip_BFu8s  {
  unsigned int v1:8;
  int *v2;
  unsigned short v3:8;
};
//SIG(1 BFu8i_Ip_BFu8s) C1{ Fi:8 Fp Fs:8}



static void Test_BFu8i_Ip_BFu8s()
{
  {
    init_simple_test("BFu8i_Ip_BFu8s");
    static STRUCT_IF_C BFu8i_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu8s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu8i_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu8s, BFu8i_Ip_BFu8s)
//============================================================================


struct  BFu8i_Ip_BFu9i  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3:9;
};
//SIG(1 BFu8i_Ip_BFu9i) C1{ Fi:8 Fp Fi:9}



static void Test_BFu8i_Ip_BFu9i()
{
  {
    init_simple_test("BFu8i_Ip_BFu9i");
    static STRUCT_IF_C BFu8i_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu9i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu8i_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu8i_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu9i, BFu8i_Ip_BFu9i)
//============================================================================


struct  BFu8i_Ip_BFu9ll  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_Ip_BFu9ll) C1{ Fi:8 Fp FL:9}



static void Test_BFu8i_Ip_BFu9ll()
{
  {
    init_simple_test("BFu8i_Ip_BFu9ll");
    static STRUCT_IF_C BFu8i_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu9ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu8i_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu8i_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu9ll, BFu8i_Ip_BFu9ll)
//============================================================================


struct  BFu8i_Ip_BFu9s  {
  unsigned int v1:8;
  int *v2;
  unsigned short v3:9;
};
//SIG(1 BFu8i_Ip_BFu9s) C1{ Fi:8 Fp Fs:9}



static void Test_BFu8i_Ip_BFu9s()
{
  {
    init_simple_test("BFu8i_Ip_BFu9s");
    static STRUCT_IF_C BFu8i_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_BFu9s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu8i_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu8i_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_BFu9s, BFu8i_Ip_BFu9s)
//============================================================================


struct  BFu8i_Ip_C  {
  unsigned int v1:8;
  int *v2;
  char v3;
};
//SIG(1 BFu8i_Ip_C) C1{ Fi:8 Fp Fc}



static void Test_BFu8i_Ip_C()
{
  {
    init_simple_test("BFu8i_Ip_C");
    static STRUCT_IF_C BFu8i_Ip_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_C, BFu8i_Ip_C)
//============================================================================


struct  BFu8i_Ip_D  {
  unsigned int v1:8;
  int *v2;
  double v3;
};
//SIG(1 BFu8i_Ip_D) C1{ Fi:8 Fp FL}



static void Test_BFu8i_Ip_D()
{
  {
    init_simple_test("BFu8i_Ip_D");
    static STRUCT_IF_C BFu8i_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_D, BFu8i_Ip_D)
//============================================================================


struct  BFu8i_Ip_F  {
  unsigned int v1:8;
  int *v2;
  float v3;
};
//SIG(1 BFu8i_Ip_F) C1{ Fi:8 Fp Fi}



static void Test_BFu8i_Ip_F()
{
  {
    init_simple_test("BFu8i_Ip_F");
    static STRUCT_IF_C BFu8i_Ip_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_F, BFu8i_Ip_F)
//============================================================================


struct  BFu8i_Ip_I  {
  unsigned int v1:8;
  int *v2;
  int v3;
};
//SIG(1 BFu8i_Ip_I) C1{ Fi:8 Fp Fi}



static void Test_BFu8i_Ip_I()
{
  {
    init_simple_test("BFu8i_Ip_I");
    static STRUCT_IF_C BFu8i_Ip_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_I, BFu8i_Ip_I)
//============================================================================


struct  BFu8i_Ip_Ip  {
  unsigned int v1:8;
  int *v2;
  int *v3;
};
//SIG(1 BFu8i_Ip_Ip) C1{ Fi:8 Fp[2]}



static void Test_BFu8i_Ip_Ip()
{
  {
    init_simple_test("BFu8i_Ip_Ip");
    static STRUCT_IF_C BFu8i_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_Ip, BFu8i_Ip_Ip)
//============================================================================


struct  BFu8i_Ip_L  {
  unsigned int v1:8;
  int *v2;
  __tsi64 v3;
};
//SIG(1 BFu8i_Ip_L) C1{ Fi:8 Fp FL}



static void Test_BFu8i_Ip_L()
{
  {
    init_simple_test("BFu8i_Ip_L");
    static STRUCT_IF_C BFu8i_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_Ip_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_L, BFu8i_Ip_L)
//============================================================================


struct  BFu8i_Ip_S  {
  unsigned int v1:8;
  int *v2;
  short v3;
};
//SIG(1 BFu8i_Ip_S) C1{ Fi:8 Fp Fs}



static void Test_BFu8i_Ip_S()
{
  {
    init_simple_test("BFu8i_Ip_S");
    static STRUCT_IF_C BFu8i_Ip_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_S, BFu8i_Ip_S)
//============================================================================


struct  BFu8i_Ip_Uc  {
  unsigned int v1:8;
  int *v2;
  unsigned char v3;
};
//SIG(1 BFu8i_Ip_Uc) C1{ Fi:8 Fp Fc}



static void Test_BFu8i_Ip_Uc()
{
  {
    init_simple_test("BFu8i_Ip_Uc");
    static STRUCT_IF_C BFu8i_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_Uc, BFu8i_Ip_Uc)
//============================================================================


struct  BFu8i_Ip_Ui  {
  unsigned int v1:8;
  int *v2;
  unsigned int v3;
};
//SIG(1 BFu8i_Ip_Ui) C1{ Fi:8 Fp Fi}



static void Test_BFu8i_Ip_Ui()
{
  {
    init_simple_test("BFu8i_Ip_Ui");
    static STRUCT_IF_C BFu8i_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_Ui, BFu8i_Ip_Ui)
//============================================================================


struct  BFu8i_Ip_Ul  {
  unsigned int v1:8;
  int *v2;
  __tsu64 v3;
};
//SIG(1 BFu8i_Ip_Ul) C1{ Fi:8 Fp FL}



static void Test_BFu8i_Ip_Ul()
{
  {
    init_simple_test("BFu8i_Ip_Ul");
    static STRUCT_IF_C BFu8i_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_Ip_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_Ul, BFu8i_Ip_Ul)
//============================================================================


struct  BFu8i_Ip_Us  {
  unsigned int v1:8;
  int *v2;
  unsigned short v3;
};
//SIG(1 BFu8i_Ip_Us) C1{ Fi:8 Fp Fs}



static void Test_BFu8i_Ip_Us()
{
  {
    init_simple_test("BFu8i_Ip_Us");
    static STRUCT_IF_C BFu8i_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_Us, BFu8i_Ip_Us)
//============================================================================


struct  BFu8i_Ip_Vp  {
  unsigned int v1:8;
  int *v2;
  void *v3;
};
//SIG(1 BFu8i_Ip_Vp) C1{ Fi:8 Fp[2]}



static void Test_BFu8i_Ip_Vp()
{
  {
    init_simple_test("BFu8i_Ip_Vp");
    static STRUCT_IF_C BFu8i_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_Vp, BFu8i_Ip_Vp)
//============================================================================


struct  BFu8i_L  {
  unsigned int v1:8;
  __tsi64 v2;
};
//SIG(1 BFu8i_L) C1{ Fi:8 FL}



static void Test_BFu8i_L()
{
  {
    init_simple_test("BFu8i_L");
    static STRUCT_IF_C BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L, BFu8i_L)
//============================================================================


struct  BFu8i_L_BFu15i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:15;
};
//SIG(1 BFu8i_L_BFu15i) C1{ Fi:8 FL Fi:15}



static void Test_BFu8i_L_BFu15i()
{
  {
    init_simple_test("BFu8i_L_BFu15i");
    static STRUCT_IF_C BFu8i_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu15i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu8i_L_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu8i_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu15i, BFu8i_L_BFu15i)
//============================================================================


struct  BFu8i_L_BFu15ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_L_BFu15ll) C1{ Fi:8 FL FL:15}



static void Test_BFu8i_L_BFu15ll()
{
  {
    init_simple_test("BFu8i_L_BFu15ll");
    static STRUCT_IF_C BFu8i_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu15ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu8i_L_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu8i_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu15ll, BFu8i_L_BFu15ll)
//============================================================================


struct  BFu8i_L_BFu15s  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned short v3:15;
};
//SIG(1 BFu8i_L_BFu15s) C1{ Fi:8 FL Fs:15}



static void Test_BFu8i_L_BFu15s()
{
  {
    init_simple_test("BFu8i_L_BFu15s");
    static STRUCT_IF_C BFu8i_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu15s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu8i_L_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu8i_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu15s, BFu8i_L_BFu15s)
//============================================================================


struct  BFu8i_L_BFu16i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:16;
};
//SIG(1 BFu8i_L_BFu16i) C1{ Fi:8 FL Fi:16}



static void Test_BFu8i_L_BFu16i()
{
  {
    init_simple_test("BFu8i_L_BFu16i");
    static STRUCT_IF_C BFu8i_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu16i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu8i_L_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu8i_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu16i, BFu8i_L_BFu16i)
//============================================================================


struct  BFu8i_L_BFu16ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_L_BFu16ll) C1{ Fi:8 FL FL:16}



static void Test_BFu8i_L_BFu16ll()
{
  {
    init_simple_test("BFu8i_L_BFu16ll");
    static STRUCT_IF_C BFu8i_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu16ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu8i_L_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu8i_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu16ll, BFu8i_L_BFu16ll)
//============================================================================


struct  BFu8i_L_BFu16s  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned short v3:16;
};
//SIG(1 BFu8i_L_BFu16s) C1{ Fi:8 FL Fs:16}



static void Test_BFu8i_L_BFu16s()
{
  {
    init_simple_test("BFu8i_L_BFu16s");
    static STRUCT_IF_C BFu8i_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu16s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu8i_L_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu8i_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu16s, BFu8i_L_BFu16s)
//============================================================================


struct  BFu8i_L_BFu17i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:17;
};
//SIG(1 BFu8i_L_BFu17i) C1{ Fi:8 FL Fi:17}



static void Test_BFu8i_L_BFu17i()
{
  {
    init_simple_test("BFu8i_L_BFu17i");
    static STRUCT_IF_C BFu8i_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu17i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu8i_L_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu8i_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu17i, BFu8i_L_BFu17i)
//============================================================================


struct  BFu8i_L_BFu17ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_L_BFu17ll) C1{ Fi:8 FL FL:17}



static void Test_BFu8i_L_BFu17ll()
{
  {
    init_simple_test("BFu8i_L_BFu17ll");
    static STRUCT_IF_C BFu8i_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu17ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu8i_L_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu8i_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu17ll, BFu8i_L_BFu17ll)
//============================================================================


struct  BFu8i_L_BFu1c  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned char v3:1;
};
//SIG(1 BFu8i_L_BFu1c) C1{ Fi:8 FL Fc:1}



static void Test_BFu8i_L_BFu1c()
{
  {
    init_simple_test("BFu8i_L_BFu1c");
    static STRUCT_IF_C BFu8i_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu1c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu8i_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu1c, BFu8i_L_BFu1c)
//============================================================================


struct  BFu8i_L_BFu1i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:1;
};
//SIG(1 BFu8i_L_BFu1i) C1{ Fi:8 FL Fi:1}



static void Test_BFu8i_L_BFu1i()
{
  {
    init_simple_test("BFu8i_L_BFu1i");
    static STRUCT_IF_C BFu8i_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu1i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu8i_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu1i, BFu8i_L_BFu1i)
//============================================================================


struct  BFu8i_L_BFu1ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_L_BFu1ll) C1{ Fi:8 FL FL:1}



static void Test_BFu8i_L_BFu1ll()
{
  {
    init_simple_test("BFu8i_L_BFu1ll");
    static STRUCT_IF_C BFu8i_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu1ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu8i_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu1ll, BFu8i_L_BFu1ll)
//============================================================================


struct  BFu8i_L_BFu1s  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned short v3:1;
};
//SIG(1 BFu8i_L_BFu1s) C1{ Fi:8 FL Fs:1}



static void Test_BFu8i_L_BFu1s()
{
  {
    init_simple_test("BFu8i_L_BFu1s");
    static STRUCT_IF_C BFu8i_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu1s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu8i_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu1s, BFu8i_L_BFu1s)
//============================================================================


struct  BFu8i_L_BFu31i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:31;
};
//SIG(1 BFu8i_L_BFu31i) C1{ Fi:8 FL Fi:31}



static void Test_BFu8i_L_BFu31i()
{
  {
    init_simple_test("BFu8i_L_BFu31i");
    static STRUCT_IF_C BFu8i_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu31i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu8i_L_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu8i_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu31i, BFu8i_L_BFu31i)
//============================================================================


struct  BFu8i_L_BFu31ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_L_BFu31ll) C1{ Fi:8 FL FL:31}



static void Test_BFu8i_L_BFu31ll()
{
  {
    init_simple_test("BFu8i_L_BFu31ll");
    static STRUCT_IF_C BFu8i_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu31ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu8i_L_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu8i_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu31ll, BFu8i_L_BFu31ll)
//============================================================================


struct  BFu8i_L_BFu32i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:32;
};
//SIG(1 BFu8i_L_BFu32i) C1{ Fi:8 FL Fi:32}



static void Test_BFu8i_L_BFu32i()
{
  {
    init_simple_test("BFu8i_L_BFu32i");
    static STRUCT_IF_C BFu8i_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu32i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu8i_L_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu8i_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu32i, BFu8i_L_BFu32i)
//============================================================================


struct  BFu8i_L_BFu32ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_L_BFu32ll) C1{ Fi:8 FL FL:32}



static void Test_BFu8i_L_BFu32ll()
{
  {
    init_simple_test("BFu8i_L_BFu32ll");
    static STRUCT_IF_C BFu8i_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu32ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu8i_L_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu8i_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu32ll, BFu8i_L_BFu32ll)
//============================================================================


struct  BFu8i_L_BFu33  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_L_BFu33) C1{ Fi:8 FL FL:33}



static void Test_BFu8i_L_BFu33()
{
  {
    init_simple_test("BFu8i_L_BFu33");
    static STRUCT_IF_C BFu8i_L_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu8i_L_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu33");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "BFu8i_L_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "BFu8i_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu33, BFu8i_L_BFu33)
//============================================================================


struct  BFu8i_L_BFu7c  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned char v3:7;
};
//SIG(1 BFu8i_L_BFu7c) C1{ Fi:8 FL Fc:7}



static void Test_BFu8i_L_BFu7c()
{
  {
    init_simple_test("BFu8i_L_BFu7c");
    static STRUCT_IF_C BFu8i_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu7c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu8i_L_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu8i_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu7c, BFu8i_L_BFu7c)
//============================================================================


struct  BFu8i_L_BFu7i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:7;
};
//SIG(1 BFu8i_L_BFu7i) C1{ Fi:8 FL Fi:7}



static void Test_BFu8i_L_BFu7i()
{
  {
    init_simple_test("BFu8i_L_BFu7i");
    static STRUCT_IF_C BFu8i_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu7i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu8i_L_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu8i_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu7i, BFu8i_L_BFu7i)
//============================================================================


struct  BFu8i_L_BFu7ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_L_BFu7ll) C1{ Fi:8 FL FL:7}



static void Test_BFu8i_L_BFu7ll()
{
  {
    init_simple_test("BFu8i_L_BFu7ll");
    static STRUCT_IF_C BFu8i_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu7ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu8i_L_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu8i_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu7ll, BFu8i_L_BFu7ll)
//============================================================================


struct  BFu8i_L_BFu7s  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned short v3:7;
};
//SIG(1 BFu8i_L_BFu7s) C1{ Fi:8 FL Fs:7}



static void Test_BFu8i_L_BFu7s()
{
  {
    init_simple_test("BFu8i_L_BFu7s");
    static STRUCT_IF_C BFu8i_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu7s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu8i_L_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu8i_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu7s, BFu8i_L_BFu7s)
//============================================================================


struct  BFu8i_L_BFu8c  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned char v3:8;
};
//SIG(1 BFu8i_L_BFu8c) C1{ Fi:8 FL Fc:8}



static void Test_BFu8i_L_BFu8c()
{
  {
    init_simple_test("BFu8i_L_BFu8c");
    static STRUCT_IF_C BFu8i_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu8c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu8i_L_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu8c, BFu8i_L_BFu8c)
//============================================================================


struct  BFu8i_L_BFu8i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:8;
};
//SIG(1 BFu8i_L_BFu8i) C1{ Fi:8 FL Fi:8}



static void Test_BFu8i_L_BFu8i()
{
  {
    init_simple_test("BFu8i_L_BFu8i");
    static STRUCT_IF_C BFu8i_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu8i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu8i_L_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu8i, BFu8i_L_BFu8i)
//============================================================================


struct  BFu8i_L_BFu8ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_L_BFu8ll) C1{ Fi:8 FL FL:8}



static void Test_BFu8i_L_BFu8ll()
{
  {
    init_simple_test("BFu8i_L_BFu8ll");
    static STRUCT_IF_C BFu8i_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu8ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu8i_L_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu8ll, BFu8i_L_BFu8ll)
//============================================================================


struct  BFu8i_L_BFu8s  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned short v3:8;
};
//SIG(1 BFu8i_L_BFu8s) C1{ Fi:8 FL Fs:8}



static void Test_BFu8i_L_BFu8s()
{
  {
    init_simple_test("BFu8i_L_BFu8s");
    static STRUCT_IF_C BFu8i_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu8s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu8i_L_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu8s, BFu8i_L_BFu8s)
//============================================================================


struct  BFu8i_L_BFu9i  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3:9;
};
//SIG(1 BFu8i_L_BFu9i) C1{ Fi:8 FL Fi:9}



static void Test_BFu8i_L_BFu9i()
{
  {
    init_simple_test("BFu8i_L_BFu9i");
    static STRUCT_IF_C BFu8i_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu9i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu8i_L_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu8i_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu9i, BFu8i_L_BFu9i)
//============================================================================


struct  BFu8i_L_BFu9ll  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_L_BFu9ll) C1{ Fi:8 FL FL:9}



static void Test_BFu8i_L_BFu9ll()
{
  {
    init_simple_test("BFu8i_L_BFu9ll");
    static STRUCT_IF_C BFu8i_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu9ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu8i_L_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu8i_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu9ll, BFu8i_L_BFu9ll)
//============================================================================


struct  BFu8i_L_BFu9s  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned short v3:9;
};
//SIG(1 BFu8i_L_BFu9s) C1{ Fi:8 FL Fs:9}



static void Test_BFu8i_L_BFu9s()
{
  {
    init_simple_test("BFu8i_L_BFu9s");
    static STRUCT_IF_C BFu8i_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_BFu9s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu8i_L_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu8i_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_BFu9s, BFu8i_L_BFu9s)
//============================================================================


struct  BFu8i_L_C  {
  unsigned int v1:8;
  __tsi64 v2;
  char v3;
};
//SIG(1 BFu8i_L_C) C1{ Fi:8 FL Fc}



static void Test_BFu8i_L_C()
{
  {
    init_simple_test("BFu8i_L_C");
    static STRUCT_IF_C BFu8i_L_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_C, BFu8i_L_C)
//============================================================================


struct  BFu8i_L_D  {
  unsigned int v1:8;
  __tsi64 v2;
  double v3;
};
//SIG(1 BFu8i_L_D) C1{ Fi:8 FL[2]}



static void Test_BFu8i_L_D()
{
  {
    init_simple_test("BFu8i_L_D");
    static STRUCT_IF_C BFu8i_L_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu8i_L_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_D, BFu8i_L_D)
//============================================================================


struct  BFu8i_L_F  {
  unsigned int v1:8;
  __tsi64 v2;
  float v3;
};
//SIG(1 BFu8i_L_F) C1{ Fi:8 FL Fi}



static void Test_BFu8i_L_F()
{
  {
    init_simple_test("BFu8i_L_F");
    static STRUCT_IF_C BFu8i_L_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_F, BFu8i_L_F)
//============================================================================


struct  BFu8i_L_I  {
  unsigned int v1:8;
  __tsi64 v2;
  int v3;
};
//SIG(1 BFu8i_L_I) C1{ Fi:8 FL Fi}



static void Test_BFu8i_L_I()
{
  {
    init_simple_test("BFu8i_L_I");
    static STRUCT_IF_C BFu8i_L_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_I, BFu8i_L_I)
//============================================================================


struct  BFu8i_L_Ip  {
  unsigned int v1:8;
  __tsi64 v2;
  int *v3;
};
//SIG(1 BFu8i_L_Ip) C1{ Fi:8 FL Fp}



static void Test_BFu8i_L_Ip()
{
  {
    init_simple_test("BFu8i_L_Ip");
    static STRUCT_IF_C BFu8i_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_Ip, BFu8i_L_Ip)
//============================================================================


struct  BFu8i_L_L  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsi64 v3;
};
//SIG(1 BFu8i_L_L) C1{ Fi:8 FL[2]}



static void Test_BFu8i_L_L()
{
  {
    init_simple_test("BFu8i_L_L");
    static STRUCT_IF_C BFu8i_L_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu8i_L_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_L, BFu8i_L_L)
//============================================================================


struct  BFu8i_L_S  {
  unsigned int v1:8;
  __tsi64 v2;
  short v3;
};
//SIG(1 BFu8i_L_S) C1{ Fi:8 FL Fs}



static void Test_BFu8i_L_S()
{
  {
    init_simple_test("BFu8i_L_S");
    static STRUCT_IF_C BFu8i_L_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_S, BFu8i_L_S)
//============================================================================


struct  BFu8i_L_Uc  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned char v3;
};
//SIG(1 BFu8i_L_Uc) C1{ Fi:8 FL Fc}



static void Test_BFu8i_L_Uc()
{
  {
    init_simple_test("BFu8i_L_Uc");
    static STRUCT_IF_C BFu8i_L_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_Uc, BFu8i_L_Uc)
//============================================================================


struct  BFu8i_L_Ui  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned int v3;
};
//SIG(1 BFu8i_L_Ui) C1{ Fi:8 FL Fi}



static void Test_BFu8i_L_Ui()
{
  {
    init_simple_test("BFu8i_L_Ui");
    static STRUCT_IF_C BFu8i_L_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_Ui, BFu8i_L_Ui)
//============================================================================


struct  BFu8i_L_Ul  {
  unsigned int v1:8;
  __tsi64 v2;
  __tsu64 v3;
};
//SIG(1 BFu8i_L_Ul) C1{ Fi:8 FL[2]}



static void Test_BFu8i_L_Ul()
{
  {
    init_simple_test("BFu8i_L_Ul");
    static STRUCT_IF_C BFu8i_L_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu8i_L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_Ul, BFu8i_L_Ul)
//============================================================================


struct  BFu8i_L_Us  {
  unsigned int v1:8;
  __tsi64 v2;
  unsigned short v3;
};
//SIG(1 BFu8i_L_Us) C1{ Fi:8 FL Fs}



static void Test_BFu8i_L_Us()
{
  {
    init_simple_test("BFu8i_L_Us");
    static STRUCT_IF_C BFu8i_L_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_Us, BFu8i_L_Us)
//============================================================================


struct  BFu8i_L_Vp  {
  unsigned int v1:8;
  __tsi64 v2;
  void *v3;
};
//SIG(1 BFu8i_L_Vp) C1{ Fi:8 FL Fp}



static void Test_BFu8i_L_Vp()
{
  {
    init_simple_test("BFu8i_L_Vp");
    static STRUCT_IF_C BFu8i_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_Vp, BFu8i_L_Vp)
//============================================================================


struct  BFu8i_S  {
  unsigned int v1:8;
  short v2;
};
//SIG(1 BFu8i_S) C1{ Fi:8 Fs}



static void Test_BFu8i_S()
{
  {
    init_simple_test("BFu8i_S");
    static STRUCT_IF_C BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S");
    check_field_offset(lv, v2, 2, "BFu8i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S, BFu8i_S)
//============================================================================


struct  BFu8i_S_BFu15i  {
  unsigned int v1:8;
  short v2;
  unsigned int v3:15;
};
//SIG(1 BFu8i_S_BFu15i) C1{ Fi:8 Fs Fi:15}



static void Test_BFu8i_S_BFu15i()
{
  {
    init_simple_test("BFu8i_S_BFu15i");
    static STRUCT_IF_C BFu8i_S_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu15i");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu8i_S_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu8i_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu15i, BFu8i_S_BFu15i)
//============================================================================


struct  BFu8i_S_BFu15ll  {
  unsigned int v1:8;
  short v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_S_BFu15ll) C1{ Fi:8 Fs FL:15}



static void Test_BFu8i_S_BFu15ll()
{
  {
    init_simple_test("BFu8i_S_BFu15ll");
    static STRUCT_IF_C BFu8i_S_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_S_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu8i_S_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu8i_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu15ll, BFu8i_S_BFu15ll)
//============================================================================


struct  BFu8i_S_BFu15s  {
  unsigned int v1:8;
  short v2;
  unsigned short v3:15;
};
//SIG(1 BFu8i_S_BFu15s) C1{ Fi:8 Fs Fs:15}



static void Test_BFu8i_S_BFu15s()
{
  {
    init_simple_test("BFu8i_S_BFu15s");
    static STRUCT_IF_C BFu8i_S_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu15s");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu8i_S_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu8i_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu15s, BFu8i_S_BFu15s)
//============================================================================


struct  BFu8i_S_BFu16i  {
  unsigned int v1:8;
  short v2;
  unsigned int v3:16;
};
//SIG(1 BFu8i_S_BFu16i) C1{ Fi:8 Fs Fi:16}



static void Test_BFu8i_S_BFu16i()
{
  {
    init_simple_test("BFu8i_S_BFu16i");
    static STRUCT_IF_C BFu8i_S_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu16i");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_S_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu16i, BFu8i_S_BFu16i)
//============================================================================


struct  BFu8i_S_BFu16ll  {
  unsigned int v1:8;
  short v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_S_BFu16ll) C1{ Fi:8 Fs FL:16}



static void Test_BFu8i_S_BFu16ll()
{
  {
    init_simple_test("BFu8i_S_BFu16ll");
    static STRUCT_IF_C BFu8i_S_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_S_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_S_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu16ll, BFu8i_S_BFu16ll)
//============================================================================


struct  BFu8i_S_BFu16s  {
  unsigned int v1:8;
  short v2;
  unsigned short v3:16;
};
//SIG(1 BFu8i_S_BFu16s) C1{ Fi:8 Fs Fs:16}



static void Test_BFu8i_S_BFu16s()
{
  {
    init_simple_test("BFu8i_S_BFu16s");
    static STRUCT_IF_C BFu8i_S_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu16s");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu8i_S_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu8i_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu16s, BFu8i_S_BFu16s)
//============================================================================


struct  BFu8i_S_BFu17i  {
  unsigned int v1:8;
  short v2;
  unsigned int v3:17;
};
//SIG(1 BFu8i_S_BFu17i) C1{ Fi:8 Fs Fi:17}



static void Test_BFu8i_S_BFu17i()
{
  {
    init_simple_test("BFu8i_S_BFu17i");
    static STRUCT_IF_C BFu8i_S_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu17i");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_S_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu17i, BFu8i_S_BFu17i)
//============================================================================


struct  BFu8i_S_BFu17ll  {
  unsigned int v1:8;
  short v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_S_BFu17ll) C1{ Fi:8 Fs FL:17}



static void Test_BFu8i_S_BFu17ll()
{
  {
    init_simple_test("BFu8i_S_BFu17ll");
    static STRUCT_IF_C BFu8i_S_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_S_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_S_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu17ll, BFu8i_S_BFu17ll)
//============================================================================


struct  BFu8i_S_BFu1c  {
  unsigned int v1:8;
  short v2;
  unsigned char v3:1;
};
//SIG(1 BFu8i_S_BFu1c) C1{ Fi:8 Fs Fc:1}



static void Test_BFu8i_S_BFu1c()
{
  {
    init_simple_test("BFu8i_S_BFu1c");
    static STRUCT_IF_C BFu8i_S_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu1c");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu8i_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu1c, BFu8i_S_BFu1c)
//============================================================================


struct  BFu8i_S_BFu1i  {
  unsigned int v1:8;
  short v2;
  unsigned int v3:1;
};
//SIG(1 BFu8i_S_BFu1i) C1{ Fi:8 Fs Fi:1}



static void Test_BFu8i_S_BFu1i()
{
  {
    init_simple_test("BFu8i_S_BFu1i");
    static STRUCT_IF_C BFu8i_S_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu1i");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu8i_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu1i, BFu8i_S_BFu1i)
//============================================================================


struct  BFu8i_S_BFu1ll  {
  unsigned int v1:8;
  short v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_S_BFu1ll) C1{ Fi:8 Fs FL:1}



static void Test_BFu8i_S_BFu1ll()
{
  {
    init_simple_test("BFu8i_S_BFu1ll");
    static STRUCT_IF_C BFu8i_S_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_S_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu8i_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu1ll, BFu8i_S_BFu1ll)
//============================================================================


struct  BFu8i_S_BFu1s  {
  unsigned int v1:8;
  short v2;
  unsigned short v3:1;
};
//SIG(1 BFu8i_S_BFu1s) C1{ Fi:8 Fs Fs:1}



static void Test_BFu8i_S_BFu1s()
{
  {
    init_simple_test("BFu8i_S_BFu1s");
    static STRUCT_IF_C BFu8i_S_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu1s");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu8i_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu1s, BFu8i_S_BFu1s)
//============================================================================


struct  BFu8i_S_BFu31i  {
  unsigned int v1:8;
  short v2;
  unsigned int v3:31;
};
//SIG(1 BFu8i_S_BFu31i) C1{ Fi:8 Fs Fi:31}



static void Test_BFu8i_S_BFu31i()
{
  {
    init_simple_test("BFu8i_S_BFu31i");
    static STRUCT_IF_C BFu8i_S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu31i");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_S_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu31i, BFu8i_S_BFu31i)
//============================================================================


struct  BFu8i_S_BFu31ll  {
  unsigned int v1:8;
  short v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_S_BFu31ll) C1{ Fi:8 Fs FL:31}



static void Test_BFu8i_S_BFu31ll()
{
  {
    init_simple_test("BFu8i_S_BFu31ll");
    static STRUCT_IF_C BFu8i_S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_S_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_S_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu31ll, BFu8i_S_BFu31ll)
//============================================================================


struct  BFu8i_S_BFu32i  {
  unsigned int v1:8;
  short v2;
  unsigned int v3:32;
};
//SIG(1 BFu8i_S_BFu32i) C1{ Fi:8 Fs Fi:32}



static void Test_BFu8i_S_BFu32i()
{
  {
    init_simple_test("BFu8i_S_BFu32i");
    static STRUCT_IF_C BFu8i_S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu32i");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_S_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu32i, BFu8i_S_BFu32i)
//============================================================================


struct  BFu8i_S_BFu32ll  {
  unsigned int v1:8;
  short v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_S_BFu32ll) C1{ Fi:8 Fs FL:32}



static void Test_BFu8i_S_BFu32ll()
{
  {
    init_simple_test("BFu8i_S_BFu32ll");
    static STRUCT_IF_C BFu8i_S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_S_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu8i_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_S_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_BFu