// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFu1i_BFs1ll_BFs1i_BFs1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1i_BFs1i) C1{ Fi:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1i_BFs1i, BFu1i_BFs1ll_BFs1i_BFs1i)
//============================================================================


struct  BFu1i_BFs1ll_BFs1i_BFs1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1i_BFs1ll) C1{ Fi:1 FL:1 Fi:1 FL:1}



static void Test_BFu1i_BFs1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1i_BFs1ll, BFu1i_BFs1ll_BFs1i_BFs1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFs1i_BFs1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1i_BFs1s) C1{ Fi:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1i_BFs1s, BFu1i_BFs1ll_BFs1i_BFs1s)
//============================================================================


struct  BFu1i_BFs1ll_BFs1i_BFu1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1i_BFu1c) C1{ Fi:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1i_BFu1c, BFu1i_BFs1ll_BFs1i_BFu1c)
//============================================================================


struct  BFu1i_BFs1ll_BFs1i_BFu1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1i_BFu1i) C1{ Fi:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1i_BFu1i, BFu1i_BFs1ll_BFs1i_BFu1i)
//============================================================================


struct  BFu1i_BFs1ll_BFs1i_BFu1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1i_BFu1ll) C1{ Fi:1 FL:1 Fi:1 FL:1}



static void Test_BFu1i_BFs1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1i_BFu1ll, BFu1i_BFs1ll_BFs1i_BFu1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFs1i_BFu1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1i_BFu1s) C1{ Fi:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1i_BFu1s, BFu1i_BFs1ll_BFs1i_BFu1s)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll) C1{ Fi:1 FL:1 FL:1}



static void Test_BFu1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll, BFu1i_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll_BFs1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll_BFs1c) C1{ Fi:1 FL:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll_BFs1c, BFu1i_BFs1ll_BFs1ll_BFs1c)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll_BFs1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll_BFs1i) C1{ Fi:1 FL:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll_BFs1i, BFu1i_BFs1ll_BFs1ll_BFs1i)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll_BFs1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll_BFs1ll) C1{ Fi:1 FL:1 FL:1 FL:1}



static void Test_BFu1i_BFs1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll_BFs1ll, BFu1i_BFs1ll_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll_BFs1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll_BFs1s) C1{ Fi:1 FL:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll_BFs1s, BFu1i_BFs1ll_BFs1ll_BFs1s)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll_BFu1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll_BFu1c) C1{ Fi:1 FL:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll_BFu1c, BFu1i_BFs1ll_BFs1ll_BFu1c)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll_BFu1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll_BFu1i) C1{ Fi:1 FL:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll_BFu1i, BFu1i_BFs1ll_BFs1ll_BFu1i)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll_BFu1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll_BFu1ll) C1{ Fi:1 FL:1 FL:1 FL:1}



static void Test_BFu1i_BFs1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll_BFu1ll, BFu1i_BFs1ll_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFs1ll_BFu1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1ll_BFu1s) C1{ Fi:1 FL:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1ll_BFu1s, BFu1i_BFs1ll_BFs1ll_BFu1s)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s) C1{ Fi:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s, BFu1i_BFs1ll_BFs1s)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s_BFs1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s_BFs1c) C1{ Fi:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s_BFs1c, BFu1i_BFs1ll_BFs1s_BFs1c)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s_BFs1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s_BFs1i) C1{ Fi:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s_BFs1i, BFu1i_BFs1ll_BFs1s_BFs1i)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s_BFs1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s_BFs1ll) C1{ Fi:1 FL:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s_BFs1ll, BFu1i_BFs1ll_BFs1s_BFs1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s_BFs1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s_BFs1s) C1{ Fi:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s_BFs1s, BFu1i_BFs1ll_BFs1s_BFs1s)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s_BFu1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s_BFu1c) C1{ Fi:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s_BFu1c, BFu1i_BFs1ll_BFs1s_BFu1c)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s_BFu1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s_BFu1i) C1{ Fi:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s_BFu1i, BFu1i_BFs1ll_BFs1s_BFu1i)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s_BFu1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s_BFu1ll) C1{ Fi:1 FL:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s_BFu1ll, BFu1i_BFs1ll_BFs1s_BFu1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFs1s_BFu1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFs1s_BFu1s) C1{ Fi:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFs1s_BFu1s, BFu1i_BFs1ll_BFs1s_BFu1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c) C1{ Fi:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c, BFu1i_BFs1ll_BFu1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c_BFs1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c_BFs1c) C1{ Fi:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c_BFs1c, BFu1i_BFs1ll_BFu1c_BFs1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c_BFs1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c_BFs1i) C1{ Fi:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c_BFs1i, BFu1i_BFs1ll_BFu1c_BFs1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c_BFs1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c_BFs1ll) C1{ Fi:1 FL:1 Fc:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c_BFs1ll, BFu1i_BFs1ll_BFu1c_BFs1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c_BFs1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c_BFs1s) C1{ Fi:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c_BFs1s, BFu1i_BFs1ll_BFu1c_BFs1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c_BFu1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c_BFu1c) C1{ Fi:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c_BFu1c, BFu1i_BFs1ll_BFu1c_BFu1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c_BFu1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c_BFu1i) C1{ Fi:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c_BFu1i, BFu1i_BFs1ll_BFu1c_BFu1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c_BFu1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c_BFu1ll) C1{ Fi:1 FL:1 Fc:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c_BFu1ll, BFu1i_BFs1ll_BFu1c_BFu1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1c_BFu1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1c_BFu1s) C1{ Fi:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1c_BFu1s, BFu1i_BFs1ll_BFu1c_BFu1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i) C1{ Fi:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i, BFu1i_BFs1ll_BFu1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i_BFs1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i_BFs1c) C1{ Fi:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i_BFs1c, BFu1i_BFs1ll_BFu1i_BFs1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i_BFs1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i_BFs1i) C1{ Fi:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i_BFs1i, BFu1i_BFs1ll_BFu1i_BFs1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i_BFs1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i_BFs1ll) C1{ Fi:1 FL:1 Fi:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i_BFs1ll, BFu1i_BFs1ll_BFu1i_BFs1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i_BFs1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i_BFs1s) C1{ Fi:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i_BFs1s, BFu1i_BFs1ll_BFu1i_BFs1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i_BFu1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i_BFu1c) C1{ Fi:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i_BFu1c, BFu1i_BFs1ll_BFu1i_BFu1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i_BFu1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i_BFu1i) C1{ Fi:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i_BFu1i, BFu1i_BFs1ll_BFu1i_BFu1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i_BFu1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i_BFu1ll) C1{ Fi:1 FL:1 Fi:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i_BFu1ll, BFu1i_BFs1ll_BFu1i_BFu1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1i_BFu1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1i_BFu1s) C1{ Fi:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1i_BFu1s, BFu1i_BFs1ll_BFu1i_BFu1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll) C1{ Fi:1 FL:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll, BFu1i_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll_BFs1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll_BFs1c) C1{ Fi:1 FL:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll_BFs1c, BFu1i_BFs1ll_BFu1ll_BFs1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll_BFs1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll_BFs1i) C1{ Fi:1 FL:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll_BFs1i, BFu1i_BFs1ll_BFu1ll_BFs1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll_BFs1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll_BFs1ll) C1{ Fi:1 FL:1 FL:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll_BFs1ll, BFu1i_BFs1ll_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll_BFs1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll_BFs1s) C1{ Fi:1 FL:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll_BFs1s, BFu1i_BFs1ll_BFu1ll_BFs1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll_BFu1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll_BFu1c) C1{ Fi:1 FL:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll_BFu1c, BFu1i_BFs1ll_BFu1ll_BFu1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll_BFu1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll_BFu1i) C1{ Fi:1 FL:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll_BFu1i, BFu1i_BFs1ll_BFu1ll_BFu1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll_BFu1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll_BFu1ll) C1{ Fi:1 FL:1 FL:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll_BFu1ll, BFu1i_BFs1ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1ll_BFu1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1ll_BFu1s) C1{ Fi:1 FL:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1ll_BFu1s, BFu1i_BFs1ll_BFu1ll_BFu1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s) C1{ Fi:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s, BFu1i_BFs1ll_BFu1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s_BFs1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s_BFs1c) C1{ Fi:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s_BFs1c, BFu1i_BFs1ll_BFu1s_BFs1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s_BFs1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s_BFs1i) C1{ Fi:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s_BFs1i, BFu1i_BFs1ll_BFu1s_BFs1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s_BFs1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s_BFs1ll) C1{ Fi:1 FL:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s_BFs1ll, BFu1i_BFs1ll_BFu1s_BFs1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s_BFs1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s_BFs1s) C1{ Fi:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s_BFs1s, BFu1i_BFs1ll_BFu1s_BFs1s)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s_BFu1c  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s_BFu1c) C1{ Fi:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s_BFu1c, BFu1i_BFs1ll_BFu1s_BFu1c)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s_BFu1i  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s_BFu1i) C1{ Fi:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s_BFu1i, BFu1i_BFs1ll_BFu1s_BFu1i)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s_BFu1ll  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s_BFu1ll) C1{ Fi:1 FL:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s_BFu1ll, BFu1i_BFs1ll_BFu1s_BFu1ll)
//============================================================================


struct  BFu1i_BFs1ll_BFu1s_BFu1s  {
  unsigned int v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1ll_BFu1s_BFu1s) C1{ Fi:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1ll_BFu1s_BFu1s, BFu1i_BFs1ll_BFu1s_BFu1s)
//============================================================================


struct  BFu1i_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
};
//SIG(1 BFu1i_BFs1s) C1{ Fi:1 Fs:1}



static void Test_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s, BFu1i_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c) C1{ Fi:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c, BFu1i_BFs1s_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1c_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c_BFs1c) C1{ Fi:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c_BFs1c, BFu1i_BFs1s_BFs1c_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1c_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c_BFs1i) C1{ Fi:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c_BFs1i, BFu1i_BFs1s_BFs1c_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1c_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c_BFs1ll) C1{ Fi:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c_BFs1ll, BFu1i_BFs1s_BFs1c_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1c_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c_BFs1s) C1{ Fi:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c_BFs1s, BFu1i_BFs1s_BFs1c_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1c_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c_BFu1c) C1{ Fi:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c_BFu1c, BFu1i_BFs1s_BFs1c_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1c_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c_BFu1i) C1{ Fi:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c_BFu1i, BFu1i_BFs1s_BFs1c_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1c_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c_BFu1ll) C1{ Fi:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c_BFu1ll, BFu1i_BFs1s_BFs1c_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1c_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1c_BFu1s) C1{ Fi:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1c_BFu1s, BFu1i_BFs1s_BFs1c_BFu1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i) C1{ Fi:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i, BFu1i_BFs1s_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1i_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i_BFs1c) C1{ Fi:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i_BFs1c, BFu1i_BFs1s_BFs1i_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1i_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i_BFs1i) C1{ Fi:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i_BFs1i, BFu1i_BFs1s_BFs1i_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1i_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i_BFs1ll) C1{ Fi:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i_BFs1ll, BFu1i_BFs1s_BFs1i_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1i_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i_BFs1s) C1{ Fi:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i_BFs1s, BFu1i_BFs1s_BFs1i_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1i_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i_BFu1c) C1{ Fi:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i_BFu1c, BFu1i_BFs1s_BFs1i_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1i_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i_BFu1i) C1{ Fi:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i_BFu1i, BFu1i_BFs1s_BFs1i_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1i_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i_BFu1ll) C1{ Fi:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i_BFu1ll, BFu1i_BFs1s_BFs1i_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1i_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1i_BFu1s) C1{ Fi:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1i_BFu1s, BFu1i_BFs1s_BFs1i_BFu1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll) C1{ Fi:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll, BFu1i_BFs1s_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll_BFs1c) C1{ Fi:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll_BFs1c, BFu1i_BFs1s_BFs1ll_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll_BFs1i) C1{ Fi:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll_BFs1i, BFu1i_BFs1s_BFs1ll_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll_BFs1ll) C1{ Fi:1 Fs:1 FL:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll_BFs1ll, BFu1i_BFs1s_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll_BFs1s) C1{ Fi:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll_BFs1s, BFu1i_BFs1s_BFs1ll_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll_BFu1c) C1{ Fi:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll_BFu1c, BFu1i_BFs1s_BFs1ll_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll_BFu1i) C1{ Fi:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll_BFu1i, BFu1i_BFs1s_BFs1ll_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll_BFu1ll) C1{ Fi:1 Fs:1 FL:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll_BFu1ll, BFu1i_BFs1s_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1ll_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1ll_BFu1s) C1{ Fi:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1ll_BFu1s, BFu1i_BFs1s_BFs1ll_BFu1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s) C1{ Fi:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s, BFu1i_BFs1s_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1s_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s_BFs1c) C1{ Fi:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s_BFs1c, BFu1i_BFs1s_BFs1s_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1s_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s_BFs1i) C1{ Fi:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s_BFs1i, BFu1i_BFs1s_BFs1s_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1s_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s_BFs1ll) C1{ Fi:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s_BFs1ll, BFu1i_BFs1s_BFs1s_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1s_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s_BFs1s) C1{ Fi:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s_BFs1s, BFu1i_BFs1s_BFs1s_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFs1s_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s_BFu1c) C1{ Fi:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s_BFu1c, BFu1i_BFs1s_BFs1s_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFs1s_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s_BFu1i) C1{ Fi:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s_BFu1i, BFu1i_BFs1s_BFs1s_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFs1s_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s_BFu1ll) C1{ Fi:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s_BFu1ll, BFu1i_BFs1s_BFs1s_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFs1s_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFs1s_BFu1s) C1{ Fi:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFs1s_BFu1s, BFu1i_BFs1s_BFs1s_BFu1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c) C1{ Fi:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c, BFu1i_BFs1s_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1c_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c_BFs1c) C1{ Fi:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c_BFs1c, BFu1i_BFs1s_BFu1c_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1c_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c_BFs1i) C1{ Fi:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c_BFs1i, BFu1i_BFs1s_BFu1c_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1c_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c_BFs1ll) C1{ Fi:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c_BFs1ll, BFu1i_BFs1s_BFu1c_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1c_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c_BFs1s) C1{ Fi:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c_BFs1s, BFu1i_BFs1s_BFu1c_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1c_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c_BFu1c) C1{ Fi:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c_BFu1c, BFu1i_BFs1s_BFu1c_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1c_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c_BFu1i) C1{ Fi:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c_BFu1i, BFu1i_BFs1s_BFu1c_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1c_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c_BFu1ll) C1{ Fi:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c_BFu1ll, BFu1i_BFs1s_BFu1c_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1c_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1c_BFu1s) C1{ Fi:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1c_BFu1s, BFu1i_BFs1s_BFu1c_BFu1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i) C1{ Fi:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i, BFu1i_BFs1s_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1i_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i_BFs1c) C1{ Fi:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i_BFs1c, BFu1i_BFs1s_BFu1i_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1i_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i_BFs1i) C1{ Fi:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i_BFs1i, BFu1i_BFs1s_BFu1i_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1i_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i_BFs1ll) C1{ Fi:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i_BFs1ll, BFu1i_BFs1s_BFu1i_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1i_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i_BFs1s) C1{ Fi:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i_BFs1s, BFu1i_BFs1s_BFu1i_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1i_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i_BFu1c) C1{ Fi:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i_BFu1c, BFu1i_BFs1s_BFu1i_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1i_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i_BFu1i) C1{ Fi:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i_BFu1i, BFu1i_BFs1s_BFu1i_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1i_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i_BFu1ll) C1{ Fi:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i_BFu1ll, BFu1i_BFs1s_BFu1i_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1i_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1i_BFu1s) C1{ Fi:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1i_BFu1s, BFu1i_BFs1s_BFu1i_BFu1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll) C1{ Fi:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll, BFu1i_BFs1s_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll_BFs1c) C1{ Fi:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll_BFs1c, BFu1i_BFs1s_BFu1ll_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll_BFs1i) C1{ Fi:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll_BFs1i, BFu1i_BFs1s_BFu1ll_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll_BFs1ll) C1{ Fi:1 Fs:1 FL:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll_BFs1ll, BFu1i_BFs1s_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll_BFs1s) C1{ Fi:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll_BFs1s, BFu1i_BFs1s_BFu1ll_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll_BFu1c) C1{ Fi:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll_BFu1c, BFu1i_BFs1s_BFu1ll_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll_BFu1i) C1{ Fi:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll_BFu1i, BFu1i_BFs1s_BFu1ll_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll_BFu1ll) C1{ Fi:1 Fs:1 FL:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll_BFu1ll, BFu1i_BFs1s_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1ll_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1ll_BFu1s) C1{ Fi:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1ll_BFu1s, BFu1i_BFs1s_BFu1ll_BFu1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s) C1{ Fi:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s, BFu1i_BFs1s_BFu1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1s_BFs1c  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s_BFs1c) C1{ Fi:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s_BFs1c, BFu1i_BFs1s_BFu1s_BFs1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1s_BFs1i  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s_BFs1i) C1{ Fi:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s_BFs1i, BFu1i_BFs1s_BFu1s_BFs1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1s_BFs1ll  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s_BFs1ll) C1{ Fi:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s_BFs1ll, BFu1i_BFs1s_BFu1s_BFs1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1s_BFs1s  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s_BFs1s) C1{ Fi:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFs1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s_BFs1s, BFu1i_BFs1s_BFu1s_BFs1s)
//============================================================================


struct  BFu1i_BFs1s_BFu1s_BFu1c  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s_BFu1c) C1{ Fi:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1i_BFs1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s_BFu1c, BFu1i_BFs1s_BFu1s_BFu1c)
//============================================================================


struct  BFu1i_BFs1s_BFu1s_BFu1i  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s_BFu1i) C1{ Fi:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1i_BFs1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s_BFu1i, BFu1i_BFs1s_BFu1s_BFu1i)
//============================================================================


struct  BFu1i_BFs1s_BFu1s_BFu1ll  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s_BFu1ll) C1{ Fi:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1i_BFs1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFs1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFs1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s_BFu1ll, BFu1i_BFs1s_BFu1s_BFu1ll)
//============================================================================


struct  BFu1i_BFs1s_BFu1s_BFu1s  {
  unsigned int v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFs1s_BFu1s_BFu1s) C1{ Fi:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1i_BFs1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFs1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFs1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFs1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFs1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1i_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFs1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFs1s_BFu1s_BFu1s, BFu1i_BFs1s_BFu1s_BFu1s)
//============================================================================


struct  BFu1i_BFu15i  {
  unsigned int v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu1i_BFu15i) C1{ Fi:1 Fi:15}



static void Test_BFu1i_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu15i");
    static STRUCT_IF_C BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i, BFu1i_BFu15i)
//============================================================================


struct  BFu1i_BFu15i_BFu15i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu15i_BFu15i) C1{ Fi:1 Fi:15 Fi:15}



static void Test_BFu1i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu15i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu15i, BFu1i_BFu15i_BFu15i)
//============================================================================


struct  BFu1i_BFu15i_BFu15ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu15i_BFu15ll) C1{ Fi:1 Fi:15 FL:15}



static void Test_BFu1i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu15ll, BFu1i_BFu15i_BFu15ll)
//============================================================================


struct  BFu1i_BFu15i_BFu15s  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu15i_BFu15s) C1{ Fi:1 Fi:15 Fs:15}



static void Test_BFu1i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu15s");
    static STRUCT_IF_C BFu1i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu15s, BFu1i_BFu15i_BFu15s)
//============================================================================


struct  BFu1i_BFu15i_BFu16i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu15i_BFu16i) C1{ Fi:1 Fi:15 Fi:16}



static void Test_BFu1i_BFu15i_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu16i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu16i, BFu1i_BFu15i_BFu16i)
//============================================================================


struct  BFu1i_BFu15i_BFu16ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu15i_BFu16ll) C1{ Fi:1 Fi:15 FL:16}



static void Test_BFu1i_BFu15i_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu16ll, BFu1i_BFu15i_BFu16ll)
//============================================================================


struct  BFu1i_BFu15i_BFu16s  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu15i_BFu16s) C1{ Fi:1 Fi:15 Fs:16}



static void Test_BFu1i_BFu15i_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu16s");
    static STRUCT_IF_C BFu1i_BFu15i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu16s, BFu1i_BFu15i_BFu16s)
//============================================================================


struct  BFu1i_BFu15i_BFu17i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu15i_BFu17i) C1{ Fi:1 Fi:15 Fi:17}



static void Test_BFu1i_BFu15i_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu17i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu17i, BFu1i_BFu15i_BFu17i)
//============================================================================


struct  BFu1i_BFu15i_BFu17ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu15i_BFu17ll) C1{ Fi:1 Fi:15 FL:17}



static void Test_BFu1i_BFu15i_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu17ll, BFu1i_BFu15i_BFu17ll)
//============================================================================


struct  BFu1i_BFu15i_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu15i_BFu1c) C1{ Fi:1 Fi:15 Fc:1}



static void Test_BFu1i_BFu15i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu1c, BFu1i_BFu15i_BFu1c)
//============================================================================


struct  BFu1i_BFu15i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu15i_BFu1i) C1{ Fi:1 Fi:15 Fi:1}



static void Test_BFu1i_BFu15i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu1i, BFu1i_BFu15i_BFu1i)
//============================================================================


struct  BFu1i_BFu15i_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu15i_BFu1ll) C1{ Fi:1 Fi:15 FL:1}



static void Test_BFu1i_BFu15i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu1ll, BFu1i_BFu15i_BFu1ll)
//============================================================================


struct  BFu1i_BFu15i_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu15i_BFu1s) C1{ Fi:1 Fi:15 Fs:1}



static void Test_BFu1i_BFu15i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu1s, BFu1i_BFu15i_BFu1s)
//============================================================================


struct  BFu1i_BFu15i_BFu31i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu15i_BFu31i) C1{ Fi:1 Fi:15 Fi:31}



static void Test_BFu1i_BFu15i_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu31i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu31i, BFu1i_BFu15i_BFu31i)
//============================================================================


struct  BFu1i_BFu15i_BFu31ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu15i_BFu31ll) C1{ Fi:1 Fi:15 FL:31}



static void Test_BFu1i_BFu15i_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu31ll, BFu1i_BFu15i_BFu31ll)
//============================================================================


struct  BFu1i_BFu15i_BFu32i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu15i_BFu32i) C1{ Fi:1 Fi:15 Fi:32}



static void Test_BFu1i_BFu15i_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu32i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu32i, BFu1i_BFu15i_BFu32i)
//============================================================================


struct  BFu1i_BFu15i_BFu32ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu15i_BFu32ll) C1{ Fi:1 Fi:15 FL:32}



static void Test_BFu1i_BFu15i_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu32ll, BFu1i_BFu15i_BFu32ll)
//============================================================================


struct  BFu1i_BFu15i_BFu33  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu15i_BFu33) C1{ Fi:1 Fi:15 FL:33}



static void Test_BFu1i_BFu15i_BFu33()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu33");
    static STRUCT_IF_C BFu1i_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1i_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1i_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu33, BFu1i_BFu15i_BFu33)
//============================================================================


struct  BFu1i_BFu15i_BFu7c  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu15i_BFu7c) C1{ Fi:1 Fi:15 Fc:7}



static void Test_BFu1i_BFu15i_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu7c");
    static STRUCT_IF_C BFu1i_BFu15i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu7c, BFu1i_BFu15i_BFu7c)
//============================================================================


struct  BFu1i_BFu15i_BFu7i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu15i_BFu7i) C1{ Fi:1 Fi:15 Fi:7}



static void Test_BFu1i_BFu15i_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu7i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu7i, BFu1i_BFu15i_BFu7i)
//============================================================================


struct  BFu1i_BFu15i_BFu7ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu15i_BFu7ll) C1{ Fi:1 Fi:15 FL:7}



static void Test_BFu1i_BFu15i_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu7ll, BFu1i_BFu15i_BFu7ll)
//============================================================================


struct  BFu1i_BFu15i_BFu7s  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu15i_BFu7s) C1{ Fi:1 Fi:15 Fs:7}



static void Test_BFu1i_BFu15i_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu7s");
    static STRUCT_IF_C BFu1i_BFu15i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu7s, BFu1i_BFu15i_BFu7s)
//============================================================================


struct  BFu1i_BFu15i_BFu8c  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu15i_BFu8c) C1{ Fi:1 Fi:15 Fc:8}



static void Test_BFu1i_BFu15i_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu8c");
    static STRUCT_IF_C BFu1i_BFu15i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu8c, BFu1i_BFu15i_BFu8c)
//============================================================================


struct  BFu1i_BFu15i_BFu8i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu15i_BFu8i) C1{ Fi:1 Fi:15 Fi:8}



static void Test_BFu1i_BFu15i_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu8i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu8i, BFu1i_BFu15i_BFu8i)
//============================================================================


struct  BFu1i_BFu15i_BFu8ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu15i_BFu8ll) C1{ Fi:1 Fi:15 FL:8}



static void Test_BFu1i_BFu15i_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu8ll, BFu1i_BFu15i_BFu8ll)
//============================================================================


struct  BFu1i_BFu15i_BFu8s  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu15i_BFu8s) C1{ Fi:1 Fi:15 Fs:8}



static void Test_BFu1i_BFu15i_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu8s");
    static STRUCT_IF_C BFu1i_BFu15i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu8s, BFu1i_BFu15i_BFu8s)
//============================================================================


struct  BFu1i_BFu15i_BFu9i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu15i_BFu9i) C1{ Fi:1 Fi:15 Fi:9}



static void Test_BFu1i_BFu15i_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu9i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu9i, BFu1i_BFu15i_BFu9i)
//============================================================================


struct  BFu1i_BFu15i_BFu9ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu15i_BFu9ll) C1{ Fi:1 Fi:15 FL:9}



static void Test_BFu1i_BFu15i_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu9ll, BFu1i_BFu15i_BFu9ll)
//============================================================================


struct  BFu1i_BFu15i_BFu9s  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu15i_BFu9s) C1{ Fi:1 Fi:15 Fs:9}



static void Test_BFu1i_BFu15i_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu9s");
    static STRUCT_IF_C BFu1i_BFu15i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu9s, BFu1i_BFu15i_BFu9s)
//============================================================================


struct  BFu1i_BFu15i_C  {
  unsigned int v1:1;
  unsigned int v2:15;
  char v3;
};
//SIG(1 BFu1i_BFu15i_C) C1{ Fi:1 Fi:15 Fc}



static void Test_BFu1i_BFu15i_C()
{
  {
    init_simple_test("BFu1i_BFu15i_C");
    static STRUCT_IF_C BFu1i_BFu15i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_C");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_C");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_C");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_C, BFu1i_BFu15i_C)
//============================================================================


struct  BFu1i_BFu15i_D  {
  unsigned int v1:1;
  unsigned int v2:15;
  double v3;
};
//SIG(1 BFu1i_BFu15i_D) C1{ Fi:1 Fi:15 FL}



static void Test_BFu1i_BFu15i_D()
{
  {
    init_simple_test("BFu1i_BFu15i_D");
    static STRUCT_IF_C BFu1i_BFu15i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_D");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_D");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_D, BFu1i_BFu15i_D)
//============================================================================


struct  BFu1i_BFu15i_F  {
  unsigned int v1:1;
  unsigned int v2:15;
  float v3;
};
//SIG(1 BFu1i_BFu15i_F) C1{ Fi:1 Fi:15 Fi}



static void Test_BFu1i_BFu15i_F()
{
  {
    init_simple_test("BFu1i_BFu15i_F");
    static STRUCT_IF_C BFu1i_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_F");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_F");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_F, BFu1i_BFu15i_F)
//============================================================================


struct  BFu1i_BFu15i_I  {
  unsigned int v1:1;
  unsigned int v2:15;
  int v3;
};
//SIG(1 BFu1i_BFu15i_I) C1{ Fi:1 Fi:15 Fi}



static void Test_BFu1i_BFu15i_I()
{
  {
    init_simple_test("BFu1i_BFu15i_I");
    static STRUCT_IF_C BFu1i_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_I");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_I");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_I, BFu1i_BFu15i_I)
//============================================================================


struct  BFu1i_BFu15i_Ip  {
  unsigned int v1:1;
  unsigned int v2:15;
  int *v3;
};
//SIG(1 BFu1i_BFu15i_Ip) C1{ Fi:1 Fi:15 Fp}



static void Test_BFu1i_BFu15i_Ip()
{
  {
    init_simple_test("BFu1i_BFu15i_Ip");
    static STRUCT_IF_C BFu1i_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_Ip, BFu1i_BFu15i_Ip)
//============================================================================


struct  BFu1i_BFu15i_L  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu15i_L) C1{ Fi:1 Fi:15 FL}



static void Test_BFu1i_BFu15i_L()
{
  {
    init_simple_test("BFu1i_BFu15i_L");
    static STRUCT_IF_C BFu1i_BFu15i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_L");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_L");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_L, BFu1i_BFu15i_L)
//============================================================================


struct  BFu1i_BFu15i_S  {
  unsigned int v1:1;
  unsigned int v2:15;
  short v3;
};
//SIG(1 BFu1i_BFu15i_S) C1{ Fi:1 Fi:15 Fs}



static void Test_BFu1i_BFu15i_S()
{
  {
    init_simple_test("BFu1i_BFu15i_S");
    static STRUCT_IF_C BFu1i_BFu15i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_S");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_S");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_S");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_S, BFu1i_BFu15i_S)
//============================================================================


struct  BFu1i_BFu15i_Uc  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu15i_Uc) C1{ Fi:1 Fi:15 Fc}



static void Test_BFu1i_BFu15i_Uc()
{
  {
    init_simple_test("BFu1i_BFu15i_Uc");
    static STRUCT_IF_C BFu1i_BFu15i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_Uc");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_Uc, BFu1i_BFu15i_Uc)
//============================================================================


struct  BFu1i_BFu15i_Ui  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu15i_Ui) C1{ Fi:1 Fi:15 Fi}



static void Test_BFu1i_BFu15i_Ui()
{
  {
    init_simple_test("BFu1i_BFu15i_Ui");
    static STRUCT_IF_C BFu1i_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_Ui, BFu1i_BFu15i_Ui)
//============================================================================


struct  BFu1i_BFu15i_Ul  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu15i_Ul) C1{ Fi:1 Fi:15 FL}



static void Test_BFu1i_BFu15i_Ul()
{
  {
    init_simple_test("BFu1i_BFu15i_Ul");
    static STRUCT_IF_C BFu1i_BFu15i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_Ul, BFu1i_BFu15i_Ul)
//============================================================================


struct  BFu1i_BFu15i_Us  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu15i_Us) C1{ Fi:1 Fi:15 Fs}



static void Test_BFu1i_BFu15i_Us()
{
  {
    init_simple_test("BFu1i_BFu15i_Us");
    static STRUCT_IF_C BFu1i_BFu15i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_Us");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_Us, BFu1i_BFu15i_Us)
//============================================================================


struct  BFu1i_BFu15i_Vp  {
  unsigned int v1:1;
  unsigned int v2:15;
  void *v3;
};
//SIG(1 BFu1i_BFu15i_Vp) C1{ Fi:1 Fi:15 Fp}



static void Test_BFu1i_BFu15i_Vp()
{
  {
    init_simple_test("BFu1i_BFu15i_Vp");
    static STRUCT_IF_C BFu1i_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_Vp, BFu1i_BFu15i_Vp)
//============================================================================


struct  BFu1i_BFu15ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu1i_BFu15ll) C1{ Fi:1 FL:15}



static void Test_BFu1i_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll, BFu1i_BFu15ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu15i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu15ll_BFu15i) C1{ Fi:1 FL:15 Fi:15}



static void Test_BFu1i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu15i, BFu1i_BFu15ll_BFu15i)
//============================================================================


struct  BFu1i_BFu15ll_BFu15ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu15ll_BFu15ll) C1{ Fi:1 FL:15 FL:15}



static void Test_BFu1i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu15ll, BFu1i_BFu15ll_BFu15ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu15s  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu15ll_BFu15s) C1{ Fi:1 FL:15 Fs:15}



static void Test_BFu1i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu15s, BFu1i_BFu15ll_BFu15s)
//============================================================================


struct  BFu1i_BFu15ll_BFu16i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu15ll_BFu16i) C1{ Fi:1 FL:15 Fi:16}



static void Test_BFu1i_BFu15ll_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu16i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu16i, BFu1i_BFu15ll_BFu16i)
//============================================================================


struct  BFu1i_BFu15ll_BFu16ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu15ll_BFu16ll) C1{ Fi:1 FL:15 FL:16}



static void Test_BFu1i_BFu15ll_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu16ll, BFu1i_BFu15ll_BFu16ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu16s  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu15ll_BFu16s) C1{ Fi:1 FL:15 Fs:16}



static void Test_BFu1i_BFu15ll_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu16s");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu16s, BFu1i_BFu15ll_BFu16s)
//============================================================================


struct  BFu1i_BFu15ll_BFu17i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu15ll_BFu17i) C1{ Fi:1 FL:15 Fi:17}



static void Test_BFu1i_BFu15ll_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu17i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu17i, BFu1i_BFu15ll_BFu17i)
//============================================================================


struct  BFu1i_BFu15ll_BFu17ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu15ll_BFu17ll) C1{ Fi:1 FL:15 FL:17}



static void Test_BFu1i_BFu15ll_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu17ll, BFu1i_BFu15ll_BFu17ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu15ll_BFu1c) C1{ Fi:1 FL:15 Fc:1}



static void Test_BFu1i_BFu15ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu1c, BFu1i_BFu15ll_BFu1c)
//============================================================================


struct  BFu1i_BFu15ll_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu15ll_BFu1i) C1{ Fi:1 FL:15 Fi:1}



static void Test_BFu1i_BFu15ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu1i, BFu1i_BFu15ll_BFu1i)
//============================================================================


struct  BFu1i_BFu15ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu15ll_BFu1ll) C1{ Fi:1 FL:15 FL:1}



static void Test_BFu1i_BFu15ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu1ll, BFu1i_BFu15ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu15ll_BFu1s) C1{ Fi:1 FL:15 Fs:1}



static void Test_BFu1i_BFu15ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu1s, BFu1i_BFu15ll_BFu1s)
//============================================================================


struct  BFu1i_BFu15ll_BFu31i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu15ll_BFu31i) C1{ Fi:1 FL:15 Fi:31}



static void Test_BFu1i_BFu15ll_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu31i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu31i, BFu1i_BFu15ll_BFu31i)
//============================================================================


struct  BFu1i_BFu15ll_BFu31ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu15ll_BFu31ll) C1{ Fi:1 FL:15 FL:31}



static void Test_BFu1i_BFu15ll_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu31ll, BFu1i_BFu15ll_BFu31ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu32i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu15ll_BFu32i) C1{ Fi:1 FL:15 Fi:32}



static void Test_BFu1i_BFu15ll_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu32i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu32i, BFu1i_BFu15ll_BFu32i)
//============================================================================


struct  BFu1i_BFu15ll_BFu32ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu15ll_BFu32ll) C1{ Fi:1 FL:15 FL:32}



static void Test_BFu1i_BFu15ll_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu32ll, BFu1i_BFu15ll_BFu32ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu33  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu15ll_BFu33) C1{ Fi:1 FL:15 FL:33}



static void Test_BFu1i_BFu15ll_BFu33()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu33");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1i_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1i_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu33, BFu1i_BFu15ll_BFu33)
//============================================================================


struct  BFu1i_BFu15ll_BFu7c  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu15ll_BFu7c) C1{ Fi:1 FL:15 Fc:7}



static void Test_BFu1i_BFu15ll_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu7c");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu7c, BFu1i_BFu15ll_BFu7c)
//============================================================================


struct  BFu1i_BFu15ll_BFu7i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu15ll_BFu7i) C1{ Fi:1 FL:15 Fi:7}



static void Test_BFu1i_BFu15ll_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu7i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu7i, BFu1i_BFu15ll_BFu7i)
//============================================================================


struct  BFu1i_BFu15ll_BFu7ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu15ll_BFu7ll) C1{ Fi:1 FL:15 FL:7}



static void Test_BFu1i_BFu15ll_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu7ll, BFu1i_BFu15ll_BFu7ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu7s  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu15ll_BFu7s) C1{ Fi:1 FL:15 Fs:7}



static void Test_BFu1i_BFu15ll_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu7s");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu7s, BFu1i_BFu15ll_BFu7s)
//============================================================================


struct  BFu1i_BFu15ll_BFu8c  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu15ll_BFu8c) C1{ Fi:1 FL:15 Fc:8}



static void Test_BFu1i_BFu15ll_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu8c");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu8c, BFu1i_BFu15ll_BFu8c)
//============================================================================


struct  BFu1i_BFu15ll_BFu8i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu15ll_BFu8i) C1{ Fi:1 FL:15 Fi:8}



static void Test_BFu1i_BFu15ll_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu8i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu8i, BFu1i_BFu15ll_BFu8i)
//============================================================================


struct  BFu1i_BFu15ll_BFu8ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu15ll_BFu8ll) C1{ Fi:1 FL:15 FL:8}



static void Test_BFu1i_BFu15ll_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu8ll, BFu1i_BFu15ll_BFu8ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu8s  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu15ll_BFu8s) C1{ Fi:1 FL:15 Fs:8}



static void Test_BFu1i_BFu15ll_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu8s");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu8s, BFu1i_BFu15ll_BFu8s)
//============================================================================


struct  BFu1i_BFu15ll_BFu9i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu15ll_BFu9i) C1{ Fi:1 FL:15 Fi:9}



static void Test_BFu1i_BFu15ll_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu9i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu9i, BFu1i_BFu15ll_BFu9i)
//============================================================================


struct  BFu1i_BFu15ll_BFu9ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu15ll_BFu9ll) C1{ Fi:1 FL:15 FL:9}



static void Test_BFu1i_BFu15ll_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu9ll, BFu1i_BFu15ll_BFu9ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu9s  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu15ll_BFu9s) C1{ Fi:1 FL:15 Fs:9}



static void Test_BFu1i_BFu15ll_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu9s");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu9s, BFu1i_BFu15ll_BFu9s)
//============================================================================


struct  BFu1i_BFu15ll_C  {
  unsigned int v1:1;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 BFu1i_BFu15ll_C) C1{ Fi:1 FL:15 Fc}



static void Test_BFu1i_BFu15ll_C()
{
  {
    init_simple_test("BFu1i_BFu15ll_C");
    static STRUCT_IF_C BFu1i_BFu15ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_C");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_C");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_C");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_C, BFu1i_BFu15ll_C)
//============================================================================


struct  BFu1i_BFu15ll_D  {
  unsigned int v1:1;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 BFu1i_BFu15ll_D) C1{ Fi:1 FL:15 FL}



static void Test_BFu1i_BFu15ll_D()
{
  {
    init_simple_test("BFu1i_BFu15ll_D");
    static STRUCT_IF_C BFu1i_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_D");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_D");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_D, BFu1i_BFu15ll_D)
//============================================================================


struct  BFu1i_BFu15ll_F  {
  unsigned int v1:1;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 BFu1i_BFu15ll_F) C1{ Fi:1 FL:15 Fi}



static void Test_BFu1i_BFu15ll_F()
{
  {
    init_simple_test("BFu1i_BFu15ll_F");
    static STRUCT_IF_C BFu1i_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_F");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_F");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_F, BFu1i_BFu15ll_F)
//============================================================================


struct  BFu1i_BFu15ll_I  {
  unsigned int v1:1;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 BFu1i_BFu15ll_I) C1{ Fi:1 FL:15 Fi}



static void Test_BFu1i_BFu15ll_I()
{
  {
    init_simple_test("BFu1i_BFu15ll_I");
    static STRUCT_IF_C BFu1i_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_I");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_I");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_I, BFu1i_BFu15ll_I)
//============================================================================


struct  BFu1i_BFu15ll_Ip  {
  unsigned int v1:1;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 BFu1i_BFu15ll_Ip) C1{ Fi:1 FL:15 Fp}



static void Test_BFu1i_BFu15ll_Ip()
{
  {
    init_simple_test("BFu1i_BFu15ll_Ip");
    static STRUCT_IF_C BFu1i_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_Ip, BFu1i_BFu15ll_Ip)
//============================================================================


struct  BFu1i_BFu15ll_L  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu15ll_L) C1{ Fi:1 FL:15 FL}



static void Test_BFu1i_BFu15ll_L()
{
  {
    init_simple_test("BFu1i_BFu15ll_L");
    static STRUCT_IF_C BFu1i_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_L");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_L");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_L, BFu1i_BFu15ll_L)
//============================================================================


struct  BFu1i_BFu15ll_S  {
  unsigned int v1:1;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 BFu1i_BFu15ll_S) C1{ Fi:1 FL:15 Fs}



static void Test_BFu1i_BFu15ll_S()
{
  {
    init_simple_test("BFu1i_BFu15ll_S");
    static STRUCT_IF_C BFu1i_BFu15ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_S");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_S");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_S");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_S, BFu1i_BFu15ll_S)
//============================================================================


struct  BFu1i_BFu15ll_Uc  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu15ll_Uc) C1{ Fi:1 FL:15 Fc}



static void Test_BFu1i_BFu15ll_Uc()
{
  {
    init_simple_test("BFu1i_BFu15ll_Uc");
    static STRUCT_IF_C BFu1i_BFu15ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_Uc");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_Uc, BFu1i_BFu15ll_Uc)
//============================================================================


struct  BFu1i_BFu15ll_Ui  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu15ll_Ui) C1{ Fi:1 FL:15 Fi}



static void Test_BFu1i_BFu15ll_Ui()
{
  {
    init_simple_test("BFu1i_BFu15ll_Ui");
    static STRUCT_IF_C BFu1i_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_Ui, BFu1i_BFu15ll_Ui)
//============================================================================


struct  BFu1i_BFu15ll_Ul  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu15ll_Ul) C1{ Fi:1 FL:15 FL}



static void Test_BFu1i_BFu15ll_Ul()
{
  {
    init_simple_test("BFu1i_BFu15ll_Ul");
    static STRUCT_IF_C BFu1i_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_Ul, BFu1i_BFu15ll_Ul)
//============================================================================


struct  BFu1i_BFu15ll_Us  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu15ll_Us) C1{ Fi:1 FL:15 Fs}



static void Test_BFu1i_BFu15ll_Us()
{
  {
    init_simple_test("BFu1i_BFu15ll_Us");
    static STRUCT_IF_C BFu1i_BFu15ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_Us");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_Us, BFu1i_BFu15ll_Us)
//============================================================================


struct  BFu1i_BFu15ll_Vp  {
  unsigned int v1:1;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 BFu1i_BFu15ll_Vp) C1{ Fi:1 FL:15 Fp}



static void Test_BFu1i_BFu15ll_Vp()
{
  {
    init_simple_test("BFu1i_BFu15ll_Vp");
    static STRUCT_IF_C BFu1i_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_Vp, BFu1i_BFu15ll_Vp)
//============================================================================


struct  BFu1i_BFu15s  {
  unsigned int v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu1i_BFu15s) C1{ Fi:1 Fs:15}



static void Test_BFu1i_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu15s");
    static STRUCT_IF_C BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s, BFu1i_BFu15s)
//============================================================================


struct  BFu1i_BFu15s_BFu15i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu15s_BFu15i) C1{ Fi:1 Fs:15 Fi:15}



static void Test_BFu1i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu15i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu15i, BFu1i_BFu15s_BFu15i)
//============================================================================


struct  BFu1i_BFu15s_BFu15ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu15s_BFu15ll) C1{ Fi:1 Fs:15 FL:15}



static void Test_BFu1i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu15ll, BFu1i_BFu15s_BFu15ll)
//============================================================================


struct  BFu1i_BFu15s_BFu15s  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu15s_BFu15s) C1{ Fi:1 Fs:15 Fs:15}



static void Test_BFu1i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu15s");
    static STRUCT_IF_C BFu1i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu15s, BFu1i_BFu15s_BFu15s)
//============================================================================


struct  BFu1i_BFu15s_BFu16i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu15s_BFu16i) C1{ Fi:1 Fs:15 Fi:16}



static void Test_BFu1i_BFu15s_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu16i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu16i, BFu1i_BFu15s_BFu16i)
//============================================================================


struct  BFu1i_BFu15s_BFu16ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu15s_BFu16ll) C1{ Fi:1 Fs:15 FL:16}



static void Test_BFu1i_BFu15s_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu16ll, BFu1i_BFu15s_BFu16ll)
//============================================================================


struct  BFu1i_BFu15s_BFu16s  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu15s_BFu16s) C1{ Fi:1 Fs:15 Fs:16}



static void Test_BFu1i_BFu15s_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu16s");
    static STRUCT_IF_C BFu1i_BFu15s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu16s, BFu1i_BFu15s_BFu16s)
//============================================================================


struct  BFu1i_BFu15s_BFu17i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu15s_BFu17i) C1{ Fi:1 Fs:15 Fi:17}



static void Test_BFu1i_BFu15s_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu17i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu17i, BFu1i_BFu15s_BFu17i)
//============================================================================


struct  BFu1i_BFu15s_BFu17ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu15s_BFu17ll) C1{ Fi:1 Fs:15 FL:17}



static void Test_BFu1i_BFu15s_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu17ll, BFu1i_BFu15s_BFu17ll)
//============================================================================


struct  BFu1i_BFu15s_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu15s_BFu1c) C1{ Fi:1 Fs:15 Fc:1}



static void Test_BFu1i_BFu15s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu15s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu1c, BFu1i_BFu15s_BFu1c)
//============================================================================


struct  BFu1i_BFu15s_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu15s_BFu1i) C1{ Fi:1 Fs:15 Fi:1}



static void Test_BFu1i_BFu15s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu1i, BFu1i_BFu15s_BFu1i)
//============================================================================


struct  BFu1i_BFu15s_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu15s_BFu1ll) C1{ Fi:1 Fs:15 FL:1}



static void Test_BFu1i_BFu15s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu1ll, BFu1i_BFu15s_BFu1ll)
//============================================================================


struct  BFu1i_BFu15s_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu15s_BFu1s) C1{ Fi:1 Fs:15 Fs:1}



static void Test_BFu1i_BFu15s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu15s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu1s, BFu1i_BFu15s_BFu1s)
//============================================================================


struct  BFu1i_BFu15s_BFu31i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu15s_BFu31i) C1{ Fi:1 Fs:15 Fi:31}



static void Test_BFu1i_BFu15s_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu31i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu31i, BFu1i_BFu15s_BFu31i)
//============================================================================


struct  BFu1i_BFu15s_BFu31ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu15s_BFu31ll) C1{ Fi:1 Fs:15 FL:31}



static void Test_BFu1i_BFu15s_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu31ll, BFu1i_BFu15s_BFu31ll)
//============================================================================


struct  BFu1i_BFu15s_BFu32i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu15s_BFu32i) C1{ Fi:1 Fs:15 Fi:32}



static void Test_BFu1i_BFu15s_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu32i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu32i, BFu1i_BFu15s_BFu32i)
//============================================================================


struct  BFu1i_BFu15s_BFu32ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu15s_BFu32ll) C1{ Fi:1 Fs:15 FL:32}



static void Test_BFu1i_BFu15s_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu32ll, BFu1i_BFu15s_BFu32ll)
//============================================================================


struct  BFu1i_BFu15s_BFu33  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu15s_BFu33) C1{ Fi:1 Fs:15 FL:33}



static void Test_BFu1i_BFu15s_BFu33()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu33");
    static STRUCT_IF_C BFu1i_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1i_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1i_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu33, BFu1i_BFu15s_BFu33)
//============================================================================


struct  BFu1i_BFu15s_BFu7c  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu15s_BFu7c) C1{ Fi:1 Fs:15 Fc:7}



static void Test_BFu1i_BFu15s_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu7c");
    static STRUCT_IF_C BFu1i_BFu15s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu7c, BFu1i_BFu15s_BFu7c)
//============================================================================


struct  BFu1i_BFu15s_BFu7i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu15s_BFu7i) C1{ Fi:1 Fs:15 Fi:7}



static void Test_BFu1i_BFu15s_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu7i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu7i, BFu1i_BFu15s_BFu7i)
//============================================================================


struct  BFu1i_BFu15s_BFu7ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu15s_BFu7ll) C1{ Fi:1 Fs:15 FL:7}



static void Test_BFu1i_BFu15s_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu7ll, BFu1i_BFu15s_BFu7ll)
//============================================================================


struct  BFu1i_BFu15s_BFu7s  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu15s_BFu7s) C1{ Fi:1 Fs:15 Fs:7}



static void Test_BFu1i_BFu15s_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu7s");
    static STRUCT_IF_C BFu1i_BFu15s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu7s, BFu1i_BFu15s_BFu7s)
//============================================================================


struct  BFu1i_BFu15s_BFu8c  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu15s_BFu8c) C1{ Fi:1 Fs:15 Fc:8}



static void Test_BFu1i_BFu15s_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu8c");
    static STRUCT_IF_C BFu1i_BFu15s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu8c, BFu1i_BFu15s_BFu8c)
//============================================================================


struct  BFu1i_BFu15s_BFu8i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu15s_BFu8i) C1{ Fi:1 Fs:15 Fi:8}



static void Test_BFu1i_BFu15s_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu8i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu8i, BFu1i_BFu15s_BFu8i)
//============================================================================


struct  BFu1i_BFu15s_BFu8ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu15s_BFu8ll) C1{ Fi:1 Fs:15 FL:8}



static void Test_BFu1i_BFu15s_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu8ll, BFu1i_BFu15s_BFu8ll)
//============================================================================


struct  BFu1i_BFu15s_BFu8s  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu15s_BFu8s) C1{ Fi:1 Fs:15 Fs:8}



static void Test_BFu1i_BFu15s_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu8s");
    static STRUCT_IF_C BFu1i_BFu15s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu8s, BFu1i_BFu15s_BFu8s)
//============================================================================


struct  BFu1i_BFu15s_BFu9i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu15s_BFu9i) C1{ Fi:1 Fs:15 Fi:9}



static void Test_BFu1i_BFu15s_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu9i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu9i, BFu1i_BFu15s_BFu9i)
//============================================================================


struct  BFu1i_BFu15s_BFu9ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu15s_BFu9ll) C1{ Fi:1 Fs:15 FL:9}



static void Test_BFu1i_BFu15s_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu9ll, BFu1i_BFu15s_BFu9ll)
//============================================================================


struct  BFu1i_BFu15s_BFu9s  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu15s_BFu9s) C1{ Fi:1 Fs:15 Fs:9}



static void Test_BFu1i_BFu15s_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu9s");
    static STRUCT_IF_C BFu1i_BFu15s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu9s, BFu1i_BFu15s_BFu9s)
//============================================================================


struct  BFu1i_BFu15s_C  {
  unsigned int v1:1;
  unsigned short v2:15;
  char v3;
};
//SIG(1 BFu1i_BFu15s_C) C1{ Fi:1 Fs:15 Fc}



static void Test_BFu1i_BFu15s_C()
{
  {
    init_simple_test("BFu1i_BFu15s_C");
    static STRUCT_IF_C BFu1i_BFu15s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_C");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_C");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_C");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_C, BFu1i_BFu15s_C)
//============================================================================


struct  BFu1i_BFu15s_D  {
  unsigned int v1:1;
  unsigned short v2:15;
  double v3;
};
//SIG(1 BFu1i_BFu15s_D) C1{ Fi:1 Fs:15 FL}



static void Test_BFu1i_BFu15s_D()
{
  {
    init_simple_test("BFu1i_BFu15s_D");
    static STRUCT_IF_C BFu1i_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_D");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_D");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_D, BFu1i_BFu15s_D)
//============================================================================


struct  BFu1i_BFu15s_F  {
  unsigned int v1:1;
  unsigned short v2:15;
  float v3;
};
//SIG(1 BFu1i_BFu15s_F) C1{ Fi:1 Fs:15 Fi}



static void Test_BFu1i_BFu15s_F()
{
  {
    init_simple_test("BFu1i_BFu15s_F");
    static STRUCT_IF_C BFu1i_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_F");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_F");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_F, BFu1i_BFu15s_F)
//============================================================================


struct  BFu1i_BFu15s_I  {
  unsigned int v1:1;
  unsigned short v2:15;
  int v3;
};
//SIG(1 BFu1i_BFu15s_I) C1{ Fi:1 Fs:15 Fi}



static void Test_BFu1i_BFu15s_I()
{
  {
    init_simple_test("BFu1i_BFu15s_I");
    static STRUCT_IF_C BFu1i_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_I");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_I");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_I, BFu1i_BFu15s_I)
//============================================================================


struct  BFu1i_BFu15s_Ip  {
  unsigned int v1:1;
  unsigned short v2:15;
  int *v3;
};
//SIG(1 BFu1i_BFu15s_Ip) C1{ Fi:1 Fs:15 Fp}



static void Test_BFu1i_BFu15s_Ip()
{
  {
    init_simple_test("BFu1i_BFu15s_Ip");
    static STRUCT_IF_C BFu1i_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_Ip, BFu1i_BFu15s_Ip)
//============================================================================


struct  BFu1i_BFu15s_L  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu15s_L) C1{ Fi:1 Fs:15 FL}



static void Test_BFu1i_BFu15s_L()
{
  {
    init_simple_test("BFu1i_BFu15s_L");
    static STRUCT_IF_C BFu1i_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_L");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_L");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_L, BFu1i_BFu15s_L)
//============================================================================


struct  BFu1i_BFu15s_S  {
  unsigned int v1:1;
  unsigned short v2:15;
  short v3;
};
//SIG(1 BFu1i_BFu15s_S) C1{ Fi:1 Fs:15 Fs}



static void Test_BFu1i_BFu15s_S()
{
  {
    init_simple_test("BFu1i_BFu15s_S");
    static STRUCT_IF_C BFu1i_BFu15s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_S");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_S");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_S");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_S, BFu1i_BFu15s_S)
//============================================================================


struct  BFu1i_BFu15s_Uc  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu15s_Uc) C1{ Fi:1 Fs:15 Fc}



static void Test_BFu1i_BFu15s_Uc()
{
  {
    init_simple_test("BFu1i_BFu15s_Uc");
    static STRUCT_IF_C BFu1i_BFu15s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_Uc");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_Uc, BFu1i_BFu15s_Uc)
//============================================================================


struct  BFu1i_BFu15s_Ui  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu15s_Ui) C1{ Fi:1 Fs:15 Fi}



static void Test_BFu1i_BFu15s_Ui()
{
  {
    init_simple_test("BFu1i_BFu15s_Ui");
    static STRUCT_IF_C BFu1i_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu15s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_Ui, BFu1i_BFu15s_Ui)
//============================================================================


struct  BFu1i_BFu15s_Ul  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu15s_Ul) C1{ Fi:1 Fs:15 FL}



static void Test_BFu1i_BFu15s_Ul()
{
  {
    init_simple_test("BFu1i_BFu15s_Ul");
    static STRUCT_IF_C BFu1i_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_Ul, BFu1i_BFu15s_Ul)
//============================================================================


struct  BFu1i_BFu15s_Us  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu15s_Us) C1{ Fi:1 Fs:15 Fs}



static void Test_BFu1i_BFu15s_Us()
{
  {
    init_simple_test("BFu1i_BFu15s_Us");
    static STRUCT_IF_C BFu1i_BFu15s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_Us");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_Us, BFu1i_BFu15s_Us)
//============================================================================


struct  BFu1i_BFu15s_Vp  {
  unsigned int v1:1;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 BFu1i_BFu15s_Vp) C1{ Fi:1 Fs:15 Fp}



static void Test_BFu1i_BFu15s_Vp()
{
  {
    init_simple_test("BFu1i_BFu15s_Vp");
    static STRUCT_IF_C BFu1i_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_Vp, BFu1i_BFu15s_Vp)
//============================================================================


struct  BFu1i_BFu16i  {
  unsigned int v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu1i_BFu16i) C1{ Fi:1 Fi:16}



static void Test_BFu1i_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu16i");
    static STRUCT_IF_C BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i, BFu1i_BFu16i)
//============================================================================


struct  BFu1i_BFu16i_BFu15i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu16i_BFu15i) C1{ Fi:1 Fi:16 Fi:15}



static void Test_BFu1i_BFu16i_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu15i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1i_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu15i, BFu1i_BFu16i_BFu15i)
//============================================================================


struct  BFu1i_BFu16i_BFu15ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu16i_BFu15ll) C1{ Fi:1 Fi:16 FL:15}



static void Test_BFu1i_BFu16i_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu15ll, BFu1i_BFu16i_BFu15ll)
//============================================================================


struct  BFu1i_BFu16i_BFu15s  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu16i_BFu15s) C1{ Fi:1 Fi:16 Fs:15}



static void Test_BFu1i_BFu16i_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu15s");
    static STRUCT_IF_C BFu1i_BFu16i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1i_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu15s, BFu1i_BFu16i_BFu15s)
//============================================================================


struct  BFu1i_BFu16i_BFu16i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu16i_BFu16i) C1{ Fi:1 Fi:16 Fi:16}



static void Test_BFu1i_BFu16i_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu16i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu16i, BFu1i_BFu16i_BFu16i)
//============================================================================


struct  BFu1i_BFu16i_BFu16ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu16i_BFu16ll) C1{ Fi:1 Fi:16 FL:16}



static void Test_BFu1i_BFu16i_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "BFu1i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu16ll, BFu1i_BFu16i_BFu16ll)
//============================================================================


struct  BFu1i_BFu16i_BFu16s  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu16i_BFu16s) C1{ Fi:1 Fi:16 Fs:16}



static void Test_BFu1i_BFu16i_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu16s");
    static STRUCT_IF_C BFu1i_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu16s, BFu1i_BFu16i_BFu16s)
//============================================================================


struct  BFu1i_BFu16i_BFu17i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu16i_BFu17i) C1{ Fi:1 Fi:16 Fi:17}



static void Test_BFu1i_BFu16i_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu17i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu17i, BFu1i_BFu16i_BFu17i)
//============================================================================


struct  BFu1i_BFu16i_BFu17ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu16i_BFu17ll) C1{ Fi:1 Fi:16 FL:17}



static void Test_BFu1i_BFu16i_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "BFu1i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu17ll, BFu1i_BFu16i_BFu17ll)
//============================================================================


struct  BFu1i_BFu16i_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu16i_BFu1c) C1{ Fi:1 Fi:16 Fc:1}



static void Test_BFu1i_BFu16i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu16i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1i_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu1c, BFu1i_BFu16i_BFu1c)
//============================================================================


struct  BFu1i_BFu16i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu16i_BFu1i) C1{ Fi:1 Fi:16 Fi:1}



static void Test_BFu1i_BFu16i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1i_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu1i, BFu1i_BFu16i_BFu1i)
//============================================================================


struct  BFu1i_BFu16i_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu16i_BFu1ll) C1{ Fi:1 Fi:16 FL:1}



static void Test_BFu1i_BFu16i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1i_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu1ll, BFu1i_BFu16i_BFu1ll)
//============================================================================


struct  BFu1i_BFu16i_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu16i_BFu1s) C1{ Fi:1 Fi:16 Fs:1}



static void Test_BFu1i_BFu16i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu16i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1i_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu1s, BFu1i_BFu16i_BFu1s)
//============================================================================


struct  BFu1i_BFu16i_BFu31i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu16i_BFu31i) C1{ Fi:1 Fi:16 Fi:31}



static void Test_BFu1i_BFu16i_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu31i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu31i, BFu1i_BFu16i_BFu31i)
//============================================================================


struct  BFu1i_BFu16i_BFu31ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu16i_BFu31ll) C1{ Fi:1 Fi:16 FL:31}



static void Test_BFu1i_BFu16i_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "BFu1i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu31ll, BFu1i_BFu16i_BFu31ll)
//============================================================================


struct  BFu1i_BFu16i_BFu32i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu16i_BFu32i) C1{ Fi:1 Fi:16 Fi:32}



static void Test_BFu1i_BFu16i_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu32i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu32i, BFu1i_BFu16i_BFu32i)
//============================================================================


struct  BFu1i_BFu16i_BFu32ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu16i_BFu32ll) C1{ Fi:1 Fi:16 FL:32}



static void Test_BFu1i_BFu16i_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "BFu1i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu32ll, BFu1i_BFu16i_BFu32ll)
//============================================================================


struct  BFu1i_BFu16i_BFu33  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu16i_BFu33) C1{ Fi:1 Fi:16 FL:33}



static void Test_BFu1i_BFu16i_BFu33()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu33");
    static STRUCT_IF_C BFu1i_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "BFu1i_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu33, BFu1i_BFu16i_BFu33)
//============================================================================


struct  BFu1i_BFu16i_BFu7c  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu16i_BFu7c) C1{ Fi:1 Fi:16 Fc:7}



static void Test_BFu1i_BFu16i_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu7c");
    static STRUCT_IF_C BFu1i_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1i_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu7c, BFu1i_BFu16i_BFu7c)
//============================================================================


struct  BFu1i_BFu16i_BFu7i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu16i_BFu7i) C1{ Fi:1 Fi:16 Fi:7}



static void Test_BFu1i_BFu16i_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu7i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1i_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu7i, BFu1i_BFu16i_BFu7i)
//============================================================================


struct  BFu1i_BFu16i_BFu7ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu16i_BFu7ll) C1{ Fi:1 Fi:16 FL:7}



static void Test_BFu1i_BFu16i_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu7ll, BFu1i_BFu16i_BFu7ll)
//============================================================================


struct  BFu1i_BFu16i_BFu7s  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu16i_BFu7s) C1{ Fi:1 Fi:16 Fs:7}



static void Test_BFu1i_BFu16i_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu7s");
    static STRUCT_IF_C BFu1i_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1i_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu7s, BFu1i_BFu16i_BFu7s)
//============================================================================


struct  BFu1i_BFu16i_BFu8c  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu16i_BFu8c) C1{ Fi:1 Fi:16 Fc:8}



static void Test_BFu1i_BFu16i_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu8c");
    static STRUCT_IF_C BFu1i_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu1i_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu8c, BFu1i_BFu16i_BFu8c)
//============================================================================


struct  BFu1i_BFu16i_BFu8i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu16i_BFu8i) C1{ Fi:1 Fi:16 Fi:8}



static void Test_BFu1i_BFu16i_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu8i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1i_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu8i, BFu1i_BFu16i_BFu8i)
//============================================================================


struct  BFu1i_BFu16i_BFu8ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu16i_BFu8ll) C1{ Fi:1 Fi:16 FL:8}



static void Test_BFu1i_BFu16i_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu8ll, BFu1i_BFu16i_BFu8ll)
//============================================================================


struct  BFu1i_BFu16i_BFu8s  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu16i_BFu8s) C1{ Fi:1 Fi:16 Fs:8}



static void Test_BFu1i_BFu16i_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu8s");
    static STRUCT_IF_C BFu1i_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1i_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu8s, BFu1i_BFu16i_BFu8s)
//============================================================================


struct  BFu1i_BFu16i_BFu9i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu16i_BFu9i) C1{ Fi:1 Fi:16 Fi:9}



static void Test_BFu1i_BFu16i_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu9i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1i_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu9i, BFu1i_BFu16i_BFu9i)
//============================================================================


struct  BFu1i_BFu16i_BFu9ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu16i_BFu9ll) C1{ Fi:1 Fi:16 FL:9}



static void Test_BFu1i_BFu16i_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu9ll, BFu1i_BFu16i_BFu9ll)
//============================================================================


struct  BFu1i_BFu16i_BFu9s  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu16i_BFu9s) C1{ Fi:1 Fi:16 Fs:9}



static void Test_BFu1i_BFu16i_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu9s");
    static STRUCT_IF_C BFu1i_BFu16i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1i_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu9s, BFu1i_BFu16i_BFu9s)
//============================================================================


struct  BFu1i_BFu16i_C  {
  unsigned int v1:1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 BFu1i_BFu16i_C) C1{ Fi:1 Fi:16 Fc}



static void Test_BFu1i_BFu16i_C()
{
  {
    init_simple_test("BFu1i_BFu16i_C");
    static STRUCT_IF_C BFu1i_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_C");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_C");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_C");
    check_field_offset(lv, v3, 3, "BFu1i_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_C, BFu1i_BFu16i_C)
//============================================================================


struct  BFu1i_BFu16i_D  {
  unsigned int v1:1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 BFu1i_BFu16i_D) C1{ Fi:1 Fi:16 FL}



static void Test_BFu1i_BFu16i_D()
{
  {
    init_simple_test("BFu1i_BFu16i_D");
    static STRUCT_IF_C BFu1i_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_D");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_D");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_D, BFu1i_BFu16i_D)
//============================================================================


struct  BFu1i_BFu16i_F  {
  unsigned int v1:1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 BFu1i_BFu16i_F) C1{ Fi:1 Fi:16 Fi}



static void Test_BFu1i_BFu16i_F()
{
  {
    init_simple_test("BFu1i_BFu16i_F");
    static STRUCT_IF_C BFu1i_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_F");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_F");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_F, BFu1i_BFu16i_F)
//============================================================================


struct  BFu1i_BFu16i_I  {
  unsigned int v1:1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 BFu1i_BFu16i_I) C1{ Fi:1 Fi:16 Fi}



static void Test_BFu1i_BFu16i_I()
{
  {
    init_simple_test("BFu1i_BFu16i_I");
    static STRUCT_IF_C BFu1i_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_I");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_I");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_I, BFu1i_BFu16i_I)
//============================================================================


struct  BFu1i_BFu16i_Ip  {
  unsigned int v1:1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 BFu1i_BFu16i_Ip) C1{ Fi:1 Fi:16 Fp}



static void Test_BFu1i_BFu16i_Ip()
{
  {
    init_simple_test("BFu1i_BFu16i_Ip");
    static STRUCT_IF_C BFu1i_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_Ip, BFu1i_BFu16i_Ip)
//============================================================================


struct  BFu1i_BFu16i_L  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu16i_L) C1{ Fi:1 Fi:16 FL}



static void Test_BFu1i_BFu16i_L()
{
  {
    init_simple_test("BFu1i_BFu16i_L");
    static STRUCT_IF_C BFu1i_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_L");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_L");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_L, BFu1i_BFu16i_L)
//============================================================================


struct  BFu1i_BFu16i_S  {
  unsigned int v1:1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 BFu1i_BFu16i_S) C1{ Fi:1 Fi:16 Fs}



static void Test_BFu1i_BFu16i_S()
{
  {
    init_simple_test("BFu1i_BFu16i_S");
    static STRUCT_IF_C BFu1i_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_S");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_S");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_S");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_S, BFu1i_BFu16i_S)
//============================================================================


struct  BFu1i_BFu16i_Uc  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu16i_Uc) C1{ Fi:1 Fi:16 Fc}



static void Test_BFu1i_BFu16i_Uc()
{
  {
    init_simple_test("BFu1i_BFu16i_Uc");
    static STRUCT_IF_C BFu1i_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_Uc");
    check_field_offset(lv, v3, 3, "BFu1i_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_Uc, BFu1i_BFu16i_Uc)
//============================================================================


struct  BFu1i_BFu16i_Ui  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu16i_Ui) C1{ Fi:1 Fi:16 Fi}



static void Test_BFu1i_BFu16i_Ui()
{
  {
    init_simple_test("BFu1i_BFu16i_Ui");
    static STRUCT_IF_C BFu1i_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_Ui, BFu1i_BFu16i_Ui)
//============================================================================


struct  BFu1i_BFu16i_Ul  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu16i_Ul) C1{ Fi:1 Fi:16 FL}



static void Test_BFu1i_BFu16i_Ul()
{
  {
    init_simple_test("BFu1i_BFu16i_Ul");
    static STRUCT_IF_C BFu1i_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_Ul, BFu1i_BFu16i_Ul)
//============================================================================


struct  BFu1i_BFu16i_Us  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu16i_Us) C1{ Fi:1 Fi:16 Fs}



static void Test_BFu1i_BFu16i_Us()
{
  {
    init_simple_test("BFu1i_BFu16i_Us");
    static STRUCT_IF_C BFu1i_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_Us");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_Us");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_Us");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_Us, BFu1i_BFu16i_Us)
//============================================================================


struct  BFu1i_BFu16i_Vp  {
  unsigned int v1:1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 BFu1i_BFu16i_Vp) C1{ Fi:1 Fi:16 Fp}



static void Test_BFu1i_BFu16i_Vp()
{
  {
    init_simple_test("BFu1i_BFu16i_Vp");
    static STRUCT_IF_C BFu1i_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_Vp, BFu1i_BFu16i_Vp)
//============================================================================


struct  BFu1i_BFu16ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu1i_BFu16ll) C1{ Fi:1 FL:16}



static void Test_BFu1i_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll, BFu1i_BFu16ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu15i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu16ll_BFu15i) C1{ Fi:1 FL:16 Fi:15}



static void Test_BFu1i_BFu16ll_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu15i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu15i, BFu1i_BFu16ll_BFu15i)
//============================================================================


struct  BFu1i_BFu16ll_BFu15ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu16ll_BFu15ll) C1{ Fi:1 FL:16 FL:15}



static void Test_BFu1i_BFu16ll_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu15ll, BFu1i_BFu16ll_BFu15ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu15s  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu16ll_BFu15s) C1{ Fi:1 FL:16 Fs:15}



static void Test_BFu1i_BFu16ll_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu15s");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu15s, BFu1i_BFu16ll_BFu15s)
//============================================================================


struct  BFu1i_BFu16ll_BFu16i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu16ll_BFu16i) C1{ Fi:1 FL:16 Fi:16}



static void Test_BFu1i_BFu16ll_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu16i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu16i, BFu1i_BFu16ll_BFu16i)
//============================================================================


struct  BFu1i_BFu16ll_BFu16ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu16ll_BFu16ll) C1{ Fi:1 FL:16 FL:16}



static void Test_BFu1i_BFu16ll_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "BFu1i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu16ll, BFu1i_BFu16ll_BFu16ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu16s  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu16ll_BFu16s) C1{ Fi:1 FL:16 Fs:16}



static void Test_BFu1i_BFu16ll_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu16s");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu16s, BFu1i_BFu16ll_BFu16s)
//============================================================================


struct  BFu1i_BFu16ll_BFu17i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu16ll_BFu17i) C1{ Fi:1 FL:16 Fi:17}



static void Test_BFu1i_BFu16ll_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu17i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu17i, BFu1i_BFu16ll_BFu17i)
//============================================================================


struct  BFu1i_BFu16ll_BFu17ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu16ll_BFu17ll) C1{ Fi:1 FL:16 FL:17}



static void Test_BFu1i_BFu16ll_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "BFu1i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu17ll, BFu1i_BFu16ll_BFu17ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu16ll_BFu1c) C1{ Fi:1 FL:16 Fc:1}



static void Test_BFu1i_BFu16ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1i_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu1c, BFu1i_BFu16ll_BFu1c)
//============================================================================


struct  BFu1i_BFu16ll_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu16ll_BFu1i) C1{ Fi:1 FL:16 Fi:1}



static void Test_BFu1i_BFu16ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1i_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu1i, BFu1i_BFu16ll_BFu1i)
//============================================================================


struct  BFu1i_BFu16ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu16ll_BFu1ll) C1{ Fi:1 FL:16 FL:1}



static void Test_BFu1i_BFu16ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1i_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu1ll, BFu1i_BFu16ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu16ll_BFu1s) C1{ Fi:1 FL:16 Fs:1}



static void Test_BFu1i_BFu16ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1i_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu1s, BFu1i_BFu16ll_BFu1s)
//============================================================================


struct  BFu1i_BFu16ll_BFu31i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu16ll_BFu31i) C1{ Fi:1 FL:16 Fi:31}



static void Test_BFu1i_BFu16ll_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu31i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu31i, BFu1i_BFu16ll_BFu31i)
//============================================================================


struct  BFu1i_BFu16ll_BFu31ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu16ll_BFu31ll) C1{ Fi:1 FL:16 FL:31}



static void Test_BFu1i_BFu16ll_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "BFu1i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu31ll, BFu1i_BFu16ll_BFu31ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu32i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu16ll_BFu32i) C1{ Fi:1 FL:16 Fi:32}



static void Test_BFu1i_BFu16ll_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu32i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu32i, BFu1i_BFu16ll_BFu32i)
//============================================================================


struct  BFu1i_BFu16ll_BFu32ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu16ll_BFu32ll) C1{ Fi:1 FL:16 FL:32}



static void Test_BFu1i_BFu16ll_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "BFu1i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu32ll, BFu1i_BFu16ll_BFu32ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu33  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu16ll_BFu33) C1{ Fi:1 FL:16 FL:33}



static void Test_BFu1i_BFu16ll_BFu33()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu33");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "BFu1i_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu33, BFu1i_BFu16ll_BFu33)
//============================================================================


struct  BFu1i_BFu16ll_BFu7c  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu16ll_BFu7c) C1{ Fi:1 FL:16 Fc:7}



static void Test_BFu1i_BFu16ll_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu7c");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu7c, BFu1i_BFu16ll_BFu7c)
//============================================================================


struct  BFu1i_BFu16ll_BFu7i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu16ll_BFu7i) C1{ Fi:1 FL:16 Fi:7}



static void Test_BFu1i_BFu16ll_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu7i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu7i, BFu1i_BFu16ll_BFu7i)
//============================================================================


struct  BFu1i_BFu16ll_BFu7ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu16ll_BFu7ll) C1{ Fi:1 FL:16 FL:7}



static void Test_BFu1i_BFu16ll_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu7ll, BFu1i_BFu16ll_BFu7ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu7s  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu16ll_BFu7s) C1{ Fi:1 FL:16 Fs:7}



static void Test_BFu1i_BFu16ll_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu7s");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu7s, BFu1i_BFu16ll_BFu7s)
//============================================================================


struct  BFu1i_BFu16ll_BFu8c  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu16ll_BFu8c) C1{ Fi:1 FL:16 Fc:8}



static void Test_BFu1i_BFu16ll_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu8c");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu1i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu8c, BFu1i_BFu16ll_BFu8c)
//============================================================================


struct  BFu1i_BFu16ll_BFu8i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu16ll_BFu8i) C1{ Fi:1 FL:16 Fi:8}



static void Test_BFu1i_BFu16ll_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu8i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu8i, BFu1i_BFu16ll_BFu8i)
//============================================================================


struct  BFu1i_BFu16ll_BFu8ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu16ll_BFu8ll) C1{ Fi:1 FL:16 FL:8}



static void Test_BFu1i_BFu16ll_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu8ll, BFu1i_BFu16ll_BFu8ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu8s  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu16ll_BFu8s) C1{ Fi:1 FL:16 Fs:8}



static void Test_BFu1i_BFu16ll_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu8s");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu8s, BFu1i_BFu16ll_BFu8s)
//============================================================================


struct  BFu1i_BFu16ll_BFu9i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu16ll_BFu9i) C1{ Fi:1 FL:16 Fi:9}



static void Test_BFu1i_BFu16ll_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu9i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu9i, BFu1i_BFu16ll_BFu9i)
//============================================================================


struct  BFu1i_BFu16ll_BFu9ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu16ll_BFu9ll) C1{ Fi:1 FL:16 FL:9}



static void Test_BFu1i_BFu16ll_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu9ll, BFu1i_BFu16ll_BFu9ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu9s  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu16ll_BFu9s) C1{ Fi:1 FL:16 Fs:9}



static void Test_BFu1i_BFu16ll_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu9s");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu9s, BFu1i_BFu16ll_BFu9s)
//============================================================================


struct  BFu1i_BFu16ll_C  {
  unsigned int v1:1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 BFu1i_BFu16ll_C) C1{ Fi:1 FL:16 Fc}



static void Test_BFu1i_BFu16ll_C()
{
  {
    init_simple_test("BFu1i_BFu16ll_C");
    static STRUCT_IF_C BFu1i_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_C");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_C");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_C");
    check_field_offset(lv, v3, 3, "BFu1i_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_C, BFu1i_BFu16ll_C)
//============================================================================


struct  BFu1i_BFu16ll_D  {
  unsigned int v1:1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 BFu1i_BFu16ll_D) C1{ Fi:1 FL:16 FL}



static void Test_BFu1i_BFu16ll_D()
{
  {
    init_simple_test("BFu1i_BFu16ll_D");
    static STRUCT_IF_C BFu1i_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_D");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_D");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_D, BFu1i_BFu16ll_D)
//============================================================================


struct  BFu1i_BFu16ll_F  {
  unsigned int v1:1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 BFu1i_BFu16ll_F) C1{ Fi:1 FL:16 Fi}



static void Test_BFu1i_BFu16ll_F()
{
  {
    init_simple_test("BFu1i_BFu16ll_F");
    static STRUCT_IF_C BFu1i_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_F");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_F");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_F, BFu1i_BFu16ll_F)
//============================================================================


struct  BFu1i_BFu16ll_I  {
  unsigned int v1:1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 BFu1i_BFu16ll_I) C1{ Fi:1 FL:16 Fi}



static void Test_BFu1i_BFu16ll_I()
{
  {
    init_simple_test("BFu1i_BFu16ll_I");
    static STRUCT_IF_C BFu1i_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_I");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_I");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_I, BFu1i_BFu16ll_I)
//============================================================================


struct  BFu1i_BFu16ll_Ip  {
  unsigned int v1:1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 BFu1i_BFu16ll_Ip) C1{ Fi:1 FL:16 Fp}



static void Test_BFu1i_BFu16ll_Ip()
{
  {
    init_simple_test("BFu1i_BFu16ll_Ip");
    static STRUCT_IF_C BFu1i_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_Ip, BFu1i_BFu16ll_Ip)
//============================================================================


struct  BFu1i_BFu16ll_L  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu16ll_L) C1{ Fi:1 FL:16 FL}



static void Test_BFu1i_BFu16ll_L()
{
  {
    init_simple_test("BFu1i_BFu16ll_L");
    static STRUCT_IF_C BFu1i_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_L");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_L");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_L, BFu1i_BFu16ll_L)
//============================================================================


struct  BFu1i_BFu16ll_S  {
  unsigned int v1:1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 BFu1i_BFu16ll_S) C1{ Fi:1 FL:16 Fs}



static void Test_BFu1i_BFu16ll_S()
{
  {
    init_simple_test("BFu1i_BFu16ll_S");
    static STRUCT_IF_C BFu1i_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_S");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_S");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_S");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_S, BFu1i_BFu16ll_S)
//============================================================================


struct  BFu1i_BFu16ll_Uc  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu16ll_Uc) C1{ Fi:1 FL:16 Fc}



static void Test_BFu1i_BFu16ll_Uc()
{
  {
    init_simple_test("BFu1i_BFu16ll_Uc");
    static STRUCT_IF_C BFu1i_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "BFu1i_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_Uc, BFu1i_BFu16ll_Uc)
//============================================================================


struct  BFu1i_BFu16ll_Ui  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu16ll_Ui) C1{ Fi:1 FL:16 Fi}



static void Test_BFu1i_BFu16ll_Ui()
{
  {
    init_simple_test("BFu1i_BFu16ll_Ui");
    static STRUCT_IF_C BFu1i_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_Ui, BFu1i_BFu16ll_Ui)
//============================================================================


struct  BFu1i_BFu16ll_Ul  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu16ll_Ul) C1{ Fi:1 FL:16 FL}



static void Test_BFu1i_BFu16ll_Ul()
{
  {
    init_simple_test("BFu1i_BFu16ll_Ul");
    static STRUCT_IF_C BFu1i_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_Ul, BFu1i_BFu16ll_Ul)
//============================================================================


struct  BFu1i_BFu16ll_Us  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu16ll_Us) C1{ Fi:1 FL:16 Fs}



static void Test_BFu1i_BFu16ll_Us()
{
  {
    init_simple_test("BFu1i_BFu16ll_Us");
    static STRUCT_IF_C BFu1i_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_Us");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_Us, BFu1i_BFu16ll_Us)
//============================================================================


struct  BFu1i_BFu16ll_Vp  {
  unsigned int v1:1;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 BFu1i_BFu16ll_Vp) C1{ Fi:1 FL:16 Fp}



static void Test_BFu1i_BFu16ll_Vp()
{
  {
    init_simple_test("BFu1i_BFu16ll_Vp");
    static STRUCT_IF_C BFu1i_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_Vp, BFu1i_BFu16ll_Vp)
//============================================================================


struct  BFu1i_BFu16s  {
  unsigned int v1:1;
  unsigned short v2:16;
};
//SIG(1 BFu1i_BFu16s) C1{ Fi:1 Fs:16}



static void Test_BFu1i_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu16s");
    static STRUCT_IF_C BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s, BFu1i_BFu16s)
//============================================================================


struct  BFu1i_BFu16s_BFu15i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu16s_BFu15i) C1{ Fi:1 Fs:16 Fi:15}



static void Test_BFu1i_BFu16s_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu15i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu15i, BFu1i_BFu16s_BFu15i)
//============================================================================


struct  BFu1i_BFu16s_BFu15ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu16s_BFu15ll) C1{ Fi:1 Fs:16 FL:15}



static void Test_BFu1i_BFu16s_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu15ll, BFu1i_BFu16s_BFu15ll)
//============================================================================


struct  BFu1i_BFu16s_BFu15s  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu16s_BFu15s) C1{ Fi:1 Fs:16 Fs:15}



static void Test_BFu1i_BFu16s_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu15s");
    static STRUCT_IF_C BFu1i_BFu16s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu15s, BFu1i_BFu16s_BFu15s)
//============================================================================


struct  BFu1i_BFu16s_BFu16i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu16s_BFu16i) C1{ Fi:1 Fs:16 Fi:16}



static void Test_BFu1i_BFu16s_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu16i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu16i, BFu1i_BFu16s_BFu16i)
//============================================================================


struct  BFu1i_BFu16s_BFu16ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu16s_BFu16ll) C1{ Fi:1 Fs:16 FL:16}



static void Test_BFu1i_BFu16s_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu16ll, BFu1i_BFu16s_BFu16ll)
//============================================================================


struct  BFu1i_BFu16s_BFu16s  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu16s_BFu16s) C1{ Fi:1 Fs:16 Fs:16}



static void Test_BFu1i_BFu16s_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu16s");
    static STRUCT_IF_C BFu1i_BFu16s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu16s, BFu1i_BFu16s_BFu16s)
//============================================================================


struct  BFu1i_BFu16s_BFu17i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu16s_BFu17i) C1{ Fi:1 Fs:16 Fi:17}



static void Test_BFu1i_BFu16s_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu17i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu17i, BFu1i_BFu16s_BFu17i)
//============================================================================


struct  BFu1i_BFu16s_BFu17ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu16s_BFu17ll) C1{ Fi:1 Fs:16 FL:17}



static void Test_BFu1i_BFu16s_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu17ll, BFu1i_BFu16s_BFu17ll)
//============================================================================


struct  BFu1i_BFu16s_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu16s_BFu1c) C1{ Fi:1 Fs:16 Fc:1}



static void Test_BFu1i_BFu16s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu16s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu1c, BFu1i_BFu16s_BFu1c)
//============================================================================


struct  BFu1i_BFu16s_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu16s_BFu1i) C1{ Fi:1 Fs:16 Fi:1}



static void Test_BFu1i_BFu16s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu1i, BFu1i_BFu16s_BFu1i)
//============================================================================


struct  BFu1i_BFu16s_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu16s_BFu1ll) C1{ Fi:1 Fs:16 FL:1}



static void Test_BFu1i_BFu16s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu1ll, BFu1i_BFu16s_BFu1ll)
//============================================================================


struct  BFu1i_BFu16s_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu16s_BFu1s) C1{ Fi:1 Fs:16 Fs:1}



static void Test_BFu1i_BFu16s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu16s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu1s, BFu1i_BFu16s_BFu1s)
//============================================================================


struct  BFu1i_BFu16s_BFu31i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu16s_BFu31i) C1{ Fi:1 Fs:16 Fi:31}



static void Test_BFu1i_BFu16s_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu31i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu31i, BFu1i_BFu16s_BFu31i)
//============================================================================


struct  BFu1i_BFu16s_BFu31ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu16s_BFu31ll) C1{ Fi:1 Fs:16 FL:31}



static void Test_BFu1i_BFu16s_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu31ll, BFu1i_BFu16s_BFu31ll)
//============================================================================


struct  BFu1i_BFu16s_BFu32i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu16s_BFu32i) C1{ Fi:1 Fs:16 Fi:32}



static void Test_BFu1i_BFu16s_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu32i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu32i, BFu1i_BFu16s_BFu32i)
//============================================================================


struct  BFu1i_BFu16s_BFu32ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu16s_BFu32ll) C1{ Fi:1 Fs:16 FL:32}



static void Test_BFu1i_BFu16s_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu32ll, BFu1i_BFu16s_BFu32ll)
//============================================================================


struct  BFu1i_BFu16s_BFu33  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu16s_BFu33) C1{ Fi:1 Fs:16 FL:33}



static void Test_BFu1i_BFu16s_BFu33()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu33");
    static STRUCT_IF_C BFu1i_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu1i_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1i_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu33, BFu1i_BFu16s_BFu33)
//============================================================================


struct  BFu1i_BFu16s_BFu7c  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu16s_BFu7c) C1{ Fi:1 Fs:16 Fc:7}



static void Test_BFu1i_BFu16s_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu7c");
    static STRUCT_IF_C BFu1i_BFu16s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu7c, BFu1i_BFu16s_BFu7c)
//============================================================================


struct  BFu1i_BFu16s_BFu7i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu16s_BFu7i) C1{ Fi:1 Fs:16 Fi:7}



static void Test_BFu1i_BFu16s_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu7i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu7i, BFu1i_BFu16s_BFu7i)
//============================================================================


struct  BFu1i_BFu16s_BFu7ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu16s_BFu7ll) C1{ Fi:1 Fs:16 FL:7}



static void Test_BFu1i_BFu16s_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu7ll, BFu1i_BFu16s_BFu7ll)
//============================================================================


struct  BFu1i_BFu16s_BFu7s  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu16s_BFu7s) C1{ Fi:1 Fs:16 Fs:7}



static void Test_BFu1i_BFu16s_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu7s");
    static STRUCT_IF_C BFu1i_BFu16s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu7s, BFu1i_BFu16s_BFu7s)
//============================================================================


struct  BFu1i_BFu16s_BFu8c  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu16s_BFu8c) C1{ Fi:1 Fs:16 Fc:8}



static void Test_BFu1i_BFu16s_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu8c");
    static STRUCT_IF_C BFu1i_BFu16s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu8c, BFu1i_BFu16s_BFu8c)
//============================================================================


struct  BFu1i_BFu16s_BFu8i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu16s_BFu8i) C1{ Fi:1 Fs:16 Fi:8}



static void Test_BFu1i_BFu16s_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu8i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu8i, BFu1i_BFu16s_BFu8i)
//============================================================================


struct  BFu1i_BFu16s_BFu8ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu16s_BFu8ll) C1{ Fi:1 Fs:16 FL:8}



static void Test_BFu1i_BFu16s_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu8ll, BFu1i_BFu16s_BFu8ll)
//============================================================================


struct  BFu1i_BFu16s_BFu8s  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu16s_BFu8s) C1{ Fi:1 Fs:16 Fs:8}



static void Test_BFu1i_BFu16s_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu8s");
    static STRUCT_IF_C BFu1i_BFu16s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu8s, BFu1i_BFu16s_BFu8s)
//============================================================================


struct  BFu1i_BFu16s_BFu9i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu16s_BFu9i) C1{ Fi:1 Fs:16 Fi:9}



static void Test_BFu1i_BFu16s_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu9i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu9i, BFu1i_BFu16s_BFu9i)
//============================================================================


struct  BFu1i_BFu16s_BFu9ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu16s_BFu9ll) C1{ Fi:1 Fs:16 FL:9}



static void Test_BFu1i_BFu16s_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu9ll, BFu1i_BFu16s_BFu9ll)
//============================================================================


struct  BFu1i_BFu16s_BFu9s  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu16s_BFu9s) C1{ Fi:1 Fs:16 Fs:9}



static void Test_BFu1i_BFu16s_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu9s");
    static STRUCT_IF_C BFu1i_BFu16s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu9s, BFu1i_BFu16s_BFu9s)
//============================================================================


struct  BFu1i_BFu16s_C  {
  unsigned int v1:1;
  unsigned short v2:16;
  char v3;
};
//SIG(1 BFu1i_BFu16s_C) C1{ Fi:1 Fs:16 Fc}



static void Test_BFu1i_BFu16s_C()
{
  {
    init_simple_test("BFu1i_BFu16s_C");
    static STRUCT_IF_C BFu1i_BFu16s_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_C");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_C, BFu1i_BFu16s_C)
//============================================================================


struct  BFu1i_BFu16s_D  {
  unsigned int v1:1;
  unsigned short v2:16;
  double v3;
};
//SIG(1 BFu1i_BFu16s_D) C1{ Fi:1 Fs:16 FL}



static void Test_BFu1i_BFu16s_D()
{
  {
    init_simple_test("BFu1i_BFu16s_D");
    static STRUCT_IF_C BFu1i_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_D, BFu1i_BFu16s_D)
//============================================================================


struct  BFu1i_BFu16s_F  {
  unsigned int v1:1;
  unsigned short v2:16;
  float v3;
};
//SIG(1 BFu1i_BFu16s_F) C1{ Fi:1 Fs:16 Fi}



static void Test_BFu1i_BFu16s_F()
{
  {
    init_simple_test("BFu1i_BFu16s_F");
    static STRUCT_IF_C BFu1i_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_F, BFu1i_BFu16s_F)
//============================================================================


struct  BFu1i_BFu16s_I  {
  unsigned int v1:1;
  unsigned short v2:16;
  int v3;
};
//SIG(1 BFu1i_BFu16s_I) C1{ Fi:1 Fs:16 Fi}



static void Test_BFu1i_BFu16s_I()
{
  {
    init_simple_test("BFu1i_BFu16s_I");
    static STRUCT_IF_C BFu1i_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_I, BFu1i_BFu16s_I)
//============================================================================


struct  BFu1i_BFu16s_Ip  {
  unsigned int v1:1;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 BFu1i_BFu16s_Ip) C1{ Fi:1 Fs:16 Fp}



static void Test_BFu1i_BFu16s_Ip()
{
  {
    init_simple_test("BFu1i_BFu16s_Ip");
    static STRUCT_IF_C BFu1i_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_Ip, BFu1i_BFu16s_Ip)
//============================================================================


struct  BFu1i_BFu16s_L  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu16s_L) C1{ Fi:1 Fs:16 FL}



static void Test_BFu1i_BFu16s_L()
{
  {
    init_simple_test("BFu1i_BFu16s_L");
    static STRUCT_IF_C BFu1i_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_L, BFu1i_BFu16s_L)
//============================================================================


struct  BFu1i_BFu16s_S  {
  unsigned int v1:1;
  unsigned short v2:16;
  short v3;
};
//SIG(1 BFu1i_BFu16s_S) C1{ Fi:1 Fs:16 Fs}



static void Test_BFu1i_BFu16s_S()
{
  {
    init_simple_test("BFu1i_BFu16s_S");
    static STRUCT_IF_C BFu1i_BFu16s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_S");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_S, BFu1i_BFu16s_S)
//============================================================================


struct  BFu1i_BFu16s_Uc  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu16s_Uc) C1{ Fi:1 Fs:16 Fc}



static void Test_BFu1i_BFu16s_Uc()
{
  {
    init_simple_test("BFu1i_BFu16s_Uc");
    static STRUCT_IF_C BFu1i_BFu16s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_Uc");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_Uc, BFu1i_BFu16s_Uc)
//============================================================================


struct  BFu1i_BFu16s_Ui  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu16s_Ui) C1{ Fi:1 Fs:16 Fi}



static void Test_BFu1i_BFu16s_Ui()
{
  {
    init_simple_test("BFu1i_BFu16s_Ui");
    static STRUCT_IF_C BFu1i_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_Ui, BFu1i_BFu16s_Ui)
//============================================================================


struct  BFu1i_BFu16s_Ul  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu16s_Ul) C1{ Fi:1 Fs:16 FL}



static void Test_BFu1i_BFu16s_Ul()
{
  {
    init_simple_test("BFu1i_BFu16s_Ul");
    static STRUCT_IF_C BFu1i_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_Ul, BFu1i_BFu16s_Ul)
//============================================================================


struct  BFu1i_BFu16s_Us  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu16s_Us) C1{ Fi:1 Fs:16 Fs}



static void Test_BFu1i_BFu16s_Us()
{
  {
    init_simple_test("BFu1i_BFu16s_Us");
    static STRUCT_IF_C BFu1i_BFu16s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_Us");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_Us, BFu1i_BFu16s_Us)
//============================================================================


struct  BFu1i_BFu16s_Vp  {
  unsigned int v1:1;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 BFu1i_BFu16s_Vp) C1{ Fi:1 Fs:16 Fp}



static void Test_BFu1i_BFu16s_Vp()
{
  {
    init_simple_test("BFu1i_BFu16s_Vp");
    static STRUCT_IF_C BFu1i_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_Vp, BFu1i_BFu16s_Vp)
//============================================================================


struct  BFu1i_BFu17i  {
  unsigned int v1:1;
  unsigned int v2:17;
};
//SIG(1 BFu1i_BFu17i) C1{ Fi:1 Fi:17}



static void Test_BFu1i_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu17i");
    static STRUCT_IF_C BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i, BFu1i_BFu17i)
//============================================================================


struct  BFu1i_BFu17i_BFu15i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu17i_BFu15i) C1{ Fi:1 Fi:17 Fi:15}



static void Test_BFu1i_BFu17i_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu15i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu15i, BFu1i_BFu17i_BFu15i)
//============================================================================


struct  BFu1i_BFu17i_BFu15ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu17i_BFu15ll) C1{ Fi:1 Fi:17 FL:15}



static void Test_BFu1i_BFu17i_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 2, 15, 1, "BFu1i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu15ll, BFu1i_BFu17i_BFu15ll)
//============================================================================


struct  BFu1i_BFu17i_BFu15s  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu17i_BFu15s) C1{ Fi:1 Fi:17 Fs:15}



static void Test_BFu1i_BFu17i_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu15s");
    static STRUCT_IF_C BFu1i_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu15s, BFu1i_BFu17i_BFu15s)
//============================================================================


struct  BFu1i_BFu17i_BFu16i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu17i_BFu16i) C1{ Fi:1 Fi:17 Fi:16}



static void Test_BFu1i_BFu17i_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu16i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu16i, BFu1i_BFu17i_BFu16i)
//============================================================================


struct  BFu1i_BFu17i_BFu16ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu17i_BFu16ll) C1{ Fi:1 Fi:17 FL:16}



static void Test_BFu1i_BFu17i_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 2, 16, 1, "BFu1i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu16ll, BFu1i_BFu17i_BFu16ll)
//============================================================================


struct  BFu1i_BFu17i_BFu16s  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu17i_BFu16s) C1{ Fi:1 Fi:17 Fs:16}



static void Test_BFu1i_BFu17i_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu16s");
    static STRUCT_IF_C BFu1i_BFu17i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu16s, BFu1i_BFu17i_BFu16s)
//============================================================================


struct  BFu1i_BFu17i_BFu17i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu17i_BFu17i) C1{ Fi:1 Fi:17 Fi:17}



static void Test_BFu1i_BFu17i_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu17i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu17i, BFu1i_BFu17i_BFu17i)
//============================================================================


struct  BFu1i_BFu17i_BFu17ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu17i_BFu17ll) C1{ Fi:1 Fi:17 FL:17}



static void Test_BFu1i_BFu17i_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 2, 17, 1, "BFu1i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu17ll, BFu1i_BFu17i_BFu17ll)
//============================================================================


struct  BFu1i_BFu17i_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu17i_BFu1c) C1{ Fi:1 Fi:17 Fc:1}



static void Test_BFu1i_BFu17i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 2, 2, 1, 1, "BFu1i_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu1c, BFu1i_BFu17i_BFu1c)
//============================================================================


struct  BFu1i_BFu17i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu17i_BFu1i) C1{ Fi:1 Fi:17 Fi:1}



static void Test_BFu1i_BFu17i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 2, 2, 1, 1, "BFu1i_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu1i, BFu1i_BFu17i_BFu1i)
//============================================================================


struct  BFu1i_BFu17i_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu17i_BFu1ll) C1{ Fi:1 Fi:17 FL:1}



static void Test_BFu1i_BFu17i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 2, 1, 1, "BFu1i_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu1ll, BFu1i_BFu17i_BFu1ll)
//============================================================================


struct  BFu1i_BFu17i_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu17i_BFu1s) C1{ Fi:1 Fi:17 Fs:1}



static void Test_BFu1i_BFu17i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 2, 2, 1, 1, "BFu1i_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu1s, BFu1i_BFu17i_BFu1s)
//============================================================================


struct  BFu1i_BFu17i_BFu31i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu17i_BFu31i) C1{ Fi:1 Fi:17 Fi:31}



static void Test_BFu1i_BFu17i_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu31i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu31i, BFu1i_BFu17i_BFu31i)
//============================================================================


struct  BFu1i_BFu17i_BFu31ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu17i_BFu31ll) C1{ Fi:1 Fi:17 FL:31}



static void Test_BFu1i_BFu17i_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 2, 31, 1, "BFu1i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 2, 31, hide_ull(1LL<<30), "BFu1i_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu31ll, BFu1i_BFu17i_BFu31ll)
//============================================================================


struct  BFu1i_BFu17i_BFu32i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu17i_BFu32i) C1{ Fi:1 Fi:17 Fi:32}



static void Test_BFu1i_BFu17i_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu32i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu32i, BFu1i_BFu17i_BFu32i)
//============================================================================


struct  BFu1i_BFu17i_BFu32ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu17i_BFu32ll) C1{ Fi:1 Fi:17 FL:32}



static void Test_BFu1i_BFu17i_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 2, 32, 1, "BFu1i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 2, 32, hide_ull(1LL<<31), "BFu1i_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu32ll, BFu1i_BFu17i_BFu32ll)
//============================================================================


struct  BFu1i_BFu17i_BFu33  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu17i_BFu33) C1{ Fi:1 Fi:17 FL:33}



static void Test_BFu1i_BFu17i_BFu33()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu33");
    static STRUCT_IF_C BFu1i_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 2, 2, 33, 1, "BFu1i_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 2, 2, 33, hide_ull(1LL<<32), "BFu1i_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu33, BFu1i_BFu17i_BFu33)
//============================================================================


struct  BFu1i_BFu17i_BFu7c  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu17i_BFu7c) C1{ Fi:1 Fi:17 Fc:7}



static void Test_BFu1i_BFu17i_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu7c");
    static STRUCT_IF_C BFu1i_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu1i_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu7c, BFu1i_BFu17i_BFu7c)
//============================================================================


struct  BFu1i_BFu17i_BFu7i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu17i_BFu7i) C1{ Fi:1 Fi:17 Fi:7}



static void Test_BFu1i_BFu17i_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu7i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 2, 2, 7, 1, "BFu1i_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 2, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu7i, BFu1i_BFu17i_BFu7i)
//============================================================================


struct  BFu1i_BFu17i_BFu7ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu17i_BFu7ll) C1{ Fi:1 Fi:17 FL:7}



static void Test_BFu1i_BFu17i_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 2, 7, 1, "BFu1i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu7ll, BFu1i_BFu17i_BFu7ll)
//============================================================================


struct  BFu1i_BFu17i_BFu7s  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu17i_BFu7s) C1{ Fi:1 Fi:17 Fs:7}



static void Test_BFu1i_BFu17i_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu7s");
    static STRUCT_IF_C BFu1i_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 2, 2, 7, 1, "BFu1i_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 2, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu7s, BFu1i_BFu17i_BFu7s)
//============================================================================


struct  BFu1i_BFu17i_BFu8c  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu17i_BFu8c) C1{ Fi:1 Fi:17 Fc:8}



static void Test_BFu1i_BFu17i_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu8c");
    static STRUCT_IF_C BFu1i_BFu17i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu1i_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu8c, BFu1i_BFu17i_BFu8c)
//============================================================================


struct  BFu1i_BFu17i_BFu8i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu17i_BFu8i) C1{ Fi:1 Fi:17 Fi:8}



static void Test_BFu1i_BFu17i_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu8i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 2, 2, 8, 1, "BFu1i_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 2, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu8i, BFu1i_BFu17i_BFu8i)
//============================================================================


struct  BFu1i_BFu17i_BFu8ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu17i_BFu8ll) C1{ Fi:1 Fi:17 FL:8}



static void Test_BFu1i_BFu17i_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 2, 8, 1, "BFu1i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu8ll, BFu1i_BFu17i_BFu8ll)
//============================================================================


struct  BFu1i_BFu17i_BFu8s  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu17i_BFu8s) C1{ Fi:1 Fi:17 Fs:8}



static void Test_BFu1i_BFu17i_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu8s");
    static STRUCT_IF_C BFu1i_BFu17i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 2, 2, 8, 1, "BFu1i_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 2, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu8s, BFu1i_BFu17i_BFu8s)
//============================================================================


struct  BFu1i_BFu17i_BFu9i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu17i_BFu9i) C1{ Fi:1 Fi:17 Fi:9}



static void Test_BFu1i_BFu17i_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu9i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFu1i_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu9i, BFu1i_BFu17i_BFu9i)
//============================================================================


struct  BFu1i_BFu17i_BFu9ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu17i_BFu9ll) C1{ Fi:1 Fi:17 FL:9}



static void Test_BFu1i_BFu17i_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFu1i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu9ll, BFu1i_BFu17i_BFu9ll)
//============================================================================


struct  BFu1i_BFu17i_BFu9s  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu17i_BFu9s) C1{ Fi:1 Fi:17 Fs:9}



static void Test_BFu1i_BFu17i_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu9s");
    static STRUCT_IF_C BFu1i_BFu17i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFu1i_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu9s, BFu1i_BFu17i_BFu9s)
//============================================================================


struct  BFu1i_BFu17i_C  {
  unsigned int v1:1;
  unsigned int v2:17;
  char v3;
};
//SIG(1 BFu1i_BFu17i_C) C1{ Fi:1 Fi:17 Fc}



static void Test_BFu1i_BFu17i_C()
{
  {
    init_simple_test("BFu1i_BFu17i_C");
    static STRUCT_IF_C BFu1i_BFu17i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_C");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_C");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_C");
    check_field_offset(lv, v3, 3, "BFu1i_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_C, BFu1i_BFu17i_C)
//============================================================================


struct  BFu1i_BFu17i_D  {
  unsigned int v1:1;
  unsigned int v2:17;
  double v3;
};
//SIG(1 BFu1i_BFu17i_D) C1{ Fi:1 Fi:17 FL}



static void Test_BFu1i_BFu17i_D()
{
  {
    init_simple_test("BFu1i_BFu17i_D");
    static STRUCT_IF_C BFu1i_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_D");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_D");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_D, BFu1i_BFu17i_D)
//============================================================================


struct  BFu1i_BFu17i_F  {
  unsigned int v1:1;
  unsigned int v2:17;
  float v3;
};
//SIG(1 BFu1i_BFu17i_F) C1{ Fi:1 Fi:17 Fi}



static void Test_BFu1i_BFu17i_F()
{
  {
    init_simple_test("BFu1i_BFu17i_F");
    static STRUCT_IF_C BFu1i_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_F");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_F");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_F, BFu1i_BFu17i_F)
//============================================================================


struct  BFu1i_BFu17i_I  {
  unsigned int v1:1;
  unsigned int v2:17;
  int v3;
};
//SIG(1 BFu1i_BFu17i_I) C1{ Fi:1 Fi:17 Fi}



static void Test_BFu1i_BFu17i_I()
{
  {
    init_simple_test("BFu1i_BFu17i_I");
    static STRUCT_IF_C BFu1i_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_I");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_I");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_I, BFu1i_BFu17i_I)
//============================================================================


struct  BFu1i_BFu17i_Ip  {
  unsigned int v1:1;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 BFu1i_BFu17i_Ip) C1{ Fi:1 Fi:17 Fp}



static void Test_BFu1i_BFu17i_Ip()
{
  {
    init_simple_test("BFu1i_BFu17i_Ip");
    static STRUCT_IF_C BFu1i_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_Ip, BFu1i_BFu17i_Ip)
//============================================================================


struct  BFu1i_BFu17i_L  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu17i_L) C1{ Fi:1 Fi:17 FL}



static void Test_BFu1i_BFu17i_L()
{
  {
    init_simple_test("BFu1i_BFu17i_L");
    static STRUCT_IF_C BFu1i_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_L");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_L");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_L, BFu1i_BFu17i_L)
//============================================================================


struct  BFu1i_BFu17i_S  {
  unsigned int v1:1;
  unsigned int v2:17;
  short v3;
};
//SIG(1 BFu1i_BFu17i_S) C1{ Fi:1 Fi:17 Fs}



static void Test_BFu1i_BFu17i_S()
{
  {
    init_simple_test("BFu1i_BFu17i_S");
    static STRUCT_IF_C BFu1i_BFu17i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_S");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_S");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_S");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_S, BFu1i_BFu17i_S)
//============================================================================


struct  BFu1i_BFu17i_Uc  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu17i_Uc) C1{ Fi:1 Fi:17 Fc}



static void Test_BFu1i_BFu17i_Uc()
{
  {
    init_simple_test("BFu1i_BFu17i_Uc");
    static STRUCT_IF_C BFu1i_BFu17i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_Uc");
    check_field_offset(lv, v3, 3, "BFu1i_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_Uc, BFu1i_BFu17i_Uc)
//============================================================================


struct  BFu1i_BFu17i_Ui  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu17i_Ui) C1{ Fi:1 Fi:17 Fi}



static void Test_BFu1i_BFu17i_Ui()
{
  {
    init_simple_test("BFu1i_BFu17i_Ui");
    static STRUCT_IF_C BFu1i_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_Ui, BFu1i_BFu17i_Ui)
//============================================================================


struct  BFu1i_BFu17i_Ul  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu17i_Ul) C1{ Fi:1 Fi:17 FL}



static void Test_BFu1i_BFu17i_Ul()
{
  {
    init_simple_test("BFu1i_BFu17i_Ul");
    static STRUCT_IF_C BFu1i_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_Ul, BFu1i_BFu17i_Ul)
//============================================================================


struct  BFu1i_BFu17i_Us  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu17i_Us) C1{ Fi:1 Fi:17 Fs}



static void Test_BFu1i_BFu17i_Us()
{
  {
    init_simple_test("BFu1i_BFu17i_Us");
    static STRUCT_IF_C BFu1i_BFu17i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_Us");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_Us");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_Us");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_Us, BFu1i_BFu17i_Us)
//============================================================================


struct  BFu1i_BFu17i_Vp  {
  unsigned int v1:1;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 BFu1i_BFu17i_Vp) C1{ Fi:1 Fi:17 Fp}



static void Test_BFu1i_BFu17i_Vp()
{
  {
    init_simple_test("BFu1i_BFu17i_Vp");
    static STRUCT_IF_C BFu1i_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_Vp, BFu1i_BFu17i_Vp)
//============================================================================


struct  BFu1i_BFu17ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
};
//SIG(1 BFu1i_BFu17ll) C1{ Fi:1 FL:17}



static void Test_BFu1i_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll, BFu1i_BFu17ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu15i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu17ll_BFu15i) C1{ Fi:1 FL:17 Fi:15}



static void Test_BFu1i_BFu17ll_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu15i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu15i, BFu1i_BFu17ll_BFu15i)
//============================================================================


struct  BFu1i_BFu17ll_BFu15ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu17ll_BFu15ll) C1{ Fi:1 FL:17 FL:15}



static void Test_BFu1i_BFu17ll_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 2, 15, 1, "BFu1i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu15ll, BFu1i_BFu17ll_BFu15ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu15s  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu17ll_BFu15s) C1{ Fi:1 FL:17 Fs:15}



static void Test_BFu1i_BFu17ll_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu15s");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu15s, BFu1i_BFu17ll_BFu15s)
//============================================================================


struct  BFu1i_BFu17ll_BFu16i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu17ll_BFu16i) C1{ Fi:1 FL:17 Fi:16}



static void Test_BFu1i_BFu17ll_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu16i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu16i, BFu1i_BFu17ll_BFu16i)
//============================================================================


struct  BFu1i_BFu17ll_BFu16ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu17ll_BFu16ll) C1{ Fi:1 FL:17 FL:16}



static void Test_BFu1i_BFu17ll_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 2, 16, 1, "BFu1i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu16ll, BFu1i_BFu17ll_BFu16ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu16s  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu17ll_BFu16s) C1{ Fi:1 FL:17 Fs:16}



static void Test_BFu1i_BFu17ll_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu16s");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu16s, BFu1i_BFu17ll_BFu16s)
//============================================================================


struct  BFu1i_BFu17ll_BFu17i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu17ll_BFu17i) C1{ Fi:1 FL:17 Fi:17}



static void Test_BFu1i_BFu17ll_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu17i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu17i, BFu1i_BFu17ll_BFu17i)
//============================================================================


struct  BFu1i_BFu17ll_BFu17ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu17ll_BFu17ll) C1{ Fi:1 FL:17 FL:17}



static void Test_BFu1i_BFu17ll_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 2, 17, 1, "BFu1i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu17ll, BFu1i_BFu17ll_BFu17ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu17ll_BFu1c) C1{ Fi:1 FL:17 Fc:1}



static void Test_BFu1i_BFu17ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 2, 1, 1, "BFu1i_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu1c, BFu1i_BFu17ll_BFu1c)
//============================================================================


struct  BFu1i_BFu17ll_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu17ll_BFu1i) C1{ Fi:1 FL:17 Fi:1}



static void Test_BFu1i_BFu17ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 2, 1, 1, "BFu1i_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu1i, BFu1i_BFu17ll_BFu1i)
//============================================================================


struct  BFu1i_BFu17ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu17ll_BFu1ll) C1{ Fi:1 FL:17 FL:1}



static void Test_BFu1i_BFu17ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 2, 1, 1, "BFu1i_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu1ll, BFu1i_BFu17ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu17ll_BFu1s) C1{ Fi:1 FL:17 Fs:1}



static void Test_BFu1i_BFu17ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 2, 1, 1, "BFu1i_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu1s, BFu1i_BFu17ll_BFu1s)
//============================================================================


struct  BFu1i_BFu17ll_BFu31i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu17ll_BFu31i) C1{ Fi:1 FL:17 Fi:31}



static void Test_BFu1i_BFu17ll_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu31i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu31i, BFu1i_BFu17ll_BFu31i)
//============================================================================


struct  BFu1i_BFu17ll_BFu31ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu17ll_BFu31ll) C1{ Fi:1 FL:17 FL:31}



static void Test_BFu1i_BFu17ll_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 2, 31, 1, "BFu1i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 2, 31, hide_ull(1LL<<30), "BFu1i_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu31ll, BFu1i_BFu17ll_BFu31ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu32i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu17ll_BFu32i) C1{ Fi:1 FL:17 Fi:32}



static void Test_BFu1i_BFu17ll_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu32i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu32i, BFu1i_BFu17ll_BFu32i)
//============================================================================


struct  BFu1i_BFu17ll_BFu32ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu17ll_BFu32ll) C1{ Fi:1 FL:17 FL:32}



static void Test_BFu1i_BFu17ll_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 2, 32, 1, "BFu1i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 2, 32, hide_ull(1LL<<31), "BFu1i_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu32ll, BFu1i_BFu17ll_BFu32ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu33  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu17ll_BFu33) C1{ Fi:1 FL:17 FL:33}



static void Test_BFu1i_BFu17ll_BFu33()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu33");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 2, 2, 33, 1, "BFu1i_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 2, 2, 33, hide_ull(1LL<<32), "BFu1i_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu33, BFu1i_BFu17ll_BFu33)
//============================================================================


struct  BFu1i_BFu17ll_BFu7c  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu17ll_BFu7c) C1{ Fi:1 FL:17 Fc:7}



static void Test_BFu1i_BFu17ll_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu7c");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu1i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu7c, BFu1i_BFu17ll_BFu7c)
//============================================================================


struct  BFu1i_BFu17ll_BFu7i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu17ll_BFu7i) C1{ Fi:1 FL:17 Fi:7}



static void Test_BFu1i_BFu17ll_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu7i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 2, 7, 1, "BFu1i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu7i, BFu1i_BFu17ll_BFu7i)
//============================================================================


struct  BFu1i_BFu17ll_BFu7ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu17ll_BFu7ll) C1{ Fi:1 FL:17 FL:7}



static void Test_BFu1i_BFu17ll_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 2, 7, 1, "BFu1i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu7ll, BFu1i_BFu17ll_BFu7ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu7s  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu17ll_BFu7s) C1{ Fi:1 FL:17 Fs:7}



static void Test_BFu1i_BFu17ll_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu7s");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 2, 7, 1, "BFu1i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu7s, BFu1i_BFu17ll_BFu7s)
//============================================================================


struct  BFu1i_BFu17ll_BFu8c  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu17ll_BFu8c) C1{ Fi:1 FL:17 Fc:8}



static void Test_BFu1i_BFu17ll_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu8c");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu1i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu8c, BFu1i_BFu17ll_BFu8c)
//============================================================================


struct  BFu1i_BFu17ll_BFu8i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu17ll_BFu8i) C1{ Fi:1 FL:17 Fi:8}



static void Test_BFu1i_BFu17ll_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu8i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 2, 8, 1, "BFu1i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu8i, BFu1i_BFu17ll_BFu8i)
//============================================================================


struct  BFu1i_BFu17ll_BFu8ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu17ll_BFu8ll) C1{ Fi:1 FL:17 FL:8}



static void Test_BFu1i_BFu17ll_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 2, 8, 1, "BFu1i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu8ll, BFu1i_BFu17ll_BFu8ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu8s  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu17ll_BFu8s) C1{ Fi:1 FL:17 Fs:8}



static void Test_BFu1i_BFu17ll_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu8s");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 2, 8, 1, "BFu1i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu8s, BFu1i_BFu17ll_BFu8s)
//============================================================================


struct  BFu1i_BFu17ll_BFu9i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu17ll_BFu9i) C1{ Fi:1 FL:17 Fi:9}



static void Test_BFu1i_BFu17ll_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu9i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFu1i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu9i, BFu1i_BFu17ll_BFu9i)
//============================================================================


struct  BFu1i_BFu17ll_BFu9ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu17ll_BFu9ll) C1{ Fi:1 FL:17 FL:9}



static void Test_BFu1i_BFu17ll_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFu1i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu9ll, BFu1i_BFu17ll_BFu9ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu9s  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu17ll_BFu9s) C1{ Fi:1 FL:17 Fs:9}



static void Test_BFu1i_BFu17ll_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu9s");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFu1i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu9s, BFu1i_BFu17ll_BFu9s)
//============================================================================


struct  BFu1i_BFu17ll_C  {
  unsigned int v1:1;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 BFu1i_BFu17ll_C) C1{ Fi:1 FL:17 Fc}



static void Test_BFu1i_BFu17ll_C()
{
  {
    init_simple_test("BFu1i_BFu17ll_C");
    static STRUCT_IF_C BFu1i_BFu17ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_C");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_C");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_C");
    check_field_offset(lv, v3, 3, "BFu1i_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_C, BFu1i_BFu17ll_C)
//============================================================================


struct  BFu1i_BFu17ll_D  {
  unsigned int v1:1;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 BFu1i_BFu17ll_D) C1{ Fi:1 FL:17 FL}



static void Test_BFu1i_BFu17ll_D()
{
  {
    init_simple_test("BFu1i_BFu17ll_D");
    static STRUCT_IF_C BFu1i_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_D");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_D");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_D, BFu1i_BFu17ll_D)
//============================================================================


struct  BFu1i_BFu17ll_F  {
  unsigned int v1:1;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 BFu1i_BFu17ll_F) C1{ Fi:1 FL:17 Fi}



static void Test_BFu1i_BFu17ll_F()
{
  {
    init_simple_test("BFu1i_BFu17ll_F");
    static STRUCT_IF_C BFu1i_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_F");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_F");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_F, BFu1i_BFu17ll_F)
//============================================================================


struct  BFu1i_BFu17ll_I  {
  unsigned int v1:1;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 BFu1i_BFu17ll_I) C1{ Fi:1 FL:17 Fi}



static void Test_BFu1i_BFu17ll_I()
{
  {
    init_simple_test("BFu1i_BFu17ll_I");
    static STRUCT_IF_C BFu1i_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_I");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_I");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_I, BFu1i_BFu17ll_I)
//============================================================================


struct  BFu1i_BFu17ll_Ip  {
  unsigned int v1:1;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 BFu1i_BFu17ll_Ip) C1{ Fi:1 FL:17 Fp}



static void Test_BFu1i_BFu17ll_Ip()
{
  {
    init_simple_test("BFu1i_BFu17ll_Ip");
    static STRUCT_IF_C BFu1i_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_Ip, BFu1i_BFu17ll_Ip)
//============================================================================


struct  BFu1i_BFu17ll_L  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu17ll_L) C1{ Fi:1 FL:17 FL}



static void Test_BFu1i_BFu17ll_L()
{
  {
    init_simple_test("BFu1i_BFu17ll_L");
    static STRUCT_IF_C BFu1i_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_L");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_L");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_L, BFu1i_BFu17ll_L)
//============================================================================


struct  BFu1i_BFu17ll_S  {
  unsigned int v1:1;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 BFu1i_BFu17ll_S) C1{ Fi:1 FL:17 Fs}



static void Test_BFu1i_BFu17ll_S()
{
  {
    init_simple_test("BFu1i_BFu17ll_S");
    static STRUCT_IF_C BFu1i_BFu17ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_S");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_S");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_S");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_S, BFu1i_BFu17ll_S)
//============================================================================


struct  BFu1i_BFu17ll_Uc  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu17ll_Uc) C1{ Fi:1 FL:17 Fc}



static void Test_BFu1i_BFu17ll_Uc()
{
  {
    init_simple_test("BFu1i_BFu17ll_Uc");
    static STRUCT_IF_C BFu1i_BFu17ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_Uc");
    check_field_offset(lv, v3, 3, "BFu1i_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_Uc, BFu1i_BFu17ll_Uc)
//============================================================================


struct  BFu1i_BFu17ll_Ui  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu17ll_Ui) C1{ Fi:1 FL:17 Fi}



static void Test_BFu1i_BFu17ll_Ui()
{
  {
    init_simple_test("BFu1i_BFu17ll_Ui");
    static STRUCT_IF_C BFu1i_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_Ui, BFu1i_BFu17ll_Ui)
//============================================================================


struct  BFu1i_BFu17ll_Ul  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu17ll_Ul) C1{ Fi:1 FL:17 FL}



static void Test_BFu1i_BFu17ll_Ul()
{
  {
    init_simple_test("BFu1i_BFu17ll_Ul");
    static STRUCT_IF_C BFu1i_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_Ul, BFu1i_BFu17ll_Ul)
//============================================================================


struct  BFu1i_BFu17ll_Us  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu17ll_Us) C1{ Fi:1 FL:17 Fs}



static void Test_BFu1i_BFu17ll_Us()
{
  {
    init_simple_test("BFu1i_BFu17ll_Us");
    static STRUCT_IF_C BFu1i_BFu17ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_Us");
    check_field_offset(lv, v3, 4, "BFu1i_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_Us, BFu1i_BFu17ll_Us)
//============================================================================


struct  BFu1i_BFu17ll_Vp  {
  unsigned int v1:1;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 BFu1i_BFu17ll_Vp) C1{ Fi:1 FL:17 Fp}



static void Test_BFu1i_BFu17ll_Vp()
{
  {
    init_simple_test("BFu1i_BFu17ll_Vp");
    static STRUCT_IF_C BFu1i_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_Vp, BFu1i_BFu17ll_Vp)
//============================================================================


struct  BFu1i_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
};
//SIG(1 BFu1i_BFu1c) C1{ Fi:1 Fc:1}



static void Test_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c, BFu1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c) C1{ Fi:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c, BFu1i_BFu1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1c_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c_BFs1c) C1{ Fi:1 Fc:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c_BFs1c, BFu1i_BFu1c_BFs1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1c_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c_BFs1i) C1{ Fi:1 Fc:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c_BFs1i, BFu1i_BFu1c_BFs1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1c_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c_BFs1ll) C1{ Fi:1 Fc:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c_BFs1ll, BFu1i_BFu1c_BFs1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1c_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c_BFs1s) C1{ Fi:1 Fc:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c_BFs1s, BFu1i_BFu1c_BFs1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFs1c_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c_BFu1c) C1{ Fi:1 Fc:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c_BFu1c, BFu1i_BFu1c_BFs1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1c_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c_BFu1i) C1{ Fi:1 Fc:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c_BFu1i, BFu1i_BFu1c_BFs1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1c_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c_BFu1ll) C1{ Fi:1 Fc:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c_BFu1ll, BFu1i_BFu1c_BFs1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1c_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1c_BFu1s) C1{ Fi:1 Fc:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1c_BFu1s, BFu1i_BFu1c_BFs1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i) C1{ Fi:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i, BFu1i_BFu1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1i_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i_BFs1c) C1{ Fi:1 Fc:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i_BFs1c, BFu1i_BFu1c_BFs1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1i_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i_BFs1i) C1{ Fi:1 Fc:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i_BFs1i, BFu1i_BFu1c_BFs1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1i_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i_BFs1ll) C1{ Fi:1 Fc:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i_BFs1ll, BFu1i_BFu1c_BFs1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1i_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i_BFs1s) C1{ Fi:1 Fc:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i_BFs1s, BFu1i_BFu1c_BFs1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFs1i_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i_BFu1c) C1{ Fi:1 Fc:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i_BFu1c, BFu1i_BFu1c_BFs1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1i_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i_BFu1i) C1{ Fi:1 Fc:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i_BFu1i, BFu1i_BFu1c_BFs1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1i_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i_BFu1ll) C1{ Fi:1 Fc:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i_BFu1ll, BFu1i_BFu1c_BFs1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1i_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1i_BFu1s) C1{ Fi:1 Fc:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1i_BFu1s, BFu1i_BFu1c_BFs1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll) C1{ Fi:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll, BFu1i_BFu1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll_BFs1c) C1{ Fi:1 Fc:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll_BFs1c, BFu1i_BFu1c_BFs1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll_BFs1i) C1{ Fi:1 Fc:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll_BFs1i, BFu1i_BFu1c_BFs1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll_BFs1ll) C1{ Fi:1 Fc:1 FL:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll_BFs1ll, BFu1i_BFu1c_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll_BFs1s) C1{ Fi:1 Fc:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll_BFs1s, BFu1i_BFu1c_BFs1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll_BFu1c) C1{ Fi:1 Fc:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll_BFu1c, BFu1i_BFu1c_BFs1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll_BFu1i) C1{ Fi:1 Fc:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll_BFu1i, BFu1i_BFu1c_BFs1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll_BFu1ll) C1{ Fi:1 Fc:1 FL:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll_BFu1ll, BFu1i_BFu1c_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1ll_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1ll_BFu1s) C1{ Fi:1 Fc:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1ll_BFu1s, BFu1i_BFu1c_BFs1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s) C1{ Fi:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s, BFu1i_BFu1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFs1s_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s_BFs1c) C1{ Fi:1 Fc:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s_BFs1c, BFu1i_BFu1c_BFs1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1s_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s_BFs1i) C1{ Fi:1 Fc:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s_BFs1i, BFu1i_BFu1c_BFs1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1s_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s_BFs1ll) C1{ Fi:1 Fc:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s_BFs1ll, BFu1i_BFu1c_BFs1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1s_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s_BFs1s) C1{ Fi:1 Fc:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s_BFs1s, BFu1i_BFu1c_BFs1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFs1s_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s_BFu1c) C1{ Fi:1 Fc:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s_BFu1c, BFu1i_BFu1c_BFs1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFs1s_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s_BFu1i) C1{ Fi:1 Fc:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s_BFu1i, BFu1i_BFu1c_BFs1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFs1s_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s_BFu1ll) C1{ Fi:1 Fc:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s_BFu1ll, BFu1i_BFu1c_BFs1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFs1s_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFs1s_BFu1s) C1{ Fi:1 Fc:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFs1s_BFu1s, BFu1i_BFu1c_BFs1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFu15i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu1c_BFu15i) C1{ Fi:1 Fc:1 Fi:15}



static void Test_BFu1i_BFu1c_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu15i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 0, 2, 15, 1, "BFu1i_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 0, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu15i, BFu1i_BFu1c_BFu15i)
//============================================================================


struct  BFu1i_BFu1c_BFu15ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu1c_BFu15ll) C1{ Fi:1 Fc:1 FL:15}



static void Test_BFu1i_BFu1c_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 0, 2, 15, 1, "BFu1i_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 0, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu15ll, BFu1i_BFu1c_BFu15ll)
//============================================================================


struct  BFu1i_BFu1c_BFu15s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu1c_BFu15s) C1{ Fi:1 Fc:1 Fs:15}



static void Test_BFu1i_BFu1c_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu15s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu15s, BFu1i_BFu1c_BFu15s)
//============================================================================


struct  BFu1i_BFu1c_BFu16i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu1c_BFu16i) C1{ Fi:1 Fc:1 Fi:16}



static void Test_BFu1i_BFu1c_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu16i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 0, 2, 16, 1, "BFu1i_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 0, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu16i, BFu1i_BFu1c_BFu16i)
//============================================================================


struct  BFu1i_BFu1c_BFu16ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu1c_BFu16ll) C1{ Fi:1 Fc:1 FL:16}



static void Test_BFu1i_BFu1c_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 0, 2, 16, 1, "BFu1i_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 0, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu16ll, BFu1i_BFu1c_BFu16ll)
//============================================================================


struct  BFu1i_BFu1c_BFu16s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu1c_BFu16s) C1{ Fi:1 Fc:1 Fs:16}



static void Test_BFu1i_BFu1c_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu16s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu16s, BFu1i_BFu1c_BFu16s)
//============================================================================


struct  BFu1i_BFu1c_BFu17i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu1c_BFu17i) C1{ Fi:1 Fc:1 Fi:17}



static void Test_BFu1i_BFu1c_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu17i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 0, 2, 17, 1, "BFu1i_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 0, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu17i, BFu1i_BFu1c_BFu17i)
//============================================================================


struct  BFu1i_BFu1c_BFu17ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu1c_BFu17ll) C1{ Fi:1 Fc:1 FL:17}



static void Test_BFu1i_BFu1c_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 0, 2, 17, 1, "BFu1i_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 0, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu17ll, BFu1i_BFu1c_BFu17ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c) C1{ Fi:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c, BFu1i_BFu1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1c_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c_BFs1c) C1{ Fi:1 Fc:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c_BFs1c, BFu1i_BFu1c_BFu1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1c_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c_BFs1i) C1{ Fi:1 Fc:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c_BFs1i, BFu1i_BFu1c_BFu1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1c_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c_BFs1ll) C1{ Fi:1 Fc:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c_BFs1ll, BFu1i_BFu1c_BFu1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1c_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c_BFs1s) C1{ Fi:1 Fc:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c_BFs1s, BFu1i_BFu1c_BFu1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFu1c_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c_BFu1c) C1{ Fi:1 Fc:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c_BFu1c, BFu1i_BFu1c_BFu1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1c_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c_BFu1i) C1{ Fi:1 Fc:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c_BFu1i, BFu1i_BFu1c_BFu1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1c_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c_BFu1ll) C1{ Fi:1 Fc:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c_BFu1ll, BFu1i_BFu1c_BFu1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1c_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1c_BFu1s) C1{ Fi:1 Fc:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1c_BFu1s, BFu1i_BFu1c_BFu1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i) C1{ Fi:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i, BFu1i_BFu1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1i_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i_BFs1c) C1{ Fi:1 Fc:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i_BFs1c, BFu1i_BFu1c_BFu1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1i_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i_BFs1i) C1{ Fi:1 Fc:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i_BFs1i, BFu1i_BFu1c_BFu1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1i_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i_BFs1ll) C1{ Fi:1 Fc:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i_BFs1ll, BFu1i_BFu1c_BFu1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1i_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i_BFs1s) C1{ Fi:1 Fc:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i_BFs1s, BFu1i_BFu1c_BFu1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFu1i_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i_BFu1c) C1{ Fi:1 Fc:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i_BFu1c, BFu1i_BFu1c_BFu1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1i_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i_BFu1i) C1{ Fi:1 Fc:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i_BFu1i, BFu1i_BFu1c_BFu1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1i_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i_BFu1ll) C1{ Fi:1 Fc:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i_BFu1ll, BFu1i_BFu1c_BFu1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1i_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1i_BFu1s) C1{ Fi:1 Fc:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1i_BFu1s, BFu1i_BFu1c_BFu1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll) C1{ Fi:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll, BFu1i_BFu1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll_BFs1c) C1{ Fi:1 Fc:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll_BFs1c, BFu1i_BFu1c_BFu1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll_BFs1i) C1{ Fi:1 Fc:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll_BFs1i, BFu1i_BFu1c_BFu1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll_BFs1ll) C1{ Fi:1 Fc:1 FL:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll_BFs1ll, BFu1i_BFu1c_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll_BFs1s) C1{ Fi:1 Fc:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll_BFs1s, BFu1i_BFu1c_BFu1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll_BFu1c) C1{ Fi:1 Fc:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll_BFu1c, BFu1i_BFu1c_BFu1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll_BFu1i) C1{ Fi:1 Fc:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll_BFu1i, BFu1i_BFu1c_BFu1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll_BFu1ll) C1{ Fi:1 Fc:1 FL:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll_BFu1ll, BFu1i_BFu1c_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1ll_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1ll_BFu1s) C1{ Fi:1 Fc:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1ll_BFu1s, BFu1i_BFu1c_BFu1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s) C1{ Fi:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s, BFu1i_BFu1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFu1s_BFs1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s_BFs1c) C1{ Fi:1 Fc:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s_BFs1c, BFu1i_BFu1c_BFu1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1s_BFs1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s_BFs1i) C1{ Fi:1 Fc:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s_BFs1i, BFu1i_BFu1c_BFu1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1s_BFs1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s_BFs1ll) C1{ Fi:1 Fc:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s_BFs1ll, BFu1i_BFu1c_BFu1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1s_BFs1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s_BFs1s) C1{ Fi:1 Fc:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s_BFs1s, BFu1i_BFu1c_BFu1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1c_BFu1s_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s_BFu1c) C1{ Fi:1 Fc:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s_BFu1c, BFu1i_BFu1c_BFu1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1c_BFu1s_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s_BFu1i) C1{ Fi:1 Fc:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s_BFu1i, BFu1i_BFu1c_BFu1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1c_BFu1s_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s_BFu1ll) C1{ Fi:1 Fc:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s_BFu1ll, BFu1i_BFu1c_BFu1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1c_BFu1s_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1c_BFu1s_BFu1s) C1{ Fi:1 Fc:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu1s_BFu1s, BFu1i_BFu1c_BFu1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1c_BFu31i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu1c_BFu31i) C1{ Fi:1 Fc:1 Fi:31}



static void Test_BFu1i_BFu1c_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu31i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu31i, BFu1i_BFu1c_BFu31i)
//============================================================================


struct  BFu1i_BFu1c_BFu31ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu1c_BFu31ll) C1{ Fi:1 Fc:1 FL:31}



static void Test_BFu1i_BFu1c_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 0, 2, 31, 1, "BFu1i_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 0, 2, 31, hide_ull(1LL<<30), "BFu1i_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu31ll, BFu1i_BFu1c_BFu31ll)
//============================================================================


struct  BFu1i_BFu1c_BFu32i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu1c_BFu32i) C1{ Fi:1 Fc:1 Fi:32}



static void Test_BFu1i_BFu1c_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu32i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu32i, BFu1i_BFu1c_BFu32i)
//============================================================================


struct  BFu1i_BFu1c_BFu32ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu1c_BFu32ll) C1{ Fi:1 Fc:1 FL:32}



static void Test_BFu1i_BFu1c_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 0, 2, 32, 1, "BFu1i_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 0, 2, 32, hide_ull(1LL<<31), "BFu1i_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu32ll, BFu1i_BFu1c_BFu32ll)
//============================================================================


struct  BFu1i_BFu1c_BFu33  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu1c_BFu33) C1{ Fi:1 Fc:1 FL:33}



static void Test_BFu1i_BFu1c_BFu33()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu33");
    static STRUCT_IF_C BFu1i_BFu1c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 0, 2, 33, 1, "BFu1i_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 0, 2, 33, hide_ull(1LL<<32), "BFu1i_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu33, BFu1i_BFu1c_BFu33)
//============================================================================


struct  BFu1i_BFu1c_BFu7c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu1c_BFu7c) C1{ Fi:1 Fc:1 Fc:7}



static void Test_BFu1i_BFu1c_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu7c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu1i_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu7c, BFu1i_BFu1c_BFu7c)
//============================================================================


struct  BFu1i_BFu1c_BFu7i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu1c_BFu7i) C1{ Fi:1 Fc:1 Fi:7}



static void Test_BFu1i_BFu1c_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu7i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu7i, BFu1i_BFu1c_BFu7i)
//============================================================================


struct  BFu1i_BFu1c_BFu7ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu1c_BFu7ll) C1{ Fi:1 Fc:1 FL:7}



static void Test_BFu1i_BFu1c_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu7ll, BFu1i_BFu1c_BFu7ll)
//============================================================================


struct  BFu1i_BFu1c_BFu7s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu1c_BFu7s) C1{ Fi:1 Fc:1 Fs:7}



static void Test_BFu1i_BFu1c_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu7s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu7s, BFu1i_BFu1c_BFu7s)
//============================================================================


struct  BFu1i_BFu1c_BFu8c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu1c_BFu8c) C1{ Fi:1 Fc:1 Fc:8}



static void Test_BFu1i_BFu1c_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu8c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu1i_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu8c, BFu1i_BFu1c_BFu8c)
//============================================================================


struct  BFu1i_BFu1c_BFu8i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu1c_BFu8i) C1{ Fi:1 Fc:1 Fi:8}



static void Test_BFu1i_BFu1c_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu8i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu8i, BFu1i_BFu1c_BFu8i)
//============================================================================


struct  BFu1i_BFu1c_BFu8ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu1c_BFu8ll) C1{ Fi:1 Fc:1 FL:8}



static void Test_BFu1i_BFu1c_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu8ll, BFu1i_BFu1c_BFu8ll)
//============================================================================


struct  BFu1i_BFu1c_BFu8s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu1c_BFu8s) C1{ Fi:1 Fc:1 Fs:8}



static void Test_BFu1i_BFu1c_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu8s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu8s, BFu1i_BFu1c_BFu8s)
//============================================================================


struct  BFu1i_BFu1c_BFu9i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu1c_BFu9i) C1{ Fi:1 Fc:1 Fi:9}



static void Test_BFu1i_BFu1c_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu9i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu9i, BFu1i_BFu1c_BFu9i)
//============================================================================


struct  BFu1i_BFu1c_BFu9ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu1c_BFu9ll) C1{ Fi:1 Fc:1 FL:9}



static void Test_BFu1i_BFu1c_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu9ll, BFu1i_BFu1c_BFu9ll)
//============================================================================


struct  BFu1i_BFu1c_BFu9s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu1c_BFu9s) C1{ Fi:1 Fc:1 Fs:9}



static void Test_BFu1i_BFu1c_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu9s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu9s, BFu1i_BFu1c_BFu9s)
//============================================================================


struct  BFu1i_BFu1c_C  {
  unsigned int v1:1;
  unsigned char v2:1;
  char v3;
};
//SIG(1 BFu1i_BFu1c_C) C1{ Fi:1 Fc:1 Fc}



static void Test_BFu1i_BFu1c_C()
{
  {
    init_simple_test("BFu1i_BFu1c_C");
    static STRUCT_IF_C BFu1i_BFu1c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_C");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_C");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_C, BFu1i_BFu1c_C)
//============================================================================


struct  BFu1i_BFu1c_D  {
  unsigned int v1:1;
  unsigned char v2:1;
  double v3;
};
//SIG(1 BFu1i_BFu1c_D) C1{ Fi:1 Fc:1 FL}



static void Test_BFu1i_BFu1c_D()
{
  {
    init_simple_test("BFu1i_BFu1c_D");
    static STRUCT_IF_C BFu1i_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_D");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_D, BFu1i_BFu1c_D)
//============================================================================


struct  BFu1i_BFu1c_F  {
  unsigned int v1:1;
  unsigned char v2:1;
  float v3;
};
//SIG(1 BFu1i_BFu1c_F) C1{ Fi:1 Fc:1 Fi}



static void Test_BFu1i_BFu1c_F()
{
  {
    init_simple_test("BFu1i_BFu1c_F");
    static STRUCT_IF_C BFu1i_BFu1c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_F");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_F, BFu1i_BFu1c_F)
//============================================================================


struct  BFu1i_BFu1c_I  {
  unsigned int v1:1;
  unsigned char v2:1;
  int v3;
};
//SIG(1 BFu1i_BFu1c_I) C1{ Fi:1 Fc:1 Fi}



static void Test_BFu1i_BFu1c_I()
{
  {
    init_simple_test("BFu1i_BFu1c_I");
    static STRUCT_IF_C BFu1i_BFu1c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_I");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_I, BFu1i_BFu1c_I)
//============================================================================


struct  BFu1i_BFu1c_Ip  {
  unsigned int v1:1;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 BFu1i_BFu1c_Ip) C1{ Fi:1 Fc:1 Fp}



static void Test_BFu1i_BFu1c_Ip()
{
  {
    init_simple_test("BFu1i_BFu1c_Ip");
    static STRUCT_IF_C BFu1i_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_Ip");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_Ip, BFu1i_BFu1c_Ip)
//============================================================================


struct  BFu1i_BFu1c_L  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu1c_L) C1{ Fi:1 Fc:1 FL}



static void Test_BFu1i_BFu1c_L()
{
  {
    init_simple_test("BFu1i_BFu1c_L");
    static STRUCT_IF_C BFu1i_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_L");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_L, BFu1i_BFu1c_L)
//============================================================================


struct  BFu1i_BFu1c_S  {
  unsigned int v1:1;
  unsigned char v2:1;
  short v3;
};
//SIG(1 BFu1i_BFu1c_S) C1{ Fi:1 Fc:1 Fs}



static void Test_BFu1i_BFu1c_S()
{
  {
    init_simple_test("BFu1i_BFu1c_S");
    static STRUCT_IF_C BFu1i_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_S");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_S");
    check_field_offset(lv, v3, 2, "BFu1i_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_S, BFu1i_BFu1c_S)
//============================================================================


struct  BFu1i_BFu1c_Uc  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu1c_Uc) C1{ Fi:1 Fc:1 Fc}



static void Test_BFu1i_BFu1c_Uc()
{
  {
    init_simple_test("BFu1i_BFu1c_Uc");
    static STRUCT_IF_C BFu1i_BFu1c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_Uc");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_Uc");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_Uc, BFu1i_BFu1c_Uc)
//============================================================================


struct  BFu1i_BFu1c_Ui  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu1c_Ui) C1{ Fi:1 Fc:1 Fi}



static void Test_BFu1i_BFu1c_Ui()
{
  {
    init_simple_test("BFu1i_BFu1c_Ui");
    static STRUCT_IF_C BFu1i_BFu1c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_Ui");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_Ui, BFu1i_BFu1c_Ui)
//============================================================================


struct  BFu1i_BFu1c_Ul  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu1c_Ul) C1{ Fi:1 Fc:1 FL}



static void Test_BFu1i_BFu1c_Ul()
{
  {
    init_simple_test("BFu1i_BFu1c_Ul");
    static STRUCT_IF_C BFu1i_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_Ul");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_Ul, BFu1i_BFu1c_Ul)
//============================================================================


struct  BFu1i_BFu1c_Us  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu1c_Us) C1{ Fi:1 Fc:1 Fs}



static void Test_BFu1i_BFu1c_Us()
{
  {
    init_simple_test("BFu1i_BFu1c_Us");
    static STRUCT_IF_C BFu1i_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_Us");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_Us");
    check_field_offset(lv, v3, 2, "BFu1i_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_Us, BFu1i_BFu1c_Us)
//============================================================================


struct  BFu1i_BFu1c_Vp  {
  unsigned int v1:1;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 BFu1i_BFu1c_Vp) C1{ Fi:1 Fc:1 Fp}



static void Test_BFu1i_BFu1c_Vp()
{
  {
    init_simple_test("BFu1i_BFu1c_Vp");
    static STRUCT_IF_C BFu1i_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_Vp");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_Vp, BFu1i_BFu1c_Vp)
//============================================================================


struct  BFu1i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu1i_BFu1i) C1{ Fi:1 Fi:1}



static void Test_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i, BFu1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c) C1{ Fi:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c, BFu1i_BFu1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1c_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c_BFs1c) C1{ Fi:1 Fi:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c_BFs1c, BFu1i_BFu1i_BFs1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1c_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c_BFs1i) C1{ Fi:1 Fi:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c_BFs1i, BFu1i_BFu1i_BFs1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1c_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c_BFs1ll) C1{ Fi:1 Fi:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c_BFs1ll, BFu1i_BFu1i_BFs1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1c_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c_BFs1s) C1{ Fi:1 Fi:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c_BFs1s, BFu1i_BFu1i_BFs1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFs1c_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c_BFu1c) C1{ Fi:1 Fi:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c_BFu1c, BFu1i_BFu1i_BFs1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1c_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c_BFu1i) C1{ Fi:1 Fi:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c_BFu1i, BFu1i_BFu1i_BFs1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1c_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c_BFu1ll) C1{ Fi:1 Fi:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c_BFu1ll, BFu1i_BFu1i_BFs1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1c_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1c_BFu1s) C1{ Fi:1 Fi:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1c_BFu1s, BFu1i_BFu1i_BFs1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i) C1{ Fi:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i, BFu1i_BFu1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1i_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i_BFs1c) C1{ Fi:1 Fi:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i_BFs1c, BFu1i_BFu1i_BFs1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1i_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i_BFs1i) C1{ Fi:1 Fi:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i_BFs1i, BFu1i_BFu1i_BFs1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1i_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i_BFs1ll) C1{ Fi:1 Fi:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i_BFs1ll, BFu1i_BFu1i_BFs1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1i_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i_BFs1s) C1{ Fi:1 Fi:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i_BFs1s, BFu1i_BFu1i_BFs1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFs1i_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i_BFu1c) C1{ Fi:1 Fi:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i_BFu1c, BFu1i_BFu1i_BFs1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i_BFu1i) C1{ Fi:1 Fi:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i_BFu1i, BFu1i_BFu1i_BFs1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1i_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i_BFu1ll) C1{ Fi:1 Fi:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i_BFu1ll, BFu1i_BFu1i_BFs1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1i_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1i_BFu1s) C1{ Fi:1 Fi:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1i_BFu1s, BFu1i_BFu1i_BFs1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll) C1{ Fi:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll, BFu1i_BFu1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll_BFs1c) C1{ Fi:1 Fi:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll_BFs1c, BFu1i_BFu1i_BFs1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll_BFs1i) C1{ Fi:1 Fi:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll_BFs1i, BFu1i_BFu1i_BFs1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll_BFs1ll) C1{ Fi:1 Fi:1 FL:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll_BFs1ll, BFu1i_BFu1i_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll_BFs1s) C1{ Fi:1 Fi:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll_BFs1s, BFu1i_BFu1i_BFs1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll_BFu1c) C1{ Fi:1 Fi:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll_BFu1c, BFu1i_BFu1i_BFs1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll_BFu1i) C1{ Fi:1 Fi:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll_BFu1i, BFu1i_BFu1i_BFs1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll_BFu1ll) C1{ Fi:1 Fi:1 FL:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll_BFu1ll, BFu1i_BFu1i_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1ll_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1ll_BFu1s) C1{ Fi:1 Fi:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1ll_BFu1s, BFu1i_BFu1i_BFs1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s) C1{ Fi:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s, BFu1i_BFu1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFs1s_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s_BFs1c) C1{ Fi:1 Fi:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s_BFs1c, BFu1i_BFu1i_BFs1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1s_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s_BFs1i) C1{ Fi:1 Fi:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s_BFs1i, BFu1i_BFu1i_BFs1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1s_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s_BFs1ll) C1{ Fi:1 Fi:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s_BFs1ll, BFu1i_BFu1i_BFs1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1s_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s_BFs1s) C1{ Fi:1 Fi:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s_BFs1s, BFu1i_BFu1i_BFs1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFs1s_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s_BFu1c) C1{ Fi:1 Fi:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s_BFu1c, BFu1i_BFu1i_BFs1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFs1s_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s_BFu1i) C1{ Fi:1 Fi:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s_BFu1i, BFu1i_BFu1i_BFs1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFs1s_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s_BFu1ll) C1{ Fi:1 Fi:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s_BFu1ll, BFu1i_BFu1i_BFs1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFs1s_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFs1s_BFu1s) C1{ Fi:1 Fi:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFs1s_BFu1s, BFu1i_BFu1i_BFs1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFu15i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu1i_BFu15i) C1{ Fi:1 Fi:1 Fi:15}



static void Test_BFu1i_BFu1i_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu15i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 0, 2, 15, 1, "BFu1i_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 0, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu15i, BFu1i_BFu1i_BFu15i)
//============================================================================


struct  BFu1i_BFu1i_BFu15ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu1i_BFu15ll) C1{ Fi:1 Fi:1 FL:15}



static void Test_BFu1i_BFu1i_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 0, 2, 15, 1, "BFu1i_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 0, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu15ll, BFu1i_BFu1i_BFu15ll)
//============================================================================


struct  BFu1i_BFu1i_BFu15s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu1i_BFu15s) C1{ Fi:1 Fi:1 Fs:15}



static void Test_BFu1i_BFu1i_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu15s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu15s, BFu1i_BFu1i_BFu15s)
//============================================================================


struct  BFu1i_BFu1i_BFu16i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu1i_BFu16i) C1{ Fi:1 Fi:1 Fi:16}



static void Test_BFu1i_BFu1i_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu16i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 0, 2, 16, 1, "BFu1i_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 0, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu16i, BFu1i_BFu1i_BFu16i)
//============================================================================


struct  BFu1i_BFu1i_BFu16ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu1i_BFu16ll) C1{ Fi:1 Fi:1 FL:16}



static void Test_BFu1i_BFu1i_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 0, 2, 16, 1, "BFu1i_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 0, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu16ll, BFu1i_BFu1i_BFu16ll)
//============================================================================


struct  BFu1i_BFu1i_BFu16s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu1i_BFu16s) C1{ Fi:1 Fi:1 Fs:16}



static void Test_BFu1i_BFu1i_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu16s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu16s, BFu1i_BFu1i_BFu16s)
//============================================================================


struct  BFu1i_BFu1i_BFu17i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu1i_BFu17i) C1{ Fi:1 Fi:1 Fi:17}



static void Test_BFu1i_BFu1i_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu17i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 0, 2, 17, 1, "BFu1i_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 0, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu17i, BFu1i_BFu1i_BFu17i)
//============================================================================


struct  BFu1i_BFu1i_BFu17ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu1i_BFu17ll) C1{ Fi:1 Fi:1 FL:17}



static void Test_BFu1i_BFu1i_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 0, 2, 17, 1, "BFu1i_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 0, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu17ll, BFu1i_BFu1i_BFu17ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c) C1{ Fi:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c, BFu1i_BFu1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1c_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c_BFs1c) C1{ Fi:1 Fi:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c_BFs1c, BFu1i_BFu1i_BFu1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1c_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c_BFs1i) C1{ Fi:1 Fi:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c_BFs1i, BFu1i_BFu1i_BFu1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1c_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c_BFs1ll) C1{ Fi:1 Fi:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c_BFs1ll, BFu1i_BFu1i_BFu1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1c_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c_BFs1s) C1{ Fi:1 Fi:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c_BFs1s, BFu1i_BFu1i_BFu1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFu1c_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c_BFu1c) C1{ Fi:1 Fi:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c_BFu1c, BFu1i_BFu1i_BFu1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1c_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c_BFu1i) C1{ Fi:1 Fi:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c_BFu1i, BFu1i_BFu1i_BFu1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1c_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c_BFu1ll) C1{ Fi:1 Fi:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c_BFu1ll, BFu1i_BFu1i_BFu1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1c_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1c_BFu1s) C1{ Fi:1 Fi:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1c_BFu1s, BFu1i_BFu1i_BFu1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i) C1{ Fi:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i, BFu1i_BFu1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1i_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i_BFs1c) C1{ Fi:1 Fi:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i_BFs1c, BFu1i_BFu1i_BFu1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1i_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i_BFs1i) C1{ Fi:1 Fi:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i_BFs1i, BFu1i_BFu1i_BFu1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1i_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i_BFs1ll) C1{ Fi:1 Fi:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i_BFs1ll, BFu1i_BFu1i_BFu1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1i_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i_BFs1s) C1{ Fi:1 Fi:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i_BFs1s, BFu1i_BFu1i_BFu1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFu1i_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i_BFu1c) C1{ Fi:1 Fi:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i_BFu1c, BFu1i_BFu1i_BFu1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i_BFu1i) C1{ Fi:1 Fi:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i_BFu1i, BFu1i_BFu1i_BFu1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1i_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i_BFu1ll) C1{ Fi:1 Fi:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i_BFu1ll, BFu1i_BFu1i_BFu1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1i_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1i_BFu1s) C1{ Fi:1 Fi:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1i_BFu1s, BFu1i_BFu1i_BFu1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll) C1{ Fi:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll, BFu1i_BFu1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll_BFs1c) C1{ Fi:1 Fi:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll_BFs1c, BFu1i_BFu1i_BFu1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll_BFs1i) C1{ Fi:1 Fi:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll_BFs1i, BFu1i_BFu1i_BFu1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll_BFs1ll) C1{ Fi:1 Fi:1 FL:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll_BFs1ll, BFu1i_BFu1i_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll_BFs1s) C1{ Fi:1 Fi:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll_BFs1s, BFu1i_BFu1i_BFu1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll_BFu1c) C1{ Fi:1 Fi:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll_BFu1c, BFu1i_BFu1i_BFu1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll_BFu1i) C1{ Fi:1 Fi:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll_BFu1i, BFu1i_BFu1i_BFu1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll_BFu1ll) C1{ Fi:1 Fi:1 FL:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll_BFu1ll, BFu1i_BFu1i_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1ll_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1ll_BFu1s) C1{ Fi:1 Fi:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1ll_BFu1s, BFu1i_BFu1i_BFu1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s) C1{ Fi:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s, BFu1i_BFu1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFu1s_BFs1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s_BFs1c) C1{ Fi:1 Fi:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s_BFs1c, BFu1i_BFu1i_BFu1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1s_BFs1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s_BFs1i) C1{ Fi:1 Fi:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s_BFs1i, BFu1i_BFu1i_BFu1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1s_BFs1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s_BFs1ll) C1{ Fi:1 Fi:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s_BFs1ll, BFu1i_BFu1i_BFu1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1s_BFs1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s_BFs1s) C1{ Fi:1 Fi:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s_BFs1s, BFu1i_BFu1i_BFu1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1i_BFu1s_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s_BFu1c) C1{ Fi:1 Fi:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s_BFu1c, BFu1i_BFu1i_BFu1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1i_BFu1s_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s_BFu1i) C1{ Fi:1 Fi:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s_BFu1i, BFu1i_BFu1i_BFu1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1i_BFu1s_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s_BFu1ll) C1{ Fi:1 Fi:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s_BFu1ll, BFu1i_BFu1i_BFu1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1i_BFu1s_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1i_BFu1s_BFu1s) C1{ Fi:1 Fi:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu1s_BFu1s, BFu1i_BFu1i_BFu1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1i_BFu31i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu1i_BFu31i) C1{ Fi:1 Fi:1 Fi:31}



static void Test_BFu1i_BFu1i_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu31i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu31i, BFu1i_BFu1i_BFu31i)
//============================================================================


struct  BFu1i_BFu1i_BFu31ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu1i_BFu31ll) C1{ Fi:1 Fi:1 FL:31}



static void Test_BFu1i_BFu1i_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 0, 2, 31, 1, "BFu1i_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 0, 2, 31, hide_ull(1LL<<30), "BFu1i_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu31ll, BFu1i_BFu1i_BFu31ll)
//============================================================================


struct  BFu1i_BFu1i_BFu32i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu1i_BFu32i) C1{ Fi:1 Fi:1 Fi:32}



static void Test_BFu1i_BFu1i_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu32i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu32i, BFu1i_BFu1i_BFu32i)
//============================================================================


struct  BFu1i_BFu1i_BFu32ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu1i_BFu32ll) C1{ Fi:1 Fi:1 FL:32}



static void Test_BFu1i_BFu1i_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 0, 2, 32, 1, "BFu1i_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 0, 2, 32, hide_ull(1LL<<31), "BFu1i_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu32ll, BFu1i_BFu1i_BFu32ll)
//============================================================================


struct  BFu1i_BFu1i_BFu33  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu1i_BFu33) C1{ Fi:1 Fi:1 FL:33}



static void Test_BFu1i_BFu1i_BFu33()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu33");
    static STRUCT_IF_C BFu1i_BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 0, 2, 33, 1, "BFu1i_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 0, 2, 33, hide_ull(1LL<<32), "BFu1i_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu33, BFu1i_BFu1i_BFu33)
//============================================================================


struct  BFu1i_BFu1i_BFu7c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu1i_BFu7c) C1{ Fi:1 Fi:1 Fc:7}



static void Test_BFu1i_BFu1i_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu7c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu1i_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu7c, BFu1i_BFu1i_BFu7c)
//============================================================================


struct  BFu1i_BFu1i_BFu7i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu1i_BFu7i) C1{ Fi:1 Fi:1 Fi:7}



static void Test_BFu1i_BFu1i_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu7i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu7i, BFu1i_BFu1i_BFu7i)
//============================================================================


struct  BFu1i_BFu1i_BFu7ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu1i_BFu7ll) C1{ Fi:1 Fi:1 FL:7}



static void Test_BFu1i_BFu1i_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu7ll, BFu1i_BFu1i_BFu7ll)
//============================================================================


struct  BFu1i_BFu1i_BFu7s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu1i_BFu7s) C1{ Fi:1 Fi:1 Fs:7}



static void Test_BFu1i_BFu1i_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu7s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu7s, BFu1i_BFu1i_BFu7s)
//============================================================================


struct  BFu1i_BFu1i_BFu8c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu1i_BFu8c) C1{ Fi:1 Fi:1 Fc:8}



static void Test_BFu1i_BFu1i_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu8c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu1i_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu8c, BFu1i_BFu1i_BFu8c)
//============================================================================


struct  BFu1i_BFu1i_BFu8i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu1i_BFu8i) C1{ Fi:1 Fi:1 Fi:8}



static void Test_BFu1i_BFu1i_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu8i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu8i, BFu1i_BFu1i_BFu8i)
//============================================================================


struct  BFu1i_BFu1i_BFu8ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu1i_BFu8ll) C1{ Fi:1 Fi:1 FL:8}



static void Test_BFu1i_BFu1i_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu8ll, BFu1i_BFu1i_BFu8ll)
//============================================================================


struct  BFu1i_BFu1i_BFu8s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu1i_BFu8s) C1{ Fi:1 Fi:1 Fs:8}



static void Test_BFu1i_BFu1i_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu8s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu8s, BFu1i_BFu1i_BFu8s)
//============================================================================


struct  BFu1i_BFu1i_BFu9i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu1i_BFu9i) C1{ Fi:1 Fi:1 Fi:9}



static void Test_BFu1i_BFu1i_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu9i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu9i, BFu1i_BFu1i_BFu9i)
//============================================================================


struct  BFu1i_BFu1i_BFu9ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu1i_BFu9ll) C1{ Fi:1 Fi:1 FL:9}



static void Test_BFu1i_BFu1i_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu9ll, BFu1i_BFu1i_BFu9ll)
//============================================================================


struct  BFu1i_BFu1i_BFu9s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu1i_BFu9s) C1{ Fi:1 Fi:1 Fs:9}



static void Test_BFu1i_BFu1i_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu9s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu9s, BFu1i_BFu1i_BFu9s)
//============================================================================


struct  BFu1i_BFu1i_C  {
  unsigned int v1:1;
  unsigned int v2:1;
  char v3;
};
//SIG(1 BFu1i_BFu1i_C) C1{ Fi:1 Fi:1 Fc}



static void Test_BFu1i_BFu1i_C()
{
  {
    init_simple_test("BFu1i_BFu1i_C");
    static STRUCT_IF_C BFu1i_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_C");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_C");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_C, BFu1i_BFu1i_C)
//============================================================================


struct  BFu1i_BFu1i_D  {
  unsigned int v1:1;
  unsigned int v2:1;
  double v3;
};
//SIG(1 BFu1i_BFu1i_D) C1{ Fi:1 Fi:1 FL}



static void Test_BFu1i_BFu1i_D()
{
  {
    init_simple_test("BFu1i_BFu1i_D");
    static STRUCT_IF_C BFu1i_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_D");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_D, BFu1i_BFu1i_D)
//============================================================================


struct  BFu1i_BFu1i_F  {
  unsigned int v1:1;
  unsigned int v2:1;
  float v3;
};
//SIG(1 BFu1i_BFu1i_F) C1{ Fi:1 Fi:1 Fi}



static void Test_BFu1i_BFu1i_F()
{
  {
    init_simple_test("BFu1i_BFu1i_F");
    static STRUCT_IF_C BFu1i_BFu1i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_F");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_F, BFu1i_BFu1i_F)
//============================================================================


struct  BFu1i_BFu1i_I  {
  unsigned int v1:1;
  unsigned int v2:1;
  int v3;
};
//SIG(1 BFu1i_BFu1i_I) C1{ Fi:1 Fi:1 Fi}



static void Test_BFu1i_BFu1i_I()
{
  {
    init_simple_test("BFu1i_BFu1i_I");
    static STRUCT_IF_C BFu1i_BFu1i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_I");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_I, BFu1i_BFu1i_I)
//============================================================================


struct  BFu1i_BFu1i_Ip  {
  unsigned int v1:1;
  unsigned int v2:1;
  int *v3;
};
//SIG(1 BFu1i_BFu1i_Ip) C1{ Fi:1 Fi:1 Fp}



static void Test_BFu1i_BFu1i_Ip()
{
  {
    init_simple_test("BFu1i_BFu1i_Ip");
    static STRUCT_IF_C BFu1i_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_Ip, BFu1i_BFu1i_Ip)
//============================================================================


struct  BFu1i_BFu1i_L  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu1i_L) C1{ Fi:1 Fi:1 FL}



static void Test_BFu1i_BFu1i_L()
{
  {
    init_simple_test("BFu1i_BFu1i_L");
    static STRUCT_IF_C BFu1i_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_L");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_L, BFu1i_BFu1i_L)
//============================================================================


struct  BFu1i_BFu1i_S  {
  unsigned int v1:1;
  unsigned int v2:1;
  short v3;
};
//SIG(1 BFu1i_BFu1i_S) C1{ Fi:1 Fi:1 Fs}



static void Test_BFu1i_BFu1i_S()
{
  {
    init_simple_test("BFu1i_BFu1i_S");
    static STRUCT_IF_C BFu1i_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_S");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_S");
    check_field_offset(lv, v3, 2, "BFu1i_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_S, BFu1i_BFu1i_S)
//============================================================================


struct  BFu1i_BFu1i_Uc  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu1i_Uc) C1{ Fi:1 Fi:1 Fc}



static void Test_BFu1i_BFu1i_Uc()
{
  {
    init_simple_test("BFu1i_BFu1i_Uc");
    static STRUCT_IF_C BFu1i_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_Uc");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_Uc, BFu1i_BFu1i_Uc)
//============================================================================


struct  BFu1i_BFu1i_Ui  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu1i_Ui) C1{ Fi:1 Fi:1 Fi}



static void Test_BFu1i_BFu1i_Ui()
{
  {
    init_simple_test("BFu1i_BFu1i_Ui");
    static STRUCT_IF_C BFu1i_BFu1i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_Ui, BFu1i_BFu1i_Ui)
//============================================================================


struct  BFu1i_BFu1i_Ul  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu1i_Ul) C1{ Fi:1 Fi:1 FL}



static void Test_BFu1i_BFu1i_Ul()
{
  {
    init_simple_test("BFu1i_BFu1i_Ul");
    static STRUCT_IF_C BFu1i_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_Ul, BFu1i_BFu1i_Ul)
//============================================================================


struct  BFu1i_BFu1i_Us  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu1i_Us) C1{ Fi:1 Fi:1 Fs}



static void Test_BFu1i_BFu1i_Us()
{
  {
    init_simple_test("BFu1i_BFu1i_Us");
    static STRUCT_IF_C BFu1i_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_Us");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_Us");
    check_field_offset(lv, v3, 2, "BFu1i_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_Us, BFu1i_BFu1i_Us)
//============================================================================


struct  BFu1i_BFu1i_Vp  {
  unsigned int v1:1;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 BFu1i_BFu1i_Vp) C1{ Fi:1 Fi:1 Fp}



static void Test_BFu1i_BFu1i_Vp()
{
  {
    init_simple_test("BFu1i_BFu1i_Vp");
    static STRUCT_IF_C BFu1i_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_Vp, BFu1i_BFu1i_Vp)
//============================================================================


struct  BFu1i_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu1i_BFu1ll) C1{ Fi:1 FL:1}



static void Test_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll, BFu1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c) C1{ Fi:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c, BFu1i_BFu1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c_BFs1c) C1{ Fi:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c_BFs1c, BFu1i_BFu1ll_BFs1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c_BFs1i) C1{ Fi:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c_BFs1i, BFu1i_BFu1ll_BFs1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c_BFs1ll) C1{ Fi:1 FL:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c_BFs1ll, BFu1i_BFu1ll_BFs1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c_BFs1s) C1{ Fi:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c_BFs1s, BFu1i_BFu1ll_BFs1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c_BFu1c) C1{ Fi:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c_BFu1c, BFu1i_BFu1ll_BFs1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c_BFu1i) C1{ Fi:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c_BFu1i, BFu1i_BFu1ll_BFs1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c_BFu1ll) C1{ Fi:1 FL:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c_BFu1ll, BFu1i_BFu1ll_BFs1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1c_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1c_BFu1s) C1{ Fi:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1c_BFu1s, BFu1i_BFu1ll_BFs1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i) C1{ Fi:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i, BFu1i_BFu1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i_BFs1c) C1{ Fi:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i_BFs1c, BFu1i_BFu1ll_BFs1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i_BFs1i) C1{ Fi:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i_BFs1i, BFu1i_BFu1ll_BFs1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i_BFs1ll) C1{ Fi:1 FL:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i_BFs1ll, BFu1i_BFu1ll_BFs1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i_BFs1s) C1{ Fi:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i_BFs1s, BFu1i_BFu1ll_BFs1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i_BFu1c) C1{ Fi:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i_BFu1c, BFu1i_BFu1ll_BFs1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i_BFu1i) C1{ Fi:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i_BFu1i, BFu1i_BFu1ll_BFs1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i_BFu1ll) C1{ Fi:1 FL:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i_BFu1ll, BFu1i_BFu1ll_BFs1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1i_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1i_BFu1s) C1{ Fi:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1i_BFu1s, BFu1i_BFu1ll_BFs1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll) C1{ Fi:1 FL:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll, BFu1i_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll_BFs1c) C1{ Fi:1 FL:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll_BFs1c, BFu1i_BFu1ll_BFs1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll_BFs1i) C1{ Fi:1 FL:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll_BFs1i, BFu1i_BFu1ll_BFs1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll_BFs1ll) C1{ Fi:1 FL:1 FL:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll_BFs1ll, BFu1i_BFu1ll_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll_BFs1s) C1{ Fi:1 FL:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll_BFs1s, BFu1i_BFu1ll_BFs1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll_BFu1c) C1{ Fi:1 FL:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll_BFu1c, BFu1i_BFu1ll_BFs1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll_BFu1i) C1{ Fi:1 FL:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll_BFu1i, BFu1i_BFu1ll_BFs1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll_BFu1ll) C1{ Fi:1 FL:1 FL:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll_BFu1ll, BFu1i_BFu1ll_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1ll_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1ll_BFu1s) C1{ Fi:1 FL:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1ll_BFu1s, BFu1i_BFu1ll_BFs1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s) C1{ Fi:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s, BFu1i_BFu1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s_BFs1c) C1{ Fi:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s_BFs1c, BFu1i_BFu1ll_BFs1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s_BFs1i) C1{ Fi:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s_BFs1i, BFu1i_BFu1ll_BFs1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s_BFs1ll) C1{ Fi:1 FL:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s_BFs1ll, BFu1i_BFu1ll_BFs1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s_BFs1s) C1{ Fi:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s_BFs1s, BFu1i_BFu1ll_BFs1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s_BFu1c) C1{ Fi:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s_BFu1c, BFu1i_BFu1ll_BFs1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s_BFu1i) C1{ Fi:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s_BFu1i, BFu1i_BFu1ll_BFs1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s_BFu1ll) C1{ Fi:1 FL:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s_BFu1ll, BFu1i_BFu1ll_BFs1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFs1s_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFs1s_BFu1s) C1{ Fi:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFs1s_BFu1s, BFu1i_BFu1ll_BFs1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu15i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu1ll_BFu15i) C1{ Fi:1 FL:1 Fi:15}



static void Test_BFu1i_BFu1ll_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu15i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 0, 2, 15, 1, "BFu1i_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 0, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu15i, BFu1i_BFu1ll_BFu15i)
//============================================================================


struct  BFu1i_BFu1ll_BFu15ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu1ll_BFu15ll) C1{ Fi:1 FL:1 FL:15}



static void Test_BFu1i_BFu1ll_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 0, 2, 15, 1, "BFu1i_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 0, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu15ll, BFu1i_BFu1ll_BFu15ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu15s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu1ll_BFu15s) C1{ Fi:1 FL:1 Fs:15}



static void Test_BFu1i_BFu1ll_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu15s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu15s, BFu1i_BFu1ll_BFu15s)
//============================================================================


struct  BFu1i_BFu1ll_BFu16i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu1ll_BFu16i) C1{ Fi:1 FL:1 Fi:16}



static void Test_BFu1i_BFu1ll_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu16i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 0, 2, 16, 1, "BFu1i_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 0, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu16i, BFu1i_BFu1ll_BFu16i)
//============================================================================


struct  BFu1i_BFu1ll_BFu16ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu1ll_BFu16ll) C1{ Fi:1 FL:1 FL:16}



static void Test_BFu1i_BFu1ll_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 0, 2, 16, 1, "BFu1i_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 0, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu16ll, BFu1i_BFu1ll_BFu16ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu16s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu1ll_BFu16s) C1{ Fi:1 FL:1 Fs:16}



static void Test_BFu1i_BFu1ll_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu16s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu16s, BFu1i_BFu1ll_BFu16s)
//============================================================================


struct  BFu1i_BFu1ll_BFu17i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu1ll_BFu17i) C1{ Fi:1 FL:1 Fi:17}



static void Test_BFu1i_BFu1ll_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu17i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 0, 2, 17, 1, "BFu1i_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 0, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu17i, BFu1i_BFu1ll_BFu17i)
//============================================================================


struct  BFu1i_BFu1ll_BFu17ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu1ll_BFu17ll) C1{ Fi:1 FL:1 FL:17}



static void Test_BFu1i_BFu1ll_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 0, 2, 17, 1, "BFu1i_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 0, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu17ll, BFu1i_BFu1ll_BFu17ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c) C1{ Fi:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c, BFu1i_BFu1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c_BFs1c) C1{ Fi:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c_BFs1c, BFu1i_BFu1ll_BFu1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c_BFs1i) C1{ Fi:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c_BFs1i, BFu1i_BFu1ll_BFu1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c_BFs1ll) C1{ Fi:1 FL:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c_BFs1ll, BFu1i_BFu1ll_BFu1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c_BFs1s) C1{ Fi:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c_BFs1s, BFu1i_BFu1ll_BFu1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c_BFu1c) C1{ Fi:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c_BFu1c, BFu1i_BFu1ll_BFu1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c_BFu1i) C1{ Fi:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c_BFu1i, BFu1i_BFu1ll_BFu1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c_BFu1ll) C1{ Fi:1 FL:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c_BFu1ll, BFu1i_BFu1ll_BFu1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1c_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1c_BFu1s) C1{ Fi:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1c_BFu1s, BFu1i_BFu1ll_BFu1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i) C1{ Fi:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i, BFu1i_BFu1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i_BFs1c) C1{ Fi:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i_BFs1c, BFu1i_BFu1ll_BFu1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i_BFs1i) C1{ Fi:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i_BFs1i, BFu1i_BFu1ll_BFu1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i_BFs1ll) C1{ Fi:1 FL:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i_BFs1ll, BFu1i_BFu1ll_BFu1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i_BFs1s) C1{ Fi:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i_BFs1s, BFu1i_BFu1ll_BFu1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i_BFu1c) C1{ Fi:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i_BFu1c, BFu1i_BFu1ll_BFu1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i_BFu1i) C1{ Fi:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i_BFu1i, BFu1i_BFu1ll_BFu1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i_BFu1ll) C1{ Fi:1 FL:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i_BFu1ll, BFu1i_BFu1ll_BFu1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1i_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1i_BFu1s) C1{ Fi:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1i_BFu1s, BFu1i_BFu1ll_BFu1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll) C1{ Fi:1 FL:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll, BFu1i_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll_BFs1c) C1{ Fi:1 FL:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll_BFs1c, BFu1i_BFu1ll_BFu1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll_BFs1i) C1{ Fi:1 FL:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll_BFs1i, BFu1i_BFu1ll_BFu1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll_BFs1ll) C1{ Fi:1 FL:1 FL:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll_BFs1ll, BFu1i_BFu1ll_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll_BFs1s) C1{ Fi:1 FL:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll_BFs1s, BFu1i_BFu1ll_BFu1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll_BFu1c) C1{ Fi:1 FL:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll_BFu1c, BFu1i_BFu1ll_BFu1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll_BFu1i) C1{ Fi:1 FL:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll_BFu1i, BFu1i_BFu1ll_BFu1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll_BFu1ll) C1{ Fi:1 FL:1 FL:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll_BFu1ll, BFu1i_BFu1ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1ll_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1ll_BFu1s) C1{ Fi:1 FL:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1ll_BFu1s, BFu1i_BFu1ll_BFu1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s) C1{ Fi:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s, BFu1i_BFu1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s_BFs1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s_BFs1c) C1{ Fi:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s_BFs1c, BFu1i_BFu1ll_BFu1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s_BFs1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s_BFs1i) C1{ Fi:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s_BFs1i, BFu1i_BFu1ll_BFu1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s_BFs1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s_BFs1ll) C1{ Fi:1 FL:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s_BFs1ll, BFu1i_BFu1ll_BFu1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s_BFs1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s_BFs1s) C1{ Fi:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s_BFs1s, BFu1i_BFu1ll_BFu1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s_BFu1c) C1{ Fi:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s_BFu1c, BFu1i_BFu1ll_BFu1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s_BFu1i) C1{ Fi:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s_BFu1i, BFu1i_BFu1ll_BFu1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s_BFu1ll) C1{ Fi:1 FL:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s_BFu1ll, BFu1i_BFu1ll_BFu1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu1s_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1ll_BFu1s_BFu1s) C1{ Fi:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu1s_BFu1s, BFu1i_BFu1ll_BFu1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1ll_BFu31i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu1ll_BFu31i) C1{ Fi:1 FL:1 Fi:31}



static void Test_BFu1i_BFu1ll_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu31i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu31i, BFu1i_BFu1ll_BFu31i)
//============================================================================


struct  BFu1i_BFu1ll_BFu31ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu1ll_BFu31ll) C1{ Fi:1 FL:1 FL:31}



static void Test_BFu1i_BFu1ll_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 0, 2, 31, 1, "BFu1i_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 0, 2, 31, hide_ull(1LL<<30), "BFu1i_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu31ll, BFu1i_BFu1ll_BFu31ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu32i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu1ll_BFu32i) C1{ Fi:1 FL:1 Fi:32}



static void Test_BFu1i_BFu1ll_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu32i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu32i, BFu1i_BFu1ll_BFu32i)
//============================================================================


struct  BFu1i_BFu1ll_BFu32ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu1ll_BFu32ll) C1{ Fi:1 FL:1 FL:32}



static void Test_BFu1i_BFu1ll_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 0, 2, 32, 1, "BFu1i_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 0, 2, 32, hide_ull(1LL<<31), "BFu1i_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu32ll, BFu1i_BFu1ll_BFu32ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu33  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu1ll_BFu33) C1{ Fi:1 FL:1 FL:33}



static void Test_BFu1i_BFu1ll_BFu33()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu33");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 0, 2, 33, 1, "BFu1i_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 0, 2, 33, hide_ull(1LL<<32), "BFu1i_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu33, BFu1i_BFu1ll_BFu33)
//============================================================================


struct  BFu1i_BFu1ll_BFu7c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu1ll_BFu7c) C1{ Fi:1 FL:1 Fc:7}



static void Test_BFu1i_BFu1ll_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu7c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu1i_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu7c, BFu1i_BFu1ll_BFu7c)
//============================================================================


struct  BFu1i_BFu1ll_BFu7i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu1ll_BFu7i) C1{ Fi:1 FL:1 Fi:7}



static void Test_BFu1i_BFu1ll_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu7i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu7i, BFu1i_BFu1ll_BFu7i)
//============================================================================


struct  BFu1i_BFu1ll_BFu7ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu1ll_BFu7ll) C1{ Fi:1 FL:1 FL:7}



static void Test_BFu1i_BFu1ll_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu7ll, BFu1i_BFu1ll_BFu7ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu7s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu1ll_BFu7s) C1{ Fi:1 FL:1 Fs:7}



static void Test_BFu1i_BFu1ll_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu7s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu7s, BFu1i_BFu1ll_BFu7s)
//============================================================================


struct  BFu1i_BFu1ll_BFu8c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu1ll_BFu8c) C1{ Fi:1 FL:1 Fc:8}



static void Test_BFu1i_BFu1ll_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu8c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu1i_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu8c, BFu1i_BFu1ll_BFu8c)
//============================================================================


struct  BFu1i_BFu1ll_BFu8i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu1ll_BFu8i) C1{ Fi:1 FL:1 Fi:8}



static void Test_BFu1i_BFu1ll_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu8i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu8i, BFu1i_BFu1ll_BFu8i)
//============================================================================


struct  BFu1i_BFu1ll_BFu8ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu1ll_BFu8ll) C1{ Fi:1 FL:1 FL:8}



static void Test_BFu1i_BFu1ll_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu8ll, BFu1i_BFu1ll_BFu8ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu8s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu1ll_BFu8s) C1{ Fi:1 FL:1 Fs:8}



static void Test_BFu1i_BFu1ll_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu8s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu8s, BFu1i_BFu1ll_BFu8s)
//============================================================================


struct  BFu1i_BFu1ll_BFu9i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu1ll_BFu9i) C1{ Fi:1 FL:1 Fi:9}



static void Test_BFu1i_BFu1ll_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu9i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu9i, BFu1i_BFu1ll_BFu9i)
//============================================================================


struct  BFu1i_BFu1ll_BFu9ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu1ll_BFu9ll) C1{ Fi:1 FL:1 FL:9}



static void Test_BFu1i_BFu1ll_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu9ll, BFu1i_BFu1ll_BFu9ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu9s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu1ll_BFu9s) C1{ Fi:1 FL:1 Fs:9}



static void Test_BFu1i_BFu1ll_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu9s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu9s, BFu1i_BFu1ll_BFu9s)
//============================================================================


struct  BFu1i_BFu1ll_C  {
  unsigned int v1:1;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 BFu1i_BFu1ll_C) C1{ Fi:1 FL:1 Fc}



static void Test_BFu1i_BFu1ll_C()
{
  {
    init_simple_test("BFu1i_BFu1ll_C");
    static STRUCT_IF_C BFu1i_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_C");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_C");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_C, BFu1i_BFu1ll_C)
//============================================================================


struct  BFu1i_BFu1ll_D  {
  unsigned int v1:1;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 BFu1i_BFu1ll_D) C1{ Fi:1 FL:1 FL}



static void Test_BFu1i_BFu1ll_D()
{
  {
    init_simple_test("BFu1i_BFu1ll_D");
    static STRUCT_IF_C BFu1i_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_D");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_D, BFu1i_BFu1ll_D)
//============================================================================


struct  BFu1i_BFu1ll_F  {
  unsigned int v1:1;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 BFu1i_BFu1ll_F) C1{ Fi:1 FL:1 Fi}



static void Test_BFu1i_BFu1ll_F()
{
  {
    init_simple_test("BFu1i_BFu1ll_F");
    static STRUCT_IF_C BFu1i_BFu1ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_F");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_F, BFu1i_BFu1ll_F)
//============================================================================


struct  BFu1i_BFu1ll_I  {
  unsigned int v1:1;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 BFu1i_BFu1ll_I) C1{ Fi:1 FL:1 Fi}



static void Test_BFu1i_BFu1ll_I()
{
  {
    init_simple_test("BFu1i_BFu1ll_I");
    static STRUCT_IF_C BFu1i_BFu1ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_I");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_I, BFu1i_BFu1ll_I)
//============================================================================


struct  BFu1i_BFu1ll_Ip  {
  unsigned int v1:1;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 BFu1i_BFu1ll_Ip) C1{ Fi:1 FL:1 Fp}



static void Test_BFu1i_BFu1ll_Ip()
{
  {
    init_simple_test("BFu1i_BFu1ll_Ip");
    static STRUCT_IF_C BFu1i_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_Ip, BFu1i_BFu1ll_Ip)
//============================================================================


struct  BFu1i_BFu1ll_L  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu1ll_L) C1{ Fi:1 FL:1 FL}



static void Test_BFu1i_BFu1ll_L()
{
  {
    init_simple_test("BFu1i_BFu1ll_L");
    static STRUCT_IF_C BFu1i_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_L");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_L, BFu1i_BFu1ll_L)
//============================================================================


struct  BFu1i_BFu1ll_S  {
  unsigned int v1:1;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 BFu1i_BFu1ll_S) C1{ Fi:1 FL:1 Fs}



static void Test_BFu1i_BFu1ll_S()
{
  {
    init_simple_test("BFu1i_BFu1ll_S");
    static STRUCT_IF_C BFu1i_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_S");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_S");
    check_field_offset(lv, v3, 2, "BFu1i_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_S, BFu1i_BFu1ll_S)
//============================================================================


struct  BFu1i_BFu1ll_Uc  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu1ll_Uc) C1{ Fi:1 FL:1 Fc}



static void Test_BFu1i_BFu1ll_Uc()
{
  {
    init_simple_test("BFu1i_BFu1ll_Uc");
    static STRUCT_IF_C BFu1i_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_Uc");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_Uc, BFu1i_BFu1ll_Uc)
//============================================================================


struct  BFu1i_BFu1ll_Ui  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu1ll_Ui) C1{ Fi:1 FL:1 Fi}



static void Test_BFu1i_BFu1ll_Ui()
{
  {
    init_simple_test("BFu1i_BFu1ll_Ui");
    static STRUCT_IF_C BFu1i_BFu1ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_Ui, BFu1i_BFu1ll_Ui)
//============================================================================


struct  BFu1i_BFu1ll_Ul  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu1ll_Ul) C1{ Fi:1 FL:1 FL}



static void Test_BFu1i_BFu1ll_Ul()
{
  {
    init_simple_test("BFu1i_BFu1ll_Ul");
    static STRUCT_IF_C BFu1i_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_Ul, BFu1i_BFu1ll_Ul)
//============================================================================


struct  BFu1i_BFu1ll_Us  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu1ll_Us) C1{ Fi:1 FL:1 Fs}



static void Test_BFu1i_BFu1ll_Us()
{
  {
    init_simple_test("BFu1i_BFu1ll_Us");
    static STRUCT_IF_C BFu1i_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_Us");
    check_field_offset(lv, v3, 2, "BFu1i_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_Us, BFu1i_BFu1ll_Us)
//============================================================================


struct  BFu1i_BFu1ll_Vp  {
  unsigned int v1:1;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 BFu1i_BFu1ll_Vp) C1{ Fi:1 FL:1 Fp}



static void Test_BFu1i_BFu1ll_Vp()
{
  {
    init_simple_test("BFu1i_BFu1ll_Vp");
    static STRUCT_IF_C BFu1i_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_Vp, BFu1i_BFu1ll_Vp)
//============================================================================


struct  BFu1i_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu1i_BFu1s) C1{ Fi:1 Fs:1}



static void Test_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s, BFu1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c) C1{ Fi:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c, BFu1i_BFu1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1c_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c_BFs1c) C1{ Fi:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c_BFs1c, BFu1i_BFu1s_BFs1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1c_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c_BFs1i) C1{ Fi:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c_BFs1i, BFu1i_BFu1s_BFs1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1c_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c_BFs1ll) C1{ Fi:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c_BFs1ll, BFu1i_BFu1s_BFs1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1c_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c_BFs1s) C1{ Fi:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c_BFs1s, BFu1i_BFu1s_BFs1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1c_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c_BFu1c) C1{ Fi:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c_BFu1c, BFu1i_BFu1s_BFs1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1c_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c_BFu1i) C1{ Fi:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c_BFu1i, BFu1i_BFu1s_BFs1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1c_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c_BFu1ll) C1{ Fi:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c_BFu1ll, BFu1i_BFu1s_BFs1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1c_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1c_BFu1s) C1{ Fi:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1c_BFu1s, BFu1i_BFu1s_BFs1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i) C1{ Fi:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i, BFu1i_BFu1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1i_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i_BFs1c) C1{ Fi:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i_BFs1c, BFu1i_BFu1s_BFs1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1i_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i_BFs1i) C1{ Fi:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i_BFs1i, BFu1i_BFu1s_BFs1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1i_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i_BFs1ll) C1{ Fi:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i_BFs1ll, BFu1i_BFu1s_BFs1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1i_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i_BFs1s) C1{ Fi:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i_BFs1s, BFu1i_BFu1s_BFs1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1i_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i_BFu1c) C1{ Fi:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i_BFu1c, BFu1i_BFu1s_BFs1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1i_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i_BFu1i) C1{ Fi:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i_BFu1i, BFu1i_BFu1s_BFs1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1i_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i_BFu1ll) C1{ Fi:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i_BFu1ll, BFu1i_BFu1s_BFs1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1i_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1i_BFu1s) C1{ Fi:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1i_BFu1s, BFu1i_BFu1s_BFs1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll) C1{ Fi:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll, BFu1i_BFu1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll_BFs1c) C1{ Fi:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll_BFs1c, BFu1i_BFu1s_BFs1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll_BFs1i) C1{ Fi:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll_BFs1i, BFu1i_BFu1s_BFs1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll_BFs1ll) C1{ Fi:1 Fs:1 FL:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll_BFs1ll, BFu1i_BFu1s_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll_BFs1s) C1{ Fi:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll_BFs1s, BFu1i_BFu1s_BFs1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll_BFu1c) C1{ Fi:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll_BFu1c, BFu1i_BFu1s_BFs1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll_BFu1i) C1{ Fi:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll_BFu1i, BFu1i_BFu1s_BFs1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll_BFu1ll) C1{ Fi:1 Fs:1 FL:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll_BFu1ll, BFu1i_BFu1s_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1ll_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1ll_BFu1s) C1{ Fi:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1ll_BFu1s, BFu1i_BFu1s_BFs1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s) C1{ Fi:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s, BFu1i_BFu1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1s_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s_BFs1c) C1{ Fi:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s_BFs1c, BFu1i_BFu1s_BFs1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1s_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s_BFs1i) C1{ Fi:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s_BFs1i, BFu1i_BFu1s_BFs1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1s_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s_BFs1ll) C1{ Fi:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s_BFs1ll, BFu1i_BFu1s_BFs1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1s_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s_BFs1s) C1{ Fi:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s_BFs1s, BFu1i_BFu1s_BFs1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFs1s_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s_BFu1c) C1{ Fi:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s_BFu1c, BFu1i_BFu1s_BFs1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFs1s_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s_BFu1i) C1{ Fi:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s_BFu1i, BFu1i_BFu1s_BFs1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFs1s_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s_BFu1ll) C1{ Fi:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s_BFu1ll, BFu1i_BFu1s_BFs1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFs1s_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFs1s_BFu1s) C1{ Fi:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1i_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFs1s_BFu1s, BFu1i_BFu1s_BFs1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFu15i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu1s_BFu15i) C1{ Fi:1 Fs:1 Fi:15}



static void Test_BFu1i_BFu1s_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu15i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 0, 2, 15, 1, "BFu1i_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 0, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu15i, BFu1i_BFu1s_BFu15i)
//============================================================================


struct  BFu1i_BFu1s_BFu15ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu1s_BFu15ll) C1{ Fi:1 Fs:1 FL:15}



static void Test_BFu1i_BFu1s_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 0, 2, 15, 1, "BFu1i_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 0, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu15ll, BFu1i_BFu1s_BFu15ll)
//============================================================================


struct  BFu1i_BFu1s_BFu15s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu1s_BFu15s) C1{ Fi:1 Fs:1 Fs:15}



static void Test_BFu1i_BFu1s_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu15s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu15s, BFu1i_BFu1s_BFu15s)
//============================================================================


struct  BFu1i_BFu1s_BFu16i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu1s_BFu16i) C1{ Fi:1 Fs:1 Fi:16}



static void Test_BFu1i_BFu1s_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu16i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 0, 2, 16, 1, "BFu1i_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 0, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu16i, BFu1i_BFu1s_BFu16i)
//============================================================================


struct  BFu1i_BFu1s_BFu16ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu1s_BFu16ll) C1{ Fi:1 Fs:1 FL:16}



static void Test_BFu1i_BFu1s_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 0, 2, 16, 1, "BFu1i_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 0, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu16ll, BFu1i_BFu1s_BFu16ll)
//============================================================================


struct  BFu1i_BFu1s_BFu16s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu1s_BFu16s) C1{ Fi:1 Fs:1 Fs:16}



static void Test_BFu1i_BFu1s_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu16s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu16s, BFu1i_BFu1s_BFu16s)
//============================================================================


struct  BFu1i_BFu1s_BFu17i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu1s_BFu17i) C1{ Fi:1 Fs:1 Fi:17}



static void Test_BFu1i_BFu1s_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu17i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 0, 2, 17, 1, "BFu1i_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 0, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu17i, BFu1i_BFu1s_BFu17i)
//============================================================================


struct  BFu1i_BFu1s_BFu17ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu1s_BFu17ll) C1{ Fi:1 Fs:1 FL:17}



static void Test_BFu1i_BFu1s_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 0, 2, 17, 1, "BFu1i_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 0, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu17ll, BFu1i_BFu1s_BFu17ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c) C1{ Fi:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c, BFu1i_BFu1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1c_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c_BFs1c) C1{ Fi:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c_BFs1c, BFu1i_BFu1s_BFu1c_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1c_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c_BFs1i) C1{ Fi:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c_BFs1i, BFu1i_BFu1s_BFu1c_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1c_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c_BFs1ll) C1{ Fi:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c_BFs1ll, BFu1i_BFu1s_BFu1c_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1c_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c_BFs1s) C1{ Fi:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c_BFs1s, BFu1i_BFu1s_BFu1c_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFu1c_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c_BFu1c) C1{ Fi:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c_BFu1c, BFu1i_BFu1s_BFu1c_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1c_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c_BFu1i) C1{ Fi:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c_BFu1i, BFu1i_BFu1s_BFu1c_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1c_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c_BFu1ll) C1{ Fi:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c_BFu1ll, BFu1i_BFu1s_BFu1c_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1c_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1c_BFu1s) C1{ Fi:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1c_BFu1s, BFu1i_BFu1s_BFu1c_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i) C1{ Fi:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i, BFu1i_BFu1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1i_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i_BFs1c) C1{ Fi:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i_BFs1c, BFu1i_BFu1s_BFu1i_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1i_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i_BFs1i) C1{ Fi:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i_BFs1i, BFu1i_BFu1s_BFu1i_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1i_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i_BFs1ll) C1{ Fi:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i_BFs1ll, BFu1i_BFu1s_BFu1i_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1i_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i_BFs1s) C1{ Fi:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i_BFs1s, BFu1i_BFu1s_BFu1i_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFu1i_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i_BFu1c) C1{ Fi:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i_BFu1c, BFu1i_BFu1s_BFu1i_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1i_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i_BFu1i) C1{ Fi:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i_BFu1i, BFu1i_BFu1s_BFu1i_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1i_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i_BFu1ll) C1{ Fi:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i_BFu1ll, BFu1i_BFu1s_BFu1i_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1i_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1i_BFu1s) C1{ Fi:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1i_BFu1s, BFu1i_BFu1s_BFu1i_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll) C1{ Fi:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll, BFu1i_BFu1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll_BFs1c) C1{ Fi:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll_BFs1c, BFu1i_BFu1s_BFu1ll_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll_BFs1i) C1{ Fi:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll_BFs1i, BFu1i_BFu1s_BFu1ll_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll_BFs1ll) C1{ Fi:1 Fs:1 FL:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll_BFs1ll, BFu1i_BFu1s_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll_BFs1s) C1{ Fi:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll_BFs1s, BFu1i_BFu1s_BFu1ll_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll_BFu1c) C1{ Fi:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll_BFu1c, BFu1i_BFu1s_BFu1ll_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll_BFu1i) C1{ Fi:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll_BFu1i, BFu1i_BFu1s_BFu1ll_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll_BFu1ll) C1{ Fi:1 Fs:1 FL:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll_BFu1ll, BFu1i_BFu1s_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1ll_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1ll_BFu1s) C1{ Fi:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1ll_BFu1s, BFu1i_BFu1s_BFu1ll_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s) C1{ Fi:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s, BFu1i_BFu1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFu1s_BFs1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s_BFs1c) C1{ Fi:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s_BFs1c, BFu1i_BFu1s_BFu1s_BFs1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1s_BFs1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s_BFs1i) C1{ Fi:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s_BFs1i, BFu1i_BFu1s_BFu1s_BFs1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1s_BFs1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s_BFs1ll) C1{ Fi:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s_BFs1ll, BFu1i_BFu1s_BFu1s_BFs1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1s_BFs1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s_BFs1s) C1{ Fi:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1i_BFu1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s_BFs1s, BFu1i_BFu1s_BFu1s_BFs1s)
//============================================================================


struct  BFu1i_BFu1s_BFu1s_BFu1c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s_BFu1c) C1{ Fi:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1i_BFu1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s_BFu1c, BFu1i_BFu1s_BFu1s_BFu1c)
//============================================================================


struct  BFu1i_BFu1s_BFu1s_BFu1i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s_BFu1i) C1{ Fi:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1i_BFu1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s_BFu1i, BFu1i_BFu1s_BFu1s_BFu1i)
//============================================================================


struct  BFu1i_BFu1s_BFu1s_BFu1ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s_BFu1ll) C1{ Fi:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1i_BFu1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s_BFu1ll, BFu1i_BFu1s_BFu1s_BFu1ll)
//============================================================================


struct  BFu1i_BFu1s_BFu1s_BFu1s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1i_BFu1s_BFu1s_BFu1s) C1{ Fi:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1i_BFu1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1i_BFu1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu1s_BFu1s, BFu1i_BFu1s_BFu1s_BFu1s)
//============================================================================


struct  BFu1i_BFu1s_BFu31i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu1s_BFu31i) C1{ Fi:1 Fs:1 Fi:31}



static void Test_BFu1i_BFu1s_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu31i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu31i, BFu1i_BFu1s_BFu31i)
//============================================================================


struct  BFu1i_BFu1s_BFu31ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu1s_BFu31ll) C1{ Fi:1 Fs:1 FL:31}



static void Test_BFu1i_BFu1s_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 0, 2, 31, 1, "BFu1i_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 0, 2, 31, hide_ull(1LL<<30), "BFu1i_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu31ll, BFu1i_BFu1s_BFu31ll)
//============================================================================


struct  BFu1i_BFu1s_BFu32i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu1s_BFu32i) C1{ Fi:1 Fs:1 Fi:32}



static void Test_BFu1i_BFu1s_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu32i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu32i, BFu1i_BFu1s_BFu32i)
//============================================================================


struct  BFu1i_BFu1s_BFu32ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu1s_BFu32ll) C1{ Fi:1 Fs:1 FL:32}



static void Test_BFu1i_BFu1s_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 0, 2, 32, 1, "BFu1i_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 0, 2, 32, hide_ull(1LL<<31), "BFu1i_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu32ll, BFu1i_BFu1s_BFu32ll)
//============================================================================


struct  BFu1i_BFu1s_BFu33  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu1s_BFu33) C1{ Fi:1 Fs:1 FL:33}



static void Test_BFu1i_BFu1s_BFu33()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu33");
    static STRUCT_IF_C BFu1i_BFu1s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 0, 2, 33, 1, "BFu1i_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 0, 2, 33, hide_ull(1LL<<32), "BFu1i_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu33, BFu1i_BFu1s_BFu33)
//============================================================================


struct  BFu1i_BFu1s_BFu7c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu1s_BFu7c) C1{ Fi:1 Fs:1 Fc:7}



static void Test_BFu1i_BFu1s_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu7c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu1i_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu7c, BFu1i_BFu1s_BFu7c)
//============================================================================


struct  BFu1i_BFu1s_BFu7i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu1s_BFu7i) C1{ Fi:1 Fs:1 Fi:7}



static void Test_BFu1i_BFu1s_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu7i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu7i, BFu1i_BFu1s_BFu7i)
//============================================================================


struct  BFu1i_BFu1s_BFu7ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu1s_BFu7ll) C1{ Fi:1 Fs:1 FL:7}



static void Test_BFu1i_BFu1s_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu7ll, BFu1i_BFu1s_BFu7ll)
//============================================================================


struct  BFu1i_BFu1s_BFu7s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu1s_BFu7s) C1{ Fi:1 Fs:1 Fs:7}



static void Test_BFu1i_BFu1s_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu7s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 0, 2, 7, 1, "BFu1i_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 0, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu7s, BFu1i_BFu1s_BFu7s)
//============================================================================


struct  BFu1i_BFu1s_BFu8c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu1s_BFu8c) C1{ Fi:1 Fs:1 Fc:8}



static void Test_BFu1i_BFu1s_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu8c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu1i_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu8c, BFu1i_BFu1s_BFu8c)
//============================================================================


struct  BFu1i_BFu1s_BFu8i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu1s_BFu8i) C1{ Fi:1 Fs:1 Fi:8}



static void Test_BFu1i_BFu1s_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu8i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu8i, BFu1i_BFu1s_BFu8i)
//============================================================================


struct  BFu1i_BFu1s_BFu8ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu1s_BFu8ll) C1{ Fi:1 Fs:1 FL:8}



static void Test_BFu1i_BFu1s_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu8ll, BFu1i_BFu1s_BFu8ll)
//============================================================================


struct  BFu1i_BFu1s_BFu8s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu1s_BFu8s) C1{ Fi:1 Fs:1 Fs:8}



static void Test_BFu1i_BFu1s_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu8s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 0, 2, 8, 1, "BFu1i_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 0, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu8s, BFu1i_BFu1s_BFu8s)
//============================================================================


struct  BFu1i_BFu1s_BFu9i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu1s_BFu9i) C1{ Fi:1 Fs:1 Fi:9}



static void Test_BFu1i_BFu1s_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu9i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu9i, BFu1i_BFu1s_BFu9i)
//============================================================================


struct  BFu1i_BFu1s_BFu9ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu1s_BFu9ll) C1{ Fi:1 Fs:1 FL:9}



static void Test_BFu1i_BFu1s_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu9ll, BFu1i_BFu1s_BFu9ll)
//============================================================================


struct  BFu1i_BFu1s_BFu9s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu1s_BFu9s) C1{ Fi:1 Fs:1 Fs:9}



static void Test_BFu1i_BFu1s_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu9s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 0, 2, 9, 1, "BFu1i_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 0, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu9s, BFu1i_BFu1s_BFu9s)
//============================================================================


struct  BFu1i_BFu1s_C  {
  unsigned int v1:1;
  unsigned short v2:1;
  char v3;
};
//SIG(1 BFu1i_BFu1s_C) C1{ Fi:1 Fs:1 Fc}



static void Test_BFu1i_BFu1s_C()
{
  {
    init_simple_test("BFu1i_BFu1s_C");
    static STRUCT_IF_C BFu1i_BFu1s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_C");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_C");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_C, BFu1i_BFu1s_C)
//============================================================================


struct  BFu1i_BFu1s_D  {
  unsigned int v1:1;
  unsigned short v2:1;
  double v3;
};
//SIG(1 BFu1i_BFu1s_D) C1{ Fi:1 Fs:1 FL}



static void Test_BFu1i_BFu1s_D()
{
  {
    init_simple_test("BFu1i_BFu1s_D");
    static STRUCT_IF_C BFu1i_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_D");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_D, BFu1i_BFu1s_D)
//============================================================================


struct  BFu1i_BFu1s_F  {
  unsigned int v1:1;
  unsigned short v2:1;
  float v3;
};
//SIG(1 BFu1i_BFu1s_F) C1{ Fi:1 Fs:1 Fi}



static void Test_BFu1i_BFu1s_F()
{
  {
    init_simple_test("BFu1i_BFu1s_F");
    static STRUCT_IF_C BFu1i_BFu1s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_F");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_F, BFu1i_BFu1s_F)
//============================================================================


struct  BFu1i_BFu1s_I  {
  unsigned int v1:1;
  unsigned short v2:1;
  int v3;
};
//SIG(1 BFu1i_BFu1s_I) C1{ Fi:1 Fs:1 Fi}



static void Test_BFu1i_BFu1s_I()
{
  {
    init_simple_test("BFu1i_BFu1s_I");
    static STRUCT_IF_C BFu1i_BFu1s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_I");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_I, BFu1i_BFu1s_I)
//============================================================================


struct  BFu1i_BFu1s_Ip  {
  unsigned int v1:1;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 BFu1i_BFu1s_Ip) C1{ Fi:1 Fs:1 Fp}



static void Test_BFu1i_BFu1s_Ip()
{
  {
    init_simple_test("BFu1i_BFu1s_Ip");
    static STRUCT_IF_C BFu1i_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_Ip");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_Ip, BFu1i_BFu1s_Ip)
//============================================================================


struct  BFu1i_BFu1s_L  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu1s_L) C1{ Fi:1 Fs:1 FL}



static void Test_BFu1i_BFu1s_L()
{
  {
    init_simple_test("BFu1i_BFu1s_L");
    static STRUCT_IF_C BFu1i_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_L");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_L, BFu1i_BFu1s_L)
//============================================================================


struct  BFu1i_BFu1s_S  {
  unsigned int v1:1;
  unsigned short v2:1;
  short v3;
};
//SIG(1 BFu1i_BFu1s_S) C1{ Fi:1 Fs:1 Fs}



static void Test_BFu1i_BFu1s_S()
{
  {
    init_simple_test("BFu1i_BFu1s_S");
    static STRUCT_IF_C BFu1i_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_S");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_S");
    check_field_offset(lv, v3, 2, "BFu1i_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_S, BFu1i_BFu1s_S)
//============================================================================


struct  BFu1i_BFu1s_Uc  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu1s_Uc) C1{ Fi:1 Fs:1 Fc}



static void Test_BFu1i_BFu1s_Uc()
{
  {
    init_simple_test("BFu1i_BFu1s_Uc");
    static STRUCT_IF_C BFu1i_BFu1s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_Uc");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_Uc");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_Uc, BFu1i_BFu1s_Uc)
//============================================================================


struct  BFu1i_BFu1s_Ui  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu1s_Ui) C1{ Fi:1 Fs:1 Fi}



static void Test_BFu1i_BFu1s_Ui()
{
  {
    init_simple_test("BFu1i_BFu1s_Ui");
    static STRUCT_IF_C BFu1i_BFu1s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_Ui");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_Ui, BFu1i_BFu1s_Ui)
//============================================================================


struct  BFu1i_BFu1s_Ul  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu1s_Ul) C1{ Fi:1 Fs:1 FL}



static void Test_BFu1i_BFu1s_Ul()
{
  {
    init_simple_test("BFu1i_BFu1s_Ul");
    static STRUCT_IF_C BFu1i_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_Ul");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_Ul, BFu1i_BFu1s_Ul)
//============================================================================


struct  BFu1i_BFu1s_Us  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu1s_Us) C1{ Fi:1 Fs:1 Fs}



static void Test_BFu1i_BFu1s_Us()
{
  {
    init_simple_test("BFu1i_BFu1s_Us");
    static STRUCT_IF_C BFu1i_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_Us");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_Us");
    check_field_offset(lv, v3, 2, "BFu1i_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_Us, BFu1i_BFu1s_Us)
//============================================================================


struct  BFu1i_BFu1s_Vp  {
  unsigned int v1:1;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 BFu1i_BFu1s_Vp) C1{ Fi:1 Fs:1 Fp}



static void Test_BFu1i_BFu1s_Vp()
{
  {
    init_simple_test("BFu1i_BFu1s_Vp");
    static STRUCT_IF_C BFu1i_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_Vp");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_Vp, BFu1i_BFu1s_Vp)
//============================================================================


struct  BFu1i_BFu31i  {
  unsigned int v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu1i_BFu31i) C1{ Fi:1 Fi:31}



static void Test_BFu1i_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu31i");
    static STRUCT_IF_C BFu1i_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i, BFu1i_BFu31i)
//============================================================================


struct  BFu1i_BFu31i_BFu15i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu31i_BFu15i) C1{ Fi:1 Fi:31 Fi:15}



static void Test_BFu1i_BFu31i_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu15i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu15i, BFu1i_BFu31i_BFu15i)
//============================================================================


struct  BFu1i_BFu31i_BFu15ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu31i_BFu15ll) C1{ Fi:1 Fi:31 FL:15}



static void Test_BFu1i_BFu31i_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu15ll, BFu1i_BFu31i_BFu15ll)
//============================================================================


struct  BFu1i_BFu31i_BFu15s  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu31i_BFu15s) C1{ Fi:1 Fi:31 Fs:15}



static void Test_BFu1i_BFu31i_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu15s");
    static STRUCT_IF_C BFu1i_BFu31i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu15s, BFu1i_BFu31i_BFu15s)
//============================================================================


struct  BFu1i_BFu31i_BFu16i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu31i_BFu16i) C1{ Fi:1 Fi:31 Fi:16}



static void Test_BFu1i_BFu31i_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu16i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu16i, BFu1i_BFu31i_BFu16i)
//============================================================================


struct  BFu1i_BFu31i_BFu16ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu31i_BFu16ll) C1{ Fi:1 Fi:31 FL:16}



static void Test_BFu1i_BFu31i_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu16ll, BFu1i_BFu31i_BFu16ll)
//============================================================================


struct  BFu1i_BFu31i_BFu16s  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu31i_BFu16s) C1{ Fi:1 Fi:31 Fs:16}



static void Test_BFu1i_BFu31i_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu16s");
    static STRUCT_IF_C BFu1i_BFu31i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu16s, BFu1i_BFu31i_BFu16s)
//============================================================================


struct  BFu1i_BFu31i_BFu17i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu31i_BFu17i) C1{ Fi:1 Fi:31 Fi:17}



static void Test_BFu1i_BFu31i_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu17i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu17i, BFu1i_BFu31i_BFu17i)
//============================================================================


struct  BFu1i_BFu31i_BFu17ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu31i_BFu17ll) C1{ Fi:1 Fi:31 FL:17}



static void Test_BFu1i_BFu31i_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu17ll, BFu1i_BFu31i_BFu17ll)
//============================================================================


struct  BFu1i_BFu31i_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu31i_BFu1c) C1{ Fi:1 Fi:31 Fc:1}



static void Test_BFu1i_BFu31i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu1c, BFu1i_BFu31i_BFu1c)
//============================================================================


struct  BFu1i_BFu31i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu31i_BFu1i) C1{ Fi:1 Fi:31 Fi:1}



static void Test_BFu1i_BFu31i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu1i, BFu1i_BFu31i_BFu1i)
//============================================================================


struct  BFu1i_BFu31i_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu31i_BFu1ll) C1{ Fi:1 Fi:31 FL:1}



static void Test_BFu1i_BFu31i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu1ll, BFu1i_BFu31i_BFu1ll)
//============================================================================


struct  BFu1i_BFu31i_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu31i_BFu1s) C1{ Fi:1 Fi:31 Fs:1}



static void Test_BFu1i_BFu31i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu1s, BFu1i_BFu31i_BFu1s)
//============================================================================


struct  BFu1i_BFu31i_BFu31i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu31i_BFu31i) C1{ Fi:1 Fi:31 Fi:31}



static void Test_BFu1i_BFu31i_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu31i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu31i, BFu1i_BFu31i_BFu31i)
//============================================================================


struct  BFu1i_BFu31i_BFu31ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu31i_BFu31ll) C1{ Fi:1 Fi:31 FL:31}



static void Test_BFu1i_BFu31i_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu31ll, BFu1i_BFu31i_BFu31ll)
//============================================================================


struct  BFu1i_BFu31i_BFu32i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu31i_BFu32i) C1{ Fi:1 Fi:31 Fi:32}



static void Test_BFu1i_BFu31i_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu32i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu32i, BFu1i_BFu31i_BFu32i)
//============================================================================


struct  BFu1i_BFu31i_BFu32ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu31i_BFu32ll) C1{ Fi:1 Fi:31 FL:32}



static void Test_BFu1i_BFu31i_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu32ll, BFu1i_BFu31i_BFu32ll)
//============================================================================


struct  BFu1i_BFu31i_BFu33  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu31i_BFu33) C1{ Fi:1 Fi:31 FL:33}



static void Test_BFu1i_BFu31i_BFu33()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu33");
    static STRUCT_IF_C BFu1i_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu1i_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1i_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu33, BFu1i_BFu31i_BFu33)
//============================================================================


struct  BFu1i_BFu31i_BFu7c  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu31i_BFu7c) C1{ Fi:1 Fi:31 Fc:7}



static void Test_BFu1i_BFu31i_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu7c");
    static STRUCT_IF_C BFu1i_BFu31i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu7c, BFu1i_BFu31i_BFu7c)
//============================================================================


struct  BFu1i_BFu31i_BFu7i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu31i_BFu7i) C1{ Fi:1 Fi:31 Fi:7}



static void Test_BFu1i_BFu31i_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu7i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu7i, BFu1i_BFu31i_BFu7i)
//============================================================================


struct  BFu1i_BFu31i_BFu7ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu31i_BFu7ll) C1{ Fi:1 Fi:31 FL:7}



static void Test_BFu1i_BFu31i_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu7ll, BFu1i_BFu31i_BFu7ll)
//============================================================================


struct  BFu1i_BFu31i_BFu7s  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu31i_BFu7s) C1{ Fi:1 Fi:31 Fs:7}



static void Test_BFu1i_BFu31i_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu7s");
    static STRUCT_IF_C BFu1i_BFu31i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu7s, BFu1i_BFu31i_BFu7s)
//============================================================================


struct  BFu1i_BFu31i_BFu8c  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu31i_BFu8c) C1{ Fi:1 Fi:31 Fc:8}



static void Test_BFu1i_BFu31i_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu8c");
    static STRUCT_IF_C BFu1i_BFu31i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu8c, BFu1i_BFu31i_BFu8c)
//============================================================================


struct  BFu1i_BFu31i_BFu8i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu31i_BFu8i) C1{ Fi:1 Fi:31 Fi:8}



static void Test_BFu1i_BFu31i_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu8i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu8i, BFu1i_BFu31i_BFu8i)
//============================================================================


struct  BFu1i_BFu31i_BFu8ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu31i_BFu8ll) C1{ Fi:1 Fi:31 FL:8}



static void Test_BFu1i_BFu31i_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu8ll, BFu1i_BFu31i_BFu8ll)
//============================================================================


struct  BFu1i_BFu31i_BFu8s  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu31i_BFu8s) C1{ Fi:1 Fi:31 Fs:8}



static void Test_BFu1i_BFu31i_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu8s");
    static STRUCT_IF_C BFu1i_BFu31i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu8s, BFu1i_BFu31i_BFu8s)
//============================================================================


struct  BFu1i_BFu31i_BFu9i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu31i_BFu9i) C1{ Fi:1 Fi:31 Fi:9}



static void Test_BFu1i_BFu31i_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu9i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu9i, BFu1i_BFu31i_BFu9i)
//============================================================================


struct  BFu1i_BFu31i_BFu9ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu31i_BFu9ll) C1{ Fi:1 Fi:31 FL:9}



static void Test_BFu1i_BFu31i_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu9ll, BFu1i_BFu31i_BFu9ll)
//============================================================================


struct  BFu1i_BFu31i_BFu9s  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu31i_BFu9s) C1{ Fi:1 Fi:31 Fs:9}



static void Test_BFu1i_BFu31i_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu9s");
    static STRUCT_IF_C BFu1i_BFu31i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu9s, BFu1i_BFu31i_BFu9s)
//============================================================================


struct  BFu1i_BFu31i_C  {
  unsigned int v1:1;
  unsigned int v2:31;
  char v3;
};
//SIG(1 BFu1i_BFu31i_C) C1{ Fi:1 Fi:31 Fc}



static void Test_BFu1i_BFu31i_C()
{
  {
    init_simple_test("BFu1i_BFu31i_C");
    static STRUCT_IF_C BFu1i_BFu31i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_C");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_C");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_C");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_C, BFu1i_BFu31i_C)
//============================================================================


struct  BFu1i_BFu31i_D  {
  unsigned int v1:1;
  unsigned int v2:31;
  double v3;
};
//SIG(1 BFu1i_BFu31i_D) C1{ Fi:1 Fi:31 FL}



static void Test_BFu1i_BFu31i_D()
{
  {
    init_simple_test("BFu1i_BFu31i_D");
    static STRUCT_IF_C BFu1i_BFu31i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_D");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_D");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_D, BFu1i_BFu31i_D)
//============================================================================


struct  BFu1i_BFu31i_F  {
  unsigned int v1:1;
  unsigned int v2:31;
  float v3;
};
//SIG(1 BFu1i_BFu31i_F) C1{ Fi:1 Fi:31 Fi}



static void Test_BFu1i_BFu31i_F()
{
  {
    init_simple_test("BFu1i_BFu31i_F");
    static STRUCT_IF_C BFu1i_BFu31i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_F");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_F");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_F, BFu1i_BFu31i_F)
//============================================================================


struct  BFu1i_BFu31i_I  {
  unsigned int v1:1;
  unsigned int v2:31;
  int v3;
};
//SIG(1 BFu1i_BFu31i_I) C1{ Fi:1 Fi:31 Fi}



static void Test_BFu1i_BFu31i_I()
{
  {
    init_simple_test("BFu1i_BFu31i_I");
    static STRUCT_IF_C BFu1i_BFu31i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_I");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_I");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_I, BFu1i_BFu31i_I)
//============================================================================


struct  BFu1i_BFu31i_Ip  {
  unsigned int v1:1;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 BFu1i_BFu31i_Ip) C1{ Fi:1 Fi:31 Fp}



static void Test_BFu1i_BFu31i_Ip()
{
  {
    init_simple_test("BFu1i_BFu31i_Ip");
    static STRUCT_IF_C BFu1i_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_Ip, BFu1i_BFu31i_Ip)
//============================================================================


struct  BFu1i_BFu31i_L  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu31i_L) C1{ Fi:1 Fi:31 FL}



static void Test_BFu1i_BFu31i_L()
{
  {
    init_simple_test("BFu1i_BFu31i_L");
    static STRUCT_IF_C BFu1i_BFu31i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_L");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_L");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_L, BFu1i_BFu31i_L)
//============================================================================


struct  BFu1i_BFu31i_S  {
  unsigned int v1:1;
  unsigned int v2:31;
  short v3;
};
//SIG(1 BFu1i_BFu31i_S) C1{ Fi:1 Fi:31 Fs}



static void Test_BFu1i_BFu31i_S()
{
  {
    init_simple_test("BFu1i_BFu31i_S");
    static STRUCT_IF_C BFu1i_BFu31i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_S");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_S");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_S");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_S, BFu1i_BFu31i_S)
//============================================================================


struct  BFu1i_BFu31i_Uc  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu31i_Uc) C1{ Fi:1 Fi:31 Fc}



static void Test_BFu1i_BFu31i_Uc()
{
  {
    init_simple_test("BFu1i_BFu31i_Uc");
    static STRUCT_IF_C BFu1i_BFu31i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_Uc");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_Uc, BFu1i_BFu31i_Uc)
//============================================================================


struct  BFu1i_BFu31i_Ui  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu31i_Ui) C1{ Fi:1 Fi:31 Fi}



static void Test_BFu1i_BFu31i_Ui()
{
  {
    init_simple_test("BFu1i_BFu31i_Ui");
    static STRUCT_IF_C BFu1i_BFu31i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_Ui, BFu1i_BFu31i_Ui)
//============================================================================


struct  BFu1i_BFu31i_Ul  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu31i_Ul) C1{ Fi:1 Fi:31 FL}



static void Test_BFu1i_BFu31i_Ul()
{
  {
    init_simple_test("BFu1i_BFu31i_Ul");
    static STRUCT_IF_C BFu1i_BFu31i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_Ul, BFu1i_BFu31i_Ul)
//============================================================================


struct  BFu1i_BFu31i_Us  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu31i_Us) C1{ Fi:1 Fi:31 Fs}



static void Test_BFu1i_BFu31i_Us()
{
  {
    init_simple_test("BFu1i_BFu31i_Us");
    static STRUCT_IF_C BFu1i_BFu31i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_Us");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_Us");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_Us");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_Us, BFu1i_BFu31i_Us)
//============================================================================


struct  BFu1i_BFu31i_Vp  {
  unsigned int v1:1;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 BFu1i_BFu31i_Vp) C1{ Fi:1 Fi:31 Fp}



static void Test_BFu1i_BFu31i_Vp()
{
  {
    init_simple_test("BFu1i_BFu31i_Vp");
    static STRUCT_IF_C BFu1i_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_Vp, BFu1i_BFu31i_Vp)
//============================================================================


struct  BFu1i_BFu31ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu1i_BFu31ll) C1{ Fi:1 FL:31}



static void Test_BFu1i_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll, BFu1i_BFu31ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu15i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu31ll_BFu15i) C1{ Fi:1 FL:31 Fi:15}



static void Test_BFu1i_BFu31ll_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu15i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu15i, BFu1i_BFu31ll_BFu15i)
//============================================================================


struct  BFu1i_BFu31ll_BFu15ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu31ll_BFu15ll) C1{ Fi:1 FL:31 FL:15}



static void Test_BFu1i_BFu31ll_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu15ll, BFu1i_BFu31ll_BFu15ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu15s  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu31ll_BFu15s) C1{ Fi:1 FL:31 Fs:15}



static void Test_BFu1i_BFu31ll_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu15s");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu1i_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu15s, BFu1i_BFu31ll_BFu15s)
//============================================================================


struct  BFu1i_BFu31ll_BFu16i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu31ll_BFu16i) C1{ Fi:1 FL:31 Fi:16}



static void Test_BFu1i_BFu31ll_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu16i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu16i, BFu1i_BFu31ll_BFu16i)
//============================================================================


struct  BFu1i_BFu31ll_BFu16ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu31ll_BFu16ll) C1{ Fi:1 FL:31 FL:16}



static void Test_BFu1i_BFu31ll_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu16ll, BFu1i_BFu31ll_BFu16ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu16s  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu31ll_BFu16s) C1{ Fi:1 FL:31 Fs:16}



static void Test_BFu1i_BFu31ll_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu16s");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1i_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu16s, BFu1i_BFu31ll_BFu16s)
//============================================================================


struct  BFu1i_BFu31ll_BFu17i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu31ll_BFu17i) C1{ Fi:1 FL:31 Fi:17}



static void Test_BFu1i_BFu31ll_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu17i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu17i, BFu1i_BFu31ll_BFu17i)
//============================================================================


struct  BFu1i_BFu31ll_BFu17ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu31ll_BFu17ll) C1{ Fi:1 FL:31 FL:17}



static void Test_BFu1i_BFu31ll_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu17ll, BFu1i_BFu31ll_BFu17ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu31ll_BFu1c) C1{ Fi:1 FL:31 Fc:1}



static void Test_BFu1i_BFu31ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu1c, BFu1i_BFu31ll_BFu1c)
//============================================================================


struct  BFu1i_BFu31ll_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu31ll_BFu1i) C1{ Fi:1 FL:31 Fi:1}



static void Test_BFu1i_BFu31ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu1i, BFu1i_BFu31ll_BFu1i)
//============================================================================


struct  BFu1i_BFu31ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu31ll_BFu1ll) C1{ Fi:1 FL:31 FL:1}



static void Test_BFu1i_BFu31ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu1ll, BFu1i_BFu31ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu31ll_BFu1s) C1{ Fi:1 FL:31 Fs:1}



static void Test_BFu1i_BFu31ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu1i_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu1s, BFu1i_BFu31ll_BFu1s)
//============================================================================


struct  BFu1i_BFu31ll_BFu31i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu31ll_BFu31i) C1{ Fi:1 FL:31 Fi:31}



static void Test_BFu1i_BFu31ll_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu31i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu31i, BFu1i_BFu31ll_BFu31i)
//============================================================================


struct  BFu1i_BFu31ll_BFu31ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu31ll_BFu31ll) C1{ Fi:1 FL:31 FL:31}



static void Test_BFu1i_BFu31ll_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu31ll, BFu1i_BFu31ll_BFu31ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu32i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu31ll_BFu32i) C1{ Fi:1 FL:31 Fi:32}



static void Test_BFu1i_BFu31ll_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu32i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu32i, BFu1i_BFu31ll_BFu32i)
//============================================================================


struct  BFu1i_BFu31ll_BFu32ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu31ll_BFu32ll) C1{ Fi:1 FL:31 FL:32}



static void Test_BFu1i_BFu31ll_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu32ll, BFu1i_BFu31ll_BFu32ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu33  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu31ll_BFu33) C1{ Fi:1 FL:31 FL:33}



static void Test_BFu1i_BFu31ll_BFu33()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu33");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu1i_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1i_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu33, BFu1i_BFu31ll_BFu33)
//============================================================================


struct  BFu1i_BFu31ll_BFu7c  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu31ll_BFu7c) C1{ Fi:1 FL:31 Fc:7}



static void Test_BFu1i_BFu31ll_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu7c");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu7c, BFu1i_BFu31ll_BFu7c)
//============================================================================


struct  BFu1i_BFu31ll_BFu7i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu31ll_BFu7i) C1{ Fi:1 FL:31 Fi:7}



static void Test_BFu1i_BFu31ll_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu7i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu7i, BFu1i_BFu31ll_BFu7i)
//============================================================================


struct  BFu1i_BFu31ll_BFu7ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu31ll_BFu7ll) C1{ Fi:1 FL:31 FL:7}



static void Test_BFu1i_BFu31ll_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu7ll, BFu1i_BFu31ll_BFu7ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu7s  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu31ll_BFu7s) C1{ Fi:1 FL:31 Fs:7}



static void Test_BFu1i_BFu31ll_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu7s");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu1i_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu7s, BFu1i_BFu31ll_BFu7s)
//============================================================================


struct  BFu1i_BFu31ll_BFu8c  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu31ll_BFu8c) C1{ Fi:1 FL:31 Fc:8}



static void Test_BFu1i_BFu31ll_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu8c");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu8c, BFu1i_BFu31ll_BFu8c)
//============================================================================


struct  BFu1i_BFu31ll_BFu8i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu31ll_BFu8i) C1{ Fi:1 FL:31 Fi:8}



static void Test_BFu1i_BFu31ll_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu8i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu8i, BFu1i_BFu31ll_BFu8i)
//============================================================================


struct  BFu1i_BFu31ll_BFu8ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu31ll_BFu8ll) C1{ Fi:1 FL:31 FL:8}



static void Test_BFu1i_BFu31ll_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu8ll, BFu1i_BFu31ll_BFu8ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu8s  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu31ll_BFu8s) C1{ Fi:1 FL:31 Fs:8}



static void Test_BFu1i_BFu31ll_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu8s");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu1i_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu8s, BFu1i_BFu31ll_BFu8s)
//============================================================================


struct  BFu1i_BFu31ll_BFu9i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu31ll_BFu9i) C1{ Fi:1 FL:31 Fi:9}



static void Test_BFu1i_BFu31ll_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu9i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu9i, BFu1i_BFu31ll_BFu9i)
//============================================================================


struct  BFu1i_BFu31ll_BFu9ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu31ll_BFu9ll) C1{ Fi:1 FL:31 FL:9}



static void Test_BFu1i_BFu31ll_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu9ll, BFu1i_BFu31ll_BFu9ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu9s  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu31ll_BFu9s) C1{ Fi:1 FL:31 Fs:9}



static void Test_BFu1i_BFu31ll_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu9s");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu1i_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu9s, BFu1i_BFu31ll_BFu9s)
//============================================================================


struct  BFu1i_BFu31ll_C  {
  unsigned int v1:1;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 BFu1i_BFu31ll_C) C1{ Fi:1 FL:31 Fc}



static void Test_BFu1i_BFu31ll_C()
{
  {
    init_simple_test("BFu1i_BFu31ll_C");
    static STRUCT_IF_C BFu1i_BFu31ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_C");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_C");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_C");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_C, BFu1i_BFu31ll_C)
//============================================================================


struct  BFu1i_BFu31ll_D  {
  unsigned int v1:1;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 BFu1i_BFu31ll_D) C1{ Fi:1 FL:31 FL}



static void Test_BFu1i_BFu31ll_D()
{
  {
    init_simple_test("BFu1i_BFu31ll_D");
    static STRUCT_IF_C BFu1i_BFu31ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_D");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_D");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_D, BFu1i_BFu31ll_D)
//============================================================================


struct  BFu1i_BFu31ll_F  {
  unsigned int v1:1;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 BFu1i_BFu31ll_F) C1{ Fi:1 FL:31 Fi}



static void Test_BFu1i_BFu31ll_F()
{
  {
    init_simple_test("BFu1i_BFu31ll_F");
    static STRUCT_IF_C BFu1i_BFu31ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_F");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_F");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_F, BFu1i_BFu31ll_F)
//============================================================================


struct  BFu1i_BFu31ll_I  {
  unsigned int v1:1;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 BFu1i_BFu31ll_I) C1{ Fi:1 FL:31 Fi}



static void Test_BFu1i_BFu31ll_I()
{
  {
    init_simple_test("BFu1i_BFu31ll_I");
    static STRUCT_IF_C BFu1i_BFu31ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_I");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_I");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_I, BFu1i_BFu31ll_I)
//============================================================================


struct  BFu1i_BFu31ll_Ip  {
  unsigned int v1:1;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 BFu1i_BFu31ll_Ip) C1{ Fi:1 FL:31 Fp}



static void Test_BFu1i_BFu31ll_Ip()
{
  {
    init_simple_test("BFu1i_BFu31ll_Ip");
    static STRUCT_IF_C BFu1i_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_Ip, BFu1i_BFu31ll_Ip)
//============================================================================


struct  BFu1i_BFu31ll_L  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu31ll_L) C1{ Fi:1 FL:31 FL}



static void Test_BFu1i_BFu31ll_L()
{
  {
    init_simple_test("BFu1i_BFu31ll_L");
    static STRUCT_IF_C BFu1i_BFu31ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_L");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_L");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_L, BFu1i_BFu31ll_L)
//============================================================================


struct  BFu1i_BFu31ll_S  {
  unsigned int v1:1;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 BFu1i_BFu31ll_S) C1{ Fi:1 FL:31 Fs}



static void Test_BFu1i_BFu31ll_S()
{
  {
    init_simple_test("BFu1i_BFu31ll_S");
    static STRUCT_IF_C BFu1i_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_S");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_S");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_S");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_S, BFu1i_BFu31ll_S)
//============================================================================


struct  BFu1i_BFu31ll_Uc  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu31ll_Uc) C1{ Fi:1 FL:31 Fc}



static void Test_BFu1i_BFu31ll_Uc()
{
  {
    init_simple_test("BFu1i_BFu31ll_Uc");
    static STRUCT_IF_C BFu1i_BFu31ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_Uc");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_Uc, BFu1i_BFu31ll_Uc)
//============================================================================


struct  BFu1i_BFu31ll_Ui  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu31ll_Ui) C1{ Fi:1 FL:31 Fi}



static void Test_BFu1i_BFu31ll_Ui()
{
  {
    init_simple_test("BFu1i_BFu31ll_Ui");
    static STRUCT_IF_C BFu1i_BFu31ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_Ui, BFu1i_BFu31ll_Ui)
//============================================================================


struct  BFu1i_BFu31ll_Ul  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu31ll_Ul) C1{ Fi:1 FL:31 FL}



static void Test_BFu1i_BFu31ll_Ul()
{
  {
    init_simple_test("BFu1i_BFu31ll_Ul");
    static STRUCT_IF_C BFu1i_BFu31ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_Ul, BFu1i_BFu31ll_Ul)
//============================================================================


struct  BFu1i_BFu31ll_Us  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu31ll_Us) C1{ Fi:1 FL:31 Fs}



static void Test_BFu1i_BFu31ll_Us()
{
  {
    init_simple_test("BFu1i_BFu31ll_Us");
    static STRUCT_IF_C BFu1i_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_Us");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_Us, BFu1i_BFu31ll_Us)
//============================================================================


struct  BFu1i_BFu31ll_Vp  {
  unsigned int v1:1;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 BFu1i_BFu31ll_Vp) C1{ Fi:1 FL:31 Fp}



static void Test_BFu1i_BFu31ll_Vp()
{
  {
    init_simple_test("BFu1i_BFu31ll_Vp");
    static STRUCT_IF_C BFu1i_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_Vp, BFu1i_BFu31ll_Vp)
//============================================================================


struct  BFu1i_BFu32i  {
  unsigned int v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu1i_BFu32i) C1{ Fi:1 Fi:32}



static void Test_BFu1i_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu32i");
    static STRUCT_IF_C BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i, BFu1i_BFu32i)
//============================================================================


struct  BFu1i_BFu32i_BFu15i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu32i_BFu15i) C1{ Fi:1 Fi:32 Fi:15}



static void Test_BFu1i_BFu32i_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu15i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu1i_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu15i, BFu1i_BFu32i_BFu15i)
//============================================================================


struct  BFu1i_BFu32i_BFu15ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu32i_BFu15ll) C1{ Fi:1 Fi:32 FL:15}



static void Test_BFu1i_BFu32i_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu1i_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu15ll, BFu1i_BFu32i_BFu15ll)
//============================================================================


struct  BFu1i_BFu32i_BFu15s  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu32i_BFu15s) C1{ Fi:1 Fi:32 Fs:15}



static void Test_BFu1i_BFu32i_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu15s");
    static STRUCT_IF_C BFu1i_BFu32i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu1i_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu15s, BFu1i_BFu32i_BFu15s)
//============================================================================


struct  BFu1i_BFu32i_BFu16i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu32i_BFu16i) C1{ Fi:1 Fi:32 Fi:16}



static void Test_BFu1i_BFu32i_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu16i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu1i_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu16i, BFu1i_BFu32i_BFu16i)
//============================================================================


struct  BFu1i_BFu32i_BFu16ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu32i_BFu16ll) C1{ Fi:1 Fi:32 FL:16}



static void Test_BFu1i_BFu32i_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu1i_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu16ll, BFu1i_BFu32i_BFu16ll)
//============================================================================


struct  BFu1i_BFu32i_BFu16s  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu32i_BFu16s) C1{ Fi:1 Fi:32 Fs:16}



static void Test_BFu1i_BFu32i_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu16s");
    static STRUCT_IF_C BFu1i_BFu32i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu1i_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu16s, BFu1i_BFu32i_BFu16s)
//============================================================================


struct  BFu1i_BFu32i_BFu17i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu32i_BFu17i) C1{ Fi:1 Fi:32 Fi:17}



static void Test_BFu1i_BFu32i_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu17i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu1i_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu17i, BFu1i_BFu32i_BFu17i)
//============================================================================


struct  BFu1i_BFu32i_BFu17ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu32i_BFu17ll) C1{ Fi:1 Fi:32 FL:17}



static void Test_BFu1i_BFu32i_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu1i_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu17ll, BFu1i_BFu32i_BFu17ll)
//============================================================================


struct  BFu1i_BFu32i_BFu1c  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu32i_BFu1c) C1{ Fi:1 Fi:32 Fc:1}



static void Test_BFu1i_BFu32i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu32i_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu1i_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu1c, BFu1i_BFu32i_BFu1c)
//============================================================================


struct  BFu1i_BFu32i_BFu1i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu32i_BFu1i) C1{ Fi:1 Fi:32 Fi:1}



static void Test_BFu1i_BFu32i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu1i_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu1i, BFu1i_BFu32i_BFu1i)
//============================================================================


struct  BFu1i_BFu32i_BFu1ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu32i_BFu1ll) C1{ Fi:1 Fi:32 FL:1}



static void Test_BFu1i_BFu32i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu1i_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu1ll, BFu1i_BFu32i_BFu1ll)
//============================================================================


struct  BFu1i_BFu32i_BFu1s  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu32i_BFu1s) C1{ Fi:1 Fi:32 Fs:1}



static void Test_BFu1i_BFu32i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu32i_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu1i_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu1s, BFu1i_BFu32i_BFu1s)
//============================================================================


struct  BFu1i_BFu32i_BFu31i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu32i_BFu31i) C1{ Fi:1 Fi:32 Fi:31}



static void Test_BFu1i_BFu32i_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu31i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu1i_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu31i, BFu1i_BFu32i_BFu31i)
//============================================================================


struct  BFu1i_BFu32i_BFu31ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu32i_BFu31ll) C1{ Fi:1 Fi:32 FL:31}



static void Test_BFu1i_BFu32i_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu1i_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu31ll, BFu1i_BFu32i_BFu31ll)
//============================================================================


struct  BFu1i_BFu32i_BFu32i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu32i_BFu32i) C1{ Fi:1 Fi:32 Fi:32}



static void Test_BFu1i_BFu32i_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu32i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu1i_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu32i, BFu1i_BFu32i_BFu32i)
//============================================================================


struct  BFu1i_BFu32i_BFu32ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu32i_BFu32ll) C1{ Fi:1 Fi:32 FL:32}



static void Test_BFu1i_BFu32i_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu1i_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu32ll, BFu1i_BFu32i_BFu32ll)
//============================================================================


struct  BFu1i_BFu32i_BFu33  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu32i_BFu33) C1{ Fi:1 Fi:32 FL:33}



static void Test_BFu1i_BFu32i_BFu33()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu33");
    static STRUCT_IF_C BFu1i_BFu32i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "BFu1i_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "BFu1i_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu33, BFu1i_BFu32i_BFu33)
//============================================================================


struct  BFu1i_BFu32i_BFu7c  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu32i_BFu7c) C1{ Fi:1 Fi:32 Fc:7}



static void Test_BFu1i_BFu32i_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu7c");
    static STRUCT_IF_C BFu1i_BFu32i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu1i_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu7c, BFu1i_BFu32i_BFu7c)
//============================================================================


struct  BFu1i_BFu32i_BFu7i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu32i_BFu7i) C1{ Fi:1 Fi:32 Fi:7}



static void Test_BFu1i_BFu32i_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu7i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu1i_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu7i, BFu1i_BFu32i_BFu7i)
//============================================================================


struct  BFu1i_BFu32i_BFu7ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu32i_BFu7ll) C1{ Fi:1 Fi:32 FL:7}



static void Test_BFu1i_BFu32i_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu1i_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu7ll, BFu1i_BFu32i_BFu7ll)
//============================================================================


struct  BFu1i_BFu32i_BFu7s  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu32i_BFu7s) C1{ Fi:1 Fi:32 Fs:7}



static void Test_BFu1i_BFu32i_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu7s");
    static STRUCT_IF_C BFu1i_BFu32i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu1i_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu7s, BFu1i_BFu32i_BFu7s)
//============================================================================


struct  BFu1i_BFu32i_BFu8c  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu32i_BFu8c) C1{ Fi:1 Fi:32 Fc:8}



static void Test_BFu1i_BFu32i_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu8c");
    static STRUCT_IF_C BFu1i_BFu32i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu1i_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu8c, BFu1i_BFu32i_BFu8c)
//============================================================================


struct  BFu1i_BFu32i_BFu8i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu32i_BFu8i) C1{ Fi:1 Fi:32 Fi:8}



static void Test_BFu1i_BFu32i_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu8i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu1i_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu8i, BFu1i_BFu32i_BFu8i)
//============================================================================


struct  BFu1i_BFu32i_BFu8ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu32i_BFu8ll) C1{ Fi:1 Fi:32 FL:8}



static void Test_BFu1i_BFu32i_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu1i_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu8ll, BFu1i_BFu32i_BFu8ll)
//============================================================================


struct  BFu1i_BFu32i_BFu8s  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu32i_BFu8s) C1{ Fi:1 Fi:32 Fs:8}



static void Test_BFu1i_BFu32i_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu8s");
    static STRUCT_IF_C BFu1i_BFu32i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu1i_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu8s, BFu1i_BFu32i_BFu8s)
//============================================================================


struct  BFu1i_BFu32i_BFu9i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu32i_BFu9i) C1{ Fi:1 Fi:32 Fi:9}



static void Test_BFu1i_BFu32i_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu9i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu1i_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu9i, BFu1i_BFu32i_BFu9i)
//============================================================================


struct  BFu1i_BFu32i_BFu9ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu32i_BFu9ll) C1{ Fi:1 Fi:32 FL:9}



static void Test_BFu1i_BFu32i_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu1i_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu9ll, BFu1i_BFu32i_BFu9ll)
//============================================================================


struct  BFu1i_BFu32i_BFu9s  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu32i_BFu9s) C1{ Fi:1 Fi:32 Fs:9}



static void Test_BFu1i_BFu32i_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu9s");
    static STRUCT_IF_C BFu1i_BFu32i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu1i_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu9s, BFu1i_BFu32i_BFu9s)
//============================================================================


struct  BFu1i_BFu32i_C  {
  unsigned int v1:1;
  unsigned int v2:32;
  char v3;
};
//SIG(1 BFu1i_BFu32i_C) C1{ Fi:1 Fi:32 Fc}



static void Test_BFu1i_BFu32i_C()
{
  {
    init_simple_test("BFu1i_BFu32i_C");
    static STRUCT_IF_C BFu1i_BFu32i_C lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_C");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_C, BFu1i_BFu32i_C)
//============================================================================


struct  BFu1i_BFu32i_D  {
  unsigned int v1:1;
  unsigned int v2:32;
  double v3;
};
//SIG(1 BFu1i_BFu32i_D) C1{ Fi:1 Fi:32 FL}



static void Test_BFu1i_BFu32i_D()
{
  {
    init_simple_test("BFu1i_BFu32i_D");
    static STRUCT_IF_C BFu1i_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_D");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_D, BFu1i_BFu32i_D)
//============================================================================


struct  BFu1i_BFu32i_F  {
  unsigned int v1:1;
  unsigned int v2:32;
  float v3;
};
//SIG(1 BFu1i_BFu32i_F) C1{ Fi:1 Fi:32 Fi}



static void Test_BFu1i_BFu32i_F()
{
  {
    init_simple_test("BFu1i_BFu32i_F");
    static STRUCT_IF_C BFu1i_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_F");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_F, BFu1i_BFu32i_F)
//============================================================================


struct  BFu1i_BFu32i_I  {
  unsigned int v1:1;
  unsigned int v2:32;
  int v3;
};
//SIG(1 BFu1i_BFu32i_I) C1{ Fi:1 Fi:32 Fi}



static void Test_BFu1i_BFu32i_I()
{
  {
    init_simple_test("BFu1i_BFu32i_I");
    static STRUCT_IF_C BFu1i_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_I");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_I, BFu1i_BFu32i_I)
//============================================================================


struct  BFu1i_BFu32i_Ip  {
  unsigned int v1:1;
  unsigned int v2:32;
  int *v3;
};
//SIG(1 BFu1i_BFu32i_Ip) C1{ Fi:1 Fi:32 Fp}



static void Test_BFu1i_BFu32i_Ip()
{
  {
    init_simple_test("BFu1i_BFu32i_Ip");
    static STRUCT_IF_C BFu1i_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_Ip, BFu1i_BFu32i_Ip)
//============================================================================


struct  BFu1i_BFu32i_L  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu32i_L) C1{ Fi:1 Fi:32 FL}



static void Test_BFu1i_BFu32i_L()
{
  {
    init_simple_test("BFu1i_BFu32i_L");
    static STRUCT_IF_C BFu1i_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_L");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_L, BFu1i_BFu32i_L)
//============================================================================


struct  BFu1i_BFu32i_S  {
  unsigned int v1:1;
  unsigned int v2:32;
  short v3;
};
//SIG(1 BFu1i_BFu32i_S) C1{ Fi:1 Fi:32 Fs}



static void Test_BFu1i_BFu32i_S()
{
  {
    init_simple_test("BFu1i_BFu32i_S");
    static STRUCT_IF_C BFu1i_BFu32i_S lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_S");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_S, BFu1i_BFu32i_S)
//============================================================================


struct  BFu1i_BFu32i_Uc  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu32i_Uc) C1{ Fi:1 Fi:32 Fc}



static void Test_BFu1i_BFu32i_Uc()
{
  {
    init_simple_test("BFu1i_BFu32i_Uc");
    static STRUCT_IF_C BFu1i_BFu32i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_Uc, BFu1i_BFu32i_Uc)
//============================================================================


struct  BFu1i_BFu32i_Ui  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu32i_Ui) C1{ Fi:1 Fi:32 Fi}



static void Test_BFu1i_BFu32i_Ui()
{
  {
    init_simple_test("BFu1i_BFu32i_Ui");
    static STRUCT_IF_C BFu1i_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_Ui, BFu1i_BFu32i_Ui)
//============================================================================


struct  BFu1i_BFu32i_Ul  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu32i_Ul) C1{ Fi:1 Fi:32 FL}



static void Test_BFu1i_BFu32i_Ul()
{
  {
    init_simple_test("BFu1i_BFu32i_Ul");
    static STRUCT_IF_C BFu1i_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_Ul, BFu1i_BFu32i_Ul)
//============================================================================


struct  BFu1i_BFu32i_Us  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu32i_Us) C1{ Fi:1 Fi:32 Fs}



static void Test_BFu1i_BFu32i_Us()
{
  {
    init_simple_test("BFu1i_BFu32i_Us");
    static STRUCT_IF_C BFu1i_BFu32i_Us lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_Us");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_Us, BFu1i_BFu32i_Us)
//============================================================================


struct  BFu1i_BFu32i_Vp  {
  unsigned int v1:1;
  unsigned int v2:32;
  void *v3;
};
//SIG(1 BFu1i_BFu32i_Vp) C1{ Fi:1 Fi:32 Fp}



static void Test_BFu1i_BFu32i_Vp()
{
  {
    init_simple_test("BFu1i_BFu32i_Vp");
    static STRUCT_IF_C BFu1i_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_Vp, BFu1i_BFu32i_Vp)
//============================================================================


struct  BFu1i_BFu32ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu1i_BFu32ll) C1{ Fi:1 FL:32}



static void Test_BFu1i_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll, BFu1i_BFu32ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu15i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu32ll_BFu15i) C1{ Fi:1 FL:32 Fi:15}



static void Test_BFu1i_BFu32ll_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu15i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "BFu1i_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu15i, BFu1i_BFu32ll_BFu15i)
//============================================================================


struct  BFu1i_BFu32ll_BFu15ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu32ll_BFu15ll) C1{ Fi:1 FL:32 FL:15}



static void Test_BFu1i_BFu32ll_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "BFu1i_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu15ll, BFu1i_BFu32ll_BFu15ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu15s  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu32ll_BFu15s) C1{ Fi:1 FL:32 Fs:15}



static void Test_BFu1i_BFu32ll_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu15s");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "BFu1i_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu15s, BFu1i_BFu32ll_BFu15s)
//============================================================================


struct  BFu1i_BFu32ll_BFu16i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu32ll_BFu16i) C1{ Fi:1 FL:32 Fi:16}



static void Test_BFu1i_BFu32ll_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu16i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "BFu1i_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu16i, BFu1i_BFu32ll_BFu16i)
//============================================================================


struct  BFu1i_BFu32ll_BFu16ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu32ll_BFu16ll) C1{ Fi:1 FL:32 FL:16}



static void Test_BFu1i_BFu32ll_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "BFu1i_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu16ll, BFu1i_BFu32ll_BFu16ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu16s  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu32ll_BFu16s) C1{ Fi:1 FL:32 Fs:16}



static void Test_BFu1i_BFu32ll_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu16s");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu1i_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu16s, BFu1i_BFu32ll_BFu16s)
//============================================================================


struct  BFu1i_BFu32ll_BFu17i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu32ll_BFu17i) C1{ Fi:1 FL:32 Fi:17}



static void Test_BFu1i_BFu32ll_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu17i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "BFu1i_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu17i, BFu1i_BFu32ll_BFu17i)
//============================================================================


struct  BFu1i_BFu32ll_BFu17ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu32ll_BFu17ll) C1{ Fi:1 FL:32 FL:17}



static void Test_BFu1i_BFu32ll_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "BFu1i_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu17ll, BFu1i_BFu32ll_BFu17ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu32ll_BFu1c) C1{ Fi:1 FL:32 Fc:1}



static void Test_BFu1i_BFu32ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "BFu1i_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu1c, BFu1i_BFu32ll_BFu1c)
//============================================================================


struct  BFu1i_BFu32ll_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu32ll_BFu1i) C1{ Fi:1 FL:32 Fi:1}



static void Test_BFu1i_BFu32ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "BFu1i_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu1i, BFu1i_BFu32ll_BFu1i)
//============================================================================


struct  BFu1i_BFu32ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu32ll_BFu1ll) C1{ Fi:1 FL:32 FL:1}



static void Test_BFu1i_BFu32ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "BFu1i_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu1ll, BFu1i_BFu32ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu32ll_BFu1s) C1{ Fi:1 FL:32 Fs:1}



static void Test_BFu1i_BFu32ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "BFu1i_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu1s, BFu1i_BFu32ll_BFu1s)
//============================================================================


struct  BFu1i_BFu32ll_BFu31i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu32ll_BFu31i) C1{ Fi:1 FL:32 Fi:31}



static void Test_BFu1i_BFu32ll_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu31i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "BFu1i_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu31i, BFu1i_BFu32ll_BFu31i)
//============================================================================


struct  BFu1i_BFu32ll_BFu31ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu32ll_BFu31ll) C1{ Fi:1 FL:32 FL:31}



static void Test_BFu1i_BFu32ll_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "BFu1i_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu31ll, BFu1i_BFu32ll_BFu31ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu32i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu32ll_BFu32i) C1{ Fi:1 FL:32 Fi:32}



static void Test_BFu1i_BFu32ll_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu32i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu1i_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu32i, BFu1i_BFu32ll_BFu32i)
//============================================================================


struct  BFu1i_BFu32ll_BFu32ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu32ll_BFu32ll) C1{ Fi:1 FL:32 FL:32}



static void Test_BFu1i_BFu32ll_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "BFu1i_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu32ll, BFu1i_BFu32ll_BFu32ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu33  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu32ll_BFu33) C1{ Fi:1 FL:32 FL:33}



static void Test_BFu1i_BFu32ll_BFu33()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu33");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "BFu1i_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu1i_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu33, BFu1i_BFu32ll_BFu33)
//============================================================================


struct  BFu1i_BFu32ll_BFu7c  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu32ll_BFu7c) C1{ Fi:1 FL:32 Fc:7}



static void Test_BFu1i_BFu32ll_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu7c");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "BFu1i_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu7c, BFu1i_BFu32ll_BFu7c)
//============================================================================


struct  BFu1i_BFu32ll_BFu7i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu32ll_BFu7i) C1{ Fi:1 FL:32 Fi:7}



static void Test_BFu1i_BFu32ll_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu7i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "BFu1i_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu7i, BFu1i_BFu32ll_BFu7i)
//============================================================================


struct  BFu1i_BFu32ll_BFu7ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu32ll_BFu7ll) C1{ Fi:1 FL:32 FL:7}



static void Test_BFu1i_BFu32ll_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "BFu1i_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu7ll, BFu1i_BFu32ll_BFu7ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu7s  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu32ll_BFu7s) C1{ Fi:1 FL:32 Fs:7}



static void Test_BFu1i_BFu32ll_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu7s");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "BFu1i_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu7s, BFu1i_BFu32ll_BFu7s)
//============================================================================


struct  BFu1i_BFu32ll_BFu8c  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu32ll_BFu8c) C1{ Fi:1 FL:32 Fc:8}



static void Test_BFu1i_BFu32ll_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu8c");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu1i_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu8c, BFu1i_BFu32ll_BFu8c)
//============================================================================


struct  BFu1i_BFu32ll_BFu8i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu32ll_BFu8i) C1{ Fi:1 FL:32 Fi:8}



static void Test_BFu1i_BFu32ll_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu8i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "BFu1i_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu8i, BFu1i_BFu32ll_BFu8i)
//============================================================================


struct  BFu1i_BFu32ll_BFu8ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu32ll_BFu8ll) C1{ Fi:1 FL:32 FL:8}



static void Test_BFu1i_BFu32ll_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "BFu1i_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu8ll, BFu1i_BFu32ll_BFu8ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu8s  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu32ll_BFu8s) C1{ Fi:1 FL:32 Fs:8}



static void Test_BFu1i_BFu32ll_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu8s");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "BFu1i_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu8s, BFu1i_BFu32ll_BFu8s)
//============================================================================


struct  BFu1i_BFu32ll_BFu9i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu32ll_BFu9i) C1{ Fi:1 FL:32 Fi:9}



static void Test_BFu1i_BFu32ll_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu9i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "BFu1i_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu9i, BFu1i_BFu32ll_BFu9i)
//============================================================================


struct  BFu1i_BFu32ll_BFu9ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu32ll_BFu9ll) C1{ Fi:1 FL:32 FL:9}



static void Test_BFu1i_BFu32ll_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "BFu1i_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu9ll, BFu1i_BFu32ll_BFu9ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu9s  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu32ll_BFu9s) C1{ Fi:1 FL:32 Fs:9}



static void Test_BFu1i_BFu32ll_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu9s");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "BFu1i_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu9s, BFu1i_BFu32ll_BFu9s)
//============================================================================


struct  BFu1i_BFu32ll_C  {
  unsigned int v1:1;
  __tsu64 v2:32;
  char v3;
};
//SIG(1 BFu1i_BFu32ll_C) C1{ Fi:1 FL:32 Fc}



static void Test_BFu1i_BFu32ll_C()
{
  {
    init_simple_test("BFu1i_BFu32ll_C");
    static STRUCT_IF_C BFu1i_BFu32ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_C");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_C");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_C");
    check_field_offset(lv, v3, 5, "BFu1i_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_C, BFu1i_BFu32ll_C)
//============================================================================


struct  BFu1i_BFu32ll_D  {
  unsigned int v1:1;
  __tsu64 v2:32;
  double v3;
};
//SIG(1 BFu1i_BFu32ll_D) C1{ Fi:1 FL:32 FL}



static void Test_BFu1i_BFu32ll_D()
{
  {
    init_simple_test("BFu1i_BFu32ll_D");
    static STRUCT_IF_C BFu1i_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_D");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_D");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_D");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_D, BFu1i_BFu32ll_D)
//============================================================================


struct  BFu1i_BFu32ll_F  {
  unsigned int v1:1;
  __tsu64 v2:32;
  float v3;
};
//SIG(1 BFu1i_BFu32ll_F) C1{ Fi:1 FL:32 Fi}



static void Test_BFu1i_BFu32ll_F()
{
  {
    init_simple_test("BFu1i_BFu32ll_F");
    static STRUCT_IF_C BFu1i_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_F");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_F");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_F");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_F, BFu1i_BFu32ll_F)
//============================================================================


struct  BFu1i_BFu32ll_I  {
  unsigned int v1:1;
  __tsu64 v2:32;
  int v3;
};
//SIG(1 BFu1i_BFu32ll_I) C1{ Fi:1 FL:32 Fi}



static void Test_BFu1i_BFu32ll_I()
{
  {
    init_simple_test("BFu1i_BFu32ll_I");
    static STRUCT_IF_C BFu1i_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_I");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_I");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_I");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_I, BFu1i_BFu32ll_I)
//============================================================================


struct  BFu1i_BFu32ll_Ip  {
  unsigned int v1:1;
  __tsu64 v2:32;
  int *v3;
};
//SIG(1 BFu1i_BFu32ll_Ip) C1{ Fi:1 FL:32 Fp}



static void Test_BFu1i_BFu32ll_Ip()
{
  {
    init_simple_test("BFu1i_BFu32ll_Ip");
    static STRUCT_IF_C BFu1i_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_Ip, BFu1i_BFu32ll_Ip)
//============================================================================


struct  BFu1i_BFu32ll_L  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu32ll_L) C1{ Fi:1 FL:32 FL}



static void Test_BFu1i_BFu32ll_L()
{
  {
    init_simple_test("BFu1i_BFu32ll_L");
    static STRUCT_IF_C BFu1i_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_L");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_L");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_L");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_L, BFu1i_BFu32ll_L)
//============================================================================


struct  BFu1i_BFu32ll_S  {
  unsigned int v1:1;
  __tsu64 v2:32;
  short v3;
};
//SIG(1 BFu1i_BFu32ll_S) C1{ Fi:1 FL:32 Fs}



static void Test_BFu1i_BFu32ll_S()
{
  {
    init_simple_test("BFu1i_BFu32ll_S");
    static STRUCT_IF_C BFu1i_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_S");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_S");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_S");
    check_field_offset(lv, v3, 6, "BFu1i_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_S, BFu1i_BFu32ll_S)
//============================================================================


struct  BFu1i_BFu32ll_Uc  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu32ll_Uc) C1{ Fi:1 FL:32 Fc}



static void Test_BFu1i_BFu32ll_Uc()
{
  {
    init_simple_test("BFu1i_BFu32ll_Uc");
    static STRUCT_IF_C BFu1i_BFu32ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_Uc");
    check_field_offset(lv, v3, 5, "BFu1i_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_Uc, BFu1i_BFu32ll_Uc)
//============================================================================


struct  BFu1i_BFu32ll_Ui  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu32ll_Ui) C1{ Fi:1 FL:32 Fi}



static void Test_BFu1i_BFu32ll_Ui()
{
  {
    init_simple_test("BFu1i_BFu32ll_Ui");
    static STRUCT_IF_C BFu1i_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_Ui, BFu1i_BFu32ll_Ui)
//============================================================================


struct  BFu1i_BFu32ll_Ul  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu32ll_Ul) C1{ Fi:1 FL:32 FL}



static void Test_BFu1i_BFu32ll_Ul()
{
  {
    init_simple_test("BFu1i_BFu32ll_Ul");
    static STRUCT_IF_C BFu1i_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_Ul, BFu1i_BFu32ll_Ul)
//============================================================================


struct  BFu1i_BFu32ll_Us  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu32ll_Us) C1{ Fi:1 FL:32 Fs}



static void Test_BFu1i_BFu32ll_Us()
{
  {
    init_simple_test("BFu1i_BFu32ll_Us");
    static STRUCT_IF_C BFu1i_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_Us");
    check_field_offset(lv, v3, 6, "BFu1i_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_Us, BFu1i_BFu32ll_Us)
//============================================================================


struct  BFu1i_BFu32ll_Vp  {
  unsigned int v1:1;
  __tsu64 v2:32;
  void *v3;
};
//SIG(1 BFu1i_BFu32ll_Vp) C1{ Fi:1 FL:32 Fp}



static void Test_BFu1i_BFu32ll_Vp()
{
  {
    init_simple_test("BFu1i_BFu32ll_Vp");
    static STRUCT_IF_C BFu1i_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_Vp, BFu1i_BFu32ll_Vp)
//============================================================================


struct  BFu1i_BFu33  {
  unsigned int v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu1i_BFu33) C1{ Fi:1 FL:33}



static void Test_BFu1i_BFu33()
{
  {
    init_simple_test("BFu1i_BFu33");
    static STRUCT_IF_C BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33, BFu1i_BFu33)
//============================================================================


struct  BFu1i_BFu33_BFu15i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu33_BFu15i) C1{ Fi:1 FL:33 Fi:15}



static void Test_BFu1i_BFu33_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu15i");
    static STRUCT_IF_C BFu1i_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 4, 2, 15, 1, "BFu1i_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 4, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu15i, BFu1i_BFu33_BFu15i)
//============================================================================


struct  BFu1i_BFu33_BFu15ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu33_BFu15ll) C1{ Fi:1 FL:33 FL:15}



static void Test_BFu1i_BFu33_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 4, 2, 15, 1, "BFu1i_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 4, 2, 15, hide_ull(1LL<<14), "BFu1i_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu15ll, BFu1i_BFu33_BFu15ll)
//============================================================================


struct  BFu1i_BFu33_BFu15s  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu33_BFu15s) C1{ Fi:1 FL:33 Fs:15}



static void Test_BFu1i_BFu33_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu33_BFu15s");
    static STRUCT_IF_C BFu1i_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu1i_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu15s, BFu1i_BFu33_BFu15s)
//============================================================================


struct  BFu1i_BFu33_BFu16i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu33_BFu16i) C1{ Fi:1 FL:33 Fi:16}



static void Test_BFu1i_BFu33_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu16i");
    static STRUCT_IF_C BFu1i_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 4, 2, 16, 1, "BFu1i_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 4, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu16i, BFu1i_BFu33_BFu16i)
//============================================================================


struct  BFu1i_BFu33_BFu16ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu33_BFu16ll) C1{ Fi:1 FL:33 FL:16}



static void Test_BFu1i_BFu33_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 4, 2, 16, 1, "BFu1i_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 4, 2, 16, hide_ull(1LL<<15), "BFu1i_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu16ll, BFu1i_BFu33_BFu16ll)
//============================================================================


struct  BFu1i_BFu33_BFu16s  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu33_BFu16s) C1{ Fi:1 FL:33 Fs:16}



static void Test_BFu1i_BFu33_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu33_BFu16s");
    static STRUCT_IF_C BFu1i_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu1i_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu16s, BFu1i_BFu33_BFu16s)
//============================================================================


struct  BFu1i_BFu33_BFu17i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu33_BFu17i) C1{ Fi:1 FL:33 Fi:17}



static void Test_BFu1i_BFu33_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu17i");
    static STRUCT_IF_C BFu1i_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 4, 2, 17, 1, "BFu1i_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 4, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu17i, BFu1i_BFu33_BFu17i)
//============================================================================


struct  BFu1i_BFu33_BFu17ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu33_BFu17ll) C1{ Fi:1 FL:33 FL:17}



static void Test_BFu1i_BFu33_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 4, 2, 17, 1, "BFu1i_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 4, 2, 17, hide_ull(1LL<<16), "BFu1i_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu17ll, BFu1i_BFu33_BFu17ll)
//============================================================================


struct  BFu1i_BFu33_BFu1c  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu33_BFu1c) C1{ Fi:1 FL:33 Fc:1}



static void Test_BFu1i_BFu33_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu33_BFu1c");
    static STRUCT_IF_C BFu1i_BFu33_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 4, 2, 1, 1, "BFu1i_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu1c, BFu1i_BFu33_BFu1c)
//============================================================================


struct  BFu1i_BFu33_BFu1i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu33_BFu1i) C1{ Fi:1 FL:33 Fi:1}



static void Test_BFu1i_BFu33_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu1i");
    static STRUCT_IF_C BFu1i_BFu33_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 4, 2, 1, 1, "BFu1i_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu1i, BFu1i_BFu33_BFu1i)
//============================================================================


struct  BFu1i_BFu33_BFu1ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu33_BFu1ll) C1{ Fi:1 FL:33 FL:1}



static void Test_BFu1i_BFu33_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 4, 2, 1, 1, "BFu1i_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu1ll, BFu1i_BFu33_BFu1ll)
//============================================================================


struct  BFu1i_BFu33_BFu1s  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu33_BFu1s) C1{ Fi:1 FL:33 Fs:1}



static void Test_BFu1i_BFu33_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu33_BFu1s");
    static STRUCT_IF_C BFu1i_BFu33_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 4, 2, 1, 1, "BFu1i_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu1s, BFu1i_BFu33_BFu1s)
//============================================================================


struct  BFu1i_BFu33_BFu31i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu33_BFu31i) C1{ Fi:1 FL:33 Fi:31}



static void Test_BFu1i_BFu33_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu31i");
    static STRUCT_IF_C BFu1i_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu1i_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu31i, BFu1i_BFu33_BFu31i)
//============================================================================


struct  BFu1i_BFu33_BFu31ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu33_BFu31ll) C1{ Fi:1 FL:33 FL:31}



static void Test_BFu1i_BFu33_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,2), 31, 1, "BFu1i_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,2), 31, hide_ull(1LL<<30), "BFu1i_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu31ll, BFu1i_BFu33_BFu31ll)
//============================================================================


struct  BFu1i_BFu33_BFu32i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu33_BFu32i) C1{ Fi:1 FL:33 Fi:32}



static void Test_BFu1i_BFu33_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu32i");
    static STRUCT_IF_C BFu1i_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu1i_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu32i, BFu1i_BFu33_BFu32i)
//============================================================================


struct  BFu1i_BFu33_BFu32ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu33_BFu32ll) C1{ Fi:1 FL:33 FL:32}



static void Test_BFu1i_BFu33_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,2), 32, 1, "BFu1i_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,2), 32, hide_ull(1LL<<31), "BFu1i_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu32ll, BFu1i_BFu33_BFu32ll)
//============================================================================


struct  BFu1i_BFu33_BFu33  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu33_BFu33) C1{ Fi:1 FL:33 FL:33}



static void Test_BFu1i_BFu33_BFu33()
{
  {
    init_simple_test("BFu1i_BFu33_BFu33");
    static STRUCT_IF_C BFu1i_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,2), 33, 1, "BFu1i_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,2), 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu33, BFu1i_BFu33_BFu33)
//============================================================================


struct  BFu1i_BFu33_BFu7c  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu33_BFu7c) C1{ Fi:1 FL:33 Fc:7}



static void Test_BFu1i_BFu33_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu33_BFu7c");
    static STRUCT_IF_C BFu1i_BFu33_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu1i_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu7c, BFu1i_BFu33_BFu7c)
//============================================================================


struct  BFu1i_BFu33_BFu7i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu33_BFu7i) C1{ Fi:1 FL:33 Fi:7}



static void Test_BFu1i_BFu33_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu7i");
    static STRUCT_IF_C BFu1i_BFu33_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 4, 2, 7, 1, "BFu1i_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 4, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu7i, BFu1i_BFu33_BFu7i)
//============================================================================


struct  BFu1i_BFu33_BFu7ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu33_BFu7ll) C1{ Fi:1 FL:33 FL:7}



static void Test_BFu1i_BFu33_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 4, 2, 7, 1, "BFu1i_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 4, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu7ll, BFu1i_BFu33_BFu7ll)
//============================================================================


struct  BFu1i_BFu33_BFu7s  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu33_BFu7s) C1{ Fi:1 FL:33 Fs:7}



static void Test_BFu1i_BFu33_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu33_BFu7s");
    static STRUCT_IF_C BFu1i_BFu33_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 4, 2, 7, 1, "BFu1i_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 4, 2, 7, hide_ull(1LL<<6), "BFu1i_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu7s, BFu1i_BFu33_BFu7s)
//============================================================================


struct  BFu1i_BFu33_BFu8c  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu33_BFu8c) C1{ Fi:1 FL:33 Fc:8}



static void Test_BFu1i_BFu33_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu33_BFu8c");
    static STRUCT_IF_C BFu1i_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu1i_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu8c, BFu1i_BFu33_BFu8c)
//============================================================================


struct  BFu1i_BFu33_BFu8i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu33_BFu8i) C1{ Fi:1 FL:33 Fi:8}



static void Test_BFu1i_BFu33_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu8i");
    static STRUCT_IF_C BFu1i_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 4, 2, 8, 1, "BFu1i_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 4, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu8i, BFu1i_BFu33_BFu8i)
//============================================================================


struct  BFu1i_BFu33_BFu8ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu33_BFu8ll) C1{ Fi:1 FL:33 FL:8}



static void Test_BFu1i_BFu33_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 4, 2, 8, 1, "BFu1i_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 4, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu8ll, BFu1i_BFu33_BFu8ll)
//============================================================================


struct  BFu1i_BFu33_BFu8s  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu33_BFu8s) C1{ Fi:1 FL:33 Fs:8}



static void Test_BFu1i_BFu33_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu33_BFu8s");
    static STRUCT_IF_C BFu1i_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 4, 2, 8, 1, "BFu1i_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 4, 2, 8, hide_ull(1LL<<7), "BFu1i_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu8s, BFu1i_BFu33_BFu8s)
//============================================================================


struct  BFu1i_BFu33_BFu9i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu33_BFu9i) C1{ Fi:1 FL:33 Fi:9}



static void Test_BFu1i_BFu33_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu9i");
    static STRUCT_IF_C BFu1i_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 4, 2, 9, 1, "BFu1i_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 4, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu9i, BFu1i_BFu33_BFu9i)
//============================================================================


struct  BFu1i_BFu33_BFu9ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu33_BFu9ll) C1{ Fi:1 FL:33 FL:9}



static void Test_BFu1i_BFu33_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 4, 2, 9, 1, "BFu1i_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 4, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu9ll, BFu1i_BFu33_BFu9ll)
//============================================================================


struct  BFu1i_BFu33_BFu9s  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu33_BFu9s) C1{ Fi:1 FL:33 Fs:9}



static void Test_BFu1i_BFu33_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu33_BFu9s");
    static STRUCT_IF_C BFu1i_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 4, 2, 9, 1, "BFu1i_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 4, 2, 9, hide_ull(1LL<<8), "BFu1i_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu9s, BFu1i_BFu33_BFu9s)
//============================================================================


struct  BFu1i_BFu33_C  {
  unsigned int v1:1;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 BFu1i_BFu33_C) C1{ Fi:1 FL:33 Fc}



static void Test_BFu1i_BFu33_C()
{
  {
    init_simple_test("BFu1i_BFu33_C");
    static STRUCT_IF_C BFu1i_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_C");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_C");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_C");
    check_field_offset(lv, v3, 5, "BFu1i_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_C, BFu1i_BFu33_C)
//============================================================================


struct  BFu1i_BFu33_D  {
  unsigned int v1:1;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 BFu1i_BFu33_D) C1{ Fi:1 FL:33 FL}



static void Test_BFu1i_BFu33_D()
{
  {
    init_simple_test("BFu1i_BFu33_D");
    static STRUCT_IF_C BFu1i_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_D");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_D");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_D");
    check_field_offset(lv, v3, 8, "BFu1i_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_D, BFu1i_BFu33_D)
//============================================================================


struct  BFu1i_BFu33_F  {
  unsigned int v1:1;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 BFu1i_BFu33_F) C1{ Fi:1 FL:33 Fi}



static void Test_BFu1i_BFu33_F()
{
  {
    init_simple_test("BFu1i_BFu33_F");
    static STRUCT_IF_C BFu1i_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_F");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_F");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_F");
    check_field_offset(lv, v3, 8, "BFu1i_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_F, BFu1i_BFu33_F)
//============================================================================


struct  BFu1i_BFu33_I  {
  unsigned int v1:1;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 BFu1i_BFu33_I) C1{ Fi:1 FL:33 Fi}



static void Test_BFu1i_BFu33_I()
{
  {
    init_simple_test("BFu1i_BFu33_I");
    static STRUCT_IF_C BFu1i_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_I");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_I");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_I");
    check_field_offset(lv, v3, 8, "BFu1i_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_I, BFu1i_BFu33_I)
//============================================================================


struct  BFu1i_BFu33_Ip  {
  unsigned int v1:1;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 BFu1i_BFu33_Ip) C1{ Fi:1 FL:33 Fp}



static void Test_BFu1i_BFu33_Ip()
{
  {
    init_simple_test("BFu1i_BFu33_Ip");
    static STRUCT_IF_C BFu1i_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_Ip");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_Ip");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_Ip");
    check_field_offset(lv, v3, 8, "BFu1i_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_Ip, BFu1i_BFu33_Ip)
//============================================================================


struct  BFu1i_BFu33_L  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu33_L) C1{ Fi:1 FL:33 FL}



static void Test_BFu1i_BFu33_L()
{
  {
    init_simple_test("BFu1i_BFu33_L");
    static STRUCT_IF_C BFu1i_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_L");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_L");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_L");
    check_field_offset(lv, v3, 8, "BFu1i_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_L, BFu1i_BFu33_L)
//============================================================================


struct  BFu1i_BFu33_S  {
  unsigned int v1:1;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 BFu1i_BFu33_S) C1{ Fi:1 FL:33 Fs}



static void Test_BFu1i_BFu33_S()
{
  {
    init_simple_test("BFu1i_BFu33_S");
    static STRUCT_IF_C BFu1i_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_S");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_S");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_S");
    check_field_offset(lv, v3, 6, "BFu1i_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_S, BFu1i_BFu33_S)
//============================================================================


struct  BFu1i_BFu33_Uc  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu33_Uc) C1{ Fi:1 FL:33 Fc}



static void Test_BFu1i_BFu33_Uc()
{
  {
    init_simple_test("BFu1i_BFu33_Uc");
    static STRUCT_IF_C BFu1i_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_Uc");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_Uc");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_Uc");
    check_field_offset(lv, v3, 5, "BFu1i_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_Uc, BFu1i_BFu33_Uc)
//============================================================================


struct  BFu1i_BFu33_Ui  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu33_Ui) C1{ Fi:1 FL:33 Fi}



static void Test_BFu1i_BFu33_Ui()
{
  {
    init_simple_test("BFu1i_BFu33_Ui");
    static STRUCT_IF_C BFu1i_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_Ui");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_Ui");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_Ui");
    check_field_offset(lv, v3, 8, "BFu1i_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_Ui, BFu1i_BFu33_Ui)
//============================================================================


struct  BFu1i_BFu33_Ul  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 BFu1i_BFu33_Ul) C1{ Fi:1 FL:33 FL}



static void Test_BFu1i_BFu33_Ul()
{
  {
    init_simple_test("BFu1i_BFu33_Ul");
    static STRUCT_IF_C BFu1i_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu1i_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_Ul");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_Ul");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_Ul");
    check_field_offset(lv, v3, 8, "BFu1i_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_Ul, BFu1i_BFu33_Ul)
//============================================================================


struct  BFu1i_BFu33_Us  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 BFu1i_BFu33_Us) C1{ Fi:1 FL:33 Fs}



static void Test_BFu1i_BFu33_Us()
{
  {
    init_simple_test("BFu1i_BFu33_Us");
    static STRUCT_IF_C BFu1i_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_Us");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_Us");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_Us");
    check_field_offset(lv, v3, 6, "BFu1i_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_Us, BFu1i_BFu33_Us)
//============================================================================


struct  BFu1i_BFu33_Vp  {
  unsigned int v1:1;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 BFu1i_BFu33_Vp) C1{ Fi:1 FL:33 Fp}



static void Test_BFu1i_BFu33_Vp()
{
  {
    init_simple_test("BFu1i_BFu33_Vp");
    static STRUCT_IF_C BFu1i_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_Vp");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_Vp");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_Vp");
    check_field_offset(lv, v3, 8, "BFu1i_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_Vp, BFu1i_BFu33_Vp)
//============================================================================


struct  BFu1i_BFu7c  {
  unsigned int v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu1i_BFu7c) C1{ Fi:1 Fc:7}



static void Test_BFu1i_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu7c");
    static STRUCT_IF_C BFu1i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c, BFu1i_BFu7c)
//============================================================================


struct  BFu1i_BFu7c_BFu15i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu1i_BFu7c_BFu15i) C1{ Fi:1 Fc:7 Fi:15}



static void Test_BFu1i_BFu7c_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu15i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu1i_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu15i, BFu1i_BFu7c_BFu15i)
//============================================================================


struct  BFu1i_BFu7c_BFu15ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_BFu7c_BFu15ll) C1{ Fi:1 Fc:7 FL:15}



static void Test_BFu1i_BFu7c_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu1i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu15ll, BFu1i_BFu7c_BFu15ll)
//============================================================================


struct  BFu1i_BFu7c_BFu15s  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu1i_BFu7c_BFu15s) C1{ Fi:1 Fc:7 Fs:15}



static void Test_BFu1i_BFu7c_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu15s");
    static STRUCT_IF_C BFu1i_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu15s, BFu1i_BFu7c_BFu15s)
//============================================================================


struct  BFu1i_BFu7c_BFu16i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu1i_BFu7c_BFu16i) C1{ Fi:1 Fc:7 Fi:16}



static void Test_BFu1i_BFu7c_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu16i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu1i_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu16i, BFu1i_BFu7c_BFu16i)
//============================================================================


struct  BFu1i_BFu7c_BFu16ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_BFu7c_BFu16ll) C1{ Fi:1 Fc:7 FL:16}



static void Test_BFu1i_BFu7c_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu1i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu16ll, BFu1i_BFu7c_BFu16ll)
//============================================================================


struct  BFu1i_BFu7c_BFu16s  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu1i_BFu7c_BFu16s) C1{ Fi:1 Fc:7 Fs:16}



static void Test_BFu1i_BFu7c_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu16s");
    static STRUCT_IF_C BFu1i_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu16s, BFu1i_BFu7c_BFu16s)
//============================================================================


struct  BFu1i_BFu7c_BFu17i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu1i_BFu7c_BFu17i) C1{ Fi:1 Fc:7 Fi:17}



static void Test_BFu1i_BFu7c_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu17i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu1i_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu17i, BFu1i_BFu7c_BFu17i)
//============================================================================


struct  BFu1i_BFu7c_BFu17ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_BFu7c_BFu17ll) C1{ Fi:1 Fc:7 FL:17}



static void Test_BFu1i_BFu7c_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu1i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu17ll, BFu1i_BFu7c_BFu17ll)
//============================================================================


struct  BFu1i_BFu7c_BFu1c  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu1i_BFu7c_BFu1c) C1{ Fi:1 Fc:7 Fc:1}



static void Test_BFu1i_BFu7c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu7c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu1i_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu1c, BFu1i_BFu7c_BFu1c)
//============================================================================


struct  BFu1i_BFu7c_BFu1i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu1i_BFu7c_BFu1i) C1{ Fi:1 Fc:7 Fi:1}



static void Test_BFu1i_BFu7c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu1i_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu1i, BFu1i_BFu7c_BFu1i)
//============================================================================


struct  BFu1i_BFu7c_BFu1ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_BFu7c_BFu1ll) C1{ Fi:1 Fc:7 FL:1}



static void Test_BFu1i_BFu7c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu1i_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu1ll, BFu1i_BFu7c_BFu1ll)
//============================================================================


struct  BFu1i_BFu7c_BFu1s  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu1i_BFu7c_BFu1s) C1{ Fi:1 Fc:7 Fs:1}



static void Test_BFu1i_BFu7c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu7c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu1i_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu1s, BFu1i_BFu7c_BFu1s)
//============================================================================


struct  BFu1i_BFu7c_BFu31i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu1i_BFu7c_BFu31i) C1{ Fi:1 Fc:7 Fi:31}



static void Test_BFu1i_BFu7c_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu31i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu31i, BFu1i_BFu7c_BFu31i)
//============================================================================


struct  BFu1i_BFu7c_BFu31ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_BFu7c_BFu31ll) C1{ Fi:1 Fc:7 FL:31}



static void Test_BFu1i_BFu7c_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu1i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu31ll, BFu1i_BFu7c_BFu31ll)
//============================================================================


struct  BFu1i_BFu7c_BFu32i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu1i_BFu7c_BFu32i) C1{ Fi:1 Fc:7 Fi:32}



static void Test_BFu1i_BFu7c_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu32i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu32i, BFu1i_BFu7c_BFu32i)
//============================================================================


struct  BFu1i_BFu7c_BFu32ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_BFu7c_BFu32ll) C1{ Fi:1 Fc:7 FL:32}



static void Test_BFu1i_BFu7c_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu1i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu32ll, BFu1i_BFu7c_BFu32ll)
//============================================================================


struct  BFu1i_BFu7c_BFu33  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_BFu7c_BFu33) C1{ Fi:1 Fc:7 FL:33}



static void Test_BFu1i_BFu7c_BFu33()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu33");
    static STRUCT_IF_C BFu1i_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu1i_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu1i_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu33, BFu1i_BFu7c_BFu33)
//============================================================================


struct  BFu1i_BFu7c_BFu7c  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu1i_BFu7c_BFu7c) C1{ Fi:1 Fc:7 Fc:7}



static void Test_BFu1i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu7c");
    static STRUCT_IF_C BFu1i_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu1i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu7c, BFu1i_BFu7c_BFu7c)
//============================================================================


struct  BFu1i_BFu7c_BFu7i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu1i_BFu7c_BFu7i) C1{ Fi:1 Fc:7 Fi:7}



static void Test_BFu1i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu7i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu1i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu7i, BFu1i_BFu7c_BFu7i)
//============================================================================


struct  BFu1i_BFu7c_BFu7ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_BFu7c_BFu7ll) C1{ Fi:1 Fc:7 FL:7}



static void Test_BFu1i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu1i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu7ll, BFu1i_BFu7c_BFu7ll)
//============================================================================


struct  BFu1i_BFu7c_BFu7s  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu1i_BFu7c_BFu7s) C1{ Fi:1 Fc:7 Fs:7}



static void Test_BFu1i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu7s");
    static STRUCT_IF_C BFu1i_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu1i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu7s, BFu1i_BFu7c_BFu7s)
//============================================================================


struct  BFu1i_BFu7c_BFu8c  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu1i_BFu7c_BFu8c) C1{ Fi:1 Fc:7 Fc:8}



static void Test_BFu1i_BFu7c_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu8c");
    static STRUCT_IF_C BFu1i_BFu7c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu1i_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu8c, BFu1i_BFu7c_BFu8c)
//============================================================================


struct  BFu1i_BFu7c_BFu8i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu1i_BFu7c_BFu8i) C1{ Fi:1 Fc:7 Fi:8}



static void Test_BFu1i_BFu7c_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu8i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu1i_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu8i, BFu1i_BFu7c_BFu8i)
//============================================================================


struct  BFu1i_BFu7c_BFu8ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_BFu7c_BFu8ll) C1{ Fi:1 Fc:7 FL:8}



static void Test_BFu1i_BFu7c_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu1i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu8ll, BFu1i_BFu7c_BFu8ll)
//============================================================================


struct  BFu1i_BFu7c_BFu8s  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu1i_BFu7c_BFu8s) C1{ Fi:1 Fc:7 Fs:8}



static void Test_BFu1i_BFu7c_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu8s");
    static STRUCT_IF_C BFu1i_BFu7c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu1i_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu8s, BFu1i_BFu7c_BFu8s)
//============================================================================


struct  BFu1i_BFu7c_BFu9i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu1i_BFu7c_BFu9i) C1{ Fi:1 Fc:7 Fi:9}



static void Test_BFu1i_BFu7c_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu9i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu1i_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu9i, BFu1i_BFu7c_BFu9i)
//============================================================================


struct  BFu1i_BFu7c_BFu9ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_BFu7c_BFu9ll) C1{ Fi:1 Fc:7 FL:9}



static void Test_BFu1i_BFu7c_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu1i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu9ll, BFu1i_BFu7c_BFu9ll)
//============================================================================


struct  BFu1i_BFu7c_BFu9s  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu1i_BFu7c_BFu9s) C1{ Fi:1 Fc:7 Fs:9}



static void Test_BFu1i_BFu7c_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu9s");
    static STRUCT_IF_C BFu1i_BFu7c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu9s, BFu1i_BFu7c_BFu9s)
//============================================================================


struct  BFu1i_BFu7c_C  {
  unsigned int v1:1;
  unsigned char v2:7;
  char v3;
};
//SIG(1 BFu1i_BFu7c_C) C1{ Fi:1 Fc:7 Fc}



static void Test_BFu1i_BFu7c_C()
{
  {
    init_simple_test("BFu1i_BFu7c_C");
    static STRUCT_IF_C BFu1i_BFu7c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_C");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_C");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_C");
    check_field_offset(lv, v3, 1, "BFu1i_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_C, BFu1i_BFu7c_C)
//============================================================================


struct  BFu1i_BFu7c_D  {
  unsigned int v1:1;
  unsigned char v2:7;
  double v3;
};
//SIG(1 BFu1i_BFu7c_D) C1{ Fi:1 Fc:7 FL}



static void Test_BFu1i_BFu7c_D()
{
  {
    init_simple_test("BFu1i_BFu7c_D");
    static STRUCT_IF_C BFu1i_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_D");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_D");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_D, BFu1i_BFu7c_D)
//============================================================================


struct  BFu1i_BFu7c_F  {
  unsigned int v1:1;
  unsigned char v2:7;
  float v3;
};
//SIG(1 BFu1i_BFu7c_F) C1{ Fi:1 Fc:7 Fi}



static void Test_BFu1i_BFu7c_F()
{
  {
    init_simple_test("BFu1i_BFu7c_F");
    static STRUCT_IF_C BFu1i_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_F");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_F");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_F");
    check_field_offset(lv, v3, 4, "BFu1i_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_F, BFu1i_BFu7c_F)
//============================================================================


struct  BFu1i_BFu7c_I  {
  unsigned int v1:1;
  unsigned char v2:7;
  int v3;
};
//SIG(1 BFu1i_BFu7c_I) C1{ Fi:1 Fc:7 Fi}



static void Test_BFu1i_BFu7c_I()
{
  {
    init_simple_test("BFu1i_BFu7c_I");
    static STRUCT_IF_C BFu1i_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_I");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_I");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_I");
    check_field_offset(lv, v3, 4, "BFu1i_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_I, BFu1i_BFu7c_I)
//============================================================================


struct  BFu1i_BFu7c_Ip  {
  unsigned int v1:1;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 BFu1i_BFu7c_Ip) C1{ Fi:1 Fc:7 Fp}



static void Test_BFu1i_BFu7c_Ip()
{
  {
    init_simple_test("BFu1i_BFu7c_Ip");
    static STRUCT_IF_C BFu1i_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_Ip");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_Ip");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_Ip, BFu1i_BFu7c_Ip)
//============================================================================


struct  BFu1i_BFu7c_L  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 BFu1i_BFu7c_L) C1{ Fi:1 Fc:7 FL}



static void Test_BFu1i_BFu7c_L()
{
  {
    init_simple_test("BFu1i_BFu7c_L");
    static STRUCT_IF_C BFu1i_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7c_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_L");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_L");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_L, BFu1i_BFu7c_L)
//============================================================================


struct  BFu1i_BFu7c_S  {
  unsigned int v1:1;
  unsigned char v2:7;
  short v3;
};
//SIG(1 BFu1i_BFu7c_S) C1{ Fi:1 Fc:7 Fs}



static void Test_BFu1i_BFu7c_S()
{
  {
    init_simple_test("BFu1i_BFu7c_S");
    static STRUCT_IF_C BFu1i_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_S");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_S");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_S");
    check_field_offset(lv, v3, 2, "BFu1i_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_S, BFu1i_BFu7c_S)
//============================================================================


struct  BFu1i_BFu7c_Uc  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 BFu1i_BFu7c_Uc) C1{ Fi:1 Fc:7 Fc}



static void Test_BFu1i_BFu7c_Uc()
{
  {
    init_simple_test("BFu1i_BFu7c_Uc");
    static STRUCT_IF_C BFu1i_BFu7c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_Uc");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_Uc");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_Uc");
    check_field_offset(lv, v3, 1, "BFu1i_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_Uc, BFu1i_BFu7c_Uc)
//============================================================================


struct  BFu1i_BFu7c_Ui  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 BFu1i_BFu7c_Ui) C1{ Fi:1 Fc:7 Fi}



static void Test_BFu1i_BFu7c_Ui()
{
  {
    init_simple_test("BFu1i_BFu7c_Ui");
    static STRUCT_IF_C BFu1i_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_Ui");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_Ui");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_Ui");
    check_field_offset(lv, v3, 4, "BFu1i_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_Ui, BFu1i_BFu7c_Ui)
//==========================================================================