// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFu17ll_BFu8s_BFu7ll  {
  __tsu64 v1:17;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_BFu8s_BFu7ll) C1{ FL:17 Fs:8 FL:7}



static void Test_BFu17ll_BFu8s_BFu7ll()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu7ll");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "BFu17ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu7ll, BFu17ll_BFu8s_BFu7ll)
//============================================================================


struct  BFu17ll_BFu8s_BFu7s  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_BFu8s_BFu7s) C1{ FL:17 Fs:8 Fs:7}



static void Test_BFu17ll_BFu8s_BFu7s()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu7s");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "BFu17ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu7s, BFu17ll_BFu8s_BFu7s)
//============================================================================


struct  BFu17ll_BFu8s_BFu8c  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_BFu8s_BFu8c) C1{ FL:17 Fs:8 Fc:8}



static void Test_BFu17ll_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu8c");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu8c, BFu17ll_BFu8s_BFu8c)
//============================================================================


struct  BFu17ll_BFu8s_BFu8i  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_BFu8s_BFu8i) C1{ FL:17 Fs:8 Fi:8}



static void Test_BFu17ll_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu8i");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu8i, BFu17ll_BFu8s_BFu8i)
//============================================================================


struct  BFu17ll_BFu8s_BFu8ll  {
  __tsu64 v1:17;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_BFu8s_BFu8ll) C1{ FL:17 Fs:8 FL:8}



static void Test_BFu17ll_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu8ll");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "BFu17ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu8ll, BFu17ll_BFu8s_BFu8ll)
//============================================================================


struct  BFu17ll_BFu8s_BFu8s  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_BFu8s_BFu8s) C1{ FL:17 Fs:8 Fs:8}



static void Test_BFu17ll_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu8s");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu8s, BFu17ll_BFu8s_BFu8s)
//============================================================================


struct  BFu17ll_BFu8s_BFu9i  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_BFu8s_BFu9i) C1{ FL:17 Fs:8 Fi:9}



static void Test_BFu17ll_BFu8s_BFu9i()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu9i");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu9i, BFu17ll_BFu8s_BFu9i)
//============================================================================


struct  BFu17ll_BFu8s_BFu9ll  {
  __tsu64 v1:17;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_BFu8s_BFu9ll) C1{ FL:17 Fs:8 FL:9}



static void Test_BFu17ll_BFu8s_BFu9ll()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu9ll");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFu17ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu9ll, BFu17ll_BFu8s_BFu9ll)
//============================================================================


struct  BFu17ll_BFu8s_BFu9s  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_BFu8s_BFu9s) C1{ FL:17 Fs:8 Fs:9}



static void Test_BFu17ll_BFu8s_BFu9s()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu9s");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu9s, BFu17ll_BFu8s_BFu9s)
//============================================================================


struct  BFu17ll_BFu8s_C  {
  __tsu64 v1:17;
  unsigned short v2:8;
  char v3;
};
//SIG(1 BFu17ll_BFu8s_C) C1{ FL:17 Fs:8 Fc}



static void Test_BFu17ll_BFu8s_C()
{
  {
    init_simple_test("BFu17ll_BFu8s_C");
    static STRUCT_IF_C BFu17ll_BFu8s_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_C");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_C");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_C");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_C, BFu17ll_BFu8s_C)
//============================================================================


struct  BFu17ll_BFu8s_D  {
  __tsu64 v1:17;
  unsigned short v2:8;
  double v3;
};
//SIG(1 BFu17ll_BFu8s_D) C1{ FL:17 Fs:8 FL}



static void Test_BFu17ll_BFu8s_D()
{
  {
    init_simple_test("BFu17ll_BFu8s_D");
    static STRUCT_IF_C BFu17ll_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_D");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_D");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_D, BFu17ll_BFu8s_D)
//============================================================================


struct  BFu17ll_BFu8s_F  {
  __tsu64 v1:17;
  unsigned short v2:8;
  float v3;
};
//SIG(1 BFu17ll_BFu8s_F) C1{ FL:17 Fs:8 Fi}



static void Test_BFu17ll_BFu8s_F()
{
  {
    init_simple_test("BFu17ll_BFu8s_F");
    static STRUCT_IF_C BFu17ll_BFu8s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_F");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_F");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_F");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_F, BFu17ll_BFu8s_F)
//============================================================================


struct  BFu17ll_BFu8s_I  {
  __tsu64 v1:17;
  unsigned short v2:8;
  int v3;
};
//SIG(1 BFu17ll_BFu8s_I) C1{ FL:17 Fs:8 Fi}



static void Test_BFu17ll_BFu8s_I()
{
  {
    init_simple_test("BFu17ll_BFu8s_I");
    static STRUCT_IF_C BFu17ll_BFu8s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_I");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_I");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_I");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_I, BFu17ll_BFu8s_I)
//============================================================================


struct  BFu17ll_BFu8s_Ip  {
  __tsu64 v1:17;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 BFu17ll_BFu8s_Ip) C1{ FL:17 Fs:8 Fp}



static void Test_BFu17ll_BFu8s_Ip()
{
  {
    init_simple_test("BFu17ll_BFu8s_Ip");
    static STRUCT_IF_C BFu17ll_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_Ip");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_Ip");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_Ip, BFu17ll_BFu8s_Ip)
//============================================================================


struct  BFu17ll_BFu8s_L  {
  __tsu64 v1:17;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 BFu17ll_BFu8s_L) C1{ FL:17 Fs:8 FL}



static void Test_BFu17ll_BFu8s_L()
{
  {
    init_simple_test("BFu17ll_BFu8s_L");
    static STRUCT_IF_C BFu17ll_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_L");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_L");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_L, BFu17ll_BFu8s_L)
//============================================================================


struct  BFu17ll_BFu8s_S  {
  __tsu64 v1:17;
  unsigned short v2:8;
  short v3;
};
//SIG(1 BFu17ll_BFu8s_S) C1{ FL:17 Fs:8 Fs}



static void Test_BFu17ll_BFu8s_S()
{
  {
    init_simple_test("BFu17ll_BFu8s_S");
    static STRUCT_IF_C BFu17ll_BFu8s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_S");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_S");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_S");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_S, BFu17ll_BFu8s_S)
//============================================================================


struct  BFu17ll_BFu8s_Uc  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 BFu17ll_BFu8s_Uc) C1{ FL:17 Fs:8 Fc}



static void Test_BFu17ll_BFu8s_Uc()
{
  {
    init_simple_test("BFu17ll_BFu8s_Uc");
    static STRUCT_IF_C BFu17ll_BFu8s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_Uc");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_Uc");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_Uc");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_Uc, BFu17ll_BFu8s_Uc)
//============================================================================


struct  BFu17ll_BFu8s_Ui  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 BFu17ll_BFu8s_Ui) C1{ FL:17 Fs:8 Fi}



static void Test_BFu17ll_BFu8s_Ui()
{
  {
    init_simple_test("BFu17ll_BFu8s_Ui");
    static STRUCT_IF_C BFu17ll_BFu8s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_Ui");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_Ui");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_Ui");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_Ui, BFu17ll_BFu8s_Ui)
//============================================================================


struct  BFu17ll_BFu8s_Ul  {
  __tsu64 v1:17;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 BFu17ll_BFu8s_Ul) C1{ FL:17 Fs:8 FL}



static void Test_BFu17ll_BFu8s_Ul()
{
  {
    init_simple_test("BFu17ll_BFu8s_Ul");
    static STRUCT_IF_C BFu17ll_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_Ul");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_Ul");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_Ul, BFu17ll_BFu8s_Ul)
//============================================================================


struct  BFu17ll_BFu8s_Us  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 BFu17ll_BFu8s_Us) C1{ FL:17 Fs:8 Fs}



static void Test_BFu17ll_BFu8s_Us()
{
  {
    init_simple_test("BFu17ll_BFu8s_Us");
    static STRUCT_IF_C BFu17ll_BFu8s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_Us");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_Us");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_Us");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_Us, BFu17ll_BFu8s_Us)
//============================================================================


struct  BFu17ll_BFu8s_Vp  {
  __tsu64 v1:17;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 BFu17ll_BFu8s_Vp) C1{ FL:17 Fs:8 Fp}



static void Test_BFu17ll_BFu8s_Vp()
{
  {
    init_simple_test("BFu17ll_BFu8s_Vp");
    static STRUCT_IF_C BFu17ll_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_Vp");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_Vp");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_Vp, BFu17ll_BFu8s_Vp)
//============================================================================


struct  BFu17ll_BFu9i  {
  __tsu64 v1:17;
  unsigned int v2:9;
};
//SIG(1 BFu17ll_BFu9i) C1{ FL:17 Fi:9}



static void Test_BFu17ll_BFu9i()
{
  {
    init_simple_test("BFu17ll_BFu9i");
    static STRUCT_IF_C BFu17ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i, BFu17ll_BFu9i)
//============================================================================


struct  BFu17ll_BFu9i_BFu15i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_BFu9i_BFu15i) C1{ FL:17 Fi:9 Fi:15}



static void Test_BFu17ll_BFu9i_BFu15i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu15i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu15i, BFu17ll_BFu9i_BFu15i)
//============================================================================


struct  BFu17ll_BFu9i_BFu15ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_BFu9i_BFu15ll) C1{ FL:17 Fi:9 FL:15}



static void Test_BFu17ll_BFu9i_BFu15ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu15ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 2, 15, 1, "BFu17ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 2, 15, hide_ull(1LL<<14), "BFu17ll_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu15ll, BFu17ll_BFu9i_BFu15ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu15s  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_BFu9i_BFu15s) C1{ FL:17 Fi:9 Fs:15}



static void Test_BFu17ll_BFu9i_BFu15s()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu15s");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu15s, BFu17ll_BFu9i_BFu15s)
//============================================================================


struct  BFu17ll_BFu9i_BFu16i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_BFu9i_BFu16i) C1{ FL:17 Fi:9 Fi:16}



static void Test_BFu17ll_BFu9i_BFu16i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu16i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu16i, BFu17ll_BFu9i_BFu16i)
//============================================================================


struct  BFu17ll_BFu9i_BFu16ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_BFu9i_BFu16ll) C1{ FL:17 Fi:9 FL:16}



static void Test_BFu17ll_BFu9i_BFu16ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu16ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 2, 16, 1, "BFu17ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 2, 16, hide_ull(1LL<<15), "BFu17ll_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu16ll, BFu17ll_BFu9i_BFu16ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu16s  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_BFu9i_BFu16s) C1{ FL:17 Fi:9 Fs:16}



static void Test_BFu17ll_BFu9i_BFu16s()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu16s");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu16s, BFu17ll_BFu9i_BFu16s)
//============================================================================


struct  BFu17ll_BFu9i_BFu17i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_BFu9i_BFu17i) C1{ FL:17 Fi:9 Fi:17}



static void Test_BFu17ll_BFu9i_BFu17i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu17i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu17i, BFu17ll_BFu9i_BFu17i)
//============================================================================


struct  BFu17ll_BFu9i_BFu17ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_BFu9i_BFu17ll) C1{ FL:17 Fi:9 FL:17}



static void Test_BFu17ll_BFu9i_BFu17ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu17ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 2, 17, 1, "BFu17ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 2, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu17ll, BFu17ll_BFu9i_BFu17ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu1c  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_BFu9i_BFu1c) C1{ FL:17 Fi:9 Fc:1}



static void Test_BFu17ll_BFu9i_BFu1c()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu1c");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu1c, BFu17ll_BFu9i_BFu1c)
//============================================================================


struct  BFu17ll_BFu9i_BFu1i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_BFu9i_BFu1i) C1{ FL:17 Fi:9 Fi:1}



static void Test_BFu17ll_BFu9i_BFu1i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu1i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu1i, BFu17ll_BFu9i_BFu1i)
//============================================================================


struct  BFu17ll_BFu9i_BFu1ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_BFu9i_BFu1ll) C1{ FL:17 Fi:9 FL:1}



static void Test_BFu17ll_BFu9i_BFu1ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu1ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu1ll, BFu17ll_BFu9i_BFu1ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu1s  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_BFu9i_BFu1s) C1{ FL:17 Fi:9 Fs:1}



static void Test_BFu17ll_BFu9i_BFu1s()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu1s");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu1s, BFu17ll_BFu9i_BFu1s)
//============================================================================


struct  BFu17ll_BFu9i_BFu31i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_BFu9i_BFu31i) C1{ FL:17 Fi:9 Fi:31}



static void Test_BFu17ll_BFu9i_BFu31i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu31i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu31i, BFu17ll_BFu9i_BFu31i)
//============================================================================


struct  BFu17ll_BFu9i_BFu31ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_BFu9i_BFu31ll) C1{ FL:17 Fi:9 FL:31}



static void Test_BFu17ll_BFu9i_BFu31ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu31ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 2, 31, 1, "BFu17ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 2, 31, hide_ull(1LL<<30), "BFu17ll_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu31ll, BFu17ll_BFu9i_BFu31ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu32i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_BFu9i_BFu32i) C1{ FL:17 Fi:9 Fi:32}



static void Test_BFu17ll_BFu9i_BFu32i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu32i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu32i, BFu17ll_BFu9i_BFu32i)
//============================================================================


struct  BFu17ll_BFu9i_BFu32ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_BFu9i_BFu32ll) C1{ FL:17 Fi:9 FL:32}



static void Test_BFu17ll_BFu9i_BFu32ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu32ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 2, 32, 1, "BFu17ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 2, 32, hide_ull(1LL<<31), "BFu17ll_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu32ll, BFu17ll_BFu9i_BFu32ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu33  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_BFu9i_BFu33) C1{ FL:17 Fi:9 FL:33}



static void Test_BFu17ll_BFu9i_BFu33()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu33");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 3, 2, 33, 1, "BFu17ll_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 3, 2, 33, hide_ull(1LL<<32), "BFu17ll_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu33, BFu17ll_BFu9i_BFu33)
//============================================================================


struct  BFu17ll_BFu9i_BFu7c  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_BFu9i_BFu7c) C1{ FL:17 Fi:9 Fc:7}



static void Test_BFu17ll_BFu9i_BFu7c()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu7c");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu7c, BFu17ll_BFu9i_BFu7c)
//============================================================================


struct  BFu17ll_BFu9i_BFu7i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_BFu9i_BFu7i) C1{ FL:17 Fi:9 Fi:7}



static void Test_BFu17ll_BFu9i_BFu7i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu7i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu7i, BFu17ll_BFu9i_BFu7i)
//============================================================================


struct  BFu17ll_BFu9i_BFu7ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_BFu9i_BFu7ll) C1{ FL:17 Fi:9 FL:7}



static void Test_BFu17ll_BFu9i_BFu7ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu7ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 2, 7, 1, "BFu17ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 2, 7, hide_ull(1LL<<6), "BFu17ll_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu7ll, BFu17ll_BFu9i_BFu7ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu7s  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_BFu9i_BFu7s) C1{ FL:17 Fi:9 Fs:7}



static void Test_BFu17ll_BFu9i_BFu7s()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu7s");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu7s, BFu17ll_BFu9i_BFu7s)
//============================================================================


struct  BFu17ll_BFu9i_BFu8c  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_BFu9i_BFu8c) C1{ FL:17 Fi:9 Fc:8}



static void Test_BFu17ll_BFu9i_BFu8c()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu8c");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu8c, BFu17ll_BFu9i_BFu8c)
//============================================================================


struct  BFu17ll_BFu9i_BFu8i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_BFu9i_BFu8i) C1{ FL:17 Fi:9 Fi:8}



static void Test_BFu17ll_BFu9i_BFu8i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu8i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu8i, BFu17ll_BFu9i_BFu8i)
//============================================================================


struct  BFu17ll_BFu9i_BFu8ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_BFu9i_BFu8ll) C1{ FL:17 Fi:9 FL:8}



static void Test_BFu17ll_BFu9i_BFu8ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu8ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 2, 8, 1, "BFu17ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 2, 8, hide_ull(1LL<<7), "BFu17ll_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu8ll, BFu17ll_BFu9i_BFu8ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu8s  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_BFu9i_BFu8s) C1{ FL:17 Fi:9 Fs:8}



static void Test_BFu17ll_BFu9i_BFu8s()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu8s");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu8s, BFu17ll_BFu9i_BFu8s)
//============================================================================


struct  BFu17ll_BFu9i_BFu9i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_BFu9i_BFu9i) C1{ FL:17 Fi:9 Fi:9}



static void Test_BFu17ll_BFu9i_BFu9i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu9i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu9i, BFu17ll_BFu9i_BFu9i)
//============================================================================


struct  BFu17ll_BFu9i_BFu9ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_BFu9i_BFu9ll) C1{ FL:17 Fi:9 FL:9}



static void Test_BFu17ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu9ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 2, 9, 1, "BFu17ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 2, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu9ll, BFu17ll_BFu9i_BFu9ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu9s  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_BFu9i_BFu9s) C1{ FL:17 Fi:9 Fs:9}



static void Test_BFu17ll_BFu9i_BFu9s()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu9s");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu9s, BFu17ll_BFu9i_BFu9s)
//============================================================================


struct  BFu17ll_BFu9i_C  {
  __tsu64 v1:17;
  unsigned int v2:9;
  char v3;
};
//SIG(1 BFu17ll_BFu9i_C) C1{ FL:17 Fi:9 Fc}



static void Test_BFu17ll_BFu9i_C()
{
  {
    init_simple_test("BFu17ll_BFu9i_C");
    static STRUCT_IF_C BFu17ll_BFu9i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_C");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_C");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_C");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_C, BFu17ll_BFu9i_C)
//============================================================================


struct  BFu17ll_BFu9i_D  {
  __tsu64 v1:17;
  unsigned int v2:9;
  double v3;
};
//SIG(1 BFu17ll_BFu9i_D) C1{ FL:17 Fi:9 FL}



static void Test_BFu17ll_BFu9i_D()
{
  {
    init_simple_test("BFu17ll_BFu9i_D");
    static STRUCT_IF_C BFu17ll_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_D");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_D");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_D, BFu17ll_BFu9i_D)
//============================================================================


struct  BFu17ll_BFu9i_F  {
  __tsu64 v1:17;
  unsigned int v2:9;
  float v3;
};
//SIG(1 BFu17ll_BFu9i_F) C1{ FL:17 Fi:9 Fi}



static void Test_BFu17ll_BFu9i_F()
{
  {
    init_simple_test("BFu17ll_BFu9i_F");
    static STRUCT_IF_C BFu17ll_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_F");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_F");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_F");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_F, BFu17ll_BFu9i_F)
//============================================================================


struct  BFu17ll_BFu9i_I  {
  __tsu64 v1:17;
  unsigned int v2:9;
  int v3;
};
//SIG(1 BFu17ll_BFu9i_I) C1{ FL:17 Fi:9 Fi}



static void Test_BFu17ll_BFu9i_I()
{
  {
    init_simple_test("BFu17ll_BFu9i_I");
    static STRUCT_IF_C BFu17ll_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_I");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_I");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_I");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_I, BFu17ll_BFu9i_I)
//============================================================================


struct  BFu17ll_BFu9i_Ip  {
  __tsu64 v1:17;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 BFu17ll_BFu9i_Ip) C1{ FL:17 Fi:9 Fp}



static void Test_BFu17ll_BFu9i_Ip()
{
  {
    init_simple_test("BFu17ll_BFu9i_Ip");
    static STRUCT_IF_C BFu17ll_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_Ip");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_Ip");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_Ip, BFu17ll_BFu9i_Ip)
//============================================================================


struct  BFu17ll_BFu9i_L  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 BFu17ll_BFu9i_L) C1{ FL:17 Fi:9 FL}



static void Test_BFu17ll_BFu9i_L()
{
  {
    init_simple_test("BFu17ll_BFu9i_L");
    static STRUCT_IF_C BFu17ll_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_L");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_L");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_L, BFu17ll_BFu9i_L)
//============================================================================


struct  BFu17ll_BFu9i_S  {
  __tsu64 v1:17;
  unsigned int v2:9;
  short v3;
};
//SIG(1 BFu17ll_BFu9i_S) C1{ FL:17 Fi:9 Fs}



static void Test_BFu17ll_BFu9i_S()
{
  {
    init_simple_test("BFu17ll_BFu9i_S");
    static STRUCT_IF_C BFu17ll_BFu9i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_S");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_S");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_S");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_S, BFu17ll_BFu9i_S)
//============================================================================


struct  BFu17ll_BFu9i_Uc  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 BFu17ll_BFu9i_Uc) C1{ FL:17 Fi:9 Fc}



static void Test_BFu17ll_BFu9i_Uc()
{
  {
    init_simple_test("BFu17ll_BFu9i_Uc");
    static STRUCT_IF_C BFu17ll_BFu9i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_Uc");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_Uc");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_Uc");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_Uc, BFu17ll_BFu9i_Uc)
//============================================================================


struct  BFu17ll_BFu9i_Ui  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 BFu17ll_BFu9i_Ui) C1{ FL:17 Fi:9 Fi}



static void Test_BFu17ll_BFu9i_Ui()
{
  {
    init_simple_test("BFu17ll_BFu9i_Ui");
    static STRUCT_IF_C BFu17ll_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_Ui");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_Ui");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_Ui");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_Ui, BFu17ll_BFu9i_Ui)
//============================================================================


struct  BFu17ll_BFu9i_Ul  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 BFu17ll_BFu9i_Ul) C1{ FL:17 Fi:9 FL}



static void Test_BFu17ll_BFu9i_Ul()
{
  {
    init_simple_test("BFu17ll_BFu9i_Ul");
    static STRUCT_IF_C BFu17ll_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_Ul");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_Ul");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_Ul, BFu17ll_BFu9i_Ul)
//============================================================================


struct  BFu17ll_BFu9i_Us  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 BFu17ll_BFu9i_Us) C1{ FL:17 Fi:9 Fs}



static void Test_BFu17ll_BFu9i_Us()
{
  {
    init_simple_test("BFu17ll_BFu9i_Us");
    static STRUCT_IF_C BFu17ll_BFu9i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_Us");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_Us");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_Us");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_Us, BFu17ll_BFu9i_Us)
//============================================================================


struct  BFu17ll_BFu9i_Vp  {
  __tsu64 v1:17;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 BFu17ll_BFu9i_Vp) C1{ FL:17 Fi:9 Fp}



static void Test_BFu17ll_BFu9i_Vp()
{
  {
    init_simple_test("BFu17ll_BFu9i_Vp");
    static STRUCT_IF_C BFu17ll_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_Vp");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_Vp");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_Vp, BFu17ll_BFu9i_Vp)
//============================================================================


struct  BFu17ll_BFu9ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
};
//SIG(1 BFu17ll_BFu9ll) C1{ FL:17 FL:9}



static void Test_BFu17ll_BFu9ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll");
    static STRUCT_IF_C BFu17ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll, BFu17ll_BFu9ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu15i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_BFu9ll_BFu15i) C1{ FL:17 FL:9 Fi:15}



static void Test_BFu17ll_BFu9ll_BFu15i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu15i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu15i, BFu17ll_BFu9ll_BFu15i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu15ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_BFu9ll_BFu15ll) C1{ FL:17 FL:9 FL:15}



static void Test_BFu17ll_BFu9ll_BFu15ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu15ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 2, 15, 1, "BFu17ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 2, 15, hide_ull(1LL<<14), "BFu17ll_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu15ll, BFu17ll_BFu9ll_BFu15ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu15s  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_BFu9ll_BFu15s) C1{ FL:17 FL:9 Fs:15}



static void Test_BFu17ll_BFu9ll_BFu15s()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu15s");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu15s, BFu17ll_BFu9ll_BFu15s)
//============================================================================


struct  BFu17ll_BFu9ll_BFu16i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_BFu9ll_BFu16i) C1{ FL:17 FL:9 Fi:16}



static void Test_BFu17ll_BFu9ll_BFu16i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu16i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu16i, BFu17ll_BFu9ll_BFu16i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu16ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_BFu9ll_BFu16ll) C1{ FL:17 FL:9 FL:16}



static void Test_BFu17ll_BFu9ll_BFu16ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu16ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 2, 16, 1, "BFu17ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 2, 16, hide_ull(1LL<<15), "BFu17ll_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu16ll, BFu17ll_BFu9ll_BFu16ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu16s  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_BFu9ll_BFu16s) C1{ FL:17 FL:9 Fs:16}



static void Test_BFu17ll_BFu9ll_BFu16s()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu16s");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu16s, BFu17ll_BFu9ll_BFu16s)
//============================================================================


struct  BFu17ll_BFu9ll_BFu17i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_BFu9ll_BFu17i) C1{ FL:17 FL:9 Fi:17}



static void Test_BFu17ll_BFu9ll_BFu17i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu17i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu17i, BFu17ll_BFu9ll_BFu17i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu17ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_BFu9ll_BFu17ll) C1{ FL:17 FL:9 FL:17}



static void Test_BFu17ll_BFu9ll_BFu17ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu17ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 2, 17, 1, "BFu17ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 2, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu17ll, BFu17ll_BFu9ll_BFu17ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu1c  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_BFu9ll_BFu1c) C1{ FL:17 FL:9 Fc:1}



static void Test_BFu17ll_BFu9ll_BFu1c()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu1c");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu1c, BFu17ll_BFu9ll_BFu1c)
//============================================================================


struct  BFu17ll_BFu9ll_BFu1i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_BFu9ll_BFu1i) C1{ FL:17 FL:9 Fi:1}



static void Test_BFu17ll_BFu9ll_BFu1i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu1i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu1i, BFu17ll_BFu9ll_BFu1i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu1ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_BFu9ll_BFu1ll) C1{ FL:17 FL:9 FL:1}



static void Test_BFu17ll_BFu9ll_BFu1ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu1ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu1ll, BFu17ll_BFu9ll_BFu1ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu1s  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_BFu9ll_BFu1s) C1{ FL:17 FL:9 Fs:1}



static void Test_BFu17ll_BFu9ll_BFu1s()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu1s");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu1s, BFu17ll_BFu9ll_BFu1s)
//============================================================================


struct  BFu17ll_BFu9ll_BFu31i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_BFu9ll_BFu31i) C1{ FL:17 FL:9 Fi:31}



static void Test_BFu17ll_BFu9ll_BFu31i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu31i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu31i, BFu17ll_BFu9ll_BFu31i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu31ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_BFu9ll_BFu31ll) C1{ FL:17 FL:9 FL:31}



static void Test_BFu17ll_BFu9ll_BFu31ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu31ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 2, 31, 1, "BFu17ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 2, 31, hide_ull(1LL<<30), "BFu17ll_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu31ll, BFu17ll_BFu9ll_BFu31ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu32i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_BFu9ll_BFu32i) C1{ FL:17 FL:9 Fi:32}



static void Test_BFu17ll_BFu9ll_BFu32i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu32i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu32i, BFu17ll_BFu9ll_BFu32i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu32ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_BFu9ll_BFu32ll) C1{ FL:17 FL:9 FL:32}



static void Test_BFu17ll_BFu9ll_BFu32ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu32ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 2, 32, 1, "BFu17ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 2, 32, hide_ull(1LL<<31), "BFu17ll_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu32ll, BFu17ll_BFu9ll_BFu32ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu33  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_BFu9ll_BFu33) C1{ FL:17 FL:9 FL:33}



static void Test_BFu17ll_BFu9ll_BFu33()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu33");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 3, 2, 33, 1, "BFu17ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 3, 2, 33, hide_ull(1LL<<32), "BFu17ll_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu33, BFu17ll_BFu9ll_BFu33)
//============================================================================


struct  BFu17ll_BFu9ll_BFu7c  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_BFu9ll_BFu7c) C1{ FL:17 FL:9 Fc:7}



static void Test_BFu17ll_BFu9ll_BFu7c()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu7c");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu7c, BFu17ll_BFu9ll_BFu7c)
//============================================================================


struct  BFu17ll_BFu9ll_BFu7i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_BFu9ll_BFu7i) C1{ FL:17 FL:9 Fi:7}



static void Test_BFu17ll_BFu9ll_BFu7i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu7i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu7i, BFu17ll_BFu9ll_BFu7i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu7ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_BFu9ll_BFu7ll) C1{ FL:17 FL:9 FL:7}



static void Test_BFu17ll_BFu9ll_BFu7ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu7ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 2, 7, 1, "BFu17ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 2, 7, hide_ull(1LL<<6), "BFu17ll_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu7ll, BFu17ll_BFu9ll_BFu7ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu7s  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_BFu9ll_BFu7s) C1{ FL:17 FL:9 Fs:7}



static void Test_BFu17ll_BFu9ll_BFu7s()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu7s");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu7s, BFu17ll_BFu9ll_BFu7s)
//============================================================================


struct  BFu17ll_BFu9ll_BFu8c  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_BFu9ll_BFu8c) C1{ FL:17 FL:9 Fc:8}



static void Test_BFu17ll_BFu9ll_BFu8c()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu8c");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu8c, BFu17ll_BFu9ll_BFu8c)
//============================================================================


struct  BFu17ll_BFu9ll_BFu8i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_BFu9ll_BFu8i) C1{ FL:17 FL:9 Fi:8}



static void Test_BFu17ll_BFu9ll_BFu8i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu8i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu8i, BFu17ll_BFu9ll_BFu8i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu8ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_BFu9ll_BFu8ll) C1{ FL:17 FL:9 FL:8}



static void Test_BFu17ll_BFu9ll_BFu8ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu8ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 2, 8, 1, "BFu17ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 2, 8, hide_ull(1LL<<7), "BFu17ll_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu8ll, BFu17ll_BFu9ll_BFu8ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu8s  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_BFu9ll_BFu8s) C1{ FL:17 FL:9 Fs:8}



static void Test_BFu17ll_BFu9ll_BFu8s()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu8s");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu8s, BFu17ll_BFu9ll_BFu8s)
//============================================================================


struct  BFu17ll_BFu9ll_BFu9i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_BFu9ll_BFu9i) C1{ FL:17 FL:9 Fi:9}



static void Test_BFu17ll_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu9i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu9i, BFu17ll_BFu9ll_BFu9i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu9ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_BFu9ll_BFu9ll) C1{ FL:17 FL:9 FL:9}



static void Test_BFu17ll_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 2, 9, 1, "BFu17ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 2, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu9ll, BFu17ll_BFu9ll_BFu9ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu9s  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_BFu9ll_BFu9s) C1{ FL:17 FL:9 Fs:9}



static void Test_BFu17ll_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu9s");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu9s, BFu17ll_BFu9ll_BFu9s)
//============================================================================


struct  BFu17ll_BFu9ll_C  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  char v3;
};
//SIG(1 BFu17ll_BFu9ll_C) C1{ FL:17 FL:9 Fc}



static void Test_BFu17ll_BFu9ll_C()
{
  {
    init_simple_test("BFu17ll_BFu9ll_C");
    static STRUCT_IF_C BFu17ll_BFu9ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_C");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_C");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_C");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_C, BFu17ll_BFu9ll_C)
//============================================================================


struct  BFu17ll_BFu9ll_D  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  double v3;
};
//SIG(1 BFu17ll_BFu9ll_D) C1{ FL:17 FL:9 FL}



static void Test_BFu17ll_BFu9ll_D()
{
  {
    init_simple_test("BFu17ll_BFu9ll_D");
    static STRUCT_IF_C BFu17ll_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_D");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_D");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_D, BFu17ll_BFu9ll_D)
//============================================================================


struct  BFu17ll_BFu9ll_F  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  float v3;
};
//SIG(1 BFu17ll_BFu9ll_F) C1{ FL:17 FL:9 Fi}



static void Test_BFu17ll_BFu9ll_F()
{
  {
    init_simple_test("BFu17ll_BFu9ll_F");
    static STRUCT_IF_C BFu17ll_BFu9ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_F");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_F");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_F");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_F, BFu17ll_BFu9ll_F)
//============================================================================


struct  BFu17ll_BFu9ll_I  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  int v3;
};
//SIG(1 BFu17ll_BFu9ll_I) C1{ FL:17 FL:9 Fi}



static void Test_BFu17ll_BFu9ll_I()
{
  {
    init_simple_test("BFu17ll_BFu9ll_I");
    static STRUCT_IF_C BFu17ll_BFu9ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_I");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_I");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_I");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_I, BFu17ll_BFu9ll_I)
//============================================================================


struct  BFu17ll_BFu9ll_Ip  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  int *v3;
};
//SIG(1 BFu17ll_BFu9ll_Ip) C1{ FL:17 FL:9 Fp}



static void Test_BFu17ll_BFu9ll_Ip()
{
  {
    init_simple_test("BFu17ll_BFu9ll_Ip");
    static STRUCT_IF_C BFu17ll_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_Ip, BFu17ll_BFu9ll_Ip)
//============================================================================


struct  BFu17ll_BFu9ll_L  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsi64 v3;
};
//SIG(1 BFu17ll_BFu9ll_L) C1{ FL:17 FL:9 FL}



static void Test_BFu17ll_BFu9ll_L()
{
  {
    init_simple_test("BFu17ll_BFu9ll_L");
    static STRUCT_IF_C BFu17ll_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_L");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_L");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_L, BFu17ll_BFu9ll_L)
//============================================================================


struct  BFu17ll_BFu9ll_S  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  short v3;
};
//SIG(1 BFu17ll_BFu9ll_S) C1{ FL:17 FL:9 Fs}



static void Test_BFu17ll_BFu9ll_S()
{
  {
    init_simple_test("BFu17ll_BFu9ll_S");
    static STRUCT_IF_C BFu17ll_BFu9ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_S");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_S");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_S");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_S, BFu17ll_BFu9ll_S)
//============================================================================


struct  BFu17ll_BFu9ll_Uc  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned char v3;
};
//SIG(1 BFu17ll_BFu9ll_Uc) C1{ FL:17 FL:9 Fc}



static void Test_BFu17ll_BFu9ll_Uc()
{
  {
    init_simple_test("BFu17ll_BFu9ll_Uc");
    static STRUCT_IF_C BFu17ll_BFu9ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_Uc");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_Uc, BFu17ll_BFu9ll_Uc)
//============================================================================


struct  BFu17ll_BFu9ll_Ui  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int v3;
};
//SIG(1 BFu17ll_BFu9ll_Ui) C1{ FL:17 FL:9 Fi}



static void Test_BFu17ll_BFu9ll_Ui()
{
  {
    init_simple_test("BFu17ll_BFu9ll_Ui");
    static STRUCT_IF_C BFu17ll_BFu9ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_Ui");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_Ui, BFu17ll_BFu9ll_Ui)
//============================================================================


struct  BFu17ll_BFu9ll_Ul  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64 v3;
};
//SIG(1 BFu17ll_BFu9ll_Ul) C1{ FL:17 FL:9 FL}



static void Test_BFu17ll_BFu9ll_Ul()
{
  {
    init_simple_test("BFu17ll_BFu9ll_Ul");
    static STRUCT_IF_C BFu17ll_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_Ul, BFu17ll_BFu9ll_Ul)
//============================================================================


struct  BFu17ll_BFu9ll_Us  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned short v3;
};
//SIG(1 BFu17ll_BFu9ll_Us) C1{ FL:17 FL:9 Fs}



static void Test_BFu17ll_BFu9ll_Us()
{
  {
    init_simple_test("BFu17ll_BFu9ll_Us");
    static STRUCT_IF_C BFu17ll_BFu9ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_Us");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_Us");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_Us");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_Us, BFu17ll_BFu9ll_Us)
//============================================================================


struct  BFu17ll_BFu9ll_Vp  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  void *v3;
};
//SIG(1 BFu17ll_BFu9ll_Vp) C1{ FL:17 FL:9 Fp}



static void Test_BFu17ll_BFu9ll_Vp()
{
  {
    init_simple_test("BFu17ll_BFu9ll_Vp");
    static STRUCT_IF_C BFu17ll_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_Vp, BFu17ll_BFu9ll_Vp)
//============================================================================


struct  BFu17ll_BFu9s  {
  __tsu64 v1:17;
  unsigned short v2:9;
};
//SIG(1 BFu17ll_BFu9s) C1{ FL:17 Fs:9}



static void Test_BFu17ll_BFu9s()
{
  {
    init_simple_test("BFu17ll_BFu9s");
    static STRUCT_IF_C BFu17ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s, BFu17ll_BFu9s)
//============================================================================


struct  BFu17ll_BFu9s_BFu15i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_BFu9s_BFu15i) C1{ FL:17 Fs:9 Fi:15}



static void Test_BFu17ll_BFu9s_BFu15i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu15i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu15i, BFu17ll_BFu9s_BFu15i)
//============================================================================


struct  BFu17ll_BFu9s_BFu15ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_BFu9s_BFu15ll) C1{ FL:17 Fs:9 FL:15}



static void Test_BFu17ll_BFu9s_BFu15ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu15ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 2, 15, 1, "BFu17ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 2, 15, hide_ull(1LL<<14), "BFu17ll_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu15ll, BFu17ll_BFu9s_BFu15ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu15s  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_BFu9s_BFu15s) C1{ FL:17 Fs:9 Fs:15}



static void Test_BFu17ll_BFu9s_BFu15s()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu15s");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu15s, BFu17ll_BFu9s_BFu15s)
//============================================================================


struct  BFu17ll_BFu9s_BFu16i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_BFu9s_BFu16i) C1{ FL:17 Fs:9 Fi:16}



static void Test_BFu17ll_BFu9s_BFu16i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu16i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu16i, BFu17ll_BFu9s_BFu16i)
//============================================================================


struct  BFu17ll_BFu9s_BFu16ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_BFu9s_BFu16ll) C1{ FL:17 Fs:9 FL:16}



static void Test_BFu17ll_BFu9s_BFu16ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu16ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 2, 16, 1, "BFu17ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 2, 16, hide_ull(1LL<<15), "BFu17ll_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu16ll, BFu17ll_BFu9s_BFu16ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu16s  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_BFu9s_BFu16s) C1{ FL:17 Fs:9 Fs:16}



static void Test_BFu17ll_BFu9s_BFu16s()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu16s");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu16s, BFu17ll_BFu9s_BFu16s)
//============================================================================


struct  BFu17ll_BFu9s_BFu17i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_BFu9s_BFu17i) C1{ FL:17 Fs:9 Fi:17}



static void Test_BFu17ll_BFu9s_BFu17i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu17i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu17i, BFu17ll_BFu9s_BFu17i)
//============================================================================


struct  BFu17ll_BFu9s_BFu17ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_BFu9s_BFu17ll) C1{ FL:17 Fs:9 FL:17}



static void Test_BFu17ll_BFu9s_BFu17ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu17ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 2, 17, 1, "BFu17ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 2, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu17ll, BFu17ll_BFu9s_BFu17ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu1c  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_BFu9s_BFu1c) C1{ FL:17 Fs:9 Fc:1}



static void Test_BFu17ll_BFu9s_BFu1c()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu1c");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu1c, BFu17ll_BFu9s_BFu1c)
//============================================================================


struct  BFu17ll_BFu9s_BFu1i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_BFu9s_BFu1i) C1{ FL:17 Fs:9 Fi:1}



static void Test_BFu17ll_BFu9s_BFu1i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu1i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu1i, BFu17ll_BFu9s_BFu1i)
//============================================================================


struct  BFu17ll_BFu9s_BFu1ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_BFu9s_BFu1ll) C1{ FL:17 Fs:9 FL:1}



static void Test_BFu17ll_BFu9s_BFu1ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu1ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu1ll, BFu17ll_BFu9s_BFu1ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu1s  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_BFu9s_BFu1s) C1{ FL:17 Fs:9 Fs:1}



static void Test_BFu17ll_BFu9s_BFu1s()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu1s");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 3, 2, 1, 1, "BFu17ll_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu1s, BFu17ll_BFu9s_BFu1s)
//============================================================================


struct  BFu17ll_BFu9s_BFu31i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_BFu9s_BFu31i) C1{ FL:17 Fs:9 Fi:31}



static void Test_BFu17ll_BFu9s_BFu31i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu31i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu31i, BFu17ll_BFu9s_BFu31i)
//============================================================================


struct  BFu17ll_BFu9s_BFu31ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_BFu9s_BFu31ll) C1{ FL:17 Fs:9 FL:31}



static void Test_BFu17ll_BFu9s_BFu31ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu31ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 2, 31, 1, "BFu17ll_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 2, 31, hide_ull(1LL<<30), "BFu17ll_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu31ll, BFu17ll_BFu9s_BFu31ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu32i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_BFu9s_BFu32i) C1{ FL:17 Fs:9 Fi:32}



static void Test_BFu17ll_BFu9s_BFu32i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu32i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu32i, BFu17ll_BFu9s_BFu32i)
//============================================================================


struct  BFu17ll_BFu9s_BFu32ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_BFu9s_BFu32ll) C1{ FL:17 Fs:9 FL:32}



static void Test_BFu17ll_BFu9s_BFu32ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu32ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 2, 32, 1, "BFu17ll_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 2, 32, hide_ull(1LL<<31), "BFu17ll_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu32ll, BFu17ll_BFu9s_BFu32ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu33  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_BFu9s_BFu33) C1{ FL:17 Fs:9 FL:33}



static void Test_BFu17ll_BFu9s_BFu33()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu33");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 2, 33, 1, "BFu17ll_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 2, 33, hide_ull(1LL<<32), "BFu17ll_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu33, BFu17ll_BFu9s_BFu33)
//============================================================================


struct  BFu17ll_BFu9s_BFu7c  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_BFu9s_BFu7c) C1{ FL:17 Fs:9 Fc:7}



static void Test_BFu17ll_BFu9s_BFu7c()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu7c");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu7c, BFu17ll_BFu9s_BFu7c)
//============================================================================


struct  BFu17ll_BFu9s_BFu7i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_BFu9s_BFu7i) C1{ FL:17 Fs:9 Fi:7}



static void Test_BFu17ll_BFu9s_BFu7i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu7i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu7i, BFu17ll_BFu9s_BFu7i)
//============================================================================


struct  BFu17ll_BFu9s_BFu7ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_BFu9s_BFu7ll) C1{ FL:17 Fs:9 FL:7}



static void Test_BFu17ll_BFu9s_BFu7ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu7ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 2, 7, 1, "BFu17ll_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 2, 7, hide_ull(1LL<<6), "BFu17ll_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu7ll, BFu17ll_BFu9s_BFu7ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu7s  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_BFu9s_BFu7s) C1{ FL:17 Fs:9 Fs:7}



static void Test_BFu17ll_BFu9s_BFu7s()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu7s");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu7s, BFu17ll_BFu9s_BFu7s)
//============================================================================


struct  BFu17ll_BFu9s_BFu8c  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_BFu9s_BFu8c) C1{ FL:17 Fs:9 Fc:8}



static void Test_BFu17ll_BFu9s_BFu8c()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu8c");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu8c, BFu17ll_BFu9s_BFu8c)
//============================================================================


struct  BFu17ll_BFu9s_BFu8i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_BFu9s_BFu8i) C1{ FL:17 Fs:9 Fi:8}



static void Test_BFu17ll_BFu9s_BFu8i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu8i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu8i, BFu17ll_BFu9s_BFu8i)
//============================================================================


struct  BFu17ll_BFu9s_BFu8ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_BFu9s_BFu8ll) C1{ FL:17 Fs:9 FL:8}



static void Test_BFu17ll_BFu9s_BFu8ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu8ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 2, 8, 1, "BFu17ll_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 2, 8, hide_ull(1LL<<7), "BFu17ll_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu8ll, BFu17ll_BFu9s_BFu8ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu8s  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_BFu9s_BFu8s) C1{ FL:17 Fs:9 Fs:8}



static void Test_BFu17ll_BFu9s_BFu8s()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu8s");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu8s, BFu17ll_BFu9s_BFu8s)
//============================================================================


struct  BFu17ll_BFu9s_BFu9i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_BFu9s_BFu9i) C1{ FL:17 Fs:9 Fi:9}



static void Test_BFu17ll_BFu9s_BFu9i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu9i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu9i, BFu17ll_BFu9s_BFu9i)
//============================================================================


struct  BFu17ll_BFu9s_BFu9ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_BFu9s_BFu9ll) C1{ FL:17 Fs:9 FL:9}



static void Test_BFu17ll_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu9ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 2, 9, 1, "BFu17ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 2, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu9ll, BFu17ll_BFu9s_BFu9ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu9s  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_BFu9s_BFu9s) C1{ FL:17 Fs:9 Fs:9}



static void Test_BFu17ll_BFu9s_BFu9s()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu9s");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu9s, BFu17ll_BFu9s_BFu9s)
//============================================================================


struct  BFu17ll_BFu9s_C  {
  __tsu64 v1:17;
  unsigned short v2:9;
  char v3;
};
//SIG(1 BFu17ll_BFu9s_C) C1{ FL:17 Fs:9 Fc}



static void Test_BFu17ll_BFu9s_C()
{
  {
    init_simple_test("BFu17ll_BFu9s_C");
    static STRUCT_IF_C BFu17ll_BFu9s_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_C");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_C");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_C");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_C, BFu17ll_BFu9s_C)
//============================================================================


struct  BFu17ll_BFu9s_D  {
  __tsu64 v1:17;
  unsigned short v2:9;
  double v3;
};
//SIG(1 BFu17ll_BFu9s_D) C1{ FL:17 Fs:9 FL}



static void Test_BFu17ll_BFu9s_D()
{
  {
    init_simple_test("BFu17ll_BFu9s_D");
    static STRUCT_IF_C BFu17ll_BFu9s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_D");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_D");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_D, BFu17ll_BFu9s_D)
//============================================================================


struct  BFu17ll_BFu9s_F  {
  __tsu64 v1:17;
  unsigned short v2:9;
  float v3;
};
//SIG(1 BFu17ll_BFu9s_F) C1{ FL:17 Fs:9 Fi}



static void Test_BFu17ll_BFu9s_F()
{
  {
    init_simple_test("BFu17ll_BFu9s_F");
    static STRUCT_IF_C BFu17ll_BFu9s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_F");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_F");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_F");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_F, BFu17ll_BFu9s_F)
//============================================================================


struct  BFu17ll_BFu9s_I  {
  __tsu64 v1:17;
  unsigned short v2:9;
  int v3;
};
//SIG(1 BFu17ll_BFu9s_I) C1{ FL:17 Fs:9 Fi}



static void Test_BFu17ll_BFu9s_I()
{
  {
    init_simple_test("BFu17ll_BFu9s_I");
    static STRUCT_IF_C BFu17ll_BFu9s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_I");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_I");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_I");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_I, BFu17ll_BFu9s_I)
//============================================================================


struct  BFu17ll_BFu9s_Ip  {
  __tsu64 v1:17;
  unsigned short v2:9;
  int *v3;
};
//SIG(1 BFu17ll_BFu9s_Ip) C1{ FL:17 Fs:9 Fp}



static void Test_BFu17ll_BFu9s_Ip()
{
  {
    init_simple_test("BFu17ll_BFu9s_Ip");
    static STRUCT_IF_C BFu17ll_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu9s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_Ip");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_Ip");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_Ip, BFu17ll_BFu9s_Ip)
//============================================================================


struct  BFu17ll_BFu9s_L  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsi64 v3;
};
//SIG(1 BFu17ll_BFu9s_L) C1{ FL:17 Fs:9 FL}



static void Test_BFu17ll_BFu9s_L()
{
  {
    init_simple_test("BFu17ll_BFu9s_L");
    static STRUCT_IF_C BFu17ll_BFu9s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_L");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_L");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_L, BFu17ll_BFu9s_L)
//============================================================================


struct  BFu17ll_BFu9s_S  {
  __tsu64 v1:17;
  unsigned short v2:9;
  short v3;
};
//SIG(1 BFu17ll_BFu9s_S) C1{ FL:17 Fs:9 Fs}



static void Test_BFu17ll_BFu9s_S()
{
  {
    init_simple_test("BFu17ll_BFu9s_S");
    static STRUCT_IF_C BFu17ll_BFu9s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_S");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_S");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_S");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_S, BFu17ll_BFu9s_S)
//============================================================================


struct  BFu17ll_BFu9s_Uc  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned char v3;
};
//SIG(1 BFu17ll_BFu9s_Uc) C1{ FL:17 Fs:9 Fc}



static void Test_BFu17ll_BFu9s_Uc()
{
  {
    init_simple_test("BFu17ll_BFu9s_Uc");
    static STRUCT_IF_C BFu17ll_BFu9s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_Uc");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_Uc");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_Uc");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_Uc, BFu17ll_BFu9s_Uc)
//============================================================================


struct  BFu17ll_BFu9s_Ui  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int v3;
};
//SIG(1 BFu17ll_BFu9s_Ui) C1{ FL:17 Fs:9 Fi}



static void Test_BFu17ll_BFu9s_Ui()
{
  {
    init_simple_test("BFu17ll_BFu9s_Ui");
    static STRUCT_IF_C BFu17ll_BFu9s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_Ui");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_Ui");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_Ui");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_Ui, BFu17ll_BFu9s_Ui)
//============================================================================


struct  BFu17ll_BFu9s_Ul  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64 v3;
};
//SIG(1 BFu17ll_BFu9s_Ul) C1{ FL:17 Fs:9 FL}



static void Test_BFu17ll_BFu9s_Ul()
{
  {
    init_simple_test("BFu17ll_BFu9s_Ul");
    static STRUCT_IF_C BFu17ll_BFu9s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu9s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_Ul");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_Ul");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_Ul, BFu17ll_BFu9s_Ul)
//============================================================================


struct  BFu17ll_BFu9s_Us  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned short v3;
};
//SIG(1 BFu17ll_BFu9s_Us) C1{ FL:17 Fs:9 Fs}



static void Test_BFu17ll_BFu9s_Us()
{
  {
    init_simple_test("BFu17ll_BFu9s_Us");
    static STRUCT_IF_C BFu17ll_BFu9s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_Us");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_Us");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_Us");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_Us, BFu17ll_BFu9s_Us)
//============================================================================


struct  BFu17ll_BFu9s_Vp  {
  __tsu64 v1:17;
  unsigned short v2:9;
  void *v3;
};
//SIG(1 BFu17ll_BFu9s_Vp) C1{ FL:17 Fs:9 Fp}



static void Test_BFu17ll_BFu9s_Vp()
{
  {
    init_simple_test("BFu17ll_BFu9s_Vp");
    static STRUCT_IF_C BFu17ll_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu9s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_Vp");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_Vp");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_Vp, BFu17ll_BFu9s_Vp)
//============================================================================


struct  BFu17ll_C  {
  __tsu64 v1:17;
  char v2;
};
//SIG(1 BFu17ll_C) C1{ FL:17 Fc}



static void Test_BFu17ll_C()
{
  {
    init_simple_test("BFu17ll_C");
    static STRUCT_IF_C BFu17ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C");
    check_field_offset(lv, v2, 3, "BFu17ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C, BFu17ll_C)
//============================================================================


struct  BFu17ll_C_BFu15i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_C_BFu15i) C1{ FL:17 Fc Fi:15}



static void Test_BFu17ll_C_BFu15i()
{
  {
    init_simple_test("BFu17ll_C_BFu15i");
    static STRUCT_IF_C BFu17ll_C_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu15i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_C_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu15i, BFu17ll_C_BFu15i)
//============================================================================


struct  BFu17ll_C_BFu15ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_C_BFu15ll) C1{ FL:17 Fc FL:15}



static void Test_BFu17ll_C_BFu15ll()
{
  {
    init_simple_test("BFu17ll_C_BFu15ll");
    static STRUCT_IF_C BFu17ll_C_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu15ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_C_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu15ll, BFu17ll_C_BFu15ll)
//============================================================================


struct  BFu17ll_C_BFu15s  {
  __tsu64 v1:17;
  char v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_C_BFu15s) C1{ FL:17 Fc Fs:15}



static void Test_BFu17ll_C_BFu15s()
{
  {
    init_simple_test("BFu17ll_C_BFu15s");
    static STRUCT_IF_C BFu17ll_C_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu15s");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_C_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu15s, BFu17ll_C_BFu15s)
//============================================================================


struct  BFu17ll_C_BFu16i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_C_BFu16i) C1{ FL:17 Fc Fi:16}



static void Test_BFu17ll_C_BFu16i()
{
  {
    init_simple_test("BFu17ll_C_BFu16i");
    static STRUCT_IF_C BFu17ll_C_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu16i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_C_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu16i, BFu17ll_C_BFu16i)
//============================================================================


struct  BFu17ll_C_BFu16ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_C_BFu16ll) C1{ FL:17 Fc FL:16}



static void Test_BFu17ll_C_BFu16ll()
{
  {
    init_simple_test("BFu17ll_C_BFu16ll");
    static STRUCT_IF_C BFu17ll_C_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu16ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_C_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu16ll, BFu17ll_C_BFu16ll)
//============================================================================


struct  BFu17ll_C_BFu16s  {
  __tsu64 v1:17;
  char v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_C_BFu16s) C1{ FL:17 Fc Fs:16}



static void Test_BFu17ll_C_BFu16s()
{
  {
    init_simple_test("BFu17ll_C_BFu16s");
    static STRUCT_IF_C BFu17ll_C_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu16s");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_C_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu16s, BFu17ll_C_BFu16s)
//============================================================================


struct  BFu17ll_C_BFu17i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_C_BFu17i) C1{ FL:17 Fc Fi:17}



static void Test_BFu17ll_C_BFu17i()
{
  {
    init_simple_test("BFu17ll_C_BFu17i");
    static STRUCT_IF_C BFu17ll_C_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu17i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_C_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu17i, BFu17ll_C_BFu17i)
//============================================================================


struct  BFu17ll_C_BFu17ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_C_BFu17ll) C1{ FL:17 Fc FL:17}



static void Test_BFu17ll_C_BFu17ll()
{
  {
    init_simple_test("BFu17ll_C_BFu17ll");
    static STRUCT_IF_C BFu17ll_C_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu17ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_C_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu17ll, BFu17ll_C_BFu17ll)
//============================================================================


struct  BFu17ll_C_BFu1c  {
  __tsu64 v1:17;
  char v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_C_BFu1c) C1{ FL:17 Fc Fc:1}



static void Test_BFu17ll_C_BFu1c()
{
  {
    init_simple_test("BFu17ll_C_BFu1c");
    static STRUCT_IF_C BFu17ll_C_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu1c");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu1c, BFu17ll_C_BFu1c)
//============================================================================


struct  BFu17ll_C_BFu1i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_C_BFu1i) C1{ FL:17 Fc Fi:1}



static void Test_BFu17ll_C_BFu1i()
{
  {
    init_simple_test("BFu17ll_C_BFu1i");
    static STRUCT_IF_C BFu17ll_C_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu1i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu1i, BFu17ll_C_BFu1i)
//============================================================================


struct  BFu17ll_C_BFu1ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_C_BFu1ll) C1{ FL:17 Fc FL:1}



static void Test_BFu17ll_C_BFu1ll()
{
  {
    init_simple_test("BFu17ll_C_BFu1ll");
    static STRUCT_IF_C BFu17ll_C_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu1ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu1ll, BFu17ll_C_BFu1ll)
//============================================================================


struct  BFu17ll_C_BFu1s  {
  __tsu64 v1:17;
  char v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_C_BFu1s) C1{ FL:17 Fc Fs:1}



static void Test_BFu17ll_C_BFu1s()
{
  {
    init_simple_test("BFu17ll_C_BFu1s");
    static STRUCT_IF_C BFu17ll_C_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu1s");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu1s, BFu17ll_C_BFu1s)
//============================================================================


struct  BFu17ll_C_BFu31i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_C_BFu31i) C1{ FL:17 Fc Fi:31}



static void Test_BFu17ll_C_BFu31i()
{
  {
    init_simple_test("BFu17ll_C_BFu31i");
    static STRUCT_IF_C BFu17ll_C_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu31i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_C_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu31i, BFu17ll_C_BFu31i)
//============================================================================


struct  BFu17ll_C_BFu31ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_C_BFu31ll) C1{ FL:17 Fc FL:31}



static void Test_BFu17ll_C_BFu31ll()
{
  {
    init_simple_test("BFu17ll_C_BFu31ll");
    static STRUCT_IF_C BFu17ll_C_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu31ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_C_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu31ll, BFu17ll_C_BFu31ll)
//============================================================================


struct  BFu17ll_C_BFu32i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_C_BFu32i) C1{ FL:17 Fc Fi:32}



static void Test_BFu17ll_C_BFu32i()
{
  {
    init_simple_test("BFu17ll_C_BFu32i");
    static STRUCT_IF_C BFu17ll_C_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu32i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_C_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu32i, BFu17ll_C_BFu32i)
//============================================================================


struct  BFu17ll_C_BFu32ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_C_BFu32ll) C1{ FL:17 Fc FL:32}



static void Test_BFu17ll_C_BFu32ll()
{
  {
    init_simple_test("BFu17ll_C_BFu32ll");
    static STRUCT_IF_C BFu17ll_C_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu32ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_C_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu32ll, BFu17ll_C_BFu32ll)
//============================================================================


struct  BFu17ll_C_BFu33  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_C_BFu33) C1{ FL:17 Fc FL:33}



static void Test_BFu17ll_C_BFu33()
{
  {
    init_simple_test("BFu17ll_C_BFu33");
    static STRUCT_IF_C BFu17ll_C_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_C_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu33");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu17ll_C_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu17ll_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu33, BFu17ll_C_BFu33)
//============================================================================


struct  BFu17ll_C_BFu7c  {
  __tsu64 v1:17;
  char v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_C_BFu7c) C1{ FL:17 Fc Fc:7}



static void Test_BFu17ll_C_BFu7c()
{
  {
    init_simple_test("BFu17ll_C_BFu7c");
    static STRUCT_IF_C BFu17ll_C_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu7c");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_C_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu7c, BFu17ll_C_BFu7c)
//============================================================================


struct  BFu17ll_C_BFu7i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_C_BFu7i) C1{ FL:17 Fc Fi:7}



static void Test_BFu17ll_C_BFu7i()
{
  {
    init_simple_test("BFu17ll_C_BFu7i");
    static STRUCT_IF_C BFu17ll_C_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu7i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_C_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu7i, BFu17ll_C_BFu7i)
//============================================================================


struct  BFu17ll_C_BFu7ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_C_BFu7ll) C1{ FL:17 Fc FL:7}



static void Test_BFu17ll_C_BFu7ll()
{
  {
    init_simple_test("BFu17ll_C_BFu7ll");
    static STRUCT_IF_C BFu17ll_C_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu7ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_C_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu7ll, BFu17ll_C_BFu7ll)
//============================================================================


struct  BFu17ll_C_BFu7s  {
  __tsu64 v1:17;
  char v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_C_BFu7s) C1{ FL:17 Fc Fs:7}



static void Test_BFu17ll_C_BFu7s()
{
  {
    init_simple_test("BFu17ll_C_BFu7s");
    static STRUCT_IF_C BFu17ll_C_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu7s");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_C_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu7s, BFu17ll_C_BFu7s)
//============================================================================


struct  BFu17ll_C_BFu8c  {
  __tsu64 v1:17;
  char v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_C_BFu8c) C1{ FL:17 Fc Fc:8}



static void Test_BFu17ll_C_BFu8c()
{
  {
    init_simple_test("BFu17ll_C_BFu8c");
    static STRUCT_IF_C BFu17ll_C_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu8c");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_C_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu8c, BFu17ll_C_BFu8c)
//============================================================================


struct  BFu17ll_C_BFu8i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_C_BFu8i) C1{ FL:17 Fc Fi:8}



static void Test_BFu17ll_C_BFu8i()
{
  {
    init_simple_test("BFu17ll_C_BFu8i");
    static STRUCT_IF_C BFu17ll_C_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu8i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_C_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu8i, BFu17ll_C_BFu8i)
//============================================================================


struct  BFu17ll_C_BFu8ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_C_BFu8ll) C1{ FL:17 Fc FL:8}



static void Test_BFu17ll_C_BFu8ll()
{
  {
    init_simple_test("BFu17ll_C_BFu8ll");
    static STRUCT_IF_C BFu17ll_C_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu8ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_C_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu8ll, BFu17ll_C_BFu8ll)
//============================================================================


struct  BFu17ll_C_BFu8s  {
  __tsu64 v1:17;
  char v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_C_BFu8s) C1{ FL:17 Fc Fs:8}



static void Test_BFu17ll_C_BFu8s()
{
  {
    init_simple_test("BFu17ll_C_BFu8s");
    static STRUCT_IF_C BFu17ll_C_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu8s");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_C_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu8s, BFu17ll_C_BFu8s)
//============================================================================


struct  BFu17ll_C_BFu9i  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_C_BFu9i) C1{ FL:17 Fc Fi:9}



static void Test_BFu17ll_C_BFu9i()
{
  {
    init_simple_test("BFu17ll_C_BFu9i");
    static STRUCT_IF_C BFu17ll_C_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu9i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_C_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu9i, BFu17ll_C_BFu9i)
//============================================================================


struct  BFu17ll_C_BFu9ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_C_BFu9ll) C1{ FL:17 Fc FL:9}



static void Test_BFu17ll_C_BFu9ll()
{
  {
    init_simple_test("BFu17ll_C_BFu9ll");
    static STRUCT_IF_C BFu17ll_C_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu9ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_C_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu9ll, BFu17ll_C_BFu9ll)
//============================================================================


struct  BFu17ll_C_BFu9s  {
  __tsu64 v1:17;
  char v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_C_BFu9s) C1{ FL:17 Fc Fs:9}



static void Test_BFu17ll_C_BFu9s()
{
  {
    init_simple_test("BFu17ll_C_BFu9s");
    static STRUCT_IF_C BFu17ll_C_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu9s");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_C_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu9s, BFu17ll_C_BFu9s)
//============================================================================


struct  BFu17ll_C_C  {
  __tsu64 v1:17;
  char v2;
  char v3;
};
//SIG(1 BFu17ll_C_C) C1{ FL:17 Fc[2]}



static void Test_BFu17ll_C_C()
{
  {
    init_simple_test("BFu17ll_C_C");
    static STRUCT_IF_C BFu17ll_C_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_C");
    check_field_offset(lv, v2, 3, "BFu17ll_C_C.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_C, BFu17ll_C_C)
//============================================================================


struct  BFu17ll_C_D  {
  __tsu64 v1:17;
  char v2;
  double v3;
};
//SIG(1 BFu17ll_C_D) C1{ FL:17 Fc FL}



static void Test_BFu17ll_C_D()
{
  {
    init_simple_test("BFu17ll_C_D");
    static STRUCT_IF_C BFu17ll_C_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_D");
    check_field_offset(lv, v2, 3, "BFu17ll_C_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_D, BFu17ll_C_D)
//============================================================================


struct  BFu17ll_C_F  {
  __tsu64 v1:17;
  char v2;
  float v3;
};
//SIG(1 BFu17ll_C_F) C1{ FL:17 Fc Fi}



static void Test_BFu17ll_C_F()
{
  {
    init_simple_test("BFu17ll_C_F");
    static STRUCT_IF_C BFu17ll_C_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_F");
    check_field_offset(lv, v2, 3, "BFu17ll_C_F.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_F, BFu17ll_C_F)
//============================================================================


struct  BFu17ll_C_I  {
  __tsu64 v1:17;
  char v2;
  int v3;
};
//SIG(1 BFu17ll_C_I) C1{ FL:17 Fc Fi}



static void Test_BFu17ll_C_I()
{
  {
    init_simple_test("BFu17ll_C_I");
    static STRUCT_IF_C BFu17ll_C_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_I");
    check_field_offset(lv, v2, 3, "BFu17ll_C_I.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_I, BFu17ll_C_I)
//============================================================================


struct  BFu17ll_C_Ip  {
  __tsu64 v1:17;
  char v2;
  int *v3;
};
//SIG(1 BFu17ll_C_Ip) C1{ FL:17 Fc Fp}



static void Test_BFu17ll_C_Ip()
{
  {
    init_simple_test("BFu17ll_C_Ip");
    static STRUCT_IF_C BFu17ll_C_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_Ip");
    check_field_offset(lv, v2, 3, "BFu17ll_C_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_Ip, BFu17ll_C_Ip)
//============================================================================


struct  BFu17ll_C_L  {
  __tsu64 v1:17;
  char v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_C_L) C1{ FL:17 Fc FL}



static void Test_BFu17ll_C_L()
{
  {
    init_simple_test("BFu17ll_C_L");
    static STRUCT_IF_C BFu17ll_C_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_L");
    check_field_offset(lv, v2, 3, "BFu17ll_C_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_L, BFu17ll_C_L)
//============================================================================


struct  BFu17ll_C_S  {
  __tsu64 v1:17;
  char v2;
  short v3;
};
//SIG(1 BFu17ll_C_S) C1{ FL:17 Fc Fs}



static void Test_BFu17ll_C_S()
{
  {
    init_simple_test("BFu17ll_C_S");
    static STRUCT_IF_C BFu17ll_C_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_S");
    check_field_offset(lv, v2, 3, "BFu17ll_C_S.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_S, BFu17ll_C_S)
//============================================================================


struct  BFu17ll_C_Uc  {
  __tsu64 v1:17;
  char v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_C_Uc) C1{ FL:17 Fc[2]}



static void Test_BFu17ll_C_Uc()
{
  {
    init_simple_test("BFu17ll_C_Uc");
    static STRUCT_IF_C BFu17ll_C_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_Uc");
    check_field_offset(lv, v2, 3, "BFu17ll_C_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_Uc, BFu17ll_C_Uc)
//============================================================================


struct  BFu17ll_C_Ui  {
  __tsu64 v1:17;
  char v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_C_Ui) C1{ FL:17 Fc Fi}



static void Test_BFu17ll_C_Ui()
{
  {
    init_simple_test("BFu17ll_C_Ui");
    static STRUCT_IF_C BFu17ll_C_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_Ui");
    check_field_offset(lv, v2, 3, "BFu17ll_C_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_Ui, BFu17ll_C_Ui)
//============================================================================


struct  BFu17ll_C_Ul  {
  __tsu64 v1:17;
  char v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_C_Ul) C1{ FL:17 Fc FL}



static void Test_BFu17ll_C_Ul()
{
  {
    init_simple_test("BFu17ll_C_Ul");
    static STRUCT_IF_C BFu17ll_C_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_Ul");
    check_field_offset(lv, v2, 3, "BFu17ll_C_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_Ul, BFu17ll_C_Ul)
//============================================================================


struct  BFu17ll_C_Us  {
  __tsu64 v1:17;
  char v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_C_Us) C1{ FL:17 Fc Fs}



static void Test_BFu17ll_C_Us()
{
  {
    init_simple_test("BFu17ll_C_Us");
    static STRUCT_IF_C BFu17ll_C_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_Us");
    check_field_offset(lv, v2, 3, "BFu17ll_C_Us.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_Us, BFu17ll_C_Us)
//============================================================================


struct  BFu17ll_C_Vp  {
  __tsu64 v1:17;
  char v2;
  void *v3;
};
//SIG(1 BFu17ll_C_Vp) C1{ FL:17 Fc Fp}



static void Test_BFu17ll_C_Vp()
{
  {
    init_simple_test("BFu17ll_C_Vp");
    static STRUCT_IF_C BFu17ll_C_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_Vp");
    check_field_offset(lv, v2, 3, "BFu17ll_C_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_Vp, BFu17ll_C_Vp)
//============================================================================


struct  BFu17ll_D  {
  __tsu64 v1:17;
  double v2;
};
//SIG(1 BFu17ll_D) C1{ FL:17 FL}



static void Test_BFu17ll_D()
{
  {
    init_simple_test("BFu17ll_D");
    static STRUCT_IF_C BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D, BFu17ll_D)
//============================================================================


struct  BFu17ll_D_BFu15i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_D_BFu15i) C1{ FL:17 FL Fi:15}



static void Test_BFu17ll_D_BFu15i()
{
  {
    init_simple_test("BFu17ll_D_BFu15i");
    static STRUCT_IF_C BFu17ll_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu15i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_D_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu15i, BFu17ll_D_BFu15i)
//============================================================================


struct  BFu17ll_D_BFu15ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_D_BFu15ll) C1{ FL:17 FL FL:15}



static void Test_BFu17ll_D_BFu15ll()
{
  {
    init_simple_test("BFu17ll_D_BFu15ll");
    static STRUCT_IF_C BFu17ll_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu15ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_D_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu15ll, BFu17ll_D_BFu15ll)
//============================================================================


struct  BFu17ll_D_BFu15s  {
  __tsu64 v1:17;
  double v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_D_BFu15s) C1{ FL:17 FL Fs:15}



static void Test_BFu17ll_D_BFu15s()
{
  {
    init_simple_test("BFu17ll_D_BFu15s");
    static STRUCT_IF_C BFu17ll_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu15s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_D_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu15s, BFu17ll_D_BFu15s)
//============================================================================


struct  BFu17ll_D_BFu16i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_D_BFu16i) C1{ FL:17 FL Fi:16}



static void Test_BFu17ll_D_BFu16i()
{
  {
    init_simple_test("BFu17ll_D_BFu16i");
    static STRUCT_IF_C BFu17ll_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu16i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_D_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu16i, BFu17ll_D_BFu16i)
//============================================================================


struct  BFu17ll_D_BFu16ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_D_BFu16ll) C1{ FL:17 FL FL:16}



static void Test_BFu17ll_D_BFu16ll()
{
  {
    init_simple_test("BFu17ll_D_BFu16ll");
    static STRUCT_IF_C BFu17ll_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu16ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_D_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu16ll, BFu17ll_D_BFu16ll)
//============================================================================


struct  BFu17ll_D_BFu16s  {
  __tsu64 v1:17;
  double v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_D_BFu16s) C1{ FL:17 FL Fs:16}



static void Test_BFu17ll_D_BFu16s()
{
  {
    init_simple_test("BFu17ll_D_BFu16s");
    static STRUCT_IF_C BFu17ll_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu16s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_D_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu16s, BFu17ll_D_BFu16s)
//============================================================================


struct  BFu17ll_D_BFu17i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_D_BFu17i) C1{ FL:17 FL Fi:17}



static void Test_BFu17ll_D_BFu17i()
{
  {
    init_simple_test("BFu17ll_D_BFu17i");
    static STRUCT_IF_C BFu17ll_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu17i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu17ll_D_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu17i, BFu17ll_D_BFu17i)
//============================================================================


struct  BFu17ll_D_BFu17ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_D_BFu17ll) C1{ FL:17 FL FL:17}



static void Test_BFu17ll_D_BFu17ll()
{
  {
    init_simple_test("BFu17ll_D_BFu17ll");
    static STRUCT_IF_C BFu17ll_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu17ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu17ll_D_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu17ll, BFu17ll_D_BFu17ll)
//============================================================================


struct  BFu17ll_D_BFu1c  {
  __tsu64 v1:17;
  double v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_D_BFu1c) C1{ FL:17 FL Fc:1}



static void Test_BFu17ll_D_BFu1c()
{
  {
    init_simple_test("BFu17ll_D_BFu1c");
    static STRUCT_IF_C BFu17ll_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu1c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu1c, BFu17ll_D_BFu1c)
//============================================================================


struct  BFu17ll_D_BFu1i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_D_BFu1i) C1{ FL:17 FL Fi:1}



static void Test_BFu17ll_D_BFu1i()
{
  {
    init_simple_test("BFu17ll_D_BFu1i");
    static STRUCT_IF_C BFu17ll_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu1i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu1i, BFu17ll_D_BFu1i)
//============================================================================


struct  BFu17ll_D_BFu1ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_D_BFu1ll) C1{ FL:17 FL FL:1}



static void Test_BFu17ll_D_BFu1ll()
{
  {
    init_simple_test("BFu17ll_D_BFu1ll");
    static STRUCT_IF_C BFu17ll_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu1ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu1ll, BFu17ll_D_BFu1ll)
//============================================================================


struct  BFu17ll_D_BFu1s  {
  __tsu64 v1:17;
  double v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_D_BFu1s) C1{ FL:17 FL Fs:1}



static void Test_BFu17ll_D_BFu1s()
{
  {
    init_simple_test("BFu17ll_D_BFu1s");
    static STRUCT_IF_C BFu17ll_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu1s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu1s, BFu17ll_D_BFu1s)
//============================================================================


struct  BFu17ll_D_BFu31i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_D_BFu31i) C1{ FL:17 FL Fi:31}



static void Test_BFu17ll_D_BFu31i()
{
  {
    init_simple_test("BFu17ll_D_BFu31i");
    static STRUCT_IF_C BFu17ll_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu31i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu17ll_D_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu17ll_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu31i, BFu17ll_D_BFu31i)
//============================================================================


struct  BFu17ll_D_BFu31ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_D_BFu31ll) C1{ FL:17 FL FL:31}



static void Test_BFu17ll_D_BFu31ll()
{
  {
    init_simple_test("BFu17ll_D_BFu31ll");
    static STRUCT_IF_C BFu17ll_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu31ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu17ll_D_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu17ll_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu31ll, BFu17ll_D_BFu31ll)
//============================================================================


struct  BFu17ll_D_BFu32i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_D_BFu32i) C1{ FL:17 FL Fi:32}



static void Test_BFu17ll_D_BFu32i()
{
  {
    init_simple_test("BFu17ll_D_BFu32i");
    static STRUCT_IF_C BFu17ll_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu32i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu17ll_D_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu17ll_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu32i, BFu17ll_D_BFu32i)
//============================================================================


struct  BFu17ll_D_BFu32ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_D_BFu32ll) C1{ FL:17 FL FL:32}



static void Test_BFu17ll_D_BFu32ll()
{
  {
    init_simple_test("BFu17ll_D_BFu32ll");
    static STRUCT_IF_C BFu17ll_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu32ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu17ll_D_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu17ll_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu32ll, BFu17ll_D_BFu32ll)
//============================================================================


struct  BFu17ll_D_BFu33  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_D_BFu33) C1{ FL:17 FL FL:33}



static void Test_BFu17ll_D_BFu33()
{
  {
    init_simple_test("BFu17ll_D_BFu33");
    static STRUCT_IF_C BFu17ll_D_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu33");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "BFu17ll_D_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "BFu17ll_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu33, BFu17ll_D_BFu33)
//============================================================================


struct  BFu17ll_D_BFu7c  {
  __tsu64 v1:17;
  double v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_D_BFu7c) C1{ FL:17 FL Fc:7}



static void Test_BFu17ll_D_BFu7c()
{
  {
    init_simple_test("BFu17ll_D_BFu7c");
    static STRUCT_IF_C BFu17ll_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu7c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_D_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu7c, BFu17ll_D_BFu7c)
//============================================================================


struct  BFu17ll_D_BFu7i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_D_BFu7i) C1{ FL:17 FL Fi:7}



static void Test_BFu17ll_D_BFu7i()
{
  {
    init_simple_test("BFu17ll_D_BFu7i");
    static STRUCT_IF_C BFu17ll_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu7i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_D_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu7i, BFu17ll_D_BFu7i)
//============================================================================


struct  BFu17ll_D_BFu7ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_D_BFu7ll) C1{ FL:17 FL FL:7}



static void Test_BFu17ll_D_BFu7ll()
{
  {
    init_simple_test("BFu17ll_D_BFu7ll");
    static STRUCT_IF_C BFu17ll_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu7ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_D_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu7ll, BFu17ll_D_BFu7ll)
//============================================================================


struct  BFu17ll_D_BFu7s  {
  __tsu64 v1:17;
  double v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_D_BFu7s) C1{ FL:17 FL Fs:7}



static void Test_BFu17ll_D_BFu7s()
{
  {
    init_simple_test("BFu17ll_D_BFu7s");
    static STRUCT_IF_C BFu17ll_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu7s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_D_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu7s, BFu17ll_D_BFu7s)
//============================================================================


struct  BFu17ll_D_BFu8c  {
  __tsu64 v1:17;
  double v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_D_BFu8c) C1{ FL:17 FL Fc:8}



static void Test_BFu17ll_D_BFu8c()
{
  {
    init_simple_test("BFu17ll_D_BFu8c");
    static STRUCT_IF_C BFu17ll_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu8c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_D_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu8c, BFu17ll_D_BFu8c)
//============================================================================


struct  BFu17ll_D_BFu8i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_D_BFu8i) C1{ FL:17 FL Fi:8}



static void Test_BFu17ll_D_BFu8i()
{
  {
    init_simple_test("BFu17ll_D_BFu8i");
    static STRUCT_IF_C BFu17ll_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu8i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_D_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu8i, BFu17ll_D_BFu8i)
//============================================================================


struct  BFu17ll_D_BFu8ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_D_BFu8ll) C1{ FL:17 FL FL:8}



static void Test_BFu17ll_D_BFu8ll()
{
  {
    init_simple_test("BFu17ll_D_BFu8ll");
    static STRUCT_IF_C BFu17ll_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu8ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_D_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu8ll, BFu17ll_D_BFu8ll)
//============================================================================


struct  BFu17ll_D_BFu8s  {
  __tsu64 v1:17;
  double v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_D_BFu8s) C1{ FL:17 FL Fs:8}



static void Test_BFu17ll_D_BFu8s()
{
  {
    init_simple_test("BFu17ll_D_BFu8s");
    static STRUCT_IF_C BFu17ll_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu8s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_D_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu8s, BFu17ll_D_BFu8s)
//============================================================================


struct  BFu17ll_D_BFu9i  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_D_BFu9i) C1{ FL:17 FL Fi:9}



static void Test_BFu17ll_D_BFu9i()
{
  {
    init_simple_test("BFu17ll_D_BFu9i");
    static STRUCT_IF_C BFu17ll_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu9i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_D_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu9i, BFu17ll_D_BFu9i)
//============================================================================


struct  BFu17ll_D_BFu9ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_D_BFu9ll) C1{ FL:17 FL FL:9}



static void Test_BFu17ll_D_BFu9ll()
{
  {
    init_simple_test("BFu17ll_D_BFu9ll");
    static STRUCT_IF_C BFu17ll_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu9ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_D_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu9ll, BFu17ll_D_BFu9ll)
//============================================================================


struct  BFu17ll_D_BFu9s  {
  __tsu64 v1:17;
  double v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_D_BFu9s) C1{ FL:17 FL Fs:9}



static void Test_BFu17ll_D_BFu9s()
{
  {
    init_simple_test("BFu17ll_D_BFu9s");
    static STRUCT_IF_C BFu17ll_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu9s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_D_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu9s, BFu17ll_D_BFu9s)
//============================================================================


struct  BFu17ll_D_C  {
  __tsu64 v1:17;
  double v2;
  char v3;
};
//SIG(1 BFu17ll_D_C) C1{ FL:17 FL Fc}



static void Test_BFu17ll_D_C()
{
  {
    init_simple_test("BFu17ll_D_C");
    static STRUCT_IF_C BFu17ll_D_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_C, BFu17ll_D_C)
//============================================================================


struct  BFu17ll_D_D  {
  __tsu64 v1:17;
  double v2;
  double v3;
};
//SIG(1 BFu17ll_D_D) C1{ FL:17 FL[2]}



static void Test_BFu17ll_D_D()
{
  {
    init_simple_test("BFu17ll_D_D");
    static STRUCT_IF_C BFu17ll_D_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_D, BFu17ll_D_D)
//============================================================================


struct  BFu17ll_D_F  {
  __tsu64 v1:17;
  double v2;
  float v3;
};
//SIG(1 BFu17ll_D_F) C1{ FL:17 FL Fi}



static void Test_BFu17ll_D_F()
{
  {
    init_simple_test("BFu17ll_D_F");
    static STRUCT_IF_C BFu17ll_D_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_F, BFu17ll_D_F)
//============================================================================


struct  BFu17ll_D_I  {
  __tsu64 v1:17;
  double v2;
  int v3;
};
//SIG(1 BFu17ll_D_I) C1{ FL:17 FL Fi}



static void Test_BFu17ll_D_I()
{
  {
    init_simple_test("BFu17ll_D_I");
    static STRUCT_IF_C BFu17ll_D_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_I, BFu17ll_D_I)
//============================================================================


struct  BFu17ll_D_Ip  {
  __tsu64 v1:17;
  double v2;
  int *v3;
};
//SIG(1 BFu17ll_D_Ip) C1{ FL:17 FL Fp}



static void Test_BFu17ll_D_Ip()
{
  {
    init_simple_test("BFu17ll_D_Ip");
    static STRUCT_IF_C BFu17ll_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_Ip, BFu17ll_D_Ip)
//============================================================================


struct  BFu17ll_D_L  {
  __tsu64 v1:17;
  double v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_D_L) C1{ FL:17 FL[2]}



static void Test_BFu17ll_D_L()
{
  {
    init_simple_test("BFu17ll_D_L");
    static STRUCT_IF_C BFu17ll_D_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_L, BFu17ll_D_L)
//============================================================================


struct  BFu17ll_D_S  {
  __tsu64 v1:17;
  double v2;
  short v3;
};
//SIG(1 BFu17ll_D_S) C1{ FL:17 FL Fs}



static void Test_BFu17ll_D_S()
{
  {
    init_simple_test("BFu17ll_D_S");
    static STRUCT_IF_C BFu17ll_D_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_S, BFu17ll_D_S)
//============================================================================


struct  BFu17ll_D_Uc  {
  __tsu64 v1:17;
  double v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_D_Uc) C1{ FL:17 FL Fc}



static void Test_BFu17ll_D_Uc()
{
  {
    init_simple_test("BFu17ll_D_Uc");
    static STRUCT_IF_C BFu17ll_D_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_Uc, BFu17ll_D_Uc)
//============================================================================


struct  BFu17ll_D_Ui  {
  __tsu64 v1:17;
  double v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_D_Ui) C1{ FL:17 FL Fi}



static void Test_BFu17ll_D_Ui()
{
  {
    init_simple_test("BFu17ll_D_Ui");
    static STRUCT_IF_C BFu17ll_D_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_Ui, BFu17ll_D_Ui)
//============================================================================


struct  BFu17ll_D_Ul  {
  __tsu64 v1:17;
  double v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_D_Ul) C1{ FL:17 FL[2]}



static void Test_BFu17ll_D_Ul()
{
  {
    init_simple_test("BFu17ll_D_Ul");
    static STRUCT_IF_C BFu17ll_D_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_Ul, BFu17ll_D_Ul)
//============================================================================


struct  BFu17ll_D_Us  {
  __tsu64 v1:17;
  double v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_D_Us) C1{ FL:17 FL Fs}



static void Test_BFu17ll_D_Us()
{
  {
    init_simple_test("BFu17ll_D_Us");
    static STRUCT_IF_C BFu17ll_D_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_Us, BFu17ll_D_Us)
//============================================================================


struct  BFu17ll_D_Vp  {
  __tsu64 v1:17;
  double v2;
  void *v3;
};
//SIG(1 BFu17ll_D_Vp) C1{ FL:17 FL Fp}



static void Test_BFu17ll_D_Vp()
{
  {
    init_simple_test("BFu17ll_D_Vp");
    static STRUCT_IF_C BFu17ll_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_Vp, BFu17ll_D_Vp)
//============================================================================


struct  BFu17ll_F  {
  __tsu64 v1:17;
  float v2;
};
//SIG(1 BFu17ll_F) C1{ FL:17 Fi}



static void Test_BFu17ll_F()
{
  {
    init_simple_test("BFu17ll_F");
    static STRUCT_IF_C BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F");
    check_field_offset(lv, v2, 4, "BFu17ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F, BFu17ll_F)
//============================================================================


struct  BFu17ll_F_BFu15i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_F_BFu15i) C1{ FL:17 Fi Fi:15}



static void Test_BFu17ll_F_BFu15i()
{
  {
    init_simple_test("BFu17ll_F_BFu15i");
    static STRUCT_IF_C BFu17ll_F_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu15i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_F_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu15i, BFu17ll_F_BFu15i)
//============================================================================


struct  BFu17ll_F_BFu15ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_F_BFu15ll) C1{ FL:17 Fi FL:15}



static void Test_BFu17ll_F_BFu15ll()
{
  {
    init_simple_test("BFu17ll_F_BFu15ll");
    static STRUCT_IF_C BFu17ll_F_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_F_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu15ll, BFu17ll_F_BFu15ll)
//============================================================================


struct  BFu17ll_F_BFu15s  {
  __tsu64 v1:17;
  float v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_F_BFu15s) C1{ FL:17 Fi Fs:15}



static void Test_BFu17ll_F_BFu15s()
{
  {
    init_simple_test("BFu17ll_F_BFu15s");
    static STRUCT_IF_C BFu17ll_F_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu15s");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_F_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu15s, BFu17ll_F_BFu15s)
//============================================================================


struct  BFu17ll_F_BFu16i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_F_BFu16i) C1{ FL:17 Fi Fi:16}



static void Test_BFu17ll_F_BFu16i()
{
  {
    init_simple_test("BFu17ll_F_BFu16i");
    static STRUCT_IF_C BFu17ll_F_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu16i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_F_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu16i, BFu17ll_F_BFu16i)
//============================================================================


struct  BFu17ll_F_BFu16ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_F_BFu16ll) C1{ FL:17 Fi FL:16}



static void Test_BFu17ll_F_BFu16ll()
{
  {
    init_simple_test("BFu17ll_F_BFu16ll");
    static STRUCT_IF_C BFu17ll_F_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_F_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu16ll, BFu17ll_F_BFu16ll)
//============================================================================


struct  BFu17ll_F_BFu16s  {
  __tsu64 v1:17;
  float v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_F_BFu16s) C1{ FL:17 Fi Fs:16}



static void Test_BFu17ll_F_BFu16s()
{
  {
    init_simple_test("BFu17ll_F_BFu16s");
    static STRUCT_IF_C BFu17ll_F_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu16s");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_F_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu16s, BFu17ll_F_BFu16s)
//============================================================================


struct  BFu17ll_F_BFu17i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_F_BFu17i) C1{ FL:17 Fi Fi:17}



static void Test_BFu17ll_F_BFu17i()
{
  {
    init_simple_test("BFu17ll_F_BFu17i");
    static STRUCT_IF_C BFu17ll_F_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu17i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu17ll_F_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu17i, BFu17ll_F_BFu17i)
//============================================================================


struct  BFu17ll_F_BFu17ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_F_BFu17ll) C1{ FL:17 Fi FL:17}



static void Test_BFu17ll_F_BFu17ll()
{
  {
    init_simple_test("BFu17ll_F_BFu17ll");
    static STRUCT_IF_C BFu17ll_F_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu17ll_F_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu17ll, BFu17ll_F_BFu17ll)
//============================================================================


struct  BFu17ll_F_BFu1c  {
  __tsu64 v1:17;
  float v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_F_BFu1c) C1{ FL:17 Fi Fc:1}



static void Test_BFu17ll_F_BFu1c()
{
  {
    init_simple_test("BFu17ll_F_BFu1c");
    static STRUCT_IF_C BFu17ll_F_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu1c");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu1c, BFu17ll_F_BFu1c)
//============================================================================


struct  BFu17ll_F_BFu1i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_F_BFu1i) C1{ FL:17 Fi Fi:1}



static void Test_BFu17ll_F_BFu1i()
{
  {
    init_simple_test("BFu17ll_F_BFu1i");
    static STRUCT_IF_C BFu17ll_F_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu1i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu1i, BFu17ll_F_BFu1i)
//============================================================================


struct  BFu17ll_F_BFu1ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_F_BFu1ll) C1{ FL:17 Fi FL:1}



static void Test_BFu17ll_F_BFu1ll()
{
  {
    init_simple_test("BFu17ll_F_BFu1ll");
    static STRUCT_IF_C BFu17ll_F_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu1ll, BFu17ll_F_BFu1ll)
//============================================================================


struct  BFu17ll_F_BFu1s  {
  __tsu64 v1:17;
  float v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_F_BFu1s) C1{ FL:17 Fi Fs:1}



static void Test_BFu17ll_F_BFu1s()
{
  {
    init_simple_test("BFu17ll_F_BFu1s");
    static STRUCT_IF_C BFu17ll_F_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu1s");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu1s, BFu17ll_F_BFu1s)
//============================================================================


struct  BFu17ll_F_BFu31i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_F_BFu31i) C1{ FL:17 Fi Fi:31}



static void Test_BFu17ll_F_BFu31i()
{
  {
    init_simple_test("BFu17ll_F_BFu31i");
    static STRUCT_IF_C BFu17ll_F_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu31i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu17ll_F_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu17ll_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu31i, BFu17ll_F_BFu31i)
//============================================================================


struct  BFu17ll_F_BFu31ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_F_BFu31ll) C1{ FL:17 Fi FL:31}



static void Test_BFu17ll_F_BFu31ll()
{
  {
    init_simple_test("BFu17ll_F_BFu31ll");
    static STRUCT_IF_C BFu17ll_F_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu17ll_F_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu17ll_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu31ll, BFu17ll_F_BFu31ll)
//============================================================================


struct  BFu17ll_F_BFu32i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_F_BFu32i) C1{ FL:17 Fi Fi:32}



static void Test_BFu17ll_F_BFu32i()
{
  {
    init_simple_test("BFu17ll_F_BFu32i");
    static STRUCT_IF_C BFu17ll_F_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu32i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu17ll_F_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu17ll_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu32i, BFu17ll_F_BFu32i)
//============================================================================


struct  BFu17ll_F_BFu32ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_F_BFu32ll) C1{ FL:17 Fi FL:32}



static void Test_BFu17ll_F_BFu32ll()
{
  {
    init_simple_test("BFu17ll_F_BFu32ll");
    static STRUCT_IF_C BFu17ll_F_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu17ll_F_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu17ll_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu32ll, BFu17ll_F_BFu32ll)
//============================================================================


struct  BFu17ll_F_BFu33  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_F_BFu33) C1{ FL:17 Fi FL:33}



static void Test_BFu17ll_F_BFu33()
{
  {
    init_simple_test("BFu17ll_F_BFu33");
    static STRUCT_IF_C BFu17ll_F_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu33");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "BFu17ll_F_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "BFu17ll_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu33, BFu17ll_F_BFu33)
//============================================================================


struct  BFu17ll_F_BFu7c  {
  __tsu64 v1:17;
  float v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_F_BFu7c) C1{ FL:17 Fi Fc:7}



static void Test_BFu17ll_F_BFu7c()
{
  {
    init_simple_test("BFu17ll_F_BFu7c");
    static STRUCT_IF_C BFu17ll_F_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu7c");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_F_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu7c, BFu17ll_F_BFu7c)
//============================================================================


struct  BFu17ll_F_BFu7i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_F_BFu7i) C1{ FL:17 Fi Fi:7}



static void Test_BFu17ll_F_BFu7i()
{
  {
    init_simple_test("BFu17ll_F_BFu7i");
    static STRUCT_IF_C BFu17ll_F_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu7i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_F_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu7i, BFu17ll_F_BFu7i)
//============================================================================


struct  BFu17ll_F_BFu7ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_F_BFu7ll) C1{ FL:17 Fi FL:7}



static void Test_BFu17ll_F_BFu7ll()
{
  {
    init_simple_test("BFu17ll_F_BFu7ll");
    static STRUCT_IF_C BFu17ll_F_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_F_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu7ll, BFu17ll_F_BFu7ll)
//============================================================================


struct  BFu17ll_F_BFu7s  {
  __tsu64 v1:17;
  float v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_F_BFu7s) C1{ FL:17 Fi Fs:7}



static void Test_BFu17ll_F_BFu7s()
{
  {
    init_simple_test("BFu17ll_F_BFu7s");
    static STRUCT_IF_C BFu17ll_F_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu7s");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_F_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu7s, BFu17ll_F_BFu7s)
//============================================================================


struct  BFu17ll_F_BFu8c  {
  __tsu64 v1:17;
  float v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_F_BFu8c) C1{ FL:17 Fi Fc:8}



static void Test_BFu17ll_F_BFu8c()
{
  {
    init_simple_test("BFu17ll_F_BFu8c");
    static STRUCT_IF_C BFu17ll_F_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu8c");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_F_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu8c, BFu17ll_F_BFu8c)
//============================================================================


struct  BFu17ll_F_BFu8i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_F_BFu8i) C1{ FL:17 Fi Fi:8}



static void Test_BFu17ll_F_BFu8i()
{
  {
    init_simple_test("BFu17ll_F_BFu8i");
    static STRUCT_IF_C BFu17ll_F_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu8i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_F_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu8i, BFu17ll_F_BFu8i)
//============================================================================


struct  BFu17ll_F_BFu8ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_F_BFu8ll) C1{ FL:17 Fi FL:8}



static void Test_BFu17ll_F_BFu8ll()
{
  {
    init_simple_test("BFu17ll_F_BFu8ll");
    static STRUCT_IF_C BFu17ll_F_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_F_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu8ll, BFu17ll_F_BFu8ll)
//============================================================================


struct  BFu17ll_F_BFu8s  {
  __tsu64 v1:17;
  float v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_F_BFu8s) C1{ FL:17 Fi Fs:8}



static void Test_BFu17ll_F_BFu8s()
{
  {
    init_simple_test("BFu17ll_F_BFu8s");
    static STRUCT_IF_C BFu17ll_F_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu8s");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_F_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu8s, BFu17ll_F_BFu8s)
//============================================================================


struct  BFu17ll_F_BFu9i  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_F_BFu9i) C1{ FL:17 Fi Fi:9}



static void Test_BFu17ll_F_BFu9i()
{
  {
    init_simple_test("BFu17ll_F_BFu9i");
    static STRUCT_IF_C BFu17ll_F_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu9i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_F_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu9i, BFu17ll_F_BFu9i)
//============================================================================


struct  BFu17ll_F_BFu9ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_F_BFu9ll) C1{ FL:17 Fi FL:9}



static void Test_BFu17ll_F_BFu9ll()
{
  {
    init_simple_test("BFu17ll_F_BFu9ll");
    static STRUCT_IF_C BFu17ll_F_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_F_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu9ll, BFu17ll_F_BFu9ll)
//============================================================================


struct  BFu17ll_F_BFu9s  {
  __tsu64 v1:17;
  float v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_F_BFu9s) C1{ FL:17 Fi Fs:9}



static void Test_BFu17ll_F_BFu9s()
{
  {
    init_simple_test("BFu17ll_F_BFu9s");
    static STRUCT_IF_C BFu17ll_F_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu9s");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_F_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu9s, BFu17ll_F_BFu9s)
//============================================================================


struct  BFu17ll_F_C  {
  __tsu64 v1:17;
  float v2;
  char v3;
};
//SIG(1 BFu17ll_F_C) C1{ FL:17 Fi Fc}



static void Test_BFu17ll_F_C()
{
  {
    init_simple_test("BFu17ll_F_C");
    static STRUCT_IF_C BFu17ll_F_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_C");
    check_field_offset(lv, v2, 4, "BFu17ll_F_C.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_C, BFu17ll_F_C)
//============================================================================


struct  BFu17ll_F_D  {
  __tsu64 v1:17;
  float v2;
  double v3;
};
//SIG(1 BFu17ll_F_D) C1{ FL:17 Fi FL}



static void Test_BFu17ll_F_D()
{
  {
    init_simple_test("BFu17ll_F_D");
    static STRUCT_IF_C BFu17ll_F_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_D");
    check_field_offset(lv, v2, 4, "BFu17ll_F_D.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_D, BFu17ll_F_D)
//============================================================================


struct  BFu17ll_F_F  {
  __tsu64 v1:17;
  float v2;
  float v3;
};
//SIG(1 BFu17ll_F_F) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_F_F()
{
  {
    init_simple_test("BFu17ll_F_F");
    static STRUCT_IF_C BFu17ll_F_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_F");
    check_field_offset(lv, v2, 4, "BFu17ll_F_F.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_F, BFu17ll_F_F)
//============================================================================


struct  BFu17ll_F_I  {
  __tsu64 v1:17;
  float v2;
  int v3;
};
//SIG(1 BFu17ll_F_I) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_F_I()
{
  {
    init_simple_test("BFu17ll_F_I");
    static STRUCT_IF_C BFu17ll_F_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_I");
    check_field_offset(lv, v2, 4, "BFu17ll_F_I.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_I, BFu17ll_F_I)
//============================================================================


struct  BFu17ll_F_Ip  {
  __tsu64 v1:17;
  float v2;
  int *v3;
};
//SIG(1 BFu17ll_F_Ip) C1{ FL:17 Fi Fp}



static void Test_BFu17ll_F_Ip()
{
  {
    init_simple_test("BFu17ll_F_Ip");
    static STRUCT_IF_C BFu17ll_F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_Ip");
    check_field_offset(lv, v2, 4, "BFu17ll_F_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_Ip, BFu17ll_F_Ip)
//============================================================================


struct  BFu17ll_F_L  {
  __tsu64 v1:17;
  float v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_F_L) C1{ FL:17 Fi FL}



static void Test_BFu17ll_F_L()
{
  {
    init_simple_test("BFu17ll_F_L");
    static STRUCT_IF_C BFu17ll_F_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_L");
    check_field_offset(lv, v2, 4, "BFu17ll_F_L.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_L, BFu17ll_F_L)
//============================================================================


struct  BFu17ll_F_S  {
  __tsu64 v1:17;
  float v2;
  short v3;
};
//SIG(1 BFu17ll_F_S) C1{ FL:17 Fi Fs}



static void Test_BFu17ll_F_S()
{
  {
    init_simple_test("BFu17ll_F_S");
    static STRUCT_IF_C BFu17ll_F_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_S");
    check_field_offset(lv, v2, 4, "BFu17ll_F_S.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_S, BFu17ll_F_S)
//============================================================================


struct  BFu17ll_F_Uc  {
  __tsu64 v1:17;
  float v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_F_Uc) C1{ FL:17 Fi Fc}



static void Test_BFu17ll_F_Uc()
{
  {
    init_simple_test("BFu17ll_F_Uc");
    static STRUCT_IF_C BFu17ll_F_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_Uc");
    check_field_offset(lv, v2, 4, "BFu17ll_F_Uc.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_Uc, BFu17ll_F_Uc)
//============================================================================


struct  BFu17ll_F_Ui  {
  __tsu64 v1:17;
  float v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_F_Ui) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_F_Ui()
{
  {
    init_simple_test("BFu17ll_F_Ui");
    static STRUCT_IF_C BFu17ll_F_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_Ui");
    check_field_offset(lv, v2, 4, "BFu17ll_F_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_Ui, BFu17ll_F_Ui)
//============================================================================


struct  BFu17ll_F_Ul  {
  __tsu64 v1:17;
  float v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_F_Ul) C1{ FL:17 Fi FL}



static void Test_BFu17ll_F_Ul()
{
  {
    init_simple_test("BFu17ll_F_Ul");
    static STRUCT_IF_C BFu17ll_F_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_Ul");
    check_field_offset(lv, v2, 4, "BFu17ll_F_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_Ul, BFu17ll_F_Ul)
//============================================================================


struct  BFu17ll_F_Us  {
  __tsu64 v1:17;
  float v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_F_Us) C1{ FL:17 Fi Fs}



static void Test_BFu17ll_F_Us()
{
  {
    init_simple_test("BFu17ll_F_Us");
    static STRUCT_IF_C BFu17ll_F_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_Us");
    check_field_offset(lv, v2, 4, "BFu17ll_F_Us.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_Us, BFu17ll_F_Us)
//============================================================================


struct  BFu17ll_F_Vp  {
  __tsu64 v1:17;
  float v2;
  void *v3;
};
//SIG(1 BFu17ll_F_Vp) C1{ FL:17 Fi Fp}



static void Test_BFu17ll_F_Vp()
{
  {
    init_simple_test("BFu17ll_F_Vp");
    static STRUCT_IF_C BFu17ll_F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_Vp");
    check_field_offset(lv, v2, 4, "BFu17ll_F_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_Vp, BFu17ll_F_Vp)
//============================================================================


struct  BFu17ll_I  {
  __tsu64 v1:17;
  int v2;
};
//SIG(1 BFu17ll_I) C1{ FL:17 Fi}



static void Test_BFu17ll_I()
{
  {
    init_simple_test("BFu17ll_I");
    static STRUCT_IF_C BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I");
    check_field_offset(lv, v2, 4, "BFu17ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I, BFu17ll_I)
//============================================================================


struct  BFu17ll_I_BFu15i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_I_BFu15i) C1{ FL:17 Fi Fi:15}



static void Test_BFu17ll_I_BFu15i()
{
  {
    init_simple_test("BFu17ll_I_BFu15i");
    static STRUCT_IF_C BFu17ll_I_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu15i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_I_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu15i, BFu17ll_I_BFu15i)
//============================================================================


struct  BFu17ll_I_BFu15ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_I_BFu15ll) C1{ FL:17 Fi FL:15}



static void Test_BFu17ll_I_BFu15ll()
{
  {
    init_simple_test("BFu17ll_I_BFu15ll");
    static STRUCT_IF_C BFu17ll_I_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_I_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu15ll, BFu17ll_I_BFu15ll)
//============================================================================


struct  BFu17ll_I_BFu15s  {
  __tsu64 v1:17;
  int v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_I_BFu15s) C1{ FL:17 Fi Fs:15}



static void Test_BFu17ll_I_BFu15s()
{
  {
    init_simple_test("BFu17ll_I_BFu15s");
    static STRUCT_IF_C BFu17ll_I_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu15s");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_I_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu15s, BFu17ll_I_BFu15s)
//============================================================================


struct  BFu17ll_I_BFu16i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_I_BFu16i) C1{ FL:17 Fi Fi:16}



static void Test_BFu17ll_I_BFu16i()
{
  {
    init_simple_test("BFu17ll_I_BFu16i");
    static STRUCT_IF_C BFu17ll_I_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu16i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_I_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu16i, BFu17ll_I_BFu16i)
//============================================================================


struct  BFu17ll_I_BFu16ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_I_BFu16ll) C1{ FL:17 Fi FL:16}



static void Test_BFu17ll_I_BFu16ll()
{
  {
    init_simple_test("BFu17ll_I_BFu16ll");
    static STRUCT_IF_C BFu17ll_I_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_I_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu16ll, BFu17ll_I_BFu16ll)
//============================================================================


struct  BFu17ll_I_BFu16s  {
  __tsu64 v1:17;
  int v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_I_BFu16s) C1{ FL:17 Fi Fs:16}



static void Test_BFu17ll_I_BFu16s()
{
  {
    init_simple_test("BFu17ll_I_BFu16s");
    static STRUCT_IF_C BFu17ll_I_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu16s");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_I_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu16s, BFu17ll_I_BFu16s)
//============================================================================


struct  BFu17ll_I_BFu17i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_I_BFu17i) C1{ FL:17 Fi Fi:17}



static void Test_BFu17ll_I_BFu17i()
{
  {
    init_simple_test("BFu17ll_I_BFu17i");
    static STRUCT_IF_C BFu17ll_I_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu17i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu17ll_I_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu17i, BFu17ll_I_BFu17i)
//============================================================================


struct  BFu17ll_I_BFu17ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_I_BFu17ll) C1{ FL:17 Fi FL:17}



static void Test_BFu17ll_I_BFu17ll()
{
  {
    init_simple_test("BFu17ll_I_BFu17ll");
    static STRUCT_IF_C BFu17ll_I_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu17ll_I_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu17ll, BFu17ll_I_BFu17ll)
//============================================================================


struct  BFu17ll_I_BFu1c  {
  __tsu64 v1:17;
  int v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_I_BFu1c) C1{ FL:17 Fi Fc:1}



static void Test_BFu17ll_I_BFu1c()
{
  {
    init_simple_test("BFu17ll_I_BFu1c");
    static STRUCT_IF_C BFu17ll_I_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu1c");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu1c, BFu17ll_I_BFu1c)
//============================================================================


struct  BFu17ll_I_BFu1i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_I_BFu1i) C1{ FL:17 Fi Fi:1}



static void Test_BFu17ll_I_BFu1i()
{
  {
    init_simple_test("BFu17ll_I_BFu1i");
    static STRUCT_IF_C BFu17ll_I_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu1i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu1i, BFu17ll_I_BFu1i)
//============================================================================


struct  BFu17ll_I_BFu1ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_I_BFu1ll) C1{ FL:17 Fi FL:1}



static void Test_BFu17ll_I_BFu1ll()
{
  {
    init_simple_test("BFu17ll_I_BFu1ll");
    static STRUCT_IF_C BFu17ll_I_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu1ll, BFu17ll_I_BFu1ll)
//============================================================================


struct  BFu17ll_I_BFu1s  {
  __tsu64 v1:17;
  int v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_I_BFu1s) C1{ FL:17 Fi Fs:1}



static void Test_BFu17ll_I_BFu1s()
{
  {
    init_simple_test("BFu17ll_I_BFu1s");
    static STRUCT_IF_C BFu17ll_I_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu1s");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu1s, BFu17ll_I_BFu1s)
//============================================================================


struct  BFu17ll_I_BFu31i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_I_BFu31i) C1{ FL:17 Fi Fi:31}



static void Test_BFu17ll_I_BFu31i()
{
  {
    init_simple_test("BFu17ll_I_BFu31i");
    static STRUCT_IF_C BFu17ll_I_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu31i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu17ll_I_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu17ll_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu31i, BFu17ll_I_BFu31i)
//============================================================================


struct  BFu17ll_I_BFu31ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_I_BFu31ll) C1{ FL:17 Fi FL:31}



static void Test_BFu17ll_I_BFu31ll()
{
  {
    init_simple_test("BFu17ll_I_BFu31ll");
    static STRUCT_IF_C BFu17ll_I_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu17ll_I_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu17ll_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu31ll, BFu17ll_I_BFu31ll)
//============================================================================


struct  BFu17ll_I_BFu32i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_I_BFu32i) C1{ FL:17 Fi Fi:32}



static void Test_BFu17ll_I_BFu32i()
{
  {
    init_simple_test("BFu17ll_I_BFu32i");
    static STRUCT_IF_C BFu17ll_I_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu32i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu17ll_I_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu17ll_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu32i, BFu17ll_I_BFu32i)
//============================================================================


struct  BFu17ll_I_BFu32ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_I_BFu32ll) C1{ FL:17 Fi FL:32}



static void Test_BFu17ll_I_BFu32ll()
{
  {
    init_simple_test("BFu17ll_I_BFu32ll");
    static STRUCT_IF_C BFu17ll_I_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu17ll_I_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu17ll_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu32ll, BFu17ll_I_BFu32ll)
//============================================================================


struct  BFu17ll_I_BFu33  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_I_BFu33) C1{ FL:17 Fi FL:33}



static void Test_BFu17ll_I_BFu33()
{
  {
    init_simple_test("BFu17ll_I_BFu33");
    static STRUCT_IF_C BFu17ll_I_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu33");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "BFu17ll_I_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "BFu17ll_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu33, BFu17ll_I_BFu33)
//============================================================================


struct  BFu17ll_I_BFu7c  {
  __tsu64 v1:17;
  int v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_I_BFu7c) C1{ FL:17 Fi Fc:7}



static void Test_BFu17ll_I_BFu7c()
{
  {
    init_simple_test("BFu17ll_I_BFu7c");
    static STRUCT_IF_C BFu17ll_I_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu7c");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_I_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu7c, BFu17ll_I_BFu7c)
//============================================================================


struct  BFu17ll_I_BFu7i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_I_BFu7i) C1{ FL:17 Fi Fi:7}



static void Test_BFu17ll_I_BFu7i()
{
  {
    init_simple_test("BFu17ll_I_BFu7i");
    static STRUCT_IF_C BFu17ll_I_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu7i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_I_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu7i, BFu17ll_I_BFu7i)
//============================================================================


struct  BFu17ll_I_BFu7ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_I_BFu7ll) C1{ FL:17 Fi FL:7}



static void Test_BFu17ll_I_BFu7ll()
{
  {
    init_simple_test("BFu17ll_I_BFu7ll");
    static STRUCT_IF_C BFu17ll_I_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_I_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu7ll, BFu17ll_I_BFu7ll)
//============================================================================


struct  BFu17ll_I_BFu7s  {
  __tsu64 v1:17;
  int v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_I_BFu7s) C1{ FL:17 Fi Fs:7}



static void Test_BFu17ll_I_BFu7s()
{
  {
    init_simple_test("BFu17ll_I_BFu7s");
    static STRUCT_IF_C BFu17ll_I_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu7s");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_I_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu7s, BFu17ll_I_BFu7s)
//============================================================================


struct  BFu17ll_I_BFu8c  {
  __tsu64 v1:17;
  int v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_I_BFu8c) C1{ FL:17 Fi Fc:8}



static void Test_BFu17ll_I_BFu8c()
{
  {
    init_simple_test("BFu17ll_I_BFu8c");
    static STRUCT_IF_C BFu17ll_I_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu8c");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_I_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu8c, BFu17ll_I_BFu8c)
//============================================================================


struct  BFu17ll_I_BFu8i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_I_BFu8i) C1{ FL:17 Fi Fi:8}



static void Test_BFu17ll_I_BFu8i()
{
  {
    init_simple_test("BFu17ll_I_BFu8i");
    static STRUCT_IF_C BFu17ll_I_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu8i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_I_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu8i, BFu17ll_I_BFu8i)
//============================================================================


struct  BFu17ll_I_BFu8ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_I_BFu8ll) C1{ FL:17 Fi FL:8}



static void Test_BFu17ll_I_BFu8ll()
{
  {
    init_simple_test("BFu17ll_I_BFu8ll");
    static STRUCT_IF_C BFu17ll_I_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_I_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu8ll, BFu17ll_I_BFu8ll)
//============================================================================


struct  BFu17ll_I_BFu8s  {
  __tsu64 v1:17;
  int v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_I_BFu8s) C1{ FL:17 Fi Fs:8}



static void Test_BFu17ll_I_BFu8s()
{
  {
    init_simple_test("BFu17ll_I_BFu8s");
    static STRUCT_IF_C BFu17ll_I_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu8s");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_I_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu8s, BFu17ll_I_BFu8s)
//============================================================================


struct  BFu17ll_I_BFu9i  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_I_BFu9i) C1{ FL:17 Fi Fi:9}



static void Test_BFu17ll_I_BFu9i()
{
  {
    init_simple_test("BFu17ll_I_BFu9i");
    static STRUCT_IF_C BFu17ll_I_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu9i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_I_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu9i, BFu17ll_I_BFu9i)
//============================================================================


struct  BFu17ll_I_BFu9ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_I_BFu9ll) C1{ FL:17 Fi FL:9}



static void Test_BFu17ll_I_BFu9ll()
{
  {
    init_simple_test("BFu17ll_I_BFu9ll");
    static STRUCT_IF_C BFu17ll_I_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_I_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu9ll, BFu17ll_I_BFu9ll)
//============================================================================


struct  BFu17ll_I_BFu9s  {
  __tsu64 v1:17;
  int v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_I_BFu9s) C1{ FL:17 Fi Fs:9}



static void Test_BFu17ll_I_BFu9s()
{
  {
    init_simple_test("BFu17ll_I_BFu9s");
    static STRUCT_IF_C BFu17ll_I_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu9s");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_I_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu9s, BFu17ll_I_BFu9s)
//============================================================================


struct  BFu17ll_I_C  {
  __tsu64 v1:17;
  int v2;
  char v3;
};
//SIG(1 BFu17ll_I_C) C1{ FL:17 Fi Fc}



static void Test_BFu17ll_I_C()
{
  {
    init_simple_test("BFu17ll_I_C");
    static STRUCT_IF_C BFu17ll_I_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_C");
    check_field_offset(lv, v2, 4, "BFu17ll_I_C.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_C, BFu17ll_I_C)
//============================================================================


struct  BFu17ll_I_D  {
  __tsu64 v1:17;
  int v2;
  double v3;
};
//SIG(1 BFu17ll_I_D) C1{ FL:17 Fi FL}



static void Test_BFu17ll_I_D()
{
  {
    init_simple_test("BFu17ll_I_D");
    static STRUCT_IF_C BFu17ll_I_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_D");
    check_field_offset(lv, v2, 4, "BFu17ll_I_D.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_D, BFu17ll_I_D)
//============================================================================


struct  BFu17ll_I_F  {
  __tsu64 v1:17;
  int v2;
  float v3;
};
//SIG(1 BFu17ll_I_F) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_I_F()
{
  {
    init_simple_test("BFu17ll_I_F");
    static STRUCT_IF_C BFu17ll_I_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_F");
    check_field_offset(lv, v2, 4, "BFu17ll_I_F.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_F, BFu17ll_I_F)
//============================================================================


struct  BFu17ll_I_I  {
  __tsu64 v1:17;
  int v2;
  int v3;
};
//SIG(1 BFu17ll_I_I) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_I_I()
{
  {
    init_simple_test("BFu17ll_I_I");
    static STRUCT_IF_C BFu17ll_I_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_I");
    check_field_offset(lv, v2, 4, "BFu17ll_I_I.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_I, BFu17ll_I_I)
//============================================================================


struct  BFu17ll_I_Ip  {
  __tsu64 v1:17;
  int v2;
  int *v3;
};
//SIG(1 BFu17ll_I_Ip) C1{ FL:17 Fi Fp}



static void Test_BFu17ll_I_Ip()
{
  {
    init_simple_test("BFu17ll_I_Ip");
    static STRUCT_IF_C BFu17ll_I_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_Ip");
    check_field_offset(lv, v2, 4, "BFu17ll_I_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_Ip, BFu17ll_I_Ip)
//============================================================================


struct  BFu17ll_I_L  {
  __tsu64 v1:17;
  int v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_I_L) C1{ FL:17 Fi FL}



static void Test_BFu17ll_I_L()
{
  {
    init_simple_test("BFu17ll_I_L");
    static STRUCT_IF_C BFu17ll_I_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_L");
    check_field_offset(lv, v2, 4, "BFu17ll_I_L.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_L, BFu17ll_I_L)
//============================================================================


struct  BFu17ll_I_S  {
  __tsu64 v1:17;
  int v2;
  short v3;
};
//SIG(1 BFu17ll_I_S) C1{ FL:17 Fi Fs}



static void Test_BFu17ll_I_S()
{
  {
    init_simple_test("BFu17ll_I_S");
    static STRUCT_IF_C BFu17ll_I_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_S");
    check_field_offset(lv, v2, 4, "BFu17ll_I_S.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_S, BFu17ll_I_S)
//============================================================================


struct  BFu17ll_I_Uc  {
  __tsu64 v1:17;
  int v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_I_Uc) C1{ FL:17 Fi Fc}



static void Test_BFu17ll_I_Uc()
{
  {
    init_simple_test("BFu17ll_I_Uc");
    static STRUCT_IF_C BFu17ll_I_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_Uc");
    check_field_offset(lv, v2, 4, "BFu17ll_I_Uc.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_Uc, BFu17ll_I_Uc)
//============================================================================


struct  BFu17ll_I_Ui  {
  __tsu64 v1:17;
  int v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_I_Ui) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_I_Ui()
{
  {
    init_simple_test("BFu17ll_I_Ui");
    static STRUCT_IF_C BFu17ll_I_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_Ui");
    check_field_offset(lv, v2, 4, "BFu17ll_I_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_Ui, BFu17ll_I_Ui)
//============================================================================


struct  BFu17ll_I_Ul  {
  __tsu64 v1:17;
  int v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_I_Ul) C1{ FL:17 Fi FL}



static void Test_BFu17ll_I_Ul()
{
  {
    init_simple_test("BFu17ll_I_Ul");
    static STRUCT_IF_C BFu17ll_I_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_Ul");
    check_field_offset(lv, v2, 4, "BFu17ll_I_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_Ul, BFu17ll_I_Ul)
//============================================================================


struct  BFu17ll_I_Us  {
  __tsu64 v1:17;
  int v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_I_Us) C1{ FL:17 Fi Fs}



static void Test_BFu17ll_I_Us()
{
  {
    init_simple_test("BFu17ll_I_Us");
    static STRUCT_IF_C BFu17ll_I_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_Us");
    check_field_offset(lv, v2, 4, "BFu17ll_I_Us.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_Us, BFu17ll_I_Us)
//============================================================================


struct  BFu17ll_I_Vp  {
  __tsu64 v1:17;
  int v2;
  void *v3;
};
//SIG(1 BFu17ll_I_Vp) C1{ FL:17 Fi Fp}



static void Test_BFu17ll_I_Vp()
{
  {
    init_simple_test("BFu17ll_I_Vp");
    static STRUCT_IF_C BFu17ll_I_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_Vp");
    check_field_offset(lv, v2, 4, "BFu17ll_I_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_Vp, BFu17ll_I_Vp)
//============================================================================


struct  BFu17ll_Ip  {
  __tsu64 v1:17;
  int *v2;
};
//SIG(1 BFu17ll_Ip) C1{ FL:17 Fp}



static void Test_BFu17ll_Ip()
{
  {
    init_simple_test("BFu17ll_Ip");
    static STRUCT_IF_C BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip, BFu17ll_Ip)
//============================================================================


struct  BFu17ll_Ip_BFu15i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_Ip_BFu15i) C1{ FL:17 Fp Fi:15}



static void Test_BFu17ll_Ip_BFu15i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu15i");
    static STRUCT_IF_C BFu17ll_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu15i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu17ll_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu17ll_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu15i, BFu17ll_Ip_BFu15i)
//============================================================================


struct  BFu17ll_Ip_BFu15ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_Ip_BFu15ll) C1{ FL:17 Fp FL:15}



static void Test_BFu17ll_Ip_BFu15ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu15ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu15ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu17ll_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu17ll_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu15ll, BFu17ll_Ip_BFu15ll)
//============================================================================


struct  BFu17ll_Ip_BFu15s  {
  __tsu64 v1:17;
  int *v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_Ip_BFu15s) C1{ FL:17 Fp Fs:15}



static void Test_BFu17ll_Ip_BFu15s()
{
  {
    init_simple_test("BFu17ll_Ip_BFu15s");
    static STRUCT_IF_C BFu17ll_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu15s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu17ll_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu17ll_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu15s, BFu17ll_Ip_BFu15s)
//============================================================================


struct  BFu17ll_Ip_BFu16i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_Ip_BFu16i) C1{ FL:17 Fp Fi:16}



static void Test_BFu17ll_Ip_BFu16i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu16i");
    static STRUCT_IF_C BFu17ll_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu16i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu17ll_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu17ll_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu16i, BFu17ll_Ip_BFu16i)
//============================================================================


struct  BFu17ll_Ip_BFu16ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_Ip_BFu16ll) C1{ FL:17 Fp FL:16}



static void Test_BFu17ll_Ip_BFu16ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu16ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu16ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu17ll_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu17ll_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu16ll, BFu17ll_Ip_BFu16ll)
//============================================================================


struct  BFu17ll_Ip_BFu16s  {
  __tsu64 v1:17;
  int *v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_Ip_BFu16s) C1{ FL:17 Fp Fs:16}



static void Test_BFu17ll_Ip_BFu16s()
{
  {
    init_simple_test("BFu17ll_Ip_BFu16s");
    static STRUCT_IF_C BFu17ll_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu16s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu17ll_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu17ll_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu16s, BFu17ll_Ip_BFu16s)
//============================================================================


struct  BFu17ll_Ip_BFu17i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_Ip_BFu17i) C1{ FL:17 Fp Fi:17}



static void Test_BFu17ll_Ip_BFu17i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu17i");
    static STRUCT_IF_C BFu17ll_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu17i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "BFu17ll_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu17i, BFu17ll_Ip_BFu17i)
//============================================================================


struct  BFu17ll_Ip_BFu17ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_Ip_BFu17ll) C1{ FL:17 Fp FL:17}



static void Test_BFu17ll_Ip_BFu17ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu17ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu17ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "BFu17ll_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu17ll, BFu17ll_Ip_BFu17ll)
//============================================================================


struct  BFu17ll_Ip_BFu1c  {
  __tsu64 v1:17;
  int *v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_Ip_BFu1c) C1{ FL:17 Fp Fc:1}



static void Test_BFu17ll_Ip_BFu1c()
{
  {
    init_simple_test("BFu17ll_Ip_BFu1c");
    static STRUCT_IF_C BFu17ll_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu1c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu17ll_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu1c, BFu17ll_Ip_BFu1c)
//============================================================================


struct  BFu17ll_Ip_BFu1i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_Ip_BFu1i) C1{ FL:17 Fp Fi:1}



static void Test_BFu17ll_Ip_BFu1i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu1i");
    static STRUCT_IF_C BFu17ll_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu1i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu17ll_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu1i, BFu17ll_Ip_BFu1i)
//============================================================================


struct  BFu17ll_Ip_BFu1ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_Ip_BFu1ll) C1{ FL:17 Fp FL:1}



static void Test_BFu17ll_Ip_BFu1ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu1ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu1ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu17ll_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu1ll, BFu17ll_Ip_BFu1ll)
//============================================================================


struct  BFu17ll_Ip_BFu1s  {
  __tsu64 v1:17;
  int *v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_Ip_BFu1s) C1{ FL:17 Fp Fs:1}



static void Test_BFu17ll_Ip_BFu1s()
{
  {
    init_simple_test("BFu17ll_Ip_BFu1s");
    static STRUCT_IF_C BFu17ll_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu1s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu17ll_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu1s, BFu17ll_Ip_BFu1s)
//============================================================================


struct  BFu17ll_Ip_BFu31i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_Ip_BFu31i) C1{ FL:17 Fp Fi:31}



static void Test_BFu17ll_Ip_BFu31i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu31i");
    static STRUCT_IF_C BFu17ll_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu31i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "BFu17ll_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "BFu17ll_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu31i, BFu17ll_Ip_BFu31i)
//============================================================================


struct  BFu17ll_Ip_BFu31ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_Ip_BFu31ll) C1{ FL:17 Fp FL:31}



static void Test_BFu17ll_Ip_BFu31ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu31ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu31ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "BFu17ll_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "BFu17ll_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu31ll, BFu17ll_Ip_BFu31ll)
//============================================================================


struct  BFu17ll_Ip_BFu32i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_Ip_BFu32i) C1{ FL:17 Fp Fi:32}



static void Test_BFu17ll_Ip_BFu32i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu32i");
    static STRUCT_IF_C BFu17ll_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu32i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "BFu17ll_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "BFu17ll_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu32i, BFu17ll_Ip_BFu32i)
//============================================================================


struct  BFu17ll_Ip_BFu32ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_Ip_BFu32ll) C1{ FL:17 Fp FL:32}



static void Test_BFu17ll_Ip_BFu32ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu32ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu32ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "BFu17ll_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "BFu17ll_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu32ll, BFu17ll_Ip_BFu32ll)
//============================================================================


struct  BFu17ll_Ip_BFu33  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_Ip_BFu33) C1{ FL:17 Fp FL:33}



static void Test_BFu17ll_Ip_BFu33()
{
  {
    init_simple_test("BFu17ll_Ip_BFu33");
    static STRUCT_IF_C BFu17ll_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu33");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "BFu17ll_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "BFu17ll_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu33, BFu17ll_Ip_BFu33)
//============================================================================


struct  BFu17ll_Ip_BFu7c  {
  __tsu64 v1:17;
  int *v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_Ip_BFu7c) C1{ FL:17 Fp Fc:7}



static void Test_BFu17ll_Ip_BFu7c()
{
  {
    init_simple_test("BFu17ll_Ip_BFu7c");
    static STRUCT_IF_C BFu17ll_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu7c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu17ll_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu17ll_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu7c, BFu17ll_Ip_BFu7c)
//============================================================================


struct  BFu17ll_Ip_BFu7i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_Ip_BFu7i) C1{ FL:17 Fp Fi:7}



static void Test_BFu17ll_Ip_BFu7i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu7i");
    static STRUCT_IF_C BFu17ll_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu7i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu17ll_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu17ll_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu7i, BFu17ll_Ip_BFu7i)
//============================================================================


struct  BFu17ll_Ip_BFu7ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_Ip_BFu7ll) C1{ FL:17 Fp FL:7}



static void Test_BFu17ll_Ip_BFu7ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu7ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu7ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu17ll_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu17ll_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu7ll, BFu17ll_Ip_BFu7ll)
//============================================================================


struct  BFu17ll_Ip_BFu7s  {
  __tsu64 v1:17;
  int *v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_Ip_BFu7s) C1{ FL:17 Fp Fs:7}



static void Test_BFu17ll_Ip_BFu7s()
{
  {
    init_simple_test("BFu17ll_Ip_BFu7s");
    static STRUCT_IF_C BFu17ll_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu7s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu17ll_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu17ll_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu7s, BFu17ll_Ip_BFu7s)
//============================================================================


struct  BFu17ll_Ip_BFu8c  {
  __tsu64 v1:17;
  int *v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_Ip_BFu8c) C1{ FL:17 Fp Fc:8}



static void Test_BFu17ll_Ip_BFu8c()
{
  {
    init_simple_test("BFu17ll_Ip_BFu8c");
    static STRUCT_IF_C BFu17ll_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu8c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu17ll_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu17ll_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu8c, BFu17ll_Ip_BFu8c)
//============================================================================


struct  BFu17ll_Ip_BFu8i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_Ip_BFu8i) C1{ FL:17 Fp Fi:8}



static void Test_BFu17ll_Ip_BFu8i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu8i");
    static STRUCT_IF_C BFu17ll_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu8i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu17ll_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu17ll_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu8i, BFu17ll_Ip_BFu8i)
//============================================================================


struct  BFu17ll_Ip_BFu8ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_Ip_BFu8ll) C1{ FL:17 Fp FL:8}



static void Test_BFu17ll_Ip_BFu8ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu8ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu8ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu17ll_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu17ll_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu8ll, BFu17ll_Ip_BFu8ll)
//============================================================================


struct  BFu17ll_Ip_BFu8s  {
  __tsu64 v1:17;
  int *v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_Ip_BFu8s) C1{ FL:17 Fp Fs:8}



static void Test_BFu17ll_Ip_BFu8s()
{
  {
    init_simple_test("BFu17ll_Ip_BFu8s");
    static STRUCT_IF_C BFu17ll_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu8s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu17ll_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu17ll_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu8s, BFu17ll_Ip_BFu8s)
//============================================================================


struct  BFu17ll_Ip_BFu9i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_Ip_BFu9i) C1{ FL:17 Fp Fi:9}



static void Test_BFu17ll_Ip_BFu9i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu9i");
    static STRUCT_IF_C BFu17ll_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu9i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu17ll_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu17ll_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu9i, BFu17ll_Ip_BFu9i)
//============================================================================


struct  BFu17ll_Ip_BFu9ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_Ip_BFu9ll) C1{ FL:17 Fp FL:9}



static void Test_BFu17ll_Ip_BFu9ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu9ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu9ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu17ll_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu17ll_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu9ll, BFu17ll_Ip_BFu9ll)
//============================================================================


struct  BFu17ll_Ip_BFu9s  {
  __tsu64 v1:17;
  int *v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_Ip_BFu9s) C1{ FL:17 Fp Fs:9}



static void Test_BFu17ll_Ip_BFu9s()
{
  {
    init_simple_test("BFu17ll_Ip_BFu9s");
    static STRUCT_IF_C BFu17ll_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu9s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu17ll_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu17ll_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu9s, BFu17ll_Ip_BFu9s)
//============================================================================


struct  BFu17ll_Ip_C  {
  __tsu64 v1:17;
  int *v2;
  char v3;
};
//SIG(1 BFu17ll_Ip_C) C1{ FL:17 Fp Fc}



static void Test_BFu17ll_Ip_C()
{
  {
    init_simple_test("BFu17ll_Ip_C");
    static STRUCT_IF_C BFu17ll_Ip_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_C, BFu17ll_Ip_C)
//============================================================================


struct  BFu17ll_Ip_D  {
  __tsu64 v1:17;
  int *v2;
  double v3;
};
//SIG(1 BFu17ll_Ip_D) C1{ FL:17 Fp FL}



static void Test_BFu17ll_Ip_D()
{
  {
    init_simple_test("BFu17ll_Ip_D");
    static STRUCT_IF_C BFu17ll_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_D, BFu17ll_Ip_D)
//============================================================================


struct  BFu17ll_Ip_F  {
  __tsu64 v1:17;
  int *v2;
  float v3;
};
//SIG(1 BFu17ll_Ip_F) C1{ FL:17 Fp Fi}



static void Test_BFu17ll_Ip_F()
{
  {
    init_simple_test("BFu17ll_Ip_F");
    static STRUCT_IF_C BFu17ll_Ip_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_F, BFu17ll_Ip_F)
//============================================================================


struct  BFu17ll_Ip_I  {
  __tsu64 v1:17;
  int *v2;
  int v3;
};
//SIG(1 BFu17ll_Ip_I) C1{ FL:17 Fp Fi}



static void Test_BFu17ll_Ip_I()
{
  {
    init_simple_test("BFu17ll_Ip_I");
    static STRUCT_IF_C BFu17ll_Ip_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_I, BFu17ll_Ip_I)
//============================================================================


struct  BFu17ll_Ip_Ip  {
  __tsu64 v1:17;
  int *v2;
  int *v3;
};
//SIG(1 BFu17ll_Ip_Ip) C1{ FL:17 Fp[2]}



static void Test_BFu17ll_Ip_Ip()
{
  {
    init_simple_test("BFu17ll_Ip_Ip");
    static STRUCT_IF_C BFu17ll_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_Ip, BFu17ll_Ip_Ip)
//============================================================================


struct  BFu17ll_Ip_L  {
  __tsu64 v1:17;
  int *v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_Ip_L) C1{ FL:17 Fp FL}



static void Test_BFu17ll_Ip_L()
{
  {
    init_simple_test("BFu17ll_Ip_L");
    static STRUCT_IF_C BFu17ll_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ip_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_L, BFu17ll_Ip_L)
//============================================================================


struct  BFu17ll_Ip_S  {
  __tsu64 v1:17;
  int *v2;
  short v3;
};
//SIG(1 BFu17ll_Ip_S) C1{ FL:17 Fp Fs}



static void Test_BFu17ll_Ip_S()
{
  {
    init_simple_test("BFu17ll_Ip_S");
    static STRUCT_IF_C BFu17ll_Ip_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_S, BFu17ll_Ip_S)
//============================================================================


struct  BFu17ll_Ip_Uc  {
  __tsu64 v1:17;
  int *v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_Ip_Uc) C1{ FL:17 Fp Fc}



static void Test_BFu17ll_Ip_Uc()
{
  {
    init_simple_test("BFu17ll_Ip_Uc");
    static STRUCT_IF_C BFu17ll_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_Uc, BFu17ll_Ip_Uc)
//============================================================================


struct  BFu17ll_Ip_Ui  {
  __tsu64 v1:17;
  int *v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_Ip_Ui) C1{ FL:17 Fp Fi}



static void Test_BFu17ll_Ip_Ui()
{
  {
    init_simple_test("BFu17ll_Ip_Ui");
    static STRUCT_IF_C BFu17ll_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_Ui, BFu17ll_Ip_Ui)
//============================================================================


struct  BFu17ll_Ip_Ul  {
  __tsu64 v1:17;
  int *v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_Ip_Ul) C1{ FL:17 Fp FL}



static void Test_BFu17ll_Ip_Ul()
{
  {
    init_simple_test("BFu17ll_Ip_Ul");
    static STRUCT_IF_C BFu17ll_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ip_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_Ul, BFu17ll_Ip_Ul)
//============================================================================


struct  BFu17ll_Ip_Us  {
  __tsu64 v1:17;
  int *v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_Ip_Us) C1{ FL:17 Fp Fs}



static void Test_BFu17ll_Ip_Us()
{
  {
    init_simple_test("BFu17ll_Ip_Us");
    static STRUCT_IF_C BFu17ll_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_Us, BFu17ll_Ip_Us)
//============================================================================


struct  BFu17ll_Ip_Vp  {
  __tsu64 v1:17;
  int *v2;
  void *v3;
};
//SIG(1 BFu17ll_Ip_Vp) C1{ FL:17 Fp[2]}



static void Test_BFu17ll_Ip_Vp()
{
  {
    init_simple_test("BFu17ll_Ip_Vp");
    static STRUCT_IF_C BFu17ll_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_Vp, BFu17ll_Ip_Vp)
//============================================================================


struct  BFu17ll_L  {
  __tsu64 v1:17;
  __tsi64 v2;
};
//SIG(1 BFu17ll_L) C1{ FL:17 FL}



static void Test_BFu17ll_L()
{
  {
    init_simple_test("BFu17ll_L");
    static STRUCT_IF_C BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L, BFu17ll_L)
//============================================================================


struct  BFu17ll_L_BFu15i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_L_BFu15i) C1{ FL:17 FL Fi:15}



static void Test_BFu17ll_L_BFu15i()
{
  {
    init_simple_test("BFu17ll_L_BFu15i");
    static STRUCT_IF_C BFu17ll_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu15i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_L_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu15i, BFu17ll_L_BFu15i)
//============================================================================


struct  BFu17ll_L_BFu15ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_L_BFu15ll) C1{ FL:17 FL FL:15}



static void Test_BFu17ll_L_BFu15ll()
{
  {
    init_simple_test("BFu17ll_L_BFu15ll");
    static STRUCT_IF_C BFu17ll_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu15ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_L_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu15ll, BFu17ll_L_BFu15ll)
//============================================================================


struct  BFu17ll_L_BFu15s  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_L_BFu15s) C1{ FL:17 FL Fs:15}



static void Test_BFu17ll_L_BFu15s()
{
  {
    init_simple_test("BFu17ll_L_BFu15s");
    static STRUCT_IF_C BFu17ll_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu15s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_L_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu15s, BFu17ll_L_BFu15s)
//============================================================================


struct  BFu17ll_L_BFu16i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_L_BFu16i) C1{ FL:17 FL Fi:16}



static void Test_BFu17ll_L_BFu16i()
{
  {
    init_simple_test("BFu17ll_L_BFu16i");
    static STRUCT_IF_C BFu17ll_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu16i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_L_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu16i, BFu17ll_L_BFu16i)
//============================================================================


struct  BFu17ll_L_BFu16ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_L_BFu16ll) C1{ FL:17 FL FL:16}



static void Test_BFu17ll_L_BFu16ll()
{
  {
    init_simple_test("BFu17ll_L_BFu16ll");
    static STRUCT_IF_C BFu17ll_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu16ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_L_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu16ll, BFu17ll_L_BFu16ll)
//============================================================================


struct  BFu17ll_L_BFu16s  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_L_BFu16s) C1{ FL:17 FL Fs:16}



static void Test_BFu17ll_L_BFu16s()
{
  {
    init_simple_test("BFu17ll_L_BFu16s");
    static STRUCT_IF_C BFu17ll_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu16s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_L_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu16s, BFu17ll_L_BFu16s)
//============================================================================


struct  BFu17ll_L_BFu17i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_L_BFu17i) C1{ FL:17 FL Fi:17}



static void Test_BFu17ll_L_BFu17i()
{
  {
    init_simple_test("BFu17ll_L_BFu17i");
    static STRUCT_IF_C BFu17ll_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu17i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu17ll_L_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu17i, BFu17ll_L_BFu17i)
//============================================================================


struct  BFu17ll_L_BFu17ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_L_BFu17ll) C1{ FL:17 FL FL:17}



static void Test_BFu17ll_L_BFu17ll()
{
  {
    init_simple_test("BFu17ll_L_BFu17ll");
    static STRUCT_IF_C BFu17ll_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu17ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu17ll_L_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu17ll, BFu17ll_L_BFu17ll)
//============================================================================


struct  BFu17ll_L_BFu1c  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_L_BFu1c) C1{ FL:17 FL Fc:1}



static void Test_BFu17ll_L_BFu1c()
{
  {
    init_simple_test("BFu17ll_L_BFu1c");
    static STRUCT_IF_C BFu17ll_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu1c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu1c, BFu17ll_L_BFu1c)
//============================================================================


struct  BFu17ll_L_BFu1i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_L_BFu1i) C1{ FL:17 FL Fi:1}



static void Test_BFu17ll_L_BFu1i()
{
  {
    init_simple_test("BFu17ll_L_BFu1i");
    static STRUCT_IF_C BFu17ll_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu1i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu1i, BFu17ll_L_BFu1i)
//============================================================================


struct  BFu17ll_L_BFu1ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_L_BFu1ll) C1{ FL:17 FL FL:1}



static void Test_BFu17ll_L_BFu1ll()
{
  {
    init_simple_test("BFu17ll_L_BFu1ll");
    static STRUCT_IF_C BFu17ll_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu1ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu1ll, BFu17ll_L_BFu1ll)
//============================================================================


struct  BFu17ll_L_BFu1s  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_L_BFu1s) C1{ FL:17 FL Fs:1}



static void Test_BFu17ll_L_BFu1s()
{
  {
    init_simple_test("BFu17ll_L_BFu1s");
    static STRUCT_IF_C BFu17ll_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu1s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu1s, BFu17ll_L_BFu1s)
//============================================================================


struct  BFu17ll_L_BFu31i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_L_BFu31i) C1{ FL:17 FL Fi:31}



static void Test_BFu17ll_L_BFu31i()
{
  {
    init_simple_test("BFu17ll_L_BFu31i");
    static STRUCT_IF_C BFu17ll_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu31i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu17ll_L_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu17ll_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu31i, BFu17ll_L_BFu31i)
//============================================================================


struct  BFu17ll_L_BFu31ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_L_BFu31ll) C1{ FL:17 FL FL:31}



static void Test_BFu17ll_L_BFu31ll()
{
  {
    init_simple_test("BFu17ll_L_BFu31ll");
    static STRUCT_IF_C BFu17ll_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu31ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu17ll_L_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu17ll_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu31ll, BFu17ll_L_BFu31ll)
//============================================================================


struct  BFu17ll_L_BFu32i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_L_BFu32i) C1{ FL:17 FL Fi:32}



static void Test_BFu17ll_L_BFu32i()
{
  {
    init_simple_test("BFu17ll_L_BFu32i");
    static STRUCT_IF_C BFu17ll_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu32i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu17ll_L_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu17ll_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu32i, BFu17ll_L_BFu32i)
//============================================================================


struct  BFu17ll_L_BFu32ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_L_BFu32ll) C1{ FL:17 FL FL:32}



static void Test_BFu17ll_L_BFu32ll()
{
  {
    init_simple_test("BFu17ll_L_BFu32ll");
    static STRUCT_IF_C BFu17ll_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu32ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu17ll_L_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu17ll_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu32ll, BFu17ll_L_BFu32ll)
//============================================================================


struct  BFu17ll_L_BFu33  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_L_BFu33) C1{ FL:17 FL FL:33}



static void Test_BFu17ll_L_BFu33()
{
  {
    init_simple_test("BFu17ll_L_BFu33");
    static STRUCT_IF_C BFu17ll_L_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_L_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu33");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "BFu17ll_L_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "BFu17ll_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu33, BFu17ll_L_BFu33)
//============================================================================


struct  BFu17ll_L_BFu7c  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_L_BFu7c) C1{ FL:17 FL Fc:7}



static void Test_BFu17ll_L_BFu7c()
{
  {
    init_simple_test("BFu17ll_L_BFu7c");
    static STRUCT_IF_C BFu17ll_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu7c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_L_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu7c, BFu17ll_L_BFu7c)
//============================================================================


struct  BFu17ll_L_BFu7i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_L_BFu7i) C1{ FL:17 FL Fi:7}



static void Test_BFu17ll_L_BFu7i()
{
  {
    init_simple_test("BFu17ll_L_BFu7i");
    static STRUCT_IF_C BFu17ll_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu7i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_L_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu7i, BFu17ll_L_BFu7i)
//============================================================================


struct  BFu17ll_L_BFu7ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_L_BFu7ll) C1{ FL:17 FL FL:7}



static void Test_BFu17ll_L_BFu7ll()
{
  {
    init_simple_test("BFu17ll_L_BFu7ll");
    static STRUCT_IF_C BFu17ll_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu7ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_L_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu7ll, BFu17ll_L_BFu7ll)
//============================================================================


struct  BFu17ll_L_BFu7s  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_L_BFu7s) C1{ FL:17 FL Fs:7}



static void Test_BFu17ll_L_BFu7s()
{
  {
    init_simple_test("BFu17ll_L_BFu7s");
    static STRUCT_IF_C BFu17ll_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu7s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_L_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu7s, BFu17ll_L_BFu7s)
//============================================================================


struct  BFu17ll_L_BFu8c  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_L_BFu8c) C1{ FL:17 FL Fc:8}



static void Test_BFu17ll_L_BFu8c()
{
  {
    init_simple_test("BFu17ll_L_BFu8c");
    static STRUCT_IF_C BFu17ll_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu8c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_L_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu8c, BFu17ll_L_BFu8c)
//============================================================================


struct  BFu17ll_L_BFu8i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_L_BFu8i) C1{ FL:17 FL Fi:8}



static void Test_BFu17ll_L_BFu8i()
{
  {
    init_simple_test("BFu17ll_L_BFu8i");
    static STRUCT_IF_C BFu17ll_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu8i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_L_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu8i, BFu17ll_L_BFu8i)
//============================================================================


struct  BFu17ll_L_BFu8ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_L_BFu8ll) C1{ FL:17 FL FL:8}



static void Test_BFu17ll_L_BFu8ll()
{
  {
    init_simple_test("BFu17ll_L_BFu8ll");
    static STRUCT_IF_C BFu17ll_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu8ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_L_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu8ll, BFu17ll_L_BFu8ll)
//============================================================================


struct  BFu17ll_L_BFu8s  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_L_BFu8s) C1{ FL:17 FL Fs:8}



static void Test_BFu17ll_L_BFu8s()
{
  {
    init_simple_test("BFu17ll_L_BFu8s");
    static STRUCT_IF_C BFu17ll_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu8s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_L_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu8s, BFu17ll_L_BFu8s)
//============================================================================


struct  BFu17ll_L_BFu9i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_L_BFu9i) C1{ FL:17 FL Fi:9}



static void Test_BFu17ll_L_BFu9i()
{
  {
    init_simple_test("BFu17ll_L_BFu9i");
    static STRUCT_IF_C BFu17ll_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu9i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_L_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu9i, BFu17ll_L_BFu9i)
//============================================================================


struct  BFu17ll_L_BFu9ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_L_BFu9ll) C1{ FL:17 FL FL:9}



static void Test_BFu17ll_L_BFu9ll()
{
  {
    init_simple_test("BFu17ll_L_BFu9ll");
    static STRUCT_IF_C BFu17ll_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu9ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_L_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu9ll, BFu17ll_L_BFu9ll)
//============================================================================


struct  BFu17ll_L_BFu9s  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_L_BFu9s) C1{ FL:17 FL Fs:9}



static void Test_BFu17ll_L_BFu9s()
{
  {
    init_simple_test("BFu17ll_L_BFu9s");
    static STRUCT_IF_C BFu17ll_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu9s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_L_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu9s, BFu17ll_L_BFu9s)
//============================================================================


struct  BFu17ll_L_C  {
  __tsu64 v1:17;
  __tsi64 v2;
  char v3;
};
//SIG(1 BFu17ll_L_C) C1{ FL:17 FL Fc}



static void Test_BFu17ll_L_C()
{
  {
    init_simple_test("BFu17ll_L_C");
    static STRUCT_IF_C BFu17ll_L_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_C, BFu17ll_L_C)
//============================================================================


struct  BFu17ll_L_D  {
  __tsu64 v1:17;
  __tsi64 v2;
  double v3;
};
//SIG(1 BFu17ll_L_D) C1{ FL:17 FL[2]}



static void Test_BFu17ll_L_D()
{
  {
    init_simple_test("BFu17ll_L_D");
    static STRUCT_IF_C BFu17ll_L_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_L_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_D, BFu17ll_L_D)
//============================================================================


struct  BFu17ll_L_F  {
  __tsu64 v1:17;
  __tsi64 v2;
  float v3;
};
//SIG(1 BFu17ll_L_F) C1{ FL:17 FL Fi}



static void Test_BFu17ll_L_F()
{
  {
    init_simple_test("BFu17ll_L_F");
    static STRUCT_IF_C BFu17ll_L_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_F, BFu17ll_L_F)
//============================================================================


struct  BFu17ll_L_I  {
  __tsu64 v1:17;
  __tsi64 v2;
  int v3;
};
//SIG(1 BFu17ll_L_I) C1{ FL:17 FL Fi}



static void Test_BFu17ll_L_I()
{
  {
    init_simple_test("BFu17ll_L_I");
    static STRUCT_IF_C BFu17ll_L_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_I, BFu17ll_L_I)
//============================================================================


struct  BFu17ll_L_Ip  {
  __tsu64 v1:17;
  __tsi64 v2;
  int *v3;
};
//SIG(1 BFu17ll_L_Ip) C1{ FL:17 FL Fp}



static void Test_BFu17ll_L_Ip()
{
  {
    init_simple_test("BFu17ll_L_Ip");
    static STRUCT_IF_C BFu17ll_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_Ip, BFu17ll_L_Ip)
//============================================================================


struct  BFu17ll_L_L  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_L_L) C1{ FL:17 FL[2]}



static void Test_BFu17ll_L_L()
{
  {
    init_simple_test("BFu17ll_L_L");
    static STRUCT_IF_C BFu17ll_L_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_L_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_L, BFu17ll_L_L)
//============================================================================


struct  BFu17ll_L_S  {
  __tsu64 v1:17;
  __tsi64 v2;
  short v3;
};
//SIG(1 BFu17ll_L_S) C1{ FL:17 FL Fs}



static void Test_BFu17ll_L_S()
{
  {
    init_simple_test("BFu17ll_L_S");
    static STRUCT_IF_C BFu17ll_L_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_S, BFu17ll_L_S)
//============================================================================


struct  BFu17ll_L_Uc  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_L_Uc) C1{ FL:17 FL Fc}



static void Test_BFu17ll_L_Uc()
{
  {
    init_simple_test("BFu17ll_L_Uc");
    static STRUCT_IF_C BFu17ll_L_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_Uc, BFu17ll_L_Uc)
//============================================================================


struct  BFu17ll_L_Ui  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_L_Ui) C1{ FL:17 FL Fi}



static void Test_BFu17ll_L_Ui()
{
  {
    init_simple_test("BFu17ll_L_Ui");
    static STRUCT_IF_C BFu17ll_L_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_Ui, BFu17ll_L_Ui)
//============================================================================


struct  BFu17ll_L_Ul  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_L_Ul) C1{ FL:17 FL[2]}



static void Test_BFu17ll_L_Ul()
{
  {
    init_simple_test("BFu17ll_L_Ul");
    static STRUCT_IF_C BFu17ll_L_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_Ul, BFu17ll_L_Ul)
//============================================================================


struct  BFu17ll_L_Us  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_L_Us) C1{ FL:17 FL Fs}



static void Test_BFu17ll_L_Us()
{
  {
    init_simple_test("BFu17ll_L_Us");
    static STRUCT_IF_C BFu17ll_L_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_Us, BFu17ll_L_Us)
//============================================================================


struct  BFu17ll_L_Vp  {
  __tsu64 v1:17;
  __tsi64 v2;
  void *v3;
};
//SIG(1 BFu17ll_L_Vp) C1{ FL:17 FL Fp}



static void Test_BFu17ll_L_Vp()
{
  {
    init_simple_test("BFu17ll_L_Vp");
    static STRUCT_IF_C BFu17ll_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_Vp, BFu17ll_L_Vp)
//============================================================================


struct  BFu17ll_S  {
  __tsu64 v1:17;
  short v2;
};
//SIG(1 BFu17ll_S) C1{ FL:17 Fs}



static void Test_BFu17ll_S()
{
  {
    init_simple_test("BFu17ll_S");
    static STRUCT_IF_C BFu17ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S");
    check_field_offset(lv, v2, 4, "BFu17ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S, BFu17ll_S)
//============================================================================


struct  BFu17ll_S_BFu15i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_S_BFu15i) C1{ FL:17 Fs Fi:15}



static void Test_BFu17ll_S_BFu15i()
{
  {
    init_simple_test("BFu17ll_S_BFu15i");
    static STRUCT_IF_C BFu17ll_S_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu15i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu17ll_S_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu17ll_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu15i, BFu17ll_S_BFu15i)
//============================================================================


struct  BFu17ll_S_BFu15ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_S_BFu15ll) C1{ FL:17 Fs FL:15}



static void Test_BFu17ll_S_BFu15ll()
{
  {
    init_simple_test("BFu17ll_S_BFu15ll");
    static STRUCT_IF_C BFu17ll_S_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu17ll_S_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu17ll_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu15ll, BFu17ll_S_BFu15ll)
//============================================================================


struct  BFu17ll_S_BFu15s  {
  __tsu64 v1:17;
  short v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_S_BFu15s) C1{ FL:17 Fs Fs:15}



static void Test_BFu17ll_S_BFu15s()
{
  {
    init_simple_test("BFu17ll_S_BFu15s");
    static STRUCT_IF_C BFu17ll_S_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu15s");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu17ll_S_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu17ll_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu15s, BFu17ll_S_BFu15s)
//============================================================================


struct  BFu17ll_S_BFu16i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_S_BFu16i) C1{ FL:17 Fs Fi:16}



static void Test_BFu17ll_S_BFu16i()
{
  {
    init_simple_test("BFu17ll_S_BFu16i");
    static STRUCT_IF_C BFu17ll_S_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu16i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu17ll_S_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu17ll_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu16i, BFu17ll_S_BFu16i)
//============================================================================


struct  BFu17ll_S_BFu16ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_S_BFu16ll) C1{ FL:17 Fs FL:16}



static void Test_BFu17ll_S_BFu16ll()
{
  {
    init_simple_test("BFu17ll_S_BFu16ll");
    static STRUCT_IF_C BFu17ll_S_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu17ll_S_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu17ll_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu16ll, BFu17ll_S_BFu16ll)
//============================================================================


struct  BFu17ll_S_BFu16s  {
  __tsu64 v1:17;
  short v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_S_BFu16s) C1{ FL:17 Fs Fs:16}



static void Test_BFu17ll_S_BFu16s()
{
  {
    init_simple_test("BFu17ll_S_BFu16s");
    static STRUCT_IF_C BFu17ll_S_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu16s");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu17ll_S_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu17ll_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu16s, BFu17ll_S_BFu16s)
//============================================================================


struct  BFu17ll_S_BFu17i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_S_BFu17i) C1{ FL:17 Fs Fi:17}



static void Test_BFu17ll_S_BFu17i()
{
  {
    init_simple_test("BFu17ll_S_BFu17i");
    static STRUCT_IF_C BFu17ll_S_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu17i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu17ll_S_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu17i, BFu17ll_S_BFu17i)
//============================================================================


struct  BFu17ll_S_BFu17ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_S_BFu17ll) C1{ FL:17 Fs FL:17}



static void Test_BFu17ll_S_BFu17ll()
{
  {
    init_simple_test("BFu17ll_S_BFu17ll");
    static STRUCT_IF_C BFu17ll_S_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "BFu17ll_S_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu17ll, BFu17ll_S_BFu17ll)
//============================================================================


struct  BFu17ll_S_BFu1c  {
  __tsu64 v1:17;
  short v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_S_BFu1c) C1{ FL:17 Fs Fc:1}



static void Test_BFu17ll_S_BFu1c()
{
  {
    init_simple_test("BFu17ll_S_BFu1c");
    static STRUCT_IF_C BFu17ll_S_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu1c");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu17ll_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu1c, BFu17ll_S_BFu1c)
//============================================================================


struct  BFu17ll_S_BFu1i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_S_BFu1i) C1{ FL:17 Fs Fi:1}



static void Test_BFu17ll_S_BFu1i()
{
  {
    init_simple_test("BFu17ll_S_BFu1i");
    static STRUCT_IF_C BFu17ll_S_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu1i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu17ll_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu1i, BFu17ll_S_BFu1i)
//============================================================================


struct  BFu17ll_S_BFu1ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_S_BFu1ll) C1{ FL:17 Fs FL:1}



static void Test_BFu17ll_S_BFu1ll()
{
  {
    init_simple_test("BFu17ll_S_BFu1ll");
    static STRUCT_IF_C BFu17ll_S_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu17ll_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu1ll, BFu17ll_S_BFu1ll)
//============================================================================


struct  BFu17ll_S_BFu1s  {
  __tsu64 v1:17;
  short v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_S_BFu1s) C1{ FL:17 Fs Fs:1}



static void Test_BFu17ll_S_BFu1s()
{
  {
    init_simple_test("BFu17ll_S_BFu1s");
    static STRUCT_IF_C BFu17ll_S_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu1s");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu17ll_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu1s, BFu17ll_S_BFu1s)
//============================================================================


struct  BFu17ll_S_BFu31i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_S_BFu31i) C1{ FL:17 Fs Fi:31}



static void Test_BFu17ll_S_BFu31i()
{
  {
    init_simple_test("BFu17ll_S_BFu31i");
    static STRUCT_IF_C BFu17ll_S_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu31i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu17ll_S_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu17ll_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu31i, BFu17ll_S_BFu31i)
//============================================================================


struct  BFu17ll_S_BFu31ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_S_BFu31ll) C1{ FL:17 Fs FL:31}



static void Test_BFu17ll_S_BFu31ll()
{
  {
    init_simple_test("BFu17ll_S_BFu31ll");
    static STRUCT_IF_C BFu17ll_S_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "BFu17ll_S_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "BFu17ll_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu31ll, BFu17ll_S_BFu31ll)
//============================================================================


struct  BFu17ll_S_BFu32i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_S_BFu32i) C1{ FL:17 Fs Fi:32}



static void Test_BFu17ll_S_BFu32i()
{
  {
    init_simple_test("BFu17ll_S_BFu32i");
    static STRUCT_IF_C BFu17ll_S_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu32i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu17ll_S_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu17ll_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu32i, BFu17ll_S_BFu32i)
//============================================================================


struct  BFu17ll_S_BFu32ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_S_BFu32ll) C1{ FL:17 Fs FL:32}



static void Test_BFu17ll_S_BFu32ll()
{
  {
    init_simple_test("BFu17ll_S_BFu32ll");
    static STRUCT_IF_C BFu17ll_S_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "BFu17ll_S_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "BFu17ll_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu32ll, BFu17ll_S_BFu32ll)
//============================================================================


struct  BFu17ll_S_BFu33  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_S_BFu33) C1{ FL:17 Fs FL:33}



static void Test_BFu17ll_S_BFu33()
{
  {
    init_simple_test("BFu17ll_S_BFu33");
    static STRUCT_IF_C BFu17ll_S_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu33");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "BFu17ll_S_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "BFu17ll_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu33, BFu17ll_S_BFu33)
//============================================================================


struct  BFu17ll_S_BFu7c  {
  __tsu64 v1:17;
  short v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_S_BFu7c) C1{ FL:17 Fs Fc:7}



static void Test_BFu17ll_S_BFu7c()
{
  {
    init_simple_test("BFu17ll_S_BFu7c");
    static STRUCT_IF_C BFu17ll_S_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu7c");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu17ll_S_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu17ll_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu7c, BFu17ll_S_BFu7c)
//============================================================================


struct  BFu17ll_S_BFu7i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_S_BFu7i) C1{ FL:17 Fs Fi:7}



static void Test_BFu17ll_S_BFu7i()
{
  {
    init_simple_test("BFu17ll_S_BFu7i");
    static STRUCT_IF_C BFu17ll_S_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu7i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu17ll_S_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu17ll_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu7i, BFu17ll_S_BFu7i)
//============================================================================


struct  BFu17ll_S_BFu7ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_S_BFu7ll) C1{ FL:17 Fs FL:7}



static void Test_BFu17ll_S_BFu7ll()
{
  {
    init_simple_test("BFu17ll_S_BFu7ll");
    static STRUCT_IF_C BFu17ll_S_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu17ll_S_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu17ll_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu7ll, BFu17ll_S_BFu7ll)
//============================================================================


struct  BFu17ll_S_BFu7s  {
  __tsu64 v1:17;
  short v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_S_BFu7s) C1{ FL:17 Fs Fs:7}



static void Test_BFu17ll_S_BFu7s()
{
  {
    init_simple_test("BFu17ll_S_BFu7s");
    static STRUCT_IF_C BFu17ll_S_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu7s");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu17ll_S_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu17ll_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu7s, BFu17ll_S_BFu7s)
//============================================================================


struct  BFu17ll_S_BFu8c  {
  __tsu64 v1:17;
  short v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_S_BFu8c) C1{ FL:17 Fs Fc:8}



static void Test_BFu17ll_S_BFu8c()
{
  {
    init_simple_test("BFu17ll_S_BFu8c");
    static STRUCT_IF_C BFu17ll_S_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu8c");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu17ll_S_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu17ll_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu8c, BFu17ll_S_BFu8c)
//============================================================================


struct  BFu17ll_S_BFu8i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_S_BFu8i) C1{ FL:17 Fs Fi:8}



static void Test_BFu17ll_S_BFu8i()
{
  {
    init_simple_test("BFu17ll_S_BFu8i");
    static STRUCT_IF_C BFu17ll_S_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu8i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu17ll_S_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu17ll_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu8i, BFu17ll_S_BFu8i)
//============================================================================


struct  BFu17ll_S_BFu8ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_S_BFu8ll) C1{ FL:17 Fs FL:8}



static void Test_BFu17ll_S_BFu8ll()
{
  {
    init_simple_test("BFu17ll_S_BFu8ll");
    static STRUCT_IF_C BFu17ll_S_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu17ll_S_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu17ll_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu8ll, BFu17ll_S_BFu8ll)
//============================================================================


struct  BFu17ll_S_BFu8s  {
  __tsu64 v1:17;
  short v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_S_BFu8s) C1{ FL:17 Fs Fs:8}



static void Test_BFu17ll_S_BFu8s()
{
  {
    init_simple_test("BFu17ll_S_BFu8s");
    static STRUCT_IF_C BFu17ll_S_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu8s");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu17ll_S_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu17ll_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu8s, BFu17ll_S_BFu8s)
//============================================================================


struct  BFu17ll_S_BFu9i  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_S_BFu9i) C1{ FL:17 Fs Fi:9}



static void Test_BFu17ll_S_BFu9i()
{
  {
    init_simple_test("BFu17ll_S_BFu9i");
    static STRUCT_IF_C BFu17ll_S_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu9i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu17ll_S_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu17ll_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu9i, BFu17ll_S_BFu9i)
//============================================================================


struct  BFu17ll_S_BFu9ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_S_BFu9ll) C1{ FL:17 Fs FL:9}



static void Test_BFu17ll_S_BFu9ll()
{
  {
    init_simple_test("BFu17ll_S_BFu9ll");
    static STRUCT_IF_C BFu17ll_S_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu17ll_S_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu17ll_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu9ll, BFu17ll_S_BFu9ll)
//============================================================================


struct  BFu17ll_S_BFu9s  {
  __tsu64 v1:17;
  short v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_S_BFu9s) C1{ FL:17 Fs Fs:9}



static void Test_BFu17ll_S_BFu9s()
{
  {
    init_simple_test("BFu17ll_S_BFu9s");
    static STRUCT_IF_C BFu17ll_S_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu9s");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu17ll_S_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu17ll_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu9s, BFu17ll_S_BFu9s)
//============================================================================


struct  BFu17ll_S_C  {
  __tsu64 v1:17;
  short v2;
  char v3;
};
//SIG(1 BFu17ll_S_C) C1{ FL:17 Fs Fc}



static void Test_BFu17ll_S_C()
{
  {
    init_simple_test("BFu17ll_S_C");
    static STRUCT_IF_C BFu17ll_S_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_C");
    check_field_offset(lv, v2, 4, "BFu17ll_S_C.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_C, BFu17ll_S_C)
//============================================================================


struct  BFu17ll_S_D  {
  __tsu64 v1:17;
  short v2;
  double v3;
};
//SIG(1 BFu17ll_S_D) C1{ FL:17 Fs FL}



static void Test_BFu17ll_S_D()
{
  {
    init_simple_test("BFu17ll_S_D");
    static STRUCT_IF_C BFu17ll_S_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_S_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_D");
    check_field_offset(lv, v2, 4, "BFu17ll_S_D.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_D, BFu17ll_S_D)
//============================================================================


struct  BFu17ll_S_F  {
  __tsu64 v1:17;
  short v2;
  float v3;
};
//SIG(1 BFu17ll_S_F) C1{ FL:17 Fs Fi}



static void Test_BFu17ll_S_F()
{
  {
    init_simple_test("BFu17ll_S_F");
    static STRUCT_IF_C BFu17ll_S_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_F");
    check_field_offset(lv, v2, 4, "BFu17ll_S_F.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_F, BFu17ll_S_F)
//============================================================================


struct  BFu17ll_S_I  {
  __tsu64 v1:17;
  short v2;
  int v3;
};
//SIG(1 BFu17ll_S_I) C1{ FL:17 Fs Fi}



static void Test_BFu17ll_S_I()
{
  {
    init_simple_test("BFu17ll_S_I");
    static STRUCT_IF_C BFu17ll_S_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_I");
    check_field_offset(lv, v2, 4, "BFu17ll_S_I.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_I, BFu17ll_S_I)
//============================================================================


struct  BFu17ll_S_Ip  {
  __tsu64 v1:17;
  short v2;
  int *v3;
};
//SIG(1 BFu17ll_S_Ip) C1{ FL:17 Fs Fp}



static void Test_BFu17ll_S_Ip()
{
  {
    init_simple_test("BFu17ll_S_Ip");
    static STRUCT_IF_C BFu17ll_S_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_Ip");
    check_field_offset(lv, v2, 4, "BFu17ll_S_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_Ip, BFu17ll_S_Ip)
//============================================================================


struct  BFu17ll_S_L  {
  __tsu64 v1:17;
  short v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_S_L) C1{ FL:17 Fs FL}



static void Test_BFu17ll_S_L()
{
  {
    init_simple_test("BFu17ll_S_L");
    static STRUCT_IF_C BFu17ll_S_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_S_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_L");
    check_field_offset(lv, v2, 4, "BFu17ll_S_L.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_L, BFu17ll_S_L)
//============================================================================


struct  BFu17ll_S_S  {
  __tsu64 v1:17;
  short v2;
  short v3;
};
//SIG(1 BFu17ll_S_S) C1{ FL:17 Fs[2]}



static void Test_BFu17ll_S_S()
{
  {
    init_simple_test("BFu17ll_S_S");
    static STRUCT_IF_C BFu17ll_S_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_S");
    check_field_offset(lv, v2, 4, "BFu17ll_S_S.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_S, BFu17ll_S_S)
//============================================================================


struct  BFu17ll_S_Uc  {
  __tsu64 v1:17;
  short v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_S_Uc) C1{ FL:17 Fs Fc}



static void Test_BFu17ll_S_Uc()
{
  {
    init_simple_test("BFu17ll_S_Uc");
    static STRUCT_IF_C BFu17ll_S_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_Uc");
    check_field_offset(lv, v2, 4, "BFu17ll_S_Uc.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_Uc, BFu17ll_S_Uc)
//============================================================================


struct  BFu17ll_S_Ui  {
  __tsu64 v1:17;
  short v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_S_Ui) C1{ FL:17 Fs Fi}



static void Test_BFu17ll_S_Ui()
{
  {
    init_simple_test("BFu17ll_S_Ui");
    static STRUCT_IF_C BFu17ll_S_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_Ui");
    check_field_offset(lv, v2, 4, "BFu17ll_S_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_Ui, BFu17ll_S_Ui)
//============================================================================


struct  BFu17ll_S_Ul  {
  __tsu64 v1:17;
  short v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_S_Ul) C1{ FL:17 Fs FL}



static void Test_BFu17ll_S_Ul()
{
  {
    init_simple_test("BFu17ll_S_Ul");
    static STRUCT_IF_C BFu17ll_S_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_S_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_Ul");
    check_field_offset(lv, v2, 4, "BFu17ll_S_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_Ul, BFu17ll_S_Ul)
//============================================================================


struct  BFu17ll_S_Us  {
  __tsu64 v1:17;
  short v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_S_Us) C1{ FL:17 Fs[2]}



static void Test_BFu17ll_S_Us()
{
  {
    init_simple_test("BFu17ll_S_Us");
    static STRUCT_IF_C BFu17ll_S_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_Us");
    check_field_offset(lv, v2, 4, "BFu17ll_S_Us.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_Us, BFu17ll_S_Us)
//============================================================================


struct  BFu17ll_S_Vp  {
  __tsu64 v1:17;
  short v2;
  void *v3;
};
//SIG(1 BFu17ll_S_Vp) C1{ FL:17 Fs Fp}



static void Test_BFu17ll_S_Vp()
{
  {
    init_simple_test("BFu17ll_S_Vp");
    static STRUCT_IF_C BFu17ll_S_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_S_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_Vp");
    check_field_offset(lv, v2, 4, "BFu17ll_S_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_Vp, BFu17ll_S_Vp)
//============================================================================


struct  BFu17ll_Uc  {
  __tsu64 v1:17;
  unsigned char v2;
};
//SIG(1 BFu17ll_Uc) C1{ FL:17 Fc}



static void Test_BFu17ll_Uc()
{
  {
    init_simple_test("BFu17ll_Uc");
    static STRUCT_IF_C BFu17ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc, BFu17ll_Uc)
//============================================================================


struct  BFu17ll_Uc_BFu15i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_Uc_BFu15i) C1{ FL:17 Fc Fi:15}



static void Test_BFu17ll_Uc_BFu15i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu15i");
    static STRUCT_IF_C BFu17ll_Uc_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu15i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_Uc_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu15i, BFu17ll_Uc_BFu15i)
//============================================================================


struct  BFu17ll_Uc_BFu15ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_Uc_BFu15ll) C1{ FL:17 Fc FL:15}



static void Test_BFu17ll_Uc_BFu15ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu15ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu15ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu15ll, BFu17ll_Uc_BFu15ll)
//============================================================================


struct  BFu17ll_Uc_BFu15s  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_Uc_BFu15s) C1{ FL:17 Fc Fs:15}



static void Test_BFu17ll_Uc_BFu15s()
{
  {
    init_simple_test("BFu17ll_Uc_BFu15s");
    static STRUCT_IF_C BFu17ll_Uc_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu15s");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_Uc_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu15s, BFu17ll_Uc_BFu15s)
//============================================================================


struct  BFu17ll_Uc_BFu16i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_Uc_BFu16i) C1{ FL:17 Fc Fi:16}



static void Test_BFu17ll_Uc_BFu16i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu16i");
    static STRUCT_IF_C BFu17ll_Uc_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu16i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_Uc_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu16i, BFu17ll_Uc_BFu16i)
//============================================================================


struct  BFu17ll_Uc_BFu16ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_Uc_BFu16ll) C1{ FL:17 Fc FL:16}



static void Test_BFu17ll_Uc_BFu16ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu16ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu16ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu16ll, BFu17ll_Uc_BFu16ll)
//============================================================================


struct  BFu17ll_Uc_BFu16s  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_Uc_BFu16s) C1{ FL:17 Fc Fs:16}



static void Test_BFu17ll_Uc_BFu16s()
{
  {
    init_simple_test("BFu17ll_Uc_BFu16s");
    static STRUCT_IF_C BFu17ll_Uc_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu16s");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_Uc_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu16s, BFu17ll_Uc_BFu16s)
//============================================================================


struct  BFu17ll_Uc_BFu17i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_Uc_BFu17i) C1{ FL:17 Fc Fi:17}



static void Test_BFu17ll_Uc_BFu17i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu17i");
    static STRUCT_IF_C BFu17ll_Uc_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu17i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_Uc_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu17i, BFu17ll_Uc_BFu17i)
//============================================================================


struct  BFu17ll_Uc_BFu17ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_Uc_BFu17ll) C1{ FL:17 Fc FL:17}



static void Test_BFu17ll_Uc_BFu17ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu17ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu17ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu17ll, BFu17ll_Uc_BFu17ll)
//============================================================================


struct  BFu17ll_Uc_BFu1c  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_Uc_BFu1c) C1{ FL:17 Fc Fc:1}



static void Test_BFu17ll_Uc_BFu1c()
{
  {
    init_simple_test("BFu17ll_Uc_BFu1c");
    static STRUCT_IF_C BFu17ll_Uc_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu1c");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu1c, BFu17ll_Uc_BFu1c)
//============================================================================


struct  BFu17ll_Uc_BFu1i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_Uc_BFu1i) C1{ FL:17 Fc Fi:1}



static void Test_BFu17ll_Uc_BFu1i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu1i");
    static STRUCT_IF_C BFu17ll_Uc_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu1i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu1i, BFu17ll_Uc_BFu1i)
//============================================================================


struct  BFu17ll_Uc_BFu1ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_Uc_BFu1ll) C1{ FL:17 Fc FL:1}



static void Test_BFu17ll_Uc_BFu1ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu1ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu1ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu1ll, BFu17ll_Uc_BFu1ll)
//============================================================================


struct  BFu17ll_Uc_BFu1s  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_Uc_BFu1s) C1{ FL:17 Fc Fs:1}



static void Test_BFu17ll_Uc_BFu1s()
{
  {
    init_simple_test("BFu17ll_Uc_BFu1s");
    static STRUCT_IF_C BFu17ll_Uc_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu1s");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu1s, BFu17ll_Uc_BFu1s)
//============================================================================


struct  BFu17ll_Uc_BFu31i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_Uc_BFu31i) C1{ FL:17 Fc Fi:31}



static void Test_BFu17ll_Uc_BFu31i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu31i");
    static STRUCT_IF_C BFu17ll_Uc_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu31i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_Uc_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu31i, BFu17ll_Uc_BFu31i)
//============================================================================


struct  BFu17ll_Uc_BFu31ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_Uc_BFu31ll) C1{ FL:17 Fc FL:31}



static void Test_BFu17ll_Uc_BFu31ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu31ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu31ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu31ll, BFu17ll_Uc_BFu31ll)
//============================================================================


struct  BFu17ll_Uc_BFu32i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_Uc_BFu32i) C1{ FL:17 Fc Fi:32}



static void Test_BFu17ll_Uc_BFu32i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu32i");
    static STRUCT_IF_C BFu17ll_Uc_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu32i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_Uc_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu32i, BFu17ll_Uc_BFu32i)
//============================================================================


struct  BFu17ll_Uc_BFu32ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_Uc_BFu32ll) C1{ FL:17 Fc FL:32}



static void Test_BFu17ll_Uc_BFu32ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu32ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu32ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu32ll, BFu17ll_Uc_BFu32ll)
//============================================================================


struct  BFu17ll_Uc_BFu33  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_Uc_BFu33) C1{ FL:17 Fc FL:33}



static void Test_BFu17ll_Uc_BFu33()
{
  {
    init_simple_test("BFu17ll_Uc_BFu33");
    static STRUCT_IF_C BFu17ll_Uc_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Uc_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu33");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu17ll_Uc_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu17ll_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu33, BFu17ll_Uc_BFu33)
//============================================================================


struct  BFu17ll_Uc_BFu7c  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_Uc_BFu7c) C1{ FL:17 Fc Fc:7}



static void Test_BFu17ll_Uc_BFu7c()
{
  {
    init_simple_test("BFu17ll_Uc_BFu7c");
    static STRUCT_IF_C BFu17ll_Uc_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu7c");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_Uc_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu7c, BFu17ll_Uc_BFu7c)
//============================================================================


struct  BFu17ll_Uc_BFu7i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_Uc_BFu7i) C1{ FL:17 Fc Fi:7}



static void Test_BFu17ll_Uc_BFu7i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu7i");
    static STRUCT_IF_C BFu17ll_Uc_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu7i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_Uc_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu7i, BFu17ll_Uc_BFu7i)
//============================================================================


struct  BFu17ll_Uc_BFu7ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_Uc_BFu7ll) C1{ FL:17 Fc FL:7}



static void Test_BFu17ll_Uc_BFu7ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu7ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu7ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu7ll, BFu17ll_Uc_BFu7ll)
//============================================================================


struct  BFu17ll_Uc_BFu7s  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_Uc_BFu7s) C1{ FL:17 Fc Fs:7}



static void Test_BFu17ll_Uc_BFu7s()
{
  {
    init_simple_test("BFu17ll_Uc_BFu7s");
    static STRUCT_IF_C BFu17ll_Uc_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu7s");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_Uc_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu7s, BFu17ll_Uc_BFu7s)
//============================================================================


struct  BFu17ll_Uc_BFu8c  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_Uc_BFu8c) C1{ FL:17 Fc Fc:8}



static void Test_BFu17ll_Uc_BFu8c()
{
  {
    init_simple_test("BFu17ll_Uc_BFu8c");
    static STRUCT_IF_C BFu17ll_Uc_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu8c");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_Uc_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu8c, BFu17ll_Uc_BFu8c)
//============================================================================


struct  BFu17ll_Uc_BFu8i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_Uc_BFu8i) C1{ FL:17 Fc Fi:8}



static void Test_BFu17ll_Uc_BFu8i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu8i");
    static STRUCT_IF_C BFu17ll_Uc_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu8i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_Uc_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu8i, BFu17ll_Uc_BFu8i)
//============================================================================


struct  BFu17ll_Uc_BFu8ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_Uc_BFu8ll) C1{ FL:17 Fc FL:8}



static void Test_BFu17ll_Uc_BFu8ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu8ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu8ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu8ll, BFu17ll_Uc_BFu8ll)
//============================================================================


struct  BFu17ll_Uc_BFu8s  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_Uc_BFu8s) C1{ FL:17 Fc Fs:8}



static void Test_BFu17ll_Uc_BFu8s()
{
  {
    init_simple_test("BFu17ll_Uc_BFu8s");
    static STRUCT_IF_C BFu17ll_Uc_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu8s");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_Uc_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu8s, BFu17ll_Uc_BFu8s)
//============================================================================


struct  BFu17ll_Uc_BFu9i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_Uc_BFu9i) C1{ FL:17 Fc Fi:9}



static void Test_BFu17ll_Uc_BFu9i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu9i");
    static STRUCT_IF_C BFu17ll_Uc_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu9i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_Uc_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu9i, BFu17ll_Uc_BFu9i)
//============================================================================


struct  BFu17ll_Uc_BFu9ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_Uc_BFu9ll) C1{ FL:17 Fc FL:9}



static void Test_BFu17ll_Uc_BFu9ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu9ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu9ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu9ll, BFu17ll_Uc_BFu9ll)
//============================================================================


struct  BFu17ll_Uc_BFu9s  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_Uc_BFu9s) C1{ FL:17 Fc Fs:9}



static void Test_BFu17ll_Uc_BFu9s()
{
  {
    init_simple_test("BFu17ll_Uc_BFu9s");
    static STRUCT_IF_C BFu17ll_Uc_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu9s");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_Uc_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu9s, BFu17ll_Uc_BFu9s)
//============================================================================


struct  BFu17ll_Uc_C  {
  __tsu64 v1:17;
  unsigned char v2;
  char v3;
};
//SIG(1 BFu17ll_Uc_C) C1{ FL:17 Fc[2]}



static void Test_BFu17ll_Uc_C()
{
  {
    init_simple_test("BFu17ll_Uc_C");
    static STRUCT_IF_C BFu17ll_Uc_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_C");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_C.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_C, BFu17ll_Uc_C)
//============================================================================


struct  BFu17ll_Uc_D  {
  __tsu64 v1:17;
  unsigned char v2;
  double v3;
};
//SIG(1 BFu17ll_Uc_D) C1{ FL:17 Fc FL}



static void Test_BFu17ll_Uc_D()
{
  {
    init_simple_test("BFu17ll_Uc_D");
    static STRUCT_IF_C BFu17ll_Uc_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Uc_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_D");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_D, BFu17ll_Uc_D)
//============================================================================


struct  BFu17ll_Uc_F  {
  __tsu64 v1:17;
  unsigned char v2;
  float v3;
};
//SIG(1 BFu17ll_Uc_F) C1{ FL:17 Fc Fi}



static void Test_BFu17ll_Uc_F()
{
  {
    init_simple_test("BFu17ll_Uc_F");
    static STRUCT_IF_C BFu17ll_Uc_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_F");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_F.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_F, BFu17ll_Uc_F)
//============================================================================


struct  BFu17ll_Uc_I  {
  __tsu64 v1:17;
  unsigned char v2;
  int v3;
};
//SIG(1 BFu17ll_Uc_I) C1{ FL:17 Fc Fi}



static void Test_BFu17ll_Uc_I()
{
  {
    init_simple_test("BFu17ll_Uc_I");
    static STRUCT_IF_C BFu17ll_Uc_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_I");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_I.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_I, BFu17ll_Uc_I)
//============================================================================


struct  BFu17ll_Uc_Ip  {
  __tsu64 v1:17;
  unsigned char v2;
  int *v3;
};
//SIG(1 BFu17ll_Uc_Ip) C1{ FL:17 Fc Fp}



static void Test_BFu17ll_Uc_Ip()
{
  {
    init_simple_test("BFu17ll_Uc_Ip");
    static STRUCT_IF_C BFu17ll_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Uc_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_Ip");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_Ip, BFu17ll_Uc_Ip)
//============================================================================


struct  BFu17ll_Uc_L  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_Uc_L) C1{ FL:17 Fc FL}



static void Test_BFu17ll_Uc_L()
{
  {
    init_simple_test("BFu17ll_Uc_L");
    static STRUCT_IF_C BFu17ll_Uc_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Uc_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_L");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_L, BFu17ll_Uc_L)
//============================================================================


struct  BFu17ll_Uc_S  {
  __tsu64 v1:17;
  unsigned char v2;
  short v3;
};
//SIG(1 BFu17ll_Uc_S) C1{ FL:17 Fc Fs}



static void Test_BFu17ll_Uc_S()
{
  {
    init_simple_test("BFu17ll_Uc_S");
    static STRUCT_IF_C BFu17ll_Uc_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_S");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_S.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_S, BFu17ll_Uc_S)
//============================================================================


struct  BFu17ll_Uc_Uc  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_Uc_Uc) C1{ FL:17 Fc[2]}



static void Test_BFu17ll_Uc_Uc()
{
  {
    init_simple_test("BFu17ll_Uc_Uc");
    static STRUCT_IF_C BFu17ll_Uc_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_Uc");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_Uc, BFu17ll_Uc_Uc)
//============================================================================


struct  BFu17ll_Uc_Ui  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_Uc_Ui) C1{ FL:17 Fc Fi}



static void Test_BFu17ll_Uc_Ui()
{
  {
    init_simple_test("BFu17ll_Uc_Ui");
    static STRUCT_IF_C BFu17ll_Uc_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_Ui");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_Ui, BFu17ll_Uc_Ui)
//============================================================================


struct  BFu17ll_Uc_Ul  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_Uc_Ul) C1{ FL:17 Fc FL}



static void Test_BFu17ll_Uc_Ul()
{
  {
    init_simple_test("BFu17ll_Uc_Ul");
    static STRUCT_IF_C BFu17ll_Uc_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Uc_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_Ul");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_Ul, BFu17ll_Uc_Ul)
//============================================================================


struct  BFu17ll_Uc_Us  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_Uc_Us) C1{ FL:17 Fc Fs}



static void Test_BFu17ll_Uc_Us()
{
  {
    init_simple_test("BFu17ll_Uc_Us");
    static STRUCT_IF_C BFu17ll_Uc_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_Us");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_Us.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_Us, BFu17ll_Uc_Us)
//============================================================================


struct  BFu17ll_Uc_Vp  {
  __tsu64 v1:17;
  unsigned char v2;
  void *v3;
};
//SIG(1 BFu17ll_Uc_Vp) C1{ FL:17 Fc Fp}



static void Test_BFu17ll_Uc_Vp()
{
  {
    init_simple_test("BFu17ll_Uc_Vp");
    static STRUCT_IF_C BFu17ll_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Uc_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_Vp");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_Vp, BFu17ll_Uc_Vp)
//============================================================================


struct  BFu17ll_Ui  {
  __tsu64 v1:17;
  unsigned int v2;
};
//SIG(1 BFu17ll_Ui) C1{ FL:17 Fi}



static void Test_BFu17ll_Ui()
{
  {
    init_simple_test("BFu17ll_Ui");
    static STRUCT_IF_C BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui, BFu17ll_Ui)
//============================================================================


struct  BFu17ll_Ui_BFu15i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_Ui_BFu15i) C1{ FL:17 Fi Fi:15}



static void Test_BFu17ll_Ui_BFu15i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu15i");
    static STRUCT_IF_C BFu17ll_Ui_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu15i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_Ui_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu15i, BFu17ll_Ui_BFu15i)
//============================================================================


struct  BFu17ll_Ui_BFu15ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_Ui_BFu15ll) C1{ FL:17 Fi FL:15}



static void Test_BFu17ll_Ui_BFu15ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu15ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu15ll, BFu17ll_Ui_BFu15ll)
//============================================================================


struct  BFu17ll_Ui_BFu15s  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_Ui_BFu15s) C1{ FL:17 Fi Fs:15}



static void Test_BFu17ll_Ui_BFu15s()
{
  {
    init_simple_test("BFu17ll_Ui_BFu15s");
    static STRUCT_IF_C BFu17ll_Ui_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu15s");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu17ll_Ui_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu17ll_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu15s, BFu17ll_Ui_BFu15s)
//============================================================================


struct  BFu17ll_Ui_BFu16i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_Ui_BFu16i) C1{ FL:17 Fi Fi:16}



static void Test_BFu17ll_Ui_BFu16i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu16i");
    static STRUCT_IF_C BFu17ll_Ui_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu16i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_Ui_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu16i, BFu17ll_Ui_BFu16i)
//============================================================================


struct  BFu17ll_Ui_BFu16ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_Ui_BFu16ll) C1{ FL:17 Fi FL:16}



static void Test_BFu17ll_Ui_BFu16ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu16ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu16ll, BFu17ll_Ui_BFu16ll)
//============================================================================


struct  BFu17ll_Ui_BFu16s  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_Ui_BFu16s) C1{ FL:17 Fi Fs:16}



static void Test_BFu17ll_Ui_BFu16s()
{
  {
    init_simple_test("BFu17ll_Ui_BFu16s");
    static STRUCT_IF_C BFu17ll_Ui_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu16s");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu17ll_Ui_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu17ll_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu16s, BFu17ll_Ui_BFu16s)
//============================================================================


struct  BFu17ll_Ui_BFu17i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_Ui_BFu17i) C1{ FL:17 Fi Fi:17}



static void Test_BFu17ll_Ui_BFu17i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu17i");
    static STRUCT_IF_C BFu17ll_Ui_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu17i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu17ll_Ui_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu17i, BFu17ll_Ui_BFu17i)
//============================================================================


struct  BFu17ll_Ui_BFu17ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_Ui_BFu17ll) C1{ FL:17 Fi FL:17}



static void Test_BFu17ll_Ui_BFu17ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu17ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu17ll_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu17ll, BFu17ll_Ui_BFu17ll)
//============================================================================


struct  BFu17ll_Ui_BFu1c  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_Ui_BFu1c) C1{ FL:17 Fi Fc:1}



static void Test_BFu17ll_Ui_BFu1c()
{
  {
    init_simple_test("BFu17ll_Ui_BFu1c");
    static STRUCT_IF_C BFu17ll_Ui_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu1c");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu1c, BFu17ll_Ui_BFu1c)
//============================================================================


struct  BFu17ll_Ui_BFu1i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_Ui_BFu1i) C1{ FL:17 Fi Fi:1}



static void Test_BFu17ll_Ui_BFu1i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu1i");
    static STRUCT_IF_C BFu17ll_Ui_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu1i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu1i, BFu17ll_Ui_BFu1i)
//============================================================================


struct  BFu17ll_Ui_BFu1ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_Ui_BFu1ll) C1{ FL:17 Fi FL:1}



static void Test_BFu17ll_Ui_BFu1ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu1ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu1ll, BFu17ll_Ui_BFu1ll)
//============================================================================


struct  BFu17ll_Ui_BFu1s  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_Ui_BFu1s) C1{ FL:17 Fi Fs:1}



static void Test_BFu17ll_Ui_BFu1s()
{
  {
    init_simple_test("BFu17ll_Ui_BFu1s");
    static STRUCT_IF_C BFu17ll_Ui_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu1s");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu17ll_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu1s, BFu17ll_Ui_BFu1s)
//============================================================================


struct  BFu17ll_Ui_BFu31i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_Ui_BFu31i) C1{ FL:17 Fi Fi:31}



static void Test_BFu17ll_Ui_BFu31i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu31i");
    static STRUCT_IF_C BFu17ll_Ui_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu31i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu17ll_Ui_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu17ll_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu31i, BFu17ll_Ui_BFu31i)
//============================================================================


struct  BFu17ll_Ui_BFu31ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_Ui_BFu31ll) C1{ FL:17 Fi FL:31}



static void Test_BFu17ll_Ui_BFu31ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu31ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu17ll_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu17ll_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu31ll, BFu17ll_Ui_BFu31ll)
//============================================================================


struct  BFu17ll_Ui_BFu32i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_Ui_BFu32i) C1{ FL:17 Fi Fi:32}



static void Test_BFu17ll_Ui_BFu32i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu32i");
    static STRUCT_IF_C BFu17ll_Ui_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu32i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu17ll_Ui_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu17ll_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu32i, BFu17ll_Ui_BFu32i)
//============================================================================


struct  BFu17ll_Ui_BFu32ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_Ui_BFu32ll) C1{ FL:17 Fi FL:32}



static void Test_BFu17ll_Ui_BFu32ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu32ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu17ll_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu17ll_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu32ll, BFu17ll_Ui_BFu32ll)
//============================================================================


struct  BFu17ll_Ui_BFu33  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_Ui_BFu33) C1{ FL:17 Fi FL:33}



static void Test_BFu17ll_Ui_BFu33()
{
  {
    init_simple_test("BFu17ll_Ui_BFu33");
    static STRUCT_IF_C BFu17ll_Ui_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_Ui_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu33");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "BFu17ll_Ui_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "BFu17ll_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu33, BFu17ll_Ui_BFu33)
//============================================================================


struct  BFu17ll_Ui_BFu7c  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_Ui_BFu7c) C1{ FL:17 Fi Fc:7}



static void Test_BFu17ll_Ui_BFu7c()
{
  {
    init_simple_test("BFu17ll_Ui_BFu7c");
    static STRUCT_IF_C BFu17ll_Ui_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu7c");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_Ui_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu7c, BFu17ll_Ui_BFu7c)
//============================================================================


struct  BFu17ll_Ui_BFu7i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_Ui_BFu7i) C1{ FL:17 Fi Fi:7}



static void Test_BFu17ll_Ui_BFu7i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu7i");
    static STRUCT_IF_C BFu17ll_Ui_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu7i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_Ui_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu7i, BFu17ll_Ui_BFu7i)
//============================================================================


struct  BFu17ll_Ui_BFu7ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_Ui_BFu7ll) C1{ FL:17 Fi FL:7}



static void Test_BFu17ll_Ui_BFu7ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu7ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu7ll, BFu17ll_Ui_BFu7ll)
//============================================================================


struct  BFu17ll_Ui_BFu7s  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_Ui_BFu7s) C1{ FL:17 Fi Fs:7}



static void Test_BFu17ll_Ui_BFu7s()
{
  {
    init_simple_test("BFu17ll_Ui_BFu7s");
    static STRUCT_IF_C BFu17ll_Ui_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu7s");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu17ll_Ui_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu17ll_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu7s, BFu17ll_Ui_BFu7s)
//============================================================================


struct  BFu17ll_Ui_BFu8c  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_Ui_BFu8c) C1{ FL:17 Fi Fc:8}



static void Test_BFu17ll_Ui_BFu8c()
{
  {
    init_simple_test("BFu17ll_Ui_BFu8c");
    static STRUCT_IF_C BFu17ll_Ui_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu8c");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_Ui_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu8c, BFu17ll_Ui_BFu8c)
//============================================================================


struct  BFu17ll_Ui_BFu8i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_Ui_BFu8i) C1{ FL:17 Fi Fi:8}



static void Test_BFu17ll_Ui_BFu8i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu8i");
    static STRUCT_IF_C BFu17ll_Ui_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu8i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_Ui_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu8i, BFu17ll_Ui_BFu8i)
//============================================================================


struct  BFu17ll_Ui_BFu8ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_Ui_BFu8ll) C1{ FL:17 Fi FL:8}



static void Test_BFu17ll_Ui_BFu8ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu8ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu8ll, BFu17ll_Ui_BFu8ll)
//============================================================================


struct  BFu17ll_Ui_BFu8s  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_Ui_BFu8s) C1{ FL:17 Fi Fs:8}



static void Test_BFu17ll_Ui_BFu8s()
{
  {
    init_simple_test("BFu17ll_Ui_BFu8s");
    static STRUCT_IF_C BFu17ll_Ui_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu8s");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu17ll_Ui_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu17ll_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu8s, BFu17ll_Ui_BFu8s)
//============================================================================


struct  BFu17ll_Ui_BFu9i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_Ui_BFu9i) C1{ FL:17 Fi Fi:9}



static void Test_BFu17ll_Ui_BFu9i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu9i");
    static STRUCT_IF_C BFu17ll_Ui_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu9i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_Ui_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu9i, BFu17ll_Ui_BFu9i)
//============================================================================


struct  BFu17ll_Ui_BFu9ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_Ui_BFu9ll) C1{ FL:17 Fi FL:9}



static void Test_BFu17ll_Ui_BFu9ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu9ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu9ll, BFu17ll_Ui_BFu9ll)
//============================================================================


struct  BFu17ll_Ui_BFu9s  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_Ui_BFu9s) C1{ FL:17 Fi Fs:9}



static void Test_BFu17ll_Ui_BFu9s()
{
  {
    init_simple_test("BFu17ll_Ui_BFu9s");
    static STRUCT_IF_C BFu17ll_Ui_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu9s");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu17ll_Ui_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu17ll_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu9s, BFu17ll_Ui_BFu9s)
//============================================================================


struct  BFu17ll_Ui_C  {
  __tsu64 v1:17;
  unsigned int v2;
  char v3;
};
//SIG(1 BFu17ll_Ui_C) C1{ FL:17 Fi Fc}



static void Test_BFu17ll_Ui_C()
{
  {
    init_simple_test("BFu17ll_Ui_C");
    static STRUCT_IF_C BFu17ll_Ui_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_C");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_C.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_C, BFu17ll_Ui_C)
//============================================================================


struct  BFu17ll_Ui_D  {
  __tsu64 v1:17;
  unsigned int v2;
  double v3;
};
//SIG(1 BFu17ll_Ui_D) C1{ FL:17 Fi FL}



static void Test_BFu17ll_Ui_D()
{
  {
    init_simple_test("BFu17ll_Ui_D");
    static STRUCT_IF_C BFu17ll_Ui_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_Ui_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_D");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_D.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_D, BFu17ll_Ui_D)
//============================================================================


struct  BFu17ll_Ui_F  {
  __tsu64 v1:17;
  unsigned int v2;
  float v3;
};
//SIG(1 BFu17ll_Ui_F) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_Ui_F()
{
  {
    init_simple_test("BFu17ll_Ui_F");
    static STRUCT_IF_C BFu17ll_Ui_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_F");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_F.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_F, BFu17ll_Ui_F)
//============================================================================


struct  BFu17ll_Ui_I  {
  __tsu64 v1:17;
  unsigned int v2;
  int v3;
};
//SIG(1 BFu17ll_Ui_I) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_Ui_I()
{
  {
    init_simple_test("BFu17ll_Ui_I");
    static STRUCT_IF_C BFu17ll_Ui_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_I");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_I.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_I, BFu17ll_Ui_I)
//============================================================================


struct  BFu17ll_Ui_Ip  {
  __tsu64 v1:17;
  unsigned int v2;
  int *v3;
};
//SIG(1 BFu17ll_Ui_Ip) C1{ FL:17 Fi Fp}



static void Test_BFu17ll_Ui_Ip()
{
  {
    init_simple_test("BFu17ll_Ui_Ip");
    static STRUCT_IF_C BFu17ll_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_Ip");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_Ip, BFu17ll_Ui_Ip)
//============================================================================


struct  BFu17ll_Ui_L  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_Ui_L) C1{ FL:17 Fi FL}



static void Test_BFu17ll_Ui_L()
{
  {
    init_simple_test("BFu17ll_Ui_L");
    static STRUCT_IF_C BFu17ll_Ui_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_Ui_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_L");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_L.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_L, BFu17ll_Ui_L)
//============================================================================


struct  BFu17ll_Ui_S  {
  __tsu64 v1:17;
  unsigned int v2;
  short v3;
};
//SIG(1 BFu17ll_Ui_S) C1{ FL:17 Fi Fs}



static void Test_BFu17ll_Ui_S()
{
  {
    init_simple_test("BFu17ll_Ui_S");
    static STRUCT_IF_C BFu17ll_Ui_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_S");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_S.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_S, BFu17ll_Ui_S)
//============================================================================


struct  BFu17ll_Ui_Uc  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_Ui_Uc) C1{ FL:17 Fi Fc}



static void Test_BFu17ll_Ui_Uc()
{
  {
    init_simple_test("BFu17ll_Ui_Uc");
    static STRUCT_IF_C BFu17ll_Ui_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_Uc");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_Uc.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_Uc, BFu17ll_Ui_Uc)
//============================================================================


struct  BFu17ll_Ui_Ui  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_Ui_Ui) C1{ FL:17 Fi[2]}



static void Test_BFu17ll_Ui_Ui()
{
  {
    init_simple_test("BFu17ll_Ui_Ui");
    static STRUCT_IF_C BFu17ll_Ui_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_Ui");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_Ui, BFu17ll_Ui_Ui)
//============================================================================


struct  BFu17ll_Ui_Ul  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_Ui_Ul) C1{ FL:17 Fi FL}



static void Test_BFu17ll_Ui_Ul()
{
  {
    init_simple_test("BFu17ll_Ui_Ul");
    static STRUCT_IF_C BFu17ll_Ui_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_Ui_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_Ul");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_Ul, BFu17ll_Ui_Ul)
//============================================================================


struct  BFu17ll_Ui_Us  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_Ui_Us) C1{ FL:17 Fi Fs}



static void Test_BFu17ll_Ui_Us()
{
  {
    init_simple_test("BFu17ll_Ui_Us");
    static STRUCT_IF_C BFu17ll_Ui_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_Us");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_Us.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_Us, BFu17ll_Ui_Us)
//============================================================================


struct  BFu17ll_Ui_Vp  {
  __tsu64 v1:17;
  unsigned int v2;
  void *v3;
};
//SIG(1 BFu17ll_Ui_Vp) C1{ FL:17 Fi Fp}



static void Test_BFu17ll_Ui_Vp()
{
  {
    init_simple_test("BFu17ll_Ui_Vp");
    static STRUCT_IF_C BFu17ll_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_Vp");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_Vp, BFu17ll_Ui_Vp)
//============================================================================


struct  BFu17ll_Ul  {
  __tsu64 v1:17;
  __tsu64 v2;
};
//SIG(1 BFu17ll_Ul) C1{ FL:17 FL}



static void Test_BFu17ll_Ul()
{
  {
    init_simple_test("BFu17ll_Ul");
    static STRUCT_IF_C BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul, BFu17ll_Ul)
//============================================================================


struct  BFu17ll_Ul_BFu15i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_Ul_BFu15i) C1{ FL:17 FL Fi:15}



static void Test_BFu17ll_Ul_BFu15i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu15i");
    static STRUCT_IF_C BFu17ll_Ul_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu15i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_Ul_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu15i, BFu17ll_Ul_BFu15i)
//============================================================================


struct  BFu17ll_Ul_BFu15ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_Ul_BFu15ll) C1{ FL:17 FL FL:15}



static void Test_BFu17ll_Ul_BFu15ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu15ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu15ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_Ul_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu15ll, BFu17ll_Ul_BFu15ll)
//============================================================================


struct  BFu17ll_Ul_BFu15s  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_Ul_BFu15s) C1{ FL:17 FL Fs:15}



static void Test_BFu17ll_Ul_BFu15s()
{
  {
    init_simple_test("BFu17ll_Ul_BFu15s");
    static STRUCT_IF_C BFu17ll_Ul_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu15s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "BFu17ll_Ul_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "BFu17ll_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu15s, BFu17ll_Ul_BFu15s)
//============================================================================


struct  BFu17ll_Ul_BFu16i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_Ul_BFu16i) C1{ FL:17 FL Fi:16}



static void Test_BFu17ll_Ul_BFu16i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu16i");
    static STRUCT_IF_C BFu17ll_Ul_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu16i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_Ul_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu16i, BFu17ll_Ul_BFu16i)
//============================================================================


struct  BFu17ll_Ul_BFu16ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_Ul_BFu16ll) C1{ FL:17 FL FL:16}



static void Test_BFu17ll_Ul_BFu16ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu16ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu16ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_Ul_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu16ll, BFu17ll_Ul_BFu16ll)
//============================================================================


struct  BFu17ll_Ul_BFu16s  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_Ul_BFu16s) C1{ FL:17 FL Fs:16}



static void Test_BFu17ll_Ul_BFu16s()
{
  {
    init_simple_test("BFu17ll_Ul_BFu16s");
    static STRUCT_IF_C BFu17ll_Ul_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu16s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "BFu17ll_Ul_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "BFu17ll_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu16s, BFu17ll_Ul_BFu16s)
//============================================================================


struct  BFu17ll_Ul_BFu17i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_Ul_BFu17i) C1{ FL:17 FL Fi:17}



static void Test_BFu17ll_Ul_BFu17i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu17i");
    static STRUCT_IF_C BFu17ll_Ul_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu17i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu17ll_Ul_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu17i, BFu17ll_Ul_BFu17i)
//============================================================================


struct  BFu17ll_Ul_BFu17ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_Ul_BFu17ll) C1{ FL:17 FL FL:17}



static void Test_BFu17ll_Ul_BFu17ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu17ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu17ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "BFu17ll_Ul_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu17ll, BFu17ll_Ul_BFu17ll)
//============================================================================


struct  BFu17ll_Ul_BFu1c  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_Ul_BFu1c) C1{ FL:17 FL Fc:1}



static void Test_BFu17ll_Ul_BFu1c()
{
  {
    init_simple_test("BFu17ll_Ul_BFu1c");
    static STRUCT_IF_C BFu17ll_Ul_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu1c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu1c, BFu17ll_Ul_BFu1c)
//============================================================================


struct  BFu17ll_Ul_BFu1i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_Ul_BFu1i) C1{ FL:17 FL Fi:1}



static void Test_BFu17ll_Ul_BFu1i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu1i");
    static STRUCT_IF_C BFu17ll_Ul_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu1i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu1i, BFu17ll_Ul_BFu1i)
//============================================================================


struct  BFu17ll_Ul_BFu1ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_Ul_BFu1ll) C1{ FL:17 FL FL:1}



static void Test_BFu17ll_Ul_BFu1ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu1ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu1ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu1ll, BFu17ll_Ul_BFu1ll)
//============================================================================


struct  BFu17ll_Ul_BFu1s  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_Ul_BFu1s) C1{ FL:17 FL Fs:1}



static void Test_BFu17ll_Ul_BFu1s()
{
  {
    init_simple_test("BFu17ll_Ul_BFu1s");
    static STRUCT_IF_C BFu17ll_Ul_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu1s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "BFu17ll_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu1s, BFu17ll_Ul_BFu1s)
//============================================================================


struct  BFu17ll_Ul_BFu31i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_Ul_BFu31i) C1{ FL:17 FL Fi:31}



static void Test_BFu17ll_Ul_BFu31i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu31i");
    static STRUCT_IF_C BFu17ll_Ul_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu31i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu17ll_Ul_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu17ll_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu31i, BFu17ll_Ul_BFu31i)
//============================================================================


struct  BFu17ll_Ul_BFu31ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_Ul_BFu31ll) C1{ FL:17 FL FL:31}



static void Test_BFu17ll_Ul_BFu31ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu31ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu31ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "BFu17ll_Ul_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "BFu17ll_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu31ll, BFu17ll_Ul_BFu31ll)
//============================================================================


struct  BFu17ll_Ul_BFu32i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_Ul_BFu32i) C1{ FL:17 FL Fi:32}



static void Test_BFu17ll_Ul_BFu32i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu32i");
    static STRUCT_IF_C BFu17ll_Ul_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu32i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu17ll_Ul_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu17ll_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu32i, BFu17ll_Ul_BFu32i)
//============================================================================


struct  BFu17ll_Ul_BFu32ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_Ul_BFu32ll) C1{ FL:17 FL FL:32}



static void Test_BFu17ll_Ul_BFu32ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu32ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu32ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "BFu17ll_Ul_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "BFu17ll_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu32ll, BFu17ll_Ul_BFu32ll)
//============================================================================


struct  BFu17ll_Ul_BFu33  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_Ul_BFu33) C1{ FL:17 FL FL:33}



static void Test_BFu17ll_Ul_BFu33()
{
  {
    init_simple_test("BFu17ll_Ul_BFu33");
    static STRUCT_IF_C BFu17ll_Ul_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_Ul_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu33");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "BFu17ll_Ul_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "BFu17ll_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu33, BFu17ll_Ul_BFu33)
//============================================================================


struct  BFu17ll_Ul_BFu7c  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_Ul_BFu7c) C1{ FL:17 FL Fc:7}



static void Test_BFu17ll_Ul_BFu7c()
{
  {
    init_simple_test("BFu17ll_Ul_BFu7c");
    static STRUCT_IF_C BFu17ll_Ul_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu7c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_Ul_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu7c, BFu17ll_Ul_BFu7c)
//============================================================================


struct  BFu17ll_Ul_BFu7i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_Ul_BFu7i) C1{ FL:17 FL Fi:7}



static void Test_BFu17ll_Ul_BFu7i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu7i");
    static STRUCT_IF_C BFu17ll_Ul_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu7i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_Ul_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu7i, BFu17ll_Ul_BFu7i)
//============================================================================


struct  BFu17ll_Ul_BFu7ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_Ul_BFu7ll) C1{ FL:17 FL FL:7}



static void Test_BFu17ll_Ul_BFu7ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu7ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu7ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_Ul_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu7ll, BFu17ll_Ul_BFu7ll)
//============================================================================


struct  BFu17ll_Ul_BFu7s  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_Ul_BFu7s) C1{ FL:17 FL Fs:7}



static void Test_BFu17ll_Ul_BFu7s()
{
  {
    init_simple_test("BFu17ll_Ul_BFu7s");
    static STRUCT_IF_C BFu17ll_Ul_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu7s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "BFu17ll_Ul_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "BFu17ll_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu7s, BFu17ll_Ul_BFu7s)
//============================================================================


struct  BFu17ll_Ul_BFu8c  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_Ul_BFu8c) C1{ FL:17 FL Fc:8}



static void Test_BFu17ll_Ul_BFu8c()
{
  {
    init_simple_test("BFu17ll_Ul_BFu8c");
    static STRUCT_IF_C BFu17ll_Ul_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu8c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_Ul_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu8c, BFu17ll_Ul_BFu8c)
//============================================================================


struct  BFu17ll_Ul_BFu8i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_Ul_BFu8i) C1{ FL:17 FL Fi:8}



static void Test_BFu17ll_Ul_BFu8i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu8i");
    static STRUCT_IF_C BFu17ll_Ul_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu8i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_Ul_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu8i, BFu17ll_Ul_BFu8i)
//============================================================================


struct  BFu17ll_Ul_BFu8ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_Ul_BFu8ll) C1{ FL:17 FL FL:8}



static void Test_BFu17ll_Ul_BFu8ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu8ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu8ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_Ul_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu8ll, BFu17ll_Ul_BFu8ll)
//============================================================================


struct  BFu17ll_Ul_BFu8s  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_Ul_BFu8s) C1{ FL:17 FL Fs:8}



static void Test_BFu17ll_Ul_BFu8s()
{
  {
    init_simple_test("BFu17ll_Ul_BFu8s");
    static STRUCT_IF_C BFu17ll_Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu8s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "BFu17ll_Ul_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "BFu17ll_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu8s, BFu17ll_Ul_BFu8s)
//============================================================================


struct  BFu17ll_Ul_BFu9i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_Ul_BFu9i) C1{ FL:17 FL Fi:9}



static void Test_BFu17ll_Ul_BFu9i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu9i");
    static STRUCT_IF_C BFu17ll_Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu9i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_Ul_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu9i, BFu17ll_Ul_BFu9i)
//============================================================================


struct  BFu17ll_Ul_BFu9ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_Ul_BFu9ll) C1{ FL:17 FL FL:9}



static void Test_BFu17ll_Ul_BFu9ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu9ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu9ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_Ul_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu9ll, BFu17ll_Ul_BFu9ll)
//============================================================================


struct  BFu17ll_Ul_BFu9s  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_Ul_BFu9s) C1{ FL:17 FL Fs:9}



static void Test_BFu17ll_Ul_BFu9s()
{
  {
    init_simple_test("BFu17ll_Ul_BFu9s");
    static STRUCT_IF_C BFu17ll_Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu9s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "BFu17ll_Ul_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "BFu17ll_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu9s, BFu17ll_Ul_BFu9s)
//============================================================================


struct  BFu17ll_Ul_C  {
  __tsu64 v1:17;
  __tsu64 v2;
  char v3;
};
//SIG(1 BFu17ll_Ul_C) C1{ FL:17 FL Fc}



static void Test_BFu17ll_Ul_C()
{
  {
    init_simple_test("BFu17ll_Ul_C");
    static STRUCT_IF_C BFu17ll_Ul_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_C, BFu17ll_Ul_C)
//============================================================================


struct  BFu17ll_Ul_D  {
  __tsu64 v1:17;
  __tsu64 v2;
  double v3;
};
//SIG(1 BFu17ll_Ul_D) C1{ FL:17 FL[2]}



static void Test_BFu17ll_Ul_D()
{
  {
    init_simple_test("BFu17ll_Ul_D");
    static STRUCT_IF_C BFu17ll_Ul_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_Ul_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_D, BFu17ll_Ul_D)
//============================================================================


struct  BFu17ll_Ul_F  {
  __tsu64 v1:17;
  __tsu64 v2;
  float v3;
};
//SIG(1 BFu17ll_Ul_F) C1{ FL:17 FL Fi}



static void Test_BFu17ll_Ul_F()
{
  {
    init_simple_test("BFu17ll_Ul_F");
    static STRUCT_IF_C BFu17ll_Ul_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_F, BFu17ll_Ul_F)
//============================================================================


struct  BFu17ll_Ul_I  {
  __tsu64 v1:17;
  __tsu64 v2;
  int v3;
};
//SIG(1 BFu17ll_Ul_I) C1{ FL:17 FL Fi}



static void Test_BFu17ll_Ul_I()
{
  {
    init_simple_test("BFu17ll_Ul_I");
    static STRUCT_IF_C BFu17ll_Ul_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_I, BFu17ll_Ul_I)
//============================================================================


struct  BFu17ll_Ul_Ip  {
  __tsu64 v1:17;
  __tsu64 v2;
  int *v3;
};
//SIG(1 BFu17ll_Ul_Ip) C1{ FL:17 FL Fp}



static void Test_BFu17ll_Ul_Ip()
{
  {
    init_simple_test("BFu17ll_Ul_Ip");
    static STRUCT_IF_C BFu17ll_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_Ip, BFu17ll_Ul_Ip)
//============================================================================


struct  BFu17ll_Ul_L  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_Ul_L) C1{ FL:17 FL[2]}



static void Test_BFu17ll_Ul_L()
{
  {
    init_simple_test("BFu17ll_Ul_L");
    static STRUCT_IF_C BFu17ll_Ul_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_Ul_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_L, BFu17ll_Ul_L)
//============================================================================


struct  BFu17ll_Ul_S  {
  __tsu64 v1:17;
  __tsu64 v2;
  short v3;
};
//SIG(1 BFu17ll_Ul_S) C1{ FL:17 FL Fs}



static void Test_BFu17ll_Ul_S()
{
  {
    init_simple_test("BFu17ll_Ul_S");
    static STRUCT_IF_C BFu17ll_Ul_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_S, BFu17ll_Ul_S)
//============================================================================


struct  BFu17ll_Ul_Uc  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_Ul_Uc) C1{ FL:17 FL Fc}



static void Test_BFu17ll_Ul_Uc()
{
  {
    init_simple_test("BFu17ll_Ul_Uc");
    static STRUCT_IF_C BFu17ll_Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_Uc, BFu17ll_Ul_Uc)
//============================================================================


struct  BFu17ll_Ul_Ui  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_Ul_Ui) C1{ FL:17 FL Fi}



static void Test_BFu17ll_Ul_Ui()
{
  {
    init_simple_test("BFu17ll_Ul_Ui");
    static STRUCT_IF_C BFu17ll_Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_Ui, BFu17ll_Ul_Ui)
//============================================================================


struct  BFu17ll_Ul_Ul  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_Ul_Ul) C1{ FL:17 FL[2]}



static void Test_BFu17ll_Ul_Ul()
{
  {
    init_simple_test("BFu17ll_Ul_Ul");
    static STRUCT_IF_C BFu17ll_Ul_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu17ll_Ul_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_Ul, BFu17ll_Ul_Ul)
//============================================================================


struct  BFu17ll_Ul_Us  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_Ul_Us) C1{ FL:17 FL Fs}



static void Test_BFu17ll_Ul_Us()
{
  {
    init_simple_test("BFu17ll_Ul_Us");
    static STRUCT_IF_C BFu17ll_Ul_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_Us, BFu17ll_Ul_Us)
//============================================================================


struct  BFu17ll_Ul_Vp  {
  __tsu64 v1:17;
  __tsu64 v2;
  void *v3;
};
//SIG(1 BFu17ll_Ul_Vp) C1{ FL:17 FL Fp}



static void Test_BFu17ll_Ul_Vp()
{
  {
    init_simple_test("BFu17ll_Ul_Vp");
    static STRUCT_IF_C BFu17ll_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_Vp, BFu17ll_Ul_Vp)
//============================================================================


struct  BFu17ll_Us  {
  __tsu64 v1:17;
  unsigned short v2;
};
//SIG(1 BFu17ll_Us) C1{ FL:17 Fs}



static void Test_BFu17ll_Us()
{
  {
    init_simple_test("BFu17ll_Us");
    static STRUCT_IF_C BFu17ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us");
    check_field_offset(lv, v2, 4, "BFu17ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us, BFu17ll_Us)
//============================================================================


struct  BFu17ll_Us_BFu15i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_Us_BFu15i) C1{ FL:17 Fs Fi:15}



static void Test_BFu17ll_Us_BFu15i()
{
  {
    init_simple_test("BFu17ll_Us_BFu15i");
    static STRUCT_IF_C BFu17ll_Us_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu15i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu17ll_Us_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu17ll_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu15i, BFu17ll_Us_BFu15i)
//============================================================================


struct  BFu17ll_Us_BFu15ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_Us_BFu15ll) C1{ FL:17 Fs FL:15}



static void Test_BFu17ll_Us_BFu15ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu15ll");
    static STRUCT_IF_C BFu17ll_Us_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu17ll_Us_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu17ll_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu15ll, BFu17ll_Us_BFu15ll)
//============================================================================


struct  BFu17ll_Us_BFu15s  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_Us_BFu15s) C1{ FL:17 Fs Fs:15}



static void Test_BFu17ll_Us_BFu15s()
{
  {
    init_simple_test("BFu17ll_Us_BFu15s");
    static STRUCT_IF_C BFu17ll_Us_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu15s");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu17ll_Us_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu17ll_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu15s, BFu17ll_Us_BFu15s)
//============================================================================


struct  BFu17ll_Us_BFu16i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_Us_BFu16i) C1{ FL:17 Fs Fi:16}



static void Test_BFu17ll_Us_BFu16i()
{
  {
    init_simple_test("BFu17ll_Us_BFu16i");
    static STRUCT_IF_C BFu17ll_Us_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu16i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu17ll_Us_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu17ll_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu16i, BFu17ll_Us_BFu16i)
//============================================================================


struct  BFu17ll_Us_BFu16ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_Us_BFu16ll) C1{ FL:17 Fs FL:16}



static void Test_BFu17ll_Us_BFu16ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu16ll");
    static STRUCT_IF_C BFu17ll_Us_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu17ll_Us_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu17ll_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu16ll, BFu17ll_Us_BFu16ll)
//============================================================================


struct  BFu17ll_Us_BFu16s  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_Us_BFu16s) C1{ FL:17 Fs Fs:16}



static void Test_BFu17ll_Us_BFu16s()
{
  {
    init_simple_test("BFu17ll_Us_BFu16s");
    static STRUCT_IF_C BFu17ll_Us_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu16s");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu17ll_Us_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu17ll_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu16s, BFu17ll_Us_BFu16s)
//============================================================================


struct  BFu17ll_Us_BFu17i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_Us_BFu17i) C1{ FL:17 Fs Fi:17}



static void Test_BFu17ll_Us_BFu17i()
{
  {
    init_simple_test("BFu17ll_Us_BFu17i");
    static STRUCT_IF_C BFu17ll_Us_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu17i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu17ll_Us_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu17i, BFu17ll_Us_BFu17i)
//============================================================================


struct  BFu17ll_Us_BFu17ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_Us_BFu17ll) C1{ FL:17 Fs FL:17}



static void Test_BFu17ll_Us_BFu17ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu17ll");
    static STRUCT_IF_C BFu17ll_Us_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "BFu17ll_Us_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu17ll, BFu17ll_Us_BFu17ll)
//============================================================================


struct  BFu17ll_Us_BFu1c  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_Us_BFu1c) C1{ FL:17 Fs Fc:1}



static void Test_BFu17ll_Us_BFu1c()
{
  {
    init_simple_test("BFu17ll_Us_BFu1c");
    static STRUCT_IF_C BFu17ll_Us_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu1c");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu17ll_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu1c, BFu17ll_Us_BFu1c)
//============================================================================


struct  BFu17ll_Us_BFu1i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_Us_BFu1i) C1{ FL:17 Fs Fi:1}



static void Test_BFu17ll_Us_BFu1i()
{
  {
    init_simple_test("BFu17ll_Us_BFu1i");
    static STRUCT_IF_C BFu17ll_Us_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu1i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu17ll_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu1i, BFu17ll_Us_BFu1i)
//============================================================================


struct  BFu17ll_Us_BFu1ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_Us_BFu1ll) C1{ FL:17 Fs FL:1}



static void Test_BFu17ll_Us_BFu1ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu1ll");
    static STRUCT_IF_C BFu17ll_Us_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu17ll_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu1ll, BFu17ll_Us_BFu1ll)
//============================================================================


struct  BFu17ll_Us_BFu1s  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_Us_BFu1s) C1{ FL:17 Fs Fs:1}



static void Test_BFu17ll_Us_BFu1s()
{
  {
    init_simple_test("BFu17ll_Us_BFu1s");
    static STRUCT_IF_C BFu17ll_Us_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu1s");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu17ll_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu1s, BFu17ll_Us_BFu1s)
//============================================================================


struct  BFu17ll_Us_BFu31i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_Us_BFu31i) C1{ FL:17 Fs Fi:31}



static void Test_BFu17ll_Us_BFu31i()
{
  {
    init_simple_test("BFu17ll_Us_BFu31i");
    static STRUCT_IF_C BFu17ll_Us_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu31i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu17ll_Us_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu17ll_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu31i, BFu17ll_Us_BFu31i)
//============================================================================


struct  BFu17ll_Us_BFu31ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_Us_BFu31ll) C1{ FL:17 Fs FL:31}



static void Test_BFu17ll_Us_BFu31ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu31ll");
    static STRUCT_IF_C BFu17ll_Us_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "BFu17ll_Us_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "BFu17ll_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu31ll, BFu17ll_Us_BFu31ll)
//============================================================================


struct  BFu17ll_Us_BFu32i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_Us_BFu32i) C1{ FL:17 Fs Fi:32}



static void Test_BFu17ll_Us_BFu32i()
{
  {
    init_simple_test("BFu17ll_Us_BFu32i");
    static STRUCT_IF_C BFu17ll_Us_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu32i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu17ll_Us_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu17ll_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu32i, BFu17ll_Us_BFu32i)
//============================================================================


struct  BFu17ll_Us_BFu32ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_Us_BFu32ll) C1{ FL:17 Fs FL:32}



static void Test_BFu17ll_Us_BFu32ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu32ll");
    static STRUCT_IF_C BFu17ll_Us_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "BFu17ll_Us_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "BFu17ll_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu32ll, BFu17ll_Us_BFu32ll)
//============================================================================


struct  BFu17ll_Us_BFu33  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_Us_BFu33) C1{ FL:17 Fs FL:33}



static void Test_BFu17ll_Us_BFu33()
{
  {
    init_simple_test("BFu17ll_Us_BFu33");
    static STRUCT_IF_C BFu17ll_Us_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu33");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "BFu17ll_Us_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "BFu17ll_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu33, BFu17ll_Us_BFu33)
//============================================================================


struct  BFu17ll_Us_BFu7c  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_Us_BFu7c) C1{ FL:17 Fs Fc:7}



static void Test_BFu17ll_Us_BFu7c()
{
  {
    init_simple_test("BFu17ll_Us_BFu7c");
    static STRUCT_IF_C BFu17ll_Us_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu7c");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu17ll_Us_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu17ll_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu7c, BFu17ll_Us_BFu7c)
//============================================================================


struct  BFu17ll_Us_BFu7i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_Us_BFu7i) C1{ FL:17 Fs Fi:7}



static void Test_BFu17ll_Us_BFu7i()
{
  {
    init_simple_test("BFu17ll_Us_BFu7i");
    static STRUCT_IF_C BFu17ll_Us_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu7i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu17ll_Us_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu17ll_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu7i, BFu17ll_Us_BFu7i)
//============================================================================


struct  BFu17ll_Us_BFu7ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_Us_BFu7ll) C1{ FL:17 Fs FL:7}



static void Test_BFu17ll_Us_BFu7ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu7ll");
    static STRUCT_IF_C BFu17ll_Us_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu17ll_Us_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu17ll_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu7ll, BFu17ll_Us_BFu7ll)
//============================================================================


struct  BFu17ll_Us_BFu7s  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_Us_BFu7s) C1{ FL:17 Fs Fs:7}



static void Test_BFu17ll_Us_BFu7s()
{
  {
    init_simple_test("BFu17ll_Us_BFu7s");
    static STRUCT_IF_C BFu17ll_Us_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu7s");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu17ll_Us_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu17ll_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu7s, BFu17ll_Us_BFu7s)
//============================================================================


struct  BFu17ll_Us_BFu8c  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_Us_BFu8c) C1{ FL:17 Fs Fc:8}



static void Test_BFu17ll_Us_BFu8c()
{
  {
    init_simple_test("BFu17ll_Us_BFu8c");
    static STRUCT_IF_C BFu17ll_Us_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu8c");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu17ll_Us_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu17ll_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu8c, BFu17ll_Us_BFu8c)
//============================================================================


struct  BFu17ll_Us_BFu8i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_Us_BFu8i) C1{ FL:17 Fs Fi:8}



static void Test_BFu17ll_Us_BFu8i()
{
  {
    init_simple_test("BFu17ll_Us_BFu8i");
    static STRUCT_IF_C BFu17ll_Us_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu8i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu17ll_Us_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu17ll_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu8i, BFu17ll_Us_BFu8i)
//============================================================================


struct  BFu17ll_Us_BFu8ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_Us_BFu8ll) C1{ FL:17 Fs FL:8}



static void Test_BFu17ll_Us_BFu8ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu8ll");
    static STRUCT_IF_C BFu17ll_Us_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu17ll_Us_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu17ll_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu8ll, BFu17ll_Us_BFu8ll)
//============================================================================


struct  BFu17ll_Us_BFu8s  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_Us_BFu8s) C1{ FL:17 Fs Fs:8}



static void Test_BFu17ll_Us_BFu8s()
{
  {
    init_simple_test("BFu17ll_Us_BFu8s");
    static STRUCT_IF_C BFu17ll_Us_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu8s");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu17ll_Us_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu17ll_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu8s, BFu17ll_Us_BFu8s)
//============================================================================


struct  BFu17ll_Us_BFu9i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_Us_BFu9i) C1{ FL:17 Fs Fi:9}



static void Test_BFu17ll_Us_BFu9i()
{
  {
    init_simple_test("BFu17ll_Us_BFu9i");
    static STRUCT_IF_C BFu17ll_Us_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu9i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu17ll_Us_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu17ll_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu9i, BFu17ll_Us_BFu9i)
//============================================================================


struct  BFu17ll_Us_BFu9ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_Us_BFu9ll) C1{ FL:17 Fs FL:9}



static void Test_BFu17ll_Us_BFu9ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu9ll");
    static STRUCT_IF_C BFu17ll_Us_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu17ll_Us_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu17ll_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu9ll, BFu17ll_Us_BFu9ll)
//============================================================================


struct  BFu17ll_Us_BFu9s  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_Us_BFu9s) C1{ FL:17 Fs Fs:9}



static void Test_BFu17ll_Us_BFu9s()
{
  {
    init_simple_test("BFu17ll_Us_BFu9s");
    static STRUCT_IF_C BFu17ll_Us_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu9s");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu17ll_Us_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu17ll_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu9s, BFu17ll_Us_BFu9s)
//============================================================================


struct  BFu17ll_Us_C  {
  __tsu64 v1:17;
  unsigned short v2;
  char v3;
};
//SIG(1 BFu17ll_Us_C) C1{ FL:17 Fs Fc}



static void Test_BFu17ll_Us_C()
{
  {
    init_simple_test("BFu17ll_Us_C");
    static STRUCT_IF_C BFu17ll_Us_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_C");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_C.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_C, BFu17ll_Us_C)
//============================================================================


struct  BFu17ll_Us_D  {
  __tsu64 v1:17;
  unsigned short v2;
  double v3;
};
//SIG(1 BFu17ll_Us_D) C1{ FL:17 Fs FL}



static void Test_BFu17ll_Us_D()
{
  {
    init_simple_test("BFu17ll_Us_D");
    static STRUCT_IF_C BFu17ll_Us_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_Us_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_D");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_D.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_D, BFu17ll_Us_D)
//============================================================================


struct  BFu17ll_Us_F  {
  __tsu64 v1:17;
  unsigned short v2;
  float v3;
};
//SIG(1 BFu17ll_Us_F) C1{ FL:17 Fs Fi}



static void Test_BFu17ll_Us_F()
{
  {
    init_simple_test("BFu17ll_Us_F");
    static STRUCT_IF_C BFu17ll_Us_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_F");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_F.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_F, BFu17ll_Us_F)
//============================================================================


struct  BFu17ll_Us_I  {
  __tsu64 v1:17;
  unsigned short v2;
  int v3;
};
//SIG(1 BFu17ll_Us_I) C1{ FL:17 Fs Fi}



static void Test_BFu17ll_Us_I()
{
  {
    init_simple_test("BFu17ll_Us_I");
    static STRUCT_IF_C BFu17ll_Us_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_I");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_I.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_I, BFu17ll_Us_I)
//============================================================================


struct  BFu17ll_Us_Ip  {
  __tsu64 v1:17;
  unsigned short v2;
  int *v3;
};
//SIG(1 BFu17ll_Us_Ip) C1{ FL:17 Fs Fp}



static void Test_BFu17ll_Us_Ip()
{
  {
    init_simple_test("BFu17ll_Us_Ip");
    static STRUCT_IF_C BFu17ll_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_Ip");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_Ip, BFu17ll_Us_Ip)
//============================================================================


struct  BFu17ll_Us_L  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_Us_L) C1{ FL:17 Fs FL}



static void Test_BFu17ll_Us_L()
{
  {
    init_simple_test("BFu17ll_Us_L");
    static STRUCT_IF_C BFu17ll_Us_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_Us_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_L");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_L.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_L, BFu17ll_Us_L)
//============================================================================


struct  BFu17ll_Us_S  {
  __tsu64 v1:17;
  unsigned short v2;
  short v3;
};
//SIG(1 BFu17ll_Us_S) C1{ FL:17 Fs[2]}



static void Test_BFu17ll_Us_S()
{
  {
    init_simple_test("BFu17ll_Us_S");
    static STRUCT_IF_C BFu17ll_Us_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_S");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_S.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_S, BFu17ll_Us_S)
//============================================================================


struct  BFu17ll_Us_Uc  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_Us_Uc) C1{ FL:17 Fs Fc}



static void Test_BFu17ll_Us_Uc()
{
  {
    init_simple_test("BFu17ll_Us_Uc");
    static STRUCT_IF_C BFu17ll_Us_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_Uc");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_Uc.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_Uc, BFu17ll_Us_Uc)
//============================================================================


struct  BFu17ll_Us_Ui  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_Us_Ui) C1{ FL:17 Fs Fi}



static void Test_BFu17ll_Us_Ui()
{
  {
    init_simple_test("BFu17ll_Us_Ui");
    static STRUCT_IF_C BFu17ll_Us_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_Ui");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_Ui, BFu17ll_Us_Ui)
//============================================================================


struct  BFu17ll_Us_Ul  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_Us_Ul) C1{ FL:17 Fs FL}



static void Test_BFu17ll_Us_Ul()
{
  {
    init_simple_test("BFu17ll_Us_Ul");
    static STRUCT_IF_C BFu17ll_Us_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu17ll_Us_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_Ul");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_Ul, BFu17ll_Us_Ul)
//============================================================================


struct  BFu17ll_Us_Us  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_Us_Us) C1{ FL:17 Fs[2]}



static void Test_BFu17ll_Us_Us()
{
  {
    init_simple_test("BFu17ll_Us_Us");
    static STRUCT_IF_C BFu17ll_Us_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_Us");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_Us.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_Us, BFu17ll_Us_Us)
//============================================================================


struct  BFu17ll_Us_Vp  {
  __tsu64 v1:17;
  unsigned short v2;
  void *v3;
};
//SIG(1 BFu17ll_Us_Vp) C1{ FL:17 Fs Fp}



static void Test_BFu17ll_Us_Vp()
{
  {
    init_simple_test("BFu17ll_Us_Vp");
    static STRUCT_IF_C BFu17ll_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Us_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_Vp");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_Vp, BFu17ll_Us_Vp)
//============================================================================


struct  BFu17ll_Vp  {
  __tsu64 v1:17;
  void *v2;
};
//SIG(1 BFu17ll_Vp) C1{ FL:17 Fp}



static void Test_BFu17ll_Vp()
{
  {
    init_simple_test("BFu17ll_Vp");
    static STRUCT_IF_C BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp, BFu17ll_Vp)
//============================================================================


struct  BFu17ll_Vp_BFu15i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_Vp_BFu15i) C1{ FL:17 Fp Fi:15}



static void Test_BFu17ll_Vp_BFu15i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu15i");
    static STRUCT_IF_C BFu17ll_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu15i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu17ll_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu17ll_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu15i, BFu17ll_Vp_BFu15i)
//============================================================================


struct  BFu17ll_Vp_BFu15ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_Vp_BFu15ll) C1{ FL:17 Fp FL:15}



static void Test_BFu17ll_Vp_BFu15ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu15ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu15ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu17ll_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu17ll_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu15ll, BFu17ll_Vp_BFu15ll)
//============================================================================


struct  BFu17ll_Vp_BFu15s  {
  __tsu64 v1:17;
  void *v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_Vp_BFu15s) C1{ FL:17 Fp Fs:15}



static void Test_BFu17ll_Vp_BFu15s()
{
  {
    init_simple_test("BFu17ll_Vp_BFu15s");
    static STRUCT_IF_C BFu17ll_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu15s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "BFu17ll_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "BFu17ll_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu15s, BFu17ll_Vp_BFu15s)
//============================================================================


struct  BFu17ll_Vp_BFu16i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_Vp_BFu16i) C1{ FL:17 Fp Fi:16}



static void Test_BFu17ll_Vp_BFu16i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu16i");
    static STRUCT_IF_C BFu17ll_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu16i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu17ll_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu17ll_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu16i, BFu17ll_Vp_BFu16i)
//============================================================================


struct  BFu17ll_Vp_BFu16ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_Vp_BFu16ll) C1{ FL:17 Fp FL:16}



static void Test_BFu17ll_Vp_BFu16ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu16ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu16ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu17ll_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu17ll_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu16ll, BFu17ll_Vp_BFu16ll)
//============================================================================


struct  BFu17ll_Vp_BFu16s  {
  __tsu64 v1:17;
  void *v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_Vp_BFu16s) C1{ FL:17 Fp Fs:16}



static void Test_BFu17ll_Vp_BFu16s()
{
  {
    init_simple_test("BFu17ll_Vp_BFu16s");
    static STRUCT_IF_C BFu17ll_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu16s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "BFu17ll_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "BFu17ll_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu16s, BFu17ll_Vp_BFu16s)
//============================================================================


struct  BFu17ll_Vp_BFu17i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_Vp_BFu17i) C1{ FL:17 Fp Fi:17}



static void Test_BFu17ll_Vp_BFu17i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu17i");
    static STRUCT_IF_C BFu17ll_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu17i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "BFu17ll_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu17i, BFu17ll_Vp_BFu17i)
//============================================================================


struct  BFu17ll_Vp_BFu17ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_Vp_BFu17ll) C1{ FL:17 Fp FL:17}



static void Test_BFu17ll_Vp_BFu17ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu17ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu17ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "BFu17ll_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu17ll, BFu17ll_Vp_BFu17ll)
//============================================================================


struct  BFu17ll_Vp_BFu1c  {
  __tsu64 v1:17;
  void *v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_Vp_BFu1c) C1{ FL:17 Fp Fc:1}



static void Test_BFu17ll_Vp_BFu1c()
{
  {
    init_simple_test("BFu17ll_Vp_BFu1c");
    static STRUCT_IF_C BFu17ll_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu1c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu17ll_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu1c, BFu17ll_Vp_BFu1c)
//============================================================================


struct  BFu17ll_Vp_BFu1i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_Vp_BFu1i) C1{ FL:17 Fp Fi:1}



static void Test_BFu17ll_Vp_BFu1i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu1i");
    static STRUCT_IF_C BFu17ll_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu1i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu17ll_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu1i, BFu17ll_Vp_BFu1i)
//============================================================================


struct  BFu17ll_Vp_BFu1ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_Vp_BFu1ll) C1{ FL:17 Fp FL:1}



static void Test_BFu17ll_Vp_BFu1ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu1ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu1ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu17ll_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu1ll, BFu17ll_Vp_BFu1ll)
//============================================================================


struct  BFu17ll_Vp_BFu1s  {
  __tsu64 v1:17;
  void *v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_Vp_BFu1s) C1{ FL:17 Fp Fs:1}



static void Test_BFu17ll_Vp_BFu1s()
{
  {
    init_simple_test("BFu17ll_Vp_BFu1s");
    static STRUCT_IF_C BFu17ll_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu1s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "BFu17ll_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu1s, BFu17ll_Vp_BFu1s)
//============================================================================


struct  BFu17ll_Vp_BFu31i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_Vp_BFu31i) C1{ FL:17 Fp Fi:31}



static void Test_BFu17ll_Vp_BFu31i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu31i");
    static STRUCT_IF_C BFu17ll_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu31i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "BFu17ll_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "BFu17ll_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu31i, BFu17ll_Vp_BFu31i)
//============================================================================


struct  BFu17ll_Vp_BFu31ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_Vp_BFu31ll) C1{ FL:17 Fp FL:31}



static void Test_BFu17ll_Vp_BFu31ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu31ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu31ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "BFu17ll_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "BFu17ll_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu31ll, BFu17ll_Vp_BFu31ll)
//============================================================================


struct  BFu17ll_Vp_BFu32i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_Vp_BFu32i) C1{ FL:17 Fp Fi:32}



static void Test_BFu17ll_Vp_BFu32i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu32i");
    static STRUCT_IF_C BFu17ll_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu32i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "BFu17ll_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "BFu17ll_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu32i, BFu17ll_Vp_BFu32i)
//============================================================================


struct  BFu17ll_Vp_BFu32ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_Vp_BFu32ll) C1{ FL:17 Fp FL:32}



static void Test_BFu17ll_Vp_BFu32ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu32ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu32ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "BFu17ll_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "BFu17ll_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu32ll, BFu17ll_Vp_BFu32ll)
//============================================================================


struct  BFu17ll_Vp_BFu33  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_Vp_BFu33) C1{ FL:17 Fp FL:33}



static void Test_BFu17ll_Vp_BFu33()
{
  {
    init_simple_test("BFu17ll_Vp_BFu33");
    static STRUCT_IF_C BFu17ll_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Vp_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu33");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "BFu17ll_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "BFu17ll_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu33, BFu17ll_Vp_BFu33)
//============================================================================


struct  BFu17ll_Vp_BFu7c  {
  __tsu64 v1:17;
  void *v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_Vp_BFu7c) C1{ FL:17 Fp Fc:7}



static void Test_BFu17ll_Vp_BFu7c()
{
  {
    init_simple_test("BFu17ll_Vp_BFu7c");
    static STRUCT_IF_C BFu17ll_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu7c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu17ll_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu17ll_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu7c, BFu17ll_Vp_BFu7c)
//============================================================================


struct  BFu17ll_Vp_BFu7i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_Vp_BFu7i) C1{ FL:17 Fp Fi:7}



static void Test_BFu17ll_Vp_BFu7i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu7i");
    static STRUCT_IF_C BFu17ll_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu7i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu17ll_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu17ll_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu7i, BFu17ll_Vp_BFu7i)
//============================================================================


struct  BFu17ll_Vp_BFu7ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_Vp_BFu7ll) C1{ FL:17 Fp FL:7}



static void Test_BFu17ll_Vp_BFu7ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu7ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu7ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu17ll_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu17ll_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu7ll, BFu17ll_Vp_BFu7ll)
//============================================================================


struct  BFu17ll_Vp_BFu7s  {
  __tsu64 v1:17;
  void *v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_Vp_BFu7s) C1{ FL:17 Fp Fs:7}



static void Test_BFu17ll_Vp_BFu7s()
{
  {
    init_simple_test("BFu17ll_Vp_BFu7s");
    static STRUCT_IF_C BFu17ll_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu7s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "BFu17ll_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "BFu17ll_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu7s, BFu17ll_Vp_BFu7s)
//============================================================================


struct  BFu17ll_Vp_BFu8c  {
  __tsu64 v1:17;
  void *v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_Vp_BFu8c) C1{ FL:17 Fp Fc:8}



static void Test_BFu17ll_Vp_BFu8c()
{
  {
    init_simple_test("BFu17ll_Vp_BFu8c");
    static STRUCT_IF_C BFu17ll_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu8c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu17ll_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu17ll_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu8c, BFu17ll_Vp_BFu8c)
//============================================================================


struct  BFu17ll_Vp_BFu8i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_Vp_BFu8i) C1{ FL:17 Fp Fi:8}



static void Test_BFu17ll_Vp_BFu8i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu8i");
    static STRUCT_IF_C BFu17ll_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu8i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu17ll_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu17ll_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu8i, BFu17ll_Vp_BFu8i)
//============================================================================


struct  BFu17ll_Vp_BFu8ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_Vp_BFu8ll) C1{ FL:17 Fp FL:8}



static void Test_BFu17ll_Vp_BFu8ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu8ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu8ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu17ll_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu17ll_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu8ll, BFu17ll_Vp_BFu8ll)
//============================================================================


struct  BFu17ll_Vp_BFu8s  {
  __tsu64 v1:17;
  void *v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_Vp_BFu8s) C1{ FL:17 Fp Fs:8}



static void Test_BFu17ll_Vp_BFu8s()
{
  {
    init_simple_test("BFu17ll_Vp_BFu8s");
    static STRUCT_IF_C BFu17ll_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu8s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "BFu17ll_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "BFu17ll_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu8s, BFu17ll_Vp_BFu8s)
//============================================================================


struct  BFu17ll_Vp_BFu9i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_Vp_BFu9i) C1{ FL:17 Fp Fi:9}



static void Test_BFu17ll_Vp_BFu9i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu9i");
    static STRUCT_IF_C BFu17ll_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu9i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu17ll_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu17ll_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu9i, BFu17ll_Vp_BFu9i)
//============================================================================


struct  BFu17ll_Vp_BFu9ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_Vp_BFu9ll) C1{ FL:17 Fp FL:9}



static void Test_BFu17ll_Vp_BFu9ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu9ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu9ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu17ll_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu17ll_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu9ll, BFu17ll_Vp_BFu9ll)
//============================================================================


struct  BFu17ll_Vp_BFu9s  {
  __tsu64 v1:17;
  void *v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_Vp_BFu9s) C1{ FL:17 Fp Fs:9}



static void Test_BFu17ll_Vp_BFu9s()
{
  {
    init_simple_test("BFu17ll_Vp_BFu9s");
    static STRUCT_IF_C BFu17ll_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu9s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "BFu17ll_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "BFu17ll_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu9s, BFu17ll_Vp_BFu9s)
//============================================================================


struct  BFu17ll_Vp_C  {
  __tsu64 v1:17;
  void *v2;
  char v3;
};
//SIG(1 BFu17ll_Vp_C) C1{ FL:17 Fp Fc}



static void Test_BFu17ll_Vp_C()
{
  {
    init_simple_test("BFu17ll_Vp_C");
    static STRUCT_IF_C BFu17ll_Vp_C lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_C, BFu17ll_Vp_C)
//============================================================================


struct  BFu17ll_Vp_D  {
  __tsu64 v1:17;
  void *v2;
  double v3;
};
//SIG(1 BFu17ll_Vp_D) C1{ FL:17 Fp FL}



static void Test_BFu17ll_Vp_D()
{
  {
    init_simple_test("BFu17ll_Vp_D");
    static STRUCT_IF_C BFu17ll_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Vp_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_D, BFu17ll_Vp_D)
//============================================================================


struct  BFu17ll_Vp_F  {
  __tsu64 v1:17;
  void *v2;
  float v3;
};
//SIG(1 BFu17ll_Vp_F) C1{ FL:17 Fp Fi}



static void Test_BFu17ll_Vp_F()
{
  {
    init_simple_test("BFu17ll_Vp_F");
    static STRUCT_IF_C BFu17ll_Vp_F lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_F, BFu17ll_Vp_F)
//============================================================================


struct  BFu17ll_Vp_I  {
  __tsu64 v1:17;
  void *v2;
  int v3;
};
//SIG(1 BFu17ll_Vp_I) C1{ FL:17 Fp Fi}



static void Test_BFu17ll_Vp_I()
{
  {
    init_simple_test("BFu17ll_Vp_I");
    static STRUCT_IF_C BFu17ll_Vp_I lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_I, BFu17ll_Vp_I)
//============================================================================


struct  BFu17ll_Vp_Ip  {
  __tsu64 v1:17;
  void *v2;
  int *v3;
};
//SIG(1 BFu17ll_Vp_Ip) C1{ FL:17 Fp[2]}



static void Test_BFu17ll_Vp_Ip()
{
  {
    init_simple_test("BFu17ll_Vp_Ip");
    static STRUCT_IF_C BFu17ll_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_Ip, BFu17ll_Vp_Ip)
//============================================================================


struct  BFu17ll_Vp_L  {
  __tsu64 v1:17;
  void *v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_Vp_L) C1{ FL:17 Fp FL}



static void Test_BFu17ll_Vp_L()
{
  {
    init_simple_test("BFu17ll_Vp_L");
    static STRUCT_IF_C BFu17ll_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Vp_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_L, BFu17ll_Vp_L)
//============================================================================


struct  BFu17ll_Vp_S  {
  __tsu64 v1:17;
  void *v2;
  short v3;
};
//SIG(1 BFu17ll_Vp_S) C1{ FL:17 Fp Fs}



static void Test_BFu17ll_Vp_S()
{
  {
    init_simple_test("BFu17ll_Vp_S");
    static STRUCT_IF_C BFu17ll_Vp_S lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_S, BFu17ll_Vp_S)
//============================================================================


struct  BFu17ll_Vp_Uc  {
  __tsu64 v1:17;
  void *v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_Vp_Uc) C1{ FL:17 Fp Fc}



static void Test_BFu17ll_Vp_Uc()
{
  {
    init_simple_test("BFu17ll_Vp_Uc");
    static STRUCT_IF_C BFu17ll_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_Uc, BFu17ll_Vp_Uc)
//============================================================================


struct  BFu17ll_Vp_Ui  {
  __tsu64 v1:17;
  void *v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_Vp_Ui) C1{ FL:17 Fp Fi}



static void Test_BFu17ll_Vp_Ui()
{
  {
    init_simple_test("BFu17ll_Vp_Ui");
    static STRUCT_IF_C BFu17ll_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_Ui, BFu17ll_Vp_Ui)
//============================================================================


struct  BFu17ll_Vp_Ul  {
  __tsu64 v1:17;
  void *v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_Vp_Ul) C1{ FL:17 Fp FL}



static void Test_BFu17ll_Vp_Ul()
{
  {
    init_simple_test("BFu17ll_Vp_Ul");
    static STRUCT_IF_C BFu17ll_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Vp_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_Ul, BFu17ll_Vp_Ul)
//============================================================================


struct  BFu17ll_Vp_Us  {
  __tsu64 v1:17;
  void *v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_Vp_Us) C1{ FL:17 Fp Fs}



static void Test_BFu17ll_Vp_Us()
{
  {
    init_simple_test("BFu17ll_Vp_Us");
    static STRUCT_IF_C BFu17ll_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_Us, BFu17ll_Vp_Us)
//============================================================================


struct  BFu17ll_Vp_Vp  {
  __tsu64 v1:17;
  void *v2;
  void *v3;
};
//SIG(1 BFu17ll_Vp_Vp) C1{ FL:17 Fp[2]}



static void Test_BFu17ll_Vp_Vp()
{
  {
    init_simple_test("BFu17ll_Vp_Vp");
    static STRUCT_IF_C BFu17ll_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_Vp, BFu17ll_Vp_Vp)
//============================================================================


struct  BFu1c  {
  unsigned char v1:1;
};
//SIG(1 BFu1c) C1{ Fc:1}



static void Test_BFu1c()
{
  {
    init_simple_test("BFu1c");
    static STRUCT_IF_C BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c, BFu1c)
//============================================================================


struct  BFu1c_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
};
//SIG(1 BFu1c_BFs1c) C1{ Fc:1 Fc:1}



static void Test_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c, BFu1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c) C1{ Fc:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c, BFu1c_BFs1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1c_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c_BFs1c) C1{ Fc:1 Fc:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFs1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFs1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c_BFs1c, BFu1c_BFs1c_BFs1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1c_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c_BFs1i) C1{ Fc:1 Fc:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c_BFs1i, BFu1c_BFs1c_BFs1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1c_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c_BFs1ll) C1{ Fc:1 Fc:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c_BFs1ll, BFu1c_BFs1c_BFs1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1c_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c_BFs1s) C1{ Fc:1 Fc:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c_BFs1s, BFu1c_BFs1c_BFs1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFs1c_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c_BFu1c) C1{ Fc:1 Fc:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFs1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFs1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c_BFu1c, BFu1c_BFs1c_BFs1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1c_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c_BFu1i) C1{ Fc:1 Fc:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c_BFu1i, BFu1c_BFs1c_BFs1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1c_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c_BFu1ll) C1{ Fc:1 Fc:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c_BFu1ll, BFu1c_BFs1c_BFs1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1c_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1c_BFu1s) C1{ Fc:1 Fc:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1c_BFu1s, BFu1c_BFs1c_BFs1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1c_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i) C1{ Fc:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i, BFu1c_BFs1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1i_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i_BFs1c) C1{ Fc:1 Fc:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i_BFs1c, BFu1c_BFs1c_BFs1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1i_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i_BFs1i) C1{ Fc:1 Fc:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i_BFs1i, BFu1c_BFs1c_BFs1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1i_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i_BFs1ll) C1{ Fc:1 Fc:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i_BFs1ll, BFu1c_BFs1c_BFs1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1i_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i_BFs1s) C1{ Fc:1 Fc:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i_BFs1s, BFu1c_BFs1c_BFs1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFs1i_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i_BFu1c) C1{ Fc:1 Fc:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i_BFu1c, BFu1c_BFs1c_BFs1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1i_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i_BFu1i) C1{ Fc:1 Fc:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i_BFu1i, BFu1c_BFs1c_BFs1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1i_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i_BFu1ll) C1{ Fc:1 Fc:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i_BFu1ll, BFu1c_BFs1c_BFs1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1i_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1i_BFu1s) C1{ Fc:1 Fc:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1i_BFu1s, BFu1c_BFs1c_BFs1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll) C1{ Fc:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll, BFu1c_BFs1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll_BFs1c) C1{ Fc:1 Fc:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll_BFs1c, BFu1c_BFs1c_BFs1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll_BFs1i) C1{ Fc:1 Fc:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll_BFs1i, BFu1c_BFs1c_BFs1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll_BFs1ll) C1{ Fc:1 Fc:1 FL:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll_BFs1ll, BFu1c_BFs1c_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll_BFs1s) C1{ Fc:1 Fc:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll_BFs1s, BFu1c_BFs1c_BFs1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll_BFu1c) C1{ Fc:1 Fc:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll_BFu1c, BFu1c_BFs1c_BFs1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll_BFu1i) C1{ Fc:1 Fc:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll_BFu1i, BFu1c_BFs1c_BFs1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll_BFu1ll) C1{ Fc:1 Fc:1 FL:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll_BFu1ll, BFu1c_BFs1c_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1ll_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1ll_BFu1s) C1{ Fc:1 Fc:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1ll_BFu1s, BFu1c_BFs1c_BFs1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1c_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s) C1{ Fc:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s, BFu1c_BFs1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFs1s_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s_BFs1c) C1{ Fc:1 Fc:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s_BFs1c, BFu1c_BFs1c_BFs1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1s_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s_BFs1i) C1{ Fc:1 Fc:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s_BFs1i, BFu1c_BFs1c_BFs1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1s_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s_BFs1ll) C1{ Fc:1 Fc:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s_BFs1ll, BFu1c_BFs1c_BFs1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1s_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s_BFs1s) C1{ Fc:1 Fc:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s_BFs1s, BFu1c_BFs1c_BFs1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFs1s_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s_BFu1c) C1{ Fc:1 Fc:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s_BFu1c, BFu1c_BFs1c_BFs1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFs1s_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s_BFu1i) C1{ Fc:1 Fc:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s_BFu1i, BFu1c_BFs1c_BFs1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFs1s_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s_BFu1ll) C1{ Fc:1 Fc:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s_BFu1ll, BFu1c_BFs1c_BFs1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFs1s_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFs1s_BFu1s) C1{ Fc:1 Fc:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFs1s_BFu1s, BFu1c_BFs1c_BFs1s_BFu1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c) C1{ Fc:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c, BFu1c_BFs1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1c_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c_BFs1c) C1{ Fc:1 Fc:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFs1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFs1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c_BFs1c, BFu1c_BFs1c_BFu1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1c_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c_BFs1i) C1{ Fc:1 Fc:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c_BFs1i, BFu1c_BFs1c_BFu1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1c_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c_BFs1ll) C1{ Fc:1 Fc:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c_BFs1ll, BFu1c_BFs1c_BFu1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1c_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c_BFs1s) C1{ Fc:1 Fc:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c_BFs1s, BFu1c_BFs1c_BFu1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1c_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c_BFu1c) C1{ Fc:1 Fc:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFs1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFs1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c_BFu1c, BFu1c_BFs1c_BFu1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1c_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c_BFu1i) C1{ Fc:1 Fc:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c_BFu1i, BFu1c_BFs1c_BFu1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1c_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c_BFu1ll) C1{ Fc:1 Fc:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c_BFu1ll, BFu1c_BFs1c_BFu1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1c_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1c_BFu1s) C1{ Fc:1 Fc:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1c_BFu1s, BFu1c_BFs1c_BFu1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i) C1{ Fc:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i, BFu1c_BFs1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1i_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i_BFs1c) C1{ Fc:1 Fc:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i_BFs1c, BFu1c_BFs1c_BFu1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1i_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i_BFs1i) C1{ Fc:1 Fc:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i_BFs1i, BFu1c_BFs1c_BFu1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1i_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i_BFs1ll) C1{ Fc:1 Fc:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i_BFs1ll, BFu1c_BFs1c_BFu1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1i_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i_BFs1s) C1{ Fc:1 Fc:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i_BFs1s, BFu1c_BFs1c_BFu1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1i_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i_BFu1c) C1{ Fc:1 Fc:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i_BFu1c, BFu1c_BFs1c_BFu1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1i_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i_BFu1i) C1{ Fc:1 Fc:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i_BFu1i, BFu1c_BFs1c_BFu1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1i_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i_BFu1ll) C1{ Fc:1 Fc:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i_BFu1ll, BFu1c_BFs1c_BFu1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1i_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1i_BFu1s) C1{ Fc:1 Fc:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1i_BFu1s, BFu1c_BFs1c_BFu1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll) C1{ Fc:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll, BFu1c_BFs1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll_BFs1c) C1{ Fc:1 Fc:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll_BFs1c, BFu1c_BFs1c_BFu1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll_BFs1i) C1{ Fc:1 Fc:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll_BFs1i, BFu1c_BFs1c_BFu1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll_BFs1ll) C1{ Fc:1 Fc:1 FL:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll_BFs1ll, BFu1c_BFs1c_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll_BFs1s) C1{ Fc:1 Fc:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll_BFs1s, BFu1c_BFs1c_BFu1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll_BFu1c) C1{ Fc:1 Fc:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll_BFu1c, BFu1c_BFs1c_BFu1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll_BFu1i) C1{ Fc:1 Fc:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll_BFu1i, BFu1c_BFs1c_BFu1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll_BFu1ll) C1{ Fc:1 Fc:1 FL:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll_BFu1ll, BFu1c_BFs1c_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1ll_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1ll_BFu1s) C1{ Fc:1 Fc:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1ll_BFu1s, BFu1c_BFs1c_BFu1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s) C1{ Fc:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s, BFu1c_BFs1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1s_BFs1c  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s_BFs1c) C1{ Fc:1 Fc:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s_BFs1c, BFu1c_BFs1c_BFu1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1s_BFs1i  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s_BFs1i) C1{ Fc:1 Fc:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s_BFs1i, BFu1c_BFs1c_BFu1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1s_BFs1ll  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s_BFs1ll) C1{ Fc:1 Fc:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s_BFs1ll, BFu1c_BFs1c_BFu1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1s_BFs1s  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s_BFs1s) C1{ Fc:1 Fc:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s_BFs1s, BFu1c_BFs1c_BFu1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1c_BFu1s_BFu1c  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s_BFu1c) C1{ Fc:1 Fc:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s_BFu1c, BFu1c_BFs1c_BFu1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1c_BFu1s_BFu1i  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s_BFu1i) C1{ Fc:1 Fc:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s_BFu1i, BFu1c_BFs1c_BFu1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1c_BFu1s_BFu1ll  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s_BFu1ll) C1{ Fc:1 Fc:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s_BFu1ll, BFu1c_BFs1c_BFu1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1c_BFu1s_BFu1s  {
  unsigned char v1:1;
  signed char v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1c_BFu1s_BFu1s) C1{ Fc:1 Fc:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1c_BFu1s_BFu1s, BFu1c_BFs1c_BFu1s_BFu1s)
//============================================================================


struct  BFu1c_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
};
//SIG(1 BFu1c_BFs1i) C1{ Fc:1 Fi:1}



static void Test_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i, BFu1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c) C1{ Fc:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c, BFu1c_BFs1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1c_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c_BFs1c) C1{ Fc:1 Fi:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c_BFs1c, BFu1c_BFs1i_BFs1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1c_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c_BFs1i) C1{ Fc:1 Fi:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c_BFs1i, BFu1c_BFs1i_BFs1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1c_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c_BFs1ll) C1{ Fc:1 Fi:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c_BFs1ll, BFu1c_BFs1i_BFs1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1c_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c_BFs1s) C1{ Fc:1 Fi:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c_BFs1s, BFu1c_BFs1i_BFs1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFs1c_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c_BFu1c) C1{ Fc:1 Fi:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c_BFu1c, BFu1c_BFs1i_BFs1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1c_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c_BFu1i) C1{ Fc:1 Fi:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c_BFu1i, BFu1c_BFs1i_BFs1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1c_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c_BFu1ll) C1{ Fc:1 Fi:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c_BFu1ll, BFu1c_BFs1i_BFs1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1c_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1c_BFu1s) C1{ Fc:1 Fi:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1c_BFu1s, BFu1c_BFs1i_BFs1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1i_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i) C1{ Fc:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i, BFu1c_BFs1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1i_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i_BFs1c) C1{ Fc:1 Fi:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i_BFs1c, BFu1c_BFs1i_BFs1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1i_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i_BFs1i) C1{ Fc:1 Fi:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i_BFs1i, BFu1c_BFs1i_BFs1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1i_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i_BFs1ll) C1{ Fc:1 Fi:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i_BFs1ll, BFu1c_BFs1i_BFs1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1i_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i_BFs1s) C1{ Fc:1 Fi:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i_BFs1s, BFu1c_BFs1i_BFs1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFs1i_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i_BFu1c) C1{ Fc:1 Fi:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i_BFu1c, BFu1c_BFs1i_BFs1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1i_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i_BFu1i) C1{ Fc:1 Fi:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i_BFu1i, BFu1c_BFs1i_BFs1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1i_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i_BFu1ll) C1{ Fc:1 Fi:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i_BFu1ll, BFu1c_BFs1i_BFs1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1i_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1i_BFu1s) C1{ Fc:1 Fi:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1i_BFu1s, BFu1c_BFs1i_BFs1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll) C1{ Fc:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll, BFu1c_BFs1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll_BFs1c) C1{ Fc:1 Fi:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll_BFs1c, BFu1c_BFs1i_BFs1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll_BFs1i) C1{ Fc:1 Fi:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll_BFs1i, BFu1c_BFs1i_BFs1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll_BFs1ll) C1{ Fc:1 Fi:1 FL:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll_BFs1ll, BFu1c_BFs1i_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll_BFs1s) C1{ Fc:1 Fi:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll_BFs1s, BFu1c_BFs1i_BFs1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll_BFu1c) C1{ Fc:1 Fi:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll_BFu1c, BFu1c_BFs1i_BFs1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll_BFu1i) C1{ Fc:1 Fi:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll_BFu1i, BFu1c_BFs1i_BFs1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll_BFu1ll) C1{ Fc:1 Fi:1 FL:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll_BFu1ll, BFu1c_BFs1i_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1ll_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1ll_BFu1s) C1{ Fc:1 Fi:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1ll_BFu1s, BFu1c_BFs1i_BFs1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1i_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s) C1{ Fc:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s, BFu1c_BFs1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFs1s_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s_BFs1c) C1{ Fc:1 Fi:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s_BFs1c, BFu1c_BFs1i_BFs1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1s_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s_BFs1i) C1{ Fc:1 Fi:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s_BFs1i, BFu1c_BFs1i_BFs1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1s_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s_BFs1ll) C1{ Fc:1 Fi:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s_BFs1ll, BFu1c_BFs1i_BFs1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1s_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s_BFs1s) C1{ Fc:1 Fi:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s_BFs1s, BFu1c_BFs1i_BFs1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFs1s_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s_BFu1c) C1{ Fc:1 Fi:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s_BFu1c, BFu1c_BFs1i_BFs1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFs1s_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s_BFu1i) C1{ Fc:1 Fi:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s_BFu1i, BFu1c_BFs1i_BFs1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFs1s_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s_BFu1ll) C1{ Fc:1 Fi:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s_BFu1ll, BFu1c_BFs1i_BFs1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFs1s_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFs1s_BFu1s) C1{ Fc:1 Fi:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFs1s_BFu1s, BFu1c_BFs1i_BFs1s_BFu1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c) C1{ Fc:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c, BFu1c_BFs1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1c_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c_BFs1c) C1{ Fc:1 Fi:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c_BFs1c, BFu1c_BFs1i_BFu1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1c_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c_BFs1i) C1{ Fc:1 Fi:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c_BFs1i, BFu1c_BFs1i_BFu1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1c_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c_BFs1ll) C1{ Fc:1 Fi:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c_BFs1ll, BFu1c_BFs1i_BFu1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1c_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c_BFs1s) C1{ Fc:1 Fi:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c_BFs1s, BFu1c_BFs1i_BFu1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1c_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c_BFu1c) C1{ Fc:1 Fi:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c_BFu1c, BFu1c_BFs1i_BFu1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1c_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c_BFu1i) C1{ Fc:1 Fi:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c_BFu1i, BFu1c_BFs1i_BFu1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1c_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c_BFu1ll) C1{ Fc:1 Fi:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c_BFu1ll, BFu1c_BFs1i_BFu1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1c_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1c_BFu1s) C1{ Fc:1 Fi:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1c_BFu1s, BFu1c_BFs1i_BFu1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i) C1{ Fc:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i, BFu1c_BFs1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1i_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i_BFs1c) C1{ Fc:1 Fi:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i_BFs1c, BFu1c_BFs1i_BFu1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1i_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i_BFs1i) C1{ Fc:1 Fi:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i_BFs1i, BFu1c_BFs1i_BFu1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1i_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i_BFs1ll) C1{ Fc:1 Fi:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i_BFs1ll, BFu1c_BFs1i_BFu1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1i_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i_BFs1s) C1{ Fc:1 Fi:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i_BFs1s, BFu1c_BFs1i_BFu1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1i_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i_BFu1c) C1{ Fc:1 Fi:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i_BFu1c, BFu1c_BFs1i_BFu1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1i_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i_BFu1i) C1{ Fc:1 Fi:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i_BFu1i, BFu1c_BFs1i_BFu1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1i_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i_BFu1ll) C1{ Fc:1 Fi:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i_BFu1ll, BFu1c_BFs1i_BFu1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1i_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1i_BFu1s) C1{ Fc:1 Fi:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1i_BFu1s, BFu1c_BFs1i_BFu1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll) C1{ Fc:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll, BFu1c_BFs1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll_BFs1c) C1{ Fc:1 Fi:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll_BFs1c, BFu1c_BFs1i_BFu1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll_BFs1i) C1{ Fc:1 Fi:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll_BFs1i, BFu1c_BFs1i_BFu1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll_BFs1ll) C1{ Fc:1 Fi:1 FL:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll_BFs1ll, BFu1c_BFs1i_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll_BFs1s) C1{ Fc:1 Fi:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll_BFs1s, BFu1c_BFs1i_BFu1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll_BFu1c) C1{ Fc:1 Fi:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll_BFu1c, BFu1c_BFs1i_BFu1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll_BFu1i) C1{ Fc:1 Fi:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll_BFu1i, BFu1c_BFs1i_BFu1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll_BFu1ll) C1{ Fc:1 Fi:1 FL:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll_BFu1ll, BFu1c_BFs1i_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1ll_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1ll_BFu1s) C1{ Fc:1 Fi:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1ll_BFu1s, BFu1c_BFs1i_BFu1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s) C1{ Fc:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s, BFu1c_BFs1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1s_BFs1c  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s_BFs1c) C1{ Fc:1 Fi:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s_BFs1c, BFu1c_BFs1i_BFu1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1s_BFs1i  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s_BFs1i) C1{ Fc:1 Fi:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s_BFs1i, BFu1c_BFs1i_BFu1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1s_BFs1ll  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s_BFs1ll) C1{ Fc:1 Fi:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s_BFs1ll, BFu1c_BFs1i_BFu1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1s_BFs1s  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s_BFs1s) C1{ Fc:1 Fi:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s_BFs1s, BFu1c_BFs1i_BFu1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1i_BFu1s_BFu1c  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s_BFu1c) C1{ Fc:1 Fi:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s_BFu1c, BFu1c_BFs1i_BFu1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1i_BFu1s_BFu1i  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s_BFu1i) C1{ Fc:1 Fi:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s_BFu1i, BFu1c_BFs1i_BFu1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1i_BFu1s_BFu1ll  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s_BFu1ll) C1{ Fc:1 Fi:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s_BFu1ll, BFu1c_BFs1i_BFu1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1i_BFu1s_BFu1s  {
  unsigned char v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1i_BFu1s_BFu1s) C1{ Fc:1 Fi:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1i_BFu1s_BFu1s, BFu1c_BFs1i_BFu1s_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
};
//SIG(1 BFu1c_BFs1ll) C1{ Fc:1 FL:1}



static void Test_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll, BFu1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c) C1{ Fc:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c, BFu1c_BFs1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c_BFs1c) C1{ Fc:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c_BFs1c, BFu1c_BFs1ll_BFs1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c_BFs1i) C1{ Fc:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c_BFs1i, BFu1c_BFs1ll_BFs1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c_BFs1ll) C1{ Fc:1 FL:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c_BFs1ll, BFu1c_BFs1ll_BFs1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c_BFs1s) C1{ Fc:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c_BFs1s, BFu1c_BFs1ll_BFs1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c_BFu1c) C1{ Fc:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c_BFu1c, BFu1c_BFs1ll_BFs1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c_BFu1i) C1{ Fc:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c_BFu1i, BFu1c_BFs1ll_BFs1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c_BFu1ll) C1{ Fc:1 FL:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c_BFu1ll, BFu1c_BFs1ll_BFs1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1c_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1c_BFu1s) C1{ Fc:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1c_BFu1s, BFu1c_BFs1ll_BFs1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i) C1{ Fc:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i, BFu1c_BFs1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i_BFs1c) C1{ Fc:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i_BFs1c, BFu1c_BFs1ll_BFs1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i_BFs1i) C1{ Fc:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i_BFs1i, BFu1c_BFs1ll_BFs1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i_BFs1ll) C1{ Fc:1 FL:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i_BFs1ll, BFu1c_BFs1ll_BFs1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i_BFs1s) C1{ Fc:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i_BFs1s, BFu1c_BFs1ll_BFs1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i_BFu1c) C1{ Fc:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i_BFu1c, BFu1c_BFs1ll_BFs1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i_BFu1i) C1{ Fc:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i_BFu1i, BFu1c_BFs1ll_BFs1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i_BFu1ll) C1{ Fc:1 FL:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i_BFu1ll, BFu1c_BFs1ll_BFs1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1i_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1i_BFu1s) C1{ Fc:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1i_BFu1s, BFu1c_BFs1ll_BFs1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll) C1{ Fc:1 FL:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll, BFu1c_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll_BFs1c) C1{ Fc:1 FL:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll_BFs1c, BFu1c_BFs1ll_BFs1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll_BFs1i) C1{ Fc:1 FL:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll_BFs1i, BFu1c_BFs1ll_BFs1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll_BFs1ll) C1{ Fc:1 FL:1 FL:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll_BFs1ll, BFu1c_BFs1ll_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll_BFs1s) C1{ Fc:1 FL:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll_BFs1s, BFu1c_BFs1ll_BFs1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll_BFu1c) C1{ Fc:1 FL:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll_BFu1c, BFu1c_BFs1ll_BFs1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll_BFu1i) C1{ Fc:1 FL:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll_BFu1i, BFu1c_BFs1ll_BFs1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll_BFu1ll) C1{ Fc:1 FL:1 FL:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll_BFu1ll, BFu1c_BFs1ll_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1ll_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1ll_BFu1s) C1{ Fc:1 FL:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1ll_BFu1s, BFu1c_BFs1ll_BFs1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s) C1{ Fc:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s, BFu1c_BFs1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s_BFs1c) C1{ Fc:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s_BFs1c, BFu1c_BFs1ll_BFs1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s_BFs1i) C1{ Fc:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s_BFs1i, BFu1c_BFs1ll_BFs1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s_BFs1ll) C1{ Fc:1 FL:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s_BFs1ll, BFu1c_BFs1ll_BFs1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s_BFs1s) C1{ Fc:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s_BFs1s, BFu1c_BFs1ll_BFs1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s_BFu1c) C1{ Fc:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s_BFu1c, BFu1c_BFs1ll_BFs1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s_BFu1i) C1{ Fc:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s_BFu1i, BFu1c_BFs1ll_BFs1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s_BFu1ll) C1{ Fc:1 FL:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s_BFu1ll, BFu1c_BFs1ll_BFs1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFs1s_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFs1s_BFu1s) C1{ Fc:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFs1s_BFu1s, BFu1c_BFs1ll_BFs1s_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c) C1{ Fc:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c, BFu1c_BFs1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c_BFs1c) C1{ Fc:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c_BFs1c, BFu1c_BFs1ll_BFu1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c_BFs1i) C1{ Fc:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c_BFs1i, BFu1c_BFs1ll_BFu1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c_BFs1ll) C1{ Fc:1 FL:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c_BFs1ll, BFu1c_BFs1ll_BFu1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c_BFs1s) C1{ Fc:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c_BFs1s, BFu1c_BFs1ll_BFu1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c_BFu1c) C1{ Fc:1 FL:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c_BFu1c, BFu1c_BFs1ll_BFu1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c_BFu1i) C1{ Fc:1 FL:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c_BFu1i, BFu1c_BFs1ll_BFu1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c_BFu1ll) C1{ Fc:1 FL:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c_BFu1ll, BFu1c_BFs1ll_BFu1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1c_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1c_BFu1s) C1{ Fc:1 FL:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1c_BFu1s, BFu1c_BFs1ll_BFu1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i) C1{ Fc:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i, BFu1c_BFs1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i_BFs1c) C1{ Fc:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i_BFs1c, BFu1c_BFs1ll_BFu1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i_BFs1i) C1{ Fc:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i_BFs1i, BFu1c_BFs1ll_BFu1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i_BFs1ll) C1{ Fc:1 FL:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i_BFs1ll, BFu1c_BFs1ll_BFu1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i_BFs1s) C1{ Fc:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i_BFs1s, BFu1c_BFs1ll_BFu1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i_BFu1c) C1{ Fc:1 FL:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i_BFu1c, BFu1c_BFs1ll_BFu1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i_BFu1i) C1{ Fc:1 FL:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i_BFu1i, BFu1c_BFs1ll_BFu1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i_BFu1ll) C1{ Fc:1 FL:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i_BFu1ll, BFu1c_BFs1ll_BFu1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1i_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1i_BFu1s) C1{ Fc:1 FL:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1i_BFu1s, BFu1c_BFs1ll_BFu1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll) C1{ Fc:1 FL:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll, BFu1c_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll_BFs1c) C1{ Fc:1 FL:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll_BFs1c, BFu1c_BFs1ll_BFu1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll_BFs1i) C1{ Fc:1 FL:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll_BFs1i, BFu1c_BFs1ll_BFu1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll_BFs1ll) C1{ Fc:1 FL:1 FL:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll_BFs1ll, BFu1c_BFs1ll_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll_BFs1s) C1{ Fc:1 FL:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll_BFs1s, BFu1c_BFs1ll_BFu1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll_BFu1c) C1{ Fc:1 FL:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll_BFu1c, BFu1c_BFs1ll_BFu1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll_BFu1i) C1{ Fc:1 FL:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll_BFu1i, BFu1c_BFs1ll_BFu1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll_BFu1ll) C1{ Fc:1 FL:1 FL:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll_BFu1ll, BFu1c_BFs1ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1ll_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1ll_BFu1s) C1{ Fc:1 FL:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1ll_BFu1s, BFu1c_BFs1ll_BFu1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s) C1{ Fc:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s, BFu1c_BFs1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s_BFs1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s_BFs1c) C1{ Fc:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s_BFs1c, BFu1c_BFs1ll_BFu1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s_BFs1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s_BFs1i) C1{ Fc:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s_BFs1i, BFu1c_BFs1ll_BFu1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s_BFs1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s_BFs1ll) C1{ Fc:1 FL:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s_BFs1ll, BFu1c_BFs1ll_BFu1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s_BFs1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s_BFs1s) C1{ Fc:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s_BFs1s, BFu1c_BFs1ll_BFu1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s_BFu1c  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s_BFu1c) C1{ Fc:1 FL:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s_BFu1c, BFu1c_BFs1ll_BFu1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s_BFu1i  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s_BFu1i) C1{ Fc:1 FL:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s_BFu1i, BFu1c_BFs1ll_BFu1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s_BFu1ll  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s_BFu1ll) C1{ Fc:1 FL:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s_BFu1ll, BFu1c_BFs1ll_BFu1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1ll_BFu1s_BFu1s  {
  unsigned char v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1ll_BFu1s_BFu1s) C1{ Fc:1 FL:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1ll_BFu1s_BFu1s, BFu1c_BFs1ll_BFu1s_BFu1s)
//============================================================================


struct  BFu1c_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
};
//SIG(1 BFu1c_BFs1s) C1{ Fc:1 Fs:1}



static void Test_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s, BFu1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c) C1{ Fc:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c, BFu1c_BFs1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1c_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c_BFs1c) C1{ Fc:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c_BFs1c, BFu1c_BFs1s_BFs1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1c_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c_BFs1i) C1{ Fc:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c_BFs1i, BFu1c_BFs1s_BFs1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1c_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c_BFs1ll) C1{ Fc:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c_BFs1ll, BFu1c_BFs1s_BFs1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1c_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c_BFs1s) C1{ Fc:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c_BFs1s, BFu1c_BFs1s_BFs1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1c_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c_BFu1c) C1{ Fc:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c_BFu1c, BFu1c_BFs1s_BFs1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1c_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c_BFu1i) C1{ Fc:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c_BFu1i, BFu1c_BFs1s_BFs1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1c_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c_BFu1ll) C1{ Fc:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c_BFu1ll, BFu1c_BFs1s_BFs1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1c_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1c_BFu1s) C1{ Fc:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1c_BFu1s, BFu1c_BFs1s_BFs1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i) C1{ Fc:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i, BFu1c_BFs1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1i_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i_BFs1c) C1{ Fc:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i_BFs1c, BFu1c_BFs1s_BFs1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1i_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i_BFs1i) C1{ Fc:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i_BFs1i, BFu1c_BFs1s_BFs1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1i_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i_BFs1ll) C1{ Fc:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i_BFs1ll, BFu1c_BFs1s_BFs1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1i_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i_BFs1s) C1{ Fc:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i_BFs1s, BFu1c_BFs1s_BFs1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1i_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i_BFu1c) C1{ Fc:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i_BFu1c, BFu1c_BFs1s_BFs1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1i_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i_BFu1i) C1{ Fc:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i_BFu1i, BFu1c_BFs1s_BFs1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1i_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i_BFu1ll) C1{ Fc:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i_BFu1ll, BFu1c_BFs1s_BFs1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1i_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1i_BFu1s) C1{ Fc:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1i_BFu1s, BFu1c_BFs1s_BFs1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll) C1{ Fc:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll, BFu1c_BFs1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll_BFs1c) C1{ Fc:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll_BFs1c, BFu1c_BFs1s_BFs1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll_BFs1i) C1{ Fc:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll_BFs1i, BFu1c_BFs1s_BFs1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll_BFs1ll) C1{ Fc:1 Fs:1 FL:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll_BFs1ll, BFu1c_BFs1s_BFs1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll_BFs1s) C1{ Fc:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll_BFs1s, BFu1c_BFs1s_BFs1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll_BFu1c) C1{ Fc:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll_BFu1c, BFu1c_BFs1s_BFs1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll_BFu1i) C1{ Fc:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll_BFu1i, BFu1c_BFs1s_BFs1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll_BFu1ll) C1{ Fc:1 Fs:1 FL:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll_BFu1ll, BFu1c_BFs1s_BFs1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1ll_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1ll_BFu1s) C1{ Fc:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1ll_BFu1s, BFu1c_BFs1s_BFs1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s) C1{ Fc:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s, BFu1c_BFs1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1s_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s_BFs1c) C1{ Fc:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s_BFs1c, BFu1c_BFs1s_BFs1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1s_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s_BFs1i) C1{ Fc:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s_BFs1i, BFu1c_BFs1s_BFs1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1s_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s_BFs1ll) C1{ Fc:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s_BFs1ll, BFu1c_BFs1s_BFs1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1s_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s_BFs1s) C1{ Fc:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s_BFs1s, BFu1c_BFs1s_BFs1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFs1s_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s_BFu1c) C1{ Fc:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s_BFu1c, BFu1c_BFs1s_BFs1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFs1s_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s_BFu1i) C1{ Fc:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s_BFu1i, BFu1c_BFs1s_BFs1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFs1s_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s_BFu1ll) C1{ Fc:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s_BFu1ll, BFu1c_BFs1s_BFs1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFs1s_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFs1s_BFu1s) C1{ Fc:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFu1c_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFs1s_BFu1s, BFu1c_BFs1s_BFs1s_BFu1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c) C1{ Fc:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c, BFu1c_BFs1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1c_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c_BFs1c) C1{ Fc:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c_BFs1c, BFu1c_BFs1s_BFu1c_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1c_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c_BFs1i) C1{ Fc:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c_BFs1i, BFu1c_BFs1s_BFu1c_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1c_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c_BFs1ll) C1{ Fc:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c_BFs1ll, BFu1c_BFs1s_BFu1c_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1c_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c_BFs1s) C1{ Fc:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c_BFs1s, BFu1c_BFs1s_BFu1c_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1c_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c_BFu1c) C1{ Fc:1 Fs:1 Fc:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c_BFu1c, BFu1c_BFs1s_BFu1c_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1c_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c_BFu1i) C1{ Fc:1 Fs:1 Fc:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c_BFu1i, BFu1c_BFs1s_BFu1c_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1c_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c_BFu1ll) C1{ Fc:1 Fs:1 Fc:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c_BFu1ll, BFu1c_BFs1s_BFu1c_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1c_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1c_BFu1s) C1{ Fc:1 Fs:1 Fc:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1c_BFu1s, BFu1c_BFs1s_BFu1c_BFu1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i) C1{ Fc:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i, BFu1c_BFs1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1i_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i_BFs1c) C1{ Fc:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i_BFs1c, BFu1c_BFs1s_BFu1i_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1i_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i_BFs1i) C1{ Fc:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i_BFs1i, BFu1c_BFs1s_BFu1i_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1i_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i_BFs1ll) C1{ Fc:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i_BFs1ll, BFu1c_BFs1s_BFu1i_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1i_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i_BFs1s) C1{ Fc:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i_BFs1s, BFu1c_BFs1s_BFu1i_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1i_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i_BFu1c) C1{ Fc:1 Fs:1 Fi:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i_BFu1c, BFu1c_BFs1s_BFu1i_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1i_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i_BFu1i) C1{ Fc:1 Fs:1 Fi:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i_BFu1i, BFu1c_BFs1s_BFu1i_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1i_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i_BFu1ll) C1{ Fc:1 Fs:1 Fi:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i_BFu1ll, BFu1c_BFs1s_BFu1i_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1i_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1i_BFu1s) C1{ Fc:1 Fs:1 Fi:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1i_BFu1s, BFu1c_BFs1s_BFu1i_BFu1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll) C1{ Fc:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll, BFu1c_BFs1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll_BFs1c) C1{ Fc:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll_BFs1c, BFu1c_BFs1s_BFu1ll_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll_BFs1i) C1{ Fc:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll_BFs1i, BFu1c_BFs1s_BFu1ll_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll_BFs1ll) C1{ Fc:1 Fs:1 FL:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll_BFs1ll, BFu1c_BFs1s_BFu1ll_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll_BFs1s) C1{ Fc:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll_BFs1s, BFu1c_BFs1s_BFu1ll_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll_BFu1c) C1{ Fc:1 Fs:1 FL:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll_BFu1c, BFu1c_BFs1s_BFu1ll_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll_BFu1i) C1{ Fc:1 Fs:1 FL:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll_BFu1i, BFu1c_BFs1s_BFu1ll_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll_BFu1ll) C1{ Fc:1 Fs:1 FL:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll_BFu1ll, BFu1c_BFs1s_BFu1ll_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1ll_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1ll_BFu1s) C1{ Fc:1 Fs:1 FL:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1ll_BFu1s, BFu1c_BFs1s_BFu1ll_BFu1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s) C1{ Fc:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s, BFu1c_BFs1s_BFu1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1s_BFs1c  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s_BFs1c) C1{ Fc:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s_BFs1c, BFu1c_BFs1s_BFu1s_BFs1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1s_BFs1i  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s_BFs1i) C1{ Fc:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s_BFs1i, BFu1c_BFs1s_BFu1s_BFs1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1s_BFs1ll  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s_BFs1ll) C1{ Fc:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s_BFs1ll, BFu1c_BFs1s_BFu1s_BFs1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1s_BFs1s  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s_BFs1s) C1{ Fc:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFu1c_BFs1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s_BFs1s, BFu1c_BFs1s_BFu1s_BFs1s)
//============================================================================


struct  BFu1c_BFs1s_BFu1s_BFu1c  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s_BFu1c) C1{ Fc:1 Fs:1 Fs:1 Fc:1}



static void Test_BFu1c_BFs1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s_BFu1c, BFu1c_BFs1s_BFu1s_BFu1c)
//============================================================================


struct  BFu1c_BFs1s_BFu1s_BFu1i  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s_BFu1i) C1{ Fc:1 Fs:1 Fs:1 Fi:1}



static void Test_BFu1c_BFs1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFs1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFs1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s_BFu1i, BFu1c_BFs1s_BFu1s_BFu1i)
//============================================================================


struct  BFu1c_BFs1s_BFu1s_BFu1ll  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s_BFu1ll) C1{ Fc:1 Fs:1 Fs:1 FL:1}



static void Test_BFu1c_BFs1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFs1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFs1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s_BFu1ll, BFu1c_BFs1s_BFu1s_BFu1ll)
//============================================================================


struct  BFu1c_BFs1s_BFu1s_BFu1s  {
  unsigned char v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFu1c_BFs1s_BFu1s_BFu1s) C1{ Fc:1 Fs:1 Fs:1 Fs:1}



static void Test_BFu1c_BFs1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFs1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFu1c_BFs1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFs1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFs1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFu1c_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFu1c_BFs1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFs1s_BFu1s_BFu1s, BFu1c_BFs1s_BFu1s_BFu1s)
//============================================================================


struct  BFu1c_BFu15i  {
  unsigned char v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu1c_BFu15i) C1{ Fc:1 Fi:15}



static void Test_BFu1c_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu15i");
    static STRUCT_IF_C BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i, BFu1c_BFu15i)
//============================================================================


struct  BFu1c_BFu15i_BFu15i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 BFu1c_BFu15i_BFu15i) C1{ Fc:1 Fi:15 Fi:15}



static void Test_BFu1c_BFu15i_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu15i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu15i, BFu1c_BFu15i_BFu15i)
//============================================================================


struct  BFu1c_BFu15i_BFu15ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFu1c_BFu15i_BFu15ll) C1{ Fc:1 Fi:15 FL:15}



static void Test_BFu1c_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu15ll, BFu1c_BFu15i_BFu15ll)
//============================================================================


struct  BFu1c_BFu15i_BFu15s  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 BFu1c_BFu15i_BFu15s) C1{ Fc:1 Fi:15 Fs:15}



static void Test_BFu1c_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu15s");
    static STRUCT_IF_C BFu1c_BFu15i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu15s, BFu1c_BFu15i_BFu15s)
//============================================================================


struct  BFu1c_BFu15i_BFu16i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:16;
};
//SIG(1 BFu1c_BFu15i_BFu16i) C1{ Fc:1 Fi:15 Fi:16}



static void Test_BFu1c_BFu15i_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu16i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu16i, BFu1c_BFu15i_BFu16i)
//============================================================================


struct  BFu1c_BFu15i_BFu16ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:16;
};
//SIG(1 BFu1c_BFu15i_BFu16ll) C1{ Fc:1 Fi:15 FL:16}



static void Test_BFu1c_BFu15i_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu16ll, BFu1c_BFu15i_BFu16ll)
//============================================================================


struct  BFu1c_BFu15i_BFu16s  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned short v3:16;
};
//SIG(1 BFu1c_BFu15i_BFu16s) C1{ Fc:1 Fi:15 Fs:16}



static void Test_BFu1c_BFu15i_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu16s");
    static STRUCT_IF_C BFu1c_BFu15i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu16s, BFu1c_BFu15i_BFu16s)
//============================================================================


struct  BFu1c_BFu15i_BFu17i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:17;
};
//SIG(1 BFu1c_BFu15i_BFu17i) C1{ Fc:1 Fi:15 Fi:17}



static void Test_BFu1c_BFu15i_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu17i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1c_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu17i, BFu1c_BFu15i_BFu17i)
//============================================================================


struct  BFu1c_BFu15i_BFu17ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:17;
};
//SIG(1 BFu1c_BFu15i_BFu17ll) C1{ Fc:1 Fi:15 FL:17}



static void Test_BFu1c_BFu15i_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1c_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu17ll, BFu1c_BFu15i_BFu17ll)
//============================================================================


struct  BFu1c_BFu15i_BFu1c  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFu15i_BFu1c) C1{ Fc:1 Fi:15 Fc:1}



static void Test_BFu1c_BFu15i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu1c");
    static STRUCT_IF_C BFu1c_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu1c, BFu1c_BFu15i_BFu1c)
//============================================================================


struct  BFu1c_BFu15i_BFu1i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFu15i_BFu1i) C1{ Fc:1 Fi:15 Fi:1}



static void Test_BFu1c_BFu15i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu1i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu1i, BFu1c_BFu15i_BFu1i)
//============================================================================


struct  BFu1c_BFu15i_BFu1ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFu15i_BFu1ll) C1{ Fc:1 Fi:15 FL:1}



static void Test_BFu1c_BFu15i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu1ll, BFu1c_BFu15i_BFu1ll)
//============================================================================


struct  BFu1c_BFu15i_BFu1s  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFu15i_BFu1s) C1{ Fc:1 Fi:15 Fs:1}



static void Test_BFu1c_BFu15i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu1s");
    static STRUCT_IF_C BFu1c_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu1s, BFu1c_BFu15i_BFu1s)
//============================================================================


struct  BFu1c_BFu15i_BFu31i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:31;
};
//SIG(1 BFu1c_BFu15i_BFu31i) C1{ Fc:1 Fi:15 Fi:31}



static void Test_BFu1c_BFu15i_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu31i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1c_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu31i, BFu1c_BFu15i_BFu31i)
//============================================================================


struct  BFu1c_BFu15i_BFu31ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:31;
};
//SIG(1 BFu1c_BFu15i_BFu31ll) C1{ Fc:1 Fi:15 FL:31}



static void Test_BFu1c_BFu15i_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1c_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu31ll, BFu1c_BFu15i_BFu31ll)
//============================================================================


struct  BFu1c_BFu15i_BFu32i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:32;
};
//SIG(1 BFu1c_BFu15i_BFu32i) C1{ Fc:1 Fi:15 Fi:32}



static void Test_BFu1c_BFu15i_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu32i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1c_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu32i, BFu1c_BFu15i_BFu32i)
//============================================================================


struct  BFu1c_BFu15i_BFu32ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:32;
};
//SIG(1 BFu1c_BFu15i_BFu32ll) C1{ Fc:1 Fi:15 FL:32}



static void Test_BFu1c_BFu15i_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1c_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu32ll, BFu1c_BFu15i_BFu32ll)
//============================================================================


struct  BFu1c_BFu15i_BFu33  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:33;
};
//SIG(1 BFu1c_BFu15i_BFu33) C1{ Fc:1 Fi:15 FL:33}



static void Test_BFu1c_BFu15i_BFu33()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu33");
    static STRUCT_IF_C BFu1c_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1c_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1c_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu33, BFu1c_BFu15i_BFu33)
//============================================================================


struct  BFu1c_BFu15i_BFu7c  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned char v3:7;
};
//SIG(1 BFu1c_BFu15i_BFu7c) C1{ Fc:1 Fi:15 Fc:7}



static void Test_BFu1c_BFu15i_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu7c");
    static STRUCT_IF_C BFu1c_BFu15i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu7c, BFu1c_BFu15i_BFu7c)
//============================================================================


struct  BFu1c_BFu15i_BFu7i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:7;
};
//SIG(1 BFu1c_BFu15i_BFu7i) C1{ Fc:1 Fi:15 Fi:7}



static void Test_BFu1c_BFu15i_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu7i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu7i, BFu1c_BFu15i_BFu7i)
//============================================================================


struct  BFu1c_BFu15i_BFu7ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:7;
};
//SIG(1 BFu1c_BFu15i_BFu7ll) C1{ Fc:1 Fi:15 FL:7}



static void Test_BFu1c_BFu15i_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu7ll, BFu1c_BFu15i_BFu7ll)
//============================================================================


struct  BFu1c_BFu15i_BFu7s  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned short v3:7;
};
//SIG(1 BFu1c_BFu15i_BFu7s) C1{ Fc:1 Fi:15 Fs:7}



static void Test_BFu1c_BFu15i_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu7s");
    static STRUCT_IF_C BFu1c_BFu15i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu7s, BFu1c_BFu15i_BFu7s)
//============================================================================


struct  BFu1c_BFu15i_BFu8c  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned char v3:8;
};
//SIG(1 BFu1c_BFu15i_BFu8c) C1{ Fc:1 Fi:15 Fc:8}



static void Test_BFu1c_BFu15i_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu8c");
    static STRUCT_IF_C BFu1c_BFu15i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu8c, BFu1c_BFu15i_BFu8c)
//============================================================================


struct  BFu1c_BFu15i_BFu8i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:8;
};
//SIG(1 BFu1c_BFu15i_BFu8i) C1{ Fc:1 Fi:15 Fi:8}



static void Test_BFu1c_BFu15i_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu8i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu8i, BFu1c_BFu15i_BFu8i)
//============================================================================


struct  BFu1c_BFu15i_BFu8ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:8;
};
//SIG(1 BFu1c_BFu15i_BFu8ll) C1{ Fc:1 Fi:15 FL:8}



static void Test_BFu1c_BFu15i_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu8ll, BFu1c_BFu15i_BFu8ll)
//============================================================================


struct  BFu1c_BFu15i_BFu8s  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned short v3:8;
};
//SIG(1 BFu1c_BFu15i_BFu8s) C1{ Fc:1 Fi:15 Fs:8}



static void Test_BFu1c_BFu15i_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu8s");
    static STRUCT_IF_C BFu1c_BFu15i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu8s, BFu1c_BFu15i_BFu8s)
//============================================================================


struct  BFu1c_BFu15i_BFu9i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3:9;
};
//SIG(1 BFu1c_BFu15i_BFu9i) C1{ Fc:1 Fi:15 Fi:9}



static void Test_BFu1c_BFu15i_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu9i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu9i, BFu1c_BFu15i_BFu9i)
//============================================================================


struct  BFu1c_BFu15i_BFu9ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3:9;
};
//SIG(1 BFu1c_BFu15i_BFu9ll) C1{ Fc:1 Fi:15 FL:9}



static void Test_BFu1c_BFu15i_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu9ll, BFu1c_BFu15i_BFu9ll)
//============================================================================


struct  BFu1c_BFu15i_BFu9s  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned short v3:9;
};
//SIG(1 BFu1c_BFu15i_BFu9s) C1{ Fc:1 Fi:15 Fs:9}



static void Test_BFu1c_BFu15i_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu9s");
    static STRUCT_IF_C BFu1c_BFu15i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu9s, BFu1c_BFu15i_BFu9s)
//============================================================================


struct  BFu1c_BFu15i_C  {
  unsigned char v1:1;
  unsigned int v2:15;
  char v3;
};
//SIG(1 BFu1c_BFu15i_C) C1{ Fc:1 Fi:15 Fc}



static void Test_BFu1c_BFu15i_C()
{
  {
    init_simple_test("BFu1c_BFu15i_C");
    static STRUCT_IF_C BFu1c_BFu15i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_C");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_C");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_C");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_C, BFu1c_BFu15i_C)
//============================================================================


struct  BFu1c_BFu15i_D  {
  unsigned char v1:1;
  unsigned int v2:15;
  double v3;
};
//SIG(1 BFu1c_BFu15i_D) C1{ Fc:1 Fi:15 FL}



static void Test_BFu1c_BFu15i_D()
{
  {
    init_simple_test("BFu1c_BFu15i_D");
    static STRUCT_IF_C BFu1c_BFu15i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_D");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_D");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_D, BFu1c_BFu15i_D)
//============================================================================


struct  BFu1c_BFu15i_F  {
  unsigned char v1:1;
  unsigned int v2:15;
  float v3;
};
//SIG(1 BFu1c_BFu15i_F) C1{ Fc:1 Fi:15 Fi}



static void Test_BFu1c_BFu15i_F()
{
  {
    init_simple_test("BFu1c_BFu15i_F");
    static STRUCT_IF_C BFu1c_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_F");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_F");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_F");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_F, BFu1c_BFu15i_F)
//============================================================================


struct  BFu1c_BFu15i_I  {
  unsigned char v1:1;
  unsigned int v2:15;
  int v3;
};
//SIG(1 BFu1c_BFu15i_I) C1{ Fc:1 Fi:15 Fi}



static void Test_BFu1c_BFu15i_I()
{
  {
    init_simple_test("BFu1c_BFu15i_I");
    static STRUCT_IF_C BFu1c_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_I");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_I");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_I");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_I, BFu1c_BFu15i_I)
//============================================================================


struct  BFu1c_BFu15i_Ip  {
  unsigned char v1:1;
  unsigned int v2:15;
  int *v3;
};
//SIG(1 BFu1c_BFu15i_Ip) C1{ Fc:1 Fi:15 Fp}



static void Test_BFu1c_BFu15i_Ip()
{
  {
    init_simple_test("BFu1c_BFu15i_Ip");
    static STRUCT_IF_C BFu1c_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_Ip, BFu1c_BFu15i_Ip)
//============================================================================


struct  BFu1c_BFu15i_L  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsi64 v3;
};
//SIG(1 BFu1c_BFu15i_L) C1{ Fc:1 Fi:15 FL}



static void Test_BFu1c_BFu15i_L()
{
  {
    init_simple_test("BFu1c_BFu15i_L");
    static STRUCT_IF_C BFu1c_BFu15i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_L");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_L");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_L, BFu1c_BFu15i_L)
//============================================================================


struct  BFu1c_BFu15i_S  {
  unsigned char v1:1;
  unsigned int v2:15;
  short v3;
};
//SIG(1 BFu1c_BFu15i_S) C1{ Fc:1 Fi:15 Fs}



static void Test_BFu1c_BFu15i_S()
{
  {
    init_simple_test("BFu1c_BFu15i_S");
    static STRUCT_IF_C BFu1c_BFu15i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_S");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_S");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_S");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_S, BFu1c_BFu15i_S)
//============================================================================


struct  BFu1c_BFu15i_Uc  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned char v3;
};
//SIG(1 BFu1c_BFu15i_Uc) C1{ Fc:1 Fi:15 Fc}



static void Test_BFu1c_BFu15i_Uc()
{
  {
    init_simple_test("BFu1c_BFu15i_Uc");
    static STRUCT_IF_C BFu1c_BFu15i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_Uc");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_Uc, BFu1c_BFu15i_Uc)
//============================================================================


struct  BFu1c_BFu15i_Ui  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int v3;
};
//SIG(1 BFu1c_BFu15i_Ui) C1{ Fc:1 Fi:15 Fi}



static void Test_BFu1c_BFu15i_Ui()
{
  {
    init_simple_test("BFu1c_BFu15i_Ui");
    static STRUCT_IF_C BFu1c_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_Ui");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_Ui, BFu1c_BFu15i_Ui)
//============================================================================


struct  BFu1c_BFu15i_Ul  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64 v3;
};
//SIG(1 BFu1c_BFu15i_Ul) C1{ Fc:1 Fi:15 FL}



static void Test_BFu1c_BFu15i_Ul()
{
  {
    init_simple_test("BFu1c_BFu15i_Ul");
    static STRUCT_IF_C BFu1c_BFu15i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_Ul, BFu1c_BFu15i_Ul)
//============================================================================


struct  BFu1c_BFu15i_Us  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned short v3;
};
//SIG(1 BFu1c_BFu15i_Us) C1{ Fc:1 Fi:15 Fs}



static void Test_BFu1c_BFu15i_Us()
{
  {
    init_simple_test("BFu1c_BFu15i_Us");
    static STRUCT_IF_C BFu1c_BFu15i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_Us");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_Us, BFu1c_BFu15i_Us)
//============================================================================


struct  BFu1c_BFu15i_Vp  {
  unsigned char v1:1;
  unsigned int v2:15;
  void *v3;
};
//SIG(1 BFu1c_BFu15i_Vp) C1{ Fc:1 Fi:15 Fp}



static void Test_BFu1c_BFu15i_Vp()
{
  {
    init_simple_test("BFu1c_BFu15i_Vp");
    static STRUCT_IF_C BFu1c_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_Vp, BFu1c_BFu15i_Vp)
//============================================================================


struct  BFu1c_BFu15ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu1c_BFu15ll) C1{ Fc:1 FL:15}



static void Test_BFu1c_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll, BFu1c_BFu15ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu15i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 BFu1c_BFu15ll_BFu15i) C1{ Fc:1 FL:15 Fi:15}



static void Test_BFu1c_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu15i, BFu1c_BFu15ll_BFu15i)
//============================================================================


struct  BFu1c_BFu15ll_BFu15ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFu1c_BFu15ll_BFu15ll) C1{ Fc:1 FL:15 FL:15}



static void Test_BFu1c_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu15ll, BFu1c_BFu15ll_BFu15ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu15s  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFu1c_BFu15ll_BFu15s) C1{ Fc:1 FL:15 Fs:15}



static void Test_BFu1c_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu15s, BFu1c_BFu15ll_BFu15s)
//============================================================================


struct  BFu1c_BFu15ll_BFu16i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 BFu1c_BFu15ll_BFu16i) C1{ Fc:1 FL:15 Fi:16}



static void Test_BFu1c_BFu15ll_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu16i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu16i, BFu1c_BFu15ll_BFu16i)
//============================================================================


struct  BFu1c_BFu15ll_BFu16ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 BFu1c_BFu15ll_BFu16ll) C1{ Fc:1 FL:15 FL:16}



static void Test_BFu1c_BFu15ll_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu16ll, BFu1c_BFu15ll_BFu16ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu16s  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 BFu1c_BFu15ll_BFu16s) C1{ Fc:1 FL:15 Fs:16}



static void Test_BFu1c_BFu15ll_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu16s");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu16s, BFu1c_BFu15ll_BFu16s)
//============================================================================


struct  BFu1c_BFu15ll_BFu17i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 BFu1c_BFu15ll_BFu17i) C1{ Fc:1 FL:15 Fi:17}



static void Test_BFu1c_BFu15ll_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu17i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1c_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu17i, BFu1c_BFu15ll_BFu17i)
//============================================================================


struct  BFu1c_BFu15ll_BFu17ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 BFu1c_BFu15ll_BFu17ll) C1{ Fc:1 FL:15 FL:17}



static void Test_BFu1c_BFu15ll_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1c_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu17ll, BFu1c_BFu15ll_BFu17ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu1c  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFu15ll_BFu1c) C1{ Fc:1 FL:15 Fc:1}



static void Test_BFu1c_BFu15ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu1c, BFu1c_BFu15ll_BFu1c)
//============================================================================


struct  BFu1c_BFu15ll_BFu1i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFu15ll_BFu1i) C1{ Fc:1 FL:15 Fi:1}



static void Test_BFu1c_BFu15ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu1i, BFu1c_BFu15ll_BFu1i)
//============================================================================


struct  BFu1c_BFu15ll_BFu1ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFu15ll_BFu1ll) C1{ Fc:1 FL:15 FL:1}



static void Test_BFu1c_BFu15ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu1ll, BFu1c_BFu15ll_BFu1ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu1s  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFu15ll_BFu1s) C1{ Fc:1 FL:15 Fs:1}



static void Test_BFu1c_BFu15ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu1s, BFu1c_BFu15ll_BFu1s)
//============================================================================


struct  BFu1c_BFu15ll_BFu31i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 BFu1c_BFu15ll_BFu31i) C1{ Fc:1 FL:15 Fi:31}



static void Test_BFu1c_BFu15ll_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu31i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1c_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu31i, BFu1c_BFu15ll_BFu31i)
//============================================================================


struct  BFu1c_BFu15ll_BFu31ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 BFu1c_BFu15ll_BFu31ll) C1{ Fc:1 FL:15 FL:31}



static void Test_BFu1c_BFu15ll_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1c_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu31ll, BFu1c_BFu15ll_BFu31ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu32i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 BFu1c_BFu15ll_BFu32i) C1{ Fc:1 FL:15 Fi:32}



static void Test_BFu1c_BFu15ll_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu32i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1c_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu32i, BFu1c_BFu15ll_BFu32i)
//============================================================================


struct  BFu1c_BFu15ll_BFu32ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 BFu1c_BFu15ll_BFu32ll) C1{ Fc:1 FL:15 FL:32}



static void Test_BFu1c_BFu15ll_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1c_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu32ll, BFu1c_BFu15ll_BFu32ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu33  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 BFu1c_BFu15ll_BFu33) C1{ Fc:1 FL:15 FL:33}



static void Test_BFu1c_BFu15ll_BFu33()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu33");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1c_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1c_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu33, BFu1c_BFu15ll_BFu33)
//============================================================================


struct  BFu1c_BFu15ll_BFu7c  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 BFu1c_BFu15ll_BFu7c) C1{ Fc:1 FL:15 Fc:7}



static void Test_BFu1c_BFu15ll_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu7c");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu7c, BFu1c_BFu15ll_BFu7c)
//============================================================================


struct  BFu1c_BFu15ll_BFu7i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 BFu1c_BFu15ll_BFu7i) C1{ Fc:1 FL:15 Fi:7}



static void Test_BFu1c_BFu15ll_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu7i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu7i, BFu1c_BFu15ll_BFu7i)
//============================================================================


struct  BFu1c_BFu15ll_BFu7ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 BFu1c_BFu15ll_BFu7ll) C1{ Fc:1 FL:15 FL:7}



static void Test_BFu1c_BFu15ll_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu7ll, BFu1c_BFu15ll_BFu7ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu7s  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 BFu1c_BFu15ll_BFu7s) C1{ Fc:1 FL:15 Fs:7}



static void Test_BFu1c_BFu15ll_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu7s");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu7s, BFu1c_BFu15ll_BFu7s)
//============================================================================


struct  BFu1c_BFu15ll_BFu8c  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 BFu1c_BFu15ll_BFu8c) C1{ Fc:1 FL:15 Fc:8}



static void Test_BFu1c_BFu15ll_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu8c");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu8c, BFu1c_BFu15ll_BFu8c)
//============================================================================


struct  BFu1c_BFu15ll_BFu8i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 BFu1c_BFu15ll_BFu8i) C1{ Fc:1 FL:15 Fi:8}



static void Test_BFu1c_BFu15ll_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu8i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu8i, BFu1c_BFu15ll_BFu8i)
//============================================================================


struct  BFu1c_BFu15ll_BFu8ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 BFu1c_BFu15ll_BFu8ll) C1{ Fc:1 FL:15 FL:8}



static void Test_BFu1c_BFu15ll_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu8ll, BFu1c_BFu15ll_BFu8ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu8s  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 BFu1c_BFu15ll_BFu8s) C1{ Fc:1 FL:15 Fs:8}



static void Test_BFu1c_BFu15ll_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu8s");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu8s, BFu1c_BFu15ll_BFu8s)
//============================================================================


struct  BFu1c_BFu15ll_BFu9i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 BFu1c_BFu15ll_BFu9i) C1{ Fc:1 FL:15 Fi:9}



static void Test_BFu1c_BFu15ll_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu9i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu9i, BFu1c_BFu15ll_BFu9i)
//============================================================================


struct  BFu1c_BFu15ll_BFu9ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 BFu1c_BFu15ll_BFu9ll) C1{ Fc:1 FL:15 FL:9}



static void Test_BFu1c_BFu15ll_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu9ll, BFu1c_BFu15ll_BFu9ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu9s  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 BFu1c_BFu15ll_BFu9s) C1{ Fc:1 FL:15 Fs:9}



static void Test_BFu1c_BFu15ll_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu9s");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu9s, BFu1c_BFu15ll_BFu9s)
//============================================================================


struct  BFu1c_BFu15ll_C  {
  unsigned char v1:1;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 BFu1c_BFu15ll_C) C1{ Fc:1 FL:15 Fc}



static void Test_BFu1c_BFu15ll_C()
{
  {
    init_simple_test("BFu1c_BFu15ll_C");
    static STRUCT_IF_C BFu1c_BFu15ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_C");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_C");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_C");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_C, BFu1c_BFu15ll_C)
//============================================================================


struct  BFu1c_BFu15ll_D  {
  unsigned char v1:1;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 BFu1c_BFu15ll_D) C1{ Fc:1 FL:15 FL}



static void Test_BFu1c_BFu15ll_D()
{
  {
    init_simple_test("BFu1c_BFu15ll_D");
    static STRUCT_IF_C BFu1c_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_D");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_D");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_D, BFu1c_BFu15ll_D)
//============================================================================


struct  BFu1c_BFu15ll_F  {
  unsigned char v1:1;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 BFu1c_BFu15ll_F) C1{ Fc:1 FL:15 Fi}



static void Test_BFu1c_BFu15ll_F()
{
  {
    init_simple_test("BFu1c_BFu15ll_F");
    static STRUCT_IF_C BFu1c_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_F");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_F");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_F");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_F, BFu1c_BFu15ll_F)
//============================================================================


struct  BFu1c_BFu15ll_I  {
  unsigned char v1:1;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 BFu1c_BFu15ll_I) C1{ Fc:1 FL:15 Fi}



static void Test_BFu1c_BFu15ll_I()
{
  {
    init_simple_test("BFu1c_BFu15ll_I");
    static STRUCT_IF_C BFu1c_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_I");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_I");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_I");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_I, BFu1c_BFu15ll_I)
//============================================================================


struct  BFu1c_BFu15ll_Ip  {
  unsigned char v1:1;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 BFu1c_BFu15ll_Ip) C1{ Fc:1 FL:15 Fp}



static void Test_BFu1c_BFu15ll_Ip()
{
  {
    init_simple_test("BFu1c_BFu15ll_Ip");
    static STRUCT_IF_C BFu1c_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_Ip, BFu1c_BFu15ll_Ip)
//============================================================================


struct  BFu1c_BFu15ll_L  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 BFu1c_BFu15ll_L) C1{ Fc:1 FL:15 FL}



static void Test_BFu1c_BFu15ll_L()
{
  {
    init_simple_test("BFu1c_BFu15ll_L");
    static STRUCT_IF_C BFu1c_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_L");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_L");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_L, BFu1c_BFu15ll_L)
//============================================================================


struct  BFu1c_BFu15ll_S  {
  unsigned char v1:1;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 BFu1c_BFu15ll_S) C1{ Fc:1 FL:15 Fs}



static void Test_BFu1c_BFu15ll_S()
{
  {
    init_simple_test("BFu1c_BFu15ll_S");
    static STRUCT_IF_C BFu1c_BFu15ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_S");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_S");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_S");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_S, BFu1c_BFu15ll_S)
//============================================================================


struct  BFu1c_BFu15ll_Uc  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 BFu1c_BFu15ll_Uc) C1{ Fc:1 FL:15 Fc}



static void Test_BFu1c_BFu15ll_Uc()
{
  {
    init_simple_test("BFu1c_BFu15ll_Uc");
    static STRUCT_IF_C BFu1c_BFu15ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_Uc");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_Uc, BFu1c_BFu15ll_Uc)
//============================================================================


struct  BFu1c_BFu15ll_Ui  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 BFu1c_BFu15ll_Ui) C1{ Fc:1 FL:15 Fi}



static void Test_BFu1c_BFu15ll_Ui()
{
  {
    init_simple_test("BFu1c_BFu15ll_Ui");
    static STRUCT_IF_C BFu1c_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_Ui, BFu1c_BFu15ll_Ui)
//============================================================================


struct  BFu1c_BFu15ll_Ul  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 BFu1c_BFu15ll_Ul) C1{ Fc:1 FL:15 FL}



static void Test_BFu1c_BFu15ll_Ul()
{
  {
    init_simple_test("BFu1c_BFu15ll_Ul");
    static STRUCT_IF_C BFu1c_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_Ul, BFu1c_BFu15ll_Ul)
//============================================================================


struct  BFu1c_BFu15ll_Us  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 BFu1c_BFu15ll_Us) C1{ Fc:1 FL:15 Fs}



static void Test_BFu1c_BFu15ll_Us()
{
  {
    init_simple_test("BFu1c_BFu15ll_Us");
    static STRUCT_IF_C BFu1c_BFu15ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_Us");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_Us, BFu1c_BFu15ll_Us)
//============================================================================


struct  BFu1c_BFu15ll_Vp  {
  unsigned char v1:1;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 BFu1c_BFu15ll_Vp) C1{ Fc:1 FL:15 Fp}



static void Test_BFu1c_BFu15ll_Vp()
{
  {
    init_simple_test("BFu1c_BFu15ll_Vp");
    static STRUCT_IF_C BFu1c_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_Vp, BFu1c_BFu15ll_Vp)
//============================================================================


struct  BFu1c_BFu15s  {
  unsigned char v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu1c_BFu15s) C1{ Fc:1 Fs:15}



static void Test_BFu1c_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu15s");
    static STRUCT_IF_C BFu1c_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s, BFu1c_BFu15s)
//============================================================================


struct  BFu1c_BFu15s_BFu15i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFu1c_BFu15s_BFu15i) C1{ Fc:1 Fs:15 Fi:15}



static void Test_BFu1c_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu15i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu15i, BFu1c_BFu15s_BFu15i)
//============================================================================


struct  BFu1c_BFu15s_BFu15ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFu1c_BFu15s_BFu15ll) C1{ Fc:1 Fs:15 FL:15}



static void Test_BFu1c_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu15ll, BFu1c_BFu15s_BFu15ll)
//============================================================================


struct  BFu1c_BFu15s_BFu15s  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFu1c_BFu15s_BFu15s) C1{ Fc:1 Fs:15 Fs:15}



static void Test_BFu1c_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu15s");
    static STRUCT_IF_C BFu1c_BFu15s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu15s, BFu1c_BFu15s_BFu15s)
//============================================================================


struct  BFu1c_BFu15s_BFu16i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 BFu1c_BFu15s_BFu16i) C1{ Fc:1 Fs:15 Fi:16}



static void Test_BFu1c_BFu15s_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu16i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu16i, BFu1c_BFu15s_BFu16i)
//============================================================================


struct  BFu1c_BFu15s_BFu16ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 BFu1c_BFu15s_BFu16ll) C1{ Fc:1 Fs:15 FL:16}



static void Test_BFu1c_BFu15s_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu16ll, BFu1c_BFu15s_BFu16ll)
//============================================================================


struct  BFu1c_BFu15s_BFu16s  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 BFu1c_BFu15s_BFu16s) C1{ Fc:1 Fs:15 Fs:16}



static void Test_BFu1c_BFu15s_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu16s");
    static STRUCT_IF_C BFu1c_BFu15s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu16s, BFu1c_BFu15s_BFu16s)
//============================================================================


struct  BFu1c_BFu15s_BFu17i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 BFu1c_BFu15s_BFu17i) C1{ Fc:1 Fs:15 Fi:17}



static void Test_BFu1c_BFu15s_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu17i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1c_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu17i, BFu1c_BFu15s_BFu17i)
//============================================================================


struct  BFu1c_BFu15s_BFu17ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 BFu1c_BFu15s_BFu17ll) C1{ Fc:1 Fs:15 FL:17}



static void Test_BFu1c_BFu15s_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1c_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu17ll, BFu1c_BFu15s_BFu17ll)
//============================================================================


struct  BFu1c_BFu15s_BFu1c  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFu15s_BFu1c) C1{ Fc:1 Fs:15 Fc:1}



static void Test_BFu1c_BFu15s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu1c");
    static STRUCT_IF_C BFu1c_BFu15s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu1c, BFu1c_BFu15s_BFu1c)
//============================================================================


struct  BFu1c_BFu15s_BFu1i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFu15s_BFu1i) C1{ Fc:1 Fs:15 Fi:1}



static void Test_BFu1c_BFu15s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu1i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu1i, BFu1c_BFu15s_BFu1i)
//============================================================================


struct  BFu1c_BFu15s_BFu1ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFu15s_BFu1ll) C1{ Fc:1 Fs:15 FL:1}



static void Test_BFu1c_BFu15s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu1ll, BFu1c_BFu15s_BFu1ll)
//============================================================================


struct  BFu1c_BFu15s_BFu1s  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFu15s_BFu1s) C1{ Fc:1 Fs:15 Fs:1}



static void Test_BFu1c_BFu15s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu1s");
    static STRUCT_IF_C BFu1c_BFu15s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu1s, BFu1c_BFu15s_BFu1s)
//============================================================================


struct  BFu1c_BFu15s_BFu31i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 BFu1c_BFu15s_BFu31i) C1{ Fc:1 Fs:15 Fi:31}



static void Test_BFu1c_BFu15s_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu31i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1c_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu31i, BFu1c_BFu15s_BFu31i)
//============================================================================


struct  BFu1c_BFu15s_BFu31ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:31;
};
//SIG(1 BFu1c_BFu15s_BFu31ll) C1{ Fc:1 Fs:15 FL:31}



static void Test_BFu1c_BFu15s_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1c_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu31ll, BFu1c_BFu15s_BFu31ll)
//============================================================================


struct  BFu1c_BFu15s_BFu32i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:32;
};
//SIG(1 BFu1c_BFu15s_BFu32i) C1{ Fc:1 Fs:15 Fi:32}



static void Test_BFu1c_BFu15s_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu32i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1c_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu32i, BFu1c_BFu15s_BFu32i)
//============================================================================


struct  BFu1c_BFu15s_BFu32ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:32;
};
//SIG(1 BFu1c_BFu15s_BFu32ll) C1{ Fc:1 Fs:15 FL:32}



static void Test_BFu1c_BFu15s_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1c_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu32ll, BFu1c_BFu15s_BFu32ll)
//============================================================================


struct  BFu1c_BFu15s_BFu33  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:33;
};
//SIG(1 BFu1c_BFu15s_BFu33) C1{ Fc:1 Fs:15 FL:33}



static void Test_BFu1c_BFu15s_BFu33()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu33");
    static STRUCT_IF_C BFu1c_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1c_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1c_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu33, BFu1c_BFu15s_BFu33)
//============================================================================


struct  BFu1c_BFu15s_BFu7c  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned char v3:7;
};
//SIG(1 BFu1c_BFu15s_BFu7c) C1{ Fc:1 Fs:15 Fc:7}



static void Test_BFu1c_BFu15s_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu7c");
    static STRUCT_IF_C BFu1c_BFu15s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu7c, BFu1c_BFu15s_BFu7c)
//============================================================================


struct  BFu1c_BFu15s_BFu7i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:7;
};
//SIG(1 BFu1c_BFu15s_BFu7i) C1{ Fc:1 Fs:15 Fi:7}



static void Test_BFu1c_BFu15s_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu7i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu7i, BFu1c_BFu15s_BFu7i)
//============================================================================


struct  BFu1c_BFu15s_BFu7ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:7;
};
//SIG(1 BFu1c_BFu15s_BFu7ll) C1{ Fc:1 Fs:15 FL:7}



static void Test_BFu1c_BFu15s_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu7ll, BFu1c_BFu15s_BFu7ll)
//============================================================================


struct  BFu1c_BFu15s_BFu7s  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned short v3:7;
};
//SIG(1 BFu1c_BFu15s_BFu7s) C1{ Fc:1 Fs:15 Fs:7}



static void Test_BFu1c_BFu15s_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu7s");
    static STRUCT_IF_C BFu1c_BFu15s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu7s, BFu1c_BFu15s_BFu7s)
//============================================================================


struct  BFu1c_BFu15s_BFu8c  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned char v3:8;
};
//SIG(1 BFu1c_BFu15s_BFu8c) C1{ Fc:1 Fs:15 Fc:8}



static void Test_BFu1c_BFu15s_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu8c");
    static STRUCT_IF_C BFu1c_BFu15s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu8c, BFu1c_BFu15s_BFu8c)
//============================================================================


struct  BFu1c_BFu15s_BFu8i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:8;
};
//SIG(1 BFu1c_BFu15s_BFu8i) C1{ Fc:1 Fs:15 Fi:8}



static void Test_BFu1c_BFu15s_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu8i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu8i, BFu1c_BFu15s_BFu8i)
//============================================================================


struct  BFu1c_BFu15s_BFu8ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:8;
};
//SIG(1 BFu1c_BFu15s_BFu8ll) C1{ Fc:1 Fs:15 FL:8}



static void Test_BFu1c_BFu15s_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu8ll, BFu1c_BFu15s_BFu8ll)
//============================================================================


struct  BFu1c_BFu15s_BFu8s  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned short v3:8;
};
//SIG(1 BFu1c_BFu15s_BFu8s) C1{ Fc:1 Fs:15 Fs:8}



static void Test_BFu1c_BFu15s_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu8s");
    static STRUCT_IF_C BFu1c_BFu15s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu8s, BFu1c_BFu15s_BFu8s)
//============================================================================


struct  BFu1c_BFu15s_BFu9i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3:9;
};
//SIG(1 BFu1c_BFu15s_BFu9i) C1{ Fc:1 Fs:15 Fi:9}



static void Test_BFu1c_BFu15s_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu9i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu9i, BFu1c_BFu15s_BFu9i)
//============================================================================


struct  BFu1c_BFu15s_BFu9ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3:9;
};
//SIG(1 BFu1c_BFu15s_BFu9ll) C1{ Fc:1 Fs:15 FL:9}



static void Test_BFu1c_BFu15s_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu9ll, BFu1c_BFu15s_BFu9ll)
//============================================================================


struct  BFu1c_BFu15s_BFu9s  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned short v3:9;
};
//SIG(1 BFu1c_BFu15s_BFu9s) C1{ Fc:1 Fs:15 Fs:9}



static void Test_BFu1c_BFu15s_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu9s");
    static STRUCT_IF_C BFu1c_BFu15s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu9s, BFu1c_BFu15s_BFu9s)
//============================================================================


struct  BFu1c_BFu15s_C  {
  unsigned char v1:1;
  unsigned short v2:15;
  char v3;
};
//SIG(1 BFu1c_BFu15s_C) C1{ Fc:1 Fs:15 Fc}



static void Test_BFu1c_BFu15s_C()
{
  {
    init_simple_test("BFu1c_BFu15s_C");
    static STRUCT_IF_C BFu1c_BFu15s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_C");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_C");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_C");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_C, BFu1c_BFu15s_C)
//============================================================================


struct  BFu1c_BFu15s_D  {
  unsigned char v1:1;
  unsigned short v2:15;
  double v3;
};
//SIG(1 BFu1c_BFu15s_D) C1{ Fc:1 Fs:15 FL}



static void Test_BFu1c_BFu15s_D()
{
  {
    init_simple_test("BFu1c_BFu15s_D");
    static STRUCT_IF_C BFu1c_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_D");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_D");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_D, BFu1c_BFu15s_D)
//============================================================================


struct  BFu1c_BFu15s_F  {
  unsigned char v1:1;
  unsigned short v2:15;
  float v3;
};
//SIG(1 BFu1c_BFu15s_F) C1{ Fc:1 Fs:15 Fi}



static void Test_BFu1c_BFu15s_F()
{
  {
    init_simple_test("BFu1c_BFu15s_F");
    static STRUCT_IF_C BFu1c_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_F");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_F");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_F");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_F, BFu1c_BFu15s_F)
//============================================================================


struct  BFu1c_BFu15s_I  {
  unsigned char v1:1;
  unsigned short v2:15;
  int v3;
};
//SIG(1 BFu1c_BFu15s_I) C1{ Fc:1 Fs:15 Fi}



static void Test_BFu1c_BFu15s_I()
{
  {
    init_simple_test("BFu1c_BFu15s_I");
    static STRUCT_IF_C BFu1c_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_I");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_I");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_I");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_I, BFu1c_BFu15s_I)
//============================================================================


struct  BFu1c_BFu15s_Ip  {
  unsigned char v1:1;
  unsigned short v2:15;
  int *v3;
};
//SIG(1 BFu1c_BFu15s_Ip) C1{ Fc:1 Fs:15 Fp}



static void Test_BFu1c_BFu15s_Ip()
{
  {
    init_simple_test("BFu1c_BFu15s_Ip");
    static STRUCT_IF_C BFu1c_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_Ip");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_Ip, BFu1c_BFu15s_Ip)
//============================================================================


struct  BFu1c_BFu15s_L  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsi64 v3;
};
//SIG(1 BFu1c_BFu15s_L) C1{ Fc:1 Fs:15 FL}



static void Test_BFu1c_BFu15s_L()
{
  {
    init_simple_test("BFu1c_BFu15s_L");
    static STRUCT_IF_C BFu1c_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_L");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_L");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_L, BFu1c_BFu15s_L)
//============================================================================


struct  BFu1c_BFu15s_S  {
  unsigned char v1:1;
  unsigned short v2:15;
  short v3;
};
//SIG(1 BFu1c_BFu15s_S) C1{ Fc:1 Fs:15 Fs}



static void Test_BFu1c_BFu15s_S()
{
  {
    init_simple_test("BFu1c_BFu15s_S");
    static STRUCT_IF_C BFu1c_BFu15s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_S");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_S");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_S");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_S, BFu1c_BFu15s_S)
//============================================================================


struct  BFu1c_BFu15s_Uc  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned char v3;
};
//SIG(1 BFu1c_BFu15s_Uc) C1{ Fc:1 Fs:15 Fc}



static void Test_BFu1c_BFu15s_Uc()
{
  {
    init_simple_test("BFu1c_BFu15s_Uc");
    static STRUCT_IF_C BFu1c_BFu15s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_Uc");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_Uc");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_Uc, BFu1c_BFu15s_Uc)
//============================================================================


struct  BFu1c_BFu15s_Ui  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int v3;
};
//SIG(1 BFu1c_BFu15s_Ui) C1{ Fc:1 Fs:15 Fi}



static void Test_BFu1c_BFu15s_Ui()
{
  {
    init_simple_test("BFu1c_BFu15s_Ui");
    static STRUCT_IF_C BFu1c_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu15s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_Ui");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_Ui");
    check_field_offset(lv, v3, 4, "BFu1c_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_Ui, BFu1c_BFu15s_Ui)
//============================================================================


struct  BFu1c_BFu15s_Ul  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64 v3;
};
//SIG(1 BFu1c_BFu15s_Ul) C1{ Fc:1 Fs:15 FL}



static void Test_BFu1c_BFu15s_Ul()
{
  {
    init_simple_test("BFu1c_BFu15s_Ul");
    static STRUCT_IF_C BFu1c_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_Ul");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_Ul, BFu1c_BFu15s_Ul)
//============================================================================


struct  BFu1c_BFu15s_Us  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 BFu1c_BFu15s_Us) C1{ Fc:1 Fs:15 Fs}



static void Test_BFu1c_BFu15s_Us()
{
  {
    init_simple_test("BFu1c_BFu15s_Us");
    static STRUCT_IF_C BFu1c_BFu15s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_Us");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_Us");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_Us, BFu1c_BFu15s_Us)
//============================================================================


struct  BFu1c_BFu15s_Vp  {
  unsigned char v1:1;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 BFu1c_BFu15s_Vp) C1{ Fc:1 Fs:15 Fp}



static void Test_BFu1c_BFu15s_Vp()
{
  {
    init_simple_test("BFu1c_BFu15s_Vp");
    static STRUCT_IF_C BFu1c_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_Vp");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_Vp, BFu1c_BFu15s_Vp)
//============================================================================


struct  BFu1c_BFu16i  {
  unsigned char v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu1c_BFu16i) C1{ Fc:1 Fi:16}



static void Test_BFu1c_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu16i");
    static STRUCT_IF_C BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i, BFu1c_BFu16i)
//============================================================================


struct  BFu1c_BFu16i_BFu15i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 BFu1c_BFu16i_BFu15i) C1{ Fc:1 Fi:16 Fi:15}



static void Test_BFu1c_BFu16i_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu15i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1c_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu15i, BFu1c_BFu16i_BFu15i)
//============================================================================


struct  BFu1c_BFu16i_BFu15ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 BFu1c_BFu16i_BFu15ll) C1{ Fc:1 Fi:16 FL:15}



static void Test_BFu1c_BFu16i_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1c_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu15ll, BFu1c_BFu16i_BFu15ll)
//============================================================================


struct  BFu1c_BFu16i_BFu15s  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 BFu1c_BFu16i_BFu15s) C1{ Fc:1 Fi:16 Fs:15}



static void Test_BFu1c_BFu16i_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu15s");
    static STRUCT_IF_C BFu1c_BFu16i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1c_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu15s, BFu1c_BFu16i_BFu15s)
//============================================================================


struct  BFu1c_BFu16i_BFu16i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 BFu1c_BFu16i_BFu16i) C1{ Fc:1 Fi:16 Fi:16}



static void Test_BFu1c_BFu16i_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu16i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1c_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu16i, BFu1c_BFu16i_BFu16i)
//============================================================================


struct  BFu1c_BFu16i_BFu16ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 BFu1c_BFu16i_BFu16ll) C1{ Fc:1 Fi:16 FL:16}



static void Test_BFu1c_BFu16i_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "BFu1c_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu16ll, BFu1c_BFu16i_BFu16ll)
//============================================================================


struct  BFu1c_BFu16i_BFu16s  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 BFu1c_BFu16i_BFu16s) C1{ Fc:1 Fi:16 Fs:16}



static void Test_BFu1c_BFu16i_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu16s");
    static STRUCT_IF_C BFu1c_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1c_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu16s, BFu1c_BFu16i_BFu16s)
//============================================================================


struct  BFu1c_BFu16i_BFu17i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 BFu1c_BFu16i_BFu17i) C1{ Fc:1 Fi:16 Fi:17}



static void Test_BFu1c_BFu16i_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu17i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1c_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu17i, BFu1c_BFu16i_BFu17i)
//============================================================================


struct  BFu1c_BFu16i_BFu17ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 BFu1c_BFu16i_BFu17ll) C1{ Fc:1 Fi:16 FL:17}



static void Test_BFu1c_BFu16i_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "BFu1c_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu17ll, BFu1c_BFu16i_BFu17ll)
//============================================================================


struct  BFu1c_BFu16i_BFu1c  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFu16i_BFu1c) C1{ Fc:1 Fi:16 Fc:1}



static void Test_BFu1c_BFu16i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu1c");
    static STRUCT_IF_C BFu1c_BFu16i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1c_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu1c, BFu1c_BFu16i_BFu1c)
//============================================================================


struct  BFu1c_BFu16i_BFu1i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFu16i_BFu1i) C1{ Fc:1 Fi:16 Fi:1}



static void Test_BFu1c_BFu16i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu1i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1c_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu1i, BFu1c_BFu16i_BFu1i)
//============================================================================


struct  BFu1c_BFu16i_BFu1ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFu16i_BFu1ll) C1{ Fc:1 Fi:16 FL:1}



static void Test_BFu1c_BFu16i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1c_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu1ll, BFu1c_BFu16i_BFu1ll)
//============================================================================


struct  BFu1c_BFu16i_BFu1s  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFu16i_BFu1s) C1{ Fc:1 Fi:16 Fs:1}



static void Test_BFu1c_BFu16i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu1s");
    static STRUCT_IF_C BFu1c_BFu16i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1c_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu1s, BFu1c_BFu16i_BFu1s)
//============================================================================


struct  BFu1c_BFu16i_BFu31i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 BFu1c_BFu16i_BFu31i) C1{ Fc:1 Fi:16 Fi:31}



static void Test_BFu1c_BFu16i_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu31i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1c_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu31i, BFu1c_BFu16i_BFu31i)
//============================================================================


struct  BFu1c_BFu16i_BFu31ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 BFu1c_BFu16i_BFu31ll) C1{ Fc:1 Fi:16 FL:31}



static void Test_BFu1c_BFu16i_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "BFu1c_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu31ll, BFu1c_BFu16i_BFu31ll)
//============================================================================


struct  BFu1c_BFu16i_BFu32i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 BFu1c_BFu16i_BFu32i) C1{ Fc:1 Fi:16 Fi:32}



static void Test_BFu1c_BFu16i_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu32i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1c_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu32i, BFu1c_BFu16i_BFu32i)
//============================================================================


struct  BFu1c_BFu16i_BFu32ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 BFu1c_BFu16i_BFu32ll) C1{ Fc:1 Fi:16 FL:32}



static void Test_BFu1c_BFu16i_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "BFu1c_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "BFu1c_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu32ll, BFu1c_BFu16i_BFu32ll)
//============================================================================


struct  BFu1c_BFu16i_BFu33  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 BFu1c_BFu16i_BFu33) C1{ Fc:1 Fi:16 FL:33}



static void Test_BFu1c_BFu16i_BFu33()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu33");
    static STRUCT_IF_C BFu1c_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "BFu1c_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "BFu1c_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu33, BFu1c_BFu16i_BFu33)
//============================================================================


struct  BFu1c_BFu16i_BFu7c  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 BFu1c_BFu16i_BFu7c) C1{ Fc:1 Fi:16 Fc:7}



static void Test_BFu1c_BFu16i_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu7c");
    static STRUCT_IF_C BFu1c_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1c_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu7c, BFu1c_BFu16i_BFu7c)
//============================================================================


struct  BFu1c_BFu16i_BFu7i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 BFu1c_BFu16i_BFu7i) C1{ Fc:1 Fi:16 Fi:7}



static void Test_BFu1c_BFu16i_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu7i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1c_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu7i, BFu1c_BFu16i_BFu7i)
//============================================================================


struct  BFu1c_BFu16i_BFu7ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 BFu1c_BFu16i_BFu7ll) C1{ Fc:1 Fi:16 FL:7}



static void Test_BFu1c_BFu16i_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1c_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu7ll, BFu1c_BFu16i_BFu7ll)
//============================================================================


struct  BFu1c_BFu16i_BFu7s  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 BFu1c_BFu16i_BFu7s) C1{ Fc:1 Fi:16 Fs:7}



static void Test_BFu1c_BFu16i_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu7s");
    static STRUCT_IF_C BFu1c_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1c_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu7s, BFu1c_BFu16i_BFu7s)
//============================================================================


struct  BFu1c_BFu16i_BFu8c  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 BFu1c_BFu16i_BFu8c) C1{ Fc:1 Fi:16 Fc:8}



static void Test_BFu1c_BFu16i_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu8c");
    static STRUCT_IF_C BFu1c_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu1c_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu8c, BFu1c_BFu16i_BFu8c)
//============================================================================


struct  BFu1c_BFu16i_BFu8i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 BFu1c_BFu16i_BFu8i) C1{ Fc:1 Fi:16 Fi:8}



static void Test_BFu1c_BFu16i_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu8i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1c_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu8i, BFu1c_BFu16i_BFu8i)
//============================================================================


struct  BFu1c_BFu16i_BFu8ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 BFu1c_BFu16i_BFu8ll) C1{ Fc:1 Fi:16 FL:8}



static void Test_BFu1c_BFu16i_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1c_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu8ll, BFu1c_BFu16i_BFu8ll)
//============================================================================


struct  BFu1c_BFu16i_BFu8s  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 BFu1c_BFu16i_BFu8s) C1{ Fc:1 Fi:16 Fs:8}



static void Test_BFu1c_BFu16i_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu8s");
    static STRUCT_IF_C BFu1c_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1c_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu8s, BFu1c_BFu16i_BFu8s)
//============================================================================


struct  BFu1c_BFu16i_BFu9i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 BFu1c_BFu16i_BFu9i) C1{ Fc:1 Fi:16 Fi:9}



static void Test_BFu1c_BFu16i_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu9i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1c_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu9i, BFu1c_BFu16i_BFu9i)
//============================================================================


struct  BFu1c_BFu16i_BFu9ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 BFu1c_BFu16i_BFu9ll) C1{ Fc:1 Fi:16 FL:9}



static void Test_BFu1c_BFu16i_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1c_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu9ll, BFu1c_BFu16i_BFu9ll)
//============================================================================


struct  BFu1c_BFu16i_BFu9s  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 BFu1c_BFu16i_BFu9s) C1{ Fc:1 Fi:16 Fs:9}



static void Test_BFu1c_BFu16i_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu9s");
    static STRUCT_IF_C BFu1c_BFu16i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1c_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu9s, BFu1c_BFu16i_BFu9s)
//============================================================================


struct  BFu1c_BFu16i_C  {
  unsigned char v1:1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 BFu1c_BFu16i_C) C1{ Fc:1 Fi:16 Fc}



static void Test_BFu1c_BFu16i_C()
{
  {
    init_simple_test("BFu1c_BFu16i_C");
    static STRUCT_IF_C BFu1c_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_C");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_C");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_C");
    check_field_offset(lv, v3, 3, "BFu1c_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_C, BFu1c_BFu16i_C)
//============================================================================


struct  BFu1c_BFu16i_D  {
  unsigned char v1:1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 BFu1c_BFu16i_D) C1{ Fc:1 Fi:16 FL}



static void Test_BFu1c_BFu16i_D()
{
  {
    init_simple_test("BFu1c_BFu16i_D");
    static STRUCT_IF_C BFu1c_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_D");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_D");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_D, BFu1c_BFu16i_D)
//============================================================================


struct  BFu1c_BFu16i_F  {
  unsigned char v1:1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 BFu1c_BFu16i_F) C1{ Fc:1 Fi:16 Fi}



static void Test_BFu1c_BFu16i_F()
{
  {
    init_simple_test("BFu1c_BFu16i_F");
    static STRUCT_IF_C BFu1c_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_F");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_F");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_F");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_F, BFu1c_BFu16i_F)
//============================================================================


struct  BFu1c_BFu16i_I  {
  unsigned char v1:1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 BFu1c_BFu16i_I) C1{ Fc:1 Fi:16 Fi}



static void Test_BFu1c_BFu16i_I()
{
  {
    init_simple_test("BFu1c_BFu16i_I");
    static STRUCT_IF_C BFu1c_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_I");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_I");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_I");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_I, BFu1c_BFu16i_I)
//============================================================================


struct  BFu1c_BFu16i_Ip  {
  unsigned char v1:1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 BFu1c_BFu16i_Ip) C1{ Fc:1 Fi:16 Fp}



static void Test_BFu1c_BFu16i_Ip()
{
  {
    init_simple_test("BFu1c_BFu16i_Ip");
    static STRUCT_IF_C BFu1c_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_Ip");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_Ip, BFu1c_BFu16i_Ip)
//============================================================================


struct  BFu1c_BFu16i_L  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 BFu1c_BFu16i_L) C1{ Fc:1 Fi:16 FL}



static void Test_BFu1c_BFu16i_L()
{
  {
    init_simple_test("BFu1c_BFu16i_L");
    static STRUCT_IF_C BFu1c_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_L");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_L");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_L, BFu1c_BFu16i_L)
//============================================================================


struct  BFu1c_BFu16i_S  {
  unsigned char v1:1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 BFu1c_BFu16i_S) C1{ Fc:1 Fi:16 Fs}



static void Test_BFu1c_BFu16i_S()
{
  {
    init_simple_test("BFu1c_BFu16i_S");
    static STRUCT_IF_C BFu1c_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_S");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_S");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_S");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_S, BFu1c_BFu16i_S)
//============================================================================


struct  BFu1c_BFu16i_Uc  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 BFu1c_BFu16i_Uc) C1{ Fc:1 Fi:16 Fc}



static void Test_BFu1c_BFu16i_Uc()
{
  {
    init_simple_test("BFu1c_BFu16i_Uc");
    static STRUCT_IF_C BFu1c_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_Uc");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_Uc");
    check_field_offset(lv, v3, 3, "BFu1c_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_Uc, BFu1c_BFu16i_Uc)
//============================================================================


struct  BFu1c_BFu16i_Ui  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 BFu1c_BFu16i_Ui) C1{ Fc:1 Fi:16 Fi}



static void Test_BFu1c_BFu16i_Ui()
{
  {
    init_simple_test("BFu1c_BFu16i_Ui");
    static STRUCT_IF_C BFu1c_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_Ui");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_Ui, BFu1c_BFu16i_Ui)
//============================================================================


struct  BFu1c_BFu16i_Ul  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 BFu1c_BFu16i_Ul) C1{ Fc:1 Fi:16 FL}



static void Test_BFu1c_BFu16i_Ul()
{
  {
    init_simple_test("BFu1c_BFu16i_Ul");
    static STRUCT_IF_C BFu1c_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_Ul");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_Ul, BFu1c_BFu16i_Ul)
//============================================================================


struct  BFu1c_BFu16i_Us  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 BFu1c_BFu16i_Us) C1{ Fc:1 Fi:16 Fs}



static void Test_BFu1c_BFu16i_Us()
{
  {
    init_simple_test("BFu1c_BFu16i_Us");
    static STRUCT_IF_C BFu1c_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_Us");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_Us");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_Us");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_Us, BFu1c_BFu16i_Us)
//============================================================================


struct  BFu1c_BFu16i_Vp  {
  unsigned char v1:1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 BFu1c_BFu16i_Vp) C1{ Fc:1 Fi:16 Fp}



static void Test_BFu1c_BFu16i_Vp()
{
  {
    init_simple_test("BFu1c_BFu16i_Vp");
    static STRUCT_IF_C BFu1c_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_Vp");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_Vp, BFu1c_BFu16i_Vp)
//============================================================================


struct  BFu1c_BFu16ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu1c_BFu16ll) C1{ Fc:1 FL:16}



static void Test_BFu1c_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll, BFu1c_BFu16ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu15i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 BFu1c_BFu16ll_BFu15i) C1{ Fc:1 FL:16 Fi:15}



static void Test_BFu1c_BFu16ll_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu15i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1c_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu15i, BFu1c_BFu16ll_BFu15i)
//============================================================================


struct  BFu1c_BFu16ll_BFu15ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 BFu1c_BFu16ll_BFu15ll) C1{ Fc:1 FL:16 FL:15}



static void Test_BFu1c_BFu16ll_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1c_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu15ll, BFu1c_BFu16ll_BFu15ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu15s  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 BFu1c_BFu16ll_BFu15s) C1{ Fc:1 FL:16 Fs:15}



static void Test_BFu1c_BFu16ll_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu15s");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "BFu1c_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu15s, BFu1c_BFu16ll_BFu15s)
//============================================================================


struct  BFu1c_BFu16ll_BFu16i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 BFu1c_BFu16ll_BFu16i) C1{ Fc:1 FL:16 Fi:16}



static void Test_BFu1c_BFu16ll_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu16i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1c_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu16i, BFu1c_BFu16ll_BFu16i)
//============================================================================


struct  BFu1c_BFu16ll_BFu16ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 BFu1c_BFu16ll_BFu16ll) C1{ Fc:1 FL:16 FL:16}



static void Test_BFu1c_BFu16ll_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "BFu1c_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu16ll, BFu1c_BFu16ll_BFu16ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu16s  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 BFu1c_BFu16ll_BFu16s) C1{ Fc:1 FL:16 Fs:16}



static void Test_BFu1c_BFu16ll_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu16s");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu1c_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu16s, BFu1c_BFu16ll_BFu16s)
//============================================================================


struct  BFu1c_BFu16ll_BFu17i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 BFu1c_BFu16ll_BFu17i) C1{ Fc:1 FL:16 Fi:17}



static void Test_BFu1c_BFu16ll_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu17i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1c_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu17i, BFu1c_BFu16ll_BFu17i)
//============================================================================


struct  BFu1c_BFu16ll_BFu17ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 BFu1c_BFu16ll_BFu17ll) C1{ Fc:1 FL:16 FL:17}



static void Test_BFu1c_BFu16ll_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "BFu1c_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu17ll, BFu1c_BFu16ll_BFu17ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu1c  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 BFu1c_BFu16ll_BFu1c) C1{ Fc:1 FL:16 Fc:1}



static void Test_BFu1c_BFu16ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1c_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu1c, BFu1c_BFu16ll_BFu1c)
//============================================================================


struct  BFu1c_BFu16ll_BFu1i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 BFu1c_BFu16ll_BFu1i) C1{ Fc:1 FL:16 Fi:1}



static void Test_BFu1c_BFu16ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1c_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu1i, BFu1c_BFu16ll_BFu1i)
//============================================================================


struct  BFu1c_BFu16ll_BFu1ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_BFu16ll_BFu1ll) C1{ Fc:1 FL:16 FL:1}



static void Test_BFu1c_BFu16ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1c_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu1ll, BFu1c_BFu16ll_BFu1ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu1s  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 BFu1c_BFu16ll_BFu1s) C1{ Fc:1 FL:16 Fs:1}



static void Test_BFu1c_BFu16ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "BFu1c_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu1s, BFu1c_BFu16ll_BFu1s)
//============================================================================


struct  BFu1c_BFu16ll_BFu31i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 BFu1c_BFu16ll_BFu31i) C1{ Fc:1 FL:16 Fi:31}



static void Test_BFu1c_BFu16ll_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu31i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1c_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu31i, BFu1c_BFu16ll_BFu31i)
//============================================================================


struct  BFu1c_BFu16ll_BFu31ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 BFu1c_BFu16ll_BFu31ll) C1{ Fc:1 FL:16 FL:31}



static void Test_BFu1c_BFu16ll_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "BFu1c_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu31ll, BFu1c_BFu16ll_BFu31ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu32i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 BFu1c_BFu16ll_BFu32i) C1{ Fc:1 FL:16 Fi:32}



static void Test_BFu1c_BFu16ll_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu32i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1c_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu32i, BFu1c_BFu16ll_BFu32i)
//============================================================================


struct  BFu1c_BFu16ll_BFu32ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 BFu1c_BFu16ll_BFu32ll) C1{ Fc:1 FL:16 FL:32}



static void Test_BFu1c_BFu16ll_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "BFu1c_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "BFu1c_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu32ll, BFu1c_BFu16ll_BFu32ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu33  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 BFu1c_BFu16ll_BFu33) C1{ Fc:1 FL:16 FL:33}



static void Test_BFu1c_BFu16ll_BFu33()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu33");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "BFu1c_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "BFu1c_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu33, BFu1c_BFu16ll_BFu33)
//============================================================================


struct  BFu1c_BFu16ll_BFu7c  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 BFu1c_BFu16ll_BFu7c) C1{ Fc:1 FL:16 Fc:7}



static void Test_BFu1c_BFu16ll_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu7c");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1c_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu7c, BFu1c_BFu16ll_BFu7c)
//============================================================================


struct  BFu1c_BFu16ll_BFu7i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 BFu1c_BFu16ll_BFu7i) C1{ Fc:1 FL:16 Fi:7}



static void Test_BFu1c_BFu16ll_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu7i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1c_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu7i, BFu1c_BFu16ll_BFu7i)
//============================================================================


struct  BFu1c_BFu16ll_BFu7ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 BFu1c_BFu16ll_BFu7ll) C1{ Fc:1 FL:16 FL:7}



static void Test_BFu1c_BFu16ll_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1c_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu7ll, BFu1c_BFu16ll_BFu7ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu7s  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 BFu1c_BFu16ll_BFu7s) C1{ Fc:1 FL:16 Fs:7}



static void Test_BFu1c_BFu16ll_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu7s");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "BFu1c_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu7s, BFu1c_BFu16ll_BFu7s)
//============================================================================


struct  BFu1c_BFu16ll_BFu8c  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 BFu1c_BFu16ll_BFu8c) C1{ Fc:1 FL:16 Fc:8}



static void Test_BFu1c_BFu16ll_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu8c");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu1c_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu8c, BFu1c_BFu16ll_BFu8c)
//============================================================================


struct  BFu1c_BFu16ll_BFu8i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 BFu1c_BFu16ll_BFu8i) C1{ Fc:1 FL:16 Fi:8}



static void Test_BFu1c_BFu16ll_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu8i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1c_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu8i, BFu1c_BFu16ll_BFu8i)
//============================================================================


struct  BFu1c_BFu16ll_BFu8ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 BFu1c_BFu16ll_BFu8ll) C1{ Fc:1 FL:16 FL:8}



static void Test_BFu1c_BFu16ll_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1c_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu8ll, BFu1c_BFu16ll_BFu8ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu8s  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 BFu1c_BFu16ll_BFu8s) C1{ Fc:1 FL:16 Fs:8}



static void Test_BFu1c_BFu16ll_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu8s");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "BFu1c_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu8s, BFu1c_BFu16ll_BFu8s)
//============================================================================


struct  BFu1c_BFu16ll_BFu9i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 BFu1c_BFu16ll_BFu9i) C1{ Fc:1 FL:16 Fi:9}



static void Test_BFu1c_BFu16ll_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu9i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1c_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu9i, BFu1c_BFu16ll_BFu9i)
//============================================================================


struct  BFu1c_BFu16ll_BFu9ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 BFu1c_BFu16ll_BFu9ll) C1{ Fc:1 FL:16 FL:9}



static void Test_BFu1c_BFu16ll_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1c_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu9ll, BFu1c_BFu16ll_BFu9ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu9s  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 BFu1c_BFu16ll_BFu9s) C1{ Fc:1 FL:16 Fs:9}



static void Test_BFu1c_BFu16ll_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu9s");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "BFu1c_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu9s, BFu1c_BFu16ll_BFu9s)
//============================================================================


struct  BFu1c_BFu16ll_C  {
  unsigned char v1:1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 BFu1c_BFu16ll_C) C1{ Fc:1 FL:16 Fc}



static void Test_BFu1c_BFu16ll_C()
{
  {
    init_simple_test("BFu1c_BFu16ll_C");
    static STRUCT_IF_C BFu1c_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_C");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_C");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_C");
    check_field_offset(lv, v3, 3, "BFu1c_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_C, BFu1c_BFu16ll_C)
//============================================================================


struct  BFu1c_BFu16ll_D  {
  unsigned char v1:1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 BFu1c_BFu16ll_D) C1{ Fc:1 FL:16 FL}



static void Test_BFu1c_BFu16ll_D()
{
  {
    init_simple_test("BFu1c_BFu16ll_D");
    static STRUCT_IF_C BFu1c_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_D");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_D");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_D, BFu1c_BFu16ll_D)
//============================================================================


struct  BFu1c_BFu16ll_F  {
  unsigned char v1:1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 BFu1c_BFu16ll_F) C1{ Fc:1 FL:16 Fi}



static void Test_BFu1c_BFu16ll_F()
{
  {
    init_simple_test("BFu1c_BFu16ll_F");
    static STRUCT_IF_C BFu1c_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_F");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_F");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_F");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_F, BFu1c_BFu16ll_F)
//============================================================================


struct  BFu1c_BFu16ll_I  {
  unsigned char v1:1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 BFu1c_BFu16ll_I) C1{ Fc:1 FL:16 Fi}



static void Test_BFu1c_BFu16ll_I()
{
  {
    init_simple_test("BFu1c_BFu16ll_I");
    static STRUCT_IF_C BFu1c_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_I");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_I");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_I");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_I, BFu1c_BFu16ll_I)
//============================================================================


struct  BFu1c_BFu16ll_Ip  {
  unsigned char v1:1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 BFu1c_BFu16ll_Ip) C1{ Fc:1 FL:16 Fp}



static void Test_BFu1c_BFu16ll_Ip()
{
  {
    init_simple_test("BFu1c_BFu16ll_Ip");
    static STRUCT_IF_C BFu1c_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_Ip, BFu1c_BFu16ll_Ip)
//============================================================================


struct  BFu1c_BFu16ll_L  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 BFu1c_BFu16ll_L) C1{ Fc:1 FL:16 FL}



static void Test_BFu1c_BFu16ll_L()
{
  {
    init_simple_test("BFu1c_BFu16ll_L");
    static STRUCT_IF_C BFu1c_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_L");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_L");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_L, BFu1c_BFu16ll_L)
//============================================================================


struct  BFu1c_BFu16ll_S  {
  unsigned char v1:1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 BFu1c_BFu16ll_S) C1{ Fc:1 FL:16 Fs}



static void Test_BFu1c_BFu16ll_S()
{
  {
    init_simple_test("BFu1c_BFu16ll_S");
    static STRUCT_IF_C BFu1c_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_S");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_S");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_S");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_S, BFu1c_BFu16ll_S)
//============================================================================


struct  BFu1c_BFu16ll_Uc  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 BFu1c_BFu16ll_Uc) C1{ Fc:1 FL:16 Fc}



static void Test_BFu1c_BFu16ll_Uc()
{
  {
    init_simple_test("BFu1c_BFu16ll_Uc");
    static STRUCT_IF_C BFu1c_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "BFu1c_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_Uc, BFu1c_BFu16ll_Uc)
//============================================================================


struct  BFu1c_BFu16ll_Ui  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 BFu1c_BFu16ll_Ui) C1{ Fc:1 FL:16 Fi}



static void Test_BFu1c_BFu16ll_Ui()
{
  {
    init_simple_test("BFu1c_BFu16ll_Ui");
    static STRUCT_IF_C BFu1c_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_Ui, BFu1c_BFu16ll_Ui)
//============================================================================


struct  BFu1c_BFu16ll_Ul  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 BFu1c_BFu16ll_Ul) C1{ Fc:1 FL:16 FL}



static void Test_BFu1c_BFu16ll_Ul()
{
  {
    init_simple_test("BFu1c_BFu16ll_Ul");
    static STRUCT_IF_C BFu1c_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "B