// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFu15ll_BFu15ll_BFu15i_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15i_BFu15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFu15ll_BFu15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15i_BFu15ll, BFu15ll_BFu15ll_BFu15i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15i_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15i_BFu15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFu15ll_BFu15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15i_BFu15s, BFu15ll_BFu15ll_BFu15i_BFu15s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15ll) C1{ FL:15 FL:15 FL:15}



static void Test_BFu15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15ll, BFu15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15ll_BFs15i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15ll_BFs15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFu15ll_BFu15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15ll_BFs15i, BFu15ll_BFu15ll_BFu15ll_BFs15i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15ll_BFs15ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15ll_BFs15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFu15ll_BFu15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15ll_BFs15ll, BFu15ll_BFu15ll_BFu15ll_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15ll_BFs15s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15ll_BFs15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFu15ll_BFu15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15ll_BFs15s, BFu15ll_BFu15ll_BFu15ll_BFs15s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15ll_BFu15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFu15ll_BFu15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15ll_BFu15i, BFu15ll_BFu15ll_BFu15ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15ll_BFu15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFu15ll_BFu15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15ll_BFu15ll, BFu15ll_BFu15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15ll_BFu15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFu15ll_BFu15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15ll_BFu15s, BFu15ll_BFu15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15s) C1{ FL:15 FL:15 Fs:15}



static void Test_BFu15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15s, BFu15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15s_BFs15i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15s_BFs15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFu15ll_BFu15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15s_BFs15i, BFu15ll_BFu15ll_BFu15s_BFs15i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15s_BFs15ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15s_BFs15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFu15ll_BFu15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15s_BFs15ll, BFu15ll_BFu15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15s_BFs15s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15s_BFs15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFu15ll_BFu15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15s_BFs15s, BFu15ll_BFu15ll_BFu15s_BFs15s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15s_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15s_BFu15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFu15ll_BFu15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15s_BFu15i, BFu15ll_BFu15ll_BFu15s_BFu15i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15s_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15s_BFu15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFu15ll_BFu15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15s_BFu15ll, BFu15ll_BFu15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu15s_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15ll_BFu15s_BFu15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFu15ll_BFu15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu15s_BFu15s, BFu15ll_BFu15ll_BFu15s_BFu15s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu15ll_BFu16i) C1{ FL:15 FL:15 Fi:16}



static void Test_BFu15ll_BFu15ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu16i, BFu15ll_BFu15ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu15ll_BFu16ll) C1{ FL:15 FL:15 FL:16}



static void Test_BFu15ll_BFu15ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 6, 16, 1, "BFu15ll_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 6, 16, hide_ull(1LL<<15), "BFu15ll_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu16ll, BFu15ll_BFu15ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu15ll_BFu16s) C1{ FL:15 FL:15 Fs:16}



static void Test_BFu15ll_BFu15ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu16s, BFu15ll_BFu15ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu15ll_BFu17i) C1{ FL:15 FL:15 Fi:17}



static void Test_BFu15ll_BFu15ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu17i, BFu15ll_BFu15ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu15ll_BFu17ll) C1{ FL:15 FL:15 FL:17}



static void Test_BFu15ll_BFu15ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 6, 17, 1, "BFu15ll_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 6, 17, hide_ull(1LL<<16), "BFu15ll_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu17ll, BFu15ll_BFu15ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu15ll_BFu1c) C1{ FL:15 FL:15 Fc:1}



static void Test_BFu15ll_BFu15ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 6, 1, 1, "BFu15ll_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu1c, BFu15ll_BFu15ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu15ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu15ll_BFu1i) C1{ FL:15 FL:15 Fi:1}



static void Test_BFu15ll_BFu15ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 6, 1, 1, "BFu15ll_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu1i, BFu15ll_BFu15ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu15ll_BFu1ll) C1{ FL:15 FL:15 FL:1}



static void Test_BFu15ll_BFu15ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 6, 1, 1, "BFu15ll_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu1ll, BFu15ll_BFu15ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu15ll_BFu1s) C1{ FL:15 FL:15 Fs:1}



static void Test_BFu15ll_BFu15ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 6, 1, 1, "BFu15ll_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu1s, BFu15ll_BFu15ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu15ll_BFu31i) C1{ FL:15 FL:15 Fi:31}



static void Test_BFu15ll_BFu15ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu31i, BFu15ll_BFu15ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu15ll_BFu31ll) C1{ FL:15 FL:15 FL:31}



static void Test_BFu15ll_BFu15ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 6, 31, 1, "BFu15ll_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 6, 31, hide_ull(1LL<<30), "BFu15ll_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu31ll, BFu15ll_BFu15ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu15ll_BFu32i) C1{ FL:15 FL:15 Fi:32}



static void Test_BFu15ll_BFu15ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu32i, BFu15ll_BFu15ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu15ll_BFu32ll) C1{ FL:15 FL:15 FL:32}



static void Test_BFu15ll_BFu15ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 6, 32, 1, "BFu15ll_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 6, 32, hide_ull(1LL<<31), "BFu15ll_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu32ll, BFu15ll_BFu15ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu15ll_BFu33) C1{ FL:15 FL:15 FL:33}



static void Test_BFu15ll_BFu15ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 6, 33, 1, "BFu15ll_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 6, 33, hide_ull(1LL<<32), "BFu15ll_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu33, BFu15ll_BFu15ll_BFu33)
//============================================================================


struct  BFu15ll_BFu15ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu15ll_BFu7c) C1{ FL:15 FL:15 Fc:7}



static void Test_BFu15ll_BFu15ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu7c, BFu15ll_BFu15ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu15ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu15ll_BFu7i) C1{ FL:15 FL:15 Fi:7}



static void Test_BFu15ll_BFu15ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu7i, BFu15ll_BFu15ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu15ll_BFu7ll) C1{ FL:15 FL:15 FL:7}



static void Test_BFu15ll_BFu15ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 6, 7, 1, "BFu15ll_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu7ll, BFu15ll_BFu15ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu15ll_BFu7s) C1{ FL:15 FL:15 Fs:7}



static void Test_BFu15ll_BFu15ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu7s, BFu15ll_BFu15ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu15ll_BFu8c) C1{ FL:15 FL:15 Fc:8}



static void Test_BFu15ll_BFu15ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu8c, BFu15ll_BFu15ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu15ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu15ll_BFu8i) C1{ FL:15 FL:15 Fi:8}



static void Test_BFu15ll_BFu15ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu8i, BFu15ll_BFu15ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu15ll_BFu8ll) C1{ FL:15 FL:15 FL:8}



static void Test_BFu15ll_BFu15ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 6, 8, 1, "BFu15ll_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu8ll, BFu15ll_BFu15ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu15ll_BFu8s) C1{ FL:15 FL:15 Fs:8}



static void Test_BFu15ll_BFu15ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu8s, BFu15ll_BFu15ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu15ll_BFu9i) C1{ FL:15 FL:15 Fi:9}



static void Test_BFu15ll_BFu15ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu9i, BFu15ll_BFu15ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu15ll_BFu9ll) C1{ FL:15 FL:15 FL:9}



static void Test_BFu15ll_BFu15ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 6, 9, 1, "BFu15ll_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu9ll, BFu15ll_BFu15ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu15ll_BFu9s) C1{ FL:15 FL:15 Fs:9}



static void Test_BFu15ll_BFu15ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu9s, BFu15ll_BFu15ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu15ll_C  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 BFu15ll_BFu15ll_C) C1{ FL:15 FL:15 Fc}



static void Test_BFu15ll_BFu15ll_C()
{
  {
    init_simple_test("BFu15ll_BFu15ll_C");
    static STRUCT_IF_C BFu15ll_BFu15ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_C");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_C");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_C");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_C, BFu15ll_BFu15ll_C)
//============================================================================


struct  BFu15ll_BFu15ll_D  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 BFu15ll_BFu15ll_D) C1{ FL:15 FL:15 FL}



static void Test_BFu15ll_BFu15ll_D()
{
  {
    init_simple_test("BFu15ll_BFu15ll_D");
    static STRUCT_IF_C BFu15ll_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_D");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_D");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_D, BFu15ll_BFu15ll_D)
//============================================================================


struct  BFu15ll_BFu15ll_F  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 BFu15ll_BFu15ll_F) C1{ FL:15 FL:15 Fi}



static void Test_BFu15ll_BFu15ll_F()
{
  {
    init_simple_test("BFu15ll_BFu15ll_F");
    static STRUCT_IF_C BFu15ll_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_F");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_F");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_F, BFu15ll_BFu15ll_F)
//============================================================================


struct  BFu15ll_BFu15ll_I  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 BFu15ll_BFu15ll_I) C1{ FL:15 FL:15 Fi}



static void Test_BFu15ll_BFu15ll_I()
{
  {
    init_simple_test("BFu15ll_BFu15ll_I");
    static STRUCT_IF_C BFu15ll_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_I");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_I");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_I, BFu15ll_BFu15ll_I)
//============================================================================


struct  BFu15ll_BFu15ll_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 BFu15ll_BFu15ll_Ip) C1{ FL:15 FL:15 Fp}



static void Test_BFu15ll_BFu15ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu15ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_Ip, BFu15ll_BFu15ll_Ip)
//============================================================================


struct  BFu15ll_BFu15ll_L  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu15ll_L) C1{ FL:15 FL:15 FL}



static void Test_BFu15ll_BFu15ll_L()
{
  {
    init_simple_test("BFu15ll_BFu15ll_L");
    static STRUCT_IF_C BFu15ll_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_L");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_L");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_L, BFu15ll_BFu15ll_L)
//============================================================================


struct  BFu15ll_BFu15ll_S  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 BFu15ll_BFu15ll_S) C1{ FL:15 FL:15 Fs}



static void Test_BFu15ll_BFu15ll_S()
{
  {
    init_simple_test("BFu15ll_BFu15ll_S");
    static STRUCT_IF_C BFu15ll_BFu15ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_S");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_S");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_S, BFu15ll_BFu15ll_S)
//============================================================================


struct  BFu15ll_BFu15ll_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu15ll_Uc) C1{ FL:15 FL:15 Fc}



static void Test_BFu15ll_BFu15ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu15ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu15ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Uc");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_Uc, BFu15ll_BFu15ll_Uc)
//============================================================================


struct  BFu15ll_BFu15ll_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu15ll_Ui) C1{ FL:15 FL:15 Fi}



static void Test_BFu15ll_BFu15ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu15ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_Ui, BFu15ll_BFu15ll_Ui)
//============================================================================


struct  BFu15ll_BFu15ll_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu15ll_Ul) C1{ FL:15 FL:15 FL}



static void Test_BFu15ll_BFu15ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu15ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_Ul, BFu15ll_BFu15ll_Ul)
//============================================================================


struct  BFu15ll_BFu15ll_Us  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu15ll_Us) C1{ FL:15 FL:15 Fs}



static void Test_BFu15ll_BFu15ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu15ll_Us");
    static STRUCT_IF_C BFu15ll_BFu15ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_Us, BFu15ll_BFu15ll_Us)
//============================================================================


struct  BFu15ll_BFu15ll_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 BFu15ll_BFu15ll_Vp) C1{ FL:15 FL:15 Fp}



static void Test_BFu15ll_BFu15ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu15ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_Vp, BFu15ll_BFu15ll_Vp)
//============================================================================


struct  BFu15ll_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
};
//SIG(1 BFu15ll_BFu15s) C1{ FL:15 Fs:15}



static void Test_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s, BFu15ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu15s_BFs15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15i) C1{ FL:15 Fs:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15i, BFu15ll_BFu15s_BFs15i)
//============================================================================


struct  BFu15ll_BFu15s_BFs15i_BFs15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15i_BFs15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15i_BFs15i, BFu15ll_BFu15s_BFs15i_BFs15i)
//============================================================================


struct  BFu15ll_BFu15s_BFs15i_BFs15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15i_BFs15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFu15ll_BFu15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15i_BFs15ll, BFu15ll_BFu15s_BFs15i_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFs15i_BFs15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15i_BFs15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15i_BFs15s, BFu15ll_BFu15s_BFs15i_BFs15s)
//============================================================================


struct  BFu15ll_BFu15s_BFs15i_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15i_BFu15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15i_BFu15i, BFu15ll_BFu15s_BFs15i_BFu15i)
//============================================================================


struct  BFu15ll_BFu15s_BFs15i_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15i_BFu15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFu15ll_BFu15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15i_BFu15ll, BFu15ll_BFu15s_BFs15i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFs15i_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15i_BFu15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15i_BFu15s, BFu15ll_BFu15s_BFs15i_BFu15s)
//============================================================================


struct  BFu15ll_BFu15s_BFs15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15ll) C1{ FL:15 Fs:15 FL:15}



static void Test_BFu15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15ll, BFu15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFs15ll_BFs15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15ll_BFs15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15ll_BFs15i, BFu15ll_BFu15s_BFs15ll_BFs15i)
//============================================================================


struct  BFu15ll_BFu15s_BFs15ll_BFs15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15ll_BFs15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFu15ll_BFu15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15ll_BFs15ll, BFu15ll_BFu15s_BFs15ll_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFs15ll_BFs15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15ll_BFs15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15ll_BFs15s, BFu15ll_BFu15s_BFs15ll_BFs15s)
//============================================================================


struct  BFu15ll_BFu15s_BFs15ll_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15ll_BFu15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15ll_BFu15i, BFu15ll_BFu15s_BFs15ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu15s_BFs15ll_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15ll_BFu15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFu15ll_BFu15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15ll_BFu15ll, BFu15ll_BFu15s_BFs15ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFs15ll_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15ll_BFu15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15ll_BFu15s, BFu15ll_BFu15s_BFs15ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu15s_BFs15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15s) C1{ FL:15 Fs:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15s, BFu15ll_BFu15s_BFs15s)
//============================================================================


struct  BFu15ll_BFu15s_BFs15s_BFs15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15s_BFs15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15s_BFs15i, BFu15ll_BFu15s_BFs15s_BFs15i)
//============================================================================


struct  BFu15ll_BFu15s_BFs15s_BFs15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15s_BFs15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFu15ll_BFu15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15s_BFs15ll, BFu15ll_BFu15s_BFs15s_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFs15s_BFs15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15s_BFs15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15s_BFs15s, BFu15ll_BFu15s_BFs15s_BFs15s)
//============================================================================


struct  BFu15ll_BFu15s_BFs15s_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15s_BFu15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15s_BFu15i, BFu15ll_BFu15s_BFs15s_BFu15i)
//============================================================================


struct  BFu15ll_BFu15s_BFs15s_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15s_BFu15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFu15ll_BFu15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15s_BFu15ll, BFu15ll_BFu15s_BFs15s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFs15s_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFs15s_BFu15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFs15s_BFu15s, BFu15ll_BFu15s_BFs15s_BFu15s)
//============================================================================


struct  BFu15ll_BFu15s_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15i) C1{ FL:15 Fs:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15i, BFu15ll_BFu15s_BFu15i)
//============================================================================


struct  BFu15ll_BFu15s_BFu15i_BFs15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15i_BFs15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15i_BFs15i, BFu15ll_BFu15s_BFu15i_BFs15i)
//============================================================================


struct  BFu15ll_BFu15s_BFu15i_BFs15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15i_BFs15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFu15ll_BFu15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15i_BFs15ll, BFu15ll_BFu15s_BFu15i_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu15i_BFs15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15i_BFs15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15i_BFs15s, BFu15ll_BFu15s_BFu15i_BFs15s)
//============================================================================


struct  BFu15ll_BFu15s_BFu15i_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15i_BFu15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15i_BFu15i, BFu15ll_BFu15s_BFu15i_BFu15i)
//============================================================================


struct  BFu15ll_BFu15s_BFu15i_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15i_BFu15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFu15ll_BFu15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15i_BFu15ll, BFu15ll_BFu15s_BFu15i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu15i_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15i_BFu15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15i_BFu15s, BFu15ll_BFu15s_BFu15i_BFu15s)
//============================================================================


struct  BFu15ll_BFu15s_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15ll) C1{ FL:15 Fs:15 FL:15}



static void Test_BFu15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15ll, BFu15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu15ll_BFs15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15ll_BFs15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15ll_BFs15i, BFu15ll_BFu15s_BFu15ll_BFs15i)
//============================================================================


struct  BFu15ll_BFu15s_BFu15ll_BFs15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15ll_BFs15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFu15ll_BFu15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15ll_BFs15ll, BFu15ll_BFu15s_BFu15ll_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu15ll_BFs15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15ll_BFs15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15ll_BFs15s, BFu15ll_BFu15s_BFu15ll_BFs15s)
//============================================================================


struct  BFu15ll_BFu15s_BFu15ll_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15ll_BFu15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15ll_BFu15i, BFu15ll_BFu15s_BFu15ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu15s_BFu15ll_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15ll_BFu15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFu15ll_BFu15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15ll_BFu15ll, BFu15ll_BFu15s_BFu15ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu15ll_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15ll_BFu15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15ll_BFu15s, BFu15ll_BFu15s_BFu15ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu15s_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15s) C1{ FL:15 Fs:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15s, BFu15ll_BFu15s_BFu15s)
//============================================================================


struct  BFu15ll_BFu15s_BFu15s_BFs15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15s_BFs15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15s_BFs15i, BFu15ll_BFu15s_BFu15s_BFs15i)
//============================================================================


struct  BFu15ll_BFu15s_BFu15s_BFs15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15s_BFs15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFu15ll_BFu15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15s_BFs15ll, BFu15ll_BFu15s_BFu15s_BFs15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu15s_BFs15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15s_BFs15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15s_BFs15s, BFu15ll_BFu15s_BFu15s_BFs15s)
//============================================================================


struct  BFu15ll_BFu15s_BFu15s_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15s_BFu15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFu15ll_BFu15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15s_BFu15i, BFu15ll_BFu15s_BFu15s_BFu15i)
//============================================================================


struct  BFu15ll_BFu15s_BFu15s_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15s_BFu15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFu15ll_BFu15s_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15s_BFu15ll, BFu15ll_BFu15s_BFu15s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu15s_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFu15ll_BFu15s_BFu15s_BFu15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFu15ll_BFu15s_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFu15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu15s_BFu15s, BFu15ll_BFu15s_BFu15s_BFu15s)
//============================================================================


struct  BFu15ll_BFu15s_BFu16i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu15s_BFu16i) C1{ FL:15 Fs:15 Fi:16}



static void Test_BFu15ll_BFu15s_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu16i, BFu15ll_BFu15s_BFu16i)
//============================================================================


struct  BFu15ll_BFu15s_BFu16ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu15s_BFu16ll) C1{ FL:15 Fs:15 FL:16}



static void Test_BFu15ll_BFu15s_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "BFu15ll_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu16ll, BFu15ll_BFu15s_BFu16ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu16s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu15s_BFu16s) C1{ FL:15 Fs:15 Fs:16}



static void Test_BFu15ll_BFu15s_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu16s, BFu15ll_BFu15s_BFu16s)
//============================================================================


struct  BFu15ll_BFu15s_BFu17i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu15s_BFu17i) C1{ FL:15 Fs:15 Fi:17}



static void Test_BFu15ll_BFu15s_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu17i, BFu15ll_BFu15s_BFu17i)
//============================================================================


struct  BFu15ll_BFu15s_BFu17ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu15s_BFu17ll) C1{ FL:15 Fs:15 FL:17}



static void Test_BFu15ll_BFu15s_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "BFu15ll_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu17ll, BFu15ll_BFu15s_BFu17ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu1c  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu15s_BFu1c) C1{ FL:15 Fs:15 Fc:1}



static void Test_BFu15ll_BFu15s_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu1c, BFu15ll_BFu15s_BFu1c)
//============================================================================


struct  BFu15ll_BFu15s_BFu1i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu15s_BFu1i) C1{ FL:15 Fs:15 Fi:1}



static void Test_BFu15ll_BFu15s_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu1i, BFu15ll_BFu15s_BFu1i)
//============================================================================


struct  BFu15ll_BFu15s_BFu1ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu15s_BFu1ll) C1{ FL:15 Fs:15 FL:1}



static void Test_BFu15ll_BFu15s_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu1ll, BFu15ll_BFu15s_BFu1ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu1s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu15s_BFu1s) C1{ FL:15 Fs:15 Fs:1}



static void Test_BFu15ll_BFu15s_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu1s, BFu15ll_BFu15s_BFu1s)
//============================================================================


struct  BFu15ll_BFu15s_BFu31i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu15s_BFu31i) C1{ FL:15 Fs:15 Fi:31}



static void Test_BFu15ll_BFu15s_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu31i, BFu15ll_BFu15s_BFu31i)
//============================================================================


struct  BFu15ll_BFu15s_BFu31ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu15s_BFu31ll) C1{ FL:15 Fs:15 FL:31}



static void Test_BFu15ll_BFu15s_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "BFu15ll_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu31ll, BFu15ll_BFu15s_BFu31ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu32i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu15s_BFu32i) C1{ FL:15 Fs:15 Fi:32}



static void Test_BFu15ll_BFu15s_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu32i, BFu15ll_BFu15s_BFu32i)
//============================================================================


struct  BFu15ll_BFu15s_BFu32ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu15s_BFu32ll) C1{ FL:15 Fs:15 FL:32}



static void Test_BFu15ll_BFu15s_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "BFu15ll_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu32ll, BFu15ll_BFu15s_BFu32ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu33  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu15s_BFu33) C1{ FL:15 Fs:15 FL:33}



static void Test_BFu15ll_BFu15s_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu33");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "BFu15ll_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu33, BFu15ll_BFu15s_BFu33)
//============================================================================


struct  BFu15ll_BFu15s_BFu7c  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu15s_BFu7c) C1{ FL:15 Fs:15 Fc:7}



static void Test_BFu15ll_BFu15s_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu7c, BFu15ll_BFu15s_BFu7c)
//============================================================================


struct  BFu15ll_BFu15s_BFu7i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu15s_BFu7i) C1{ FL:15 Fs:15 Fi:7}



static void Test_BFu15ll_BFu15s_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu7i, BFu15ll_BFu15s_BFu7i)
//============================================================================


struct  BFu15ll_BFu15s_BFu7ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu15s_BFu7ll) C1{ FL:15 Fs:15 FL:7}



static void Test_BFu15ll_BFu15s_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "BFu15ll_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu7ll, BFu15ll_BFu15s_BFu7ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu7s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu15s_BFu7s) C1{ FL:15 Fs:15 Fs:7}



static void Test_BFu15ll_BFu15s_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu7s, BFu15ll_BFu15s_BFu7s)
//============================================================================


struct  BFu15ll_BFu15s_BFu8c  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu15s_BFu8c) C1{ FL:15 Fs:15 Fc:8}



static void Test_BFu15ll_BFu15s_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu8c, BFu15ll_BFu15s_BFu8c)
//============================================================================


struct  BFu15ll_BFu15s_BFu8i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu15s_BFu8i) C1{ FL:15 Fs:15 Fi:8}



static void Test_BFu15ll_BFu15s_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu8i, BFu15ll_BFu15s_BFu8i)
//============================================================================


struct  BFu15ll_BFu15s_BFu8ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu15s_BFu8ll) C1{ FL:15 Fs:15 FL:8}



static void Test_BFu15ll_BFu15s_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "BFu15ll_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu8ll, BFu15ll_BFu15s_BFu8ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu8s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu15s_BFu8s) C1{ FL:15 Fs:15 Fs:8}



static void Test_BFu15ll_BFu15s_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu8s, BFu15ll_BFu15s_BFu8s)
//============================================================================


struct  BFu15ll_BFu15s_BFu9i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu15s_BFu9i) C1{ FL:15 Fs:15 Fi:9}



static void Test_BFu15ll_BFu15s_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu9i, BFu15ll_BFu15s_BFu9i)
//============================================================================


struct  BFu15ll_BFu15s_BFu9ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu15s_BFu9ll) C1{ FL:15 Fs:15 FL:9}



static void Test_BFu15ll_BFu15s_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "BFu15ll_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu9ll, BFu15ll_BFu15s_BFu9ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu9s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu15s_BFu9s) C1{ FL:15 Fs:15 Fs:9}



static void Test_BFu15ll_BFu15s_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu9s, BFu15ll_BFu15s_BFu9s)
//============================================================================


struct  BFu15ll_BFu15s_C  {
  __tsu64 v1:15;
  unsigned short v2:15;
  char v3;
};
//SIG(1 BFu15ll_BFu15s_C) C1{ FL:15 Fs:15 Fc}



static void Test_BFu15ll_BFu15s_C()
{
  {
    init_simple_test("BFu15ll_BFu15s_C");
    static STRUCT_IF_C BFu15ll_BFu15s_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_C");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_C");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_C, BFu15ll_BFu15s_C)
//============================================================================


struct  BFu15ll_BFu15s_D  {
  __tsu64 v1:15;
  unsigned short v2:15;
  double v3;
};
//SIG(1 BFu15ll_BFu15s_D) C1{ FL:15 Fs:15 FL}



static void Test_BFu15ll_BFu15s_D()
{
  {
    init_simple_test("BFu15ll_BFu15s_D");
    static STRUCT_IF_C BFu15ll_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_D");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_D, BFu15ll_BFu15s_D)
//============================================================================


struct  BFu15ll_BFu15s_F  {
  __tsu64 v1:15;
  unsigned short v2:15;
  float v3;
};
//SIG(1 BFu15ll_BFu15s_F) C1{ FL:15 Fs:15 Fi}



static void Test_BFu15ll_BFu15s_F()
{
  {
    init_simple_test("BFu15ll_BFu15s_F");
    static STRUCT_IF_C BFu15ll_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_F");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_F, BFu15ll_BFu15s_F)
//============================================================================


struct  BFu15ll_BFu15s_I  {
  __tsu64 v1:15;
  unsigned short v2:15;
  int v3;
};
//SIG(1 BFu15ll_BFu15s_I) C1{ FL:15 Fs:15 Fi}



static void Test_BFu15ll_BFu15s_I()
{
  {
    init_simple_test("BFu15ll_BFu15s_I");
    static STRUCT_IF_C BFu15ll_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_I");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_I, BFu15ll_BFu15s_I)
//============================================================================


struct  BFu15ll_BFu15s_Ip  {
  __tsu64 v1:15;
  unsigned short v2:15;
  int *v3;
};
//SIG(1 BFu15ll_BFu15s_Ip) C1{ FL:15 Fs:15 Fp}



static void Test_BFu15ll_BFu15s_Ip()
{
  {
    init_simple_test("BFu15ll_BFu15s_Ip");
    static STRUCT_IF_C BFu15ll_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_Ip, BFu15ll_BFu15s_Ip)
//============================================================================


struct  BFu15ll_BFu15s_L  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu15s_L) C1{ FL:15 Fs:15 FL}



static void Test_BFu15ll_BFu15s_L()
{
  {
    init_simple_test("BFu15ll_BFu15s_L");
    static STRUCT_IF_C BFu15ll_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_L");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_L, BFu15ll_BFu15s_L)
//============================================================================


struct  BFu15ll_BFu15s_S  {
  __tsu64 v1:15;
  unsigned short v2:15;
  short v3;
};
//SIG(1 BFu15ll_BFu15s_S) C1{ FL:15 Fs:15 Fs}



static void Test_BFu15ll_BFu15s_S()
{
  {
    init_simple_test("BFu15ll_BFu15s_S");
    static STRUCT_IF_C BFu15ll_BFu15s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_S");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_S, BFu15ll_BFu15s_S)
//============================================================================


struct  BFu15ll_BFu15s_Uc  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu15s_Uc) C1{ FL:15 Fs:15 Fc}



static void Test_BFu15ll_BFu15s_Uc()
{
  {
    init_simple_test("BFu15ll_BFu15s_Uc");
    static STRUCT_IF_C BFu15ll_BFu15s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Uc");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_Uc, BFu15ll_BFu15s_Uc)
//============================================================================


struct  BFu15ll_BFu15s_Ui  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu15s_Ui) C1{ FL:15 Fs:15 Fi}



static void Test_BFu15ll_BFu15s_Ui()
{
  {
    init_simple_test("BFu15ll_BFu15s_Ui");
    static STRUCT_IF_C BFu15ll_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_Ui, BFu15ll_BFu15s_Ui)
//============================================================================


struct  BFu15ll_BFu15s_Ul  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu15s_Ul) C1{ FL:15 Fs:15 FL}



static void Test_BFu15ll_BFu15s_Ul()
{
  {
    init_simple_test("BFu15ll_BFu15s_Ul");
    static STRUCT_IF_C BFu15ll_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_Ul, BFu15ll_BFu15s_Ul)
//============================================================================


struct  BFu15ll_BFu15s_Us  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu15s_Us) C1{ FL:15 Fs:15 Fs}



static void Test_BFu15ll_BFu15s_Us()
{
  {
    init_simple_test("BFu15ll_BFu15s_Us");
    static STRUCT_IF_C BFu15ll_BFu15s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_Us, BFu15ll_BFu15s_Us)
//============================================================================


struct  BFu15ll_BFu15s_Vp  {
  __tsu64 v1:15;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 BFu15ll_BFu15s_Vp) C1{ FL:15 Fs:15 Fp}



static void Test_BFu15ll_BFu15s_Vp()
{
  {
    init_simple_test("BFu15ll_BFu15s_Vp");
    static STRUCT_IF_C BFu15ll_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_Vp, BFu15ll_BFu15s_Vp)
//============================================================================


struct  BFu15ll_BFu16i  {
  __tsu64 v1:15;
  unsigned int v2:16;
};
//SIG(1 BFu15ll_BFu16i) C1{ FL:15 Fi:16}



static void Test_BFu15ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i, BFu15ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu16i_BFu15i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu16i_BFu15i) C1{ FL:15 Fi:16 Fi:15}



static void Test_BFu15ll_BFu16i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu15i, BFu15ll_BFu16i_BFu15i)
//============================================================================


struct  BFu15ll_BFu16i_BFu15ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu16i_BFu15ll) C1{ FL:15 Fi:16 FL:15}



static void Test_BFu15ll_BFu16i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu15ll, BFu15ll_BFu16i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu15s  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu16i_BFu15s) C1{ FL:15 Fi:16 Fs:15}



static void Test_BFu15ll_BFu16i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu15s, BFu15ll_BFu16i_BFu15s)
//============================================================================


struct  BFu15ll_BFu16i_BFu16i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu16i_BFu16i) C1{ FL:15 Fi:16 Fi:16}



static void Test_BFu15ll_BFu16i_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu16i, BFu15ll_BFu16i_BFu16i)
//============================================================================


struct  BFu15ll_BFu16i_BFu16ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu16i_BFu16ll) C1{ FL:15 Fi:16 FL:16}



static void Test_BFu15ll_BFu16i_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "BFu15ll_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu16ll, BFu15ll_BFu16i_BFu16ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu16s  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu16i_BFu16s) C1{ FL:15 Fi:16 Fs:16}



static void Test_BFu15ll_BFu16i_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu16s, BFu15ll_BFu16i_BFu16s)
//============================================================================


struct  BFu15ll_BFu16i_BFu17i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu16i_BFu17i) C1{ FL:15 Fi:16 Fi:17}



static void Test_BFu15ll_BFu16i_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu17i, BFu15ll_BFu16i_BFu17i)
//============================================================================


struct  BFu15ll_BFu16i_BFu17ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu16i_BFu17ll) C1{ FL:15 Fi:16 FL:17}



static void Test_BFu15ll_BFu16i_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "BFu15ll_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu17ll, BFu15ll_BFu16i_BFu17ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu1c  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu16i_BFu1c) C1{ FL:15 Fi:16 Fc:1}



static void Test_BFu15ll_BFu16i_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu1c, BFu15ll_BFu16i_BFu1c)
//============================================================================


struct  BFu15ll_BFu16i_BFu1i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu16i_BFu1i) C1{ FL:15 Fi:16 Fi:1}



static void Test_BFu15ll_BFu16i_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu1i, BFu15ll_BFu16i_BFu1i)
//============================================================================


struct  BFu15ll_BFu16i_BFu1ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu16i_BFu1ll) C1{ FL:15 Fi:16 FL:1}



static void Test_BFu15ll_BFu16i_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu1ll, BFu15ll_BFu16i_BFu1ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu1s  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu16i_BFu1s) C1{ FL:15 Fi:16 Fs:1}



static void Test_BFu15ll_BFu16i_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu1s, BFu15ll_BFu16i_BFu1s)
//============================================================================


struct  BFu15ll_BFu16i_BFu31i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu16i_BFu31i) C1{ FL:15 Fi:16 Fi:31}



static void Test_BFu15ll_BFu16i_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu31i, BFu15ll_BFu16i_BFu31i)
//============================================================================


struct  BFu15ll_BFu16i_BFu31ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu16i_BFu31ll) C1{ FL:15 Fi:16 FL:31}



static void Test_BFu15ll_BFu16i_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "BFu15ll_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu31ll, BFu15ll_BFu16i_BFu31ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu32i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu16i_BFu32i) C1{ FL:15 Fi:16 Fi:32}



static void Test_BFu15ll_BFu16i_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu32i, BFu15ll_BFu16i_BFu32i)
//============================================================================


struct  BFu15ll_BFu16i_BFu32ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu16i_BFu32ll) C1{ FL:15 Fi:16 FL:32}



static void Test_BFu15ll_BFu16i_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "BFu15ll_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu32ll, BFu15ll_BFu16i_BFu32ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu33  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu16i_BFu33) C1{ FL:15 Fi:16 FL:33}



static void Test_BFu15ll_BFu16i_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu33");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "BFu15ll_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu33, BFu15ll_BFu16i_BFu33)
//============================================================================


struct  BFu15ll_BFu16i_BFu7c  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu16i_BFu7c) C1{ FL:15 Fi:16 Fc:7}



static void Test_BFu15ll_BFu16i_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu7c, BFu15ll_BFu16i_BFu7c)
//============================================================================


struct  BFu15ll_BFu16i_BFu7i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu16i_BFu7i) C1{ FL:15 Fi:16 Fi:7}



static void Test_BFu15ll_BFu16i_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu7i, BFu15ll_BFu16i_BFu7i)
//============================================================================


struct  BFu15ll_BFu16i_BFu7ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu16i_BFu7ll) C1{ FL:15 Fi:16 FL:7}



static void Test_BFu15ll_BFu16i_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "BFu15ll_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu7ll, BFu15ll_BFu16i_BFu7ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu7s  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu16i_BFu7s) C1{ FL:15 Fi:16 Fs:7}



static void Test_BFu15ll_BFu16i_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu7s, BFu15ll_BFu16i_BFu7s)
//============================================================================


struct  BFu15ll_BFu16i_BFu8c  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu16i_BFu8c) C1{ FL:15 Fi:16 Fc:8}



static void Test_BFu15ll_BFu16i_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu8c, BFu15ll_BFu16i_BFu8c)
//============================================================================


struct  BFu15ll_BFu16i_BFu8i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu16i_BFu8i) C1{ FL:15 Fi:16 Fi:8}



static void Test_BFu15ll_BFu16i_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu8i, BFu15ll_BFu16i_BFu8i)
//============================================================================


struct  BFu15ll_BFu16i_BFu8ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu16i_BFu8ll) C1{ FL:15 Fi:16 FL:8}



static void Test_BFu15ll_BFu16i_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "BFu15ll_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu8ll, BFu15ll_BFu16i_BFu8ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu8s  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu16i_BFu8s) C1{ FL:15 Fi:16 Fs:8}



static void Test_BFu15ll_BFu16i_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu8s, BFu15ll_BFu16i_BFu8s)
//============================================================================


struct  BFu15ll_BFu16i_BFu9i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu16i_BFu9i) C1{ FL:15 Fi:16 Fi:9}



static void Test_BFu15ll_BFu16i_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu9i, BFu15ll_BFu16i_BFu9i)
//============================================================================


struct  BFu15ll_BFu16i_BFu9ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu16i_BFu9ll) C1{ FL:15 Fi:16 FL:9}



static void Test_BFu15ll_BFu16i_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "BFu15ll_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu9ll, BFu15ll_BFu16i_BFu9ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu9s  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu16i_BFu9s) C1{ FL:15 Fi:16 Fs:9}



static void Test_BFu15ll_BFu16i_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu9s, BFu15ll_BFu16i_BFu9s)
//============================================================================


struct  BFu15ll_BFu16i_C  {
  __tsu64 v1:15;
  unsigned int v2:16;
  char v3;
};
//SIG(1 BFu15ll_BFu16i_C) C1{ FL:15 Fi:16 Fc}



static void Test_BFu15ll_BFu16i_C()
{
  {
    init_simple_test("BFu15ll_BFu16i_C");
    static STRUCT_IF_C BFu15ll_BFu16i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_C");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_C");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_C");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_C, BFu15ll_BFu16i_C)
//============================================================================


struct  BFu15ll_BFu16i_D  {
  __tsu64 v1:15;
  unsigned int v2:16;
  double v3;
};
//SIG(1 BFu15ll_BFu16i_D) C1{ FL:15 Fi:16 FL}



static void Test_BFu15ll_BFu16i_D()
{
  {
    init_simple_test("BFu15ll_BFu16i_D");
    static STRUCT_IF_C BFu15ll_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_D");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_D");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_D, BFu15ll_BFu16i_D)
//============================================================================


struct  BFu15ll_BFu16i_F  {
  __tsu64 v1:15;
  unsigned int v2:16;
  float v3;
};
//SIG(1 BFu15ll_BFu16i_F) C1{ FL:15 Fi:16 Fi}



static void Test_BFu15ll_BFu16i_F()
{
  {
    init_simple_test("BFu15ll_BFu16i_F");
    static STRUCT_IF_C BFu15ll_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_F");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_F");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_F, BFu15ll_BFu16i_F)
//============================================================================


struct  BFu15ll_BFu16i_I  {
  __tsu64 v1:15;
  unsigned int v2:16;
  int v3;
};
//SIG(1 BFu15ll_BFu16i_I) C1{ FL:15 Fi:16 Fi}



static void Test_BFu15ll_BFu16i_I()
{
  {
    init_simple_test("BFu15ll_BFu16i_I");
    static STRUCT_IF_C BFu15ll_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_I");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_I");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_I, BFu15ll_BFu16i_I)
//============================================================================


struct  BFu15ll_BFu16i_Ip  {
  __tsu64 v1:15;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 BFu15ll_BFu16i_Ip) C1{ FL:15 Fi:16 Fp}



static void Test_BFu15ll_BFu16i_Ip()
{
  {
    init_simple_test("BFu15ll_BFu16i_Ip");
    static STRUCT_IF_C BFu15ll_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_Ip, BFu15ll_BFu16i_Ip)
//============================================================================


struct  BFu15ll_BFu16i_L  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu16i_L) C1{ FL:15 Fi:16 FL}



static void Test_BFu15ll_BFu16i_L()
{
  {
    init_simple_test("BFu15ll_BFu16i_L");
    static STRUCT_IF_C BFu15ll_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_L");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_L");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_L, BFu15ll_BFu16i_L)
//============================================================================


struct  BFu15ll_BFu16i_S  {
  __tsu64 v1:15;
  unsigned int v2:16;
  short v3;
};
//SIG(1 BFu15ll_BFu16i_S) C1{ FL:15 Fi:16 Fs}



static void Test_BFu15ll_BFu16i_S()
{
  {
    init_simple_test("BFu15ll_BFu16i_S");
    static STRUCT_IF_C BFu15ll_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_S");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_S");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_S, BFu15ll_BFu16i_S)
//============================================================================


struct  BFu15ll_BFu16i_Uc  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu16i_Uc) C1{ FL:15 Fi:16 Fc}



static void Test_BFu15ll_BFu16i_Uc()
{
  {
    init_simple_test("BFu15ll_BFu16i_Uc");
    static STRUCT_IF_C BFu15ll_BFu16i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_Uc");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_Uc, BFu15ll_BFu16i_Uc)
//============================================================================


struct  BFu15ll_BFu16i_Ui  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu16i_Ui) C1{ FL:15 Fi:16 Fi}



static void Test_BFu15ll_BFu16i_Ui()
{
  {
    init_simple_test("BFu15ll_BFu16i_Ui");
    static STRUCT_IF_C BFu15ll_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_Ui, BFu15ll_BFu16i_Ui)
//============================================================================


struct  BFu15ll_BFu16i_Ul  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu16i_Ul) C1{ FL:15 Fi:16 FL}



static void Test_BFu15ll_BFu16i_Ul()
{
  {
    init_simple_test("BFu15ll_BFu16i_Ul");
    static STRUCT_IF_C BFu15ll_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_Ul, BFu15ll_BFu16i_Ul)
//============================================================================


struct  BFu15ll_BFu16i_Us  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu16i_Us) C1{ FL:15 Fi:16 Fs}



static void Test_BFu15ll_BFu16i_Us()
{
  {
    init_simple_test("BFu15ll_BFu16i_Us");
    static STRUCT_IF_C BFu15ll_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_Us");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_Us");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_Us, BFu15ll_BFu16i_Us)
//============================================================================


struct  BFu15ll_BFu16i_Vp  {
  __tsu64 v1:15;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 BFu15ll_BFu16i_Vp) C1{ FL:15 Fi:16 Fp}



static void Test_BFu15ll_BFu16i_Vp()
{
  {
    init_simple_test("BFu15ll_BFu16i_Vp");
    static STRUCT_IF_C BFu15ll_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_Vp, BFu15ll_BFu16i_Vp)
//============================================================================


struct  BFu15ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
};
//SIG(1 BFu15ll_BFu16ll) C1{ FL:15 FL:16}



static void Test_BFu15ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll, BFu15ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu16ll_BFu15i) C1{ FL:15 FL:16 Fi:15}



static void Test_BFu15ll_BFu16ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu15i, BFu15ll_BFu16ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu16ll_BFu15ll) C1{ FL:15 FL:16 FL:15}



static void Test_BFu15ll_BFu16ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFu15ll_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu15ll, BFu15ll_BFu16ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu16ll_BFu15s) C1{ FL:15 FL:16 Fs:15}



static void Test_BFu15ll_BFu16ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu15s, BFu15ll_BFu16ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu16ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu16ll_BFu16i) C1{ FL:15 FL:16 Fi:16}



static void Test_BFu15ll_BFu16ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu16i, BFu15ll_BFu16ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu16ll_BFu16ll) C1{ FL:15 FL:16 FL:16}



static void Test_BFu15ll_BFu16ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "BFu15ll_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu16ll, BFu15ll_BFu16ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu16ll_BFu16s) C1{ FL:15 FL:16 Fs:16}



static void Test_BFu15ll_BFu16ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu16s, BFu15ll_BFu16ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu16ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu16ll_BFu17i) C1{ FL:15 FL:16 Fi:17}



static void Test_BFu15ll_BFu16ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu17i, BFu15ll_BFu16ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu16ll_BFu17ll) C1{ FL:15 FL:16 FL:17}



static void Test_BFu15ll_BFu16ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "BFu15ll_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu17ll, BFu15ll_BFu16ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu16ll_BFu1c) C1{ FL:15 FL:16 Fc:1}



static void Test_BFu15ll_BFu16ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu1c, BFu15ll_BFu16ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu16ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu16ll_BFu1i) C1{ FL:15 FL:16 Fi:1}



static void Test_BFu15ll_BFu16ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu1i, BFu15ll_BFu16ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu16ll_BFu1ll) C1{ FL:15 FL:16 FL:1}



static void Test_BFu15ll_BFu16ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu1ll, BFu15ll_BFu16ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu16ll_BFu1s) C1{ FL:15 FL:16 Fs:1}



static void Test_BFu15ll_BFu16ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "BFu15ll_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu1s, BFu15ll_BFu16ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu16ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu16ll_BFu31i) C1{ FL:15 FL:16 Fi:31}



static void Test_BFu15ll_BFu16ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu31i, BFu15ll_BFu16ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu16ll_BFu31ll) C1{ FL:15 FL:16 FL:31}



static void Test_BFu15ll_BFu16ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "BFu15ll_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu31ll, BFu15ll_BFu16ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu16ll_BFu32i) C1{ FL:15 FL:16 Fi:32}



static void Test_BFu15ll_BFu16ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu32i, BFu15ll_BFu16ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu16ll_BFu32ll) C1{ FL:15 FL:16 FL:32}



static void Test_BFu15ll_BFu16ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "BFu15ll_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu32ll, BFu15ll_BFu16ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu16ll_BFu33) C1{ FL:15 FL:16 FL:33}



static void Test_BFu15ll_BFu16ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "BFu15ll_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu33, BFu15ll_BFu16ll_BFu33)
//============================================================================


struct  BFu15ll_BFu16ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu16ll_BFu7c) C1{ FL:15 FL:16 Fc:7}



static void Test_BFu15ll_BFu16ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu7c, BFu15ll_BFu16ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu16ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu16ll_BFu7i) C1{ FL:15 FL:16 Fi:7}



static void Test_BFu15ll_BFu16ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu7i, BFu15ll_BFu16ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu16ll_BFu7ll) C1{ FL:15 FL:16 FL:7}



static void Test_BFu15ll_BFu16ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "BFu15ll_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu7ll, BFu15ll_BFu16ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu16ll_BFu7s) C1{ FL:15 FL:16 Fs:7}



static void Test_BFu15ll_BFu16ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu7s, BFu15ll_BFu16ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu16ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu16ll_BFu8c) C1{ FL:15 FL:16 Fc:8}



static void Test_BFu15ll_BFu16ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu8c, BFu15ll_BFu16ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu16ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu16ll_BFu8i) C1{ FL:15 FL:16 Fi:8}



static void Test_BFu15ll_BFu16ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu8i, BFu15ll_BFu16ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu16ll_BFu8ll) C1{ FL:15 FL:16 FL:8}



static void Test_BFu15ll_BFu16ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "BFu15ll_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu8ll, BFu15ll_BFu16ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu16ll_BFu8s) C1{ FL:15 FL:16 Fs:8}



static void Test_BFu15ll_BFu16ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu8s, BFu15ll_BFu16ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu16ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu16ll_BFu9i) C1{ FL:15 FL:16 Fi:9}



static void Test_BFu15ll_BFu16ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu9i, BFu15ll_BFu16ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu16ll_BFu9ll) C1{ FL:15 FL:16 FL:9}



static void Test_BFu15ll_BFu16ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "BFu15ll_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu9ll, BFu15ll_BFu16ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu16ll_BFu9s) C1{ FL:15 FL:16 Fs:9}



static void Test_BFu15ll_BFu16ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu9s, BFu15ll_BFu16ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu16ll_C  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 BFu15ll_BFu16ll_C) C1{ FL:15 FL:16 Fc}



static void Test_BFu15ll_BFu16ll_C()
{
  {
    init_simple_test("BFu15ll_BFu16ll_C");
    static STRUCT_IF_C BFu15ll_BFu16ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_C");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_C");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_C");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_C, BFu15ll_BFu16ll_C)
//============================================================================


struct  BFu15ll_BFu16ll_D  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 BFu15ll_BFu16ll_D) C1{ FL:15 FL:16 FL}



static void Test_BFu15ll_BFu16ll_D()
{
  {
    init_simple_test("BFu15ll_BFu16ll_D");
    static STRUCT_IF_C BFu15ll_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_D");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_D");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_D, BFu15ll_BFu16ll_D)
//============================================================================


struct  BFu15ll_BFu16ll_F  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 BFu15ll_BFu16ll_F) C1{ FL:15 FL:16 Fi}



static void Test_BFu15ll_BFu16ll_F()
{
  {
    init_simple_test("BFu15ll_BFu16ll_F");
    static STRUCT_IF_C BFu15ll_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_F");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_F");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_F, BFu15ll_BFu16ll_F)
//============================================================================


struct  BFu15ll_BFu16ll_I  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 BFu15ll_BFu16ll_I) C1{ FL:15 FL:16 Fi}



static void Test_BFu15ll_BFu16ll_I()
{
  {
    init_simple_test("BFu15ll_BFu16ll_I");
    static STRUCT_IF_C BFu15ll_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_I");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_I");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_I, BFu15ll_BFu16ll_I)
//============================================================================


struct  BFu15ll_BFu16ll_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 BFu15ll_BFu16ll_Ip) C1{ FL:15 FL:16 Fp}



static void Test_BFu15ll_BFu16ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu16ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_Ip, BFu15ll_BFu16ll_Ip)
//============================================================================


struct  BFu15ll_BFu16ll_L  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu16ll_L) C1{ FL:15 FL:16 FL}



static void Test_BFu15ll_BFu16ll_L()
{
  {
    init_simple_test("BFu15ll_BFu16ll_L");
    static STRUCT_IF_C BFu15ll_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_L");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_L");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_L, BFu15ll_BFu16ll_L)
//============================================================================


struct  BFu15ll_BFu16ll_S  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 BFu15ll_BFu16ll_S) C1{ FL:15 FL:16 Fs}



static void Test_BFu15ll_BFu16ll_S()
{
  {
    init_simple_test("BFu15ll_BFu16ll_S");
    static STRUCT_IF_C BFu15ll_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_S");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_S");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_S, BFu15ll_BFu16ll_S)
//============================================================================


struct  BFu15ll_BFu16ll_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu16ll_Uc) C1{ FL:15 FL:16 Fc}



static void Test_BFu15ll_BFu16ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu16ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu16ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_Uc");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_Uc, BFu15ll_BFu16ll_Uc)
//============================================================================


struct  BFu15ll_BFu16ll_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu16ll_Ui) C1{ FL:15 FL:16 Fi}



static void Test_BFu15ll_BFu16ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu16ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_Ui, BFu15ll_BFu16ll_Ui)
//============================================================================


struct  BFu15ll_BFu16ll_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu16ll_Ul) C1{ FL:15 FL:16 FL}



static void Test_BFu15ll_BFu16ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu16ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_Ul, BFu15ll_BFu16ll_Ul)
//============================================================================


struct  BFu15ll_BFu16ll_Us  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu16ll_Us) C1{ FL:15 FL:16 Fs}



static void Test_BFu15ll_BFu16ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu16ll_Us");
    static STRUCT_IF_C BFu15ll_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_Us, BFu15ll_BFu16ll_Us)
//============================================================================


struct  BFu15ll_BFu16ll_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 BFu15ll_BFu16ll_Vp) C1{ FL:15 FL:16 Fp}



static void Test_BFu15ll_BFu16ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu16ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_Vp, BFu15ll_BFu16ll_Vp)
//============================================================================


struct  BFu15ll_BFu16s  {
  __tsu64 v1:15;
  unsigned short v2:16;
};
//SIG(1 BFu15ll_BFu16s) C1{ FL:15 Fs:16}



static void Test_BFu15ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s, BFu15ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu16s_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu16s_BFu15i) C1{ FL:15 Fs:16 Fi:15}



static void Test_BFu15ll_BFu16s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu15i, BFu15ll_BFu16s_BFu15i)
//============================================================================


struct  BFu15ll_BFu16s_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu16s_BFu15ll) C1{ FL:15 Fs:16 FL:15}



static void Test_BFu15ll_BFu16s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu15ll, BFu15ll_BFu16s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu16s_BFu15s) C1{ FL:15 Fs:16 Fs:15}



static void Test_BFu15ll_BFu16s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu15s, BFu15ll_BFu16s_BFu15s)
//============================================================================


struct  BFu15ll_BFu16s_BFu16i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu16s_BFu16i) C1{ FL:15 Fs:16 Fi:16}



static void Test_BFu15ll_BFu16s_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu16i, BFu15ll_BFu16s_BFu16i)
//============================================================================


struct  BFu15ll_BFu16s_BFu16ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu16s_BFu16ll) C1{ FL:15 Fs:16 FL:16}



static void Test_BFu15ll_BFu16s_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu16ll, BFu15ll_BFu16s_BFu16ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu16s  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu16s_BFu16s) C1{ FL:15 Fs:16 Fs:16}



static void Test_BFu15ll_BFu16s_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu16s, BFu15ll_BFu16s_BFu16s)
//============================================================================


struct  BFu15ll_BFu16s_BFu17i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu16s_BFu17i) C1{ FL:15 Fs:16 Fi:17}



static void Test_BFu15ll_BFu16s_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu17i, BFu15ll_BFu16s_BFu17i)
//============================================================================


struct  BFu15ll_BFu16s_BFu17ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu16s_BFu17ll) C1{ FL:15 Fs:16 FL:17}



static void Test_BFu15ll_BFu16s_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu17ll, BFu15ll_BFu16s_BFu17ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu1c  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu16s_BFu1c) C1{ FL:15 Fs:16 Fc:1}



static void Test_BFu15ll_BFu16s_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu1c, BFu15ll_BFu16s_BFu1c)
//============================================================================


struct  BFu15ll_BFu16s_BFu1i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu16s_BFu1i) C1{ FL:15 Fs:16 Fi:1}



static void Test_BFu15ll_BFu16s_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu1i, BFu15ll_BFu16s_BFu1i)
//============================================================================


struct  BFu15ll_BFu16s_BFu1ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu16s_BFu1ll) C1{ FL:15 Fs:16 FL:1}



static void Test_BFu15ll_BFu16s_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu1ll, BFu15ll_BFu16s_BFu1ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu1s  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu16s_BFu1s) C1{ FL:15 Fs:16 Fs:1}



static void Test_BFu15ll_BFu16s_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu1s, BFu15ll_BFu16s_BFu1s)
//============================================================================


struct  BFu15ll_BFu16s_BFu31i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu16s_BFu31i) C1{ FL:15 Fs:16 Fi:31}



static void Test_BFu15ll_BFu16s_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu31i, BFu15ll_BFu16s_BFu31i)
//============================================================================


struct  BFu15ll_BFu16s_BFu31ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu16s_BFu31ll) C1{ FL:15 Fs:16 FL:31}



static void Test_BFu15ll_BFu16s_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu31ll, BFu15ll_BFu16s_BFu31ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu32i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu16s_BFu32i) C1{ FL:15 Fs:16 Fi:32}



static void Test_BFu15ll_BFu16s_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu32i, BFu15ll_BFu16s_BFu32i)
//============================================================================


struct  BFu15ll_BFu16s_BFu32ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu16s_BFu32ll) C1{ FL:15 Fs:16 FL:32}



static void Test_BFu15ll_BFu16s_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu32ll, BFu15ll_BFu16s_BFu32ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu33  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu16s_BFu33) C1{ FL:15 Fs:16 FL:33}



static void Test_BFu15ll_BFu16s_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu33");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu15ll_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu33, BFu15ll_BFu16s_BFu33)
//============================================================================


struct  BFu15ll_BFu16s_BFu7c  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu16s_BFu7c) C1{ FL:15 Fs:16 Fc:7}



static void Test_BFu15ll_BFu16s_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu7c, BFu15ll_BFu16s_BFu7c)
//============================================================================


struct  BFu15ll_BFu16s_BFu7i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu16s_BFu7i) C1{ FL:15 Fs:16 Fi:7}



static void Test_BFu15ll_BFu16s_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu7i, BFu15ll_BFu16s_BFu7i)
//============================================================================


struct  BFu15ll_BFu16s_BFu7ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu16s_BFu7ll) C1{ FL:15 Fs:16 FL:7}



static void Test_BFu15ll_BFu16s_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu7ll, BFu15ll_BFu16s_BFu7ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu7s  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu16s_BFu7s) C1{ FL:15 Fs:16 Fs:7}



static void Test_BFu15ll_BFu16s_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu7s, BFu15ll_BFu16s_BFu7s)
//============================================================================


struct  BFu15ll_BFu16s_BFu8c  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu16s_BFu8c) C1{ FL:15 Fs:16 Fc:8}



static void Test_BFu15ll_BFu16s_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu8c, BFu15ll_BFu16s_BFu8c)
//============================================================================


struct  BFu15ll_BFu16s_BFu8i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu16s_BFu8i) C1{ FL:15 Fs:16 Fi:8}



static void Test_BFu15ll_BFu16s_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu8i, BFu15ll_BFu16s_BFu8i)
//============================================================================


struct  BFu15ll_BFu16s_BFu8ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu16s_BFu8ll) C1{ FL:15 Fs:16 FL:8}



static void Test_BFu15ll_BFu16s_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu8ll, BFu15ll_BFu16s_BFu8ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu8s  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu16s_BFu8s) C1{ FL:15 Fs:16 Fs:8}



static void Test_BFu15ll_BFu16s_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu8s, BFu15ll_BFu16s_BFu8s)
//============================================================================


struct  BFu15ll_BFu16s_BFu9i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu16s_BFu9i) C1{ FL:15 Fs:16 Fi:9}



static void Test_BFu15ll_BFu16s_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu9i, BFu15ll_BFu16s_BFu9i)
//============================================================================


struct  BFu15ll_BFu16s_BFu9ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu16s_BFu9ll) C1{ FL:15 Fs:16 FL:9}



static void Test_BFu15ll_BFu16s_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu9ll, BFu15ll_BFu16s_BFu9ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu9s  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu16s_BFu9s) C1{ FL:15 Fs:16 Fs:9}



static void Test_BFu15ll_BFu16s_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu9s, BFu15ll_BFu16s_BFu9s)
//============================================================================


struct  BFu15ll_BFu16s_C  {
  __tsu64 v1:15;
  unsigned short v2:16;
  char v3;
};
//SIG(1 BFu15ll_BFu16s_C) C1{ FL:15 Fs:16 Fc}



static void Test_BFu15ll_BFu16s_C()
{
  {
    init_simple_test("BFu15ll_BFu16s_C");
    static STRUCT_IF_C BFu15ll_BFu16s_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_C");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_C, BFu15ll_BFu16s_C)
//============================================================================


struct  BFu15ll_BFu16s_D  {
  __tsu64 v1:15;
  unsigned short v2:16;
  double v3;
};
//SIG(1 BFu15ll_BFu16s_D) C1{ FL:15 Fs:16 FL}



static void Test_BFu15ll_BFu16s_D()
{
  {
    init_simple_test("BFu15ll_BFu16s_D");
    static STRUCT_IF_C BFu15ll_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_D, BFu15ll_BFu16s_D)
//============================================================================


struct  BFu15ll_BFu16s_F  {
  __tsu64 v1:15;
  unsigned short v2:16;
  float v3;
};
//SIG(1 BFu15ll_BFu16s_F) C1{ FL:15 Fs:16 Fi}



static void Test_BFu15ll_BFu16s_F()
{
  {
    init_simple_test("BFu15ll_BFu16s_F");
    static STRUCT_IF_C BFu15ll_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_F, BFu15ll_BFu16s_F)
//============================================================================


struct  BFu15ll_BFu16s_I  {
  __tsu64 v1:15;
  unsigned short v2:16;
  int v3;
};
//SIG(1 BFu15ll_BFu16s_I) C1{ FL:15 Fs:16 Fi}



static void Test_BFu15ll_BFu16s_I()
{
  {
    init_simple_test("BFu15ll_BFu16s_I");
    static STRUCT_IF_C BFu15ll_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_I, BFu15ll_BFu16s_I)
//============================================================================


struct  BFu15ll_BFu16s_Ip  {
  __tsu64 v1:15;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 BFu15ll_BFu16s_Ip) C1{ FL:15 Fs:16 Fp}



static void Test_BFu15ll_BFu16s_Ip()
{
  {
    init_simple_test("BFu15ll_BFu16s_Ip");
    static STRUCT_IF_C BFu15ll_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_Ip, BFu15ll_BFu16s_Ip)
//============================================================================


struct  BFu15ll_BFu16s_L  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu16s_L) C1{ FL:15 Fs:16 FL}



static void Test_BFu15ll_BFu16s_L()
{
  {
    init_simple_test("BFu15ll_BFu16s_L");
    static STRUCT_IF_C BFu15ll_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_L, BFu15ll_BFu16s_L)
//============================================================================


struct  BFu15ll_BFu16s_S  {
  __tsu64 v1:15;
  unsigned short v2:16;
  short v3;
};
//SIG(1 BFu15ll_BFu16s_S) C1{ FL:15 Fs:16 Fs}



static void Test_BFu15ll_BFu16s_S()
{
  {
    init_simple_test("BFu15ll_BFu16s_S");
    static STRUCT_IF_C BFu15ll_BFu16s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_S, BFu15ll_BFu16s_S)
//============================================================================


struct  BFu15ll_BFu16s_Uc  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu16s_Uc) C1{ FL:15 Fs:16 Fc}



static void Test_BFu15ll_BFu16s_Uc()
{
  {
    init_simple_test("BFu15ll_BFu16s_Uc");
    static STRUCT_IF_C BFu15ll_BFu16s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_Uc");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_Uc, BFu15ll_BFu16s_Uc)
//============================================================================


struct  BFu15ll_BFu16s_Ui  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu16s_Ui) C1{ FL:15 Fs:16 Fi}



static void Test_BFu15ll_BFu16s_Ui()
{
  {
    init_simple_test("BFu15ll_BFu16s_Ui");
    static STRUCT_IF_C BFu15ll_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_Ui, BFu15ll_BFu16s_Ui)
//============================================================================


struct  BFu15ll_BFu16s_Ul  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu16s_Ul) C1{ FL:15 Fs:16 FL}



static void Test_BFu15ll_BFu16s_Ul()
{
  {
    init_simple_test("BFu15ll_BFu16s_Ul");
    static STRUCT_IF_C BFu15ll_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_Ul, BFu15ll_BFu16s_Ul)
//============================================================================


struct  BFu15ll_BFu16s_Us  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu16s_Us) C1{ FL:15 Fs:16 Fs}



static void Test_BFu15ll_BFu16s_Us()
{
  {
    init_simple_test("BFu15ll_BFu16s_Us");
    static STRUCT_IF_C BFu15ll_BFu16s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_Us, BFu15ll_BFu16s_Us)
//============================================================================


struct  BFu15ll_BFu16s_Vp  {
  __tsu64 v1:15;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 BFu15ll_BFu16s_Vp) C1{ FL:15 Fs:16 Fp}



static void Test_BFu15ll_BFu16s_Vp()
{
  {
    init_simple_test("BFu15ll_BFu16s_Vp");
    static STRUCT_IF_C BFu15ll_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_Vp, BFu15ll_BFu16s_Vp)
//============================================================================


struct  BFu15ll_BFu17i  {
  __tsu64 v1:15;
  unsigned int v2:17;
};
//SIG(1 BFu15ll_BFu17i) C1{ FL:15 Fi:17}



static void Test_BFu15ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i, BFu15ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu17i_BFu15i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu17i_BFu15i) C1{ FL:15 Fi:17 Fi:15}



static void Test_BFu15ll_BFu17i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu15i, BFu15ll_BFu17i_BFu15i)
//============================================================================


struct  BFu15ll_BFu17i_BFu15ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu17i_BFu15ll) C1{ FL:15 Fi:17 FL:15}



static void Test_BFu15ll_BFu17i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu15ll, BFu15ll_BFu17i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu15s  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu17i_BFu15s) C1{ FL:15 Fi:17 Fs:15}



static void Test_BFu15ll_BFu17i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu15s, BFu15ll_BFu17i_BFu15s)
//============================================================================


struct  BFu15ll_BFu17i_BFu16i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu17i_BFu16i) C1{ FL:15 Fi:17 Fi:16}



static void Test_BFu15ll_BFu17i_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu16i, BFu15ll_BFu17i_BFu16i)
//============================================================================


struct  BFu15ll_BFu17i_BFu16ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu17i_BFu16ll) C1{ FL:15 Fi:17 FL:16}



static void Test_BFu15ll_BFu17i_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu16ll, BFu15ll_BFu17i_BFu16ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu16s  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu17i_BFu16s) C1{ FL:15 Fi:17 Fs:16}



static void Test_BFu15ll_BFu17i_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu16s, BFu15ll_BFu17i_BFu16s)
//============================================================================


struct  BFu15ll_BFu17i_BFu17i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu17i_BFu17i) C1{ FL:15 Fi:17 Fi:17}



static void Test_BFu15ll_BFu17i_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu17i, BFu15ll_BFu17i_BFu17i)
//============================================================================


struct  BFu15ll_BFu17i_BFu17ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu17i_BFu17ll) C1{ FL:15 Fi:17 FL:17}



static void Test_BFu15ll_BFu17i_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu17ll, BFu15ll_BFu17i_BFu17ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu1c  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu17i_BFu1c) C1{ FL:15 Fi:17 Fc:1}



static void Test_BFu15ll_BFu17i_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu1c, BFu15ll_BFu17i_BFu1c)
//============================================================================


struct  BFu15ll_BFu17i_BFu1i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu17i_BFu1i) C1{ FL:15 Fi:17 Fi:1}



static void Test_BFu15ll_BFu17i_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu1i, BFu15ll_BFu17i_BFu1i)
//============================================================================


struct  BFu15ll_BFu17i_BFu1ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu17i_BFu1ll) C1{ FL:15 Fi:17 FL:1}



static void Test_BFu15ll_BFu17i_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu1ll, BFu15ll_BFu17i_BFu1ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu1s  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu17i_BFu1s) C1{ FL:15 Fi:17 Fs:1}



static void Test_BFu15ll_BFu17i_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu1s, BFu15ll_BFu17i_BFu1s)
//============================================================================


struct  BFu15ll_BFu17i_BFu31i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu17i_BFu31i) C1{ FL:15 Fi:17 Fi:31}



static void Test_BFu15ll_BFu17i_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu31i, BFu15ll_BFu17i_BFu31i)
//============================================================================


struct  BFu15ll_BFu17i_BFu31ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu17i_BFu31ll) C1{ FL:15 Fi:17 FL:31}



static void Test_BFu15ll_BFu17i_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu31ll, BFu15ll_BFu17i_BFu31ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu32i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu17i_BFu32i) C1{ FL:15 Fi:17 Fi:32}



static void Test_BFu15ll_BFu17i_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu32i, BFu15ll_BFu17i_BFu32i)
//============================================================================


struct  BFu15ll_BFu17i_BFu32ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu17i_BFu32ll) C1{ FL:15 Fi:17 FL:32}



static void Test_BFu15ll_BFu17i_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu32ll, BFu15ll_BFu17i_BFu32ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu33  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu17i_BFu33) C1{ FL:15 Fi:17 FL:33}



static void Test_BFu15ll_BFu17i_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu33");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu15ll_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu33, BFu15ll_BFu17i_BFu33)
//============================================================================


struct  BFu15ll_BFu17i_BFu7c  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu17i_BFu7c) C1{ FL:15 Fi:17 Fc:7}



static void Test_BFu15ll_BFu17i_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu7c, BFu15ll_BFu17i_BFu7c)
//============================================================================


struct  BFu15ll_BFu17i_BFu7i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu17i_BFu7i) C1{ FL:15 Fi:17 Fi:7}



static void Test_BFu15ll_BFu17i_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu7i, BFu15ll_BFu17i_BFu7i)
//============================================================================


struct  BFu15ll_BFu17i_BFu7ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu17i_BFu7ll) C1{ FL:15 Fi:17 FL:7}



static void Test_BFu15ll_BFu17i_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu7ll, BFu15ll_BFu17i_BFu7ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu7s  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu17i_BFu7s) C1{ FL:15 Fi:17 Fs:7}



static void Test_BFu15ll_BFu17i_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu7s, BFu15ll_BFu17i_BFu7s)
//============================================================================


struct  BFu15ll_BFu17i_BFu8c  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu17i_BFu8c) C1{ FL:15 Fi:17 Fc:8}



static void Test_BFu15ll_BFu17i_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu8c, BFu15ll_BFu17i_BFu8c)
//============================================================================


struct  BFu15ll_BFu17i_BFu8i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu17i_BFu8i) C1{ FL:15 Fi:17 Fi:8}



static void Test_BFu15ll_BFu17i_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu8i, BFu15ll_BFu17i_BFu8i)
//============================================================================


struct  BFu15ll_BFu17i_BFu8ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu17i_BFu8ll) C1{ FL:15 Fi:17 FL:8}



static void Test_BFu15ll_BFu17i_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu8ll, BFu15ll_BFu17i_BFu8ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu8s  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu17i_BFu8s) C1{ FL:15 Fi:17 Fs:8}



static void Test_BFu15ll_BFu17i_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu8s, BFu15ll_BFu17i_BFu8s)
//============================================================================


struct  BFu15ll_BFu17i_BFu9i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu17i_BFu9i) C1{ FL:15 Fi:17 Fi:9}



static void Test_BFu15ll_BFu17i_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu9i, BFu15ll_BFu17i_BFu9i)
//============================================================================


struct  BFu15ll_BFu17i_BFu9ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu17i_BFu9ll) C1{ FL:15 Fi:17 FL:9}



static void Test_BFu15ll_BFu17i_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu9ll, BFu15ll_BFu17i_BFu9ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu9s  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu17i_BFu9s) C1{ FL:15 Fi:17 Fs:9}



static void Test_BFu15ll_BFu17i_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu9s, BFu15ll_BFu17i_BFu9s)
//============================================================================


struct  BFu15ll_BFu17i_C  {
  __tsu64 v1:15;
  unsigned int v2:17;
  char v3;
};
//SIG(1 BFu15ll_BFu17i_C) C1{ FL:15 Fi:17 Fc}



static void Test_BFu15ll_BFu17i_C()
{
  {
    init_simple_test("BFu15ll_BFu17i_C");
    static STRUCT_IF_C BFu15ll_BFu17i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_C");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_C");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_C");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_C, BFu15ll_BFu17i_C)
//============================================================================


struct  BFu15ll_BFu17i_D  {
  __tsu64 v1:15;
  unsigned int v2:17;
  double v3;
};
//SIG(1 BFu15ll_BFu17i_D) C1{ FL:15 Fi:17 FL}



static void Test_BFu15ll_BFu17i_D()
{
  {
    init_simple_test("BFu15ll_BFu17i_D");
    static STRUCT_IF_C BFu15ll_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_D");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_D");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_D, BFu15ll_BFu17i_D)
//============================================================================


struct  BFu15ll_BFu17i_F  {
  __tsu64 v1:15;
  unsigned int v2:17;
  float v3;
};
//SIG(1 BFu15ll_BFu17i_F) C1{ FL:15 Fi:17 Fi}



static void Test_BFu15ll_BFu17i_F()
{
  {
    init_simple_test("BFu15ll_BFu17i_F");
    static STRUCT_IF_C BFu15ll_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_F");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_F");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_F, BFu15ll_BFu17i_F)
//============================================================================


struct  BFu15ll_BFu17i_I  {
  __tsu64 v1:15;
  unsigned int v2:17;
  int v3;
};
//SIG(1 BFu15ll_BFu17i_I) C1{ FL:15 Fi:17 Fi}



static void Test_BFu15ll_BFu17i_I()
{
  {
    init_simple_test("BFu15ll_BFu17i_I");
    static STRUCT_IF_C BFu15ll_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_I");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_I");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_I, BFu15ll_BFu17i_I)
//============================================================================


struct  BFu15ll_BFu17i_Ip  {
  __tsu64 v1:15;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 BFu15ll_BFu17i_Ip) C1{ FL:15 Fi:17 Fp}



static void Test_BFu15ll_BFu17i_Ip()
{
  {
    init_simple_test("BFu15ll_BFu17i_Ip");
    static STRUCT_IF_C BFu15ll_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_Ip, BFu15ll_BFu17i_Ip)
//============================================================================


struct  BFu15ll_BFu17i_L  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu17i_L) C1{ FL:15 Fi:17 FL}



static void Test_BFu15ll_BFu17i_L()
{
  {
    init_simple_test("BFu15ll_BFu17i_L");
    static STRUCT_IF_C BFu15ll_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_L");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_L");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_L, BFu15ll_BFu17i_L)
//============================================================================


struct  BFu15ll_BFu17i_S  {
  __tsu64 v1:15;
  unsigned int v2:17;
  short v3;
};
//SIG(1 BFu15ll_BFu17i_S) C1{ FL:15 Fi:17 Fs}



static void Test_BFu15ll_BFu17i_S()
{
  {
    init_simple_test("BFu15ll_BFu17i_S");
    static STRUCT_IF_C BFu15ll_BFu17i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_S");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_S");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_S, BFu15ll_BFu17i_S)
//============================================================================


struct  BFu15ll_BFu17i_Uc  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu17i_Uc) C1{ FL:15 Fi:17 Fc}



static void Test_BFu15ll_BFu17i_Uc()
{
  {
    init_simple_test("BFu15ll_BFu17i_Uc");
    static STRUCT_IF_C BFu15ll_BFu17i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_Uc");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_Uc, BFu15ll_BFu17i_Uc)
//============================================================================


struct  BFu15ll_BFu17i_Ui  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu17i_Ui) C1{ FL:15 Fi:17 Fi}



static void Test_BFu15ll_BFu17i_Ui()
{
  {
    init_simple_test("BFu15ll_BFu17i_Ui");
    static STRUCT_IF_C BFu15ll_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_Ui, BFu15ll_BFu17i_Ui)
//============================================================================


struct  BFu15ll_BFu17i_Ul  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu17i_Ul) C1{ FL:15 Fi:17 FL}



static void Test_BFu15ll_BFu17i_Ul()
{
  {
    init_simple_test("BFu15ll_BFu17i_Ul");
    static STRUCT_IF_C BFu15ll_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_Ul, BFu15ll_BFu17i_Ul)
//============================================================================


struct  BFu15ll_BFu17i_Us  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu17i_Us) C1{ FL:15 Fi:17 Fs}



static void Test_BFu15ll_BFu17i_Us()
{
  {
    init_simple_test("BFu15ll_BFu17i_Us");
    static STRUCT_IF_C BFu15ll_BFu17i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_Us");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_Us");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_Us, BFu15ll_BFu17i_Us)
//============================================================================


struct  BFu15ll_BFu17i_Vp  {
  __tsu64 v1:15;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 BFu15ll_BFu17i_Vp) C1{ FL:15 Fi:17 Fp}



static void Test_BFu15ll_BFu17i_Vp()
{
  {
    init_simple_test("BFu15ll_BFu17i_Vp");
    static STRUCT_IF_C BFu15ll_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_Vp, BFu15ll_BFu17i_Vp)
//============================================================================


struct  BFu15ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
};
//SIG(1 BFu15ll_BFu17ll) C1{ FL:15 FL:17}



static void Test_BFu15ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll, BFu15ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu17ll_BFu15i) C1{ FL:15 FL:17 Fi:15}



static void Test_BFu15ll_BFu17ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu15i, BFu15ll_BFu17ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu17ll_BFu15ll) C1{ FL:15 FL:17 FL:15}



static void Test_BFu15ll_BFu17ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu15ll, BFu15ll_BFu17ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu17ll_BFu15s) C1{ FL:15 FL:17 Fs:15}



static void Test_BFu15ll_BFu17ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu15s, BFu15ll_BFu17ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu17ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu17ll_BFu16i) C1{ FL:15 FL:17 Fi:16}



static void Test_BFu15ll_BFu17ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu16i, BFu15ll_BFu17ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu17ll_BFu16ll) C1{ FL:15 FL:17 FL:16}



static void Test_BFu15ll_BFu17ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu16ll, BFu15ll_BFu17ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu17ll_BFu16s) C1{ FL:15 FL:17 Fs:16}



static void Test_BFu15ll_BFu17ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu16s, BFu15ll_BFu17ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu17ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu17ll_BFu17i) C1{ FL:15 FL:17 Fi:17}



static void Test_BFu15ll_BFu17ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu17i, BFu15ll_BFu17ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu17ll_BFu17ll) C1{ FL:15 FL:17 FL:17}



static void Test_BFu15ll_BFu17ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu17ll, BFu15ll_BFu17ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu17ll_BFu1c) C1{ FL:15 FL:17 Fc:1}



static void Test_BFu15ll_BFu17ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu1c, BFu15ll_BFu17ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu17ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu17ll_BFu1i) C1{ FL:15 FL:17 Fi:1}



static void Test_BFu15ll_BFu17ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu1i, BFu15ll_BFu17ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu17ll_BFu1ll) C1{ FL:15 FL:17 FL:1}



static void Test_BFu15ll_BFu17ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu1ll, BFu15ll_BFu17ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu17ll_BFu1s) C1{ FL:15 FL:17 Fs:1}



static void Test_BFu15ll_BFu17ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15ll_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu1s, BFu15ll_BFu17ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu17ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu17ll_BFu31i) C1{ FL:15 FL:17 Fi:31}



static void Test_BFu15ll_BFu17ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu31i, BFu15ll_BFu17ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu17ll_BFu31ll) C1{ FL:15 FL:17 FL:31}



static void Test_BFu15ll_BFu17ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu31ll, BFu15ll_BFu17ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu17ll_BFu32i) C1{ FL:15 FL:17 Fi:32}



static void Test_BFu15ll_BFu17ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu32i, BFu15ll_BFu17ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu17ll_BFu32ll) C1{ FL:15 FL:17 FL:32}



static void Test_BFu15ll_BFu17ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu32ll, BFu15ll_BFu17ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu17ll_BFu33) C1{ FL:15 FL:17 FL:33}



static void Test_BFu15ll_BFu17ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu15ll_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu33, BFu15ll_BFu17ll_BFu33)
//============================================================================


struct  BFu15ll_BFu17ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu17ll_BFu7c) C1{ FL:15 FL:17 Fc:7}



static void Test_BFu15ll_BFu17ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu7c, BFu15ll_BFu17ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu17ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu17ll_BFu7i) C1{ FL:15 FL:17 Fi:7}



static void Test_BFu15ll_BFu17ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu7i, BFu15ll_BFu17ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu17ll_BFu7ll) C1{ FL:15 FL:17 FL:7}



static void Test_BFu15ll_BFu17ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu7ll, BFu15ll_BFu17ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu17ll_BFu7s) C1{ FL:15 FL:17 Fs:7}



static void Test_BFu15ll_BFu17ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15ll_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu7s, BFu15ll_BFu17ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu17ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu17ll_BFu8c) C1{ FL:15 FL:17 Fc:8}



static void Test_BFu15ll_BFu17ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu8c, BFu15ll_BFu17ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu17ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu17ll_BFu8i) C1{ FL:15 FL:17 Fi:8}



static void Test_BFu15ll_BFu17ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu8i, BFu15ll_BFu17ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu17ll_BFu8ll) C1{ FL:15 FL:17 FL:8}



static void Test_BFu15ll_BFu17ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu8ll, BFu15ll_BFu17ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu17ll_BFu8s) C1{ FL:15 FL:17 Fs:8}



static void Test_BFu15ll_BFu17ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15ll_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu8s, BFu15ll_BFu17ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu17ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu17ll_BFu9i) C1{ FL:15 FL:17 Fi:9}



static void Test_BFu15ll_BFu17ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu9i, BFu15ll_BFu17ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu17ll_BFu9ll) C1{ FL:15 FL:17 FL:9}



static void Test_BFu15ll_BFu17ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu9ll, BFu15ll_BFu17ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu17ll_BFu9s) C1{ FL:15 FL:17 Fs:9}



static void Test_BFu15ll_BFu17ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu9s, BFu15ll_BFu17ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu17ll_C  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 BFu15ll_BFu17ll_C) C1{ FL:15 FL:17 Fc}



static void Test_BFu15ll_BFu17ll_C()
{
  {
    init_simple_test("BFu15ll_BFu17ll_C");
    static STRUCT_IF_C BFu15ll_BFu17ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_C");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_C");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_C");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_C, BFu15ll_BFu17ll_C)
//============================================================================


struct  BFu15ll_BFu17ll_D  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 BFu15ll_BFu17ll_D) C1{ FL:15 FL:17 FL}



static void Test_BFu15ll_BFu17ll_D()
{
  {
    init_simple_test("BFu15ll_BFu17ll_D");
    static STRUCT_IF_C BFu15ll_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_D");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_D");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_D, BFu15ll_BFu17ll_D)
//============================================================================


struct  BFu15ll_BFu17ll_F  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 BFu15ll_BFu17ll_F) C1{ FL:15 FL:17 Fi}



static void Test_BFu15ll_BFu17ll_F()
{
  {
    init_simple_test("BFu15ll_BFu17ll_F");
    static STRUCT_IF_C BFu15ll_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_F");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_F");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_F, BFu15ll_BFu17ll_F)
//============================================================================


struct  BFu15ll_BFu17ll_I  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 BFu15ll_BFu17ll_I) C1{ FL:15 FL:17 Fi}



static void Test_BFu15ll_BFu17ll_I()
{
  {
    init_simple_test("BFu15ll_BFu17ll_I");
    static STRUCT_IF_C BFu15ll_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_I");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_I");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_I, BFu15ll_BFu17ll_I)
//============================================================================


struct  BFu15ll_BFu17ll_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 BFu15ll_BFu17ll_Ip) C1{ FL:15 FL:17 Fp}



static void Test_BFu15ll_BFu17ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu17ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_Ip, BFu15ll_BFu17ll_Ip)
//============================================================================


struct  BFu15ll_BFu17ll_L  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu17ll_L) C1{ FL:15 FL:17 FL}



static void Test_BFu15ll_BFu17ll_L()
{
  {
    init_simple_test("BFu15ll_BFu17ll_L");
    static STRUCT_IF_C BFu15ll_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_L");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_L");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_L, BFu15ll_BFu17ll_L)
//============================================================================


struct  BFu15ll_BFu17ll_S  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 BFu15ll_BFu17ll_S) C1{ FL:15 FL:17 Fs}



static void Test_BFu15ll_BFu17ll_S()
{
  {
    init_simple_test("BFu15ll_BFu17ll_S");
    static STRUCT_IF_C BFu15ll_BFu17ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_S");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_S");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_S, BFu15ll_BFu17ll_S)
//============================================================================


struct  BFu15ll_BFu17ll_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu17ll_Uc) C1{ FL:15 FL:17 Fc}



static void Test_BFu15ll_BFu17ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu17ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu17ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_Uc");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_Uc, BFu15ll_BFu17ll_Uc)
//============================================================================


struct  BFu15ll_BFu17ll_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu17ll_Ui) C1{ FL:15 FL:17 Fi}



static void Test_BFu15ll_BFu17ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu17ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_Ui, BFu15ll_BFu17ll_Ui)
//============================================================================


struct  BFu15ll_BFu17ll_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu17ll_Ul) C1{ FL:15 FL:17 FL}



static void Test_BFu15ll_BFu17ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu17ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_Ul, BFu15ll_BFu17ll_Ul)
//============================================================================


struct  BFu15ll_BFu17ll_Us  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu17ll_Us) C1{ FL:15 FL:17 Fs}



static void Test_BFu15ll_BFu17ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu17ll_Us");
    static STRUCT_IF_C BFu15ll_BFu17ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_Us, BFu15ll_BFu17ll_Us)
//============================================================================


struct  BFu15ll_BFu17ll_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 BFu15ll_BFu17ll_Vp) C1{ FL:15 FL:17 Fp}



static void Test_BFu15ll_BFu17ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu17ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_Vp, BFu15ll_BFu17ll_Vp)
//============================================================================


struct  BFu15ll_BFu1c  {
  __tsu64 v1:15;
  unsigned char v2:1;
};
//SIG(1 BFu15ll_BFu1c) C1{ FL:15 Fc:1}



static void Test_BFu15ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c, BFu15ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu1c_BFu15i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu1c_BFu15i) C1{ FL:15 Fc:1 Fi:15}



static void Test_BFu15ll_BFu1c_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu15i, BFu15ll_BFu1c_BFu15i)
//============================================================================


struct  BFu15ll_BFu1c_BFu15ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu1c_BFu15ll) C1{ FL:15 Fc:1 FL:15}



static void Test_BFu15ll_BFu1c_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu15ll, BFu15ll_BFu1c_BFu15ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu15s  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu1c_BFu15s) C1{ FL:15 Fc:1 Fs:15}



static void Test_BFu15ll_BFu1c_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu15s, BFu15ll_BFu1c_BFu15s)
//============================================================================


struct  BFu15ll_BFu1c_BFu16i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu1c_BFu16i) C1{ FL:15 Fc:1 Fi:16}



static void Test_BFu15ll_BFu1c_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu16i, BFu15ll_BFu1c_BFu16i)
//============================================================================


struct  BFu15ll_BFu1c_BFu16ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu1c_BFu16ll) C1{ FL:15 Fc:1 FL:16}



static void Test_BFu15ll_BFu1c_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu16ll, BFu15ll_BFu1c_BFu16ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu16s  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu1c_BFu16s) C1{ FL:15 Fc:1 Fs:16}



static void Test_BFu15ll_BFu1c_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu16s, BFu15ll_BFu1c_BFu16s)
//============================================================================


struct  BFu15ll_BFu1c_BFu17i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu1c_BFu17i) C1{ FL:15 Fc:1 Fi:17}



static void Test_BFu15ll_BFu1c_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu17i, BFu15ll_BFu1c_BFu17i)
//============================================================================


struct  BFu15ll_BFu1c_BFu17ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu1c_BFu17ll) C1{ FL:15 Fc:1 FL:17}



static void Test_BFu15ll_BFu1c_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu15ll_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu17ll, BFu15ll_BFu1c_BFu17ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu1c  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu1c_BFu1c) C1{ FL:15 Fc:1 Fc:1}



static void Test_BFu15ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu1c, BFu15ll_BFu1c_BFu1c)
//============================================================================


struct  BFu15ll_BFu1c_BFu1i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu1c_BFu1i) C1{ FL:15 Fc:1 Fi:1}



static void Test_BFu15ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu1i, BFu15ll_BFu1c_BFu1i)
//============================================================================


struct  BFu15ll_BFu1c_BFu1ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu1c_BFu1ll) C1{ FL:15 Fc:1 FL:1}



static void Test_BFu15ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu1ll, BFu15ll_BFu1c_BFu1ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu1s  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu1c_BFu1s) C1{ FL:15 Fc:1 Fs:1}



static void Test_BFu15ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu1s, BFu15ll_BFu1c_BFu1s)
//============================================================================


struct  BFu15ll_BFu1c_BFu31i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu1c_BFu31i) C1{ FL:15 Fc:1 Fi:31}



static void Test_BFu15ll_BFu1c_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu31i, BFu15ll_BFu1c_BFu31i)
//============================================================================


struct  BFu15ll_BFu1c_BFu31ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu1c_BFu31ll) C1{ FL:15 Fc:1 FL:31}



static void Test_BFu15ll_BFu1c_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu15ll_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu31ll, BFu15ll_BFu1c_BFu31ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu32i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu1c_BFu32i) C1{ FL:15 Fc:1 Fi:32}



static void Test_BFu15ll_BFu1c_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu32i, BFu15ll_BFu1c_BFu32i)
//============================================================================


struct  BFu15ll_BFu1c_BFu32ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu1c_BFu32ll) C1{ FL:15 Fc:1 FL:32}



static void Test_BFu15ll_BFu1c_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu15ll_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu32ll, BFu15ll_BFu1c_BFu32ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu33  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu1c_BFu33) C1{ FL:15 Fc:1 FL:33}



static void Test_BFu15ll_BFu1c_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu33");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu15ll_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu33, BFu15ll_BFu1c_BFu33)
//============================================================================


struct  BFu15ll_BFu1c_BFu7c  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu1c_BFu7c) C1{ FL:15 Fc:1 Fc:7}



static void Test_BFu15ll_BFu1c_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu7c, BFu15ll_BFu1c_BFu7c)
//============================================================================


struct  BFu15ll_BFu1c_BFu7i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu1c_BFu7i) C1{ FL:15 Fc:1 Fi:7}



static void Test_BFu15ll_BFu1c_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu7i, BFu15ll_BFu1c_BFu7i)
//============================================================================


struct  BFu15ll_BFu1c_BFu7ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu1c_BFu7ll) C1{ FL:15 Fc:1 FL:7}



static void Test_BFu15ll_BFu1c_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu7ll, BFu15ll_BFu1c_BFu7ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu7s  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu1c_BFu7s) C1{ FL:15 Fc:1 Fs:7}



static void Test_BFu15ll_BFu1c_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu7s, BFu15ll_BFu1c_BFu7s)
//============================================================================


struct  BFu15ll_BFu1c_BFu8c  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu1c_BFu8c) C1{ FL:15 Fc:1 Fc:8}



static void Test_BFu15ll_BFu1c_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu8c, BFu15ll_BFu1c_BFu8c)
//============================================================================


struct  BFu15ll_BFu1c_BFu8i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu1c_BFu8i) C1{ FL:15 Fc:1 Fi:8}



static void Test_BFu15ll_BFu1c_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu8i, BFu15ll_BFu1c_BFu8i)
//============================================================================


struct  BFu15ll_BFu1c_BFu8ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu1c_BFu8ll) C1{ FL:15 Fc:1 FL:8}



static void Test_BFu15ll_BFu1c_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu8ll, BFu15ll_BFu1c_BFu8ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu8s  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu1c_BFu8s) C1{ FL:15 Fc:1 Fs:8}



static void Test_BFu15ll_BFu1c_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu8s, BFu15ll_BFu1c_BFu8s)
//============================================================================


struct  BFu15ll_BFu1c_BFu9i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu1c_BFu9i) C1{ FL:15 Fc:1 Fi:9}



static void Test_BFu15ll_BFu1c_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu9i, BFu15ll_BFu1c_BFu9i)
//============================================================================


struct  BFu15ll_BFu1c_BFu9ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu1c_BFu9ll) C1{ FL:15 Fc:1 FL:9}



static void Test_BFu15ll_BFu1c_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu9ll, BFu15ll_BFu1c_BFu9ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu9s  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu1c_BFu9s) C1{ FL:15 Fc:1 Fs:9}



static void Test_BFu15ll_BFu1c_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu9s, BFu15ll_BFu1c_BFu9s)
//============================================================================


struct  BFu15ll_BFu1c_C  {
  __tsu64 v1:15;
  unsigned char v2:1;
  char v3;
};
//SIG(1 BFu15ll_BFu1c_C) C1{ FL:15 Fc:1 Fc}



static void Test_BFu15ll_BFu1c_C()
{
  {
    init_simple_test("BFu15ll_BFu1c_C");
    static STRUCT_IF_C BFu15ll_BFu1c_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_C");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_C");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_C, BFu15ll_BFu1c_C)
//============================================================================


struct  BFu15ll_BFu1c_D  {
  __tsu64 v1:15;
  unsigned char v2:1;
  double v3;
};
//SIG(1 BFu15ll_BFu1c_D) C1{ FL:15 Fc:1 FL}



static void Test_BFu15ll_BFu1c_D()
{
  {
    init_simple_test("BFu15ll_BFu1c_D");
    static STRUCT_IF_C BFu15ll_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_D");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_D, BFu15ll_BFu1c_D)
//============================================================================


struct  BFu15ll_BFu1c_F  {
  __tsu64 v1:15;
  unsigned char v2:1;
  float v3;
};
//SIG(1 BFu15ll_BFu1c_F) C1{ FL:15 Fc:1 Fi}



static void Test_BFu15ll_BFu1c_F()
{
  {
    init_simple_test("BFu15ll_BFu1c_F");
    static STRUCT_IF_C BFu15ll_BFu1c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_F");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_F, BFu15ll_BFu1c_F)
//============================================================================


struct  BFu15ll_BFu1c_I  {
  __tsu64 v1:15;
  unsigned char v2:1;
  int v3;
};
//SIG(1 BFu15ll_BFu1c_I) C1{ FL:15 Fc:1 Fi}



static void Test_BFu15ll_BFu1c_I()
{
  {
    init_simple_test("BFu15ll_BFu1c_I");
    static STRUCT_IF_C BFu15ll_BFu1c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_I");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_I, BFu15ll_BFu1c_I)
//============================================================================


struct  BFu15ll_BFu1c_Ip  {
  __tsu64 v1:15;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 BFu15ll_BFu1c_Ip) C1{ FL:15 Fc:1 Fp}



static void Test_BFu15ll_BFu1c_Ip()
{
  {
    init_simple_test("BFu15ll_BFu1c_Ip");
    static STRUCT_IF_C BFu15ll_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_Ip");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_Ip, BFu15ll_BFu1c_Ip)
//============================================================================


struct  BFu15ll_BFu1c_L  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu1c_L) C1{ FL:15 Fc:1 FL}



static void Test_BFu15ll_BFu1c_L()
{
  {
    init_simple_test("BFu15ll_BFu1c_L");
    static STRUCT_IF_C BFu15ll_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_L");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_L, BFu15ll_BFu1c_L)
//============================================================================


struct  BFu15ll_BFu1c_S  {
  __tsu64 v1:15;
  unsigned char v2:1;
  short v3;
};
//SIG(1 BFu15ll_BFu1c_S) C1{ FL:15 Fc:1 Fs}



static void Test_BFu15ll_BFu1c_S()
{
  {
    init_simple_test("BFu15ll_BFu1c_S");
    static STRUCT_IF_C BFu15ll_BFu1c_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_S");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_S");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_S, BFu15ll_BFu1c_S)
//============================================================================


struct  BFu15ll_BFu1c_Uc  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu1c_Uc) C1{ FL:15 Fc:1 Fc}



static void Test_BFu15ll_BFu1c_Uc()
{
  {
    init_simple_test("BFu15ll_BFu1c_Uc");
    static STRUCT_IF_C BFu15ll_BFu1c_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_Uc");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_Uc");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_Uc, BFu15ll_BFu1c_Uc)
//============================================================================


struct  BFu15ll_BFu1c_Ui  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu1c_Ui) C1{ FL:15 Fc:1 Fi}



static void Test_BFu15ll_BFu1c_Ui()
{
  {
    init_simple_test("BFu15ll_BFu1c_Ui");
    static STRUCT_IF_C BFu15ll_BFu1c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_Ui");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_Ui, BFu15ll_BFu1c_Ui)
//============================================================================


struct  BFu15ll_BFu1c_Ul  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu1c_Ul) C1{ FL:15 Fc:1 FL}



static void Test_BFu15ll_BFu1c_Ul()
{
  {
    init_simple_test("BFu15ll_BFu1c_Ul");
    static STRUCT_IF_C BFu15ll_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_Ul");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_Ul, BFu15ll_BFu1c_Ul)
//============================================================================


struct  BFu15ll_BFu1c_Us  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu1c_Us) C1{ FL:15 Fc:1 Fs}



static void Test_BFu15ll_BFu1c_Us()
{
  {
    init_simple_test("BFu15ll_BFu1c_Us");
    static STRUCT_IF_C BFu15ll_BFu1c_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_Us");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_Us");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_Us, BFu15ll_BFu1c_Us)
//============================================================================


struct  BFu15ll_BFu1c_Vp  {
  __tsu64 v1:15;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 BFu15ll_BFu1c_Vp) C1{ FL:15 Fc:1 Fp}



static void Test_BFu15ll_BFu1c_Vp()
{
  {
    init_simple_test("BFu15ll_BFu1c_Vp");
    static STRUCT_IF_C BFu15ll_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_Vp");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_Vp, BFu15ll_BFu1c_Vp)
//============================================================================


struct  BFu15ll_BFu1i  {
  __tsu64 v1:15;
  unsigned int v2:1;
};
//SIG(1 BFu15ll_BFu1i) C1{ FL:15 Fi:1}



static void Test_BFu15ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i, BFu15ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu1i_BFu15i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu1i_BFu15i) C1{ FL:15 Fi:1 Fi:15}



static void Test_BFu15ll_BFu1i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu15i, BFu15ll_BFu1i_BFu15i)
//============================================================================


struct  BFu15ll_BFu1i_BFu15ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu1i_BFu15ll) C1{ FL:15 Fi:1 FL:15}



static void Test_BFu15ll_BFu1i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu15ll, BFu15ll_BFu1i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu15s  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu1i_BFu15s) C1{ FL:15 Fi:1 Fs:15}



static void Test_BFu15ll_BFu1i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu15s, BFu15ll_BFu1i_BFu15s)
//============================================================================


struct  BFu15ll_BFu1i_BFu16i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu1i_BFu16i) C1{ FL:15 Fi:1 Fi:16}



static void Test_BFu15ll_BFu1i_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu16i, BFu15ll_BFu1i_BFu16i)
//============================================================================


struct  BFu15ll_BFu1i_BFu16ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu1i_BFu16ll) C1{ FL:15 Fi:1 FL:16}



static void Test_BFu15ll_BFu1i_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu16ll, BFu15ll_BFu1i_BFu16ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu16s  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu1i_BFu16s) C1{ FL:15 Fi:1 Fs:16}



static void Test_BFu15ll_BFu1i_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu16s, BFu15ll_BFu1i_BFu16s)
//============================================================================


struct  BFu15ll_BFu1i_BFu17i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu1i_BFu17i) C1{ FL:15 Fi:1 Fi:17}



static void Test_BFu15ll_BFu1i_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu17i, BFu15ll_BFu1i_BFu17i)
//============================================================================


struct  BFu15ll_BFu1i_BFu17ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu1i_BFu17ll) C1{ FL:15 Fi:1 FL:17}



static void Test_BFu15ll_BFu1i_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu15ll_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu17ll, BFu15ll_BFu1i_BFu17ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu1c  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu1i_BFu1c) C1{ FL:15 Fi:1 Fc:1}



static void Test_BFu15ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu1c, BFu15ll_BFu1i_BFu1c)
//============================================================================


struct  BFu15ll_BFu1i_BFu1i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu1i_BFu1i) C1{ FL:15 Fi:1 Fi:1}



static void Test_BFu15ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu1i, BFu15ll_BFu1i_BFu1i)
//============================================================================


struct  BFu15ll_BFu1i_BFu1ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu1i_BFu1ll) C1{ FL:15 Fi:1 FL:1}



static void Test_BFu15ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu1ll, BFu15ll_BFu1i_BFu1ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu1s  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu1i_BFu1s) C1{ FL:15 Fi:1 Fs:1}



static void Test_BFu15ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu1s, BFu15ll_BFu1i_BFu1s)
//============================================================================


struct  BFu15ll_BFu1i_BFu31i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu1i_BFu31i) C1{ FL:15 Fi:1 Fi:31}



static void Test_BFu15ll_BFu1i_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu31i, BFu15ll_BFu1i_BFu31i)
//============================================================================


struct  BFu15ll_BFu1i_BFu31ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu1i_BFu31ll) C1{ FL:15 Fi:1 FL:31}



static void Test_BFu15ll_BFu1i_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu15ll_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu31ll, BFu15ll_BFu1i_BFu31ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu32i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu1i_BFu32i) C1{ FL:15 Fi:1 Fi:32}



static void Test_BFu15ll_BFu1i_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu32i, BFu15ll_BFu1i_BFu32i)
//============================================================================


struct  BFu15ll_BFu1i_BFu32ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu1i_BFu32ll) C1{ FL:15 Fi:1 FL:32}



static void Test_BFu15ll_BFu1i_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu15ll_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu32ll, BFu15ll_BFu1i_BFu32ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu33  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu1i_BFu33) C1{ FL:15 Fi:1 FL:33}



static void Test_BFu15ll_BFu1i_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu33");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu15ll_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu33, BFu15ll_BFu1i_BFu33)
//============================================================================


struct  BFu15ll_BFu1i_BFu7c  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu1i_BFu7c) C1{ FL:15 Fi:1 Fc:7}



static void Test_BFu15ll_BFu1i_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu7c, BFu15ll_BFu1i_BFu7c)
//============================================================================


struct  BFu15ll_BFu1i_BFu7i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu1i_BFu7i) C1{ FL:15 Fi:1 Fi:7}



static void Test_BFu15ll_BFu1i_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu7i, BFu15ll_BFu1i_BFu7i)
//============================================================================


struct  BFu15ll_BFu1i_BFu7ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu1i_BFu7ll) C1{ FL:15 Fi:1 FL:7}



static void Test_BFu15ll_BFu1i_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu7ll, BFu15ll_BFu1i_BFu7ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu7s  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu1i_BFu7s) C1{ FL:15 Fi:1 Fs:7}



static void Test_BFu15ll_BFu1i_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu7s, BFu15ll_BFu1i_BFu7s)
//============================================================================


struct  BFu15ll_BFu1i_BFu8c  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu1i_BFu8c) C1{ FL:15 Fi:1 Fc:8}



static void Test_BFu15ll_BFu1i_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu8c, BFu15ll_BFu1i_BFu8c)
//============================================================================


struct  BFu15ll_BFu1i_BFu8i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu1i_BFu8i) C1{ FL:15 Fi:1 Fi:8}



static void Test_BFu15ll_BFu1i_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu8i, BFu15ll_BFu1i_BFu8i)
//============================================================================


struct  BFu15ll_BFu1i_BFu8ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu1i_BFu8ll) C1{ FL:15 Fi:1 FL:8}



static void Test_BFu15ll_BFu1i_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu8ll, BFu15ll_BFu1i_BFu8ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu8s  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu1i_BFu8s) C1{ FL:15 Fi:1 Fs:8}



static void Test_BFu15ll_BFu1i_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu8s, BFu15ll_BFu1i_BFu8s)
//============================================================================


struct  BFu15ll_BFu1i_BFu9i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu1i_BFu9i) C1{ FL:15 Fi:1 Fi:9}



static void Test_BFu15ll_BFu1i_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu9i, BFu15ll_BFu1i_BFu9i)
//============================================================================


struct  BFu15ll_BFu1i_BFu9ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu1i_BFu9ll) C1{ FL:15 Fi:1 FL:9}



static void Test_BFu15ll_BFu1i_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu9ll, BFu15ll_BFu1i_BFu9ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu9s  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu1i_BFu9s) C1{ FL:15 Fi:1 Fs:9}



static void Test_BFu15ll_BFu1i_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu9s, BFu15ll_BFu1i_BFu9s)
//============================================================================


struct  BFu15ll_BFu1i_C  {
  __tsu64 v1:15;
  unsigned int v2:1;
  char v3;
};
//SIG(1 BFu15ll_BFu1i_C) C1{ FL:15 Fi:1 Fc}



static void Test_BFu15ll_BFu1i_C()
{
  {
    init_simple_test("BFu15ll_BFu1i_C");
    static STRUCT_IF_C BFu15ll_BFu1i_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_C");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_C");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_C, BFu15ll_BFu1i_C)
//============================================================================


struct  BFu15ll_BFu1i_D  {
  __tsu64 v1:15;
  unsigned int v2:1;
  double v3;
};
//SIG(1 BFu15ll_BFu1i_D) C1{ FL:15 Fi:1 FL}



static void Test_BFu15ll_BFu1i_D()
{
  {
    init_simple_test("BFu15ll_BFu1i_D");
    static STRUCT_IF_C BFu15ll_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_D");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_D, BFu15ll_BFu1i_D)
//============================================================================


struct  BFu15ll_BFu1i_F  {
  __tsu64 v1:15;
  unsigned int v2:1;
  float v3;
};
//SIG(1 BFu15ll_BFu1i_F) C1{ FL:15 Fi:1 Fi}



static void Test_BFu15ll_BFu1i_F()
{
  {
    init_simple_test("BFu15ll_BFu1i_F");
    static STRUCT_IF_C BFu15ll_BFu1i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_F");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_F, BFu15ll_BFu1i_F)
//============================================================================


struct  BFu15ll_BFu1i_I  {
  __tsu64 v1:15;
  unsigned int v2:1;
  int v3;
};
//SIG(1 BFu15ll_BFu1i_I) C1{ FL:15 Fi:1 Fi}



static void Test_BFu15ll_BFu1i_I()
{
  {
    init_simple_test("BFu15ll_BFu1i_I");
    static STRUCT_IF_C BFu15ll_BFu1i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_I");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_I, BFu15ll_BFu1i_I)
//============================================================================


struct  BFu15ll_BFu1i_Ip  {
  __tsu64 v1:15;
  unsigned int v2:1;
  int *v3;
};
//SIG(1 BFu15ll_BFu1i_Ip) C1{ FL:15 Fi:1 Fp}



static void Test_BFu15ll_BFu1i_Ip()
{
  {
    init_simple_test("BFu15ll_BFu1i_Ip");
    static STRUCT_IF_C BFu15ll_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_Ip, BFu15ll_BFu1i_Ip)
//============================================================================


struct  BFu15ll_BFu1i_L  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu1i_L) C1{ FL:15 Fi:1 FL}



static void Test_BFu15ll_BFu1i_L()
{
  {
    init_simple_test("BFu15ll_BFu1i_L");
    static STRUCT_IF_C BFu15ll_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_L");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_L, BFu15ll_BFu1i_L)
//============================================================================


struct  BFu15ll_BFu1i_S  {
  __tsu64 v1:15;
  unsigned int v2:1;
  short v3;
};
//SIG(1 BFu15ll_BFu1i_S) C1{ FL:15 Fi:1 Fs}



static void Test_BFu15ll_BFu1i_S()
{
  {
    init_simple_test("BFu15ll_BFu1i_S");
    static STRUCT_IF_C BFu15ll_BFu1i_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_S");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_S");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_S, BFu15ll_BFu1i_S)
//============================================================================


struct  BFu15ll_BFu1i_Uc  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu1i_Uc) C1{ FL:15 Fi:1 Fc}



static void Test_BFu15ll_BFu1i_Uc()
{
  {
    init_simple_test("BFu15ll_BFu1i_Uc");
    static STRUCT_IF_C BFu15ll_BFu1i_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_Uc");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_Uc, BFu15ll_BFu1i_Uc)
//============================================================================


struct  BFu15ll_BFu1i_Ui  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu1i_Ui) C1{ FL:15 Fi:1 Fi}



static void Test_BFu15ll_BFu1i_Ui()
{
  {
    init_simple_test("BFu15ll_BFu1i_Ui");
    static STRUCT_IF_C BFu15ll_BFu1i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_Ui, BFu15ll_BFu1i_Ui)
//============================================================================


struct  BFu15ll_BFu1i_Ul  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu1i_Ul) C1{ FL:15 Fi:1 FL}



static void Test_BFu15ll_BFu1i_Ul()
{
  {
    init_simple_test("BFu15ll_BFu1i_Ul");
    static STRUCT_IF_C BFu15ll_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_Ul, BFu15ll_BFu1i_Ul)
//============================================================================


struct  BFu15ll_BFu1i_Us  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu1i_Us) C1{ FL:15 Fi:1 Fs}



static void Test_BFu15ll_BFu1i_Us()
{
  {
    init_simple_test("BFu15ll_BFu1i_Us");
    static STRUCT_IF_C BFu15ll_BFu1i_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_Us");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_Us");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_Us, BFu15ll_BFu1i_Us)
//============================================================================


struct  BFu15ll_BFu1i_Vp  {
  __tsu64 v1:15;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 BFu15ll_BFu1i_Vp) C1{ FL:15 Fi:1 Fp}



static void Test_BFu15ll_BFu1i_Vp()
{
  {
    init_simple_test("BFu15ll_BFu1i_Vp");
    static STRUCT_IF_C BFu15ll_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_Vp, BFu15ll_BFu1i_Vp)
//============================================================================


struct  BFu15ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
};
//SIG(1 BFu15ll_BFu1ll) C1{ FL:15 FL:1}



static void Test_BFu15ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll, BFu15ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu1ll_BFu15i) C1{ FL:15 FL:1 Fi:15}



static void Test_BFu15ll_BFu1ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu15i, BFu15ll_BFu1ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu1ll_BFu15ll) C1{ FL:15 FL:1 FL:15}



static void Test_BFu15ll_BFu1ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu15ll, BFu15ll_BFu1ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu1ll_BFu15s) C1{ FL:15 FL:1 Fs:15}



static void Test_BFu15ll_BFu1ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu15s, BFu15ll_BFu1ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu1ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu1ll_BFu16i) C1{ FL:15 FL:1 Fi:16}



static void Test_BFu15ll_BFu1ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu16i, BFu15ll_BFu1ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu1ll_BFu16ll) C1{ FL:15 FL:1 FL:16}



static void Test_BFu15ll_BFu1ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu16ll, BFu15ll_BFu1ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu1ll_BFu16s) C1{ FL:15 FL:1 Fs:16}



static void Test_BFu15ll_BFu1ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu16s, BFu15ll_BFu1ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu1ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu1ll_BFu17i) C1{ FL:15 FL:1 Fi:17}



static void Test_BFu15ll_BFu1ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu17i, BFu15ll_BFu1ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu1ll_BFu17ll) C1{ FL:15 FL:1 FL:17}



static void Test_BFu15ll_BFu1ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu15ll_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu17ll, BFu15ll_BFu1ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu1ll_BFu1c) C1{ FL:15 FL:1 Fc:1}



static void Test_BFu15ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu1c, BFu15ll_BFu1ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu1ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu1ll_BFu1i) C1{ FL:15 FL:1 Fi:1}



static void Test_BFu15ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu1i, BFu15ll_BFu1ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu1ll_BFu1ll) C1{ FL:15 FL:1 FL:1}



static void Test_BFu15ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu1ll, BFu15ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu1ll_BFu1s) C1{ FL:15 FL:1 Fs:1}



static void Test_BFu15ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu1s, BFu15ll_BFu1ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu1ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu1ll_BFu31i) C1{ FL:15 FL:1 Fi:31}



static void Test_BFu15ll_BFu1ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu31i, BFu15ll_BFu1ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu1ll_BFu31ll) C1{ FL:15 FL:1 FL:31}



static void Test_BFu15ll_BFu1ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu15ll_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu31ll, BFu15ll_BFu1ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu1ll_BFu32i) C1{ FL:15 FL:1 Fi:32}



static void Test_BFu15ll_BFu1ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu32i, BFu15ll_BFu1ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu1ll_BFu32ll) C1{ FL:15 FL:1 FL:32}



static void Test_BFu15ll_BFu1ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu15ll_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu32ll, BFu15ll_BFu1ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu1ll_BFu33) C1{ FL:15 FL:1 FL:33}



static void Test_BFu15ll_BFu1ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu15ll_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu33, BFu15ll_BFu1ll_BFu33)
//============================================================================


struct  BFu15ll_BFu1ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu1ll_BFu7c) C1{ FL:15 FL:1 Fc:7}



static void Test_BFu15ll_BFu1ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu7c, BFu15ll_BFu1ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu1ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu1ll_BFu7i) C1{ FL:15 FL:1 Fi:7}



static void Test_BFu15ll_BFu1ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu7i, BFu15ll_BFu1ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu1ll_BFu7ll) C1{ FL:15 FL:1 FL:7}



static void Test_BFu15ll_BFu1ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu7ll, BFu15ll_BFu1ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu1ll_BFu7s) C1{ FL:15 FL:1 Fs:7}



static void Test_BFu15ll_BFu1ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu7s, BFu15ll_BFu1ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu1ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu1ll_BFu8c) C1{ FL:15 FL:1 Fc:8}



static void Test_BFu15ll_BFu1ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu8c, BFu15ll_BFu1ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu1ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu1ll_BFu8i) C1{ FL:15 FL:1 Fi:8}



static void Test_BFu15ll_BFu1ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu8i, BFu15ll_BFu1ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu1ll_BFu8ll) C1{ FL:15 FL:1 FL:8}



static void Test_BFu15ll_BFu1ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu8ll, BFu15ll_BFu1ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu1ll_BFu8s) C1{ FL:15 FL:1 Fs:8}



static void Test_BFu15ll_BFu1ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu8s, BFu15ll_BFu1ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu1ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu1ll_BFu9i) C1{ FL:15 FL:1 Fi:9}



static void Test_BFu15ll_BFu1ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu9i, BFu15ll_BFu1ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu1ll_BFu9ll) C1{ FL:15 FL:1 FL:9}



static void Test_BFu15ll_BFu1ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu9ll, BFu15ll_BFu1ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu1ll_BFu9s) C1{ FL:15 FL:1 Fs:9}



static void Test_BFu15ll_BFu1ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu9s, BFu15ll_BFu1ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu1ll_C  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 BFu15ll_BFu1ll_C) C1{ FL:15 FL:1 Fc}



static void Test_BFu15ll_BFu1ll_C()
{
  {
    init_simple_test("BFu15ll_BFu1ll_C");
    static STRUCT_IF_C BFu15ll_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_C");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_C");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_C, BFu15ll_BFu1ll_C)
//============================================================================


struct  BFu15ll_BFu1ll_D  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 BFu15ll_BFu1ll_D) C1{ FL:15 FL:1 FL}



static void Test_BFu15ll_BFu1ll_D()
{
  {
    init_simple_test("BFu15ll_BFu1ll_D");
    static STRUCT_IF_C BFu15ll_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_D");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_D, BFu15ll_BFu1ll_D)
//============================================================================


struct  BFu15ll_BFu1ll_F  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 BFu15ll_BFu1ll_F) C1{ FL:15 FL:1 Fi}



static void Test_BFu15ll_BFu1ll_F()
{
  {
    init_simple_test("BFu15ll_BFu1ll_F");
    static STRUCT_IF_C BFu15ll_BFu1ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_F");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_F, BFu15ll_BFu1ll_F)
//============================================================================


struct  BFu15ll_BFu1ll_I  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 BFu15ll_BFu1ll_I) C1{ FL:15 FL:1 Fi}



static void Test_BFu15ll_BFu1ll_I()
{
  {
    init_simple_test("BFu15ll_BFu1ll_I");
    static STRUCT_IF_C BFu15ll_BFu1ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_I");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_I, BFu15ll_BFu1ll_I)
//============================================================================


struct  BFu15ll_BFu1ll_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 BFu15ll_BFu1ll_Ip) C1{ FL:15 FL:1 Fp}



static void Test_BFu15ll_BFu1ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu1ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_Ip, BFu15ll_BFu1ll_Ip)
//============================================================================


struct  BFu15ll_BFu1ll_L  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu1ll_L) C1{ FL:15 FL:1 FL}



static void Test_BFu15ll_BFu1ll_L()
{
  {
    init_simple_test("BFu15ll_BFu1ll_L");
    static STRUCT_IF_C BFu15ll_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_L");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_L, BFu15ll_BFu1ll_L)
//============================================================================


struct  BFu15ll_BFu1ll_S  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 BFu15ll_BFu1ll_S) C1{ FL:15 FL:1 Fs}



static void Test_BFu15ll_BFu1ll_S()
{
  {
    init_simple_test("BFu15ll_BFu1ll_S");
    static STRUCT_IF_C BFu15ll_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_S");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_S");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_S, BFu15ll_BFu1ll_S)
//============================================================================


struct  BFu15ll_BFu1ll_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu1ll_Uc) C1{ FL:15 FL:1 Fc}



static void Test_BFu15ll_BFu1ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu1ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_Uc");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_Uc, BFu15ll_BFu1ll_Uc)
//============================================================================


struct  BFu15ll_BFu1ll_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu1ll_Ui) C1{ FL:15 FL:1 Fi}



static void Test_BFu15ll_BFu1ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu1ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu1ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_Ui, BFu15ll_BFu1ll_Ui)
//============================================================================


struct  BFu15ll_BFu1ll_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu1ll_Ul) C1{ FL:15 FL:1 FL}



static void Test_BFu15ll_BFu1ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu1ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_Ul, BFu15ll_BFu1ll_Ul)
//============================================================================


struct  BFu15ll_BFu1ll_Us  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu1ll_Us) C1{ FL:15 FL:1 Fs}



static void Test_BFu15ll_BFu1ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu1ll_Us");
    static STRUCT_IF_C BFu15ll_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_Us");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_Us, BFu15ll_BFu1ll_Us)
//============================================================================


struct  BFu15ll_BFu1ll_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 BFu15ll_BFu1ll_Vp) C1{ FL:15 FL:1 Fp}



static void Test_BFu15ll_BFu1ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu1ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_Vp, BFu15ll_BFu1ll_Vp)
//============================================================================


struct  BFu15ll_BFu1s  {
  __tsu64 v1:15;
  unsigned short v2:1;
};
//SIG(1 BFu15ll_BFu1s) C1{ FL:15 Fs:1}



static void Test_BFu15ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s, BFu15ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu1s_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu1s_BFu15i) C1{ FL:15 Fs:1 Fi:15}



static void Test_BFu15ll_BFu1s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu15i, BFu15ll_BFu1s_BFu15i)
//============================================================================


struct  BFu15ll_BFu1s_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu1s_BFu15ll) C1{ FL:15 Fs:1 FL:15}



static void Test_BFu15ll_BFu1s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu15ll, BFu15ll_BFu1s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu1s_BFu15s) C1{ FL:15 Fs:1 Fs:15}



static void Test_BFu15ll_BFu1s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu15ll_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu15s, BFu15ll_BFu1s_BFu15s)
//============================================================================


struct  BFu15ll_BFu1s_BFu16i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu1s_BFu16i) C1{ FL:15 Fs:1 Fi:16}



static void Test_BFu15ll_BFu1s_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu16i, BFu15ll_BFu1s_BFu16i)
//============================================================================


struct  BFu15ll_BFu1s_BFu16ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu1s_BFu16ll) C1{ FL:15 Fs:1 FL:16}



static void Test_BFu15ll_BFu1s_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu16ll, BFu15ll_BFu1s_BFu16ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu16s  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu1s_BFu16s) C1{ FL:15 Fs:1 Fs:16}



static void Test_BFu15ll_BFu1s_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu15ll_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu16s, BFu15ll_BFu1s_BFu16s)
//============================================================================


struct  BFu15ll_BFu1s_BFu17i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu1s_BFu17i) C1{ FL:15 Fs:1 Fi:17}



static void Test_BFu15ll_BFu1s_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu17i, BFu15ll_BFu1s_BFu17i)
//============================================================================


struct  BFu15ll_BFu1s_BFu17ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu1s_BFu17ll) C1{ FL:15 Fs:1 FL:17}



static void Test_BFu15ll_BFu1s_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu15ll_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu17ll, BFu15ll_BFu1s_BFu17ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu1c  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu1s_BFu1c) C1{ FL:15 Fs:1 Fc:1}



static void Test_BFu15ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu1c, BFu15ll_BFu1s_BFu1c)
//============================================================================


struct  BFu15ll_BFu1s_BFu1i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu1s_BFu1i) C1{ FL:15 Fs:1 Fi:1}



static void Test_BFu15ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu1i, BFu15ll_BFu1s_BFu1i)
//============================================================================


struct  BFu15ll_BFu1s_BFu1ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu1s_BFu1ll) C1{ FL:15 Fs:1 FL:1}



static void Test_BFu15ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu1ll, BFu15ll_BFu1s_BFu1ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu1s  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu1s_BFu1s) C1{ FL:15 Fs:1 Fs:1}



static void Test_BFu15ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu15ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu1s, BFu15ll_BFu1s_BFu1s)
//============================================================================


struct  BFu15ll_BFu1s_BFu31i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu1s_BFu31i) C1{ FL:15 Fs:1 Fi:31}



static void Test_BFu15ll_BFu1s_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu31i, BFu15ll_BFu1s_BFu31i)
//============================================================================


struct  BFu15ll_BFu1s_BFu31ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu1s_BFu31ll) C1{ FL:15 Fs:1 FL:31}



static void Test_BFu15ll_BFu1s_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu15ll_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu31ll, BFu15ll_BFu1s_BFu31ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu32i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu1s_BFu32i) C1{ FL:15 Fs:1 Fi:32}



static void Test_BFu15ll_BFu1s_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu32i, BFu15ll_BFu1s_BFu32i)
//============================================================================


struct  BFu15ll_BFu1s_BFu32ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu1s_BFu32ll) C1{ FL:15 Fs:1 FL:32}



static void Test_BFu15ll_BFu1s_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu15ll_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu32ll, BFu15ll_BFu1s_BFu32ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu33  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu1s_BFu33) C1{ FL:15 Fs:1 FL:33}



static void Test_BFu15ll_BFu1s_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu33");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu15ll_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu33, BFu15ll_BFu1s_BFu33)
//============================================================================


struct  BFu15ll_BFu1s_BFu7c  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu1s_BFu7c) C1{ FL:15 Fs:1 Fc:7}



static void Test_BFu15ll_BFu1s_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu7c, BFu15ll_BFu1s_BFu7c)
//============================================================================


struct  BFu15ll_BFu1s_BFu7i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu1s_BFu7i) C1{ FL:15 Fs:1 Fi:7}



static void Test_BFu15ll_BFu1s_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu7i, BFu15ll_BFu1s_BFu7i)
//============================================================================


struct  BFu15ll_BFu1s_BFu7ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu1s_BFu7ll) C1{ FL:15 Fs:1 FL:7}



static void Test_BFu15ll_BFu1s_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu7ll, BFu15ll_BFu1s_BFu7ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu7s  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu1s_BFu7s) C1{ FL:15 Fs:1 Fs:7}



static void Test_BFu15ll_BFu1s_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu15ll_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu7s, BFu15ll_BFu1s_BFu7s)
//============================================================================


struct  BFu15ll_BFu1s_BFu8c  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu1s_BFu8c) C1{ FL:15 Fs:1 Fc:8}



static void Test_BFu15ll_BFu1s_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu8c, BFu15ll_BFu1s_BFu8c)
//============================================================================


struct  BFu15ll_BFu1s_BFu8i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu1s_BFu8i) C1{ FL:15 Fs:1 Fi:8}



static void Test_BFu15ll_BFu1s_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu8i, BFu15ll_BFu1s_BFu8i)
//============================================================================


struct  BFu15ll_BFu1s_BFu8ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu1s_BFu8ll) C1{ FL:15 Fs:1 FL:8}



static void Test_BFu15ll_BFu1s_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu8ll, BFu15ll_BFu1s_BFu8ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu8s  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu1s_BFu8s) C1{ FL:15 Fs:1 Fs:8}



static void Test_BFu15ll_BFu1s_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu15ll_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu8s, BFu15ll_BFu1s_BFu8s)
//============================================================================


struct  BFu15ll_BFu1s_BFu9i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu1s_BFu9i) C1{ FL:15 Fs:1 Fi:9}



static void Test_BFu15ll_BFu1s_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu9i, BFu15ll_BFu1s_BFu9i)
//============================================================================


struct  BFu15ll_BFu1s_BFu9ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu1s_BFu9ll) C1{ FL:15 Fs:1 FL:9}



static void Test_BFu15ll_BFu1s_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu9ll, BFu15ll_BFu1s_BFu9ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu9s  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu1s_BFu9s) C1{ FL:15 Fs:1 Fs:9}



static void Test_BFu15ll_BFu1s_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu15ll_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu9s, BFu15ll_BFu1s_BFu9s)
//============================================================================


struct  BFu15ll_BFu1s_C  {
  __tsu64 v1:15;
  unsigned short v2:1;
  char v3;
};
//SIG(1 BFu15ll_BFu1s_C) C1{ FL:15 Fs:1 Fc}



static void Test_BFu15ll_BFu1s_C()
{
  {
    init_simple_test("BFu15ll_BFu1s_C");
    static STRUCT_IF_C BFu15ll_BFu1s_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_C");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_C");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_C, BFu15ll_BFu1s_C)
//============================================================================


struct  BFu15ll_BFu1s_D  {
  __tsu64 v1:15;
  unsigned short v2:1;
  double v3;
};
//SIG(1 BFu15ll_BFu1s_D) C1{ FL:15 Fs:1 FL}



static void Test_BFu15ll_BFu1s_D()
{
  {
    init_simple_test("BFu15ll_BFu1s_D");
    static STRUCT_IF_C BFu15ll_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_D");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_D, BFu15ll_BFu1s_D)
//============================================================================


struct  BFu15ll_BFu1s_F  {
  __tsu64 v1:15;
  unsigned short v2:1;
  float v3;
};
//SIG(1 BFu15ll_BFu1s_F) C1{ FL:15 Fs:1 Fi}



static void Test_BFu15ll_BFu1s_F()
{
  {
    init_simple_test("BFu15ll_BFu1s_F");
    static STRUCT_IF_C BFu15ll_BFu1s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_F");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_F, BFu15ll_BFu1s_F)
//============================================================================


struct  BFu15ll_BFu1s_I  {
  __tsu64 v1:15;
  unsigned short v2:1;
  int v3;
};
//SIG(1 BFu15ll_BFu1s_I) C1{ FL:15 Fs:1 Fi}



static void Test_BFu15ll_BFu1s_I()
{
  {
    init_simple_test("BFu15ll_BFu1s_I");
    static STRUCT_IF_C BFu15ll_BFu1s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_I");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_I, BFu15ll_BFu1s_I)
//============================================================================


struct  BFu15ll_BFu1s_Ip  {
  __tsu64 v1:15;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 BFu15ll_BFu1s_Ip) C1{ FL:15 Fs:1 Fp}



static void Test_BFu15ll_BFu1s_Ip()
{
  {
    init_simple_test("BFu15ll_BFu1s_Ip");
    static STRUCT_IF_C BFu15ll_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_Ip");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_Ip, BFu15ll_BFu1s_Ip)
//============================================================================


struct  BFu15ll_BFu1s_L  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu1s_L) C1{ FL:15 Fs:1 FL}



static void Test_BFu15ll_BFu1s_L()
{
  {
    init_simple_test("BFu15ll_BFu1s_L");
    static STRUCT_IF_C BFu15ll_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_L");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_L, BFu15ll_BFu1s_L)
//============================================================================


struct  BFu15ll_BFu1s_S  {
  __tsu64 v1:15;
  unsigned short v2:1;
  short v3;
};
//SIG(1 BFu15ll_BFu1s_S) C1{ FL:15 Fs:1 Fs}



static void Test_BFu15ll_BFu1s_S()
{
  {
    init_simple_test("BFu15ll_BFu1s_S");
    static STRUCT_IF_C BFu15ll_BFu1s_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_S");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_S");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_S, BFu15ll_BFu1s_S)
//============================================================================


struct  BFu15ll_BFu1s_Uc  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu1s_Uc) C1{ FL:15 Fs:1 Fc}



static void Test_BFu15ll_BFu1s_Uc()
{
  {
    init_simple_test("BFu15ll_BFu1s_Uc");
    static STRUCT_IF_C BFu15ll_BFu1s_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_Uc");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_Uc");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_Uc, BFu15ll_BFu1s_Uc)
//============================================================================


struct  BFu15ll_BFu1s_Ui  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu1s_Ui) C1{ FL:15 Fs:1 Fi}



static void Test_BFu15ll_BFu1s_Ui()
{
  {
    init_simple_test("BFu15ll_BFu1s_Ui");
    static STRUCT_IF_C BFu15ll_BFu1s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu1s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_Ui");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_Ui, BFu15ll_BFu1s_Ui)
//============================================================================


struct  BFu15ll_BFu1s_Ul  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu1s_Ul) C1{ FL:15 Fs:1 FL}



static void Test_BFu15ll_BFu1s_Ul()
{
  {
    init_simple_test("BFu15ll_BFu1s_Ul");
    static STRUCT_IF_C BFu15ll_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_Ul");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_Ul, BFu15ll_BFu1s_Ul)
//============================================================================


struct  BFu15ll_BFu1s_Us  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu1s_Us) C1{ FL:15 Fs:1 Fs}



static void Test_BFu15ll_BFu1s_Us()
{
  {
    init_simple_test("BFu15ll_BFu1s_Us");
    static STRUCT_IF_C BFu15ll_BFu1s_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_Us");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_Us");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_Us, BFu15ll_BFu1s_Us)
//============================================================================


struct  BFu15ll_BFu1s_Vp  {
  __tsu64 v1:15;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 BFu15ll_BFu1s_Vp) C1{ FL:15 Fs:1 Fp}



static void Test_BFu15ll_BFu1s_Vp()
{
  {
    init_simple_test("BFu15ll_BFu1s_Vp");
    static STRUCT_IF_C BFu15ll_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_Vp");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_Vp, BFu15ll_BFu1s_Vp)
//============================================================================


struct  BFu15ll_BFu31i  {
  __tsu64 v1:15;
  unsigned int v2:31;
};
//SIG(1 BFu15ll_BFu31i) C1{ FL:15 Fi:31}



static void Test_BFu15ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i, BFu15ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu31i_BFu15i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu31i_BFu15i) C1{ FL:15 Fi:31 Fi:15}



static void Test_BFu15ll_BFu31i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu15ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu15i, BFu15ll_BFu31i_BFu15i)
//============================================================================


struct  BFu15ll_BFu31i_BFu15ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu31i_BFu15ll) C1{ FL:15 Fi:31 FL:15}



static void Test_BFu15ll_BFu31i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "BFu15ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu15ll, BFu15ll_BFu31i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu15s  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu31i_BFu15s) C1{ FL:15 Fi:31 Fs:15}



static void Test_BFu15ll_BFu31i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu15ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu15s, BFu15ll_BFu31i_BFu15s)
//============================================================================


struct  BFu15ll_BFu31i_BFu16i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu31i_BFu16i) C1{ FL:15 Fi:31 Fi:16}



static void Test_BFu15ll_BFu31i_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu15ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu16i, BFu15ll_BFu31i_BFu16i)
//============================================================================


struct  BFu15ll_BFu31i_BFu16ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu31i_BFu16ll) C1{ FL:15 Fi:31 FL:16}



static void Test_BFu15ll_BFu31i_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "BFu15ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "BFu15ll_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu16ll, BFu15ll_BFu31i_BFu16ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu16s  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu31i_BFu16s) C1{ FL:15 Fi:31 Fs:16}



static void Test_BFu15ll_BFu31i_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu15ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu16s, BFu15ll_BFu31i_BFu16s)
//============================================================================


struct  BFu15ll_BFu31i_BFu17i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu31i_BFu17i) C1{ FL:15 Fi:31 Fi:17}



static void Test_BFu15ll_BFu31i_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu15ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu17i, BFu15ll_BFu31i_BFu17i)
//============================================================================


struct  BFu15ll_BFu31i_BFu17ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu31i_BFu17ll) C1{ FL:15 Fi:31 FL:17}



static void Test_BFu15ll_BFu31i_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "BFu15ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "BFu15ll_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu17ll, BFu15ll_BFu31i_BFu17ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu1c  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu31i_BFu1c) C1{ FL:15 Fi:31 Fc:1}



static void Test_BFu15ll_BFu31i_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "BFu15ll_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu1c, BFu15ll_BFu31i_BFu1c)
//============================================================================


struct  BFu15ll_BFu31i_BFu1i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu31i_BFu1i) C1{ FL:15 Fi:31 Fi:1}



static void Test_BFu15ll_BFu31i_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "BFu15ll_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu1i, BFu15ll_BFu31i_BFu1i)
//============================================================================


struct  BFu15ll_BFu31i_BFu1ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu31i_BFu1ll) C1{ FL:15 Fi:31 FL:1}



static void Test_BFu15ll_BFu31i_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "BFu15ll_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu1ll, BFu15ll_BFu31i_BFu1ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu1s  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu31i_BFu1s) C1{ FL:15 Fi:31 Fs:1}



static void Test_BFu15ll_BFu31i_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "BFu15ll_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu1s, BFu15ll_BFu31i_BFu1s)
//============================================================================


struct  BFu15ll_BFu31i_BFu31i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu31i_BFu31i) C1{ FL:15 Fi:31 Fi:31}



static void Test_BFu15ll_BFu31i_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu15ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu31i, BFu15ll_BFu31i_BFu31i)
//============================================================================


struct  BFu15ll_BFu31i_BFu31ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu31i_BFu31ll) C1{ FL:15 Fi:31 FL:31}



static void Test_BFu15ll_BFu31i_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFu15ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu31ll, BFu15ll_BFu31i_BFu31ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu32i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu31i_BFu32i) C1{ FL:15 Fi:31 Fi:32}



static void Test_BFu15ll_BFu31i_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu15ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu32i, BFu15ll_BFu31i_BFu32i)
//============================================================================


struct  BFu15ll_BFu31i_BFu32ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu31i_BFu32ll) C1{ FL:15 Fi:31 FL:32}



static void Test_BFu15ll_BFu31i_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "BFu15ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "BFu15ll_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu32ll, BFu15ll_BFu31i_BFu32ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu33  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu31i_BFu33) C1{ FL:15 Fi:31 FL:33}



static void Test_BFu15ll_BFu31i_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu33");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "BFu15ll_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "BFu15ll_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu33, BFu15ll_BFu31i_BFu33)
//============================================================================


struct  BFu15ll_BFu31i_BFu7c  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu31i_BFu7c) C1{ FL:15 Fi:31 Fc:7}



static void Test_BFu15ll_BFu31i_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu15ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu7c, BFu15ll_BFu31i_BFu7c)
//============================================================================


struct  BFu15ll_BFu31i_BFu7i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu31i_BFu7i) C1{ FL:15 Fi:31 Fi:7}



static void Test_BFu15ll_BFu31i_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu15ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu7i, BFu15ll_BFu31i_BFu7i)
//============================================================================


struct  BFu15ll_BFu31i_BFu7ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu31i_BFu7ll) C1{ FL:15 Fi:31 FL:7}



static void Test_BFu15ll_BFu31i_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "BFu15ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "BFu15ll_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu7ll, BFu15ll_BFu31i_BFu7ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu7s  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu31i_BFu7s) C1{ FL:15 Fi:31 Fs:7}



static void Test_BFu15ll_BFu31i_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu15ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu7s, BFu15ll_BFu31i_BFu7s)
//============================================================================


struct  BFu15ll_BFu31i_BFu8c  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu31i_BFu8c) C1{ FL:15 Fi:31 Fc:8}



static void Test_BFu15ll_BFu31i_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu15ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu8c, BFu15ll_BFu31i_BFu8c)
//============================================================================


struct  BFu15ll_BFu31i_BFu8i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu31i_BFu8i) C1{ FL:15 Fi:31 Fi:8}



static void Test_BFu15ll_BFu31i_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu15ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu8i, BFu15ll_BFu31i_BFu8i)
//============================================================================


struct  BFu15ll_BFu31i_BFu8ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu31i_BFu8ll) C1{ FL:15 Fi:31 FL:8}



static void Test_BFu15ll_BFu31i_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "BFu15ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "BFu15ll_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu8ll, BFu15ll_BFu31i_BFu8ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu8s  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu31i_BFu8s) C1{ FL:15 Fi:31 Fs:8}



static void Test_BFu15ll_BFu31i_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu15ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu8s, BFu15ll_BFu31i_BFu8s)
//============================================================================


struct  BFu15ll_BFu31i_BFu9i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu31i_BFu9i) C1{ FL:15 Fi:31 Fi:9}



static void Test_BFu15ll_BFu31i_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu15ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu9i, BFu15ll_BFu31i_BFu9i)
//============================================================================


struct  BFu15ll_BFu31i_BFu9ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu31i_BFu9ll) C1{ FL:15 Fi:31 FL:9}



static void Test_BFu15ll_BFu31i_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "BFu15ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "BFu15ll_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu9ll, BFu15ll_BFu31i_BFu9ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu9s  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu31i_BFu9s) C1{ FL:15 Fi:31 Fs:9}



static void Test_BFu15ll_BFu31i_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu15ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu9s, BFu15ll_BFu31i_BFu9s)
//============================================================================


struct  BFu15ll_BFu31i_C  {
  __tsu64 v1:15;
  unsigned int v2:31;
  char v3;
};
//SIG(1 BFu15ll_BFu31i_C) C1{ FL:15 Fi:31 Fc}



static void Test_BFu15ll_BFu31i_C()
{
  {
    init_simple_test("BFu15ll_BFu31i_C");
    static STRUCT_IF_C BFu15ll_BFu31i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_C");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_C, BFu15ll_BFu31i_C)
//============================================================================


struct  BFu15ll_BFu31i_D  {
  __tsu64 v1:15;
  unsigned int v2:31;
  double v3;
};
//SIG(1 BFu15ll_BFu31i_D) C1{ FL:15 Fi:31 FL}



static void Test_BFu15ll_BFu31i_D()
{
  {
    init_simple_test("BFu15ll_BFu31i_D");
    static STRUCT_IF_C BFu15ll_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_D");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_D, BFu15ll_BFu31i_D)
//============================================================================


struct  BFu15ll_BFu31i_F  {
  __tsu64 v1:15;
  unsigned int v2:31;
  float v3;
};
//SIG(1 BFu15ll_BFu31i_F) C1{ FL:15 Fi:31 Fi}



static void Test_BFu15ll_BFu31i_F()
{
  {
    init_simple_test("BFu15ll_BFu31i_F");
    static STRUCT_IF_C BFu15ll_BFu31i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_F");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_F, BFu15ll_BFu31i_F)
//============================================================================


struct  BFu15ll_BFu31i_I  {
  __tsu64 v1:15;
  unsigned int v2:31;
  int v3;
};
//SIG(1 BFu15ll_BFu31i_I) C1{ FL:15 Fi:31 Fi}



static void Test_BFu15ll_BFu31i_I()
{
  {
    init_simple_test("BFu15ll_BFu31i_I");
    static STRUCT_IF_C BFu15ll_BFu31i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_I");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_I, BFu15ll_BFu31i_I)
//============================================================================


struct  BFu15ll_BFu31i_Ip  {
  __tsu64 v1:15;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 BFu15ll_BFu31i_Ip) C1{ FL:15 Fi:31 Fp}



static void Test_BFu15ll_BFu31i_Ip()
{
  {
    init_simple_test("BFu15ll_BFu31i_Ip");
    static STRUCT_IF_C BFu15ll_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_Ip, BFu15ll_BFu31i_Ip)
//============================================================================


struct  BFu15ll_BFu31i_L  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu31i_L) C1{ FL:15 Fi:31 FL}



static void Test_BFu15ll_BFu31i_L()
{
  {
    init_simple_test("BFu15ll_BFu31i_L");
    static STRUCT_IF_C BFu15ll_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_L");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_L, BFu15ll_BFu31i_L)
//============================================================================


struct  BFu15ll_BFu31i_S  {
  __tsu64 v1:15;
  unsigned int v2:31;
  short v3;
};
//SIG(1 BFu15ll_BFu31i_S) C1{ FL:15 Fi:31 Fs}



static void Test_BFu15ll_BFu31i_S()
{
  {
    init_simple_test("BFu15ll_BFu31i_S");
    static STRUCT_IF_C BFu15ll_BFu31i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_S");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_S, BFu15ll_BFu31i_S)
//============================================================================


struct  BFu15ll_BFu31i_Uc  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu31i_Uc) C1{ FL:15 Fi:31 Fc}



static void Test_BFu15ll_BFu31i_Uc()
{
  {
    init_simple_test("BFu15ll_BFu31i_Uc");
    static STRUCT_IF_C BFu15ll_BFu31i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_Uc, BFu15ll_BFu31i_Uc)
//============================================================================


struct  BFu15ll_BFu31i_Ui  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu31i_Ui) C1{ FL:15 Fi:31 Fi}



static void Test_BFu15ll_BFu31i_Ui()
{
  {
    init_simple_test("BFu15ll_BFu31i_Ui");
    static STRUCT_IF_C BFu15ll_BFu31i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_Ui, BFu15ll_BFu31i_Ui)
//============================================================================


struct  BFu15ll_BFu31i_Ul  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu31i_Ul) C1{ FL:15 Fi:31 FL}



static void Test_BFu15ll_BFu31i_Ul()
{
  {
    init_simple_test("BFu15ll_BFu31i_Ul");
    static STRUCT_IF_C BFu15ll_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_Ul, BFu15ll_BFu31i_Ul)
//============================================================================


struct  BFu15ll_BFu31i_Us  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu31i_Us) C1{ FL:15 Fi:31 Fs}



static void Test_BFu15ll_BFu31i_Us()
{
  {
    init_simple_test("BFu15ll_BFu31i_Us");
    static STRUCT_IF_C BFu15ll_BFu31i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_Us");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_Us, BFu15ll_BFu31i_Us)
//============================================================================


struct  BFu15ll_BFu31i_Vp  {
  __tsu64 v1:15;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 BFu15ll_BFu31i_Vp) C1{ FL:15 Fi:31 Fp}



static void Test_BFu15ll_BFu31i_Vp()
{
  {
    init_simple_test("BFu15ll_BFu31i_Vp");
    static STRUCT_IF_C BFu15ll_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_Vp, BFu15ll_BFu31i_Vp)
//============================================================================


struct  BFu15ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
};
//SIG(1 BFu15ll_BFu31ll) C1{ FL:15 FL:31}



static void Test_BFu15ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll, BFu15ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu31ll_BFu15i) C1{ FL:15 FL:31 Fi:15}



static void Test_BFu15ll_BFu31ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 6, 15, 1, "BFu15ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu15i, BFu15ll_BFu31ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu31ll_BFu15ll) C1{ FL:15 FL:31 FL:15}



static void Test_BFu15ll_BFu31ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 6, 15, 1, "BFu15ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu15ll, BFu15ll_BFu31ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu31ll_BFu15s) C1{ FL:15 FL:31 Fs:15}



static void Test_BFu15ll_BFu31ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu15s, BFu15ll_BFu31ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu31ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu31ll_BFu16i) C1{ FL:15 FL:31 Fi:16}



static void Test_BFu15ll_BFu31ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 6, 16, 1, "BFu15ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 6, 16, hide_ull(1LL<<15), "BFu15ll_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu16i, BFu15ll_BFu31ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu31ll_BFu16ll) C1{ FL:15 FL:31 FL:16}



static void Test_BFu15ll_BFu31ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 6, 16, 1, "BFu15ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 6, 16, hide_ull(1LL<<15), "BFu15ll_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu16ll, BFu15ll_BFu31ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu31ll_BFu16s) C1{ FL:15 FL:31 Fs:16}



static void Test_BFu15ll_BFu31ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu16s, BFu15ll_BFu31ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu31ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu31ll_BFu17i) C1{ FL:15 FL:31 Fi:17}



static void Test_BFu15ll_BFu31ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 6, 17, 1, "BFu15ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 6, 17, hide_ull(1LL<<16), "BFu15ll_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu17i, BFu15ll_BFu31ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu31ll_BFu17ll) C1{ FL:15 FL:31 FL:17}



static void Test_BFu15ll_BFu31ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 6, 17, 1, "BFu15ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 6, 17, hide_ull(1LL<<16), "BFu15ll_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu17ll, BFu15ll_BFu31ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu31ll_BFu1c) C1{ FL:15 FL:31 Fc:1}



static void Test_BFu15ll_BFu31ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 6, 1, 1, "BFu15ll_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu1c, BFu15ll_BFu31ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu31ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu31ll_BFu1i) C1{ FL:15 FL:31 Fi:1}



static void Test_BFu15ll_BFu31ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 6, 1, 1, "BFu15ll_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu1i, BFu15ll_BFu31ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu31ll_BFu1ll) C1{ FL:15 FL:31 FL:1}



static void Test_BFu15ll_BFu31ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 6, 1, 1, "BFu15ll_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu1ll, BFu15ll_BFu31ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu31ll_BFu1s) C1{ FL:15 FL:31 Fs:1}



static void Test_BFu15ll_BFu31ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 6, 1, 1, "BFu15ll_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu1s, BFu15ll_BFu31ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu31ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu31ll_BFu31i) C1{ FL:15 FL:31 Fi:31}



static void Test_BFu15ll_BFu31ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu15ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu31i, BFu15ll_BFu31ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu31ll_BFu31ll) C1{ FL:15 FL:31 FL:31}



static void Test_BFu15ll_BFu31ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,6), 31, 1, "BFu15ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,6), 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu31ll, BFu15ll_BFu31ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu31ll_BFu32i) C1{ FL:15 FL:31 Fi:32}



static void Test_BFu15ll_BFu31ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu15ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu32i, BFu15ll_BFu31ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu31ll_BFu32ll) C1{ FL:15 FL:31 FL:32}



static void Test_BFu15ll_BFu31ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,6), 32, 1, "BFu15ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,6), 32, hide_ull(1LL<<31), "BFu15ll_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu32ll, BFu15ll_BFu31ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu31ll_BFu33) C1{ FL:15 FL:31 FL:33}



static void Test_BFu15ll_BFu31ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,6), 33, 1, "BFu15ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,6), 33, hide_ull(1LL<<32), "BFu15ll_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu33, BFu15ll_BFu31ll_BFu33)
//============================================================================


struct  BFu15ll_BFu31ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu31ll_BFu7c) C1{ FL:15 FL:31 Fc:7}



static void Test_BFu15ll_BFu31ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu7c, BFu15ll_BFu31ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu31ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu31ll_BFu7i) C1{ FL:15 FL:31 Fi:7}



static void Test_BFu15ll_BFu31ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 6, 7, 1, "BFu15ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu7i, BFu15ll_BFu31ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu31ll_BFu7ll) C1{ FL:15 FL:31 FL:7}



static void Test_BFu15ll_BFu31ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 6, 7, 1, "BFu15ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu7ll, BFu15ll_BFu31ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu31ll_BFu7s) C1{ FL:15 FL:31 Fs:7}



static void Test_BFu15ll_BFu31ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu7s, BFu15ll_BFu31ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu31ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu31ll_BFu8c) C1{ FL:15 FL:31 Fc:8}



static void Test_BFu15ll_BFu31ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu8c, BFu15ll_BFu31ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu31ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu31ll_BFu8i) C1{ FL:15 FL:31 Fi:8}



static void Test_BFu15ll_BFu31ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 6, 8, 1, "BFu15ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu8i, BFu15ll_BFu31ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu31ll_BFu8ll) C1{ FL:15 FL:31 FL:8}



static void Test_BFu15ll_BFu31ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 6, 8, 1, "BFu15ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu8ll, BFu15ll_BFu31ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu31ll_BFu8s) C1{ FL:15 FL:31 Fs:8}



static void Test_BFu15ll_BFu31ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu8s, BFu15ll_BFu31ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu31ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu31ll_BFu9i) C1{ FL:15 FL:31 Fi:9}



static void Test_BFu15ll_BFu31ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 6, 9, 1, "BFu15ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu9i, BFu15ll_BFu31ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu31ll_BFu9ll) C1{ FL:15 FL:31 FL:9}



static void Test_BFu15ll_BFu31ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 6, 9, 1, "BFu15ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu9ll, BFu15ll_BFu31ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu31ll_BFu9s) C1{ FL:15 FL:31 Fs:9}



static void Test_BFu15ll_BFu31ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu9s, BFu15ll_BFu31ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu31ll_C  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 BFu15ll_BFu31ll_C) C1{ FL:15 FL:31 Fc}



static void Test_BFu15ll_BFu31ll_C()
{
  {
    init_simple_test("BFu15ll_BFu31ll_C");
    static STRUCT_IF_C BFu15ll_BFu31ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_C");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_C");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_C");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_C, BFu15ll_BFu31ll_C)
//============================================================================


struct  BFu15ll_BFu31ll_D  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 BFu15ll_BFu31ll_D) C1{ FL:15 FL:31 FL}



static void Test_BFu15ll_BFu31ll_D()
{
  {
    init_simple_test("BFu15ll_BFu31ll_D");
    static STRUCT_IF_C BFu15ll_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_D");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_D");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_D");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_D, BFu15ll_BFu31ll_D)
//============================================================================


struct  BFu15ll_BFu31ll_F  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 BFu15ll_BFu31ll_F) C1{ FL:15 FL:31 Fi}



static void Test_BFu15ll_BFu31ll_F()
{
  {
    init_simple_test("BFu15ll_BFu31ll_F");
    static STRUCT_IF_C BFu15ll_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_F");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_F");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_F");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_F, BFu15ll_BFu31ll_F)
//============================================================================


struct  BFu15ll_BFu31ll_I  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 BFu15ll_BFu31ll_I) C1{ FL:15 FL:31 Fi}



static void Test_BFu15ll_BFu31ll_I()
{
  {
    init_simple_test("BFu15ll_BFu31ll_I");
    static STRUCT_IF_C BFu15ll_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_I");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_I");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_I");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_I, BFu15ll_BFu31ll_I)
//============================================================================


struct  BFu15ll_BFu31ll_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 BFu15ll_BFu31ll_Ip) C1{ FL:15 FL:31 Fp}



static void Test_BFu15ll_BFu31ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu31ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_Ip, BFu15ll_BFu31ll_Ip)
//============================================================================


struct  BFu15ll_BFu31ll_L  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu31ll_L) C1{ FL:15 FL:31 FL}



static void Test_BFu15ll_BFu31ll_L()
{
  {
    init_simple_test("BFu15ll_BFu31ll_L");
    static STRUCT_IF_C BFu15ll_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_L");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_L");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_L");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_L, BFu15ll_BFu31ll_L)
//============================================================================


struct  BFu15ll_BFu31ll_S  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 BFu15ll_BFu31ll_S) C1{ FL:15 FL:31 Fs}



static void Test_BFu15ll_BFu31ll_S()
{
  {
    init_simple_test("BFu15ll_BFu31ll_S");
    static STRUCT_IF_C BFu15ll_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_S");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_S");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_S");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_S, BFu15ll_BFu31ll_S)
//============================================================================


struct  BFu15ll_BFu31ll_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu31ll_Uc) C1{ FL:15 FL:31 Fc}



static void Test_BFu15ll_BFu31ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu31ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu31ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_Uc");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_Uc, BFu15ll_BFu31ll_Uc)
//============================================================================


struct  BFu15ll_BFu31ll_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu31ll_Ui) C1{ FL:15 FL:31 Fi}



static void Test_BFu15ll_BFu31ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu31ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_Ui, BFu15ll_BFu31ll_Ui)
//============================================================================


struct  BFu15ll_BFu31ll_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu31ll_Ul) C1{ FL:15 FL:31 FL}



static void Test_BFu15ll_BFu31ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu31ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_Ul, BFu15ll_BFu31ll_Ul)
//============================================================================


struct  BFu15ll_BFu31ll_Us  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu31ll_Us) C1{ FL:15 FL:31 Fs}



static void Test_BFu15ll_BFu31ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu31ll_Us");
    static STRUCT_IF_C BFu15ll_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_Us");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_Us, BFu15ll_BFu31ll_Us)
//============================================================================


struct  BFu15ll_BFu31ll_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 BFu15ll_BFu31ll_Vp) C1{ FL:15 FL:31 Fp}



static void Test_BFu15ll_BFu31ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu31ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_Vp, BFu15ll_BFu31ll_Vp)
//============================================================================


struct  BFu15ll_BFu32i  {
  __tsu64 v1:15;
  unsigned int v2:32;
};
//SIG(1 BFu15ll_BFu32i) C1{ FL:15 Fi:32}



static void Test_BFu15ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i, BFu15ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu32i_BFu15i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu32i_BFu15i) C1{ FL:15 Fi:32 Fi:15}



static void Test_BFu15ll_BFu32i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu15ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu15i, BFu15ll_BFu32i_BFu15i)
//============================================================================


struct  BFu15ll_BFu32i_BFu15ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu32i_BFu15ll) C1{ FL:15 Fi:32 FL:15}



static void Test_BFu15ll_BFu32i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu15ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu15ll, BFu15ll_BFu32i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu15s  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu32i_BFu15s) C1{ FL:15 Fi:32 Fs:15}



static void Test_BFu15ll_BFu32i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "BFu15ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu15s, BFu15ll_BFu32i_BFu15s)
//============================================================================


struct  BFu15ll_BFu32i_BFu16i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu32i_BFu16i) C1{ FL:15 Fi:32 Fi:16}



static void Test_BFu15ll_BFu32i_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu15ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu16i, BFu15ll_BFu32i_BFu16i)
//============================================================================


struct  BFu15ll_BFu32i_BFu16ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu32i_BFu16ll) C1{ FL:15 Fi:32 FL:16}



static void Test_BFu15ll_BFu32i_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu15ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu16ll, BFu15ll_BFu32i_BFu16ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu16s  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu32i_BFu16s) C1{ FL:15 Fi:32 Fs:16}



static void Test_BFu15ll_BFu32i_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "BFu15ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu16s, BFu15ll_BFu32i_BFu16s)
//============================================================================


struct  BFu15ll_BFu32i_BFu17i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu32i_BFu17i) C1{ FL:15 Fi:32 Fi:17}



static void Test_BFu15ll_BFu32i_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu15ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu17i, BFu15ll_BFu32i_BFu17i)
//============================================================================


struct  BFu15ll_BFu32i_BFu17ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu32i_BFu17ll) C1{ FL:15 Fi:32 FL:17}



static void Test_BFu15ll_BFu32i_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu15ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu17ll, BFu15ll_BFu32i_BFu17ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu1c  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu32i_BFu1c) C1{ FL:15 Fi:32 Fc:1}



static void Test_BFu15ll_BFu32i_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu15ll_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu1c, BFu15ll_BFu32i_BFu1c)
//============================================================================


struct  BFu15ll_BFu32i_BFu1i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu32i_BFu1i) C1{ FL:15 Fi:32 Fi:1}



static void Test_BFu15ll_BFu32i_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu15ll_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu1i, BFu15ll_BFu32i_BFu1i)
//============================================================================


struct  BFu15ll_BFu32i_BFu1ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu32i_BFu1ll) C1{ FL:15 Fi:32 FL:1}



static void Test_BFu15ll_BFu32i_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu15ll_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu1ll, BFu15ll_BFu32i_BFu1ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu1s  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu32i_BFu1s) C1{ FL:15 Fi:32 Fs:1}



static void Test_BFu15ll_BFu32i_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "BFu15ll_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu1s, BFu15ll_BFu32i_BFu1s)
//============================================================================


struct  BFu15ll_BFu32i_BFu31i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu32i_BFu31i) C1{ FL:15 Fi:32 Fi:31}



static void Test_BFu15ll_BFu32i_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu15ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu31i, BFu15ll_BFu32i_BFu31i)
//============================================================================


struct  BFu15ll_BFu32i_BFu31ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu32i_BFu31ll) C1{ FL:15 Fi:32 FL:31}



static void Test_BFu15ll_BFu32i_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu15ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu31ll, BFu15ll_BFu32i_BFu31ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu32i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu32i_BFu32i) C1{ FL:15 Fi:32 Fi:32}



static void Test_BFu15ll_BFu32i_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu15ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu32i, BFu15ll_BFu32i_BFu32i)
//============================================================================


struct  BFu15ll_BFu32i_BFu32ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu32i_BFu32ll) C1{ FL:15 Fi:32 FL:32}



static void Test_BFu15ll_BFu32i_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu15ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu32ll, BFu15ll_BFu32i_BFu32ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu33  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu32i_BFu33) C1{ FL:15 Fi:32 FL:33}



static void Test_BFu15ll_BFu32i_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu33");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "BFu15ll_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu33, BFu15ll_BFu32i_BFu33)
//============================================================================


struct  BFu15ll_BFu32i_BFu7c  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu32i_BFu7c) C1{ FL:15 Fi:32 Fc:7}



static void Test_BFu15ll_BFu32i_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu15ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu7c, BFu15ll_BFu32i_BFu7c)
//============================================================================


struct  BFu15ll_BFu32i_BFu7i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu32i_BFu7i) C1{ FL:15 Fi:32 Fi:7}



static void Test_BFu15ll_BFu32i_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu15ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu7i, BFu15ll_BFu32i_BFu7i)
//============================================================================


struct  BFu15ll_BFu32i_BFu7ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu32i_BFu7ll) C1{ FL:15 Fi:32 FL:7}



static void Test_BFu15ll_BFu32i_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu15ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu7ll, BFu15ll_BFu32i_BFu7ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu7s  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu32i_BFu7s) C1{ FL:15 Fi:32 Fs:7}



static void Test_BFu15ll_BFu32i_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "BFu15ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu7s, BFu15ll_BFu32i_BFu7s)
//============================================================================


struct  BFu15ll_BFu32i_BFu8c  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu32i_BFu8c) C1{ FL:15 Fi:32 Fc:8}



static void Test_BFu15ll_BFu32i_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu15ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu8c, BFu15ll_BFu32i_BFu8c)
//============================================================================


struct  BFu15ll_BFu32i_BFu8i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu32i_BFu8i) C1{ FL:15 Fi:32 Fi:8}



static void Test_BFu15ll_BFu32i_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu15ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu8i, BFu15ll_BFu32i_BFu8i)
//============================================================================


struct  BFu15ll_BFu32i_BFu8ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu32i_BFu8ll) C1{ FL:15 Fi:32 FL:8}



static void Test_BFu15ll_BFu32i_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu15ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu8ll, BFu15ll_BFu32i_BFu8ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu8s  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu32i_BFu8s) C1{ FL:15 Fi:32 Fs:8}



static void Test_BFu15ll_BFu32i_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "BFu15ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu8s, BFu15ll_BFu32i_BFu8s)
//============================================================================


struct  BFu15ll_BFu32i_BFu9i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu32i_BFu9i) C1{ FL:15 Fi:32 Fi:9}



static void Test_BFu15ll_BFu32i_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu15ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu9i, BFu15ll_BFu32i_BFu9i)
//============================================================================


struct  BFu15ll_BFu32i_BFu9ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu32i_BFu9ll) C1{ FL:15 Fi:32 FL:9}



static void Test_BFu15ll_BFu32i_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu15ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu9ll, BFu15ll_BFu32i_BFu9ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu9s  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu32i_BFu9s) C1{ FL:15 Fi:32 Fs:9}



static void Test_BFu15ll_BFu32i_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "BFu15ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu9s, BFu15ll_BFu32i_BFu9s)
//============================================================================


struct  BFu15ll_BFu32i_C  {
  __tsu64 v1:15;
  unsigned int v2:32;
  char v3;
};
//SIG(1 BFu15ll_BFu32i_C) C1{ FL:15 Fi:32 Fc}



static void Test_BFu15ll_BFu32i_C()
{
  {
    init_simple_test("BFu15ll_BFu32i_C");
    static STRUCT_IF_C BFu15ll_BFu32i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_C");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_C, BFu15ll_BFu32i_C)
//============================================================================


struct  BFu15ll_BFu32i_D  {
  __tsu64 v1:15;
  unsigned int v2:32;
  double v3;
};
//SIG(1 BFu15ll_BFu32i_D) C1{ FL:15 Fi:32 FL}



static void Test_BFu15ll_BFu32i_D()
{
  {
    init_simple_test("BFu15ll_BFu32i_D");
    static STRUCT_IF_C BFu15ll_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_D");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_D, BFu15ll_BFu32i_D)
//============================================================================


struct  BFu15ll_BFu32i_F  {
  __tsu64 v1:15;
  unsigned int v2:32;
  float v3;
};
//SIG(1 BFu15ll_BFu32i_F) C1{ FL:15 Fi:32 Fi}



static void Test_BFu15ll_BFu32i_F()
{
  {
    init_simple_test("BFu15ll_BFu32i_F");
    static STRUCT_IF_C BFu15ll_BFu32i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_F");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_F, BFu15ll_BFu32i_F)
//============================================================================


struct  BFu15ll_BFu32i_I  {
  __tsu64 v1:15;
  unsigned int v2:32;
  int v3;
};
//SIG(1 BFu15ll_BFu32i_I) C1{ FL:15 Fi:32 Fi}



static void Test_BFu15ll_BFu32i_I()
{
  {
    init_simple_test("BFu15ll_BFu32i_I");
    static STRUCT_IF_C BFu15ll_BFu32i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_I");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_I, BFu15ll_BFu32i_I)
//============================================================================


struct  BFu15ll_BFu32i_Ip  {
  __tsu64 v1:15;
  unsigned int v2:32;
  int *v3;
};
//SIG(1 BFu15ll_BFu32i_Ip) C1{ FL:15 Fi:32 Fp}



static void Test_BFu15ll_BFu32i_Ip()
{
  {
    init_simple_test("BFu15ll_BFu32i_Ip");
    static STRUCT_IF_C BFu15ll_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_Ip, BFu15ll_BFu32i_Ip)
//============================================================================


struct  BFu15ll_BFu32i_L  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu32i_L) C1{ FL:15 Fi:32 FL}



static void Test_BFu15ll_BFu32i_L()
{
  {
    init_simple_test("BFu15ll_BFu32i_L");
    static STRUCT_IF_C BFu15ll_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_L");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_L, BFu15ll_BFu32i_L)
//============================================================================


struct  BFu15ll_BFu32i_S  {
  __tsu64 v1:15;
  unsigned int v2:32;
  short v3;
};
//SIG(1 BFu15ll_BFu32i_S) C1{ FL:15 Fi:32 Fs}



static void Test_BFu15ll_BFu32i_S()
{
  {
    init_simple_test("BFu15ll_BFu32i_S");
    static STRUCT_IF_C BFu15ll_BFu32i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_S");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_S, BFu15ll_BFu32i_S)
//============================================================================


struct  BFu15ll_BFu32i_Uc  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu32i_Uc) C1{ FL:15 Fi:32 Fc}



static void Test_BFu15ll_BFu32i_Uc()
{
  {
    init_simple_test("BFu15ll_BFu32i_Uc");
    static STRUCT_IF_C BFu15ll_BFu32i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_Uc, BFu15ll_BFu32i_Uc)
//============================================================================


struct  BFu15ll_BFu32i_Ui  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu32i_Ui) C1{ FL:15 Fi:32 Fi}



static void Test_BFu15ll_BFu32i_Ui()
{
  {
    init_simple_test("BFu15ll_BFu32i_Ui");
    static STRUCT_IF_C BFu15ll_BFu32i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_Ui, BFu15ll_BFu32i_Ui)
//============================================================================


struct  BFu15ll_BFu32i_Ul  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu32i_Ul) C1{ FL:15 Fi:32 FL}



static void Test_BFu15ll_BFu32i_Ul()
{
  {
    init_simple_test("BFu15ll_BFu32i_Ul");
    static STRUCT_IF_C BFu15ll_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_Ul, BFu15ll_BFu32i_Ul)
//============================================================================


struct  BFu15ll_BFu32i_Us  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu32i_Us) C1{ FL:15 Fi:32 Fs}



static void Test_BFu15ll_BFu32i_Us()
{
  {
    init_simple_test("BFu15ll_BFu32i_Us");
    static STRUCT_IF_C BFu15ll_BFu32i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_Us");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_Us, BFu15ll_BFu32i_Us)
//============================================================================


struct  BFu15ll_BFu32i_Vp  {
  __tsu64 v1:15;
  unsigned int v2:32;
  void *v3;
};
//SIG(1 BFu15ll_BFu32i_Vp) C1{ FL:15 Fi:32 Fp}



static void Test_BFu15ll_BFu32i_Vp()
{
  {
    init_simple_test("BFu15ll_BFu32i_Vp");
    static STRUCT_IF_C BFu15ll_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_Vp, BFu15ll_BFu32i_Vp)
//============================================================================


struct  BFu15ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
};
//SIG(1 BFu15ll_BFu32ll) C1{ FL:15 FL:32}



static void Test_BFu15ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll, BFu15ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu32ll_BFu15i) C1{ FL:15 FL:32 Fi:15}



static void Test_BFu15ll_BFu32ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "BFu15ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu15i, BFu15ll_BFu32ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu32ll_BFu15ll) C1{ FL:15 FL:32 FL:15}



static void Test_BFu15ll_BFu32ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "BFu15ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu15ll, BFu15ll_BFu32ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu32ll_BFu15s) C1{ FL:15 FL:32 Fs:15}



static void Test_BFu15ll_BFu32ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu15s, BFu15ll_BFu32ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu32ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu32ll_BFu16i) C1{ FL:15 FL:32 Fi:16}



static void Test_BFu15ll_BFu32ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "BFu15ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu16i, BFu15ll_BFu32ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu32ll_BFu16ll) C1{ FL:15 FL:32 FL:16}



static void Test_BFu15ll_BFu32ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "BFu15ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu16ll, BFu15ll_BFu32ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu32ll_BFu16s) C1{ FL:15 FL:32 Fs:16}



static void Test_BFu15ll_BFu32ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu16s, BFu15ll_BFu32ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu32ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu32ll_BFu17i) C1{ FL:15 FL:32 Fi:17}



static void Test_BFu15ll_BFu32ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "BFu15ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu17i, BFu15ll_BFu32ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu32ll_BFu17ll) C1{ FL:15 FL:32 FL:17}



static void Test_BFu15ll_BFu32ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "BFu15ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu17ll, BFu15ll_BFu32ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu32ll_BFu1c) C1{ FL:15 FL:32 Fc:1}



static void Test_BFu15ll_BFu32ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "BFu15ll_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu1c, BFu15ll_BFu32ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu32ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu32ll_BFu1i) C1{ FL:15 FL:32 Fi:1}



static void Test_BFu15ll_BFu32ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "BFu15ll_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu1i, BFu15ll_BFu32ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu32ll_BFu1ll) C1{ FL:15 FL:32 FL:1}



static void Test_BFu15ll_BFu32ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "BFu15ll_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu1ll, BFu15ll_BFu32ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu32ll_BFu1s) C1{ FL:15 FL:32 Fs:1}



static void Test_BFu15ll_BFu32ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "BFu15ll_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu1s, BFu15ll_BFu32ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu32ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu32ll_BFu31i) C1{ FL:15 FL:32 Fi:31}



static void Test_BFu15ll_BFu32ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu15ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu31i, BFu15ll_BFu32ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu32ll_BFu31ll) C1{ FL:15 FL:32 FL:31}



static void Test_BFu15ll_BFu32ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, 1, "BFu15ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, hide_ull(1LL<<30), "BFu15ll_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu31ll, BFu15ll_BFu32ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu32ll_BFu32i) C1{ FL:15 FL:32 Fi:32}



static void Test_BFu15ll_BFu32ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu15ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu32i, BFu15ll_BFu32ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu32ll_BFu32ll) C1{ FL:15 FL:32 FL:32}



static void Test_BFu15ll_BFu32ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, 1, "BFu15ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu32ll, BFu15ll_BFu32ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu32ll_BFu33) C1{ FL:15 FL:32 FL:33}



static void Test_BFu15ll_BFu32ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, 1, "BFu15ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, hide_ull(1LL<<32), "BFu15ll_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu33, BFu15ll_BFu32ll_BFu33)
//============================================================================


struct  BFu15ll_BFu32ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu32ll_BFu7c) C1{ FL:15 FL:32 Fc:7}



static void Test_BFu15ll_BFu32ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu7c, BFu15ll_BFu32ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu32ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu32ll_BFu7i) C1{ FL:15 FL:32 Fi:7}



static void Test_BFu15ll_BFu32ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "BFu15ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu7i, BFu15ll_BFu32ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu32ll_BFu7ll) C1{ FL:15 FL:32 FL:7}



static void Test_BFu15ll_BFu32ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "BFu15ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu7ll, BFu15ll_BFu32ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu32ll_BFu7s) C1{ FL:15 FL:32 Fs:7}



static void Test_BFu15ll_BFu32ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu7s, BFu15ll_BFu32ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu32ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu32ll_BFu8c) C1{ FL:15 FL:32 Fc:8}



static void Test_BFu15ll_BFu32ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu8c, BFu15ll_BFu32ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu32ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu32ll_BFu8i) C1{ FL:15 FL:32 Fi:8}



static void Test_BFu15ll_BFu32ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "BFu15ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu8i, BFu15ll_BFu32ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu32ll_BFu8ll) C1{ FL:15 FL:32 FL:8}



static void Test_BFu15ll_BFu32ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "BFu15ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu8ll, BFu15ll_BFu32ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu32ll_BFu8s) C1{ FL:15 FL:32 Fs:8}



static void Test_BFu15ll_BFu32ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu8s, BFu15ll_BFu32ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu32ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu32ll_BFu9i) C1{ FL:15 FL:32 Fi:9}



static void Test_BFu15ll_BFu32ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "BFu15ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu9i, BFu15ll_BFu32ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu32ll_BFu9ll) C1{ FL:15 FL:32 FL:9}



static void Test_BFu15ll_BFu32ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "BFu15ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu9ll, BFu15ll_BFu32ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu32ll_BFu9s) C1{ FL:15 FL:32 Fs:9}



static void Test_BFu15ll_BFu32ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu9s, BFu15ll_BFu32ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu32ll_C  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  char v3;
};
//SIG(1 BFu15ll_BFu32ll_C) C1{ FL:15 FL:32 Fc}



static void Test_BFu15ll_BFu32ll_C()
{
  {
    init_simple_test("BFu15ll_BFu32ll_C");
    static STRUCT_IF_C BFu15ll_BFu32ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_C");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_C");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_C");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_C, BFu15ll_BFu32ll_C)
//============================================================================


struct  BFu15ll_BFu32ll_D  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  double v3;
};
//SIG(1 BFu15ll_BFu32ll_D) C1{ FL:15 FL:32 FL}



static void Test_BFu15ll_BFu32ll_D()
{
  {
    init_simple_test("BFu15ll_BFu32ll_D");
    static STRUCT_IF_C BFu15ll_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_D");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_D");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_D");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_D, BFu15ll_BFu32ll_D)
//============================================================================


struct  BFu15ll_BFu32ll_F  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  float v3;
};
//SIG(1 BFu15ll_BFu32ll_F) C1{ FL:15 FL:32 Fi}



static void Test_BFu15ll_BFu32ll_F()
{
  {
    init_simple_test("BFu15ll_BFu32ll_F");
    static STRUCT_IF_C BFu15ll_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_F");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_F");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_F");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_F, BFu15ll_BFu32ll_F)
//============================================================================


struct  BFu15ll_BFu32ll_I  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  int v3;
};
//SIG(1 BFu15ll_BFu32ll_I) C1{ FL:15 FL:32 Fi}



static void Test_BFu15ll_BFu32ll_I()
{
  {
    init_simple_test("BFu15ll_BFu32ll_I");
    static STRUCT_IF_C BFu15ll_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_I");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_I");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_I");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_I, BFu15ll_BFu32ll_I)
//============================================================================


struct  BFu15ll_BFu32ll_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  int *v3;
};
//SIG(1 BFu15ll_BFu32ll_Ip) C1{ FL:15 FL:32 Fp}



static void Test_BFu15ll_BFu32ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu32ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_Ip, BFu15ll_BFu32ll_Ip)
//============================================================================


struct  BFu15ll_BFu32ll_L  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu32ll_L) C1{ FL:15 FL:32 FL}



static void Test_BFu15ll_BFu32ll_L()
{
  {
    init_simple_test("BFu15ll_BFu32ll_L");
    static STRUCT_IF_C BFu15ll_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_L");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_L");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_L");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_L, BFu15ll_BFu32ll_L)
//============================================================================


struct  BFu15ll_BFu32ll_S  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  short v3;
};
//SIG(1 BFu15ll_BFu32ll_S) C1{ FL:15 FL:32 Fs}



static void Test_BFu15ll_BFu32ll_S()
{
  {
    init_simple_test("BFu15ll_BFu32ll_S");
    static STRUCT_IF_C BFu15ll_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_S");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_S");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_S");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_S, BFu15ll_BFu32ll_S)
//============================================================================


struct  BFu15ll_BFu32ll_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu32ll_Uc) C1{ FL:15 FL:32 Fc}



static void Test_BFu15ll_BFu32ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu32ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu32ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_Uc");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_Uc, BFu15ll_BFu32ll_Uc)
//============================================================================


struct  BFu15ll_BFu32ll_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu32ll_Ui) C1{ FL:15 FL:32 Fi}



static void Test_BFu15ll_BFu32ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu32ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_Ui, BFu15ll_BFu32ll_Ui)
//============================================================================


struct  BFu15ll_BFu32ll_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu32ll_Ul) C1{ FL:15 FL:32 FL}



static void Test_BFu15ll_BFu32ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu32ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_Ul, BFu15ll_BFu32ll_Ul)
//============================================================================


struct  BFu15ll_BFu32ll_Us  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu32ll_Us) C1{ FL:15 FL:32 Fs}



static void Test_BFu15ll_BFu32ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu32ll_Us");
    static STRUCT_IF_C BFu15ll_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_Us");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_Us, BFu15ll_BFu32ll_Us)
//============================================================================


struct  BFu15ll_BFu32ll_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  void *v3;
};
//SIG(1 BFu15ll_BFu32ll_Vp) C1{ FL:15 FL:32 Fp}



static void Test_BFu15ll_BFu32ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu32ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_Vp, BFu15ll_BFu32ll_Vp)
//============================================================================


struct  BFu15ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:33;
};
//SIG(1 BFu15ll_BFu33) C1{ FL:15 FL:33}



static void Test_BFu15ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33, BFu15ll_BFu33)
//============================================================================


struct  BFu15ll_BFu33_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu33_BFu15i) C1{ FL:15 FL:33 Fi:15}



static void Test_BFu15ll_BFu33_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15ll_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu15i, BFu15ll_BFu33_BFu15i)
//============================================================================


struct  BFu15ll_BFu33_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu33_BFu15ll) C1{ FL:15 FL:33 FL:15}



static void Test_BFu15ll_BFu33_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu15ll, BFu15ll_BFu33_BFu15ll)
//============================================================================


struct  BFu15ll_BFu33_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu33_BFu15s) C1{ FL:15 FL:33 Fs:15}



static void Test_BFu15ll_BFu33_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15ll_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu15s, BFu15ll_BFu33_BFu15s)
//============================================================================


struct  BFu15ll_BFu33_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu33_BFu16i) C1{ FL:15 FL:33 Fi:16}



static void Test_BFu15ll_BFu33_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15ll_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu16i, BFu15ll_BFu33_BFu16i)
//============================================================================


struct  BFu15ll_BFu33_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu33_BFu16ll) C1{ FL:15 FL:33 FL:16}



static void Test_BFu15ll_BFu33_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu16ll, BFu15ll_BFu33_BFu16ll)
//============================================================================


struct  BFu15ll_BFu33_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu33_BFu16s) C1{ FL:15 FL:33 Fs:16}



static void Test_BFu15ll_BFu33_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15ll_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu16s, BFu15ll_BFu33_BFu16s)
//============================================================================


struct  BFu15ll_BFu33_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu33_BFu17i) C1{ FL:15 FL:33 Fi:17}



static void Test_BFu15ll_BFu33_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu15ll_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu17i, BFu15ll_BFu33_BFu17i)
//============================================================================


struct  BFu15ll_BFu33_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu33_BFu17ll) C1{ FL:15 FL:33 FL:17}



static void Test_BFu15ll_BFu33_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "BFu15ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu17ll, BFu15ll_BFu33_BFu17ll)
//============================================================================


struct  BFu15ll_BFu33_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu33_BFu1c) C1{ FL:15 FL:33 Fc:1}



static void Test_BFu15ll_BFu33_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu33_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15ll_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu1c, BFu15ll_BFu33_BFu1c)
//============================================================================


struct  BFu15ll_BFu33_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu33_BFu1i) C1{ FL:15 FL:33 Fi:1}



static void Test_BFu15ll_BFu33_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15ll_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu1i, BFu15ll_BFu33_BFu1i)
//============================================================================


struct  BFu15ll_BFu33_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu33_BFu1ll) C1{ FL:15 FL:33 FL:1}



static void Test_BFu15ll_BFu33_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15ll_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu1ll, BFu15ll_BFu33_BFu1ll)
//============================================================================


struct  BFu15ll_BFu33_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu33_BFu1s) C1{ FL:15 FL:33 Fs:1}



static void Test_BFu15ll_BFu33_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu33_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15ll_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu1s, BFu15ll_BFu33_BFu1s)
//============================================================================


struct  BFu15ll_BFu33_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu33_BFu31i) C1{ FL:15 FL:33 Fi:31}



static void Test_BFu15ll_BFu33_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu15ll_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu31i, BFu15ll_BFu33_BFu31i)
//============================================================================


struct  BFu15ll_BFu33_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu33_BFu31ll) C1{ FL:15 FL:33 FL:31}



static void Test_BFu15ll_BFu33_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "BFu15ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu31ll, BFu15ll_BFu33_BFu31ll)
//============================================================================


struct  BFu15ll_BFu33_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu33_BFu32i) C1{ FL:15 FL:33 Fi:32}



static void Test_BFu15ll_BFu33_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu15ll_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu32i, BFu15ll_BFu33_BFu32i)
//============================================================================


struct  BFu15ll_BFu33_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu33_BFu32ll) C1{ FL:15 FL:33 FL:32}



static void Test_BFu15ll_BFu33_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "BFu15ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu32ll, BFu15ll_BFu33_BFu32ll)
//============================================================================


struct  BFu15ll_BFu33_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu33_BFu33) C1{ FL:15 FL:33 FL:33}



static void Test_BFu15ll_BFu33_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu33");
    static STRUCT_IF_C BFu15ll_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "BFu15ll_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu33, BFu15ll_BFu33_BFu33)
//============================================================================


struct  BFu15ll_BFu33_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu33_BFu7c) C1{ FL:15 FL:33 Fc:7}



static void Test_BFu15ll_BFu33_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu33_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15ll_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu7c, BFu15ll_BFu33_BFu7c)
//============================================================================


struct  BFu15ll_BFu33_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu33_BFu7i) C1{ FL:15 FL:33 Fi:7}



static void Test_BFu15ll_BFu33_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15ll_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu7i, BFu15ll_BFu33_BFu7i)
//============================================================================


struct  BFu15ll_BFu33_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu33_BFu7ll) C1{ FL:15 FL:33 FL:7}



static void Test_BFu15ll_BFu33_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu7ll, BFu15ll_BFu33_BFu7ll)
//============================================================================


struct  BFu15ll_BFu33_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu33_BFu7s) C1{ FL:15 FL:33 Fs:7}



static void Test_BFu15ll_BFu33_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu33_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15ll_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu7s, BFu15ll_BFu33_BFu7s)
//============================================================================


struct  BFu15ll_BFu33_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu33_BFu8c) C1{ FL:15 FL:33 Fc:8}



static void Test_BFu15ll_BFu33_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15ll_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu8c, BFu15ll_BFu33_BFu8c)
//============================================================================


struct  BFu15ll_BFu33_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu33_BFu8i) C1{ FL:15 FL:33 Fi:8}



static void Test_BFu15ll_BFu33_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15ll_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu8i, BFu15ll_BFu33_BFu8i)
//============================================================================


struct  BFu15ll_BFu33_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu33_BFu8ll) C1{ FL:15 FL:33 FL:8}



static void Test_BFu15ll_BFu33_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu8ll, BFu15ll_BFu33_BFu8ll)
//============================================================================


struct  BFu15ll_BFu33_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu33_BFu8s) C1{ FL:15 FL:33 Fs:8}



static void Test_BFu15ll_BFu33_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15ll_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu8s, BFu15ll_BFu33_BFu8s)
//============================================================================


struct  BFu15ll_BFu33_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu33_BFu9i) C1{ FL:15 FL:33 Fi:9}



static void Test_BFu15ll_BFu33_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15ll_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu9i, BFu15ll_BFu33_BFu9i)
//============================================================================


struct  BFu15ll_BFu33_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu33_BFu9ll) C1{ FL:15 FL:33 FL:9}



static void Test_BFu15ll_BFu33_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu9ll, BFu15ll_BFu33_BFu9ll)
//============================================================================


struct  BFu15ll_BFu33_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu33_BFu9s) C1{ FL:15 FL:33 Fs:9}



static void Test_BFu15ll_BFu33_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15ll_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu9s, BFu15ll_BFu33_BFu9s)
//============================================================================


struct  BFu15ll_BFu33_C  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 BFu15ll_BFu33_C) C1{ FL:15 FL:33 Fc}



static void Test_BFu15ll_BFu33_C()
{
  {
    init_simple_test("BFu15ll_BFu33_C");
    static STRUCT_IF_C BFu15ll_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_C");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_C");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_C");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_C, BFu15ll_BFu33_C)
//============================================================================


struct  BFu15ll_BFu33_D  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 BFu15ll_BFu33_D) C1{ FL:15 FL:33 FL}



static void Test_BFu15ll_BFu33_D()
{
  {
    init_simple_test("BFu15ll_BFu33_D");
    static STRUCT_IF_C BFu15ll_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_D");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_D");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_D");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_D, BFu15ll_BFu33_D)
//============================================================================


struct  BFu15ll_BFu33_F  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 BFu15ll_BFu33_F) C1{ FL:15 FL:33 Fi}



static void Test_BFu15ll_BFu33_F()
{
  {
    init_simple_test("BFu15ll_BFu33_F");
    static STRUCT_IF_C BFu15ll_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_F");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_F");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_F");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_F, BFu15ll_BFu33_F)
//============================================================================


struct  BFu15ll_BFu33_I  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 BFu15ll_BFu33_I) C1{ FL:15 FL:33 Fi}



static void Test_BFu15ll_BFu33_I()
{
  {
    init_simple_test("BFu15ll_BFu33_I");
    static STRUCT_IF_C BFu15ll_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_I");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_I");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_I");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_I, BFu15ll_BFu33_I)
//============================================================================


struct  BFu15ll_BFu33_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 BFu15ll_BFu33_Ip) C1{ FL:15 FL:33 Fp}



static void Test_BFu15ll_BFu33_Ip()
{
  {
    init_simple_test("BFu15ll_BFu33_Ip");
    static STRUCT_IF_C BFu15ll_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_Ip");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_Ip, BFu15ll_BFu33_Ip)
//============================================================================


struct  BFu15ll_BFu33_L  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu33_L) C1{ FL:15 FL:33 FL}



static void Test_BFu15ll_BFu33_L()
{
  {
    init_simple_test("BFu15ll_BFu33_L");
    static STRUCT_IF_C BFu15ll_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_L");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_L");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_L");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_L, BFu15ll_BFu33_L)
//============================================================================


struct  BFu15ll_BFu33_S  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 BFu15ll_BFu33_S) C1{ FL:15 FL:33 Fs}



static void Test_BFu15ll_BFu33_S()
{
  {
    init_simple_test("BFu15ll_BFu33_S");
    static STRUCT_IF_C BFu15ll_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_S");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_S");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_S");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_S, BFu15ll_BFu33_S)
//============================================================================


struct  BFu15ll_BFu33_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu33_Uc) C1{ FL:15 FL:33 Fc}



static void Test_BFu15ll_BFu33_Uc()
{
  {
    init_simple_test("BFu15ll_BFu33_Uc");
    static STRUCT_IF_C BFu15ll_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_Uc");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_Uc, BFu15ll_BFu33_Uc)
//============================================================================


struct  BFu15ll_BFu33_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu33_Ui) C1{ FL:15 FL:33 Fi}



static void Test_BFu15ll_BFu33_Ui()
{
  {
    init_simple_test("BFu15ll_BFu33_Ui");
    static STRUCT_IF_C BFu15ll_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_Ui");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_Ui, BFu15ll_BFu33_Ui)
//============================================================================


struct  BFu15ll_BFu33_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu33_Ul) C1{ FL:15 FL:33 FL}



static void Test_BFu15ll_BFu33_Ul()
{
  {
    init_simple_test("BFu15ll_BFu33_Ul");
    static STRUCT_IF_C BFu15ll_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu15ll_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_Ul");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_Ul, BFu15ll_BFu33_Ul)
//============================================================================


struct  BFu15ll_BFu33_Us  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu33_Us) C1{ FL:15 FL:33 Fs}



static void Test_BFu15ll_BFu33_Us()
{
  {
    init_simple_test("BFu15ll_BFu33_Us");
    static STRUCT_IF_C BFu15ll_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_Us");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_Us, BFu15ll_BFu33_Us)
//============================================================================


struct  BFu15ll_BFu33_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 BFu15ll_BFu33_Vp) C1{ FL:15 FL:33 Fp}



static void Test_BFu15ll_BFu33_Vp()
{
  {
    init_simple_test("BFu15ll_BFu33_Vp");
    static STRUCT_IF_C BFu15ll_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_Vp");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_Vp, BFu15ll_BFu33_Vp)
//============================================================================


struct  BFu15ll_BFu7c  {
  __tsu64 v1:15;
  unsigned char v2:7;
};
//SIG(1 BFu15ll_BFu7c) C1{ FL:15 Fc:7}



static void Test_BFu15ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c, BFu15ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu7c_BFu15i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu7c_BFu15i) C1{ FL:15 Fc:7 Fi:15}



static void Test_BFu15ll_BFu7c_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu15i, BFu15ll_BFu7c_BFu15i)
//============================================================================


struct  BFu15ll_BFu7c_BFu15ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu7c_BFu15ll) C1{ FL:15 Fc:7 FL:15}



static void Test_BFu15ll_BFu7c_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu15ll, BFu15ll_BFu7c_BFu15ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu15s  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu7c_BFu15s) C1{ FL:15 Fc:7 Fs:15}



static void Test_BFu15ll_BFu7c_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu15s, BFu15ll_BFu7c_BFu15s)
//============================================================================


struct  BFu15ll_BFu7c_BFu16i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu7c_BFu16i) C1{ FL:15 Fc:7 Fi:16}



static void Test_BFu15ll_BFu7c_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu16i, BFu15ll_BFu7c_BFu16i)
//============================================================================


struct  BFu15ll_BFu7c_BFu16ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu7c_BFu16ll) C1{ FL:15 Fc:7 FL:16}



static void Test_BFu15ll_BFu7c_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu16ll, BFu15ll_BFu7c_BFu16ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu16s  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu7c_BFu16s) C1{ FL:15 Fc:7 Fs:16}



static void Test_BFu15ll_BFu7c_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu16s, BFu15ll_BFu7c_BFu16s)
//============================================================================


struct  BFu15ll_BFu7c_BFu17i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu7c_BFu17i) C1{ FL:15 Fc:7 Fi:17}



static void Test_BFu15ll_BFu7c_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu17i, BFu15ll_BFu7c_BFu17i)
//============================================================================


struct  BFu15ll_BFu7c_BFu17ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu7c_BFu17ll) C1{ FL:15 Fc:7 FL:17}



static void Test_BFu15ll_BFu7c_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu17ll, BFu15ll_BFu7c_BFu17ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu1c  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu7c_BFu1c) C1{ FL:15 Fc:7 Fc:1}



static void Test_BFu15ll_BFu7c_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu1c, BFu15ll_BFu7c_BFu1c)
//============================================================================


struct  BFu15ll_BFu7c_BFu1i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu7c_BFu1i) C1{ FL:15 Fc:7 Fi:1}



static void Test_BFu15ll_BFu7c_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu1i, BFu15ll_BFu7c_BFu1i)
//============================================================================


struct  BFu15ll_BFu7c_BFu1ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu7c_BFu1ll) C1{ FL:15 Fc:7 FL:1}



static void Test_BFu15ll_BFu7c_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu1ll, BFu15ll_BFu7c_BFu1ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu1s  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu7c_BFu1s) C1{ FL:15 Fc:7 Fs:1}



static void Test_BFu15ll_BFu7c_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu1s, BFu15ll_BFu7c_BFu1s)
//============================================================================


struct  BFu15ll_BFu7c_BFu31i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu7c_BFu31i) C1{ FL:15 Fc:7 Fi:31}



static void Test_BFu15ll_BFu7c_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu31i, BFu15ll_BFu7c_BFu31i)
//============================================================================


struct  BFu15ll_BFu7c_BFu31ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu7c_BFu31ll) C1{ FL:15 Fc:7 FL:31}



static void Test_BFu15ll_BFu7c_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu31ll, BFu15ll_BFu7c_BFu31ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu32i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu7c_BFu32i) C1{ FL:15 Fc:7 Fi:32}



static void Test_BFu15ll_BFu7c_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu32i, BFu15ll_BFu7c_BFu32i)
//============================================================================


struct  BFu15ll_BFu7c_BFu32ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu7c_BFu32ll) C1{ FL:15 Fc:7 FL:32}



static void Test_BFu15ll_BFu7c_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu32ll, BFu15ll_BFu7c_BFu32ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu33  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu7c_BFu33) C1{ FL:15 Fc:7 FL:33}



static void Test_BFu15ll_BFu7c_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu33");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu15ll_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu33, BFu15ll_BFu7c_BFu33)
//============================================================================


struct  BFu15ll_BFu7c_BFu7c  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu7c_BFu7c) C1{ FL:15 Fc:7 Fc:7}



static void Test_BFu15ll_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu7c, BFu15ll_BFu7c_BFu7c)
//============================================================================


struct  BFu15ll_BFu7c_BFu7i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu7c_BFu7i) C1{ FL:15 Fc:7 Fi:7}



static void Test_BFu15ll_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu7i, BFu15ll_BFu7c_BFu7i)
//============================================================================


struct  BFu15ll_BFu7c_BFu7ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu7c_BFu7ll) C1{ FL:15 Fc:7 FL:7}



static void Test_BFu15ll_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu7ll, BFu15ll_BFu7c_BFu7ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu7s  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu7c_BFu7s) C1{ FL:15 Fc:7 Fs:7}



static void Test_BFu15ll_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu7s, BFu15ll_BFu7c_BFu7s)
//============================================================================


struct  BFu15ll_BFu7c_BFu8c  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu7c_BFu8c) C1{ FL:15 Fc:7 Fc:8}



static void Test_BFu15ll_BFu7c_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu8c, BFu15ll_BFu7c_BFu8c)
//============================================================================


struct  BFu15ll_BFu7c_BFu8i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu7c_BFu8i) C1{ FL:15 Fc:7 Fi:8}



static void Test_BFu15ll_BFu7c_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu8i, BFu15ll_BFu7c_BFu8i)
//============================================================================


struct  BFu15ll_BFu7c_BFu8ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu7c_BFu8ll) C1{ FL:15 Fc:7 FL:8}



static void Test_BFu15ll_BFu7c_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu8ll, BFu15ll_BFu7c_BFu8ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu8s  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu7c_BFu8s) C1{ FL:15 Fc:7 Fs:8}



static void Test_BFu15ll_BFu7c_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu8s, BFu15ll_BFu7c_BFu8s)
//============================================================================


struct  BFu15ll_BFu7c_BFu9i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu7c_BFu9i) C1{ FL:15 Fc:7 Fi:9}



static void Test_BFu15ll_BFu7c_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu9i, BFu15ll_BFu7c_BFu9i)
//============================================================================


struct  BFu15ll_BFu7c_BFu9ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu7c_BFu9ll) C1{ FL:15 Fc:7 FL:9}



static void Test_BFu15ll_BFu7c_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu9ll, BFu15ll_BFu7c_BFu9ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu9s  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu7c_BFu9s) C1{ FL:15 Fc:7 Fs:9}



static void Test_BFu15ll_BFu7c_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu9s, BFu15ll_BFu7c_BFu9s)
//============================================================================


struct  BFu15ll_BFu7c_C  {
  __tsu64 v1:15;
  unsigned char v2:7;
  char v3;
};
//SIG(1 BFu15ll_BFu7c_C) C1{ FL:15 Fc:7 Fc}



static void Test_BFu15ll_BFu7c_C()
{
  {
    init_simple_test("BFu15ll_BFu7c_C");
    static STRUCT_IF_C BFu15ll_BFu7c_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_C");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_C");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_C, BFu15ll_BFu7c_C)
//============================================================================


struct  BFu15ll_BFu7c_D  {
  __tsu64 v1:15;
  unsigned char v2:7;
  double v3;
};
//SIG(1 BFu15ll_BFu7c_D) C1{ FL:15 Fc:7 FL}



static void Test_BFu15ll_BFu7c_D()
{
  {
    init_simple_test("BFu15ll_BFu7c_D");
    static STRUCT_IF_C BFu15ll_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_D");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_D, BFu15ll_BFu7c_D)
//============================================================================


struct  BFu15ll_BFu7c_F  {
  __tsu64 v1:15;
  unsigned char v2:7;
  float v3;
};
//SIG(1 BFu15ll_BFu7c_F) C1{ FL:15 Fc:7 Fi}



static void Test_BFu15ll_BFu7c_F()
{
  {
    init_simple_test("BFu15ll_BFu7c_F");
    static STRUCT_IF_C BFu15ll_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_F");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_F, BFu15ll_BFu7c_F)
//============================================================================


struct  BFu15ll_BFu7c_I  {
  __tsu64 v1:15;
  unsigned char v2:7;
  int v3;
};
//SIG(1 BFu15ll_BFu7c_I) C1{ FL:15 Fc:7 Fi}



static void Test_BFu15ll_BFu7c_I()
{
  {
    init_simple_test("BFu15ll_BFu7c_I");
    static STRUCT_IF_C BFu15ll_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_I");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_I, BFu15ll_BFu7c_I)
//============================================================================


struct  BFu15ll_BFu7c_Ip  {
  __tsu64 v1:15;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 BFu15ll_BFu7c_Ip) C1{ FL:15 Fc:7 Fp}



static void Test_BFu15ll_BFu7c_Ip()
{
  {
    init_simple_test("BFu15ll_BFu7c_Ip");
    static STRUCT_IF_C BFu15ll_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_Ip, BFu15ll_BFu7c_Ip)
//============================================================================


struct  BFu15ll_BFu7c_L  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu7c_L) C1{ FL:15 Fc:7 FL}



static void Test_BFu15ll_BFu7c_L()
{
  {
    init_simple_test("BFu15ll_BFu7c_L");
    static STRUCT_IF_C BFu15ll_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_L");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_L, BFu15ll_BFu7c_L)
//============================================================================


struct  BFu15ll_BFu7c_S  {
  __tsu64 v1:15;
  unsigned char v2:7;
  short v3;
};
//SIG(1 BFu15ll_BFu7c_S) C1{ FL:15 Fc:7 Fs}



static void Test_BFu15ll_BFu7c_S()
{
  {
    init_simple_test("BFu15ll_BFu7c_S");
    static STRUCT_IF_C BFu15ll_BFu7c_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_S");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_S, BFu15ll_BFu7c_S)
//============================================================================


struct  BFu15ll_BFu7c_Uc  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu7c_Uc) C1{ FL:15 Fc:7 Fc}



static void Test_BFu15ll_BFu7c_Uc()
{
  {
    init_simple_test("BFu15ll_BFu7c_Uc");
    static STRUCT_IF_C BFu15ll_BFu7c_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_Uc");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_Uc, BFu15ll_BFu7c_Uc)
//============================================================================


struct  BFu15ll_BFu7c_Ui  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu7c_Ui) C1{ FL:15 Fc:7 Fi}



static void Test_BFu15ll_BFu7c_Ui()
{
  {
    init_simple_test("BFu15ll_BFu7c_Ui");
    static STRUCT_IF_C BFu15ll_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_Ui, BFu15ll_BFu7c_Ui)
//============================================================================


struct  BFu15ll_BFu7c_Ul  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu7c_Ul) C1{ FL:15 Fc:7 FL}



static void Test_BFu15ll_BFu7c_Ul()
{
  {
    init_simple_test("BFu15ll_BFu7c_Ul");
    static STRUCT_IF_C BFu15ll_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_Ul, BFu15ll_BFu7c_Ul)
//============================================================================


struct  BFu15ll_BFu7c_Us  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu7c_Us) C1{ FL:15 Fc:7 Fs}



static void Test_BFu15ll_BFu7c_Us()
{
  {
    init_simple_test("BFu15ll_BFu7c_Us");
    static STRUCT_IF_C BFu15ll_BFu7c_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_Us, BFu15ll_BFu7c_Us)
//============================================================================


struct  BFu15ll_BFu7c_Vp  {
  __tsu64 v1:15;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 BFu15ll_BFu7c_Vp) C1{ FL:15 Fc:7 Fp}



static void Test_BFu15ll_BFu7c_Vp()
{
  {
    init_simple_test("BFu15ll_BFu7c_Vp");
    static STRUCT_IF_C BFu15ll_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_Vp, BFu15ll_BFu7c_Vp)
//============================================================================


struct  BFu15ll_BFu7i  {
  __tsu64 v1:15;
  unsigned int v2:7;
};
//SIG(1 BFu15ll_BFu7i) C1{ FL:15 Fi:7}



static void Test_BFu15ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i, BFu15ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu7i_BFu15i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu7i_BFu15i) C1{ FL:15 Fi:7 Fi:15}



static void Test_BFu15ll_BFu7i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu15i, BFu15ll_BFu7i_BFu15i)
//============================================================================


struct  BFu15ll_BFu7i_BFu15ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu7i_BFu15ll) C1{ FL:15 Fi:7 FL:15}



static void Test_BFu15ll_BFu7i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu15ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu15ll, BFu15ll_BFu7i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu15s  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu7i_BFu15s) C1{ FL:15 Fi:7 Fs:15}



static void Test_BFu15ll_BFu7i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu15s, BFu15ll_BFu7i_BFu15s)
//============================================================================


struct  BFu15ll_BFu7i_BFu16i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu7i_BFu16i) C1{ FL:15 Fi:7 Fi:16}



static void Test_BFu15ll_BFu7i_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu16i, BFu15ll_BFu7i_BFu16i)
//============================================================================


struct  BFu15ll_BFu7i_BFu16ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu7i_BFu16ll) C1{ FL:15 Fi:7 FL:16}



static void Test_BFu15ll_BFu7i_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu15ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu15ll_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu16ll, BFu15ll_BFu7i_BFu16ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu16s  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu7i_BFu16s) C1{ FL:15 Fi:7 Fs:16}



static void Test_BFu15ll_BFu7i_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu16s, BFu15ll_BFu7i_BFu16s)
//============================================================================


struct  BFu15ll_BFu7i_BFu17i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu7i_BFu17i) C1{ FL:15 Fi:7 Fi:17}



static void Test_BFu15ll_BFu7i_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu17i, BFu15ll_BFu7i_BFu17i)
//============================================================================


struct  BFu15ll_BFu7i_BFu17ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu7i_BFu17ll) C1{ FL:15 Fi:7 FL:17}



static void Test_BFu15ll_BFu7i_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, 1, "BFu15ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, hide_ull(1LL<<16), "BFu15ll_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu17ll, BFu15ll_BFu7i_BFu17ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu1c  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu7i_BFu1c) C1{ FL:15 Fi:7 Fc:1}



static void Test_BFu15ll_BFu7i_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu15ll_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu1c, BFu15ll_BFu7i_BFu1c)
//============================================================================


struct  BFu15ll_BFu7i_BFu1i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu7i_BFu1i) C1{ FL:15 Fi:7 Fi:1}



static void Test_BFu15ll_BFu7i_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu15ll_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu1i, BFu15ll_BFu7i_BFu1i)
//============================================================================


struct  BFu15ll_BFu7i_BFu1ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu7i_BFu1ll) C1{ FL:15 Fi:7 FL:1}



static void Test_BFu15ll_BFu7i_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu15ll_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu1ll, BFu15ll_BFu7i_BFu1ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu1s  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu7i_BFu1s) C1{ FL:15 Fi:7 Fs:1}



static void Test_BFu15ll_BFu7i_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu15ll_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu1s, BFu15ll_BFu7i_BFu1s)
//============================================================================


struct  BFu15ll_BFu7i_BFu31i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu7i_BFu31i) C1{ FL:15 Fi:7 Fi:31}



static void Test_BFu15ll_BFu7i_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu31i, BFu15ll_BFu7i_BFu31i)
//============================================================================


struct  BFu15ll_BFu7i_BFu31ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu7i_BFu31ll) C1{ FL:15 Fi:7 FL:31}



static void Test_BFu15ll_BFu7i_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, 1, "BFu15ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, hide_ull(1LL<<30), "BFu15ll_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu31ll, BFu15ll_BFu7i_BFu31ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu32i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu7i_BFu32i) C1{ FL:15 Fi:7 Fi:32}



static void Test_BFu15ll_BFu7i_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu32i, BFu15ll_BFu7i_BFu32i)
//============================================================================


struct  BFu15ll_BFu7i_BFu32ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu7i_BFu32ll) C1{ FL:15 Fi:7 FL:32}



static void Test_BFu15ll_BFu7i_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, 1, "BFu15ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, hide_ull(1LL<<31), "BFu15ll_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu32ll, BFu15ll_BFu7i_BFu32ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu33  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu7i_BFu33) C1{ FL:15 Fi:7 FL:33}



static void Test_BFu15ll_BFu7i_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu33");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, 1, "BFu15ll_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, hide_ull(1LL<<32), "BFu15ll_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu33, BFu15ll_BFu7i_BFu33)
//============================================================================


struct  BFu15ll_BFu7i_BFu7c  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu7i_BFu7c) C1{ FL:15 Fi:7 Fc:7}



static void Test_BFu15ll_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu7c, BFu15ll_BFu7i_BFu7c)
//============================================================================


struct  BFu15ll_BFu7i_BFu7i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu7i_BFu7i) C1{ FL:15 Fi:7 Fi:7}



static void Test_BFu15ll_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu15ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu7i, BFu15ll_BFu7i_BFu7i)
//============================================================================


struct  BFu15ll_BFu7i_BFu7ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu7i_BFu7ll) C1{ FL:15 Fi:7 FL:7}



static void Test_BFu15ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu15ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu7ll, BFu15ll_BFu7i_BFu7ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu7s  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu7i_BFu7s) C1{ FL:15 Fi:7 Fs:7}



static void Test_BFu15ll_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu15ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu7s, BFu15ll_BFu7i_BFu7s)
//============================================================================


struct  BFu15ll_BFu7i_BFu8c  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu7i_BFu8c) C1{ FL:15 Fi:7 Fc:8}



static void Test_BFu15ll_BFu7i_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu8c, BFu15ll_BFu7i_BFu8c)
//============================================================================


struct  BFu15ll_BFu7i_BFu8i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu7i_BFu8i) C1{ FL:15 Fi:7 Fi:8}



static void Test_BFu15ll_BFu7i_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu15ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu8i, BFu15ll_BFu7i_BFu8i)
//============================================================================


struct  BFu15ll_BFu7i_BFu8ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu7i_BFu8ll) C1{ FL:15 Fi:7 FL:8}



static void Test_BFu15ll_BFu7i_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu15ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu8ll, BFu15ll_BFu7i_BFu8ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu8s  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu7i_BFu8s) C1{ FL:15 Fi:7 Fs:8}



static void Test_BFu15ll_BFu7i_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu15ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu8s, BFu15ll_BFu7i_BFu8s)
//============================================================================


struct  BFu15ll_BFu7i_BFu9i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu7i_BFu9i) C1{ FL:15 Fi:7 Fi:9}



static void Test_BFu15ll_BFu7i_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu15ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu9i, BFu15ll_BFu7i_BFu9i)
//============================================================================


struct  BFu15ll_BFu7i_BFu9ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu7i_BFu9ll) C1{ FL:15 Fi:7 FL:9}



static void Test_BFu15ll_BFu7i_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu15ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu9ll, BFu15ll_BFu7i_BFu9ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu9s  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu7i_BFu9s) C1{ FL:15 Fi:7 Fs:9}



static void Test_BFu15ll_BFu7i_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu15ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu9s, BFu15ll_BFu7i_BFu9s)
//============================================================================


struct  BFu15ll_BFu7i_C  {
  __tsu64 v1:15;
  unsigned int v2:7;
  char v3;
};
//SIG(1 BFu15ll_BFu7i_C) C1{ FL:15 Fi:7 Fc}



static void Test_BFu15ll_BFu7i_C()
{
  {
    init_simple_test("BFu15ll_BFu7i_C");
    static STRUCT_IF_C BFu15ll_BFu7i_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_C");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_C, BFu15ll_BFu7i_C)
//============================================================================


struct  BFu15ll_BFu7i_D  {
  __tsu64 v1:15;
  unsigned int v2:7;
  double v3;
};
//SIG(1 BFu15ll_BFu7i_D) C1{ FL:15 Fi:7 FL}



static void Test_BFu15ll_BFu7i_D()
{
  {
    init_simple_test("BFu15ll_BFu7i_D");
    static STRUCT_IF_C BFu15ll_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_D, BFu15ll_BFu7i_D)
//============================================================================


struct  BFu15ll_BFu7i_F  {
  __tsu64 v1:15;
  unsigned int v2:7;
  float v3;
};
//SIG(1 BFu15ll_BFu7i_F) C1{ FL:15 Fi:7 Fi}



static void Test_BFu15ll_BFu7i_F()
{
  {
    init_simple_test("BFu15ll_BFu7i_F");
    static STRUCT_IF_C BFu15ll_BFu7i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_F, BFu15ll_BFu7i_F)
//============================================================================


struct  BFu15ll_BFu7i_I  {
  __tsu64 v1:15;
  unsigned int v2:7;
  int v3;
};
//SIG(1 BFu15ll_BFu7i_I) C1{ FL:15 Fi:7 Fi}



static void Test_BFu15ll_BFu7i_I()
{
  {
    init_simple_test("BFu15ll_BFu7i_I");
    static STRUCT_IF_C BFu15ll_BFu7i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_I, BFu15ll_BFu7i_I)
//============================================================================


struct  BFu15ll_BFu7i_Ip  {
  __tsu64 v1:15;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 BFu15ll_BFu7i_Ip) C1{ FL:15 Fi:7 Fp}



static void Test_BFu15ll_BFu7i_Ip()
{
  {
    init_simple_test("BFu15ll_BFu7i_Ip");
    static STRUCT_IF_C BFu15ll_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_Ip, BFu15ll_BFu7i_Ip)
//============================================================================


struct  BFu15ll_BFu7i_L  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu7i_L) C1{ FL:15 Fi:7 FL}



static void Test_BFu15ll_BFu7i_L()
{
  {
    init_simple_test("BFu15ll_BFu7i_L");
    static STRUCT_IF_C BFu15ll_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_L, BFu15ll_BFu7i_L)
//============================================================================


struct  BFu15ll_BFu7i_S  {
  __tsu64 v1:15;
  unsigned int v2:7;
  short v3;
};
//SIG(1 BFu15ll_BFu7i_S) C1{ FL:15 Fi:7 Fs}



static void Test_BFu15ll_BFu7i_S()
{
  {
    init_simple_test("BFu15ll_BFu7i_S");
    static STRUCT_IF_C BFu15ll_BFu7i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_S, BFu15ll_BFu7i_S)
//============================================================================


struct  BFu15ll_BFu7i_Uc  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu7i_Uc) C1{ FL:15 Fi:7 Fc}



static void Test_BFu15ll_BFu7i_Uc()
{
  {
    init_simple_test("BFu15ll_BFu7i_Uc");
    static STRUCT_IF_C BFu15ll_BFu7i_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_Uc");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_Uc, BFu15ll_BFu7i_Uc)
//============================================================================


struct  BFu15ll_BFu7i_Ui  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu7i_Ui) C1{ FL:15 Fi:7 Fi}



static void Test_BFu15ll_BFu7i_Ui()
{
  {
    init_simple_test("BFu15ll_BFu7i_Ui");
    static STRUCT_IF_C BFu15ll_BFu7i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_Ui, BFu15ll_BFu7i_Ui)
//============================================================================


struct  BFu15ll_BFu7i_Ul  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu7i_Ul) C1{ FL:15 Fi:7 FL}



static void Test_BFu15ll_BFu7i_Ul()
{
  {
    init_simple_test("BFu15ll_BFu7i_Ul");
    static STRUCT_IF_C BFu15ll_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_Ul, BFu15ll_BFu7i_Ul)
//============================================================================


struct  BFu15ll_BFu7i_Us  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu7i_Us) C1{ FL:15 Fi:7 Fs}



static void Test_BFu15ll_BFu7i_Us()
{
  {
    init_simple_test("BFu15ll_BFu7i_Us");
    static STRUCT_IF_C BFu15ll_BFu7i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_Us, BFu15ll_BFu7i_Us)
//============================================================================


struct  BFu15ll_BFu7i_Vp  {
  __tsu64 v1:15;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 BFu15ll_BFu7i_Vp) C1{ FL:15 Fi:7 Fp}



static void Test_BFu15ll_BFu7i_Vp()
{
  {
    init_simple_test("BFu15ll_BFu7i_Vp");
    static STRUCT_IF_C BFu15ll_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_Vp, BFu15ll_BFu7i_Vp)
//============================================================================


struct  BFu15ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
};
//SIG(1 BFu15ll_BFu7ll) C1{ FL:15 FL:7}



static void Test_BFu15ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll, BFu15ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu7ll_BFu15i) C1{ FL:15 FL:7 Fi:15}



static void Test_BFu15ll_BFu7ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu15i, BFu15ll_BFu7ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu7ll_BFu15ll) C1{ FL:15 FL:7 FL:15}



static void Test_BFu15ll_BFu7ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu15ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu15ll, BFu15ll_BFu7ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu7ll_BFu15s) C1{ FL:15 FL:7 Fs:15}



static void Test_BFu15ll_BFu7ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu15s, BFu15ll_BFu7ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu7ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu7ll_BFu16i) C1{ FL:15 FL:7 Fi:16}



static void Test_BFu15ll_BFu7ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu16i, BFu15ll_BFu7ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu7ll_BFu16ll) C1{ FL:15 FL:7 FL:16}



static void Test_BFu15ll_BFu7ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu15ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu15ll_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu16ll, BFu15ll_BFu7ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu7ll_BFu16s) C1{ FL:15 FL:7 Fs:16}



static void Test_BFu15ll_BFu7ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu16s, BFu15ll_BFu7ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu7ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu7ll_BFu17i) C1{ FL:15 FL:7 Fi:17}



static void Test_BFu15ll_BFu7ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu17i, BFu15ll_BFu7ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu7ll_BFu17ll) C1{ FL:15 FL:7 FL:17}



static void Test_BFu15ll_BFu7ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, 1, "BFu15ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, hide_ull(1LL<<16), "BFu15ll_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu17ll, BFu15ll_BFu7ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu7ll_BFu1c) C1{ FL:15 FL:7 Fc:1}



static void Test_BFu15ll_BFu7ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu15ll_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu1c, BFu15ll_BFu7ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu7ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu7ll_BFu1i) C1{ FL:15 FL:7 Fi:1}



static void Test_BFu15ll_BFu7ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu15ll_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu1i, BFu15ll_BFu7ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu7ll_BFu1ll) C1{ FL:15 FL:7 FL:1}



static void Test_BFu15ll_BFu7ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu15ll_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu1ll, BFu15ll_BFu7ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu7ll_BFu1s) C1{ FL:15 FL:7 Fs:1}



static void Test_BFu15ll_BFu7ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu15ll_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu1s, BFu15ll_BFu7ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu7ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu7ll_BFu31i) C1{ FL:15 FL:7 Fi:31}



static void Test_BFu15ll_BFu7ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu31i, BFu15ll_BFu7ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu7ll_BFu31ll) C1{ FL:15 FL:7 FL:31}



static void Test_BFu15ll_BFu7ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, 1, "BFu15ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, hide_ull(1LL<<30), "BFu15ll_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu31ll, BFu15ll_BFu7ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu7ll_BFu32i) C1{ FL:15 FL:7 Fi:32}



static void Test_BFu15ll_BFu7ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu32i, BFu15ll_BFu7ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu7ll_BFu32ll) C1{ FL:15 FL:7 FL:32}



static void Test_BFu15ll_BFu7ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, 1, "BFu15ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, hide_ull(1LL<<31), "BFu15ll_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu32ll, BFu15ll_BFu7ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu7ll_BFu33) C1{ FL:15 FL:7 FL:33}



static void Test_BFu15ll_BFu7ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, 1, "BFu15ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, hide_ull(1LL<<32), "BFu15ll_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu33, BFu15ll_BFu7ll_BFu33)
//============================================================================


struct  BFu15ll_BFu7ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu7ll_BFu7c) C1{ FL:15 FL:7 Fc:7}



static void Test_BFu15ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu7c, BFu15ll_BFu7ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu7ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu7ll_BFu7i) C1{ FL:15 FL:7 Fi:7}



static void Test_BFu15ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu15ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu7i, BFu15ll_BFu7ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu7ll_BFu7ll) C1{ FL:15 FL:7 FL:7}



static void Test_BFu15ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu15ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu7ll, BFu15ll_BFu7ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu7ll_BFu7s) C1{ FL:15 FL:7 Fs:7}



static void Test_BFu15ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu15ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu7s, BFu15ll_BFu7ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu7ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu7ll_BFu8c) C1{ FL:15 FL:7 Fc:8}



static void Test_BFu15ll_BFu7ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu8c, BFu15ll_BFu7ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu7ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu7ll_BFu8i) C1{ FL:15 FL:7 Fi:8}



static void Test_BFu15ll_BFu7ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu15ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu8i, BFu15ll_BFu7ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu7ll_BFu8ll) C1{ FL:15 FL:7 FL:8}



static void Test_BFu15ll_BFu7ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu15ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu8ll, BFu15ll_BFu7ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu7ll_BFu8s) C1{ FL:15 FL:7 Fs:8}



static void Test_BFu15ll_BFu7ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu15ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu15ll_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu8s, BFu15ll_BFu7ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu7ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu7ll_BFu9i) C1{ FL:15 FL:7 Fi:9}



static void Test_BFu15ll_BFu7ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu15ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu9i, BFu15ll_BFu7ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu7ll_BFu9ll) C1{ FL:15 FL:7 FL:9}



static void Test_BFu15ll_BFu7ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu15ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu9ll, BFu15ll_BFu7ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu7ll_BFu9s) C1{ FL:15 FL:7 Fs:9}



static void Test_BFu15ll_BFu7ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu15ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu15ll_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu9s, BFu15ll_BFu7ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu7ll_C  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 BFu15ll_BFu7ll_C) C1{ FL:15 FL:7 Fc}



static void Test_BFu15ll_BFu7ll_C()
{
  {
    init_simple_test("BFu15ll_BFu7ll_C");
    static STRUCT_IF_C BFu15ll_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_C");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_C, BFu15ll_BFu7ll_C)
//============================================================================


struct  BFu15ll_BFu7ll_D  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 BFu15ll_BFu7ll_D) C1{ FL:15 FL:7 FL}



static void Test_BFu15ll_BFu7ll_D()
{
  {
    init_simple_test("BFu15ll_BFu7ll_D");
    static STRUCT_IF_C BFu15ll_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_D, BFu15ll_BFu7ll_D)
//============================================================================


struct  BFu15ll_BFu7ll_F  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 BFu15ll_BFu7ll_F) C1{ FL:15 FL:7 Fi}



static void Test_BFu15ll_BFu7ll_F()
{
  {
    init_simple_test("BFu15ll_BFu7ll_F");
    static STRUCT_IF_C BFu15ll_BFu7ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_F, BFu15ll_BFu7ll_F)
//============================================================================


struct  BFu15ll_BFu7ll_I  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 BFu15ll_BFu7ll_I) C1{ FL:15 FL:7 Fi}



static void Test_BFu15ll_BFu7ll_I()
{
  {
    init_simple_test("BFu15ll_BFu7ll_I");
    static STRUCT_IF_C BFu15ll_BFu7ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_I, BFu15ll_BFu7ll_I)
//============================================================================


struct  BFu15ll_BFu7ll_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 BFu15ll_BFu7ll_Ip) C1{ FL:15 FL:7 Fp}



static void Test_BFu15ll_BFu7ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu7ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_Ip, BFu15ll_BFu7ll_Ip)
//============================================================================


struct  BFu15ll_BFu7ll_L  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu7ll_L) C1{ FL:15 FL:7 FL}



static void Test_BFu15ll_BFu7ll_L()
{
  {
    init_simple_test("BFu15ll_BFu7ll_L");
    static STRUCT_IF_C BFu15ll_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_L, BFu15ll_BFu7ll_L)
//============================================================================


struct  BFu15ll_BFu7ll_S  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 BFu15ll_BFu7ll_S) C1{ FL:15 FL:7 Fs}



static void Test_BFu15ll_BFu7ll_S()
{
  {
    init_simple_test("BFu15ll_BFu7ll_S");
    static STRUCT_IF_C BFu15ll_BFu7ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_S, BFu15ll_BFu7ll_S)
//============================================================================


struct  BFu15ll_BFu7ll_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu7ll_Uc) C1{ FL:15 FL:7 Fc}



static void Test_BFu15ll_BFu7ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu7ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_Uc");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_Uc, BFu15ll_BFu7ll_Uc)
//============================================================================


struct  BFu15ll_BFu7ll_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu7ll_Ui) C1{ FL:15 FL:7 Fi}



static void Test_BFu15ll_BFu7ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu7ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu7ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_Ui, BFu15ll_BFu7ll_Ui)
//============================================================================


struct  BFu15ll_BFu7ll_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu7ll_Ul) C1{ FL:15 FL:7 FL}



static void Test_BFu15ll_BFu7ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu7ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_Ul, BFu15ll_BFu7ll_Ul)
//============================================================================


struct  BFu15ll_BFu7ll_Us  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu7ll_Us) C1{ FL:15 FL:7 Fs}



static void Test_BFu15ll_BFu7ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu7ll_Us");
    static STRUCT_IF_C BFu15ll_BFu7ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_Us, BFu15ll_BFu7ll_Us)
//============================================================================


struct  BFu15ll_BFu7ll_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 BFu15ll_BFu7ll_Vp) C1{ FL:15 FL:7 Fp}



static void Test_BFu15ll_BFu7ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu7ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_Vp, BFu15ll_BFu7ll_Vp)
//============================================================================


struct  BFu15ll_BFu7s  {
  __tsu64 v1:15;
  unsigned short v2:7;
};
//SIG(1 BFu15ll_BFu7s) C1{ FL:15 Fs:7}



static void Test_BFu15ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s, BFu15ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu7s_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu7s_BFu15i) C1{ FL:15 Fs:7 Fi:15}



static void Test_BFu15ll_BFu7s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu15i, BFu15ll_BFu7s_BFu15i)
//============================================================================


struct  BFu15ll_BFu7s_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu7s_BFu15ll) C1{ FL:15 Fs:7 FL:15}



static void Test_BFu15ll_BFu7s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu15ll, BFu15ll_BFu7s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu7s_BFu15s) C1{ FL:15 Fs:7 Fs:15}



static void Test_BFu15ll_BFu7s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu15s, BFu15ll_BFu7s_BFu15s)
//============================================================================


struct  BFu15ll_BFu7s_BFu16i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu7s_BFu16i) C1{ FL:15 Fs:7 Fi:16}



static void Test_BFu15ll_BFu7s_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu16i, BFu15ll_BFu7s_BFu16i)
//============================================================================


struct  BFu15ll_BFu7s_BFu16ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu7s_BFu16ll) C1{ FL:15 Fs:7 FL:16}



static void Test_BFu15ll_BFu7s_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu16ll, BFu15ll_BFu7s_BFu16ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu16s  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu7s_BFu16s) C1{ FL:15 Fs:7 Fs:16}



static void Test_BFu15ll_BFu7s_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu16s, BFu15ll_BFu7s_BFu16s)
//============================================================================


struct  BFu15ll_BFu7s_BFu17i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu7s_BFu17i) C1{ FL:15 Fs:7 Fi:17}



static void Test_BFu15ll_BFu7s_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu17i, BFu15ll_BFu7s_BFu17i)
//============================================================================


struct  BFu15ll_BFu7s_BFu17ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu7s_BFu17ll) C1{ FL:15 Fs:7 FL:17}



static void Test_BFu15ll_BFu7s_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu17ll, BFu15ll_BFu7s_BFu17ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu1c  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu7s_BFu1c) C1{ FL:15 Fs:7 Fc:1}



static void Test_BFu15ll_BFu7s_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu1c, BFu15ll_BFu7s_BFu1c)
//============================================================================


struct  BFu15ll_BFu7s_BFu1i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu7s_BFu1i) C1{ FL:15 Fs:7 Fi:1}



static void Test_BFu15ll_BFu7s_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu1i, BFu15ll_BFu7s_BFu1i)
//============================================================================


struct  BFu15ll_BFu7s_BFu1ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu7s_BFu1ll) C1{ FL:15 Fs:7 FL:1}



static void Test_BFu15ll_BFu7s_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu1ll, BFu15ll_BFu7s_BFu1ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu1s  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu7s_BFu1s) C1{ FL:15 Fs:7 Fs:1}



static void Test_BFu15ll_BFu7s_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu1s, BFu15ll_BFu7s_BFu1s)
//============================================================================


struct  BFu15ll_BFu7s_BFu31i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu7s_BFu31i) C1{ FL:15 Fs:7 Fi:31}



static void Test_BFu15ll_BFu7s_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu31i, BFu15ll_BFu7s_BFu31i)
//============================================================================


struct  BFu15ll_BFu7s_BFu31ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu7s_BFu31ll) C1{ FL:15 Fs:7 FL:31}



static void Test_BFu15ll_BFu7s_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu31ll, BFu15ll_BFu7s_BFu31ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu32i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu7s_BFu32i) C1{ FL:15 Fs:7 Fi:32}



static void Test_BFu15ll_BFu7s_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu32i, BFu15ll_BFu7s_BFu32i)
//============================================================================


struct  BFu15ll_BFu7s_BFu32ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu7s_BFu32ll) C1{ FL:15 Fs:7 FL:32}



static void Test_BFu15ll_BFu7s_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu32ll, BFu15ll_BFu7s_BFu32ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu33  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu7s_BFu33) C1{ FL:15 Fs:7 FL:33}



static void Test_BFu15ll_BFu7s_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu33");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu15ll_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu33, BFu15ll_BFu7s_BFu33)
//============================================================================


struct  BFu15ll_BFu7s_BFu7c  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu7s_BFu7c) C1{ FL:15 Fs:7 Fc:7}



static void Test_BFu15ll_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu7c, BFu15ll_BFu7s_BFu7c)
//============================================================================


struct  BFu15ll_BFu7s_BFu7i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu7s_BFu7i) C1{ FL:15 Fs:7 Fi:7}



static void Test_BFu15ll_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu7i, BFu15ll_BFu7s_BFu7i)
//============================================================================


struct  BFu15ll_BFu7s_BFu7ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu7s_BFu7ll) C1{ FL:15 Fs:7 FL:7}



static void Test_BFu15ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu7ll, BFu15ll_BFu7s_BFu7ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu7s  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu7s_BFu7s) C1{ FL:15 Fs:7 Fs:7}



static void Test_BFu15ll_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu7s, BFu15ll_BFu7s_BFu7s)
//============================================================================


struct  BFu15ll_BFu7s_BFu8c  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu7s_BFu8c) C1{ FL:15 Fs:7 Fc:8}



static void Test_BFu15ll_BFu7s_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu8c, BFu15ll_BFu7s_BFu8c)
//============================================================================


struct  BFu15ll_BFu7s_BFu8i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu7s_BFu8i) C1{ FL:15 Fs:7 Fi:8}



static void Test_BFu15ll_BFu7s_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu8i, BFu15ll_BFu7s_BFu8i)
//============================================================================


struct  BFu15ll_BFu7s_BFu8ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu7s_BFu8ll) C1{ FL:15 Fs:7 FL:8}



static void Test_BFu15ll_BFu7s_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu8ll, BFu15ll_BFu7s_BFu8ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu8s  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu7s_BFu8s) C1{ FL:15 Fs:7 Fs:8}



static void Test_BFu15ll_BFu7s_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu8s, BFu15ll_BFu7s_BFu8s)
//============================================================================


struct  BFu15ll_BFu7s_BFu9i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu7s_BFu9i) C1{ FL:15 Fs:7 Fi:9}



static void Test_BFu15ll_BFu7s_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu9i, BFu15ll_BFu7s_BFu9i)
//============================================================================


struct  BFu15ll_BFu7s_BFu9ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu7s_BFu9ll) C1{ FL:15 Fs:7 FL:9}



static void Test_BFu15ll_BFu7s_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu9ll, BFu15ll_BFu7s_BFu9ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu9s  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu7s_BFu9s) C1{ FL:15 Fs:7 Fs:9}



static void Test_BFu15ll_BFu7s_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu9s, BFu15ll_BFu7s_BFu9s)
//============================================================================


struct  BFu15ll_BFu7s_C  {
  __tsu64 v1:15;
  unsigned short v2:7;
  char v3;
};
//SIG(1 BFu15ll_BFu7s_C) C1{ FL:15 Fs:7 Fc}



static void Test_BFu15ll_BFu7s_C()
{
  {
    init_simple_test("BFu15ll_BFu7s_C");
    static STRUCT_IF_C BFu15ll_BFu7s_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_C");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_C");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_C, BFu15ll_BFu7s_C)
//============================================================================


struct  BFu15ll_BFu7s_D  {
  __tsu64 v1:15;
  unsigned short v2:7;
  double v3;
};
//SIG(1 BFu15ll_BFu7s_D) C1{ FL:15 Fs:7 FL}



static void Test_BFu15ll_BFu7s_D()
{
  {
    init_simple_test("BFu15ll_BFu7s_D");
    static STRUCT_IF_C BFu15ll_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_D");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_D, BFu15ll_BFu7s_D)
//============================================================================


struct  BFu15ll_BFu7s_F  {
  __tsu64 v1:15;
  unsigned short v2:7;
  float v3;
};
//SIG(1 BFu15ll_BFu7s_F) C1{ FL:15 Fs:7 Fi}



static void Test_BFu15ll_BFu7s_F()
{
  {
    init_simple_test("BFu15ll_BFu7s_F");
    static STRUCT_IF_C BFu15ll_BFu7s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_F");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_F, BFu15ll_BFu7s_F)
//============================================================================


struct  BFu15ll_BFu7s_I  {
  __tsu64 v1:15;
  unsigned short v2:7;
  int v3;
};
//SIG(1 BFu15ll_BFu7s_I) C1{ FL:15 Fs:7 Fi}



static void Test_BFu15ll_BFu7s_I()
{
  {
    init_simple_test("BFu15ll_BFu7s_I");
    static STRUCT_IF_C BFu15ll_BFu7s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_I");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_I, BFu15ll_BFu7s_I)
//============================================================================


struct  BFu15ll_BFu7s_Ip  {
  __tsu64 v1:15;
  unsigned short v2:7;
  int *v3;
};
//SIG(1 BFu15ll_BFu7s_Ip) C1{ FL:15 Fs:7 Fp}



static void Test_BFu15ll_BFu7s_Ip()
{
  {
    init_simple_test("BFu15ll_BFu7s_Ip");
    static STRUCT_IF_C BFu15ll_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_Ip, BFu15ll_BFu7s_Ip)
//============================================================================


struct  BFu15ll_BFu7s_L  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu7s_L) C1{ FL:15 Fs:7 FL}



static void Test_BFu15ll_BFu7s_L()
{
  {
    init_simple_test("BFu15ll_BFu7s_L");
    static STRUCT_IF_C BFu15ll_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_L");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_L, BFu15ll_BFu7s_L)
//============================================================================


struct  BFu15ll_BFu7s_S  {
  __tsu64 v1:15;
  unsigned short v2:7;
  short v3;
};
//SIG(1 BFu15ll_BFu7s_S) C1{ FL:15 Fs:7 Fs}



static void Test_BFu15ll_BFu7s_S()
{
  {
    init_simple_test("BFu15ll_BFu7s_S");
    static STRUCT_IF_C BFu15ll_BFu7s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_S");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_S, BFu15ll_BFu7s_S)
//============================================================================


struct  BFu15ll_BFu7s_Uc  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu7s_Uc) C1{ FL:15 Fs:7 Fc}



static void Test_BFu15ll_BFu7s_Uc()
{
  {
    init_simple_test("BFu15ll_BFu7s_Uc");
    static STRUCT_IF_C BFu15ll_BFu7s_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_Uc");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_Uc, BFu15ll_BFu7s_Uc)
//============================================================================


struct  BFu15ll_BFu7s_Ui  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu7s_Ui) C1{ FL:15 Fs:7 Fi}



static void Test_BFu15ll_BFu7s_Ui()
{
  {
    init_simple_test("BFu15ll_BFu7s_Ui");
    static STRUCT_IF_C BFu15ll_BFu7s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_Ui, BFu15ll_BFu7s_Ui)
//============================================================================


struct  BFu15ll_BFu7s_Ul  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu7s_Ul) C1{ FL:15 Fs:7 FL}



static void Test_BFu15ll_BFu7s_Ul()
{
  {
    init_simple_test("BFu15ll_BFu7s_Ul");
    static STRUCT_IF_C BFu15ll_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_Ul, BFu15ll_BFu7s_Ul)
//============================================================================


struct  BFu15ll_BFu7s_Us  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu7s_Us) C1{ FL:15 Fs:7 Fs}



static void Test_BFu15ll_BFu7s_Us()
{
  {
    init_simple_test("BFu15ll_BFu7s_Us");
    static STRUCT_IF_C BFu15ll_BFu7s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu7s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_Us, BFu15ll_BFu7s_Us)
//============================================================================


struct  BFu15ll_BFu7s_Vp  {
  __tsu64 v1:15;
  unsigned short v2:7;
  void *v3;
};
//SIG(1 BFu15ll_BFu7s_Vp) C1{ FL:15 Fs:7 Fp}



static void Test_BFu15ll_BFu7s_Vp()
{
  {
    init_simple_test("BFu15ll_BFu7s_Vp");
    static STRUCT_IF_C BFu15ll_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_Vp, BFu15ll_BFu7s_Vp)
//============================================================================


struct  BFu15ll_BFu8c  {
  __tsu64 v1:15;
  unsigned char v2:8;
};
//SIG(1 BFu15ll_BFu8c) C1{ FL:15 Fc:8}



static void Test_BFu15ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c, BFu15ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu8c_BFu15i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu8c_BFu15i) C1{ FL:15 Fc:8 Fi:15}



static void Test_BFu15ll_BFu8c_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu15i, BFu15ll_BFu8c_BFu15i)
//============================================================================


struct  BFu15ll_BFu8c_BFu15ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu8c_BFu15ll) C1{ FL:15 Fc:8 FL:15}



static void Test_BFu15ll_BFu8c_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu15ll, BFu15ll_BFu8c_BFu15ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu15s  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu8c_BFu15s) C1{ FL:15 Fc:8 Fs:15}



static void Test_BFu15ll_BFu8c_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu15s, BFu15ll_BFu8c_BFu15s)
//============================================================================


struct  BFu15ll_BFu8c_BFu16i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu8c_BFu16i) C1{ FL:15 Fc:8 Fi:16}



static void Test_BFu15ll_BFu8c_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu16i, BFu15ll_BFu8c_BFu16i)
//============================================================================


struct  BFu15ll_BFu8c_BFu16ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu8c_BFu16ll) C1{ FL:15 Fc:8 FL:16}



static void Test_BFu15ll_BFu8c_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu16ll, BFu15ll_BFu8c_BFu16ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu16s  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu8c_BFu16s) C1{ FL:15 Fc:8 Fs:16}



static void Test_BFu15ll_BFu8c_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu16s, BFu15ll_BFu8c_BFu16s)
//============================================================================


struct  BFu15ll_BFu8c_BFu17i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu8c_BFu17i) C1{ FL:15 Fc:8 Fi:17}



static void Test_BFu15ll_BFu8c_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu17i, BFu15ll_BFu8c_BFu17i)
//============================================================================


struct  BFu15ll_BFu8c_BFu17ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu8c_BFu17ll) C1{ FL:15 Fc:8 FL:17}



static void Test_BFu15ll_BFu8c_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu17ll, BFu15ll_BFu8c_BFu17ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu1c  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu8c_BFu1c) C1{ FL:15 Fc:8 Fc:1}



static void Test_BFu15ll_BFu8c_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu1c, BFu15ll_BFu8c_BFu1c)
//============================================================================


struct  BFu15ll_BFu8c_BFu1i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu8c_BFu1i) C1{ FL:15 Fc:8 Fi:1}



static void Test_BFu15ll_BFu8c_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu1i, BFu15ll_BFu8c_BFu1i)
//============================================================================


struct  BFu15ll_BFu8c_BFu1ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu8c_BFu1ll) C1{ FL:15 Fc:8 FL:1}



static void Test_BFu15ll_BFu8c_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu1ll, BFu15ll_BFu8c_BFu1ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu1s  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu8c_BFu1s) C1{ FL:15 Fc:8 Fs:1}



static void Test_BFu15ll_BFu8c_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu1s, BFu15ll_BFu8c_BFu1s)
//============================================================================


struct  BFu15ll_BFu8c_BFu31i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu8c_BFu31i) C1{ FL:15 Fc:8 Fi:31}



static void Test_BFu15ll_BFu8c_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu31i, BFu15ll_BFu8c_BFu31i)
//============================================================================


struct  BFu15ll_BFu8c_BFu31ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu8c_BFu31ll) C1{ FL:15 Fc:8 FL:31}



static void Test_BFu15ll_BFu8c_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu31ll, BFu15ll_BFu8c_BFu31ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu32i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu8c_BFu32i) C1{ FL:15 Fc:8 Fi:32}



static void Test_BFu15ll_BFu8c_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu32i, BFu15ll_BFu8c_BFu32i)
//============================================================================


struct  BFu15ll_BFu8c_BFu32ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu8c_BFu32ll) C1{ FL:15 Fc:8 FL:32}



static void Test_BFu15ll_BFu8c_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu32ll, BFu15ll_BFu8c_BFu32ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu33  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu8c_BFu33) C1{ FL:15 Fc:8 FL:33}



static void Test_BFu15ll_BFu8c_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu33");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15ll_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu33, BFu15ll_BFu8c_BFu33)
//============================================================================


struct  BFu15ll_BFu8c_BFu7c  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu8c_BFu7c) C1{ FL:15 Fc:8 Fc:7}



static void Test_BFu15ll_BFu8c_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu7c, BFu15ll_BFu8c_BFu7c)
//============================================================================


struct  BFu15ll_BFu8c_BFu7i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu8c_BFu7i) C1{ FL:15 Fc:8 Fi:7}



static void Test_BFu15ll_BFu8c_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu7i, BFu15ll_BFu8c_BFu7i)
//============================================================================


struct  BFu15ll_BFu8c_BFu7ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu8c_BFu7ll) C1{ FL:15 Fc:8 FL:7}



static void Test_BFu15ll_BFu8c_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu7ll, BFu15ll_BFu8c_BFu7ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu7s  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu8c_BFu7s) C1{ FL:15 Fc:8 Fs:7}



static void Test_BFu15ll_BFu8c_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu7s, BFu15ll_BFu8c_BFu7s)
//============================================================================


struct  BFu15ll_BFu8c_BFu8c  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu8c_BFu8c) C1{ FL:15 Fc:8 Fc:8}



static void Test_BFu15ll_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu8c, BFu15ll_BFu8c_BFu8c)
//============================================================================


struct  BFu15ll_BFu8c_BFu8i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu8c_BFu8i) C1{ FL:15 Fc:8 Fi:8}



static void Test_BFu15ll_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu8i, BFu15ll_BFu8c_BFu8i)
//============================================================================


struct  BFu15ll_BFu8c_BFu8ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu8c_BFu8ll) C1{ FL:15 Fc:8 FL:8}



static void Test_BFu15ll_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu8ll, BFu15ll_BFu8c_BFu8ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu8s  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu8c_BFu8s) C1{ FL:15 Fc:8 Fs:8}



static void Test_BFu15ll_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu8s, BFu15ll_BFu8c_BFu8s)
//============================================================================


struct  BFu15ll_BFu8c_BFu9i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu8c_BFu9i) C1{ FL:15 Fc:8 Fi:9}



static void Test_BFu15ll_BFu8c_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu9i, BFu15ll_BFu8c_BFu9i)
//============================================================================


struct  BFu15ll_BFu8c_BFu9ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu8c_BFu9ll) C1{ FL:15 Fc:8 FL:9}



static void Test_BFu15ll_BFu8c_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu9ll, BFu15ll_BFu8c_BFu9ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu9s  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu8c_BFu9s) C1{ FL:15 Fc:8 Fs:9}



static void Test_BFu15ll_BFu8c_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu9s, BFu15ll_BFu8c_BFu9s)
//============================================================================


struct  BFu15ll_BFu8c_C  {
  __tsu64 v1:15;
  unsigned char v2:8;
  char v3;
};
//SIG(1 BFu15ll_BFu8c_C) C1{ FL:15 Fc:8 Fc}



static void Test_BFu15ll_BFu8c_C()
{
  {
    init_simple_test("BFu15ll_BFu8c_C");
    static STRUCT_IF_C BFu15ll_BFu8c_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_C");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_C");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_C, BFu15ll_BFu8c_C)
//============================================================================


struct  BFu15ll_BFu8c_D  {
  __tsu64 v1:15;
  unsigned char v2:8;
  double v3;
};
//SIG(1 BFu15ll_BFu8c_D) C1{ FL:15 Fc:8 FL}



static void Test_BFu15ll_BFu8c_D()
{
  {
    init_simple_test("BFu15ll_BFu8c_D");
    static STRUCT_IF_C BFu15ll_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_D");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_D, BFu15ll_BFu8c_D)
//============================================================================


struct  BFu15ll_BFu8c_F  {
  __tsu64 v1:15;
  unsigned char v2:8;
  float v3;
};
//SIG(1 BFu15ll_BFu8c_F) C1{ FL:15 Fc:8 Fi}



static void Test_BFu15ll_BFu8c_F()
{
  {
    init_simple_test("BFu15ll_BFu8c_F");
    static STRUCT_IF_C BFu15ll_BFu8c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_F");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_F, BFu15ll_BFu8c_F)
//============================================================================


struct  BFu15ll_BFu8c_I  {
  __tsu64 v1:15;
  unsigned char v2:8;
  int v3;
};
//SIG(1 BFu15ll_BFu8c_I) C1{ FL:15 Fc:8 Fi}



static void Test_BFu15ll_BFu8c_I()
{
  {
    init_simple_test("BFu15ll_BFu8c_I");
    static STRUCT_IF_C BFu15ll_BFu8c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_I");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_I, BFu15ll_BFu8c_I)
//============================================================================


struct  BFu15ll_BFu8c_Ip  {
  __tsu64 v1:15;
  unsigned char v2:8;
  int *v3;
};
//SIG(1 BFu15ll_BFu8c_Ip) C1{ FL:15 Fc:8 Fp}



static void Test_BFu15ll_BFu8c_Ip()
{
  {
    init_simple_test("BFu15ll_BFu8c_Ip");
    static STRUCT_IF_C BFu15ll_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_Ip, BFu15ll_BFu8c_Ip)
//============================================================================


struct  BFu15ll_BFu8c_L  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu8c_L) C1{ FL:15 Fc:8 FL}



static void Test_BFu15ll_BFu8c_L()
{
  {
    init_simple_test("BFu15ll_BFu8c_L");
    static STRUCT_IF_C BFu15ll_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_L");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_L, BFu15ll_BFu8c_L)
//============================================================================


struct  BFu15ll_BFu8c_S  {
  __tsu64 v1:15;
  unsigned char v2:8;
  short v3;
};
//SIG(1 BFu15ll_BFu8c_S) C1{ FL:15 Fc:8 Fs}



static void Test_BFu15ll_BFu8c_S()
{
  {
    init_simple_test("BFu15ll_BFu8c_S");
    static STRUCT_IF_C BFu15ll_BFu8c_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_S");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_S, BFu15ll_BFu8c_S)
//============================================================================


struct  BFu15ll_BFu8c_Uc  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu8c_Uc) C1{ FL:15 Fc:8 Fc}



static void Test_BFu15ll_BFu8c_Uc()
{
  {
    init_simple_test("BFu15ll_BFu8c_Uc");
    static STRUCT_IF_C BFu15ll_BFu8c_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_Uc");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_Uc, BFu15ll_BFu8c_Uc)
//============================================================================


struct  BFu15ll_BFu8c_Ui  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu8c_Ui) C1{ FL:15 Fc:8 Fi}



static void Test_BFu15ll_BFu8c_Ui()
{
  {
    init_simple_test("BFu15ll_BFu8c_Ui");
    static STRUCT_IF_C BFu15ll_BFu8c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_Ui, BFu15ll_BFu8c_Ui)
//============================================================================


struct  BFu15ll_BFu8c_Ul  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu8c_Ul) C1{ FL:15 Fc:8 FL}



static void Test_BFu15ll_BFu8c_Ul()
{
  {
    init_simple_test("BFu15ll_BFu8c_Ul");
    static STRUCT_IF_C BFu15ll_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_Ul, BFu15ll_BFu8c_Ul)
//============================================================================


struct  BFu15ll_BFu8c_Us  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu8c_Us) C1{ FL:15 Fc:8 Fs}



static void Test_BFu15ll_BFu8c_Us()
{
  {
    init_simple_test("BFu15ll_BFu8c_Us");
    static STRUCT_IF_C BFu15ll_BFu8c_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_Us, BFu15ll_BFu8c_Us)
//============================================================================


struct  BFu15ll_BFu8c_Vp  {
  __tsu64 v1:15;
  unsigned char v2:8;
  void *v3;
};
//SIG(1 BFu15ll_BFu8c_Vp) C1{ FL:15 Fc:8 Fp}



static void Test_BFu15ll_BFu8c_Vp()
{
  {
    init_simple_test("BFu15ll_BFu8c_Vp");
    static STRUCT_IF_C BFu15ll_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_Vp, BFu15ll_BFu8c_Vp)
//============================================================================


struct  BFu15ll_BFu8i  {
  __tsu64 v1:15;
  unsigned int v2:8;
};
//SIG(1 BFu15ll_BFu8i) C1{ FL:15 Fi:8}



static void Test_BFu15ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i, BFu15ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu8i_BFu15i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu8i_BFu15i) C1{ FL:15 Fi:8 Fi:15}



static void Test_BFu15ll_BFu8i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu15i, BFu15ll_BFu8i_BFu15i)
//============================================================================


struct  BFu15ll_BFu8i_BFu15ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu8i_BFu15ll) C1{ FL:15 Fi:8 FL:15}



static void Test_BFu15ll_BFu8i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu15ll, BFu15ll_BFu8i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu15s  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu8i_BFu15s) C1{ FL:15 Fi:8 Fs:15}



static void Test_BFu15ll_BFu8i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu15s, BFu15ll_BFu8i_BFu15s)
//============================================================================


struct  BFu15ll_BFu8i_BFu16i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu8i_BFu16i) C1{ FL:15 Fi:8 Fi:16}



static void Test_BFu15ll_BFu8i_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu16i, BFu15ll_BFu8i_BFu16i)
//============================================================================


struct  BFu15ll_BFu8i_BFu16ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu8i_BFu16ll) C1{ FL:15 Fi:8 FL:16}



static void Test_BFu15ll_BFu8i_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu16ll, BFu15ll_BFu8i_BFu16ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu16s  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu8i_BFu16s) C1{ FL:15 Fi:8 Fs:16}



static void Test_BFu15ll_BFu8i_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu16s, BFu15ll_BFu8i_BFu16s)
//============================================================================


struct  BFu15ll_BFu8i_BFu17i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu8i_BFu17i) C1{ FL:15 Fi:8 Fi:17}



static void Test_BFu15ll_BFu8i_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu17i, BFu15ll_BFu8i_BFu17i)
//============================================================================


struct  BFu15ll_BFu8i_BFu17ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu8i_BFu17ll) C1{ FL:15 Fi:8 FL:17}



static void Test_BFu15ll_BFu8i_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu17ll, BFu15ll_BFu8i_BFu17ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu1c  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu8i_BFu1c) C1{ FL:15 Fi:8 Fc:1}



static void Test_BFu15ll_BFu8i_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu1c, BFu15ll_BFu8i_BFu1c)
//============================================================================


struct  BFu15ll_BFu8i_BFu1i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu8i_BFu1i) C1{ FL:15 Fi:8 Fi:1}



static void Test_BFu15ll_BFu8i_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu1i, BFu15ll_BFu8i_BFu1i)
//============================================================================


struct  BFu15ll_BFu8i_BFu1ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu8i_BFu1ll) C1{ FL:15 Fi:8 FL:1}



static void Test_BFu15ll_BFu8i_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu1ll, BFu15ll_BFu8i_BFu1ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu1s  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu8i_BFu1s) C1{ FL:15 Fi:8 Fs:1}



static void Test_BFu15ll_BFu8i_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu1s, BFu15ll_BFu8i_BFu1s)
//============================================================================


struct  BFu15ll_BFu8i_BFu31i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu8i_BFu31i) C1{ FL:15 Fi:8 Fi:31}



static void Test_BFu15ll_BFu8i_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu31i, BFu15ll_BFu8i_BFu31i)
//============================================================================


struct  BFu15ll_BFu8i_BFu31ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu8i_BFu31ll) C1{ FL:15 Fi:8 FL:31}



static void Test_BFu15ll_BFu8i_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu31ll, BFu15ll_BFu8i_BFu31ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu32i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu8i_BFu32i) C1{ FL:15 Fi:8 Fi:32}



static void Test_BFu15ll_BFu8i_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu32i, BFu15ll_BFu8i_BFu32i)
//============================================================================


struct  BFu15ll_BFu8i_BFu32ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu8i_BFu32ll) C1{ FL:15 Fi:8 FL:32}



static void Test_BFu15ll_BFu8i_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu32ll, BFu15ll_BFu8i_BFu32ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu33  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu8i_BFu33) C1{ FL:15 Fi:8 FL:33}



static void Test_BFu15ll_BFu8i_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu33");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu15ll_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu33, BFu15ll_BFu8i_BFu33)
//============================================================================


struct  BFu15ll_BFu8i_BFu7c  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu8i_BFu7c) C1{ FL:15 Fi:8 Fc:7}



static void Test_BFu15ll_BFu8i_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu7c, BFu15ll_BFu8i_BFu7c)
//============================================================================


struct  BFu15ll_BFu8i_BFu7i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu8i_BFu7i) C1{ FL:15 Fi:8 Fi:7}



static void Test_BFu15ll_BFu8i_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu7i, BFu15ll_BFu8i_BFu7i)
//============================================================================


struct  BFu15ll_BFu8i_BFu7ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu8i_BFu7ll) C1{ FL:15 Fi:8 FL:7}



static void Test_BFu15ll_BFu8i_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu7ll, BFu15ll_BFu8i_BFu7ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu7s  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu8i_BFu7s) C1{ FL:15 Fi:8 Fs:7}



static void Test_BFu15ll_BFu8i_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu7s, BFu15ll_BFu8i_BFu7s)
//============================================================================


struct  BFu15ll_BFu8i_BFu8c  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu8i_BFu8c) C1{ FL:15 Fi:8 Fc:8}



static void Test_BFu15ll_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu8c, BFu15ll_BFu8i_BFu8c)
//============================================================================


struct  BFu15ll_BFu8i_BFu8i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu8i_BFu8i) C1{ FL:15 Fi:8 Fi:8}



static void Test_BFu15ll_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu8i, BFu15ll_BFu8i_BFu8i)
//============================================================================


struct  BFu15ll_BFu8i_BFu8ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu8i_BFu8ll) C1{ FL:15 Fi:8 FL:8}



static void Test_BFu15ll_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu8ll, BFu15ll_BFu8i_BFu8ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu8s  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu8i_BFu8s) C1{ FL:15 Fi:8 Fs:8}



static void Test_BFu15ll_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu8s, BFu15ll_BFu8i_BFu8s)
//============================================================================


struct  BFu15ll_BFu8i_BFu9i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu8i_BFu9i) C1{ FL:15 Fi:8 Fi:9}



static void Test_BFu15ll_BFu8i_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu9i, BFu15ll_BFu8i_BFu9i)
//============================================================================


struct  BFu15ll_BFu8i_BFu9ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu8i_BFu9ll) C1{ FL:15 Fi:8 FL:9}



static void Test_BFu15ll_BFu8i_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu9ll, BFu15ll_BFu8i_BFu9ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu9s  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu8i_BFu9s) C1{ FL:15 Fi:8 Fs:9}



static void Test_BFu15ll_BFu8i_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu9s, BFu15ll_BFu8i_BFu9s)
//============================================================================


struct  BFu15ll_BFu8i_C  {
  __tsu64 v1:15;
  unsigned int v2:8;
  char v3;
};
//SIG(1 BFu15ll_BFu8i_C) C1{ FL:15 Fi:8 Fc}



static void Test_BFu15ll_BFu8i_C()
{
  {
    init_simple_test("BFu15ll_BFu8i_C");
    static STRUCT_IF_C BFu15ll_BFu8i_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_C");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_C, BFu15ll_BFu8i_C)
//============================================================================


struct  BFu15ll_BFu8i_D  {
  __tsu64 v1:15;
  unsigned int v2:8;
  double v3;
};
//SIG(1 BFu15ll_BFu8i_D) C1{ FL:15 Fi:8 FL}



static void Test_BFu15ll_BFu8i_D()
{
  {
    init_simple_test("BFu15ll_BFu8i_D");
    static STRUCT_IF_C BFu15ll_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_D, BFu15ll_BFu8i_D)
//============================================================================


struct  BFu15ll_BFu8i_F  {
  __tsu64 v1:15;
  unsigned int v2:8;
  float v3;
};
//SIG(1 BFu15ll_BFu8i_F) C1{ FL:15 Fi:8 Fi}



static void Test_BFu15ll_BFu8i_F()
{
  {
    init_simple_test("BFu15ll_BFu8i_F");
    static STRUCT_IF_C BFu15ll_BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_F, BFu15ll_BFu8i_F)
//============================================================================


struct  BFu15ll_BFu8i_I  {
  __tsu64 v1:15;
  unsigned int v2:8;
  int v3;
};
//SIG(1 BFu15ll_BFu8i_I) C1{ FL:15 Fi:8 Fi}



static void Test_BFu15ll_BFu8i_I()
{
  {
    init_simple_test("BFu15ll_BFu8i_I");
    static STRUCT_IF_C BFu15ll_BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_I, BFu15ll_BFu8i_I)
//============================================================================


struct  BFu15ll_BFu8i_Ip  {
  __tsu64 v1:15;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 BFu15ll_BFu8i_Ip) C1{ FL:15 Fi:8 Fp}



static void Test_BFu15ll_BFu8i_Ip()
{
  {
    init_simple_test("BFu15ll_BFu8i_Ip");
    static STRUCT_IF_C BFu15ll_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_Ip, BFu15ll_BFu8i_Ip)
//============================================================================


struct  BFu15ll_BFu8i_L  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu8i_L) C1{ FL:15 Fi:8 FL}



static void Test_BFu15ll_BFu8i_L()
{
  {
    init_simple_test("BFu15ll_BFu8i_L");
    static STRUCT_IF_C BFu15ll_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_L, BFu15ll_BFu8i_L)
//============================================================================


struct  BFu15ll_BFu8i_S  {
  __tsu64 v1:15;
  unsigned int v2:8;
  short v3;
};
//SIG(1 BFu15ll_BFu8i_S) C1{ FL:15 Fi:8 Fs}



static void Test_BFu15ll_BFu8i_S()
{
  {
    init_simple_test("BFu15ll_BFu8i_S");
    static STRUCT_IF_C BFu15ll_BFu8i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_S, BFu15ll_BFu8i_S)
//============================================================================


struct  BFu15ll_BFu8i_Uc  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu8i_Uc) C1{ FL:15 Fi:8 Fc}



static void Test_BFu15ll_BFu8i_Uc()
{
  {
    init_simple_test("BFu15ll_BFu8i_Uc");
    static STRUCT_IF_C BFu15ll_BFu8i_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_Uc");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_Uc, BFu15ll_BFu8i_Uc)
//============================================================================


struct  BFu15ll_BFu8i_Ui  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu8i_Ui) C1{ FL:15 Fi:8 Fi}



static void Test_BFu15ll_BFu8i_Ui()
{
  {
    init_simple_test("BFu15ll_BFu8i_Ui");
    static STRUCT_IF_C BFu15ll_BFu8i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_Ui, BFu15ll_BFu8i_Ui)
//============================================================================


struct  BFu15ll_BFu8i_Ul  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu8i_Ul) C1{ FL:15 Fi:8 FL}



static void Test_BFu15ll_BFu8i_Ul()
{
  {
    init_simple_test("BFu15ll_BFu8i_Ul");
    static STRUCT_IF_C BFu15ll_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_Ul, BFu15ll_BFu8i_Ul)
//============================================================================


struct  BFu15ll_BFu8i_Us  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu8i_Us) C1{ FL:15 Fi:8 Fs}



static void Test_BFu15ll_BFu8i_Us()
{
  {
    init_simple_test("BFu15ll_BFu8i_Us");
    static STRUCT_IF_C BFu15ll_BFu8i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_Us, BFu15ll_BFu8i_Us)
//============================================================================


struct  BFu15ll_BFu8i_Vp  {
  __tsu64 v1:15;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 BFu15ll_BFu8i_Vp) C1{ FL:15 Fi:8 Fp}



static void Test_BFu15ll_BFu8i_Vp()
{
  {
    init_simple_test("BFu15ll_BFu8i_Vp");
    static STRUCT_IF_C BFu15ll_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_Vp, BFu15ll_BFu8i_Vp)
//============================================================================


struct  BFu15ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
};
//SIG(1 BFu15ll_BFu8ll) C1{ FL:15 FL:8}



static void Test_BFu15ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll, BFu15ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu8ll_BFu15i) C1{ FL:15 FL:8 Fi:15}



static void Test_BFu15ll_BFu8ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu15i, BFu15ll_BFu8ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu8ll_BFu15ll) C1{ FL:15 FL:8 FL:15}



static void Test_BFu15ll_BFu8ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu15ll, BFu15ll_BFu8ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu8ll_BFu15s) C1{ FL:15 FL:8 Fs:15}



static void Test_BFu15ll_BFu8ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu15s, BFu15ll_BFu8ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu8ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu8ll_BFu16i) C1{ FL:15 FL:8 Fi:16}



static void Test_BFu15ll_BFu8ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu16i, BFu15ll_BFu8ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu8ll_BFu16ll) C1{ FL:15 FL:8 FL:16}



static void Test_BFu15ll_BFu8ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu16ll, BFu15ll_BFu8ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu8ll_BFu16s) C1{ FL:15 FL:8 Fs:16}



static void Test_BFu15ll_BFu8ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu16s, BFu15ll_BFu8ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu8ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu8ll_BFu17i) C1{ FL:15 FL:8 Fi:17}



static void Test_BFu15ll_BFu8ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu17i, BFu15ll_BFu8ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu8ll_BFu17ll) C1{ FL:15 FL:8 FL:17}



static void Test_BFu15ll_BFu8ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu17ll, BFu15ll_BFu8ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu8ll_BFu1c) C1{ FL:15 FL:8 Fc:1}



static void Test_BFu15ll_BFu8ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu1c, BFu15ll_BFu8ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu8ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu8ll_BFu1i) C1{ FL:15 FL:8 Fi:1}



static void Test_BFu15ll_BFu8ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu1i, BFu15ll_BFu8ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu8ll_BFu1ll) C1{ FL:15 FL:8 FL:1}



static void Test_BFu15ll_BFu8ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu1ll, BFu15ll_BFu8ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu8ll_BFu1s) C1{ FL:15 FL:8 Fs:1}



static void Test_BFu15ll_BFu8ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15ll_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu1s, BFu15ll_BFu8ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu8ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu8ll_BFu31i) C1{ FL:15 FL:8 Fi:31}



static void Test_BFu15ll_BFu8ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu31i, BFu15ll_BFu8ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu8ll_BFu31ll) C1{ FL:15 FL:8 FL:31}



static void Test_BFu15ll_BFu8ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu31ll, BFu15ll_BFu8ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu8ll_BFu32i) C1{ FL:15 FL:8 Fi:32}



static void Test_BFu15ll_BFu8ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu32i, BFu15ll_BFu8ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu8ll_BFu32ll) C1{ FL:15 FL:8 FL:32}



static void Test_BFu15ll_BFu8ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu32ll, BFu15ll_BFu8ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu33  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_BFu8ll_BFu33) C1{ FL:15 FL:8 FL:33}



static void Test_BFu15ll_BFu8ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu15ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu33, BFu15ll_BFu8ll_BFu33)
//============================================================================


struct  BFu15ll_BFu8ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_BFu8ll_BFu7c) C1{ FL:15 FL:8 Fc:7}



static void Test_BFu15ll_BFu8ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu7c, BFu15ll_BFu8ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu8ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_BFu8ll_BFu7i) C1{ FL:15 FL:8 Fi:7}



static void Test_BFu15ll_BFu8ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu7i, BFu15ll_BFu8ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_BFu8ll_BFu7ll) C1{ FL:15 FL:8 FL:7}



static void Test_BFu15ll_BFu8ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu7ll, BFu15ll_BFu8ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_BFu8ll_BFu7s) C1{ FL:15 FL:8 Fs:7}



static void Test_BFu15ll_BFu8ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu7s, BFu15ll_BFu8ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu8ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_BFu8ll_BFu8c) C1{ FL:15 FL:8 Fc:8}



static void Test_BFu15ll_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu8c, BFu15ll_BFu8ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu8ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_BFu8ll_BFu8i) C1{ FL:15 FL:8 Fi:8}



static void Test_BFu15ll_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu8i, BFu15ll_BFu8ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_BFu8ll_BFu8ll) C1{ FL:15 FL:8 FL:8}



static void Test_BFu15ll_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu8ll, BFu15ll_BFu8ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_BFu8ll_BFu8s) C1{ FL:15 FL:8 Fs:8}



static void Test_BFu15ll_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu8s, BFu15ll_BFu8ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu8ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_BFu8ll_BFu9i) C1{ FL:15 FL:8 Fi:9}



static void Test_BFu15ll_BFu8ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu9i, BFu15ll_BFu8ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_BFu8ll_BFu9ll) C1{ FL:15 FL:8 FL:9}



static void Test_BFu15ll_BFu8ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu9ll, BFu15ll_BFu8ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_BFu8ll_BFu9s) C1{ FL:15 FL:8 Fs:9}



static void Test_BFu15ll_BFu8ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu9s, BFu15ll_BFu8ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu8ll_C  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 BFu15ll_BFu8ll_C) C1{ FL:15 FL:8 Fc}



static void Test_BFu15ll_BFu8ll_C()
{
  {
    init_simple_test("BFu15ll_BFu8ll_C");
    static STRUCT_IF_C BFu15ll_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_C");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_C, BFu15ll_BFu8ll_C)
//============================================================================


struct  BFu15ll_BFu8ll_D  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 BFu15ll_BFu8ll_D) C1{ FL:15 FL:8 FL}



static void Test_BFu15ll_BFu8ll_D()
{
  {
    init_simple_test("BFu15ll_BFu8ll_D");
    static STRUCT_IF_C BFu15ll_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_D, BFu15ll_BFu8ll_D)
//============================================================================


struct  BFu15ll_BFu8ll_F  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 BFu15ll_BFu8ll_F) C1{ FL:15 FL:8 Fi}



static void Test_BFu15ll_BFu8ll_F()
{
  {
    init_simple_test("BFu15ll_BFu8ll_F");
    static STRUCT_IF_C BFu15ll_BFu8ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_F");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_F, BFu15ll_BFu8ll_F)
//============================================================================


struct  BFu15ll_BFu8ll_I  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 BFu15ll_BFu8ll_I) C1{ FL:15 FL:8 Fi}



static void Test_BFu15ll_BFu8ll_I()
{
  {
    init_simple_test("BFu15ll_BFu8ll_I");
    static STRUCT_IF_C BFu15ll_BFu8ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_I");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_I, BFu15ll_BFu8ll_I)
//============================================================================


struct  BFu15ll_BFu8ll_Ip  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 BFu15ll_BFu8ll_Ip) C1{ FL:15 FL:8 Fp}



static void Test_BFu15ll_BFu8ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu8ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_Ip, BFu15ll_BFu8ll_Ip)
//============================================================================


struct  BFu15ll_BFu8ll_L  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 BFu15ll_BFu8ll_L) C1{ FL:15 FL:8 FL}



static void Test_BFu15ll_BFu8ll_L()
{
  {
    init_simple_test("BFu15ll_BFu8ll_L");
    static STRUCT_IF_C BFu15ll_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_L, BFu15ll_BFu8ll_L)
//============================================================================


struct  BFu15ll_BFu8ll_S  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 BFu15ll_BFu8ll_S) C1{ FL:15 FL:8 Fs}



static void Test_BFu15ll_BFu8ll_S()
{
  {
    init_simple_test("BFu15ll_BFu8ll_S");
    static STRUCT_IF_C BFu15ll_BFu8ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_S");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_S, BFu15ll_BFu8ll_S)
//============================================================================


struct  BFu15ll_BFu8ll_Uc  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 BFu15ll_BFu8ll_Uc) C1{ FL:15 FL:8 Fc}



static void Test_BFu15ll_BFu8ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu8ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_Uc");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_Uc, BFu15ll_BFu8ll_Uc)
//============================================================================


struct  BFu15ll_BFu8ll_Ui  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 BFu15ll_BFu8ll_Ui) C1{ FL:15 FL:8 Fi}



static void Test_BFu15ll_BFu8ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu8ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu8ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_Ui");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_Ui, BFu15ll_BFu8ll_Ui)
//============================================================================


struct  BFu15ll_BFu8ll_Ul  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 BFu15ll_BFu8ll_Ul) C1{ FL:15 FL:8 FL}



static void Test_BFu15ll_BFu8ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu8ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_Ul, BFu15ll_BFu8ll_Ul)
//============================================================================


struct  BFu15ll_BFu8ll_Us  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 BFu15ll_BFu8ll_Us) C1{ FL:15 FL:8 Fs}



static void Test_BFu15ll_BFu8ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu8ll_Us");
    static STRUCT_IF_C BFu15ll_BFu8ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_Us");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_Us, BFu15ll_BFu8ll_Us)
//============================================================================


struct  BFu15ll_BFu8ll_Vp  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 BFu15ll_BFu8ll_Vp) C1{ FL:15 FL:8 Fp}



static void Test_BFu15ll_BFu8ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu8ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_Vp, BFu15ll_BFu8ll_Vp)
//============================================================================


struct  BFu15ll_BFu8s  {
  __tsu64 v1:15;
  unsigned short v2:8;
};
//SIG(1 BFu15ll_BFu8s) C1{ FL:15 Fs:8}



static void Test_BFu15ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s, BFu15ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu8s_BFu15i  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_BFu8s_BFu15i) C1{ FL:15 Fs:8 Fi:15}



static void Test_BFu15ll_BFu8s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu15i, BFu15ll_BFu8s_BFu15i)
//============================================================================


struct  BFu15ll_BFu8s_BFu15ll  {
  __tsu64 v1:15;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_BFu8s_BFu15ll) C1{ FL:15 Fs:8 FL:15}



static void Test_BFu15ll_BFu8s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu15ll, BFu15ll_BFu8s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu8s_BFu15s  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_BFu8s_BFu15s) C1{ FL:15 Fs:8 Fs:15}



static void Test_BFu15ll_BFu8s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu15s, BFu15ll_BFu8s_BFu15s)
//============================================================================


struct  BFu15ll_BFu8s_BFu16i  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_BFu8s_BFu16i) C1{ FL:15 Fs:8 Fi:16}



static void Test_BFu15ll_BFu8s_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu16i, BFu15ll_BFu8s_BFu16i)
//============================================================================


struct  BFu15ll_BFu8s_BFu16ll  {
  __tsu64 v1:15;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_BFu8s_BFu16ll) C1{ FL:15 Fs:8 FL:16}



static void Test_BFu15ll_BFu8s_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu16ll, BFu15ll_BFu8s_BFu16ll)
//============================================================================


struct  BFu15ll_BFu8s_BFu16s  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_BFu8s_BFu16s) C1{ FL:15 Fs:8 Fs:16}



static void Test_BFu15ll_BFu8s_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu16s, BFu15ll_BFu8s_BFu16s)
//============================================================================


struct  BFu15ll_BFu8s_BFu17i  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_BFu8s_BFu17i) C1{ FL:15 Fs:8 Fi:17}



static void Test_BFu15ll_BFu8s_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu17i, BFu15ll_BFu8s_BFu17i)
//============================================================================


struct  BFu15ll_BFu8s_BFu17ll  {
  __tsu64 v1:15;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_BFu8s_BFu17ll) C1{ FL:15 Fs:8 FL:17}



static void Test_BFu15ll_BFu8s_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu17ll, BFu15ll_BFu8s_BFu17ll)
//============================================================================


struct  BFu15ll_BFu8s_BFu1c  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_BFu8s_BFu1c) C1{ FL:15 Fs:8 Fc:1}



static void Test_BFu15ll_BFu8s_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu1c, BFu15ll_BFu8s_BFu1c)
//============================================================================


struct  BFu15ll_BFu8s_BFu1i  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_BFu8s_BFu1i) C1{ FL:15 Fs:8 Fi:1}



static void Test_BFu15ll_BFu8s_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu1i, BFu15ll_BFu8s_BFu1i)
//============================================================================


struct  BFu15ll_BFu8s_BFu1ll  {
  __tsu64 v1:15;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_BFu8s_BFu1ll) C1{ FL:15 Fs:8 FL:1}



static void Test_BFu15ll_BFu8s_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu1ll, BFu15ll_BFu8s_BFu1ll)
//============================================================================


struct  BFu15ll_BFu8s_BFu1s  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_BFu8s_BFu1s) C1{ FL:15 Fs:8 Fs:1}



static void Test_BFu15ll_BFu8s_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu1s, BFu15ll_BFu8s_BFu1s)
//============================================================================


struct  BFu15ll_BFu8s_BFu31i  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_BFu8s_BFu31i) C1{ FL:15 Fs:8 Fi:31}



static void Test_BFu15ll_BFu8s_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu31i, BFu15ll_BFu8s_BFu31i)
//============================================================================


struct  BFu15ll_BFu8s_BFu31ll  {
  __tsu64 v1:15;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_BFu8s_BFu31ll) C1{ FL:15 Fs:8 FL:31}



static void Test_BFu15ll_BFu8s_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu31ll, BFu15ll_BFu8s_BFu31ll)
//============================================================================


struct  BFu15ll_BFu8s_BFu32i  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_BFu8s_BFu32i) C1{ FL:15 Fs:8 Fi:32}



static void Test_BFu15ll_BFu8s_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu32i, BFu15ll_BFu8s_BFu32i)
//============================================================================


struct  BFu15ll_BFu8s_BFu32ll  {
  __tsu64 v1:15;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_BFu8s_BFu32ll) C1{ FL:15 Fs:8 FL:32}



static void Test_BFu15ll_BFu8s_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15l