// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFs8s_BFu8ll_BFu8c_BFu8ll  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8c_BFu8ll) C1{ Fs:8 FL:8 Fc:8 FL:8}



static void Test_BFs8s_BFu8ll_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8c_BFu8ll, BFs8s_BFu8ll_BFu8c_BFu8ll)
//============================================================================


struct  BFs8s_BFu8ll_BFu8c_BFu8s  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8c_BFu8s) C1{ Fs:8 FL:8 Fc:8 Fs:8}



static void Test_BFs8s_BFu8ll_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8c_BFu8s, BFs8s_BFu8ll_BFu8c_BFu8s)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i) C1{ Fs:8 FL:8 Fi:8}



static void Test_BFs8s_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i, BFs8s_BFu8ll_BFu8i)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i_BFs8c  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i_BFs8c) C1{ Fs:8 FL:8 Fi:8 Fc:8}



static void Test_BFs8s_BFu8ll_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i_BFs8c, BFs8s_BFu8ll_BFu8i_BFs8c)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i_BFs8i  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i_BFs8i) C1{ Fs:8 FL:8 Fi:8 Fi:8}



static void Test_BFs8s_BFu8ll_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i_BFs8i, BFs8s_BFu8ll_BFu8i_BFs8i)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i_BFs8ll  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i_BFs8ll) C1{ Fs:8 FL:8 Fi:8 FL:8}



static void Test_BFs8s_BFu8ll_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i_BFs8ll, BFs8s_BFu8ll_BFu8i_BFs8ll)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i_BFs8s  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i_BFs8s) C1{ Fs:8 FL:8 Fi:8 Fs:8}



static void Test_BFs8s_BFu8ll_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i_BFs8s, BFs8s_BFu8ll_BFu8i_BFs8s)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i_BFu8c  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i_BFu8c) C1{ Fs:8 FL:8 Fi:8 Fc:8}



static void Test_BFs8s_BFu8ll_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i_BFu8c, BFs8s_BFu8ll_BFu8i_BFu8c)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i_BFu8i  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i_BFu8i) C1{ Fs:8 FL:8 Fi:8 Fi:8}



static void Test_BFs8s_BFu8ll_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i_BFu8i, BFs8s_BFu8ll_BFu8i_BFu8i)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i_BFu8ll  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i_BFu8ll) C1{ Fs:8 FL:8 Fi:8 FL:8}



static void Test_BFs8s_BFu8ll_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i_BFu8ll, BFs8s_BFu8ll_BFu8i_BFu8ll)
//============================================================================


struct  BFs8s_BFu8ll_BFu8i_BFu8s  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8i_BFu8s) C1{ Fs:8 FL:8 Fi:8 Fs:8}



static void Test_BFs8s_BFu8ll_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8i_BFu8s, BFs8s_BFu8ll_BFu8i_BFu8s)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll) C1{ Fs:8 FL:8 FL:8}



static void Test_BFs8s_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll, BFs8s_BFu8ll_BFu8ll)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll_BFs8c  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll_BFs8c) C1{ Fs:8 FL:8 FL:8 Fc:8}



static void Test_BFs8s_BFu8ll_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll_BFs8c, BFs8s_BFu8ll_BFu8ll_BFs8c)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll_BFs8i  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll_BFs8i) C1{ Fs:8 FL:8 FL:8 Fi:8}



static void Test_BFs8s_BFu8ll_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll_BFs8i, BFs8s_BFu8ll_BFu8ll_BFs8i)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll_BFs8ll  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll_BFs8ll) C1{ Fs:8 FL:8 FL:8 FL:8}



static void Test_BFs8s_BFu8ll_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll_BFs8ll, BFs8s_BFu8ll_BFu8ll_BFs8ll)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll_BFs8s  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll_BFs8s) C1{ Fs:8 FL:8 FL:8 Fs:8}



static void Test_BFs8s_BFu8ll_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll_BFs8s, BFs8s_BFu8ll_BFu8ll_BFs8s)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll_BFu8c  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll_BFu8c) C1{ Fs:8 FL:8 FL:8 Fc:8}



static void Test_BFs8s_BFu8ll_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll_BFu8c, BFs8s_BFu8ll_BFu8ll_BFu8c)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll_BFu8i  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll_BFu8i) C1{ Fs:8 FL:8 FL:8 Fi:8}



static void Test_BFs8s_BFu8ll_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll_BFu8i, BFs8s_BFu8ll_BFu8ll_BFu8i)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll_BFu8ll  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll_BFu8ll) C1{ Fs:8 FL:8 FL:8 FL:8}



static void Test_BFs8s_BFu8ll_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll_BFu8ll, BFs8s_BFu8ll_BFu8ll_BFu8ll)
//============================================================================


struct  BFs8s_BFu8ll_BFu8ll_BFu8s  {
  signed short v1:8;
  __tsu64 v2:8;
  __tsu64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8ll_BFu8s) C1{ Fs:8 FL:8 FL:8 Fs:8}



static void Test_BFs8s_BFu8ll_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8ll_BFu8s, BFs8s_BFu8ll_BFu8ll_BFu8s)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s) C1{ Fs:8 FL:8 Fs:8}



static void Test_BFs8s_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s, BFs8s_BFu8ll_BFu8s)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s_BFs8c  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s_BFs8c) C1{ Fs:8 FL:8 Fs:8 Fc:8}



static void Test_BFs8s_BFu8ll_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s_BFs8c, BFs8s_BFu8ll_BFu8s_BFs8c)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s_BFs8i  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s_BFs8i) C1{ Fs:8 FL:8 Fs:8 Fi:8}



static void Test_BFs8s_BFu8ll_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s_BFs8i, BFs8s_BFu8ll_BFu8s_BFs8i)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s_BFs8ll  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s_BFs8ll) C1{ Fs:8 FL:8 Fs:8 FL:8}



static void Test_BFs8s_BFu8ll_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s_BFs8ll, BFs8s_BFu8ll_BFu8s_BFs8ll)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s_BFs8s  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s_BFs8s) C1{ Fs:8 FL:8 Fs:8 Fs:8}



static void Test_BFs8s_BFu8ll_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s_BFs8s, BFs8s_BFu8ll_BFu8s_BFs8s)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s_BFu8c  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s_BFu8c) C1{ Fs:8 FL:8 Fs:8 Fc:8}



static void Test_BFs8s_BFu8ll_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s_BFu8c, BFs8s_BFu8ll_BFu8s_BFu8c)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s_BFu8i  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s_BFu8i) C1{ Fs:8 FL:8 Fs:8 Fi:8}



static void Test_BFs8s_BFu8ll_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s_BFu8i, BFs8s_BFu8ll_BFu8s_BFu8i)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s_BFu8ll  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s_BFu8ll) C1{ Fs:8 FL:8 Fs:8 FL:8}



static void Test_BFs8s_BFu8ll_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s_BFu8ll, BFs8s_BFu8ll_BFu8s_BFu8ll)
//============================================================================


struct  BFs8s_BFu8ll_BFu8s_BFu8s  {
  signed short v1:8;
  __tsu64 v2:8;
  unsigned short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8ll_BFu8s_BFu8s) C1{ Fs:8 FL:8 Fs:8 Fs:8}



static void Test_BFs8s_BFu8ll_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8ll_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8ll_BFu8s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8ll_BFu8s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8ll_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8ll_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8ll_BFu8s_BFu8s, BFs8s_BFu8ll_BFu8s_BFu8s)
//============================================================================


struct  BFs8s_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
};
//SIG(1 BFs8s_BFu8s) C1{ Fs:8 Fs:8}



static void Test_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFs8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s, BFs8s_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c) C1{ Fs:8 Fs:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c, BFs8s_BFu8s_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8c_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c_BFs8c) C1{ Fs:8 Fs:8 Fc:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8c_BFs8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c_BFs8c, BFs8s_BFu8s_BFs8c_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8c_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c_BFs8i) C1{ Fs:8 Fs:8 Fc:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c_BFs8i, BFs8s_BFu8s_BFs8c_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8c_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c_BFs8ll) C1{ Fs:8 Fs:8 Fc:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c_BFs8ll, BFs8s_BFu8s_BFs8c_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8c_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c_BFs8s) C1{ Fs:8 Fs:8 Fc:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8c_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c_BFs8s, BFs8s_BFu8s_BFs8c_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8c_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c_BFu8c) C1{ Fs:8 Fs:8 Fc:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c_BFu8c, BFs8s_BFu8s_BFs8c_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8c_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c_BFu8i) C1{ Fs:8 Fs:8 Fc:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c_BFu8i, BFs8s_BFu8s_BFs8c_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8c_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c_BFu8ll) C1{ Fs:8 Fs:8 Fc:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c_BFu8ll, BFs8s_BFu8s_BFs8c_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8c_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8c_BFu8s) C1{ Fs:8 Fs:8 Fc:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8c_BFu8s, BFs8s_BFu8s_BFs8c_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i) C1{ Fs:8 Fs:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i, BFs8s_BFu8s_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8i_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i_BFs8c) C1{ Fs:8 Fs:8 Fi:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i_BFs8c, BFs8s_BFu8s_BFs8i_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8i_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i_BFs8i) C1{ Fs:8 Fs:8 Fi:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i_BFs8i, BFs8s_BFu8s_BFs8i_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8i_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i_BFs8ll) C1{ Fs:8 Fs:8 Fi:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i_BFs8ll, BFs8s_BFu8s_BFs8i_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8i_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i_BFs8s) C1{ Fs:8 Fs:8 Fi:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i_BFs8s, BFs8s_BFu8s_BFs8i_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8i_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i_BFu8c) C1{ Fs:8 Fs:8 Fi:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i_BFu8c, BFs8s_BFu8s_BFs8i_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8i_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i_BFu8i) C1{ Fs:8 Fs:8 Fi:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i_BFu8i, BFs8s_BFu8s_BFs8i_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8i_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i_BFu8ll) C1{ Fs:8 Fs:8 Fi:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i_BFu8ll, BFs8s_BFu8s_BFs8i_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8i_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8i_BFu8s) C1{ Fs:8 Fs:8 Fi:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8i_BFu8s, BFs8s_BFu8s_BFs8i_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll) C1{ Fs:8 Fs:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll, BFs8s_BFu8s_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll_BFs8c) C1{ Fs:8 Fs:8 FL:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll_BFs8c, BFs8s_BFu8s_BFs8ll_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll_BFs8i) C1{ Fs:8 Fs:8 FL:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll_BFs8i, BFs8s_BFu8s_BFs8ll_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll_BFs8ll) C1{ Fs:8 Fs:8 FL:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll_BFs8ll, BFs8s_BFu8s_BFs8ll_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll_BFs8s) C1{ Fs:8 Fs:8 FL:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll_BFs8s, BFs8s_BFu8s_BFs8ll_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll_BFu8c) C1{ Fs:8 Fs:8 FL:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll_BFu8c, BFs8s_BFu8s_BFs8ll_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll_BFu8i) C1{ Fs:8 Fs:8 FL:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll_BFu8i, BFs8s_BFu8s_BFs8ll_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll_BFu8ll) C1{ Fs:8 Fs:8 FL:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll_BFu8ll, BFs8s_BFu8s_BFs8ll_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8ll_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed __tsi64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8ll_BFu8s) C1{ Fs:8 Fs:8 FL:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8ll_BFu8s, BFs8s_BFu8s_BFs8ll_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s) C1{ Fs:8 Fs:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s, BFs8s_BFu8s_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8s_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s_BFs8c) C1{ Fs:8 Fs:8 Fs:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8s_BFs8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s_BFs8c, BFs8s_BFu8s_BFs8s_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8s_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s_BFs8i) C1{ Fs:8 Fs:8 Fs:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s_BFs8i, BFs8s_BFu8s_BFs8s_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8s_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s_BFs8ll) C1{ Fs:8 Fs:8 Fs:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s_BFs8ll, BFs8s_BFu8s_BFs8s_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8s_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s_BFs8s) C1{ Fs:8 Fs:8 Fs:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8s_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s_BFs8s, BFs8s_BFu8s_BFs8s_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFs8s_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s_BFu8c) C1{ Fs:8 Fs:8 Fs:8 Fc:8}



static void Test_BFs8s_BFu8s_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s_BFu8c, BFs8s_BFu8s_BFs8s_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFs8s_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s_BFu8i) C1{ Fs:8 Fs:8 Fs:8 Fi:8}



static void Test_BFs8s_BFu8s_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s_BFu8i, BFs8s_BFu8s_BFs8s_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFs8s_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s_BFu8ll) C1{ Fs:8 Fs:8 Fs:8 FL:8}



static void Test_BFs8s_BFu8s_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFs8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s_BFu8ll, BFs8s_BFu8s_BFs8s_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFs8s_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  signed short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFs8s_BFu8s) C1{ Fs:8 Fs:8 Fs:8 Fs:8}



static void Test_BFs8s_BFu8s_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFs8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFs8s_BFu8s, BFs8s_BFu8s_BFs8s_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c) C1{ Fs:8 Fs:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c, BFs8s_BFu8s_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8c_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c_BFs8c) C1{ Fs:8 Fs:8 Fc:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8c_BFs8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c_BFs8c, BFs8s_BFu8s_BFu8c_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8c_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c_BFs8i) C1{ Fs:8 Fs:8 Fc:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c_BFs8i, BFs8s_BFu8s_BFu8c_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8c_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c_BFs8ll) C1{ Fs:8 Fs:8 Fc:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c_BFs8ll, BFs8s_BFu8s_BFu8c_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8c_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c_BFs8s) C1{ Fs:8 Fs:8 Fc:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8c_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c_BFs8s, BFs8s_BFu8s_BFu8c_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8c_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c_BFu8c) C1{ Fs:8 Fs:8 Fc:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c_BFu8c, BFs8s_BFu8s_BFu8c_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8c_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c_BFu8i) C1{ Fs:8 Fs:8 Fc:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c_BFu8i, BFs8s_BFu8s_BFu8c_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8c_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c_BFu8ll) C1{ Fs:8 Fs:8 Fc:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c_BFu8ll, BFs8s_BFu8s_BFu8c_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8c_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8c_BFu8s) C1{ Fs:8 Fs:8 Fc:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8c_BFu8s, BFs8s_BFu8s_BFu8c_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i) C1{ Fs:8 Fs:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i, BFs8s_BFu8s_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8i_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i_BFs8c) C1{ Fs:8 Fs:8 Fi:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i_BFs8c, BFs8s_BFu8s_BFu8i_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8i_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i_BFs8i) C1{ Fs:8 Fs:8 Fi:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i_BFs8i, BFs8s_BFu8s_BFu8i_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8i_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i_BFs8ll) C1{ Fs:8 Fs:8 Fi:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i_BFs8ll, BFs8s_BFu8s_BFu8i_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8i_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i_BFs8s) C1{ Fs:8 Fs:8 Fi:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i_BFs8s, BFs8s_BFu8s_BFu8i_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8i_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i_BFu8c) C1{ Fs:8 Fs:8 Fi:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i_BFu8c, BFs8s_BFu8s_BFu8i_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8i_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i_BFu8i) C1{ Fs:8 Fs:8 Fi:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i_BFu8i, BFs8s_BFu8s_BFu8i_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8i_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i_BFu8ll) C1{ Fs:8 Fs:8 Fi:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i_BFu8ll, BFs8s_BFu8s_BFu8i_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8i_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8i_BFu8s) C1{ Fs:8 Fs:8 Fi:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8i_BFu8s, BFs8s_BFu8s_BFu8i_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll) C1{ Fs:8 Fs:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll, BFs8s_BFu8s_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll_BFs8c) C1{ Fs:8 Fs:8 FL:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll_BFs8c, BFs8s_BFu8s_BFu8ll_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll_BFs8i) C1{ Fs:8 Fs:8 FL:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll_BFs8i, BFs8s_BFu8s_BFu8ll_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll_BFs8ll) C1{ Fs:8 Fs:8 FL:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll_BFs8ll, BFs8s_BFu8s_BFu8ll_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll_BFs8s) C1{ Fs:8 Fs:8 FL:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll_BFs8s, BFs8s_BFu8s_BFu8ll_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll_BFu8c) C1{ Fs:8 Fs:8 FL:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll_BFu8c, BFs8s_BFu8s_BFu8ll_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll_BFu8i) C1{ Fs:8 Fs:8 FL:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll_BFu8i, BFs8s_BFu8s_BFu8ll_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll_BFu8ll) C1{ Fs:8 Fs:8 FL:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll_BFu8ll, BFs8s_BFu8s_BFu8ll_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8ll_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  __tsu64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8ll_BFu8s) C1{ Fs:8 Fs:8 FL:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8ll_BFu8s, BFs8s_BFu8s_BFu8ll_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s) C1{ Fs:8 Fs:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s, BFs8s_BFu8s_BFu8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8s_BFs8c  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  signed char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s_BFs8c) C1{ Fs:8 Fs:8 Fs:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8s_BFs8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s_BFs8c, BFs8s_BFu8s_BFu8s_BFs8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8s_BFs8i  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  signed int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s_BFs8i) C1{ Fs:8 Fs:8 Fs:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s_BFs8i, BFs8s_BFu8s_BFu8s_BFs8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8s_BFs8ll  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s_BFs8ll) C1{ Fs:8 Fs:8 Fs:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s_BFs8ll, BFs8s_BFu8s_BFu8s_BFs8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8s_BFs8s  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  signed short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s_BFs8s) C1{ Fs:8 Fs:8 Fs:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8s_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s_BFs8s, BFs8s_BFu8s_BFu8s_BFs8s)
//============================================================================


struct  BFs8s_BFu8s_BFu8s_BFu8c  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s_BFu8c) C1{ Fs:8 Fs:8 Fs:8 Fc:8}



static void Test_BFs8s_BFu8s_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s_BFu8c, BFs8s_BFu8s_BFu8s_BFu8c)
//============================================================================


struct  BFs8s_BFu8s_BFu8s_BFu8i  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s_BFu8i) C1{ Fs:8 Fs:8 Fs:8 Fi:8}



static void Test_BFs8s_BFu8s_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8s_BFu8s_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s_BFu8i, BFs8s_BFu8s_BFu8s_BFu8i)
//============================================================================


struct  BFs8s_BFu8s_BFu8s_BFu8ll  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s_BFu8ll) C1{ Fs:8 Fs:8 Fs:8 FL:8}



static void Test_BFs8s_BFu8s_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8s_BFu8s_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8s_BFu8s_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s_BFu8ll, BFs8s_BFu8s_BFu8s_BFu8ll)
//============================================================================


struct  BFs8s_BFu8s_BFu8s_BFu8s  {
  signed short v1:8;
  unsigned short v2:8;
  unsigned short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8s_BFu8s_BFu8s_BFu8s) C1{ Fs:8 Fs:8 Fs:8 Fs:8}



static void Test_BFs8s_BFu8s_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8s_BFu8s_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8s_BFu8s_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFu8s_BFu8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8s_BFu8s_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFu8s_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFu8s_BFu8s_BFu8s, BFs8s_BFu8s_BFu8s_BFu8s)
//============================================================================


struct  BFs9i_BFs9i  {
  signed int v1:9;
  signed int v2:9;
};
//SIG(1 BFs9i_BFs9i) C1{ Fi:9 Fi:9}



static void Test_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i, BFs9i_BFs9i)
//============================================================================


struct  BFs9i_BFs9i_BFs9i  {
  signed int v1:9;
  signed int v2:9;
  signed int v3:9;
};
//SIG(1 BFs9i_BFs9i_BFs9i) C1{ Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9i, BFs9i_BFs9i_BFs9i)
//============================================================================


struct  BFs9i_BFs9i_BFs9i_BFs9i  {
  signed int v1:9;
  signed int v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9i_BFs9i) C1{ Fi:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9i_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9i_BFs9i, BFs9i_BFs9i_BFs9i_BFs9i)
//============================================================================


struct  BFs9i_BFs9i_BFs9i_BFs9ll  {
  signed int v1:9;
  signed int v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9i_BFs9ll) C1{ Fi:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9i_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9i_BFs9ll, BFs9i_BFs9i_BFs9i_BFs9ll)
//============================================================================


struct  BFs9i_BFs9i_BFs9i_BFs9s  {
  signed int v1:9;
  signed int v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9i_BFs9s) C1{ Fi:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9i_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9i_BFs9s, BFs9i_BFs9i_BFs9i_BFs9s)
//============================================================================


struct  BFs9i_BFs9i_BFs9i_BFu9i  {
  signed int v1:9;
  signed int v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9i_BFu9i) C1{ Fi:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9i_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9i_BFu9i, BFs9i_BFs9i_BFs9i_BFu9i)
//============================================================================


struct  BFs9i_BFs9i_BFs9i_BFu9ll  {
  signed int v1:9;
  signed int v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9i_BFu9ll) C1{ Fi:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9i_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9i_BFu9ll, BFs9i_BFs9i_BFs9i_BFu9ll)
//============================================================================


struct  BFs9i_BFs9i_BFs9i_BFu9s  {
  signed int v1:9;
  signed int v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9i_BFu9s) C1{ Fi:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9i_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9i_BFu9s, BFs9i_BFs9i_BFs9i_BFu9s)
//============================================================================


struct  BFs9i_BFs9i_BFs9ll  {
  signed int v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9i_BFs9i_BFs9ll) C1{ Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9ll, BFs9i_BFs9i_BFs9ll)
//============================================================================


struct  BFs9i_BFs9i_BFs9ll_BFs9i  {
  signed int v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9ll_BFs9i) C1{ Fi:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9i_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9ll_BFs9i, BFs9i_BFs9i_BFs9ll_BFs9i)
//============================================================================


struct  BFs9i_BFs9i_BFs9ll_BFs9ll  {
  signed int v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9ll_BFs9ll) C1{ Fi:9 Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFs9i_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9ll_BFs9ll, BFs9i_BFs9i_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFs9i_BFs9ll_BFs9s  {
  signed int v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9ll_BFs9s) C1{ Fi:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9i_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9ll_BFs9s, BFs9i_BFs9i_BFs9ll_BFs9s)
//============================================================================


struct  BFs9i_BFs9i_BFs9ll_BFu9i  {
  signed int v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9ll_BFu9i) C1{ Fi:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9i_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9ll_BFu9i, BFs9i_BFs9i_BFs9ll_BFu9i)
//============================================================================


struct  BFs9i_BFs9i_BFs9ll_BFu9ll  {
  signed int v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9ll_BFu9ll) C1{ Fi:9 Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFs9i_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9ll_BFu9ll, BFs9i_BFs9i_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFs9i_BFs9ll_BFu9s  {
  signed int v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9ll_BFu9s) C1{ Fi:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9i_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9ll_BFu9s, BFs9i_BFs9i_BFs9ll_BFu9s)
//============================================================================


struct  BFs9i_BFs9i_BFs9s  {
  signed int v1:9;
  signed int v2:9;
  signed short v3:9;
};
//SIG(1 BFs9i_BFs9i_BFs9s) C1{ Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9s, BFs9i_BFs9i_BFs9s)
//============================================================================


struct  BFs9i_BFs9i_BFs9s_BFs9i  {
  signed int v1:9;
  signed int v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9s_BFs9i) C1{ Fi:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9i_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9s_BFs9i, BFs9i_BFs9i_BFs9s_BFs9i)
//============================================================================


struct  BFs9i_BFs9i_BFs9s_BFs9ll  {
  signed int v1:9;
  signed int v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9s_BFs9ll) C1{ Fi:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9i_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9s_BFs9ll, BFs9i_BFs9i_BFs9s_BFs9ll)
//============================================================================


struct  BFs9i_BFs9i_BFs9s_BFs9s  {
  signed int v1:9;
  signed int v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9s_BFs9s) C1{ Fi:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9i_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9s_BFs9s, BFs9i_BFs9i_BFs9s_BFs9s)
//============================================================================


struct  BFs9i_BFs9i_BFs9s_BFu9i  {
  signed int v1:9;
  signed int v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9s_BFu9i) C1{ Fi:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9i_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9s_BFu9i, BFs9i_BFs9i_BFs9s_BFu9i)
//============================================================================


struct  BFs9i_BFs9i_BFs9s_BFu9ll  {
  signed int v1:9;
  signed int v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9s_BFu9ll) C1{ Fi:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9i_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9s_BFu9ll, BFs9i_BFs9i_BFs9s_BFu9ll)
//============================================================================


struct  BFs9i_BFs9i_BFs9s_BFu9s  {
  signed int v1:9;
  signed int v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFs9s_BFu9s) C1{ Fi:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9i_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFs9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFs9s_BFu9s, BFs9i_BFs9i_BFs9s_BFu9s)
//============================================================================


struct  BFs9i_BFs9i_BFu9i  {
  signed int v1:9;
  signed int v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9i_BFs9i_BFu9i) C1{ Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9i, BFs9i_BFs9i_BFu9i)
//============================================================================


struct  BFs9i_BFs9i_BFu9i_BFs9i  {
  signed int v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9i_BFs9i) C1{ Fi:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9i_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9i_BFs9i, BFs9i_BFs9i_BFu9i_BFs9i)
//============================================================================


struct  BFs9i_BFs9i_BFu9i_BFs9ll  {
  signed int v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9i_BFs9ll) C1{ Fi:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9i_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9i_BFs9ll, BFs9i_BFs9i_BFu9i_BFs9ll)
//============================================================================


struct  BFs9i_BFs9i_BFu9i_BFs9s  {
  signed int v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9i_BFs9s) C1{ Fi:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9i_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9i_BFs9s, BFs9i_BFs9i_BFu9i_BFs9s)
//============================================================================


struct  BFs9i_BFs9i_BFu9i_BFu9i  {
  signed int v1:9;
  signed int v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9i_BFu9i) C1{ Fi:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9i_BFu9i, BFs9i_BFs9i_BFu9i_BFu9i)
//============================================================================


struct  BFs9i_BFs9i_BFu9i_BFu9ll  {
  signed int v1:9;
  signed int v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9i_BFu9ll) C1{ Fi:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9i_BFu9ll, BFs9i_BFs9i_BFu9i_BFu9ll)
//============================================================================


struct  BFs9i_BFs9i_BFu9i_BFu9s  {
  signed int v1:9;
  signed int v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9i_BFu9s) C1{ Fi:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9i_BFu9s, BFs9i_BFs9i_BFu9i_BFu9s)
//============================================================================


struct  BFs9i_BFs9i_BFu9ll  {
  signed int v1:9;
  signed int v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9i_BFs9i_BFu9ll) C1{ Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9ll, BFs9i_BFs9i_BFu9ll)
//============================================================================


struct  BFs9i_BFs9i_BFu9ll_BFs9i  {
  signed int v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9ll_BFs9i) C1{ Fi:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9i_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9ll_BFs9i, BFs9i_BFs9i_BFu9ll_BFs9i)
//============================================================================


struct  BFs9i_BFs9i_BFu9ll_BFs9ll  {
  signed int v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9ll_BFs9ll) C1{ Fi:9 Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFs9i_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9ll_BFs9ll, BFs9i_BFs9i_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFs9i_BFu9ll_BFs9s  {
  signed int v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9ll_BFs9s) C1{ Fi:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9i_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9ll_BFs9s, BFs9i_BFs9i_BFu9ll_BFs9s)
//============================================================================


struct  BFs9i_BFs9i_BFu9ll_BFu9i  {
  signed int v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9ll_BFu9i) C1{ Fi:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9ll_BFu9i, BFs9i_BFs9i_BFu9ll_BFu9i)
//============================================================================


struct  BFs9i_BFs9i_BFu9ll_BFu9ll  {
  signed int v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9ll_BFu9ll) C1{ Fi:9 Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFs9i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9ll_BFu9ll, BFs9i_BFs9i_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFs9i_BFu9ll_BFu9s  {
  signed int v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9ll_BFu9s) C1{ Fi:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9ll_BFu9s, BFs9i_BFs9i_BFu9ll_BFu9s)
//============================================================================


struct  BFs9i_BFs9i_BFu9s  {
  signed int v1:9;
  signed int v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9i_BFs9i_BFu9s) C1{ Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9s, BFs9i_BFs9i_BFu9s)
//============================================================================


struct  BFs9i_BFs9i_BFu9s_BFs9i  {
  signed int v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9s_BFs9i) C1{ Fi:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9i_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9s_BFs9i, BFs9i_BFs9i_BFu9s_BFs9i)
//============================================================================


struct  BFs9i_BFs9i_BFu9s_BFs9ll  {
  signed int v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9s_BFs9ll) C1{ Fi:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9i_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9s_BFs9ll, BFs9i_BFs9i_BFu9s_BFs9ll)
//============================================================================


struct  BFs9i_BFs9i_BFu9s_BFs9s  {
  signed int v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9s_BFs9s) C1{ Fi:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9i_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9s_BFs9s, BFs9i_BFs9i_BFu9s_BFs9s)
//============================================================================


struct  BFs9i_BFs9i_BFu9s_BFu9i  {
  signed int v1:9;
  signed int v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9s_BFu9i) C1{ Fi:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9s_BFu9i, BFs9i_BFs9i_BFu9s_BFu9i)
//============================================================================


struct  BFs9i_BFs9i_BFu9s_BFu9ll  {
  signed int v1:9;
  signed int v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9s_BFu9ll) C1{ Fi:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9s_BFu9ll, BFs9i_BFs9i_BFu9s_BFu9ll)
//============================================================================


struct  BFs9i_BFs9i_BFu9s_BFu9s  {
  signed int v1:9;
  signed int v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9i_BFu9s_BFu9s) C1{ Fi:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9i_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9i_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9i_BFu9s_BFu9s, BFs9i_BFs9i_BFu9s_BFu9s)
//============================================================================


struct  BFs9i_BFs9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
};
//SIG(1 BFs9i_BFs9ll) C1{ Fi:9 FL:9}



static void Test_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll, BFs9i_BFs9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFs9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9i) C1{ Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9i, BFs9i_BFs9ll_BFs9i)
//============================================================================


struct  BFs9i_BFs9ll_BFs9i_BFs9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9i_BFs9i) C1{ Fi:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9i_BFs9i, BFs9i_BFs9ll_BFs9i_BFs9i)
//============================================================================


struct  BFs9i_BFs9ll_BFs9i_BFs9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9i_BFs9ll) C1{ Fi:9 FL:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9ll_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9i_BFs9ll, BFs9i_BFs9ll_BFs9i_BFs9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFs9i_BFs9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9i_BFs9s) C1{ Fi:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9i_BFs9s, BFs9i_BFs9ll_BFs9i_BFs9s)
//============================================================================


struct  BFs9i_BFs9ll_BFs9i_BFu9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9i_BFu9i) C1{ Fi:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9i_BFu9i, BFs9i_BFs9ll_BFs9i_BFu9i)
//============================================================================


struct  BFs9i_BFs9ll_BFs9i_BFu9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9i_BFu9ll) C1{ Fi:9 FL:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9ll_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9i_BFu9ll, BFs9i_BFs9ll_BFs9i_BFu9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFs9i_BFu9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9i_BFu9s) C1{ Fi:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9i_BFu9s, BFs9i_BFs9ll_BFs9i_BFu9s)
//============================================================================


struct  BFs9i_BFs9ll_BFs9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9ll) C1{ Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9ll, BFs9i_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFs9ll_BFs9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9ll_BFs9i) C1{ Fi:9 FL:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9ll_BFs9i, BFs9i_BFs9ll_BFs9ll_BFs9i)
//============================================================================


struct  BFs9i_BFs9ll_BFs9ll_BFs9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9ll_BFs9ll) C1{ Fi:9 FL:9 FL:9 FL:9}



static void Test_BFs9i_BFs9ll_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9ll_BFs9ll, BFs9i_BFs9ll_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFs9ll_BFs9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9ll_BFs9s) C1{ Fi:9 FL:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9ll_BFs9s, BFs9i_BFs9ll_BFs9ll_BFs9s)
//============================================================================


struct  BFs9i_BFs9ll_BFs9ll_BFu9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9ll_BFu9i) C1{ Fi:9 FL:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9ll_BFu9i, BFs9i_BFs9ll_BFs9ll_BFu9i)
//============================================================================


struct  BFs9i_BFs9ll_BFs9ll_BFu9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9ll_BFu9ll) C1{ Fi:9 FL:9 FL:9 FL:9}



static void Test_BFs9i_BFs9ll_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9ll_BFu9ll, BFs9i_BFs9ll_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFs9ll_BFu9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9ll_BFu9s) C1{ Fi:9 FL:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9ll_BFu9s, BFs9i_BFs9ll_BFs9ll_BFu9s)
//============================================================================


struct  BFs9i_BFs9ll_BFs9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9s) C1{ Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9s, BFs9i_BFs9ll_BFs9s)
//============================================================================


struct  BFs9i_BFs9ll_BFs9s_BFs9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9s_BFs9i) C1{ Fi:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9s_BFs9i, BFs9i_BFs9ll_BFs9s_BFs9i)
//============================================================================


struct  BFs9i_BFs9ll_BFs9s_BFs9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9s_BFs9ll) C1{ Fi:9 FL:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9ll_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9s_BFs9ll, BFs9i_BFs9ll_BFs9s_BFs9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFs9s_BFs9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9s_BFs9s) C1{ Fi:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9s_BFs9s, BFs9i_BFs9ll_BFs9s_BFs9s)
//============================================================================


struct  BFs9i_BFs9ll_BFs9s_BFu9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9s_BFu9i) C1{ Fi:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9s_BFu9i, BFs9i_BFs9ll_BFs9s_BFu9i)
//============================================================================


struct  BFs9i_BFs9ll_BFs9s_BFu9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9s_BFu9ll) C1{ Fi:9 FL:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9ll_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9s_BFu9ll, BFs9i_BFs9ll_BFs9s_BFu9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFs9s_BFu9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFs9s_BFu9s) C1{ Fi:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFs9s_BFu9s, BFs9i_BFs9ll_BFs9s_BFu9s)
//============================================================================


struct  BFs9i_BFs9ll_BFu9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9i) C1{ Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9i, BFs9i_BFs9ll_BFu9i)
//============================================================================


struct  BFs9i_BFs9ll_BFu9i_BFs9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9i_BFs9i) C1{ Fi:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9i_BFs9i, BFs9i_BFs9ll_BFu9i_BFs9i)
//============================================================================


struct  BFs9i_BFs9ll_BFu9i_BFs9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9i_BFs9ll) C1{ Fi:9 FL:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9ll_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9i_BFs9ll, BFs9i_BFs9ll_BFu9i_BFs9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFu9i_BFs9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9i_BFs9s) C1{ Fi:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9i_BFs9s, BFs9i_BFs9ll_BFu9i_BFs9s)
//============================================================================


struct  BFs9i_BFs9ll_BFu9i_BFu9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9i_BFu9i) C1{ Fi:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9i_BFu9i, BFs9i_BFs9ll_BFu9i_BFu9i)
//============================================================================


struct  BFs9i_BFs9ll_BFu9i_BFu9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9i_BFu9ll) C1{ Fi:9 FL:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9i_BFu9ll, BFs9i_BFs9ll_BFu9i_BFu9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFu9i_BFu9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9i_BFu9s) C1{ Fi:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9i_BFu9s, BFs9i_BFs9ll_BFu9i_BFu9s)
//============================================================================


struct  BFs9i_BFs9ll_BFu9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9ll) C1{ Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9ll, BFs9i_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFu9ll_BFs9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9ll_BFs9i) C1{ Fi:9 FL:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9ll_BFs9i, BFs9i_BFs9ll_BFu9ll_BFs9i)
//============================================================================


struct  BFs9i_BFs9ll_BFu9ll_BFs9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9ll_BFs9ll) C1{ Fi:9 FL:9 FL:9 FL:9}



static void Test_BFs9i_BFs9ll_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9ll_BFs9ll, BFs9i_BFs9ll_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFu9ll_BFs9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9ll_BFs9s) C1{ Fi:9 FL:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9ll_BFs9s, BFs9i_BFs9ll_BFu9ll_BFs9s)
//============================================================================


struct  BFs9i_BFs9ll_BFu9ll_BFu9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9ll_BFu9i) C1{ Fi:9 FL:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9ll_BFu9i, BFs9i_BFs9ll_BFu9ll_BFu9i)
//============================================================================


struct  BFs9i_BFs9ll_BFu9ll_BFu9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9ll_BFu9ll) C1{ Fi:9 FL:9 FL:9 FL:9}



static void Test_BFs9i_BFs9ll_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9ll_BFu9ll, BFs9i_BFs9ll_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFu9ll_BFu9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9ll_BFu9s) C1{ Fi:9 FL:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9ll_BFu9s, BFs9i_BFs9ll_BFu9ll_BFu9s)
//============================================================================


struct  BFs9i_BFs9ll_BFu9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9s) C1{ Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9s, BFs9i_BFs9ll_BFu9s)
//============================================================================


struct  BFs9i_BFs9ll_BFu9s_BFs9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9s_BFs9i) C1{ Fi:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9s_BFs9i, BFs9i_BFs9ll_BFu9s_BFs9i)
//============================================================================


struct  BFs9i_BFs9ll_BFu9s_BFs9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9s_BFs9ll) C1{ Fi:9 FL:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9ll_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9s_BFs9ll, BFs9i_BFs9ll_BFu9s_BFs9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFu9s_BFs9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9s_BFs9s) C1{ Fi:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9s_BFs9s, BFs9i_BFs9ll_BFu9s_BFs9s)
//============================================================================


struct  BFs9i_BFs9ll_BFu9s_BFu9i  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9s_BFu9i) C1{ Fi:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9ll_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9s_BFu9i, BFs9i_BFs9ll_BFu9s_BFu9i)
//============================================================================


struct  BFs9i_BFs9ll_BFu9s_BFu9ll  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9s_BFu9ll) C1{ Fi:9 FL:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9ll_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9s_BFu9ll, BFs9i_BFs9ll_BFu9s_BFu9ll)
//============================================================================


struct  BFs9i_BFs9ll_BFu9s_BFu9s  {
  signed int v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9ll_BFu9s_BFu9s) C1{ Fi:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9ll_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9ll_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9ll_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9ll_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9ll_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9ll_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9ll_BFu9s_BFu9s, BFs9i_BFs9ll_BFu9s_BFu9s)
//============================================================================


struct  BFs9i_BFs9s  {
  signed int v1:9;
  signed short v2:9;
};
//SIG(1 BFs9i_BFs9s) C1{ Fi:9 Fs:9}



static void Test_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s, BFs9i_BFs9s)
//============================================================================


struct  BFs9i_BFs9s_BFs9i  {
  signed int v1:9;
  signed short v2:9;
  signed int v3:9;
};
//SIG(1 BFs9i_BFs9s_BFs9i) C1{ Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9i, BFs9i_BFs9s_BFs9i)
//============================================================================


struct  BFs9i_BFs9s_BFs9i_BFs9i  {
  signed int v1:9;
  signed short v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9i_BFs9i) C1{ Fi:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9s_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9i_BFs9i, BFs9i_BFs9s_BFs9i_BFs9i)
//============================================================================


struct  BFs9i_BFs9s_BFs9i_BFs9ll  {
  signed int v1:9;
  signed short v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9i_BFs9ll) C1{ Fi:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9s_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9i_BFs9ll, BFs9i_BFs9s_BFs9i_BFs9ll)
//============================================================================


struct  BFs9i_BFs9s_BFs9i_BFs9s  {
  signed int v1:9;
  signed short v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9i_BFs9s) C1{ Fi:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9s_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9i_BFs9s, BFs9i_BFs9s_BFs9i_BFs9s)
//============================================================================


struct  BFs9i_BFs9s_BFs9i_BFu9i  {
  signed int v1:9;
  signed short v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9i_BFu9i) C1{ Fi:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9s_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9i_BFu9i, BFs9i_BFs9s_BFs9i_BFu9i)
//============================================================================


struct  BFs9i_BFs9s_BFs9i_BFu9ll  {
  signed int v1:9;
  signed short v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9i_BFu9ll) C1{ Fi:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9s_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9i_BFu9ll, BFs9i_BFs9s_BFs9i_BFu9ll)
//============================================================================


struct  BFs9i_BFs9s_BFs9i_BFu9s  {
  signed int v1:9;
  signed short v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9i_BFu9s) C1{ Fi:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9s_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9i_BFu9s, BFs9i_BFs9s_BFs9i_BFu9s)
//============================================================================


struct  BFs9i_BFs9s_BFs9ll  {
  signed int v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9i_BFs9s_BFs9ll) C1{ Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9ll, BFs9i_BFs9s_BFs9ll)
//============================================================================


struct  BFs9i_BFs9s_BFs9ll_BFs9i  {
  signed int v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9ll_BFs9i) C1{ Fi:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9s_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9ll_BFs9i, BFs9i_BFs9s_BFs9ll_BFs9i)
//============================================================================


struct  BFs9i_BFs9s_BFs9ll_BFs9ll  {
  signed int v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9ll_BFs9ll) C1{ Fi:9 Fs:9 FL:9 FL:9}



static void Test_BFs9i_BFs9s_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9ll_BFs9ll, BFs9i_BFs9s_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFs9s_BFs9ll_BFs9s  {
  signed int v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9ll_BFs9s) C1{ Fi:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9s_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9ll_BFs9s, BFs9i_BFs9s_BFs9ll_BFs9s)
//============================================================================


struct  BFs9i_BFs9s_BFs9ll_BFu9i  {
  signed int v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9ll_BFu9i) C1{ Fi:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9s_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9ll_BFu9i, BFs9i_BFs9s_BFs9ll_BFu9i)
//============================================================================


struct  BFs9i_BFs9s_BFs9ll_BFu9ll  {
  signed int v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9ll_BFu9ll) C1{ Fi:9 Fs:9 FL:9 FL:9}



static void Test_BFs9i_BFs9s_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9ll_BFu9ll, BFs9i_BFs9s_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFs9s_BFs9ll_BFu9s  {
  signed int v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9ll_BFu9s) C1{ Fi:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9s_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9ll_BFu9s, BFs9i_BFs9s_BFs9ll_BFu9s)
//============================================================================


struct  BFs9i_BFs9s_BFs9s  {
  signed int v1:9;
  signed short v2:9;
  signed short v3:9;
};
//SIG(1 BFs9i_BFs9s_BFs9s) C1{ Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9s, BFs9i_BFs9s_BFs9s)
//============================================================================


struct  BFs9i_BFs9s_BFs9s_BFs9i  {
  signed int v1:9;
  signed short v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9s_BFs9i) C1{ Fi:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9s_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9s_BFs9i, BFs9i_BFs9s_BFs9s_BFs9i)
//============================================================================


struct  BFs9i_BFs9s_BFs9s_BFs9ll  {
  signed int v1:9;
  signed short v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9s_BFs9ll) C1{ Fi:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9s_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9s_BFs9ll, BFs9i_BFs9s_BFs9s_BFs9ll)
//============================================================================


struct  BFs9i_BFs9s_BFs9s_BFs9s  {
  signed int v1:9;
  signed short v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9s_BFs9s) C1{ Fi:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9s_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9s_BFs9s, BFs9i_BFs9s_BFs9s_BFs9s)
//============================================================================


struct  BFs9i_BFs9s_BFs9s_BFu9i  {
  signed int v1:9;
  signed short v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9s_BFu9i) C1{ Fi:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9s_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9s_BFu9i, BFs9i_BFs9s_BFs9s_BFu9i)
//============================================================================


struct  BFs9i_BFs9s_BFs9s_BFu9ll  {
  signed int v1:9;
  signed short v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9s_BFu9ll) C1{ Fi:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9s_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9s_BFu9ll, BFs9i_BFs9s_BFs9s_BFu9ll)
//============================================================================


struct  BFs9i_BFs9s_BFs9s_BFu9s  {
  signed int v1:9;
  signed short v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFs9s_BFu9s) C1{ Fi:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9s_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFs9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFs9s_BFu9s, BFs9i_BFs9s_BFs9s_BFu9s)
//============================================================================


struct  BFs9i_BFs9s_BFu9i  {
  signed int v1:9;
  signed short v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9i_BFs9s_BFu9i) C1{ Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9i, BFs9i_BFs9s_BFu9i)
//============================================================================


struct  BFs9i_BFs9s_BFu9i_BFs9i  {
  signed int v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9i_BFs9i) C1{ Fi:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9s_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9i_BFs9i, BFs9i_BFs9s_BFu9i_BFs9i)
//============================================================================


struct  BFs9i_BFs9s_BFu9i_BFs9ll  {
  signed int v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9i_BFs9ll) C1{ Fi:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9s_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9i_BFs9ll, BFs9i_BFs9s_BFu9i_BFs9ll)
//============================================================================


struct  BFs9i_BFs9s_BFu9i_BFs9s  {
  signed int v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9i_BFs9s) C1{ Fi:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9s_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9i_BFs9s, BFs9i_BFs9s_BFu9i_BFs9s)
//============================================================================


struct  BFs9i_BFs9s_BFu9i_BFu9i  {
  signed int v1:9;
  signed short v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9i_BFu9i) C1{ Fi:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9i_BFs9s_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9i_BFu9i, BFs9i_BFs9s_BFu9i_BFu9i)
//============================================================================


struct  BFs9i_BFs9s_BFu9i_BFu9ll  {
  signed int v1:9;
  signed short v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9i_BFu9ll) C1{ Fi:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9i_BFs9s_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9i_BFu9ll, BFs9i_BFs9s_BFu9i_BFu9ll)
//============================================================================


struct  BFs9i_BFs9s_BFu9i_BFu9s  {
  signed int v1:9;
  signed short v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9i_BFu9s) C1{ Fi:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9i_BFs9s_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9i_BFu9s, BFs9i_BFs9s_BFu9i_BFu9s)
//============================================================================


struct  BFs9i_BFs9s_BFu9ll  {
  signed int v1:9;
  signed short v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9i_BFs9s_BFu9ll) C1{ Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9ll, BFs9i_BFs9s_BFu9ll)
//============================================================================


struct  BFs9i_BFs9s_BFu9ll_BFs9i  {
  signed int v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9ll_BFs9i) C1{ Fi:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9s_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9ll_BFs9i, BFs9i_BFs9s_BFu9ll_BFs9i)
//============================================================================


struct  BFs9i_BFs9s_BFu9ll_BFs9ll  {
  signed int v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9ll_BFs9ll) C1{ Fi:9 Fs:9 FL:9 FL:9}



static void Test_BFs9i_BFs9s_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9ll_BFs9ll, BFs9i_BFs9s_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFs9s_BFu9ll_BFs9s  {
  signed int v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9ll_BFs9s) C1{ Fi:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9s_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9ll_BFs9s, BFs9i_BFs9s_BFu9ll_BFs9s)
//============================================================================


struct  BFs9i_BFs9s_BFu9ll_BFu9i  {
  signed int v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9ll_BFu9i) C1{ Fi:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9i_BFs9s_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9ll_BFu9i, BFs9i_BFs9s_BFu9ll_BFu9i)
//============================================================================


struct  BFs9i_BFs9s_BFu9ll_BFu9ll  {
  signed int v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9ll_BFu9ll) C1{ Fi:9 Fs:9 FL:9 FL:9}



static void Test_BFs9i_BFs9s_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9ll_BFu9ll, BFs9i_BFs9s_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFs9s_BFu9ll_BFu9s  {
  signed int v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9ll_BFu9s) C1{ Fi:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9i_BFs9s_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9ll_BFu9s, BFs9i_BFs9s_BFu9ll_BFu9s)
//============================================================================


struct  BFs9i_BFs9s_BFu9s  {
  signed int v1:9;
  signed short v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9i_BFs9s_BFu9s) C1{ Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9s, BFs9i_BFs9s_BFu9s)
//============================================================================


struct  BFs9i_BFs9s_BFu9s_BFs9i  {
  signed int v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9s_BFs9i) C1{ Fi:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9s_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9s_BFs9i, BFs9i_BFs9s_BFu9s_BFs9i)
//============================================================================


struct  BFs9i_BFs9s_BFu9s_BFs9ll  {
  signed int v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9s_BFs9ll) C1{ Fi:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9s_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9s_BFs9ll, BFs9i_BFs9s_BFu9s_BFs9ll)
//============================================================================


struct  BFs9i_BFs9s_BFu9s_BFs9s  {
  signed int v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9s_BFs9s) C1{ Fi:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9s_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9s_BFs9s, BFs9i_BFs9s_BFu9s_BFs9s)
//============================================================================


struct  BFs9i_BFs9s_BFu9s_BFu9i  {
  signed int v1:9;
  signed short v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9s_BFu9i) C1{ Fi:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9i_BFs9s_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9s_BFu9i, BFs9i_BFs9s_BFu9s_BFu9i)
//============================================================================


struct  BFs9i_BFs9s_BFu9s_BFu9ll  {
  signed int v1:9;
  signed short v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9s_BFu9ll) C1{ Fi:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9i_BFs9s_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFs9s_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9s_BFu9ll, BFs9i_BFs9s_BFu9s_BFu9ll)
//============================================================================


struct  BFs9i_BFs9s_BFu9s_BFu9s  {
  signed int v1:9;
  signed short v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFs9s_BFu9s_BFu9s) C1{ Fi:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9i_BFs9s_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFs9s_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFs9s_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFs9s_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFs9s_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9i_BFs9s_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFs9s_BFu9s_BFu9s, BFs9i_BFs9s_BFu9s_BFu9s)
//============================================================================


struct  BFs9i_BFu9i  {
  signed int v1:9;
  unsigned int v2:9;
};
//SIG(1 BFs9i_BFu9i) C1{ Fi:9 Fi:9}



static void Test_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i, BFs9i_BFu9i)
//============================================================================


struct  BFs9i_BFu9i_BFs9i  {
  signed int v1:9;
  unsigned int v2:9;
  signed int v3:9;
};
//SIG(1 BFs9i_BFu9i_BFs9i) C1{ Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9i, BFs9i_BFu9i_BFs9i)
//============================================================================


struct  BFs9i_BFu9i_BFs9i_BFs9i  {
  signed int v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9i_BFs9i) C1{ Fi:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9i_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9i_BFs9i, BFs9i_BFu9i_BFs9i_BFs9i)
//============================================================================


struct  BFs9i_BFu9i_BFs9i_BFs9ll  {
  signed int v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9i_BFs9ll) C1{ Fi:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9i_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9i_BFs9ll, BFs9i_BFu9i_BFs9i_BFs9ll)
//============================================================================


struct  BFs9i_BFu9i_BFs9i_BFs9s  {
  signed int v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9i_BFs9s) C1{ Fi:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9i_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9i_BFs9s, BFs9i_BFu9i_BFs9i_BFs9s)
//============================================================================


struct  BFs9i_BFu9i_BFs9i_BFu9i  {
  signed int v1:9;
  unsigned int v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9i_BFu9i) C1{ Fi:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9i_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9i_BFu9i, BFs9i_BFu9i_BFs9i_BFu9i)
//============================================================================


struct  BFs9i_BFu9i_BFs9i_BFu9ll  {
  signed int v1:9;
  unsigned int v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9i_BFu9ll) C1{ Fi:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9i_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9i_BFu9ll, BFs9i_BFu9i_BFs9i_BFu9ll)
//============================================================================


struct  BFs9i_BFu9i_BFs9i_BFu9s  {
  signed int v1:9;
  unsigned int v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9i_BFu9s) C1{ Fi:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9i_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9i_BFu9s, BFs9i_BFu9i_BFs9i_BFu9s)
//============================================================================


struct  BFs9i_BFu9i_BFs9ll  {
  signed int v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9i_BFu9i_BFs9ll) C1{ Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9ll, BFs9i_BFu9i_BFs9ll)
//============================================================================


struct  BFs9i_BFu9i_BFs9ll_BFs9i  {
  signed int v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9ll_BFs9i) C1{ Fi:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9i_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9ll_BFs9i, BFs9i_BFu9i_BFs9ll_BFs9i)
//============================================================================


struct  BFs9i_BFu9i_BFs9ll_BFs9ll  {
  signed int v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9ll_BFs9ll) C1{ Fi:9 Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFu9i_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9ll_BFs9ll, BFs9i_BFu9i_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFu9i_BFs9ll_BFs9s  {
  signed int v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9ll_BFs9s) C1{ Fi:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9i_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9ll_BFs9s, BFs9i_BFu9i_BFs9ll_BFs9s)
//============================================================================


struct  BFs9i_BFu9i_BFs9ll_BFu9i  {
  signed int v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9ll_BFu9i) C1{ Fi:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9i_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9ll_BFu9i, BFs9i_BFu9i_BFs9ll_BFu9i)
//============================================================================


struct  BFs9i_BFu9i_BFs9ll_BFu9ll  {
  signed int v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9ll_BFu9ll) C1{ Fi:9 Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFu9i_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9ll_BFu9ll, BFs9i_BFu9i_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFu9i_BFs9ll_BFu9s  {
  signed int v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9ll_BFu9s) C1{ Fi:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9i_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9ll_BFu9s, BFs9i_BFu9i_BFs9ll_BFu9s)
//============================================================================


struct  BFs9i_BFu9i_BFs9s  {
  signed int v1:9;
  unsigned int v2:9;
  signed short v3:9;
};
//SIG(1 BFs9i_BFu9i_BFs9s) C1{ Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9s, BFs9i_BFu9i_BFs9s)
//============================================================================


struct  BFs9i_BFu9i_BFs9s_BFs9i  {
  signed int v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9s_BFs9i) C1{ Fi:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9i_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9s_BFs9i, BFs9i_BFu9i_BFs9s_BFs9i)
//============================================================================


struct  BFs9i_BFu9i_BFs9s_BFs9ll  {
  signed int v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9s_BFs9ll) C1{ Fi:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9i_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9s_BFs9ll, BFs9i_BFu9i_BFs9s_BFs9ll)
//============================================================================


struct  BFs9i_BFu9i_BFs9s_BFs9s  {
  signed int v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9s_BFs9s) C1{ Fi:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9i_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9s_BFs9s, BFs9i_BFu9i_BFs9s_BFs9s)
//============================================================================


struct  BFs9i_BFu9i_BFs9s_BFu9i  {
  signed int v1:9;
  unsigned int v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9s_BFu9i) C1{ Fi:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9i_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9s_BFu9i, BFs9i_BFu9i_BFs9s_BFu9i)
//============================================================================


struct  BFs9i_BFu9i_BFs9s_BFu9ll  {
  signed int v1:9;
  unsigned int v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9s_BFu9ll) C1{ Fi:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9i_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9s_BFu9ll, BFs9i_BFu9i_BFs9s_BFu9ll)
//============================================================================


struct  BFs9i_BFu9i_BFs9s_BFu9s  {
  signed int v1:9;
  unsigned int v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFs9s_BFu9s) C1{ Fi:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9i_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFs9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFs9s_BFu9s, BFs9i_BFu9i_BFs9s_BFu9s)
//============================================================================


struct  BFs9i_BFu9i_BFu9i  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9i_BFu9i_BFu9i) C1{ Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9i, BFs9i_BFu9i_BFu9i)
//============================================================================


struct  BFs9i_BFu9i_BFu9i_BFs9i  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9i_BFs9i) C1{ Fi:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9i_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9i_BFs9i, BFs9i_BFu9i_BFu9i_BFs9i)
//============================================================================


struct  BFs9i_BFu9i_BFu9i_BFs9ll  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9i_BFs9ll) C1{ Fi:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9i_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9i_BFs9ll, BFs9i_BFu9i_BFu9i_BFs9ll)
//============================================================================


struct  BFs9i_BFu9i_BFu9i_BFs9s  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9i_BFs9s) C1{ Fi:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9i_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9i_BFs9s, BFs9i_BFu9i_BFu9i_BFs9s)
//============================================================================


struct  BFs9i_BFu9i_BFu9i_BFu9i  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9i_BFu9i) C1{ Fi:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9i_BFu9i, BFs9i_BFu9i_BFu9i_BFu9i)
//============================================================================


struct  BFs9i_BFu9i_BFu9i_BFu9ll  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9i_BFu9ll) C1{ Fi:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9i_BFu9ll, BFs9i_BFu9i_BFu9i_BFu9ll)
//============================================================================


struct  BFs9i_BFu9i_BFu9i_BFu9s  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9i_BFu9s) C1{ Fi:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9i_BFu9s, BFs9i_BFu9i_BFu9i_BFu9s)
//============================================================================


struct  BFs9i_BFu9i_BFu9ll  {
  signed int v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9i_BFu9i_BFu9ll) C1{ Fi:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9ll, BFs9i_BFu9i_BFu9ll)
//============================================================================


struct  BFs9i_BFu9i_BFu9ll_BFs9i  {
  signed int v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9ll_BFs9i) C1{ Fi:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9i_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9ll_BFs9i, BFs9i_BFu9i_BFu9ll_BFs9i)
//============================================================================


struct  BFs9i_BFu9i_BFu9ll_BFs9ll  {
  signed int v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9ll_BFs9ll) C1{ Fi:9 Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFu9i_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9ll_BFs9ll, BFs9i_BFu9i_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFu9i_BFu9ll_BFs9s  {
  signed int v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9ll_BFs9s) C1{ Fi:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9i_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9ll_BFs9s, BFs9i_BFu9i_BFu9ll_BFs9s)
//============================================================================


struct  BFs9i_BFu9i_BFu9ll_BFu9i  {
  signed int v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9ll_BFu9i) C1{ Fi:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9ll_BFu9i, BFs9i_BFu9i_BFu9ll_BFu9i)
//============================================================================


struct  BFs9i_BFu9i_BFu9ll_BFu9ll  {
  signed int v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9ll_BFu9ll) C1{ Fi:9 Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFu9i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9ll_BFu9ll, BFs9i_BFu9i_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFu9i_BFu9ll_BFu9s  {
  signed int v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9ll_BFu9s) C1{ Fi:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9ll_BFu9s, BFs9i_BFu9i_BFu9ll_BFu9s)
//============================================================================


struct  BFs9i_BFu9i_BFu9s  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9i_BFu9i_BFu9s) C1{ Fi:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9s, BFs9i_BFu9i_BFu9s)
//============================================================================


struct  BFs9i_BFu9i_BFu9s_BFs9i  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9s_BFs9i) C1{ Fi:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9i_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9s_BFs9i, BFs9i_BFu9i_BFu9s_BFs9i)
//============================================================================


struct  BFs9i_BFu9i_BFu9s_BFs9ll  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9s_BFs9ll) C1{ Fi:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9i_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9s_BFs9ll, BFs9i_BFu9i_BFu9s_BFs9ll)
//============================================================================


struct  BFs9i_BFu9i_BFu9s_BFs9s  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9s_BFs9s) C1{ Fi:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9i_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9s_BFs9s, BFs9i_BFu9i_BFu9s_BFs9s)
//============================================================================


struct  BFs9i_BFu9i_BFu9s_BFu9i  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9s_BFu9i) C1{ Fi:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9s_BFu9i, BFs9i_BFu9i_BFu9s_BFu9i)
//============================================================================


struct  BFs9i_BFu9i_BFu9s_BFu9ll  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9s_BFu9ll) C1{ Fi:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9s_BFu9ll, BFs9i_BFu9i_BFu9s_BFu9ll)
//============================================================================


struct  BFs9i_BFu9i_BFu9s_BFu9s  {
  signed int v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9i_BFu9s_BFu9s) C1{ Fi:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9i_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9i_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9i_BFu9s_BFu9s, BFs9i_BFu9i_BFu9s_BFu9s)
//============================================================================


struct  BFs9i_BFu9ll  {
  signed int v1:9;
  __tsu64 v2:9;
};
//SIG(1 BFs9i_BFu9ll) C1{ Fi:9 FL:9}



static void Test_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll, BFs9i_BFu9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFs9i  {
  signed int v1:9;
  __tsu64 v2:9;
  signed int v3:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9i) C1{ Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9i, BFs9i_BFu9ll_BFs9i)
//============================================================================


struct  BFs9i_BFu9ll_BFs9i_BFs9i  {
  signed int v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9i_BFs9i) C1{ Fi:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9i_BFs9i, BFs9i_BFu9ll_BFs9i_BFs9i)
//============================================================================


struct  BFs9i_BFu9ll_BFs9i_BFs9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9i_BFs9ll) C1{ Fi:9 FL:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9ll_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9i_BFs9ll, BFs9i_BFu9ll_BFs9i_BFs9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFs9i_BFs9s  {
  signed int v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9i_BFs9s) C1{ Fi:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9i_BFs9s, BFs9i_BFu9ll_BFs9i_BFs9s)
//============================================================================


struct  BFs9i_BFu9ll_BFs9i_BFu9i  {
  signed int v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9i_BFu9i) C1{ Fi:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9i_BFu9i, BFs9i_BFu9ll_BFs9i_BFu9i)
//============================================================================


struct  BFs9i_BFu9ll_BFs9i_BFu9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9i_BFu9ll) C1{ Fi:9 FL:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9ll_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9i_BFu9ll, BFs9i_BFu9ll_BFs9i_BFu9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFs9i_BFu9s  {
  signed int v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9i_BFu9s) C1{ Fi:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9i_BFu9s, BFs9i_BFu9ll_BFs9i_BFu9s)
//============================================================================


struct  BFs9i_BFu9ll_BFs9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9ll) C1{ Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9ll, BFs9i_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFs9ll_BFs9i  {
  signed int v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9ll_BFs9i) C1{ Fi:9 FL:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9ll_BFs9i, BFs9i_BFu9ll_BFs9ll_BFs9i)
//============================================================================


struct  BFs9i_BFu9ll_BFs9ll_BFs9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9ll_BFs9ll) C1{ Fi:9 FL:9 FL:9 FL:9}



static void Test_BFs9i_BFu9ll_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9ll_BFs9ll, BFs9i_BFu9ll_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFs9ll_BFs9s  {
  signed int v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9ll_BFs9s) C1{ Fi:9 FL:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9ll_BFs9s, BFs9i_BFu9ll_BFs9ll_BFs9s)
//============================================================================


struct  BFs9i_BFu9ll_BFs9ll_BFu9i  {
  signed int v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9ll_BFu9i) C1{ Fi:9 FL:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9ll_BFu9i, BFs9i_BFu9ll_BFs9ll_BFu9i)
//============================================================================


struct  BFs9i_BFu9ll_BFs9ll_BFu9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9ll_BFu9ll) C1{ Fi:9 FL:9 FL:9 FL:9}



static void Test_BFs9i_BFu9ll_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9ll_BFu9ll, BFs9i_BFu9ll_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFs9ll_BFu9s  {
  signed int v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9ll_BFu9s) C1{ Fi:9 FL:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9ll_BFu9s, BFs9i_BFu9ll_BFs9ll_BFu9s)
//============================================================================


struct  BFs9i_BFu9ll_BFs9s  {
  signed int v1:9;
  __tsu64 v2:9;
  signed short v3:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9s) C1{ Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9s, BFs9i_BFu9ll_BFs9s)
//============================================================================


struct  BFs9i_BFu9ll_BFs9s_BFs9i  {
  signed int v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9s_BFs9i) C1{ Fi:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9s_BFs9i, BFs9i_BFu9ll_BFs9s_BFs9i)
//============================================================================


struct  BFs9i_BFu9ll_BFs9s_BFs9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9s_BFs9ll) C1{ Fi:9 FL:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9ll_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9s_BFs9ll, BFs9i_BFu9ll_BFs9s_BFs9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFs9s_BFs9s  {
  signed int v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9s_BFs9s) C1{ Fi:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9s_BFs9s, BFs9i_BFu9ll_BFs9s_BFs9s)
//============================================================================


struct  BFs9i_BFu9ll_BFs9s_BFu9i  {
  signed int v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9s_BFu9i) C1{ Fi:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9s_BFu9i, BFs9i_BFu9ll_BFs9s_BFu9i)
//============================================================================


struct  BFs9i_BFu9ll_BFs9s_BFu9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9s_BFu9ll) C1{ Fi:9 FL:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9ll_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9s_BFu9ll, BFs9i_BFu9ll_BFs9s_BFu9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFs9s_BFu9s  {
  signed int v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFs9s_BFu9s) C1{ Fi:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFs9s_BFu9s, BFs9i_BFu9ll_BFs9s_BFu9s)
//============================================================================


struct  BFs9i_BFu9ll_BFu9i  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9i) C1{ Fi:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9i, BFs9i_BFu9ll_BFu9i)
//============================================================================


struct  BFs9i_BFu9ll_BFu9i_BFs9i  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9i_BFs9i) C1{ Fi:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9i_BFs9i, BFs9i_BFu9ll_BFu9i_BFs9i)
//============================================================================


struct  BFs9i_BFu9ll_BFu9i_BFs9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9i_BFs9ll) C1{ Fi:9 FL:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9ll_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9i_BFs9ll, BFs9i_BFu9ll_BFu9i_BFs9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFu9i_BFs9s  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9i_BFs9s) C1{ Fi:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9i_BFs9s, BFs9i_BFu9ll_BFu9i_BFs9s)
//============================================================================


struct  BFs9i_BFu9ll_BFu9i_BFu9i  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9i_BFu9i) C1{ Fi:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9i_BFu9i, BFs9i_BFu9ll_BFu9i_BFu9i)
//============================================================================


struct  BFs9i_BFu9ll_BFu9i_BFu9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9i_BFu9ll) C1{ Fi:9 FL:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9i_BFu9ll, BFs9i_BFu9ll_BFu9i_BFu9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFu9i_BFu9s  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9i_BFu9s) C1{ Fi:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9i_BFu9s, BFs9i_BFu9ll_BFu9i_BFu9s)
//============================================================================


struct  BFs9i_BFu9ll_BFu9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9ll) C1{ Fi:9 FL:9 FL:9}



static void Test_BFs9i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9ll, BFs9i_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFu9ll_BFs9i  {
  signed int v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9ll_BFs9i) C1{ Fi:9 FL:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9ll_BFs9i, BFs9i_BFu9ll_BFu9ll_BFs9i)
//============================================================================


struct  BFs9i_BFu9ll_BFu9ll_BFs9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9ll_BFs9ll) C1{ Fi:9 FL:9 FL:9 FL:9}



static void Test_BFs9i_BFu9ll_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9ll_BFs9ll, BFs9i_BFu9ll_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFu9ll_BFs9s  {
  signed int v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9ll_BFs9s) C1{ Fi:9 FL:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9ll_BFs9s, BFs9i_BFu9ll_BFu9ll_BFs9s)
//============================================================================


struct  BFs9i_BFu9ll_BFu9ll_BFu9i  {
  signed int v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9ll_BFu9i) C1{ Fi:9 FL:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9ll_BFu9i, BFs9i_BFu9ll_BFu9ll_BFu9i)
//============================================================================


struct  BFs9i_BFu9ll_BFu9ll_BFu9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9ll_BFu9ll) C1{ Fi:9 FL:9 FL:9 FL:9}



static void Test_BFs9i_BFu9ll_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9ll_BFu9ll, BFs9i_BFu9ll_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFu9ll_BFu9s  {
  signed int v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9ll_BFu9s) C1{ Fi:9 FL:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9ll_BFu9s, BFs9i_BFu9ll_BFu9ll_BFu9s)
//============================================================================


struct  BFs9i_BFu9ll_BFu9s  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9s) C1{ Fi:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9s, BFs9i_BFu9ll_BFu9s)
//============================================================================


struct  BFs9i_BFu9ll_BFu9s_BFs9i  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9s_BFs9i) C1{ Fi:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9s_BFs9i, BFs9i_BFu9ll_BFu9s_BFs9i)
//============================================================================


struct  BFs9i_BFu9ll_BFu9s_BFs9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9s_BFs9ll) C1{ Fi:9 FL:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9ll_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9s_BFs9ll, BFs9i_BFu9ll_BFu9s_BFs9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFu9s_BFs9s  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9s_BFs9s) C1{ Fi:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9s_BFs9s, BFs9i_BFu9ll_BFu9s_BFs9s)
//============================================================================


struct  BFs9i_BFu9ll_BFu9s_BFu9i  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9s_BFu9i) C1{ Fi:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9ll_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9s_BFu9i, BFs9i_BFu9ll_BFu9s_BFu9i)
//============================================================================


struct  BFs9i_BFu9ll_BFu9s_BFu9ll  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9s_BFu9ll) C1{ Fi:9 FL:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9ll_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9s_BFu9ll, BFs9i_BFu9ll_BFu9s_BFu9ll)
//============================================================================


struct  BFs9i_BFu9ll_BFu9s_BFu9s  {
  signed int v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9ll_BFu9s_BFu9s) C1{ Fi:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9ll_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9ll_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9ll_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9ll_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9ll_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9i_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9ll_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9ll_BFu9s_BFu9s, BFs9i_BFu9ll_BFu9s_BFu9s)
//============================================================================


struct  BFs9i_BFu9s  {
  signed int v1:9;
  unsigned short v2:9;
};
//SIG(1 BFs9i_BFu9s) C1{ Fi:9 Fs:9}



static void Test_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s, BFs9i_BFu9s)
//============================================================================


struct  BFs9i_BFu9s_BFs9i  {
  signed int v1:9;
  unsigned short v2:9;
  signed int v3:9;
};
//SIG(1 BFs9i_BFu9s_BFs9i) C1{ Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9i, BFs9i_BFu9s_BFs9i)
//============================================================================


struct  BFs9i_BFu9s_BFs9i_BFs9i  {
  signed int v1:9;
  unsigned short v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9i_BFs9i) C1{ Fi:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9s_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9i_BFs9i, BFs9i_BFu9s_BFs9i_BFs9i)
//============================================================================


struct  BFs9i_BFu9s_BFs9i_BFs9ll  {
  signed int v1:9;
  unsigned short v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9i_BFs9ll) C1{ Fi:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9s_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9i_BFs9ll, BFs9i_BFu9s_BFs9i_BFs9ll)
//============================================================================


struct  BFs9i_BFu9s_BFs9i_BFs9s  {
  signed int v1:9;
  unsigned short v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9i_BFs9s) C1{ Fi:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9s_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9i_BFs9s, BFs9i_BFu9s_BFs9i_BFs9s)
//============================================================================


struct  BFs9i_BFu9s_BFs9i_BFu9i  {
  signed int v1:9;
  unsigned short v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9i_BFu9i) C1{ Fi:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9s_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9i_BFu9i, BFs9i_BFu9s_BFs9i_BFu9i)
//============================================================================


struct  BFs9i_BFu9s_BFs9i_BFu9ll  {
  signed int v1:9;
  unsigned short v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9i_BFu9ll) C1{ Fi:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9s_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9i_BFu9ll, BFs9i_BFu9s_BFs9i_BFu9ll)
//============================================================================


struct  BFs9i_BFu9s_BFs9i_BFu9s  {
  signed int v1:9;
  unsigned short v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9i_BFu9s) C1{ Fi:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9s_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9i_BFu9s, BFs9i_BFu9s_BFs9i_BFu9s)
//============================================================================


struct  BFs9i_BFu9s_BFs9ll  {
  signed int v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9i_BFu9s_BFs9ll) C1{ Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9ll, BFs9i_BFu9s_BFs9ll)
//============================================================================


struct  BFs9i_BFu9s_BFs9ll_BFs9i  {
  signed int v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9ll_BFs9i) C1{ Fi:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9s_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9ll_BFs9i, BFs9i_BFu9s_BFs9ll_BFs9i)
//============================================================================


struct  BFs9i_BFu9s_BFs9ll_BFs9ll  {
  signed int v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9ll_BFs9ll) C1{ Fi:9 Fs:9 FL:9 FL:9}



static void Test_BFs9i_BFu9s_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9ll_BFs9ll, BFs9i_BFu9s_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFu9s_BFs9ll_BFs9s  {
  signed int v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9ll_BFs9s) C1{ Fi:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9s_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9ll_BFs9s, BFs9i_BFu9s_BFs9ll_BFs9s)
//============================================================================


struct  BFs9i_BFu9s_BFs9ll_BFu9i  {
  signed int v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9ll_BFu9i) C1{ Fi:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9s_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9ll_BFu9i, BFs9i_BFu9s_BFs9ll_BFu9i)
//============================================================================


struct  BFs9i_BFu9s_BFs9ll_BFu9ll  {
  signed int v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9ll_BFu9ll) C1{ Fi:9 Fs:9 FL:9 FL:9}



static void Test_BFs9i_BFu9s_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9ll_BFu9ll, BFs9i_BFu9s_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFu9s_BFs9ll_BFu9s  {
  signed int v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9ll_BFu9s) C1{ Fi:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9s_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9ll_BFu9s, BFs9i_BFu9s_BFs9ll_BFu9s)
//============================================================================


struct  BFs9i_BFu9s_BFs9s  {
  signed int v1:9;
  unsigned short v2:9;
  signed short v3:9;
};
//SIG(1 BFs9i_BFu9s_BFs9s) C1{ Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9s, BFs9i_BFu9s_BFs9s)
//============================================================================


struct  BFs9i_BFu9s_BFs9s_BFs9i  {
  signed int v1:9;
  unsigned short v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9s_BFs9i) C1{ Fi:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9s_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9s_BFs9i, BFs9i_BFu9s_BFs9s_BFs9i)
//============================================================================


struct  BFs9i_BFu9s_BFs9s_BFs9ll  {
  signed int v1:9;
  unsigned short v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9s_BFs9ll) C1{ Fi:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9s_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9s_BFs9ll, BFs9i_BFu9s_BFs9s_BFs9ll)
//============================================================================


struct  BFs9i_BFu9s_BFs9s_BFs9s  {
  signed int v1:9;
  unsigned short v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9s_BFs9s) C1{ Fi:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9s_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9s_BFs9s, BFs9i_BFu9s_BFs9s_BFs9s)
//============================================================================


struct  BFs9i_BFu9s_BFs9s_BFu9i  {
  signed int v1:9;
  unsigned short v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9s_BFu9i) C1{ Fi:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9s_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9s_BFu9i, BFs9i_BFu9s_BFs9s_BFu9i)
//============================================================================


struct  BFs9i_BFu9s_BFs9s_BFu9ll  {
  signed int v1:9;
  unsigned short v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9s_BFu9ll) C1{ Fi:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9s_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9s_BFu9ll, BFs9i_BFu9s_BFs9s_BFu9ll)
//============================================================================


struct  BFs9i_BFu9s_BFs9s_BFu9s  {
  signed int v1:9;
  unsigned short v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFs9s_BFu9s) C1{ Fi:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9s_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFs9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFs9s_BFu9s, BFs9i_BFu9s_BFs9s_BFu9s)
//============================================================================


struct  BFs9i_BFu9s_BFu9i  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9i_BFu9s_BFu9i) C1{ Fi:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9i, BFs9i_BFu9s_BFu9i)
//============================================================================


struct  BFs9i_BFu9s_BFu9i_BFs9i  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9i_BFs9i) C1{ Fi:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9s_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9i_BFs9i, BFs9i_BFu9s_BFu9i_BFs9i)
//============================================================================


struct  BFs9i_BFu9s_BFu9i_BFs9ll  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9i_BFs9ll) C1{ Fi:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9s_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9i_BFs9ll, BFs9i_BFu9s_BFu9i_BFs9ll)
//============================================================================


struct  BFs9i_BFu9s_BFu9i_BFs9s  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9i_BFs9s) C1{ Fi:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9s_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9i_BFs9s, BFs9i_BFu9s_BFu9i_BFs9s)
//============================================================================


struct  BFs9i_BFu9s_BFu9i_BFu9i  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9i_BFu9i) C1{ Fi:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9i_BFu9s_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9i_BFu9i, BFs9i_BFu9s_BFu9i_BFu9i)
//============================================================================


struct  BFs9i_BFu9s_BFu9i_BFu9ll  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9i_BFu9ll) C1{ Fi:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9i_BFu9s_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9i_BFu9ll, BFs9i_BFu9s_BFu9i_BFu9ll)
//============================================================================


struct  BFs9i_BFu9s_BFu9i_BFu9s  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9i_BFu9s) C1{ Fi:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9i_BFu9s_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9i_BFu9s, BFs9i_BFu9s_BFu9i_BFu9s)
//============================================================================


struct  BFs9i_BFu9s_BFu9ll  {
  signed int v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9i_BFu9s_BFu9ll) C1{ Fi:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9ll, BFs9i_BFu9s_BFu9ll)
//============================================================================


struct  BFs9i_BFu9s_BFu9ll_BFs9i  {
  signed int v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9ll_BFs9i) C1{ Fi:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9s_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9ll_BFs9i, BFs9i_BFu9s_BFu9ll_BFs9i)
//============================================================================


struct  BFs9i_BFu9s_BFu9ll_BFs9ll  {
  signed int v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9ll_BFs9ll) C1{ Fi:9 Fs:9 FL:9 FL:9}



static void Test_BFs9i_BFu9s_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9ll_BFs9ll, BFs9i_BFu9s_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9i_BFu9s_BFu9ll_BFs9s  {
  signed int v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9ll_BFs9s) C1{ Fi:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9s_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9ll_BFs9s, BFs9i_BFu9s_BFu9ll_BFs9s)
//============================================================================


struct  BFs9i_BFu9s_BFu9ll_BFu9i  {
  signed int v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9ll_BFu9i) C1{ Fi:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9i_BFu9s_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9ll_BFu9i, BFs9i_BFu9s_BFu9ll_BFu9i)
//============================================================================


struct  BFs9i_BFu9s_BFu9ll_BFu9ll  {
  signed int v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9ll_BFu9ll) C1{ Fi:9 Fs:9 FL:9 FL:9}



static void Test_BFs9i_BFu9s_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9ll_BFu9ll, BFs9i_BFu9s_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9i_BFu9s_BFu9ll_BFu9s  {
  signed int v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9ll_BFu9s) C1{ Fi:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9i_BFu9s_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9i_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9ll_BFu9s, BFs9i_BFu9s_BFu9ll_BFu9s)
//============================================================================


struct  BFs9i_BFu9s_BFu9s  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9i_BFu9s_BFu9s) C1{ Fi:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9s, BFs9i_BFu9s_BFu9s)
//============================================================================


struct  BFs9i_BFu9s_BFu9s_BFs9i  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9s_BFs9i) C1{ Fi:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9s_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9s_BFs9i, BFs9i_BFu9s_BFu9s_BFs9i)
//============================================================================


struct  BFs9i_BFu9s_BFu9s_BFs9ll  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9s_BFs9ll) C1{ Fi:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9s_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9s_BFs9ll, BFs9i_BFu9s_BFu9s_BFs9ll)
//============================================================================


struct  BFs9i_BFu9s_BFu9s_BFs9s  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9s_BFs9s) C1{ Fi:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9s_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9s_BFs9s, BFs9i_BFu9s_BFu9s_BFs9s)
//============================================================================


struct  BFs9i_BFu9s_BFu9s_BFu9i  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9s_BFu9i) C1{ Fi:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9i_BFu9s_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9s_BFu9i, BFs9i_BFu9s_BFu9s_BFu9i)
//============================================================================


struct  BFs9i_BFu9s_BFu9s_BFu9ll  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9s_BFu9ll) C1{ Fi:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9i_BFu9s_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9i_BFu9s_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9s_BFu9ll, BFs9i_BFu9s_BFu9s_BFu9ll)
//============================================================================


struct  BFs9i_BFu9s_BFu9s_BFu9s  {
  signed int v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9i_BFu9s_BFu9s_BFu9s) C1{ Fi:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9i_BFu9s_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9i_BFu9s_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9i_BFu9s_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9i_BFu9s_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9i_BFu9s_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9i_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9i_BFu9s_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9i_BFu9s_BFu9s_BFu9s, BFs9i_BFu9s_BFu9s_BFu9s)
//============================================================================


struct  BFs9ll_BFs9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
};
//SIG(1 BFs9ll_BFs9i) C1{ FL:9 Fi:9}



static void Test_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i, BFs9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFs9i_BFs9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed int v3:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9i) C1{ FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9i, BFs9ll_BFs9i_BFs9i)
//============================================================================


struct  BFs9ll_BFs9i_BFs9i_BFs9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9i_BFs9i) C1{ FL:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9i_BFs9i, BFs9ll_BFs9i_BFs9i_BFs9i)
//============================================================================


struct  BFs9ll_BFs9i_BFs9i_BFs9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9i_BFs9ll) C1{ FL:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9i_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9i_BFs9ll, BFs9ll_BFs9i_BFs9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFs9i_BFs9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9i_BFs9s) C1{ FL:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9i_BFs9s, BFs9ll_BFs9i_BFs9i_BFs9s)
//============================================================================


struct  BFs9ll_BFs9i_BFs9i_BFu9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9i_BFu9i) C1{ FL:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9i_BFu9i, BFs9ll_BFs9i_BFs9i_BFu9i)
//============================================================================


struct  BFs9ll_BFs9i_BFs9i_BFu9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9i_BFu9ll) C1{ FL:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9i_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9i_BFu9ll, BFs9ll_BFs9i_BFs9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFs9i_BFu9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9i_BFu9s) C1{ FL:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9i_BFu9s, BFs9ll_BFs9i_BFs9i_BFu9s)
//============================================================================


struct  BFs9ll_BFs9i_BFs9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9ll) C1{ FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9ll, BFs9ll_BFs9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFs9ll_BFs9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9ll_BFs9i) C1{ FL:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9ll_BFs9i, BFs9ll_BFs9i_BFs9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFs9i_BFs9ll_BFs9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9ll_BFs9ll) C1{ FL:9 Fi:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9i_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9ll_BFs9ll, BFs9ll_BFs9i_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFs9ll_BFs9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9ll_BFs9s) C1{ FL:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9ll_BFs9s, BFs9ll_BFs9i_BFs9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFs9i_BFs9ll_BFu9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9ll_BFu9i) C1{ FL:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9ll_BFu9i, BFs9ll_BFs9i_BFs9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFs9i_BFs9ll_BFu9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9ll_BFu9ll) C1{ FL:9 Fi:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9i_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9ll_BFu9ll, BFs9ll_BFs9i_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFs9ll_BFu9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9ll_BFu9s) C1{ FL:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9ll_BFu9s, BFs9ll_BFs9i_BFs9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFs9i_BFs9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed short v3:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9s) C1{ FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9s, BFs9ll_BFs9i_BFs9s)
//============================================================================


struct  BFs9ll_BFs9i_BFs9s_BFs9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9s_BFs9i) C1{ FL:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9s_BFs9i, BFs9ll_BFs9i_BFs9s_BFs9i)
//============================================================================


struct  BFs9ll_BFs9i_BFs9s_BFs9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9s_BFs9ll) C1{ FL:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9i_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9s_BFs9ll, BFs9ll_BFs9i_BFs9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFs9s_BFs9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9s_BFs9s) C1{ FL:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9s_BFs9s, BFs9ll_BFs9i_BFs9s_BFs9s)
//============================================================================


struct  BFs9ll_BFs9i_BFs9s_BFu9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9s_BFu9i) C1{ FL:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9s_BFu9i, BFs9ll_BFs9i_BFs9s_BFu9i)
//============================================================================


struct  BFs9ll_BFs9i_BFs9s_BFu9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9s_BFu9ll) C1{ FL:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9i_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9s_BFu9ll, BFs9ll_BFs9i_BFs9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFs9s_BFu9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFs9s_BFu9s) C1{ FL:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFs9s_BFu9s, BFs9ll_BFs9i_BFs9s_BFu9s)
//============================================================================


struct  BFs9ll_BFs9i_BFu9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9i) C1{ FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9i, BFs9ll_BFs9i_BFu9i)
//============================================================================


struct  BFs9ll_BFs9i_BFu9i_BFs9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9i_BFs9i) C1{ FL:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9i_BFs9i, BFs9ll_BFs9i_BFu9i_BFs9i)
//============================================================================


struct  BFs9ll_BFs9i_BFu9i_BFs9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9i_BFs9ll) C1{ FL:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9i_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9i_BFs9ll, BFs9ll_BFs9i_BFu9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFu9i_BFs9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9i_BFs9s) C1{ FL:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9i_BFs9s, BFs9ll_BFs9i_BFu9i_BFs9s)
//============================================================================


struct  BFs9ll_BFs9i_BFu9i_BFu9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9i_BFu9i) C1{ FL:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9i_BFu9i, BFs9ll_BFs9i_BFu9i_BFu9i)
//============================================================================


struct  BFs9ll_BFs9i_BFu9i_BFu9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9i_BFu9ll) C1{ FL:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9i_BFu9ll, BFs9ll_BFs9i_BFu9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFu9i_BFu9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9i_BFu9s) C1{ FL:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9i_BFu9s, BFs9ll_BFs9i_BFu9i_BFu9s)
//============================================================================


struct  BFs9ll_BFs9i_BFu9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9ll) C1{ FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9ll, BFs9ll_BFs9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFu9ll_BFs9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9ll_BFs9i) C1{ FL:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9ll_BFs9i, BFs9ll_BFs9i_BFu9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFs9i_BFu9ll_BFs9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9ll_BFs9ll) C1{ FL:9 Fi:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9i_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9ll_BFs9ll, BFs9ll_BFs9i_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFu9ll_BFs9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9ll_BFs9s) C1{ FL:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9ll_BFs9s, BFs9ll_BFs9i_BFu9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFs9i_BFu9ll_BFu9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9ll_BFu9i) C1{ FL:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9ll_BFu9i, BFs9ll_BFs9i_BFu9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFs9i_BFu9ll_BFu9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9ll_BFu9ll) C1{ FL:9 Fi:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9ll_BFu9ll, BFs9ll_BFs9i_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFu9ll_BFu9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9ll_BFu9s) C1{ FL:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9ll_BFu9s, BFs9ll_BFs9i_BFu9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFs9i_BFu9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9s) C1{ FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9s, BFs9ll_BFs9i_BFu9s)
//============================================================================


struct  BFs9ll_BFs9i_BFu9s_BFs9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9s_BFs9i) C1{ FL:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9s_BFs9i, BFs9ll_BFs9i_BFu9s_BFs9i)
//============================================================================


struct  BFs9ll_BFs9i_BFu9s_BFs9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9s_BFs9ll) C1{ FL:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9i_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9s_BFs9ll, BFs9ll_BFs9i_BFu9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFu9s_BFs9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9s_BFs9s) C1{ FL:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9s_BFs9s, BFs9ll_BFs9i_BFu9s_BFs9s)
//============================================================================


struct  BFs9ll_BFs9i_BFu9s_BFu9i  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9s_BFu9i) C1{ FL:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9s_BFu9i, BFs9ll_BFs9i_BFu9s_BFu9i)
//============================================================================


struct  BFs9ll_BFs9i_BFu9s_BFu9ll  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9s_BFu9ll) C1{ FL:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9s_BFu9ll, BFs9ll_BFs9i_BFu9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9i_BFu9s_BFu9s  {
  signed __tsi64 v1:9;
  signed int v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9i_BFu9s_BFu9s) C1{ FL:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9i_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9i_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9i_BFu9s_BFu9s, BFs9ll_BFs9i_BFu9s_BFu9s)
//============================================================================


struct  BFs9ll_BFs9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
};
//SIG(1 BFs9ll_BFs9ll) C1{ FL:9 FL:9}



static void Test_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll, BFs9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9i) C1{ FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9i, BFs9ll_BFs9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9i_BFs9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9i_BFs9i) C1{ FL:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9i_BFs9i, BFs9ll_BFs9ll_BFs9i_BFs9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9i_BFs9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9i_BFs9ll) C1{ FL:9 FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9i_BFs9ll, BFs9ll_BFs9ll_BFs9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9i_BFs9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9i_BFs9s) C1{ FL:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9i_BFs9s, BFs9ll_BFs9ll_BFs9i_BFs9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9i_BFu9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9i_BFu9i) C1{ FL:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9i_BFu9i, BFs9ll_BFs9ll_BFs9i_BFu9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9i_BFu9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9i_BFu9ll) C1{ FL:9 FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9i_BFu9ll, BFs9ll_BFs9ll_BFs9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9i_BFu9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9i_BFu9s) C1{ FL:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9i_BFu9s, BFs9ll_BFs9ll_BFs9i_BFu9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9ll) C1{ FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9ll, BFs9ll_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9ll_BFs9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9ll_BFs9i) C1{ FL:9 FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9ll_BFs9i, BFs9ll_BFs9ll_BFs9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9ll_BFs9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9ll_BFs9ll) C1{ FL:9 FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9ll_BFs9ll, BFs9ll_BFs9ll_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9ll_BFs9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9ll_BFs9s) C1{ FL:9 FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9ll_BFs9s, BFs9ll_BFs9ll_BFs9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9ll_BFu9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9ll_BFu9i) C1{ FL:9 FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9ll_BFu9i, BFs9ll_BFs9ll_BFs9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9ll_BFu9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9ll_BFu9ll) C1{ FL:9 FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9ll_BFu9ll, BFs9ll_BFs9ll_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9ll_BFu9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9ll_BFu9s) C1{ FL:9 FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9ll_BFu9s, BFs9ll_BFs9ll_BFs9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9s) C1{ FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9s, BFs9ll_BFs9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9s_BFs9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9s_BFs9i) C1{ FL:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9s_BFs9i, BFs9ll_BFs9ll_BFs9s_BFs9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9s_BFs9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9s_BFs9ll) C1{ FL:9 FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9s_BFs9ll, BFs9ll_BFs9ll_BFs9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9s_BFs9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9s_BFs9s) C1{ FL:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9s_BFs9s, BFs9ll_BFs9ll_BFs9s_BFs9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9s_BFu9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9s_BFu9i) C1{ FL:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9s_BFu9i, BFs9ll_BFs9ll_BFs9s_BFu9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9s_BFu9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9s_BFu9ll) C1{ FL:9 FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9s_BFu9ll, BFs9ll_BFs9ll_BFs9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFs9s_BFu9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFs9s_BFu9s) C1{ FL:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFs9s_BFu9s, BFs9ll_BFs9ll_BFs9s_BFu9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9i) C1{ FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9i, BFs9ll_BFs9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9i_BFs9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9i_BFs9i) C1{ FL:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9i_BFs9i, BFs9ll_BFs9ll_BFu9i_BFs9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9i_BFs9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9i_BFs9ll) C1{ FL:9 FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9i_BFs9ll, BFs9ll_BFs9ll_BFu9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9i_BFs9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9i_BFs9s) C1{ FL:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9i_BFs9s, BFs9ll_BFs9ll_BFu9i_BFs9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9i_BFu9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9i_BFu9i) C1{ FL:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9i_BFu9i, BFs9ll_BFs9ll_BFu9i_BFu9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9i_BFu9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9i_BFu9ll) C1{ FL:9 FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9i_BFu9ll, BFs9ll_BFs9ll_BFu9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9i_BFu9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9i_BFu9s) C1{ FL:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9i_BFu9s, BFs9ll_BFs9ll_BFu9i_BFu9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9ll) C1{ FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9ll, BFs9ll_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9ll_BFs9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9ll_BFs9i) C1{ FL:9 FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9ll_BFs9i, BFs9ll_BFs9ll_BFu9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9ll_BFs9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9ll_BFs9ll) C1{ FL:9 FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9ll_BFs9ll, BFs9ll_BFs9ll_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9ll_BFs9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9ll_BFs9s) C1{ FL:9 FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9ll_BFs9s, BFs9ll_BFs9ll_BFu9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9ll_BFu9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9ll_BFu9i) C1{ FL:9 FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9ll_BFu9i, BFs9ll_BFs9ll_BFu9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9ll_BFu9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9ll_BFu9ll) C1{ FL:9 FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9ll_BFu9ll, BFs9ll_BFs9ll_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9ll_BFu9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9ll_BFu9s) C1{ FL:9 FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9ll_BFu9s, BFs9ll_BFs9ll_BFu9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9s) C1{ FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9s, BFs9ll_BFs9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9s_BFs9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9s_BFs9i) C1{ FL:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9s_BFs9i, BFs9ll_BFs9ll_BFu9s_BFs9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9s_BFs9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9s_BFs9ll) C1{ FL:9 FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9s_BFs9ll, BFs9ll_BFs9ll_BFu9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9s_BFs9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9s_BFs9s) C1{ FL:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9s_BFs9s, BFs9ll_BFs9ll_BFu9s_BFs9s)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9s_BFu9i  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9s_BFu9i) C1{ FL:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9ll_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9s_BFu9i, BFs9ll_BFs9ll_BFu9s_BFu9i)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9s_BFu9ll  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9s_BFu9ll) C1{ FL:9 FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9ll_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9s_BFu9ll, BFs9ll_BFs9ll_BFu9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9ll_BFu9s_BFu9s  {
  signed __tsi64 v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9ll_BFu9s_BFu9s) C1{ FL:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9ll_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9ll_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9ll_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9ll_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9ll_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9ll_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9ll_BFu9s_BFu9s, BFs9ll_BFs9ll_BFu9s_BFu9s)
//============================================================================


struct  BFs9ll_BFs9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
};
//SIG(1 BFs9ll_BFs9s) C1{ FL:9 Fs:9}



static void Test_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s, BFs9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFs9s_BFs9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed int v3:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9i) C1{ FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9i, BFs9ll_BFs9s_BFs9i)
//============================================================================


struct  BFs9ll_BFs9s_BFs9i_BFs9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9i_BFs9i) C1{ FL:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9i_BFs9i, BFs9ll_BFs9s_BFs9i_BFs9i)
//============================================================================


struct  BFs9ll_BFs9s_BFs9i_BFs9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9i_BFs9ll) C1{ FL:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9s_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9i_BFs9ll, BFs9ll_BFs9s_BFs9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFs9i_BFs9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9i_BFs9s) C1{ FL:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9i_BFs9s, BFs9ll_BFs9s_BFs9i_BFs9s)
//============================================================================


struct  BFs9ll_BFs9s_BFs9i_BFu9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9i_BFu9i) C1{ FL:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9i_BFu9i, BFs9ll_BFs9s_BFs9i_BFu9i)
//============================================================================


struct  BFs9ll_BFs9s_BFs9i_BFu9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9i_BFu9ll) C1{ FL:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9s_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9i_BFu9ll, BFs9ll_BFs9s_BFs9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFs9i_BFu9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9i_BFu9s) C1{ FL:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9i_BFu9s, BFs9ll_BFs9s_BFs9i_BFu9s)
//============================================================================


struct  BFs9ll_BFs9s_BFs9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9ll) C1{ FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9ll, BFs9ll_BFs9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFs9ll_BFs9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9ll_BFs9i) C1{ FL:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9ll_BFs9i, BFs9ll_BFs9s_BFs9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFs9s_BFs9ll_BFs9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9ll_BFs9ll) C1{ FL:9 Fs:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9s_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9ll_BFs9ll, BFs9ll_BFs9s_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFs9ll_BFs9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9ll_BFs9s) C1{ FL:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9ll_BFs9s, BFs9ll_BFs9s_BFs9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFs9s_BFs9ll_BFu9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9ll_BFu9i) C1{ FL:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9ll_BFu9i, BFs9ll_BFs9s_BFs9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFs9s_BFs9ll_BFu9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9ll_BFu9ll) C1{ FL:9 Fs:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9s_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9ll_BFu9ll, BFs9ll_BFs9s_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFs9ll_BFu9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9ll_BFu9s) C1{ FL:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9ll_BFu9s, BFs9ll_BFs9s_BFs9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFs9s_BFs9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed short v3:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9s) C1{ FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9s, BFs9ll_BFs9s_BFs9s)
//============================================================================


struct  BFs9ll_BFs9s_BFs9s_BFs9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9s_BFs9i) C1{ FL:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9s_BFs9i, BFs9ll_BFs9s_BFs9s_BFs9i)
//============================================================================


struct  BFs9ll_BFs9s_BFs9s_BFs9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9s_BFs9ll) C1{ FL:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9s_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9s_BFs9ll, BFs9ll_BFs9s_BFs9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFs9s_BFs9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9s_BFs9s) C1{ FL:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9s_BFs9s, BFs9ll_BFs9s_BFs9s_BFs9s)
//============================================================================


struct  BFs9ll_BFs9s_BFs9s_BFu9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9s_BFu9i) C1{ FL:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9s_BFu9i, BFs9ll_BFs9s_BFs9s_BFu9i)
//============================================================================


struct  BFs9ll_BFs9s_BFs9s_BFu9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9s_BFu9ll) C1{ FL:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9s_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9s_BFu9ll, BFs9ll_BFs9s_BFs9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFs9s_BFu9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFs9s_BFu9s) C1{ FL:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFs9s_BFu9s, BFs9ll_BFs9s_BFs9s_BFu9s)
//============================================================================


struct  BFs9ll_BFs9s_BFu9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9i) C1{ FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9i, BFs9ll_BFs9s_BFu9i)
//============================================================================


struct  BFs9ll_BFs9s_BFu9i_BFs9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9i_BFs9i) C1{ FL:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9i_BFs9i, BFs9ll_BFs9s_BFu9i_BFs9i)
//============================================================================


struct  BFs9ll_BFs9s_BFu9i_BFs9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9i_BFs9ll) C1{ FL:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9s_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9i_BFs9ll, BFs9ll_BFs9s_BFu9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFu9i_BFs9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9i_BFs9s) C1{ FL:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9i_BFs9s, BFs9ll_BFs9s_BFu9i_BFs9s)
//============================================================================


struct  BFs9ll_BFs9s_BFu9i_BFu9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9i_BFu9i) C1{ FL:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9i_BFu9i, BFs9ll_BFs9s_BFu9i_BFu9i)
//============================================================================


struct  BFs9ll_BFs9s_BFu9i_BFu9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9i_BFu9ll) C1{ FL:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9ll_BFs9s_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9i_BFu9ll, BFs9ll_BFs9s_BFu9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFu9i_BFu9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9i_BFu9s) C1{ FL:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9i_BFu9s, BFs9ll_BFs9s_BFu9i_BFu9s)
//============================================================================


struct  BFs9ll_BFs9s_BFu9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9ll) C1{ FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9ll, BFs9ll_BFs9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFu9ll_BFs9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9ll_BFs9i) C1{ FL:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9ll_BFs9i, BFs9ll_BFs9s_BFu9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFs9s_BFu9ll_BFs9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9ll_BFs9ll) C1{ FL:9 Fs:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9s_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9ll_BFs9ll, BFs9ll_BFs9s_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFu9ll_BFs9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9ll_BFs9s) C1{ FL:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9ll_BFs9s, BFs9ll_BFs9s_BFu9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFs9s_BFu9ll_BFu9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9ll_BFu9i) C1{ FL:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9ll_BFu9i, BFs9ll_BFs9s_BFu9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFs9s_BFu9ll_BFu9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9ll_BFu9ll) C1{ FL:9 Fs:9 FL:9 FL:9}



static void Test_BFs9ll_BFs9s_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9ll_BFu9ll, BFs9ll_BFs9s_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFu9ll_BFu9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9ll_BFu9s) C1{ FL:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9ll_BFu9s, BFs9ll_BFs9s_BFu9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFs9s_BFu9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9s) C1{ FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9s, BFs9ll_BFs9s_BFu9s)
//============================================================================


struct  BFs9ll_BFs9s_BFu9s_BFs9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9s_BFs9i) C1{ FL:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9s_BFs9i, BFs9ll_BFs9s_BFu9s_BFs9i)
//============================================================================


struct  BFs9ll_BFs9s_BFu9s_BFs9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9s_BFs9ll) C1{ FL:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9s_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9s_BFs9ll, BFs9ll_BFs9s_BFu9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFu9s_BFs9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9s_BFs9s) C1{ FL:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9s_BFs9s, BFs9ll_BFs9s_BFu9s_BFs9s)
//============================================================================


struct  BFs9ll_BFs9s_BFu9s_BFu9i  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9s_BFu9i) C1{ FL:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFs9s_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9s_BFu9i, BFs9ll_BFs9s_BFu9s_BFu9i)
//============================================================================


struct  BFs9ll_BFs9s_BFu9s_BFu9ll  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9s_BFu9ll) C1{ FL:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9ll_BFs9s_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9s_BFu9ll, BFs9ll_BFs9s_BFu9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFs9s_BFu9s_BFu9s  {
  signed __tsi64 v1:9;
  signed short v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFs9s_BFu9s_BFu9s) C1{ FL:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFs9s_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFs9s_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFs9s_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFs9s_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFs9s_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFs9s_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFs9s_BFu9s_BFu9s, BFs9ll_BFs9s_BFu9s_BFu9s)
//============================================================================


struct  BFs9ll_BFu9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
};
//SIG(1 BFs9ll_BFu9i) C1{ FL:9 Fi:9}



static void Test_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i, BFs9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFu9i_BFs9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed int v3:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9i) C1{ FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9i, BFs9ll_BFu9i_BFs9i)
//============================================================================


struct  BFs9ll_BFu9i_BFs9i_BFs9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9i_BFs9i) C1{ FL:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9i_BFs9i, BFs9ll_BFu9i_BFs9i_BFs9i)
//============================================================================


struct  BFs9ll_BFu9i_BFs9i_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9i_BFs9ll) C1{ FL:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9i_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9i_BFs9ll, BFs9ll_BFu9i_BFs9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFs9i_BFs9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9i_BFs9s) C1{ FL:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9i_BFs9s, BFs9ll_BFu9i_BFs9i_BFs9s)
//============================================================================


struct  BFs9ll_BFu9i_BFs9i_BFu9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9i_BFu9i) C1{ FL:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9i_BFu9i, BFs9ll_BFu9i_BFs9i_BFu9i)
//============================================================================


struct  BFs9ll_BFu9i_BFs9i_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9i_BFu9ll) C1{ FL:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9i_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9i_BFu9ll, BFs9ll_BFu9i_BFs9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFs9i_BFu9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9i_BFu9s) C1{ FL:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9i_BFu9s, BFs9ll_BFu9i_BFs9i_BFu9s)
//============================================================================


struct  BFs9ll_BFu9i_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9ll) C1{ FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9ll, BFs9ll_BFu9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFs9ll_BFs9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9ll_BFs9i) C1{ FL:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9ll_BFs9i, BFs9ll_BFu9i_BFs9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFu9i_BFs9ll_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9ll_BFs9ll) C1{ FL:9 Fi:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9i_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9ll_BFs9ll, BFs9ll_BFu9i_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFs9ll_BFs9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9ll_BFs9s) C1{ FL:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9ll_BFs9s, BFs9ll_BFu9i_BFs9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFu9i_BFs9ll_BFu9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9ll_BFu9i) C1{ FL:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9ll_BFu9i, BFs9ll_BFu9i_BFs9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFu9i_BFs9ll_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9ll_BFu9ll) C1{ FL:9 Fi:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9i_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9ll_BFu9ll, BFs9ll_BFu9i_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFs9ll_BFu9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9ll_BFu9s) C1{ FL:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9ll_BFu9s, BFs9ll_BFu9i_BFs9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFu9i_BFs9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed short v3:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9s) C1{ FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9s, BFs9ll_BFu9i_BFs9s)
//============================================================================


struct  BFs9ll_BFu9i_BFs9s_BFs9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9s_BFs9i) C1{ FL:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9s_BFs9i, BFs9ll_BFu9i_BFs9s_BFs9i)
//============================================================================


struct  BFs9ll_BFu9i_BFs9s_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9s_BFs9ll) C1{ FL:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9i_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9s_BFs9ll, BFs9ll_BFu9i_BFs9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFs9s_BFs9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9s_BFs9s) C1{ FL:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9s_BFs9s, BFs9ll_BFu9i_BFs9s_BFs9s)
//============================================================================


struct  BFs9ll_BFu9i_BFs9s_BFu9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9s_BFu9i) C1{ FL:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9s_BFu9i, BFs9ll_BFu9i_BFs9s_BFu9i)
//============================================================================


struct  BFs9ll_BFu9i_BFs9s_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9s_BFu9ll) C1{ FL:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9i_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9s_BFu9ll, BFs9ll_BFu9i_BFs9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFs9s_BFu9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFs9s_BFu9s) C1{ FL:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFs9s_BFu9s, BFs9ll_BFu9i_BFs9s_BFu9s)
//============================================================================


struct  BFs9ll_BFu9i_BFu9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9i) C1{ FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9i, BFs9ll_BFu9i_BFu9i)
//============================================================================


struct  BFs9ll_BFu9i_BFu9i_BFs9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9i_BFs9i) C1{ FL:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9i_BFs9i, BFs9ll_BFu9i_BFu9i_BFs9i)
//============================================================================


struct  BFs9ll_BFu9i_BFu9i_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9i_BFs9ll) C1{ FL:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9i_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9i_BFs9ll, BFs9ll_BFu9i_BFu9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFu9i_BFs9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9i_BFs9s) C1{ FL:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9i_BFs9s, BFs9ll_BFu9i_BFu9i_BFs9s)
//============================================================================


struct  BFs9ll_BFu9i_BFu9i_BFu9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9i_BFu9i) C1{ FL:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9i_BFu9i, BFs9ll_BFu9i_BFu9i_BFu9i)
//============================================================================


struct  BFs9ll_BFu9i_BFu9i_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9i_BFu9ll) C1{ FL:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9i_BFu9ll, BFs9ll_BFu9i_BFu9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFu9i_BFu9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9i_BFu9s) C1{ FL:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9i_BFu9s, BFs9ll_BFu9i_BFu9i_BFu9s)
//============================================================================


struct  BFs9ll_BFu9i_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9ll) C1{ FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9ll, BFs9ll_BFu9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFu9ll_BFs9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9ll_BFs9i) C1{ FL:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9ll_BFs9i, BFs9ll_BFu9i_BFu9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFu9i_BFu9ll_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9ll_BFs9ll) C1{ FL:9 Fi:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9i_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9ll_BFs9ll, BFs9ll_BFu9i_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFu9ll_BFs9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9ll_BFs9s) C1{ FL:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9ll_BFs9s, BFs9ll_BFu9i_BFu9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFu9i_BFu9ll_BFu9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9ll_BFu9i) C1{ FL:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9ll_BFu9i, BFs9ll_BFu9i_BFu9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFu9i_BFu9ll_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9ll_BFu9ll) C1{ FL:9 Fi:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9ll_BFu9ll, BFs9ll_BFu9i_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFu9ll_BFu9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9ll_BFu9s) C1{ FL:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9ll_BFu9s, BFs9ll_BFu9i_BFu9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFu9i_BFu9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9s) C1{ FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9s, BFs9ll_BFu9i_BFu9s)
//============================================================================


struct  BFs9ll_BFu9i_BFu9s_BFs9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9s_BFs9i) C1{ FL:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9s_BFs9i, BFs9ll_BFu9i_BFu9s_BFs9i)
//============================================================================


struct  BFs9ll_BFu9i_BFu9s_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9s_BFs9ll) C1{ FL:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9i_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9s_BFs9ll, BFs9ll_BFu9i_BFu9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFu9s_BFs9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9s_BFs9s) C1{ FL:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9s_BFs9s, BFs9ll_BFu9i_BFu9s_BFs9s)
//============================================================================


struct  BFs9ll_BFu9i_BFu9s_BFu9i  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9s_BFu9i) C1{ FL:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9s_BFu9i, BFs9ll_BFu9i_BFu9s_BFu9i)
//============================================================================


struct  BFs9ll_BFu9i_BFu9s_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9s_BFu9ll) C1{ FL:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9s_BFu9ll, BFs9ll_BFu9i_BFu9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9i_BFu9s_BFu9s  {
  signed __tsi64 v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9i_BFu9s_BFu9s) C1{ FL:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9i_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9i_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9i_BFu9s_BFu9s, BFs9ll_BFu9i_BFu9s_BFu9s)
//============================================================================


struct  BFs9ll_BFu9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
};
//SIG(1 BFs9ll_BFu9ll) C1{ FL:9 FL:9}



static void Test_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll, BFs9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed int v3:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9i) C1{ FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9i, BFs9ll_BFu9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9i_BFs9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9i_BFs9i) C1{ FL:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9i_BFs9i, BFs9ll_BFu9ll_BFs9i_BFs9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9i_BFs9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9i_BFs9ll) C1{ FL:9 FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9i_BFs9ll, BFs9ll_BFu9ll_BFs9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9i_BFs9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9i_BFs9s) C1{ FL:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9i_BFs9s, BFs9ll_BFu9ll_BFs9i_BFs9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9i_BFu9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9i_BFu9i) C1{ FL:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9i_BFu9i, BFs9ll_BFu9ll_BFs9i_BFu9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9i_BFu9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9i_BFu9ll) C1{ FL:9 FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9i_BFu9ll, BFs9ll_BFu9ll_BFs9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9i_BFu9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9i_BFu9s) C1{ FL:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9i_BFu9s, BFs9ll_BFu9ll_BFs9i_BFu9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9ll) C1{ FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9ll, BFs9ll_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9ll_BFs9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9ll_BFs9i) C1{ FL:9 FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9ll_BFs9i, BFs9ll_BFu9ll_BFs9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9ll_BFs9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9ll_BFs9ll) C1{ FL:9 FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9ll_BFs9ll, BFs9ll_BFu9ll_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9ll_BFs9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9ll_BFs9s) C1{ FL:9 FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9ll_BFs9s, BFs9ll_BFu9ll_BFs9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9ll_BFu9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9ll_BFu9i) C1{ FL:9 FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9ll_BFu9i, BFs9ll_BFu9ll_BFs9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9ll_BFu9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9ll_BFu9ll) C1{ FL:9 FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9ll_BFu9ll, BFs9ll_BFu9ll_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9ll_BFu9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9ll_BFu9s) C1{ FL:9 FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9ll_BFu9s, BFs9ll_BFu9ll_BFs9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed short v3:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9s) C1{ FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9s, BFs9ll_BFu9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9s_BFs9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9s_BFs9i) C1{ FL:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9s_BFs9i, BFs9ll_BFu9ll_BFs9s_BFs9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9s_BFs9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9s_BFs9ll) C1{ FL:9 FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9s_BFs9ll, BFs9ll_BFu9ll_BFs9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9s_BFs9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9s_BFs9s) C1{ FL:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9s_BFs9s, BFs9ll_BFu9ll_BFs9s_BFs9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9s_BFu9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9s_BFu9i) C1{ FL:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9s_BFu9i, BFs9ll_BFu9ll_BFs9s_BFu9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9s_BFu9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9s_BFu9ll) C1{ FL:9 FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9s_BFu9ll, BFs9ll_BFu9ll_BFs9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFs9s_BFu9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFs9s_BFu9s) C1{ FL:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFs9s_BFu9s, BFs9ll_BFu9ll_BFs9s_BFu9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9i) C1{ FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9i, BFs9ll_BFu9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9i_BFs9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9i_BFs9i) C1{ FL:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9i_BFs9i, BFs9ll_BFu9ll_BFu9i_BFs9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9i_BFs9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9i_BFs9ll) C1{ FL:9 FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9i_BFs9ll, BFs9ll_BFu9ll_BFu9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9i_BFs9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9i_BFs9s) C1{ FL:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9i_BFs9s, BFs9ll_BFu9ll_BFu9i_BFs9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9i_BFu9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9i_BFu9i) C1{ FL:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9i_BFu9i, BFs9ll_BFu9ll_BFu9i_BFu9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9i_BFu9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9i_BFu9ll) C1{ FL:9 FL:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9i_BFu9ll, BFs9ll_BFu9ll_BFu9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9i_BFu9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9i_BFu9s) C1{ FL:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9i_BFu9s, BFs9ll_BFu9ll_BFu9i_BFu9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9ll) C1{ FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9ll, BFs9ll_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9ll_BFs9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9ll_BFs9i) C1{ FL:9 FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9ll_BFs9i, BFs9ll_BFu9ll_BFu9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9ll_BFs9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9ll_BFs9ll) C1{ FL:9 FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9ll_BFs9ll, BFs9ll_BFu9ll_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9ll_BFs9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9ll_BFs9s) C1{ FL:9 FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9ll_BFs9s, BFs9ll_BFu9ll_BFu9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9ll_BFu9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9ll_BFu9i) C1{ FL:9 FL:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9ll_BFu9i, BFs9ll_BFu9ll_BFu9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9ll_BFu9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9ll_BFu9ll) C1{ FL:9 FL:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9ll_BFu9ll, BFs9ll_BFu9ll_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9ll_BFu9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9ll_BFu9s) C1{ FL:9 FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9ll_BFu9s, BFs9ll_BFu9ll_BFu9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9s) C1{ FL:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9s, BFs9ll_BFu9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9s_BFs9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9s_BFs9i) C1{ FL:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9s_BFs9i, BFs9ll_BFu9ll_BFu9s_BFs9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9s_BFs9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9s_BFs9ll) C1{ FL:9 FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9s_BFs9ll, BFs9ll_BFu9ll_BFu9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9s_BFs9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9s_BFs9s) C1{ FL:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9s_BFs9s, BFs9ll_BFu9ll_BFu9s_BFs9s)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9s_BFu9i  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9s_BFu9i) C1{ FL:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9ll_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9s_BFu9i, BFs9ll_BFu9ll_BFu9s_BFu9i)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9s_BFu9ll  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9s_BFu9ll) C1{ FL:9 FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9ll_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9s_BFu9ll, BFs9ll_BFu9ll_BFu9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9ll_BFu9s_BFu9s  {
  signed __tsi64 v1:9;
  __tsu64 v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9ll_BFu9s_BFu9s) C1{ FL:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9ll_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9ll_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9ll_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9ll_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9ll_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9ll_BFu9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9ll_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9ll_BFu9s_BFu9s, BFs9ll_BFu9ll_BFu9s_BFu9s)
//============================================================================


struct  BFs9ll_BFu9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
};
//SIG(1 BFs9ll_BFu9s) C1{ FL:9 Fs:9}



static void Test_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s, BFs9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFu9s_BFs9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed int v3:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9i) C1{ FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9i, BFs9ll_BFu9s_BFs9i)
//============================================================================


struct  BFs9ll_BFu9s_BFs9i_BFs9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9i_BFs9i) C1{ FL:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9i_BFs9i, BFs9ll_BFu9s_BFs9i_BFs9i)
//============================================================================


struct  BFs9ll_BFu9s_BFs9i_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9i_BFs9ll) C1{ FL:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9s_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9i_BFs9ll, BFs9ll_BFu9s_BFs9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFs9i_BFs9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9i_BFs9s) C1{ FL:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9i_BFs9s, BFs9ll_BFu9s_BFs9i_BFs9s)
//============================================================================


struct  BFs9ll_BFu9s_BFs9i_BFu9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9i_BFu9i) C1{ FL:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9i_BFu9i, BFs9ll_BFu9s_BFs9i_BFu9i)
//============================================================================


struct  BFs9ll_BFu9s_BFs9i_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9i_BFu9ll) C1{ FL:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9s_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9i_BFu9ll, BFs9ll_BFu9s_BFs9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFs9i_BFu9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9i_BFu9s) C1{ FL:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFu9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9i_BFu9s, BFs9ll_BFu9s_BFs9i_BFu9s)
//============================================================================


struct  BFs9ll_BFu9s_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9ll) C1{ FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9ll, BFs9ll_BFu9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFs9ll_BFs9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9ll_BFs9i) C1{ FL:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9ll_BFs9i, BFs9ll_BFu9s_BFs9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFu9s_BFs9ll_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9ll_BFs9ll) C1{ FL:9 Fs:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9s_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9ll_BFs9ll, BFs9ll_BFu9s_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFs9ll_BFs9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9ll_BFs9s) C1{ FL:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9ll_BFs9s, BFs9ll_BFu9s_BFs9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFu9s_BFs9ll_BFu9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9ll_BFu9i) C1{ FL:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9ll_BFu9i, BFs9ll_BFu9s_BFs9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFu9s_BFs9ll_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9ll_BFu9ll) C1{ FL:9 Fs:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9s_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9ll_BFu9ll, BFs9ll_BFu9s_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFs9ll_BFu9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9ll_BFu9s) C1{ FL:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9ll_BFu9s, BFs9ll_BFu9s_BFs9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFu9s_BFs9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed short v3:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9s) C1{ FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9s, BFs9ll_BFu9s_BFs9s)
//============================================================================


struct  BFs9ll_BFu9s_BFs9s_BFs9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9s_BFs9i) C1{ FL:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9s_BFs9i, BFs9ll_BFu9s_BFs9s_BFs9i)
//============================================================================


struct  BFs9ll_BFu9s_BFs9s_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9s_BFs9ll) C1{ FL:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9s_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9s_BFs9ll, BFs9ll_BFu9s_BFs9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFs9s_BFs9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9s_BFs9s) C1{ FL:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9s_BFs9s, BFs9ll_BFu9s_BFs9s_BFs9s)
//============================================================================


struct  BFs9ll_BFu9s_BFs9s_BFu9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9s_BFu9i) C1{ FL:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9s_BFu9i, BFs9ll_BFu9s_BFs9s_BFu9i)
//============================================================================


struct  BFs9ll_BFu9s_BFs9s_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9s_BFu9ll) C1{ FL:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9s_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9s_BFu9ll, BFs9ll_BFu9s_BFs9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFs9s_BFu9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFs9s_BFu9s) C1{ FL:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFu9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFs9s_BFu9s, BFs9ll_BFu9s_BFs9s_BFu9s)
//============================================================================


struct  BFs9ll_BFu9s_BFu9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9i) C1{ FL:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9i, BFs9ll_BFu9s_BFu9i)
//============================================================================


struct  BFs9ll_BFu9s_BFu9i_BFs9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9i_BFs9i) C1{ FL:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9i_BFs9i, BFs9ll_BFu9s_BFu9i_BFs9i)
//============================================================================


struct  BFs9ll_BFu9s_BFu9i_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9i_BFs9ll) C1{ FL:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9s_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9i_BFs9ll, BFs9ll_BFu9s_BFu9i_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFu9i_BFs9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9i_BFs9s) C1{ FL:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9i_BFs9s, BFs9ll_BFu9s_BFu9i_BFs9s)
//============================================================================


struct  BFs9ll_BFu9s_BFu9i_BFu9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9i_BFu9i) C1{ FL:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9i_BFu9i, BFs9ll_BFu9s_BFu9i_BFu9i)
//============================================================================


struct  BFs9ll_BFu9s_BFu9i_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9i_BFu9ll) C1{ FL:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9ll_BFu9s_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9i_BFu9ll, BFs9ll_BFu9s_BFu9i_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFu9i_BFu9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9i_BFu9s) C1{ FL:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFu9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9i_BFu9s, BFs9ll_BFu9s_BFu9i_BFu9s)
//============================================================================


struct  BFs9ll_BFu9s_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9ll) C1{ FL:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9ll, BFs9ll_BFu9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFu9ll_BFs9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9ll_BFs9i) C1{ FL:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9ll_BFs9i, BFs9ll_BFu9s_BFu9ll_BFs9i)
//============================================================================


struct  BFs9ll_BFu9s_BFu9ll_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9ll_BFs9ll) C1{ FL:9 Fs:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9s_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9ll_BFs9ll, BFs9ll_BFu9s_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFu9ll_BFs9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9ll_BFs9s) C1{ FL:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9ll_BFs9s, BFs9ll_BFu9s_BFu9ll_BFs9s)
//============================================================================


struct  BFs9ll_BFu9s_BFu9ll_BFu9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9ll_BFu9i) C1{ FL:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9ll_BFu9i, BFs9ll_BFu9s_BFu9ll_BFu9i)
//============================================================================


struct  BFs9ll_BFu9s_BFu9ll_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9ll_BFu9ll) C1{ FL:9 Fs:9 FL:9 FL:9}



static void Test_BFs9ll_BFu9s_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9ll_BFu9ll, BFs9ll_BFu9s_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFu9ll_BFu9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9ll_BFu9s) C1{ FL:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9ll_BFu9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9ll_BFu9s, BFs9ll_BFu9s_BFu9ll_BFu9s)
//============================================================================


struct  BFs9ll_BFu9s_BFu9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9s) C1{ FL:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9s, BFs9ll_BFu9s_BFu9s)
//============================================================================


struct  BFs9ll_BFu9s_BFu9s_BFs9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9s_BFs9i) C1{ FL:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9s_BFs9i, BFs9ll_BFu9s_BFu9s_BFs9i)
//============================================================================


struct  BFs9ll_BFu9s_BFu9s_BFs9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9s_BFs9ll) C1{ FL:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9s_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9s_BFs9ll, BFs9ll_BFu9s_BFu9s_BFs9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFu9s_BFs9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9s_BFs9s) C1{ FL:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9s_BFs9s, BFs9ll_BFu9s_BFu9s_BFs9s)
//============================================================================


struct  BFs9ll_BFu9s_BFu9s_BFu9i  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9s_BFu9i) C1{ FL:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9ll_BFu9s_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9s_BFu9i, BFs9ll_BFu9s_BFu9s_BFu9i)
//============================================================================


struct  BFs9ll_BFu9s_BFu9s_BFu9ll  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9s_BFu9ll) C1{ FL:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9ll_BFu9s_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9s_BFu9ll, BFs9ll_BFu9s_BFu9s_BFu9ll)
//============================================================================


struct  BFs9ll_BFu9s_BFu9s_BFu9s  {
  signed __tsi64 v1:9;
  unsigned short v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9ll_BFu9s_BFu9s_BFu9s) C1{ FL:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9ll_BFu9s_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9ll_BFu9s_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9ll_BFu9s_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9ll_BFu9s_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9ll_BFu9s_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9ll_BFu9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9ll_BFu9s_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9ll_BFu9s_BFu9s_BFu9s, BFs9ll_BFu9s_BFu9s_BFu9s)
//============================================================================


struct  BFs9s_BFs9i  {
  signed short v1:9;
  signed int v2:9;
};
//SIG(1 BFs9s_BFs9i) C1{ Fs:9 Fi:9}



static void Test_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i, BFs9s_BFs9i)
//============================================================================


struct  BFs9s_BFs9i_BFs9i  {
  signed short v1:9;
  signed int v2:9;
  signed int v3:9;
};
//SIG(1 BFs9s_BFs9i_BFs9i) C1{ Fs:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9i, BFs9s_BFs9i_BFs9i)
//============================================================================


struct  BFs9s_BFs9i_BFs9i_BFs9i  {
  signed short v1:9;
  signed int v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9i_BFs9i) C1{ Fs:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9i_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9i_BFs9i, BFs9s_BFs9i_BFs9i_BFs9i)
//============================================================================


struct  BFs9s_BFs9i_BFs9i_BFs9ll  {
  signed short v1:9;
  signed int v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9i_BFs9ll) C1{ Fs:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9i_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9i_BFs9ll, BFs9s_BFs9i_BFs9i_BFs9ll)
//============================================================================


struct  BFs9s_BFs9i_BFs9i_BFs9s  {
  signed short v1:9;
  signed int v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9i_BFs9s) C1{ Fs:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9i_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9i_BFs9s, BFs9s_BFs9i_BFs9i_BFs9s)
//============================================================================


struct  BFs9s_BFs9i_BFs9i_BFu9i  {
  signed short v1:9;
  signed int v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9i_BFu9i) C1{ Fs:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9i_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9i_BFu9i, BFs9s_BFs9i_BFs9i_BFu9i)
//============================================================================


struct  BFs9s_BFs9i_BFs9i_BFu9ll  {
  signed short v1:9;
  signed int v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9i_BFu9ll) C1{ Fs:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9i_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9i_BFu9ll, BFs9s_BFs9i_BFs9i_BFu9ll)
//============================================================================


struct  BFs9s_BFs9i_BFs9i_BFu9s  {
  signed short v1:9;
  signed int v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9i_BFu9s) C1{ Fs:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9i_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9i_BFu9s, BFs9s_BFs9i_BFs9i_BFu9s)
//============================================================================


struct  BFs9s_BFs9i_BFs9ll  {
  signed short v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9s_BFs9i_BFs9ll) C1{ Fs:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9ll, BFs9s_BFs9i_BFs9ll)
//============================================================================


struct  BFs9s_BFs9i_BFs9ll_BFs9i  {
  signed short v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9ll_BFs9i) C1{ Fs:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9i_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9ll_BFs9i, BFs9s_BFs9i_BFs9ll_BFs9i)
//============================================================================


struct  BFs9s_BFs9i_BFs9ll_BFs9ll  {
  signed short v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9ll_BFs9ll) C1{ Fs:9 Fi:9 FL:9 FL:9}



static void Test_BFs9s_BFs9i_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9ll_BFs9ll, BFs9s_BFs9i_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFs9i_BFs9ll_BFs9s  {
  signed short v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9ll_BFs9s) C1{ Fs:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9i_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9ll_BFs9s, BFs9s_BFs9i_BFs9ll_BFs9s)
//============================================================================


struct  BFs9s_BFs9i_BFs9ll_BFu9i  {
  signed short v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9ll_BFu9i) C1{ Fs:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9i_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9ll_BFu9i, BFs9s_BFs9i_BFs9ll_BFu9i)
//============================================================================


struct  BFs9s_BFs9i_BFs9ll_BFu9ll  {
  signed short v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9ll_BFu9ll) C1{ Fs:9 Fi:9 FL:9 FL:9}



static void Test_BFs9s_BFs9i_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9ll_BFu9ll, BFs9s_BFs9i_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFs9i_BFs9ll_BFu9s  {
  signed short v1:9;
  signed int v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9ll_BFu9s) C1{ Fs:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9i_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9ll_BFu9s, BFs9s_BFs9i_BFs9ll_BFu9s)
//============================================================================


struct  BFs9s_BFs9i_BFs9s  {
  signed short v1:9;
  signed int v2:9;
  signed short v3:9;
};
//SIG(1 BFs9s_BFs9i_BFs9s) C1{ Fs:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9s, BFs9s_BFs9i_BFs9s)
//============================================================================


struct  BFs9s_BFs9i_BFs9s_BFs9i  {
  signed short v1:9;
  signed int v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9s_BFs9i) C1{ Fs:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9i_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9s_BFs9i, BFs9s_BFs9i_BFs9s_BFs9i)
//============================================================================


struct  BFs9s_BFs9i_BFs9s_BFs9ll  {
  signed short v1:9;
  signed int v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9s_BFs9ll) C1{ Fs:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9i_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9s_BFs9ll, BFs9s_BFs9i_BFs9s_BFs9ll)
//============================================================================


struct  BFs9s_BFs9i_BFs9s_BFs9s  {
  signed short v1:9;
  signed int v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9s_BFs9s) C1{ Fs:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9i_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9s_BFs9s, BFs9s_BFs9i_BFs9s_BFs9s)
//============================================================================


struct  BFs9s_BFs9i_BFs9s_BFu9i  {
  signed short v1:9;
  signed int v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9s_BFu9i) C1{ Fs:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9i_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9s_BFu9i, BFs9s_BFs9i_BFs9s_BFu9i)
//============================================================================


struct  BFs9s_BFs9i_BFs9s_BFu9ll  {
  signed short v1:9;
  signed int v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9s_BFu9ll) C1{ Fs:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9i_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9s_BFu9ll, BFs9s_BFs9i_BFs9s_BFu9ll)
//============================================================================


struct  BFs9s_BFs9i_BFs9s_BFu9s  {
  signed short v1:9;
  signed int v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFs9s_BFu9s) C1{ Fs:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9i_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFs9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFs9s_BFu9s, BFs9s_BFs9i_BFs9s_BFu9s)
//============================================================================


struct  BFs9s_BFs9i_BFu9i  {
  signed short v1:9;
  signed int v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9s_BFs9i_BFu9i) C1{ Fs:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9i, BFs9s_BFs9i_BFu9i)
//============================================================================


struct  BFs9s_BFs9i_BFu9i_BFs9i  {
  signed short v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9i_BFs9i) C1{ Fs:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9i_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9i_BFs9i, BFs9s_BFs9i_BFu9i_BFs9i)
//============================================================================


struct  BFs9s_BFs9i_BFu9i_BFs9ll  {
  signed short v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9i_BFs9ll) C1{ Fs:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9i_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9i_BFs9ll, BFs9s_BFs9i_BFu9i_BFs9ll)
//============================================================================


struct  BFs9s_BFs9i_BFu9i_BFs9s  {
  signed short v1:9;
  signed int v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9i_BFs9s) C1{ Fs:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9i_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9i_BFs9s, BFs9s_BFs9i_BFu9i_BFs9s)
//============================================================================


struct  BFs9s_BFs9i_BFu9i_BFu9i  {
  signed short v1:9;
  signed int v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9i_BFu9i) C1{ Fs:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9i_BFu9i, BFs9s_BFs9i_BFu9i_BFu9i)
//============================================================================


struct  BFs9s_BFs9i_BFu9i_BFu9ll  {
  signed short v1:9;
  signed int v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9i_BFu9ll) C1{ Fs:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9i_BFu9ll, BFs9s_BFs9i_BFu9i_BFu9ll)
//============================================================================


struct  BFs9s_BFs9i_BFu9i_BFu9s  {
  signed short v1:9;
  signed int v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9i_BFu9s) C1{ Fs:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9i_BFu9s, BFs9s_BFs9i_BFu9i_BFu9s)
//============================================================================


struct  BFs9s_BFs9i_BFu9ll  {
  signed short v1:9;
  signed int v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9s_BFs9i_BFu9ll) C1{ Fs:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9ll, BFs9s_BFs9i_BFu9ll)
//============================================================================


struct  BFs9s_BFs9i_BFu9ll_BFs9i  {
  signed short v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9ll_BFs9i) C1{ Fs:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9i_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9ll_BFs9i, BFs9s_BFs9i_BFu9ll_BFs9i)
//============================================================================


struct  BFs9s_BFs9i_BFu9ll_BFs9ll  {
  signed short v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9ll_BFs9ll) C1{ Fs:9 Fi:9 FL:9 FL:9}



static void Test_BFs9s_BFs9i_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9ll_BFs9ll, BFs9s_BFs9i_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFs9i_BFu9ll_BFs9s  {
  signed short v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9ll_BFs9s) C1{ Fs:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9i_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9ll_BFs9s, BFs9s_BFs9i_BFu9ll_BFs9s)
//============================================================================


struct  BFs9s_BFs9i_BFu9ll_BFu9i  {
  signed short v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9ll_BFu9i) C1{ Fs:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9ll_BFu9i, BFs9s_BFs9i_BFu9ll_BFu9i)
//============================================================================


struct  BFs9s_BFs9i_BFu9ll_BFu9ll  {
  signed short v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9ll_BFu9ll) C1{ Fs:9 Fi:9 FL:9 FL:9}



static void Test_BFs9s_BFs9i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9ll_BFu9ll, BFs9s_BFs9i_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFs9i_BFu9ll_BFu9s  {
  signed short v1:9;
  signed int v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9ll_BFu9s) C1{ Fs:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9ll_BFu9s, BFs9s_BFs9i_BFu9ll_BFu9s)
//============================================================================


struct  BFs9s_BFs9i_BFu9s  {
  signed short v1:9;
  signed int v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9s_BFs9i_BFu9s) C1{ Fs:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9s, BFs9s_BFs9i_BFu9s)
//============================================================================


struct  BFs9s_BFs9i_BFu9s_BFs9i  {
  signed short v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9s_BFs9i) C1{ Fs:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9i_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9s_BFs9i, BFs9s_BFs9i_BFu9s_BFs9i)
//============================================================================


struct  BFs9s_BFs9i_BFu9s_BFs9ll  {
  signed short v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9s_BFs9ll) C1{ Fs:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9i_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9s_BFs9ll, BFs9s_BFs9i_BFu9s_BFs9ll)
//============================================================================


struct  BFs9s_BFs9i_BFu9s_BFs9s  {
  signed short v1:9;
  signed int v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9s_BFs9s) C1{ Fs:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9i_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9s_BFs9s, BFs9s_BFs9i_BFu9s_BFs9s)
//============================================================================


struct  BFs9s_BFs9i_BFu9s_BFu9i  {
  signed short v1:9;
  signed int v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9s_BFu9i) C1{ Fs:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9s_BFu9i, BFs9s_BFs9i_BFu9s_BFu9i)
//============================================================================


struct  BFs9s_BFs9i_BFu9s_BFu9ll  {
  signed short v1:9;
  signed int v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9s_BFu9ll) C1{ Fs:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9s_BFu9ll, BFs9s_BFs9i_BFu9s_BFu9ll)
//============================================================================


struct  BFs9s_BFs9i_BFu9s_BFu9s  {
  signed short v1:9;
  signed int v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9i_BFu9s_BFu9s) C1{ Fs:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9i_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9i_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9i_BFu9s_BFu9s, BFs9s_BFs9i_BFu9s_BFu9s)
//============================================================================


struct  BFs9s_BFs9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
};
//SIG(1 BFs9s_BFs9ll) C1{ Fs:9 FL:9}



static void Test_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll, BFs9s_BFs9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFs9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9i) C1{ Fs:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9i, BFs9s_BFs9ll_BFs9i)
//============================================================================


struct  BFs9s_BFs9ll_BFs9i_BFs9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9i_BFs9i) C1{ Fs:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9i_BFs9i, BFs9s_BFs9ll_BFs9i_BFs9i)
//============================================================================


struct  BFs9s_BFs9ll_BFs9i_BFs9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9i_BFs9ll) C1{ Fs:9 FL:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9ll_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9i_BFs9ll, BFs9s_BFs9ll_BFs9i_BFs9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFs9i_BFs9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9i_BFs9s) C1{ Fs:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9i_BFs9s, BFs9s_BFs9ll_BFs9i_BFs9s)
//============================================================================


struct  BFs9s_BFs9ll_BFs9i_BFu9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9i_BFu9i) C1{ Fs:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9i_BFu9i, BFs9s_BFs9ll_BFs9i_BFu9i)
//============================================================================


struct  BFs9s_BFs9ll_BFs9i_BFu9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9i_BFu9ll) C1{ Fs:9 FL:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9ll_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9i_BFu9ll, BFs9s_BFs9ll_BFs9i_BFu9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFs9i_BFu9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9i_BFu9s) C1{ Fs:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9i_BFu9s, BFs9s_BFs9ll_BFs9i_BFu9s)
//============================================================================


struct  BFs9s_BFs9ll_BFs9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9ll) C1{ Fs:9 FL:9 FL:9}



static void Test_BFs9s_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9ll, BFs9s_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFs9ll_BFs9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9ll_BFs9i) C1{ Fs:9 FL:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9ll_BFs9i, BFs9s_BFs9ll_BFs9ll_BFs9i)
//============================================================================


struct  BFs9s_BFs9ll_BFs9ll_BFs9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9ll_BFs9ll) C1{ Fs:9 FL:9 FL:9 FL:9}



static void Test_BFs9s_BFs9ll_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9ll_BFs9ll, BFs9s_BFs9ll_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFs9ll_BFs9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9ll_BFs9s) C1{ Fs:9 FL:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9ll_BFs9s, BFs9s_BFs9ll_BFs9ll_BFs9s)
//============================================================================


struct  BFs9s_BFs9ll_BFs9ll_BFu9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9ll_BFu9i) C1{ Fs:9 FL:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9ll_BFu9i, BFs9s_BFs9ll_BFs9ll_BFu9i)
//============================================================================


struct  BFs9s_BFs9ll_BFs9ll_BFu9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9ll_BFu9ll) C1{ Fs:9 FL:9 FL:9 FL:9}



static void Test_BFs9s_BFs9ll_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9ll_BFu9ll, BFs9s_BFs9ll_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFs9ll_BFu9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9ll_BFu9s) C1{ Fs:9 FL:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9ll_BFu9s, BFs9s_BFs9ll_BFs9ll_BFu9s)
//============================================================================


struct  BFs9s_BFs9ll_BFs9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9s) C1{ Fs:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9s, BFs9s_BFs9ll_BFs9s)
//============================================================================


struct  BFs9s_BFs9ll_BFs9s_BFs9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9s_BFs9i) C1{ Fs:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9s_BFs9i, BFs9s_BFs9ll_BFs9s_BFs9i)
//============================================================================


struct  BFs9s_BFs9ll_BFs9s_BFs9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9s_BFs9ll) C1{ Fs:9 FL:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9ll_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9s_BFs9ll, BFs9s_BFs9ll_BFs9s_BFs9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFs9s_BFs9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9s_BFs9s) C1{ Fs:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9s_BFs9s, BFs9s_BFs9ll_BFs9s_BFs9s)
//============================================================================


struct  BFs9s_BFs9ll_BFs9s_BFu9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9s_BFu9i) C1{ Fs:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9s_BFu9i, BFs9s_BFs9ll_BFs9s_BFu9i)
//============================================================================


struct  BFs9s_BFs9ll_BFs9s_BFu9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9s_BFu9ll) C1{ Fs:9 FL:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9ll_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9s_BFu9ll, BFs9s_BFs9ll_BFs9s_BFu9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFs9s_BFu9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFs9s_BFu9s) C1{ Fs:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFs9s_BFu9s, BFs9s_BFs9ll_BFs9s_BFu9s)
//============================================================================


struct  BFs9s_BFs9ll_BFu9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9i) C1{ Fs:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9i, BFs9s_BFs9ll_BFu9i)
//============================================================================


struct  BFs9s_BFs9ll_BFu9i_BFs9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9i_BFs9i) C1{ Fs:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9i_BFs9i, BFs9s_BFs9ll_BFu9i_BFs9i)
//============================================================================


struct  BFs9s_BFs9ll_BFu9i_BFs9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9i_BFs9ll) C1{ Fs:9 FL:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9ll_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9i_BFs9ll, BFs9s_BFs9ll_BFu9i_BFs9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFu9i_BFs9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9i_BFs9s) C1{ Fs:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9i_BFs9s, BFs9s_BFs9ll_BFu9i_BFs9s)
//============================================================================


struct  BFs9s_BFs9ll_BFu9i_BFu9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9i_BFu9i) C1{ Fs:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9i_BFu9i, BFs9s_BFs9ll_BFu9i_BFu9i)
//============================================================================


struct  BFs9s_BFs9ll_BFu9i_BFu9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9i_BFu9ll) C1{ Fs:9 FL:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9i_BFu9ll, BFs9s_BFs9ll_BFu9i_BFu9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFu9i_BFu9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9i_BFu9s) C1{ Fs:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9i_BFu9s, BFs9s_BFs9ll_BFu9i_BFu9s)
//============================================================================


struct  BFs9s_BFs9ll_BFu9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9ll) C1{ Fs:9 FL:9 FL:9}



static void Test_BFs9s_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9ll, BFs9s_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFu9ll_BFs9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9ll_BFs9i) C1{ Fs:9 FL:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9ll_BFs9i, BFs9s_BFs9ll_BFu9ll_BFs9i)
//============================================================================


struct  BFs9s_BFs9ll_BFu9ll_BFs9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9ll_BFs9ll) C1{ Fs:9 FL:9 FL:9 FL:9}



static void Test_BFs9s_BFs9ll_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9ll_BFs9ll, BFs9s_BFs9ll_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFu9ll_BFs9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9ll_BFs9s) C1{ Fs:9 FL:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9ll_BFs9s, BFs9s_BFs9ll_BFu9ll_BFs9s)
//============================================================================


struct  BFs9s_BFs9ll_BFu9ll_BFu9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9ll_BFu9i) C1{ Fs:9 FL:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9ll_BFu9i, BFs9s_BFs9ll_BFu9ll_BFu9i)
//============================================================================


struct  BFs9s_BFs9ll_BFu9ll_BFu9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9ll_BFu9ll) C1{ Fs:9 FL:9 FL:9 FL:9}



static void Test_BFs9s_BFs9ll_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9ll_BFu9ll, BFs9s_BFs9ll_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFu9ll_BFu9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9ll_BFu9s) C1{ Fs:9 FL:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9ll_BFu9s, BFs9s_BFs9ll_BFu9ll_BFu9s)
//============================================================================


struct  BFs9s_BFs9ll_BFu9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9s) C1{ Fs:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9s, BFs9s_BFs9ll_BFu9s)
//============================================================================


struct  BFs9s_BFs9ll_BFu9s_BFs9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9s_BFs9i) C1{ Fs:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9s_BFs9i, BFs9s_BFs9ll_BFu9s_BFs9i)
//============================================================================


struct  BFs9s_BFs9ll_BFu9s_BFs9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9s_BFs9ll) C1{ Fs:9 FL:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9ll_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9s_BFs9ll, BFs9s_BFs9ll_BFu9s_BFs9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFu9s_BFs9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9s_BFs9s) C1{ Fs:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9s_BFs9s, BFs9s_BFs9ll_BFu9s_BFs9s)
//============================================================================


struct  BFs9s_BFs9ll_BFu9s_BFu9i  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9s_BFu9i) C1{ Fs:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9ll_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9s_BFu9i, BFs9s_BFs9ll_BFu9s_BFu9i)
//============================================================================


struct  BFs9s_BFs9ll_BFu9s_BFu9ll  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9s_BFu9ll) C1{ Fs:9 FL:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9ll_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9s_BFu9ll, BFs9s_BFs9ll_BFu9s_BFu9ll)
//============================================================================


struct  BFs9s_BFs9ll_BFu9s_BFu9s  {
  signed short v1:9;
  signed __tsi64 v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9ll_BFu9s_BFu9s) C1{ Fs:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9ll_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9ll_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9ll_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9ll_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9ll_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFs9ll_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9ll_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9ll_BFu9s_BFu9s, BFs9s_BFs9ll_BFu9s_BFu9s)
//============================================================================


struct  BFs9s_BFs9s  {
  signed short v1:9;
  signed short v2:9;
};
//SIG(1 BFs9s_BFs9s) C1{ Fs:9 Fs:9}



static void Test_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFs9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s, BFs9s_BFs9s)
//============================================================================


struct  BFs9s_BFs9s_BFs9i  {
  signed short v1:9;
  signed short v2:9;
  signed int v3:9;
};
//SIG(1 BFs9s_BFs9s_BFs9i) C1{ Fs:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9i, BFs9s_BFs9s_BFs9i)
//============================================================================


struct  BFs9s_BFs9s_BFs9i_BFs9i  {
  signed short v1:9;
  signed short v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9i_BFs9i) C1{ Fs:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9s_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9i_BFs9i, BFs9s_BFs9s_BFs9i_BFs9i)
//============================================================================


struct  BFs9s_BFs9s_BFs9i_BFs9ll  {
  signed short v1:9;
  signed short v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9i_BFs9ll) C1{ Fs:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9s_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9i_BFs9ll, BFs9s_BFs9s_BFs9i_BFs9ll)
//============================================================================


struct  BFs9s_BFs9s_BFs9i_BFs9s  {
  signed short v1:9;
  signed short v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9i_BFs9s) C1{ Fs:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9s_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9i_BFs9s, BFs9s_BFs9s_BFs9i_BFs9s)
//============================================================================


struct  BFs9s_BFs9s_BFs9i_BFu9i  {
  signed short v1:9;
  signed short v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9i_BFu9i) C1{ Fs:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9s_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9i_BFu9i, BFs9s_BFs9s_BFs9i_BFu9i)
//============================================================================


struct  BFs9s_BFs9s_BFs9i_BFu9ll  {
  signed short v1:9;
  signed short v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9i_BFu9ll) C1{ Fs:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9s_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9i_BFu9ll, BFs9s_BFs9s_BFs9i_BFu9ll)
//============================================================================


struct  BFs9s_BFs9s_BFs9i_BFu9s  {
  signed short v1:9;
  signed short v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9i_BFu9s) C1{ Fs:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9s_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9s_BFs9s_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9i_BFu9s, BFs9s_BFs9s_BFs9i_BFu9s)
//============================================================================


struct  BFs9s_BFs9s_BFs9ll  {
  signed short v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9s_BFs9s_BFs9ll) C1{ Fs:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9ll, BFs9s_BFs9s_BFs9ll)
//============================================================================


struct  BFs9s_BFs9s_BFs9ll_BFs9i  {
  signed short v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9ll_BFs9i) C1{ Fs:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9s_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9ll_BFs9i, BFs9s_BFs9s_BFs9ll_BFs9i)
//============================================================================


struct  BFs9s_BFs9s_BFs9ll_BFs9ll  {
  signed short v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9ll_BFs9ll) C1{ Fs:9 Fs:9 FL:9 FL:9}



static void Test_BFs9s_BFs9s_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9ll_BFs9ll, BFs9s_BFs9s_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFs9s_BFs9ll_BFs9s  {
  signed short v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9ll_BFs9s) C1{ Fs:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9s_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9ll_BFs9s, BFs9s_BFs9s_BFs9ll_BFs9s)
//============================================================================


struct  BFs9s_BFs9s_BFs9ll_BFu9i  {
  signed short v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9ll_BFu9i) C1{ Fs:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9s_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9ll_BFu9i, BFs9s_BFs9s_BFs9ll_BFu9i)
//============================================================================


struct  BFs9s_BFs9s_BFs9ll_BFu9ll  {
  signed short v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9ll_BFu9ll) C1{ Fs:9 Fs:9 FL:9 FL:9}



static void Test_BFs9s_BFs9s_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9ll_BFu9ll, BFs9s_BFs9s_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFs9s_BFs9ll_BFu9s  {
  signed short v1:9;
  signed short v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9ll_BFu9s) C1{ Fs:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9s_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9ll_BFu9s, BFs9s_BFs9s_BFs9ll_BFu9s)
//============================================================================


struct  BFs9s_BFs9s_BFs9s  {
  signed short v1:9;
  signed short v2:9;
  signed short v3:9;
};
//SIG(1 BFs9s_BFs9s_BFs9s) C1{ Fs:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9s lv;
    check2(sizeof(lv), 6, "sizeof(BFs9s_BFs9s_BFs9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs9s_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9s, BFs9s_BFs9s_BFs9s)
//============================================================================


struct  BFs9s_BFs9s_BFs9s_BFs9i  {
  signed short v1:9;
  signed short v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9s_BFs9i) C1{ Fs:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9s_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9s_BFs9i, BFs9s_BFs9s_BFs9s_BFs9i)
//============================================================================


struct  BFs9s_BFs9s_BFs9s_BFs9ll  {
  signed short v1:9;
  signed short v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9s_BFs9ll) C1{ Fs:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9s_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9s_BFs9ll, BFs9s_BFs9s_BFs9s_BFs9ll)
//============================================================================


struct  BFs9s_BFs9s_BFs9s_BFs9s  {
  signed short v1:9;
  signed short v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9s_BFs9s) C1{ Fs:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9s_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9s_BFs9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs9s_BFs9s_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9s_BFs9s, BFs9s_BFs9s_BFs9s_BFs9s)
//============================================================================


struct  BFs9s_BFs9s_BFs9s_BFu9i  {
  signed short v1:9;
  signed short v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9s_BFu9i) C1{ Fs:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9s_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9s_BFu9i, BFs9s_BFs9s_BFs9s_BFu9i)
//============================================================================


struct  BFs9s_BFs9s_BFs9s_BFu9ll  {
  signed short v1:9;
  signed short v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9s_BFu9ll) C1{ Fs:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9s_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9s_BFu9ll, BFs9s_BFs9s_BFs9s_BFu9ll)
//============================================================================


struct  BFs9s_BFs9s_BFs9s_BFu9s  {
  signed short v1:9;
  signed short v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFs9s_BFu9s) C1{ Fs:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9s_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFs9s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs9s_BFs9s_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9s_BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFs9s_BFu9s, BFs9s_BFs9s_BFs9s_BFu9s)
//============================================================================


struct  BFs9s_BFs9s_BFu9i  {
  signed short v1:9;
  signed short v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9s_BFs9s_BFu9i) C1{ Fs:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9i, BFs9s_BFs9s_BFu9i)
//============================================================================


struct  BFs9s_BFs9s_BFu9i_BFs9i  {
  signed short v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9i_BFs9i) C1{ Fs:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9s_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9i_BFs9i, BFs9s_BFs9s_BFu9i_BFs9i)
//============================================================================


struct  BFs9s_BFs9s_BFu9i_BFs9ll  {
  signed short v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9i_BFs9ll) C1{ Fs:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9s_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9i_BFs9ll, BFs9s_BFs9s_BFu9i_BFs9ll)
//============================================================================


struct  BFs9s_BFs9s_BFu9i_BFs9s  {
  signed short v1:9;
  signed short v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9i_BFs9s) C1{ Fs:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9s_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9i_BFs9s, BFs9s_BFs9s_BFu9i_BFs9s)
//============================================================================


struct  BFs9s_BFs9s_BFu9i_BFu9i  {
  signed short v1:9;
  signed short v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9i_BFu9i) C1{ Fs:9 Fs:9 Fi:9 Fi:9}



static void Test_BFs9s_BFs9s_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9i_BFu9i, BFs9s_BFs9s_BFu9i_BFu9i)
//============================================================================


struct  BFs9s_BFs9s_BFu9i_BFu9ll  {
  signed short v1:9;
  signed short v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9i_BFu9ll) C1{ Fs:9 Fs:9 Fi:9 FL:9}



static void Test_BFs9s_BFs9s_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9i_BFu9ll, BFs9s_BFs9s_BFu9i_BFu9ll)
//============================================================================


struct  BFs9s_BFs9s_BFu9i_BFu9s  {
  signed short v1:9;
  signed short v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9i_BFu9s) C1{ Fs:9 Fs:9 Fi:9 Fs:9}



static void Test_BFs9s_BFs9s_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9s_BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9i_BFu9s, BFs9s_BFs9s_BFu9i_BFu9s)
//============================================================================


struct  BFs9s_BFs9s_BFu9ll  {
  signed short v1:9;
  signed short v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9s_BFs9s_BFu9ll) C1{ Fs:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9ll, BFs9s_BFs9s_BFu9ll)
//============================================================================


struct  BFs9s_BFs9s_BFu9ll_BFs9i  {
  signed short v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9ll_BFs9i) C1{ Fs:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9s_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9ll_BFs9i, BFs9s_BFs9s_BFu9ll_BFs9i)
//============================================================================


struct  BFs9s_BFs9s_BFu9ll_BFs9ll  {
  signed short v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9ll_BFs9ll) C1{ Fs:9 Fs:9 FL:9 FL:9}



static void Test_BFs9s_BFs9s_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9ll_BFs9ll, BFs9s_BFs9s_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFs9s_BFu9ll_BFs9s  {
  signed short v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9ll_BFs9s) C1{ Fs:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9s_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9ll_BFs9s, BFs9s_BFs9s_BFu9ll_BFs9s)
//============================================================================


struct  BFs9s_BFs9s_BFu9ll_BFu9i  {
  signed short v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9ll_BFu9i) C1{ Fs:9 Fs:9 FL:9 Fi:9}



static void Test_BFs9s_BFs9s_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9ll_BFu9i, BFs9s_BFs9s_BFu9ll_BFu9i)
//============================================================================


struct  BFs9s_BFs9s_BFu9ll_BFu9ll  {
  signed short v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9ll_BFu9ll) C1{ Fs:9 Fs:9 FL:9 FL:9}



static void Test_BFs9s_BFs9s_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9ll_BFu9ll, BFs9s_BFs9s_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFs9s_BFu9ll_BFu9s  {
  signed short v1:9;
  signed short v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9ll_BFu9s) C1{ Fs:9 Fs:9 FL:9 Fs:9}



static void Test_BFs9s_BFs9s_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, 1, "BFs9s_BFs9s_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 2, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9ll_BFu9s, BFs9s_BFs9s_BFu9ll_BFu9s)
//============================================================================


struct  BFs9s_BFs9s_BFu9s  {
  signed short v1:9;
  signed short v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9s_BFs9s_BFu9s) C1{ Fs:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFs9s_BFs9s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs9s_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9s, BFs9s_BFs9s_BFu9s)
//============================================================================


struct  BFs9s_BFs9s_BFu9s_BFs9i  {
  signed short v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9s_BFs9i) C1{ Fs:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9s_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9s_BFs9i, BFs9s_BFs9s_BFu9s_BFs9i)
//============================================================================


struct  BFs9s_BFs9s_BFu9s_BFs9ll  {
  signed short v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9s_BFs9ll) C1{ Fs:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9s_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9s_BFs9ll, BFs9s_BFs9s_BFu9s_BFs9ll)
//============================================================================


struct  BFs9s_BFs9s_BFu9s_BFs9s  {
  signed short v1:9;
  signed short v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9s_BFs9s) C1{ Fs:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9s_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9s_BFs9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs9s_BFs9s_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9s_BFs9s, BFs9s_BFs9s_BFu9s_BFs9s)
//============================================================================


struct  BFs9s_BFs9s_BFu9s_BFu9i  {
  signed short v1:9;
  signed short v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9s_BFu9i) C1{ Fs:9 Fs:9 Fs:9 Fi:9}



static void Test_BFs9s_BFs9s_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFs9s_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9s_BFu9i, BFs9s_BFs9s_BFu9s_BFu9i)
//============================================================================


struct  BFs9s_BFs9s_BFu9s_BFu9ll  {
  signed short v1:9;
  signed short v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9s_BFu9ll) C1{ Fs:9 Fs:9 Fs:9 FL:9}



static void Test_BFs9s_BFs9s_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFs9s_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 5, 1, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9s_BFu9ll, BFs9s_BFs9s_BFu9s_BFu9ll)
//============================================================================


struct  BFs9s_BFs9s_BFu9s_BFu9s  {
  signed short v1:9;
  signed short v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFs9s_BFu9s_BFu9s) C1{ Fs:9 Fs:9 Fs:9 Fs:9}



static void Test_BFs9s_BFs9s_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFs9s_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFs9s_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFs9s_BFu9s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs9s_BFs9s_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_sll(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, 1, "BFs9s_BFs9s_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 6, 0, 9, hide_ull(1LL<<8), "BFs9s_BFs9s_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFs9s_BFu9s_BFu9s, BFs9s_BFs9s_BFu9s_BFu9s)
//============================================================================


struct  BFs9s_BFu9i  {
  signed short v1:9;
  unsigned int v2:9;
};
//SIG(1 BFs9s_BFu9i) C1{ Fs:9 Fi:9}



static void Test_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i, BFs9s_BFu9i)
//============================================================================


struct  BFs9s_BFu9i_BFs9i  {
  signed short v1:9;
  unsigned int v2:9;
  signed int v3:9;
};
//SIG(1 BFs9s_BFu9i_BFs9i) C1{ Fs:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9i, BFs9s_BFu9i_BFs9i)
//============================================================================


struct  BFs9s_BFu9i_BFs9i_BFs9i  {
  signed short v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9i_BFs9i) C1{ Fs:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9i_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9i_BFs9i, BFs9s_BFu9i_BFs9i_BFs9i)
//============================================================================


struct  BFs9s_BFu9i_BFs9i_BFs9ll  {
  signed short v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9i_BFs9ll) C1{ Fs:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9i_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9i_BFs9ll, BFs9s_BFu9i_BFs9i_BFs9ll)
//============================================================================


struct  BFs9s_BFu9i_BFs9i_BFs9s  {
  signed short v1:9;
  unsigned int v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9i_BFs9s) C1{ Fs:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9i_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9i_BFs9s, BFs9s_BFu9i_BFs9i_BFs9s)
//============================================================================


struct  BFs9s_BFu9i_BFs9i_BFu9i  {
  signed short v1:9;
  unsigned int v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9i_BFu9i) C1{ Fs:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9i_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9i_BFu9i, BFs9s_BFu9i_BFs9i_BFu9i)
//============================================================================


struct  BFs9s_BFu9i_BFs9i_BFu9ll  {
  signed short v1:9;
  unsigned int v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9i_BFu9ll) C1{ Fs:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9i_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9i_BFu9ll, BFs9s_BFu9i_BFs9i_BFu9ll)
//============================================================================


struct  BFs9s_BFu9i_BFs9i_BFu9s  {
  signed short v1:9;
  unsigned int v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9i_BFu9s) C1{ Fs:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9i_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9i_BFu9s, BFs9s_BFu9i_BFs9i_BFu9s)
//============================================================================


struct  BFs9s_BFu9i_BFs9ll  {
  signed short v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9s_BFu9i_BFs9ll) C1{ Fs:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9ll, BFs9s_BFu9i_BFs9ll)
//============================================================================


struct  BFs9s_BFu9i_BFs9ll_BFs9i  {
  signed short v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9ll_BFs9i) C1{ Fs:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9i_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9ll_BFs9i, BFs9s_BFu9i_BFs9ll_BFs9i)
//============================================================================


struct  BFs9s_BFu9i_BFs9ll_BFs9ll  {
  signed short v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9ll_BFs9ll) C1{ Fs:9 Fi:9 FL:9 FL:9}



static void Test_BFs9s_BFu9i_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9ll_BFs9ll, BFs9s_BFu9i_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFu9i_BFs9ll_BFs9s  {
  signed short v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9ll_BFs9s) C1{ Fs:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9s_BFu9i_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9ll_BFs9s, BFs9s_BFu9i_BFs9ll_BFs9s)
//============================================================================


struct  BFs9s_BFu9i_BFs9ll_BFu9i  {
  signed short v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9ll_BFu9i) C1{ Fs:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9i_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9ll_BFu9i, BFs9s_BFu9i_BFs9ll_BFu9i)
//============================================================================


struct  BFs9s_BFu9i_BFs9ll_BFu9ll  {
  signed short v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9ll_BFu9ll) C1{ Fs:9 Fi:9 FL:9 FL:9}



static void Test_BFs9s_BFu9i_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9ll_BFu9ll, BFs9s_BFu9i_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFu9i_BFs9ll_BFu9s  {
  signed short v1:9;
  unsigned int v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9ll_BFu9s) C1{ Fs:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9s_BFu9i_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9ll_BFu9s, BFs9s_BFu9i_BFs9ll_BFu9s)
//============================================================================


struct  BFs9s_BFu9i_BFs9s  {
  signed short v1:9;
  unsigned int v2:9;
  signed short v3:9;
};
//SIG(1 BFs9s_BFu9i_BFs9s) C1{ Fs:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9s, BFs9s_BFu9i_BFs9s)
//============================================================================


struct  BFs9s_BFu9i_BFs9s_BFs9i  {
  signed short v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9s_BFs9i) C1{ Fs:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9s_BFu9i_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9s_BFs9i, BFs9s_BFu9i_BFs9s_BFs9i)
//============================================================================


struct  BFs9s_BFu9i_BFs9s_BFs9ll  {
  signed short v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9s_BFs9ll) C1{ Fs:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9s_BFu9i_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9s_BFs9ll, BFs9s_BFu9i_BFs9s_BFs9ll)
//============================================================================


struct  BFs9s_BFu9i_BFs9s_BFs9s  {
  signed short v1:9;
  unsigned int v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9s_BFs9s) C1{ Fs:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9s_BFu9i_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9s_BFs9s, BFs9s_BFu9i_BFs9s_BFs9s)
//============================================================================


struct  BFs9s_BFu9i_BFs9s_BFu9i  {
  signed short v1:9;
  unsigned int v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9s_BFu9i) C1{ Fs:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9s_BFu9i_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9s_BFu9i, BFs9s_BFu9i_BFs9s_BFu9i)
//============================================================================


struct  BFs9s_BFu9i_BFs9s_BFu9ll  {
  signed short v1:9;
  unsigned int v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9s_BFu9ll) C1{ Fs:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9s_BFu9i_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9s_BFu9ll, BFs9s_BFu9i_BFs9s_BFu9ll)
//============================================================================


struct  BFs9s_BFu9i_BFs9s_BFu9s  {
  signed short v1:9;
  unsigned int v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFs9s_BFu9s) C1{ Fs:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9s_BFu9i_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFs9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFs9s_BFu9s, BFs9s_BFu9i_BFs9s_BFu9s)
//============================================================================


struct  BFs9s_BFu9i_BFu9i  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9s_BFu9i_BFu9i) C1{ Fs:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9i, BFs9s_BFu9i_BFu9i)
//============================================================================


struct  BFs9s_BFu9i_BFu9i_BFs9i  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9i_BFs9i) C1{ Fs:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9i_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9i_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9i_BFs9i, BFs9s_BFu9i_BFu9i_BFs9i)
//============================================================================


struct  BFs9s_BFu9i_BFu9i_BFs9ll  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9i_BFs9ll) C1{ Fs:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9i_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9i_BFs9ll, BFs9s_BFu9i_BFu9i_BFs9ll)
//============================================================================


struct  BFs9s_BFu9i_BFu9i_BFs9s  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9i_BFs9s) C1{ Fs:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9i_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9i_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9i_BFs9s, BFs9s_BFu9i_BFu9i_BFs9s)
//============================================================================


struct  BFs9s_BFu9i_BFu9i_BFu9i  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9i_BFu9i) C1{ Fs:9 Fi:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9i_BFu9i, BFs9s_BFu9i_BFu9i_BFu9i)
//============================================================================


struct  BFs9s_BFu9i_BFu9i_BFu9ll  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9i_BFu9ll) C1{ Fs:9 Fi:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9i_BFu9ll, BFs9s_BFu9i_BFu9i_BFu9ll)
//============================================================================


struct  BFs9s_BFu9i_BFu9i_BFu9s  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9i_BFu9s) C1{ Fs:9 Fi:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9i_BFu9s, BFs9s_BFu9i_BFu9i_BFu9s)
//============================================================================


struct  BFs9s_BFu9i_BFu9ll  {
  signed short v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9s_BFu9i_BFu9ll) C1{ Fs:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9ll, BFs9s_BFu9i_BFu9ll)
//============================================================================


struct  BFs9s_BFu9i_BFu9ll_BFs9i  {
  signed short v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9ll_BFs9i) C1{ Fs:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9i_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9ll_BFs9i, BFs9s_BFu9i_BFu9ll_BFs9i)
//============================================================================


struct  BFs9s_BFu9i_BFu9ll_BFs9ll  {
  signed short v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9ll_BFs9ll) C1{ Fs:9 Fi:9 FL:9 FL:9}



static void Test_BFs9s_BFu9i_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9ll_BFs9ll, BFs9s_BFu9i_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFu9i_BFu9ll_BFs9s  {
  signed short v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9ll_BFs9s) C1{ Fs:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9s_BFu9i_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9ll_BFs9s, BFs9s_BFu9i_BFu9ll_BFs9s)
//============================================================================


struct  BFs9s_BFu9i_BFu9ll_BFu9i  {
  signed short v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9ll_BFu9i) C1{ Fs:9 Fi:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9ll_BFu9i, BFs9s_BFu9i_BFu9ll_BFu9i)
//============================================================================


struct  BFs9s_BFu9i_BFu9ll_BFu9ll  {
  signed short v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9ll_BFu9ll) C1{ Fs:9 Fi:9 FL:9 FL:9}



static void Test_BFs9s_BFu9i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9ll_BFu9ll, BFs9s_BFu9i_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFu9i_BFu9ll_BFu9s  {
  signed short v1:9;
  unsigned int v2:9;
  __tsu64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9ll_BFu9s) C1{ Fs:9 Fi:9 FL:9 Fs:9}



static void Test_BFs9s_BFu9i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9ll_BFu9s, BFs9s_BFu9i_BFu9ll_BFu9s)
//============================================================================


struct  BFs9s_BFu9i_BFu9s  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 BFs9s_BFu9i_BFu9s) C1{ Fs:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFs9s_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9s, BFs9s_BFu9i_BFu9s)
//============================================================================


struct  BFs9s_BFu9i_BFu9s_BFs9i  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9s_BFs9i) C1{ Fs:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9s_BFu9i_BFu9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9s_BFs9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9s_BFs9i, BFs9s_BFu9i_BFu9s_BFs9i)
//============================================================================


struct  BFs9s_BFu9i_BFu9s_BFs9ll  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9s_BFs9ll) C1{ Fs:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9s_BFu9i_BFu9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9s_BFs9ll, BFs9s_BFu9i_BFu9s_BFs9ll)
//============================================================================


struct  BFs9s_BFu9i_BFu9s_BFs9s  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9s_BFs9s) C1{ Fs:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9s_BFu9i_BFu9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9s_BFs9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9s_BFs9s, BFs9s_BFu9i_BFu9s_BFs9s)
//============================================================================


struct  BFs9s_BFu9i_BFu9s_BFu9i  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9s_BFu9i) C1{ Fs:9 Fi:9 Fs:9 Fi:9}



static void Test_BFs9s_BFu9i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9s_BFu9i, BFs9s_BFu9i_BFu9s_BFu9i)
//============================================================================


struct  BFs9s_BFu9i_BFu9s_BFu9ll  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9s_BFu9ll) C1{ Fs:9 Fi:9 Fs:9 FL:9}



static void Test_BFs9s_BFu9i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9s_BFu9ll, BFs9s_BFu9i_BFu9s_BFu9ll)
//============================================================================


struct  BFs9s_BFu9i_BFu9s_BFu9s  {
  signed short v1:9;
  unsigned int v2:9;
  unsigned short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9i_BFu9s_BFu9s) C1{ Fs:9 Fi:9 Fs:9 Fs:9}



static void Test_BFs9s_BFu9i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9i_BFu9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9i_BFu9s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs9s_BFu9i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9i_BFu9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9i_BFu9s_BFu9s, BFs9s_BFu9i_BFu9s_BFu9s)
//============================================================================


struct  BFs9s_BFu9ll  {
  signed short v1:9;
  __tsu64 v2:9;
};
//SIG(1 BFs9s_BFu9ll) C1{ Fs:9 FL:9}



static void Test_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll, BFs9s_BFu9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFs9i  {
  signed short v1:9;
  __tsu64 v2:9;
  signed int v3:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9i) C1{ Fs:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9i, BFs9s_BFu9ll_BFs9i)
//============================================================================


struct  BFs9s_BFu9ll_BFs9i_BFs9i  {
  signed short v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9i_BFs9i) C1{ Fs:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFs9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9i_BFs9i, BFs9s_BFu9ll_BFs9i_BFs9i)
//============================================================================


struct  BFs9s_BFu9ll_BFs9i_BFs9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9i_BFs9ll) C1{ Fs:9 FL:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9ll_BFs9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9i_BFs9ll, BFs9s_BFu9ll_BFs9i_BFs9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFs9i_BFs9s  {
  signed short v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9i_BFs9s) C1{ Fs:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFs9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9i_BFs9s, BFs9s_BFu9ll_BFs9i_BFs9s)
//============================================================================


struct  BFs9s_BFu9ll_BFs9i_BFu9i  {
  signed short v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9i_BFu9i) C1{ Fs:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFs9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9i_BFu9i, BFs9s_BFu9ll_BFs9i_BFu9i)
//============================================================================


struct  BFs9s_BFu9ll_BFs9i_BFu9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9i_BFu9ll) C1{ Fs:9 FL:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9ll_BFs9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9i_BFu9ll, BFs9s_BFu9ll_BFs9i_BFu9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFs9i_BFu9s  {
  signed short v1:9;
  __tsu64 v2:9;
  signed int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9i_BFu9s) C1{ Fs:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFs9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9i_BFu9s, BFs9s_BFu9ll_BFs9i_BFu9s)
//============================================================================


struct  BFs9s_BFu9ll_BFs9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9ll) C1{ Fs:9 FL:9 FL:9}



static void Test_BFs9s_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9ll, BFs9s_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFs9ll_BFs9i  {
  signed short v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9ll_BFs9i) C1{ Fs:9 FL:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFs9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9ll_BFs9i, BFs9s_BFu9ll_BFs9ll_BFs9i)
//============================================================================


struct  BFs9s_BFu9ll_BFs9ll_BFs9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9ll_BFs9ll) C1{ Fs:9 FL:9 FL:9 FL:9}



static void Test_BFs9s_BFu9ll_BFs9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9ll_BFs9ll, BFs9s_BFu9ll_BFs9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFs9ll_BFs9s  {
  signed short v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9ll_BFs9s) C1{ Fs:9 FL:9 FL:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFs9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9ll_BFs9s, BFs9s_BFu9ll_BFs9ll_BFs9s)
//============================================================================


struct  BFs9s_BFu9ll_BFs9ll_BFu9i  {
  signed short v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9ll_BFu9i) C1{ Fs:9 FL:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFs9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9ll_BFu9i, BFs9s_BFu9ll_BFs9ll_BFu9i)
//============================================================================


struct  BFs9s_BFu9ll_BFs9ll_BFu9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9ll_BFu9ll) C1{ Fs:9 FL:9 FL:9 FL:9}



static void Test_BFs9s_BFu9ll_BFs9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9ll_BFu9ll, BFs9s_BFu9ll_BFs9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFs9ll_BFu9s  {
  signed short v1:9;
  __tsu64 v2:9;
  signed __tsi64 v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9ll_BFu9s) C1{ Fs:9 FL:9 FL:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFs9ll_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9ll_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9ll_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9ll_BFu9s, BFs9s_BFu9ll_BFs9ll_BFu9s)
//============================================================================


struct  BFs9s_BFu9ll_BFs9s  {
  signed short v1:9;
  __tsu64 v2:9;
  signed short v3:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9s) C1{ Fs:9 FL:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9s, BFs9s_BFu9ll_BFs9s)
//============================================================================


struct  BFs9s_BFu9ll_BFs9s_BFs9i  {
  signed short v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9s_BFs9i) C1{ Fs:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFs9s_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9s_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9s_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9s_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9s_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9s_BFs9i, BFs9s_BFu9ll_BFs9s_BFs9i)
//============================================================================


struct  BFs9s_BFu9ll_BFs9s_BFs9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9s_BFs9ll) C1{ Fs:9 FL:9 Fs:9 FL:9}



static void Test_BFs9s_BFu9ll_BFs9s_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9s_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9s_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9s_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9s_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9s_BFs9ll, BFs9s_BFu9ll_BFs9s_BFs9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFs9s_BFs9s  {
  signed short v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9s_BFs9s) C1{ Fs:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFs9s_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9s_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9s_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9s_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9s_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9s_BFs9s, BFs9s_BFu9ll_BFs9s_BFs9s)
//============================================================================


struct  BFs9s_BFu9ll_BFs9s_BFu9i  {
  signed short v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9s_BFu9i) C1{ Fs:9 FL:9 Fs:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFs9s_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9s_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9s_BFu9i, BFs9s_BFu9ll_BFs9s_BFu9i)
//============================================================================


struct  BFs9s_BFu9ll_BFs9s_BFu9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9s_BFu9ll) C1{ Fs:9 FL:9 Fs:9 FL:9}



static void Test_BFs9s_BFu9ll_BFs9s_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9s_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9s_BFu9ll, BFs9s_BFu9ll_BFs9s_BFu9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFs9s_BFu9s  {
  signed short v1:9;
  __tsu64 v2:9;
  signed short v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFs9s_BFu9s) C1{ Fs:9 FL:9 Fs:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFs9s_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFs9s_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFs9s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFs9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFs9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFs9s_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFs9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFs9s_BFu9s, BFs9s_BFu9ll_BFs9s_BFu9s)
//============================================================================


struct  BFs9s_BFu9ll_BFu9i  {
  signed short v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9i) C1{ Fs:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9i, BFs9s_BFu9ll_BFu9i)
//============================================================================


struct  BFs9s_BFu9ll_BFu9i_BFs9i  {
  signed short v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9i_BFs9i) C1{ Fs:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFu9i_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9i_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9i_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9i_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9i_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9i_BFs9i, BFs9s_BFu9ll_BFu9i_BFs9i)
//============================================================================


struct  BFs9s_BFu9ll_BFu9i_BFs9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9i_BFs9ll) C1{ Fs:9 FL:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9ll_BFu9i_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9i_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9i_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9i_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9i_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9i_BFs9ll, BFs9s_BFu9ll_BFu9i_BFs9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFu9i_BFs9s  {
  signed short v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9i_BFs9s) C1{ Fs:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFu9i_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9i_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9i_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9i_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9i_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFs9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFs9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9i_BFs9s, BFs9s_BFu9ll_BFu9i_BFs9s)
//============================================================================


struct  BFs9s_BFu9ll_BFu9i_BFu9i  {
  signed short v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  unsigned int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9i_BFu9i) C1{ Fs:9 FL:9 Fi:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFu9i_BFu9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9i_BFu9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9i_BFu9i, BFs9s_BFu9ll_BFu9i_BFu9i)
//============================================================================


struct  BFs9s_BFu9ll_BFu9i_BFu9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  __tsu64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9i_BFu9ll) C1{ Fs:9 FL:9 Fi:9 FL:9}



static void Test_BFs9s_BFu9ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9i_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9i_BFu9ll, BFs9s_BFu9ll_BFu9i_BFu9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFu9i_BFu9s  {
  signed short v1:9;
  __tsu64 v2:9;
  unsigned int v3:9;
  unsigned short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9i_BFu9s) C1{ Fs:9 FL:9 Fi:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFu9i_BFu9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9i_BFu9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9i_BFu9s, BFs9s_BFu9ll_BFu9i_BFu9s)
//============================================================================


struct  BFs9s_BFu9ll_BFu9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9ll) C1{ Fs:9 FL:9 FL:9}



static void Test_BFs9s_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs9s_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9ll, BFs9s_BFu9ll_BFu9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFu9ll_BFs9i  {
  signed short v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed int v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9ll_BFs9i) C1{ Fs:9 FL:9 FL:9 Fi:9}



static void Test_BFs9s_BFu9ll_BFu9ll_BFs9i()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9ll_BFs9i");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9ll_BFs9i lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9ll_BFs9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9ll_BFs9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9i");
    set_bf_and_test(lv, v4, 4, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9ll_BFs9i, BFs9s_BFu9ll_BFu9ll_BFs9i)
//============================================================================


struct  BFs9s_BFu9ll_BFu9ll_BFs9ll  {
  signed short v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed __tsi64 v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9ll_BFs9ll) C1{ Fs:9 FL:9 FL:9 FL:9}



static void Test_BFs9s_BFu9ll_BFu9ll_BFs9ll()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9ll_BFs9ll");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9ll_BFs9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9ll_BFs9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9ll_BFs9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v3, 2, 2, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9ll");
    set_bf_and_test(lv, v4, 3, 3, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs9s_BFu9ll_BFu9ll_BFs9ll, BFs9s_BFu9ll_BFu9ll_BFs9ll)
//============================================================================


struct  BFs9s_BFu9ll_BFu9ll_BFs9s  {
  signed short v1:9;
  __tsu64 v2:9;
  __tsu64 v3:9;
  signed short v4:9;
};
//SIG(1 BFs9s_BFu9ll_BFu9ll_BFs9s) C1{ Fs:9 FL:9 FL:9 Fs:9}



static void Test_BFs9s_BFu9ll_BFu9ll_BFs9s()
{
  {
    init_simple_test("BFs9s_BFu9ll_BFu9ll_BFs9s");
    static STRUCT_IF_C BFs9s_BFu9ll_BFu9ll_BFs9s lv;
    check2(sizeof(lv), 8, "sizeof(BFs9s_BFu9ll_BFu9ll_BFs9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs9s_BFu9ll_BFu9ll_BFs9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_sll(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFs9s_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9, 1, "BFs9s_BFu9ll_BFu9ll_BFs9s");
    set_bf_and_test(lv, v3, 2, 2, 9,